/*
 * Decompiled with CFR 0.152.
 */
package org.openide.execution;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.execution.ExecutionEngine;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.windows.InputOutput;

public class NbClassLoader
extends URLClassLoader {
    protected InputOutput inout;
    private HashMap permissionCollections;
    private PermissionCollection defaultPermissions;
    private final boolean fast;
    static ThreadLocal<Boolean> f = new ThreadLocal();

    private static ClassLoader systemClassLoader() {
        return (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
    }

    public NbClassLoader() {
        super(new URL[0], NbClassLoader.systemClassLoader());
        this.fast = false;
    }

    public NbClassLoader(InputOutput inputOutput) {
        super(new URL[0], NbClassLoader.systemClassLoader());
        this.fast = false;
        this.inout = inputOutput;
    }

    public NbClassLoader(FileObject[] fileObjectArray, ClassLoader classLoader, InputOutput inputOutput) {
        super(NbClassLoader.createRootURLs(fileObjectArray), classLoader);
        this.fast = NbClassLoader.canOptimize(this.getURLs());
        this.inout = inputOutput;
    }

    public NbClassLoader(FileSystem[] fileSystemArray) {
        super(new URL[0], NbClassLoader.systemClassLoader(), null);
        this.fast = false;
        Thread.dumpStack();
    }

    public NbClassLoader(FileSystem[] fileSystemArray, ClassLoader classLoader) {
        super(new URL[0], classLoader);
        this.fast = false;
        Thread.dumpStack();
    }

    @Override
    public URL getResource(String string) {
        return super.getResource(string.startsWith("/") ? string.substring(1) : string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class findClass(String string) throws ClassNotFoundException {
        if (!this.fast && string.indexOf(46) != -1) {
            Logger.getLogger(NbClassLoader.class.getName()).log(Level.FINE, "NBFS used!");
            String string2 = string.substring(0, string.lastIndexOf(46));
            if (this.getPackage(string2) == null) {
                String string3 = string.replace('.', '/') + ".class";
                URL[] uRLArray = this.getURLs();
                for (int i = 0; i < uRLArray.length; ++i) {
                    FileObject fileObject = URLMapper.findFileObject((URL)uRLArray[i]);
                    if (fileObject == null) continue;
                    try {
                        FileObject fileObject2 = fileObject.getFileObject(string3);
                        if (fileObject2 == null) continue;
                        FileObject fileObject3 = fileObject.getFileObject("META-INF/MANIFEST.MF");
                        if (fileObject3 == null) {
                            fileObject3 = fileObject.getFileObject("meta-inf/manifest.mf");
                        }
                        if (fileObject3 == null) break;
                        Manifest manifest = new Manifest();
                        try (InputStream inputStream = fileObject3.getInputStream();){
                            manifest.read(inputStream);
                        }
                        this.definePackage(string2, manifest, uRLArray[i]);
                        break;
                    }
                    catch (IOException iOException) {
                        Exceptions.attachLocalizedMessage((Throwable)iOException, (String)uRLArray[i].toString());
                        Exceptions.printStackTrace((Throwable)iOException);
                    }
                }
            }
        }
        return super.findClass(string);
    }

    public void setDefaultPermissions(PermissionCollection permissionCollection) {
        if (permissionCollection != null && !permissionCollection.isReadOnly()) {
            permissionCollection.setReadOnly();
        }
        this.defaultPermissions = permissionCollection;
    }

    @Override
    protected final synchronized PermissionCollection getPermissions(CodeSource codeSource) {
        PermissionCollection permissionCollection;
        if (this.permissionCollections != null && (permissionCollection = (PermissionCollection)this.permissionCollections.get(codeSource)) != null) {
            return permissionCollection;
        }
        return this.createPermissions(codeSource, this.inout);
    }

    private PermissionCollection createPermissions(CodeSource codeSource, InputOutput inputOutput) {
        PermissionCollection permissionCollection;
        if (inputOutput == null) {
            permissionCollection = this.defaultPermissions != null ? this.defaultPermissions : super.getPermissions(codeSource);
        } else {
            ExecutionEngine executionEngine = ExecutionEngine.getDefault();
            permissionCollection = executionEngine.createPermissions(codeSource, inputOutput);
            if (this.defaultPermissions != null) {
                NbClassLoader.addAllPermissions(permissionCollection, this.defaultPermissions);
            } else {
                permissionCollection.add(new AllPermission());
            }
        }
        if (this.permissionCollections == null) {
            this.permissionCollections = new HashMap(7);
        }
        this.permissionCollections.put(codeSource, permissionCollection);
        return permissionCollection;
    }

    private static void addAllPermissions(PermissionCollection permissionCollection, PermissionCollection permissionCollection2) {
        Enumeration<Permission> enumeration = permissionCollection2.elements();
        while (enumeration.hasMoreElements()) {
            permissionCollection.add(enumeration.nextElement());
        }
    }

    private static URL[] createRootURLs(FileObject[] fileObjectArray) {
        URL[] uRLArray = new URL[fileObjectArray.length];
        for (int i = 0; i < fileObjectArray.length; ++i) {
            uRLArray[i] = fileObjectArray[i].toURL();
        }
        return uRLArray;
    }

    private static boolean canOptimize(URL[] uRLArray) {
        assert (uRLArray != null);
        for (int i = 0; i < uRLArray.length; ++i) {
            URL uRL = uRLArray[i];
            URL uRL2 = FileUtil.getArchiveFile((URL)uRL);
            if (uRL2 != null) {
                if (!uRL.toExternalForm().endsWith("!/")) {
                    return false;
                }
                uRL = uRL2;
            }
            if ("file".equals(uRL.getProtocol())) continue;
            return false;
        }
        return true;
    }
}

