/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jvm;

import java.lang.management.RuntimeMXBean;
import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.application.jvm.Jvm;
import org.graalvm.visualvm.jvm.JRockitJVMImpl;
import org.graalvm.visualvm.jvm.JvmProvider;
import org.graalvm.visualvm.tools.jmx.JmxModel;
import org.graalvm.visualvm.tools.jmx.JmxModelFactory;
import org.graalvm.visualvm.tools.jmx.JvmMXBeans;
import org.graalvm.visualvm.tools.jmx.JvmMXBeansFactory;
import org.graalvm.visualvm.tools.jvmstat.JvmstatModel;
import org.graalvm.visualvm.tools.jvmstat.JvmstatModelFactory;

class JRockitJvmProvider
extends JvmProvider {
    private static final String JROCKIT_VM_NAME = "BEA JRockit(R)";
    private static final String VM_NAME = "java.property.java.vm.name";

    JRockitJvmProvider() {
    }

    @Override
    public Jvm createModelFor(Application app) {
        JRockitJVMImpl jvm = null;
        JvmstatModel jvmstat = JvmstatModelFactory.getJvmstatFor((Application)app);
        if (jvmstat != null) {
            String vmName = jvmstat.findByName(VM_NAME);
            if (JROCKIT_VM_NAME.equals(vmName)) {
                jvm = new JRockitJVMImpl(app, jvmstat);
            }
        } else {
            RuntimeMXBean runtime;
            JvmMXBeans mxbeans;
            JmxModel jmxModel = JmxModelFactory.getJmxModelFor((Application)app);
            if (jmxModel != null && jmxModel.getConnectionState() == JmxModel.ConnectionState.CONNECTED && (mxbeans = JvmMXBeansFactory.getJvmMXBeans((JmxModel)jmxModel)) != null && (runtime = mxbeans.getRuntimeMXBean()) != null && JROCKIT_VM_NAME.equals(runtime.getVmName())) {
                jvm = new JRockitJVMImpl(app);
            }
        }
        return jvm;
    }
}

