/*
 * Decompiled with CFR 0.152.
 */
package org.openide.actions;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Path2D;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.prefs.Preferences;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import org.openide.actions.GarbageCollectAction;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

class HeapView
extends JComponent {
    private static final boolean AUTOMATIC_REFRESH = System.getProperty("org.netbeans.log.startup") == null;
    private static final int TICK = 1500;
    private static final Color CHART_COLOR;
    private static final Color TEXT_COLOR;
    private static final Color BACKGROUND_COLOR;
    private static final int GRAPH_COUNT = 100;
    private static final String SHOW_TEXT = "showText";
    private final MessageFormat format;
    private final long[] graph = new long[100];
    private int graphIndex;
    private long lastTotal;
    private Timer updateTimer;
    private int maxTextWidth;
    private String heapSizeText = "";

    public HeapView() {
        this.format = new MessageFormat("{0,choice,0#{0,number,0.0}|999<{0,number,0}}/{1,choice,0#{1,number,0.0}|999<{1,number,0}}MB");
        this.enableEvents(16L);
        this.setToolTipText(NbBundle.getMessage(GarbageCollectAction.class, (String)"CTL_GC"));
        this.updateUI();
    }

    @Override
    public boolean isOpaque() {
        return true;
    }

    @Override
    public void updateUI() {
        Font font = UIManager.getFont("Label.font");
        this.setFont(font);
    }

    public void setShowText(boolean bl) {
        this.prefs().putBoolean(SHOW_TEXT, bl);
        this.repaint();
    }

    public boolean getShowText() {
        return this.prefs().getBoolean(SHOW_TEXT, true);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.updateTextWidth();
    }

    Dimension heapViewPreferredSize() {
        Dimension dimension = new Dimension(this.maxTextWidth + 8, this.getFontMetrics(this.getFont()).getHeight() + 8);
        return dimension;
    }

    private Preferences prefs() {
        return NbPreferences.forModule(HeapView.class);
    }

    private void updateTextWidth() {
        String string = this.format.format(new Object[]{Float.valueOf(888.8f), Float.valueOf(888.8f)});
        this.maxTextWidth = this.getFontMetrics(this.getFont()).stringWidth(string) + 4;
    }

    @Override
    protected void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
        if (!mouseEvent.isConsumed() && mouseEvent.isPopupTrigger()) {
            this.showPopup(mouseEvent.getX(), mouseEvent.getY());
        }
        if (mouseEvent.getID() == 500 && SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 1) {
            ((GarbageCollectAction)GarbageCollectAction.get(GarbageCollectAction.class)).performAction();
        }
    }

    private void showPopup(int n, int n2) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(NbBundle.getMessage(HeapView.class, (String)"LBL_ShowText"));
        jCheckBoxMenuItem.setSelected(this.getShowText());
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HeapView.this.setShowText(((JCheckBoxMenuItem)actionEvent.getSource()).isSelected());
            }
        });
        jPopupMenu.add(jCheckBoxMenuItem);
        jPopupMenu.show(this, n, n2);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (n > 0 && n2 > 0) {
            this.startTimerIfNecessary();
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setPaint(BACKGROUND_COLOR);
            graphics2D.fillRect(0, 0, n + 1, n2 + 1);
            graphics2D.setPaint(CHART_COLOR);
            this.paintSamples(graphics2D, n, n2);
            if (this.getShowText()) {
                this.paintText(graphics2D, n, n2);
            }
        } else {
            this.stopTimerIfNecessary();
        }
    }

    private void paintText(Graphics2D graphics2D, int n, int n2) {
        graphics2D.setFont(this.getFont());
        String string = this.getHeapSizeText();
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n3 = fontMetrics.stringWidth(string);
        int n4 = (n - this.maxTextWidth) / 2 + (this.maxTextWidth - n3);
        int n5 = n2 / 2 + fontMetrics.getAscent() / 2 - 2;
        graphics2D.setColor(TEXT_COLOR);
        graphics2D.drawString(string, n4, n5);
    }

    private String getHeapSizeText() {
        return this.heapSizeText;
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.stopTimerIfNecessary();
    }

    private void startTimerIfNecessary() {
        if (!AUTOMATIC_REFRESH) {
            return;
        }
        if (this.updateTimer == null) {
            this.updateTimer = new Timer(1500, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    HeapView.this.update();
                }
            });
            this.updateTimer.setRepeats(true);
            this.updateTimer.start();
        }
    }

    private void stopTimerIfNecessary() {
        if (this.updateTimer != null) {
            this.updateTimer.stop();
            this.updateTimer = null;
            this.lastTotal = 0L;
            Arrays.fill(this.graph, 0L);
            this.heapSizeText = "";
        }
    }

    private void update() {
        if (this.isShowing()) {
            long l;
            Runtime runtime = Runtime.getRuntime();
            long l2 = runtime.totalMemory();
            this.graph[this.graphIndex] = l = l2 - runtime.freeMemory();
            this.lastTotal = l2;
            ++this.graphIndex;
            if (this.graphIndex >= 100) {
                this.graphIndex = 0;
            }
            this.heapSizeText = this.format.format(new Object[]{(double)l / 1048576.0, (double)l2 / 1048576.0});
            this.repaint();
        } else {
            this.stopTimerIfNecessary();
        }
    }

    private void paintSamples(Graphics2D graphics2D, int n, int n2) {
        Path2D.Double double_ = new Path2D.Double();
        ((Path2D)double_).moveTo(0.0, n2);
        for (int i = 0; i < 100; ++i) {
            int n3 = (i + this.graphIndex) % 100;
            double d = (double)i / 99.0 * (double)n;
            double d2 = (double)n2 * (1.0 - (double)this.graph[n3] / (double)this.lastTotal);
            ((Path2D)double_).lineTo(d, d2);
        }
        ((Path2D)double_).lineTo(n, n2);
        double_.closePath();
        graphics2D.fill(double_);
    }

    static {
        Color color = UIManager.getColor("nb.heapview.chart");
        if (null == color) {
            color = new Color(3051752);
        }
        CHART_COLOR = color;
        color = UIManager.getColor("nb.heapview.foreground");
        if (null == color) {
            color = Color.DARK_GRAY;
        }
        TEXT_COLOR = color;
        color = UIManager.getColor("nb.heapview.background");
        if (null == color) {
            color = new Color(13556710);
        }
        BACKGROUND_COLOR = color;
    }
}

