/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.internal.parser.v0.factories;

import org.openjdk.jmc.common.unit.ContentType;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.factories.IPoolFactory;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.factories.ThreadGroup;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.model.ValueDescriptor;

final class ThreadGroupFactory
implements IPoolFactory<Object> {
    private final int m_nameIndex;

    public ThreadGroupFactory(ValueDescriptor[] descriptors) {
        this.m_nameIndex = ValueDescriptor.getIndex(descriptors, "name");
    }

    @Override
    public Object createObject(long identifier, Object o) {
        if (o != null) {
            Object[] os = (Object[])o;
            if (this.m_nameIndex >= 0) {
                Object nameObject = os[this.m_nameIndex];
                if (o != null) {
                    return new ThreadGroup(String.valueOf(nameObject));
                }
            }
        }
        return new ThreadGroup("Unknown Group");
    }

    @Override
    public ContentType<Object> getContentType() {
        return UnitLookup.UNKNOWN;
    }
}

