/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.heap;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.graalvm.visualvm.lib.jfluid.heap.AbstractLongMap;
import org.graalvm.visualvm.lib.jfluid.heap.HprofByteBuffer;
import org.graalvm.visualvm.lib.jfluid.heap.NumberList;

class CacheDirectory {
    private static final String DIR_EXT = ".hwcache";
    private static final String DUMP_AUX_FILE = "NBProfiler.nphd";
    private static final String DIRTY_FILENAME = "dirty.lck";
    private File cacheDirectory;

    static CacheDirectory getHeapDumpCacheDirectory(File heapDump, int seg) {
        String dumpName = heapDump.getName();
        String suffix = seg == 0 ? "" : "_" + seg;
        File parent = heapDump.getParentFile();
        File dir = new File(parent, dumpName + suffix + DIR_EXT);
        return new CacheDirectory(dir);
    }

    CacheDirectory(File cacheDir) {
        this.cacheDirectory = cacheDir;
        if (cacheDir != null && !cacheDir.exists() && !cacheDir.mkdir()) {
            this.cacheDirectory = null;
        }
        if (this.cacheDirectory != null) assert (this.cacheDirectory.isDirectory() && this.cacheDirectory.canRead() && this.cacheDirectory.canWrite());
    }

    File createTempFile(String prefix, String suffix) throws IOException {
        File newFile;
        if (this.isTemporary()) {
            newFile = File.createTempFile(prefix, suffix);
            newFile.deleteOnExit();
        } else {
            newFile = File.createTempFile(prefix, suffix, this.cacheDirectory);
        }
        return newFile;
    }

    File getHeapDumpAuxFile() {
        assert (!this.isTemporary());
        return new File(this.cacheDirectory, DUMP_AUX_FILE);
    }

    boolean isTemporary() {
        return this.cacheDirectory == null;
    }

    File getCacheFile(String fileName) throws FileNotFoundException {
        File f = new File(fileName);
        if (CacheDirectory.isFileRW(f)) {
            return f;
        }
        if (CacheDirectory.isFileRW(f = new File(this.cacheDirectory, f.getName()))) {
            return f;
        }
        throw new FileNotFoundException(fileName);
    }

    File getHeapFile(String fileName) throws FileNotFoundException {
        File f = new File(fileName);
        if (CacheDirectory.isFileR(f)) {
            return f;
        }
        f = new File(this.cacheDirectory.getParentFile(), f.getName());
        if (CacheDirectory.isFileR(f)) {
            return f;
        }
        throw new FileNotFoundException(fileName);
    }

    void deleteAllCachedFiles() {
        assert (!this.isTemporary());
        for (File f : this.cacheDirectory.listFiles()) {
            f.delete();
        }
    }

    boolean isDirty() {
        if (this.isTemporary()) {
            return true;
        }
        File dirtyFile = new File(this.cacheDirectory, DIRTY_FILENAME);
        return CacheDirectory.isFileR(dirtyFile);
    }

    void setDirty(boolean dirty) {
        if (!this.isTemporary()) {
            File dirtyFile = new File(this.cacheDirectory, DIRTY_FILENAME);
            try {
                if (dirty) {
                    assert (!CacheDirectory.isFileR(dirtyFile));
                    dirtyFile.createNewFile();
                } else {
                    assert (CacheDirectory.isFileRW(dirtyFile));
                    dirtyFile.delete();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    HprofByteBuffer createHprofByteBuffer(File dumpFile) throws IOException {
        return HprofByteBuffer.createHprofByteBuffer(dumpFile);
    }

    AbstractLongMap.Data createDumpBuffer(long fileSize, int entrySize) throws IOException {
        File tempFile = this.createTempFile("NBProfiler", ".map");
        try (RandomAccessFile file = new RandomAccessFile(tempFile, "rw");){
            if (Boolean.getBoolean("org.graalvm.visualvm.lib.jfluid.heap.zerofile")) {
                byte[] zeros = new byte[524288];
                while (file.length() < fileSize) {
                    file.write(zeros);
                }
                file.write(zeros, 0, (int)(fileSize - file.length()));
            }
            file.setLength(fileSize);
            AbstractLongMap.Data data = AbstractLongMap.getDumpBuffer(tempFile, file, entrySize);
            return data;
        }
    }

    NumberList createNumberList(int idSize) throws IOException {
        return new NumberList(idSize, this);
    }

    private static boolean isFileR(File f) {
        return f.exists() && f.isFile() && f.canRead();
    }

    private static boolean isFileRW(File f) {
        return CacheDirectory.isFileR(f) && f.canWrite();
    }

    private static boolean isLinux() {
        String osName = System.getProperty("os.name");
        return osName.endsWith("Linux");
    }
}

