/* rygel-media-object.c generated by valac 0.56.1, the Vala compiler
 * generated from rygel-media-object.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2012 Intel Corporation.
 * Copyright (C) 2013 Cable Television Laboratories, Inc.
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *         Doug Galligan <doug@sentosatech.com>
 *         Craig Pratt <craig@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "rygel-server.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <libgupnp-av/gupnp-av.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <libxml/tree.h>
#include "rygel-core.h"

enum  {
	RYGEL_MEDIA_OBJECT_0_PROPERTY,
	RYGEL_MEDIA_OBJECT_ID_PROPERTY,
	RYGEL_MEDIA_OBJECT_REF_ID_PROPERTY,
	RYGEL_MEDIA_OBJECT_UPNP_CLASS_PROPERTY,
	RYGEL_MEDIA_OBJECT_DATE_PROPERTY,
	RYGEL_MEDIA_OBJECT_CREATOR_PROPERTY,
	RYGEL_MEDIA_OBJECT_MODIFIED_PROPERTY,
	RYGEL_MEDIA_OBJECT_OBJECT_UPDATE_ID_PROPERTY,
	RYGEL_MEDIA_OBJECT_ARTIST_PROPERTY,
	RYGEL_MEDIA_OBJECT_GENRE_PROPERTY,
	RYGEL_MEDIA_OBJECT_PARENT_PROPERTY,
	RYGEL_MEDIA_OBJECT_PARENT_REF_PROPERTY,
	RYGEL_MEDIA_OBJECT_TITLE_PROPERTY,
	RYGEL_MEDIA_OBJECT_OCM_FLAGS_PROPERTY,
	RYGEL_MEDIA_OBJECT_RESTRICTED_PROPERTY,
	RYGEL_MEDIA_OBJECT_NUM_PROPERTIES
};
static GParamSpec* rygel_media_object_properties[RYGEL_MEDIA_OBJECT_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _RygelMediaObjectGetWritableData RygelMediaObjectGetWritableData;
typedef struct _RygelMediaObjectGetWritablesData RygelMediaObjectGetWritablesData;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _Block4Data Block4Data;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelMediaObjectApplyFragmentsData RygelMediaObjectApplyFragmentsData;
typedef struct _RygelMediaObjectCheckWritableData RygelMediaObjectCheckWritableData;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

#define RYGEL_TYPE_MEDIA_ITEM_ERROR (rygel_media_item_error_get_type ())

struct _RygelMediaObjectPrivate {
	gchar* _id;
	gchar* _ref_id;
	gchar* _upnp_class;
	gchar* _date;
	gchar* _creator;
	guint64 _modified;
	guint _object_update_id;
	gchar* _artist;
	gchar* _genre;
	GeeArrayList* uris;
	GeeList* media_resources;
	RygelMediaContainer* _parent_ref;
	gchar* _title;
};

struct _RygelMediaObjectGetWritableData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelMediaObject* self;
	GCancellable* cancellable;
	GFile* result;
	GeeArrayList* _uri_list;
	GeeArrayList* _tmp0_;
	gint _uri_size;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _uri_index;
	gint _tmp4_;
	gint _tmp5_;
	gchar* uri;
	GeeArrayList* _tmp6_;
	gpointer _tmp7_;
	GFile* file;
	const gchar* _tmp8_;
	GFile* _tmp9_;
	gboolean _tmp10_;
	GFile* _tmp11_;
	GError* _inner_error0_;
};

struct _RygelMediaObjectGetWritablesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelMediaObject* self;
	GCancellable* cancellable;
	GeeArrayList* result;
	GeeArrayList* writables;
	GeeArrayList* _tmp0_;
	GeeArrayList* _uri_list;
	GeeArrayList* _tmp1_;
	gint _uri_size;
	GeeArrayList* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _uri_index;
	gint _tmp5_;
	gint _tmp6_;
	gchar* uri;
	GeeArrayList* _tmp7_;
	gpointer _tmp8_;
	GFile* file;
	const gchar* _tmp9_;
	GFile* _tmp10_;
	gboolean _tmp11_;
	GFile* _tmp12_;
	GeeArrayList* _tmp13_;
	GFile* _tmp14_;
	GError* _inner_error0_;
};

struct _Block4Data {
	int _ref_count_;
	gchar* replaced_string;
};

struct _RygelMediaObjectApplyFragmentsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelMediaObject* self;
	GeeLinkedList* current_fragments;
	GeeLinkedList* new_fragments;
	RygelHTTPServer* http_server;
	GUPnPDIDLLiteFragmentResult result;
	GUPnPDIDLLiteFragmentResult _result_;
	RygelSerializer* writer;
	RygelSerializer* _tmp0_;
	GUPnPDIDLLiteObject* didl_object;
	RygelSerializer* _tmp1_;
	GUPnPDIDLLiteObject* _tmp2_;
	GUPnPDIDLLiteObject* _tmp3_;
	xmlNode* _tmp4_;
	xmlNode* _tmp5_;
	GUPnPDIDLLiteObject* _tmp6_;
	xmlNs* _tmp7_;
	xmlNs* _tmp8_;
	GUPnPDIDLLiteObject* _tmp9_;
	gint _tmp10_;
	gpointer* _tmp11_;
	gchar** _tmp12_;
	gint _tmp12__length1;
	gint _tmp13_;
	gpointer* _tmp14_;
	gchar** _tmp15_;
	gint _tmp15__length1;
	GUPnPDIDLLiteObject* _tmp16_;
	GError* e;
	GError* _tmp17_;
	const gchar* _tmp18_;
	GError* _inner_error0_;
};

struct _RygelMediaObjectCheckWritableData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelMediaObject* self;
	GFile* file;
	GCancellable* cancellable;
	gboolean result;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	GFileInfo* info;
	GFileInfo* _tmp3_;
	GFileInfo* _tmp4_;
	GError* _inner_error0_;
};

typedef enum  {
	RYGEL_MEDIA_ITEM_ERROR_BAD_URI
} RygelMediaItemError;
#define RYGEL_MEDIA_ITEM_ERROR rygel_media_item_error_quark ()

static gint RygelMediaObject_private_offset;
static gpointer rygel_media_object_parent_class = NULL;
static GRegex* rygel_media_object_real_name_regex;
static GRegex* rygel_media_object_real_name_regex = NULL;
static GRegex* rygel_media_object_user_name_regex;
static GRegex* rygel_media_object_user_name_regex = NULL;
static GRegex* rygel_media_object_host_name_regex;
static GRegex* rygel_media_object_host_name_regex = NULL;
static GRegex* rygel_media_object_pretty_name_regex;
static GRegex* rygel_media_object_pretty_name_regex = NULL;

VALA_EXTERN void rygel_media_object_apply_didl_lite (RygelMediaObject* self,
                                         GUPnPDIDLLiteObject* didl_object);
VALA_EXTERN gint rygel_media_object_compare_by_property (RygelMediaObject* self,
                                             RygelMediaObject* media_object,
                                             const gchar* property);
static void rygel_media_object_real_add_uri (RygelMediaObject* self,
                                      const gchar* uri);
static void rygel_media_object_real_constructed (GObject* base);
static void rygel_media_object_get_writable_data_free (gpointer _data);
static gboolean rygel_media_object_get_writable_co (RygelMediaObjectGetWritableData* _data_);
static void rygel_media_object_check_writable (RygelMediaObject* self,
                                        GFile* file,
                                        GCancellable* cancellable,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
static gboolean rygel_media_object_check_writable_finish (RygelMediaObject* self,
                                                   GAsyncResult* _res_,
                                                   GError** error);
static void rygel_media_object_get_writable_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_);
static void rygel_media_object_get_writables_data_free (gpointer _data);
static gboolean rygel_media_object_get_writables_co (RygelMediaObjectGetWritablesData* _data_);
static void rygel_media_object_get_writables_ready (GObject* source_object,
                                             GAsyncResult* _res_,
                                             gpointer _user_data_);
static GUPnPDIDLLiteObject* rygel_media_object_real_serialize (RygelMediaObject* self,
                                                        RygelSerializer* serializer,
                                                        RygelHTTPServer* http_server,
                                                        GError** error);
VALA_EXTERN gchar* rygel_http_server_create_uri_for_object (RygelHTTPServer* self,
                                                RygelMediaObject* object,
                                                gint thumbnail_index,
                                                gint subtitle_index,
                                                const gchar* resource_name);
VALA_EXTERN gchar* rygel_media_object_get_protocol_for_uri (RygelMediaObject* self,
                                                const gchar* uri,
                                                GError** error);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void __lambda4_ (Block4Data* _data4_,
                 const gchar* search_string,
                 const gchar* replacement);
static void ___lambda4__gh_func (gconstpointer key,
                          gconstpointer value,
                          gpointer self);
static RygelDataSource* rygel_media_object_real_create_stream_source_for_resource (RygelMediaObject* self,
                                                                            RygelHTTPRequest* request,
                                                                            RygelMediaResource* resource,
                                                                            GError** error);
static void rygel_media_object_real_apply_didl_lite (RygelMediaObject* self,
                                              GUPnPDIDLLiteObject* didl_object);
static gchar* rygel_media_object_get_first (RygelMediaObject* self,
                                     GList* contributors);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void rygel_media_object_clean_node (RygelMediaObject* self,
                                    xmlNode* node,
                                    xmlNs* ns);
static void rygel_media_object_apply_fragments_data_free (gpointer _data);
VALA_EXTERN void rygel_media_object_apply_fragments (RygelMediaObject* self,
                                         GeeLinkedList* current_fragments,
                                         GeeLinkedList* new_fragments,
                                         RygelHTTPServer* http_server,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_);
VALA_EXTERN GUPnPDIDLLiteFragmentResult rygel_media_object_apply_fragments_finish (RygelMediaObject* self,
                                                                       GAsyncResult* _res_);
static gboolean rygel_media_object_apply_fragments_co (RygelMediaObjectApplyFragmentsData* _data_);
static void rygel_media_object_apply_fragments_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_);
static gint rygel_media_object_real_compare_by_property (RygelMediaObject* self,
                                                  RygelMediaObject* media_object,
                                                  const gchar* property);
static gint rygel_media_object_compare_by_date (RygelMediaObject* self,
                                         RygelMediaObject* object);
static void rygel_media_object_check_writable_data_free (gpointer _data);
static gboolean rygel_media_object_check_writable_co (RygelMediaObjectCheckWritableData* _data_);
static void rygel_media_object_check_writable_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_);
VALA_EXTERN GQuark rygel_media_item_error_quark (void);
GType rygel_media_item_error_get_type (void) G_GNUC_CONST ;
static void _g_free0_ (gpointer var);
static inline void _g_list_free__g_free0_ (GList* self);
VALA_EXTERN gboolean rygel_media_object_get_restricted (RygelMediaObject* self);
static void rygel_media_object_finalize (GObject * obj);
static GType rygel_media_object_get_type_once (void);
static void _vala_rygel_media_object_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);
static void _vala_rygel_media_object_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
rygel_media_object_get_instance_private (RygelMediaObject* self)
{
	return G_STRUCT_MEMBER_P (self, RygelMediaObject_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GeeList*
rygel_media_object_get_uris (RygelMediaObject* self)
{
	GeeArrayList* _tmp0_;
	GeeList* _tmp1_;
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->uris;
	_tmp1_ = _g_object_ref0 ((GeeList*) _tmp0_);
	result = _tmp1_;
	return result;
}

gchar*
rygel_media_object_get_primary_uri (RygelMediaObject* self)
{
	GeeArrayList* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GeeArrayList* _tmp3_;
	gpointer _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->uris;
	_tmp1_ = gee_collection_get_is_empty ((GeeCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		result = NULL;
		return result;
	}
	_tmp3_ = self->priv->uris;
	_tmp4_ = gee_abstract_list_get ((GeeAbstractList*) _tmp3_, 0);
	result = (gchar*) _tmp4_;
	return result;
}

static void
rygel_media_object_real_add_uri (RygelMediaObject* self,
                                 const gchar* uri)
{
	GeeArrayList* _tmp0_;
	g_return_if_fail (uri != NULL);
	_tmp0_ = self->priv->uris;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp0_, uri);
}

void
rygel_media_object_add_uri (RygelMediaObject* self,
                            const gchar* uri)
{
	RygelMediaObjectClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = RYGEL_MEDIA_OBJECT_GET_CLASS (self);
	if (_klass_->add_uri) {
		_klass_->add_uri (self, uri);
	}
}

static void
rygel_media_object_real_constructed (GObject* base)
{
	RygelMediaObject * self;
	GeeArrayList* _tmp0_;
	self = (RygelMediaObject*) base;
	G_OBJECT_CLASS (rygel_media_object_parent_class)->constructed (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject));
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->uris);
	self->priv->uris = _tmp0_;
}

static void
rygel_media_object_get_writable_data_free (gpointer _data)
{
	RygelMediaObjectGetWritableData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelMediaObjectGetWritableData, _data_);
}

void
rygel_media_object_get_writable (RygelMediaObject* self,
                                 GCancellable* cancellable,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_)
{
	RygelMediaObjectGetWritableData* _data_;
	RygelMediaObject* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (RygelMediaObjectGetWritableData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_media_object_get_writable_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	rygel_media_object_get_writable_co (_data_);
}

GFile*
rygel_media_object_get_writable_finish (RygelMediaObject* self,
                                        GAsyncResult* _res_,
                                        GError** error)
{
	GFile* result;
	RygelMediaObjectGetWritableData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

/**
     * Fetches a File object for any writable URI available for this object.
     *
     * @param cancellable A GLib.Cancellable
     */
static void
rygel_media_object_get_writable_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_)
{
	RygelMediaObjectGetWritableData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_media_object_get_writable_co (_data_);
}

static gboolean
rygel_media_object_get_writable_co (RygelMediaObjectGetWritableData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = _data_->self->priv->uris;
		_data_->_uri_list = _data_->_tmp0_;
		_data_->_tmp1_ = _data_->_uri_list;
		_data_->_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->_tmp1_);
		_data_->_tmp3_ = _data_->_tmp2_;
		_data_->_uri_size = _data_->_tmp3_;
		_data_->_uri_index = -1;
		while (TRUE) {
			_data_->_uri_index = _data_->_uri_index + 1;
			_data_->_tmp4_ = _data_->_uri_index;
			_data_->_tmp5_ = _data_->_uri_size;
			if (!(_data_->_tmp4_ < _data_->_tmp5_)) {
				break;
			}
			_data_->_tmp6_ = _data_->_uri_list;
			_data_->_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp6_, _data_->_uri_index);
			_data_->uri = (gchar*) _data_->_tmp7_;
			_data_->_tmp8_ = _data_->uri;
			_data_->_tmp9_ = g_file_new_for_uri (_data_->_tmp8_);
			_data_->file = _data_->_tmp9_;
			_data_->_tmp11_ = _data_->file;
			_data_->_state_ = 1;
			rygel_media_object_check_writable (_data_->self, _data_->_tmp11_, _data_->cancellable, rygel_media_object_get_writable_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp10_ = rygel_media_object_check_writable_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				_g_object_unref0 (_data_->file);
				_g_free0 (_data_->uri);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			if (_data_->_tmp10_) {
				_data_->result = _data_->file;
				_g_free0 (_data_->uri);
				g_task_return_pointer (_data_->_async_result, _data_, NULL);
				if (_data_->_state_ != 0) {
					while (!g_task_get_completed (_data_->_async_result)) {
						g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
					}
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_g_object_unref0 (_data_->file);
			_g_free0 (_data_->uri);
		}
	}
	_data_->result = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
rygel_media_object_get_writables_data_free (gpointer _data)
{
	RygelMediaObjectGetWritablesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelMediaObjectGetWritablesData, _data_);
}

void
rygel_media_object_get_writables (RygelMediaObject* self,
                                  GCancellable* cancellable,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_)
{
	RygelMediaObjectGetWritablesData* _data_;
	RygelMediaObject* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (RygelMediaObjectGetWritablesData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_media_object_get_writables_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	rygel_media_object_get_writables_co (_data_);
}

GeeArrayList*
rygel_media_object_get_writables_finish (RygelMediaObject* self,
                                         GAsyncResult* _res_,
                                         GError** error)
{
	GeeArrayList* result;
	RygelMediaObjectGetWritablesData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

/**
     * Fetches File objects for all writable URIs available for this object.
     *
     * @param cancellable A GLib.Cancellable
     */
static void
rygel_media_object_get_writables_ready (GObject* source_object,
                                        GAsyncResult* _res_,
                                        gpointer _user_data_)
{
	RygelMediaObjectGetWritablesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_media_object_get_writables_co (_data_);
}

static gboolean
rygel_media_object_get_writables_co (RygelMediaObjectGetWritablesData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = gee_array_list_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_data_->writables = _data_->_tmp0_;
	{
		_data_->_tmp1_ = _data_->self->priv->uris;
		_data_->_uri_list = _data_->_tmp1_;
		_data_->_tmp2_ = _data_->_uri_list;
		_data_->_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->_tmp2_);
		_data_->_tmp4_ = _data_->_tmp3_;
		_data_->_uri_size = _data_->_tmp4_;
		_data_->_uri_index = -1;
		while (TRUE) {
			_data_->_uri_index = _data_->_uri_index + 1;
			_data_->_tmp5_ = _data_->_uri_index;
			_data_->_tmp6_ = _data_->_uri_size;
			if (!(_data_->_tmp5_ < _data_->_tmp6_)) {
				break;
			}
			_data_->_tmp7_ = _data_->_uri_list;
			_data_->_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp7_, _data_->_uri_index);
			_data_->uri = (gchar*) _data_->_tmp8_;
			_data_->_tmp9_ = _data_->uri;
			_data_->_tmp10_ = g_file_new_for_uri (_data_->_tmp9_);
			_data_->file = _data_->_tmp10_;
			_data_->_tmp12_ = _data_->file;
			_data_->_state_ = 1;
			rygel_media_object_check_writable (_data_->self, _data_->_tmp12_, _data_->cancellable, rygel_media_object_get_writables_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp11_ = rygel_media_object_check_writable_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				_g_object_unref0 (_data_->file);
				_g_free0 (_data_->uri);
				_g_object_unref0 (_data_->writables);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			if (_data_->_tmp11_) {
				_data_->_tmp13_ = _data_->writables;
				_data_->_tmp14_ = _data_->file;
				gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp13_, _data_->_tmp14_);
			}
			_g_object_unref0 (_data_->file);
			_g_free0 (_data_->uri);
		}
	}
	_data_->result = _data_->writables;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

/**
     * Return the MediaResource list.
     */
GeeList*
rygel_media_object_get_resource_list (RygelMediaObject* self)
{
	GeeList* _tmp0_;
	GeeList* _tmp1_;
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->media_resources;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

RygelMediaResource*
rygel_media_object_get_resource_by_name (RygelMediaObject* self,
                                         const gchar* resource_name)
{
	RygelMediaResource* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (resource_name != NULL, NULL);
	{
		GeeList* _resource_list = NULL;
		GeeList* _tmp0_;
		gint _resource_size = 0;
		GeeList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _resource_index = 0;
		_tmp0_ = self->priv->media_resources;
		_resource_list = _tmp0_;
		_tmp1_ = _resource_list;
		_tmp2_ = gee_collection_get_size ((GeeCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_resource_size = _tmp3_;
		_resource_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			RygelMediaResource* resource = NULL;
			GeeList* _tmp6_;
			gpointer _tmp7_;
			RygelMediaResource* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			gboolean _tmp11_;
			_resource_index = _resource_index + 1;
			_tmp4_ = _resource_index;
			_tmp5_ = _resource_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _resource_list;
			_tmp7_ = gee_list_get (_tmp6_, _resource_index);
			resource = (RygelMediaResource*) _tmp7_;
			_tmp8_ = resource;
			_tmp9_ = rygel_media_resource_get_name (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = g_strcmp0 (_tmp10_, resource_name) == 0;
			_g_free0 (_tmp10_);
			if (_tmp11_) {
				result = resource;
				return result;
			}
			_g_object_unref0 (resource);
		}
	}
	result = NULL;
	return result;
}

static GUPnPDIDLLiteObject*
rygel_media_object_real_serialize (RygelMediaObject* self,
                                   RygelSerializer* serializer,
                                   RygelHTTPServer* http_server,
                                   GError** error)
{
	g_critical ("Type `%s' does not implement abstract method `rygel_media_object_serialize'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

GUPnPDIDLLiteObject*
rygel_media_object_serialize (RygelMediaObject* self,
                              RygelSerializer* serializer,
                              RygelHTTPServer* http_server,
                              GError** error)
{
	RygelMediaObjectClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = RYGEL_MEDIA_OBJECT_GET_CLASS (self);
	if (_klass_->serialize) {
		return _klass_->serialize (self, serializer, http_server, error);
	}
	return NULL;
}

/**
     * Serialize the resource list
     *
     * Any resource with an empty URIs will get a resource-based HTTP URI and have its protocol
     * and delivery options adjusted to the HTTPServer.
     *
     * Internal (e.g. "file:") resources will only be included when the http server
     * is on the local host.
     *
     * Resources will be serialized in list order.
     */
void
rygel_media_object_serialize_resource_list (RygelMediaObject* self,
                                            GUPnPDIDLLiteObject* didl_object,
                                            RygelHTTPServer* http_server,
                                            GError** error)
{
	GHashTable* replacements = NULL;
	GHashTable* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (didl_object != NULL);
	g_return_if_fail (http_server != NULL);
	_tmp0_ = rygel_http_server_get_replacements (http_server);
	replacements = _tmp0_;
	{
		GeeList* _res_list = NULL;
		GeeList* _tmp1_;
		gint _res_size = 0;
		GeeList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _res_index = 0;
		_tmp1_ = rygel_media_object_get_resource_list (self);
		_res_list = _tmp1_;
		_tmp2_ = _res_list;
		_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_res_size = _tmp4_;
		_res_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			RygelMediaResource* res = NULL;
			GeeList* _tmp7_;
			gpointer _tmp8_;
			gboolean _tmp9_ = FALSE;
			RygelMediaResource* _tmp10_;
			const gchar* _tmp11_;
			const gchar* _tmp12_;
			_res_index = _res_index + 1;
			_tmp5_ = _res_index;
			_tmp6_ = _res_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _res_list;
			_tmp8_ = gee_list_get (_tmp7_, _res_index);
			res = (RygelMediaResource*) _tmp8_;
			_tmp10_ = res;
			_tmp11_ = rygel_media_resource_get_uri (_tmp10_);
			_tmp12_ = _tmp11_;
			if (_tmp12_ == NULL) {
				_tmp9_ = TRUE;
			} else {
				RygelMediaResource* _tmp13_;
				const gchar* _tmp14_;
				const gchar* _tmp15_;
				_tmp13_ = res;
				_tmp14_ = rygel_media_resource_get_uri (_tmp13_);
				_tmp15_ = _tmp14_;
				_tmp9_ = g_strcmp0 (_tmp15_, "") == 0;
			}
			if (_tmp9_) {
				gchar* uri = NULL;
				RygelMediaResource* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				gchar* _tmp19_;
				gchar* _tmp20_;
				RygelMediaFileItem* media_item = NULL;
				RygelMediaFileItem* _tmp21_;
				gboolean _tmp22_ = FALSE;
				RygelMediaFileItem* _tmp23_;
				GUPnPDIDLLiteResource* didl_resource = NULL;
				GUPnPDIDLLiteResource* _tmp31_;
				RygelMediaResource* _tmp32_;
				RygelMediaResource* _tmp33_;
				GUPnPDIDLLiteResource* _tmp34_;
				GHashTable* _tmp35_;
				GUPnPDIDLLiteResource* _tmp36_;
				GUPnPDIDLLiteResource* _tmp37_;
				RygelMediaResource* _tmp38_;
				RygelMediaResource* _tmp39_;
				_tmp16_ = res;
				_tmp17_ = rygel_media_resource_get_name (_tmp16_);
				_tmp18_ = _tmp17_;
				_tmp19_ = rygel_http_server_create_uri_for_object (http_server, self, -1, -1, _tmp18_);
				_tmp20_ = _tmp19_;
				_g_free0 (_tmp18_);
				uri = _tmp20_;
				_tmp21_ = _g_object_ref0 (RYGEL_IS_MEDIA_FILE_ITEM (self) ? ((RygelMediaFileItem*) self) : NULL);
				media_item = _tmp21_;
				_tmp23_ = media_item;
				if (_tmp23_ != NULL) {
					RygelMediaFileItem* _tmp24_;
					gboolean _tmp25_;
					gboolean _tmp26_;
					_tmp24_ = media_item;
					_tmp25_ = rygel_media_file_item_get_place_holder (_tmp24_);
					_tmp26_ = _tmp25_;
					_tmp22_ = _tmp26_;
				} else {
					_tmp22_ = FALSE;
				}
				if (_tmp22_) {
					RygelMediaResource* _tmp27_;
					const gchar* _tmp28_;
					_tmp27_ = res;
					_tmp28_ = uri;
					rygel_media_resource_set_import_uri (_tmp27_, _tmp28_);
				} else {
					RygelMediaResource* _tmp29_;
					const gchar* _tmp30_;
					_tmp29_ = res;
					_tmp30_ = uri;
					rygel_media_resource_set_uri (_tmp29_, _tmp30_);
				}
				_tmp31_ = gupnp_didl_lite_object_add_resource (didl_object);
				didl_resource = _tmp31_;
				_tmp32_ = res;
				rygel_http_server_set_resource_delivery_options (http_server, _tmp32_);
				_tmp33_ = res;
				_tmp34_ = didl_resource;
				_tmp35_ = replacements;
				_tmp36_ = rygel_media_resource_serialize (_tmp33_, _tmp34_, _tmp35_);
				_tmp37_ = _tmp36_;
				_g_object_unref0 (_tmp37_);
				_tmp38_ = res;
				rygel_media_resource_set_uri (_tmp38_, NULL);
				_tmp39_ = res;
				rygel_media_resource_set_import_uri (_tmp39_, NULL);
				_g_object_unref0 (didl_resource);
				_g_object_unref0 (media_item);
				_g_free0 (uri);
			} else {
				{
					gchar* protocol = NULL;
					RygelMediaResource* _tmp40_;
					const gchar* _tmp41_;
					const gchar* _tmp42_;
					gchar* _tmp43_;
					gboolean _tmp44_ = FALSE;
					const gchar* _tmp45_;
					_tmp40_ = res;
					_tmp41_ = rygel_media_resource_get_uri (_tmp40_);
					_tmp42_ = _tmp41_;
					_tmp43_ = rygel_media_object_get_protocol_for_uri (self, _tmp42_, &_inner_error0_);
					protocol = _tmp43_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch0_g_error;
					}
					_tmp45_ = protocol;
					if (_tmp45_ != NULL) {
						gboolean _tmp46_ = FALSE;
						const gchar* _tmp47_;
						_tmp47_ = protocol;
						if (g_strcmp0 (_tmp47_, "internal") != 0) {
							_tmp46_ = TRUE;
						} else {
							_tmp46_ = rygel_http_server_is_local (http_server);
						}
						_tmp44_ = _tmp46_;
					} else {
						_tmp44_ = FALSE;
					}
					if (_tmp44_) {
						GUPnPDIDLLiteResource* didl_resource = NULL;
						GUPnPDIDLLiteResource* _tmp48_;
						RygelMediaResource* _tmp49_;
						GUPnPDIDLLiteResource* _tmp50_;
						GHashTable* _tmp51_;
						GUPnPDIDLLiteResource* _tmp52_;
						GUPnPDIDLLiteResource* _tmp53_;
						_tmp48_ = gupnp_didl_lite_object_add_resource (didl_object);
						didl_resource = _tmp48_;
						_tmp49_ = res;
						_tmp50_ = didl_resource;
						_tmp51_ = replacements;
						_tmp52_ = rygel_media_resource_serialize (_tmp49_, _tmp50_, _tmp51_);
						_tmp53_ = _tmp52_;
						_g_object_unref0 (_tmp53_);
						_g_object_unref0 (didl_resource);
					}
					_g_free0 (protocol);
				}
				goto __finally0;
				__catch0_g_error:
				{
					RygelMediaResource* _tmp54_;
					const gchar* _tmp55_;
					const gchar* _tmp56_;
					g_clear_error (&_inner_error0_);
					_tmp54_ = res;
					_tmp55_ = rygel_media_resource_get_uri (_tmp54_);
					_tmp56_ = _tmp55_;
					g_warning (_ ("Could not determine protocol for %s"), _tmp56_);
				}
				__finally0:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (res);
					_g_object_unref0 (_res_list);
					_g_hash_table_unref0 (replacements);
					return;
				}
			}
			_g_object_unref0 (res);
		}
		_g_object_unref0 (_res_list);
	}
	_g_hash_table_unref0 (replacements);
}

/**
     * Replace each key in replacement_pairs with its corresponding
     * value in the source_string and return the result.
     *
     * @param replacement_pairs HashTable of variable -> substitution pairs
     * @param source_string String that shall have the replacements applied
     * to.
     *
     * @return null if source_string is null, string with all replacements
     * applied otherwise.
     */
static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		_g_free0 (_data4_->replaced_string);
		g_slice_free (Block4Data, _data4_);
	}
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
__lambda4_ (Block4Data* _data4_,
            const gchar* search_string,
            const gchar* replacement)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (search_string != NULL);
	g_return_if_fail (replacement != NULL);
	_tmp0_ = _data4_->replaced_string;
	_tmp1_ = string_replace (_tmp0_, search_string, replacement);
	_g_free0 (_data4_->replaced_string);
	_data4_->replaced_string = _tmp1_;
}

static void
___lambda4__gh_func (gconstpointer key,
                     gconstpointer value,
                     gpointer self)
{
	__lambda4_ (self, (const gchar*) key, (const gchar*) value);
}

gchar*
rygel_media_object_apply_replacements (GHashTable* replacement_pairs,
                                       const gchar* source_string)
{
	Block4Data* _data4_;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	g_return_val_if_fail (replacement_pairs != NULL, NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	if (source_string == NULL) {
		result = NULL;
		block4_data_unref (_data4_);
		_data4_ = NULL;
		return result;
	}
	_tmp0_ = g_strdup (source_string);
	_data4_->replaced_string = _tmp0_;
	g_hash_table_foreach (replacement_pairs, ___lambda4__gh_func, _data4_);
	_tmp1_ = _data4_->replaced_string;
	_tmp2_ = g_strdup (_tmp1_);
	result = _tmp2_;
	block4_data_unref (_data4_);
	_data4_ = NULL;
	return result;
}

/**
     * Create a stream source for the given resource
     */
static RygelDataSource*
rygel_media_object_real_create_stream_source_for_resource (RygelMediaObject* self,
                                                           RygelHTTPRequest* request,
                                                           RygelMediaResource* resource,
                                                           GError** error)
{
	g_critical ("Type `%s' does not implement abstract method `rygel_media_object_create_stream_source_for_resource'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

RygelDataSource*
rygel_media_object_create_stream_source_for_resource (RygelMediaObject* self,
                                                      RygelHTTPRequest* request,
                                                      RygelMediaResource* resource,
                                                      GError** error)
{
	RygelMediaObjectClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = RYGEL_MEDIA_OBJECT_GET_CLASS (self);
	if (_klass_->create_stream_source_for_resource) {
		return _klass_->create_stream_source_for_resource (self, request, resource, error);
	}
	return NULL;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
rygel_media_object_real_apply_didl_lite (RygelMediaObject* self,
                                         GUPnPDIDLLiteObject* didl_object)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GList* _tmp2_;
	GList* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	g_return_if_fail (didl_object != NULL);
	_tmp0_ = gupnp_didl_lite_object_get_title (didl_object);
	_tmp1_ = _tmp0_;
	rygel_media_object_set_title (self, _tmp1_);
	_tmp2_ = gupnp_didl_lite_object_get_artists (didl_object);
	_tmp3_ = _tmp2_;
	_tmp4_ = rygel_media_object_get_first (self, _tmp3_);
	_tmp5_ = _tmp4_;
	rygel_media_object_set_artist (self, _tmp5_);
	_g_free0 (_tmp5_);
	(_tmp3_ == NULL) ? NULL : (_tmp3_ = (_g_list_free__g_object_unref0_ (_tmp3_), NULL));
	_tmp6_ = gupnp_didl_lite_object_get_genre (didl_object);
	_tmp7_ = _tmp6_;
	rygel_media_object_set_genre (self, _tmp7_);
}

void
rygel_media_object_apply_didl_lite (RygelMediaObject* self,
                                    GUPnPDIDLLiteObject* didl_object)
{
	RygelMediaObjectClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = RYGEL_MEDIA_OBJECT_GET_CLASS (self);
	if (_klass_->apply_didl_lite) {
		_klass_->apply_didl_lite (self, didl_object);
	}
}

static void
rygel_media_object_clean_node (RygelMediaObject* self,
                               xmlNode* node,
                               xmlNs* ns)
{
	GeeArrayList* list = NULL;
	GeeArrayList* _tmp0_;
	xmlAttr* attr = NULL;
	xmlAttr* _tmp1_;
	xmlNode* child = NULL;
	xmlNode* _tmp19_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	list = _tmp0_;
	_tmp1_ = node->properties;
	attr = _tmp1_;
	while (TRUE) {
		xmlAttr* _tmp2_;
		xmlAttr* _tmp3_;
		xmlNs* _tmp4_;
		xmlAttr* _tmp8_;
		xmlAttr* _tmp9_;
		_tmp2_ = attr;
		if (!(_tmp2_ != NULL)) {
			break;
		}
		_tmp3_ = attr;
		_tmp4_ = _tmp3_->ns;
		if (_tmp4_ == ns) {
			GeeArrayList* _tmp5_;
			xmlAttr* _tmp6_;
			const gchar* _tmp7_;
			_tmp5_ = list;
			_tmp6_ = attr;
			_tmp7_ = _tmp6_->name;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp5_, _tmp7_);
		}
		_tmp8_ = attr;
		_tmp9_ = _tmp8_->next;
		attr = _tmp9_;
	}
	{
		GeeArrayList* _name_list = NULL;
		GeeArrayList* _tmp10_;
		gint _name_size = 0;
		GeeArrayList* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		gint _name_index = 0;
		_tmp10_ = list;
		_name_list = _tmp10_;
		_tmp11_ = _name_list;
		_tmp12_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp11_);
		_tmp13_ = _tmp12_;
		_name_size = _tmp13_;
		_name_index = -1;
		while (TRUE) {
			gint _tmp14_;
			gint _tmp15_;
			gchar* name = NULL;
			GeeArrayList* _tmp16_;
			gpointer _tmp17_;
			const gchar* _tmp18_;
			_name_index = _name_index + 1;
			_tmp14_ = _name_index;
			_tmp15_ = _name_size;
			if (!(_tmp14_ < _tmp15_)) {
				break;
			}
			_tmp16_ = _name_list;
			_tmp17_ = gee_abstract_list_get ((GeeAbstractList*) _tmp16_, _name_index);
			name = (gchar*) _tmp17_;
			_tmp18_ = name;
			xmlUnsetNsProp (node, ns, (xmlChar*) _tmp18_);
			_g_free0 (name);
		}
	}
	_tmp19_ = node->children;
	child = _tmp19_;
	while (TRUE) {
		xmlNode* _tmp20_;
		xmlNode* _tmp21_;
		xmlNode* _tmp22_;
		xmlNode* _tmp23_;
		_tmp20_ = child;
		if (!(_tmp20_ != NULL)) {
			break;
		}
		_tmp21_ = child;
		rygel_media_object_clean_node (self, _tmp21_, ns);
		_tmp22_ = child;
		_tmp23_ = _tmp22_->next;
		child = _tmp23_;
	}
	_g_object_unref0 (list);
}

static void
rygel_media_object_apply_fragments_data_free (gpointer _data)
{
	RygelMediaObjectApplyFragmentsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->current_fragments);
	_g_object_unref0 (_data_->new_fragments);
	_g_object_unref0 (_data_->http_server);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelMediaObjectApplyFragmentsData, _data_);
}

void
rygel_media_object_apply_fragments (RygelMediaObject* self,
                                    GeeLinkedList* current_fragments,
                                    GeeLinkedList* new_fragments,
                                    RygelHTTPServer* http_server,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_)
{
	RygelMediaObjectApplyFragmentsData* _data_;
	RygelMediaObject* _tmp0_;
	GeeLinkedList* _tmp1_;
	GeeLinkedList* _tmp2_;
	RygelHTTPServer* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (current_fragments != NULL);
	g_return_if_fail (new_fragments != NULL);
	g_return_if_fail (http_server != NULL);
	_data_ = g_slice_new0 (RygelMediaObjectApplyFragmentsData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_media_object_apply_fragments_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (current_fragments);
	_g_object_unref0 (_data_->current_fragments);
	_data_->current_fragments = _tmp1_;
	_tmp2_ = _g_object_ref0 (new_fragments);
	_g_object_unref0 (_data_->new_fragments);
	_data_->new_fragments = _tmp2_;
	_tmp3_ = _g_object_ref0 (http_server);
	_g_object_unref0 (_data_->http_server);
	_data_->http_server = _tmp3_;
	rygel_media_object_apply_fragments_co (_data_);
}

GUPnPDIDLLiteFragmentResult
rygel_media_object_apply_fragments_finish (RygelMediaObject* self,
                                           GAsyncResult* _res_)
{
	GUPnPDIDLLiteFragmentResult result;
	RygelMediaObjectApplyFragmentsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	return result;
}

static void
rygel_media_object_apply_fragments_ready (GObject* source_object,
                                          GAsyncResult* _res_,
                                          gpointer _user_data_)
{
	RygelMediaObjectApplyFragmentsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_media_object_apply_fragments_co (_data_);
}

static gboolean
rygel_media_object_apply_fragments_co (RygelMediaObjectApplyFragmentsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_result_ = GUPNP_DIDL_LITE_FRAGMENT_RESULT_UNKNOWN_ERROR;
	{
		_data_->_tmp0_ = rygel_serializer_new (RYGEL_SERIALIZER_TYPE_GENERIC_DIDL);
		_data_->writer = _data_->_tmp0_;
		_data_->_tmp1_ = _data_->writer;
		_data_->_tmp2_ = rygel_media_object_serialize (_data_->self, _data_->_tmp1_, _data_->http_server, &_data_->_inner_error0_);
		_data_->didl_object = _data_->_tmp2_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->writer);
			goto __catch0_g_error;
		}
		_data_->_tmp3_ = _data_->didl_object;
		_data_->_tmp4_ = gupnp_didl_lite_object_get_xml_node (_data_->_tmp3_);
		_data_->_tmp5_ = _data_->_tmp4_;
		_data_->_tmp6_ = _data_->didl_object;
		_data_->_tmp7_ = gupnp_didl_lite_object_get_dlna_namespace (_data_->_tmp6_);
		_data_->_tmp8_ = _data_->_tmp7_;
		rygel_media_object_clean_node (_data_->self, _data_->_tmp5_, _data_->_tmp8_);
		_data_->_tmp9_ = _data_->didl_object;
		_data_->_tmp10_ = 0;
		_data_->_tmp11_ = gee_collection_to_array ((GeeCollection*) _data_->current_fragments, &_data_->_tmp10_);
		_data_->_tmp12_ = _data_->_tmp11_;
		_data_->_tmp12__length1 = _data_->_tmp10_;
		_data_->_tmp13_ = 0;
		_data_->_tmp14_ = gee_collection_to_array ((GeeCollection*) _data_->new_fragments, &_data_->_tmp13_);
		_data_->_tmp15_ = _data_->_tmp14_;
		_data_->_tmp15__length1 = _data_->_tmp13_;
		_data_->_result_ = gupnp_didl_lite_object_apply_fragments (_data_->_tmp9_, _data_->_tmp12_, (gint) _data_->_tmp10_, _data_->_tmp15_, (gint) _data_->_tmp13_);
		_data_->_tmp15_ = (_vala_array_free (_data_->_tmp15_, _data_->_tmp15__length1, (GDestroyNotify) g_free), NULL);
		_data_->_tmp12_ = (_vala_array_free (_data_->_tmp12_, _data_->_tmp12__length1, (GDestroyNotify) g_free), NULL);
		if (_data_->_result_ == GUPNP_DIDL_LITE_FRAGMENT_RESULT_OK) {
			_data_->_tmp16_ = _data_->didl_object;
			rygel_media_object_apply_didl_lite (_data_->self, _data_->_tmp16_);
			if (RYGEL_IS_UPDATABLE_OBJECT (_data_->self)) {
				_data_->_state_ = 1;
				rygel_updatable_object_commit (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, RYGEL_TYPE_UPDATABLE_OBJECT, RygelUpdatableObject), rygel_media_object_apply_fragments_ready, _data_);
				return FALSE;
				_state_1:
				rygel_updatable_object_commit_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, RYGEL_TYPE_UPDATABLE_OBJECT, RygelUpdatableObject), _data_->_res_, &_data_->_inner_error0_);
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					_g_object_unref0 (_data_->didl_object);
					_g_object_unref0 (_data_->writer);
					goto __catch0_g_error;
				}
			}
		}
		_g_object_unref0 (_data_->didl_object);
		_g_object_unref0 (_data_->writer);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp17_ = _data_->e;
		_data_->_tmp18_ = _data_->_tmp17_->message;
		g_debug ("rygel-media-object.vala:382: Failed to apply fragments: %s. Ignoring.", _data_->_tmp18_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = _data_->_result_;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gint
rygel_media_object_real_compare_by_property (RygelMediaObject* self,
                                             RygelMediaObject* media_object,
                                             const gchar* property)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	static GQuark _tmp1_label4 = 0;
	static GQuark _tmp1_label5 = 0;
	static GQuark _tmp1_label6 = 0;
	static GQuark _tmp1_label7 = 0;
	gint result;
	g_return_val_if_fail (media_object != NULL, 0);
	g_return_val_if_fail (property != NULL, 0);
	_tmp0_ = property;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("@id")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp3_;
				const gchar* _tmp4_;
				_tmp3_ = self->priv->_id;
				_tmp4_ = media_object->priv->_id;
				result = rygel_media_object_compare_string_props (self, _tmp3_, _tmp4_);
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("@parentID")))) {
		switch (0) {
			default:
			{
				RygelMediaContainer* _tmp5_;
				RygelMediaContainer* _tmp6_;
				const gchar* _tmp7_;
				RygelMediaContainer* _tmp8_;
				RygelMediaContainer* _tmp9_;
				const gchar* _tmp10_;
				_tmp5_ = rygel_media_object_get_parent (self);
				_tmp6_ = _tmp5_;
				_tmp7_ = ((RygelMediaObject*) _tmp6_)->priv->_id;
				_tmp8_ = rygel_media_object_get_parent (media_object);
				_tmp9_ = _tmp8_;
				_tmp10_ = ((RygelMediaObject*) _tmp9_)->priv->_id;
				result = rygel_media_object_compare_string_props (self, _tmp7_, _tmp10_);
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("dc:title")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp11_;
				const gchar* _tmp12_;
				const gchar* _tmp13_;
				const gchar* _tmp14_;
				_tmp11_ = rygel_media_object_get_title (self);
				_tmp12_ = _tmp11_;
				_tmp13_ = rygel_media_object_get_title (media_object);
				_tmp14_ = _tmp13_;
				result = rygel_media_object_compare_string_props (self, _tmp12_, _tmp14_);
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("upnp:class")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp15_;
				const gchar* _tmp16_;
				_tmp15_ = self->priv->_upnp_class;
				_tmp16_ = media_object->priv->_upnp_class;
				result = rygel_media_object_compare_string_props (self, _tmp15_, _tmp16_);
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label4) ? _tmp1_label4 : (_tmp1_label4 = g_quark_from_static_string ("dc:artist")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp17_;
				const gchar* _tmp18_;
				_tmp17_ = self->priv->_artist;
				_tmp18_ = media_object->priv->_artist;
				result = rygel_media_object_compare_string_props (self, _tmp17_, _tmp18_);
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label5) ? _tmp1_label5 : (_tmp1_label5 = g_quark_from_static_string ("upnp:genre")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp19_;
				const gchar* _tmp20_;
				_tmp19_ = self->priv->_genre;
				_tmp20_ = media_object->priv->_genre;
				result = rygel_media_object_compare_string_props (self, _tmp19_, _tmp20_);
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label6) ? _tmp1_label6 : (_tmp1_label6 = g_quark_from_static_string ("dc:creator")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp21_;
				const gchar* _tmp22_;
				_tmp21_ = self->priv->_creator;
				_tmp22_ = media_object->priv->_creator;
				result = rygel_media_object_compare_string_props (self, _tmp21_, _tmp22_);
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label7) ? _tmp1_label7 : (_tmp1_label7 = g_quark_from_static_string ("dc:date")))) {
		switch (0) {
			default:
			{
				result = rygel_media_object_compare_by_date (self, media_object);
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				result = 0;
				return result;
			}
		}
	}
}

gint
rygel_media_object_compare_by_property (RygelMediaObject* self,
                                        RygelMediaObject* media_object,
                                        const gchar* property)
{
	RygelMediaObjectClass* _klass_;
	g_return_val_if_fail (self != NULL, 0);
	_klass_ = RYGEL_MEDIA_OBJECT_GET_CLASS (self);
	if (_klass_->compare_by_property) {
		return _klass_->compare_by_property (self, media_object, property);
	}
	return -1;
}

gint
rygel_media_object_compare_string_props (RygelMediaObject* self,
                                         const gchar* prop1,
                                         const gchar* prop2)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (prop1 != NULL, 0);
	g_return_val_if_fail (prop2 != NULL, 0);
	if (prop1 == NULL) {
		result = -1;
		return result;
	} else {
		if (prop2 == NULL) {
			result = 1;
			return result;
		} else {
			result = g_utf8_collate (prop1, prop2);
			return result;
		}
	}
}

gint
rygel_media_object_compare_int_props (RygelMediaObject* self,
                                      gint prop1,
                                      gint prop2)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = CLAMP (prop1 - prop2, -1, 1);
	return result;
}

static void
rygel_media_object_check_writable_data_free (gpointer _data)
{
	RygelMediaObjectCheckWritableData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->file);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelMediaObjectCheckWritableData, _data_);
}

static void
rygel_media_object_check_writable (RygelMediaObject* self,
                                   GFile* file,
                                   GCancellable* cancellable,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_)
{
	RygelMediaObjectCheckWritableData* _data_;
	RygelMediaObject* _tmp0_;
	GFile* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_data_ = g_slice_new0 (RygelMediaObjectCheckWritableData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_media_object_check_writable_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (file);
	_g_object_unref0 (_data_->file);
	_data_->file = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	rygel_media_object_check_writable_co (_data_);
}

static gboolean
rygel_media_object_check_writable_finish (RygelMediaObject* self,
                                          GAsyncResult* _res_,
                                          GError** error)
{
	gboolean result;
	RygelMediaObjectCheckWritableData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		gboolean _tmp0_ = FALSE;
		return _tmp0_;
	}
	result = _data_->result;
	return result;
}

static void
rygel_media_object_check_writable_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_)
{
	RygelMediaObjectCheckWritableData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_media_object_check_writable_co (_data_);
}

static gboolean
rygel_media_object_check_writable_co (RygelMediaObjectCheckWritableData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_file_get_uri_scheme (_data_->file);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = g_str_has_prefix (RYGEL_WRITABLE_CONTAINER_WRITABLE_SCHEME, _data_->_tmp1_);
	_g_free0 (_data_->_tmp1_);
	if (_data_->_tmp2_) {
		_data_->result = TRUE;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (!g_file_is_native (_data_->file)) {
		_data_->result = FALSE;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_state_ = 1;
		g_file_query_info_async (_data_->file, G_FILE_ATTRIBUTE_ACCESS_CAN_WRITE, G_FILE_QUERY_INFO_NONE, G_PRIORITY_DEFAULT, _data_->cancellable, rygel_media_object_check_writable_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp3_ = g_file_query_info_finish (_data_->file, _data_->_res_, &_data_->_inner_error0_);
		_data_->info = _data_->_tmp3_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			if (g_error_matches (_data_->_inner_error0_, G_IO_ERROR, G_IO_ERROR_NOT_FOUND)) {
				goto __catch0_g_io_error_not_found;
			}
			goto __finally0;
		}
		_data_->_tmp4_ = _data_->info;
		_data_->result = g_file_info_get_attribute_boolean (_data_->_tmp4_, G_FILE_ATTRIBUTE_ACCESS_CAN_WRITE);
		_g_object_unref0 (_data_->info);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	goto __finally0;
	__catch0_g_io_error_not_found:
	{
		g_clear_error (&_data_->_inner_error0_);
		_data_->result = TRUE;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gint
rygel_media_object_compare_by_date (RygelMediaObject* self,
                                    RygelMediaObject* object)
{
	const gchar* _tmp0_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (object != NULL, 0);
	_tmp0_ = self->priv->_date;
	if (_tmp0_ == NULL) {
		result = -1;
		return result;
	} else {
		const gchar* _tmp1_;
		_tmp1_ = object->priv->_date;
		if (_tmp1_ == NULL) {
			result = 1;
			return result;
		} else {
			gchar* our_date = NULL;
			const gchar* _tmp2_;
			gchar* _tmp3_;
			gchar* other_date = NULL;
			const gchar* _tmp4_;
			gchar* _tmp5_;
			const gchar* _tmp6_;
			const gchar* _tmp9_;
			GDateTime* our_date_time = NULL;
			const gchar* _tmp12_;
			GDateTime* _tmp13_;
			GDateTime* other_date_time = NULL;
			const gchar* _tmp14_;
			GDateTime* _tmp15_;
			GDateTime* _tmp16_;
			GDateTime* _tmp17_;
			_tmp2_ = self->priv->_date;
			_tmp3_ = g_strdup (_tmp2_);
			our_date = _tmp3_;
			_tmp4_ = object->priv->_date;
			_tmp5_ = g_strdup (_tmp4_);
			other_date = _tmp5_;
			_tmp6_ = our_date;
			if (!string_contains (_tmp6_, "T")) {
				const gchar* _tmp7_;
				gchar* _tmp8_;
				_tmp7_ = our_date;
				_tmp8_ = g_strconcat (_tmp7_, "T00:00:00Z", NULL);
				_g_free0 (our_date);
				our_date = _tmp8_;
			}
			_tmp9_ = other_date;
			if (!string_contains (_tmp9_, "T")) {
				const gchar* _tmp10_;
				gchar* _tmp11_;
				_tmp10_ = other_date;
				_tmp11_ = g_strconcat (_tmp10_, "T00:00:00Z", NULL);
				_g_free0 (other_date);
				other_date = _tmp11_;
			}
			_tmp12_ = our_date;
			_tmp13_ = g_date_time_new_from_iso8601 (_tmp12_, NULL);
			our_date_time = _tmp13_;
			_tmp14_ = other_date;
			_tmp15_ = g_date_time_new_from_iso8601 (_tmp14_, NULL);
			other_date_time = _tmp15_;
			_tmp16_ = our_date_time;
			_tmp17_ = other_date_time;
			result = g_date_time_compare (_tmp16_, _tmp17_);
			_g_date_time_unref0 (other_date_time);
			_g_date_time_unref0 (our_date_time);
			_g_free0 (other_date);
			_g_free0 (our_date);
			return result;
		}
	}
}

static gchar*
rygel_media_object_get_first (RygelMediaObject* self,
                              GList* contributors)
{
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (contributors != NULL) {
		gconstpointer _tmp0_;
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp0_ = contributors->data;
		_tmp1_ = gupnp_didl_lite_contributor_get_name ((GUPnPDIDLLiteContributor*) _tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_strdup (_tmp2_);
		result = _tmp3_;
		return result;
	}
	_tmp4_ = g_strdup ("");
	result = _tmp4_;
	return result;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static inline void
_g_list_free__g_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_free0_);
}

gchar*
rygel_media_object_get_protocol_for_uri (RygelMediaObject* self,
                                         const gchar* uri,
                                         GError** error)
{
	gchar* scheme = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	RygelMediaEngine* engine = NULL;
	RygelMediaEngine* _tmp3_;
	GList* schemes = NULL;
	RygelMediaEngine* _tmp4_;
	GList* _tmp5_;
	GList* _tmp6_;
	const gchar* _tmp7_;
	GCompareFunc _tmp8_;
	GList* _tmp9_;
	const gchar* _tmp10_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	_tmp0_ = g_uri_parse_scheme (uri);
	scheme = _tmp0_;
	_tmp1_ = scheme;
	if (_tmp1_ == NULL) {
		GError* _tmp2_;
		_tmp2_ = g_error_new (RYGEL_MEDIA_ITEM_ERROR, RYGEL_MEDIA_ITEM_ERROR_BAD_URI, _ ("Bad URI: %s"), uri);
		_inner_error0_ = _tmp2_;
		g_propagate_error (error, _inner_error0_);
		_g_free0 (scheme);
		return NULL;
	}
	_tmp3_ = rygel_media_engine_get_default ();
	engine = _tmp3_;
	_tmp4_ = engine;
	_tmp5_ = rygel_media_engine_get_internal_protocol_schemes (_tmp4_);
	schemes = _tmp5_;
	_tmp6_ = schemes;
	_tmp7_ = scheme;
	_tmp8_ = ((GCompareFunc) g_strcmp0);
	_tmp9_ = g_list_find_custom (_tmp6_, _tmp7_, _tmp8_);
	if (_tmp9_ != NULL) {
		result = NULL;
		(schemes == NULL) ? NULL : (schemes = (_g_list_free__g_free0_ (schemes), NULL));
		_g_object_unref0 (engine);
		_g_free0 (scheme);
		return result;
	}
	_tmp10_ = scheme;
	if (g_strcmp0 (_tmp10_, "http") == 0) {
		gchar* _tmp11_;
		_tmp11_ = g_strdup ("http-get");
		result = _tmp11_;
		(schemes == NULL) ? NULL : (schemes = (_g_list_free__g_free0_ (schemes), NULL));
		_g_object_unref0 (engine);
		_g_free0 (scheme);
		return result;
	} else {
		const gchar* _tmp12_;
		_tmp12_ = scheme;
		if (g_strcmp0 (_tmp12_, "file") == 0) {
			gchar* _tmp13_;
			_tmp13_ = g_strdup ("internal");
			result = _tmp13_;
			(schemes == NULL) ? NULL : (schemes = (_g_list_free__g_free0_ (schemes), NULL));
			_g_object_unref0 (engine);
			_g_free0 (scheme);
			return result;
		} else {
			const gchar* _tmp14_;
			_tmp14_ = scheme;
			if (g_strcmp0 (_tmp14_, "rtsp") == 0) {
				gchar* _tmp15_;
				_tmp15_ = g_strdup ("rtsp-rtp-udp");
				result = _tmp15_;
				(schemes == NULL) ? NULL : (schemes = (_g_list_free__g_free0_ (schemes), NULL));
				_g_object_unref0 (engine);
				_g_free0 (scheme);
				return result;
			} else {
				const gchar* _tmp16_;
				_tmp16_ = scheme;
				g_debug ("Could not translate protocol scheme for  %s. " " Using '%s' as-is", uri, _tmp16_);
				result = scheme;
				(schemes == NULL) ? NULL : (schemes = (_g_list_free__g_free0_ (schemes), NULL));
				_g_object_unref0 (engine);
				return result;
			}
		}
	}
}

RygelMediaObject*
rygel_media_object_construct (GType object_type)
{
	RygelMediaObject * self = NULL;
	self = (RygelMediaObject*) g_object_new (object_type, NULL);
	return self;
}

const gchar*
rygel_media_object_get_id (RygelMediaObject* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_id;
	result = _tmp0_;
	return result;
}

void
rygel_media_object_set_id (RygelMediaObject* self,
                           const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = rygel_media_object_get_id (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_id);
		self->priv->_id = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_media_object_properties[RYGEL_MEDIA_OBJECT_ID_PROPERTY]);
	}
}

const gchar*
rygel_media_object_get_ref_id (RygelMediaObject* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_ref_id;
	result = _tmp0_;
	return result;
}

void
rygel_media_object_set_ref_id (RygelMediaObject* self,
                               const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = rygel_media_object_get_ref_id (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_ref_id);
		self->priv->_ref_id = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_media_object_properties[RYGEL_MEDIA_OBJECT_REF_ID_PROPERTY]);
	}
}

const gchar*
rygel_media_object_get_upnp_class (RygelMediaObject* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_upnp_class;
	result = _tmp0_;
	return result;
}

void
rygel_media_object_set_upnp_class (RygelMediaObject* self,
                                   const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = rygel_media_object_get_upnp_class (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_upnp_class);
		self->priv->_upnp_class = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_media_object_properties[RYGEL_MEDIA_OBJECT_UPNP_CLASS_PROPERTY]);
	}
}

const gchar*
rygel_media_object_get_date (RygelMediaObject* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_date;
	result = _tmp0_;
	return result;
}

void
rygel_media_object_set_date (RygelMediaObject* self,
                             const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = rygel_media_object_get_date (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_date);
		self->priv->_date = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_media_object_properties[RYGEL_MEDIA_OBJECT_DATE_PROPERTY]);
	}
}

const gchar*
rygel_media_object_get_creator (RygelMediaObject* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_creator;
	result = _tmp0_;
	return result;
}

void
rygel_media_object_set_creator (RygelMediaObject* self,
                                const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = rygel_media_object_get_creator (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_creator);
		self->priv->_creator = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_media_object_properties[RYGEL_MEDIA_OBJECT_CREATOR_PROPERTY]);
	}
}

guint64
rygel_media_object_get_modified (RygelMediaObject* self)
{
	guint64 result;
	g_return_val_if_fail (self != NULL, 0ULL);
	result = self->priv->_modified;
	return result;
}

void
rygel_media_object_set_modified (RygelMediaObject* self,
                                 guint64 value)
{
	guint64 old_value;
	g_return_if_fail (self != NULL);
	old_value = rygel_media_object_get_modified (self);
	if (old_value != value) {
		self->priv->_modified = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_media_object_properties[RYGEL_MEDIA_OBJECT_MODIFIED_PROPERTY]);
	}
}

guint
rygel_media_object_get_object_update_id (RygelMediaObject* self)
{
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_object_update_id;
	return result;
}

void
rygel_media_object_set_object_update_id (RygelMediaObject* self,
                                         guint value)
{
	guint old_value;
	g_return_if_fail (self != NULL);
	old_value = rygel_media_object_get_object_update_id (self);
	if (old_value != value) {
		self->priv->_object_update_id = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_media_object_properties[RYGEL_MEDIA_OBJECT_OBJECT_UPDATE_ID_PROPERTY]);
	}
}

const gchar*
rygel_media_object_get_artist (RygelMediaObject* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_artist;
	result = _tmp0_;
	return result;
}

void
rygel_media_object_set_artist (RygelMediaObject* self,
                               const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = rygel_media_object_get_artist (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_artist);
		self->priv->_artist = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_media_object_properties[RYGEL_MEDIA_OBJECT_ARTIST_PROPERTY]);
	}
}

const gchar*
rygel_media_object_get_genre (RygelMediaObject* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_genre;
	result = _tmp0_;
	return result;
}

void
rygel_media_object_set_genre (RygelMediaObject* self,
                              const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = rygel_media_object_get_genre (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_genre);
		self->priv->_genre = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_media_object_properties[RYGEL_MEDIA_OBJECT_GENRE_PROPERTY]);
	}
}

RygelMediaContainer*
rygel_media_object_get_parent (RygelMediaObject* self)
{
	RygelMediaContainer* result;
	RygelMediaContainer* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->parent_ptr;
	result = _tmp0_;
	return result;
}

void
rygel_media_object_set_parent (RygelMediaObject* self,
                               RygelMediaContainer* value)
{
	g_return_if_fail (self != NULL);
	self->parent_ptr = value;
	g_object_notify_by_pspec ((GObject *) self, rygel_media_object_properties[RYGEL_MEDIA_OBJECT_PARENT_PROPERTY]);
}

RygelMediaContainer*
rygel_media_object_get_parent_ref (RygelMediaObject* self)
{
	RygelMediaContainer* result;
	RygelMediaContainer* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_parent_ref;
	result = _tmp0_;
	return result;
}

void
rygel_media_object_set_parent_ref (RygelMediaObject* self,
                                   RygelMediaContainer* value)
{
	RygelMediaContainer* _tmp0_;
	g_return_if_fail (self != NULL);
	rygel_media_object_set_parent (self, value);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_parent_ref);
	self->priv->_parent_ref = _tmp0_;
	g_object_notify_by_pspec ((GObject *) self, rygel_media_object_properties[RYGEL_MEDIA_OBJECT_PARENT_REF_PROPERTY]);
}

const gchar*
rygel_media_object_get_title (RygelMediaObject* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_title;
	result = _tmp0_;
	return result;
}

void
rygel_media_object_set_title (RygelMediaObject* self,
                              const gchar* value)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		gchar* _tmp0_ = NULL;
		GRegex* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_ = NULL;
		GRegex* _tmp12_;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_ = NULL;
		GRegex* _tmp18_;
		const gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		_tmp1_ = rygel_media_object_real_name_regex;
		_tmp2_ = g_get_real_name ();
		_tmp3_ = g_regex_replace_literal (_tmp1_, value, (gssize) -1, 0, _tmp2_, 0, &_inner_error0_);
		_tmp0_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp4_ = _tmp0_;
		_tmp0_ = NULL;
		_g_free0 (self->priv->_title);
		self->priv->_title = _tmp4_;
		_tmp6_ = rygel_media_object_user_name_regex;
		_tmp7_ = self->priv->_title;
		_tmp8_ = g_get_user_name ();
		_tmp9_ = g_regex_replace_literal (_tmp6_, _tmp7_, (gssize) -1, 0, _tmp8_, 0, &_inner_error0_);
		_tmp5_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp0_);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp10_ = _tmp5_;
		_tmp5_ = NULL;
		_g_free0 (self->priv->_title);
		self->priv->_title = _tmp10_;
		_tmp12_ = rygel_media_object_host_name_regex;
		_tmp13_ = self->priv->_title;
		_tmp14_ = g_get_host_name ();
		_tmp15_ = g_regex_replace_literal (_tmp12_, _tmp13_, (gssize) -1, 0, _tmp14_, 0, &_inner_error0_);
		_tmp11_ = _tmp15_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp5_);
			_g_free0 (_tmp0_);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp16_ = _tmp11_;
		_tmp11_ = NULL;
		_g_free0 (self->priv->_title);
		self->priv->_title = _tmp16_;
		_tmp18_ = rygel_media_object_pretty_name_regex;
		_tmp19_ = self->priv->_title;
		_tmp20_ = rygel_get_pretty_host_name ();
		_tmp21_ = _tmp20_;
		_tmp22_ = g_regex_replace_literal (_tmp18_, _tmp19_, (gssize) -1, 0, _tmp21_, 0, &_inner_error0_);
		_tmp23_ = _tmp22_;
		_g_free0 (_tmp21_);
		_tmp17_ = _tmp23_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp11_);
			_g_free0 (_tmp5_);
			_g_free0 (_tmp0_);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp24_ = _tmp17_;
		_tmp17_ = NULL;
		_g_free0 (self->priv->_title);
		self->priv->_title = _tmp24_;
		_g_free0 (_tmp17_);
		_g_free0 (_tmp11_);
		_g_free0 (_tmp5_);
		_g_free0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	g_object_notify_by_pspec ((GObject *) self, rygel_media_object_properties[RYGEL_MEDIA_OBJECT_TITLE_PROPERTY]);
}

GUPnPOCMFlags
rygel_media_object_get_ocm_flags (RygelMediaObject* self)
{
	RygelMediaObjectClass* _klass_;
	g_return_val_if_fail (self != NULL, 0U);
	_klass_ = RYGEL_MEDIA_OBJECT_GET_CLASS (self);
	if (_klass_->get_ocm_flags) {
		return _klass_->get_ocm_flags (self);
	}
	return 0U;
}

static GUPnPOCMFlags
rygel_media_object_real_get_ocm_flags (RygelMediaObject* base)
{
	GUPnPOCMFlags result;
	RygelMediaObject* self;
	self = base;
	result = GUPNP_OCM_FLAGS_NONE;
	return result;
}

gboolean
rygel_media_object_get_restricted (RygelMediaObject* self)
{
	gboolean result;
	GUPnPOCMFlags _tmp0_;
	GUPnPOCMFlags _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = rygel_media_object_get_ocm_flags (self);
	_tmp1_ = _tmp0_;
	result = _tmp1_ == GUPNP_OCM_FLAGS_NONE;
	return result;
}

static void
rygel_media_object_class_init (RygelMediaObjectClass * klass,
                               gpointer klass_data)
{
	GError* _inner_error0_ = NULL;
	rygel_media_object_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelMediaObject_private_offset);
	((RygelMediaObjectClass *) klass)->add_uri = (void (*) (RygelMediaObject*, const gchar*)) rygel_media_object_real_add_uri;
	((GObjectClass *) klass)->constructed = (void (*) (GObject*)) rygel_media_object_real_constructed;
	((RygelMediaObjectClass *) klass)->serialize = (GUPnPDIDLLiteObject* (*) (RygelMediaObject*, RygelSerializer*, RygelHTTPServer*, GError**)) rygel_media_object_real_serialize;
	((RygelMediaObjectClass *) klass)->create_stream_source_for_resource = (RygelDataSource* (*) (RygelMediaObject*, RygelHTTPRequest*, RygelMediaResource*, GError**)) rygel_media_object_real_create_stream_source_for_resource;
	((RygelMediaObjectClass *) klass)->apply_didl_lite = (void (*) (RygelMediaObject*, GUPnPDIDLLiteObject*)) rygel_media_object_real_apply_didl_lite;
	((RygelMediaObjectClass *) klass)->compare_by_property = (gint (*) (RygelMediaObject*, RygelMediaObject*, const gchar*)) rygel_media_object_real_compare_by_property;
	RYGEL_MEDIA_OBJECT_CLASS (klass)->get_ocm_flags = rygel_media_object_real_get_ocm_flags;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_media_object_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_media_object_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_media_object_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_OBJECT_ID_PROPERTY, rygel_media_object_properties[RYGEL_MEDIA_OBJECT_ID_PROPERTY] = g_param_spec_string ("id", "id", "id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_OBJECT_REF_ID_PROPERTY, rygel_media_object_properties[RYGEL_MEDIA_OBJECT_REF_ID_PROPERTY] = g_param_spec_string ("ref-id", "ref-id", "ref-id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_OBJECT_UPNP_CLASS_PROPERTY, rygel_media_object_properties[RYGEL_MEDIA_OBJECT_UPNP_CLASS_PROPERTY] = g_param_spec_string ("upnp-class", "upnp-class", "upnp-class", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_OBJECT_DATE_PROPERTY, rygel_media_object_properties[RYGEL_MEDIA_OBJECT_DATE_PROPERTY] = g_param_spec_string ("date", "date", "date", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_OBJECT_CREATOR_PROPERTY, rygel_media_object_properties[RYGEL_MEDIA_OBJECT_CREATOR_PROPERTY] = g_param_spec_string ("creator", "creator", "creator", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_OBJECT_MODIFIED_PROPERTY, rygel_media_object_properties[RYGEL_MEDIA_OBJECT_MODIFIED_PROPERTY] = g_param_spec_uint64 ("modified", "modified", "modified", 0, G_MAXUINT64, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_OBJECT_OBJECT_UPDATE_ID_PROPERTY, rygel_media_object_properties[RYGEL_MEDIA_OBJECT_OBJECT_UPDATE_ID_PROPERTY] = g_param_spec_uint ("object-update-id", "object-update-id", "object-update-id", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_OBJECT_ARTIST_PROPERTY, rygel_media_object_properties[RYGEL_MEDIA_OBJECT_ARTIST_PROPERTY] = g_param_spec_string ("artist", "artist", "artist", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_OBJECT_GENRE_PROPERTY, rygel_media_object_properties[RYGEL_MEDIA_OBJECT_GENRE_PROPERTY] = g_param_spec_string ("genre", "genre", "genre", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_OBJECT_PARENT_PROPERTY, rygel_media_object_properties[RYGEL_MEDIA_OBJECT_PARENT_PROPERTY] = g_param_spec_object ("parent", "parent", "parent", RYGEL_TYPE_MEDIA_CONTAINER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_OBJECT_PARENT_REF_PROPERTY, rygel_media_object_properties[RYGEL_MEDIA_OBJECT_PARENT_REF_PROPERTY] = g_param_spec_object ("parent-ref", "parent-ref", "parent-ref", RYGEL_TYPE_MEDIA_CONTAINER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * The human-readable title of this container or item.
	     * These variables will be substituted:
	     *
	     *  - @@REALNAME@ will be substituted by the user's real name.
	     *  - @@USERNAME@ will be substituted by the users's login ID.
	     *  - @@HOSTNAME@ will be substituted by the name of the machine.
	     *  - @@ADDRESS@ will be substituted by the IP address of network interface
	     *    used for the UPnP communication.
	     *  - @@PRETTY_HOSTNAME@ will be substituted by the human readable name of the machine
	     *    (PRETTY_HOSTNAME field of /etc/machine-info)
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_OBJECT_TITLE_PROPERTY, rygel_media_object_properties[RYGEL_MEDIA_OBJECT_TITLE_PROPERTY] = g_param_spec_string ("title", "title", "title", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_OBJECT_OCM_FLAGS_PROPERTY, rygel_media_object_properties[RYGEL_MEDIA_OBJECT_OCM_FLAGS_PROPERTY] = g_param_spec_flags ("ocm-flags", "ocm-flags", "ocm-flags", gupnp_ocm_flags_get_type (), 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_OBJECT_RESTRICTED_PROPERTY, rygel_media_object_properties[RYGEL_MEDIA_OBJECT_RESTRICTED_PROPERTY] = g_param_spec_boolean ("restricted", "restricted", "restricted", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	{
		GRegex* _tmp0_ = NULL;
		gchar* _tmp1_;
		gchar* _tmp2_;
		GRegex* _tmp3_;
		GRegex* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_ = NULL;
		gchar* _tmp7_;
		gchar* _tmp8_;
		GRegex* _tmp9_;
		GRegex* _tmp10_;
		GRegex* _tmp11_;
		GRegex* _tmp12_ = NULL;
		gchar* _tmp13_;
		gchar* _tmp14_;
		GRegex* _tmp15_;
		GRegex* _tmp16_;
		GRegex* _tmp17_;
		GRegex* _tmp18_ = NULL;
		gchar* _tmp19_;
		gchar* _tmp20_;
		GRegex* _tmp21_;
		GRegex* _tmp22_;
		GRegex* _tmp23_;
		_tmp1_ = g_regex_escape_string ("@REALNAME@", -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error0_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		_tmp0_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
		}
		_tmp5_ = _tmp0_;
		_tmp0_ = NULL;
		_g_regex_unref0 (rygel_media_object_real_name_regex);
		rygel_media_object_real_name_regex = _tmp5_;
		_tmp7_ = g_regex_escape_string ("@USERNAME@", -1);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_regex_new (_tmp8_, 0, 0, &_inner_error0_);
		_tmp10_ = _tmp9_;
		_g_free0 (_tmp8_);
		_tmp6_ = _tmp10_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (_tmp0_);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
		}
		_tmp11_ = _tmp6_;
		_tmp6_ = NULL;
		_g_regex_unref0 (rygel_media_object_user_name_regex);
		rygel_media_object_user_name_regex = _tmp11_;
		_tmp13_ = g_regex_escape_string ("@HOSTNAME@", -1);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_regex_new (_tmp14_, 0, 0, &_inner_error0_);
		_tmp16_ = _tmp15_;
		_g_free0 (_tmp14_);
		_tmp12_ = _tmp16_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (_tmp6_);
			_g_regex_unref0 (_tmp0_);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
		}
		_tmp17_ = _tmp12_;
		_tmp12_ = NULL;
		_g_regex_unref0 (rygel_media_object_host_name_regex);
		rygel_media_object_host_name_regex = _tmp17_;
		_tmp19_ = g_regex_escape_string ("@PRETTY_HOSTNAME@", -1);
		_tmp20_ = _tmp19_;
		_tmp21_ = g_regex_new (_tmp20_, 0, 0, &_inner_error0_);
		_tmp22_ = _tmp21_;
		_g_free0 (_tmp20_);
		_tmp18_ = _tmp22_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (_tmp12_);
			_g_regex_unref0 (_tmp6_);
			_g_regex_unref0 (_tmp0_);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
		}
		_tmp23_ = _tmp18_;
		_tmp18_ = NULL;
		_g_regex_unref0 (rygel_media_object_pretty_name_regex);
		rygel_media_object_pretty_name_regex = _tmp23_;
		_g_regex_unref0 (_tmp18_);
		_g_regex_unref0 (_tmp12_);
		_g_regex_unref0 (_tmp6_);
		_g_regex_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
}

static void
rygel_media_object_instance_init (RygelMediaObject * self,
                                  gpointer klass)
{
	GeeLinkedList* _tmp0_;
	self->priv = rygel_media_object_get_instance_private (self);
	_tmp0_ = gee_linked_list_new (RYGEL_TYPE_MEDIA_RESOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->priv->media_resources = (GeeList*) _tmp0_;
}

static void
rygel_media_object_finalize (GObject * obj)
{
	RygelMediaObject * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject);
	_g_free0 (self->priv->_id);
	_g_free0 (self->priv->_ref_id);
	_g_free0 (self->priv->_upnp_class);
	_g_free0 (self->priv->_date);
	_g_free0 (self->priv->_creator);
	_g_free0 (self->priv->_artist);
	_g_free0 (self->priv->_genre);
	_g_object_unref0 (self->priv->uris);
	_g_object_unref0 (self->priv->media_resources);
	_g_object_unref0 (self->priv->_parent_ref);
	_g_free0 (self->priv->_title);
	G_OBJECT_CLASS (rygel_media_object_parent_class)->finalize (obj);
}

/**
 * Represents a media object (container or item).
 *
 * The derived RygelMediaContainer class represents a container
 * and the derived MediaItem classes represent media items.
 */
static GType
rygel_media_object_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelMediaObjectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_object_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaObject), 0, (GInstanceInitFunc) rygel_media_object_instance_init, NULL };
	GType rygel_media_object_type_id;
	rygel_media_object_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaObject", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	RygelMediaObject_private_offset = g_type_add_instance_private (rygel_media_object_type_id, sizeof (RygelMediaObjectPrivate));
	return rygel_media_object_type_id;
}

GType
rygel_media_object_get_type (void)
{
	static volatile gsize rygel_media_object_type_id__once = 0;
	if (g_once_init_enter (&rygel_media_object_type_id__once)) {
		GType rygel_media_object_type_id;
		rygel_media_object_type_id = rygel_media_object_get_type_once ();
		g_once_init_leave (&rygel_media_object_type_id__once, rygel_media_object_type_id);
	}
	return rygel_media_object_type_id__once;
}

static void
_vala_rygel_media_object_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	RygelMediaObject * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject);
	switch (property_id) {
		case RYGEL_MEDIA_OBJECT_ID_PROPERTY:
		g_value_set_string (value, rygel_media_object_get_id (self));
		break;
		case RYGEL_MEDIA_OBJECT_REF_ID_PROPERTY:
		g_value_set_string (value, rygel_media_object_get_ref_id (self));
		break;
		case RYGEL_MEDIA_OBJECT_UPNP_CLASS_PROPERTY:
		g_value_set_string (value, rygel_media_object_get_upnp_class (self));
		break;
		case RYGEL_MEDIA_OBJECT_DATE_PROPERTY:
		g_value_set_string (value, rygel_media_object_get_date (self));
		break;
		case RYGEL_MEDIA_OBJECT_CREATOR_PROPERTY:
		g_value_set_string (value, rygel_media_object_get_creator (self));
		break;
		case RYGEL_MEDIA_OBJECT_MODIFIED_PROPERTY:
		g_value_set_uint64 (value, rygel_media_object_get_modified (self));
		break;
		case RYGEL_MEDIA_OBJECT_OBJECT_UPDATE_ID_PROPERTY:
		g_value_set_uint (value, rygel_media_object_get_object_update_id (self));
		break;
		case RYGEL_MEDIA_OBJECT_ARTIST_PROPERTY:
		g_value_set_string (value, rygel_media_object_get_artist (self));
		break;
		case RYGEL_MEDIA_OBJECT_GENRE_PROPERTY:
		g_value_set_string (value, rygel_media_object_get_genre (self));
		break;
		case RYGEL_MEDIA_OBJECT_PARENT_PROPERTY:
		g_value_set_object (value, rygel_media_object_get_parent (self));
		break;
		case RYGEL_MEDIA_OBJECT_PARENT_REF_PROPERTY:
		g_value_set_object (value, rygel_media_object_get_parent_ref (self));
		break;
		case RYGEL_MEDIA_OBJECT_TITLE_PROPERTY:
		g_value_set_string (value, rygel_media_object_get_title (self));
		break;
		case RYGEL_MEDIA_OBJECT_OCM_FLAGS_PROPERTY:
		g_value_set_flags (value, rygel_media_object_get_ocm_flags (self));
		break;
		case RYGEL_MEDIA_OBJECT_RESTRICTED_PROPERTY:
		g_value_set_boolean (value, rygel_media_object_get_restricted (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_rygel_media_object_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec)
{
	RygelMediaObject * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject);
	switch (property_id) {
		case RYGEL_MEDIA_OBJECT_ID_PROPERTY:
		rygel_media_object_set_id (self, g_value_get_string (value));
		break;
		case RYGEL_MEDIA_OBJECT_REF_ID_PROPERTY:
		rygel_media_object_set_ref_id (self, g_value_get_string (value));
		break;
		case RYGEL_MEDIA_OBJECT_UPNP_CLASS_PROPERTY:
		rygel_media_object_set_upnp_class (self, g_value_get_string (value));
		break;
		case RYGEL_MEDIA_OBJECT_DATE_PROPERTY:
		rygel_media_object_set_date (self, g_value_get_string (value));
		break;
		case RYGEL_MEDIA_OBJECT_CREATOR_PROPERTY:
		rygel_media_object_set_creator (self, g_value_get_string (value));
		break;
		case RYGEL_MEDIA_OBJECT_MODIFIED_PROPERTY:
		rygel_media_object_set_modified (self, g_value_get_uint64 (value));
		break;
		case RYGEL_MEDIA_OBJECT_OBJECT_UPDATE_ID_PROPERTY:
		rygel_media_object_set_object_update_id (self, g_value_get_uint (value));
		break;
		case RYGEL_MEDIA_OBJECT_ARTIST_PROPERTY:
		rygel_media_object_set_artist (self, g_value_get_string (value));
		break;
		case RYGEL_MEDIA_OBJECT_GENRE_PROPERTY:
		rygel_media_object_set_genre (self, g_value_get_string (value));
		break;
		case RYGEL_MEDIA_OBJECT_PARENT_PROPERTY:
		rygel_media_object_set_parent (self, g_value_get_object (value));
		break;
		case RYGEL_MEDIA_OBJECT_PARENT_REF_PROPERTY:
		rygel_media_object_set_parent_ref (self, g_value_get_object (value));
		break;
		case RYGEL_MEDIA_OBJECT_TITLE_PROPERTY:
		rygel_media_object_set_title (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

