/* rygel-serializer.c generated by valac 0.56.1, the Vala compiler
 * generated from rygel-serializer.vala, do not modify */

/*
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Jens Georg <jensg@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "rygel-server.h"
#include <libgupnp-av/gupnp-av.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#define RYGEL_TYPE_M3_UPLAY_LIST (rygel_m3_uplay_list_get_type ())
#define RYGEL_M3_UPLAY_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_M3_UPLAY_LIST, RygelM3UPlayList))
#define RYGEL_M3_UPLAY_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_M3_UPLAY_LIST, RygelM3UPlayListClass))
#define RYGEL_IS_M3_UPLAY_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_M3_UPLAY_LIST))
#define RYGEL_IS_M3_UPLAY_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_M3_UPLAY_LIST))
#define RYGEL_M3_UPLAY_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_M3_UPLAY_LIST, RygelM3UPlayListClass))

typedef struct _RygelM3UPlayList RygelM3UPlayList;
typedef struct _RygelM3UPlayListClass RygelM3UPlayListClass;
enum  {
	RYGEL_SERIALIZER_0_PROPERTY,
	RYGEL_SERIALIZER_SERIALIZER_TYPE_PROPERTY,
	RYGEL_SERIALIZER_NUM_PROPERTIES
};
static GParamSpec* rygel_serializer_properties[RYGEL_SERIALIZER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _RygelSerializerPrivate {
	GUPnPDIDLLiteWriter* writer;
	GUPnPMediaCollection* collection;
	RygelM3UPlayList* playlist;
	RygelSerializerType _serializer_type;
};

static gint RygelSerializer_private_offset;
static gpointer rygel_serializer_parent_class = NULL;

VALA_EXTERN GType rygel_m3_uplay_list_get_type (void) G_GNUC_CONST ;
static void rygel_serializer_real_constructed (GObject* base);
static RygelSerializerType rygel_serializer_get_serializer_type (RygelSerializer* self);
VALA_EXTERN RygelM3UPlayList* rygel_m3_uplay_list_new (void);
VALA_EXTERN RygelM3UPlayList* rygel_m3_uplay_list_construct (GType object_type);
VALA_EXTERN GUPnPDIDLLiteItem* rygel_m3_uplay_list_add_item (RygelM3UPlayList* self);
VALA_EXTERN gchar* rygel_m3_uplay_list_get_string (RygelM3UPlayList* self);
static void rygel_serializer_finalize (GObject * obj);
static GType rygel_serializer_get_type_once (void);
static void _vala_rygel_serializer_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec);
static void _vala_rygel_serializer_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static GType
rygel_serializer_type_get_type_once (void)
{
	static const GEnumValue values[] = {{RYGEL_SERIALIZER_TYPE_GENERIC_DIDL, "RYGEL_SERIALIZER_TYPE_GENERIC_DIDL", "generic-didl"}, {RYGEL_SERIALIZER_TYPE_DIDL_S, "RYGEL_SERIALIZER_TYPE_DIDL_S", "didl-s"}, {RYGEL_SERIALIZER_TYPE_M3UEXT, "RYGEL_SERIALIZER_TYPE_M3UEXT", "m3uext"}, {0, NULL, NULL}};
	GType rygel_serializer_type_type_id;
	rygel_serializer_type_type_id = g_enum_register_static ("RygelSerializerType", values);
	return rygel_serializer_type_type_id;
}

GType
rygel_serializer_type_get_type (void)
{
	static volatile gsize rygel_serializer_type_type_id__once = 0;
	if (g_once_init_enter (&rygel_serializer_type_type_id__once)) {
		GType rygel_serializer_type_type_id;
		rygel_serializer_type_type_id = rygel_serializer_type_get_type_once ();
		g_once_init_leave (&rygel_serializer_type_type_id__once, rygel_serializer_type_type_id);
	}
	return rygel_serializer_type_type_id__once;
}

static inline gpointer
rygel_serializer_get_instance_private (RygelSerializer* self)
{
	return G_STRUCT_MEMBER_P (self, RygelSerializer_private_offset);
}

RygelSerializer*
rygel_serializer_construct (GType object_type,
                            RygelSerializerType type)
{
	RygelSerializer * self = NULL;
	self = (RygelSerializer*) g_object_new (object_type, "serializer-type", type, NULL);
	return self;
}

RygelSerializer*
rygel_serializer_new (RygelSerializerType type)
{
	return rygel_serializer_construct (RYGEL_TYPE_SERIALIZER, type);
}

static void
rygel_serializer_real_constructed (GObject* base)
{
	RygelSerializer * self;
	RygelSerializerType _tmp0_;
	self = (RygelSerializer*) base;
	_tmp0_ = self->priv->_serializer_type;
	switch (_tmp0_) {
		case RYGEL_SERIALIZER_TYPE_GENERIC_DIDL:
		{
			GUPnPDIDLLiteWriter* _tmp1_;
			_tmp1_ = gupnp_didl_lite_writer_new (NULL);
			_g_object_unref0 (self->priv->writer);
			self->priv->writer = _tmp1_;
			break;
		}
		case RYGEL_SERIALIZER_TYPE_DIDL_S:
		{
			GUPnPMediaCollection* _tmp2_;
			_tmp2_ = gupnp_media_collection_new ();
			_g_object_unref0 (self->priv->collection);
			self->priv->collection = _tmp2_;
			break;
		}
		case RYGEL_SERIALIZER_TYPE_M3UEXT:
		{
			RygelM3UPlayList* _tmp3_;
			_tmp3_ = rygel_m3_uplay_list_new ();
			_g_object_unref0 (self->priv->playlist);
			self->priv->playlist = _tmp3_;
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	G_OBJECT_CLASS (rygel_serializer_parent_class)->constructed (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject));
}

GUPnPDIDLLiteItem*
rygel_serializer_add_item (RygelSerializer* self)
{
	RygelSerializerType _tmp0_;
	GUPnPDIDLLiteItem* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_serializer_type;
	switch (_tmp0_) {
		case RYGEL_SERIALIZER_TYPE_GENERIC_DIDL:
		{
			GUPnPDIDLLiteWriter* _tmp1_;
			GUPnPDIDLLiteItem* _tmp2_;
			_tmp1_ = self->priv->writer;
			_tmp2_ = gupnp_didl_lite_writer_add_item (_tmp1_);
			result = _tmp2_;
			return result;
		}
		case RYGEL_SERIALIZER_TYPE_DIDL_S:
		{
			GUPnPMediaCollection* _tmp3_;
			GUPnPDIDLLiteItem* _tmp4_;
			_tmp3_ = self->priv->collection;
			_tmp4_ = gupnp_media_collection_add_item (_tmp3_);
			result = _tmp4_;
			return result;
		}
		case RYGEL_SERIALIZER_TYPE_M3UEXT:
		{
			RygelM3UPlayList* _tmp5_;
			GUPnPDIDLLiteItem* _tmp6_;
			_tmp5_ = self->priv->playlist;
			_tmp6_ = rygel_m3_uplay_list_add_item (_tmp5_);
			result = _tmp6_;
			return result;
		}
		default:
		{
			result = NULL;
			return result;
		}
	}
}

GUPnPDIDLLiteContainer*
rygel_serializer_add_container (RygelSerializer* self)
{
	GUPnPDIDLLiteWriter* _tmp0_;
	GUPnPDIDLLiteContainer* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->writer;
	if (_tmp0_ != NULL) {
		GUPnPDIDLLiteWriter* _tmp1_;
		GUPnPDIDLLiteContainer* _tmp2_;
		_tmp1_ = self->priv->writer;
		_tmp2_ = gupnp_didl_lite_writer_add_container (_tmp1_);
		result = _tmp2_;
		return result;
	} else {
		result = NULL;
		return result;
	}
}

void
rygel_serializer_filter (RygelSerializer* self,
                         const gchar* filter_string)
{
	GUPnPDIDLLiteWriter* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (filter_string != NULL);
	_tmp0_ = self->priv->writer;
	if (_tmp0_ != NULL) {
		GUPnPDIDLLiteWriter* _tmp1_;
		_tmp1_ = self->priv->writer;
		gupnp_didl_lite_writer_filter (_tmp1_, filter_string);
	}
}

gchar*
rygel_serializer_get_string (RygelSerializer* self)
{
	RygelSerializerType _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_serializer_type;
	switch (_tmp0_) {
		case RYGEL_SERIALIZER_TYPE_GENERIC_DIDL:
		{
			GUPnPDIDLLiteWriter* _tmp1_;
			gchar* _tmp2_;
			_tmp1_ = self->priv->writer;
			_tmp2_ = gupnp_didl_lite_writer_get_string (_tmp1_);
			result = _tmp2_;
			return result;
		}
		case RYGEL_SERIALIZER_TYPE_DIDL_S:
		{
			GUPnPMediaCollection* _tmp3_;
			gchar* _tmp4_;
			_tmp3_ = self->priv->collection;
			_tmp4_ = gupnp_media_collection_get_string (_tmp3_);
			result = _tmp4_;
			return result;
		}
		case RYGEL_SERIALIZER_TYPE_M3UEXT:
		{
			RygelM3UPlayList* _tmp5_;
			gchar* _tmp6_;
			_tmp5_ = self->priv->playlist;
			_tmp6_ = rygel_m3_uplay_list_get_string (_tmp5_);
			result = _tmp6_;
			return result;
		}
		default:
		{
			gchar* _tmp7_;
			_tmp7_ = g_strdup ("");
			result = _tmp7_;
			return result;
		}
	}
}

static RygelSerializerType
rygel_serializer_get_serializer_type (RygelSerializer* self)
{
	RygelSerializerType result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_serializer_type;
	return result;
}

static void
rygel_serializer_set_serializer_type (RygelSerializer* self,
                                      RygelSerializerType value)
{
	RygelSerializerType old_value;
	g_return_if_fail (self != NULL);
	old_value = rygel_serializer_get_serializer_type (self);
	if (old_value != value) {
		self->priv->_serializer_type = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_serializer_properties[RYGEL_SERIALIZER_SERIALIZER_TYPE_PROPERTY]);
	}
}

static void
rygel_serializer_class_init (RygelSerializerClass * klass,
                             gpointer klass_data)
{
	rygel_serializer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelSerializer_private_offset);
	((GObjectClass *) klass)->constructed = (void (*) (GObject*)) rygel_serializer_real_constructed;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_serializer_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_serializer_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_serializer_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_SERIALIZER_SERIALIZER_TYPE_PROPERTY, rygel_serializer_properties[RYGEL_SERIALIZER_SERIALIZER_TYPE_PROPERTY] = g_param_spec_enum ("serializer-type", "serializer-type", "serializer-type", RYGEL_TYPE_SERIALIZER_TYPE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
rygel_serializer_instance_init (RygelSerializer * self,
                                gpointer klass)
{
	self->priv = rygel_serializer_get_instance_private (self);
}

static void
rygel_serializer_finalize (GObject * obj)
{
	RygelSerializer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_SERIALIZER, RygelSerializer);
	_g_object_unref0 (self->priv->writer);
	_g_object_unref0 (self->priv->collection);
	_g_object_unref0 (self->priv->playlist);
	G_OBJECT_CLASS (rygel_serializer_parent_class)->finalize (obj);
}

/**
 * Proxy class hiding the different serializers (DIDL, DIDL_S, M3U) behind a
 * single implementation.
 */
static GType
rygel_serializer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelSerializerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_serializer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelSerializer), 0, (GInstanceInitFunc) rygel_serializer_instance_init, NULL };
	GType rygel_serializer_type_id;
	rygel_serializer_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelSerializer", &g_define_type_info, 0);
	RygelSerializer_private_offset = g_type_add_instance_private (rygel_serializer_type_id, sizeof (RygelSerializerPrivate));
	return rygel_serializer_type_id;
}

GType
rygel_serializer_get_type (void)
{
	static volatile gsize rygel_serializer_type_id__once = 0;
	if (g_once_init_enter (&rygel_serializer_type_id__once)) {
		GType rygel_serializer_type_id;
		rygel_serializer_type_id = rygel_serializer_get_type_once ();
		g_once_init_leave (&rygel_serializer_type_id__once, rygel_serializer_type_id);
	}
	return rygel_serializer_type_id__once;
}

static void
_vala_rygel_serializer_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec)
{
	RygelSerializer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_SERIALIZER, RygelSerializer);
	switch (property_id) {
		case RYGEL_SERIALIZER_SERIALIZER_TYPE_PROPERTY:
		g_value_set_enum (value, rygel_serializer_get_serializer_type (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_rygel_serializer_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec)
{
	RygelSerializer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_SERIALIZER, RygelSerializer);
	switch (property_id) {
		case RYGEL_SERIALIZER_SERIALIZER_TYPE_PROPERTY:
		rygel_serializer_set_serializer_type (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

