/* browser-stack.c generated by valac 0.56.2, the Vala compiler
 * generated from browser-stack.vala, do not modify */

/*
  This file is part of Dconf Editor

  Dconf Editor is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  Dconf Editor is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with Dconf Editor.  If not, see <https://www.gnu.org/licenses/>.
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_ADAPTATIVE_WIDGET (adaptative_widget_get_type ())
#define ADAPTATIVE_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ADAPTATIVE_WIDGET, AdaptativeWidget))
#define IS_ADAPTATIVE_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ADAPTATIVE_WIDGET))
#define ADAPTATIVE_WIDGET_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_ADAPTATIVE_WIDGET, AdaptativeWidgetIface))

typedef struct _AdaptativeWidget AdaptativeWidget;
typedef struct _AdaptativeWidgetIface AdaptativeWidgetIface;
typedef enum  {
	ADAPTATIVE_WIDGET_WINDOW_SIZE_START_SIZE,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_USUAL_SIZE,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_QUITE_THIN,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_VERT,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_HZTL,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_BOTH,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_EXTRA_THIN,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_EXTRA_FLAT
} AdaptativeWidgetWindowSize;

#define ADAPTATIVE_WIDGET_TYPE_WINDOW_SIZE (adaptative_widget_window_size_get_type ())

#define TYPE_BROWSER_CONTENT (browser_content_get_type ())
#define BROWSER_CONTENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BROWSER_CONTENT, BrowserContent))
#define IS_BROWSER_CONTENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BROWSER_CONTENT))
#define BROWSER_CONTENT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_BROWSER_CONTENT, BrowserContentIface))

typedef struct _BrowserContent BrowserContent;
typedef struct _BrowserContentIface BrowserContentIface;
typedef enum  {
	VIEW_TYPE_OBJECT,
	VIEW_TYPE_FOLDER,
	VIEW_TYPE_SEARCH,
	VIEW_TYPE_CONFIG
} ViewType;

#define TYPE_VIEW_TYPE (view_type_get_type ())

#define TYPE_BROWSER_STACK (browser_stack_get_type ())
#define BROWSER_STACK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BROWSER_STACK, BrowserStack))
#define BROWSER_STACK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BROWSER_STACK, BrowserStackClass))
#define IS_BROWSER_STACK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BROWSER_STACK))
#define IS_BROWSER_STACK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BROWSER_STACK))
#define BROWSER_STACK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BROWSER_STACK, BrowserStackClass))

typedef struct _BrowserStack BrowserStack;
typedef struct _BrowserStackClass BrowserStackClass;
typedef struct _BrowserStackPrivate BrowserStackPrivate;

#define TYPE_REGISTRY_LIST (registry_list_get_type ())
#define REGISTRY_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REGISTRY_LIST, RegistryList))
#define REGISTRY_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_REGISTRY_LIST, RegistryListClass))
#define IS_REGISTRY_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REGISTRY_LIST))
#define IS_REGISTRY_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_REGISTRY_LIST))
#define REGISTRY_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_REGISTRY_LIST, RegistryListClass))

typedef struct _RegistryList RegistryList;
typedef struct _RegistryListClass RegistryListClass;

#define TYPE_REGISTRY_VIEW (registry_view_get_type ())
#define REGISTRY_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REGISTRY_VIEW, RegistryView))
#define REGISTRY_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_REGISTRY_VIEW, RegistryViewClass))
#define IS_REGISTRY_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REGISTRY_VIEW))
#define IS_REGISTRY_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_REGISTRY_VIEW))
#define REGISTRY_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_REGISTRY_VIEW, RegistryViewClass))

typedef struct _RegistryView RegistryView;
typedef struct _RegistryViewClass RegistryViewClass;

#define TYPE_REGISTRY_INFO (registry_info_get_type ())
#define REGISTRY_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REGISTRY_INFO, RegistryInfo))
#define REGISTRY_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_REGISTRY_INFO, RegistryInfoClass))
#define IS_REGISTRY_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REGISTRY_INFO))
#define IS_REGISTRY_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_REGISTRY_INFO))
#define REGISTRY_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_REGISTRY_INFO, RegistryInfoClass))

typedef struct _RegistryInfo RegistryInfo;
typedef struct _RegistryInfoClass RegistryInfoClass;

#define TYPE_REGISTRY_SEARCH (registry_search_get_type ())
#define REGISTRY_SEARCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REGISTRY_SEARCH, RegistrySearch))
#define REGISTRY_SEARCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_REGISTRY_SEARCH, RegistrySearchClass))
#define IS_REGISTRY_SEARCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REGISTRY_SEARCH))
#define IS_REGISTRY_SEARCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_REGISTRY_SEARCH))
#define REGISTRY_SEARCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_REGISTRY_SEARCH, RegistrySearchClass))

typedef struct _RegistrySearch RegistrySearch;
typedef struct _RegistrySearchClass RegistrySearchClass;
enum  {
	BROWSER_STACK_0_PROPERTY,
	BROWSER_STACK_CURRENT_VIEW_PROPERTY,
	BROWSER_STACK_MODIFICATIONS_HANDLER_PROPERTY,
	BROWSER_STACK_NUM_PROPERTIES
};
static GParamSpec* browser_stack_properties[BROWSER_STACK_NUM_PROPERTIES];

#define TYPE_MODIFICATIONS_HANDLER (modifications_handler_get_type ())
#define MODIFICATIONS_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MODIFICATIONS_HANDLER, ModificationsHandler))
#define MODIFICATIONS_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MODIFICATIONS_HANDLER, ModificationsHandlerClass))
#define IS_MODIFICATIONS_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MODIFICATIONS_HANDLER))
#define IS_MODIFICATIONS_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MODIFICATIONS_HANDLER))
#define MODIFICATIONS_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MODIFICATIONS_HANDLER, ModificationsHandlerClass))

typedef struct _ModificationsHandler ModificationsHandler;
typedef struct _ModificationsHandlerClass ModificationsHandlerClass;

#define TYPE_BROWSABLE_VIEW (browsable_view_get_type ())
#define BROWSABLE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BROWSABLE_VIEW, BrowsableView))
#define IS_BROWSABLE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BROWSABLE_VIEW))
#define BROWSABLE_VIEW_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_BROWSABLE_VIEW, BrowsableViewIface))

typedef struct _BrowsableView BrowsableView;
typedef struct _BrowsableViewIface BrowsableViewIface;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_SORTING_OPTIONS (sorting_options_get_type ())
#define SORTING_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SORTING_OPTIONS, SortingOptions))
#define SORTING_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SORTING_OPTIONS, SortingOptionsClass))
#define IS_SORTING_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SORTING_OPTIONS))
#define IS_SORTING_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SORTING_OPTIONS))
#define SORTING_OPTIONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SORTING_OPTIONS, SortingOptionsClass))

typedef struct _SortingOptions SortingOptions;
typedef struct _SortingOptionsClass SortingOptionsClass;
typedef struct _Block6Data Block6Data;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _AdaptativeWidgetIface {
	GTypeInterface parent_iface;
	void (*set_window_size) (AdaptativeWidget* self, AdaptativeWidgetWindowSize new_size);
};

struct _BrowserContentIface {
	GTypeInterface parent_iface;
	void (*prepare_folder_view) (BrowserContent* self, GListStore* key_model, gboolean is_ancestor);
	void (*prepare_object_view) (BrowserContent* self, const gchar* full_name, guint16 context_id, GVariant* properties, gboolean is_parent);
	void (*set_path) (BrowserContent* self, ViewType type, const gchar* path);
	gchar* (*get_selected_row_name) (BrowserContent* self);
	void (*select_row_named) (BrowserContent* self, const gchar* selected, guint16 last_context_id, gboolean grab_focus_if_needed);
	void (*select_first_row) (BrowserContent* self);
	void (*row_grab_focus) (BrowserContent* self);
	gboolean (*toggle_row_popover) (BrowserContent* self);
	void (*discard_row_popover) (BrowserContent* self);
	void (*invalidate_popovers) (BrowserContent* self);
	gboolean (*check_reload_folder) (BrowserContent* self, GVariant* fresh_key_model);
	gboolean (*check_reload_object) (BrowserContent* self, guint properties_hash);
	gboolean (*handle_copy_text) (BrowserContent* self, gchar** copy_text);
	gboolean (*handle_alt_copy_text) (BrowserContent* self, gchar** copy_text);
	gboolean (*next_match) (BrowserContent* self);
	gboolean (*previous_match) (BrowserContent* self);
	gboolean (*return_pressed) (BrowserContent* self);
	ViewType (*get_current_view) (BrowserContent* self);
	void (*set_current_view) (BrowserContent* self, ViewType value);
};

struct _BrowserStack {
	GtkGrid parent_instance;
	BrowserStackPrivate * priv;
};

struct _BrowserStackClass {
	GtkGridClass parent_class;
};

struct _BrowserStackPrivate {
	GtkStack* stack;
	RegistryView* folder_view;
	RegistryInfo* object_view;
	RegistrySearch* search_view;
	ViewType _current_view;
};

struct _BrowsableViewIface {
	GTypeInterface parent_iface;
	gboolean (*handle_copy_text) (BrowsableView* self, gchar** copy_text);
};

struct _Block6Data {
	int _ref_count_;
	BrowserStack* self;
	GtkStyleContext* context;
	GSettings* settings;
	gboolean has_small_keys_list_rows_class;
	gulong small_keys_list_rows_handler;
};

static gint BrowserStack_private_offset;
static gpointer browser_stack_parent_class = NULL;
static AdaptativeWidgetIface * browser_stack_adaptative_widget_parent_iface = NULL;
static BrowserContentIface * browser_stack_browser_content_parent_iface = NULL;

VALA_EXTERN GType adaptative_widget_window_size_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType adaptative_widget_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AdaptativeWidget, g_object_unref)
VALA_EXTERN GType view_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType browser_content_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType browser_stack_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BrowserStack, g_object_unref)
VALA_EXTERN GType registry_list_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RegistryList, g_object_unref)
VALA_EXTERN GType registry_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RegistryView, g_object_unref)
VALA_EXTERN GType registry_info_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RegistryInfo, g_object_unref)
VALA_EXTERN GType registry_search_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RegistrySearch, g_object_unref)
static void browser_stack_real_set_window_size (AdaptativeWidget* base,
                                         AdaptativeWidgetWindowSize new_size);
VALA_EXTERN void adaptative_widget_set_window_size (AdaptativeWidget* self,
                                        AdaptativeWidgetWindowSize new_size);
VALA_EXTERN GType modifications_handler_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ModificationsHandler, g_object_unref)
VALA_EXTERN BrowserStack* browser_stack_new (ModificationsHandler* modifications_handler);
VALA_EXTERN BrowserStack* browser_stack_construct (GType object_type,
                                       ModificationsHandler* modifications_handler);
static gchar* browser_stack_real_get_selected_row_name (BrowserContent* base);
VALA_EXTERN gboolean view_type_displays_objects_list (ViewType type);
VALA_EXTERN ViewType browser_content_get_current_view (BrowserContent* self);
VALA_EXTERN gchar* registry_list_get_selected_row_name (RegistryList* self);
VALA_EXTERN const gchar* registry_info_get_full_name (RegistryInfo* self);
static void browser_stack_real_prepare_folder_view (BrowserContent* base,
                                             GListStore* key_model,
                                             gboolean is_ancestor);
VALA_EXTERN void registry_view_set_key_model (RegistryView* self,
                                  GListStore* key_model);
static void browser_stack_real_select_row_named (BrowserContent* base,
                                          const gchar* selected,
                                          guint16 last_context_id,
                                          gboolean grab_focus_if_needed);
VALA_EXTERN void registry_list_select_row_named (RegistryList* self,
                                     const gchar* selected,
                                     guint16 context_id,
                                     gboolean grab_focus);
static void browser_stack_real_select_first_row (BrowserContent* base);
VALA_EXTERN void registry_list_select_first_row (RegistryList* self);
static void browser_stack_real_prepare_object_view (BrowserContent* base,
                                             const gchar* full_name,
                                             guint16 context_id,
                                             GVariant* properties,
                                             gboolean is_parent);
VALA_EXTERN void registry_info_populate_properties_list_box (RegistryInfo* self,
                                                 const gchar* _full_name,
                                                 guint16 _context_id,
                                                 GVariant* current_key_info);
static void browser_stack_real_set_path (BrowserContent* base,
                                  ViewType type,
                                  const gchar* path);
VALA_EXTERN void browser_content_set_current_view (BrowserContent* self,
                                       ViewType value);
VALA_EXTERN gboolean view_type_displays_object_infos (ViewType type);
VALA_EXTERN void registry_search_start_search (RegistrySearch* self,
                                   const gchar* _term);
VALA_EXTERN void registry_info_clean (RegistryInfo* self);
VALA_EXTERN void registry_search_clean (RegistrySearch* self);
static gboolean browser_stack_real_handle_copy_text (BrowserContent* base,
                                              gchar** copy_text);
VALA_EXTERN GType browsable_view_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gboolean browsable_view_handle_copy_text (BrowsableView* self,
                                          gchar** copy_text);
static gboolean browser_stack_real_handle_alt_copy_text (BrowserContent* base,
                                                  gchar** copy_text);
VALA_EXTERN gboolean registry_search_handle_alt_copy_text (RegistrySearch* self,
                                               gchar** copy_text);
VALA_EXTERN gboolean base_window_no_copy_text (gchar** copy_text);
static gboolean browser_stack_real_toggle_row_popover (BrowserContent* base);
VALA_EXTERN gboolean registry_list_toggle_row_popover (RegistryList* self);
VALA_EXTERN void browser_stack_toggle_boolean_key (BrowserStack* self);
VALA_EXTERN void registry_list_toggle_boolean_key (RegistryList* self);
VALA_EXTERN void browser_stack_set_selected_to_default (BrowserStack* self);
VALA_EXTERN void registry_list_set_selected_to_default (RegistryList* self);
static void browser_stack_real_discard_row_popover (BrowserContent* base);
VALA_EXTERN void registry_list_discard_row_popover (RegistryList* self);
static void browser_stack_real_invalidate_popovers (BrowserContent* base);
VALA_EXTERN void registry_list_invalidate_popovers (RegistryList* self);
VALA_EXTERN void browser_stack_hide_or_show_toggles (BrowserStack* self,
                                         gboolean show);
VALA_EXTERN void registry_list_hide_or_show_toggles (RegistryList* self,
                                         gboolean show);
VALA_EXTERN GType sorting_options_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SortingOptions, g_object_unref)
VALA_EXTERN void browser_stack_set_search_parameters (BrowserStack* self,
                                          gboolean local_search,
                                          const gchar* current_path,
                                          guint16 current_context_id,
                                          gchar** bookmarks,
                                          gint bookmarks_length1,
                                          SortingOptions* sorting_options);
VALA_EXTERN void registry_search_set_search_parameters (RegistrySearch* self,
                                            gboolean local_search,
                                            const gchar* current_path,
                                            guint16 current_context_id,
                                            gchar** _bookmarks,
                                            gint _bookmarks_length1,
                                            SortingOptions* _sorting_options);
static gboolean browser_stack_real_check_reload_folder (BrowserContent* base,
                                                 GVariant* fresh_key_model);
VALA_EXTERN gboolean registry_view_check_reload (RegistryView* self,
                                     GVariant* fresh_key_model);
static gboolean browser_stack_real_check_reload_object (BrowserContent* base,
                                                 guint properties_hash);
VALA_EXTERN gboolean registry_info_check_reload (RegistryInfo* self,
                                     guint properties_hash);
VALA_EXTERN void browser_stack_gkey_value_push (BrowserStack* self,
                                    const gchar* full_name,
                                    guint16 context_id,
                                    GVariant* key_value,
                                    gboolean is_key_default);
VALA_EXTERN void registry_list_gkey_value_push (RegistryList* self,
                                    const gchar* full_name,
                                    guint16 context_id,
                                    GVariant* key_value,
                                    gboolean is_key_default);
VALA_EXTERN guint16 registry_info_get_context_id (RegistryInfo* self);
VALA_EXTERN void registry_info_gkey_value_push (RegistryInfo* self,
                                    GVariant* key_value,
                                    gboolean is_key_default);
VALA_EXTERN void browser_stack_dkey_value_push (BrowserStack* self,
                                    const gchar* full_name,
                                    GVariant* key_value_or_null);
VALA_EXTERN void registry_list_dkey_value_push (RegistryList* self,
                                    const gchar* full_name,
                                    GVariant* key_value_or_null);
VALA_EXTERN void registry_info_dkey_value_push (RegistryInfo* self,
                                    GVariant* key_value_or_null);
static void browser_stack_real_row_grab_focus (BrowserContent* base);
VALA_EXTERN void registry_list_row_grab_focus (RegistryList* self);
static gboolean browser_stack_real_return_pressed (BrowserContent* base);
VALA_EXTERN gboolean registry_search_return_pressed (RegistrySearch* self);
static gboolean browser_stack_real_next_match (BrowserContent* base);
VALA_EXTERN gboolean registry_list_next_match (RegistryList* self);
static gboolean browser_stack_real_previous_match (BrowserContent* base);
VALA_EXTERN gboolean registry_list_previous_match (RegistryList* self);
static void browser_stack_set_modifications_handler (BrowserStack* self,
                                              ModificationsHandler* value);
VALA_EXTERN void registry_list_set_modifications_handler (RegistryList* self,
                                              ModificationsHandler* value);
VALA_EXTERN void registry_info_set_modifications_handler (RegistryInfo* self,
                                              ModificationsHandler* value);
static GObject * browser_stack_constructor (GType type,
                                     guint n_construct_properties,
                                     GObjectConstructParam * construct_properties);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void _browser_stack___lambda90_ (Block6Data* _data6_,
                                 GSettings* _settings,
                                 const gchar* key_name);
VALA_EXTERN void registry_list_set_small_keys_list_rows (RegistryList* self,
                                             gboolean value);
static void __browser_stack___lambda90__g_settings_changed (GSettings* _sender,
                                                     const gchar* key,
                                                     gpointer self);
static void _browser_stack___lambda91_ (Block6Data* _data6_);
static void __browser_stack___lambda91__gtk_widget_destroy (GtkWidget* _sender,
                                                     gpointer self);
VALA_EXTERN gchar* browser_content_get_selected_row_name (BrowserContent* self);
VALA_EXTERN void browser_content_prepare_folder_view (BrowserContent* self,
                                          GListStore* key_model,
                                          gboolean is_ancestor);
VALA_EXTERN void browser_content_select_row_named (BrowserContent* self,
                                       const gchar* selected,
                                       guint16 last_context_id,
                                       gboolean grab_focus_if_needed);
VALA_EXTERN void browser_content_select_first_row (BrowserContent* self);
VALA_EXTERN void browser_content_prepare_object_view (BrowserContent* self,
                                          const gchar* full_name,
                                          guint16 context_id,
                                          GVariant* properties,
                                          gboolean is_parent);
VALA_EXTERN void browser_content_set_path (BrowserContent* self,
                               ViewType type,
                               const gchar* path);
VALA_EXTERN gboolean browser_content_handle_copy_text (BrowserContent* self,
                                           gchar** copy_text);
VALA_EXTERN gboolean browser_content_handle_alt_copy_text (BrowserContent* self,
                                               gchar** copy_text);
VALA_EXTERN gboolean browser_content_toggle_row_popover (BrowserContent* self);
VALA_EXTERN void browser_content_discard_row_popover (BrowserContent* self);
VALA_EXTERN void browser_content_invalidate_popovers (BrowserContent* self);
VALA_EXTERN gboolean browser_content_check_reload_folder (BrowserContent* self,
                                              GVariant* fresh_key_model);
VALA_EXTERN gboolean browser_content_check_reload_object (BrowserContent* self,
                                              guint properties_hash);
VALA_EXTERN void browser_content_row_grab_focus (BrowserContent* self);
VALA_EXTERN gboolean browser_content_return_pressed (BrowserContent* self);
VALA_EXTERN gboolean browser_content_next_match (BrowserContent* self);
VALA_EXTERN gboolean browser_content_previous_match (BrowserContent* self);
static void browser_stack_finalize (GObject * obj);
static GType browser_stack_get_type_once (void);
static void _vala_browser_stack_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec);
static void _vala_browser_stack_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec);
static GType browsable_view_get_type_once (void);

static inline gpointer
browser_stack_get_instance_private (BrowserStack* self)
{
	return G_STRUCT_MEMBER_P (self, BrowserStack_private_offset);
}

static void
browser_stack_real_set_window_size (AdaptativeWidget* base,
                                    AdaptativeWidgetWindowSize new_size)
{
	BrowserStack * self;
	RegistryView* _tmp0_;
	RegistrySearch* _tmp1_;
	self = (BrowserStack*) base;
	_tmp0_ = self->priv->folder_view;
	adaptative_widget_set_window_size ((AdaptativeWidget*) _tmp0_, new_size);
	_tmp1_ = self->priv->search_view;
	adaptative_widget_set_window_size ((AdaptativeWidget*) _tmp1_, new_size);
}

BrowserStack*
browser_stack_construct (GType object_type,
                         ModificationsHandler* modifications_handler)
{
	BrowserStack * self = NULL;
	g_return_val_if_fail (modifications_handler != NULL, NULL);
	self = (BrowserStack*) g_object_new (object_type, "modifications-handler", modifications_handler, NULL);
	return self;
}

BrowserStack*
browser_stack_new (ModificationsHandler* modifications_handler)
{
	return browser_stack_construct (TYPE_BROWSER_STACK, modifications_handler);
}

static gchar*
browser_stack_real_get_selected_row_name (BrowserContent* base)
{
	BrowserStack * self;
	ViewType _tmp0_;
	ViewType _tmp1_;
	RegistryInfo* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* result;
	self = (BrowserStack*) base;
	_tmp0_ = browser_content_get_current_view ((BrowserContent*) self);
	_tmp1_ = _tmp0_;
	if (view_type_displays_objects_list (_tmp1_)) {
		GtkStack* _tmp2_;
		GtkWidget* _tmp3_;
		gchar* _tmp4_;
		_tmp2_ = self->priv->stack;
		_tmp3_ = gtk_stack_get_visible_child (_tmp2_);
		_tmp4_ = registry_list_get_selected_row_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_REGISTRY_LIST, RegistryList));
		result = _tmp4_;
		return result;
	}
	_tmp5_ = self->priv->object_view;
	_tmp6_ = registry_info_get_full_name (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strdup (_tmp7_);
	result = _tmp8_;
	return result;
}

static void
browser_stack_real_prepare_folder_view (BrowserContent* base,
                                        GListStore* key_model,
                                        gboolean is_ancestor)
{
	BrowserStack * self;
	RegistryView* _tmp0_;
	GtkStackTransitionType _tmp1_ = 0;
	gboolean _tmp2_ = FALSE;
	GtkStack* _tmp5_;
	self = (BrowserStack*) base;
	g_return_if_fail (key_model != NULL);
	_tmp0_ = self->priv->folder_view;
	registry_view_set_key_model (_tmp0_, key_model);
	if (is_ancestor) {
		ViewType _tmp3_;
		ViewType _tmp4_;
		_tmp3_ = browser_content_get_current_view ((BrowserContent*) self);
		_tmp4_ = _tmp3_;
		_tmp2_ = _tmp4_ != VIEW_TYPE_SEARCH;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = GTK_STACK_TRANSITION_TYPE_CROSSFADE;
	} else {
		_tmp1_ = GTK_STACK_TRANSITION_TYPE_NONE;
	}
	_tmp5_ = self->priv->stack;
	gtk_stack_set_transition_type (_tmp5_, _tmp1_);
}

static void
browser_stack_real_select_row_named (BrowserContent* base,
                                     const gchar* selected,
                                     guint16 last_context_id,
                                     gboolean grab_focus_if_needed)
{
	BrowserStack * self;
	ViewType _tmp0_;
	ViewType _tmp1_;
	gboolean _tmp2_ = FALSE;
	ViewType _tmp3_;
	ViewType _tmp4_;
	GtkStack* _tmp5_;
	GtkWidget* _tmp6_;
	self = (BrowserStack*) base;
	g_return_if_fail (selected != NULL);
	_tmp0_ = browser_content_get_current_view ((BrowserContent*) self);
	_tmp1_ = _tmp0_;
	_vala_return_if_fail (view_type_displays_objects_list (_tmp1_), "ViewType.displays_objects_list (current_view)");
	_vala_return_if_fail (g_strcmp0 (selected, "") != 0, "selected != \"\"");
	_tmp3_ = browser_content_get_current_view ((BrowserContent*) self);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == VIEW_TYPE_FOLDER) {
		_tmp2_ = grab_focus_if_needed;
	} else {
		_tmp2_ = FALSE;
	}
	_tmp5_ = self->priv->stack;
	_tmp6_ = gtk_stack_get_visible_child (_tmp5_);
	registry_list_select_row_named (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_REGISTRY_LIST, RegistryList), selected, last_context_id, _tmp2_);
}

static void
browser_stack_real_select_first_row (BrowserContent* base)
{
	BrowserStack * self;
	ViewType _tmp0_;
	ViewType _tmp1_;
	ViewType _tmp2_;
	ViewType _tmp3_;
	self = (BrowserStack*) base;
	_tmp0_ = browser_content_get_current_view ((BrowserContent*) self);
	_tmp1_ = _tmp0_;
	_vala_return_if_fail (view_type_displays_objects_list (_tmp1_), "ViewType.displays_objects_list (current_view)");
	_tmp2_ = browser_content_get_current_view ((BrowserContent*) self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == VIEW_TYPE_SEARCH) {
		GtkStack* _tmp4_;
		GtkWidget* _tmp5_;
		_tmp4_ = self->priv->stack;
		_tmp5_ = gtk_stack_get_visible_child (_tmp4_);
		registry_list_select_first_row ((RegistryList*) G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_REGISTRY_SEARCH, RegistrySearch));
	} else {
		ViewType _tmp6_;
		ViewType _tmp7_;
		_tmp6_ = browser_content_get_current_view ((BrowserContent*) self);
		_tmp7_ = _tmp6_;
		if (_tmp7_ == VIEW_TYPE_FOLDER) {
			GtkStack* _tmp8_;
			GtkWidget* _tmp9_;
			_tmp8_ = self->priv->stack;
			_tmp9_ = gtk_stack_get_visible_child (_tmp8_);
			registry_list_select_first_row ((RegistryList*) G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_REGISTRY_VIEW, RegistryView));
		} else {
			g_assert_not_reached ();
		}
	}
}

static void
browser_stack_real_prepare_object_view (BrowserContent* base,
                                        const gchar* full_name,
                                        guint16 context_id,
                                        GVariant* properties,
                                        gboolean is_parent)
{
	BrowserStack * self;
	RegistryInfo* _tmp0_;
	GtkStackTransitionType _tmp1_ = 0;
	gboolean _tmp2_ = FALSE;
	GtkStack* _tmp5_;
	self = (BrowserStack*) base;
	g_return_if_fail (full_name != NULL);
	g_return_if_fail (properties != NULL);
	_tmp0_ = self->priv->object_view;
	registry_info_populate_properties_list_box (_tmp0_, full_name, context_id, properties);
	if (is_parent) {
		ViewType _tmp3_;
		ViewType _tmp4_;
		_tmp3_ = browser_content_get_current_view ((BrowserContent*) self);
		_tmp4_ = _tmp3_;
		_tmp2_ = _tmp4_ != VIEW_TYPE_SEARCH;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = GTK_STACK_TRANSITION_TYPE_CROSSFADE;
	} else {
		_tmp1_ = GTK_STACK_TRANSITION_TYPE_NONE;
	}
	_tmp5_ = self->priv->stack;
	gtk_stack_set_transition_type (_tmp5_, _tmp1_);
}

static void
browser_stack_real_set_path (BrowserContent* base,
                             ViewType type,
                             const gchar* path)
{
	BrowserStack * self;
	gboolean clean_object_view = FALSE;
	gboolean _tmp0_ = FALSE;
	ViewType _tmp1_;
	ViewType _tmp2_;
	gboolean clean_search_view = FALSE;
	self = (BrowserStack*) base;
	g_return_if_fail (path != NULL);
	clean_object_view = type == VIEW_TYPE_FOLDER;
	_tmp1_ = browser_content_get_current_view ((BrowserContent*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == VIEW_TYPE_SEARCH) {
		_tmp0_ = type != VIEW_TYPE_SEARCH;
	} else {
		_tmp0_ = FALSE;
	}
	clean_search_view = _tmp0_;
	browser_content_set_current_view ((BrowserContent*) self, type);
	if (type == VIEW_TYPE_FOLDER) {
		GtkStack* _tmp3_;
		RegistryView* _tmp4_;
		_tmp3_ = self->priv->stack;
		_tmp4_ = self->priv->folder_view;
		gtk_stack_set_visible_child (_tmp3_, (GtkWidget*) _tmp4_);
	} else {
		if (view_type_displays_object_infos (type)) {
			GtkStack* _tmp5_;
			RegistryInfo* _tmp6_;
			_tmp5_ = self->priv->stack;
			_tmp6_ = self->priv->object_view;
			gtk_stack_set_visible_child (_tmp5_, (GtkWidget*) _tmp6_);
		} else {
			if (type == VIEW_TYPE_SEARCH) {
				RegistrySearch* _tmp7_;
				GtkStack* _tmp8_;
				GtkStack* _tmp9_;
				RegistrySearch* _tmp10_;
				RegistrySearch* _tmp11_;
				_tmp7_ = self->priv->search_view;
				registry_search_start_search (_tmp7_, path);
				_tmp8_ = self->priv->stack;
				gtk_stack_set_transition_type (_tmp8_, GTK_STACK_TRANSITION_TYPE_NONE);
				_tmp9_ = self->priv->stack;
				_tmp10_ = self->priv->search_view;
				gtk_stack_set_visible_child (_tmp9_, (GtkWidget*) _tmp10_);
				_tmp11_ = self->priv->search_view;
				registry_list_select_first_row ((RegistryList*) _tmp11_);
			} else {
				g_assert_not_reached ();
			}
		}
	}
	if (clean_object_view) {
		RegistryInfo* _tmp12_;
		_tmp12_ = self->priv->object_view;
		registry_info_clean (_tmp12_);
	}
	if (clean_search_view) {
		RegistrySearch* _tmp13_;
		_tmp13_ = self->priv->search_view;
		registry_search_clean (_tmp13_);
	}
}

static gboolean
browser_stack_real_handle_copy_text (BrowserContent* base,
                                     gchar** copy_text)
{
	BrowserStack * self;
	gchar* _vala_copy_text = NULL;
	GtkStack* _tmp0_;
	GtkWidget* _tmp1_;
	gchar* _tmp2_ = NULL;
	gboolean _tmp3_;
	gboolean result;
	self = (BrowserStack*) base;
	_tmp0_ = self->priv->stack;
	_tmp1_ = gtk_stack_get_visible_child (_tmp0_);
	_tmp3_ = browsable_view_handle_copy_text (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_BROWSABLE_VIEW, BrowsableView), &_tmp2_);
	_g_free0 (_vala_copy_text);
	_vala_copy_text = _tmp2_;
	result = _tmp3_;
	if (copy_text) {
		*copy_text = _vala_copy_text;
	} else {
		_g_free0 (_vala_copy_text);
	}
	return result;
}

static gboolean
browser_stack_real_handle_alt_copy_text (BrowserContent* base,
                                         gchar** copy_text)
{
	BrowserStack * self;
	gchar* _vala_copy_text = NULL;
	ViewType _tmp0_;
	ViewType _tmp1_;
	gchar* _tmp5_ = NULL;
	gboolean _tmp6_;
	gboolean result;
	self = (BrowserStack*) base;
	_tmp0_ = browser_content_get_current_view ((BrowserContent*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == VIEW_TYPE_SEARCH) {
		RegistrySearch* _tmp2_;
		gchar* _tmp3_ = NULL;
		gboolean _tmp4_;
		_tmp2_ = self->priv->search_view;
		_tmp4_ = registry_search_handle_alt_copy_text (_tmp2_, &_tmp3_);
		_g_free0 (_vala_copy_text);
		_vala_copy_text = _tmp3_;
		result = _tmp4_;
		if (copy_text) {
			*copy_text = _vala_copy_text;
		} else {
			_g_free0 (_vala_copy_text);
		}
		return result;
	}
	g_warning ("browser-stack.vala:157: BrowserView get_copy_path_text() called but cu" \
"rrent view is not search results view.");
	_tmp6_ = base_window_no_copy_text (&_tmp5_);
	_g_free0 (_vala_copy_text);
	_vala_copy_text = _tmp5_;
	result = _tmp6_;
	if (copy_text) {
		*copy_text = _vala_copy_text;
	} else {
		_g_free0 (_vala_copy_text);
	}
	return result;
}

static gboolean
browser_stack_real_toggle_row_popover (BrowserContent* base)
{
	BrowserStack * self;
	ViewType _tmp0_;
	ViewType _tmp1_;
	gboolean result;
	self = (BrowserStack*) base;
	_tmp0_ = browser_content_get_current_view ((BrowserContent*) self);
	_tmp1_ = _tmp0_;
	if (view_type_displays_objects_list (_tmp1_)) {
		GtkStack* _tmp2_;
		GtkWidget* _tmp3_;
		_tmp2_ = self->priv->stack;
		_tmp3_ = gtk_stack_get_visible_child (_tmp2_);
		result = registry_list_toggle_row_popover (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_REGISTRY_LIST, RegistryList));
		return result;
	}
	result = FALSE;
	return result;
}

void
browser_stack_toggle_boolean_key (BrowserStack* self)
{
	ViewType _tmp0_;
	ViewType _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = browser_content_get_current_view ((BrowserContent*) self);
	_tmp1_ = _tmp0_;
	if (view_type_displays_objects_list (_tmp1_)) {
		GtkStack* _tmp2_;
		GtkWidget* _tmp3_;
		_tmp2_ = self->priv->stack;
		_tmp3_ = gtk_stack_get_visible_child (_tmp2_);
		registry_list_toggle_boolean_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_REGISTRY_LIST, RegistryList));
	}
}

void
browser_stack_set_selected_to_default (BrowserStack* self)
{
	ViewType _tmp0_;
	ViewType _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = browser_content_get_current_view ((BrowserContent*) self);
	_tmp1_ = _tmp0_;
	if (view_type_displays_objects_list (_tmp1_)) {
		GtkStack* _tmp2_;
		GtkWidget* _tmp3_;
		_tmp2_ = self->priv->stack;
		_tmp3_ = gtk_stack_get_visible_child (_tmp2_);
		registry_list_set_selected_to_default (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_REGISTRY_LIST, RegistryList));
	}
}

static void
browser_stack_real_discard_row_popover (BrowserContent* base)
{
	BrowserStack * self;
	ViewType _tmp0_;
	ViewType _tmp1_;
	self = (BrowserStack*) base;
	_tmp0_ = browser_content_get_current_view ((BrowserContent*) self);
	_tmp1_ = _tmp0_;
	if (view_type_displays_objects_list (_tmp1_)) {
		GtkStack* _tmp2_;
		GtkWidget* _tmp3_;
		_tmp2_ = self->priv->stack;
		_tmp3_ = gtk_stack_get_visible_child (_tmp2_);
		registry_list_discard_row_popover (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_REGISTRY_LIST, RegistryList));
	}
}

static void
browser_stack_real_invalidate_popovers (BrowserContent* base)
{
	BrowserStack * self;
	RegistryView* _tmp0_;
	RegistrySearch* _tmp1_;
	self = (BrowserStack*) base;
	_tmp0_ = self->priv->folder_view;
	registry_list_invalidate_popovers ((RegistryList*) _tmp0_);
	_tmp1_ = self->priv->search_view;
	registry_list_invalidate_popovers ((RegistryList*) _tmp1_);
}

void
browser_stack_hide_or_show_toggles (BrowserStack* self,
                                    gboolean show)
{
	RegistryView* _tmp0_;
	RegistrySearch* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->folder_view;
	registry_list_hide_or_show_toggles ((RegistryList*) _tmp0_, show);
	_tmp1_ = self->priv->search_view;
	registry_list_hide_or_show_toggles ((RegistryList*) _tmp1_, show);
}

void
browser_stack_set_search_parameters (BrowserStack* self,
                                     gboolean local_search,
                                     const gchar* current_path,
                                     guint16 current_context_id,
                                     gchar** bookmarks,
                                     gint bookmarks_length1,
                                     SortingOptions* sorting_options)
{
	RegistrySearch* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (current_path != NULL);
	g_return_if_fail (sorting_options != NULL);
	_tmp0_ = self->priv->search_view;
	registry_search_set_search_parameters (_tmp0_, local_search, current_path, current_context_id, bookmarks, (gint) bookmarks_length1, sorting_options);
}

static gboolean
browser_stack_real_check_reload_folder (BrowserContent* base,
                                        GVariant* fresh_key_model)
{
	BrowserStack * self;
	RegistryView* _tmp0_;
	gboolean result;
	self = (BrowserStack*) base;
	_tmp0_ = self->priv->folder_view;
	result = registry_view_check_reload (_tmp0_, fresh_key_model);
	return result;
}

static gboolean
browser_stack_real_check_reload_object (BrowserContent* base,
                                        guint properties_hash)
{
	BrowserStack * self;
	RegistryInfo* _tmp0_;
	gboolean result;
	self = (BrowserStack*) base;
	_tmp0_ = self->priv->object_view;
	result = registry_info_check_reload (_tmp0_, properties_hash);
	return result;
}

void
browser_stack_gkey_value_push (BrowserStack* self,
                               const gchar* full_name,
                               guint16 context_id,
                               GVariant* key_value,
                               gboolean is_key_default)
{
	RegistryView* _tmp0_;
	RegistrySearch* _tmp1_;
	gboolean _tmp2_ = FALSE;
	RegistryInfo* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (full_name != NULL);
	g_return_if_fail (key_value != NULL);
	_tmp0_ = self->priv->folder_view;
	registry_list_gkey_value_push ((RegistryList*) _tmp0_, full_name, context_id, key_value, is_key_default);
	_tmp1_ = self->priv->search_view;
	registry_list_gkey_value_push ((RegistryList*) _tmp1_, full_name, context_id, key_value, is_key_default);
	_tmp3_ = self->priv->object_view;
	_tmp4_ = registry_info_get_full_name (_tmp3_);
	_tmp5_ = _tmp4_;
	if (g_strcmp0 (full_name, _tmp5_) == 0) {
		RegistryInfo* _tmp6_;
		guint16 _tmp7_;
		guint16 _tmp8_;
		_tmp6_ = self->priv->object_view;
		_tmp7_ = registry_info_get_context_id (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp2_ = context_id == _tmp8_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		RegistryInfo* _tmp9_;
		_tmp9_ = self->priv->object_view;
		registry_info_gkey_value_push (_tmp9_, key_value, is_key_default);
	}
}

void
browser_stack_dkey_value_push (BrowserStack* self,
                               const gchar* full_name,
                               GVariant* key_value_or_null)
{
	RegistryView* _tmp0_;
	RegistrySearch* _tmp1_;
	RegistryInfo* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (full_name != NULL);
	_tmp0_ = self->priv->folder_view;
	registry_list_dkey_value_push ((RegistryList*) _tmp0_, full_name, key_value_or_null);
	_tmp1_ = self->priv->search_view;
	registry_list_dkey_value_push ((RegistryList*) _tmp1_, full_name, key_value_or_null);
	_tmp2_ = self->priv->object_view;
	_tmp3_ = registry_info_get_full_name (_tmp2_);
	_tmp4_ = _tmp3_;
	if (g_strcmp0 (full_name, _tmp4_) == 0) {
		RegistryInfo* _tmp5_;
		_tmp5_ = self->priv->object_view;
		registry_info_dkey_value_push (_tmp5_, key_value_or_null);
	}
}

static void
browser_stack_real_row_grab_focus (BrowserContent* base)
{
	BrowserStack * self;
	ViewType _tmp0_;
	ViewType _tmp1_;
	self = (BrowserStack*) base;
	_tmp0_ = browser_content_get_current_view ((BrowserContent*) self);
	_tmp1_ = _tmp0_;
	if (view_type_displays_objects_list (_tmp1_)) {
		GtkStack* _tmp2_;
		GtkWidget* _tmp3_;
		_tmp2_ = self->priv->stack;
		_tmp3_ = gtk_stack_get_visible_child (_tmp2_);
		registry_list_row_grab_focus (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_REGISTRY_LIST, RegistryList));
	}
}

static gboolean
browser_stack_real_return_pressed (BrowserContent* base)
{
	BrowserStack * self;
	ViewType _tmp0_;
	ViewType _tmp1_;
	RegistrySearch* _tmp2_;
	gboolean result;
	self = (BrowserStack*) base;
	_tmp0_ = browser_content_get_current_view ((BrowserContent*) self);
	_tmp1_ = _tmp0_;
	_vala_return_val_if_fail (_tmp1_ == VIEW_TYPE_SEARCH, "current_view == ViewType.SEARCH", FALSE);
	_tmp2_ = self->priv->search_view;
	result = registry_search_return_pressed (_tmp2_);
	return result;
}

static gboolean
browser_stack_real_next_match (BrowserContent* base)
{
	BrowserStack * self;
	ViewType _tmp0_;
	ViewType _tmp1_;
	gboolean result;
	self = (BrowserStack*) base;
	_tmp0_ = browser_content_get_current_view ((BrowserContent*) self);
	_tmp1_ = _tmp0_;
	if (view_type_displays_objects_list (_tmp1_)) {
		GtkStack* _tmp2_;
		GtkWidget* _tmp3_;
		_tmp2_ = self->priv->stack;
		_tmp3_ = gtk_stack_get_visible_child (_tmp2_);
		result = registry_list_next_match (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_REGISTRY_LIST, RegistryList));
		return result;
	}
	result = FALSE;
	return result;
}

static gboolean
browser_stack_real_previous_match (BrowserContent* base)
{
	BrowserStack * self;
	ViewType _tmp0_;
	ViewType _tmp1_;
	gboolean result;
	self = (BrowserStack*) base;
	_tmp0_ = browser_content_get_current_view ((BrowserContent*) self);
	_tmp1_ = _tmp0_;
	if (view_type_displays_objects_list (_tmp1_)) {
		GtkStack* _tmp2_;
		GtkWidget* _tmp3_;
		_tmp2_ = self->priv->stack;
		_tmp3_ = gtk_stack_get_visible_child (_tmp2_);
		result = registry_list_previous_match (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_REGISTRY_LIST, RegistryList));
		return result;
	}
	result = FALSE;
	return result;
}

static ViewType
browser_stack_real_get_current_view (BrowserContent* base)
{
	ViewType result;
	BrowserStack* self;
	self = (BrowserStack*) base;
	result = self->priv->_current_view;
	return result;
}

static void
browser_stack_real_set_current_view (BrowserContent* base,
                                     ViewType value)
{
	BrowserStack* self;
	self = (BrowserStack*) base;
	self->priv->_current_view = value;
}

static void
browser_stack_set_modifications_handler (BrowserStack* self,
                                         ModificationsHandler* value)
{
	RegistryView* _tmp0_;
	RegistryInfo* _tmp1_;
	RegistrySearch* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->folder_view;
	registry_list_set_modifications_handler ((RegistryList*) _tmp0_, value);
	_tmp1_ = self->priv->object_view;
	registry_info_set_modifications_handler (_tmp1_, value);
	_tmp2_ = self->priv->search_view;
	registry_list_set_modifications_handler ((RegistryList*) _tmp2_, value);
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		BrowserStack* self;
		self = _data6_->self;
		_g_object_unref0 (_data6_->settings);
		_g_object_unref0 (_data6_->context);
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_browser_stack___lambda90_ (Block6Data* _data6_,
                            GSettings* _settings,
                            const gchar* key_name)
{
	BrowserStack* self;
	gboolean small_rows = FALSE;
	RegistryView* _tmp2_;
	RegistrySearch* _tmp3_;
	self = _data6_->self;
	g_return_if_fail (_settings != NULL);
	g_return_if_fail (key_name != NULL);
	small_rows = g_settings_get_boolean (_settings, key_name);
	if (small_rows) {
		if (!_data6_->has_small_keys_list_rows_class) {
			GtkStyleContext* _tmp0_;
			_tmp0_ = _data6_->context;
			gtk_style_context_add_class (_tmp0_, "small-keys-list-rows");
		}
	} else {
		if (_data6_->has_small_keys_list_rows_class) {
			GtkStyleContext* _tmp1_;
			_tmp1_ = _data6_->context;
			gtk_style_context_remove_class (_tmp1_, "small-keys-list-rows");
		}
	}
	_data6_->has_small_keys_list_rows_class = small_rows;
	_tmp2_ = self->priv->folder_view;
	registry_list_set_small_keys_list_rows ((RegistryList*) _tmp2_, small_rows);
	_tmp3_ = self->priv->search_view;
	registry_list_set_small_keys_list_rows ((RegistryList*) _tmp3_, small_rows);
}

static void
__browser_stack___lambda90__g_settings_changed (GSettings* _sender,
                                                const gchar* key,
                                                gpointer self)
{
	_browser_stack___lambda90_ (self, _sender, key);
}

static void
_browser_stack___lambda91_ (Block6Data* _data6_)
{
	BrowserStack* self;
	GSettings* _tmp0_;
	self = _data6_->self;
	_tmp0_ = _data6_->settings;
	g_signal_handler_disconnect ((GObject*) _tmp0_, _data6_->small_keys_list_rows_handler);
}

static void
__browser_stack___lambda91__gtk_widget_destroy (GtkWidget* _sender,
                                                gpointer self)
{
	_browser_stack___lambda91_ (self);
}

static GObject *
browser_stack_constructor (GType type,
                           guint n_construct_properties,
                           GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	BrowserStack * self;
	Block6Data* _data6_;
	GtkStyleContext* _tmp0_;
	GtkStyleContext* _tmp1_;
	GSettings* _tmp2_;
	GSettings* _tmp3_;
	GSettings* _tmp4_;
	gulong _tmp5_;
	RegistryView* _tmp7_;
	RegistrySearch* _tmp8_;
	parent_class = G_OBJECT_CLASS (browser_stack_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BROWSER_STACK, BrowserStack);
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_data6_->self = g_object_ref (self);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_data6_->context = _tmp1_;
	_tmp2_ = g_settings_new ("ca.desrt.dconf-editor.Settings");
	_data6_->settings = _tmp2_;
	_tmp3_ = _data6_->settings;
	_data6_->has_small_keys_list_rows_class = g_settings_get_boolean (_tmp3_, "small-keys-list-rows");
	_tmp4_ = _data6_->settings;
	_tmp5_ = g_signal_connect_data (_tmp4_, "changed::small-keys-list-rows", (GCallback) __browser_stack___lambda90__g_settings_changed, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
	_data6_->small_keys_list_rows_handler = _tmp5_;
	if (_data6_->has_small_keys_list_rows_class) {
		GtkStyleContext* _tmp6_;
		_tmp6_ = _data6_->context;
		gtk_style_context_add_class (_tmp6_, "small-keys-list-rows");
	}
	_tmp7_ = self->priv->folder_view;
	registry_list_set_small_keys_list_rows ((RegistryList*) _tmp7_, _data6_->has_small_keys_list_rows_class);
	_tmp8_ = self->priv->search_view;
	registry_list_set_small_keys_list_rows ((RegistryList*) _tmp8_, _data6_->has_small_keys_list_rows_class);
	g_signal_connect_data ((GtkWidget*) self, "destroy", (GCallback) __browser_stack___lambda91__gtk_widget_destroy, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
	block6_data_unref (_data6_);
	_data6_ = NULL;
	return obj;
}

static void
browser_stack_class_init (BrowserStackClass * klass,
                          gpointer klass_data)
{
	browser_stack_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BrowserStack_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_browser_stack_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_browser_stack_set_property;
	G_OBJECT_CLASS (klass)->constructor = browser_stack_constructor;
	G_OBJECT_CLASS (klass)->finalize = browser_stack_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BROWSER_STACK_CURRENT_VIEW_PROPERTY, browser_stack_properties[BROWSER_STACK_CURRENT_VIEW_PROPERTY] = g_param_spec_enum ("current-view", "current-view", "current-view", TYPE_VIEW_TYPE, VIEW_TYPE_FOLDER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BROWSER_STACK_MODIFICATIONS_HANDLER_PROPERTY, browser_stack_properties[BROWSER_STACK_MODIFICATIONS_HANDLER_PROPERTY] = g_param_spec_object ("modifications-handler", "modifications-handler", "modifications-handler", TYPE_MODIFICATIONS_HANDLER, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_EXPLICIT_NOTIFY));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/ca/desrt/dconf-editor/ui/browser-stack.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "stack", FALSE, BrowserStack_private_offset + G_STRUCT_OFFSET (BrowserStackPrivate, stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "folder_view", FALSE, BrowserStack_private_offset + G_STRUCT_OFFSET (BrowserStackPrivate, folder_view));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "object_view", FALSE, BrowserStack_private_offset + G_STRUCT_OFFSET (BrowserStackPrivate, object_view));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "search_view", FALSE, BrowserStack_private_offset + G_STRUCT_OFFSET (BrowserStackPrivate, search_view));
}

static void
browser_stack_adaptative_widget_interface_init (AdaptativeWidgetIface * iface,
                                                gpointer iface_data)
{
	browser_stack_adaptative_widget_parent_iface = g_type_interface_peek_parent (iface);
	iface->set_window_size = (void (*) (AdaptativeWidget*, AdaptativeWidgetWindowSize)) browser_stack_real_set_window_size;
}

static void
browser_stack_browser_content_interface_init (BrowserContentIface * iface,
                                              gpointer iface_data)
{
	browser_stack_browser_content_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_selected_row_name = (gchar* (*) (BrowserContent*)) browser_stack_real_get_selected_row_name;
	iface->prepare_folder_view = (void (*) (BrowserContent*, GListStore*, gboolean)) browser_stack_real_prepare_folder_view;
	iface->select_row_named = (void (*) (BrowserContent*, const gchar*, guint16, gboolean)) browser_stack_real_select_row_named;
	iface->select_first_row = (void (*) (BrowserContent*)) browser_stack_real_select_first_row;
	iface->prepare_object_view = (void (*) (BrowserContent*, const gchar*, guint16, GVariant*, gboolean)) browser_stack_real_prepare_object_view;
	iface->set_path = (void (*) (BrowserContent*, ViewType, const gchar*)) browser_stack_real_set_path;
	iface->handle_copy_text = (gboolean (*) (BrowserContent*, gchar**)) browser_stack_real_handle_copy_text;
	iface->handle_alt_copy_text = (gboolean (*) (BrowserContent*, gchar**)) browser_stack_real_handle_alt_copy_text;
	iface->toggle_row_popover = (gboolean (*) (BrowserContent*)) browser_stack_real_toggle_row_popover;
	iface->discard_row_popover = (void (*) (BrowserContent*)) browser_stack_real_discard_row_popover;
	iface->invalidate_popovers = (void (*) (BrowserContent*)) browser_stack_real_invalidate_popovers;
	iface->check_reload_folder = (gboolean (*) (BrowserContent*, GVariant*)) browser_stack_real_check_reload_folder;
	iface->check_reload_object = (gboolean (*) (BrowserContent*, guint)) browser_stack_real_check_reload_object;
	iface->row_grab_focus = (void (*) (BrowserContent*)) browser_stack_real_row_grab_focus;
	iface->return_pressed = (gboolean (*) (BrowserContent*)) browser_stack_real_return_pressed;
	iface->next_match = (gboolean (*) (BrowserContent*)) browser_stack_real_next_match;
	iface->previous_match = (gboolean (*) (BrowserContent*)) browser_stack_real_previous_match;
	iface->get_current_view = browser_stack_real_get_current_view;
	iface->set_current_view = browser_stack_real_set_current_view;
}

static void
browser_stack_instance_init (BrowserStack * self,
                             gpointer klass)
{
	self->priv = browser_stack_get_instance_private (self);
	self->priv->_current_view = VIEW_TYPE_FOLDER;
	g_type_ensure (TYPE_REGISTRY_VIEW);
	g_type_ensure (TYPE_REGISTRY_INFO);
	g_type_ensure (TYPE_REGISTRY_SEARCH);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
browser_stack_finalize (GObject * obj)
{
	BrowserStack * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BROWSER_STACK, BrowserStack);
	G_OBJECT_CLASS (browser_stack_parent_class)->finalize (obj);
}

static GType
browser_stack_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BrowserStackClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) browser_stack_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BrowserStack), 0, (GInstanceInitFunc) browser_stack_instance_init, NULL };
	static const GInterfaceInfo adaptative_widget_info = { (GInterfaceInitFunc) browser_stack_adaptative_widget_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo browser_content_info = { (GInterfaceInitFunc) browser_stack_browser_content_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType browser_stack_type_id;
	browser_stack_type_id = g_type_register_static (gtk_grid_get_type (), "BrowserStack", &g_define_type_info, 0);
	g_type_add_interface_static (browser_stack_type_id, TYPE_ADAPTATIVE_WIDGET, &adaptative_widget_info);
	g_type_add_interface_static (browser_stack_type_id, TYPE_BROWSER_CONTENT, &browser_content_info);
	BrowserStack_private_offset = g_type_add_instance_private (browser_stack_type_id, sizeof (BrowserStackPrivate));
	return browser_stack_type_id;
}

GType
browser_stack_get_type (void)
{
	static volatile gsize browser_stack_type_id__once = 0;
	if (g_once_init_enter (&browser_stack_type_id__once)) {
		GType browser_stack_type_id;
		browser_stack_type_id = browser_stack_get_type_once ();
		g_once_init_leave (&browser_stack_type_id__once, browser_stack_type_id);
	}
	return browser_stack_type_id__once;
}

static void
_vala_browser_stack_get_property (GObject * object,
                                  guint property_id,
                                  GValue * value,
                                  GParamSpec * pspec)
{
	BrowserStack * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_BROWSER_STACK, BrowserStack);
	switch (property_id) {
		case BROWSER_STACK_CURRENT_VIEW_PROPERTY:
		g_value_set_enum (value, browser_content_get_current_view ((BrowserContent*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_browser_stack_set_property (GObject * object,
                                  guint property_id,
                                  const GValue * value,
                                  GParamSpec * pspec)
{
	BrowserStack * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_BROWSER_STACK, BrowserStack);
	switch (property_id) {
		case BROWSER_STACK_CURRENT_VIEW_PROPERTY:
		browser_content_set_current_view ((BrowserContent*) self, g_value_get_enum (value));
		break;
		case BROWSER_STACK_MODIFICATIONS_HANDLER_PROPERTY:
		browser_stack_set_modifications_handler (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

gboolean
browsable_view_handle_copy_text (BrowsableView* self,
                                 gchar** copy_text)
{
	BrowsableViewIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = BROWSABLE_VIEW_GET_INTERFACE (self);
	if (_iface_->handle_copy_text) {
		return _iface_->handle_copy_text (self, copy_text);
	}
	return FALSE;
}

static void
browsable_view_default_init (BrowsableViewIface * iface,
                             gpointer iface_data)
{
}

static GType
browsable_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BrowsableViewIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) browsable_view_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType browsable_view_type_id;
	browsable_view_type_id = g_type_register_static (G_TYPE_INTERFACE, "BrowsableView", &g_define_type_info, 0);
	return browsable_view_type_id;
}

GType
browsable_view_get_type (void)
{
	static volatile gsize browsable_view_type_id__once = 0;
	if (g_once_init_enter (&browsable_view_type_id__once)) {
		GType browsable_view_type_id;
		browsable_view_type_id = browsable_view_get_type_once ();
		g_once_init_leave (&browsable_view_type_id__once, browsable_view_type_id);
	}
	return browsable_view_type_id__once;
}

