/* rygel-thumbnail.c generated by valac 0.56.1, the Vala compiler
 * generated from rygel-thumbnail.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "rygel-server.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "rygel-core.h"
#include <libgupnp-av/gupnp-av.h>

#define _g_free0(var) (var = (g_free (var), NULL))

static gpointer rygel_thumbnail_parent_class = NULL;

VALA_EXTERN RygelMediaResource* rygel_thumbnail_get_resource (RygelThumbnail* self,
                                                  const gchar* protocol,
                                                  gint index);
static RygelMediaResource* rygel_thumbnail_real_get_resource (RygelThumbnail* self,
                                                       const gchar* protocol,
                                                       gint index);
static void rygel_thumbnail_finalize (RygelIconInfo * obj);
static GType rygel_thumbnail_get_type_once (void);

RygelThumbnail*
rygel_thumbnail_construct (GType object_type,
                           const gchar* mime_type,
                           const gchar* dlna_profile,
                           const gchar* file_extension)
{
	RygelThumbnail* self = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (mime_type != NULL, NULL);
	g_return_val_if_fail (dlna_profile != NULL, NULL);
	g_return_val_if_fail (file_extension != NULL, NULL);
	self = (RygelThumbnail*) rygel_icon_info_construct (object_type, mime_type, file_extension);
	_tmp0_ = g_strdup (dlna_profile);
	_g_free0 (self->dlna_profile);
	self->dlna_profile = _tmp0_;
	return self;
}

RygelThumbnail*
rygel_thumbnail_new (const gchar* mime_type,
                     const gchar* dlna_profile,
                     const gchar* file_extension)
{
	return rygel_thumbnail_construct (RYGEL_TYPE_THUMBNAIL, mime_type, dlna_profile, file_extension);
}

static RygelMediaResource*
rygel_thumbnail_real_get_resource (RygelThumbnail* self,
                                   const gchar* protocol,
                                   gint index)
{
	gchar* name = NULL;
	gchar* _tmp0_;
	RygelMediaResource* res = NULL;
	RygelMediaResource* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GUPnPDLNAFlags _tmp4_;
	GUPnPDLNAFlags _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	RygelMediaResource* result;
	g_return_val_if_fail (protocol != NULL, NULL);
	_tmp0_ = g_strdup_printf ("%s_thumbnail_%02d", protocol, index);
	name = _tmp0_;
	_tmp1_ = rygel_media_resource_new (name);
	res = _tmp1_;
	rygel_media_resource_set_size (res, ((RygelIconInfo*) self)->size);
	rygel_media_resource_set_width (res, ((RygelIconInfo*) self)->width);
	rygel_media_resource_set_height (res, ((RygelIconInfo*) self)->height);
	rygel_media_resource_set_color_depth (res, ((RygelIconInfo*) self)->depth);
	_tmp2_ = ((RygelIconInfo*) self)->mime_type;
	rygel_media_resource_set_mime_type (res, _tmp2_);
	_tmp3_ = self->dlna_profile;
	rygel_media_resource_set_dlna_profile (res, _tmp3_);
	rygel_media_resource_set_protocol (res, protocol);
	_tmp4_ = rygel_media_resource_get_dlna_flags (res);
	_tmp5_ = _tmp4_;
	rygel_media_resource_set_dlna_flags (res, _tmp5_ | (((GUPNP_DLNA_FLAGS_INTERACTIVE_TRANSFER_MODE | GUPNP_DLNA_FLAGS_BACKGROUND_TRANSFER_MODE) | GUPNP_DLNA_FLAGS_CONNECTION_STALL) | GUPNP_DLNA_FLAGS_DLNA_V15));
	rygel_media_resource_set_dlna_operation (res, GUPNP_DLNA_OPERATION_RANGE);
	rygel_media_resource_set_dlna_conversion (res, GUPNP_DLNA_CONVERSION_TRANSCODED);
	_tmp6_ = ((RygelIconInfo*) self)->file_extension;
	rygel_media_resource_set_extension (res, _tmp6_);
	_tmp7_ = ((RygelIconInfo*) self)->uri;
	rygel_media_resource_set_uri (res, _tmp7_);
	result = res;
	_g_free0 (name);
	return result;
}

RygelMediaResource*
rygel_thumbnail_get_resource (RygelThumbnail* self,
                              const gchar* protocol,
                              gint index)
{
	RygelThumbnailClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = RYGEL_THUMBNAIL_GET_CLASS (self);
	if (_klass_->get_resource) {
		return _klass_->get_resource (self, protocol, index);
	}
	return NULL;
}

static void
rygel_thumbnail_class_init (RygelThumbnailClass * klass,
                            gpointer klass_data)
{
	rygel_thumbnail_parent_class = g_type_class_peek_parent (klass);
	((RygelIconInfoClass *) klass)->finalize = rygel_thumbnail_finalize;
	((RygelThumbnailClass *) klass)->get_resource = (RygelMediaResource* (*) (RygelThumbnail*, const gchar*, gint)) rygel_thumbnail_real_get_resource;
}

static void
rygel_thumbnail_instance_init (RygelThumbnail * self,
                               gpointer klass)
{
}

static void
rygel_thumbnail_finalize (RygelIconInfo * obj)
{
	RygelThumbnail * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_THUMBNAIL, RygelThumbnail);
	_g_free0 (self->dlna_profile);
	RYGEL_ICON_INFO_CLASS (rygel_thumbnail_parent_class)->finalize (obj);
}

/**
 * Represents a picture or video thumbnail.
 */
static GType
rygel_thumbnail_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelThumbnailClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_thumbnail_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelThumbnail), 0, (GInstanceInitFunc) rygel_thumbnail_instance_init, NULL };
	GType rygel_thumbnail_type_id;
	rygel_thumbnail_type_id = g_type_register_static (RYGEL_TYPE_ICON_INFO, "RygelThumbnail", &g_define_type_info, 0);
	return rygel_thumbnail_type_id;
}

GType
rygel_thumbnail_get_type (void)
{
	static volatile gsize rygel_thumbnail_type_id__once = 0;
	if (g_once_init_enter (&rygel_thumbnail_type_id__once)) {
		GType rygel_thumbnail_type_id;
		rygel_thumbnail_type_id = rygel_thumbnail_get_type_once ();
		g_once_init_leave (&rygel_thumbnail_type_id__once, rygel_thumbnail_type_id);
	}
	return rygel_thumbnail_type_id__once;
}

