/* rygel-writable-container.c generated by valac 0.56.1, the Vala compiler
 * generated from rygel-writable-container.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2010-2012 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Jens Georg <jensg@openismus.com>
 *         Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "rygel-server.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <gio/gio.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _RygelWritableContainerAddReferenceData RygelWritableContainerAddReferenceData;

struct _RygelWritableContainerAddReferenceData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelWritableContainer* self;
	RygelMediaObject* object;
	GCancellable* cancellable;
	gchar* result;
	GError* _tmp0_;
	GError* _inner_error0_;
};

static void rygel_writable_container_real_add_reference_data_free (gpointer _data);
static void rygel_writable_container_real_add_reference (RygelWritableContainer* self,
                                                  RygelMediaObject* object,
                                                  GCancellable* cancellable,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_);
static gboolean rygel_writable_container_real_add_reference_co (RygelWritableContainerAddReferenceData* _data_);
static GType rygel_writable_container_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

GQuark
rygel_writable_container_error_quark (void)
{
	return g_quark_from_static_string ("rygel-writable-container-error-quark");
}

static GType
rygel_writable_container_error_get_type_once (void)
{
	static const GEnumValue values[] = {{RYGEL_WRITABLE_CONTAINER_ERROR_NOT_IMPLEMENTED, "RYGEL_WRITABLE_CONTAINER_ERROR_NOT_IMPLEMENTED", "not-implemented"}, {0, NULL, NULL}};
	GType rygel_writable_container_error_type_id;
	rygel_writable_container_error_type_id = g_enum_register_static ("RygelWritableContainerError", values);
	return rygel_writable_container_error_type_id;
}

GType
rygel_writable_container_error_get_type (void)
{
	static volatile gsize rygel_writable_container_error_type_id__once = 0;
	if (g_once_init_enter (&rygel_writable_container_error_type_id__once)) {
		GType rygel_writable_container_error_type_id;
		rygel_writable_container_error_type_id = rygel_writable_container_error_get_type_once ();
		g_once_init_leave (&rygel_writable_container_error_type_id__once, rygel_writable_container_error_type_id);
	}
	return rygel_writable_container_error_type_id__once;
}

/**
     * Check if this container can contain an item with the given upnp class,
     * meaning that rygel_writable_container_add_item() should succeed.
     *
     * @param upnp_class The upnp class of an item to check
     *
     * @return true if it can, false, if not.
     */
gboolean
rygel_writable_container_can_create (RygelWritableContainer* self,
                                     const gchar* upnp_class)
{
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	gboolean result;
	g_return_val_if_fail (upnp_class != NULL, FALSE);
	_tmp0_ = rygel_writable_container_get_create_classes (self);
	_tmp1_ = _tmp0_;
	result = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp1_, upnp_class);
	return result;
}

void
rygel_writable_container_add_item (RygelWritableContainer* self,
                                   RygelMediaFileItem* item,
                                   GCancellable* cancellable,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_)
{
	RygelWritableContainerIface* _iface_;
	_iface_ = RYGEL_WRITABLE_CONTAINER_GET_INTERFACE (self);
	if (_iface_->add_item) {
		_iface_->add_item (self, item, cancellable, _callback_, _user_data_);
	}
}

void
rygel_writable_container_add_item_finish (RygelWritableContainer* self,
                                          GAsyncResult* _res_,
                                          GError** error)
{
	RygelWritableContainerIface* _iface_;
	_iface_ = RYGEL_WRITABLE_CONTAINER_GET_INTERFACE (self);
	if (_iface_->add_item_finish) {
		_iface_->add_item_finish (self, _res_, error);
	}
}

void
rygel_writable_container_add_container (RygelWritableContainer* self,
                                        RygelMediaContainer* container,
                                        GCancellable* cancellable,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_)
{
	RygelWritableContainerIface* _iface_;
	_iface_ = RYGEL_WRITABLE_CONTAINER_GET_INTERFACE (self);
	if (_iface_->add_container) {
		_iface_->add_container (self, container, cancellable, _callback_, _user_data_);
	}
}

void
rygel_writable_container_add_container_finish (RygelWritableContainer* self,
                                               GAsyncResult* _res_,
                                               GError** error)
{
	RygelWritableContainerIface* _iface_;
	_iface_ = RYGEL_WRITABLE_CONTAINER_GET_INTERFACE (self);
	if (_iface_->add_container_finish) {
		_iface_->add_container_finish (self, _res_, error);
	}
}

static void
rygel_writable_container_real_add_reference_data_free (gpointer _data)
{
	RygelWritableContainerAddReferenceData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->object);
	_g_object_unref0 (_data_->cancellable);
	_g_free0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelWritableContainerAddReferenceData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
rygel_writable_container_real_add_reference (RygelWritableContainer* self,
                                             RygelMediaObject* object,
                                             GCancellable* cancellable,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_)
{
	RygelWritableContainerAddReferenceData* _data_;
	RygelWritableContainer* _tmp0_;
	RygelMediaObject* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (object != NULL);
	_data_ = g_slice_new0 (RygelWritableContainerAddReferenceData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_writable_container_real_add_reference_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (object);
	_g_object_unref0 (_data_->object);
	_data_->object = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	rygel_writable_container_real_add_reference_co (_data_);
}

static gchar*
rygel_writable_container_real_add_reference_finish (RygelWritableContainer* self,
                                                    GAsyncResult* _res_,
                                                    GError** error)
{
	gchar* result;
	RygelWritableContainerAddReferenceData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

/**
     * Add a reference to an object.
     * @param object The source object to add a reference to.
     * @param cancellable optional cancellable for this operation
     * @return the id of the newly created reference
     **/
static gboolean
rygel_writable_container_real_add_reference_co (RygelWritableContainerAddReferenceData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_error_new_literal (RYGEL_WRITABLE_CONTAINER_ERROR, RYGEL_WRITABLE_CONTAINER_ERROR_NOT_IMPLEMENTED, "Cannot create references here");
	_data_->_inner_error0_ = _data_->_tmp0_;
	g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
rygel_writable_container_add_reference (RygelWritableContainer* self,
                                        RygelMediaObject* object,
                                        GCancellable* cancellable,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_)
{
	RygelWritableContainerIface* _iface_;
	_iface_ = RYGEL_WRITABLE_CONTAINER_GET_INTERFACE (self);
	if (_iface_->add_reference) {
		_iface_->add_reference (self, object, cancellable, _callback_, _user_data_);
	}
}

gchar*
rygel_writable_container_add_reference_finish (RygelWritableContainer* self,
                                               GAsyncResult* _res_,
                                               GError** error)
{
	RygelWritableContainerIface* _iface_;
	_iface_ = RYGEL_WRITABLE_CONTAINER_GET_INTERFACE (self);
	if (_iface_->add_reference_finish) {
		return _iface_->add_reference_finish (self, _res_, error);
	}
	return NULL;
}

void
rygel_writable_container_remove_item (RygelWritableContainer* self,
                                      const gchar* id,
                                      GCancellable* cancellable,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	RygelWritableContainerIface* _iface_;
	_iface_ = RYGEL_WRITABLE_CONTAINER_GET_INTERFACE (self);
	if (_iface_->remove_item) {
		_iface_->remove_item (self, id, cancellable, _callback_, _user_data_);
	}
}

void
rygel_writable_container_remove_item_finish (RygelWritableContainer* self,
                                             GAsyncResult* _res_,
                                             GError** error)
{
	RygelWritableContainerIface* _iface_;
	_iface_ = RYGEL_WRITABLE_CONTAINER_GET_INTERFACE (self);
	if (_iface_->remove_item_finish) {
		_iface_->remove_item_finish (self, _res_, error);
	}
}

void
rygel_writable_container_remove_container (RygelWritableContainer* self,
                                           const gchar* id,
                                           GCancellable* cancellable,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_)
{
	RygelWritableContainerIface* _iface_;
	_iface_ = RYGEL_WRITABLE_CONTAINER_GET_INTERFACE (self);
	if (_iface_->remove_container) {
		_iface_->remove_container (self, id, cancellable, _callback_, _user_data_);
	}
}

void
rygel_writable_container_remove_container_finish (RygelWritableContainer* self,
                                                  GAsyncResult* _res_,
                                                  GError** error)
{
	RygelWritableContainerIface* _iface_;
	_iface_ = RYGEL_WRITABLE_CONTAINER_GET_INTERFACE (self);
	if (_iface_->remove_container_finish) {
		_iface_->remove_container_finish (self, _res_, error);
	}
}

GeeArrayList*
rygel_writable_container_get_create_classes (RygelWritableContainer* self)
{
	RygelWritableContainerIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = RYGEL_WRITABLE_CONTAINER_GET_INTERFACE (self);
	if (_iface_->get_create_classes) {
		return _iface_->get_create_classes (self);
	}
	return NULL;
}

void
rygel_writable_container_set_create_classes (RygelWritableContainer* self,
                                             GeeArrayList* value)
{
	RygelWritableContainerIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = RYGEL_WRITABLE_CONTAINER_GET_INTERFACE (self);
	if (_iface_->set_create_classes) {
		_iface_->set_create_classes (self, value);
	}
}

static void
rygel_writable_container_default_init (RygelWritableContainerIface * iface,
                                       gpointer iface_data)
{
	/**
	     * The list of upnp classes that can be added to this container.
	     *
	     * See rygel_writable_container_add_item().
	     *
	     * This corresponds to the UPnP ContentDirectory's createClass properties.
	     */
	g_object_interface_install_property (iface, g_param_spec_object ("create-classes", "create-classes", "create-classes", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	iface->add_reference = rygel_writable_container_real_add_reference;
	iface->add_reference_finish = rygel_writable_container_real_add_reference_finish;
}

/**
 * This interface should be implemented by 'writable' containers - ones that allow
 * adding (via upload), removal and editing of items directly under them.
 * Currently, only addition and removal are supported.
 *
 * In addition to implementing this interface, a writable container must also:
 *
 *  # Provide one URI that points to a writable folder on a GIO-supported filesystem.
 *  # Monitor not only its own URI but also that of its child items, though the latter is implied in the former if you use GIO for monitoring.
 */
static GType
rygel_writable_container_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelWritableContainerIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_writable_container_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType rygel_writable_container_type_id;
	rygel_writable_container_type_id = g_type_register_static (G_TYPE_INTERFACE, "RygelWritableContainer", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (rygel_writable_container_type_id, RYGEL_TYPE_MEDIA_CONTAINER);
	return rygel_writable_container_type_id;
}

GType
rygel_writable_container_get_type (void)
{
	static volatile gsize rygel_writable_container_type_id__once = 0;
	if (g_once_init_enter (&rygel_writable_container_type_id__once)) {
		GType rygel_writable_container_type_id;
		rygel_writable_container_type_id = rygel_writable_container_get_type_once ();
		g_once_init_leave (&rygel_writable_container_type_id__once, rygel_writable_container_type_id);
	}
	return rygel_writable_container_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

