/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http2;

import jakarta.servlet.http.WebConnection;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.CompletionHandler;
import java.util.concurrent.TimeUnit;
import org.apache.coyote.ProtocolException;
import org.apache.coyote.http2.ByteUtil;
import org.apache.coyote.http2.ConnectionException;
import org.apache.coyote.http2.FrameType;
import org.apache.coyote.http2.Http2AsyncUpgradeHandler;
import org.apache.coyote.http2.Http2Error;
import org.apache.coyote.http2.Http2Exception;
import org.apache.coyote.http2.Http2Parser;
import org.apache.coyote.http2.Stream;
import org.apache.coyote.http2.StreamException;
import org.apache.tomcat.util.net.SocketEvent;
import org.apache.tomcat.util.net.SocketWrapperBase;

class Http2AsyncParser
extends Http2Parser {
    private final SocketWrapperBase<?> socketWrapper;
    private final Http2AsyncUpgradeHandler upgradeHandler;
    private volatile Throwable error = null;

    Http2AsyncParser(String string, Http2Parser.Input input, Http2Parser.Output output, SocketWrapperBase<?> socketWrapperBase, Http2AsyncUpgradeHandler http2AsyncUpgradeHandler) {
        super(string, input, output);
        this.socketWrapper = socketWrapperBase;
        socketWrapperBase.getSocketBufferHandler().expand(input.getMaxFrameSize());
        this.upgradeHandler = http2AsyncUpgradeHandler;
    }

    @Override
    void readConnectionPreface(WebConnection webConnection, Stream stream) throws Http2Exception {
        byte[] byArray = new byte[CLIENT_PREFACE_START.length];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(9);
        ByteBuffer byteBuffer3 = ByteBuffer.allocate(this.input.getMaxFrameSize());
        PrefaceCompletionHandler prefaceCompletionHandler = new PrefaceCompletionHandler(webConnection, stream, byArray, new ByteBuffer[]{byteBuffer, byteBuffer2, byteBuffer3});
        this.socketWrapper.read(SocketWrapperBase.BlockingMode.NON_BLOCK, this.socketWrapper.getReadTimeout(), TimeUnit.MILLISECONDS, null, prefaceCompletionHandler, prefaceCompletionHandler, byteBuffer, byteBuffer2, byteBuffer3);
    }

    @Override
    protected boolean readFrame(boolean bl, FrameType frameType) throws IOException, Http2Exception {
        this.handleAsyncException();
        ByteBuffer byteBuffer = ByteBuffer.allocate(9);
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(this.input.getMaxFrameSize());
        FrameCompletionHandler frameCompletionHandler = new FrameCompletionHandler(frameType, new ByteBuffer[]{byteBuffer, byteBuffer2});
        SocketWrapperBase.CompletionState completionState = this.socketWrapper.read(bl ? SocketWrapperBase.BlockingMode.BLOCK : SocketWrapperBase.BlockingMode.NON_BLOCK, this.socketWrapper.getReadTimeout(), TimeUnit.MILLISECONDS, null, frameCompletionHandler, frameCompletionHandler, byteBuffer, byteBuffer2);
        if (completionState == SocketWrapperBase.CompletionState.ERROR || completionState == SocketWrapperBase.CompletionState.INLINE) {
            this.handleAsyncException();
            return true;
        }
        return false;
    }

    private void handleAsyncException() throws IOException, Http2Exception {
        if (this.error != null) {
            Throwable throwable = this.error;
            this.error = null;
            if (throwable instanceof Http2Exception) {
                throw (Http2Exception)throwable;
            }
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new RuntimeException(throwable);
        }
    }

    private class FrameCompletionHandler
    implements SocketWrapperBase.CompletionCheck,
    CompletionHandler<Long, Void> {
        private final FrameType expected;
        protected final ByteBuffer[] buffers;
        private volatile boolean parsedFrameHeader = false;
        private volatile boolean validated = false;
        private volatile SocketWrapperBase.CompletionState state = null;
        protected volatile int payloadSize;
        protected volatile int frameTypeId;
        protected volatile FrameType frameType;
        protected volatile int flags;
        protected volatile int streamId;
        protected volatile boolean streamException = false;

        private FrameCompletionHandler(FrameType frameType, ByteBuffer ... byteBufferArray) {
            this.expected = frameType;
            this.buffers = byteBufferArray;
        }

        @Override
        public SocketWrapperBase.CompletionHandlerCall callHandler(SocketWrapperBase.CompletionState completionState, ByteBuffer[] byteBufferArray, int n, int n2) {
            if (n != 0 || n2 != 2) {
                try {
                    throw new IllegalArgumentException(Http2Parser.sm.getString("http2Parser.invalidBuffers"));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Http2AsyncParser.this.error = illegalArgumentException;
                    return SocketWrapperBase.CompletionHandlerCall.DONE;
                }
            }
            return this.validate(completionState, byteBufferArray[0], byteBufferArray[1]);
        }

        protected SocketWrapperBase.CompletionHandlerCall validate(SocketWrapperBase.CompletionState completionState, ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
            if (!this.parsedFrameHeader) {
                if (byteBuffer.position() < 9) {
                    return SocketWrapperBase.CompletionHandlerCall.CONTINUE;
                }
                this.parsedFrameHeader = true;
                this.payloadSize = ByteUtil.getThreeBytes(byteBuffer, 0);
                this.frameTypeId = ByteUtil.getOneByte(byteBuffer, 3);
                this.frameType = FrameType.valueOf(this.frameTypeId);
                this.flags = ByteUtil.getOneByte(byteBuffer, 4);
                this.streamId = ByteUtil.get31Bits(byteBuffer, 5);
            }
            this.state = completionState;
            if (!this.validated) {
                this.validated = true;
                try {
                    Http2AsyncParser.this.validateFrame(this.expected, this.frameType, this.streamId, this.flags, this.payloadSize);
                }
                catch (StreamException streamException) {
                    Http2AsyncParser.this.error = streamException;
                    this.streamException = true;
                }
                catch (Http2Exception http2Exception) {
                    Http2AsyncParser.this.error = http2Exception;
                    return SocketWrapperBase.CompletionHandlerCall.DONE;
                }
            }
            if (byteBuffer2.position() < this.payloadSize) {
                return SocketWrapperBase.CompletionHandlerCall.CONTINUE;
            }
            return SocketWrapperBase.CompletionHandlerCall.DONE;
        }

        @Override
        public void completed(Long l, Void void_) {
            if (this.streamException || Http2AsyncParser.this.error == null) {
                ByteBuffer byteBuffer = this.buffers[1];
                byteBuffer.flip();
                try {
                    boolean bl;
                    do {
                        bl = false;
                        if (this.streamException) {
                            Http2AsyncParser.this.swallowPayload(this.streamId, this.frameTypeId, this.payloadSize, false, byteBuffer);
                        } else {
                            switch (this.frameType) {
                                case DATA: {
                                    Http2AsyncParser.this.readDataFrame(this.streamId, this.flags, this.payloadSize, byteBuffer);
                                    break;
                                }
                                case HEADERS: {
                                    Http2AsyncParser.this.readHeadersFrame(this.streamId, this.flags, this.payloadSize, byteBuffer);
                                    break;
                                }
                                case PRIORITY: {
                                    Http2AsyncParser.this.readPriorityFrame(this.streamId, byteBuffer);
                                    break;
                                }
                                case RST: {
                                    Http2AsyncParser.this.readRstFrame(this.streamId, byteBuffer);
                                    break;
                                }
                                case SETTINGS: {
                                    Http2AsyncParser.this.readSettingsFrame(this.flags, this.payloadSize, byteBuffer);
                                    break;
                                }
                                case PUSH_PROMISE: {
                                    Http2AsyncParser.this.readPushPromiseFrame(this.streamId, this.flags, this.payloadSize, byteBuffer);
                                    break;
                                }
                                case PING: {
                                    Http2AsyncParser.this.readPingFrame(this.flags, byteBuffer);
                                    break;
                                }
                                case GOAWAY: {
                                    Http2AsyncParser.this.readGoawayFrame(this.payloadSize, byteBuffer);
                                    break;
                                }
                                case WINDOW_UPDATE: {
                                    Http2AsyncParser.this.readWindowUpdateFrame(this.streamId, byteBuffer);
                                    break;
                                }
                                case CONTINUATION: {
                                    Http2AsyncParser.this.readContinuationFrame(this.streamId, this.flags, this.payloadSize, byteBuffer);
                                    break;
                                }
                                case UNKNOWN: {
                                    Http2AsyncParser.this.readUnknownFrame(this.streamId, this.frameTypeId, this.flags, this.payloadSize, byteBuffer);
                                }
                            }
                        }
                        if (byteBuffer.remaining() < 9) continue;
                        int n = byteBuffer.position();
                        this.payloadSize = ByteUtil.getThreeBytes(byteBuffer, n);
                        this.frameTypeId = ByteUtil.getOneByte(byteBuffer, n + 3);
                        this.frameType = FrameType.valueOf(this.frameTypeId);
                        this.flags = ByteUtil.getOneByte(byteBuffer, n + 4);
                        this.streamId = ByteUtil.get31Bits(byteBuffer, n + 5);
                        this.streamException = false;
                        if (byteBuffer.remaining() - 9 < this.payloadSize) continue;
                        bl = true;
                        byteBuffer.position(byteBuffer.position() + 9);
                        try {
                            Http2AsyncParser.this.validateFrame(null, this.frameType, this.streamId, this.flags, this.payloadSize);
                        }
                        catch (StreamException streamException) {
                            Http2AsyncParser.this.error = streamException;
                            this.streamException = true;
                        }
                        catch (Http2Exception http2Exception) {
                            Http2AsyncParser.this.error = http2Exception;
                            bl = false;
                        }
                    } while (bl);
                }
                catch (IOException | RuntimeException | Http2Exception exception) {
                    Http2AsyncParser.this.error = exception;
                }
                if (byteBuffer.hasRemaining()) {
                    Http2AsyncParser.this.socketWrapper.unRead(byteBuffer);
                }
            }
            if (this.state == SocketWrapperBase.CompletionState.DONE) {
                Http2AsyncParser.this.upgradeHandler.upgradeDispatch(SocketEvent.OPEN_READ);
            }
        }

        @Override
        public void failed(Throwable throwable, Void void_) {
            Http2AsyncParser.this.error = throwable;
            if (Http2Parser.log.isDebugEnabled()) {
                Http2Parser.log.debug((Object)Http2Parser.sm.getString("http2Parser.error", new Object[]{Http2AsyncParser.this.connectionId, this.streamId, this.frameType}), throwable);
            }
            if (this.state == null || this.state == SocketWrapperBase.CompletionState.DONE) {
                Http2AsyncParser.this.upgradeHandler.upgradeDispatch(SocketEvent.ERROR);
            }
        }
    }

    private class PrefaceCompletionHandler
    extends FrameCompletionHandler {
        private final WebConnection webConnection;
        private final Stream stream;
        private final byte[] prefaceData;
        private volatile boolean prefaceValidated;

        private PrefaceCompletionHandler(WebConnection webConnection, Stream stream, byte[] byArray, ByteBuffer ... byteBufferArray) {
            super(FrameType.SETTINGS, byteBufferArray);
            this.prefaceValidated = false;
            this.webConnection = webConnection;
            this.stream = stream;
            this.prefaceData = byArray;
        }

        @Override
        public SocketWrapperBase.CompletionHandlerCall callHandler(SocketWrapperBase.CompletionState completionState, ByteBuffer[] byteBufferArray, int n, int n2) {
            if (n != 0 || n2 != 3) {
                try {
                    throw new IllegalArgumentException(Http2Parser.sm.getString("http2Parser.invalidBuffers"));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Http2AsyncParser.this.error = illegalArgumentException;
                    return SocketWrapperBase.CompletionHandlerCall.DONE;
                }
            }
            if (!this.prefaceValidated) {
                if (byteBufferArray[0].hasRemaining()) {
                    return SocketWrapperBase.CompletionHandlerCall.CONTINUE;
                }
                for (int i = 0; i < Http2Parser.CLIENT_PREFACE_START.length; ++i) {
                    if (Http2Parser.CLIENT_PREFACE_START[i] == this.prefaceData[i]) continue;
                    Http2AsyncParser.this.error = new ProtocolException(Http2Parser.sm.getString("http2Parser.preface.invalid"));
                    return SocketWrapperBase.CompletionHandlerCall.DONE;
                }
                this.prefaceValidated = true;
            }
            return this.validate(completionState, byteBufferArray[1], byteBufferArray[2]);
        }

        @Override
        public void completed(Long l, Void void_) {
            if (this.streamException || Http2AsyncParser.this.error == null) {
                ByteBuffer byteBuffer = this.buffers[2];
                byteBuffer.flip();
                try {
                    if (this.streamException) {
                        Http2AsyncParser.this.swallowPayload(this.streamId, this.frameTypeId, this.payloadSize, false, byteBuffer);
                    } else {
                        Http2AsyncParser.this.readSettingsFrame(this.flags, this.payloadSize, byteBuffer);
                    }
                }
                catch (IOException | RuntimeException | Http2Exception exception) {
                    Http2AsyncParser.this.error = exception;
                }
                if (byteBuffer.hasRemaining()) {
                    Http2AsyncParser.this.socketWrapper.unRead(byteBuffer);
                }
                Http2AsyncParser.this.upgradeHandler.processConnectionCallback(this.webConnection, this.stream);
            } else {
                Http2AsyncParser.this.upgradeHandler.closeConnection(new ConnectionException(Http2AsyncParser.this.error.getMessage(), Http2Error.PROTOCOL_ERROR, Http2AsyncParser.this.error));
            }
            Http2AsyncParser.this.upgradeHandler.upgradeDispatch(SocketEvent.OPEN_READ);
        }
    }
}

