/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.graalvm.svm;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.application.jvm.HeapHistogram;
import org.graalvm.visualvm.application.jvm.Jvm;
import org.graalvm.visualvm.application.jvm.MonitoredData;
import org.graalvm.visualvm.application.jvm.MonitoredDataListener;
import org.graalvm.visualvm.graalvm.svm.SVMMonitoredDataImpl;
import org.graalvm.visualvm.tools.jvmstat.JvmJvmstatModel;
import org.graalvm.visualvm.tools.jvmstat.JvmJvmstatModelFactory;
import org.graalvm.visualvm.tools.jvmstat.JvmstatListener;
import org.graalvm.visualvm.tools.jvmstat.JvmstatModel;
import org.graalvm.visualvm.tools.jvmstat.MonitoredValue;

public class SVMJVMImpl
extends Jvm
implements JvmstatListener {
    private static final String USER_DIR_COUNTER_NAME = "java.property.user.dir";
    private static final String PROCESSORS_COUNTER_NAME = "com.oracle.svm.processors";
    private static final String SVM_HEAP_DUMP_PREFIX = "svm-heapdump-";
    private static final String SVM_HEAP_DUMP_SUFFIX = ".hprof";
    private static final String SYSTEM_PROPERTY_PREFIX = "java.property.";
    private static final String SYSTEM_PROPERTY_REG_EXPR = "java.property.".replace(".", "\\.") + ".*";
    private static final String MEMORY_COUNTER_REG_EXPR = "sun\\.gc\\.generation\\..*";
    Application application;
    JvmstatModel monitoredVm;
    JvmJvmstatModel jvmstatModel;
    Set<MonitoredDataListener> listeners;
    private boolean staticDataInitialized;
    private final Object staticDataLock = new Object();
    private String commandLine;
    private String jvmArgs;
    private String jvmFlags;
    private String mainArgs;
    private String mainClass;
    private String vmVersion;
    private String javaVersion;
    private String javaHome;
    private String vmInfo;
    private String vmName;
    private String vmVendor;

    SVMJVMImpl(Application app, JvmstatModel jvms) {
        this.application = app;
        this.monitoredVm = jvms;
        this.jvmstatModel = JvmJvmstatModelFactory.getJvmstatModelFor((Application)app);
        this.listeners = new HashSet<MonitoredDataListener>();
    }

    public boolean isAttachable() {
        return false;
    }

    public boolean isBasicInfoSupported() {
        return true;
    }

    public String getCommandLine() {
        this.initStaticData();
        return this.commandLine;
    }

    public String getJvmArgs() {
        this.initStaticData();
        return this.jvmArgs;
    }

    public String getJvmFlags() {
        this.initStaticData();
        return this.jvmFlags;
    }

    public String getMainArgs() {
        this.initStaticData();
        return this.mainArgs;
    }

    public String getMainClass() {
        this.initStaticData();
        return this.mainClass;
    }

    public String getVmVersion() {
        this.initStaticData();
        return this.vmVersion;
    }

    public String getJavaVersion() {
        this.initStaticData();
        if (this.javaVersion != null) {
            return this.javaVersion;
        }
        return this.vmVersion;
    }

    public String getJavaHome() {
        this.initStaticData();
        return this.javaHome;
    }

    public String getVmInfo() {
        this.initStaticData();
        return this.vmInfo;
    }

    public String getVmName() {
        this.initStaticData();
        return this.vmName;
    }

    public String getVmVendor() {
        this.initStaticData();
        return this.vmVendor;
    }

    public boolean is14() {
        return false;
    }

    public boolean is15() {
        return false;
    }

    public boolean is16() {
        return false;
    }

    public boolean is17() {
        return false;
    }

    public boolean is18() {
        String ver = this.getJavaVersion();
        return ver != null && ver.startsWith("1.8.");
    }

    public boolean is19() {
        String ver = this.getJavaVersion();
        return ver != null && this.javaVersion != null && (ver.startsWith("1.9.") || ver.equals("9") || ver.startsWith("9."));
    }

    public boolean is100() {
        String ver = this.getJavaVersion();
        return ver != null && this.javaVersion != null && (ver.equals("10") || ver.startsWith("10."));
    }

    public boolean is110() {
        String ver = this.getJavaVersion();
        return ver != null && this.javaVersion != null && (ver.equals("11") || ver.equals("11-ea") || ver.startsWith("11."));
    }

    public boolean isDumpOnOOMEnabled() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMonitoredDataListener(MonitoredDataListener l) {
        Set<MonitoredDataListener> set = this.listeners;
        synchronized (set) {
            if (this.listeners.add(l) && this.monitoredVm != null) {
                this.monitoredVm.addJvmstatListener((JvmstatListener)this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMonitoredDataListener(MonitoredDataListener l) {
        Set<MonitoredDataListener> set = this.listeners;
        synchronized (set) {
            if (this.listeners.remove(l) && this.listeners.isEmpty() && this.monitoredVm != null) {
                this.monitoredVm.removeJvmstatListener((JvmstatListener)this);
            }
        }
    }

    public String[] getGenName() {
        if (this.jvmstatModel != null) {
            return this.jvmstatModel.getGenName();
        }
        throw new UnsupportedOperationException();
    }

    public boolean isMonitoringSupported() {
        return this.isClassMonitoringSupported() || this.isThreadMonitoringSupported() || this.isMemoryMonitoringSupported();
    }

    public boolean isClassMonitoringSupported() {
        return this.monitoredVm != null;
    }

    public boolean isThreadMonitoringSupported() {
        return this.monitoredVm != null;
    }

    public boolean isMemoryMonitoringSupported() {
        if (this.monitoredVm != null) {
            List vals = this.monitoredVm.findByPattern(MEMORY_COUNTER_REG_EXPR);
            return vals != null && !vals.isEmpty();
        }
        return false;
    }

    public boolean isGetSystemPropertiesSupported() {
        return true;
    }

    public int getAvailableProcessors() {
        MonitoredValue procs = this.monitoredVm.findMonitoredValueByName(PROCESSORS_COUNTER_NAME);
        if (procs != null) {
            return ((Long)procs.getValue()).intValue();
        }
        return 1;
    }

    public Properties getSystemProperties() {
        Properties p = new Properties();
        for (MonitoredValue val : this.monitoredVm.findMonitoredValueByPattern(SYSTEM_PROPERTY_REG_EXPR)) {
            p.put(val.getName().substring(SYSTEM_PROPERTY_PREFIX.length()), val.getValue());
        }
        return p;
    }

    public boolean isDumpOnOOMEnabledSupported() {
        return false;
    }

    public synchronized void setDumpOnOOMEnabled(boolean enabled) {
    }

    public boolean isTakeHeapDumpSupported() {
        if (this.application.isLocalApplication()) {
            return this.monitoredVm.findByName(USER_DIR_COUNTER_NAME) != null;
        }
        return false;
    }

    public boolean takeHeapDump(File outputFile) throws IOException {
        if (!this.isTakeHeapDumpSupported()) {
            throw new UnsupportedOperationException();
        }
        String cwd = this.monitoredVm.findByName(USER_DIR_COUNTER_NAME);
        Path applicationCwd = Paths.get(cwd, new String[0]);
        WatchService watchService = FileSystems.getDefault().newWatchService();
        WatchKey key = applicationCwd.register(watchService, StandardWatchEventKinds.ENTRY_CREATE);
        Runtime.getRuntime().exec(new String[]{"kill", "-USR1", String.valueOf(this.application.getPid())});
        try {
            Path name = this.findHeapDumpFile(key);
            if (name == null) {
                key = watchService.poll(20L, TimeUnit.SECONDS);
                name = this.findHeapDumpFile(key);
            }
            watchService.close();
            if (name == null) {
                return false;
            }
            Path dumpPath = applicationCwd.resolve(name);
            Path outputPath = outputFile.toPath();
            this.waitDumpDone(dumpPath);
            Files.move(dumpPath, outputPath, new CopyOption[0]);
            return true;
        }
        catch (InterruptedException ex) {
            watchService.close();
            return false;
        }
    }

    private Path findHeapDumpFile(WatchKey key) {
        for (WatchEvent<?> event : key.pollEvents()) {
            WatchEvent<?> ev;
            Path filename;
            String name;
            WatchEvent.Kind<?> kind = event.kind();
            if (kind == StandardWatchEventKinds.OVERFLOW || !(name = (filename = (Path)(ev = event).context()).toString()).endsWith(SVM_HEAP_DUMP_SUFFIX) || !name.startsWith(SVM_HEAP_DUMP_PREFIX)) continue;
            return filename;
        }
        return null;
    }

    public boolean isTakeThreadDumpSupported() {
        return false;
    }

    public String takeThreadDump() {
        throw new UnsupportedOperationException();
    }

    public HeapHistogram takeHeapHistogram() {
        return null;
    }

    public boolean isCpuMonitoringSupported() {
        return true;
    }

    public boolean isCollectionTimeSupported() {
        return false;
    }

    public boolean isJfrAvailable() {
        return false;
    }

    public List<Long> jfrCheck() {
        return Collections.EMPTY_LIST;
    }

    public String takeJfrDump(long recording, String fileName) {
        throw new UnsupportedOperationException();
    }

    public boolean startJfrRecording(String name, String[] settings, String delay, String duration, Boolean disk, String path, String maxAge, String maxSize, Boolean dumpOnExit) {
        throw new UnsupportedOperationException();
    }

    public boolean stopJfrRecording() {
        throw new UnsupportedOperationException();
    }

    public MonitoredData getMonitoredData() {
        if (this.application.getState() == 1 && this.monitoredVm != null) {
            return new SVMMonitoredDataImpl(this, this.monitoredVm, this.jvmstatModel);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initStaticData() {
        Object object = this.staticDataLock;
        synchronized (object) {
            if (this.staticDataInitialized) {
                return;
            }
            if (this.jvmstatModel != null) {
                this.commandLine = this.jvmstatModel.getCommandLine();
                this.jvmArgs = this.getJvmArgsJvmstat();
                this.jvmFlags = this.jvmstatModel.getJvmFlags();
                this.mainArgs = this.jvmstatModel.getMainArgs();
                this.mainClass = this.jvmstatModel.getMainClass();
                this.vmVersion = this.jvmstatModel.getVmVersion();
                this.javaVersion = this.jvmstatModel.getJavaVersion();
                this.javaHome = this.jvmstatModel.getJavaHome();
                this.vmInfo = this.jvmstatModel.getVmInfo();
                this.vmName = this.jvmstatModel.getVmName();
                this.vmVendor = this.jvmstatModel.getVmVendor();
            }
            this.staticDataInitialized = true;
        }
    }

    private String getJvmArgsJvmstat() {
        return this.jvmstatModel.getJvmArgs();
    }

    public void dataChanged(JvmstatModel stat) {
        assert (stat == this.monitoredVm);
        SVMMonitoredDataImpl data = new SVMMonitoredDataImpl(this, this.monitoredVm, this.jvmstatModel);
        this.notifyListeners(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyListeners(MonitoredData data) {
        ArrayList<MonitoredDataListener> listenersCopy;
        Set<MonitoredDataListener> set = this.listeners;
        synchronized (set) {
            listenersCopy = new ArrayList<MonitoredDataListener>(this.listeners);
        }
        for (MonitoredDataListener listener : listenersCopy) {
            listener.monitoredDataEvent(data);
        }
    }

    private void waitDumpDone(Path name) throws IOException {
        long size;
        long newSize = Files.size(name);
        do {
            size = newSize;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ex) {
                return;
            }
        } while (size != (newSize = Files.size(name)));
    }
}

