/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.gotosource.java;

import java.util.List;
import java.util.regex.Pattern;
import org.graalvm.visualvm.gotosource.java.JavaClass;
import org.graalvm.visualvm.gotosource.java.JavaMethod;

final class JavaSourceUtils {
    private static final char COMMENT_MASK_CHAR = ' ';
    private static final char STRING_MASK_CHAR = '+';
    private static final char NONBLOCK_MASK_CHAR = '=';
    private static final char CLASS_MASK_CHAR = '_';
    private static final String LAMBDA_CLASS_PREFIX = "$Lambda$";
    static final String LAMBDA_CLASS_PREFIX_MASK = "-Lambda-";
    static final String IDENTIFIER_REGEX = "\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*";
    static final String FULLY_QUALIFIED_IDENTIFIER_REGEX = "(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\.)*\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*";
    private static final String THROWS_REGEX = "throws\\s+((\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\.)*\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\s*,\\s*)*(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\.)*\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*";
    static final String REGEX_PARAMETER_0 = "{#$0#}";
    static final String REGEX_GROUP_NAME = "name";
    static final String REGEX_GROUP_INDEX = "index";
    static final String REGEX_GROUP_PREFIX = "prefix";
    static final String ANONYMOUS_LOCAL_CLASSNAME_REGEX = "(?<index>[\\d]+)(?<name>[\\D]*)";
    static final String CLASS_REGEX = "(^|[\\W&&[^.]])(class|interface|enum)\\s+(?<name>\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)[^\\p{javaJavaIdentifierPart}]";
    static final String ANONYMOUS_CLASS_START_REGEX = "\\Wnew\\s*(\\s|\\<)";
    static final String ANONYMOUS_CLASS_END_REGEX = "\\G\\s*(?<name>(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\.)*\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)\\s*";
    static final String ANONYMOUS_CLASS_METHOD_REGEX = "\\G\\s*.s*\\(";
    static final int SHORTEST_ANNONYMOUS_LENGTH = "new X(){}".length();
    static final String CLASS_INITIALIZER_REGEX = "\\Wstatic\\s*\\{";
    static final String INSTANCE_INITIALIZER_REGEX = "[\\{\\};]\\s*\\{";
    static final String DEFINED_METHOD_WITHBODY_START_REGEX = "(?<prefix>[\\s\\>]){#$0#}\\s*\\(";
    static final String DEFINED_METHOD_WITHBODY_END_REGEX = "\\G\\s*(throws\\s+((\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\.)*\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\s*,\\s*)*(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\.)*\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)??\\s*\\{";
    static final String DEFINED_METHOD_WITHOUTBODY_START_REGEX = "(?<prefix>\\Wnative[\\s\\S&&[^;]&&[^\\(]]*?[\\s\\>]){#$0#}\\s*\\(";
    static final String DEFINED_METHOD_WITHOUTBODY_END_REGEX = "\\G\\s*(throws\\s+((\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\.)*\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\s*,\\s*)*(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\.)*\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)??\\s*;";

    private JavaSourceUtils() {
    }

    static String toplevelClassName(String className) {
        int innerIndex = (className = className.replace("[]", "")).indexOf("$");
        return innerIndex == -1 ? className : className.substring(0, innerIndex);
    }

    static String toplevelClassFile(String toplevelClassName) {
        return toplevelClassName.replace(".", "/") + ".java";
    }

    static String plainClassName(String className) {
        int index = className.lastIndexOf(".");
        return index == -1 ? className : className.substring(index + 1);
    }

    private static String[] classNameComponents(String className) {
        String pureClassName = className.replace("[]", "");
        String plainClassName = JavaSourceUtils.plainClassName(pureClassName);
        plainClassName = plainClassName.replace(LAMBDA_CLASS_PREFIX, LAMBDA_CLASS_PREFIX_MASK);
        return plainClassName.split(Pattern.quote("$"));
    }

    static int classDefinitionOffset(String text, String className, boolean exactOnly) {
        String[] classNameComponents;
        JavaClass cls = JavaSourceUtils.getJavaClass(text = JavaSourceUtils.maskNonCode(text), classNameComponents = JavaSourceUtils.classNameComponents(className), exactOnly);
        return cls == null ? -1 : cls.getNameStart();
    }

    private static JavaClass getJavaClass(String text, String[] plainClassNames, boolean exactOnly) {
        JavaClass cls = null;
        JavaClass foundClass = null;
        for (String classNameComponent : plainClassNames) {
            if ((cls = cls == null ? JavaClass.fromSource(text, classNameComponent) : cls.getClass(classNameComponent)) == null) {
                return exactOnly ? null : foundClass;
            }
            foundClass = cls;
        }
        return foundClass;
    }

    static int methodDefinitionOffset(String text, String className, String methodName, String methodSignature, boolean exactOnly) {
        String[] classNameComponents;
        JavaClass cls = JavaSourceUtils.getJavaClass(text = JavaSourceUtils.maskNonCode(text), classNameComponents = JavaSourceUtils.classNameComponents(className), true);
        if (cls == null) {
            if (!exactOnly) {
                cls = JavaSourceUtils.getJavaClass(text, classNameComponents, false);
            }
            return cls == null ? -1 : cls.getNameStart();
        }
        JavaMethod method = cls.getMethod(methodName, methodSignature);
        if (method == null) {
            return exactOnly ? -1 : cls.getNameStart();
        }
        return method.getNameStart();
    }

    static String maskNonCode(String text) {
        char[] newText = new char[text.length()];
        boolean lineComment = false;
        boolean blockComment = false;
        boolean chardef = false;
        boolean string = false;
        int escapes = 0;
        int lastChar = 32;
        for (int position = 0; position < newText.length; ++position) {
            int currentChar = text.charAt(position);
            if (!(lineComment || chardef || string || blockComment || 47 != lastChar || 42 != currentChar)) {
                newText[position - 1] = 32;
                blockComment = true;
            }
            if (!(blockComment || chardef || string)) {
                if (!lineComment && 47 == lastChar && 47 == currentChar) {
                    newText[position - 1] = 32;
                    lineComment = true;
                } else if (lineComment && (13 == currentChar || 10 == currentChar)) {
                    lineComment = false;
                }
            }
            if (!(lineComment || blockComment || string)) {
                if (!chardef && 39 == currentChar) {
                    chardef = true;
                } else if (chardef) {
                    if (92 == currentChar) {
                        ++escapes;
                    } else if (39 == currentChar) {
                        chardef = escapes % 2 != 0;
                        escapes = 0;
                    } else {
                        escapes = 0;
                    }
                }
            }
            if (!(lineComment || blockComment || chardef)) {
                if (!string && 34 == currentChar) {
                    string = true;
                } else if (string) {
                    if (92 == currentChar) {
                        ++escapes;
                    } else if (34 == currentChar) {
                        string = escapes % 2 != 0;
                        escapes = 0;
                    } else {
                        escapes = 0;
                    }
                }
            }
            newText[position] = string || chardef ? 43 : (Character.isWhitespace((char)currentChar) ? currentChar : (lineComment || blockComment ? 32 : currentChar));
            if (!lineComment && !chardef && !string && blockComment && 42 == lastChar && 47 == currentChar) {
                blockComment = false;
            }
            lastChar = currentChar;
        }
        return new String(newText);
    }

    static String maskNonBlock(String text, char startDelimiter, char endDelimiter, int startPosition, int endPosition) {
        char[] newText = new char[text.length()];
        int currentCount = 0;
        while (startPosition <= endPosition) {
            char currentChar = text.charAt(startPosition);
            if (startDelimiter == currentChar) {
                ++currentCount;
            }
            char c = newText[startPosition] = currentCount == 1 || currentCount == 2 && (currentChar == startDelimiter || currentChar == endDelimiter) || Character.isWhitespace(currentChar) ? currentChar : (char)'=';
            if (endDelimiter == currentChar) {
                --currentCount;
            }
            ++startPosition;
        }
        return new String(newText);
    }

    static String maskClasses(String text, List<JavaClass> classes) {
        char[] newText = text.toCharArray();
        for (JavaClass cls : classes) {
            for (int position = cls.getBodyStart() + 1; position < cls.getBodyEnd(); ++position) {
                int currentChar = text.charAt(position);
                newText[position] = Character.isWhitespace((char)currentChar) ? currentChar : 95;
            }
        }
        return new String(newText);
    }

    static int skipBlock(String text, int position, char startDelimiter, char endDelimiter) {
        return JavaSourceUtils.skipBlockImpl(text, position, startDelimiter, endDelimiter, true)[1];
    }

    static int[] getBlockBounds(String text, int position, char startDelimiter, char endDelimiter) {
        return JavaSourceUtils.skipBlockImpl(text, position, startDelimiter, endDelimiter, false);
    }

    private static int[] skipBlockImpl(String text, int position, char startDelimiter, char endDelimiter, boolean moveToNext) {
        int start = -1;
        int currentCount = 0;
        boolean found = false;
        while (position < text.length()) {
            char currentChar = text.charAt(position);
            if (currentChar == endDelimiter) {
                --currentCount;
            } else if (currentChar == startDelimiter) {
                if (start == -1) {
                    start = position;
                }
                ++currentCount;
                found = true;
            }
            if (found && currentCount == 0) break;
            ++position;
        }
        return new int[]{start, moveToNext ? position + 1 : position};
    }

    static int skipWhiteSpaces(String text, int position) {
        while (position < text.length() && Character.isWhitespace(text.charAt(position))) {
            ++position;
        }
        return position;
    }
}

