package #
Date::Manip::TZ::paeast00;
# Copyright (c) 2008-2022 Sullivan Beck.  All rights reserved.
# This program is free software; you can redistribute it and/or modify it
# under the same terms as Perl itself.

# This file was automatically generated.  Any changes to this file will
# be lost the next time 'tzdata' is run.
#    Generated on: Wed Jun  1 10:55:29 EDT 2022
#    Data version: tzdata2022a
#    Code version: tzcode2022a

# This module contains data from the zoneinfo time zone database.  The original
# data was obtained from the URL:
#    ftp://ftp.iana.org/tz

use strict;
use warnings;
require 5.010000;

our (%Dates,%LastRule);
END {
   undef %Dates;
   undef %LastRule;
}

our ($VERSION);
$VERSION='6.88';
END { undef $VERSION; }

%Dates         = (
   1    =>
     [
        [ [1,1,2,0,0,0],[1,1,1,16,42,32],'-07:17:28',[-7,-17,-28],
          'LMT',0,[1890,1,1,7,17,27],[1889,12,31,23,59,59],
          '0001010200:00:00','0001010116:42:32','1890010107:17:27','1889123123:59:59' ],
     ],
   1890 =>
     [
        [ [1890,1,1,7,17,28],[1890,1,1,0,0,0],'-07:17:28',[-7,-17,-28],
          'EMT',0,[1932,9,1,7,17,27],[1932,8,31,23,59,59],
          '1890010107:17:28','1890010100:00:00','1932090107:17:27','1932083123:59:59' ],
     ],
   1932 =>
     [
        [ [1932,9,1,7,17,28],[1932,9,1,0,17,28],'-07:00:00',[-7,0,0],
          '-07',0,[1968,11,3,3,59,59],[1968,11,2,20,59,59],
          '1932090107:17:28','1932090100:17:28','1968110303:59:59','1968110220:59:59' ],
     ],
   1968 =>
     [
        [ [1968,11,3,4,0,0],[1968,11,2,22,0,0],'-06:00:00',[-6,0,0],
          '-06',1,[1969,3,30,2,59,59],[1969,3,29,20,59,59],
          '1968110304:00:00','1968110222:00:00','1969033002:59:59','1969032920:59:59' ],
     ],
   1969 =>
     [
        [ [1969,3,30,3,0,0],[1969,3,29,20,0,0],'-07:00:00',[-7,0,0],
          '-07',0,[1969,11,23,3,59,59],[1969,11,22,20,59,59],
          '1969033003:00:00','1969032920:00:00','1969112303:59:59','1969112220:59:59' ],
        [ [1969,11,23,4,0,0],[1969,11,22,22,0,0],'-06:00:00',[-6,0,0],
          '-06',1,[1970,3,29,2,59,59],[1970,3,28,20,59,59],
          '1969112304:00:00','1969112222:00:00','1970032902:59:59','1970032820:59:59' ],
     ],
   1970 =>
     [
        [ [1970,3,29,3,0,0],[1970,3,28,20,0,0],'-07:00:00',[-7,0,0],
          '-07',0,[1970,10,11,3,59,59],[1970,10,10,20,59,59],
          '1970032903:00:00','1970032820:00:00','1970101103:59:59','1970101020:59:59' ],
        [ [1970,10,11,4,0,0],[1970,10,10,22,0,0],'-06:00:00',[-6,0,0],
          '-06',1,[1971,3,14,2,59,59],[1971,3,13,20,59,59],
          '1970101104:00:00','1970101022:00:00','1971031402:59:59','1971031320:59:59' ],
     ],
   1971 =>
     [
        [ [1971,3,14,3,0,0],[1971,3,13,20,0,0],'-07:00:00',[-7,0,0],
          '-07',0,[1971,10,10,3,59,59],[1971,10,9,20,59,59],
          '1971031403:00:00','1971031320:00:00','1971101003:59:59','1971100920:59:59' ],
        [ [1971,10,10,4,0,0],[1971,10,9,22,0,0],'-06:00:00',[-6,0,0],
          '-06',1,[1972,3,12,2,59,59],[1972,3,11,20,59,59],
          '1971101004:00:00','1971100922:00:00','1972031202:59:59','1972031120:59:59' ],
     ],
   1972 =>
     [
        [ [1972,3,12,3,0,0],[1972,3,11,20,0,0],'-07:00:00',[-7,0,0],
          '-07',0,[1972,10,15,3,59,59],[1972,10,14,20,59,59],
          '1972031203:00:00','1972031120:00:00','1972101503:59:59','1972101420:59:59' ],
        [ [1972,10,15,4,0,0],[1972,10,14,22,0,0],'-06:00:00',[-6,0,0],
          '-06',1,[1973,3,11,2,59,59],[1973,3,10,20,59,59],
          '1972101504:00:00','1972101422:00:00','1973031102:59:59','1973031020:59:59' ],
     ],
   1973 =>
     [
        [ [1973,3,11,3,0,0],[1973,3,10,20,0,0],'-07:00:00',[-7,0,0],
          '-07',0,[1973,9,30,3,59,59],[1973,9,29,20,59,59],
          '1973031103:00:00','1973031020:00:00','1973093003:59:59','1973092920:59:59' ],
        [ [1973,9,30,4,0,0],[1973,9,29,22,0,0],'-06:00:00',[-6,0,0],
          '-06',1,[1974,3,10,2,59,59],[1974,3,9,20,59,59],
          '1973093004:00:00','1973092922:00:00','1974031002:59:59','1974030920:59:59' ],
     ],
   1974 =>
     [
        [ [1974,3,10,3,0,0],[1974,3,9,20,0,0],'-07:00:00',[-7,0,0],
          '-07',0,[1974,10,13,3,59,59],[1974,10,12,20,59,59],
          '1974031003:00:00','1974030920:00:00','1974101303:59:59','1974101220:59:59' ],
        [ [1974,10,13,4,0,0],[1974,10,12,22,0,0],'-06:00:00',[-6,0,0],
          '-06',1,[1975,3,9,2,59,59],[1975,3,8,20,59,59],
          '1974101304:00:00','1974101222:00:00','1975030902:59:59','1975030820:59:59' ],
     ],
   1975 =>
     [
        [ [1975,3,9,3,0,0],[1975,3,8,20,0,0],'-07:00:00',[-7,0,0],
          '-07',0,[1975,10,12,3,59,59],[1975,10,11,20,59,59],
          '1975030903:00:00','1975030820:00:00','1975101203:59:59','1975101120:59:59' ],
        [ [1975,10,12,4,0,0],[1975,10,11,22,0,0],'-06:00:00',[-6,0,0],
          '-06',1,[1976,3,14,2,59,59],[1976,3,13,20,59,59],
          '1975101204:00:00','1975101122:00:00','1976031402:59:59','1976031320:59:59' ],
     ],
   1976 =>
     [
        [ [1976,3,14,3,0,0],[1976,3,13,20,0,0],'-07:00:00',[-7,0,0],
          '-07',0,[1976,10,10,3,59,59],[1976,10,9,20,59,59],
          '1976031403:00:00','1976031320:00:00','1976101003:59:59','1976100920:59:59' ],
        [ [1976,10,10,4,0,0],[1976,10,9,22,0,0],'-06:00:00',[-6,0,0],
          '-06',1,[1977,3,13,2,59,59],[1977,3,12,20,59,59],
          '1976101004:00:00','1976100922:00:00','1977031302:59:59','1977031220:59:59' ],
     ],
   1977 =>
     [
        [ [1977,3,13,3,0,0],[1977,3,12,20,0,0],'-07:00:00',[-7,0,0],
          '-07',0,[1977,10,9,3,59,59],[1977,10,8,20,59,59],
          '1977031303:00:00','1977031220:00:00','1977100903:59:59','1977100820:59:59' ],
        [ [1977,10,9,4,0,0],[1977,10,8,22,0,0],'-06:00:00',[-6,0,0],
          '-06',1,[1978,3,12,2,59,59],[1978,3,11,20,59,59],
          '1977100904:00:00','1977100822:00:00','1978031202:59:59','1978031120:59:59' ],
     ],
   1978 =>
     [
        [ [1978,3,12,3,0,0],[1978,3,11,20,0,0],'-07:00:00',[-7,0,0],
          '-07',0,[1978,10,15,3,59,59],[1978,10,14,20,59,59],
          '1978031203:00:00','1978031120:00:00','1978101503:59:59','1978101420:59:59' ],
        [ [1978,10,15,4,0,0],[1978,10,14,22,0,0],'-06:00:00',[-6,0,0],
          '-06',1,[1979,3,11,2,59,59],[1979,3,10,20,59,59],
          '1978101504:00:00','1978101422:00:00','1979031102:59:59','1979031020:59:59' ],
     ],
   1979 =>
     [
        [ [1979,3,11,3,0,0],[1979,3,10,20,0,0],'-07:00:00',[-7,0,0],
          '-07',0,[1979,10,14,3,59,59],[1979,10,13,20,59,59],
          '1979031103:00:00','1979031020:00:00','1979101403:59:59','1979101320:59:59' ],
        [ [1979,10,14,4,0,0],[1979,10,13,22,0,0],'-06:00:00',[-6,0,0],
          '-06',1,[1980,3,9,2,59,59],[1980,3,8,20,59,59],
          '1979101404:00:00','1979101322:00:00','1980030902:59:59','1980030820:59:59' ],
     ],
   1980 =>
     [
        [ [1980,3,9,3,0,0],[1980,3,8,20,0,0],'-07:00:00',[-7,0,0],
          '-07',0,[1980,10,12,3,59,59],[1980,10,11,20,59,59],
          '1980030903:00:00','1980030820:00:00','1980101203:59:59','1980101120:59:59' ],
        [ [1980,10,12,4,0,0],[1980,10,11,22,0,0],'-06:00:00',[-6,0,0],
          '-06',1,[1981,3,15,2,59,59],[1981,3,14,20,59,59],
          '1980101204:00:00','1980101122:00:00','1981031502:59:59','1981031420:59:59' ],
     ],
   1981 =>
     [
        [ [1981,3,15,3,0,0],[1981,3,14,20,0,0],'-07:00:00',[-7,0,0],
          '-07',0,[1981,10,11,3,59,59],[1981,10,10,20,59,59],
          '1981031503:00:00','1981031420:00:00','1981101103:59:59','1981101020:59:59' ],
        [ [1981,10,11,4,0,0],[1981,10,10,22,0,0],'-06:00:00',[-6,0,0],
          '-06',1,[1982,3,14,2,59,59],[1982,3,13,20,59,59],
          '1981101104:00:00','1981101022:00:00','1982031402:59:59','1982031320:59:59' ],
     ],
   1982 =>
     [
        [ [1982,3,14,3,0,0],[1982,3,13,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[1982,10,10,3,59,59],[1982,10,9,21,59,59],
          '1982031403:00:00','1982031321:00:00','1982101003:59:59','1982100921:59:59' ],
        [ [1982,10,10,4,0,0],[1982,10,9,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[1983,3,13,2,59,59],[1983,3,12,21,59,59],
          '1982101004:00:00','1982100923:00:00','1983031302:59:59','1983031221:59:59' ],
     ],
   1983 =>
     [
        [ [1983,3,13,3,0,0],[1983,3,12,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[1983,10,9,3,59,59],[1983,10,8,21,59,59],
          '1983031303:00:00','1983031221:00:00','1983100903:59:59','1983100821:59:59' ],
        [ [1983,10,9,4,0,0],[1983,10,8,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[1984,3,11,2,59,59],[1984,3,10,21,59,59],
          '1983100904:00:00','1983100823:00:00','1984031102:59:59','1984031021:59:59' ],
     ],
   1984 =>
     [
        [ [1984,3,11,3,0,0],[1984,3,10,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[1984,10,14,3,59,59],[1984,10,13,21,59,59],
          '1984031103:00:00','1984031021:00:00','1984101403:59:59','1984101321:59:59' ],
        [ [1984,10,14,4,0,0],[1984,10,13,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[1985,3,10,2,59,59],[1985,3,9,21,59,59],
          '1984101404:00:00','1984101323:00:00','1985031002:59:59','1985030921:59:59' ],
     ],
   1985 =>
     [
        [ [1985,3,10,3,0,0],[1985,3,9,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[1985,10,13,3,59,59],[1985,10,12,21,59,59],
          '1985031003:00:00','1985030921:00:00','1985101303:59:59','1985101221:59:59' ],
        [ [1985,10,13,4,0,0],[1985,10,12,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[1986,3,9,2,59,59],[1986,3,8,21,59,59],
          '1985101304:00:00','1985101223:00:00','1986030902:59:59','1986030821:59:59' ],
     ],
   1986 =>
     [
        [ [1986,3,9,3,0,0],[1986,3,8,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[1986,10,12,3,59,59],[1986,10,11,21,59,59],
          '1986030903:00:00','1986030821:00:00','1986101203:59:59','1986101121:59:59' ],
        [ [1986,10,12,4,0,0],[1986,10,11,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[1987,4,12,2,59,59],[1987,4,11,21,59,59],
          '1986101204:00:00','1986101123:00:00','1987041202:59:59','1987041121:59:59' ],
     ],
   1987 =>
     [
        [ [1987,4,12,3,0,0],[1987,4,11,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[1987,10,11,3,59,59],[1987,10,10,21,59,59],
          '1987041203:00:00','1987041121:00:00','1987101103:59:59','1987101021:59:59' ],
        [ [1987,10,11,4,0,0],[1987,10,10,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[1988,3,13,2,59,59],[1988,3,12,21,59,59],
          '1987101104:00:00','1987101023:00:00','1988031302:59:59','1988031221:59:59' ],
     ],
   1988 =>
     [
        [ [1988,3,13,3,0,0],[1988,3,12,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[1988,10,9,3,59,59],[1988,10,8,21,59,59],
          '1988031303:00:00','1988031221:00:00','1988100903:59:59','1988100821:59:59' ],
        [ [1988,10,9,4,0,0],[1988,10,8,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[1989,3,12,2,59,59],[1989,3,11,21,59,59],
          '1988100904:00:00','1988100823:00:00','1989031202:59:59','1989031121:59:59' ],
     ],
   1989 =>
     [
        [ [1989,3,12,3,0,0],[1989,3,11,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[1989,10,15,3,59,59],[1989,10,14,21,59,59],
          '1989031203:00:00','1989031121:00:00','1989101503:59:59','1989101421:59:59' ],
        [ [1989,10,15,4,0,0],[1989,10,14,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[1990,3,11,2,59,59],[1990,3,10,21,59,59],
          '1989101504:00:00','1989101423:00:00','1990031102:59:59','1990031021:59:59' ],
     ],
   1990 =>
     [
        [ [1990,3,11,3,0,0],[1990,3,10,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[1990,9,16,3,59,59],[1990,9,15,21,59,59],
          '1990031103:00:00','1990031021:00:00','1990091603:59:59','1990091521:59:59' ],
        [ [1990,9,16,4,0,0],[1990,9,15,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[1991,3,10,2,59,59],[1991,3,9,21,59,59],
          '1990091604:00:00','1990091523:00:00','1991031002:59:59','1991030921:59:59' ],
     ],
   1991 =>
     [
        [ [1991,3,10,3,0,0],[1991,3,9,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[1991,10,13,3,59,59],[1991,10,12,21,59,59],
          '1991031003:00:00','1991030921:00:00','1991101303:59:59','1991101221:59:59' ],
        [ [1991,10,13,4,0,0],[1991,10,12,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[1992,3,15,2,59,59],[1992,3,14,21,59,59],
          '1991101304:00:00','1991101223:00:00','1992031502:59:59','1992031421:59:59' ],
     ],
   1992 =>
     [
        [ [1992,3,15,3,0,0],[1992,3,14,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[1992,10,11,3,59,59],[1992,10,10,21,59,59],
          '1992031503:00:00','1992031421:00:00','1992101103:59:59','1992101021:59:59' ],
        [ [1992,10,11,4,0,0],[1992,10,10,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[1993,3,14,2,59,59],[1993,3,13,21,59,59],
          '1992101104:00:00','1992101023:00:00','1993031402:59:59','1993031321:59:59' ],
     ],
   1993 =>
     [
        [ [1993,3,14,3,0,0],[1993,3,13,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[1993,10,10,3,59,59],[1993,10,9,21,59,59],
          '1993031403:00:00','1993031321:00:00','1993101003:59:59','1993100921:59:59' ],
        [ [1993,10,10,4,0,0],[1993,10,9,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[1994,3,13,2,59,59],[1994,3,12,21,59,59],
          '1993101004:00:00','1993100923:00:00','1994031302:59:59','1994031221:59:59' ],
     ],
   1994 =>
     [
        [ [1994,3,13,3,0,0],[1994,3,12,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[1994,10,9,3,59,59],[1994,10,8,21,59,59],
          '1994031303:00:00','1994031221:00:00','1994100903:59:59','1994100821:59:59' ],
        [ [1994,10,9,4,0,0],[1994,10,8,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[1995,3,12,2,59,59],[1995,3,11,21,59,59],
          '1994100904:00:00','1994100823:00:00','1995031202:59:59','1995031121:59:59' ],
     ],
   1995 =>
     [
        [ [1995,3,12,3,0,0],[1995,3,11,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[1995,10,15,3,59,59],[1995,10,14,21,59,59],
          '1995031203:00:00','1995031121:00:00','1995101503:59:59','1995101421:59:59' ],
        [ [1995,10,15,4,0,0],[1995,10,14,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[1996,3,10,2,59,59],[1996,3,9,21,59,59],
          '1995101504:00:00','1995101423:00:00','1996031002:59:59','1996030921:59:59' ],
     ],
   1996 =>
     [
        [ [1996,3,10,3,0,0],[1996,3,9,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[1996,10,13,3,59,59],[1996,10,12,21,59,59],
          '1996031003:00:00','1996030921:00:00','1996101303:59:59','1996101221:59:59' ],
        [ [1996,10,13,4,0,0],[1996,10,12,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[1997,3,30,2,59,59],[1997,3,29,21,59,59],
          '1996101304:00:00','1996101223:00:00','1997033002:59:59','1997032921:59:59' ],
     ],
   1997 =>
     [
        [ [1997,3,30,3,0,0],[1997,3,29,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[1997,10,12,3,59,59],[1997,10,11,21,59,59],
          '1997033003:00:00','1997032921:00:00','1997101203:59:59','1997101121:59:59' ],
        [ [1997,10,12,4,0,0],[1997,10,11,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[1998,3,15,2,59,59],[1998,3,14,21,59,59],
          '1997101204:00:00','1997101123:00:00','1998031502:59:59','1998031421:59:59' ],
     ],
   1998 =>
     [
        [ [1998,3,15,3,0,0],[1998,3,14,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[1998,9,27,3,59,59],[1998,9,26,21,59,59],
          '1998031503:00:00','1998031421:00:00','1998092703:59:59','1998092621:59:59' ],
        [ [1998,9,27,4,0,0],[1998,9,26,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[1999,4,4,2,59,59],[1999,4,3,21,59,59],
          '1998092704:00:00','1998092623:00:00','1999040402:59:59','1999040321:59:59' ],
     ],
   1999 =>
     [
        [ [1999,4,4,3,0,0],[1999,4,3,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[1999,10,10,3,59,59],[1999,10,9,21,59,59],
          '1999040403:00:00','1999040321:00:00','1999101003:59:59','1999100921:59:59' ],
        [ [1999,10,10,4,0,0],[1999,10,9,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2000,3,12,2,59,59],[2000,3,11,21,59,59],
          '1999101004:00:00','1999100923:00:00','2000031202:59:59','2000031121:59:59' ],
     ],
   2000 =>
     [
        [ [2000,3,12,3,0,0],[2000,3,11,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2000,10,15,3,59,59],[2000,10,14,21,59,59],
          '2000031203:00:00','2000031121:00:00','2000101503:59:59','2000101421:59:59' ],
        [ [2000,10,15,4,0,0],[2000,10,14,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2001,3,11,2,59,59],[2001,3,10,21,59,59],
          '2000101504:00:00','2000101423:00:00','2001031102:59:59','2001031021:59:59' ],
     ],
   2001 =>
     [
        [ [2001,3,11,3,0,0],[2001,3,10,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2001,10,14,3,59,59],[2001,10,13,21,59,59],
          '2001031103:00:00','2001031021:00:00','2001101403:59:59','2001101321:59:59' ],
        [ [2001,10,14,4,0,0],[2001,10,13,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2002,3,10,2,59,59],[2002,3,9,21,59,59],
          '2001101404:00:00','2001101323:00:00','2002031002:59:59','2002030921:59:59' ],
     ],
   2002 =>
     [
        [ [2002,3,10,3,0,0],[2002,3,9,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2002,10,13,3,59,59],[2002,10,12,21,59,59],
          '2002031003:00:00','2002030921:00:00','2002101303:59:59','2002101221:59:59' ],
        [ [2002,10,13,4,0,0],[2002,10,12,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2003,3,9,2,59,59],[2003,3,8,21,59,59],
          '2002101304:00:00','2002101223:00:00','2003030902:59:59','2003030821:59:59' ],
     ],
   2003 =>
     [
        [ [2003,3,9,3,0,0],[2003,3,8,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2003,10,12,3,59,59],[2003,10,11,21,59,59],
          '2003030903:00:00','2003030821:00:00','2003101203:59:59','2003101121:59:59' ],
        [ [2003,10,12,4,0,0],[2003,10,11,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2004,3,14,2,59,59],[2004,3,13,21,59,59],
          '2003101204:00:00','2003101123:00:00','2004031402:59:59','2004031321:59:59' ],
     ],
   2004 =>
     [
        [ [2004,3,14,3,0,0],[2004,3,13,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2004,10,10,3,59,59],[2004,10,9,21,59,59],
          '2004031403:00:00','2004031321:00:00','2004101003:59:59','2004100921:59:59' ],
        [ [2004,10,10,4,0,0],[2004,10,9,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2005,3,13,2,59,59],[2005,3,12,21,59,59],
          '2004101004:00:00','2004100923:00:00','2005031302:59:59','2005031221:59:59' ],
     ],
   2005 =>
     [
        [ [2005,3,13,3,0,0],[2005,3,12,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2005,10,9,3,59,59],[2005,10,8,21,59,59],
          '2005031303:00:00','2005031221:00:00','2005100903:59:59','2005100821:59:59' ],
        [ [2005,10,9,4,0,0],[2005,10,8,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2006,3,12,2,59,59],[2006,3,11,21,59,59],
          '2005100904:00:00','2005100823:00:00','2006031202:59:59','2006031121:59:59' ],
     ],
   2006 =>
     [
        [ [2006,3,12,3,0,0],[2006,3,11,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2006,10,15,3,59,59],[2006,10,14,21,59,59],
          '2006031203:00:00','2006031121:00:00','2006101503:59:59','2006101421:59:59' ],
        [ [2006,10,15,4,0,0],[2006,10,14,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2007,3,11,2,59,59],[2007,3,10,21,59,59],
          '2006101504:00:00','2006101423:00:00','2007031102:59:59','2007031021:59:59' ],
     ],
   2007 =>
     [
        [ [2007,3,11,3,0,0],[2007,3,10,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2007,10,14,3,59,59],[2007,10,13,21,59,59],
          '2007031103:00:00','2007031021:00:00','2007101403:59:59','2007101321:59:59' ],
        [ [2007,10,14,4,0,0],[2007,10,13,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2008,3,30,2,59,59],[2008,3,29,21,59,59],
          '2007101404:00:00','2007101323:00:00','2008033002:59:59','2008032921:59:59' ],
     ],
   2008 =>
     [
        [ [2008,3,30,3,0,0],[2008,3,29,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2008,10,12,3,59,59],[2008,10,11,21,59,59],
          '2008033003:00:00','2008032921:00:00','2008101203:59:59','2008101121:59:59' ],
        [ [2008,10,12,4,0,0],[2008,10,11,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2009,3,15,2,59,59],[2009,3,14,21,59,59],
          '2008101204:00:00','2008101123:00:00','2009031502:59:59','2009031421:59:59' ],
     ],
   2009 =>
     [
        [ [2009,3,15,3,0,0],[2009,3,14,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2009,10,11,3,59,59],[2009,10,10,21,59,59],
          '2009031503:00:00','2009031421:00:00','2009101103:59:59','2009101021:59:59' ],
        [ [2009,10,11,4,0,0],[2009,10,10,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2010,4,4,2,59,59],[2010,4,3,21,59,59],
          '2009101104:00:00','2009101023:00:00','2010040402:59:59','2010040321:59:59' ],
     ],
   2010 =>
     [
        [ [2010,4,4,3,0,0],[2010,4,3,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2010,10,10,3,59,59],[2010,10,9,21,59,59],
          '2010040403:00:00','2010040321:00:00','2010101003:59:59','2010100921:59:59' ],
        [ [2010,10,10,4,0,0],[2010,10,9,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2011,5,8,2,59,59],[2011,5,7,21,59,59],
          '2010101004:00:00','2010100923:00:00','2011050802:59:59','2011050721:59:59' ],
     ],
   2011 =>
     [
        [ [2011,5,8,3,0,0],[2011,5,7,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2011,8,21,3,59,59],[2011,8,20,21,59,59],
          '2011050803:00:00','2011050721:00:00','2011082103:59:59','2011082021:59:59' ],
        [ [2011,8,21,4,0,0],[2011,8,20,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2012,4,29,2,59,59],[2012,4,28,21,59,59],
          '2011082104:00:00','2011082023:00:00','2012042902:59:59','2012042821:59:59' ],
     ],
   2012 =>
     [
        [ [2012,4,29,3,0,0],[2012,4,28,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2012,9,2,3,59,59],[2012,9,1,21,59,59],
          '2012042903:00:00','2012042821:00:00','2012090203:59:59','2012090121:59:59' ],
        [ [2012,9,2,4,0,0],[2012,9,1,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2013,4,28,2,59,59],[2013,4,27,21,59,59],
          '2012090204:00:00','2012090123:00:00','2013042802:59:59','2013042721:59:59' ],
     ],
   2013 =>
     [
        [ [2013,4,28,3,0,0],[2013,4,27,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2013,9,8,3,59,59],[2013,9,7,21,59,59],
          '2013042803:00:00','2013042721:00:00','2013090803:59:59','2013090721:59:59' ],
        [ [2013,9,8,4,0,0],[2013,9,7,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2014,4,27,2,59,59],[2014,4,26,21,59,59],
          '2013090804:00:00','2013090723:00:00','2014042702:59:59','2014042621:59:59' ],
     ],
   2014 =>
     [
        [ [2014,4,27,3,0,0],[2014,4,26,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2014,9,7,3,59,59],[2014,9,6,21,59,59],
          '2014042703:00:00','2014042621:00:00','2014090703:59:59','2014090621:59:59' ],
        [ [2014,9,7,4,0,0],[2014,9,6,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2016,5,15,2,59,59],[2016,5,14,21,59,59],
          '2014090704:00:00','2014090623:00:00','2016051502:59:59','2016051421:59:59' ],
     ],
   2016 =>
     [
        [ [2016,5,15,3,0,0],[2016,5,14,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2016,8,14,3,59,59],[2016,8,13,21,59,59],
          '2016051503:00:00','2016051421:00:00','2016081403:59:59','2016081321:59:59' ],
        [ [2016,8,14,4,0,0],[2016,8,13,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2017,5,14,2,59,59],[2017,5,13,21,59,59],
          '2016081404:00:00','2016081323:00:00','2017051402:59:59','2017051321:59:59' ],
     ],
   2017 =>
     [
        [ [2017,5,14,3,0,0],[2017,5,13,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2017,8,13,3,59,59],[2017,8,12,21,59,59],
          '2017051403:00:00','2017051321:00:00','2017081303:59:59','2017081221:59:59' ],
        [ [2017,8,13,4,0,0],[2017,8,12,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2018,5,13,2,59,59],[2018,5,12,21,59,59],
          '2017081304:00:00','2017081223:00:00','2018051302:59:59','2018051221:59:59' ],
     ],
   2018 =>
     [
        [ [2018,5,13,3,0,0],[2018,5,12,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2018,8,12,3,59,59],[2018,8,11,21,59,59],
          '2018051303:00:00','2018051221:00:00','2018081203:59:59','2018081121:59:59' ],
        [ [2018,8,12,4,0,0],[2018,8,11,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2019,4,7,2,59,59],[2019,4,6,21,59,59],
          '2018081204:00:00','2018081123:00:00','2019040702:59:59','2019040621:59:59' ],
     ],
   2019 =>
     [
        [ [2019,4,7,3,0,0],[2019,4,6,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2019,9,8,3,59,59],[2019,9,7,21,59,59],
          '2019040703:00:00','2019040621:00:00','2019090803:59:59','2019090721:59:59' ],
        [ [2019,9,8,4,0,0],[2019,9,7,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2020,4,5,2,59,59],[2020,4,4,21,59,59],
          '2019090804:00:00','2019090723:00:00','2020040502:59:59','2020040421:59:59' ],
     ],
   2020 =>
     [
        [ [2020,4,5,3,0,0],[2020,4,4,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2020,9,6,3,59,59],[2020,9,5,21,59,59],
          '2020040503:00:00','2020040421:00:00','2020090603:59:59','2020090521:59:59' ],
        [ [2020,9,6,4,0,0],[2020,9,5,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2021,4,4,2,59,59],[2021,4,3,21,59,59],
          '2020090604:00:00','2020090523:00:00','2021040402:59:59','2021040321:59:59' ],
     ],
   2021 =>
     [
        [ [2021,4,4,3,0,0],[2021,4,3,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2021,9,5,3,59,59],[2021,9,4,21,59,59],
          '2021040403:00:00','2021040321:00:00','2021090503:59:59','2021090421:59:59' ],
        [ [2021,9,5,4,0,0],[2021,9,4,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2022,4,3,2,59,59],[2022,4,2,21,59,59],
          '2021090504:00:00','2021090423:00:00','2022040302:59:59','2022040221:59:59' ],
     ],
   2022 =>
     [
        [ [2022,4,3,3,0,0],[2022,4,2,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2022,9,4,3,59,59],[2022,9,3,21,59,59],
          '2022040303:00:00','2022040221:00:00','2022090403:59:59','2022090321:59:59' ],
        [ [2022,9,4,4,0,0],[2022,9,3,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2023,4,2,2,59,59],[2023,4,1,21,59,59],
          '2022090404:00:00','2022090323:00:00','2023040202:59:59','2023040121:59:59' ],
     ],
   2023 =>
     [
        [ [2023,4,2,3,0,0],[2023,4,1,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2023,9,3,3,59,59],[2023,9,2,21,59,59],
          '2023040203:00:00','2023040121:00:00','2023090303:59:59','2023090221:59:59' ],
        [ [2023,9,3,4,0,0],[2023,9,2,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2024,4,7,2,59,59],[2024,4,6,21,59,59],
          '2023090304:00:00','2023090223:00:00','2024040702:59:59','2024040621:59:59' ],
     ],
   2024 =>
     [
        [ [2024,4,7,3,0,0],[2024,4,6,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2024,9,8,3,59,59],[2024,9,7,21,59,59],
          '2024040703:00:00','2024040621:00:00','2024090803:59:59','2024090721:59:59' ],
        [ [2024,9,8,4,0,0],[2024,9,7,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2025,4,6,2,59,59],[2025,4,5,21,59,59],
          '2024090804:00:00','2024090723:00:00','2025040602:59:59','2025040521:59:59' ],
     ],
   2025 =>
     [
        [ [2025,4,6,3,0,0],[2025,4,5,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2025,9,7,3,59,59],[2025,9,6,21,59,59],
          '2025040603:00:00','2025040521:00:00','2025090703:59:59','2025090621:59:59' ],
        [ [2025,9,7,4,0,0],[2025,9,6,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2026,4,5,2,59,59],[2026,4,4,21,59,59],
          '2025090704:00:00','2025090623:00:00','2026040502:59:59','2026040421:59:59' ],
     ],
   2026 =>
     [
        [ [2026,4,5,3,0,0],[2026,4,4,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2026,9,6,3,59,59],[2026,9,5,21,59,59],
          '2026040503:00:00','2026040421:00:00','2026090603:59:59','2026090521:59:59' ],
        [ [2026,9,6,4,0,0],[2026,9,5,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2027,4,4,2,59,59],[2027,4,3,21,59,59],
          '2026090604:00:00','2026090523:00:00','2027040402:59:59','2027040321:59:59' ],
     ],
   2027 =>
     [
        [ [2027,4,4,3,0,0],[2027,4,3,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2027,9,5,3,59,59],[2027,9,4,21,59,59],
          '2027040403:00:00','2027040321:00:00','2027090503:59:59','2027090421:59:59' ],
        [ [2027,9,5,4,0,0],[2027,9,4,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2028,4,2,2,59,59],[2028,4,1,21,59,59],
          '2027090504:00:00','2027090423:00:00','2028040202:59:59','2028040121:59:59' ],
     ],
   2028 =>
     [
        [ [2028,4,2,3,0,0],[2028,4,1,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2028,9,3,3,59,59],[2028,9,2,21,59,59],
          '2028040203:00:00','2028040121:00:00','2028090303:59:59','2028090221:59:59' ],
        [ [2028,9,3,4,0,0],[2028,9,2,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2029,4,8,2,59,59],[2029,4,7,21,59,59],
          '2028090304:00:00','2028090223:00:00','2029040802:59:59','2029040721:59:59' ],
     ],
   2029 =>
     [
        [ [2029,4,8,3,0,0],[2029,4,7,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2029,9,2,3,59,59],[2029,9,1,21,59,59],
          '2029040803:00:00','2029040721:00:00','2029090203:59:59','2029090121:59:59' ],
        [ [2029,9,2,4,0,0],[2029,9,1,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2030,4,7,2,59,59],[2030,4,6,21,59,59],
          '2029090204:00:00','2029090123:00:00','2030040702:59:59','2030040621:59:59' ],
     ],
   2030 =>
     [
        [ [2030,4,7,3,0,0],[2030,4,6,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2030,9,8,3,59,59],[2030,9,7,21,59,59],
          '2030040703:00:00','2030040621:00:00','2030090803:59:59','2030090721:59:59' ],
        [ [2030,9,8,4,0,0],[2030,9,7,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2031,4,6,2,59,59],[2031,4,5,21,59,59],
          '2030090804:00:00','2030090723:00:00','2031040602:59:59','2031040521:59:59' ],
     ],
   2031 =>
     [
        [ [2031,4,6,3,0,0],[2031,4,5,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2031,9,7,3,59,59],[2031,9,6,21,59,59],
          '2031040603:00:00','2031040521:00:00','2031090703:59:59','2031090621:59:59' ],
        [ [2031,9,7,4,0,0],[2031,9,6,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2032,4,4,2,59,59],[2032,4,3,21,59,59],
          '2031090704:00:00','2031090623:00:00','2032040402:59:59','2032040321:59:59' ],
     ],
   2032 =>
     [
        [ [2032,4,4,3,0,0],[2032,4,3,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2032,9,5,3,59,59],[2032,9,4,21,59,59],
          '2032040403:00:00','2032040321:00:00','2032090503:59:59','2032090421:59:59' ],
        [ [2032,9,5,4,0,0],[2032,9,4,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2033,4,3,2,59,59],[2033,4,2,21,59,59],
          '2032090504:00:00','2032090423:00:00','2033040302:59:59','2033040221:59:59' ],
     ],
   2033 =>
     [
        [ [2033,4,3,3,0,0],[2033,4,2,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2033,9,4,3,59,59],[2033,9,3,21,59,59],
          '2033040303:00:00','2033040221:00:00','2033090403:59:59','2033090321:59:59' ],
        [ [2033,9,4,4,0,0],[2033,9,3,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2034,4,2,2,59,59],[2034,4,1,21,59,59],
          '2033090404:00:00','2033090323:00:00','2034040202:59:59','2034040121:59:59' ],
     ],
   2034 =>
     [
        [ [2034,4,2,3,0,0],[2034,4,1,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2034,9,3,3,59,59],[2034,9,2,21,59,59],
          '2034040203:00:00','2034040121:00:00','2034090303:59:59','2034090221:59:59' ],
        [ [2034,9,3,4,0,0],[2034,9,2,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2035,4,8,2,59,59],[2035,4,7,21,59,59],
          '2034090304:00:00','2034090223:00:00','2035040802:59:59','2035040721:59:59' ],
     ],
   2035 =>
     [
        [ [2035,4,8,3,0,0],[2035,4,7,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2035,9,2,3,59,59],[2035,9,1,21,59,59],
          '2035040803:00:00','2035040721:00:00','2035090203:59:59','2035090121:59:59' ],
        [ [2035,9,2,4,0,0],[2035,9,1,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2036,4,6,2,59,59],[2036,4,5,21,59,59],
          '2035090204:00:00','2035090123:00:00','2036040602:59:59','2036040521:59:59' ],
     ],
   2036 =>
     [
        [ [2036,4,6,3,0,0],[2036,4,5,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2036,9,7,3,59,59],[2036,9,6,21,59,59],
          '2036040603:00:00','2036040521:00:00','2036090703:59:59','2036090621:59:59' ],
        [ [2036,9,7,4,0,0],[2036,9,6,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2037,4,5,2,59,59],[2037,4,4,21,59,59],
          '2036090704:00:00','2036090623:00:00','2037040502:59:59','2037040421:59:59' ],
     ],
   2037 =>
     [
        [ [2037,4,5,3,0,0],[2037,4,4,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2037,9,6,3,59,59],[2037,9,5,21,59,59],
          '2037040503:00:00','2037040421:00:00','2037090603:59:59','2037090521:59:59' ],
        [ [2037,9,6,4,0,0],[2037,9,5,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2038,4,4,2,59,59],[2038,4,3,21,59,59],
          '2037090604:00:00','2037090523:00:00','2038040402:59:59','2038040321:59:59' ],
     ],
   2038 =>
     [
        [ [2038,4,4,3,0,0],[2038,4,3,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2038,9,5,3,59,59],[2038,9,4,21,59,59],
          '2038040403:00:00','2038040321:00:00','2038090503:59:59','2038090421:59:59' ],
        [ [2038,9,5,4,0,0],[2038,9,4,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2039,4,3,2,59,59],[2039,4,2,21,59,59],
          '2038090504:00:00','2038090423:00:00','2039040302:59:59','2039040221:59:59' ],
     ],
   2039 =>
     [
        [ [2039,4,3,3,0,0],[2039,4,2,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2039,9,4,3,59,59],[2039,9,3,21,59,59],
          '2039040303:00:00','2039040221:00:00','2039090403:59:59','2039090321:59:59' ],
        [ [2039,9,4,4,0,0],[2039,9,3,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2040,4,8,2,59,59],[2040,4,7,21,59,59],
          '2039090404:00:00','2039090323:00:00','2040040802:59:59','2040040721:59:59' ],
     ],
   2040 =>
     [
        [ [2040,4,8,3,0,0],[2040,4,7,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2040,9,2,3,59,59],[2040,9,1,21,59,59],
          '2040040803:00:00','2040040721:00:00','2040090203:59:59','2040090121:59:59' ],
        [ [2040,9,2,4,0,0],[2040,9,1,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2041,4,7,2,59,59],[2041,4,6,21,59,59],
          '2040090204:00:00','2040090123:00:00','2041040702:59:59','2041040621:59:59' ],
     ],
   2041 =>
     [
        [ [2041,4,7,3,0,0],[2041,4,6,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2041,9,8,3,59,59],[2041,9,7,21,59,59],
          '2041040703:00:00','2041040621:00:00','2041090803:59:59','2041090721:59:59' ],
        [ [2041,9,8,4,0,0],[2041,9,7,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2042,4,6,2,59,59],[2042,4,5,21,59,59],
          '2041090804:00:00','2041090723:00:00','2042040602:59:59','2042040521:59:59' ],
     ],
   2042 =>
     [
        [ [2042,4,6,3,0,0],[2042,4,5,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2042,9,7,3,59,59],[2042,9,6,21,59,59],
          '2042040603:00:00','2042040521:00:00','2042090703:59:59','2042090621:59:59' ],
        [ [2042,9,7,4,0,0],[2042,9,6,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2043,4,5,2,59,59],[2043,4,4,21,59,59],
          '2042090704:00:00','2042090623:00:00','2043040502:59:59','2043040421:59:59' ],
     ],
   2043 =>
     [
        [ [2043,4,5,3,0,0],[2043,4,4,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2043,9,6,3,59,59],[2043,9,5,21,59,59],
          '2043040503:00:00','2043040421:00:00','2043090603:59:59','2043090521:59:59' ],
        [ [2043,9,6,4,0,0],[2043,9,5,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2044,4,3,2,59,59],[2044,4,2,21,59,59],
          '2043090604:00:00','2043090523:00:00','2044040302:59:59','2044040221:59:59' ],
     ],
   2044 =>
     [
        [ [2044,4,3,3,0,0],[2044,4,2,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2044,9,4,3,59,59],[2044,9,3,21,59,59],
          '2044040303:00:00','2044040221:00:00','2044090403:59:59','2044090321:59:59' ],
        [ [2044,9,4,4,0,0],[2044,9,3,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2045,4,2,2,59,59],[2045,4,1,21,59,59],
          '2044090404:00:00','2044090323:00:00','2045040202:59:59','2045040121:59:59' ],
     ],
   2045 =>
     [
        [ [2045,4,2,3,0,0],[2045,4,1,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2045,9,3,3,59,59],[2045,9,2,21,59,59],
          '2045040203:00:00','2045040121:00:00','2045090303:59:59','2045090221:59:59' ],
        [ [2045,9,3,4,0,0],[2045,9,2,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2046,4,8,2,59,59],[2046,4,7,21,59,59],
          '2045090304:00:00','2045090223:00:00','2046040802:59:59','2046040721:59:59' ],
     ],
   2046 =>
     [
        [ [2046,4,8,3,0,0],[2046,4,7,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2046,9,2,3,59,59],[2046,9,1,21,59,59],
          '2046040803:00:00','2046040721:00:00','2046090203:59:59','2046090121:59:59' ],
        [ [2046,9,2,4,0,0],[2046,9,1,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2047,4,7,2,59,59],[2047,4,6,21,59,59],
          '2046090204:00:00','2046090123:00:00','2047040702:59:59','2047040621:59:59' ],
     ],
   2047 =>
     [
        [ [2047,4,7,3,0,0],[2047,4,6,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2047,9,8,3,59,59],[2047,9,7,21,59,59],
          '2047040703:00:00','2047040621:00:00','2047090803:59:59','2047090721:59:59' ],
        [ [2047,9,8,4,0,0],[2047,9,7,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2048,4,5,2,59,59],[2048,4,4,21,59,59],
          '2047090804:00:00','2047090723:00:00','2048040502:59:59','2048040421:59:59' ],
     ],
   2048 =>
     [
        [ [2048,4,5,3,0,0],[2048,4,4,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2048,9,6,3,59,59],[2048,9,5,21,59,59],
          '2048040503:00:00','2048040421:00:00','2048090603:59:59','2048090521:59:59' ],
        [ [2048,9,6,4,0,0],[2048,9,5,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2049,4,4,2,59,59],[2049,4,3,21,59,59],
          '2048090604:00:00','2048090523:00:00','2049040402:59:59','2049040321:59:59' ],
     ],
   2049 =>
     [
        [ [2049,4,4,3,0,0],[2049,4,3,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2049,9,5,3,59,59],[2049,9,4,21,59,59],
          '2049040403:00:00','2049040321:00:00','2049090503:59:59','2049090421:59:59' ],
        [ [2049,9,5,4,0,0],[2049,9,4,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2050,4,3,2,59,59],[2050,4,2,21,59,59],
          '2049090504:00:00','2049090423:00:00','2050040302:59:59','2050040221:59:59' ],
     ],
   2050 =>
     [
        [ [2050,4,3,3,0,0],[2050,4,2,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2050,9,4,3,59,59],[2050,9,3,21,59,59],
          '2050040303:00:00','2050040221:00:00','2050090403:59:59','2050090321:59:59' ],
        [ [2050,9,4,4,0,0],[2050,9,3,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2051,4,2,2,59,59],[2051,4,1,21,59,59],
          '2050090404:00:00','2050090323:00:00','2051040202:59:59','2051040121:59:59' ],
     ],
   2051 =>
     [
        [ [2051,4,2,3,0,0],[2051,4,1,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2051,9,3,3,59,59],[2051,9,2,21,59,59],
          '2051040203:00:00','2051040121:00:00','2051090303:59:59','2051090221:59:59' ],
        [ [2051,9,3,4,0,0],[2051,9,2,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2052,4,7,2,59,59],[2052,4,6,21,59,59],
          '2051090304:00:00','2051090223:00:00','2052040702:59:59','2052040621:59:59' ],
     ],
   2052 =>
     [
        [ [2052,4,7,3,0,0],[2052,4,6,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2052,9,8,3,59,59],[2052,9,7,21,59,59],
          '2052040703:00:00','2052040621:00:00','2052090803:59:59','2052090721:59:59' ],
        [ [2052,9,8,4,0,0],[2052,9,7,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2053,4,6,2,59,59],[2053,4,5,21,59,59],
          '2052090804:00:00','2052090723:00:00','2053040602:59:59','2053040521:59:59' ],
     ],
   2053 =>
     [
        [ [2053,4,6,3,0,0],[2053,4,5,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2053,9,7,3,59,59],[2053,9,6,21,59,59],
          '2053040603:00:00','2053040521:00:00','2053090703:59:59','2053090621:59:59' ],
        [ [2053,9,7,4,0,0],[2053,9,6,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2054,4,5,2,59,59],[2054,4,4,21,59,59],
          '2053090704:00:00','2053090623:00:00','2054040502:59:59','2054040421:59:59' ],
     ],
   2054 =>
     [
        [ [2054,4,5,3,0,0],[2054,4,4,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2054,9,6,3,59,59],[2054,9,5,21,59,59],
          '2054040503:00:00','2054040421:00:00','2054090603:59:59','2054090521:59:59' ],
        [ [2054,9,6,4,0,0],[2054,9,5,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2055,4,4,2,59,59],[2055,4,3,21,59,59],
          '2054090604:00:00','2054090523:00:00','2055040402:59:59','2055040321:59:59' ],
     ],
   2055 =>
     [
        [ [2055,4,4,3,0,0],[2055,4,3,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2055,9,5,3,59,59],[2055,9,4,21,59,59],
          '2055040403:00:00','2055040321:00:00','2055090503:59:59','2055090421:59:59' ],
        [ [2055,9,5,4,0,0],[2055,9,4,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2056,4,2,2,59,59],[2056,4,1,21,59,59],
          '2055090504:00:00','2055090423:00:00','2056040202:59:59','2056040121:59:59' ],
     ],
   2056 =>
     [
        [ [2056,4,2,3,0,0],[2056,4,1,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2056,9,3,3,59,59],[2056,9,2,21,59,59],
          '2056040203:00:00','2056040121:00:00','2056090303:59:59','2056090221:59:59' ],
        [ [2056,9,3,4,0,0],[2056,9,2,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2057,4,8,2,59,59],[2057,4,7,21,59,59],
          '2056090304:00:00','2056090223:00:00','2057040802:59:59','2057040721:59:59' ],
     ],
   2057 =>
     [
        [ [2057,4,8,3,0,0],[2057,4,7,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2057,9,2,3,59,59],[2057,9,1,21,59,59],
          '2057040803:00:00','2057040721:00:00','2057090203:59:59','2057090121:59:59' ],
        [ [2057,9,2,4,0,0],[2057,9,1,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2058,4,7,2,59,59],[2058,4,6,21,59,59],
          '2057090204:00:00','2057090123:00:00','2058040702:59:59','2058040621:59:59' ],
     ],
   2058 =>
     [
        [ [2058,4,7,3,0,0],[2058,4,6,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2058,9,8,3,59,59],[2058,9,7,21,59,59],
          '2058040703:00:00','2058040621:00:00','2058090803:59:59','2058090721:59:59' ],
        [ [2058,9,8,4,0,0],[2058,9,7,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2059,4,6,2,59,59],[2059,4,5,21,59,59],
          '2058090804:00:00','2058090723:00:00','2059040602:59:59','2059040521:59:59' ],
     ],
   2059 =>
     [
        [ [2059,4,6,3,0,0],[2059,4,5,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2059,9,7,3,59,59],[2059,9,6,21,59,59],
          '2059040603:00:00','2059040521:00:00','2059090703:59:59','2059090621:59:59' ],
        [ [2059,9,7,4,0,0],[2059,9,6,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2060,4,4,2,59,59],[2060,4,3,21,59,59],
          '2059090704:00:00','2059090623:00:00','2060040402:59:59','2060040321:59:59' ],
     ],
   2060 =>
     [
        [ [2060,4,4,3,0,0],[2060,4,3,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2060,9,5,3,59,59],[2060,9,4,21,59,59],
          '2060040403:00:00','2060040321:00:00','2060090503:59:59','2060090421:59:59' ],
        [ [2060,9,5,4,0,0],[2060,9,4,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2061,4,3,2,59,59],[2061,4,2,21,59,59],
          '2060090504:00:00','2060090423:00:00','2061040302:59:59','2061040221:59:59' ],
     ],
   2061 =>
     [
        [ [2061,4,3,3,0,0],[2061,4,2,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2061,9,4,3,59,59],[2061,9,3,21,59,59],
          '2061040303:00:00','2061040221:00:00','2061090403:59:59','2061090321:59:59' ],
        [ [2061,9,4,4,0,0],[2061,9,3,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2062,4,2,2,59,59],[2062,4,1,21,59,59],
          '2061090404:00:00','2061090323:00:00','2062040202:59:59','2062040121:59:59' ],
     ],
   2062 =>
     [
        [ [2062,4,2,3,0,0],[2062,4,1,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2062,9,3,3,59,59],[2062,9,2,21,59,59],
          '2062040203:00:00','2062040121:00:00','2062090303:59:59','2062090221:59:59' ],
        [ [2062,9,3,4,0,0],[2062,9,2,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2063,4,8,2,59,59],[2063,4,7,21,59,59],
          '2062090304:00:00','2062090223:00:00','2063040802:59:59','2063040721:59:59' ],
     ],
   2063 =>
     [
        [ [2063,4,8,3,0,0],[2063,4,7,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2063,9,2,3,59,59],[2063,9,1,21,59,59],
          '2063040803:00:00','2063040721:00:00','2063090203:59:59','2063090121:59:59' ],
        [ [2063,9,2,4,0,0],[2063,9,1,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2064,4,6,2,59,59],[2064,4,5,21,59,59],
          '2063090204:00:00','2063090123:00:00','2064040602:59:59','2064040521:59:59' ],
     ],
   2064 =>
     [
        [ [2064,4,6,3,0,0],[2064,4,5,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2064,9,7,3,59,59],[2064,9,6,21,59,59],
          '2064040603:00:00','2064040521:00:00','2064090703:59:59','2064090621:59:59' ],
        [ [2064,9,7,4,0,0],[2064,9,6,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2065,4,5,2,59,59],[2065,4,4,21,59,59],
          '2064090704:00:00','2064090623:00:00','2065040502:59:59','2065040421:59:59' ],
     ],
   2065 =>
     [
        [ [2065,4,5,3,0,0],[2065,4,4,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2065,9,6,3,59,59],[2065,9,5,21,59,59],
          '2065040503:00:00','2065040421:00:00','2065090603:59:59','2065090521:59:59' ],
        [ [2065,9,6,4,0,0],[2065,9,5,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2066,4,4,2,59,59],[2066,4,3,21,59,59],
          '2065090604:00:00','2065090523:00:00','2066040402:59:59','2066040321:59:59' ],
     ],
   2066 =>
     [
        [ [2066,4,4,3,0,0],[2066,4,3,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2066,9,5,3,59,59],[2066,9,4,21,59,59],
          '2066040403:00:00','2066040321:00:00','2066090503:59:59','2066090421:59:59' ],
        [ [2066,9,5,4,0,0],[2066,9,4,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2067,4,3,2,59,59],[2067,4,2,21,59,59],
          '2066090504:00:00','2066090423:00:00','2067040302:59:59','2067040221:59:59' ],
     ],
   2067 =>
     [
        [ [2067,4,3,3,0,0],[2067,4,2,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2067,9,4,3,59,59],[2067,9,3,21,59,59],
          '2067040303:00:00','2067040221:00:00','2067090403:59:59','2067090321:59:59' ],
        [ [2067,9,4,4,0,0],[2067,9,3,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2068,4,8,2,59,59],[2068,4,7,21,59,59],
          '2067090404:00:00','2067090323:00:00','2068040802:59:59','2068040721:59:59' ],
     ],
   2068 =>
     [
        [ [2068,4,8,3,0,0],[2068,4,7,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2068,9,2,3,59,59],[2068,9,1,21,59,59],
          '2068040803:00:00','2068040721:00:00','2068090203:59:59','2068090121:59:59' ],
        [ [2068,9,2,4,0,0],[2068,9,1,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2069,4,7,2,59,59],[2069,4,6,21,59,59],
          '2068090204:00:00','2068090123:00:00','2069040702:59:59','2069040621:59:59' ],
     ],
   2069 =>
     [
        [ [2069,4,7,3,0,0],[2069,4,6,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2069,9,8,3,59,59],[2069,9,7,21,59,59],
          '2069040703:00:00','2069040621:00:00','2069090803:59:59','2069090721:59:59' ],
        [ [2069,9,8,4,0,0],[2069,9,7,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2070,4,6,2,59,59],[2070,4,5,21,59,59],
          '2069090804:00:00','2069090723:00:00','2070040602:59:59','2070040521:59:59' ],
     ],
   2070 =>
     [
        [ [2070,4,6,3,0,0],[2070,4,5,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2070,9,7,3,59,59],[2070,9,6,21,59,59],
          '2070040603:00:00','2070040521:00:00','2070090703:59:59','2070090621:59:59' ],
        [ [2070,9,7,4,0,0],[2070,9,6,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2071,4,5,2,59,59],[2071,4,4,21,59,59],
          '2070090704:00:00','2070090623:00:00','2071040502:59:59','2071040421:59:59' ],
     ],
   2071 =>
     [
        [ [2071,4,5,3,0,0],[2071,4,4,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2071,9,6,3,59,59],[2071,9,5,21,59,59],
          '2071040503:00:00','2071040421:00:00','2071090603:59:59','2071090521:59:59' ],
        [ [2071,9,6,4,0,0],[2071,9,5,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2072,4,3,2,59,59],[2072,4,2,21,59,59],
          '2071090604:00:00','2071090523:00:00','2072040302:59:59','2072040221:59:59' ],
     ],
   2072 =>
     [
        [ [2072,4,3,3,0,0],[2072,4,2,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2072,9,4,3,59,59],[2072,9,3,21,59,59],
          '2072040303:00:00','2072040221:00:00','2072090403:59:59','2072090321:59:59' ],
        [ [2072,9,4,4,0,0],[2072,9,3,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2073,4,2,2,59,59],[2073,4,1,21,59,59],
          '2072090404:00:00','2072090323:00:00','2073040202:59:59','2073040121:59:59' ],
     ],
   2073 =>
     [
        [ [2073,4,2,3,0,0],[2073,4,1,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2073,9,3,3,59,59],[2073,9,2,21,59,59],
          '2073040203:00:00','2073040121:00:00','2073090303:59:59','2073090221:59:59' ],
        [ [2073,9,3,4,0,0],[2073,9,2,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2074,4,8,2,59,59],[2074,4,7,21,59,59],
          '2073090304:00:00','2073090223:00:00','2074040802:59:59','2074040721:59:59' ],
     ],
   2074 =>
     [
        [ [2074,4,8,3,0,0],[2074,4,7,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2074,9,2,3,59,59],[2074,9,1,21,59,59],
          '2074040803:00:00','2074040721:00:00','2074090203:59:59','2074090121:59:59' ],
        [ [2074,9,2,4,0,0],[2074,9,1,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2075,4,7,2,59,59],[2075,4,6,21,59,59],
          '2074090204:00:00','2074090123:00:00','2075040702:59:59','2075040621:59:59' ],
     ],
   2075 =>
     [
        [ [2075,4,7,3,0,0],[2075,4,6,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2075,9,8,3,59,59],[2075,9,7,21,59,59],
          '2075040703:00:00','2075040621:00:00','2075090803:59:59','2075090721:59:59' ],
        [ [2075,9,8,4,0,0],[2075,9,7,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2076,4,5,2,59,59],[2076,4,4,21,59,59],
          '2075090804:00:00','2075090723:00:00','2076040502:59:59','2076040421:59:59' ],
     ],
   2076 =>
     [
        [ [2076,4,5,3,0,0],[2076,4,4,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2076,9,6,3,59,59],[2076,9,5,21,59,59],
          '2076040503:00:00','2076040421:00:00','2076090603:59:59','2076090521:59:59' ],
        [ [2076,9,6,4,0,0],[2076,9,5,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2077,4,4,2,59,59],[2077,4,3,21,59,59],
          '2076090604:00:00','2076090523:00:00','2077040402:59:59','2077040321:59:59' ],
     ],
   2077 =>
     [
        [ [2077,4,4,3,0,0],[2077,4,3,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2077,9,5,3,59,59],[2077,9,4,21,59,59],
          '2077040403:00:00','2077040321:00:00','2077090503:59:59','2077090421:59:59' ],
        [ [2077,9,5,4,0,0],[2077,9,4,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2078,4,3,2,59,59],[2078,4,2,21,59,59],
          '2077090504:00:00','2077090423:00:00','2078040302:59:59','2078040221:59:59' ],
     ],
   2078 =>
     [
        [ [2078,4,3,3,0,0],[2078,4,2,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2078,9,4,3,59,59],[2078,9,3,21,59,59],
          '2078040303:00:00','2078040221:00:00','2078090403:59:59','2078090321:59:59' ],
        [ [2078,9,4,4,0,0],[2078,9,3,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2079,4,2,2,59,59],[2079,4,1,21,59,59],
          '2078090404:00:00','2078090323:00:00','2079040202:59:59','2079040121:59:59' ],
     ],
   2079 =>
     [
        [ [2079,4,2,3,0,0],[2079,4,1,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2079,9,3,3,59,59],[2079,9,2,21,59,59],
          '2079040203:00:00','2079040121:00:00','2079090303:59:59','2079090221:59:59' ],
        [ [2079,9,3,4,0,0],[2079,9,2,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2080,4,7,2,59,59],[2080,4,6,21,59,59],
          '2079090304:00:00','2079090223:00:00','2080040702:59:59','2080040621:59:59' ],
     ],
   2080 =>
     [
        [ [2080,4,7,3,0,0],[2080,4,6,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2080,9,8,3,59,59],[2080,9,7,21,59,59],
          '2080040703:00:00','2080040621:00:00','2080090803:59:59','2080090721:59:59' ],
        [ [2080,9,8,4,0,0],[2080,9,7,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2081,4,6,2,59,59],[2081,4,5,21,59,59],
          '2080090804:00:00','2080090723:00:00','2081040602:59:59','2081040521:59:59' ],
     ],
   2081 =>
     [
        [ [2081,4,6,3,0,0],[2081,4,5,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2081,9,7,3,59,59],[2081,9,6,21,59,59],
          '2081040603:00:00','2081040521:00:00','2081090703:59:59','2081090621:59:59' ],
        [ [2081,9,7,4,0,0],[2081,9,6,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2082,4,5,2,59,59],[2082,4,4,21,59,59],
          '2081090704:00:00','2081090623:00:00','2082040502:59:59','2082040421:59:59' ],
     ],
   2082 =>
     [
        [ [2082,4,5,3,0,0],[2082,4,4,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2082,9,6,3,59,59],[2082,9,5,21,59,59],
          '2082040503:00:00','2082040421:00:00','2082090603:59:59','2082090521:59:59' ],
        [ [2082,9,6,4,0,0],[2082,9,5,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2083,4,4,2,59,59],[2083,4,3,21,59,59],
          '2082090604:00:00','2082090523:00:00','2083040402:59:59','2083040321:59:59' ],
     ],
   2083 =>
     [
        [ [2083,4,4,3,0,0],[2083,4,3,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2083,9,5,3,59,59],[2083,9,4,21,59,59],
          '2083040403:00:00','2083040321:00:00','2083090503:59:59','2083090421:59:59' ],
        [ [2083,9,5,4,0,0],[2083,9,4,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2084,4,2,2,59,59],[2084,4,1,21,59,59],
          '2083090504:00:00','2083090423:00:00','2084040202:59:59','2084040121:59:59' ],
     ],
   2084 =>
     [
        [ [2084,4,2,3,0,0],[2084,4,1,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2084,9,3,3,59,59],[2084,9,2,21,59,59],
          '2084040203:00:00','2084040121:00:00','2084090303:59:59','2084090221:59:59' ],
        [ [2084,9,3,4,0,0],[2084,9,2,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2085,4,8,2,59,59],[2085,4,7,21,59,59],
          '2084090304:00:00','2084090223:00:00','2085040802:59:59','2085040721:59:59' ],
     ],
   2085 =>
     [
        [ [2085,4,8,3,0,0],[2085,4,7,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2085,9,2,3,59,59],[2085,9,1,21,59,59],
          '2085040803:00:00','2085040721:00:00','2085090203:59:59','2085090121:59:59' ],
        [ [2085,9,2,4,0,0],[2085,9,1,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2086,4,7,2,59,59],[2086,4,6,21,59,59],
          '2085090204:00:00','2085090123:00:00','2086040702:59:59','2086040621:59:59' ],
     ],
   2086 =>
     [
        [ [2086,4,7,3,0,0],[2086,4,6,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2086,9,8,3,59,59],[2086,9,7,21,59,59],
          '2086040703:00:00','2086040621:00:00','2086090803:59:59','2086090721:59:59' ],
        [ [2086,9,8,4,0,0],[2086,9,7,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2087,4,6,2,59,59],[2087,4,5,21,59,59],
          '2086090804:00:00','2086090723:00:00','2087040602:59:59','2087040521:59:59' ],
     ],
   2087 =>
     [
        [ [2087,4,6,3,0,0],[2087,4,5,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2087,9,7,3,59,59],[2087,9,6,21,59,59],
          '2087040603:00:00','2087040521:00:00','2087090703:59:59','2087090621:59:59' ],
        [ [2087,9,7,4,0,0],[2087,9,6,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2088,4,4,2,59,59],[2088,4,3,21,59,59],
          '2087090704:00:00','2087090623:00:00','2088040402:59:59','2088040321:59:59' ],
     ],
   2088 =>
     [
        [ [2088,4,4,3,0,0],[2088,4,3,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2088,9,5,3,59,59],[2088,9,4,21,59,59],
          '2088040403:00:00','2088040321:00:00','2088090503:59:59','2088090421:59:59' ],
        [ [2088,9,5,4,0,0],[2088,9,4,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2089,4,3,2,59,59],[2089,4,2,21,59,59],
          '2088090504:00:00','2088090423:00:00','2089040302:59:59','2089040221:59:59' ],
     ],
   2089 =>
     [
        [ [2089,4,3,3,0,0],[2089,4,2,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2089,9,4,3,59,59],[2089,9,3,21,59,59],
          '2089040303:00:00','2089040221:00:00','2089090403:59:59','2089090321:59:59' ],
        [ [2089,9,4,4,0,0],[2089,9,3,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2090,4,2,2,59,59],[2090,4,1,21,59,59],
          '2089090404:00:00','2089090323:00:00','2090040202:59:59','2090040121:59:59' ],
     ],
   2090 =>
     [
        [ [2090,4,2,3,0,0],[2090,4,1,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2090,9,3,3,59,59],[2090,9,2,21,59,59],
          '2090040203:00:00','2090040121:00:00','2090090303:59:59','2090090221:59:59' ],
        [ [2090,9,3,4,0,0],[2090,9,2,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2091,4,8,2,59,59],[2091,4,7,21,59,59],
          '2090090304:00:00','2090090223:00:00','2091040802:59:59','2091040721:59:59' ],
     ],
   2091 =>
     [
        [ [2091,4,8,3,0,0],[2091,4,7,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2091,9,2,3,59,59],[2091,9,1,21,59,59],
          '2091040803:00:00','2091040721:00:00','2091090203:59:59','2091090121:59:59' ],
        [ [2091,9,2,4,0,0],[2091,9,1,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2092,4,6,2,59,59],[2092,4,5,21,59,59],
          '2091090204:00:00','2091090123:00:00','2092040602:59:59','2092040521:59:59' ],
     ],
   2092 =>
     [
        [ [2092,4,6,3,0,0],[2092,4,5,21,0,0],'-06:00:00',[-6,0,0],
          '-06',0,[2092,9,7,3,59,59],[2092,9,6,21,59,59],
          '2092040603:00:00','2092040521:00:00','2092090703:59:59','2092090621:59:59' ],
        [ [2092,9,7,4,0,0],[2092,9,6,23,0,0],'-05:00:00',[-5,0,0],
          '-05',1,[2093,4,5,2,59,59],[2093,4,4,21,59,59],
          '2092090704:00:00','2092090623:00:00','2093040502:59:59','2093040421:59:59' ],
     ],
);

%LastRule      = (
   'zone'   => {
                'dstoff' => '-05:00:00',
                'stdoff' => '-06:00:00',
               },
   'rules'  => {
                '04' => {
                         'flag'    => 'ge',
                         'dow'     => '7',
                         'num'     => '2',
                         'type'    => 'u',
                         'time'    => '03:00:00',
                         'isdst'   => '0',
                         'abb'     => '-06',
                        },
                '09' => {
                         'flag'    => 'ge',
                         'dow'     => '7',
                         'num'     => '2',
                         'type'    => 'u',
                         'time'    => '04:00:00',
                         'isdst'   => '1',
                         'abb'     => '-05',
                        },
               },
);

1;
