/* rygel-dtcp-cleartext-response.c generated by valac 0.56.1, the Vala compiler
 * generated from rygel-dtcp-cleartext-response.vala, do not modify */

/*
 * Copyright (C) 2013  Cable Television Laboratories, Inc.
 *
 * Author: Craig Pratt <craig@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "rygel-server.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <libsoup/soup.h>

enum  {
	RYGEL_DTCP_CLEARTEXT_RESPONSE_0_PROPERTY,
	RYGEL_DTCP_CLEARTEXT_RESPONSE_START_BYTE_PROPERTY,
	RYGEL_DTCP_CLEARTEXT_RESPONSE_END_BYTE_PROPERTY,
	RYGEL_DTCP_CLEARTEXT_RESPONSE_RANGE_LENGTH_PROPERTY,
	RYGEL_DTCP_CLEARTEXT_RESPONSE_TOTAL_SIZE_PROPERTY,
	RYGEL_DTCP_CLEARTEXT_RESPONSE_ENCRYPTED_LENGTH_PROPERTY,
	RYGEL_DTCP_CLEARTEXT_RESPONSE_NUM_PROPERTIES
};
static GParamSpec* rygel_dtcp_cleartext_response_properties[RYGEL_DTCP_CLEARTEXT_RESPONSE_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))

struct _RygelDTCPCleartextResponsePrivate {
	gint64 _start_byte;
	gint64 _end_byte;
	gint64 _range_length;
	gint64 _total_size;
	gint64 _encrypted_length;
};

static gint RygelDTCPCleartextResponse_private_offset;
static gpointer rygel_dtcp_cleartext_response_parent_class = NULL;

static void rygel_dtcp_cleartext_response_set_start_byte (RygelDTCPCleartextResponse* self,
                                                   gint64 value);
static void rygel_dtcp_cleartext_response_set_end_byte (RygelDTCPCleartextResponse* self,
                                                 gint64 value);
static void rygel_dtcp_cleartext_response_set_range_length (RygelDTCPCleartextResponse* self,
                                                     gint64 value);
static void rygel_dtcp_cleartext_response_set_total_size (RygelDTCPCleartextResponse* self,
                                                   gint64 value);
static void rygel_dtcp_cleartext_response_real_add_response_headers (RygelHTTPResponseElement* base,
                                                              RygelHTTPRequest* request);
static gchar* rygel_dtcp_cleartext_response_real_to_string (RygelHTTPResponseElement* base);
static void rygel_dtcp_cleartext_response_finalize (GObject * obj);
static GType rygel_dtcp_cleartext_response_get_type_once (void);
static void _vala_rygel_dtcp_cleartext_response_get_property (GObject * object,
                                                       guint property_id,
                                                       GValue * value,
                                                       GParamSpec * pspec);
static void _vala_rygel_dtcp_cleartext_response_set_property (GObject * object,
                                                       guint property_id,
                                                       const GValue * value,
                                                       GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
rygel_dtcp_cleartext_response_get_instance_private (RygelDTCPCleartextResponse* self)
{
	return G_STRUCT_MEMBER_P (self, RygelDTCPCleartextResponse_private_offset);
}

RygelDTCPCleartextResponse*
rygel_dtcp_cleartext_response_construct (GType object_type,
                                         gint64 start_byte,
                                         gint64 end_byte,
                                         gint64 total_size,
                                         gint64 encrypted_length)
{
	RygelDTCPCleartextResponse * self = NULL;
	self = (RygelDTCPCleartextResponse*) rygel_http_response_element_construct (object_type);
	rygel_dtcp_cleartext_response_set_start_byte (self, start_byte);
	rygel_dtcp_cleartext_response_set_end_byte (self, end_byte);
	rygel_dtcp_cleartext_response_set_range_length (self, (end_byte - start_byte) + 1);
	rygel_dtcp_cleartext_response_set_total_size (self, total_size);
	rygel_dtcp_cleartext_response_set_encrypted_length (self, encrypted_length);
	return self;
}

RygelDTCPCleartextResponse*
rygel_dtcp_cleartext_response_new (gint64 start_byte,
                                   gint64 end_byte,
                                   gint64 total_size,
                                   gint64 encrypted_length)
{
	return rygel_dtcp_cleartext_response_construct (RYGEL_TYPE_DTCP_CLEARTEXT_RESPONSE, start_byte, end_byte, total_size, encrypted_length);
}

RygelDTCPCleartextResponse*
rygel_dtcp_cleartext_response_construct_from_request (GType object_type,
                                                      RygelDTCPCleartextRequest* request,
                                                      gint64 encrypted_length)
{
	RygelDTCPCleartextResponse * self = NULL;
	gint64 _tmp0_;
	gint64 _tmp1_;
	gint64 _tmp2_;
	gint64 _tmp3_;
	gint64 _tmp4_;
	gint64 _tmp5_;
	gint64 _tmp6_;
	gint64 _tmp7_;
	g_return_val_if_fail (request != NULL, NULL);
	self = (RygelDTCPCleartextResponse*) rygel_http_response_element_construct (object_type);
	_tmp0_ = rygel_dtcp_cleartext_request_get_start_byte (request);
	_tmp1_ = _tmp0_;
	rygel_dtcp_cleartext_response_set_start_byte (self, _tmp1_);
	_tmp2_ = rygel_dtcp_cleartext_request_get_end_byte (request);
	_tmp3_ = _tmp2_;
	rygel_dtcp_cleartext_response_set_end_byte (self, _tmp3_);
	_tmp4_ = rygel_dtcp_cleartext_request_get_range_length (request);
	_tmp5_ = _tmp4_;
	rygel_dtcp_cleartext_response_set_range_length (self, _tmp5_);
	_tmp6_ = rygel_dtcp_cleartext_request_get_total_size (request);
	_tmp7_ = _tmp6_;
	rygel_dtcp_cleartext_response_set_total_size (self, _tmp7_);
	rygel_dtcp_cleartext_response_set_encrypted_length (self, encrypted_length);
	return self;
}

RygelDTCPCleartextResponse*
rygel_dtcp_cleartext_response_new_from_request (RygelDTCPCleartextRequest* request,
                                                gint64 encrypted_length)
{
	return rygel_dtcp_cleartext_response_construct_from_request (RYGEL_TYPE_DTCP_CLEARTEXT_RESPONSE, request, encrypted_length);
}

static void
rygel_dtcp_cleartext_response_real_add_response_headers (RygelHTTPResponseElement* base,
                                                         RygelHTTPRequest* request)
{
	RygelDTCPCleartextResponse * self;
	gint64 _tmp0_;
	gint64 _tmp25_;
	self = (RygelDTCPCleartextResponse*) base;
	g_return_if_fail (request != NULL);
	_tmp0_ = self->priv->_start_byte;
	if (_tmp0_ != RYGEL_HTTP_RESPONSE_ELEMENT_UNSPECIFIED) {
		gchar* _tmp1_ = NULL;
		gint64 _tmp2_;
		gchar* response = NULL;
		gint64 _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gint64 _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		SoupMessage* _tmp22_;
		SoupMessageHeaders* _tmp23_;
		const gchar* _tmp24_;
		_tmp2_ = self->priv->_total_size;
		if (_tmp2_ == RYGEL_HTTP_RESPONSE_ELEMENT_UNSPECIFIED) {
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("*");
			_g_free0 (_tmp1_);
			_tmp1_ = _tmp3_;
		} else {
			gint64 _tmp4_;
			gchar* _tmp5_;
			_tmp4_ = self->priv->_total_size;
			_tmp5_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp4_);
			_g_free0 (_tmp1_);
			_tmp1_ = _tmp5_;
		}
		_tmp6_ = self->priv->_start_byte;
		_tmp7_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_strconcat ("bytes ", _tmp8_, NULL);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strconcat (_tmp10_, "-", NULL);
		_tmp12_ = _tmp11_;
		_tmp13_ = self->priv->_end_byte;
		_tmp14_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = g_strconcat (_tmp12_, _tmp15_, NULL);
		_tmp17_ = _tmp16_;
		_tmp18_ = g_strconcat (_tmp17_, "/", NULL);
		_tmp19_ = _tmp18_;
		_tmp20_ = g_strconcat (_tmp19_, _tmp1_, NULL);
		_tmp21_ = _tmp20_;
		_g_free0 (_tmp19_);
		_g_free0 (_tmp17_);
		_g_free0 (_tmp15_);
		_g_free0 (_tmp12_);
		_g_free0 (_tmp10_);
		_g_free0 (_tmp8_);
		response = _tmp21_;
		_tmp22_ = request->msg;
		_tmp23_ = _tmp22_->response_headers;
		_tmp24_ = response;
		soup_message_headers_append (_tmp23_, RYGEL_DTCP_CLEARTEXT_RESPONSE_DTCP_CONTENT_RANGE_HEADER, _tmp24_);
		_g_free0 (response);
		_g_free0 (_tmp1_);
	}
	_tmp25_ = self->priv->_encrypted_length;
	if (_tmp25_ != RYGEL_HTTP_RESPONSE_ELEMENT_UNSPECIFIED) {
		SoupMessage* _tmp26_;
		SoupMessageHeaders* _tmp27_;
		gint64 _tmp28_;
		_tmp26_ = request->msg;
		_tmp27_ = _tmp26_->response_headers;
		_tmp28_ = self->priv->_encrypted_length;
		soup_message_headers_set_content_length (_tmp27_, _tmp28_);
	}
}

static gchar*
rygel_dtcp_cleartext_response_real_to_string (RygelHTTPResponseElement* base)
{
	RygelDTCPCleartextResponse * self;
	gint64 _tmp0_;
	gint64 _tmp1_;
	gint64 _tmp2_;
	gint64 _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	self = (RygelDTCPCleartextResponse*) base;
	_tmp0_ = self->priv->_start_byte;
	_tmp1_ = self->priv->_end_byte;
	_tmp2_ = self->priv->_total_size;
	_tmp3_ = self->priv->_encrypted_length;
	_tmp4_ = g_strdup_printf ("DTCPCleartextResponse(bytes=%lld-%lld/%lld, enc_len=%lld)", _tmp0_, _tmp1_, _tmp2_, _tmp3_);
	result = _tmp4_;
	return result;
}

gint64
rygel_dtcp_cleartext_response_get_start_byte (RygelDTCPCleartextResponse* self)
{
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_start_byte;
	return result;
}

static void
rygel_dtcp_cleartext_response_set_start_byte (RygelDTCPCleartextResponse* self,
                                              gint64 value)
{
	gint64 old_value;
	g_return_if_fail (self != NULL);
	old_value = rygel_dtcp_cleartext_response_get_start_byte (self);
	if (old_value != value) {
		self->priv->_start_byte = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_dtcp_cleartext_response_properties[RYGEL_DTCP_CLEARTEXT_RESPONSE_START_BYTE_PROPERTY]);
	}
}

gint64
rygel_dtcp_cleartext_response_get_end_byte (RygelDTCPCleartextResponse* self)
{
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_end_byte;
	return result;
}

static void
rygel_dtcp_cleartext_response_set_end_byte (RygelDTCPCleartextResponse* self,
                                            gint64 value)
{
	gint64 old_value;
	g_return_if_fail (self != NULL);
	old_value = rygel_dtcp_cleartext_response_get_end_byte (self);
	if (old_value != value) {
		self->priv->_end_byte = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_dtcp_cleartext_response_properties[RYGEL_DTCP_CLEARTEXT_RESPONSE_END_BYTE_PROPERTY]);
	}
}

gint64
rygel_dtcp_cleartext_response_get_range_length (RygelDTCPCleartextResponse* self)
{
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_range_length;
	return result;
}

static void
rygel_dtcp_cleartext_response_set_range_length (RygelDTCPCleartextResponse* self,
                                                gint64 value)
{
	gint64 old_value;
	g_return_if_fail (self != NULL);
	old_value = rygel_dtcp_cleartext_response_get_range_length (self);
	if (old_value != value) {
		self->priv->_range_length = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_dtcp_cleartext_response_properties[RYGEL_DTCP_CLEARTEXT_RESPONSE_RANGE_LENGTH_PROPERTY]);
	}
}

gint64
rygel_dtcp_cleartext_response_get_total_size (RygelDTCPCleartextResponse* self)
{
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_total_size;
	return result;
}

static void
rygel_dtcp_cleartext_response_set_total_size (RygelDTCPCleartextResponse* self,
                                              gint64 value)
{
	gint64 old_value;
	g_return_if_fail (self != NULL);
	old_value = rygel_dtcp_cleartext_response_get_total_size (self);
	if (old_value != value) {
		self->priv->_total_size = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_dtcp_cleartext_response_properties[RYGEL_DTCP_CLEARTEXT_RESPONSE_TOTAL_SIZE_PROPERTY]);
	}
}

gint64
rygel_dtcp_cleartext_response_get_encrypted_length (RygelDTCPCleartextResponse* self)
{
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_encrypted_length;
	return result;
}

void
rygel_dtcp_cleartext_response_set_encrypted_length (RygelDTCPCleartextResponse* self,
                                                    gint64 value)
{
	gint64 old_value;
	g_return_if_fail (self != NULL);
	old_value = rygel_dtcp_cleartext_response_get_encrypted_length (self);
	if (old_value != value) {
		self->priv->_encrypted_length = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_dtcp_cleartext_response_properties[RYGEL_DTCP_CLEARTEXT_RESPONSE_ENCRYPTED_LENGTH_PROPERTY]);
	}
}

static void
rygel_dtcp_cleartext_response_class_init (RygelDTCPCleartextResponseClass * klass,
                                          gpointer klass_data)
{
	rygel_dtcp_cleartext_response_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelDTCPCleartextResponse_private_offset);
	((RygelHTTPResponseElementClass *) klass)->add_response_headers = (void (*) (RygelHTTPResponseElement*, RygelHTTPRequest*)) rygel_dtcp_cleartext_response_real_add_response_headers;
	((RygelHTTPResponseElementClass *) klass)->to_string = (gchar* (*) (RygelHTTPResponseElement*)) rygel_dtcp_cleartext_response_real_to_string;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_dtcp_cleartext_response_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_dtcp_cleartext_response_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_dtcp_cleartext_response_finalize;
	/**
	     * The start of the response range in bytes
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_DTCP_CLEARTEXT_RESPONSE_START_BYTE_PROPERTY, rygel_dtcp_cleartext_response_properties[RYGEL_DTCP_CLEARTEXT_RESPONSE_START_BYTE_PROPERTY] = g_param_spec_int64 ("start-byte", "start-byte", "start-byte", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * The end of the range in bytes (inclusive)
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_DTCP_CLEARTEXT_RESPONSE_END_BYTE_PROPERTY, rygel_dtcp_cleartext_response_properties[RYGEL_DTCP_CLEARTEXT_RESPONSE_END_BYTE_PROPERTY] = g_param_spec_int64 ("end-byte", "end-byte", "end-byte", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * The length of the range in bytes
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_DTCP_CLEARTEXT_RESPONSE_RANGE_LENGTH_PROPERTY, rygel_dtcp_cleartext_response_properties[RYGEL_DTCP_CLEARTEXT_RESPONSE_RANGE_LENGTH_PROPERTY] = g_param_spec_int64 ("range-length", "range-length", "range-length", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * The length of the resource in bytes. May be HTTPSeekRequest.UNSPECIFIED
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_DTCP_CLEARTEXT_RESPONSE_TOTAL_SIZE_PROPERTY, rygel_dtcp_cleartext_response_properties[RYGEL_DTCP_CLEARTEXT_RESPONSE_TOTAL_SIZE_PROPERTY] = g_param_spec_int64 ("total-size", "total-size", "total-size", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * The encrypted length of the response
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_DTCP_CLEARTEXT_RESPONSE_ENCRYPTED_LENGTH_PROPERTY, rygel_dtcp_cleartext_response_properties[RYGEL_DTCP_CLEARTEXT_RESPONSE_ENCRYPTED_LENGTH_PROPERTY] = g_param_spec_int64 ("encrypted-length", "encrypted-length", "encrypted-length", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
rygel_dtcp_cleartext_response_instance_init (RygelDTCPCleartextResponse * self,
                                             gpointer klass)
{
	self->priv = rygel_dtcp_cleartext_response_get_instance_private (self);
}

static void
rygel_dtcp_cleartext_response_finalize (GObject * obj)
{
	RygelDTCPCleartextResponse * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_DTCP_CLEARTEXT_RESPONSE, RygelDTCPCleartextResponse);
	G_OBJECT_CLASS (rygel_dtcp_cleartext_response_parent_class)->finalize (obj);
}

static GType
rygel_dtcp_cleartext_response_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelDTCPCleartextResponseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_dtcp_cleartext_response_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelDTCPCleartextResponse), 0, (GInstanceInitFunc) rygel_dtcp_cleartext_response_instance_init, NULL };
	GType rygel_dtcp_cleartext_response_type_id;
	rygel_dtcp_cleartext_response_type_id = g_type_register_static (RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, "RygelDTCPCleartextResponse", &g_define_type_info, 0);
	RygelDTCPCleartextResponse_private_offset = g_type_add_instance_private (rygel_dtcp_cleartext_response_type_id, sizeof (RygelDTCPCleartextResponsePrivate));
	return rygel_dtcp_cleartext_response_type_id;
}

GType
rygel_dtcp_cleartext_response_get_type (void)
{
	static volatile gsize rygel_dtcp_cleartext_response_type_id__once = 0;
	if (g_once_init_enter (&rygel_dtcp_cleartext_response_type_id__once)) {
		GType rygel_dtcp_cleartext_response_type_id;
		rygel_dtcp_cleartext_response_type_id = rygel_dtcp_cleartext_response_get_type_once ();
		g_once_init_leave (&rygel_dtcp_cleartext_response_type_id__once, rygel_dtcp_cleartext_response_type_id);
	}
	return rygel_dtcp_cleartext_response_type_id__once;
}

static void
_vala_rygel_dtcp_cleartext_response_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec)
{
	RygelDTCPCleartextResponse * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_DTCP_CLEARTEXT_RESPONSE, RygelDTCPCleartextResponse);
	switch (property_id) {
		case RYGEL_DTCP_CLEARTEXT_RESPONSE_START_BYTE_PROPERTY:
		g_value_set_int64 (value, rygel_dtcp_cleartext_response_get_start_byte (self));
		break;
		case RYGEL_DTCP_CLEARTEXT_RESPONSE_END_BYTE_PROPERTY:
		g_value_set_int64 (value, rygel_dtcp_cleartext_response_get_end_byte (self));
		break;
		case RYGEL_DTCP_CLEARTEXT_RESPONSE_RANGE_LENGTH_PROPERTY:
		g_value_set_int64 (value, rygel_dtcp_cleartext_response_get_range_length (self));
		break;
		case RYGEL_DTCP_CLEARTEXT_RESPONSE_TOTAL_SIZE_PROPERTY:
		g_value_set_int64 (value, rygel_dtcp_cleartext_response_get_total_size (self));
		break;
		case RYGEL_DTCP_CLEARTEXT_RESPONSE_ENCRYPTED_LENGTH_PROPERTY:
		g_value_set_int64 (value, rygel_dtcp_cleartext_response_get_encrypted_length (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_rygel_dtcp_cleartext_response_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec)
{
	RygelDTCPCleartextResponse * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_DTCP_CLEARTEXT_RESPONSE, RygelDTCPCleartextResponse);
	switch (property_id) {
		case RYGEL_DTCP_CLEARTEXT_RESPONSE_START_BYTE_PROPERTY:
		rygel_dtcp_cleartext_response_set_start_byte (self, g_value_get_int64 (value));
		break;
		case RYGEL_DTCP_CLEARTEXT_RESPONSE_END_BYTE_PROPERTY:
		rygel_dtcp_cleartext_response_set_end_byte (self, g_value_get_int64 (value));
		break;
		case RYGEL_DTCP_CLEARTEXT_RESPONSE_RANGE_LENGTH_PROPERTY:
		rygel_dtcp_cleartext_response_set_range_length (self, g_value_get_int64 (value));
		break;
		case RYGEL_DTCP_CLEARTEXT_RESPONSE_TOTAL_SIZE_PROPERTY:
		rygel_dtcp_cleartext_response_set_total_size (self, g_value_get_int64 (value));
		break;
		case RYGEL_DTCP_CLEARTEXT_RESPONSE_ENCRYPTED_LENGTH_PROPERTY:
		rygel_dtcp_cleartext_response_set_encrypted_length (self, g_value_get_int64 (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

