/* IconPopover.c generated by valac 0.56.2, the Vala compiler
 * generated from IconPopover.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright © 2018-2022 Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include "icontasklistapplet.h"
#include <gio/gio.h>
#include <glib.h>
#include <string.h>
#include <stdlib.h>
#include <gtk/gtk.h>
#include <gio/gdesktopappinfo.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <libwnck/libwnck.h>
#include <pango/pango.h>

typedef GDBusProxy BudgieSettingsRemoteProxy;
typedef GDBusProxyClass BudgieSettingsRemoteProxyClass;
typedef struct _budgie_settings_remote_CloseReadyData budgie_settings_remote_CloseReadyData;
enum  {
	BUDGIE_ICON_POPOVER_0_PROPERTY,
	BUDGIE_ICON_POPOVER_NUM_PROPERTIES
};
static GParamSpec* budgie_icon_popover_properties[BUDGIE_ICON_POPOVER_NUM_PROPERTIES];
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block8Data Block8Data;
typedef struct _Block9Data Block9Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block10Data Block10Data;
enum  {
	BUDGIE_ICON_POPOVER_ADDED_WINDOW_SIGNAL,
	BUDGIE_ICON_POPOVER_CLOSED_ALL_SIGNAL,
	BUDGIE_ICON_POPOVER_CLOSED_WINDOW_SIGNAL,
	BUDGIE_ICON_POPOVER_CHANGED_PIN_STATE_SIGNAL,
	BUDGIE_ICON_POPOVER_LAUNCH_NEW_INSTANCE_SIGNAL,
	BUDGIE_ICON_POPOVER_MOVE_WINDOW_TO_WORKSPACE_SIGNAL,
	BUDGIE_ICON_POPOVER_PERFORM_ACTION_SIGNAL,
	BUDGIE_ICON_POPOVER_NUM_SIGNALS
};
static guint budgie_icon_popover_signals[BUDGIE_ICON_POPOVER_NUM_SIGNALS] = {0};
enum  {
	BUDGIE_ICON_POPOVER_ITEM_0_PROPERTY,
	BUDGIE_ICON_POPOVER_ITEM_NUM_PROPERTIES
};
static GParamSpec* budgie_icon_popover_item_properties[BUDGIE_ICON_POPOVER_ITEM_NUM_PROPERTIES];

struct _budgie_settings_remote_CloseReadyData {
	GDBusMethodInvocation* _invocation_;
};

struct _BudgieIconPopoverPrivate {
	gboolean is_budgie_desktop_settings;
	gulong current_window_id;
	gint longest_label_length;
	GHashTable* window_id_to_controls;
	GList* workspace_items;
	gchar** actions;
	gint actions_length1;
	gint _actions_size_;
	gchar* preferred_action;
	gboolean pinned;
	gint workspace_count;
	gint workspaces_added_to_list;
	GtkImage* non_starred_image;
	GtkImage* starred_image;
	BudgieSettingsRemote* settings_remote;
};

struct _Block8Data {
	int _ref_count_;
	BudgieIconPopover* self;
	BudgieIconPopoverItem* action_item;
};

struct _Block9Data {
	int _ref_count_;
	BudgieIconPopover* self;
	BudgieIconPopoverItem* item;
};

struct _Block10Data {
	int _ref_count_;
	BudgieIconPopover* self;
	BudgieIconPopoverItem* item;
};

static GType budgie_settings_remote_type_id = 0;
static gint BudgieIconPopover_private_offset;
static gpointer budgie_icon_popover_parent_class = NULL;
static GType budgie_icon_popover_type_id = 0;
static gpointer budgie_icon_popover_item_parent_class = NULL;
static GType budgie_icon_popover_item_type_id = 0;

static void budgie_settings_remote_proxy_g_signal (GDBusProxy* proxy,
                                            const gchar* sender_name,
                                            const gchar* signal_name,
                                            GVariant* parameters);
static void _vala_g_async_ready_callback (GObject *source_object,
                                   GAsyncResult *res,
                                   void *user_data);
static void budgie_settings_remote_proxy_Close_async (BudgieSettingsRemote* self,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_);
static void budgie_settings_remote_proxy_Close_finish (BudgieSettingsRemote* self,
                                                GAsyncResult* _res_,
                                                GError** error);
static void budgie_settings_remote_proxy_budgie_settings_remote_interface_init (BudgieSettingsRemoteIface* iface);
static void _dbus_budgie_settings_remote_Close (BudgieSettingsRemote* self,
                                         GVariant* _parameters_,
                                         GDBusMethodInvocation* invocation);
static void _dbus_budgie_settings_remote_Close_ready (GObject * source_object,
                                               GAsyncResult * _res_,
                                               gpointer _user_data_);
static void budgie_settings_remote_dbus_interface_method_call (GDBusConnection* connection,
                                                        const gchar* sender,
                                                        const gchar* object_path,
                                                        const gchar* interface_name,
                                                        const gchar* method_name,
                                                        GVariant* parameters,
                                                        GDBusMethodInvocation* invocation,
                                                        gpointer user_data);
static GVariant* budgie_settings_remote_dbus_interface_get_property (GDBusConnection* connection,
                                                              const gchar* sender,
                                                              const gchar* object_path,
                                                              const gchar* interface_name,
                                                              const gchar* property_name,
                                                              GError** error,
                                                              gpointer user_data);
static gboolean budgie_settings_remote_dbus_interface_set_property (GDBusConnection* connection,
                                                             const gchar* sender,
                                                             const gchar* object_path,
                                                             const gchar* interface_name,
                                                             const gchar* property_name,
                                                             GVariant* value,
                                                             GError** error,
                                                             gpointer user_data);
static void _budgie_settings_remote_unregister_object (gpointer user_data);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void _g_free0_ (gpointer var);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
static void ______lambda10_ (Block8Data* _data8_);
static void _______lambda10__gtk_button_clicked (GtkButton* _sender,
                                          gpointer self);
static void __lambda11_ (BudgieIconPopover* self);
static void ___lambda11__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void __lambda12_ (BudgieIconPopover* self);
static void ___lambda12__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void _budgie_icon_popover_close_all_windows_gtk_button_clicked (GtkButton* _sender,
                                                                gpointer self);
static void _budgie_icon_popover_toggle_always_on_top_state_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                                gpointer self);
static void _budgie_icon_popover_toggle_maximized_state_gtk_button_clicked (GtkButton* _sender,
                                                                     gpointer self);
static void _budgie_icon_popover_minimize_window_gtk_button_clicked (GtkButton* _sender,
                                                              gpointer self);
static void _budgie_icon_popover_render_gtk_button_clicked (GtkButton* _sender,
                                                     gpointer self);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (void * _userdata_);
static void ___lambda16_ (Block9Data* _data9_);
static void ____lambda16__gtk_button_clicked (GtkButton* _sender,
                                       gpointer self);
static void ___lambda17_ (Block9Data* _data9_);
static void ____lambda17__gtk_button_clicked (GtkButton* _sender,
                                       gpointer self);
static void ___lambda18_ (Block9Data* _data9_);
static void ____lambda18__gtk_button_clicked (GtkButton* _sender,
                                       gpointer self);
static gulong* _ulong_dup (gulong* self);
static void _budgie_icon_popover_on_settings_get_gasync_ready_callback (GObject* source_object,
                                                                 GAsyncResult* res,
                                                                 gpointer self);
static void ___lambda13_ (BudgieIconPopover* self,
                   gulong* xid,
                   const gchar* name);
static void ____lambda13__gh_func (gconstpointer key,
                            gconstpointer value,
                            gpointer self);
static void _budgie_icon_popover_on_settings_closed_gasync_ready_callback (GObject* source_object,
                                                                    GAsyncResult* res,
                                                                    gpointer self);
static gboolean __lambda15_ (BudgieIconPopover* self);
static gboolean ___lambda15__gsource_func (gpointer self);
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (void * _userdata_);
static void _______lambda9_ (Block10Data* _data10_);
static void ________lambda9__gtk_button_clicked (GtkButton* _sender,
                                          gpointer self);
static gboolean ___lambda14_ (BudgieIconPopover* self);
static gboolean ____lambda14__gsource_func (gpointer self);
static void g_cclosure_user_marshal_VOID__ULONG_INT (GClosure * closure,
                                              GValue * return_value,
                                              guint n_param_values,
                                              const GValue * param_values,
                                              gpointer invocation_hint,
                                              gpointer marshal_data);
static void budgie_icon_popover_finalize (GObject * obj);
static void budgie_icon_popover_item_finalize (GObject * obj);
static gssize _vala_array_length (gpointer array);

static const GDBusArgInfo * const _budgie_settings_remote_dbus_arg_info_Close_in[] = {NULL};
static const GDBusArgInfo * const _budgie_settings_remote_dbus_arg_info_Close_out[] = {NULL};
static const GDBusMethodInfo _budgie_settings_remote_dbus_method_info_Close = {-1, "Close", (GDBusArgInfo **) (&_budgie_settings_remote_dbus_arg_info_Close_in), (GDBusArgInfo **) (&_budgie_settings_remote_dbus_arg_info_Close_out), NULL};
static const GDBusMethodInfo * const _budgie_settings_remote_dbus_method_info[] = {&_budgie_settings_remote_dbus_method_info_Close, NULL};
static const GDBusSignalInfo * const _budgie_settings_remote_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _budgie_settings_remote_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _budgie_settings_remote_dbus_interface_info = {-1, "org.budgie_desktop.Settings", (GDBusMethodInfo **) (&_budgie_settings_remote_dbus_method_info), (GDBusSignalInfo **) (&_budgie_settings_remote_dbus_signal_info), (GDBusPropertyInfo **) (&_budgie_settings_remote_dbus_property_info), NULL};
static const GDBusInterfaceVTable _budgie_settings_remote_dbus_interface_vtable = {budgie_settings_remote_dbus_interface_method_call, budgie_settings_remote_dbus_interface_get_property, budgie_settings_remote_dbus_interface_set_property};

void
budgie_settings_remote_Close (BudgieSettingsRemote* self,
                              GAsyncReadyCallback _callback_,
                              gpointer _user_data_)
{
	BudgieSettingsRemoteIface* _iface_;
	_iface_ = BUDGIE_SETTINGS_REMOTE_GET_INTERFACE (self);
	if (_iface_->Close) {
		_iface_->Close (self, _callback_, _user_data_);
	}
}

void
budgie_settings_remote_Close_finish (BudgieSettingsRemote* self,
                                     GAsyncResult* _res_,
                                     GError** error)
{
	BudgieSettingsRemoteIface* _iface_;
	_iface_ = BUDGIE_SETTINGS_REMOTE_GET_INTERFACE (self);
	if (_iface_->Close_finish) {
		_iface_->Close_finish (self, _res_, error);
	}
}

static void
budgie_settings_remote_default_init (BudgieSettingsRemoteIface * iface,
                                     gpointer iface_data)
{
}

GType
budgie_settings_remote_get_type (void)
{
	return budgie_settings_remote_type_id;
}

GType
budgie_settings_remote_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieSettingsRemoteIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_settings_remote_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	budgie_settings_remote_type_id = g_type_module_register_type (module, G_TYPE_INTERFACE, "BudgieSettingsRemote", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (budgie_settings_remote_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (budgie_settings_remote_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) budgie_settings_remote_proxy_get_type);
	g_type_set_qdata (budgie_settings_remote_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.budgie_desktop.Settings");
	g_type_set_qdata (budgie_settings_remote_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_budgie_settings_remote_dbus_interface_info));
	g_type_set_qdata (budgie_settings_remote_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) budgie_settings_remote_register_object);
	return budgie_settings_remote_type_id;
}

G_DEFINE_DYNAMIC_TYPE_EXTENDED (BudgieSettingsRemoteProxy, budgie_settings_remote_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE_DYNAMIC (BUDGIE_TYPE_SETTINGS_REMOTE, budgie_settings_remote_proxy_budgie_settings_remote_interface_init) )
static void
budgie_settings_remote_proxy_class_init (BudgieSettingsRemoteProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = budgie_settings_remote_proxy_g_signal;
}

static void
budgie_settings_remote_proxy_g_signal (GDBusProxy* proxy,
                                       const gchar* sender_name,
                                       const gchar* signal_name,
                                       GVariant* parameters)
{
}

static void
budgie_settings_remote_proxy_class_finalize (BudgieSettingsRemoteProxyClass* klass)
{
}

void
budgie_settings_remote_proxy_register_dynamic_type (GTypeModule* module)
{
	budgie_settings_remote_proxy_register_type (module);
}

static void
budgie_settings_remote_proxy_init (BudgieSettingsRemoteProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_budgie_settings_remote_dbus_interface_info));
}

static void
_vala_g_async_ready_callback (GObject *source_object,
                              GAsyncResult *res,
                              void *user_data)
{
	g_task_return_pointer (user_data, g_object_ref (res), g_object_unref);
	g_object_unref (user_data);
}

static void
budgie_settings_remote_proxy_Close_async (BudgieSettingsRemote* self,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.budgie_desktop.Settings", "Close");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	if (_callback_ != NULL) {
		g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_task_new ((GObject *) self, NULL, _callback_, _user_data_));
	} else {
		g_dbus_message_set_flags (_message, G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED);
		g_dbus_connection_send_message (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	}
	g_object_unref (_message);
}

static void
budgie_settings_remote_proxy_Close_finish (BudgieSettingsRemote* self,
                                           GAsyncResult* _res_,
                                           GError** error)
{
	GAsyncResult *_inner_res;
	GDBusMessage *_reply_message;
	_inner_res = g_task_propagate_pointer ((GTask *) _res_, NULL);
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), _inner_res, error);
	g_object_unref (_inner_res);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
budgie_settings_remote_proxy_budgie_settings_remote_interface_init (BudgieSettingsRemoteIface* iface)
{
	iface->Close = budgie_settings_remote_proxy_Close_async;
	iface->Close_finish = budgie_settings_remote_proxy_Close_finish;
}

static void
_dbus_budgie_settings_remote_Close (BudgieSettingsRemote* self,
                                    GVariant* _parameters_,
                                    GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	budgie_settings_remote_CloseReadyData* _ready_data;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (budgie_settings_remote_CloseReadyData);
	_ready_data->_invocation_ = invocation;
	budgie_settings_remote_Close (self, (GAsyncReadyCallback) _dbus_budgie_settings_remote_Close_ready, _ready_data);
}

static void
_dbus_budgie_settings_remote_Close_ready (GObject * source_object,
                                          GAsyncResult * _res_,
                                          gpointer _user_data_)
{
	budgie_settings_remote_CloseReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	budgie_settings_remote_Close_finish ((BudgieSettingsRemote*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	g_slice_free (budgie_settings_remote_CloseReadyData, _ready_data);
}

static void
budgie_settings_remote_dbus_interface_method_call (GDBusConnection* connection,
                                                   const gchar* sender,
                                                   const gchar* object_path,
                                                   const gchar* interface_name,
                                                   const gchar* method_name,
                                                   GVariant* parameters,
                                                   GDBusMethodInvocation* invocation,
                                                   gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "Close") == 0) {
		_dbus_budgie_settings_remote_Close (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
budgie_settings_remote_dbus_interface_get_property (GDBusConnection* connection,
                                                    const gchar* sender,
                                                    const gchar* object_path,
                                                    const gchar* interface_name,
                                                    const gchar* property_name,
                                                    GError** error,
                                                    gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
budgie_settings_remote_dbus_interface_set_property (GDBusConnection* connection,
                                                    const gchar* sender,
                                                    const gchar* object_path,
                                                    const gchar* interface_name,
                                                    const gchar* property_name,
                                                    GVariant* value,
                                                    GError** error,
                                                    gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
budgie_settings_remote_register_object (gpointer object,
                                        GDBusConnection* connection,
                                        const gchar* path,
                                        GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_budgie_settings_remote_dbus_interface_info), &_budgie_settings_remote_dbus_interface_vtable, data, _budgie_settings_remote_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_budgie_settings_remote_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static inline gpointer
budgie_icon_popover_get_instance_private (BudgieIconPopover* self)
{
	return G_STRUCT_MEMBER_P (self, BudgieIconPopover_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
_g_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_free (var), NULL));
}

static Block8Data*
block8_data_ref (Block8Data* _data8_)
{
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}

static void
block8_data_unref (void * _userdata_)
{
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		BudgieIconPopover* self;
		self = _data8_->self;
		_g_object_unref0 (_data8_->action_item);
		_g_object_unref0 (self);
		g_slice_free (Block8Data, _data8_);
	}
}

static void
______lambda10_ (Block8Data* _data8_)
{
	BudgieIconPopover* self;
	gchar* assigned_action = NULL;
	BudgieIconPopoverItem* _tmp0_;
	GtkButton* _tmp1_;
	gconstpointer _tmp2_;
	gchar* _tmp3_;
	self = _data8_->self;
	_tmp0_ = _data8_->action_item;
	_tmp1_ = _tmp0_->actionable_label;
	_tmp2_ = g_object_get_data ((GObject*) _tmp1_, "action");
	_tmp3_ = g_strdup ((const gchar*) _tmp2_);
	assigned_action = _tmp3_;
	g_signal_emit (self, budgie_icon_popover_signals[BUDGIE_ICON_POPOVER_PERFORM_ACTION_SIGNAL], 0, assigned_action);
	_g_free0 (assigned_action);
}

static void
_______lambda10__gtk_button_clicked (GtkButton* _sender,
                                     gpointer self)
{
	______lambda10_ (self);
}

static void
__lambda11_ (BudgieIconPopover* self)
{
	budgie_icon_popover_set_pinned_state (self, !self->priv->pinned);
	g_signal_emit (self, budgie_icon_popover_signals[BUDGIE_ICON_POPOVER_CHANGED_PIN_STATE_SIGNAL], 0, self->priv->pinned);
}

static void
___lambda11__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda11_ ((BudgieIconPopover*) self);
}

static void
__lambda12_ (BudgieIconPopover* self)
{
	const gchar* _tmp0_;
	_tmp0_ = self->priv->preferred_action;
	if (g_strcmp0 (_tmp0_, "") != 0) {
		const gchar* _tmp1_;
		_tmp1_ = self->priv->preferred_action;
		g_signal_emit (self, budgie_icon_popover_signals[BUDGIE_ICON_POPOVER_PERFORM_ACTION_SIGNAL], 0, _tmp1_);
	} else {
		g_signal_emit (self, budgie_icon_popover_signals[BUDGIE_ICON_POPOVER_LAUNCH_NEW_INSTANCE_SIGNAL], 0);
	}
}

static void
___lambda12__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda12_ ((BudgieIconPopover*) self);
}

static void
_budgie_icon_popover_close_all_windows_gtk_button_clicked (GtkButton* _sender,
                                                           gpointer self)
{
	budgie_icon_popover_close_all_windows ((BudgieIconPopover*) self);
}

static void
_budgie_icon_popover_toggle_always_on_top_state_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                           gpointer self)
{
	budgie_icon_popover_toggle_always_on_top_state ((BudgieIconPopover*) self);
}

static void
_budgie_icon_popover_toggle_maximized_state_gtk_button_clicked (GtkButton* _sender,
                                                                gpointer self)
{
	budgie_icon_popover_toggle_maximized_state ((BudgieIconPopover*) self);
}

static void
_budgie_icon_popover_minimize_window_gtk_button_clicked (GtkButton* _sender,
                                                         gpointer self)
{
	budgie_icon_popover_minimize_window ((BudgieIconPopover*) self);
}

static void
_budgie_icon_popover_render_gtk_button_clicked (GtkButton* _sender,
                                                gpointer self)
{
	budgie_icon_popover_render ((BudgieIconPopover*) self);
}

BudgieIconPopover*
budgie_icon_popover_construct (GType object_type,
                               GtkWidget* relative_parent,
                               GDesktopAppInfo* app_info,
                               gint current_workspace_count)
{
	BudgieIconPopover * self = NULL;
	GtkStyleContext* _tmp0_;
	GHashFunc _tmp1_;
	GEqualFunc _tmp2_;
	GHashTable* _tmp3_;
	GHashFunc _tmp4_;
	GEqualFunc _tmp5_;
	GHashTable* _tmp6_;
	GtkStack* _tmp7_;
	GtkStack* _tmp8_;
	GtkStyleContext* _tmp9_;
	GtkBox* _tmp10_;
	GtkBox* _tmp11_;
	GtkBox* _tmp12_;
	GtkBox* _tmp13_;
	GtkSeparator* _tmp14_;
	GtkSeparator* _tmp15_;
	GtkGrid* _tmp16_;
	GtkGrid* _tmp17_;
	GtkButton* _tmp18_;
	GtkButton* _tmp19_;
	GtkImage* _tmp20_;
	GtkButton* _tmp21_;
	GtkButton* _tmp22_;
	GtkButton* _tmp23_;
	GtkButton* _tmp24_;
	GtkButton* _tmp25_;
	GtkBox* _tmp26_;
	GtkBox* _tmp27_;
	GtkBox* _tmp28_;
	GtkSeparator* _tmp29_;
	GtkBox* _tmp30_;
	GtkBox* _tmp31_;
	GtkBox* _tmp32_;
	GtkGrid* _tmp33_;
	GtkCheckButton* _tmp34_;
	GtkCheckButton* _tmp35_;
	BudgieIconPopoverItem* _tmp36_;
	BudgieIconPopoverItem* _tmp37_;
	GtkButton* _tmp38_;
	GtkButton* _tmp39_;
	GtkGrid* _tmp40_;
	GtkGrid* _tmp41_;
	GtkButton* _tmp42_;
	GtkBox* _tmp43_;
	GtkCheckButton* _tmp44_;
	GtkBox* _tmp45_;
	BudgieIconPopoverItem* _tmp46_;
	GtkBox* _tmp47_;
	BudgieIconPopoverItem* _tmp48_;
	GtkBox* _tmp49_;
	GtkGrid* _tmp50_;
	GtkButton* _tmp90_;
	GtkButton* _tmp91_;
	GtkButton* _tmp92_;
	GtkCheckButton* _tmp93_;
	BudgieIconPopoverItem* _tmp94_;
	GtkButton* _tmp95_;
	BudgieIconPopoverItem* _tmp96_;
	GtkButton* _tmp97_;
	GtkButton* _tmp98_;
	GtkStack* _tmp99_;
	GtkBox* _tmp100_;
	GtkStack* _tmp101_;
	GtkBox* _tmp102_;
	GtkStack* _tmp103_;
	g_return_val_if_fail (relative_parent != NULL, NULL);
	self = (BudgieIconPopover*) g_object_new (object_type, "relative-to", relative_parent, NULL);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp0_, "icon-popover");
	self->priv->workspace_count = current_workspace_count;
	g_object_set ((GtkWidget*) self, "width-request", 200, NULL);
	_tmp1_ = g_int_hash;
	_tmp2_ = g_int_equal;
	_tmp3_ = g_hash_table_new_full (_tmp1_, _tmp2_, _g_free0_, _g_free0_);
	_g_hash_table_unref0 (self->window_id_to_name);
	self->window_id_to_name = _tmp3_;
	_tmp4_ = g_int_hash;
	_tmp5_ = g_int_equal;
	_tmp6_ = g_hash_table_new_full (_tmp4_, _tmp5_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->window_id_to_controls);
	self->priv->window_id_to_controls = _tmp6_;
	(self->priv->workspace_items == NULL) ? NULL : (self->priv->workspace_items = (_g_list_free__g_object_unref0_ (self->priv->workspace_items), NULL));
	self->priv->workspace_items = NULL;
	budgie_icon_popover_create_images (self);
	_tmp7_ = (GtkStack*) gtk_stack_new ();
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->stack);
	self->stack = _tmp7_;
	_tmp8_ = self->stack;
	_tmp9_ = gtk_widget_get_style_context ((GtkWidget*) _tmp8_);
	gtk_style_context_add_class (_tmp9_, "icon-popover-stack");
	_tmp10_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp10_);
	_g_object_unref0 (self->primary_view);
	self->primary_view = _tmp10_;
	_tmp11_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp11_);
	_g_object_unref0 (self->actions_view);
	self->actions_view = _tmp11_;
	_tmp12_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp12_);
	_g_object_unref0 (self->actions_list);
	self->actions_list = _tmp12_;
	_tmp13_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp13_);
	_g_object_unref0 (self->windows_list);
	self->windows_list = _tmp13_;
	_tmp14_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
	g_object_ref_sink (_tmp14_);
	_g_object_unref0 (self->windows_sep);
	self->windows_sep = _tmp14_;
	_tmp15_ = self->windows_sep;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp15_, TRUE);
	_tmp16_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp16_);
	_g_object_unref0 (self->quick_actions);
	self->quick_actions = _tmp16_;
	_tmp17_ = self->quick_actions;
	gtk_grid_set_column_homogeneous (_tmp17_, TRUE);
	_tmp18_ = (GtkButton*) gtk_button_new ();
	g_object_ref_sink (_tmp18_);
	_g_object_unref0 (self->pin_button);
	self->pin_button = _tmp18_;
	_tmp19_ = self->pin_button;
	_tmp20_ = self->priv->non_starred_image;
	gtk_button_set_image (_tmp19_, (GtkWidget*) _tmp20_);
	_tmp21_ = (GtkButton*) gtk_button_new_from_icon_name ("list-add-symbolic", (GtkIconSize) GTK_ICON_SIZE_SMALL_TOOLBAR);
	g_object_ref_sink (_tmp21_);
	_g_object_unref0 (self->launch_new_instance_button);
	self->launch_new_instance_button = _tmp21_;
	_tmp22_ = self->launch_new_instance_button;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp22_, _ ("Launch New Instance"));
	_tmp23_ = (GtkButton*) gtk_button_new_from_icon_name ("list-remove-all-symbolic", (GtkIconSize) GTK_ICON_SIZE_SMALL_TOOLBAR);
	g_object_ref_sink (_tmp23_);
	_g_object_unref0 (self->close_all_button);
	self->close_all_button = _tmp23_;
	_tmp24_ = self->close_all_button;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp24_, _ ("Close All Windows"));
	_tmp25_ = self->close_all_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp25_, FALSE);
	_tmp26_ = self->primary_view;
	_tmp27_ = self->actions_list;
	gtk_box_pack_start (_tmp26_, (GtkWidget*) _tmp27_, TRUE, TRUE, (guint) 0);
	_tmp28_ = self->primary_view;
	_tmp29_ = self->windows_sep;
	gtk_box_pack_start (_tmp28_, (GtkWidget*) _tmp29_, TRUE, TRUE, (guint) 0);
	_tmp30_ = self->primary_view;
	_tmp31_ = self->windows_list;
	gtk_box_pack_start (_tmp30_, (GtkWidget*) _tmp31_, TRUE, TRUE, (guint) 0);
	_tmp32_ = self->primary_view;
	_tmp33_ = self->quick_actions;
	gtk_box_pack_end (_tmp32_, (GtkWidget*) _tmp33_, TRUE, TRUE, (guint) 0);
	_tmp34_ = (GtkCheckButton*) gtk_check_button_new_with_label (_ ("Always On Top"));
	g_object_ref_sink (_tmp34_);
	_g_object_unref0 (self->always_on_top_button);
	self->always_on_top_button = _tmp34_;
	_tmp35_ = self->always_on_top_button;
	g_object_set ((GtkWidget*) _tmp35_, "height-request", 32, NULL);
	_tmp36_ = budgie_icon_popover_item_new (_ ("Maximize"), 20);
	g_object_ref_sink (_tmp36_);
	_g_object_unref0 (self->maximize_button);
	self->maximize_button = _tmp36_;
	_tmp37_ = budgie_icon_popover_item_new (_ ("Minimize"), 20);
	g_object_ref_sink (_tmp37_);
	_g_object_unref0 (self->minimize_button);
	self->minimize_button = _tmp37_;
	_tmp38_ = (GtkButton*) gtk_button_new_from_icon_name ("go-previous-symbolic", (GtkIconSize) GTK_ICON_SIZE_SMALL_TOOLBAR);
	g_object_ref_sink (_tmp38_);
	_g_object_unref0 (self->back_button);
	self->back_button = _tmp38_;
	_tmp39_ = self->back_button;
	g_object_set ((GtkWidget*) _tmp39_, "width-request", 100, NULL);
	_tmp40_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp40_);
	_g_object_unref0 (self->actions_view_buttons);
	self->actions_view_buttons = _tmp40_;
	_tmp41_ = self->actions_view_buttons;
	_tmp42_ = self->back_button;
	gtk_grid_attach (_tmp41_, (GtkWidget*) _tmp42_, 0, 0, 1, 1);
	_tmp43_ = self->actions_view;
	_tmp44_ = self->always_on_top_button;
	gtk_box_pack_start (_tmp43_, (GtkWidget*) _tmp44_, FALSE, TRUE, (guint) 0);
	_tmp45_ = self->actions_view;
	_tmp46_ = self->maximize_button;
	gtk_box_pack_start (_tmp45_, (GtkWidget*) _tmp46_, FALSE, TRUE, (guint) 0);
	_tmp47_ = self->actions_view;
	_tmp48_ = self->minimize_button;
	gtk_box_pack_start (_tmp47_, (GtkWidget*) _tmp48_, FALSE, TRUE, (guint) 0);
	_tmp49_ = self->actions_view;
	_tmp50_ = self->actions_view_buttons;
	gtk_box_pack_end (_tmp49_, (GtkWidget*) _tmp50_, FALSE, TRUE, (guint) 0);
	budgie_icon_popover_set_workspace_count (self, self->priv->workspace_count);
	if (app_info != NULL) {
		const gchar* _tmp51_;
		GtkGrid* _tmp52_;
		GtkButton* _tmp53_;
		GtkGrid* _tmp54_;
		GtkButton* _tmp55_;
		GtkGrid* _tmp56_;
		GtkButton* _tmp57_;
		gchar** _tmp58_;
		gchar** _tmp59_;
		gchar** _tmp60_;
		gint _tmp60__length1;
		_tmp51_ = g_desktop_app_info_get_startup_wm_class (app_info);
		self->priv->is_budgie_desktop_settings = g_strcmp0 (_tmp51_, "budgie-desktop-settings") == 0;
		if (self->priv->is_budgie_desktop_settings) {
			budgie_icon_popover_acquire_settings_remote (self);
		}
		_tmp52_ = self->quick_actions;
		_tmp53_ = self->pin_button;
		gtk_grid_attach (_tmp52_, (GtkWidget*) _tmp53_, 0, 0, 1, 1);
		_tmp54_ = self->quick_actions;
		_tmp55_ = self->launch_new_instance_button;
		gtk_grid_attach (_tmp54_, (GtkWidget*) _tmp55_, 1, 0, 1, 1);
		_tmp56_ = self->quick_actions;
		_tmp57_ = self->close_all_button;
		gtk_grid_attach (_tmp56_, (GtkWidget*) _tmp57_, 2, 0, 1, 1);
		_tmp59_ = _tmp58_ = g_desktop_app_info_list_actions (app_info);
		self->priv->actions = _tmp59_;
		self->priv->actions_length1 = _vala_array_length (_tmp58_);
		self->priv->_actions_size_ = self->priv->actions_length1;
		_tmp60_ = self->priv->actions;
		_tmp60__length1 = self->priv->actions_length1;
		if (_tmp60__length1 != 0) {
			gchar** _tmp61_;
			gint _tmp61__length1;
			gchar** _tmp71_;
			gint _tmp71__length1;
			_tmp61_ = self->priv->actions;
			_tmp61__length1 = self->priv->actions_length1;
			{
				gchar** action_collection = NULL;
				gint action_collection_length1 = 0;
				gint _action_collection_size_ = 0;
				gint action_it = 0;
				action_collection = _tmp61_;
				action_collection_length1 = _tmp61__length1;
				for (action_it = 0; action_it < action_collection_length1; action_it = action_it + 1) {
					gchar* _tmp62_;
					gchar* action = NULL;
					_tmp62_ = g_strdup (action_collection[action_it]);
					action = _tmp62_;
					{
						gchar* action_name = NULL;
						const gchar* _tmp63_;
						gchar* _tmp64_;
						const gchar* _tmp65_;
						gint _tmp66_;
						gint _tmp67_;
						_tmp63_ = action;
						_tmp64_ = g_desktop_app_info_get_action_name (app_info, _tmp63_);
						action_name = _tmp64_;
						_tmp65_ = action_name;
						_tmp66_ = strlen (_tmp65_);
						_tmp67_ = _tmp66_;
						if (_tmp67_ > self->priv->longest_label_length) {
							const gchar* _tmp68_;
							gint _tmp69_;
							gint _tmp70_;
							_tmp68_ = action_name;
							_tmp69_ = strlen (_tmp68_);
							_tmp70_ = _tmp69_;
							self->priv->longest_label_length = _tmp70_;
						}
						_g_free0 (action_name);
						_g_free0 (action);
					}
				}
			}
			_tmp71_ = self->priv->actions;
			_tmp71__length1 = self->priv->actions_length1;
			{
				gchar** action_collection = NULL;
				gint action_collection_length1 = 0;
				gint _action_collection_size_ = 0;
				gint action_it = 0;
				action_collection = _tmp71_;
				action_collection_length1 = _tmp71__length1;
				for (action_it = 0; action_it < action_collection_length1; action_it = action_it + 1) {
					gchar* _tmp72_;
					gchar* action = NULL;
					_tmp72_ = g_strdup (action_collection[action_it]);
					action = _tmp72_;
					{
						Block8Data* _data8_;
						gchar* action_name = NULL;
						const gchar* _tmp73_;
						gchar* _tmp74_;
						const gchar* _tmp75_;
						BudgieIconPopoverItem* _tmp76_;
						BudgieIconPopoverItem* _tmp77_;
						GtkButton* _tmp78_;
						const gchar* _tmp79_;
						gchar* _tmp80_;
						BudgieIconPopoverItem* _tmp81_;
						GtkButton* _tmp82_;
						GtkBox* _tmp83_;
						BudgieIconPopoverItem* _tmp84_;
						const gchar* _tmp85_;
						_data8_ = g_slice_new0 (Block8Data);
						_data8_->_ref_count_ = 1;
						_data8_->self = g_object_ref (self);
						_tmp73_ = action;
						_tmp74_ = g_desktop_app_info_get_action_name (app_info, _tmp73_);
						action_name = _tmp74_;
						_tmp75_ = action_name;
						_tmp76_ = budgie_icon_popover_item_new (_tmp75_, self->priv->longest_label_length);
						g_object_ref_sink (_tmp76_);
						_data8_->action_item = _tmp76_;
						_tmp77_ = _data8_->action_item;
						_tmp78_ = _tmp77_->actionable_label;
						_tmp79_ = action;
						_tmp80_ = g_strdup (_tmp79_);
						g_object_set_data_full ((GObject*) _tmp78_, "action", _tmp80_, g_free);
						_tmp81_ = _data8_->action_item;
						_tmp82_ = _tmp81_->actionable_label;
						g_signal_connect_data (_tmp82_, "clicked", (GCallback) _______lambda10__gtk_button_clicked, block8_data_ref (_data8_), (GClosureNotify) block8_data_unref, 0);
						_tmp83_ = self->actions_list;
						_tmp84_ = _data8_->action_item;
						gtk_box_pack_end (_tmp83_, (GtkWidget*) _tmp84_, TRUE, FALSE, (guint) 0);
						_tmp85_ = action;
						if (g_strcmp0 (_tmp85_, "new-window") == 0) {
							const gchar* _tmp86_;
							gchar* _tmp87_;
							_tmp86_ = action;
							_tmp87_ = g_strdup (_tmp86_);
							_g_free0 (self->priv->preferred_action);
							self->priv->preferred_action = _tmp87_;
						}
						_g_free0 (action_name);
						_g_free0 (action);
						block8_data_unref (_data8_);
						_data8_ = NULL;
					}
				}
			}
		}
	} else {
		GtkGrid* _tmp88_;
		GtkButton* _tmp89_;
		_tmp88_ = self->quick_actions;
		_tmp89_ = self->close_all_button;
		gtk_grid_attach (_tmp88_, (GtkWidget*) _tmp89_, 0, 0, 3, 1);
	}
	_tmp90_ = self->pin_button;
	g_signal_connect_object (_tmp90_, "clicked", (GCallback) ___lambda11__gtk_button_clicked, self, 0);
	_tmp91_ = self->launch_new_instance_button;
	g_signal_connect_object (_tmp91_, "clicked", (GCallback) ___lambda12__gtk_button_clicked, self, 0);
	_tmp92_ = self->close_all_button;
	g_signal_connect_object (_tmp92_, "clicked", (GCallback) _budgie_icon_popover_close_all_windows_gtk_button_clicked, self, 0);
	_tmp93_ = self->always_on_top_button;
	g_signal_connect_object ((GtkToggleButton*) _tmp93_, "toggled", (GCallback) _budgie_icon_popover_toggle_always_on_top_state_gtk_toggle_button_toggled, self, 0);
	_tmp94_ = self->maximize_button;
	_tmp95_ = _tmp94_->actionable_label;
	g_signal_connect_object (_tmp95_, "clicked", (GCallback) _budgie_icon_popover_toggle_maximized_state_gtk_button_clicked, self, 0);
	_tmp96_ = self->minimize_button;
	_tmp97_ = _tmp96_->actionable_label;
	g_signal_connect_object (_tmp97_, "clicked", (GCallback) _budgie_icon_popover_minimize_window_gtk_button_clicked, self, 0);
	_tmp98_ = self->back_button;
	g_signal_connect_object (_tmp98_, "clicked", (GCallback) _budgie_icon_popover_render_gtk_button_clicked, self, 0);
	budgie_icon_popover_apply_button_style (self);
	_tmp99_ = self->stack;
	_tmp100_ = self->primary_view;
	gtk_stack_add_named (_tmp99_, (GtkWidget*) _tmp100_, "primary");
	_tmp101_ = self->stack;
	_tmp102_ = self->actions_view;
	gtk_stack_add_named (_tmp101_, (GtkWidget*) _tmp102_, "actions");
	_tmp103_ = self->stack;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp103_);
	return self;
}

BudgieIconPopover*
budgie_icon_popover_new (GtkWidget* relative_parent,
                         GDesktopAppInfo* app_info,
                         gint current_workspace_count)
{
	return budgie_icon_popover_construct (BUDGIE_TYPE_ICON_POPOVER, relative_parent, app_info, current_workspace_count);
}

/**
 * add_window will add a window to our list
 */
static Block9Data*
block9_data_ref (Block9Data* _data9_)
{
	g_atomic_int_inc (&_data9_->_ref_count_);
	return _data9_;
}

static void
block9_data_unref (void * _userdata_)
{
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
		BudgieIconPopover* self;
		self = _data9_->self;
		_g_object_unref0 (_data9_->item);
		_g_object_unref0 (self);
		g_slice_free (Block9Data, _data9_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
___lambda16_ (Block9Data* _data9_)
{
	BudgieIconPopover* self;
	BudgieIconPopoverItem* _tmp0_;
	self = _data9_->self;
	_tmp0_ = _data9_->item;
	budgie_icon_popover_toggle_window (self, _tmp0_->xid);
}

static void
____lambda16__gtk_button_clicked (GtkButton* _sender,
                                  gpointer self)
{
	___lambda16_ (self);
}

static void
___lambda17_ (Block9Data* _data9_)
{
	BudgieIconPopover* self;
	BudgieIconPopoverItem* _tmp0_;
	self = _data9_->self;
	_tmp0_ = _data9_->item;
	budgie_icon_popover_close_window (self, _tmp0_->xid);
}

static void
____lambda17__gtk_button_clicked (GtkButton* _sender,
                                  gpointer self)
{
	___lambda17_ (self);
}

static void
___lambda18_ (Block9Data* _data9_)
{
	BudgieIconPopover* self;
	BudgieIconPopoverItem* _tmp0_;
	GtkBox* _tmp1_;
	GtkStack* _tmp2_;
	self = _data9_->self;
	_tmp0_ = _data9_->item;
	self->priv->current_window_id = _tmp0_->xid;
	budgie_icon_popover_update_actions_view (self);
	_tmp1_ = self->actions_view;
	gtk_widget_show_all ((GtkWidget*) _tmp1_);
	_tmp2_ = self->stack;
	gtk_stack_set_visible_child_name (_tmp2_, "actions");
}

static void
____lambda18__gtk_button_clicked (GtkButton* _sender,
                                  gpointer self)
{
	___lambda18_ (self);
}

static gulong*
_ulong_dup (gulong* self)
{
	gulong* dup;
	dup = g_new0 (gulong, 1);
	memcpy (dup, self, sizeof (gulong));
	return dup;
}

static gpointer
__ulong_dup0 (gpointer self)
{
	return self ? _ulong_dup (self) : NULL;
}

void
budgie_icon_popover_add_window (BudgieIconPopover* self,
                                gulong xid,
                                const gchar* name)
{
	GHashTable* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = self->window_id_to_name;
	if (!g_hash_table_contains (_tmp0_, &xid)) {
		Block9Data* _data9_;
		WnckWindow* window = NULL;
		WnckWindow* _tmp1_;
		WnckWindow* _tmp2_;
		WnckWindow* _tmp3_;
		WnckWindow* _tmp4_;
		const gchar* _tmp5_;
		BudgieIconPopoverItem* _tmp6_;
		BudgieIconPopoverItem* _tmp7_;
		GtkButton* _tmp8_;
		BudgieIconPopoverItem* _tmp9_;
		GtkButton* _tmp10_;
		BudgieIconPopoverItem* _tmp11_;
		GtkButton* _tmp12_;
		GHashTable* _tmp13_;
		gulong* _tmp14_;
		gchar* _tmp15_;
		GHashTable* _tmp16_;
		gulong* _tmp17_;
		BudgieIconPopoverItem* _tmp18_;
		BudgieIconPopoverItem* _tmp19_;
		GtkBox* _tmp20_;
		BudgieIconPopoverItem* _tmp21_;
		_data9_ = g_slice_new0 (Block9Data);
		_data9_->_ref_count_ = 1;
		_data9_->self = g_object_ref (self);
		_tmp1_ = wnck_window_get (xid);
		_tmp2_ = _g_object_ref0 (_tmp1_);
		window = _tmp2_;
		_tmp3_ = window;
		if (_tmp3_ == NULL) {
			_g_object_unref0 (window);
			block9_data_unref (_data9_);
			_data9_ = NULL;
			return;
		}
		_tmp4_ = window;
		_tmp5_ = wnck_window_get_class_instance_name (_tmp4_);
		if (g_strcmp0 (_tmp5_, "budgie-panel") == 0) {
			self->priv->is_budgie_desktop_settings = TRUE;
			budgie_icon_popover_acquire_settings_remote (self);
		}
		_tmp6_ = budgie_icon_popover_item_new_with_xid (name, xid, self->priv->longest_label_length);
		g_object_ref_sink (_tmp6_);
		_data9_->item = _tmp6_;
		_tmp7_ = _data9_->item;
		_tmp8_ = _tmp7_->actionable_label;
		g_signal_connect_data (_tmp8_, "clicked", (GCallback) ____lambda16__gtk_button_clicked, block9_data_ref (_data9_), (GClosureNotify) block9_data_unref, 0);
		_tmp9_ = _data9_->item;
		_tmp10_ = _tmp9_->close_button;
		g_signal_connect_data (_tmp10_, "clicked", (GCallback) ____lambda17__gtk_button_clicked, block9_data_ref (_data9_), (GClosureNotify) block9_data_unref, 0);
		_tmp11_ = _data9_->item;
		_tmp12_ = _tmp11_->window_controls_button;
		g_signal_connect_data (_tmp12_, "clicked", (GCallback) ____lambda18__gtk_button_clicked, block9_data_ref (_data9_), (GClosureNotify) block9_data_unref, 0);
		_tmp13_ = self->window_id_to_name;
		_tmp14_ = __ulong_dup0 (&xid);
		_tmp15_ = g_strdup (name);
		g_hash_table_insert (_tmp13_, _tmp14_, _tmp15_);
		_tmp16_ = self->priv->window_id_to_controls;
		_tmp17_ = __ulong_dup0 (&xid);
		_tmp18_ = _data9_->item;
		_tmp19_ = _g_object_ref0 (_tmp18_);
		g_hash_table_insert (_tmp16_, _tmp17_, _tmp19_);
		_tmp20_ = self->windows_list;
		_tmp21_ = _data9_->item;
		gtk_box_pack_end (_tmp20_, (GtkWidget*) _tmp21_, TRUE, FALSE, (guint) 0);
		budgie_icon_popover_render (self);
		g_signal_emit (self, budgie_icon_popover_signals[BUDGIE_ICON_POPOVER_ADDED_WINDOW_SIGNAL], 0);
		_g_object_unref0 (window);
		block9_data_unref (_data9_);
		_data9_ = NULL;
	}
}

/**
 * apply_button_style will make our buttons flat
 */
void
budgie_icon_popover_apply_button_style (BudgieIconPopover* self)
{
	GtkButton* _tmp0_;
	GtkStyleContext* _tmp1_;
	GtkButton* _tmp2_;
	GtkStyleContext* _tmp3_;
	GtkButton* _tmp4_;
	GtkStyleContext* _tmp5_;
	GtkButton* _tmp6_;
	GtkStyleContext* _tmp7_;
	GtkButton* _tmp8_;
	GtkStyleContext* _tmp9_;
	GtkButton* _tmp10_;
	GtkStyleContext* _tmp11_;
	GtkButton* _tmp12_;
	GtkStyleContext* _tmp13_;
	GtkButton* _tmp14_;
	GtkStyleContext* _tmp15_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->pin_button;
	_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) _tmp0_);
	gtk_style_context_add_class (_tmp1_, "flat");
	_tmp2_ = self->pin_button;
	_tmp3_ = gtk_widget_get_style_context ((GtkWidget*) _tmp2_);
	gtk_style_context_remove_class (_tmp3_, "button");
	_tmp4_ = self->launch_new_instance_button;
	_tmp5_ = gtk_widget_get_style_context ((GtkWidget*) _tmp4_);
	gtk_style_context_add_class (_tmp5_, "flat");
	_tmp6_ = self->launch_new_instance_button;
	_tmp7_ = gtk_widget_get_style_context ((GtkWidget*) _tmp6_);
	gtk_style_context_remove_class (_tmp7_, "button");
	_tmp8_ = self->close_all_button;
	_tmp9_ = gtk_widget_get_style_context ((GtkWidget*) _tmp8_);
	gtk_style_context_add_class (_tmp9_, "flat");
	_tmp10_ = self->close_all_button;
	_tmp11_ = gtk_widget_get_style_context ((GtkWidget*) _tmp10_);
	gtk_style_context_remove_class (_tmp11_, "button");
	_tmp12_ = self->back_button;
	_tmp13_ = gtk_widget_get_style_context ((GtkWidget*) _tmp12_);
	gtk_style_context_add_class (_tmp13_, "flat");
	_tmp14_ = self->back_button;
	_tmp15_ = gtk_widget_get_style_context ((GtkWidget*) _tmp14_);
	gtk_style_context_remove_class (_tmp15_, "button");
}

static void
_budgie_icon_popover_on_settings_get_gasync_ready_callback (GObject* source_object,
                                                            GAsyncResult* res,
                                                            gpointer self)
{
	budgie_icon_popover_on_settings_get ((BudgieIconPopover*) self, source_object, res);
	g_object_unref (self);
}

void
budgie_icon_popover_acquire_settings_remote (BudgieIconPopover* self)
{
	BudgieSettingsRemote* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings_remote;
	if (_tmp0_ != NULL) {
		return;
	}
	g_async_initable_new_async (BUDGIE_TYPE_SETTINGS_REMOTE_PROXY, 0, NULL, _budgie_icon_popover_on_settings_get_gasync_ready_callback, g_object_ref (self), "g-flags", 0, "g-name", BUDGIE_SETTINGS_DBUS_NAME, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", BUDGIE_SETTINGS_DBUS_PATH, "g-interface-name", "org.budgie_desktop.Settings", NULL);
}

static void
___lambda13_ (BudgieIconPopover* self,
              gulong* xid,
              const gchar* name)
{
	budgie_icon_popover_close_window (self, *xid);
}

static void
____lambda13__gh_func (gconstpointer key,
                       gconstpointer value,
                       gpointer self)
{
	___lambda13_ ((BudgieIconPopover*) self, (gulong*) key, (const gchar*) value);
}

void
budgie_icon_popover_close_all_windows (BudgieIconPopover* self)
{
	GHashTable* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->window_id_to_name;
	_tmp1_ = g_hash_table_size (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != ((guint) 0)) {
		GHashTable* _tmp3_;
		_tmp3_ = self->window_id_to_name;
		g_hash_table_foreach (_tmp3_, ____lambda13__gh_func, self);
	}
}

/**
 * close_window will close a window and remove its respective IconPopoverItem
 */
static void
_budgie_icon_popover_on_settings_closed_gasync_ready_callback (GObject* source_object,
                                                               GAsyncResult* res,
                                                               gpointer self)
{
	budgie_icon_popover_on_settings_closed ((BudgieIconPopover*) self, source_object, res);
	g_object_unref (self);
}

void
budgie_icon_popover_close_window (BudgieIconPopover* self,
                                  gulong xid)
{
	WnckWindow* selected_window = NULL;
	WnckWindow* _tmp0_;
	WnckWindow* _tmp1_;
	WnckWindow* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = wnck_window_get (xid);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	selected_window = _tmp1_;
	_tmp2_ = selected_window;
	if (_tmp2_ != NULL) {
		if (self->priv->is_budgie_desktop_settings) {
			BudgieSettingsRemote* _tmp3_;
			_tmp3_ = self->priv->settings_remote;
			budgie_settings_remote_Close (_tmp3_, _budgie_icon_popover_on_settings_closed_gasync_ready_callback, g_object_ref (self));
		} else {
			WnckWindow* _tmp4_;
			_tmp4_ = selected_window;
			wnck_window_close (_tmp4_, gtk_get_current_event_time ());
		}
	} else {
		g_warning ("IconPopover.vala:292: Failed to get window during close.");
	}
	_g_object_unref0 (selected_window);
}

/**
 * create_images will create the Pixbufs we need for the pinned button
 */
void
budgie_icon_popover_create_images (BudgieIconPopover* self)
{
	GtkImage* _tmp0_;
	GtkImage* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkImage*) gtk_image_new_from_icon_name ("non-starred-symbolic", (GtkIconSize) GTK_ICON_SIZE_SMALL_TOOLBAR);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->non_starred_image);
	self->priv->non_starred_image = _tmp0_;
	_tmp1_ = (GtkImage*) gtk_image_new_from_icon_name ("starred-symbolic", (GtkIconSize) GTK_ICON_SIZE_SMALL_TOOLBAR);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->starred_image);
	self->priv->starred_image = _tmp1_;
}

/**
 * minimize_window will minimize the current window
 */
static gboolean
__lambda15_ (BudgieIconPopover* self)
{
	gboolean result;
	budgie_icon_popover_update_actions_view (self);
	result = FALSE;
	return result;
}

static gboolean
___lambda15__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda15_ ((BudgieIconPopover*) self);
	return result;
}

void
budgie_icon_popover_minimize_window (BudgieIconPopover* self)
{
	WnckWindow* selected_window = NULL;
	WnckWindow* _tmp0_;
	WnckWindow* _tmp1_;
	WnckWindow* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = wnck_window_get (self->priv->current_window_id);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	selected_window = _tmp1_;
	_tmp2_ = selected_window;
	if (_tmp2_ != NULL) {
		WnckWindow* _tmp3_;
		_tmp3_ = selected_window;
		wnck_window_minimize (_tmp3_);
	}
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 250, ___lambda15__gsource_func, g_object_ref (self), g_object_unref);
	_g_object_unref0 (selected_window);
}

void
budgie_icon_popover_on_settings_get (BudgieIconPopover* self,
                                     GObject* o,
                                     GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		BudgieSettingsRemote* _tmp0_ = NULL;
		BudgieSettingsRemote* _tmp1_;
		BudgieSettingsRemote* _tmp2_;
		BudgieSettingsRemote* _tmp3_;
		_tmp1_ = g_async_result_get_source_object (res);
		_tmp2_ = (BudgieSettingsRemote*) g_async_initable_new_finish ((GAsyncInitable *) _tmp1_, res, &_inner_error0_);
		g_object_unref (_tmp1_);
		_tmp0_ = (BudgieSettingsRemote*) _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->settings_remote);
		self->priv->settings_remote = _tmp3_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("IconPopover.vala:324: Failed to get SettingsRemote proxy: %s", _tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
budgie_icon_popover_on_settings_closed (BudgieIconPopover* self,
                                        GObject* o,
                                        GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		BudgieSettingsRemote* _tmp0_;
		BudgieSettingsRemote* _tmp1_;
		_tmp0_ = self->priv->settings_remote;
		if (_tmp0_ == NULL) {
			return;
		}
		_tmp1_ = self->priv->settings_remote;
		budgie_settings_remote_Close_finish (_tmp1_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("IconPopover.vala:336: Failed to close Settings: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

/**
 * remove_window will remove the respective item from our windows list and HashTables
 */
void
budgie_icon_popover_remove_window (BudgieIconPopover* self,
                                   gulong xid)
{
	GHashTable* _tmp0_;
	GtkButton* _tmp12_;
	GHashTable* _tmp13_;
	guint _tmp14_;
	guint _tmp15_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->window_id_to_name;
	if (g_hash_table_contains (_tmp0_, &xid)) {
		BudgieIconPopoverItem* item = NULL;
		GHashTable* _tmp1_;
		gconstpointer _tmp2_;
		BudgieIconPopoverItem* _tmp3_;
		GtkBox* _tmp4_;
		BudgieIconPopoverItem* _tmp5_;
		GHashTable* _tmp6_;
		GHashTable* _tmp7_;
		GHashTable* _tmp8_;
		guint _tmp9_;
		guint _tmp10_;
		_tmp1_ = self->priv->window_id_to_controls;
		_tmp2_ = g_hash_table_lookup (_tmp1_, &xid);
		_tmp3_ = _g_object_ref0 ((BudgieIconPopoverItem*) _tmp2_);
		item = _tmp3_;
		_tmp4_ = self->windows_list;
		_tmp5_ = item;
		gtk_container_remove ((GtkContainer*) _tmp4_, (GtkWidget*) _tmp5_);
		_tmp6_ = self->window_id_to_name;
		g_hash_table_remove (_tmp6_, &xid);
		_tmp7_ = self->priv->window_id_to_controls;
		g_hash_table_remove (_tmp7_, &xid);
		budgie_icon_popover_render (self);
		g_signal_emit (self, budgie_icon_popover_signals[BUDGIE_ICON_POPOVER_CLOSED_WINDOW_SIGNAL], 0);
		_tmp8_ = self->window_id_to_name;
		_tmp9_ = g_hash_table_size (_tmp8_);
		_tmp10_ = _tmp9_;
		if (_tmp10_ == ((guint) 0)) {
			g_signal_emit (self, budgie_icon_popover_signals[BUDGIE_ICON_POPOVER_CLOSED_ALL_SIGNAL], 0);
			if (self->priv->is_budgie_desktop_settings) {
				GtkButton* _tmp11_;
				_tmp11_ = self->launch_new_instance_button;
				gtk_widget_set_sensitive ((GtkWidget*) _tmp11_, TRUE);
			}
		}
		_g_object_unref0 (item);
	}
	_tmp12_ = self->close_all_button;
	_tmp13_ = self->window_id_to_name;
	_tmp14_ = g_hash_table_size (_tmp13_);
	_tmp15_ = _tmp14_;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp12_, _tmp15_ != ((guint) 0));
}

/**
 * rename_window will rename a window we have listed
 */
void
budgie_icon_popover_rename_window (BudgieIconPopover* self,
                                   gulong xid)
{
	GHashTable* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->window_id_to_name;
	if (g_hash_table_contains (_tmp0_, &xid)) {
		WnckWindow* selected_window = NULL;
		WnckWindow* _tmp1_;
		WnckWindow* _tmp2_;
		WnckWindow* _tmp3_;
		_tmp1_ = wnck_window_get (xid);
		_tmp2_ = _g_object_ref0 (_tmp1_);
		selected_window = _tmp2_;
		_tmp3_ = selected_window;
		if (_tmp3_ != NULL) {
			BudgieIconPopoverItem* item = NULL;
			GHashTable* _tmp4_;
			gconstpointer _tmp5_;
			BudgieIconPopoverItem* _tmp6_;
			BudgieIconPopoverItem* _tmp7_;
			WnckWindow* _tmp8_;
			const gchar* _tmp9_;
			_tmp4_ = self->priv->window_id_to_controls;
			_tmp5_ = g_hash_table_lookup (_tmp4_, &xid);
			_tmp6_ = _g_object_ref0 ((BudgieIconPopoverItem*) _tmp5_);
			item = _tmp6_;
			_tmp7_ = item;
			_tmp8_ = selected_window;
			_tmp9_ = wnck_window_get_name (_tmp8_);
			budgie_icon_popover_item_set_label (_tmp7_, _tmp9_);
			_g_object_unref0 (item);
		}
		_g_object_unref0 (selected_window);
	}
}

/**
 * render will determine what we need to render (show v.s. hide) in the popover
 */
void
budgie_icon_popover_render (BudgieIconPopover* self)
{
	gboolean has_actions = FALSE;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gboolean has_windows = FALSE;
	GHashTable* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp11_ = FALSE;
	GtkButton* _tmp14_;
	GHashTable* _tmp15_;
	guint _tmp16_;
	guint _tmp17_;
	GtkBox* _tmp18_;
	GtkBox* _tmp19_;
	GtkStack* _tmp20_;
	GtkStack* _tmp25_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->actions;
	_tmp0__length1 = self->priv->actions_length1;
	has_actions = _tmp0__length1 != 0;
	_tmp1_ = self->window_id_to_name;
	_tmp2_ = g_hash_table_size (_tmp1_);
	_tmp3_ = _tmp2_;
	has_windows = _tmp3_ != ((guint) 0);
	if (has_actions) {
		GtkBox* _tmp4_;
		_tmp4_ = self->actions_list;
		gtk_widget_show_all ((GtkWidget*) _tmp4_);
	} else {
		GtkBox* _tmp5_;
		_tmp5_ = self->actions_list;
		gtk_widget_hide ((GtkWidget*) _tmp5_);
	}
	if (has_windows) {
		GtkBox* _tmp6_;
		_tmp6_ = self->windows_list;
		gtk_widget_show_all ((GtkWidget*) _tmp6_);
	} else {
		GtkBox* _tmp7_;
		_tmp7_ = self->windows_list;
		gtk_widget_hide ((GtkWidget*) _tmp7_);
	}
	if (has_actions) {
		_tmp8_ = has_windows;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		GtkSeparator* _tmp9_;
		_tmp9_ = self->windows_sep;
		gtk_widget_show ((GtkWidget*) _tmp9_);
	} else {
		GtkSeparator* _tmp10_;
		_tmp10_ = self->windows_sep;
		gtk_widget_hide ((GtkWidget*) _tmp10_);
	}
	if (!has_actions) {
		_tmp11_ = !has_windows;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		GtkStyleContext* _tmp12_;
		_tmp12_ = gtk_widget_get_style_context ((GtkWidget*) self);
		gtk_style_context_add_class (_tmp12_, "only-actions");
	} else {
		GtkStyleContext* _tmp13_;
		_tmp13_ = gtk_widget_get_style_context ((GtkWidget*) self);
		gtk_style_context_remove_class (_tmp13_, "only-actions");
	}
	_tmp14_ = self->close_all_button;
	_tmp15_ = self->window_id_to_name;
	_tmp16_ = g_hash_table_size (_tmp15_);
	_tmp17_ = _tmp16_;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp14_, _tmp17_ != ((guint) 0));
	_tmp18_ = self->actions_view;
	gtk_widget_hide ((GtkWidget*) _tmp18_);
	_tmp19_ = self->primary_view;
	gtk_widget_show_all ((GtkWidget*) _tmp19_);
	_tmp20_ = self->stack;
	gtk_stack_set_visible_child_name (_tmp20_, "primary");
	if (self->priv->is_budgie_desktop_settings) {
		GtkButton* _tmp21_;
		GtkButton* _tmp22_;
		_tmp21_ = self->pin_button;
		gtk_widget_hide ((GtkWidget*) _tmp21_);
		_tmp22_ = self->launch_new_instance_button;
		gtk_widget_hide ((GtkWidget*) _tmp22_);
	} else {
		GtkButton* _tmp23_;
		GtkButton* _tmp24_;
		_tmp23_ = self->pin_button;
		gtk_widget_show ((GtkWidget*) _tmp23_);
		_tmp24_ = self->launch_new_instance_button;
		gtk_widget_show ((GtkWidget*) _tmp24_);
	}
	_tmp25_ = self->stack;
	gtk_widget_show ((GtkWidget*) _tmp25_);
}

/**
 * set_pinned_state will change the icon of our pinned button and set pinned state
 */
void
budgie_icon_popover_set_pinned_state (BudgieIconPopover* self,
                                      gboolean pinned_state)
{
	GtkImage* _tmp0_ = NULL;
	GtkButton* _tmp3_;
	const gchar* _tmp4_ = NULL;
	GtkButton* _tmp5_;
	g_return_if_fail (self != NULL);
	self->priv->pinned = pinned_state;
	if (self->priv->pinned) {
		GtkImage* _tmp1_;
		_tmp1_ = self->priv->starred_image;
		_tmp0_ = _tmp1_;
	} else {
		GtkImage* _tmp2_;
		_tmp2_ = self->priv->non_starred_image;
		_tmp0_ = _tmp2_;
	}
	_tmp3_ = self->pin_button;
	gtk_button_set_image (_tmp3_, (GtkWidget*) _tmp0_);
	if (self->priv->pinned) {
		_tmp4_ = _ ("Unfavorite");
	} else {
		_tmp4_ = _ ("Favorite");
	}
	_tmp5_ = self->pin_button;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp5_, _tmp4_);
}

/**
 * set_workspace_count will update our current maximize number of workspaces
 */
static Block10Data*
block10_data_ref (Block10Data* _data10_)
{
	g_atomic_int_inc (&_data10_->_ref_count_);
	return _data10_;
}

static void
block10_data_unref (void * _userdata_)
{
	Block10Data* _data10_;
	_data10_ = (Block10Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
		BudgieIconPopover* self;
		self = _data10_->self;
		_g_object_unref0 (_data10_->item);
		_g_object_unref0 (self);
		g_slice_free (Block10Data, _data10_);
	}
}

static void
_______lambda9_ (Block10Data* _data10_)
{
	BudgieIconPopover* self;
	gint workspace_num = 0;
	BudgieIconPopoverItem* _tmp0_;
	GtkButton* _tmp1_;
	gconstpointer _tmp2_;
	self = _data10_->self;
	_tmp0_ = _data10_->item;
	_tmp1_ = _tmp0_->actionable_label;
	_tmp2_ = g_object_get_data ((GObject*) _tmp1_, "num");
	workspace_num = (gint) ((gintptr) _tmp2_);
	g_signal_emit (self, budgie_icon_popover_signals[BUDGIE_ICON_POPOVER_MOVE_WINDOW_TO_WORKSPACE_SIGNAL], 0, self->priv->current_window_id, workspace_num);
}

static void
________lambda9__gtk_button_clicked (GtkButton* _sender,
                                     gpointer self)
{
	_______lambda9_ (self);
}

static GList*
vala_g_list_remove_full (GList* self,
                         gconstpointer data,
                         GFreeFunc func)
{
	GList* l = NULL;
	GList* result;
	l = self;
	while (TRUE) {
		GList* _tmp0_;
		GList* _tmp1_;
		gconstpointer _tmp2_;
		_tmp0_ = l;
		if (!(_tmp0_ != NULL)) {
			break;
		}
		_tmp1_ = l;
		_tmp2_ = ((GList*) _tmp1_)->data;
		if (_tmp2_ != data) {
			GList* _tmp3_;
			GList* _tmp4_;
			_tmp3_ = l;
			_tmp4_ = ((GList*) _tmp3_)->next;
			l = _tmp4_;
		} else {
			GList* _tmp5_;
			gconstpointer _tmp6_;
			GList* _tmp7_;
			_tmp5_ = l;
			_tmp6_ = ((GList*) _tmp5_)->data;
			func (_tmp6_);
			_tmp7_ = l;
			self = g_list_delete_link (self, (GList*) _tmp7_);
			break;
		}
	}
	result = self;
	return result;
}

void
budgie_icon_popover_set_workspace_count (BudgieIconPopover* self,
                                         gint workspaces)
{
	g_return_if_fail (self != NULL);
	self->priv->workspace_count = workspaces;
	if (self->priv->workspace_count != self->priv->workspaces_added_to_list) {
		if (self->priv->workspace_count > self->priv->workspaces_added_to_list) {
			{
				gint i = 0;
				i = self->priv->workspaces_added_to_list + 1;
				{
					gboolean _tmp0_ = FALSE;
					_tmp0_ = TRUE;
					while (TRUE) {
						Block10Data* _data10_;
						gchar* _tmp2_;
						gchar* _tmp3_;
						BudgieIconPopoverItem* _tmp4_;
						BudgieIconPopoverItem* _tmp5_;
						BudgieIconPopoverItem* _tmp6_;
						GtkButton* _tmp7_;
						BudgieIconPopoverItem* _tmp8_;
						GtkButton* _tmp9_;
						BudgieIconPopoverItem* _tmp10_;
						BudgieIconPopoverItem* _tmp11_;
						GtkBox* _tmp12_;
						BudgieIconPopoverItem* _tmp13_;
						_data10_ = g_slice_new0 (Block10Data);
						_data10_->_ref_count_ = 1;
						_data10_->self = g_object_ref (self);
						if (!_tmp0_) {
							gint _tmp1_;
							_tmp1_ = i;
							i = _tmp1_ + 1;
						}
						_tmp0_ = FALSE;
						if (!(i <= self->priv->workspace_count)) {
							block10_data_unref (_data10_);
							_data10_ = NULL;
							break;
						}
						_tmp2_ = g_strdup_printf (_ ("Move To Workspace %i"), i);
						_tmp3_ = _tmp2_;
						_tmp4_ = budgie_icon_popover_item_new (_tmp3_, 20);
						g_object_ref_sink (_tmp4_);
						_tmp5_ = _tmp4_;
						_g_free0 (_tmp3_);
						_data10_->item = _tmp5_;
						_tmp6_ = _data10_->item;
						_tmp7_ = _tmp6_->actionable_label;
						g_object_set_data_full ((GObject*) _tmp7_, "num", (gpointer) ((gintptr) i), NULL);
						_tmp8_ = _data10_->item;
						_tmp9_ = _tmp8_->actionable_label;
						g_signal_connect_data (_tmp9_, "clicked", (GCallback) ________lambda9__gtk_button_clicked, block10_data_ref (_data10_), (GClosureNotify) block10_data_unref, 0);
						_tmp10_ = _data10_->item;
						_tmp11_ = _g_object_ref0 (_tmp10_);
						self->priv->workspace_items = g_list_append (self->priv->workspace_items, _tmp11_);
						_tmp12_ = self->actions_view;
						_tmp13_ = _data10_->item;
						gtk_box_pack_start (_tmp12_, (GtkWidget*) _tmp13_, FALSE, FALSE, (guint) 0);
						block10_data_unref (_data10_);
						_data10_ = NULL;
					}
				}
			}
			self->priv->workspaces_added_to_list = self->priv->workspace_count;
		} else {
			gint workspaces_to_remove = 0;
			workspaces_to_remove = self->priv->workspaces_added_to_list - self->priv->workspace_count;
			if (workspaces_to_remove > 0) {
				self->priv->workspace_items = g_list_reverse (self->priv->workspace_items);
				{
					gint i = 0;
					i = 0;
					{
						gboolean _tmp14_ = FALSE;
						_tmp14_ = TRUE;
						while (TRUE) {
							BudgieIconPopoverItem* child = NULL;
							GList* _tmp16_;
							gconstpointer _tmp17_;
							BudgieIconPopoverItem* _tmp18_;
							BudgieIconPopoverItem* _tmp19_;
							if (!_tmp14_) {
								gint _tmp15_;
								_tmp15_ = i;
								i = _tmp15_ + 1;
							}
							_tmp14_ = FALSE;
							if (!(i < workspaces_to_remove)) {
								break;
							}
							_tmp16_ = self->priv->workspace_items;
							_tmp17_ = g_list_nth_data (_tmp16_, (guint) i);
							_tmp18_ = _g_object_ref0 ((BudgieIconPopoverItem*) _tmp17_);
							child = _tmp18_;
							_tmp19_ = child;
							if (_tmp19_ != NULL) {
								GtkBox* _tmp20_;
								BudgieIconPopoverItem* _tmp21_;
								BudgieIconPopoverItem* _tmp22_;
								_tmp20_ = self->actions_view;
								_tmp21_ = child;
								gtk_container_remove ((GtkContainer*) _tmp20_, (GtkWidget*) _tmp21_);
								_tmp22_ = child;
								self->priv->workspace_items = vala_g_list_remove_full (self->priv->workspace_items, _tmp22_, _g_object_unref0_);
							}
							_g_object_unref0 (child);
						}
					}
				}
				self->priv->workspace_items = g_list_reverse (self->priv->workspace_items);
			}
		}
	}
}

/**
 * toggle_always_on_top_state will toggle the always on state of the current window
 */
void
budgie_icon_popover_toggle_always_on_top_state (BudgieIconPopover* self)
{
	WnckWindow* selected_window = NULL;
	WnckWindow* _tmp0_;
	WnckWindow* _tmp1_;
	WnckWindow* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = wnck_window_get (self->priv->current_window_id);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	selected_window = _tmp1_;
	_tmp2_ = selected_window;
	if (_tmp2_ != NULL) {
		WnckWindow* _tmp3_;
		_tmp3_ = selected_window;
		if (wnck_window_is_above (_tmp3_)) {
			WnckWindow* _tmp4_;
			_tmp4_ = selected_window;
			wnck_window_unmake_above (_tmp4_);
		} else {
			WnckWindow* _tmp5_;
			_tmp5_ = selected_window;
			wnck_window_make_above (_tmp5_);
		}
	}
	_g_object_unref0 (selected_window);
}

/**
 * toggle_maximized_state will toggle the maximized state of the current window
 */
static gboolean
___lambda14_ (BudgieIconPopover* self)
{
	gboolean result;
	budgie_icon_popover_update_actions_view (self);
	result = FALSE;
	return result;
}

static gboolean
____lambda14__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda14_ ((BudgieIconPopover*) self);
	return result;
}

void
budgie_icon_popover_toggle_maximized_state (BudgieIconPopover* self)
{
	WnckWindow* selected_window = NULL;
	WnckWindow* _tmp0_;
	WnckWindow* _tmp1_;
	WnckWindow* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = wnck_window_get (self->priv->current_window_id);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	selected_window = _tmp1_;
	_tmp2_ = selected_window;
	if (_tmp2_ != NULL) {
		WnckWindow* _tmp3_;
		WnckWindow* _tmp8_;
		_tmp3_ = selected_window;
		if (!wnck_window_is_minimized (_tmp3_)) {
			WnckWindow* _tmp4_;
			_tmp4_ = selected_window;
			if (wnck_window_is_maximized (_tmp4_)) {
				WnckWindow* _tmp5_;
				_tmp5_ = selected_window;
				wnck_window_unmaximize (_tmp5_);
			} else {
				WnckWindow* _tmp6_;
				_tmp6_ = selected_window;
				wnck_window_maximize (_tmp6_);
			}
		} else {
			WnckWindow* _tmp7_;
			_tmp7_ = selected_window;
			wnck_window_maximize (_tmp7_);
		}
		_tmp8_ = selected_window;
		wnck_window_activate (_tmp8_, gtk_get_current_event_time ());
		g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 250, ____lambda14__gsource_func, g_object_ref (self), g_object_unref);
	}
	_g_object_unref0 (selected_window);
}

/**
 * toggle_window will activate or minimize this window
 */
void
budgie_icon_popover_toggle_window (BudgieIconPopover* self,
                                   gulong xid)
{
	GHashTable* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->window_id_to_name;
	if (g_hash_table_contains (_tmp0_, &xid)) {
		WnckWindow* selected_window = NULL;
		WnckWindow* _tmp1_;
		WnckWindow* _tmp2_;
		WnckWindow* _tmp3_;
		_tmp1_ = wnck_window_get (xid);
		_tmp2_ = _g_object_ref0 (_tmp1_);
		selected_window = _tmp2_;
		_tmp3_ = selected_window;
		if (_tmp3_ != NULL) {
			WnckWindow* _tmp4_;
			_tmp4_ = selected_window;
			if (!wnck_window_is_active (_tmp4_)) {
				WnckWindow* _tmp5_;
				_tmp5_ = selected_window;
				wnck_window_activate (_tmp5_, gtk_get_current_event_time ());
			} else {
				WnckWindow* _tmp6_;
				_tmp6_ = selected_window;
				wnck_window_minimize (_tmp6_);
			}
		}
		_g_object_unref0 (selected_window);
	}
}

/**
 * update_actions_view will update the actions view
 */
void
budgie_icon_popover_update_actions_view (BudgieIconPopover* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->current_window_id != ((gulong) 0)) {
		WnckWindow* selected_window = NULL;
		WnckWindow* _tmp0_;
		WnckWindow* _tmp1_;
		WnckWindow* _tmp2_;
		_tmp0_ = wnck_window_get (self->priv->current_window_id);
		_tmp1_ = _g_object_ref0 (_tmp0_);
		selected_window = _tmp1_;
		_tmp2_ = selected_window;
		if (_tmp2_ != NULL) {
			GtkCheckButton* _tmp3_;
			WnckWindow* _tmp4_;
			const gchar* _tmp5_ = NULL;
			gboolean _tmp6_ = FALSE;
			WnckWindow* _tmp7_;
			gchar* maximize_label = NULL;
			gchar* _tmp9_;
			BudgieIconPopoverItem* _tmp10_;
			const gchar* _tmp11_;
			_tmp3_ = self->always_on_top_button;
			_tmp4_ = selected_window;
			gtk_toggle_button_set_active ((GtkToggleButton*) _tmp3_, wnck_window_is_above (_tmp4_));
			_tmp7_ = selected_window;
			if (wnck_window_is_maximized (_tmp7_)) {
				WnckWindow* _tmp8_;
				_tmp8_ = selected_window;
				_tmp6_ = !wnck_window_is_minimized (_tmp8_);
			} else {
				_tmp6_ = FALSE;
			}
			if (_tmp6_) {
				_tmp5_ = _ ("Unmaximize");
			} else {
				_tmp5_ = _ ("Maximize");
			}
			_tmp9_ = g_strdup (_tmp5_);
			maximize_label = _tmp9_;
			_tmp10_ = self->maximize_button;
			_tmp11_ = maximize_label;
			budgie_icon_popover_item_set_label (_tmp10_, _tmp11_);
			gtk_widget_queue_draw ((GtkWidget*) self);
			_g_free0 (maximize_label);
		}
		_g_object_unref0 (selected_window);
	}
}

static void
g_cclosure_user_marshal_VOID__ULONG_INT (GClosure * closure,
                                         GValue * return_value,
                                         guint n_param_values,
                                         const GValue * param_values,
                                         gpointer invocation_hint,
                                         gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__ULONG_INT) (gpointer data1, gulong arg_1, gint arg_2, gpointer data2);
	register GMarshalFunc_VOID__ULONG_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__ULONG_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_ulong (param_values + 1), g_value_get_int (param_values + 2), data2);
}

static void
budgie_icon_popover_class_init (BudgieIconPopoverClass * klass,
                                gpointer klass_data)
{
	budgie_icon_popover_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BudgieIconPopover_private_offset);
	G_OBJECT_CLASS (klass)->finalize = budgie_icon_popover_finalize;
	/**
	 * Signals
	 */
	budgie_icon_popover_signals[BUDGIE_ICON_POPOVER_ADDED_WINDOW_SIGNAL] = g_signal_new ("added-window", BUDGIE_TYPE_ICON_POPOVER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	budgie_icon_popover_signals[BUDGIE_ICON_POPOVER_CLOSED_ALL_SIGNAL] = g_signal_new ("closed-all", BUDGIE_TYPE_ICON_POPOVER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	budgie_icon_popover_signals[BUDGIE_ICON_POPOVER_CLOSED_WINDOW_SIGNAL] = g_signal_new ("closed-window", BUDGIE_TYPE_ICON_POPOVER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	budgie_icon_popover_signals[BUDGIE_ICON_POPOVER_CHANGED_PIN_STATE_SIGNAL] = g_signal_new ("changed-pin-state", BUDGIE_TYPE_ICON_POPOVER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
	budgie_icon_popover_signals[BUDGIE_ICON_POPOVER_LAUNCH_NEW_INSTANCE_SIGNAL] = g_signal_new ("launch-new-instance", BUDGIE_TYPE_ICON_POPOVER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	budgie_icon_popover_signals[BUDGIE_ICON_POPOVER_MOVE_WINDOW_TO_WORKSPACE_SIGNAL] = g_signal_new ("move-window-to-workspace", BUDGIE_TYPE_ICON_POPOVER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__ULONG_INT, G_TYPE_NONE, 2, G_TYPE_ULONG, G_TYPE_INT);
	budgie_icon_popover_signals[BUDGIE_ICON_POPOVER_PERFORM_ACTION_SIGNAL] = g_signal_new ("perform-action", BUDGIE_TYPE_ICON_POPOVER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
}

static void
budgie_icon_popover_instance_init (BudgieIconPopover * self,
                                   gpointer klass)
{
	gchar* _tmp0_;
	self->priv = budgie_icon_popover_get_instance_private (self);
	self->priv->is_budgie_desktop_settings = FALSE;
	self->priv->current_window_id = (gulong) 0;
	self->priv->longest_label_length = 20;
	self->priv->actions = NULL;
	self->priv->actions_length1 = 0;
	self->priv->_actions_size_ = self->priv->actions_length1;
	_tmp0_ = g_strdup ("");
	self->priv->preferred_action = _tmp0_;
	self->priv->pinned = FALSE;
	self->priv->workspace_count = 0;
	self->priv->workspaces_added_to_list = 0;
	self->priv->non_starred_image = NULL;
	self->priv->starred_image = NULL;
	self->priv->settings_remote = NULL;
	self->stack = NULL;
	self->primary_view = NULL;
	self->actions_view = NULL;
	self->actions_list = NULL;
	self->actions_view_buttons = NULL;
	self->windows_list = NULL;
	self->windows_sep = NULL;
	self->quick_actions = NULL;
	self->always_on_top_button = NULL;
	self->pin_button = NULL;
	self->back_button = NULL;
	self->close_all_button = NULL;
	self->launch_new_instance_button = NULL;
	self->maximize_button = NULL;
	self->minimize_button = NULL;
}

static void
budgie_icon_popover_finalize (GObject * obj)
{
	BudgieIconPopover * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_ICON_POPOVER, BudgieIconPopover);
	_g_hash_table_unref0 (self->window_id_to_name);
	_g_hash_table_unref0 (self->priv->window_id_to_controls);
	(self->priv->workspace_items == NULL) ? NULL : (self->priv->workspace_items = (_g_list_free__g_object_unref0_ (self->priv->workspace_items), NULL));
	_g_free0 (self->priv->preferred_action);
	_g_object_unref0 (self->priv->non_starred_image);
	_g_object_unref0 (self->priv->starred_image);
	_g_object_unref0 (self->priv->settings_remote);
	_g_object_unref0 (self->stack);
	_g_object_unref0 (self->primary_view);
	_g_object_unref0 (self->actions_view);
	_g_object_unref0 (self->actions_list);
	_g_object_unref0 (self->actions_view_buttons);
	_g_object_unref0 (self->windows_list);
	_g_object_unref0 (self->windows_sep);
	_g_object_unref0 (self->quick_actions);
	_g_object_unref0 (self->always_on_top_button);
	_g_object_unref0 (self->pin_button);
	_g_object_unref0 (self->back_button);
	_g_object_unref0 (self->close_all_button);
	_g_object_unref0 (self->launch_new_instance_button);
	_g_object_unref0 (self->maximize_button);
	_g_object_unref0 (self->minimize_button);
	G_OBJECT_CLASS (budgie_icon_popover_parent_class)->finalize (obj);
}

GType
budgie_icon_popover_get_type (void)
{
	return budgie_icon_popover_type_id;
}

GType
budgie_icon_popover_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieIconPopoverClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_icon_popover_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieIconPopover), 0, (GInstanceInitFunc) budgie_icon_popover_instance_init, NULL };
	budgie_icon_popover_type_id = g_type_module_register_type (module, budgie_popover_get_type (), "BudgieIconPopover", &g_define_type_info, 0);
	BudgieIconPopover_private_offset = sizeof (BudgieIconPopoverPrivate);
	return budgie_icon_popover_type_id;
}

BudgieIconPopoverItem*
budgie_icon_popover_item_construct (GType object_type,
                                    const gchar* label_content,
                                    gint label_length)
{
	BudgieIconPopoverItem * self = NULL;
	GtkButton* _tmp0_;
	GtkBox* actionable_label_container = NULL;
	GtkBox* _tmp1_;
	GtkLabel* _tmp2_;
	GtkLabel* _tmp3_;
	GtkLabel* _tmp4_;
	GtkLabel* _tmp5_;
	GtkLabel* _tmp6_;
	GtkLabel* _tmp7_;
	GtkButton* _tmp8_;
	GtkButton* _tmp9_;
	g_return_val_if_fail (label_content != NULL, NULL);
	self = (BudgieIconPopoverItem*) g_object_new (object_type, "orientation", GTK_ORIENTATION_HORIZONTAL, "spacing", 0, NULL);
	g_object_set ((GtkWidget*) self, "height-request", 32, NULL);
	g_object_set ((GtkWidget*) self, "margin", 0, NULL);
	_tmp0_ = (GtkButton*) gtk_button_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->actionable_label);
	self->actionable_label = _tmp0_;
	_tmp1_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp1_);
	actionable_label_container = _tmp1_;
	_tmp2_ = (GtkLabel*) gtk_label_new (label_content);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->actionable_label_content);
	self->actionable_label_content = _tmp2_;
	_tmp3_ = self->actionable_label_content;
	gtk_label_set_ellipsize (_tmp3_, PANGO_ELLIPSIZE_END);
	_tmp4_ = self->actionable_label_content;
	gtk_widget_set_halign ((GtkWidget*) _tmp4_, GTK_ALIGN_START);
	_tmp5_ = self->actionable_label_content;
	gtk_label_set_justify (_tmp5_, GTK_JUSTIFY_LEFT);
	_tmp6_ = self->actionable_label_content;
	gtk_label_set_max_width_chars (_tmp6_, label_length);
	_tmp7_ = self->actionable_label_content;
	gtk_box_pack_start (actionable_label_container, (GtkWidget*) _tmp7_, FALSE, TRUE, (guint) 0);
	_tmp8_ = self->actionable_label;
	gtk_container_add ((GtkContainer*) _tmp8_, (GtkWidget*) actionable_label_container);
	budgie_icon_popover_item_apply_button_style (self);
	_tmp9_ = self->actionable_label;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp9_, TRUE, TRUE, (guint) 0);
	_g_object_unref0 (actionable_label_container);
	return self;
}

BudgieIconPopoverItem*
budgie_icon_popover_item_new (const gchar* label_content,
                              gint label_length)
{
	return budgie_icon_popover_item_construct (BUDGIE_TYPE_ICON_POPOVER_ITEM, label_content, label_length);
}

BudgieIconPopoverItem*
budgie_icon_popover_item_construct_with_xid (GType object_type,
                                             const gchar* label_content,
                                             gulong xid,
                                             gint label_length)
{
	BudgieIconPopoverItem * self = NULL;
	GtkButton* _tmp0_;
	GtkBox* actionable_label_container = NULL;
	GtkBox* _tmp1_;
	GtkLabel* _tmp2_;
	GtkLabel* _tmp3_;
	GtkLabel* _tmp4_;
	GtkLabel* _tmp5_;
	GtkLabel* _tmp6_;
	GtkLabel* _tmp7_;
	GtkButton* _tmp8_;
	GtkButton* _tmp9_;
	GtkButton* _tmp10_;
	GtkButton* _tmp11_;
	GtkButton* _tmp12_;
	GtkButton* _tmp13_;
	GtkButton* _tmp14_;
	GtkButton* _tmp15_;
	g_return_val_if_fail (label_content != NULL, NULL);
	self = (BudgieIconPopoverItem*) g_object_new (object_type, "orientation", GTK_ORIENTATION_HORIZONTAL, "spacing", 0, NULL);
	g_object_set ((GtkWidget*) self, "height-request", 32, NULL);
	g_object_set ((GtkWidget*) self, "margin", 0, NULL);
	_tmp0_ = (GtkButton*) gtk_button_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->actionable_label);
	self->actionable_label = _tmp0_;
	_tmp1_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp1_);
	actionable_label_container = _tmp1_;
	_tmp2_ = (GtkLabel*) gtk_label_new (label_content);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->actionable_label_content);
	self->actionable_label_content = _tmp2_;
	_tmp3_ = self->actionable_label_content;
	gtk_label_set_ellipsize (_tmp3_, PANGO_ELLIPSIZE_END);
	_tmp4_ = self->actionable_label_content;
	gtk_widget_set_halign ((GtkWidget*) _tmp4_, GTK_ALIGN_START);
	_tmp5_ = self->actionable_label_content;
	gtk_label_set_justify (_tmp5_, GTK_JUSTIFY_LEFT);
	_tmp6_ = self->actionable_label_content;
	gtk_label_set_max_width_chars (_tmp6_, label_length);
	_tmp7_ = self->actionable_label_content;
	gtk_box_pack_start (actionable_label_container, (GtkWidget*) _tmp7_, TRUE, TRUE, (guint) 0);
	_tmp8_ = self->actionable_label;
	gtk_container_add ((GtkContainer*) _tmp8_, (GtkWidget*) actionable_label_container);
	self->xid = xid;
	_tmp9_ = (GtkButton*) gtk_button_new_from_icon_name ("window-close-symbolic", (GtkIconSize) GTK_ICON_SIZE_SMALL_TOOLBAR);
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->close_button);
	self->close_button = _tmp9_;
	_tmp10_ = self->close_button;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp10_, _ ("Close Window"));
	_tmp11_ = (GtkButton*) gtk_button_new_from_icon_name ("go-next-symbolic", (GtkIconSize) GTK_ICON_SIZE_SMALL_TOOLBAR);
	g_object_ref_sink (_tmp11_);
	_g_object_unref0 (self->window_controls_button);
	self->window_controls_button = _tmp11_;
	_tmp12_ = self->window_controls_button;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp12_, _ ("Show Window Controls"));
	budgie_icon_popover_item_apply_button_style (self);
	_tmp13_ = self->actionable_label;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp13_, TRUE, TRUE, (guint) 0);
	_tmp14_ = self->close_button;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp14_, FALSE, FALSE, (guint) 0);
	_tmp15_ = self->window_controls_button;
	gtk_box_pack_end ((GtkBox*) self, (GtkWidget*) _tmp15_, FALSE, FALSE, (guint) 0);
	_g_object_unref0 (actionable_label_container);
	return self;
}

BudgieIconPopoverItem*
budgie_icon_popover_item_new_with_xid (const gchar* label_content,
                                       gulong xid,
                                       gint label_length)
{
	return budgie_icon_popover_item_construct_with_xid (BUDGIE_TYPE_ICON_POPOVER_ITEM, label_content, xid, label_length);
}

/**
 * apply_button_style will make our buttons flat
 */
void
budgie_icon_popover_item_apply_button_style (BudgieIconPopoverItem* self)
{
	GtkButton* _tmp0_;
	GtkButton* _tmp5_;
	GtkButton* _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->actionable_label;
	if (_tmp0_ != NULL) {
		GtkButton* _tmp1_;
		GtkStyleContext* _tmp2_;
		GtkButton* _tmp3_;
		GtkStyleContext* _tmp4_;
		_tmp1_ = self->actionable_label;
		_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) _tmp1_);
		gtk_style_context_add_class (_tmp2_, "flat");
		_tmp3_ = self->actionable_label;
		_tmp4_ = gtk_widget_get_style_context ((GtkWidget*) _tmp3_);
		gtk_style_context_remove_class (_tmp4_, "button");
	}
	_tmp5_ = self->close_button;
	if (_tmp5_ != NULL) {
		GtkButton* _tmp6_;
		GtkStyleContext* _tmp7_;
		GtkButton* _tmp8_;
		GtkStyleContext* _tmp9_;
		_tmp6_ = self->close_button;
		_tmp7_ = gtk_widget_get_style_context ((GtkWidget*) _tmp6_);
		gtk_style_context_add_class (_tmp7_, "flat");
		_tmp8_ = self->close_button;
		_tmp9_ = gtk_widget_get_style_context ((GtkWidget*) _tmp8_);
		gtk_style_context_remove_class (_tmp9_, "button");
	}
	_tmp10_ = self->window_controls_button;
	if (_tmp10_ != NULL) {
		GtkButton* _tmp11_;
		GtkStyleContext* _tmp12_;
		GtkButton* _tmp13_;
		GtkStyleContext* _tmp14_;
		_tmp11_ = self->window_controls_button;
		_tmp12_ = gtk_widget_get_style_context ((GtkWidget*) _tmp11_);
		gtk_style_context_add_class (_tmp12_, "flat");
		_tmp13_ = self->window_controls_button;
		_tmp14_ = gtk_widget_get_style_context ((GtkWidget*) _tmp13_);
		gtk_style_context_remove_class (_tmp14_, "button");
	}
}

/**
 * set_label will set the label content
 */
void
budgie_icon_popover_item_set_label (BudgieIconPopoverItem* self,
                                    const gchar* label)
{
	GtkLabel* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (label != NULL);
	_tmp0_ = self->actionable_label_content;
	gtk_label_set_label (_tmp0_, label);
}

static void
budgie_icon_popover_item_class_init (BudgieIconPopoverItemClass * klass,
                                     gpointer klass_data)
{
	budgie_icon_popover_item_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = budgie_icon_popover_item_finalize;
}

static void
budgie_icon_popover_item_instance_init (BudgieIconPopoverItem * self,
                                        gpointer klass)
{
}

static void
budgie_icon_popover_item_finalize (GObject * obj)
{
	BudgieIconPopoverItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_ICON_POPOVER_ITEM, BudgieIconPopoverItem);
	_g_object_unref0 (self->actionable_label);
	_g_object_unref0 (self->actionable_label_content);
	_g_object_unref0 (self->close_button);
	_g_object_unref0 (self->window_controls_button);
	G_OBJECT_CLASS (budgie_icon_popover_item_parent_class)->finalize (obj);
}

/**
 * IconPopoverItem is an item for our IconPopover
 */
GType
budgie_icon_popover_item_get_type (void)
{
	return budgie_icon_popover_item_type_id;
}

GType
budgie_icon_popover_item_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieIconPopoverItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_icon_popover_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieIconPopoverItem), 0, (GInstanceInitFunc) budgie_icon_popover_item_instance_init, NULL };
	budgie_icon_popover_item_type_id = g_type_module_register_type (module, gtk_box_get_type (), "BudgieIconPopoverItem", &g_define_type_info, 0);
	return budgie_icon_popover_item_type_id;
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

