/* IconTasklistApplet.c generated by valac 0.56.2, the Vala compiler
 * generated from IconTasklistApplet.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright © 2015-2022 Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include "icontasklistapplet.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "plugin.h"
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include "abomination.h"
#include <libwnck/libwnck.h>
#include "appsys.h"
#include <gdk/gdk.h>
#include <gio/gdesktopappinfo.h>
#include <cairo-gobject.h>
#include <libpeas/peas.h>

enum  {
	ICON_TASKLIST_0_PROPERTY,
	ICON_TASKLIST_NUM_PROPERTIES
};
static GParamSpec* icon_tasklist_properties[ICON_TASKLIST_NUM_PROPERTIES];
enum  {
	ICON_TASKLIST_SETTINGS_0_PROPERTY,
	ICON_TASKLIST_SETTINGS_NUM_PROPERTIES
};
static GParamSpec* icon_tasklist_settings_properties[ICON_TASKLIST_SETTINGS_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	ICON_TASKLIST_APPLET_0_PROPERTY,
	ICON_TASKLIST_APPLET_UUID_PROPERTY,
	ICON_TASKLIST_APPLET_NUM_PROPERTIES
};
static GParamSpec* icon_tasklist_applet_properties[ICON_TASKLIST_APPLET_NUM_PROPERTIES];
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _Block1Data Block1Data;

struct _IconTasklistSettingsPrivate {
	GtkSwitch* switch_grouping;
	GtkSwitch* switch_restrict;
	GtkSwitch* switch_lock_icons;
	GtkSwitch* switch_only_pinned;
	GtkSwitch* show_all_on_click;
	GtkSwitch* switch_middle_click_create_new_instance;
	GtkSwitch* switch_require_double_click_to_launch_new_instance;
	GSettings* settings;
};

struct _IconTasklistAppletPrivate {
	BudgieAbominationAbomination* abomination;
	WnckScreen* wnck_screen;
	GSettings* settings;
	GtkBox* main_layout;
	gboolean grouping;
	gboolean restrict_to_workspace;
	gboolean only_show_pinned;
	GHashTable* buttons;
	GRecMutex __lock_buttons;
	DesktopHelper* desktop_helper;
	BudgieAppSystem* app_system;
	BudgiePopoverManager* manager;
	gchar* _uuid;
};

struct _Block1Data {
	int _ref_count_;
	IconTasklistApplet* self;
	ButtonWrapper* wrapper;
	gchar* app_id;
	IconButton* button;
};

static gpointer icon_tasklist_parent_class = NULL;
static BudgiePluginIface * icon_tasklist_budgie_plugin_parent_iface = NULL;
static GType icon_tasklist_type_id = 0;
static gint IconTasklistSettings_private_offset;
static gpointer icon_tasklist_settings_parent_class = NULL;
static GType icon_tasklist_settings_type_id = 0;
static gint IconTasklistApplet_private_offset;
static gpointer icon_tasklist_applet_parent_class = NULL;
static GType icon_tasklist_applet_type_id = 0;

static BudgieApplet* icon_tasklist_real_get_panel_widget (BudgiePlugin* base,
                                                   const gchar* uuid);
static void icon_tasklist_settings_finalize (GObject * obj);
static GtkWidget* icon_tasklist_applet_real_get_settings_ui (BudgieApplet* base);
static gboolean icon_tasklist_applet_real_supports_settings (BudgieApplet* base);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
static void icon_tasklist_applet_on_settings_changed (IconTasklistApplet* self,
                                               const gchar* key);
static void _icon_tasklist_applet_on_settings_changed_g_settings_changed (GSettings* _sender,
                                                                   const gchar* key,
                                                                   gpointer self);
static void icon_tasklist_applet_on_drag_data_received (IconTasklistApplet* self,
                                                 GtkWidget* widget,
                                                 GdkDragContext* context,
                                                 gint x,
                                                 gint y,
                                                 GtkSelectionData* selection_data,
                                                 guint item,
                                                 guint time);
static void _icon_tasklist_applet_on_drag_data_received_gtk_widget_drag_data_received (GtkWidget* _sender,
                                                                                GdkDragContext* context,
                                                                                gint x,
                                                                                gint y,
                                                                                GtkSelectionData* selection_data,
                                                                                guint info,
                                                                                guint time_,
                                                                                gpointer self);
static void icon_tasklist_applet_connect_app_signals (IconTasklistApplet* self);
static void icon_tasklist_applet_on_active_window_changed (IconTasklistApplet* self);
static void icon_tasklist_applet_startup (IconTasklistApplet* self);
static void icon_tasklist_applet_add_icon_button (IconTasklistApplet* self,
                                           const gchar* app_id,
                                           IconButton* button);
static void _icon_tasklist_applet_on_active_window_changed_wnck_screen_active_window_changed (WnckScreen* _sender,
                                                                                       WnckWindow* previous_window,
                                                                                       gpointer self);
static void icon_tasklist_applet_update_buttons (IconTasklistApplet* self);
static void _icon_tasklist_applet_update_buttons_wnck_screen_active_workspace_changed (WnckScreen* _sender,
                                                                                WnckWorkspace* previous_workspace,
                                                                                gpointer self);
static void __lambda51_ (IconTasklistApplet* self,
                  const gchar* group,
                  BudgieAbominationRunningApp* app);
static void icon_tasklist_applet_on_app_opened (IconTasklistApplet* self,
                                         BudgieAbominationRunningApp* app);
static void ___lambda51__budgie_abomination_abomination_added_app (BudgieAbominationAbomination* _sender,
                                                            const gchar* group,
                                                            BudgieAbominationRunningApp* app,
                                                            gpointer self);
static void __lambda52_ (IconTasklistApplet* self,
                  const gchar* group,
                  BudgieAbominationRunningApp* app);
static void icon_tasklist_applet_on_app_closed (IconTasklistApplet* self,
                                         BudgieAbominationRunningApp* app);
static void ___lambda52__budgie_abomination_abomination_removed_app (BudgieAbominationAbomination* _sender,
                                                              const gchar* group,
                                                              BudgieAbominationRunningApp* app,
                                                              gpointer self);
static void __lambda53_ (IconTasklistApplet* self,
                  BudgieAbominationAppGroup* group);
static void icon_tasklist_applet_remove_button (IconTasklistApplet* self,
                                         const gchar* key);
static void ___lambda53__budgie_abomination_abomination_updated_group (BudgieAbominationAbomination* _sender,
                                                                BudgieAbominationAppGroup* group,
                                                                gpointer self);
static void icon_tasklist_applet_rebuild_items (IconTasklistApplet* self);
static void _icon_tasklist_applet_on_app_opened_gfunc (gconstpointer data,
                                                gpointer self);
static gboolean ___lambda47_ (IconTasklistApplet* self);
static gboolean ____lambda47__gsource_func (gpointer self);
static void __lambda50_ (IconTasklistApplet* self,
                  const gchar* id,
                  IconButton* button);
static void icon_tasklist_applet_update_button (IconTasklistApplet* self,
                                         IconButton* button);
static void ___lambda50__gh_func (gconstpointer key,
                           gconstpointer value,
                           gpointer self);
static GtkOrientation icon_tasklist_applet_get_orientation (IconTasklistApplet* self);
static void icon_tasklist_applet_add_button (IconTasklistApplet* self,
                                      const gchar* key,
                                      IconButton* button);
static void icon_tasklist_applet_swap_button (IconTasklistApplet* self,
                                       const gchar* old_key,
                                       const gchar* new_key);
static void icon_tasklist_applet_set_icons_size (IconTasklistApplet* self);
static gboolean __lambda54_ (IconTasklistApplet* self);
static void __lambda55_ (IconTasklistApplet* self,
                  const gchar* id,
                  IconButton* button);
static void ___lambda55__gh_func (gconstpointer key,
                           gconstpointer value,
                           gpointer self);
static gboolean ___lambda54__gsource_func (gpointer self);
static void icon_tasklist_applet_real_panel_position_changed (BudgieApplet* base,
                                                       BudgiePanelPosition position);
static void icon_tasklist_applet_real_panel_size_changed (BudgieApplet* base,
                                                   gint panel,
                                                   gint icon,
                                                   gint small_icon);
static void icon_tasklist_applet_real_update_popovers (BudgieApplet* base,
                                                BudgiePopoverManager* manager);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda48_ (Block1Data* _data1_);
static void ___lambda48__icon_button_became_empty (IconButton* _sender,
                                            gpointer self);
static void __lambda49_ (Block1Data* _data1_);
static void ___lambda49__icon_button_pinned_changed (IconButton* _sender,
                                              gpointer self);
static void icon_tasklist_applet_finalize (GObject * obj);
static void _vala_icon_tasklist_applet_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_icon_tasklist_applet_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec);
GType budgie_icon_popover_register_type (GTypeModule * module);
GType budgie_icon_popover_item_register_type (GTypeModule * module);
GType budgie_settings_remote_register_type (GTypeModule * module);
GType budgie_task_list_animation_register_type (GTypeModule * module);
GType button_wrapper_register_type (GTypeModule * module);
GType desktop_helper_register_type (GTypeModule * module);
GType icon_button_register_type (GTypeModule * module);
GType icon_register_type (GTypeModule * module);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

VALA_EXTERN const GtkTargetEntry DESKTOP_HELPER_targets[3];

static BudgieApplet*
icon_tasklist_real_get_panel_widget (BudgiePlugin* base,
                                     const gchar* uuid)
{
	IconTasklist * self;
	IconTasklistApplet* _tmp0_;
	BudgieApplet* result;
	self = (IconTasklist*) base;
	g_return_val_if_fail (uuid != NULL, NULL);
	_tmp0_ = icon_tasklist_applet_new (uuid);
	g_object_ref_sink (_tmp0_);
	result = (BudgieApplet*) _tmp0_;
	return result;
}

IconTasklist*
icon_tasklist_construct (GType object_type)
{
	IconTasklist * self = NULL;
	self = (IconTasklist*) g_object_new (object_type, NULL);
	return self;
}

IconTasklist*
icon_tasklist_new (void)
{
	return icon_tasklist_construct (TYPE_ICON_TASKLIST);
}

static void
icon_tasklist_class_init (IconTasklistClass * klass,
                          gpointer klass_data)
{
	icon_tasklist_parent_class = g_type_class_peek_parent (klass);
}

static void
icon_tasklist_budgie_plugin_interface_init (BudgiePluginIface * iface,
                                            gpointer iface_data)
{
	icon_tasklist_budgie_plugin_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_panel_widget = (BudgieApplet* (*) (BudgiePlugin*, const gchar*)) icon_tasklist_real_get_panel_widget;
}

static void
icon_tasklist_instance_init (IconTasklist * self,
                             gpointer klass)
{
}

GType
icon_tasklist_get_type (void)
{
	return icon_tasklist_type_id;
}

GType
icon_tasklist_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (IconTasklistClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) icon_tasklist_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (IconTasklist), 0, (GInstanceInitFunc) icon_tasklist_instance_init, NULL };
	static const GInterfaceInfo budgie_plugin_info = { (GInterfaceInitFunc) icon_tasklist_budgie_plugin_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	icon_tasklist_type_id = g_type_module_register_type (module, peas_extension_base_get_type (), "IconTasklist", &g_define_type_info, 0);
	g_type_module_add_interface (module, icon_tasklist_type_id, budgie_plugin_get_type (), &budgie_plugin_info);
	return icon_tasklist_type_id;
}

static inline gpointer
icon_tasklist_settings_get_instance_private (IconTasklistSettings* self)
{
	return G_STRUCT_MEMBER_P (self, IconTasklistSettings_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

IconTasklistSettings*
icon_tasklist_settings_construct (GType object_type,
                                  GSettings* settings)
{
	IconTasklistSettings * self = NULL;
	GSettings* _tmp0_;
	GtkSwitch* _tmp1_;
	GtkSwitch* _tmp2_;
	GtkSwitch* _tmp3_;
	GtkSwitch* _tmp4_;
	GtkSwitch* _tmp5_;
	GtkSwitch* _tmp6_;
	GtkSwitch* _tmp7_;
	self = (IconTasklistSettings*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (settings);
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp1_ = self->priv->switch_grouping;
	g_settings_bind (settings, "grouping", (GObject*) _tmp1_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp2_ = self->priv->switch_restrict;
	g_settings_bind (settings, "restrict-to-workspace", (GObject*) _tmp2_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp3_ = self->priv->switch_lock_icons;
	g_settings_bind (settings, "lock-icons", (GObject*) _tmp3_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp4_ = self->priv->switch_only_pinned;
	g_settings_bind (settings, "only-pinned", (GObject*) _tmp4_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp5_ = self->priv->show_all_on_click;
	g_settings_bind (settings, "show-all-windows-on-click", (GObject*) _tmp5_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp6_ = self->priv->switch_middle_click_create_new_instance;
	g_settings_bind (settings, "middle-click-launch-new-instance", (GObject*) _tmp6_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp7_ = self->priv->switch_require_double_click_to_launch_new_instance;
	g_settings_bind (settings, "require-double-click-to-launch", (GObject*) _tmp7_, "active", G_SETTINGS_BIND_DEFAULT);
	return self;
}

IconTasklistSettings*
icon_tasklist_settings_new (GSettings* settings)
{
	return icon_tasklist_settings_construct (TYPE_ICON_TASKLIST_SETTINGS, settings);
}

static void
icon_tasklist_settings_class_init (IconTasklistSettingsClass * klass,
                                   gpointer klass_data)
{
	icon_tasklist_settings_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &IconTasklistSettings_private_offset);
	G_OBJECT_CLASS (klass)->finalize = icon_tasklist_settings_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/com/solus-project/icon-tasklist/settings.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "switch_grouping", FALSE, IconTasklistSettings_private_offset + G_STRUCT_OFFSET (IconTasklistSettingsPrivate, switch_grouping));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "switch_restrict", FALSE, IconTasklistSettings_private_offset + G_STRUCT_OFFSET (IconTasklistSettingsPrivate, switch_restrict));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "switch_lock_icons", FALSE, IconTasklistSettings_private_offset + G_STRUCT_OFFSET (IconTasklistSettingsPrivate, switch_lock_icons));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "switch_only_pinned", FALSE, IconTasklistSettings_private_offset + G_STRUCT_OFFSET (IconTasklistSettingsPrivate, switch_only_pinned));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "show_all_on_click", FALSE, IconTasklistSettings_private_offset + G_STRUCT_OFFSET (IconTasklistSettingsPrivate, show_all_on_click));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "switch_middle_click_create_new_instance", FALSE, IconTasklistSettings_private_offset + G_STRUCT_OFFSET (IconTasklistSettingsPrivate, switch_middle_click_create_new_instance));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "switch_require_double_click_to_launch_new_instance", FALSE, IconTasklistSettings_private_offset + G_STRUCT_OFFSET (IconTasklistSettingsPrivate, switch_require_double_click_to_launch_new_instance));
}

static void
icon_tasklist_settings_instance_init (IconTasklistSettings * self,
                                      gpointer klass)
{
	self->priv = icon_tasklist_settings_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
icon_tasklist_settings_finalize (GObject * obj)
{
	IconTasklistSettings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ICON_TASKLIST_SETTINGS, IconTasklistSettings);
	_g_object_unref0 (self->priv->settings);
	G_OBJECT_CLASS (icon_tasklist_settings_parent_class)->finalize (obj);
}

GType
icon_tasklist_settings_get_type (void)
{
	return icon_tasklist_settings_type_id;
}

GType
icon_tasklist_settings_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (IconTasklistSettingsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) icon_tasklist_settings_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (IconTasklistSettings), 0, (GInstanceInitFunc) icon_tasklist_settings_instance_init, NULL };
	icon_tasklist_settings_type_id = g_type_module_register_type (module, gtk_grid_get_type (), "IconTasklistSettings", &g_define_type_info, 0);
	IconTasklistSettings_private_offset = sizeof (IconTasklistSettingsPrivate);
	return icon_tasklist_settings_type_id;
}

static inline gpointer
icon_tasklist_applet_get_instance_private (IconTasklistApplet* self)
{
	return G_STRUCT_MEMBER_P (self, IconTasklistApplet_private_offset);
}

static GtkWidget*
icon_tasklist_applet_real_get_settings_ui (BudgieApplet* base)
{
	IconTasklistApplet * self;
	const gchar* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	IconTasklistSettings* _tmp3_;
	GtkWidget* _tmp4_;
	GtkWidget* result;
	self = (IconTasklistApplet*) base;
	_tmp0_ = self->priv->_uuid;
	_tmp1_ = budgie_applet_get_applet_settings ((BudgieApplet*) self, _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = icon_tasklist_settings_new (_tmp2_);
	g_object_ref_sink (_tmp3_);
	_tmp4_ = (GtkWidget*) _tmp3_;
	_g_object_unref0 (_tmp2_);
	result = _tmp4_;
	return result;
}

static gboolean
icon_tasklist_applet_real_supports_settings (BudgieApplet* base)
{
	IconTasklistApplet * self;
	gboolean result;
	self = (IconTasklistApplet*) base;
	result = TRUE;
	return result;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static void
_icon_tasklist_applet_on_settings_changed_g_settings_changed (GSettings* _sender,
                                                              const gchar* key,
                                                              gpointer self)
{
	icon_tasklist_applet_on_settings_changed ((IconTasklistApplet*) self, key);
}

static void
_icon_tasklist_applet_on_drag_data_received_gtk_widget_drag_data_received (GtkWidget* _sender,
                                                                           GdkDragContext* context,
                                                                           gint x,
                                                                           gint y,
                                                                           GtkSelectionData* selection_data,
                                                                           guint info,
                                                                           guint time_,
                                                                           gpointer self)
{
	icon_tasklist_applet_on_drag_data_received ((IconTasklistApplet*) self, _sender, context, x, y, selection_data, info, time_);
}

IconTasklistApplet*
icon_tasklist_applet_construct (GType object_type,
                                const gchar* uuid)
{
	IconTasklistApplet * self = NULL;
	GSettings* _tmp0_;
	GHashFunc _tmp1_;
	GEqualFunc _tmp2_;
	GHashTable* _tmp3_;
	GtkBox* _tmp4_;
	GSettings* _tmp5_;
	GtkBox* _tmp6_;
	DesktopHelper* _tmp7_;
	WnckScreen* _tmp8_;
	WnckScreen* _tmp9_;
	BudgieAbominationAbomination* _tmp10_;
	BudgieAppSystem* _tmp11_;
	GSettings* _tmp12_;
	GtkBox* _tmp13_;
	GtkBox* _tmp14_;
	GtkBox* _tmp15_;
	GtkStyleContext* _tmp16_;
	g_return_val_if_fail (uuid != NULL, NULL);
	self = (IconTasklistApplet*) g_object_new (object_type, "uuid", uuid, NULL);
	budgie_applet_set_settings_schema ((BudgieApplet*) self, "com.solus-project.icon-tasklist");
	budgie_applet_set_settings_prefix ((BudgieApplet*) self, "/com/solus-project/budgie-panel/instance/icon-tasklist");
	_tmp0_ = budgie_applet_get_applet_settings ((BudgieApplet*) self, uuid);
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp1_ = g_str_hash;
	_tmp2_ = g_str_equal;
	_tmp3_ = g_hash_table_new_full (_tmp1_, _tmp2_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->buttons);
	self->priv->buttons = _tmp3_;
	_tmp4_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->main_layout);
	self->priv->main_layout = _tmp4_;
	_tmp5_ = self->priv->settings;
	_tmp6_ = self->priv->main_layout;
	_tmp7_ = desktop_helper_new (_tmp5_, _tmp6_);
	_g_object_unref0 (self->priv->desktop_helper);
	self->priv->desktop_helper = _tmp7_;
	_tmp8_ = wnck_screen_get_default ();
	_tmp9_ = _g_object_ref0 (_tmp8_);
	_g_object_unref0 (self->priv->wnck_screen);
	self->priv->wnck_screen = _tmp9_;
	_tmp10_ = budgie_abomination_abomination_new ();
	_g_object_unref0 (self->priv->abomination);
	self->priv->abomination = _tmp10_;
	_tmp11_ = budgie_app_system_new ();
	_g_object_unref0 (self->priv->app_system);
	self->priv->app_system = _tmp11_;
	_tmp12_ = self->priv->settings;
	g_signal_connect_object (_tmp12_, "changed", (GCallback) _icon_tasklist_applet_on_settings_changed_g_settings_changed, self, 0);
	_tmp13_ = self->priv->main_layout;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp13_);
	_tmp14_ = self->priv->main_layout;
	gtk_drag_dest_set ((GtkWidget*) _tmp14_, GTK_DEST_DEFAULT_ALL, DESKTOP_HELPER_targets, (gint) G_N_ELEMENTS (DESKTOP_HELPER_targets), GDK_ACTION_COPY);
	_tmp15_ = self->priv->main_layout;
	g_signal_connect_object ((GtkWidget*) _tmp15_, "drag-data-received", (GCallback) _icon_tasklist_applet_on_drag_data_received_gtk_widget_drag_data_received, self, 0);
	icon_tasklist_applet_on_settings_changed (self, "grouping");
	icon_tasklist_applet_on_settings_changed (self, "restrict-to-workspace");
	icon_tasklist_applet_on_settings_changed (self, "lock-icons");
	icon_tasklist_applet_on_settings_changed (self, "only-pinned");
	icon_tasklist_applet_connect_app_signals (self);
	icon_tasklist_applet_on_active_window_changed (self);
	_tmp16_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp16_, "icon-tasklist");
	gtk_widget_show_all ((GtkWidget*) self);
	return self;
}

IconTasklistApplet*
icon_tasklist_applet_new (const gchar* uuid)
{
	return icon_tasklist_applet_construct (TYPE_ICON_TASKLIST_APPLET, uuid);
}

/**
 * Add IconButton for pinned apps
 */
static void
icon_tasklist_applet_startup (IconTasklistApplet* self)
{
	gchar** pinned = NULL;
	GSettings* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint pinned_length1;
	gint _pinned_size_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	_tmp2_ = _tmp1_ = g_settings_get_strv (_tmp0_, "pinned-launchers");
	pinned = _tmp2_;
	pinned_length1 = _vala_array_length (_tmp1_);
	_pinned_size_ = pinned_length1;
	_tmp3_ = pinned;
	_tmp3__length1 = pinned_length1;
	{
		gchar** launcher_collection = NULL;
		gint launcher_collection_length1 = 0;
		gint _launcher_collection_size_ = 0;
		gint launcher_it = 0;
		launcher_collection = _tmp3_;
		launcher_collection_length1 = _tmp3__length1;
		for (launcher_it = 0; launcher_it < launcher_collection_length1; launcher_it = launcher_it + 1) {
			gchar* _tmp4_;
			gchar* launcher = NULL;
			_tmp4_ = g_strdup (launcher_collection[launcher_it]);
			launcher = _tmp4_;
			{
				GDesktopAppInfo* info = NULL;
				const gchar* _tmp5_;
				GDesktopAppInfo* _tmp6_;
				GDesktopAppInfo* _tmp7_;
				IconButton* button = NULL;
				BudgieAbominationAbomination* _tmp8_;
				BudgieAppSystem* _tmp9_;
				GSettings* _tmp10_;
				DesktopHelper* _tmp11_;
				BudgiePopoverManager* _tmp12_;
				GDesktopAppInfo* _tmp13_;
				const gchar* _tmp14_;
				IconButton* _tmp15_;
				const gchar* _tmp16_;
				IconButton* _tmp17_;
				_tmp5_ = launcher;
				_tmp6_ = g_desktop_app_info_new (_tmp5_);
				info = _tmp6_;
				_tmp7_ = info;
				if (_tmp7_ == NULL) {
					_g_object_unref0 (info);
					_g_free0 (launcher);
					continue;
				}
				_tmp8_ = self->priv->abomination;
				_tmp9_ = self->priv->app_system;
				_tmp10_ = self->priv->settings;
				_tmp11_ = self->priv->desktop_helper;
				_tmp12_ = self->priv->manager;
				_tmp13_ = info;
				_tmp14_ = launcher;
				_tmp15_ = icon_button_new (_tmp8_, _tmp9_, _tmp10_, _tmp11_, _tmp12_, _tmp13_, _tmp14_);
				g_object_ref_sink (_tmp15_);
				button = _tmp15_;
				_tmp16_ = launcher;
				_tmp17_ = button;
				icon_tasklist_applet_add_icon_button (self, _tmp16_, _tmp17_);
				_g_object_unref0 (button);
				_g_object_unref0 (info);
				_g_free0 (launcher);
			}
		}
	}
	pinned = (_vala_array_free (pinned, pinned_length1, (GDestroyNotify) g_free), NULL);
}

static void
_icon_tasklist_applet_on_active_window_changed_wnck_screen_active_window_changed (WnckScreen* _sender,
                                                                                  WnckWindow* previous_window,
                                                                                  gpointer self)
{
	icon_tasklist_applet_on_active_window_changed ((IconTasklistApplet*) self);
}

static void
_icon_tasklist_applet_update_buttons_wnck_screen_active_workspace_changed (WnckScreen* _sender,
                                                                           WnckWorkspace* previous_workspace,
                                                                           gpointer self)
{
	icon_tasklist_applet_update_buttons ((IconTasklistApplet*) self);
}

static void
__lambda51_ (IconTasklistApplet* self,
             const gchar* group,
             BudgieAbominationRunningApp* app)
{
	g_return_if_fail (group != NULL);
	g_return_if_fail (app != NULL);
	icon_tasklist_applet_on_app_opened (self, app);
}

static void
___lambda51__budgie_abomination_abomination_added_app (BudgieAbominationAbomination* _sender,
                                                       const gchar* group,
                                                       BudgieAbominationRunningApp* app,
                                                       gpointer self)
{
	__lambda51_ ((IconTasklistApplet*) self, group, app);
}

static void
__lambda52_ (IconTasklistApplet* self,
             const gchar* group,
             BudgieAbominationRunningApp* app)
{
	g_return_if_fail (group != NULL);
	g_return_if_fail (app != NULL);
	icon_tasklist_applet_on_app_closed (self, app);
}

static void
___lambda52__budgie_abomination_abomination_removed_app (BudgieAbominationAbomination* _sender,
                                                         const gchar* group,
                                                         BudgieAbominationRunningApp* app,
                                                         gpointer self)
{
	__lambda52_ ((IconTasklistApplet*) self, group, app);
}

static void
__lambda53_ (IconTasklistApplet* self,
             BudgieAbominationAppGroup* group)
{
	WnckWindow* window = NULL;
	GList* _tmp0_;
	GList* _tmp1_;
	gconstpointer _tmp2_;
	WnckWindow* _tmp3_;
	WnckWindow* _tmp4_;
	WnckWindow* _tmp5_;
	BudgieAbominationRunningApp* app = NULL;
	BudgieAbominationAbomination* _tmp6_;
	WnckWindow* _tmp7_;
	BudgieAbominationRunningApp* _tmp8_;
	BudgieAbominationRunningApp* _tmp9_;
	IconButton* button = NULL;
	GHashTable* _tmp10_;
	WnckWindow* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gconstpointer _tmp14_;
	IconButton* _tmp15_;
	IconButton* _tmp16_;
	gboolean _tmp17_ = FALSE;
	IconButton* _tmp18_;
	IconButton* _tmp32_;
	ButtonWrapper* wrapper = NULL;
	IconButton* _tmp33_;
	GtkContainer* _tmp34_;
	ButtonWrapper* _tmp35_;
	ButtonWrapper* _tmp36_;
	IconButton* _tmp37_;
	WnckWindow* _tmp42_;
	gchar* _tmp43_;
	gchar* _tmp44_;
	BudgieAbominationRunningApp* _tmp45_;
	g_return_if_fail (group != NULL);
	_tmp0_ = budgie_abomination_app_group_get_windows (group);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_list_nth_data (_tmp1_, (guint) 0);
	_tmp3_ = _g_object_ref0 ((WnckWindow*) _tmp2_);
	_tmp4_ = _tmp3_;
	(_tmp1_ == NULL) ? NULL : (_tmp1_ = (g_list_free (_tmp1_), NULL));
	window = _tmp4_;
	_tmp5_ = window;
	if (_tmp5_ == NULL) {
		_g_object_unref0 (window);
		return;
	}
	_tmp6_ = self->priv->abomination;
	_tmp7_ = window;
	_tmp8_ = budgie_abomination_abomination_get_app_from_window_id (_tmp6_, wnck_window_get_xid (_tmp7_));
	app = _tmp8_;
	_tmp9_ = app;
	if (_tmp9_ == NULL) {
		_g_object_unref0 (app);
		_g_object_unref0 (window);
		return;
	}
	_tmp10_ = self->priv->buttons;
	_tmp11_ = window;
	_tmp12_ = g_strdup_printf ("%lu", wnck_window_get_xid (_tmp11_));
	_tmp13_ = _tmp12_;
	_tmp14_ = g_hash_table_lookup (_tmp10_, _tmp13_);
	_tmp15_ = _g_object_ref0 ((IconButton*) _tmp14_);
	_tmp16_ = _tmp15_;
	_g_free0 (_tmp13_);
	button = _tmp16_;
	_tmp18_ = button;
	if (_tmp18_ == NULL) {
		BudgieAbominationRunningApp* _tmp19_;
		GDesktopAppInfo* _tmp20_;
		GDesktopAppInfo* _tmp21_;
		_tmp19_ = app;
		_tmp20_ = budgie_abomination_running_app_get_app_info (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp17_ = _tmp21_ != NULL;
	} else {
		_tmp17_ = FALSE;
	}
	if (_tmp17_) {
		gchar* launcher = NULL;
		DesktopHelper* _tmp22_;
		BudgieAbominationRunningApp* _tmp23_;
		GDesktopAppInfo* _tmp24_;
		GDesktopAppInfo* _tmp25_;
		const gchar* _tmp26_;
		gchar* _tmp27_;
		GHashTable* _tmp28_;
		const gchar* _tmp29_;
		gconstpointer _tmp30_;
		IconButton* _tmp31_;
		_tmp22_ = self->priv->desktop_helper;
		_tmp23_ = app;
		_tmp24_ = budgie_abomination_running_app_get_app_info (_tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = g_desktop_app_info_get_filename (_tmp25_);
		_tmp27_ = desktop_helper_get_app_launcher (_tmp22_, _tmp26_);
		launcher = _tmp27_;
		_tmp28_ = self->priv->buttons;
		_tmp29_ = launcher;
		_tmp30_ = g_hash_table_lookup (_tmp28_, _tmp29_);
		_tmp31_ = _g_object_ref0 ((IconButton*) _tmp30_);
		_g_object_unref0 (button);
		button = _tmp31_;
		_g_free0 (launcher);
	}
	_tmp32_ = button;
	if (_tmp32_ == NULL) {
		_g_object_unref0 (button);
		_g_object_unref0 (app);
		_g_object_unref0 (window);
		return;
	}
	_tmp33_ = button;
	_tmp34_ = gtk_widget_get_parent ((GtkWidget*) _tmp33_);
	_tmp35_ = _g_object_ref0 (IS_BUTTON_WRAPPER (_tmp34_) ? ((ButtonWrapper*) _tmp34_) : NULL);
	wrapper = _tmp35_;
	_tmp36_ = wrapper;
	if (_tmp36_ == NULL) {
		_g_object_unref0 (wrapper);
		_g_object_unref0 (button);
		_g_object_unref0 (app);
		_g_object_unref0 (window);
		return;
	}
	_tmp37_ = button;
	if (!_tmp37_->pinned) {
		ButtonWrapper* _tmp38_;
		_tmp38_ = wrapper;
		button_wrapper_gracefully_die (_tmp38_);
	} else {
		IconButton* _tmp39_;
		IconButton* _tmp40_;
		IconButton* _tmp41_;
		_tmp39_ = button;
		icon_button_set_class_group (_tmp39_, NULL);
		_tmp40_ = button;
		_g_object_unref0 (_tmp40_->first_app);
		_tmp40_->first_app = NULL;
		_tmp41_ = button;
		icon_button_update (_tmp41_);
	}
	_tmp42_ = window;
	_tmp43_ = g_strdup_printf ("%lu", wnck_window_get_xid (_tmp42_));
	_tmp44_ = _tmp43_;
	icon_tasklist_applet_remove_button (self, _tmp44_);
	_g_free0 (_tmp44_);
	_tmp45_ = app;
	icon_tasklist_applet_on_app_opened (self, _tmp45_);
	_g_object_unref0 (wrapper);
	_g_object_unref0 (button);
	_g_object_unref0 (app);
	_g_object_unref0 (window);
}

static void
___lambda53__budgie_abomination_abomination_updated_group (BudgieAbominationAbomination* _sender,
                                                           BudgieAbominationAppGroup* group,
                                                           gpointer self)
{
	__lambda53_ ((IconTasklistApplet*) self, group);
}

static void
icon_tasklist_applet_connect_app_signals (IconTasklistApplet* self)
{
	WnckScreen* _tmp0_;
	WnckScreen* _tmp1_;
	BudgieAbominationAbomination* _tmp2_;
	BudgieAbominationAbomination* _tmp3_;
	BudgieAbominationAbomination* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->wnck_screen;
	g_signal_connect_object (_tmp0_, "active-window-changed", (GCallback) _icon_tasklist_applet_on_active_window_changed_wnck_screen_active_window_changed, self, G_CONNECT_AFTER);
	_tmp1_ = self->priv->wnck_screen;
	g_signal_connect_object (_tmp1_, "active-workspace-changed", (GCallback) _icon_tasklist_applet_update_buttons_wnck_screen_active_workspace_changed, self, G_CONNECT_AFTER);
	_tmp2_ = self->priv->abomination;
	g_signal_connect_object (_tmp2_, "added-app", (GCallback) ___lambda51__budgie_abomination_abomination_added_app, self, 0);
	_tmp3_ = self->priv->abomination;
	g_signal_connect_object (_tmp3_, "removed-app", (GCallback) ___lambda52__budgie_abomination_abomination_removed_app, self, 0);
	if (!self->priv->grouping) {
		return;
	}
	_tmp4_ = self->priv->abomination;
	g_signal_connect_object (_tmp4_, "updated-group", (GCallback) ___lambda53__budgie_abomination_abomination_updated_group, self, 0);
}

/**
 * Remove every IconButton and add them back
 */
static void
_icon_tasklist_applet_on_app_opened_gfunc (gconstpointer data,
                                           gpointer self)
{
	icon_tasklist_applet_on_app_opened ((IconTasklistApplet*) self, (BudgieAbominationRunningApp*) data);
}

static void
icon_tasklist_applet_rebuild_items (IconTasklistApplet* self)
{
	GtkBox* _tmp0_;
	GList* _tmp1_;
	GHashTable* _tmp4_;
	BudgieAbominationAbomination* _tmp5_;
	GList* _tmp6_;
	GList* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->main_layout;
	_tmp1_ = gtk_container_get_children ((GtkContainer*) _tmp0_);
	{
		GList* widget_collection = NULL;
		GList* widget_it = NULL;
		widget_collection = _tmp1_;
		for (widget_it = widget_collection; widget_it != NULL; widget_it = widget_it->next) {
			GtkWidget* _tmp2_;
			GtkWidget* widget = NULL;
			_tmp2_ = _g_object_ref0 ((GtkWidget*) widget_it->data);
			widget = _tmp2_;
			{
				GtkWidget* _tmp3_;
				_tmp3_ = widget;
				gtk_widget_destroy (_tmp3_);
				_g_object_unref0 (widget);
			}
		}
		(widget_collection == NULL) ? NULL : (widget_collection = (g_list_free (widget_collection), NULL));
	}
	_tmp4_ = self->priv->buttons;
	g_hash_table_remove_all (_tmp4_);
	icon_tasklist_applet_startup (self);
	_tmp5_ = self->priv->abomination;
	_tmp6_ = budgie_abomination_abomination_get_running_apps (_tmp5_);
	_tmp7_ = _tmp6_;
	g_list_foreach (_tmp7_, _icon_tasklist_applet_on_app_opened_gfunc, self);
	(_tmp7_ == NULL) ? NULL : (_tmp7_ = (g_list_free (_tmp7_), NULL));
}

static gboolean
___lambda47_ (IconTasklistApplet* self)
{
	gboolean result;
	icon_tasklist_applet_rebuild_items (self);
	result = FALSE;
	return result;
}

static gboolean
____lambda47__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda47_ ((IconTasklistApplet*) self);
	return result;
}

static void
icon_tasklist_applet_on_settings_changed (IconTasklistApplet* self,
                                          const gchar* key)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = key;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("grouping")))) {
		switch (0) {
			default:
			{
				GSettings* _tmp3_;
				_tmp3_ = self->priv->settings;
				self->priv->grouping = g_settings_get_boolean (_tmp3_, key);
				g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda47__gsource_func, g_object_ref (self), g_object_unref);
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("lock-icons")))) {
		switch (0) {
			default:
			{
				DesktopHelper* _tmp4_;
				GSettings* _tmp5_;
				_tmp4_ = self->priv->desktop_helper;
				_tmp5_ = self->priv->settings;
				_tmp4_->lock_icons = g_settings_get_boolean (_tmp5_, key);
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("restrict-to-workspace")))) {
		switch (0) {
			default:
			{
				GSettings* _tmp6_;
				_tmp6_ = self->priv->settings;
				self->priv->restrict_to_workspace = g_settings_get_boolean (_tmp6_, key);
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("only-pinned")))) {
		switch (0) {
			default:
			{
				GSettings* _tmp7_;
				_tmp7_ = self->priv->settings;
				self->priv->only_show_pinned = g_settings_get_boolean (_tmp7_, key);
				break;
			}
		}
	}
	if (g_strcmp0 (key, "grouping") != 0) {
		icon_tasklist_applet_update_buttons (self);
	}
}

static void
__lambda50_ (IconTasklistApplet* self,
             const gchar* id,
             IconButton* button)
{
	g_return_if_fail (id != NULL);
	g_return_if_fail (button != NULL);
	icon_tasklist_applet_update_button (self, button);
}

static void
___lambda50__gh_func (gconstpointer key,
                      gconstpointer value,
                      gpointer self)
{
	__lambda50_ ((IconTasklistApplet*) self, (const gchar*) key, (IconButton*) value);
}

static void
icon_tasklist_applet_update_buttons (IconTasklistApplet* self)
{
	GHashTable* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->buttons;
	g_hash_table_foreach (_tmp0_, ___lambda50__gh_func, self);
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
icon_tasklist_applet_on_drag_data_received (IconTasklistApplet* self,
                                            GtkWidget* widget,
                                            GdkDragContext* context,
                                            gint x,
                                            gint y,
                                            GtkSelectionData* selection_data,
                                            guint item,
                                            guint time)
{
	gchar* app_id = NULL;
	guint8* _tmp0_;
	gchar* _tmp1_;
	ButtonWrapper* original_button = NULL;
	const gchar* _tmp2_;
	ButtonWrapper* _tmp53_;
	GtkBox* _tmp54_;
	GList* _tmp55_;
	ButtonWrapper* _tmp91_;
	ButtonWrapper* _tmp92_;
	DesktopHelper* _tmp93_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (selection_data != NULL);
	if (item != ((guint) 0)) {
		g_message ("IconTasklistApplet.vala:242: Invalid target type");
		return;
	}
	_tmp0_ = gtk_selection_data_get_data (selection_data);
	_tmp1_ = g_strdup ((const gchar*) _tmp0_);
	app_id = _tmp1_;
	original_button = NULL;
	_tmp2_ = app_id;
	if (g_str_has_prefix (_tmp2_, "file://")) {
		const gchar* _tmp3_;
		gchar** _tmp4_;
		gchar** _tmp5_;
		gchar** _tmp6_;
		gint _tmp6__length1;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		GDesktopAppInfo* info = NULL;
		const gchar* _tmp11_;
		GDesktopAppInfo* _tmp12_;
		GDesktopAppInfo* _tmp13_;
		GDesktopAppInfo* _tmp14_;
		const gchar* _tmp15_;
		gchar* launcher = NULL;
		DesktopHelper* _tmp16_;
		const gchar* _tmp17_;
		gchar* _tmp18_;
		GHashTable* _tmp19_;
		const gchar* _tmp20_;
		_tmp3_ = app_id;
		_tmp5_ = _tmp4_ = g_strsplit (_tmp3_, "://", 0);
		_tmp6_ = _tmp5_;
		_tmp6__length1 = _vala_array_length (_tmp4_);
		_tmp7_ = _tmp6_[1];
		_tmp8_ = g_strdup (_tmp7_);
		_g_free0 (app_id);
		app_id = _tmp8_;
		_tmp6_ = (_vala_array_free (_tmp6_, _tmp6__length1, (GDestroyNotify) g_free), NULL);
		_tmp9_ = app_id;
		_tmp10_ = string_strip (_tmp9_);
		_g_free0 (app_id);
		app_id = _tmp10_;
		_tmp11_ = app_id;
		_tmp12_ = g_desktop_app_info_new_from_filename (_tmp11_);
		info = _tmp12_;
		_tmp13_ = info;
		if (_tmp13_ == NULL) {
			_g_object_unref0 (info);
			_g_object_unref0 (original_button);
			_g_free0 (app_id);
			return;
		}
		_tmp14_ = info;
		_tmp15_ = g_desktop_app_info_get_startup_wm_class (_tmp14_);
		if (g_strcmp0 (_tmp15_, "budgie-desktop-settings") == 0) {
			_g_object_unref0 (info);
			_g_object_unref0 (original_button);
			_g_free0 (app_id);
			return;
		}
		_tmp16_ = self->priv->desktop_helper;
		_tmp17_ = app_id;
		_tmp18_ = desktop_helper_get_app_launcher (_tmp16_, _tmp17_);
		launcher = _tmp18_;
		_tmp19_ = self->priv->buttons;
		_tmp20_ = launcher;
		if (g_hash_table_contains (_tmp19_, _tmp20_)) {
			GHashTable* _tmp21_;
			const gchar* _tmp22_;
			gconstpointer _tmp23_;
			GtkContainer* _tmp24_;
			ButtonWrapper* _tmp25_;
			_tmp21_ = self->priv->buttons;
			_tmp22_ = launcher;
			_tmp23_ = g_hash_table_lookup (_tmp21_, _tmp22_);
			_tmp24_ = gtk_widget_get_parent ((GtkWidget*) ((IconButton*) _tmp23_));
			_tmp25_ = _g_object_ref0 (IS_BUTTON_WRAPPER (_tmp24_) ? ((ButtonWrapper*) _tmp24_) : NULL);
			_g_object_unref0 (original_button);
			original_button = _tmp25_;
		} else {
			IconButton* button = NULL;
			BudgieAbominationAbomination* _tmp26_;
			BudgieAppSystem* _tmp27_;
			GSettings* _tmp28_;
			DesktopHelper* _tmp29_;
			BudgiePopoverManager* _tmp30_;
			GDesktopAppInfo* _tmp31_;
			const gchar* _tmp32_;
			IconButton* _tmp33_;
			const gchar* _tmp34_;
			IconButton* _tmp35_;
			IconButton* _tmp36_;
			GtkContainer* _tmp37_;
			ButtonWrapper* _tmp38_;
			_tmp26_ = self->priv->abomination;
			_tmp27_ = self->priv->app_system;
			_tmp28_ = self->priv->settings;
			_tmp29_ = self->priv->desktop_helper;
			_tmp30_ = self->priv->manager;
			_tmp31_ = info;
			_tmp32_ = launcher;
			_tmp33_ = icon_button_new (_tmp26_, _tmp27_, _tmp28_, _tmp29_, _tmp30_, _tmp31_, _tmp32_);
			g_object_ref_sink (_tmp33_);
			button = _tmp33_;
			_tmp34_ = launcher;
			_tmp35_ = button;
			icon_tasklist_applet_add_icon_button (self, _tmp34_, _tmp35_);
			_tmp36_ = button;
			_tmp37_ = gtk_widget_get_parent ((GtkWidget*) _tmp36_);
			_tmp38_ = _g_object_ref0 (IS_BUTTON_WRAPPER (_tmp37_) ? ((ButtonWrapper*) _tmp37_) : NULL);
			_g_object_unref0 (original_button);
			original_button = _tmp38_;
			_g_object_unref0 (button);
		}
		_g_free0 (launcher);
		_g_object_unref0 (info);
	} else {
		IconButton* button = NULL;
		gchar* app_id_without_desktop_suffix = NULL;
		const gchar* _tmp39_;
		gchar* _tmp40_;
		GHashTable* _tmp41_;
		const gchar* _tmp42_;
		IconButton* _tmp49_;
		button = NULL;
		_tmp39_ = app_id;
		_tmp40_ = string_replace (_tmp39_, ".desktop", "");
		app_id_without_desktop_suffix = _tmp40_;
		_tmp41_ = self->priv->buttons;
		_tmp42_ = app_id;
		if (g_hash_table_contains (_tmp41_, _tmp42_)) {
			GHashTable* _tmp43_;
			const gchar* _tmp44_;
			gconstpointer _tmp45_;
			_tmp43_ = self->priv->buttons;
			_tmp44_ = app_id;
			_tmp45_ = g_hash_table_lookup (_tmp43_, _tmp44_);
			button = (IconButton*) _tmp45_;
		} else {
			GHashTable* _tmp46_;
			const gchar* _tmp47_;
			gconstpointer _tmp48_;
			_tmp46_ = self->priv->buttons;
			_tmp47_ = app_id_without_desktop_suffix;
			_tmp48_ = g_hash_table_lookup (_tmp46_, _tmp47_);
			button = (IconButton*) _tmp48_;
		}
		_tmp49_ = button;
		if (_tmp49_ != NULL) {
			IconButton* _tmp50_;
			GtkContainer* _tmp51_;
			ButtonWrapper* _tmp52_;
			_tmp50_ = button;
			_tmp51_ = gtk_widget_get_parent ((GtkWidget*) _tmp50_);
			_tmp52_ = _g_object_ref0 (IS_BUTTON_WRAPPER (_tmp51_) ? ((ButtonWrapper*) _tmp51_) : NULL);
			_g_object_unref0 (original_button);
			original_button = _tmp52_;
		}
		_g_free0 (app_id_without_desktop_suffix);
	}
	_tmp53_ = original_button;
	if (_tmp53_ == NULL) {
		_g_object_unref0 (original_button);
		_g_free0 (app_id);
		return;
	}
	_tmp54_ = self->priv->main_layout;
	_tmp55_ = gtk_container_get_children ((GtkContainer*) _tmp54_);
	{
		GList* widget1_collection = NULL;
		GList* widget1_it = NULL;
		widget1_collection = _tmp55_;
		for (widget1_it = widget1_collection; widget1_it != NULL; widget1_it = widget1_it->next) {
			GtkWidget* _tmp56_;
			GtkWidget* widget1 = NULL;
			_tmp56_ = _g_object_ref0 ((GtkWidget*) widget1_it->data);
			widget1 = _tmp56_;
			{
				ButtonWrapper* current_button = NULL;
				GtkWidget* _tmp57_;
				ButtonWrapper* _tmp58_;
				GtkAllocation alloc = {0};
				ButtonWrapper* _tmp59_;
				GtkAllocation _tmp60_ = {0};
				gboolean _tmp61_ = FALSE;
				gboolean _tmp62_ = FALSE;
				gboolean _tmp76_ = FALSE;
				gboolean _tmp77_ = FALSE;
				_tmp57_ = widget1;
				_tmp58_ = _g_object_ref0 (IS_BUTTON_WRAPPER (_tmp57_) ? ((ButtonWrapper*) _tmp57_) : NULL);
				current_button = _tmp58_;
				_tmp59_ = current_button;
				gtk_widget_get_allocation ((GtkWidget*) _tmp59_, &_tmp60_);
				alloc = _tmp60_;
				if (icon_tasklist_applet_get_orientation (self) == GTK_ORIENTATION_HORIZONTAL) {
					GtkAllocation _tmp63_;
					GtkAllocation _tmp64_;
					_tmp63_ = alloc;
					_tmp64_ = alloc;
					_tmp62_ = x <= (_tmp63_.x + (_tmp64_.width / 2));
				} else {
					_tmp62_ = FALSE;
				}
				if (_tmp62_) {
					_tmp61_ = TRUE;
				} else {
					gboolean _tmp65_ = FALSE;
					if (icon_tasklist_applet_get_orientation (self) == GTK_ORIENTATION_VERTICAL) {
						GtkAllocation _tmp66_;
						GtkAllocation _tmp67_;
						_tmp66_ = alloc;
						_tmp67_ = alloc;
						_tmp65_ = y <= (_tmp66_.y + (_tmp67_.height / 2));
					} else {
						_tmp65_ = FALSE;
					}
					_tmp61_ = _tmp65_;
				}
				if (_tmp61_) {
					gint new_position = 0;
					gint old_position = 0;
					GtkBox* _tmp68_;
					ButtonWrapper* _tmp69_;
					gint _tmp70_ = 0;
					GtkBox* _tmp71_;
					ButtonWrapper* _tmp72_;
					gint _tmp73_ = 0;
					GtkBox* _tmp74_;
					ButtonWrapper* _tmp75_;
					_tmp68_ = self->priv->main_layout;
					_tmp69_ = original_button;
					gtk_container_child_get ((GtkContainer*) _tmp68_, (GtkWidget*) _tmp69_, "position", &_tmp70_, NULL, NULL);
					old_position = _tmp70_;
					_tmp71_ = self->priv->main_layout;
					_tmp72_ = current_button;
					gtk_container_child_get ((GtkContainer*) _tmp71_, (GtkWidget*) _tmp72_, "position", &_tmp73_, NULL, NULL);
					new_position = _tmp73_;
					if (new_position == old_position) {
						_g_object_unref0 (current_button);
						_g_object_unref0 (widget1);
						break;
					}
					if (new_position == (old_position + 1)) {
						_g_object_unref0 (current_button);
						_g_object_unref0 (widget1);
						break;
					}
					if (new_position > old_position) {
						new_position = new_position - 1;
					}
					_tmp74_ = self->priv->main_layout;
					_tmp75_ = original_button;
					gtk_box_reorder_child (_tmp74_, (GtkWidget*) _tmp75_, new_position);
					_g_object_unref0 (current_button);
					_g_object_unref0 (widget1);
					break;
				}
				if (icon_tasklist_applet_get_orientation (self) == GTK_ORIENTATION_HORIZONTAL) {
					GtkAllocation _tmp78_;
					GtkAllocation _tmp79_;
					_tmp78_ = alloc;
					_tmp79_ = alloc;
					_tmp77_ = x <= (_tmp78_.x + _tmp79_.width);
				} else {
					_tmp77_ = FALSE;
				}
				if (_tmp77_) {
					_tmp76_ = TRUE;
				} else {
					gboolean _tmp80_ = FALSE;
					if (icon_tasklist_applet_get_orientation (self) == GTK_ORIENTATION_VERTICAL) {
						GtkAllocation _tmp81_;
						GtkAllocation _tmp82_;
						_tmp81_ = alloc;
						_tmp82_ = alloc;
						_tmp80_ = y <= (_tmp81_.y + _tmp82_.height);
					} else {
						_tmp80_ = FALSE;
					}
					_tmp76_ = _tmp80_;
				}
				if (_tmp76_) {
					gint new_position = 0;
					gint old_position = 0;
					GtkBox* _tmp83_;
					ButtonWrapper* _tmp84_;
					gint _tmp85_ = 0;
					GtkBox* _tmp86_;
					ButtonWrapper* _tmp87_;
					gint _tmp88_ = 0;
					GtkBox* _tmp89_;
					ButtonWrapper* _tmp90_;
					_tmp83_ = self->priv->main_layout;
					_tmp84_ = original_button;
					gtk_container_child_get ((GtkContainer*) _tmp83_, (GtkWidget*) _tmp84_, "position", &_tmp85_, NULL, NULL);
					old_position = _tmp85_;
					_tmp86_ = self->priv->main_layout;
					_tmp87_ = current_button;
					gtk_container_child_get ((GtkContainer*) _tmp86_, (GtkWidget*) _tmp87_, "position", &_tmp88_, NULL, NULL);
					new_position = _tmp88_;
					if (new_position == old_position) {
						_g_object_unref0 (current_button);
						_g_object_unref0 (widget1);
						break;
					}
					if (new_position == (old_position - 1)) {
						_g_object_unref0 (current_button);
						_g_object_unref0 (widget1);
						break;
					}
					if (new_position < old_position) {
						new_position = new_position + 1;
					}
					_tmp89_ = self->priv->main_layout;
					_tmp90_ = original_button;
					gtk_box_reorder_child (_tmp89_, (GtkWidget*) _tmp90_, new_position);
					_g_object_unref0 (current_button);
					_g_object_unref0 (widget1);
					break;
				}
				_g_object_unref0 (current_button);
				_g_object_unref0 (widget1);
			}
		}
		(widget1_collection == NULL) ? NULL : (widget1_collection = (g_list_free (widget1_collection), NULL));
	}
	_tmp91_ = original_button;
	gtk_revealer_set_transition_type ((GtkRevealer*) _tmp91_, GTK_REVEALER_TRANSITION_TYPE_NONE);
	_tmp92_ = original_button;
	gtk_revealer_set_reveal_child ((GtkRevealer*) _tmp92_, TRUE);
	_tmp93_ = self->priv->desktop_helper;
	desktop_helper_update_pinned (_tmp93_);
	gtk_drag_finish (context, TRUE, TRUE, (guint32) time);
	_g_object_unref0 (original_button);
	_g_free0 (app_id);
}

/**
 * on_app_opened handles when we open a new app
 */
static void
icon_tasklist_applet_on_app_opened (IconTasklistApplet* self,
                                    BudgieAbominationRunningApp* app)
{
	BudgieAbominationRunningApp* first_app = NULL;
	BudgieAbominationAbomination* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	BudgieAbominationRunningApp* _tmp3_;
	BudgieAbominationRunningApp* _tmp4_;
	BudgieAbominationRunningApp* _tmp5_;
	gchar* first_app_id = NULL;
	BudgieAbominationRunningApp* _tmp6_;
	gulong _tmp7_;
	gulong _tmp8_;
	gchar* _tmp9_;
	GDesktopAppInfo* _tmp10_;
	GDesktopAppInfo* _tmp11_;
	gboolean _tmp21_ = FALSE;
	GHashTable* _tmp22_;
	const gchar* _tmp23_;
	IconButton* button = NULL;
	GHashTable* _tmp37_;
	const gchar* _tmp38_;
	IconButton* _tmp51_;
	gboolean _tmp79_ = FALSE;
	gboolean _tmp85_ = FALSE;
	IconButton* _tmp90_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (app != NULL);
	_tmp0_ = self->priv->abomination;
	_tmp1_ = budgie_abomination_running_app_get_group_name (app);
	_tmp2_ = _tmp1_;
	_tmp3_ = budgie_abomination_abomination_get_first_app_of_group (_tmp0_, _tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	first_app = _tmp4_;
	_tmp5_ = first_app;
	if (_tmp5_ == NULL) {
		_g_object_unref0 (first_app);
		return;
	}
	_tmp6_ = first_app;
	_tmp7_ = budgie_abomination_running_app_get_id (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strdup_printf ("%lu", _tmp8_);
	first_app_id = _tmp9_;
	_tmp10_ = budgie_abomination_running_app_get_app_info (app);
	_tmp11_ = _tmp10_;
	if (_tmp11_ != NULL) {
		gchar* launcher = NULL;
		DesktopHelper* _tmp12_;
		GDesktopAppInfo* _tmp13_;
		GDesktopAppInfo* _tmp14_;
		const gchar* _tmp15_;
		gchar* _tmp16_;
		GHashTable* _tmp17_;
		const gchar* _tmp18_;
		_tmp12_ = self->priv->desktop_helper;
		_tmp13_ = budgie_abomination_running_app_get_app_info (app);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_desktop_app_info_get_filename (_tmp14_);
		_tmp16_ = desktop_helper_get_app_launcher (_tmp12_, _tmp15_);
		launcher = _tmp16_;
		_tmp17_ = self->priv->buttons;
		_tmp18_ = launcher;
		if (g_hash_table_contains (_tmp17_, _tmp18_)) {
			const gchar* _tmp19_;
			gchar* _tmp20_;
			_tmp19_ = launcher;
			_tmp20_ = g_strdup (_tmp19_);
			_g_free0 (first_app_id);
			first_app_id = _tmp20_;
		}
		_g_free0 (launcher);
	}
	_tmp22_ = self->priv->buttons;
	_tmp23_ = first_app_id;
	if (g_hash_table_contains (_tmp22_, _tmp23_)) {
		_tmp21_ = self->priv->grouping;
	} else {
		_tmp21_ = FALSE;
	}
	if (_tmp21_) {
		IconButton* first_button = NULL;
		GHashTable* _tmp24_;
		const gchar* _tmp25_;
		gconstpointer _tmp26_;
		IconButton* _tmp27_;
		gboolean _tmp28_ = FALSE;
		IconButton* _tmp29_;
		Icon* _tmp30_;
		_tmp24_ = self->priv->buttons;
		_tmp25_ = first_app_id;
		_tmp26_ = g_hash_table_lookup (_tmp24_, _tmp25_);
		_tmp27_ = _g_object_ref0 ((IconButton*) _tmp26_);
		first_button = _tmp27_;
		_tmp29_ = first_button;
		_tmp30_ = _tmp29_->icon;
		if (!_tmp30_->waiting) {
			IconButton* _tmp31_;
			Icon* _tmp32_;
			_tmp31_ = first_button;
			_tmp32_ = _tmp31_->icon;
			_tmp28_ = gtk_widget_get_realized ((GtkWidget*) _tmp32_);
		} else {
			_tmp28_ = FALSE;
		}
		if (_tmp28_) {
			IconButton* _tmp33_;
			Icon* _tmp34_;
			IconButton* _tmp35_;
			Icon* _tmp36_;
			_tmp33_ = first_button;
			_tmp34_ = _tmp33_->icon;
			_tmp34_->waiting = TRUE;
			_tmp35_ = first_button;
			_tmp36_ = _tmp35_->icon;
			icon_animate_wait (_tmp36_);
		}
		_g_object_unref0 (first_button);
	}
	button = NULL;
	_tmp37_ = self->priv->buttons;
	_tmp38_ = first_app_id;
	if (g_hash_table_contains (_tmp37_, _tmp38_)) {
		GHashTable* _tmp39_;
		const gchar* _tmp40_;
		gconstpointer _tmp41_;
		IconButton* _tmp42_;
		gboolean _tmp43_ = FALSE;
		IconButton* _tmp45_;
		_tmp39_ = self->priv->buttons;
		_tmp40_ = first_app_id;
		_tmp41_ = g_hash_table_lookup (_tmp39_, _tmp40_);
		_tmp42_ = _g_object_ref0 ((IconButton*) _tmp41_);
		_g_object_unref0 (button);
		button = _tmp42_;
		if (!self->priv->grouping) {
			IconButton* _tmp44_;
			_tmp44_ = button;
			_tmp43_ = !icon_button_is_empty (_tmp44_);
		} else {
			_tmp43_ = FALSE;
		}
		if (_tmp43_) {
			_g_object_unref0 (button);
			button = NULL;
		}
		_tmp45_ = button;
		if (_tmp45_ != NULL) {
			gulong _tmp46_;
			gulong _tmp47_;
			gchar* _tmp48_;
			gchar* _tmp49_;
			IconButton* _tmp50_;
			_tmp46_ = budgie_abomination_running_app_get_id (app);
			_tmp47_ = _tmp46_;
			_tmp48_ = g_strdup_printf ("%lu", _tmp47_);
			_tmp49_ = _tmp48_;
			_tmp50_ = button;
			icon_tasklist_applet_add_button (self, _tmp49_, _tmp50_);
			_g_free0 (_tmp49_);
		}
	}
	_tmp51_ = button;
	if (_tmp51_ == NULL) {
		gulong _tmp74_;
		gulong _tmp75_;
		gchar* _tmp76_;
		gchar* _tmp77_;
		IconButton* _tmp78_;
		if (!self->priv->grouping) {
			BudgieAbominationAbomination* _tmp52_;
			BudgieAppSystem* _tmp53_;
			GSettings* _tmp54_;
			DesktopHelper* _tmp55_;
			BudgiePopoverManager* _tmp56_;
			gulong _tmp57_;
			gulong _tmp58_;
			gchar* _tmp59_;
			gchar* _tmp60_;
			IconButton* _tmp61_;
			_tmp52_ = self->priv->abomination;
			_tmp53_ = self->priv->app_system;
			_tmp54_ = self->priv->settings;
			_tmp55_ = self->priv->desktop_helper;
			_tmp56_ = self->priv->manager;
			_tmp57_ = budgie_abomination_running_app_get_id (app);
			_tmp58_ = _tmp57_;
			_tmp59_ = g_strdup_printf ("%lu", _tmp58_);
			_tmp60_ = _tmp59_;
			_tmp61_ = icon_button_new_from_app (_tmp52_, _tmp53_, _tmp54_, _tmp55_, _tmp56_, app, _tmp60_);
			g_object_ref_sink (_tmp61_);
			_g_object_unref0 (button);
			button = _tmp61_;
			_g_free0 (_tmp60_);
		} else {
			BudgieAbominationAbomination* _tmp62_;
			BudgieAppSystem* _tmp63_;
			GSettings* _tmp64_;
			DesktopHelper* _tmp65_;
			BudgiePopoverManager* _tmp66_;
			BudgieAbominationAppGroup* _tmp67_;
			BudgieAbominationAppGroup* _tmp68_;
			gulong _tmp69_;
			gulong _tmp70_;
			gchar* _tmp71_;
			gchar* _tmp72_;
			IconButton* _tmp73_;
			_tmp62_ = self->priv->abomination;
			_tmp63_ = self->priv->app_system;
			_tmp64_ = self->priv->settings;
			_tmp65_ = self->priv->desktop_helper;
			_tmp66_ = self->priv->manager;
			_tmp67_ = budgie_abomination_running_app_get_group_object (app);
			_tmp68_ = _tmp67_;
			_tmp69_ = budgie_abomination_running_app_get_id (app);
			_tmp70_ = _tmp69_;
			_tmp71_ = g_strdup_printf ("%lu", _tmp70_);
			_tmp72_ = _tmp71_;
			_tmp73_ = icon_button_new_from_group (_tmp62_, _tmp63_, _tmp64_, _tmp65_, _tmp66_, _tmp68_, _tmp72_);
			g_object_ref_sink (_tmp73_);
			_g_object_unref0 (button);
			button = _tmp73_;
			_g_free0 (_tmp72_);
		}
		_tmp74_ = budgie_abomination_running_app_get_id (app);
		_tmp75_ = _tmp74_;
		_tmp76_ = g_strdup_printf ("%lu", _tmp75_);
		_tmp77_ = _tmp76_;
		_tmp78_ = button;
		icon_tasklist_applet_add_icon_button (self, _tmp77_, _tmp78_);
		_g_free0 (_tmp77_);
	}
	if (self->priv->grouping) {
		IconButton* _tmp80_;
		BudgieAbominationAppGroup* _tmp81_;
		_tmp80_ = button;
		_tmp81_ = icon_button_get_class_group (_tmp80_);
		_tmp79_ = _tmp81_ == NULL;
	} else {
		_tmp79_ = FALSE;
	}
	if (_tmp79_) {
		IconButton* _tmp82_;
		BudgieAbominationAppGroup* _tmp83_;
		BudgieAbominationAppGroup* _tmp84_;
		_tmp82_ = button;
		_tmp83_ = budgie_abomination_running_app_get_group_object (app);
		_tmp84_ = _tmp83_;
		icon_button_set_class_group (_tmp82_, _tmp84_);
	}
	if (!self->priv->grouping) {
		IconButton* _tmp86_;
		_tmp86_ = button;
		_tmp85_ = icon_button_is_empty (_tmp86_);
	} else {
		_tmp85_ = FALSE;
	}
	if (_tmp85_) {
		IconButton* _tmp87_;
		WnckWindow* _tmp88_;
		WnckWindow* _tmp89_;
		_tmp87_ = button;
		_tmp88_ = budgie_abomination_running_app_get_window (app);
		_tmp89_ = _tmp88_;
		icon_button_set_wnck_window (_tmp87_, _tmp89_);
		_g_object_unref0 (_tmp89_);
	}
	_tmp90_ = button;
	icon_tasklist_applet_update_button (self, _tmp90_);
	_g_object_unref0 (button);
	_g_free0 (first_app_id);
	_g_object_unref0 (first_app);
}

static void
icon_tasklist_applet_on_app_closed (IconTasklistApplet* self,
                                    BudgieAbominationRunningApp* app)
{
	IconButton* button = NULL;
	GHashTable* _tmp0_;
	gulong _tmp1_;
	gulong _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gconstpointer _tmp5_;
	IconButton* _tmp6_;
	IconButton* _tmp7_;
	gboolean _tmp8_ = FALSE;
	IconButton* _tmp9_;
	IconButton* _tmp21_;
	IconButton* _tmp22_;
	BudgieAbominationAppGroup* _tmp23_;
	IconButton* _tmp44_;
	IconButton* _tmp45_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (app != NULL);
	_tmp0_ = self->priv->buttons;
	_tmp1_ = budgie_abomination_running_app_get_id (app);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup_printf ("%lu", _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_hash_table_lookup (_tmp0_, _tmp4_);
	_tmp6_ = _g_object_ref0 ((IconButton*) _tmp5_);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp4_);
	button = _tmp7_;
	_tmp9_ = button;
	if (_tmp9_ == NULL) {
		GDesktopAppInfo* _tmp10_;
		GDesktopAppInfo* _tmp11_;
		_tmp10_ = budgie_abomination_running_app_get_app_info (app);
		_tmp11_ = _tmp10_;
		_tmp8_ = _tmp11_ != NULL;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		gchar* launcher = NULL;
		DesktopHelper* _tmp12_;
		GDesktopAppInfo* _tmp13_;
		GDesktopAppInfo* _tmp14_;
		const gchar* _tmp15_;
		gchar* _tmp16_;
		GHashTable* _tmp17_;
		const gchar* _tmp18_;
		gconstpointer _tmp19_;
		IconButton* _tmp20_;
		_tmp12_ = self->priv->desktop_helper;
		_tmp13_ = budgie_abomination_running_app_get_app_info (app);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_desktop_app_info_get_filename (_tmp14_);
		_tmp16_ = desktop_helper_get_app_launcher (_tmp12_, _tmp15_);
		launcher = _tmp16_;
		_tmp17_ = self->priv->buttons;
		_tmp18_ = launcher;
		_tmp19_ = g_hash_table_lookup (_tmp17_, _tmp18_);
		_tmp20_ = _g_object_ref0 ((IconButton*) _tmp19_);
		_g_object_unref0 (button);
		button = _tmp20_;
		_g_free0 (launcher);
	}
	_tmp21_ = button;
	if (_tmp21_ == NULL) {
		_g_object_unref0 (button);
		return;
	}
	_tmp22_ = button;
	_tmp23_ = icon_button_get_class_group (_tmp22_);
	if (_tmp23_ != NULL) {
		IconButton* _tmp24_;
		BudgieAbominationAppGroup* _tmp25_;
		GList* _tmp26_;
		GList* _tmp27_;
		gboolean _tmp28_;
		_tmp24_ = button;
		_tmp25_ = icon_button_get_class_group (_tmp24_);
		_tmp26_ = budgie_abomination_app_group_get_windows (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = g_list_length (_tmp27_) == ((guint) 0);
		(_tmp27_ == NULL) ? NULL : (_tmp27_ = (g_list_free (_tmp27_), NULL));
		if (_tmp28_) {
			IconButton* _tmp29_;
			_tmp29_ = button;
			icon_button_set_class_group (_tmp29_, NULL);
		} else {
			IconButton* _tmp30_;
			_tmp30_ = button;
			if (!_tmp30_->pinned) {
				BudgieAbominationRunningApp* first_app = NULL;
				BudgieAbominationAbomination* _tmp31_;
				IconButton* _tmp32_;
				BudgieAbominationAppGroup* _tmp33_;
				gchar* _tmp34_;
				gchar* _tmp35_;
				BudgieAbominationRunningApp* _tmp36_;
				BudgieAbominationRunningApp* _tmp37_;
				BudgieAbominationRunningApp* _tmp38_;
				_tmp31_ = self->priv->abomination;
				_tmp32_ = button;
				_tmp33_ = icon_button_get_class_group (_tmp32_);
				_tmp34_ = budgie_abomination_app_group_get_name (_tmp33_);
				_tmp35_ = _tmp34_;
				_tmp36_ = budgie_abomination_abomination_get_first_app_of_group (_tmp31_, _tmp35_);
				_tmp37_ = _tmp36_;
				_g_free0 (_tmp35_);
				first_app = _tmp37_;
				_tmp38_ = first_app;
				if (_tmp38_ != NULL) {
					IconButton* _tmp39_;
					BudgieAbominationRunningApp* _tmp40_;
					gulong _tmp41_;
					gulong _tmp42_;
					gchar* _tmp43_;
					_tmp39_ = button;
					_tmp40_ = first_app;
					_tmp41_ = budgie_abomination_running_app_get_id (_tmp40_);
					_tmp42_ = _tmp41_;
					_tmp43_ = g_strdup_printf ("%lu", _tmp42_);
					_g_free0 (_tmp39_->button_id);
					_tmp39_->button_id = _tmp43_;
				}
				_g_object_unref0 (first_app);
			}
		}
	}
	_tmp44_ = button;
	icon_button_set_wnck_window (_tmp44_, NULL);
	_tmp45_ = button;
	icon_button_update (_tmp45_);
	if (self->priv->grouping) {
		gboolean _tmp46_ = FALSE;
		IconButton* _tmp47_;
		const gchar* _tmp48_;
		gulong _tmp49_;
		gulong _tmp50_;
		gchar* _tmp51_;
		gchar* _tmp52_;
		gboolean _tmp53_;
		_tmp47_ = button;
		_tmp48_ = _tmp47_->button_id;
		_tmp49_ = budgie_abomination_running_app_get_id (app);
		_tmp50_ = _tmp49_;
		_tmp51_ = g_strdup_printf ("%lu", _tmp50_);
		_tmp52_ = _tmp51_;
		_tmp53_ = g_strcmp0 (_tmp48_, _tmp52_) != 0;
		_g_free0 (_tmp52_);
		if (_tmp53_) {
			GHashTable* _tmp54_;
			gulong _tmp55_;
			gulong _tmp56_;
			gchar* _tmp57_;
			gchar* _tmp58_;
			_tmp54_ = self->priv->buttons;
			_tmp55_ = budgie_abomination_running_app_get_id (app);
			_tmp56_ = _tmp55_;
			_tmp57_ = g_strdup_printf ("%lu", _tmp56_);
			_tmp58_ = _tmp57_;
			_tmp46_ = g_hash_table_contains (_tmp54_, _tmp58_);
			_g_free0 (_tmp58_);
		} else {
			_tmp46_ = FALSE;
		}
		if (_tmp46_) {
			gulong _tmp59_;
			gulong _tmp60_;
			gchar* _tmp61_;
			gchar* _tmp62_;
			IconButton* _tmp63_;
			const gchar* _tmp64_;
			IconButton* _tmp65_;
			IconButton* _tmp66_;
			_tmp59_ = budgie_abomination_running_app_get_id (app);
			_tmp60_ = _tmp59_;
			_tmp61_ = g_strdup_printf ("%lu", _tmp60_);
			_tmp62_ = _tmp61_;
			_tmp63_ = button;
			_tmp64_ = _tmp63_->button_id;
			icon_tasklist_applet_swap_button (self, _tmp62_, _tmp64_);
			_g_free0 (_tmp62_);
			_tmp65_ = button;
			_g_object_unref0 (_tmp65_->first_app);
			_tmp65_->first_app = NULL;
			_tmp66_ = button;
			icon_button_set_app_for_class_group (_tmp66_);
		} else {
			gulong _tmp67_;
			gulong _tmp68_;
			gchar* _tmp69_;
			gchar* _tmp70_;
			_tmp67_ = budgie_abomination_running_app_get_id (app);
			_tmp68_ = _tmp67_;
			_tmp69_ = g_strdup_printf ("%lu", _tmp68_);
			_tmp70_ = _tmp69_;
			icon_tasklist_applet_remove_button (self, _tmp70_);
			_g_free0 (_tmp70_);
		}
	} else {
		IconButton* _tmp71_;
		_tmp71_ = button;
		if (_tmp71_->pinned) {
			gulong _tmp72_;
			gulong _tmp73_;
			gchar* _tmp74_;
			gchar* _tmp75_;
			BudgieAbominationRunningApp* first_app = NULL;
			BudgieAbominationAbomination* _tmp76_;
			gchar* _tmp77_;
			gchar* _tmp78_;
			BudgieAbominationRunningApp* _tmp79_;
			BudgieAbominationRunningApp* _tmp80_;
			BudgieAbominationRunningApp* _tmp81_;
			BudgieAbominationRunningApp* _tmp82_;
			BudgieAbominationRunningApp* _tmp83_;
			_tmp72_ = budgie_abomination_running_app_get_id (app);
			_tmp73_ = _tmp72_;
			_tmp74_ = g_strdup_printf ("%lu", _tmp73_);
			_tmp75_ = _tmp74_;
			icon_tasklist_applet_remove_button (self, _tmp75_);
			_g_free0 (_tmp75_);
			_tmp76_ = self->priv->abomination;
			_tmp77_ = budgie_abomination_running_app_get_group_name (app);
			_tmp78_ = _tmp77_;
			_tmp79_ = budgie_abomination_abomination_get_first_app_of_group (_tmp76_, _tmp78_);
			_tmp80_ = _tmp79_;
			_g_free0 (_tmp78_);
			first_app = _tmp80_;
			_tmp81_ = first_app;
			if (_tmp81_ == NULL) {
				_g_object_unref0 (first_app);
				_g_object_unref0 (button);
				return;
			}
			_tmp82_ = first_app;
			icon_tasklist_applet_on_app_closed (self, _tmp82_);
			_tmp83_ = first_app;
			icon_tasklist_applet_on_app_opened (self, _tmp83_);
			_g_object_unref0 (first_app);
		}
	}
	_g_object_unref0 (button);
}

static void
icon_tasklist_applet_on_active_window_changed (IconTasklistApplet* self)
{
	GHashTable* _tmp0_;
	GList* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->buttons;
	_tmp1_ = g_hash_table_get_values (_tmp0_);
	{
		GList* button_collection = NULL;
		GList* button_it = NULL;
		button_collection = _tmp1_;
		for (button_it = button_collection; button_it != NULL; button_it = button_it->next) {
			IconButton* _tmp2_;
			IconButton* button = NULL;
			_tmp2_ = _g_object_ref0 ((IconButton*) button_it->data);
			button = _tmp2_;
			{
				IconButton* _tmp3_;
				DesktopHelper* _tmp4_;
				WnckWindow* _tmp5_;
				WnckWindow* _tmp6_;
				gboolean _tmp7_;
				IconButton* _tmp12_;
				_tmp3_ = button;
				_tmp4_ = self->priv->desktop_helper;
				_tmp5_ = desktop_helper_get_active_window (_tmp4_);
				_tmp6_ = _tmp5_;
				_tmp7_ = icon_button_has_window (_tmp3_, _tmp6_);
				_g_object_unref0 (_tmp6_);
				if (_tmp7_) {
					IconButton* _tmp8_;
					DesktopHelper* _tmp9_;
					WnckWindow* _tmp10_;
					IconButton* _tmp11_;
					_tmp8_ = button;
					_tmp9_ = self->priv->desktop_helper;
					_tmp10_ = desktop_helper_get_active_window (_tmp9_);
					_g_object_unref0 (_tmp8_->last_active_window);
					_tmp8_->last_active_window = _tmp10_;
					_tmp11_ = button;
					icon_button_attention (_tmp11_, FALSE);
				}
				_tmp12_ = button;
				icon_button_update (_tmp12_);
				_g_object_unref0 (button);
			}
		}
		(button_collection == NULL) ? NULL : (button_collection = (g_list_free (button_collection), NULL));
	}
}

static void
__lambda55_ (IconTasklistApplet* self,
             const gchar* id,
             IconButton* button)
{
	g_return_if_fail (id != NULL);
	g_return_if_fail (button != NULL);
	icon_button_update_icon (button);
}

static void
___lambda55__gh_func (gconstpointer key,
                      gconstpointer value,
                      gpointer self)
{
	__lambda55_ ((IconTasklistApplet*) self, (const gchar*) key, (IconButton*) value);
}

static gboolean
__lambda54_ (IconTasklistApplet* self)
{
	GHashTable* _tmp0_;
	gboolean result;
	_tmp0_ = self->priv->buttons;
	g_hash_table_foreach (_tmp0_, ___lambda55__gh_func, self);
	result = FALSE;
	return result;
}

static gboolean
___lambda54__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda54_ ((IconTasklistApplet*) self);
	return result;
}

static void
icon_tasklist_applet_set_icons_size (IconTasklistApplet* self)
{
	DesktopHelper* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->desktop_helper;
	wnck_set_default_icon_size ((gsize) _tmp0_->icon_size);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda54__gsource_func, g_object_ref (self), g_object_unref);
	gtk_widget_queue_resize ((GtkWidget*) self);
	gtk_widget_queue_draw ((GtkWidget*) self);
}

/**
 * Our panel has moved somewhere, stash the positions
 */
static void
icon_tasklist_applet_real_panel_position_changed (BudgieApplet* base,
                                                  BudgiePanelPosition position)
{
	IconTasklistApplet * self;
	DesktopHelper* _tmp0_;
	DesktopHelper* _tmp1_;
	GtkBox* _tmp2_;
	DesktopHelper* _tmp3_;
	self = (IconTasklistApplet*) base;
	_tmp0_ = self->priv->desktop_helper;
	_tmp0_->panel_position = position;
	_tmp1_ = self->priv->desktop_helper;
	_tmp1_->orientation = icon_tasklist_applet_get_orientation (self);
	_tmp2_ = self->priv->main_layout;
	_tmp3_ = self->priv->desktop_helper;
	gtk_orientable_set_orientation ((GtkOrientable*) _tmp2_, _tmp3_->orientation);
	icon_tasklist_applet_set_icons_size (self);
}

/**
 * Our panel has changed size, record the new icon sizes
 */
static void
icon_tasklist_applet_real_panel_size_changed (BudgieApplet* base,
                                              gint panel,
                                              gint icon,
                                              gint small_icon)
{
	IconTasklistApplet * self;
	DesktopHelper* _tmp0_;
	DesktopHelper* _tmp1_;
	self = (IconTasklistApplet*) base;
	_tmp0_ = self->priv->desktop_helper;
	_tmp0_->icon_size = small_icon;
	_tmp1_ = self->priv->desktop_helper;
	_tmp1_->panel_size = panel;
	icon_tasklist_applet_set_icons_size (self);
}

static void
icon_tasklist_applet_real_update_popovers (BudgieApplet* base,
                                           BudgiePopoverManager* manager)
{
	IconTasklistApplet * self;
	self = (IconTasklistApplet*) base;
	self->priv->manager = manager;
}

/**
 * Return our orientation in relation to the panel position
 */
static GtkOrientation
icon_tasklist_applet_get_orientation (IconTasklistApplet* self)
{
	DesktopHelper* _tmp0_;
	GtkOrientation result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->desktop_helper;
	switch (_tmp0_->panel_position) {
		case BUDGIE_PANEL_POSITION_TOP:
		case BUDGIE_PANEL_POSITION_BOTTOM:
		{
			result = GTK_ORIENTATION_HORIZONTAL;
			return result;
		}
		default:
		{
			result = GTK_ORIENTATION_VERTICAL;
			return result;
		}
	}
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		IconTasklistApplet* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->wrapper);
		_g_free0 (_data1_->app_id);
		_g_object_unref0 (_data1_->button);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
__lambda48_ (Block1Data* _data1_)
{
	IconTasklistApplet* self;
	self = _data1_->self;
	if (!_data1_->button->pinned) {
		if (_data1_->wrapper != NULL) {
			button_wrapper_gracefully_die (_data1_->wrapper);
		}
		icon_tasklist_applet_remove_button (self, _data1_->app_id);
	}
}

static void
___lambda48__icon_button_became_empty (IconButton* _sender,
                                       gpointer self)
{
	__lambda48_ (self);
}

static void
__lambda49_ (Block1Data* _data1_)
{
	IconTasklistApplet* self;
	BudgieAbominationRunningApp* _tmp0_;
	gchar** parts = NULL;
	BudgieAbominationRunningApp* _tmp1_;
	GDesktopAppInfo* _tmp2_;
	GDesktopAppInfo* _tmp3_;
	const gchar* _tmp4_;
	gchar** _tmp5_;
	gchar** _tmp6_;
	gint parts_length1;
	gint _parts_size_;
	gchar* launcher = NULL;
	gchar** _tmp7_;
	gint _tmp7__length1;
	gchar** _tmp8_;
	gint _tmp8__length1;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	self = _data1_->self;
	_tmp0_ = _data1_->button->first_app;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = _data1_->button->first_app;
	_tmp2_ = budgie_abomination_running_app_get_app_info (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_desktop_app_info_get_filename (_tmp3_);
	_tmp6_ = _tmp5_ = g_strsplit (_tmp4_, "/", 0);
	parts = _tmp6_;
	parts_length1 = _vala_array_length (_tmp5_);
	_parts_size_ = parts_length1;
	_tmp7_ = parts;
	_tmp7__length1 = parts_length1;
	_tmp8_ = parts;
	_tmp8__length1 = parts_length1;
	_tmp9_ = _tmp7_[_tmp8__length1 - 1];
	_tmp10_ = g_strdup (_tmp9_);
	launcher = _tmp10_;
	if (_data1_->button->pinned) {
		const gchar* _tmp11_;
		gchar* _tmp12_;
		const gchar* _tmp13_;
		BudgieAbominationRunningApp* _tmp14_;
		gulong _tmp15_;
		gulong _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		_tmp11_ = launcher;
		_tmp12_ = g_strdup (_tmp11_);
		_g_free0 (_data1_->button->button_id);
		_data1_->button->button_id = _tmp12_;
		_tmp13_ = launcher;
		icon_tasklist_applet_add_button (self, _tmp13_, _data1_->button);
		_tmp14_ = _data1_->button->first_app;
		_tmp15_ = budgie_abomination_running_app_get_id (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = g_strdup_printf ("%lu", _tmp16_);
		_tmp18_ = _tmp17_;
		icon_tasklist_applet_remove_button (self, _tmp18_);
		_g_free0 (_tmp18_);
	} else {
		BudgieAbominationRunningApp* _tmp19_;
		gulong _tmp20_;
		gulong _tmp21_;
		gchar* _tmp22_;
		BudgieAbominationRunningApp* _tmp23_;
		gulong _tmp24_;
		gulong _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		const gchar* _tmp28_;
		_tmp19_ = _data1_->button->first_app;
		_tmp20_ = budgie_abomination_running_app_get_id (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = g_strdup_printf ("%lu", _tmp21_);
		_g_free0 (_data1_->button->button_id);
		_data1_->button->button_id = _tmp22_;
		_tmp23_ = _data1_->button->first_app;
		_tmp24_ = budgie_abomination_running_app_get_id (_tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = g_strdup_printf ("%lu", _tmp25_);
		_tmp27_ = _tmp26_;
		icon_tasklist_applet_add_button (self, _tmp27_, _data1_->button);
		_g_free0 (_tmp27_);
		_tmp28_ = launcher;
		icon_tasklist_applet_remove_button (self, _tmp28_);
	}
	_g_free0 (launcher);
	parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
}

static void
___lambda49__icon_button_pinned_changed (IconButton* _sender,
                                         gpointer self)
{
	__lambda49_ (self);
}

static void
icon_tasklist_applet_add_icon_button (IconTasklistApplet* self,
                                      const gchar* app_id,
                                      IconButton* button)
{
	Block1Data* _data1_;
	gchar* _tmp0_;
	IconButton* _tmp1_;
	ButtonWrapper* _tmp2_;
	GtkBox* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (app_id != NULL);
	g_return_if_fail (button != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = g_strdup (app_id);
	_g_free0 (_data1_->app_id);
	_data1_->app_id = _tmp0_;
	_tmp1_ = _g_object_ref0 (button);
	_g_object_unref0 (_data1_->button);
	_data1_->button = _tmp1_;
	icon_tasklist_applet_add_button (self, _data1_->app_id, _data1_->button);
	_tmp2_ = button_wrapper_new (_data1_->button);
	g_object_ref_sink (_tmp2_);
	_data1_->wrapper = _tmp2_;
	button_wrapper_set_orient (_data1_->wrapper, icon_tasklist_applet_get_orientation (self));
	g_signal_connect_data (_data1_->button, "became-empty", (GCallback) ___lambda48__icon_button_became_empty, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	g_signal_connect_data (_data1_->button, "pinned-changed", (GCallback) ___lambda49__icon_button_pinned_changed, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp3_ = self->priv->main_layout;
	gtk_container_add ((GtkContainer*) _tmp3_, (GtkWidget*) _data1_->wrapper);
	gtk_widget_show_all ((GtkWidget*) self);
	icon_tasklist_applet_update_button (self, _data1_->button);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}

static void
icon_tasklist_applet_update_button (IconTasklistApplet* self,
                                    IconButton* button)
{
	gboolean visible = FALSE;
	gboolean _tmp5_ = FALSE;
	GtkContainer* _tmp6_;
	GtkContainer* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	visible = TRUE;
	if (self->priv->restrict_to_workspace) {
		WnckWorkspace* workspace = NULL;
		WnckScreen* _tmp0_;
		WnckWorkspace* _tmp1_;
		WnckWorkspace* _tmp2_;
		WnckWorkspace* _tmp3_;
		WnckWorkspace* _tmp4_;
		_tmp0_ = self->priv->wnck_screen;
		_tmp1_ = wnck_screen_get_active_workspace (_tmp0_);
		_tmp2_ = _g_object_ref0 (_tmp1_);
		workspace = _tmp2_;
		_tmp3_ = workspace;
		if (_tmp3_ == NULL) {
			_g_object_unref0 (workspace);
			return;
		}
		_tmp4_ = workspace;
		visible = icon_button_has_window_on_workspace (button, _tmp4_);
		_g_object_unref0 (workspace);
	}
	if (self->priv->only_show_pinned) {
		visible = icon_button_is_pinned (button);
	}
	if (visible) {
		_tmp5_ = TRUE;
	} else {
		_tmp5_ = icon_button_is_pinned (button);
	}
	visible = _tmp5_;
	_tmp6_ = gtk_widget_get_parent ((GtkWidget*) button);
	button_wrapper_set_orient (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_BUTTON_WRAPPER, ButtonWrapper), icon_tasklist_applet_get_orientation (self));
	_tmp7_ = gtk_widget_get_parent ((GtkWidget*) button);
	gtk_revealer_set_reveal_child (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_revealer_get_type (), GtkRevealer), visible);
	icon_button_update (button);
}

/**
 * Ensure that we don't access the resource simultaneously when adding new buttons.
 */
static void
icon_tasklist_applet_add_button (IconTasklistApplet* self,
                                 const gchar* key,
                                 IconButton* button)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	g_return_if_fail (button != NULL);
	{
		GHashTable* _tmp0_;
		_tmp0_ = self->priv->buttons;
		g_rec_mutex_lock (&self->priv->__lock_buttons);
		{
			GHashTable* _tmp1_;
			gchar* _tmp2_;
			IconButton* _tmp3_;
			_tmp1_ = self->priv->buttons;
			_tmp2_ = g_strdup (key);
			_tmp3_ = _g_object_ref0 (button);
			g_hash_table_insert (_tmp1_, _tmp2_, _tmp3_);
		}
		__finally0:
		{
			GHashTable* _tmp4_;
			_tmp4_ = self->priv->buttons;
			g_rec_mutex_unlock (&self->priv->__lock_buttons);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

/**
 * Ensure that we don't access the resource simultaneously when removing a button.
 */
static void
icon_tasklist_applet_remove_button (IconTasklistApplet* self,
                                    const gchar* key)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	{
		GHashTable* _tmp0_;
		_tmp0_ = self->priv->buttons;
		g_rec_mutex_lock (&self->priv->__lock_buttons);
		{
			GHashTable* _tmp1_;
			_tmp1_ = self->priv->buttons;
			g_hash_table_remove (_tmp1_, key);
		}
		__finally0:
		{
			GHashTable* _tmp2_;
			_tmp2_ = self->priv->buttons;
			g_rec_mutex_unlock (&self->priv->__lock_buttons);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

/**
 * Ensure that we don't access the resource simultaneously when swapping a button's key.
 */
static gpointer
_vala_g_hash_table_take (GHashTable* self,
                         gconstpointer key,
                         gboolean* exists)
{
	gboolean _vala_exists = FALSE;
	GHashTable* ht = NULL;
	void** htp = NULL;
	gconstpointer _tmp0_;
	gpointer result;
	g_return_val_if_fail (self != NULL, NULL);
	ht = NULL;
	htp = &ht;
	_tmp0_ = g_hash_table_lookup (self, key);
	*htp = _tmp0_;
	_vala_exists = g_hash_table_steal (self, key);
	result = ht;
	if (exists) {
		*exists = _vala_exists;
	}
	return result;
}

static void
icon_tasklist_applet_swap_button (IconTasklistApplet* self,
                                  const gchar* old_key,
                                  const gchar* new_key)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (old_key != NULL);
	g_return_if_fail (new_key != NULL);
	{
		GHashTable* _tmp0_;
		_tmp0_ = self->priv->buttons;
		g_rec_mutex_lock (&self->priv->__lock_buttons);
		{
			GHashTable* _tmp1_;
			gchar* _tmp2_;
			GHashTable* _tmp3_;
			gpointer _tmp4_;
			_tmp1_ = self->priv->buttons;
			_tmp2_ = g_strdup (new_key);
			_tmp3_ = self->priv->buttons;
			_tmp4_ = _vala_g_hash_table_take (_tmp3_, old_key, NULL);
			g_hash_table_insert (_tmp1_, _tmp2_, (IconButton*) _tmp4_);
		}
		__finally0:
		{
			GHashTable* _tmp5_;
			_tmp5_ = self->priv->buttons;
			g_rec_mutex_unlock (&self->priv->__lock_buttons);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

const gchar*
icon_tasklist_applet_get_uuid (IconTasklistApplet* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_uuid;
	result = _tmp0_;
	return result;
}

void
icon_tasklist_applet_set_uuid (IconTasklistApplet* self,
                               const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = icon_tasklist_applet_get_uuid (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_uuid);
		self->priv->_uuid = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, icon_tasklist_applet_properties[ICON_TASKLIST_APPLET_UUID_PROPERTY]);
	}
}

static void
icon_tasklist_applet_class_init (IconTasklistAppletClass * klass,
                                 gpointer klass_data)
{
	icon_tasklist_applet_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &IconTasklistApplet_private_offset);
	((BudgieAppletClass *) klass)->get_settings_ui = (GtkWidget* (*) (BudgieApplet*)) icon_tasklist_applet_real_get_settings_ui;
	((BudgieAppletClass *) klass)->supports_settings = (gboolean (*) (BudgieApplet*)) icon_tasklist_applet_real_supports_settings;
	((BudgieAppletClass *) klass)->panel_position_changed = (void (*) (BudgieApplet*, BudgiePanelPosition)) icon_tasklist_applet_real_panel_position_changed;
	((BudgieAppletClass *) klass)->panel_size_changed = (void (*) (BudgieApplet*, gint, gint, gint)) icon_tasklist_applet_real_panel_size_changed;
	((BudgieAppletClass *) klass)->update_popovers = (void (*) (BudgieApplet*, BudgiePopoverManager*)) icon_tasklist_applet_real_update_popovers;
	G_OBJECT_CLASS (klass)->get_property = _vala_icon_tasklist_applet_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_icon_tasklist_applet_set_property;
	G_OBJECT_CLASS (klass)->finalize = icon_tasklist_applet_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ICON_TASKLIST_APPLET_UUID_PROPERTY, icon_tasklist_applet_properties[ICON_TASKLIST_APPLET_UUID_PROPERTY] = g_param_spec_string ("uuid", "uuid", "uuid", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
icon_tasklist_applet_instance_init (IconTasklistApplet * self,
                                    gpointer klass)
{
	self->priv = icon_tasklist_applet_get_instance_private (self);
	self->priv->abomination = NULL;
	self->priv->wnck_screen = NULL;
	self->priv->settings = NULL;
	self->priv->main_layout = NULL;
	self->priv->grouping = TRUE;
	self->priv->restrict_to_workspace = FALSE;
	self->priv->only_show_pinned = FALSE;
	g_rec_mutex_init (&self->priv->__lock_buttons);
	self->priv->desktop_helper = NULL;
	self->priv->app_system = NULL;
	self->priv->manager = NULL;
}

static void
icon_tasklist_applet_finalize (GObject * obj)
{
	IconTasklistApplet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ICON_TASKLIST_APPLET, IconTasklistApplet);
	_g_object_unref0 (self->priv->abomination);
	_g_object_unref0 (self->priv->wnck_screen);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->main_layout);
	g_rec_mutex_clear (&self->priv->__lock_buttons);
	_g_hash_table_unref0 (self->priv->buttons);
	_g_object_unref0 (self->priv->desktop_helper);
	_g_object_unref0 (self->priv->app_system);
	_g_free0 (self->priv->_uuid);
	G_OBJECT_CLASS (icon_tasklist_applet_parent_class)->finalize (obj);
}

GType
icon_tasklist_applet_get_type (void)
{
	return icon_tasklist_applet_type_id;
}

GType
icon_tasklist_applet_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (IconTasklistAppletClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) icon_tasklist_applet_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (IconTasklistApplet), 0, (GInstanceInitFunc) icon_tasklist_applet_instance_init, NULL };
	icon_tasklist_applet_type_id = g_type_module_register_type (module, budgie_applet_get_type (), "IconTasklistApplet", &g_define_type_info, 0);
	IconTasklistApplet_private_offset = sizeof (IconTasklistAppletPrivate);
	return icon_tasklist_applet_type_id;
}

static void
_vala_icon_tasklist_applet_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	IconTasklistApplet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_ICON_TASKLIST_APPLET, IconTasklistApplet);
	switch (property_id) {
		case ICON_TASKLIST_APPLET_UUID_PROPERTY:
		g_value_set_string (value, icon_tasklist_applet_get_uuid (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_icon_tasklist_applet_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec)
{
	IconTasklistApplet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_ICON_TASKLIST_APPLET, IconTasklistApplet);
	switch (property_id) {
		case ICON_TASKLIST_APPLET_UUID_PROPERTY:
		icon_tasklist_applet_set_uuid (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

void
peas_register_types (GTypeModule* module)
{
	PeasObjectModule* objmodule = NULL;
	PeasObjectModule* _tmp0_;
	g_return_if_fail (module != NULL);
	budgie_icon_popover_register_type (module);
	budgie_icon_popover_item_register_type (module);
	budgie_settings_remote_register_type (module);
	budgie_settings_remote_proxy_register_dynamic_type (module);
	budgie_task_list_animation_register_type (module);
	button_wrapper_register_type (module);
	desktop_helper_register_type (module);
	icon_tasklist_register_type (module);
	icon_tasklist_settings_register_type (module);
	icon_tasklist_applet_register_type (module);
	icon_button_register_type (module);
	icon_register_type (module);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (module, peas_object_module_get_type ()) ? ((PeasObjectModule*) module) : NULL);
	objmodule = _tmp0_;
	peas_object_module_register_extension_type (objmodule, budgie_plugin_get_type (), TYPE_ICON_TASKLIST);
	_g_object_unref0 (objmodule);
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

