/* UserIndicator.c generated by valac 0.56.2, the Vala compiler
 * generated from UserIndicator.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright © 2015-2022 Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include "userindicator.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "plugin.h"
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <libpeas/peas.h>

enum  {
	USER_INDICATOR_0_PROPERTY,
	USER_INDICATOR_NUM_PROPERTIES
};
static GParamSpec* user_indicator_properties[USER_INDICATOR_NUM_PROPERTIES];
enum  {
	USER_INDICATOR_APPLET_0_PROPERTY,
	USER_INDICATOR_APPLET_UUID_PROPERTY,
	USER_INDICATOR_APPLET_NUM_PROPERTIES
};
static GParamSpec* user_indicator_applet_properties[USER_INDICATOR_APPLET_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _UserIndicatorAppletPrivate {
	GtkImage* image;
	BudgiePopoverManager* manager;
	gchar* _uuid;
};

static gpointer user_indicator_parent_class = NULL;
static BudgiePluginIface * user_indicator_budgie_plugin_parent_iface = NULL;
static GType user_indicator_type_id = 0;
static gint UserIndicatorApplet_private_offset;
static gpointer user_indicator_applet_parent_class = NULL;
static GType user_indicator_applet_type_id = 0;

static BudgieApplet* user_indicator_real_get_panel_widget (BudgiePlugin* base,
                                                    const gchar* uuid);
static gboolean __lambda17_ (UserIndicatorApplet* self,
                      GdkEventButton* e);
static gboolean ___lambda17__gtk_widget_button_press_event (GtkWidget* _sender,
                                                     GdkEventButton* event,
                                                     gpointer self);
static void user_indicator_applet_real_invoke_action (BudgieApplet* base,
                                               BudgiePanelAction action);
static void user_indicator_applet_real_update_popovers (BudgieApplet* base,
                                                 BudgiePopoverManager* manager);
static void user_indicator_applet_finalize (GObject * obj);
static void _vala_user_indicator_applet_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_user_indicator_applet_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);
GType user_indicator_window_register_type (GTypeModule * module);
GType indicator_item_register_type (GTypeModule * module);
GType accounts_interface_register_type (GTypeModule * module);
GType account_user_interface_register_type (GTypeModule * module);
GType properties_interface_register_type (GTypeModule * module);
GType logind_interface_register_type (GTypeModule * module);
GType session_manager_register_type (GTypeModule * module);
GType screen_saver_register_type (GTypeModule * module);

static BudgieApplet*
user_indicator_real_get_panel_widget (BudgiePlugin* base,
                                      const gchar* uuid)
{
	UserIndicator * self;
	UserIndicatorApplet* _tmp0_;
	BudgieApplet* result;
	self = (UserIndicator*) base;
	g_return_val_if_fail (uuid != NULL, NULL);
	_tmp0_ = user_indicator_applet_new (uuid);
	g_object_ref_sink (_tmp0_);
	result = (BudgieApplet*) _tmp0_;
	return result;
}

UserIndicator*
user_indicator_construct (GType object_type)
{
	UserIndicator * self = NULL;
	self = (UserIndicator*) g_object_new (object_type, NULL);
	return self;
}

UserIndicator*
user_indicator_new (void)
{
	return user_indicator_construct (TYPE_USER_INDICATOR);
}

static void
user_indicator_class_init (UserIndicatorClass * klass,
                           gpointer klass_data)
{
	user_indicator_parent_class = g_type_class_peek_parent (klass);
}

static void
user_indicator_budgie_plugin_interface_init (BudgiePluginIface * iface,
                                             gpointer iface_data)
{
	user_indicator_budgie_plugin_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_panel_widget = (BudgieApplet* (*) (BudgiePlugin*, const gchar*)) user_indicator_real_get_panel_widget;
}

static void
user_indicator_instance_init (UserIndicator * self,
                              gpointer klass)
{
}

GType
user_indicator_get_type (void)
{
	return user_indicator_type_id;
}

GType
user_indicator_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (UserIndicatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) user_indicator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UserIndicator), 0, (GInstanceInitFunc) user_indicator_instance_init, NULL };
	static const GInterfaceInfo budgie_plugin_info = { (GInterfaceInitFunc) user_indicator_budgie_plugin_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	user_indicator_type_id = g_type_module_register_type (module, peas_extension_base_get_type (), "UserIndicator", &g_define_type_info, 0);
	g_type_module_add_interface (module, user_indicator_type_id, budgie_plugin_get_type (), &budgie_plugin_info);
	return user_indicator_type_id;
}

static inline gpointer
user_indicator_applet_get_instance_private (UserIndicatorApplet* self)
{
	return G_STRUCT_MEMBER_P (self, UserIndicatorApplet_private_offset);
}

static gboolean
__lambda17_ (UserIndicatorApplet* self,
             GdkEventButton* e)
{
	gboolean result;
	g_return_val_if_fail (e != NULL, FALSE);
	if (e->button != ((guint) 1)) {
		result = GDK_EVENT_PROPAGATE;
		return result;
	}
	user_indicator_applet_Toggle (self);
	result = GDK_EVENT_STOP;
	return result;
}

static gboolean
___lambda17__gtk_widget_button_press_event (GtkWidget* _sender,
                                            GdkEventButton* event,
                                            gpointer self)
{
	gboolean result;
	result = __lambda17_ ((UserIndicatorApplet*) self, event);
	return result;
}

UserIndicatorApplet*
user_indicator_applet_construct (GType object_type,
                                 const gchar* uuid)
{
	UserIndicatorApplet * self = NULL;
	GtkEventBox* _tmp0_;
	GtkImage* _tmp1_;
	GtkEventBox* _tmp2_;
	GtkImage* _tmp3_;
	GtkImage* _tmp4_;
	UserIndicatorWindow* _tmp5_;
	GtkEventBox* _tmp6_;
	UserIndicatorWindow* _tmp7_;
	GtkWidget* _tmp8_;
	GtkEventBox* _tmp9_;
	g_return_val_if_fail (uuid != NULL, NULL);
	self = (UserIndicatorApplet*) g_object_new (object_type, "uuid", uuid, NULL);
	_tmp0_ = (GtkEventBox*) gtk_event_box_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->ebox);
	self->ebox = _tmp0_;
	_tmp1_ = (GtkImage*) gtk_image_new_from_icon_name (USER_SYMBOLIC_ICON, (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->image);
	self->priv->image = _tmp1_;
	_tmp2_ = self->ebox;
	_tmp3_ = self->priv->image;
	gtk_container_add ((GtkContainer*) _tmp2_, (GtkWidget*) _tmp3_);
	_tmp4_ = self->priv->image;
	_tmp5_ = user_indicator_window_new ((GtkWidget*) _tmp4_);
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->popover);
	self->popover = _tmp5_;
	_tmp6_ = self->ebox;
	g_signal_connect_object ((GtkWidget*) _tmp6_, "button-press-event", (GCallback) ___lambda17__gtk_widget_button_press_event, self, 0);
	_tmp7_ = self->popover;
	_tmp8_ = gtk_bin_get_child ((GtkBin*) _tmp7_);
	gtk_widget_show_all (_tmp8_);
	_tmp9_ = self->ebox;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp9_);
	gtk_widget_show_all ((GtkWidget*) self);
	return self;
}

UserIndicatorApplet*
user_indicator_applet_new (const gchar* uuid)
{
	return user_indicator_applet_construct (TYPE_USER_INDICATOR_APPLET, uuid);
}

void
user_indicator_applet_Toggle (UserIndicatorApplet* self)
{
	UserIndicatorWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->popover;
	if (gtk_widget_get_visible ((GtkWidget*) _tmp0_)) {
		UserIndicatorWindow* _tmp1_;
		_tmp1_ = self->popover;
		gtk_widget_hide ((GtkWidget*) _tmp1_);
	} else {
		UserIndicatorWindow* _tmp2_;
		GtkWidget* _tmp3_;
		BudgiePopoverManager* _tmp4_;
		GtkEventBox* _tmp5_;
		_tmp2_ = self->popover;
		_tmp3_ = gtk_bin_get_child ((GtkBin*) _tmp2_);
		gtk_widget_show_all (_tmp3_);
		_tmp4_ = self->priv->manager;
		_tmp5_ = self->ebox;
		budgie_popover_manager_show_popover (_tmp4_, (GtkWidget*) _tmp5_);
	}
}

static void
user_indicator_applet_real_invoke_action (BudgieApplet* base,
                                          BudgiePanelAction action)
{
	UserIndicatorApplet * self;
	self = (UserIndicatorApplet*) base;
	user_indicator_applet_Toggle (self);
}

static void
user_indicator_applet_real_update_popovers (BudgieApplet* base,
                                            BudgiePopoverManager* manager)
{
	UserIndicatorApplet * self;
	GtkEventBox* _tmp0_;
	UserIndicatorWindow* _tmp1_;
	self = (UserIndicatorApplet*) base;
	self->priv->manager = manager;
	_tmp0_ = self->ebox;
	_tmp1_ = self->popover;
	budgie_popover_manager_register_popover (manager, (GtkWidget*) _tmp0_, (BudgiePopover*) _tmp1_);
}

const gchar*
user_indicator_applet_get_uuid (UserIndicatorApplet* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_uuid;
	result = _tmp0_;
	return result;
}

void
user_indicator_applet_set_uuid (UserIndicatorApplet* self,
                                const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = user_indicator_applet_get_uuid (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_uuid);
		self->priv->_uuid = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, user_indicator_applet_properties[USER_INDICATOR_APPLET_UUID_PROPERTY]);
	}
}

static void
user_indicator_applet_class_init (UserIndicatorAppletClass * klass,
                                  gpointer klass_data)
{
	user_indicator_applet_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &UserIndicatorApplet_private_offset);
	((BudgieAppletClass *) klass)->invoke_action = (void (*) (BudgieApplet*, BudgiePanelAction)) user_indicator_applet_real_invoke_action;
	((BudgieAppletClass *) klass)->update_popovers = (void (*) (BudgieApplet*, BudgiePopoverManager*)) user_indicator_applet_real_update_popovers;
	G_OBJECT_CLASS (klass)->get_property = _vala_user_indicator_applet_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_user_indicator_applet_set_property;
	G_OBJECT_CLASS (klass)->finalize = user_indicator_applet_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), USER_INDICATOR_APPLET_UUID_PROPERTY, user_indicator_applet_properties[USER_INDICATOR_APPLET_UUID_PROPERTY] = g_param_spec_string ("uuid", "uuid", "uuid", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
user_indicator_applet_instance_init (UserIndicatorApplet * self,
                                     gpointer klass)
{
	self->priv = user_indicator_applet_get_instance_private (self);
	self->priv->manager = NULL;
}

static void
user_indicator_applet_finalize (GObject * obj)
{
	UserIndicatorApplet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_USER_INDICATOR_APPLET, UserIndicatorApplet);
	_g_object_unref0 (self->ebox);
	_g_object_unref0 (self->popover);
	_g_object_unref0 (self->priv->image);
	_g_free0 (self->priv->_uuid);
	G_OBJECT_CLASS (user_indicator_applet_parent_class)->finalize (obj);
}

GType
user_indicator_applet_get_type (void)
{
	return user_indicator_applet_type_id;
}

GType
user_indicator_applet_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (UserIndicatorAppletClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) user_indicator_applet_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UserIndicatorApplet), 0, (GInstanceInitFunc) user_indicator_applet_instance_init, NULL };
	user_indicator_applet_type_id = g_type_module_register_type (module, budgie_applet_get_type (), "UserIndicatorApplet", &g_define_type_info, 0);
	UserIndicatorApplet_private_offset = sizeof (UserIndicatorAppletPrivate);
	return user_indicator_applet_type_id;
}

static void
_vala_user_indicator_applet_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	UserIndicatorApplet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_USER_INDICATOR_APPLET, UserIndicatorApplet);
	switch (property_id) {
		case USER_INDICATOR_APPLET_UUID_PROPERTY:
		g_value_set_string (value, user_indicator_applet_get_uuid (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_user_indicator_applet_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	UserIndicatorApplet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_USER_INDICATOR_APPLET, UserIndicatorApplet);
	switch (property_id) {
		case USER_INDICATOR_APPLET_UUID_PROPERTY:
		user_indicator_applet_set_uuid (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
peas_register_types (GTypeModule* module)
{
	PeasObjectModule* objmodule = NULL;
	PeasObjectModule* _tmp0_;
	g_return_if_fail (module != NULL);
	user_indicator_register_type (module);
	user_indicator_applet_register_type (module);
	user_indicator_window_register_type (module);
	indicator_item_register_type (module);
	accounts_interface_register_type (module);
	accounts_interface_proxy_register_dynamic_type (module);
	account_user_interface_register_type (module);
	account_user_interface_proxy_register_dynamic_type (module);
	properties_interface_register_type (module);
	properties_interface_proxy_register_dynamic_type (module);
	logind_interface_register_type (module);
	logind_interface_proxy_register_dynamic_type (module);
	session_manager_register_type (module);
	session_manager_proxy_register_dynamic_type (module);
	screen_saver_register_type (module);
	screen_saver_proxy_register_dynamic_type (module);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (module, peas_object_module_get_type ()) ? ((PeasObjectModule*) module) : NULL);
	objmodule = _tmp0_;
	peas_object_module_register_extension_type (objmodule, budgie_plugin_get_type (), TYPE_USER_INDICATOR);
	_g_object_unref0 (objmodule);
}

