/* shadow.c generated by valac 0.56.2, the Vala compiler
 * generated from shadow.vala, do not modify */

/*
 * This file is part of budgie-desktop.
 *
 * Copyright © 2015-2022 Budgie Desktop Developers
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */

#include "budgie-private.h"
#include "plugin.h"
#include <glib.h>
#include <gtk/gtk.h>
#include <glib-object.h>

enum  {
	BUDGIE_SHADOW_BLOCK_0_PROPERTY,
	BUDGIE_SHADOW_BLOCK_POSITION_PROPERTY,
	BUDGIE_SHADOW_BLOCK_ACTIVE_PROPERTY,
	BUDGIE_SHADOW_BLOCK_NUM_PROPERTIES
};
static GParamSpec* budgie_shadow_block_properties[BUDGIE_SHADOW_BLOCK_NUM_PROPERTIES];

struct _BudgieShadowBlockPrivate {
	BudgiePanelPosition pos;
	gboolean horizontal;
	gint rm;
	gboolean _active;
};

static gint BudgieShadowBlock_private_offset;
static gpointer budgie_shadow_block_parent_class = NULL;

static void budgie_shadow_block_update_position (BudgieShadowBlock* self,
                                          BudgiePanelPosition* old);
static void budgie_shadow_block_real_get_preferred_height (GtkWidget* base,
                                                    gint* min,
                                                    gint* nat);
static void budgie_shadow_block_real_get_preferred_height_for_width (GtkWidget* base,
                                                              gint width,
                                                              gint* min,
                                                              gint* nat);
static void budgie_shadow_block_real_get_preferred_width (GtkWidget* base,
                                                   gint* min,
                                                   gint* nat);
static void budgie_shadow_block_real_get_preferred_width_for_height (GtkWidget* base,
                                                              gint height,
                                                              gint* min,
                                                              gint* nat);
static void budgie_shadow_block_finalize (GObject * obj);
static GType budgie_shadow_block_get_type_once (void);
static void _vala_budgie_shadow_block_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void _vala_budgie_shadow_block_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec);

static inline gpointer
budgie_shadow_block_get_instance_private (BudgieShadowBlock* self)
{
	return G_STRUCT_MEMBER_P (self, BudgieShadowBlock_private_offset);
}

static void
budgie_shadow_block_update_position (BudgieShadowBlock* self,
                                     BudgiePanelPosition* old)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (self->priv->pos == BUDGIE_PANEL_POSITION_TOP) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->priv->pos == BUDGIE_PANEL_POSITION_BOTTOM;
	}
	if (_tmp0_) {
		self->priv->horizontal = TRUE;
	} else {
		self->priv->horizontal = FALSE;
	}
	gtk_widget_queue_resize ((GtkWidget*) self);
}

BudgieShadowBlock*
budgie_shadow_block_construct (GType object_type,
                               BudgiePanelPosition position)
{
	BudgieShadowBlock * self = NULL;
	self = (BudgieShadowBlock*) g_object_new (object_type, NULL);
	budgie_shadow_block_set_active (self, TRUE);
	budgie_shadow_block_set_position (self, position);
	return self;
}

BudgieShadowBlock*
budgie_shadow_block_new (BudgiePanelPosition position)
{
	return budgie_shadow_block_construct (BUDGIE_TYPE_SHADOW_BLOCK, position);
}

static void
budgie_shadow_block_real_get_preferred_height (GtkWidget* base,
                                               gint* min,
                                               gint* nat)
{
	BudgieShadowBlock * self;
	gint _vala_min = 0;
	gint _vala_nat = 0;
	self = (BudgieShadowBlock*) base;
	if (self->priv->horizontal) {
		_vala_min = BUDGIE_SHADOW_BLOCK_SIZE;
		_vala_nat = BUDGIE_SHADOW_BLOCK_SIZE;
		if (min) {
			*min = _vala_min;
		}
		if (nat) {
			*nat = _vala_nat;
		}
		return;
	}
	_vala_nat = self->priv->rm;
	_vala_min = _vala_nat;
	if (min) {
		*min = _vala_min;
	}
	if (nat) {
		*nat = _vala_nat;
	}
}

static void
budgie_shadow_block_real_get_preferred_height_for_width (GtkWidget* base,
                                                         gint width,
                                                         gint* min,
                                                         gint* nat)
{
	BudgieShadowBlock * self;
	gint _vala_min = 0;
	gint _vala_nat = 0;
	self = (BudgieShadowBlock*) base;
	if (self->priv->horizontal) {
		_vala_min = BUDGIE_SHADOW_BLOCK_SIZE;
		_vala_nat = BUDGIE_SHADOW_BLOCK_SIZE;
		if (min) {
			*min = _vala_min;
		}
		if (nat) {
			*nat = _vala_nat;
		}
		return;
	}
	_vala_nat = self->priv->rm;
	_vala_min = _vala_nat;
	if (min) {
		*min = _vala_min;
	}
	if (nat) {
		*nat = _vala_nat;
	}
}

static void
budgie_shadow_block_real_get_preferred_width (GtkWidget* base,
                                              gint* min,
                                              gint* nat)
{
	BudgieShadowBlock * self;
	gint _vala_min = 0;
	gint _vala_nat = 0;
	self = (BudgieShadowBlock*) base;
	if (self->priv->horizontal) {
		_vala_nat = self->priv->rm;
		_vala_min = _vala_nat;
		if (min) {
			*min = _vala_min;
		}
		if (nat) {
			*nat = _vala_nat;
		}
		return;
	}
	_vala_nat = BUDGIE_SHADOW_BLOCK_SIZE;
	_vala_min = _vala_nat;
	if (min) {
		*min = _vala_min;
	}
	if (nat) {
		*nat = _vala_nat;
	}
}

static void
budgie_shadow_block_real_get_preferred_width_for_height (GtkWidget* base,
                                                         gint height,
                                                         gint* min,
                                                         gint* nat)
{
	BudgieShadowBlock * self;
	gint _vala_min = 0;
	gint _vala_nat = 0;
	self = (BudgieShadowBlock*) base;
	if (self->priv->horizontal) {
		_vala_nat = self->priv->rm;
		_vala_min = _vala_nat;
		if (min) {
			*min = _vala_min;
		}
		if (nat) {
			*nat = _vala_nat;
		}
		return;
	}
	_vala_nat = BUDGIE_SHADOW_BLOCK_SIZE;
	_vala_min = _vala_nat;
	if (min) {
		*min = _vala_min;
	}
	if (nat) {
		*nat = _vala_nat;
	}
}

BudgiePanelPosition
budgie_shadow_block_get_position (BudgieShadowBlock* self)
{
	BudgiePanelPosition result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->pos;
	return result;
}

void
budgie_shadow_block_set_position (BudgieShadowBlock* self,
                                  BudgiePanelPosition value)
{
	BudgiePanelPosition old = 0U;
	g_return_if_fail (self != NULL);
	old = self->priv->pos;
	self->priv->pos = value;
	budgie_shadow_block_update_position (self, &old);
	g_object_notify_by_pspec ((GObject *) self, budgie_shadow_block_properties[BUDGIE_SHADOW_BLOCK_POSITION_PROPERTY]);
}

gboolean
budgie_shadow_block_get_active (BudgieShadowBlock* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_active;
	return result;
}

void
budgie_shadow_block_set_active (BudgieShadowBlock* self,
                                gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_active = value;
	if (self->priv->_active) {
		GtkStyleContext* _tmp0_;
		GtkStyleContext* _tmp1_;
		_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
		gtk_style_context_add_class (_tmp0_, "shadow-block");
		_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) self);
		gtk_style_context_remove_class (_tmp1_, "budgie-container");
	} else {
		GtkStyleContext* _tmp2_;
		GtkStyleContext* _tmp3_;
		_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) self);
		gtk_style_context_remove_class (_tmp2_, "shadow-block");
		_tmp3_ = gtk_widget_get_style_context ((GtkWidget*) self);
		gtk_style_context_add_class (_tmp3_, "budgie-container");
	}
	g_object_notify_by_pspec ((GObject *) self, budgie_shadow_block_properties[BUDGIE_SHADOW_BLOCK_ACTIVE_PROPERTY]);
}

static void
budgie_shadow_block_class_init (BudgieShadowBlockClass * klass,
                                gpointer klass_data)
{
	budgie_shadow_block_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BudgieShadowBlock_private_offset);
	((GtkWidgetClass *) klass)->get_preferred_height = (void (*) (GtkWidget*, gint*, gint*)) budgie_shadow_block_real_get_preferred_height;
	((GtkWidgetClass *) klass)->get_preferred_height_for_width = (void (*) (GtkWidget*, gint, gint*, gint*)) budgie_shadow_block_real_get_preferred_height_for_width;
	((GtkWidgetClass *) klass)->get_preferred_width = (void (*) (GtkWidget*, gint*, gint*)) budgie_shadow_block_real_get_preferred_width;
	((GtkWidgetClass *) klass)->get_preferred_width_for_height = (void (*) (GtkWidget*, gint, gint*, gint*)) budgie_shadow_block_real_get_preferred_width_for_height;
	G_OBJECT_CLASS (klass)->get_property = _vala_budgie_shadow_block_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_budgie_shadow_block_set_property;
	G_OBJECT_CLASS (klass)->finalize = budgie_shadow_block_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_SHADOW_BLOCK_POSITION_PROPERTY, budgie_shadow_block_properties[BUDGIE_SHADOW_BLOCK_POSITION_PROPERTY] = g_param_spec_flags ("position", "position", "position", budgie_panel_position_get_type (), 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_SHADOW_BLOCK_ACTIVE_PROPERTY, budgie_shadow_block_properties[BUDGIE_SHADOW_BLOCK_ACTIVE_PROPERTY] = g_param_spec_boolean ("active", "active", "active", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
budgie_shadow_block_instance_init (BudgieShadowBlock * self,
                                   gpointer klass)
{
	self->priv = budgie_shadow_block_get_instance_private (self);
	self->priv->horizontal = FALSE;
	self->priv->rm = 0;
	self->priv->_active = TRUE;
}

static void
budgie_shadow_block_finalize (GObject * obj)
{
	BudgieShadowBlock * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_SHADOW_BLOCK, BudgieShadowBlock);
	G_OBJECT_CLASS (budgie_shadow_block_parent_class)->finalize (obj);
}

/**
* Alternative to a separator, gives a shadow effect
*/
static GType
budgie_shadow_block_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieShadowBlockClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_shadow_block_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieShadowBlock), 0, (GInstanceInitFunc) budgie_shadow_block_instance_init, NULL };
	GType budgie_shadow_block_type_id;
	budgie_shadow_block_type_id = g_type_register_static (gtk_event_box_get_type (), "BudgieShadowBlock", &g_define_type_info, 0);
	BudgieShadowBlock_private_offset = g_type_add_instance_private (budgie_shadow_block_type_id, sizeof (BudgieShadowBlockPrivate));
	return budgie_shadow_block_type_id;
}

GType
budgie_shadow_block_get_type (void)
{
	static volatile gsize budgie_shadow_block_type_id__once = 0;
	if (g_once_init_enter (&budgie_shadow_block_type_id__once)) {
		GType budgie_shadow_block_type_id;
		budgie_shadow_block_type_id = budgie_shadow_block_get_type_once ();
		g_once_init_leave (&budgie_shadow_block_type_id__once, budgie_shadow_block_type_id);
	}
	return budgie_shadow_block_type_id__once;
}

static void
_vala_budgie_shadow_block_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	BudgieShadowBlock * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_TYPE_SHADOW_BLOCK, BudgieShadowBlock);
	switch (property_id) {
		case BUDGIE_SHADOW_BLOCK_POSITION_PROPERTY:
		g_value_set_flags (value, budgie_shadow_block_get_position (self));
		break;
		case BUDGIE_SHADOW_BLOCK_ACTIVE_PROPERTY:
		g_value_set_boolean (value, budgie_shadow_block_get_active (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_budgie_shadow_block_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec)
{
	BudgieShadowBlock * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_TYPE_SHADOW_BLOCK, BudgieShadowBlock);
	switch (property_id) {
		case BUDGIE_SHADOW_BLOCK_POSITION_PROPERTY:
		budgie_shadow_block_set_position (self, g_value_get_flags (value));
		break;
		case BUDGIE_SHADOW_BLOCK_ACTIVE_PROPERTY:
		budgie_shadow_block_set_active (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

