/* ibus.c generated by valac 0.56.2, the Vala compiler
 * generated from ibus.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright © 2016-2022 Budgie Desktop Developers
 * Copyright (C) GNOME Shell Developers (Heavy inspiration, logic theft)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <glib-object.h>
#include <ibus.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>

#define BUDGIE_IBUS_MANAGER_ENGINE_SET_TIMEOUT 4000
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define BUDGIE_TYPE_IBUS_MANAGER (budgie_ibus_manager_get_type ())
#define BUDGIE_IBUS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_IBUS_MANAGER, BudgieIBusManager))
#define BUDGIE_IBUS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_IBUS_MANAGER, BudgieIBusManagerClass))
#define BUDGIE_IS_IBUS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_IBUS_MANAGER))
#define BUDGIE_IS_IBUS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_IBUS_MANAGER))
#define BUDGIE_IBUS_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_IBUS_MANAGER, BudgieIBusManagerClass))

typedef struct _BudgieIBusManager BudgieIBusManager;
typedef struct _BudgieIBusManagerClass BudgieIBusManagerClass;
typedef struct _BudgieIBusManagerPrivate BudgieIBusManagerPrivate;

#define BUDGIE_TYPE_KEYBOARD_MANAGER (budgie_keyboard_manager_get_type ())
#define BUDGIE_KEYBOARD_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_KEYBOARD_MANAGER, BudgieKeyboardManager))
#define BUDGIE_KEYBOARD_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_KEYBOARD_MANAGER, BudgieKeyboardManagerClass))
#define BUDGIE_IS_KEYBOARD_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_KEYBOARD_MANAGER))
#define BUDGIE_IS_KEYBOARD_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_KEYBOARD_MANAGER))
#define BUDGIE_KEYBOARD_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_KEYBOARD_MANAGER, BudgieKeyboardManagerClass))

typedef struct _BudgieKeyboardManager BudgieKeyboardManager;
typedef struct _BudgieKeyboardManagerClass BudgieKeyboardManagerClass;
enum  {
	BUDGIE_IBUS_MANAGER_0_PROPERTY,
	BUDGIE_IBUS_MANAGER_KBM_PROPERTY,
	BUDGIE_IBUS_MANAGER_NUM_PROPERTIES
};
static GParamSpec* budgie_ibus_manager_properties[BUDGIE_IBUS_MANAGER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	BUDGIE_IBUS_MANAGER_READY_SIGNAL,
	BUDGIE_IBUS_MANAGER_NUM_SIGNALS
};
static guint budgie_ibus_manager_signals[BUDGIE_IBUS_MANAGER_NUM_SIGNALS] = {0};

struct _BudgieIBusManager {
	GObject parent_instance;
	BudgieIBusManagerPrivate * priv;
};

struct _BudgieIBusManagerClass {
	GObjectClass parent_class;
};

struct _BudgieIBusManagerPrivate {
	IBusBus* bus;
	gboolean ibus_available;
	GHashTable* engines;
	GList* enginelist;
	BudgieKeyboardManager* _kbm;
	gboolean did_ibus_init;
};

static gint BudgieIBusManager_private_offset;
static gpointer budgie_ibus_manager_parent_class = NULL;

VALA_EXTERN GType budgie_ibus_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieIBusManager, g_object_unref)
VALA_EXTERN GType budgie_keyboard_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieKeyboardManager, g_object_unref)
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
VALA_EXTERN BudgieIBusManager* budgie_ibus_manager_new (BudgieKeyboardManager* kbm);
VALA_EXTERN BudgieIBusManager* budgie_ibus_manager_construct (GType object_type,
                                                  BudgieKeyboardManager* kbm);
VALA_EXTERN void budgie_ibus_manager_do_init (BudgieIBusManager* self);
static void _g_free0_ (gpointer var);
static void budgie_ibus_manager_ibus_connected (BudgieIBusManager* self);
static void _budgie_ibus_manager_ibus_connected_ibus_bus_connected (IBusBus* _sender,
                                                             gpointer self);
static void budgie_ibus_manager_ibus_disconnected (BudgieIBusManager* self);
static void _budgie_ibus_manager_ibus_disconnected_ibus_bus_disconnected (IBusBus* _sender,
                                                                   gpointer self);
static void budgie_ibus_manager_startup_ibus (BudgieIBusManager* self);
static void budgie_ibus_manager_reset_ibus (BudgieIBusManager* self);
static void budgie_ibus_manager_on_engines_get (BudgieIBusManager* self,
                                         GObject* o,
                                         GAsyncResult* res);
static void _budgie_ibus_manager_on_engines_get_gasync_ready_callback (GObject* source_object,
                                                                GAsyncResult* res,
                                                                gpointer self);
VALA_EXTERN IBusEngineDesc* budgie_ibus_manager_get_engine (BudgieIBusManager* self,
                                                const gchar* name);
VALA_EXTERN void budgie_ibus_manager_set_engine (BudgieIBusManager* self,
                                     const gchar* name);
VALA_EXTERN BudgieKeyboardManager* budgie_ibus_manager_get_kbm (BudgieIBusManager* self);
VALA_EXTERN void budgie_keyboard_manager_release_keyboard (BudgieKeyboardManager* self);
static void __lambda4_ (BudgieIBusManager* self);
static void ___lambda4__gasync_ready_callback (GObject* source_object,
                                        GAsyncResult* res,
                                        gpointer self);
VALA_EXTERN void budgie_ibus_manager_set_kbm (BudgieIBusManager* self,
                                  BudgieKeyboardManager* value);
static void budgie_ibus_manager_finalize (GObject * obj);
static GType budgie_ibus_manager_get_type_once (void);
static void _vala_budgie_ibus_manager_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void _vala_budgie_ibus_manager_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
budgie_ibus_manager_get_instance_private (BudgieIBusManager* self)
{
	return G_STRUCT_MEMBER_P (self, BudgieIBusManager_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

/**
* Construct a new IBusManager which will begin setting up the
* ibus daemon, as well as registering events to connect to it
* and monitor it.
*/
BudgieIBusManager*
budgie_ibus_manager_construct (GType object_type,
                               BudgieKeyboardManager* kbm)
{
	BudgieIBusManager * self = NULL;
	self = (BudgieIBusManager*) g_object_new (object_type, "kbm", kbm, NULL);
	return self;
}

BudgieIBusManager*
budgie_ibus_manager_new (BudgieKeyboardManager* kbm)
{
	return budgie_ibus_manager_construct (BUDGIE_TYPE_IBUS_MANAGER, kbm);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_budgie_ibus_manager_ibus_connected_ibus_bus_connected (IBusBus* _sender,
                                                        gpointer self)
{
	budgie_ibus_manager_ibus_connected ((BudgieIBusManager*) self);
}

static void
_budgie_ibus_manager_ibus_disconnected_ibus_bus_disconnected (IBusBus* _sender,
                                                              gpointer self)
{
	budgie_ibus_manager_ibus_disconnected ((BudgieIBusManager*) self);
}

void
budgie_ibus_manager_do_init (BudgieIBusManager* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	GHashFunc _tmp3_;
	GEqualFunc _tmp4_;
	GHashTable* _tmp5_;
	IBusBus* _tmp6_;
	IBusBus* _tmp7_;
	IBusBus* _tmp8_;
	IBusBus* _tmp9_;
	IBusBus* _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_find_program_in_path ("ibus-daemon");
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_ == NULL;
	_g_free0 (_tmp1_);
	if (_tmp2_) {
		g_message ("ibus.vala:47: ibus-daemon unsupported on this system");
		self->priv->ibus_available = FALSE;
		g_signal_emit (self, budgie_ibus_manager_signals[BUDGIE_IBUS_MANAGER_READY_SIGNAL], 0);
		return;
	}
	_tmp3_ = g_str_hash;
	_tmp4_ = g_str_equal;
	_tmp5_ = g_hash_table_new_full (_tmp3_, _tmp4_, _g_free0_, NULL);
	_g_hash_table_unref0 (self->priv->engines);
	self->priv->engines = _tmp5_;
	_tmp6_ = ibus_bus_new ();
	g_object_ref_sink (_tmp6_);
	_g_object_unref0 (self->priv->bus);
	self->priv->bus = _tmp6_;
	_tmp7_ = self->priv->bus;
	g_signal_connect_object (_tmp7_, "connected", (GCallback) _budgie_ibus_manager_ibus_connected_ibus_bus_connected, self, 0);
	_tmp8_ = self->priv->bus;
	g_signal_connect_object (_tmp8_, "disconnected", (GCallback) _budgie_ibus_manager_ibus_disconnected_ibus_bus_disconnected, self, 0);
	_tmp9_ = self->priv->bus;
	ibus_bus_set_watch_dbus_signal (_tmp9_, TRUE);
	_tmp10_ = self->priv->bus;
	if (ibus_bus_is_connected (_tmp10_)) {
		budgie_ibus_manager_ibus_connected (self);
	} else {
		budgie_ibus_manager_startup_ibus (self);
	}
}

/**
* Launch the daemon as a child process so that it dies when we die
*/
static void
budgie_ibus_manager_startup_ibus (BudgieIBusManager* self)
{
	gchar** cmdline = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar** _tmp4_;
	gint cmdline_length1;
	gint _cmdline_size_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("ibus-daemon");
	_tmp1_ = g_strdup ("--xim");
	_tmp2_ = g_strdup ("--panel");
	_tmp3_ = g_strdup ("disable");
	_tmp4_ = g_new0 (gchar*, 4 + 1);
	_tmp4_[0] = _tmp0_;
	_tmp4_[1] = _tmp1_;
	_tmp4_[2] = _tmp2_;
	_tmp4_[3] = _tmp3_;
	cmdline = _tmp4_;
	cmdline_length1 = 4;
	_cmdline_size_ = cmdline_length1;
	{
		GSubprocess* _tmp5_;
		GSubprocess* _tmp6_;
		_tmp5_ = g_subprocess_newv (cmdline, G_SUBPROCESS_FLAGS_NONE, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp6_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		g_message ("ibus.vala:80: Failed to launch ibus: %s", _tmp8_);
		self->priv->ibus_available = FALSE;
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		cmdline = (_vala_array_free (cmdline, cmdline_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	cmdline = (_vala_array_free (cmdline, cmdline_length1, (GDestroyNotify) g_free), NULL);
}

/**
* Something on ibus changed so we'll reset our state
*/
static void
budgie_ibus_manager_reset_ibus (BudgieIBusManager* self)
{
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, NULL);
	_g_hash_table_unref0 (self->priv->engines);
	self->priv->engines = _tmp2_;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
budgie_ibus_manager_on_engines_get (BudgieIBusManager* self,
                                    GObject* o,
                                    GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GList* _tmp0_ = NULL;
		IBusBus* _tmp1_;
		GList* _tmp2_;
		GList* _tmp3_;
		GList* _tmp4_;
		_tmp1_ = self->priv->bus;
		_tmp2_ = ibus_bus_list_engines_async_finish (_tmp1_, res, &_inner_error0_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		(self->priv->enginelist == NULL) ? NULL : (self->priv->enginelist = (_g_list_free__g_object_unref0_ (self->priv->enginelist), NULL));
		self->priv->enginelist = _tmp3_;
		budgie_ibus_manager_reset_ibus (self);
		_tmp4_ = self->priv->enginelist;
		{
			GList* engine_collection = NULL;
			GList* engine_it = NULL;
			engine_collection = _tmp4_;
			for (engine_it = engine_collection; engine_it != NULL; engine_it = engine_it->next) {
				IBusEngineDesc* _tmp5_;
				IBusEngineDesc* engine = NULL;
				_tmp5_ = _g_object_ref0 ((IBusEngineDesc*) engine_it->data);
				engine = _tmp5_;
				{
					GHashTable* _tmp6_;
					IBusEngineDesc* _tmp7_;
					const gchar* _tmp8_;
					gchar* _tmp9_;
					IBusEngineDesc* _tmp10_;
					_tmp6_ = self->priv->engines;
					_tmp7_ = engine;
					_tmp8_ = ibus_engine_desc_get_name (_tmp7_);
					_tmp9_ = g_strdup (_tmp8_);
					_tmp10_ = engine;
					g_hash_table_insert (_tmp6_, _tmp9_, _tmp10_);
					_g_object_unref0 (engine);
				}
			}
		}
		(_tmp0_ == NULL) ? NULL : (_tmp0_ = (_g_list_free__g_object_unref0_ (_tmp0_), NULL));
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp11_;
		const gchar* _tmp12_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		g_message ("ibus.vala:101: Failed to get engines: %s", _tmp12_);
		budgie_ibus_manager_reset_ibus (self);
		_g_error_free0 (e);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	g_signal_emit (self, budgie_ibus_manager_signals[BUDGIE_IBUS_MANAGER_READY_SIGNAL], 0);
}

/**
* We gained connection to the ibus daemon
*/
static void
_budgie_ibus_manager_on_engines_get_gasync_ready_callback (GObject* source_object,
                                                           GAsyncResult* res,
                                                           gpointer self)
{
	budgie_ibus_manager_on_engines_get ((BudgieIBusManager*) self, source_object, res);
	g_object_unref (self);
}

static void
budgie_ibus_manager_ibus_connected (BudgieIBusManager* self)
{
	IBusBus* _tmp0_;
	g_return_if_fail (self != NULL);
	if (!self->priv->did_ibus_init) {
		ibus_init ();
		self->priv->did_ibus_init = TRUE;
	}
	_tmp0_ = self->priv->bus;
	ibus_bus_list_engines_async (_tmp0_, -1, NULL, _budgie_ibus_manager_on_engines_get_gasync_ready_callback, g_object_ref (self));
}

/**
* Lost connection to ibus
*/
static void
budgie_ibus_manager_ibus_disconnected (BudgieIBusManager* self)
{
	g_return_if_fail (self != NULL);
	budgie_ibus_manager_reset_ibus (self);
}

/**
* Attempt to grab the ibus engine for the given name if it
* exists, or returns null
*/
IBusEngineDesc*
budgie_ibus_manager_get_engine (BudgieIBusManager* self,
                                const gchar* name)
{
	GHashTable* _tmp0_;
	GHashTable* _tmp1_;
	gconstpointer _tmp2_;
	IBusEngineDesc* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->priv->engines;
	if (_tmp0_ == NULL) {
		result = NULL;
		return result;
	}
	_tmp1_ = self->priv->engines;
	_tmp2_ = g_hash_table_lookup (_tmp1_, name);
	result = (IBusEngineDesc*) _tmp2_;
	return result;
}

/**
* Set the ibus engine to the specified engine name
*/
static void
__lambda4_ (BudgieIBusManager* self)
{
	BudgieKeyboardManager* _tmp0_;
	_tmp0_ = self->priv->_kbm;
	budgie_keyboard_manager_release_keyboard (_tmp0_);
}

static void
___lambda4__gasync_ready_callback (GObject* source_object,
                                   GAsyncResult* res,
                                   gpointer self)
{
	__lambda4_ ((BudgieIBusManager*) self);
	g_object_unref (self);
}

void
budgie_ibus_manager_set_engine (BudgieIBusManager* self,
                                const gchar* name)
{
	IBusBus* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	if (!self->priv->ibus_available) {
		BudgieKeyboardManager* _tmp0_;
		_tmp0_ = self->priv->_kbm;
		budgie_keyboard_manager_release_keyboard (_tmp0_);
		return;
	}
	_tmp1_ = self->priv->bus;
	ibus_bus_set_global_engine_async (_tmp1_, name, BUDGIE_IBUS_MANAGER_ENGINE_SET_TIMEOUT, NULL, ___lambda4__gasync_ready_callback, g_object_ref (self));
}

BudgieKeyboardManager*
budgie_ibus_manager_get_kbm (BudgieIBusManager* self)
{
	BudgieKeyboardManager* result;
	BudgieKeyboardManager* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_kbm;
	result = _tmp0_;
	return result;
}

void
budgie_ibus_manager_set_kbm (BudgieIBusManager* self,
                             BudgieKeyboardManager* value)
{
	BudgieKeyboardManager* old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_ibus_manager_get_kbm (self);
	if (old_value != value) {
		self->priv->_kbm = value;
		g_object_notify_by_pspec ((GObject *) self, budgie_ibus_manager_properties[BUDGIE_IBUS_MANAGER_KBM_PROPERTY]);
	}
}

static void
budgie_ibus_manager_class_init (BudgieIBusManagerClass * klass,
                                gpointer klass_data)
{
	budgie_ibus_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BudgieIBusManager_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_budgie_ibus_manager_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_budgie_ibus_manager_set_property;
	G_OBJECT_CLASS (klass)->finalize = budgie_ibus_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_IBUS_MANAGER_KBM_PROPERTY, budgie_ibus_manager_properties[BUDGIE_IBUS_MANAGER_KBM_PROPERTY] = g_param_spec_object ("kbm", "kbm", "kbm", BUDGIE_TYPE_KEYBOARD_MANAGER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	* Ensure that owning process knows we're up and running
	*/
	budgie_ibus_manager_signals[BUDGIE_IBUS_MANAGER_READY_SIGNAL] = g_signal_new ("ready", BUDGIE_TYPE_IBUS_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
budgie_ibus_manager_instance_init (BudgieIBusManager * self,
                                   gpointer klass)
{
	self->priv = budgie_ibus_manager_get_instance_private (self);
	self->priv->bus = NULL;
	self->priv->ibus_available = TRUE;
	self->priv->engines = NULL;
	self->priv->enginelist = NULL;
	self->priv->did_ibus_init = FALSE;
}

static void
budgie_ibus_manager_finalize (GObject * obj)
{
	BudgieIBusManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_IBUS_MANAGER, BudgieIBusManager);
	_g_object_unref0 (self->priv->bus);
	_g_hash_table_unref0 (self->priv->engines);
	(self->priv->enginelist == NULL) ? NULL : (self->priv->enginelist = (_g_list_free__g_object_unref0_ (self->priv->enginelist), NULL));
	G_OBJECT_CLASS (budgie_ibus_manager_parent_class)->finalize (obj);
}

/**
* IBusManager is responsible for interfacing with the ibus daemon
* under Budgie Desktop, enabling extra input sources to be used
* when using the ibus XIM daemon
*/
static GType
budgie_ibus_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieIBusManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_ibus_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieIBusManager), 0, (GInstanceInitFunc) budgie_ibus_manager_instance_init, NULL };
	GType budgie_ibus_manager_type_id;
	budgie_ibus_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "BudgieIBusManager", &g_define_type_info, 0);
	BudgieIBusManager_private_offset = g_type_add_instance_private (budgie_ibus_manager_type_id, sizeof (BudgieIBusManagerPrivate));
	return budgie_ibus_manager_type_id;
}

GType
budgie_ibus_manager_get_type (void)
{
	static volatile gsize budgie_ibus_manager_type_id__once = 0;
	if (g_once_init_enter (&budgie_ibus_manager_type_id__once)) {
		GType budgie_ibus_manager_type_id;
		budgie_ibus_manager_type_id = budgie_ibus_manager_get_type_once ();
		g_once_init_leave (&budgie_ibus_manager_type_id__once, budgie_ibus_manager_type_id);
	}
	return budgie_ibus_manager_type_id__once;
}

static void
_vala_budgie_ibus_manager_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	BudgieIBusManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_TYPE_IBUS_MANAGER, BudgieIBusManager);
	switch (property_id) {
		case BUDGIE_IBUS_MANAGER_KBM_PROPERTY:
		g_value_set_object (value, budgie_ibus_manager_get_kbm (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_budgie_ibus_manager_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec)
{
	BudgieIBusManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_TYPE_IBUS_MANAGER, BudgieIBusManager);
	switch (property_id) {
		case BUDGIE_IBUS_MANAGER_KBM_PROPERTY:
		budgie_ibus_manager_set_kbm (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

