/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.lexer.yacc;

import java.io.IOException;
import org.jruby.ast.StrNode;
import org.jruby.lexer.yacc.RubyLexer;
import org.jruby.lexer.yacc.StrTerm;
import org.jruby.lexer.yacc.StringTerm;
import org.jruby.util.ByteList;

public class HeredocTerm
extends StrTerm {
    private final ByteList nd_lit;
    private final int flags;
    protected final int nth;
    protected final int line;
    protected final ByteList lastLine;

    public HeredocTerm(ByteList marker, int func, int nth, int line, ByteList lastLine) {
        this.nd_lit = marker;
        this.flags = func;
        this.nth = nth;
        this.line = line;
        this.lastLine = lastLine;
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    protected int error(RubyLexer lexer, int len, ByteList str, ByteList eos) {
        lexer.compile_error("can't find string \"" + eos.toString() + "\" anywhere before EOF");
        return -1;
    }

    protected int restore(RubyLexer lexer) {
        lexer.heredoc_restore(this);
        lexer.setStrTerm(new StringTerm(this.flags | 0x8000, 0, 0, this.line));
        return -1;
    }

    @Override
    public int parseString(RubyLexer lexer) throws IOException {
        ByteList str = null;
        ByteList eos = this.nd_lit;
        int len = this.nd_lit.length() - 1;
        boolean indent = (this.flags & 0x20) != 0;
        int c = lexer.nextc();
        if (c == -1) {
            return this.error(lexer, len, str, eos);
        }
        boolean bol = lexer.was_bol();
        if (bol) {
            int line_indent = lexer.getHeredocLineIndent();
            if (line_indent != -1) {
                if (lexer.whole_match_p(this.nd_lit, indent)) {
                    lexer.heredoc_restore(this);
                    lexer.setStrTerm(null);
                    lexer.setState(2);
                    return 373;
                }
            } else {
                lexer.setHeredocLineIndent(0);
            }
        }
        if ((this.flags & 2) == 0) {
            do {
                ByteList lbuf = lexer.lex_lastline;
                int pend = lexer.lex_pend;
                int p2 = 0;
                if (pend > p2) {
                    switch (lexer.p(pend - 1)) {
                        case 10: {
                            if (--pend != p2 && lexer.p(pend - 1) != 13) break;
                            ++pend;
                            break;
                        }
                        case 13: {
                            --pend;
                        }
                    }
                }
                if (lexer.getHeredocIndent() > 0) {
                    int i2 = 0;
                    while (p2 + i2 < pend && lexer.update_heredoc_indent(lexer.p(p2 + i2))) {
                        ++i2;
                    }
                    lexer.setHeredocLineIndent(0);
                }
                if (str != null) {
                    str.append(lbuf.makeShared(p2, pend - p2));
                } else {
                    str = new ByteList(lbuf.makeShared(p2, pend - p2));
                }
                if (pend < lexer.lex_pend) {
                    str.append(10);
                }
                lexer.lex_goto_eol();
                if (lexer.getHeredocIndent() > 0) {
                    return this.flush(lexer, bol, str);
                }
                if (lexer.nextc() != -1) continue;
                return this.error(lexer, len, null, eos);
            } while (!lexer.whole_match_p(eos, indent));
        } else {
            ByteList tok = new ByteList();
            tok.setEncoding(lexer.getEncoding());
            if (c == 35) {
                int token = lexer.peekVariableName(372, 371);
                int heredoc_line_indent = lexer.getHeredocLineIndent();
                if (heredoc_line_indent != -1) {
                    if (lexer.getHeredocIndent() > heredoc_line_indent) {
                        lexer.setHeredocIndent(heredoc_line_indent);
                    }
                    lexer.setHeredocLineIndent(-1);
                }
                if (token != 0) {
                    return token;
                }
                tok.append(35);
            }
            boolean[] encodingDetermined = new boolean[]{false};
            do {
                lexer.pushback(c);
                c = new StringTerm(this.flags, 0, 10, lexer.getRubySourceline()).parseStringIntoBuffer(lexer, tok, lexer.getEncoding(), encodingDetermined);
                if (c == -1) {
                    if (lexer.eofp) {
                        return this.error(lexer, len, str, eos);
                    }
                    return this.restore(lexer);
                }
                if (c != 10) {
                    if (c == 92) {
                        lexer.setHeredocLineIndent(-1);
                    }
                    return this.flush(lexer, bol, tok);
                }
                tok.append(lexer.nextc());
                if (lexer.getHeredocIndent() > 0) {
                    lexer.lex_goto_eol();
                    return this.flush(lexer, bol, tok);
                }
                c = lexer.nextc();
                if (c != -1) continue;
                return this.error(lexer, len, str, eos);
            } while (!lexer.whole_match_p(eos, indent));
            str = tok;
        }
        lexer.pushback(c);
        lexer.heredoc_restore(this);
        lexer.setStrTerm(new StringTerm(this.flags | 0x8000, 0, 0, this.line));
        return this.flush(lexer, bol, str);
    }

    private int flush(RubyLexer lexer, boolean bol, ByteList tok) {
        StrNode node = lexer.createStr(tok, 0);
        lexer.setValue(node);
        if (bol) {
            node.setNewline();
        }
        return 378;
    }
}

