import * as lsp from 'vscode-languageserver';
import type tsp from 'typescript/lib/protocol.js';
import { LspDocument } from './document.js';
import { TspClient } from './tsp-client.js';
import { CompletionOptions, SupportedFeatures } from './ts-protocol.js';
interface TSCompletionItem extends lsp.CompletionItem {
    data: tsp.CompletionDetailsRequestArgs;
}
export declare function asCompletionItem(entry: tsp.CompletionEntry, file: string, position: lsp.Position, document: LspDocument, features: SupportedFeatures): TSCompletionItem;
export declare function asResolvedCompletionItem(item: lsp.CompletionItem, details: tsp.CompletionEntryDetails, client: TspClient, options: CompletionOptions): Promise<lsp.CompletionItem>;
export declare function isValidFunctionCompletionContext(filepath: string, position: lsp.Position, client: TspClient): Promise<boolean>;
export declare function getCompletionTriggerCharacter(character: string | undefined): tsp.CompletionsTriggerCharacter | undefined;
export {};
//# sourceMappingURL=completion.d.ts.map