/*
 * Copyright (C) 2017, 2018 TypeFox and others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import * as chai from 'chai';
import { TspClient } from './tsp-client.js';
import { ConsoleLogger } from './logger.js';
import { filePath, readContents } from './test-utils.js';
import { TypeScriptVersionProvider } from './utils/versionProvider.js';
const assert = chai.assert;
const typescriptVersionProvider = new TypeScriptVersionProvider();
const bundled = typescriptVersionProvider.bundledVersion();
let server;
before(() => {
    server = new TspClient({
        logger: new ConsoleLogger(),
        tsserverPath: bundled.tsServerPath
    });
});
after(() => {
    server.shutdown();
});
describe('ts server client', () => {
    before(() => {
        server.start();
    });
    it('completion', () => __awaiter(void 0, void 0, void 0, function* () {
        const f = filePath('module2.ts');
        server.notify("open" /* CommandTypes.Open */, {
            file: f,
            fileContent: readContents(f)
        });
        const completions = yield server.request("completionInfo" /* CommandTypes.CompletionInfo */, {
            file: f,
            line: 1,
            offset: 0,
            prefix: 'im'
        });
        assert.isDefined(completions.body);
        assert.equal(completions.body.entries[1].name, 'ImageBitmap');
    }));
    it('references', () => __awaiter(void 0, void 0, void 0, function* () {
        const f = filePath('module2.ts');
        server.notify("open" /* CommandTypes.Open */, {
            file: f,
            fileContent: readContents(f)
        });
        const references = yield server.request("references" /* CommandTypes.References */, {
            file: f,
            line: 8,
            offset: 16
        });
        assert.isDefined(references.body);
        assert.equal(references.body.symbolName, 'doStuff');
    }));
    it('inlayHints', () => __awaiter(void 0, void 0, void 0, function* () {
        const f = filePath('module2.ts');
        server.notify("open" /* CommandTypes.Open */, {
            file: f,
            fileContent: readContents(f)
        });
        yield server.request("configure" /* CommandTypes.Configure */, {
            preferences: {
                includeInlayFunctionLikeReturnTypeHints: true
            }
        });
        const inlayHints = yield server.request("provideInlayHints" /* CommandTypes.ProvideInlayHints */, {
            file: f,
            start: 0,
            length: 1000
        });
        assert.isDefined(inlayHints.body);
        assert.equal(inlayHints.body[0].text, ': boolean');
    }));
    it('documentHighlight', () => __awaiter(void 0, void 0, void 0, function* () {
        const f = filePath('module2.ts');
        server.notify("open" /* CommandTypes.Open */, {
            file: f,
            fileContent: readContents(f)
        });
        const response = yield server.request("documentHighlights" /* CommandTypes.DocumentHighlights */, {
            file: f,
            line: 8,
            offset: 16,
            filesToSearch: [f]
        });
        assert.isDefined(response.body);
        assert.isTrue(response.body.some(({ file }) => file.endsWith('module2.ts')), JSON.stringify(response.body, undefined, 2));
        assert.isFalse(response.body.some(({ file: file_1 }) => file_1.endsWith('module1.ts')), JSON.stringify(response.body, undefined, 2));
    }));
});
//# sourceMappingURL=tsp-client.spec.js.map