import { Event } from './event';
import { SentryRequestType } from './request';
import { SdkInfo } from './sdkinfo';
import { Session, SessionAggregates } from './session';
import { Outcome } from './transport';
import { User } from './user';
declare type CommonEnvelopeHeaders = {
    dsn?: string;
    sdk?: SdkInfo;
};
declare type CommonEnvelopeItemHeaders = {
    length?: number;
};
/**
 * 1st Item: Item headers
 * 2nd Item: Item payload
 */
declare type BaseEnvelopeItem<ItemHeader extends {
    type: string;
}, Payload = unknown> = [CommonEnvelopeItemHeaders & ItemHeader, Payload];
declare type UnknownEnvelopeItem = BaseEnvelopeItem<{
    type: '__unknown__';
}>;
declare type BaseEnvelope<EnvelopeHeaders extends Record<string, unknown>, EnvelopeItem extends BaseEnvelopeItem<{
    type: string;
}>> = {
    headers: CommonEnvelopeHeaders & EnvelopeHeaders;
    items: Array<EnvelopeItem | UnknownEnvelopeItem>;
};
export declare type EventEnvelopeItem = BaseEnvelopeItem<{
    type: 'event' | 'transaction';
}, Event>;
declare type AttachmentEnvelopeItem = BaseEnvelopeItem<{
    type: 'attachment';
    filename: 'string';
}>;
declare type UserFeedbackEnvelopeItem = BaseEnvelopeItem<{
    type: 'user_report';
}, {
    event_id: string;
    email: User['email'];
    name: string;
    comments: string;
}>;
export declare type EventEnvelope = BaseEnvelope<{
    event_id: string;
    sent_at: string;
}, EventEnvelopeItem | AttachmentEnvelopeItem | UserFeedbackEnvelopeItem>;
export declare type SessionEnvelopeItem = BaseEnvelopeItem<{
    type: 'session';
}, Session> | BaseEnvelopeItem<{
    type: 'sessions';
}, SessionAggregates>;
export declare type SessionEnvelope = BaseEnvelope<{
    sent_at: string;
}, SessionEnvelopeItem>;
export declare type ClientReportEnvelopeItem = BaseEnvelopeItem<{
    type: 'client_report';
}, {
    timestamp: number;
    discarded_events: {
        reason: Outcome;
        category: SentryRequestType;
        quantity: number;
    };
}>;
export declare type ClientReportEnvelope = BaseEnvelope<Record<string, unknown>, ClientReportEnvelopeItem>;
export declare type Envelope = EventEnvelope | SessionEnvelope | ClientReportEnvelope;
export {};
//# sourceMappingURL=envelope.d.ts.map