import { MatrixClient } from "../MatrixClient";
import { UserDevice } from "../models/Crypto";
/**
 * Tracks user devices for encryption operations.
 * @category Encryption
 */
export declare class DeviceTracker {
    private client;
    private deviceListUpdates;
    constructor(client: MatrixClient);
    /**
     * Gets the device lists for the given user IDs. Outdated device lists will be updated before
     * returning.
     * @param {string[]} userIds The user IDs to get the device lists of.
     * @returns {Promise<Record<string, UserDevice[]>>} Resolves to a map of user ID to device list.
     * If a user has no devices, they may be excluded from the result or appear as an empty array.
     */
    getDevicesFor(userIds: string[]): Promise<Record<string, UserDevice[]>>;
    /**
     * Flags multiple user's device lists as outdated, optionally queuing an immediate update.
     * @param {string} userIds The user IDs to flag the device lists of.
     * @param {boolean} resync True (default) to queue an immediate update, false otherwise.
     * @returns {Promise<void>} Resolves when the flagging has completed. Will wait for the resync
     * if requested too.
     */
    flagUsersOutdated(userIds: string[], resync?: boolean): Promise<void>;
    /**
     * Updates multiple user's device lists regardless of outdated flag.
     * @param {string[]} userIds The user IDs to update.
     * @returns {Promise<void>} Resolves when complete.
     */
    updateUsersDeviceLists(userIds: string[]): Promise<void>;
}
