/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.j3d;

import com.eteks.sweethome3d.j3d.Object3DBranch;
import com.eteks.sweethome3d.j3d.ShapeTools;
import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.Polyline;
import com.sun.j3d.utils.geometry.GeometryInfo;
import java.awt.BasicStroke;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.Group;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

public class Polyline3D
extends Object3DBranch {
    private static final PolygonAttributes DEFAULT_POLYGON_ATTRIBUTES = new PolygonAttributes(2, 0, 0.0f, false);
    private static final GeneralPath ARROW = new GeneralPath();

    public Polyline3D(Polyline polyline, Home home) {
        this.setUserData(polyline);
        this.setCapability(17);
        this.setCapability(12);
        this.setCapability(13);
        this.setCapability(14);
        this.update();
    }

    @Override
    public void update() {
        Polyline polyline = (Polyline)this.getUserData();
        if (polyline.isVisibleIn3D() && (polyline.getLevel() == null || polyline.getLevel().isViewableAndVisible())) {
            BranchGroup branchGroup;
            Object object2;
            Stroke stroke = ShapeTools.getStroke(polyline.getThickness(), polyline.getCapStyle(), polyline.getJoinStyle(), polyline.getDashStyle() != Polyline.DashStyle.SOLID ? polyline.getDashPattern() : null, polyline.getDashOffset());
            Shape shape = ShapeTools.getPolylineShape(polyline.getPoints(), polyline.getJoinStyle() == Polyline.JoinStyle.CURVED, polyline.isClosedPath());
            float[] fArray = null;
            float[] fArray2 = null;
            float[] fArray3 = null;
            float[] fArray4 = null;
            PathIterator pathIterator = shape.getPathIterator(null, 0.5);
            while (!pathIterator.isDone()) {
                float[] fArray5 = new float[2];
                if (pathIterator.currentSegment(fArray5) != 4) {
                    if (fArray == null) {
                        fArray = fArray5;
                    } else if (fArray2 == null) {
                        fArray2 = fArray5;
                    }
                    fArray3 = fArray4;
                    fArray4 = fArray5;
                }
                pathIterator.next();
            }
            float f = (float)Math.atan2((double)(fArray[1] - fArray2[1]), (double)(fArray[0] - fArray2[0]));
            float f2 = (float)Math.atan2(fArray4[1] - fArray3[1], fArray4[0] - fArray3[0]);
            float f3 = polyline.getCapStyle() != Polyline.CapStyle.BUTT ? polyline.getThickness() / 2.0f : 0.0f;
            Shape[] shapeArray = new Shape[]{this.getArrowShape(fArray, f, polyline.getStartArrowStyle(), polyline.getThickness(), f3), this.getArrowShape(fArray4, f2, polyline.getEndArrowStyle(), polyline.getThickness(), f3), stroke.createStrokedShape(shape)};
            Area area = new Area();
            for (Shape shape2 : shapeArray) {
                if (shape2 == null) continue;
                area.add(new Area(shape2));
            }
            ArrayList arrayList = new ArrayList(4);
            List<float[][]> list = this.getAreaPoints(area, 0.5f, false);
            int[] nArray = new int[list.size()];
            int n = 0;
            for (int i = 0; i < list.size(); ++i) {
                for (Object object2 : list.get(i)) {
                    arrayList.add(new Point3f(object2[0], 0.0f, object2[1]));
                }
                nArray[i] = arrayList.size() - n;
                n = arrayList.size();
            }
            GeometryInfo geometryInfo = new GeometryInfo(5);
            geometryInfo.setCoordinates(arrayList.toArray(new Point3f[arrayList.size()]));
            Object[] objectArray = new Vector3f[arrayList.size()];
            Arrays.fill(objectArray, new Vector3f(0.0f, 1.0f, 0.0f));
            geometryInfo.setNormals((Vector3f[])objectArray);
            geometryInfo.setStripCounts(nArray);
            GeometryArray geometryArray = geometryInfo.getGeometryArray(true, true, false);
            if (this.numChildren() == 0) {
                branchGroup = new BranchGroup();
                branchGroup.setCapability(12);
                branchGroup.setCapability(17);
                object2 = new TransformGroup();
                object2.setCapability(18);
                object2.setCapability(12);
                branchGroup.addChild((Node)object2);
                Appearance appearance = new Appearance();
                appearance.setMaterial(this.getMaterial(DEFAULT_COLOR, DEFAULT_AMBIENT_COLOR, 0.0f));
                appearance.setCapability(1);
                appearance.setPolygonAttributes(DEFAULT_POLYGON_ATTRIBUTES);
                Shape3D shape3D = new Shape3D((Geometry)geometryArray, appearance);
                shape3D.setCapability(13);
                shape3D.setCapability(14);
                object2.addChild((Node)shape3D);
                this.addChild((Node)branchGroup);
            } else {
                branchGroup = (Shape3D)((TransformGroup)((Group)this.getChild(0)).getChild(0)).getChild(0);
                branchGroup.setGeometry((Geometry)geometryArray);
            }
            branchGroup = (TransformGroup)((Group)this.getChild(0)).getChild(0);
            object2 = new Transform3D();
            object2.setTranslation(new Vector3d(0.0, (double)(polyline.getGroundElevation() + (polyline.getElevation() < 0.05f ? 0.05f : 0.0f)), 0.0));
            branchGroup.setTransform((Transform3D)object2);
            ((Shape3D)branchGroup.getChild(0)).getAppearance().setMaterial(this.getMaterial(polyline.getColor(), polyline.getColor(), 0.0f));
        } else {
            this.removeAllChildren();
        }
    }

    private Shape getArrowShape(float[] fArray, float f, Polyline.ArrowStyle arrowStyle, float f2, float f3) {
        if (arrowStyle != null && arrowStyle != Polyline.ArrowStyle.NONE) {
            AffineTransform affineTransform = AffineTransform.getTranslateInstance(fArray[0], fArray[1]);
            affineTransform.rotate(f);
            affineTransform.translate(f3, 0.0);
            double d = Math.pow(f2, 0.66f) * 2.0;
            affineTransform.scale(d, d);
            GeneralPath generalPath = new GeneralPath();
            switch (arrowStyle) {
                case DISC: {
                    generalPath.append(new Ellipse2D.Float(-3.5f, -2.0f, 4.0f, 4.0f), false);
                    break;
                }
                case OPEN: {
                    BasicStroke basicStroke = new BasicStroke((float)((double)f2 / d / 0.9), 0, 0);
                    generalPath.append(basicStroke.createStrokedShape(ARROW).getPathIterator(AffineTransform.getScaleInstance(0.9, 0.9), 0.0), false);
                    break;
                }
                case DELTA: {
                    GeneralPath generalPath2 = new GeneralPath(ARROW);
                    generalPath2.closePath();
                    generalPath.append(generalPath2.getPathIterator(AffineTransform.getTranslateInstance(1.65f, 0.0), 0.0), false);
                    break;
                }
                default: {
                    return null;
                }
            }
            return generalPath.createTransformedShape(affineTransform);
        }
        return null;
    }

    static {
        ARROW.moveTo(-5.0f, -2.0f);
        ARROW.lineTo(0.0f, 0.0f);
        ARROW.lineTo(-5.0f, 2.0f);
    }
}

