/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import com.eteks.sweethome3d.j3d.ModelManager;
import com.eteks.sweethome3d.model.Transformation;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.swing.AutoCompleteTextField;
import com.eteks.sweethome3d.swing.ColorButton;
import com.eteks.sweethome3d.swing.ImportedFurnitureWizardStepsPanel;
import com.eteks.sweethome3d.swing.ModelPreviewComponent;
import com.eteks.sweethome3d.swing.NullableCheckBox;
import com.eteks.sweethome3d.swing.NullableSpinner;
import com.eteks.sweethome3d.swing.SwingTools;
import com.eteks.sweethome3d.tools.OperatingSystem;
import com.eteks.sweethome3d.viewcontroller.DialogView;
import com.eteks.sweethome3d.viewcontroller.HomeFurnitureController;
import com.eteks.sweethome3d.viewcontroller.ModelMaterialsController;
import com.eteks.sweethome3d.viewcontroller.TextureChoiceController;
import com.eteks.sweethome3d.viewcontroller.View;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.security.AccessControlException;
import java.text.DecimalFormat;
import java.text.Format;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;
import javax.swing.AbstractAction;
import javax.swing.AbstractSpinnerModel;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class HomeFurniturePanel
extends JPanel
implements DialogView {
    private final HomeFurnitureController controller;
    private JLabel nameLabel;
    private JTextField nameTextField;
    private JLabel descriptionLabel;
    private JTextField descriptionTextField;
    private NullableCheckBox nameVisibleCheckBox;
    private JLabel priceLabel;
    private JSpinner priceSpinner;
    private JLabel valueAddedTaxPercentageLabel;
    private JSpinner valueAddedTaxPercentageSpinner;
    private JLabel xLabel;
    private JSpinner xSpinner;
    private JLabel yLabel;
    private JSpinner ySpinner;
    private JLabel elevationLabel;
    private JSpinner elevationSpinner;
    private NullableCheckBox basePlanItemCheckBox;
    private JLabel angleLabel;
    private JSpinner angleSpinner;
    private JRadioButton rollRadioButton;
    private JSpinner rollSpinner;
    private JRadioButton pitchRadioButton;
    private JSpinner pitchSpinner;
    private JLabel widthLabel;
    private JSpinner widthSpinner;
    private JLabel depthLabel;
    private JSpinner depthSpinner;
    private JLabel heightLabel;
    private JSpinner heightSpinner;
    private JCheckBox keepProportionsCheckBox;
    private NullableCheckBox mirroredModelCheckBox;
    private JButton modelTransformationsButton;
    private JRadioButton defaultColorAndTextureRadioButton;
    private JRadioButton colorRadioButton;
    private ColorButton colorButton;
    private JRadioButton textureRadioButton;
    private JComponent textureComponent;
    private JRadioButton modelMaterialsRadioButton;
    private JComponent modelMaterialsComponent;
    private JRadioButton defaultShininessRadioButton;
    private JRadioButton mattRadioButton;
    private JRadioButton shinyRadioButton;
    private NullableCheckBox visibleCheckBox;
    private JLabel lightPowerLabel;
    private JSpinner lightPowerSpinner;
    private String dialogTitle;

    public HomeFurniturePanel(UserPreferences userPreferences, HomeFurnitureController homeFurnitureController) {
        super(new GridBagLayout());
        this.controller = homeFurnitureController;
        this.createComponents(userPreferences, homeFurnitureController);
        this.setMnemonics(userPreferences);
        this.layoutComponents(userPreferences, homeFurnitureController);
    }

    private void createComponents(final UserPreferences userPreferences, final HomeFurnitureController homeFurnitureController) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        String string = userPreferences.getLengthUnit().getName();
        if (homeFurnitureController.isPropertyEditable(HomeFurnitureController.Property.NAME)) {
            this.nameLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, HomeFurniturePanel.class, "nameLabel.text", new Object[0]));
            this.nameTextField = new AutoCompleteTextField(homeFurnitureController.getName(), 15, userPreferences.getAutoCompletionStrings("HomePieceOfFurnitureName"));
            if (!OperatingSystem.isMacOSXLeopardOrSuperior()) {
                SwingTools.addAutoSelectionOnFocusGain(this.nameTextField);
            }
            object5 = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    HomeFurniturePanel.this.nameTextField.setText(homeFurnitureController.getName());
                }
            };
            homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.NAME, (PropertyChangeListener)object5);
            this.nameTextField.getDocument().addDocumentListener(new DocumentListener((PropertyChangeListener)object5){
                final /* synthetic */ PropertyChangeListener val$nameChangeListener;
                {
                    this.val$nameChangeListener = propertyChangeListener;
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    homeFurnitureController.removePropertyChangeListener(HomeFurnitureController.Property.NAME, this.val$nameChangeListener);
                    String string = HomeFurniturePanel.this.nameTextField.getText();
                    if (string == null || string.trim().length() == 0) {
                        homeFurnitureController.setName(null);
                    } else {
                        homeFurnitureController.setName(string);
                    }
                    homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.NAME, this.val$nameChangeListener);
                }

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    this.changedUpdate(documentEvent);
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    this.changedUpdate(documentEvent);
                }
            });
        }
        if (homeFurnitureController.isPropertyEditable(HomeFurnitureController.Property.NAME_VISIBLE)) {
            this.nameVisibleCheckBox = new NullableCheckBox(SwingTools.getLocalizedLabelText(userPreferences, HomeFurniturePanel.class, "nameVisibleCheckBox.text", new Object[0]));
            this.nameVisibleCheckBox.setNullable(homeFurnitureController.getNameVisible() == null);
            this.nameVisibleCheckBox.setValue(homeFurnitureController.getNameVisible());
            object5 = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    HomeFurniturePanel.this.nameVisibleCheckBox.setNullable(propertyChangeEvent.getNewValue() == null);
                    HomeFurniturePanel.this.nameVisibleCheckBox.setValue((Boolean)propertyChangeEvent.getNewValue());
                }
            };
            homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.NAME_VISIBLE, (PropertyChangeListener)object5);
            this.nameVisibleCheckBox.addChangeListener(new ChangeListener((PropertyChangeListener)object5){
                final /* synthetic */ PropertyChangeListener val$nameVisibleChangeListener;
                {
                    this.val$nameVisibleChangeListener = propertyChangeListener;
                }

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    homeFurnitureController.removePropertyChangeListener(HomeFurnitureController.Property.NAME_VISIBLE, this.val$nameVisibleChangeListener);
                    homeFurnitureController.setNameVisible(HomeFurniturePanel.this.nameVisibleCheckBox.getValue());
                    homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.NAME_VISIBLE, this.val$nameVisibleChangeListener);
                }
            });
        }
        if (homeFurnitureController.isPropertyEditable(HomeFurnitureController.Property.DESCRIPTION)) {
            this.descriptionLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, HomeFurniturePanel.class, "descriptionLabel.text", new Object[0]));
            this.descriptionTextField = new AutoCompleteTextField(homeFurnitureController.getDescription(), 15, userPreferences.getAutoCompletionStrings("HomePieceOfFurnitureDescription"));
            if (!OperatingSystem.isMacOSXLeopardOrSuperior()) {
                SwingTools.addAutoSelectionOnFocusGain(this.descriptionTextField);
            }
            object5 = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    HomeFurniturePanel.this.descriptionTextField.setText(homeFurnitureController.getDescription());
                }
            };
            homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.DESCRIPTION, (PropertyChangeListener)object5);
            this.descriptionTextField.getDocument().addDocumentListener(new DocumentListener((PropertyChangeListener)object5){
                final /* synthetic */ PropertyChangeListener val$descriptionChangeListener;
                {
                    this.val$descriptionChangeListener = propertyChangeListener;
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    homeFurnitureController.removePropertyChangeListener(HomeFurnitureController.Property.DESCRIPTION, this.val$descriptionChangeListener);
                    String string = HomeFurniturePanel.this.descriptionTextField.getText();
                    if (string == null || string.trim().length() == 0) {
                        homeFurnitureController.setDescription(null);
                    } else {
                        homeFurnitureController.setDescription(string);
                    }
                    homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.DESCRIPTION, this.val$descriptionChangeListener);
                }

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    this.changedUpdate(documentEvent);
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    this.changedUpdate(documentEvent);
                }
            });
        }
        if (homeFurnitureController.isPropertyEditable(HomeFurnitureController.Property.PRICE)) {
            this.priceLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, HomeFurniturePanel.class, "priceLabel.text", new Object[0]));
            object5 = new NullableSpinner.NullableSpinnerNumberModel(BigDecimal.ZERO, BigDecimal.ZERO, new BigDecimal("1000000000"), BigDecimal.ONE);
            this.priceSpinner = new NullableSpinner((NullableSpinner.NullableSpinnerNumberModel)object5);
            object4 = homeFurnitureController.getPrice();
            ((NullableSpinner.NullableSpinnerNumberModel)object5).setNullable(true);
            ((NullableSpinner.NullableSpinnerNumberModel)object5).setValue(object4);
            object3 = new PropertyChangeListener((NullableSpinner.NullableSpinnerNumberModel)object5){
                final /* synthetic */ NullableSpinner.NullableSpinnerNumberModel val$priceSpinnerModel;
                {
                    this.val$priceSpinnerModel = nullableSpinnerNumberModel;
                }

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    this.val$priceSpinnerModel.setNullable(propertyChangeEvent.getNewValue() == null);
                    this.val$priceSpinnerModel.setValue(propertyChangeEvent.getNewValue());
                }
            };
            homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.PRICE, (PropertyChangeListener)object3);
            ((AbstractSpinnerModel)object5).addChangeListener(new ChangeListener((PropertyChangeListener)object3, (NullableSpinner.NullableSpinnerNumberModel)object5){
                final /* synthetic */ PropertyChangeListener val$priceChangeListener;
                final /* synthetic */ NullableSpinner.NullableSpinnerNumberModel val$priceSpinnerModel;
                {
                    this.val$priceChangeListener = propertyChangeListener;
                    this.val$priceSpinnerModel = nullableSpinnerNumberModel;
                }

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    homeFurnitureController.removePropertyChangeListener(HomeFurnitureController.Property.PRICE, this.val$priceChangeListener);
                    homeFurnitureController.setPrice((BigDecimal)this.val$priceSpinnerModel.getNumber());
                    homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.PRICE, this.val$priceChangeListener);
                }
            });
            if (homeFurnitureController.isPropertyEditable(HomeFurnitureController.Property.VALUE_ADDED_TAX_PERCENTAGE)) {
                this.valueAddedTaxPercentageLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, HomeFurniturePanel.class, "valueAddedTaxPercentageLabel.text", new Object[0]));
                object2 = new BigDecimal("100");
                object = new NullableSpinner.NullableSpinnerNumberModel(BigDecimal.ZERO, BigDecimal.ZERO, (BigDecimal)object2, new BigDecimal("0.5"));
                this.valueAddedTaxPercentageSpinner = new NullableSpinner((NullableSpinner.NullableSpinnerNumberModel)object);
                BigDecimal bigDecimal = homeFurnitureController.getValueAddedTaxPercentage();
                ((NullableSpinner.NullableSpinnerNumberModel)object).setNullable(true);
                if (bigDecimal != null) {
                    ((NullableSpinner.NullableSpinnerNumberModel)object).setValue(bigDecimal.multiply((BigDecimal)object2));
                } else {
                    ((NullableSpinner.NullableSpinnerNumberModel)object).setValue(null);
                }
                final PropertyChangeListener propertyChangeListener = new PropertyChangeListener((NullableSpinner.NullableSpinnerNumberModel)object5, (NullableSpinner.NullableSpinnerNumberModel)object, (BigDecimal)object2){
                    final /* synthetic */ NullableSpinner.NullableSpinnerNumberModel val$priceSpinnerModel;
                    final /* synthetic */ NullableSpinner.NullableSpinnerNumberModel val$valueAddedTaxPercentageSpinnerModel;
                    final /* synthetic */ BigDecimal val$hundred;
                    {
                        this.val$priceSpinnerModel = nullableSpinnerNumberModel;
                        this.val$valueAddedTaxPercentageSpinnerModel = nullableSpinnerNumberModel2;
                        this.val$hundred = bigDecimal;
                    }

                    @Override
                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        this.val$priceSpinnerModel.setNullable(propertyChangeEvent.getNewValue() == null);
                        if (propertyChangeEvent.getNewValue() != null) {
                            this.val$valueAddedTaxPercentageSpinnerModel.setValue(((BigDecimal)propertyChangeEvent.getNewValue()).multiply(this.val$hundred));
                        } else {
                            this.val$valueAddedTaxPercentageSpinnerModel.setValue(null);
                        }
                    }
                };
                ((AbstractSpinnerModel)object).addChangeListener(new ChangeListener((NullableSpinner.NullableSpinnerNumberModel)object, (BigDecimal)object2){
                    final /* synthetic */ NullableSpinner.NullableSpinnerNumberModel val$valueAddedTaxPercentageSpinnerModel;
                    final /* synthetic */ BigDecimal val$hundred;
                    {
                        this.val$valueAddedTaxPercentageSpinnerModel = nullableSpinnerNumberModel;
                        this.val$hundred = bigDecimal;
                    }

                    @Override
                    public void stateChanged(ChangeEvent changeEvent) {
                        homeFurnitureController.removePropertyChangeListener(HomeFurnitureController.Property.VALUE_ADDED_TAX_PERCENTAGE, propertyChangeListener);
                        homeFurnitureController.setValueAddedTaxPercentage(this.val$valueAddedTaxPercentageSpinnerModel.getValue() != null ? ((BigDecimal)this.val$valueAddedTaxPercentageSpinnerModel.getValue()).divide(this.val$hundred) : null);
                        homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.VALUE_ADDED_TAX_PERCENTAGE, propertyChangeListener);
                    }
                });
                homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.VALUE_ADDED_TAX_PERCENTAGE, propertyChangeListener);
            }
        }
        float f = userPreferences.getLengthUnit().getMaximumLength();
        if (homeFurnitureController.isPropertyEditable(HomeFurnitureController.Property.X)) {
            this.xLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, HomeFurniturePanel.class, "xLabel.text", string));
            object4 = new NullableSpinner.NullableSpinnerLengthModel(userPreferences, -f, f);
            this.xSpinner = new NullableSpinner((NullableSpinner.NullableSpinnerNumberModel)object4);
            ((NullableSpinner.NullableSpinnerNumberModel)object4).setNullable(homeFurnitureController.getX() == null);
            ((NullableSpinner.NullableSpinnerLengthModel)object4).setLength(homeFurnitureController.getX());
            object3 = new PropertyChangeListener((NullableSpinner.NullableSpinnerLengthModel)object4){
                final /* synthetic */ NullableSpinner.NullableSpinnerLengthModel val$xSpinnerModel;
                {
                    this.val$xSpinnerModel = nullableSpinnerLengthModel;
                }

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    this.val$xSpinnerModel.setNullable(propertyChangeEvent.getNewValue() == null);
                    this.val$xSpinnerModel.setLength((Float)propertyChangeEvent.getNewValue());
                }
            };
            homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.X, (PropertyChangeListener)object3);
            ((AbstractSpinnerModel)object4).addChangeListener(new ChangeListener((PropertyChangeListener)object3, (NullableSpinner.NullableSpinnerLengthModel)object4){
                final /* synthetic */ PropertyChangeListener val$xChangeListener;
                final /* synthetic */ NullableSpinner.NullableSpinnerLengthModel val$xSpinnerModel;
                {
                    this.val$xChangeListener = propertyChangeListener;
                    this.val$xSpinnerModel = nullableSpinnerLengthModel;
                }

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    homeFurnitureController.removePropertyChangeListener(HomeFurnitureController.Property.X, this.val$xChangeListener);
                    homeFurnitureController.setX(this.val$xSpinnerModel.getLength());
                    homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.X, this.val$xChangeListener);
                }
            });
        }
        if (homeFurnitureController.isPropertyEditable(HomeFurnitureController.Property.Y)) {
            this.yLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, HomeFurniturePanel.class, "yLabel.text", string));
            object4 = new NullableSpinner.NullableSpinnerLengthModel(userPreferences, -f, f);
            this.ySpinner = new NullableSpinner((NullableSpinner.NullableSpinnerNumberModel)object4);
            ((NullableSpinner.NullableSpinnerNumberModel)object4).setNullable(homeFurnitureController.getY() == null);
            ((NullableSpinner.NullableSpinnerLengthModel)object4).setLength(homeFurnitureController.getY());
            object3 = new PropertyChangeListener((NullableSpinner.NullableSpinnerLengthModel)object4){
                final /* synthetic */ NullableSpinner.NullableSpinnerLengthModel val$ySpinnerModel;
                {
                    this.val$ySpinnerModel = nullableSpinnerLengthModel;
                }

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    this.val$ySpinnerModel.setNullable(propertyChangeEvent.getNewValue() == null);
                    this.val$ySpinnerModel.setLength((Float)propertyChangeEvent.getNewValue());
                }
            };
            homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.Y, (PropertyChangeListener)object3);
            ((AbstractSpinnerModel)object4).addChangeListener(new ChangeListener((PropertyChangeListener)object3, (NullableSpinner.NullableSpinnerLengthModel)object4){
                final /* synthetic */ PropertyChangeListener val$yChangeListener;
                final /* synthetic */ NullableSpinner.NullableSpinnerLengthModel val$ySpinnerModel;
                {
                    this.val$yChangeListener = propertyChangeListener;
                    this.val$ySpinnerModel = nullableSpinnerLengthModel;
                }

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    homeFurnitureController.removePropertyChangeListener(HomeFurnitureController.Property.Y, this.val$yChangeListener);
                    homeFurnitureController.setY(this.val$ySpinnerModel.getLength());
                    homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.Y, this.val$yChangeListener);
                }
            });
        }
        if (homeFurnitureController.isPropertyEditable(HomeFurnitureController.Property.ELEVATION)) {
            this.elevationLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, HomeFurniturePanel.class, "elevationLabel.text", string));
            object4 = new NullableSpinner.NullableSpinnerLengthModel(userPreferences, 0.0f, userPreferences.getLengthUnit().getMaximumElevation());
            this.elevationSpinner = new NullableSpinner((NullableSpinner.NullableSpinnerNumberModel)object4);
            ((NullableSpinner.NullableSpinnerNumberModel)object4).setNullable(homeFurnitureController.getElevation() == null);
            ((NullableSpinner.NullableSpinnerLengthModel)object4).setLength(homeFurnitureController.getElevation());
            object3 = new PropertyChangeListener((NullableSpinner.NullableSpinnerLengthModel)object4){
                final /* synthetic */ NullableSpinner.NullableSpinnerLengthModel val$elevationSpinnerModel;
                {
                    this.val$elevationSpinnerModel = nullableSpinnerLengthModel;
                }

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    this.val$elevationSpinnerModel.setNullable(propertyChangeEvent.getNewValue() == null);
                    this.val$elevationSpinnerModel.setLength((Float)propertyChangeEvent.getNewValue());
                }
            };
            homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.ELEVATION, (PropertyChangeListener)object3);
            ((AbstractSpinnerModel)object4).addChangeListener(new ChangeListener((PropertyChangeListener)object3, (NullableSpinner.NullableSpinnerLengthModel)object4){
                final /* synthetic */ PropertyChangeListener val$elevationChangeListener;
                final /* synthetic */ NullableSpinner.NullableSpinnerLengthModel val$elevationSpinnerModel;
                {
                    this.val$elevationChangeListener = propertyChangeListener;
                    this.val$elevationSpinnerModel = nullableSpinnerLengthModel;
                }

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    homeFurnitureController.removePropertyChangeListener(HomeFurnitureController.Property.ELEVATION, this.val$elevationChangeListener);
                    homeFurnitureController.setElevation(this.val$elevationSpinnerModel.getLength());
                    homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.ELEVATION, this.val$elevationChangeListener);
                }
            });
        }
        if (homeFurnitureController.isPropertyEditable(HomeFurnitureController.Property.ANGLE_IN_DEGREES) || homeFurnitureController.isPropertyEditable(HomeFurnitureController.Property.ANGLE)) {
            this.angleLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, HomeFurniturePanel.class, "angleLabel.text", new Object[0]));
            object4 = new NullableSpinner.NullableSpinnerModuloNumberModel(0.0f, 0.0f, 360.0f, 1.0f);
            this.angleSpinner = new NullableSpinner((NullableSpinner.NullableSpinnerNumberModel)object4);
            object3 = homeFurnitureController.getAngle();
            ((NullableSpinner.NullableSpinnerNumberModel)object4).setNullable(object3 == null);
            ((NullableSpinner.NullableSpinnerNumberModel)object4).setValue(object3 != null ? new Float((float)Math.toDegrees(((Float)object3).floatValue())) : null);
            object2 = new PropertyChangeListener((NullableSpinner.NullableSpinnerNumberModel)object4){
                final /* synthetic */ NullableSpinner.NullableSpinnerNumberModel val$angleSpinnerModel;
                {
                    this.val$angleSpinnerModel = nullableSpinnerNumberModel;
                }

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    Float f = (Float)propertyChangeEvent.getNewValue();
                    this.val$angleSpinnerModel.setNullable(f == null);
                    this.val$angleSpinnerModel.setValue(f != null ? new Float((float)Math.toDegrees(f.floatValue())) : null);
                }
            };
            homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.ANGLE, (PropertyChangeListener)object2);
            ((AbstractSpinnerModel)object4).addChangeListener(new ChangeListener((PropertyChangeListener)object2, (NullableSpinner.NullableSpinnerNumberModel)object4){
                final /* synthetic */ PropertyChangeListener val$angleChangeListener;
                final /* synthetic */ NullableSpinner.NullableSpinnerNumberModel val$angleSpinnerModel;
                {
                    this.val$angleChangeListener = propertyChangeListener;
                    this.val$angleSpinnerModel = nullableSpinnerNumberModel;
                }

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    homeFurnitureController.removePropertyChangeListener(HomeFurnitureController.Property.ANGLE, this.val$angleChangeListener);
                    Number number = (Number)this.val$angleSpinnerModel.getValue();
                    if (number == null) {
                        homeFurnitureController.setAngle(null);
                    } else {
                        homeFurnitureController.setAngle(Float.valueOf((float)Math.toRadians(number.doubleValue())));
                    }
                    homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.ANGLE, this.val$angleChangeListener);
                }
            });
        }
        if (!Boolean.getBoolean("com.eteks.sweethome3d.no3D")) {
            if (homeFurnitureController.isPropertyEditable(HomeFurnitureController.Property.ROLL)) {
                this.rollRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, HomeFurniturePanel.class, "rollRadioButton.text", new Object[0]));
                this.rollRadioButton.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent changeEvent) {
                        if (HomeFurniturePanel.this.rollRadioButton.isSelected()) {
                            homeFurnitureController.setHorizontalAxis(HomeFurnitureController.FurnitureHorizontalAxis.ROLL);
                        }
                    }
                });
                object4 = new NullableSpinner.NullableSpinnerModuloNumberModel(0.0f, 0.0f, 360.0f, 1.0f);
                this.rollSpinner = new NullableSpinner((NullableSpinner.NullableSpinnerNumberModel)object4);
                object3 = homeFurnitureController.getRoll();
                ((NullableSpinner.NullableSpinnerNumberModel)object4).setNullable(object3 == null);
                ((NullableSpinner.NullableSpinnerNumberModel)object4).setValue(object3 != null ? new Float((float)Math.toDegrees(((Float)object3).floatValue())) : null);
                object2 = new PropertyChangeListener((NullableSpinner.NullableSpinnerNumberModel)object4){
                    final /* synthetic */ NullableSpinner.NullableSpinnerNumberModel val$rollSpinnerModel;
                    {
                        this.val$rollSpinnerModel = nullableSpinnerNumberModel;
                    }

                    @Override
                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        Float f = (Float)propertyChangeEvent.getNewValue();
                        this.val$rollSpinnerModel.setNullable(f == null);
                        this.val$rollSpinnerModel.setValue(f != null ? new Float((float)Math.toDegrees(f.floatValue())) : null);
                    }
                };
                homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.ROLL, (PropertyChangeListener)object2);
                ((AbstractSpinnerModel)object4).addChangeListener(new ChangeListener((PropertyChangeListener)object2, (NullableSpinner.NullableSpinnerNumberModel)object4){
                    final /* synthetic */ PropertyChangeListener val$rollChangeListener;
                    final /* synthetic */ NullableSpinner.NullableSpinnerNumberModel val$rollSpinnerModel;
                    {
                        this.val$rollChangeListener = propertyChangeListener;
                        this.val$rollSpinnerModel = nullableSpinnerNumberModel;
                    }

                    @Override
                    public void stateChanged(ChangeEvent changeEvent) {
                        homeFurnitureController.removePropertyChangeListener(HomeFurnitureController.Property.ROLL, this.val$rollChangeListener);
                        Number number = (Number)this.val$rollSpinnerModel.getValue();
                        if (number == null) {
                            homeFurnitureController.setRoll(null);
                        } else {
                            homeFurnitureController.setRoll(Float.valueOf((float)Math.toRadians(number.floatValue())));
                        }
                        homeFurnitureController.setHorizontalAxis(HomeFurnitureController.FurnitureHorizontalAxis.ROLL);
                        homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.ROLL, this.val$rollChangeListener);
                    }
                });
            }
            if (homeFurnitureController.isPropertyEditable(HomeFurnitureController.Property.PITCH)) {
                this.pitchRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, HomeFurniturePanel.class, "pitchRadioButton.text", new Object[0]));
                this.pitchRadioButton.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent changeEvent) {
                        if (HomeFurniturePanel.this.pitchRadioButton.isSelected()) {
                            homeFurnitureController.setHorizontalAxis(HomeFurnitureController.FurnitureHorizontalAxis.PITCH);
                        }
                    }
                });
                object4 = new NullableSpinner.NullableSpinnerModuloNumberModel(0.0f, 0.0f, 360.0f, 1.0f);
                this.pitchSpinner = new NullableSpinner((NullableSpinner.NullableSpinnerNumberModel)object4);
                object3 = homeFurnitureController.getPitch();
                ((NullableSpinner.NullableSpinnerNumberModel)object4).setNullable(object3 == null);
                ((NullableSpinner.NullableSpinnerNumberModel)object4).setValue(object3 != null ? new Float((float)Math.toDegrees(((Float)object3).floatValue())) : null);
                object2 = new PropertyChangeListener((NullableSpinner.NullableSpinnerNumberModel)object4){
                    final /* synthetic */ NullableSpinner.NullableSpinnerNumberModel val$pitchSpinnerModel;
                    {
                        this.val$pitchSpinnerModel = nullableSpinnerNumberModel;
                    }

                    @Override
                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        Float f = (Float)propertyChangeEvent.getNewValue();
                        this.val$pitchSpinnerModel.setNullable(f == null);
                        this.val$pitchSpinnerModel.setValue(f != null ? new Float((float)Math.toDegrees(f.floatValue())) : null);
                    }
                };
                homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.PITCH, (PropertyChangeListener)object2);
                ((AbstractSpinnerModel)object4).addChangeListener(new ChangeListener((PropertyChangeListener)object2, (NullableSpinner.NullableSpinnerNumberModel)object4){
                    final /* synthetic */ PropertyChangeListener val$pitchChangeListener;
                    final /* synthetic */ NullableSpinner.NullableSpinnerNumberModel val$pitchSpinnerModel;
                    {
                        this.val$pitchChangeListener = propertyChangeListener;
                        this.val$pitchSpinnerModel = nullableSpinnerNumberModel;
                    }

                    @Override
                    public void stateChanged(ChangeEvent changeEvent) {
                        homeFurnitureController.removePropertyChangeListener(HomeFurnitureController.Property.PITCH, this.val$pitchChangeListener);
                        Number number = (Number)this.val$pitchSpinnerModel.getValue();
                        if (number == null) {
                            homeFurnitureController.setPitch(null);
                        } else {
                            homeFurnitureController.setPitch(Float.valueOf((float)Math.toRadians(number.floatValue())));
                        }
                        homeFurnitureController.setHorizontalAxis(HomeFurnitureController.FurnitureHorizontalAxis.PITCH);
                        homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.PITCH, this.val$pitchChangeListener);
                    }
                });
            }
            if (this.rollRadioButton != null && this.pitchRadioButton != null) {
                object4 = new ButtonGroup();
                ((ButtonGroup)object4).add(this.rollRadioButton);
                ((ButtonGroup)object4).add(this.pitchRadioButton);
                this.updateHorizontalAxisRadioButtons(homeFurnitureController);
                homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.HORIZONTAL_AXIS, new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        HomeFurniturePanel.this.updateHorizontalAxisRadioButtons(homeFurnitureController);
                    }
                });
            }
        }
        if (homeFurnitureController.isPropertyEditable(HomeFurnitureController.Property.BASE_PLAN_ITEM)) {
            this.basePlanItemCheckBox = new NullableCheckBox(SwingTools.getLocalizedLabelText(userPreferences, HomeFurniturePanel.class, "basePlanItemCheckBox.text", new Object[0]));
            object4 = userPreferences.getLocalizedString(HomeFurniturePanel.class, "basePlanItemCheckBox.tooltip", new Object[0]);
            if (((String)object4).length() > 0) {
                this.basePlanItemCheckBox.setToolTipText((String)object4);
            }
            this.basePlanItemCheckBox.setNullable(homeFurnitureController.getBasePlanItem() == null);
            this.basePlanItemCheckBox.setValue(homeFurnitureController.getBasePlanItem());
            object3 = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    HomeFurniturePanel.this.basePlanItemCheckBox.setNullable(propertyChangeEvent.getNewValue() == null);
                    HomeFurniturePanel.this.basePlanItemCheckBox.setValue((Boolean)propertyChangeEvent.getNewValue());
                }
            };
            homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.BASE_PLAN_ITEM, (PropertyChangeListener)object3);
            this.basePlanItemCheckBox.addChangeListener(new ChangeListener((PropertyChangeListener)object3){
                final /* synthetic */ PropertyChangeListener val$basePlanItemModelChangeListener;
                {
                    this.val$basePlanItemModelChangeListener = propertyChangeListener;
                }

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    homeFurnitureController.removePropertyChangeListener(HomeFurnitureController.Property.BASE_PLAN_ITEM, this.val$basePlanItemModelChangeListener);
                    homeFurnitureController.setBasePlanItem(HomeFurniturePanel.this.basePlanItemCheckBox.getValue());
                    homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.BASE_PLAN_ITEM, this.val$basePlanItemModelChangeListener);
                }
            });
            this.basePlanItemCheckBox.setEnabled(homeFurnitureController.isBasePlanItemEnabled());
        }
        float f2 = userPreferences.getLengthUnit().getMinimumLength();
        if (homeFurnitureController.isPropertyEditable(HomeFurnitureController.Property.WIDTH)) {
            this.widthLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, HomeFurniturePanel.class, "widthLabel.text", string));
            object3 = new NullableSpinner.NullableSpinnerLengthModel(userPreferences, f2, f);
            this.widthSpinner = new NullableSpinner((NullableSpinner.NullableSpinnerNumberModel)object3);
            object2 = new PropertyChangeListener((NullableSpinner.NullableSpinnerLengthModel)object3, f2){
                final /* synthetic */ NullableSpinner.NullableSpinnerLengthModel val$widthSpinnerModel;
                final /* synthetic */ float val$minimumLength;
                {
                    this.val$widthSpinnerModel = nullableSpinnerLengthModel;
                    this.val$minimumLength = f;
                }

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    Float f = homeFurnitureController.getWidth();
                    this.val$widthSpinnerModel.setNullable(f == null);
                    this.val$widthSpinnerModel.setLength(f);
                    if (f != null) {
                        this.val$widthSpinnerModel.setMinimumLength(Math.min(f.floatValue(), this.val$minimumLength));
                    }
                }
            };
            object2.propertyChange(null);
            homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.WIDTH, (PropertyChangeListener)object2);
            ((AbstractSpinnerModel)object3).addChangeListener(new ChangeListener((PropertyChangeListener)object2, (NullableSpinner.NullableSpinnerLengthModel)object3){
                final /* synthetic */ PropertyChangeListener val$widthChangeListener;
                final /* synthetic */ NullableSpinner.NullableSpinnerLengthModel val$widthSpinnerModel;
                {
                    this.val$widthChangeListener = propertyChangeListener;
                    this.val$widthSpinnerModel = nullableSpinnerLengthModel;
                }

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    homeFurnitureController.removePropertyChangeListener(HomeFurnitureController.Property.WIDTH, this.val$widthChangeListener);
                    homeFurnitureController.setWidth(this.val$widthSpinnerModel.getLength());
                    homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.WIDTH, this.val$widthChangeListener);
                }
            });
        }
        if (homeFurnitureController.isPropertyEditable(HomeFurnitureController.Property.DEPTH)) {
            this.depthLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, HomeFurniturePanel.class, "depthLabel.text", string));
            object3 = new NullableSpinner.NullableSpinnerLengthModel(userPreferences, f2, f);
            this.depthSpinner = new NullableSpinner((NullableSpinner.NullableSpinnerNumberModel)object3);
            object2 = new PropertyChangeListener((NullableSpinner.NullableSpinnerLengthModel)object3, f2){
                final /* synthetic */ NullableSpinner.NullableSpinnerLengthModel val$depthSpinnerModel;
                final /* synthetic */ float val$minimumLength;
                {
                    this.val$depthSpinnerModel = nullableSpinnerLengthModel;
                    this.val$minimumLength = f;
                }

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    Float f = homeFurnitureController.getDepth();
                    this.val$depthSpinnerModel.setNullable(f == null);
                    this.val$depthSpinnerModel.setLength(f);
                    if (f != null) {
                        this.val$depthSpinnerModel.setMinimumLength(Math.min(f.floatValue(), this.val$minimumLength));
                    }
                }
            };
            object2.propertyChange(null);
            homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.DEPTH, (PropertyChangeListener)object2);
            ((AbstractSpinnerModel)object3).addChangeListener(new ChangeListener((PropertyChangeListener)object2, (NullableSpinner.NullableSpinnerLengthModel)object3){
                final /* synthetic */ PropertyChangeListener val$depthChangeListener;
                final /* synthetic */ NullableSpinner.NullableSpinnerLengthModel val$depthSpinnerModel;
                {
                    this.val$depthChangeListener = propertyChangeListener;
                    this.val$depthSpinnerModel = nullableSpinnerLengthModel;
                }

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    homeFurnitureController.removePropertyChangeListener(HomeFurnitureController.Property.DEPTH, this.val$depthChangeListener);
                    homeFurnitureController.setDepth(this.val$depthSpinnerModel.getLength());
                    homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.DEPTH, this.val$depthChangeListener);
                }
            });
        }
        if (homeFurnitureController.isPropertyEditable(HomeFurnitureController.Property.HEIGHT)) {
            this.heightLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, HomeFurniturePanel.class, "heightLabel.text", string));
            object3 = new NullableSpinner.NullableSpinnerLengthModel(userPreferences, f2, f);
            this.heightSpinner = new NullableSpinner((NullableSpinner.NullableSpinnerNumberModel)object3);
            object2 = new PropertyChangeListener((NullableSpinner.NullableSpinnerLengthModel)object3, f2){
                final /* synthetic */ NullableSpinner.NullableSpinnerLengthModel val$heightSpinnerModel;
                final /* synthetic */ float val$minimumLength;
                {
                    this.val$heightSpinnerModel = nullableSpinnerLengthModel;
                    this.val$minimumLength = f;
                }

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    Float f = homeFurnitureController.getHeight();
                    this.val$heightSpinnerModel.setNullable(f == null);
                    this.val$heightSpinnerModel.setLength(f);
                    if (f != null) {
                        this.val$heightSpinnerModel.setMinimumLength(Math.min(f.floatValue(), this.val$minimumLength));
                    }
                }
            };
            object2.propertyChange(null);
            homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.HEIGHT, (PropertyChangeListener)object2);
            ((AbstractSpinnerModel)object3).addChangeListener(new ChangeListener((PropertyChangeListener)object2, (NullableSpinner.NullableSpinnerLengthModel)object3){
                final /* synthetic */ PropertyChangeListener val$heightChangeListener;
                final /* synthetic */ NullableSpinner.NullableSpinnerLengthModel val$heightSpinnerModel;
                {
                    this.val$heightChangeListener = propertyChangeListener;
                    this.val$heightSpinnerModel = nullableSpinnerLengthModel;
                }

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    homeFurnitureController.removePropertyChangeListener(HomeFurnitureController.Property.HEIGHT, this.val$heightChangeListener);
                    homeFurnitureController.setHeight(this.val$heightSpinnerModel.getLength());
                    homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.HEIGHT, this.val$heightChangeListener);
                }
            });
        }
        if (homeFurnitureController.isPropertyEditable(HomeFurnitureController.Property.PROPORTIONAL)) {
            this.keepProportionsCheckBox = new JCheckBox(SwingTools.getLocalizedLabelText(userPreferences, ImportedFurnitureWizardStepsPanel.class, "keepProportionsCheckBox.text", new Object[0]));
            this.keepProportionsCheckBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    homeFurnitureController.setProportional(HomeFurniturePanel.this.keepProportionsCheckBox.isSelected());
                }
            });
            this.keepProportionsCheckBox.setSelected(homeFurnitureController.isProportional() || Boolean.getBoolean("com.eteks.sweethome3d.no3D") && (homeFurnitureController.getRoll() == null || homeFurnitureController.getRoll().floatValue() != 0.0f || homeFurnitureController.getPitch() == null || homeFurnitureController.getPitch().floatValue() != 0.0f));
            homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.PROPORTIONAL, new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    HomeFurniturePanel.this.keepProportionsCheckBox.setSelected(homeFurnitureController.isProportional());
                }
            });
        }
        if (homeFurnitureController.isPropertyEditable(HomeFurnitureController.Property.MODEL_MIRRORED)) {
            this.mirroredModelCheckBox = new NullableCheckBox(SwingTools.getLocalizedLabelText(userPreferences, HomeFurniturePanel.class, "mirroredModelCheckBox.text", new Object[0]));
            object3 = userPreferences.getLocalizedString(HomeFurniturePanel.class, "mirroredModelCheckBox.tooltip", new Object[0]);
            if (((String)object3).length() > 0) {
                this.mirroredModelCheckBox.setToolTipText((String)object3);
            }
            this.mirroredModelCheckBox.setNullable(homeFurnitureController.getModelMirrored() == null);
            this.mirroredModelCheckBox.setValue(homeFurnitureController.getModelMirrored());
            object2 = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    HomeFurniturePanel.this.mirroredModelCheckBox.setNullable(propertyChangeEvent.getNewValue() == null);
                    HomeFurniturePanel.this.mirroredModelCheckBox.setValue((Boolean)propertyChangeEvent.getNewValue());
                }
            };
            homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.MODEL_MIRRORED, (PropertyChangeListener)object2);
            this.mirroredModelCheckBox.addChangeListener(new ChangeListener((PropertyChangeListener)object2){
                final /* synthetic */ PropertyChangeListener val$mirroredModelChangeListener;
                {
                    this.val$mirroredModelChangeListener = propertyChangeListener;
                }

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    homeFurnitureController.removePropertyChangeListener(HomeFurnitureController.Property.MODEL_MIRRORED, this.val$mirroredModelChangeListener);
                    homeFurnitureController.setModelMirrored(HomeFurniturePanel.this.mirroredModelCheckBox.getValue());
                    homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.MODEL_MIRRORED, this.val$mirroredModelChangeListener);
                }
            });
        }
        if (homeFurnitureController.isPropertyEditable(HomeFurnitureController.Property.MODEL_TRANSFORMATIONS)) {
            try {
                if (!Boolean.getBoolean("com.eteks.sweethome3d.no3D")) {
                    this.modelTransformationsButton = new JButton();
                    this.modelTransformationsButton.setVisible(false);
                    if (OperatingSystem.isMacOSX()) {
                        this.modelTransformationsButton.putClientProperty("JButton.buttonType", "segmented");
                        this.modelTransformationsButton.putClientProperty("JButton.segmentPosition", "only");
                    }
                    if ((object3 = homeFurnitureController.getModelMaterialsController()) != null && ((ModelMaterialsController)object3).getModel() != null) {
                        ModelManager.getInstance().loadModel(((ModelMaterialsController)object3).getModel(), new ModelManager.ModelObserver(){

                            @Override
                            public void modelUpdated(BranchGroup branchGroup) {
                                ModelManager modelManager = ModelManager.getInstance();
                                if (modelManager.containsDeformableNode((Node)branchGroup)) {
                                    HomeFurniturePanel.this.modelTransformationsButton.setText(SwingTools.getLocalizedLabelText(userPreferences, HomeFurniturePanel.class, modelManager.containsNode((Node)branchGroup, "sweethome3d_mannequin_abdomen") ? "mannequinTransformationsButton.text" : "modelTransformationsButton.text", new Object[0]));
                                    HomeFurniturePanel.this.modelTransformationsButton.setVisible(true);
                                    HomeFurniturePanel.this.modelTransformationsButton.addActionListener(new ActionListener(){

                                        @Override
                                        public void actionPerformed(ActionEvent actionEvent) {
                                            HomeFurniturePanel.this.displayModelTransformationsView(userPreferences, homeFurnitureController);
                                        }
                                    });
                                }
                            }

                            @Override
                            public void modelError(Exception exception) {
                            }
                        });
                    }
                }
            }
            catch (AccessControlException accessControlException) {
                // empty catch block
            }
        }
        if (homeFurnitureController.isPropertyEditable(HomeFurnitureController.Property.PAINT)) {
            object3 = new ButtonGroup();
            this.defaultColorAndTextureRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, HomeFurniturePanel.class, "defaultColorAndTextureRadioButton.text", new Object[0]));
            ((ButtonGroup)object3).add(this.defaultColorAndTextureRadioButton);
            this.defaultColorAndTextureRadioButton.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (HomeFurniturePanel.this.defaultColorAndTextureRadioButton.isSelected()) {
                        homeFurnitureController.setPaint(HomeFurnitureController.FurniturePaint.DEFAULT);
                    }
                }
            });
            homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.PAINT, new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    HomeFurniturePanel.this.updatePaintRadioButtons(homeFurnitureController);
                }
            });
            this.colorRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, HomeFurniturePanel.class, "colorRadioButton.text", new Object[0]));
            ((ButtonGroup)object3).add(this.colorRadioButton);
            this.colorRadioButton.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (HomeFurniturePanel.this.colorRadioButton.isSelected()) {
                        homeFurnitureController.setPaint(HomeFurnitureController.FurniturePaint.COLORED);
                    }
                }
            });
            this.colorButton = new ColorButton(userPreferences);
            if (OperatingSystem.isMacOSX()) {
                this.colorButton.putClientProperty("JButton.buttonType", "segmented");
                this.colorButton.putClientProperty("JButton.segmentPosition", "only");
            }
            this.colorButton.setColorDialogTitle(userPreferences.getLocalizedString(HomeFurniturePanel.class, "colorDialog.title", new Object[0]));
            this.colorButton.setColor(homeFurnitureController.getColor());
            this.colorButton.addPropertyChangeListener("color", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    homeFurnitureController.setColor(HomeFurniturePanel.this.colorButton.getColor());
                    homeFurnitureController.setPaint(HomeFurnitureController.FurniturePaint.COLORED);
                }
            });
            homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.COLOR, new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    HomeFurniturePanel.this.colorButton.setColor(homeFurnitureController.getColor());
                }
            });
            object2 = homeFurnitureController.getTextureController();
            if (object2 != null) {
                this.textureRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, HomeFurniturePanel.class, "textureRadioButton.text", new Object[0]));
                this.textureRadioButton.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent changeEvent) {
                        if (HomeFurniturePanel.this.textureRadioButton.isSelected()) {
                            homeFurnitureController.setPaint(HomeFurnitureController.FurniturePaint.TEXTURED);
                        }
                    }
                });
                this.textureComponent = (JComponent)((Object)((TextureChoiceController)object2).getView());
                if (OperatingSystem.isMacOSX()) {
                    this.textureComponent.putClientProperty("JButton.buttonType", "segmented");
                    this.textureComponent.putClientProperty("JButton.segmentPosition", "only");
                }
                ((ButtonGroup)object3).add(this.textureRadioButton);
            }
            try {
                object = homeFurnitureController.getModelMaterialsController();
                if (object != null && !Boolean.getBoolean("com.eteks.sweethome3d.no3D")) {
                    this.modelMaterialsRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, HomeFurniturePanel.class, "modelMaterialsRadioButton.text", new Object[0]));
                    this.modelMaterialsRadioButton.addChangeListener(new ChangeListener(){

                        @Override
                        public void stateChanged(ChangeEvent changeEvent) {
                            if (HomeFurniturePanel.this.modelMaterialsRadioButton.isSelected()) {
                                homeFurnitureController.setPaint(HomeFurnitureController.FurniturePaint.MODEL_MATERIALS);
                            }
                        }
                    });
                    this.modelMaterialsComponent = (JComponent)((Object)((ModelMaterialsController)object).getView());
                    if (OperatingSystem.isMacOSX()) {
                        this.modelMaterialsComponent.putClientProperty("JButton.buttonType", "segmented");
                        this.modelMaterialsComponent.putClientProperty("JButton.segmentPosition", "only");
                    }
                    ((ButtonGroup)object3).add(this.modelMaterialsRadioButton);
                    boolean bl = ((ModelMaterialsController)object).getModel() != null;
                    this.modelMaterialsRadioButton.setEnabled(bl);
                    this.modelMaterialsComponent.setEnabled(bl);
                }
            }
            catch (AccessControlException accessControlException) {
                // empty catch block
            }
        }
        if (homeFurnitureController.isPropertyEditable(HomeFurnitureController.Property.SHININESS)) {
            this.defaultShininessRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, HomeFurniturePanel.class, "defaultShininessRadioButton.text", new Object[0]));
            this.defaultShininessRadioButton.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (HomeFurniturePanel.this.defaultShininessRadioButton.isSelected()) {
                        homeFurnitureController.setShininess(HomeFurnitureController.FurnitureShininess.DEFAULT);
                    }
                }
            });
            homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.SHININESS, new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    HomeFurniturePanel.this.updateShininessRadioButtons(homeFurnitureController);
                }
            });
            this.mattRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, HomeFurniturePanel.class, "mattRadioButton.text", new Object[0]));
            this.mattRadioButton.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (HomeFurniturePanel.this.mattRadioButton.isSelected()) {
                        homeFurnitureController.setShininess(HomeFurnitureController.FurnitureShininess.MATT);
                    }
                }
            });
            this.shinyRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, HomeFurniturePanel.class, "shinyRadioButton.text", new Object[0]));
            this.shinyRadioButton.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (HomeFurniturePanel.this.shinyRadioButton.isSelected()) {
                        homeFurnitureController.setShininess(HomeFurnitureController.FurnitureShininess.SHINY);
                    }
                }
            });
            object3 = new ButtonGroup();
            ((ButtonGroup)object3).add(this.defaultShininessRadioButton);
            ((ButtonGroup)object3).add(this.mattRadioButton);
            ((ButtonGroup)object3).add(this.shinyRadioButton);
            this.updateShininessRadioButtons(homeFurnitureController);
        }
        if (homeFurnitureController.isPropertyEditable(HomeFurnitureController.Property.PAINT)) {
            this.updatePaintRadioButtons(homeFurnitureController);
        }
        if (homeFurnitureController.isPropertyEditable(HomeFurnitureController.Property.VISIBLE)) {
            this.visibleCheckBox = new NullableCheckBox(SwingTools.getLocalizedLabelText(userPreferences, HomeFurniturePanel.class, "visibleCheckBox.text", new Object[0]));
            this.visibleCheckBox.setNullable(homeFurnitureController.getVisible() == null);
            this.visibleCheckBox.setValue(homeFurnitureController.getVisible());
            object3 = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    HomeFurniturePanel.this.visibleCheckBox.setNullable(propertyChangeEvent.getNewValue() == null);
                    HomeFurniturePanel.this.visibleCheckBox.setValue((Boolean)propertyChangeEvent.getNewValue());
                }
            };
            homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.VISIBLE, (PropertyChangeListener)object3);
            this.visibleCheckBox.addChangeListener(new ChangeListener((PropertyChangeListener)object3){
                final /* synthetic */ PropertyChangeListener val$visibleChangeListener;
                {
                    this.val$visibleChangeListener = propertyChangeListener;
                }

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    homeFurnitureController.removePropertyChangeListener(HomeFurnitureController.Property.VISIBLE, this.val$visibleChangeListener);
                    homeFurnitureController.setVisible(HomeFurniturePanel.this.visibleCheckBox.getValue());
                    homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.VISIBLE, this.val$visibleChangeListener);
                }
            });
        }
        if (homeFurnitureController.isPropertyEditable(HomeFurnitureController.Property.LIGHT_POWER)) {
            this.lightPowerLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, HomeFurniturePanel.class, "lightPowerLabel.text", "%"));
            object3 = new NullableSpinner.NullableSpinnerNumberModel(0.0f, 0.0f, 100.0f, 5.0f){

                @Override
                Format getFormat() {
                    return new DecimalFormat("0.#");
                }
            };
            this.lightPowerSpinner = new NullableSpinner((NullableSpinner.NullableSpinnerNumberModel)object3);
            ((NullableSpinner.NullableSpinnerNumberModel)object3).setNullable(homeFurnitureController.getLightPower() == null);
            ((NullableSpinner.NullableSpinnerNumberModel)object3).setValue(homeFurnitureController.getLightPower() != null ? Float.valueOf(homeFurnitureController.getLightPower().floatValue() * 100.0f) : null);
            object2 = new PropertyChangeListener((NullableSpinner.NullableSpinnerNumberModel)object3){
                final /* synthetic */ NullableSpinner.NullableSpinnerNumberModel val$lightPowerSpinnerModel;
                {
                    this.val$lightPowerSpinnerModel = nullableSpinnerNumberModel;
                }

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    Float f = (Float)propertyChangeEvent.getNewValue();
                    this.val$lightPowerSpinnerModel.setNullable(f == null);
                    this.val$lightPowerSpinnerModel.setValue(f != null ? Float.valueOf(f.floatValue() * 100.0f) : null);
                }
            };
            homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.LIGHT_POWER, (PropertyChangeListener)object2);
            ((AbstractSpinnerModel)object3).addChangeListener(new ChangeListener((PropertyChangeListener)object2, (NullableSpinner.NullableSpinnerNumberModel)object3){
                final /* synthetic */ PropertyChangeListener val$lightPowerChangeListener;
                final /* synthetic */ NullableSpinner.NullableSpinnerNumberModel val$lightPowerSpinnerModel;
                {
                    this.val$lightPowerChangeListener = propertyChangeListener;
                    this.val$lightPowerSpinnerModel = nullableSpinnerNumberModel;
                }

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    homeFurnitureController.removePropertyChangeListener(HomeFurnitureController.Property.LIGHT_POWER, this.val$lightPowerChangeListener);
                    homeFurnitureController.setLightPower(Float.valueOf(((Number)this.val$lightPowerSpinnerModel.getValue()).floatValue() / 100.0f));
                    homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.LIGHT_POWER, this.val$lightPowerChangeListener);
                }
            });
        }
        this.updateSizeComponents(homeFurnitureController);
        object3 = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                HomeFurniturePanel.this.updateSizeComponents(homeFurnitureController);
            }
        };
        homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.RESIZABLE, (PropertyChangeListener)object3);
        homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.DEFORMABLE, (PropertyChangeListener)object3);
        this.dialogTitle = userPreferences.getLocalizedString(HomeFurniturePanel.class, "homeFurniture.title", new Object[0]);
    }

    private void updateHorizontalAxisRadioButtons(HomeFurnitureController homeFurnitureController) {
        if (homeFurnitureController.getHorizontalAxis() == null) {
            SwingTools.deselectAllRadioButtons(this.rollRadioButton, this.pitchRadioButton);
        } else {
            switch (homeFurnitureController.getHorizontalAxis()) {
                case ROLL: {
                    this.rollRadioButton.setSelected(true);
                    break;
                }
                case PITCH: {
                    this.pitchRadioButton.setSelected(true);
                }
            }
        }
    }

    private void updatePaintRadioButtons(HomeFurnitureController homeFurnitureController) {
        if (homeFurnitureController.getPaint() == null) {
            SwingTools.deselectAllRadioButtons(this.defaultColorAndTextureRadioButton, this.colorRadioButton, this.textureRadioButton, this.modelMaterialsRadioButton);
        } else {
            switch (homeFurnitureController.getPaint()) {
                case DEFAULT: {
                    this.defaultColorAndTextureRadioButton.setSelected(true);
                    break;
                }
                case COLORED: {
                    this.colorRadioButton.setSelected(true);
                    break;
                }
                case TEXTURED: {
                    this.textureRadioButton.setSelected(true);
                    break;
                }
                case MODEL_MATERIALS: {
                    if (this.modelMaterialsRadioButton == null) break;
                    this.modelMaterialsRadioButton.setSelected(true);
                }
            }
            this.updateShininessRadioButtons(homeFurnitureController);
        }
    }

    private void updateShininessRadioButtons(HomeFurnitureController homeFurnitureController) {
        if (homeFurnitureController.isPropertyEditable(HomeFurnitureController.Property.SHININESS)) {
            if (homeFurnitureController.getShininess() == HomeFurnitureController.FurnitureShininess.DEFAULT) {
                this.defaultShininessRadioButton.setSelected(true);
            } else if (homeFurnitureController.getShininess() == HomeFurnitureController.FurnitureShininess.MATT) {
                this.mattRadioButton.setSelected(true);
            } else if (homeFurnitureController.getShininess() == HomeFurnitureController.FurnitureShininess.SHINY) {
                this.shinyRadioButton.setSelected(true);
            } else {
                SwingTools.deselectAllRadioButtons(this.defaultShininessRadioButton, this.mattRadioButton, this.shinyRadioButton);
            }
            boolean bl = homeFurnitureController.getPaint() != HomeFurnitureController.FurniturePaint.MODEL_MATERIALS;
            this.defaultShininessRadioButton.setEnabled(bl);
            this.mattRadioButton.setEnabled(bl);
            this.shinyRadioButton.setEnabled(bl);
            if (!bl) {
                SwingTools.deselectAllRadioButtons(this.defaultShininessRadioButton, this.mattRadioButton, this.shinyRadioButton);
            }
        }
    }

    private void updateSizeComponents(HomeFurnitureController homeFurnitureController) {
        boolean bl = homeFurnitureController.isResizable();
        this.widthLabel.setEnabled(bl);
        this.widthSpinner.setEnabled(bl);
        this.depthLabel.setEnabled(bl);
        this.depthSpinner.setEnabled(bl);
        this.heightLabel.setEnabled(bl);
        this.heightSpinner.setEnabled(bl);
        this.keepProportionsCheckBox.setEnabled(bl && homeFurnitureController.isDeformable() && (!Boolean.getBoolean("com.eteks.sweethome3d.no3D") || homeFurnitureController.getRoll() != null && homeFurnitureController.getRoll().floatValue() == 0.0f && homeFurnitureController.getPitch() != null && homeFurnitureController.getPitch().floatValue() == 0.0f));
        this.mirroredModelCheckBox.setEnabled(bl);
    }

    private void setMnemonics(UserPreferences userPreferences) {
        if (!OperatingSystem.isMacOSX()) {
            if (this.nameLabel != null) {
                this.nameLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(HomeFurniturePanel.class, "nameLabel.mnemonic", new Object[0])).getKeyCode());
                this.nameLabel.setLabelFor(this.nameTextField);
            }
            if (this.nameVisibleCheckBox != null) {
                this.nameVisibleCheckBox.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(HomeFurniturePanel.class, "nameVisibleCheckBox.mnemonic", new Object[0])).getKeyCode());
            }
            if (this.descriptionLabel != null) {
                this.descriptionLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(HomeFurniturePanel.class, "descriptionLabel.mnemonic", new Object[0])).getKeyCode());
                this.descriptionLabel.setLabelFor(this.descriptionTextField);
            }
            if (this.priceLabel != null) {
                this.priceLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(HomeFurniturePanel.class, "priceLabel.mnemonic", new Object[0])).getKeyCode());
                this.priceLabel.setLabelFor(this.priceSpinner);
            }
            if (this.valueAddedTaxPercentageLabel != null) {
                this.valueAddedTaxPercentageLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(HomeFurniturePanel.class, "valueAddedTaxPercentageLabel.mnemonic", new Object[0])).getKeyCode());
                this.valueAddedTaxPercentageLabel.setLabelFor(this.valueAddedTaxPercentageSpinner);
            }
            if (this.xLabel != null) {
                this.xLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(HomeFurniturePanel.class, "xLabel.mnemonic", new Object[0])).getKeyCode());
                this.xLabel.setLabelFor(this.xSpinner);
            }
            if (this.yLabel != null) {
                this.yLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(HomeFurniturePanel.class, "yLabel.mnemonic", new Object[0])).getKeyCode());
                this.yLabel.setLabelFor(this.ySpinner);
            }
            if (this.elevationLabel != null) {
                this.elevationLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(HomeFurniturePanel.class, "elevationLabel.mnemonic", new Object[0])).getKeyCode());
                this.elevationLabel.setLabelFor(this.elevationSpinner);
            }
            if (this.angleLabel != null) {
                this.angleLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(HomeFurniturePanel.class, "angleLabel.mnemonic", new Object[0])).getKeyCode());
                this.angleLabel.setLabelFor(this.angleSpinner);
            }
            if (this.rollRadioButton != null) {
                this.rollRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(HomeFurniturePanel.class, "rollRadioButton.mnemonic", new Object[0])).getKeyCode());
            }
            if (this.pitchRadioButton != null) {
                this.pitchRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(HomeFurniturePanel.class, "pitchRadioButton.mnemonic", new Object[0])).getKeyCode());
            }
            if (this.keepProportionsCheckBox != null) {
                this.keepProportionsCheckBox.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(HomeFurniturePanel.class, "keepProportionsCheckBox.mnemonic", new Object[0])).getKeyCode());
            }
            if (this.widthLabel != null) {
                this.widthLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(HomeFurniturePanel.class, "widthLabel.mnemonic", new Object[0])).getKeyCode());
                this.widthLabel.setLabelFor(this.widthSpinner);
            }
            if (this.depthLabel != null) {
                this.depthLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(HomeFurniturePanel.class, "depthLabel.mnemonic", new Object[0])).getKeyCode());
                this.depthLabel.setLabelFor(this.depthSpinner);
            }
            if (this.heightLabel != null) {
                this.heightLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(HomeFurniturePanel.class, "heightLabel.mnemonic", new Object[0])).getKeyCode());
                this.heightLabel.setLabelFor(this.heightSpinner);
            }
            if (this.modelTransformationsButton != null) {
                this.modelTransformationsButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(HomeFurniturePanel.class, "modelTransformationsButton.mnemonic", new Object[0])).getKeyCode());
            }
            if (this.basePlanItemCheckBox != null) {
                this.basePlanItemCheckBox.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(HomeFurniturePanel.class, "basePlanItemCheckBox.mnemonic", new Object[0])).getKeyCode());
            }
            if (this.mirroredModelCheckBox != null) {
                this.mirroredModelCheckBox.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(HomeFurniturePanel.class, "mirroredModelCheckBox.mnemonic", new Object[0])).getKeyCode());
            }
            if (this.defaultColorAndTextureRadioButton != null) {
                this.defaultColorAndTextureRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(HomeFurniturePanel.class, "defaultColorAndTextureRadioButton.mnemonic", new Object[0])).getKeyCode());
                this.colorRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(HomeFurniturePanel.class, "colorRadioButton.mnemonic", new Object[0])).getKeyCode());
                this.textureRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(HomeFurniturePanel.class, "textureRadioButton.mnemonic", new Object[0])).getKeyCode());
            }
            if (this.defaultShininessRadioButton != null) {
                this.defaultShininessRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(HomeFurniturePanel.class, "defaultShininessRadioButton.mnemonic", new Object[0])).getKeyCode());
                this.mattRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(HomeFurniturePanel.class, "mattRadioButton.mnemonic", new Object[0])).getKeyCode());
                this.shinyRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(HomeFurniturePanel.class, "shinyRadioButton.mnemonic", new Object[0])).getKeyCode());
            }
            if (this.visibleCheckBox != null) {
                this.visibleCheckBox.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(HomeFurniturePanel.class, "visibleCheckBox.mnemonic", new Object[0])).getKeyCode());
            }
            if (this.lightPowerLabel != null) {
                this.lightPowerLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(HomeFurniturePanel.class, "lightPowerLabel.mnemonic", new Object[0])).getKeyCode());
                this.lightPowerLabel.setLabelFor(this.lightPowerSpinner);
            }
        }
    }

    private void layoutComponents(UserPreferences userPreferences, HomeFurnitureController homeFurnitureController) {
        JComponent jComponent;
        JComponent jComponent2;
        JPanel jPanel;
        int n;
        int n2 = OperatingSystem.isMacOSX() ? 22 : 21;
        boolean bl = this.priceLabel != null;
        boolean bl2 = this.angleLabel != null && (this.rollRadioButton != null || this.pitchRadioButton != null);
        JPanel jPanel2 = SwingTools.createTitledPanel(userPreferences.getLocalizedString(HomeFurniturePanel.class, bl ? "nameAndPricePanel.title" : "namePanel.title", new Object[0]));
        int n3 = Math.round(5.0f * SwingTools.getResolutionScale());
        int n4 = n = OperatingSystem.isMacOSXLeopardOrSuperior() ? 0 : n3;
        if (this.nameLabel != null) {
            jPanel2.add((Component)this.nameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, n2, 0, new Insets(0, 0, 0, n3), 0, 0));
            jPanel2.add((Component)this.nameTextField, new GridBagConstraints(1, 0, 3, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
        }
        if (this.nameVisibleCheckBox != null) {
            jPanel2.add((Component)this.nameVisibleCheckBox, new GridBagConstraints(4, 0, 2, 1, 0.0, 0.0, 21, 0, new Insets(0, 10, 0, 0), 0, 0));
        }
        if (this.descriptionLabel != null) {
            jPanel2.add((Component)this.descriptionLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, n2, 0, new Insets(n3, 0, 0, n3), 0, 0));
            jPanel2.add((Component)this.descriptionTextField, new GridBagConstraints(1, 1, bl ? 1 : 3, 1, 0.0, 0.0, 21, 2, new Insets(n3, 0, 0, bl ? 10 : 0), 0, 0));
        }
        if (bl) {
            jPanel2.add((Component)this.priceLabel, new GridBagConstraints(this.descriptionLabel != null ? 2 : 0, 1, 1, 1, 0.0, 0.0, n2, 0, new Insets(n3, 0, 0, n3), 0, 0));
            jPanel2.add((Component)this.priceSpinner, new GridBagConstraints(this.descriptionLabel != null ? 3 : 1, 1, 1, 1, 0.0, 0.0, 21, 2, new Insets(n3, 0, 0, 0), OperatingSystem.isMacOSX() ? -60 : -30, 0));
            if (this.valueAddedTaxPercentageLabel != null) {
                jPanel2.add((Component)this.valueAddedTaxPercentageLabel, new GridBagConstraints(this.descriptionLabel != null ? 4 : 2, 1, 1, 1, 0.0, 0.0, n2, 0, new Insets(n3, 10, 0, n3), 0, 0));
                jPanel2.add((Component)this.valueAddedTaxPercentageSpinner, new GridBagConstraints(this.descriptionLabel != null ? 5 : 3, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(n3, 0, 0, 0), 0, 0));
            }
        }
        if (jPanel2.getComponentCount() > 0) {
            this.add((Component)jPanel2, new GridBagConstraints(0, 0, bl2 ? 4 : 3, 1, 0.0, 0.0, n2, 2, new Insets(0, 0, n, 0), 0, 0));
        }
        JPanel jPanel3 = SwingTools.createTitledPanel(userPreferences.getLocalizedString(HomeFurniturePanel.class, "locationPanel.title", new Object[0]));
        Insets insets = new Insets(0, 0, n3, n3);
        Insets insets2 = new Insets(0, 0, n3, 0);
        if (this.xLabel != null) {
            jPanel3.add((Component)this.xLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, n2, 0, insets, 0, 0));
            jPanel3.add((Component)this.xSpinner, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 21, 2, insets2, -15, 0));
        }
        if (this.yLabel != null) {
            jPanel3.add((Component)this.yLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, n2, 0, insets, 0, 0));
            jPanel3.add((Component)this.ySpinner, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 21, 2, insets2, -15, 0));
        }
        if (this.elevationLabel != null) {
            jPanel3.add((Component)this.elevationLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, n2, 0, insets, 0, 0));
            jPanel3.add((Component)this.elevationSpinner, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 21, 2, insets2, -15, 0));
        }
        if (this.angleLabel != null && !bl2) {
            jPanel3.add((Component)this.angleLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, n2, 0, insets, 0, 0));
            jPanel3.add((Component)this.angleSpinner, new GridBagConstraints(1, 3, 1, 1, 0.0, 1.0, 21, 2, insets2, -15, 0));
        }
        if (this.mirroredModelCheckBox != null) {
            jPanel3.add((Component)this.mirroredModelCheckBox, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, OperatingSystem.isMacOSX() ? 5 : 2, 0), 0, 0));
        }
        if (this.basePlanItemCheckBox != null) {
            jPanel3.add((Component)this.basePlanItemCheckBox, new GridBagConstraints(0, 5, 2, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
        if (jPanel3.getComponentCount() > 0) {
            jPanel3.add((Component)new JLabel(), new GridBagConstraints(0, 100, 2, 1, 0.0, 1.0, 21, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)jPanel3, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, n2, 1, new Insets(0, 0, n, 0), 0, 0));
        }
        if (bl2) {
            boolean bl3;
            jPanel = SwingTools.createTitledPanel(userPreferences.getLocalizedString(HomeFurniturePanel.class, "orientationPanel.title", new Object[0]));
            jComponent2 = new JLabel(userPreferences.getLocalizedString(HomeFurniturePanel.class, "verticalRotationLabel.text", new Object[0]));
            jComponent = new JLabel(userPreferences.getLocalizedString(HomeFurniturePanel.class, "horizontalRotationLabel.text", new Object[0]));
            JLabel jLabel = new JLabel(userPreferences.getLocalizedString(HomeFurniturePanel.class, "orientationLabel.text", new Object[0]));
            boolean bl4 = bl3 = ((JLabel)jComponent2).getText().length() > 0 && ((JLabel)jComponent).getText().length() > 0;
            if (this.angleLabel != null) {
                jPanel.add((Component)this.angleLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, new JRadioButton().getPreferredSize().width, OperatingSystem.isMacOSX() || bl3 ? n3 : 2, n3), 0, 0));
                jPanel.add((Component)this.angleSpinner, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 21, 2, insets2, 10, 0));
            }
            Insets insets3 = new Insets(0, 0, bl3 ? 2 : (OperatingSystem.isMacOSX() ? 5 : 1), n3);
            Insets insets4 = new Insets(0, 0, bl3 ? 2 : n3, 0);
            Insets insets5 = new Insets(0, 0, 0, n3);
            Insets insets6 = new Insets(0, 0, 0, 0);
            if (this.pitchRadioButton != null) {
                jPanel.add((Component)this.pitchRadioButton, new GridBagConstraints(0, bl3 ? 3 : 4, 1, 1, 0.0, 0.0, 21, 0, bl3 ? insets3 : insets5, 0, 0));
                jPanel.add((Component)this.pitchSpinner, new GridBagConstraints(1, bl3 ? 3 : 4, 1, 1, 0.0, 0.0, 21, 2, bl3 ? insets4 : insets6, 10, 0));
            }
            if (this.rollRadioButton != null) {
                jPanel.add((Component)this.rollRadioButton, new GridBagConstraints(0, bl3 ? 4 : 3, 1, 1, 0.0, 0.0, 21, 0, bl3 ? insets5 : insets3, 0, 0));
                jPanel.add((Component)this.rollSpinner, new GridBagConstraints(1, bl3 ? 4 : 3, 1, 1, 0.0, 0.0, 21, 2, bl3 ? insets6 : insets4, 10, 0));
            }
            if (this.rollRadioButton != null && this.pitchRadioButton != null) {
                if (homeFurnitureController.isTexturable()) {
                    jPanel.add((Component)new JLabel(SwingTools.getScaledImageIcon(this.getClass().getResource("resources/furnitureOrientation.png"))), new GridBagConstraints(0, 6, 2, 1, 1.0, bl3 ? 1.0 : 0.0, 10, 1, new Insets(10, 0, n3, 0), 0, 0));
                }
                if (bl3) {
                    jPanel.add((Component)jComponent2, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 21, 0, new Insets(OperatingSystem.isMacOSX() ? 5 : 3, 0, OperatingSystem.isMacOSX() ? 10 : 8, 0), 0, 0));
                    jPanel.add((Component)jComponent, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 21, 0, new Insets(OperatingSystem.isMacOSX() ? 5 : 3, 0, OperatingSystem.isMacOSX() ? 9 : 8, 0), 0, 0));
                } else {
                    jLabel.setFont(UIManager.getFont("ToolTip.font"));
                    jPanel.add((Component)jLabel, new GridBagConstraints(0, 7, 2, 1, 1.0, 1.0, 11, 0, new Insets(10, 0, 0, 0), 0, 0));
                }
            }
            if (jPanel.getComponentCount() > 0) {
                this.add((Component)jPanel, new GridBagConstraints(1, 1, 1, 2, 1.0, 0.0, n2, 1, new Insets(0, 0, n, 0), 0, 0));
            }
        }
        jPanel = SwingTools.createTitledPanel(userPreferences.getLocalizedString(HomeFurniturePanel.class, "sizePanel.title", new Object[0]));
        if (this.widthLabel != null) {
            jPanel.add((Component)this.widthLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, n2, 0, insets, 0, 0));
            jPanel.add((Component)this.widthSpinner, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 21, 0, insets2, -10, 0));
        }
        if (this.depthLabel != null) {
            jPanel.add((Component)this.depthLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, n2, 0, insets, 0, 0));
            jPanel.add((Component)this.depthSpinner, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 21, 0, insets2, -10, 0));
        }
        if (this.heightLabel != null) {
            jPanel.add((Component)this.heightLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, n2, 0, insets, 0, 0));
            jPanel.add((Component)this.heightSpinner, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 21, 0, insets2, -10, 0));
        }
        if (this.keepProportionsCheckBox != null) {
            jPanel.add((Component)this.keepProportionsCheckBox, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, OperatingSystem.isMacOSX() ? 5 : 2, 0), 0, 0));
        }
        if (this.modelTransformationsButton != null) {
            jPanel.add((Component)this.modelTransformationsButton, new GridBagConstraints(0, 4, 2, 1, 0.0, 1.0, 11, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
        if (jPanel.getComponentCount() > 0) {
            jPanel.add((Component)new JLabel(), new GridBagConstraints(0, 100, 2, 1, 0.0, 1.0, 21, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)jPanel, new GridBagConstraints(bl2 ? 2 : 1, 1, 2, 1, 1.0, 1.0, n2, 1, new Insets(0, 0, n, 0), 0, 0));
        }
        jComponent2 = SwingTools.createTitledPanel(userPreferences.getLocalizedString(HomeFurniturePanel.class, "colorAndTexturePanel.title", new Object[0]));
        if (this.defaultColorAndTextureRadioButton != null) {
            int n5;
            int n6;
            if (OperatingSystem.isMacOSXLeopardOrSuperior() && OperatingSystem.isJavaVersionGreaterOrEqual("1.7")) {
                n6 = 4;
                n5 = -4;
            } else {
                n6 = 0;
                n5 = 0;
            }
            jComponent2.add((Component)this.defaultColorAndTextureRadioButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
            jComponent2.add((Component)this.colorRadioButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, n3), 0, 0));
            jComponent2.add((Component)this.colorButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 21, 2, new Insets(0, 0, n5, 0), 0, n6));
            if (this.textureComponent != null) {
                jComponent2.add((Component)this.textureRadioButton, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 21, 0, new Insets(n3, 0, 0, n3), 0, 0));
                jComponent2.add((Component)this.textureComponent, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 21, 2, new Insets(n3, 0, n5, 0), 0, n6));
            }
            if (this.modelMaterialsComponent != null) {
                jComponent2.add((Component)this.modelMaterialsRadioButton, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 21, 0, new Insets(n3, 0, 0, n3), 0, 0));
                jComponent2.add((Component)this.modelMaterialsComponent, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 21, 2, new Insets(n3, 0, n5, 0), 0, n6));
            }
            this.add((Component)jComponent2, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, n2, 1, new Insets(0, 0, n, 0), 0, 0));
            homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.TEXTURABLE, new PropertyChangeListener((JPanel)jComponent2, homeFurnitureController){
                final /* synthetic */ JPanel val$paintPanel;
                final /* synthetic */ HomeFurnitureController val$controller;
                {
                    this.val$paintPanel = jPanel;
                    this.val$controller = homeFurnitureController;
                }

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    this.val$paintPanel.setVisible(this.val$controller.isTexturable());
                }
            });
            jComponent2.setVisible(homeFurnitureController.isTexturable());
        }
        if (this.defaultShininessRadioButton != null) {
            jComponent = SwingTools.createTitledPanel(userPreferences.getLocalizedString(HomeFurniturePanel.class, "shininessPanel.title", new Object[0]));
            jComponent.add((Component)this.defaultShininessRadioButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 21, 0, new Insets(0, 0, n3, 0), 0, 0));
            jComponent.add((Component)this.mattRadioButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
            jComponent.add((Component)this.shinyRadioButton, new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 21, 0, new Insets(n3, 0, 0, 0), 0, 0));
            if (jComponent2.getComponentCount() == 7) {
                jComponent.add((Component)new JLabel(), new GridBagConstraints(0, 3, 1, 1, 0.0, 1.0, 21, 0, new Insets(n3, 0, 0, 0), 0, 0));
            }
            this.add((Component)jComponent, new GridBagConstraints(bl2 ? 2 : 1, 2, 2, 1, 0.0, 0.0, n2, 1, new Insets(0, 0, n, 0), 0, 0));
            homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.TEXTURABLE, new PropertyChangeListener((JPanel)jComponent, homeFurnitureController){
                final /* synthetic */ JPanel val$shininessPanel;
                final /* synthetic */ HomeFurnitureController val$controller;
                {
                    this.val$shininessPanel = jPanel;
                    this.val$controller = homeFurnitureController;
                }

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    this.val$shininessPanel.setVisible(this.val$controller.isTexturable());
                }
            });
            jComponent.setVisible(homeFurnitureController.isTexturable());
        }
        if (this.visibleCheckBox != null) {
            this.add((Component)this.visibleCheckBox, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 10, 0, 0), 0, 0));
        }
        if (this.lightPowerLabel != null) {
            this.add((Component)this.lightPowerLabel, new GridBagConstraints(bl2 ? 2 : 1, 3, 1, 1, 0.0, 0.0, n2, 0, new Insets(0, 10, 0, n3), 0, 0));
            this.add((Component)this.lightPowerSpinner, new GridBagConstraints(bl2 ? 3 : 2, 3, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, n3), 0, 0));
        }
    }

    @Override
    public void displayView(View view) {
        if (SwingTools.showConfirmDialog((JComponent)((Object)view), this, this.dialogTitle, this.nameTextField) == 0) {
            this.controller.modifyFurniture();
        }
    }

    private void displayModelTransformationsView(UserPreferences userPreferences, HomeFurnitureController homeFurnitureController) {
        new ModelTransformationsPanel(userPreferences, homeFurnitureController).displayView(this);
    }

    private static class ModelTransformationsPanel
    extends JPanel {
        private ModelPreviewComponent previewComponent;
        private JLabel transformationsLabel;
        private JButton resetTransformationsButton;
        private JButton viewFromFrontButton;
        private JButton viewFromSideButton;
        private JButton viewFromTopButton;
        private String dialogTitle;
        private HomeFurnitureController controller;

        public ModelTransformationsPanel(UserPreferences userPreferences, HomeFurnitureController homeFurnitureController) {
            super(new GridBagLayout());
            this.controller = homeFurnitureController;
            this.createComponents(userPreferences, homeFurnitureController);
            this.setMnemonics(userPreferences);
            this.layoutComponents();
        }

        private void createComponents(UserPreferences userPreferences, final HomeFurnitureController homeFurnitureController) {
            ModelMaterialsController modelMaterialsController = homeFurnitureController.getModelMaterialsController();
            this.previewComponent = new ModelPreviewComponent(true, true, true, true);
            this.previewComponent.setFocusable(false);
            float f = SwingTools.getResolutionScale();
            this.previewComponent.setPreferredSize(new Dimension((int)(400.0f * f), (int)(400.0f * f)));
            this.previewComponent.setModel(modelMaterialsController.getModel(), modelMaterialsController.getModelFlags(), modelMaterialsController.getModelRotation(), modelMaterialsController.getModelWidth(), modelMaterialsController.getModelDepth(), modelMaterialsController.getModelHeight());
            this.previewComponent.setModelMaterials(modelMaterialsController.getMaterials());
            this.previewComponent.setModelTransformations(homeFurnitureController.getModelTransformations());
            this.previewComponent.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                    ModelTransformationsPanel.this.updateComponents(homeFurnitureController);
                }
            });
            this.transformationsLabel = new JLabel(userPreferences.getLocalizedString(ModelTransformationsPanel.class, "transformationsLabel.text", new Object[0]));
            this.resetTransformationsButton = new JButton(new AbstractAction(SwingTools.getLocalizedLabelText(userPreferences, ModelTransformationsPanel.class, "resetTransformationsButton.text", new Object[0])){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ModelTransformationsPanel.this.previewComponent.resetModelTransformations();
                    ModelTransformationsPanel.this.updateComponents(homeFurnitureController);
                }
            });
            this.updateComponents(homeFurnitureController);
            this.viewFromFrontButton = new JButton(new AbstractAction(SwingTools.getLocalizedLabelText(userPreferences, ModelTransformationsPanel.class, "viewFromFrontButton.text", new Object[0])){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ModelTransformationsPanel.this.previewComponent.setViewYaw(0.0f);
                    ModelTransformationsPanel.this.previewComponent.setViewPitch(0.0f);
                }
            });
            this.viewFromSideButton = new JButton(new AbstractAction(SwingTools.getLocalizedLabelText(userPreferences, ModelTransformationsPanel.class, "viewFromSideButton.text", new Object[0])){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ModelTransformationsPanel.this.previewComponent.setViewYaw(1.5707964f);
                    ModelTransformationsPanel.this.previewComponent.setViewPitch(0.0f);
                }
            });
            this.viewFromTopButton = new JButton(new AbstractAction(SwingTools.getLocalizedLabelText(userPreferences, ModelTransformationsPanel.class, "viewFromTopButton.text", new Object[0])){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ModelTransformationsPanel.this.previewComponent.setViewYaw(0.0f);
                    ModelTransformationsPanel.this.previewComponent.setViewPitch(-1.5707964f);
                }
            });
            this.dialogTitle = userPreferences.getLocalizedString(ModelTransformationsPanel.class, "modelTransformations.title", new Object[0]);
        }

        private void updateComponents(HomeFurnitureController homeFurnitureController) {
            this.resetTransformationsButton.setEnabled(this.previewComponent.getModelTransformations() != null);
        }

        private void setMnemonics(UserPreferences userPreferences) {
            if (!OperatingSystem.isMacOSX()) {
                this.resetTransformationsButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(ModelTransformationsPanel.class, "resetTransformationsButton.mnemonic", new Object[0])).getKeyCode());
                this.viewFromFrontButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(ModelTransformationsPanel.class, "viewFromFrontButton.mnemonic", new Object[0])).getKeyCode());
                this.viewFromSideButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(ModelTransformationsPanel.class, "viewFromSideButton.mnemonic", new Object[0])).getKeyCode());
                this.viewFromTopButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(ModelTransformationsPanel.class, "viewFromTopButton.mnemonic", new Object[0])).getKeyCode());
            }
        }

        private void layoutComponents() {
            int n = Math.round(5.0f * SwingTools.getResolutionScale());
            this.add((Component)this.transformationsLabel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, n, 10), 0, 0));
            this.previewComponent.setPreferredSize(new Dimension(400, 400));
            this.add((Component)this.previewComponent, new GridBagConstraints(0, 1, 1, 10, 0.0, 0.0, 11, 0, new Insets(2, 0, 0, 15), 0, 0));
            this.add((Component)this.resetTransformationsButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 11, 1, new Insets(2, 0, n, 0), 0, 0));
            this.add((Component)this.viewFromFrontButton, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 11, 1, new Insets(2, 0, n, 0), 0, 0));
            this.add((Component)this.viewFromSideButton, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 11, 1, new Insets(2, 0, n, 0), 0, 0));
            this.add((Component)this.viewFromTopButton, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 11, 1, new Insets(2, 0, n, 0), 0, 0));
        }

        private void updateLocationAndSize() {
            float f = this.previewComponent.getModelX();
            float f2 = this.previewComponent.getModelY();
            float f3 = (float)((double)this.controller.getX().floatValue() + (double)f * Math.cos(this.controller.getAngle().floatValue()) - (double)f2 * Math.sin(this.controller.getAngle().floatValue()));
            float f4 = (float)((double)this.controller.getY().floatValue() + (double)f * Math.sin(this.controller.getAngle().floatValue()) + (double)f2 * Math.cos(this.controller.getAngle().floatValue()));
            float f5 = this.controller.getElevation().floatValue() + this.previewComponent.getModelElevation() + this.controller.getHeight().floatValue() / 2.0f;
            Transformation[] transformationArray = this.previewComponent.getModelTransformations();
            this.controller.setModelTransformations(transformationArray != null ? transformationArray : new Transformation[]{}, f3, f4, f5, this.previewComponent.getModelWidth(), this.previewComponent.getModelDepth(), this.previewComponent.getModelHeight());
        }

        public void displayView(View view) {
            JRootPane jRootPane = SwingUtilities.getRootPane((JComponent)((Object)view));
            if (SwingTools.showConfirmDialog(jRootPane, this, this.dialogTitle, null) == 0) {
                this.updateLocationAndSize();
            }
        }
    }
}

