// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from ATSAML11D14A.svd, see https://github.com/posborne/cmsis-svd/tree/master/data/Atmel

//go:build sam && atsaml11d14a
// +build sam,atsaml11d14a

// Microchip ATSAML11D14A Microcontroller
//

package sam

import (
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	Device       = "ATSAML11D14A"
	CPU          = "CM23"
	FPUPresent   = false
	NVICPrioBits = 2
)

// Interrupt numbers.
const (
	// Watchdog Timer
	IRQ_WDT = 1

	// Real-Time Counter
	IRQ_RTC = 2

	// External Interrupt Controller
	IRQ_EIC_0 = 3

	// External Interrupt Controller
	IRQ_EIC_1 = 4

	// External Interrupt Controller
	IRQ_EIC_2 = 5

	// External Interrupt Controller
	IRQ_EIC_3 = 6

	// External Interrupt Controller
	IRQ_EIC_OTHER = 7

	// Frequency Meter
	IRQ_FREQM = 8

	// Non-Volatile Memory Controller
	IRQ_NVMCTRL = 9

	// Port Module
	IRQ_PORT = 10

	// Direct Memory Access Controller
	IRQ_DMAC_0 = 11

	// Direct Memory Access Controller
	IRQ_DMAC_1 = 12

	// Direct Memory Access Controller
	IRQ_DMAC_2 = 13

	// Direct Memory Access Controller
	IRQ_DMAC_3 = 14

	// Direct Memory Access Controller
	IRQ_DMAC_OTHER = 15

	// Event System Interface
	IRQ_EVSYS_0 = 16

	// Event System Interface
	IRQ_EVSYS_1 = 17

	// Event System Interface
	IRQ_EVSYS_2 = 18

	// Event System Interface
	IRQ_EVSYS_3 = 19

	// Event System Interface
	IRQ_EVSYS_NSCHK = 20

	// Peripheral Access Controller
	IRQ_PAC = 21

	// Serial Communication Interface
	IRQ_SERCOM0_0 = 22

	// Serial Communication Interface
	IRQ_SERCOM0_1 = 23

	// Serial Communication Interface
	IRQ_SERCOM0_2 = 24

	// Serial Communication Interface
	IRQ_SERCOM0_OTHER = 25

	IRQ_SERCOM1_0 = 26

	IRQ_SERCOM1_1 = 27

	IRQ_SERCOM1_2 = 28

	IRQ_SERCOM1_OTHER = 29

	// Basic Timer Counter
	IRQ_TC0 = 34

	IRQ_TC1 = 35

	IRQ_TC2 = 36

	// Analog Digital Converter
	IRQ_ADC_OTHER = 37

	// Analog Digital Converter
	IRQ_ADC_RESRDY = 38

	// Analog Comparators
	IRQ_AC = 39

	// Digital Analog Converter
	IRQ_DAC_UNDERRUN_A = 40

	// Digital Analog Converter
	IRQ_DAC_EMPTY = 41

	// Peripheral Touch Controller
	IRQ_PTC = 42

	// True Random Generator
	IRQ_TRNG = 43

	// TrustRAM
	IRQ_TRAM = 44

	// Highest interrupt number on this device.
	IRQ_max = 44
)

// Pseudo function call that is replaced by the compiler with the actual
// functions registered through interrupt.New.
//
//go:linkname callHandlers runtime/interrupt.callHandlers
func callHandlers(num int)

//export WDT_IRQHandler
func interruptWDT() {
	callHandlers(IRQ_WDT)
}

//export RTC_IRQHandler
func interruptRTC() {
	callHandlers(IRQ_RTC)
}

//export EIC_0_IRQHandler
func interruptEIC_0() {
	callHandlers(IRQ_EIC_0)
}

//export EIC_1_IRQHandler
func interruptEIC_1() {
	callHandlers(IRQ_EIC_1)
}

//export EIC_2_IRQHandler
func interruptEIC_2() {
	callHandlers(IRQ_EIC_2)
}

//export EIC_3_IRQHandler
func interruptEIC_3() {
	callHandlers(IRQ_EIC_3)
}

//export EIC_OTHER_IRQHandler
func interruptEIC_OTHER() {
	callHandlers(IRQ_EIC_OTHER)
}

//export FREQM_IRQHandler
func interruptFREQM() {
	callHandlers(IRQ_FREQM)
}

//export NVMCTRL_IRQHandler
func interruptNVMCTRL() {
	callHandlers(IRQ_NVMCTRL)
}

//export PORT_IRQHandler
func interruptPORT() {
	callHandlers(IRQ_PORT)
}

//export DMAC_0_IRQHandler
func interruptDMAC_0() {
	callHandlers(IRQ_DMAC_0)
}

//export DMAC_1_IRQHandler
func interruptDMAC_1() {
	callHandlers(IRQ_DMAC_1)
}

//export DMAC_2_IRQHandler
func interruptDMAC_2() {
	callHandlers(IRQ_DMAC_2)
}

//export DMAC_3_IRQHandler
func interruptDMAC_3() {
	callHandlers(IRQ_DMAC_3)
}

//export DMAC_OTHER_IRQHandler
func interruptDMAC_OTHER() {
	callHandlers(IRQ_DMAC_OTHER)
}

//export EVSYS_0_IRQHandler
func interruptEVSYS_0() {
	callHandlers(IRQ_EVSYS_0)
}

//export EVSYS_1_IRQHandler
func interruptEVSYS_1() {
	callHandlers(IRQ_EVSYS_1)
}

//export EVSYS_2_IRQHandler
func interruptEVSYS_2() {
	callHandlers(IRQ_EVSYS_2)
}

//export EVSYS_3_IRQHandler
func interruptEVSYS_3() {
	callHandlers(IRQ_EVSYS_3)
}

//export EVSYS_NSCHK_IRQHandler
func interruptEVSYS_NSCHK() {
	callHandlers(IRQ_EVSYS_NSCHK)
}

//export PAC_IRQHandler
func interruptPAC() {
	callHandlers(IRQ_PAC)
}

//export SERCOM0_0_IRQHandler
func interruptSERCOM0_0() {
	callHandlers(IRQ_SERCOM0_0)
}

//export SERCOM0_1_IRQHandler
func interruptSERCOM0_1() {
	callHandlers(IRQ_SERCOM0_1)
}

//export SERCOM0_2_IRQHandler
func interruptSERCOM0_2() {
	callHandlers(IRQ_SERCOM0_2)
}

//export SERCOM0_OTHER_IRQHandler
func interruptSERCOM0_OTHER() {
	callHandlers(IRQ_SERCOM0_OTHER)
}

//export SERCOM1_0_IRQHandler
func interruptSERCOM1_0() {
	callHandlers(IRQ_SERCOM1_0)
}

//export SERCOM1_1_IRQHandler
func interruptSERCOM1_1() {
	callHandlers(IRQ_SERCOM1_1)
}

//export SERCOM1_2_IRQHandler
func interruptSERCOM1_2() {
	callHandlers(IRQ_SERCOM1_2)
}

//export SERCOM1_OTHER_IRQHandler
func interruptSERCOM1_OTHER() {
	callHandlers(IRQ_SERCOM1_OTHER)
}

//export TC0_IRQHandler
func interruptTC0() {
	callHandlers(IRQ_TC0)
}

//export TC1_IRQHandler
func interruptTC1() {
	callHandlers(IRQ_TC1)
}

//export TC2_IRQHandler
func interruptTC2() {
	callHandlers(IRQ_TC2)
}

//export ADC_OTHER_IRQHandler
func interruptADC_OTHER() {
	callHandlers(IRQ_ADC_OTHER)
}

//export ADC_RESRDY_IRQHandler
func interruptADC_RESRDY() {
	callHandlers(IRQ_ADC_RESRDY)
}

//export AC_IRQHandler
func interruptAC() {
	callHandlers(IRQ_AC)
}

//export DAC_UNDERRUN_A_IRQHandler
func interruptDAC_UNDERRUN_A() {
	callHandlers(IRQ_DAC_UNDERRUN_A)
}

//export DAC_EMPTY_IRQHandler
func interruptDAC_EMPTY() {
	callHandlers(IRQ_DAC_EMPTY)
}

//export PTC_IRQHandler
func interruptPTC() {
	callHandlers(IRQ_PTC)
}

//export TRNG_IRQHandler
func interruptTRNG() {
	callHandlers(IRQ_TRNG)
}

//export TRAM_IRQHandler
func interruptTRAM() {
	callHandlers(IRQ_TRAM)
}

// Peripherals.
var (
	// Analog Comparators
	AC = (*AC_Type)(unsafe.Pointer(uintptr(0x40003400)))

	// Analog Digital Converter
	ADC = (*ADC_Type)(unsafe.Pointer(uintptr(0x42001c00)))

	// Configurable Custom Logic
	CCL = (*CCL_Type)(unsafe.Pointer(uintptr(0x42002c00)))

	// Digital Analog Converter
	DAC = (*DAC_Type)(unsafe.Pointer(uintptr(0x42002000)))

	// Direct Memory Access Controller
	DMAC = (*DMAC_Type)(unsafe.Pointer(uintptr(0x41006000)))

	// Device Service Unit
	DSU = (*DSU_Type)(unsafe.Pointer(uintptr(0x41002000)))

	// Device Service Unit
	DSU_EXT = (*DSU_Type)(unsafe.Pointer(uintptr(0x41002100)))

	// External Interrupt Controller
	EIC = (*EIC_Type)(unsafe.Pointer(uintptr(0x40002800)))

	// External Interrupt Controller
	EIC_SEC = (*EIC_Type)(unsafe.Pointer(uintptr(0x40002a00)))

	// Event System Interface
	EVSYS = (*EVSYS_Type)(unsafe.Pointer(uintptr(0x42000000)))

	// Event System Interface
	EVSYS_SEC = (*EVSYS_Type)(unsafe.Pointer(uintptr(0x42000200)))

	// Frequency Meter
	FREQM = (*FREQM_Type)(unsafe.Pointer(uintptr(0x40002c00)))

	// Generic Clock Generator
	GCLK = (*GCLK_Type)(unsafe.Pointer(uintptr(0x40001c00)))

	// Implementation Defined Attribution Unit
	IDAU = (*IDAU_Type)(unsafe.Pointer(uintptr(0x41000000)))

	// Main Clock
	MCLK = (*MCLK_Type)(unsafe.Pointer(uintptr(0x40000800)))

	// Non-Volatile Memory Controller
	NVMCTRL = (*NVMCTRL_Type)(unsafe.Pointer(uintptr(0x41004000)))

	// Non-Volatile Memory Controller
	NVMCTRL_SEC = (*NVMCTRL_Type)(unsafe.Pointer(uintptr(0x41005000)))

	// Operational Amplifier
	OPAMP = (*OPAMP_Type)(unsafe.Pointer(uintptr(0x42003000)))

	// Oscillators Control
	OSCCTRL = (*OSCCTRL_Type)(unsafe.Pointer(uintptr(0x40001000)))

	// 32k Oscillators Control
	OSC32KCTRL = (*OSC32KCTRL_Type)(unsafe.Pointer(uintptr(0x40001400)))

	// Peripheral Access Controller
	PAC = (*PAC_Type)(unsafe.Pointer(uintptr(0x40000000)))

	// Peripheral Access Controller
	PAC_SEC = (*PAC_Type)(unsafe.Pointer(uintptr(0x40000200)))

	// Power Manager
	PM = (*PM_Type)(unsafe.Pointer(uintptr(0x40000400)))

	// Port Module
	PORT = (*PORT_Type)(unsafe.Pointer(uintptr(0x40003000)))

	// Port Module
	PORT_SEC = (*PORT_Type)(unsafe.Pointer(uintptr(0x40003200)))

	// Port Module
	PORT_IOBUS = (*PORT_Type)(unsafe.Pointer(uintptr(0x60000000)))

	// Port Module
	PORT_IOBUS_SEC = (*PORT_Type)(unsafe.Pointer(uintptr(0x60000200)))

	// Peripheral Touch Controller
	PTC = (*PTC_Type)(unsafe.Pointer(uintptr(0x42002400)))

	// Reset Controller
	RSTC = (*RSTC_Type)(unsafe.Pointer(uintptr(0x40000c00)))

	// Real-Time Counter
	RTC = (*RTC_Type)(unsafe.Pointer(uintptr(0x40002400)))

	// Real-Time Counter - MODE0
	RTC_MODE0 = (*RTC_MODE0_Type)(unsafe.Pointer(uintptr(0x40002400)))

	// Real-Time Counter - MODE1
	RTC_MODE1 = (*RTC_MODE1_Type)(unsafe.Pointer(uintptr(0x40002400)))

	// Real-Time Counter - MODE2
	RTC_MODE2 = (*RTC_MODE2_Type)(unsafe.Pointer(uintptr(0x40002400)))

	// Serial Communication Interface
	SERCOM0 = (*SERCOM_Type)(unsafe.Pointer(uintptr(0x42000400)))

	// Serial Communication Interface - I2CM
	SERCOM0_I2CM = (*SERCOM_I2CM_Type)(unsafe.Pointer(uintptr(0x42000400)))

	// Serial Communication Interface - I2CS
	SERCOM0_I2CS = (*SERCOM_I2CS_Type)(unsafe.Pointer(uintptr(0x42000400)))

	// Serial Communication Interface - SPI
	SERCOM0_SPI = (*SERCOM_SPI_Type)(unsafe.Pointer(uintptr(0x42000400)))

	// Serial Communication Interface - USART
	SERCOM0_USART = (*SERCOM_USART_Type)(unsafe.Pointer(uintptr(0x42000400)))

	// Supply Controller
	SUPC = (*SUPC_Type)(unsafe.Pointer(uintptr(0x40001800)))

	// Basic Timer Counter
	TC0 = (*TC_Type)(unsafe.Pointer(uintptr(0x42001000)))

	// Basic Timer Counter - COUNT8
	TC0_COUNT8 = (*TC_COUNT8_Type)(unsafe.Pointer(uintptr(0x42001000)))

	// Basic Timer Counter - COUNT16
	TC0_COUNT16 = (*TC_COUNT16_Type)(unsafe.Pointer(uintptr(0x42001000)))

	// Basic Timer Counter - COUNT32
	TC0_COUNT32 = (*TC_COUNT32_Type)(unsafe.Pointer(uintptr(0x42001000)))

	// TrustRAM
	TRAM = (*TRAM_Type)(unsafe.Pointer(uintptr(0x42003400)))

	// True Random Generator
	TRNG = (*TRNG_Type)(unsafe.Pointer(uintptr(0x42002800)))

	// Watchdog Timer
	WDT = (*WDT_Type)(unsafe.Pointer(uintptr(0x40002000)))

	// Debug Control Block
	CoreDebug = (*CoreDebug_Type)(unsafe.Pointer(uintptr(0xe000edf0)))

	// Debug Control Block
	CoreDebug_NS = (*CoreDebug_Type)(unsafe.Pointer(uintptr(0xe002edf0)))

	// Debug Identification Block
	DIB = (*DIB_Type)(unsafe.Pointer(uintptr(0xe000efb0)))

	// Debug Identification Block
	DIB_NS = (*DIB_Type)(unsafe.Pointer(uintptr(0xe002efb0)))

	// Data Watchpoint and Trace
	DWT = (*DWT_Type)(unsafe.Pointer(uintptr(0xe0001000)))

	// Flash Patch and Breakpoint
	FPB = (*FPB_Type)(unsafe.Pointer(uintptr(0xe0002000)))

	// Implementation Control Block
	ICB = (*ICB_Type)(unsafe.Pointer(uintptr(0xe000e000)))

	// Implementation Control Block
	ICB_NS = (*ICB_Type)(unsafe.Pointer(uintptr(0xe002e000)))

	// Memory Protection Unit
	MPU = (*MPU_Type)(unsafe.Pointer(uintptr(0xe000ed90)))

	// Memory Protection Unit
	MPU_NS = (*MPU_Type)(unsafe.Pointer(uintptr(0xe002ed90)))

	// Nested Vectored Interrupt Controller
	NVIC = (*NVIC_Type)(unsafe.Pointer(uintptr(0xe000e100)))

	// Nested Vectored Interrupt Controller
	NVIC_NS = (*NVIC_Type)(unsafe.Pointer(uintptr(0xe002e100)))

	// System Control Block
	SCB = (*SCB_Type)(unsafe.Pointer(uintptr(0xe000ed00)))

	// System Control Block
	SCB_NS = (*SCB_Type)(unsafe.Pointer(uintptr(0xe002ed00)))

	// SysTick Timer
	SysTick = (*SysTick_Type)(unsafe.Pointer(uintptr(0xe000e010)))

	// SysTick Timer
	SysTick_NS = (*SysTick_Type)(unsafe.Pointer(uintptr(0xe002e010)))

	// Serial Communication Interface
	SERCOM1 = (*SERCOM_Type)(unsafe.Pointer(uintptr(0x42000800)))

	// Serial Communication Interface - I2CM
	SERCOM1_I2CM = (*SERCOM_I2CM_Type)(unsafe.Pointer(uintptr(0x42000800)))

	// Serial Communication Interface - I2CS
	SERCOM1_I2CS = (*SERCOM_I2CS_Type)(unsafe.Pointer(uintptr(0x42000800)))

	// Serial Communication Interface - SPI
	SERCOM1_SPI = (*SERCOM_SPI_Type)(unsafe.Pointer(uintptr(0x42000800)))

	// Serial Communication Interface - USART
	SERCOM1_USART = (*SERCOM_USART_Type)(unsafe.Pointer(uintptr(0x42000800)))

	// Basic Timer Counter
	TC1 = (*TC_Type)(unsafe.Pointer(uintptr(0x42001400)))

	// Basic Timer Counter - COUNT8
	TC1_COUNT8 = (*TC_COUNT8_Type)(unsafe.Pointer(uintptr(0x42001400)))

	// Basic Timer Counter - COUNT16
	TC1_COUNT16 = (*TC_COUNT16_Type)(unsafe.Pointer(uintptr(0x42001400)))

	// Basic Timer Counter - COUNT32
	TC1_COUNT32 = (*TC_COUNT32_Type)(unsafe.Pointer(uintptr(0x42001400)))

	// Basic Timer Counter
	TC2 = (*TC_Type)(unsafe.Pointer(uintptr(0x42001800)))

	// Basic Timer Counter - COUNT8
	TC2_COUNT8 = (*TC_COUNT8_Type)(unsafe.Pointer(uintptr(0x42001800)))

	// Basic Timer Counter - COUNT16
	TC2_COUNT16 = (*TC_COUNT16_Type)(unsafe.Pointer(uintptr(0x42001800)))

	// Basic Timer Counter - COUNT32
	TC2_COUNT32 = (*TC_COUNT32_Type)(unsafe.Pointer(uintptr(0x42001800)))
)

// Analog Comparators
type AC_Type struct {
	CTRLA    volatile.Register8  // 0x0
	CTRLB    volatile.Register8  // 0x1
	EVCTRL   volatile.Register16 // 0x2
	INTENCLR volatile.Register8  // 0x4
	INTENSET volatile.Register8  // 0x5
	INTFLAG  volatile.Register8  // 0x6
	STATUSA  volatile.Register8  // 0x7
	STATUSB  volatile.Register8  // 0x8
	DBGCTRL  volatile.Register8  // 0x9
	WINCTRL  volatile.Register8  // 0xA
	_        byte
	SCALER   [2]volatile.Register8 // 0xC
	_        [2]byte
	COMPCTRL [2]volatile.Register32 // 0x10
	_        [8]byte
	SYNCBUSY volatile.Register32 // 0x20
}

// AC.CTRLA: Control A
func (o *AC_Type) SetCTRLA_SWRST(value uint8) {
	volatile.StoreUint8(&o.CTRLA.Reg, volatile.LoadUint8(&o.CTRLA.Reg)&^(0x1)|value)
}
func (o *AC_Type) GetCTRLA_SWRST() uint8 {
	return volatile.LoadUint8(&o.CTRLA.Reg) & 0x1
}
func (o *AC_Type) SetCTRLA_ENABLE(value uint8) {
	volatile.StoreUint8(&o.CTRLA.Reg, volatile.LoadUint8(&o.CTRLA.Reg)&^(0x2)|value<<1)
}
func (o *AC_Type) GetCTRLA_ENABLE() uint8 {
	return (volatile.LoadUint8(&o.CTRLA.Reg) & 0x2) >> 1
}

// AC.CTRLB: Control B
func (o *AC_Type) SetCTRLB_START0(value uint8) {
	volatile.StoreUint8(&o.CTRLB.Reg, volatile.LoadUint8(&o.CTRLB.Reg)&^(0x1)|value)
}
func (o *AC_Type) GetCTRLB_START0() uint8 {
	return volatile.LoadUint8(&o.CTRLB.Reg) & 0x1
}
func (o *AC_Type) SetCTRLB_START1(value uint8) {
	volatile.StoreUint8(&o.CTRLB.Reg, volatile.LoadUint8(&o.CTRLB.Reg)&^(0x2)|value<<1)
}
func (o *AC_Type) GetCTRLB_START1() uint8 {
	return (volatile.LoadUint8(&o.CTRLB.Reg) & 0x2) >> 1
}

// AC.EVCTRL: Event Control
func (o *AC_Type) SetEVCTRL_COMPEO0(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x1)|value)
}
func (o *AC_Type) GetEVCTRL_COMPEO0() uint16 {
	return volatile.LoadUint16(&o.EVCTRL.Reg) & 0x1
}
func (o *AC_Type) SetEVCTRL_COMPEO1(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x2)|value<<1)
}
func (o *AC_Type) GetEVCTRL_COMPEO1() uint16 {
	return (volatile.LoadUint16(&o.EVCTRL.Reg) & 0x2) >> 1
}
func (o *AC_Type) SetEVCTRL_WINEO0(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x10)|value<<4)
}
func (o *AC_Type) GetEVCTRL_WINEO0() uint16 {
	return (volatile.LoadUint16(&o.EVCTRL.Reg) & 0x10) >> 4
}
func (o *AC_Type) SetEVCTRL_COMPEI0(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x100)|value<<8)
}
func (o *AC_Type) GetEVCTRL_COMPEI0() uint16 {
	return (volatile.LoadUint16(&o.EVCTRL.Reg) & 0x100) >> 8
}
func (o *AC_Type) SetEVCTRL_COMPEI1(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x200)|value<<9)
}
func (o *AC_Type) GetEVCTRL_COMPEI1() uint16 {
	return (volatile.LoadUint16(&o.EVCTRL.Reg) & 0x200) >> 9
}
func (o *AC_Type) SetEVCTRL_INVEI0(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x1000)|value<<12)
}
func (o *AC_Type) GetEVCTRL_INVEI0() uint16 {
	return (volatile.LoadUint16(&o.EVCTRL.Reg) & 0x1000) >> 12
}
func (o *AC_Type) SetEVCTRL_INVEI1(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x2000)|value<<13)
}
func (o *AC_Type) GetEVCTRL_INVEI1() uint16 {
	return (volatile.LoadUint16(&o.EVCTRL.Reg) & 0x2000) >> 13
}

// AC.INTENCLR: Interrupt Enable Clear
func (o *AC_Type) SetINTENCLR_COMP0(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *AC_Type) GetINTENCLR_COMP0() uint8 {
	return volatile.LoadUint8(&o.INTENCLR.Reg) & 0x1
}
func (o *AC_Type) SetINTENCLR_COMP1(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *AC_Type) GetINTENCLR_COMP1() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *AC_Type) SetINTENCLR_WIN0(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x10)|value<<4)
}
func (o *AC_Type) GetINTENCLR_WIN0() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x10) >> 4
}

// AC.INTENSET: Interrupt Enable Set
func (o *AC_Type) SetINTENSET_COMP0(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *AC_Type) GetINTENSET_COMP0() uint8 {
	return volatile.LoadUint8(&o.INTENSET.Reg) & 0x1
}
func (o *AC_Type) SetINTENSET_COMP1(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *AC_Type) GetINTENSET_COMP1() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *AC_Type) SetINTENSET_WIN0(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x10)|value<<4)
}
func (o *AC_Type) GetINTENSET_WIN0() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x10) >> 4
}

// AC.INTFLAG: Interrupt Flag Status and Clear
func (o *AC_Type) SetINTFLAG_COMP0(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x1)|value)
}
func (o *AC_Type) GetINTFLAG_COMP0() uint8 {
	return volatile.LoadUint8(&o.INTFLAG.Reg) & 0x1
}
func (o *AC_Type) SetINTFLAG_COMP1(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x2)|value<<1)
}
func (o *AC_Type) GetINTFLAG_COMP1() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x2) >> 1
}
func (o *AC_Type) SetINTFLAG_WIN0(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x10)|value<<4)
}
func (o *AC_Type) GetINTFLAG_WIN0() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x10) >> 4
}

// AC.STATUSA: Status A
func (o *AC_Type) SetSTATUSA_STATE0(value uint8) {
	volatile.StoreUint8(&o.STATUSA.Reg, volatile.LoadUint8(&o.STATUSA.Reg)&^(0x1)|value)
}
func (o *AC_Type) GetSTATUSA_STATE0() uint8 {
	return volatile.LoadUint8(&o.STATUSA.Reg) & 0x1
}
func (o *AC_Type) SetSTATUSA_STATE1(value uint8) {
	volatile.StoreUint8(&o.STATUSA.Reg, volatile.LoadUint8(&o.STATUSA.Reg)&^(0x2)|value<<1)
}
func (o *AC_Type) GetSTATUSA_STATE1() uint8 {
	return (volatile.LoadUint8(&o.STATUSA.Reg) & 0x2) >> 1
}
func (o *AC_Type) SetSTATUSA_WSTATE0(value uint8) {
	volatile.StoreUint8(&o.STATUSA.Reg, volatile.LoadUint8(&o.STATUSA.Reg)&^(0x30)|value<<4)
}
func (o *AC_Type) GetSTATUSA_WSTATE0() uint8 {
	return (volatile.LoadUint8(&o.STATUSA.Reg) & 0x30) >> 4
}

// AC.STATUSB: Status B
func (o *AC_Type) SetSTATUSB_READY0(value uint8) {
	volatile.StoreUint8(&o.STATUSB.Reg, volatile.LoadUint8(&o.STATUSB.Reg)&^(0x1)|value)
}
func (o *AC_Type) GetSTATUSB_READY0() uint8 {
	return volatile.LoadUint8(&o.STATUSB.Reg) & 0x1
}
func (o *AC_Type) SetSTATUSB_READY1(value uint8) {
	volatile.StoreUint8(&o.STATUSB.Reg, volatile.LoadUint8(&o.STATUSB.Reg)&^(0x2)|value<<1)
}
func (o *AC_Type) GetSTATUSB_READY1() uint8 {
	return (volatile.LoadUint8(&o.STATUSB.Reg) & 0x2) >> 1
}

// AC.DBGCTRL: Debug Control
func (o *AC_Type) SetDBGCTRL_DBGRUN(value uint8) {
	volatile.StoreUint8(&o.DBGCTRL.Reg, volatile.LoadUint8(&o.DBGCTRL.Reg)&^(0x1)|value)
}
func (o *AC_Type) GetDBGCTRL_DBGRUN() uint8 {
	return volatile.LoadUint8(&o.DBGCTRL.Reg) & 0x1
}

// AC.WINCTRL: Window Control
func (o *AC_Type) SetWINCTRL_WEN0(value uint8) {
	volatile.StoreUint8(&o.WINCTRL.Reg, volatile.LoadUint8(&o.WINCTRL.Reg)&^(0x1)|value)
}
func (o *AC_Type) GetWINCTRL_WEN0() uint8 {
	return volatile.LoadUint8(&o.WINCTRL.Reg) & 0x1
}
func (o *AC_Type) SetWINCTRL_WINTSEL0(value uint8) {
	volatile.StoreUint8(&o.WINCTRL.Reg, volatile.LoadUint8(&o.WINCTRL.Reg)&^(0x6)|value<<1)
}
func (o *AC_Type) GetWINCTRL_WINTSEL0() uint8 {
	return (volatile.LoadUint8(&o.WINCTRL.Reg) & 0x6) >> 1
}

// AC.SCALER: Scaler n
func (o *AC_Type) SetSCALER_VALUE(idx int, value uint8) {
	volatile.StoreUint8(&o.SCALER[idx].Reg, volatile.LoadUint8(&o.SCALER[idx].Reg)&^(0x3f)|value)
}
func (o *AC_Type) GetSCALER_VALUE(idx int) uint8 {
	return volatile.LoadUint8(&o.SCALER[idx].Reg) & 0x3f
}

// AC.COMPCTRL: Comparator Control n
func (o *AC_Type) SetCOMPCTRL_ENABLE(idx int, value uint32) {
	volatile.StoreUint32(&o.COMPCTRL[idx].Reg, volatile.LoadUint32(&o.COMPCTRL[idx].Reg)&^(0x2)|value<<1)
}
func (o *AC_Type) GetCOMPCTRL_ENABLE(idx int) uint32 {
	return (volatile.LoadUint32(&o.COMPCTRL[idx].Reg) & 0x2) >> 1
}
func (o *AC_Type) SetCOMPCTRL_SINGLE(idx int, value uint32) {
	volatile.StoreUint32(&o.COMPCTRL[idx].Reg, volatile.LoadUint32(&o.COMPCTRL[idx].Reg)&^(0x4)|value<<2)
}
func (o *AC_Type) GetCOMPCTRL_SINGLE(idx int) uint32 {
	return (volatile.LoadUint32(&o.COMPCTRL[idx].Reg) & 0x4) >> 2
}
func (o *AC_Type) SetCOMPCTRL_INTSEL(idx int, value uint32) {
	volatile.StoreUint32(&o.COMPCTRL[idx].Reg, volatile.LoadUint32(&o.COMPCTRL[idx].Reg)&^(0x18)|value<<3)
}
func (o *AC_Type) GetCOMPCTRL_INTSEL(idx int) uint32 {
	return (volatile.LoadUint32(&o.COMPCTRL[idx].Reg) & 0x18) >> 3
}
func (o *AC_Type) SetCOMPCTRL_RUNSTDBY(idx int, value uint32) {
	volatile.StoreUint32(&o.COMPCTRL[idx].Reg, volatile.LoadUint32(&o.COMPCTRL[idx].Reg)&^(0x40)|value<<6)
}
func (o *AC_Type) GetCOMPCTRL_RUNSTDBY(idx int) uint32 {
	return (volatile.LoadUint32(&o.COMPCTRL[idx].Reg) & 0x40) >> 6
}
func (o *AC_Type) SetCOMPCTRL_MUXNEG(idx int, value uint32) {
	volatile.StoreUint32(&o.COMPCTRL[idx].Reg, volatile.LoadUint32(&o.COMPCTRL[idx].Reg)&^(0x700)|value<<8)
}
func (o *AC_Type) GetCOMPCTRL_MUXNEG(idx int) uint32 {
	return (volatile.LoadUint32(&o.COMPCTRL[idx].Reg) & 0x700) >> 8
}
func (o *AC_Type) SetCOMPCTRL_MUXPOS(idx int, value uint32) {
	volatile.StoreUint32(&o.COMPCTRL[idx].Reg, volatile.LoadUint32(&o.COMPCTRL[idx].Reg)&^(0x7000)|value<<12)
}
func (o *AC_Type) GetCOMPCTRL_MUXPOS(idx int) uint32 {
	return (volatile.LoadUint32(&o.COMPCTRL[idx].Reg) & 0x7000) >> 12
}
func (o *AC_Type) SetCOMPCTRL_SWAP(idx int, value uint32) {
	volatile.StoreUint32(&o.COMPCTRL[idx].Reg, volatile.LoadUint32(&o.COMPCTRL[idx].Reg)&^(0x8000)|value<<15)
}
func (o *AC_Type) GetCOMPCTRL_SWAP(idx int) uint32 {
	return (volatile.LoadUint32(&o.COMPCTRL[idx].Reg) & 0x8000) >> 15
}
func (o *AC_Type) SetCOMPCTRL_SPEED(idx int, value uint32) {
	volatile.StoreUint32(&o.COMPCTRL[idx].Reg, volatile.LoadUint32(&o.COMPCTRL[idx].Reg)&^(0x30000)|value<<16)
}
func (o *AC_Type) GetCOMPCTRL_SPEED(idx int) uint32 {
	return (volatile.LoadUint32(&o.COMPCTRL[idx].Reg) & 0x30000) >> 16
}
func (o *AC_Type) SetCOMPCTRL_HYSTEN(idx int, value uint32) {
	volatile.StoreUint32(&o.COMPCTRL[idx].Reg, volatile.LoadUint32(&o.COMPCTRL[idx].Reg)&^(0x80000)|value<<19)
}
func (o *AC_Type) GetCOMPCTRL_HYSTEN(idx int) uint32 {
	return (volatile.LoadUint32(&o.COMPCTRL[idx].Reg) & 0x80000) >> 19
}
func (o *AC_Type) SetCOMPCTRL_HYST(idx int, value uint32) {
	volatile.StoreUint32(&o.COMPCTRL[idx].Reg, volatile.LoadUint32(&o.COMPCTRL[idx].Reg)&^(0x300000)|value<<20)
}
func (o *AC_Type) GetCOMPCTRL_HYST(idx int) uint32 {
	return (volatile.LoadUint32(&o.COMPCTRL[idx].Reg) & 0x300000) >> 20
}
func (o *AC_Type) SetCOMPCTRL_FLEN(idx int, value uint32) {
	volatile.StoreUint32(&o.COMPCTRL[idx].Reg, volatile.LoadUint32(&o.COMPCTRL[idx].Reg)&^(0x7000000)|value<<24)
}
func (o *AC_Type) GetCOMPCTRL_FLEN(idx int) uint32 {
	return (volatile.LoadUint32(&o.COMPCTRL[idx].Reg) & 0x7000000) >> 24
}
func (o *AC_Type) SetCOMPCTRL_OUT(idx int, value uint32) {
	volatile.StoreUint32(&o.COMPCTRL[idx].Reg, volatile.LoadUint32(&o.COMPCTRL[idx].Reg)&^(0x30000000)|value<<28)
}
func (o *AC_Type) GetCOMPCTRL_OUT(idx int) uint32 {
	return (volatile.LoadUint32(&o.COMPCTRL[idx].Reg) & 0x30000000) >> 28
}

// AC.SYNCBUSY: Synchronization Busy
func (o *AC_Type) SetSYNCBUSY_SWRST(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x1)|value)
}
func (o *AC_Type) GetSYNCBUSY_SWRST() uint32 {
	return volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x1
}
func (o *AC_Type) SetSYNCBUSY_ENABLE(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x2)|value<<1)
}
func (o *AC_Type) GetSYNCBUSY_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x2) >> 1
}
func (o *AC_Type) SetSYNCBUSY_WINCTRL(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x4)|value<<2)
}
func (o *AC_Type) GetSYNCBUSY_WINCTRL() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x4) >> 2
}
func (o *AC_Type) SetSYNCBUSY_COMPCTRL0(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x8)|value<<3)
}
func (o *AC_Type) GetSYNCBUSY_COMPCTRL0() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x8) >> 3
}
func (o *AC_Type) SetSYNCBUSY_COMPCTRL1(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x10)|value<<4)
}
func (o *AC_Type) GetSYNCBUSY_COMPCTRL1() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x10) >> 4
}

// Analog Digital Converter
type ADC_Type struct {
	CTRLA      volatile.Register8  // 0x0
	CTRLB      volatile.Register8  // 0x1
	REFCTRL    volatile.Register8  // 0x2
	EVCTRL     volatile.Register8  // 0x3
	INTENCLR   volatile.Register8  // 0x4
	INTENSET   volatile.Register8  // 0x5
	INTFLAG    volatile.Register8  // 0x6
	SEQSTATUS  volatile.Register8  // 0x7
	INPUTCTRL  volatile.Register16 // 0x8
	CTRLC      volatile.Register16 // 0xA
	AVGCTRL    volatile.Register8  // 0xC
	SAMPCTRL   volatile.Register8  // 0xD
	WINLT      volatile.Register16 // 0xE
	WINUT      volatile.Register16 // 0x10
	GAINCORR   volatile.Register16 // 0x12
	OFFSETCORR volatile.Register16 // 0x14
	_          [2]byte
	SWTRIG     volatile.Register8 // 0x18
	_          [3]byte
	DBGCTRL    volatile.Register8 // 0x1C
	_          [3]byte
	SYNCBUSY   volatile.Register16 // 0x20
	_          [2]byte
	RESULT     volatile.Register16 // 0x24
	_          [2]byte
	SEQCTRL    volatile.Register32 // 0x28
	CALIB      volatile.Register16 // 0x2C
}

// ADC.CTRLA: Control A
func (o *ADC_Type) SetCTRLA_SWRST(value uint8) {
	volatile.StoreUint8(&o.CTRLA.Reg, volatile.LoadUint8(&o.CTRLA.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetCTRLA_SWRST() uint8 {
	return volatile.LoadUint8(&o.CTRLA.Reg) & 0x1
}
func (o *ADC_Type) SetCTRLA_ENABLE(value uint8) {
	volatile.StoreUint8(&o.CTRLA.Reg, volatile.LoadUint8(&o.CTRLA.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetCTRLA_ENABLE() uint8 {
	return (volatile.LoadUint8(&o.CTRLA.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetCTRLA_SLAVEEN(value uint8) {
	volatile.StoreUint8(&o.CTRLA.Reg, volatile.LoadUint8(&o.CTRLA.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetCTRLA_SLAVEEN() uint8 {
	return (volatile.LoadUint8(&o.CTRLA.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetCTRLA_RUNSTDBY(value uint8) {
	volatile.StoreUint8(&o.CTRLA.Reg, volatile.LoadUint8(&o.CTRLA.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetCTRLA_RUNSTDBY() uint8 {
	return (volatile.LoadUint8(&o.CTRLA.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetCTRLA_ONDEMAND(value uint8) {
	volatile.StoreUint8(&o.CTRLA.Reg, volatile.LoadUint8(&o.CTRLA.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetCTRLA_ONDEMAND() uint8 {
	return (volatile.LoadUint8(&o.CTRLA.Reg) & 0x80) >> 7
}

// ADC.CTRLB: Control B
func (o *ADC_Type) SetCTRLB_PRESCALER(value uint8) {
	volatile.StoreUint8(&o.CTRLB.Reg, volatile.LoadUint8(&o.CTRLB.Reg)&^(0x7)|value)
}
func (o *ADC_Type) GetCTRLB_PRESCALER() uint8 {
	return volatile.LoadUint8(&o.CTRLB.Reg) & 0x7
}

// ADC.REFCTRL: Reference Control
func (o *ADC_Type) SetREFCTRL_REFSEL(value uint8) {
	volatile.StoreUint8(&o.REFCTRL.Reg, volatile.LoadUint8(&o.REFCTRL.Reg)&^(0xf)|value)
}
func (o *ADC_Type) GetREFCTRL_REFSEL() uint8 {
	return volatile.LoadUint8(&o.REFCTRL.Reg) & 0xf
}
func (o *ADC_Type) SetREFCTRL_REFCOMP(value uint8) {
	volatile.StoreUint8(&o.REFCTRL.Reg, volatile.LoadUint8(&o.REFCTRL.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetREFCTRL_REFCOMP() uint8 {
	return (volatile.LoadUint8(&o.REFCTRL.Reg) & 0x80) >> 7
}

// ADC.EVCTRL: Event Control
func (o *ADC_Type) SetEVCTRL_FLUSHEI(value uint8) {
	volatile.StoreUint8(&o.EVCTRL.Reg, volatile.LoadUint8(&o.EVCTRL.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetEVCTRL_FLUSHEI() uint8 {
	return volatile.LoadUint8(&o.EVCTRL.Reg) & 0x1
}
func (o *ADC_Type) SetEVCTRL_STARTEI(value uint8) {
	volatile.StoreUint8(&o.EVCTRL.Reg, volatile.LoadUint8(&o.EVCTRL.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetEVCTRL_STARTEI() uint8 {
	return (volatile.LoadUint8(&o.EVCTRL.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetEVCTRL_FLUSHINV(value uint8) {
	volatile.StoreUint8(&o.EVCTRL.Reg, volatile.LoadUint8(&o.EVCTRL.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetEVCTRL_FLUSHINV() uint8 {
	return (volatile.LoadUint8(&o.EVCTRL.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetEVCTRL_STARTINV(value uint8) {
	volatile.StoreUint8(&o.EVCTRL.Reg, volatile.LoadUint8(&o.EVCTRL.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetEVCTRL_STARTINV() uint8 {
	return (volatile.LoadUint8(&o.EVCTRL.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetEVCTRL_RESRDYEO(value uint8) {
	volatile.StoreUint8(&o.EVCTRL.Reg, volatile.LoadUint8(&o.EVCTRL.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetEVCTRL_RESRDYEO() uint8 {
	return (volatile.LoadUint8(&o.EVCTRL.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetEVCTRL_WINMONEO(value uint8) {
	volatile.StoreUint8(&o.EVCTRL.Reg, volatile.LoadUint8(&o.EVCTRL.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetEVCTRL_WINMONEO() uint8 {
	return (volatile.LoadUint8(&o.EVCTRL.Reg) & 0x20) >> 5
}

// ADC.INTENCLR: Interrupt Enable Clear
func (o *ADC_Type) SetINTENCLR_RESRDY(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetINTENCLR_RESRDY() uint8 {
	return volatile.LoadUint8(&o.INTENCLR.Reg) & 0x1
}
func (o *ADC_Type) SetINTENCLR_OVERRUN(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetINTENCLR_OVERRUN() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetINTENCLR_WINMON(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetINTENCLR_WINMON() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x4) >> 2
}

// ADC.INTENSET: Interrupt Enable Set
func (o *ADC_Type) SetINTENSET_RESRDY(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetINTENSET_RESRDY() uint8 {
	return volatile.LoadUint8(&o.INTENSET.Reg) & 0x1
}
func (o *ADC_Type) SetINTENSET_OVERRUN(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetINTENSET_OVERRUN() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetINTENSET_WINMON(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetINTENSET_WINMON() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x4) >> 2
}

// ADC.INTFLAG: Interrupt Flag Status and Clear
func (o *ADC_Type) SetINTFLAG_RESRDY(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetINTFLAG_RESRDY() uint8 {
	return volatile.LoadUint8(&o.INTFLAG.Reg) & 0x1
}
func (o *ADC_Type) SetINTFLAG_OVERRUN(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetINTFLAG_OVERRUN() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetINTFLAG_WINMON(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetINTFLAG_WINMON() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x4) >> 2
}

// ADC.SEQSTATUS: Sequence Status
func (o *ADC_Type) SetSEQSTATUS_SEQSTATE(value uint8) {
	volatile.StoreUint8(&o.SEQSTATUS.Reg, volatile.LoadUint8(&o.SEQSTATUS.Reg)&^(0x1f)|value)
}
func (o *ADC_Type) GetSEQSTATUS_SEQSTATE() uint8 {
	return volatile.LoadUint8(&o.SEQSTATUS.Reg) & 0x1f
}
func (o *ADC_Type) SetSEQSTATUS_SEQBUSY(value uint8) {
	volatile.StoreUint8(&o.SEQSTATUS.Reg, volatile.LoadUint8(&o.SEQSTATUS.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetSEQSTATUS_SEQBUSY() uint8 {
	return (volatile.LoadUint8(&o.SEQSTATUS.Reg) & 0x80) >> 7
}

// ADC.INPUTCTRL: Input Control
func (o *ADC_Type) SetINPUTCTRL_MUXPOS(value uint16) {
	volatile.StoreUint16(&o.INPUTCTRL.Reg, volatile.LoadUint16(&o.INPUTCTRL.Reg)&^(0x1f)|value)
}
func (o *ADC_Type) GetINPUTCTRL_MUXPOS() uint16 {
	return volatile.LoadUint16(&o.INPUTCTRL.Reg) & 0x1f
}
func (o *ADC_Type) SetINPUTCTRL_MUXNEG(value uint16) {
	volatile.StoreUint16(&o.INPUTCTRL.Reg, volatile.LoadUint16(&o.INPUTCTRL.Reg)&^(0x1f00)|value<<8)
}
func (o *ADC_Type) GetINPUTCTRL_MUXNEG() uint16 {
	return (volatile.LoadUint16(&o.INPUTCTRL.Reg) & 0x1f00) >> 8
}

// ADC.CTRLC: Control C
func (o *ADC_Type) SetCTRLC_DIFFMODE(value uint16) {
	volatile.StoreUint16(&o.CTRLC.Reg, volatile.LoadUint16(&o.CTRLC.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetCTRLC_DIFFMODE() uint16 {
	return volatile.LoadUint16(&o.CTRLC.Reg) & 0x1
}
func (o *ADC_Type) SetCTRLC_LEFTADJ(value uint16) {
	volatile.StoreUint16(&o.CTRLC.Reg, volatile.LoadUint16(&o.CTRLC.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetCTRLC_LEFTADJ() uint16 {
	return (volatile.LoadUint16(&o.CTRLC.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetCTRLC_FREERUN(value uint16) {
	volatile.StoreUint16(&o.CTRLC.Reg, volatile.LoadUint16(&o.CTRLC.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetCTRLC_FREERUN() uint16 {
	return (volatile.LoadUint16(&o.CTRLC.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetCTRLC_CORREN(value uint16) {
	volatile.StoreUint16(&o.CTRLC.Reg, volatile.LoadUint16(&o.CTRLC.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetCTRLC_CORREN() uint16 {
	return (volatile.LoadUint16(&o.CTRLC.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetCTRLC_RESSEL(value uint16) {
	volatile.StoreUint16(&o.CTRLC.Reg, volatile.LoadUint16(&o.CTRLC.Reg)&^(0x30)|value<<4)
}
func (o *ADC_Type) GetCTRLC_RESSEL() uint16 {
	return (volatile.LoadUint16(&o.CTRLC.Reg) & 0x30) >> 4
}
func (o *ADC_Type) SetCTRLC_R2R(value uint16) {
	volatile.StoreUint16(&o.CTRLC.Reg, volatile.LoadUint16(&o.CTRLC.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetCTRLC_R2R() uint16 {
	return (volatile.LoadUint16(&o.CTRLC.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetCTRLC_WINMODE(value uint16) {
	volatile.StoreUint16(&o.CTRLC.Reg, volatile.LoadUint16(&o.CTRLC.Reg)&^(0x700)|value<<8)
}
func (o *ADC_Type) GetCTRLC_WINMODE() uint16 {
	return (volatile.LoadUint16(&o.CTRLC.Reg) & 0x700) >> 8
}
func (o *ADC_Type) SetCTRLC_DUALSEL(value uint16) {
	volatile.StoreUint16(&o.CTRLC.Reg, volatile.LoadUint16(&o.CTRLC.Reg)&^(0x3000)|value<<12)
}
func (o *ADC_Type) GetCTRLC_DUALSEL() uint16 {
	return (volatile.LoadUint16(&o.CTRLC.Reg) & 0x3000) >> 12
}

// ADC.AVGCTRL: Average Control
func (o *ADC_Type) SetAVGCTRL_SAMPLENUM(value uint8) {
	volatile.StoreUint8(&o.AVGCTRL.Reg, volatile.LoadUint8(&o.AVGCTRL.Reg)&^(0xf)|value)
}
func (o *ADC_Type) GetAVGCTRL_SAMPLENUM() uint8 {
	return volatile.LoadUint8(&o.AVGCTRL.Reg) & 0xf
}
func (o *ADC_Type) SetAVGCTRL_ADJRES(value uint8) {
	volatile.StoreUint8(&o.AVGCTRL.Reg, volatile.LoadUint8(&o.AVGCTRL.Reg)&^(0x70)|value<<4)
}
func (o *ADC_Type) GetAVGCTRL_ADJRES() uint8 {
	return (volatile.LoadUint8(&o.AVGCTRL.Reg) & 0x70) >> 4
}

// ADC.SAMPCTRL: Sample Time Control
func (o *ADC_Type) SetSAMPCTRL_SAMPLEN(value uint8) {
	volatile.StoreUint8(&o.SAMPCTRL.Reg, volatile.LoadUint8(&o.SAMPCTRL.Reg)&^(0x3f)|value)
}
func (o *ADC_Type) GetSAMPCTRL_SAMPLEN() uint8 {
	return volatile.LoadUint8(&o.SAMPCTRL.Reg) & 0x3f
}
func (o *ADC_Type) SetSAMPCTRL_OFFCOMP(value uint8) {
	volatile.StoreUint8(&o.SAMPCTRL.Reg, volatile.LoadUint8(&o.SAMPCTRL.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetSAMPCTRL_OFFCOMP() uint8 {
	return (volatile.LoadUint8(&o.SAMPCTRL.Reg) & 0x80) >> 7
}

// ADC.WINLT: Window Monitor Lower Threshold
func (o *ADC_Type) SetWINLT(value uint16) {
	volatile.StoreUint16(&o.WINLT.Reg, value)
}
func (o *ADC_Type) GetWINLT() uint16 {
	return volatile.LoadUint16(&o.WINLT.Reg)
}

// ADC.WINUT: Window Monitor Upper Threshold
func (o *ADC_Type) SetWINUT(value uint16) {
	volatile.StoreUint16(&o.WINUT.Reg, value)
}
func (o *ADC_Type) GetWINUT() uint16 {
	return volatile.LoadUint16(&o.WINUT.Reg)
}

// ADC.GAINCORR: Gain Correction
func (o *ADC_Type) SetGAINCORR(value uint16) {
	volatile.StoreUint16(&o.GAINCORR.Reg, volatile.LoadUint16(&o.GAINCORR.Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetGAINCORR() uint16 {
	return volatile.LoadUint16(&o.GAINCORR.Reg) & 0xfff
}

// ADC.OFFSETCORR: Offset Correction
func (o *ADC_Type) SetOFFSETCORR(value uint16) {
	volatile.StoreUint16(&o.OFFSETCORR.Reg, volatile.LoadUint16(&o.OFFSETCORR.Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetOFFSETCORR() uint16 {
	return volatile.LoadUint16(&o.OFFSETCORR.Reg) & 0xfff
}

// ADC.SWTRIG: Software Trigger
func (o *ADC_Type) SetSWTRIG_FLUSH(value uint8) {
	volatile.StoreUint8(&o.SWTRIG.Reg, volatile.LoadUint8(&o.SWTRIG.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetSWTRIG_FLUSH() uint8 {
	return volatile.LoadUint8(&o.SWTRIG.Reg) & 0x1
}
func (o *ADC_Type) SetSWTRIG_START(value uint8) {
	volatile.StoreUint8(&o.SWTRIG.Reg, volatile.LoadUint8(&o.SWTRIG.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetSWTRIG_START() uint8 {
	return (volatile.LoadUint8(&o.SWTRIG.Reg) & 0x2) >> 1
}

// ADC.DBGCTRL: Debug Control
func (o *ADC_Type) SetDBGCTRL_DBGRUN(value uint8) {
	volatile.StoreUint8(&o.DBGCTRL.Reg, volatile.LoadUint8(&o.DBGCTRL.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetDBGCTRL_DBGRUN() uint8 {
	return volatile.LoadUint8(&o.DBGCTRL.Reg) & 0x1
}

// ADC.SYNCBUSY: Synchronization Busy
func (o *ADC_Type) SetSYNCBUSY_SWRST(value uint16) {
	volatile.StoreUint16(&o.SYNCBUSY.Reg, volatile.LoadUint16(&o.SYNCBUSY.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetSYNCBUSY_SWRST() uint16 {
	return volatile.LoadUint16(&o.SYNCBUSY.Reg) & 0x1
}
func (o *ADC_Type) SetSYNCBUSY_ENABLE(value uint16) {
	volatile.StoreUint16(&o.SYNCBUSY.Reg, volatile.LoadUint16(&o.SYNCBUSY.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetSYNCBUSY_ENABLE() uint16 {
	return (volatile.LoadUint16(&o.SYNCBUSY.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetSYNCBUSY_INPUTCTRL(value uint16) {
	volatile.StoreUint16(&o.SYNCBUSY.Reg, volatile.LoadUint16(&o.SYNCBUSY.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetSYNCBUSY_INPUTCTRL() uint16 {
	return (volatile.LoadUint16(&o.SYNCBUSY.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetSYNCBUSY_CTRLC(value uint16) {
	volatile.StoreUint16(&o.SYNCBUSY.Reg, volatile.LoadUint16(&o.SYNCBUSY.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetSYNCBUSY_CTRLC() uint16 {
	return (volatile.LoadUint16(&o.SYNCBUSY.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetSYNCBUSY_AVGCTRL(value uint16) {
	volatile.StoreUint16(&o.SYNCBUSY.Reg, volatile.LoadUint16(&o.SYNCBUSY.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetSYNCBUSY_AVGCTRL() uint16 {
	return (volatile.LoadUint16(&o.SYNCBUSY.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetSYNCBUSY_SAMPCTRL(value uint16) {
	volatile.StoreUint16(&o.SYNCBUSY.Reg, volatile.LoadUint16(&o.SYNCBUSY.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetSYNCBUSY_SAMPCTRL() uint16 {
	return (volatile.LoadUint16(&o.SYNCBUSY.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetSYNCBUSY_WINLT(value uint16) {
	volatile.StoreUint16(&o.SYNCBUSY.Reg, volatile.LoadUint16(&o.SYNCBUSY.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetSYNCBUSY_WINLT() uint16 {
	return (volatile.LoadUint16(&o.SYNCBUSY.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetSYNCBUSY_WINUT(value uint16) {
	volatile.StoreUint16(&o.SYNCBUSY.Reg, volatile.LoadUint16(&o.SYNCBUSY.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetSYNCBUSY_WINUT() uint16 {
	return (volatile.LoadUint16(&o.SYNCBUSY.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetSYNCBUSY_GAINCORR(value uint16) {
	volatile.StoreUint16(&o.SYNCBUSY.Reg, volatile.LoadUint16(&o.SYNCBUSY.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetSYNCBUSY_GAINCORR() uint16 {
	return (volatile.LoadUint16(&o.SYNCBUSY.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetSYNCBUSY_OFFSETCORR(value uint16) {
	volatile.StoreUint16(&o.SYNCBUSY.Reg, volatile.LoadUint16(&o.SYNCBUSY.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetSYNCBUSY_OFFSETCORR() uint16 {
	return (volatile.LoadUint16(&o.SYNCBUSY.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetSYNCBUSY_SWTRIG(value uint16) {
	volatile.StoreUint16(&o.SYNCBUSY.Reg, volatile.LoadUint16(&o.SYNCBUSY.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetSYNCBUSY_SWTRIG() uint16 {
	return (volatile.LoadUint16(&o.SYNCBUSY.Reg) & 0x400) >> 10
}

// ADC.RESULT: Result
func (o *ADC_Type) SetRESULT(value uint16) {
	volatile.StoreUint16(&o.RESULT.Reg, value)
}
func (o *ADC_Type) GetRESULT() uint16 {
	return volatile.LoadUint16(&o.RESULT.Reg)
}

// ADC.SEQCTRL: Sequence Control
func (o *ADC_Type) SetSEQCTRL(value uint32) {
	volatile.StoreUint32(&o.SEQCTRL.Reg, value)
}
func (o *ADC_Type) GetSEQCTRL() uint32 {
	return volatile.LoadUint32(&o.SEQCTRL.Reg)
}

// ADC.CALIB: Calibration
func (o *ADC_Type) SetCALIB_BIASCOMP(value uint16) {
	volatile.StoreUint16(&o.CALIB.Reg, volatile.LoadUint16(&o.CALIB.Reg)&^(0x7)|value)
}
func (o *ADC_Type) GetCALIB_BIASCOMP() uint16 {
	return volatile.LoadUint16(&o.CALIB.Reg) & 0x7
}
func (o *ADC_Type) SetCALIB_BIASREFBUF(value uint16) {
	volatile.StoreUint16(&o.CALIB.Reg, volatile.LoadUint16(&o.CALIB.Reg)&^(0x700)|value<<8)
}
func (o *ADC_Type) GetCALIB_BIASREFBUF() uint16 {
	return (volatile.LoadUint16(&o.CALIB.Reg) & 0x700) >> 8
}

// Configurable Custom Logic
type CCL_Type struct {
	CTRL    volatile.Register8 // 0x0
	_       [3]byte
	SEQCTRL [1]volatile.Register8 // 0x4
	_       [3]byte
	LUTCTRL [2]volatile.Register32 // 0x8
}

// CCL.CTRL: Control
func (o *CCL_Type) SetCTRL_SWRST(value uint8) {
	volatile.StoreUint8(&o.CTRL.Reg, volatile.LoadUint8(&o.CTRL.Reg)&^(0x1)|value)
}
func (o *CCL_Type) GetCTRL_SWRST() uint8 {
	return volatile.LoadUint8(&o.CTRL.Reg) & 0x1
}
func (o *CCL_Type) SetCTRL_ENABLE(value uint8) {
	volatile.StoreUint8(&o.CTRL.Reg, volatile.LoadUint8(&o.CTRL.Reg)&^(0x2)|value<<1)
}
func (o *CCL_Type) GetCTRL_ENABLE() uint8 {
	return (volatile.LoadUint8(&o.CTRL.Reg) & 0x2) >> 1
}
func (o *CCL_Type) SetCTRL_RUNSTDBY(value uint8) {
	volatile.StoreUint8(&o.CTRL.Reg, volatile.LoadUint8(&o.CTRL.Reg)&^(0x40)|value<<6)
}
func (o *CCL_Type) GetCTRL_RUNSTDBY() uint8 {
	return (volatile.LoadUint8(&o.CTRL.Reg) & 0x40) >> 6
}

// CCL.SEQCTRL: SEQ Control x
func (o *CCL_Type) SetSEQCTRL_SEQSEL(idx int, value uint8) {
	volatile.StoreUint8(&o.SEQCTRL[idx].Reg, volatile.LoadUint8(&o.SEQCTRL[idx].Reg)&^(0xf)|value)
}
func (o *CCL_Type) GetSEQCTRL_SEQSEL(idx int) uint8 {
	return volatile.LoadUint8(&o.SEQCTRL[idx].Reg) & 0xf
}

// CCL.LUTCTRL: LUT Control x
func (o *CCL_Type) SetLUTCTRL_ENABLE(idx int, value uint32) {
	volatile.StoreUint32(&o.LUTCTRL[idx].Reg, volatile.LoadUint32(&o.LUTCTRL[idx].Reg)&^(0x2)|value<<1)
}
func (o *CCL_Type) GetLUTCTRL_ENABLE(idx int) uint32 {
	return (volatile.LoadUint32(&o.LUTCTRL[idx].Reg) & 0x2) >> 1
}
func (o *CCL_Type) SetLUTCTRL_FILTSEL(idx int, value uint32) {
	volatile.StoreUint32(&o.LUTCTRL[idx].Reg, volatile.LoadUint32(&o.LUTCTRL[idx].Reg)&^(0x30)|value<<4)
}
func (o *CCL_Type) GetLUTCTRL_FILTSEL(idx int) uint32 {
	return (volatile.LoadUint32(&o.LUTCTRL[idx].Reg) & 0x30) >> 4
}
func (o *CCL_Type) SetLUTCTRL_EDGESEL(idx int, value uint32) {
	volatile.StoreUint32(&o.LUTCTRL[idx].Reg, volatile.LoadUint32(&o.LUTCTRL[idx].Reg)&^(0x80)|value<<7)
}
func (o *CCL_Type) GetLUTCTRL_EDGESEL(idx int) uint32 {
	return (volatile.LoadUint32(&o.LUTCTRL[idx].Reg) & 0x80) >> 7
}
func (o *CCL_Type) SetLUTCTRL_INSEL0(idx int, value uint32) {
	volatile.StoreUint32(&o.LUTCTRL[idx].Reg, volatile.LoadUint32(&o.LUTCTRL[idx].Reg)&^(0xf00)|value<<8)
}
func (o *CCL_Type) GetLUTCTRL_INSEL0(idx int) uint32 {
	return (volatile.LoadUint32(&o.LUTCTRL[idx].Reg) & 0xf00) >> 8
}
func (o *CCL_Type) SetLUTCTRL_INSEL1(idx int, value uint32) {
	volatile.StoreUint32(&o.LUTCTRL[idx].Reg, volatile.LoadUint32(&o.LUTCTRL[idx].Reg)&^(0xf000)|value<<12)
}
func (o *CCL_Type) GetLUTCTRL_INSEL1(idx int) uint32 {
	return (volatile.LoadUint32(&o.LUTCTRL[idx].Reg) & 0xf000) >> 12
}
func (o *CCL_Type) SetLUTCTRL_INSEL2(idx int, value uint32) {
	volatile.StoreUint32(&o.LUTCTRL[idx].Reg, volatile.LoadUint32(&o.LUTCTRL[idx].Reg)&^(0xf0000)|value<<16)
}
func (o *CCL_Type) GetLUTCTRL_INSEL2(idx int) uint32 {
	return (volatile.LoadUint32(&o.LUTCTRL[idx].Reg) & 0xf0000) >> 16
}
func (o *CCL_Type) SetLUTCTRL_INVEI(idx int, value uint32) {
	volatile.StoreUint32(&o.LUTCTRL[idx].Reg, volatile.LoadUint32(&o.LUTCTRL[idx].Reg)&^(0x100000)|value<<20)
}
func (o *CCL_Type) GetLUTCTRL_INVEI(idx int) uint32 {
	return (volatile.LoadUint32(&o.LUTCTRL[idx].Reg) & 0x100000) >> 20
}
func (o *CCL_Type) SetLUTCTRL_LUTEI(idx int, value uint32) {
	volatile.StoreUint32(&o.LUTCTRL[idx].Reg, volatile.LoadUint32(&o.LUTCTRL[idx].Reg)&^(0x200000)|value<<21)
}
func (o *CCL_Type) GetLUTCTRL_LUTEI(idx int) uint32 {
	return (volatile.LoadUint32(&o.LUTCTRL[idx].Reg) & 0x200000) >> 21
}
func (o *CCL_Type) SetLUTCTRL_LUTEO(idx int, value uint32) {
	volatile.StoreUint32(&o.LUTCTRL[idx].Reg, volatile.LoadUint32(&o.LUTCTRL[idx].Reg)&^(0x400000)|value<<22)
}
func (o *CCL_Type) GetLUTCTRL_LUTEO(idx int) uint32 {
	return (volatile.LoadUint32(&o.LUTCTRL[idx].Reg) & 0x400000) >> 22
}
func (o *CCL_Type) SetLUTCTRL_TRUTH(idx int, value uint32) {
	volatile.StoreUint32(&o.LUTCTRL[idx].Reg, volatile.LoadUint32(&o.LUTCTRL[idx].Reg)&^(0xff000000)|value<<24)
}
func (o *CCL_Type) GetLUTCTRL_TRUTH(idx int) uint32 {
	return (volatile.LoadUint32(&o.LUTCTRL[idx].Reg) & 0xff000000) >> 24
}

// Digital Analog Converter
type DAC_Type struct {
	CTRLA    volatile.Register8 // 0x0
	CTRLB    volatile.Register8 // 0x1
	EVCTRL   volatile.Register8 // 0x2
	_        byte
	INTENCLR volatile.Register8  // 0x4
	INTENSET volatile.Register8  // 0x5
	INTFLAG  volatile.Register8  // 0x6
	STATUS   volatile.Register8  // 0x7
	DATA     volatile.Register16 // 0x8
	_        [2]byte
	DATABUF  volatile.Register16 // 0xC
	_        [2]byte
	SYNCBUSY volatile.Register32 // 0x10
	DBGCTRL  volatile.Register8  // 0x14
}

// DAC.CTRLA: Control A
func (o *DAC_Type) SetCTRLA_SWRST(value uint8) {
	volatile.StoreUint8(&o.CTRLA.Reg, volatile.LoadUint8(&o.CTRLA.Reg)&^(0x1)|value)
}
func (o *DAC_Type) GetCTRLA_SWRST() uint8 {
	return volatile.LoadUint8(&o.CTRLA.Reg) & 0x1
}
func (o *DAC_Type) SetCTRLA_ENABLE(value uint8) {
	volatile.StoreUint8(&o.CTRLA.Reg, volatile.LoadUint8(&o.CTRLA.Reg)&^(0x2)|value<<1)
}
func (o *DAC_Type) GetCTRLA_ENABLE() uint8 {
	return (volatile.LoadUint8(&o.CTRLA.Reg) & 0x2) >> 1
}
func (o *DAC_Type) SetCTRLA_RUNSTDBY(value uint8) {
	volatile.StoreUint8(&o.CTRLA.Reg, volatile.LoadUint8(&o.CTRLA.Reg)&^(0x40)|value<<6)
}
func (o *DAC_Type) GetCTRLA_RUNSTDBY() uint8 {
	return (volatile.LoadUint8(&o.CTRLA.Reg) & 0x40) >> 6
}

// DAC.CTRLB: Control B
func (o *DAC_Type) SetCTRLB_EOEN(value uint8) {
	volatile.StoreUint8(&o.CTRLB.Reg, volatile.LoadUint8(&o.CTRLB.Reg)&^(0x1)|value)
}
func (o *DAC_Type) GetCTRLB_EOEN() uint8 {
	return volatile.LoadUint8(&o.CTRLB.Reg) & 0x1
}
func (o *DAC_Type) SetCTRLB_IOEN(value uint8) {
	volatile.StoreUint8(&o.CTRLB.Reg, volatile.LoadUint8(&o.CTRLB.Reg)&^(0x2)|value<<1)
}
func (o *DAC_Type) GetCTRLB_IOEN() uint8 {
	return (volatile.LoadUint8(&o.CTRLB.Reg) & 0x2) >> 1
}
func (o *DAC_Type) SetCTRLB_LEFTADJ(value uint8) {
	volatile.StoreUint8(&o.CTRLB.Reg, volatile.LoadUint8(&o.CTRLB.Reg)&^(0x4)|value<<2)
}
func (o *DAC_Type) GetCTRLB_LEFTADJ() uint8 {
	return (volatile.LoadUint8(&o.CTRLB.Reg) & 0x4) >> 2
}
func (o *DAC_Type) SetCTRLB_VPD(value uint8) {
	volatile.StoreUint8(&o.CTRLB.Reg, volatile.LoadUint8(&o.CTRLB.Reg)&^(0x8)|value<<3)
}
func (o *DAC_Type) GetCTRLB_VPD() uint8 {
	return (volatile.LoadUint8(&o.CTRLB.Reg) & 0x8) >> 3
}
func (o *DAC_Type) SetCTRLB_DITHER(value uint8) {
	volatile.StoreUint8(&o.CTRLB.Reg, volatile.LoadUint8(&o.CTRLB.Reg)&^(0x20)|value<<5)
}
func (o *DAC_Type) GetCTRLB_DITHER() uint8 {
	return (volatile.LoadUint8(&o.CTRLB.Reg) & 0x20) >> 5
}
func (o *DAC_Type) SetCTRLB_REFSEL(value uint8) {
	volatile.StoreUint8(&o.CTRLB.Reg, volatile.LoadUint8(&o.CTRLB.Reg)&^(0xc0)|value<<6)
}
func (o *DAC_Type) GetCTRLB_REFSEL() uint8 {
	return (volatile.LoadUint8(&o.CTRLB.Reg) & 0xc0) >> 6
}

// DAC.EVCTRL: Event Control
func (o *DAC_Type) SetEVCTRL_STARTEI(value uint8) {
	volatile.StoreUint8(&o.EVCTRL.Reg, volatile.LoadUint8(&o.EVCTRL.Reg)&^(0x1)|value)
}
func (o *DAC_Type) GetEVCTRL_STARTEI() uint8 {
	return volatile.LoadUint8(&o.EVCTRL.Reg) & 0x1
}
func (o *DAC_Type) SetEVCTRL_EMPTYEO(value uint8) {
	volatile.StoreUint8(&o.EVCTRL.Reg, volatile.LoadUint8(&o.EVCTRL.Reg)&^(0x2)|value<<1)
}
func (o *DAC_Type) GetEVCTRL_EMPTYEO() uint8 {
	return (volatile.LoadUint8(&o.EVCTRL.Reg) & 0x2) >> 1
}
func (o *DAC_Type) SetEVCTRL_INVEI(value uint8) {
	volatile.StoreUint8(&o.EVCTRL.Reg, volatile.LoadUint8(&o.EVCTRL.Reg)&^(0x4)|value<<2)
}
func (o *DAC_Type) GetEVCTRL_INVEI() uint8 {
	return (volatile.LoadUint8(&o.EVCTRL.Reg) & 0x4) >> 2
}

// DAC.INTENCLR: Interrupt Enable Clear
func (o *DAC_Type) SetINTENCLR_UNDERRUN(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *DAC_Type) GetINTENCLR_UNDERRUN() uint8 {
	return volatile.LoadUint8(&o.INTENCLR.Reg) & 0x1
}
func (o *DAC_Type) SetINTENCLR_EMPTY(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *DAC_Type) GetINTENCLR_EMPTY() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x2) >> 1
}

// DAC.INTENSET: Interrupt Enable Set
func (o *DAC_Type) SetINTENSET_UNDERRUN(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *DAC_Type) GetINTENSET_UNDERRUN() uint8 {
	return volatile.LoadUint8(&o.INTENSET.Reg) & 0x1
}
func (o *DAC_Type) SetINTENSET_EMPTY(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *DAC_Type) GetINTENSET_EMPTY() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x2) >> 1
}

// DAC.INTFLAG: Interrupt Flag Status and Clear
func (o *DAC_Type) SetINTFLAG_UNDERRUN(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x1)|value)
}
func (o *DAC_Type) GetINTFLAG_UNDERRUN() uint8 {
	return volatile.LoadUint8(&o.INTFLAG.Reg) & 0x1
}
func (o *DAC_Type) SetINTFLAG_EMPTY(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x2)|value<<1)
}
func (o *DAC_Type) GetINTFLAG_EMPTY() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x2) >> 1
}

// DAC.STATUS: Status
func (o *DAC_Type) SetSTATUS_READY(value uint8) {
	volatile.StoreUint8(&o.STATUS.Reg, volatile.LoadUint8(&o.STATUS.Reg)&^(0x1)|value)
}
func (o *DAC_Type) GetSTATUS_READY() uint8 {
	return volatile.LoadUint8(&o.STATUS.Reg) & 0x1
}

// DAC.DATA: Data
func (o *DAC_Type) SetDATA(value uint16) {
	volatile.StoreUint16(&o.DATA.Reg, value)
}
func (o *DAC_Type) GetDATA() uint16 {
	return volatile.LoadUint16(&o.DATA.Reg)
}

// DAC.DATABUF: Data Buffer
func (o *DAC_Type) SetDATABUF(value uint16) {
	volatile.StoreUint16(&o.DATABUF.Reg, value)
}
func (o *DAC_Type) GetDATABUF() uint16 {
	return volatile.LoadUint16(&o.DATABUF.Reg)
}

// DAC.SYNCBUSY: Synchronization Busy
func (o *DAC_Type) SetSYNCBUSY_SWRST(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x1)|value)
}
func (o *DAC_Type) GetSYNCBUSY_SWRST() uint32 {
	return volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x1
}
func (o *DAC_Type) SetSYNCBUSY_ENABLE(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x2)|value<<1)
}
func (o *DAC_Type) GetSYNCBUSY_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x2) >> 1
}
func (o *DAC_Type) SetSYNCBUSY_DATA(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x4)|value<<2)
}
func (o *DAC_Type) GetSYNCBUSY_DATA() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x4) >> 2
}
func (o *DAC_Type) SetSYNCBUSY_DATABUF(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x8)|value<<3)
}
func (o *DAC_Type) GetSYNCBUSY_DATABUF() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x8) >> 3
}

// DAC.DBGCTRL: Debug Control
func (o *DAC_Type) SetDBGCTRL_DBGRUN(value uint8) {
	volatile.StoreUint8(&o.DBGCTRL.Reg, volatile.LoadUint8(&o.DBGCTRL.Reg)&^(0x1)|value)
}
func (o *DAC_Type) GetDBGCTRL_DBGRUN() uint8 {
	return volatile.LoadUint8(&o.DBGCTRL.Reg) & 0x1
}

// Direct Memory Access Controller
type DMAC_Type struct {
	CTRL       volatile.Register16 // 0x0
	CRCCTRL    volatile.Register16 // 0x2
	CRCDATAIN  volatile.Register32 // 0x4
	CRCCHKSUM  volatile.Register32 // 0x8
	CRCSTATUS  volatile.Register8  // 0xC
	DBGCTRL    volatile.Register8  // 0xD
	QOSCTRL    volatile.Register8  // 0xE
	_          byte
	SWTRIGCTRL volatile.Register32 // 0x10
	PRICTRL0   volatile.Register32 // 0x14
	_          [8]byte
	INTPEND    volatile.Register16 // 0x20
	_          [2]byte
	INTSTATUS  volatile.Register32 // 0x24
	BUSYCH     volatile.Register32 // 0x28
	PENDCH     volatile.Register32 // 0x2C
	ACTIVE     volatile.Register32 // 0x30
	BASEADDR   volatile.Register32 // 0x34
	WRBADDR    volatile.Register32 // 0x38
	_          [3]byte
	CHID       volatile.Register8 // 0x3F
	CHCTRLA    volatile.Register8 // 0x40
	_          [3]byte
	CHCTRLB    volatile.Register32 // 0x44
	_          [4]byte
	CHINTENCLR volatile.Register8 // 0x4C
	CHINTENSET volatile.Register8 // 0x4D
	CHINTFLAG  volatile.Register8 // 0x4E
	CHSTATUS   volatile.Register8 // 0x4F
}

// DMAC.CTRL: Control
func (o *DMAC_Type) SetCTRL_SWRST(value uint16) {
	volatile.StoreUint16(&o.CTRL.Reg, volatile.LoadUint16(&o.CTRL.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetCTRL_SWRST() uint16 {
	return volatile.LoadUint16(&o.CTRL.Reg) & 0x1
}
func (o *DMAC_Type) SetCTRL_DMAENABLE(value uint16) {
	volatile.StoreUint16(&o.CTRL.Reg, volatile.LoadUint16(&o.CTRL.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetCTRL_DMAENABLE() uint16 {
	return (volatile.LoadUint16(&o.CTRL.Reg) & 0x2) >> 1
}
func (o *DMAC_Type) SetCTRL_CRCENABLE(value uint16) {
	volatile.StoreUint16(&o.CTRL.Reg, volatile.LoadUint16(&o.CTRL.Reg)&^(0x4)|value<<2)
}
func (o *DMAC_Type) GetCTRL_CRCENABLE() uint16 {
	return (volatile.LoadUint16(&o.CTRL.Reg) & 0x4) >> 2
}
func (o *DMAC_Type) SetCTRL_LVLEN0(value uint16) {
	volatile.StoreUint16(&o.CTRL.Reg, volatile.LoadUint16(&o.CTRL.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetCTRL_LVLEN0() uint16 {
	return (volatile.LoadUint16(&o.CTRL.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetCTRL_LVLEN1(value uint16) {
	volatile.StoreUint16(&o.CTRL.Reg, volatile.LoadUint16(&o.CTRL.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetCTRL_LVLEN1() uint16 {
	return (volatile.LoadUint16(&o.CTRL.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetCTRL_LVLEN2(value uint16) {
	volatile.StoreUint16(&o.CTRL.Reg, volatile.LoadUint16(&o.CTRL.Reg)&^(0x400)|value<<10)
}
func (o *DMAC_Type) GetCTRL_LVLEN2() uint16 {
	return (volatile.LoadUint16(&o.CTRL.Reg) & 0x400) >> 10
}
func (o *DMAC_Type) SetCTRL_LVLEN3(value uint16) {
	volatile.StoreUint16(&o.CTRL.Reg, volatile.LoadUint16(&o.CTRL.Reg)&^(0x800)|value<<11)
}
func (o *DMAC_Type) GetCTRL_LVLEN3() uint16 {
	return (volatile.LoadUint16(&o.CTRL.Reg) & 0x800) >> 11
}

// DMAC.CRCCTRL: CRC Control
func (o *DMAC_Type) SetCRCCTRL_CRCBEATSIZE(value uint16) {
	volatile.StoreUint16(&o.CRCCTRL.Reg, volatile.LoadUint16(&o.CRCCTRL.Reg)&^(0x3)|value)
}
func (o *DMAC_Type) GetCRCCTRL_CRCBEATSIZE() uint16 {
	return volatile.LoadUint16(&o.CRCCTRL.Reg) & 0x3
}
func (o *DMAC_Type) SetCRCCTRL_CRCPOLY(value uint16) {
	volatile.StoreUint16(&o.CRCCTRL.Reg, volatile.LoadUint16(&o.CRCCTRL.Reg)&^(0xc)|value<<2)
}
func (o *DMAC_Type) GetCRCCTRL_CRCPOLY() uint16 {
	return (volatile.LoadUint16(&o.CRCCTRL.Reg) & 0xc) >> 2
}
func (o *DMAC_Type) SetCRCCTRL_CRCSRC(value uint16) {
	volatile.StoreUint16(&o.CRCCTRL.Reg, volatile.LoadUint16(&o.CRCCTRL.Reg)&^(0x3f00)|value<<8)
}
func (o *DMAC_Type) GetCRCCTRL_CRCSRC() uint16 {
	return (volatile.LoadUint16(&o.CRCCTRL.Reg) & 0x3f00) >> 8
}

// DMAC.CRCDATAIN: CRC Data Input
func (o *DMAC_Type) SetCRCDATAIN(value uint32) {
	volatile.StoreUint32(&o.CRCDATAIN.Reg, value)
}
func (o *DMAC_Type) GetCRCDATAIN() uint32 {
	return volatile.LoadUint32(&o.CRCDATAIN.Reg)
}

// DMAC.CRCCHKSUM: CRC Checksum
func (o *DMAC_Type) SetCRCCHKSUM(value uint32) {
	volatile.StoreUint32(&o.CRCCHKSUM.Reg, value)
}
func (o *DMAC_Type) GetCRCCHKSUM() uint32 {
	return volatile.LoadUint32(&o.CRCCHKSUM.Reg)
}

// DMAC.CRCSTATUS: CRC Status
func (o *DMAC_Type) SetCRCSTATUS_CRCBUSY(value uint8) {
	volatile.StoreUint8(&o.CRCSTATUS.Reg, volatile.LoadUint8(&o.CRCSTATUS.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetCRCSTATUS_CRCBUSY() uint8 {
	return volatile.LoadUint8(&o.CRCSTATUS.Reg) & 0x1
}
func (o *DMAC_Type) SetCRCSTATUS_CRCZERO(value uint8) {
	volatile.StoreUint8(&o.CRCSTATUS.Reg, volatile.LoadUint8(&o.CRCSTATUS.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetCRCSTATUS_CRCZERO() uint8 {
	return (volatile.LoadUint8(&o.CRCSTATUS.Reg) & 0x2) >> 1
}

// DMAC.DBGCTRL: Debug Control
func (o *DMAC_Type) SetDBGCTRL_DBGRUN(value uint8) {
	volatile.StoreUint8(&o.DBGCTRL.Reg, volatile.LoadUint8(&o.DBGCTRL.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetDBGCTRL_DBGRUN() uint8 {
	return volatile.LoadUint8(&o.DBGCTRL.Reg) & 0x1
}

// DMAC.QOSCTRL: QOS Control
func (o *DMAC_Type) SetQOSCTRL_WRBQOS(value uint8) {
	volatile.StoreUint8(&o.QOSCTRL.Reg, volatile.LoadUint8(&o.QOSCTRL.Reg)&^(0x3)|value)
}
func (o *DMAC_Type) GetQOSCTRL_WRBQOS() uint8 {
	return volatile.LoadUint8(&o.QOSCTRL.Reg) & 0x3
}
func (o *DMAC_Type) SetQOSCTRL_FQOS(value uint8) {
	volatile.StoreUint8(&o.QOSCTRL.Reg, volatile.LoadUint8(&o.QOSCTRL.Reg)&^(0xc)|value<<2)
}
func (o *DMAC_Type) GetQOSCTRL_FQOS() uint8 {
	return (volatile.LoadUint8(&o.QOSCTRL.Reg) & 0xc) >> 2
}
func (o *DMAC_Type) SetQOSCTRL_DQOS(value uint8) {
	volatile.StoreUint8(&o.QOSCTRL.Reg, volatile.LoadUint8(&o.QOSCTRL.Reg)&^(0x30)|value<<4)
}
func (o *DMAC_Type) GetQOSCTRL_DQOS() uint8 {
	return (volatile.LoadUint8(&o.QOSCTRL.Reg) & 0x30) >> 4
}

// DMAC.SWTRIGCTRL: Software Trigger Control
func (o *DMAC_Type) SetSWTRIGCTRL_SWTRIG0(value uint32) {
	volatile.StoreUint32(&o.SWTRIGCTRL.Reg, volatile.LoadUint32(&o.SWTRIGCTRL.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetSWTRIGCTRL_SWTRIG0() uint32 {
	return volatile.LoadUint32(&o.SWTRIGCTRL.Reg) & 0x1
}
func (o *DMAC_Type) SetSWTRIGCTRL_SWTRIG1(value uint32) {
	volatile.StoreUint32(&o.SWTRIGCTRL.Reg, volatile.LoadUint32(&o.SWTRIGCTRL.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetSWTRIGCTRL_SWTRIG1() uint32 {
	return (volatile.LoadUint32(&o.SWTRIGCTRL.Reg) & 0x2) >> 1
}
func (o *DMAC_Type) SetSWTRIGCTRL_SWTRIG2(value uint32) {
	volatile.StoreUint32(&o.SWTRIGCTRL.Reg, volatile.LoadUint32(&o.SWTRIGCTRL.Reg)&^(0x4)|value<<2)
}
func (o *DMAC_Type) GetSWTRIGCTRL_SWTRIG2() uint32 {
	return (volatile.LoadUint32(&o.SWTRIGCTRL.Reg) & 0x4) >> 2
}
func (o *DMAC_Type) SetSWTRIGCTRL_SWTRIG3(value uint32) {
	volatile.StoreUint32(&o.SWTRIGCTRL.Reg, volatile.LoadUint32(&o.SWTRIGCTRL.Reg)&^(0x8)|value<<3)
}
func (o *DMAC_Type) GetSWTRIGCTRL_SWTRIG3() uint32 {
	return (volatile.LoadUint32(&o.SWTRIGCTRL.Reg) & 0x8) >> 3
}
func (o *DMAC_Type) SetSWTRIGCTRL_SWTRIG4(value uint32) {
	volatile.StoreUint32(&o.SWTRIGCTRL.Reg, volatile.LoadUint32(&o.SWTRIGCTRL.Reg)&^(0x10)|value<<4)
}
func (o *DMAC_Type) GetSWTRIGCTRL_SWTRIG4() uint32 {
	return (volatile.LoadUint32(&o.SWTRIGCTRL.Reg) & 0x10) >> 4
}
func (o *DMAC_Type) SetSWTRIGCTRL_SWTRIG5(value uint32) {
	volatile.StoreUint32(&o.SWTRIGCTRL.Reg, volatile.LoadUint32(&o.SWTRIGCTRL.Reg)&^(0x20)|value<<5)
}
func (o *DMAC_Type) GetSWTRIGCTRL_SWTRIG5() uint32 {
	return (volatile.LoadUint32(&o.SWTRIGCTRL.Reg) & 0x20) >> 5
}
func (o *DMAC_Type) SetSWTRIGCTRL_SWTRIG6(value uint32) {
	volatile.StoreUint32(&o.SWTRIGCTRL.Reg, volatile.LoadUint32(&o.SWTRIGCTRL.Reg)&^(0x40)|value<<6)
}
func (o *DMAC_Type) GetSWTRIGCTRL_SWTRIG6() uint32 {
	return (volatile.LoadUint32(&o.SWTRIGCTRL.Reg) & 0x40) >> 6
}
func (o *DMAC_Type) SetSWTRIGCTRL_SWTRIG7(value uint32) {
	volatile.StoreUint32(&o.SWTRIGCTRL.Reg, volatile.LoadUint32(&o.SWTRIGCTRL.Reg)&^(0x80)|value<<7)
}
func (o *DMAC_Type) GetSWTRIGCTRL_SWTRIG7() uint32 {
	return (volatile.LoadUint32(&o.SWTRIGCTRL.Reg) & 0x80) >> 7
}

// DMAC.PRICTRL0: Priority Control 0
func (o *DMAC_Type) SetPRICTRL0_LVLPRI0(value uint32) {
	volatile.StoreUint32(&o.PRICTRL0.Reg, volatile.LoadUint32(&o.PRICTRL0.Reg)&^(0x7)|value)
}
func (o *DMAC_Type) GetPRICTRL0_LVLPRI0() uint32 {
	return volatile.LoadUint32(&o.PRICTRL0.Reg) & 0x7
}
func (o *DMAC_Type) SetPRICTRL0_RRLVLEN0(value uint32) {
	volatile.StoreUint32(&o.PRICTRL0.Reg, volatile.LoadUint32(&o.PRICTRL0.Reg)&^(0x80)|value<<7)
}
func (o *DMAC_Type) GetPRICTRL0_RRLVLEN0() uint32 {
	return (volatile.LoadUint32(&o.PRICTRL0.Reg) & 0x80) >> 7
}
func (o *DMAC_Type) SetPRICTRL0_LVLPRI1(value uint32) {
	volatile.StoreUint32(&o.PRICTRL0.Reg, volatile.LoadUint32(&o.PRICTRL0.Reg)&^(0x700)|value<<8)
}
func (o *DMAC_Type) GetPRICTRL0_LVLPRI1() uint32 {
	return (volatile.LoadUint32(&o.PRICTRL0.Reg) & 0x700) >> 8
}
func (o *DMAC_Type) SetPRICTRL0_RRLVLEN1(value uint32) {
	volatile.StoreUint32(&o.PRICTRL0.Reg, volatile.LoadUint32(&o.PRICTRL0.Reg)&^(0x8000)|value<<15)
}
func (o *DMAC_Type) GetPRICTRL0_RRLVLEN1() uint32 {
	return (volatile.LoadUint32(&o.PRICTRL0.Reg) & 0x8000) >> 15
}
func (o *DMAC_Type) SetPRICTRL0_LVLPRI2(value uint32) {
	volatile.StoreUint32(&o.PRICTRL0.Reg, volatile.LoadUint32(&o.PRICTRL0.Reg)&^(0x70000)|value<<16)
}
func (o *DMAC_Type) GetPRICTRL0_LVLPRI2() uint32 {
	return (volatile.LoadUint32(&o.PRICTRL0.Reg) & 0x70000) >> 16
}
func (o *DMAC_Type) SetPRICTRL0_RRLVLEN2(value uint32) {
	volatile.StoreUint32(&o.PRICTRL0.Reg, volatile.LoadUint32(&o.PRICTRL0.Reg)&^(0x800000)|value<<23)
}
func (o *DMAC_Type) GetPRICTRL0_RRLVLEN2() uint32 {
	return (volatile.LoadUint32(&o.PRICTRL0.Reg) & 0x800000) >> 23
}
func (o *DMAC_Type) SetPRICTRL0_LVLPRI3(value uint32) {
	volatile.StoreUint32(&o.PRICTRL0.Reg, volatile.LoadUint32(&o.PRICTRL0.Reg)&^(0x7000000)|value<<24)
}
func (o *DMAC_Type) GetPRICTRL0_LVLPRI3() uint32 {
	return (volatile.LoadUint32(&o.PRICTRL0.Reg) & 0x7000000) >> 24
}
func (o *DMAC_Type) SetPRICTRL0_RRLVLEN3(value uint32) {
	volatile.StoreUint32(&o.PRICTRL0.Reg, volatile.LoadUint32(&o.PRICTRL0.Reg)&^(0x80000000)|value<<31)
}
func (o *DMAC_Type) GetPRICTRL0_RRLVLEN3() uint32 {
	return (volatile.LoadUint32(&o.PRICTRL0.Reg) & 0x80000000) >> 31
}

// DMAC.INTPEND: Interrupt Pending
func (o *DMAC_Type) SetINTPEND_ID(value uint16) {
	volatile.StoreUint16(&o.INTPEND.Reg, volatile.LoadUint16(&o.INTPEND.Reg)&^(0x7)|value)
}
func (o *DMAC_Type) GetINTPEND_ID() uint16 {
	return volatile.LoadUint16(&o.INTPEND.Reg) & 0x7
}
func (o *DMAC_Type) SetINTPEND_TERR(value uint16) {
	volatile.StoreUint16(&o.INTPEND.Reg, volatile.LoadUint16(&o.INTPEND.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetINTPEND_TERR() uint16 {
	return (volatile.LoadUint16(&o.INTPEND.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetINTPEND_TCMPL(value uint16) {
	volatile.StoreUint16(&o.INTPEND.Reg, volatile.LoadUint16(&o.INTPEND.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetINTPEND_TCMPL() uint16 {
	return (volatile.LoadUint16(&o.INTPEND.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetINTPEND_SUSP(value uint16) {
	volatile.StoreUint16(&o.INTPEND.Reg, volatile.LoadUint16(&o.INTPEND.Reg)&^(0x400)|value<<10)
}
func (o *DMAC_Type) GetINTPEND_SUSP() uint16 {
	return (volatile.LoadUint16(&o.INTPEND.Reg) & 0x400) >> 10
}
func (o *DMAC_Type) SetINTPEND_FERR(value uint16) {
	volatile.StoreUint16(&o.INTPEND.Reg, volatile.LoadUint16(&o.INTPEND.Reg)&^(0x2000)|value<<13)
}
func (o *DMAC_Type) GetINTPEND_FERR() uint16 {
	return (volatile.LoadUint16(&o.INTPEND.Reg) & 0x2000) >> 13
}
func (o *DMAC_Type) SetINTPEND_BUSY(value uint16) {
	volatile.StoreUint16(&o.INTPEND.Reg, volatile.LoadUint16(&o.INTPEND.Reg)&^(0x4000)|value<<14)
}
func (o *DMAC_Type) GetINTPEND_BUSY() uint16 {
	return (volatile.LoadUint16(&o.INTPEND.Reg) & 0x4000) >> 14
}
func (o *DMAC_Type) SetINTPEND_PEND(value uint16) {
	volatile.StoreUint16(&o.INTPEND.Reg, volatile.LoadUint16(&o.INTPEND.Reg)&^(0x8000)|value<<15)
}
func (o *DMAC_Type) GetINTPEND_PEND() uint16 {
	return (volatile.LoadUint16(&o.INTPEND.Reg) & 0x8000) >> 15
}

// DMAC.INTSTATUS: Interrupt Status
func (o *DMAC_Type) SetINTSTATUS_CHINT0(value uint32) {
	volatile.StoreUint32(&o.INTSTATUS.Reg, volatile.LoadUint32(&o.INTSTATUS.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetINTSTATUS_CHINT0() uint32 {
	return volatile.LoadUint32(&o.INTSTATUS.Reg) & 0x1
}
func (o *DMAC_Type) SetINTSTATUS_CHINT1(value uint32) {
	volatile.StoreUint32(&o.INTSTATUS.Reg, volatile.LoadUint32(&o.INTSTATUS.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetINTSTATUS_CHINT1() uint32 {
	return (volatile.LoadUint32(&o.INTSTATUS.Reg) & 0x2) >> 1
}
func (o *DMAC_Type) SetINTSTATUS_CHINT2(value uint32) {
	volatile.StoreUint32(&o.INTSTATUS.Reg, volatile.LoadUint32(&o.INTSTATUS.Reg)&^(0x4)|value<<2)
}
func (o *DMAC_Type) GetINTSTATUS_CHINT2() uint32 {
	return (volatile.LoadUint32(&o.INTSTATUS.Reg) & 0x4) >> 2
}
func (o *DMAC_Type) SetINTSTATUS_CHINT3(value uint32) {
	volatile.StoreUint32(&o.INTSTATUS.Reg, volatile.LoadUint32(&o.INTSTATUS.Reg)&^(0x8)|value<<3)
}
func (o *DMAC_Type) GetINTSTATUS_CHINT3() uint32 {
	return (volatile.LoadUint32(&o.INTSTATUS.Reg) & 0x8) >> 3
}
func (o *DMAC_Type) SetINTSTATUS_CHINT4(value uint32) {
	volatile.StoreUint32(&o.INTSTATUS.Reg, volatile.LoadUint32(&o.INTSTATUS.Reg)&^(0x10)|value<<4)
}
func (o *DMAC_Type) GetINTSTATUS_CHINT4() uint32 {
	return (volatile.LoadUint32(&o.INTSTATUS.Reg) & 0x10) >> 4
}
func (o *DMAC_Type) SetINTSTATUS_CHINT5(value uint32) {
	volatile.StoreUint32(&o.INTSTATUS.Reg, volatile.LoadUint32(&o.INTSTATUS.Reg)&^(0x20)|value<<5)
}
func (o *DMAC_Type) GetINTSTATUS_CHINT5() uint32 {
	return (volatile.LoadUint32(&o.INTSTATUS.Reg) & 0x20) >> 5
}
func (o *DMAC_Type) SetINTSTATUS_CHINT6(value uint32) {
	volatile.StoreUint32(&o.INTSTATUS.Reg, volatile.LoadUint32(&o.INTSTATUS.Reg)&^(0x40)|value<<6)
}
func (o *DMAC_Type) GetINTSTATUS_CHINT6() uint32 {
	return (volatile.LoadUint32(&o.INTSTATUS.Reg) & 0x40) >> 6
}
func (o *DMAC_Type) SetINTSTATUS_CHINT7(value uint32) {
	volatile.StoreUint32(&o.INTSTATUS.Reg, volatile.LoadUint32(&o.INTSTATUS.Reg)&^(0x80)|value<<7)
}
func (o *DMAC_Type) GetINTSTATUS_CHINT7() uint32 {
	return (volatile.LoadUint32(&o.INTSTATUS.Reg) & 0x80) >> 7
}

// DMAC.BUSYCH: Busy Channels
func (o *DMAC_Type) SetBUSYCH_BUSYCH0(value uint32) {
	volatile.StoreUint32(&o.BUSYCH.Reg, volatile.LoadUint32(&o.BUSYCH.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetBUSYCH_BUSYCH0() uint32 {
	return volatile.LoadUint32(&o.BUSYCH.Reg) & 0x1
}
func (o *DMAC_Type) SetBUSYCH_BUSYCH1(value uint32) {
	volatile.StoreUint32(&o.BUSYCH.Reg, volatile.LoadUint32(&o.BUSYCH.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetBUSYCH_BUSYCH1() uint32 {
	return (volatile.LoadUint32(&o.BUSYCH.Reg) & 0x2) >> 1
}
func (o *DMAC_Type) SetBUSYCH_BUSYCH2(value uint32) {
	volatile.StoreUint32(&o.BUSYCH.Reg, volatile.LoadUint32(&o.BUSYCH.Reg)&^(0x4)|value<<2)
}
func (o *DMAC_Type) GetBUSYCH_BUSYCH2() uint32 {
	return (volatile.LoadUint32(&o.BUSYCH.Reg) & 0x4) >> 2
}
func (o *DMAC_Type) SetBUSYCH_BUSYCH3(value uint32) {
	volatile.StoreUint32(&o.BUSYCH.Reg, volatile.LoadUint32(&o.BUSYCH.Reg)&^(0x8)|value<<3)
}
func (o *DMAC_Type) GetBUSYCH_BUSYCH3() uint32 {
	return (volatile.LoadUint32(&o.BUSYCH.Reg) & 0x8) >> 3
}
func (o *DMAC_Type) SetBUSYCH_BUSYCH4(value uint32) {
	volatile.StoreUint32(&o.BUSYCH.Reg, volatile.LoadUint32(&o.BUSYCH.Reg)&^(0x10)|value<<4)
}
func (o *DMAC_Type) GetBUSYCH_BUSYCH4() uint32 {
	return (volatile.LoadUint32(&o.BUSYCH.Reg) & 0x10) >> 4
}
func (o *DMAC_Type) SetBUSYCH_BUSYCH5(value uint32) {
	volatile.StoreUint32(&o.BUSYCH.Reg, volatile.LoadUint32(&o.BUSYCH.Reg)&^(0x20)|value<<5)
}
func (o *DMAC_Type) GetBUSYCH_BUSYCH5() uint32 {
	return (volatile.LoadUint32(&o.BUSYCH.Reg) & 0x20) >> 5
}
func (o *DMAC_Type) SetBUSYCH_BUSYCH6(value uint32) {
	volatile.StoreUint32(&o.BUSYCH.Reg, volatile.LoadUint32(&o.BUSYCH.Reg)&^(0x40)|value<<6)
}
func (o *DMAC_Type) GetBUSYCH_BUSYCH6() uint32 {
	return (volatile.LoadUint32(&o.BUSYCH.Reg) & 0x40) >> 6
}
func (o *DMAC_Type) SetBUSYCH_BUSYCH7(value uint32) {
	volatile.StoreUint32(&o.BUSYCH.Reg, volatile.LoadUint32(&o.BUSYCH.Reg)&^(0x80)|value<<7)
}
func (o *DMAC_Type) GetBUSYCH_BUSYCH7() uint32 {
	return (volatile.LoadUint32(&o.BUSYCH.Reg) & 0x80) >> 7
}

// DMAC.PENDCH: Pending Channels
func (o *DMAC_Type) SetPENDCH_PENDCH0(value uint32) {
	volatile.StoreUint32(&o.PENDCH.Reg, volatile.LoadUint32(&o.PENDCH.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetPENDCH_PENDCH0() uint32 {
	return volatile.LoadUint32(&o.PENDCH.Reg) & 0x1
}
func (o *DMAC_Type) SetPENDCH_PENDCH1(value uint32) {
	volatile.StoreUint32(&o.PENDCH.Reg, volatile.LoadUint32(&o.PENDCH.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetPENDCH_PENDCH1() uint32 {
	return (volatile.LoadUint32(&o.PENDCH.Reg) & 0x2) >> 1
}
func (o *DMAC_Type) SetPENDCH_PENDCH2(value uint32) {
	volatile.StoreUint32(&o.PENDCH.Reg, volatile.LoadUint32(&o.PENDCH.Reg)&^(0x4)|value<<2)
}
func (o *DMAC_Type) GetPENDCH_PENDCH2() uint32 {
	return (volatile.LoadUint32(&o.PENDCH.Reg) & 0x4) >> 2
}
func (o *DMAC_Type) SetPENDCH_PENDCH3(value uint32) {
	volatile.StoreUint32(&o.PENDCH.Reg, volatile.LoadUint32(&o.PENDCH.Reg)&^(0x8)|value<<3)
}
func (o *DMAC_Type) GetPENDCH_PENDCH3() uint32 {
	return (volatile.LoadUint32(&o.PENDCH.Reg) & 0x8) >> 3
}
func (o *DMAC_Type) SetPENDCH_PENDCH4(value uint32) {
	volatile.StoreUint32(&o.PENDCH.Reg, volatile.LoadUint32(&o.PENDCH.Reg)&^(0x10)|value<<4)
}
func (o *DMAC_Type) GetPENDCH_PENDCH4() uint32 {
	return (volatile.LoadUint32(&o.PENDCH.Reg) & 0x10) >> 4
}
func (o *DMAC_Type) SetPENDCH_PENDCH5(value uint32) {
	volatile.StoreUint32(&o.PENDCH.Reg, volatile.LoadUint32(&o.PENDCH.Reg)&^(0x20)|value<<5)
}
func (o *DMAC_Type) GetPENDCH_PENDCH5() uint32 {
	return (volatile.LoadUint32(&o.PENDCH.Reg) & 0x20) >> 5
}
func (o *DMAC_Type) SetPENDCH_PENDCH6(value uint32) {
	volatile.StoreUint32(&o.PENDCH.Reg, volatile.LoadUint32(&o.PENDCH.Reg)&^(0x40)|value<<6)
}
func (o *DMAC_Type) GetPENDCH_PENDCH6() uint32 {
	return (volatile.LoadUint32(&o.PENDCH.Reg) & 0x40) >> 6
}
func (o *DMAC_Type) SetPENDCH_PENDCH7(value uint32) {
	volatile.StoreUint32(&o.PENDCH.Reg, volatile.LoadUint32(&o.PENDCH.Reg)&^(0x80)|value<<7)
}
func (o *DMAC_Type) GetPENDCH_PENDCH7() uint32 {
	return (volatile.LoadUint32(&o.PENDCH.Reg) & 0x80) >> 7
}

// DMAC.ACTIVE: Active Channel and Levels
func (o *DMAC_Type) SetACTIVE_LVLEX0(value uint32) {
	volatile.StoreUint32(&o.ACTIVE.Reg, volatile.LoadUint32(&o.ACTIVE.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetACTIVE_LVLEX0() uint32 {
	return volatile.LoadUint32(&o.ACTIVE.Reg) & 0x1
}
func (o *DMAC_Type) SetACTIVE_LVLEX1(value uint32) {
	volatile.StoreUint32(&o.ACTIVE.Reg, volatile.LoadUint32(&o.ACTIVE.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetACTIVE_LVLEX1() uint32 {
	return (volatile.LoadUint32(&o.ACTIVE.Reg) & 0x2) >> 1
}
func (o *DMAC_Type) SetACTIVE_LVLEX2(value uint32) {
	volatile.StoreUint32(&o.ACTIVE.Reg, volatile.LoadUint32(&o.ACTIVE.Reg)&^(0x4)|value<<2)
}
func (o *DMAC_Type) GetACTIVE_LVLEX2() uint32 {
	return (volatile.LoadUint32(&o.ACTIVE.Reg) & 0x4) >> 2
}
func (o *DMAC_Type) SetACTIVE_LVLEX3(value uint32) {
	volatile.StoreUint32(&o.ACTIVE.Reg, volatile.LoadUint32(&o.ACTIVE.Reg)&^(0x8)|value<<3)
}
func (o *DMAC_Type) GetACTIVE_LVLEX3() uint32 {
	return (volatile.LoadUint32(&o.ACTIVE.Reg) & 0x8) >> 3
}
func (o *DMAC_Type) SetACTIVE_ID(value uint32) {
	volatile.StoreUint32(&o.ACTIVE.Reg, volatile.LoadUint32(&o.ACTIVE.Reg)&^(0x1f00)|value<<8)
}
func (o *DMAC_Type) GetACTIVE_ID() uint32 {
	return (volatile.LoadUint32(&o.ACTIVE.Reg) & 0x1f00) >> 8
}
func (o *DMAC_Type) SetACTIVE_ABUSY(value uint32) {
	volatile.StoreUint32(&o.ACTIVE.Reg, volatile.LoadUint32(&o.ACTIVE.Reg)&^(0x8000)|value<<15)
}
func (o *DMAC_Type) GetACTIVE_ABUSY() uint32 {
	return (volatile.LoadUint32(&o.ACTIVE.Reg) & 0x8000) >> 15
}
func (o *DMAC_Type) SetACTIVE_BTCNT(value uint32) {
	volatile.StoreUint32(&o.ACTIVE.Reg, volatile.LoadUint32(&o.ACTIVE.Reg)&^(0xffff0000)|value<<16)
}
func (o *DMAC_Type) GetACTIVE_BTCNT() uint32 {
	return (volatile.LoadUint32(&o.ACTIVE.Reg) & 0xffff0000) >> 16
}

// DMAC.BASEADDR: Descriptor Memory Section Base Address
func (o *DMAC_Type) SetBASEADDR(value uint32) {
	volatile.StoreUint32(&o.BASEADDR.Reg, value)
}
func (o *DMAC_Type) GetBASEADDR() uint32 {
	return volatile.LoadUint32(&o.BASEADDR.Reg)
}

// DMAC.WRBADDR: Write-Back Memory Section Base Address
func (o *DMAC_Type) SetWRBADDR(value uint32) {
	volatile.StoreUint32(&o.WRBADDR.Reg, value)
}
func (o *DMAC_Type) GetWRBADDR() uint32 {
	return volatile.LoadUint32(&o.WRBADDR.Reg)
}

// DMAC.CHID: Channel ID
func (o *DMAC_Type) SetCHID_ID(value uint8) {
	volatile.StoreUint8(&o.CHID.Reg, volatile.LoadUint8(&o.CHID.Reg)&^(0x7)|value)
}
func (o *DMAC_Type) GetCHID_ID() uint8 {
	return volatile.LoadUint8(&o.CHID.Reg) & 0x7
}

// DMAC.CHCTRLA: Channel Control A
func (o *DMAC_Type) SetCHCTRLA_SWRST(value uint8) {
	volatile.StoreUint8(&o.CHCTRLA.Reg, volatile.LoadUint8(&o.CHCTRLA.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetCHCTRLA_SWRST() uint8 {
	return volatile.LoadUint8(&o.CHCTRLA.Reg) & 0x1
}
func (o *DMAC_Type) SetCHCTRLA_ENABLE(value uint8) {
	volatile.StoreUint8(&o.CHCTRLA.Reg, volatile.LoadUint8(&o.CHCTRLA.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetCHCTRLA_ENABLE() uint8 {
	return (volatile.LoadUint8(&o.CHCTRLA.Reg) & 0x2) >> 1
}
func (o *DMAC_Type) SetCHCTRLA_RUNSTDBY(value uint8) {
	volatile.StoreUint8(&o.CHCTRLA.Reg, volatile.LoadUint8(&o.CHCTRLA.Reg)&^(0x40)|value<<6)
}
func (o *DMAC_Type) GetCHCTRLA_RUNSTDBY() uint8 {
	return (volatile.LoadUint8(&o.CHCTRLA.Reg) & 0x40) >> 6
}

// DMAC.CHCTRLB: Channel Control B
func (o *DMAC_Type) SetCHCTRLB_EVACT(value uint32) {
	volatile.StoreUint32(&o.CHCTRLB.Reg, volatile.LoadUint32(&o.CHCTRLB.Reg)&^(0x7)|value)
}
func (o *DMAC_Type) GetCHCTRLB_EVACT() uint32 {
	return volatile.LoadUint32(&o.CHCTRLB.Reg) & 0x7
}
func (o *DMAC_Type) SetCHCTRLB_EVIE(value uint32) {
	volatile.StoreUint32(&o.CHCTRLB.Reg, volatile.LoadUint32(&o.CHCTRLB.Reg)&^(0x8)|value<<3)
}
func (o *DMAC_Type) GetCHCTRLB_EVIE() uint32 {
	return (volatile.LoadUint32(&o.CHCTRLB.Reg) & 0x8) >> 3
}
func (o *DMAC_Type) SetCHCTRLB_EVOE(value uint32) {
	volatile.StoreUint32(&o.CHCTRLB.Reg, volatile.LoadUint32(&o.CHCTRLB.Reg)&^(0x10)|value<<4)
}
func (o *DMAC_Type) GetCHCTRLB_EVOE() uint32 {
	return (volatile.LoadUint32(&o.CHCTRLB.Reg) & 0x10) >> 4
}
func (o *DMAC_Type) SetCHCTRLB_LVL(value uint32) {
	volatile.StoreUint32(&o.CHCTRLB.Reg, volatile.LoadUint32(&o.CHCTRLB.Reg)&^(0x60)|value<<5)
}
func (o *DMAC_Type) GetCHCTRLB_LVL() uint32 {
	return (volatile.LoadUint32(&o.CHCTRLB.Reg) & 0x60) >> 5
}
func (o *DMAC_Type) SetCHCTRLB_TRIGSRC(value uint32) {
	volatile.StoreUint32(&o.CHCTRLB.Reg, volatile.LoadUint32(&o.CHCTRLB.Reg)&^(0x1f00)|value<<8)
}
func (o *DMAC_Type) GetCHCTRLB_TRIGSRC() uint32 {
	return (volatile.LoadUint32(&o.CHCTRLB.Reg) & 0x1f00) >> 8
}
func (o *DMAC_Type) SetCHCTRLB_TRIGACT(value uint32) {
	volatile.StoreUint32(&o.CHCTRLB.Reg, volatile.LoadUint32(&o.CHCTRLB.Reg)&^(0xc00000)|value<<22)
}
func (o *DMAC_Type) GetCHCTRLB_TRIGACT() uint32 {
	return (volatile.LoadUint32(&o.CHCTRLB.Reg) & 0xc00000) >> 22
}
func (o *DMAC_Type) SetCHCTRLB_CMD(value uint32) {
	volatile.StoreUint32(&o.CHCTRLB.Reg, volatile.LoadUint32(&o.CHCTRLB.Reg)&^(0x3000000)|value<<24)
}
func (o *DMAC_Type) GetCHCTRLB_CMD() uint32 {
	return (volatile.LoadUint32(&o.CHCTRLB.Reg) & 0x3000000) >> 24
}

// DMAC.CHINTENCLR: Channel Interrupt Enable Clear
func (o *DMAC_Type) SetCHINTENCLR_TERR(value uint8) {
	volatile.StoreUint8(&o.CHINTENCLR.Reg, volatile.LoadUint8(&o.CHINTENCLR.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetCHINTENCLR_TERR() uint8 {
	return volatile.LoadUint8(&o.CHINTENCLR.Reg) & 0x1
}
func (o *DMAC_Type) SetCHINTENCLR_TCMPL(value uint8) {
	volatile.StoreUint8(&o.CHINTENCLR.Reg, volatile.LoadUint8(&o.CHINTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetCHINTENCLR_TCMPL() uint8 {
	return (volatile.LoadUint8(&o.CHINTENCLR.Reg) & 0x2) >> 1
}
func (o *DMAC_Type) SetCHINTENCLR_SUSP(value uint8) {
	volatile.StoreUint8(&o.CHINTENCLR.Reg, volatile.LoadUint8(&o.CHINTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *DMAC_Type) GetCHINTENCLR_SUSP() uint8 {
	return (volatile.LoadUint8(&o.CHINTENCLR.Reg) & 0x4) >> 2
}

// DMAC.CHINTENSET: Channel Interrupt Enable Set
func (o *DMAC_Type) SetCHINTENSET_TERR(value uint8) {
	volatile.StoreUint8(&o.CHINTENSET.Reg, volatile.LoadUint8(&o.CHINTENSET.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetCHINTENSET_TERR() uint8 {
	return volatile.LoadUint8(&o.CHINTENSET.Reg) & 0x1
}
func (o *DMAC_Type) SetCHINTENSET_TCMPL(value uint8) {
	volatile.StoreUint8(&o.CHINTENSET.Reg, volatile.LoadUint8(&o.CHINTENSET.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetCHINTENSET_TCMPL() uint8 {
	return (volatile.LoadUint8(&o.CHINTENSET.Reg) & 0x2) >> 1
}
func (o *DMAC_Type) SetCHINTENSET_SUSP(value uint8) {
	volatile.StoreUint8(&o.CHINTENSET.Reg, volatile.LoadUint8(&o.CHINTENSET.Reg)&^(0x4)|value<<2)
}
func (o *DMAC_Type) GetCHINTENSET_SUSP() uint8 {
	return (volatile.LoadUint8(&o.CHINTENSET.Reg) & 0x4) >> 2
}

// DMAC.CHINTFLAG: Channel Interrupt Flag Status and Clear
func (o *DMAC_Type) SetCHINTFLAG_TERR(value uint8) {
	volatile.StoreUint8(&o.CHINTFLAG.Reg, volatile.LoadUint8(&o.CHINTFLAG.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetCHINTFLAG_TERR() uint8 {
	return volatile.LoadUint8(&o.CHINTFLAG.Reg) & 0x1
}
func (o *DMAC_Type) SetCHINTFLAG_TCMPL(value uint8) {
	volatile.StoreUint8(&o.CHINTFLAG.Reg, volatile.LoadUint8(&o.CHINTFLAG.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetCHINTFLAG_TCMPL() uint8 {
	return (volatile.LoadUint8(&o.CHINTFLAG.Reg) & 0x2) >> 1
}
func (o *DMAC_Type) SetCHINTFLAG_SUSP(value uint8) {
	volatile.StoreUint8(&o.CHINTFLAG.Reg, volatile.LoadUint8(&o.CHINTFLAG.Reg)&^(0x4)|value<<2)
}
func (o *DMAC_Type) GetCHINTFLAG_SUSP() uint8 {
	return (volatile.LoadUint8(&o.CHINTFLAG.Reg) & 0x4) >> 2
}

// DMAC.CHSTATUS: Channel Status
func (o *DMAC_Type) SetCHSTATUS_PEND(value uint8) {
	volatile.StoreUint8(&o.CHSTATUS.Reg, volatile.LoadUint8(&o.CHSTATUS.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetCHSTATUS_PEND() uint8 {
	return volatile.LoadUint8(&o.CHSTATUS.Reg) & 0x1
}
func (o *DMAC_Type) SetCHSTATUS_BUSY(value uint8) {
	volatile.StoreUint8(&o.CHSTATUS.Reg, volatile.LoadUint8(&o.CHSTATUS.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetCHSTATUS_BUSY() uint8 {
	return (volatile.LoadUint8(&o.CHSTATUS.Reg) & 0x2) >> 1
}
func (o *DMAC_Type) SetCHSTATUS_FERR(value uint8) {
	volatile.StoreUint8(&o.CHSTATUS.Reg, volatile.LoadUint8(&o.CHSTATUS.Reg)&^(0x4)|value<<2)
}
func (o *DMAC_Type) GetCHSTATUS_FERR() uint8 {
	return (volatile.LoadUint8(&o.CHSTATUS.Reg) & 0x4) >> 2
}

// Device Service Unit
type DSU_Type struct {
	CTRL    volatile.Register8     // 0x0
	STATUSA volatile.Register8     // 0x1
	STATUSB volatile.Register8     // 0x2
	STATUSC volatile.Register8     // 0x3
	ADDR    volatile.Register32    // 0x4
	LENGTH  volatile.Register32    // 0x8
	DATA    volatile.Register32    // 0xC
	DCC     [2]volatile.Register32 // 0x10
	DID     volatile.Register32    // 0x18
	CFG     volatile.Register32    // 0x1C
	BCC     [2]volatile.Register32 // 0x20
	_       [200]byte
	DCFG    [2]volatile.Register32 // 0xF0
	_       [3848]byte
	ENTRY0  volatile.Register32 // 0x1000
	ENTRY1  volatile.Register32 // 0x1004
	END     volatile.Register32 // 0x1008
	_       [4032]byte
	MEMTYPE volatile.Register32 // 0x1FCC
	PID4    volatile.Register32 // 0x1FD0
	PID5    volatile.Register32 // 0x1FD4
	PID6    volatile.Register32 // 0x1FD8
	PID7    volatile.Register32 // 0x1FDC
	PID0    volatile.Register32 // 0x1FE0
	PID1    volatile.Register32 // 0x1FE4
	PID2    volatile.Register32 // 0x1FE8
	PID3    volatile.Register32 // 0x1FEC
	CID0    volatile.Register32 // 0x1FF0
	CID1    volatile.Register32 // 0x1FF4
	CID2    volatile.Register32 // 0x1FF8
	CID3    volatile.Register32 // 0x1FFC
}

// DSU.CTRL: Control
func (o *DSU_Type) SetCTRL_SWRST(value uint8) {
	volatile.StoreUint8(&o.CTRL.Reg, volatile.LoadUint8(&o.CTRL.Reg)&^(0x1)|value)
}
func (o *DSU_Type) GetCTRL_SWRST() uint8 {
	return volatile.LoadUint8(&o.CTRL.Reg) & 0x1
}
func (o *DSU_Type) SetCTRL_CRC(value uint8) {
	volatile.StoreUint8(&o.CTRL.Reg, volatile.LoadUint8(&o.CTRL.Reg)&^(0x4)|value<<2)
}
func (o *DSU_Type) GetCTRL_CRC() uint8 {
	return (volatile.LoadUint8(&o.CTRL.Reg) & 0x4) >> 2
}
func (o *DSU_Type) SetCTRL_MBIST(value uint8) {
	volatile.StoreUint8(&o.CTRL.Reg, volatile.LoadUint8(&o.CTRL.Reg)&^(0x8)|value<<3)
}
func (o *DSU_Type) GetCTRL_MBIST() uint8 {
	return (volatile.LoadUint8(&o.CTRL.Reg) & 0x8) >> 3
}

// DSU.STATUSA: Status A
func (o *DSU_Type) SetSTATUSA_DONE(value uint8) {
	volatile.StoreUint8(&o.STATUSA.Reg, volatile.LoadUint8(&o.STATUSA.Reg)&^(0x1)|value)
}
func (o *DSU_Type) GetSTATUSA_DONE() uint8 {
	return volatile.LoadUint8(&o.STATUSA.Reg) & 0x1
}
func (o *DSU_Type) SetSTATUSA_CRSTEXT(value uint8) {
	volatile.StoreUint8(&o.STATUSA.Reg, volatile.LoadUint8(&o.STATUSA.Reg)&^(0x2)|value<<1)
}
func (o *DSU_Type) GetSTATUSA_CRSTEXT() uint8 {
	return (volatile.LoadUint8(&o.STATUSA.Reg) & 0x2) >> 1
}
func (o *DSU_Type) SetSTATUSA_BERR(value uint8) {
	volatile.StoreUint8(&o.STATUSA.Reg, volatile.LoadUint8(&o.STATUSA.Reg)&^(0x4)|value<<2)
}
func (o *DSU_Type) GetSTATUSA_BERR() uint8 {
	return (volatile.LoadUint8(&o.STATUSA.Reg) & 0x4) >> 2
}
func (o *DSU_Type) SetSTATUSA_FAIL(value uint8) {
	volatile.StoreUint8(&o.STATUSA.Reg, volatile.LoadUint8(&o.STATUSA.Reg)&^(0x8)|value<<3)
}
func (o *DSU_Type) GetSTATUSA_FAIL() uint8 {
	return (volatile.LoadUint8(&o.STATUSA.Reg) & 0x8) >> 3
}
func (o *DSU_Type) SetSTATUSA_PERR(value uint8) {
	volatile.StoreUint8(&o.STATUSA.Reg, volatile.LoadUint8(&o.STATUSA.Reg)&^(0x10)|value<<4)
}
func (o *DSU_Type) GetSTATUSA_PERR() uint8 {
	return (volatile.LoadUint8(&o.STATUSA.Reg) & 0x10) >> 4
}
func (o *DSU_Type) SetSTATUSA_BREXT(value uint8) {
	volatile.StoreUint8(&o.STATUSA.Reg, volatile.LoadUint8(&o.STATUSA.Reg)&^(0x20)|value<<5)
}
func (o *DSU_Type) GetSTATUSA_BREXT() uint8 {
	return (volatile.LoadUint8(&o.STATUSA.Reg) & 0x20) >> 5
}

// DSU.STATUSB: Status B
func (o *DSU_Type) SetSTATUSB_DAL(value uint8) {
	volatile.StoreUint8(&o.STATUSB.Reg, volatile.LoadUint8(&o.STATUSB.Reg)&^(0x3)|value)
}
func (o *DSU_Type) GetSTATUSB_DAL() uint8 {
	return volatile.LoadUint8(&o.STATUSB.Reg) & 0x3
}
func (o *DSU_Type) SetSTATUSB_DBGPRES(value uint8) {
	volatile.StoreUint8(&o.STATUSB.Reg, volatile.LoadUint8(&o.STATUSB.Reg)&^(0x4)|value<<2)
}
func (o *DSU_Type) GetSTATUSB_DBGPRES() uint8 {
	return (volatile.LoadUint8(&o.STATUSB.Reg) & 0x4) >> 2
}
func (o *DSU_Type) SetSTATUSB_HPE(value uint8) {
	volatile.StoreUint8(&o.STATUSB.Reg, volatile.LoadUint8(&o.STATUSB.Reg)&^(0x8)|value<<3)
}
func (o *DSU_Type) GetSTATUSB_HPE() uint8 {
	return (volatile.LoadUint8(&o.STATUSB.Reg) & 0x8) >> 3
}
func (o *DSU_Type) SetSTATUSB_DCCD0(value uint8) {
	volatile.StoreUint8(&o.STATUSB.Reg, volatile.LoadUint8(&o.STATUSB.Reg)&^(0x10)|value<<4)
}
func (o *DSU_Type) GetSTATUSB_DCCD0() uint8 {
	return (volatile.LoadUint8(&o.STATUSB.Reg) & 0x10) >> 4
}
func (o *DSU_Type) SetSTATUSB_DCCD1(value uint8) {
	volatile.StoreUint8(&o.STATUSB.Reg, volatile.LoadUint8(&o.STATUSB.Reg)&^(0x20)|value<<5)
}
func (o *DSU_Type) GetSTATUSB_DCCD1() uint8 {
	return (volatile.LoadUint8(&o.STATUSB.Reg) & 0x20) >> 5
}
func (o *DSU_Type) SetSTATUSB_BCCD0(value uint8) {
	volatile.StoreUint8(&o.STATUSB.Reg, volatile.LoadUint8(&o.STATUSB.Reg)&^(0x40)|value<<6)
}
func (o *DSU_Type) GetSTATUSB_BCCD0() uint8 {
	return (volatile.LoadUint8(&o.STATUSB.Reg) & 0x40) >> 6
}
func (o *DSU_Type) SetSTATUSB_BCCD1(value uint8) {
	volatile.StoreUint8(&o.STATUSB.Reg, volatile.LoadUint8(&o.STATUSB.Reg)&^(0x80)|value<<7)
}
func (o *DSU_Type) GetSTATUSB_BCCD1() uint8 {
	return (volatile.LoadUint8(&o.STATUSB.Reg) & 0x80) >> 7
}

// DSU.ADDR: Address
func (o *DSU_Type) SetADDR_AMOD(value uint32) {
	volatile.StoreUint32(&o.ADDR.Reg, volatile.LoadUint32(&o.ADDR.Reg)&^(0x3)|value)
}
func (o *DSU_Type) GetADDR_AMOD() uint32 {
	return volatile.LoadUint32(&o.ADDR.Reg) & 0x3
}
func (o *DSU_Type) SetADDR(value uint32) {
	volatile.StoreUint32(&o.ADDR.Reg, volatile.LoadUint32(&o.ADDR.Reg)&^(0xfffffffc)|value<<2)
}
func (o *DSU_Type) GetADDR() uint32 {
	return (volatile.LoadUint32(&o.ADDR.Reg) & 0xfffffffc) >> 2
}

// DSU.LENGTH: Length
func (o *DSU_Type) SetLENGTH(value uint32) {
	volatile.StoreUint32(&o.LENGTH.Reg, volatile.LoadUint32(&o.LENGTH.Reg)&^(0xfffffffc)|value<<2)
}
func (o *DSU_Type) GetLENGTH() uint32 {
	return (volatile.LoadUint32(&o.LENGTH.Reg) & 0xfffffffc) >> 2
}

// DSU.DATA: Data
func (o *DSU_Type) SetDATA(value uint32) {
	volatile.StoreUint32(&o.DATA.Reg, value)
}
func (o *DSU_Type) GetDATA() uint32 {
	return volatile.LoadUint32(&o.DATA.Reg)
}

// DSU.DCC: Debug Communication Channel n
func (o *DSU_Type) SetDCC(idx int, value uint32) {
	volatile.StoreUint32(&o.DCC[idx].Reg, value)
}
func (o *DSU_Type) GetDCC(idx int) uint32 {
	return volatile.LoadUint32(&o.DCC[idx].Reg)
}

// DSU.DID: Device Identification
func (o *DSU_Type) SetDID_DEVSEL(value uint32) {
	volatile.StoreUint32(&o.DID.Reg, volatile.LoadUint32(&o.DID.Reg)&^(0xff)|value)
}
func (o *DSU_Type) GetDID_DEVSEL() uint32 {
	return volatile.LoadUint32(&o.DID.Reg) & 0xff
}
func (o *DSU_Type) SetDID_REVISION(value uint32) {
	volatile.StoreUint32(&o.DID.Reg, volatile.LoadUint32(&o.DID.Reg)&^(0xf00)|value<<8)
}
func (o *DSU_Type) GetDID_REVISION() uint32 {
	return (volatile.LoadUint32(&o.DID.Reg) & 0xf00) >> 8
}
func (o *DSU_Type) SetDID_DIE(value uint32) {
	volatile.StoreUint32(&o.DID.Reg, volatile.LoadUint32(&o.DID.Reg)&^(0xf000)|value<<12)
}
func (o *DSU_Type) GetDID_DIE() uint32 {
	return (volatile.LoadUint32(&o.DID.Reg) & 0xf000) >> 12
}
func (o *DSU_Type) SetDID_SERIES(value uint32) {
	volatile.StoreUint32(&o.DID.Reg, volatile.LoadUint32(&o.DID.Reg)&^(0x3f0000)|value<<16)
}
func (o *DSU_Type) GetDID_SERIES() uint32 {
	return (volatile.LoadUint32(&o.DID.Reg) & 0x3f0000) >> 16
}
func (o *DSU_Type) SetDID_FAMILY(value uint32) {
	volatile.StoreUint32(&o.DID.Reg, volatile.LoadUint32(&o.DID.Reg)&^(0xf800000)|value<<23)
}
func (o *DSU_Type) GetDID_FAMILY() uint32 {
	return (volatile.LoadUint32(&o.DID.Reg) & 0xf800000) >> 23
}
func (o *DSU_Type) SetDID_PROCESSOR(value uint32) {
	volatile.StoreUint32(&o.DID.Reg, volatile.LoadUint32(&o.DID.Reg)&^(0xf0000000)|value<<28)
}
func (o *DSU_Type) GetDID_PROCESSOR() uint32 {
	return (volatile.LoadUint32(&o.DID.Reg) & 0xf0000000) >> 28
}

// DSU.CFG: Configuration
func (o *DSU_Type) SetCFG_LQOS(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x3)|value)
}
func (o *DSU_Type) GetCFG_LQOS() uint32 {
	return volatile.LoadUint32(&o.CFG.Reg) & 0x3
}
func (o *DSU_Type) SetCFG_DCCDMALEVEL(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0xc)|value<<2)
}
func (o *DSU_Type) GetCFG_DCCDMALEVEL() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0xc) >> 2
}

// DSU.BCC: Boot ROM Communication Channel n
func (o *DSU_Type) SetBCC(idx int, value uint32) {
	volatile.StoreUint32(&o.BCC[idx].Reg, value)
}
func (o *DSU_Type) GetBCC(idx int) uint32 {
	return volatile.LoadUint32(&o.BCC[idx].Reg)
}

// DSU.DCFG: Device Configuration
func (o *DSU_Type) SetDCFG(idx int, value uint32) {
	volatile.StoreUint32(&o.DCFG[idx].Reg, value)
}
func (o *DSU_Type) GetDCFG(idx int) uint32 {
	return volatile.LoadUint32(&o.DCFG[idx].Reg)
}

// DSU.ENTRY0: CoreSight ROM Table Entry 0
func (o *DSU_Type) SetENTRY0_EPRES(value uint32) {
	volatile.StoreUint32(&o.ENTRY0.Reg, volatile.LoadUint32(&o.ENTRY0.Reg)&^(0x1)|value)
}
func (o *DSU_Type) GetENTRY0_EPRES() uint32 {
	return volatile.LoadUint32(&o.ENTRY0.Reg) & 0x1
}
func (o *DSU_Type) SetENTRY0_FMT(value uint32) {
	volatile.StoreUint32(&o.ENTRY0.Reg, volatile.LoadUint32(&o.ENTRY0.Reg)&^(0x2)|value<<1)
}
func (o *DSU_Type) GetENTRY0_FMT() uint32 {
	return (volatile.LoadUint32(&o.ENTRY0.Reg) & 0x2) >> 1
}
func (o *DSU_Type) SetENTRY0_ADDOFF(value uint32) {
	volatile.StoreUint32(&o.ENTRY0.Reg, volatile.LoadUint32(&o.ENTRY0.Reg)&^(0xfffff000)|value<<12)
}
func (o *DSU_Type) GetENTRY0_ADDOFF() uint32 {
	return (volatile.LoadUint32(&o.ENTRY0.Reg) & 0xfffff000) >> 12
}

// DSU.END: CoreSight ROM Table End
func (o *DSU_Type) SetEND(value uint32) {
	volatile.StoreUint32(&o.END.Reg, value)
}
func (o *DSU_Type) GetEND() uint32 {
	return volatile.LoadUint32(&o.END.Reg)
}

// DSU.MEMTYPE: CoreSight ROM Table Memory Type
func (o *DSU_Type) SetMEMTYPE_SMEMP(value uint32) {
	volatile.StoreUint32(&o.MEMTYPE.Reg, volatile.LoadUint32(&o.MEMTYPE.Reg)&^(0x1)|value)
}
func (o *DSU_Type) GetMEMTYPE_SMEMP() uint32 {
	return volatile.LoadUint32(&o.MEMTYPE.Reg) & 0x1
}

// DSU.PID4: Peripheral Identification 4
func (o *DSU_Type) SetPID4_JEPCC(value uint32) {
	volatile.StoreUint32(&o.PID4.Reg, volatile.LoadUint32(&o.PID4.Reg)&^(0xf)|value)
}
func (o *DSU_Type) GetPID4_JEPCC() uint32 {
	return volatile.LoadUint32(&o.PID4.Reg) & 0xf
}
func (o *DSU_Type) SetPID4_FKBC(value uint32) {
	volatile.StoreUint32(&o.PID4.Reg, volatile.LoadUint32(&o.PID4.Reg)&^(0xf0)|value<<4)
}
func (o *DSU_Type) GetPID4_FKBC() uint32 {
	return (volatile.LoadUint32(&o.PID4.Reg) & 0xf0) >> 4
}

// DSU.PID0: Peripheral Identification 0
func (o *DSU_Type) SetPID0_PARTNBL(value uint32) {
	volatile.StoreUint32(&o.PID0.Reg, volatile.LoadUint32(&o.PID0.Reg)&^(0xff)|value)
}
func (o *DSU_Type) GetPID0_PARTNBL() uint32 {
	return volatile.LoadUint32(&o.PID0.Reg) & 0xff
}

// DSU.PID1: Peripheral Identification 1
func (o *DSU_Type) SetPID1_PARTNBH(value uint32) {
	volatile.StoreUint32(&o.PID1.Reg, volatile.LoadUint32(&o.PID1.Reg)&^(0xf)|value)
}
func (o *DSU_Type) GetPID1_PARTNBH() uint32 {
	return volatile.LoadUint32(&o.PID1.Reg) & 0xf
}
func (o *DSU_Type) SetPID1_JEPIDCL(value uint32) {
	volatile.StoreUint32(&o.PID1.Reg, volatile.LoadUint32(&o.PID1.Reg)&^(0xf0)|value<<4)
}
func (o *DSU_Type) GetPID1_JEPIDCL() uint32 {
	return (volatile.LoadUint32(&o.PID1.Reg) & 0xf0) >> 4
}

// DSU.PID2: Peripheral Identification 2
func (o *DSU_Type) SetPID2_JEPIDCH(value uint32) {
	volatile.StoreUint32(&o.PID2.Reg, volatile.LoadUint32(&o.PID2.Reg)&^(0x7)|value)
}
func (o *DSU_Type) GetPID2_JEPIDCH() uint32 {
	return volatile.LoadUint32(&o.PID2.Reg) & 0x7
}
func (o *DSU_Type) SetPID2_JEPU(value uint32) {
	volatile.StoreUint32(&o.PID2.Reg, volatile.LoadUint32(&o.PID2.Reg)&^(0x8)|value<<3)
}
func (o *DSU_Type) GetPID2_JEPU() uint32 {
	return (volatile.LoadUint32(&o.PID2.Reg) & 0x8) >> 3
}
func (o *DSU_Type) SetPID2_REVISION(value uint32) {
	volatile.StoreUint32(&o.PID2.Reg, volatile.LoadUint32(&o.PID2.Reg)&^(0xf0)|value<<4)
}
func (o *DSU_Type) GetPID2_REVISION() uint32 {
	return (volatile.LoadUint32(&o.PID2.Reg) & 0xf0) >> 4
}

// DSU.PID3: Peripheral Identification 3
func (o *DSU_Type) SetPID3_CUSMOD(value uint32) {
	volatile.StoreUint32(&o.PID3.Reg, volatile.LoadUint32(&o.PID3.Reg)&^(0xf)|value)
}
func (o *DSU_Type) GetPID3_CUSMOD() uint32 {
	return volatile.LoadUint32(&o.PID3.Reg) & 0xf
}
func (o *DSU_Type) SetPID3_REVAND(value uint32) {
	volatile.StoreUint32(&o.PID3.Reg, volatile.LoadUint32(&o.PID3.Reg)&^(0xf0)|value<<4)
}
func (o *DSU_Type) GetPID3_REVAND() uint32 {
	return (volatile.LoadUint32(&o.PID3.Reg) & 0xf0) >> 4
}

// DSU.CID0: Component Identification 0
func (o *DSU_Type) SetCID0_PREAMBLEB0(value uint32) {
	volatile.StoreUint32(&o.CID0.Reg, volatile.LoadUint32(&o.CID0.Reg)&^(0xff)|value)
}
func (o *DSU_Type) GetCID0_PREAMBLEB0() uint32 {
	return volatile.LoadUint32(&o.CID0.Reg) & 0xff
}

// DSU.CID1: Component Identification 1
func (o *DSU_Type) SetCID1_PREAMBLE(value uint32) {
	volatile.StoreUint32(&o.CID1.Reg, volatile.LoadUint32(&o.CID1.Reg)&^(0xf)|value)
}
func (o *DSU_Type) GetCID1_PREAMBLE() uint32 {
	return volatile.LoadUint32(&o.CID1.Reg) & 0xf
}
func (o *DSU_Type) SetCID1_CCLASS(value uint32) {
	volatile.StoreUint32(&o.CID1.Reg, volatile.LoadUint32(&o.CID1.Reg)&^(0xf0)|value<<4)
}
func (o *DSU_Type) GetCID1_CCLASS() uint32 {
	return (volatile.LoadUint32(&o.CID1.Reg) & 0xf0) >> 4
}

// DSU.CID2: Component Identification 2
func (o *DSU_Type) SetCID2_PREAMBLEB2(value uint32) {
	volatile.StoreUint32(&o.CID2.Reg, volatile.LoadUint32(&o.CID2.Reg)&^(0xff)|value)
}
func (o *DSU_Type) GetCID2_PREAMBLEB2() uint32 {
	return volatile.LoadUint32(&o.CID2.Reg) & 0xff
}

// DSU.CID3: Component Identification 3
func (o *DSU_Type) SetCID3_PREAMBLEB3(value uint32) {
	volatile.StoreUint32(&o.CID3.Reg, volatile.LoadUint32(&o.CID3.Reg)&^(0xff)|value)
}
func (o *DSU_Type) GetCID3_PREAMBLEB3() uint32 {
	return volatile.LoadUint32(&o.CID3.Reg) & 0xff
}

// External Interrupt Controller
type EIC_Type struct {
	CTRLA      volatile.Register8 // 0x0
	NMICTRL    volatile.Register8 // 0x1
	NMIFLAG    volatile.Register8 // 0x2
	_          byte
	SYNCBUSY   volatile.Register32    // 0x4
	EVCTRL     volatile.Register32    // 0x8
	INTENCLR   volatile.Register32    // 0xC
	INTENSET   volatile.Register32    // 0x10
	INTFLAG    volatile.Register32    // 0x14
	ASYNCH     volatile.Register32    // 0x18
	CONFIG     [1]volatile.Register32 // 0x1C
	_          [16]byte
	DEBOUNCEN  volatile.Register32 // 0x30
	DPRESCALER volatile.Register32 // 0x34
	PINSTATE   volatile.Register32 // 0x38
	NSCHK      volatile.Register32 // 0x3C
	NONSEC     volatile.Register32 // 0x40
}

// EIC.CTRLA: Control A
func (o *EIC_Type) SetCTRLA_SWRST(value uint8) {
	volatile.StoreUint8(&o.CTRLA.Reg, volatile.LoadUint8(&o.CTRLA.Reg)&^(0x1)|value)
}
func (o *EIC_Type) GetCTRLA_SWRST() uint8 {
	return volatile.LoadUint8(&o.CTRLA.Reg) & 0x1
}
func (o *EIC_Type) SetCTRLA_ENABLE(value uint8) {
	volatile.StoreUint8(&o.CTRLA.Reg, volatile.LoadUint8(&o.CTRLA.Reg)&^(0x2)|value<<1)
}
func (o *EIC_Type) GetCTRLA_ENABLE() uint8 {
	return (volatile.LoadUint8(&o.CTRLA.Reg) & 0x2) >> 1
}
func (o *EIC_Type) SetCTRLA_CKSEL(value uint8) {
	volatile.StoreUint8(&o.CTRLA.Reg, volatile.LoadUint8(&o.CTRLA.Reg)&^(0x10)|value<<4)
}
func (o *EIC_Type) GetCTRLA_CKSEL() uint8 {
	return (volatile.LoadUint8(&o.CTRLA.Reg) & 0x10) >> 4
}

// EIC.NMICTRL: Non-Maskable Interrupt Control
func (o *EIC_Type) SetNMICTRL_NMISENSE(value uint8) {
	volatile.StoreUint8(&o.NMICTRL.Reg, volatile.LoadUint8(&o.NMICTRL.Reg)&^(0x7)|value)
}
func (o *EIC_Type) GetNMICTRL_NMISENSE() uint8 {
	return volatile.LoadUint8(&o.NMICTRL.Reg) & 0x7
}
func (o *EIC_Type) SetNMICTRL_NMIFILTEN(value uint8) {
	volatile.StoreUint8(&o.NMICTRL.Reg, volatile.LoadUint8(&o.NMICTRL.Reg)&^(0x8)|value<<3)
}
func (o *EIC_Type) GetNMICTRL_NMIFILTEN() uint8 {
	return (volatile.LoadUint8(&o.NMICTRL.Reg) & 0x8) >> 3
}
func (o *EIC_Type) SetNMICTRL_NMIASYNCH(value uint8) {
	volatile.StoreUint8(&o.NMICTRL.Reg, volatile.LoadUint8(&o.NMICTRL.Reg)&^(0x10)|value<<4)
}
func (o *EIC_Type) GetNMICTRL_NMIASYNCH() uint8 {
	return (volatile.LoadUint8(&o.NMICTRL.Reg) & 0x10) >> 4
}

// EIC.NMIFLAG: Non-Maskable Interrupt Flag Status and Clear
func (o *EIC_Type) SetNMIFLAG_NMI(value uint8) {
	volatile.StoreUint8(&o.NMIFLAG.Reg, volatile.LoadUint8(&o.NMIFLAG.Reg)&^(0x1)|value)
}
func (o *EIC_Type) GetNMIFLAG_NMI() uint8 {
	return volatile.LoadUint8(&o.NMIFLAG.Reg) & 0x1
}

// EIC.SYNCBUSY: Synchronization Busy
func (o *EIC_Type) SetSYNCBUSY_SWRST(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x1)|value)
}
func (o *EIC_Type) GetSYNCBUSY_SWRST() uint32 {
	return volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x1
}
func (o *EIC_Type) SetSYNCBUSY_ENABLE(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x2)|value<<1)
}
func (o *EIC_Type) GetSYNCBUSY_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x2) >> 1
}

// EIC.EVCTRL: Event Control
func (o *EIC_Type) SetEVCTRL_EXTINTEO(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0xff)|value)
}
func (o *EIC_Type) GetEVCTRL_EXTINTEO() uint32 {
	return volatile.LoadUint32(&o.EVCTRL.Reg) & 0xff
}

// EIC.INTENCLR: Interrupt Enable Clear
func (o *EIC_Type) SetINTENCLR_EXTINT(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0xff)|value)
}
func (o *EIC_Type) GetINTENCLR_EXTINT() uint32 {
	return volatile.LoadUint32(&o.INTENCLR.Reg) & 0xff
}
func (o *EIC_Type) SetINTENCLR_NSCHK(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x80000000)|value<<31)
}
func (o *EIC_Type) GetINTENCLR_NSCHK() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x80000000) >> 31
}

// EIC.INTENSET: Interrupt Enable Set
func (o *EIC_Type) SetINTENSET_EXTINT(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0xff)|value)
}
func (o *EIC_Type) GetINTENSET_EXTINT() uint32 {
	return volatile.LoadUint32(&o.INTENSET.Reg) & 0xff
}
func (o *EIC_Type) SetINTENSET_NSCHK(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x80000000)|value<<31)
}
func (o *EIC_Type) GetINTENSET_NSCHK() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x80000000) >> 31
}

// EIC.INTFLAG: Interrupt Flag Status and Clear
func (o *EIC_Type) SetINTFLAG_EXTINT(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0xff)|value)
}
func (o *EIC_Type) GetINTFLAG_EXTINT() uint32 {
	return volatile.LoadUint32(&o.INTFLAG.Reg) & 0xff
}
func (o *EIC_Type) SetINTFLAG_NSCHK(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x80000000)|value<<31)
}
func (o *EIC_Type) GetINTFLAG_NSCHK() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x80000000) >> 31
}

// EIC.ASYNCH: External Interrupt Asynchronous Mode
func (o *EIC_Type) SetASYNCH(value uint32) {
	volatile.StoreUint32(&o.ASYNCH.Reg, volatile.LoadUint32(&o.ASYNCH.Reg)&^(0xff)|value)
}
func (o *EIC_Type) GetASYNCH() uint32 {
	return volatile.LoadUint32(&o.ASYNCH.Reg) & 0xff
}

// EIC.CONFIG: External Interrupt Sense Configuration
func (o *EIC_Type) SetCONFIG_SENSE0(idx int, value uint32) {
	volatile.StoreUint32(&o.CONFIG[idx].Reg, volatile.LoadUint32(&o.CONFIG[idx].Reg)&^(0x7)|value)
}
func (o *EIC_Type) GetCONFIG_SENSE0(idx int) uint32 {
	return volatile.LoadUint32(&o.CONFIG[idx].Reg) & 0x7
}
func (o *EIC_Type) SetCONFIG_FILTEN0(idx int, value uint32) {
	volatile.StoreUint32(&o.CONFIG[idx].Reg, volatile.LoadUint32(&o.CONFIG[idx].Reg)&^(0x8)|value<<3)
}
func (o *EIC_Type) GetCONFIG_FILTEN0(idx int) uint32 {
	return (volatile.LoadUint32(&o.CONFIG[idx].Reg) & 0x8) >> 3
}
func (o *EIC_Type) SetCONFIG_SENSE1(idx int, value uint32) {
	volatile.StoreUint32(&o.CONFIG[idx].Reg, volatile.LoadUint32(&o.CONFIG[idx].Reg)&^(0x70)|value<<4)
}
func (o *EIC_Type) GetCONFIG_SENSE1(idx int) uint32 {
	return (volatile.LoadUint32(&o.CONFIG[idx].Reg) & 0x70) >> 4
}
func (o *EIC_Type) SetCONFIG_FILTEN1(idx int, value uint32) {
	volatile.StoreUint32(&o.CONFIG[idx].Reg, volatile.LoadUint32(&o.CONFIG[idx].Reg)&^(0x80)|value<<7)
}
func (o *EIC_Type) GetCONFIG_FILTEN1(idx int) uint32 {
	return (volatile.LoadUint32(&o.CONFIG[idx].Reg) & 0x80) >> 7
}
func (o *EIC_Type) SetCONFIG_SENSE2(idx int, value uint32) {
	volatile.StoreUint32(&o.CONFIG[idx].Reg, volatile.LoadUint32(&o.CONFIG[idx].Reg)&^(0x700)|value<<8)
}
func (o *EIC_Type) GetCONFIG_SENSE2(idx int) uint32 {
	return (volatile.LoadUint32(&o.CONFIG[idx].Reg) & 0x700) >> 8
}
func (o *EIC_Type) SetCONFIG_FILTEN2(idx int, value uint32) {
	volatile.StoreUint32(&o.CONFIG[idx].Reg, volatile.LoadUint32(&o.CONFIG[idx].Reg)&^(0x800)|value<<11)
}
func (o *EIC_Type) GetCONFIG_FILTEN2(idx int) uint32 {
	return (volatile.LoadUint32(&o.CONFIG[idx].Reg) & 0x800) >> 11
}
func (o *EIC_Type) SetCONFIG_SENSE3(idx int, value uint32) {
	volatile.StoreUint32(&o.CONFIG[idx].Reg, volatile.LoadUint32(&o.CONFIG[idx].Reg)&^(0x7000)|value<<12)
}
func (o *EIC_Type) GetCONFIG_SENSE3(idx int) uint32 {
	return (volatile.LoadUint32(&o.CONFIG[idx].Reg) & 0x7000) >> 12
}
func (o *EIC_Type) SetCONFIG_FILTEN3(idx int, value uint32) {
	volatile.StoreUint32(&o.CONFIG[idx].Reg, volatile.LoadUint32(&o.CONFIG[idx].Reg)&^(0x8000)|value<<15)
}
func (o *EIC_Type) GetCONFIG_FILTEN3(idx int) uint32 {
	return (volatile.LoadUint32(&o.CONFIG[idx].Reg) & 0x8000) >> 15
}
func (o *EIC_Type) SetCONFIG_SENSE4(idx int, value uint32) {
	volatile.StoreUint32(&o.CONFIG[idx].Reg, volatile.LoadUint32(&o.CONFIG[idx].Reg)&^(0x70000)|value<<16)
}
func (o *EIC_Type) GetCONFIG_SENSE4(idx int) uint32 {
	return (volatile.LoadUint32(&o.CONFIG[idx].Reg) & 0x70000) >> 16
}
func (o *EIC_Type) SetCONFIG_FILTEN4(idx int, value uint32) {
	volatile.StoreUint32(&o.CONFIG[idx].Reg, volatile.LoadUint32(&o.CONFIG[idx].Reg)&^(0x80000)|value<<19)
}
func (o *EIC_Type) GetCONFIG_FILTEN4(idx int) uint32 {
	return (volatile.LoadUint32(&o.CONFIG[idx].Reg) & 0x80000) >> 19
}
func (o *EIC_Type) SetCONFIG_SENSE5(idx int, value uint32) {
	volatile.StoreUint32(&o.CONFIG[idx].Reg, volatile.LoadUint32(&o.CONFIG[idx].Reg)&^(0x700000)|value<<20)
}
func (o *EIC_Type) GetCONFIG_SENSE5(idx int) uint32 {
	return (volatile.LoadUint32(&o.CONFIG[idx].Reg) & 0x700000) >> 20
}
func (o *EIC_Type) SetCONFIG_FILTEN5(idx int, value uint32) {
	volatile.StoreUint32(&o.CONFIG[idx].Reg, volatile.LoadUint32(&o.CONFIG[idx].Reg)&^(0x800000)|value<<23)
}
func (o *EIC_Type) GetCONFIG_FILTEN5(idx int) uint32 {
	return (volatile.LoadUint32(&o.CONFIG[idx].Reg) & 0x800000) >> 23
}
func (o *EIC_Type) SetCONFIG_SENSE6(idx int, value uint32) {
	volatile.StoreUint32(&o.CONFIG[idx].Reg, volatile.LoadUint32(&o.CONFIG[idx].Reg)&^(0x7000000)|value<<24)
}
func (o *EIC_Type) GetCONFIG_SENSE6(idx int) uint32 {
	return (volatile.LoadUint32(&o.CONFIG[idx].Reg) & 0x7000000) >> 24
}
func (o *EIC_Type) SetCONFIG_FILTEN6(idx int, value uint32) {
	volatile.StoreUint32(&o.CONFIG[idx].Reg, volatile.LoadUint32(&o.CONFIG[idx].Reg)&^(0x8000000)|value<<27)
}
func (o *EIC_Type) GetCONFIG_FILTEN6(idx int) uint32 {
	return (volatile.LoadUint32(&o.CONFIG[idx].Reg) & 0x8000000) >> 27
}
func (o *EIC_Type) SetCONFIG_SENSE7(idx int, value uint32) {
	volatile.StoreUint32(&o.CONFIG[idx].Reg, volatile.LoadUint32(&o.CONFIG[idx].Reg)&^(0x70000000)|value<<28)
}
func (o *EIC_Type) GetCONFIG_SENSE7(idx int) uint32 {
	return (volatile.LoadUint32(&o.CONFIG[idx].Reg) & 0x70000000) >> 28
}
func (o *EIC_Type) SetCONFIG_FILTEN7(idx int, value uint32) {
	volatile.StoreUint32(&o.CONFIG[idx].Reg, volatile.LoadUint32(&o.CONFIG[idx].Reg)&^(0x80000000)|value<<31)
}
func (o *EIC_Type) GetCONFIG_FILTEN7(idx int) uint32 {
	return (volatile.LoadUint32(&o.CONFIG[idx].Reg) & 0x80000000) >> 31
}

// EIC.DEBOUNCEN: Debouncer Enable
func (o *EIC_Type) SetDEBOUNCEN(value uint32) {
	volatile.StoreUint32(&o.DEBOUNCEN.Reg, volatile.LoadUint32(&o.DEBOUNCEN.Reg)&^(0xff)|value)
}
func (o *EIC_Type) GetDEBOUNCEN() uint32 {
	return volatile.LoadUint32(&o.DEBOUNCEN.Reg) & 0xff
}

// EIC.DPRESCALER: Debouncer Prescaler
func (o *EIC_Type) SetDPRESCALER_PRESCALER0(value uint32) {
	volatile.StoreUint32(&o.DPRESCALER.Reg, volatile.LoadUint32(&o.DPRESCALER.Reg)&^(0x7)|value)
}
func (o *EIC_Type) GetDPRESCALER_PRESCALER0() uint32 {
	return volatile.LoadUint32(&o.DPRESCALER.Reg) & 0x7
}
func (o *EIC_Type) SetDPRESCALER_STATES0(value uint32) {
	volatile.StoreUint32(&o.DPRESCALER.Reg, volatile.LoadUint32(&o.DPRESCALER.Reg)&^(0x8)|value<<3)
}
func (o *EIC_Type) GetDPRESCALER_STATES0() uint32 {
	return (volatile.LoadUint32(&o.DPRESCALER.Reg) & 0x8) >> 3
}
func (o *EIC_Type) SetDPRESCALER_TICKON(value uint32) {
	volatile.StoreUint32(&o.DPRESCALER.Reg, volatile.LoadUint32(&o.DPRESCALER.Reg)&^(0x10000)|value<<16)
}
func (o *EIC_Type) GetDPRESCALER_TICKON() uint32 {
	return (volatile.LoadUint32(&o.DPRESCALER.Reg) & 0x10000) >> 16
}

// EIC.PINSTATE: Pin State
func (o *EIC_Type) SetPINSTATE(value uint32) {
	volatile.StoreUint32(&o.PINSTATE.Reg, volatile.LoadUint32(&o.PINSTATE.Reg)&^(0xff)|value)
}
func (o *EIC_Type) GetPINSTATE() uint32 {
	return volatile.LoadUint32(&o.PINSTATE.Reg) & 0xff
}

// EIC.NSCHK: Non-secure Interrupt Check Enable
func (o *EIC_Type) SetNSCHK_EXTINT(value uint32) {
	volatile.StoreUint32(&o.NSCHK.Reg, volatile.LoadUint32(&o.NSCHK.Reg)&^(0xff)|value)
}
func (o *EIC_Type) GetNSCHK_EXTINT() uint32 {
	return volatile.LoadUint32(&o.NSCHK.Reg) & 0xff
}
func (o *EIC_Type) SetNSCHK_NMI(value uint32) {
	volatile.StoreUint32(&o.NSCHK.Reg, volatile.LoadUint32(&o.NSCHK.Reg)&^(0x80000000)|value<<31)
}
func (o *EIC_Type) GetNSCHK_NMI() uint32 {
	return (volatile.LoadUint32(&o.NSCHK.Reg) & 0x80000000) >> 31
}

// EIC.NONSEC: Non-secure Interrupt
func (o *EIC_Type) SetNONSEC_EXTINT(value uint32) {
	volatile.StoreUint32(&o.NONSEC.Reg, volatile.LoadUint32(&o.NONSEC.Reg)&^(0xff)|value)
}
func (o *EIC_Type) GetNONSEC_EXTINT() uint32 {
	return volatile.LoadUint32(&o.NONSEC.Reg) & 0xff
}
func (o *EIC_Type) SetNONSEC_NMI(value uint32) {
	volatile.StoreUint32(&o.NONSEC.Reg, volatile.LoadUint32(&o.NONSEC.Reg)&^(0x80000000)|value<<31)
}
func (o *EIC_Type) GetNONSEC_NMI() uint32 {
	return (volatile.LoadUint32(&o.NONSEC.Reg) & 0x80000000) >> 31
}

// Event System Interface
type EVSYS_Type struct {
	CTRLA      volatile.Register8 // 0x0
	_          [3]byte
	SWEVT      volatile.Register32 // 0x4
	PRICTRL    volatile.Register8  // 0x8
	_          [7]byte
	INTPEND    volatile.Register16 // 0x10
	_          [2]byte
	INTSTATUS  volatile.Register32   // 0x14
	BUSYCH     volatile.Register32   // 0x18
	READYUSR   volatile.Register32   // 0x1C
	CHANNEL    [8]EVSYS_CHANNEL_Type // 0x20
	_          [192]byte
	USER       [23]volatile.Register8 // 0x120
	_          [157]byte
	INTENCLR   volatile.Register8 // 0x1D4
	INTENSET   volatile.Register8 // 0x1D5
	INTFLAG    volatile.Register8 // 0x1D6
	_          byte
	NONSECCHAN volatile.Register32    // 0x1D8
	NSCHKCHAN  volatile.Register32    // 0x1DC
	NONSECUSER [1]volatile.Register32 // 0x1E0
	_          [12]byte
	NSCHKUSER  [1]volatile.Register32 // 0x1F0
}

// EVSYS.CTRLA: Control
func (o *EVSYS_Type) SetCTRLA_SWRST(value uint8) {
	volatile.StoreUint8(&o.CTRLA.Reg, volatile.LoadUint8(&o.CTRLA.Reg)&^(0x1)|value)
}
func (o *EVSYS_Type) GetCTRLA_SWRST() uint8 {
	return volatile.LoadUint8(&o.CTRLA.Reg) & 0x1
}

// EVSYS.SWEVT: Software Event
func (o *EVSYS_Type) SetSWEVT_CHANNEL0(value uint32) {
	volatile.StoreUint32(&o.SWEVT.Reg, volatile.LoadUint32(&o.SWEVT.Reg)&^(0x1)|value)
}
func (o *EVSYS_Type) GetSWEVT_CHANNEL0() uint32 {
	return volatile.LoadUint32(&o.SWEVT.Reg) & 0x1
}
func (o *EVSYS_Type) SetSWEVT_CHANNEL1(value uint32) {
	volatile.StoreUint32(&o.SWEVT.Reg, volatile.LoadUint32(&o.SWEVT.Reg)&^(0x2)|value<<1)
}
func (o *EVSYS_Type) GetSWEVT_CHANNEL1() uint32 {
	return (volatile.LoadUint32(&o.SWEVT.Reg) & 0x2) >> 1
}
func (o *EVSYS_Type) SetSWEVT_CHANNEL2(value uint32) {
	volatile.StoreUint32(&o.SWEVT.Reg, volatile.LoadUint32(&o.SWEVT.Reg)&^(0x4)|value<<2)
}
func (o *EVSYS_Type) GetSWEVT_CHANNEL2() uint32 {
	return (volatile.LoadUint32(&o.SWEVT.Reg) & 0x4) >> 2
}
func (o *EVSYS_Type) SetSWEVT_CHANNEL3(value uint32) {
	volatile.StoreUint32(&o.SWEVT.Reg, volatile.LoadUint32(&o.SWEVT.Reg)&^(0x8)|value<<3)
}
func (o *EVSYS_Type) GetSWEVT_CHANNEL3() uint32 {
	return (volatile.LoadUint32(&o.SWEVT.Reg) & 0x8) >> 3
}
func (o *EVSYS_Type) SetSWEVT_CHANNEL4(value uint32) {
	volatile.StoreUint32(&o.SWEVT.Reg, volatile.LoadUint32(&o.SWEVT.Reg)&^(0x10)|value<<4)
}
func (o *EVSYS_Type) GetSWEVT_CHANNEL4() uint32 {
	return (volatile.LoadUint32(&o.SWEVT.Reg) & 0x10) >> 4
}
func (o *EVSYS_Type) SetSWEVT_CHANNEL5(value uint32) {
	volatile.StoreUint32(&o.SWEVT.Reg, volatile.LoadUint32(&o.SWEVT.Reg)&^(0x20)|value<<5)
}
func (o *EVSYS_Type) GetSWEVT_CHANNEL5() uint32 {
	return (volatile.LoadUint32(&o.SWEVT.Reg) & 0x20) >> 5
}
func (o *EVSYS_Type) SetSWEVT_CHANNEL6(value uint32) {
	volatile.StoreUint32(&o.SWEVT.Reg, volatile.LoadUint32(&o.SWEVT.Reg)&^(0x40)|value<<6)
}
func (o *EVSYS_Type) GetSWEVT_CHANNEL6() uint32 {
	return (volatile.LoadUint32(&o.SWEVT.Reg) & 0x40) >> 6
}
func (o *EVSYS_Type) SetSWEVT_CHANNEL7(value uint32) {
	volatile.StoreUint32(&o.SWEVT.Reg, volatile.LoadUint32(&o.SWEVT.Reg)&^(0x80)|value<<7)
}
func (o *EVSYS_Type) GetSWEVT_CHANNEL7() uint32 {
	return (volatile.LoadUint32(&o.SWEVT.Reg) & 0x80) >> 7
}

// EVSYS.PRICTRL: Priority Control
func (o *EVSYS_Type) SetPRICTRL_PRI(value uint8) {
	volatile.StoreUint8(&o.PRICTRL.Reg, volatile.LoadUint8(&o.PRICTRL.Reg)&^(0x3)|value)
}
func (o *EVSYS_Type) GetPRICTRL_PRI() uint8 {
	return volatile.LoadUint8(&o.PRICTRL.Reg) & 0x3
}
func (o *EVSYS_Type) SetPRICTRL_RREN(value uint8) {
	volatile.StoreUint8(&o.PRICTRL.Reg, volatile.LoadUint8(&o.PRICTRL.Reg)&^(0x80)|value<<7)
}
func (o *EVSYS_Type) GetPRICTRL_RREN() uint8 {
	return (volatile.LoadUint8(&o.PRICTRL.Reg) & 0x80) >> 7
}

// EVSYS.INTPEND: Channel Pending Interrupt
func (o *EVSYS_Type) SetINTPEND_ID(value uint16) {
	volatile.StoreUint16(&o.INTPEND.Reg, volatile.LoadUint16(&o.INTPEND.Reg)&^(0x3)|value)
}
func (o *EVSYS_Type) GetINTPEND_ID() uint16 {
	return volatile.LoadUint16(&o.INTPEND.Reg) & 0x3
}
func (o *EVSYS_Type) SetINTPEND_OVR(value uint16) {
	volatile.StoreUint16(&o.INTPEND.Reg, volatile.LoadUint16(&o.INTPEND.Reg)&^(0x100)|value<<8)
}
func (o *EVSYS_Type) GetINTPEND_OVR() uint16 {
	return (volatile.LoadUint16(&o.INTPEND.Reg) & 0x100) >> 8
}
func (o *EVSYS_Type) SetINTPEND_EVD(value uint16) {
	volatile.StoreUint16(&o.INTPEND.Reg, volatile.LoadUint16(&o.INTPEND.Reg)&^(0x200)|value<<9)
}
func (o *EVSYS_Type) GetINTPEND_EVD() uint16 {
	return (volatile.LoadUint16(&o.INTPEND.Reg) & 0x200) >> 9
}
func (o *EVSYS_Type) SetINTPEND_READY(value uint16) {
	volatile.StoreUint16(&o.INTPEND.Reg, volatile.LoadUint16(&o.INTPEND.Reg)&^(0x4000)|value<<14)
}
func (o *EVSYS_Type) GetINTPEND_READY() uint16 {
	return (volatile.LoadUint16(&o.INTPEND.Reg) & 0x4000) >> 14
}
func (o *EVSYS_Type) SetINTPEND_BUSY(value uint16) {
	volatile.StoreUint16(&o.INTPEND.Reg, volatile.LoadUint16(&o.INTPEND.Reg)&^(0x8000)|value<<15)
}
func (o *EVSYS_Type) GetINTPEND_BUSY() uint16 {
	return (volatile.LoadUint16(&o.INTPEND.Reg) & 0x8000) >> 15
}

// EVSYS.INTSTATUS: Interrupt Status
func (o *EVSYS_Type) SetINTSTATUS_CHINT0(value uint32) {
	volatile.StoreUint32(&o.INTSTATUS.Reg, volatile.LoadUint32(&o.INTSTATUS.Reg)&^(0x1)|value)
}
func (o *EVSYS_Type) GetINTSTATUS_CHINT0() uint32 {
	return volatile.LoadUint32(&o.INTSTATUS.Reg) & 0x1
}
func (o *EVSYS_Type) SetINTSTATUS_CHINT1(value uint32) {
	volatile.StoreUint32(&o.INTSTATUS.Reg, volatile.LoadUint32(&o.INTSTATUS.Reg)&^(0x2)|value<<1)
}
func (o *EVSYS_Type) GetINTSTATUS_CHINT1() uint32 {
	return (volatile.LoadUint32(&o.INTSTATUS.Reg) & 0x2) >> 1
}
func (o *EVSYS_Type) SetINTSTATUS_CHINT2(value uint32) {
	volatile.StoreUint32(&o.INTSTATUS.Reg, volatile.LoadUint32(&o.INTSTATUS.Reg)&^(0x4)|value<<2)
}
func (o *EVSYS_Type) GetINTSTATUS_CHINT2() uint32 {
	return (volatile.LoadUint32(&o.INTSTATUS.Reg) & 0x4) >> 2
}
func (o *EVSYS_Type) SetINTSTATUS_CHINT3(value uint32) {
	volatile.StoreUint32(&o.INTSTATUS.Reg, volatile.LoadUint32(&o.INTSTATUS.Reg)&^(0x8)|value<<3)
}
func (o *EVSYS_Type) GetINTSTATUS_CHINT3() uint32 {
	return (volatile.LoadUint32(&o.INTSTATUS.Reg) & 0x8) >> 3
}

// EVSYS.BUSYCH: Busy Channels
func (o *EVSYS_Type) SetBUSYCH_BUSYCH0(value uint32) {
	volatile.StoreUint32(&o.BUSYCH.Reg, volatile.LoadUint32(&o.BUSYCH.Reg)&^(0x1)|value)
}
func (o *EVSYS_Type) GetBUSYCH_BUSYCH0() uint32 {
	return volatile.LoadUint32(&o.BUSYCH.Reg) & 0x1
}
func (o *EVSYS_Type) SetBUSYCH_BUSYCH1(value uint32) {
	volatile.StoreUint32(&o.BUSYCH.Reg, volatile.LoadUint32(&o.BUSYCH.Reg)&^(0x2)|value<<1)
}
func (o *EVSYS_Type) GetBUSYCH_BUSYCH1() uint32 {
	return (volatile.LoadUint32(&o.BUSYCH.Reg) & 0x2) >> 1
}
func (o *EVSYS_Type) SetBUSYCH_BUSYCH2(value uint32) {
	volatile.StoreUint32(&o.BUSYCH.Reg, volatile.LoadUint32(&o.BUSYCH.Reg)&^(0x4)|value<<2)
}
func (o *EVSYS_Type) GetBUSYCH_BUSYCH2() uint32 {
	return (volatile.LoadUint32(&o.BUSYCH.Reg) & 0x4) >> 2
}
func (o *EVSYS_Type) SetBUSYCH_BUSYCH3(value uint32) {
	volatile.StoreUint32(&o.BUSYCH.Reg, volatile.LoadUint32(&o.BUSYCH.Reg)&^(0x8)|value<<3)
}
func (o *EVSYS_Type) GetBUSYCH_BUSYCH3() uint32 {
	return (volatile.LoadUint32(&o.BUSYCH.Reg) & 0x8) >> 3
}

// EVSYS.READYUSR: Ready Users
func (o *EVSYS_Type) SetREADYUSR_READYUSR0(value uint32) {
	volatile.StoreUint32(&o.READYUSR.Reg, volatile.LoadUint32(&o.READYUSR.Reg)&^(0x1)|value)
}
func (o *EVSYS_Type) GetREADYUSR_READYUSR0() uint32 {
	return volatile.LoadUint32(&o.READYUSR.Reg) & 0x1
}
func (o *EVSYS_Type) SetREADYUSR_READYUSR1(value uint32) {
	volatile.StoreUint32(&o.READYUSR.Reg, volatile.LoadUint32(&o.READYUSR.Reg)&^(0x2)|value<<1)
}
func (o *EVSYS_Type) GetREADYUSR_READYUSR1() uint32 {
	return (volatile.LoadUint32(&o.READYUSR.Reg) & 0x2) >> 1
}
func (o *EVSYS_Type) SetREADYUSR_READYUSR2(value uint32) {
	volatile.StoreUint32(&o.READYUSR.Reg, volatile.LoadUint32(&o.READYUSR.Reg)&^(0x4)|value<<2)
}
func (o *EVSYS_Type) GetREADYUSR_READYUSR2() uint32 {
	return (volatile.LoadUint32(&o.READYUSR.Reg) & 0x4) >> 2
}
func (o *EVSYS_Type) SetREADYUSR_READYUSR3(value uint32) {
	volatile.StoreUint32(&o.READYUSR.Reg, volatile.LoadUint32(&o.READYUSR.Reg)&^(0x8)|value<<3)
}
func (o *EVSYS_Type) GetREADYUSR_READYUSR3() uint32 {
	return (volatile.LoadUint32(&o.READYUSR.Reg) & 0x8) >> 3
}

// EVSYS.USER: User Multiplexer n
func (o *EVSYS_Type) SetUSER_CHANNEL(idx int, value uint8) {
	volatile.StoreUint8(&o.USER[idx].Reg, volatile.LoadUint8(&o.USER[idx].Reg)&^(0xf)|value)
}
func (o *EVSYS_Type) GetUSER_CHANNEL(idx int) uint8 {
	return volatile.LoadUint8(&o.USER[idx].Reg) & 0xf
}

// EVSYS.INTENCLR: Interrupt Enable Clear
func (o *EVSYS_Type) SetINTENCLR_NSCHK(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *EVSYS_Type) GetINTENCLR_NSCHK() uint8 {
	return volatile.LoadUint8(&o.INTENCLR.Reg) & 0x1
}

// EVSYS.INTENSET: Interrupt Enable Set
func (o *EVSYS_Type) SetINTENSET_NSCHK(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *EVSYS_Type) GetINTENSET_NSCHK() uint8 {
	return volatile.LoadUint8(&o.INTENSET.Reg) & 0x1
}

// EVSYS.INTFLAG: Interrupt Flag Status and Clear
func (o *EVSYS_Type) SetINTFLAG_NSCHK(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x1)|value)
}
func (o *EVSYS_Type) GetINTFLAG_NSCHK() uint8 {
	return volatile.LoadUint8(&o.INTFLAG.Reg) & 0x1
}

// EVSYS.NONSECCHAN: Channels Security Attribution
func (o *EVSYS_Type) SetNONSECCHAN_CHANNEL0(value uint32) {
	volatile.StoreUint32(&o.NONSECCHAN.Reg, volatile.LoadUint32(&o.NONSECCHAN.Reg)&^(0x1)|value)
}
func (o *EVSYS_Type) GetNONSECCHAN_CHANNEL0() uint32 {
	return volatile.LoadUint32(&o.NONSECCHAN.Reg) & 0x1
}
func (o *EVSYS_Type) SetNONSECCHAN_CHANNEL1(value uint32) {
	volatile.StoreUint32(&o.NONSECCHAN.Reg, volatile.LoadUint32(&o.NONSECCHAN.Reg)&^(0x2)|value<<1)
}
func (o *EVSYS_Type) GetNONSECCHAN_CHANNEL1() uint32 {
	return (volatile.LoadUint32(&o.NONSECCHAN.Reg) & 0x2) >> 1
}
func (o *EVSYS_Type) SetNONSECCHAN_CHANNEL2(value uint32) {
	volatile.StoreUint32(&o.NONSECCHAN.Reg, volatile.LoadUint32(&o.NONSECCHAN.Reg)&^(0x4)|value<<2)
}
func (o *EVSYS_Type) GetNONSECCHAN_CHANNEL2() uint32 {
	return (volatile.LoadUint32(&o.NONSECCHAN.Reg) & 0x4) >> 2
}
func (o *EVSYS_Type) SetNONSECCHAN_CHANNEL3(value uint32) {
	volatile.StoreUint32(&o.NONSECCHAN.Reg, volatile.LoadUint32(&o.NONSECCHAN.Reg)&^(0x8)|value<<3)
}
func (o *EVSYS_Type) GetNONSECCHAN_CHANNEL3() uint32 {
	return (volatile.LoadUint32(&o.NONSECCHAN.Reg) & 0x8) >> 3
}
func (o *EVSYS_Type) SetNONSECCHAN_CHANNEL4(value uint32) {
	volatile.StoreUint32(&o.NONSECCHAN.Reg, volatile.LoadUint32(&o.NONSECCHAN.Reg)&^(0x10)|value<<4)
}
func (o *EVSYS_Type) GetNONSECCHAN_CHANNEL4() uint32 {
	return (volatile.LoadUint32(&o.NONSECCHAN.Reg) & 0x10) >> 4
}
func (o *EVSYS_Type) SetNONSECCHAN_CHANNEL5(value uint32) {
	volatile.StoreUint32(&o.NONSECCHAN.Reg, volatile.LoadUint32(&o.NONSECCHAN.Reg)&^(0x20)|value<<5)
}
func (o *EVSYS_Type) GetNONSECCHAN_CHANNEL5() uint32 {
	return (volatile.LoadUint32(&o.NONSECCHAN.Reg) & 0x20) >> 5
}
func (o *EVSYS_Type) SetNONSECCHAN_CHANNEL6(value uint32) {
	volatile.StoreUint32(&o.NONSECCHAN.Reg, volatile.LoadUint32(&o.NONSECCHAN.Reg)&^(0x40)|value<<6)
}
func (o *EVSYS_Type) GetNONSECCHAN_CHANNEL6() uint32 {
	return (volatile.LoadUint32(&o.NONSECCHAN.Reg) & 0x40) >> 6
}
func (o *EVSYS_Type) SetNONSECCHAN_CHANNEL7(value uint32) {
	volatile.StoreUint32(&o.NONSECCHAN.Reg, volatile.LoadUint32(&o.NONSECCHAN.Reg)&^(0x80)|value<<7)
}
func (o *EVSYS_Type) GetNONSECCHAN_CHANNEL7() uint32 {
	return (volatile.LoadUint32(&o.NONSECCHAN.Reg) & 0x80) >> 7
}

// EVSYS.NSCHKCHAN: Non-Secure Channels Check
func (o *EVSYS_Type) SetNSCHKCHAN_CHANNEL0(value uint32) {
	volatile.StoreUint32(&o.NSCHKCHAN.Reg, volatile.LoadUint32(&o.NSCHKCHAN.Reg)&^(0x1)|value)
}
func (o *EVSYS_Type) GetNSCHKCHAN_CHANNEL0() uint32 {
	return volatile.LoadUint32(&o.NSCHKCHAN.Reg) & 0x1
}
func (o *EVSYS_Type) SetNSCHKCHAN_CHANNEL1(value uint32) {
	volatile.StoreUint32(&o.NSCHKCHAN.Reg, volatile.LoadUint32(&o.NSCHKCHAN.Reg)&^(0x2)|value<<1)
}
func (o *EVSYS_Type) GetNSCHKCHAN_CHANNEL1() uint32 {
	return (volatile.LoadUint32(&o.NSCHKCHAN.Reg) & 0x2) >> 1
}
func (o *EVSYS_Type) SetNSCHKCHAN_CHANNEL2(value uint32) {
	volatile.StoreUint32(&o.NSCHKCHAN.Reg, volatile.LoadUint32(&o.NSCHKCHAN.Reg)&^(0x4)|value<<2)
}
func (o *EVSYS_Type) GetNSCHKCHAN_CHANNEL2() uint32 {
	return (volatile.LoadUint32(&o.NSCHKCHAN.Reg) & 0x4) >> 2
}
func (o *EVSYS_Type) SetNSCHKCHAN_CHANNEL3(value uint32) {
	volatile.StoreUint32(&o.NSCHKCHAN.Reg, volatile.LoadUint32(&o.NSCHKCHAN.Reg)&^(0x8)|value<<3)
}
func (o *EVSYS_Type) GetNSCHKCHAN_CHANNEL3() uint32 {
	return (volatile.LoadUint32(&o.NSCHKCHAN.Reg) & 0x8) >> 3
}
func (o *EVSYS_Type) SetNSCHKCHAN_CHANNEL4(value uint32) {
	volatile.StoreUint32(&o.NSCHKCHAN.Reg, volatile.LoadUint32(&o.NSCHKCHAN.Reg)&^(0x10)|value<<4)
}
func (o *EVSYS_Type) GetNSCHKCHAN_CHANNEL4() uint32 {
	return (volatile.LoadUint32(&o.NSCHKCHAN.Reg) & 0x10) >> 4
}
func (o *EVSYS_Type) SetNSCHKCHAN_CHANNEL5(value uint32) {
	volatile.StoreUint32(&o.NSCHKCHAN.Reg, volatile.LoadUint32(&o.NSCHKCHAN.Reg)&^(0x20)|value<<5)
}
func (o *EVSYS_Type) GetNSCHKCHAN_CHANNEL5() uint32 {
	return (volatile.LoadUint32(&o.NSCHKCHAN.Reg) & 0x20) >> 5
}
func (o *EVSYS_Type) SetNSCHKCHAN_CHANNEL6(value uint32) {
	volatile.StoreUint32(&o.NSCHKCHAN.Reg, volatile.LoadUint32(&o.NSCHKCHAN.Reg)&^(0x40)|value<<6)
}
func (o *EVSYS_Type) GetNSCHKCHAN_CHANNEL6() uint32 {
	return (volatile.LoadUint32(&o.NSCHKCHAN.Reg) & 0x40) >> 6
}
func (o *EVSYS_Type) SetNSCHKCHAN_CHANNEL7(value uint32) {
	volatile.StoreUint32(&o.NSCHKCHAN.Reg, volatile.LoadUint32(&o.NSCHKCHAN.Reg)&^(0x80)|value<<7)
}
func (o *EVSYS_Type) GetNSCHKCHAN_CHANNEL7() uint32 {
	return (volatile.LoadUint32(&o.NSCHKCHAN.Reg) & 0x80) >> 7
}

// EVSYS.NONSECUSER: Users Security Attribution
func (o *EVSYS_Type) SetNONSECUSER_USER0(idx int, value uint32) {
	volatile.StoreUint32(&o.NONSECUSER[idx].Reg, volatile.LoadUint32(&o.NONSECUSER[idx].Reg)&^(0x1)|value)
}
func (o *EVSYS_Type) GetNONSECUSER_USER0(idx int) uint32 {
	return volatile.LoadUint32(&o.NONSECUSER[idx].Reg) & 0x1
}
func (o *EVSYS_Type) SetNONSECUSER_USER1(idx int, value uint32) {
	volatile.StoreUint32(&o.NONSECUSER[idx].Reg, volatile.LoadUint32(&o.NONSECUSER[idx].Reg)&^(0x2)|value<<1)
}
func (o *EVSYS_Type) GetNONSECUSER_USER1(idx int) uint32 {
	return (volatile.LoadUint32(&o.NONSECUSER[idx].Reg) & 0x2) >> 1
}
func (o *EVSYS_Type) SetNONSECUSER_USER2(idx int, value uint32) {
	volatile.StoreUint32(&o.NONSECUSER[idx].Reg, volatile.LoadUint32(&o.NONSECUSER[idx].Reg)&^(0x4)|value<<2)
}
func (o *EVSYS_Type) GetNONSECUSER_USER2(idx int) uint32 {
	return (volatile.LoadUint32(&o.NONSECUSER[idx].Reg) & 0x4) >> 2
}
func (o *EVSYS_Type) SetNONSECUSER_USER3(idx int, value uint32) {
	volatile.StoreUint32(&o.NONSECUSER[idx].Reg, volatile.LoadUint32(&o.NONSECUSER[idx].Reg)&^(0x8)|value<<3)
}
func (o *EVSYS_Type) GetNONSECUSER_USER3(idx int) uint32 {
	return (volatile.LoadUint32(&o.NONSECUSER[idx].Reg) & 0x8) >> 3
}
func (o *EVSYS_Type) SetNONSECUSER_USER4(idx int, value uint32) {
	volatile.StoreUint32(&o.NONSECUSER[idx].Reg, volatile.LoadUint32(&o.NONSECUSER[idx].Reg)&^(0x10)|value<<4)
}
func (o *EVSYS_Type) GetNONSECUSER_USER4(idx int) uint32 {
	return (volatile.LoadUint32(&o.NONSECUSER[idx].Reg) & 0x10) >> 4
}
func (o *EVSYS_Type) SetNONSECUSER_USER5(idx int, value uint32) {
	volatile.StoreUint32(&o.NONSECUSER[idx].Reg, volatile.LoadUint32(&o.NONSECUSER[idx].Reg)&^(0x20)|value<<5)
}
func (o *EVSYS_Type) GetNONSECUSER_USER5(idx int) uint32 {
	return (volatile.LoadUint32(&o.NONSECUSER[idx].Reg) & 0x20) >> 5
}
func (o *EVSYS_Type) SetNONSECUSER_USER6(idx int, value uint32) {
	volatile.StoreUint32(&o.NONSECUSER[idx].Reg, volatile.LoadUint32(&o.NONSECUSER[idx].Reg)&^(0x40)|value<<6)
}
func (o *EVSYS_Type) GetNONSECUSER_USER6(idx int) uint32 {
	return (volatile.LoadUint32(&o.NONSECUSER[idx].Reg) & 0x40) >> 6
}
func (o *EVSYS_Type) SetNONSECUSER_USER7(idx int, value uint32) {
	volatile.StoreUint32(&o.NONSECUSER[idx].Reg, volatile.LoadUint32(&o.NONSECUSER[idx].Reg)&^(0x80)|value<<7)
}
func (o *EVSYS_Type) GetNONSECUSER_USER7(idx int) uint32 {
	return (volatile.LoadUint32(&o.NONSECUSER[idx].Reg) & 0x80) >> 7
}
func (o *EVSYS_Type) SetNONSECUSER_USER8(idx int, value uint32) {
	volatile.StoreUint32(&o.NONSECUSER[idx].Reg, volatile.LoadUint32(&o.NONSECUSER[idx].Reg)&^(0x100)|value<<8)
}
func (o *EVSYS_Type) GetNONSECUSER_USER8(idx int) uint32 {
	return (volatile.LoadUint32(&o.NONSECUSER[idx].Reg) & 0x100) >> 8
}
func (o *EVSYS_Type) SetNONSECUSER_USER9(idx int, value uint32) {
	volatile.StoreUint32(&o.NONSECUSER[idx].Reg, volatile.LoadUint32(&o.NONSECUSER[idx].Reg)&^(0x200)|value<<9)
}
func (o *EVSYS_Type) GetNONSECUSER_USER9(idx int) uint32 {
	return (volatile.LoadUint32(&o.NONSECUSER[idx].Reg) & 0x200) >> 9
}
func (o *EVSYS_Type) SetNONSECUSER_USER10(idx int, value uint32) {
	volatile.StoreUint32(&o.NONSECUSER[idx].Reg, volatile.LoadUint32(&o.NONSECUSER[idx].Reg)&^(0x400)|value<<10)
}
func (o *EVSYS_Type) GetNONSECUSER_USER10(idx int) uint32 {
	return (volatile.LoadUint32(&o.NONSECUSER[idx].Reg) & 0x400) >> 10
}
func (o *EVSYS_Type) SetNONSECUSER_USER11(idx int, value uint32) {
	volatile.StoreUint32(&o.NONSECUSER[idx].Reg, volatile.LoadUint32(&o.NONSECUSER[idx].Reg)&^(0x800)|value<<11)
}
func (o *EVSYS_Type) GetNONSECUSER_USER11(idx int) uint32 {
	return (volatile.LoadUint32(&o.NONSECUSER[idx].Reg) & 0x800) >> 11
}
func (o *EVSYS_Type) SetNONSECUSER_USER12(idx int, value uint32) {
	volatile.StoreUint32(&o.NONSECUSER[idx].Reg, volatile.LoadUint32(&o.NONSECUSER[idx].Reg)&^(0x1000)|value<<12)
}
func (o *EVSYS_Type) GetNONSECUSER_USER12(idx int) uint32 {
	return (volatile.LoadUint32(&o.NONSECUSER[idx].Reg) & 0x1000) >> 12
}
func (o *EVSYS_Type) SetNONSECUSER_USER13(idx int, value uint32) {
	volatile.StoreUint32(&o.NONSECUSER[idx].Reg, volatile.LoadUint32(&o.NONSECUSER[idx].Reg)&^(0x2000)|value<<13)
}
func (o *EVSYS_Type) GetNONSECUSER_USER13(idx int) uint32 {
	return (volatile.LoadUint32(&o.NONSECUSER[idx].Reg) & 0x2000) >> 13
}
func (o *EVSYS_Type) SetNONSECUSER_USER14(idx int, value uint32) {
	volatile.StoreUint32(&o.NONSECUSER[idx].Reg, volatile.LoadUint32(&o.NONSECUSER[idx].Reg)&^(0x4000)|value<<14)
}
func (o *EVSYS_Type) GetNONSECUSER_USER14(idx int) uint32 {
	return (volatile.LoadUint32(&o.NONSECUSER[idx].Reg) & 0x4000) >> 14
}
func (o *EVSYS_Type) SetNONSECUSER_USER15(idx int, value uint32) {
	volatile.StoreUint32(&o.NONSECUSER[idx].Reg, volatile.LoadUint32(&o.NONSECUSER[idx].Reg)&^(0x8000)|value<<15)
}
func (o *EVSYS_Type) GetNONSECUSER_USER15(idx int) uint32 {
	return (volatile.LoadUint32(&o.NONSECUSER[idx].Reg) & 0x8000) >> 15
}
func (o *EVSYS_Type) SetNONSECUSER_USER16(idx int, value uint32) {
	volatile.StoreUint32(&o.NONSECUSER[idx].Reg, volatile.LoadUint32(&o.NONSECUSER[idx].Reg)&^(0x10000)|value<<16)
}
func (o *EVSYS_Type) GetNONSECUSER_USER16(idx int) uint32 {
	return (volatile.LoadUint32(&o.NONSECUSER[idx].Reg) & 0x10000) >> 16
}
func (o *EVSYS_Type) SetNONSECUSER_USER17(idx int, value uint32) {
	volatile.StoreUint32(&o.NONSECUSER[idx].Reg, volatile.LoadUint32(&o.NONSECUSER[idx].Reg)&^(0x20000)|value<<17)
}
func (o *EVSYS_Type) GetNONSECUSER_USER17(idx int) uint32 {
	return (volatile.LoadUint32(&o.NONSECUSER[idx].Reg) & 0x20000) >> 17
}
func (o *EVSYS_Type) SetNONSECUSER_USER18(idx int, value uint32) {
	volatile.StoreUint32(&o.NONSECUSER[idx].Reg, volatile.LoadUint32(&o.NONSECUSER[idx].Reg)&^(0x40000)|value<<18)
}
func (o *EVSYS_Type) GetNONSECUSER_USER18(idx int) uint32 {
	return (volatile.LoadUint32(&o.NONSECUSER[idx].Reg) & 0x40000) >> 18
}
func (o *EVSYS_Type) SetNONSECUSER_USER19(idx int, value uint32) {
	volatile.StoreUint32(&o.NONSECUSER[idx].Reg, volatile.LoadUint32(&o.NONSECUSER[idx].Reg)&^(0x80000)|value<<19)
}
func (o *EVSYS_Type) GetNONSECUSER_USER19(idx int) uint32 {
	return (volatile.LoadUint32(&o.NONSECUSER[idx].Reg) & 0x80000) >> 19
}
func (o *EVSYS_Type) SetNONSECUSER_USER20(idx int, value uint32) {
	volatile.StoreUint32(&o.NONSECUSER[idx].Reg, volatile.LoadUint32(&o.NONSECUSER[idx].Reg)&^(0x100000)|value<<20)
}
func (o *EVSYS_Type) GetNONSECUSER_USER20(idx int) uint32 {
	return (volatile.LoadUint32(&o.NONSECUSER[idx].Reg) & 0x100000) >> 20
}
func (o *EVSYS_Type) SetNONSECUSER_USER21(idx int, value uint32) {
	volatile.StoreUint32(&o.NONSECUSER[idx].Reg, volatile.LoadUint32(&o.NONSECUSER[idx].Reg)&^(0x200000)|value<<21)
}
func (o *EVSYS_Type) GetNONSECUSER_USER21(idx int) uint32 {
	return (volatile.LoadUint32(&o.NONSECUSER[idx].Reg) & 0x200000) >> 21
}
func (o *EVSYS_Type) SetNONSECUSER_USER22(idx int, value uint32) {
	volatile.StoreUint32(&o.NONSECUSER[idx].Reg, volatile.LoadUint32(&o.NONSECUSER[idx].Reg)&^(0x400000)|value<<22)
}
func (o *EVSYS_Type) GetNONSECUSER_USER22(idx int) uint32 {
	return (volatile.LoadUint32(&o.NONSECUSER[idx].Reg) & 0x400000) >> 22
}

// EVSYS.NSCHKUSER: Non-Secure Users Check
func (o *EVSYS_Type) SetNSCHKUSER_USER0(idx int, value uint32) {
	volatile.StoreUint32(&o.NSCHKUSER[idx].Reg, volatile.LoadUint32(&o.NSCHKUSER[idx].Reg)&^(0x1)|value)
}
func (o *EVSYS_Type) GetNSCHKUSER_USER0(idx int) uint32 {
	return volatile.LoadUint32(&o.NSCHKUSER[idx].Reg) & 0x1
}
func (o *EVSYS_Type) SetNSCHKUSER_USER1(idx int, value uint32) {
	volatile.StoreUint32(&o.NSCHKUSER[idx].Reg, volatile.LoadUint32(&o.NSCHKUSER[idx].Reg)&^(0x2)|value<<1)
}
func (o *EVSYS_Type) GetNSCHKUSER_USER1(idx int) uint32 {
	return (volatile.LoadUint32(&o.NSCHKUSER[idx].Reg) & 0x2) >> 1
}
func (o *EVSYS_Type) SetNSCHKUSER_USER2(idx int, value uint32) {
	volatile.StoreUint32(&o.NSCHKUSER[idx].Reg, volatile.LoadUint32(&o.NSCHKUSER[idx].Reg)&^(0x4)|value<<2)
}
func (o *EVSYS_Type) GetNSCHKUSER_USER2(idx int) uint32 {
	return (volatile.LoadUint32(&o.NSCHKUSER[idx].Reg) & 0x4) >> 2
}
func (o *EVSYS_Type) SetNSCHKUSER_USER3(idx int, value uint32) {
	volatile.StoreUint32(&o.NSCHKUSER[idx].Reg, volatile.LoadUint32(&o.NSCHKUSER[idx].Reg)&^(0x8)|value<<3)
}
func (o *EVSYS_Type) GetNSCHKUSER_USER3(idx int) uint32 {
	return (volatile.LoadUint32(&o.NSCHKUSER[idx].Reg) & 0x8) >> 3
}
func (o *EVSYS_Type) SetNSCHKUSER_USER4(idx int, value uint32) {
	volatile.StoreUint32(&o.NSCHKUSER[idx].Reg, volatile.LoadUint32(&o.NSCHKUSER[idx].Reg)&^(0x10)|value<<4)
}
func (o *EVSYS_Type) GetNSCHKUSER_USER4(idx int) uint32 {
	return (volatile.LoadUint32(&o.NSCHKUSER[idx].Reg) & 0x10) >> 4
}
func (o *EVSYS_Type) SetNSCHKUSER_USER5(idx int, value uint32) {
	volatile.StoreUint32(&o.NSCHKUSER[idx].Reg, volatile.LoadUint32(&o.NSCHKUSER[idx].Reg)&^(0x20)|value<<5)
}
func (o *EVSYS_Type) GetNSCHKUSER_USER5(idx int) uint32 {
	return (volatile.LoadUint32(&o.NSCHKUSER[idx].Reg) & 0x20) >> 5
}
func (o *EVSYS_Type) SetNSCHKUSER_USER6(idx int, value uint32) {
	volatile.StoreUint32(&o.NSCHKUSER[idx].Reg, volatile.LoadUint32(&o.NSCHKUSER[idx].Reg)&^(0x40)|value<<6)
}
func (o *EVSYS_Type) GetNSCHKUSER_USER6(idx int) uint32 {
	return (volatile.LoadUint32(&o.NSCHKUSER[idx].Reg) & 0x40) >> 6
}
func (o *EVSYS_Type) SetNSCHKUSER_USER7(idx int, value uint32) {
	volatile.StoreUint32(&o.NSCHKUSER[idx].Reg, volatile.LoadUint32(&o.NSCHKUSER[idx].Reg)&^(0x80)|value<<7)
}
func (o *EVSYS_Type) GetNSCHKUSER_USER7(idx int) uint32 {
	return (volatile.LoadUint32(&o.NSCHKUSER[idx].Reg) & 0x80) >> 7
}
func (o *EVSYS_Type) SetNSCHKUSER_USER8(idx int, value uint32) {
	volatile.StoreUint32(&o.NSCHKUSER[idx].Reg, volatile.LoadUint32(&o.NSCHKUSER[idx].Reg)&^(0x100)|value<<8)
}
func (o *EVSYS_Type) GetNSCHKUSER_USER8(idx int) uint32 {
	return (volatile.LoadUint32(&o.NSCHKUSER[idx].Reg) & 0x100) >> 8
}
func (o *EVSYS_Type) SetNSCHKUSER_USER9(idx int, value uint32) {
	volatile.StoreUint32(&o.NSCHKUSER[idx].Reg, volatile.LoadUint32(&o.NSCHKUSER[idx].Reg)&^(0x200)|value<<9)
}
func (o *EVSYS_Type) GetNSCHKUSER_USER9(idx int) uint32 {
	return (volatile.LoadUint32(&o.NSCHKUSER[idx].Reg) & 0x200) >> 9
}
func (o *EVSYS_Type) SetNSCHKUSER_USER10(idx int, value uint32) {
	volatile.StoreUint32(&o.NSCHKUSER[idx].Reg, volatile.LoadUint32(&o.NSCHKUSER[idx].Reg)&^(0x400)|value<<10)
}
func (o *EVSYS_Type) GetNSCHKUSER_USER10(idx int) uint32 {
	return (volatile.LoadUint32(&o.NSCHKUSER[idx].Reg) & 0x400) >> 10
}
func (o *EVSYS_Type) SetNSCHKUSER_USER11(idx int, value uint32) {
	volatile.StoreUint32(&o.NSCHKUSER[idx].Reg, volatile.LoadUint32(&o.NSCHKUSER[idx].Reg)&^(0x800)|value<<11)
}
func (o *EVSYS_Type) GetNSCHKUSER_USER11(idx int) uint32 {
	return (volatile.LoadUint32(&o.NSCHKUSER[idx].Reg) & 0x800) >> 11
}
func (o *EVSYS_Type) SetNSCHKUSER_USER12(idx int, value uint32) {
	volatile.StoreUint32(&o.NSCHKUSER[idx].Reg, volatile.LoadUint32(&o.NSCHKUSER[idx].Reg)&^(0x1000)|value<<12)
}
func (o *EVSYS_Type) GetNSCHKUSER_USER12(idx int) uint32 {
	return (volatile.LoadUint32(&o.NSCHKUSER[idx].Reg) & 0x1000) >> 12
}
func (o *EVSYS_Type) SetNSCHKUSER_USER13(idx int, value uint32) {
	volatile.StoreUint32(&o.NSCHKUSER[idx].Reg, volatile.LoadUint32(&o.NSCHKUSER[idx].Reg)&^(0x2000)|value<<13)
}
func (o *EVSYS_Type) GetNSCHKUSER_USER13(idx int) uint32 {
	return (volatile.LoadUint32(&o.NSCHKUSER[idx].Reg) & 0x2000) >> 13
}
func (o *EVSYS_Type) SetNSCHKUSER_USER14(idx int, value uint32) {
	volatile.StoreUint32(&o.NSCHKUSER[idx].Reg, volatile.LoadUint32(&o.NSCHKUSER[idx].Reg)&^(0x4000)|value<<14)
}
func (o *EVSYS_Type) GetNSCHKUSER_USER14(idx int) uint32 {
	return (volatile.LoadUint32(&o.NSCHKUSER[idx].Reg) & 0x4000) >> 14
}
func (o *EVSYS_Type) SetNSCHKUSER_USER15(idx int, value uint32) {
	volatile.StoreUint32(&o.NSCHKUSER[idx].Reg, volatile.LoadUint32(&o.NSCHKUSER[idx].Reg)&^(0x8000)|value<<15)
}
func (o *EVSYS_Type) GetNSCHKUSER_USER15(idx int) uint32 {
	return (volatile.LoadUint32(&o.NSCHKUSER[idx].Reg) & 0x8000) >> 15
}
func (o *EVSYS_Type) SetNSCHKUSER_USER16(idx int, value uint32) {
	volatile.StoreUint32(&o.NSCHKUSER[idx].Reg, volatile.LoadUint32(&o.NSCHKUSER[idx].Reg)&^(0x10000)|value<<16)
}
func (o *EVSYS_Type) GetNSCHKUSER_USER16(idx int) uint32 {
	return (volatile.LoadUint32(&o.NSCHKUSER[idx].Reg) & 0x10000) >> 16
}
func (o *EVSYS_Type) SetNSCHKUSER_USER17(idx int, value uint32) {
	volatile.StoreUint32(&o.NSCHKUSER[idx].Reg, volatile.LoadUint32(&o.NSCHKUSER[idx].Reg)&^(0x20000)|value<<17)
}
func (o *EVSYS_Type) GetNSCHKUSER_USER17(idx int) uint32 {
	return (volatile.LoadUint32(&o.NSCHKUSER[idx].Reg) & 0x20000) >> 17
}
func (o *EVSYS_Type) SetNSCHKUSER_USER18(idx int, value uint32) {
	volatile.StoreUint32(&o.NSCHKUSER[idx].Reg, volatile.LoadUint32(&o.NSCHKUSER[idx].Reg)&^(0x40000)|value<<18)
}
func (o *EVSYS_Type) GetNSCHKUSER_USER18(idx int) uint32 {
	return (volatile.LoadUint32(&o.NSCHKUSER[idx].Reg) & 0x40000) >> 18
}
func (o *EVSYS_Type) SetNSCHKUSER_USER19(idx int, value uint32) {
	volatile.StoreUint32(&o.NSCHKUSER[idx].Reg, volatile.LoadUint32(&o.NSCHKUSER[idx].Reg)&^(0x80000)|value<<19)
}
func (o *EVSYS_Type) GetNSCHKUSER_USER19(idx int) uint32 {
	return (volatile.LoadUint32(&o.NSCHKUSER[idx].Reg) & 0x80000) >> 19
}
func (o *EVSYS_Type) SetNSCHKUSER_USER20(idx int, value uint32) {
	volatile.StoreUint32(&o.NSCHKUSER[idx].Reg, volatile.LoadUint32(&o.NSCHKUSER[idx].Reg)&^(0x100000)|value<<20)
}
func (o *EVSYS_Type) GetNSCHKUSER_USER20(idx int) uint32 {
	return (volatile.LoadUint32(&o.NSCHKUSER[idx].Reg) & 0x100000) >> 20
}
func (o *EVSYS_Type) SetNSCHKUSER_USER21(idx int, value uint32) {
	volatile.StoreUint32(&o.NSCHKUSER[idx].Reg, volatile.LoadUint32(&o.NSCHKUSER[idx].Reg)&^(0x200000)|value<<21)
}
func (o *EVSYS_Type) GetNSCHKUSER_USER21(idx int) uint32 {
	return (volatile.LoadUint32(&o.NSCHKUSER[idx].Reg) & 0x200000) >> 21
}
func (o *EVSYS_Type) SetNSCHKUSER_USER22(idx int, value uint32) {
	volatile.StoreUint32(&o.NSCHKUSER[idx].Reg, volatile.LoadUint32(&o.NSCHKUSER[idx].Reg)&^(0x400000)|value<<22)
}
func (o *EVSYS_Type) GetNSCHKUSER_USER22(idx int) uint32 {
	return (volatile.LoadUint32(&o.NSCHKUSER[idx].Reg) & 0x400000) >> 22
}

type EVSYS_CHANNEL_Type struct {
	CHANNEL    volatile.Register32 // 0x20
	CHINTENCLR volatile.Register8  // 0x24
	CHINTENSET volatile.Register8  // 0x25
	CHINTFLAG  volatile.Register8  // 0x26
	CHSTATUS   volatile.Register8  // 0x27
}

// EVSYS_CHANNEL.CHANNEL: Channel n Control
func (o *EVSYS_CHANNEL_Type) SetCHANNEL_EVGEN(value uint32) {
	volatile.StoreUint32(&o.CHANNEL.Reg, volatile.LoadUint32(&o.CHANNEL.Reg)&^(0x3f)|value)
}
func (o *EVSYS_CHANNEL_Type) GetCHANNEL_EVGEN() uint32 {
	return volatile.LoadUint32(&o.CHANNEL.Reg) & 0x3f
}
func (o *EVSYS_CHANNEL_Type) SetCHANNEL_PATH(value uint32) {
	volatile.StoreUint32(&o.CHANNEL.Reg, volatile.LoadUint32(&o.CHANNEL.Reg)&^(0x300)|value<<8)
}
func (o *EVSYS_CHANNEL_Type) GetCHANNEL_PATH() uint32 {
	return (volatile.LoadUint32(&o.CHANNEL.Reg) & 0x300) >> 8
}
func (o *EVSYS_CHANNEL_Type) SetCHANNEL_EDGSEL(value uint32) {
	volatile.StoreUint32(&o.CHANNEL.Reg, volatile.LoadUint32(&o.CHANNEL.Reg)&^(0xc00)|value<<10)
}
func (o *EVSYS_CHANNEL_Type) GetCHANNEL_EDGSEL() uint32 {
	return (volatile.LoadUint32(&o.CHANNEL.Reg) & 0xc00) >> 10
}
func (o *EVSYS_CHANNEL_Type) SetCHANNEL_RUNSTDBY(value uint32) {
	volatile.StoreUint32(&o.CHANNEL.Reg, volatile.LoadUint32(&o.CHANNEL.Reg)&^(0x4000)|value<<14)
}
func (o *EVSYS_CHANNEL_Type) GetCHANNEL_RUNSTDBY() uint32 {
	return (volatile.LoadUint32(&o.CHANNEL.Reg) & 0x4000) >> 14
}
func (o *EVSYS_CHANNEL_Type) SetCHANNEL_ONDEMAND(value uint32) {
	volatile.StoreUint32(&o.CHANNEL.Reg, volatile.LoadUint32(&o.CHANNEL.Reg)&^(0x8000)|value<<15)
}
func (o *EVSYS_CHANNEL_Type) GetCHANNEL_ONDEMAND() uint32 {
	return (volatile.LoadUint32(&o.CHANNEL.Reg) & 0x8000) >> 15
}

// EVSYS_CHANNEL.CHINTENCLR: Channel n Interrupt Enable Clear
func (o *EVSYS_CHANNEL_Type) SetCHINTENCLR_OVR(value uint8) {
	volatile.StoreUint8(&o.CHINTENCLR.Reg, volatile.LoadUint8(&o.CHINTENCLR.Reg)&^(0x1)|value)
}
func (o *EVSYS_CHANNEL_Type) GetCHINTENCLR_OVR() uint8 {
	return volatile.LoadUint8(&o.CHINTENCLR.Reg) & 0x1
}
func (o *EVSYS_CHANNEL_Type) SetCHINTENCLR_EVD(value uint8) {
	volatile.StoreUint8(&o.CHINTENCLR.Reg, volatile.LoadUint8(&o.CHINTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *EVSYS_CHANNEL_Type) GetCHINTENCLR_EVD() uint8 {
	return (volatile.LoadUint8(&o.CHINTENCLR.Reg) & 0x2) >> 1
}

// EVSYS_CHANNEL.CHINTENSET: Channel n Interrupt Enable Set
func (o *EVSYS_CHANNEL_Type) SetCHINTENSET_OVR(value uint8) {
	volatile.StoreUint8(&o.CHINTENSET.Reg, volatile.LoadUint8(&o.CHINTENSET.Reg)&^(0x1)|value)
}
func (o *EVSYS_CHANNEL_Type) GetCHINTENSET_OVR() uint8 {
	return volatile.LoadUint8(&o.CHINTENSET.Reg) & 0x1
}
func (o *EVSYS_CHANNEL_Type) SetCHINTENSET_EVD(value uint8) {
	volatile.StoreUint8(&o.CHINTENSET.Reg, volatile.LoadUint8(&o.CHINTENSET.Reg)&^(0x2)|value<<1)
}
func (o *EVSYS_CHANNEL_Type) GetCHINTENSET_EVD() uint8 {
	return (volatile.LoadUint8(&o.CHINTENSET.Reg) & 0x2) >> 1
}

// EVSYS_CHANNEL.CHINTFLAG: Channel n Interrupt Flag Status and Clear
func (o *EVSYS_CHANNEL_Type) SetCHINTFLAG_OVR(value uint8) {
	volatile.StoreUint8(&o.CHINTFLAG.Reg, volatile.LoadUint8(&o.CHINTFLAG.Reg)&^(0x1)|value)
}
func (o *EVSYS_CHANNEL_Type) GetCHINTFLAG_OVR() uint8 {
	return volatile.LoadUint8(&o.CHINTFLAG.Reg) & 0x1
}
func (o *EVSYS_CHANNEL_Type) SetCHINTFLAG_EVD(value uint8) {
	volatile.StoreUint8(&o.CHINTFLAG.Reg, volatile.LoadUint8(&o.CHINTFLAG.Reg)&^(0x2)|value<<1)
}
func (o *EVSYS_CHANNEL_Type) GetCHINTFLAG_EVD() uint8 {
	return (volatile.LoadUint8(&o.CHINTFLAG.Reg) & 0x2) >> 1
}

// EVSYS_CHANNEL.CHSTATUS: Channel n Status
func (o *EVSYS_CHANNEL_Type) SetCHSTATUS_RDYUSR(value uint8) {
	volatile.StoreUint8(&o.CHSTATUS.Reg, volatile.LoadUint8(&o.CHSTATUS.Reg)&^(0x1)|value)
}
func (o *EVSYS_CHANNEL_Type) GetCHSTATUS_RDYUSR() uint8 {
	return volatile.LoadUint8(&o.CHSTATUS.Reg) & 0x1
}
func (o *EVSYS_CHANNEL_Type) SetCHSTATUS_BUSYCH(value uint8) {
	volatile.StoreUint8(&o.CHSTATUS.Reg, volatile.LoadUint8(&o.CHSTATUS.Reg)&^(0x2)|value<<1)
}
func (o *EVSYS_CHANNEL_Type) GetCHSTATUS_BUSYCH() uint8 {
	return (volatile.LoadUint8(&o.CHSTATUS.Reg) & 0x2) >> 1
}

// Frequency Meter
type FREQM_Type struct {
	CTRLA    volatile.Register8  // 0x0
	CTRLB    volatile.Register8  // 0x1
	CFGA     volatile.Register16 // 0x2
	_        [4]byte
	INTENCLR volatile.Register8  // 0x8
	INTENSET volatile.Register8  // 0x9
	INTFLAG  volatile.Register8  // 0xA
	STATUS   volatile.Register8  // 0xB
	SYNCBUSY volatile.Register32 // 0xC
	VALUE    volatile.Register32 // 0x10
}

// FREQM.CTRLA: Control A Register
func (o *FREQM_Type) SetCTRLA_SWRST(value uint8) {
	volatile.StoreUint8(&o.CTRLA.Reg, volatile.LoadUint8(&o.CTRLA.Reg)&^(0x1)|value)
}
func (o *FREQM_Type) GetCTRLA_SWRST() uint8 {
	return volatile.LoadUint8(&o.CTRLA.Reg) & 0x1
}
func (o *FREQM_Type) SetCTRLA_ENABLE(value uint8) {
	volatile.StoreUint8(&o.CTRLA.Reg, volatile.LoadUint8(&o.CTRLA.Reg)&^(0x2)|value<<1)
}
func (o *FREQM_Type) GetCTRLA_ENABLE() uint8 {
	return (volatile.LoadUint8(&o.CTRLA.Reg) & 0x2) >> 1
}

// FREQM.CTRLB: Control B Register
func (o *FREQM_Type) SetCTRLB_START(value uint8) {
	volatile.StoreUint8(&o.CTRLB.Reg, volatile.LoadUint8(&o.CTRLB.Reg)&^(0x1)|value)
}
func (o *FREQM_Type) GetCTRLB_START() uint8 {
	return volatile.LoadUint8(&o.CTRLB.Reg) & 0x1
}

// FREQM.CFGA: Config A register
func (o *FREQM_Type) SetCFGA_REFNUM(value uint16) {
	volatile.StoreUint16(&o.CFGA.Reg, volatile.LoadUint16(&o.CFGA.Reg)&^(0xff)|value)
}
func (o *FREQM_Type) GetCFGA_REFNUM() uint16 {
	return volatile.LoadUint16(&o.CFGA.Reg) & 0xff
}
func (o *FREQM_Type) SetCFGA_DIVREF(value uint16) {
	volatile.StoreUint16(&o.CFGA.Reg, volatile.LoadUint16(&o.CFGA.Reg)&^(0x8000)|value<<15)
}
func (o *FREQM_Type) GetCFGA_DIVREF() uint16 {
	return (volatile.LoadUint16(&o.CFGA.Reg) & 0x8000) >> 15
}

// FREQM.INTENCLR: Interrupt Enable Clear Register
func (o *FREQM_Type) SetINTENCLR_DONE(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *FREQM_Type) GetINTENCLR_DONE() uint8 {
	return volatile.LoadUint8(&o.INTENCLR.Reg) & 0x1
}

// FREQM.INTENSET: Interrupt Enable Set Register
func (o *FREQM_Type) SetINTENSET_DONE(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *FREQM_Type) GetINTENSET_DONE() uint8 {
	return volatile.LoadUint8(&o.INTENSET.Reg) & 0x1
}

// FREQM.INTFLAG: Interrupt Flag Register
func (o *FREQM_Type) SetINTFLAG_DONE(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x1)|value)
}
func (o *FREQM_Type) GetINTFLAG_DONE() uint8 {
	return volatile.LoadUint8(&o.INTFLAG.Reg) & 0x1
}

// FREQM.STATUS: Status Register
func (o *FREQM_Type) SetSTATUS_BUSY(value uint8) {
	volatile.StoreUint8(&o.STATUS.Reg, volatile.LoadUint8(&o.STATUS.Reg)&^(0x1)|value)
}
func (o *FREQM_Type) GetSTATUS_BUSY() uint8 {
	return volatile.LoadUint8(&o.STATUS.Reg) & 0x1
}
func (o *FREQM_Type) SetSTATUS_OVF(value uint8) {
	volatile.StoreUint8(&o.STATUS.Reg, volatile.LoadUint8(&o.STATUS.Reg)&^(0x2)|value<<1)
}
func (o *FREQM_Type) GetSTATUS_OVF() uint8 {
	return (volatile.LoadUint8(&o.STATUS.Reg) & 0x2) >> 1
}

// FREQM.SYNCBUSY: Synchronization Busy Register
func (o *FREQM_Type) SetSYNCBUSY_SWRST(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x1)|value)
}
func (o *FREQM_Type) GetSYNCBUSY_SWRST() uint32 {
	return volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x1
}
func (o *FREQM_Type) SetSYNCBUSY_ENABLE(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x2)|value<<1)
}
func (o *FREQM_Type) GetSYNCBUSY_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x2) >> 1
}

// FREQM.VALUE: Count Value Register
func (o *FREQM_Type) SetVALUE(value uint32) {
	volatile.StoreUint32(&o.VALUE.Reg, volatile.LoadUint32(&o.VALUE.Reg)&^(0xffffff)|value)
}
func (o *FREQM_Type) GetVALUE() uint32 {
	return volatile.LoadUint32(&o.VALUE.Reg) & 0xffffff
}

// Generic Clock Generator
type GCLK_Type struct {
	CTRLA    volatile.Register8 // 0x0
	_        [3]byte
	SYNCBUSY volatile.Register32 // 0x4
	_        [24]byte
	GENCTRL  [5]volatile.Register32 // 0x20
	_        [76]byte
	PCHCTRL  [21]volatile.Register32 // 0x80
}

// GCLK.CTRLA: Control
func (o *GCLK_Type) SetCTRLA_SWRST(value uint8) {
	volatile.StoreUint8(&o.CTRLA.Reg, volatile.LoadUint8(&o.CTRLA.Reg)&^(0x1)|value)
}
func (o *GCLK_Type) GetCTRLA_SWRST() uint8 {
	return volatile.LoadUint8(&o.CTRLA.Reg) & 0x1
}

// GCLK.SYNCBUSY: Synchronization Busy
func (o *GCLK_Type) SetSYNCBUSY_SWRST(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x1)|value)
}
func (o *GCLK_Type) GetSYNCBUSY_SWRST() uint32 {
	return volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x1
}
func (o *GCLK_Type) SetSYNCBUSY_GENCTRL0(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x4)|value<<2)
}
func (o *GCLK_Type) GetSYNCBUSY_GENCTRL0() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x4) >> 2
}
func (o *GCLK_Type) SetSYNCBUSY_GENCTRL1(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x8)|value<<3)
}
func (o *GCLK_Type) GetSYNCBUSY_GENCTRL1() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x8) >> 3
}
func (o *GCLK_Type) SetSYNCBUSY_GENCTRL2(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x10)|value<<4)
}
func (o *GCLK_Type) GetSYNCBUSY_GENCTRL2() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x10) >> 4
}
func (o *GCLK_Type) SetSYNCBUSY_GENCTRL3(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x20)|value<<5)
}
func (o *GCLK_Type) GetSYNCBUSY_GENCTRL3() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x20) >> 5
}
func (o *GCLK_Type) SetSYNCBUSY_GENCTRL4(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x40)|value<<6)
}
func (o *GCLK_Type) GetSYNCBUSY_GENCTRL4() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x40) >> 6
}

// GCLK.GENCTRL: Generic Clock Generator Control
func (o *GCLK_Type) SetGENCTRL_SRC(idx int, value uint32) {
	volatile.StoreUint32(&o.GENCTRL[idx].Reg, volatile.LoadUint32(&o.GENCTRL[idx].Reg)&^(0x7)|value)
}
func (o *GCLK_Type) GetGENCTRL_SRC(idx int) uint32 {
	return volatile.LoadUint32(&o.GENCTRL[idx].Reg) & 0x7
}
func (o *GCLK_Type) SetGENCTRL_GENEN(idx int, value uint32) {
	volatile.StoreUint32(&o.GENCTRL[idx].Reg, volatile.LoadUint32(&o.GENCTRL[idx].Reg)&^(0x100)|value<<8)
}
func (o *GCLK_Type) GetGENCTRL_GENEN(idx int) uint32 {
	return (volatile.LoadUint32(&o.GENCTRL[idx].Reg) & 0x100) >> 8
}
func (o *GCLK_Type) SetGENCTRL_IDC(idx int, value uint32) {
	volatile.StoreUint32(&o.GENCTRL[idx].Reg, volatile.LoadUint32(&o.GENCTRL[idx].Reg)&^(0x200)|value<<9)
}
func (o *GCLK_Type) GetGENCTRL_IDC(idx int) uint32 {
	return (volatile.LoadUint32(&o.GENCTRL[idx].Reg) & 0x200) >> 9
}
func (o *GCLK_Type) SetGENCTRL_OOV(idx int, value uint32) {
	volatile.StoreUint32(&o.GENCTRL[idx].Reg, volatile.LoadUint32(&o.GENCTRL[idx].Reg)&^(0x400)|value<<10)
}
func (o *GCLK_Type) GetGENCTRL_OOV(idx int) uint32 {
	return (volatile.LoadUint32(&o.GENCTRL[idx].Reg) & 0x400) >> 10
}
func (o *GCLK_Type) SetGENCTRL_OE(idx int, value uint32) {
	volatile.StoreUint32(&o.GENCTRL[idx].Reg, volatile.LoadUint32(&o.GENCTRL[idx].Reg)&^(0x800)|value<<11)
}
func (o *GCLK_Type) GetGENCTRL_OE(idx int) uint32 {
	return (volatile.LoadUint32(&o.GENCTRL[idx].Reg) & 0x800) >> 11
}
func (o *GCLK_Type) SetGENCTRL_DIVSEL(idx int, value uint32) {
	volatile.StoreUint32(&o.GENCTRL[idx].Reg, volatile.LoadUint32(&o.GENCTRL[idx].Reg)&^(0x1000)|value<<12)
}
func (o *GCLK_Type) GetGENCTRL_DIVSEL(idx int) uint32 {
	return (volatile.LoadUint32(&o.GENCTRL[idx].Reg) & 0x1000) >> 12
}
func (o *GCLK_Type) SetGENCTRL_RUNSTDBY(idx int, value uint32) {
	volatile.StoreUint32(&o.GENCTRL[idx].Reg, volatile.LoadUint32(&o.GENCTRL[idx].Reg)&^(0x2000)|value<<13)
}
func (o *GCLK_Type) GetGENCTRL_RUNSTDBY(idx int) uint32 {
	return (volatile.LoadUint32(&o.GENCTRL[idx].Reg) & 0x2000) >> 13
}
func (o *GCLK_Type) SetGENCTRL_DIV(idx int, value uint32) {
	volatile.StoreUint32(&o.GENCTRL[idx].Reg, volatile.LoadUint32(&o.GENCTRL[idx].Reg)&^(0xffff0000)|value<<16)
}
func (o *GCLK_Type) GetGENCTRL_DIV(idx int) uint32 {
	return (volatile.LoadUint32(&o.GENCTRL[idx].Reg) & 0xffff0000) >> 16
}

// GCLK.PCHCTRL: Peripheral Clock Control
func (o *GCLK_Type) SetPCHCTRL_GEN(idx int, value uint32) {
	volatile.StoreUint32(&o.PCHCTRL[idx].Reg, volatile.LoadUint32(&o.PCHCTRL[idx].Reg)&^(0x7)|value)
}
func (o *GCLK_Type) GetPCHCTRL_GEN(idx int) uint32 {
	return volatile.LoadUint32(&o.PCHCTRL[idx].Reg) & 0x7
}
func (o *GCLK_Type) SetPCHCTRL_CHEN(idx int, value uint32) {
	volatile.StoreUint32(&o.PCHCTRL[idx].Reg, volatile.LoadUint32(&o.PCHCTRL[idx].Reg)&^(0x40)|value<<6)
}
func (o *GCLK_Type) GetPCHCTRL_CHEN(idx int) uint32 {
	return (volatile.LoadUint32(&o.PCHCTRL[idx].Reg) & 0x40) >> 6
}
func (o *GCLK_Type) SetPCHCTRL_WRTLOCK(idx int, value uint32) {
	volatile.StoreUint32(&o.PCHCTRL[idx].Reg, volatile.LoadUint32(&o.PCHCTRL[idx].Reg)&^(0x80)|value<<7)
}
func (o *GCLK_Type) GetPCHCTRL_WRTLOCK(idx int) uint32 {
	return (volatile.LoadUint32(&o.PCHCTRL[idx].Reg) & 0x80) >> 7
}

// Implementation Defined Attribution Unit
type IDAU_Type struct {
	_       byte
	SECCTRL volatile.Register8 // 0x1
	_       [2]byte
	SCFGB   volatile.Register32 // 0x4
	SCFGA   volatile.Register32 // 0x8
	SCFGR   volatile.Register8  // 0xC
}

// IDAU.SECCTRL: SECCTRL
func (o *IDAU_Type) SetSECCTRL_RXN(value uint8) {
	volatile.StoreUint8(&o.SECCTRL.Reg, volatile.LoadUint8(&o.SECCTRL.Reg)&^(0x4)|value<<2)
}
func (o *IDAU_Type) GetSECCTRL_RXN() uint8 {
	return (volatile.LoadUint8(&o.SECCTRL.Reg) & 0x4) >> 2
}

// IDAU.SCFGB: SCFGB
func (o *IDAU_Type) SetSCFGB_BS(value uint32) {
	volatile.StoreUint32(&o.SCFGB.Reg, volatile.LoadUint32(&o.SCFGB.Reg)&^(0xff)|value)
}
func (o *IDAU_Type) GetSCFGB_BS() uint32 {
	return volatile.LoadUint32(&o.SCFGB.Reg) & 0xff
}
func (o *IDAU_Type) SetSCFGB_BNSC(value uint32) {
	volatile.StoreUint32(&o.SCFGB.Reg, volatile.LoadUint32(&o.SCFGB.Reg)&^(0x3f00)|value<<8)
}
func (o *IDAU_Type) GetSCFGB_BNSC() uint32 {
	return (volatile.LoadUint32(&o.SCFGB.Reg) & 0x3f00) >> 8
}
func (o *IDAU_Type) SetSCFGB_BOOTPROT(value uint32) {
	volatile.StoreUint32(&o.SCFGB.Reg, volatile.LoadUint32(&o.SCFGB.Reg)&^(0xff0000)|value<<16)
}
func (o *IDAU_Type) GetSCFGB_BOOTPROT() uint32 {
	return (volatile.LoadUint32(&o.SCFGB.Reg) & 0xff0000) >> 16
}

// IDAU.SCFGA: SCFGA
func (o *IDAU_Type) SetSCFGA_AS(value uint32) {
	volatile.StoreUint32(&o.SCFGA.Reg, volatile.LoadUint32(&o.SCFGA.Reg)&^(0xff)|value)
}
func (o *IDAU_Type) GetSCFGA_AS() uint32 {
	return volatile.LoadUint32(&o.SCFGA.Reg) & 0xff
}
func (o *IDAU_Type) SetSCFGA_ANSC(value uint32) {
	volatile.StoreUint32(&o.SCFGA.Reg, volatile.LoadUint32(&o.SCFGA.Reg)&^(0x3f00)|value<<8)
}
func (o *IDAU_Type) GetSCFGA_ANSC() uint32 {
	return (volatile.LoadUint32(&o.SCFGA.Reg) & 0x3f00) >> 8
}
func (o *IDAU_Type) SetSCFGA_DS(value uint32) {
	volatile.StoreUint32(&o.SCFGA.Reg, volatile.LoadUint32(&o.SCFGA.Reg)&^(0xf0000)|value<<16)
}
func (o *IDAU_Type) GetSCFGA_DS() uint32 {
	return (volatile.LoadUint32(&o.SCFGA.Reg) & 0xf0000) >> 16
}

// IDAU.SCFGR: SCFGR
func (o *IDAU_Type) SetSCFGR_RS(value uint8) {
	volatile.StoreUint8(&o.SCFGR.Reg, volatile.LoadUint8(&o.SCFGR.Reg)&^(0x7f)|value)
}
func (o *IDAU_Type) GetSCFGR_RS() uint8 {
	return volatile.LoadUint8(&o.SCFGR.Reg) & 0x7f
}

// Main Clock
type MCLK_Type struct {
	CTRLA    volatile.Register8 // 0x0
	INTENCLR volatile.Register8 // 0x1
	INTENSET volatile.Register8 // 0x2
	INTFLAG  volatile.Register8 // 0x3
	CPUDIV   volatile.Register8 // 0x4
	_        [11]byte
	AHBMASK  volatile.Register32 // 0x10
	APBAMASK volatile.Register32 // 0x14
	APBBMASK volatile.Register32 // 0x18
	APBCMASK volatile.Register32 // 0x1C
}

// MCLK.CTRLA: Control
func (o *MCLK_Type) SetCTRLA_CKSEL(value uint8) {
	volatile.StoreUint8(&o.CTRLA.Reg, volatile.LoadUint8(&o.CTRLA.Reg)&^(0x4)|value<<2)
}
func (o *MCLK_Type) GetCTRLA_CKSEL() uint8 {
	return (volatile.LoadUint8(&o.CTRLA.Reg) & 0x4) >> 2
}

// MCLK.INTENCLR: Interrupt Enable Clear
func (o *MCLK_Type) SetINTENCLR_CKRDY(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *MCLK_Type) GetINTENCLR_CKRDY() uint8 {
	return volatile.LoadUint8(&o.INTENCLR.Reg) & 0x1
}

// MCLK.INTENSET: Interrupt Enable Set
func (o *MCLK_Type) SetINTENSET_CKRDY(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *MCLK_Type) GetINTENSET_CKRDY() uint8 {
	return volatile.LoadUint8(&o.INTENSET.Reg) & 0x1
}

// MCLK.INTFLAG: Interrupt Flag Status and Clear
func (o *MCLK_Type) SetINTFLAG_CKRDY(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x1)|value)
}
func (o *MCLK_Type) GetINTFLAG_CKRDY() uint8 {
	return volatile.LoadUint8(&o.INTFLAG.Reg) & 0x1
}

// MCLK.CPUDIV: CPU Clock Division
func (o *MCLK_Type) SetCPUDIV(value uint8) {
	volatile.StoreUint8(&o.CPUDIV.Reg, value)
}
func (o *MCLK_Type) GetCPUDIV() uint8 {
	return volatile.LoadUint8(&o.CPUDIV.Reg)
}

// MCLK.AHBMASK: AHB Mask
func (o *MCLK_Type) SetAHBMASK_HPB0_(value uint32) {
	volatile.StoreUint32(&o.AHBMASK.Reg, volatile.LoadUint32(&o.AHBMASK.Reg)&^(0x1)|value)
}
func (o *MCLK_Type) GetAHBMASK_HPB0_() uint32 {
	return volatile.LoadUint32(&o.AHBMASK.Reg) & 0x1
}
func (o *MCLK_Type) SetAHBMASK_HPB1_(value uint32) {
	volatile.StoreUint32(&o.AHBMASK.Reg, volatile.LoadUint32(&o.AHBMASK.Reg)&^(0x2)|value<<1)
}
func (o *MCLK_Type) GetAHBMASK_HPB1_() uint32 {
	return (volatile.LoadUint32(&o.AHBMASK.Reg) & 0x2) >> 1
}
func (o *MCLK_Type) SetAHBMASK_HPB2_(value uint32) {
	volatile.StoreUint32(&o.AHBMASK.Reg, volatile.LoadUint32(&o.AHBMASK.Reg)&^(0x4)|value<<2)
}
func (o *MCLK_Type) GetAHBMASK_HPB2_() uint32 {
	return (volatile.LoadUint32(&o.AHBMASK.Reg) & 0x4) >> 2
}
func (o *MCLK_Type) SetAHBMASK_DMAC_(value uint32) {
	volatile.StoreUint32(&o.AHBMASK.Reg, volatile.LoadUint32(&o.AHBMASK.Reg)&^(0x8)|value<<3)
}
func (o *MCLK_Type) GetAHBMASK_DMAC_() uint32 {
	return (volatile.LoadUint32(&o.AHBMASK.Reg) & 0x8) >> 3
}
func (o *MCLK_Type) SetAHBMASK_DSU_(value uint32) {
	volatile.StoreUint32(&o.AHBMASK.Reg, volatile.LoadUint32(&o.AHBMASK.Reg)&^(0x10)|value<<4)
}
func (o *MCLK_Type) GetAHBMASK_DSU_() uint32 {
	return (volatile.LoadUint32(&o.AHBMASK.Reg) & 0x10) >> 4
}
func (o *MCLK_Type) SetAHBMASK_PAC_(value uint32) {
	volatile.StoreUint32(&o.AHBMASK.Reg, volatile.LoadUint32(&o.AHBMASK.Reg)&^(0x40)|value<<6)
}
func (o *MCLK_Type) GetAHBMASK_PAC_() uint32 {
	return (volatile.LoadUint32(&o.AHBMASK.Reg) & 0x40) >> 6
}
func (o *MCLK_Type) SetAHBMASK_NVMCTRL_(value uint32) {
	volatile.StoreUint32(&o.AHBMASK.Reg, volatile.LoadUint32(&o.AHBMASK.Reg)&^(0x80)|value<<7)
}
func (o *MCLK_Type) GetAHBMASK_NVMCTRL_() uint32 {
	return (volatile.LoadUint32(&o.AHBMASK.Reg) & 0x80) >> 7
}
func (o *MCLK_Type) SetAHBMASK_TRAM_(value uint32) {
	volatile.StoreUint32(&o.AHBMASK.Reg, volatile.LoadUint32(&o.AHBMASK.Reg)&^(0x1000)|value<<12)
}
func (o *MCLK_Type) GetAHBMASK_TRAM_() uint32 {
	return (volatile.LoadUint32(&o.AHBMASK.Reg) & 0x1000) >> 12
}

// MCLK.APBAMASK: APBA Mask
func (o *MCLK_Type) SetAPBAMASK_PAC_(value uint32) {
	volatile.StoreUint32(&o.APBAMASK.Reg, volatile.LoadUint32(&o.APBAMASK.Reg)&^(0x1)|value)
}
func (o *MCLK_Type) GetAPBAMASK_PAC_() uint32 {
	return volatile.LoadUint32(&o.APBAMASK.Reg) & 0x1
}
func (o *MCLK_Type) SetAPBAMASK_PM_(value uint32) {
	volatile.StoreUint32(&o.APBAMASK.Reg, volatile.LoadUint32(&o.APBAMASK.Reg)&^(0x2)|value<<1)
}
func (o *MCLK_Type) GetAPBAMASK_PM_() uint32 {
	return (volatile.LoadUint32(&o.APBAMASK.Reg) & 0x2) >> 1
}
func (o *MCLK_Type) SetAPBAMASK_MCLK_(value uint32) {
	volatile.StoreUint32(&o.APBAMASK.Reg, volatile.LoadUint32(&o.APBAMASK.Reg)&^(0x4)|value<<2)
}
func (o *MCLK_Type) GetAPBAMASK_MCLK_() uint32 {
	return (volatile.LoadUint32(&o.APBAMASK.Reg) & 0x4) >> 2
}
func (o *MCLK_Type) SetAPBAMASK_RSTC_(value uint32) {
	volatile.StoreUint32(&o.APBAMASK.Reg, volatile.LoadUint32(&o.APBAMASK.Reg)&^(0x8)|value<<3)
}
func (o *MCLK_Type) GetAPBAMASK_RSTC_() uint32 {
	return (volatile.LoadUint32(&o.APBAMASK.Reg) & 0x8) >> 3
}
func (o *MCLK_Type) SetAPBAMASK_OSCCTRL_(value uint32) {
	volatile.StoreUint32(&o.APBAMASK.Reg, volatile.LoadUint32(&o.APBAMASK.Reg)&^(0x10)|value<<4)
}
func (o *MCLK_Type) GetAPBAMASK_OSCCTRL_() uint32 {
	return (volatile.LoadUint32(&o.APBAMASK.Reg) & 0x10) >> 4
}
func (o *MCLK_Type) SetAPBAMASK_OSC32KCTRL_(value uint32) {
	volatile.StoreUint32(&o.APBAMASK.Reg, volatile.LoadUint32(&o.APBAMASK.Reg)&^(0x20)|value<<5)
}
func (o *MCLK_Type) GetAPBAMASK_OSC32KCTRL_() uint32 {
	return (volatile.LoadUint32(&o.APBAMASK.Reg) & 0x20) >> 5
}
func (o *MCLK_Type) SetAPBAMASK_SUPC_(value uint32) {
	volatile.StoreUint32(&o.APBAMASK.Reg, volatile.LoadUint32(&o.APBAMASK.Reg)&^(0x40)|value<<6)
}
func (o *MCLK_Type) GetAPBAMASK_SUPC_() uint32 {
	return (volatile.LoadUint32(&o.APBAMASK.Reg) & 0x40) >> 6
}
func (o *MCLK_Type) SetAPBAMASK_GCLK_(value uint32) {
	volatile.StoreUint32(&o.APBAMASK.Reg, volatile.LoadUint32(&o.APBAMASK.Reg)&^(0x80)|value<<7)
}
func (o *MCLK_Type) GetAPBAMASK_GCLK_() uint32 {
	return (volatile.LoadUint32(&o.APBAMASK.Reg) & 0x80) >> 7
}
func (o *MCLK_Type) SetAPBAMASK_WDT_(value uint32) {
	volatile.StoreUint32(&o.APBAMASK.Reg, volatile.LoadUint32(&o.APBAMASK.Reg)&^(0x100)|value<<8)
}
func (o *MCLK_Type) GetAPBAMASK_WDT_() uint32 {
	return (volatile.LoadUint32(&o.APBAMASK.Reg) & 0x100) >> 8
}
func (o *MCLK_Type) SetAPBAMASK_RTC_(value uint32) {
	volatile.StoreUint32(&o.APBAMASK.Reg, volatile.LoadUint32(&o.APBAMASK.Reg)&^(0x200)|value<<9)
}
func (o *MCLK_Type) GetAPBAMASK_RTC_() uint32 {
	return (volatile.LoadUint32(&o.APBAMASK.Reg) & 0x200) >> 9
}
func (o *MCLK_Type) SetAPBAMASK_EIC_(value uint32) {
	volatile.StoreUint32(&o.APBAMASK.Reg, volatile.LoadUint32(&o.APBAMASK.Reg)&^(0x400)|value<<10)
}
func (o *MCLK_Type) GetAPBAMASK_EIC_() uint32 {
	return (volatile.LoadUint32(&o.APBAMASK.Reg) & 0x400) >> 10
}
func (o *MCLK_Type) SetAPBAMASK_FREQM_(value uint32) {
	volatile.StoreUint32(&o.APBAMASK.Reg, volatile.LoadUint32(&o.APBAMASK.Reg)&^(0x800)|value<<11)
}
func (o *MCLK_Type) GetAPBAMASK_FREQM_() uint32 {
	return (volatile.LoadUint32(&o.APBAMASK.Reg) & 0x800) >> 11
}
func (o *MCLK_Type) SetAPBAMASK_PORT_(value uint32) {
	volatile.StoreUint32(&o.APBAMASK.Reg, volatile.LoadUint32(&o.APBAMASK.Reg)&^(0x1000)|value<<12)
}
func (o *MCLK_Type) GetAPBAMASK_PORT_() uint32 {
	return (volatile.LoadUint32(&o.APBAMASK.Reg) & 0x1000) >> 12
}
func (o *MCLK_Type) SetAPBAMASK_AC_(value uint32) {
	volatile.StoreUint32(&o.APBAMASK.Reg, volatile.LoadUint32(&o.APBAMASK.Reg)&^(0x2000)|value<<13)
}
func (o *MCLK_Type) GetAPBAMASK_AC_() uint32 {
	return (volatile.LoadUint32(&o.APBAMASK.Reg) & 0x2000) >> 13
}

// MCLK.APBBMASK: APBB Mask
func (o *MCLK_Type) SetAPBBMASK_IDAU_(value uint32) {
	volatile.StoreUint32(&o.APBBMASK.Reg, volatile.LoadUint32(&o.APBBMASK.Reg)&^(0x1)|value)
}
func (o *MCLK_Type) GetAPBBMASK_IDAU_() uint32 {
	return volatile.LoadUint32(&o.APBBMASK.Reg) & 0x1
}
func (o *MCLK_Type) SetAPBBMASK_DSU_(value uint32) {
	volatile.StoreUint32(&o.APBBMASK.Reg, volatile.LoadUint32(&o.APBBMASK.Reg)&^(0x2)|value<<1)
}
func (o *MCLK_Type) GetAPBBMASK_DSU_() uint32 {
	return (volatile.LoadUint32(&o.APBBMASK.Reg) & 0x2) >> 1
}
func (o *MCLK_Type) SetAPBBMASK_NVMCTRL_(value uint32) {
	volatile.StoreUint32(&o.APBBMASK.Reg, volatile.LoadUint32(&o.APBBMASK.Reg)&^(0x4)|value<<2)
}
func (o *MCLK_Type) GetAPBBMASK_NVMCTRL_() uint32 {
	return (volatile.LoadUint32(&o.APBBMASK.Reg) & 0x4) >> 2
}

// MCLK.APBCMASK: APBC Mask
func (o *MCLK_Type) SetAPBCMASK_EVSYS_(value uint32) {
	volatile.StoreUint32(&o.APBCMASK.Reg, volatile.LoadUint32(&o.APBCMASK.Reg)&^(0x1)|value)
}
func (o *MCLK_Type) GetAPBCMASK_EVSYS_() uint32 {
	return volatile.LoadUint32(&o.APBCMASK.Reg) & 0x1
}
func (o *MCLK_Type) SetAPBCMASK_SERCOM0_(value uint32) {
	volatile.StoreUint32(&o.APBCMASK.Reg, volatile.LoadUint32(&o.APBCMASK.Reg)&^(0x2)|value<<1)
}
func (o *MCLK_Type) GetAPBCMASK_SERCOM0_() uint32 {
	return (volatile.LoadUint32(&o.APBCMASK.Reg) & 0x2) >> 1
}
func (o *MCLK_Type) SetAPBCMASK_SERCOM1_(value uint32) {
	volatile.StoreUint32(&o.APBCMASK.Reg, volatile.LoadUint32(&o.APBCMASK.Reg)&^(0x4)|value<<2)
}
func (o *MCLK_Type) GetAPBCMASK_SERCOM1_() uint32 {
	return (volatile.LoadUint32(&o.APBCMASK.Reg) & 0x4) >> 2
}
func (o *MCLK_Type) SetAPBCMASK_TC0_(value uint32) {
	volatile.StoreUint32(&o.APBCMASK.Reg, volatile.LoadUint32(&o.APBCMASK.Reg)&^(0x10)|value<<4)
}
func (o *MCLK_Type) GetAPBCMASK_TC0_() uint32 {
	return (volatile.LoadUint32(&o.APBCMASK.Reg) & 0x10) >> 4
}
func (o *MCLK_Type) SetAPBCMASK_TC1_(value uint32) {
	volatile.StoreUint32(&o.APBCMASK.Reg, volatile.LoadUint32(&o.APBCMASK.Reg)&^(0x20)|value<<5)
}
func (o *MCLK_Type) GetAPBCMASK_TC1_() uint32 {
	return (volatile.LoadUint32(&o.APBCMASK.Reg) & 0x20) >> 5
}
func (o *MCLK_Type) SetAPBCMASK_TC2_(value uint32) {
	volatile.StoreUint32(&o.APBCMASK.Reg, volatile.LoadUint32(&o.APBCMASK.Reg)&^(0x40)|value<<6)
}
func (o *MCLK_Type) GetAPBCMASK_TC2_() uint32 {
	return (volatile.LoadUint32(&o.APBCMASK.Reg) & 0x40) >> 6
}
func (o *MCLK_Type) SetAPBCMASK_ADC_(value uint32) {
	volatile.StoreUint32(&o.APBCMASK.Reg, volatile.LoadUint32(&o.APBCMASK.Reg)&^(0x80)|value<<7)
}
func (o *MCLK_Type) GetAPBCMASK_ADC_() uint32 {
	return (volatile.LoadUint32(&o.APBCMASK.Reg) & 0x80) >> 7
}
func (o *MCLK_Type) SetAPBCMASK_DAC_(value uint32) {
	volatile.StoreUint32(&o.APBCMASK.Reg, volatile.LoadUint32(&o.APBCMASK.Reg)&^(0x100)|value<<8)
}
func (o *MCLK_Type) GetAPBCMASK_DAC_() uint32 {
	return (volatile.LoadUint32(&o.APBCMASK.Reg) & 0x100) >> 8
}
func (o *MCLK_Type) SetAPBCMASK_PTC_(value uint32) {
	volatile.StoreUint32(&o.APBCMASK.Reg, volatile.LoadUint32(&o.APBCMASK.Reg)&^(0x200)|value<<9)
}
func (o *MCLK_Type) GetAPBCMASK_PTC_() uint32 {
	return (volatile.LoadUint32(&o.APBCMASK.Reg) & 0x200) >> 9
}
func (o *MCLK_Type) SetAPBCMASK_TRNG_(value uint32) {
	volatile.StoreUint32(&o.APBCMASK.Reg, volatile.LoadUint32(&o.APBCMASK.Reg)&^(0x400)|value<<10)
}
func (o *MCLK_Type) GetAPBCMASK_TRNG_() uint32 {
	return (volatile.LoadUint32(&o.APBCMASK.Reg) & 0x400) >> 10
}
func (o *MCLK_Type) SetAPBCMASK_CCL_(value uint32) {
	volatile.StoreUint32(&o.APBCMASK.Reg, volatile.LoadUint32(&o.APBCMASK.Reg)&^(0x800)|value<<11)
}
func (o *MCLK_Type) GetAPBCMASK_CCL_() uint32 {
	return (volatile.LoadUint32(&o.APBCMASK.Reg) & 0x800) >> 11
}
func (o *MCLK_Type) SetAPBCMASK_OPAMP_(value uint32) {
	volatile.StoreUint32(&o.APBCMASK.Reg, volatile.LoadUint32(&o.APBCMASK.Reg)&^(0x1000)|value<<12)
}
func (o *MCLK_Type) GetAPBCMASK_OPAMP_() uint32 {
	return (volatile.LoadUint32(&o.APBCMASK.Reg) & 0x1000) >> 12
}

// Non-Volatile Memory Controller
type NVMCTRL_Type struct {
	CTRLA    volatile.Register16 // 0x0
	_        [2]byte
	CTRLB    volatile.Register32 // 0x4
	CTRLC    volatile.Register8  // 0x8
	_        byte
	EVCTRL   volatile.Register8 // 0xA
	_        byte
	INTENCLR volatile.Register8 // 0xC
	_        [3]byte
	INTENSET volatile.Register8 // 0x10
	_        [3]byte
	INTFLAG  volatile.Register8 // 0x14
	_        [3]byte
	STATUS   volatile.Register16 // 0x18
	_        [2]byte
	ADDR     volatile.Register32 // 0x1C
	SULCK    volatile.Register16 // 0x20
	NSULCK   volatile.Register16 // 0x22
	PARAM    volatile.Register32 // 0x24
	_        [8]byte
	DSCC     volatile.Register32 // 0x30
	SECCTRL  volatile.Register32 // 0x34
	SCFGB    volatile.Register32 // 0x38
	SCFGAD   volatile.Register32 // 0x3C
	NONSEC   volatile.Register32 // 0x40
	NSCHK    volatile.Register32 // 0x44
}

// NVMCTRL.CTRLA: Control A
func (o *NVMCTRL_Type) SetCTRLA_CMD(value uint16) {
	volatile.StoreUint16(&o.CTRLA.Reg, volatile.LoadUint16(&o.CTRLA.Reg)&^(0x7f)|value)
}
func (o *NVMCTRL_Type) GetCTRLA_CMD() uint16 {
	return volatile.LoadUint16(&o.CTRLA.Reg) & 0x7f
}
func (o *NVMCTRL_Type) SetCTRLA_CMDEX(value uint16) {
	volatile.StoreUint16(&o.CTRLA.Reg, volatile.LoadUint16(&o.CTRLA.Reg)&^(0xff00)|value<<8)
}
func (o *NVMCTRL_Type) GetCTRLA_CMDEX() uint16 {
	return (volatile.LoadUint16(&o.CTRLA.Reg) & 0xff00) >> 8
}

// NVMCTRL.CTRLB: Control B
func (o *NVMCTRL_Type) SetCTRLB_RWS(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0x1e)|value<<1)
}
func (o *NVMCTRL_Type) GetCTRLB_RWS() uint32 {
	return (volatile.LoadUint32(&o.CTRLB.Reg) & 0x1e) >> 1
}
func (o *NVMCTRL_Type) SetCTRLB_SLEEPPRM(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0x300)|value<<8)
}
func (o *NVMCTRL_Type) GetCTRLB_SLEEPPRM() uint32 {
	return (volatile.LoadUint32(&o.CTRLB.Reg) & 0x300) >> 8
}
func (o *NVMCTRL_Type) SetCTRLB_FWUP(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0x800)|value<<11)
}
func (o *NVMCTRL_Type) GetCTRLB_FWUP() uint32 {
	return (volatile.LoadUint32(&o.CTRLB.Reg) & 0x800) >> 11
}
func (o *NVMCTRL_Type) SetCTRLB_READMODE(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0x30000)|value<<16)
}
func (o *NVMCTRL_Type) GetCTRLB_READMODE() uint32 {
	return (volatile.LoadUint32(&o.CTRLB.Reg) & 0x30000) >> 16
}
func (o *NVMCTRL_Type) SetCTRLB_CACHEDIS(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0x40000)|value<<18)
}
func (o *NVMCTRL_Type) GetCTRLB_CACHEDIS() uint32 {
	return (volatile.LoadUint32(&o.CTRLB.Reg) & 0x40000) >> 18
}
func (o *NVMCTRL_Type) SetCTRLB_QWEN(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0x80000)|value<<19)
}
func (o *NVMCTRL_Type) GetCTRLB_QWEN() uint32 {
	return (volatile.LoadUint32(&o.CTRLB.Reg) & 0x80000) >> 19
}

// NVMCTRL.CTRLC: Control C
func (o *NVMCTRL_Type) SetCTRLC_MANW(value uint8) {
	volatile.StoreUint8(&o.CTRLC.Reg, volatile.LoadUint8(&o.CTRLC.Reg)&^(0x1)|value)
}
func (o *NVMCTRL_Type) GetCTRLC_MANW() uint8 {
	return volatile.LoadUint8(&o.CTRLC.Reg) & 0x1
}

// NVMCTRL.EVCTRL: Event Control
func (o *NVMCTRL_Type) SetEVCTRL_AUTOWEI(value uint8) {
	volatile.StoreUint8(&o.EVCTRL.Reg, volatile.LoadUint8(&o.EVCTRL.Reg)&^(0x1)|value)
}
func (o *NVMCTRL_Type) GetEVCTRL_AUTOWEI() uint8 {
	return volatile.LoadUint8(&o.EVCTRL.Reg) & 0x1
}
func (o *NVMCTRL_Type) SetEVCTRL_AUTOWINV(value uint8) {
	volatile.StoreUint8(&o.EVCTRL.Reg, volatile.LoadUint8(&o.EVCTRL.Reg)&^(0x2)|value<<1)
}
func (o *NVMCTRL_Type) GetEVCTRL_AUTOWINV() uint8 {
	return (volatile.LoadUint8(&o.EVCTRL.Reg) & 0x2) >> 1
}

// NVMCTRL.INTENCLR: Interrupt Enable Clear
func (o *NVMCTRL_Type) SetINTENCLR_DONE(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *NVMCTRL_Type) GetINTENCLR_DONE() uint8 {
	return volatile.LoadUint8(&o.INTENCLR.Reg) & 0x1
}
func (o *NVMCTRL_Type) SetINTENCLR_PROGE(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *NVMCTRL_Type) GetINTENCLR_PROGE() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *NVMCTRL_Type) SetINTENCLR_LOCKE(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *NVMCTRL_Type) GetINTENCLR_LOCKE() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x4) >> 2
}
func (o *NVMCTRL_Type) SetINTENCLR_NVME(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x8)|value<<3)
}
func (o *NVMCTRL_Type) GetINTENCLR_NVME() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x8) >> 3
}
func (o *NVMCTRL_Type) SetINTENCLR_KEYE(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x10)|value<<4)
}
func (o *NVMCTRL_Type) GetINTENCLR_KEYE() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x10) >> 4
}
func (o *NVMCTRL_Type) SetINTENCLR_NSCHK(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x20)|value<<5)
}
func (o *NVMCTRL_Type) GetINTENCLR_NSCHK() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x20) >> 5
}

// NVMCTRL.INTENSET: Interrupt Enable Set
func (o *NVMCTRL_Type) SetINTENSET_DONE(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *NVMCTRL_Type) GetINTENSET_DONE() uint8 {
	return volatile.LoadUint8(&o.INTENSET.Reg) & 0x1
}
func (o *NVMCTRL_Type) SetINTENSET_PROGE(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *NVMCTRL_Type) GetINTENSET_PROGE() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *NVMCTRL_Type) SetINTENSET_LOCKE(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *NVMCTRL_Type) GetINTENSET_LOCKE() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x4) >> 2
}
func (o *NVMCTRL_Type) SetINTENSET_NVME(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x8)|value<<3)
}
func (o *NVMCTRL_Type) GetINTENSET_NVME() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x8) >> 3
}
func (o *NVMCTRL_Type) SetINTENSET_KEYE(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x10)|value<<4)
}
func (o *NVMCTRL_Type) GetINTENSET_KEYE() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x10) >> 4
}
func (o *NVMCTRL_Type) SetINTENSET_NSCHK(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x20)|value<<5)
}
func (o *NVMCTRL_Type) GetINTENSET_NSCHK() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x20) >> 5
}

// NVMCTRL.INTFLAG: Interrupt Flag Status and Clear
func (o *NVMCTRL_Type) SetINTFLAG_DONE(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x1)|value)
}
func (o *NVMCTRL_Type) GetINTFLAG_DONE() uint8 {
	return volatile.LoadUint8(&o.INTFLAG.Reg) & 0x1
}
func (o *NVMCTRL_Type) SetINTFLAG_PROGE(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x2)|value<<1)
}
func (o *NVMCTRL_Type) GetINTFLAG_PROGE() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x2) >> 1
}
func (o *NVMCTRL_Type) SetINTFLAG_LOCKE(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x4)|value<<2)
}
func (o *NVMCTRL_Type) GetINTFLAG_LOCKE() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x4) >> 2
}
func (o *NVMCTRL_Type) SetINTFLAG_NVME(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x8)|value<<3)
}
func (o *NVMCTRL_Type) GetINTFLAG_NVME() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x8) >> 3
}
func (o *NVMCTRL_Type) SetINTFLAG_KEYE(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x10)|value<<4)
}
func (o *NVMCTRL_Type) GetINTFLAG_KEYE() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x10) >> 4
}
func (o *NVMCTRL_Type) SetINTFLAG_NSCHK(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x20)|value<<5)
}
func (o *NVMCTRL_Type) GetINTFLAG_NSCHK() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x20) >> 5
}

// NVMCTRL.STATUS: Status
func (o *NVMCTRL_Type) SetSTATUS_PRM(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x1)|value)
}
func (o *NVMCTRL_Type) GetSTATUS_PRM() uint16 {
	return volatile.LoadUint16(&o.STATUS.Reg) & 0x1
}
func (o *NVMCTRL_Type) SetSTATUS_LOAD(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x2)|value<<1)
}
func (o *NVMCTRL_Type) GetSTATUS_LOAD() uint16 {
	return (volatile.LoadUint16(&o.STATUS.Reg) & 0x2) >> 1
}
func (o *NVMCTRL_Type) SetSTATUS_READY(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x4)|value<<2)
}
func (o *NVMCTRL_Type) GetSTATUS_READY() uint16 {
	return (volatile.LoadUint16(&o.STATUS.Reg) & 0x4) >> 2
}
func (o *NVMCTRL_Type) SetSTATUS_DALFUSE(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x18)|value<<3)
}
func (o *NVMCTRL_Type) GetSTATUS_DALFUSE() uint16 {
	return (volatile.LoadUint16(&o.STATUS.Reg) & 0x18) >> 3
}

// NVMCTRL.ADDR: Address
func (o *NVMCTRL_Type) SetADDR_AOFFSET(value uint32) {
	volatile.StoreUint32(&o.ADDR.Reg, volatile.LoadUint32(&o.ADDR.Reg)&^(0xffff)|value)
}
func (o *NVMCTRL_Type) GetADDR_AOFFSET() uint32 {
	return volatile.LoadUint32(&o.ADDR.Reg) & 0xffff
}
func (o *NVMCTRL_Type) SetADDR_ARRAY(value uint32) {
	volatile.StoreUint32(&o.ADDR.Reg, volatile.LoadUint32(&o.ADDR.Reg)&^(0xc00000)|value<<22)
}
func (o *NVMCTRL_Type) GetADDR_ARRAY() uint32 {
	return (volatile.LoadUint32(&o.ADDR.Reg) & 0xc00000) >> 22
}

// NVMCTRL.SULCK: Secure Unlock Register
func (o *NVMCTRL_Type) SetSULCK_BS(value uint16) {
	volatile.StoreUint16(&o.SULCK.Reg, volatile.LoadUint16(&o.SULCK.Reg)&^(0x1)|value)
}
func (o *NVMCTRL_Type) GetSULCK_BS() uint16 {
	return volatile.LoadUint16(&o.SULCK.Reg) & 0x1
}
func (o *NVMCTRL_Type) SetSULCK_AS(value uint16) {
	volatile.StoreUint16(&o.SULCK.Reg, volatile.LoadUint16(&o.SULCK.Reg)&^(0x2)|value<<1)
}
func (o *NVMCTRL_Type) GetSULCK_AS() uint16 {
	return (volatile.LoadUint16(&o.SULCK.Reg) & 0x2) >> 1
}
func (o *NVMCTRL_Type) SetSULCK_DS(value uint16) {
	volatile.StoreUint16(&o.SULCK.Reg, volatile.LoadUint16(&o.SULCK.Reg)&^(0x4)|value<<2)
}
func (o *NVMCTRL_Type) GetSULCK_DS() uint16 {
	return (volatile.LoadUint16(&o.SULCK.Reg) & 0x4) >> 2
}
func (o *NVMCTRL_Type) SetSULCK_SLKEY(value uint16) {
	volatile.StoreUint16(&o.SULCK.Reg, volatile.LoadUint16(&o.SULCK.Reg)&^(0xff00)|value<<8)
}
func (o *NVMCTRL_Type) GetSULCK_SLKEY() uint16 {
	return (volatile.LoadUint16(&o.SULCK.Reg) & 0xff00) >> 8
}

// NVMCTRL.NSULCK: Non-Secure Unlock Register
func (o *NVMCTRL_Type) SetNSULCK_BNS(value uint16) {
	volatile.StoreUint16(&o.NSULCK.Reg, volatile.LoadUint16(&o.NSULCK.Reg)&^(0x1)|value)
}
func (o *NVMCTRL_Type) GetNSULCK_BNS() uint16 {
	return volatile.LoadUint16(&o.NSULCK.Reg) & 0x1
}
func (o *NVMCTRL_Type) SetNSULCK_ANS(value uint16) {
	volatile.StoreUint16(&o.NSULCK.Reg, volatile.LoadUint16(&o.NSULCK.Reg)&^(0x2)|value<<1)
}
func (o *NVMCTRL_Type) GetNSULCK_ANS() uint16 {
	return (volatile.LoadUint16(&o.NSULCK.Reg) & 0x2) >> 1
}
func (o *NVMCTRL_Type) SetNSULCK_DNS(value uint16) {
	volatile.StoreUint16(&o.NSULCK.Reg, volatile.LoadUint16(&o.NSULCK.Reg)&^(0x4)|value<<2)
}
func (o *NVMCTRL_Type) GetNSULCK_DNS() uint16 {
	return (volatile.LoadUint16(&o.NSULCK.Reg) & 0x4) >> 2
}
func (o *NVMCTRL_Type) SetNSULCK_NSLKEY(value uint16) {
	volatile.StoreUint16(&o.NSULCK.Reg, volatile.LoadUint16(&o.NSULCK.Reg)&^(0xff00)|value<<8)
}
func (o *NVMCTRL_Type) GetNSULCK_NSLKEY() uint16 {
	return (volatile.LoadUint16(&o.NSULCK.Reg) & 0xff00) >> 8
}

// NVMCTRL.PARAM: NVM Parameter
func (o *NVMCTRL_Type) SetPARAM_FLASHP(value uint32) {
	volatile.StoreUint32(&o.PARAM.Reg, volatile.LoadUint32(&o.PARAM.Reg)&^(0xffff)|value)
}
func (o *NVMCTRL_Type) GetPARAM_FLASHP() uint32 {
	return volatile.LoadUint32(&o.PARAM.Reg) & 0xffff
}
func (o *NVMCTRL_Type) SetPARAM_PSZ(value uint32) {
	volatile.StoreUint32(&o.PARAM.Reg, volatile.LoadUint32(&o.PARAM.Reg)&^(0x70000)|value<<16)
}
func (o *NVMCTRL_Type) GetPARAM_PSZ() uint32 {
	return (volatile.LoadUint32(&o.PARAM.Reg) & 0x70000) >> 16
}
func (o *NVMCTRL_Type) SetPARAM_DFLASHP(value uint32) {
	volatile.StoreUint32(&o.PARAM.Reg, volatile.LoadUint32(&o.PARAM.Reg)&^(0xfff00000)|value<<20)
}
func (o *NVMCTRL_Type) GetPARAM_DFLASHP() uint32 {
	return (volatile.LoadUint32(&o.PARAM.Reg) & 0xfff00000) >> 20
}

// NVMCTRL.DSCC: Data Scramble Configuration
func (o *NVMCTRL_Type) SetDSCC_DSCKEY(value uint32) {
	volatile.StoreUint32(&o.DSCC.Reg, volatile.LoadUint32(&o.DSCC.Reg)&^(0x3fffffff)|value)
}
func (o *NVMCTRL_Type) GetDSCC_DSCKEY() uint32 {
	return volatile.LoadUint32(&o.DSCC.Reg) & 0x3fffffff
}

// NVMCTRL.SECCTRL: Security Control
func (o *NVMCTRL_Type) SetSECCTRL_TAMPEEN(value uint32) {
	volatile.StoreUint32(&o.SECCTRL.Reg, volatile.LoadUint32(&o.SECCTRL.Reg)&^(0x1)|value)
}
func (o *NVMCTRL_Type) GetSECCTRL_TAMPEEN() uint32 {
	return volatile.LoadUint32(&o.SECCTRL.Reg) & 0x1
}
func (o *NVMCTRL_Type) SetSECCTRL_SILACC(value uint32) {
	volatile.StoreUint32(&o.SECCTRL.Reg, volatile.LoadUint32(&o.SECCTRL.Reg)&^(0x4)|value<<2)
}
func (o *NVMCTRL_Type) GetSECCTRL_SILACC() uint32 {
	return (volatile.LoadUint32(&o.SECCTRL.Reg) & 0x4) >> 2
}
func (o *NVMCTRL_Type) SetSECCTRL_DSCEN(value uint32) {
	volatile.StoreUint32(&o.SECCTRL.Reg, volatile.LoadUint32(&o.SECCTRL.Reg)&^(0x8)|value<<3)
}
func (o *NVMCTRL_Type) GetSECCTRL_DSCEN() uint32 {
	return (volatile.LoadUint32(&o.SECCTRL.Reg) & 0x8) >> 3
}
func (o *NVMCTRL_Type) SetSECCTRL_DXN(value uint32) {
	volatile.StoreUint32(&o.SECCTRL.Reg, volatile.LoadUint32(&o.SECCTRL.Reg)&^(0x40)|value<<6)
}
func (o *NVMCTRL_Type) GetSECCTRL_DXN() uint32 {
	return (volatile.LoadUint32(&o.SECCTRL.Reg) & 0x40) >> 6
}
func (o *NVMCTRL_Type) SetSECCTRL_TEROW(value uint32) {
	volatile.StoreUint32(&o.SECCTRL.Reg, volatile.LoadUint32(&o.SECCTRL.Reg)&^(0x700)|value<<8)
}
func (o *NVMCTRL_Type) GetSECCTRL_TEROW() uint32 {
	return (volatile.LoadUint32(&o.SECCTRL.Reg) & 0x700) >> 8
}
func (o *NVMCTRL_Type) SetSECCTRL_KEY(value uint32) {
	volatile.StoreUint32(&o.SECCTRL.Reg, volatile.LoadUint32(&o.SECCTRL.Reg)&^(0xff000000)|value<<24)
}
func (o *NVMCTRL_Type) GetSECCTRL_KEY() uint32 {
	return (volatile.LoadUint32(&o.SECCTRL.Reg) & 0xff000000) >> 24
}

// NVMCTRL.SCFGB: Secure Boot Configuration
func (o *NVMCTRL_Type) SetSCFGB_BCREN(value uint32) {
	volatile.StoreUint32(&o.SCFGB.Reg, volatile.LoadUint32(&o.SCFGB.Reg)&^(0x1)|value)
}
func (o *NVMCTRL_Type) GetSCFGB_BCREN() uint32 {
	return volatile.LoadUint32(&o.SCFGB.Reg) & 0x1
}
func (o *NVMCTRL_Type) SetSCFGB_BCWEN(value uint32) {
	volatile.StoreUint32(&o.SCFGB.Reg, volatile.LoadUint32(&o.SCFGB.Reg)&^(0x2)|value<<1)
}
func (o *NVMCTRL_Type) GetSCFGB_BCWEN() uint32 {
	return (volatile.LoadUint32(&o.SCFGB.Reg) & 0x2) >> 1
}

// NVMCTRL.SCFGAD: Secure Application and Data Configuration
func (o *NVMCTRL_Type) SetSCFGAD_URWEN(value uint32) {
	volatile.StoreUint32(&o.SCFGAD.Reg, volatile.LoadUint32(&o.SCFGAD.Reg)&^(0x1)|value)
}
func (o *NVMCTRL_Type) GetSCFGAD_URWEN() uint32 {
	return volatile.LoadUint32(&o.SCFGAD.Reg) & 0x1
}

// NVMCTRL.NONSEC: Non-secure Write Enable
func (o *NVMCTRL_Type) SetNONSEC_WRITE(value uint32) {
	volatile.StoreUint32(&o.NONSEC.Reg, volatile.LoadUint32(&o.NONSEC.Reg)&^(0x1)|value)
}
func (o *NVMCTRL_Type) GetNONSEC_WRITE() uint32 {
	return volatile.LoadUint32(&o.NONSEC.Reg) & 0x1
}

// NVMCTRL.NSCHK: Non-secure Write Reference Value
func (o *NVMCTRL_Type) SetNSCHK_WRITE(value uint32) {
	volatile.StoreUint32(&o.NSCHK.Reg, volatile.LoadUint32(&o.NSCHK.Reg)&^(0x1)|value)
}
func (o *NVMCTRL_Type) GetNSCHK_WRITE() uint32 {
	return volatile.LoadUint32(&o.NSCHK.Reg) & 0x1
}

// Operational Amplifier
type OPAMP_Type struct {
	CTRLA     volatile.Register8 // 0x0
	_         byte
	STATUS    volatile.Register8 // 0x2
	_         byte
	OPAMPCTRL [3]volatile.Register32 // 0x4
	RESCTRL   volatile.Register8     // 0x10
}

// OPAMP.CTRLA: Control A
func (o *OPAMP_Type) SetCTRLA_SWRST(value uint8) {
	volatile.StoreUint8(&o.CTRLA.Reg, volatile.LoadUint8(&o.CTRLA.Reg)&^(0x1)|value)
}
func (o *OPAMP_Type) GetCTRLA_SWRST() uint8 {
	return volatile.LoadUint8(&o.CTRLA.Reg) & 0x1
}
func (o *OPAMP_Type) SetCTRLA_ENABLE(value uint8) {
	volatile.StoreUint8(&o.CTRLA.Reg, volatile.LoadUint8(&o.CTRLA.Reg)&^(0x2)|value<<1)
}
func (o *OPAMP_Type) GetCTRLA_ENABLE() uint8 {
	return (volatile.LoadUint8(&o.CTRLA.Reg) & 0x2) >> 1
}
func (o *OPAMP_Type) SetCTRLA_LPMUX(value uint8) {
	volatile.StoreUint8(&o.CTRLA.Reg, volatile.LoadUint8(&o.CTRLA.Reg)&^(0x80)|value<<7)
}
func (o *OPAMP_Type) GetCTRLA_LPMUX() uint8 {
	return (volatile.LoadUint8(&o.CTRLA.Reg) & 0x80) >> 7
}

// OPAMP.STATUS: Status
func (o *OPAMP_Type) SetSTATUS_READY0(value uint8) {
	volatile.StoreUint8(&o.STATUS.Reg, volatile.LoadUint8(&o.STATUS.Reg)&^(0x1)|value)
}
func (o *OPAMP_Type) GetSTATUS_READY0() uint8 {
	return volatile.LoadUint8(&o.STATUS.Reg) & 0x1
}
func (o *OPAMP_Type) SetSTATUS_READY1(value uint8) {
	volatile.StoreUint8(&o.STATUS.Reg, volatile.LoadUint8(&o.STATUS.Reg)&^(0x2)|value<<1)
}
func (o *OPAMP_Type) GetSTATUS_READY1() uint8 {
	return (volatile.LoadUint8(&o.STATUS.Reg) & 0x2) >> 1
}
func (o *OPAMP_Type) SetSTATUS_READY2(value uint8) {
	volatile.StoreUint8(&o.STATUS.Reg, volatile.LoadUint8(&o.STATUS.Reg)&^(0x4)|value<<2)
}
func (o *OPAMP_Type) GetSTATUS_READY2() uint8 {
	return (volatile.LoadUint8(&o.STATUS.Reg) & 0x4) >> 2
}

// OPAMP.OPAMPCTRL: OPAMP n Control
func (o *OPAMP_Type) SetOPAMPCTRL_ENABLE(idx int, value uint32) {
	volatile.StoreUint32(&o.OPAMPCTRL[idx].Reg, volatile.LoadUint32(&o.OPAMPCTRL[idx].Reg)&^(0x2)|value<<1)
}
func (o *OPAMP_Type) GetOPAMPCTRL_ENABLE(idx int) uint32 {
	return (volatile.LoadUint32(&o.OPAMPCTRL[idx].Reg) & 0x2) >> 1
}
func (o *OPAMP_Type) SetOPAMPCTRL_ANAOUT(idx int, value uint32) {
	volatile.StoreUint32(&o.OPAMPCTRL[idx].Reg, volatile.LoadUint32(&o.OPAMPCTRL[idx].Reg)&^(0x4)|value<<2)
}
func (o *OPAMP_Type) GetOPAMPCTRL_ANAOUT(idx int) uint32 {
	return (volatile.LoadUint32(&o.OPAMPCTRL[idx].Reg) & 0x4) >> 2
}
func (o *OPAMP_Type) SetOPAMPCTRL_BIAS(idx int, value uint32) {
	volatile.StoreUint32(&o.OPAMPCTRL[idx].Reg, volatile.LoadUint32(&o.OPAMPCTRL[idx].Reg)&^(0x18)|value<<3)
}
func (o *OPAMP_Type) GetOPAMPCTRL_BIAS(idx int) uint32 {
	return (volatile.LoadUint32(&o.OPAMPCTRL[idx].Reg) & 0x18) >> 3
}
func (o *OPAMP_Type) SetOPAMPCTRL_RES2VCC(idx int, value uint32) {
	volatile.StoreUint32(&o.OPAMPCTRL[idx].Reg, volatile.LoadUint32(&o.OPAMPCTRL[idx].Reg)&^(0x20)|value<<5)
}
func (o *OPAMP_Type) GetOPAMPCTRL_RES2VCC(idx int) uint32 {
	return (volatile.LoadUint32(&o.OPAMPCTRL[idx].Reg) & 0x20) >> 5
}
func (o *OPAMP_Type) SetOPAMPCTRL_RUNSTDBY(idx int, value uint32) {
	volatile.StoreUint32(&o.OPAMPCTRL[idx].Reg, volatile.LoadUint32(&o.OPAMPCTRL[idx].Reg)&^(0x40)|value<<6)
}
func (o *OPAMP_Type) GetOPAMPCTRL_RUNSTDBY(idx int) uint32 {
	return (volatile.LoadUint32(&o.OPAMPCTRL[idx].Reg) & 0x40) >> 6
}
func (o *OPAMP_Type) SetOPAMPCTRL_ONDEMAND(idx int, value uint32) {
	volatile.StoreUint32(&o.OPAMPCTRL[idx].Reg, volatile.LoadUint32(&o.OPAMPCTRL[idx].Reg)&^(0x80)|value<<7)
}
func (o *OPAMP_Type) GetOPAMPCTRL_ONDEMAND(idx int) uint32 {
	return (volatile.LoadUint32(&o.OPAMPCTRL[idx].Reg) & 0x80) >> 7
}
func (o *OPAMP_Type) SetOPAMPCTRL_RES2OUT(idx int, value uint32) {
	volatile.StoreUint32(&o.OPAMPCTRL[idx].Reg, volatile.LoadUint32(&o.OPAMPCTRL[idx].Reg)&^(0x100)|value<<8)
}
func (o *OPAMP_Type) GetOPAMPCTRL_RES2OUT(idx int) uint32 {
	return (volatile.LoadUint32(&o.OPAMPCTRL[idx].Reg) & 0x100) >> 8
}
func (o *OPAMP_Type) SetOPAMPCTRL_RES1EN(idx int, value uint32) {
	volatile.StoreUint32(&o.OPAMPCTRL[idx].Reg, volatile.LoadUint32(&o.OPAMPCTRL[idx].Reg)&^(0x200)|value<<9)
}
func (o *OPAMP_Type) GetOPAMPCTRL_RES1EN(idx int) uint32 {
	return (volatile.LoadUint32(&o.OPAMPCTRL[idx].Reg) & 0x200) >> 9
}
func (o *OPAMP_Type) SetOPAMPCTRL_RES1MUX(idx int, value uint32) {
	volatile.StoreUint32(&o.OPAMPCTRL[idx].Reg, volatile.LoadUint32(&o.OPAMPCTRL[idx].Reg)&^(0x1c00)|value<<10)
}
func (o *OPAMP_Type) GetOPAMPCTRL_RES1MUX(idx int) uint32 {
	return (volatile.LoadUint32(&o.OPAMPCTRL[idx].Reg) & 0x1c00) >> 10
}
func (o *OPAMP_Type) SetOPAMPCTRL_POTMUX(idx int, value uint32) {
	volatile.StoreUint32(&o.OPAMPCTRL[idx].Reg, volatile.LoadUint32(&o.OPAMPCTRL[idx].Reg)&^(0xe000)|value<<13)
}
func (o *OPAMP_Type) GetOPAMPCTRL_POTMUX(idx int) uint32 {
	return (volatile.LoadUint32(&o.OPAMPCTRL[idx].Reg) & 0xe000) >> 13
}
func (o *OPAMP_Type) SetOPAMPCTRL_MUXPOS(idx int, value uint32) {
	volatile.StoreUint32(&o.OPAMPCTRL[idx].Reg, volatile.LoadUint32(&o.OPAMPCTRL[idx].Reg)&^(0xf0000)|value<<16)
}
func (o *OPAMP_Type) GetOPAMPCTRL_MUXPOS(idx int) uint32 {
	return (volatile.LoadUint32(&o.OPAMPCTRL[idx].Reg) & 0xf0000) >> 16
}
func (o *OPAMP_Type) SetOPAMPCTRL_MUXNEG(idx int, value uint32) {
	volatile.StoreUint32(&o.OPAMPCTRL[idx].Reg, volatile.LoadUint32(&o.OPAMPCTRL[idx].Reg)&^(0xf00000)|value<<20)
}
func (o *OPAMP_Type) GetOPAMPCTRL_MUXNEG(idx int) uint32 {
	return (volatile.LoadUint32(&o.OPAMPCTRL[idx].Reg) & 0xf00000) >> 20
}

// OPAMP.RESCTRL: Resister Control
func (o *OPAMP_Type) SetRESCTRL_RES2OUT(value uint8) {
	volatile.StoreUint8(&o.RESCTRL.Reg, volatile.LoadUint8(&o.RESCTRL.Reg)&^(0x1)|value)
}
func (o *OPAMP_Type) GetRESCTRL_RES2OUT() uint8 {
	return volatile.LoadUint8(&o.RESCTRL.Reg) & 0x1
}
func (o *OPAMP_Type) SetRESCTRL_RES1EN(value uint8) {
	volatile.StoreUint8(&o.RESCTRL.Reg, volatile.LoadUint8(&o.RESCTRL.Reg)&^(0x2)|value<<1)
}
func (o *OPAMP_Type) GetRESCTRL_RES1EN() uint8 {
	return (volatile.LoadUint8(&o.RESCTRL.Reg) & 0x2) >> 1
}
func (o *OPAMP_Type) SetRESCTRL_RES1MUX(value uint8) {
	volatile.StoreUint8(&o.RESCTRL.Reg, volatile.LoadUint8(&o.RESCTRL.Reg)&^(0x4)|value<<2)
}
func (o *OPAMP_Type) GetRESCTRL_RES1MUX() uint8 {
	return (volatile.LoadUint8(&o.RESCTRL.Reg) & 0x4) >> 2
}
func (o *OPAMP_Type) SetRESCTRL_POTMUX(value uint8) {
	volatile.StoreUint8(&o.RESCTRL.Reg, volatile.LoadUint8(&o.RESCTRL.Reg)&^(0x38)|value<<3)
}
func (o *OPAMP_Type) GetRESCTRL_POTMUX() uint8 {
	return (volatile.LoadUint8(&o.RESCTRL.Reg) & 0x38) >> 3
}
func (o *OPAMP_Type) SetRESCTRL_REFBUFLEVEL(value uint8) {
	volatile.StoreUint8(&o.RESCTRL.Reg, volatile.LoadUint8(&o.RESCTRL.Reg)&^(0xc0)|value<<6)
}
func (o *OPAMP_Type) GetRESCTRL_REFBUFLEVEL() uint8 {
	return (volatile.LoadUint8(&o.RESCTRL.Reg) & 0xc0) >> 6
}

// Oscillators Control
type OSCCTRL_Type struct {
	EVCTRL          volatile.Register8 // 0x0
	_               [3]byte
	INTENCLR        volatile.Register32 // 0x4
	INTENSET        volatile.Register32 // 0x8
	INTFLAG         volatile.Register32 // 0xC
	STATUS          volatile.Register32 // 0x10
	XOSCCTRL        volatile.Register16 // 0x14
	CFDPRESC        volatile.Register8  // 0x16
	_               byte
	OSC16MCTRL      volatile.Register8 // 0x18
	_               [3]byte
	DFLLULPCTRL     volatile.Register16 // 0x1C
	DFLLULPDITHER   volatile.Register8  // 0x1E
	DFLLULPRREQ     volatile.Register8  // 0x1F
	DFLLULPDLY      volatile.Register32 // 0x20
	DFLLULPRATIO    volatile.Register32 // 0x24
	DFLLULPSYNCBUSY volatile.Register32 // 0x28
	DPLLCTRLA       volatile.Register8  // 0x2C
	_               [3]byte
	DPLLRATIO       volatile.Register32 // 0x30
	DPLLCTRLB       volatile.Register32 // 0x34
	DPLLPRESC       volatile.Register8  // 0x38
	_               [3]byte
	DPLLSYNCBUSY    volatile.Register8 // 0x3C
	_               [3]byte
	DPLLSTATUS      volatile.Register8 // 0x40
}

// OSCCTRL.EVCTRL: Event Control
func (o *OSCCTRL_Type) SetEVCTRL_CFDEO(value uint8) {
	volatile.StoreUint8(&o.EVCTRL.Reg, volatile.LoadUint8(&o.EVCTRL.Reg)&^(0x1)|value)
}
func (o *OSCCTRL_Type) GetEVCTRL_CFDEO() uint8 {
	return volatile.LoadUint8(&o.EVCTRL.Reg) & 0x1
}
func (o *OSCCTRL_Type) SetEVCTRL_TUNEEI(value uint8) {
	volatile.StoreUint8(&o.EVCTRL.Reg, volatile.LoadUint8(&o.EVCTRL.Reg)&^(0x2)|value<<1)
}
func (o *OSCCTRL_Type) GetEVCTRL_TUNEEI() uint8 {
	return (volatile.LoadUint8(&o.EVCTRL.Reg) & 0x2) >> 1
}
func (o *OSCCTRL_Type) SetEVCTRL_TUNEINV(value uint8) {
	volatile.StoreUint8(&o.EVCTRL.Reg, volatile.LoadUint8(&o.EVCTRL.Reg)&^(0x4)|value<<2)
}
func (o *OSCCTRL_Type) GetEVCTRL_TUNEINV() uint8 {
	return (volatile.LoadUint8(&o.EVCTRL.Reg) & 0x4) >> 2
}

// OSCCTRL.INTENCLR: Interrupt Enable Clear
func (o *OSCCTRL_Type) SetINTENCLR_XOSCRDY(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *OSCCTRL_Type) GetINTENCLR_XOSCRDY() uint32 {
	return volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1
}
func (o *OSCCTRL_Type) SetINTENCLR_XOSCFAIL(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *OSCCTRL_Type) GetINTENCLR_XOSCFAIL() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *OSCCTRL_Type) SetINTENCLR_OSC16MRDY(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x10)|value<<4)
}
func (o *OSCCTRL_Type) GetINTENCLR_OSC16MRDY() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x10) >> 4
}
func (o *OSCCTRL_Type) SetINTENCLR_DFLLULPRDY(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x100)|value<<8)
}
func (o *OSCCTRL_Type) GetINTENCLR_DFLLULPRDY() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x100) >> 8
}
func (o *OSCCTRL_Type) SetINTENCLR_DFLLULPLOCK(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x200)|value<<9)
}
func (o *OSCCTRL_Type) GetINTENCLR_DFLLULPLOCK() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x200) >> 9
}
func (o *OSCCTRL_Type) SetINTENCLR_DFLLULPNOLOCK(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x400)|value<<10)
}
func (o *OSCCTRL_Type) GetINTENCLR_DFLLULPNOLOCK() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x400) >> 10
}
func (o *OSCCTRL_Type) SetINTENCLR_DPLLLCKR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x10000)|value<<16)
}
func (o *OSCCTRL_Type) GetINTENCLR_DPLLLCKR() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x10000) >> 16
}
func (o *OSCCTRL_Type) SetINTENCLR_DPLLLCKF(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x20000)|value<<17)
}
func (o *OSCCTRL_Type) GetINTENCLR_DPLLLCKF() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x20000) >> 17
}
func (o *OSCCTRL_Type) SetINTENCLR_DPLLLTO(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x40000)|value<<18)
}
func (o *OSCCTRL_Type) GetINTENCLR_DPLLLTO() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x40000) >> 18
}
func (o *OSCCTRL_Type) SetINTENCLR_DPLLLDRTO(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x80000)|value<<19)
}
func (o *OSCCTRL_Type) GetINTENCLR_DPLLLDRTO() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x80000) >> 19
}

// OSCCTRL.INTENSET: Interrupt Enable Set
func (o *OSCCTRL_Type) SetINTENSET_XOSCRDY(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *OSCCTRL_Type) GetINTENSET_XOSCRDY() uint32 {
	return volatile.LoadUint32(&o.INTENSET.Reg) & 0x1
}
func (o *OSCCTRL_Type) SetINTENSET_XOSCFAIL(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *OSCCTRL_Type) GetINTENSET_XOSCFAIL() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *OSCCTRL_Type) SetINTENSET_OSC16MRDY(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x10)|value<<4)
}
func (o *OSCCTRL_Type) GetINTENSET_OSC16MRDY() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x10) >> 4
}
func (o *OSCCTRL_Type) SetINTENSET_DFLLULPRDY(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x100)|value<<8)
}
func (o *OSCCTRL_Type) GetINTENSET_DFLLULPRDY() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x100) >> 8
}
func (o *OSCCTRL_Type) SetINTENSET_DFLLULPLOCK(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x200)|value<<9)
}
func (o *OSCCTRL_Type) GetINTENSET_DFLLULPLOCK() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x200) >> 9
}
func (o *OSCCTRL_Type) SetINTENSET_DFLLULPNOLOCK(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x400)|value<<10)
}
func (o *OSCCTRL_Type) GetINTENSET_DFLLULPNOLOCK() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x400) >> 10
}
func (o *OSCCTRL_Type) SetINTENSET_DPLLLCKR(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x10000)|value<<16)
}
func (o *OSCCTRL_Type) GetINTENSET_DPLLLCKR() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x10000) >> 16
}
func (o *OSCCTRL_Type) SetINTENSET_DPLLLCKF(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x20000)|value<<17)
}
func (o *OSCCTRL_Type) GetINTENSET_DPLLLCKF() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x20000) >> 17
}
func (o *OSCCTRL_Type) SetINTENSET_DPLLLTO(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x40000)|value<<18)
}
func (o *OSCCTRL_Type) GetINTENSET_DPLLLTO() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x40000) >> 18
}
func (o *OSCCTRL_Type) SetINTENSET_DPLLLDRTO(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x80000)|value<<19)
}
func (o *OSCCTRL_Type) GetINTENSET_DPLLLDRTO() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x80000) >> 19
}

// OSCCTRL.INTFLAG: Interrupt Flag Status and Clear
func (o *OSCCTRL_Type) SetINTFLAG_XOSCRDY(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x1)|value)
}
func (o *OSCCTRL_Type) GetINTFLAG_XOSCRDY() uint32 {
	return volatile.LoadUint32(&o.INTFLAG.Reg) & 0x1
}
func (o *OSCCTRL_Type) SetINTFLAG_XOSCFAIL(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x2)|value<<1)
}
func (o *OSCCTRL_Type) GetINTFLAG_XOSCFAIL() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x2) >> 1
}
func (o *OSCCTRL_Type) SetINTFLAG_OSC16MRDY(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x10)|value<<4)
}
func (o *OSCCTRL_Type) GetINTFLAG_OSC16MRDY() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x10) >> 4
}
func (o *OSCCTRL_Type) SetINTFLAG_DFLLULPRDY(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x100)|value<<8)
}
func (o *OSCCTRL_Type) GetINTFLAG_DFLLULPRDY() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x100) >> 8
}
func (o *OSCCTRL_Type) SetINTFLAG_DFLLULPLOCK(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x200)|value<<9)
}
func (o *OSCCTRL_Type) GetINTFLAG_DFLLULPLOCK() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x200) >> 9
}
func (o *OSCCTRL_Type) SetINTFLAG_DFLLULPNOLOCK(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x400)|value<<10)
}
func (o *OSCCTRL_Type) GetINTFLAG_DFLLULPNOLOCK() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x400) >> 10
}
func (o *OSCCTRL_Type) SetINTFLAG_DPLLLCKR(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x10000)|value<<16)
}
func (o *OSCCTRL_Type) GetINTFLAG_DPLLLCKR() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x10000) >> 16
}
func (o *OSCCTRL_Type) SetINTFLAG_DPLLLCKF(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x20000)|value<<17)
}
func (o *OSCCTRL_Type) GetINTFLAG_DPLLLCKF() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x20000) >> 17
}
func (o *OSCCTRL_Type) SetINTFLAG_DPLLLTO(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x40000)|value<<18)
}
func (o *OSCCTRL_Type) GetINTFLAG_DPLLLTO() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x40000) >> 18
}
func (o *OSCCTRL_Type) SetINTFLAG_DPLLLDRTO(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x80000)|value<<19)
}
func (o *OSCCTRL_Type) GetINTFLAG_DPLLLDRTO() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x80000) >> 19
}

// OSCCTRL.STATUS: Status
func (o *OSCCTRL_Type) SetSTATUS_XOSCRDY(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x1)|value)
}
func (o *OSCCTRL_Type) GetSTATUS_XOSCRDY() uint32 {
	return volatile.LoadUint32(&o.STATUS.Reg) & 0x1
}
func (o *OSCCTRL_Type) SetSTATUS_XOSCFAIL(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x2)|value<<1)
}
func (o *OSCCTRL_Type) GetSTATUS_XOSCFAIL() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x2) >> 1
}
func (o *OSCCTRL_Type) SetSTATUS_XOSCCKSW(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x4)|value<<2)
}
func (o *OSCCTRL_Type) GetSTATUS_XOSCCKSW() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x4) >> 2
}
func (o *OSCCTRL_Type) SetSTATUS_OSC16MRDY(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x10)|value<<4)
}
func (o *OSCCTRL_Type) GetSTATUS_OSC16MRDY() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x10) >> 4
}
func (o *OSCCTRL_Type) SetSTATUS_DFLLULPRDY(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x100)|value<<8)
}
func (o *OSCCTRL_Type) GetSTATUS_DFLLULPRDY() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x100) >> 8
}
func (o *OSCCTRL_Type) SetSTATUS_DFLLULPLOCK(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x200)|value<<9)
}
func (o *OSCCTRL_Type) GetSTATUS_DFLLULPLOCK() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x200) >> 9
}
func (o *OSCCTRL_Type) SetSTATUS_DFLLULPNOLOCK(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x400)|value<<10)
}
func (o *OSCCTRL_Type) GetSTATUS_DFLLULPNOLOCK() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x400) >> 10
}
func (o *OSCCTRL_Type) SetSTATUS_DPLLLCKR(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x10000)|value<<16)
}
func (o *OSCCTRL_Type) GetSTATUS_DPLLLCKR() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x10000) >> 16
}
func (o *OSCCTRL_Type) SetSTATUS_DPLLLCKF(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *OSCCTRL_Type) GetSTATUS_DPLLLCKF() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x20000) >> 17
}
func (o *OSCCTRL_Type) SetSTATUS_DPLLTO(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x40000)|value<<18)
}
func (o *OSCCTRL_Type) GetSTATUS_DPLLTO() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x40000) >> 18
}
func (o *OSCCTRL_Type) SetSTATUS_DPLLLDRTO(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x80000)|value<<19)
}
func (o *OSCCTRL_Type) GetSTATUS_DPLLLDRTO() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x80000) >> 19
}

// OSCCTRL.XOSCCTRL: External Multipurpose Crystal Oscillator (XOSC) Control
func (o *OSCCTRL_Type) SetXOSCCTRL_ENABLE(value uint16) {
	volatile.StoreUint16(&o.XOSCCTRL.Reg, volatile.LoadUint16(&o.XOSCCTRL.Reg)&^(0x2)|value<<1)
}
func (o *OSCCTRL_Type) GetXOSCCTRL_ENABLE() uint16 {
	return (volatile.LoadUint16(&o.XOSCCTRL.Reg) & 0x2) >> 1
}
func (o *OSCCTRL_Type) SetXOSCCTRL_XTALEN(value uint16) {
	volatile.StoreUint16(&o.XOSCCTRL.Reg, volatile.LoadUint16(&o.XOSCCTRL.Reg)&^(0x4)|value<<2)
}
func (o *OSCCTRL_Type) GetXOSCCTRL_XTALEN() uint16 {
	return (volatile.LoadUint16(&o.XOSCCTRL.Reg) & 0x4) >> 2
}
func (o *OSCCTRL_Type) SetXOSCCTRL_CFDEN(value uint16) {
	volatile.StoreUint16(&o.XOSCCTRL.Reg, volatile.LoadUint16(&o.XOSCCTRL.Reg)&^(0x8)|value<<3)
}
func (o *OSCCTRL_Type) GetXOSCCTRL_CFDEN() uint16 {
	return (volatile.LoadUint16(&o.XOSCCTRL.Reg) & 0x8) >> 3
}
func (o *OSCCTRL_Type) SetXOSCCTRL_SWBEN(value uint16) {
	volatile.StoreUint16(&o.XOSCCTRL.Reg, volatile.LoadUint16(&o.XOSCCTRL.Reg)&^(0x10)|value<<4)
}
func (o *OSCCTRL_Type) GetXOSCCTRL_SWBEN() uint16 {
	return (volatile.LoadUint16(&o.XOSCCTRL.Reg) & 0x10) >> 4
}
func (o *OSCCTRL_Type) SetXOSCCTRL_RUNSTDBY(value uint16) {
	volatile.StoreUint16(&o.XOSCCTRL.Reg, volatile.LoadUint16(&o.XOSCCTRL.Reg)&^(0x40)|value<<6)
}
func (o *OSCCTRL_Type) GetXOSCCTRL_RUNSTDBY() uint16 {
	return (volatile.LoadUint16(&o.XOSCCTRL.Reg) & 0x40) >> 6
}
func (o *OSCCTRL_Type) SetXOSCCTRL_ONDEMAND(value uint16) {
	volatile.StoreUint16(&o.XOSCCTRL.Reg, volatile.LoadUint16(&o.XOSCCTRL.Reg)&^(0x80)|value<<7)
}
func (o *OSCCTRL_Type) GetXOSCCTRL_ONDEMAND() uint16 {
	return (volatile.LoadUint16(&o.XOSCCTRL.Reg) & 0x80) >> 7
}
func (o *OSCCTRL_Type) SetXOSCCTRL_GAIN(value uint16) {
	volatile.StoreUint16(&o.XOSCCTRL.Reg, volatile.LoadUint16(&o.XOSCCTRL.Reg)&^(0x700)|value<<8)
}
func (o *OSCCTRL_Type) GetXOSCCTRL_GAIN() uint16 {
	return (volatile.LoadUint16(&o.XOSCCTRL.Reg) & 0x700) >> 8
}
func (o *OSCCTRL_Type) SetXOSCCTRL_AMPGC(value uint16) {
	volatile.StoreUint16(&o.XOSCCTRL.Reg, volatile.LoadUint16(&o.XOSCCTRL.Reg)&^(0x800)|value<<11)
}
func (o *OSCCTRL_Type) GetXOSCCTRL_AMPGC() uint16 {
	return (volatile.LoadUint16(&o.XOSCCTRL.Reg) & 0x800) >> 11
}
func (o *OSCCTRL_Type) SetXOSCCTRL_STARTUP(value uint16) {
	volatile.StoreUint16(&o.XOSCCTRL.Reg, volatile.LoadUint16(&o.XOSCCTRL.Reg)&^(0xf000)|value<<12)
}
func (o *OSCCTRL_Type) GetXOSCCTRL_STARTUP() uint16 {
	return (volatile.LoadUint16(&o.XOSCCTRL.Reg) & 0xf000) >> 12
}

// OSCCTRL.CFDPRESC: Clock Failure Detector Prescaler
func (o *OSCCTRL_Type) SetCFDPRESC(value uint8) {
	volatile.StoreUint8(&o.CFDPRESC.Reg, volatile.LoadUint8(&o.CFDPRESC.Reg)&^(0x7)|value)
}
func (o *OSCCTRL_Type) GetCFDPRESC() uint8 {
	return volatile.LoadUint8(&o.CFDPRESC.Reg) & 0x7
}

// OSCCTRL.OSC16MCTRL: 16MHz Internal Oscillator (OSC16M) Control
func (o *OSCCTRL_Type) SetOSC16MCTRL_ENABLE(value uint8) {
	volatile.StoreUint8(&o.OSC16MCTRL.Reg, volatile.LoadUint8(&o.OSC16MCTRL.Reg)&^(0x2)|value<<1)
}
func (o *OSCCTRL_Type) GetOSC16MCTRL_ENABLE() uint8 {
	return (volatile.LoadUint8(&o.OSC16MCTRL.Reg) & 0x2) >> 1
}
func (o *OSCCTRL_Type) SetOSC16MCTRL_FSEL(value uint8) {
	volatile.StoreUint8(&o.OSC16MCTRL.Reg, volatile.LoadUint8(&o.OSC16MCTRL.Reg)&^(0xc)|value<<2)
}
func (o *OSCCTRL_Type) GetOSC16MCTRL_FSEL() uint8 {
	return (volatile.LoadUint8(&o.OSC16MCTRL.Reg) & 0xc) >> 2
}
func (o *OSCCTRL_Type) SetOSC16MCTRL_RUNSTDBY(value uint8) {
	volatile.StoreUint8(&o.OSC16MCTRL.Reg, volatile.LoadUint8(&o.OSC16MCTRL.Reg)&^(0x40)|value<<6)
}
func (o *OSCCTRL_Type) GetOSC16MCTRL_RUNSTDBY() uint8 {
	return (volatile.LoadUint8(&o.OSC16MCTRL.Reg) & 0x40) >> 6
}
func (o *OSCCTRL_Type) SetOSC16MCTRL_ONDEMAND(value uint8) {
	volatile.StoreUint8(&o.OSC16MCTRL.Reg, volatile.LoadUint8(&o.OSC16MCTRL.Reg)&^(0x80)|value<<7)
}
func (o *OSCCTRL_Type) GetOSC16MCTRL_ONDEMAND() uint8 {
	return (volatile.LoadUint8(&o.OSC16MCTRL.Reg) & 0x80) >> 7
}

// OSCCTRL.DFLLULPCTRL: DFLLULP Control
func (o *OSCCTRL_Type) SetDFLLULPCTRL_ENABLE(value uint16) {
	volatile.StoreUint16(&o.DFLLULPCTRL.Reg, volatile.LoadUint16(&o.DFLLULPCTRL.Reg)&^(0x2)|value<<1)
}
func (o *OSCCTRL_Type) GetDFLLULPCTRL_ENABLE() uint16 {
	return (volatile.LoadUint16(&o.DFLLULPCTRL.Reg) & 0x2) >> 1
}
func (o *OSCCTRL_Type) SetDFLLULPCTRL_BINSE(value uint16) {
	volatile.StoreUint16(&o.DFLLULPCTRL.Reg, volatile.LoadUint16(&o.DFLLULPCTRL.Reg)&^(0x8)|value<<3)
}
func (o *OSCCTRL_Type) GetDFLLULPCTRL_BINSE() uint16 {
	return (volatile.LoadUint16(&o.DFLLULPCTRL.Reg) & 0x8) >> 3
}
func (o *OSCCTRL_Type) SetDFLLULPCTRL_SAFE(value uint16) {
	volatile.StoreUint16(&o.DFLLULPCTRL.Reg, volatile.LoadUint16(&o.DFLLULPCTRL.Reg)&^(0x10)|value<<4)
}
func (o *OSCCTRL_Type) GetDFLLULPCTRL_SAFE() uint16 {
	return (volatile.LoadUint16(&o.DFLLULPCTRL.Reg) & 0x10) >> 4
}
func (o *OSCCTRL_Type) SetDFLLULPCTRL_DITHER(value uint16) {
	volatile.StoreUint16(&o.DFLLULPCTRL.Reg, volatile.LoadUint16(&o.DFLLULPCTRL.Reg)&^(0x20)|value<<5)
}
func (o *OSCCTRL_Type) GetDFLLULPCTRL_DITHER() uint16 {
	return (volatile.LoadUint16(&o.DFLLULPCTRL.Reg) & 0x20) >> 5
}
func (o *OSCCTRL_Type) SetDFLLULPCTRL_RUNSTDBY(value uint16) {
	volatile.StoreUint16(&o.DFLLULPCTRL.Reg, volatile.LoadUint16(&o.DFLLULPCTRL.Reg)&^(0x40)|value<<6)
}
func (o *OSCCTRL_Type) GetDFLLULPCTRL_RUNSTDBY() uint16 {
	return (volatile.LoadUint16(&o.DFLLULPCTRL.Reg) & 0x40) >> 6
}
func (o *OSCCTRL_Type) SetDFLLULPCTRL_ONDEMAND(value uint16) {
	volatile.StoreUint16(&o.DFLLULPCTRL.Reg, volatile.LoadUint16(&o.DFLLULPCTRL.Reg)&^(0x80)|value<<7)
}
func (o *OSCCTRL_Type) GetDFLLULPCTRL_ONDEMAND() uint16 {
	return (volatile.LoadUint16(&o.DFLLULPCTRL.Reg) & 0x80) >> 7
}
func (o *OSCCTRL_Type) SetDFLLULPCTRL_DIV(value uint16) {
	volatile.StoreUint16(&o.DFLLULPCTRL.Reg, volatile.LoadUint16(&o.DFLLULPCTRL.Reg)&^(0x700)|value<<8)
}
func (o *OSCCTRL_Type) GetDFLLULPCTRL_DIV() uint16 {
	return (volatile.LoadUint16(&o.DFLLULPCTRL.Reg) & 0x700) >> 8
}

// OSCCTRL.DFLLULPDITHER: DFLLULP Dither Control
func (o *OSCCTRL_Type) SetDFLLULPDITHER_STEP(value uint8) {
	volatile.StoreUint8(&o.DFLLULPDITHER.Reg, volatile.LoadUint8(&o.DFLLULPDITHER.Reg)&^(0x7)|value)
}
func (o *OSCCTRL_Type) GetDFLLULPDITHER_STEP() uint8 {
	return volatile.LoadUint8(&o.DFLLULPDITHER.Reg) & 0x7
}
func (o *OSCCTRL_Type) SetDFLLULPDITHER_PER(value uint8) {
	volatile.StoreUint8(&o.DFLLULPDITHER.Reg, volatile.LoadUint8(&o.DFLLULPDITHER.Reg)&^(0x70)|value<<4)
}
func (o *OSCCTRL_Type) GetDFLLULPDITHER_PER() uint8 {
	return (volatile.LoadUint8(&o.DFLLULPDITHER.Reg) & 0x70) >> 4
}

// OSCCTRL.DFLLULPRREQ: DFLLULP Read Request
func (o *OSCCTRL_Type) SetDFLLULPRREQ_RREQ(value uint8) {
	volatile.StoreUint8(&o.DFLLULPRREQ.Reg, volatile.LoadUint8(&o.DFLLULPRREQ.Reg)&^(0x80)|value<<7)
}
func (o *OSCCTRL_Type) GetDFLLULPRREQ_RREQ() uint8 {
	return (volatile.LoadUint8(&o.DFLLULPRREQ.Reg) & 0x80) >> 7
}

// OSCCTRL.DFLLULPDLY: DFLLULP Delay Value
func (o *OSCCTRL_Type) SetDFLLULPDLY_DELAY(value uint32) {
	volatile.StoreUint32(&o.DFLLULPDLY.Reg, volatile.LoadUint32(&o.DFLLULPDLY.Reg)&^(0xff)|value)
}
func (o *OSCCTRL_Type) GetDFLLULPDLY_DELAY() uint32 {
	return volatile.LoadUint32(&o.DFLLULPDLY.Reg) & 0xff
}

// OSCCTRL.DFLLULPRATIO: DFLLULP Target Ratio
func (o *OSCCTRL_Type) SetDFLLULPRATIO_RATIO(value uint32) {
	volatile.StoreUint32(&o.DFLLULPRATIO.Reg, volatile.LoadUint32(&o.DFLLULPRATIO.Reg)&^(0x7ff)|value)
}
func (o *OSCCTRL_Type) GetDFLLULPRATIO_RATIO() uint32 {
	return volatile.LoadUint32(&o.DFLLULPRATIO.Reg) & 0x7ff
}

// OSCCTRL.DFLLULPSYNCBUSY: DFLLULP Synchronization Busy
func (o *OSCCTRL_Type) SetDFLLULPSYNCBUSY_ENABLE(value uint32) {
	volatile.StoreUint32(&o.DFLLULPSYNCBUSY.Reg, volatile.LoadUint32(&o.DFLLULPSYNCBUSY.Reg)&^(0x2)|value<<1)
}
func (o *OSCCTRL_Type) GetDFLLULPSYNCBUSY_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.DFLLULPSYNCBUSY.Reg) & 0x2) >> 1
}
func (o *OSCCTRL_Type) SetDFLLULPSYNCBUSY_TUNE(value uint32) {
	volatile.StoreUint32(&o.DFLLULPSYNCBUSY.Reg, volatile.LoadUint32(&o.DFLLULPSYNCBUSY.Reg)&^(0x4)|value<<2)
}
func (o *OSCCTRL_Type) GetDFLLULPSYNCBUSY_TUNE() uint32 {
	return (volatile.LoadUint32(&o.DFLLULPSYNCBUSY.Reg) & 0x4) >> 2
}
func (o *OSCCTRL_Type) SetDFLLULPSYNCBUSY_DELAY(value uint32) {
	volatile.StoreUint32(&o.DFLLULPSYNCBUSY.Reg, volatile.LoadUint32(&o.DFLLULPSYNCBUSY.Reg)&^(0x8)|value<<3)
}
func (o *OSCCTRL_Type) GetDFLLULPSYNCBUSY_DELAY() uint32 {
	return (volatile.LoadUint32(&o.DFLLULPSYNCBUSY.Reg) & 0x8) >> 3
}

// OSCCTRL.DPLLCTRLA: DPLL Control A
func (o *OSCCTRL_Type) SetDPLLCTRLA_ENABLE(value uint8) {
	volatile.StoreUint8(&o.DPLLCTRLA.Reg, volatile.LoadUint8(&o.DPLLCTRLA.Reg)&^(0x2)|value<<1)
}
func (o *OSCCTRL_Type) GetDPLLCTRLA_ENABLE() uint8 {
	return (volatile.LoadUint8(&o.DPLLCTRLA.Reg) & 0x2) >> 1
}
func (o *OSCCTRL_Type) SetDPLLCTRLA_RUNSTDBY(value uint8) {
	volatile.StoreUint8(&o.DPLLCTRLA.Reg, volatile.LoadUint8(&o.DPLLCTRLA.Reg)&^(0x40)|value<<6)
}
func (o *OSCCTRL_Type) GetDPLLCTRLA_RUNSTDBY() uint8 {
	return (volatile.LoadUint8(&o.DPLLCTRLA.Reg) & 0x40) >> 6
}
func (o *OSCCTRL_Type) SetDPLLCTRLA_ONDEMAND(value uint8) {
	volatile.StoreUint8(&o.DPLLCTRLA.Reg, volatile.LoadUint8(&o.DPLLCTRLA.Reg)&^(0x80)|value<<7)
}
func (o *OSCCTRL_Type) GetDPLLCTRLA_ONDEMAND() uint8 {
	return (volatile.LoadUint8(&o.DPLLCTRLA.Reg) & 0x80) >> 7
}

// OSCCTRL.DPLLRATIO: DPLL Ratio Control
func (o *OSCCTRL_Type) SetDPLLRATIO_LDR(value uint32) {
	volatile.StoreUint32(&o.DPLLRATIO.Reg, volatile.LoadUint32(&o.DPLLRATIO.Reg)&^(0xfff)|value)
}
func (o *OSCCTRL_Type) GetDPLLRATIO_LDR() uint32 {
	return volatile.LoadUint32(&o.DPLLRATIO.Reg) & 0xfff
}
func (o *OSCCTRL_Type) SetDPLLRATIO_LDRFRAC(value uint32) {
	volatile.StoreUint32(&o.DPLLRATIO.Reg, volatile.LoadUint32(&o.DPLLRATIO.Reg)&^(0xf0000)|value<<16)
}
func (o *OSCCTRL_Type) GetDPLLRATIO_LDRFRAC() uint32 {
	return (volatile.LoadUint32(&o.DPLLRATIO.Reg) & 0xf0000) >> 16
}

// OSCCTRL.DPLLCTRLB: DPLL Control B
func (o *OSCCTRL_Type) SetDPLLCTRLB_FILTER(value uint32) {
	volatile.StoreUint32(&o.DPLLCTRLB.Reg, volatile.LoadUint32(&o.DPLLCTRLB.Reg)&^(0x3)|value)
}
func (o *OSCCTRL_Type) GetDPLLCTRLB_FILTER() uint32 {
	return volatile.LoadUint32(&o.DPLLCTRLB.Reg) & 0x3
}
func (o *OSCCTRL_Type) SetDPLLCTRLB_LPEN(value uint32) {
	volatile.StoreUint32(&o.DPLLCTRLB.Reg, volatile.LoadUint32(&o.DPLLCTRLB.Reg)&^(0x4)|value<<2)
}
func (o *OSCCTRL_Type) GetDPLLCTRLB_LPEN() uint32 {
	return (volatile.LoadUint32(&o.DPLLCTRLB.Reg) & 0x4) >> 2
}
func (o *OSCCTRL_Type) SetDPLLCTRLB_WUF(value uint32) {
	volatile.StoreUint32(&o.DPLLCTRLB.Reg, volatile.LoadUint32(&o.DPLLCTRLB.Reg)&^(0x8)|value<<3)
}
func (o *OSCCTRL_Type) GetDPLLCTRLB_WUF() uint32 {
	return (volatile.LoadUint32(&o.DPLLCTRLB.Reg) & 0x8) >> 3
}
func (o *OSCCTRL_Type) SetDPLLCTRLB_REFCLK(value uint32) {
	volatile.StoreUint32(&o.DPLLCTRLB.Reg, volatile.LoadUint32(&o.DPLLCTRLB.Reg)&^(0x30)|value<<4)
}
func (o *OSCCTRL_Type) GetDPLLCTRLB_REFCLK() uint32 {
	return (volatile.LoadUint32(&o.DPLLCTRLB.Reg) & 0x30) >> 4
}
func (o *OSCCTRL_Type) SetDPLLCTRLB_LTIME(value uint32) {
	volatile.StoreUint32(&o.DPLLCTRLB.Reg, volatile.LoadUint32(&o.DPLLCTRLB.Reg)&^(0x700)|value<<8)
}
func (o *OSCCTRL_Type) GetDPLLCTRLB_LTIME() uint32 {
	return (volatile.LoadUint32(&o.DPLLCTRLB.Reg) & 0x700) >> 8
}
func (o *OSCCTRL_Type) SetDPLLCTRLB_LBYPASS(value uint32) {
	volatile.StoreUint32(&o.DPLLCTRLB.Reg, volatile.LoadUint32(&o.DPLLCTRLB.Reg)&^(0x1000)|value<<12)
}
func (o *OSCCTRL_Type) GetDPLLCTRLB_LBYPASS() uint32 {
	return (volatile.LoadUint32(&o.DPLLCTRLB.Reg) & 0x1000) >> 12
}
func (o *OSCCTRL_Type) SetDPLLCTRLB_DIV(value uint32) {
	volatile.StoreUint32(&o.DPLLCTRLB.Reg, volatile.LoadUint32(&o.DPLLCTRLB.Reg)&^(0x7ff0000)|value<<16)
}
func (o *OSCCTRL_Type) GetDPLLCTRLB_DIV() uint32 {
	return (volatile.LoadUint32(&o.DPLLCTRLB.Reg) & 0x7ff0000) >> 16
}

// OSCCTRL.DPLLPRESC: DPLL Prescaler
func (o *OSCCTRL_Type) SetDPLLPRESC_PRESC(value uint8) {
	volatile.StoreUint8(&o.DPLLPRESC.Reg, volatile.LoadUint8(&o.DPLLPRESC.Reg)&^(0x3)|value)
}
func (o *OSCCTRL_Type) GetDPLLPRESC_PRESC() uint8 {
	return volatile.LoadUint8(&o.DPLLPRESC.Reg) & 0x3
}

// OSCCTRL.DPLLSYNCBUSY: DPLL Synchronization Busy
func (o *OSCCTRL_Type) SetDPLLSYNCBUSY_ENABLE(value uint8) {
	volatile.StoreUint8(&o.DPLLSYNCBUSY.Reg, volatile.LoadUint8(&o.DPLLSYNCBUSY.Reg)&^(0x2)|value<<1)
}
func (o *OSCCTRL_Type) GetDPLLSYNCBUSY_ENABLE() uint8 {
	return (volatile.LoadUint8(&o.DPLLSYNCBUSY.Reg) & 0x2) >> 1
}
func (o *OSCCTRL_Type) SetDPLLSYNCBUSY_DPLLRATIO(value uint8) {
	volatile.StoreUint8(&o.DPLLSYNCBUSY.Reg, volatile.LoadUint8(&o.DPLLSYNCBUSY.Reg)&^(0x4)|value<<2)
}
func (o *OSCCTRL_Type) GetDPLLSYNCBUSY_DPLLRATIO() uint8 {
	return (volatile.LoadUint8(&o.DPLLSYNCBUSY.Reg) & 0x4) >> 2
}
func (o *OSCCTRL_Type) SetDPLLSYNCBUSY_DPLLPRESC(value uint8) {
	volatile.StoreUint8(&o.DPLLSYNCBUSY.Reg, volatile.LoadUint8(&o.DPLLSYNCBUSY.Reg)&^(0x8)|value<<3)
}
func (o *OSCCTRL_Type) GetDPLLSYNCBUSY_DPLLPRESC() uint8 {
	return (volatile.LoadUint8(&o.DPLLSYNCBUSY.Reg) & 0x8) >> 3
}

// OSCCTRL.DPLLSTATUS: DPLL Status
func (o *OSCCTRL_Type) SetDPLLSTATUS_LOCK(value uint8) {
	volatile.StoreUint8(&o.DPLLSTATUS.Reg, volatile.LoadUint8(&o.DPLLSTATUS.Reg)&^(0x1)|value)
}
func (o *OSCCTRL_Type) GetDPLLSTATUS_LOCK() uint8 {
	return volatile.LoadUint8(&o.DPLLSTATUS.Reg) & 0x1
}
func (o *OSCCTRL_Type) SetDPLLSTATUS_CLKRDY(value uint8) {
	volatile.StoreUint8(&o.DPLLSTATUS.Reg, volatile.LoadUint8(&o.DPLLSTATUS.Reg)&^(0x2)|value<<1)
}
func (o *OSCCTRL_Type) GetDPLLSTATUS_CLKRDY() uint8 {
	return (volatile.LoadUint8(&o.DPLLSTATUS.Reg) & 0x2) >> 1
}

// 32k Oscillators Control
type OSC32KCTRL_Type struct {
	INTENCLR  volatile.Register32 // 0x0
	INTENSET  volatile.Register32 // 0x4
	INTFLAG   volatile.Register32 // 0x8
	STATUS    volatile.Register32 // 0xC
	RTCCTRL   volatile.Register8  // 0x10
	_         [3]byte
	XOSC32K   volatile.Register16 // 0x14
	CFDCTRL   volatile.Register8  // 0x16
	EVCTRL    volatile.Register8  // 0x17
	_         [4]byte
	OSCULP32K volatile.Register32 // 0x1C
}

// OSC32KCTRL.INTENCLR: Interrupt Enable Clear
func (o *OSC32KCTRL_Type) SetINTENCLR_XOSC32KRDY(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *OSC32KCTRL_Type) GetINTENCLR_XOSC32KRDY() uint32 {
	return volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1
}
func (o *OSC32KCTRL_Type) SetINTENCLR_CLKFAIL(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *OSC32KCTRL_Type) GetINTENCLR_CLKFAIL() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4) >> 2
}

// OSC32KCTRL.INTENSET: Interrupt Enable Set
func (o *OSC32KCTRL_Type) SetINTENSET_XOSC32KRDY(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *OSC32KCTRL_Type) GetINTENSET_XOSC32KRDY() uint32 {
	return volatile.LoadUint32(&o.INTENSET.Reg) & 0x1
}
func (o *OSC32KCTRL_Type) SetINTENSET_CLKFAIL(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *OSC32KCTRL_Type) GetINTENSET_CLKFAIL() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4) >> 2
}

// OSC32KCTRL.INTFLAG: Interrupt Flag Status and Clear
func (o *OSC32KCTRL_Type) SetINTFLAG_XOSC32KRDY(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x1)|value)
}
func (o *OSC32KCTRL_Type) GetINTFLAG_XOSC32KRDY() uint32 {
	return volatile.LoadUint32(&o.INTFLAG.Reg) & 0x1
}
func (o *OSC32KCTRL_Type) SetINTFLAG_CLKFAIL(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x4)|value<<2)
}
func (o *OSC32KCTRL_Type) GetINTFLAG_CLKFAIL() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x4) >> 2
}

// OSC32KCTRL.STATUS: Power and Clocks Status
func (o *OSC32KCTRL_Type) SetSTATUS_XOSC32KRDY(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x1)|value)
}
func (o *OSC32KCTRL_Type) GetSTATUS_XOSC32KRDY() uint32 {
	return volatile.LoadUint32(&o.STATUS.Reg) & 0x1
}
func (o *OSC32KCTRL_Type) SetSTATUS_CLKFAIL(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x4)|value<<2)
}
func (o *OSC32KCTRL_Type) GetSTATUS_CLKFAIL() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x4) >> 2
}
func (o *OSC32KCTRL_Type) SetSTATUS_CLKSW(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x8)|value<<3)
}
func (o *OSC32KCTRL_Type) GetSTATUS_CLKSW() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x8) >> 3
}
func (o *OSC32KCTRL_Type) SetSTATUS_ULP32KSW(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x10)|value<<4)
}
func (o *OSC32KCTRL_Type) GetSTATUS_ULP32KSW() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x10) >> 4
}

// OSC32KCTRL.RTCCTRL: RTC Clock Selection
func (o *OSC32KCTRL_Type) SetRTCCTRL_RTCSEL(value uint8) {
	volatile.StoreUint8(&o.RTCCTRL.Reg, volatile.LoadUint8(&o.RTCCTRL.Reg)&^(0x7)|value)
}
func (o *OSC32KCTRL_Type) GetRTCCTRL_RTCSEL() uint8 {
	return volatile.LoadUint8(&o.RTCCTRL.Reg) & 0x7
}

// OSC32KCTRL.XOSC32K: 32kHz External Crystal Oscillator (XOSC32K) Control
func (o *OSC32KCTRL_Type) SetXOSC32K_ENABLE(value uint16) {
	volatile.StoreUint16(&o.XOSC32K.Reg, volatile.LoadUint16(&o.XOSC32K.Reg)&^(0x2)|value<<1)
}
func (o *OSC32KCTRL_Type) GetXOSC32K_ENABLE() uint16 {
	return (volatile.LoadUint16(&o.XOSC32K.Reg) & 0x2) >> 1
}
func (o *OSC32KCTRL_Type) SetXOSC32K_XTALEN(value uint16) {
	volatile.StoreUint16(&o.XOSC32K.Reg, volatile.LoadUint16(&o.XOSC32K.Reg)&^(0x4)|value<<2)
}
func (o *OSC32KCTRL_Type) GetXOSC32K_XTALEN() uint16 {
	return (volatile.LoadUint16(&o.XOSC32K.Reg) & 0x4) >> 2
}
func (o *OSC32KCTRL_Type) SetXOSC32K_EN32K(value uint16) {
	volatile.StoreUint16(&o.XOSC32K.Reg, volatile.LoadUint16(&o.XOSC32K.Reg)&^(0x8)|value<<3)
}
func (o *OSC32KCTRL_Type) GetXOSC32K_EN32K() uint16 {
	return (volatile.LoadUint16(&o.XOSC32K.Reg) & 0x8) >> 3
}
func (o *OSC32KCTRL_Type) SetXOSC32K_EN1K(value uint16) {
	volatile.StoreUint16(&o.XOSC32K.Reg, volatile.LoadUint16(&o.XOSC32K.Reg)&^(0x10)|value<<4)
}
func (o *OSC32KCTRL_Type) GetXOSC32K_EN1K() uint16 {
	return (volatile.LoadUint16(&o.XOSC32K.Reg) & 0x10) >> 4
}
func (o *OSC32KCTRL_Type) SetXOSC32K_RUNSTDBY(value uint16) {
	volatile.StoreUint16(&o.XOSC32K.Reg, volatile.LoadUint16(&o.XOSC32K.Reg)&^(0x40)|value<<6)
}
func (o *OSC32KCTRL_Type) GetXOSC32K_RUNSTDBY() uint16 {
	return (volatile.LoadUint16(&o.XOSC32K.Reg) & 0x40) >> 6
}
func (o *OSC32KCTRL_Type) SetXOSC32K_ONDEMAND(value uint16) {
	volatile.StoreUint16(&o.XOSC32K.Reg, volatile.LoadUint16(&o.XOSC32K.Reg)&^(0x80)|value<<7)
}
func (o *OSC32KCTRL_Type) GetXOSC32K_ONDEMAND() uint16 {
	return (volatile.LoadUint16(&o.XOSC32K.Reg) & 0x80) >> 7
}
func (o *OSC32KCTRL_Type) SetXOSC32K_STARTUP(value uint16) {
	volatile.StoreUint16(&o.XOSC32K.Reg, volatile.LoadUint16(&o.XOSC32K.Reg)&^(0x700)|value<<8)
}
func (o *OSC32KCTRL_Type) GetXOSC32K_STARTUP() uint16 {
	return (volatile.LoadUint16(&o.XOSC32K.Reg) & 0x700) >> 8
}
func (o *OSC32KCTRL_Type) SetXOSC32K_WRTLOCK(value uint16) {
	volatile.StoreUint16(&o.XOSC32K.Reg, volatile.LoadUint16(&o.XOSC32K.Reg)&^(0x1000)|value<<12)
}
func (o *OSC32KCTRL_Type) GetXOSC32K_WRTLOCK() uint16 {
	return (volatile.LoadUint16(&o.XOSC32K.Reg) & 0x1000) >> 12
}

// OSC32KCTRL.CFDCTRL: Clock Failure Detector Control
func (o *OSC32KCTRL_Type) SetCFDCTRL_CFDEN(value uint8) {
	volatile.StoreUint8(&o.CFDCTRL.Reg, volatile.LoadUint8(&o.CFDCTRL.Reg)&^(0x1)|value)
}
func (o *OSC32KCTRL_Type) GetCFDCTRL_CFDEN() uint8 {
	return volatile.LoadUint8(&o.CFDCTRL.Reg) & 0x1
}
func (o *OSC32KCTRL_Type) SetCFDCTRL_SWBACK(value uint8) {
	volatile.StoreUint8(&o.CFDCTRL.Reg, volatile.LoadUint8(&o.CFDCTRL.Reg)&^(0x2)|value<<1)
}
func (o *OSC32KCTRL_Type) GetCFDCTRL_SWBACK() uint8 {
	return (volatile.LoadUint8(&o.CFDCTRL.Reg) & 0x2) >> 1
}
func (o *OSC32KCTRL_Type) SetCFDCTRL_CFDPRESC(value uint8) {
	volatile.StoreUint8(&o.CFDCTRL.Reg, volatile.LoadUint8(&o.CFDCTRL.Reg)&^(0x4)|value<<2)
}
func (o *OSC32KCTRL_Type) GetCFDCTRL_CFDPRESC() uint8 {
	return (volatile.LoadUint8(&o.CFDCTRL.Reg) & 0x4) >> 2
}

// OSC32KCTRL.EVCTRL: Event Control
func (o *OSC32KCTRL_Type) SetEVCTRL_CFDEO(value uint8) {
	volatile.StoreUint8(&o.EVCTRL.Reg, volatile.LoadUint8(&o.EVCTRL.Reg)&^(0x1)|value)
}
func (o *OSC32KCTRL_Type) GetEVCTRL_CFDEO() uint8 {
	return volatile.LoadUint8(&o.EVCTRL.Reg) & 0x1
}

// OSC32KCTRL.OSCULP32K: 32kHz Ultra Low Power Internal Oscillator (OSCULP32K) Control
func (o *OSC32KCTRL_Type) SetOSCULP32K_ULP32KSW(value uint32) {
	volatile.StoreUint32(&o.OSCULP32K.Reg, volatile.LoadUint32(&o.OSCULP32K.Reg)&^(0x20)|value<<5)
}
func (o *OSC32KCTRL_Type) GetOSCULP32K_ULP32KSW() uint32 {
	return (volatile.LoadUint32(&o.OSCULP32K.Reg) & 0x20) >> 5
}
func (o *OSC32KCTRL_Type) SetOSCULP32K_CALIB(value uint32) {
	volatile.StoreUint32(&o.OSCULP32K.Reg, volatile.LoadUint32(&o.OSCULP32K.Reg)&^(0x1f00)|value<<8)
}
func (o *OSC32KCTRL_Type) GetOSCULP32K_CALIB() uint32 {
	return (volatile.LoadUint32(&o.OSCULP32K.Reg) & 0x1f00) >> 8
}
func (o *OSC32KCTRL_Type) SetOSCULP32K_WRTLOCK(value uint32) {
	volatile.StoreUint32(&o.OSCULP32K.Reg, volatile.LoadUint32(&o.OSCULP32K.Reg)&^(0x8000)|value<<15)
}
func (o *OSC32KCTRL_Type) GetOSCULP32K_WRTLOCK() uint32 {
	return (volatile.LoadUint32(&o.OSCULP32K.Reg) & 0x8000) >> 15
}

// Peripheral Access Controller
type PAC_Type struct {
	WRCTRL     volatile.Register32 // 0x0
	EVCTRL     volatile.Register8  // 0x4
	_          [3]byte
	INTENCLR   volatile.Register8 // 0x8
	INTENSET   volatile.Register8 // 0x9
	_          [6]byte
	INTFLAGAHB volatile.Register32 // 0x10
	INTFLAGA   volatile.Register32 // 0x14
	INTFLAGB   volatile.Register32 // 0x18
	INTFLAGC   volatile.Register32 // 0x1C
	_          [20]byte
	STATUSA    volatile.Register32 // 0x34
	STATUSB    volatile.Register32 // 0x38
	STATUSC    volatile.Register32 // 0x3C
	_          [20]byte
	NONSECA    volatile.Register32 // 0x54
	NONSECB    volatile.Register32 // 0x58
	NONSECC    volatile.Register32 // 0x5C
	_          [20]byte
	SECLOCKA   volatile.Register32 // 0x74
	SECLOCKB   volatile.Register32 // 0x78
	SECLOCKC   volatile.Register32 // 0x7C
}

// PAC.WRCTRL: Write control
func (o *PAC_Type) SetWRCTRL_PERID(value uint32) {
	volatile.StoreUint32(&o.WRCTRL.Reg, volatile.LoadUint32(&o.WRCTRL.Reg)&^(0xffff)|value)
}
func (o *PAC_Type) GetWRCTRL_PERID() uint32 {
	return volatile.LoadUint32(&o.WRCTRL.Reg) & 0xffff
}
func (o *PAC_Type) SetWRCTRL_KEY(value uint32) {
	volatile.StoreUint32(&o.WRCTRL.Reg, volatile.LoadUint32(&o.WRCTRL.Reg)&^(0xff0000)|value<<16)
}
func (o *PAC_Type) GetWRCTRL_KEY() uint32 {
	return (volatile.LoadUint32(&o.WRCTRL.Reg) & 0xff0000) >> 16
}

// PAC.EVCTRL: Event control
func (o *PAC_Type) SetEVCTRL_ERREO(value uint8) {
	volatile.StoreUint8(&o.EVCTRL.Reg, volatile.LoadUint8(&o.EVCTRL.Reg)&^(0x1)|value)
}
func (o *PAC_Type) GetEVCTRL_ERREO() uint8 {
	return volatile.LoadUint8(&o.EVCTRL.Reg) & 0x1
}

// PAC.INTENCLR: Interrupt enable clear
func (o *PAC_Type) SetINTENCLR_ERR(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *PAC_Type) GetINTENCLR_ERR() uint8 {
	return volatile.LoadUint8(&o.INTENCLR.Reg) & 0x1
}

// PAC.INTENSET: Interrupt enable set
func (o *PAC_Type) SetINTENSET_ERR(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *PAC_Type) GetINTENSET_ERR() uint8 {
	return volatile.LoadUint8(&o.INTENSET.Reg) & 0x1
}

// PAC.INTFLAGAHB: Bridge interrupt flag status
func (o *PAC_Type) SetINTFLAGAHB_FLASH_(value uint32) {
	volatile.StoreUint32(&o.INTFLAGAHB.Reg, volatile.LoadUint32(&o.INTFLAGAHB.Reg)&^(0x1)|value)
}
func (o *PAC_Type) GetINTFLAGAHB_FLASH_() uint32 {
	return volatile.LoadUint32(&o.INTFLAGAHB.Reg) & 0x1
}
func (o *PAC_Type) SetINTFLAGAHB_HPB0_(value uint32) {
	volatile.StoreUint32(&o.INTFLAGAHB.Reg, volatile.LoadUint32(&o.INTFLAGAHB.Reg)&^(0x2)|value<<1)
}
func (o *PAC_Type) GetINTFLAGAHB_HPB0_() uint32 {
	return (volatile.LoadUint32(&o.INTFLAGAHB.Reg) & 0x2) >> 1
}
func (o *PAC_Type) SetINTFLAGAHB_HPB1_(value uint32) {
	volatile.StoreUint32(&o.INTFLAGAHB.Reg, volatile.LoadUint32(&o.INTFLAGAHB.Reg)&^(0x4)|value<<2)
}
func (o *PAC_Type) GetINTFLAGAHB_HPB1_() uint32 {
	return (volatile.LoadUint32(&o.INTFLAGAHB.Reg) & 0x4) >> 2
}
func (o *PAC_Type) SetINTFLAGAHB_HPB2_(value uint32) {
	volatile.StoreUint32(&o.INTFLAGAHB.Reg, volatile.LoadUint32(&o.INTFLAGAHB.Reg)&^(0x8)|value<<3)
}
func (o *PAC_Type) GetINTFLAGAHB_HPB2_() uint32 {
	return (volatile.LoadUint32(&o.INTFLAGAHB.Reg) & 0x8) >> 3
}
func (o *PAC_Type) SetINTFLAGAHB_HSRAMCPU_(value uint32) {
	volatile.StoreUint32(&o.INTFLAGAHB.Reg, volatile.LoadUint32(&o.INTFLAGAHB.Reg)&^(0x10)|value<<4)
}
func (o *PAC_Type) GetINTFLAGAHB_HSRAMCPU_() uint32 {
	return (volatile.LoadUint32(&o.INTFLAGAHB.Reg) & 0x10) >> 4
}
func (o *PAC_Type) SetINTFLAGAHB_HSRAMDMAC_(value uint32) {
	volatile.StoreUint32(&o.INTFLAGAHB.Reg, volatile.LoadUint32(&o.INTFLAGAHB.Reg)&^(0x20)|value<<5)
}
func (o *PAC_Type) GetINTFLAGAHB_HSRAMDMAC_() uint32 {
	return (volatile.LoadUint32(&o.INTFLAGAHB.Reg) & 0x20) >> 5
}
func (o *PAC_Type) SetINTFLAGAHB_HSRAMDSU_(value uint32) {
	volatile.StoreUint32(&o.INTFLAGAHB.Reg, volatile.LoadUint32(&o.INTFLAGAHB.Reg)&^(0x40)|value<<6)
}
func (o *PAC_Type) GetINTFLAGAHB_HSRAMDSU_() uint32 {
	return (volatile.LoadUint32(&o.INTFLAGAHB.Reg) & 0x40) >> 6
}

// PAC.INTFLAGA: Peripheral interrupt flag status - Bridge A
func (o *PAC_Type) SetINTFLAGA_PAC_(value uint32) {
	volatile.StoreUint32(&o.INTFLAGA.Reg, volatile.LoadUint32(&o.INTFLAGA.Reg)&^(0x1)|value)
}
func (o *PAC_Type) GetINTFLAGA_PAC_() uint32 {
	return volatile.LoadUint32(&o.INTFLAGA.Reg) & 0x1
}
func (o *PAC_Type) SetINTFLAGA_PM_(value uint32) {
	volatile.StoreUint32(&o.INTFLAGA.Reg, volatile.LoadUint32(&o.INTFLAGA.Reg)&^(0x2)|value<<1)
}
func (o *PAC_Type) GetINTFLAGA_PM_() uint32 {
	return (volatile.LoadUint32(&o.INTFLAGA.Reg) & 0x2) >> 1
}
func (o *PAC_Type) SetINTFLAGA_MCLK_(value uint32) {
	volatile.StoreUint32(&o.INTFLAGA.Reg, volatile.LoadUint32(&o.INTFLAGA.Reg)&^(0x4)|value<<2)
}
func (o *PAC_Type) GetINTFLAGA_MCLK_() uint32 {
	return (volatile.LoadUint32(&o.INTFLAGA.Reg) & 0x4) >> 2
}
func (o *PAC_Type) SetINTFLAGA_RSTC_(value uint32) {
	volatile.StoreUint32(&o.INTFLAGA.Reg, volatile.LoadUint32(&o.INTFLAGA.Reg)&^(0x8)|value<<3)
}
func (o *PAC_Type) GetINTFLAGA_RSTC_() uint32 {
	return (volatile.LoadUint32(&o.INTFLAGA.Reg) & 0x8) >> 3
}
func (o *PAC_Type) SetINTFLAGA_OSCCTRL_(value uint32) {
	volatile.StoreUint32(&o.INTFLAGA.Reg, volatile.LoadUint32(&o.INTFLAGA.Reg)&^(0x10)|value<<4)
}
func (o *PAC_Type) GetINTFLAGA_OSCCTRL_() uint32 {
	return (volatile.LoadUint32(&o.INTFLAGA.Reg) & 0x10) >> 4
}
func (o *PAC_Type) SetINTFLAGA_OSC32KCTRL_(value uint32) {
	volatile.StoreUint32(&o.INTFLAGA.Reg, volatile.LoadUint32(&o.INTFLAGA.Reg)&^(0x20)|value<<5)
}
func (o *PAC_Type) GetINTFLAGA_OSC32KCTRL_() uint32 {
	return (volatile.LoadUint32(&o.INTFLAGA.Reg) & 0x20) >> 5
}
func (o *PAC_Type) SetINTFLAGA_SUPC_(value uint32) {
	volatile.StoreUint32(&o.INTFLAGA.Reg, volatile.LoadUint32(&o.INTFLAGA.Reg)&^(0x40)|value<<6)
}
func (o *PAC_Type) GetINTFLAGA_SUPC_() uint32 {
	return (volatile.LoadUint32(&o.INTFLAGA.Reg) & 0x40) >> 6
}
func (o *PAC_Type) SetINTFLAGA_GCLK_(value uint32) {
	volatile.StoreUint32(&o.INTFLAGA.Reg, volatile.LoadUint32(&o.INTFLAGA.Reg)&^(0x80)|value<<7)
}
func (o *PAC_Type) GetINTFLAGA_GCLK_() uint32 {
	return (volatile.LoadUint32(&o.INTFLAGA.Reg) & 0x80) >> 7
}
func (o *PAC_Type) SetINTFLAGA_WDT_(value uint32) {
	volatile.StoreUint32(&o.INTFLAGA.Reg, volatile.LoadUint32(&o.INTFLAGA.Reg)&^(0x100)|value<<8)
}
func (o *PAC_Type) GetINTFLAGA_WDT_() uint32 {
	return (volatile.LoadUint32(&o.INTFLAGA.Reg) & 0x100) >> 8
}
func (o *PAC_Type) SetINTFLAGA_RTC_(value uint32) {
	volatile.StoreUint32(&o.INTFLAGA.Reg, volatile.LoadUint32(&o.INTFLAGA.Reg)&^(0x200)|value<<9)
}
func (o *PAC_Type) GetINTFLAGA_RTC_() uint32 {
	return (volatile.LoadUint32(&o.INTFLAGA.Reg) & 0x200) >> 9
}
func (o *PAC_Type) SetINTFLAGA_EIC_(value uint32) {
	volatile.StoreUint32(&o.INTFLAGA.Reg, volatile.LoadUint32(&o.INTFLAGA.Reg)&^(0x400)|value<<10)
}
func (o *PAC_Type) GetINTFLAGA_EIC_() uint32 {
	return (volatile.LoadUint32(&o.INTFLAGA.Reg) & 0x400) >> 10
}
func (o *PAC_Type) SetINTFLAGA_FREQM_(value uint32) {
	volatile.StoreUint32(&o.INTFLAGA.Reg, volatile.LoadUint32(&o.INTFLAGA.Reg)&^(0x800)|value<<11)
}
func (o *PAC_Type) GetINTFLAGA_FREQM_() uint32 {
	return (volatile.LoadUint32(&o.INTFLAGA.Reg) & 0x800) >> 11
}
func (o *PAC_Type) SetINTFLAGA_PORT_(value uint32) {
	volatile.StoreUint32(&o.INTFLAGA.Reg, volatile.LoadUint32(&o.INTFLAGA.Reg)&^(0x1000)|value<<12)
}
func (o *PAC_Type) GetINTFLAGA_PORT_() uint32 {
	return (volatile.LoadUint32(&o.INTFLAGA.Reg) & 0x1000) >> 12
}
func (o *PAC_Type) SetINTFLAGA_AC_(value uint32) {
	volatile.StoreUint32(&o.INTFLAGA.Reg, volatile.LoadUint32(&o.INTFLAGA.Reg)&^(0x2000)|value<<13)
}
func (o *PAC_Type) GetINTFLAGA_AC_() uint32 {
	return (volatile.LoadUint32(&o.INTFLAGA.Reg) & 0x2000) >> 13
}

// PAC.INTFLAGB: Peripheral interrupt flag status - Bridge B
func (o *PAC_Type) SetINTFLAGB_IDAU_(value uint32) {
	volatile.StoreUint32(&o.INTFLAGB.Reg, volatile.LoadUint32(&o.INTFLAGB.Reg)&^(0x1)|value)
}
func (o *PAC_Type) GetINTFLAGB_IDAU_() uint32 {
	return volatile.LoadUint32(&o.INTFLAGB.Reg) & 0x1
}
func (o *PAC_Type) SetINTFLAGB_DSU_(value uint32) {
	volatile.StoreUint32(&o.INTFLAGB.Reg, volatile.LoadUint32(&o.INTFLAGB.Reg)&^(0x2)|value<<1)
}
func (o *PAC_Type) GetINTFLAGB_DSU_() uint32 {
	return (volatile.LoadUint32(&o.INTFLAGB.Reg) & 0x2) >> 1
}
func (o *PAC_Type) SetINTFLAGB_NVMCTRL_(value uint32) {
	volatile.StoreUint32(&o.INTFLAGB.Reg, volatile.LoadUint32(&o.INTFLAGB.Reg)&^(0x4)|value<<2)
}
func (o *PAC_Type) GetINTFLAGB_NVMCTRL_() uint32 {
	return (volatile.LoadUint32(&o.INTFLAGB.Reg) & 0x4) >> 2
}
func (o *PAC_Type) SetINTFLAGB_DMAC_(value uint32) {
	volatile.StoreUint32(&o.INTFLAGB.Reg, volatile.LoadUint32(&o.INTFLAGB.Reg)&^(0x8)|value<<3)
}
func (o *PAC_Type) GetINTFLAGB_DMAC_() uint32 {
	return (volatile.LoadUint32(&o.INTFLAGB.Reg) & 0x8) >> 3
}

// PAC.INTFLAGC: Peripheral interrupt flag status - Bridge C
func (o *PAC_Type) SetINTFLAGC_EVSYS_(value uint32) {
	volatile.StoreUint32(&o.INTFLAGC.Reg, volatile.LoadUint32(&o.INTFLAGC.Reg)&^(0x1)|value)
}
func (o *PAC_Type) GetINTFLAGC_EVSYS_() uint32 {
	return volatile.LoadUint32(&o.INTFLAGC.Reg) & 0x1
}
func (o *PAC_Type) SetINTFLAGC_SERCOM0_(value uint32) {
	volatile.StoreUint32(&o.INTFLAGC.Reg, volatile.LoadUint32(&o.INTFLAGC.Reg)&^(0x2)|value<<1)
}
func (o *PAC_Type) GetINTFLAGC_SERCOM0_() uint32 {
	return (volatile.LoadUint32(&o.INTFLAGC.Reg) & 0x2) >> 1
}
func (o *PAC_Type) SetINTFLAGC_SERCOM1_(value uint32) {
	volatile.StoreUint32(&o.INTFLAGC.Reg, volatile.LoadUint32(&o.INTFLAGC.Reg)&^(0x4)|value<<2)
}
func (o *PAC_Type) GetINTFLAGC_SERCOM1_() uint32 {
	return (volatile.LoadUint32(&o.INTFLAGC.Reg) & 0x4) >> 2
}
func (o *PAC_Type) SetINTFLAGC_TC0_(value uint32) {
	volatile.StoreUint32(&o.INTFLAGC.Reg, volatile.LoadUint32(&o.INTFLAGC.Reg)&^(0x10)|value<<4)
}
func (o *PAC_Type) GetINTFLAGC_TC0_() uint32 {
	return (volatile.LoadUint32(&o.INTFLAGC.Reg) & 0x10) >> 4
}
func (o *PAC_Type) SetINTFLAGC_TC1_(value uint32) {
	volatile.StoreUint32(&o.INTFLAGC.Reg, volatile.LoadUint32(&o.INTFLAGC.Reg)&^(0x20)|value<<5)
}
func (o *PAC_Type) GetINTFLAGC_TC1_() uint32 {
	return (volatile.LoadUint32(&o.INTFLAGC.Reg) & 0x20) >> 5
}
func (o *PAC_Type) SetINTFLAGC_TC2_(value uint32) {
	volatile.StoreUint32(&o.INTFLAGC.Reg, volatile.LoadUint32(&o.INTFLAGC.Reg)&^(0x40)|value<<6)
}
func (o *PAC_Type) GetINTFLAGC_TC2_() uint32 {
	return (volatile.LoadUint32(&o.INTFLAGC.Reg) & 0x40) >> 6
}
func (o *PAC_Type) SetINTFLAGC_ADC_(value uint32) {
	volatile.StoreUint32(&o.INTFLAGC.Reg, volatile.LoadUint32(&o.INTFLAGC.Reg)&^(0x80)|value<<7)
}
func (o *PAC_Type) GetINTFLAGC_ADC_() uint32 {
	return (volatile.LoadUint32(&o.INTFLAGC.Reg) & 0x80) >> 7
}
func (o *PAC_Type) SetINTFLAGC_DAC_(value uint32) {
	volatile.StoreUint32(&o.INTFLAGC.Reg, volatile.LoadUint32(&o.INTFLAGC.Reg)&^(0x100)|value<<8)
}
func (o *PAC_Type) GetINTFLAGC_DAC_() uint32 {
	return (volatile.LoadUint32(&o.INTFLAGC.Reg) & 0x100) >> 8
}
func (o *PAC_Type) SetINTFLAGC_PTC_(value uint32) {
	volatile.StoreUint32(&o.INTFLAGC.Reg, volatile.LoadUint32(&o.INTFLAGC.Reg)&^(0x200)|value<<9)
}
func (o *PAC_Type) GetINTFLAGC_PTC_() uint32 {
	return (volatile.LoadUint32(&o.INTFLAGC.Reg) & 0x200) >> 9
}
func (o *PAC_Type) SetINTFLAGC_TRNG_(value uint32) {
	volatile.StoreUint32(&o.INTFLAGC.Reg, volatile.LoadUint32(&o.INTFLAGC.Reg)&^(0x400)|value<<10)
}
func (o *PAC_Type) GetINTFLAGC_TRNG_() uint32 {
	return (volatile.LoadUint32(&o.INTFLAGC.Reg) & 0x400) >> 10
}
func (o *PAC_Type) SetINTFLAGC_CCL_(value uint32) {
	volatile.StoreUint32(&o.INTFLAGC.Reg, volatile.LoadUint32(&o.INTFLAGC.Reg)&^(0x800)|value<<11)
}
func (o *PAC_Type) GetINTFLAGC_CCL_() uint32 {
	return (volatile.LoadUint32(&o.INTFLAGC.Reg) & 0x800) >> 11
}
func (o *PAC_Type) SetINTFLAGC_OPAMP_(value uint32) {
	volatile.StoreUint32(&o.INTFLAGC.Reg, volatile.LoadUint32(&o.INTFLAGC.Reg)&^(0x1000)|value<<12)
}
func (o *PAC_Type) GetINTFLAGC_OPAMP_() uint32 {
	return (volatile.LoadUint32(&o.INTFLAGC.Reg) & 0x1000) >> 12
}
func (o *PAC_Type) SetINTFLAGC_TRAM_(value uint32) {
	volatile.StoreUint32(&o.INTFLAGC.Reg, volatile.LoadUint32(&o.INTFLAGC.Reg)&^(0x2000)|value<<13)
}
func (o *PAC_Type) GetINTFLAGC_TRAM_() uint32 {
	return (volatile.LoadUint32(&o.INTFLAGC.Reg) & 0x2000) >> 13
}

// PAC.STATUSA: Peripheral write protection status - Bridge A
func (o *PAC_Type) SetSTATUSA_PAC_(value uint32) {
	volatile.StoreUint32(&o.STATUSA.Reg, volatile.LoadUint32(&o.STATUSA.Reg)&^(0x1)|value)
}
func (o *PAC_Type) GetSTATUSA_PAC_() uint32 {
	return volatile.LoadUint32(&o.STATUSA.Reg) & 0x1
}
func (o *PAC_Type) SetSTATUSA_PM_(value uint32) {
	volatile.StoreUint32(&o.STATUSA.Reg, volatile.LoadUint32(&o.STATUSA.Reg)&^(0x2)|value<<1)
}
func (o *PAC_Type) GetSTATUSA_PM_() uint32 {
	return (volatile.LoadUint32(&o.STATUSA.Reg) & 0x2) >> 1
}
func (o *PAC_Type) SetSTATUSA_MCLK_(value uint32) {
	volatile.StoreUint32(&o.STATUSA.Reg, volatile.LoadUint32(&o.STATUSA.Reg)&^(0x4)|value<<2)
}
func (o *PAC_Type) GetSTATUSA_MCLK_() uint32 {
	return (volatile.LoadUint32(&o.STATUSA.Reg) & 0x4) >> 2
}
func (o *PAC_Type) SetSTATUSA_RSTC_(value uint32) {
	volatile.StoreUint32(&o.STATUSA.Reg, volatile.LoadUint32(&o.STATUSA.Reg)&^(0x8)|value<<3)
}
func (o *PAC_Type) GetSTATUSA_RSTC_() uint32 {
	return (volatile.LoadUint32(&o.STATUSA.Reg) & 0x8) >> 3
}
func (o *PAC_Type) SetSTATUSA_OSCCTRL_(value uint32) {
	volatile.StoreUint32(&o.STATUSA.Reg, volatile.LoadUint32(&o.STATUSA.Reg)&^(0x10)|value<<4)
}
func (o *PAC_Type) GetSTATUSA_OSCCTRL_() uint32 {
	return (volatile.LoadUint32(&o.STATUSA.Reg) & 0x10) >> 4
}
func (o *PAC_Type) SetSTATUSA_OSC32KCTRL_(value uint32) {
	volatile.StoreUint32(&o.STATUSA.Reg, volatile.LoadUint32(&o.STATUSA.Reg)&^(0x20)|value<<5)
}
func (o *PAC_Type) GetSTATUSA_OSC32KCTRL_() uint32 {
	return (volatile.LoadUint32(&o.STATUSA.Reg) & 0x20) >> 5
}
func (o *PAC_Type) SetSTATUSA_SUPC_(value uint32) {
	volatile.StoreUint32(&o.STATUSA.Reg, volatile.LoadUint32(&o.STATUSA.Reg)&^(0x40)|value<<6)
}
func (o *PAC_Type) GetSTATUSA_SUPC_() uint32 {
	return (volatile.LoadUint32(&o.STATUSA.Reg) & 0x40) >> 6
}
func (o *PAC_Type) SetSTATUSA_GCLK_(value uint32) {
	volatile.StoreUint32(&o.STATUSA.Reg, volatile.LoadUint32(&o.STATUSA.Reg)&^(0x80)|value<<7)
}
func (o *PAC_Type) GetSTATUSA_GCLK_() uint32 {
	return (volatile.LoadUint32(&o.STATUSA.Reg) & 0x80) >> 7
}
func (o *PAC_Type) SetSTATUSA_WDT_(value uint32) {
	volatile.StoreUint32(&o.STATUSA.Reg, volatile.LoadUint32(&o.STATUSA.Reg)&^(0x100)|value<<8)
}
func (o *PAC_Type) GetSTATUSA_WDT_() uint32 {
	return (volatile.LoadUint32(&o.STATUSA.Reg) & 0x100) >> 8
}
func (o *PAC_Type) SetSTATUSA_RTC_(value uint32) {
	volatile.StoreUint32(&o.STATUSA.Reg, volatile.LoadUint32(&o.STATUSA.Reg)&^(0x200)|value<<9)
}
func (o *PAC_Type) GetSTATUSA_RTC_() uint32 {
	return (volatile.LoadUint32(&o.STATUSA.Reg) & 0x200) >> 9
}
func (o *PAC_Type) SetSTATUSA_EIC_(value uint32) {
	volatile.StoreUint32(&o.STATUSA.Reg, volatile.LoadUint32(&o.STATUSA.Reg)&^(0x400)|value<<10)
}
func (o *PAC_Type) GetSTATUSA_EIC_() uint32 {
	return (volatile.LoadUint32(&o.STATUSA.Reg) & 0x400) >> 10
}
func (o *PAC_Type) SetSTATUSA_FREQM_(value uint32) {
	volatile.StoreUint32(&o.STATUSA.Reg, volatile.LoadUint32(&o.STATUSA.Reg)&^(0x800)|value<<11)
}
func (o *PAC_Type) GetSTATUSA_FREQM_() uint32 {
	return (volatile.LoadUint32(&o.STATUSA.Reg) & 0x800) >> 11
}
func (o *PAC_Type) SetSTATUSA_PORT_(value uint32) {
	volatile.StoreUint32(&o.STATUSA.Reg, volatile.LoadUint32(&o.STATUSA.Reg)&^(0x1000)|value<<12)
}
func (o *PAC_Type) GetSTATUSA_PORT_() uint32 {
	return (volatile.LoadUint32(&o.STATUSA.Reg) & 0x1000) >> 12
}
func (o *PAC_Type) SetSTATUSA_AC_(value uint32) {
	volatile.StoreUint32(&o.STATUSA.Reg, volatile.LoadUint32(&o.STATUSA.Reg)&^(0x2000)|value<<13)
}
func (o *PAC_Type) GetSTATUSA_AC_() uint32 {
	return (volatile.LoadUint32(&o.STATUSA.Reg) & 0x2000) >> 13
}

// PAC.STATUSB: Peripheral write protection status - Bridge B
func (o *PAC_Type) SetSTATUSB_IDAU_(value uint32) {
	volatile.StoreUint32(&o.STATUSB.Reg, volatile.LoadUint32(&o.STATUSB.Reg)&^(0x1)|value)
}
func (o *PAC_Type) GetSTATUSB_IDAU_() uint32 {
	return volatile.LoadUint32(&o.STATUSB.Reg) & 0x1
}
func (o *PAC_Type) SetSTATUSB_DSU_(value uint32) {
	volatile.StoreUint32(&o.STATUSB.Reg, volatile.LoadUint32(&o.STATUSB.Reg)&^(0x2)|value<<1)
}
func (o *PAC_Type) GetSTATUSB_DSU_() uint32 {
	return (volatile.LoadUint32(&o.STATUSB.Reg) & 0x2) >> 1
}
func (o *PAC_Type) SetSTATUSB_NVMCTRL_(value uint32) {
	volatile.StoreUint32(&o.STATUSB.Reg, volatile.LoadUint32(&o.STATUSB.Reg)&^(0x4)|value<<2)
}
func (o *PAC_Type) GetSTATUSB_NVMCTRL_() uint32 {
	return (volatile.LoadUint32(&o.STATUSB.Reg) & 0x4) >> 2
}
func (o *PAC_Type) SetSTATUSB_DMAC_(value uint32) {
	volatile.StoreUint32(&o.STATUSB.Reg, volatile.LoadUint32(&o.STATUSB.Reg)&^(0x8)|value<<3)
}
func (o *PAC_Type) GetSTATUSB_DMAC_() uint32 {
	return (volatile.LoadUint32(&o.STATUSB.Reg) & 0x8) >> 3
}

// PAC.STATUSC: Peripheral write protection status - Bridge C
func (o *PAC_Type) SetSTATUSC_EVSYS_(value uint32) {
	volatile.StoreUint32(&o.STATUSC.Reg, volatile.LoadUint32(&o.STATUSC.Reg)&^(0x1)|value)
}
func (o *PAC_Type) GetSTATUSC_EVSYS_() uint32 {
	return volatile.LoadUint32(&o.STATUSC.Reg) & 0x1
}
func (o *PAC_Type) SetSTATUSC_SERCOM0_(value uint32) {
	volatile.StoreUint32(&o.STATUSC.Reg, volatile.LoadUint32(&o.STATUSC.Reg)&^(0x2)|value<<1)
}
func (o *PAC_Type) GetSTATUSC_SERCOM0_() uint32 {
	return (volatile.LoadUint32(&o.STATUSC.Reg) & 0x2) >> 1
}
func (o *PAC_Type) SetSTATUSC_SERCOM1_(value uint32) {
	volatile.StoreUint32(&o.STATUSC.Reg, volatile.LoadUint32(&o.STATUSC.Reg)&^(0x4)|value<<2)
}
func (o *PAC_Type) GetSTATUSC_SERCOM1_() uint32 {
	return (volatile.LoadUint32(&o.STATUSC.Reg) & 0x4) >> 2
}
func (o *PAC_Type) SetSTATUSC_TC0_(value uint32) {
	volatile.StoreUint32(&o.STATUSC.Reg, volatile.LoadUint32(&o.STATUSC.Reg)&^(0x10)|value<<4)
}
func (o *PAC_Type) GetSTATUSC_TC0_() uint32 {
	return (volatile.LoadUint32(&o.STATUSC.Reg) & 0x10) >> 4
}
func (o *PAC_Type) SetSTATUSC_TC1_(value uint32) {
	volatile.StoreUint32(&o.STATUSC.Reg, volatile.LoadUint32(&o.STATUSC.Reg)&^(0x20)|value<<5)
}
func (o *PAC_Type) GetSTATUSC_TC1_() uint32 {
	return (volatile.LoadUint32(&o.STATUSC.Reg) & 0x20) >> 5
}
func (o *PAC_Type) SetSTATUSC_TC2_(value uint32) {
	volatile.StoreUint32(&o.STATUSC.Reg, volatile.LoadUint32(&o.STATUSC.Reg)&^(0x40)|value<<6)
}
func (o *PAC_Type) GetSTATUSC_TC2_() uint32 {
	return (volatile.LoadUint32(&o.STATUSC.Reg) & 0x40) >> 6
}
func (o *PAC_Type) SetSTATUSC_ADC_(value uint32) {
	volatile.StoreUint32(&o.STATUSC.Reg, volatile.LoadUint32(&o.STATUSC.Reg)&^(0x80)|value<<7)
}
func (o *PAC_Type) GetSTATUSC_ADC_() uint32 {
	return (volatile.LoadUint32(&o.STATUSC.Reg) & 0x80) >> 7
}
func (o *PAC_Type) SetSTATUSC_DAC_(value uint32) {
	volatile.StoreUint32(&o.STATUSC.Reg, volatile.LoadUint32(&o.STATUSC.Reg)&^(0x100)|value<<8)
}
func (o *PAC_Type) GetSTATUSC_DAC_() uint32 {
	return (volatile.LoadUint32(&o.STATUSC.Reg) & 0x100) >> 8
}
func (o *PAC_Type) SetSTATUSC_PTC_(value uint32) {
	volatile.StoreUint32(&o.STATUSC.Reg, volatile.LoadUint32(&o.STATUSC.Reg)&^(0x200)|value<<9)
}
func (o *PAC_Type) GetSTATUSC_PTC_() uint32 {
	return (volatile.LoadUint32(&o.STATUSC.Reg) & 0x200) >> 9
}
func (o *PAC_Type) SetSTATUSC_TRNG_(value uint32) {
	volatile.StoreUint32(&o.STATUSC.Reg, volatile.LoadUint32(&o.STATUSC.Reg)&^(0x400)|value<<10)
}
func (o *PAC_Type) GetSTATUSC_TRNG_() uint32 {
	return (volatile.LoadUint32(&o.STATUSC.Reg) & 0x400) >> 10
}
func (o *PAC_Type) SetSTATUSC_CCL_(value uint32) {
	volatile.StoreUint32(&o.STATUSC.Reg, volatile.LoadUint32(&o.STATUSC.Reg)&^(0x800)|value<<11)
}
func (o *PAC_Type) GetSTATUSC_CCL_() uint32 {
	return (volatile.LoadUint32(&o.STATUSC.Reg) & 0x800) >> 11
}
func (o *PAC_Type) SetSTATUSC_OPAMP_(value uint32) {
	volatile.StoreUint32(&o.STATUSC.Reg, volatile.LoadUint32(&o.STATUSC.Reg)&^(0x1000)|value<<12)
}
func (o *PAC_Type) GetSTATUSC_OPAMP_() uint32 {
	return (volatile.LoadUint32(&o.STATUSC.Reg) & 0x1000) >> 12
}
func (o *PAC_Type) SetSTATUSC_TRAM_(value uint32) {
	volatile.StoreUint32(&o.STATUSC.Reg, volatile.LoadUint32(&o.STATUSC.Reg)&^(0x2000)|value<<13)
}
func (o *PAC_Type) GetSTATUSC_TRAM_() uint32 {
	return (volatile.LoadUint32(&o.STATUSC.Reg) & 0x2000) >> 13
}

// PAC.NONSECA: Peripheral non-secure status - Bridge A
func (o *PAC_Type) SetNONSECA_PAC_(value uint32) {
	volatile.StoreUint32(&o.NONSECA.Reg, volatile.LoadUint32(&o.NONSECA.Reg)&^(0x1)|value)
}
func (o *PAC_Type) GetNONSECA_PAC_() uint32 {
	return volatile.LoadUint32(&o.NONSECA.Reg) & 0x1
}
func (o *PAC_Type) SetNONSECA_PM_(value uint32) {
	volatile.StoreUint32(&o.NONSECA.Reg, volatile.LoadUint32(&o.NONSECA.Reg)&^(0x2)|value<<1)
}
func (o *PAC_Type) GetNONSECA_PM_() uint32 {
	return (volatile.LoadUint32(&o.NONSECA.Reg) & 0x2) >> 1
}
func (o *PAC_Type) SetNONSECA_MCLK_(value uint32) {
	volatile.StoreUint32(&o.NONSECA.Reg, volatile.LoadUint32(&o.NONSECA.Reg)&^(0x4)|value<<2)
}
func (o *PAC_Type) GetNONSECA_MCLK_() uint32 {
	return (volatile.LoadUint32(&o.NONSECA.Reg) & 0x4) >> 2
}
func (o *PAC_Type) SetNONSECA_RSTC_(value uint32) {
	volatile.StoreUint32(&o.NONSECA.Reg, volatile.LoadUint32(&o.NONSECA.Reg)&^(0x8)|value<<3)
}
func (o *PAC_Type) GetNONSECA_RSTC_() uint32 {
	return (volatile.LoadUint32(&o.NONSECA.Reg) & 0x8) >> 3
}
func (o *PAC_Type) SetNONSECA_OSCCTRL_(value uint32) {
	volatile.StoreUint32(&o.NONSECA.Reg, volatile.LoadUint32(&o.NONSECA.Reg)&^(0x10)|value<<4)
}
func (o *PAC_Type) GetNONSECA_OSCCTRL_() uint32 {
	return (volatile.LoadUint32(&o.NONSECA.Reg) & 0x10) >> 4
}
func (o *PAC_Type) SetNONSECA_OSC32KCTRL_(value uint32) {
	volatile.StoreUint32(&o.NONSECA.Reg, volatile.LoadUint32(&o.NONSECA.Reg)&^(0x20)|value<<5)
}
func (o *PAC_Type) GetNONSECA_OSC32KCTRL_() uint32 {
	return (volatile.LoadUint32(&o.NONSECA.Reg) & 0x20) >> 5
}
func (o *PAC_Type) SetNONSECA_SUPC_(value uint32) {
	volatile.StoreUint32(&o.NONSECA.Reg, volatile.LoadUint32(&o.NONSECA.Reg)&^(0x40)|value<<6)
}
func (o *PAC_Type) GetNONSECA_SUPC_() uint32 {
	return (volatile.LoadUint32(&o.NONSECA.Reg) & 0x40) >> 6
}
func (o *PAC_Type) SetNONSECA_GCLK_(value uint32) {
	volatile.StoreUint32(&o.NONSECA.Reg, volatile.LoadUint32(&o.NONSECA.Reg)&^(0x80)|value<<7)
}
func (o *PAC_Type) GetNONSECA_GCLK_() uint32 {
	return (volatile.LoadUint32(&o.NONSECA.Reg) & 0x80) >> 7
}
func (o *PAC_Type) SetNONSECA_WDT_(value uint32) {
	volatile.StoreUint32(&o.NONSECA.Reg, volatile.LoadUint32(&o.NONSECA.Reg)&^(0x100)|value<<8)
}
func (o *PAC_Type) GetNONSECA_WDT_() uint32 {
	return (volatile.LoadUint32(&o.NONSECA.Reg) & 0x100) >> 8
}
func (o *PAC_Type) SetNONSECA_RTC_(value uint32) {
	volatile.StoreUint32(&o.NONSECA.Reg, volatile.LoadUint32(&o.NONSECA.Reg)&^(0x200)|value<<9)
}
func (o *PAC_Type) GetNONSECA_RTC_() uint32 {
	return (volatile.LoadUint32(&o.NONSECA.Reg) & 0x200) >> 9
}
func (o *PAC_Type) SetNONSECA_EIC_(value uint32) {
	volatile.StoreUint32(&o.NONSECA.Reg, volatile.LoadUint32(&o.NONSECA.Reg)&^(0x400)|value<<10)
}
func (o *PAC_Type) GetNONSECA_EIC_() uint32 {
	return (volatile.LoadUint32(&o.NONSECA.Reg) & 0x400) >> 10
}
func (o *PAC_Type) SetNONSECA_FREQM_(value uint32) {
	volatile.StoreUint32(&o.NONSECA.Reg, volatile.LoadUint32(&o.NONSECA.Reg)&^(0x800)|value<<11)
}
func (o *PAC_Type) GetNONSECA_FREQM_() uint32 {
	return (volatile.LoadUint32(&o.NONSECA.Reg) & 0x800) >> 11
}
func (o *PAC_Type) SetNONSECA_PORT_(value uint32) {
	volatile.StoreUint32(&o.NONSECA.Reg, volatile.LoadUint32(&o.NONSECA.Reg)&^(0x1000)|value<<12)
}
func (o *PAC_Type) GetNONSECA_PORT_() uint32 {
	return (volatile.LoadUint32(&o.NONSECA.Reg) & 0x1000) >> 12
}
func (o *PAC_Type) SetNONSECA_AC_(value uint32) {
	volatile.StoreUint32(&o.NONSECA.Reg, volatile.LoadUint32(&o.NONSECA.Reg)&^(0x2000)|value<<13)
}
func (o *PAC_Type) GetNONSECA_AC_() uint32 {
	return (volatile.LoadUint32(&o.NONSECA.Reg) & 0x2000) >> 13
}

// PAC.NONSECB: Peripheral non-secure status - Bridge B
func (o *PAC_Type) SetNONSECB_IDAU_(value uint32) {
	volatile.StoreUint32(&o.NONSECB.Reg, volatile.LoadUint32(&o.NONSECB.Reg)&^(0x1)|value)
}
func (o *PAC_Type) GetNONSECB_IDAU_() uint32 {
	return volatile.LoadUint32(&o.NONSECB.Reg) & 0x1
}
func (o *PAC_Type) SetNONSECB_DSU_(value uint32) {
	volatile.StoreUint32(&o.NONSECB.Reg, volatile.LoadUint32(&o.NONSECB.Reg)&^(0x2)|value<<1)
}
func (o *PAC_Type) GetNONSECB_DSU_() uint32 {
	return (volatile.LoadUint32(&o.NONSECB.Reg) & 0x2) >> 1
}
func (o *PAC_Type) SetNONSECB_NVMCTRL_(value uint32) {
	volatile.StoreUint32(&o.NONSECB.Reg, volatile.LoadUint32(&o.NONSECB.Reg)&^(0x4)|value<<2)
}
func (o *PAC_Type) GetNONSECB_NVMCTRL_() uint32 {
	return (volatile.LoadUint32(&o.NONSECB.Reg) & 0x4) >> 2
}
func (o *PAC_Type) SetNONSECB_DMAC_(value uint32) {
	volatile.StoreUint32(&o.NONSECB.Reg, volatile.LoadUint32(&o.NONSECB.Reg)&^(0x8)|value<<3)
}
func (o *PAC_Type) GetNONSECB_DMAC_() uint32 {
	return (volatile.LoadUint32(&o.NONSECB.Reg) & 0x8) >> 3
}

// PAC.NONSECC: Peripheral non-secure status - Bridge C
func (o *PAC_Type) SetNONSECC_EVSYS_(value uint32) {
	volatile.StoreUint32(&o.NONSECC.Reg, volatile.LoadUint32(&o.NONSECC.Reg)&^(0x1)|value)
}
func (o *PAC_Type) GetNONSECC_EVSYS_() uint32 {
	return volatile.LoadUint32(&o.NONSECC.Reg) & 0x1
}
func (o *PAC_Type) SetNONSECC_SERCOM0_(value uint32) {
	volatile.StoreUint32(&o.NONSECC.Reg, volatile.LoadUint32(&o.NONSECC.Reg)&^(0x2)|value<<1)
}
func (o *PAC_Type) GetNONSECC_SERCOM0_() uint32 {
	return (volatile.LoadUint32(&o.NONSECC.Reg) & 0x2) >> 1
}
func (o *PAC_Type) SetNONSECC_SERCOM1_(value uint32) {
	volatile.StoreUint32(&o.NONSECC.Reg, volatile.LoadUint32(&o.NONSECC.Reg)&^(0x4)|value<<2)
}
func (o *PAC_Type) GetNONSECC_SERCOM1_() uint32 {
	return (volatile.LoadUint32(&o.NONSECC.Reg) & 0x4) >> 2
}
func (o *PAC_Type) SetNONSECC_TC0_(value uint32) {
	volatile.StoreUint32(&o.NONSECC.Reg, volatile.LoadUint32(&o.NONSECC.Reg)&^(0x10)|value<<4)
}
func (o *PAC_Type) GetNONSECC_TC0_() uint32 {
	return (volatile.LoadUint32(&o.NONSECC.Reg) & 0x10) >> 4
}
func (o *PAC_Type) SetNONSECC_TC1_(value uint32) {
	volatile.StoreUint32(&o.NONSECC.Reg, volatile.LoadUint32(&o.NONSECC.Reg)&^(0x20)|value<<5)
}
func (o *PAC_Type) GetNONSECC_TC1_() uint32 {
	return (volatile.LoadUint32(&o.NONSECC.Reg) & 0x20) >> 5
}
func (o *PAC_Type) SetNONSECC_TC2_(value uint32) {
	volatile.StoreUint32(&o.NONSECC.Reg, volatile.LoadUint32(&o.NONSECC.Reg)&^(0x40)|value<<6)
}
func (o *PAC_Type) GetNONSECC_TC2_() uint32 {
	return (volatile.LoadUint32(&o.NONSECC.Reg) & 0x40) >> 6
}
func (o *PAC_Type) SetNONSECC_ADC_(value uint32) {
	volatile.StoreUint32(&o.NONSECC.Reg, volatile.LoadUint32(&o.NONSECC.Reg)&^(0x80)|value<<7)
}
func (o *PAC_Type) GetNONSECC_ADC_() uint32 {
	return (volatile.LoadUint32(&o.NONSECC.Reg) & 0x80) >> 7
}
func (o *PAC_Type) SetNONSECC_DAC_(value uint32) {
	volatile.StoreUint32(&o.NONSECC.Reg, volatile.LoadUint32(&o.NONSECC.Reg)&^(0x100)|value<<8)
}
func (o *PAC_Type) GetNONSECC_DAC_() uint32 {
	return (volatile.LoadUint32(&o.NONSECC.Reg) & 0x100) >> 8
}
func (o *PAC_Type) SetNONSECC_PTC_(value uint32) {
	volatile.StoreUint32(&o.NONSECC.Reg, volatile.LoadUint32(&o.NONSECC.Reg)&^(0x200)|value<<9)
}
func (o *PAC_Type) GetNONSECC_PTC_() uint32 {
	return (volatile.LoadUint32(&o.NONSECC.Reg) & 0x200) >> 9
}
func (o *PAC_Type) SetNONSECC_TRNG_(value uint32) {
	volatile.StoreUint32(&o.NONSECC.Reg, volatile.LoadUint32(&o.NONSECC.Reg)&^(0x400)|value<<10)
}
func (o *PAC_Type) GetNONSECC_TRNG_() uint32 {
	return (volatile.LoadUint32(&o.NONSECC.Reg) & 0x400) >> 10
}
func (o *PAC_Type) SetNONSECC_CCL_(value uint32) {
	volatile.StoreUint32(&o.NONSECC.Reg, volatile.LoadUint32(&o.NONSECC.Reg)&^(0x800)|value<<11)
}
func (o *PAC_Type) GetNONSECC_CCL_() uint32 {
	return (volatile.LoadUint32(&o.NONSECC.Reg) & 0x800) >> 11
}
func (o *PAC_Type) SetNONSECC_OPAMP_(value uint32) {
	volatile.StoreUint32(&o.NONSECC.Reg, volatile.LoadUint32(&o.NONSECC.Reg)&^(0x1000)|value<<12)
}
func (o *PAC_Type) GetNONSECC_OPAMP_() uint32 {
	return (volatile.LoadUint32(&o.NONSECC.Reg) & 0x1000) >> 12
}
func (o *PAC_Type) SetNONSECC_TRAM_(value uint32) {
	volatile.StoreUint32(&o.NONSECC.Reg, volatile.LoadUint32(&o.NONSECC.Reg)&^(0x2000)|value<<13)
}
func (o *PAC_Type) GetNONSECC_TRAM_() uint32 {
	return (volatile.LoadUint32(&o.NONSECC.Reg) & 0x2000) >> 13
}

// PAC.SECLOCKA: Peripheral secure status locked - Bridge A
func (o *PAC_Type) SetSECLOCKA_PAC_(value uint32) {
	volatile.StoreUint32(&o.SECLOCKA.Reg, volatile.LoadUint32(&o.SECLOCKA.Reg)&^(0x1)|value)
}
func (o *PAC_Type) GetSECLOCKA_PAC_() uint32 {
	return volatile.LoadUint32(&o.SECLOCKA.Reg) & 0x1
}
func (o *PAC_Type) SetSECLOCKA_PM_(value uint32) {
	volatile.StoreUint32(&o.SECLOCKA.Reg, volatile.LoadUint32(&o.SECLOCKA.Reg)&^(0x2)|value<<1)
}
func (o *PAC_Type) GetSECLOCKA_PM_() uint32 {
	return (volatile.LoadUint32(&o.SECLOCKA.Reg) & 0x2) >> 1
}
func (o *PAC_Type) SetSECLOCKA_MCLK_(value uint32) {
	volatile.StoreUint32(&o.SECLOCKA.Reg, volatile.LoadUint32(&o.SECLOCKA.Reg)&^(0x4)|value<<2)
}
func (o *PAC_Type) GetSECLOCKA_MCLK_() uint32 {
	return (volatile.LoadUint32(&o.SECLOCKA.Reg) & 0x4) >> 2
}
func (o *PAC_Type) SetSECLOCKA_RSTC_(value uint32) {
	volatile.StoreUint32(&o.SECLOCKA.Reg, volatile.LoadUint32(&o.SECLOCKA.Reg)&^(0x8)|value<<3)
}
func (o *PAC_Type) GetSECLOCKA_RSTC_() uint32 {
	return (volatile.LoadUint32(&o.SECLOCKA.Reg) & 0x8) >> 3
}
func (o *PAC_Type) SetSECLOCKA_OSCCTRL_(value uint32) {
	volatile.StoreUint32(&o.SECLOCKA.Reg, volatile.LoadUint32(&o.SECLOCKA.Reg)&^(0x10)|value<<4)
}
func (o *PAC_Type) GetSECLOCKA_OSCCTRL_() uint32 {
	return (volatile.LoadUint32(&o.SECLOCKA.Reg) & 0x10) >> 4
}
func (o *PAC_Type) SetSECLOCKA_OSC32KCTRL_(value uint32) {
	volatile.StoreUint32(&o.SECLOCKA.Reg, volatile.LoadUint32(&o.SECLOCKA.Reg)&^(0x20)|value<<5)
}
func (o *PAC_Type) GetSECLOCKA_OSC32KCTRL_() uint32 {
	return (volatile.LoadUint32(&o.SECLOCKA.Reg) & 0x20) >> 5
}
func (o *PAC_Type) SetSECLOCKA_SUPC_(value uint32) {
	volatile.StoreUint32(&o.SECLOCKA.Reg, volatile.LoadUint32(&o.SECLOCKA.Reg)&^(0x40)|value<<6)
}
func (o *PAC_Type) GetSECLOCKA_SUPC_() uint32 {
	return (volatile.LoadUint32(&o.SECLOCKA.Reg) & 0x40) >> 6
}
func (o *PAC_Type) SetSECLOCKA_GCLK_(value uint32) {
	volatile.StoreUint32(&o.SECLOCKA.Reg, volatile.LoadUint32(&o.SECLOCKA.Reg)&^(0x80)|value<<7)
}
func (o *PAC_Type) GetSECLOCKA_GCLK_() uint32 {
	return (volatile.LoadUint32(&o.SECLOCKA.Reg) & 0x80) >> 7
}
func (o *PAC_Type) SetSECLOCKA_WDT_(value uint32) {
	volatile.StoreUint32(&o.SECLOCKA.Reg, volatile.LoadUint32(&o.SECLOCKA.Reg)&^(0x100)|value<<8)
}
func (o *PAC_Type) GetSECLOCKA_WDT_() uint32 {
	return (volatile.LoadUint32(&o.SECLOCKA.Reg) & 0x100) >> 8
}
func (o *PAC_Type) SetSECLOCKA_RTC_(value uint32) {
	volatile.StoreUint32(&o.SECLOCKA.Reg, volatile.LoadUint32(&o.SECLOCKA.Reg)&^(0x200)|value<<9)
}
func (o *PAC_Type) GetSECLOCKA_RTC_() uint32 {
	return (volatile.LoadUint32(&o.SECLOCKA.Reg) & 0x200) >> 9
}
func (o *PAC_Type) SetSECLOCKA_EIC_(value uint32) {
	volatile.StoreUint32(&o.SECLOCKA.Reg, volatile.LoadUint32(&o.SECLOCKA.Reg)&^(0x400)|value<<10)
}
func (o *PAC_Type) GetSECLOCKA_EIC_() uint32 {
	return (volatile.LoadUint32(&o.SECLOCKA.Reg) & 0x400) >> 10
}
func (o *PAC_Type) SetSECLOCKA_FREQM_(value uint32) {
	volatile.StoreUint32(&o.SECLOCKA.Reg, volatile.LoadUint32(&o.SECLOCKA.Reg)&^(0x800)|value<<11)
}
func (o *PAC_Type) GetSECLOCKA_FREQM_() uint32 {
	return (volatile.LoadUint32(&o.SECLOCKA.Reg) & 0x800) >> 11
}
func (o *PAC_Type) SetSECLOCKA_PORT_(value uint32) {
	volatile.StoreUint32(&o.SECLOCKA.Reg, volatile.LoadUint32(&o.SECLOCKA.Reg)&^(0x1000)|value<<12)
}
func (o *PAC_Type) GetSECLOCKA_PORT_() uint32 {
	return (volatile.LoadUint32(&o.SECLOCKA.Reg) & 0x1000) >> 12
}
func (o *PAC_Type) SetSECLOCKA_AC_(value uint32) {
	volatile.StoreUint32(&o.SECLOCKA.Reg, volatile.LoadUint32(&o.SECLOCKA.Reg)&^(0x2000)|value<<13)
}
func (o *PAC_Type) GetSECLOCKA_AC_() uint32 {
	return (volatile.LoadUint32(&o.SECLOCKA.Reg) & 0x2000) >> 13
}

// PAC.SECLOCKB: Peripheral secure status locked - Bridge B
func (o *PAC_Type) SetSECLOCKB_IDAU_(value uint32) {
	volatile.StoreUint32(&o.SECLOCKB.Reg, volatile.LoadUint32(&o.SECLOCKB.Reg)&^(0x1)|value)
}
func (o *PAC_Type) GetSECLOCKB_IDAU_() uint32 {
	return volatile.LoadUint32(&o.SECLOCKB.Reg) & 0x1
}
func (o *PAC_Type) SetSECLOCKB_DSU_(value uint32) {
	volatile.StoreUint32(&o.SECLOCKB.Reg, volatile.LoadUint32(&o.SECLOCKB.Reg)&^(0x2)|value<<1)
}
func (o *PAC_Type) GetSECLOCKB_DSU_() uint32 {
	return (volatile.LoadUint32(&o.SECLOCKB.Reg) & 0x2) >> 1
}
func (o *PAC_Type) SetSECLOCKB_NVMCTRL_(value uint32) {
	volatile.StoreUint32(&o.SECLOCKB.Reg, volatile.LoadUint32(&o.SECLOCKB.Reg)&^(0x4)|value<<2)
}
func (o *PAC_Type) GetSECLOCKB_NVMCTRL_() uint32 {
	return (volatile.LoadUint32(&o.SECLOCKB.Reg) & 0x4) >> 2
}
func (o *PAC_Type) SetSECLOCKB_DMAC_(value uint32) {
	volatile.StoreUint32(&o.SECLOCKB.Reg, volatile.LoadUint32(&o.SECLOCKB.Reg)&^(0x8)|value<<3)
}
func (o *PAC_Type) GetSECLOCKB_DMAC_() uint32 {
	return (volatile.LoadUint32(&o.SECLOCKB.Reg) & 0x8) >> 3
}

// PAC.SECLOCKC: Peripheral secure status locked - Bridge C
func (o *PAC_Type) SetSECLOCKC_EVSYS_(value uint32) {
	volatile.StoreUint32(&o.SECLOCKC.Reg, volatile.LoadUint32(&o.SECLOCKC.Reg)&^(0x1)|value)
}
func (o *PAC_Type) GetSECLOCKC_EVSYS_() uint32 {
	return volatile.LoadUint32(&o.SECLOCKC.Reg) & 0x1
}
func (o *PAC_Type) SetSECLOCKC_SERCOM0_(value uint32) {
	volatile.StoreUint32(&o.SECLOCKC.Reg, volatile.LoadUint32(&o.SECLOCKC.Reg)&^(0x2)|value<<1)
}
func (o *PAC_Type) GetSECLOCKC_SERCOM0_() uint32 {
	return (volatile.LoadUint32(&o.SECLOCKC.Reg) & 0x2) >> 1
}
func (o *PAC_Type) SetSECLOCKC_SERCOM1_(value uint32) {
	volatile.StoreUint32(&o.SECLOCKC.Reg, volatile.LoadUint32(&o.SECLOCKC.Reg)&^(0x4)|value<<2)
}
func (o *PAC_Type) GetSECLOCKC_SERCOM1_() uint32 {
	return (volatile.LoadUint32(&o.SECLOCKC.Reg) & 0x4) >> 2
}
func (o *PAC_Type) SetSECLOCKC_TC0_(value uint32) {
	volatile.StoreUint32(&o.SECLOCKC.Reg, volatile.LoadUint32(&o.SECLOCKC.Reg)&^(0x10)|value<<4)
}
func (o *PAC_Type) GetSECLOCKC_TC0_() uint32 {
	return (volatile.LoadUint32(&o.SECLOCKC.Reg) & 0x10) >> 4
}
func (o *PAC_Type) SetSECLOCKC_TC1_(value uint32) {
	volatile.StoreUint32(&o.SECLOCKC.Reg, volatile.LoadUint32(&o.SECLOCKC.Reg)&^(0x20)|value<<5)
}
func (o *PAC_Type) GetSECLOCKC_TC1_() uint32 {
	return (volatile.LoadUint32(&o.SECLOCKC.Reg) & 0x20) >> 5
}
func (o *PAC_Type) SetSECLOCKC_TC2_(value uint32) {
	volatile.StoreUint32(&o.SECLOCKC.Reg, volatile.LoadUint32(&o.SECLOCKC.Reg)&^(0x40)|value<<6)
}
func (o *PAC_Type) GetSECLOCKC_TC2_() uint32 {
	return (volatile.LoadUint32(&o.SECLOCKC.Reg) & 0x40) >> 6
}
func (o *PAC_Type) SetSECLOCKC_ADC_(value uint32) {
	volatile.StoreUint32(&o.SECLOCKC.Reg, volatile.LoadUint32(&o.SECLOCKC.Reg)&^(0x80)|value<<7)
}
func (o *PAC_Type) GetSECLOCKC_ADC_() uint32 {
	return (volatile.LoadUint32(&o.SECLOCKC.Reg) & 0x80) >> 7
}
func (o *PAC_Type) SetSECLOCKC_DAC_(value uint32) {
	volatile.StoreUint32(&o.SECLOCKC.Reg, volatile.LoadUint32(&o.SECLOCKC.Reg)&^(0x100)|value<<8)
}
func (o *PAC_Type) GetSECLOCKC_DAC_() uint32 {
	return (volatile.LoadUint32(&o.SECLOCKC.Reg) & 0x100) >> 8
}
func (o *PAC_Type) SetSECLOCKC_PTC_(value uint32) {
	volatile.StoreUint32(&o.SECLOCKC.Reg, volatile.LoadUint32(&o.SECLOCKC.Reg)&^(0x200)|value<<9)
}
func (o *PAC_Type) GetSECLOCKC_PTC_() uint32 {
	return (volatile.LoadUint32(&o.SECLOCKC.Reg) & 0x200) >> 9
}
func (o *PAC_Type) SetSECLOCKC_TRNG_(value uint32) {
	volatile.StoreUint32(&o.SECLOCKC.Reg, volatile.LoadUint32(&o.SECLOCKC.Reg)&^(0x400)|value<<10)
}
func (o *PAC_Type) GetSECLOCKC_TRNG_() uint32 {
	return (volatile.LoadUint32(&o.SECLOCKC.Reg) & 0x400) >> 10
}
func (o *PAC_Type) SetSECLOCKC_CCL_(value uint32) {
	volatile.StoreUint32(&o.SECLOCKC.Reg, volatile.LoadUint32(&o.SECLOCKC.Reg)&^(0x800)|value<<11)
}
func (o *PAC_Type) GetSECLOCKC_CCL_() uint32 {
	return (volatile.LoadUint32(&o.SECLOCKC.Reg) & 0x800) >> 11
}
func (o *PAC_Type) SetSECLOCKC_OPAMP_(value uint32) {
	volatile.StoreUint32(&o.SECLOCKC.Reg, volatile.LoadUint32(&o.SECLOCKC.Reg)&^(0x1000)|value<<12)
}
func (o *PAC_Type) GetSECLOCKC_OPAMP_() uint32 {
	return (volatile.LoadUint32(&o.SECLOCKC.Reg) & 0x1000) >> 12
}
func (o *PAC_Type) SetSECLOCKC_TRAM_(value uint32) {
	volatile.StoreUint32(&o.SECLOCKC.Reg, volatile.LoadUint32(&o.SECLOCKC.Reg)&^(0x2000)|value<<13)
}
func (o *PAC_Type) GetSECLOCKC_TRAM_() uint32 {
	return (volatile.LoadUint32(&o.SECLOCKC.Reg) & 0x2000) >> 13
}

// Power Manager
type PM_Type struct {
	_        byte
	SLEEPCFG volatile.Register8 // 0x1
	PLCFG    volatile.Register8 // 0x2
	PWCFG    volatile.Register8 // 0x3
	INTENCLR volatile.Register8 // 0x4
	INTENSET volatile.Register8 // 0x5
	INTFLAG  volatile.Register8 // 0x6
	_        byte
	STDBYCFG volatile.Register16 // 0x8
}

// PM.SLEEPCFG: Sleep Configuration
func (o *PM_Type) SetSLEEPCFG_SLEEPMODE(value uint8) {
	volatile.StoreUint8(&o.SLEEPCFG.Reg, volatile.LoadUint8(&o.SLEEPCFG.Reg)&^(0x7)|value)
}
func (o *PM_Type) GetSLEEPCFG_SLEEPMODE() uint8 {
	return volatile.LoadUint8(&o.SLEEPCFG.Reg) & 0x7
}

// PM.PLCFG: Performance Level Configuration
func (o *PM_Type) SetPLCFG_PLSEL(value uint8) {
	volatile.StoreUint8(&o.PLCFG.Reg, volatile.LoadUint8(&o.PLCFG.Reg)&^(0x3)|value)
}
func (o *PM_Type) GetPLCFG_PLSEL() uint8 {
	return volatile.LoadUint8(&o.PLCFG.Reg) & 0x3
}
func (o *PM_Type) SetPLCFG_PLDIS(value uint8) {
	volatile.StoreUint8(&o.PLCFG.Reg, volatile.LoadUint8(&o.PLCFG.Reg)&^(0x80)|value<<7)
}
func (o *PM_Type) GetPLCFG_PLDIS() uint8 {
	return (volatile.LoadUint8(&o.PLCFG.Reg) & 0x80) >> 7
}

// PM.PWCFG: Power Configuration
func (o *PM_Type) SetPWCFG_RAMPSWC(value uint8) {
	volatile.StoreUint8(&o.PWCFG.Reg, volatile.LoadUint8(&o.PWCFG.Reg)&^(0x3)|value)
}
func (o *PM_Type) GetPWCFG_RAMPSWC() uint8 {
	return volatile.LoadUint8(&o.PWCFG.Reg) & 0x3
}

// PM.INTENCLR: Interrupt Enable Clear
func (o *PM_Type) SetINTENCLR_PLRDY(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *PM_Type) GetINTENCLR_PLRDY() uint8 {
	return volatile.LoadUint8(&o.INTENCLR.Reg) & 0x1
}

// PM.INTENSET: Interrupt Enable Set
func (o *PM_Type) SetINTENSET_PLRDY(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *PM_Type) GetINTENSET_PLRDY() uint8 {
	return volatile.LoadUint8(&o.INTENSET.Reg) & 0x1
}

// PM.INTFLAG: Interrupt Flag Status and Clear
func (o *PM_Type) SetINTFLAG_PLRDY(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x1)|value)
}
func (o *PM_Type) GetINTFLAG_PLRDY() uint8 {
	return volatile.LoadUint8(&o.INTFLAG.Reg) & 0x1
}

// PM.STDBYCFG: Standby Configuration
func (o *PM_Type) SetSTDBYCFG_PDCFG(value uint16) {
	volatile.StoreUint16(&o.STDBYCFG.Reg, volatile.LoadUint16(&o.STDBYCFG.Reg)&^(0x1)|value)
}
func (o *PM_Type) GetSTDBYCFG_PDCFG() uint16 {
	return volatile.LoadUint16(&o.STDBYCFG.Reg) & 0x1
}
func (o *PM_Type) SetSTDBYCFG_DPGPDSW(value uint16) {
	volatile.StoreUint16(&o.STDBYCFG.Reg, volatile.LoadUint16(&o.STDBYCFG.Reg)&^(0x10)|value<<4)
}
func (o *PM_Type) GetSTDBYCFG_DPGPDSW() uint16 {
	return (volatile.LoadUint16(&o.STDBYCFG.Reg) & 0x10) >> 4
}
func (o *PM_Type) SetSTDBYCFG_VREGSMOD(value uint16) {
	volatile.StoreUint16(&o.STDBYCFG.Reg, volatile.LoadUint16(&o.STDBYCFG.Reg)&^(0xc0)|value<<6)
}
func (o *PM_Type) GetSTDBYCFG_VREGSMOD() uint16 {
	return (volatile.LoadUint16(&o.STDBYCFG.Reg) & 0xc0) >> 6
}
func (o *PM_Type) SetSTDBYCFG_BBIASHS(value uint16) {
	volatile.StoreUint16(&o.STDBYCFG.Reg, volatile.LoadUint16(&o.STDBYCFG.Reg)&^(0x400)|value<<10)
}
func (o *PM_Type) GetSTDBYCFG_BBIASHS() uint16 {
	return (volatile.LoadUint16(&o.STDBYCFG.Reg) & 0x400) >> 10
}
func (o *PM_Type) SetSTDBYCFG_BBIASTR(value uint16) {
	volatile.StoreUint16(&o.STDBYCFG.Reg, volatile.LoadUint16(&o.STDBYCFG.Reg)&^(0x1000)|value<<12)
}
func (o *PM_Type) GetSTDBYCFG_BBIASTR() uint16 {
	return (volatile.LoadUint16(&o.STDBYCFG.Reg) & 0x1000) >> 12
}

// Port Module
type PORT_Type struct {
	GROUP [1]PORT_GROUP_Type // 0x0
}

type PORT_GROUP_Type struct {
	DIR      volatile.Register32    // 0x0
	DIRCLR   volatile.Register32    // 0x4
	DIRSET   volatile.Register32    // 0x8
	DIRTGL   volatile.Register32    // 0xC
	OUT      volatile.Register32    // 0x10
	OUTCLR   volatile.Register32    // 0x14
	OUTSET   volatile.Register32    // 0x18
	OUTTGL   volatile.Register32    // 0x1C
	IN       volatile.Register32    // 0x20
	CTRL     volatile.Register32    // 0x24
	WRCONFIG volatile.Register32    // 0x28
	EVCTRL   volatile.Register32    // 0x2C
	PMUX     [16]volatile.Register8 // 0x30
	PINCFG   [32]volatile.Register8 // 0x40
	INTENCLR volatile.Register32    // 0x60
	INTENSET volatile.Register32    // 0x64
	INTFLAG  volatile.Register32    // 0x68
	NONSEC   volatile.Register32    // 0x6C
	NSCHK    volatile.Register32    // 0x70
}

// PORT_GROUP.DIR: Data Direction
func (o *PORT_GROUP_Type) SetDIR(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, value)
}
func (o *PORT_GROUP_Type) GetDIR() uint32 {
	return volatile.LoadUint32(&o.DIR.Reg)
}

// PORT_GROUP.DIRCLR: Data Direction Clear
func (o *PORT_GROUP_Type) SetDIRCLR(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, value)
}
func (o *PORT_GROUP_Type) GetDIRCLR() uint32 {
	return volatile.LoadUint32(&o.DIRCLR.Reg)
}

// PORT_GROUP.DIRSET: Data Direction Set
func (o *PORT_GROUP_Type) SetDIRSET(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, value)
}
func (o *PORT_GROUP_Type) GetDIRSET() uint32 {
	return volatile.LoadUint32(&o.DIRSET.Reg)
}

// PORT_GROUP.DIRTGL: Data Direction Toggle
func (o *PORT_GROUP_Type) SetDIRTGL(value uint32) {
	volatile.StoreUint32(&o.DIRTGL.Reg, value)
}
func (o *PORT_GROUP_Type) GetDIRTGL() uint32 {
	return volatile.LoadUint32(&o.DIRTGL.Reg)
}

// PORT_GROUP.OUT: Data Output Value
func (o *PORT_GROUP_Type) SetOUT(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, value)
}
func (o *PORT_GROUP_Type) GetOUT() uint32 {
	return volatile.LoadUint32(&o.OUT.Reg)
}

// PORT_GROUP.OUTCLR: Data Output Value Clear
func (o *PORT_GROUP_Type) SetOUTCLR(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, value)
}
func (o *PORT_GROUP_Type) GetOUTCLR() uint32 {
	return volatile.LoadUint32(&o.OUTCLR.Reg)
}

// PORT_GROUP.OUTSET: Data Output Value Set
func (o *PORT_GROUP_Type) SetOUTSET(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, value)
}
func (o *PORT_GROUP_Type) GetOUTSET() uint32 {
	return volatile.LoadUint32(&o.OUTSET.Reg)
}

// PORT_GROUP.OUTTGL: Data Output Value Toggle
func (o *PORT_GROUP_Type) SetOUTTGL(value uint32) {
	volatile.StoreUint32(&o.OUTTGL.Reg, value)
}
func (o *PORT_GROUP_Type) GetOUTTGL() uint32 {
	return volatile.LoadUint32(&o.OUTTGL.Reg)
}

// PORT_GROUP.IN: Data Input Value
func (o *PORT_GROUP_Type) SetIN(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, value)
}
func (o *PORT_GROUP_Type) GetIN() uint32 {
	return volatile.LoadUint32(&o.IN.Reg)
}

// PORT_GROUP.CTRL: Control
func (o *PORT_GROUP_Type) SetCTRL(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, value)
}
func (o *PORT_GROUP_Type) GetCTRL() uint32 {
	return volatile.LoadUint32(&o.CTRL.Reg)
}

// PORT_GROUP.WRCONFIG: Write Configuration
func (o *PORT_GROUP_Type) SetWRCONFIG_PINMASK(value uint32) {
	volatile.StoreUint32(&o.WRCONFIG.Reg, volatile.LoadUint32(&o.WRCONFIG.Reg)&^(0xffff)|value)
}
func (o *PORT_GROUP_Type) GetWRCONFIG_PINMASK() uint32 {
	return volatile.LoadUint32(&o.WRCONFIG.Reg) & 0xffff
}
func (o *PORT_GROUP_Type) SetWRCONFIG_PMUXEN(value uint32) {
	volatile.StoreUint32(&o.WRCONFIG.Reg, volatile.LoadUint32(&o.WRCONFIG.Reg)&^(0x10000)|value<<16)
}
func (o *PORT_GROUP_Type) GetWRCONFIG_PMUXEN() uint32 {
	return (volatile.LoadUint32(&o.WRCONFIG.Reg) & 0x10000) >> 16
}
func (o *PORT_GROUP_Type) SetWRCONFIG_INEN(value uint32) {
	volatile.StoreUint32(&o.WRCONFIG.Reg, volatile.LoadUint32(&o.WRCONFIG.Reg)&^(0x20000)|value<<17)
}
func (o *PORT_GROUP_Type) GetWRCONFIG_INEN() uint32 {
	return (volatile.LoadUint32(&o.WRCONFIG.Reg) & 0x20000) >> 17
}
func (o *PORT_GROUP_Type) SetWRCONFIG_PULLEN(value uint32) {
	volatile.StoreUint32(&o.WRCONFIG.Reg, volatile.LoadUint32(&o.WRCONFIG.Reg)&^(0x40000)|value<<18)
}
func (o *PORT_GROUP_Type) GetWRCONFIG_PULLEN() uint32 {
	return (volatile.LoadUint32(&o.WRCONFIG.Reg) & 0x40000) >> 18
}
func (o *PORT_GROUP_Type) SetWRCONFIG_DRVSTR(value uint32) {
	volatile.StoreUint32(&o.WRCONFIG.Reg, volatile.LoadUint32(&o.WRCONFIG.Reg)&^(0x400000)|value<<22)
}
func (o *PORT_GROUP_Type) GetWRCONFIG_DRVSTR() uint32 {
	return (volatile.LoadUint32(&o.WRCONFIG.Reg) & 0x400000) >> 22
}
func (o *PORT_GROUP_Type) SetWRCONFIG_PMUX(value uint32) {
	volatile.StoreUint32(&o.WRCONFIG.Reg, volatile.LoadUint32(&o.WRCONFIG.Reg)&^(0xf000000)|value<<24)
}
func (o *PORT_GROUP_Type) GetWRCONFIG_PMUX() uint32 {
	return (volatile.LoadUint32(&o.WRCONFIG.Reg) & 0xf000000) >> 24
}
func (o *PORT_GROUP_Type) SetWRCONFIG_WRPMUX(value uint32) {
	volatile.StoreUint32(&o.WRCONFIG.Reg, volatile.LoadUint32(&o.WRCONFIG.Reg)&^(0x10000000)|value<<28)
}
func (o *PORT_GROUP_Type) GetWRCONFIG_WRPMUX() uint32 {
	return (volatile.LoadUint32(&o.WRCONFIG.Reg) & 0x10000000) >> 28
}
func (o *PORT_GROUP_Type) SetWRCONFIG_WRPINCFG(value uint32) {
	volatile.StoreUint32(&o.WRCONFIG.Reg, volatile.LoadUint32(&o.WRCONFIG.Reg)&^(0x40000000)|value<<30)
}
func (o *PORT_GROUP_Type) GetWRCONFIG_WRPINCFG() uint32 {
	return (volatile.LoadUint32(&o.WRCONFIG.Reg) & 0x40000000) >> 30
}
func (o *PORT_GROUP_Type) SetWRCONFIG_HWSEL(value uint32) {
	volatile.StoreUint32(&o.WRCONFIG.Reg, volatile.LoadUint32(&o.WRCONFIG.Reg)&^(0x80000000)|value<<31)
}
func (o *PORT_GROUP_Type) GetWRCONFIG_HWSEL() uint32 {
	return (volatile.LoadUint32(&o.WRCONFIG.Reg) & 0x80000000) >> 31
}

// PORT_GROUP.EVCTRL: Event Input Control
func (o *PORT_GROUP_Type) SetEVCTRL_PID0(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x1f)|value)
}
func (o *PORT_GROUP_Type) GetEVCTRL_PID0() uint32 {
	return volatile.LoadUint32(&o.EVCTRL.Reg) & 0x1f
}
func (o *PORT_GROUP_Type) SetEVCTRL_EVACT0(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x60)|value<<5)
}
func (o *PORT_GROUP_Type) GetEVCTRL_EVACT0() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x60) >> 5
}
func (o *PORT_GROUP_Type) SetEVCTRL_PORTEI0(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x80)|value<<7)
}
func (o *PORT_GROUP_Type) GetEVCTRL_PORTEI0() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x80) >> 7
}
func (o *PORT_GROUP_Type) SetEVCTRL_PID1(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x1f00)|value<<8)
}
func (o *PORT_GROUP_Type) GetEVCTRL_PID1() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x1f00) >> 8
}
func (o *PORT_GROUP_Type) SetEVCTRL_EVACT1(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x6000)|value<<13)
}
func (o *PORT_GROUP_Type) GetEVCTRL_EVACT1() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x6000) >> 13
}
func (o *PORT_GROUP_Type) SetEVCTRL_PORTEI1(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x8000)|value<<15)
}
func (o *PORT_GROUP_Type) GetEVCTRL_PORTEI1() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x8000) >> 15
}
func (o *PORT_GROUP_Type) SetEVCTRL_PID2(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x1f0000)|value<<16)
}
func (o *PORT_GROUP_Type) GetEVCTRL_PID2() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x1f0000) >> 16
}
func (o *PORT_GROUP_Type) SetEVCTRL_EVACT2(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x600000)|value<<21)
}
func (o *PORT_GROUP_Type) GetEVCTRL_EVACT2() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x600000) >> 21
}
func (o *PORT_GROUP_Type) SetEVCTRL_PORTEI2(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x800000)|value<<23)
}
func (o *PORT_GROUP_Type) GetEVCTRL_PORTEI2() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x800000) >> 23
}
func (o *PORT_GROUP_Type) SetEVCTRL_PID3(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x1f000000)|value<<24)
}
func (o *PORT_GROUP_Type) GetEVCTRL_PID3() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x1f000000) >> 24
}
func (o *PORT_GROUP_Type) SetEVCTRL_EVACT3(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x60000000)|value<<29)
}
func (o *PORT_GROUP_Type) GetEVCTRL_EVACT3() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x60000000) >> 29
}
func (o *PORT_GROUP_Type) SetEVCTRL_PORTEI3(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x80000000)|value<<31)
}
func (o *PORT_GROUP_Type) GetEVCTRL_PORTEI3() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x80000000) >> 31
}

// PORT_GROUP.INTENCLR: Interrupt Enable Clear
func (o *PORT_GROUP_Type) SetINTENCLR_NSCHK(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *PORT_GROUP_Type) GetINTENCLR_NSCHK() uint32 {
	return volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1
}

// PORT_GROUP.INTENSET: Interrupt Enable Set
func (o *PORT_GROUP_Type) SetINTENSET_NSCHK(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *PORT_GROUP_Type) GetINTENSET_NSCHK() uint32 {
	return volatile.LoadUint32(&o.INTENSET.Reg) & 0x1
}

// PORT_GROUP.INTFLAG: Interrupt Flag Status and Clear
func (o *PORT_GROUP_Type) SetINTFLAG_NSCHK(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x1)|value)
}
func (o *PORT_GROUP_Type) GetINTFLAG_NSCHK() uint32 {
	return volatile.LoadUint32(&o.INTFLAG.Reg) & 0x1
}

// PORT_GROUP.NONSEC: Security Attribution
func (o *PORT_GROUP_Type) SetNONSEC(value uint32) {
	volatile.StoreUint32(&o.NONSEC.Reg, value)
}
func (o *PORT_GROUP_Type) GetNONSEC() uint32 {
	return volatile.LoadUint32(&o.NONSEC.Reg)
}

// PORT_GROUP.NSCHK: Security Attribution Check
func (o *PORT_GROUP_Type) SetNSCHK(value uint32) {
	volatile.StoreUint32(&o.NSCHK.Reg, value)
}
func (o *PORT_GROUP_Type) GetNSCHK() uint32 {
	return volatile.LoadUint32(&o.NSCHK.Reg)
}

// Peripheral Touch Controller
type PTC_Type struct {
}

// Reset Controller
type RSTC_Type struct {
	RCAUSE volatile.Register8 // 0x0
}

// RSTC.RCAUSE: Reset Cause
func (o *RSTC_Type) SetRCAUSE_POR(value uint8) {
	volatile.StoreUint8(&o.RCAUSE.Reg, volatile.LoadUint8(&o.RCAUSE.Reg)&^(0x1)|value)
}
func (o *RSTC_Type) GetRCAUSE_POR() uint8 {
	return volatile.LoadUint8(&o.RCAUSE.Reg) & 0x1
}
func (o *RSTC_Type) SetRCAUSE_BODCORE(value uint8) {
	volatile.StoreUint8(&o.RCAUSE.Reg, volatile.LoadUint8(&o.RCAUSE.Reg)&^(0x2)|value<<1)
}
func (o *RSTC_Type) GetRCAUSE_BODCORE() uint8 {
	return (volatile.LoadUint8(&o.RCAUSE.Reg) & 0x2) >> 1
}
func (o *RSTC_Type) SetRCAUSE_BODVDD(value uint8) {
	volatile.StoreUint8(&o.RCAUSE.Reg, volatile.LoadUint8(&o.RCAUSE.Reg)&^(0x4)|value<<2)
}
func (o *RSTC_Type) GetRCAUSE_BODVDD() uint8 {
	return (volatile.LoadUint8(&o.RCAUSE.Reg) & 0x4) >> 2
}
func (o *RSTC_Type) SetRCAUSE_EXT(value uint8) {
	volatile.StoreUint8(&o.RCAUSE.Reg, volatile.LoadUint8(&o.RCAUSE.Reg)&^(0x10)|value<<4)
}
func (o *RSTC_Type) GetRCAUSE_EXT() uint8 {
	return (volatile.LoadUint8(&o.RCAUSE.Reg) & 0x10) >> 4
}
func (o *RSTC_Type) SetRCAUSE_WDT(value uint8) {
	volatile.StoreUint8(&o.RCAUSE.Reg, volatile.LoadUint8(&o.RCAUSE.Reg)&^(0x20)|value<<5)
}
func (o *RSTC_Type) GetRCAUSE_WDT() uint8 {
	return (volatile.LoadUint8(&o.RCAUSE.Reg) & 0x20) >> 5
}
func (o *RSTC_Type) SetRCAUSE_SYST(value uint8) {
	volatile.StoreUint8(&o.RCAUSE.Reg, volatile.LoadUint8(&o.RCAUSE.Reg)&^(0x40)|value<<6)
}
func (o *RSTC_Type) GetRCAUSE_SYST() uint8 {
	return (volatile.LoadUint8(&o.RCAUSE.Reg) & 0x40) >> 6
}

// Real-Time Counter
type RTC_Type struct {
}

// Real-Time Counter - MODE0
type RTC_MODE0_Type struct {
	CTRLA     volatile.Register16 // 0x0
	CTRLB     volatile.Register16 // 0x2
	EVCTRL    volatile.Register32 // 0x4
	INTENCLR  volatile.Register16 // 0x8
	INTENSET  volatile.Register16 // 0xA
	INTFLAG   volatile.Register16 // 0xC
	DBGCTRL   volatile.Register8  // 0xE
	_         byte
	SYNCBUSY  volatile.Register32 // 0x10
	FREQCORR  volatile.Register8  // 0x14
	_         [3]byte
	COUNT     volatile.Register32 // 0x18
	_         [4]byte
	COMP      [1]volatile.Register32 // 0x20
	_         [28]byte
	GP        [2]volatile.Register32 // 0x40
	_         [24]byte
	TAMPCTRL  volatile.Register32 // 0x60
	TIMESTAMP volatile.Register32 // 0x64
	TAMPID    volatile.Register32 // 0x68
	TAMPCTRLB volatile.Register32 // 0x6C
}

// RTC_MODE0.CTRLA: MODE0 Control A
func (o *RTC_MODE0_Type) SetCTRLA_SWRST(value uint16) {
	volatile.StoreUint16(&o.CTRLA.Reg, volatile.LoadUint16(&o.CTRLA.Reg)&^(0x1)|value)
}
func (o *RTC_MODE0_Type) GetCTRLA_SWRST() uint16 {
	return volatile.LoadUint16(&o.CTRLA.Reg) & 0x1
}
func (o *RTC_MODE0_Type) SetCTRLA_ENABLE(value uint16) {
	volatile.StoreUint16(&o.CTRLA.Reg, volatile.LoadUint16(&o.CTRLA.Reg)&^(0x2)|value<<1)
}
func (o *RTC_MODE0_Type) GetCTRLA_ENABLE() uint16 {
	return (volatile.LoadUint16(&o.CTRLA.Reg) & 0x2) >> 1
}
func (o *RTC_MODE0_Type) SetCTRLA_MODE(value uint16) {
	volatile.StoreUint16(&o.CTRLA.Reg, volatile.LoadUint16(&o.CTRLA.Reg)&^(0xc)|value<<2)
}
func (o *RTC_MODE0_Type) GetCTRLA_MODE() uint16 {
	return (volatile.LoadUint16(&o.CTRLA.Reg) & 0xc) >> 2
}
func (o *RTC_MODE0_Type) SetCTRLA_MATCHCLR(value uint16) {
	volatile.StoreUint16(&o.CTRLA.Reg, volatile.LoadUint16(&o.CTRLA.Reg)&^(0x80)|value<<7)
}
func (o *RTC_MODE0_Type) GetCTRLA_MATCHCLR() uint16 {
	return (volatile.LoadUint16(&o.CTRLA.Reg) & 0x80) >> 7
}
func (o *RTC_MODE0_Type) SetCTRLA_PRESCALER(value uint16) {
	volatile.StoreUint16(&o.CTRLA.Reg, volatile.LoadUint16(&o.CTRLA.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_MODE0_Type) GetCTRLA_PRESCALER() uint16 {
	return (volatile.LoadUint16(&o.CTRLA.Reg) & 0xf00) >> 8
}
func (o *RTC_MODE0_Type) SetCTRLA_GPTRST(value uint16) {
	volatile.StoreUint16(&o.CTRLA.Reg, volatile.LoadUint16(&o.CTRLA.Reg)&^(0x4000)|value<<14)
}
func (o *RTC_MODE0_Type) GetCTRLA_GPTRST() uint16 {
	return (volatile.LoadUint16(&o.CTRLA.Reg) & 0x4000) >> 14
}
func (o *RTC_MODE0_Type) SetCTRLA_COUNTSYNC(value uint16) {
	volatile.StoreUint16(&o.CTRLA.Reg, volatile.LoadUint16(&o.CTRLA.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_MODE0_Type) GetCTRLA_COUNTSYNC() uint16 {
	return (volatile.LoadUint16(&o.CTRLA.Reg) & 0x8000) >> 15
}

// RTC_MODE0.CTRLB: MODE0 Control B
func (o *RTC_MODE0_Type) SetCTRLB_GP0EN(value uint16) {
	volatile.StoreUint16(&o.CTRLB.Reg, volatile.LoadUint16(&o.CTRLB.Reg)&^(0x1)|value)
}
func (o *RTC_MODE0_Type) GetCTRLB_GP0EN() uint16 {
	return volatile.LoadUint16(&o.CTRLB.Reg) & 0x1
}
func (o *RTC_MODE0_Type) SetCTRLB_DEBMAJ(value uint16) {
	volatile.StoreUint16(&o.CTRLB.Reg, volatile.LoadUint16(&o.CTRLB.Reg)&^(0x10)|value<<4)
}
func (o *RTC_MODE0_Type) GetCTRLB_DEBMAJ() uint16 {
	return (volatile.LoadUint16(&o.CTRLB.Reg) & 0x10) >> 4
}
func (o *RTC_MODE0_Type) SetCTRLB_DEBASYNC(value uint16) {
	volatile.StoreUint16(&o.CTRLB.Reg, volatile.LoadUint16(&o.CTRLB.Reg)&^(0x20)|value<<5)
}
func (o *RTC_MODE0_Type) GetCTRLB_DEBASYNC() uint16 {
	return (volatile.LoadUint16(&o.CTRLB.Reg) & 0x20) >> 5
}
func (o *RTC_MODE0_Type) SetCTRLB_RTCOUT(value uint16) {
	volatile.StoreUint16(&o.CTRLB.Reg, volatile.LoadUint16(&o.CTRLB.Reg)&^(0x40)|value<<6)
}
func (o *RTC_MODE0_Type) GetCTRLB_RTCOUT() uint16 {
	return (volatile.LoadUint16(&o.CTRLB.Reg) & 0x40) >> 6
}
func (o *RTC_MODE0_Type) SetCTRLB_DMAEN(value uint16) {
	volatile.StoreUint16(&o.CTRLB.Reg, volatile.LoadUint16(&o.CTRLB.Reg)&^(0x80)|value<<7)
}
func (o *RTC_MODE0_Type) GetCTRLB_DMAEN() uint16 {
	return (volatile.LoadUint16(&o.CTRLB.Reg) & 0x80) >> 7
}
func (o *RTC_MODE0_Type) SetCTRLB_DEBF(value uint16) {
	volatile.StoreUint16(&o.CTRLB.Reg, volatile.LoadUint16(&o.CTRLB.Reg)&^(0x700)|value<<8)
}
func (o *RTC_MODE0_Type) GetCTRLB_DEBF() uint16 {
	return (volatile.LoadUint16(&o.CTRLB.Reg) & 0x700) >> 8
}
func (o *RTC_MODE0_Type) SetCTRLB_ACTF(value uint16) {
	volatile.StoreUint16(&o.CTRLB.Reg, volatile.LoadUint16(&o.CTRLB.Reg)&^(0x7000)|value<<12)
}
func (o *RTC_MODE0_Type) GetCTRLB_ACTF() uint16 {
	return (volatile.LoadUint16(&o.CTRLB.Reg) & 0x7000) >> 12
}
func (o *RTC_MODE0_Type) SetCTRLB_SEPTO(value uint16) {
	volatile.StoreUint16(&o.CTRLB.Reg, volatile.LoadUint16(&o.CTRLB.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_MODE0_Type) GetCTRLB_SEPTO() uint16 {
	return (volatile.LoadUint16(&o.CTRLB.Reg) & 0x8000) >> 15
}

// RTC_MODE0.EVCTRL: MODE0 Event Control
func (o *RTC_MODE0_Type) SetEVCTRL_PEREO0(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x1)|value)
}
func (o *RTC_MODE0_Type) GetEVCTRL_PEREO0() uint32 {
	return volatile.LoadUint32(&o.EVCTRL.Reg) & 0x1
}
func (o *RTC_MODE0_Type) SetEVCTRL_PEREO1(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x2)|value<<1)
}
func (o *RTC_MODE0_Type) GetEVCTRL_PEREO1() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x2) >> 1
}
func (o *RTC_MODE0_Type) SetEVCTRL_PEREO2(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x4)|value<<2)
}
func (o *RTC_MODE0_Type) GetEVCTRL_PEREO2() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x4) >> 2
}
func (o *RTC_MODE0_Type) SetEVCTRL_PEREO3(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x8)|value<<3)
}
func (o *RTC_MODE0_Type) GetEVCTRL_PEREO3() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x8) >> 3
}
func (o *RTC_MODE0_Type) SetEVCTRL_PEREO4(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x10)|value<<4)
}
func (o *RTC_MODE0_Type) GetEVCTRL_PEREO4() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x10) >> 4
}
func (o *RTC_MODE0_Type) SetEVCTRL_PEREO5(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x20)|value<<5)
}
func (o *RTC_MODE0_Type) GetEVCTRL_PEREO5() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x20) >> 5
}
func (o *RTC_MODE0_Type) SetEVCTRL_PEREO6(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x40)|value<<6)
}
func (o *RTC_MODE0_Type) GetEVCTRL_PEREO6() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x40) >> 6
}
func (o *RTC_MODE0_Type) SetEVCTRL_PEREO7(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x80)|value<<7)
}
func (o *RTC_MODE0_Type) GetEVCTRL_PEREO7() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x80) >> 7
}
func (o *RTC_MODE0_Type) SetEVCTRL_CMPEO0(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x100)|value<<8)
}
func (o *RTC_MODE0_Type) GetEVCTRL_CMPEO0() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x100) >> 8
}
func (o *RTC_MODE0_Type) SetEVCTRL_TAMPEREO(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x4000)|value<<14)
}
func (o *RTC_MODE0_Type) GetEVCTRL_TAMPEREO() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x4000) >> 14
}
func (o *RTC_MODE0_Type) SetEVCTRL_OVFEO(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_MODE0_Type) GetEVCTRL_OVFEO() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x8000) >> 15
}
func (o *RTC_MODE0_Type) SetEVCTRL_TAMPEVEI(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x10000)|value<<16)
}
func (o *RTC_MODE0_Type) GetEVCTRL_TAMPEVEI() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x10000) >> 16
}
func (o *RTC_MODE0_Type) SetEVCTRL_PERDEO(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x1000000)|value<<24)
}
func (o *RTC_MODE0_Type) GetEVCTRL_PERDEO() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x1000000) >> 24
}

// RTC_MODE0.INTENCLR: MODE0 Interrupt Enable Clear
func (o *RTC_MODE0_Type) SetINTENCLR_PER0(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *RTC_MODE0_Type) GetINTENCLR_PER0() uint16 {
	return volatile.LoadUint16(&o.INTENCLR.Reg) & 0x1
}
func (o *RTC_MODE0_Type) SetINTENCLR_PER1(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *RTC_MODE0_Type) GetINTENCLR_PER1() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *RTC_MODE0_Type) SetINTENCLR_PER2(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *RTC_MODE0_Type) GetINTENCLR_PER2() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x4) >> 2
}
func (o *RTC_MODE0_Type) SetINTENCLR_PER3(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x8)|value<<3)
}
func (o *RTC_MODE0_Type) GetINTENCLR_PER3() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x8) >> 3
}
func (o *RTC_MODE0_Type) SetINTENCLR_PER4(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x10)|value<<4)
}
func (o *RTC_MODE0_Type) GetINTENCLR_PER4() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x10) >> 4
}
func (o *RTC_MODE0_Type) SetINTENCLR_PER5(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x20)|value<<5)
}
func (o *RTC_MODE0_Type) GetINTENCLR_PER5() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x20) >> 5
}
func (o *RTC_MODE0_Type) SetINTENCLR_PER6(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x40)|value<<6)
}
func (o *RTC_MODE0_Type) GetINTENCLR_PER6() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x40) >> 6
}
func (o *RTC_MODE0_Type) SetINTENCLR_PER7(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x80)|value<<7)
}
func (o *RTC_MODE0_Type) GetINTENCLR_PER7() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x80) >> 7
}
func (o *RTC_MODE0_Type) SetINTENCLR_CMP0(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x100)|value<<8)
}
func (o *RTC_MODE0_Type) GetINTENCLR_CMP0() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x100) >> 8
}
func (o *RTC_MODE0_Type) SetINTENCLR_TAMPER(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x4000)|value<<14)
}
func (o *RTC_MODE0_Type) GetINTENCLR_TAMPER() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x4000) >> 14
}
func (o *RTC_MODE0_Type) SetINTENCLR_OVF(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_MODE0_Type) GetINTENCLR_OVF() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x8000) >> 15
}

// RTC_MODE0.INTENSET: MODE0 Interrupt Enable Set
func (o *RTC_MODE0_Type) SetINTENSET_PER0(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *RTC_MODE0_Type) GetINTENSET_PER0() uint16 {
	return volatile.LoadUint16(&o.INTENSET.Reg) & 0x1
}
func (o *RTC_MODE0_Type) SetINTENSET_PER1(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *RTC_MODE0_Type) GetINTENSET_PER1() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *RTC_MODE0_Type) SetINTENSET_PER2(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *RTC_MODE0_Type) GetINTENSET_PER2() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x4) >> 2
}
func (o *RTC_MODE0_Type) SetINTENSET_PER3(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x8)|value<<3)
}
func (o *RTC_MODE0_Type) GetINTENSET_PER3() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x8) >> 3
}
func (o *RTC_MODE0_Type) SetINTENSET_PER4(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x10)|value<<4)
}
func (o *RTC_MODE0_Type) GetINTENSET_PER4() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x10) >> 4
}
func (o *RTC_MODE0_Type) SetINTENSET_PER5(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x20)|value<<5)
}
func (o *RTC_MODE0_Type) GetINTENSET_PER5() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x20) >> 5
}
func (o *RTC_MODE0_Type) SetINTENSET_PER6(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x40)|value<<6)
}
func (o *RTC_MODE0_Type) GetINTENSET_PER6() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x40) >> 6
}
func (o *RTC_MODE0_Type) SetINTENSET_PER7(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x80)|value<<7)
}
func (o *RTC_MODE0_Type) GetINTENSET_PER7() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x80) >> 7
}
func (o *RTC_MODE0_Type) SetINTENSET_CMP0(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x100)|value<<8)
}
func (o *RTC_MODE0_Type) GetINTENSET_CMP0() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x100) >> 8
}
func (o *RTC_MODE0_Type) SetINTENSET_TAMPER(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x4000)|value<<14)
}
func (o *RTC_MODE0_Type) GetINTENSET_TAMPER() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x4000) >> 14
}
func (o *RTC_MODE0_Type) SetINTENSET_OVF(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_MODE0_Type) GetINTENSET_OVF() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x8000) >> 15
}

// RTC_MODE0.INTFLAG: MODE0 Interrupt Flag Status and Clear
func (o *RTC_MODE0_Type) SetINTFLAG_PER0(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x1)|value)
}
func (o *RTC_MODE0_Type) GetINTFLAG_PER0() uint16 {
	return volatile.LoadUint16(&o.INTFLAG.Reg) & 0x1
}
func (o *RTC_MODE0_Type) SetINTFLAG_PER1(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x2)|value<<1)
}
func (o *RTC_MODE0_Type) GetINTFLAG_PER1() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x2) >> 1
}
func (o *RTC_MODE0_Type) SetINTFLAG_PER2(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x4)|value<<2)
}
func (o *RTC_MODE0_Type) GetINTFLAG_PER2() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x4) >> 2
}
func (o *RTC_MODE0_Type) SetINTFLAG_PER3(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x8)|value<<3)
}
func (o *RTC_MODE0_Type) GetINTFLAG_PER3() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x8) >> 3
}
func (o *RTC_MODE0_Type) SetINTFLAG_PER4(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x10)|value<<4)
}
func (o *RTC_MODE0_Type) GetINTFLAG_PER4() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x10) >> 4
}
func (o *RTC_MODE0_Type) SetINTFLAG_PER5(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x20)|value<<5)
}
func (o *RTC_MODE0_Type) GetINTFLAG_PER5() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x20) >> 5
}
func (o *RTC_MODE0_Type) SetINTFLAG_PER6(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x40)|value<<6)
}
func (o *RTC_MODE0_Type) GetINTFLAG_PER6() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x40) >> 6
}
func (o *RTC_MODE0_Type) SetINTFLAG_PER7(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x80)|value<<7)
}
func (o *RTC_MODE0_Type) GetINTFLAG_PER7() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x80) >> 7
}
func (o *RTC_MODE0_Type) SetINTFLAG_CMP0(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x100)|value<<8)
}
func (o *RTC_MODE0_Type) GetINTFLAG_CMP0() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x100) >> 8
}
func (o *RTC_MODE0_Type) SetINTFLAG_TAMPER(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x4000)|value<<14)
}
func (o *RTC_MODE0_Type) GetINTFLAG_TAMPER() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x4000) >> 14
}
func (o *RTC_MODE0_Type) SetINTFLAG_OVF(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_MODE0_Type) GetINTFLAG_OVF() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x8000) >> 15
}

// RTC_MODE0.DBGCTRL: Debug Control
func (o *RTC_MODE0_Type) SetDBGCTRL_DBGRUN(value uint8) {
	volatile.StoreUint8(&o.DBGCTRL.Reg, volatile.LoadUint8(&o.DBGCTRL.Reg)&^(0x1)|value)
}
func (o *RTC_MODE0_Type) GetDBGCTRL_DBGRUN() uint8 {
	return volatile.LoadUint8(&o.DBGCTRL.Reg) & 0x1
}

// RTC_MODE0.SYNCBUSY: MODE0 Synchronization Busy Status
func (o *RTC_MODE0_Type) SetSYNCBUSY_SWRST(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x1)|value)
}
func (o *RTC_MODE0_Type) GetSYNCBUSY_SWRST() uint32 {
	return volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x1
}
func (o *RTC_MODE0_Type) SetSYNCBUSY_ENABLE(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x2)|value<<1)
}
func (o *RTC_MODE0_Type) GetSYNCBUSY_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x2) >> 1
}
func (o *RTC_MODE0_Type) SetSYNCBUSY_FREQCORR(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x4)|value<<2)
}
func (o *RTC_MODE0_Type) GetSYNCBUSY_FREQCORR() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x4) >> 2
}
func (o *RTC_MODE0_Type) SetSYNCBUSY_COUNT(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x8)|value<<3)
}
func (o *RTC_MODE0_Type) GetSYNCBUSY_COUNT() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x8) >> 3
}
func (o *RTC_MODE0_Type) SetSYNCBUSY_COMP0(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x20)|value<<5)
}
func (o *RTC_MODE0_Type) GetSYNCBUSY_COMP0() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x20) >> 5
}
func (o *RTC_MODE0_Type) SetSYNCBUSY_COUNTSYNC(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_MODE0_Type) GetSYNCBUSY_COUNTSYNC() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x8000) >> 15
}
func (o *RTC_MODE0_Type) SetSYNCBUSY_GP0(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x10000)|value<<16)
}
func (o *RTC_MODE0_Type) GetSYNCBUSY_GP0() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x10000) >> 16
}
func (o *RTC_MODE0_Type) SetSYNCBUSY_GP1(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x20000)|value<<17)
}
func (o *RTC_MODE0_Type) GetSYNCBUSY_GP1() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x20000) >> 17
}

// RTC_MODE0.FREQCORR: Frequency Correction
func (o *RTC_MODE0_Type) SetFREQCORR_VALUE(value uint8) {
	volatile.StoreUint8(&o.FREQCORR.Reg, volatile.LoadUint8(&o.FREQCORR.Reg)&^(0x7f)|value)
}
func (o *RTC_MODE0_Type) GetFREQCORR_VALUE() uint8 {
	return volatile.LoadUint8(&o.FREQCORR.Reg) & 0x7f
}
func (o *RTC_MODE0_Type) SetFREQCORR_SIGN(value uint8) {
	volatile.StoreUint8(&o.FREQCORR.Reg, volatile.LoadUint8(&o.FREQCORR.Reg)&^(0x80)|value<<7)
}
func (o *RTC_MODE0_Type) GetFREQCORR_SIGN() uint8 {
	return (volatile.LoadUint8(&o.FREQCORR.Reg) & 0x80) >> 7
}

// RTC_MODE0.COUNT: MODE0 Counter Value
func (o *RTC_MODE0_Type) SetCOUNT(value uint32) {
	volatile.StoreUint32(&o.COUNT.Reg, value)
}
func (o *RTC_MODE0_Type) GetCOUNT() uint32 {
	return volatile.LoadUint32(&o.COUNT.Reg)
}

// RTC_MODE0.COMP: MODE0 Compare n Value
func (o *RTC_MODE0_Type) SetCOMP(idx int, value uint32) {
	volatile.StoreUint32(&o.COMP[idx].Reg, value)
}
func (o *RTC_MODE0_Type) GetCOMP(idx int) uint32 {
	return volatile.LoadUint32(&o.COMP[idx].Reg)
}

// RTC_MODE0.GP: General Purpose
func (o *RTC_MODE0_Type) SetGP(idx int, value uint32) {
	volatile.StoreUint32(&o.GP[idx].Reg, value)
}
func (o *RTC_MODE0_Type) GetGP(idx int) uint32 {
	return volatile.LoadUint32(&o.GP[idx].Reg)
}

// RTC_MODE0.TAMPCTRL: Tamper Control
func (o *RTC_MODE0_Type) SetTAMPCTRL_IN0ACT(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRL.Reg, volatile.LoadUint32(&o.TAMPCTRL.Reg)&^(0x3)|value)
}
func (o *RTC_MODE0_Type) GetTAMPCTRL_IN0ACT() uint32 {
	return volatile.LoadUint32(&o.TAMPCTRL.Reg) & 0x3
}
func (o *RTC_MODE0_Type) SetTAMPCTRL_IN1ACT(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRL.Reg, volatile.LoadUint32(&o.TAMPCTRL.Reg)&^(0xc)|value<<2)
}
func (o *RTC_MODE0_Type) GetTAMPCTRL_IN1ACT() uint32 {
	return (volatile.LoadUint32(&o.TAMPCTRL.Reg) & 0xc) >> 2
}
func (o *RTC_MODE0_Type) SetTAMPCTRL_IN2ACT(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRL.Reg, volatile.LoadUint32(&o.TAMPCTRL.Reg)&^(0x30)|value<<4)
}
func (o *RTC_MODE0_Type) GetTAMPCTRL_IN2ACT() uint32 {
	return (volatile.LoadUint32(&o.TAMPCTRL.Reg) & 0x30) >> 4
}
func (o *RTC_MODE0_Type) SetTAMPCTRL_IN3ACT(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRL.Reg, volatile.LoadUint32(&o.TAMPCTRL.Reg)&^(0xc0)|value<<6)
}
func (o *RTC_MODE0_Type) GetTAMPCTRL_IN3ACT() uint32 {
	return (volatile.LoadUint32(&o.TAMPCTRL.Reg) & 0xc0) >> 6
}
func (o *RTC_MODE0_Type) SetTAMPCTRL_TAMLVL0(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRL.Reg, volatile.LoadUint32(&o.TAMPCTRL.Reg)&^(0x10000)|value<<16)
}
func (o *RTC_MODE0_Type) GetTAMPCTRL_TAMLVL0() uint32 {
	return (volatile.LoadUint32(&o.TAMPCTRL.Reg) & 0x10000) >> 16
}
func (o *RTC_MODE0_Type) SetTAMPCTRL_TAMLVL1(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRL.Reg, volatile.LoadUint32(&o.TAMPCTRL.Reg)&^(0x20000)|value<<17)
}
func (o *RTC_MODE0_Type) GetTAMPCTRL_TAMLVL1() uint32 {
	return (volatile.LoadUint32(&o.TAMPCTRL.Reg) & 0x20000) >> 17
}
func (o *RTC_MODE0_Type) SetTAMPCTRL_TAMLVL2(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRL.Reg, volatile.LoadUint32(&o.TAMPCTRL.Reg)&^(0x40000)|value<<18)
}
func (o *RTC_MODE0_Type) GetTAMPCTRL_TAMLVL2() uint32 {
	return (volatile.LoadUint32(&o.TAMPCTRL.Reg) & 0x40000) >> 18
}
func (o *RTC_MODE0_Type) SetTAMPCTRL_TAMLVL3(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRL.Reg, volatile.LoadUint32(&o.TAMPCTRL.Reg)&^(0x80000)|value<<19)
}
func (o *RTC_MODE0_Type) GetTAMPCTRL_TAMLVL3() uint32 {
	return (volatile.LoadUint32(&o.TAMPCTRL.Reg) & 0x80000) >> 19
}
func (o *RTC_MODE0_Type) SetTAMPCTRL_DEBNC0(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRL.Reg, volatile.LoadUint32(&o.TAMPCTRL.Reg)&^(0x1000000)|value<<24)
}
func (o *RTC_MODE0_Type) GetTAMPCTRL_DEBNC0() uint32 {
	return (volatile.LoadUint32(&o.TAMPCTRL.Reg) & 0x1000000) >> 24
}
func (o *RTC_MODE0_Type) SetTAMPCTRL_DEBNC1(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRL.Reg, volatile.LoadUint32(&o.TAMPCTRL.Reg)&^(0x2000000)|value<<25)
}
func (o *RTC_MODE0_Type) GetTAMPCTRL_DEBNC1() uint32 {
	return (volatile.LoadUint32(&o.TAMPCTRL.Reg) & 0x2000000) >> 25
}
func (o *RTC_MODE0_Type) SetTAMPCTRL_DEBNC2(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRL.Reg, volatile.LoadUint32(&o.TAMPCTRL.Reg)&^(0x4000000)|value<<26)
}
func (o *RTC_MODE0_Type) GetTAMPCTRL_DEBNC2() uint32 {
	return (volatile.LoadUint32(&o.TAMPCTRL.Reg) & 0x4000000) >> 26
}
func (o *RTC_MODE0_Type) SetTAMPCTRL_DEBNC3(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRL.Reg, volatile.LoadUint32(&o.TAMPCTRL.Reg)&^(0x8000000)|value<<27)
}
func (o *RTC_MODE0_Type) GetTAMPCTRL_DEBNC3() uint32 {
	return (volatile.LoadUint32(&o.TAMPCTRL.Reg) & 0x8000000) >> 27
}

// RTC_MODE0.TIMESTAMP: MODE0 Timestamp
func (o *RTC_MODE0_Type) SetTIMESTAMP(value uint32) {
	volatile.StoreUint32(&o.TIMESTAMP.Reg, value)
}
func (o *RTC_MODE0_Type) GetTIMESTAMP() uint32 {
	return volatile.LoadUint32(&o.TIMESTAMP.Reg)
}

// RTC_MODE0.TAMPID: Tamper ID
func (o *RTC_MODE0_Type) SetTAMPID_TAMPID0(value uint32) {
	volatile.StoreUint32(&o.TAMPID.Reg, volatile.LoadUint32(&o.TAMPID.Reg)&^(0x1)|value)
}
func (o *RTC_MODE0_Type) GetTAMPID_TAMPID0() uint32 {
	return volatile.LoadUint32(&o.TAMPID.Reg) & 0x1
}
func (o *RTC_MODE0_Type) SetTAMPID_TAMPID1(value uint32) {
	volatile.StoreUint32(&o.TAMPID.Reg, volatile.LoadUint32(&o.TAMPID.Reg)&^(0x2)|value<<1)
}
func (o *RTC_MODE0_Type) GetTAMPID_TAMPID1() uint32 {
	return (volatile.LoadUint32(&o.TAMPID.Reg) & 0x2) >> 1
}
func (o *RTC_MODE0_Type) SetTAMPID_TAMPID2(value uint32) {
	volatile.StoreUint32(&o.TAMPID.Reg, volatile.LoadUint32(&o.TAMPID.Reg)&^(0x4)|value<<2)
}
func (o *RTC_MODE0_Type) GetTAMPID_TAMPID2() uint32 {
	return (volatile.LoadUint32(&o.TAMPID.Reg) & 0x4) >> 2
}
func (o *RTC_MODE0_Type) SetTAMPID_TAMPID3(value uint32) {
	volatile.StoreUint32(&o.TAMPID.Reg, volatile.LoadUint32(&o.TAMPID.Reg)&^(0x8)|value<<3)
}
func (o *RTC_MODE0_Type) GetTAMPID_TAMPID3() uint32 {
	return (volatile.LoadUint32(&o.TAMPID.Reg) & 0x8) >> 3
}
func (o *RTC_MODE0_Type) SetTAMPID_TAMPEVT(value uint32) {
	volatile.StoreUint32(&o.TAMPID.Reg, volatile.LoadUint32(&o.TAMPID.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_MODE0_Type) GetTAMPID_TAMPEVT() uint32 {
	return (volatile.LoadUint32(&o.TAMPID.Reg) & 0x80000000) >> 31
}

// RTC_MODE0.TAMPCTRLB: Tamper Control B
func (o *RTC_MODE0_Type) SetTAMPCTRLB_ALSI0(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRLB.Reg, volatile.LoadUint32(&o.TAMPCTRLB.Reg)&^(0x1)|value)
}
func (o *RTC_MODE0_Type) GetTAMPCTRLB_ALSI0() uint32 {
	return volatile.LoadUint32(&o.TAMPCTRLB.Reg) & 0x1
}
func (o *RTC_MODE0_Type) SetTAMPCTRLB_ALSI1(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRLB.Reg, volatile.LoadUint32(&o.TAMPCTRLB.Reg)&^(0x2)|value<<1)
}
func (o *RTC_MODE0_Type) GetTAMPCTRLB_ALSI1() uint32 {
	return (volatile.LoadUint32(&o.TAMPCTRLB.Reg) & 0x2) >> 1
}
func (o *RTC_MODE0_Type) SetTAMPCTRLB_ALSI2(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRLB.Reg, volatile.LoadUint32(&o.TAMPCTRLB.Reg)&^(0x4)|value<<2)
}
func (o *RTC_MODE0_Type) GetTAMPCTRLB_ALSI2() uint32 {
	return (volatile.LoadUint32(&o.TAMPCTRLB.Reg) & 0x4) >> 2
}
func (o *RTC_MODE0_Type) SetTAMPCTRLB_ALSI3(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRLB.Reg, volatile.LoadUint32(&o.TAMPCTRLB.Reg)&^(0x8)|value<<3)
}
func (o *RTC_MODE0_Type) GetTAMPCTRLB_ALSI3() uint32 {
	return (volatile.LoadUint32(&o.TAMPCTRLB.Reg) & 0x8) >> 3
}

// Real-Time Counter - MODE1
type RTC_MODE1_Type struct {
	CTRLA     volatile.Register16 // 0x0
	CTRLB     volatile.Register16 // 0x2
	EVCTRL    volatile.Register32 // 0x4
	INTENCLR  volatile.Register16 // 0x8
	INTENSET  volatile.Register16 // 0xA
	INTFLAG   volatile.Register16 // 0xC
	DBGCTRL   volatile.Register8  // 0xE
	_         byte
	SYNCBUSY  volatile.Register32 // 0x10
	FREQCORR  volatile.Register8  // 0x14
	_         [3]byte
	COUNT     volatile.Register16 // 0x18
	_         [2]byte
	PER       volatile.Register16 // 0x1C
	_         [2]byte
	COMP      [2]volatile.Register16 // 0x20
	_         [28]byte
	GP        [2]volatile.Register32 // 0x40
	_         [24]byte
	TAMPCTRL  volatile.Register32 // 0x60
	TIMESTAMP volatile.Register32 // 0x64
	TAMPID    volatile.Register32 // 0x68
	TAMPCTRLB volatile.Register32 // 0x6C
}

// RTC_MODE1.CTRLA: MODE1 Control A
func (o *RTC_MODE1_Type) SetCTRLA_SWRST(value uint16) {
	volatile.StoreUint16(&o.CTRLA.Reg, volatile.LoadUint16(&o.CTRLA.Reg)&^(0x1)|value)
}
func (o *RTC_MODE1_Type) GetCTRLA_SWRST() uint16 {
	return volatile.LoadUint16(&o.CTRLA.Reg) & 0x1
}
func (o *RTC_MODE1_Type) SetCTRLA_ENABLE(value uint16) {
	volatile.StoreUint16(&o.CTRLA.Reg, volatile.LoadUint16(&o.CTRLA.Reg)&^(0x2)|value<<1)
}
func (o *RTC_MODE1_Type) GetCTRLA_ENABLE() uint16 {
	return (volatile.LoadUint16(&o.CTRLA.Reg) & 0x2) >> 1
}
func (o *RTC_MODE1_Type) SetCTRLA_MODE(value uint16) {
	volatile.StoreUint16(&o.CTRLA.Reg, volatile.LoadUint16(&o.CTRLA.Reg)&^(0xc)|value<<2)
}
func (o *RTC_MODE1_Type) GetCTRLA_MODE() uint16 {
	return (volatile.LoadUint16(&o.CTRLA.Reg) & 0xc) >> 2
}
func (o *RTC_MODE1_Type) SetCTRLA_PRESCALER(value uint16) {
	volatile.StoreUint16(&o.CTRLA.Reg, volatile.LoadUint16(&o.CTRLA.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_MODE1_Type) GetCTRLA_PRESCALER() uint16 {
	return (volatile.LoadUint16(&o.CTRLA.Reg) & 0xf00) >> 8
}
func (o *RTC_MODE1_Type) SetCTRLA_GPTRST(value uint16) {
	volatile.StoreUint16(&o.CTRLA.Reg, volatile.LoadUint16(&o.CTRLA.Reg)&^(0x4000)|value<<14)
}
func (o *RTC_MODE1_Type) GetCTRLA_GPTRST() uint16 {
	return (volatile.LoadUint16(&o.CTRLA.Reg) & 0x4000) >> 14
}
func (o *RTC_MODE1_Type) SetCTRLA_COUNTSYNC(value uint16) {
	volatile.StoreUint16(&o.CTRLA.Reg, volatile.LoadUint16(&o.CTRLA.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_MODE1_Type) GetCTRLA_COUNTSYNC() uint16 {
	return (volatile.LoadUint16(&o.CTRLA.Reg) & 0x8000) >> 15
}

// RTC_MODE1.CTRLB: MODE1 Control B
func (o *RTC_MODE1_Type) SetCTRLB_GP0EN(value uint16) {
	volatile.StoreUint16(&o.CTRLB.Reg, volatile.LoadUint16(&o.CTRLB.Reg)&^(0x1)|value)
}
func (o *RTC_MODE1_Type) GetCTRLB_GP0EN() uint16 {
	return volatile.LoadUint16(&o.CTRLB.Reg) & 0x1
}
func (o *RTC_MODE1_Type) SetCTRLB_DEBMAJ(value uint16) {
	volatile.StoreUint16(&o.CTRLB.Reg, volatile.LoadUint16(&o.CTRLB.Reg)&^(0x10)|value<<4)
}
func (o *RTC_MODE1_Type) GetCTRLB_DEBMAJ() uint16 {
	return (volatile.LoadUint16(&o.CTRLB.Reg) & 0x10) >> 4
}
func (o *RTC_MODE1_Type) SetCTRLB_DEBASYNC(value uint16) {
	volatile.StoreUint16(&o.CTRLB.Reg, volatile.LoadUint16(&o.CTRLB.Reg)&^(0x20)|value<<5)
}
func (o *RTC_MODE1_Type) GetCTRLB_DEBASYNC() uint16 {
	return (volatile.LoadUint16(&o.CTRLB.Reg) & 0x20) >> 5
}
func (o *RTC_MODE1_Type) SetCTRLB_RTCOUT(value uint16) {
	volatile.StoreUint16(&o.CTRLB.Reg, volatile.LoadUint16(&o.CTRLB.Reg)&^(0x40)|value<<6)
}
func (o *RTC_MODE1_Type) GetCTRLB_RTCOUT() uint16 {
	return (volatile.LoadUint16(&o.CTRLB.Reg) & 0x40) >> 6
}
func (o *RTC_MODE1_Type) SetCTRLB_DMAEN(value uint16) {
	volatile.StoreUint16(&o.CTRLB.Reg, volatile.LoadUint16(&o.CTRLB.Reg)&^(0x80)|value<<7)
}
func (o *RTC_MODE1_Type) GetCTRLB_DMAEN() uint16 {
	return (volatile.LoadUint16(&o.CTRLB.Reg) & 0x80) >> 7
}
func (o *RTC_MODE1_Type) SetCTRLB_DEBF(value uint16) {
	volatile.StoreUint16(&o.CTRLB.Reg, volatile.LoadUint16(&o.CTRLB.Reg)&^(0x700)|value<<8)
}
func (o *RTC_MODE1_Type) GetCTRLB_DEBF() uint16 {
	return (volatile.LoadUint16(&o.CTRLB.Reg) & 0x700) >> 8
}
func (o *RTC_MODE1_Type) SetCTRLB_ACTF(value uint16) {
	volatile.StoreUint16(&o.CTRLB.Reg, volatile.LoadUint16(&o.CTRLB.Reg)&^(0x7000)|value<<12)
}
func (o *RTC_MODE1_Type) GetCTRLB_ACTF() uint16 {
	return (volatile.LoadUint16(&o.CTRLB.Reg) & 0x7000) >> 12
}
func (o *RTC_MODE1_Type) SetCTRLB_SEPTO(value uint16) {
	volatile.StoreUint16(&o.CTRLB.Reg, volatile.LoadUint16(&o.CTRLB.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_MODE1_Type) GetCTRLB_SEPTO() uint16 {
	return (volatile.LoadUint16(&o.CTRLB.Reg) & 0x8000) >> 15
}

// RTC_MODE1.EVCTRL: MODE1 Event Control
func (o *RTC_MODE1_Type) SetEVCTRL_PEREO0(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x1)|value)
}
func (o *RTC_MODE1_Type) GetEVCTRL_PEREO0() uint32 {
	return volatile.LoadUint32(&o.EVCTRL.Reg) & 0x1
}
func (o *RTC_MODE1_Type) SetEVCTRL_PEREO1(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x2)|value<<1)
}
func (o *RTC_MODE1_Type) GetEVCTRL_PEREO1() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x2) >> 1
}
func (o *RTC_MODE1_Type) SetEVCTRL_PEREO2(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x4)|value<<2)
}
func (o *RTC_MODE1_Type) GetEVCTRL_PEREO2() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x4) >> 2
}
func (o *RTC_MODE1_Type) SetEVCTRL_PEREO3(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x8)|value<<3)
}
func (o *RTC_MODE1_Type) GetEVCTRL_PEREO3() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x8) >> 3
}
func (o *RTC_MODE1_Type) SetEVCTRL_PEREO4(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x10)|value<<4)
}
func (o *RTC_MODE1_Type) GetEVCTRL_PEREO4() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x10) >> 4
}
func (o *RTC_MODE1_Type) SetEVCTRL_PEREO5(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x20)|value<<5)
}
func (o *RTC_MODE1_Type) GetEVCTRL_PEREO5() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x20) >> 5
}
func (o *RTC_MODE1_Type) SetEVCTRL_PEREO6(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x40)|value<<6)
}
func (o *RTC_MODE1_Type) GetEVCTRL_PEREO6() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x40) >> 6
}
func (o *RTC_MODE1_Type) SetEVCTRL_PEREO7(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x80)|value<<7)
}
func (o *RTC_MODE1_Type) GetEVCTRL_PEREO7() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x80) >> 7
}
func (o *RTC_MODE1_Type) SetEVCTRL_CMPEO0(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x100)|value<<8)
}
func (o *RTC_MODE1_Type) GetEVCTRL_CMPEO0() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x100) >> 8
}
func (o *RTC_MODE1_Type) SetEVCTRL_CMPEO1(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x200)|value<<9)
}
func (o *RTC_MODE1_Type) GetEVCTRL_CMPEO1() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x200) >> 9
}
func (o *RTC_MODE1_Type) SetEVCTRL_TAMPEREO(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x4000)|value<<14)
}
func (o *RTC_MODE1_Type) GetEVCTRL_TAMPEREO() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x4000) >> 14
}
func (o *RTC_MODE1_Type) SetEVCTRL_OVFEO(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_MODE1_Type) GetEVCTRL_OVFEO() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x8000) >> 15
}
func (o *RTC_MODE1_Type) SetEVCTRL_TAMPEVEI(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x10000)|value<<16)
}
func (o *RTC_MODE1_Type) GetEVCTRL_TAMPEVEI() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x10000) >> 16
}
func (o *RTC_MODE1_Type) SetEVCTRL_PERDEO(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x1000000)|value<<24)
}
func (o *RTC_MODE1_Type) GetEVCTRL_PERDEO() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x1000000) >> 24
}

// RTC_MODE1.INTENCLR: MODE1 Interrupt Enable Clear
func (o *RTC_MODE1_Type) SetINTENCLR_PER0(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *RTC_MODE1_Type) GetINTENCLR_PER0() uint16 {
	return volatile.LoadUint16(&o.INTENCLR.Reg) & 0x1
}
func (o *RTC_MODE1_Type) SetINTENCLR_PER1(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *RTC_MODE1_Type) GetINTENCLR_PER1() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *RTC_MODE1_Type) SetINTENCLR_PER2(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *RTC_MODE1_Type) GetINTENCLR_PER2() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x4) >> 2
}
func (o *RTC_MODE1_Type) SetINTENCLR_PER3(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x8)|value<<3)
}
func (o *RTC_MODE1_Type) GetINTENCLR_PER3() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x8) >> 3
}
func (o *RTC_MODE1_Type) SetINTENCLR_PER4(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x10)|value<<4)
}
func (o *RTC_MODE1_Type) GetINTENCLR_PER4() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x10) >> 4
}
func (o *RTC_MODE1_Type) SetINTENCLR_PER5(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x20)|value<<5)
}
func (o *RTC_MODE1_Type) GetINTENCLR_PER5() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x20) >> 5
}
func (o *RTC_MODE1_Type) SetINTENCLR_PER6(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x40)|value<<6)
}
func (o *RTC_MODE1_Type) GetINTENCLR_PER6() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x40) >> 6
}
func (o *RTC_MODE1_Type) SetINTENCLR_PER7(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x80)|value<<7)
}
func (o *RTC_MODE1_Type) GetINTENCLR_PER7() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x80) >> 7
}
func (o *RTC_MODE1_Type) SetINTENCLR_CMP0(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x100)|value<<8)
}
func (o *RTC_MODE1_Type) GetINTENCLR_CMP0() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x100) >> 8
}
func (o *RTC_MODE1_Type) SetINTENCLR_CMP1(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x200)|value<<9)
}
func (o *RTC_MODE1_Type) GetINTENCLR_CMP1() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x200) >> 9
}
func (o *RTC_MODE1_Type) SetINTENCLR_TAMPER(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x4000)|value<<14)
}
func (o *RTC_MODE1_Type) GetINTENCLR_TAMPER() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x4000) >> 14
}
func (o *RTC_MODE1_Type) SetINTENCLR_OVF(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_MODE1_Type) GetINTENCLR_OVF() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x8000) >> 15
}

// RTC_MODE1.INTENSET: MODE1 Interrupt Enable Set
func (o *RTC_MODE1_Type) SetINTENSET_PER0(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *RTC_MODE1_Type) GetINTENSET_PER0() uint16 {
	return volatile.LoadUint16(&o.INTENSET.Reg) & 0x1
}
func (o *RTC_MODE1_Type) SetINTENSET_PER1(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *RTC_MODE1_Type) GetINTENSET_PER1() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *RTC_MODE1_Type) SetINTENSET_PER2(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *RTC_MODE1_Type) GetINTENSET_PER2() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x4) >> 2
}
func (o *RTC_MODE1_Type) SetINTENSET_PER3(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x8)|value<<3)
}
func (o *RTC_MODE1_Type) GetINTENSET_PER3() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x8) >> 3
}
func (o *RTC_MODE1_Type) SetINTENSET_PER4(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x10)|value<<4)
}
func (o *RTC_MODE1_Type) GetINTENSET_PER4() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x10) >> 4
}
func (o *RTC_MODE1_Type) SetINTENSET_PER5(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x20)|value<<5)
}
func (o *RTC_MODE1_Type) GetINTENSET_PER5() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x20) >> 5
}
func (o *RTC_MODE1_Type) SetINTENSET_PER6(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x40)|value<<6)
}
func (o *RTC_MODE1_Type) GetINTENSET_PER6() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x40) >> 6
}
func (o *RTC_MODE1_Type) SetINTENSET_PER7(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x80)|value<<7)
}
func (o *RTC_MODE1_Type) GetINTENSET_PER7() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x80) >> 7
}
func (o *RTC_MODE1_Type) SetINTENSET_CMP0(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x100)|value<<8)
}
func (o *RTC_MODE1_Type) GetINTENSET_CMP0() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x100) >> 8
}
func (o *RTC_MODE1_Type) SetINTENSET_CMP1(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x200)|value<<9)
}
func (o *RTC_MODE1_Type) GetINTENSET_CMP1() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x200) >> 9
}
func (o *RTC_MODE1_Type) SetINTENSET_TAMPER(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x4000)|value<<14)
}
func (o *RTC_MODE1_Type) GetINTENSET_TAMPER() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x4000) >> 14
}
func (o *RTC_MODE1_Type) SetINTENSET_OVF(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_MODE1_Type) GetINTENSET_OVF() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x8000) >> 15
}

// RTC_MODE1.INTFLAG: MODE1 Interrupt Flag Status and Clear
func (o *RTC_MODE1_Type) SetINTFLAG_PER0(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x1)|value)
}
func (o *RTC_MODE1_Type) GetINTFLAG_PER0() uint16 {
	return volatile.LoadUint16(&o.INTFLAG.Reg) & 0x1
}
func (o *RTC_MODE1_Type) SetINTFLAG_PER1(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x2)|value<<1)
}
func (o *RTC_MODE1_Type) GetINTFLAG_PER1() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x2) >> 1
}
func (o *RTC_MODE1_Type) SetINTFLAG_PER2(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x4)|value<<2)
}
func (o *RTC_MODE1_Type) GetINTFLAG_PER2() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x4) >> 2
}
func (o *RTC_MODE1_Type) SetINTFLAG_PER3(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x8)|value<<3)
}
func (o *RTC_MODE1_Type) GetINTFLAG_PER3() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x8) >> 3
}
func (o *RTC_MODE1_Type) SetINTFLAG_PER4(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x10)|value<<4)
}
func (o *RTC_MODE1_Type) GetINTFLAG_PER4() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x10) >> 4
}
func (o *RTC_MODE1_Type) SetINTFLAG_PER5(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x20)|value<<5)
}
func (o *RTC_MODE1_Type) GetINTFLAG_PER5() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x20) >> 5
}
func (o *RTC_MODE1_Type) SetINTFLAG_PER6(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x40)|value<<6)
}
func (o *RTC_MODE1_Type) GetINTFLAG_PER6() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x40) >> 6
}
func (o *RTC_MODE1_Type) SetINTFLAG_PER7(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x80)|value<<7)
}
func (o *RTC_MODE1_Type) GetINTFLAG_PER7() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x80) >> 7
}
func (o *RTC_MODE1_Type) SetINTFLAG_CMP0(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x100)|value<<8)
}
func (o *RTC_MODE1_Type) GetINTFLAG_CMP0() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x100) >> 8
}
func (o *RTC_MODE1_Type) SetINTFLAG_CMP1(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x200)|value<<9)
}
func (o *RTC_MODE1_Type) GetINTFLAG_CMP1() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x200) >> 9
}
func (o *RTC_MODE1_Type) SetINTFLAG_TAMPER(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x4000)|value<<14)
}
func (o *RTC_MODE1_Type) GetINTFLAG_TAMPER() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x4000) >> 14
}
func (o *RTC_MODE1_Type) SetINTFLAG_OVF(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_MODE1_Type) GetINTFLAG_OVF() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x8000) >> 15
}

// RTC_MODE1.DBGCTRL: Debug Control
func (o *RTC_MODE1_Type) SetDBGCTRL_DBGRUN(value uint8) {
	volatile.StoreUint8(&o.DBGCTRL.Reg, volatile.LoadUint8(&o.DBGCTRL.Reg)&^(0x1)|value)
}
func (o *RTC_MODE1_Type) GetDBGCTRL_DBGRUN() uint8 {
	return volatile.LoadUint8(&o.DBGCTRL.Reg) & 0x1
}

// RTC_MODE1.SYNCBUSY: MODE1 Synchronization Busy Status
func (o *RTC_MODE1_Type) SetSYNCBUSY_SWRST(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x1)|value)
}
func (o *RTC_MODE1_Type) GetSYNCBUSY_SWRST() uint32 {
	return volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x1
}
func (o *RTC_MODE1_Type) SetSYNCBUSY_ENABLE(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x2)|value<<1)
}
func (o *RTC_MODE1_Type) GetSYNCBUSY_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x2) >> 1
}
func (o *RTC_MODE1_Type) SetSYNCBUSY_FREQCORR(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x4)|value<<2)
}
func (o *RTC_MODE1_Type) GetSYNCBUSY_FREQCORR() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x4) >> 2
}
func (o *RTC_MODE1_Type) SetSYNCBUSY_COUNT(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x8)|value<<3)
}
func (o *RTC_MODE1_Type) GetSYNCBUSY_COUNT() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x8) >> 3
}
func (o *RTC_MODE1_Type) SetSYNCBUSY_PER(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x10)|value<<4)
}
func (o *RTC_MODE1_Type) GetSYNCBUSY_PER() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x10) >> 4
}
func (o *RTC_MODE1_Type) SetSYNCBUSY_COMP0(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x20)|value<<5)
}
func (o *RTC_MODE1_Type) GetSYNCBUSY_COMP0() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x20) >> 5
}
func (o *RTC_MODE1_Type) SetSYNCBUSY_COMP1(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x40)|value<<6)
}
func (o *RTC_MODE1_Type) GetSYNCBUSY_COMP1() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x40) >> 6
}
func (o *RTC_MODE1_Type) SetSYNCBUSY_COUNTSYNC(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_MODE1_Type) GetSYNCBUSY_COUNTSYNC() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x8000) >> 15
}
func (o *RTC_MODE1_Type) SetSYNCBUSY_GP0(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x10000)|value<<16)
}
func (o *RTC_MODE1_Type) GetSYNCBUSY_GP0() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x10000) >> 16
}
func (o *RTC_MODE1_Type) SetSYNCBUSY_GP1(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x20000)|value<<17)
}
func (o *RTC_MODE1_Type) GetSYNCBUSY_GP1() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x20000) >> 17
}

// RTC_MODE1.FREQCORR: Frequency Correction
func (o *RTC_MODE1_Type) SetFREQCORR_VALUE(value uint8) {
	volatile.StoreUint8(&o.FREQCORR.Reg, volatile.LoadUint8(&o.FREQCORR.Reg)&^(0x7f)|value)
}
func (o *RTC_MODE1_Type) GetFREQCORR_VALUE() uint8 {
	return volatile.LoadUint8(&o.FREQCORR.Reg) & 0x7f
}
func (o *RTC_MODE1_Type) SetFREQCORR_SIGN(value uint8) {
	volatile.StoreUint8(&o.FREQCORR.Reg, volatile.LoadUint8(&o.FREQCORR.Reg)&^(0x80)|value<<7)
}
func (o *RTC_MODE1_Type) GetFREQCORR_SIGN() uint8 {
	return (volatile.LoadUint8(&o.FREQCORR.Reg) & 0x80) >> 7
}

// RTC_MODE1.COUNT: MODE1 Counter Value
func (o *RTC_MODE1_Type) SetCOUNT(value uint16) {
	volatile.StoreUint16(&o.COUNT.Reg, value)
}
func (o *RTC_MODE1_Type) GetCOUNT() uint16 {
	return volatile.LoadUint16(&o.COUNT.Reg)
}

// RTC_MODE1.PER: MODE1 Counter Period
func (o *RTC_MODE1_Type) SetPER(value uint16) {
	volatile.StoreUint16(&o.PER.Reg, value)
}
func (o *RTC_MODE1_Type) GetPER() uint16 {
	return volatile.LoadUint16(&o.PER.Reg)
}

// RTC_MODE1.COMP: MODE1 Compare n Value
func (o *RTC_MODE1_Type) SetCOMP(idx int, value uint16) {
	volatile.StoreUint16(&o.COMP[idx].Reg, value)
}
func (o *RTC_MODE1_Type) GetCOMP(idx int) uint16 {
	return volatile.LoadUint16(&o.COMP[idx].Reg)
}

// RTC_MODE1.GP: General Purpose
func (o *RTC_MODE1_Type) SetGP(idx int, value uint32) {
	volatile.StoreUint32(&o.GP[idx].Reg, value)
}
func (o *RTC_MODE1_Type) GetGP(idx int) uint32 {
	return volatile.LoadUint32(&o.GP[idx].Reg)
}

// RTC_MODE1.TAMPCTRL: Tamper Control
func (o *RTC_MODE1_Type) SetTAMPCTRL_IN0ACT(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRL.Reg, volatile.LoadUint32(&o.TAMPCTRL.Reg)&^(0x3)|value)
}
func (o *RTC_MODE1_Type) GetTAMPCTRL_IN0ACT() uint32 {
	return volatile.LoadUint32(&o.TAMPCTRL.Reg) & 0x3
}
func (o *RTC_MODE1_Type) SetTAMPCTRL_IN1ACT(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRL.Reg, volatile.LoadUint32(&o.TAMPCTRL.Reg)&^(0xc)|value<<2)
}
func (o *RTC_MODE1_Type) GetTAMPCTRL_IN1ACT() uint32 {
	return (volatile.LoadUint32(&o.TAMPCTRL.Reg) & 0xc) >> 2
}
func (o *RTC_MODE1_Type) SetTAMPCTRL_IN2ACT(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRL.Reg, volatile.LoadUint32(&o.TAMPCTRL.Reg)&^(0x30)|value<<4)
}
func (o *RTC_MODE1_Type) GetTAMPCTRL_IN2ACT() uint32 {
	return (volatile.LoadUint32(&o.TAMPCTRL.Reg) & 0x30) >> 4
}
func (o *RTC_MODE1_Type) SetTAMPCTRL_IN3ACT(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRL.Reg, volatile.LoadUint32(&o.TAMPCTRL.Reg)&^(0xc0)|value<<6)
}
func (o *RTC_MODE1_Type) GetTAMPCTRL_IN3ACT() uint32 {
	return (volatile.LoadUint32(&o.TAMPCTRL.Reg) & 0xc0) >> 6
}
func (o *RTC_MODE1_Type) SetTAMPCTRL_TAMLVL0(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRL.Reg, volatile.LoadUint32(&o.TAMPCTRL.Reg)&^(0x10000)|value<<16)
}
func (o *RTC_MODE1_Type) GetTAMPCTRL_TAMLVL0() uint32 {
	return (volatile.LoadUint32(&o.TAMPCTRL.Reg) & 0x10000) >> 16
}
func (o *RTC_MODE1_Type) SetTAMPCTRL_TAMLVL1(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRL.Reg, volatile.LoadUint32(&o.TAMPCTRL.Reg)&^(0x20000)|value<<17)
}
func (o *RTC_MODE1_Type) GetTAMPCTRL_TAMLVL1() uint32 {
	return (volatile.LoadUint32(&o.TAMPCTRL.Reg) & 0x20000) >> 17
}
func (o *RTC_MODE1_Type) SetTAMPCTRL_TAMLVL2(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRL.Reg, volatile.LoadUint32(&o.TAMPCTRL.Reg)&^(0x40000)|value<<18)
}
func (o *RTC_MODE1_Type) GetTAMPCTRL_TAMLVL2() uint32 {
	return (volatile.LoadUint32(&o.TAMPCTRL.Reg) & 0x40000) >> 18
}
func (o *RTC_MODE1_Type) SetTAMPCTRL_TAMLVL3(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRL.Reg, volatile.LoadUint32(&o.TAMPCTRL.Reg)&^(0x80000)|value<<19)
}
func (o *RTC_MODE1_Type) GetTAMPCTRL_TAMLVL3() uint32 {
	return (volatile.LoadUint32(&o.TAMPCTRL.Reg) & 0x80000) >> 19
}
func (o *RTC_MODE1_Type) SetTAMPCTRL_DEBNC0(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRL.Reg, volatile.LoadUint32(&o.TAMPCTRL.Reg)&^(0x1000000)|value<<24)
}
func (o *RTC_MODE1_Type) GetTAMPCTRL_DEBNC0() uint32 {
	return (volatile.LoadUint32(&o.TAMPCTRL.Reg) & 0x1000000) >> 24
}
func (o *RTC_MODE1_Type) SetTAMPCTRL_DEBNC1(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRL.Reg, volatile.LoadUint32(&o.TAMPCTRL.Reg)&^(0x2000000)|value<<25)
}
func (o *RTC_MODE1_Type) GetTAMPCTRL_DEBNC1() uint32 {
	return (volatile.LoadUint32(&o.TAMPCTRL.Reg) & 0x2000000) >> 25
}
func (o *RTC_MODE1_Type) SetTAMPCTRL_DEBNC2(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRL.Reg, volatile.LoadUint32(&o.TAMPCTRL.Reg)&^(0x4000000)|value<<26)
}
func (o *RTC_MODE1_Type) GetTAMPCTRL_DEBNC2() uint32 {
	return (volatile.LoadUint32(&o.TAMPCTRL.Reg) & 0x4000000) >> 26
}
func (o *RTC_MODE1_Type) SetTAMPCTRL_DEBNC3(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRL.Reg, volatile.LoadUint32(&o.TAMPCTRL.Reg)&^(0x8000000)|value<<27)
}
func (o *RTC_MODE1_Type) GetTAMPCTRL_DEBNC3() uint32 {
	return (volatile.LoadUint32(&o.TAMPCTRL.Reg) & 0x8000000) >> 27
}

// RTC_MODE1.TIMESTAMP: MODE1 Timestamp
func (o *RTC_MODE1_Type) SetTIMESTAMP_COUNT(value uint32) {
	volatile.StoreUint32(&o.TIMESTAMP.Reg, volatile.LoadUint32(&o.TIMESTAMP.Reg)&^(0xffff)|value)
}
func (o *RTC_MODE1_Type) GetTIMESTAMP_COUNT() uint32 {
	return volatile.LoadUint32(&o.TIMESTAMP.Reg) & 0xffff
}

// RTC_MODE1.TAMPID: Tamper ID
func (o *RTC_MODE1_Type) SetTAMPID_TAMPID0(value uint32) {
	volatile.StoreUint32(&o.TAMPID.Reg, volatile.LoadUint32(&o.TAMPID.Reg)&^(0x1)|value)
}
func (o *RTC_MODE1_Type) GetTAMPID_TAMPID0() uint32 {
	return volatile.LoadUint32(&o.TAMPID.Reg) & 0x1
}
func (o *RTC_MODE1_Type) SetTAMPID_TAMPID1(value uint32) {
	volatile.StoreUint32(&o.TAMPID.Reg, volatile.LoadUint32(&o.TAMPID.Reg)&^(0x2)|value<<1)
}
func (o *RTC_MODE1_Type) GetTAMPID_TAMPID1() uint32 {
	return (volatile.LoadUint32(&o.TAMPID.Reg) & 0x2) >> 1
}
func (o *RTC_MODE1_Type) SetTAMPID_TAMPID2(value uint32) {
	volatile.StoreUint32(&o.TAMPID.Reg, volatile.LoadUint32(&o.TAMPID.Reg)&^(0x4)|value<<2)
}
func (o *RTC_MODE1_Type) GetTAMPID_TAMPID2() uint32 {
	return (volatile.LoadUint32(&o.TAMPID.Reg) & 0x4) >> 2
}
func (o *RTC_MODE1_Type) SetTAMPID_TAMPID3(value uint32) {
	volatile.StoreUint32(&o.TAMPID.Reg, volatile.LoadUint32(&o.TAMPID.Reg)&^(0x8)|value<<3)
}
func (o *RTC_MODE1_Type) GetTAMPID_TAMPID3() uint32 {
	return (volatile.LoadUint32(&o.TAMPID.Reg) & 0x8) >> 3
}
func (o *RTC_MODE1_Type) SetTAMPID_TAMPEVT(value uint32) {
	volatile.StoreUint32(&o.TAMPID.Reg, volatile.LoadUint32(&o.TAMPID.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_MODE1_Type) GetTAMPID_TAMPEVT() uint32 {
	return (volatile.LoadUint32(&o.TAMPID.Reg) & 0x80000000) >> 31
}

// RTC_MODE1.TAMPCTRLB: Tamper Control B
func (o *RTC_MODE1_Type) SetTAMPCTRLB_ALSI0(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRLB.Reg, volatile.LoadUint32(&o.TAMPCTRLB.Reg)&^(0x1)|value)
}
func (o *RTC_MODE1_Type) GetTAMPCTRLB_ALSI0() uint32 {
	return volatile.LoadUint32(&o.TAMPCTRLB.Reg) & 0x1
}
func (o *RTC_MODE1_Type) SetTAMPCTRLB_ALSI1(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRLB.Reg, volatile.LoadUint32(&o.TAMPCTRLB.Reg)&^(0x2)|value<<1)
}
func (o *RTC_MODE1_Type) GetTAMPCTRLB_ALSI1() uint32 {
	return (volatile.LoadUint32(&o.TAMPCTRLB.Reg) & 0x2) >> 1
}
func (o *RTC_MODE1_Type) SetTAMPCTRLB_ALSI2(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRLB.Reg, volatile.LoadUint32(&o.TAMPCTRLB.Reg)&^(0x4)|value<<2)
}
func (o *RTC_MODE1_Type) GetTAMPCTRLB_ALSI2() uint32 {
	return (volatile.LoadUint32(&o.TAMPCTRLB.Reg) & 0x4) >> 2
}
func (o *RTC_MODE1_Type) SetTAMPCTRLB_ALSI3(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRLB.Reg, volatile.LoadUint32(&o.TAMPCTRLB.Reg)&^(0x8)|value<<3)
}
func (o *RTC_MODE1_Type) GetTAMPCTRLB_ALSI3() uint32 {
	return (volatile.LoadUint32(&o.TAMPCTRLB.Reg) & 0x8) >> 3
}

// Real-Time Counter - MODE2
type RTC_MODE2_Type struct {
	CTRLA     volatile.Register16 // 0x0
	CTRLB     volatile.Register16 // 0x2
	EVCTRL    volatile.Register32 // 0x4
	INTENCLR  volatile.Register16 // 0x8
	INTENSET  volatile.Register16 // 0xA
	INTFLAG   volatile.Register16 // 0xC
	DBGCTRL   volatile.Register8  // 0xE
	_         byte
	SYNCBUSY  volatile.Register32 // 0x10
	FREQCORR  volatile.Register8  // 0x14
	_         [3]byte
	CLOCK     volatile.Register32 // 0x18
	_         [4]byte
	ALARM     volatile.Register32 // 0x20
	MASK      volatile.Register8  // 0x24
	_         [27]byte
	GP        [2]volatile.Register32 // 0x40
	_         [24]byte
	TAMPCTRL  volatile.Register32 // 0x60
	TIMESTAMP volatile.Register32 // 0x64
	TAMPID    volatile.Register32 // 0x68
	TAMPCTRLB volatile.Register32 // 0x6C
}

// RTC_MODE2.CTRLA: MODE2 Control A
func (o *RTC_MODE2_Type) SetCTRLA_SWRST(value uint16) {
	volatile.StoreUint16(&o.CTRLA.Reg, volatile.LoadUint16(&o.CTRLA.Reg)&^(0x1)|value)
}
func (o *RTC_MODE2_Type) GetCTRLA_SWRST() uint16 {
	return volatile.LoadUint16(&o.CTRLA.Reg) & 0x1
}
func (o *RTC_MODE2_Type) SetCTRLA_ENABLE(value uint16) {
	volatile.StoreUint16(&o.CTRLA.Reg, volatile.LoadUint16(&o.CTRLA.Reg)&^(0x2)|value<<1)
}
func (o *RTC_MODE2_Type) GetCTRLA_ENABLE() uint16 {
	return (volatile.LoadUint16(&o.CTRLA.Reg) & 0x2) >> 1
}
func (o *RTC_MODE2_Type) SetCTRLA_MODE(value uint16) {
	volatile.StoreUint16(&o.CTRLA.Reg, volatile.LoadUint16(&o.CTRLA.Reg)&^(0xc)|value<<2)
}
func (o *RTC_MODE2_Type) GetCTRLA_MODE() uint16 {
	return (volatile.LoadUint16(&o.CTRLA.Reg) & 0xc) >> 2
}
func (o *RTC_MODE2_Type) SetCTRLA_CLKREP(value uint16) {
	volatile.StoreUint16(&o.CTRLA.Reg, volatile.LoadUint16(&o.CTRLA.Reg)&^(0x40)|value<<6)
}
func (o *RTC_MODE2_Type) GetCTRLA_CLKREP() uint16 {
	return (volatile.LoadUint16(&o.CTRLA.Reg) & 0x40) >> 6
}
func (o *RTC_MODE2_Type) SetCTRLA_MATCHCLR(value uint16) {
	volatile.StoreUint16(&o.CTRLA.Reg, volatile.LoadUint16(&o.CTRLA.Reg)&^(0x80)|value<<7)
}
func (o *RTC_MODE2_Type) GetCTRLA_MATCHCLR() uint16 {
	return (volatile.LoadUint16(&o.CTRLA.Reg) & 0x80) >> 7
}
func (o *RTC_MODE2_Type) SetCTRLA_PRESCALER(value uint16) {
	volatile.StoreUint16(&o.CTRLA.Reg, volatile.LoadUint16(&o.CTRLA.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_MODE2_Type) GetCTRLA_PRESCALER() uint16 {
	return (volatile.LoadUint16(&o.CTRLA.Reg) & 0xf00) >> 8
}
func (o *RTC_MODE2_Type) SetCTRLA_GPTRST(value uint16) {
	volatile.StoreUint16(&o.CTRLA.Reg, volatile.LoadUint16(&o.CTRLA.Reg)&^(0x4000)|value<<14)
}
func (o *RTC_MODE2_Type) GetCTRLA_GPTRST() uint16 {
	return (volatile.LoadUint16(&o.CTRLA.Reg) & 0x4000) >> 14
}
func (o *RTC_MODE2_Type) SetCTRLA_CLOCKSYNC(value uint16) {
	volatile.StoreUint16(&o.CTRLA.Reg, volatile.LoadUint16(&o.CTRLA.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_MODE2_Type) GetCTRLA_CLOCKSYNC() uint16 {
	return (volatile.LoadUint16(&o.CTRLA.Reg) & 0x8000) >> 15
}

// RTC_MODE2.CTRLB: MODE2 Control B
func (o *RTC_MODE2_Type) SetCTRLB_GP0EN(value uint16) {
	volatile.StoreUint16(&o.CTRLB.Reg, volatile.LoadUint16(&o.CTRLB.Reg)&^(0x1)|value)
}
func (o *RTC_MODE2_Type) GetCTRLB_GP0EN() uint16 {
	return volatile.LoadUint16(&o.CTRLB.Reg) & 0x1
}
func (o *RTC_MODE2_Type) SetCTRLB_DEBMAJ(value uint16) {
	volatile.StoreUint16(&o.CTRLB.Reg, volatile.LoadUint16(&o.CTRLB.Reg)&^(0x10)|value<<4)
}
func (o *RTC_MODE2_Type) GetCTRLB_DEBMAJ() uint16 {
	return (volatile.LoadUint16(&o.CTRLB.Reg) & 0x10) >> 4
}
func (o *RTC_MODE2_Type) SetCTRLB_DEBASYNC(value uint16) {
	volatile.StoreUint16(&o.CTRLB.Reg, volatile.LoadUint16(&o.CTRLB.Reg)&^(0x20)|value<<5)
}
func (o *RTC_MODE2_Type) GetCTRLB_DEBASYNC() uint16 {
	return (volatile.LoadUint16(&o.CTRLB.Reg) & 0x20) >> 5
}
func (o *RTC_MODE2_Type) SetCTRLB_RTCOUT(value uint16) {
	volatile.StoreUint16(&o.CTRLB.Reg, volatile.LoadUint16(&o.CTRLB.Reg)&^(0x40)|value<<6)
}
func (o *RTC_MODE2_Type) GetCTRLB_RTCOUT() uint16 {
	return (volatile.LoadUint16(&o.CTRLB.Reg) & 0x40) >> 6
}
func (o *RTC_MODE2_Type) SetCTRLB_DMAEN(value uint16) {
	volatile.StoreUint16(&o.CTRLB.Reg, volatile.LoadUint16(&o.CTRLB.Reg)&^(0x80)|value<<7)
}
func (o *RTC_MODE2_Type) GetCTRLB_DMAEN() uint16 {
	return (volatile.LoadUint16(&o.CTRLB.Reg) & 0x80) >> 7
}
func (o *RTC_MODE2_Type) SetCTRLB_DEBF(value uint16) {
	volatile.StoreUint16(&o.CTRLB.Reg, volatile.LoadUint16(&o.CTRLB.Reg)&^(0x700)|value<<8)
}
func (o *RTC_MODE2_Type) GetCTRLB_DEBF() uint16 {
	return (volatile.LoadUint16(&o.CTRLB.Reg) & 0x700) >> 8
}
func (o *RTC_MODE2_Type) SetCTRLB_ACTF(value uint16) {
	volatile.StoreUint16(&o.CTRLB.Reg, volatile.LoadUint16(&o.CTRLB.Reg)&^(0x7000)|value<<12)
}
func (o *RTC_MODE2_Type) GetCTRLB_ACTF() uint16 {
	return (volatile.LoadUint16(&o.CTRLB.Reg) & 0x7000) >> 12
}
func (o *RTC_MODE2_Type) SetCTRLB_SEPTO(value uint16) {
	volatile.StoreUint16(&o.CTRLB.Reg, volatile.LoadUint16(&o.CTRLB.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_MODE2_Type) GetCTRLB_SEPTO() uint16 {
	return (volatile.LoadUint16(&o.CTRLB.Reg) & 0x8000) >> 15
}

// RTC_MODE2.EVCTRL: MODE2 Event Control
func (o *RTC_MODE2_Type) SetEVCTRL_PEREO0(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x1)|value)
}
func (o *RTC_MODE2_Type) GetEVCTRL_PEREO0() uint32 {
	return volatile.LoadUint32(&o.EVCTRL.Reg) & 0x1
}
func (o *RTC_MODE2_Type) SetEVCTRL_PEREO1(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x2)|value<<1)
}
func (o *RTC_MODE2_Type) GetEVCTRL_PEREO1() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x2) >> 1
}
func (o *RTC_MODE2_Type) SetEVCTRL_PEREO2(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x4)|value<<2)
}
func (o *RTC_MODE2_Type) GetEVCTRL_PEREO2() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x4) >> 2
}
func (o *RTC_MODE2_Type) SetEVCTRL_PEREO3(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x8)|value<<3)
}
func (o *RTC_MODE2_Type) GetEVCTRL_PEREO3() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x8) >> 3
}
func (o *RTC_MODE2_Type) SetEVCTRL_PEREO4(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x10)|value<<4)
}
func (o *RTC_MODE2_Type) GetEVCTRL_PEREO4() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x10) >> 4
}
func (o *RTC_MODE2_Type) SetEVCTRL_PEREO5(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x20)|value<<5)
}
func (o *RTC_MODE2_Type) GetEVCTRL_PEREO5() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x20) >> 5
}
func (o *RTC_MODE2_Type) SetEVCTRL_PEREO6(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x40)|value<<6)
}
func (o *RTC_MODE2_Type) GetEVCTRL_PEREO6() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x40) >> 6
}
func (o *RTC_MODE2_Type) SetEVCTRL_PEREO7(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x80)|value<<7)
}
func (o *RTC_MODE2_Type) GetEVCTRL_PEREO7() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x80) >> 7
}
func (o *RTC_MODE2_Type) SetEVCTRL_ALARMEO0(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x100)|value<<8)
}
func (o *RTC_MODE2_Type) GetEVCTRL_ALARMEO0() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x100) >> 8
}
func (o *RTC_MODE2_Type) SetEVCTRL_TAMPEREO(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x4000)|value<<14)
}
func (o *RTC_MODE2_Type) GetEVCTRL_TAMPEREO() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x4000) >> 14
}
func (o *RTC_MODE2_Type) SetEVCTRL_OVFEO(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_MODE2_Type) GetEVCTRL_OVFEO() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x8000) >> 15
}
func (o *RTC_MODE2_Type) SetEVCTRL_TAMPEVEI(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x10000)|value<<16)
}
func (o *RTC_MODE2_Type) GetEVCTRL_TAMPEVEI() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x10000) >> 16
}
func (o *RTC_MODE2_Type) SetEVCTRL_PERDEO(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x1000000)|value<<24)
}
func (o *RTC_MODE2_Type) GetEVCTRL_PERDEO() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x1000000) >> 24
}

// RTC_MODE2.INTENCLR: MODE2 Interrupt Enable Clear
func (o *RTC_MODE2_Type) SetINTENCLR_PER0(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *RTC_MODE2_Type) GetINTENCLR_PER0() uint16 {
	return volatile.LoadUint16(&o.INTENCLR.Reg) & 0x1
}
func (o *RTC_MODE2_Type) SetINTENCLR_PER1(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *RTC_MODE2_Type) GetINTENCLR_PER1() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *RTC_MODE2_Type) SetINTENCLR_PER2(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *RTC_MODE2_Type) GetINTENCLR_PER2() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x4) >> 2
}
func (o *RTC_MODE2_Type) SetINTENCLR_PER3(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x8)|value<<3)
}
func (o *RTC_MODE2_Type) GetINTENCLR_PER3() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x8) >> 3
}
func (o *RTC_MODE2_Type) SetINTENCLR_PER4(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x10)|value<<4)
}
func (o *RTC_MODE2_Type) GetINTENCLR_PER4() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x10) >> 4
}
func (o *RTC_MODE2_Type) SetINTENCLR_PER5(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x20)|value<<5)
}
func (o *RTC_MODE2_Type) GetINTENCLR_PER5() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x20) >> 5
}
func (o *RTC_MODE2_Type) SetINTENCLR_PER6(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x40)|value<<6)
}
func (o *RTC_MODE2_Type) GetINTENCLR_PER6() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x40) >> 6
}
func (o *RTC_MODE2_Type) SetINTENCLR_PER7(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x80)|value<<7)
}
func (o *RTC_MODE2_Type) GetINTENCLR_PER7() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x80) >> 7
}
func (o *RTC_MODE2_Type) SetINTENCLR_ALARM0(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x100)|value<<8)
}
func (o *RTC_MODE2_Type) GetINTENCLR_ALARM0() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x100) >> 8
}
func (o *RTC_MODE2_Type) SetINTENCLR_TAMPER(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x4000)|value<<14)
}
func (o *RTC_MODE2_Type) GetINTENCLR_TAMPER() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x4000) >> 14
}
func (o *RTC_MODE2_Type) SetINTENCLR_OVF(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_MODE2_Type) GetINTENCLR_OVF() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x8000) >> 15
}

// RTC_MODE2.INTENSET: MODE2 Interrupt Enable Set
func (o *RTC_MODE2_Type) SetINTENSET_PER0(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *RTC_MODE2_Type) GetINTENSET_PER0() uint16 {
	return volatile.LoadUint16(&o.INTENSET.Reg) & 0x1
}
func (o *RTC_MODE2_Type) SetINTENSET_PER1(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *RTC_MODE2_Type) GetINTENSET_PER1() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *RTC_MODE2_Type) SetINTENSET_PER2(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *RTC_MODE2_Type) GetINTENSET_PER2() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x4) >> 2
}
func (o *RTC_MODE2_Type) SetINTENSET_PER3(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x8)|value<<3)
}
func (o *RTC_MODE2_Type) GetINTENSET_PER3() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x8) >> 3
}
func (o *RTC_MODE2_Type) SetINTENSET_PER4(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x10)|value<<4)
}
func (o *RTC_MODE2_Type) GetINTENSET_PER4() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x10) >> 4
}
func (o *RTC_MODE2_Type) SetINTENSET_PER5(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x20)|value<<5)
}
func (o *RTC_MODE2_Type) GetINTENSET_PER5() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x20) >> 5
}
func (o *RTC_MODE2_Type) SetINTENSET_PER6(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x40)|value<<6)
}
func (o *RTC_MODE2_Type) GetINTENSET_PER6() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x40) >> 6
}
func (o *RTC_MODE2_Type) SetINTENSET_PER7(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x80)|value<<7)
}
func (o *RTC_MODE2_Type) GetINTENSET_PER7() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x80) >> 7
}
func (o *RTC_MODE2_Type) SetINTENSET_ALARM0(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x100)|value<<8)
}
func (o *RTC_MODE2_Type) GetINTENSET_ALARM0() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x100) >> 8
}
func (o *RTC_MODE2_Type) SetINTENSET_TAMPER(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x4000)|value<<14)
}
func (o *RTC_MODE2_Type) GetINTENSET_TAMPER() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x4000) >> 14
}
func (o *RTC_MODE2_Type) SetINTENSET_OVF(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_MODE2_Type) GetINTENSET_OVF() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x8000) >> 15
}

// RTC_MODE2.INTFLAG: MODE2 Interrupt Flag Status and Clear
func (o *RTC_MODE2_Type) SetINTFLAG_PER0(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x1)|value)
}
func (o *RTC_MODE2_Type) GetINTFLAG_PER0() uint16 {
	return volatile.LoadUint16(&o.INTFLAG.Reg) & 0x1
}
func (o *RTC_MODE2_Type) SetINTFLAG_PER1(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x2)|value<<1)
}
func (o *RTC_MODE2_Type) GetINTFLAG_PER1() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x2) >> 1
}
func (o *RTC_MODE2_Type) SetINTFLAG_PER2(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x4)|value<<2)
}
func (o *RTC_MODE2_Type) GetINTFLAG_PER2() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x4) >> 2
}
func (o *RTC_MODE2_Type) SetINTFLAG_PER3(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x8)|value<<3)
}
func (o *RTC_MODE2_Type) GetINTFLAG_PER3() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x8) >> 3
}
func (o *RTC_MODE2_Type) SetINTFLAG_PER4(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x10)|value<<4)
}
func (o *RTC_MODE2_Type) GetINTFLAG_PER4() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x10) >> 4
}
func (o *RTC_MODE2_Type) SetINTFLAG_PER5(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x20)|value<<5)
}
func (o *RTC_MODE2_Type) GetINTFLAG_PER5() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x20) >> 5
}
func (o *RTC_MODE2_Type) SetINTFLAG_PER6(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x40)|value<<6)
}
func (o *RTC_MODE2_Type) GetINTFLAG_PER6() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x40) >> 6
}
func (o *RTC_MODE2_Type) SetINTFLAG_PER7(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x80)|value<<7)
}
func (o *RTC_MODE2_Type) GetINTFLAG_PER7() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x80) >> 7
}
func (o *RTC_MODE2_Type) SetINTFLAG_ALARM0(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x100)|value<<8)
}
func (o *RTC_MODE2_Type) GetINTFLAG_ALARM0() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x100) >> 8
}
func (o *RTC_MODE2_Type) SetINTFLAG_TAMPER(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x4000)|value<<14)
}
func (o *RTC_MODE2_Type) GetINTFLAG_TAMPER() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x4000) >> 14
}
func (o *RTC_MODE2_Type) SetINTFLAG_OVF(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_MODE2_Type) GetINTFLAG_OVF() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x8000) >> 15
}

// RTC_MODE2.DBGCTRL: Debug Control
func (o *RTC_MODE2_Type) SetDBGCTRL_DBGRUN(value uint8) {
	volatile.StoreUint8(&o.DBGCTRL.Reg, volatile.LoadUint8(&o.DBGCTRL.Reg)&^(0x1)|value)
}
func (o *RTC_MODE2_Type) GetDBGCTRL_DBGRUN() uint8 {
	return volatile.LoadUint8(&o.DBGCTRL.Reg) & 0x1
}

// RTC_MODE2.SYNCBUSY: MODE2 Synchronization Busy Status
func (o *RTC_MODE2_Type) SetSYNCBUSY_SWRST(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x1)|value)
}
func (o *RTC_MODE2_Type) GetSYNCBUSY_SWRST() uint32 {
	return volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x1
}
func (o *RTC_MODE2_Type) SetSYNCBUSY_ENABLE(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x2)|value<<1)
}
func (o *RTC_MODE2_Type) GetSYNCBUSY_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x2) >> 1
}
func (o *RTC_MODE2_Type) SetSYNCBUSY_FREQCORR(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x4)|value<<2)
}
func (o *RTC_MODE2_Type) GetSYNCBUSY_FREQCORR() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x4) >> 2
}
func (o *RTC_MODE2_Type) SetSYNCBUSY_CLOCK(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x8)|value<<3)
}
func (o *RTC_MODE2_Type) GetSYNCBUSY_CLOCK() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x8) >> 3
}
func (o *RTC_MODE2_Type) SetSYNCBUSY_ALARM0(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x20)|value<<5)
}
func (o *RTC_MODE2_Type) GetSYNCBUSY_ALARM0() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x20) >> 5
}
func (o *RTC_MODE2_Type) SetSYNCBUSY_MASK0(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x800)|value<<11)
}
func (o *RTC_MODE2_Type) GetSYNCBUSY_MASK0() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x800) >> 11
}
func (o *RTC_MODE2_Type) SetSYNCBUSY_CLOCKSYNC(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_MODE2_Type) GetSYNCBUSY_CLOCKSYNC() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x8000) >> 15
}
func (o *RTC_MODE2_Type) SetSYNCBUSY_GP0(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x10000)|value<<16)
}
func (o *RTC_MODE2_Type) GetSYNCBUSY_GP0() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x10000) >> 16
}
func (o *RTC_MODE2_Type) SetSYNCBUSY_GP1(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x20000)|value<<17)
}
func (o *RTC_MODE2_Type) GetSYNCBUSY_GP1() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x20000) >> 17
}

// RTC_MODE2.FREQCORR: Frequency Correction
func (o *RTC_MODE2_Type) SetFREQCORR_VALUE(value uint8) {
	volatile.StoreUint8(&o.FREQCORR.Reg, volatile.LoadUint8(&o.FREQCORR.Reg)&^(0x7f)|value)
}
func (o *RTC_MODE2_Type) GetFREQCORR_VALUE() uint8 {
	return volatile.LoadUint8(&o.FREQCORR.Reg) & 0x7f
}
func (o *RTC_MODE2_Type) SetFREQCORR_SIGN(value uint8) {
	volatile.StoreUint8(&o.FREQCORR.Reg, volatile.LoadUint8(&o.FREQCORR.Reg)&^(0x80)|value<<7)
}
func (o *RTC_MODE2_Type) GetFREQCORR_SIGN() uint8 {
	return (volatile.LoadUint8(&o.FREQCORR.Reg) & 0x80) >> 7
}

// RTC_MODE2.CLOCK: MODE2 Clock Value
func (o *RTC_MODE2_Type) SetCLOCK_SECOND(value uint32) {
	volatile.StoreUint32(&o.CLOCK.Reg, volatile.LoadUint32(&o.CLOCK.Reg)&^(0x3f)|value)
}
func (o *RTC_MODE2_Type) GetCLOCK_SECOND() uint32 {
	return volatile.LoadUint32(&o.CLOCK.Reg) & 0x3f
}
func (o *RTC_MODE2_Type) SetCLOCK_MINUTE(value uint32) {
	volatile.StoreUint32(&o.CLOCK.Reg, volatile.LoadUint32(&o.CLOCK.Reg)&^(0xfc0)|value<<6)
}
func (o *RTC_MODE2_Type) GetCLOCK_MINUTE() uint32 {
	return (volatile.LoadUint32(&o.CLOCK.Reg) & 0xfc0) >> 6
}
func (o *RTC_MODE2_Type) SetCLOCK_HOUR(value uint32) {
	volatile.StoreUint32(&o.CLOCK.Reg, volatile.LoadUint32(&o.CLOCK.Reg)&^(0x1f000)|value<<12)
}
func (o *RTC_MODE2_Type) GetCLOCK_HOUR() uint32 {
	return (volatile.LoadUint32(&o.CLOCK.Reg) & 0x1f000) >> 12
}
func (o *RTC_MODE2_Type) SetCLOCK_DAY(value uint32) {
	volatile.StoreUint32(&o.CLOCK.Reg, volatile.LoadUint32(&o.CLOCK.Reg)&^(0x3e0000)|value<<17)
}
func (o *RTC_MODE2_Type) GetCLOCK_DAY() uint32 {
	return (volatile.LoadUint32(&o.CLOCK.Reg) & 0x3e0000) >> 17
}
func (o *RTC_MODE2_Type) SetCLOCK_MONTH(value uint32) {
	volatile.StoreUint32(&o.CLOCK.Reg, volatile.LoadUint32(&o.CLOCK.Reg)&^(0x3c00000)|value<<22)
}
func (o *RTC_MODE2_Type) GetCLOCK_MONTH() uint32 {
	return (volatile.LoadUint32(&o.CLOCK.Reg) & 0x3c00000) >> 22
}
func (o *RTC_MODE2_Type) SetCLOCK_YEAR(value uint32) {
	volatile.StoreUint32(&o.CLOCK.Reg, volatile.LoadUint32(&o.CLOCK.Reg)&^(0xfc000000)|value<<26)
}
func (o *RTC_MODE2_Type) GetCLOCK_YEAR() uint32 {
	return (volatile.LoadUint32(&o.CLOCK.Reg) & 0xfc000000) >> 26
}

// RTC_MODE2.ALARM: MODE2_ALARM Alarm n Value
func (o *RTC_MODE2_Type) SetALARM_SECOND(value uint32) {
	volatile.StoreUint32(&o.ALARM.Reg, volatile.LoadUint32(&o.ALARM.Reg)&^(0x3f)|value)
}
func (o *RTC_MODE2_Type) GetALARM_SECOND() uint32 {
	return volatile.LoadUint32(&o.ALARM.Reg) & 0x3f
}
func (o *RTC_MODE2_Type) SetALARM_MINUTE(value uint32) {
	volatile.StoreUint32(&o.ALARM.Reg, volatile.LoadUint32(&o.ALARM.Reg)&^(0xfc0)|value<<6)
}
func (o *RTC_MODE2_Type) GetALARM_MINUTE() uint32 {
	return (volatile.LoadUint32(&o.ALARM.Reg) & 0xfc0) >> 6
}
func (o *RTC_MODE2_Type) SetALARM_HOUR(value uint32) {
	volatile.StoreUint32(&o.ALARM.Reg, volatile.LoadUint32(&o.ALARM.Reg)&^(0x1f000)|value<<12)
}
func (o *RTC_MODE2_Type) GetALARM_HOUR() uint32 {
	return (volatile.LoadUint32(&o.ALARM.Reg) & 0x1f000) >> 12
}
func (o *RTC_MODE2_Type) SetALARM_DAY(value uint32) {
	volatile.StoreUint32(&o.ALARM.Reg, volatile.LoadUint32(&o.ALARM.Reg)&^(0x3e0000)|value<<17)
}
func (o *RTC_MODE2_Type) GetALARM_DAY() uint32 {
	return (volatile.LoadUint32(&o.ALARM.Reg) & 0x3e0000) >> 17
}
func (o *RTC_MODE2_Type) SetALARM_MONTH(value uint32) {
	volatile.StoreUint32(&o.ALARM.Reg, volatile.LoadUint32(&o.ALARM.Reg)&^(0x3c00000)|value<<22)
}
func (o *RTC_MODE2_Type) GetALARM_MONTH() uint32 {
	return (volatile.LoadUint32(&o.ALARM.Reg) & 0x3c00000) >> 22
}
func (o *RTC_MODE2_Type) SetALARM_YEAR(value uint32) {
	volatile.StoreUint32(&o.ALARM.Reg, volatile.LoadUint32(&o.ALARM.Reg)&^(0xfc000000)|value<<26)
}
func (o *RTC_MODE2_Type) GetALARM_YEAR() uint32 {
	return (volatile.LoadUint32(&o.ALARM.Reg) & 0xfc000000) >> 26
}

// RTC_MODE2.MASK: MODE2_ALARM Alarm n Mask
func (o *RTC_MODE2_Type) SetMASK_SEL(value uint8) {
	volatile.StoreUint8(&o.MASK.Reg, volatile.LoadUint8(&o.MASK.Reg)&^(0x7)|value)
}
func (o *RTC_MODE2_Type) GetMASK_SEL() uint8 {
	return volatile.LoadUint8(&o.MASK.Reg) & 0x7
}

// RTC_MODE2.GP: General Purpose
func (o *RTC_MODE2_Type) SetGP(idx int, value uint32) {
	volatile.StoreUint32(&o.GP[idx].Reg, value)
}
func (o *RTC_MODE2_Type) GetGP(idx int) uint32 {
	return volatile.LoadUint32(&o.GP[idx].Reg)
}

// RTC_MODE2.TAMPCTRL: Tamper Control
func (o *RTC_MODE2_Type) SetTAMPCTRL_IN0ACT(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRL.Reg, volatile.LoadUint32(&o.TAMPCTRL.Reg)&^(0x3)|value)
}
func (o *RTC_MODE2_Type) GetTAMPCTRL_IN0ACT() uint32 {
	return volatile.LoadUint32(&o.TAMPCTRL.Reg) & 0x3
}
func (o *RTC_MODE2_Type) SetTAMPCTRL_IN1ACT(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRL.Reg, volatile.LoadUint32(&o.TAMPCTRL.Reg)&^(0xc)|value<<2)
}
func (o *RTC_MODE2_Type) GetTAMPCTRL_IN1ACT() uint32 {
	return (volatile.LoadUint32(&o.TAMPCTRL.Reg) & 0xc) >> 2
}
func (o *RTC_MODE2_Type) SetTAMPCTRL_IN2ACT(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRL.Reg, volatile.LoadUint32(&o.TAMPCTRL.Reg)&^(0x30)|value<<4)
}
func (o *RTC_MODE2_Type) GetTAMPCTRL_IN2ACT() uint32 {
	return (volatile.LoadUint32(&o.TAMPCTRL.Reg) & 0x30) >> 4
}
func (o *RTC_MODE2_Type) SetTAMPCTRL_IN3ACT(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRL.Reg, volatile.LoadUint32(&o.TAMPCTRL.Reg)&^(0xc0)|value<<6)
}
func (o *RTC_MODE2_Type) GetTAMPCTRL_IN3ACT() uint32 {
	return (volatile.LoadUint32(&o.TAMPCTRL.Reg) & 0xc0) >> 6
}
func (o *RTC_MODE2_Type) SetTAMPCTRL_TAMLVL0(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRL.Reg, volatile.LoadUint32(&o.TAMPCTRL.Reg)&^(0x10000)|value<<16)
}
func (o *RTC_MODE2_Type) GetTAMPCTRL_TAMLVL0() uint32 {
	return (volatile.LoadUint32(&o.TAMPCTRL.Reg) & 0x10000) >> 16
}
func (o *RTC_MODE2_Type) SetTAMPCTRL_TAMLVL1(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRL.Reg, volatile.LoadUint32(&o.TAMPCTRL.Reg)&^(0x20000)|value<<17)
}
func (o *RTC_MODE2_Type) GetTAMPCTRL_TAMLVL1() uint32 {
	return (volatile.LoadUint32(&o.TAMPCTRL.Reg) & 0x20000) >> 17
}
func (o *RTC_MODE2_Type) SetTAMPCTRL_TAMLVL2(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRL.Reg, volatile.LoadUint32(&o.TAMPCTRL.Reg)&^(0x40000)|value<<18)
}
func (o *RTC_MODE2_Type) GetTAMPCTRL_TAMLVL2() uint32 {
	return (volatile.LoadUint32(&o.TAMPCTRL.Reg) & 0x40000) >> 18
}
func (o *RTC_MODE2_Type) SetTAMPCTRL_TAMLVL3(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRL.Reg, volatile.LoadUint32(&o.TAMPCTRL.Reg)&^(0x80000)|value<<19)
}
func (o *RTC_MODE2_Type) GetTAMPCTRL_TAMLVL3() uint32 {
	return (volatile.LoadUint32(&o.TAMPCTRL.Reg) & 0x80000) >> 19
}
func (o *RTC_MODE2_Type) SetTAMPCTRL_DEBNC0(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRL.Reg, volatile.LoadUint32(&o.TAMPCTRL.Reg)&^(0x1000000)|value<<24)
}
func (o *RTC_MODE2_Type) GetTAMPCTRL_DEBNC0() uint32 {
	return (volatile.LoadUint32(&o.TAMPCTRL.Reg) & 0x1000000) >> 24
}
func (o *RTC_MODE2_Type) SetTAMPCTRL_DEBNC1(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRL.Reg, volatile.LoadUint32(&o.TAMPCTRL.Reg)&^(0x2000000)|value<<25)
}
func (o *RTC_MODE2_Type) GetTAMPCTRL_DEBNC1() uint32 {
	return (volatile.LoadUint32(&o.TAMPCTRL.Reg) & 0x2000000) >> 25
}
func (o *RTC_MODE2_Type) SetTAMPCTRL_DEBNC2(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRL.Reg, volatile.LoadUint32(&o.TAMPCTRL.Reg)&^(0x4000000)|value<<26)
}
func (o *RTC_MODE2_Type) GetTAMPCTRL_DEBNC2() uint32 {
	return (volatile.LoadUint32(&o.TAMPCTRL.Reg) & 0x4000000) >> 26
}
func (o *RTC_MODE2_Type) SetTAMPCTRL_DEBNC3(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRL.Reg, volatile.LoadUint32(&o.TAMPCTRL.Reg)&^(0x8000000)|value<<27)
}
func (o *RTC_MODE2_Type) GetTAMPCTRL_DEBNC3() uint32 {
	return (volatile.LoadUint32(&o.TAMPCTRL.Reg) & 0x8000000) >> 27
}

// RTC_MODE2.TIMESTAMP: MODE2 Timestamp
func (o *RTC_MODE2_Type) SetTIMESTAMP_SECOND(value uint32) {
	volatile.StoreUint32(&o.TIMESTAMP.Reg, volatile.LoadUint32(&o.TIMESTAMP.Reg)&^(0x3f)|value)
}
func (o *RTC_MODE2_Type) GetTIMESTAMP_SECOND() uint32 {
	return volatile.LoadUint32(&o.TIMESTAMP.Reg) & 0x3f
}
func (o *RTC_MODE2_Type) SetTIMESTAMP_MINUTE(value uint32) {
	volatile.StoreUint32(&o.TIMESTAMP.Reg, volatile.LoadUint32(&o.TIMESTAMP.Reg)&^(0xfc0)|value<<6)
}
func (o *RTC_MODE2_Type) GetTIMESTAMP_MINUTE() uint32 {
	return (volatile.LoadUint32(&o.TIMESTAMP.Reg) & 0xfc0) >> 6
}
func (o *RTC_MODE2_Type) SetTIMESTAMP_HOUR(value uint32) {
	volatile.StoreUint32(&o.TIMESTAMP.Reg, volatile.LoadUint32(&o.TIMESTAMP.Reg)&^(0x1f000)|value<<12)
}
func (o *RTC_MODE2_Type) GetTIMESTAMP_HOUR() uint32 {
	return (volatile.LoadUint32(&o.TIMESTAMP.Reg) & 0x1f000) >> 12
}
func (o *RTC_MODE2_Type) SetTIMESTAMP_DAY(value uint32) {
	volatile.StoreUint32(&o.TIMESTAMP.Reg, volatile.LoadUint32(&o.TIMESTAMP.Reg)&^(0x3e0000)|value<<17)
}
func (o *RTC_MODE2_Type) GetTIMESTAMP_DAY() uint32 {
	return (volatile.LoadUint32(&o.TIMESTAMP.Reg) & 0x3e0000) >> 17
}
func (o *RTC_MODE2_Type) SetTIMESTAMP_MONTH(value uint32) {
	volatile.StoreUint32(&o.TIMESTAMP.Reg, volatile.LoadUint32(&o.TIMESTAMP.Reg)&^(0x3c00000)|value<<22)
}
func (o *RTC_MODE2_Type) GetTIMESTAMP_MONTH() uint32 {
	return (volatile.LoadUint32(&o.TIMESTAMP.Reg) & 0x3c00000) >> 22
}
func (o *RTC_MODE2_Type) SetTIMESTAMP_YEAR(value uint32) {
	volatile.StoreUint32(&o.TIMESTAMP.Reg, volatile.LoadUint32(&o.TIMESTAMP.Reg)&^(0xfc000000)|value<<26)
}
func (o *RTC_MODE2_Type) GetTIMESTAMP_YEAR() uint32 {
	return (volatile.LoadUint32(&o.TIMESTAMP.Reg) & 0xfc000000) >> 26
}

// RTC_MODE2.TAMPID: Tamper ID
func (o *RTC_MODE2_Type) SetTAMPID_TAMPID0(value uint32) {
	volatile.StoreUint32(&o.TAMPID.Reg, volatile.LoadUint32(&o.TAMPID.Reg)&^(0x1)|value)
}
func (o *RTC_MODE2_Type) GetTAMPID_TAMPID0() uint32 {
	return volatile.LoadUint32(&o.TAMPID.Reg) & 0x1
}
func (o *RTC_MODE2_Type) SetTAMPID_TAMPID1(value uint32) {
	volatile.StoreUint32(&o.TAMPID.Reg, volatile.LoadUint32(&o.TAMPID.Reg)&^(0x2)|value<<1)
}
func (o *RTC_MODE2_Type) GetTAMPID_TAMPID1() uint32 {
	return (volatile.LoadUint32(&o.TAMPID.Reg) & 0x2) >> 1
}
func (o *RTC_MODE2_Type) SetTAMPID_TAMPID2(value uint32) {
	volatile.StoreUint32(&o.TAMPID.Reg, volatile.LoadUint32(&o.TAMPID.Reg)&^(0x4)|value<<2)
}
func (o *RTC_MODE2_Type) GetTAMPID_TAMPID2() uint32 {
	return (volatile.LoadUint32(&o.TAMPID.Reg) & 0x4) >> 2
}
func (o *RTC_MODE2_Type) SetTAMPID_TAMPID3(value uint32) {
	volatile.StoreUint32(&o.TAMPID.Reg, volatile.LoadUint32(&o.TAMPID.Reg)&^(0x8)|value<<3)
}
func (o *RTC_MODE2_Type) GetTAMPID_TAMPID3() uint32 {
	return (volatile.LoadUint32(&o.TAMPID.Reg) & 0x8) >> 3
}
func (o *RTC_MODE2_Type) SetTAMPID_TAMPEVT(value uint32) {
	volatile.StoreUint32(&o.TAMPID.Reg, volatile.LoadUint32(&o.TAMPID.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_MODE2_Type) GetTAMPID_TAMPEVT() uint32 {
	return (volatile.LoadUint32(&o.TAMPID.Reg) & 0x80000000) >> 31
}

// RTC_MODE2.TAMPCTRLB: Tamper Control B
func (o *RTC_MODE2_Type) SetTAMPCTRLB_ALSI0(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRLB.Reg, volatile.LoadUint32(&o.TAMPCTRLB.Reg)&^(0x1)|value)
}
func (o *RTC_MODE2_Type) GetTAMPCTRLB_ALSI0() uint32 {
	return volatile.LoadUint32(&o.TAMPCTRLB.Reg) & 0x1
}
func (o *RTC_MODE2_Type) SetTAMPCTRLB_ALSI1(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRLB.Reg, volatile.LoadUint32(&o.TAMPCTRLB.Reg)&^(0x2)|value<<1)
}
func (o *RTC_MODE2_Type) GetTAMPCTRLB_ALSI1() uint32 {
	return (volatile.LoadUint32(&o.TAMPCTRLB.Reg) & 0x2) >> 1
}
func (o *RTC_MODE2_Type) SetTAMPCTRLB_ALSI2(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRLB.Reg, volatile.LoadUint32(&o.TAMPCTRLB.Reg)&^(0x4)|value<<2)
}
func (o *RTC_MODE2_Type) GetTAMPCTRLB_ALSI2() uint32 {
	return (volatile.LoadUint32(&o.TAMPCTRLB.Reg) & 0x4) >> 2
}
func (o *RTC_MODE2_Type) SetTAMPCTRLB_ALSI3(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRLB.Reg, volatile.LoadUint32(&o.TAMPCTRLB.Reg)&^(0x8)|value<<3)
}
func (o *RTC_MODE2_Type) GetTAMPCTRLB_ALSI3() uint32 {
	return (volatile.LoadUint32(&o.TAMPCTRLB.Reg) & 0x8) >> 3
}

// Serial Communication Interface
type SERCOM_Type struct {
}

// Serial Communication Interface - I2CM
type SERCOM_I2CM_Type struct {
	CTRLA    volatile.Register32 // 0x0
	CTRLB    volatile.Register32 // 0x4
	_        [4]byte
	BAUD     volatile.Register32 // 0xC
	_        [4]byte
	INTENCLR volatile.Register8 // 0x14
	_        byte
	INTENSET volatile.Register8 // 0x16
	_        byte
	INTFLAG  volatile.Register8 // 0x18
	_        byte
	STATUS   volatile.Register16 // 0x1A
	SYNCBUSY volatile.Register32 // 0x1C
	_        [4]byte
	ADDR     volatile.Register32 // 0x24
	DATA     volatile.Register8  // 0x28
	_        [7]byte
	DBGCTRL  volatile.Register8 // 0x30
}

// SERCOM_I2CM.CTRLA: I2CM Control A
func (o *SERCOM_I2CM_Type) SetCTRLA_SWRST(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x1)|value)
}
func (o *SERCOM_I2CM_Type) GetCTRLA_SWRST() uint32 {
	return volatile.LoadUint32(&o.CTRLA.Reg) & 0x1
}
func (o *SERCOM_I2CM_Type) SetCTRLA_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x2)|value<<1)
}
func (o *SERCOM_I2CM_Type) GetCTRLA_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x2) >> 1
}
func (o *SERCOM_I2CM_Type) SetCTRLA_MODE(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x1c)|value<<2)
}
func (o *SERCOM_I2CM_Type) GetCTRLA_MODE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x1c) >> 2
}
func (o *SERCOM_I2CM_Type) SetCTRLA_RUNSTDBY(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x80)|value<<7)
}
func (o *SERCOM_I2CM_Type) GetCTRLA_RUNSTDBY() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x80) >> 7
}
func (o *SERCOM_I2CM_Type) SetCTRLA_PINOUT(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x10000)|value<<16)
}
func (o *SERCOM_I2CM_Type) GetCTRLA_PINOUT() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x10000) >> 16
}
func (o *SERCOM_I2CM_Type) SetCTRLA_SDAHOLD(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x300000)|value<<20)
}
func (o *SERCOM_I2CM_Type) GetCTRLA_SDAHOLD() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x300000) >> 20
}
func (o *SERCOM_I2CM_Type) SetCTRLA_MEXTTOEN(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x400000)|value<<22)
}
func (o *SERCOM_I2CM_Type) GetCTRLA_MEXTTOEN() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x400000) >> 22
}
func (o *SERCOM_I2CM_Type) SetCTRLA_SEXTTOEN(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x800000)|value<<23)
}
func (o *SERCOM_I2CM_Type) GetCTRLA_SEXTTOEN() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x800000) >> 23
}
func (o *SERCOM_I2CM_Type) SetCTRLA_SPEED(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x3000000)|value<<24)
}
func (o *SERCOM_I2CM_Type) GetCTRLA_SPEED() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x3000000) >> 24
}
func (o *SERCOM_I2CM_Type) SetCTRLA_SCLSM(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x8000000)|value<<27)
}
func (o *SERCOM_I2CM_Type) GetCTRLA_SCLSM() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x8000000) >> 27
}
func (o *SERCOM_I2CM_Type) SetCTRLA_INACTOUT(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x30000000)|value<<28)
}
func (o *SERCOM_I2CM_Type) GetCTRLA_INACTOUT() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x30000000) >> 28
}
func (o *SERCOM_I2CM_Type) SetCTRLA_LOWTOUTEN(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x40000000)|value<<30)
}
func (o *SERCOM_I2CM_Type) GetCTRLA_LOWTOUTEN() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x40000000) >> 30
}

// SERCOM_I2CM.CTRLB: I2CM Control B
func (o *SERCOM_I2CM_Type) SetCTRLB_SMEN(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0x100)|value<<8)
}
func (o *SERCOM_I2CM_Type) GetCTRLB_SMEN() uint32 {
	return (volatile.LoadUint32(&o.CTRLB.Reg) & 0x100) >> 8
}
func (o *SERCOM_I2CM_Type) SetCTRLB_QCEN(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0x200)|value<<9)
}
func (o *SERCOM_I2CM_Type) GetCTRLB_QCEN() uint32 {
	return (volatile.LoadUint32(&o.CTRLB.Reg) & 0x200) >> 9
}
func (o *SERCOM_I2CM_Type) SetCTRLB_CMD(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0x30000)|value<<16)
}
func (o *SERCOM_I2CM_Type) GetCTRLB_CMD() uint32 {
	return (volatile.LoadUint32(&o.CTRLB.Reg) & 0x30000) >> 16
}
func (o *SERCOM_I2CM_Type) SetCTRLB_ACKACT(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0x40000)|value<<18)
}
func (o *SERCOM_I2CM_Type) GetCTRLB_ACKACT() uint32 {
	return (volatile.LoadUint32(&o.CTRLB.Reg) & 0x40000) >> 18
}

// SERCOM_I2CM.BAUD: I2CM Baud Rate
func (o *SERCOM_I2CM_Type) SetBAUD(value uint32) {
	volatile.StoreUint32(&o.BAUD.Reg, volatile.LoadUint32(&o.BAUD.Reg)&^(0xff)|value)
}
func (o *SERCOM_I2CM_Type) GetBAUD() uint32 {
	return volatile.LoadUint32(&o.BAUD.Reg) & 0xff
}
func (o *SERCOM_I2CM_Type) SetBAUD_BAUDLOW(value uint32) {
	volatile.StoreUint32(&o.BAUD.Reg, volatile.LoadUint32(&o.BAUD.Reg)&^(0xff00)|value<<8)
}
func (o *SERCOM_I2CM_Type) GetBAUD_BAUDLOW() uint32 {
	return (volatile.LoadUint32(&o.BAUD.Reg) & 0xff00) >> 8
}
func (o *SERCOM_I2CM_Type) SetBAUD_HSBAUD(value uint32) {
	volatile.StoreUint32(&o.BAUD.Reg, volatile.LoadUint32(&o.BAUD.Reg)&^(0xff0000)|value<<16)
}
func (o *SERCOM_I2CM_Type) GetBAUD_HSBAUD() uint32 {
	return (volatile.LoadUint32(&o.BAUD.Reg) & 0xff0000) >> 16
}
func (o *SERCOM_I2CM_Type) SetBAUD_HSBAUDLOW(value uint32) {
	volatile.StoreUint32(&o.BAUD.Reg, volatile.LoadUint32(&o.BAUD.Reg)&^(0xff000000)|value<<24)
}
func (o *SERCOM_I2CM_Type) GetBAUD_HSBAUDLOW() uint32 {
	return (volatile.LoadUint32(&o.BAUD.Reg) & 0xff000000) >> 24
}

// SERCOM_I2CM.INTENCLR: I2CM Interrupt Enable Clear
func (o *SERCOM_I2CM_Type) SetINTENCLR_MB(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *SERCOM_I2CM_Type) GetINTENCLR_MB() uint8 {
	return volatile.LoadUint8(&o.INTENCLR.Reg) & 0x1
}
func (o *SERCOM_I2CM_Type) SetINTENCLR_SB(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *SERCOM_I2CM_Type) GetINTENCLR_SB() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *SERCOM_I2CM_Type) SetINTENCLR_ERROR(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x80)|value<<7)
}
func (o *SERCOM_I2CM_Type) GetINTENCLR_ERROR() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x80) >> 7
}

// SERCOM_I2CM.INTENSET: I2CM Interrupt Enable Set
func (o *SERCOM_I2CM_Type) SetINTENSET_MB(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *SERCOM_I2CM_Type) GetINTENSET_MB() uint8 {
	return volatile.LoadUint8(&o.INTENSET.Reg) & 0x1
}
func (o *SERCOM_I2CM_Type) SetINTENSET_SB(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *SERCOM_I2CM_Type) GetINTENSET_SB() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *SERCOM_I2CM_Type) SetINTENSET_ERROR(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x80)|value<<7)
}
func (o *SERCOM_I2CM_Type) GetINTENSET_ERROR() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x80) >> 7
}

// SERCOM_I2CM.INTFLAG: I2CM Interrupt Flag Status and Clear
func (o *SERCOM_I2CM_Type) SetINTFLAG_MB(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x1)|value)
}
func (o *SERCOM_I2CM_Type) GetINTFLAG_MB() uint8 {
	return volatile.LoadUint8(&o.INTFLAG.Reg) & 0x1
}
func (o *SERCOM_I2CM_Type) SetINTFLAG_SB(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x2)|value<<1)
}
func (o *SERCOM_I2CM_Type) GetINTFLAG_SB() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x2) >> 1
}
func (o *SERCOM_I2CM_Type) SetINTFLAG_ERROR(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x80)|value<<7)
}
func (o *SERCOM_I2CM_Type) GetINTFLAG_ERROR() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x80) >> 7
}

// SERCOM_I2CM.STATUS: I2CM Status
func (o *SERCOM_I2CM_Type) SetSTATUS_BUSERR(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x1)|value)
}
func (o *SERCOM_I2CM_Type) GetSTATUS_BUSERR() uint16 {
	return volatile.LoadUint16(&o.STATUS.Reg) & 0x1
}
func (o *SERCOM_I2CM_Type) SetSTATUS_ARBLOST(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x2)|value<<1)
}
func (o *SERCOM_I2CM_Type) GetSTATUS_ARBLOST() uint16 {
	return (volatile.LoadUint16(&o.STATUS.Reg) & 0x2) >> 1
}
func (o *SERCOM_I2CM_Type) SetSTATUS_RXNACK(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x4)|value<<2)
}
func (o *SERCOM_I2CM_Type) GetSTATUS_RXNACK() uint16 {
	return (volatile.LoadUint16(&o.STATUS.Reg) & 0x4) >> 2
}
func (o *SERCOM_I2CM_Type) SetSTATUS_BUSSTATE(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x30)|value<<4)
}
func (o *SERCOM_I2CM_Type) GetSTATUS_BUSSTATE() uint16 {
	return (volatile.LoadUint16(&o.STATUS.Reg) & 0x30) >> 4
}
func (o *SERCOM_I2CM_Type) SetSTATUS_LOWTOUT(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x40)|value<<6)
}
func (o *SERCOM_I2CM_Type) GetSTATUS_LOWTOUT() uint16 {
	return (volatile.LoadUint16(&o.STATUS.Reg) & 0x40) >> 6
}
func (o *SERCOM_I2CM_Type) SetSTATUS_CLKHOLD(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x80)|value<<7)
}
func (o *SERCOM_I2CM_Type) GetSTATUS_CLKHOLD() uint16 {
	return (volatile.LoadUint16(&o.STATUS.Reg) & 0x80) >> 7
}
func (o *SERCOM_I2CM_Type) SetSTATUS_MEXTTOUT(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x100)|value<<8)
}
func (o *SERCOM_I2CM_Type) GetSTATUS_MEXTTOUT() uint16 {
	return (volatile.LoadUint16(&o.STATUS.Reg) & 0x100) >> 8
}
func (o *SERCOM_I2CM_Type) SetSTATUS_SEXTTOUT(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x200)|value<<9)
}
func (o *SERCOM_I2CM_Type) GetSTATUS_SEXTTOUT() uint16 {
	return (volatile.LoadUint16(&o.STATUS.Reg) & 0x200) >> 9
}
func (o *SERCOM_I2CM_Type) SetSTATUS_LENERR(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x400)|value<<10)
}
func (o *SERCOM_I2CM_Type) GetSTATUS_LENERR() uint16 {
	return (volatile.LoadUint16(&o.STATUS.Reg) & 0x400) >> 10
}

// SERCOM_I2CM.SYNCBUSY: I2CM Synchronization Busy
func (o *SERCOM_I2CM_Type) SetSYNCBUSY_SWRST(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x1)|value)
}
func (o *SERCOM_I2CM_Type) GetSYNCBUSY_SWRST() uint32 {
	return volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x1
}
func (o *SERCOM_I2CM_Type) SetSYNCBUSY_ENABLE(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x2)|value<<1)
}
func (o *SERCOM_I2CM_Type) GetSYNCBUSY_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x2) >> 1
}
func (o *SERCOM_I2CM_Type) SetSYNCBUSY_SYSOP(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x4)|value<<2)
}
func (o *SERCOM_I2CM_Type) GetSYNCBUSY_SYSOP() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x4) >> 2
}

// SERCOM_I2CM.ADDR: I2CM Address
func (o *SERCOM_I2CM_Type) SetADDR(value uint32) {
	volatile.StoreUint32(&o.ADDR.Reg, volatile.LoadUint32(&o.ADDR.Reg)&^(0x7ff)|value)
}
func (o *SERCOM_I2CM_Type) GetADDR() uint32 {
	return volatile.LoadUint32(&o.ADDR.Reg) & 0x7ff
}
func (o *SERCOM_I2CM_Type) SetADDR_LENEN(value uint32) {
	volatile.StoreUint32(&o.ADDR.Reg, volatile.LoadUint32(&o.ADDR.Reg)&^(0x2000)|value<<13)
}
func (o *SERCOM_I2CM_Type) GetADDR_LENEN() uint32 {
	return (volatile.LoadUint32(&o.ADDR.Reg) & 0x2000) >> 13
}
func (o *SERCOM_I2CM_Type) SetADDR_HS(value uint32) {
	volatile.StoreUint32(&o.ADDR.Reg, volatile.LoadUint32(&o.ADDR.Reg)&^(0x4000)|value<<14)
}
func (o *SERCOM_I2CM_Type) GetADDR_HS() uint32 {
	return (volatile.LoadUint32(&o.ADDR.Reg) & 0x4000) >> 14
}
func (o *SERCOM_I2CM_Type) SetADDR_TENBITEN(value uint32) {
	volatile.StoreUint32(&o.ADDR.Reg, volatile.LoadUint32(&o.ADDR.Reg)&^(0x8000)|value<<15)
}
func (o *SERCOM_I2CM_Type) GetADDR_TENBITEN() uint32 {
	return (volatile.LoadUint32(&o.ADDR.Reg) & 0x8000) >> 15
}
func (o *SERCOM_I2CM_Type) SetADDR_LEN(value uint32) {
	volatile.StoreUint32(&o.ADDR.Reg, volatile.LoadUint32(&o.ADDR.Reg)&^(0xff0000)|value<<16)
}
func (o *SERCOM_I2CM_Type) GetADDR_LEN() uint32 {
	return (volatile.LoadUint32(&o.ADDR.Reg) & 0xff0000) >> 16
}

// SERCOM_I2CM.DATA: I2CM Data
func (o *SERCOM_I2CM_Type) SetDATA(value uint8) {
	volatile.StoreUint8(&o.DATA.Reg, value)
}
func (o *SERCOM_I2CM_Type) GetDATA() uint8 {
	return volatile.LoadUint8(&o.DATA.Reg)
}

// SERCOM_I2CM.DBGCTRL: I2CM Debug Control
func (o *SERCOM_I2CM_Type) SetDBGCTRL_DBGSTOP(value uint8) {
	volatile.StoreUint8(&o.DBGCTRL.Reg, volatile.LoadUint8(&o.DBGCTRL.Reg)&^(0x1)|value)
}
func (o *SERCOM_I2CM_Type) GetDBGCTRL_DBGSTOP() uint8 {
	return volatile.LoadUint8(&o.DBGCTRL.Reg) & 0x1
}

// Serial Communication Interface - I2CS
type SERCOM_I2CS_Type struct {
	CTRLA    volatile.Register32 // 0x0
	CTRLB    volatile.Register32 // 0x4
	_        [12]byte
	INTENCLR volatile.Register8 // 0x14
	_        byte
	INTENSET volatile.Register8 // 0x16
	_        byte
	INTFLAG  volatile.Register8 // 0x18
	_        byte
	STATUS   volatile.Register16 // 0x1A
	SYNCBUSY volatile.Register32 // 0x1C
	_        [4]byte
	ADDR     volatile.Register32 // 0x24
	DATA     volatile.Register8  // 0x28
}

// SERCOM_I2CS.CTRLA: I2CS Control A
func (o *SERCOM_I2CS_Type) SetCTRLA_SWRST(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x1)|value)
}
func (o *SERCOM_I2CS_Type) GetCTRLA_SWRST() uint32 {
	return volatile.LoadUint32(&o.CTRLA.Reg) & 0x1
}
func (o *SERCOM_I2CS_Type) SetCTRLA_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x2)|value<<1)
}
func (o *SERCOM_I2CS_Type) GetCTRLA_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x2) >> 1
}
func (o *SERCOM_I2CS_Type) SetCTRLA_MODE(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x1c)|value<<2)
}
func (o *SERCOM_I2CS_Type) GetCTRLA_MODE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x1c) >> 2
}
func (o *SERCOM_I2CS_Type) SetCTRLA_RUNSTDBY(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x80)|value<<7)
}
func (o *SERCOM_I2CS_Type) GetCTRLA_RUNSTDBY() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x80) >> 7
}
func (o *SERCOM_I2CS_Type) SetCTRLA_PINOUT(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x10000)|value<<16)
}
func (o *SERCOM_I2CS_Type) GetCTRLA_PINOUT() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x10000) >> 16
}
func (o *SERCOM_I2CS_Type) SetCTRLA_SDAHOLD(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x300000)|value<<20)
}
func (o *SERCOM_I2CS_Type) GetCTRLA_SDAHOLD() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x300000) >> 20
}
func (o *SERCOM_I2CS_Type) SetCTRLA_SEXTTOEN(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x800000)|value<<23)
}
func (o *SERCOM_I2CS_Type) GetCTRLA_SEXTTOEN() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x800000) >> 23
}
func (o *SERCOM_I2CS_Type) SetCTRLA_SPEED(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x3000000)|value<<24)
}
func (o *SERCOM_I2CS_Type) GetCTRLA_SPEED() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x3000000) >> 24
}
func (o *SERCOM_I2CS_Type) SetCTRLA_SCLSM(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x8000000)|value<<27)
}
func (o *SERCOM_I2CS_Type) GetCTRLA_SCLSM() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x8000000) >> 27
}
func (o *SERCOM_I2CS_Type) SetCTRLA_LOWTOUTEN(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x40000000)|value<<30)
}
func (o *SERCOM_I2CS_Type) GetCTRLA_LOWTOUTEN() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x40000000) >> 30
}

// SERCOM_I2CS.CTRLB: I2CS Control B
func (o *SERCOM_I2CS_Type) SetCTRLB_SMEN(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0x100)|value<<8)
}
func (o *SERCOM_I2CS_Type) GetCTRLB_SMEN() uint32 {
	return (volatile.LoadUint32(&o.CTRLB.Reg) & 0x100) >> 8
}
func (o *SERCOM_I2CS_Type) SetCTRLB_GCMD(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0x200)|value<<9)
}
func (o *SERCOM_I2CS_Type) GetCTRLB_GCMD() uint32 {
	return (volatile.LoadUint32(&o.CTRLB.Reg) & 0x200) >> 9
}
func (o *SERCOM_I2CS_Type) SetCTRLB_AACKEN(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0x400)|value<<10)
}
func (o *SERCOM_I2CS_Type) GetCTRLB_AACKEN() uint32 {
	return (volatile.LoadUint32(&o.CTRLB.Reg) & 0x400) >> 10
}
func (o *SERCOM_I2CS_Type) SetCTRLB_AMODE(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0xc000)|value<<14)
}
func (o *SERCOM_I2CS_Type) GetCTRLB_AMODE() uint32 {
	return (volatile.LoadUint32(&o.CTRLB.Reg) & 0xc000) >> 14
}
func (o *SERCOM_I2CS_Type) SetCTRLB_CMD(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0x30000)|value<<16)
}
func (o *SERCOM_I2CS_Type) GetCTRLB_CMD() uint32 {
	return (volatile.LoadUint32(&o.CTRLB.Reg) & 0x30000) >> 16
}
func (o *SERCOM_I2CS_Type) SetCTRLB_ACKACT(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0x40000)|value<<18)
}
func (o *SERCOM_I2CS_Type) GetCTRLB_ACKACT() uint32 {
	return (volatile.LoadUint32(&o.CTRLB.Reg) & 0x40000) >> 18
}

// SERCOM_I2CS.INTENCLR: I2CS Interrupt Enable Clear
func (o *SERCOM_I2CS_Type) SetINTENCLR_PREC(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *SERCOM_I2CS_Type) GetINTENCLR_PREC() uint8 {
	return volatile.LoadUint8(&o.INTENCLR.Reg) & 0x1
}
func (o *SERCOM_I2CS_Type) SetINTENCLR_AMATCH(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *SERCOM_I2CS_Type) GetINTENCLR_AMATCH() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *SERCOM_I2CS_Type) SetINTENCLR_DRDY(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *SERCOM_I2CS_Type) GetINTENCLR_DRDY() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x4) >> 2
}
func (o *SERCOM_I2CS_Type) SetINTENCLR_ERROR(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x80)|value<<7)
}
func (o *SERCOM_I2CS_Type) GetINTENCLR_ERROR() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x80) >> 7
}

// SERCOM_I2CS.INTENSET: I2CS Interrupt Enable Set
func (o *SERCOM_I2CS_Type) SetINTENSET_PREC(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *SERCOM_I2CS_Type) GetINTENSET_PREC() uint8 {
	return volatile.LoadUint8(&o.INTENSET.Reg) & 0x1
}
func (o *SERCOM_I2CS_Type) SetINTENSET_AMATCH(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *SERCOM_I2CS_Type) GetINTENSET_AMATCH() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *SERCOM_I2CS_Type) SetINTENSET_DRDY(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *SERCOM_I2CS_Type) GetINTENSET_DRDY() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x4) >> 2
}
func (o *SERCOM_I2CS_Type) SetINTENSET_ERROR(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x80)|value<<7)
}
func (o *SERCOM_I2CS_Type) GetINTENSET_ERROR() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x80) >> 7
}

// SERCOM_I2CS.INTFLAG: I2CS Interrupt Flag Status and Clear
func (o *SERCOM_I2CS_Type) SetINTFLAG_PREC(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x1)|value)
}
func (o *SERCOM_I2CS_Type) GetINTFLAG_PREC() uint8 {
	return volatile.LoadUint8(&o.INTFLAG.Reg) & 0x1
}
func (o *SERCOM_I2CS_Type) SetINTFLAG_AMATCH(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x2)|value<<1)
}
func (o *SERCOM_I2CS_Type) GetINTFLAG_AMATCH() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x2) >> 1
}
func (o *SERCOM_I2CS_Type) SetINTFLAG_DRDY(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x4)|value<<2)
}
func (o *SERCOM_I2CS_Type) GetINTFLAG_DRDY() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x4) >> 2
}
func (o *SERCOM_I2CS_Type) SetINTFLAG_ERROR(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x80)|value<<7)
}
func (o *SERCOM_I2CS_Type) GetINTFLAG_ERROR() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x80) >> 7
}

// SERCOM_I2CS.STATUS: I2CS Status
func (o *SERCOM_I2CS_Type) SetSTATUS_BUSERR(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x1)|value)
}
func (o *SERCOM_I2CS_Type) GetSTATUS_BUSERR() uint16 {
	return volatile.LoadUint16(&o.STATUS.Reg) & 0x1
}
func (o *SERCOM_I2CS_Type) SetSTATUS_COLL(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x2)|value<<1)
}
func (o *SERCOM_I2CS_Type) GetSTATUS_COLL() uint16 {
	return (volatile.LoadUint16(&o.STATUS.Reg) & 0x2) >> 1
}
func (o *SERCOM_I2CS_Type) SetSTATUS_RXNACK(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x4)|value<<2)
}
func (o *SERCOM_I2CS_Type) GetSTATUS_RXNACK() uint16 {
	return (volatile.LoadUint16(&o.STATUS.Reg) & 0x4) >> 2
}
func (o *SERCOM_I2CS_Type) SetSTATUS_DIR(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x8)|value<<3)
}
func (o *SERCOM_I2CS_Type) GetSTATUS_DIR() uint16 {
	return (volatile.LoadUint16(&o.STATUS.Reg) & 0x8) >> 3
}
func (o *SERCOM_I2CS_Type) SetSTATUS_SR(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x10)|value<<4)
}
func (o *SERCOM_I2CS_Type) GetSTATUS_SR() uint16 {
	return (volatile.LoadUint16(&o.STATUS.Reg) & 0x10) >> 4
}
func (o *SERCOM_I2CS_Type) SetSTATUS_LOWTOUT(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x40)|value<<6)
}
func (o *SERCOM_I2CS_Type) GetSTATUS_LOWTOUT() uint16 {
	return (volatile.LoadUint16(&o.STATUS.Reg) & 0x40) >> 6
}
func (o *SERCOM_I2CS_Type) SetSTATUS_CLKHOLD(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x80)|value<<7)
}
func (o *SERCOM_I2CS_Type) GetSTATUS_CLKHOLD() uint16 {
	return (volatile.LoadUint16(&o.STATUS.Reg) & 0x80) >> 7
}
func (o *SERCOM_I2CS_Type) SetSTATUS_SEXTTOUT(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x200)|value<<9)
}
func (o *SERCOM_I2CS_Type) GetSTATUS_SEXTTOUT() uint16 {
	return (volatile.LoadUint16(&o.STATUS.Reg) & 0x200) >> 9
}
func (o *SERCOM_I2CS_Type) SetSTATUS_HS(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x400)|value<<10)
}
func (o *SERCOM_I2CS_Type) GetSTATUS_HS() uint16 {
	return (volatile.LoadUint16(&o.STATUS.Reg) & 0x400) >> 10
}

// SERCOM_I2CS.SYNCBUSY: I2CS Synchronization Busy
func (o *SERCOM_I2CS_Type) SetSYNCBUSY_SWRST(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x1)|value)
}
func (o *SERCOM_I2CS_Type) GetSYNCBUSY_SWRST() uint32 {
	return volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x1
}
func (o *SERCOM_I2CS_Type) SetSYNCBUSY_ENABLE(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x2)|value<<1)
}
func (o *SERCOM_I2CS_Type) GetSYNCBUSY_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x2) >> 1
}

// SERCOM_I2CS.ADDR: I2CS Address
func (o *SERCOM_I2CS_Type) SetADDR_GENCEN(value uint32) {
	volatile.StoreUint32(&o.ADDR.Reg, volatile.LoadUint32(&o.ADDR.Reg)&^(0x1)|value)
}
func (o *SERCOM_I2CS_Type) GetADDR_GENCEN() uint32 {
	return volatile.LoadUint32(&o.ADDR.Reg) & 0x1
}
func (o *SERCOM_I2CS_Type) SetADDR(value uint32) {
	volatile.StoreUint32(&o.ADDR.Reg, volatile.LoadUint32(&o.ADDR.Reg)&^(0x7fe)|value<<1)
}
func (o *SERCOM_I2CS_Type) GetADDR() uint32 {
	return (volatile.LoadUint32(&o.ADDR.Reg) & 0x7fe) >> 1
}
func (o *SERCOM_I2CS_Type) SetADDR_TENBITEN(value uint32) {
	volatile.StoreUint32(&o.ADDR.Reg, volatile.LoadUint32(&o.ADDR.Reg)&^(0x8000)|value<<15)
}
func (o *SERCOM_I2CS_Type) GetADDR_TENBITEN() uint32 {
	return (volatile.LoadUint32(&o.ADDR.Reg) & 0x8000) >> 15
}
func (o *SERCOM_I2CS_Type) SetADDR_ADDRMASK(value uint32) {
	volatile.StoreUint32(&o.ADDR.Reg, volatile.LoadUint32(&o.ADDR.Reg)&^(0x7fe0000)|value<<17)
}
func (o *SERCOM_I2CS_Type) GetADDR_ADDRMASK() uint32 {
	return (volatile.LoadUint32(&o.ADDR.Reg) & 0x7fe0000) >> 17
}

// SERCOM_I2CS.DATA: I2CS Data
func (o *SERCOM_I2CS_Type) SetDATA(value uint8) {
	volatile.StoreUint8(&o.DATA.Reg, value)
}
func (o *SERCOM_I2CS_Type) GetDATA() uint8 {
	return volatile.LoadUint8(&o.DATA.Reg)
}

// Serial Communication Interface - SPI
type SERCOM_SPI_Type struct {
	CTRLA    volatile.Register32 // 0x0
	CTRLB    volatile.Register32 // 0x4
	_        [4]byte
	BAUD     volatile.Register8 // 0xC
	_        [7]byte
	INTENCLR volatile.Register8 // 0x14
	_        byte
	INTENSET volatile.Register8 // 0x16
	_        byte
	INTFLAG  volatile.Register8 // 0x18
	_        byte
	STATUS   volatile.Register16 // 0x1A
	SYNCBUSY volatile.Register32 // 0x1C
	_        [4]byte
	ADDR     volatile.Register32 // 0x24
	DATA     volatile.Register32 // 0x28
	_        [4]byte
	DBGCTRL  volatile.Register8 // 0x30
}

// SERCOM_SPI.CTRLA: SPI Control A
func (o *SERCOM_SPI_Type) SetCTRLA_SWRST(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x1)|value)
}
func (o *SERCOM_SPI_Type) GetCTRLA_SWRST() uint32 {
	return volatile.LoadUint32(&o.CTRLA.Reg) & 0x1
}
func (o *SERCOM_SPI_Type) SetCTRLA_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x2)|value<<1)
}
func (o *SERCOM_SPI_Type) GetCTRLA_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x2) >> 1
}
func (o *SERCOM_SPI_Type) SetCTRLA_MODE(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x1c)|value<<2)
}
func (o *SERCOM_SPI_Type) GetCTRLA_MODE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x1c) >> 2
}
func (o *SERCOM_SPI_Type) SetCTRLA_RUNSTDBY(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x80)|value<<7)
}
func (o *SERCOM_SPI_Type) GetCTRLA_RUNSTDBY() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x80) >> 7
}
func (o *SERCOM_SPI_Type) SetCTRLA_IBON(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x100)|value<<8)
}
func (o *SERCOM_SPI_Type) GetCTRLA_IBON() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x100) >> 8
}
func (o *SERCOM_SPI_Type) SetCTRLA_DOPO(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x30000)|value<<16)
}
func (o *SERCOM_SPI_Type) GetCTRLA_DOPO() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x30000) >> 16
}
func (o *SERCOM_SPI_Type) SetCTRLA_DIPO(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x300000)|value<<20)
}
func (o *SERCOM_SPI_Type) GetCTRLA_DIPO() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x300000) >> 20
}
func (o *SERCOM_SPI_Type) SetCTRLA_FORM(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0xf000000)|value<<24)
}
func (o *SERCOM_SPI_Type) GetCTRLA_FORM() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0xf000000) >> 24
}
func (o *SERCOM_SPI_Type) SetCTRLA_CPHA(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x10000000)|value<<28)
}
func (o *SERCOM_SPI_Type) GetCTRLA_CPHA() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x10000000) >> 28
}
func (o *SERCOM_SPI_Type) SetCTRLA_CPOL(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x20000000)|value<<29)
}
func (o *SERCOM_SPI_Type) GetCTRLA_CPOL() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x20000000) >> 29
}
func (o *SERCOM_SPI_Type) SetCTRLA_DORD(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x40000000)|value<<30)
}
func (o *SERCOM_SPI_Type) GetCTRLA_DORD() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x40000000) >> 30
}

// SERCOM_SPI.CTRLB: SPI Control B
func (o *SERCOM_SPI_Type) SetCTRLB_CHSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0x7)|value)
}
func (o *SERCOM_SPI_Type) GetCTRLB_CHSIZE() uint32 {
	return volatile.LoadUint32(&o.CTRLB.Reg) & 0x7
}
func (o *SERCOM_SPI_Type) SetCTRLB_PLOADEN(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0x40)|value<<6)
}
func (o *SERCOM_SPI_Type) GetCTRLB_PLOADEN() uint32 {
	return (volatile.LoadUint32(&o.CTRLB.Reg) & 0x40) >> 6
}
func (o *SERCOM_SPI_Type) SetCTRLB_SSDE(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0x200)|value<<9)
}
func (o *SERCOM_SPI_Type) GetCTRLB_SSDE() uint32 {
	return (volatile.LoadUint32(&o.CTRLB.Reg) & 0x200) >> 9
}
func (o *SERCOM_SPI_Type) SetCTRLB_MSSEN(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0x2000)|value<<13)
}
func (o *SERCOM_SPI_Type) GetCTRLB_MSSEN() uint32 {
	return (volatile.LoadUint32(&o.CTRLB.Reg) & 0x2000) >> 13
}
func (o *SERCOM_SPI_Type) SetCTRLB_AMODE(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0xc000)|value<<14)
}
func (o *SERCOM_SPI_Type) GetCTRLB_AMODE() uint32 {
	return (volatile.LoadUint32(&o.CTRLB.Reg) & 0xc000) >> 14
}
func (o *SERCOM_SPI_Type) SetCTRLB_RXEN(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0x20000)|value<<17)
}
func (o *SERCOM_SPI_Type) GetCTRLB_RXEN() uint32 {
	return (volatile.LoadUint32(&o.CTRLB.Reg) & 0x20000) >> 17
}

// SERCOM_SPI.BAUD: SPI Baud Rate
func (o *SERCOM_SPI_Type) SetBAUD(value uint8) {
	volatile.StoreUint8(&o.BAUD.Reg, value)
}
func (o *SERCOM_SPI_Type) GetBAUD() uint8 {
	return volatile.LoadUint8(&o.BAUD.Reg)
}

// SERCOM_SPI.INTENCLR: SPI Interrupt Enable Clear
func (o *SERCOM_SPI_Type) SetINTENCLR_DRE(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *SERCOM_SPI_Type) GetINTENCLR_DRE() uint8 {
	return volatile.LoadUint8(&o.INTENCLR.Reg) & 0x1
}
func (o *SERCOM_SPI_Type) SetINTENCLR_TXC(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *SERCOM_SPI_Type) GetINTENCLR_TXC() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *SERCOM_SPI_Type) SetINTENCLR_RXC(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *SERCOM_SPI_Type) GetINTENCLR_RXC() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x4) >> 2
}
func (o *SERCOM_SPI_Type) SetINTENCLR_SSL(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x8)|value<<3)
}
func (o *SERCOM_SPI_Type) GetINTENCLR_SSL() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x8) >> 3
}
func (o *SERCOM_SPI_Type) SetINTENCLR_ERROR(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x80)|value<<7)
}
func (o *SERCOM_SPI_Type) GetINTENCLR_ERROR() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x80) >> 7
}

// SERCOM_SPI.INTENSET: SPI Interrupt Enable Set
func (o *SERCOM_SPI_Type) SetINTENSET_DRE(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *SERCOM_SPI_Type) GetINTENSET_DRE() uint8 {
	return volatile.LoadUint8(&o.INTENSET.Reg) & 0x1
}
func (o *SERCOM_SPI_Type) SetINTENSET_TXC(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *SERCOM_SPI_Type) GetINTENSET_TXC() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *SERCOM_SPI_Type) SetINTENSET_RXC(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *SERCOM_SPI_Type) GetINTENSET_RXC() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x4) >> 2
}
func (o *SERCOM_SPI_Type) SetINTENSET_SSL(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x8)|value<<3)
}
func (o *SERCOM_SPI_Type) GetINTENSET_SSL() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x8) >> 3
}
func (o *SERCOM_SPI_Type) SetINTENSET_ERROR(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x80)|value<<7)
}
func (o *SERCOM_SPI_Type) GetINTENSET_ERROR() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x80) >> 7
}

// SERCOM_SPI.INTFLAG: SPI Interrupt Flag Status and Clear
func (o *SERCOM_SPI_Type) SetINTFLAG_DRE(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x1)|value)
}
func (o *SERCOM_SPI_Type) GetINTFLAG_DRE() uint8 {
	return volatile.LoadUint8(&o.INTFLAG.Reg) & 0x1
}
func (o *SERCOM_SPI_Type) SetINTFLAG_TXC(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x2)|value<<1)
}
func (o *SERCOM_SPI_Type) GetINTFLAG_TXC() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x2) >> 1
}
func (o *SERCOM_SPI_Type) SetINTFLAG_RXC(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x4)|value<<2)
}
func (o *SERCOM_SPI_Type) GetINTFLAG_RXC() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x4) >> 2
}
func (o *SERCOM_SPI_Type) SetINTFLAG_SSL(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x8)|value<<3)
}
func (o *SERCOM_SPI_Type) GetINTFLAG_SSL() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x8) >> 3
}
func (o *SERCOM_SPI_Type) SetINTFLAG_ERROR(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x80)|value<<7)
}
func (o *SERCOM_SPI_Type) GetINTFLAG_ERROR() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x80) >> 7
}

// SERCOM_SPI.STATUS: SPI Status
func (o *SERCOM_SPI_Type) SetSTATUS_BUFOVF(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x4)|value<<2)
}
func (o *SERCOM_SPI_Type) GetSTATUS_BUFOVF() uint16 {
	return (volatile.LoadUint16(&o.STATUS.Reg) & 0x4) >> 2
}

// SERCOM_SPI.SYNCBUSY: SPI Synchronization Busy
func (o *SERCOM_SPI_Type) SetSYNCBUSY_SWRST(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x1)|value)
}
func (o *SERCOM_SPI_Type) GetSYNCBUSY_SWRST() uint32 {
	return volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x1
}
func (o *SERCOM_SPI_Type) SetSYNCBUSY_ENABLE(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x2)|value<<1)
}
func (o *SERCOM_SPI_Type) GetSYNCBUSY_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x2) >> 1
}
func (o *SERCOM_SPI_Type) SetSYNCBUSY_CTRLB(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x4)|value<<2)
}
func (o *SERCOM_SPI_Type) GetSYNCBUSY_CTRLB() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x4) >> 2
}

// SERCOM_SPI.ADDR: SPI Address
func (o *SERCOM_SPI_Type) SetADDR(value uint32) {
	volatile.StoreUint32(&o.ADDR.Reg, volatile.LoadUint32(&o.ADDR.Reg)&^(0xff)|value)
}
func (o *SERCOM_SPI_Type) GetADDR() uint32 {
	return volatile.LoadUint32(&o.ADDR.Reg) & 0xff
}
func (o *SERCOM_SPI_Type) SetADDR_ADDRMASK(value uint32) {
	volatile.StoreUint32(&o.ADDR.Reg, volatile.LoadUint32(&o.ADDR.Reg)&^(0xff0000)|value<<16)
}
func (o *SERCOM_SPI_Type) GetADDR_ADDRMASK() uint32 {
	return (volatile.LoadUint32(&o.ADDR.Reg) & 0xff0000) >> 16
}

// SERCOM_SPI.DATA: SPI Data
func (o *SERCOM_SPI_Type) SetDATA(value uint32) {
	volatile.StoreUint32(&o.DATA.Reg, volatile.LoadUint32(&o.DATA.Reg)&^(0x1ff)|value)
}
func (o *SERCOM_SPI_Type) GetDATA() uint32 {
	return volatile.LoadUint32(&o.DATA.Reg) & 0x1ff
}

// SERCOM_SPI.DBGCTRL: SPI Debug Control
func (o *SERCOM_SPI_Type) SetDBGCTRL_DBGSTOP(value uint8) {
	volatile.StoreUint8(&o.DBGCTRL.Reg, volatile.LoadUint8(&o.DBGCTRL.Reg)&^(0x1)|value)
}
func (o *SERCOM_SPI_Type) GetDBGCTRL_DBGSTOP() uint8 {
	return volatile.LoadUint8(&o.DBGCTRL.Reg) & 0x1
}

// Serial Communication Interface - USART
type SERCOM_USART_Type struct {
	CTRLA    volatile.Register32 // 0x0
	CTRLB    volatile.Register32 // 0x4
	CTRLC    volatile.Register32 // 0x8
	BAUD     volatile.Register16 // 0xC
	RXPL     volatile.Register8  // 0xE
	_        [5]byte
	INTENCLR volatile.Register8 // 0x14
	_        byte
	INTENSET volatile.Register8 // 0x16
	_        byte
	INTFLAG  volatile.Register8 // 0x18
	_        byte
	STATUS   volatile.Register16 // 0x1A
	SYNCBUSY volatile.Register32 // 0x1C
	RXERRCNT volatile.Register8  // 0x20
	_        [7]byte
	DATA     volatile.Register16 // 0x28
	_        [6]byte
	DBGCTRL  volatile.Register8 // 0x30
}

// SERCOM_USART.CTRLA: USART Control A
func (o *SERCOM_USART_Type) SetCTRLA_SWRST(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x1)|value)
}
func (o *SERCOM_USART_Type) GetCTRLA_SWRST() uint32 {
	return volatile.LoadUint32(&o.CTRLA.Reg) & 0x1
}
func (o *SERCOM_USART_Type) SetCTRLA_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x2)|value<<1)
}
func (o *SERCOM_USART_Type) GetCTRLA_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x2) >> 1
}
func (o *SERCOM_USART_Type) SetCTRLA_MODE(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x1c)|value<<2)
}
func (o *SERCOM_USART_Type) GetCTRLA_MODE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x1c) >> 2
}
func (o *SERCOM_USART_Type) SetCTRLA_RUNSTDBY(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x80)|value<<7)
}
func (o *SERCOM_USART_Type) GetCTRLA_RUNSTDBY() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x80) >> 7
}
func (o *SERCOM_USART_Type) SetCTRLA_IBON(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x100)|value<<8)
}
func (o *SERCOM_USART_Type) GetCTRLA_IBON() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x100) >> 8
}
func (o *SERCOM_USART_Type) SetCTRLA_TXINV(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x200)|value<<9)
}
func (o *SERCOM_USART_Type) GetCTRLA_TXINV() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x200) >> 9
}
func (o *SERCOM_USART_Type) SetCTRLA_RXINV(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x400)|value<<10)
}
func (o *SERCOM_USART_Type) GetCTRLA_RXINV() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x400) >> 10
}
func (o *SERCOM_USART_Type) SetCTRLA_SAMPR(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0xe000)|value<<13)
}
func (o *SERCOM_USART_Type) GetCTRLA_SAMPR() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0xe000) >> 13
}
func (o *SERCOM_USART_Type) SetCTRLA_TXPO(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x30000)|value<<16)
}
func (o *SERCOM_USART_Type) GetCTRLA_TXPO() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x30000) >> 16
}
func (o *SERCOM_USART_Type) SetCTRLA_RXPO(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x300000)|value<<20)
}
func (o *SERCOM_USART_Type) GetCTRLA_RXPO() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x300000) >> 20
}
func (o *SERCOM_USART_Type) SetCTRLA_SAMPA(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0xc00000)|value<<22)
}
func (o *SERCOM_USART_Type) GetCTRLA_SAMPA() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0xc00000) >> 22
}
func (o *SERCOM_USART_Type) SetCTRLA_FORM(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0xf000000)|value<<24)
}
func (o *SERCOM_USART_Type) GetCTRLA_FORM() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0xf000000) >> 24
}
func (o *SERCOM_USART_Type) SetCTRLA_CMODE(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x10000000)|value<<28)
}
func (o *SERCOM_USART_Type) GetCTRLA_CMODE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x10000000) >> 28
}
func (o *SERCOM_USART_Type) SetCTRLA_CPOL(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x20000000)|value<<29)
}
func (o *SERCOM_USART_Type) GetCTRLA_CPOL() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x20000000) >> 29
}
func (o *SERCOM_USART_Type) SetCTRLA_DORD(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x40000000)|value<<30)
}
func (o *SERCOM_USART_Type) GetCTRLA_DORD() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x40000000) >> 30
}

// SERCOM_USART.CTRLB: USART Control B
func (o *SERCOM_USART_Type) SetCTRLB_CHSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0x7)|value)
}
func (o *SERCOM_USART_Type) GetCTRLB_CHSIZE() uint32 {
	return volatile.LoadUint32(&o.CTRLB.Reg) & 0x7
}
func (o *SERCOM_USART_Type) SetCTRLB_SBMODE(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0x40)|value<<6)
}
func (o *SERCOM_USART_Type) GetCTRLB_SBMODE() uint32 {
	return (volatile.LoadUint32(&o.CTRLB.Reg) & 0x40) >> 6
}
func (o *SERCOM_USART_Type) SetCTRLB_COLDEN(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0x100)|value<<8)
}
func (o *SERCOM_USART_Type) GetCTRLB_COLDEN() uint32 {
	return (volatile.LoadUint32(&o.CTRLB.Reg) & 0x100) >> 8
}
func (o *SERCOM_USART_Type) SetCTRLB_SFDE(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0x200)|value<<9)
}
func (o *SERCOM_USART_Type) GetCTRLB_SFDE() uint32 {
	return (volatile.LoadUint32(&o.CTRLB.Reg) & 0x200) >> 9
}
func (o *SERCOM_USART_Type) SetCTRLB_ENC(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0x400)|value<<10)
}
func (o *SERCOM_USART_Type) GetCTRLB_ENC() uint32 {
	return (volatile.LoadUint32(&o.CTRLB.Reg) & 0x400) >> 10
}
func (o *SERCOM_USART_Type) SetCTRLB_PMODE(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0x2000)|value<<13)
}
func (o *SERCOM_USART_Type) GetCTRLB_PMODE() uint32 {
	return (volatile.LoadUint32(&o.CTRLB.Reg) & 0x2000) >> 13
}
func (o *SERCOM_USART_Type) SetCTRLB_TXEN(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0x10000)|value<<16)
}
func (o *SERCOM_USART_Type) GetCTRLB_TXEN() uint32 {
	return (volatile.LoadUint32(&o.CTRLB.Reg) & 0x10000) >> 16
}
func (o *SERCOM_USART_Type) SetCTRLB_RXEN(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0x20000)|value<<17)
}
func (o *SERCOM_USART_Type) GetCTRLB_RXEN() uint32 {
	return (volatile.LoadUint32(&o.CTRLB.Reg) & 0x20000) >> 17
}
func (o *SERCOM_USART_Type) SetCTRLB_LINCMD(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0x3000000)|value<<24)
}
func (o *SERCOM_USART_Type) GetCTRLB_LINCMD() uint32 {
	return (volatile.LoadUint32(&o.CTRLB.Reg) & 0x3000000) >> 24
}

// SERCOM_USART.CTRLC: USART Control C
func (o *SERCOM_USART_Type) SetCTRLC_GTIME(value uint32) {
	volatile.StoreUint32(&o.CTRLC.Reg, volatile.LoadUint32(&o.CTRLC.Reg)&^(0x7)|value)
}
func (o *SERCOM_USART_Type) GetCTRLC_GTIME() uint32 {
	return volatile.LoadUint32(&o.CTRLC.Reg) & 0x7
}
func (o *SERCOM_USART_Type) SetCTRLC_BRKLEN(value uint32) {
	volatile.StoreUint32(&o.CTRLC.Reg, volatile.LoadUint32(&o.CTRLC.Reg)&^(0x300)|value<<8)
}
func (o *SERCOM_USART_Type) GetCTRLC_BRKLEN() uint32 {
	return (volatile.LoadUint32(&o.CTRLC.Reg) & 0x300) >> 8
}
func (o *SERCOM_USART_Type) SetCTRLC_HDRDLY(value uint32) {
	volatile.StoreUint32(&o.CTRLC.Reg, volatile.LoadUint32(&o.CTRLC.Reg)&^(0xc00)|value<<10)
}
func (o *SERCOM_USART_Type) GetCTRLC_HDRDLY() uint32 {
	return (volatile.LoadUint32(&o.CTRLC.Reg) & 0xc00) >> 10
}
func (o *SERCOM_USART_Type) SetCTRLC_INACK(value uint32) {
	volatile.StoreUint32(&o.CTRLC.Reg, volatile.LoadUint32(&o.CTRLC.Reg)&^(0x10000)|value<<16)
}
func (o *SERCOM_USART_Type) GetCTRLC_INACK() uint32 {
	return (volatile.LoadUint32(&o.CTRLC.Reg) & 0x10000) >> 16
}
func (o *SERCOM_USART_Type) SetCTRLC_DSNACK(value uint32) {
	volatile.StoreUint32(&o.CTRLC.Reg, volatile.LoadUint32(&o.CTRLC.Reg)&^(0x20000)|value<<17)
}
func (o *SERCOM_USART_Type) GetCTRLC_DSNACK() uint32 {
	return (volatile.LoadUint32(&o.CTRLC.Reg) & 0x20000) >> 17
}
func (o *SERCOM_USART_Type) SetCTRLC_MAXITER(value uint32) {
	volatile.StoreUint32(&o.CTRLC.Reg, volatile.LoadUint32(&o.CTRLC.Reg)&^(0x700000)|value<<20)
}
func (o *SERCOM_USART_Type) GetCTRLC_MAXITER() uint32 {
	return (volatile.LoadUint32(&o.CTRLC.Reg) & 0x700000) >> 20
}

// SERCOM_USART.BAUD: USART Baud Rate
func (o *SERCOM_USART_Type) SetBAUD(value uint16) {
	volatile.StoreUint16(&o.BAUD.Reg, value)
}
func (o *SERCOM_USART_Type) GetBAUD() uint16 {
	return volatile.LoadUint16(&o.BAUD.Reg)
}

// SERCOM_USART.RXPL: USART Receive Pulse Length
func (o *SERCOM_USART_Type) SetRXPL(value uint8) {
	volatile.StoreUint8(&o.RXPL.Reg, value)
}
func (o *SERCOM_USART_Type) GetRXPL() uint8 {
	return volatile.LoadUint8(&o.RXPL.Reg)
}

// SERCOM_USART.INTENCLR: USART Interrupt Enable Clear
func (o *SERCOM_USART_Type) SetINTENCLR_DRE(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *SERCOM_USART_Type) GetINTENCLR_DRE() uint8 {
	return volatile.LoadUint8(&o.INTENCLR.Reg) & 0x1
}
func (o *SERCOM_USART_Type) SetINTENCLR_TXC(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *SERCOM_USART_Type) GetINTENCLR_TXC() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *SERCOM_USART_Type) SetINTENCLR_RXC(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *SERCOM_USART_Type) GetINTENCLR_RXC() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x4) >> 2
}
func (o *SERCOM_USART_Type) SetINTENCLR_RXS(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x8)|value<<3)
}
func (o *SERCOM_USART_Type) GetINTENCLR_RXS() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x8) >> 3
}
func (o *SERCOM_USART_Type) SetINTENCLR_CTSIC(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x10)|value<<4)
}
func (o *SERCOM_USART_Type) GetINTENCLR_CTSIC() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x10) >> 4
}
func (o *SERCOM_USART_Type) SetINTENCLR_RXBRK(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x20)|value<<5)
}
func (o *SERCOM_USART_Type) GetINTENCLR_RXBRK() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x20) >> 5
}
func (o *SERCOM_USART_Type) SetINTENCLR_ERROR(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x80)|value<<7)
}
func (o *SERCOM_USART_Type) GetINTENCLR_ERROR() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x80) >> 7
}

// SERCOM_USART.INTENSET: USART Interrupt Enable Set
func (o *SERCOM_USART_Type) SetINTENSET_DRE(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *SERCOM_USART_Type) GetINTENSET_DRE() uint8 {
	return volatile.LoadUint8(&o.INTENSET.Reg) & 0x1
}
func (o *SERCOM_USART_Type) SetINTENSET_TXC(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *SERCOM_USART_Type) GetINTENSET_TXC() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *SERCOM_USART_Type) SetINTENSET_RXC(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *SERCOM_USART_Type) GetINTENSET_RXC() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x4) >> 2
}
func (o *SERCOM_USART_Type) SetINTENSET_RXS(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x8)|value<<3)
}
func (o *SERCOM_USART_Type) GetINTENSET_RXS() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x8) >> 3
}
func (o *SERCOM_USART_Type) SetINTENSET_CTSIC(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x10)|value<<4)
}
func (o *SERCOM_USART_Type) GetINTENSET_CTSIC() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x10) >> 4
}
func (o *SERCOM_USART_Type) SetINTENSET_RXBRK(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x20)|value<<5)
}
func (o *SERCOM_USART_Type) GetINTENSET_RXBRK() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x20) >> 5
}
func (o *SERCOM_USART_Type) SetINTENSET_ERROR(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x80)|value<<7)
}
func (o *SERCOM_USART_Type) GetINTENSET_ERROR() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x80) >> 7
}

// SERCOM_USART.INTFLAG: USART Interrupt Flag Status and Clear
func (o *SERCOM_USART_Type) SetINTFLAG_DRE(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x1)|value)
}
func (o *SERCOM_USART_Type) GetINTFLAG_DRE() uint8 {
	return volatile.LoadUint8(&o.INTFLAG.Reg) & 0x1
}
func (o *SERCOM_USART_Type) SetINTFLAG_TXC(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x2)|value<<1)
}
func (o *SERCOM_USART_Type) GetINTFLAG_TXC() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x2) >> 1
}
func (o *SERCOM_USART_Type) SetINTFLAG_RXC(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x4)|value<<2)
}
func (o *SERCOM_USART_Type) GetINTFLAG_RXC() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x4) >> 2
}
func (o *SERCOM_USART_Type) SetINTFLAG_RXS(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x8)|value<<3)
}
func (o *SERCOM_USART_Type) GetINTFLAG_RXS() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x8) >> 3
}
func (o *SERCOM_USART_Type) SetINTFLAG_CTSIC(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x10)|value<<4)
}
func (o *SERCOM_USART_Type) GetINTFLAG_CTSIC() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x10) >> 4
}
func (o *SERCOM_USART_Type) SetINTFLAG_RXBRK(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x20)|value<<5)
}
func (o *SERCOM_USART_Type) GetINTFLAG_RXBRK() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x20) >> 5
}
func (o *SERCOM_USART_Type) SetINTFLAG_ERROR(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x80)|value<<7)
}
func (o *SERCOM_USART_Type) GetINTFLAG_ERROR() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x80) >> 7
}

// SERCOM_USART.STATUS: USART Status
func (o *SERCOM_USART_Type) SetSTATUS_PERR(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x1)|value)
}
func (o *SERCOM_USART_Type) GetSTATUS_PERR() uint16 {
	return volatile.LoadUint16(&o.STATUS.Reg) & 0x1
}
func (o *SERCOM_USART_Type) SetSTATUS_FERR(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x2)|value<<1)
}
func (o *SERCOM_USART_Type) GetSTATUS_FERR() uint16 {
	return (volatile.LoadUint16(&o.STATUS.Reg) & 0x2) >> 1
}
func (o *SERCOM_USART_Type) SetSTATUS_BUFOVF(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x4)|value<<2)
}
func (o *SERCOM_USART_Type) GetSTATUS_BUFOVF() uint16 {
	return (volatile.LoadUint16(&o.STATUS.Reg) & 0x4) >> 2
}
func (o *SERCOM_USART_Type) SetSTATUS_CTS(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x8)|value<<3)
}
func (o *SERCOM_USART_Type) GetSTATUS_CTS() uint16 {
	return (volatile.LoadUint16(&o.STATUS.Reg) & 0x8) >> 3
}
func (o *SERCOM_USART_Type) SetSTATUS_ISF(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x10)|value<<4)
}
func (o *SERCOM_USART_Type) GetSTATUS_ISF() uint16 {
	return (volatile.LoadUint16(&o.STATUS.Reg) & 0x10) >> 4
}
func (o *SERCOM_USART_Type) SetSTATUS_COLL(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x20)|value<<5)
}
func (o *SERCOM_USART_Type) GetSTATUS_COLL() uint16 {
	return (volatile.LoadUint16(&o.STATUS.Reg) & 0x20) >> 5
}
func (o *SERCOM_USART_Type) SetSTATUS_TXE(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x40)|value<<6)
}
func (o *SERCOM_USART_Type) GetSTATUS_TXE() uint16 {
	return (volatile.LoadUint16(&o.STATUS.Reg) & 0x40) >> 6
}
func (o *SERCOM_USART_Type) SetSTATUS_ITER(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x80)|value<<7)
}
func (o *SERCOM_USART_Type) GetSTATUS_ITER() uint16 {
	return (volatile.LoadUint16(&o.STATUS.Reg) & 0x80) >> 7
}

// SERCOM_USART.SYNCBUSY: USART Synchronization Busy
func (o *SERCOM_USART_Type) SetSYNCBUSY_SWRST(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x1)|value)
}
func (o *SERCOM_USART_Type) GetSYNCBUSY_SWRST() uint32 {
	return volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x1
}
func (o *SERCOM_USART_Type) SetSYNCBUSY_ENABLE(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x2)|value<<1)
}
func (o *SERCOM_USART_Type) GetSYNCBUSY_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x2) >> 1
}
func (o *SERCOM_USART_Type) SetSYNCBUSY_CTRLB(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x4)|value<<2)
}
func (o *SERCOM_USART_Type) GetSYNCBUSY_CTRLB() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x4) >> 2
}
func (o *SERCOM_USART_Type) SetSYNCBUSY_RXERRCNT(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x8)|value<<3)
}
func (o *SERCOM_USART_Type) GetSYNCBUSY_RXERRCNT() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x8) >> 3
}

// SERCOM_USART.DATA: USART Data
func (o *SERCOM_USART_Type) SetDATA(value uint16) {
	volatile.StoreUint16(&o.DATA.Reg, volatile.LoadUint16(&o.DATA.Reg)&^(0x1ff)|value)
}
func (o *SERCOM_USART_Type) GetDATA() uint16 {
	return volatile.LoadUint16(&o.DATA.Reg) & 0x1ff
}

// SERCOM_USART.DBGCTRL: USART Debug Control
func (o *SERCOM_USART_Type) SetDBGCTRL_DBGSTOP(value uint8) {
	volatile.StoreUint8(&o.DBGCTRL.Reg, volatile.LoadUint8(&o.DBGCTRL.Reg)&^(0x1)|value)
}
func (o *SERCOM_USART_Type) GetDBGCTRL_DBGSTOP() uint8 {
	return volatile.LoadUint8(&o.DBGCTRL.Reg) & 0x1
}

// Supply Controller
type SUPC_Type struct {
	INTENCLR volatile.Register32 // 0x0
	INTENSET volatile.Register32 // 0x4
	INTFLAG  volatile.Register32 // 0x8
	STATUS   volatile.Register32 // 0xC
	BOD33    volatile.Register32 // 0x10
	BOD12    volatile.Register32 // 0x14
	VREG     volatile.Register32 // 0x18
	VREF     volatile.Register32 // 0x1C
	_        [12]byte
	EVCTRL   volatile.Register32 // 0x2C
	VREGSUSP volatile.Register32 // 0x30
}

// SUPC.INTENCLR: Interrupt Enable Clear
func (o *SUPC_Type) SetINTENCLR_BOD33RDY(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *SUPC_Type) GetINTENCLR_BOD33RDY() uint32 {
	return volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1
}
func (o *SUPC_Type) SetINTENCLR_BOD33DET(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *SUPC_Type) GetINTENCLR_BOD33DET() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *SUPC_Type) SetINTENCLR_B33SRDY(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *SUPC_Type) GetINTENCLR_B33SRDY() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4) >> 2
}
func (o *SUPC_Type) SetINTENCLR_BOD12RDY(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x8)|value<<3)
}
func (o *SUPC_Type) GetINTENCLR_BOD12RDY() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x8) >> 3
}
func (o *SUPC_Type) SetINTENCLR_BOD12DET(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x10)|value<<4)
}
func (o *SUPC_Type) GetINTENCLR_BOD12DET() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x10) >> 4
}
func (o *SUPC_Type) SetINTENCLR_B12SRDY(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x20)|value<<5)
}
func (o *SUPC_Type) GetINTENCLR_B12SRDY() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x20) >> 5
}
func (o *SUPC_Type) SetINTENCLR_VREGRDY(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x100)|value<<8)
}
func (o *SUPC_Type) GetINTENCLR_VREGRDY() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x100) >> 8
}
func (o *SUPC_Type) SetINTENCLR_VCORERDY(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x400)|value<<10)
}
func (o *SUPC_Type) GetINTENCLR_VCORERDY() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x400) >> 10
}
func (o *SUPC_Type) SetINTENCLR_ULPVREFRDY(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x800)|value<<11)
}
func (o *SUPC_Type) GetINTENCLR_ULPVREFRDY() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x800) >> 11
}

// SUPC.INTENSET: Interrupt Enable Set
func (o *SUPC_Type) SetINTENSET_BOD33RDY(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *SUPC_Type) GetINTENSET_BOD33RDY() uint32 {
	return volatile.LoadUint32(&o.INTENSET.Reg) & 0x1
}
func (o *SUPC_Type) SetINTENSET_BOD33DET(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *SUPC_Type) GetINTENSET_BOD33DET() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *SUPC_Type) SetINTENSET_B33SRDY(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *SUPC_Type) GetINTENSET_B33SRDY() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4) >> 2
}
func (o *SUPC_Type) SetINTENSET_BOD12RDY(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x8)|value<<3)
}
func (o *SUPC_Type) GetINTENSET_BOD12RDY() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x8) >> 3
}
func (o *SUPC_Type) SetINTENSET_BOD12DET(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x10)|value<<4)
}
func (o *SUPC_Type) GetINTENSET_BOD12DET() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x10) >> 4
}
func (o *SUPC_Type) SetINTENSET_B12SRDY(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x20)|value<<5)
}
func (o *SUPC_Type) GetINTENSET_B12SRDY() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x20) >> 5
}
func (o *SUPC_Type) SetINTENSET_VREGRDY(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x100)|value<<8)
}
func (o *SUPC_Type) GetINTENSET_VREGRDY() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x100) >> 8
}
func (o *SUPC_Type) SetINTENSET_VCORERDY(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x400)|value<<10)
}
func (o *SUPC_Type) GetINTENSET_VCORERDY() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x400) >> 10
}
func (o *SUPC_Type) SetINTENSET_ULPVREFRDY(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x800)|value<<11)
}
func (o *SUPC_Type) GetINTENSET_ULPVREFRDY() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x800) >> 11
}

// SUPC.INTFLAG: Interrupt Flag Status and Clear
func (o *SUPC_Type) SetINTFLAG_BOD33RDY(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x1)|value)
}
func (o *SUPC_Type) GetINTFLAG_BOD33RDY() uint32 {
	return volatile.LoadUint32(&o.INTFLAG.Reg) & 0x1
}
func (o *SUPC_Type) SetINTFLAG_BOD33DET(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x2)|value<<1)
}
func (o *SUPC_Type) GetINTFLAG_BOD33DET() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x2) >> 1
}
func (o *SUPC_Type) SetINTFLAG_B33SRDY(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x4)|value<<2)
}
func (o *SUPC_Type) GetINTFLAG_B33SRDY() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x4) >> 2
}
func (o *SUPC_Type) SetINTFLAG_BOD12RDY(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x8)|value<<3)
}
func (o *SUPC_Type) GetINTFLAG_BOD12RDY() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x8) >> 3
}
func (o *SUPC_Type) SetINTFLAG_BOD12DET(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x10)|value<<4)
}
func (o *SUPC_Type) GetINTFLAG_BOD12DET() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x10) >> 4
}
func (o *SUPC_Type) SetINTFLAG_B12SRDY(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x20)|value<<5)
}
func (o *SUPC_Type) GetINTFLAG_B12SRDY() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x20) >> 5
}
func (o *SUPC_Type) SetINTFLAG_VREGRDY(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x100)|value<<8)
}
func (o *SUPC_Type) GetINTFLAG_VREGRDY() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x100) >> 8
}
func (o *SUPC_Type) SetINTFLAG_VCORERDY(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x400)|value<<10)
}
func (o *SUPC_Type) GetINTFLAG_VCORERDY() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x400) >> 10
}
func (o *SUPC_Type) SetINTFLAG_ULPVREFRDY(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x800)|value<<11)
}
func (o *SUPC_Type) GetINTFLAG_ULPVREFRDY() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x800) >> 11
}

// SUPC.STATUS: Power and Clocks Status
func (o *SUPC_Type) SetSTATUS_BOD33RDY(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x1)|value)
}
func (o *SUPC_Type) GetSTATUS_BOD33RDY() uint32 {
	return volatile.LoadUint32(&o.STATUS.Reg) & 0x1
}
func (o *SUPC_Type) SetSTATUS_BOD33DET(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x2)|value<<1)
}
func (o *SUPC_Type) GetSTATUS_BOD33DET() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x2) >> 1
}
func (o *SUPC_Type) SetSTATUS_B33SRDY(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x4)|value<<2)
}
func (o *SUPC_Type) GetSTATUS_B33SRDY() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x4) >> 2
}
func (o *SUPC_Type) SetSTATUS_BOD12RDY(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x8)|value<<3)
}
func (o *SUPC_Type) GetSTATUS_BOD12RDY() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x8) >> 3
}
func (o *SUPC_Type) SetSTATUS_BOD12DET(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x10)|value<<4)
}
func (o *SUPC_Type) GetSTATUS_BOD12DET() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x10) >> 4
}
func (o *SUPC_Type) SetSTATUS_B12SRDY(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x20)|value<<5)
}
func (o *SUPC_Type) GetSTATUS_B12SRDY() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x20) >> 5
}
func (o *SUPC_Type) SetSTATUS_VREGRDY(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x100)|value<<8)
}
func (o *SUPC_Type) GetSTATUS_VREGRDY() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x100) >> 8
}
func (o *SUPC_Type) SetSTATUS_VCORERDY(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x400)|value<<10)
}
func (o *SUPC_Type) GetSTATUS_VCORERDY() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x400) >> 10
}
func (o *SUPC_Type) SetSTATUS_ULPVREFRDY(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x1000)|value<<12)
}
func (o *SUPC_Type) GetSTATUS_ULPVREFRDY() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x1000) >> 12
}
func (o *SUPC_Type) SetSTATUS_ULPBIASRDY(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *SUPC_Type) GetSTATUS_ULPBIASRDY() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x2000) >> 13
}

// SUPC.BOD33: BOD33 Control
func (o *SUPC_Type) SetBOD33_ENABLE(value uint32) {
	volatile.StoreUint32(&o.BOD33.Reg, volatile.LoadUint32(&o.BOD33.Reg)&^(0x2)|value<<1)
}
func (o *SUPC_Type) GetBOD33_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.BOD33.Reg) & 0x2) >> 1
}
func (o *SUPC_Type) SetBOD33_HYST(value uint32) {
	volatile.StoreUint32(&o.BOD33.Reg, volatile.LoadUint32(&o.BOD33.Reg)&^(0x4)|value<<2)
}
func (o *SUPC_Type) GetBOD33_HYST() uint32 {
	return (volatile.LoadUint32(&o.BOD33.Reg) & 0x4) >> 2
}
func (o *SUPC_Type) SetBOD33_ACTION(value uint32) {
	volatile.StoreUint32(&o.BOD33.Reg, volatile.LoadUint32(&o.BOD33.Reg)&^(0x18)|value<<3)
}
func (o *SUPC_Type) GetBOD33_ACTION() uint32 {
	return (volatile.LoadUint32(&o.BOD33.Reg) & 0x18) >> 3
}
func (o *SUPC_Type) SetBOD33_STDBYCFG(value uint32) {
	volatile.StoreUint32(&o.BOD33.Reg, volatile.LoadUint32(&o.BOD33.Reg)&^(0x20)|value<<5)
}
func (o *SUPC_Type) GetBOD33_STDBYCFG() uint32 {
	return (volatile.LoadUint32(&o.BOD33.Reg) & 0x20) >> 5
}
func (o *SUPC_Type) SetBOD33_RUNSTDBY(value uint32) {
	volatile.StoreUint32(&o.BOD33.Reg, volatile.LoadUint32(&o.BOD33.Reg)&^(0x40)|value<<6)
}
func (o *SUPC_Type) GetBOD33_RUNSTDBY() uint32 {
	return (volatile.LoadUint32(&o.BOD33.Reg) & 0x40) >> 6
}
func (o *SUPC_Type) SetBOD33_ACTCFG(value uint32) {
	volatile.StoreUint32(&o.BOD33.Reg, volatile.LoadUint32(&o.BOD33.Reg)&^(0x100)|value<<8)
}
func (o *SUPC_Type) GetBOD33_ACTCFG() uint32 {
	return (volatile.LoadUint32(&o.BOD33.Reg) & 0x100) >> 8
}
func (o *SUPC_Type) SetBOD33_REFSEL(value uint32) {
	volatile.StoreUint32(&o.BOD33.Reg, volatile.LoadUint32(&o.BOD33.Reg)&^(0x800)|value<<11)
}
func (o *SUPC_Type) GetBOD33_REFSEL() uint32 {
	return (volatile.LoadUint32(&o.BOD33.Reg) & 0x800) >> 11
}
func (o *SUPC_Type) SetBOD33_PSEL(value uint32) {
	volatile.StoreUint32(&o.BOD33.Reg, volatile.LoadUint32(&o.BOD33.Reg)&^(0xf000)|value<<12)
}
func (o *SUPC_Type) GetBOD33_PSEL() uint32 {
	return (volatile.LoadUint32(&o.BOD33.Reg) & 0xf000) >> 12
}
func (o *SUPC_Type) SetBOD33_LEVEL(value uint32) {
	volatile.StoreUint32(&o.BOD33.Reg, volatile.LoadUint32(&o.BOD33.Reg)&^(0x3f0000)|value<<16)
}
func (o *SUPC_Type) GetBOD33_LEVEL() uint32 {
	return (volatile.LoadUint32(&o.BOD33.Reg) & 0x3f0000) >> 16
}

// SUPC.BOD12: BOD12 Control
func (o *SUPC_Type) SetBOD12_ENABLE(value uint32) {
	volatile.StoreUint32(&o.BOD12.Reg, volatile.LoadUint32(&o.BOD12.Reg)&^(0x2)|value<<1)
}
func (o *SUPC_Type) GetBOD12_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.BOD12.Reg) & 0x2) >> 1
}
func (o *SUPC_Type) SetBOD12_HYST(value uint32) {
	volatile.StoreUint32(&o.BOD12.Reg, volatile.LoadUint32(&o.BOD12.Reg)&^(0x4)|value<<2)
}
func (o *SUPC_Type) GetBOD12_HYST() uint32 {
	return (volatile.LoadUint32(&o.BOD12.Reg) & 0x4) >> 2
}
func (o *SUPC_Type) SetBOD12_ACTION(value uint32) {
	volatile.StoreUint32(&o.BOD12.Reg, volatile.LoadUint32(&o.BOD12.Reg)&^(0x18)|value<<3)
}
func (o *SUPC_Type) GetBOD12_ACTION() uint32 {
	return (volatile.LoadUint32(&o.BOD12.Reg) & 0x18) >> 3
}
func (o *SUPC_Type) SetBOD12_STDBYCFG(value uint32) {
	volatile.StoreUint32(&o.BOD12.Reg, volatile.LoadUint32(&o.BOD12.Reg)&^(0x20)|value<<5)
}
func (o *SUPC_Type) GetBOD12_STDBYCFG() uint32 {
	return (volatile.LoadUint32(&o.BOD12.Reg) & 0x20) >> 5
}
func (o *SUPC_Type) SetBOD12_RUNSTDBY(value uint32) {
	volatile.StoreUint32(&o.BOD12.Reg, volatile.LoadUint32(&o.BOD12.Reg)&^(0x40)|value<<6)
}
func (o *SUPC_Type) GetBOD12_RUNSTDBY() uint32 {
	return (volatile.LoadUint32(&o.BOD12.Reg) & 0x40) >> 6
}
func (o *SUPC_Type) SetBOD12_ACTCFG(value uint32) {
	volatile.StoreUint32(&o.BOD12.Reg, volatile.LoadUint32(&o.BOD12.Reg)&^(0x100)|value<<8)
}
func (o *SUPC_Type) GetBOD12_ACTCFG() uint32 {
	return (volatile.LoadUint32(&o.BOD12.Reg) & 0x100) >> 8
}
func (o *SUPC_Type) SetBOD12_PSEL(value uint32) {
	volatile.StoreUint32(&o.BOD12.Reg, volatile.LoadUint32(&o.BOD12.Reg)&^(0xf000)|value<<12)
}
func (o *SUPC_Type) GetBOD12_PSEL() uint32 {
	return (volatile.LoadUint32(&o.BOD12.Reg) & 0xf000) >> 12
}
func (o *SUPC_Type) SetBOD12_LEVEL(value uint32) {
	volatile.StoreUint32(&o.BOD12.Reg, volatile.LoadUint32(&o.BOD12.Reg)&^(0x3f0000)|value<<16)
}
func (o *SUPC_Type) GetBOD12_LEVEL() uint32 {
	return (volatile.LoadUint32(&o.BOD12.Reg) & 0x3f0000) >> 16
}

// SUPC.VREG: VREG Control
func (o *SUPC_Type) SetVREG_ENABLE(value uint32) {
	volatile.StoreUint32(&o.VREG.Reg, volatile.LoadUint32(&o.VREG.Reg)&^(0x2)|value<<1)
}
func (o *SUPC_Type) GetVREG_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.VREG.Reg) & 0x2) >> 1
}
func (o *SUPC_Type) SetVREG_SEL(value uint32) {
	volatile.StoreUint32(&o.VREG.Reg, volatile.LoadUint32(&o.VREG.Reg)&^(0xc)|value<<2)
}
func (o *SUPC_Type) GetVREG_SEL() uint32 {
	return (volatile.LoadUint32(&o.VREG.Reg) & 0xc) >> 2
}
func (o *SUPC_Type) SetVREG_STDBYPL0(value uint32) {
	volatile.StoreUint32(&o.VREG.Reg, volatile.LoadUint32(&o.VREG.Reg)&^(0x20)|value<<5)
}
func (o *SUPC_Type) GetVREG_STDBYPL0() uint32 {
	return (volatile.LoadUint32(&o.VREG.Reg) & 0x20) >> 5
}
func (o *SUPC_Type) SetVREG_RUNSTDBY(value uint32) {
	volatile.StoreUint32(&o.VREG.Reg, volatile.LoadUint32(&o.VREG.Reg)&^(0x40)|value<<6)
}
func (o *SUPC_Type) GetVREG_RUNSTDBY() uint32 {
	return (volatile.LoadUint32(&o.VREG.Reg) & 0x40) >> 6
}
func (o *SUPC_Type) SetVREG_LPEFF(value uint32) {
	volatile.StoreUint32(&o.VREG.Reg, volatile.LoadUint32(&o.VREG.Reg)&^(0x100)|value<<8)
}
func (o *SUPC_Type) GetVREG_LPEFF() uint32 {
	return (volatile.LoadUint32(&o.VREG.Reg) & 0x100) >> 8
}
func (o *SUPC_Type) SetVREG_VREFSEL(value uint32) {
	volatile.StoreUint32(&o.VREG.Reg, volatile.LoadUint32(&o.VREG.Reg)&^(0x200)|value<<9)
}
func (o *SUPC_Type) GetVREG_VREFSEL() uint32 {
	return (volatile.LoadUint32(&o.VREG.Reg) & 0x200) >> 9
}
func (o *SUPC_Type) SetVREG_VSVSTEP(value uint32) {
	volatile.StoreUint32(&o.VREG.Reg, volatile.LoadUint32(&o.VREG.Reg)&^(0xf0000)|value<<16)
}
func (o *SUPC_Type) GetVREG_VSVSTEP() uint32 {
	return (volatile.LoadUint32(&o.VREG.Reg) & 0xf0000) >> 16
}
func (o *SUPC_Type) SetVREG_VSPER(value uint32) {
	volatile.StoreUint32(&o.VREG.Reg, volatile.LoadUint32(&o.VREG.Reg)&^(0xff000000)|value<<24)
}
func (o *SUPC_Type) GetVREG_VSPER() uint32 {
	return (volatile.LoadUint32(&o.VREG.Reg) & 0xff000000) >> 24
}

// SUPC.VREF: VREF Control
func (o *SUPC_Type) SetVREF_TSEN(value uint32) {
	volatile.StoreUint32(&o.VREF.Reg, volatile.LoadUint32(&o.VREF.Reg)&^(0x2)|value<<1)
}
func (o *SUPC_Type) GetVREF_TSEN() uint32 {
	return (volatile.LoadUint32(&o.VREF.Reg) & 0x2) >> 1
}
func (o *SUPC_Type) SetVREF_VREFOE(value uint32) {
	volatile.StoreUint32(&o.VREF.Reg, volatile.LoadUint32(&o.VREF.Reg)&^(0x4)|value<<2)
}
func (o *SUPC_Type) GetVREF_VREFOE() uint32 {
	return (volatile.LoadUint32(&o.VREF.Reg) & 0x4) >> 2
}
func (o *SUPC_Type) SetVREF_TSSEL(value uint32) {
	volatile.StoreUint32(&o.VREF.Reg, volatile.LoadUint32(&o.VREF.Reg)&^(0x8)|value<<3)
}
func (o *SUPC_Type) GetVREF_TSSEL() uint32 {
	return (volatile.LoadUint32(&o.VREF.Reg) & 0x8) >> 3
}
func (o *SUPC_Type) SetVREF_RUNSTDBY(value uint32) {
	volatile.StoreUint32(&o.VREF.Reg, volatile.LoadUint32(&o.VREF.Reg)&^(0x40)|value<<6)
}
func (o *SUPC_Type) GetVREF_RUNSTDBY() uint32 {
	return (volatile.LoadUint32(&o.VREF.Reg) & 0x40) >> 6
}
func (o *SUPC_Type) SetVREF_ONDEMAND(value uint32) {
	volatile.StoreUint32(&o.VREF.Reg, volatile.LoadUint32(&o.VREF.Reg)&^(0x80)|value<<7)
}
func (o *SUPC_Type) GetVREF_ONDEMAND() uint32 {
	return (volatile.LoadUint32(&o.VREF.Reg) & 0x80) >> 7
}
func (o *SUPC_Type) SetVREF_SEL(value uint32) {
	volatile.StoreUint32(&o.VREF.Reg, volatile.LoadUint32(&o.VREF.Reg)&^(0xf0000)|value<<16)
}
func (o *SUPC_Type) GetVREF_SEL() uint32 {
	return (volatile.LoadUint32(&o.VREF.Reg) & 0xf0000) >> 16
}

// SUPC.EVCTRL: Event Control
func (o *SUPC_Type) SetEVCTRL_BOD33DETEO(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x2)|value<<1)
}
func (o *SUPC_Type) GetEVCTRL_BOD33DETEO() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x2) >> 1
}
func (o *SUPC_Type) SetEVCTRL_BOD12DETEO(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x10)|value<<4)
}
func (o *SUPC_Type) GetEVCTRL_BOD12DETEO() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x10) >> 4
}

// SUPC.VREGSUSP: VREG Suspend Control
func (o *SUPC_Type) SetVREGSUSP_VREGSEN(value uint32) {
	volatile.StoreUint32(&o.VREGSUSP.Reg, volatile.LoadUint32(&o.VREGSUSP.Reg)&^(0x1)|value)
}
func (o *SUPC_Type) GetVREGSUSP_VREGSEN() uint32 {
	return volatile.LoadUint32(&o.VREGSUSP.Reg) & 0x1
}

// Basic Timer Counter
type TC_Type struct {
}

// Basic Timer Counter - COUNT8
type TC_COUNT8_Type struct {
	CTRLA    volatile.Register32 // 0x0
	CTRLBCLR volatile.Register8  // 0x4
	CTRLBSET volatile.Register8  // 0x5
	EVCTRL   volatile.Register16 // 0x6
	INTENCLR volatile.Register8  // 0x8
	INTENSET volatile.Register8  // 0x9
	INTFLAG  volatile.Register8  // 0xA
	STATUS   volatile.Register8  // 0xB
	WAVE     volatile.Register8  // 0xC
	DRVCTRL  volatile.Register8  // 0xD
	_        byte
	DBGCTRL  volatile.Register8  // 0xF
	SYNCBUSY volatile.Register32 // 0x10
	COUNT    volatile.Register8  // 0x14
	_        [6]byte
	PER      volatile.Register8    // 0x1B
	CC       [2]volatile.Register8 // 0x1C
	_        [17]byte
	PERBUF   volatile.Register8    // 0x2F
	CCBUF    [2]volatile.Register8 // 0x30
}

// TC_COUNT8.CTRLA: Control A
func (o *TC_COUNT8_Type) SetCTRLA_SWRST(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x1)|value)
}
func (o *TC_COUNT8_Type) GetCTRLA_SWRST() uint32 {
	return volatile.LoadUint32(&o.CTRLA.Reg) & 0x1
}
func (o *TC_COUNT8_Type) SetCTRLA_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x2)|value<<1)
}
func (o *TC_COUNT8_Type) GetCTRLA_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x2) >> 1
}
func (o *TC_COUNT8_Type) SetCTRLA_MODE(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0xc)|value<<2)
}
func (o *TC_COUNT8_Type) GetCTRLA_MODE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0xc) >> 2
}
func (o *TC_COUNT8_Type) SetCTRLA_PRESCSYNC(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x30)|value<<4)
}
func (o *TC_COUNT8_Type) GetCTRLA_PRESCSYNC() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x30) >> 4
}
func (o *TC_COUNT8_Type) SetCTRLA_RUNSTDBY(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x40)|value<<6)
}
func (o *TC_COUNT8_Type) GetCTRLA_RUNSTDBY() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x40) >> 6
}
func (o *TC_COUNT8_Type) SetCTRLA_ONDEMAND(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x80)|value<<7)
}
func (o *TC_COUNT8_Type) GetCTRLA_ONDEMAND() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x80) >> 7
}
func (o *TC_COUNT8_Type) SetCTRLA_PRESCALER(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x700)|value<<8)
}
func (o *TC_COUNT8_Type) GetCTRLA_PRESCALER() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x700) >> 8
}
func (o *TC_COUNT8_Type) SetCTRLA_ALOCK(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x800)|value<<11)
}
func (o *TC_COUNT8_Type) GetCTRLA_ALOCK() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x800) >> 11
}
func (o *TC_COUNT8_Type) SetCTRLA_CAPTEN0(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x10000)|value<<16)
}
func (o *TC_COUNT8_Type) GetCTRLA_CAPTEN0() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x10000) >> 16
}
func (o *TC_COUNT8_Type) SetCTRLA_CAPTEN1(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x20000)|value<<17)
}
func (o *TC_COUNT8_Type) GetCTRLA_CAPTEN1() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x20000) >> 17
}
func (o *TC_COUNT8_Type) SetCTRLA_COPEN0(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x100000)|value<<20)
}
func (o *TC_COUNT8_Type) GetCTRLA_COPEN0() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x100000) >> 20
}
func (o *TC_COUNT8_Type) SetCTRLA_COPEN1(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x200000)|value<<21)
}
func (o *TC_COUNT8_Type) GetCTRLA_COPEN1() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x200000) >> 21
}
func (o *TC_COUNT8_Type) SetCTRLA_CAPTMODE0(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x3000000)|value<<24)
}
func (o *TC_COUNT8_Type) GetCTRLA_CAPTMODE0() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x3000000) >> 24
}
func (o *TC_COUNT8_Type) SetCTRLA_CAPTMODE1(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x18000000)|value<<27)
}
func (o *TC_COUNT8_Type) GetCTRLA_CAPTMODE1() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x18000000) >> 27
}

// TC_COUNT8.CTRLBCLR: Control B Clear
func (o *TC_COUNT8_Type) SetCTRLBCLR_DIR(value uint8) {
	volatile.StoreUint8(&o.CTRLBCLR.Reg, volatile.LoadUint8(&o.CTRLBCLR.Reg)&^(0x1)|value)
}
func (o *TC_COUNT8_Type) GetCTRLBCLR_DIR() uint8 {
	return volatile.LoadUint8(&o.CTRLBCLR.Reg) & 0x1
}
func (o *TC_COUNT8_Type) SetCTRLBCLR_LUPD(value uint8) {
	volatile.StoreUint8(&o.CTRLBCLR.Reg, volatile.LoadUint8(&o.CTRLBCLR.Reg)&^(0x2)|value<<1)
}
func (o *TC_COUNT8_Type) GetCTRLBCLR_LUPD() uint8 {
	return (volatile.LoadUint8(&o.CTRLBCLR.Reg) & 0x2) >> 1
}
func (o *TC_COUNT8_Type) SetCTRLBCLR_ONESHOT(value uint8) {
	volatile.StoreUint8(&o.CTRLBCLR.Reg, volatile.LoadUint8(&o.CTRLBCLR.Reg)&^(0x4)|value<<2)
}
func (o *TC_COUNT8_Type) GetCTRLBCLR_ONESHOT() uint8 {
	return (volatile.LoadUint8(&o.CTRLBCLR.Reg) & 0x4) >> 2
}
func (o *TC_COUNT8_Type) SetCTRLBCLR_CMD(value uint8) {
	volatile.StoreUint8(&o.CTRLBCLR.Reg, volatile.LoadUint8(&o.CTRLBCLR.Reg)&^(0xe0)|value<<5)
}
func (o *TC_COUNT8_Type) GetCTRLBCLR_CMD() uint8 {
	return (volatile.LoadUint8(&o.CTRLBCLR.Reg) & 0xe0) >> 5
}

// TC_COUNT8.CTRLBSET: Control B Set
func (o *TC_COUNT8_Type) SetCTRLBSET_DIR(value uint8) {
	volatile.StoreUint8(&o.CTRLBSET.Reg, volatile.LoadUint8(&o.CTRLBSET.Reg)&^(0x1)|value)
}
func (o *TC_COUNT8_Type) GetCTRLBSET_DIR() uint8 {
	return volatile.LoadUint8(&o.CTRLBSET.Reg) & 0x1
}
func (o *TC_COUNT8_Type) SetCTRLBSET_LUPD(value uint8) {
	volatile.StoreUint8(&o.CTRLBSET.Reg, volatile.LoadUint8(&o.CTRLBSET.Reg)&^(0x2)|value<<1)
}
func (o *TC_COUNT8_Type) GetCTRLBSET_LUPD() uint8 {
	return (volatile.LoadUint8(&o.CTRLBSET.Reg) & 0x2) >> 1
}
func (o *TC_COUNT8_Type) SetCTRLBSET_ONESHOT(value uint8) {
	volatile.StoreUint8(&o.CTRLBSET.Reg, volatile.LoadUint8(&o.CTRLBSET.Reg)&^(0x4)|value<<2)
}
func (o *TC_COUNT8_Type) GetCTRLBSET_ONESHOT() uint8 {
	return (volatile.LoadUint8(&o.CTRLBSET.Reg) & 0x4) >> 2
}
func (o *TC_COUNT8_Type) SetCTRLBSET_CMD(value uint8) {
	volatile.StoreUint8(&o.CTRLBSET.Reg, volatile.LoadUint8(&o.CTRLBSET.Reg)&^(0xe0)|value<<5)
}
func (o *TC_COUNT8_Type) GetCTRLBSET_CMD() uint8 {
	return (volatile.LoadUint8(&o.CTRLBSET.Reg) & 0xe0) >> 5
}

// TC_COUNT8.EVCTRL: Event Control
func (o *TC_COUNT8_Type) SetEVCTRL_EVACT(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x7)|value)
}
func (o *TC_COUNT8_Type) GetEVCTRL_EVACT() uint16 {
	return volatile.LoadUint16(&o.EVCTRL.Reg) & 0x7
}
func (o *TC_COUNT8_Type) SetEVCTRL_TCINV(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x10)|value<<4)
}
func (o *TC_COUNT8_Type) GetEVCTRL_TCINV() uint16 {
	return (volatile.LoadUint16(&o.EVCTRL.Reg) & 0x10) >> 4
}
func (o *TC_COUNT8_Type) SetEVCTRL_TCEI(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x20)|value<<5)
}
func (o *TC_COUNT8_Type) GetEVCTRL_TCEI() uint16 {
	return (volatile.LoadUint16(&o.EVCTRL.Reg) & 0x20) >> 5
}
func (o *TC_COUNT8_Type) SetEVCTRL_OVFEO(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x100)|value<<8)
}
func (o *TC_COUNT8_Type) GetEVCTRL_OVFEO() uint16 {
	return (volatile.LoadUint16(&o.EVCTRL.Reg) & 0x100) >> 8
}
func (o *TC_COUNT8_Type) SetEVCTRL_MCEO0(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x1000)|value<<12)
}
func (o *TC_COUNT8_Type) GetEVCTRL_MCEO0() uint16 {
	return (volatile.LoadUint16(&o.EVCTRL.Reg) & 0x1000) >> 12
}
func (o *TC_COUNT8_Type) SetEVCTRL_MCEO1(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x2000)|value<<13)
}
func (o *TC_COUNT8_Type) GetEVCTRL_MCEO1() uint16 {
	return (volatile.LoadUint16(&o.EVCTRL.Reg) & 0x2000) >> 13
}

// TC_COUNT8.INTENCLR: Interrupt Enable Clear
func (o *TC_COUNT8_Type) SetINTENCLR_OVF(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *TC_COUNT8_Type) GetINTENCLR_OVF() uint8 {
	return volatile.LoadUint8(&o.INTENCLR.Reg) & 0x1
}
func (o *TC_COUNT8_Type) SetINTENCLR_ERR(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *TC_COUNT8_Type) GetINTENCLR_ERR() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *TC_COUNT8_Type) SetINTENCLR_MC0(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x10)|value<<4)
}
func (o *TC_COUNT8_Type) GetINTENCLR_MC0() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x10) >> 4
}
func (o *TC_COUNT8_Type) SetINTENCLR_MC1(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x20)|value<<5)
}
func (o *TC_COUNT8_Type) GetINTENCLR_MC1() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x20) >> 5
}

// TC_COUNT8.INTENSET: Interrupt Enable Set
func (o *TC_COUNT8_Type) SetINTENSET_OVF(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *TC_COUNT8_Type) GetINTENSET_OVF() uint8 {
	return volatile.LoadUint8(&o.INTENSET.Reg) & 0x1
}
func (o *TC_COUNT8_Type) SetINTENSET_ERR(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *TC_COUNT8_Type) GetINTENSET_ERR() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *TC_COUNT8_Type) SetINTENSET_MC0(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x10)|value<<4)
}
func (o *TC_COUNT8_Type) GetINTENSET_MC0() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x10) >> 4
}
func (o *TC_COUNT8_Type) SetINTENSET_MC1(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x20)|value<<5)
}
func (o *TC_COUNT8_Type) GetINTENSET_MC1() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x20) >> 5
}

// TC_COUNT8.INTFLAG: Interrupt Flag Status and Clear
func (o *TC_COUNT8_Type) SetINTFLAG_OVF(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x1)|value)
}
func (o *TC_COUNT8_Type) GetINTFLAG_OVF() uint8 {
	return volatile.LoadUint8(&o.INTFLAG.Reg) & 0x1
}
func (o *TC_COUNT8_Type) SetINTFLAG_ERR(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x2)|value<<1)
}
func (o *TC_COUNT8_Type) GetINTFLAG_ERR() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x2) >> 1
}
func (o *TC_COUNT8_Type) SetINTFLAG_MC0(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x10)|value<<4)
}
func (o *TC_COUNT8_Type) GetINTFLAG_MC0() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x10) >> 4
}
func (o *TC_COUNT8_Type) SetINTFLAG_MC1(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x20)|value<<5)
}
func (o *TC_COUNT8_Type) GetINTFLAG_MC1() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x20) >> 5
}

// TC_COUNT8.STATUS: Status
func (o *TC_COUNT8_Type) SetSTATUS_STOP(value uint8) {
	volatile.StoreUint8(&o.STATUS.Reg, volatile.LoadUint8(&o.STATUS.Reg)&^(0x1)|value)
}
func (o *TC_COUNT8_Type) GetSTATUS_STOP() uint8 {
	return volatile.LoadUint8(&o.STATUS.Reg) & 0x1
}
func (o *TC_COUNT8_Type) SetSTATUS_SLAVE(value uint8) {
	volatile.StoreUint8(&o.STATUS.Reg, volatile.LoadUint8(&o.STATUS.Reg)&^(0x2)|value<<1)
}
func (o *TC_COUNT8_Type) GetSTATUS_SLAVE() uint8 {
	return (volatile.LoadUint8(&o.STATUS.Reg) & 0x2) >> 1
}
func (o *TC_COUNT8_Type) SetSTATUS_PERBUFV(value uint8) {
	volatile.StoreUint8(&o.STATUS.Reg, volatile.LoadUint8(&o.STATUS.Reg)&^(0x8)|value<<3)
}
func (o *TC_COUNT8_Type) GetSTATUS_PERBUFV() uint8 {
	return (volatile.LoadUint8(&o.STATUS.Reg) & 0x8) >> 3
}
func (o *TC_COUNT8_Type) SetSTATUS_CCBUFV0(value uint8) {
	volatile.StoreUint8(&o.STATUS.Reg, volatile.LoadUint8(&o.STATUS.Reg)&^(0x10)|value<<4)
}
func (o *TC_COUNT8_Type) GetSTATUS_CCBUFV0() uint8 {
	return (volatile.LoadUint8(&o.STATUS.Reg) & 0x10) >> 4
}
func (o *TC_COUNT8_Type) SetSTATUS_CCBUFV1(value uint8) {
	volatile.StoreUint8(&o.STATUS.Reg, volatile.LoadUint8(&o.STATUS.Reg)&^(0x20)|value<<5)
}
func (o *TC_COUNT8_Type) GetSTATUS_CCBUFV1() uint8 {
	return (volatile.LoadUint8(&o.STATUS.Reg) & 0x20) >> 5
}

// TC_COUNT8.WAVE: Waveform Generation Control
func (o *TC_COUNT8_Type) SetWAVE_WAVEGEN(value uint8) {
	volatile.StoreUint8(&o.WAVE.Reg, volatile.LoadUint8(&o.WAVE.Reg)&^(0x3)|value)
}
func (o *TC_COUNT8_Type) GetWAVE_WAVEGEN() uint8 {
	return volatile.LoadUint8(&o.WAVE.Reg) & 0x3
}

// TC_COUNT8.DRVCTRL: Control C
func (o *TC_COUNT8_Type) SetDRVCTRL_INVEN0(value uint8) {
	volatile.StoreUint8(&o.DRVCTRL.Reg, volatile.LoadUint8(&o.DRVCTRL.Reg)&^(0x1)|value)
}
func (o *TC_COUNT8_Type) GetDRVCTRL_INVEN0() uint8 {
	return volatile.LoadUint8(&o.DRVCTRL.Reg) & 0x1
}
func (o *TC_COUNT8_Type) SetDRVCTRL_INVEN1(value uint8) {
	volatile.StoreUint8(&o.DRVCTRL.Reg, volatile.LoadUint8(&o.DRVCTRL.Reg)&^(0x2)|value<<1)
}
func (o *TC_COUNT8_Type) GetDRVCTRL_INVEN1() uint8 {
	return (volatile.LoadUint8(&o.DRVCTRL.Reg) & 0x2) >> 1
}

// TC_COUNT8.DBGCTRL: Debug Control
func (o *TC_COUNT8_Type) SetDBGCTRL_DBGRUN(value uint8) {
	volatile.StoreUint8(&o.DBGCTRL.Reg, volatile.LoadUint8(&o.DBGCTRL.Reg)&^(0x1)|value)
}
func (o *TC_COUNT8_Type) GetDBGCTRL_DBGRUN() uint8 {
	return volatile.LoadUint8(&o.DBGCTRL.Reg) & 0x1
}

// TC_COUNT8.SYNCBUSY: Synchronization Status
func (o *TC_COUNT8_Type) SetSYNCBUSY_SWRST(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x1)|value)
}
func (o *TC_COUNT8_Type) GetSYNCBUSY_SWRST() uint32 {
	return volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x1
}
func (o *TC_COUNT8_Type) SetSYNCBUSY_ENABLE(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x2)|value<<1)
}
func (o *TC_COUNT8_Type) GetSYNCBUSY_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x2) >> 1
}
func (o *TC_COUNT8_Type) SetSYNCBUSY_CTRLB(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x4)|value<<2)
}
func (o *TC_COUNT8_Type) GetSYNCBUSY_CTRLB() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x4) >> 2
}
func (o *TC_COUNT8_Type) SetSYNCBUSY_STATUS(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x8)|value<<3)
}
func (o *TC_COUNT8_Type) GetSYNCBUSY_STATUS() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x8) >> 3
}
func (o *TC_COUNT8_Type) SetSYNCBUSY_COUNT(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x10)|value<<4)
}
func (o *TC_COUNT8_Type) GetSYNCBUSY_COUNT() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x10) >> 4
}
func (o *TC_COUNT8_Type) SetSYNCBUSY_PER(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x20)|value<<5)
}
func (o *TC_COUNT8_Type) GetSYNCBUSY_PER() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x20) >> 5
}
func (o *TC_COUNT8_Type) SetSYNCBUSY_CC0(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x40)|value<<6)
}
func (o *TC_COUNT8_Type) GetSYNCBUSY_CC0() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x40) >> 6
}
func (o *TC_COUNT8_Type) SetSYNCBUSY_CC1(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x80)|value<<7)
}
func (o *TC_COUNT8_Type) GetSYNCBUSY_CC1() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x80) >> 7
}

// TC_COUNT8.COUNT: COUNT8 Count
func (o *TC_COUNT8_Type) SetCOUNT(value uint8) {
	volatile.StoreUint8(&o.COUNT.Reg, value)
}
func (o *TC_COUNT8_Type) GetCOUNT() uint8 {
	return volatile.LoadUint8(&o.COUNT.Reg)
}

// TC_COUNT8.PER: COUNT8 Period
func (o *TC_COUNT8_Type) SetPER(value uint8) {
	volatile.StoreUint8(&o.PER.Reg, value)
}
func (o *TC_COUNT8_Type) GetPER() uint8 {
	return volatile.LoadUint8(&o.PER.Reg)
}

// TC_COUNT8.CC: COUNT8 Compare and Capture
func (o *TC_COUNT8_Type) SetCC(idx int, value uint8) {
	volatile.StoreUint8(&o.CC[idx].Reg, value)
}
func (o *TC_COUNT8_Type) GetCC(idx int) uint8 {
	return volatile.LoadUint8(&o.CC[idx].Reg)
}

// TC_COUNT8.PERBUF: COUNT8 Period Buffer
func (o *TC_COUNT8_Type) SetPERBUF(value uint8) {
	volatile.StoreUint8(&o.PERBUF.Reg, value)
}
func (o *TC_COUNT8_Type) GetPERBUF() uint8 {
	return volatile.LoadUint8(&o.PERBUF.Reg)
}

// TC_COUNT8.CCBUF: COUNT8 Compare and Capture Buffer
func (o *TC_COUNT8_Type) SetCCBUF(idx int, value uint8) {
	volatile.StoreUint8(&o.CCBUF[idx].Reg, value)
}
func (o *TC_COUNT8_Type) GetCCBUF(idx int) uint8 {
	return volatile.LoadUint8(&o.CCBUF[idx].Reg)
}

// Basic Timer Counter - COUNT16
type TC_COUNT16_Type struct {
	CTRLA    volatile.Register32 // 0x0
	CTRLBCLR volatile.Register8  // 0x4
	CTRLBSET volatile.Register8  // 0x5
	EVCTRL   volatile.Register16 // 0x6
	INTENCLR volatile.Register8  // 0x8
	INTENSET volatile.Register8  // 0x9
	INTFLAG  volatile.Register8  // 0xA
	STATUS   volatile.Register8  // 0xB
	WAVE     volatile.Register8  // 0xC
	DRVCTRL  volatile.Register8  // 0xD
	_        byte
	DBGCTRL  volatile.Register8  // 0xF
	SYNCBUSY volatile.Register32 // 0x10
	COUNT    volatile.Register16 // 0x14
	_        [4]byte
	PER      volatile.Register16    // 0x1A
	CC       [2]volatile.Register16 // 0x1C
	_        [14]byte
	PERBUF   volatile.Register16    // 0x2E
	CCBUF    [2]volatile.Register16 // 0x30
}

// TC_COUNT16.CTRLA: Control A
func (o *TC_COUNT16_Type) SetCTRLA_SWRST(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x1)|value)
}
func (o *TC_COUNT16_Type) GetCTRLA_SWRST() uint32 {
	return volatile.LoadUint32(&o.CTRLA.Reg) & 0x1
}
func (o *TC_COUNT16_Type) SetCTRLA_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x2)|value<<1)
}
func (o *TC_COUNT16_Type) GetCTRLA_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x2) >> 1
}
func (o *TC_COUNT16_Type) SetCTRLA_MODE(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0xc)|value<<2)
}
func (o *TC_COUNT16_Type) GetCTRLA_MODE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0xc) >> 2
}
func (o *TC_COUNT16_Type) SetCTRLA_PRESCSYNC(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x30)|value<<4)
}
func (o *TC_COUNT16_Type) GetCTRLA_PRESCSYNC() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x30) >> 4
}
func (o *TC_COUNT16_Type) SetCTRLA_RUNSTDBY(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x40)|value<<6)
}
func (o *TC_COUNT16_Type) GetCTRLA_RUNSTDBY() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x40) >> 6
}
func (o *TC_COUNT16_Type) SetCTRLA_ONDEMAND(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x80)|value<<7)
}
func (o *TC_COUNT16_Type) GetCTRLA_ONDEMAND() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x80) >> 7
}
func (o *TC_COUNT16_Type) SetCTRLA_PRESCALER(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x700)|value<<8)
}
func (o *TC_COUNT16_Type) GetCTRLA_PRESCALER() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x700) >> 8
}
func (o *TC_COUNT16_Type) SetCTRLA_ALOCK(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x800)|value<<11)
}
func (o *TC_COUNT16_Type) GetCTRLA_ALOCK() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x800) >> 11
}
func (o *TC_COUNT16_Type) SetCTRLA_CAPTEN0(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x10000)|value<<16)
}
func (o *TC_COUNT16_Type) GetCTRLA_CAPTEN0() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x10000) >> 16
}
func (o *TC_COUNT16_Type) SetCTRLA_CAPTEN1(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x20000)|value<<17)
}
func (o *TC_COUNT16_Type) GetCTRLA_CAPTEN1() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x20000) >> 17
}
func (o *TC_COUNT16_Type) SetCTRLA_COPEN0(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x100000)|value<<20)
}
func (o *TC_COUNT16_Type) GetCTRLA_COPEN0() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x100000) >> 20
}
func (o *TC_COUNT16_Type) SetCTRLA_COPEN1(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x200000)|value<<21)
}
func (o *TC_COUNT16_Type) GetCTRLA_COPEN1() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x200000) >> 21
}
func (o *TC_COUNT16_Type) SetCTRLA_CAPTMODE0(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x3000000)|value<<24)
}
func (o *TC_COUNT16_Type) GetCTRLA_CAPTMODE0() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x3000000) >> 24
}
func (o *TC_COUNT16_Type) SetCTRLA_CAPTMODE1(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x18000000)|value<<27)
}
func (o *TC_COUNT16_Type) GetCTRLA_CAPTMODE1() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x18000000) >> 27
}

// TC_COUNT16.CTRLBCLR: Control B Clear
func (o *TC_COUNT16_Type) SetCTRLBCLR_DIR(value uint8) {
	volatile.StoreUint8(&o.CTRLBCLR.Reg, volatile.LoadUint8(&o.CTRLBCLR.Reg)&^(0x1)|value)
}
func (o *TC_COUNT16_Type) GetCTRLBCLR_DIR() uint8 {
	return volatile.LoadUint8(&o.CTRLBCLR.Reg) & 0x1
}
func (o *TC_COUNT16_Type) SetCTRLBCLR_LUPD(value uint8) {
	volatile.StoreUint8(&o.CTRLBCLR.Reg, volatile.LoadUint8(&o.CTRLBCLR.Reg)&^(0x2)|value<<1)
}
func (o *TC_COUNT16_Type) GetCTRLBCLR_LUPD() uint8 {
	return (volatile.LoadUint8(&o.CTRLBCLR.Reg) & 0x2) >> 1
}
func (o *TC_COUNT16_Type) SetCTRLBCLR_ONESHOT(value uint8) {
	volatile.StoreUint8(&o.CTRLBCLR.Reg, volatile.LoadUint8(&o.CTRLBCLR.Reg)&^(0x4)|value<<2)
}
func (o *TC_COUNT16_Type) GetCTRLBCLR_ONESHOT() uint8 {
	return (volatile.LoadUint8(&o.CTRLBCLR.Reg) & 0x4) >> 2
}
func (o *TC_COUNT16_Type) SetCTRLBCLR_CMD(value uint8) {
	volatile.StoreUint8(&o.CTRLBCLR.Reg, volatile.LoadUint8(&o.CTRLBCLR.Reg)&^(0xe0)|value<<5)
}
func (o *TC_COUNT16_Type) GetCTRLBCLR_CMD() uint8 {
	return (volatile.LoadUint8(&o.CTRLBCLR.Reg) & 0xe0) >> 5
}

// TC_COUNT16.CTRLBSET: Control B Set
func (o *TC_COUNT16_Type) SetCTRLBSET_DIR(value uint8) {
	volatile.StoreUint8(&o.CTRLBSET.Reg, volatile.LoadUint8(&o.CTRLBSET.Reg)&^(0x1)|value)
}
func (o *TC_COUNT16_Type) GetCTRLBSET_DIR() uint8 {
	return volatile.LoadUint8(&o.CTRLBSET.Reg) & 0x1
}
func (o *TC_COUNT16_Type) SetCTRLBSET_LUPD(value uint8) {
	volatile.StoreUint8(&o.CTRLBSET.Reg, volatile.LoadUint8(&o.CTRLBSET.Reg)&^(0x2)|value<<1)
}
func (o *TC_COUNT16_Type) GetCTRLBSET_LUPD() uint8 {
	return (volatile.LoadUint8(&o.CTRLBSET.Reg) & 0x2) >> 1
}
func (o *TC_COUNT16_Type) SetCTRLBSET_ONESHOT(value uint8) {
	volatile.StoreUint8(&o.CTRLBSET.Reg, volatile.LoadUint8(&o.CTRLBSET.Reg)&^(0x4)|value<<2)
}
func (o *TC_COUNT16_Type) GetCTRLBSET_ONESHOT() uint8 {
	return (volatile.LoadUint8(&o.CTRLBSET.Reg) & 0x4) >> 2
}
func (o *TC_COUNT16_Type) SetCTRLBSET_CMD(value uint8) {
	volatile.StoreUint8(&o.CTRLBSET.Reg, volatile.LoadUint8(&o.CTRLBSET.Reg)&^(0xe0)|value<<5)
}
func (o *TC_COUNT16_Type) GetCTRLBSET_CMD() uint8 {
	return (volatile.LoadUint8(&o.CTRLBSET.Reg) & 0xe0) >> 5
}

// TC_COUNT16.EVCTRL: Event Control
func (o *TC_COUNT16_Type) SetEVCTRL_EVACT(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x7)|value)
}
func (o *TC_COUNT16_Type) GetEVCTRL_EVACT() uint16 {
	return volatile.LoadUint16(&o.EVCTRL.Reg) & 0x7
}
func (o *TC_COUNT16_Type) SetEVCTRL_TCINV(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x10)|value<<4)
}
func (o *TC_COUNT16_Type) GetEVCTRL_TCINV() uint16 {
	return (volatile.LoadUint16(&o.EVCTRL.Reg) & 0x10) >> 4
}
func (o *TC_COUNT16_Type) SetEVCTRL_TCEI(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x20)|value<<5)
}
func (o *TC_COUNT16_Type) GetEVCTRL_TCEI() uint16 {
	return (volatile.LoadUint16(&o.EVCTRL.Reg) & 0x20) >> 5
}
func (o *TC_COUNT16_Type) SetEVCTRL_OVFEO(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x100)|value<<8)
}
func (o *TC_COUNT16_Type) GetEVCTRL_OVFEO() uint16 {
	return (volatile.LoadUint16(&o.EVCTRL.Reg) & 0x100) >> 8
}
func (o *TC_COUNT16_Type) SetEVCTRL_MCEO0(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x1000)|value<<12)
}
func (o *TC_COUNT16_Type) GetEVCTRL_MCEO0() uint16 {
	return (volatile.LoadUint16(&o.EVCTRL.Reg) & 0x1000) >> 12
}
func (o *TC_COUNT16_Type) SetEVCTRL_MCEO1(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x2000)|value<<13)
}
func (o *TC_COUNT16_Type) GetEVCTRL_MCEO1() uint16 {
	return (volatile.LoadUint16(&o.EVCTRL.Reg) & 0x2000) >> 13
}

// TC_COUNT16.INTENCLR: Interrupt Enable Clear
func (o *TC_COUNT16_Type) SetINTENCLR_OVF(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *TC_COUNT16_Type) GetINTENCLR_OVF() uint8 {
	return volatile.LoadUint8(&o.INTENCLR.Reg) & 0x1
}
func (o *TC_COUNT16_Type) SetINTENCLR_ERR(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *TC_COUNT16_Type) GetINTENCLR_ERR() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *TC_COUNT16_Type) SetINTENCLR_MC0(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x10)|value<<4)
}
func (o *TC_COUNT16_Type) GetINTENCLR_MC0() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x10) >> 4
}
func (o *TC_COUNT16_Type) SetINTENCLR_MC1(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x20)|value<<5)
}
func (o *TC_COUNT16_Type) GetINTENCLR_MC1() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x20) >> 5
}

// TC_COUNT16.INTENSET: Interrupt Enable Set
func (o *TC_COUNT16_Type) SetINTENSET_OVF(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *TC_COUNT16_Type) GetINTENSET_OVF() uint8 {
	return volatile.LoadUint8(&o.INTENSET.Reg) & 0x1
}
func (o *TC_COUNT16_Type) SetINTENSET_ERR(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *TC_COUNT16_Type) GetINTENSET_ERR() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *TC_COUNT16_Type) SetINTENSET_MC0(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x10)|value<<4)
}
func (o *TC_COUNT16_Type) GetINTENSET_MC0() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x10) >> 4
}
func (o *TC_COUNT16_Type) SetINTENSET_MC1(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x20)|value<<5)
}
func (o *TC_COUNT16_Type) GetINTENSET_MC1() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x20) >> 5
}

// TC_COUNT16.INTFLAG: Interrupt Flag Status and Clear
func (o *TC_COUNT16_Type) SetINTFLAG_OVF(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x1)|value)
}
func (o *TC_COUNT16_Type) GetINTFLAG_OVF() uint8 {
	return volatile.LoadUint8(&o.INTFLAG.Reg) & 0x1
}
func (o *TC_COUNT16_Type) SetINTFLAG_ERR(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x2)|value<<1)
}
func (o *TC_COUNT16_Type) GetINTFLAG_ERR() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x2) >> 1
}
func (o *TC_COUNT16_Type) SetINTFLAG_MC0(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x10)|value<<4)
}
func (o *TC_COUNT16_Type) GetINTFLAG_MC0() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x10) >> 4
}
func (o *TC_COUNT16_Type) SetINTFLAG_MC1(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x20)|value<<5)
}
func (o *TC_COUNT16_Type) GetINTFLAG_MC1() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x20) >> 5
}

// TC_COUNT16.STATUS: Status
func (o *TC_COUNT16_Type) SetSTATUS_STOP(value uint8) {
	volatile.StoreUint8(&o.STATUS.Reg, volatile.LoadUint8(&o.STATUS.Reg)&^(0x1)|value)
}
func (o *TC_COUNT16_Type) GetSTATUS_STOP() uint8 {
	return volatile.LoadUint8(&o.STATUS.Reg) & 0x1
}
func (o *TC_COUNT16_Type) SetSTATUS_SLAVE(value uint8) {
	volatile.StoreUint8(&o.STATUS.Reg, volatile.LoadUint8(&o.STATUS.Reg)&^(0x2)|value<<1)
}
func (o *TC_COUNT16_Type) GetSTATUS_SLAVE() uint8 {
	return (volatile.LoadUint8(&o.STATUS.Reg) & 0x2) >> 1
}
func (o *TC_COUNT16_Type) SetSTATUS_PERBUFV(value uint8) {
	volatile.StoreUint8(&o.STATUS.Reg, volatile.LoadUint8(&o.STATUS.Reg)&^(0x8)|value<<3)
}
func (o *TC_COUNT16_Type) GetSTATUS_PERBUFV() uint8 {
	return (volatile.LoadUint8(&o.STATUS.Reg) & 0x8) >> 3
}
func (o *TC_COUNT16_Type) SetSTATUS_CCBUFV0(value uint8) {
	volatile.StoreUint8(&o.STATUS.Reg, volatile.LoadUint8(&o.STATUS.Reg)&^(0x10)|value<<4)
}
func (o *TC_COUNT16_Type) GetSTATUS_CCBUFV0() uint8 {
	return (volatile.LoadUint8(&o.STATUS.Reg) & 0x10) >> 4
}
func (o *TC_COUNT16_Type) SetSTATUS_CCBUFV1(value uint8) {
	volatile.StoreUint8(&o.STATUS.Reg, volatile.LoadUint8(&o.STATUS.Reg)&^(0x20)|value<<5)
}
func (o *TC_COUNT16_Type) GetSTATUS_CCBUFV1() uint8 {
	return (volatile.LoadUint8(&o.STATUS.Reg) & 0x20) >> 5
}

// TC_COUNT16.WAVE: Waveform Generation Control
func (o *TC_COUNT16_Type) SetWAVE_WAVEGEN(value uint8) {
	volatile.StoreUint8(&o.WAVE.Reg, volatile.LoadUint8(&o.WAVE.Reg)&^(0x3)|value)
}
func (o *TC_COUNT16_Type) GetWAVE_WAVEGEN() uint8 {
	return volatile.LoadUint8(&o.WAVE.Reg) & 0x3
}

// TC_COUNT16.DRVCTRL: Control C
func (o *TC_COUNT16_Type) SetDRVCTRL_INVEN0(value uint8) {
	volatile.StoreUint8(&o.DRVCTRL.Reg, volatile.LoadUint8(&o.DRVCTRL.Reg)&^(0x1)|value)
}
func (o *TC_COUNT16_Type) GetDRVCTRL_INVEN0() uint8 {
	return volatile.LoadUint8(&o.DRVCTRL.Reg) & 0x1
}
func (o *TC_COUNT16_Type) SetDRVCTRL_INVEN1(value uint8) {
	volatile.StoreUint8(&o.DRVCTRL.Reg, volatile.LoadUint8(&o.DRVCTRL.Reg)&^(0x2)|value<<1)
}
func (o *TC_COUNT16_Type) GetDRVCTRL_INVEN1() uint8 {
	return (volatile.LoadUint8(&o.DRVCTRL.Reg) & 0x2) >> 1
}

// TC_COUNT16.DBGCTRL: Debug Control
func (o *TC_COUNT16_Type) SetDBGCTRL_DBGRUN(value uint8) {
	volatile.StoreUint8(&o.DBGCTRL.Reg, volatile.LoadUint8(&o.DBGCTRL.Reg)&^(0x1)|value)
}
func (o *TC_COUNT16_Type) GetDBGCTRL_DBGRUN() uint8 {
	return volatile.LoadUint8(&o.DBGCTRL.Reg) & 0x1
}

// TC_COUNT16.SYNCBUSY: Synchronization Status
func (o *TC_COUNT16_Type) SetSYNCBUSY_SWRST(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x1)|value)
}
func (o *TC_COUNT16_Type) GetSYNCBUSY_SWRST() uint32 {
	return volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x1
}
func (o *TC_COUNT16_Type) SetSYNCBUSY_ENABLE(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x2)|value<<1)
}
func (o *TC_COUNT16_Type) GetSYNCBUSY_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x2) >> 1
}
func (o *TC_COUNT16_Type) SetSYNCBUSY_CTRLB(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x4)|value<<2)
}
func (o *TC_COUNT16_Type) GetSYNCBUSY_CTRLB() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x4) >> 2
}
func (o *TC_COUNT16_Type) SetSYNCBUSY_STATUS(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x8)|value<<3)
}
func (o *TC_COUNT16_Type) GetSYNCBUSY_STATUS() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x8) >> 3
}
func (o *TC_COUNT16_Type) SetSYNCBUSY_COUNT(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x10)|value<<4)
}
func (o *TC_COUNT16_Type) GetSYNCBUSY_COUNT() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x10) >> 4
}
func (o *TC_COUNT16_Type) SetSYNCBUSY_PER(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x20)|value<<5)
}
func (o *TC_COUNT16_Type) GetSYNCBUSY_PER() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x20) >> 5
}
func (o *TC_COUNT16_Type) SetSYNCBUSY_CC0(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x40)|value<<6)
}
func (o *TC_COUNT16_Type) GetSYNCBUSY_CC0() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x40) >> 6
}
func (o *TC_COUNT16_Type) SetSYNCBUSY_CC1(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x80)|value<<7)
}
func (o *TC_COUNT16_Type) GetSYNCBUSY_CC1() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x80) >> 7
}

// TC_COUNT16.COUNT: COUNT16 Count
func (o *TC_COUNT16_Type) SetCOUNT(value uint16) {
	volatile.StoreUint16(&o.COUNT.Reg, value)
}
func (o *TC_COUNT16_Type) GetCOUNT() uint16 {
	return volatile.LoadUint16(&o.COUNT.Reg)
}

// TC_COUNT16.PER: COUNT16 Period
func (o *TC_COUNT16_Type) SetPER(value uint16) {
	volatile.StoreUint16(&o.PER.Reg, value)
}
func (o *TC_COUNT16_Type) GetPER() uint16 {
	return volatile.LoadUint16(&o.PER.Reg)
}

// TC_COUNT16.CC: COUNT16 Compare and Capture
func (o *TC_COUNT16_Type) SetCC(idx int, value uint16) {
	volatile.StoreUint16(&o.CC[idx].Reg, value)
}
func (o *TC_COUNT16_Type) GetCC(idx int) uint16 {
	return volatile.LoadUint16(&o.CC[idx].Reg)
}

// TC_COUNT16.PERBUF: COUNT16 Period Buffer
func (o *TC_COUNT16_Type) SetPERBUF(value uint16) {
	volatile.StoreUint16(&o.PERBUF.Reg, value)
}
func (o *TC_COUNT16_Type) GetPERBUF() uint16 {
	return volatile.LoadUint16(&o.PERBUF.Reg)
}

// TC_COUNT16.CCBUF: COUNT16 Compare and Capture Buffer
func (o *TC_COUNT16_Type) SetCCBUF(idx int, value uint16) {
	volatile.StoreUint16(&o.CCBUF[idx].Reg, value)
}
func (o *TC_COUNT16_Type) GetCCBUF(idx int) uint16 {
	return volatile.LoadUint16(&o.CCBUF[idx].Reg)
}

// Basic Timer Counter - COUNT32
type TC_COUNT32_Type struct {
	CTRLA    volatile.Register32 // 0x0
	CTRLBCLR volatile.Register8  // 0x4
	CTRLBSET volatile.Register8  // 0x5
	EVCTRL   volatile.Register16 // 0x6
	INTENCLR volatile.Register8  // 0x8
	INTENSET volatile.Register8  // 0x9
	INTFLAG  volatile.Register8  // 0xA
	STATUS   volatile.Register8  // 0xB
	WAVE     volatile.Register8  // 0xC
	DRVCTRL  volatile.Register8  // 0xD
	_        byte
	DBGCTRL  volatile.Register8     // 0xF
	SYNCBUSY volatile.Register32    // 0x10
	COUNT    volatile.Register32    // 0x14
	PER      volatile.Register32    // 0x18
	CC       [2]volatile.Register32 // 0x1C
	_        [8]byte
	PERBUF   volatile.Register32    // 0x2C
	CCBUF    [2]volatile.Register32 // 0x30
}

// TC_COUNT32.CTRLA: Control A
func (o *TC_COUNT32_Type) SetCTRLA_SWRST(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x1)|value)
}
func (o *TC_COUNT32_Type) GetCTRLA_SWRST() uint32 {
	return volatile.LoadUint32(&o.CTRLA.Reg) & 0x1
}
func (o *TC_COUNT32_Type) SetCTRLA_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x2)|value<<1)
}
func (o *TC_COUNT32_Type) GetCTRLA_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x2) >> 1
}
func (o *TC_COUNT32_Type) SetCTRLA_MODE(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0xc)|value<<2)
}
func (o *TC_COUNT32_Type) GetCTRLA_MODE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0xc) >> 2
}
func (o *TC_COUNT32_Type) SetCTRLA_PRESCSYNC(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x30)|value<<4)
}
func (o *TC_COUNT32_Type) GetCTRLA_PRESCSYNC() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x30) >> 4
}
func (o *TC_COUNT32_Type) SetCTRLA_RUNSTDBY(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x40)|value<<6)
}
func (o *TC_COUNT32_Type) GetCTRLA_RUNSTDBY() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x40) >> 6
}
func (o *TC_COUNT32_Type) SetCTRLA_ONDEMAND(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x80)|value<<7)
}
func (o *TC_COUNT32_Type) GetCTRLA_ONDEMAND() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x80) >> 7
}
func (o *TC_COUNT32_Type) SetCTRLA_PRESCALER(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x700)|value<<8)
}
func (o *TC_COUNT32_Type) GetCTRLA_PRESCALER() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x700) >> 8
}
func (o *TC_COUNT32_Type) SetCTRLA_ALOCK(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x800)|value<<11)
}
func (o *TC_COUNT32_Type) GetCTRLA_ALOCK() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x800) >> 11
}
func (o *TC_COUNT32_Type) SetCTRLA_CAPTEN0(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x10000)|value<<16)
}
func (o *TC_COUNT32_Type) GetCTRLA_CAPTEN0() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x10000) >> 16
}
func (o *TC_COUNT32_Type) SetCTRLA_CAPTEN1(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x20000)|value<<17)
}
func (o *TC_COUNT32_Type) GetCTRLA_CAPTEN1() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x20000) >> 17
}
func (o *TC_COUNT32_Type) SetCTRLA_COPEN0(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x100000)|value<<20)
}
func (o *TC_COUNT32_Type) GetCTRLA_COPEN0() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x100000) >> 20
}
func (o *TC_COUNT32_Type) SetCTRLA_COPEN1(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x200000)|value<<21)
}
func (o *TC_COUNT32_Type) GetCTRLA_COPEN1() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x200000) >> 21
}
func (o *TC_COUNT32_Type) SetCTRLA_CAPTMODE0(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x3000000)|value<<24)
}
func (o *TC_COUNT32_Type) GetCTRLA_CAPTMODE0() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x3000000) >> 24
}
func (o *TC_COUNT32_Type) SetCTRLA_CAPTMODE1(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x18000000)|value<<27)
}
func (o *TC_COUNT32_Type) GetCTRLA_CAPTMODE1() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x18000000) >> 27
}

// TC_COUNT32.CTRLBCLR: Control B Clear
func (o *TC_COUNT32_Type) SetCTRLBCLR_DIR(value uint8) {
	volatile.StoreUint8(&o.CTRLBCLR.Reg, volatile.LoadUint8(&o.CTRLBCLR.Reg)&^(0x1)|value)
}
func (o *TC_COUNT32_Type) GetCTRLBCLR_DIR() uint8 {
	return volatile.LoadUint8(&o.CTRLBCLR.Reg) & 0x1
}
func (o *TC_COUNT32_Type) SetCTRLBCLR_LUPD(value uint8) {
	volatile.StoreUint8(&o.CTRLBCLR.Reg, volatile.LoadUint8(&o.CTRLBCLR.Reg)&^(0x2)|value<<1)
}
func (o *TC_COUNT32_Type) GetCTRLBCLR_LUPD() uint8 {
	return (volatile.LoadUint8(&o.CTRLBCLR.Reg) & 0x2) >> 1
}
func (o *TC_COUNT32_Type) SetCTRLBCLR_ONESHOT(value uint8) {
	volatile.StoreUint8(&o.CTRLBCLR.Reg, volatile.LoadUint8(&o.CTRLBCLR.Reg)&^(0x4)|value<<2)
}
func (o *TC_COUNT32_Type) GetCTRLBCLR_ONESHOT() uint8 {
	return (volatile.LoadUint8(&o.CTRLBCLR.Reg) & 0x4) >> 2
}
func (o *TC_COUNT32_Type) SetCTRLBCLR_CMD(value uint8) {
	volatile.StoreUint8(&o.CTRLBCLR.Reg, volatile.LoadUint8(&o.CTRLBCLR.Reg)&^(0xe0)|value<<5)
}
func (o *TC_COUNT32_Type) GetCTRLBCLR_CMD() uint8 {
	return (volatile.LoadUint8(&o.CTRLBCLR.Reg) & 0xe0) >> 5
}

// TC_COUNT32.CTRLBSET: Control B Set
func (o *TC_COUNT32_Type) SetCTRLBSET_DIR(value uint8) {
	volatile.StoreUint8(&o.CTRLBSET.Reg, volatile.LoadUint8(&o.CTRLBSET.Reg)&^(0x1)|value)
}
func (o *TC_COUNT32_Type) GetCTRLBSET_DIR() uint8 {
	return volatile.LoadUint8(&o.CTRLBSET.Reg) & 0x1
}
func (o *TC_COUNT32_Type) SetCTRLBSET_LUPD(value uint8) {
	volatile.StoreUint8(&o.CTRLBSET.Reg, volatile.LoadUint8(&o.CTRLBSET.Reg)&^(0x2)|value<<1)
}
func (o *TC_COUNT32_Type) GetCTRLBSET_LUPD() uint8 {
	return (volatile.LoadUint8(&o.CTRLBSET.Reg) & 0x2) >> 1
}
func (o *TC_COUNT32_Type) SetCTRLBSET_ONESHOT(value uint8) {
	volatile.StoreUint8(&o.CTRLBSET.Reg, volatile.LoadUint8(&o.CTRLBSET.Reg)&^(0x4)|value<<2)
}
func (o *TC_COUNT32_Type) GetCTRLBSET_ONESHOT() uint8 {
	return (volatile.LoadUint8(&o.CTRLBSET.Reg) & 0x4) >> 2
}
func (o *TC_COUNT32_Type) SetCTRLBSET_CMD(value uint8) {
	volatile.StoreUint8(&o.CTRLBSET.Reg, volatile.LoadUint8(&o.CTRLBSET.Reg)&^(0xe0)|value<<5)
}
func (o *TC_COUNT32_Type) GetCTRLBSET_CMD() uint8 {
	return (volatile.LoadUint8(&o.CTRLBSET.Reg) & 0xe0) >> 5
}

// TC_COUNT32.EVCTRL: Event Control
func (o *TC_COUNT32_Type) SetEVCTRL_EVACT(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x7)|value)
}
func (o *TC_COUNT32_Type) GetEVCTRL_EVACT() uint16 {
	return volatile.LoadUint16(&o.EVCTRL.Reg) & 0x7
}
func (o *TC_COUNT32_Type) SetEVCTRL_TCINV(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x10)|value<<4)
}
func (o *TC_COUNT32_Type) GetEVCTRL_TCINV() uint16 {
	return (volatile.LoadUint16(&o.EVCTRL.Reg) & 0x10) >> 4
}
func (o *TC_COUNT32_Type) SetEVCTRL_TCEI(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x20)|value<<5)
}
func (o *TC_COUNT32_Type) GetEVCTRL_TCEI() uint16 {
	return (volatile.LoadUint16(&o.EVCTRL.Reg) & 0x20) >> 5
}
func (o *TC_COUNT32_Type) SetEVCTRL_OVFEO(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x100)|value<<8)
}
func (o *TC_COUNT32_Type) GetEVCTRL_OVFEO() uint16 {
	return (volatile.LoadUint16(&o.EVCTRL.Reg) & 0x100) >> 8
}
func (o *TC_COUNT32_Type) SetEVCTRL_MCEO0(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x1000)|value<<12)
}
func (o *TC_COUNT32_Type) GetEVCTRL_MCEO0() uint16 {
	return (volatile.LoadUint16(&o.EVCTRL.Reg) & 0x1000) >> 12
}
func (o *TC_COUNT32_Type) SetEVCTRL_MCEO1(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x2000)|value<<13)
}
func (o *TC_COUNT32_Type) GetEVCTRL_MCEO1() uint16 {
	return (volatile.LoadUint16(&o.EVCTRL.Reg) & 0x2000) >> 13
}

// TC_COUNT32.INTENCLR: Interrupt Enable Clear
func (o *TC_COUNT32_Type) SetINTENCLR_OVF(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *TC_COUNT32_Type) GetINTENCLR_OVF() uint8 {
	return volatile.LoadUint8(&o.INTENCLR.Reg) & 0x1
}
func (o *TC_COUNT32_Type) SetINTENCLR_ERR(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *TC_COUNT32_Type) GetINTENCLR_ERR() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *TC_COUNT32_Type) SetINTENCLR_MC0(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x10)|value<<4)
}
func (o *TC_COUNT32_Type) GetINTENCLR_MC0() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x10) >> 4
}
func (o *TC_COUNT32_Type) SetINTENCLR_MC1(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x20)|value<<5)
}
func (o *TC_COUNT32_Type) GetINTENCLR_MC1() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x20) >> 5
}

// TC_COUNT32.INTENSET: Interrupt Enable Set
func (o *TC_COUNT32_Type) SetINTENSET_OVF(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *TC_COUNT32_Type) GetINTENSET_OVF() uint8 {
	return volatile.LoadUint8(&o.INTENSET.Reg) & 0x1
}
func (o *TC_COUNT32_Type) SetINTENSET_ERR(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *TC_COUNT32_Type) GetINTENSET_ERR() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *TC_COUNT32_Type) SetINTENSET_MC0(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x10)|value<<4)
}
func (o *TC_COUNT32_Type) GetINTENSET_MC0() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x10) >> 4
}
func (o *TC_COUNT32_Type) SetINTENSET_MC1(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x20)|value<<5)
}
func (o *TC_COUNT32_Type) GetINTENSET_MC1() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x20) >> 5
}

// TC_COUNT32.INTFLAG: Interrupt Flag Status and Clear
func (o *TC_COUNT32_Type) SetINTFLAG_OVF(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x1)|value)
}
func (o *TC_COUNT32_Type) GetINTFLAG_OVF() uint8 {
	return volatile.LoadUint8(&o.INTFLAG.Reg) & 0x1
}
func (o *TC_COUNT32_Type) SetINTFLAG_ERR(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x2)|value<<1)
}
func (o *TC_COUNT32_Type) GetINTFLAG_ERR() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x2) >> 1
}
func (o *TC_COUNT32_Type) SetINTFLAG_MC0(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x10)|value<<4)
}
func (o *TC_COUNT32_Type) GetINTFLAG_MC0() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x10) >> 4
}
func (o *TC_COUNT32_Type) SetINTFLAG_MC1(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x20)|value<<5)
}
func (o *TC_COUNT32_Type) GetINTFLAG_MC1() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x20) >> 5
}

// TC_COUNT32.STATUS: Status
func (o *TC_COUNT32_Type) SetSTATUS_STOP(value uint8) {
	volatile.StoreUint8(&o.STATUS.Reg, volatile.LoadUint8(&o.STATUS.Reg)&^(0x1)|value)
}
func (o *TC_COUNT32_Type) GetSTATUS_STOP() uint8 {
	return volatile.LoadUint8(&o.STATUS.Reg) & 0x1
}
func (o *TC_COUNT32_Type) SetSTATUS_SLAVE(value uint8) {
	volatile.StoreUint8(&o.STATUS.Reg, volatile.LoadUint8(&o.STATUS.Reg)&^(0x2)|value<<1)
}
func (o *TC_COUNT32_Type) GetSTATUS_SLAVE() uint8 {
	return (volatile.LoadUint8(&o.STATUS.Reg) & 0x2) >> 1
}
func (o *TC_COUNT32_Type) SetSTATUS_PERBUFV(value uint8) {
	volatile.StoreUint8(&o.STATUS.Reg, volatile.LoadUint8(&o.STATUS.Reg)&^(0x8)|value<<3)
}
func (o *TC_COUNT32_Type) GetSTATUS_PERBUFV() uint8 {
	return (volatile.LoadUint8(&o.STATUS.Reg) & 0x8) >> 3
}
func (o *TC_COUNT32_Type) SetSTATUS_CCBUFV0(value uint8) {
	volatile.StoreUint8(&o.STATUS.Reg, volatile.LoadUint8(&o.STATUS.Reg)&^(0x10)|value<<4)
}
func (o *TC_COUNT32_Type) GetSTATUS_CCBUFV0() uint8 {
	return (volatile.LoadUint8(&o.STATUS.Reg) & 0x10) >> 4
}
func (o *TC_COUNT32_Type) SetSTATUS_CCBUFV1(value uint8) {
	volatile.StoreUint8(&o.STATUS.Reg, volatile.LoadUint8(&o.STATUS.Reg)&^(0x20)|value<<5)
}
func (o *TC_COUNT32_Type) GetSTATUS_CCBUFV1() uint8 {
	return (volatile.LoadUint8(&o.STATUS.Reg) & 0x20) >> 5
}

// TC_COUNT32.WAVE: Waveform Generation Control
func (o *TC_COUNT32_Type) SetWAVE_WAVEGEN(value uint8) {
	volatile.StoreUint8(&o.WAVE.Reg, volatile.LoadUint8(&o.WAVE.Reg)&^(0x3)|value)
}
func (o *TC_COUNT32_Type) GetWAVE_WAVEGEN() uint8 {
	return volatile.LoadUint8(&o.WAVE.Reg) & 0x3
}

// TC_COUNT32.DRVCTRL: Control C
func (o *TC_COUNT32_Type) SetDRVCTRL_INVEN0(value uint8) {
	volatile.StoreUint8(&o.DRVCTRL.Reg, volatile.LoadUint8(&o.DRVCTRL.Reg)&^(0x1)|value)
}
func (o *TC_COUNT32_Type) GetDRVCTRL_INVEN0() uint8 {
	return volatile.LoadUint8(&o.DRVCTRL.Reg) & 0x1
}
func (o *TC_COUNT32_Type) SetDRVCTRL_INVEN1(value uint8) {
	volatile.StoreUint8(&o.DRVCTRL.Reg, volatile.LoadUint8(&o.DRVCTRL.Reg)&^(0x2)|value<<1)
}
func (o *TC_COUNT32_Type) GetDRVCTRL_INVEN1() uint8 {
	return (volatile.LoadUint8(&o.DRVCTRL.Reg) & 0x2) >> 1
}

// TC_COUNT32.DBGCTRL: Debug Control
func (o *TC_COUNT32_Type) SetDBGCTRL_DBGRUN(value uint8) {
	volatile.StoreUint8(&o.DBGCTRL.Reg, volatile.LoadUint8(&o.DBGCTRL.Reg)&^(0x1)|value)
}
func (o *TC_COUNT32_Type) GetDBGCTRL_DBGRUN() uint8 {
	return volatile.LoadUint8(&o.DBGCTRL.Reg) & 0x1
}

// TC_COUNT32.SYNCBUSY: Synchronization Status
func (o *TC_COUNT32_Type) SetSYNCBUSY_SWRST(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x1)|value)
}
func (o *TC_COUNT32_Type) GetSYNCBUSY_SWRST() uint32 {
	return volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x1
}
func (o *TC_COUNT32_Type) SetSYNCBUSY_ENABLE(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x2)|value<<1)
}
func (o *TC_COUNT32_Type) GetSYNCBUSY_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x2) >> 1
}
func (o *TC_COUNT32_Type) SetSYNCBUSY_CTRLB(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x4)|value<<2)
}
func (o *TC_COUNT32_Type) GetSYNCBUSY_CTRLB() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x4) >> 2
}
func (o *TC_COUNT32_Type) SetSYNCBUSY_STATUS(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x8)|value<<3)
}
func (o *TC_COUNT32_Type) GetSYNCBUSY_STATUS() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x8) >> 3
}
func (o *TC_COUNT32_Type) SetSYNCBUSY_COUNT(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x10)|value<<4)
}
func (o *TC_COUNT32_Type) GetSYNCBUSY_COUNT() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x10) >> 4
}
func (o *TC_COUNT32_Type) SetSYNCBUSY_PER(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x20)|value<<5)
}
func (o *TC_COUNT32_Type) GetSYNCBUSY_PER() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x20) >> 5
}
func (o *TC_COUNT32_Type) SetSYNCBUSY_CC0(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x40)|value<<6)
}
func (o *TC_COUNT32_Type) GetSYNCBUSY_CC0() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x40) >> 6
}
func (o *TC_COUNT32_Type) SetSYNCBUSY_CC1(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x80)|value<<7)
}
func (o *TC_COUNT32_Type) GetSYNCBUSY_CC1() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x80) >> 7
}

// TC_COUNT32.COUNT: COUNT32 Count
func (o *TC_COUNT32_Type) SetCOUNT(value uint32) {
	volatile.StoreUint32(&o.COUNT.Reg, value)
}
func (o *TC_COUNT32_Type) GetCOUNT() uint32 {
	return volatile.LoadUint32(&o.COUNT.Reg)
}

// TC_COUNT32.PER: COUNT32 Period
func (o *TC_COUNT32_Type) SetPER(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, value)
}
func (o *TC_COUNT32_Type) GetPER() uint32 {
	return volatile.LoadUint32(&o.PER.Reg)
}

// TC_COUNT32.CC: COUNT32 Compare and Capture
func (o *TC_COUNT32_Type) SetCC(idx int, value uint32) {
	volatile.StoreUint32(&o.CC[idx].Reg, value)
}
func (o *TC_COUNT32_Type) GetCC(idx int) uint32 {
	return volatile.LoadUint32(&o.CC[idx].Reg)
}

// TC_COUNT32.PERBUF: COUNT32 Period Buffer
func (o *TC_COUNT32_Type) SetPERBUF(value uint32) {
	volatile.StoreUint32(&o.PERBUF.Reg, value)
}
func (o *TC_COUNT32_Type) GetPERBUF() uint32 {
	return volatile.LoadUint32(&o.PERBUF.Reg)
}

// TC_COUNT32.CCBUF: COUNT32 Compare and Capture Buffer
func (o *TC_COUNT32_Type) SetCCBUF(idx int, value uint32) {
	volatile.StoreUint32(&o.CCBUF[idx].Reg, value)
}
func (o *TC_COUNT32_Type) GetCCBUF(idx int) uint32 {
	return volatile.LoadUint32(&o.CCBUF[idx].Reg)
}

// TrustRAM
type TRAM_Type struct {
	CTRLA    volatile.Register8 // 0x0
	_        [3]byte
	INTENCLR volatile.Register8  // 0x4
	INTENSET volatile.Register8  // 0x5
	INTFLAG  volatile.Register8  // 0x6
	STATUS   volatile.Register8  // 0x7
	SYNCBUSY volatile.Register32 // 0x8
	DSCC     volatile.Register32 // 0xC
	PERMW    volatile.Register8  // 0x10
	PERMR    volatile.Register8  // 0x11
	_        [238]byte
	RAM      [64]volatile.Register32 // 0x100
}

// TRAM.CTRLA: Control
func (o *TRAM_Type) SetCTRLA_SWRST(value uint8) {
	volatile.StoreUint8(&o.CTRLA.Reg, volatile.LoadUint8(&o.CTRLA.Reg)&^(0x1)|value)
}
func (o *TRAM_Type) GetCTRLA_SWRST() uint8 {
	return volatile.LoadUint8(&o.CTRLA.Reg) & 0x1
}
func (o *TRAM_Type) SetCTRLA_ENABLE(value uint8) {
	volatile.StoreUint8(&o.CTRLA.Reg, volatile.LoadUint8(&o.CTRLA.Reg)&^(0x2)|value<<1)
}
func (o *TRAM_Type) GetCTRLA_ENABLE() uint8 {
	return (volatile.LoadUint8(&o.CTRLA.Reg) & 0x2) >> 1
}
func (o *TRAM_Type) SetCTRLA_TAMPERS(value uint8) {
	volatile.StoreUint8(&o.CTRLA.Reg, volatile.LoadUint8(&o.CTRLA.Reg)&^(0x10)|value<<4)
}
func (o *TRAM_Type) GetCTRLA_TAMPERS() uint8 {
	return (volatile.LoadUint8(&o.CTRLA.Reg) & 0x10) >> 4
}
func (o *TRAM_Type) SetCTRLA_DRP(value uint8) {
	volatile.StoreUint8(&o.CTRLA.Reg, volatile.LoadUint8(&o.CTRLA.Reg)&^(0x40)|value<<6)
}
func (o *TRAM_Type) GetCTRLA_DRP() uint8 {
	return (volatile.LoadUint8(&o.CTRLA.Reg) & 0x40) >> 6
}
func (o *TRAM_Type) SetCTRLA_SILACC(value uint8) {
	volatile.StoreUint8(&o.CTRLA.Reg, volatile.LoadUint8(&o.CTRLA.Reg)&^(0x80)|value<<7)
}
func (o *TRAM_Type) GetCTRLA_SILACC() uint8 {
	return (volatile.LoadUint8(&o.CTRLA.Reg) & 0x80) >> 7
}

// TRAM.INTENCLR: Interrupt Enable Clear
func (o *TRAM_Type) SetINTENCLR_ERR(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *TRAM_Type) GetINTENCLR_ERR() uint8 {
	return volatile.LoadUint8(&o.INTENCLR.Reg) & 0x1
}
func (o *TRAM_Type) SetINTENCLR_DRP(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *TRAM_Type) GetINTENCLR_DRP() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x2) >> 1
}

// TRAM.INTENSET: Interrupt Enable Set
func (o *TRAM_Type) SetINTENSET_ERR(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *TRAM_Type) GetINTENSET_ERR() uint8 {
	return volatile.LoadUint8(&o.INTENSET.Reg) & 0x1
}
func (o *TRAM_Type) SetINTENSET_DRP(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *TRAM_Type) GetINTENSET_DRP() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x2) >> 1
}

// TRAM.INTFLAG: Interrupt Flag Status and Clear
func (o *TRAM_Type) SetINTFLAG_ERR(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x1)|value)
}
func (o *TRAM_Type) GetINTFLAG_ERR() uint8 {
	return volatile.LoadUint8(&o.INTFLAG.Reg) & 0x1
}
func (o *TRAM_Type) SetINTFLAG_DRP(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x2)|value<<1)
}
func (o *TRAM_Type) GetINTFLAG_DRP() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x2) >> 1
}

// TRAM.STATUS: Status
func (o *TRAM_Type) SetSTATUS_RAMINV(value uint8) {
	volatile.StoreUint8(&o.STATUS.Reg, volatile.LoadUint8(&o.STATUS.Reg)&^(0x1)|value)
}
func (o *TRAM_Type) GetSTATUS_RAMINV() uint8 {
	return volatile.LoadUint8(&o.STATUS.Reg) & 0x1
}
func (o *TRAM_Type) SetSTATUS_DRP(value uint8) {
	volatile.StoreUint8(&o.STATUS.Reg, volatile.LoadUint8(&o.STATUS.Reg)&^(0x2)|value<<1)
}
func (o *TRAM_Type) GetSTATUS_DRP() uint8 {
	return (volatile.LoadUint8(&o.STATUS.Reg) & 0x2) >> 1
}

// TRAM.SYNCBUSY: Synchronization Busy Status
func (o *TRAM_Type) SetSYNCBUSY_SWRST(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x1)|value)
}
func (o *TRAM_Type) GetSYNCBUSY_SWRST() uint32 {
	return volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x1
}
func (o *TRAM_Type) SetSYNCBUSY_ENABLE(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x2)|value<<1)
}
func (o *TRAM_Type) GetSYNCBUSY_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x2) >> 1
}

// TRAM.DSCC: Data Scramble Control
func (o *TRAM_Type) SetDSCC_DSCKEY(value uint32) {
	volatile.StoreUint32(&o.DSCC.Reg, volatile.LoadUint32(&o.DSCC.Reg)&^(0x3fffffff)|value)
}
func (o *TRAM_Type) GetDSCC_DSCKEY() uint32 {
	return volatile.LoadUint32(&o.DSCC.Reg) & 0x3fffffff
}
func (o *TRAM_Type) SetDSCC_DSCEN(value uint32) {
	volatile.StoreUint32(&o.DSCC.Reg, volatile.LoadUint32(&o.DSCC.Reg)&^(0x80000000)|value<<31)
}
func (o *TRAM_Type) GetDSCC_DSCEN() uint32 {
	return (volatile.LoadUint32(&o.DSCC.Reg) & 0x80000000) >> 31
}

// TRAM.PERMW: Permutation Write
func (o *TRAM_Type) SetPERMW_DATA(value uint8) {
	volatile.StoreUint8(&o.PERMW.Reg, volatile.LoadUint8(&o.PERMW.Reg)&^(0x7)|value)
}
func (o *TRAM_Type) GetPERMW_DATA() uint8 {
	return volatile.LoadUint8(&o.PERMW.Reg) & 0x7
}

// TRAM.PERMR: Permutation Read
func (o *TRAM_Type) SetPERMR_DATA(value uint8) {
	volatile.StoreUint8(&o.PERMR.Reg, volatile.LoadUint8(&o.PERMR.Reg)&^(0x7)|value)
}
func (o *TRAM_Type) GetPERMR_DATA() uint8 {
	return volatile.LoadUint8(&o.PERMR.Reg) & 0x7
}

// TRAM.RAM: TrustRAM
func (o *TRAM_Type) SetRAM(idx int, value uint32) {
	volatile.StoreUint32(&o.RAM[idx].Reg, value)
}
func (o *TRAM_Type) GetRAM(idx int) uint32 {
	return volatile.LoadUint32(&o.RAM[idx].Reg)
}

// True Random Generator
type TRNG_Type struct {
	CTRLA    volatile.Register8 // 0x0
	_        [3]byte
	EVCTRL   volatile.Register8 // 0x4
	_        [3]byte
	INTENCLR volatile.Register8 // 0x8
	INTENSET volatile.Register8 // 0x9
	INTFLAG  volatile.Register8 // 0xA
	_        [21]byte
	DATA     volatile.Register32 // 0x20
}

// TRNG.CTRLA: Control A
func (o *TRNG_Type) SetCTRLA_ENABLE(value uint8) {
	volatile.StoreUint8(&o.CTRLA.Reg, volatile.LoadUint8(&o.CTRLA.Reg)&^(0x2)|value<<1)
}
func (o *TRNG_Type) GetCTRLA_ENABLE() uint8 {
	return (volatile.LoadUint8(&o.CTRLA.Reg) & 0x2) >> 1
}
func (o *TRNG_Type) SetCTRLA_RUNSTDBY(value uint8) {
	volatile.StoreUint8(&o.CTRLA.Reg, volatile.LoadUint8(&o.CTRLA.Reg)&^(0x40)|value<<6)
}
func (o *TRNG_Type) GetCTRLA_RUNSTDBY() uint8 {
	return (volatile.LoadUint8(&o.CTRLA.Reg) & 0x40) >> 6
}

// TRNG.EVCTRL: Event Control
func (o *TRNG_Type) SetEVCTRL_DATARDYEO(value uint8) {
	volatile.StoreUint8(&o.EVCTRL.Reg, volatile.LoadUint8(&o.EVCTRL.Reg)&^(0x1)|value)
}
func (o *TRNG_Type) GetEVCTRL_DATARDYEO() uint8 {
	return volatile.LoadUint8(&o.EVCTRL.Reg) & 0x1
}

// TRNG.INTENCLR: Interrupt Enable Clear
func (o *TRNG_Type) SetINTENCLR_DATARDY(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *TRNG_Type) GetINTENCLR_DATARDY() uint8 {
	return volatile.LoadUint8(&o.INTENCLR.Reg) & 0x1
}

// TRNG.INTENSET: Interrupt Enable Set
func (o *TRNG_Type) SetINTENSET_DATARDY(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *TRNG_Type) GetINTENSET_DATARDY() uint8 {
	return volatile.LoadUint8(&o.INTENSET.Reg) & 0x1
}

// TRNG.INTFLAG: Interrupt Flag Status and Clear
func (o *TRNG_Type) SetINTFLAG_DATARDY(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x1)|value)
}
func (o *TRNG_Type) GetINTFLAG_DATARDY() uint8 {
	return volatile.LoadUint8(&o.INTFLAG.Reg) & 0x1
}

// TRNG.DATA: Output Data
func (o *TRNG_Type) SetDATA(value uint32) {
	volatile.StoreUint32(&o.DATA.Reg, value)
}
func (o *TRNG_Type) GetDATA() uint32 {
	return volatile.LoadUint32(&o.DATA.Reg)
}

// Watchdog Timer
type WDT_Type struct {
	CTRLA    volatile.Register8 // 0x0
	CONFIG   volatile.Register8 // 0x1
	EWCTRL   volatile.Register8 // 0x2
	_        byte
	INTENCLR volatile.Register8 // 0x4
	INTENSET volatile.Register8 // 0x5
	INTFLAG  volatile.Register8 // 0x6
	_        byte
	SYNCBUSY volatile.Register32 // 0x8
	CLEAR    volatile.Register8  // 0xC
}

// WDT.CTRLA: Control
func (o *WDT_Type) SetCTRLA_ENABLE(value uint8) {
	volatile.StoreUint8(&o.CTRLA.Reg, volatile.LoadUint8(&o.CTRLA.Reg)&^(0x2)|value<<1)
}
func (o *WDT_Type) GetCTRLA_ENABLE() uint8 {
	return (volatile.LoadUint8(&o.CTRLA.Reg) & 0x2) >> 1
}
func (o *WDT_Type) SetCTRLA_WEN(value uint8) {
	volatile.StoreUint8(&o.CTRLA.Reg, volatile.LoadUint8(&o.CTRLA.Reg)&^(0x4)|value<<2)
}
func (o *WDT_Type) GetCTRLA_WEN() uint8 {
	return (volatile.LoadUint8(&o.CTRLA.Reg) & 0x4) >> 2
}
func (o *WDT_Type) SetCTRLA_RUNSTDBY(value uint8) {
	volatile.StoreUint8(&o.CTRLA.Reg, volatile.LoadUint8(&o.CTRLA.Reg)&^(0x40)|value<<6)
}
func (o *WDT_Type) GetCTRLA_RUNSTDBY() uint8 {
	return (volatile.LoadUint8(&o.CTRLA.Reg) & 0x40) >> 6
}
func (o *WDT_Type) SetCTRLA_ALWAYSON(value uint8) {
	volatile.StoreUint8(&o.CTRLA.Reg, volatile.LoadUint8(&o.CTRLA.Reg)&^(0x80)|value<<7)
}
func (o *WDT_Type) GetCTRLA_ALWAYSON() uint8 {
	return (volatile.LoadUint8(&o.CTRLA.Reg) & 0x80) >> 7
}

// WDT.CONFIG: Configuration
func (o *WDT_Type) SetCONFIG_PER(value uint8) {
	volatile.StoreUint8(&o.CONFIG.Reg, volatile.LoadUint8(&o.CONFIG.Reg)&^(0xf)|value)
}
func (o *WDT_Type) GetCONFIG_PER() uint8 {
	return volatile.LoadUint8(&o.CONFIG.Reg) & 0xf
}
func (o *WDT_Type) SetCONFIG_WINDOW(value uint8) {
	volatile.StoreUint8(&o.CONFIG.Reg, volatile.LoadUint8(&o.CONFIG.Reg)&^(0xf0)|value<<4)
}
func (o *WDT_Type) GetCONFIG_WINDOW() uint8 {
	return (volatile.LoadUint8(&o.CONFIG.Reg) & 0xf0) >> 4
}

// WDT.EWCTRL: Early Warning Interrupt Control
func (o *WDT_Type) SetEWCTRL_EWOFFSET(value uint8) {
	volatile.StoreUint8(&o.EWCTRL.Reg, volatile.LoadUint8(&o.EWCTRL.Reg)&^(0xf)|value)
}
func (o *WDT_Type) GetEWCTRL_EWOFFSET() uint8 {
	return volatile.LoadUint8(&o.EWCTRL.Reg) & 0xf
}

// WDT.INTENCLR: Interrupt Enable Clear
func (o *WDT_Type) SetINTENCLR_EW(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *WDT_Type) GetINTENCLR_EW() uint8 {
	return volatile.LoadUint8(&o.INTENCLR.Reg) & 0x1
}

// WDT.INTENSET: Interrupt Enable Set
func (o *WDT_Type) SetINTENSET_EW(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *WDT_Type) GetINTENSET_EW() uint8 {
	return volatile.LoadUint8(&o.INTENSET.Reg) & 0x1
}

// WDT.INTFLAG: Interrupt Flag Status and Clear
func (o *WDT_Type) SetINTFLAG_EW(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x1)|value)
}
func (o *WDT_Type) GetINTFLAG_EW() uint8 {
	return volatile.LoadUint8(&o.INTFLAG.Reg) & 0x1
}

// WDT.SYNCBUSY: Synchronization Busy
func (o *WDT_Type) SetSYNCBUSY_ENABLE(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x2)|value<<1)
}
func (o *WDT_Type) GetSYNCBUSY_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x2) >> 1
}
func (o *WDT_Type) SetSYNCBUSY_WEN(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x4)|value<<2)
}
func (o *WDT_Type) GetSYNCBUSY_WEN() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x4) >> 2
}
func (o *WDT_Type) SetSYNCBUSY_RUNSTDBY(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x8)|value<<3)
}
func (o *WDT_Type) GetSYNCBUSY_RUNSTDBY() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x8) >> 3
}
func (o *WDT_Type) SetSYNCBUSY_ALWAYSON(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x10)|value<<4)
}
func (o *WDT_Type) GetSYNCBUSY_ALWAYSON() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x10) >> 4
}
func (o *WDT_Type) SetSYNCBUSY_CLEAR(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x20)|value<<5)
}
func (o *WDT_Type) GetSYNCBUSY_CLEAR() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x20) >> 5
}

// WDT.CLEAR: Clear
func (o *WDT_Type) SetCLEAR(value uint8) {
	volatile.StoreUint8(&o.CLEAR.Reg, value)
}
func (o *WDT_Type) GetCLEAR() uint8 {
	return volatile.LoadUint8(&o.CLEAR.Reg)
}

// Debug Control Block
type CoreDebug_Type struct {
	DHCSR     volatile.Register32 // 0x0
	DCRSR     volatile.Register32 // 0x4
	_         [4]byte
	DEMCR     volatile.Register32 // 0xC
	_         [4]byte
	DAUTHCTRL volatile.Register32 // 0x14
	DSCSR     volatile.Register32 // 0x18
}

// CoreDebug.DHCSR: Debug Halting Control and Status Register
func (o *CoreDebug_Type) SetDHCSR_C_DEBUGEN(value uint32) {
	volatile.StoreUint32(&o.DHCSR.Reg, volatile.LoadUint32(&o.DHCSR.Reg)&^(0x1)|value)
}
func (o *CoreDebug_Type) GetDHCSR_C_DEBUGEN() uint32 {
	return volatile.LoadUint32(&o.DHCSR.Reg) & 0x1
}
func (o *CoreDebug_Type) SetDHCSR_C_HALT(value uint32) {
	volatile.StoreUint32(&o.DHCSR.Reg, volatile.LoadUint32(&o.DHCSR.Reg)&^(0x2)|value<<1)
}
func (o *CoreDebug_Type) GetDHCSR_C_HALT() uint32 {
	return (volatile.LoadUint32(&o.DHCSR.Reg) & 0x2) >> 1
}
func (o *CoreDebug_Type) SetDHCSR_C_STEP(value uint32) {
	volatile.StoreUint32(&o.DHCSR.Reg, volatile.LoadUint32(&o.DHCSR.Reg)&^(0x4)|value<<2)
}
func (o *CoreDebug_Type) GetDHCSR_C_STEP() uint32 {
	return (volatile.LoadUint32(&o.DHCSR.Reg) & 0x4) >> 2
}
func (o *CoreDebug_Type) SetDHCSR_C_MASKINTS(value uint32) {
	volatile.StoreUint32(&o.DHCSR.Reg, volatile.LoadUint32(&o.DHCSR.Reg)&^(0x8)|value<<3)
}
func (o *CoreDebug_Type) GetDHCSR_C_MASKINTS() uint32 {
	return (volatile.LoadUint32(&o.DHCSR.Reg) & 0x8) >> 3
}
func (o *CoreDebug_Type) SetDHCSR_S_SNAPSTALL(value uint32) {
	volatile.StoreUint32(&o.DHCSR.Reg, volatile.LoadUint32(&o.DHCSR.Reg)&^(0x20)|value<<5)
}
func (o *CoreDebug_Type) GetDHCSR_S_SNAPSTALL() uint32 {
	return (volatile.LoadUint32(&o.DHCSR.Reg) & 0x20) >> 5
}
func (o *CoreDebug_Type) SetDHCSR_S_REGRDY(value uint32) {
	volatile.StoreUint32(&o.DHCSR.Reg, volatile.LoadUint32(&o.DHCSR.Reg)&^(0x10000)|value<<16)
}
func (o *CoreDebug_Type) GetDHCSR_S_REGRDY() uint32 {
	return (volatile.LoadUint32(&o.DHCSR.Reg) & 0x10000) >> 16
}
func (o *CoreDebug_Type) SetDHCSR_S_HALT(value uint32) {
	volatile.StoreUint32(&o.DHCSR.Reg, volatile.LoadUint32(&o.DHCSR.Reg)&^(0x20000)|value<<17)
}
func (o *CoreDebug_Type) GetDHCSR_S_HALT() uint32 {
	return (volatile.LoadUint32(&o.DHCSR.Reg) & 0x20000) >> 17
}
func (o *CoreDebug_Type) SetDHCSR_S_SLEEP(value uint32) {
	volatile.StoreUint32(&o.DHCSR.Reg, volatile.LoadUint32(&o.DHCSR.Reg)&^(0x40000)|value<<18)
}
func (o *CoreDebug_Type) GetDHCSR_S_SLEEP() uint32 {
	return (volatile.LoadUint32(&o.DHCSR.Reg) & 0x40000) >> 18
}
func (o *CoreDebug_Type) SetDHCSR_S_LOCKUP(value uint32) {
	volatile.StoreUint32(&o.DHCSR.Reg, volatile.LoadUint32(&o.DHCSR.Reg)&^(0x80000)|value<<19)
}
func (o *CoreDebug_Type) GetDHCSR_S_LOCKUP() uint32 {
	return (volatile.LoadUint32(&o.DHCSR.Reg) & 0x80000) >> 19
}
func (o *CoreDebug_Type) SetDHCSR_S_SDE(value uint32) {
	volatile.StoreUint32(&o.DHCSR.Reg, volatile.LoadUint32(&o.DHCSR.Reg)&^(0x100000)|value<<20)
}
func (o *CoreDebug_Type) GetDHCSR_S_SDE() uint32 {
	return (volatile.LoadUint32(&o.DHCSR.Reg) & 0x100000) >> 20
}
func (o *CoreDebug_Type) SetDHCSR_S_RETIRE_ST(value uint32) {
	volatile.StoreUint32(&o.DHCSR.Reg, volatile.LoadUint32(&o.DHCSR.Reg)&^(0x1000000)|value<<24)
}
func (o *CoreDebug_Type) GetDHCSR_S_RETIRE_ST() uint32 {
	return (volatile.LoadUint32(&o.DHCSR.Reg) & 0x1000000) >> 24
}
func (o *CoreDebug_Type) SetDHCSR_S_RESET_ST(value uint32) {
	volatile.StoreUint32(&o.DHCSR.Reg, volatile.LoadUint32(&o.DHCSR.Reg)&^(0x2000000)|value<<25)
}
func (o *CoreDebug_Type) GetDHCSR_S_RESET_ST() uint32 {
	return (volatile.LoadUint32(&o.DHCSR.Reg) & 0x2000000) >> 25
}
func (o *CoreDebug_Type) SetDHCSR_S_RESTART_ST(value uint32) {
	volatile.StoreUint32(&o.DHCSR.Reg, volatile.LoadUint32(&o.DHCSR.Reg)&^(0x4000000)|value<<26)
}
func (o *CoreDebug_Type) GetDHCSR_S_RESTART_ST() uint32 {
	return (volatile.LoadUint32(&o.DHCSR.Reg) & 0x4000000) >> 26
}

// CoreDebug.DCRSR: Debug Core Register Select Register
func (o *CoreDebug_Type) SetDCRSR_REGSEL(value uint32) {
	volatile.StoreUint32(&o.DCRSR.Reg, volatile.LoadUint32(&o.DCRSR.Reg)&^(0x7f)|value)
}
func (o *CoreDebug_Type) GetDCRSR_REGSEL() uint32 {
	return volatile.LoadUint32(&o.DCRSR.Reg) & 0x7f
}
func (o *CoreDebug_Type) SetDCRSR_REGWnR(value uint32) {
	volatile.StoreUint32(&o.DCRSR.Reg, volatile.LoadUint32(&o.DCRSR.Reg)&^(0x10000)|value<<16)
}
func (o *CoreDebug_Type) GetDCRSR_REGWnR() uint32 {
	return (volatile.LoadUint32(&o.DCRSR.Reg) & 0x10000) >> 16
}

// CoreDebug.DEMCR: Debug Exception and Monitor Control Register
func (o *CoreDebug_Type) SetDEMCR_VC_CORERESET(value uint32) {
	volatile.StoreUint32(&o.DEMCR.Reg, volatile.LoadUint32(&o.DEMCR.Reg)&^(0x1)|value)
}
func (o *CoreDebug_Type) GetDEMCR_VC_CORERESET() uint32 {
	return volatile.LoadUint32(&o.DEMCR.Reg) & 0x1
}
func (o *CoreDebug_Type) SetDEMCR_VC_MMERR(value uint32) {
	volatile.StoreUint32(&o.DEMCR.Reg, volatile.LoadUint32(&o.DEMCR.Reg)&^(0x10)|value<<4)
}
func (o *CoreDebug_Type) GetDEMCR_VC_MMERR() uint32 {
	return (volatile.LoadUint32(&o.DEMCR.Reg) & 0x10) >> 4
}
func (o *CoreDebug_Type) SetDEMCR_VC_NOCPERR(value uint32) {
	volatile.StoreUint32(&o.DEMCR.Reg, volatile.LoadUint32(&o.DEMCR.Reg)&^(0x20)|value<<5)
}
func (o *CoreDebug_Type) GetDEMCR_VC_NOCPERR() uint32 {
	return (volatile.LoadUint32(&o.DEMCR.Reg) & 0x20) >> 5
}
func (o *CoreDebug_Type) SetDEMCR_VC_CHKERR(value uint32) {
	volatile.StoreUint32(&o.DEMCR.Reg, volatile.LoadUint32(&o.DEMCR.Reg)&^(0x40)|value<<6)
}
func (o *CoreDebug_Type) GetDEMCR_VC_CHKERR() uint32 {
	return (volatile.LoadUint32(&o.DEMCR.Reg) & 0x40) >> 6
}
func (o *CoreDebug_Type) SetDEMCR_VC_STATERR(value uint32) {
	volatile.StoreUint32(&o.DEMCR.Reg, volatile.LoadUint32(&o.DEMCR.Reg)&^(0x80)|value<<7)
}
func (o *CoreDebug_Type) GetDEMCR_VC_STATERR() uint32 {
	return (volatile.LoadUint32(&o.DEMCR.Reg) & 0x80) >> 7
}
func (o *CoreDebug_Type) SetDEMCR_VC_BUSERR(value uint32) {
	volatile.StoreUint32(&o.DEMCR.Reg, volatile.LoadUint32(&o.DEMCR.Reg)&^(0x100)|value<<8)
}
func (o *CoreDebug_Type) GetDEMCR_VC_BUSERR() uint32 {
	return (volatile.LoadUint32(&o.DEMCR.Reg) & 0x100) >> 8
}
func (o *CoreDebug_Type) SetDEMCR_VC_INTERR(value uint32) {
	volatile.StoreUint32(&o.DEMCR.Reg, volatile.LoadUint32(&o.DEMCR.Reg)&^(0x200)|value<<9)
}
func (o *CoreDebug_Type) GetDEMCR_VC_INTERR() uint32 {
	return (volatile.LoadUint32(&o.DEMCR.Reg) & 0x200) >> 9
}
func (o *CoreDebug_Type) SetDEMCR_VC_HARDERR(value uint32) {
	volatile.StoreUint32(&o.DEMCR.Reg, volatile.LoadUint32(&o.DEMCR.Reg)&^(0x400)|value<<10)
}
func (o *CoreDebug_Type) GetDEMCR_VC_HARDERR() uint32 {
	return (volatile.LoadUint32(&o.DEMCR.Reg) & 0x400) >> 10
}
func (o *CoreDebug_Type) SetDEMCR_VC_SFERR(value uint32) {
	volatile.StoreUint32(&o.DEMCR.Reg, volatile.LoadUint32(&o.DEMCR.Reg)&^(0x800)|value<<11)
}
func (o *CoreDebug_Type) GetDEMCR_VC_SFERR() uint32 {
	return (volatile.LoadUint32(&o.DEMCR.Reg) & 0x800) >> 11
}
func (o *CoreDebug_Type) SetDEMCR_MON_EN(value uint32) {
	volatile.StoreUint32(&o.DEMCR.Reg, volatile.LoadUint32(&o.DEMCR.Reg)&^(0x10000)|value<<16)
}
func (o *CoreDebug_Type) GetDEMCR_MON_EN() uint32 {
	return (volatile.LoadUint32(&o.DEMCR.Reg) & 0x10000) >> 16
}
func (o *CoreDebug_Type) SetDEMCR_MON_PEND(value uint32) {
	volatile.StoreUint32(&o.DEMCR.Reg, volatile.LoadUint32(&o.DEMCR.Reg)&^(0x20000)|value<<17)
}
func (o *CoreDebug_Type) GetDEMCR_MON_PEND() uint32 {
	return (volatile.LoadUint32(&o.DEMCR.Reg) & 0x20000) >> 17
}
func (o *CoreDebug_Type) SetDEMCR_MON_STEP(value uint32) {
	volatile.StoreUint32(&o.DEMCR.Reg, volatile.LoadUint32(&o.DEMCR.Reg)&^(0x40000)|value<<18)
}
func (o *CoreDebug_Type) GetDEMCR_MON_STEP() uint32 {
	return (volatile.LoadUint32(&o.DEMCR.Reg) & 0x40000) >> 18
}
func (o *CoreDebug_Type) SetDEMCR_MON_REQ(value uint32) {
	volatile.StoreUint32(&o.DEMCR.Reg, volatile.LoadUint32(&o.DEMCR.Reg)&^(0x80000)|value<<19)
}
func (o *CoreDebug_Type) GetDEMCR_MON_REQ() uint32 {
	return (volatile.LoadUint32(&o.DEMCR.Reg) & 0x80000) >> 19
}
func (o *CoreDebug_Type) SetDEMCR_SDME(value uint32) {
	volatile.StoreUint32(&o.DEMCR.Reg, volatile.LoadUint32(&o.DEMCR.Reg)&^(0x100000)|value<<20)
}
func (o *CoreDebug_Type) GetDEMCR_SDME() uint32 {
	return (volatile.LoadUint32(&o.DEMCR.Reg) & 0x100000) >> 20
}
func (o *CoreDebug_Type) SetDEMCR_TRCENA(value uint32) {
	volatile.StoreUint32(&o.DEMCR.Reg, volatile.LoadUint32(&o.DEMCR.Reg)&^(0x1000000)|value<<24)
}
func (o *CoreDebug_Type) GetDEMCR_TRCENA() uint32 {
	return (volatile.LoadUint32(&o.DEMCR.Reg) & 0x1000000) >> 24
}

// CoreDebug.DAUTHCTRL: Debug Authentication Control Register
func (o *CoreDebug_Type) SetDAUTHCTRL_SPIDENSEL(value uint32) {
	volatile.StoreUint32(&o.DAUTHCTRL.Reg, volatile.LoadUint32(&o.DAUTHCTRL.Reg)&^(0x1)|value)
}
func (o *CoreDebug_Type) GetDAUTHCTRL_SPIDENSEL() uint32 {
	return volatile.LoadUint32(&o.DAUTHCTRL.Reg) & 0x1
}
func (o *CoreDebug_Type) SetDAUTHCTRL_INTSPIDEN(value uint32) {
	volatile.StoreUint32(&o.DAUTHCTRL.Reg, volatile.LoadUint32(&o.DAUTHCTRL.Reg)&^(0x2)|value<<1)
}
func (o *CoreDebug_Type) GetDAUTHCTRL_INTSPIDEN() uint32 {
	return (volatile.LoadUint32(&o.DAUTHCTRL.Reg) & 0x2) >> 1
}
func (o *CoreDebug_Type) SetDAUTHCTRL_SPNIDENSEL(value uint32) {
	volatile.StoreUint32(&o.DAUTHCTRL.Reg, volatile.LoadUint32(&o.DAUTHCTRL.Reg)&^(0x4)|value<<2)
}
func (o *CoreDebug_Type) GetDAUTHCTRL_SPNIDENSEL() uint32 {
	return (volatile.LoadUint32(&o.DAUTHCTRL.Reg) & 0x4) >> 2
}
func (o *CoreDebug_Type) SetDAUTHCTRL_INTSPNIDEN(value uint32) {
	volatile.StoreUint32(&o.DAUTHCTRL.Reg, volatile.LoadUint32(&o.DAUTHCTRL.Reg)&^(0x8)|value<<3)
}
func (o *CoreDebug_Type) GetDAUTHCTRL_INTSPNIDEN() uint32 {
	return (volatile.LoadUint32(&o.DAUTHCTRL.Reg) & 0x8) >> 3
}

// CoreDebug.DSCSR: Debug Security Control and Status Register
func (o *CoreDebug_Type) SetDSCSR_SBRSELEN(value uint32) {
	volatile.StoreUint32(&o.DSCSR.Reg, volatile.LoadUint32(&o.DSCSR.Reg)&^(0x1)|value)
}
func (o *CoreDebug_Type) GetDSCSR_SBRSELEN() uint32 {
	return volatile.LoadUint32(&o.DSCSR.Reg) & 0x1
}
func (o *CoreDebug_Type) SetDSCSR_SBRSEL(value uint32) {
	volatile.StoreUint32(&o.DSCSR.Reg, volatile.LoadUint32(&o.DSCSR.Reg)&^(0x2)|value<<1)
}
func (o *CoreDebug_Type) GetDSCSR_SBRSEL() uint32 {
	return (volatile.LoadUint32(&o.DSCSR.Reg) & 0x2) >> 1
}
func (o *CoreDebug_Type) SetDSCSR_CDS(value uint32) {
	volatile.StoreUint32(&o.DSCSR.Reg, volatile.LoadUint32(&o.DSCSR.Reg)&^(0x10000)|value<<16)
}
func (o *CoreDebug_Type) GetDSCSR_CDS() uint32 {
	return (volatile.LoadUint32(&o.DSCSR.Reg) & 0x10000) >> 16
}
func (o *CoreDebug_Type) SetDSCSR_CDSKEY(value uint32) {
	volatile.StoreUint32(&o.DSCSR.Reg, volatile.LoadUint32(&o.DSCSR.Reg)&^(0x20000)|value<<17)
}
func (o *CoreDebug_Type) GetDSCSR_CDSKEY() uint32 {
	return (volatile.LoadUint32(&o.DSCSR.Reg) & 0x20000) >> 17
}

// Debug Identification Block
type DIB_Type struct {
	DLAR        volatile.Register32 // 0x0
	DLSR        volatile.Register32 // 0x4
	DAUTHSTATUS volatile.Register32 // 0x8
	DDEVARCH    volatile.Register32 // 0xC
	_           [12]byte
	DDEVTYPE    volatile.Register32 // 0x1C
	DPIDR4      volatile.Register32 // 0x20
	DPIDR5      volatile.Register32 // 0x24
	DPIDR6      volatile.Register32 // 0x28
	DPIDR7      volatile.Register32 // 0x2C
	DPIDR0      volatile.Register32 // 0x30
	DPIDR1      volatile.Register32 // 0x34
	DPIDR2      volatile.Register32 // 0x38
	DPIDR3      volatile.Register32 // 0x3C
	DCIDR0      volatile.Register32 // 0x40
	DCIDR1      volatile.Register32 // 0x44
	DCIDR2      volatile.Register32 // 0x48
	DCIDR3      volatile.Register32 // 0x4C
}

// DIB.DLAR: SCS Software Lock Access Register
func (o *DIB_Type) SetDLAR(value uint32) {
	volatile.StoreUint32(&o.DLAR.Reg, value)
}
func (o *DIB_Type) GetDLAR() uint32 {
	return volatile.LoadUint32(&o.DLAR.Reg)
}

// DIB.DLSR: SCS Software Lock Status Register
func (o *DIB_Type) SetDLSR_SLI(value uint32) {
	volatile.StoreUint32(&o.DLSR.Reg, volatile.LoadUint32(&o.DLSR.Reg)&^(0x1)|value)
}
func (o *DIB_Type) GetDLSR_SLI() uint32 {
	return volatile.LoadUint32(&o.DLSR.Reg) & 0x1
}
func (o *DIB_Type) SetDLSR_SLK(value uint32) {
	volatile.StoreUint32(&o.DLSR.Reg, volatile.LoadUint32(&o.DLSR.Reg)&^(0x2)|value<<1)
}
func (o *DIB_Type) GetDLSR_SLK() uint32 {
	return (volatile.LoadUint32(&o.DLSR.Reg) & 0x2) >> 1
}
func (o *DIB_Type) SetDLSR_NTT(value uint32) {
	volatile.StoreUint32(&o.DLSR.Reg, volatile.LoadUint32(&o.DLSR.Reg)&^(0x4)|value<<2)
}
func (o *DIB_Type) GetDLSR_NTT() uint32 {
	return (volatile.LoadUint32(&o.DLSR.Reg) & 0x4) >> 2
}

// DIB.DAUTHSTATUS: Debug Authentication Status Register
func (o *DIB_Type) SetDAUTHSTATUS_NSID(value uint32) {
	volatile.StoreUint32(&o.DAUTHSTATUS.Reg, volatile.LoadUint32(&o.DAUTHSTATUS.Reg)&^(0x1)|value)
}
func (o *DIB_Type) GetDAUTHSTATUS_NSID() uint32 {
	return volatile.LoadUint32(&o.DAUTHSTATUS.Reg) & 0x1
}
func (o *DIB_Type) SetDAUTHSTATUS_NSNID(value uint32) {
	volatile.StoreUint32(&o.DAUTHSTATUS.Reg, volatile.LoadUint32(&o.DAUTHSTATUS.Reg)&^(0x4)|value<<2)
}
func (o *DIB_Type) GetDAUTHSTATUS_NSNID() uint32 {
	return (volatile.LoadUint32(&o.DAUTHSTATUS.Reg) & 0x4) >> 2
}
func (o *DIB_Type) SetDAUTHSTATUS_SID(value uint32) {
	volatile.StoreUint32(&o.DAUTHSTATUS.Reg, volatile.LoadUint32(&o.DAUTHSTATUS.Reg)&^(0x30)|value<<4)
}
func (o *DIB_Type) GetDAUTHSTATUS_SID() uint32 {
	return (volatile.LoadUint32(&o.DAUTHSTATUS.Reg) & 0x30) >> 4
}
func (o *DIB_Type) SetDAUTHSTATUS_SNID(value uint32) {
	volatile.StoreUint32(&o.DAUTHSTATUS.Reg, volatile.LoadUint32(&o.DAUTHSTATUS.Reg)&^(0xc0)|value<<6)
}
func (o *DIB_Type) GetDAUTHSTATUS_SNID() uint32 {
	return (volatile.LoadUint32(&o.DAUTHSTATUS.Reg) & 0xc0) >> 6
}

// DIB.DDEVARCH: SCS Device Architecture Register
func (o *DIB_Type) SetDDEVARCH_ARCHPART(value uint32) {
	volatile.StoreUint32(&o.DDEVARCH.Reg, volatile.LoadUint32(&o.DDEVARCH.Reg)&^(0xfff)|value)
}
func (o *DIB_Type) GetDDEVARCH_ARCHPART() uint32 {
	return volatile.LoadUint32(&o.DDEVARCH.Reg) & 0xfff
}
func (o *DIB_Type) SetDDEVARCH_ARCHVER(value uint32) {
	volatile.StoreUint32(&o.DDEVARCH.Reg, volatile.LoadUint32(&o.DDEVARCH.Reg)&^(0xf000)|value<<12)
}
func (o *DIB_Type) GetDDEVARCH_ARCHVER() uint32 {
	return (volatile.LoadUint32(&o.DDEVARCH.Reg) & 0xf000) >> 12
}
func (o *DIB_Type) SetDDEVARCH_REVISION(value uint32) {
	volatile.StoreUint32(&o.DDEVARCH.Reg, volatile.LoadUint32(&o.DDEVARCH.Reg)&^(0xf0000)|value<<16)
}
func (o *DIB_Type) GetDDEVARCH_REVISION() uint32 {
	return (volatile.LoadUint32(&o.DDEVARCH.Reg) & 0xf0000) >> 16
}
func (o *DIB_Type) SetDDEVARCH_PRESENT(value uint32) {
	volatile.StoreUint32(&o.DDEVARCH.Reg, volatile.LoadUint32(&o.DDEVARCH.Reg)&^(0x100000)|value<<20)
}
func (o *DIB_Type) GetDDEVARCH_PRESENT() uint32 {
	return (volatile.LoadUint32(&o.DDEVARCH.Reg) & 0x100000) >> 20
}
func (o *DIB_Type) SetDDEVARCH_ARCHITECT(value uint32) {
	volatile.StoreUint32(&o.DDEVARCH.Reg, volatile.LoadUint32(&o.DDEVARCH.Reg)&^(0xffe00000)|value<<21)
}
func (o *DIB_Type) GetDDEVARCH_ARCHITECT() uint32 {
	return (volatile.LoadUint32(&o.DDEVARCH.Reg) & 0xffe00000) >> 21
}

// DIB.DDEVTYPE: SCS Device Type Register
func (o *DIB_Type) SetDDEVTYPE_MAJOR(value uint32) {
	volatile.StoreUint32(&o.DDEVTYPE.Reg, volatile.LoadUint32(&o.DDEVTYPE.Reg)&^(0xf)|value)
}
func (o *DIB_Type) GetDDEVTYPE_MAJOR() uint32 {
	return volatile.LoadUint32(&o.DDEVTYPE.Reg) & 0xf
}
func (o *DIB_Type) SetDDEVTYPE_SUB(value uint32) {
	volatile.StoreUint32(&o.DDEVTYPE.Reg, volatile.LoadUint32(&o.DDEVTYPE.Reg)&^(0xf0)|value<<4)
}
func (o *DIB_Type) GetDDEVTYPE_SUB() uint32 {
	return (volatile.LoadUint32(&o.DDEVTYPE.Reg) & 0xf0) >> 4
}

// DIB.DPIDR4: SCS Peripheral Identification Register 4
func (o *DIB_Type) SetDPIDR4_DES_2(value uint32) {
	volatile.StoreUint32(&o.DPIDR4.Reg, volatile.LoadUint32(&o.DPIDR4.Reg)&^(0xf)|value)
}
func (o *DIB_Type) GetDPIDR4_DES_2() uint32 {
	return volatile.LoadUint32(&o.DPIDR4.Reg) & 0xf
}
func (o *DIB_Type) SetDPIDR4_SIZE(value uint32) {
	volatile.StoreUint32(&o.DPIDR4.Reg, volatile.LoadUint32(&o.DPIDR4.Reg)&^(0xf0)|value<<4)
}
func (o *DIB_Type) GetDPIDR4_SIZE() uint32 {
	return (volatile.LoadUint32(&o.DPIDR4.Reg) & 0xf0) >> 4
}

// DIB.DPIDR0: SCS Peripheral Identification Register 0
func (o *DIB_Type) SetDPIDR0_PART_0(value uint32) {
	volatile.StoreUint32(&o.DPIDR0.Reg, volatile.LoadUint32(&o.DPIDR0.Reg)&^(0xff)|value)
}
func (o *DIB_Type) GetDPIDR0_PART_0() uint32 {
	return volatile.LoadUint32(&o.DPIDR0.Reg) & 0xff
}

// DIB.DPIDR1: SCS Peripheral Identification Register 1
func (o *DIB_Type) SetDPIDR1_PART_1(value uint32) {
	volatile.StoreUint32(&o.DPIDR1.Reg, volatile.LoadUint32(&o.DPIDR1.Reg)&^(0xf)|value)
}
func (o *DIB_Type) GetDPIDR1_PART_1() uint32 {
	return volatile.LoadUint32(&o.DPIDR1.Reg) & 0xf
}
func (o *DIB_Type) SetDPIDR1_DES_0(value uint32) {
	volatile.StoreUint32(&o.DPIDR1.Reg, volatile.LoadUint32(&o.DPIDR1.Reg)&^(0xf0)|value<<4)
}
func (o *DIB_Type) GetDPIDR1_DES_0() uint32 {
	return (volatile.LoadUint32(&o.DPIDR1.Reg) & 0xf0) >> 4
}

// DIB.DPIDR2: SCS Peripheral Identification Register 2
func (o *DIB_Type) SetDPIDR2_DES_1(value uint32) {
	volatile.StoreUint32(&o.DPIDR2.Reg, volatile.LoadUint32(&o.DPIDR2.Reg)&^(0x7)|value)
}
func (o *DIB_Type) GetDPIDR2_DES_1() uint32 {
	return volatile.LoadUint32(&o.DPIDR2.Reg) & 0x7
}
func (o *DIB_Type) SetDPIDR2_JEDEC(value uint32) {
	volatile.StoreUint32(&o.DPIDR2.Reg, volatile.LoadUint32(&o.DPIDR2.Reg)&^(0x8)|value<<3)
}
func (o *DIB_Type) GetDPIDR2_JEDEC() uint32 {
	return (volatile.LoadUint32(&o.DPIDR2.Reg) & 0x8) >> 3
}
func (o *DIB_Type) SetDPIDR2_REVISION(value uint32) {
	volatile.StoreUint32(&o.DPIDR2.Reg, volatile.LoadUint32(&o.DPIDR2.Reg)&^(0xf0)|value<<4)
}
func (o *DIB_Type) GetDPIDR2_REVISION() uint32 {
	return (volatile.LoadUint32(&o.DPIDR2.Reg) & 0xf0) >> 4
}

// DIB.DPIDR3: SCS Peripheral Identification Register 3
func (o *DIB_Type) SetDPIDR3_CMOD(value uint32) {
	volatile.StoreUint32(&o.DPIDR3.Reg, volatile.LoadUint32(&o.DPIDR3.Reg)&^(0xf)|value)
}
func (o *DIB_Type) GetDPIDR3_CMOD() uint32 {
	return volatile.LoadUint32(&o.DPIDR3.Reg) & 0xf
}
func (o *DIB_Type) SetDPIDR3_REVAND(value uint32) {
	volatile.StoreUint32(&o.DPIDR3.Reg, volatile.LoadUint32(&o.DPIDR3.Reg)&^(0xf0)|value<<4)
}
func (o *DIB_Type) GetDPIDR3_REVAND() uint32 {
	return (volatile.LoadUint32(&o.DPIDR3.Reg) & 0xf0) >> 4
}

// DIB.DCIDR0: SCS Component Identification Register 0
func (o *DIB_Type) SetDCIDR0_PRMBL_0(value uint32) {
	volatile.StoreUint32(&o.DCIDR0.Reg, volatile.LoadUint32(&o.DCIDR0.Reg)&^(0xff)|value)
}
func (o *DIB_Type) GetDCIDR0_PRMBL_0() uint32 {
	return volatile.LoadUint32(&o.DCIDR0.Reg) & 0xff
}

// DIB.DCIDR1: SCS Component Identification Register 1
func (o *DIB_Type) SetDCIDR1_PRMBL_1(value uint32) {
	volatile.StoreUint32(&o.DCIDR1.Reg, volatile.LoadUint32(&o.DCIDR1.Reg)&^(0xf)|value)
}
func (o *DIB_Type) GetDCIDR1_PRMBL_1() uint32 {
	return volatile.LoadUint32(&o.DCIDR1.Reg) & 0xf
}
func (o *DIB_Type) SetDCIDR1_CLASS(value uint32) {
	volatile.StoreUint32(&o.DCIDR1.Reg, volatile.LoadUint32(&o.DCIDR1.Reg)&^(0xf0)|value<<4)
}
func (o *DIB_Type) GetDCIDR1_CLASS() uint32 {
	return (volatile.LoadUint32(&o.DCIDR1.Reg) & 0xf0) >> 4
}

// DIB.DCIDR2: SCS Component Identification Register 2
func (o *DIB_Type) SetDCIDR2_PRMBL_2(value uint32) {
	volatile.StoreUint32(&o.DCIDR2.Reg, volatile.LoadUint32(&o.DCIDR2.Reg)&^(0xff)|value)
}
func (o *DIB_Type) GetDCIDR2_PRMBL_2() uint32 {
	return volatile.LoadUint32(&o.DCIDR2.Reg) & 0xff
}

// DIB.DCIDR3: SCS Component Identification Register 3
func (o *DIB_Type) SetDCIDR3_PRMBL_3(value uint32) {
	volatile.StoreUint32(&o.DCIDR3.Reg, volatile.LoadUint32(&o.DCIDR3.Reg)&^(0xff)|value)
}
func (o *DIB_Type) GetDCIDR3_PRMBL_3() uint32 {
	return volatile.LoadUint32(&o.DCIDR3.Reg) & 0xff
}

// Data Watchpoint and Trace
type DWT_Type struct {
	DWT_CTRL    volatile.Register32 // 0x0
	_           [24]byte
	DWT_PCSR    volatile.Register32    // 0x1C
	COMPARATOR  [2]DWT_COMPARATOR_Type // 0x20
	_           [3952]byte
	DWT_LAR     volatile.Register32 // 0xFB0
	DWT_LSR     volatile.Register32 // 0xFB4
	_           [4]byte
	DWT_DEVARCH volatile.Register32 // 0xFBC
	_           [12]byte
	DWT_DEVTYPE volatile.Register32 // 0xFCC
	DWT_PIDR4   volatile.Register32 // 0xFD0
	DWT_PIDR5   volatile.Register32 // 0xFD4
	DWT_PIDR6   volatile.Register32 // 0xFD8
	DWT_PIDR7   volatile.Register32 // 0xFDC
	DWT_PIDR0   volatile.Register32 // 0xFE0
	DWT_PIDR1   volatile.Register32 // 0xFE4
	DWT_PIDR2   volatile.Register32 // 0xFE8
	DWT_PIDR3   volatile.Register32 // 0xFEC
	DWT_CIDR0   volatile.Register32 // 0xFF0
	DWT_CIDR1   volatile.Register32 // 0xFF4
	DWT_CIDR2   volatile.Register32 // 0xFF8
	DWT_CIDR3   volatile.Register32 // 0xFFC
}

// DWT.DWT_CTRL: DWT Control Register
func (o *DWT_Type) SetDWT_CTRL_CYCCNTENA(value uint32) {
	volatile.StoreUint32(&o.DWT_CTRL.Reg, volatile.LoadUint32(&o.DWT_CTRL.Reg)&^(0x1)|value)
}
func (o *DWT_Type) GetDWT_CTRL_CYCCNTENA() uint32 {
	return volatile.LoadUint32(&o.DWT_CTRL.Reg) & 0x1
}
func (o *DWT_Type) SetDWT_CTRL_POSTPRESET(value uint32) {
	volatile.StoreUint32(&o.DWT_CTRL.Reg, volatile.LoadUint32(&o.DWT_CTRL.Reg)&^(0x1e)|value<<1)
}
func (o *DWT_Type) GetDWT_CTRL_POSTPRESET() uint32 {
	return (volatile.LoadUint32(&o.DWT_CTRL.Reg) & 0x1e) >> 1
}
func (o *DWT_Type) SetDWT_CTRL_POSTINIT(value uint32) {
	volatile.StoreUint32(&o.DWT_CTRL.Reg, volatile.LoadUint32(&o.DWT_CTRL.Reg)&^(0x1e0)|value<<5)
}
func (o *DWT_Type) GetDWT_CTRL_POSTINIT() uint32 {
	return (volatile.LoadUint32(&o.DWT_CTRL.Reg) & 0x1e0) >> 5
}
func (o *DWT_Type) SetDWT_CTRL_CYCTAP(value uint32) {
	volatile.StoreUint32(&o.DWT_CTRL.Reg, volatile.LoadUint32(&o.DWT_CTRL.Reg)&^(0x200)|value<<9)
}
func (o *DWT_Type) GetDWT_CTRL_CYCTAP() uint32 {
	return (volatile.LoadUint32(&o.DWT_CTRL.Reg) & 0x200) >> 9
}
func (o *DWT_Type) SetDWT_CTRL_SYNCTAP(value uint32) {
	volatile.StoreUint32(&o.DWT_CTRL.Reg, volatile.LoadUint32(&o.DWT_CTRL.Reg)&^(0xc00)|value<<10)
}
func (o *DWT_Type) GetDWT_CTRL_SYNCTAP() uint32 {
	return (volatile.LoadUint32(&o.DWT_CTRL.Reg) & 0xc00) >> 10
}
func (o *DWT_Type) SetDWT_CTRL_PCSAMPLENA(value uint32) {
	volatile.StoreUint32(&o.DWT_CTRL.Reg, volatile.LoadUint32(&o.DWT_CTRL.Reg)&^(0x1000)|value<<12)
}
func (o *DWT_Type) GetDWT_CTRL_PCSAMPLENA() uint32 {
	return (volatile.LoadUint32(&o.DWT_CTRL.Reg) & 0x1000) >> 12
}
func (o *DWT_Type) SetDWT_CTRL_EXCTRCENA(value uint32) {
	volatile.StoreUint32(&o.DWT_CTRL.Reg, volatile.LoadUint32(&o.DWT_CTRL.Reg)&^(0x10000)|value<<16)
}
func (o *DWT_Type) GetDWT_CTRL_EXCTRCENA() uint32 {
	return (volatile.LoadUint32(&o.DWT_CTRL.Reg) & 0x10000) >> 16
}
func (o *DWT_Type) SetDWT_CTRL_CPIEVTENA(value uint32) {
	volatile.StoreUint32(&o.DWT_CTRL.Reg, volatile.LoadUint32(&o.DWT_CTRL.Reg)&^(0x20000)|value<<17)
}
func (o *DWT_Type) GetDWT_CTRL_CPIEVTENA() uint32 {
	return (volatile.LoadUint32(&o.DWT_CTRL.Reg) & 0x20000) >> 17
}
func (o *DWT_Type) SetDWT_CTRL_EXCEVTENA(value uint32) {
	volatile.StoreUint32(&o.DWT_CTRL.Reg, volatile.LoadUint32(&o.DWT_CTRL.Reg)&^(0x40000)|value<<18)
}
func (o *DWT_Type) GetDWT_CTRL_EXCEVTENA() uint32 {
	return (volatile.LoadUint32(&o.DWT_CTRL.Reg) & 0x40000) >> 18
}
func (o *DWT_Type) SetDWT_CTRL_SLEEPEVTENA(value uint32) {
	volatile.StoreUint32(&o.DWT_CTRL.Reg, volatile.LoadUint32(&o.DWT_CTRL.Reg)&^(0x80000)|value<<19)
}
func (o *DWT_Type) GetDWT_CTRL_SLEEPEVTENA() uint32 {
	return (volatile.LoadUint32(&o.DWT_CTRL.Reg) & 0x80000) >> 19
}
func (o *DWT_Type) SetDWT_CTRL_LSUEVTENA(value uint32) {
	volatile.StoreUint32(&o.DWT_CTRL.Reg, volatile.LoadUint32(&o.DWT_CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *DWT_Type) GetDWT_CTRL_LSUEVTENA() uint32 {
	return (volatile.LoadUint32(&o.DWT_CTRL.Reg) & 0x100000) >> 20
}
func (o *DWT_Type) SetDWT_CTRL_FOLDEVTENA(value uint32) {
	volatile.StoreUint32(&o.DWT_CTRL.Reg, volatile.LoadUint32(&o.DWT_CTRL.Reg)&^(0x200000)|value<<21)
}
func (o *DWT_Type) GetDWT_CTRL_FOLDEVTENA() uint32 {
	return (volatile.LoadUint32(&o.DWT_CTRL.Reg) & 0x200000) >> 21
}
func (o *DWT_Type) SetDWT_CTRL_CYCEVTENA(value uint32) {
	volatile.StoreUint32(&o.DWT_CTRL.Reg, volatile.LoadUint32(&o.DWT_CTRL.Reg)&^(0x400000)|value<<22)
}
func (o *DWT_Type) GetDWT_CTRL_CYCEVTENA() uint32 {
	return (volatile.LoadUint32(&o.DWT_CTRL.Reg) & 0x400000) >> 22
}
func (o *DWT_Type) SetDWT_CTRL_CYCDISS(value uint32) {
	volatile.StoreUint32(&o.DWT_CTRL.Reg, volatile.LoadUint32(&o.DWT_CTRL.Reg)&^(0x800000)|value<<23)
}
func (o *DWT_Type) GetDWT_CTRL_CYCDISS() uint32 {
	return (volatile.LoadUint32(&o.DWT_CTRL.Reg) & 0x800000) >> 23
}
func (o *DWT_Type) SetDWT_CTRL_NOPRFCNT(value uint32) {
	volatile.StoreUint32(&o.DWT_CTRL.Reg, volatile.LoadUint32(&o.DWT_CTRL.Reg)&^(0x1000000)|value<<24)
}
func (o *DWT_Type) GetDWT_CTRL_NOPRFCNT() uint32 {
	return (volatile.LoadUint32(&o.DWT_CTRL.Reg) & 0x1000000) >> 24
}
func (o *DWT_Type) SetDWT_CTRL_NOCYCCNT(value uint32) {
	volatile.StoreUint32(&o.DWT_CTRL.Reg, volatile.LoadUint32(&o.DWT_CTRL.Reg)&^(0x2000000)|value<<25)
}
func (o *DWT_Type) GetDWT_CTRL_NOCYCCNT() uint32 {
	return (volatile.LoadUint32(&o.DWT_CTRL.Reg) & 0x2000000) >> 25
}
func (o *DWT_Type) SetDWT_CTRL_NOEXTTRIG(value uint32) {
	volatile.StoreUint32(&o.DWT_CTRL.Reg, volatile.LoadUint32(&o.DWT_CTRL.Reg)&^(0x4000000)|value<<26)
}
func (o *DWT_Type) GetDWT_CTRL_NOEXTTRIG() uint32 {
	return (volatile.LoadUint32(&o.DWT_CTRL.Reg) & 0x4000000) >> 26
}
func (o *DWT_Type) SetDWT_CTRL_NOTRCPKT(value uint32) {
	volatile.StoreUint32(&o.DWT_CTRL.Reg, volatile.LoadUint32(&o.DWT_CTRL.Reg)&^(0x8000000)|value<<27)
}
func (o *DWT_Type) GetDWT_CTRL_NOTRCPKT() uint32 {
	return (volatile.LoadUint32(&o.DWT_CTRL.Reg) & 0x8000000) >> 27
}
func (o *DWT_Type) SetDWT_CTRL_NUMCOMP(value uint32) {
	volatile.StoreUint32(&o.DWT_CTRL.Reg, volatile.LoadUint32(&o.DWT_CTRL.Reg)&^(0xf0000000)|value<<28)
}
func (o *DWT_Type) GetDWT_CTRL_NUMCOMP() uint32 {
	return (volatile.LoadUint32(&o.DWT_CTRL.Reg) & 0xf0000000) >> 28
}

// DWT.DWT_PCSR: DWT Program Counter Sample Register
func (o *DWT_Type) SetDWT_PCSR(value uint32) {
	volatile.StoreUint32(&o.DWT_PCSR.Reg, value)
}
func (o *DWT_Type) GetDWT_PCSR() uint32 {
	return volatile.LoadUint32(&o.DWT_PCSR.Reg)
}

// DWT.DWT_LAR: DWT Software Lock Access Register
func (o *DWT_Type) SetDWT_LAR(value uint32) {
	volatile.StoreUint32(&o.DWT_LAR.Reg, value)
}
func (o *DWT_Type) GetDWT_LAR() uint32 {
	return volatile.LoadUint32(&o.DWT_LAR.Reg)
}

// DWT.DWT_LSR: DWT Software Lock Status Register
func (o *DWT_Type) SetDWT_LSR_SLI(value uint32) {
	volatile.StoreUint32(&o.DWT_LSR.Reg, volatile.LoadUint32(&o.DWT_LSR.Reg)&^(0x1)|value)
}
func (o *DWT_Type) GetDWT_LSR_SLI() uint32 {
	return volatile.LoadUint32(&o.DWT_LSR.Reg) & 0x1
}
func (o *DWT_Type) SetDWT_LSR_SLK(value uint32) {
	volatile.StoreUint32(&o.DWT_LSR.Reg, volatile.LoadUint32(&o.DWT_LSR.Reg)&^(0x2)|value<<1)
}
func (o *DWT_Type) GetDWT_LSR_SLK() uint32 {
	return (volatile.LoadUint32(&o.DWT_LSR.Reg) & 0x2) >> 1
}
func (o *DWT_Type) SetDWT_LSR_NTT(value uint32) {
	volatile.StoreUint32(&o.DWT_LSR.Reg, volatile.LoadUint32(&o.DWT_LSR.Reg)&^(0x4)|value<<2)
}
func (o *DWT_Type) GetDWT_LSR_NTT() uint32 {
	return (volatile.LoadUint32(&o.DWT_LSR.Reg) & 0x4) >> 2
}

// DWT.DWT_DEVARCH: DWT Device Architecture Register
func (o *DWT_Type) SetDWT_DEVARCH_ARCHPART(value uint32) {
	volatile.StoreUint32(&o.DWT_DEVARCH.Reg, volatile.LoadUint32(&o.DWT_DEVARCH.Reg)&^(0xfff)|value)
}
func (o *DWT_Type) GetDWT_DEVARCH_ARCHPART() uint32 {
	return volatile.LoadUint32(&o.DWT_DEVARCH.Reg) & 0xfff
}
func (o *DWT_Type) SetDWT_DEVARCH_ARCHVER(value uint32) {
	volatile.StoreUint32(&o.DWT_DEVARCH.Reg, volatile.LoadUint32(&o.DWT_DEVARCH.Reg)&^(0xf000)|value<<12)
}
func (o *DWT_Type) GetDWT_DEVARCH_ARCHVER() uint32 {
	return (volatile.LoadUint32(&o.DWT_DEVARCH.Reg) & 0xf000) >> 12
}
func (o *DWT_Type) SetDWT_DEVARCH_REVISION(value uint32) {
	volatile.StoreUint32(&o.DWT_DEVARCH.Reg, volatile.LoadUint32(&o.DWT_DEVARCH.Reg)&^(0xf0000)|value<<16)
}
func (o *DWT_Type) GetDWT_DEVARCH_REVISION() uint32 {
	return (volatile.LoadUint32(&o.DWT_DEVARCH.Reg) & 0xf0000) >> 16
}
func (o *DWT_Type) SetDWT_DEVARCH_PRESENT(value uint32) {
	volatile.StoreUint32(&o.DWT_DEVARCH.Reg, volatile.LoadUint32(&o.DWT_DEVARCH.Reg)&^(0x100000)|value<<20)
}
func (o *DWT_Type) GetDWT_DEVARCH_PRESENT() uint32 {
	return (volatile.LoadUint32(&o.DWT_DEVARCH.Reg) & 0x100000) >> 20
}
func (o *DWT_Type) SetDWT_DEVARCH_ARCHITECT(value uint32) {
	volatile.StoreUint32(&o.DWT_DEVARCH.Reg, volatile.LoadUint32(&o.DWT_DEVARCH.Reg)&^(0xffe00000)|value<<21)
}
func (o *DWT_Type) GetDWT_DEVARCH_ARCHITECT() uint32 {
	return (volatile.LoadUint32(&o.DWT_DEVARCH.Reg) & 0xffe00000) >> 21
}

// DWT.DWT_DEVTYPE: DWT Device Type Register
func (o *DWT_Type) SetDWT_DEVTYPE_MAJOR(value uint32) {
	volatile.StoreUint32(&o.DWT_DEVTYPE.Reg, volatile.LoadUint32(&o.DWT_DEVTYPE.Reg)&^(0xf)|value)
}
func (o *DWT_Type) GetDWT_DEVTYPE_MAJOR() uint32 {
	return volatile.LoadUint32(&o.DWT_DEVTYPE.Reg) & 0xf
}
func (o *DWT_Type) SetDWT_DEVTYPE_SUB(value uint32) {
	volatile.StoreUint32(&o.DWT_DEVTYPE.Reg, volatile.LoadUint32(&o.DWT_DEVTYPE.Reg)&^(0xf0)|value<<4)
}
func (o *DWT_Type) GetDWT_DEVTYPE_SUB() uint32 {
	return (volatile.LoadUint32(&o.DWT_DEVTYPE.Reg) & 0xf0) >> 4
}

// DWT.DWT_PIDR4: DWT Peripheral Identification Register 4
func (o *DWT_Type) SetDWT_PIDR4_DES_2(value uint32) {
	volatile.StoreUint32(&o.DWT_PIDR4.Reg, volatile.LoadUint32(&o.DWT_PIDR4.Reg)&^(0xf)|value)
}
func (o *DWT_Type) GetDWT_PIDR4_DES_2() uint32 {
	return volatile.LoadUint32(&o.DWT_PIDR4.Reg) & 0xf
}
func (o *DWT_Type) SetDWT_PIDR4_SIZE(value uint32) {
	volatile.StoreUint32(&o.DWT_PIDR4.Reg, volatile.LoadUint32(&o.DWT_PIDR4.Reg)&^(0xf0)|value<<4)
}
func (o *DWT_Type) GetDWT_PIDR4_SIZE() uint32 {
	return (volatile.LoadUint32(&o.DWT_PIDR4.Reg) & 0xf0) >> 4
}

// DWT.DWT_PIDR0: DWT Peripheral Identification Register 0
func (o *DWT_Type) SetDWT_PIDR0_PART_0(value uint32) {
	volatile.StoreUint32(&o.DWT_PIDR0.Reg, volatile.LoadUint32(&o.DWT_PIDR0.Reg)&^(0xff)|value)
}
func (o *DWT_Type) GetDWT_PIDR0_PART_0() uint32 {
	return volatile.LoadUint32(&o.DWT_PIDR0.Reg) & 0xff
}

// DWT.DWT_PIDR1: DWT Peripheral Identification Register 1
func (o *DWT_Type) SetDWT_PIDR1_PART_1(value uint32) {
	volatile.StoreUint32(&o.DWT_PIDR1.Reg, volatile.LoadUint32(&o.DWT_PIDR1.Reg)&^(0xf)|value)
}
func (o *DWT_Type) GetDWT_PIDR1_PART_1() uint32 {
	return volatile.LoadUint32(&o.DWT_PIDR1.Reg) & 0xf
}
func (o *DWT_Type) SetDWT_PIDR1_DES_0(value uint32) {
	volatile.StoreUint32(&o.DWT_PIDR1.Reg, volatile.LoadUint32(&o.DWT_PIDR1.Reg)&^(0xf0)|value<<4)
}
func (o *DWT_Type) GetDWT_PIDR1_DES_0() uint32 {
	return (volatile.LoadUint32(&o.DWT_PIDR1.Reg) & 0xf0) >> 4
}

// DWT.DWT_PIDR2: DWT Peripheral Identification Register 2
func (o *DWT_Type) SetDWT_PIDR2_DES_1(value uint32) {
	volatile.StoreUint32(&o.DWT_PIDR2.Reg, volatile.LoadUint32(&o.DWT_PIDR2.Reg)&^(0x7)|value)
}
func (o *DWT_Type) GetDWT_PIDR2_DES_1() uint32 {
	return volatile.LoadUint32(&o.DWT_PIDR2.Reg) & 0x7
}
func (o *DWT_Type) SetDWT_PIDR2_JEDEC(value uint32) {
	volatile.StoreUint32(&o.DWT_PIDR2.Reg, volatile.LoadUint32(&o.DWT_PIDR2.Reg)&^(0x8)|value<<3)
}
func (o *DWT_Type) GetDWT_PIDR2_JEDEC() uint32 {
	return (volatile.LoadUint32(&o.DWT_PIDR2.Reg) & 0x8) >> 3
}
func (o *DWT_Type) SetDWT_PIDR2_REVISION(value uint32) {
	volatile.StoreUint32(&o.DWT_PIDR2.Reg, volatile.LoadUint32(&o.DWT_PIDR2.Reg)&^(0xf0)|value<<4)
}
func (o *DWT_Type) GetDWT_PIDR2_REVISION() uint32 {
	return (volatile.LoadUint32(&o.DWT_PIDR2.Reg) & 0xf0) >> 4
}

// DWT.DWT_PIDR3: DWT Peripheral Identification Register 3
func (o *DWT_Type) SetDWT_PIDR3_CMOD(value uint32) {
	volatile.StoreUint32(&o.DWT_PIDR3.Reg, volatile.LoadUint32(&o.DWT_PIDR3.Reg)&^(0xf)|value)
}
func (o *DWT_Type) GetDWT_PIDR3_CMOD() uint32 {
	return volatile.LoadUint32(&o.DWT_PIDR3.Reg) & 0xf
}
func (o *DWT_Type) SetDWT_PIDR3_REVAND(value uint32) {
	volatile.StoreUint32(&o.DWT_PIDR3.Reg, volatile.LoadUint32(&o.DWT_PIDR3.Reg)&^(0xf0)|value<<4)
}
func (o *DWT_Type) GetDWT_PIDR3_REVAND() uint32 {
	return (volatile.LoadUint32(&o.DWT_PIDR3.Reg) & 0xf0) >> 4
}

// DWT.DWT_CIDR0: DWT Component Identification Register 0
func (o *DWT_Type) SetDWT_CIDR0_PRMBL_0(value uint32) {
	volatile.StoreUint32(&o.DWT_CIDR0.Reg, volatile.LoadUint32(&o.DWT_CIDR0.Reg)&^(0xff)|value)
}
func (o *DWT_Type) GetDWT_CIDR0_PRMBL_0() uint32 {
	return volatile.LoadUint32(&o.DWT_CIDR0.Reg) & 0xff
}

// DWT.DWT_CIDR1: DWT Component Identification Register 1
func (o *DWT_Type) SetDWT_CIDR1_PRMBL_1(value uint32) {
	volatile.StoreUint32(&o.DWT_CIDR1.Reg, volatile.LoadUint32(&o.DWT_CIDR1.Reg)&^(0xf)|value)
}
func (o *DWT_Type) GetDWT_CIDR1_PRMBL_1() uint32 {
	return volatile.LoadUint32(&o.DWT_CIDR1.Reg) & 0xf
}
func (o *DWT_Type) SetDWT_CIDR1_CLASS(value uint32) {
	volatile.StoreUint32(&o.DWT_CIDR1.Reg, volatile.LoadUint32(&o.DWT_CIDR1.Reg)&^(0xf0)|value<<4)
}
func (o *DWT_Type) GetDWT_CIDR1_CLASS() uint32 {
	return (volatile.LoadUint32(&o.DWT_CIDR1.Reg) & 0xf0) >> 4
}

// DWT.DWT_CIDR2: DWT Component Identification Register 2
func (o *DWT_Type) SetDWT_CIDR2_PRMBL_2(value uint32) {
	volatile.StoreUint32(&o.DWT_CIDR2.Reg, volatile.LoadUint32(&o.DWT_CIDR2.Reg)&^(0xff)|value)
}
func (o *DWT_Type) GetDWT_CIDR2_PRMBL_2() uint32 {
	return volatile.LoadUint32(&o.DWT_CIDR2.Reg) & 0xff
}

// DWT.DWT_CIDR3: DWT Component Identification Register 3
func (o *DWT_Type) SetDWT_CIDR3_PRMBL_3(value uint32) {
	volatile.StoreUint32(&o.DWT_CIDR3.Reg, volatile.LoadUint32(&o.DWT_CIDR3.Reg)&^(0xff)|value)
}
func (o *DWT_Type) GetDWT_CIDR3_PRMBL_3() uint32 {
	return volatile.LoadUint32(&o.DWT_CIDR3.Reg) & 0xff
}

type DWT_COMPARATOR_Type struct {
	DWT_COMP     volatile.Register32 // 0x20
	_            [4]byte
	DWT_FUNCTION volatile.Register32 // 0x28
	_            [4]byte
}

// DWT_COMPARATOR.DWT_COMP: DWT Comparator Register n
func (o *DWT_COMPARATOR_Type) SetDWT_COMP(value uint32) {
	volatile.StoreUint32(&o.DWT_COMP.Reg, value)
}
func (o *DWT_COMPARATOR_Type) GetDWT_COMP() uint32 {
	return volatile.LoadUint32(&o.DWT_COMP.Reg)
}

// DWT_COMPARATOR.DWT_FUNCTION: DWT Function Register x
func (o *DWT_COMPARATOR_Type) SetDWT_FUNCTION_MATCH(value uint32) {
	volatile.StoreUint32(&o.DWT_FUNCTION.Reg, volatile.LoadUint32(&o.DWT_FUNCTION.Reg)&^(0xf)|value)
}
func (o *DWT_COMPARATOR_Type) GetDWT_FUNCTION_MATCH() uint32 {
	return volatile.LoadUint32(&o.DWT_FUNCTION.Reg) & 0xf
}
func (o *DWT_COMPARATOR_Type) SetDWT_FUNCTION_ACTION(value uint32) {
	volatile.StoreUint32(&o.DWT_FUNCTION.Reg, volatile.LoadUint32(&o.DWT_FUNCTION.Reg)&^(0x30)|value<<4)
}
func (o *DWT_COMPARATOR_Type) GetDWT_FUNCTION_ACTION() uint32 {
	return (volatile.LoadUint32(&o.DWT_FUNCTION.Reg) & 0x30) >> 4
}
func (o *DWT_COMPARATOR_Type) SetDWT_FUNCTION_DATAVSIZE(value uint32) {
	volatile.StoreUint32(&o.DWT_FUNCTION.Reg, volatile.LoadUint32(&o.DWT_FUNCTION.Reg)&^(0xc00)|value<<10)
}
func (o *DWT_COMPARATOR_Type) GetDWT_FUNCTION_DATAVSIZE() uint32 {
	return (volatile.LoadUint32(&o.DWT_FUNCTION.Reg) & 0xc00) >> 10
}
func (o *DWT_COMPARATOR_Type) SetDWT_FUNCTION_MATCHED(value uint32) {
	volatile.StoreUint32(&o.DWT_FUNCTION.Reg, volatile.LoadUint32(&o.DWT_FUNCTION.Reg)&^(0x1000000)|value<<24)
}
func (o *DWT_COMPARATOR_Type) GetDWT_FUNCTION_MATCHED() uint32 {
	return (volatile.LoadUint32(&o.DWT_FUNCTION.Reg) & 0x1000000) >> 24
}
func (o *DWT_COMPARATOR_Type) SetDWT_FUNCTION_ID(value uint32) {
	volatile.StoreUint32(&o.DWT_FUNCTION.Reg, volatile.LoadUint32(&o.DWT_FUNCTION.Reg)&^(0xf8000000)|value<<27)
}
func (o *DWT_COMPARATOR_Type) GetDWT_FUNCTION_ID() uint32 {
	return (volatile.LoadUint32(&o.DWT_FUNCTION.Reg) & 0xf8000000) >> 27
}

// Flash Patch and Breakpoint
type FPB_Type struct {
	FP_CTRL    volatile.Register32    // 0x0
	FP_REMAP   volatile.Register32    // 0x4
	FP_COMP    [4]volatile.Register32 // 0x8
	_          [3992]byte
	FP_LAR     volatile.Register32 // 0xFB0
	FP_LSR     volatile.Register32 // 0xFB4
	_          [4]byte
	FP_DEVARCH volatile.Register32 // 0xFBC
	_          [12]byte
	FP_DEVTYPE volatile.Register32 // 0xFCC
	FP_PIDR4   volatile.Register32 // 0xFD0
	FP_PIDR5   volatile.Register32 // 0xFD4
	FP_PIDR6   volatile.Register32 // 0xFD8
	FP_PIDR7   volatile.Register32 // 0xFDC
	FP_PIDR0   volatile.Register32 // 0xFE0
	FP_PIDR1   volatile.Register32 // 0xFE4
	FP_PIDR2   volatile.Register32 // 0xFE8
	FP_PIDR3   volatile.Register32 // 0xFEC
	FP_CIDR0   volatile.Register32 // 0xFF0
	FP_CIDR1   volatile.Register32 // 0xFF4
	FP_CIDR2   volatile.Register32 // 0xFF8
	FP_CIDR3   volatile.Register32 // 0xFFC
}

// FPB.FP_CTRL: Flash Patch Control Register
func (o *FPB_Type) SetFP_CTRL_ENABLE(value uint32) {
	volatile.StoreUint32(&o.FP_CTRL.Reg, volatile.LoadUint32(&o.FP_CTRL.Reg)&^(0x1)|value)
}
func (o *FPB_Type) GetFP_CTRL_ENABLE() uint32 {
	return volatile.LoadUint32(&o.FP_CTRL.Reg) & 0x1
}
func (o *FPB_Type) SetFP_CTRL_KEY(value uint32) {
	volatile.StoreUint32(&o.FP_CTRL.Reg, volatile.LoadUint32(&o.FP_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *FPB_Type) GetFP_CTRL_KEY() uint32 {
	return (volatile.LoadUint32(&o.FP_CTRL.Reg) & 0x2) >> 1
}
func (o *FPB_Type) SetFP_CTRL_NUM_CODE(value uint32) {
	volatile.StoreUint32(&o.FP_CTRL.Reg, volatile.LoadUint32(&o.FP_CTRL.Reg)&^(0xf0)|value<<4)
}
func (o *FPB_Type) GetFP_CTRL_NUM_CODE() uint32 {
	return (volatile.LoadUint32(&o.FP_CTRL.Reg) & 0xf0) >> 4
}
func (o *FPB_Type) SetFP_CTRL_NUM_LIT(value uint32) {
	volatile.StoreUint32(&o.FP_CTRL.Reg, volatile.LoadUint32(&o.FP_CTRL.Reg)&^(0xf00)|value<<8)
}
func (o *FPB_Type) GetFP_CTRL_NUM_LIT() uint32 {
	return (volatile.LoadUint32(&o.FP_CTRL.Reg) & 0xf00) >> 8
}
func (o *FPB_Type) SetFP_CTRL_NUM_CODE_1(value uint32) {
	volatile.StoreUint32(&o.FP_CTRL.Reg, volatile.LoadUint32(&o.FP_CTRL.Reg)&^(0x7000)|value<<12)
}
func (o *FPB_Type) GetFP_CTRL_NUM_CODE_1() uint32 {
	return (volatile.LoadUint32(&o.FP_CTRL.Reg) & 0x7000) >> 12
}
func (o *FPB_Type) SetFP_CTRL_REV(value uint32) {
	volatile.StoreUint32(&o.FP_CTRL.Reg, volatile.LoadUint32(&o.FP_CTRL.Reg)&^(0xf0000000)|value<<28)
}
func (o *FPB_Type) GetFP_CTRL_REV() uint32 {
	return (volatile.LoadUint32(&o.FP_CTRL.Reg) & 0xf0000000) >> 28
}

// FPB.FP_REMAP: Flash Patch Remap Register
func (o *FPB_Type) SetFP_REMAP_REMAP(value uint32) {
	volatile.StoreUint32(&o.FP_REMAP.Reg, volatile.LoadUint32(&o.FP_REMAP.Reg)&^(0x1fffffe0)|value<<5)
}
func (o *FPB_Type) GetFP_REMAP_REMAP() uint32 {
	return (volatile.LoadUint32(&o.FP_REMAP.Reg) & 0x1fffffe0) >> 5
}
func (o *FPB_Type) SetFP_REMAP_RMPSPT(value uint32) {
	volatile.StoreUint32(&o.FP_REMAP.Reg, volatile.LoadUint32(&o.FP_REMAP.Reg)&^(0x20000000)|value<<29)
}
func (o *FPB_Type) GetFP_REMAP_RMPSPT() uint32 {
	return (volatile.LoadUint32(&o.FP_REMAP.Reg) & 0x20000000) >> 29
}

// FPB.FP_COMP: Flash Patch Comparator Register n
func (o *FPB_Type) SetFP_COMP_BE(idx int, value uint32) {
	volatile.StoreUint32(&o.FP_COMP[idx].Reg, volatile.LoadUint32(&o.FP_COMP[idx].Reg)&^(0x1)|value)
}
func (o *FPB_Type) GetFP_COMP_BE(idx int) uint32 {
	return volatile.LoadUint32(&o.FP_COMP[idx].Reg) & 0x1
}
func (o *FPB_Type) SetFP_COMP_FPADDR(idx int, value uint32) {
	volatile.StoreUint32(&o.FP_COMP[idx].Reg, volatile.LoadUint32(&o.FP_COMP[idx].Reg)&^(0x1ffffffc)|value<<2)
}
func (o *FPB_Type) GetFP_COMP_FPADDR(idx int) uint32 {
	return (volatile.LoadUint32(&o.FP_COMP[idx].Reg) & 0x1ffffffc) >> 2
}
func (o *FPB_Type) SetFP_COMP_FE(idx int, value uint32) {
	volatile.StoreUint32(&o.FP_COMP[idx].Reg, volatile.LoadUint32(&o.FP_COMP[idx].Reg)&^(0x80000000)|value<<31)
}
func (o *FPB_Type) GetFP_COMP_FE(idx int) uint32 {
	return (volatile.LoadUint32(&o.FP_COMP[idx].Reg) & 0x80000000) >> 31
}

// FPB.FP_LAR: FPB Software Lock Access Register
func (o *FPB_Type) SetFP_LAR(value uint32) {
	volatile.StoreUint32(&o.FP_LAR.Reg, value)
}
func (o *FPB_Type) GetFP_LAR() uint32 {
	return volatile.LoadUint32(&o.FP_LAR.Reg)
}

// FPB.FP_LSR: FPB Software Lock Status Register
func (o *FPB_Type) SetFP_LSR_SLI(value uint32) {
	volatile.StoreUint32(&o.FP_LSR.Reg, volatile.LoadUint32(&o.FP_LSR.Reg)&^(0x1)|value)
}
func (o *FPB_Type) GetFP_LSR_SLI() uint32 {
	return volatile.LoadUint32(&o.FP_LSR.Reg) & 0x1
}
func (o *FPB_Type) SetFP_LSR_SLK(value uint32) {
	volatile.StoreUint32(&o.FP_LSR.Reg, volatile.LoadUint32(&o.FP_LSR.Reg)&^(0x2)|value<<1)
}
func (o *FPB_Type) GetFP_LSR_SLK() uint32 {
	return (volatile.LoadUint32(&o.FP_LSR.Reg) & 0x2) >> 1
}
func (o *FPB_Type) SetFP_LSR_NTT(value uint32) {
	volatile.StoreUint32(&o.FP_LSR.Reg, volatile.LoadUint32(&o.FP_LSR.Reg)&^(0x4)|value<<2)
}
func (o *FPB_Type) GetFP_LSR_NTT() uint32 {
	return (volatile.LoadUint32(&o.FP_LSR.Reg) & 0x4) >> 2
}

// FPB.FP_DEVARCH: FPB Device Architecture Register
func (o *FPB_Type) SetFP_DEVARCH_ARCHPART(value uint32) {
	volatile.StoreUint32(&o.FP_DEVARCH.Reg, volatile.LoadUint32(&o.FP_DEVARCH.Reg)&^(0xfff)|value)
}
func (o *FPB_Type) GetFP_DEVARCH_ARCHPART() uint32 {
	return volatile.LoadUint32(&o.FP_DEVARCH.Reg) & 0xfff
}
func (o *FPB_Type) SetFP_DEVARCH_ARCHVER(value uint32) {
	volatile.StoreUint32(&o.FP_DEVARCH.Reg, volatile.LoadUint32(&o.FP_DEVARCH.Reg)&^(0xf000)|value<<12)
}
func (o *FPB_Type) GetFP_DEVARCH_ARCHVER() uint32 {
	return (volatile.LoadUint32(&o.FP_DEVARCH.Reg) & 0xf000) >> 12
}
func (o *FPB_Type) SetFP_DEVARCH_REVISION(value uint32) {
	volatile.StoreUint32(&o.FP_DEVARCH.Reg, volatile.LoadUint32(&o.FP_DEVARCH.Reg)&^(0xf0000)|value<<16)
}
func (o *FPB_Type) GetFP_DEVARCH_REVISION() uint32 {
	return (volatile.LoadUint32(&o.FP_DEVARCH.Reg) & 0xf0000) >> 16
}
func (o *FPB_Type) SetFP_DEVARCH_PRESENT(value uint32) {
	volatile.StoreUint32(&o.FP_DEVARCH.Reg, volatile.LoadUint32(&o.FP_DEVARCH.Reg)&^(0x100000)|value<<20)
}
func (o *FPB_Type) GetFP_DEVARCH_PRESENT() uint32 {
	return (volatile.LoadUint32(&o.FP_DEVARCH.Reg) & 0x100000) >> 20
}
func (o *FPB_Type) SetFP_DEVARCH_ARCHITECT(value uint32) {
	volatile.StoreUint32(&o.FP_DEVARCH.Reg, volatile.LoadUint32(&o.FP_DEVARCH.Reg)&^(0xffe00000)|value<<21)
}
func (o *FPB_Type) GetFP_DEVARCH_ARCHITECT() uint32 {
	return (volatile.LoadUint32(&o.FP_DEVARCH.Reg) & 0xffe00000) >> 21
}

// FPB.FP_DEVTYPE: FPB Device Type Register
func (o *FPB_Type) SetFP_DEVTYPE_MAJOR(value uint32) {
	volatile.StoreUint32(&o.FP_DEVTYPE.Reg, volatile.LoadUint32(&o.FP_DEVTYPE.Reg)&^(0xf)|value)
}
func (o *FPB_Type) GetFP_DEVTYPE_MAJOR() uint32 {
	return volatile.LoadUint32(&o.FP_DEVTYPE.Reg) & 0xf
}
func (o *FPB_Type) SetFP_DEVTYPE_SUB(value uint32) {
	volatile.StoreUint32(&o.FP_DEVTYPE.Reg, volatile.LoadUint32(&o.FP_DEVTYPE.Reg)&^(0xf0)|value<<4)
}
func (o *FPB_Type) GetFP_DEVTYPE_SUB() uint32 {
	return (volatile.LoadUint32(&o.FP_DEVTYPE.Reg) & 0xf0) >> 4
}

// FPB.FP_PIDR4: FP Peripheral Identification Register 4
func (o *FPB_Type) SetFP_PIDR4_DES_2(value uint32) {
	volatile.StoreUint32(&o.FP_PIDR4.Reg, volatile.LoadUint32(&o.FP_PIDR4.Reg)&^(0xf)|value)
}
func (o *FPB_Type) GetFP_PIDR4_DES_2() uint32 {
	return volatile.LoadUint32(&o.FP_PIDR4.Reg) & 0xf
}
func (o *FPB_Type) SetFP_PIDR4_SIZE(value uint32) {
	volatile.StoreUint32(&o.FP_PIDR4.Reg, volatile.LoadUint32(&o.FP_PIDR4.Reg)&^(0xf0)|value<<4)
}
func (o *FPB_Type) GetFP_PIDR4_SIZE() uint32 {
	return (volatile.LoadUint32(&o.FP_PIDR4.Reg) & 0xf0) >> 4
}

// FPB.FP_PIDR0: FP Peripheral Identification Register 0
func (o *FPB_Type) SetFP_PIDR0_PART_0(value uint32) {
	volatile.StoreUint32(&o.FP_PIDR0.Reg, volatile.LoadUint32(&o.FP_PIDR0.Reg)&^(0xff)|value)
}
func (o *FPB_Type) GetFP_PIDR0_PART_0() uint32 {
	return volatile.LoadUint32(&o.FP_PIDR0.Reg) & 0xff
}

// FPB.FP_PIDR1: FP Peripheral Identification Register 1
func (o *FPB_Type) SetFP_PIDR1_PART_1(value uint32) {
	volatile.StoreUint32(&o.FP_PIDR1.Reg, volatile.LoadUint32(&o.FP_PIDR1.Reg)&^(0xf)|value)
}
func (o *FPB_Type) GetFP_PIDR1_PART_1() uint32 {
	return volatile.LoadUint32(&o.FP_PIDR1.Reg) & 0xf
}
func (o *FPB_Type) SetFP_PIDR1_DES_0(value uint32) {
	volatile.StoreUint32(&o.FP_PIDR1.Reg, volatile.LoadUint32(&o.FP_PIDR1.Reg)&^(0xf0)|value<<4)
}
func (o *FPB_Type) GetFP_PIDR1_DES_0() uint32 {
	return (volatile.LoadUint32(&o.FP_PIDR1.Reg) & 0xf0) >> 4
}

// FPB.FP_PIDR2: FP Peripheral Identification Register 2
func (o *FPB_Type) SetFP_PIDR2_DES_1(value uint32) {
	volatile.StoreUint32(&o.FP_PIDR2.Reg, volatile.LoadUint32(&o.FP_PIDR2.Reg)&^(0x7)|value)
}
func (o *FPB_Type) GetFP_PIDR2_DES_1() uint32 {
	return volatile.LoadUint32(&o.FP_PIDR2.Reg) & 0x7
}
func (o *FPB_Type) SetFP_PIDR2_JEDEC(value uint32) {
	volatile.StoreUint32(&o.FP_PIDR2.Reg, volatile.LoadUint32(&o.FP_PIDR2.Reg)&^(0x8)|value<<3)
}
func (o *FPB_Type) GetFP_PIDR2_JEDEC() uint32 {
	return (volatile.LoadUint32(&o.FP_PIDR2.Reg) & 0x8) >> 3
}
func (o *FPB_Type) SetFP_PIDR2_REVISION(value uint32) {
	volatile.StoreUint32(&o.FP_PIDR2.Reg, volatile.LoadUint32(&o.FP_PIDR2.Reg)&^(0xf0)|value<<4)
}
func (o *FPB_Type) GetFP_PIDR2_REVISION() uint32 {
	return (volatile.LoadUint32(&o.FP_PIDR2.Reg) & 0xf0) >> 4
}

// FPB.FP_PIDR3: FP Peripheral Identification Register 3
func (o *FPB_Type) SetFP_PIDR3_CMOD(value uint32) {
	volatile.StoreUint32(&o.FP_PIDR3.Reg, volatile.LoadUint32(&o.FP_PIDR3.Reg)&^(0xf)|value)
}
func (o *FPB_Type) GetFP_PIDR3_CMOD() uint32 {
	return volatile.LoadUint32(&o.FP_PIDR3.Reg) & 0xf
}
func (o *FPB_Type) SetFP_PIDR3_REVAND(value uint32) {
	volatile.StoreUint32(&o.FP_PIDR3.Reg, volatile.LoadUint32(&o.FP_PIDR3.Reg)&^(0xf0)|value<<4)
}
func (o *FPB_Type) GetFP_PIDR3_REVAND() uint32 {
	return (volatile.LoadUint32(&o.FP_PIDR3.Reg) & 0xf0) >> 4
}

// FPB.FP_CIDR0: FP Component Identification Register 0
func (o *FPB_Type) SetFP_CIDR0_PRMBL_0(value uint32) {
	volatile.StoreUint32(&o.FP_CIDR0.Reg, volatile.LoadUint32(&o.FP_CIDR0.Reg)&^(0xff)|value)
}
func (o *FPB_Type) GetFP_CIDR0_PRMBL_0() uint32 {
	return volatile.LoadUint32(&o.FP_CIDR0.Reg) & 0xff
}

// FPB.FP_CIDR1: FP Component Identification Register 1
func (o *FPB_Type) SetFP_CIDR1_PRMBL_1(value uint32) {
	volatile.StoreUint32(&o.FP_CIDR1.Reg, volatile.LoadUint32(&o.FP_CIDR1.Reg)&^(0xf)|value)
}
func (o *FPB_Type) GetFP_CIDR1_PRMBL_1() uint32 {
	return volatile.LoadUint32(&o.FP_CIDR1.Reg) & 0xf
}
func (o *FPB_Type) SetFP_CIDR1_CLASS(value uint32) {
	volatile.StoreUint32(&o.FP_CIDR1.Reg, volatile.LoadUint32(&o.FP_CIDR1.Reg)&^(0xf0)|value<<4)
}
func (o *FPB_Type) GetFP_CIDR1_CLASS() uint32 {
	return (volatile.LoadUint32(&o.FP_CIDR1.Reg) & 0xf0) >> 4
}

// FPB.FP_CIDR2: FP Component Identification Register 2
func (o *FPB_Type) SetFP_CIDR2_PRMBL_2(value uint32) {
	volatile.StoreUint32(&o.FP_CIDR2.Reg, volatile.LoadUint32(&o.FP_CIDR2.Reg)&^(0xff)|value)
}
func (o *FPB_Type) GetFP_CIDR2_PRMBL_2() uint32 {
	return volatile.LoadUint32(&o.FP_CIDR2.Reg) & 0xff
}

// FPB.FP_CIDR3: FP Component Identification Register 3
func (o *FPB_Type) SetFP_CIDR3_PRMBL_3(value uint32) {
	volatile.StoreUint32(&o.FP_CIDR3.Reg, volatile.LoadUint32(&o.FP_CIDR3.Reg)&^(0xff)|value)
}
func (o *FPB_Type) GetFP_CIDR3_PRMBL_3() uint32 {
	return volatile.LoadUint32(&o.FP_CIDR3.Reg) & 0xff
}

// Implementation Control Block
type ICB_Type struct {
	_     [4]byte
	ICTR  volatile.Register32 // 0x4
	ACTLR volatile.Register32 // 0x8
}

// ICB.ICTR: Interrupt Controller Type Register
func (o *ICB_Type) SetICTR_INTLINESNUM(value uint32) {
	volatile.StoreUint32(&o.ICTR.Reg, volatile.LoadUint32(&o.ICTR.Reg)&^(0xf)|value)
}
func (o *ICB_Type) GetICTR_INTLINESNUM() uint32 {
	return volatile.LoadUint32(&o.ICTR.Reg) & 0xf
}

// Memory Protection Unit
type MPU_Type struct {
	MPU_TYPE  volatile.Register32 // 0x0
	MPU_CTRL  volatile.Register32 // 0x4
	MPU_RNR   volatile.Register32 // 0x8
	MPU_RBAR  volatile.Register32 // 0xC
	MPU_RLAR  volatile.Register32 // 0x10
	_         [28]byte
	MPU_MAIR0 volatile.Register32 // 0x30
	MPU_MAIR1 volatile.Register32 // 0x34
}

// MPU.MPU_TYPE: MPU Type Register
func (o *MPU_Type) SetMPU_TYPE_SEPARATE(value uint32) {
	volatile.StoreUint32(&o.MPU_TYPE.Reg, volatile.LoadUint32(&o.MPU_TYPE.Reg)&^(0x1)|value)
}
func (o *MPU_Type) GetMPU_TYPE_SEPARATE() uint32 {
	return volatile.LoadUint32(&o.MPU_TYPE.Reg) & 0x1
}
func (o *MPU_Type) SetMPU_TYPE_DREGION(value uint32) {
	volatile.StoreUint32(&o.MPU_TYPE.Reg, volatile.LoadUint32(&o.MPU_TYPE.Reg)&^(0xff00)|value<<8)
}
func (o *MPU_Type) GetMPU_TYPE_DREGION() uint32 {
	return (volatile.LoadUint32(&o.MPU_TYPE.Reg) & 0xff00) >> 8
}

// MPU.MPU_CTRL: MPU Control Register
func (o *MPU_Type) SetMPU_CTRL_ENABLE(value uint32) {
	volatile.StoreUint32(&o.MPU_CTRL.Reg, volatile.LoadUint32(&o.MPU_CTRL.Reg)&^(0x1)|value)
}
func (o *MPU_Type) GetMPU_CTRL_ENABLE() uint32 {
	return volatile.LoadUint32(&o.MPU_CTRL.Reg) & 0x1
}
func (o *MPU_Type) SetMPU_CTRL_HFNMIENA(value uint32) {
	volatile.StoreUint32(&o.MPU_CTRL.Reg, volatile.LoadUint32(&o.MPU_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *MPU_Type) GetMPU_CTRL_HFNMIENA() uint32 {
	return (volatile.LoadUint32(&o.MPU_CTRL.Reg) & 0x2) >> 1
}
func (o *MPU_Type) SetMPU_CTRL_PRIVDEFENA(value uint32) {
	volatile.StoreUint32(&o.MPU_CTRL.Reg, volatile.LoadUint32(&o.MPU_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *MPU_Type) GetMPU_CTRL_PRIVDEFENA() uint32 {
	return (volatile.LoadUint32(&o.MPU_CTRL.Reg) & 0x4) >> 2
}

// MPU.MPU_RNR: MPU Region Number Register
func (o *MPU_Type) SetMPU_RNR_REGION(value uint32) {
	volatile.StoreUint32(&o.MPU_RNR.Reg, volatile.LoadUint32(&o.MPU_RNR.Reg)&^(0xff)|value)
}
func (o *MPU_Type) GetMPU_RNR_REGION() uint32 {
	return volatile.LoadUint32(&o.MPU_RNR.Reg) & 0xff
}

// MPU.MPU_RBAR: MPU Region Base Address Register
func (o *MPU_Type) SetMPU_RBAR_XN(value uint32) {
	volatile.StoreUint32(&o.MPU_RBAR.Reg, volatile.LoadUint32(&o.MPU_RBAR.Reg)&^(0x1)|value)
}
func (o *MPU_Type) GetMPU_RBAR_XN() uint32 {
	return volatile.LoadUint32(&o.MPU_RBAR.Reg) & 0x1
}
func (o *MPU_Type) SetMPU_RBAR_AP(value uint32) {
	volatile.StoreUint32(&o.MPU_RBAR.Reg, volatile.LoadUint32(&o.MPU_RBAR.Reg)&^(0x6)|value<<1)
}
func (o *MPU_Type) GetMPU_RBAR_AP() uint32 {
	return (volatile.LoadUint32(&o.MPU_RBAR.Reg) & 0x6) >> 1
}
func (o *MPU_Type) SetMPU_RBAR_SH(value uint32) {
	volatile.StoreUint32(&o.MPU_RBAR.Reg, volatile.LoadUint32(&o.MPU_RBAR.Reg)&^(0x18)|value<<3)
}
func (o *MPU_Type) GetMPU_RBAR_SH() uint32 {
	return (volatile.LoadUint32(&o.MPU_RBAR.Reg) & 0x18) >> 3
}
func (o *MPU_Type) SetMPU_RBAR_BASE(value uint32) {
	volatile.StoreUint32(&o.MPU_RBAR.Reg, volatile.LoadUint32(&o.MPU_RBAR.Reg)&^(0xffffffe0)|value<<5)
}
func (o *MPU_Type) GetMPU_RBAR_BASE() uint32 {
	return (volatile.LoadUint32(&o.MPU_RBAR.Reg) & 0xffffffe0) >> 5
}

// MPU.MPU_RLAR: MPU Region Limit Address Register
func (o *MPU_Type) SetMPU_RLAR_EN(value uint32) {
	volatile.StoreUint32(&o.MPU_RLAR.Reg, volatile.LoadUint32(&o.MPU_RLAR.Reg)&^(0x1)|value)
}
func (o *MPU_Type) GetMPU_RLAR_EN() uint32 {
	return volatile.LoadUint32(&o.MPU_RLAR.Reg) & 0x1
}
func (o *MPU_Type) SetMPU_RLAR_AttrInd(value uint32) {
	volatile.StoreUint32(&o.MPU_RLAR.Reg, volatile.LoadUint32(&o.MPU_RLAR.Reg)&^(0xe)|value<<1)
}
func (o *MPU_Type) GetMPU_RLAR_AttrInd() uint32 {
	return (volatile.LoadUint32(&o.MPU_RLAR.Reg) & 0xe) >> 1
}
func (o *MPU_Type) SetMPU_RLAR_LIMIT(value uint32) {
	volatile.StoreUint32(&o.MPU_RLAR.Reg, volatile.LoadUint32(&o.MPU_RLAR.Reg)&^(0xffffffe0)|value<<5)
}
func (o *MPU_Type) GetMPU_RLAR_LIMIT() uint32 {
	return (volatile.LoadUint32(&o.MPU_RLAR.Reg) & 0xffffffe0) >> 5
}

// MPU.MPU_MAIR0: MPU Memory Attribute Indirection Register 0
func (o *MPU_Type) SetMPU_MAIR0_Attr0(value uint32) {
	volatile.StoreUint32(&o.MPU_MAIR0.Reg, volatile.LoadUint32(&o.MPU_MAIR0.Reg)&^(0xff)|value)
}
func (o *MPU_Type) GetMPU_MAIR0_Attr0() uint32 {
	return volatile.LoadUint32(&o.MPU_MAIR0.Reg) & 0xff
}
func (o *MPU_Type) SetMPU_MAIR0_Attr1(value uint32) {
	volatile.StoreUint32(&o.MPU_MAIR0.Reg, volatile.LoadUint32(&o.MPU_MAIR0.Reg)&^(0xff00)|value<<8)
}
func (o *MPU_Type) GetMPU_MAIR0_Attr1() uint32 {
	return (volatile.LoadUint32(&o.MPU_MAIR0.Reg) & 0xff00) >> 8
}
func (o *MPU_Type) SetMPU_MAIR0_Attr2(value uint32) {
	volatile.StoreUint32(&o.MPU_MAIR0.Reg, volatile.LoadUint32(&o.MPU_MAIR0.Reg)&^(0xff0000)|value<<16)
}
func (o *MPU_Type) GetMPU_MAIR0_Attr2() uint32 {
	return (volatile.LoadUint32(&o.MPU_MAIR0.Reg) & 0xff0000) >> 16
}
func (o *MPU_Type) SetMPU_MAIR0_Attr3(value uint32) {
	volatile.StoreUint32(&o.MPU_MAIR0.Reg, volatile.LoadUint32(&o.MPU_MAIR0.Reg)&^(0xff000000)|value<<24)
}
func (o *MPU_Type) GetMPU_MAIR0_Attr3() uint32 {
	return (volatile.LoadUint32(&o.MPU_MAIR0.Reg) & 0xff000000) >> 24
}

// Nested Vectored Interrupt Controller
type NVIC_Type struct {
	NVIC_ISER [2]volatile.Register32 // 0x0
	_         [120]byte
	NVIC_ICER [2]volatile.Register32 // 0x80
	_         [120]byte
	NVIC_ISPR [2]volatile.Register32 // 0x100
	_         [120]byte
	NVIC_ICPR [2]volatile.Register32 // 0x180
	_         [120]byte
	NVIC_IABR [2]volatile.Register32 // 0x200
	_         [120]byte
	NVIC_ITNS [2]volatile.Register32 // 0x280
	_         [120]byte
	NVIC_IPR  [12]volatile.Register32 // 0x300
}

// NVIC.NVIC_ISER: Interrupt Set Enable Register n
func (o *NVIC_Type) SetNVIC_ISER(idx int, value uint32) {
	volatile.StoreUint32(&o.NVIC_ISER[idx].Reg, value)
}
func (o *NVIC_Type) GetNVIC_ISER(idx int) uint32 {
	return volatile.LoadUint32(&o.NVIC_ISER[idx].Reg)
}

// NVIC.NVIC_ICER: Interrupt Clear Enable Register n
func (o *NVIC_Type) SetNVIC_ICER(idx int, value uint32) {
	volatile.StoreUint32(&o.NVIC_ICER[idx].Reg, value)
}
func (o *NVIC_Type) GetNVIC_ICER(idx int) uint32 {
	return volatile.LoadUint32(&o.NVIC_ICER[idx].Reg)
}

// NVIC.NVIC_ISPR: Interrupt Set Pending Register n
func (o *NVIC_Type) SetNVIC_ISPR(idx int, value uint32) {
	volatile.StoreUint32(&o.NVIC_ISPR[idx].Reg, value)
}
func (o *NVIC_Type) GetNVIC_ISPR(idx int) uint32 {
	return volatile.LoadUint32(&o.NVIC_ISPR[idx].Reg)
}

// NVIC.NVIC_ICPR: Interrupt Clear Pending Register n
func (o *NVIC_Type) SetNVIC_ICPR(idx int, value uint32) {
	volatile.StoreUint32(&o.NVIC_ICPR[idx].Reg, value)
}
func (o *NVIC_Type) GetNVIC_ICPR(idx int) uint32 {
	return volatile.LoadUint32(&o.NVIC_ICPR[idx].Reg)
}

// NVIC.NVIC_IABR: Interrupt Active Bit Register n
func (o *NVIC_Type) SetNVIC_IABR(idx int, value uint32) {
	volatile.StoreUint32(&o.NVIC_IABR[idx].Reg, value)
}
func (o *NVIC_Type) GetNVIC_IABR(idx int) uint32 {
	return volatile.LoadUint32(&o.NVIC_IABR[idx].Reg)
}

// NVIC.NVIC_ITNS: Interrupt Target Non-secure Register n
func (o *NVIC_Type) SetNVIC_ITNS(idx int, value uint32) {
	volatile.StoreUint32(&o.NVIC_ITNS[idx].Reg, value)
}
func (o *NVIC_Type) GetNVIC_ITNS(idx int) uint32 {
	return volatile.LoadUint32(&o.NVIC_ITNS[idx].Reg)
}

// NVIC.NVIC_IPR: Interrupt Priority Register n
func (o *NVIC_Type) SetNVIC_IPR_PRI_N0(idx int, value uint32) {
	volatile.StoreUint32(&o.NVIC_IPR[idx].Reg, volatile.LoadUint32(&o.NVIC_IPR[idx].Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetNVIC_IPR_PRI_N0(idx int) uint32 {
	return volatile.LoadUint32(&o.NVIC_IPR[idx].Reg) & 0xff
}
func (o *NVIC_Type) SetNVIC_IPR_PRI_N1(idx int, value uint32) {
	volatile.StoreUint32(&o.NVIC_IPR[idx].Reg, volatile.LoadUint32(&o.NVIC_IPR[idx].Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetNVIC_IPR_PRI_N1(idx int) uint32 {
	return (volatile.LoadUint32(&o.NVIC_IPR[idx].Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetNVIC_IPR_PRI_N2(idx int, value uint32) {
	volatile.StoreUint32(&o.NVIC_IPR[idx].Reg, volatile.LoadUint32(&o.NVIC_IPR[idx].Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetNVIC_IPR_PRI_N2(idx int) uint32 {
	return (volatile.LoadUint32(&o.NVIC_IPR[idx].Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetNVIC_IPR_PRI_N3(idx int, value uint32) {
	volatile.StoreUint32(&o.NVIC_IPR[idx].Reg, volatile.LoadUint32(&o.NVIC_IPR[idx].Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetNVIC_IPR_PRI_N3(idx int) uint32 {
	return (volatile.LoadUint32(&o.NVIC_IPR[idx].Reg) & 0xff000000) >> 24
}

// System Control Block
type SCB_Type struct {
	CPUID  volatile.Register32 // 0x0
	ICSR   volatile.Register32 // 0x4
	VTOR   volatile.Register32 // 0x8
	AIRCR  volatile.Register32 // 0xC
	SCR    volatile.Register32 // 0x10
	CCR    volatile.Register32 // 0x14
	_      [4]byte
	SHPR2  volatile.Register32 // 0x1C
	SHPR3  volatile.Register32 // 0x20
	SHCSR  volatile.Register32 // 0x24
	_      [8]byte
	DFSR   volatile.Register32 // 0x30
	_      [8]byte
	AFSR   volatile.Register32 // 0x3C
	_      [56]byte
	CLIDR  volatile.Register32 // 0x78
	CTR    volatile.Register32 // 0x7C
	CCSIDR volatile.Register32 // 0x80
	CSSELR volatile.Register32 // 0x84
}

// SCB.CPUID: CPUID base register
func (o *SCB_Type) SetCPUID_Revision(value uint32) {
	volatile.StoreUint32(&o.CPUID.Reg, volatile.LoadUint32(&o.CPUID.Reg)&^(0xf)|value)
}
func (o *SCB_Type) GetCPUID_Revision() uint32 {
	return volatile.LoadUint32(&o.CPUID.Reg) & 0xf
}
func (o *SCB_Type) SetCPUID_PartNo(value uint32) {
	volatile.StoreUint32(&o.CPUID.Reg, volatile.LoadUint32(&o.CPUID.Reg)&^(0xfff0)|value<<4)
}
func (o *SCB_Type) GetCPUID_PartNo() uint32 {
	return (volatile.LoadUint32(&o.CPUID.Reg) & 0xfff0) >> 4
}
func (o *SCB_Type) SetCPUID_Architecture(value uint32) {
	volatile.StoreUint32(&o.CPUID.Reg, volatile.LoadUint32(&o.CPUID.Reg)&^(0xf0000)|value<<16)
}
func (o *SCB_Type) GetCPUID_Architecture() uint32 {
	return (volatile.LoadUint32(&o.CPUID.Reg) & 0xf0000) >> 16
}
func (o *SCB_Type) SetCPUID_Variant(value uint32) {
	volatile.StoreUint32(&o.CPUID.Reg, volatile.LoadUint32(&o.CPUID.Reg)&^(0xf00000)|value<<20)
}
func (o *SCB_Type) GetCPUID_Variant() uint32 {
	return (volatile.LoadUint32(&o.CPUID.Reg) & 0xf00000) >> 20
}
func (o *SCB_Type) SetCPUID_Implementer(value uint32) {
	volatile.StoreUint32(&o.CPUID.Reg, volatile.LoadUint32(&o.CPUID.Reg)&^(0xff000000)|value<<24)
}
func (o *SCB_Type) GetCPUID_Implementer() uint32 {
	return (volatile.LoadUint32(&o.CPUID.Reg) & 0xff000000) >> 24
}

// SCB.ICSR: Interrupt Control and State Register
func (o *SCB_Type) SetICSR_VECTACTIVE(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x1ff)|value)
}
func (o *SCB_Type) GetICSR_VECTACTIVE() uint32 {
	return volatile.LoadUint32(&o.ICSR.Reg) & 0x1ff
}
func (o *SCB_Type) SetICSR_RETTOBASE(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x800)|value<<11)
}
func (o *SCB_Type) GetICSR_RETTOBASE() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x800) >> 11
}
func (o *SCB_Type) SetICSR_VECTPENDING(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x1ff000)|value<<12)
}
func (o *SCB_Type) GetICSR_VECTPENDING() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x1ff000) >> 12
}
func (o *SCB_Type) SetICSR_ISRPENDING(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x400000)|value<<22)
}
func (o *SCB_Type) GetICSR_ISRPENDING() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x400000) >> 22
}
func (o *SCB_Type) SetICSR_ISRPREEMPT(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x800000)|value<<23)
}
func (o *SCB_Type) GetICSR_ISRPREEMPT() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x800000) >> 23
}
func (o *SCB_Type) SetICSR_PENDSTCLR(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x2000000)|value<<25)
}
func (o *SCB_Type) GetICSR_PENDSTCLR() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x2000000) >> 25
}
func (o *SCB_Type) SetICSR_PENDSTSET(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x4000000)|value<<26)
}
func (o *SCB_Type) GetICSR_PENDSTSET() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x4000000) >> 26
}
func (o *SCB_Type) SetICSR_PENDSVCLR(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x8000000)|value<<27)
}
func (o *SCB_Type) GetICSR_PENDSVCLR() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x8000000) >> 27
}
func (o *SCB_Type) SetICSR_PENDSVSET(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x10000000)|value<<28)
}
func (o *SCB_Type) GetICSR_PENDSVSET() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x10000000) >> 28
}
func (o *SCB_Type) SetICSR_PENDNMICLR(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x40000000)|value<<30)
}
func (o *SCB_Type) GetICSR_PENDNMICLR() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x40000000) >> 30
}
func (o *SCB_Type) SetICSR_PENDNMISET(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x80000000)|value<<31)
}
func (o *SCB_Type) GetICSR_PENDNMISET() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x80000000) >> 31
}

// SCB.VTOR: Vector Table Offset Register
func (o *SCB_Type) SetVTOR_TBLOFF(value uint32) {
	volatile.StoreUint32(&o.VTOR.Reg, volatile.LoadUint32(&o.VTOR.Reg)&^(0xffffff80)|value<<7)
}
func (o *SCB_Type) GetVTOR_TBLOFF() uint32 {
	return (volatile.LoadUint32(&o.VTOR.Reg) & 0xffffff80) >> 7
}

// SCB.AIRCR: Application Interrupt and Reset Control Register
func (o *SCB_Type) SetAIRCR_VECTCLRACTIVE(value uint32) {
	volatile.StoreUint32(&o.AIRCR.Reg, volatile.LoadUint32(&o.AIRCR.Reg)&^(0x2)|value<<1)
}
func (o *SCB_Type) GetAIRCR_VECTCLRACTIVE() uint32 {
	return (volatile.LoadUint32(&o.AIRCR.Reg) & 0x2) >> 1
}
func (o *SCB_Type) SetAIRCR_SYSRESETREQ(value uint32) {
	volatile.StoreUint32(&o.AIRCR.Reg, volatile.LoadUint32(&o.AIRCR.Reg)&^(0x4)|value<<2)
}
func (o *SCB_Type) GetAIRCR_SYSRESETREQ() uint32 {
	return (volatile.LoadUint32(&o.AIRCR.Reg) & 0x4) >> 2
}
func (o *SCB_Type) SetAIRCR_SYSRESETREQS(value uint32) {
	volatile.StoreUint32(&o.AIRCR.Reg, volatile.LoadUint32(&o.AIRCR.Reg)&^(0x8)|value<<3)
}
func (o *SCB_Type) GetAIRCR_SYSRESETREQS() uint32 {
	return (volatile.LoadUint32(&o.AIRCR.Reg) & 0x8) >> 3
}
func (o *SCB_Type) SetAIRCR_BFHFNMINS(value uint32) {
	volatile.StoreUint32(&o.AIRCR.Reg, volatile.LoadUint32(&o.AIRCR.Reg)&^(0x2000)|value<<13)
}
func (o *SCB_Type) GetAIRCR_BFHFNMINS() uint32 {
	return (volatile.LoadUint32(&o.AIRCR.Reg) & 0x2000) >> 13
}
func (o *SCB_Type) SetAIRCR_PRIS(value uint32) {
	volatile.StoreUint32(&o.AIRCR.Reg, volatile.LoadUint32(&o.AIRCR.Reg)&^(0x4000)|value<<14)
}
func (o *SCB_Type) GetAIRCR_PRIS() uint32 {
	return (volatile.LoadUint32(&o.AIRCR.Reg) & 0x4000) >> 14
}
func (o *SCB_Type) SetAIRCR_ENDIANNESS(value uint32) {
	volatile.StoreUint32(&o.AIRCR.Reg, volatile.LoadUint32(&o.AIRCR.Reg)&^(0x8000)|value<<15)
}
func (o *SCB_Type) GetAIRCR_ENDIANNESS() uint32 {
	return (volatile.LoadUint32(&o.AIRCR.Reg) & 0x8000) >> 15
}
func (o *SCB_Type) SetAIRCR_VECTKEY(value uint32) {
	volatile.StoreUint32(&o.AIRCR.Reg, volatile.LoadUint32(&o.AIRCR.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCB_Type) GetAIRCR_VECTKEY() uint32 {
	return (volatile.LoadUint32(&o.AIRCR.Reg) & 0xffff0000) >> 16
}

// SCB.SCR: System Control Register
func (o *SCB_Type) SetSCR_SLEEPONEXIT(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x2)|value<<1)
}
func (o *SCB_Type) GetSCR_SLEEPONEXIT() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x2) >> 1
}
func (o *SCB_Type) SetSCR_SLEEPDEEP(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x4)|value<<2)
}
func (o *SCB_Type) GetSCR_SLEEPDEEP() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x4) >> 2
}
func (o *SCB_Type) SetSCR_SLEEPDEEPS(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x8)|value<<3)
}
func (o *SCB_Type) GetSCR_SLEEPDEEPS() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x8) >> 3
}
func (o *SCB_Type) SetSCR_SEVONPEND(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x10)|value<<4)
}
func (o *SCB_Type) GetSCR_SEVONPEND() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x10) >> 4
}

// SCB.CCR: Configuration and Control Register
func (o *SCB_Type) SetCCR_USERSETMPEND(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x2)|value<<1)
}
func (o *SCB_Type) GetCCR_USERSETMPEND() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x2) >> 1
}
func (o *SCB_Type) SetCCR_UNALIGN_TRP(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x8)|value<<3)
}
func (o *SCB_Type) GetCCR_UNALIGN_TRP() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x8) >> 3
}
func (o *SCB_Type) SetCCR_DIV_0_TRP(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x10)|value<<4)
}
func (o *SCB_Type) GetCCR_DIV_0_TRP() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x10) >> 4
}
func (o *SCB_Type) SetCCR_BFHFNMIGN(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x100)|value<<8)
}
func (o *SCB_Type) GetCCR_BFHFNMIGN() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x100) >> 8
}
func (o *SCB_Type) SetCCR_STKOFHFNMIGN(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x400)|value<<10)
}
func (o *SCB_Type) GetCCR_STKOFHFNMIGN() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x400) >> 10
}
func (o *SCB_Type) SetCCR_DC(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x10000)|value<<16)
}
func (o *SCB_Type) GetCCR_DC() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x10000) >> 16
}
func (o *SCB_Type) SetCCR_IC(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x20000)|value<<17)
}
func (o *SCB_Type) GetCCR_IC() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x20000) >> 17
}
func (o *SCB_Type) SetCCR_BP(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x40000)|value<<18)
}
func (o *SCB_Type) GetCCR_BP() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x40000) >> 18
}

// SCB.SHPR2: System Handler Priority Register 2
func (o *SCB_Type) SetSHPR2_PRI_11(value uint32) {
	volatile.StoreUint32(&o.SHPR2.Reg, volatile.LoadUint32(&o.SHPR2.Reg)&^(0xff000000)|value<<24)
}
func (o *SCB_Type) GetSHPR2_PRI_11() uint32 {
	return (volatile.LoadUint32(&o.SHPR2.Reg) & 0xff000000) >> 24
}

// SCB.SHPR3: System Handler Priority Register 3
func (o *SCB_Type) SetSHPR3_PRI_12(value uint32) {
	volatile.StoreUint32(&o.SHPR3.Reg, volatile.LoadUint32(&o.SHPR3.Reg)&^(0xff)|value)
}
func (o *SCB_Type) GetSHPR3_PRI_12() uint32 {
	return volatile.LoadUint32(&o.SHPR3.Reg) & 0xff
}
func (o *SCB_Type) SetSHPR3_PRI_14(value uint32) {
	volatile.StoreUint32(&o.SHPR3.Reg, volatile.LoadUint32(&o.SHPR3.Reg)&^(0xff0000)|value<<16)
}
func (o *SCB_Type) GetSHPR3_PRI_14() uint32 {
	return (volatile.LoadUint32(&o.SHPR3.Reg) & 0xff0000) >> 16
}
func (o *SCB_Type) SetSHPR3_PRI_15(value uint32) {
	volatile.StoreUint32(&o.SHPR3.Reg, volatile.LoadUint32(&o.SHPR3.Reg)&^(0xff000000)|value<<24)
}
func (o *SCB_Type) GetSHPR3_PRI_15() uint32 {
	return (volatile.LoadUint32(&o.SHPR3.Reg) & 0xff000000) >> 24
}

// SCB.SHCSR: System Handler Control and State Register
func (o *SCB_Type) SetSHCSR_HARDFAULTACT(value uint32) {
	volatile.StoreUint32(&o.SHCSR.Reg, volatile.LoadUint32(&o.SHCSR.Reg)&^(0x4)|value<<2)
}
func (o *SCB_Type) GetSHCSR_HARDFAULTACT() uint32 {
	return (volatile.LoadUint32(&o.SHCSR.Reg) & 0x4) >> 2
}
func (o *SCB_Type) SetSHCSR_NMIACT(value uint32) {
	volatile.StoreUint32(&o.SHCSR.Reg, volatile.LoadUint32(&o.SHCSR.Reg)&^(0x20)|value<<5)
}
func (o *SCB_Type) GetSHCSR_NMIACT() uint32 {
	return (volatile.LoadUint32(&o.SHCSR.Reg) & 0x20) >> 5
}
func (o *SCB_Type) SetSHCSR_SVCALLACT(value uint32) {
	volatile.StoreUint32(&o.SHCSR.Reg, volatile.LoadUint32(&o.SHCSR.Reg)&^(0x80)|value<<7)
}
func (o *SCB_Type) GetSHCSR_SVCALLACT() uint32 {
	return (volatile.LoadUint32(&o.SHCSR.Reg) & 0x80) >> 7
}
func (o *SCB_Type) SetSHCSR_PENDSVACT(value uint32) {
	volatile.StoreUint32(&o.SHCSR.Reg, volatile.LoadUint32(&o.SHCSR.Reg)&^(0x400)|value<<10)
}
func (o *SCB_Type) GetSHCSR_PENDSVACT() uint32 {
	return (volatile.LoadUint32(&o.SHCSR.Reg) & 0x400) >> 10
}
func (o *SCB_Type) SetSHCSR_SYSTICKACT(value uint32) {
	volatile.StoreUint32(&o.SHCSR.Reg, volatile.LoadUint32(&o.SHCSR.Reg)&^(0x800)|value<<11)
}
func (o *SCB_Type) GetSHCSR_SYSTICKACT() uint32 {
	return (volatile.LoadUint32(&o.SHCSR.Reg) & 0x800) >> 11
}
func (o *SCB_Type) SetSHCSR_SVCALLPENDED(value uint32) {
	volatile.StoreUint32(&o.SHCSR.Reg, volatile.LoadUint32(&o.SHCSR.Reg)&^(0x8000)|value<<15)
}
func (o *SCB_Type) GetSHCSR_SVCALLPENDED() uint32 {
	return (volatile.LoadUint32(&o.SHCSR.Reg) & 0x8000) >> 15
}
func (o *SCB_Type) SetSHCSR_HARDFAULTPENDED(value uint32) {
	volatile.StoreUint32(&o.SHCSR.Reg, volatile.LoadUint32(&o.SHCSR.Reg)&^(0x200000)|value<<21)
}
func (o *SCB_Type) GetSHCSR_HARDFAULTPENDED() uint32 {
	return (volatile.LoadUint32(&o.SHCSR.Reg) & 0x200000) >> 21
}

// SCB.DFSR: Debug Fault Status Register
func (o *SCB_Type) SetDFSR_HALTED(value uint32) {
	volatile.StoreUint32(&o.DFSR.Reg, volatile.LoadUint32(&o.DFSR.Reg)&^(0x1)|value)
}
func (o *SCB_Type) GetDFSR_HALTED() uint32 {
	return volatile.LoadUint32(&o.DFSR.Reg) & 0x1
}
func (o *SCB_Type) SetDFSR_BKPT(value uint32) {
	volatile.StoreUint32(&o.DFSR.Reg, volatile.LoadUint32(&o.DFSR.Reg)&^(0x2)|value<<1)
}
func (o *SCB_Type) GetDFSR_BKPT() uint32 {
	return (volatile.LoadUint32(&o.DFSR.Reg) & 0x2) >> 1
}
func (o *SCB_Type) SetDFSR_DWTTRAP(value uint32) {
	volatile.StoreUint32(&o.DFSR.Reg, volatile.LoadUint32(&o.DFSR.Reg)&^(0x4)|value<<2)
}
func (o *SCB_Type) GetDFSR_DWTTRAP() uint32 {
	return (volatile.LoadUint32(&o.DFSR.Reg) & 0x4) >> 2
}
func (o *SCB_Type) SetDFSR_VCATCH(value uint32) {
	volatile.StoreUint32(&o.DFSR.Reg, volatile.LoadUint32(&o.DFSR.Reg)&^(0x8)|value<<3)
}
func (o *SCB_Type) GetDFSR_VCATCH() uint32 {
	return (volatile.LoadUint32(&o.DFSR.Reg) & 0x8) >> 3
}
func (o *SCB_Type) SetDFSR_EXTERNAL(value uint32) {
	volatile.StoreUint32(&o.DFSR.Reg, volatile.LoadUint32(&o.DFSR.Reg)&^(0x10)|value<<4)
}
func (o *SCB_Type) GetDFSR_EXTERNAL() uint32 {
	return (volatile.LoadUint32(&o.DFSR.Reg) & 0x10) >> 4
}

// SCB.CLIDR: Cache Level ID Register
func (o *SCB_Type) SetCLIDR_Ctype1(value uint32) {
	volatile.StoreUint32(&o.CLIDR.Reg, volatile.LoadUint32(&o.CLIDR.Reg)&^(0x7)|value)
}
func (o *SCB_Type) GetCLIDR_Ctype1() uint32 {
	return volatile.LoadUint32(&o.CLIDR.Reg) & 0x7
}
func (o *SCB_Type) SetCLIDR_Ctype2(value uint32) {
	volatile.StoreUint32(&o.CLIDR.Reg, volatile.LoadUint32(&o.CLIDR.Reg)&^(0x38)|value<<3)
}
func (o *SCB_Type) GetCLIDR_Ctype2() uint32 {
	return (volatile.LoadUint32(&o.CLIDR.Reg) & 0x38) >> 3
}
func (o *SCB_Type) SetCLIDR_Ctype3(value uint32) {
	volatile.StoreUint32(&o.CLIDR.Reg, volatile.LoadUint32(&o.CLIDR.Reg)&^(0x1c0)|value<<6)
}
func (o *SCB_Type) GetCLIDR_Ctype3() uint32 {
	return (volatile.LoadUint32(&o.CLIDR.Reg) & 0x1c0) >> 6
}
func (o *SCB_Type) SetCLIDR_Ctype4(value uint32) {
	volatile.StoreUint32(&o.CLIDR.Reg, volatile.LoadUint32(&o.CLIDR.Reg)&^(0xe00)|value<<9)
}
func (o *SCB_Type) GetCLIDR_Ctype4() uint32 {
	return (volatile.LoadUint32(&o.CLIDR.Reg) & 0xe00) >> 9
}
func (o *SCB_Type) SetCLIDR_Ctype5(value uint32) {
	volatile.StoreUint32(&o.CLIDR.Reg, volatile.LoadUint32(&o.CLIDR.Reg)&^(0x7000)|value<<12)
}
func (o *SCB_Type) GetCLIDR_Ctype5() uint32 {
	return (volatile.LoadUint32(&o.CLIDR.Reg) & 0x7000) >> 12
}
func (o *SCB_Type) SetCLIDR_Ctype6(value uint32) {
	volatile.StoreUint32(&o.CLIDR.Reg, volatile.LoadUint32(&o.CLIDR.Reg)&^(0x38000)|value<<15)
}
func (o *SCB_Type) GetCLIDR_Ctype6() uint32 {
	return (volatile.LoadUint32(&o.CLIDR.Reg) & 0x38000) >> 15
}
func (o *SCB_Type) SetCLIDR_Ctype7(value uint32) {
	volatile.StoreUint32(&o.CLIDR.Reg, volatile.LoadUint32(&o.CLIDR.Reg)&^(0x1c0000)|value<<18)
}
func (o *SCB_Type) GetCLIDR_Ctype7() uint32 {
	return (volatile.LoadUint32(&o.CLIDR.Reg) & 0x1c0000) >> 18
}
func (o *SCB_Type) SetCLIDR_LoUIS(value uint32) {
	volatile.StoreUint32(&o.CLIDR.Reg, volatile.LoadUint32(&o.CLIDR.Reg)&^(0xe00000)|value<<21)
}
func (o *SCB_Type) GetCLIDR_LoUIS() uint32 {
	return (volatile.LoadUint32(&o.CLIDR.Reg) & 0xe00000) >> 21
}
func (o *SCB_Type) SetCLIDR_LoC(value uint32) {
	volatile.StoreUint32(&o.CLIDR.Reg, volatile.LoadUint32(&o.CLIDR.Reg)&^(0x7000000)|value<<24)
}
func (o *SCB_Type) GetCLIDR_LoC() uint32 {
	return (volatile.LoadUint32(&o.CLIDR.Reg) & 0x7000000) >> 24
}
func (o *SCB_Type) SetCLIDR_LoUU(value uint32) {
	volatile.StoreUint32(&o.CLIDR.Reg, volatile.LoadUint32(&o.CLIDR.Reg)&^(0x38000000)|value<<27)
}
func (o *SCB_Type) GetCLIDR_LoUU() uint32 {
	return (volatile.LoadUint32(&o.CLIDR.Reg) & 0x38000000) >> 27
}
func (o *SCB_Type) SetCLIDR_ICB(value uint32) {
	volatile.StoreUint32(&o.CLIDR.Reg, volatile.LoadUint32(&o.CLIDR.Reg)&^(0xc0000000)|value<<30)
}
func (o *SCB_Type) GetCLIDR_ICB() uint32 {
	return (volatile.LoadUint32(&o.CLIDR.Reg) & 0xc0000000) >> 30
}

// SCB.CTR: Cache Type Register
func (o *SCB_Type) SetCTR_IminLine(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0xf)|value)
}
func (o *SCB_Type) GetCTR_IminLine() uint32 {
	return volatile.LoadUint32(&o.CTR.Reg) & 0xf
}
func (o *SCB_Type) SetCTR_DminLine(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0xf0000)|value<<16)
}
func (o *SCB_Type) GetCTR_DminLine() uint32 {
	return (volatile.LoadUint32(&o.CTR.Reg) & 0xf0000) >> 16
}
func (o *SCB_Type) SetCTR_ERG(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0xf00000)|value<<20)
}
func (o *SCB_Type) GetCTR_ERG() uint32 {
	return (volatile.LoadUint32(&o.CTR.Reg) & 0xf00000) >> 20
}
func (o *SCB_Type) SetCTR_CWG(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0xf000000)|value<<24)
}
func (o *SCB_Type) GetCTR_CWG() uint32 {
	return (volatile.LoadUint32(&o.CTR.Reg) & 0xf000000) >> 24
}
func (o *SCB_Type) SetCTR_Format(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0xe0000000)|value<<29)
}
func (o *SCB_Type) GetCTR_Format() uint32 {
	return (volatile.LoadUint32(&o.CTR.Reg) & 0xe0000000) >> 29
}

// SCB.CCSIDR: Current Cache Size ID register
func (o *SCB_Type) SetCCSIDR_LineSize(value uint32) {
	volatile.StoreUint32(&o.CCSIDR.Reg, volatile.LoadUint32(&o.CCSIDR.Reg)&^(0x7)|value)
}
func (o *SCB_Type) GetCCSIDR_LineSize() uint32 {
	return volatile.LoadUint32(&o.CCSIDR.Reg) & 0x7
}
func (o *SCB_Type) SetCCSIDR_Associativity(value uint32) {
	volatile.StoreUint32(&o.CCSIDR.Reg, volatile.LoadUint32(&o.CCSIDR.Reg)&^(0x1ff8)|value<<3)
}
func (o *SCB_Type) GetCCSIDR_Associativity() uint32 {
	return (volatile.LoadUint32(&o.CCSIDR.Reg) & 0x1ff8) >> 3
}
func (o *SCB_Type) SetCCSIDR_NumSets(value uint32) {
	volatile.StoreUint32(&o.CCSIDR.Reg, volatile.LoadUint32(&o.CCSIDR.Reg)&^(0xfffe000)|value<<13)
}
func (o *SCB_Type) GetCCSIDR_NumSets() uint32 {
	return (volatile.LoadUint32(&o.CCSIDR.Reg) & 0xfffe000) >> 13
}
func (o *SCB_Type) SetCCSIDR_WA(value uint32) {
	volatile.StoreUint32(&o.CCSIDR.Reg, volatile.LoadUint32(&o.CCSIDR.Reg)&^(0x10000000)|value<<28)
}
func (o *SCB_Type) GetCCSIDR_WA() uint32 {
	return (volatile.LoadUint32(&o.CCSIDR.Reg) & 0x10000000) >> 28
}
func (o *SCB_Type) SetCCSIDR_RA(value uint32) {
	volatile.StoreUint32(&o.CCSIDR.Reg, volatile.LoadUint32(&o.CCSIDR.Reg)&^(0x20000000)|value<<29)
}
func (o *SCB_Type) GetCCSIDR_RA() uint32 {
	return (volatile.LoadUint32(&o.CCSIDR.Reg) & 0x20000000) >> 29
}
func (o *SCB_Type) SetCCSIDR_WB(value uint32) {
	volatile.StoreUint32(&o.CCSIDR.Reg, volatile.LoadUint32(&o.CCSIDR.Reg)&^(0x40000000)|value<<30)
}
func (o *SCB_Type) GetCCSIDR_WB() uint32 {
	return (volatile.LoadUint32(&o.CCSIDR.Reg) & 0x40000000) >> 30
}
func (o *SCB_Type) SetCCSIDR_WT(value uint32) {
	volatile.StoreUint32(&o.CCSIDR.Reg, volatile.LoadUint32(&o.CCSIDR.Reg)&^(0x80000000)|value<<31)
}
func (o *SCB_Type) GetCCSIDR_WT() uint32 {
	return (volatile.LoadUint32(&o.CCSIDR.Reg) & 0x80000000) >> 31
}

// SCB.CSSELR: Cache Size Selection Register
func (o *SCB_Type) SetCSSELR_InD(value uint32) {
	volatile.StoreUint32(&o.CSSELR.Reg, volatile.LoadUint32(&o.CSSELR.Reg)&^(0x1)|value)
}
func (o *SCB_Type) GetCSSELR_InD() uint32 {
	return volatile.LoadUint32(&o.CSSELR.Reg) & 0x1
}
func (o *SCB_Type) SetCSSELR_Level(value uint32) {
	volatile.StoreUint32(&o.CSSELR.Reg, volatile.LoadUint32(&o.CSSELR.Reg)&^(0xe)|value<<1)
}
func (o *SCB_Type) GetCSSELR_Level() uint32 {
	return (volatile.LoadUint32(&o.CSSELR.Reg) & 0xe) >> 1
}

// SysTick Timer
type SysTick_Type struct {
	SYST_CSR   volatile.Register32 // 0x0
	SYST_RVR   volatile.Register32 // 0x4
	SYST_CVR   volatile.Register32 // 0x8
	SYST_CALIB volatile.Register32 // 0xC
}

// SysTick.SYST_CSR: SysTick Control and Status Register
func (o *SysTick_Type) SetSYST_CSR_ENABLE(value uint32) {
	volatile.StoreUint32(&o.SYST_CSR.Reg, volatile.LoadUint32(&o.SYST_CSR.Reg)&^(0x1)|value)
}
func (o *SysTick_Type) GetSYST_CSR_ENABLE() uint32 {
	return volatile.LoadUint32(&o.SYST_CSR.Reg) & 0x1
}
func (o *SysTick_Type) SetSYST_CSR_TICKINT(value uint32) {
	volatile.StoreUint32(&o.SYST_CSR.Reg, volatile.LoadUint32(&o.SYST_CSR.Reg)&^(0x2)|value<<1)
}
func (o *SysTick_Type) GetSYST_CSR_TICKINT() uint32 {
	return (volatile.LoadUint32(&o.SYST_CSR.Reg) & 0x2) >> 1
}
func (o *SysTick_Type) SetSYST_CSR_CLKSOURCE(value uint32) {
	volatile.StoreUint32(&o.SYST_CSR.Reg, volatile.LoadUint32(&o.SYST_CSR.Reg)&^(0x4)|value<<2)
}
func (o *SysTick_Type) GetSYST_CSR_CLKSOURCE() uint32 {
	return (volatile.LoadUint32(&o.SYST_CSR.Reg) & 0x4) >> 2
}
func (o *SysTick_Type) SetSYST_CSR_COUNTFLAG(value uint32) {
	volatile.StoreUint32(&o.SYST_CSR.Reg, volatile.LoadUint32(&o.SYST_CSR.Reg)&^(0x10000)|value<<16)
}
func (o *SysTick_Type) GetSYST_CSR_COUNTFLAG() uint32 {
	return (volatile.LoadUint32(&o.SYST_CSR.Reg) & 0x10000) >> 16
}

// SysTick.SYST_RVR: SysTick Reload Value Register
func (o *SysTick_Type) SetSYST_RVR_RELOAD(value uint32) {
	volatile.StoreUint32(&o.SYST_RVR.Reg, volatile.LoadUint32(&o.SYST_RVR.Reg)&^(0x1000000)|value<<24)
}
func (o *SysTick_Type) GetSYST_RVR_RELOAD() uint32 {
	return (volatile.LoadUint32(&o.SYST_RVR.Reg) & 0x1000000) >> 24
}

// SysTick.SYST_CVR: SysTick Current Value Register
func (o *SysTick_Type) SetSYST_CVR_CURRENT(value uint32) {
	volatile.StoreUint32(&o.SYST_CVR.Reg, volatile.LoadUint32(&o.SYST_CVR.Reg)&^(0x1000000)|value<<24)
}
func (o *SysTick_Type) GetSYST_CVR_CURRENT() uint32 {
	return (volatile.LoadUint32(&o.SYST_CVR.Reg) & 0x1000000) >> 24
}

// SysTick.SYST_CALIB: SysTick Calibration Value Register
func (o *SysTick_Type) SetSYST_CALIB_TENMS(value uint32) {
	volatile.StoreUint32(&o.SYST_CALIB.Reg, volatile.LoadUint32(&o.SYST_CALIB.Reg)&^(0xffffff)|value)
}
func (o *SysTick_Type) GetSYST_CALIB_TENMS() uint32 {
	return volatile.LoadUint32(&o.SYST_CALIB.Reg) & 0xffffff
}
func (o *SysTick_Type) SetSYST_CALIB_SKEW(value uint32) {
	volatile.StoreUint32(&o.SYST_CALIB.Reg, volatile.LoadUint32(&o.SYST_CALIB.Reg)&^(0x40000000)|value<<30)
}
func (o *SysTick_Type) GetSYST_CALIB_SKEW() uint32 {
	return (volatile.LoadUint32(&o.SYST_CALIB.Reg) & 0x40000000) >> 30
}
func (o *SysTick_Type) SetSYST_CALIB_NOREF(value uint32) {
	volatile.StoreUint32(&o.SYST_CALIB.Reg, volatile.LoadUint32(&o.SYST_CALIB.Reg)&^(0x80000000)|value<<31)
}
func (o *SysTick_Type) GetSYST_CALIB_NOREF() uint32 {
	return (volatile.LoadUint32(&o.SYST_CALIB.Reg) & 0x80000000) >> 31
}

// Constants for AC: Analog Comparators
const (
	// CTRLA: Control A
	// Position of SWRST field.
	AC_CTRLA_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	AC_CTRLA_SWRST_Msk = 0x1
	// Bit SWRST.
	AC_CTRLA_SWRST = 0x1
	// Position of ENABLE field.
	AC_CTRLA_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	AC_CTRLA_ENABLE_Msk = 0x2
	// Bit ENABLE.
	AC_CTRLA_ENABLE = 0x2

	// CTRLB: Control B
	// Position of START0 field.
	AC_CTRLB_START0_Pos = 0x0
	// Bit mask of START0 field.
	AC_CTRLB_START0_Msk = 0x1
	// Bit START0.
	AC_CTRLB_START0 = 0x1
	// Position of START1 field.
	AC_CTRLB_START1_Pos = 0x1
	// Bit mask of START1 field.
	AC_CTRLB_START1_Msk = 0x2
	// Bit START1.
	AC_CTRLB_START1 = 0x2

	// EVCTRL: Event Control
	// Position of COMPEO0 field.
	AC_EVCTRL_COMPEO0_Pos = 0x0
	// Bit mask of COMPEO0 field.
	AC_EVCTRL_COMPEO0_Msk = 0x1
	// Bit COMPEO0.
	AC_EVCTRL_COMPEO0 = 0x1
	// Position of COMPEO1 field.
	AC_EVCTRL_COMPEO1_Pos = 0x1
	// Bit mask of COMPEO1 field.
	AC_EVCTRL_COMPEO1_Msk = 0x2
	// Bit COMPEO1.
	AC_EVCTRL_COMPEO1 = 0x2
	// Position of WINEO0 field.
	AC_EVCTRL_WINEO0_Pos = 0x4
	// Bit mask of WINEO0 field.
	AC_EVCTRL_WINEO0_Msk = 0x10
	// Bit WINEO0.
	AC_EVCTRL_WINEO0 = 0x10
	// Position of COMPEI0 field.
	AC_EVCTRL_COMPEI0_Pos = 0x8
	// Bit mask of COMPEI0 field.
	AC_EVCTRL_COMPEI0_Msk = 0x100
	// Bit COMPEI0.
	AC_EVCTRL_COMPEI0 = 0x100
	// Position of COMPEI1 field.
	AC_EVCTRL_COMPEI1_Pos = 0x9
	// Bit mask of COMPEI1 field.
	AC_EVCTRL_COMPEI1_Msk = 0x200
	// Bit COMPEI1.
	AC_EVCTRL_COMPEI1 = 0x200
	// Position of INVEI0 field.
	AC_EVCTRL_INVEI0_Pos = 0xc
	// Bit mask of INVEI0 field.
	AC_EVCTRL_INVEI0_Msk = 0x1000
	// Bit INVEI0.
	AC_EVCTRL_INVEI0 = 0x1000
	// Position of INVEI1 field.
	AC_EVCTRL_INVEI1_Pos = 0xd
	// Bit mask of INVEI1 field.
	AC_EVCTRL_INVEI1_Msk = 0x2000
	// Bit INVEI1.
	AC_EVCTRL_INVEI1 = 0x2000

	// INTENCLR: Interrupt Enable Clear
	// Position of COMP0 field.
	AC_INTENCLR_COMP0_Pos = 0x0
	// Bit mask of COMP0 field.
	AC_INTENCLR_COMP0_Msk = 0x1
	// Bit COMP0.
	AC_INTENCLR_COMP0 = 0x1
	// Position of COMP1 field.
	AC_INTENCLR_COMP1_Pos = 0x1
	// Bit mask of COMP1 field.
	AC_INTENCLR_COMP1_Msk = 0x2
	// Bit COMP1.
	AC_INTENCLR_COMP1 = 0x2
	// Position of WIN0 field.
	AC_INTENCLR_WIN0_Pos = 0x4
	// Bit mask of WIN0 field.
	AC_INTENCLR_WIN0_Msk = 0x10
	// Bit WIN0.
	AC_INTENCLR_WIN0 = 0x10

	// INTENSET: Interrupt Enable Set
	// Position of COMP0 field.
	AC_INTENSET_COMP0_Pos = 0x0
	// Bit mask of COMP0 field.
	AC_INTENSET_COMP0_Msk = 0x1
	// Bit COMP0.
	AC_INTENSET_COMP0 = 0x1
	// Position of COMP1 field.
	AC_INTENSET_COMP1_Pos = 0x1
	// Bit mask of COMP1 field.
	AC_INTENSET_COMP1_Msk = 0x2
	// Bit COMP1.
	AC_INTENSET_COMP1 = 0x2
	// Position of WIN0 field.
	AC_INTENSET_WIN0_Pos = 0x4
	// Bit mask of WIN0 field.
	AC_INTENSET_WIN0_Msk = 0x10
	// Bit WIN0.
	AC_INTENSET_WIN0 = 0x10

	// INTFLAG: Interrupt Flag Status and Clear
	// Position of COMP0 field.
	AC_INTFLAG_COMP0_Pos = 0x0
	// Bit mask of COMP0 field.
	AC_INTFLAG_COMP0_Msk = 0x1
	// Bit COMP0.
	AC_INTFLAG_COMP0 = 0x1
	// Position of COMP1 field.
	AC_INTFLAG_COMP1_Pos = 0x1
	// Bit mask of COMP1 field.
	AC_INTFLAG_COMP1_Msk = 0x2
	// Bit COMP1.
	AC_INTFLAG_COMP1 = 0x2
	// Position of WIN0 field.
	AC_INTFLAG_WIN0_Pos = 0x4
	// Bit mask of WIN0 field.
	AC_INTFLAG_WIN0_Msk = 0x10
	// Bit WIN0.
	AC_INTFLAG_WIN0 = 0x10

	// STATUSA: Status A
	// Position of STATE0 field.
	AC_STATUSA_STATE0_Pos = 0x0
	// Bit mask of STATE0 field.
	AC_STATUSA_STATE0_Msk = 0x1
	// Bit STATE0.
	AC_STATUSA_STATE0 = 0x1
	// Position of STATE1 field.
	AC_STATUSA_STATE1_Pos = 0x1
	// Bit mask of STATE1 field.
	AC_STATUSA_STATE1_Msk = 0x2
	// Bit STATE1.
	AC_STATUSA_STATE1 = 0x2
	// Position of WSTATE0 field.
	AC_STATUSA_WSTATE0_Pos = 0x4
	// Bit mask of WSTATE0 field.
	AC_STATUSA_WSTATE0_Msk = 0x30
	// Signal is above window
	AC_STATUSA_WSTATE0_ABOVE = 0x0
	// Signal is inside window
	AC_STATUSA_WSTATE0_INSIDE = 0x1
	// Signal is below window
	AC_STATUSA_WSTATE0_BELOW = 0x2

	// STATUSB: Status B
	// Position of READY0 field.
	AC_STATUSB_READY0_Pos = 0x0
	// Bit mask of READY0 field.
	AC_STATUSB_READY0_Msk = 0x1
	// Bit READY0.
	AC_STATUSB_READY0 = 0x1
	// Position of READY1 field.
	AC_STATUSB_READY1_Pos = 0x1
	// Bit mask of READY1 field.
	AC_STATUSB_READY1_Msk = 0x2
	// Bit READY1.
	AC_STATUSB_READY1 = 0x2

	// DBGCTRL: Debug Control
	// Position of DBGRUN field.
	AC_DBGCTRL_DBGRUN_Pos = 0x0
	// Bit mask of DBGRUN field.
	AC_DBGCTRL_DBGRUN_Msk = 0x1
	// Bit DBGRUN.
	AC_DBGCTRL_DBGRUN = 0x1

	// WINCTRL: Window Control
	// Position of WEN0 field.
	AC_WINCTRL_WEN0_Pos = 0x0
	// Bit mask of WEN0 field.
	AC_WINCTRL_WEN0_Msk = 0x1
	// Bit WEN0.
	AC_WINCTRL_WEN0 = 0x1
	// Position of WINTSEL0 field.
	AC_WINCTRL_WINTSEL0_Pos = 0x1
	// Bit mask of WINTSEL0 field.
	AC_WINCTRL_WINTSEL0_Msk = 0x6
	// Interrupt on signal above window
	AC_WINCTRL_WINTSEL0_ABOVE = 0x0
	// Interrupt on signal inside window
	AC_WINCTRL_WINTSEL0_INSIDE = 0x1
	// Interrupt on signal below window
	AC_WINCTRL_WINTSEL0_BELOW = 0x2
	// Interrupt on signal outside window
	AC_WINCTRL_WINTSEL0_OUTSIDE = 0x3

	// SCALER: Scaler n
	// Position of VALUE field.
	AC_SCALER_VALUE_Pos = 0x0
	// Bit mask of VALUE field.
	AC_SCALER_VALUE_Msk = 0x3f

	// COMPCTRL: Comparator Control n
	// Position of ENABLE field.
	AC_COMPCTRL_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	AC_COMPCTRL_ENABLE_Msk = 0x2
	// Bit ENABLE.
	AC_COMPCTRL_ENABLE = 0x2
	// Position of SINGLE field.
	AC_COMPCTRL_SINGLE_Pos = 0x2
	// Bit mask of SINGLE field.
	AC_COMPCTRL_SINGLE_Msk = 0x4
	// Bit SINGLE.
	AC_COMPCTRL_SINGLE = 0x4
	// Position of INTSEL field.
	AC_COMPCTRL_INTSEL_Pos = 0x3
	// Bit mask of INTSEL field.
	AC_COMPCTRL_INTSEL_Msk = 0x18
	// Interrupt on comparator output toggle
	AC_COMPCTRL_INTSEL_TOGGLE = 0x0
	// Interrupt on comparator output rising
	AC_COMPCTRL_INTSEL_RISING = 0x1
	// Interrupt on comparator output falling
	AC_COMPCTRL_INTSEL_FALLING = 0x2
	// Interrupt on end of comparison (single-shot mode only)
	AC_COMPCTRL_INTSEL_EOC = 0x3
	// Position of RUNSTDBY field.
	AC_COMPCTRL_RUNSTDBY_Pos = 0x6
	// Bit mask of RUNSTDBY field.
	AC_COMPCTRL_RUNSTDBY_Msk = 0x40
	// Bit RUNSTDBY.
	AC_COMPCTRL_RUNSTDBY = 0x40
	// Position of MUXNEG field.
	AC_COMPCTRL_MUXNEG_Pos = 0x8
	// Bit mask of MUXNEG field.
	AC_COMPCTRL_MUXNEG_Msk = 0x700
	// I/O pin 0
	AC_COMPCTRL_MUXNEG_PIN0 = 0x0
	// I/O pin 1
	AC_COMPCTRL_MUXNEG_PIN1 = 0x1
	// I/O pin 2
	AC_COMPCTRL_MUXNEG_PIN2 = 0x2
	// I/O pin 3
	AC_COMPCTRL_MUXNEG_PIN3 = 0x3
	// Ground
	AC_COMPCTRL_MUXNEG_GND = 0x4
	// VDD scaler
	AC_COMPCTRL_MUXNEG_VSCALE = 0x5
	// Internal bandgap voltage
	AC_COMPCTRL_MUXNEG_BANDGAP = 0x6
	// OPAMP output (on AC1)
	AC_COMPCTRL_MUXNEG_OPAMP = 0x7
	// DAC output (on AC0)
	AC_COMPCTRL_MUXNEG_DAC = 0x7
	// Position of MUXPOS field.
	AC_COMPCTRL_MUXPOS_Pos = 0xc
	// Bit mask of MUXPOS field.
	AC_COMPCTRL_MUXPOS_Msk = 0x7000
	// I/O pin 0
	AC_COMPCTRL_MUXPOS_PIN0 = 0x0
	// I/O pin 1
	AC_COMPCTRL_MUXPOS_PIN1 = 0x1
	// I/O pin 2
	AC_COMPCTRL_MUXPOS_PIN2 = 0x2
	// I/O pin 3
	AC_COMPCTRL_MUXPOS_PIN3 = 0x3
	// VDD Scaler
	AC_COMPCTRL_MUXPOS_VSCALE = 0x4
	// Position of SWAP field.
	AC_COMPCTRL_SWAP_Pos = 0xf
	// Bit mask of SWAP field.
	AC_COMPCTRL_SWAP_Msk = 0x8000
	// Bit SWAP.
	AC_COMPCTRL_SWAP = 0x8000
	// Position of SPEED field.
	AC_COMPCTRL_SPEED_Pos = 0x10
	// Bit mask of SPEED field.
	AC_COMPCTRL_SPEED_Msk = 0x30000
	// Low speed
	AC_COMPCTRL_SPEED_LOW = 0x0
	// Medium low speed
	AC_COMPCTRL_SPEED_MEDLOW = 0x1
	// Medium high speed
	AC_COMPCTRL_SPEED_MEDHIGH = 0x2
	// High speed
	AC_COMPCTRL_SPEED_HIGH = 0x3
	// Position of HYSTEN field.
	AC_COMPCTRL_HYSTEN_Pos = 0x13
	// Bit mask of HYSTEN field.
	AC_COMPCTRL_HYSTEN_Msk = 0x80000
	// Bit HYSTEN.
	AC_COMPCTRL_HYSTEN = 0x80000
	// Position of HYST field.
	AC_COMPCTRL_HYST_Pos = 0x14
	// Bit mask of HYST field.
	AC_COMPCTRL_HYST_Msk = 0x300000
	// 50mV
	AC_COMPCTRL_HYST_HYST50 = 0x0
	// 70mV
	AC_COMPCTRL_HYST_HYST70 = 0x1
	// 90mV
	AC_COMPCTRL_HYST_HYST90 = 0x2
	// 110mV
	AC_COMPCTRL_HYST_HYST110 = 0x3
	// Position of FLEN field.
	AC_COMPCTRL_FLEN_Pos = 0x18
	// Bit mask of FLEN field.
	AC_COMPCTRL_FLEN_Msk = 0x7000000
	// No filtering
	AC_COMPCTRL_FLEN_OFF = 0x0
	// 3-bit majority function (2 of 3)
	AC_COMPCTRL_FLEN_MAJ3 = 0x1
	// 5-bit majority function (3 of 5)
	AC_COMPCTRL_FLEN_MAJ5 = 0x2
	// Position of OUT field.
	AC_COMPCTRL_OUT_Pos = 0x1c
	// Bit mask of OUT field.
	AC_COMPCTRL_OUT_Msk = 0x30000000
	// The output of COMPn is not routed to the COMPn I/O port
	AC_COMPCTRL_OUT_OFF = 0x0
	// The asynchronous output of COMPn is routed to the COMPn I/O port
	AC_COMPCTRL_OUT_ASYNC = 0x1
	// The synchronous output (including filtering) of COMPn is routed to the COMPn I/O port
	AC_COMPCTRL_OUT_SYNC = 0x2

	// SYNCBUSY: Synchronization Busy
	// Position of SWRST field.
	AC_SYNCBUSY_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	AC_SYNCBUSY_SWRST_Msk = 0x1
	// Bit SWRST.
	AC_SYNCBUSY_SWRST = 0x1
	// Position of ENABLE field.
	AC_SYNCBUSY_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	AC_SYNCBUSY_ENABLE_Msk = 0x2
	// Bit ENABLE.
	AC_SYNCBUSY_ENABLE = 0x2
	// Position of WINCTRL field.
	AC_SYNCBUSY_WINCTRL_Pos = 0x2
	// Bit mask of WINCTRL field.
	AC_SYNCBUSY_WINCTRL_Msk = 0x4
	// Bit WINCTRL.
	AC_SYNCBUSY_WINCTRL = 0x4
	// Position of COMPCTRL0 field.
	AC_SYNCBUSY_COMPCTRL0_Pos = 0x3
	// Bit mask of COMPCTRL0 field.
	AC_SYNCBUSY_COMPCTRL0_Msk = 0x8
	// Bit COMPCTRL0.
	AC_SYNCBUSY_COMPCTRL0 = 0x8
	// Position of COMPCTRL1 field.
	AC_SYNCBUSY_COMPCTRL1_Pos = 0x4
	// Bit mask of COMPCTRL1 field.
	AC_SYNCBUSY_COMPCTRL1_Msk = 0x10
	// Bit COMPCTRL1.
	AC_SYNCBUSY_COMPCTRL1 = 0x10
)

// Constants for ADC: Analog Digital Converter
const (
	// CTRLA: Control A
	// Position of SWRST field.
	ADC_CTRLA_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	ADC_CTRLA_SWRST_Msk = 0x1
	// Bit SWRST.
	ADC_CTRLA_SWRST = 0x1
	// Position of ENABLE field.
	ADC_CTRLA_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	ADC_CTRLA_ENABLE_Msk = 0x2
	// Bit ENABLE.
	ADC_CTRLA_ENABLE = 0x2
	// Position of SLAVEEN field.
	ADC_CTRLA_SLAVEEN_Pos = 0x5
	// Bit mask of SLAVEEN field.
	ADC_CTRLA_SLAVEEN_Msk = 0x20
	// Bit SLAVEEN.
	ADC_CTRLA_SLAVEEN = 0x20
	// Position of RUNSTDBY field.
	ADC_CTRLA_RUNSTDBY_Pos = 0x6
	// Bit mask of RUNSTDBY field.
	ADC_CTRLA_RUNSTDBY_Msk = 0x40
	// Bit RUNSTDBY.
	ADC_CTRLA_RUNSTDBY = 0x40
	// Position of ONDEMAND field.
	ADC_CTRLA_ONDEMAND_Pos = 0x7
	// Bit mask of ONDEMAND field.
	ADC_CTRLA_ONDEMAND_Msk = 0x80
	// Bit ONDEMAND.
	ADC_CTRLA_ONDEMAND = 0x80

	// CTRLB: Control B
	// Position of PRESCALER field.
	ADC_CTRLB_PRESCALER_Pos = 0x0
	// Bit mask of PRESCALER field.
	ADC_CTRLB_PRESCALER_Msk = 0x7
	// Peripheral clock divided by 2
	ADC_CTRLB_PRESCALER_DIV2 = 0x0
	// Peripheral clock divided by 4
	ADC_CTRLB_PRESCALER_DIV4 = 0x1
	// Peripheral clock divided by 8
	ADC_CTRLB_PRESCALER_DIV8 = 0x2
	// Peripheral clock divided by 16
	ADC_CTRLB_PRESCALER_DIV16 = 0x3
	// Peripheral clock divided by 32
	ADC_CTRLB_PRESCALER_DIV32 = 0x4
	// Peripheral clock divided by 64
	ADC_CTRLB_PRESCALER_DIV64 = 0x5
	// Peripheral clock divided by 128
	ADC_CTRLB_PRESCALER_DIV128 = 0x6
	// Peripheral clock divided by 256
	ADC_CTRLB_PRESCALER_DIV256 = 0x7

	// REFCTRL: Reference Control
	// Position of REFSEL field.
	ADC_REFCTRL_REFSEL_Pos = 0x0
	// Bit mask of REFSEL field.
	ADC_REFCTRL_REFSEL_Msk = 0xf
	// Internal Bandgap Reference
	ADC_REFCTRL_REFSEL_INTREF = 0x0
	// 1/1.6 VDDANA
	ADC_REFCTRL_REFSEL_INTVCC0 = 0x1
	// 1/2 VDDANA
	ADC_REFCTRL_REFSEL_INTVCC1 = 0x2
	// External Reference
	ADC_REFCTRL_REFSEL_AREFA = 0x3
	// External Reference
	ADC_REFCTRL_REFSEL_AREFB = 0x4
	// VCCANA
	ADC_REFCTRL_REFSEL_INTVCC2 = 0x5
	// Position of REFCOMP field.
	ADC_REFCTRL_REFCOMP_Pos = 0x7
	// Bit mask of REFCOMP field.
	ADC_REFCTRL_REFCOMP_Msk = 0x80
	// Bit REFCOMP.
	ADC_REFCTRL_REFCOMP = 0x80

	// EVCTRL: Event Control
	// Position of FLUSHEI field.
	ADC_EVCTRL_FLUSHEI_Pos = 0x0
	// Bit mask of FLUSHEI field.
	ADC_EVCTRL_FLUSHEI_Msk = 0x1
	// Bit FLUSHEI.
	ADC_EVCTRL_FLUSHEI = 0x1
	// Position of STARTEI field.
	ADC_EVCTRL_STARTEI_Pos = 0x1
	// Bit mask of STARTEI field.
	ADC_EVCTRL_STARTEI_Msk = 0x2
	// Bit STARTEI.
	ADC_EVCTRL_STARTEI = 0x2
	// Position of FLUSHINV field.
	ADC_EVCTRL_FLUSHINV_Pos = 0x2
	// Bit mask of FLUSHINV field.
	ADC_EVCTRL_FLUSHINV_Msk = 0x4
	// Bit FLUSHINV.
	ADC_EVCTRL_FLUSHINV = 0x4
	// Position of STARTINV field.
	ADC_EVCTRL_STARTINV_Pos = 0x3
	// Bit mask of STARTINV field.
	ADC_EVCTRL_STARTINV_Msk = 0x8
	// Bit STARTINV.
	ADC_EVCTRL_STARTINV = 0x8
	// Position of RESRDYEO field.
	ADC_EVCTRL_RESRDYEO_Pos = 0x4
	// Bit mask of RESRDYEO field.
	ADC_EVCTRL_RESRDYEO_Msk = 0x10
	// Bit RESRDYEO.
	ADC_EVCTRL_RESRDYEO = 0x10
	// Position of WINMONEO field.
	ADC_EVCTRL_WINMONEO_Pos = 0x5
	// Bit mask of WINMONEO field.
	ADC_EVCTRL_WINMONEO_Msk = 0x20
	// Bit WINMONEO.
	ADC_EVCTRL_WINMONEO = 0x20

	// INTENCLR: Interrupt Enable Clear
	// Position of RESRDY field.
	ADC_INTENCLR_RESRDY_Pos = 0x0
	// Bit mask of RESRDY field.
	ADC_INTENCLR_RESRDY_Msk = 0x1
	// Bit RESRDY.
	ADC_INTENCLR_RESRDY = 0x1
	// Position of OVERRUN field.
	ADC_INTENCLR_OVERRUN_Pos = 0x1
	// Bit mask of OVERRUN field.
	ADC_INTENCLR_OVERRUN_Msk = 0x2
	// Bit OVERRUN.
	ADC_INTENCLR_OVERRUN = 0x2
	// Position of WINMON field.
	ADC_INTENCLR_WINMON_Pos = 0x2
	// Bit mask of WINMON field.
	ADC_INTENCLR_WINMON_Msk = 0x4
	// Bit WINMON.
	ADC_INTENCLR_WINMON = 0x4

	// INTENSET: Interrupt Enable Set
	// Position of RESRDY field.
	ADC_INTENSET_RESRDY_Pos = 0x0
	// Bit mask of RESRDY field.
	ADC_INTENSET_RESRDY_Msk = 0x1
	// Bit RESRDY.
	ADC_INTENSET_RESRDY = 0x1
	// Position of OVERRUN field.
	ADC_INTENSET_OVERRUN_Pos = 0x1
	// Bit mask of OVERRUN field.
	ADC_INTENSET_OVERRUN_Msk = 0x2
	// Bit OVERRUN.
	ADC_INTENSET_OVERRUN = 0x2
	// Position of WINMON field.
	ADC_INTENSET_WINMON_Pos = 0x2
	// Bit mask of WINMON field.
	ADC_INTENSET_WINMON_Msk = 0x4
	// Bit WINMON.
	ADC_INTENSET_WINMON = 0x4

	// INTFLAG: Interrupt Flag Status and Clear
	// Position of RESRDY field.
	ADC_INTFLAG_RESRDY_Pos = 0x0
	// Bit mask of RESRDY field.
	ADC_INTFLAG_RESRDY_Msk = 0x1
	// Bit RESRDY.
	ADC_INTFLAG_RESRDY = 0x1
	// Position of OVERRUN field.
	ADC_INTFLAG_OVERRUN_Pos = 0x1
	// Bit mask of OVERRUN field.
	ADC_INTFLAG_OVERRUN_Msk = 0x2
	// Bit OVERRUN.
	ADC_INTFLAG_OVERRUN = 0x2
	// Position of WINMON field.
	ADC_INTFLAG_WINMON_Pos = 0x2
	// Bit mask of WINMON field.
	ADC_INTFLAG_WINMON_Msk = 0x4
	// Bit WINMON.
	ADC_INTFLAG_WINMON = 0x4

	// SEQSTATUS: Sequence Status
	// Position of SEQSTATE field.
	ADC_SEQSTATUS_SEQSTATE_Pos = 0x0
	// Bit mask of SEQSTATE field.
	ADC_SEQSTATUS_SEQSTATE_Msk = 0x1f
	// Position of SEQBUSY field.
	ADC_SEQSTATUS_SEQBUSY_Pos = 0x7
	// Bit mask of SEQBUSY field.
	ADC_SEQSTATUS_SEQBUSY_Msk = 0x80
	// Bit SEQBUSY.
	ADC_SEQSTATUS_SEQBUSY = 0x80

	// INPUTCTRL: Input Control
	// Position of MUXPOS field.
	ADC_INPUTCTRL_MUXPOS_Pos = 0x0
	// Bit mask of MUXPOS field.
	ADC_INPUTCTRL_MUXPOS_Msk = 0x1f
	// ADC AIN0 Pin
	ADC_INPUTCTRL_MUXPOS_AIN0 = 0x0
	// ADC AIN1 Pin
	ADC_INPUTCTRL_MUXPOS_AIN1 = 0x1
	// ADC AIN2 Pin
	ADC_INPUTCTRL_MUXPOS_AIN2 = 0x2
	// ADC AIN3 Pin
	ADC_INPUTCTRL_MUXPOS_AIN3 = 0x3
	// ADC AIN4 Pin
	ADC_INPUTCTRL_MUXPOS_AIN4 = 0x4
	// ADC AIN5 Pin
	ADC_INPUTCTRL_MUXPOS_AIN5 = 0x5
	// ADC AIN6 Pin
	ADC_INPUTCTRL_MUXPOS_AIN6 = 0x6
	// ADC AIN7 Pin
	ADC_INPUTCTRL_MUXPOS_AIN7 = 0x7
	// ADC AIN8 Pin
	ADC_INPUTCTRL_MUXPOS_AIN8 = 0x8
	// ADC AIN9 Pin
	ADC_INPUTCTRL_MUXPOS_AIN9 = 0x9
	// ADC AIN10 Pin
	ADC_INPUTCTRL_MUXPOS_AIN10 = 0xa
	// ADC AIN11 Pin
	ADC_INPUTCTRL_MUXPOS_AIN11 = 0xb
	// ADC AIN12 Pin
	ADC_INPUTCTRL_MUXPOS_AIN12 = 0xc
	// ADC AIN13 Pin
	ADC_INPUTCTRL_MUXPOS_AIN13 = 0xd
	// ADC AIN14 Pin
	ADC_INPUTCTRL_MUXPOS_AIN14 = 0xe
	// ADC AIN15 Pin
	ADC_INPUTCTRL_MUXPOS_AIN15 = 0xf
	// ADC AIN16 Pin
	ADC_INPUTCTRL_MUXPOS_AIN16 = 0x10
	// ADC AIN17 Pin
	ADC_INPUTCTRL_MUXPOS_AIN17 = 0x11
	// ADC AIN18 Pin
	ADC_INPUTCTRL_MUXPOS_AIN18 = 0x12
	// ADC AIN19 Pin
	ADC_INPUTCTRL_MUXPOS_AIN19 = 0x13
	// ADC AIN20 Pin
	ADC_INPUTCTRL_MUXPOS_AIN20 = 0x14
	// ADC AIN21 Pin
	ADC_INPUTCTRL_MUXPOS_AIN21 = 0x15
	// ADC AIN22 Pin
	ADC_INPUTCTRL_MUXPOS_AIN22 = 0x16
	// ADC AIN23 Pin
	ADC_INPUTCTRL_MUXPOS_AIN23 = 0x17
	// Temperature Sensor
	ADC_INPUTCTRL_MUXPOS_TEMP = 0x18
	// Bandgap Voltage
	ADC_INPUTCTRL_MUXPOS_BANDGAP = 0x19
	// 1/4 Scaled Core Supply
	ADC_INPUTCTRL_MUXPOS_SCALEDCOREVCC = 0x1a
	// 1/4 Scaled I/O Supply
	ADC_INPUTCTRL_MUXPOS_SCALEDIOVCC = 0x1b
	// DAC Output
	ADC_INPUTCTRL_MUXPOS_DAC = 0x1c
	// 1/4 Scaled VBAT Supply
	ADC_INPUTCTRL_MUXPOS_SCALEDVBAT = 0x1d
	// OPAMP0 or OPAMP1 output
	ADC_INPUTCTRL_MUXPOS_OPAMP01 = 0x1e
	// OPAMP2 output
	ADC_INPUTCTRL_MUXPOS_OPAMP2 = 0x1f
	// Position of MUXNEG field.
	ADC_INPUTCTRL_MUXNEG_Pos = 0x8
	// Bit mask of MUXNEG field.
	ADC_INPUTCTRL_MUXNEG_Msk = 0x1f00
	// ADC AIN0 Pin
	ADC_INPUTCTRL_MUXNEG_AIN0 = 0x0
	// ADC AIN1 Pin
	ADC_INPUTCTRL_MUXNEG_AIN1 = 0x1
	// ADC AIN2 Pin
	ADC_INPUTCTRL_MUXNEG_AIN2 = 0x2
	// ADC AIN3 Pin
	ADC_INPUTCTRL_MUXNEG_AIN3 = 0x3
	// ADC AIN4 Pin
	ADC_INPUTCTRL_MUXNEG_AIN4 = 0x4
	// ADC AIN5 Pin
	ADC_INPUTCTRL_MUXNEG_AIN5 = 0x5
	// ADC AIN6 Pin
	ADC_INPUTCTRL_MUXNEG_AIN6 = 0x6
	// ADC AIN7 Pin
	ADC_INPUTCTRL_MUXNEG_AIN7 = 0x7

	// CTRLC: Control C
	// Position of DIFFMODE field.
	ADC_CTRLC_DIFFMODE_Pos = 0x0
	// Bit mask of DIFFMODE field.
	ADC_CTRLC_DIFFMODE_Msk = 0x1
	// Bit DIFFMODE.
	ADC_CTRLC_DIFFMODE = 0x1
	// Position of LEFTADJ field.
	ADC_CTRLC_LEFTADJ_Pos = 0x1
	// Bit mask of LEFTADJ field.
	ADC_CTRLC_LEFTADJ_Msk = 0x2
	// Bit LEFTADJ.
	ADC_CTRLC_LEFTADJ = 0x2
	// Position of FREERUN field.
	ADC_CTRLC_FREERUN_Pos = 0x2
	// Bit mask of FREERUN field.
	ADC_CTRLC_FREERUN_Msk = 0x4
	// Bit FREERUN.
	ADC_CTRLC_FREERUN = 0x4
	// Position of CORREN field.
	ADC_CTRLC_CORREN_Pos = 0x3
	// Bit mask of CORREN field.
	ADC_CTRLC_CORREN_Msk = 0x8
	// Bit CORREN.
	ADC_CTRLC_CORREN = 0x8
	// Position of RESSEL field.
	ADC_CTRLC_RESSEL_Pos = 0x4
	// Bit mask of RESSEL field.
	ADC_CTRLC_RESSEL_Msk = 0x30
	// 12-bit result
	ADC_CTRLC_RESSEL_12BIT = 0x0
	// For averaging mode output
	ADC_CTRLC_RESSEL_16BIT = 0x1
	// 10-bit result
	ADC_CTRLC_RESSEL_10BIT = 0x2
	// 8-bit result
	ADC_CTRLC_RESSEL_8BIT = 0x3
	// Position of R2R field.
	ADC_CTRLC_R2R_Pos = 0x7
	// Bit mask of R2R field.
	ADC_CTRLC_R2R_Msk = 0x80
	// Bit R2R.
	ADC_CTRLC_R2R = 0x80
	// Position of WINMODE field.
	ADC_CTRLC_WINMODE_Pos = 0x8
	// Bit mask of WINMODE field.
	ADC_CTRLC_WINMODE_Msk = 0x700
	// No window mode (default)
	ADC_CTRLC_WINMODE_DISABLE = 0x0
	// RESULT > WINLT
	ADC_CTRLC_WINMODE_MODE1 = 0x1
	// RESULT < WINUT
	ADC_CTRLC_WINMODE_MODE2 = 0x2
	// WINLT < RESULT < WINUT
	ADC_CTRLC_WINMODE_MODE3 = 0x3
	// !(WINLT < RESULT < WINUT)
	ADC_CTRLC_WINMODE_MODE4 = 0x4
	// Position of DUALSEL field.
	ADC_CTRLC_DUALSEL_Pos = 0xc
	// Bit mask of DUALSEL field.
	ADC_CTRLC_DUALSEL_Msk = 0x3000
	// Start event or software trigger will start a conversion on both ADCs
	ADC_CTRLC_DUALSEL_BOTH = 0x0
	// START event or software trigger will alternatingly start a conversion on ADC0 and ADC1
	ADC_CTRLC_DUALSEL_INTERLEAVE = 0x1

	// AVGCTRL: Average Control
	// Position of SAMPLENUM field.
	ADC_AVGCTRL_SAMPLENUM_Pos = 0x0
	// Bit mask of SAMPLENUM field.
	ADC_AVGCTRL_SAMPLENUM_Msk = 0xf
	// 1 sample
	ADC_AVGCTRL_SAMPLENUM_1 = 0x0
	// 2 samples
	ADC_AVGCTRL_SAMPLENUM_2 = 0x1
	// 4 samples
	ADC_AVGCTRL_SAMPLENUM_4 = 0x2
	// 8 samples
	ADC_AVGCTRL_SAMPLENUM_8 = 0x3
	// 16 samples
	ADC_AVGCTRL_SAMPLENUM_16 = 0x4
	// 32 samples
	ADC_AVGCTRL_SAMPLENUM_32 = 0x5
	// 64 samples
	ADC_AVGCTRL_SAMPLENUM_64 = 0x6
	// 128 samples
	ADC_AVGCTRL_SAMPLENUM_128 = 0x7
	// 256 samples
	ADC_AVGCTRL_SAMPLENUM_256 = 0x8
	// 512 samples
	ADC_AVGCTRL_SAMPLENUM_512 = 0x9
	// 1024 samples
	ADC_AVGCTRL_SAMPLENUM_1024 = 0xa
	// Position of ADJRES field.
	ADC_AVGCTRL_ADJRES_Pos = 0x4
	// Bit mask of ADJRES field.
	ADC_AVGCTRL_ADJRES_Msk = 0x70

	// SAMPCTRL: Sample Time Control
	// Position of SAMPLEN field.
	ADC_SAMPCTRL_SAMPLEN_Pos = 0x0
	// Bit mask of SAMPLEN field.
	ADC_SAMPCTRL_SAMPLEN_Msk = 0x3f
	// Position of OFFCOMP field.
	ADC_SAMPCTRL_OFFCOMP_Pos = 0x7
	// Bit mask of OFFCOMP field.
	ADC_SAMPCTRL_OFFCOMP_Msk = 0x80
	// Bit OFFCOMP.
	ADC_SAMPCTRL_OFFCOMP = 0x80

	// WINLT: Window Monitor Lower Threshold
	// Position of WINLT field.
	ADC_WINLT_WINLT_Pos = 0x0
	// Bit mask of WINLT field.
	ADC_WINLT_WINLT_Msk = 0xffff

	// WINUT: Window Monitor Upper Threshold
	// Position of WINUT field.
	ADC_WINUT_WINUT_Pos = 0x0
	// Bit mask of WINUT field.
	ADC_WINUT_WINUT_Msk = 0xffff

	// GAINCORR: Gain Correction
	// Position of GAINCORR field.
	ADC_GAINCORR_GAINCORR_Pos = 0x0
	// Bit mask of GAINCORR field.
	ADC_GAINCORR_GAINCORR_Msk = 0xfff

	// OFFSETCORR: Offset Correction
	// Position of OFFSETCORR field.
	ADC_OFFSETCORR_OFFSETCORR_Pos = 0x0
	// Bit mask of OFFSETCORR field.
	ADC_OFFSETCORR_OFFSETCORR_Msk = 0xfff

	// SWTRIG: Software Trigger
	// Position of FLUSH field.
	ADC_SWTRIG_FLUSH_Pos = 0x0
	// Bit mask of FLUSH field.
	ADC_SWTRIG_FLUSH_Msk = 0x1
	// Bit FLUSH.
	ADC_SWTRIG_FLUSH = 0x1
	// Position of START field.
	ADC_SWTRIG_START_Pos = 0x1
	// Bit mask of START field.
	ADC_SWTRIG_START_Msk = 0x2
	// Bit START.
	ADC_SWTRIG_START = 0x2

	// DBGCTRL: Debug Control
	// Position of DBGRUN field.
	ADC_DBGCTRL_DBGRUN_Pos = 0x0
	// Bit mask of DBGRUN field.
	ADC_DBGCTRL_DBGRUN_Msk = 0x1
	// Bit DBGRUN.
	ADC_DBGCTRL_DBGRUN = 0x1

	// SYNCBUSY: Synchronization Busy
	// Position of SWRST field.
	ADC_SYNCBUSY_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	ADC_SYNCBUSY_SWRST_Msk = 0x1
	// Bit SWRST.
	ADC_SYNCBUSY_SWRST = 0x1
	// Position of ENABLE field.
	ADC_SYNCBUSY_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	ADC_SYNCBUSY_ENABLE_Msk = 0x2
	// Bit ENABLE.
	ADC_SYNCBUSY_ENABLE = 0x2
	// Position of INPUTCTRL field.
	ADC_SYNCBUSY_INPUTCTRL_Pos = 0x2
	// Bit mask of INPUTCTRL field.
	ADC_SYNCBUSY_INPUTCTRL_Msk = 0x4
	// Bit INPUTCTRL.
	ADC_SYNCBUSY_INPUTCTRL = 0x4
	// Position of CTRLC field.
	ADC_SYNCBUSY_CTRLC_Pos = 0x3
	// Bit mask of CTRLC field.
	ADC_SYNCBUSY_CTRLC_Msk = 0x8
	// Bit CTRLC.
	ADC_SYNCBUSY_CTRLC = 0x8
	// Position of AVGCTRL field.
	ADC_SYNCBUSY_AVGCTRL_Pos = 0x4
	// Bit mask of AVGCTRL field.
	ADC_SYNCBUSY_AVGCTRL_Msk = 0x10
	// Bit AVGCTRL.
	ADC_SYNCBUSY_AVGCTRL = 0x10
	// Position of SAMPCTRL field.
	ADC_SYNCBUSY_SAMPCTRL_Pos = 0x5
	// Bit mask of SAMPCTRL field.
	ADC_SYNCBUSY_SAMPCTRL_Msk = 0x20
	// Bit SAMPCTRL.
	ADC_SYNCBUSY_SAMPCTRL = 0x20
	// Position of WINLT field.
	ADC_SYNCBUSY_WINLT_Pos = 0x6
	// Bit mask of WINLT field.
	ADC_SYNCBUSY_WINLT_Msk = 0x40
	// Bit WINLT.
	ADC_SYNCBUSY_WINLT = 0x40
	// Position of WINUT field.
	ADC_SYNCBUSY_WINUT_Pos = 0x7
	// Bit mask of WINUT field.
	ADC_SYNCBUSY_WINUT_Msk = 0x80
	// Bit WINUT.
	ADC_SYNCBUSY_WINUT = 0x80
	// Position of GAINCORR field.
	ADC_SYNCBUSY_GAINCORR_Pos = 0x8
	// Bit mask of GAINCORR field.
	ADC_SYNCBUSY_GAINCORR_Msk = 0x100
	// Bit GAINCORR.
	ADC_SYNCBUSY_GAINCORR = 0x100
	// Position of OFFSETCORR field.
	ADC_SYNCBUSY_OFFSETCORR_Pos = 0x9
	// Bit mask of OFFSETCORR field.
	ADC_SYNCBUSY_OFFSETCORR_Msk = 0x200
	// Bit OFFSETCORR.
	ADC_SYNCBUSY_OFFSETCORR = 0x200
	// Position of SWTRIG field.
	ADC_SYNCBUSY_SWTRIG_Pos = 0xa
	// Bit mask of SWTRIG field.
	ADC_SYNCBUSY_SWTRIG_Msk = 0x400
	// Bit SWTRIG.
	ADC_SYNCBUSY_SWTRIG = 0x400

	// RESULT: Result
	// Position of RESULT field.
	ADC_RESULT_RESULT_Pos = 0x0
	// Bit mask of RESULT field.
	ADC_RESULT_RESULT_Msk = 0xffff

	// SEQCTRL: Sequence Control
	// Position of SEQEN field.
	ADC_SEQCTRL_SEQEN_Pos = 0x0
	// Bit mask of SEQEN field.
	ADC_SEQCTRL_SEQEN_Msk = 0xffffffff

	// CALIB: Calibration
	// Position of BIASCOMP field.
	ADC_CALIB_BIASCOMP_Pos = 0x0
	// Bit mask of BIASCOMP field.
	ADC_CALIB_BIASCOMP_Msk = 0x7
	// Position of BIASREFBUF field.
	ADC_CALIB_BIASREFBUF_Pos = 0x8
	// Bit mask of BIASREFBUF field.
	ADC_CALIB_BIASREFBUF_Msk = 0x700
)

// Constants for CCL: Configurable Custom Logic
const (
	// CTRL: Control
	// Position of SWRST field.
	CCL_CTRL_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	CCL_CTRL_SWRST_Msk = 0x1
	// Bit SWRST.
	CCL_CTRL_SWRST = 0x1
	// Position of ENABLE field.
	CCL_CTRL_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	CCL_CTRL_ENABLE_Msk = 0x2
	// Bit ENABLE.
	CCL_CTRL_ENABLE = 0x2
	// Position of RUNSTDBY field.
	CCL_CTRL_RUNSTDBY_Pos = 0x6
	// Bit mask of RUNSTDBY field.
	CCL_CTRL_RUNSTDBY_Msk = 0x40
	// Bit RUNSTDBY.
	CCL_CTRL_RUNSTDBY = 0x40

	// SEQCTRL: SEQ Control x
	// Position of SEQSEL field.
	CCL_SEQCTRL_SEQSEL_Pos = 0x0
	// Bit mask of SEQSEL field.
	CCL_SEQCTRL_SEQSEL_Msk = 0xf
	// Sequential logic is disabled
	CCL_SEQCTRL_SEQSEL_DISABLE = 0x0
	// D flip flop
	CCL_SEQCTRL_SEQSEL_DFF = 0x1
	// JK flip flop
	CCL_SEQCTRL_SEQSEL_JK = 0x2
	// D latch
	CCL_SEQCTRL_SEQSEL_LATCH = 0x3
	// RS latch
	CCL_SEQCTRL_SEQSEL_RS = 0x4

	// LUTCTRL: LUT Control x
	// Position of ENABLE field.
	CCL_LUTCTRL_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	CCL_LUTCTRL_ENABLE_Msk = 0x2
	// Bit ENABLE.
	CCL_LUTCTRL_ENABLE = 0x2
	// Position of FILTSEL field.
	CCL_LUTCTRL_FILTSEL_Pos = 0x4
	// Bit mask of FILTSEL field.
	CCL_LUTCTRL_FILTSEL_Msk = 0x30
	// Filter disabled
	CCL_LUTCTRL_FILTSEL_DISABLE = 0x0
	// Synchronizer enabled
	CCL_LUTCTRL_FILTSEL_SYNCH = 0x1
	// Filter enabled
	CCL_LUTCTRL_FILTSEL_FILTER = 0x2
	// Position of EDGESEL field.
	CCL_LUTCTRL_EDGESEL_Pos = 0x7
	// Bit mask of EDGESEL field.
	CCL_LUTCTRL_EDGESEL_Msk = 0x80
	// Bit EDGESEL.
	CCL_LUTCTRL_EDGESEL = 0x80
	// Position of INSEL0 field.
	CCL_LUTCTRL_INSEL0_Pos = 0x8
	// Bit mask of INSEL0 field.
	CCL_LUTCTRL_INSEL0_Msk = 0xf00
	// Masked input
	CCL_LUTCTRL_INSEL0_MASK = 0x0
	// Feedback input source
	CCL_LUTCTRL_INSEL0_FEEDBACK = 0x1
	// Linked LUT input source
	CCL_LUTCTRL_INSEL0_LINK = 0x2
	// Event input source
	CCL_LUTCTRL_INSEL0_EVENT = 0x3
	// I/O pin input source
	CCL_LUTCTRL_INSEL0_IO = 0x4
	// AC input source
	CCL_LUTCTRL_INSEL0_AC = 0x5
	// TC input source
	CCL_LUTCTRL_INSEL0_TC = 0x6
	// Alternate TC input source
	CCL_LUTCTRL_INSEL0_ALTTC = 0x7
	// TCC input source
	CCL_LUTCTRL_INSEL0_TCC = 0x8
	// SERCOM input source
	CCL_LUTCTRL_INSEL0_SERCOM = 0x9
	// Alternate 2 TC input source
	CCL_LUTCTRL_INSEL0_ALT2TC = 0xa
	// Asynchronous event input source. The EVENT input will bypass edge detection logic.
	CCL_LUTCTRL_INSEL0_ASYNCEVENT = 0xb
	// Position of INSEL1 field.
	CCL_LUTCTRL_INSEL1_Pos = 0xc
	// Bit mask of INSEL1 field.
	CCL_LUTCTRL_INSEL1_Msk = 0xf000
	// Masked input
	CCL_LUTCTRL_INSEL1_MASK = 0x0
	// Feedback input source
	CCL_LUTCTRL_INSEL1_FEEDBACK = 0x1
	// Linked LUT input source
	CCL_LUTCTRL_INSEL1_LINK = 0x2
	// Event input source
	CCL_LUTCTRL_INSEL1_EVENT = 0x3
	// I/O pin input source
	CCL_LUTCTRL_INSEL1_IO = 0x4
	// AC input source
	CCL_LUTCTRL_INSEL1_AC = 0x5
	// TC input source
	CCL_LUTCTRL_INSEL1_TC = 0x6
	// Alternate TC input source
	CCL_LUTCTRL_INSEL1_ALTTC = 0x7
	// TCC input source
	CCL_LUTCTRL_INSEL1_TCC = 0x8
	// SERCOM input source
	CCL_LUTCTRL_INSEL1_SERCOM = 0x9
	// Alternate 2 TC input source
	CCL_LUTCTRL_INSEL1_ALT2TC = 0xa
	// Asynchronous event input source. The EVENT input will bypass edge detection logic.
	CCL_LUTCTRL_INSEL1_ASYNCEVENT = 0xb
	// Position of INSEL2 field.
	CCL_LUTCTRL_INSEL2_Pos = 0x10
	// Bit mask of INSEL2 field.
	CCL_LUTCTRL_INSEL2_Msk = 0xf0000
	// Masked input
	CCL_LUTCTRL_INSEL2_MASK = 0x0
	// Feedback input source
	CCL_LUTCTRL_INSEL2_FEEDBACK = 0x1
	// Linked LUT input source
	CCL_LUTCTRL_INSEL2_LINK = 0x2
	// Event input source
	CCL_LUTCTRL_INSEL2_EVENT = 0x3
	// I/O pin input source
	CCL_LUTCTRL_INSEL2_IO = 0x4
	// AC input source
	CCL_LUTCTRL_INSEL2_AC = 0x5
	// TC input source
	CCL_LUTCTRL_INSEL2_TC = 0x6
	// Alternate TC input source
	CCL_LUTCTRL_INSEL2_ALTTC = 0x7
	// TCC input source
	CCL_LUTCTRL_INSEL2_TCC = 0x8
	// SERCOM input source
	CCL_LUTCTRL_INSEL2_SERCOM = 0x9
	// Alternate 2 TC input source
	CCL_LUTCTRL_INSEL2_ALT2TC = 0xa
	// Asynchronous event input source. The EVENT input will bypass edge detection logic.
	CCL_LUTCTRL_INSEL2_ASYNCEVENT = 0xb
	// Position of INVEI field.
	CCL_LUTCTRL_INVEI_Pos = 0x14
	// Bit mask of INVEI field.
	CCL_LUTCTRL_INVEI_Msk = 0x100000
	// Bit INVEI.
	CCL_LUTCTRL_INVEI = 0x100000
	// Position of LUTEI field.
	CCL_LUTCTRL_LUTEI_Pos = 0x15
	// Bit mask of LUTEI field.
	CCL_LUTCTRL_LUTEI_Msk = 0x200000
	// Bit LUTEI.
	CCL_LUTCTRL_LUTEI = 0x200000
	// Position of LUTEO field.
	CCL_LUTCTRL_LUTEO_Pos = 0x16
	// Bit mask of LUTEO field.
	CCL_LUTCTRL_LUTEO_Msk = 0x400000
	// Bit LUTEO.
	CCL_LUTCTRL_LUTEO = 0x400000
	// Position of TRUTH field.
	CCL_LUTCTRL_TRUTH_Pos = 0x18
	// Bit mask of TRUTH field.
	CCL_LUTCTRL_TRUTH_Msk = 0xff000000
)

// Constants for DAC: Digital Analog Converter
const (
	// CTRLA: Control A
	// Position of SWRST field.
	DAC_CTRLA_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	DAC_CTRLA_SWRST_Msk = 0x1
	// Bit SWRST.
	DAC_CTRLA_SWRST = 0x1
	// Position of ENABLE field.
	DAC_CTRLA_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	DAC_CTRLA_ENABLE_Msk = 0x2
	// Bit ENABLE.
	DAC_CTRLA_ENABLE = 0x2
	// Position of RUNSTDBY field.
	DAC_CTRLA_RUNSTDBY_Pos = 0x6
	// Bit mask of RUNSTDBY field.
	DAC_CTRLA_RUNSTDBY_Msk = 0x40
	// Bit RUNSTDBY.
	DAC_CTRLA_RUNSTDBY = 0x40

	// CTRLB: Control B
	// Position of EOEN field.
	DAC_CTRLB_EOEN_Pos = 0x0
	// Bit mask of EOEN field.
	DAC_CTRLB_EOEN_Msk = 0x1
	// Bit EOEN.
	DAC_CTRLB_EOEN = 0x1
	// Position of IOEN field.
	DAC_CTRLB_IOEN_Pos = 0x1
	// Bit mask of IOEN field.
	DAC_CTRLB_IOEN_Msk = 0x2
	// Bit IOEN.
	DAC_CTRLB_IOEN = 0x2
	// Position of LEFTADJ field.
	DAC_CTRLB_LEFTADJ_Pos = 0x2
	// Bit mask of LEFTADJ field.
	DAC_CTRLB_LEFTADJ_Msk = 0x4
	// Bit LEFTADJ.
	DAC_CTRLB_LEFTADJ = 0x4
	// Position of VPD field.
	DAC_CTRLB_VPD_Pos = 0x3
	// Bit mask of VPD field.
	DAC_CTRLB_VPD_Msk = 0x8
	// Bit VPD.
	DAC_CTRLB_VPD = 0x8
	// Position of DITHER field.
	DAC_CTRLB_DITHER_Pos = 0x5
	// Bit mask of DITHER field.
	DAC_CTRLB_DITHER_Msk = 0x20
	// Bit DITHER.
	DAC_CTRLB_DITHER = 0x20
	// Position of REFSEL field.
	DAC_CTRLB_REFSEL_Pos = 0x6
	// Bit mask of REFSEL field.
	DAC_CTRLB_REFSEL_Msk = 0xc0
	// Internal 1.0V reference
	DAC_CTRLB_REFSEL_INT1V = 0x0
	// AVCC
	DAC_CTRLB_REFSEL_AVCC = 0x1
	// External reference
	DAC_CTRLB_REFSEL_VREFP = 0x2

	// EVCTRL: Event Control
	// Position of STARTEI field.
	DAC_EVCTRL_STARTEI_Pos = 0x0
	// Bit mask of STARTEI field.
	DAC_EVCTRL_STARTEI_Msk = 0x1
	// Bit STARTEI.
	DAC_EVCTRL_STARTEI = 0x1
	// Position of EMPTYEO field.
	DAC_EVCTRL_EMPTYEO_Pos = 0x1
	// Bit mask of EMPTYEO field.
	DAC_EVCTRL_EMPTYEO_Msk = 0x2
	// Bit EMPTYEO.
	DAC_EVCTRL_EMPTYEO = 0x2
	// Position of INVEI field.
	DAC_EVCTRL_INVEI_Pos = 0x2
	// Bit mask of INVEI field.
	DAC_EVCTRL_INVEI_Msk = 0x4
	// Bit INVEI.
	DAC_EVCTRL_INVEI = 0x4

	// INTENCLR: Interrupt Enable Clear
	// Position of UNDERRUN field.
	DAC_INTENCLR_UNDERRUN_Pos = 0x0
	// Bit mask of UNDERRUN field.
	DAC_INTENCLR_UNDERRUN_Msk = 0x1
	// Bit UNDERRUN.
	DAC_INTENCLR_UNDERRUN = 0x1
	// Position of EMPTY field.
	DAC_INTENCLR_EMPTY_Pos = 0x1
	// Bit mask of EMPTY field.
	DAC_INTENCLR_EMPTY_Msk = 0x2
	// Bit EMPTY.
	DAC_INTENCLR_EMPTY = 0x2

	// INTENSET: Interrupt Enable Set
	// Position of UNDERRUN field.
	DAC_INTENSET_UNDERRUN_Pos = 0x0
	// Bit mask of UNDERRUN field.
	DAC_INTENSET_UNDERRUN_Msk = 0x1
	// Bit UNDERRUN.
	DAC_INTENSET_UNDERRUN = 0x1
	// Position of EMPTY field.
	DAC_INTENSET_EMPTY_Pos = 0x1
	// Bit mask of EMPTY field.
	DAC_INTENSET_EMPTY_Msk = 0x2
	// Bit EMPTY.
	DAC_INTENSET_EMPTY = 0x2

	// INTFLAG: Interrupt Flag Status and Clear
	// Position of UNDERRUN field.
	DAC_INTFLAG_UNDERRUN_Pos = 0x0
	// Bit mask of UNDERRUN field.
	DAC_INTFLAG_UNDERRUN_Msk = 0x1
	// Bit UNDERRUN.
	DAC_INTFLAG_UNDERRUN = 0x1
	// Position of EMPTY field.
	DAC_INTFLAG_EMPTY_Pos = 0x1
	// Bit mask of EMPTY field.
	DAC_INTFLAG_EMPTY_Msk = 0x2
	// Bit EMPTY.
	DAC_INTFLAG_EMPTY = 0x2

	// STATUS: Status
	// Position of READY field.
	DAC_STATUS_READY_Pos = 0x0
	// Bit mask of READY field.
	DAC_STATUS_READY_Msk = 0x1
	// Bit READY.
	DAC_STATUS_READY = 0x1

	// DATA: Data
	// Position of DATA field.
	DAC_DATA_DATA_Pos = 0x0
	// Bit mask of DATA field.
	DAC_DATA_DATA_Msk = 0xffff

	// DATABUF: Data Buffer
	// Position of DATABUF field.
	DAC_DATABUF_DATABUF_Pos = 0x0
	// Bit mask of DATABUF field.
	DAC_DATABUF_DATABUF_Msk = 0xffff

	// SYNCBUSY: Synchronization Busy
	// Position of SWRST field.
	DAC_SYNCBUSY_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	DAC_SYNCBUSY_SWRST_Msk = 0x1
	// Bit SWRST.
	DAC_SYNCBUSY_SWRST = 0x1
	// Position of ENABLE field.
	DAC_SYNCBUSY_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	DAC_SYNCBUSY_ENABLE_Msk = 0x2
	// Bit ENABLE.
	DAC_SYNCBUSY_ENABLE = 0x2
	// Position of DATA field.
	DAC_SYNCBUSY_DATA_Pos = 0x2
	// Bit mask of DATA field.
	DAC_SYNCBUSY_DATA_Msk = 0x4
	// Bit DATA.
	DAC_SYNCBUSY_DATA = 0x4
	// Position of DATABUF field.
	DAC_SYNCBUSY_DATABUF_Pos = 0x3
	// Bit mask of DATABUF field.
	DAC_SYNCBUSY_DATABUF_Msk = 0x8
	// Bit DATABUF.
	DAC_SYNCBUSY_DATABUF = 0x8

	// DBGCTRL: Debug Control
	// Position of DBGRUN field.
	DAC_DBGCTRL_DBGRUN_Pos = 0x0
	// Bit mask of DBGRUN field.
	DAC_DBGCTRL_DBGRUN_Msk = 0x1
	// Bit DBGRUN.
	DAC_DBGCTRL_DBGRUN = 0x1
)

// Constants for DMAC: Direct Memory Access Controller
const (
	// CTRL: Control
	// Position of SWRST field.
	DMAC_CTRL_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	DMAC_CTRL_SWRST_Msk = 0x1
	// Bit SWRST.
	DMAC_CTRL_SWRST = 0x1
	// Position of DMAENABLE field.
	DMAC_CTRL_DMAENABLE_Pos = 0x1
	// Bit mask of DMAENABLE field.
	DMAC_CTRL_DMAENABLE_Msk = 0x2
	// Bit DMAENABLE.
	DMAC_CTRL_DMAENABLE = 0x2
	// Position of CRCENABLE field.
	DMAC_CTRL_CRCENABLE_Pos = 0x2
	// Bit mask of CRCENABLE field.
	DMAC_CTRL_CRCENABLE_Msk = 0x4
	// Bit CRCENABLE.
	DMAC_CTRL_CRCENABLE = 0x4
	// Position of LVLEN0 field.
	DMAC_CTRL_LVLEN0_Pos = 0x8
	// Bit mask of LVLEN0 field.
	DMAC_CTRL_LVLEN0_Msk = 0x100
	// Bit LVLEN0.
	DMAC_CTRL_LVLEN0 = 0x100
	// Position of LVLEN1 field.
	DMAC_CTRL_LVLEN1_Pos = 0x9
	// Bit mask of LVLEN1 field.
	DMAC_CTRL_LVLEN1_Msk = 0x200
	// Bit LVLEN1.
	DMAC_CTRL_LVLEN1 = 0x200
	// Position of LVLEN2 field.
	DMAC_CTRL_LVLEN2_Pos = 0xa
	// Bit mask of LVLEN2 field.
	DMAC_CTRL_LVLEN2_Msk = 0x400
	// Bit LVLEN2.
	DMAC_CTRL_LVLEN2 = 0x400
	// Position of LVLEN3 field.
	DMAC_CTRL_LVLEN3_Pos = 0xb
	// Bit mask of LVLEN3 field.
	DMAC_CTRL_LVLEN3_Msk = 0x800
	// Bit LVLEN3.
	DMAC_CTRL_LVLEN3 = 0x800

	// CRCCTRL: CRC Control
	// Position of CRCBEATSIZE field.
	DMAC_CRCCTRL_CRCBEATSIZE_Pos = 0x0
	// Bit mask of CRCBEATSIZE field.
	DMAC_CRCCTRL_CRCBEATSIZE_Msk = 0x3
	// 8-bit bus transfer
	DMAC_CRCCTRL_CRCBEATSIZE_BYTE = 0x0
	// 16-bit bus transfer
	DMAC_CRCCTRL_CRCBEATSIZE_HWORD = 0x1
	// 32-bit bus transfer
	DMAC_CRCCTRL_CRCBEATSIZE_WORD = 0x2
	// Position of CRCPOLY field.
	DMAC_CRCCTRL_CRCPOLY_Pos = 0x2
	// Bit mask of CRCPOLY field.
	DMAC_CRCCTRL_CRCPOLY_Msk = 0xc
	// CRC-16 (CRC-CCITT)
	DMAC_CRCCTRL_CRCPOLY_CRC16 = 0x0
	// CRC32 (IEEE 802.3)
	DMAC_CRCCTRL_CRCPOLY_CRC32 = 0x1
	// Position of CRCSRC field.
	DMAC_CRCCTRL_CRCSRC_Pos = 0x8
	// Bit mask of CRCSRC field.
	DMAC_CRCCTRL_CRCSRC_Msk = 0x3f00
	// No action
	DMAC_CRCCTRL_CRCSRC_NOACT = 0x0
	// I/O interface
	DMAC_CRCCTRL_CRCSRC_IO = 0x1

	// CRCDATAIN: CRC Data Input
	// Position of CRCDATAIN field.
	DMAC_CRCDATAIN_CRCDATAIN_Pos = 0x0
	// Bit mask of CRCDATAIN field.
	DMAC_CRCDATAIN_CRCDATAIN_Msk = 0xffffffff

	// CRCCHKSUM: CRC Checksum
	// Position of CRCCHKSUM field.
	DMAC_CRCCHKSUM_CRCCHKSUM_Pos = 0x0
	// Bit mask of CRCCHKSUM field.
	DMAC_CRCCHKSUM_CRCCHKSUM_Msk = 0xffffffff

	// CRCSTATUS: CRC Status
	// Position of CRCBUSY field.
	DMAC_CRCSTATUS_CRCBUSY_Pos = 0x0
	// Bit mask of CRCBUSY field.
	DMAC_CRCSTATUS_CRCBUSY_Msk = 0x1
	// Bit CRCBUSY.
	DMAC_CRCSTATUS_CRCBUSY = 0x1
	// Position of CRCZERO field.
	DMAC_CRCSTATUS_CRCZERO_Pos = 0x1
	// Bit mask of CRCZERO field.
	DMAC_CRCSTATUS_CRCZERO_Msk = 0x2
	// Bit CRCZERO.
	DMAC_CRCSTATUS_CRCZERO = 0x2

	// DBGCTRL: Debug Control
	// Position of DBGRUN field.
	DMAC_DBGCTRL_DBGRUN_Pos = 0x0
	// Bit mask of DBGRUN field.
	DMAC_DBGCTRL_DBGRUN_Msk = 0x1
	// Bit DBGRUN.
	DMAC_DBGCTRL_DBGRUN = 0x1

	// QOSCTRL: QOS Control
	// Position of WRBQOS field.
	DMAC_QOSCTRL_WRBQOS_Pos = 0x0
	// Bit mask of WRBQOS field.
	DMAC_QOSCTRL_WRBQOS_Msk = 0x3
	// Background (no sensitive operation)
	DMAC_QOSCTRL_WRBQOS_DISABLE = 0x0
	// Sensitive Bandwidth
	DMAC_QOSCTRL_WRBQOS_LOW = 0x1
	// Sensitive Latency
	DMAC_QOSCTRL_WRBQOS_MEDIUM = 0x2
	// Critical Latency
	DMAC_QOSCTRL_WRBQOS_HIGH = 0x3
	// Position of FQOS field.
	DMAC_QOSCTRL_FQOS_Pos = 0x2
	// Bit mask of FQOS field.
	DMAC_QOSCTRL_FQOS_Msk = 0xc
	// Background (no sensitive operation)
	DMAC_QOSCTRL_FQOS_DISABLE = 0x0
	// Sensitive Bandwidth
	DMAC_QOSCTRL_FQOS_LOW = 0x1
	// Sensitive Latency
	DMAC_QOSCTRL_FQOS_MEDIUM = 0x2
	// Critical Latency
	DMAC_QOSCTRL_FQOS_HIGH = 0x3
	// Position of DQOS field.
	DMAC_QOSCTRL_DQOS_Pos = 0x4
	// Bit mask of DQOS field.
	DMAC_QOSCTRL_DQOS_Msk = 0x30
	// Background (no sensitive operation)
	DMAC_QOSCTRL_DQOS_DISABLE = 0x0
	// Sensitive Bandwidth
	DMAC_QOSCTRL_DQOS_LOW = 0x1
	// Sensitive Latency
	DMAC_QOSCTRL_DQOS_MEDIUM = 0x2
	// Critical Latency
	DMAC_QOSCTRL_DQOS_HIGH = 0x3

	// SWTRIGCTRL: Software Trigger Control
	// Position of SWTRIG0 field.
	DMAC_SWTRIGCTRL_SWTRIG0_Pos = 0x0
	// Bit mask of SWTRIG0 field.
	DMAC_SWTRIGCTRL_SWTRIG0_Msk = 0x1
	// Bit SWTRIG0.
	DMAC_SWTRIGCTRL_SWTRIG0 = 0x1
	// Position of SWTRIG1 field.
	DMAC_SWTRIGCTRL_SWTRIG1_Pos = 0x1
	// Bit mask of SWTRIG1 field.
	DMAC_SWTRIGCTRL_SWTRIG1_Msk = 0x2
	// Bit SWTRIG1.
	DMAC_SWTRIGCTRL_SWTRIG1 = 0x2
	// Position of SWTRIG2 field.
	DMAC_SWTRIGCTRL_SWTRIG2_Pos = 0x2
	// Bit mask of SWTRIG2 field.
	DMAC_SWTRIGCTRL_SWTRIG2_Msk = 0x4
	// Bit SWTRIG2.
	DMAC_SWTRIGCTRL_SWTRIG2 = 0x4
	// Position of SWTRIG3 field.
	DMAC_SWTRIGCTRL_SWTRIG3_Pos = 0x3
	// Bit mask of SWTRIG3 field.
	DMAC_SWTRIGCTRL_SWTRIG3_Msk = 0x8
	// Bit SWTRIG3.
	DMAC_SWTRIGCTRL_SWTRIG3 = 0x8
	// Position of SWTRIG4 field.
	DMAC_SWTRIGCTRL_SWTRIG4_Pos = 0x4
	// Bit mask of SWTRIG4 field.
	DMAC_SWTRIGCTRL_SWTRIG4_Msk = 0x10
	// Bit SWTRIG4.
	DMAC_SWTRIGCTRL_SWTRIG4 = 0x10
	// Position of SWTRIG5 field.
	DMAC_SWTRIGCTRL_SWTRIG5_Pos = 0x5
	// Bit mask of SWTRIG5 field.
	DMAC_SWTRIGCTRL_SWTRIG5_Msk = 0x20
	// Bit SWTRIG5.
	DMAC_SWTRIGCTRL_SWTRIG5 = 0x20
	// Position of SWTRIG6 field.
	DMAC_SWTRIGCTRL_SWTRIG6_Pos = 0x6
	// Bit mask of SWTRIG6 field.
	DMAC_SWTRIGCTRL_SWTRIG6_Msk = 0x40
	// Bit SWTRIG6.
	DMAC_SWTRIGCTRL_SWTRIG6 = 0x40
	// Position of SWTRIG7 field.
	DMAC_SWTRIGCTRL_SWTRIG7_Pos = 0x7
	// Bit mask of SWTRIG7 field.
	DMAC_SWTRIGCTRL_SWTRIG7_Msk = 0x80
	// Bit SWTRIG7.
	DMAC_SWTRIGCTRL_SWTRIG7 = 0x80

	// PRICTRL0: Priority Control 0
	// Position of LVLPRI0 field.
	DMAC_PRICTRL0_LVLPRI0_Pos = 0x0
	// Bit mask of LVLPRI0 field.
	DMAC_PRICTRL0_LVLPRI0_Msk = 0x7
	// Position of RRLVLEN0 field.
	DMAC_PRICTRL0_RRLVLEN0_Pos = 0x7
	// Bit mask of RRLVLEN0 field.
	DMAC_PRICTRL0_RRLVLEN0_Msk = 0x80
	// Bit RRLVLEN0.
	DMAC_PRICTRL0_RRLVLEN0 = 0x80
	// Position of LVLPRI1 field.
	DMAC_PRICTRL0_LVLPRI1_Pos = 0x8
	// Bit mask of LVLPRI1 field.
	DMAC_PRICTRL0_LVLPRI1_Msk = 0x700
	// Position of RRLVLEN1 field.
	DMAC_PRICTRL0_RRLVLEN1_Pos = 0xf
	// Bit mask of RRLVLEN1 field.
	DMAC_PRICTRL0_RRLVLEN1_Msk = 0x8000
	// Bit RRLVLEN1.
	DMAC_PRICTRL0_RRLVLEN1 = 0x8000
	// Position of LVLPRI2 field.
	DMAC_PRICTRL0_LVLPRI2_Pos = 0x10
	// Bit mask of LVLPRI2 field.
	DMAC_PRICTRL0_LVLPRI2_Msk = 0x70000
	// Position of RRLVLEN2 field.
	DMAC_PRICTRL0_RRLVLEN2_Pos = 0x17
	// Bit mask of RRLVLEN2 field.
	DMAC_PRICTRL0_RRLVLEN2_Msk = 0x800000
	// Bit RRLVLEN2.
	DMAC_PRICTRL0_RRLVLEN2 = 0x800000
	// Position of LVLPRI3 field.
	DMAC_PRICTRL0_LVLPRI3_Pos = 0x18
	// Bit mask of LVLPRI3 field.
	DMAC_PRICTRL0_LVLPRI3_Msk = 0x7000000
	// Position of RRLVLEN3 field.
	DMAC_PRICTRL0_RRLVLEN3_Pos = 0x1f
	// Bit mask of RRLVLEN3 field.
	DMAC_PRICTRL0_RRLVLEN3_Msk = 0x80000000
	// Bit RRLVLEN3.
	DMAC_PRICTRL0_RRLVLEN3 = 0x80000000

	// INTPEND: Interrupt Pending
	// Position of ID field.
	DMAC_INTPEND_ID_Pos = 0x0
	// Bit mask of ID field.
	DMAC_INTPEND_ID_Msk = 0x7
	// Position of TERR field.
	DMAC_INTPEND_TERR_Pos = 0x8
	// Bit mask of TERR field.
	DMAC_INTPEND_TERR_Msk = 0x100
	// Bit TERR.
	DMAC_INTPEND_TERR = 0x100
	// Position of TCMPL field.
	DMAC_INTPEND_TCMPL_Pos = 0x9
	// Bit mask of TCMPL field.
	DMAC_INTPEND_TCMPL_Msk = 0x200
	// Bit TCMPL.
	DMAC_INTPEND_TCMPL = 0x200
	// Position of SUSP field.
	DMAC_INTPEND_SUSP_Pos = 0xa
	// Bit mask of SUSP field.
	DMAC_INTPEND_SUSP_Msk = 0x400
	// Bit SUSP.
	DMAC_INTPEND_SUSP = 0x400
	// Position of FERR field.
	DMAC_INTPEND_FERR_Pos = 0xd
	// Bit mask of FERR field.
	DMAC_INTPEND_FERR_Msk = 0x2000
	// Bit FERR.
	DMAC_INTPEND_FERR = 0x2000
	// Position of BUSY field.
	DMAC_INTPEND_BUSY_Pos = 0xe
	// Bit mask of BUSY field.
	DMAC_INTPEND_BUSY_Msk = 0x4000
	// Bit BUSY.
	DMAC_INTPEND_BUSY = 0x4000
	// Position of PEND field.
	DMAC_INTPEND_PEND_Pos = 0xf
	// Bit mask of PEND field.
	DMAC_INTPEND_PEND_Msk = 0x8000
	// Bit PEND.
	DMAC_INTPEND_PEND = 0x8000

	// INTSTATUS: Interrupt Status
	// Position of CHINT0 field.
	DMAC_INTSTATUS_CHINT0_Pos = 0x0
	// Bit mask of CHINT0 field.
	DMAC_INTSTATUS_CHINT0_Msk = 0x1
	// Bit CHINT0.
	DMAC_INTSTATUS_CHINT0 = 0x1
	// Position of CHINT1 field.
	DMAC_INTSTATUS_CHINT1_Pos = 0x1
	// Bit mask of CHINT1 field.
	DMAC_INTSTATUS_CHINT1_Msk = 0x2
	// Bit CHINT1.
	DMAC_INTSTATUS_CHINT1 = 0x2
	// Position of CHINT2 field.
	DMAC_INTSTATUS_CHINT2_Pos = 0x2
	// Bit mask of CHINT2 field.
	DMAC_INTSTATUS_CHINT2_Msk = 0x4
	// Bit CHINT2.
	DMAC_INTSTATUS_CHINT2 = 0x4
	// Position of CHINT3 field.
	DMAC_INTSTATUS_CHINT3_Pos = 0x3
	// Bit mask of CHINT3 field.
	DMAC_INTSTATUS_CHINT3_Msk = 0x8
	// Bit CHINT3.
	DMAC_INTSTATUS_CHINT3 = 0x8
	// Position of CHINT4 field.
	DMAC_INTSTATUS_CHINT4_Pos = 0x4
	// Bit mask of CHINT4 field.
	DMAC_INTSTATUS_CHINT4_Msk = 0x10
	// Bit CHINT4.
	DMAC_INTSTATUS_CHINT4 = 0x10
	// Position of CHINT5 field.
	DMAC_INTSTATUS_CHINT5_Pos = 0x5
	// Bit mask of CHINT5 field.
	DMAC_INTSTATUS_CHINT5_Msk = 0x20
	// Bit CHINT5.
	DMAC_INTSTATUS_CHINT5 = 0x20
	// Position of CHINT6 field.
	DMAC_INTSTATUS_CHINT6_Pos = 0x6
	// Bit mask of CHINT6 field.
	DMAC_INTSTATUS_CHINT6_Msk = 0x40
	// Bit CHINT6.
	DMAC_INTSTATUS_CHINT6 = 0x40
	// Position of CHINT7 field.
	DMAC_INTSTATUS_CHINT7_Pos = 0x7
	// Bit mask of CHINT7 field.
	DMAC_INTSTATUS_CHINT7_Msk = 0x80
	// Bit CHINT7.
	DMAC_INTSTATUS_CHINT7 = 0x80

	// BUSYCH: Busy Channels
	// Position of BUSYCH0 field.
	DMAC_BUSYCH_BUSYCH0_Pos = 0x0
	// Bit mask of BUSYCH0 field.
	DMAC_BUSYCH_BUSYCH0_Msk = 0x1
	// Bit BUSYCH0.
	DMAC_BUSYCH_BUSYCH0 = 0x1
	// Position of BUSYCH1 field.
	DMAC_BUSYCH_BUSYCH1_Pos = 0x1
	// Bit mask of BUSYCH1 field.
	DMAC_BUSYCH_BUSYCH1_Msk = 0x2
	// Bit BUSYCH1.
	DMAC_BUSYCH_BUSYCH1 = 0x2
	// Position of BUSYCH2 field.
	DMAC_BUSYCH_BUSYCH2_Pos = 0x2
	// Bit mask of BUSYCH2 field.
	DMAC_BUSYCH_BUSYCH2_Msk = 0x4
	// Bit BUSYCH2.
	DMAC_BUSYCH_BUSYCH2 = 0x4
	// Position of BUSYCH3 field.
	DMAC_BUSYCH_BUSYCH3_Pos = 0x3
	// Bit mask of BUSYCH3 field.
	DMAC_BUSYCH_BUSYCH3_Msk = 0x8
	// Bit BUSYCH3.
	DMAC_BUSYCH_BUSYCH3 = 0x8
	// Position of BUSYCH4 field.
	DMAC_BUSYCH_BUSYCH4_Pos = 0x4
	// Bit mask of BUSYCH4 field.
	DMAC_BUSYCH_BUSYCH4_Msk = 0x10
	// Bit BUSYCH4.
	DMAC_BUSYCH_BUSYCH4 = 0x10
	// Position of BUSYCH5 field.
	DMAC_BUSYCH_BUSYCH5_Pos = 0x5
	// Bit mask of BUSYCH5 field.
	DMAC_BUSYCH_BUSYCH5_Msk = 0x20
	// Bit BUSYCH5.
	DMAC_BUSYCH_BUSYCH5 = 0x20
	// Position of BUSYCH6 field.
	DMAC_BUSYCH_BUSYCH6_Pos = 0x6
	// Bit mask of BUSYCH6 field.
	DMAC_BUSYCH_BUSYCH6_Msk = 0x40
	// Bit BUSYCH6.
	DMAC_BUSYCH_BUSYCH6 = 0x40
	// Position of BUSYCH7 field.
	DMAC_BUSYCH_BUSYCH7_Pos = 0x7
	// Bit mask of BUSYCH7 field.
	DMAC_BUSYCH_BUSYCH7_Msk = 0x80
	// Bit BUSYCH7.
	DMAC_BUSYCH_BUSYCH7 = 0x80

	// PENDCH: Pending Channels
	// Position of PENDCH0 field.
	DMAC_PENDCH_PENDCH0_Pos = 0x0
	// Bit mask of PENDCH0 field.
	DMAC_PENDCH_PENDCH0_Msk = 0x1
	// Bit PENDCH0.
	DMAC_PENDCH_PENDCH0 = 0x1
	// Position of PENDCH1 field.
	DMAC_PENDCH_PENDCH1_Pos = 0x1
	// Bit mask of PENDCH1 field.
	DMAC_PENDCH_PENDCH1_Msk = 0x2
	// Bit PENDCH1.
	DMAC_PENDCH_PENDCH1 = 0x2
	// Position of PENDCH2 field.
	DMAC_PENDCH_PENDCH2_Pos = 0x2
	// Bit mask of PENDCH2 field.
	DMAC_PENDCH_PENDCH2_Msk = 0x4
	// Bit PENDCH2.
	DMAC_PENDCH_PENDCH2 = 0x4
	// Position of PENDCH3 field.
	DMAC_PENDCH_PENDCH3_Pos = 0x3
	// Bit mask of PENDCH3 field.
	DMAC_PENDCH_PENDCH3_Msk = 0x8
	// Bit PENDCH3.
	DMAC_PENDCH_PENDCH3 = 0x8
	// Position of PENDCH4 field.
	DMAC_PENDCH_PENDCH4_Pos = 0x4
	// Bit mask of PENDCH4 field.
	DMAC_PENDCH_PENDCH4_Msk = 0x10
	// Bit PENDCH4.
	DMAC_PENDCH_PENDCH4 = 0x10
	// Position of PENDCH5 field.
	DMAC_PENDCH_PENDCH5_Pos = 0x5
	// Bit mask of PENDCH5 field.
	DMAC_PENDCH_PENDCH5_Msk = 0x20
	// Bit PENDCH5.
	DMAC_PENDCH_PENDCH5 = 0x20
	// Position of PENDCH6 field.
	DMAC_PENDCH_PENDCH6_Pos = 0x6
	// Bit mask of PENDCH6 field.
	DMAC_PENDCH_PENDCH6_Msk = 0x40
	// Bit PENDCH6.
	DMAC_PENDCH_PENDCH6 = 0x40
	// Position of PENDCH7 field.
	DMAC_PENDCH_PENDCH7_Pos = 0x7
	// Bit mask of PENDCH7 field.
	DMAC_PENDCH_PENDCH7_Msk = 0x80
	// Bit PENDCH7.
	DMAC_PENDCH_PENDCH7 = 0x80

	// ACTIVE: Active Channel and Levels
	// Position of LVLEX0 field.
	DMAC_ACTIVE_LVLEX0_Pos = 0x0
	// Bit mask of LVLEX0 field.
	DMAC_ACTIVE_LVLEX0_Msk = 0x1
	// Bit LVLEX0.
	DMAC_ACTIVE_LVLEX0 = 0x1
	// Position of LVLEX1 field.
	DMAC_ACTIVE_LVLEX1_Pos = 0x1
	// Bit mask of LVLEX1 field.
	DMAC_ACTIVE_LVLEX1_Msk = 0x2
	// Bit LVLEX1.
	DMAC_ACTIVE_LVLEX1 = 0x2
	// Position of LVLEX2 field.
	DMAC_ACTIVE_LVLEX2_Pos = 0x2
	// Bit mask of LVLEX2 field.
	DMAC_ACTIVE_LVLEX2_Msk = 0x4
	// Bit LVLEX2.
	DMAC_ACTIVE_LVLEX2 = 0x4
	// Position of LVLEX3 field.
	DMAC_ACTIVE_LVLEX3_Pos = 0x3
	// Bit mask of LVLEX3 field.
	DMAC_ACTIVE_LVLEX3_Msk = 0x8
	// Bit LVLEX3.
	DMAC_ACTIVE_LVLEX3 = 0x8
	// Position of ID field.
	DMAC_ACTIVE_ID_Pos = 0x8
	// Bit mask of ID field.
	DMAC_ACTIVE_ID_Msk = 0x1f00
	// Position of ABUSY field.
	DMAC_ACTIVE_ABUSY_Pos = 0xf
	// Bit mask of ABUSY field.
	DMAC_ACTIVE_ABUSY_Msk = 0x8000
	// Bit ABUSY.
	DMAC_ACTIVE_ABUSY = 0x8000
	// Position of BTCNT field.
	DMAC_ACTIVE_BTCNT_Pos = 0x10
	// Bit mask of BTCNT field.
	DMAC_ACTIVE_BTCNT_Msk = 0xffff0000

	// BASEADDR: Descriptor Memory Section Base Address
	// Position of BASEADDR field.
	DMAC_BASEADDR_BASEADDR_Pos = 0x0
	// Bit mask of BASEADDR field.
	DMAC_BASEADDR_BASEADDR_Msk = 0xffffffff

	// WRBADDR: Write-Back Memory Section Base Address
	// Position of WRBADDR field.
	DMAC_WRBADDR_WRBADDR_Pos = 0x0
	// Bit mask of WRBADDR field.
	DMAC_WRBADDR_WRBADDR_Msk = 0xffffffff

	// CHID: Channel ID
	// Position of ID field.
	DMAC_CHID_ID_Pos = 0x0
	// Bit mask of ID field.
	DMAC_CHID_ID_Msk = 0x7

	// CHCTRLA: Channel Control A
	// Position of SWRST field.
	DMAC_CHCTRLA_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	DMAC_CHCTRLA_SWRST_Msk = 0x1
	// Bit SWRST.
	DMAC_CHCTRLA_SWRST = 0x1
	// Position of ENABLE field.
	DMAC_CHCTRLA_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	DMAC_CHCTRLA_ENABLE_Msk = 0x2
	// Bit ENABLE.
	DMAC_CHCTRLA_ENABLE = 0x2
	// Position of RUNSTDBY field.
	DMAC_CHCTRLA_RUNSTDBY_Pos = 0x6
	// Bit mask of RUNSTDBY field.
	DMAC_CHCTRLA_RUNSTDBY_Msk = 0x40
	// Bit RUNSTDBY.
	DMAC_CHCTRLA_RUNSTDBY = 0x40

	// CHCTRLB: Channel Control B
	// Position of EVACT field.
	DMAC_CHCTRLB_EVACT_Pos = 0x0
	// Bit mask of EVACT field.
	DMAC_CHCTRLB_EVACT_Msk = 0x7
	// No action
	DMAC_CHCTRLB_EVACT_NOACT = 0x0
	// Transfer and periodic transfer trigger
	DMAC_CHCTRLB_EVACT_TRIG = 0x1
	// Conditional transfer trigger
	DMAC_CHCTRLB_EVACT_CTRIG = 0x2
	// Conditional block transfer
	DMAC_CHCTRLB_EVACT_CBLOCK = 0x3
	// Channel suspend operation
	DMAC_CHCTRLB_EVACT_SUSPEND = 0x4
	// Channel resume operation
	DMAC_CHCTRLB_EVACT_RESUME = 0x5
	// Skip next block suspend action
	DMAC_CHCTRLB_EVACT_SSKIP = 0x6
	// Position of EVIE field.
	DMAC_CHCTRLB_EVIE_Pos = 0x3
	// Bit mask of EVIE field.
	DMAC_CHCTRLB_EVIE_Msk = 0x8
	// Bit EVIE.
	DMAC_CHCTRLB_EVIE = 0x8
	// Position of EVOE field.
	DMAC_CHCTRLB_EVOE_Pos = 0x4
	// Bit mask of EVOE field.
	DMAC_CHCTRLB_EVOE_Msk = 0x10
	// Bit EVOE.
	DMAC_CHCTRLB_EVOE = 0x10
	// Position of LVL field.
	DMAC_CHCTRLB_LVL_Pos = 0x5
	// Bit mask of LVL field.
	DMAC_CHCTRLB_LVL_Msk = 0x60
	// Position of TRIGSRC field.
	DMAC_CHCTRLB_TRIGSRC_Pos = 0x8
	// Bit mask of TRIGSRC field.
	DMAC_CHCTRLB_TRIGSRC_Msk = 0x1f00
	// Only software/event triggers
	DMAC_CHCTRLB_TRIGSRC_DISABLE = 0x0
	// Position of TRIGACT field.
	DMAC_CHCTRLB_TRIGACT_Pos = 0x16
	// Bit mask of TRIGACT field.
	DMAC_CHCTRLB_TRIGACT_Msk = 0xc00000
	// One trigger required for each block transfer
	DMAC_CHCTRLB_TRIGACT_BLOCK = 0x0
	// One trigger required for each beat transfer
	DMAC_CHCTRLB_TRIGACT_BEAT = 0x2
	// One trigger required for each transaction
	DMAC_CHCTRLB_TRIGACT_TRANSACTION = 0x3
	// Position of CMD field.
	DMAC_CHCTRLB_CMD_Pos = 0x18
	// Bit mask of CMD field.
	DMAC_CHCTRLB_CMD_Msk = 0x3000000
	// No action
	DMAC_CHCTRLB_CMD_NOACT = 0x0
	// Channel suspend operation
	DMAC_CHCTRLB_CMD_SUSPEND = 0x1
	// Channel resume operation
	DMAC_CHCTRLB_CMD_RESUME = 0x2

	// CHINTENCLR: Channel Interrupt Enable Clear
	// Position of TERR field.
	DMAC_CHINTENCLR_TERR_Pos = 0x0
	// Bit mask of TERR field.
	DMAC_CHINTENCLR_TERR_Msk = 0x1
	// Bit TERR.
	DMAC_CHINTENCLR_TERR = 0x1
	// Position of TCMPL field.
	DMAC_CHINTENCLR_TCMPL_Pos = 0x1
	// Bit mask of TCMPL field.
	DMAC_CHINTENCLR_TCMPL_Msk = 0x2
	// Bit TCMPL.
	DMAC_CHINTENCLR_TCMPL = 0x2
	// Position of SUSP field.
	DMAC_CHINTENCLR_SUSP_Pos = 0x2
	// Bit mask of SUSP field.
	DMAC_CHINTENCLR_SUSP_Msk = 0x4
	// Bit SUSP.
	DMAC_CHINTENCLR_SUSP = 0x4

	// CHINTENSET: Channel Interrupt Enable Set
	// Position of TERR field.
	DMAC_CHINTENSET_TERR_Pos = 0x0
	// Bit mask of TERR field.
	DMAC_CHINTENSET_TERR_Msk = 0x1
	// Bit TERR.
	DMAC_CHINTENSET_TERR = 0x1
	// Position of TCMPL field.
	DMAC_CHINTENSET_TCMPL_Pos = 0x1
	// Bit mask of TCMPL field.
	DMAC_CHINTENSET_TCMPL_Msk = 0x2
	// Bit TCMPL.
	DMAC_CHINTENSET_TCMPL = 0x2
	// Position of SUSP field.
	DMAC_CHINTENSET_SUSP_Pos = 0x2
	// Bit mask of SUSP field.
	DMAC_CHINTENSET_SUSP_Msk = 0x4
	// Bit SUSP.
	DMAC_CHINTENSET_SUSP = 0x4

	// CHINTFLAG: Channel Interrupt Flag Status and Clear
	// Position of TERR field.
	DMAC_CHINTFLAG_TERR_Pos = 0x0
	// Bit mask of TERR field.
	DMAC_CHINTFLAG_TERR_Msk = 0x1
	// Bit TERR.
	DMAC_CHINTFLAG_TERR = 0x1
	// Position of TCMPL field.
	DMAC_CHINTFLAG_TCMPL_Pos = 0x1
	// Bit mask of TCMPL field.
	DMAC_CHINTFLAG_TCMPL_Msk = 0x2
	// Bit TCMPL.
	DMAC_CHINTFLAG_TCMPL = 0x2
	// Position of SUSP field.
	DMAC_CHINTFLAG_SUSP_Pos = 0x2
	// Bit mask of SUSP field.
	DMAC_CHINTFLAG_SUSP_Msk = 0x4
	// Bit SUSP.
	DMAC_CHINTFLAG_SUSP = 0x4

	// CHSTATUS: Channel Status
	// Position of PEND field.
	DMAC_CHSTATUS_PEND_Pos = 0x0
	// Bit mask of PEND field.
	DMAC_CHSTATUS_PEND_Msk = 0x1
	// Bit PEND.
	DMAC_CHSTATUS_PEND = 0x1
	// Position of BUSY field.
	DMAC_CHSTATUS_BUSY_Pos = 0x1
	// Bit mask of BUSY field.
	DMAC_CHSTATUS_BUSY_Msk = 0x2
	// Bit BUSY.
	DMAC_CHSTATUS_BUSY = 0x2
	// Position of FERR field.
	DMAC_CHSTATUS_FERR_Pos = 0x2
	// Bit mask of FERR field.
	DMAC_CHSTATUS_FERR_Msk = 0x4
	// Bit FERR.
	DMAC_CHSTATUS_FERR = 0x4
)

// Constants for DSU: Device Service Unit
const (
	// CTRL: Control
	// Position of SWRST field.
	DSU_CTRL_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	DSU_CTRL_SWRST_Msk = 0x1
	// Bit SWRST.
	DSU_CTRL_SWRST = 0x1
	// Position of CRC field.
	DSU_CTRL_CRC_Pos = 0x2
	// Bit mask of CRC field.
	DSU_CTRL_CRC_Msk = 0x4
	// Bit CRC.
	DSU_CTRL_CRC = 0x4
	// Position of MBIST field.
	DSU_CTRL_MBIST_Pos = 0x3
	// Bit mask of MBIST field.
	DSU_CTRL_MBIST_Msk = 0x8
	// Bit MBIST.
	DSU_CTRL_MBIST = 0x8

	// STATUSA: Status A
	// Position of DONE field.
	DSU_STATUSA_DONE_Pos = 0x0
	// Bit mask of DONE field.
	DSU_STATUSA_DONE_Msk = 0x1
	// Bit DONE.
	DSU_STATUSA_DONE = 0x1
	// Position of CRSTEXT field.
	DSU_STATUSA_CRSTEXT_Pos = 0x1
	// Bit mask of CRSTEXT field.
	DSU_STATUSA_CRSTEXT_Msk = 0x2
	// Bit CRSTEXT.
	DSU_STATUSA_CRSTEXT = 0x2
	// Position of BERR field.
	DSU_STATUSA_BERR_Pos = 0x2
	// Bit mask of BERR field.
	DSU_STATUSA_BERR_Msk = 0x4
	// Bit BERR.
	DSU_STATUSA_BERR = 0x4
	// Position of FAIL field.
	DSU_STATUSA_FAIL_Pos = 0x3
	// Bit mask of FAIL field.
	DSU_STATUSA_FAIL_Msk = 0x8
	// Bit FAIL.
	DSU_STATUSA_FAIL = 0x8
	// Position of PERR field.
	DSU_STATUSA_PERR_Pos = 0x4
	// Bit mask of PERR field.
	DSU_STATUSA_PERR_Msk = 0x10
	// Bit PERR.
	DSU_STATUSA_PERR = 0x10
	// Position of BREXT field.
	DSU_STATUSA_BREXT_Pos = 0x5
	// Bit mask of BREXT field.
	DSU_STATUSA_BREXT_Msk = 0x20
	// Bit BREXT.
	DSU_STATUSA_BREXT = 0x20

	// STATUSB: Status B
	// Position of DAL field.
	DSU_STATUSB_DAL_Pos = 0x0
	// Bit mask of DAL field.
	DSU_STATUSB_DAL_Msk        = 0x3
	DSU_STATUSB_DAL_SECURED    = 0x0
	DSU_STATUSB_DAL_NS_DEBUG   = 0x1
	DSU_STATUSB_DAL_FULL_DEBUG = 0x2
	// Position of DBGPRES field.
	DSU_STATUSB_DBGPRES_Pos = 0x2
	// Bit mask of DBGPRES field.
	DSU_STATUSB_DBGPRES_Msk = 0x4
	// Bit DBGPRES.
	DSU_STATUSB_DBGPRES = 0x4
	// Position of HPE field.
	DSU_STATUSB_HPE_Pos = 0x3
	// Bit mask of HPE field.
	DSU_STATUSB_HPE_Msk = 0x8
	// Bit HPE.
	DSU_STATUSB_HPE = 0x8
	// Position of DCCD0 field.
	DSU_STATUSB_DCCD0_Pos = 0x4
	// Bit mask of DCCD0 field.
	DSU_STATUSB_DCCD0_Msk = 0x10
	// Bit DCCD0.
	DSU_STATUSB_DCCD0 = 0x10
	// Position of DCCD1 field.
	DSU_STATUSB_DCCD1_Pos = 0x5
	// Bit mask of DCCD1 field.
	DSU_STATUSB_DCCD1_Msk = 0x20
	// Bit DCCD1.
	DSU_STATUSB_DCCD1 = 0x20
	// Position of BCCD0 field.
	DSU_STATUSB_BCCD0_Pos = 0x6
	// Bit mask of BCCD0 field.
	DSU_STATUSB_BCCD0_Msk = 0x40
	// Bit BCCD0.
	DSU_STATUSB_BCCD0 = 0x40
	// Position of BCCD1 field.
	DSU_STATUSB_BCCD1_Pos = 0x7
	// Bit mask of BCCD1 field.
	DSU_STATUSB_BCCD1_Msk = 0x80
	// Bit BCCD1.
	DSU_STATUSB_BCCD1 = 0x80

	// ADDR: Address
	// Position of AMOD field.
	DSU_ADDR_AMOD_Pos = 0x0
	// Bit mask of AMOD field.
	DSU_ADDR_AMOD_Msk = 0x3
	// Position of ADDR field.
	DSU_ADDR_ADDR_Pos = 0x2
	// Bit mask of ADDR field.
	DSU_ADDR_ADDR_Msk = 0xfffffffc

	// LENGTH: Length
	// Position of LENGTH field.
	DSU_LENGTH_LENGTH_Pos = 0x2
	// Bit mask of LENGTH field.
	DSU_LENGTH_LENGTH_Msk = 0xfffffffc

	// DATA: Data
	// Position of DATA field.
	DSU_DATA_DATA_Pos = 0x0
	// Bit mask of DATA field.
	DSU_DATA_DATA_Msk = 0xffffffff

	// DCC: Debug Communication Channel n
	// Position of DATA field.
	DSU_DCC_DATA_Pos = 0x0
	// Bit mask of DATA field.
	DSU_DCC_DATA_Msk = 0xffffffff

	// DID: Device Identification
	// Position of DEVSEL field.
	DSU_DID_DEVSEL_Pos = 0x0
	// Bit mask of DEVSEL field.
	DSU_DID_DEVSEL_Msk = 0xff
	// Position of REVISION field.
	DSU_DID_REVISION_Pos = 0x8
	// Bit mask of REVISION field.
	DSU_DID_REVISION_Msk = 0xf00
	// Position of DIE field.
	DSU_DID_DIE_Pos = 0xc
	// Bit mask of DIE field.
	DSU_DID_DIE_Msk = 0xf000
	// Position of SERIES field.
	DSU_DID_SERIES_Pos = 0x10
	// Bit mask of SERIES field.
	DSU_DID_SERIES_Msk = 0x3f0000
	// Cortex-M0+ processor, basic feature set
	DSU_DID_SERIES_0 = 0x0
	// Cortex-M0+ processor, USB
	DSU_DID_SERIES_1 = 0x1
	// Position of FAMILY field.
	DSU_DID_FAMILY_Pos = 0x17
	// Bit mask of FAMILY field.
	DSU_DID_FAMILY_Msk = 0xf800000
	// General purpose microcontroller
	DSU_DID_FAMILY_0 = 0x0
	// PicoPower
	DSU_DID_FAMILY_1 = 0x1
	// Position of PROCESSOR field.
	DSU_DID_PROCESSOR_Pos = 0x1c
	// Bit mask of PROCESSOR field.
	DSU_DID_PROCESSOR_Msk = 0xf0000000
	// Cortex-M0+
	DSU_DID_PROCESSOR_CM0P = 0x1
	// Cortex-M23
	DSU_DID_PROCESSOR_CM23 = 0x2
	// Cortex-M3
	DSU_DID_PROCESSOR_CM3 = 0x3
	// Cortex-M4
	DSU_DID_PROCESSOR_CM4 = 0x5
	// Cortex-M4 with FPU
	DSU_DID_PROCESSOR_CM4F = 0x6
	// Cortex-M33
	DSU_DID_PROCESSOR_CM33 = 0x7

	// CFG: Configuration
	// Position of LQOS field.
	DSU_CFG_LQOS_Pos = 0x0
	// Bit mask of LQOS field.
	DSU_CFG_LQOS_Msk = 0x3
	// Position of DCCDMALEVEL field.
	DSU_CFG_DCCDMALEVEL_Pos = 0x2
	// Bit mask of DCCDMALEVEL field.
	DSU_CFG_DCCDMALEVEL_Msk = 0xc
	// Trigger rises when DCC is empty
	DSU_CFG_DCCDMALEVEL_EMPTY = 0x0
	// Trigger rises when DCC is full
	DSU_CFG_DCCDMALEVEL_FULL = 0x1

	// BCC: Boot ROM Communication Channel n
	// Position of DATA field.
	DSU_BCC_DATA_Pos = 0x0
	// Bit mask of DATA field.
	DSU_BCC_DATA_Msk = 0xffffffff

	// DCFG: Device Configuration
	// Position of DCFG field.
	DSU_DCFG_DCFG_Pos = 0x0
	// Bit mask of DCFG field.
	DSU_DCFG_DCFG_Msk = 0xffffffff

	// ENTRY0: CoreSight ROM Table Entry 0
	// Position of EPRES field.
	DSU_ENTRY0_EPRES_Pos = 0x0
	// Bit mask of EPRES field.
	DSU_ENTRY0_EPRES_Msk = 0x1
	// Bit EPRES.
	DSU_ENTRY0_EPRES = 0x1
	// Position of FMT field.
	DSU_ENTRY0_FMT_Pos = 0x1
	// Bit mask of FMT field.
	DSU_ENTRY0_FMT_Msk = 0x2
	// Bit FMT.
	DSU_ENTRY0_FMT = 0x2
	// Position of ADDOFF field.
	DSU_ENTRY0_ADDOFF_Pos = 0xc
	// Bit mask of ADDOFF field.
	DSU_ENTRY0_ADDOFF_Msk = 0xfffff000

	// END: CoreSight ROM Table End
	// Position of END field.
	DSU_END_END_Pos = 0x0
	// Bit mask of END field.
	DSU_END_END_Msk = 0xffffffff

	// MEMTYPE: CoreSight ROM Table Memory Type
	// Position of SMEMP field.
	DSU_MEMTYPE_SMEMP_Pos = 0x0
	// Bit mask of SMEMP field.
	DSU_MEMTYPE_SMEMP_Msk = 0x1
	// Bit SMEMP.
	DSU_MEMTYPE_SMEMP = 0x1

	// PID4: Peripheral Identification 4
	// Position of JEPCC field.
	DSU_PID4_JEPCC_Pos = 0x0
	// Bit mask of JEPCC field.
	DSU_PID4_JEPCC_Msk = 0xf
	// Position of FKBC field.
	DSU_PID4_FKBC_Pos = 0x4
	// Bit mask of FKBC field.
	DSU_PID4_FKBC_Msk = 0xf0

	// PID0: Peripheral Identification 0
	// Position of PARTNBL field.
	DSU_PID0_PARTNBL_Pos = 0x0
	// Bit mask of PARTNBL field.
	DSU_PID0_PARTNBL_Msk = 0xff

	// PID1: Peripheral Identification 1
	// Position of PARTNBH field.
	DSU_PID1_PARTNBH_Pos = 0x0
	// Bit mask of PARTNBH field.
	DSU_PID1_PARTNBH_Msk = 0xf
	// Position of JEPIDCL field.
	DSU_PID1_JEPIDCL_Pos = 0x4
	// Bit mask of JEPIDCL field.
	DSU_PID1_JEPIDCL_Msk = 0xf0

	// PID2: Peripheral Identification 2
	// Position of JEPIDCH field.
	DSU_PID2_JEPIDCH_Pos = 0x0
	// Bit mask of JEPIDCH field.
	DSU_PID2_JEPIDCH_Msk = 0x7
	// Position of JEPU field.
	DSU_PID2_JEPU_Pos = 0x3
	// Bit mask of JEPU field.
	DSU_PID2_JEPU_Msk = 0x8
	// Bit JEPU.
	DSU_PID2_JEPU = 0x8
	// Position of REVISION field.
	DSU_PID2_REVISION_Pos = 0x4
	// Bit mask of REVISION field.
	DSU_PID2_REVISION_Msk = 0xf0

	// PID3: Peripheral Identification 3
	// Position of CUSMOD field.
	DSU_PID3_CUSMOD_Pos = 0x0
	// Bit mask of CUSMOD field.
	DSU_PID3_CUSMOD_Msk = 0xf
	// Position of REVAND field.
	DSU_PID3_REVAND_Pos = 0x4
	// Bit mask of REVAND field.
	DSU_PID3_REVAND_Msk = 0xf0

	// CID0: Component Identification 0
	// Position of PREAMBLEB0 field.
	DSU_CID0_PREAMBLEB0_Pos = 0x0
	// Bit mask of PREAMBLEB0 field.
	DSU_CID0_PREAMBLEB0_Msk = 0xff

	// CID1: Component Identification 1
	// Position of PREAMBLE field.
	DSU_CID1_PREAMBLE_Pos = 0x0
	// Bit mask of PREAMBLE field.
	DSU_CID1_PREAMBLE_Msk = 0xf
	// Position of CCLASS field.
	DSU_CID1_CCLASS_Pos = 0x4
	// Bit mask of CCLASS field.
	DSU_CID1_CCLASS_Msk = 0xf0

	// CID2: Component Identification 2
	// Position of PREAMBLEB2 field.
	DSU_CID2_PREAMBLEB2_Pos = 0x0
	// Bit mask of PREAMBLEB2 field.
	DSU_CID2_PREAMBLEB2_Msk = 0xff

	// CID3: Component Identification 3
	// Position of PREAMBLEB3 field.
	DSU_CID3_PREAMBLEB3_Pos = 0x0
	// Bit mask of PREAMBLEB3 field.
	DSU_CID3_PREAMBLEB3_Msk = 0xff
)

// Constants for EIC: External Interrupt Controller
const (
	// CTRLA: Control A
	// Position of SWRST field.
	EIC_CTRLA_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	EIC_CTRLA_SWRST_Msk = 0x1
	// Bit SWRST.
	EIC_CTRLA_SWRST = 0x1
	// Position of ENABLE field.
	EIC_CTRLA_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	EIC_CTRLA_ENABLE_Msk = 0x2
	// Bit ENABLE.
	EIC_CTRLA_ENABLE = 0x2
	// Position of CKSEL field.
	EIC_CTRLA_CKSEL_Pos = 0x4
	// Bit mask of CKSEL field.
	EIC_CTRLA_CKSEL_Msk = 0x10
	// Bit CKSEL.
	EIC_CTRLA_CKSEL = 0x10

	// NMICTRL: Non-Maskable Interrupt Control
	// Position of NMISENSE field.
	EIC_NMICTRL_NMISENSE_Pos = 0x0
	// Bit mask of NMISENSE field.
	EIC_NMICTRL_NMISENSE_Msk = 0x7
	// No detection
	EIC_NMICTRL_NMISENSE_NONE = 0x0
	// Rising-edge detection
	EIC_NMICTRL_NMISENSE_RISE = 0x1
	// Falling-edge detection
	EIC_NMICTRL_NMISENSE_FALL = 0x2
	// Both-edges detection
	EIC_NMICTRL_NMISENSE_BOTH = 0x3
	// High-level detection
	EIC_NMICTRL_NMISENSE_HIGH = 0x4
	// Low-level detection
	EIC_NMICTRL_NMISENSE_LOW = 0x5
	// Position of NMIFILTEN field.
	EIC_NMICTRL_NMIFILTEN_Pos = 0x3
	// Bit mask of NMIFILTEN field.
	EIC_NMICTRL_NMIFILTEN_Msk = 0x8
	// Bit NMIFILTEN.
	EIC_NMICTRL_NMIFILTEN = 0x8
	// Position of NMIASYNCH field.
	EIC_NMICTRL_NMIASYNCH_Pos = 0x4
	// Bit mask of NMIASYNCH field.
	EIC_NMICTRL_NMIASYNCH_Msk = 0x10
	// Bit NMIASYNCH.
	EIC_NMICTRL_NMIASYNCH = 0x10

	// NMIFLAG: Non-Maskable Interrupt Flag Status and Clear
	// Position of NMI field.
	EIC_NMIFLAG_NMI_Pos = 0x0
	// Bit mask of NMI field.
	EIC_NMIFLAG_NMI_Msk = 0x1
	// Bit NMI.
	EIC_NMIFLAG_NMI = 0x1

	// SYNCBUSY: Synchronization Busy
	// Position of SWRST field.
	EIC_SYNCBUSY_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	EIC_SYNCBUSY_SWRST_Msk = 0x1
	// Bit SWRST.
	EIC_SYNCBUSY_SWRST = 0x1
	// Position of ENABLE field.
	EIC_SYNCBUSY_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	EIC_SYNCBUSY_ENABLE_Msk = 0x2
	// Bit ENABLE.
	EIC_SYNCBUSY_ENABLE = 0x2

	// EVCTRL: Event Control
	// Position of EXTINTEO field.
	EIC_EVCTRL_EXTINTEO_Pos = 0x0
	// Bit mask of EXTINTEO field.
	EIC_EVCTRL_EXTINTEO_Msk = 0xff

	// INTENCLR: Interrupt Enable Clear
	// Position of EXTINT field.
	EIC_INTENCLR_EXTINT_Pos = 0x0
	// Bit mask of EXTINT field.
	EIC_INTENCLR_EXTINT_Msk = 0xff
	// Position of NSCHK field.
	EIC_INTENCLR_NSCHK_Pos = 0x1f
	// Bit mask of NSCHK field.
	EIC_INTENCLR_NSCHK_Msk = 0x80000000
	// Bit NSCHK.
	EIC_INTENCLR_NSCHK = 0x80000000

	// INTENSET: Interrupt Enable Set
	// Position of EXTINT field.
	EIC_INTENSET_EXTINT_Pos = 0x0
	// Bit mask of EXTINT field.
	EIC_INTENSET_EXTINT_Msk = 0xff
	// Position of NSCHK field.
	EIC_INTENSET_NSCHK_Pos = 0x1f
	// Bit mask of NSCHK field.
	EIC_INTENSET_NSCHK_Msk = 0x80000000
	// Bit NSCHK.
	EIC_INTENSET_NSCHK = 0x80000000

	// INTFLAG: Interrupt Flag Status and Clear
	// Position of EXTINT field.
	EIC_INTFLAG_EXTINT_Pos = 0x0
	// Bit mask of EXTINT field.
	EIC_INTFLAG_EXTINT_Msk = 0xff
	// Position of NSCHK field.
	EIC_INTFLAG_NSCHK_Pos = 0x1f
	// Bit mask of NSCHK field.
	EIC_INTFLAG_NSCHK_Msk = 0x80000000
	// Bit NSCHK.
	EIC_INTFLAG_NSCHK = 0x80000000

	// ASYNCH: External Interrupt Asynchronous Mode
	// Position of ASYNCH field.
	EIC_ASYNCH_ASYNCH_Pos = 0x0
	// Bit mask of ASYNCH field.
	EIC_ASYNCH_ASYNCH_Msk = 0xff

	// CONFIG: External Interrupt Sense Configuration
	// Position of SENSE0 field.
	EIC_CONFIG_SENSE0_Pos = 0x0
	// Bit mask of SENSE0 field.
	EIC_CONFIG_SENSE0_Msk = 0x7
	// No detection
	EIC_CONFIG_SENSE0_NONE = 0x0
	// Rising edge detection
	EIC_CONFIG_SENSE0_RISE = 0x1
	// Falling edge detection
	EIC_CONFIG_SENSE0_FALL = 0x2
	// Both edges detection
	EIC_CONFIG_SENSE0_BOTH = 0x3
	// High level detection
	EIC_CONFIG_SENSE0_HIGH = 0x4
	// Low level detection
	EIC_CONFIG_SENSE0_LOW = 0x5
	// Position of FILTEN0 field.
	EIC_CONFIG_FILTEN0_Pos = 0x3
	// Bit mask of FILTEN0 field.
	EIC_CONFIG_FILTEN0_Msk = 0x8
	// Bit FILTEN0.
	EIC_CONFIG_FILTEN0 = 0x8
	// Position of SENSE1 field.
	EIC_CONFIG_SENSE1_Pos = 0x4
	// Bit mask of SENSE1 field.
	EIC_CONFIG_SENSE1_Msk = 0x70
	// No detection
	EIC_CONFIG_SENSE1_NONE = 0x0
	// Rising edge detection
	EIC_CONFIG_SENSE1_RISE = 0x1
	// Falling edge detection
	EIC_CONFIG_SENSE1_FALL = 0x2
	// Both edges detection
	EIC_CONFIG_SENSE1_BOTH = 0x3
	// High level detection
	EIC_CONFIG_SENSE1_HIGH = 0x4
	// Low level detection
	EIC_CONFIG_SENSE1_LOW = 0x5
	// Position of FILTEN1 field.
	EIC_CONFIG_FILTEN1_Pos = 0x7
	// Bit mask of FILTEN1 field.
	EIC_CONFIG_FILTEN1_Msk = 0x80
	// Bit FILTEN1.
	EIC_CONFIG_FILTEN1 = 0x80
	// Position of SENSE2 field.
	EIC_CONFIG_SENSE2_Pos = 0x8
	// Bit mask of SENSE2 field.
	EIC_CONFIG_SENSE2_Msk = 0x700
	// No detection
	EIC_CONFIG_SENSE2_NONE = 0x0
	// Rising edge detection
	EIC_CONFIG_SENSE2_RISE = 0x1
	// Falling edge detection
	EIC_CONFIG_SENSE2_FALL = 0x2
	// Both edges detection
	EIC_CONFIG_SENSE2_BOTH = 0x3
	// High level detection
	EIC_CONFIG_SENSE2_HIGH = 0x4
	// Low level detection
	EIC_CONFIG_SENSE2_LOW = 0x5
	// Position of FILTEN2 field.
	EIC_CONFIG_FILTEN2_Pos = 0xb
	// Bit mask of FILTEN2 field.
	EIC_CONFIG_FILTEN2_Msk = 0x800
	// Bit FILTEN2.
	EIC_CONFIG_FILTEN2 = 0x800
	// Position of SENSE3 field.
	EIC_CONFIG_SENSE3_Pos = 0xc
	// Bit mask of SENSE3 field.
	EIC_CONFIG_SENSE3_Msk = 0x7000
	// No detection
	EIC_CONFIG_SENSE3_NONE = 0x0
	// Rising edge detection
	EIC_CONFIG_SENSE3_RISE = 0x1
	// Falling edge detection
	EIC_CONFIG_SENSE3_FALL = 0x2
	// Both edges detection
	EIC_CONFIG_SENSE3_BOTH = 0x3
	// High level detection
	EIC_CONFIG_SENSE3_HIGH = 0x4
	// Low level detection
	EIC_CONFIG_SENSE3_LOW = 0x5
	// Position of FILTEN3 field.
	EIC_CONFIG_FILTEN3_Pos = 0xf
	// Bit mask of FILTEN3 field.
	EIC_CONFIG_FILTEN3_Msk = 0x8000
	// Bit FILTEN3.
	EIC_CONFIG_FILTEN3 = 0x8000
	// Position of SENSE4 field.
	EIC_CONFIG_SENSE4_Pos = 0x10
	// Bit mask of SENSE4 field.
	EIC_CONFIG_SENSE4_Msk = 0x70000
	// No detection
	EIC_CONFIG_SENSE4_NONE = 0x0
	// Rising edge detection
	EIC_CONFIG_SENSE4_RISE = 0x1
	// Falling edge detection
	EIC_CONFIG_SENSE4_FALL = 0x2
	// Both edges detection
	EIC_CONFIG_SENSE4_BOTH = 0x3
	// High level detection
	EIC_CONFIG_SENSE4_HIGH = 0x4
	// Low level detection
	EIC_CONFIG_SENSE4_LOW = 0x5
	// Position of FILTEN4 field.
	EIC_CONFIG_FILTEN4_Pos = 0x13
	// Bit mask of FILTEN4 field.
	EIC_CONFIG_FILTEN4_Msk = 0x80000
	// Bit FILTEN4.
	EIC_CONFIG_FILTEN4 = 0x80000
	// Position of SENSE5 field.
	EIC_CONFIG_SENSE5_Pos = 0x14
	// Bit mask of SENSE5 field.
	EIC_CONFIG_SENSE5_Msk = 0x700000
	// No detection
	EIC_CONFIG_SENSE5_NONE = 0x0
	// Rising edge detection
	EIC_CONFIG_SENSE5_RISE = 0x1
	// Falling edge detection
	EIC_CONFIG_SENSE5_FALL = 0x2
	// Both edges detection
	EIC_CONFIG_SENSE5_BOTH = 0x3
	// High level detection
	EIC_CONFIG_SENSE5_HIGH = 0x4
	// Low level detection
	EIC_CONFIG_SENSE5_LOW = 0x5
	// Position of FILTEN5 field.
	EIC_CONFIG_FILTEN5_Pos = 0x17
	// Bit mask of FILTEN5 field.
	EIC_CONFIG_FILTEN5_Msk = 0x800000
	// Bit FILTEN5.
	EIC_CONFIG_FILTEN5 = 0x800000
	// Position of SENSE6 field.
	EIC_CONFIG_SENSE6_Pos = 0x18
	// Bit mask of SENSE6 field.
	EIC_CONFIG_SENSE6_Msk = 0x7000000
	// No detection
	EIC_CONFIG_SENSE6_NONE = 0x0
	// Rising edge detection
	EIC_CONFIG_SENSE6_RISE = 0x1
	// Falling edge detection
	EIC_CONFIG_SENSE6_FALL = 0x2
	// Both edges detection
	EIC_CONFIG_SENSE6_BOTH = 0x3
	// High level detection
	EIC_CONFIG_SENSE6_HIGH = 0x4
	// Low level detection
	EIC_CONFIG_SENSE6_LOW = 0x5
	// Position of FILTEN6 field.
	EIC_CONFIG_FILTEN6_Pos = 0x1b
	// Bit mask of FILTEN6 field.
	EIC_CONFIG_FILTEN6_Msk = 0x8000000
	// Bit FILTEN6.
	EIC_CONFIG_FILTEN6 = 0x8000000
	// Position of SENSE7 field.
	EIC_CONFIG_SENSE7_Pos = 0x1c
	// Bit mask of SENSE7 field.
	EIC_CONFIG_SENSE7_Msk = 0x70000000
	// No detection
	EIC_CONFIG_SENSE7_NONE = 0x0
	// Rising edge detection
	EIC_CONFIG_SENSE7_RISE = 0x1
	// Falling edge detection
	EIC_CONFIG_SENSE7_FALL = 0x2
	// Both edges detection
	EIC_CONFIG_SENSE7_BOTH = 0x3
	// High level detection
	EIC_CONFIG_SENSE7_HIGH = 0x4
	// Low level detection
	EIC_CONFIG_SENSE7_LOW = 0x5
	// Position of FILTEN7 field.
	EIC_CONFIG_FILTEN7_Pos = 0x1f
	// Bit mask of FILTEN7 field.
	EIC_CONFIG_FILTEN7_Msk = 0x80000000
	// Bit FILTEN7.
	EIC_CONFIG_FILTEN7 = 0x80000000

	// DEBOUNCEN: Debouncer Enable
	// Position of DEBOUNCEN field.
	EIC_DEBOUNCEN_DEBOUNCEN_Pos = 0x0
	// Bit mask of DEBOUNCEN field.
	EIC_DEBOUNCEN_DEBOUNCEN_Msk = 0xff

	// DPRESCALER: Debouncer Prescaler
	// Position of PRESCALER0 field.
	EIC_DPRESCALER_PRESCALER0_Pos = 0x0
	// Bit mask of PRESCALER0 field.
	EIC_DPRESCALER_PRESCALER0_Msk = 0x7
	// Position of STATES0 field.
	EIC_DPRESCALER_STATES0_Pos = 0x3
	// Bit mask of STATES0 field.
	EIC_DPRESCALER_STATES0_Msk = 0x8
	// Bit STATES0.
	EIC_DPRESCALER_STATES0 = 0x8
	// Position of TICKON field.
	EIC_DPRESCALER_TICKON_Pos = 0x10
	// Bit mask of TICKON field.
	EIC_DPRESCALER_TICKON_Msk = 0x10000
	// Bit TICKON.
	EIC_DPRESCALER_TICKON = 0x10000

	// PINSTATE: Pin State
	// Position of PINSTATE field.
	EIC_PINSTATE_PINSTATE_Pos = 0x0
	// Bit mask of PINSTATE field.
	EIC_PINSTATE_PINSTATE_Msk = 0xff

	// NSCHK: Non-secure Interrupt Check Enable
	// Position of EXTINT field.
	EIC_NSCHK_EXTINT_Pos = 0x0
	// Bit mask of EXTINT field.
	EIC_NSCHK_EXTINT_Msk = 0xff
	// Position of NMI field.
	EIC_NSCHK_NMI_Pos = 0x1f
	// Bit mask of NMI field.
	EIC_NSCHK_NMI_Msk = 0x80000000
	// Bit NMI.
	EIC_NSCHK_NMI = 0x80000000

	// NONSEC: Non-secure Interrupt
	// Position of EXTINT field.
	EIC_NONSEC_EXTINT_Pos = 0x0
	// Bit mask of EXTINT field.
	EIC_NONSEC_EXTINT_Msk = 0xff
	// Position of NMI field.
	EIC_NONSEC_NMI_Pos = 0x1f
	// Bit mask of NMI field.
	EIC_NONSEC_NMI_Msk = 0x80000000
	// Bit NMI.
	EIC_NONSEC_NMI = 0x80000000
)

// Constants for EVSYS: Event System Interface
const (
	// CTRLA: Control
	// Position of SWRST field.
	EVSYS_CTRLA_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	EVSYS_CTRLA_SWRST_Msk = 0x1
	// Bit SWRST.
	EVSYS_CTRLA_SWRST = 0x1

	// SWEVT: Software Event
	// Position of CHANNEL0 field.
	EVSYS_SWEVT_CHANNEL0_Pos = 0x0
	// Bit mask of CHANNEL0 field.
	EVSYS_SWEVT_CHANNEL0_Msk = 0x1
	// Bit CHANNEL0.
	EVSYS_SWEVT_CHANNEL0 = 0x1
	// Position of CHANNEL1 field.
	EVSYS_SWEVT_CHANNEL1_Pos = 0x1
	// Bit mask of CHANNEL1 field.
	EVSYS_SWEVT_CHANNEL1_Msk = 0x2
	// Bit CHANNEL1.
	EVSYS_SWEVT_CHANNEL1 = 0x2
	// Position of CHANNEL2 field.
	EVSYS_SWEVT_CHANNEL2_Pos = 0x2
	// Bit mask of CHANNEL2 field.
	EVSYS_SWEVT_CHANNEL2_Msk = 0x4
	// Bit CHANNEL2.
	EVSYS_SWEVT_CHANNEL2 = 0x4
	// Position of CHANNEL3 field.
	EVSYS_SWEVT_CHANNEL3_Pos = 0x3
	// Bit mask of CHANNEL3 field.
	EVSYS_SWEVT_CHANNEL3_Msk = 0x8
	// Bit CHANNEL3.
	EVSYS_SWEVT_CHANNEL3 = 0x8
	// Position of CHANNEL4 field.
	EVSYS_SWEVT_CHANNEL4_Pos = 0x4
	// Bit mask of CHANNEL4 field.
	EVSYS_SWEVT_CHANNEL4_Msk = 0x10
	// Bit CHANNEL4.
	EVSYS_SWEVT_CHANNEL4 = 0x10
	// Position of CHANNEL5 field.
	EVSYS_SWEVT_CHANNEL5_Pos = 0x5
	// Bit mask of CHANNEL5 field.
	EVSYS_SWEVT_CHANNEL5_Msk = 0x20
	// Bit CHANNEL5.
	EVSYS_SWEVT_CHANNEL5 = 0x20
	// Position of CHANNEL6 field.
	EVSYS_SWEVT_CHANNEL6_Pos = 0x6
	// Bit mask of CHANNEL6 field.
	EVSYS_SWEVT_CHANNEL6_Msk = 0x40
	// Bit CHANNEL6.
	EVSYS_SWEVT_CHANNEL6 = 0x40
	// Position of CHANNEL7 field.
	EVSYS_SWEVT_CHANNEL7_Pos = 0x7
	// Bit mask of CHANNEL7 field.
	EVSYS_SWEVT_CHANNEL7_Msk = 0x80
	// Bit CHANNEL7.
	EVSYS_SWEVT_CHANNEL7 = 0x80

	// PRICTRL: Priority Control
	// Position of PRI field.
	EVSYS_PRICTRL_PRI_Pos = 0x0
	// Bit mask of PRI field.
	EVSYS_PRICTRL_PRI_Msk = 0x3
	// Position of RREN field.
	EVSYS_PRICTRL_RREN_Pos = 0x7
	// Bit mask of RREN field.
	EVSYS_PRICTRL_RREN_Msk = 0x80
	// Bit RREN.
	EVSYS_PRICTRL_RREN = 0x80

	// INTPEND: Channel Pending Interrupt
	// Position of ID field.
	EVSYS_INTPEND_ID_Pos = 0x0
	// Bit mask of ID field.
	EVSYS_INTPEND_ID_Msk = 0x3
	// Position of OVR field.
	EVSYS_INTPEND_OVR_Pos = 0x8
	// Bit mask of OVR field.
	EVSYS_INTPEND_OVR_Msk = 0x100
	// Bit OVR.
	EVSYS_INTPEND_OVR = 0x100
	// Position of EVD field.
	EVSYS_INTPEND_EVD_Pos = 0x9
	// Bit mask of EVD field.
	EVSYS_INTPEND_EVD_Msk = 0x200
	// Bit EVD.
	EVSYS_INTPEND_EVD = 0x200
	// Position of READY field.
	EVSYS_INTPEND_READY_Pos = 0xe
	// Bit mask of READY field.
	EVSYS_INTPEND_READY_Msk = 0x4000
	// Bit READY.
	EVSYS_INTPEND_READY = 0x4000
	// Position of BUSY field.
	EVSYS_INTPEND_BUSY_Pos = 0xf
	// Bit mask of BUSY field.
	EVSYS_INTPEND_BUSY_Msk = 0x8000
	// Bit BUSY.
	EVSYS_INTPEND_BUSY = 0x8000

	// INTSTATUS: Interrupt Status
	// Position of CHINT0 field.
	EVSYS_INTSTATUS_CHINT0_Pos = 0x0
	// Bit mask of CHINT0 field.
	EVSYS_INTSTATUS_CHINT0_Msk = 0x1
	// Bit CHINT0.
	EVSYS_INTSTATUS_CHINT0 = 0x1
	// Position of CHINT1 field.
	EVSYS_INTSTATUS_CHINT1_Pos = 0x1
	// Bit mask of CHINT1 field.
	EVSYS_INTSTATUS_CHINT1_Msk = 0x2
	// Bit CHINT1.
	EVSYS_INTSTATUS_CHINT1 = 0x2
	// Position of CHINT2 field.
	EVSYS_INTSTATUS_CHINT2_Pos = 0x2
	// Bit mask of CHINT2 field.
	EVSYS_INTSTATUS_CHINT2_Msk = 0x4
	// Bit CHINT2.
	EVSYS_INTSTATUS_CHINT2 = 0x4
	// Position of CHINT3 field.
	EVSYS_INTSTATUS_CHINT3_Pos = 0x3
	// Bit mask of CHINT3 field.
	EVSYS_INTSTATUS_CHINT3_Msk = 0x8
	// Bit CHINT3.
	EVSYS_INTSTATUS_CHINT3 = 0x8

	// BUSYCH: Busy Channels
	// Position of BUSYCH0 field.
	EVSYS_BUSYCH_BUSYCH0_Pos = 0x0
	// Bit mask of BUSYCH0 field.
	EVSYS_BUSYCH_BUSYCH0_Msk = 0x1
	// Bit BUSYCH0.
	EVSYS_BUSYCH_BUSYCH0 = 0x1
	// Position of BUSYCH1 field.
	EVSYS_BUSYCH_BUSYCH1_Pos = 0x1
	// Bit mask of BUSYCH1 field.
	EVSYS_BUSYCH_BUSYCH1_Msk = 0x2
	// Bit BUSYCH1.
	EVSYS_BUSYCH_BUSYCH1 = 0x2
	// Position of BUSYCH2 field.
	EVSYS_BUSYCH_BUSYCH2_Pos = 0x2
	// Bit mask of BUSYCH2 field.
	EVSYS_BUSYCH_BUSYCH2_Msk = 0x4
	// Bit BUSYCH2.
	EVSYS_BUSYCH_BUSYCH2 = 0x4
	// Position of BUSYCH3 field.
	EVSYS_BUSYCH_BUSYCH3_Pos = 0x3
	// Bit mask of BUSYCH3 field.
	EVSYS_BUSYCH_BUSYCH3_Msk = 0x8
	// Bit BUSYCH3.
	EVSYS_BUSYCH_BUSYCH3 = 0x8

	// READYUSR: Ready Users
	// Position of READYUSR0 field.
	EVSYS_READYUSR_READYUSR0_Pos = 0x0
	// Bit mask of READYUSR0 field.
	EVSYS_READYUSR_READYUSR0_Msk = 0x1
	// Bit READYUSR0.
	EVSYS_READYUSR_READYUSR0 = 0x1
	// Position of READYUSR1 field.
	EVSYS_READYUSR_READYUSR1_Pos = 0x1
	// Bit mask of READYUSR1 field.
	EVSYS_READYUSR_READYUSR1_Msk = 0x2
	// Bit READYUSR1.
	EVSYS_READYUSR_READYUSR1 = 0x2
	// Position of READYUSR2 field.
	EVSYS_READYUSR_READYUSR2_Pos = 0x2
	// Bit mask of READYUSR2 field.
	EVSYS_READYUSR_READYUSR2_Msk = 0x4
	// Bit READYUSR2.
	EVSYS_READYUSR_READYUSR2 = 0x4
	// Position of READYUSR3 field.
	EVSYS_READYUSR_READYUSR3_Pos = 0x3
	// Bit mask of READYUSR3 field.
	EVSYS_READYUSR_READYUSR3_Msk = 0x8
	// Bit READYUSR3.
	EVSYS_READYUSR_READYUSR3 = 0x8

	// CHANNEL.CHANNEL: Channel n Control
	// Position of EVGEN field.
	EVSYS_CHANNEL_CHANNEL_EVGEN_Pos = 0x0
	// Bit mask of EVGEN field.
	EVSYS_CHANNEL_CHANNEL_EVGEN_Msk = 0x3f
	// Position of PATH field.
	EVSYS_CHANNEL_CHANNEL_PATH_Pos = 0x8
	// Bit mask of PATH field.
	EVSYS_CHANNEL_CHANNEL_PATH_Msk = 0x300
	// Synchronous path
	EVSYS_CHANNEL_CHANNEL_PATH_SYNCHRONOUS = 0x0
	// Resynchronized path
	EVSYS_CHANNEL_CHANNEL_PATH_RESYNCHRONIZED = 0x1
	// Asynchronous path
	EVSYS_CHANNEL_CHANNEL_PATH_ASYNCHRONOUS = 0x2
	// Position of EDGSEL field.
	EVSYS_CHANNEL_CHANNEL_EDGSEL_Pos = 0xa
	// Bit mask of EDGSEL field.
	EVSYS_CHANNEL_CHANNEL_EDGSEL_Msk = 0xc00
	// No event output when using the resynchronized or synchronous path
	EVSYS_CHANNEL_CHANNEL_EDGSEL_NO_EVT_OUTPUT = 0x0
	// Event detection only on the rising edge of the signal from the event generator when using the resynchronized or synchronous path
	EVSYS_CHANNEL_CHANNEL_EDGSEL_RISING_EDGE = 0x1
	// Event detection only on the falling edge of the signal from the event generator when using the resynchronized or synchronous path
	EVSYS_CHANNEL_CHANNEL_EDGSEL_FALLING_EDGE = 0x2
	// Event detection on rising and falling edges of the signal from the event generator when using the resynchronized or synchronous path
	EVSYS_CHANNEL_CHANNEL_EDGSEL_BOTH_EDGES = 0x3
	// Position of RUNSTDBY field.
	EVSYS_CHANNEL_CHANNEL_RUNSTDBY_Pos = 0xe
	// Bit mask of RUNSTDBY field.
	EVSYS_CHANNEL_CHANNEL_RUNSTDBY_Msk = 0x4000
	// Bit RUNSTDBY.
	EVSYS_CHANNEL_CHANNEL_RUNSTDBY = 0x4000
	// Position of ONDEMAND field.
	EVSYS_CHANNEL_CHANNEL_ONDEMAND_Pos = 0xf
	// Bit mask of ONDEMAND field.
	EVSYS_CHANNEL_CHANNEL_ONDEMAND_Msk = 0x8000
	// Bit ONDEMAND.
	EVSYS_CHANNEL_CHANNEL_ONDEMAND = 0x8000

	// CHANNEL.CHINTENCLR: Channel n Interrupt Enable Clear
	// Position of OVR field.
	EVSYS_CHANNEL_CHINTENCLR_OVR_Pos = 0x0
	// Bit mask of OVR field.
	EVSYS_CHANNEL_CHINTENCLR_OVR_Msk = 0x1
	// Bit OVR.
	EVSYS_CHANNEL_CHINTENCLR_OVR = 0x1
	// Position of EVD field.
	EVSYS_CHANNEL_CHINTENCLR_EVD_Pos = 0x1
	// Bit mask of EVD field.
	EVSYS_CHANNEL_CHINTENCLR_EVD_Msk = 0x2
	// Bit EVD.
	EVSYS_CHANNEL_CHINTENCLR_EVD = 0x2

	// CHANNEL.CHINTENSET: Channel n Interrupt Enable Set
	// Position of OVR field.
	EVSYS_CHANNEL_CHINTENSET_OVR_Pos = 0x0
	// Bit mask of OVR field.
	EVSYS_CHANNEL_CHINTENSET_OVR_Msk = 0x1
	// Bit OVR.
	EVSYS_CHANNEL_CHINTENSET_OVR = 0x1
	// Position of EVD field.
	EVSYS_CHANNEL_CHINTENSET_EVD_Pos = 0x1
	// Bit mask of EVD field.
	EVSYS_CHANNEL_CHINTENSET_EVD_Msk = 0x2
	// Bit EVD.
	EVSYS_CHANNEL_CHINTENSET_EVD = 0x2

	// CHANNEL.CHINTFLAG: Channel n Interrupt Flag Status and Clear
	// Position of OVR field.
	EVSYS_CHANNEL_CHINTFLAG_OVR_Pos = 0x0
	// Bit mask of OVR field.
	EVSYS_CHANNEL_CHINTFLAG_OVR_Msk = 0x1
	// Bit OVR.
	EVSYS_CHANNEL_CHINTFLAG_OVR = 0x1
	// Position of EVD field.
	EVSYS_CHANNEL_CHINTFLAG_EVD_Pos = 0x1
	// Bit mask of EVD field.
	EVSYS_CHANNEL_CHINTFLAG_EVD_Msk = 0x2
	// Bit EVD.
	EVSYS_CHANNEL_CHINTFLAG_EVD = 0x2

	// CHANNEL.CHSTATUS: Channel n Status
	// Position of RDYUSR field.
	EVSYS_CHANNEL_CHSTATUS_RDYUSR_Pos = 0x0
	// Bit mask of RDYUSR field.
	EVSYS_CHANNEL_CHSTATUS_RDYUSR_Msk = 0x1
	// Bit RDYUSR.
	EVSYS_CHANNEL_CHSTATUS_RDYUSR = 0x1
	// Position of BUSYCH field.
	EVSYS_CHANNEL_CHSTATUS_BUSYCH_Pos = 0x1
	// Bit mask of BUSYCH field.
	EVSYS_CHANNEL_CHSTATUS_BUSYCH_Msk = 0x2
	// Bit BUSYCH.
	EVSYS_CHANNEL_CHSTATUS_BUSYCH = 0x2

	// USER: User Multiplexer n
	// Position of CHANNEL field.
	EVSYS_USER_CHANNEL_Pos = 0x0
	// Bit mask of CHANNEL field.
	EVSYS_USER_CHANNEL_Msk = 0xf

	// INTENCLR: Interrupt Enable Clear
	// Position of NSCHK field.
	EVSYS_INTENCLR_NSCHK_Pos = 0x0
	// Bit mask of NSCHK field.
	EVSYS_INTENCLR_NSCHK_Msk = 0x1
	// Bit NSCHK.
	EVSYS_INTENCLR_NSCHK = 0x1

	// INTENSET: Interrupt Enable Set
	// Position of NSCHK field.
	EVSYS_INTENSET_NSCHK_Pos = 0x0
	// Bit mask of NSCHK field.
	EVSYS_INTENSET_NSCHK_Msk = 0x1
	// Bit NSCHK.
	EVSYS_INTENSET_NSCHK = 0x1

	// INTFLAG: Interrupt Flag Status and Clear
	// Position of NSCHK field.
	EVSYS_INTFLAG_NSCHK_Pos = 0x0
	// Bit mask of NSCHK field.
	EVSYS_INTFLAG_NSCHK_Msk = 0x1
	// Bit NSCHK.
	EVSYS_INTFLAG_NSCHK = 0x1

	// NONSECCHAN: Channels Security Attribution
	// Position of CHANNEL0 field.
	EVSYS_NONSECCHAN_CHANNEL0_Pos = 0x0
	// Bit mask of CHANNEL0 field.
	EVSYS_NONSECCHAN_CHANNEL0_Msk = 0x1
	// Bit CHANNEL0.
	EVSYS_NONSECCHAN_CHANNEL0 = 0x1
	// Position of CHANNEL1 field.
	EVSYS_NONSECCHAN_CHANNEL1_Pos = 0x1
	// Bit mask of CHANNEL1 field.
	EVSYS_NONSECCHAN_CHANNEL1_Msk = 0x2
	// Bit CHANNEL1.
	EVSYS_NONSECCHAN_CHANNEL1 = 0x2
	// Position of CHANNEL2 field.
	EVSYS_NONSECCHAN_CHANNEL2_Pos = 0x2
	// Bit mask of CHANNEL2 field.
	EVSYS_NONSECCHAN_CHANNEL2_Msk = 0x4
	// Bit CHANNEL2.
	EVSYS_NONSECCHAN_CHANNEL2 = 0x4
	// Position of CHANNEL3 field.
	EVSYS_NONSECCHAN_CHANNEL3_Pos = 0x3
	// Bit mask of CHANNEL3 field.
	EVSYS_NONSECCHAN_CHANNEL3_Msk = 0x8
	// Bit CHANNEL3.
	EVSYS_NONSECCHAN_CHANNEL3 = 0x8
	// Position of CHANNEL4 field.
	EVSYS_NONSECCHAN_CHANNEL4_Pos = 0x4
	// Bit mask of CHANNEL4 field.
	EVSYS_NONSECCHAN_CHANNEL4_Msk = 0x10
	// Bit CHANNEL4.
	EVSYS_NONSECCHAN_CHANNEL4 = 0x10
	// Position of CHANNEL5 field.
	EVSYS_NONSECCHAN_CHANNEL5_Pos = 0x5
	// Bit mask of CHANNEL5 field.
	EVSYS_NONSECCHAN_CHANNEL5_Msk = 0x20
	// Bit CHANNEL5.
	EVSYS_NONSECCHAN_CHANNEL5 = 0x20
	// Position of CHANNEL6 field.
	EVSYS_NONSECCHAN_CHANNEL6_Pos = 0x6
	// Bit mask of CHANNEL6 field.
	EVSYS_NONSECCHAN_CHANNEL6_Msk = 0x40
	// Bit CHANNEL6.
	EVSYS_NONSECCHAN_CHANNEL6 = 0x40
	// Position of CHANNEL7 field.
	EVSYS_NONSECCHAN_CHANNEL7_Pos = 0x7
	// Bit mask of CHANNEL7 field.
	EVSYS_NONSECCHAN_CHANNEL7_Msk = 0x80
	// Bit CHANNEL7.
	EVSYS_NONSECCHAN_CHANNEL7 = 0x80

	// NSCHKCHAN: Non-Secure Channels Check
	// Position of CHANNEL0 field.
	EVSYS_NSCHKCHAN_CHANNEL0_Pos = 0x0
	// Bit mask of CHANNEL0 field.
	EVSYS_NSCHKCHAN_CHANNEL0_Msk = 0x1
	// Bit CHANNEL0.
	EVSYS_NSCHKCHAN_CHANNEL0 = 0x1
	// Position of CHANNEL1 field.
	EVSYS_NSCHKCHAN_CHANNEL1_Pos = 0x1
	// Bit mask of CHANNEL1 field.
	EVSYS_NSCHKCHAN_CHANNEL1_Msk = 0x2
	// Bit CHANNEL1.
	EVSYS_NSCHKCHAN_CHANNEL1 = 0x2
	// Position of CHANNEL2 field.
	EVSYS_NSCHKCHAN_CHANNEL2_Pos = 0x2
	// Bit mask of CHANNEL2 field.
	EVSYS_NSCHKCHAN_CHANNEL2_Msk = 0x4
	// Bit CHANNEL2.
	EVSYS_NSCHKCHAN_CHANNEL2 = 0x4
	// Position of CHANNEL3 field.
	EVSYS_NSCHKCHAN_CHANNEL3_Pos = 0x3
	// Bit mask of CHANNEL3 field.
	EVSYS_NSCHKCHAN_CHANNEL3_Msk = 0x8
	// Bit CHANNEL3.
	EVSYS_NSCHKCHAN_CHANNEL3 = 0x8
	// Position of CHANNEL4 field.
	EVSYS_NSCHKCHAN_CHANNEL4_Pos = 0x4
	// Bit mask of CHANNEL4 field.
	EVSYS_NSCHKCHAN_CHANNEL4_Msk = 0x10
	// Bit CHANNEL4.
	EVSYS_NSCHKCHAN_CHANNEL4 = 0x10
	// Position of CHANNEL5 field.
	EVSYS_NSCHKCHAN_CHANNEL5_Pos = 0x5
	// Bit mask of CHANNEL5 field.
	EVSYS_NSCHKCHAN_CHANNEL5_Msk = 0x20
	// Bit CHANNEL5.
	EVSYS_NSCHKCHAN_CHANNEL5 = 0x20
	// Position of CHANNEL6 field.
	EVSYS_NSCHKCHAN_CHANNEL6_Pos = 0x6
	// Bit mask of CHANNEL6 field.
	EVSYS_NSCHKCHAN_CHANNEL6_Msk = 0x40
	// Bit CHANNEL6.
	EVSYS_NSCHKCHAN_CHANNEL6 = 0x40
	// Position of CHANNEL7 field.
	EVSYS_NSCHKCHAN_CHANNEL7_Pos = 0x7
	// Bit mask of CHANNEL7 field.
	EVSYS_NSCHKCHAN_CHANNEL7_Msk = 0x80
	// Bit CHANNEL7.
	EVSYS_NSCHKCHAN_CHANNEL7 = 0x80

	// NONSECUSER: Users Security Attribution
	// Position of USER0 field.
	EVSYS_NONSECUSER_USER0_Pos = 0x0
	// Bit mask of USER0 field.
	EVSYS_NONSECUSER_USER0_Msk = 0x1
	// Bit USER0.
	EVSYS_NONSECUSER_USER0 = 0x1
	// Position of USER1 field.
	EVSYS_NONSECUSER_USER1_Pos = 0x1
	// Bit mask of USER1 field.
	EVSYS_NONSECUSER_USER1_Msk = 0x2
	// Bit USER1.
	EVSYS_NONSECUSER_USER1 = 0x2
	// Position of USER2 field.
	EVSYS_NONSECUSER_USER2_Pos = 0x2
	// Bit mask of USER2 field.
	EVSYS_NONSECUSER_USER2_Msk = 0x4
	// Bit USER2.
	EVSYS_NONSECUSER_USER2 = 0x4
	// Position of USER3 field.
	EVSYS_NONSECUSER_USER3_Pos = 0x3
	// Bit mask of USER3 field.
	EVSYS_NONSECUSER_USER3_Msk = 0x8
	// Bit USER3.
	EVSYS_NONSECUSER_USER3 = 0x8
	// Position of USER4 field.
	EVSYS_NONSECUSER_USER4_Pos = 0x4
	// Bit mask of USER4 field.
	EVSYS_NONSECUSER_USER4_Msk = 0x10
	// Bit USER4.
	EVSYS_NONSECUSER_USER4 = 0x10
	// Position of USER5 field.
	EVSYS_NONSECUSER_USER5_Pos = 0x5
	// Bit mask of USER5 field.
	EVSYS_NONSECUSER_USER5_Msk = 0x20
	// Bit USER5.
	EVSYS_NONSECUSER_USER5 = 0x20
	// Position of USER6 field.
	EVSYS_NONSECUSER_USER6_Pos = 0x6
	// Bit mask of USER6 field.
	EVSYS_NONSECUSER_USER6_Msk = 0x40
	// Bit USER6.
	EVSYS_NONSECUSER_USER6 = 0x40
	// Position of USER7 field.
	EVSYS_NONSECUSER_USER7_Pos = 0x7
	// Bit mask of USER7 field.
	EVSYS_NONSECUSER_USER7_Msk = 0x80
	// Bit USER7.
	EVSYS_NONSECUSER_USER7 = 0x80
	// Position of USER8 field.
	EVSYS_NONSECUSER_USER8_Pos = 0x8
	// Bit mask of USER8 field.
	EVSYS_NONSECUSER_USER8_Msk = 0x100
	// Bit USER8.
	EVSYS_NONSECUSER_USER8 = 0x100
	// Position of USER9 field.
	EVSYS_NONSECUSER_USER9_Pos = 0x9
	// Bit mask of USER9 field.
	EVSYS_NONSECUSER_USER9_Msk = 0x200
	// Bit USER9.
	EVSYS_NONSECUSER_USER9 = 0x200
	// Position of USER10 field.
	EVSYS_NONSECUSER_USER10_Pos = 0xa
	// Bit mask of USER10 field.
	EVSYS_NONSECUSER_USER10_Msk = 0x400
	// Bit USER10.
	EVSYS_NONSECUSER_USER10 = 0x400
	// Position of USER11 field.
	EVSYS_NONSECUSER_USER11_Pos = 0xb
	// Bit mask of USER11 field.
	EVSYS_NONSECUSER_USER11_Msk = 0x800
	// Bit USER11.
	EVSYS_NONSECUSER_USER11 = 0x800
	// Position of USER12 field.
	EVSYS_NONSECUSER_USER12_Pos = 0xc
	// Bit mask of USER12 field.
	EVSYS_NONSECUSER_USER12_Msk = 0x1000
	// Bit USER12.
	EVSYS_NONSECUSER_USER12 = 0x1000
	// Position of USER13 field.
	EVSYS_NONSECUSER_USER13_Pos = 0xd
	// Bit mask of USER13 field.
	EVSYS_NONSECUSER_USER13_Msk = 0x2000
	// Bit USER13.
	EVSYS_NONSECUSER_USER13 = 0x2000
	// Position of USER14 field.
	EVSYS_NONSECUSER_USER14_Pos = 0xe
	// Bit mask of USER14 field.
	EVSYS_NONSECUSER_USER14_Msk = 0x4000
	// Bit USER14.
	EVSYS_NONSECUSER_USER14 = 0x4000
	// Position of USER15 field.
	EVSYS_NONSECUSER_USER15_Pos = 0xf
	// Bit mask of USER15 field.
	EVSYS_NONSECUSER_USER15_Msk = 0x8000
	// Bit USER15.
	EVSYS_NONSECUSER_USER15 = 0x8000
	// Position of USER16 field.
	EVSYS_NONSECUSER_USER16_Pos = 0x10
	// Bit mask of USER16 field.
	EVSYS_NONSECUSER_USER16_Msk = 0x10000
	// Bit USER16.
	EVSYS_NONSECUSER_USER16 = 0x10000
	// Position of USER17 field.
	EVSYS_NONSECUSER_USER17_Pos = 0x11
	// Bit mask of USER17 field.
	EVSYS_NONSECUSER_USER17_Msk = 0x20000
	// Bit USER17.
	EVSYS_NONSECUSER_USER17 = 0x20000
	// Position of USER18 field.
	EVSYS_NONSECUSER_USER18_Pos = 0x12
	// Bit mask of USER18 field.
	EVSYS_NONSECUSER_USER18_Msk = 0x40000
	// Bit USER18.
	EVSYS_NONSECUSER_USER18 = 0x40000
	// Position of USER19 field.
	EVSYS_NONSECUSER_USER19_Pos = 0x13
	// Bit mask of USER19 field.
	EVSYS_NONSECUSER_USER19_Msk = 0x80000
	// Bit USER19.
	EVSYS_NONSECUSER_USER19 = 0x80000
	// Position of USER20 field.
	EVSYS_NONSECUSER_USER20_Pos = 0x14
	// Bit mask of USER20 field.
	EVSYS_NONSECUSER_USER20_Msk = 0x100000
	// Bit USER20.
	EVSYS_NONSECUSER_USER20 = 0x100000
	// Position of USER21 field.
	EVSYS_NONSECUSER_USER21_Pos = 0x15
	// Bit mask of USER21 field.
	EVSYS_NONSECUSER_USER21_Msk = 0x200000
	// Bit USER21.
	EVSYS_NONSECUSER_USER21 = 0x200000
	// Position of USER22 field.
	EVSYS_NONSECUSER_USER22_Pos = 0x16
	// Bit mask of USER22 field.
	EVSYS_NONSECUSER_USER22_Msk = 0x400000
	// Bit USER22.
	EVSYS_NONSECUSER_USER22 = 0x400000

	// NSCHKUSER: Non-Secure Users Check
	// Position of USER0 field.
	EVSYS_NSCHKUSER_USER0_Pos = 0x0
	// Bit mask of USER0 field.
	EVSYS_NSCHKUSER_USER0_Msk = 0x1
	// Bit USER0.
	EVSYS_NSCHKUSER_USER0 = 0x1
	// Position of USER1 field.
	EVSYS_NSCHKUSER_USER1_Pos = 0x1
	// Bit mask of USER1 field.
	EVSYS_NSCHKUSER_USER1_Msk = 0x2
	// Bit USER1.
	EVSYS_NSCHKUSER_USER1 = 0x2
	// Position of USER2 field.
	EVSYS_NSCHKUSER_USER2_Pos = 0x2
	// Bit mask of USER2 field.
	EVSYS_NSCHKUSER_USER2_Msk = 0x4
	// Bit USER2.
	EVSYS_NSCHKUSER_USER2 = 0x4
	// Position of USER3 field.
	EVSYS_NSCHKUSER_USER3_Pos = 0x3
	// Bit mask of USER3 field.
	EVSYS_NSCHKUSER_USER3_Msk = 0x8
	// Bit USER3.
	EVSYS_NSCHKUSER_USER3 = 0x8
	// Position of USER4 field.
	EVSYS_NSCHKUSER_USER4_Pos = 0x4
	// Bit mask of USER4 field.
	EVSYS_NSCHKUSER_USER4_Msk = 0x10
	// Bit USER4.
	EVSYS_NSCHKUSER_USER4 = 0x10
	// Position of USER5 field.
	EVSYS_NSCHKUSER_USER5_Pos = 0x5
	// Bit mask of USER5 field.
	EVSYS_NSCHKUSER_USER5_Msk = 0x20
	// Bit USER5.
	EVSYS_NSCHKUSER_USER5 = 0x20
	// Position of USER6 field.
	EVSYS_NSCHKUSER_USER6_Pos = 0x6
	// Bit mask of USER6 field.
	EVSYS_NSCHKUSER_USER6_Msk = 0x40
	// Bit USER6.
	EVSYS_NSCHKUSER_USER6 = 0x40
	// Position of USER7 field.
	EVSYS_NSCHKUSER_USER7_Pos = 0x7
	// Bit mask of USER7 field.
	EVSYS_NSCHKUSER_USER7_Msk = 0x80
	// Bit USER7.
	EVSYS_NSCHKUSER_USER7 = 0x80
	// Position of USER8 field.
	EVSYS_NSCHKUSER_USER8_Pos = 0x8
	// Bit mask of USER8 field.
	EVSYS_NSCHKUSER_USER8_Msk = 0x100
	// Bit USER8.
	EVSYS_NSCHKUSER_USER8 = 0x100
	// Position of USER9 field.
	EVSYS_NSCHKUSER_USER9_Pos = 0x9
	// Bit mask of USER9 field.
	EVSYS_NSCHKUSER_USER9_Msk = 0x200
	// Bit USER9.
	EVSYS_NSCHKUSER_USER9 = 0x200
	// Position of USER10 field.
	EVSYS_NSCHKUSER_USER10_Pos = 0xa
	// Bit mask of USER10 field.
	EVSYS_NSCHKUSER_USER10_Msk = 0x400
	// Bit USER10.
	EVSYS_NSCHKUSER_USER10 = 0x400
	// Position of USER11 field.
	EVSYS_NSCHKUSER_USER11_Pos = 0xb
	// Bit mask of USER11 field.
	EVSYS_NSCHKUSER_USER11_Msk = 0x800
	// Bit USER11.
	EVSYS_NSCHKUSER_USER11 = 0x800
	// Position of USER12 field.
	EVSYS_NSCHKUSER_USER12_Pos = 0xc
	// Bit mask of USER12 field.
	EVSYS_NSCHKUSER_USER12_Msk = 0x1000
	// Bit USER12.
	EVSYS_NSCHKUSER_USER12 = 0x1000
	// Position of USER13 field.
	EVSYS_NSCHKUSER_USER13_Pos = 0xd
	// Bit mask of USER13 field.
	EVSYS_NSCHKUSER_USER13_Msk = 0x2000
	// Bit USER13.
	EVSYS_NSCHKUSER_USER13 = 0x2000
	// Position of USER14 field.
	EVSYS_NSCHKUSER_USER14_Pos = 0xe
	// Bit mask of USER14 field.
	EVSYS_NSCHKUSER_USER14_Msk = 0x4000
	// Bit USER14.
	EVSYS_NSCHKUSER_USER14 = 0x4000
	// Position of USER15 field.
	EVSYS_NSCHKUSER_USER15_Pos = 0xf
	// Bit mask of USER15 field.
	EVSYS_NSCHKUSER_USER15_Msk = 0x8000
	// Bit USER15.
	EVSYS_NSCHKUSER_USER15 = 0x8000
	// Position of USER16 field.
	EVSYS_NSCHKUSER_USER16_Pos = 0x10
	// Bit mask of USER16 field.
	EVSYS_NSCHKUSER_USER16_Msk = 0x10000
	// Bit USER16.
	EVSYS_NSCHKUSER_USER16 = 0x10000
	// Position of USER17 field.
	EVSYS_NSCHKUSER_USER17_Pos = 0x11
	// Bit mask of USER17 field.
	EVSYS_NSCHKUSER_USER17_Msk = 0x20000
	// Bit USER17.
	EVSYS_NSCHKUSER_USER17 = 0x20000
	// Position of USER18 field.
	EVSYS_NSCHKUSER_USER18_Pos = 0x12
	// Bit mask of USER18 field.
	EVSYS_NSCHKUSER_USER18_Msk = 0x40000
	// Bit USER18.
	EVSYS_NSCHKUSER_USER18 = 0x40000
	// Position of USER19 field.
	EVSYS_NSCHKUSER_USER19_Pos = 0x13
	// Bit mask of USER19 field.
	EVSYS_NSCHKUSER_USER19_Msk = 0x80000
	// Bit USER19.
	EVSYS_NSCHKUSER_USER19 = 0x80000
	// Position of USER20 field.
	EVSYS_NSCHKUSER_USER20_Pos = 0x14
	// Bit mask of USER20 field.
	EVSYS_NSCHKUSER_USER20_Msk = 0x100000
	// Bit USER20.
	EVSYS_NSCHKUSER_USER20 = 0x100000
	// Position of USER21 field.
	EVSYS_NSCHKUSER_USER21_Pos = 0x15
	// Bit mask of USER21 field.
	EVSYS_NSCHKUSER_USER21_Msk = 0x200000
	// Bit USER21.
	EVSYS_NSCHKUSER_USER21 = 0x200000
	// Position of USER22 field.
	EVSYS_NSCHKUSER_USER22_Pos = 0x16
	// Bit mask of USER22 field.
	EVSYS_NSCHKUSER_USER22_Msk = 0x400000
	// Bit USER22.
	EVSYS_NSCHKUSER_USER22 = 0x400000
)

// Constants for FREQM: Frequency Meter
const (
	// CTRLA: Control A Register
	// Position of SWRST field.
	FREQM_CTRLA_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	FREQM_CTRLA_SWRST_Msk = 0x1
	// Bit SWRST.
	FREQM_CTRLA_SWRST = 0x1
	// Position of ENABLE field.
	FREQM_CTRLA_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	FREQM_CTRLA_ENABLE_Msk = 0x2
	// Bit ENABLE.
	FREQM_CTRLA_ENABLE = 0x2

	// CTRLB: Control B Register
	// Position of START field.
	FREQM_CTRLB_START_Pos = 0x0
	// Bit mask of START field.
	FREQM_CTRLB_START_Msk = 0x1
	// Bit START.
	FREQM_CTRLB_START = 0x1

	// CFGA: Config A register
	// Position of REFNUM field.
	FREQM_CFGA_REFNUM_Pos = 0x0
	// Bit mask of REFNUM field.
	FREQM_CFGA_REFNUM_Msk = 0xff
	// Position of DIVREF field.
	FREQM_CFGA_DIVREF_Pos = 0xf
	// Bit mask of DIVREF field.
	FREQM_CFGA_DIVREF_Msk = 0x8000
	// Bit DIVREF.
	FREQM_CFGA_DIVREF = 0x8000

	// INTENCLR: Interrupt Enable Clear Register
	// Position of DONE field.
	FREQM_INTENCLR_DONE_Pos = 0x0
	// Bit mask of DONE field.
	FREQM_INTENCLR_DONE_Msk = 0x1
	// Bit DONE.
	FREQM_INTENCLR_DONE = 0x1

	// INTENSET: Interrupt Enable Set Register
	// Position of DONE field.
	FREQM_INTENSET_DONE_Pos = 0x0
	// Bit mask of DONE field.
	FREQM_INTENSET_DONE_Msk = 0x1
	// Bit DONE.
	FREQM_INTENSET_DONE = 0x1

	// INTFLAG: Interrupt Flag Register
	// Position of DONE field.
	FREQM_INTFLAG_DONE_Pos = 0x0
	// Bit mask of DONE field.
	FREQM_INTFLAG_DONE_Msk = 0x1
	// Bit DONE.
	FREQM_INTFLAG_DONE = 0x1

	// STATUS: Status Register
	// Position of BUSY field.
	FREQM_STATUS_BUSY_Pos = 0x0
	// Bit mask of BUSY field.
	FREQM_STATUS_BUSY_Msk = 0x1
	// Bit BUSY.
	FREQM_STATUS_BUSY = 0x1
	// Position of OVF field.
	FREQM_STATUS_OVF_Pos = 0x1
	// Bit mask of OVF field.
	FREQM_STATUS_OVF_Msk = 0x2
	// Bit OVF.
	FREQM_STATUS_OVF = 0x2

	// SYNCBUSY: Synchronization Busy Register
	// Position of SWRST field.
	FREQM_SYNCBUSY_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	FREQM_SYNCBUSY_SWRST_Msk = 0x1
	// Bit SWRST.
	FREQM_SYNCBUSY_SWRST = 0x1
	// Position of ENABLE field.
	FREQM_SYNCBUSY_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	FREQM_SYNCBUSY_ENABLE_Msk = 0x2
	// Bit ENABLE.
	FREQM_SYNCBUSY_ENABLE = 0x2

	// VALUE: Count Value Register
	// Position of VALUE field.
	FREQM_VALUE_VALUE_Pos = 0x0
	// Bit mask of VALUE field.
	FREQM_VALUE_VALUE_Msk = 0xffffff
)

// Constants for GCLK: Generic Clock Generator
const (
	// CTRLA: Control
	// Position of SWRST field.
	GCLK_CTRLA_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	GCLK_CTRLA_SWRST_Msk = 0x1
	// Bit SWRST.
	GCLK_CTRLA_SWRST = 0x1

	// SYNCBUSY: Synchronization Busy
	// Position of SWRST field.
	GCLK_SYNCBUSY_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	GCLK_SYNCBUSY_SWRST_Msk = 0x1
	// Bit SWRST.
	GCLK_SYNCBUSY_SWRST = 0x1
	// Position of GENCTRL0 field.
	GCLK_SYNCBUSY_GENCTRL0_Pos = 0x2
	// Bit mask of GENCTRL0 field.
	GCLK_SYNCBUSY_GENCTRL0_Msk = 0x4
	// Bit GENCTRL0.
	GCLK_SYNCBUSY_GENCTRL0 = 0x4
	// Position of GENCTRL1 field.
	GCLK_SYNCBUSY_GENCTRL1_Pos = 0x3
	// Bit mask of GENCTRL1 field.
	GCLK_SYNCBUSY_GENCTRL1_Msk = 0x8
	// Bit GENCTRL1.
	GCLK_SYNCBUSY_GENCTRL1 = 0x8
	// Position of GENCTRL2 field.
	GCLK_SYNCBUSY_GENCTRL2_Pos = 0x4
	// Bit mask of GENCTRL2 field.
	GCLK_SYNCBUSY_GENCTRL2_Msk = 0x10
	// Bit GENCTRL2.
	GCLK_SYNCBUSY_GENCTRL2 = 0x10
	// Position of GENCTRL3 field.
	GCLK_SYNCBUSY_GENCTRL3_Pos = 0x5
	// Bit mask of GENCTRL3 field.
	GCLK_SYNCBUSY_GENCTRL3_Msk = 0x20
	// Bit GENCTRL3.
	GCLK_SYNCBUSY_GENCTRL3 = 0x20
	// Position of GENCTRL4 field.
	GCLK_SYNCBUSY_GENCTRL4_Pos = 0x6
	// Bit mask of GENCTRL4 field.
	GCLK_SYNCBUSY_GENCTRL4_Msk = 0x40
	// Bit GENCTRL4.
	GCLK_SYNCBUSY_GENCTRL4 = 0x40

	// GENCTRL: Generic Clock Generator Control
	// Position of SRC field.
	GCLK_GENCTRL_SRC_Pos = 0x0
	// Bit mask of SRC field.
	GCLK_GENCTRL_SRC_Msk = 0x7
	// XOSC oscillator output
	GCLK_GENCTRL_SRC_XOSC = 0x0
	// Generator input pad
	GCLK_GENCTRL_SRC_GCLKIN = 0x1
	// Generic clock generator 1 output
	GCLK_GENCTRL_SRC_GCLKGEN1 = 0x2
	// OSCULP32K oscillator output
	GCLK_GENCTRL_SRC_OSCULP32K = 0x3
	// XOSC32K oscillator output
	GCLK_GENCTRL_SRC_XOSC32K = 0x4
	// OSC16M oscillator output
	GCLK_GENCTRL_SRC_OSC16M = 0x5
	// DFLLULP output
	GCLK_GENCTRL_SRC_DFLLULP = 0x6
	// FDPLL output
	GCLK_GENCTRL_SRC_FDPLL96M = 0x7
	// Position of GENEN field.
	GCLK_GENCTRL_GENEN_Pos = 0x8
	// Bit mask of GENEN field.
	GCLK_GENCTRL_GENEN_Msk = 0x100
	// Bit GENEN.
	GCLK_GENCTRL_GENEN = 0x100
	// Position of IDC field.
	GCLK_GENCTRL_IDC_Pos = 0x9
	// Bit mask of IDC field.
	GCLK_GENCTRL_IDC_Msk = 0x200
	// Bit IDC.
	GCLK_GENCTRL_IDC = 0x200
	// Position of OOV field.
	GCLK_GENCTRL_OOV_Pos = 0xa
	// Bit mask of OOV field.
	GCLK_GENCTRL_OOV_Msk = 0x400
	// Bit OOV.
	GCLK_GENCTRL_OOV = 0x400
	// Position of OE field.
	GCLK_GENCTRL_OE_Pos = 0xb
	// Bit mask of OE field.
	GCLK_GENCTRL_OE_Msk = 0x800
	// Bit OE.
	GCLK_GENCTRL_OE = 0x800
	// Position of DIVSEL field.
	GCLK_GENCTRL_DIVSEL_Pos = 0xc
	// Bit mask of DIVSEL field.
	GCLK_GENCTRL_DIVSEL_Msk = 0x1000
	// Bit DIVSEL.
	GCLK_GENCTRL_DIVSEL = 0x1000
	// Position of RUNSTDBY field.
	GCLK_GENCTRL_RUNSTDBY_Pos = 0xd
	// Bit mask of RUNSTDBY field.
	GCLK_GENCTRL_RUNSTDBY_Msk = 0x2000
	// Bit RUNSTDBY.
	GCLK_GENCTRL_RUNSTDBY = 0x2000
	// Position of DIV field.
	GCLK_GENCTRL_DIV_Pos = 0x10
	// Bit mask of DIV field.
	GCLK_GENCTRL_DIV_Msk = 0xffff0000

	// PCHCTRL: Peripheral Clock Control
	// Position of GEN field.
	GCLK_PCHCTRL_GEN_Pos = 0x0
	// Bit mask of GEN field.
	GCLK_PCHCTRL_GEN_Msk = 0x7
	// Generic clock generator 0
	GCLK_PCHCTRL_GEN_GCLK0 = 0x0
	// Generic clock generator 1
	GCLK_PCHCTRL_GEN_GCLK1 = 0x1
	// Generic clock generator 2
	GCLK_PCHCTRL_GEN_GCLK2 = 0x2
	// Generic clock generator 3
	GCLK_PCHCTRL_GEN_GCLK3 = 0x3
	// Generic clock generator 4
	GCLK_PCHCTRL_GEN_GCLK4 = 0x4
	// Position of CHEN field.
	GCLK_PCHCTRL_CHEN_Pos = 0x6
	// Bit mask of CHEN field.
	GCLK_PCHCTRL_CHEN_Msk = 0x40
	// Bit CHEN.
	GCLK_PCHCTRL_CHEN = 0x40
	// Position of WRTLOCK field.
	GCLK_PCHCTRL_WRTLOCK_Pos = 0x7
	// Bit mask of WRTLOCK field.
	GCLK_PCHCTRL_WRTLOCK_Msk = 0x80
	// Bit WRTLOCK.
	GCLK_PCHCTRL_WRTLOCK = 0x80
)

// Constants for IDAU: Implementation Defined Attribution Unit
const (
	// SECCTRL: SECCTRL
	// Position of RXN field.
	IDAU_SECCTRL_RXN_Pos = 0x2
	// Bit mask of RXN field.
	IDAU_SECCTRL_RXN_Msk = 0x4
	// Bit RXN.
	IDAU_SECCTRL_RXN = 0x4

	// SCFGB: SCFGB
	// Position of BS field.
	IDAU_SCFGB_BS_Pos = 0x0
	// Bit mask of BS field.
	IDAU_SCFGB_BS_Msk = 0xff
	// Position of BNSC field.
	IDAU_SCFGB_BNSC_Pos = 0x8
	// Bit mask of BNSC field.
	IDAU_SCFGB_BNSC_Msk = 0x3f00
	// Position of BOOTPROT field.
	IDAU_SCFGB_BOOTPROT_Pos = 0x10
	// Bit mask of BOOTPROT field.
	IDAU_SCFGB_BOOTPROT_Msk = 0xff0000

	// SCFGA: SCFGA
	// Position of AS field.
	IDAU_SCFGA_AS_Pos = 0x0
	// Bit mask of AS field.
	IDAU_SCFGA_AS_Msk = 0xff
	// Position of ANSC field.
	IDAU_SCFGA_ANSC_Pos = 0x8
	// Bit mask of ANSC field.
	IDAU_SCFGA_ANSC_Msk = 0x3f00
	// Position of DS field.
	IDAU_SCFGA_DS_Pos = 0x10
	// Bit mask of DS field.
	IDAU_SCFGA_DS_Msk = 0xf0000

	// SCFGR: SCFGR
	// Position of RS field.
	IDAU_SCFGR_RS_Pos = 0x0
	// Bit mask of RS field.
	IDAU_SCFGR_RS_Msk = 0x7f
)

// Constants for MCLK: Main Clock
const (
	// CTRLA: Control
	// Position of CKSEL field.
	MCLK_CTRLA_CKSEL_Pos = 0x2
	// Bit mask of CKSEL field.
	MCLK_CTRLA_CKSEL_Msk = 0x4
	// Bit CKSEL.
	MCLK_CTRLA_CKSEL = 0x4

	// INTENCLR: Interrupt Enable Clear
	// Position of CKRDY field.
	MCLK_INTENCLR_CKRDY_Pos = 0x0
	// Bit mask of CKRDY field.
	MCLK_INTENCLR_CKRDY_Msk = 0x1
	// Bit CKRDY.
	MCLK_INTENCLR_CKRDY = 0x1

	// INTENSET: Interrupt Enable Set
	// Position of CKRDY field.
	MCLK_INTENSET_CKRDY_Pos = 0x0
	// Bit mask of CKRDY field.
	MCLK_INTENSET_CKRDY_Msk = 0x1
	// Bit CKRDY.
	MCLK_INTENSET_CKRDY = 0x1

	// INTFLAG: Interrupt Flag Status and Clear
	// Position of CKRDY field.
	MCLK_INTFLAG_CKRDY_Pos = 0x0
	// Bit mask of CKRDY field.
	MCLK_INTFLAG_CKRDY_Msk = 0x1
	// Bit CKRDY.
	MCLK_INTFLAG_CKRDY = 0x1

	// CPUDIV: CPU Clock Division
	// Position of CPUDIV field.
	MCLK_CPUDIV_CPUDIV_Pos = 0x0
	// Bit mask of CPUDIV field.
	MCLK_CPUDIV_CPUDIV_Msk = 0xff
	// Divide by 1
	MCLK_CPUDIV_CPUDIV_DIV1 = 0x1
	// Divide by 2
	MCLK_CPUDIV_CPUDIV_DIV2 = 0x2
	// Divide by 4
	MCLK_CPUDIV_CPUDIV_DIV4 = 0x4
	// Divide by 8
	MCLK_CPUDIV_CPUDIV_DIV8 = 0x8
	// Divide by 16
	MCLK_CPUDIV_CPUDIV_DIV16 = 0x10
	// Divide by 32
	MCLK_CPUDIV_CPUDIV_DIV32 = 0x20
	// Divide by 64
	MCLK_CPUDIV_CPUDIV_DIV64 = 0x40
	// Divide by 128
	MCLK_CPUDIV_CPUDIV_DIV128 = 0x80

	// AHBMASK: AHB Mask
	// Position of HPB0_ field.
	MCLK_AHBMASK_HPB0__Pos = 0x0
	// Bit mask of HPB0_ field.
	MCLK_AHBMASK_HPB0__Msk = 0x1
	// Bit HPB0_.
	MCLK_AHBMASK_HPB0_ = 0x1
	// Position of HPB1_ field.
	MCLK_AHBMASK_HPB1__Pos = 0x1
	// Bit mask of HPB1_ field.
	MCLK_AHBMASK_HPB1__Msk = 0x2
	// Bit HPB1_.
	MCLK_AHBMASK_HPB1_ = 0x2
	// Position of HPB2_ field.
	MCLK_AHBMASK_HPB2__Pos = 0x2
	// Bit mask of HPB2_ field.
	MCLK_AHBMASK_HPB2__Msk = 0x4
	// Bit HPB2_.
	MCLK_AHBMASK_HPB2_ = 0x4
	// Position of DMAC_ field.
	MCLK_AHBMASK_DMAC__Pos = 0x3
	// Bit mask of DMAC_ field.
	MCLK_AHBMASK_DMAC__Msk = 0x8
	// Bit DMAC_.
	MCLK_AHBMASK_DMAC_ = 0x8
	// Position of DSU_ field.
	MCLK_AHBMASK_DSU__Pos = 0x4
	// Bit mask of DSU_ field.
	MCLK_AHBMASK_DSU__Msk = 0x10
	// Bit DSU_.
	MCLK_AHBMASK_DSU_ = 0x10
	// Position of PAC_ field.
	MCLK_AHBMASK_PAC__Pos = 0x6
	// Bit mask of PAC_ field.
	MCLK_AHBMASK_PAC__Msk = 0x40
	// Bit PAC_.
	MCLK_AHBMASK_PAC_ = 0x40
	// Position of NVMCTRL_ field.
	MCLK_AHBMASK_NVMCTRL__Pos = 0x7
	// Bit mask of NVMCTRL_ field.
	MCLK_AHBMASK_NVMCTRL__Msk = 0x80
	// Bit NVMCTRL_.
	MCLK_AHBMASK_NVMCTRL_ = 0x80
	// Position of TRAM_ field.
	MCLK_AHBMASK_TRAM__Pos = 0xc
	// Bit mask of TRAM_ field.
	MCLK_AHBMASK_TRAM__Msk = 0x1000
	// Bit TRAM_.
	MCLK_AHBMASK_TRAM_ = 0x1000

	// APBAMASK: APBA Mask
	// Position of PAC_ field.
	MCLK_APBAMASK_PAC__Pos = 0x0
	// Bit mask of PAC_ field.
	MCLK_APBAMASK_PAC__Msk = 0x1
	// Bit PAC_.
	MCLK_APBAMASK_PAC_ = 0x1
	// Position of PM_ field.
	MCLK_APBAMASK_PM__Pos = 0x1
	// Bit mask of PM_ field.
	MCLK_APBAMASK_PM__Msk = 0x2
	// Bit PM_.
	MCLK_APBAMASK_PM_ = 0x2
	// Position of MCLK_ field.
	MCLK_APBAMASK_MCLK__Pos = 0x2
	// Bit mask of MCLK_ field.
	MCLK_APBAMASK_MCLK__Msk = 0x4
	// Bit MCLK_.
	MCLK_APBAMASK_MCLK_ = 0x4
	// Position of RSTC_ field.
	MCLK_APBAMASK_RSTC__Pos = 0x3
	// Bit mask of RSTC_ field.
	MCLK_APBAMASK_RSTC__Msk = 0x8
	// Bit RSTC_.
	MCLK_APBAMASK_RSTC_ = 0x8
	// Position of OSCCTRL_ field.
	MCLK_APBAMASK_OSCCTRL__Pos = 0x4
	// Bit mask of OSCCTRL_ field.
	MCLK_APBAMASK_OSCCTRL__Msk = 0x10
	// Bit OSCCTRL_.
	MCLK_APBAMASK_OSCCTRL_ = 0x10
	// Position of OSC32KCTRL_ field.
	MCLK_APBAMASK_OSC32KCTRL__Pos = 0x5
	// Bit mask of OSC32KCTRL_ field.
	MCLK_APBAMASK_OSC32KCTRL__Msk = 0x20
	// Bit OSC32KCTRL_.
	MCLK_APBAMASK_OSC32KCTRL_ = 0x20
	// Position of SUPC_ field.
	MCLK_APBAMASK_SUPC__Pos = 0x6
	// Bit mask of SUPC_ field.
	MCLK_APBAMASK_SUPC__Msk = 0x40
	// Bit SUPC_.
	MCLK_APBAMASK_SUPC_ = 0x40
	// Position of GCLK_ field.
	MCLK_APBAMASK_GCLK__Pos = 0x7
	// Bit mask of GCLK_ field.
	MCLK_APBAMASK_GCLK__Msk = 0x80
	// Bit GCLK_.
	MCLK_APBAMASK_GCLK_ = 0x80
	// Position of WDT_ field.
	MCLK_APBAMASK_WDT__Pos = 0x8
	// Bit mask of WDT_ field.
	MCLK_APBAMASK_WDT__Msk = 0x100
	// Bit WDT_.
	MCLK_APBAMASK_WDT_ = 0x100
	// Position of RTC_ field.
	MCLK_APBAMASK_RTC__Pos = 0x9
	// Bit mask of RTC_ field.
	MCLK_APBAMASK_RTC__Msk = 0x200
	// Bit RTC_.
	MCLK_APBAMASK_RTC_ = 0x200
	// Position of EIC_ field.
	MCLK_APBAMASK_EIC__Pos = 0xa
	// Bit mask of EIC_ field.
	MCLK_APBAMASK_EIC__Msk = 0x400
	// Bit EIC_.
	MCLK_APBAMASK_EIC_ = 0x400
	// Position of FREQM_ field.
	MCLK_APBAMASK_FREQM__Pos = 0xb
	// Bit mask of FREQM_ field.
	MCLK_APBAMASK_FREQM__Msk = 0x800
	// Bit FREQM_.
	MCLK_APBAMASK_FREQM_ = 0x800
	// Position of PORT_ field.
	MCLK_APBAMASK_PORT__Pos = 0xc
	// Bit mask of PORT_ field.
	MCLK_APBAMASK_PORT__Msk = 0x1000
	// Bit PORT_.
	MCLK_APBAMASK_PORT_ = 0x1000
	// Position of AC_ field.
	MCLK_APBAMASK_AC__Pos = 0xd
	// Bit mask of AC_ field.
	MCLK_APBAMASK_AC__Msk = 0x2000
	// Bit AC_.
	MCLK_APBAMASK_AC_ = 0x2000

	// APBBMASK: APBB Mask
	// Position of IDAU_ field.
	MCLK_APBBMASK_IDAU__Pos = 0x0
	// Bit mask of IDAU_ field.
	MCLK_APBBMASK_IDAU__Msk = 0x1
	// Bit IDAU_.
	MCLK_APBBMASK_IDAU_ = 0x1
	// Position of DSU_ field.
	MCLK_APBBMASK_DSU__Pos = 0x1
	// Bit mask of DSU_ field.
	MCLK_APBBMASK_DSU__Msk = 0x2
	// Bit DSU_.
	MCLK_APBBMASK_DSU_ = 0x2
	// Position of NVMCTRL_ field.
	MCLK_APBBMASK_NVMCTRL__Pos = 0x2
	// Bit mask of NVMCTRL_ field.
	MCLK_APBBMASK_NVMCTRL__Msk = 0x4
	// Bit NVMCTRL_.
	MCLK_APBBMASK_NVMCTRL_ = 0x4

	// APBCMASK: APBC Mask
	// Position of EVSYS_ field.
	MCLK_APBCMASK_EVSYS__Pos = 0x0
	// Bit mask of EVSYS_ field.
	MCLK_APBCMASK_EVSYS__Msk = 0x1
	// Bit EVSYS_.
	MCLK_APBCMASK_EVSYS_ = 0x1
	// Position of SERCOM0_ field.
	MCLK_APBCMASK_SERCOM0__Pos = 0x1
	// Bit mask of SERCOM0_ field.
	MCLK_APBCMASK_SERCOM0__Msk = 0x2
	// Bit SERCOM0_.
	MCLK_APBCMASK_SERCOM0_ = 0x2
	// Position of SERCOM1_ field.
	MCLK_APBCMASK_SERCOM1__Pos = 0x2
	// Bit mask of SERCOM1_ field.
	MCLK_APBCMASK_SERCOM1__Msk = 0x4
	// Bit SERCOM1_.
	MCLK_APBCMASK_SERCOM1_ = 0x4
	// Position of TC0_ field.
	MCLK_APBCMASK_TC0__Pos = 0x4
	// Bit mask of TC0_ field.
	MCLK_APBCMASK_TC0__Msk = 0x10
	// Bit TC0_.
	MCLK_APBCMASK_TC0_ = 0x10
	// Position of TC1_ field.
	MCLK_APBCMASK_TC1__Pos = 0x5
	// Bit mask of TC1_ field.
	MCLK_APBCMASK_TC1__Msk = 0x20
	// Bit TC1_.
	MCLK_APBCMASK_TC1_ = 0x20
	// Position of TC2_ field.
	MCLK_APBCMASK_TC2__Pos = 0x6
	// Bit mask of TC2_ field.
	MCLK_APBCMASK_TC2__Msk = 0x40
	// Bit TC2_.
	MCLK_APBCMASK_TC2_ = 0x40
	// Position of ADC_ field.
	MCLK_APBCMASK_ADC__Pos = 0x7
	// Bit mask of ADC_ field.
	MCLK_APBCMASK_ADC__Msk = 0x80
	// Bit ADC_.
	MCLK_APBCMASK_ADC_ = 0x80
	// Position of DAC_ field.
	MCLK_APBCMASK_DAC__Pos = 0x8
	// Bit mask of DAC_ field.
	MCLK_APBCMASK_DAC__Msk = 0x100
	// Bit DAC_.
	MCLK_APBCMASK_DAC_ = 0x100
	// Position of PTC_ field.
	MCLK_APBCMASK_PTC__Pos = 0x9
	// Bit mask of PTC_ field.
	MCLK_APBCMASK_PTC__Msk = 0x200
	// Bit PTC_.
	MCLK_APBCMASK_PTC_ = 0x200
	// Position of TRNG_ field.
	MCLK_APBCMASK_TRNG__Pos = 0xa
	// Bit mask of TRNG_ field.
	MCLK_APBCMASK_TRNG__Msk = 0x400
	// Bit TRNG_.
	MCLK_APBCMASK_TRNG_ = 0x400
	// Position of CCL_ field.
	MCLK_APBCMASK_CCL__Pos = 0xb
	// Bit mask of CCL_ field.
	MCLK_APBCMASK_CCL__Msk = 0x800
	// Bit CCL_.
	MCLK_APBCMASK_CCL_ = 0x800
	// Position of OPAMP_ field.
	MCLK_APBCMASK_OPAMP__Pos = 0xc
	// Bit mask of OPAMP_ field.
	MCLK_APBCMASK_OPAMP__Msk = 0x1000
	// Bit OPAMP_.
	MCLK_APBCMASK_OPAMP_ = 0x1000
)

// Constants for NVMCTRL: Non-Volatile Memory Controller
const (
	// CTRLA: Control A
	// Position of CMD field.
	NVMCTRL_CTRLA_CMD_Pos = 0x0
	// Bit mask of CMD field.
	NVMCTRL_CTRLA_CMD_Msk = 0x7f
	// Erase Row - Erases the row addressed by the ADDR register.
	NVMCTRL_CTRLA_CMD_ER = 0x2
	// Write Page - Writes the contents of the page buffer to the page addressed by the ADDR register.
	NVMCTRL_CTRLA_CMD_WP = 0x4
	// Sets the power reduction mode.
	NVMCTRL_CTRLA_CMD_SPRM = 0x42
	// Clears the power reduction mode.
	NVMCTRL_CTRLA_CMD_CPRM = 0x43
	// Page Buffer Clear - Clears the page buffer.
	NVMCTRL_CTRLA_CMD_PBC = 0x44
	// Invalidate all cache lines.
	NVMCTRL_CTRLA_CMD_INVALL = 0x46
	// Set DAL=0
	NVMCTRL_CTRLA_CMD_SDAL0 = 0x4b
	// Set DAL=1
	NVMCTRL_CTRLA_CMD_SDAL1 = 0x4c
	// Position of CMDEX field.
	NVMCTRL_CTRLA_CMDEX_Pos = 0x8
	// Bit mask of CMDEX field.
	NVMCTRL_CTRLA_CMDEX_Msk = 0xff00
	// Execution Key
	NVMCTRL_CTRLA_CMDEX_KEY = 0xa5

	// CTRLB: Control B
	// Position of RWS field.
	NVMCTRL_CTRLB_RWS_Pos = 0x1
	// Bit mask of RWS field.
	NVMCTRL_CTRLB_RWS_Msk = 0x1e
	// Position of SLEEPPRM field.
	NVMCTRL_CTRLB_SLEEPPRM_Pos = 0x8
	// Bit mask of SLEEPPRM field.
	NVMCTRL_CTRLB_SLEEPPRM_Msk = 0x300
	// NVM block enters low-power mode when entering sleep.NVM block exits low-power mode upon first access.
	NVMCTRL_CTRLB_SLEEPPRM_WAKEONACCESS = 0x0
	// NVM block enters low-power mode when entering sleep.NVM block exits low-power mode when exiting sleep.
	NVMCTRL_CTRLB_SLEEPPRM_WAKEUPINSTANT = 0x1
	// Auto power reduction disabled.
	NVMCTRL_CTRLB_SLEEPPRM_DISABLED = 0x3
	// Position of FWUP field.
	NVMCTRL_CTRLB_FWUP_Pos = 0xb
	// Bit mask of FWUP field.
	NVMCTRL_CTRLB_FWUP_Msk = 0x800
	// Bit FWUP.
	NVMCTRL_CTRLB_FWUP = 0x800
	// Position of READMODE field.
	NVMCTRL_CTRLB_READMODE_Pos = 0x10
	// Bit mask of READMODE field.
	NVMCTRL_CTRLB_READMODE_Msk = 0x30000
	// The NVM Controller (cache system) does not insert wait states on a cache miss. Gives the best system performance.
	NVMCTRL_CTRLB_READMODE_NO_MISS_PENALTY = 0x0
	// Reduces power consumption of the cache system, but inserts a wait state each time there is a cache miss. This mode may not be relevant if CPU performance is required, as the application will be stalled and may lead to increase run time.
	NVMCTRL_CTRLB_READMODE_LOW_POWER = 0x1
	// The cache system ensures that a cache hit or miss takes the same amount of time, determined by the number of programmed flash wait states. This mode can be used for real-time applications that require deterministic execution timings.
	NVMCTRL_CTRLB_READMODE_DETERMINISTIC = 0x2
	// Position of CACHEDIS field.
	NVMCTRL_CTRLB_CACHEDIS_Pos = 0x12
	// Bit mask of CACHEDIS field.
	NVMCTRL_CTRLB_CACHEDIS_Msk = 0x40000
	// Bit CACHEDIS.
	NVMCTRL_CTRLB_CACHEDIS = 0x40000
	// Position of QWEN field.
	NVMCTRL_CTRLB_QWEN_Pos = 0x13
	// Bit mask of QWEN field.
	NVMCTRL_CTRLB_QWEN_Msk = 0x80000
	// Bit QWEN.
	NVMCTRL_CTRLB_QWEN = 0x80000

	// CTRLC: Control C
	// Position of MANW field.
	NVMCTRL_CTRLC_MANW_Pos = 0x0
	// Bit mask of MANW field.
	NVMCTRL_CTRLC_MANW_Msk = 0x1
	// Bit MANW.
	NVMCTRL_CTRLC_MANW = 0x1

	// EVCTRL: Event Control
	// Position of AUTOWEI field.
	NVMCTRL_EVCTRL_AUTOWEI_Pos = 0x0
	// Bit mask of AUTOWEI field.
	NVMCTRL_EVCTRL_AUTOWEI_Msk = 0x1
	// Bit AUTOWEI.
	NVMCTRL_EVCTRL_AUTOWEI = 0x1
	// Position of AUTOWINV field.
	NVMCTRL_EVCTRL_AUTOWINV_Pos = 0x1
	// Bit mask of AUTOWINV field.
	NVMCTRL_EVCTRL_AUTOWINV_Msk = 0x2
	// Bit AUTOWINV.
	NVMCTRL_EVCTRL_AUTOWINV = 0x2

	// INTENCLR: Interrupt Enable Clear
	// Position of DONE field.
	NVMCTRL_INTENCLR_DONE_Pos = 0x0
	// Bit mask of DONE field.
	NVMCTRL_INTENCLR_DONE_Msk = 0x1
	// Bit DONE.
	NVMCTRL_INTENCLR_DONE = 0x1
	// Position of PROGE field.
	NVMCTRL_INTENCLR_PROGE_Pos = 0x1
	// Bit mask of PROGE field.
	NVMCTRL_INTENCLR_PROGE_Msk = 0x2
	// Bit PROGE.
	NVMCTRL_INTENCLR_PROGE = 0x2
	// Position of LOCKE field.
	NVMCTRL_INTENCLR_LOCKE_Pos = 0x2
	// Bit mask of LOCKE field.
	NVMCTRL_INTENCLR_LOCKE_Msk = 0x4
	// Bit LOCKE.
	NVMCTRL_INTENCLR_LOCKE = 0x4
	// Position of NVME field.
	NVMCTRL_INTENCLR_NVME_Pos = 0x3
	// Bit mask of NVME field.
	NVMCTRL_INTENCLR_NVME_Msk = 0x8
	// Bit NVME.
	NVMCTRL_INTENCLR_NVME = 0x8
	// Position of KEYE field.
	NVMCTRL_INTENCLR_KEYE_Pos = 0x4
	// Bit mask of KEYE field.
	NVMCTRL_INTENCLR_KEYE_Msk = 0x10
	// Bit KEYE.
	NVMCTRL_INTENCLR_KEYE = 0x10
	// Position of NSCHK field.
	NVMCTRL_INTENCLR_NSCHK_Pos = 0x5
	// Bit mask of NSCHK field.
	NVMCTRL_INTENCLR_NSCHK_Msk = 0x20
	// Bit NSCHK.
	NVMCTRL_INTENCLR_NSCHK = 0x20

	// INTENSET: Interrupt Enable Set
	// Position of DONE field.
	NVMCTRL_INTENSET_DONE_Pos = 0x0
	// Bit mask of DONE field.
	NVMCTRL_INTENSET_DONE_Msk = 0x1
	// Bit DONE.
	NVMCTRL_INTENSET_DONE = 0x1
	// Position of PROGE field.
	NVMCTRL_INTENSET_PROGE_Pos = 0x1
	// Bit mask of PROGE field.
	NVMCTRL_INTENSET_PROGE_Msk = 0x2
	// Bit PROGE.
	NVMCTRL_INTENSET_PROGE = 0x2
	// Position of LOCKE field.
	NVMCTRL_INTENSET_LOCKE_Pos = 0x2
	// Bit mask of LOCKE field.
	NVMCTRL_INTENSET_LOCKE_Msk = 0x4
	// Bit LOCKE.
	NVMCTRL_INTENSET_LOCKE = 0x4
	// Position of NVME field.
	NVMCTRL_INTENSET_NVME_Pos = 0x3
	// Bit mask of NVME field.
	NVMCTRL_INTENSET_NVME_Msk = 0x8
	// Bit NVME.
	NVMCTRL_INTENSET_NVME = 0x8
	// Position of KEYE field.
	NVMCTRL_INTENSET_KEYE_Pos = 0x4
	// Bit mask of KEYE field.
	NVMCTRL_INTENSET_KEYE_Msk = 0x10
	// Bit KEYE.
	NVMCTRL_INTENSET_KEYE = 0x10
	// Position of NSCHK field.
	NVMCTRL_INTENSET_NSCHK_Pos = 0x5
	// Bit mask of NSCHK field.
	NVMCTRL_INTENSET_NSCHK_Msk = 0x20
	// Bit NSCHK.
	NVMCTRL_INTENSET_NSCHK = 0x20

	// INTFLAG: Interrupt Flag Status and Clear
	// Position of DONE field.
	NVMCTRL_INTFLAG_DONE_Pos = 0x0
	// Bit mask of DONE field.
	NVMCTRL_INTFLAG_DONE_Msk = 0x1
	// Bit DONE.
	NVMCTRL_INTFLAG_DONE = 0x1
	// Position of PROGE field.
	NVMCTRL_INTFLAG_PROGE_Pos = 0x1
	// Bit mask of PROGE field.
	NVMCTRL_INTFLAG_PROGE_Msk = 0x2
	// Bit PROGE.
	NVMCTRL_INTFLAG_PROGE = 0x2
	// Position of LOCKE field.
	NVMCTRL_INTFLAG_LOCKE_Pos = 0x2
	// Bit mask of LOCKE field.
	NVMCTRL_INTFLAG_LOCKE_Msk = 0x4
	// Bit LOCKE.
	NVMCTRL_INTFLAG_LOCKE = 0x4
	// Position of NVME field.
	NVMCTRL_INTFLAG_NVME_Pos = 0x3
	// Bit mask of NVME field.
	NVMCTRL_INTFLAG_NVME_Msk = 0x8
	// Bit NVME.
	NVMCTRL_INTFLAG_NVME = 0x8
	// Position of KEYE field.
	NVMCTRL_INTFLAG_KEYE_Pos = 0x4
	// Bit mask of KEYE field.
	NVMCTRL_INTFLAG_KEYE_Msk = 0x10
	// Bit KEYE.
	NVMCTRL_INTFLAG_KEYE = 0x10
	// Position of NSCHK field.
	NVMCTRL_INTFLAG_NSCHK_Pos = 0x5
	// Bit mask of NSCHK field.
	NVMCTRL_INTFLAG_NSCHK_Msk = 0x20
	// Bit NSCHK.
	NVMCTRL_INTFLAG_NSCHK = 0x20

	// STATUS: Status
	// Position of PRM field.
	NVMCTRL_STATUS_PRM_Pos = 0x0
	// Bit mask of PRM field.
	NVMCTRL_STATUS_PRM_Msk = 0x1
	// Bit PRM.
	NVMCTRL_STATUS_PRM = 0x1
	// Position of LOAD field.
	NVMCTRL_STATUS_LOAD_Pos = 0x1
	// Bit mask of LOAD field.
	NVMCTRL_STATUS_LOAD_Msk = 0x2
	// Bit LOAD.
	NVMCTRL_STATUS_LOAD = 0x2
	// Position of READY field.
	NVMCTRL_STATUS_READY_Pos = 0x2
	// Bit mask of READY field.
	NVMCTRL_STATUS_READY_Msk = 0x4
	// Bit READY.
	NVMCTRL_STATUS_READY = 0x4
	// Position of DALFUSE field.
	NVMCTRL_STATUS_DALFUSE_Pos = 0x3
	// Bit mask of DALFUSE field.
	NVMCTRL_STATUS_DALFUSE_Msk = 0x18

	// ADDR: Address
	// Position of AOFFSET field.
	NVMCTRL_ADDR_AOFFSET_Pos = 0x0
	// Bit mask of AOFFSET field.
	NVMCTRL_ADDR_AOFFSET_Msk = 0xffff
	// Position of ARRAY field.
	NVMCTRL_ADDR_ARRAY_Pos = 0x16
	// Bit mask of ARRAY field.
	NVMCTRL_ADDR_ARRAY_Msk = 0xc00000
	// FLASH Array
	NVMCTRL_ADDR_ARRAY_FLASH = 0x0
	// DATA FLASH Array
	NVMCTRL_ADDR_ARRAY_DATAFLASH = 0x1
	// Auxilliary Space
	NVMCTRL_ADDR_ARRAY_AUX = 0x2

	// SULCK: Secure Unlock Register
	// Position of BS field.
	NVMCTRL_SULCK_BS_Pos = 0x0
	// Bit mask of BS field.
	NVMCTRL_SULCK_BS_Msk = 0x1
	// Bit BS.
	NVMCTRL_SULCK_BS = 0x1
	// Position of AS field.
	NVMCTRL_SULCK_AS_Pos = 0x1
	// Bit mask of AS field.
	NVMCTRL_SULCK_AS_Msk = 0x2
	// Bit AS.
	NVMCTRL_SULCK_AS = 0x2
	// Position of DS field.
	NVMCTRL_SULCK_DS_Pos = 0x2
	// Bit mask of DS field.
	NVMCTRL_SULCK_DS_Msk = 0x4
	// Bit DS.
	NVMCTRL_SULCK_DS = 0x4
	// Position of SLKEY field.
	NVMCTRL_SULCK_SLKEY_Pos = 0x8
	// Bit mask of SLKEY field.
	NVMCTRL_SULCK_SLKEY_Msk = 0xff00
	// Write Key
	NVMCTRL_SULCK_SLKEY_KEY = 0xa5

	// NSULCK: Non-Secure Unlock Register
	// Position of BNS field.
	NVMCTRL_NSULCK_BNS_Pos = 0x0
	// Bit mask of BNS field.
	NVMCTRL_NSULCK_BNS_Msk = 0x1
	// Bit BNS.
	NVMCTRL_NSULCK_BNS = 0x1
	// Position of ANS field.
	NVMCTRL_NSULCK_ANS_Pos = 0x1
	// Bit mask of ANS field.
	NVMCTRL_NSULCK_ANS_Msk = 0x2
	// Bit ANS.
	NVMCTRL_NSULCK_ANS = 0x2
	// Position of DNS field.
	NVMCTRL_NSULCK_DNS_Pos = 0x2
	// Bit mask of DNS field.
	NVMCTRL_NSULCK_DNS_Msk = 0x4
	// Bit DNS.
	NVMCTRL_NSULCK_DNS = 0x4
	// Position of NSLKEY field.
	NVMCTRL_NSULCK_NSLKEY_Pos = 0x8
	// Bit mask of NSLKEY field.
	NVMCTRL_NSULCK_NSLKEY_Msk = 0xff00
	// Write Key
	NVMCTRL_NSULCK_NSLKEY_KEY = 0xa5

	// PARAM: NVM Parameter
	// Position of FLASHP field.
	NVMCTRL_PARAM_FLASHP_Pos = 0x0
	// Bit mask of FLASHP field.
	NVMCTRL_PARAM_FLASHP_Msk = 0xffff
	// Position of PSZ field.
	NVMCTRL_PARAM_PSZ_Pos = 0x10
	// Bit mask of PSZ field.
	NVMCTRL_PARAM_PSZ_Msk = 0x70000
	// 8 bytes
	NVMCTRL_PARAM_PSZ_8 = 0x0
	// 16 bytes
	NVMCTRL_PARAM_PSZ_16 = 0x1
	// 32 bytes
	NVMCTRL_PARAM_PSZ_32 = 0x2
	// 64 bytes
	NVMCTRL_PARAM_PSZ_64 = 0x3
	// 128 bytes
	NVMCTRL_PARAM_PSZ_128 = 0x4
	// 256 bytes
	NVMCTRL_PARAM_PSZ_256 = 0x5
	// 512 bytes
	NVMCTRL_PARAM_PSZ_512 = 0x6
	// 1024 bytes
	NVMCTRL_PARAM_PSZ_1024 = 0x7
	// Position of DFLASHP field.
	NVMCTRL_PARAM_DFLASHP_Pos = 0x14
	// Bit mask of DFLASHP field.
	NVMCTRL_PARAM_DFLASHP_Msk = 0xfff00000

	// DSCC: Data Scramble Configuration
	// Position of DSCKEY field.
	NVMCTRL_DSCC_DSCKEY_Pos = 0x0
	// Bit mask of DSCKEY field.
	NVMCTRL_DSCC_DSCKEY_Msk = 0x3fffffff

	// SECCTRL: Security Control
	// Position of TAMPEEN field.
	NVMCTRL_SECCTRL_TAMPEEN_Pos = 0x0
	// Bit mask of TAMPEEN field.
	NVMCTRL_SECCTRL_TAMPEEN_Msk = 0x1
	// Bit TAMPEEN.
	NVMCTRL_SECCTRL_TAMPEEN = 0x1
	// Position of SILACC field.
	NVMCTRL_SECCTRL_SILACC_Pos = 0x2
	// Bit mask of SILACC field.
	NVMCTRL_SECCTRL_SILACC_Msk = 0x4
	// Bit SILACC.
	NVMCTRL_SECCTRL_SILACC = 0x4
	// Position of DSCEN field.
	NVMCTRL_SECCTRL_DSCEN_Pos = 0x3
	// Bit mask of DSCEN field.
	NVMCTRL_SECCTRL_DSCEN_Msk = 0x8
	// Bit DSCEN.
	NVMCTRL_SECCTRL_DSCEN = 0x8
	// Position of DXN field.
	NVMCTRL_SECCTRL_DXN_Pos = 0x6
	// Bit mask of DXN field.
	NVMCTRL_SECCTRL_DXN_Msk = 0x40
	// Bit DXN.
	NVMCTRL_SECCTRL_DXN = 0x40
	// Position of TEROW field.
	NVMCTRL_SECCTRL_TEROW_Pos = 0x8
	// Bit mask of TEROW field.
	NVMCTRL_SECCTRL_TEROW_Msk = 0x700
	// Position of KEY field.
	NVMCTRL_SECCTRL_KEY_Pos = 0x18
	// Bit mask of KEY field.
	NVMCTRL_SECCTRL_KEY_Msk = 0xff000000
	// Write Key
	NVMCTRL_SECCTRL_KEY_KEY = 0xa5

	// SCFGB: Secure Boot Configuration
	// Position of BCREN field.
	NVMCTRL_SCFGB_BCREN_Pos = 0x0
	// Bit mask of BCREN field.
	NVMCTRL_SCFGB_BCREN_Msk = 0x1
	// Bit BCREN.
	NVMCTRL_SCFGB_BCREN = 0x1
	// Position of BCWEN field.
	NVMCTRL_SCFGB_BCWEN_Pos = 0x1
	// Bit mask of BCWEN field.
	NVMCTRL_SCFGB_BCWEN_Msk = 0x2
	// Bit BCWEN.
	NVMCTRL_SCFGB_BCWEN = 0x2

	// SCFGAD: Secure Application and Data Configuration
	// Position of URWEN field.
	NVMCTRL_SCFGAD_URWEN_Pos = 0x0
	// Bit mask of URWEN field.
	NVMCTRL_SCFGAD_URWEN_Msk = 0x1
	// Bit URWEN.
	NVMCTRL_SCFGAD_URWEN = 0x1

	// NONSEC: Non-secure Write Enable
	// Position of WRITE field.
	NVMCTRL_NONSEC_WRITE_Pos = 0x0
	// Bit mask of WRITE field.
	NVMCTRL_NONSEC_WRITE_Msk = 0x1
	// Bit WRITE.
	NVMCTRL_NONSEC_WRITE = 0x1

	// NSCHK: Non-secure Write Reference Value
	// Position of WRITE field.
	NVMCTRL_NSCHK_WRITE_Pos = 0x0
	// Bit mask of WRITE field.
	NVMCTRL_NSCHK_WRITE_Msk = 0x1
	// Bit WRITE.
	NVMCTRL_NSCHK_WRITE = 0x1
)

// Constants for OPAMP: Operational Amplifier
const (
	// CTRLA: Control A
	// Position of SWRST field.
	OPAMP_CTRLA_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	OPAMP_CTRLA_SWRST_Msk = 0x1
	// Bit SWRST.
	OPAMP_CTRLA_SWRST = 0x1
	// Position of ENABLE field.
	OPAMP_CTRLA_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	OPAMP_CTRLA_ENABLE_Msk = 0x2
	// Bit ENABLE.
	OPAMP_CTRLA_ENABLE = 0x2
	// Position of LPMUX field.
	OPAMP_CTRLA_LPMUX_Pos = 0x7
	// Bit mask of LPMUX field.
	OPAMP_CTRLA_LPMUX_Msk = 0x80
	// Bit LPMUX.
	OPAMP_CTRLA_LPMUX = 0x80

	// STATUS: Status
	// Position of READY0 field.
	OPAMP_STATUS_READY0_Pos = 0x0
	// Bit mask of READY0 field.
	OPAMP_STATUS_READY0_Msk = 0x1
	// Bit READY0.
	OPAMP_STATUS_READY0 = 0x1
	// Position of READY1 field.
	OPAMP_STATUS_READY1_Pos = 0x1
	// Bit mask of READY1 field.
	OPAMP_STATUS_READY1_Msk = 0x2
	// Bit READY1.
	OPAMP_STATUS_READY1 = 0x2
	// Position of READY2 field.
	OPAMP_STATUS_READY2_Pos = 0x2
	// Bit mask of READY2 field.
	OPAMP_STATUS_READY2_Msk = 0x4
	// Bit READY2.
	OPAMP_STATUS_READY2 = 0x4

	// OPAMPCTRL: OPAMP n Control
	// Position of ENABLE field.
	OPAMP_OPAMPCTRL_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	OPAMP_OPAMPCTRL_ENABLE_Msk = 0x2
	// Bit ENABLE.
	OPAMP_OPAMPCTRL_ENABLE = 0x2
	// Position of ANAOUT field.
	OPAMP_OPAMPCTRL_ANAOUT_Pos = 0x2
	// Bit mask of ANAOUT field.
	OPAMP_OPAMPCTRL_ANAOUT_Msk = 0x4
	// Bit ANAOUT.
	OPAMP_OPAMPCTRL_ANAOUT = 0x4
	// Position of BIAS field.
	OPAMP_OPAMPCTRL_BIAS_Pos = 0x3
	// Bit mask of BIAS field.
	OPAMP_OPAMPCTRL_BIAS_Msk = 0x18
	// Position of RES2VCC field.
	OPAMP_OPAMPCTRL_RES2VCC_Pos = 0x5
	// Bit mask of RES2VCC field.
	OPAMP_OPAMPCTRL_RES2VCC_Msk = 0x20
	// Bit RES2VCC.
	OPAMP_OPAMPCTRL_RES2VCC = 0x20
	// Position of RUNSTDBY field.
	OPAMP_OPAMPCTRL_RUNSTDBY_Pos = 0x6
	// Bit mask of RUNSTDBY field.
	OPAMP_OPAMPCTRL_RUNSTDBY_Msk = 0x40
	// Bit RUNSTDBY.
	OPAMP_OPAMPCTRL_RUNSTDBY = 0x40
	// Position of ONDEMAND field.
	OPAMP_OPAMPCTRL_ONDEMAND_Pos = 0x7
	// Bit mask of ONDEMAND field.
	OPAMP_OPAMPCTRL_ONDEMAND_Msk = 0x80
	// Bit ONDEMAND.
	OPAMP_OPAMPCTRL_ONDEMAND = 0x80
	// Position of RES2OUT field.
	OPAMP_OPAMPCTRL_RES2OUT_Pos = 0x8
	// Bit mask of RES2OUT field.
	OPAMP_OPAMPCTRL_RES2OUT_Msk = 0x100
	// Bit RES2OUT.
	OPAMP_OPAMPCTRL_RES2OUT = 0x100
	// Position of RES1EN field.
	OPAMP_OPAMPCTRL_RES1EN_Pos = 0x9
	// Bit mask of RES1EN field.
	OPAMP_OPAMPCTRL_RES1EN_Msk = 0x200
	// Bit RES1EN.
	OPAMP_OPAMPCTRL_RES1EN = 0x200
	// Position of RES1MUX field.
	OPAMP_OPAMPCTRL_RES1MUX_Pos = 0xa
	// Bit mask of RES1MUX field.
	OPAMP_OPAMPCTRL_RES1MUX_Msk = 0x1c00
	// Position of POTMUX field.
	OPAMP_OPAMPCTRL_POTMUX_Pos = 0xd
	// Bit mask of POTMUX field.
	OPAMP_OPAMPCTRL_POTMUX_Msk = 0xe000
	// Position of MUXPOS field.
	OPAMP_OPAMPCTRL_MUXPOS_Pos = 0x10
	// Bit mask of MUXPOS field.
	OPAMP_OPAMPCTRL_MUXPOS_Msk = 0xf0000
	// Position of MUXNEG field.
	OPAMP_OPAMPCTRL_MUXNEG_Pos = 0x14
	// Bit mask of MUXNEG field.
	OPAMP_OPAMPCTRL_MUXNEG_Msk = 0xf00000

	// RESCTRL: Resister Control
	// Position of RES2OUT field.
	OPAMP_RESCTRL_RES2OUT_Pos = 0x0
	// Bit mask of RES2OUT field.
	OPAMP_RESCTRL_RES2OUT_Msk = 0x1
	// Bit RES2OUT.
	OPAMP_RESCTRL_RES2OUT = 0x1
	// Position of RES1EN field.
	OPAMP_RESCTRL_RES1EN_Pos = 0x1
	// Bit mask of RES1EN field.
	OPAMP_RESCTRL_RES1EN_Msk = 0x2
	// Bit RES1EN.
	OPAMP_RESCTRL_RES1EN = 0x2
	// Position of RES1MUX field.
	OPAMP_RESCTRL_RES1MUX_Pos = 0x2
	// Bit mask of RES1MUX field.
	OPAMP_RESCTRL_RES1MUX_Msk = 0x4
	// Bit RES1MUX.
	OPAMP_RESCTRL_RES1MUX = 0x4
	// Position of POTMUX field.
	OPAMP_RESCTRL_POTMUX_Pos = 0x3
	// Bit mask of POTMUX field.
	OPAMP_RESCTRL_POTMUX_Msk = 0x38
	// Position of REFBUFLEVEL field.
	OPAMP_RESCTRL_REFBUFLEVEL_Pos = 0x6
	// Bit mask of REFBUFLEVEL field.
	OPAMP_RESCTRL_REFBUFLEVEL_Msk = 0xc0
)

// Constants for OSCCTRL: Oscillators Control
const (
	// EVCTRL: Event Control
	// Position of CFDEO field.
	OSCCTRL_EVCTRL_CFDEO_Pos = 0x0
	// Bit mask of CFDEO field.
	OSCCTRL_EVCTRL_CFDEO_Msk = 0x1
	// Bit CFDEO.
	OSCCTRL_EVCTRL_CFDEO = 0x1
	// Position of TUNEEI field.
	OSCCTRL_EVCTRL_TUNEEI_Pos = 0x1
	// Bit mask of TUNEEI field.
	OSCCTRL_EVCTRL_TUNEEI_Msk = 0x2
	// Bit TUNEEI.
	OSCCTRL_EVCTRL_TUNEEI = 0x2
	// Position of TUNEINV field.
	OSCCTRL_EVCTRL_TUNEINV_Pos = 0x2
	// Bit mask of TUNEINV field.
	OSCCTRL_EVCTRL_TUNEINV_Msk = 0x4
	// Bit TUNEINV.
	OSCCTRL_EVCTRL_TUNEINV = 0x4

	// INTENCLR: Interrupt Enable Clear
	// Position of XOSCRDY field.
	OSCCTRL_INTENCLR_XOSCRDY_Pos = 0x0
	// Bit mask of XOSCRDY field.
	OSCCTRL_INTENCLR_XOSCRDY_Msk = 0x1
	// Bit XOSCRDY.
	OSCCTRL_INTENCLR_XOSCRDY = 0x1
	// Position of XOSCFAIL field.
	OSCCTRL_INTENCLR_XOSCFAIL_Pos = 0x1
	// Bit mask of XOSCFAIL field.
	OSCCTRL_INTENCLR_XOSCFAIL_Msk = 0x2
	// Bit XOSCFAIL.
	OSCCTRL_INTENCLR_XOSCFAIL = 0x2
	// Position of OSC16MRDY field.
	OSCCTRL_INTENCLR_OSC16MRDY_Pos = 0x4
	// Bit mask of OSC16MRDY field.
	OSCCTRL_INTENCLR_OSC16MRDY_Msk = 0x10
	// Bit OSC16MRDY.
	OSCCTRL_INTENCLR_OSC16MRDY = 0x10
	// Position of DFLLULPRDY field.
	OSCCTRL_INTENCLR_DFLLULPRDY_Pos = 0x8
	// Bit mask of DFLLULPRDY field.
	OSCCTRL_INTENCLR_DFLLULPRDY_Msk = 0x100
	// Bit DFLLULPRDY.
	OSCCTRL_INTENCLR_DFLLULPRDY = 0x100
	// Position of DFLLULPLOCK field.
	OSCCTRL_INTENCLR_DFLLULPLOCK_Pos = 0x9
	// Bit mask of DFLLULPLOCK field.
	OSCCTRL_INTENCLR_DFLLULPLOCK_Msk = 0x200
	// Bit DFLLULPLOCK.
	OSCCTRL_INTENCLR_DFLLULPLOCK = 0x200
	// Position of DFLLULPNOLOCK field.
	OSCCTRL_INTENCLR_DFLLULPNOLOCK_Pos = 0xa
	// Bit mask of DFLLULPNOLOCK field.
	OSCCTRL_INTENCLR_DFLLULPNOLOCK_Msk = 0x400
	// Bit DFLLULPNOLOCK.
	OSCCTRL_INTENCLR_DFLLULPNOLOCK = 0x400
	// Position of DPLLLCKR field.
	OSCCTRL_INTENCLR_DPLLLCKR_Pos = 0x10
	// Bit mask of DPLLLCKR field.
	OSCCTRL_INTENCLR_DPLLLCKR_Msk = 0x10000
	// Bit DPLLLCKR.
	OSCCTRL_INTENCLR_DPLLLCKR = 0x10000
	// Position of DPLLLCKF field.
	OSCCTRL_INTENCLR_DPLLLCKF_Pos = 0x11
	// Bit mask of DPLLLCKF field.
	OSCCTRL_INTENCLR_DPLLLCKF_Msk = 0x20000
	// Bit DPLLLCKF.
	OSCCTRL_INTENCLR_DPLLLCKF = 0x20000
	// Position of DPLLLTO field.
	OSCCTRL_INTENCLR_DPLLLTO_Pos = 0x12
	// Bit mask of DPLLLTO field.
	OSCCTRL_INTENCLR_DPLLLTO_Msk = 0x40000
	// Bit DPLLLTO.
	OSCCTRL_INTENCLR_DPLLLTO = 0x40000
	// Position of DPLLLDRTO field.
	OSCCTRL_INTENCLR_DPLLLDRTO_Pos = 0x13
	// Bit mask of DPLLLDRTO field.
	OSCCTRL_INTENCLR_DPLLLDRTO_Msk = 0x80000
	// Bit DPLLLDRTO.
	OSCCTRL_INTENCLR_DPLLLDRTO = 0x80000

	// INTENSET: Interrupt Enable Set
	// Position of XOSCRDY field.
	OSCCTRL_INTENSET_XOSCRDY_Pos = 0x0
	// Bit mask of XOSCRDY field.
	OSCCTRL_INTENSET_XOSCRDY_Msk = 0x1
	// Bit XOSCRDY.
	OSCCTRL_INTENSET_XOSCRDY = 0x1
	// Position of XOSCFAIL field.
	OSCCTRL_INTENSET_XOSCFAIL_Pos = 0x1
	// Bit mask of XOSCFAIL field.
	OSCCTRL_INTENSET_XOSCFAIL_Msk = 0x2
	// Bit XOSCFAIL.
	OSCCTRL_INTENSET_XOSCFAIL = 0x2
	// Position of OSC16MRDY field.
	OSCCTRL_INTENSET_OSC16MRDY_Pos = 0x4
	// Bit mask of OSC16MRDY field.
	OSCCTRL_INTENSET_OSC16MRDY_Msk = 0x10
	// Bit OSC16MRDY.
	OSCCTRL_INTENSET_OSC16MRDY = 0x10
	// Position of DFLLULPRDY field.
	OSCCTRL_INTENSET_DFLLULPRDY_Pos = 0x8
	// Bit mask of DFLLULPRDY field.
	OSCCTRL_INTENSET_DFLLULPRDY_Msk = 0x100
	// Bit DFLLULPRDY.
	OSCCTRL_INTENSET_DFLLULPRDY = 0x100
	// Position of DFLLULPLOCK field.
	OSCCTRL_INTENSET_DFLLULPLOCK_Pos = 0x9
	// Bit mask of DFLLULPLOCK field.
	OSCCTRL_INTENSET_DFLLULPLOCK_Msk = 0x200
	// Bit DFLLULPLOCK.
	OSCCTRL_INTENSET_DFLLULPLOCK = 0x200
	// Position of DFLLULPNOLOCK field.
	OSCCTRL_INTENSET_DFLLULPNOLOCK_Pos = 0xa
	// Bit mask of DFLLULPNOLOCK field.
	OSCCTRL_INTENSET_DFLLULPNOLOCK_Msk = 0x400
	// Bit DFLLULPNOLOCK.
	OSCCTRL_INTENSET_DFLLULPNOLOCK = 0x400
	// Position of DPLLLCKR field.
	OSCCTRL_INTENSET_DPLLLCKR_Pos = 0x10
	// Bit mask of DPLLLCKR field.
	OSCCTRL_INTENSET_DPLLLCKR_Msk = 0x10000
	// Bit DPLLLCKR.
	OSCCTRL_INTENSET_DPLLLCKR = 0x10000
	// Position of DPLLLCKF field.
	OSCCTRL_INTENSET_DPLLLCKF_Pos = 0x11
	// Bit mask of DPLLLCKF field.
	OSCCTRL_INTENSET_DPLLLCKF_Msk = 0x20000
	// Bit DPLLLCKF.
	OSCCTRL_INTENSET_DPLLLCKF = 0x20000
	// Position of DPLLLTO field.
	OSCCTRL_INTENSET_DPLLLTO_Pos = 0x12
	// Bit mask of DPLLLTO field.
	OSCCTRL_INTENSET_DPLLLTO_Msk = 0x40000
	// Bit DPLLLTO.
	OSCCTRL_INTENSET_DPLLLTO = 0x40000
	// Position of DPLLLDRTO field.
	OSCCTRL_INTENSET_DPLLLDRTO_Pos = 0x13
	// Bit mask of DPLLLDRTO field.
	OSCCTRL_INTENSET_DPLLLDRTO_Msk = 0x80000
	// Bit DPLLLDRTO.
	OSCCTRL_INTENSET_DPLLLDRTO = 0x80000

	// INTFLAG: Interrupt Flag Status and Clear
	// Position of XOSCRDY field.
	OSCCTRL_INTFLAG_XOSCRDY_Pos = 0x0
	// Bit mask of XOSCRDY field.
	OSCCTRL_INTFLAG_XOSCRDY_Msk = 0x1
	// Bit XOSCRDY.
	OSCCTRL_INTFLAG_XOSCRDY = 0x1
	// Position of XOSCFAIL field.
	OSCCTRL_INTFLAG_XOSCFAIL_Pos = 0x1
	// Bit mask of XOSCFAIL field.
	OSCCTRL_INTFLAG_XOSCFAIL_Msk = 0x2
	// Bit XOSCFAIL.
	OSCCTRL_INTFLAG_XOSCFAIL = 0x2
	// Position of OSC16MRDY field.
	OSCCTRL_INTFLAG_OSC16MRDY_Pos = 0x4
	// Bit mask of OSC16MRDY field.
	OSCCTRL_INTFLAG_OSC16MRDY_Msk = 0x10
	// Bit OSC16MRDY.
	OSCCTRL_INTFLAG_OSC16MRDY = 0x10
	// Position of DFLLULPRDY field.
	OSCCTRL_INTFLAG_DFLLULPRDY_Pos = 0x8
	// Bit mask of DFLLULPRDY field.
	OSCCTRL_INTFLAG_DFLLULPRDY_Msk = 0x100
	// Bit DFLLULPRDY.
	OSCCTRL_INTFLAG_DFLLULPRDY = 0x100
	// Position of DFLLULPLOCK field.
	OSCCTRL_INTFLAG_DFLLULPLOCK_Pos = 0x9
	// Bit mask of DFLLULPLOCK field.
	OSCCTRL_INTFLAG_DFLLULPLOCK_Msk = 0x200
	// Bit DFLLULPLOCK.
	OSCCTRL_INTFLAG_DFLLULPLOCK = 0x200
	// Position of DFLLULPNOLOCK field.
	OSCCTRL_INTFLAG_DFLLULPNOLOCK_Pos = 0xa
	// Bit mask of DFLLULPNOLOCK field.
	OSCCTRL_INTFLAG_DFLLULPNOLOCK_Msk = 0x400
	// Bit DFLLULPNOLOCK.
	OSCCTRL_INTFLAG_DFLLULPNOLOCK = 0x400
	// Position of DPLLLCKR field.
	OSCCTRL_INTFLAG_DPLLLCKR_Pos = 0x10
	// Bit mask of DPLLLCKR field.
	OSCCTRL_INTFLAG_DPLLLCKR_Msk = 0x10000
	// Bit DPLLLCKR.
	OSCCTRL_INTFLAG_DPLLLCKR = 0x10000
	// Position of DPLLLCKF field.
	OSCCTRL_INTFLAG_DPLLLCKF_Pos = 0x11
	// Bit mask of DPLLLCKF field.
	OSCCTRL_INTFLAG_DPLLLCKF_Msk = 0x20000
	// Bit DPLLLCKF.
	OSCCTRL_INTFLAG_DPLLLCKF = 0x20000
	// Position of DPLLLTO field.
	OSCCTRL_INTFLAG_DPLLLTO_Pos = 0x12
	// Bit mask of DPLLLTO field.
	OSCCTRL_INTFLAG_DPLLLTO_Msk = 0x40000
	// Bit DPLLLTO.
	OSCCTRL_INTFLAG_DPLLLTO = 0x40000
	// Position of DPLLLDRTO field.
	OSCCTRL_INTFLAG_DPLLLDRTO_Pos = 0x13
	// Bit mask of DPLLLDRTO field.
	OSCCTRL_INTFLAG_DPLLLDRTO_Msk = 0x80000
	// Bit DPLLLDRTO.
	OSCCTRL_INTFLAG_DPLLLDRTO = 0x80000

	// STATUS: Status
	// Position of XOSCRDY field.
	OSCCTRL_STATUS_XOSCRDY_Pos = 0x0
	// Bit mask of XOSCRDY field.
	OSCCTRL_STATUS_XOSCRDY_Msk = 0x1
	// Bit XOSCRDY.
	OSCCTRL_STATUS_XOSCRDY = 0x1
	// Position of XOSCFAIL field.
	OSCCTRL_STATUS_XOSCFAIL_Pos = 0x1
	// Bit mask of XOSCFAIL field.
	OSCCTRL_STATUS_XOSCFAIL_Msk = 0x2
	// Bit XOSCFAIL.
	OSCCTRL_STATUS_XOSCFAIL = 0x2
	// Position of XOSCCKSW field.
	OSCCTRL_STATUS_XOSCCKSW_Pos = 0x2
	// Bit mask of XOSCCKSW field.
	OSCCTRL_STATUS_XOSCCKSW_Msk = 0x4
	// Bit XOSCCKSW.
	OSCCTRL_STATUS_XOSCCKSW = 0x4
	// Position of OSC16MRDY field.
	OSCCTRL_STATUS_OSC16MRDY_Pos = 0x4
	// Bit mask of OSC16MRDY field.
	OSCCTRL_STATUS_OSC16MRDY_Msk = 0x10
	// Bit OSC16MRDY.
	OSCCTRL_STATUS_OSC16MRDY = 0x10
	// Position of DFLLULPRDY field.
	OSCCTRL_STATUS_DFLLULPRDY_Pos = 0x8
	// Bit mask of DFLLULPRDY field.
	OSCCTRL_STATUS_DFLLULPRDY_Msk = 0x100
	// Bit DFLLULPRDY.
	OSCCTRL_STATUS_DFLLULPRDY = 0x100
	// Position of DFLLULPLOCK field.
	OSCCTRL_STATUS_DFLLULPLOCK_Pos = 0x9
	// Bit mask of DFLLULPLOCK field.
	OSCCTRL_STATUS_DFLLULPLOCK_Msk = 0x200
	// Bit DFLLULPLOCK.
	OSCCTRL_STATUS_DFLLULPLOCK = 0x200
	// Position of DFLLULPNOLOCK field.
	OSCCTRL_STATUS_DFLLULPNOLOCK_Pos = 0xa
	// Bit mask of DFLLULPNOLOCK field.
	OSCCTRL_STATUS_DFLLULPNOLOCK_Msk = 0x400
	// Bit DFLLULPNOLOCK.
	OSCCTRL_STATUS_DFLLULPNOLOCK = 0x400
	// Position of DPLLLCKR field.
	OSCCTRL_STATUS_DPLLLCKR_Pos = 0x10
	// Bit mask of DPLLLCKR field.
	OSCCTRL_STATUS_DPLLLCKR_Msk = 0x10000
	// Bit DPLLLCKR.
	OSCCTRL_STATUS_DPLLLCKR = 0x10000
	// Position of DPLLLCKF field.
	OSCCTRL_STATUS_DPLLLCKF_Pos = 0x11
	// Bit mask of DPLLLCKF field.
	OSCCTRL_STATUS_DPLLLCKF_Msk = 0x20000
	// Bit DPLLLCKF.
	OSCCTRL_STATUS_DPLLLCKF = 0x20000
	// Position of DPLLTO field.
	OSCCTRL_STATUS_DPLLTO_Pos = 0x12
	// Bit mask of DPLLTO field.
	OSCCTRL_STATUS_DPLLTO_Msk = 0x40000
	// Bit DPLLTO.
	OSCCTRL_STATUS_DPLLTO = 0x40000
	// Position of DPLLLDRTO field.
	OSCCTRL_STATUS_DPLLLDRTO_Pos = 0x13
	// Bit mask of DPLLLDRTO field.
	OSCCTRL_STATUS_DPLLLDRTO_Msk = 0x80000
	// Bit DPLLLDRTO.
	OSCCTRL_STATUS_DPLLLDRTO = 0x80000

	// XOSCCTRL: External Multipurpose Crystal Oscillator (XOSC) Control
	// Position of ENABLE field.
	OSCCTRL_XOSCCTRL_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	OSCCTRL_XOSCCTRL_ENABLE_Msk = 0x2
	// Bit ENABLE.
	OSCCTRL_XOSCCTRL_ENABLE = 0x2
	// Position of XTALEN field.
	OSCCTRL_XOSCCTRL_XTALEN_Pos = 0x2
	// Bit mask of XTALEN field.
	OSCCTRL_XOSCCTRL_XTALEN_Msk = 0x4
	// Bit XTALEN.
	OSCCTRL_XOSCCTRL_XTALEN = 0x4
	// Position of CFDEN field.
	OSCCTRL_XOSCCTRL_CFDEN_Pos = 0x3
	// Bit mask of CFDEN field.
	OSCCTRL_XOSCCTRL_CFDEN_Msk = 0x8
	// Bit CFDEN.
	OSCCTRL_XOSCCTRL_CFDEN = 0x8
	// Position of SWBEN field.
	OSCCTRL_XOSCCTRL_SWBEN_Pos = 0x4
	// Bit mask of SWBEN field.
	OSCCTRL_XOSCCTRL_SWBEN_Msk = 0x10
	// Bit SWBEN.
	OSCCTRL_XOSCCTRL_SWBEN = 0x10
	// Position of RUNSTDBY field.
	OSCCTRL_XOSCCTRL_RUNSTDBY_Pos = 0x6
	// Bit mask of RUNSTDBY field.
	OSCCTRL_XOSCCTRL_RUNSTDBY_Msk = 0x40
	// Bit RUNSTDBY.
	OSCCTRL_XOSCCTRL_RUNSTDBY = 0x40
	// Position of ONDEMAND field.
	OSCCTRL_XOSCCTRL_ONDEMAND_Pos = 0x7
	// Bit mask of ONDEMAND field.
	OSCCTRL_XOSCCTRL_ONDEMAND_Msk = 0x80
	// Bit ONDEMAND.
	OSCCTRL_XOSCCTRL_ONDEMAND = 0x80
	// Position of GAIN field.
	OSCCTRL_XOSCCTRL_GAIN_Pos = 0x8
	// Bit mask of GAIN field.
	OSCCTRL_XOSCCTRL_GAIN_Msk = 0x700
	// Position of AMPGC field.
	OSCCTRL_XOSCCTRL_AMPGC_Pos = 0xb
	// Bit mask of AMPGC field.
	OSCCTRL_XOSCCTRL_AMPGC_Msk = 0x800
	// Bit AMPGC.
	OSCCTRL_XOSCCTRL_AMPGC = 0x800
	// Position of STARTUP field.
	OSCCTRL_XOSCCTRL_STARTUP_Pos = 0xc
	// Bit mask of STARTUP field.
	OSCCTRL_XOSCCTRL_STARTUP_Msk = 0xf000

	// CFDPRESC: Clock Failure Detector Prescaler
	// Position of CFDPRESC field.
	OSCCTRL_CFDPRESC_CFDPRESC_Pos = 0x0
	// Bit mask of CFDPRESC field.
	OSCCTRL_CFDPRESC_CFDPRESC_Msk = 0x7

	// OSC16MCTRL: 16MHz Internal Oscillator (OSC16M) Control
	// Position of ENABLE field.
	OSCCTRL_OSC16MCTRL_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	OSCCTRL_OSC16MCTRL_ENABLE_Msk = 0x2
	// Bit ENABLE.
	OSCCTRL_OSC16MCTRL_ENABLE = 0x2
	// Position of FSEL field.
	OSCCTRL_OSC16MCTRL_FSEL_Pos = 0x2
	// Bit mask of FSEL field.
	OSCCTRL_OSC16MCTRL_FSEL_Msk = 0xc
	// 4MHz
	OSCCTRL_OSC16MCTRL_FSEL_4 = 0x0
	// 8MHz
	OSCCTRL_OSC16MCTRL_FSEL_8 = 0x1
	// 12MHz
	OSCCTRL_OSC16MCTRL_FSEL_12 = 0x2
	// 16MHz
	OSCCTRL_OSC16MCTRL_FSEL_16 = 0x3
	// Position of RUNSTDBY field.
	OSCCTRL_OSC16MCTRL_RUNSTDBY_Pos = 0x6
	// Bit mask of RUNSTDBY field.
	OSCCTRL_OSC16MCTRL_RUNSTDBY_Msk = 0x40
	// Bit RUNSTDBY.
	OSCCTRL_OSC16MCTRL_RUNSTDBY = 0x40
	// Position of ONDEMAND field.
	OSCCTRL_OSC16MCTRL_ONDEMAND_Pos = 0x7
	// Bit mask of ONDEMAND field.
	OSCCTRL_OSC16MCTRL_ONDEMAND_Msk = 0x80
	// Bit ONDEMAND.
	OSCCTRL_OSC16MCTRL_ONDEMAND = 0x80

	// DFLLULPCTRL: DFLLULP Control
	// Position of ENABLE field.
	OSCCTRL_DFLLULPCTRL_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	OSCCTRL_DFLLULPCTRL_ENABLE_Msk = 0x2
	// Bit ENABLE.
	OSCCTRL_DFLLULPCTRL_ENABLE = 0x2
	// Position of BINSE field.
	OSCCTRL_DFLLULPCTRL_BINSE_Pos = 0x3
	// Bit mask of BINSE field.
	OSCCTRL_DFLLULPCTRL_BINSE_Msk = 0x8
	// Bit BINSE.
	OSCCTRL_DFLLULPCTRL_BINSE = 0x8
	// Position of SAFE field.
	OSCCTRL_DFLLULPCTRL_SAFE_Pos = 0x4
	// Bit mask of SAFE field.
	OSCCTRL_DFLLULPCTRL_SAFE_Msk = 0x10
	// Bit SAFE.
	OSCCTRL_DFLLULPCTRL_SAFE = 0x10
	// Position of DITHER field.
	OSCCTRL_DFLLULPCTRL_DITHER_Pos = 0x5
	// Bit mask of DITHER field.
	OSCCTRL_DFLLULPCTRL_DITHER_Msk = 0x20
	// Bit DITHER.
	OSCCTRL_DFLLULPCTRL_DITHER = 0x20
	// Position of RUNSTDBY field.
	OSCCTRL_DFLLULPCTRL_RUNSTDBY_Pos = 0x6
	// Bit mask of RUNSTDBY field.
	OSCCTRL_DFLLULPCTRL_RUNSTDBY_Msk = 0x40
	// Bit RUNSTDBY.
	OSCCTRL_DFLLULPCTRL_RUNSTDBY = 0x40
	// Position of ONDEMAND field.
	OSCCTRL_DFLLULPCTRL_ONDEMAND_Pos = 0x7
	// Bit mask of ONDEMAND field.
	OSCCTRL_DFLLULPCTRL_ONDEMAND_Msk = 0x80
	// Bit ONDEMAND.
	OSCCTRL_DFLLULPCTRL_ONDEMAND = 0x80
	// Position of DIV field.
	OSCCTRL_DFLLULPCTRL_DIV_Pos = 0x8
	// Bit mask of DIV field.
	OSCCTRL_DFLLULPCTRL_DIV_Msk = 0x700
	// Frequency Divided by 1
	OSCCTRL_DFLLULPCTRL_DIV_DIV1 = 0x0
	// Frequency Divided by 2
	OSCCTRL_DFLLULPCTRL_DIV_DIV2 = 0x1
	// Frequency Divided by 4
	OSCCTRL_DFLLULPCTRL_DIV_DIV4 = 0x2
	// Frequency Divided by 8
	OSCCTRL_DFLLULPCTRL_DIV_DIV8 = 0x3
	// Frequency Divided by 16
	OSCCTRL_DFLLULPCTRL_DIV_DIV16 = 0x4
	// Frequency Divided by 32
	OSCCTRL_DFLLULPCTRL_DIV_DIV32 = 0x5

	// DFLLULPDITHER: DFLLULP Dither Control
	// Position of STEP field.
	OSCCTRL_DFLLULPDITHER_STEP_Pos = 0x0
	// Bit mask of STEP field.
	OSCCTRL_DFLLULPDITHER_STEP_Msk = 0x7
	// Dither Step = 1
	OSCCTRL_DFLLULPDITHER_STEP_STEP1 = 0x0
	// Dither Step = 2
	OSCCTRL_DFLLULPDITHER_STEP_STEP2 = 0x1
	// Dither Step = 4
	OSCCTRL_DFLLULPDITHER_STEP_STEP4 = 0x2
	// Dither Step = 8
	OSCCTRL_DFLLULPDITHER_STEP_STEP8 = 0x3
	// Position of PER field.
	OSCCTRL_DFLLULPDITHER_PER_Pos = 0x4
	// Bit mask of PER field.
	OSCCTRL_DFLLULPDITHER_PER_Msk = 0x70
	// Dither Over 1 Reference Clock Period
	OSCCTRL_DFLLULPDITHER_PER_PER1 = 0x0
	// Dither Over 2 Reference Clock Period
	OSCCTRL_DFLLULPDITHER_PER_PER2 = 0x1
	// Dither Over 4 Reference Clock Period
	OSCCTRL_DFLLULPDITHER_PER_PER4 = 0x2
	// Dither Over 8 Reference Clock Period
	OSCCTRL_DFLLULPDITHER_PER_PER8 = 0x3
	// Dither Over 16 Reference Clock Period
	OSCCTRL_DFLLULPDITHER_PER_PER16 = 0x4
	// Dither Over 32 Reference Clock Period
	OSCCTRL_DFLLULPDITHER_PER_PER32 = 0x5

	// DFLLULPRREQ: DFLLULP Read Request
	// Position of RREQ field.
	OSCCTRL_DFLLULPRREQ_RREQ_Pos = 0x7
	// Bit mask of RREQ field.
	OSCCTRL_DFLLULPRREQ_RREQ_Msk = 0x80
	// Bit RREQ.
	OSCCTRL_DFLLULPRREQ_RREQ = 0x80

	// DFLLULPDLY: DFLLULP Delay Value
	// Position of DELAY field.
	OSCCTRL_DFLLULPDLY_DELAY_Pos = 0x0
	// Bit mask of DELAY field.
	OSCCTRL_DFLLULPDLY_DELAY_Msk = 0xff

	// DFLLULPRATIO: DFLLULP Target Ratio
	// Position of RATIO field.
	OSCCTRL_DFLLULPRATIO_RATIO_Pos = 0x0
	// Bit mask of RATIO field.
	OSCCTRL_DFLLULPRATIO_RATIO_Msk = 0x7ff

	// DFLLULPSYNCBUSY: DFLLULP Synchronization Busy
	// Position of ENABLE field.
	OSCCTRL_DFLLULPSYNCBUSY_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	OSCCTRL_DFLLULPSYNCBUSY_ENABLE_Msk = 0x2
	// Bit ENABLE.
	OSCCTRL_DFLLULPSYNCBUSY_ENABLE = 0x2
	// Position of TUNE field.
	OSCCTRL_DFLLULPSYNCBUSY_TUNE_Pos = 0x2
	// Bit mask of TUNE field.
	OSCCTRL_DFLLULPSYNCBUSY_TUNE_Msk = 0x4
	// Bit TUNE.
	OSCCTRL_DFLLULPSYNCBUSY_TUNE = 0x4
	// Position of DELAY field.
	OSCCTRL_DFLLULPSYNCBUSY_DELAY_Pos = 0x3
	// Bit mask of DELAY field.
	OSCCTRL_DFLLULPSYNCBUSY_DELAY_Msk = 0x8
	// Bit DELAY.
	OSCCTRL_DFLLULPSYNCBUSY_DELAY = 0x8

	// DPLLCTRLA: DPLL Control A
	// Position of ENABLE field.
	OSCCTRL_DPLLCTRLA_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	OSCCTRL_DPLLCTRLA_ENABLE_Msk = 0x2
	// Bit ENABLE.
	OSCCTRL_DPLLCTRLA_ENABLE = 0x2
	// Position of RUNSTDBY field.
	OSCCTRL_DPLLCTRLA_RUNSTDBY_Pos = 0x6
	// Bit mask of RUNSTDBY field.
	OSCCTRL_DPLLCTRLA_RUNSTDBY_Msk = 0x40
	// Bit RUNSTDBY.
	OSCCTRL_DPLLCTRLA_RUNSTDBY = 0x40
	// Position of ONDEMAND field.
	OSCCTRL_DPLLCTRLA_ONDEMAND_Pos = 0x7
	// Bit mask of ONDEMAND field.
	OSCCTRL_DPLLCTRLA_ONDEMAND_Msk = 0x80
	// Bit ONDEMAND.
	OSCCTRL_DPLLCTRLA_ONDEMAND = 0x80

	// DPLLRATIO: DPLL Ratio Control
	// Position of LDR field.
	OSCCTRL_DPLLRATIO_LDR_Pos = 0x0
	// Bit mask of LDR field.
	OSCCTRL_DPLLRATIO_LDR_Msk = 0xfff
	// Position of LDRFRAC field.
	OSCCTRL_DPLLRATIO_LDRFRAC_Pos = 0x10
	// Bit mask of LDRFRAC field.
	OSCCTRL_DPLLRATIO_LDRFRAC_Msk = 0xf0000

	// DPLLCTRLB: DPLL Control B
	// Position of FILTER field.
	OSCCTRL_DPLLCTRLB_FILTER_Pos = 0x0
	// Bit mask of FILTER field.
	OSCCTRL_DPLLCTRLB_FILTER_Msk = 0x3
	// Default Filter Mode
	OSCCTRL_DPLLCTRLB_FILTER_Default = 0x0
	// Low Bandwidth Filter
	OSCCTRL_DPLLCTRLB_FILTER_LBFILT = 0x1
	// High Bandwidth Filter
	OSCCTRL_DPLLCTRLB_FILTER_HBFILT = 0x2
	// High Damping Filter
	OSCCTRL_DPLLCTRLB_FILTER_HDFILT = 0x3
	// Position of LPEN field.
	OSCCTRL_DPLLCTRLB_LPEN_Pos = 0x2
	// Bit mask of LPEN field.
	OSCCTRL_DPLLCTRLB_LPEN_Msk = 0x4
	// Bit LPEN.
	OSCCTRL_DPLLCTRLB_LPEN = 0x4
	// Position of WUF field.
	OSCCTRL_DPLLCTRLB_WUF_Pos = 0x3
	// Bit mask of WUF field.
	OSCCTRL_DPLLCTRLB_WUF_Msk = 0x8
	// Bit WUF.
	OSCCTRL_DPLLCTRLB_WUF = 0x8
	// Position of REFCLK field.
	OSCCTRL_DPLLCTRLB_REFCLK_Pos = 0x4
	// Bit mask of REFCLK field.
	OSCCTRL_DPLLCTRLB_REFCLK_Msk = 0x30
	// XOSC32K Clock Reference
	OSCCTRL_DPLLCTRLB_REFCLK_XOSC32K = 0x0
	// XOSC Clock Reference
	OSCCTRL_DPLLCTRLB_REFCLK_XOSC = 0x1
	// GCLK Clock Reference
	OSCCTRL_DPLLCTRLB_REFCLK_GCLK = 0x2
	// Position of LTIME field.
	OSCCTRL_DPLLCTRLB_LTIME_Pos = 0x8
	// Bit mask of LTIME field.
	OSCCTRL_DPLLCTRLB_LTIME_Msk = 0x700
	// No time-out. Automatic lock
	OSCCTRL_DPLLCTRLB_LTIME_Default = 0x0
	// Time-out if no lock within 8 ms
	OSCCTRL_DPLLCTRLB_LTIME_8MS = 0x4
	// Time-out if no lock within 9 ms
	OSCCTRL_DPLLCTRLB_LTIME_9MS = 0x5
	// Time-out if no lock within 10 ms
	OSCCTRL_DPLLCTRLB_LTIME_10MS = 0x6
	// Time-out if no lock within 11 ms
	OSCCTRL_DPLLCTRLB_LTIME_11MS = 0x7
	// Position of LBYPASS field.
	OSCCTRL_DPLLCTRLB_LBYPASS_Pos = 0xc
	// Bit mask of LBYPASS field.
	OSCCTRL_DPLLCTRLB_LBYPASS_Msk = 0x1000
	// Bit LBYPASS.
	OSCCTRL_DPLLCTRLB_LBYPASS = 0x1000
	// Position of DIV field.
	OSCCTRL_DPLLCTRLB_DIV_Pos = 0x10
	// Bit mask of DIV field.
	OSCCTRL_DPLLCTRLB_DIV_Msk = 0x7ff0000

	// DPLLPRESC: DPLL Prescaler
	// Position of PRESC field.
	OSCCTRL_DPLLPRESC_PRESC_Pos = 0x0
	// Bit mask of PRESC field.
	OSCCTRL_DPLLPRESC_PRESC_Msk = 0x3
	// DPLL output is divided by 1
	OSCCTRL_DPLLPRESC_PRESC_DIV1 = 0x0
	// DPLL output is divided by 2
	OSCCTRL_DPLLPRESC_PRESC_DIV2 = 0x1
	// DPLL output is divided by 4
	OSCCTRL_DPLLPRESC_PRESC_DIV4 = 0x2

	// DPLLSYNCBUSY: DPLL Synchronization Busy
	// Position of ENABLE field.
	OSCCTRL_DPLLSYNCBUSY_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	OSCCTRL_DPLLSYNCBUSY_ENABLE_Msk = 0x2
	// Bit ENABLE.
	OSCCTRL_DPLLSYNCBUSY_ENABLE = 0x2
	// Position of DPLLRATIO field.
	OSCCTRL_DPLLSYNCBUSY_DPLLRATIO_Pos = 0x2
	// Bit mask of DPLLRATIO field.
	OSCCTRL_DPLLSYNCBUSY_DPLLRATIO_Msk = 0x4
	// Bit DPLLRATIO.
	OSCCTRL_DPLLSYNCBUSY_DPLLRATIO = 0x4
	// Position of DPLLPRESC field.
	OSCCTRL_DPLLSYNCBUSY_DPLLPRESC_Pos = 0x3
	// Bit mask of DPLLPRESC field.
	OSCCTRL_DPLLSYNCBUSY_DPLLPRESC_Msk = 0x8
	// Bit DPLLPRESC.
	OSCCTRL_DPLLSYNCBUSY_DPLLPRESC = 0x8

	// DPLLSTATUS: DPLL Status
	// Position of LOCK field.
	OSCCTRL_DPLLSTATUS_LOCK_Pos = 0x0
	// Bit mask of LOCK field.
	OSCCTRL_DPLLSTATUS_LOCK_Msk = 0x1
	// Bit LOCK.
	OSCCTRL_DPLLSTATUS_LOCK = 0x1
	// Position of CLKRDY field.
	OSCCTRL_DPLLSTATUS_CLKRDY_Pos = 0x1
	// Bit mask of CLKRDY field.
	OSCCTRL_DPLLSTATUS_CLKRDY_Msk = 0x2
	// Bit CLKRDY.
	OSCCTRL_DPLLSTATUS_CLKRDY = 0x2
)

// Constants for OSC32KCTRL: 32k Oscillators Control
const (
	// INTENCLR: Interrupt Enable Clear
	// Position of XOSC32KRDY field.
	OSC32KCTRL_INTENCLR_XOSC32KRDY_Pos = 0x0
	// Bit mask of XOSC32KRDY field.
	OSC32KCTRL_INTENCLR_XOSC32KRDY_Msk = 0x1
	// Bit XOSC32KRDY.
	OSC32KCTRL_INTENCLR_XOSC32KRDY = 0x1
	// Position of CLKFAIL field.
	OSC32KCTRL_INTENCLR_CLKFAIL_Pos = 0x2
	// Bit mask of CLKFAIL field.
	OSC32KCTRL_INTENCLR_CLKFAIL_Msk = 0x4
	// Bit CLKFAIL.
	OSC32KCTRL_INTENCLR_CLKFAIL = 0x4

	// INTENSET: Interrupt Enable Set
	// Position of XOSC32KRDY field.
	OSC32KCTRL_INTENSET_XOSC32KRDY_Pos = 0x0
	// Bit mask of XOSC32KRDY field.
	OSC32KCTRL_INTENSET_XOSC32KRDY_Msk = 0x1
	// Bit XOSC32KRDY.
	OSC32KCTRL_INTENSET_XOSC32KRDY = 0x1
	// Position of CLKFAIL field.
	OSC32KCTRL_INTENSET_CLKFAIL_Pos = 0x2
	// Bit mask of CLKFAIL field.
	OSC32KCTRL_INTENSET_CLKFAIL_Msk = 0x4
	// Bit CLKFAIL.
	OSC32KCTRL_INTENSET_CLKFAIL = 0x4

	// INTFLAG: Interrupt Flag Status and Clear
	// Position of XOSC32KRDY field.
	OSC32KCTRL_INTFLAG_XOSC32KRDY_Pos = 0x0
	// Bit mask of XOSC32KRDY field.
	OSC32KCTRL_INTFLAG_XOSC32KRDY_Msk = 0x1
	// Bit XOSC32KRDY.
	OSC32KCTRL_INTFLAG_XOSC32KRDY = 0x1
	// Position of CLKFAIL field.
	OSC32KCTRL_INTFLAG_CLKFAIL_Pos = 0x2
	// Bit mask of CLKFAIL field.
	OSC32KCTRL_INTFLAG_CLKFAIL_Msk = 0x4
	// Bit CLKFAIL.
	OSC32KCTRL_INTFLAG_CLKFAIL = 0x4

	// STATUS: Power and Clocks Status
	// Position of XOSC32KRDY field.
	OSC32KCTRL_STATUS_XOSC32KRDY_Pos = 0x0
	// Bit mask of XOSC32KRDY field.
	OSC32KCTRL_STATUS_XOSC32KRDY_Msk = 0x1
	// Bit XOSC32KRDY.
	OSC32KCTRL_STATUS_XOSC32KRDY = 0x1
	// Position of CLKFAIL field.
	OSC32KCTRL_STATUS_CLKFAIL_Pos = 0x2
	// Bit mask of CLKFAIL field.
	OSC32KCTRL_STATUS_CLKFAIL_Msk = 0x4
	// Bit CLKFAIL.
	OSC32KCTRL_STATUS_CLKFAIL = 0x4
	// Position of CLKSW field.
	OSC32KCTRL_STATUS_CLKSW_Pos = 0x3
	// Bit mask of CLKSW field.
	OSC32KCTRL_STATUS_CLKSW_Msk = 0x8
	// Bit CLKSW.
	OSC32KCTRL_STATUS_CLKSW = 0x8
	// Position of ULP32KSW field.
	OSC32KCTRL_STATUS_ULP32KSW_Pos = 0x4
	// Bit mask of ULP32KSW field.
	OSC32KCTRL_STATUS_ULP32KSW_Msk = 0x10
	// Bit ULP32KSW.
	OSC32KCTRL_STATUS_ULP32KSW = 0x10

	// RTCCTRL: RTC Clock Selection
	// Position of RTCSEL field.
	OSC32KCTRL_RTCCTRL_RTCSEL_Pos = 0x0
	// Bit mask of RTCSEL field.
	OSC32KCTRL_RTCCTRL_RTCSEL_Msk = 0x7
	// 1.024kHz from 32kHz internal ULP oscillator
	OSC32KCTRL_RTCCTRL_RTCSEL_ULP1K = 0x0
	// 32.768kHz from 32kHz internal ULP oscillator
	OSC32KCTRL_RTCCTRL_RTCSEL_ULP32K = 0x1
	// 1.024kHz from 32.768kHz internal oscillator
	OSC32KCTRL_RTCCTRL_RTCSEL_OSC1K = 0x2
	// 32.768kHz from 32.768kHz internal oscillator
	OSC32KCTRL_RTCCTRL_RTCSEL_OSC32K = 0x3
	// 1.024kHz from 32.768kHz internal oscillator
	OSC32KCTRL_RTCCTRL_RTCSEL_XOSC1K = 0x4
	// 32.768kHz from 32.768kHz external crystal oscillator
	OSC32KCTRL_RTCCTRL_RTCSEL_XOSC32K = 0x5

	// XOSC32K: 32kHz External Crystal Oscillator (XOSC32K) Control
	// Position of ENABLE field.
	OSC32KCTRL_XOSC32K_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	OSC32KCTRL_XOSC32K_ENABLE_Msk = 0x2
	// Bit ENABLE.
	OSC32KCTRL_XOSC32K_ENABLE = 0x2
	// Position of XTALEN field.
	OSC32KCTRL_XOSC32K_XTALEN_Pos = 0x2
	// Bit mask of XTALEN field.
	OSC32KCTRL_XOSC32K_XTALEN_Msk = 0x4
	// Bit XTALEN.
	OSC32KCTRL_XOSC32K_XTALEN = 0x4
	// Position of EN32K field.
	OSC32KCTRL_XOSC32K_EN32K_Pos = 0x3
	// Bit mask of EN32K field.
	OSC32KCTRL_XOSC32K_EN32K_Msk = 0x8
	// Bit EN32K.
	OSC32KCTRL_XOSC32K_EN32K = 0x8
	// Position of EN1K field.
	OSC32KCTRL_XOSC32K_EN1K_Pos = 0x4
	// Bit mask of EN1K field.
	OSC32KCTRL_XOSC32K_EN1K_Msk = 0x10
	// Bit EN1K.
	OSC32KCTRL_XOSC32K_EN1K = 0x10
	// Position of RUNSTDBY field.
	OSC32KCTRL_XOSC32K_RUNSTDBY_Pos = 0x6
	// Bit mask of RUNSTDBY field.
	OSC32KCTRL_XOSC32K_RUNSTDBY_Msk = 0x40
	// Bit RUNSTDBY.
	OSC32KCTRL_XOSC32K_RUNSTDBY = 0x40
	// Position of ONDEMAND field.
	OSC32KCTRL_XOSC32K_ONDEMAND_Pos = 0x7
	// Bit mask of ONDEMAND field.
	OSC32KCTRL_XOSC32K_ONDEMAND_Msk = 0x80
	// Bit ONDEMAND.
	OSC32KCTRL_XOSC32K_ONDEMAND = 0x80
	// Position of STARTUP field.
	OSC32KCTRL_XOSC32K_STARTUP_Pos = 0x8
	// Bit mask of STARTUP field.
	OSC32KCTRL_XOSC32K_STARTUP_Msk = 0x700
	// Position of WRTLOCK field.
	OSC32KCTRL_XOSC32K_WRTLOCK_Pos = 0xc
	// Bit mask of WRTLOCK field.
	OSC32KCTRL_XOSC32K_WRTLOCK_Msk = 0x1000
	// Bit WRTLOCK.
	OSC32KCTRL_XOSC32K_WRTLOCK = 0x1000

	// CFDCTRL: Clock Failure Detector Control
	// Position of CFDEN field.
	OSC32KCTRL_CFDCTRL_CFDEN_Pos = 0x0
	// Bit mask of CFDEN field.
	OSC32KCTRL_CFDCTRL_CFDEN_Msk = 0x1
	// Bit CFDEN.
	OSC32KCTRL_CFDCTRL_CFDEN = 0x1
	// Position of SWBACK field.
	OSC32KCTRL_CFDCTRL_SWBACK_Pos = 0x1
	// Bit mask of SWBACK field.
	OSC32KCTRL_CFDCTRL_SWBACK_Msk = 0x2
	// Bit SWBACK.
	OSC32KCTRL_CFDCTRL_SWBACK = 0x2
	// Position of CFDPRESC field.
	OSC32KCTRL_CFDCTRL_CFDPRESC_Pos = 0x2
	// Bit mask of CFDPRESC field.
	OSC32KCTRL_CFDCTRL_CFDPRESC_Msk = 0x4
	// Bit CFDPRESC.
	OSC32KCTRL_CFDCTRL_CFDPRESC = 0x4

	// EVCTRL: Event Control
	// Position of CFDEO field.
	OSC32KCTRL_EVCTRL_CFDEO_Pos = 0x0
	// Bit mask of CFDEO field.
	OSC32KCTRL_EVCTRL_CFDEO_Msk = 0x1
	// Bit CFDEO.
	OSC32KCTRL_EVCTRL_CFDEO = 0x1

	// OSCULP32K: 32kHz Ultra Low Power Internal Oscillator (OSCULP32K) Control
	// Position of ULP32KSW field.
	OSC32KCTRL_OSCULP32K_ULP32KSW_Pos = 0x5
	// Bit mask of ULP32KSW field.
	OSC32KCTRL_OSCULP32K_ULP32KSW_Msk = 0x20
	// Bit ULP32KSW.
	OSC32KCTRL_OSCULP32K_ULP32KSW = 0x20
	// Position of CALIB field.
	OSC32KCTRL_OSCULP32K_CALIB_Pos = 0x8
	// Bit mask of CALIB field.
	OSC32KCTRL_OSCULP32K_CALIB_Msk = 0x1f00
	// Position of WRTLOCK field.
	OSC32KCTRL_OSCULP32K_WRTLOCK_Pos = 0xf
	// Bit mask of WRTLOCK field.
	OSC32KCTRL_OSCULP32K_WRTLOCK_Msk = 0x8000
	// Bit WRTLOCK.
	OSC32KCTRL_OSCULP32K_WRTLOCK = 0x8000
)

// Constants for PAC: Peripheral Access Controller
const (
	// WRCTRL: Write control
	// Position of PERID field.
	PAC_WRCTRL_PERID_Pos = 0x0
	// Bit mask of PERID field.
	PAC_WRCTRL_PERID_Msk = 0xffff
	// Position of KEY field.
	PAC_WRCTRL_KEY_Pos = 0x10
	// Bit mask of KEY field.
	PAC_WRCTRL_KEY_Msk = 0xff0000
	// No action
	PAC_WRCTRL_KEY_OFF = 0x0
	// Clear protection
	PAC_WRCTRL_KEY_CLR = 0x1
	// Set protection
	PAC_WRCTRL_KEY_SET = 0x2
	// Set and lock protection
	PAC_WRCTRL_KEY_SETLCK = 0x3
	// Set IP secure
	PAC_WRCTRL_KEY_SETSEC = 0x4
	// Set IP non-secure
	PAC_WRCTRL_KEY_SETNONSEC = 0x5
	// Lock IP security value
	PAC_WRCTRL_KEY_SECLOCK = 0x6

	// EVCTRL: Event control
	// Position of ERREO field.
	PAC_EVCTRL_ERREO_Pos = 0x0
	// Bit mask of ERREO field.
	PAC_EVCTRL_ERREO_Msk = 0x1
	// Bit ERREO.
	PAC_EVCTRL_ERREO = 0x1

	// INTENCLR: Interrupt enable clear
	// Position of ERR field.
	PAC_INTENCLR_ERR_Pos = 0x0
	// Bit mask of ERR field.
	PAC_INTENCLR_ERR_Msk = 0x1
	// Bit ERR.
	PAC_INTENCLR_ERR = 0x1

	// INTENSET: Interrupt enable set
	// Position of ERR field.
	PAC_INTENSET_ERR_Pos = 0x0
	// Bit mask of ERR field.
	PAC_INTENSET_ERR_Msk = 0x1
	// Bit ERR.
	PAC_INTENSET_ERR = 0x1

	// INTFLAGAHB: Bridge interrupt flag status
	// Position of FLASH_ field.
	PAC_INTFLAGAHB_FLASH__Pos = 0x0
	// Bit mask of FLASH_ field.
	PAC_INTFLAGAHB_FLASH__Msk = 0x1
	// Bit FLASH_.
	PAC_INTFLAGAHB_FLASH_ = 0x1
	// Position of HPB0_ field.
	PAC_INTFLAGAHB_HPB0__Pos = 0x1
	// Bit mask of HPB0_ field.
	PAC_INTFLAGAHB_HPB0__Msk = 0x2
	// Bit HPB0_.
	PAC_INTFLAGAHB_HPB0_ = 0x2
	// Position of HPB1_ field.
	PAC_INTFLAGAHB_HPB1__Pos = 0x2
	// Bit mask of HPB1_ field.
	PAC_INTFLAGAHB_HPB1__Msk = 0x4
	// Bit HPB1_.
	PAC_INTFLAGAHB_HPB1_ = 0x4
	// Position of HPB2_ field.
	PAC_INTFLAGAHB_HPB2__Pos = 0x3
	// Bit mask of HPB2_ field.
	PAC_INTFLAGAHB_HPB2__Msk = 0x8
	// Bit HPB2_.
	PAC_INTFLAGAHB_HPB2_ = 0x8
	// Position of HSRAMCPU_ field.
	PAC_INTFLAGAHB_HSRAMCPU__Pos = 0x4
	// Bit mask of HSRAMCPU_ field.
	PAC_INTFLAGAHB_HSRAMCPU__Msk = 0x10
	// Bit HSRAMCPU_.
	PAC_INTFLAGAHB_HSRAMCPU_ = 0x10
	// Position of HSRAMDMAC_ field.
	PAC_INTFLAGAHB_HSRAMDMAC__Pos = 0x5
	// Bit mask of HSRAMDMAC_ field.
	PAC_INTFLAGAHB_HSRAMDMAC__Msk = 0x20
	// Bit HSRAMDMAC_.
	PAC_INTFLAGAHB_HSRAMDMAC_ = 0x20
	// Position of HSRAMDSU_ field.
	PAC_INTFLAGAHB_HSRAMDSU__Pos = 0x6
	// Bit mask of HSRAMDSU_ field.
	PAC_INTFLAGAHB_HSRAMDSU__Msk = 0x40
	// Bit HSRAMDSU_.
	PAC_INTFLAGAHB_HSRAMDSU_ = 0x40

	// INTFLAGA: Peripheral interrupt flag status - Bridge A
	// Position of PAC_ field.
	PAC_INTFLAGA_PAC__Pos = 0x0
	// Bit mask of PAC_ field.
	PAC_INTFLAGA_PAC__Msk = 0x1
	// Bit PAC_.
	PAC_INTFLAGA_PAC_ = 0x1
	// Position of PM_ field.
	PAC_INTFLAGA_PM__Pos = 0x1
	// Bit mask of PM_ field.
	PAC_INTFLAGA_PM__Msk = 0x2
	// Bit PM_.
	PAC_INTFLAGA_PM_ = 0x2
	// Position of MCLK_ field.
	PAC_INTFLAGA_MCLK__Pos = 0x2
	// Bit mask of MCLK_ field.
	PAC_INTFLAGA_MCLK__Msk = 0x4
	// Bit MCLK_.
	PAC_INTFLAGA_MCLK_ = 0x4
	// Position of RSTC_ field.
	PAC_INTFLAGA_RSTC__Pos = 0x3
	// Bit mask of RSTC_ field.
	PAC_INTFLAGA_RSTC__Msk = 0x8
	// Bit RSTC_.
	PAC_INTFLAGA_RSTC_ = 0x8
	// Position of OSCCTRL_ field.
	PAC_INTFLAGA_OSCCTRL__Pos = 0x4
	// Bit mask of OSCCTRL_ field.
	PAC_INTFLAGA_OSCCTRL__Msk = 0x10
	// Bit OSCCTRL_.
	PAC_INTFLAGA_OSCCTRL_ = 0x10
	// Position of OSC32KCTRL_ field.
	PAC_INTFLAGA_OSC32KCTRL__Pos = 0x5
	// Bit mask of OSC32KCTRL_ field.
	PAC_INTFLAGA_OSC32KCTRL__Msk = 0x20
	// Bit OSC32KCTRL_.
	PAC_INTFLAGA_OSC32KCTRL_ = 0x20
	// Position of SUPC_ field.
	PAC_INTFLAGA_SUPC__Pos = 0x6
	// Bit mask of SUPC_ field.
	PAC_INTFLAGA_SUPC__Msk = 0x40
	// Bit SUPC_.
	PAC_INTFLAGA_SUPC_ = 0x40
	// Position of GCLK_ field.
	PAC_INTFLAGA_GCLK__Pos = 0x7
	// Bit mask of GCLK_ field.
	PAC_INTFLAGA_GCLK__Msk = 0x80
	// Bit GCLK_.
	PAC_INTFLAGA_GCLK_ = 0x80
	// Position of WDT_ field.
	PAC_INTFLAGA_WDT__Pos = 0x8
	// Bit mask of WDT_ field.
	PAC_INTFLAGA_WDT__Msk = 0x100
	// Bit WDT_.
	PAC_INTFLAGA_WDT_ = 0x100
	// Position of RTC_ field.
	PAC_INTFLAGA_RTC__Pos = 0x9
	// Bit mask of RTC_ field.
	PAC_INTFLAGA_RTC__Msk = 0x200
	// Bit RTC_.
	PAC_INTFLAGA_RTC_ = 0x200
	// Position of EIC_ field.
	PAC_INTFLAGA_EIC__Pos = 0xa
	// Bit mask of EIC_ field.
	PAC_INTFLAGA_EIC__Msk = 0x400
	// Bit EIC_.
	PAC_INTFLAGA_EIC_ = 0x400
	// Position of FREQM_ field.
	PAC_INTFLAGA_FREQM__Pos = 0xb
	// Bit mask of FREQM_ field.
	PAC_INTFLAGA_FREQM__Msk = 0x800
	// Bit FREQM_.
	PAC_INTFLAGA_FREQM_ = 0x800
	// Position of PORT_ field.
	PAC_INTFLAGA_PORT__Pos = 0xc
	// Bit mask of PORT_ field.
	PAC_INTFLAGA_PORT__Msk = 0x1000
	// Bit PORT_.
	PAC_INTFLAGA_PORT_ = 0x1000
	// Position of AC_ field.
	PAC_INTFLAGA_AC__Pos = 0xd
	// Bit mask of AC_ field.
	PAC_INTFLAGA_AC__Msk = 0x2000
	// Bit AC_.
	PAC_INTFLAGA_AC_ = 0x2000

	// INTFLAGB: Peripheral interrupt flag status - Bridge B
	// Position of IDAU_ field.
	PAC_INTFLAGB_IDAU__Pos = 0x0
	// Bit mask of IDAU_ field.
	PAC_INTFLAGB_IDAU__Msk = 0x1
	// Bit IDAU_.
	PAC_INTFLAGB_IDAU_ = 0x1
	// Position of DSU_ field.
	PAC_INTFLAGB_DSU__Pos = 0x1
	// Bit mask of DSU_ field.
	PAC_INTFLAGB_DSU__Msk = 0x2
	// Bit DSU_.
	PAC_INTFLAGB_DSU_ = 0x2
	// Position of NVMCTRL_ field.
	PAC_INTFLAGB_NVMCTRL__Pos = 0x2
	// Bit mask of NVMCTRL_ field.
	PAC_INTFLAGB_NVMCTRL__Msk = 0x4
	// Bit NVMCTRL_.
	PAC_INTFLAGB_NVMCTRL_ = 0x4
	// Position of DMAC_ field.
	PAC_INTFLAGB_DMAC__Pos = 0x3
	// Bit mask of DMAC_ field.
	PAC_INTFLAGB_DMAC__Msk = 0x8
	// Bit DMAC_.
	PAC_INTFLAGB_DMAC_ = 0x8

	// INTFLAGC: Peripheral interrupt flag status - Bridge C
	// Position of EVSYS_ field.
	PAC_INTFLAGC_EVSYS__Pos = 0x0
	// Bit mask of EVSYS_ field.
	PAC_INTFLAGC_EVSYS__Msk = 0x1
	// Bit EVSYS_.
	PAC_INTFLAGC_EVSYS_ = 0x1
	// Position of SERCOM0_ field.
	PAC_INTFLAGC_SERCOM0__Pos = 0x1
	// Bit mask of SERCOM0_ field.
	PAC_INTFLAGC_SERCOM0__Msk = 0x2
	// Bit SERCOM0_.
	PAC_INTFLAGC_SERCOM0_ = 0x2
	// Position of SERCOM1_ field.
	PAC_INTFLAGC_SERCOM1__Pos = 0x2
	// Bit mask of SERCOM1_ field.
	PAC_INTFLAGC_SERCOM1__Msk = 0x4
	// Bit SERCOM1_.
	PAC_INTFLAGC_SERCOM1_ = 0x4
	// Position of TC0_ field.
	PAC_INTFLAGC_TC0__Pos = 0x4
	// Bit mask of TC0_ field.
	PAC_INTFLAGC_TC0__Msk = 0x10
	// Bit TC0_.
	PAC_INTFLAGC_TC0_ = 0x10
	// Position of TC1_ field.
	PAC_INTFLAGC_TC1__Pos = 0x5
	// Bit mask of TC1_ field.
	PAC_INTFLAGC_TC1__Msk = 0x20
	// Bit TC1_.
	PAC_INTFLAGC_TC1_ = 0x20
	// Position of TC2_ field.
	PAC_INTFLAGC_TC2__Pos = 0x6
	// Bit mask of TC2_ field.
	PAC_INTFLAGC_TC2__Msk = 0x40
	// Bit TC2_.
	PAC_INTFLAGC_TC2_ = 0x40
	// Position of ADC_ field.
	PAC_INTFLAGC_ADC__Pos = 0x7
	// Bit mask of ADC_ field.
	PAC_INTFLAGC_ADC__Msk = 0x80
	// Bit ADC_.
	PAC_INTFLAGC_ADC_ = 0x80
	// Position of DAC_ field.
	PAC_INTFLAGC_DAC__Pos = 0x8
	// Bit mask of DAC_ field.
	PAC_INTFLAGC_DAC__Msk = 0x100
	// Bit DAC_.
	PAC_INTFLAGC_DAC_ = 0x100
	// Position of PTC_ field.
	PAC_INTFLAGC_PTC__Pos = 0x9
	// Bit mask of PTC_ field.
	PAC_INTFLAGC_PTC__Msk = 0x200
	// Bit PTC_.
	PAC_INTFLAGC_PTC_ = 0x200
	// Position of TRNG_ field.
	PAC_INTFLAGC_TRNG__Pos = 0xa
	// Bit mask of TRNG_ field.
	PAC_INTFLAGC_TRNG__Msk = 0x400
	// Bit TRNG_.
	PAC_INTFLAGC_TRNG_ = 0x400
	// Position of CCL_ field.
	PAC_INTFLAGC_CCL__Pos = 0xb
	// Bit mask of CCL_ field.
	PAC_INTFLAGC_CCL__Msk = 0x800
	// Bit CCL_.
	PAC_INTFLAGC_CCL_ = 0x800
	// Position of OPAMP_ field.
	PAC_INTFLAGC_OPAMP__Pos = 0xc
	// Bit mask of OPAMP_ field.
	PAC_INTFLAGC_OPAMP__Msk = 0x1000
	// Bit OPAMP_.
	PAC_INTFLAGC_OPAMP_ = 0x1000
	// Position of TRAM_ field.
	PAC_INTFLAGC_TRAM__Pos = 0xd
	// Bit mask of TRAM_ field.
	PAC_INTFLAGC_TRAM__Msk = 0x2000
	// Bit TRAM_.
	PAC_INTFLAGC_TRAM_ = 0x2000

	// STATUSA: Peripheral write protection status - Bridge A
	// Position of PAC_ field.
	PAC_STATUSA_PAC__Pos = 0x0
	// Bit mask of PAC_ field.
	PAC_STATUSA_PAC__Msk = 0x1
	// Bit PAC_.
	PAC_STATUSA_PAC_ = 0x1
	// Position of PM_ field.
	PAC_STATUSA_PM__Pos = 0x1
	// Bit mask of PM_ field.
	PAC_STATUSA_PM__Msk = 0x2
	// Bit PM_.
	PAC_STATUSA_PM_ = 0x2
	// Position of MCLK_ field.
	PAC_STATUSA_MCLK__Pos = 0x2
	// Bit mask of MCLK_ field.
	PAC_STATUSA_MCLK__Msk = 0x4
	// Bit MCLK_.
	PAC_STATUSA_MCLK_ = 0x4
	// Position of RSTC_ field.
	PAC_STATUSA_RSTC__Pos = 0x3
	// Bit mask of RSTC_ field.
	PAC_STATUSA_RSTC__Msk = 0x8
	// Bit RSTC_.
	PAC_STATUSA_RSTC_ = 0x8
	// Position of OSCCTRL_ field.
	PAC_STATUSA_OSCCTRL__Pos = 0x4
	// Bit mask of OSCCTRL_ field.
	PAC_STATUSA_OSCCTRL__Msk = 0x10
	// Bit OSCCTRL_.
	PAC_STATUSA_OSCCTRL_ = 0x10
	// Position of OSC32KCTRL_ field.
	PAC_STATUSA_OSC32KCTRL__Pos = 0x5
	// Bit mask of OSC32KCTRL_ field.
	PAC_STATUSA_OSC32KCTRL__Msk = 0x20
	// Bit OSC32KCTRL_.
	PAC_STATUSA_OSC32KCTRL_ = 0x20
	// Position of SUPC_ field.
	PAC_STATUSA_SUPC__Pos = 0x6
	// Bit mask of SUPC_ field.
	PAC_STATUSA_SUPC__Msk = 0x40
	// Bit SUPC_.
	PAC_STATUSA_SUPC_ = 0x40
	// Position of GCLK_ field.
	PAC_STATUSA_GCLK__Pos = 0x7
	// Bit mask of GCLK_ field.
	PAC_STATUSA_GCLK__Msk = 0x80
	// Bit GCLK_.
	PAC_STATUSA_GCLK_ = 0x80
	// Position of WDT_ field.
	PAC_STATUSA_WDT__Pos = 0x8
	// Bit mask of WDT_ field.
	PAC_STATUSA_WDT__Msk = 0x100
	// Bit WDT_.
	PAC_STATUSA_WDT_ = 0x100
	// Position of RTC_ field.
	PAC_STATUSA_RTC__Pos = 0x9
	// Bit mask of RTC_ field.
	PAC_STATUSA_RTC__Msk = 0x200
	// Bit RTC_.
	PAC_STATUSA_RTC_ = 0x200
	// Position of EIC_ field.
	PAC_STATUSA_EIC__Pos = 0xa
	// Bit mask of EIC_ field.
	PAC_STATUSA_EIC__Msk = 0x400
	// Bit EIC_.
	PAC_STATUSA_EIC_ = 0x400
	// Position of FREQM_ field.
	PAC_STATUSA_FREQM__Pos = 0xb
	// Bit mask of FREQM_ field.
	PAC_STATUSA_FREQM__Msk = 0x800
	// Bit FREQM_.
	PAC_STATUSA_FREQM_ = 0x800
	// Position of PORT_ field.
	PAC_STATUSA_PORT__Pos = 0xc
	// Bit mask of PORT_ field.
	PAC_STATUSA_PORT__Msk = 0x1000
	// Bit PORT_.
	PAC_STATUSA_PORT_ = 0x1000
	// Position of AC_ field.
	PAC_STATUSA_AC__Pos = 0xd
	// Bit mask of AC_ field.
	PAC_STATUSA_AC__Msk = 0x2000
	// Bit AC_.
	PAC_STATUSA_AC_ = 0x2000

	// STATUSB: Peripheral write protection status - Bridge B
	// Position of IDAU_ field.
	PAC_STATUSB_IDAU__Pos = 0x0
	// Bit mask of IDAU_ field.
	PAC_STATUSB_IDAU__Msk = 0x1
	// Bit IDAU_.
	PAC_STATUSB_IDAU_ = 0x1
	// Position of DSU_ field.
	PAC_STATUSB_DSU__Pos = 0x1
	// Bit mask of DSU_ field.
	PAC_STATUSB_DSU__Msk = 0x2
	// Bit DSU_.
	PAC_STATUSB_DSU_ = 0x2
	// Position of NVMCTRL_ field.
	PAC_STATUSB_NVMCTRL__Pos = 0x2
	// Bit mask of NVMCTRL_ field.
	PAC_STATUSB_NVMCTRL__Msk = 0x4
	// Bit NVMCTRL_.
	PAC_STATUSB_NVMCTRL_ = 0x4
	// Position of DMAC_ field.
	PAC_STATUSB_DMAC__Pos = 0x3
	// Bit mask of DMAC_ field.
	PAC_STATUSB_DMAC__Msk = 0x8
	// Bit DMAC_.
	PAC_STATUSB_DMAC_ = 0x8

	// STATUSC: Peripheral write protection status - Bridge C
	// Position of EVSYS_ field.
	PAC_STATUSC_EVSYS__Pos = 0x0
	// Bit mask of EVSYS_ field.
	PAC_STATUSC_EVSYS__Msk = 0x1
	// Bit EVSYS_.
	PAC_STATUSC_EVSYS_ = 0x1
	// Position of SERCOM0_ field.
	PAC_STATUSC_SERCOM0__Pos = 0x1
	// Bit mask of SERCOM0_ field.
	PAC_STATUSC_SERCOM0__Msk = 0x2
	// Bit SERCOM0_.
	PAC_STATUSC_SERCOM0_ = 0x2
	// Position of SERCOM1_ field.
	PAC_STATUSC_SERCOM1__Pos = 0x2
	// Bit mask of SERCOM1_ field.
	PAC_STATUSC_SERCOM1__Msk = 0x4
	// Bit SERCOM1_.
	PAC_STATUSC_SERCOM1_ = 0x4
	// Position of TC0_ field.
	PAC_STATUSC_TC0__Pos = 0x4
	// Bit mask of TC0_ field.
	PAC_STATUSC_TC0__Msk = 0x10
	// Bit TC0_.
	PAC_STATUSC_TC0_ = 0x10
	// Position of TC1_ field.
	PAC_STATUSC_TC1__Pos = 0x5
	// Bit mask of TC1_ field.
	PAC_STATUSC_TC1__Msk = 0x20
	// Bit TC1_.
	PAC_STATUSC_TC1_ = 0x20
	// Position of TC2_ field.
	PAC_STATUSC_TC2__Pos = 0x6
	// Bit mask of TC2_ field.
	PAC_STATUSC_TC2__Msk = 0x40
	// Bit TC2_.
	PAC_STATUSC_TC2_ = 0x40
	// Position of ADC_ field.
	PAC_STATUSC_ADC__Pos = 0x7
	// Bit mask of ADC_ field.
	PAC_STATUSC_ADC__Msk = 0x80
	// Bit ADC_.
	PAC_STATUSC_ADC_ = 0x80
	// Position of DAC_ field.
	PAC_STATUSC_DAC__Pos = 0x8
	// Bit mask of DAC_ field.
	PAC_STATUSC_DAC__Msk = 0x100
	// Bit DAC_.
	PAC_STATUSC_DAC_ = 0x100
	// Position of PTC_ field.
	PAC_STATUSC_PTC__Pos = 0x9
	// Bit mask of PTC_ field.
	PAC_STATUSC_PTC__Msk = 0x200
	// Bit PTC_.
	PAC_STATUSC_PTC_ = 0x200
	// Position of TRNG_ field.
	PAC_STATUSC_TRNG__Pos = 0xa
	// Bit mask of TRNG_ field.
	PAC_STATUSC_TRNG__Msk = 0x400
	// Bit TRNG_.
	PAC_STATUSC_TRNG_ = 0x400
	// Position of CCL_ field.
	PAC_STATUSC_CCL__Pos = 0xb
	// Bit mask of CCL_ field.
	PAC_STATUSC_CCL__Msk = 0x800
	// Bit CCL_.
	PAC_STATUSC_CCL_ = 0x800
	// Position of OPAMP_ field.
	PAC_STATUSC_OPAMP__Pos = 0xc
	// Bit mask of OPAMP_ field.
	PAC_STATUSC_OPAMP__Msk = 0x1000
	// Bit OPAMP_.
	PAC_STATUSC_OPAMP_ = 0x1000
	// Position of TRAM_ field.
	PAC_STATUSC_TRAM__Pos = 0xd
	// Bit mask of TRAM_ field.
	PAC_STATUSC_TRAM__Msk = 0x2000
	// Bit TRAM_.
	PAC_STATUSC_TRAM_ = 0x2000

	// NONSECA: Peripheral non-secure status - Bridge A
	// Position of PAC_ field.
	PAC_NONSECA_PAC__Pos = 0x0
	// Bit mask of PAC_ field.
	PAC_NONSECA_PAC__Msk = 0x1
	// Bit PAC_.
	PAC_NONSECA_PAC_ = 0x1
	// Position of PM_ field.
	PAC_NONSECA_PM__Pos = 0x1
	// Bit mask of PM_ field.
	PAC_NONSECA_PM__Msk = 0x2
	// Bit PM_.
	PAC_NONSECA_PM_ = 0x2
	// Position of MCLK_ field.
	PAC_NONSECA_MCLK__Pos = 0x2
	// Bit mask of MCLK_ field.
	PAC_NONSECA_MCLK__Msk = 0x4
	// Bit MCLK_.
	PAC_NONSECA_MCLK_ = 0x4
	// Position of RSTC_ field.
	PAC_NONSECA_RSTC__Pos = 0x3
	// Bit mask of RSTC_ field.
	PAC_NONSECA_RSTC__Msk = 0x8
	// Bit RSTC_.
	PAC_NONSECA_RSTC_ = 0x8
	// Position of OSCCTRL_ field.
	PAC_NONSECA_OSCCTRL__Pos = 0x4
	// Bit mask of OSCCTRL_ field.
	PAC_NONSECA_OSCCTRL__Msk = 0x10
	// Bit OSCCTRL_.
	PAC_NONSECA_OSCCTRL_ = 0x10
	// Position of OSC32KCTRL_ field.
	PAC_NONSECA_OSC32KCTRL__Pos = 0x5
	// Bit mask of OSC32KCTRL_ field.
	PAC_NONSECA_OSC32KCTRL__Msk = 0x20
	// Bit OSC32KCTRL_.
	PAC_NONSECA_OSC32KCTRL_ = 0x20
	// Position of SUPC_ field.
	PAC_NONSECA_SUPC__Pos = 0x6
	// Bit mask of SUPC_ field.
	PAC_NONSECA_SUPC__Msk = 0x40
	// Bit SUPC_.
	PAC_NONSECA_SUPC_ = 0x40
	// Position of GCLK_ field.
	PAC_NONSECA_GCLK__Pos = 0x7
	// Bit mask of GCLK_ field.
	PAC_NONSECA_GCLK__Msk = 0x80
	// Bit GCLK_.
	PAC_NONSECA_GCLK_ = 0x80
	// Position of WDT_ field.
	PAC_NONSECA_WDT__Pos = 0x8
	// Bit mask of WDT_ field.
	PAC_NONSECA_WDT__Msk = 0x100
	// Bit WDT_.
	PAC_NONSECA_WDT_ = 0x100
	// Position of RTC_ field.
	PAC_NONSECA_RTC__Pos = 0x9
	// Bit mask of RTC_ field.
	PAC_NONSECA_RTC__Msk = 0x200
	// Bit RTC_.
	PAC_NONSECA_RTC_ = 0x200
	// Position of EIC_ field.
	PAC_NONSECA_EIC__Pos = 0xa
	// Bit mask of EIC_ field.
	PAC_NONSECA_EIC__Msk = 0x400
	// Bit EIC_.
	PAC_NONSECA_EIC_ = 0x400
	// Position of FREQM_ field.
	PAC_NONSECA_FREQM__Pos = 0xb
	// Bit mask of FREQM_ field.
	PAC_NONSECA_FREQM__Msk = 0x800
	// Bit FREQM_.
	PAC_NONSECA_FREQM_ = 0x800
	// Position of PORT_ field.
	PAC_NONSECA_PORT__Pos = 0xc
	// Bit mask of PORT_ field.
	PAC_NONSECA_PORT__Msk = 0x1000
	// Bit PORT_.
	PAC_NONSECA_PORT_ = 0x1000
	// Position of AC_ field.
	PAC_NONSECA_AC__Pos = 0xd
	// Bit mask of AC_ field.
	PAC_NONSECA_AC__Msk = 0x2000
	// Bit AC_.
	PAC_NONSECA_AC_ = 0x2000

	// NONSECB: Peripheral non-secure status - Bridge B
	// Position of IDAU_ field.
	PAC_NONSECB_IDAU__Pos = 0x0
	// Bit mask of IDAU_ field.
	PAC_NONSECB_IDAU__Msk = 0x1
	// Bit IDAU_.
	PAC_NONSECB_IDAU_ = 0x1
	// Position of DSU_ field.
	PAC_NONSECB_DSU__Pos = 0x1
	// Bit mask of DSU_ field.
	PAC_NONSECB_DSU__Msk = 0x2
	// Bit DSU_.
	PAC_NONSECB_DSU_ = 0x2
	// Position of NVMCTRL_ field.
	PAC_NONSECB_NVMCTRL__Pos = 0x2
	// Bit mask of NVMCTRL_ field.
	PAC_NONSECB_NVMCTRL__Msk = 0x4
	// Bit NVMCTRL_.
	PAC_NONSECB_NVMCTRL_ = 0x4
	// Position of DMAC_ field.
	PAC_NONSECB_DMAC__Pos = 0x3
	// Bit mask of DMAC_ field.
	PAC_NONSECB_DMAC__Msk = 0x8
	// Bit DMAC_.
	PAC_NONSECB_DMAC_ = 0x8

	// NONSECC: Peripheral non-secure status - Bridge C
	// Position of EVSYS_ field.
	PAC_NONSECC_EVSYS__Pos = 0x0
	// Bit mask of EVSYS_ field.
	PAC_NONSECC_EVSYS__Msk = 0x1
	// Bit EVSYS_.
	PAC_NONSECC_EVSYS_ = 0x1
	// Position of SERCOM0_ field.
	PAC_NONSECC_SERCOM0__Pos = 0x1
	// Bit mask of SERCOM0_ field.
	PAC_NONSECC_SERCOM0__Msk = 0x2
	// Bit SERCOM0_.
	PAC_NONSECC_SERCOM0_ = 0x2
	// Position of SERCOM1_ field.
	PAC_NONSECC_SERCOM1__Pos = 0x2
	// Bit mask of SERCOM1_ field.
	PAC_NONSECC_SERCOM1__Msk = 0x4
	// Bit SERCOM1_.
	PAC_NONSECC_SERCOM1_ = 0x4
	// Position of TC0_ field.
	PAC_NONSECC_TC0__Pos = 0x4
	// Bit mask of TC0_ field.
	PAC_NONSECC_TC0__Msk = 0x10
	// Bit TC0_.
	PAC_NONSECC_TC0_ = 0x10
	// Position of TC1_ field.
	PAC_NONSECC_TC1__Pos = 0x5
	// Bit mask of TC1_ field.
	PAC_NONSECC_TC1__Msk = 0x20
	// Bit TC1_.
	PAC_NONSECC_TC1_ = 0x20
	// Position of TC2_ field.
	PAC_NONSECC_TC2__Pos = 0x6
	// Bit mask of TC2_ field.
	PAC_NONSECC_TC2__Msk = 0x40
	// Bit TC2_.
	PAC_NONSECC_TC2_ = 0x40
	// Position of ADC_ field.
	PAC_NONSECC_ADC__Pos = 0x7
	// Bit mask of ADC_ field.
	PAC_NONSECC_ADC__Msk = 0x80
	// Bit ADC_.
	PAC_NONSECC_ADC_ = 0x80
	// Position of DAC_ field.
	PAC_NONSECC_DAC__Pos = 0x8
	// Bit mask of DAC_ field.
	PAC_NONSECC_DAC__Msk = 0x100
	// Bit DAC_.
	PAC_NONSECC_DAC_ = 0x100
	// Position of PTC_ field.
	PAC_NONSECC_PTC__Pos = 0x9
	// Bit mask of PTC_ field.
	PAC_NONSECC_PTC__Msk = 0x200
	// Bit PTC_.
	PAC_NONSECC_PTC_ = 0x200
	// Position of TRNG_ field.
	PAC_NONSECC_TRNG__Pos = 0xa
	// Bit mask of TRNG_ field.
	PAC_NONSECC_TRNG__Msk = 0x400
	// Bit TRNG_.
	PAC_NONSECC_TRNG_ = 0x400
	// Position of CCL_ field.
	PAC_NONSECC_CCL__Pos = 0xb
	// Bit mask of CCL_ field.
	PAC_NONSECC_CCL__Msk = 0x800
	// Bit CCL_.
	PAC_NONSECC_CCL_ = 0x800
	// Position of OPAMP_ field.
	PAC_NONSECC_OPAMP__Pos = 0xc
	// Bit mask of OPAMP_ field.
	PAC_NONSECC_OPAMP__Msk = 0x1000
	// Bit OPAMP_.
	PAC_NONSECC_OPAMP_ = 0x1000
	// Position of TRAM_ field.
	PAC_NONSECC_TRAM__Pos = 0xd
	// Bit mask of TRAM_ field.
	PAC_NONSECC_TRAM__Msk = 0x2000
	// Bit TRAM_.
	PAC_NONSECC_TRAM_ = 0x2000

	// SECLOCKA: Peripheral secure status locked - Bridge A
	// Position of PAC_ field.
	PAC_SECLOCKA_PAC__Pos = 0x0
	// Bit mask of PAC_ field.
	PAC_SECLOCKA_PAC__Msk = 0x1
	// Bit PAC_.
	PAC_SECLOCKA_PAC_ = 0x1
	// Position of PM_ field.
	PAC_SECLOCKA_PM__Pos = 0x1
	// Bit mask of PM_ field.
	PAC_SECLOCKA_PM__Msk = 0x2
	// Bit PM_.
	PAC_SECLOCKA_PM_ = 0x2
	// Position of MCLK_ field.
	PAC_SECLOCKA_MCLK__Pos = 0x2
	// Bit mask of MCLK_ field.
	PAC_SECLOCKA_MCLK__Msk = 0x4
	// Bit MCLK_.
	PAC_SECLOCKA_MCLK_ = 0x4
	// Position of RSTC_ field.
	PAC_SECLOCKA_RSTC__Pos = 0x3
	// Bit mask of RSTC_ field.
	PAC_SECLOCKA_RSTC__Msk = 0x8
	// Bit RSTC_.
	PAC_SECLOCKA_RSTC_ = 0x8
	// Position of OSCCTRL_ field.
	PAC_SECLOCKA_OSCCTRL__Pos = 0x4
	// Bit mask of OSCCTRL_ field.
	PAC_SECLOCKA_OSCCTRL__Msk = 0x10
	// Bit OSCCTRL_.
	PAC_SECLOCKA_OSCCTRL_ = 0x10
	// Position of OSC32KCTRL_ field.
	PAC_SECLOCKA_OSC32KCTRL__Pos = 0x5
	// Bit mask of OSC32KCTRL_ field.
	PAC_SECLOCKA_OSC32KCTRL__Msk = 0x20
	// Bit OSC32KCTRL_.
	PAC_SECLOCKA_OSC32KCTRL_ = 0x20
	// Position of SUPC_ field.
	PAC_SECLOCKA_SUPC__Pos = 0x6
	// Bit mask of SUPC_ field.
	PAC_SECLOCKA_SUPC__Msk = 0x40
	// Bit SUPC_.
	PAC_SECLOCKA_SUPC_ = 0x40
	// Position of GCLK_ field.
	PAC_SECLOCKA_GCLK__Pos = 0x7
	// Bit mask of GCLK_ field.
	PAC_SECLOCKA_GCLK__Msk = 0x80
	// Bit GCLK_.
	PAC_SECLOCKA_GCLK_ = 0x80
	// Position of WDT_ field.
	PAC_SECLOCKA_WDT__Pos = 0x8
	// Bit mask of WDT_ field.
	PAC_SECLOCKA_WDT__Msk = 0x100
	// Bit WDT_.
	PAC_SECLOCKA_WDT_ = 0x100
	// Position of RTC_ field.
	PAC_SECLOCKA_RTC__Pos = 0x9
	// Bit mask of RTC_ field.
	PAC_SECLOCKA_RTC__Msk = 0x200
	// Bit RTC_.
	PAC_SECLOCKA_RTC_ = 0x200
	// Position of EIC_ field.
	PAC_SECLOCKA_EIC__Pos = 0xa
	// Bit mask of EIC_ field.
	PAC_SECLOCKA_EIC__Msk = 0x400
	// Bit EIC_.
	PAC_SECLOCKA_EIC_ = 0x400
	// Position of FREQM_ field.
	PAC_SECLOCKA_FREQM__Pos = 0xb
	// Bit mask of FREQM_ field.
	PAC_SECLOCKA_FREQM__Msk = 0x800
	// Bit FREQM_.
	PAC_SECLOCKA_FREQM_ = 0x800
	// Position of PORT_ field.
	PAC_SECLOCKA_PORT__Pos = 0xc
	// Bit mask of PORT_ field.
	PAC_SECLOCKA_PORT__Msk = 0x1000
	// Bit PORT_.
	PAC_SECLOCKA_PORT_ = 0x1000
	// Position of AC_ field.
	PAC_SECLOCKA_AC__Pos = 0xd
	// Bit mask of AC_ field.
	PAC_SECLOCKA_AC__Msk = 0x2000
	// Bit AC_.
	PAC_SECLOCKA_AC_ = 0x2000

	// SECLOCKB: Peripheral secure status locked - Bridge B
	// Position of IDAU_ field.
	PAC_SECLOCKB_IDAU__Pos = 0x0
	// Bit mask of IDAU_ field.
	PAC_SECLOCKB_IDAU__Msk = 0x1
	// Bit IDAU_.
	PAC_SECLOCKB_IDAU_ = 0x1
	// Position of DSU_ field.
	PAC_SECLOCKB_DSU__Pos = 0x1
	// Bit mask of DSU_ field.
	PAC_SECLOCKB_DSU__Msk = 0x2
	// Bit DSU_.
	PAC_SECLOCKB_DSU_ = 0x2
	// Position of NVMCTRL_ field.
	PAC_SECLOCKB_NVMCTRL__Pos = 0x2
	// Bit mask of NVMCTRL_ field.
	PAC_SECLOCKB_NVMCTRL__Msk = 0x4
	// Bit NVMCTRL_.
	PAC_SECLOCKB_NVMCTRL_ = 0x4
	// Position of DMAC_ field.
	PAC_SECLOCKB_DMAC__Pos = 0x3
	// Bit mask of DMAC_ field.
	PAC_SECLOCKB_DMAC__Msk = 0x8
	// Bit DMAC_.
	PAC_SECLOCKB_DMAC_ = 0x8

	// SECLOCKC: Peripheral secure status locked - Bridge C
	// Position of EVSYS_ field.
	PAC_SECLOCKC_EVSYS__Pos = 0x0
	// Bit mask of EVSYS_ field.
	PAC_SECLOCKC_EVSYS__Msk = 0x1
	// Bit EVSYS_.
	PAC_SECLOCKC_EVSYS_ = 0x1
	// Position of SERCOM0_ field.
	PAC_SECLOCKC_SERCOM0__Pos = 0x1
	// Bit mask of SERCOM0_ field.
	PAC_SECLOCKC_SERCOM0__Msk = 0x2
	// Bit SERCOM0_.
	PAC_SECLOCKC_SERCOM0_ = 0x2
	// Position of SERCOM1_ field.
	PAC_SECLOCKC_SERCOM1__Pos = 0x2
	// Bit mask of SERCOM1_ field.
	PAC_SECLOCKC_SERCOM1__Msk = 0x4
	// Bit SERCOM1_.
	PAC_SECLOCKC_SERCOM1_ = 0x4
	// Position of TC0_ field.
	PAC_SECLOCKC_TC0__Pos = 0x4
	// Bit mask of TC0_ field.
	PAC_SECLOCKC_TC0__Msk = 0x10
	// Bit TC0_.
	PAC_SECLOCKC_TC0_ = 0x10
	// Position of TC1_ field.
	PAC_SECLOCKC_TC1__Pos = 0x5
	// Bit mask of TC1_ field.
	PAC_SECLOCKC_TC1__Msk = 0x20
	// Bit TC1_.
	PAC_SECLOCKC_TC1_ = 0x20
	// Position of TC2_ field.
	PAC_SECLOCKC_TC2__Pos = 0x6
	// Bit mask of TC2_ field.
	PAC_SECLOCKC_TC2__Msk = 0x40
	// Bit TC2_.
	PAC_SECLOCKC_TC2_ = 0x40
	// Position of ADC_ field.
	PAC_SECLOCKC_ADC__Pos = 0x7
	// Bit mask of ADC_ field.
	PAC_SECLOCKC_ADC__Msk = 0x80
	// Bit ADC_.
	PAC_SECLOCKC_ADC_ = 0x80
	// Position of DAC_ field.
	PAC_SECLOCKC_DAC__Pos = 0x8
	// Bit mask of DAC_ field.
	PAC_SECLOCKC_DAC__Msk = 0x100
	// Bit DAC_.
	PAC_SECLOCKC_DAC_ = 0x100
	// Position of PTC_ field.
	PAC_SECLOCKC_PTC__Pos = 0x9
	// Bit mask of PTC_ field.
	PAC_SECLOCKC_PTC__Msk = 0x200
	// Bit PTC_.
	PAC_SECLOCKC_PTC_ = 0x200
	// Position of TRNG_ field.
	PAC_SECLOCKC_TRNG__Pos = 0xa
	// Bit mask of TRNG_ field.
	PAC_SECLOCKC_TRNG__Msk = 0x400
	// Bit TRNG_.
	PAC_SECLOCKC_TRNG_ = 0x400
	// Position of CCL_ field.
	PAC_SECLOCKC_CCL__Pos = 0xb
	// Bit mask of CCL_ field.
	PAC_SECLOCKC_CCL__Msk = 0x800
	// Bit CCL_.
	PAC_SECLOCKC_CCL_ = 0x800
	// Position of OPAMP_ field.
	PAC_SECLOCKC_OPAMP__Pos = 0xc
	// Bit mask of OPAMP_ field.
	PAC_SECLOCKC_OPAMP__Msk = 0x1000
	// Bit OPAMP_.
	PAC_SECLOCKC_OPAMP_ = 0x1000
	// Position of TRAM_ field.
	PAC_SECLOCKC_TRAM__Pos = 0xd
	// Bit mask of TRAM_ field.
	PAC_SECLOCKC_TRAM__Msk = 0x2000
	// Bit TRAM_.
	PAC_SECLOCKC_TRAM_ = 0x2000
)

// Constants for PM: Power Manager
const (
	// SLEEPCFG: Sleep Configuration
	// Position of SLEEPMODE field.
	PM_SLEEPCFG_SLEEPMODE_Pos = 0x0
	// Bit mask of SLEEPMODE field.
	PM_SLEEPCFG_SLEEPMODE_Msk = 0x7
	// CPU, AHB, APB clocks are OFF
	PM_SLEEPCFG_SLEEPMODE_IDLE = 0x2
	// All Clocks are OFF
	PM_SLEEPCFG_SLEEPMODE_STANDBY = 0x4
	// All power domains are powered OFF
	PM_SLEEPCFG_SLEEPMODE_OFF = 0x6

	// PLCFG: Performance Level Configuration
	// Position of PLSEL field.
	PM_PLCFG_PLSEL_Pos = 0x0
	// Bit mask of PLSEL field.
	PM_PLCFG_PLSEL_Msk = 0x3
	// Performance Level 0
	PM_PLCFG_PLSEL_PL0 = 0x0
	// Performance Level 2
	PM_PLCFG_PLSEL_PL2 = 0x2
	// Position of PLDIS field.
	PM_PLCFG_PLDIS_Pos = 0x7
	// Bit mask of PLDIS field.
	PM_PLCFG_PLDIS_Msk = 0x80
	// Bit PLDIS.
	PM_PLCFG_PLDIS = 0x80

	// PWCFG: Power Configuration
	// Position of RAMPSWC field.
	PM_PWCFG_RAMPSWC_Pos = 0x0
	// Bit mask of RAMPSWC field.
	PM_PWCFG_RAMPSWC_Msk = 0x3
	// 16KB Available
	PM_PWCFG_RAMPSWC_16KB = 0x0
	// 12KB Available
	PM_PWCFG_RAMPSWC_12KB = 0x1
	// 8KB Available
	PM_PWCFG_RAMPSWC_8KB = 0x2
	// 4KB Available
	PM_PWCFG_RAMPSWC_4KB = 0x3

	// INTENCLR: Interrupt Enable Clear
	// Position of PLRDY field.
	PM_INTENCLR_PLRDY_Pos = 0x0
	// Bit mask of PLRDY field.
	PM_INTENCLR_PLRDY_Msk = 0x1
	// Bit PLRDY.
	PM_INTENCLR_PLRDY = 0x1

	// INTENSET: Interrupt Enable Set
	// Position of PLRDY field.
	PM_INTENSET_PLRDY_Pos = 0x0
	// Bit mask of PLRDY field.
	PM_INTENSET_PLRDY_Msk = 0x1
	// Bit PLRDY.
	PM_INTENSET_PLRDY = 0x1

	// INTFLAG: Interrupt Flag Status and Clear
	// Position of PLRDY field.
	PM_INTFLAG_PLRDY_Pos = 0x0
	// Bit mask of PLRDY field.
	PM_INTFLAG_PLRDY_Msk = 0x1
	// Bit PLRDY.
	PM_INTFLAG_PLRDY = 0x1

	// STDBYCFG: Standby Configuration
	// Position of PDCFG field.
	PM_STDBYCFG_PDCFG_Pos = 0x0
	// Bit mask of PDCFG field.
	PM_STDBYCFG_PDCFG_Msk = 0x1
	// Bit PDCFG.
	PM_STDBYCFG_PDCFG = 0x1
	// PDSW power domain switching is handled by hardware.
	PM_STDBYCFG_PDCFG_DEFAULT = 0x0
	// PDSW is forced ACTIVE.
	PM_STDBYCFG_PDCFG_PDSW = 0x1
	// Position of DPGPDSW field.
	PM_STDBYCFG_DPGPDSW_Pos = 0x4
	// Bit mask of DPGPDSW field.
	PM_STDBYCFG_DPGPDSW_Msk = 0x10
	// Bit DPGPDSW.
	PM_STDBYCFG_DPGPDSW = 0x10
	// Dynamic Power Gating disabled
	PM_STDBYCFG_DPGPDSW_0 = 0x0
	// Dynamic Power Gating enabled
	PM_STDBYCFG_DPGPDSW_1 = 0x1
	// Position of VREGSMOD field.
	PM_STDBYCFG_VREGSMOD_Pos = 0x6
	// Bit mask of VREGSMOD field.
	PM_STDBYCFG_VREGSMOD_Msk = 0xc0
	// Automatic mode
	PM_STDBYCFG_VREGSMOD_AUTO = 0x0
	// Performance oriented
	PM_STDBYCFG_VREGSMOD_PERFORMANCE = 0x1
	// Low Power oriented
	PM_STDBYCFG_VREGSMOD_LP = 0x2
	// Position of BBIASHS field.
	PM_STDBYCFG_BBIASHS_Pos = 0xa
	// Bit mask of BBIASHS field.
	PM_STDBYCFG_BBIASHS_Msk = 0x400
	// Bit BBIASHS.
	PM_STDBYCFG_BBIASHS = 0x400
	// Position of BBIASTR field.
	PM_STDBYCFG_BBIASTR_Pos = 0xc
	// Bit mask of BBIASTR field.
	PM_STDBYCFG_BBIASTR_Msk = 0x1000
	// Bit BBIASTR.
	PM_STDBYCFG_BBIASTR = 0x1000
)

// Constants for PORT: Port Module
const (
	// GROUP.DIR: Data Direction
	// Position of DIR field.
	PORT_GROUP_DIR_DIR_Pos = 0x0
	// Bit mask of DIR field.
	PORT_GROUP_DIR_DIR_Msk = 0xffffffff

	// GROUP.DIRCLR: Data Direction Clear
	// Position of DIRCLR field.
	PORT_GROUP_DIRCLR_DIRCLR_Pos = 0x0
	// Bit mask of DIRCLR field.
	PORT_GROUP_DIRCLR_DIRCLR_Msk = 0xffffffff

	// GROUP.DIRSET: Data Direction Set
	// Position of DIRSET field.
	PORT_GROUP_DIRSET_DIRSET_Pos = 0x0
	// Bit mask of DIRSET field.
	PORT_GROUP_DIRSET_DIRSET_Msk = 0xffffffff

	// GROUP.DIRTGL: Data Direction Toggle
	// Position of DIRTGL field.
	PORT_GROUP_DIRTGL_DIRTGL_Pos = 0x0
	// Bit mask of DIRTGL field.
	PORT_GROUP_DIRTGL_DIRTGL_Msk = 0xffffffff

	// GROUP.OUT: Data Output Value
	// Position of OUT field.
	PORT_GROUP_OUT_OUT_Pos = 0x0
	// Bit mask of OUT field.
	PORT_GROUP_OUT_OUT_Msk = 0xffffffff

	// GROUP.OUTCLR: Data Output Value Clear
	// Position of OUTCLR field.
	PORT_GROUP_OUTCLR_OUTCLR_Pos = 0x0
	// Bit mask of OUTCLR field.
	PORT_GROUP_OUTCLR_OUTCLR_Msk = 0xffffffff

	// GROUP.OUTSET: Data Output Value Set
	// Position of OUTSET field.
	PORT_GROUP_OUTSET_OUTSET_Pos = 0x0
	// Bit mask of OUTSET field.
	PORT_GROUP_OUTSET_OUTSET_Msk = 0xffffffff

	// GROUP.OUTTGL: Data Output Value Toggle
	// Position of OUTTGL field.
	PORT_GROUP_OUTTGL_OUTTGL_Pos = 0x0
	// Bit mask of OUTTGL field.
	PORT_GROUP_OUTTGL_OUTTGL_Msk = 0xffffffff

	// GROUP.IN: Data Input Value
	// Position of IN field.
	PORT_GROUP_IN_IN_Pos = 0x0
	// Bit mask of IN field.
	PORT_GROUP_IN_IN_Msk = 0xffffffff

	// GROUP.CTRL: Control
	// Position of SAMPLING field.
	PORT_GROUP_CTRL_SAMPLING_Pos = 0x0
	// Bit mask of SAMPLING field.
	PORT_GROUP_CTRL_SAMPLING_Msk = 0xffffffff

	// GROUP.WRCONFIG: Write Configuration
	// Position of PINMASK field.
	PORT_GROUP_WRCONFIG_PINMASK_Pos = 0x0
	// Bit mask of PINMASK field.
	PORT_GROUP_WRCONFIG_PINMASK_Msk = 0xffff
	// Position of PMUXEN field.
	PORT_GROUP_WRCONFIG_PMUXEN_Pos = 0x10
	// Bit mask of PMUXEN field.
	PORT_GROUP_WRCONFIG_PMUXEN_Msk = 0x10000
	// Bit PMUXEN.
	PORT_GROUP_WRCONFIG_PMUXEN = 0x10000
	// Position of INEN field.
	PORT_GROUP_WRCONFIG_INEN_Pos = 0x11
	// Bit mask of INEN field.
	PORT_GROUP_WRCONFIG_INEN_Msk = 0x20000
	// Bit INEN.
	PORT_GROUP_WRCONFIG_INEN = 0x20000
	// Position of PULLEN field.
	PORT_GROUP_WRCONFIG_PULLEN_Pos = 0x12
	// Bit mask of PULLEN field.
	PORT_GROUP_WRCONFIG_PULLEN_Msk = 0x40000
	// Bit PULLEN.
	PORT_GROUP_WRCONFIG_PULLEN = 0x40000
	// Position of DRVSTR field.
	PORT_GROUP_WRCONFIG_DRVSTR_Pos = 0x16
	// Bit mask of DRVSTR field.
	PORT_GROUP_WRCONFIG_DRVSTR_Msk = 0x400000
	// Bit DRVSTR.
	PORT_GROUP_WRCONFIG_DRVSTR = 0x400000
	// Position of PMUX field.
	PORT_GROUP_WRCONFIG_PMUX_Pos = 0x18
	// Bit mask of PMUX field.
	PORT_GROUP_WRCONFIG_PMUX_Msk = 0xf000000
	// Position of WRPMUX field.
	PORT_GROUP_WRCONFIG_WRPMUX_Pos = 0x1c
	// Bit mask of WRPMUX field.
	PORT_GROUP_WRCONFIG_WRPMUX_Msk = 0x10000000
	// Bit WRPMUX.
	PORT_GROUP_WRCONFIG_WRPMUX = 0x10000000
	// Position of WRPINCFG field.
	PORT_GROUP_WRCONFIG_WRPINCFG_Pos = 0x1e
	// Bit mask of WRPINCFG field.
	PORT_GROUP_WRCONFIG_WRPINCFG_Msk = 0x40000000
	// Bit WRPINCFG.
	PORT_GROUP_WRCONFIG_WRPINCFG = 0x40000000
	// Position of HWSEL field.
	PORT_GROUP_WRCONFIG_HWSEL_Pos = 0x1f
	// Bit mask of HWSEL field.
	PORT_GROUP_WRCONFIG_HWSEL_Msk = 0x80000000
	// Bit HWSEL.
	PORT_GROUP_WRCONFIG_HWSEL = 0x80000000

	// GROUP.EVCTRL: Event Input Control
	// Position of PID0 field.
	PORT_GROUP_EVCTRL_PID0_Pos = 0x0
	// Bit mask of PID0 field.
	PORT_GROUP_EVCTRL_PID0_Msk = 0x1f
	// Position of EVACT0 field.
	PORT_GROUP_EVCTRL_EVACT0_Pos = 0x5
	// Bit mask of EVACT0 field.
	PORT_GROUP_EVCTRL_EVACT0_Msk = 0x60
	// Event output to pin
	PORT_GROUP_EVCTRL_EVACT0_OUT = 0x0
	// Set output register of pin on event
	PORT_GROUP_EVCTRL_EVACT0_SET = 0x1
	// Clear output register of pin on event
	PORT_GROUP_EVCTRL_EVACT0_CLR = 0x2
	// Toggle output register of pin on event
	PORT_GROUP_EVCTRL_EVACT0_TGL = 0x3
	// Position of PORTEI0 field.
	PORT_GROUP_EVCTRL_PORTEI0_Pos = 0x7
	// Bit mask of PORTEI0 field.
	PORT_GROUP_EVCTRL_PORTEI0_Msk = 0x80
	// Bit PORTEI0.
	PORT_GROUP_EVCTRL_PORTEI0 = 0x80
	// Position of PID1 field.
	PORT_GROUP_EVCTRL_PID1_Pos = 0x8
	// Bit mask of PID1 field.
	PORT_GROUP_EVCTRL_PID1_Msk = 0x1f00
	// Position of EVACT1 field.
	PORT_GROUP_EVCTRL_EVACT1_Pos = 0xd
	// Bit mask of EVACT1 field.
	PORT_GROUP_EVCTRL_EVACT1_Msk = 0x6000
	// Position of PORTEI1 field.
	PORT_GROUP_EVCTRL_PORTEI1_Pos = 0xf
	// Bit mask of PORTEI1 field.
	PORT_GROUP_EVCTRL_PORTEI1_Msk = 0x8000
	// Bit PORTEI1.
	PORT_GROUP_EVCTRL_PORTEI1 = 0x8000
	// Position of PID2 field.
	PORT_GROUP_EVCTRL_PID2_Pos = 0x10
	// Bit mask of PID2 field.
	PORT_GROUP_EVCTRL_PID2_Msk = 0x1f0000
	// Position of EVACT2 field.
	PORT_GROUP_EVCTRL_EVACT2_Pos = 0x15
	// Bit mask of EVACT2 field.
	PORT_GROUP_EVCTRL_EVACT2_Msk = 0x600000
	// Position of PORTEI2 field.
	PORT_GROUP_EVCTRL_PORTEI2_Pos = 0x17
	// Bit mask of PORTEI2 field.
	PORT_GROUP_EVCTRL_PORTEI2_Msk = 0x800000
	// Bit PORTEI2.
	PORT_GROUP_EVCTRL_PORTEI2 = 0x800000
	// Position of PID3 field.
	PORT_GROUP_EVCTRL_PID3_Pos = 0x18
	// Bit mask of PID3 field.
	PORT_GROUP_EVCTRL_PID3_Msk = 0x1f000000
	// Position of EVACT3 field.
	PORT_GROUP_EVCTRL_EVACT3_Pos = 0x1d
	// Bit mask of EVACT3 field.
	PORT_GROUP_EVCTRL_EVACT3_Msk = 0x60000000
	// Position of PORTEI3 field.
	PORT_GROUP_EVCTRL_PORTEI3_Pos = 0x1f
	// Bit mask of PORTEI3 field.
	PORT_GROUP_EVCTRL_PORTEI3_Msk = 0x80000000
	// Bit PORTEI3.
	PORT_GROUP_EVCTRL_PORTEI3 = 0x80000000

	// GROUP.PMUX: Peripheral Multiplexing
	// Position of PMUXE field.
	PORT_GROUP_PMUX_PMUXE_Pos = 0x0
	// Bit mask of PMUXE field.
	PORT_GROUP_PMUX_PMUXE_Msk = 0xf
	// Position of PMUXO field.
	PORT_GROUP_PMUX_PMUXO_Pos = 0x4
	// Bit mask of PMUXO field.
	PORT_GROUP_PMUX_PMUXO_Msk = 0xf0

	// GROUP.PINCFG: Pin Configuration
	// Position of PMUXEN field.
	PORT_GROUP_PINCFG_PMUXEN_Pos = 0x0
	// Bit mask of PMUXEN field.
	PORT_GROUP_PINCFG_PMUXEN_Msk = 0x1
	// Bit PMUXEN.
	PORT_GROUP_PINCFG_PMUXEN = 0x1
	// Position of INEN field.
	PORT_GROUP_PINCFG_INEN_Pos = 0x1
	// Bit mask of INEN field.
	PORT_GROUP_PINCFG_INEN_Msk = 0x2
	// Bit INEN.
	PORT_GROUP_PINCFG_INEN = 0x2
	// Position of PULLEN field.
	PORT_GROUP_PINCFG_PULLEN_Pos = 0x2
	// Bit mask of PULLEN field.
	PORT_GROUP_PINCFG_PULLEN_Msk = 0x4
	// Bit PULLEN.
	PORT_GROUP_PINCFG_PULLEN = 0x4
	// Position of DRVSTR field.
	PORT_GROUP_PINCFG_DRVSTR_Pos = 0x6
	// Bit mask of DRVSTR field.
	PORT_GROUP_PINCFG_DRVSTR_Msk = 0x40
	// Bit DRVSTR.
	PORT_GROUP_PINCFG_DRVSTR = 0x40

	// GROUP.INTENCLR: Interrupt Enable Clear
	// Position of NSCHK field.
	PORT_GROUP_INTENCLR_NSCHK_Pos = 0x0
	// Bit mask of NSCHK field.
	PORT_GROUP_INTENCLR_NSCHK_Msk = 0x1
	// Bit NSCHK.
	PORT_GROUP_INTENCLR_NSCHK = 0x1

	// GROUP.INTENSET: Interrupt Enable Set
	// Position of NSCHK field.
	PORT_GROUP_INTENSET_NSCHK_Pos = 0x0
	// Bit mask of NSCHK field.
	PORT_GROUP_INTENSET_NSCHK_Msk = 0x1
	// Bit NSCHK.
	PORT_GROUP_INTENSET_NSCHK = 0x1

	// GROUP.INTFLAG: Interrupt Flag Status and Clear
	// Position of NSCHK field.
	PORT_GROUP_INTFLAG_NSCHK_Pos = 0x0
	// Bit mask of NSCHK field.
	PORT_GROUP_INTFLAG_NSCHK_Msk = 0x1
	// Bit NSCHK.
	PORT_GROUP_INTFLAG_NSCHK = 0x1

	// GROUP.NONSEC: Security Attribution
	// Position of NONSEC field.
	PORT_GROUP_NONSEC_NONSEC_Pos = 0x0
	// Bit mask of NONSEC field.
	PORT_GROUP_NONSEC_NONSEC_Msk = 0xffffffff

	// GROUP.NSCHK: Security Attribution Check
	// Position of NSCHK field.
	PORT_GROUP_NSCHK_NSCHK_Pos = 0x0
	// Bit mask of NSCHK field.
	PORT_GROUP_NSCHK_NSCHK_Msk = 0xffffffff
)

// Constants for PTC: Peripheral Touch Controller
const ()

// Constants for RSTC: Reset Controller
const (
	// RCAUSE: Reset Cause
	// Position of POR field.
	RSTC_RCAUSE_POR_Pos = 0x0
	// Bit mask of POR field.
	RSTC_RCAUSE_POR_Msk = 0x1
	// Bit POR.
	RSTC_RCAUSE_POR = 0x1
	// Position of BODCORE field.
	RSTC_RCAUSE_BODCORE_Pos = 0x1
	// Bit mask of BODCORE field.
	RSTC_RCAUSE_BODCORE_Msk = 0x2
	// Bit BODCORE.
	RSTC_RCAUSE_BODCORE = 0x2
	// Position of BODVDD field.
	RSTC_RCAUSE_BODVDD_Pos = 0x2
	// Bit mask of BODVDD field.
	RSTC_RCAUSE_BODVDD_Msk = 0x4
	// Bit BODVDD.
	RSTC_RCAUSE_BODVDD = 0x4
	// Position of EXT field.
	RSTC_RCAUSE_EXT_Pos = 0x4
	// Bit mask of EXT field.
	RSTC_RCAUSE_EXT_Msk = 0x10
	// Bit EXT.
	RSTC_RCAUSE_EXT = 0x10
	// Position of WDT field.
	RSTC_RCAUSE_WDT_Pos = 0x5
	// Bit mask of WDT field.
	RSTC_RCAUSE_WDT_Msk = 0x20
	// Bit WDT.
	RSTC_RCAUSE_WDT = 0x20
	// Position of SYST field.
	RSTC_RCAUSE_SYST_Pos = 0x6
	// Bit mask of SYST field.
	RSTC_RCAUSE_SYST_Msk = 0x40
	// Bit SYST.
	RSTC_RCAUSE_SYST = 0x40
)

// Constants for RTC: Real-Time Counter
const ()

// Constants for RTC_MODE0: Real-Time Counter - MODE0
const (
	// CTRLA: MODE0 Control A
	// Position of SWRST field.
	RTC_MODE0_CTRLA_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	RTC_MODE0_CTRLA_SWRST_Msk = 0x1
	// Bit SWRST.
	RTC_MODE0_CTRLA_SWRST = 0x1
	// Position of ENABLE field.
	RTC_MODE0_CTRLA_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	RTC_MODE0_CTRLA_ENABLE_Msk = 0x2
	// Bit ENABLE.
	RTC_MODE0_CTRLA_ENABLE = 0x2
	// Position of MODE field.
	RTC_MODE0_CTRLA_MODE_Pos = 0x2
	// Bit mask of MODE field.
	RTC_MODE0_CTRLA_MODE_Msk = 0xc
	// Mode 0: 32-bit Counter
	RTC_MODE0_CTRLA_MODE_COUNT32 = 0x0
	// Mode 1: 16-bit Counter
	RTC_MODE0_CTRLA_MODE_COUNT16 = 0x1
	// Mode 2: Clock/Calendar
	RTC_MODE0_CTRLA_MODE_CLOCK = 0x2
	// Position of MATCHCLR field.
	RTC_MODE0_CTRLA_MATCHCLR_Pos = 0x7
	// Bit mask of MATCHCLR field.
	RTC_MODE0_CTRLA_MATCHCLR_Msk = 0x80
	// Bit MATCHCLR.
	RTC_MODE0_CTRLA_MATCHCLR = 0x80
	// Position of PRESCALER field.
	RTC_MODE0_CTRLA_PRESCALER_Pos = 0x8
	// Bit mask of PRESCALER field.
	RTC_MODE0_CTRLA_PRESCALER_Msk = 0xf00
	// CLK_RTC_CNT = GCLK_RTC/1
	RTC_MODE0_CTRLA_PRESCALER_OFF = 0x0
	// CLK_RTC_CNT = GCLK_RTC/1
	RTC_MODE0_CTRLA_PRESCALER_DIV1 = 0x1
	// CLK_RTC_CNT = GCLK_RTC/2
	RTC_MODE0_CTRLA_PRESCALER_DIV2 = 0x2
	// CLK_RTC_CNT = GCLK_RTC/4
	RTC_MODE0_CTRLA_PRESCALER_DIV4 = 0x3
	// CLK_RTC_CNT = GCLK_RTC/8
	RTC_MODE0_CTRLA_PRESCALER_DIV8 = 0x4
	// CLK_RTC_CNT = GCLK_RTC/16
	RTC_MODE0_CTRLA_PRESCALER_DIV16 = 0x5
	// CLK_RTC_CNT = GCLK_RTC/32
	RTC_MODE0_CTRLA_PRESCALER_DIV32 = 0x6
	// CLK_RTC_CNT = GCLK_RTC/64
	RTC_MODE0_CTRLA_PRESCALER_DIV64 = 0x7
	// CLK_RTC_CNT = GCLK_RTC/128
	RTC_MODE0_CTRLA_PRESCALER_DIV128 = 0x8
	// CLK_RTC_CNT = GCLK_RTC/256
	RTC_MODE0_CTRLA_PRESCALER_DIV256 = 0x9
	// CLK_RTC_CNT = GCLK_RTC/512
	RTC_MODE0_CTRLA_PRESCALER_DIV512 = 0xa
	// CLK_RTC_CNT = GCLK_RTC/1024
	RTC_MODE0_CTRLA_PRESCALER_DIV1024 = 0xb
	// Position of GPTRST field.
	RTC_MODE0_CTRLA_GPTRST_Pos = 0xe
	// Bit mask of GPTRST field.
	RTC_MODE0_CTRLA_GPTRST_Msk = 0x4000
	// Bit GPTRST.
	RTC_MODE0_CTRLA_GPTRST = 0x4000
	// Position of COUNTSYNC field.
	RTC_MODE0_CTRLA_COUNTSYNC_Pos = 0xf
	// Bit mask of COUNTSYNC field.
	RTC_MODE0_CTRLA_COUNTSYNC_Msk = 0x8000
	// Bit COUNTSYNC.
	RTC_MODE0_CTRLA_COUNTSYNC = 0x8000

	// CTRLB: MODE0 Control B
	// Position of GP0EN field.
	RTC_MODE0_CTRLB_GP0EN_Pos = 0x0
	// Bit mask of GP0EN field.
	RTC_MODE0_CTRLB_GP0EN_Msk = 0x1
	// Bit GP0EN.
	RTC_MODE0_CTRLB_GP0EN = 0x1
	// Position of DEBMAJ field.
	RTC_MODE0_CTRLB_DEBMAJ_Pos = 0x4
	// Bit mask of DEBMAJ field.
	RTC_MODE0_CTRLB_DEBMAJ_Msk = 0x10
	// Bit DEBMAJ.
	RTC_MODE0_CTRLB_DEBMAJ = 0x10
	// Position of DEBASYNC field.
	RTC_MODE0_CTRLB_DEBASYNC_Pos = 0x5
	// Bit mask of DEBASYNC field.
	RTC_MODE0_CTRLB_DEBASYNC_Msk = 0x20
	// Bit DEBASYNC.
	RTC_MODE0_CTRLB_DEBASYNC = 0x20
	// Position of RTCOUT field.
	RTC_MODE0_CTRLB_RTCOUT_Pos = 0x6
	// Bit mask of RTCOUT field.
	RTC_MODE0_CTRLB_RTCOUT_Msk = 0x40
	// Bit RTCOUT.
	RTC_MODE0_CTRLB_RTCOUT = 0x40
	// Position of DMAEN field.
	RTC_MODE0_CTRLB_DMAEN_Pos = 0x7
	// Bit mask of DMAEN field.
	RTC_MODE0_CTRLB_DMAEN_Msk = 0x80
	// Bit DMAEN.
	RTC_MODE0_CTRLB_DMAEN = 0x80
	// Position of DEBF field.
	RTC_MODE0_CTRLB_DEBF_Pos = 0x8
	// Bit mask of DEBF field.
	RTC_MODE0_CTRLB_DEBF_Msk = 0x700
	// CLK_RTC_DEB = CLK_RTC/2
	RTC_MODE0_CTRLB_DEBF_DIV2 = 0x0
	// CLK_RTC_DEB = CLK_RTC/4
	RTC_MODE0_CTRLB_DEBF_DIV4 = 0x1
	// CLK_RTC_DEB = CLK_RTC/8
	RTC_MODE0_CTRLB_DEBF_DIV8 = 0x2
	// CLK_RTC_DEB = CLK_RTC/16
	RTC_MODE0_CTRLB_DEBF_DIV16 = 0x3
	// CLK_RTC_DEB = CLK_RTC/32
	RTC_MODE0_CTRLB_DEBF_DIV32 = 0x4
	// CLK_RTC_DEB = CLK_RTC/64
	RTC_MODE0_CTRLB_DEBF_DIV64 = 0x5
	// CLK_RTC_DEB = CLK_RTC/128
	RTC_MODE0_CTRLB_DEBF_DIV128 = 0x6
	// CLK_RTC_DEB = CLK_RTC/256
	RTC_MODE0_CTRLB_DEBF_DIV256 = 0x7
	// Position of ACTF field.
	RTC_MODE0_CTRLB_ACTF_Pos = 0xc
	// Bit mask of ACTF field.
	RTC_MODE0_CTRLB_ACTF_Msk = 0x7000
	// CLK_RTC_OUT = CLK_RTC/2
	RTC_MODE0_CTRLB_ACTF_DIV2 = 0x0
	// CLK_RTC_OUT = CLK_RTC/4
	RTC_MODE0_CTRLB_ACTF_DIV4 = 0x1
	// CLK_RTC_OUT = CLK_RTC/8
	RTC_MODE0_CTRLB_ACTF_DIV8 = 0x2
	// CLK_RTC_OUT = CLK_RTC/16
	RTC_MODE0_CTRLB_ACTF_DIV16 = 0x3
	// CLK_RTC_OUT = CLK_RTC/32
	RTC_MODE0_CTRLB_ACTF_DIV32 = 0x4
	// CLK_RTC_OUT = CLK_RTC/64
	RTC_MODE0_CTRLB_ACTF_DIV64 = 0x5
	// CLK_RTC_OUT = CLK_RTC/128
	RTC_MODE0_CTRLB_ACTF_DIV128 = 0x6
	// CLK_RTC_OUT = CLK_RTC/256
	RTC_MODE0_CTRLB_ACTF_DIV256 = 0x7
	// Position of SEPTO field.
	RTC_MODE0_CTRLB_SEPTO_Pos = 0xf
	// Bit mask of SEPTO field.
	RTC_MODE0_CTRLB_SEPTO_Msk = 0x8000
	// Bit SEPTO.
	RTC_MODE0_CTRLB_SEPTO = 0x8000

	// EVCTRL: MODE0 Event Control
	// Position of PEREO0 field.
	RTC_MODE0_EVCTRL_PEREO0_Pos = 0x0
	// Bit mask of PEREO0 field.
	RTC_MODE0_EVCTRL_PEREO0_Msk = 0x1
	// Bit PEREO0.
	RTC_MODE0_EVCTRL_PEREO0 = 0x1
	// Position of PEREO1 field.
	RTC_MODE0_EVCTRL_PEREO1_Pos = 0x1
	// Bit mask of PEREO1 field.
	RTC_MODE0_EVCTRL_PEREO1_Msk = 0x2
	// Bit PEREO1.
	RTC_MODE0_EVCTRL_PEREO1 = 0x2
	// Position of PEREO2 field.
	RTC_MODE0_EVCTRL_PEREO2_Pos = 0x2
	// Bit mask of PEREO2 field.
	RTC_MODE0_EVCTRL_PEREO2_Msk = 0x4
	// Bit PEREO2.
	RTC_MODE0_EVCTRL_PEREO2 = 0x4
	// Position of PEREO3 field.
	RTC_MODE0_EVCTRL_PEREO3_Pos = 0x3
	// Bit mask of PEREO3 field.
	RTC_MODE0_EVCTRL_PEREO3_Msk = 0x8
	// Bit PEREO3.
	RTC_MODE0_EVCTRL_PEREO3 = 0x8
	// Position of PEREO4 field.
	RTC_MODE0_EVCTRL_PEREO4_Pos = 0x4
	// Bit mask of PEREO4 field.
	RTC_MODE0_EVCTRL_PEREO4_Msk = 0x10
	// Bit PEREO4.
	RTC_MODE0_EVCTRL_PEREO4 = 0x10
	// Position of PEREO5 field.
	RTC_MODE0_EVCTRL_PEREO5_Pos = 0x5
	// Bit mask of PEREO5 field.
	RTC_MODE0_EVCTRL_PEREO5_Msk = 0x20
	// Bit PEREO5.
	RTC_MODE0_EVCTRL_PEREO5 = 0x20
	// Position of PEREO6 field.
	RTC_MODE0_EVCTRL_PEREO6_Pos = 0x6
	// Bit mask of PEREO6 field.
	RTC_MODE0_EVCTRL_PEREO6_Msk = 0x40
	// Bit PEREO6.
	RTC_MODE0_EVCTRL_PEREO6 = 0x40
	// Position of PEREO7 field.
	RTC_MODE0_EVCTRL_PEREO7_Pos = 0x7
	// Bit mask of PEREO7 field.
	RTC_MODE0_EVCTRL_PEREO7_Msk = 0x80
	// Bit PEREO7.
	RTC_MODE0_EVCTRL_PEREO7 = 0x80
	// Position of CMPEO0 field.
	RTC_MODE0_EVCTRL_CMPEO0_Pos = 0x8
	// Bit mask of CMPEO0 field.
	RTC_MODE0_EVCTRL_CMPEO0_Msk = 0x100
	// Bit CMPEO0.
	RTC_MODE0_EVCTRL_CMPEO0 = 0x100
	// Position of TAMPEREO field.
	RTC_MODE0_EVCTRL_TAMPEREO_Pos = 0xe
	// Bit mask of TAMPEREO field.
	RTC_MODE0_EVCTRL_TAMPEREO_Msk = 0x4000
	// Bit TAMPEREO.
	RTC_MODE0_EVCTRL_TAMPEREO = 0x4000
	// Position of OVFEO field.
	RTC_MODE0_EVCTRL_OVFEO_Pos = 0xf
	// Bit mask of OVFEO field.
	RTC_MODE0_EVCTRL_OVFEO_Msk = 0x8000
	// Bit OVFEO.
	RTC_MODE0_EVCTRL_OVFEO = 0x8000
	// Position of TAMPEVEI field.
	RTC_MODE0_EVCTRL_TAMPEVEI_Pos = 0x10
	// Bit mask of TAMPEVEI field.
	RTC_MODE0_EVCTRL_TAMPEVEI_Msk = 0x10000
	// Bit TAMPEVEI.
	RTC_MODE0_EVCTRL_TAMPEVEI = 0x10000
	// Position of PERDEO field.
	RTC_MODE0_EVCTRL_PERDEO_Pos = 0x18
	// Bit mask of PERDEO field.
	RTC_MODE0_EVCTRL_PERDEO_Msk = 0x1000000
	// Bit PERDEO.
	RTC_MODE0_EVCTRL_PERDEO = 0x1000000

	// INTENCLR: MODE0 Interrupt Enable Clear
	// Position of PER0 field.
	RTC_MODE0_INTENCLR_PER0_Pos = 0x0
	// Bit mask of PER0 field.
	RTC_MODE0_INTENCLR_PER0_Msk = 0x1
	// Bit PER0.
	RTC_MODE0_INTENCLR_PER0 = 0x1
	// Position of PER1 field.
	RTC_MODE0_INTENCLR_PER1_Pos = 0x1
	// Bit mask of PER1 field.
	RTC_MODE0_INTENCLR_PER1_Msk = 0x2
	// Bit PER1.
	RTC_MODE0_INTENCLR_PER1 = 0x2
	// Position of PER2 field.
	RTC_MODE0_INTENCLR_PER2_Pos = 0x2
	// Bit mask of PER2 field.
	RTC_MODE0_INTENCLR_PER2_Msk = 0x4
	// Bit PER2.
	RTC_MODE0_INTENCLR_PER2 = 0x4
	// Position of PER3 field.
	RTC_MODE0_INTENCLR_PER3_Pos = 0x3
	// Bit mask of PER3 field.
	RTC_MODE0_INTENCLR_PER3_Msk = 0x8
	// Bit PER3.
	RTC_MODE0_INTENCLR_PER3 = 0x8
	// Position of PER4 field.
	RTC_MODE0_INTENCLR_PER4_Pos = 0x4
	// Bit mask of PER4 field.
	RTC_MODE0_INTENCLR_PER4_Msk = 0x10
	// Bit PER4.
	RTC_MODE0_INTENCLR_PER4 = 0x10
	// Position of PER5 field.
	RTC_MODE0_INTENCLR_PER5_Pos = 0x5
	// Bit mask of PER5 field.
	RTC_MODE0_INTENCLR_PER5_Msk = 0x20
	// Bit PER5.
	RTC_MODE0_INTENCLR_PER5 = 0x20
	// Position of PER6 field.
	RTC_MODE0_INTENCLR_PER6_Pos = 0x6
	// Bit mask of PER6 field.
	RTC_MODE0_INTENCLR_PER6_Msk = 0x40
	// Bit PER6.
	RTC_MODE0_INTENCLR_PER6 = 0x40
	// Position of PER7 field.
	RTC_MODE0_INTENCLR_PER7_Pos = 0x7
	// Bit mask of PER7 field.
	RTC_MODE0_INTENCLR_PER7_Msk = 0x80
	// Bit PER7.
	RTC_MODE0_INTENCLR_PER7 = 0x80
	// Position of CMP0 field.
	RTC_MODE0_INTENCLR_CMP0_Pos = 0x8
	// Bit mask of CMP0 field.
	RTC_MODE0_INTENCLR_CMP0_Msk = 0x100
	// Bit CMP0.
	RTC_MODE0_INTENCLR_CMP0 = 0x100
	// Position of TAMPER field.
	RTC_MODE0_INTENCLR_TAMPER_Pos = 0xe
	// Bit mask of TAMPER field.
	RTC_MODE0_INTENCLR_TAMPER_Msk = 0x4000
	// Bit TAMPER.
	RTC_MODE0_INTENCLR_TAMPER = 0x4000
	// Position of OVF field.
	RTC_MODE0_INTENCLR_OVF_Pos = 0xf
	// Bit mask of OVF field.
	RTC_MODE0_INTENCLR_OVF_Msk = 0x8000
	// Bit OVF.
	RTC_MODE0_INTENCLR_OVF = 0x8000

	// INTENSET: MODE0 Interrupt Enable Set
	// Position of PER0 field.
	RTC_MODE0_INTENSET_PER0_Pos = 0x0
	// Bit mask of PER0 field.
	RTC_MODE0_INTENSET_PER0_Msk = 0x1
	// Bit PER0.
	RTC_MODE0_INTENSET_PER0 = 0x1
	// Position of PER1 field.
	RTC_MODE0_INTENSET_PER1_Pos = 0x1
	// Bit mask of PER1 field.
	RTC_MODE0_INTENSET_PER1_Msk = 0x2
	// Bit PER1.
	RTC_MODE0_INTENSET_PER1 = 0x2
	// Position of PER2 field.
	RTC_MODE0_INTENSET_PER2_Pos = 0x2
	// Bit mask of PER2 field.
	RTC_MODE0_INTENSET_PER2_Msk = 0x4
	// Bit PER2.
	RTC_MODE0_INTENSET_PER2 = 0x4
	// Position of PER3 field.
	RTC_MODE0_INTENSET_PER3_Pos = 0x3
	// Bit mask of PER3 field.
	RTC_MODE0_INTENSET_PER3_Msk = 0x8
	// Bit PER3.
	RTC_MODE0_INTENSET_PER3 = 0x8
	// Position of PER4 field.
	RTC_MODE0_INTENSET_PER4_Pos = 0x4
	// Bit mask of PER4 field.
	RTC_MODE0_INTENSET_PER4_Msk = 0x10
	// Bit PER4.
	RTC_MODE0_INTENSET_PER4 = 0x10
	// Position of PER5 field.
	RTC_MODE0_INTENSET_PER5_Pos = 0x5
	// Bit mask of PER5 field.
	RTC_MODE0_INTENSET_PER5_Msk = 0x20
	// Bit PER5.
	RTC_MODE0_INTENSET_PER5 = 0x20
	// Position of PER6 field.
	RTC_MODE0_INTENSET_PER6_Pos = 0x6
	// Bit mask of PER6 field.
	RTC_MODE0_INTENSET_PER6_Msk = 0x40
	// Bit PER6.
	RTC_MODE0_INTENSET_PER6 = 0x40
	// Position of PER7 field.
	RTC_MODE0_INTENSET_PER7_Pos = 0x7
	// Bit mask of PER7 field.
	RTC_MODE0_INTENSET_PER7_Msk = 0x80
	// Bit PER7.
	RTC_MODE0_INTENSET_PER7 = 0x80
	// Position of CMP0 field.
	RTC_MODE0_INTENSET_CMP0_Pos = 0x8
	// Bit mask of CMP0 field.
	RTC_MODE0_INTENSET_CMP0_Msk = 0x100
	// Bit CMP0.
	RTC_MODE0_INTENSET_CMP0 = 0x100
	// Position of TAMPER field.
	RTC_MODE0_INTENSET_TAMPER_Pos = 0xe
	// Bit mask of TAMPER field.
	RTC_MODE0_INTENSET_TAMPER_Msk = 0x4000
	// Bit TAMPER.
	RTC_MODE0_INTENSET_TAMPER = 0x4000
	// Position of OVF field.
	RTC_MODE0_INTENSET_OVF_Pos = 0xf
	// Bit mask of OVF field.
	RTC_MODE0_INTENSET_OVF_Msk = 0x8000
	// Bit OVF.
	RTC_MODE0_INTENSET_OVF = 0x8000

	// INTFLAG: MODE0 Interrupt Flag Status and Clear
	// Position of PER0 field.
	RTC_MODE0_INTFLAG_PER0_Pos = 0x0
	// Bit mask of PER0 field.
	RTC_MODE0_INTFLAG_PER0_Msk = 0x1
	// Bit PER0.
	RTC_MODE0_INTFLAG_PER0 = 0x1
	// Position of PER1 field.
	RTC_MODE0_INTFLAG_PER1_Pos = 0x1
	// Bit mask of PER1 field.
	RTC_MODE0_INTFLAG_PER1_Msk = 0x2
	// Bit PER1.
	RTC_MODE0_INTFLAG_PER1 = 0x2
	// Position of PER2 field.
	RTC_MODE0_INTFLAG_PER2_Pos = 0x2
	// Bit mask of PER2 field.
	RTC_MODE0_INTFLAG_PER2_Msk = 0x4
	// Bit PER2.
	RTC_MODE0_INTFLAG_PER2 = 0x4
	// Position of PER3 field.
	RTC_MODE0_INTFLAG_PER3_Pos = 0x3
	// Bit mask of PER3 field.
	RTC_MODE0_INTFLAG_PER3_Msk = 0x8
	// Bit PER3.
	RTC_MODE0_INTFLAG_PER3 = 0x8
	// Position of PER4 field.
	RTC_MODE0_INTFLAG_PER4_Pos = 0x4
	// Bit mask of PER4 field.
	RTC_MODE0_INTFLAG_PER4_Msk = 0x10
	// Bit PER4.
	RTC_MODE0_INTFLAG_PER4 = 0x10
	// Position of PER5 field.
	RTC_MODE0_INTFLAG_PER5_Pos = 0x5
	// Bit mask of PER5 field.
	RTC_MODE0_INTFLAG_PER5_Msk = 0x20
	// Bit PER5.
	RTC_MODE0_INTFLAG_PER5 = 0x20
	// Position of PER6 field.
	RTC_MODE0_INTFLAG_PER6_Pos = 0x6
	// Bit mask of PER6 field.
	RTC_MODE0_INTFLAG_PER6_Msk = 0x40
	// Bit PER6.
	RTC_MODE0_INTFLAG_PER6 = 0x40
	// Position of PER7 field.
	RTC_MODE0_INTFLAG_PER7_Pos = 0x7
	// Bit mask of PER7 field.
	RTC_MODE0_INTFLAG_PER7_Msk = 0x80
	// Bit PER7.
	RTC_MODE0_INTFLAG_PER7 = 0x80
	// Position of CMP0 field.
	RTC_MODE0_INTFLAG_CMP0_Pos = 0x8
	// Bit mask of CMP0 field.
	RTC_MODE0_INTFLAG_CMP0_Msk = 0x100
	// Bit CMP0.
	RTC_MODE0_INTFLAG_CMP0 = 0x100
	// Position of TAMPER field.
	RTC_MODE0_INTFLAG_TAMPER_Pos = 0xe
	// Bit mask of TAMPER field.
	RTC_MODE0_INTFLAG_TAMPER_Msk = 0x4000
	// Bit TAMPER.
	RTC_MODE0_INTFLAG_TAMPER = 0x4000
	// Position of OVF field.
	RTC_MODE0_INTFLAG_OVF_Pos = 0xf
	// Bit mask of OVF field.
	RTC_MODE0_INTFLAG_OVF_Msk = 0x8000
	// Bit OVF.
	RTC_MODE0_INTFLAG_OVF = 0x8000

	// DBGCTRL: Debug Control
	// Position of DBGRUN field.
	RTC_MODE0_DBGCTRL_DBGRUN_Pos = 0x0
	// Bit mask of DBGRUN field.
	RTC_MODE0_DBGCTRL_DBGRUN_Msk = 0x1
	// Bit DBGRUN.
	RTC_MODE0_DBGCTRL_DBGRUN = 0x1

	// SYNCBUSY: MODE0 Synchronization Busy Status
	// Position of SWRST field.
	RTC_MODE0_SYNCBUSY_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	RTC_MODE0_SYNCBUSY_SWRST_Msk = 0x1
	// Bit SWRST.
	RTC_MODE0_SYNCBUSY_SWRST = 0x1
	// Position of ENABLE field.
	RTC_MODE0_SYNCBUSY_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	RTC_MODE0_SYNCBUSY_ENABLE_Msk = 0x2
	// Bit ENABLE.
	RTC_MODE0_SYNCBUSY_ENABLE = 0x2
	// Position of FREQCORR field.
	RTC_MODE0_SYNCBUSY_FREQCORR_Pos = 0x2
	// Bit mask of FREQCORR field.
	RTC_MODE0_SYNCBUSY_FREQCORR_Msk = 0x4
	// Bit FREQCORR.
	RTC_MODE0_SYNCBUSY_FREQCORR = 0x4
	// Position of COUNT field.
	RTC_MODE0_SYNCBUSY_COUNT_Pos = 0x3
	// Bit mask of COUNT field.
	RTC_MODE0_SYNCBUSY_COUNT_Msk = 0x8
	// Bit COUNT.
	RTC_MODE0_SYNCBUSY_COUNT = 0x8
	// Position of COMP0 field.
	RTC_MODE0_SYNCBUSY_COMP0_Pos = 0x5
	// Bit mask of COMP0 field.
	RTC_MODE0_SYNCBUSY_COMP0_Msk = 0x20
	// Bit COMP0.
	RTC_MODE0_SYNCBUSY_COMP0 = 0x20
	// Position of COUNTSYNC field.
	RTC_MODE0_SYNCBUSY_COUNTSYNC_Pos = 0xf
	// Bit mask of COUNTSYNC field.
	RTC_MODE0_SYNCBUSY_COUNTSYNC_Msk = 0x8000
	// Bit COUNTSYNC.
	RTC_MODE0_SYNCBUSY_COUNTSYNC = 0x8000
	// Position of GP0 field.
	RTC_MODE0_SYNCBUSY_GP0_Pos = 0x10
	// Bit mask of GP0 field.
	RTC_MODE0_SYNCBUSY_GP0_Msk = 0x10000
	// Bit GP0.
	RTC_MODE0_SYNCBUSY_GP0 = 0x10000
	// Position of GP1 field.
	RTC_MODE0_SYNCBUSY_GP1_Pos = 0x11
	// Bit mask of GP1 field.
	RTC_MODE0_SYNCBUSY_GP1_Msk = 0x20000
	// Bit GP1.
	RTC_MODE0_SYNCBUSY_GP1 = 0x20000

	// FREQCORR: Frequency Correction
	// Position of VALUE field.
	RTC_MODE0_FREQCORR_VALUE_Pos = 0x0
	// Bit mask of VALUE field.
	RTC_MODE0_FREQCORR_VALUE_Msk = 0x7f
	// Position of SIGN field.
	RTC_MODE0_FREQCORR_SIGN_Pos = 0x7
	// Bit mask of SIGN field.
	RTC_MODE0_FREQCORR_SIGN_Msk = 0x80
	// Bit SIGN.
	RTC_MODE0_FREQCORR_SIGN = 0x80

	// COUNT: MODE0 Counter Value
	// Position of COUNT field.
	RTC_MODE0_COUNT_COUNT_Pos = 0x0
	// Bit mask of COUNT field.
	RTC_MODE0_COUNT_COUNT_Msk = 0xffffffff

	// COMP: MODE0 Compare n Value
	// Position of COMP field.
	RTC_MODE0_COMP_COMP_Pos = 0x0
	// Bit mask of COMP field.
	RTC_MODE0_COMP_COMP_Msk = 0xffffffff

	// GP: General Purpose
	// Position of GP field.
	RTC_MODE0_GP_GP_Pos = 0x0
	// Bit mask of GP field.
	RTC_MODE0_GP_GP_Msk = 0xffffffff

	// TAMPCTRL: Tamper Control
	// Position of IN0ACT field.
	RTC_MODE0_TAMPCTRL_IN0ACT_Pos = 0x0
	// Bit mask of IN0ACT field.
	RTC_MODE0_TAMPCTRL_IN0ACT_Msk = 0x3
	// Off (Disabled)
	RTC_MODE0_TAMPCTRL_IN0ACT_OFF = 0x0
	// Wake and set Tamper flag
	RTC_MODE0_TAMPCTRL_IN0ACT_WAKE = 0x1
	// Capture timestamp and set Tamper flag
	RTC_MODE0_TAMPCTRL_IN0ACT_CAPTURE = 0x2
	// Compare IN0 to OUT. When a mismatch occurs, capture timestamp and set Tamper flag
	RTC_MODE0_TAMPCTRL_IN0ACT_ACTL = 0x3
	// Position of IN1ACT field.
	RTC_MODE0_TAMPCTRL_IN1ACT_Pos = 0x2
	// Bit mask of IN1ACT field.
	RTC_MODE0_TAMPCTRL_IN1ACT_Msk = 0xc
	// Off (Disabled)
	RTC_MODE0_TAMPCTRL_IN1ACT_OFF = 0x0
	// Wake and set Tamper flag
	RTC_MODE0_TAMPCTRL_IN1ACT_WAKE = 0x1
	// Capture timestamp and set Tamper flag
	RTC_MODE0_TAMPCTRL_IN1ACT_CAPTURE = 0x2
	// Compare IN1 to OUT. When a mismatch occurs, capture timestamp and set Tamper flag
	RTC_MODE0_TAMPCTRL_IN1ACT_ACTL = 0x3
	// Position of IN2ACT field.
	RTC_MODE0_TAMPCTRL_IN2ACT_Pos = 0x4
	// Bit mask of IN2ACT field.
	RTC_MODE0_TAMPCTRL_IN2ACT_Msk = 0x30
	// Off (Disabled)
	RTC_MODE0_TAMPCTRL_IN2ACT_OFF = 0x0
	// Wake and set Tamper flag
	RTC_MODE0_TAMPCTRL_IN2ACT_WAKE = 0x1
	// Capture timestamp and set Tamper flag
	RTC_MODE0_TAMPCTRL_IN2ACT_CAPTURE = 0x2
	// Compare IN2 to OUT. When a mismatch occurs, capture timestamp and set Tamper flag
	RTC_MODE0_TAMPCTRL_IN2ACT_ACTL = 0x3
	// Position of IN3ACT field.
	RTC_MODE0_TAMPCTRL_IN3ACT_Pos = 0x6
	// Bit mask of IN3ACT field.
	RTC_MODE0_TAMPCTRL_IN3ACT_Msk = 0xc0
	// Off (Disabled)
	RTC_MODE0_TAMPCTRL_IN3ACT_OFF = 0x0
	// Wake and set Tamper flag
	RTC_MODE0_TAMPCTRL_IN3ACT_WAKE = 0x1
	// Capture timestamp and set Tamper flag
	RTC_MODE0_TAMPCTRL_IN3ACT_CAPTURE = 0x2
	// Compare IN3 to OUT. When a mismatch occurs, capture timestamp and set Tamper flag
	RTC_MODE0_TAMPCTRL_IN3ACT_ACTL = 0x3
	// Position of TAMLVL0 field.
	RTC_MODE0_TAMPCTRL_TAMLVL0_Pos = 0x10
	// Bit mask of TAMLVL0 field.
	RTC_MODE0_TAMPCTRL_TAMLVL0_Msk = 0x10000
	// Bit TAMLVL0.
	RTC_MODE0_TAMPCTRL_TAMLVL0 = 0x10000
	// Position of TAMLVL1 field.
	RTC_MODE0_TAMPCTRL_TAMLVL1_Pos = 0x11
	// Bit mask of TAMLVL1 field.
	RTC_MODE0_TAMPCTRL_TAMLVL1_Msk = 0x20000
	// Bit TAMLVL1.
	RTC_MODE0_TAMPCTRL_TAMLVL1 = 0x20000
	// Position of TAMLVL2 field.
	RTC_MODE0_TAMPCTRL_TAMLVL2_Pos = 0x12
	// Bit mask of TAMLVL2 field.
	RTC_MODE0_TAMPCTRL_TAMLVL2_Msk = 0x40000
	// Bit TAMLVL2.
	RTC_MODE0_TAMPCTRL_TAMLVL2 = 0x40000
	// Position of TAMLVL3 field.
	RTC_MODE0_TAMPCTRL_TAMLVL3_Pos = 0x13
	// Bit mask of TAMLVL3 field.
	RTC_MODE0_TAMPCTRL_TAMLVL3_Msk = 0x80000
	// Bit TAMLVL3.
	RTC_MODE0_TAMPCTRL_TAMLVL3 = 0x80000
	// Position of DEBNC0 field.
	RTC_MODE0_TAMPCTRL_DEBNC0_Pos = 0x18
	// Bit mask of DEBNC0 field.
	RTC_MODE0_TAMPCTRL_DEBNC0_Msk = 0x1000000
	// Bit DEBNC0.
	RTC_MODE0_TAMPCTRL_DEBNC0 = 0x1000000
	// Position of DEBNC1 field.
	RTC_MODE0_TAMPCTRL_DEBNC1_Pos = 0x19
	// Bit mask of DEBNC1 field.
	RTC_MODE0_TAMPCTRL_DEBNC1_Msk = 0x2000000
	// Bit DEBNC1.
	RTC_MODE0_TAMPCTRL_DEBNC1 = 0x2000000
	// Position of DEBNC2 field.
	RTC_MODE0_TAMPCTRL_DEBNC2_Pos = 0x1a
	// Bit mask of DEBNC2 field.
	RTC_MODE0_TAMPCTRL_DEBNC2_Msk = 0x4000000
	// Bit DEBNC2.
	RTC_MODE0_TAMPCTRL_DEBNC2 = 0x4000000
	// Position of DEBNC3 field.
	RTC_MODE0_TAMPCTRL_DEBNC3_Pos = 0x1b
	// Bit mask of DEBNC3 field.
	RTC_MODE0_TAMPCTRL_DEBNC3_Msk = 0x8000000
	// Bit DEBNC3.
	RTC_MODE0_TAMPCTRL_DEBNC3 = 0x8000000

	// TIMESTAMP: MODE0 Timestamp
	// Position of COUNT field.
	RTC_MODE0_TIMESTAMP_COUNT_Pos = 0x0
	// Bit mask of COUNT field.
	RTC_MODE0_TIMESTAMP_COUNT_Msk = 0xffffffff

	// TAMPID: Tamper ID
	// Position of TAMPID0 field.
	RTC_MODE0_TAMPID_TAMPID0_Pos = 0x0
	// Bit mask of TAMPID0 field.
	RTC_MODE0_TAMPID_TAMPID0_Msk = 0x1
	// Bit TAMPID0.
	RTC_MODE0_TAMPID_TAMPID0 = 0x1
	// Position of TAMPID1 field.
	RTC_MODE0_TAMPID_TAMPID1_Pos = 0x1
	// Bit mask of TAMPID1 field.
	RTC_MODE0_TAMPID_TAMPID1_Msk = 0x2
	// Bit TAMPID1.
	RTC_MODE0_TAMPID_TAMPID1 = 0x2
	// Position of TAMPID2 field.
	RTC_MODE0_TAMPID_TAMPID2_Pos = 0x2
	// Bit mask of TAMPID2 field.
	RTC_MODE0_TAMPID_TAMPID2_Msk = 0x4
	// Bit TAMPID2.
	RTC_MODE0_TAMPID_TAMPID2 = 0x4
	// Position of TAMPID3 field.
	RTC_MODE0_TAMPID_TAMPID3_Pos = 0x3
	// Bit mask of TAMPID3 field.
	RTC_MODE0_TAMPID_TAMPID3_Msk = 0x8
	// Bit TAMPID3.
	RTC_MODE0_TAMPID_TAMPID3 = 0x8
	// Position of TAMPEVT field.
	RTC_MODE0_TAMPID_TAMPEVT_Pos = 0x1f
	// Bit mask of TAMPEVT field.
	RTC_MODE0_TAMPID_TAMPEVT_Msk = 0x80000000
	// Bit TAMPEVT.
	RTC_MODE0_TAMPID_TAMPEVT = 0x80000000

	// TAMPCTRLB: Tamper Control B
	// Position of ALSI0 field.
	RTC_MODE0_TAMPCTRLB_ALSI0_Pos = 0x0
	// Bit mask of ALSI0 field.
	RTC_MODE0_TAMPCTRLB_ALSI0_Msk = 0x1
	// Bit ALSI0.
	RTC_MODE0_TAMPCTRLB_ALSI0 = 0x1
	// Position of ALSI1 field.
	RTC_MODE0_TAMPCTRLB_ALSI1_Pos = 0x1
	// Bit mask of ALSI1 field.
	RTC_MODE0_TAMPCTRLB_ALSI1_Msk = 0x2
	// Bit ALSI1.
	RTC_MODE0_TAMPCTRLB_ALSI1 = 0x2
	// Position of ALSI2 field.
	RTC_MODE0_TAMPCTRLB_ALSI2_Pos = 0x2
	// Bit mask of ALSI2 field.
	RTC_MODE0_TAMPCTRLB_ALSI2_Msk = 0x4
	// Bit ALSI2.
	RTC_MODE0_TAMPCTRLB_ALSI2 = 0x4
	// Position of ALSI3 field.
	RTC_MODE0_TAMPCTRLB_ALSI3_Pos = 0x3
	// Bit mask of ALSI3 field.
	RTC_MODE0_TAMPCTRLB_ALSI3_Msk = 0x8
	// Bit ALSI3.
	RTC_MODE0_TAMPCTRLB_ALSI3 = 0x8
)

// Constants for RTC_MODE1: Real-Time Counter - MODE1
const (
	// CTRLA: MODE1 Control A
	// Position of SWRST field.
	RTC_MODE1_CTRLA_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	RTC_MODE1_CTRLA_SWRST_Msk = 0x1
	// Bit SWRST.
	RTC_MODE1_CTRLA_SWRST = 0x1
	// Position of ENABLE field.
	RTC_MODE1_CTRLA_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	RTC_MODE1_CTRLA_ENABLE_Msk = 0x2
	// Bit ENABLE.
	RTC_MODE1_CTRLA_ENABLE = 0x2
	// Position of MODE field.
	RTC_MODE1_CTRLA_MODE_Pos = 0x2
	// Bit mask of MODE field.
	RTC_MODE1_CTRLA_MODE_Msk = 0xc
	// Mode 0: 32-bit Counter
	RTC_MODE1_CTRLA_MODE_COUNT32 = 0x0
	// Mode 1: 16-bit Counter
	RTC_MODE1_CTRLA_MODE_COUNT16 = 0x1
	// Mode 2: Clock/Calendar
	RTC_MODE1_CTRLA_MODE_CLOCK = 0x2
	// Position of PRESCALER field.
	RTC_MODE1_CTRLA_PRESCALER_Pos = 0x8
	// Bit mask of PRESCALER field.
	RTC_MODE1_CTRLA_PRESCALER_Msk = 0xf00
	// CLK_RTC_CNT = GCLK_RTC/1
	RTC_MODE1_CTRLA_PRESCALER_OFF = 0x0
	// CLK_RTC_CNT = GCLK_RTC/1
	RTC_MODE1_CTRLA_PRESCALER_DIV1 = 0x1
	// CLK_RTC_CNT = GCLK_RTC/2
	RTC_MODE1_CTRLA_PRESCALER_DIV2 = 0x2
	// CLK_RTC_CNT = GCLK_RTC/4
	RTC_MODE1_CTRLA_PRESCALER_DIV4 = 0x3
	// CLK_RTC_CNT = GCLK_RTC/8
	RTC_MODE1_CTRLA_PRESCALER_DIV8 = 0x4
	// CLK_RTC_CNT = GCLK_RTC/16
	RTC_MODE1_CTRLA_PRESCALER_DIV16 = 0x5
	// CLK_RTC_CNT = GCLK_RTC/32
	RTC_MODE1_CTRLA_PRESCALER_DIV32 = 0x6
	// CLK_RTC_CNT = GCLK_RTC/64
	RTC_MODE1_CTRLA_PRESCALER_DIV64 = 0x7
	// CLK_RTC_CNT = GCLK_RTC/128
	RTC_MODE1_CTRLA_PRESCALER_DIV128 = 0x8
	// CLK_RTC_CNT = GCLK_RTC/256
	RTC_MODE1_CTRLA_PRESCALER_DIV256 = 0x9
	// CLK_RTC_CNT = GCLK_RTC/512
	RTC_MODE1_CTRLA_PRESCALER_DIV512 = 0xa
	// CLK_RTC_CNT = GCLK_RTC/1024
	RTC_MODE1_CTRLA_PRESCALER_DIV1024 = 0xb
	// Position of GPTRST field.
	RTC_MODE1_CTRLA_GPTRST_Pos = 0xe
	// Bit mask of GPTRST field.
	RTC_MODE1_CTRLA_GPTRST_Msk = 0x4000
	// Bit GPTRST.
	RTC_MODE1_CTRLA_GPTRST = 0x4000
	// Position of COUNTSYNC field.
	RTC_MODE1_CTRLA_COUNTSYNC_Pos = 0xf
	// Bit mask of COUNTSYNC field.
	RTC_MODE1_CTRLA_COUNTSYNC_Msk = 0x8000
	// Bit COUNTSYNC.
	RTC_MODE1_CTRLA_COUNTSYNC = 0x8000

	// CTRLB: MODE1 Control B
	// Position of GP0EN field.
	RTC_MODE1_CTRLB_GP0EN_Pos = 0x0
	// Bit mask of GP0EN field.
	RTC_MODE1_CTRLB_GP0EN_Msk = 0x1
	// Bit GP0EN.
	RTC_MODE1_CTRLB_GP0EN = 0x1
	// Position of DEBMAJ field.
	RTC_MODE1_CTRLB_DEBMAJ_Pos = 0x4
	// Bit mask of DEBMAJ field.
	RTC_MODE1_CTRLB_DEBMAJ_Msk = 0x10
	// Bit DEBMAJ.
	RTC_MODE1_CTRLB_DEBMAJ = 0x10
	// Position of DEBASYNC field.
	RTC_MODE1_CTRLB_DEBASYNC_Pos = 0x5
	// Bit mask of DEBASYNC field.
	RTC_MODE1_CTRLB_DEBASYNC_Msk = 0x20
	// Bit DEBASYNC.
	RTC_MODE1_CTRLB_DEBASYNC = 0x20
	// Position of RTCOUT field.
	RTC_MODE1_CTRLB_RTCOUT_Pos = 0x6
	// Bit mask of RTCOUT field.
	RTC_MODE1_CTRLB_RTCOUT_Msk = 0x40
	// Bit RTCOUT.
	RTC_MODE1_CTRLB_RTCOUT = 0x40
	// Position of DMAEN field.
	RTC_MODE1_CTRLB_DMAEN_Pos = 0x7
	// Bit mask of DMAEN field.
	RTC_MODE1_CTRLB_DMAEN_Msk = 0x80
	// Bit DMAEN.
	RTC_MODE1_CTRLB_DMAEN = 0x80
	// Position of DEBF field.
	RTC_MODE1_CTRLB_DEBF_Pos = 0x8
	// Bit mask of DEBF field.
	RTC_MODE1_CTRLB_DEBF_Msk = 0x700
	// CLK_RTC_DEB = CLK_RTC/2
	RTC_MODE1_CTRLB_DEBF_DIV2 = 0x0
	// CLK_RTC_DEB = CLK_RTC/4
	RTC_MODE1_CTRLB_DEBF_DIV4 = 0x1
	// CLK_RTC_DEB = CLK_RTC/8
	RTC_MODE1_CTRLB_DEBF_DIV8 = 0x2
	// CLK_RTC_DEB = CLK_RTC/16
	RTC_MODE1_CTRLB_DEBF_DIV16 = 0x3
	// CLK_RTC_DEB = CLK_RTC/32
	RTC_MODE1_CTRLB_DEBF_DIV32 = 0x4
	// CLK_RTC_DEB = CLK_RTC/64
	RTC_MODE1_CTRLB_DEBF_DIV64 = 0x5
	// CLK_RTC_DEB = CLK_RTC/128
	RTC_MODE1_CTRLB_DEBF_DIV128 = 0x6
	// CLK_RTC_DEB = CLK_RTC/256
	RTC_MODE1_CTRLB_DEBF_DIV256 = 0x7
	// Position of ACTF field.
	RTC_MODE1_CTRLB_ACTF_Pos = 0xc
	// Bit mask of ACTF field.
	RTC_MODE1_CTRLB_ACTF_Msk = 0x7000
	// CLK_RTC_OUT = CLK_RTC/2
	RTC_MODE1_CTRLB_ACTF_DIV2 = 0x0
	// CLK_RTC_OUT = CLK_RTC/4
	RTC_MODE1_CTRLB_ACTF_DIV4 = 0x1
	// CLK_RTC_OUT = CLK_RTC/8
	RTC_MODE1_CTRLB_ACTF_DIV8 = 0x2
	// CLK_RTC_OUT = CLK_RTC/16
	RTC_MODE1_CTRLB_ACTF_DIV16 = 0x3
	// CLK_RTC_OUT = CLK_RTC/32
	RTC_MODE1_CTRLB_ACTF_DIV32 = 0x4
	// CLK_RTC_OUT = CLK_RTC/64
	RTC_MODE1_CTRLB_ACTF_DIV64 = 0x5
	// CLK_RTC_OUT = CLK_RTC/128
	RTC_MODE1_CTRLB_ACTF_DIV128 = 0x6
	// CLK_RTC_OUT = CLK_RTC/256
	RTC_MODE1_CTRLB_ACTF_DIV256 = 0x7
	// Position of SEPTO field.
	RTC_MODE1_CTRLB_SEPTO_Pos = 0xf
	// Bit mask of SEPTO field.
	RTC_MODE1_CTRLB_SEPTO_Msk = 0x8000
	// Bit SEPTO.
	RTC_MODE1_CTRLB_SEPTO = 0x8000

	// EVCTRL: MODE1 Event Control
	// Position of PEREO0 field.
	RTC_MODE1_EVCTRL_PEREO0_Pos = 0x0
	// Bit mask of PEREO0 field.
	RTC_MODE1_EVCTRL_PEREO0_Msk = 0x1
	// Bit PEREO0.
	RTC_MODE1_EVCTRL_PEREO0 = 0x1
	// Position of PEREO1 field.
	RTC_MODE1_EVCTRL_PEREO1_Pos = 0x1
	// Bit mask of PEREO1 field.
	RTC_MODE1_EVCTRL_PEREO1_Msk = 0x2
	// Bit PEREO1.
	RTC_MODE1_EVCTRL_PEREO1 = 0x2
	// Position of PEREO2 field.
	RTC_MODE1_EVCTRL_PEREO2_Pos = 0x2
	// Bit mask of PEREO2 field.
	RTC_MODE1_EVCTRL_PEREO2_Msk = 0x4
	// Bit PEREO2.
	RTC_MODE1_EVCTRL_PEREO2 = 0x4
	// Position of PEREO3 field.
	RTC_MODE1_EVCTRL_PEREO3_Pos = 0x3
	// Bit mask of PEREO3 field.
	RTC_MODE1_EVCTRL_PEREO3_Msk = 0x8
	// Bit PEREO3.
	RTC_MODE1_EVCTRL_PEREO3 = 0x8
	// Position of PEREO4 field.
	RTC_MODE1_EVCTRL_PEREO4_Pos = 0x4
	// Bit mask of PEREO4 field.
	RTC_MODE1_EVCTRL_PEREO4_Msk = 0x10
	// Bit PEREO4.
	RTC_MODE1_EVCTRL_PEREO4 = 0x10
	// Position of PEREO5 field.
	RTC_MODE1_EVCTRL_PEREO5_Pos = 0x5
	// Bit mask of PEREO5 field.
	RTC_MODE1_EVCTRL_PEREO5_Msk = 0x20
	// Bit PEREO5.
	RTC_MODE1_EVCTRL_PEREO5 = 0x20
	// Position of PEREO6 field.
	RTC_MODE1_EVCTRL_PEREO6_Pos = 0x6
	// Bit mask of PEREO6 field.
	RTC_MODE1_EVCTRL_PEREO6_Msk = 0x40
	// Bit PEREO6.
	RTC_MODE1_EVCTRL_PEREO6 = 0x40
	// Position of PEREO7 field.
	RTC_MODE1_EVCTRL_PEREO7_Pos = 0x7
	// Bit mask of PEREO7 field.
	RTC_MODE1_EVCTRL_PEREO7_Msk = 0x80
	// Bit PEREO7.
	RTC_MODE1_EVCTRL_PEREO7 = 0x80
	// Position of CMPEO0 field.
	RTC_MODE1_EVCTRL_CMPEO0_Pos = 0x8
	// Bit mask of CMPEO0 field.
	RTC_MODE1_EVCTRL_CMPEO0_Msk = 0x100
	// Bit CMPEO0.
	RTC_MODE1_EVCTRL_CMPEO0 = 0x100
	// Position of CMPEO1 field.
	RTC_MODE1_EVCTRL_CMPEO1_Pos = 0x9
	// Bit mask of CMPEO1 field.
	RTC_MODE1_EVCTRL_CMPEO1_Msk = 0x200
	// Bit CMPEO1.
	RTC_MODE1_EVCTRL_CMPEO1 = 0x200
	// Position of TAMPEREO field.
	RTC_MODE1_EVCTRL_TAMPEREO_Pos = 0xe
	// Bit mask of TAMPEREO field.
	RTC_MODE1_EVCTRL_TAMPEREO_Msk = 0x4000
	// Bit TAMPEREO.
	RTC_MODE1_EVCTRL_TAMPEREO = 0x4000
	// Position of OVFEO field.
	RTC_MODE1_EVCTRL_OVFEO_Pos = 0xf
	// Bit mask of OVFEO field.
	RTC_MODE1_EVCTRL_OVFEO_Msk = 0x8000
	// Bit OVFEO.
	RTC_MODE1_EVCTRL_OVFEO = 0x8000
	// Position of TAMPEVEI field.
	RTC_MODE1_EVCTRL_TAMPEVEI_Pos = 0x10
	// Bit mask of TAMPEVEI field.
	RTC_MODE1_EVCTRL_TAMPEVEI_Msk = 0x10000
	// Bit TAMPEVEI.
	RTC_MODE1_EVCTRL_TAMPEVEI = 0x10000
	// Position of PERDEO field.
	RTC_MODE1_EVCTRL_PERDEO_Pos = 0x18
	// Bit mask of PERDEO field.
	RTC_MODE1_EVCTRL_PERDEO_Msk = 0x1000000
	// Bit PERDEO.
	RTC_MODE1_EVCTRL_PERDEO = 0x1000000

	// INTENCLR: MODE1 Interrupt Enable Clear
	// Position of PER0 field.
	RTC_MODE1_INTENCLR_PER0_Pos = 0x0
	// Bit mask of PER0 field.
	RTC_MODE1_INTENCLR_PER0_Msk = 0x1
	// Bit PER0.
	RTC_MODE1_INTENCLR_PER0 = 0x1
	// Position of PER1 field.
	RTC_MODE1_INTENCLR_PER1_Pos = 0x1
	// Bit mask of PER1 field.
	RTC_MODE1_INTENCLR_PER1_Msk = 0x2
	// Bit PER1.
	RTC_MODE1_INTENCLR_PER1 = 0x2
	// Position of PER2 field.
	RTC_MODE1_INTENCLR_PER2_Pos = 0x2
	// Bit mask of PER2 field.
	RTC_MODE1_INTENCLR_PER2_Msk = 0x4
	// Bit PER2.
	RTC_MODE1_INTENCLR_PER2 = 0x4
	// Position of PER3 field.
	RTC_MODE1_INTENCLR_PER3_Pos = 0x3
	// Bit mask of PER3 field.
	RTC_MODE1_INTENCLR_PER3_Msk = 0x8
	// Bit PER3.
	RTC_MODE1_INTENCLR_PER3 = 0x8
	// Position of PER4 field.
	RTC_MODE1_INTENCLR_PER4_Pos = 0x4
	// Bit mask of PER4 field.
	RTC_MODE1_INTENCLR_PER4_Msk = 0x10
	// Bit PER4.
	RTC_MODE1_INTENCLR_PER4 = 0x10
	// Position of PER5 field.
	RTC_MODE1_INTENCLR_PER5_Pos = 0x5
	// Bit mask of PER5 field.
	RTC_MODE1_INTENCLR_PER5_Msk = 0x20
	// Bit PER5.
	RTC_MODE1_INTENCLR_PER5 = 0x20
	// Position of PER6 field.
	RTC_MODE1_INTENCLR_PER6_Pos = 0x6
	// Bit mask of PER6 field.
	RTC_MODE1_INTENCLR_PER6_Msk = 0x40
	// Bit PER6.
	RTC_MODE1_INTENCLR_PER6 = 0x40
	// Position of PER7 field.
	RTC_MODE1_INTENCLR_PER7_Pos = 0x7
	// Bit mask of PER7 field.
	RTC_MODE1_INTENCLR_PER7_Msk = 0x80
	// Bit PER7.
	RTC_MODE1_INTENCLR_PER7 = 0x80
	// Position of CMP0 field.
	RTC_MODE1_INTENCLR_CMP0_Pos = 0x8
	// Bit mask of CMP0 field.
	RTC_MODE1_INTENCLR_CMP0_Msk = 0x100
	// Bit CMP0.
	RTC_MODE1_INTENCLR_CMP0 = 0x100
	// Position of CMP1 field.
	RTC_MODE1_INTENCLR_CMP1_Pos = 0x9
	// Bit mask of CMP1 field.
	RTC_MODE1_INTENCLR_CMP1_Msk = 0x200
	// Bit CMP1.
	RTC_MODE1_INTENCLR_CMP1 = 0x200
	// Position of TAMPER field.
	RTC_MODE1_INTENCLR_TAMPER_Pos = 0xe
	// Bit mask of TAMPER field.
	RTC_MODE1_INTENCLR_TAMPER_Msk = 0x4000
	// Bit TAMPER.
	RTC_MODE1_INTENCLR_TAMPER = 0x4000
	// Position of OVF field.
	RTC_MODE1_INTENCLR_OVF_Pos = 0xf
	// Bit mask of OVF field.
	RTC_MODE1_INTENCLR_OVF_Msk = 0x8000
	// Bit OVF.
	RTC_MODE1_INTENCLR_OVF = 0x8000

	// INTENSET: MODE1 Interrupt Enable Set
	// Position of PER0 field.
	RTC_MODE1_INTENSET_PER0_Pos = 0x0
	// Bit mask of PER0 field.
	RTC_MODE1_INTENSET_PER0_Msk = 0x1
	// Bit PER0.
	RTC_MODE1_INTENSET_PER0 = 0x1
	// Position of PER1 field.
	RTC_MODE1_INTENSET_PER1_Pos = 0x1
	// Bit mask of PER1 field.
	RTC_MODE1_INTENSET_PER1_Msk = 0x2
	// Bit PER1.
	RTC_MODE1_INTENSET_PER1 = 0x2
	// Position of PER2 field.
	RTC_MODE1_INTENSET_PER2_Pos = 0x2
	// Bit mask of PER2 field.
	RTC_MODE1_INTENSET_PER2_Msk = 0x4
	// Bit PER2.
	RTC_MODE1_INTENSET_PER2 = 0x4
	// Position of PER3 field.
	RTC_MODE1_INTENSET_PER3_Pos = 0x3
	// Bit mask of PER3 field.
	RTC_MODE1_INTENSET_PER3_Msk = 0x8
	// Bit PER3.
	RTC_MODE1_INTENSET_PER3 = 0x8
	// Position of PER4 field.
	RTC_MODE1_INTENSET_PER4_Pos = 0x4
	// Bit mask of PER4 field.
	RTC_MODE1_INTENSET_PER4_Msk = 0x10
	// Bit PER4.
	RTC_MODE1_INTENSET_PER4 = 0x10
	// Position of PER5 field.
	RTC_MODE1_INTENSET_PER5_Pos = 0x5
	// Bit mask of PER5 field.
	RTC_MODE1_INTENSET_PER5_Msk = 0x20
	// Bit PER5.
	RTC_MODE1_INTENSET_PER5 = 0x20
	// Position of PER6 field.
	RTC_MODE1_INTENSET_PER6_Pos = 0x6
	// Bit mask of PER6 field.
	RTC_MODE1_INTENSET_PER6_Msk = 0x40
	// Bit PER6.
	RTC_MODE1_INTENSET_PER6 = 0x40
	// Position of PER7 field.
	RTC_MODE1_INTENSET_PER7_Pos = 0x7
	// Bit mask of PER7 field.
	RTC_MODE1_INTENSET_PER7_Msk = 0x80
	// Bit PER7.
	RTC_MODE1_INTENSET_PER7 = 0x80
	// Position of CMP0 field.
	RTC_MODE1_INTENSET_CMP0_Pos = 0x8
	// Bit mask of CMP0 field.
	RTC_MODE1_INTENSET_CMP0_Msk = 0x100
	// Bit CMP0.
	RTC_MODE1_INTENSET_CMP0 = 0x100
	// Position of CMP1 field.
	RTC_MODE1_INTENSET_CMP1_Pos = 0x9
	// Bit mask of CMP1 field.
	RTC_MODE1_INTENSET_CMP1_Msk = 0x200
	// Bit CMP1.
	RTC_MODE1_INTENSET_CMP1 = 0x200
	// Position of TAMPER field.
	RTC_MODE1_INTENSET_TAMPER_Pos = 0xe
	// Bit mask of TAMPER field.
	RTC_MODE1_INTENSET_TAMPER_Msk = 0x4000
	// Bit TAMPER.
	RTC_MODE1_INTENSET_TAMPER = 0x4000
	// Position of OVF field.
	RTC_MODE1_INTENSET_OVF_Pos = 0xf
	// Bit mask of OVF field.
	RTC_MODE1_INTENSET_OVF_Msk = 0x8000
	// Bit OVF.
	RTC_MODE1_INTENSET_OVF = 0x8000

	// INTFLAG: MODE1 Interrupt Flag Status and Clear
	// Position of PER0 field.
	RTC_MODE1_INTFLAG_PER0_Pos = 0x0
	// Bit mask of PER0 field.
	RTC_MODE1_INTFLAG_PER0_Msk = 0x1
	// Bit PER0.
	RTC_MODE1_INTFLAG_PER0 = 0x1
	// Position of PER1 field.
	RTC_MODE1_INTFLAG_PER1_Pos = 0x1
	// Bit mask of PER1 field.
	RTC_MODE1_INTFLAG_PER1_Msk = 0x2
	// Bit PER1.
	RTC_MODE1_INTFLAG_PER1 = 0x2
	// Position of PER2 field.
	RTC_MODE1_INTFLAG_PER2_Pos = 0x2
	// Bit mask of PER2 field.
	RTC_MODE1_INTFLAG_PER2_Msk = 0x4
	// Bit PER2.
	RTC_MODE1_INTFLAG_PER2 = 0x4
	// Position of PER3 field.
	RTC_MODE1_INTFLAG_PER3_Pos = 0x3
	// Bit mask of PER3 field.
	RTC_MODE1_INTFLAG_PER3_Msk = 0x8
	// Bit PER3.
	RTC_MODE1_INTFLAG_PER3 = 0x8
	// Position of PER4 field.
	RTC_MODE1_INTFLAG_PER4_Pos = 0x4
	// Bit mask of PER4 field.
	RTC_MODE1_INTFLAG_PER4_Msk = 0x10
	// Bit PER4.
	RTC_MODE1_INTFLAG_PER4 = 0x10
	// Position of PER5 field.
	RTC_MODE1_INTFLAG_PER5_Pos = 0x5
	// Bit mask of PER5 field.
	RTC_MODE1_INTFLAG_PER5_Msk = 0x20
	// Bit PER5.
	RTC_MODE1_INTFLAG_PER5 = 0x20
	// Position of PER6 field.
	RTC_MODE1_INTFLAG_PER6_Pos = 0x6
	// Bit mask of PER6 field.
	RTC_MODE1_INTFLAG_PER6_Msk = 0x40
	// Bit PER6.
	RTC_MODE1_INTFLAG_PER6 = 0x40
	// Position of PER7 field.
	RTC_MODE1_INTFLAG_PER7_Pos = 0x7
	// Bit mask of PER7 field.
	RTC_MODE1_INTFLAG_PER7_Msk = 0x80
	// Bit PER7.
	RTC_MODE1_INTFLAG_PER7 = 0x80
	// Position of CMP0 field.
	RTC_MODE1_INTFLAG_CMP0_Pos = 0x8
	// Bit mask of CMP0 field.
	RTC_MODE1_INTFLAG_CMP0_Msk = 0x100
	// Bit CMP0.
	RTC_MODE1_INTFLAG_CMP0 = 0x100
	// Position of CMP1 field.
	RTC_MODE1_INTFLAG_CMP1_Pos = 0x9
	// Bit mask of CMP1 field.
	RTC_MODE1_INTFLAG_CMP1_Msk = 0x200
	// Bit CMP1.
	RTC_MODE1_INTFLAG_CMP1 = 0x200
	// Position of TAMPER field.
	RTC_MODE1_INTFLAG_TAMPER_Pos = 0xe
	// Bit mask of TAMPER field.
	RTC_MODE1_INTFLAG_TAMPER_Msk = 0x4000
	// Bit TAMPER.
	RTC_MODE1_INTFLAG_TAMPER = 0x4000
	// Position of OVF field.
	RTC_MODE1_INTFLAG_OVF_Pos = 0xf
	// Bit mask of OVF field.
	RTC_MODE1_INTFLAG_OVF_Msk = 0x8000
	// Bit OVF.
	RTC_MODE1_INTFLAG_OVF = 0x8000

	// DBGCTRL: Debug Control
	// Position of DBGRUN field.
	RTC_MODE1_DBGCTRL_DBGRUN_Pos = 0x0
	// Bit mask of DBGRUN field.
	RTC_MODE1_DBGCTRL_DBGRUN_Msk = 0x1
	// Bit DBGRUN.
	RTC_MODE1_DBGCTRL_DBGRUN = 0x1

	// SYNCBUSY: MODE1 Synchronization Busy Status
	// Position of SWRST field.
	RTC_MODE1_SYNCBUSY_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	RTC_MODE1_SYNCBUSY_SWRST_Msk = 0x1
	// Bit SWRST.
	RTC_MODE1_SYNCBUSY_SWRST = 0x1
	// Position of ENABLE field.
	RTC_MODE1_SYNCBUSY_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	RTC_MODE1_SYNCBUSY_ENABLE_Msk = 0x2
	// Bit ENABLE.
	RTC_MODE1_SYNCBUSY_ENABLE = 0x2
	// Position of FREQCORR field.
	RTC_MODE1_SYNCBUSY_FREQCORR_Pos = 0x2
	// Bit mask of FREQCORR field.
	RTC_MODE1_SYNCBUSY_FREQCORR_Msk = 0x4
	// Bit FREQCORR.
	RTC_MODE1_SYNCBUSY_FREQCORR = 0x4
	// Position of COUNT field.
	RTC_MODE1_SYNCBUSY_COUNT_Pos = 0x3
	// Bit mask of COUNT field.
	RTC_MODE1_SYNCBUSY_COUNT_Msk = 0x8
	// Bit COUNT.
	RTC_MODE1_SYNCBUSY_COUNT = 0x8
	// Position of PER field.
	RTC_MODE1_SYNCBUSY_PER_Pos = 0x4
	// Bit mask of PER field.
	RTC_MODE1_SYNCBUSY_PER_Msk = 0x10
	// Bit PER.
	RTC_MODE1_SYNCBUSY_PER = 0x10
	// Position of COMP0 field.
	RTC_MODE1_SYNCBUSY_COMP0_Pos = 0x5
	// Bit mask of COMP0 field.
	RTC_MODE1_SYNCBUSY_COMP0_Msk = 0x20
	// Bit COMP0.
	RTC_MODE1_SYNCBUSY_COMP0 = 0x20
	// Position of COMP1 field.
	RTC_MODE1_SYNCBUSY_COMP1_Pos = 0x6
	// Bit mask of COMP1 field.
	RTC_MODE1_SYNCBUSY_COMP1_Msk = 0x40
	// Bit COMP1.
	RTC_MODE1_SYNCBUSY_COMP1 = 0x40
	// Position of COUNTSYNC field.
	RTC_MODE1_SYNCBUSY_COUNTSYNC_Pos = 0xf
	// Bit mask of COUNTSYNC field.
	RTC_MODE1_SYNCBUSY_COUNTSYNC_Msk = 0x8000
	// Bit COUNTSYNC.
	RTC_MODE1_SYNCBUSY_COUNTSYNC = 0x8000
	// Position of GP0 field.
	RTC_MODE1_SYNCBUSY_GP0_Pos = 0x10
	// Bit mask of GP0 field.
	RTC_MODE1_SYNCBUSY_GP0_Msk = 0x10000
	// Bit GP0.
	RTC_MODE1_SYNCBUSY_GP0 = 0x10000
	// Position of GP1 field.
	RTC_MODE1_SYNCBUSY_GP1_Pos = 0x11
	// Bit mask of GP1 field.
	RTC_MODE1_SYNCBUSY_GP1_Msk = 0x20000
	// Bit GP1.
	RTC_MODE1_SYNCBUSY_GP1 = 0x20000

	// FREQCORR: Frequency Correction
	// Position of VALUE field.
	RTC_MODE1_FREQCORR_VALUE_Pos = 0x0
	// Bit mask of VALUE field.
	RTC_MODE1_FREQCORR_VALUE_Msk = 0x7f
	// Position of SIGN field.
	RTC_MODE1_FREQCORR_SIGN_Pos = 0x7
	// Bit mask of SIGN field.
	RTC_MODE1_FREQCORR_SIGN_Msk = 0x80
	// Bit SIGN.
	RTC_MODE1_FREQCORR_SIGN = 0x80

	// COUNT: MODE1 Counter Value
	// Position of COUNT field.
	RTC_MODE1_COUNT_COUNT_Pos = 0x0
	// Bit mask of COUNT field.
	RTC_MODE1_COUNT_COUNT_Msk = 0xffff

	// PER: MODE1 Counter Period
	// Position of PER field.
	RTC_MODE1_PER_PER_Pos = 0x0
	// Bit mask of PER field.
	RTC_MODE1_PER_PER_Msk = 0xffff

	// COMP: MODE1 Compare n Value
	// Position of COMP field.
	RTC_MODE1_COMP_COMP_Pos = 0x0
	// Bit mask of COMP field.
	RTC_MODE1_COMP_COMP_Msk = 0xffff

	// GP: General Purpose
	// Position of GP field.
	RTC_MODE1_GP_GP_Pos = 0x0
	// Bit mask of GP field.
	RTC_MODE1_GP_GP_Msk = 0xffffffff

	// TAMPCTRL: Tamper Control
	// Position of IN0ACT field.
	RTC_MODE1_TAMPCTRL_IN0ACT_Pos = 0x0
	// Bit mask of IN0ACT field.
	RTC_MODE1_TAMPCTRL_IN0ACT_Msk = 0x3
	// Off (Disabled)
	RTC_MODE1_TAMPCTRL_IN0ACT_OFF = 0x0
	// Wake and set Tamper flag
	RTC_MODE1_TAMPCTRL_IN0ACT_WAKE = 0x1
	// Capture timestamp and set Tamper flag
	RTC_MODE1_TAMPCTRL_IN0ACT_CAPTURE = 0x2
	// Compare IN0 to OUT. When a mismatch occurs, capture timestamp and set Tamper flag
	RTC_MODE1_TAMPCTRL_IN0ACT_ACTL = 0x3
	// Position of IN1ACT field.
	RTC_MODE1_TAMPCTRL_IN1ACT_Pos = 0x2
	// Bit mask of IN1ACT field.
	RTC_MODE1_TAMPCTRL_IN1ACT_Msk = 0xc
	// Off (Disabled)
	RTC_MODE1_TAMPCTRL_IN1ACT_OFF = 0x0
	// Wake and set Tamper flag
	RTC_MODE1_TAMPCTRL_IN1ACT_WAKE = 0x1
	// Capture timestamp and set Tamper flag
	RTC_MODE1_TAMPCTRL_IN1ACT_CAPTURE = 0x2
	// Compare IN1 to OUT. When a mismatch occurs, capture timestamp and set Tamper flag
	RTC_MODE1_TAMPCTRL_IN1ACT_ACTL = 0x3
	// Position of IN2ACT field.
	RTC_MODE1_TAMPCTRL_IN2ACT_Pos = 0x4
	// Bit mask of IN2ACT field.
	RTC_MODE1_TAMPCTRL_IN2ACT_Msk = 0x30
	// Off (Disabled)
	RTC_MODE1_TAMPCTRL_IN2ACT_OFF = 0x0
	// Wake and set Tamper flag
	RTC_MODE1_TAMPCTRL_IN2ACT_WAKE = 0x1
	// Capture timestamp and set Tamper flag
	RTC_MODE1_TAMPCTRL_IN2ACT_CAPTURE = 0x2
	// Compare IN2 to OUT. When a mismatch occurs, capture timestamp and set Tamper flag
	RTC_MODE1_TAMPCTRL_IN2ACT_ACTL = 0x3
	// Position of IN3ACT field.
	RTC_MODE1_TAMPCTRL_IN3ACT_Pos = 0x6
	// Bit mask of IN3ACT field.
	RTC_MODE1_TAMPCTRL_IN3ACT_Msk = 0xc0
	// Off (Disabled)
	RTC_MODE1_TAMPCTRL_IN3ACT_OFF = 0x0
	// Wake and set Tamper flag
	RTC_MODE1_TAMPCTRL_IN3ACT_WAKE = 0x1
	// Capture timestamp and set Tamper flag
	RTC_MODE1_TAMPCTRL_IN3ACT_CAPTURE = 0x2
	// Compare IN3 to OUT. When a mismatch occurs, capture timestamp and set Tamper flag
	RTC_MODE1_TAMPCTRL_IN3ACT_ACTL = 0x3
	// Position of TAMLVL0 field.
	RTC_MODE1_TAMPCTRL_TAMLVL0_Pos = 0x10
	// Bit mask of TAMLVL0 field.
	RTC_MODE1_TAMPCTRL_TAMLVL0_Msk = 0x10000
	// Bit TAMLVL0.
	RTC_MODE1_TAMPCTRL_TAMLVL0 = 0x10000
	// Position of TAMLVL1 field.
	RTC_MODE1_TAMPCTRL_TAMLVL1_Pos = 0x11
	// Bit mask of TAMLVL1 field.
	RTC_MODE1_TAMPCTRL_TAMLVL1_Msk = 0x20000
	// Bit TAMLVL1.
	RTC_MODE1_TAMPCTRL_TAMLVL1 = 0x20000
	// Position of TAMLVL2 field.
	RTC_MODE1_TAMPCTRL_TAMLVL2_Pos = 0x12
	// Bit mask of TAMLVL2 field.
	RTC_MODE1_TAMPCTRL_TAMLVL2_Msk = 0x40000
	// Bit TAMLVL2.
	RTC_MODE1_TAMPCTRL_TAMLVL2 = 0x40000
	// Position of TAMLVL3 field.
	RTC_MODE1_TAMPCTRL_TAMLVL3_Pos = 0x13
	// Bit mask of TAMLVL3 field.
	RTC_MODE1_TAMPCTRL_TAMLVL3_Msk = 0x80000
	// Bit TAMLVL3.
	RTC_MODE1_TAMPCTRL_TAMLVL3 = 0x80000
	// Position of DEBNC0 field.
	RTC_MODE1_TAMPCTRL_DEBNC0_Pos = 0x18
	// Bit mask of DEBNC0 field.
	RTC_MODE1_TAMPCTRL_DEBNC0_Msk = 0x1000000
	// Bit DEBNC0.
	RTC_MODE1_TAMPCTRL_DEBNC0 = 0x1000000
	// Position of DEBNC1 field.
	RTC_MODE1_TAMPCTRL_DEBNC1_Pos = 0x19
	// Bit mask of DEBNC1 field.
	RTC_MODE1_TAMPCTRL_DEBNC1_Msk = 0x2000000
	// Bit DEBNC1.
	RTC_MODE1_TAMPCTRL_DEBNC1 = 0x2000000
	// Position of DEBNC2 field.
	RTC_MODE1_TAMPCTRL_DEBNC2_Pos = 0x1a
	// Bit mask of DEBNC2 field.
	RTC_MODE1_TAMPCTRL_DEBNC2_Msk = 0x4000000
	// Bit DEBNC2.
	RTC_MODE1_TAMPCTRL_DEBNC2 = 0x4000000
	// Position of DEBNC3 field.
	RTC_MODE1_TAMPCTRL_DEBNC3_Pos = 0x1b
	// Bit mask of DEBNC3 field.
	RTC_MODE1_TAMPCTRL_DEBNC3_Msk = 0x8000000
	// Bit DEBNC3.
	RTC_MODE1_TAMPCTRL_DEBNC3 = 0x8000000

	// TIMESTAMP: MODE1 Timestamp
	// Position of COUNT field.
	RTC_MODE1_TIMESTAMP_COUNT_Pos = 0x0
	// Bit mask of COUNT field.
	RTC_MODE1_TIMESTAMP_COUNT_Msk = 0xffff

	// TAMPID: Tamper ID
	// Position of TAMPID0 field.
	RTC_MODE1_TAMPID_TAMPID0_Pos = 0x0
	// Bit mask of TAMPID0 field.
	RTC_MODE1_TAMPID_TAMPID0_Msk = 0x1
	// Bit TAMPID0.
	RTC_MODE1_TAMPID_TAMPID0 = 0x1
	// Position of TAMPID1 field.
	RTC_MODE1_TAMPID_TAMPID1_Pos = 0x1
	// Bit mask of TAMPID1 field.
	RTC_MODE1_TAMPID_TAMPID1_Msk = 0x2
	// Bit TAMPID1.
	RTC_MODE1_TAMPID_TAMPID1 = 0x2
	// Position of TAMPID2 field.
	RTC_MODE1_TAMPID_TAMPID2_Pos = 0x2
	// Bit mask of TAMPID2 field.
	RTC_MODE1_TAMPID_TAMPID2_Msk = 0x4
	// Bit TAMPID2.
	RTC_MODE1_TAMPID_TAMPID2 = 0x4
	// Position of TAMPID3 field.
	RTC_MODE1_TAMPID_TAMPID3_Pos = 0x3
	// Bit mask of TAMPID3 field.
	RTC_MODE1_TAMPID_TAMPID3_Msk = 0x8
	// Bit TAMPID3.
	RTC_MODE1_TAMPID_TAMPID3 = 0x8
	// Position of TAMPEVT field.
	RTC_MODE1_TAMPID_TAMPEVT_Pos = 0x1f
	// Bit mask of TAMPEVT field.
	RTC_MODE1_TAMPID_TAMPEVT_Msk = 0x80000000
	// Bit TAMPEVT.
	RTC_MODE1_TAMPID_TAMPEVT = 0x80000000

	// TAMPCTRLB: Tamper Control B
	// Position of ALSI0 field.
	RTC_MODE1_TAMPCTRLB_ALSI0_Pos = 0x0
	// Bit mask of ALSI0 field.
	RTC_MODE1_TAMPCTRLB_ALSI0_Msk = 0x1
	// Bit ALSI0.
	RTC_MODE1_TAMPCTRLB_ALSI0 = 0x1
	// Position of ALSI1 field.
	RTC_MODE1_TAMPCTRLB_ALSI1_Pos = 0x1
	// Bit mask of ALSI1 field.
	RTC_MODE1_TAMPCTRLB_ALSI1_Msk = 0x2
	// Bit ALSI1.
	RTC_MODE1_TAMPCTRLB_ALSI1 = 0x2
	// Position of ALSI2 field.
	RTC_MODE1_TAMPCTRLB_ALSI2_Pos = 0x2
	// Bit mask of ALSI2 field.
	RTC_MODE1_TAMPCTRLB_ALSI2_Msk = 0x4
	// Bit ALSI2.
	RTC_MODE1_TAMPCTRLB_ALSI2 = 0x4
	// Position of ALSI3 field.
	RTC_MODE1_TAMPCTRLB_ALSI3_Pos = 0x3
	// Bit mask of ALSI3 field.
	RTC_MODE1_TAMPCTRLB_ALSI3_Msk = 0x8
	// Bit ALSI3.
	RTC_MODE1_TAMPCTRLB_ALSI3 = 0x8
)

// Constants for RTC_MODE2: Real-Time Counter - MODE2
const (
	// CTRLA: MODE2 Control A
	// Position of SWRST field.
	RTC_MODE2_CTRLA_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	RTC_MODE2_CTRLA_SWRST_Msk = 0x1
	// Bit SWRST.
	RTC_MODE2_CTRLA_SWRST = 0x1
	// Position of ENABLE field.
	RTC_MODE2_CTRLA_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	RTC_MODE2_CTRLA_ENABLE_Msk = 0x2
	// Bit ENABLE.
	RTC_MODE2_CTRLA_ENABLE = 0x2
	// Position of MODE field.
	RTC_MODE2_CTRLA_MODE_Pos = 0x2
	// Bit mask of MODE field.
	RTC_MODE2_CTRLA_MODE_Msk = 0xc
	// Mode 0: 32-bit Counter
	RTC_MODE2_CTRLA_MODE_COUNT32 = 0x0
	// Mode 1: 16-bit Counter
	RTC_MODE2_CTRLA_MODE_COUNT16 = 0x1
	// Mode 2: Clock/Calendar
	RTC_MODE2_CTRLA_MODE_CLOCK = 0x2
	// Position of CLKREP field.
	RTC_MODE2_CTRLA_CLKREP_Pos = 0x6
	// Bit mask of CLKREP field.
	RTC_MODE2_CTRLA_CLKREP_Msk = 0x40
	// Bit CLKREP.
	RTC_MODE2_CTRLA_CLKREP = 0x40
	// Position of MATCHCLR field.
	RTC_MODE2_CTRLA_MATCHCLR_Pos = 0x7
	// Bit mask of MATCHCLR field.
	RTC_MODE2_CTRLA_MATCHCLR_Msk = 0x80
	// Bit MATCHCLR.
	RTC_MODE2_CTRLA_MATCHCLR = 0x80
	// Position of PRESCALER field.
	RTC_MODE2_CTRLA_PRESCALER_Pos = 0x8
	// Bit mask of PRESCALER field.
	RTC_MODE2_CTRLA_PRESCALER_Msk = 0xf00
	// CLK_RTC_CNT = GCLK_RTC/1
	RTC_MODE2_CTRLA_PRESCALER_OFF = 0x0
	// CLK_RTC_CNT = GCLK_RTC/1
	RTC_MODE2_CTRLA_PRESCALER_DIV1 = 0x1
	// CLK_RTC_CNT = GCLK_RTC/2
	RTC_MODE2_CTRLA_PRESCALER_DIV2 = 0x2
	// CLK_RTC_CNT = GCLK_RTC/4
	RTC_MODE2_CTRLA_PRESCALER_DIV4 = 0x3
	// CLK_RTC_CNT = GCLK_RTC/8
	RTC_MODE2_CTRLA_PRESCALER_DIV8 = 0x4
	// CLK_RTC_CNT = GCLK_RTC/16
	RTC_MODE2_CTRLA_PRESCALER_DIV16 = 0x5
	// CLK_RTC_CNT = GCLK_RTC/32
	RTC_MODE2_CTRLA_PRESCALER_DIV32 = 0x6
	// CLK_RTC_CNT = GCLK_RTC/64
	RTC_MODE2_CTRLA_PRESCALER_DIV64 = 0x7
	// CLK_RTC_CNT = GCLK_RTC/128
	RTC_MODE2_CTRLA_PRESCALER_DIV128 = 0x8
	// CLK_RTC_CNT = GCLK_RTC/256
	RTC_MODE2_CTRLA_PRESCALER_DIV256 = 0x9
	// CLK_RTC_CNT = GCLK_RTC/512
	RTC_MODE2_CTRLA_PRESCALER_DIV512 = 0xa
	// CLK_RTC_CNT = GCLK_RTC/1024
	RTC_MODE2_CTRLA_PRESCALER_DIV1024 = 0xb
	// Position of GPTRST field.
	RTC_MODE2_CTRLA_GPTRST_Pos = 0xe
	// Bit mask of GPTRST field.
	RTC_MODE2_CTRLA_GPTRST_Msk = 0x4000
	// Bit GPTRST.
	RTC_MODE2_CTRLA_GPTRST = 0x4000
	// Position of CLOCKSYNC field.
	RTC_MODE2_CTRLA_CLOCKSYNC_Pos = 0xf
	// Bit mask of CLOCKSYNC field.
	RTC_MODE2_CTRLA_CLOCKSYNC_Msk = 0x8000
	// Bit CLOCKSYNC.
	RTC_MODE2_CTRLA_CLOCKSYNC = 0x8000

	// CTRLB: MODE2 Control B
	// Position of GP0EN field.
	RTC_MODE2_CTRLB_GP0EN_Pos = 0x0
	// Bit mask of GP0EN field.
	RTC_MODE2_CTRLB_GP0EN_Msk = 0x1
	// Bit GP0EN.
	RTC_MODE2_CTRLB_GP0EN = 0x1
	// Position of DEBMAJ field.
	RTC_MODE2_CTRLB_DEBMAJ_Pos = 0x4
	// Bit mask of DEBMAJ field.
	RTC_MODE2_CTRLB_DEBMAJ_Msk = 0x10
	// Bit DEBMAJ.
	RTC_MODE2_CTRLB_DEBMAJ = 0x10
	// Position of DEBASYNC field.
	RTC_MODE2_CTRLB_DEBASYNC_Pos = 0x5
	// Bit mask of DEBASYNC field.
	RTC_MODE2_CTRLB_DEBASYNC_Msk = 0x20
	// Bit DEBASYNC.
	RTC_MODE2_CTRLB_DEBASYNC = 0x20
	// Position of RTCOUT field.
	RTC_MODE2_CTRLB_RTCOUT_Pos = 0x6
	// Bit mask of RTCOUT field.
	RTC_MODE2_CTRLB_RTCOUT_Msk = 0x40
	// Bit RTCOUT.
	RTC_MODE2_CTRLB_RTCOUT = 0x40
	// Position of DMAEN field.
	RTC_MODE2_CTRLB_DMAEN_Pos = 0x7
	// Bit mask of DMAEN field.
	RTC_MODE2_CTRLB_DMAEN_Msk = 0x80
	// Bit DMAEN.
	RTC_MODE2_CTRLB_DMAEN = 0x80
	// Position of DEBF field.
	RTC_MODE2_CTRLB_DEBF_Pos = 0x8
	// Bit mask of DEBF field.
	RTC_MODE2_CTRLB_DEBF_Msk = 0x700
	// CLK_RTC_DEB = CLK_RTC/2
	RTC_MODE2_CTRLB_DEBF_DIV2 = 0x0
	// CLK_RTC_DEB = CLK_RTC/4
	RTC_MODE2_CTRLB_DEBF_DIV4 = 0x1
	// CLK_RTC_DEB = CLK_RTC/8
	RTC_MODE2_CTRLB_DEBF_DIV8 = 0x2
	// CLK_RTC_DEB = CLK_RTC/16
	RTC_MODE2_CTRLB_DEBF_DIV16 = 0x3
	// CLK_RTC_DEB = CLK_RTC/32
	RTC_MODE2_CTRLB_DEBF_DIV32 = 0x4
	// CLK_RTC_DEB = CLK_RTC/64
	RTC_MODE2_CTRLB_DEBF_DIV64 = 0x5
	// CLK_RTC_DEB = CLK_RTC/128
	RTC_MODE2_CTRLB_DEBF_DIV128 = 0x6
	// CLK_RTC_DEB = CLK_RTC/256
	RTC_MODE2_CTRLB_DEBF_DIV256 = 0x7
	// Position of ACTF field.
	RTC_MODE2_CTRLB_ACTF_Pos = 0xc
	// Bit mask of ACTF field.
	RTC_MODE2_CTRLB_ACTF_Msk = 0x7000
	// CLK_RTC_OUT = CLK_RTC/2
	RTC_MODE2_CTRLB_ACTF_DIV2 = 0x0
	// CLK_RTC_OUT = CLK_RTC/4
	RTC_MODE2_CTRLB_ACTF_DIV4 = 0x1
	// CLK_RTC_OUT = CLK_RTC/8
	RTC_MODE2_CTRLB_ACTF_DIV8 = 0x2
	// CLK_RTC_OUT = CLK_RTC/16
	RTC_MODE2_CTRLB_ACTF_DIV16 = 0x3
	// CLK_RTC_OUT = CLK_RTC/32
	RTC_MODE2_CTRLB_ACTF_DIV32 = 0x4
	// CLK_RTC_OUT = CLK_RTC/64
	RTC_MODE2_CTRLB_ACTF_DIV64 = 0x5
	// CLK_RTC_OUT = CLK_RTC/128
	RTC_MODE2_CTRLB_ACTF_DIV128 = 0x6
	// CLK_RTC_OUT = CLK_RTC/256
	RTC_MODE2_CTRLB_ACTF_DIV256 = 0x7
	// Position of SEPTO field.
	RTC_MODE2_CTRLB_SEPTO_Pos = 0xf
	// Bit mask of SEPTO field.
	RTC_MODE2_CTRLB_SEPTO_Msk = 0x8000
	// Bit SEPTO.
	RTC_MODE2_CTRLB_SEPTO = 0x8000

	// EVCTRL: MODE2 Event Control
	// Position of PEREO0 field.
	RTC_MODE2_EVCTRL_PEREO0_Pos = 0x0
	// Bit mask of PEREO0 field.
	RTC_MODE2_EVCTRL_PEREO0_Msk = 0x1
	// Bit PEREO0.
	RTC_MODE2_EVCTRL_PEREO0 = 0x1
	// Position of PEREO1 field.
	RTC_MODE2_EVCTRL_PEREO1_Pos = 0x1
	// Bit mask of PEREO1 field.
	RTC_MODE2_EVCTRL_PEREO1_Msk = 0x2
	// Bit PEREO1.
	RTC_MODE2_EVCTRL_PEREO1 = 0x2
	// Position of PEREO2 field.
	RTC_MODE2_EVCTRL_PEREO2_Pos = 0x2
	// Bit mask of PEREO2 field.
	RTC_MODE2_EVCTRL_PEREO2_Msk = 0x4
	// Bit PEREO2.
	RTC_MODE2_EVCTRL_PEREO2 = 0x4
	// Position of PEREO3 field.
	RTC_MODE2_EVCTRL_PEREO3_Pos = 0x3
	// Bit mask of PEREO3 field.
	RTC_MODE2_EVCTRL_PEREO3_Msk = 0x8
	// Bit PEREO3.
	RTC_MODE2_EVCTRL_PEREO3 = 0x8
	// Position of PEREO4 field.
	RTC_MODE2_EVCTRL_PEREO4_Pos = 0x4
	// Bit mask of PEREO4 field.
	RTC_MODE2_EVCTRL_PEREO4_Msk = 0x10
	// Bit PEREO4.
	RTC_MODE2_EVCTRL_PEREO4 = 0x10
	// Position of PEREO5 field.
	RTC_MODE2_EVCTRL_PEREO5_Pos = 0x5
	// Bit mask of PEREO5 field.
	RTC_MODE2_EVCTRL_PEREO5_Msk = 0x20
	// Bit PEREO5.
	RTC_MODE2_EVCTRL_PEREO5 = 0x20
	// Position of PEREO6 field.
	RTC_MODE2_EVCTRL_PEREO6_Pos = 0x6
	// Bit mask of PEREO6 field.
	RTC_MODE2_EVCTRL_PEREO6_Msk = 0x40
	// Bit PEREO6.
	RTC_MODE2_EVCTRL_PEREO6 = 0x40
	// Position of PEREO7 field.
	RTC_MODE2_EVCTRL_PEREO7_Pos = 0x7
	// Bit mask of PEREO7 field.
	RTC_MODE2_EVCTRL_PEREO7_Msk = 0x80
	// Bit PEREO7.
	RTC_MODE2_EVCTRL_PEREO7 = 0x80
	// Position of ALARMEO0 field.
	RTC_MODE2_EVCTRL_ALARMEO0_Pos = 0x8
	// Bit mask of ALARMEO0 field.
	RTC_MODE2_EVCTRL_ALARMEO0_Msk = 0x100
	// Bit ALARMEO0.
	RTC_MODE2_EVCTRL_ALARMEO0 = 0x100
	// Position of TAMPEREO field.
	RTC_MODE2_EVCTRL_TAMPEREO_Pos = 0xe
	// Bit mask of TAMPEREO field.
	RTC_MODE2_EVCTRL_TAMPEREO_Msk = 0x4000
	// Bit TAMPEREO.
	RTC_MODE2_EVCTRL_TAMPEREO = 0x4000
	// Position of OVFEO field.
	RTC_MODE2_EVCTRL_OVFEO_Pos = 0xf
	// Bit mask of OVFEO field.
	RTC_MODE2_EVCTRL_OVFEO_Msk = 0x8000
	// Bit OVFEO.
	RTC_MODE2_EVCTRL_OVFEO = 0x8000
	// Position of TAMPEVEI field.
	RTC_MODE2_EVCTRL_TAMPEVEI_Pos = 0x10
	// Bit mask of TAMPEVEI field.
	RTC_MODE2_EVCTRL_TAMPEVEI_Msk = 0x10000
	// Bit TAMPEVEI.
	RTC_MODE2_EVCTRL_TAMPEVEI = 0x10000
	// Position of PERDEO field.
	RTC_MODE2_EVCTRL_PERDEO_Pos = 0x18
	// Bit mask of PERDEO field.
	RTC_MODE2_EVCTRL_PERDEO_Msk = 0x1000000
	// Bit PERDEO.
	RTC_MODE2_EVCTRL_PERDEO = 0x1000000

	// INTENCLR: MODE2 Interrupt Enable Clear
	// Position of PER0 field.
	RTC_MODE2_INTENCLR_PER0_Pos = 0x0
	// Bit mask of PER0 field.
	RTC_MODE2_INTENCLR_PER0_Msk = 0x1
	// Bit PER0.
	RTC_MODE2_INTENCLR_PER0 = 0x1
	// Position of PER1 field.
	RTC_MODE2_INTENCLR_PER1_Pos = 0x1
	// Bit mask of PER1 field.
	RTC_MODE2_INTENCLR_PER1_Msk = 0x2
	// Bit PER1.
	RTC_MODE2_INTENCLR_PER1 = 0x2
	// Position of PER2 field.
	RTC_MODE2_INTENCLR_PER2_Pos = 0x2
	// Bit mask of PER2 field.
	RTC_MODE2_INTENCLR_PER2_Msk = 0x4
	// Bit PER2.
	RTC_MODE2_INTENCLR_PER2 = 0x4
	// Position of PER3 field.
	RTC_MODE2_INTENCLR_PER3_Pos = 0x3
	// Bit mask of PER3 field.
	RTC_MODE2_INTENCLR_PER3_Msk = 0x8
	// Bit PER3.
	RTC_MODE2_INTENCLR_PER3 = 0x8
	// Position of PER4 field.
	RTC_MODE2_INTENCLR_PER4_Pos = 0x4
	// Bit mask of PER4 field.
	RTC_MODE2_INTENCLR_PER4_Msk = 0x10
	// Bit PER4.
	RTC_MODE2_INTENCLR_PER4 = 0x10
	// Position of PER5 field.
	RTC_MODE2_INTENCLR_PER5_Pos = 0x5
	// Bit mask of PER5 field.
	RTC_MODE2_INTENCLR_PER5_Msk = 0x20
	// Bit PER5.
	RTC_MODE2_INTENCLR_PER5 = 0x20
	// Position of PER6 field.
	RTC_MODE2_INTENCLR_PER6_Pos = 0x6
	// Bit mask of PER6 field.
	RTC_MODE2_INTENCLR_PER6_Msk = 0x40
	// Bit PER6.
	RTC_MODE2_INTENCLR_PER6 = 0x40
	// Position of PER7 field.
	RTC_MODE2_INTENCLR_PER7_Pos = 0x7
	// Bit mask of PER7 field.
	RTC_MODE2_INTENCLR_PER7_Msk = 0x80
	// Bit PER7.
	RTC_MODE2_INTENCLR_PER7 = 0x80
	// Position of ALARM0 field.
	RTC_MODE2_INTENCLR_ALARM0_Pos = 0x8
	// Bit mask of ALARM0 field.
	RTC_MODE2_INTENCLR_ALARM0_Msk = 0x100
	// Bit ALARM0.
	RTC_MODE2_INTENCLR_ALARM0 = 0x100
	// Position of TAMPER field.
	RTC_MODE2_INTENCLR_TAMPER_Pos = 0xe
	// Bit mask of TAMPER field.
	RTC_MODE2_INTENCLR_TAMPER_Msk = 0x4000
	// Bit TAMPER.
	RTC_MODE2_INTENCLR_TAMPER = 0x4000
	// Position of OVF field.
	RTC_MODE2_INTENCLR_OVF_Pos = 0xf
	// Bit mask of OVF field.
	RTC_MODE2_INTENCLR_OVF_Msk = 0x8000
	// Bit OVF.
	RTC_MODE2_INTENCLR_OVF = 0x8000

	// INTENSET: MODE2 Interrupt Enable Set
	// Position of PER0 field.
	RTC_MODE2_INTENSET_PER0_Pos = 0x0
	// Bit mask of PER0 field.
	RTC_MODE2_INTENSET_PER0_Msk = 0x1
	// Bit PER0.
	RTC_MODE2_INTENSET_PER0 = 0x1
	// Position of PER1 field.
	RTC_MODE2_INTENSET_PER1_Pos = 0x1
	// Bit mask of PER1 field.
	RTC_MODE2_INTENSET_PER1_Msk = 0x2
	// Bit PER1.
	RTC_MODE2_INTENSET_PER1 = 0x2
	// Position of PER2 field.
	RTC_MODE2_INTENSET_PER2_Pos = 0x2
	// Bit mask of PER2 field.
	RTC_MODE2_INTENSET_PER2_Msk = 0x4
	// Bit PER2.
	RTC_MODE2_INTENSET_PER2 = 0x4
	// Position of PER3 field.
	RTC_MODE2_INTENSET_PER3_Pos = 0x3
	// Bit mask of PER3 field.
	RTC_MODE2_INTENSET_PER3_Msk = 0x8
	// Bit PER3.
	RTC_MODE2_INTENSET_PER3 = 0x8
	// Position of PER4 field.
	RTC_MODE2_INTENSET_PER4_Pos = 0x4
	// Bit mask of PER4 field.
	RTC_MODE2_INTENSET_PER4_Msk = 0x10
	// Bit PER4.
	RTC_MODE2_INTENSET_PER4 = 0x10
	// Position of PER5 field.
	RTC_MODE2_INTENSET_PER5_Pos = 0x5
	// Bit mask of PER5 field.
	RTC_MODE2_INTENSET_PER5_Msk = 0x20
	// Bit PER5.
	RTC_MODE2_INTENSET_PER5 = 0x20
	// Position of PER6 field.
	RTC_MODE2_INTENSET_PER6_Pos = 0x6
	// Bit mask of PER6 field.
	RTC_MODE2_INTENSET_PER6_Msk = 0x40
	// Bit PER6.
	RTC_MODE2_INTENSET_PER6 = 0x40
	// Position of PER7 field.
	RTC_MODE2_INTENSET_PER7_Pos = 0x7
	// Bit mask of PER7 field.
	RTC_MODE2_INTENSET_PER7_Msk = 0x80
	// Bit PER7.
	RTC_MODE2_INTENSET_PER7 = 0x80
	// Position of ALARM0 field.
	RTC_MODE2_INTENSET_ALARM0_Pos = 0x8
	// Bit mask of ALARM0 field.
	RTC_MODE2_INTENSET_ALARM0_Msk = 0x100
	// Bit ALARM0.
	RTC_MODE2_INTENSET_ALARM0 = 0x100
	// Position of TAMPER field.
	RTC_MODE2_INTENSET_TAMPER_Pos = 0xe
	// Bit mask of TAMPER field.
	RTC_MODE2_INTENSET_TAMPER_Msk = 0x4000
	// Bit TAMPER.
	RTC_MODE2_INTENSET_TAMPER = 0x4000
	// Position of OVF field.
	RTC_MODE2_INTENSET_OVF_Pos = 0xf
	// Bit mask of OVF field.
	RTC_MODE2_INTENSET_OVF_Msk = 0x8000
	// Bit OVF.
	RTC_MODE2_INTENSET_OVF = 0x8000

	// INTFLAG: MODE2 Interrupt Flag Status and Clear
	// Position of PER0 field.
	RTC_MODE2_INTFLAG_PER0_Pos = 0x0
	// Bit mask of PER0 field.
	RTC_MODE2_INTFLAG_PER0_Msk = 0x1
	// Bit PER0.
	RTC_MODE2_INTFLAG_PER0 = 0x1
	// Position of PER1 field.
	RTC_MODE2_INTFLAG_PER1_Pos = 0x1
	// Bit mask of PER1 field.
	RTC_MODE2_INTFLAG_PER1_Msk = 0x2
	// Bit PER1.
	RTC_MODE2_INTFLAG_PER1 = 0x2
	// Position of PER2 field.
	RTC_MODE2_INTFLAG_PER2_Pos = 0x2
	// Bit mask of PER2 field.
	RTC_MODE2_INTFLAG_PER2_Msk = 0x4
	// Bit PER2.
	RTC_MODE2_INTFLAG_PER2 = 0x4
	// Position of PER3 field.
	RTC_MODE2_INTFLAG_PER3_Pos = 0x3
	// Bit mask of PER3 field.
	RTC_MODE2_INTFLAG_PER3_Msk = 0x8
	// Bit PER3.
	RTC_MODE2_INTFLAG_PER3 = 0x8
	// Position of PER4 field.
	RTC_MODE2_INTFLAG_PER4_Pos = 0x4
	// Bit mask of PER4 field.
	RTC_MODE2_INTFLAG_PER4_Msk = 0x10
	// Bit PER4.
	RTC_MODE2_INTFLAG_PER4 = 0x10
	// Position of PER5 field.
	RTC_MODE2_INTFLAG_PER5_Pos = 0x5
	// Bit mask of PER5 field.
	RTC_MODE2_INTFLAG_PER5_Msk = 0x20
	// Bit PER5.
	RTC_MODE2_INTFLAG_PER5 = 0x20
	// Position of PER6 field.
	RTC_MODE2_INTFLAG_PER6_Pos = 0x6
	// Bit mask of PER6 field.
	RTC_MODE2_INTFLAG_PER6_Msk = 0x40
	// Bit PER6.
	RTC_MODE2_INTFLAG_PER6 = 0x40
	// Position of PER7 field.
	RTC_MODE2_INTFLAG_PER7_Pos = 0x7
	// Bit mask of PER7 field.
	RTC_MODE2_INTFLAG_PER7_Msk = 0x80
	// Bit PER7.
	RTC_MODE2_INTFLAG_PER7 = 0x80
	// Position of ALARM0 field.
	RTC_MODE2_INTFLAG_ALARM0_Pos = 0x8
	// Bit mask of ALARM0 field.
	RTC_MODE2_INTFLAG_ALARM0_Msk = 0x100
	// Bit ALARM0.
	RTC_MODE2_INTFLAG_ALARM0 = 0x100
	// Position of TAMPER field.
	RTC_MODE2_INTFLAG_TAMPER_Pos = 0xe
	// Bit mask of TAMPER field.
	RTC_MODE2_INTFLAG_TAMPER_Msk = 0x4000
	// Bit TAMPER.
	RTC_MODE2_INTFLAG_TAMPER = 0x4000
	// Position of OVF field.
	RTC_MODE2_INTFLAG_OVF_Pos = 0xf
	// Bit mask of OVF field.
	RTC_MODE2_INTFLAG_OVF_Msk = 0x8000
	// Bit OVF.
	RTC_MODE2_INTFLAG_OVF = 0x8000

	// DBGCTRL: Debug Control
	// Position of DBGRUN field.
	RTC_MODE2_DBGCTRL_DBGRUN_Pos = 0x0
	// Bit mask of DBGRUN field.
	RTC_MODE2_DBGCTRL_DBGRUN_Msk = 0x1
	// Bit DBGRUN.
	RTC_MODE2_DBGCTRL_DBGRUN = 0x1

	// SYNCBUSY: MODE2 Synchronization Busy Status
	// Position of SWRST field.
	RTC_MODE2_SYNCBUSY_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	RTC_MODE2_SYNCBUSY_SWRST_Msk = 0x1
	// Bit SWRST.
	RTC_MODE2_SYNCBUSY_SWRST = 0x1
	// Position of ENABLE field.
	RTC_MODE2_SYNCBUSY_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	RTC_MODE2_SYNCBUSY_ENABLE_Msk = 0x2
	// Bit ENABLE.
	RTC_MODE2_SYNCBUSY_ENABLE = 0x2
	// Position of FREQCORR field.
	RTC_MODE2_SYNCBUSY_FREQCORR_Pos = 0x2
	// Bit mask of FREQCORR field.
	RTC_MODE2_SYNCBUSY_FREQCORR_Msk = 0x4
	// Bit FREQCORR.
	RTC_MODE2_SYNCBUSY_FREQCORR = 0x4
	// Position of CLOCK field.
	RTC_MODE2_SYNCBUSY_CLOCK_Pos = 0x3
	// Bit mask of CLOCK field.
	RTC_MODE2_SYNCBUSY_CLOCK_Msk = 0x8
	// Bit CLOCK.
	RTC_MODE2_SYNCBUSY_CLOCK = 0x8
	// Position of ALARM0 field.
	RTC_MODE2_SYNCBUSY_ALARM0_Pos = 0x5
	// Bit mask of ALARM0 field.
	RTC_MODE2_SYNCBUSY_ALARM0_Msk = 0x20
	// Bit ALARM0.
	RTC_MODE2_SYNCBUSY_ALARM0 = 0x20
	// Position of MASK0 field.
	RTC_MODE2_SYNCBUSY_MASK0_Pos = 0xb
	// Bit mask of MASK0 field.
	RTC_MODE2_SYNCBUSY_MASK0_Msk = 0x800
	// Bit MASK0.
	RTC_MODE2_SYNCBUSY_MASK0 = 0x800
	// Position of CLOCKSYNC field.
	RTC_MODE2_SYNCBUSY_CLOCKSYNC_Pos = 0xf
	// Bit mask of CLOCKSYNC field.
	RTC_MODE2_SYNCBUSY_CLOCKSYNC_Msk = 0x8000
	// Bit CLOCKSYNC.
	RTC_MODE2_SYNCBUSY_CLOCKSYNC = 0x8000
	// Position of GP0 field.
	RTC_MODE2_SYNCBUSY_GP0_Pos = 0x10
	// Bit mask of GP0 field.
	RTC_MODE2_SYNCBUSY_GP0_Msk = 0x10000
	// Bit GP0.
	RTC_MODE2_SYNCBUSY_GP0 = 0x10000
	// Position of GP1 field.
	RTC_MODE2_SYNCBUSY_GP1_Pos = 0x11
	// Bit mask of GP1 field.
	RTC_MODE2_SYNCBUSY_GP1_Msk = 0x20000
	// Bit GP1.
	RTC_MODE2_SYNCBUSY_GP1 = 0x20000

	// FREQCORR: Frequency Correction
	// Position of VALUE field.
	RTC_MODE2_FREQCORR_VALUE_Pos = 0x0
	// Bit mask of VALUE field.
	RTC_MODE2_FREQCORR_VALUE_Msk = 0x7f
	// Position of SIGN field.
	RTC_MODE2_FREQCORR_SIGN_Pos = 0x7
	// Bit mask of SIGN field.
	RTC_MODE2_FREQCORR_SIGN_Msk = 0x80
	// Bit SIGN.
	RTC_MODE2_FREQCORR_SIGN = 0x80

	// CLOCK: MODE2 Clock Value
	// Position of SECOND field.
	RTC_MODE2_CLOCK_SECOND_Pos = 0x0
	// Bit mask of SECOND field.
	RTC_MODE2_CLOCK_SECOND_Msk = 0x3f
	// Position of MINUTE field.
	RTC_MODE2_CLOCK_MINUTE_Pos = 0x6
	// Bit mask of MINUTE field.
	RTC_MODE2_CLOCK_MINUTE_Msk = 0xfc0
	// Position of HOUR field.
	RTC_MODE2_CLOCK_HOUR_Pos = 0xc
	// Bit mask of HOUR field.
	RTC_MODE2_CLOCK_HOUR_Msk = 0x1f000
	// Position of DAY field.
	RTC_MODE2_CLOCK_DAY_Pos = 0x11
	// Bit mask of DAY field.
	RTC_MODE2_CLOCK_DAY_Msk = 0x3e0000
	// Position of MONTH field.
	RTC_MODE2_CLOCK_MONTH_Pos = 0x16
	// Bit mask of MONTH field.
	RTC_MODE2_CLOCK_MONTH_Msk = 0x3c00000
	// Position of YEAR field.
	RTC_MODE2_CLOCK_YEAR_Pos = 0x1a
	// Bit mask of YEAR field.
	RTC_MODE2_CLOCK_YEAR_Msk = 0xfc000000

	// ALARM: MODE2_ALARM Alarm n Value
	// Position of SECOND field.
	ALARM_MODE2_ALARM_ALARM_SECOND_Pos = 0x0
	// Bit mask of SECOND field.
	ALARM_MODE2_ALARM_ALARM_SECOND_Msk = 0x3f
	// Position of MINUTE field.
	ALARM_MODE2_ALARM_ALARM_MINUTE_Pos = 0x6
	// Bit mask of MINUTE field.
	ALARM_MODE2_ALARM_ALARM_MINUTE_Msk = 0xfc0
	// Position of HOUR field.
	ALARM_MODE2_ALARM_ALARM_HOUR_Pos = 0xc
	// Bit mask of HOUR field.
	ALARM_MODE2_ALARM_ALARM_HOUR_Msk = 0x1f000
	// Morning hour
	ALARM_MODE2_ALARM_ALARM_HOUR_AM = 0x0
	// Afternoon hour
	ALARM_MODE2_ALARM_ALARM_HOUR_PM = 0x10
	// Position of DAY field.
	ALARM_MODE2_ALARM_ALARM_DAY_Pos = 0x11
	// Bit mask of DAY field.
	ALARM_MODE2_ALARM_ALARM_DAY_Msk = 0x3e0000
	// Position of MONTH field.
	ALARM_MODE2_ALARM_ALARM_MONTH_Pos = 0x16
	// Bit mask of MONTH field.
	ALARM_MODE2_ALARM_ALARM_MONTH_Msk = 0x3c00000
	// Position of YEAR field.
	ALARM_MODE2_ALARM_ALARM_YEAR_Pos = 0x1a
	// Bit mask of YEAR field.
	ALARM_MODE2_ALARM_ALARM_YEAR_Msk = 0xfc000000

	// MASK: MODE2_ALARM Alarm n Mask
	// Position of SEL field.
	MASK_MODE2_ALARM_MASK_SEL_Pos = 0x0
	// Bit mask of SEL field.
	MASK_MODE2_ALARM_MASK_SEL_Msk = 0x7
	// Alarm Disabled
	MASK_MODE2_ALARM_MASK_SEL_OFF = 0x0
	// Match seconds only
	MASK_MODE2_ALARM_MASK_SEL_SS = 0x1
	// Match seconds and minutes only
	MASK_MODE2_ALARM_MASK_SEL_MMSS = 0x2
	// Match seconds, minutes, and hours only
	MASK_MODE2_ALARM_MASK_SEL_HHMMSS = 0x3
	// Match seconds, minutes, hours, and days only
	MASK_MODE2_ALARM_MASK_SEL_DDHHMMSS = 0x4
	// Match seconds, minutes, hours, days, and months only
	MASK_MODE2_ALARM_MASK_SEL_MMDDHHMMSS = 0x5
	// Match seconds, minutes, hours, days, months, and years
	MASK_MODE2_ALARM_MASK_SEL_YYMMDDHHMMSS = 0x6

	// GP: General Purpose
	// Position of GP field.
	RTC_MODE2_GP_GP_Pos = 0x0
	// Bit mask of GP field.
	RTC_MODE2_GP_GP_Msk = 0xffffffff

	// TAMPCTRL: Tamper Control
	// Position of IN0ACT field.
	RTC_MODE2_TAMPCTRL_IN0ACT_Pos = 0x0
	// Bit mask of IN0ACT field.
	RTC_MODE2_TAMPCTRL_IN0ACT_Msk = 0x3
	// Off (Disabled)
	RTC_MODE2_TAMPCTRL_IN0ACT_OFF = 0x0
	// Wake and set Tamper flag
	RTC_MODE2_TAMPCTRL_IN0ACT_WAKE = 0x1
	// Capture timestamp and set Tamper flag
	RTC_MODE2_TAMPCTRL_IN0ACT_CAPTURE = 0x2
	// Compare IN0 to OUT. When a mismatch occurs, capture timestamp and set Tamper flag
	RTC_MODE2_TAMPCTRL_IN0ACT_ACTL = 0x3
	// Position of IN1ACT field.
	RTC_MODE2_TAMPCTRL_IN1ACT_Pos = 0x2
	// Bit mask of IN1ACT field.
	RTC_MODE2_TAMPCTRL_IN1ACT_Msk = 0xc
	// Off (Disabled)
	RTC_MODE2_TAMPCTRL_IN1ACT_OFF = 0x0
	// Wake and set Tamper flag
	RTC_MODE2_TAMPCTRL_IN1ACT_WAKE = 0x1
	// Capture timestamp and set Tamper flag
	RTC_MODE2_TAMPCTRL_IN1ACT_CAPTURE = 0x2
	// Compare IN1 to OUT. When a mismatch occurs, capture timestamp and set Tamper flag
	RTC_MODE2_TAMPCTRL_IN1ACT_ACTL = 0x3
	// Position of IN2ACT field.
	RTC_MODE2_TAMPCTRL_IN2ACT_Pos = 0x4
	// Bit mask of IN2ACT field.
	RTC_MODE2_TAMPCTRL_IN2ACT_Msk = 0x30
	// Off (Disabled)
	RTC_MODE2_TAMPCTRL_IN2ACT_OFF = 0x0
	// Wake and set Tamper flag
	RTC_MODE2_TAMPCTRL_IN2ACT_WAKE = 0x1
	// Capture timestamp and set Tamper flag
	RTC_MODE2_TAMPCTRL_IN2ACT_CAPTURE = 0x2
	// Compare IN2 to OUT. When a mismatch occurs, capture timestamp and set Tamper flag
	RTC_MODE2_TAMPCTRL_IN2ACT_ACTL = 0x3
	// Position of IN3ACT field.
	RTC_MODE2_TAMPCTRL_IN3ACT_Pos = 0x6
	// Bit mask of IN3ACT field.
	RTC_MODE2_TAMPCTRL_IN3ACT_Msk = 0xc0
	// Off (Disabled)
	RTC_MODE2_TAMPCTRL_IN3ACT_OFF = 0x0
	// Wake and set Tamper flag
	RTC_MODE2_TAMPCTRL_IN3ACT_WAKE = 0x1
	// Capture timestamp and set Tamper flag
	RTC_MODE2_TAMPCTRL_IN3ACT_CAPTURE = 0x2
	// Compare IN3 to OUT. When a mismatch occurs, capture timestamp and set Tamper flag
	RTC_MODE2_TAMPCTRL_IN3ACT_ACTL = 0x3
	// Position of TAMLVL0 field.
	RTC_MODE2_TAMPCTRL_TAMLVL0_Pos = 0x10
	// Bit mask of TAMLVL0 field.
	RTC_MODE2_TAMPCTRL_TAMLVL0_Msk = 0x10000
	// Bit TAMLVL0.
	RTC_MODE2_TAMPCTRL_TAMLVL0 = 0x10000
	// Position of TAMLVL1 field.
	RTC_MODE2_TAMPCTRL_TAMLVL1_Pos = 0x11
	// Bit mask of TAMLVL1 field.
	RTC_MODE2_TAMPCTRL_TAMLVL1_Msk = 0x20000
	// Bit TAMLVL1.
	RTC_MODE2_TAMPCTRL_TAMLVL1 = 0x20000
	// Position of TAMLVL2 field.
	RTC_MODE2_TAMPCTRL_TAMLVL2_Pos = 0x12
	// Bit mask of TAMLVL2 field.
	RTC_MODE2_TAMPCTRL_TAMLVL2_Msk = 0x40000
	// Bit TAMLVL2.
	RTC_MODE2_TAMPCTRL_TAMLVL2 = 0x40000
	// Position of TAMLVL3 field.
	RTC_MODE2_TAMPCTRL_TAMLVL3_Pos = 0x13
	// Bit mask of TAMLVL3 field.
	RTC_MODE2_TAMPCTRL_TAMLVL3_Msk = 0x80000
	// Bit TAMLVL3.
	RTC_MODE2_TAMPCTRL_TAMLVL3 = 0x80000
	// Position of DEBNC0 field.
	RTC_MODE2_TAMPCTRL_DEBNC0_Pos = 0x18
	// Bit mask of DEBNC0 field.
	RTC_MODE2_TAMPCTRL_DEBNC0_Msk = 0x1000000
	// Bit DEBNC0.
	RTC_MODE2_TAMPCTRL_DEBNC0 = 0x1000000
	// Position of DEBNC1 field.
	RTC_MODE2_TAMPCTRL_DEBNC1_Pos = 0x19
	// Bit mask of DEBNC1 field.
	RTC_MODE2_TAMPCTRL_DEBNC1_Msk = 0x2000000
	// Bit DEBNC1.
	RTC_MODE2_TAMPCTRL_DEBNC1 = 0x2000000
	// Position of DEBNC2 field.
	RTC_MODE2_TAMPCTRL_DEBNC2_Pos = 0x1a
	// Bit mask of DEBNC2 field.
	RTC_MODE2_TAMPCTRL_DEBNC2_Msk = 0x4000000
	// Bit DEBNC2.
	RTC_MODE2_TAMPCTRL_DEBNC2 = 0x4000000
	// Position of DEBNC3 field.
	RTC_MODE2_TAMPCTRL_DEBNC3_Pos = 0x1b
	// Bit mask of DEBNC3 field.
	RTC_MODE2_TAMPCTRL_DEBNC3_Msk = 0x8000000
	// Bit DEBNC3.
	RTC_MODE2_TAMPCTRL_DEBNC3 = 0x8000000

	// TIMESTAMP: MODE2 Timestamp
	// Position of SECOND field.
	RTC_MODE2_TIMESTAMP_SECOND_Pos = 0x0
	// Bit mask of SECOND field.
	RTC_MODE2_TIMESTAMP_SECOND_Msk = 0x3f
	// Position of MINUTE field.
	RTC_MODE2_TIMESTAMP_MINUTE_Pos = 0x6
	// Bit mask of MINUTE field.
	RTC_MODE2_TIMESTAMP_MINUTE_Msk = 0xfc0
	// Position of HOUR field.
	RTC_MODE2_TIMESTAMP_HOUR_Pos = 0xc
	// Bit mask of HOUR field.
	RTC_MODE2_TIMESTAMP_HOUR_Msk = 0x1f000
	// Position of DAY field.
	RTC_MODE2_TIMESTAMP_DAY_Pos = 0x11
	// Bit mask of DAY field.
	RTC_MODE2_TIMESTAMP_DAY_Msk = 0x3e0000
	// Position of MONTH field.
	RTC_MODE2_TIMESTAMP_MONTH_Pos = 0x16
	// Bit mask of MONTH field.
	RTC_MODE2_TIMESTAMP_MONTH_Msk = 0x3c00000
	// Position of YEAR field.
	RTC_MODE2_TIMESTAMP_YEAR_Pos = 0x1a
	// Bit mask of YEAR field.
	RTC_MODE2_TIMESTAMP_YEAR_Msk = 0xfc000000

	// TAMPID: Tamper ID
	// Position of TAMPID0 field.
	RTC_MODE2_TAMPID_TAMPID0_Pos = 0x0
	// Bit mask of TAMPID0 field.
	RTC_MODE2_TAMPID_TAMPID0_Msk = 0x1
	// Bit TAMPID0.
	RTC_MODE2_TAMPID_TAMPID0 = 0x1
	// Position of TAMPID1 field.
	RTC_MODE2_TAMPID_TAMPID1_Pos = 0x1
	// Bit mask of TAMPID1 field.
	RTC_MODE2_TAMPID_TAMPID1_Msk = 0x2
	// Bit TAMPID1.
	RTC_MODE2_TAMPID_TAMPID1 = 0x2
	// Position of TAMPID2 field.
	RTC_MODE2_TAMPID_TAMPID2_Pos = 0x2
	// Bit mask of TAMPID2 field.
	RTC_MODE2_TAMPID_TAMPID2_Msk = 0x4
	// Bit TAMPID2.
	RTC_MODE2_TAMPID_TAMPID2 = 0x4
	// Position of TAMPID3 field.
	RTC_MODE2_TAMPID_TAMPID3_Pos = 0x3
	// Bit mask of TAMPID3 field.
	RTC_MODE2_TAMPID_TAMPID3_Msk = 0x8
	// Bit TAMPID3.
	RTC_MODE2_TAMPID_TAMPID3 = 0x8
	// Position of TAMPEVT field.
	RTC_MODE2_TAMPID_TAMPEVT_Pos = 0x1f
	// Bit mask of TAMPEVT field.
	RTC_MODE2_TAMPID_TAMPEVT_Msk = 0x80000000
	// Bit TAMPEVT.
	RTC_MODE2_TAMPID_TAMPEVT = 0x80000000

	// TAMPCTRLB: Tamper Control B
	// Position of ALSI0 field.
	RTC_MODE2_TAMPCTRLB_ALSI0_Pos = 0x0
	// Bit mask of ALSI0 field.
	RTC_MODE2_TAMPCTRLB_ALSI0_Msk = 0x1
	// Bit ALSI0.
	RTC_MODE2_TAMPCTRLB_ALSI0 = 0x1
	// Position of ALSI1 field.
	RTC_MODE2_TAMPCTRLB_ALSI1_Pos = 0x1
	// Bit mask of ALSI1 field.
	RTC_MODE2_TAMPCTRLB_ALSI1_Msk = 0x2
	// Bit ALSI1.
	RTC_MODE2_TAMPCTRLB_ALSI1 = 0x2
	// Position of ALSI2 field.
	RTC_MODE2_TAMPCTRLB_ALSI2_Pos = 0x2
	// Bit mask of ALSI2 field.
	RTC_MODE2_TAMPCTRLB_ALSI2_Msk = 0x4
	// Bit ALSI2.
	RTC_MODE2_TAMPCTRLB_ALSI2 = 0x4
	// Position of ALSI3 field.
	RTC_MODE2_TAMPCTRLB_ALSI3_Pos = 0x3
	// Bit mask of ALSI3 field.
	RTC_MODE2_TAMPCTRLB_ALSI3_Msk = 0x8
	// Bit ALSI3.
	RTC_MODE2_TAMPCTRLB_ALSI3 = 0x8
)

// Constants for SERCOM0: Serial Communication Interface
const ()

// Constants for SERCOM0_I2CM: Serial Communication Interface - I2CM
const (
	// CTRLA: I2CM Control A
	// Position of SWRST field.
	SERCOM_I2CM_CTRLA_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	SERCOM_I2CM_CTRLA_SWRST_Msk = 0x1
	// Bit SWRST.
	SERCOM_I2CM_CTRLA_SWRST = 0x1
	// Position of ENABLE field.
	SERCOM_I2CM_CTRLA_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	SERCOM_I2CM_CTRLA_ENABLE_Msk = 0x2
	// Bit ENABLE.
	SERCOM_I2CM_CTRLA_ENABLE = 0x2
	// Position of MODE field.
	SERCOM_I2CM_CTRLA_MODE_Pos = 0x2
	// Bit mask of MODE field.
	SERCOM_I2CM_CTRLA_MODE_Msk = 0x1c
	// Position of RUNSTDBY field.
	SERCOM_I2CM_CTRLA_RUNSTDBY_Pos = 0x7
	// Bit mask of RUNSTDBY field.
	SERCOM_I2CM_CTRLA_RUNSTDBY_Msk = 0x80
	// Bit RUNSTDBY.
	SERCOM_I2CM_CTRLA_RUNSTDBY = 0x80
	// Position of PINOUT field.
	SERCOM_I2CM_CTRLA_PINOUT_Pos = 0x10
	// Bit mask of PINOUT field.
	SERCOM_I2CM_CTRLA_PINOUT_Msk = 0x10000
	// Bit PINOUT.
	SERCOM_I2CM_CTRLA_PINOUT = 0x10000
	// Position of SDAHOLD field.
	SERCOM_I2CM_CTRLA_SDAHOLD_Pos = 0x14
	// Bit mask of SDAHOLD field.
	SERCOM_I2CM_CTRLA_SDAHOLD_Msk = 0x300000
	// Position of MEXTTOEN field.
	SERCOM_I2CM_CTRLA_MEXTTOEN_Pos = 0x16
	// Bit mask of MEXTTOEN field.
	SERCOM_I2CM_CTRLA_MEXTTOEN_Msk = 0x400000
	// Bit MEXTTOEN.
	SERCOM_I2CM_CTRLA_MEXTTOEN = 0x400000
	// Position of SEXTTOEN field.
	SERCOM_I2CM_CTRLA_SEXTTOEN_Pos = 0x17
	// Bit mask of SEXTTOEN field.
	SERCOM_I2CM_CTRLA_SEXTTOEN_Msk = 0x800000
	// Bit SEXTTOEN.
	SERCOM_I2CM_CTRLA_SEXTTOEN = 0x800000
	// Position of SPEED field.
	SERCOM_I2CM_CTRLA_SPEED_Pos = 0x18
	// Bit mask of SPEED field.
	SERCOM_I2CM_CTRLA_SPEED_Msk = 0x3000000
	// Position of SCLSM field.
	SERCOM_I2CM_CTRLA_SCLSM_Pos = 0x1b
	// Bit mask of SCLSM field.
	SERCOM_I2CM_CTRLA_SCLSM_Msk = 0x8000000
	// Bit SCLSM.
	SERCOM_I2CM_CTRLA_SCLSM = 0x8000000
	// Position of INACTOUT field.
	SERCOM_I2CM_CTRLA_INACTOUT_Pos = 0x1c
	// Bit mask of INACTOUT field.
	SERCOM_I2CM_CTRLA_INACTOUT_Msk = 0x30000000
	// Position of LOWTOUTEN field.
	SERCOM_I2CM_CTRLA_LOWTOUTEN_Pos = 0x1e
	// Bit mask of LOWTOUTEN field.
	SERCOM_I2CM_CTRLA_LOWTOUTEN_Msk = 0x40000000
	// Bit LOWTOUTEN.
	SERCOM_I2CM_CTRLA_LOWTOUTEN = 0x40000000

	// CTRLB: I2CM Control B
	// Position of SMEN field.
	SERCOM_I2CM_CTRLB_SMEN_Pos = 0x8
	// Bit mask of SMEN field.
	SERCOM_I2CM_CTRLB_SMEN_Msk = 0x100
	// Bit SMEN.
	SERCOM_I2CM_CTRLB_SMEN = 0x100
	// Position of QCEN field.
	SERCOM_I2CM_CTRLB_QCEN_Pos = 0x9
	// Bit mask of QCEN field.
	SERCOM_I2CM_CTRLB_QCEN_Msk = 0x200
	// Bit QCEN.
	SERCOM_I2CM_CTRLB_QCEN = 0x200
	// Position of CMD field.
	SERCOM_I2CM_CTRLB_CMD_Pos = 0x10
	// Bit mask of CMD field.
	SERCOM_I2CM_CTRLB_CMD_Msk = 0x30000
	// Position of ACKACT field.
	SERCOM_I2CM_CTRLB_ACKACT_Pos = 0x12
	// Bit mask of ACKACT field.
	SERCOM_I2CM_CTRLB_ACKACT_Msk = 0x40000
	// Bit ACKACT.
	SERCOM_I2CM_CTRLB_ACKACT = 0x40000

	// BAUD: I2CM Baud Rate
	// Position of BAUD field.
	SERCOM_I2CM_BAUD_BAUD_Pos = 0x0
	// Bit mask of BAUD field.
	SERCOM_I2CM_BAUD_BAUD_Msk = 0xff
	// Position of BAUDLOW field.
	SERCOM_I2CM_BAUD_BAUDLOW_Pos = 0x8
	// Bit mask of BAUDLOW field.
	SERCOM_I2CM_BAUD_BAUDLOW_Msk = 0xff00
	// Position of HSBAUD field.
	SERCOM_I2CM_BAUD_HSBAUD_Pos = 0x10
	// Bit mask of HSBAUD field.
	SERCOM_I2CM_BAUD_HSBAUD_Msk = 0xff0000
	// Position of HSBAUDLOW field.
	SERCOM_I2CM_BAUD_HSBAUDLOW_Pos = 0x18
	// Bit mask of HSBAUDLOW field.
	SERCOM_I2CM_BAUD_HSBAUDLOW_Msk = 0xff000000

	// INTENCLR: I2CM Interrupt Enable Clear
	// Position of MB field.
	SERCOM_I2CM_INTENCLR_MB_Pos = 0x0
	// Bit mask of MB field.
	SERCOM_I2CM_INTENCLR_MB_Msk = 0x1
	// Bit MB.
	SERCOM_I2CM_INTENCLR_MB = 0x1
	// Position of SB field.
	SERCOM_I2CM_INTENCLR_SB_Pos = 0x1
	// Bit mask of SB field.
	SERCOM_I2CM_INTENCLR_SB_Msk = 0x2
	// Bit SB.
	SERCOM_I2CM_INTENCLR_SB = 0x2
	// Position of ERROR field.
	SERCOM_I2CM_INTENCLR_ERROR_Pos = 0x7
	// Bit mask of ERROR field.
	SERCOM_I2CM_INTENCLR_ERROR_Msk = 0x80
	// Bit ERROR.
	SERCOM_I2CM_INTENCLR_ERROR = 0x80

	// INTENSET: I2CM Interrupt Enable Set
	// Position of MB field.
	SERCOM_I2CM_INTENSET_MB_Pos = 0x0
	// Bit mask of MB field.
	SERCOM_I2CM_INTENSET_MB_Msk = 0x1
	// Bit MB.
	SERCOM_I2CM_INTENSET_MB = 0x1
	// Position of SB field.
	SERCOM_I2CM_INTENSET_SB_Pos = 0x1
	// Bit mask of SB field.
	SERCOM_I2CM_INTENSET_SB_Msk = 0x2
	// Bit SB.
	SERCOM_I2CM_INTENSET_SB = 0x2
	// Position of ERROR field.
	SERCOM_I2CM_INTENSET_ERROR_Pos = 0x7
	// Bit mask of ERROR field.
	SERCOM_I2CM_INTENSET_ERROR_Msk = 0x80
	// Bit ERROR.
	SERCOM_I2CM_INTENSET_ERROR = 0x80

	// INTFLAG: I2CM Interrupt Flag Status and Clear
	// Position of MB field.
	SERCOM_I2CM_INTFLAG_MB_Pos = 0x0
	// Bit mask of MB field.
	SERCOM_I2CM_INTFLAG_MB_Msk = 0x1
	// Bit MB.
	SERCOM_I2CM_INTFLAG_MB = 0x1
	// Position of SB field.
	SERCOM_I2CM_INTFLAG_SB_Pos = 0x1
	// Bit mask of SB field.
	SERCOM_I2CM_INTFLAG_SB_Msk = 0x2
	// Bit SB.
	SERCOM_I2CM_INTFLAG_SB = 0x2
	// Position of ERROR field.
	SERCOM_I2CM_INTFLAG_ERROR_Pos = 0x7
	// Bit mask of ERROR field.
	SERCOM_I2CM_INTFLAG_ERROR_Msk = 0x80
	// Bit ERROR.
	SERCOM_I2CM_INTFLAG_ERROR = 0x80

	// STATUS: I2CM Status
	// Position of BUSERR field.
	SERCOM_I2CM_STATUS_BUSERR_Pos = 0x0
	// Bit mask of BUSERR field.
	SERCOM_I2CM_STATUS_BUSERR_Msk = 0x1
	// Bit BUSERR.
	SERCOM_I2CM_STATUS_BUSERR = 0x1
	// Position of ARBLOST field.
	SERCOM_I2CM_STATUS_ARBLOST_Pos = 0x1
	// Bit mask of ARBLOST field.
	SERCOM_I2CM_STATUS_ARBLOST_Msk = 0x2
	// Bit ARBLOST.
	SERCOM_I2CM_STATUS_ARBLOST = 0x2
	// Position of RXNACK field.
	SERCOM_I2CM_STATUS_RXNACK_Pos = 0x2
	// Bit mask of RXNACK field.
	SERCOM_I2CM_STATUS_RXNACK_Msk = 0x4
	// Bit RXNACK.
	SERCOM_I2CM_STATUS_RXNACK = 0x4
	// Position of BUSSTATE field.
	SERCOM_I2CM_STATUS_BUSSTATE_Pos = 0x4
	// Bit mask of BUSSTATE field.
	SERCOM_I2CM_STATUS_BUSSTATE_Msk = 0x30
	// Position of LOWTOUT field.
	SERCOM_I2CM_STATUS_LOWTOUT_Pos = 0x6
	// Bit mask of LOWTOUT field.
	SERCOM_I2CM_STATUS_LOWTOUT_Msk = 0x40
	// Bit LOWTOUT.
	SERCOM_I2CM_STATUS_LOWTOUT = 0x40
	// Position of CLKHOLD field.
	SERCOM_I2CM_STATUS_CLKHOLD_Pos = 0x7
	// Bit mask of CLKHOLD field.
	SERCOM_I2CM_STATUS_CLKHOLD_Msk = 0x80
	// Bit CLKHOLD.
	SERCOM_I2CM_STATUS_CLKHOLD = 0x80
	// Position of MEXTTOUT field.
	SERCOM_I2CM_STATUS_MEXTTOUT_Pos = 0x8
	// Bit mask of MEXTTOUT field.
	SERCOM_I2CM_STATUS_MEXTTOUT_Msk = 0x100
	// Bit MEXTTOUT.
	SERCOM_I2CM_STATUS_MEXTTOUT = 0x100
	// Position of SEXTTOUT field.
	SERCOM_I2CM_STATUS_SEXTTOUT_Pos = 0x9
	// Bit mask of SEXTTOUT field.
	SERCOM_I2CM_STATUS_SEXTTOUT_Msk = 0x200
	// Bit SEXTTOUT.
	SERCOM_I2CM_STATUS_SEXTTOUT = 0x200
	// Position of LENERR field.
	SERCOM_I2CM_STATUS_LENERR_Pos = 0xa
	// Bit mask of LENERR field.
	SERCOM_I2CM_STATUS_LENERR_Msk = 0x400
	// Bit LENERR.
	SERCOM_I2CM_STATUS_LENERR = 0x400

	// SYNCBUSY: I2CM Synchronization Busy
	// Position of SWRST field.
	SERCOM_I2CM_SYNCBUSY_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	SERCOM_I2CM_SYNCBUSY_SWRST_Msk = 0x1
	// Bit SWRST.
	SERCOM_I2CM_SYNCBUSY_SWRST = 0x1
	// Position of ENABLE field.
	SERCOM_I2CM_SYNCBUSY_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	SERCOM_I2CM_SYNCBUSY_ENABLE_Msk = 0x2
	// Bit ENABLE.
	SERCOM_I2CM_SYNCBUSY_ENABLE = 0x2
	// Position of SYSOP field.
	SERCOM_I2CM_SYNCBUSY_SYSOP_Pos = 0x2
	// Bit mask of SYSOP field.
	SERCOM_I2CM_SYNCBUSY_SYSOP_Msk = 0x4
	// Bit SYSOP.
	SERCOM_I2CM_SYNCBUSY_SYSOP = 0x4

	// ADDR: I2CM Address
	// Position of ADDR field.
	SERCOM_I2CM_ADDR_ADDR_Pos = 0x0
	// Bit mask of ADDR field.
	SERCOM_I2CM_ADDR_ADDR_Msk = 0x7ff
	// Position of LENEN field.
	SERCOM_I2CM_ADDR_LENEN_Pos = 0xd
	// Bit mask of LENEN field.
	SERCOM_I2CM_ADDR_LENEN_Msk = 0x2000
	// Bit LENEN.
	SERCOM_I2CM_ADDR_LENEN = 0x2000
	// Position of HS field.
	SERCOM_I2CM_ADDR_HS_Pos = 0xe
	// Bit mask of HS field.
	SERCOM_I2CM_ADDR_HS_Msk = 0x4000
	// Bit HS.
	SERCOM_I2CM_ADDR_HS = 0x4000
	// Position of TENBITEN field.
	SERCOM_I2CM_ADDR_TENBITEN_Pos = 0xf
	// Bit mask of TENBITEN field.
	SERCOM_I2CM_ADDR_TENBITEN_Msk = 0x8000
	// Bit TENBITEN.
	SERCOM_I2CM_ADDR_TENBITEN = 0x8000
	// Position of LEN field.
	SERCOM_I2CM_ADDR_LEN_Pos = 0x10
	// Bit mask of LEN field.
	SERCOM_I2CM_ADDR_LEN_Msk = 0xff0000

	// DATA: I2CM Data
	// Position of DATA field.
	SERCOM_I2CM_DATA_DATA_Pos = 0x0
	// Bit mask of DATA field.
	SERCOM_I2CM_DATA_DATA_Msk = 0xff

	// DBGCTRL: I2CM Debug Control
	// Position of DBGSTOP field.
	SERCOM_I2CM_DBGCTRL_DBGSTOP_Pos = 0x0
	// Bit mask of DBGSTOP field.
	SERCOM_I2CM_DBGCTRL_DBGSTOP_Msk = 0x1
	// Bit DBGSTOP.
	SERCOM_I2CM_DBGCTRL_DBGSTOP = 0x1
)

// Constants for SERCOM0_I2CS: Serial Communication Interface - I2CS
const (
	// CTRLA: I2CS Control A
	// Position of SWRST field.
	SERCOM_I2CS_CTRLA_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	SERCOM_I2CS_CTRLA_SWRST_Msk = 0x1
	// Bit SWRST.
	SERCOM_I2CS_CTRLA_SWRST = 0x1
	// Position of ENABLE field.
	SERCOM_I2CS_CTRLA_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	SERCOM_I2CS_CTRLA_ENABLE_Msk = 0x2
	// Bit ENABLE.
	SERCOM_I2CS_CTRLA_ENABLE = 0x2
	// Position of MODE field.
	SERCOM_I2CS_CTRLA_MODE_Pos = 0x2
	// Bit mask of MODE field.
	SERCOM_I2CS_CTRLA_MODE_Msk = 0x1c
	// Position of RUNSTDBY field.
	SERCOM_I2CS_CTRLA_RUNSTDBY_Pos = 0x7
	// Bit mask of RUNSTDBY field.
	SERCOM_I2CS_CTRLA_RUNSTDBY_Msk = 0x80
	// Bit RUNSTDBY.
	SERCOM_I2CS_CTRLA_RUNSTDBY = 0x80
	// Position of PINOUT field.
	SERCOM_I2CS_CTRLA_PINOUT_Pos = 0x10
	// Bit mask of PINOUT field.
	SERCOM_I2CS_CTRLA_PINOUT_Msk = 0x10000
	// Bit PINOUT.
	SERCOM_I2CS_CTRLA_PINOUT = 0x10000
	// Position of SDAHOLD field.
	SERCOM_I2CS_CTRLA_SDAHOLD_Pos = 0x14
	// Bit mask of SDAHOLD field.
	SERCOM_I2CS_CTRLA_SDAHOLD_Msk = 0x300000
	// Position of SEXTTOEN field.
	SERCOM_I2CS_CTRLA_SEXTTOEN_Pos = 0x17
	// Bit mask of SEXTTOEN field.
	SERCOM_I2CS_CTRLA_SEXTTOEN_Msk = 0x800000
	// Bit SEXTTOEN.
	SERCOM_I2CS_CTRLA_SEXTTOEN = 0x800000
	// Position of SPEED field.
	SERCOM_I2CS_CTRLA_SPEED_Pos = 0x18
	// Bit mask of SPEED field.
	SERCOM_I2CS_CTRLA_SPEED_Msk = 0x3000000
	// Position of SCLSM field.
	SERCOM_I2CS_CTRLA_SCLSM_Pos = 0x1b
	// Bit mask of SCLSM field.
	SERCOM_I2CS_CTRLA_SCLSM_Msk = 0x8000000
	// Bit SCLSM.
	SERCOM_I2CS_CTRLA_SCLSM = 0x8000000
	// Position of LOWTOUTEN field.
	SERCOM_I2CS_CTRLA_LOWTOUTEN_Pos = 0x1e
	// Bit mask of LOWTOUTEN field.
	SERCOM_I2CS_CTRLA_LOWTOUTEN_Msk = 0x40000000
	// Bit LOWTOUTEN.
	SERCOM_I2CS_CTRLA_LOWTOUTEN = 0x40000000

	// CTRLB: I2CS Control B
	// Position of SMEN field.
	SERCOM_I2CS_CTRLB_SMEN_Pos = 0x8
	// Bit mask of SMEN field.
	SERCOM_I2CS_CTRLB_SMEN_Msk = 0x100
	// Bit SMEN.
	SERCOM_I2CS_CTRLB_SMEN = 0x100
	// Position of GCMD field.
	SERCOM_I2CS_CTRLB_GCMD_Pos = 0x9
	// Bit mask of GCMD field.
	SERCOM_I2CS_CTRLB_GCMD_Msk = 0x200
	// Bit GCMD.
	SERCOM_I2CS_CTRLB_GCMD = 0x200
	// Position of AACKEN field.
	SERCOM_I2CS_CTRLB_AACKEN_Pos = 0xa
	// Bit mask of AACKEN field.
	SERCOM_I2CS_CTRLB_AACKEN_Msk = 0x400
	// Bit AACKEN.
	SERCOM_I2CS_CTRLB_AACKEN = 0x400
	// Position of AMODE field.
	SERCOM_I2CS_CTRLB_AMODE_Pos = 0xe
	// Bit mask of AMODE field.
	SERCOM_I2CS_CTRLB_AMODE_Msk = 0xc000
	// Position of CMD field.
	SERCOM_I2CS_CTRLB_CMD_Pos = 0x10
	// Bit mask of CMD field.
	SERCOM_I2CS_CTRLB_CMD_Msk = 0x30000
	// Position of ACKACT field.
	SERCOM_I2CS_CTRLB_ACKACT_Pos = 0x12
	// Bit mask of ACKACT field.
	SERCOM_I2CS_CTRLB_ACKACT_Msk = 0x40000
	// Bit ACKACT.
	SERCOM_I2CS_CTRLB_ACKACT = 0x40000

	// INTENCLR: I2CS Interrupt Enable Clear
	// Position of PREC field.
	SERCOM_I2CS_INTENCLR_PREC_Pos = 0x0
	// Bit mask of PREC field.
	SERCOM_I2CS_INTENCLR_PREC_Msk = 0x1
	// Bit PREC.
	SERCOM_I2CS_INTENCLR_PREC = 0x1
	// Position of AMATCH field.
	SERCOM_I2CS_INTENCLR_AMATCH_Pos = 0x1
	// Bit mask of AMATCH field.
	SERCOM_I2CS_INTENCLR_AMATCH_Msk = 0x2
	// Bit AMATCH.
	SERCOM_I2CS_INTENCLR_AMATCH = 0x2
	// Position of DRDY field.
	SERCOM_I2CS_INTENCLR_DRDY_Pos = 0x2
	// Bit mask of DRDY field.
	SERCOM_I2CS_INTENCLR_DRDY_Msk = 0x4
	// Bit DRDY.
	SERCOM_I2CS_INTENCLR_DRDY = 0x4
	// Position of ERROR field.
	SERCOM_I2CS_INTENCLR_ERROR_Pos = 0x7
	// Bit mask of ERROR field.
	SERCOM_I2CS_INTENCLR_ERROR_Msk = 0x80
	// Bit ERROR.
	SERCOM_I2CS_INTENCLR_ERROR = 0x80

	// INTENSET: I2CS Interrupt Enable Set
	// Position of PREC field.
	SERCOM_I2CS_INTENSET_PREC_Pos = 0x0
	// Bit mask of PREC field.
	SERCOM_I2CS_INTENSET_PREC_Msk = 0x1
	// Bit PREC.
	SERCOM_I2CS_INTENSET_PREC = 0x1
	// Position of AMATCH field.
	SERCOM_I2CS_INTENSET_AMATCH_Pos = 0x1
	// Bit mask of AMATCH field.
	SERCOM_I2CS_INTENSET_AMATCH_Msk = 0x2
	// Bit AMATCH.
	SERCOM_I2CS_INTENSET_AMATCH = 0x2
	// Position of DRDY field.
	SERCOM_I2CS_INTENSET_DRDY_Pos = 0x2
	// Bit mask of DRDY field.
	SERCOM_I2CS_INTENSET_DRDY_Msk = 0x4
	// Bit DRDY.
	SERCOM_I2CS_INTENSET_DRDY = 0x4
	// Position of ERROR field.
	SERCOM_I2CS_INTENSET_ERROR_Pos = 0x7
	// Bit mask of ERROR field.
	SERCOM_I2CS_INTENSET_ERROR_Msk = 0x80
	// Bit ERROR.
	SERCOM_I2CS_INTENSET_ERROR = 0x80

	// INTFLAG: I2CS Interrupt Flag Status and Clear
	// Position of PREC field.
	SERCOM_I2CS_INTFLAG_PREC_Pos = 0x0
	// Bit mask of PREC field.
	SERCOM_I2CS_INTFLAG_PREC_Msk = 0x1
	// Bit PREC.
	SERCOM_I2CS_INTFLAG_PREC = 0x1
	// Position of AMATCH field.
	SERCOM_I2CS_INTFLAG_AMATCH_Pos = 0x1
	// Bit mask of AMATCH field.
	SERCOM_I2CS_INTFLAG_AMATCH_Msk = 0x2
	// Bit AMATCH.
	SERCOM_I2CS_INTFLAG_AMATCH = 0x2
	// Position of DRDY field.
	SERCOM_I2CS_INTFLAG_DRDY_Pos = 0x2
	// Bit mask of DRDY field.
	SERCOM_I2CS_INTFLAG_DRDY_Msk = 0x4
	// Bit DRDY.
	SERCOM_I2CS_INTFLAG_DRDY = 0x4
	// Position of ERROR field.
	SERCOM_I2CS_INTFLAG_ERROR_Pos = 0x7
	// Bit mask of ERROR field.
	SERCOM_I2CS_INTFLAG_ERROR_Msk = 0x80
	// Bit ERROR.
	SERCOM_I2CS_INTFLAG_ERROR = 0x80

	// STATUS: I2CS Status
	// Position of BUSERR field.
	SERCOM_I2CS_STATUS_BUSERR_Pos = 0x0
	// Bit mask of BUSERR field.
	SERCOM_I2CS_STATUS_BUSERR_Msk = 0x1
	// Bit BUSERR.
	SERCOM_I2CS_STATUS_BUSERR = 0x1
	// Position of COLL field.
	SERCOM_I2CS_STATUS_COLL_Pos = 0x1
	// Bit mask of COLL field.
	SERCOM_I2CS_STATUS_COLL_Msk = 0x2
	// Bit COLL.
	SERCOM_I2CS_STATUS_COLL = 0x2
	// Position of RXNACK field.
	SERCOM_I2CS_STATUS_RXNACK_Pos = 0x2
	// Bit mask of RXNACK field.
	SERCOM_I2CS_STATUS_RXNACK_Msk = 0x4
	// Bit RXNACK.
	SERCOM_I2CS_STATUS_RXNACK = 0x4
	// Position of DIR field.
	SERCOM_I2CS_STATUS_DIR_Pos = 0x3
	// Bit mask of DIR field.
	SERCOM_I2CS_STATUS_DIR_Msk = 0x8
	// Bit DIR.
	SERCOM_I2CS_STATUS_DIR = 0x8
	// Position of SR field.
	SERCOM_I2CS_STATUS_SR_Pos = 0x4
	// Bit mask of SR field.
	SERCOM_I2CS_STATUS_SR_Msk = 0x10
	// Bit SR.
	SERCOM_I2CS_STATUS_SR = 0x10
	// Position of LOWTOUT field.
	SERCOM_I2CS_STATUS_LOWTOUT_Pos = 0x6
	// Bit mask of LOWTOUT field.
	SERCOM_I2CS_STATUS_LOWTOUT_Msk = 0x40
	// Bit LOWTOUT.
	SERCOM_I2CS_STATUS_LOWTOUT = 0x40
	// Position of CLKHOLD field.
	SERCOM_I2CS_STATUS_CLKHOLD_Pos = 0x7
	// Bit mask of CLKHOLD field.
	SERCOM_I2CS_STATUS_CLKHOLD_Msk = 0x80
	// Bit CLKHOLD.
	SERCOM_I2CS_STATUS_CLKHOLD = 0x80
	// Position of SEXTTOUT field.
	SERCOM_I2CS_STATUS_SEXTTOUT_Pos = 0x9
	// Bit mask of SEXTTOUT field.
	SERCOM_I2CS_STATUS_SEXTTOUT_Msk = 0x200
	// Bit SEXTTOUT.
	SERCOM_I2CS_STATUS_SEXTTOUT = 0x200
	// Position of HS field.
	SERCOM_I2CS_STATUS_HS_Pos = 0xa
	// Bit mask of HS field.
	SERCOM_I2CS_STATUS_HS_Msk = 0x400
	// Bit HS.
	SERCOM_I2CS_STATUS_HS = 0x400

	// SYNCBUSY: I2CS Synchronization Busy
	// Position of SWRST field.
	SERCOM_I2CS_SYNCBUSY_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	SERCOM_I2CS_SYNCBUSY_SWRST_Msk = 0x1
	// Bit SWRST.
	SERCOM_I2CS_SYNCBUSY_SWRST = 0x1
	// Position of ENABLE field.
	SERCOM_I2CS_SYNCBUSY_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	SERCOM_I2CS_SYNCBUSY_ENABLE_Msk = 0x2
	// Bit ENABLE.
	SERCOM_I2CS_SYNCBUSY_ENABLE = 0x2

	// ADDR: I2CS Address
	// Position of GENCEN field.
	SERCOM_I2CS_ADDR_GENCEN_Pos = 0x0
	// Bit mask of GENCEN field.
	SERCOM_I2CS_ADDR_GENCEN_Msk = 0x1
	// Bit GENCEN.
	SERCOM_I2CS_ADDR_GENCEN = 0x1
	// Position of ADDR field.
	SERCOM_I2CS_ADDR_ADDR_Pos = 0x1
	// Bit mask of ADDR field.
	SERCOM_I2CS_ADDR_ADDR_Msk = 0x7fe
	// Position of TENBITEN field.
	SERCOM_I2CS_ADDR_TENBITEN_Pos = 0xf
	// Bit mask of TENBITEN field.
	SERCOM_I2CS_ADDR_TENBITEN_Msk = 0x8000
	// Bit TENBITEN.
	SERCOM_I2CS_ADDR_TENBITEN = 0x8000
	// Position of ADDRMASK field.
	SERCOM_I2CS_ADDR_ADDRMASK_Pos = 0x11
	// Bit mask of ADDRMASK field.
	SERCOM_I2CS_ADDR_ADDRMASK_Msk = 0x7fe0000

	// DATA: I2CS Data
	// Position of DATA field.
	SERCOM_I2CS_DATA_DATA_Pos = 0x0
	// Bit mask of DATA field.
	SERCOM_I2CS_DATA_DATA_Msk = 0xff
)

// Constants for SERCOM0_SPI: Serial Communication Interface - SPI
const (
	// CTRLA: SPI Control A
	// Position of SWRST field.
	SERCOM_SPI_CTRLA_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	SERCOM_SPI_CTRLA_SWRST_Msk = 0x1
	// Bit SWRST.
	SERCOM_SPI_CTRLA_SWRST = 0x1
	// Position of ENABLE field.
	SERCOM_SPI_CTRLA_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	SERCOM_SPI_CTRLA_ENABLE_Msk = 0x2
	// Bit ENABLE.
	SERCOM_SPI_CTRLA_ENABLE = 0x2
	// Position of MODE field.
	SERCOM_SPI_CTRLA_MODE_Pos = 0x2
	// Bit mask of MODE field.
	SERCOM_SPI_CTRLA_MODE_Msk = 0x1c
	// Position of RUNSTDBY field.
	SERCOM_SPI_CTRLA_RUNSTDBY_Pos = 0x7
	// Bit mask of RUNSTDBY field.
	SERCOM_SPI_CTRLA_RUNSTDBY_Msk = 0x80
	// Bit RUNSTDBY.
	SERCOM_SPI_CTRLA_RUNSTDBY = 0x80
	// Position of IBON field.
	SERCOM_SPI_CTRLA_IBON_Pos = 0x8
	// Bit mask of IBON field.
	SERCOM_SPI_CTRLA_IBON_Msk = 0x100
	// Bit IBON.
	SERCOM_SPI_CTRLA_IBON = 0x100
	// Position of DOPO field.
	SERCOM_SPI_CTRLA_DOPO_Pos = 0x10
	// Bit mask of DOPO field.
	SERCOM_SPI_CTRLA_DOPO_Msk = 0x30000
	// Position of DIPO field.
	SERCOM_SPI_CTRLA_DIPO_Pos = 0x14
	// Bit mask of DIPO field.
	SERCOM_SPI_CTRLA_DIPO_Msk = 0x300000
	// Position of FORM field.
	SERCOM_SPI_CTRLA_FORM_Pos = 0x18
	// Bit mask of FORM field.
	SERCOM_SPI_CTRLA_FORM_Msk = 0xf000000
	// Position of CPHA field.
	SERCOM_SPI_CTRLA_CPHA_Pos = 0x1c
	// Bit mask of CPHA field.
	SERCOM_SPI_CTRLA_CPHA_Msk = 0x10000000
	// Bit CPHA.
	SERCOM_SPI_CTRLA_CPHA = 0x10000000
	// Position of CPOL field.
	SERCOM_SPI_CTRLA_CPOL_Pos = 0x1d
	// Bit mask of CPOL field.
	SERCOM_SPI_CTRLA_CPOL_Msk = 0x20000000
	// Bit CPOL.
	SERCOM_SPI_CTRLA_CPOL = 0x20000000
	// Position of DORD field.
	SERCOM_SPI_CTRLA_DORD_Pos = 0x1e
	// Bit mask of DORD field.
	SERCOM_SPI_CTRLA_DORD_Msk = 0x40000000
	// Bit DORD.
	SERCOM_SPI_CTRLA_DORD = 0x40000000

	// CTRLB: SPI Control B
	// Position of CHSIZE field.
	SERCOM_SPI_CTRLB_CHSIZE_Pos = 0x0
	// Bit mask of CHSIZE field.
	SERCOM_SPI_CTRLB_CHSIZE_Msk = 0x7
	// Position of PLOADEN field.
	SERCOM_SPI_CTRLB_PLOADEN_Pos = 0x6
	// Bit mask of PLOADEN field.
	SERCOM_SPI_CTRLB_PLOADEN_Msk = 0x40
	// Bit PLOADEN.
	SERCOM_SPI_CTRLB_PLOADEN = 0x40
	// Position of SSDE field.
	SERCOM_SPI_CTRLB_SSDE_Pos = 0x9
	// Bit mask of SSDE field.
	SERCOM_SPI_CTRLB_SSDE_Msk = 0x200
	// Bit SSDE.
	SERCOM_SPI_CTRLB_SSDE = 0x200
	// Position of MSSEN field.
	SERCOM_SPI_CTRLB_MSSEN_Pos = 0xd
	// Bit mask of MSSEN field.
	SERCOM_SPI_CTRLB_MSSEN_Msk = 0x2000
	// Bit MSSEN.
	SERCOM_SPI_CTRLB_MSSEN = 0x2000
	// Position of AMODE field.
	SERCOM_SPI_CTRLB_AMODE_Pos = 0xe
	// Bit mask of AMODE field.
	SERCOM_SPI_CTRLB_AMODE_Msk = 0xc000
	// Position of RXEN field.
	SERCOM_SPI_CTRLB_RXEN_Pos = 0x11
	// Bit mask of RXEN field.
	SERCOM_SPI_CTRLB_RXEN_Msk = 0x20000
	// Bit RXEN.
	SERCOM_SPI_CTRLB_RXEN = 0x20000

	// BAUD: SPI Baud Rate
	// Position of BAUD field.
	SERCOM_SPI_BAUD_BAUD_Pos = 0x0
	// Bit mask of BAUD field.
	SERCOM_SPI_BAUD_BAUD_Msk = 0xff

	// INTENCLR: SPI Interrupt Enable Clear
	// Position of DRE field.
	SERCOM_SPI_INTENCLR_DRE_Pos = 0x0
	// Bit mask of DRE field.
	SERCOM_SPI_INTENCLR_DRE_Msk = 0x1
	// Bit DRE.
	SERCOM_SPI_INTENCLR_DRE = 0x1
	// Position of TXC field.
	SERCOM_SPI_INTENCLR_TXC_Pos = 0x1
	// Bit mask of TXC field.
	SERCOM_SPI_INTENCLR_TXC_Msk = 0x2
	// Bit TXC.
	SERCOM_SPI_INTENCLR_TXC = 0x2
	// Position of RXC field.
	SERCOM_SPI_INTENCLR_RXC_Pos = 0x2
	// Bit mask of RXC field.
	SERCOM_SPI_INTENCLR_RXC_Msk = 0x4
	// Bit RXC.
	SERCOM_SPI_INTENCLR_RXC = 0x4
	// Position of SSL field.
	SERCOM_SPI_INTENCLR_SSL_Pos = 0x3
	// Bit mask of SSL field.
	SERCOM_SPI_INTENCLR_SSL_Msk = 0x8
	// Bit SSL.
	SERCOM_SPI_INTENCLR_SSL = 0x8
	// Position of ERROR field.
	SERCOM_SPI_INTENCLR_ERROR_Pos = 0x7
	// Bit mask of ERROR field.
	SERCOM_SPI_INTENCLR_ERROR_Msk = 0x80
	// Bit ERROR.
	SERCOM_SPI_INTENCLR_ERROR = 0x80

	// INTENSET: SPI Interrupt Enable Set
	// Position of DRE field.
	SERCOM_SPI_INTENSET_DRE_Pos = 0x0
	// Bit mask of DRE field.
	SERCOM_SPI_INTENSET_DRE_Msk = 0x1
	// Bit DRE.
	SERCOM_SPI_INTENSET_DRE = 0x1
	// Position of TXC field.
	SERCOM_SPI_INTENSET_TXC_Pos = 0x1
	// Bit mask of TXC field.
	SERCOM_SPI_INTENSET_TXC_Msk = 0x2
	// Bit TXC.
	SERCOM_SPI_INTENSET_TXC = 0x2
	// Position of RXC field.
	SERCOM_SPI_INTENSET_RXC_Pos = 0x2
	// Bit mask of RXC field.
	SERCOM_SPI_INTENSET_RXC_Msk = 0x4
	// Bit RXC.
	SERCOM_SPI_INTENSET_RXC = 0x4
	// Position of SSL field.
	SERCOM_SPI_INTENSET_SSL_Pos = 0x3
	// Bit mask of SSL field.
	SERCOM_SPI_INTENSET_SSL_Msk = 0x8
	// Bit SSL.
	SERCOM_SPI_INTENSET_SSL = 0x8
	// Position of ERROR field.
	SERCOM_SPI_INTENSET_ERROR_Pos = 0x7
	// Bit mask of ERROR field.
	SERCOM_SPI_INTENSET_ERROR_Msk = 0x80
	// Bit ERROR.
	SERCOM_SPI_INTENSET_ERROR = 0x80

	// INTFLAG: SPI Interrupt Flag Status and Clear
	// Position of DRE field.
	SERCOM_SPI_INTFLAG_DRE_Pos = 0x0
	// Bit mask of DRE field.
	SERCOM_SPI_INTFLAG_DRE_Msk = 0x1
	// Bit DRE.
	SERCOM_SPI_INTFLAG_DRE = 0x1
	// Position of TXC field.
	SERCOM_SPI_INTFLAG_TXC_Pos = 0x1
	// Bit mask of TXC field.
	SERCOM_SPI_INTFLAG_TXC_Msk = 0x2
	// Bit TXC.
	SERCOM_SPI_INTFLAG_TXC = 0x2
	// Position of RXC field.
	SERCOM_SPI_INTFLAG_RXC_Pos = 0x2
	// Bit mask of RXC field.
	SERCOM_SPI_INTFLAG_RXC_Msk = 0x4
	// Bit RXC.
	SERCOM_SPI_INTFLAG_RXC = 0x4
	// Position of SSL field.
	SERCOM_SPI_INTFLAG_SSL_Pos = 0x3
	// Bit mask of SSL field.
	SERCOM_SPI_INTFLAG_SSL_Msk = 0x8
	// Bit SSL.
	SERCOM_SPI_INTFLAG_SSL = 0x8
	// Position of ERROR field.
	SERCOM_SPI_INTFLAG_ERROR_Pos = 0x7
	// Bit mask of ERROR field.
	SERCOM_SPI_INTFLAG_ERROR_Msk = 0x80
	// Bit ERROR.
	SERCOM_SPI_INTFLAG_ERROR = 0x80

	// STATUS: SPI Status
	// Position of BUFOVF field.
	SERCOM_SPI_STATUS_BUFOVF_Pos = 0x2
	// Bit mask of BUFOVF field.
	SERCOM_SPI_STATUS_BUFOVF_Msk = 0x4
	// Bit BUFOVF.
	SERCOM_SPI_STATUS_BUFOVF = 0x4

	// SYNCBUSY: SPI Synchronization Busy
	// Position of SWRST field.
	SERCOM_SPI_SYNCBUSY_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	SERCOM_SPI_SYNCBUSY_SWRST_Msk = 0x1
	// Bit SWRST.
	SERCOM_SPI_SYNCBUSY_SWRST = 0x1
	// Position of ENABLE field.
	SERCOM_SPI_SYNCBUSY_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	SERCOM_SPI_SYNCBUSY_ENABLE_Msk = 0x2
	// Bit ENABLE.
	SERCOM_SPI_SYNCBUSY_ENABLE = 0x2
	// Position of CTRLB field.
	SERCOM_SPI_SYNCBUSY_CTRLB_Pos = 0x2
	// Bit mask of CTRLB field.
	SERCOM_SPI_SYNCBUSY_CTRLB_Msk = 0x4
	// Bit CTRLB.
	SERCOM_SPI_SYNCBUSY_CTRLB = 0x4

	// ADDR: SPI Address
	// Position of ADDR field.
	SERCOM_SPI_ADDR_ADDR_Pos = 0x0
	// Bit mask of ADDR field.
	SERCOM_SPI_ADDR_ADDR_Msk = 0xff
	// Position of ADDRMASK field.
	SERCOM_SPI_ADDR_ADDRMASK_Pos = 0x10
	// Bit mask of ADDRMASK field.
	SERCOM_SPI_ADDR_ADDRMASK_Msk = 0xff0000

	// DATA: SPI Data
	// Position of DATA field.
	SERCOM_SPI_DATA_DATA_Pos = 0x0
	// Bit mask of DATA field.
	SERCOM_SPI_DATA_DATA_Msk = 0x1ff

	// DBGCTRL: SPI Debug Control
	// Position of DBGSTOP field.
	SERCOM_SPI_DBGCTRL_DBGSTOP_Pos = 0x0
	// Bit mask of DBGSTOP field.
	SERCOM_SPI_DBGCTRL_DBGSTOP_Msk = 0x1
	// Bit DBGSTOP.
	SERCOM_SPI_DBGCTRL_DBGSTOP = 0x1
)

// Constants for SERCOM0_USART: Serial Communication Interface - USART
const (
	// CTRLA: USART Control A
	// Position of SWRST field.
	SERCOM_USART_CTRLA_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	SERCOM_USART_CTRLA_SWRST_Msk = 0x1
	// Bit SWRST.
	SERCOM_USART_CTRLA_SWRST = 0x1
	// Position of ENABLE field.
	SERCOM_USART_CTRLA_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	SERCOM_USART_CTRLA_ENABLE_Msk = 0x2
	// Bit ENABLE.
	SERCOM_USART_CTRLA_ENABLE = 0x2
	// Position of MODE field.
	SERCOM_USART_CTRLA_MODE_Pos = 0x2
	// Bit mask of MODE field.
	SERCOM_USART_CTRLA_MODE_Msk = 0x1c
	// Position of RUNSTDBY field.
	SERCOM_USART_CTRLA_RUNSTDBY_Pos = 0x7
	// Bit mask of RUNSTDBY field.
	SERCOM_USART_CTRLA_RUNSTDBY_Msk = 0x80
	// Bit RUNSTDBY.
	SERCOM_USART_CTRLA_RUNSTDBY = 0x80
	// Position of IBON field.
	SERCOM_USART_CTRLA_IBON_Pos = 0x8
	// Bit mask of IBON field.
	SERCOM_USART_CTRLA_IBON_Msk = 0x100
	// Bit IBON.
	SERCOM_USART_CTRLA_IBON = 0x100
	// Position of TXINV field.
	SERCOM_USART_CTRLA_TXINV_Pos = 0x9
	// Bit mask of TXINV field.
	SERCOM_USART_CTRLA_TXINV_Msk = 0x200
	// Bit TXINV.
	SERCOM_USART_CTRLA_TXINV = 0x200
	// Position of RXINV field.
	SERCOM_USART_CTRLA_RXINV_Pos = 0xa
	// Bit mask of RXINV field.
	SERCOM_USART_CTRLA_RXINV_Msk = 0x400
	// Bit RXINV.
	SERCOM_USART_CTRLA_RXINV = 0x400
	// Position of SAMPR field.
	SERCOM_USART_CTRLA_SAMPR_Pos = 0xd
	// Bit mask of SAMPR field.
	SERCOM_USART_CTRLA_SAMPR_Msk = 0xe000
	// Position of TXPO field.
	SERCOM_USART_CTRLA_TXPO_Pos = 0x10
	// Bit mask of TXPO field.
	SERCOM_USART_CTRLA_TXPO_Msk = 0x30000
	// Position of RXPO field.
	SERCOM_USART_CTRLA_RXPO_Pos = 0x14
	// Bit mask of RXPO field.
	SERCOM_USART_CTRLA_RXPO_Msk = 0x300000
	// Position of SAMPA field.
	SERCOM_USART_CTRLA_SAMPA_Pos = 0x16
	// Bit mask of SAMPA field.
	SERCOM_USART_CTRLA_SAMPA_Msk = 0xc00000
	// Position of FORM field.
	SERCOM_USART_CTRLA_FORM_Pos = 0x18
	// Bit mask of FORM field.
	SERCOM_USART_CTRLA_FORM_Msk = 0xf000000
	// Position of CMODE field.
	SERCOM_USART_CTRLA_CMODE_Pos = 0x1c
	// Bit mask of CMODE field.
	SERCOM_USART_CTRLA_CMODE_Msk = 0x10000000
	// Bit CMODE.
	SERCOM_USART_CTRLA_CMODE = 0x10000000
	// Position of CPOL field.
	SERCOM_USART_CTRLA_CPOL_Pos = 0x1d
	// Bit mask of CPOL field.
	SERCOM_USART_CTRLA_CPOL_Msk = 0x20000000
	// Bit CPOL.
	SERCOM_USART_CTRLA_CPOL = 0x20000000
	// Position of DORD field.
	SERCOM_USART_CTRLA_DORD_Pos = 0x1e
	// Bit mask of DORD field.
	SERCOM_USART_CTRLA_DORD_Msk = 0x40000000
	// Bit DORD.
	SERCOM_USART_CTRLA_DORD = 0x40000000

	// CTRLB: USART Control B
	// Position of CHSIZE field.
	SERCOM_USART_CTRLB_CHSIZE_Pos = 0x0
	// Bit mask of CHSIZE field.
	SERCOM_USART_CTRLB_CHSIZE_Msk = 0x7
	// Position of SBMODE field.
	SERCOM_USART_CTRLB_SBMODE_Pos = 0x6
	// Bit mask of SBMODE field.
	SERCOM_USART_CTRLB_SBMODE_Msk = 0x40
	// Bit SBMODE.
	SERCOM_USART_CTRLB_SBMODE = 0x40
	// Position of COLDEN field.
	SERCOM_USART_CTRLB_COLDEN_Pos = 0x8
	// Bit mask of COLDEN field.
	SERCOM_USART_CTRLB_COLDEN_Msk = 0x100
	// Bit COLDEN.
	SERCOM_USART_CTRLB_COLDEN = 0x100
	// Position of SFDE field.
	SERCOM_USART_CTRLB_SFDE_Pos = 0x9
	// Bit mask of SFDE field.
	SERCOM_USART_CTRLB_SFDE_Msk = 0x200
	// Bit SFDE.
	SERCOM_USART_CTRLB_SFDE = 0x200
	// Position of ENC field.
	SERCOM_USART_CTRLB_ENC_Pos = 0xa
	// Bit mask of ENC field.
	SERCOM_USART_CTRLB_ENC_Msk = 0x400
	// Bit ENC.
	SERCOM_USART_CTRLB_ENC = 0x400
	// Position of PMODE field.
	SERCOM_USART_CTRLB_PMODE_Pos = 0xd
	// Bit mask of PMODE field.
	SERCOM_USART_CTRLB_PMODE_Msk = 0x2000
	// Bit PMODE.
	SERCOM_USART_CTRLB_PMODE = 0x2000
	// Position of TXEN field.
	SERCOM_USART_CTRLB_TXEN_Pos = 0x10
	// Bit mask of TXEN field.
	SERCOM_USART_CTRLB_TXEN_Msk = 0x10000
	// Bit TXEN.
	SERCOM_USART_CTRLB_TXEN = 0x10000
	// Position of RXEN field.
	SERCOM_USART_CTRLB_RXEN_Pos = 0x11
	// Bit mask of RXEN field.
	SERCOM_USART_CTRLB_RXEN_Msk = 0x20000
	// Bit RXEN.
	SERCOM_USART_CTRLB_RXEN = 0x20000
	// Position of LINCMD field.
	SERCOM_USART_CTRLB_LINCMD_Pos = 0x18
	// Bit mask of LINCMD field.
	SERCOM_USART_CTRLB_LINCMD_Msk = 0x3000000

	// CTRLC: USART Control C
	// Position of GTIME field.
	SERCOM_USART_CTRLC_GTIME_Pos = 0x0
	// Bit mask of GTIME field.
	SERCOM_USART_CTRLC_GTIME_Msk = 0x7
	// Position of BRKLEN field.
	SERCOM_USART_CTRLC_BRKLEN_Pos = 0x8
	// Bit mask of BRKLEN field.
	SERCOM_USART_CTRLC_BRKLEN_Msk = 0x300
	// Position of HDRDLY field.
	SERCOM_USART_CTRLC_HDRDLY_Pos = 0xa
	// Bit mask of HDRDLY field.
	SERCOM_USART_CTRLC_HDRDLY_Msk = 0xc00
	// Position of INACK field.
	SERCOM_USART_CTRLC_INACK_Pos = 0x10
	// Bit mask of INACK field.
	SERCOM_USART_CTRLC_INACK_Msk = 0x10000
	// Bit INACK.
	SERCOM_USART_CTRLC_INACK = 0x10000
	// Position of DSNACK field.
	SERCOM_USART_CTRLC_DSNACK_Pos = 0x11
	// Bit mask of DSNACK field.
	SERCOM_USART_CTRLC_DSNACK_Msk = 0x20000
	// Bit DSNACK.
	SERCOM_USART_CTRLC_DSNACK = 0x20000
	// Position of MAXITER field.
	SERCOM_USART_CTRLC_MAXITER_Pos = 0x14
	// Bit mask of MAXITER field.
	SERCOM_USART_CTRLC_MAXITER_Msk = 0x700000

	// BAUD: USART Baud Rate
	// Position of BAUD field.
	SERCOM_USART_BAUD_BAUD_Pos = 0x0
	// Bit mask of BAUD field.
	SERCOM_USART_BAUD_BAUD_Msk = 0xffff

	// BAUD_FRAC_MODE: USART Baud Rate
	// Position of BAUD field.
	SERCOM_USART_BAUD_FRAC_MODE_BAUD_Pos = 0x0
	// Bit mask of BAUD field.
	SERCOM_USART_BAUD_FRAC_MODE_BAUD_Msk = 0x1fff
	// Position of FP field.
	SERCOM_USART_BAUD_FRAC_MODE_FP_Pos = 0xd
	// Bit mask of FP field.
	SERCOM_USART_BAUD_FRAC_MODE_FP_Msk = 0xe000

	// BAUD_FRACFP_MODE: USART Baud Rate
	// Position of BAUD field.
	SERCOM_USART_BAUD_FRACFP_MODE_BAUD_Pos = 0x0
	// Bit mask of BAUD field.
	SERCOM_USART_BAUD_FRACFP_MODE_BAUD_Msk = 0x1fff
	// Position of FP field.
	SERCOM_USART_BAUD_FRACFP_MODE_FP_Pos = 0xd
	// Bit mask of FP field.
	SERCOM_USART_BAUD_FRACFP_MODE_FP_Msk = 0xe000

	// BAUD_USARTFP_MODE: USART Baud Rate
	// Position of BAUD field.
	SERCOM_USART_BAUD_USARTFP_MODE_BAUD_Pos = 0x0
	// Bit mask of BAUD field.
	SERCOM_USART_BAUD_USARTFP_MODE_BAUD_Msk = 0xffff

	// RXPL: USART Receive Pulse Length
	// Position of RXPL field.
	SERCOM_USART_RXPL_RXPL_Pos = 0x0
	// Bit mask of RXPL field.
	SERCOM_USART_RXPL_RXPL_Msk = 0xff

	// INTENCLR: USART Interrupt Enable Clear
	// Position of DRE field.
	SERCOM_USART_INTENCLR_DRE_Pos = 0x0
	// Bit mask of DRE field.
	SERCOM_USART_INTENCLR_DRE_Msk = 0x1
	// Bit DRE.
	SERCOM_USART_INTENCLR_DRE = 0x1
	// Position of TXC field.
	SERCOM_USART_INTENCLR_TXC_Pos = 0x1
	// Bit mask of TXC field.
	SERCOM_USART_INTENCLR_TXC_Msk = 0x2
	// Bit TXC.
	SERCOM_USART_INTENCLR_TXC = 0x2
	// Position of RXC field.
	SERCOM_USART_INTENCLR_RXC_Pos = 0x2
	// Bit mask of RXC field.
	SERCOM_USART_INTENCLR_RXC_Msk = 0x4
	// Bit RXC.
	SERCOM_USART_INTENCLR_RXC = 0x4
	// Position of RXS field.
	SERCOM_USART_INTENCLR_RXS_Pos = 0x3
	// Bit mask of RXS field.
	SERCOM_USART_INTENCLR_RXS_Msk = 0x8
	// Bit RXS.
	SERCOM_USART_INTENCLR_RXS = 0x8
	// Position of CTSIC field.
	SERCOM_USART_INTENCLR_CTSIC_Pos = 0x4
	// Bit mask of CTSIC field.
	SERCOM_USART_INTENCLR_CTSIC_Msk = 0x10
	// Bit CTSIC.
	SERCOM_USART_INTENCLR_CTSIC = 0x10
	// Position of RXBRK field.
	SERCOM_USART_INTENCLR_RXBRK_Pos = 0x5
	// Bit mask of RXBRK field.
	SERCOM_USART_INTENCLR_RXBRK_Msk = 0x20
	// Bit RXBRK.
	SERCOM_USART_INTENCLR_RXBRK = 0x20
	// Position of ERROR field.
	SERCOM_USART_INTENCLR_ERROR_Pos = 0x7
	// Bit mask of ERROR field.
	SERCOM_USART_INTENCLR_ERROR_Msk = 0x80
	// Bit ERROR.
	SERCOM_USART_INTENCLR_ERROR = 0x80

	// INTENSET: USART Interrupt Enable Set
	// Position of DRE field.
	SERCOM_USART_INTENSET_DRE_Pos = 0x0
	// Bit mask of DRE field.
	SERCOM_USART_INTENSET_DRE_Msk = 0x1
	// Bit DRE.
	SERCOM_USART_INTENSET_DRE = 0x1
	// Position of TXC field.
	SERCOM_USART_INTENSET_TXC_Pos = 0x1
	// Bit mask of TXC field.
	SERCOM_USART_INTENSET_TXC_Msk = 0x2
	// Bit TXC.
	SERCOM_USART_INTENSET_TXC = 0x2
	// Position of RXC field.
	SERCOM_USART_INTENSET_RXC_Pos = 0x2
	// Bit mask of RXC field.
	SERCOM_USART_INTENSET_RXC_Msk = 0x4
	// Bit RXC.
	SERCOM_USART_INTENSET_RXC = 0x4
	// Position of RXS field.
	SERCOM_USART_INTENSET_RXS_Pos = 0x3
	// Bit mask of RXS field.
	SERCOM_USART_INTENSET_RXS_Msk = 0x8
	// Bit RXS.
	SERCOM_USART_INTENSET_RXS = 0x8
	// Position of CTSIC field.
	SERCOM_USART_INTENSET_CTSIC_Pos = 0x4
	// Bit mask of CTSIC field.
	SERCOM_USART_INTENSET_CTSIC_Msk = 0x10
	// Bit CTSIC.
	SERCOM_USART_INTENSET_CTSIC = 0x10
	// Position of RXBRK field.
	SERCOM_USART_INTENSET_RXBRK_Pos = 0x5
	// Bit mask of RXBRK field.
	SERCOM_USART_INTENSET_RXBRK_Msk = 0x20
	// Bit RXBRK.
	SERCOM_USART_INTENSET_RXBRK = 0x20
	// Position of ERROR field.
	SERCOM_USART_INTENSET_ERROR_Pos = 0x7
	// Bit mask of ERROR field.
	SERCOM_USART_INTENSET_ERROR_Msk = 0x80
	// Bit ERROR.
	SERCOM_USART_INTENSET_ERROR = 0x80

	// INTFLAG: USART Interrupt Flag Status and Clear
	// Position of DRE field.
	SERCOM_USART_INTFLAG_DRE_Pos = 0x0
	// Bit mask of DRE field.
	SERCOM_USART_INTFLAG_DRE_Msk = 0x1
	// Bit DRE.
	SERCOM_USART_INTFLAG_DRE = 0x1
	// Position of TXC field.
	SERCOM_USART_INTFLAG_TXC_Pos = 0x1
	// Bit mask of TXC field.
	SERCOM_USART_INTFLAG_TXC_Msk = 0x2
	// Bit TXC.
	SERCOM_USART_INTFLAG_TXC = 0x2
	// Position of RXC field.
	SERCOM_USART_INTFLAG_RXC_Pos = 0x2
	// Bit mask of RXC field.
	SERCOM_USART_INTFLAG_RXC_Msk = 0x4
	// Bit RXC.
	SERCOM_USART_INTFLAG_RXC = 0x4
	// Position of RXS field.
	SERCOM_USART_INTFLAG_RXS_Pos = 0x3
	// Bit mask of RXS field.
	SERCOM_USART_INTFLAG_RXS_Msk = 0x8
	// Bit RXS.
	SERCOM_USART_INTFLAG_RXS = 0x8
	// Position of CTSIC field.
	SERCOM_USART_INTFLAG_CTSIC_Pos = 0x4
	// Bit mask of CTSIC field.
	SERCOM_USART_INTFLAG_CTSIC_Msk = 0x10
	// Bit CTSIC.
	SERCOM_USART_INTFLAG_CTSIC = 0x10
	// Position of RXBRK field.
	SERCOM_USART_INTFLAG_RXBRK_Pos = 0x5
	// Bit mask of RXBRK field.
	SERCOM_USART_INTFLAG_RXBRK_Msk = 0x20
	// Bit RXBRK.
	SERCOM_USART_INTFLAG_RXBRK = 0x20
	// Position of ERROR field.
	SERCOM_USART_INTFLAG_ERROR_Pos = 0x7
	// Bit mask of ERROR field.
	SERCOM_USART_INTFLAG_ERROR_Msk = 0x80
	// Bit ERROR.
	SERCOM_USART_INTFLAG_ERROR = 0x80

	// STATUS: USART Status
	// Position of PERR field.
	SERCOM_USART_STATUS_PERR_Pos = 0x0
	// Bit mask of PERR field.
	SERCOM_USART_STATUS_PERR_Msk = 0x1
	// Bit PERR.
	SERCOM_USART_STATUS_PERR = 0x1
	// Position of FERR field.
	SERCOM_USART_STATUS_FERR_Pos = 0x1
	// Bit mask of FERR field.
	SERCOM_USART_STATUS_FERR_Msk = 0x2
	// Bit FERR.
	SERCOM_USART_STATUS_FERR = 0x2
	// Position of BUFOVF field.
	SERCOM_USART_STATUS_BUFOVF_Pos = 0x2
	// Bit mask of BUFOVF field.
	SERCOM_USART_STATUS_BUFOVF_Msk = 0x4
	// Bit BUFOVF.
	SERCOM_USART_STATUS_BUFOVF = 0x4
	// Position of CTS field.
	SERCOM_USART_STATUS_CTS_Pos = 0x3
	// Bit mask of CTS field.
	SERCOM_USART_STATUS_CTS_Msk = 0x8
	// Bit CTS.
	SERCOM_USART_STATUS_CTS = 0x8
	// Position of ISF field.
	SERCOM_USART_STATUS_ISF_Pos = 0x4
	// Bit mask of ISF field.
	SERCOM_USART_STATUS_ISF_Msk = 0x10
	// Bit ISF.
	SERCOM_USART_STATUS_ISF = 0x10
	// Position of COLL field.
	SERCOM_USART_STATUS_COLL_Pos = 0x5
	// Bit mask of COLL field.
	SERCOM_USART_STATUS_COLL_Msk = 0x20
	// Bit COLL.
	SERCOM_USART_STATUS_COLL = 0x20
	// Position of TXE field.
	SERCOM_USART_STATUS_TXE_Pos = 0x6
	// Bit mask of TXE field.
	SERCOM_USART_STATUS_TXE_Msk = 0x40
	// Bit TXE.
	SERCOM_USART_STATUS_TXE = 0x40
	// Position of ITER field.
	SERCOM_USART_STATUS_ITER_Pos = 0x7
	// Bit mask of ITER field.
	SERCOM_USART_STATUS_ITER_Msk = 0x80
	// Bit ITER.
	SERCOM_USART_STATUS_ITER = 0x80

	// SYNCBUSY: USART Synchronization Busy
	// Position of SWRST field.
	SERCOM_USART_SYNCBUSY_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	SERCOM_USART_SYNCBUSY_SWRST_Msk = 0x1
	// Bit SWRST.
	SERCOM_USART_SYNCBUSY_SWRST = 0x1
	// Position of ENABLE field.
	SERCOM_USART_SYNCBUSY_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	SERCOM_USART_SYNCBUSY_ENABLE_Msk = 0x2
	// Bit ENABLE.
	SERCOM_USART_SYNCBUSY_ENABLE = 0x2
	// Position of CTRLB field.
	SERCOM_USART_SYNCBUSY_CTRLB_Pos = 0x2
	// Bit mask of CTRLB field.
	SERCOM_USART_SYNCBUSY_CTRLB_Msk = 0x4
	// Bit CTRLB.
	SERCOM_USART_SYNCBUSY_CTRLB = 0x4
	// Position of RXERRCNT field.
	SERCOM_USART_SYNCBUSY_RXERRCNT_Pos = 0x3
	// Bit mask of RXERRCNT field.
	SERCOM_USART_SYNCBUSY_RXERRCNT_Msk = 0x8
	// Bit RXERRCNT.
	SERCOM_USART_SYNCBUSY_RXERRCNT = 0x8

	// DATA: USART Data
	// Position of DATA field.
	SERCOM_USART_DATA_DATA_Pos = 0x0
	// Bit mask of DATA field.
	SERCOM_USART_DATA_DATA_Msk = 0x1ff

	// DBGCTRL: USART Debug Control
	// Position of DBGSTOP field.
	SERCOM_USART_DBGCTRL_DBGSTOP_Pos = 0x0
	// Bit mask of DBGSTOP field.
	SERCOM_USART_DBGCTRL_DBGSTOP_Msk = 0x1
	// Bit DBGSTOP.
	SERCOM_USART_DBGCTRL_DBGSTOP = 0x1
)

// Constants for SUPC: Supply Controller
const (
	// INTENCLR: Interrupt Enable Clear
	// Position of BOD33RDY field.
	SUPC_INTENCLR_BOD33RDY_Pos = 0x0
	// Bit mask of BOD33RDY field.
	SUPC_INTENCLR_BOD33RDY_Msk = 0x1
	// Bit BOD33RDY.
	SUPC_INTENCLR_BOD33RDY = 0x1
	// Position of BOD33DET field.
	SUPC_INTENCLR_BOD33DET_Pos = 0x1
	// Bit mask of BOD33DET field.
	SUPC_INTENCLR_BOD33DET_Msk = 0x2
	// Bit BOD33DET.
	SUPC_INTENCLR_BOD33DET = 0x2
	// Position of B33SRDY field.
	SUPC_INTENCLR_B33SRDY_Pos = 0x2
	// Bit mask of B33SRDY field.
	SUPC_INTENCLR_B33SRDY_Msk = 0x4
	// Bit B33SRDY.
	SUPC_INTENCLR_B33SRDY = 0x4
	// Position of BOD12RDY field.
	SUPC_INTENCLR_BOD12RDY_Pos = 0x3
	// Bit mask of BOD12RDY field.
	SUPC_INTENCLR_BOD12RDY_Msk = 0x8
	// Bit BOD12RDY.
	SUPC_INTENCLR_BOD12RDY = 0x8
	// Position of BOD12DET field.
	SUPC_INTENCLR_BOD12DET_Pos = 0x4
	// Bit mask of BOD12DET field.
	SUPC_INTENCLR_BOD12DET_Msk = 0x10
	// Bit BOD12DET.
	SUPC_INTENCLR_BOD12DET = 0x10
	// Position of B12SRDY field.
	SUPC_INTENCLR_B12SRDY_Pos = 0x5
	// Bit mask of B12SRDY field.
	SUPC_INTENCLR_B12SRDY_Msk = 0x20
	// Bit B12SRDY.
	SUPC_INTENCLR_B12SRDY = 0x20
	// Position of VREGRDY field.
	SUPC_INTENCLR_VREGRDY_Pos = 0x8
	// Bit mask of VREGRDY field.
	SUPC_INTENCLR_VREGRDY_Msk = 0x100
	// Bit VREGRDY.
	SUPC_INTENCLR_VREGRDY = 0x100
	// Position of VCORERDY field.
	SUPC_INTENCLR_VCORERDY_Pos = 0xa
	// Bit mask of VCORERDY field.
	SUPC_INTENCLR_VCORERDY_Msk = 0x400
	// Bit VCORERDY.
	SUPC_INTENCLR_VCORERDY = 0x400
	// Position of ULPVREFRDY field.
	SUPC_INTENCLR_ULPVREFRDY_Pos = 0xb
	// Bit mask of ULPVREFRDY field.
	SUPC_INTENCLR_ULPVREFRDY_Msk = 0x800
	// Bit ULPVREFRDY.
	SUPC_INTENCLR_ULPVREFRDY = 0x800

	// INTENSET: Interrupt Enable Set
	// Position of BOD33RDY field.
	SUPC_INTENSET_BOD33RDY_Pos = 0x0
	// Bit mask of BOD33RDY field.
	SUPC_INTENSET_BOD33RDY_Msk = 0x1
	// Bit BOD33RDY.
	SUPC_INTENSET_BOD33RDY = 0x1
	// Position of BOD33DET field.
	SUPC_INTENSET_BOD33DET_Pos = 0x1
	// Bit mask of BOD33DET field.
	SUPC_INTENSET_BOD33DET_Msk = 0x2
	// Bit BOD33DET.
	SUPC_INTENSET_BOD33DET = 0x2
	// Position of B33SRDY field.
	SUPC_INTENSET_B33SRDY_Pos = 0x2
	// Bit mask of B33SRDY field.
	SUPC_INTENSET_B33SRDY_Msk = 0x4
	// Bit B33SRDY.
	SUPC_INTENSET_B33SRDY = 0x4
	// Position of BOD12RDY field.
	SUPC_INTENSET_BOD12RDY_Pos = 0x3
	// Bit mask of BOD12RDY field.
	SUPC_INTENSET_BOD12RDY_Msk = 0x8
	// Bit BOD12RDY.
	SUPC_INTENSET_BOD12RDY = 0x8
	// Position of BOD12DET field.
	SUPC_INTENSET_BOD12DET_Pos = 0x4
	// Bit mask of BOD12DET field.
	SUPC_INTENSET_BOD12DET_Msk = 0x10
	// Bit BOD12DET.
	SUPC_INTENSET_BOD12DET = 0x10
	// Position of B12SRDY field.
	SUPC_INTENSET_B12SRDY_Pos = 0x5
	// Bit mask of B12SRDY field.
	SUPC_INTENSET_B12SRDY_Msk = 0x20
	// Bit B12SRDY.
	SUPC_INTENSET_B12SRDY = 0x20
	// Position of VREGRDY field.
	SUPC_INTENSET_VREGRDY_Pos = 0x8
	// Bit mask of VREGRDY field.
	SUPC_INTENSET_VREGRDY_Msk = 0x100
	// Bit VREGRDY.
	SUPC_INTENSET_VREGRDY = 0x100
	// Position of VCORERDY field.
	SUPC_INTENSET_VCORERDY_Pos = 0xa
	// Bit mask of VCORERDY field.
	SUPC_INTENSET_VCORERDY_Msk = 0x400
	// Bit VCORERDY.
	SUPC_INTENSET_VCORERDY = 0x400
	// Position of ULPVREFRDY field.
	SUPC_INTENSET_ULPVREFRDY_Pos = 0xb
	// Bit mask of ULPVREFRDY field.
	SUPC_INTENSET_ULPVREFRDY_Msk = 0x800
	// Bit ULPVREFRDY.
	SUPC_INTENSET_ULPVREFRDY = 0x800

	// INTFLAG: Interrupt Flag Status and Clear
	// Position of BOD33RDY field.
	SUPC_INTFLAG_BOD33RDY_Pos = 0x0
	// Bit mask of BOD33RDY field.
	SUPC_INTFLAG_BOD33RDY_Msk = 0x1
	// Bit BOD33RDY.
	SUPC_INTFLAG_BOD33RDY = 0x1
	// Position of BOD33DET field.
	SUPC_INTFLAG_BOD33DET_Pos = 0x1
	// Bit mask of BOD33DET field.
	SUPC_INTFLAG_BOD33DET_Msk = 0x2
	// Bit BOD33DET.
	SUPC_INTFLAG_BOD33DET = 0x2
	// Position of B33SRDY field.
	SUPC_INTFLAG_B33SRDY_Pos = 0x2
	// Bit mask of B33SRDY field.
	SUPC_INTFLAG_B33SRDY_Msk = 0x4
	// Bit B33SRDY.
	SUPC_INTFLAG_B33SRDY = 0x4
	// Position of BOD12RDY field.
	SUPC_INTFLAG_BOD12RDY_Pos = 0x3
	// Bit mask of BOD12RDY field.
	SUPC_INTFLAG_BOD12RDY_Msk = 0x8
	// Bit BOD12RDY.
	SUPC_INTFLAG_BOD12RDY = 0x8
	// Position of BOD12DET field.
	SUPC_INTFLAG_BOD12DET_Pos = 0x4
	// Bit mask of BOD12DET field.
	SUPC_INTFLAG_BOD12DET_Msk = 0x10
	// Bit BOD12DET.
	SUPC_INTFLAG_BOD12DET = 0x10
	// Position of B12SRDY field.
	SUPC_INTFLAG_B12SRDY_Pos = 0x5
	// Bit mask of B12SRDY field.
	SUPC_INTFLAG_B12SRDY_Msk = 0x20
	// Bit B12SRDY.
	SUPC_INTFLAG_B12SRDY = 0x20
	// Position of VREGRDY field.
	SUPC_INTFLAG_VREGRDY_Pos = 0x8
	// Bit mask of VREGRDY field.
	SUPC_INTFLAG_VREGRDY_Msk = 0x100
	// Bit VREGRDY.
	SUPC_INTFLAG_VREGRDY = 0x100
	// Position of VCORERDY field.
	SUPC_INTFLAG_VCORERDY_Pos = 0xa
	// Bit mask of VCORERDY field.
	SUPC_INTFLAG_VCORERDY_Msk = 0x400
	// Bit VCORERDY.
	SUPC_INTFLAG_VCORERDY = 0x400
	// Position of ULPVREFRDY field.
	SUPC_INTFLAG_ULPVREFRDY_Pos = 0xb
	// Bit mask of ULPVREFRDY field.
	SUPC_INTFLAG_ULPVREFRDY_Msk = 0x800
	// Bit ULPVREFRDY.
	SUPC_INTFLAG_ULPVREFRDY = 0x800

	// STATUS: Power and Clocks Status
	// Position of BOD33RDY field.
	SUPC_STATUS_BOD33RDY_Pos = 0x0
	// Bit mask of BOD33RDY field.
	SUPC_STATUS_BOD33RDY_Msk = 0x1
	// Bit BOD33RDY.
	SUPC_STATUS_BOD33RDY = 0x1
	// Position of BOD33DET field.
	SUPC_STATUS_BOD33DET_Pos = 0x1
	// Bit mask of BOD33DET field.
	SUPC_STATUS_BOD33DET_Msk = 0x2
	// Bit BOD33DET.
	SUPC_STATUS_BOD33DET = 0x2
	// Position of B33SRDY field.
	SUPC_STATUS_B33SRDY_Pos = 0x2
	// Bit mask of B33SRDY field.
	SUPC_STATUS_B33SRDY_Msk = 0x4
	// Bit B33SRDY.
	SUPC_STATUS_B33SRDY = 0x4
	// Position of BOD12RDY field.
	SUPC_STATUS_BOD12RDY_Pos = 0x3
	// Bit mask of BOD12RDY field.
	SUPC_STATUS_BOD12RDY_Msk = 0x8
	// Bit BOD12RDY.
	SUPC_STATUS_BOD12RDY = 0x8
	// Position of BOD12DET field.
	SUPC_STATUS_BOD12DET_Pos = 0x4
	// Bit mask of BOD12DET field.
	SUPC_STATUS_BOD12DET_Msk = 0x10
	// Bit BOD12DET.
	SUPC_STATUS_BOD12DET = 0x10
	// Position of B12SRDY field.
	SUPC_STATUS_B12SRDY_Pos = 0x5
	// Bit mask of B12SRDY field.
	SUPC_STATUS_B12SRDY_Msk = 0x20
	// Bit B12SRDY.
	SUPC_STATUS_B12SRDY = 0x20
	// Position of VREGRDY field.
	SUPC_STATUS_VREGRDY_Pos = 0x8
	// Bit mask of VREGRDY field.
	SUPC_STATUS_VREGRDY_Msk = 0x100
	// Bit VREGRDY.
	SUPC_STATUS_VREGRDY = 0x100
	// Position of VCORERDY field.
	SUPC_STATUS_VCORERDY_Pos = 0xa
	// Bit mask of VCORERDY field.
	SUPC_STATUS_VCORERDY_Msk = 0x400
	// Bit VCORERDY.
	SUPC_STATUS_VCORERDY = 0x400
	// Position of ULPVREFRDY field.
	SUPC_STATUS_ULPVREFRDY_Pos = 0xc
	// Bit mask of ULPVREFRDY field.
	SUPC_STATUS_ULPVREFRDY_Msk = 0x1000
	// Bit ULPVREFRDY.
	SUPC_STATUS_ULPVREFRDY = 0x1000
	// Position of ULPBIASRDY field.
	SUPC_STATUS_ULPBIASRDY_Pos = 0xd
	// Bit mask of ULPBIASRDY field.
	SUPC_STATUS_ULPBIASRDY_Msk = 0x2000
	// Bit ULPBIASRDY.
	SUPC_STATUS_ULPBIASRDY = 0x2000

	// BOD33: BOD33 Control
	// Position of ENABLE field.
	SUPC_BOD33_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	SUPC_BOD33_ENABLE_Msk = 0x2
	// Bit ENABLE.
	SUPC_BOD33_ENABLE = 0x2
	// Position of HYST field.
	SUPC_BOD33_HYST_Pos = 0x2
	// Bit mask of HYST field.
	SUPC_BOD33_HYST_Msk = 0x4
	// Bit HYST.
	SUPC_BOD33_HYST = 0x4
	// Position of ACTION field.
	SUPC_BOD33_ACTION_Pos = 0x3
	// Bit mask of ACTION field.
	SUPC_BOD33_ACTION_Msk = 0x18
	// No action
	SUPC_BOD33_ACTION_NONE = 0x0
	// The BOD33 generates a reset
	SUPC_BOD33_ACTION_RESET = 0x1
	// The BOD33 generates an interrupt
	SUPC_BOD33_ACTION_INT = 0x2
	// The BOD33 puts the device in backup sleep mode if VMON=0
	SUPC_BOD33_ACTION_BKUP = 0x3
	// Position of STDBYCFG field.
	SUPC_BOD33_STDBYCFG_Pos = 0x5
	// Bit mask of STDBYCFG field.
	SUPC_BOD33_STDBYCFG_Msk = 0x20
	// Bit STDBYCFG.
	SUPC_BOD33_STDBYCFG = 0x20
	// Position of RUNSTDBY field.
	SUPC_BOD33_RUNSTDBY_Pos = 0x6
	// Bit mask of RUNSTDBY field.
	SUPC_BOD33_RUNSTDBY_Msk = 0x40
	// Bit RUNSTDBY.
	SUPC_BOD33_RUNSTDBY = 0x40
	// Position of ACTCFG field.
	SUPC_BOD33_ACTCFG_Pos = 0x8
	// Bit mask of ACTCFG field.
	SUPC_BOD33_ACTCFG_Msk = 0x100
	// Bit ACTCFG.
	SUPC_BOD33_ACTCFG = 0x100
	// Position of REFSEL field.
	SUPC_BOD33_REFSEL_Pos = 0xb
	// Bit mask of REFSEL field.
	SUPC_BOD33_REFSEL_Msk = 0x800
	// Bit REFSEL.
	SUPC_BOD33_REFSEL = 0x800
	// Selects VREFDETREF for the BOD33
	SUPC_BOD33_REFSEL_SEL_VREFDETREF = 0x0
	// Selects ULPVREF for the BOD33
	SUPC_BOD33_REFSEL_SEL_ULPVREF = 0x1
	// Position of PSEL field.
	SUPC_BOD33_PSEL_Pos = 0xc
	// Bit mask of PSEL field.
	SUPC_BOD33_PSEL_Msk = 0xf000
	// Divide clock by 2
	SUPC_BOD33_PSEL_DIV2 = 0x0
	// Divide clock by 4
	SUPC_BOD33_PSEL_DIV4 = 0x1
	// Divide clock by 8
	SUPC_BOD33_PSEL_DIV8 = 0x2
	// Divide clock by 16
	SUPC_BOD33_PSEL_DIV16 = 0x3
	// Divide clock by 32
	SUPC_BOD33_PSEL_DIV32 = 0x4
	// Divide clock by 64
	SUPC_BOD33_PSEL_DIV64 = 0x5
	// Divide clock by 128
	SUPC_BOD33_PSEL_DIV128 = 0x6
	// Divide clock by 256
	SUPC_BOD33_PSEL_DIV256 = 0x7
	// Divide clock by 512
	SUPC_BOD33_PSEL_DIV512 = 0x8
	// Divide clock by 1024
	SUPC_BOD33_PSEL_DIV1024 = 0x9
	// Divide clock by 2048
	SUPC_BOD33_PSEL_DIV2048 = 0xa
	// Divide clock by 4096
	SUPC_BOD33_PSEL_DIV4096 = 0xb
	// Divide clock by 8192
	SUPC_BOD33_PSEL_DIV8192 = 0xc
	// Divide clock by 16384
	SUPC_BOD33_PSEL_DIV16384 = 0xd
	// Divide clock by 32768
	SUPC_BOD33_PSEL_DIV32768 = 0xe
	// Divide clock by 65536
	SUPC_BOD33_PSEL_DIV65536 = 0xf
	// Position of LEVEL field.
	SUPC_BOD33_LEVEL_Pos = 0x10
	// Bit mask of LEVEL field.
	SUPC_BOD33_LEVEL_Msk = 0x3f0000

	// BOD12: BOD12 Control
	// Position of ENABLE field.
	SUPC_BOD12_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	SUPC_BOD12_ENABLE_Msk = 0x2
	// Bit ENABLE.
	SUPC_BOD12_ENABLE = 0x2
	// Position of HYST field.
	SUPC_BOD12_HYST_Pos = 0x2
	// Bit mask of HYST field.
	SUPC_BOD12_HYST_Msk = 0x4
	// Bit HYST.
	SUPC_BOD12_HYST = 0x4
	// Position of ACTION field.
	SUPC_BOD12_ACTION_Pos = 0x3
	// Bit mask of ACTION field.
	SUPC_BOD12_ACTION_Msk = 0x18
	// No action
	SUPC_BOD12_ACTION_NONE = 0x0
	// The BOD12 generates a reset
	SUPC_BOD12_ACTION_RESET = 0x1
	// The BOD12 generates an interrupt
	SUPC_BOD12_ACTION_INT = 0x2
	// Position of STDBYCFG field.
	SUPC_BOD12_STDBYCFG_Pos = 0x5
	// Bit mask of STDBYCFG field.
	SUPC_BOD12_STDBYCFG_Msk = 0x20
	// Bit STDBYCFG.
	SUPC_BOD12_STDBYCFG = 0x20
	// Position of RUNSTDBY field.
	SUPC_BOD12_RUNSTDBY_Pos = 0x6
	// Bit mask of RUNSTDBY field.
	SUPC_BOD12_RUNSTDBY_Msk = 0x40
	// Bit RUNSTDBY.
	SUPC_BOD12_RUNSTDBY = 0x40
	// Position of ACTCFG field.
	SUPC_BOD12_ACTCFG_Pos = 0x8
	// Bit mask of ACTCFG field.
	SUPC_BOD12_ACTCFG_Msk = 0x100
	// Bit ACTCFG.
	SUPC_BOD12_ACTCFG = 0x100
	// Position of PSEL field.
	SUPC_BOD12_PSEL_Pos = 0xc
	// Bit mask of PSEL field.
	SUPC_BOD12_PSEL_Msk = 0xf000
	// Divide clock by 2
	SUPC_BOD12_PSEL_DIV2 = 0x0
	// Divide clock by 4
	SUPC_BOD12_PSEL_DIV4 = 0x1
	// Divide clock by 8
	SUPC_BOD12_PSEL_DIV8 = 0x2
	// Divide clock by 16
	SUPC_BOD12_PSEL_DIV16 = 0x3
	// Divide clock by 32
	SUPC_BOD12_PSEL_DIV32 = 0x4
	// Divide clock by 64
	SUPC_BOD12_PSEL_DIV64 = 0x5
	// Divide clock by 128
	SUPC_BOD12_PSEL_DIV128 = 0x6
	// Divide clock by 256
	SUPC_BOD12_PSEL_DIV256 = 0x7
	// Divide clock by 512
	SUPC_BOD12_PSEL_DIV512 = 0x8
	// Divide clock by 1024
	SUPC_BOD12_PSEL_DIV1024 = 0x9
	// Divide clock by 2048
	SUPC_BOD12_PSEL_DIV2048 = 0xa
	// Divide clock by 4096
	SUPC_BOD12_PSEL_DIV4096 = 0xb
	// Divide clock by 8192
	SUPC_BOD12_PSEL_DIV8192 = 0xc
	// Divide clock by 16384
	SUPC_BOD12_PSEL_DIV16384 = 0xd
	// Divide clock by 32768
	SUPC_BOD12_PSEL_DIV32768 = 0xe
	// Divide clock by 65536
	SUPC_BOD12_PSEL_DIV65536 = 0xf
	// Position of LEVEL field.
	SUPC_BOD12_LEVEL_Pos = 0x10
	// Bit mask of LEVEL field.
	SUPC_BOD12_LEVEL_Msk = 0x3f0000

	// VREG: VREG Control
	// Position of ENABLE field.
	SUPC_VREG_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	SUPC_VREG_ENABLE_Msk = 0x2
	// Bit ENABLE.
	SUPC_VREG_ENABLE = 0x2
	// Position of SEL field.
	SUPC_VREG_SEL_Pos = 0x2
	// Bit mask of SEL field.
	SUPC_VREG_SEL_Msk = 0xc
	// LDO selection
	SUPC_VREG_SEL_LDO = 0x0
	// Buck selection
	SUPC_VREG_SEL_BUCK = 0x1
	// Position of STDBYPL0 field.
	SUPC_VREG_STDBYPL0_Pos = 0x5
	// Bit mask of STDBYPL0 field.
	SUPC_VREG_STDBYPL0_Msk = 0x20
	// Bit STDBYPL0.
	SUPC_VREG_STDBYPL0 = 0x20
	// Position of RUNSTDBY field.
	SUPC_VREG_RUNSTDBY_Pos = 0x6
	// Bit mask of RUNSTDBY field.
	SUPC_VREG_RUNSTDBY_Msk = 0x40
	// Bit RUNSTDBY.
	SUPC_VREG_RUNSTDBY = 0x40
	// Position of LPEFF field.
	SUPC_VREG_LPEFF_Pos = 0x8
	// Bit mask of LPEFF field.
	SUPC_VREG_LPEFF_Msk = 0x100
	// Bit LPEFF.
	SUPC_VREG_LPEFF = 0x100
	// Position of VREFSEL field.
	SUPC_VREG_VREFSEL_Pos = 0x9
	// Bit mask of VREFSEL field.
	SUPC_VREG_VREFSEL_Msk = 0x200
	// Bit VREFSEL.
	SUPC_VREG_VREFSEL = 0x200
	// Position of VSVSTEP field.
	SUPC_VREG_VSVSTEP_Pos = 0x10
	// Bit mask of VSVSTEP field.
	SUPC_VREG_VSVSTEP_Msk = 0xf0000
	// Position of VSPER field.
	SUPC_VREG_VSPER_Pos = 0x18
	// Bit mask of VSPER field.
	SUPC_VREG_VSPER_Msk = 0xff000000

	// VREF: VREF Control
	// Position of TSEN field.
	SUPC_VREF_TSEN_Pos = 0x1
	// Bit mask of TSEN field.
	SUPC_VREF_TSEN_Msk = 0x2
	// Bit TSEN.
	SUPC_VREF_TSEN = 0x2
	// Position of VREFOE field.
	SUPC_VREF_VREFOE_Pos = 0x2
	// Bit mask of VREFOE field.
	SUPC_VREF_VREFOE_Msk = 0x4
	// Bit VREFOE.
	SUPC_VREF_VREFOE = 0x4
	// Position of TSSEL field.
	SUPC_VREF_TSSEL_Pos = 0x3
	// Bit mask of TSSEL field.
	SUPC_VREF_TSSEL_Msk = 0x8
	// Bit TSSEL.
	SUPC_VREF_TSSEL = 0x8
	// Position of RUNSTDBY field.
	SUPC_VREF_RUNSTDBY_Pos = 0x6
	// Bit mask of RUNSTDBY field.
	SUPC_VREF_RUNSTDBY_Msk = 0x40
	// Bit RUNSTDBY.
	SUPC_VREF_RUNSTDBY = 0x40
	// Position of ONDEMAND field.
	SUPC_VREF_ONDEMAND_Pos = 0x7
	// Bit mask of ONDEMAND field.
	SUPC_VREF_ONDEMAND_Msk = 0x80
	// Bit ONDEMAND.
	SUPC_VREF_ONDEMAND = 0x80
	// Position of SEL field.
	SUPC_VREF_SEL_Pos = 0x10
	// Bit mask of SEL field.
	SUPC_VREF_SEL_Msk = 0xf0000
	// 1.0V voltage reference typical value
	SUPC_VREF_SEL_1V0 = 0x0
	// 1.1V voltage reference typical value
	SUPC_VREF_SEL_1V1 = 0x1
	// 1.2V voltage reference typical value
	SUPC_VREF_SEL_1V2 = 0x2
	// 1.25V voltage reference typical value
	SUPC_VREF_SEL_1V25 = 0x3
	// 2.0V voltage reference typical value
	SUPC_VREF_SEL_2V0 = 0x4
	// 2.2V voltage reference typical value
	SUPC_VREF_SEL_2V2 = 0x5
	// 2.4V voltage reference typical value
	SUPC_VREF_SEL_2V4 = 0x6
	// 2.5V voltage reference typical value
	SUPC_VREF_SEL_2V5 = 0x7

	// EVCTRL: Event Control
	// Position of BOD33DETEO field.
	SUPC_EVCTRL_BOD33DETEO_Pos = 0x1
	// Bit mask of BOD33DETEO field.
	SUPC_EVCTRL_BOD33DETEO_Msk = 0x2
	// Bit BOD33DETEO.
	SUPC_EVCTRL_BOD33DETEO = 0x2
	// Position of BOD12DETEO field.
	SUPC_EVCTRL_BOD12DETEO_Pos = 0x4
	// Bit mask of BOD12DETEO field.
	SUPC_EVCTRL_BOD12DETEO_Msk = 0x10
	// Bit BOD12DETEO.
	SUPC_EVCTRL_BOD12DETEO = 0x10

	// VREGSUSP: VREG Suspend Control
	// Position of VREGSEN field.
	SUPC_VREGSUSP_VREGSEN_Pos = 0x0
	// Bit mask of VREGSEN field.
	SUPC_VREGSUSP_VREGSEN_Msk = 0x1
	// Bit VREGSEN.
	SUPC_VREGSUSP_VREGSEN = 0x1
)

// Constants for TC0: Basic Timer Counter
const ()

// Constants for TC0_COUNT8: Basic Timer Counter - COUNT8
const (
	// CTRLA: Control A
	// Position of SWRST field.
	TC_COUNT8_CTRLA_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	TC_COUNT8_CTRLA_SWRST_Msk = 0x1
	// Bit SWRST.
	TC_COUNT8_CTRLA_SWRST = 0x1
	// Position of ENABLE field.
	TC_COUNT8_CTRLA_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	TC_COUNT8_CTRLA_ENABLE_Msk = 0x2
	// Bit ENABLE.
	TC_COUNT8_CTRLA_ENABLE = 0x2
	// Position of MODE field.
	TC_COUNT8_CTRLA_MODE_Pos = 0x2
	// Bit mask of MODE field.
	TC_COUNT8_CTRLA_MODE_Msk = 0xc
	// Counter in 16-bit mode
	TC_COUNT8_CTRLA_MODE_COUNT16 = 0x0
	// Counter in 8-bit mode
	TC_COUNT8_CTRLA_MODE_COUNT8 = 0x1
	// Counter in 32-bit mode
	TC_COUNT8_CTRLA_MODE_COUNT32 = 0x2
	// Position of PRESCSYNC field.
	TC_COUNT8_CTRLA_PRESCSYNC_Pos = 0x4
	// Bit mask of PRESCSYNC field.
	TC_COUNT8_CTRLA_PRESCSYNC_Msk = 0x30
	// Reload or reset the counter on next generic clock
	TC_COUNT8_CTRLA_PRESCSYNC_GCLK = 0x0
	// Reload or reset the counter on next prescaler clock
	TC_COUNT8_CTRLA_PRESCSYNC_PRESC = 0x1
	// Reload or reset the counter on next generic clock and reset the prescaler counter
	TC_COUNT8_CTRLA_PRESCSYNC_RESYNC = 0x2
	// Position of RUNSTDBY field.
	TC_COUNT8_CTRLA_RUNSTDBY_Pos = 0x6
	// Bit mask of RUNSTDBY field.
	TC_COUNT8_CTRLA_RUNSTDBY_Msk = 0x40
	// Bit RUNSTDBY.
	TC_COUNT8_CTRLA_RUNSTDBY = 0x40
	// Position of ONDEMAND field.
	TC_COUNT8_CTRLA_ONDEMAND_Pos = 0x7
	// Bit mask of ONDEMAND field.
	TC_COUNT8_CTRLA_ONDEMAND_Msk = 0x80
	// Bit ONDEMAND.
	TC_COUNT8_CTRLA_ONDEMAND = 0x80
	// Position of PRESCALER field.
	TC_COUNT8_CTRLA_PRESCALER_Pos = 0x8
	// Bit mask of PRESCALER field.
	TC_COUNT8_CTRLA_PRESCALER_Msk = 0x700
	// Prescaler: GCLK_TC
	TC_COUNT8_CTRLA_PRESCALER_DIV1 = 0x0
	// Prescaler: GCLK_TC/2
	TC_COUNT8_CTRLA_PRESCALER_DIV2 = 0x1
	// Prescaler: GCLK_TC/4
	TC_COUNT8_CTRLA_PRESCALER_DIV4 = 0x2
	// Prescaler: GCLK_TC/8
	TC_COUNT8_CTRLA_PRESCALER_DIV8 = 0x3
	// Prescaler: GCLK_TC/16
	TC_COUNT8_CTRLA_PRESCALER_DIV16 = 0x4
	// Prescaler: GCLK_TC/64
	TC_COUNT8_CTRLA_PRESCALER_DIV64 = 0x5
	// Prescaler: GCLK_TC/256
	TC_COUNT8_CTRLA_PRESCALER_DIV256 = 0x6
	// Prescaler: GCLK_TC/1024
	TC_COUNT8_CTRLA_PRESCALER_DIV1024 = 0x7
	// Position of ALOCK field.
	TC_COUNT8_CTRLA_ALOCK_Pos = 0xb
	// Bit mask of ALOCK field.
	TC_COUNT8_CTRLA_ALOCK_Msk = 0x800
	// Bit ALOCK.
	TC_COUNT8_CTRLA_ALOCK = 0x800
	// Position of CAPTEN0 field.
	TC_COUNT8_CTRLA_CAPTEN0_Pos = 0x10
	// Bit mask of CAPTEN0 field.
	TC_COUNT8_CTRLA_CAPTEN0_Msk = 0x10000
	// Bit CAPTEN0.
	TC_COUNT8_CTRLA_CAPTEN0 = 0x10000
	// Position of CAPTEN1 field.
	TC_COUNT8_CTRLA_CAPTEN1_Pos = 0x11
	// Bit mask of CAPTEN1 field.
	TC_COUNT8_CTRLA_CAPTEN1_Msk = 0x20000
	// Bit CAPTEN1.
	TC_COUNT8_CTRLA_CAPTEN1 = 0x20000
	// Position of COPEN0 field.
	TC_COUNT8_CTRLA_COPEN0_Pos = 0x14
	// Bit mask of COPEN0 field.
	TC_COUNT8_CTRLA_COPEN0_Msk = 0x100000
	// Bit COPEN0.
	TC_COUNT8_CTRLA_COPEN0 = 0x100000
	// Position of COPEN1 field.
	TC_COUNT8_CTRLA_COPEN1_Pos = 0x15
	// Bit mask of COPEN1 field.
	TC_COUNT8_CTRLA_COPEN1_Msk = 0x200000
	// Bit COPEN1.
	TC_COUNT8_CTRLA_COPEN1 = 0x200000
	// Position of CAPTMODE0 field.
	TC_COUNT8_CTRLA_CAPTMODE0_Pos = 0x18
	// Bit mask of CAPTMODE0 field.
	TC_COUNT8_CTRLA_CAPTMODE0_Msk = 0x3000000
	// Default capture
	TC_COUNT8_CTRLA_CAPTMODE0_DEFAULT = 0x0
	// Minimum capture
	TC_COUNT8_CTRLA_CAPTMODE0_CAPTMIN = 0x1
	// Maximum capture
	TC_COUNT8_CTRLA_CAPTMODE0_CAPTMAX = 0x2
	// Position of CAPTMODE1 field.
	TC_COUNT8_CTRLA_CAPTMODE1_Pos = 0x1b
	// Bit mask of CAPTMODE1 field.
	TC_COUNT8_CTRLA_CAPTMODE1_Msk = 0x18000000
	// Default capture
	TC_COUNT8_CTRLA_CAPTMODE1_DEFAULT = 0x0
	// Minimum capture
	TC_COUNT8_CTRLA_CAPTMODE1_CAPTMIN = 0x1
	// Maximum capture
	TC_COUNT8_CTRLA_CAPTMODE1_CAPTMAX = 0x2

	// CTRLBCLR: Control B Clear
	// Position of DIR field.
	TC_COUNT8_CTRLBCLR_DIR_Pos = 0x0
	// Bit mask of DIR field.
	TC_COUNT8_CTRLBCLR_DIR_Msk = 0x1
	// Bit DIR.
	TC_COUNT8_CTRLBCLR_DIR = 0x1
	// Position of LUPD field.
	TC_COUNT8_CTRLBCLR_LUPD_Pos = 0x1
	// Bit mask of LUPD field.
	TC_COUNT8_CTRLBCLR_LUPD_Msk = 0x2
	// Bit LUPD.
	TC_COUNT8_CTRLBCLR_LUPD = 0x2
	// Position of ONESHOT field.
	TC_COUNT8_CTRLBCLR_ONESHOT_Pos = 0x2
	// Bit mask of ONESHOT field.
	TC_COUNT8_CTRLBCLR_ONESHOT_Msk = 0x4
	// Bit ONESHOT.
	TC_COUNT8_CTRLBCLR_ONESHOT = 0x4
	// Position of CMD field.
	TC_COUNT8_CTRLBCLR_CMD_Pos = 0x5
	// Bit mask of CMD field.
	TC_COUNT8_CTRLBCLR_CMD_Msk = 0xe0
	// No action
	TC_COUNT8_CTRLBCLR_CMD_NONE = 0x0
	// Force a start, restart or retrigger
	TC_COUNT8_CTRLBCLR_CMD_RETRIGGER = 0x1
	// Force a stop
	TC_COUNT8_CTRLBCLR_CMD_STOP = 0x2
	// Force update of double-buffered register
	TC_COUNT8_CTRLBCLR_CMD_UPDATE = 0x3
	// Force a read synchronization of COUNT
	TC_COUNT8_CTRLBCLR_CMD_READSYNC = 0x4
	// One-shot DMA trigger
	TC_COUNT8_CTRLBCLR_CMD_DMAOS = 0x5

	// CTRLBSET: Control B Set
	// Position of DIR field.
	TC_COUNT8_CTRLBSET_DIR_Pos = 0x0
	// Bit mask of DIR field.
	TC_COUNT8_CTRLBSET_DIR_Msk = 0x1
	// Bit DIR.
	TC_COUNT8_CTRLBSET_DIR = 0x1
	// Position of LUPD field.
	TC_COUNT8_CTRLBSET_LUPD_Pos = 0x1
	// Bit mask of LUPD field.
	TC_COUNT8_CTRLBSET_LUPD_Msk = 0x2
	// Bit LUPD.
	TC_COUNT8_CTRLBSET_LUPD = 0x2
	// Position of ONESHOT field.
	TC_COUNT8_CTRLBSET_ONESHOT_Pos = 0x2
	// Bit mask of ONESHOT field.
	TC_COUNT8_CTRLBSET_ONESHOT_Msk = 0x4
	// Bit ONESHOT.
	TC_COUNT8_CTRLBSET_ONESHOT = 0x4
	// Position of CMD field.
	TC_COUNT8_CTRLBSET_CMD_Pos = 0x5
	// Bit mask of CMD field.
	TC_COUNT8_CTRLBSET_CMD_Msk = 0xe0
	// No action
	TC_COUNT8_CTRLBSET_CMD_NONE = 0x0
	// Force a start, restart or retrigger
	TC_COUNT8_CTRLBSET_CMD_RETRIGGER = 0x1
	// Force a stop
	TC_COUNT8_CTRLBSET_CMD_STOP = 0x2
	// Force update of double-buffered register
	TC_COUNT8_CTRLBSET_CMD_UPDATE = 0x3
	// Force a read synchronization of COUNT
	TC_COUNT8_CTRLBSET_CMD_READSYNC = 0x4
	// One-shot DMA trigger
	TC_COUNT8_CTRLBSET_CMD_DMAOS = 0x5

	// EVCTRL: Event Control
	// Position of EVACT field.
	TC_COUNT8_EVCTRL_EVACT_Pos = 0x0
	// Bit mask of EVACT field.
	TC_COUNT8_EVCTRL_EVACT_Msk = 0x7
	// Event action disabled
	TC_COUNT8_EVCTRL_EVACT_OFF = 0x0
	// Start, restart or retrigger TC on event
	TC_COUNT8_EVCTRL_EVACT_RETRIGGER = 0x1
	// Count on event
	TC_COUNT8_EVCTRL_EVACT_COUNT = 0x2
	// Start TC on event
	TC_COUNT8_EVCTRL_EVACT_START = 0x3
	// Time stamp capture
	TC_COUNT8_EVCTRL_EVACT_STAMP = 0x4
	// Period catured in CC0, pulse width in CC1
	TC_COUNT8_EVCTRL_EVACT_PPW = 0x5
	// Period catured in CC1, pulse width in CC0
	TC_COUNT8_EVCTRL_EVACT_PWP = 0x6
	// Pulse width capture
	TC_COUNT8_EVCTRL_EVACT_PW = 0x7
	// Position of TCINV field.
	TC_COUNT8_EVCTRL_TCINV_Pos = 0x4
	// Bit mask of TCINV field.
	TC_COUNT8_EVCTRL_TCINV_Msk = 0x10
	// Bit TCINV.
	TC_COUNT8_EVCTRL_TCINV = 0x10
	// Position of TCEI field.
	TC_COUNT8_EVCTRL_TCEI_Pos = 0x5
	// Bit mask of TCEI field.
	TC_COUNT8_EVCTRL_TCEI_Msk = 0x20
	// Bit TCEI.
	TC_COUNT8_EVCTRL_TCEI = 0x20
	// Position of OVFEO field.
	TC_COUNT8_EVCTRL_OVFEO_Pos = 0x8
	// Bit mask of OVFEO field.
	TC_COUNT8_EVCTRL_OVFEO_Msk = 0x100
	// Bit OVFEO.
	TC_COUNT8_EVCTRL_OVFEO = 0x100
	// Position of MCEO0 field.
	TC_COUNT8_EVCTRL_MCEO0_Pos = 0xc
	// Bit mask of MCEO0 field.
	TC_COUNT8_EVCTRL_MCEO0_Msk = 0x1000
	// Bit MCEO0.
	TC_COUNT8_EVCTRL_MCEO0 = 0x1000
	// Position of MCEO1 field.
	TC_COUNT8_EVCTRL_MCEO1_Pos = 0xd
	// Bit mask of MCEO1 field.
	TC_COUNT8_EVCTRL_MCEO1_Msk = 0x2000
	// Bit MCEO1.
	TC_COUNT8_EVCTRL_MCEO1 = 0x2000

	// INTENCLR: Interrupt Enable Clear
	// Position of OVF field.
	TC_COUNT8_INTENCLR_OVF_Pos = 0x0
	// Bit mask of OVF field.
	TC_COUNT8_INTENCLR_OVF_Msk = 0x1
	// Bit OVF.
	TC_COUNT8_INTENCLR_OVF = 0x1
	// Position of ERR field.
	TC_COUNT8_INTENCLR_ERR_Pos = 0x1
	// Bit mask of ERR field.
	TC_COUNT8_INTENCLR_ERR_Msk = 0x2
	// Bit ERR.
	TC_COUNT8_INTENCLR_ERR = 0x2
	// Position of MC0 field.
	TC_COUNT8_INTENCLR_MC0_Pos = 0x4
	// Bit mask of MC0 field.
	TC_COUNT8_INTENCLR_MC0_Msk = 0x10
	// Bit MC0.
	TC_COUNT8_INTENCLR_MC0 = 0x10
	// Position of MC1 field.
	TC_COUNT8_INTENCLR_MC1_Pos = 0x5
	// Bit mask of MC1 field.
	TC_COUNT8_INTENCLR_MC1_Msk = 0x20
	// Bit MC1.
	TC_COUNT8_INTENCLR_MC1 = 0x20

	// INTENSET: Interrupt Enable Set
	// Position of OVF field.
	TC_COUNT8_INTENSET_OVF_Pos = 0x0
	// Bit mask of OVF field.
	TC_COUNT8_INTENSET_OVF_Msk = 0x1
	// Bit OVF.
	TC_COUNT8_INTENSET_OVF = 0x1
	// Position of ERR field.
	TC_COUNT8_INTENSET_ERR_Pos = 0x1
	// Bit mask of ERR field.
	TC_COUNT8_INTENSET_ERR_Msk = 0x2
	// Bit ERR.
	TC_COUNT8_INTENSET_ERR = 0x2
	// Position of MC0 field.
	TC_COUNT8_INTENSET_MC0_Pos = 0x4
	// Bit mask of MC0 field.
	TC_COUNT8_INTENSET_MC0_Msk = 0x10
	// Bit MC0.
	TC_COUNT8_INTENSET_MC0 = 0x10
	// Position of MC1 field.
	TC_COUNT8_INTENSET_MC1_Pos = 0x5
	// Bit mask of MC1 field.
	TC_COUNT8_INTENSET_MC1_Msk = 0x20
	// Bit MC1.
	TC_COUNT8_INTENSET_MC1 = 0x20

	// INTFLAG: Interrupt Flag Status and Clear
	// Position of OVF field.
	TC_COUNT8_INTFLAG_OVF_Pos = 0x0
	// Bit mask of OVF field.
	TC_COUNT8_INTFLAG_OVF_Msk = 0x1
	// Bit OVF.
	TC_COUNT8_INTFLAG_OVF = 0x1
	// Position of ERR field.
	TC_COUNT8_INTFLAG_ERR_Pos = 0x1
	// Bit mask of ERR field.
	TC_COUNT8_INTFLAG_ERR_Msk = 0x2
	// Bit ERR.
	TC_COUNT8_INTFLAG_ERR = 0x2
	// Position of MC0 field.
	TC_COUNT8_INTFLAG_MC0_Pos = 0x4
	// Bit mask of MC0 field.
	TC_COUNT8_INTFLAG_MC0_Msk = 0x10
	// Bit MC0.
	TC_COUNT8_INTFLAG_MC0 = 0x10
	// Position of MC1 field.
	TC_COUNT8_INTFLAG_MC1_Pos = 0x5
	// Bit mask of MC1 field.
	TC_COUNT8_INTFLAG_MC1_Msk = 0x20
	// Bit MC1.
	TC_COUNT8_INTFLAG_MC1 = 0x20

	// STATUS: Status
	// Position of STOP field.
	TC_COUNT8_STATUS_STOP_Pos = 0x0
	// Bit mask of STOP field.
	TC_COUNT8_STATUS_STOP_Msk = 0x1
	// Bit STOP.
	TC_COUNT8_STATUS_STOP = 0x1
	// Position of SLAVE field.
	TC_COUNT8_STATUS_SLAVE_Pos = 0x1
	// Bit mask of SLAVE field.
	TC_COUNT8_STATUS_SLAVE_Msk = 0x2
	// Bit SLAVE.
	TC_COUNT8_STATUS_SLAVE = 0x2
	// Position of PERBUFV field.
	TC_COUNT8_STATUS_PERBUFV_Pos = 0x3
	// Bit mask of PERBUFV field.
	TC_COUNT8_STATUS_PERBUFV_Msk = 0x8
	// Bit PERBUFV.
	TC_COUNT8_STATUS_PERBUFV = 0x8
	// Position of CCBUFV0 field.
	TC_COUNT8_STATUS_CCBUFV0_Pos = 0x4
	// Bit mask of CCBUFV0 field.
	TC_COUNT8_STATUS_CCBUFV0_Msk = 0x10
	// Bit CCBUFV0.
	TC_COUNT8_STATUS_CCBUFV0 = 0x10
	// Position of CCBUFV1 field.
	TC_COUNT8_STATUS_CCBUFV1_Pos = 0x5
	// Bit mask of CCBUFV1 field.
	TC_COUNT8_STATUS_CCBUFV1_Msk = 0x20
	// Bit CCBUFV1.
	TC_COUNT8_STATUS_CCBUFV1 = 0x20

	// WAVE: Waveform Generation Control
	// Position of WAVEGEN field.
	TC_COUNT8_WAVE_WAVEGEN_Pos = 0x0
	// Bit mask of WAVEGEN field.
	TC_COUNT8_WAVE_WAVEGEN_Msk = 0x3
	// Normal frequency
	TC_COUNT8_WAVE_WAVEGEN_NFRQ = 0x0
	// Match frequency
	TC_COUNT8_WAVE_WAVEGEN_MFRQ = 0x1
	// Normal PWM
	TC_COUNT8_WAVE_WAVEGEN_NPWM = 0x2
	// Match PWM
	TC_COUNT8_WAVE_WAVEGEN_MPWM = 0x3

	// DRVCTRL: Control C
	// Position of INVEN0 field.
	TC_COUNT8_DRVCTRL_INVEN0_Pos = 0x0
	// Bit mask of INVEN0 field.
	TC_COUNT8_DRVCTRL_INVEN0_Msk = 0x1
	// Bit INVEN0.
	TC_COUNT8_DRVCTRL_INVEN0 = 0x1
	// Position of INVEN1 field.
	TC_COUNT8_DRVCTRL_INVEN1_Pos = 0x1
	// Bit mask of INVEN1 field.
	TC_COUNT8_DRVCTRL_INVEN1_Msk = 0x2
	// Bit INVEN1.
	TC_COUNT8_DRVCTRL_INVEN1 = 0x2

	// DBGCTRL: Debug Control
	// Position of DBGRUN field.
	TC_COUNT8_DBGCTRL_DBGRUN_Pos = 0x0
	// Bit mask of DBGRUN field.
	TC_COUNT8_DBGCTRL_DBGRUN_Msk = 0x1
	// Bit DBGRUN.
	TC_COUNT8_DBGCTRL_DBGRUN = 0x1

	// SYNCBUSY: Synchronization Status
	// Position of SWRST field.
	TC_COUNT8_SYNCBUSY_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	TC_COUNT8_SYNCBUSY_SWRST_Msk = 0x1
	// Bit SWRST.
	TC_COUNT8_SYNCBUSY_SWRST = 0x1
	// Position of ENABLE field.
	TC_COUNT8_SYNCBUSY_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	TC_COUNT8_SYNCBUSY_ENABLE_Msk = 0x2
	// Bit ENABLE.
	TC_COUNT8_SYNCBUSY_ENABLE = 0x2
	// Position of CTRLB field.
	TC_COUNT8_SYNCBUSY_CTRLB_Pos = 0x2
	// Bit mask of CTRLB field.
	TC_COUNT8_SYNCBUSY_CTRLB_Msk = 0x4
	// Bit CTRLB.
	TC_COUNT8_SYNCBUSY_CTRLB = 0x4
	// Position of STATUS field.
	TC_COUNT8_SYNCBUSY_STATUS_Pos = 0x3
	// Bit mask of STATUS field.
	TC_COUNT8_SYNCBUSY_STATUS_Msk = 0x8
	// Bit STATUS.
	TC_COUNT8_SYNCBUSY_STATUS = 0x8
	// Position of COUNT field.
	TC_COUNT8_SYNCBUSY_COUNT_Pos = 0x4
	// Bit mask of COUNT field.
	TC_COUNT8_SYNCBUSY_COUNT_Msk = 0x10
	// Bit COUNT.
	TC_COUNT8_SYNCBUSY_COUNT = 0x10
	// Position of PER field.
	TC_COUNT8_SYNCBUSY_PER_Pos = 0x5
	// Bit mask of PER field.
	TC_COUNT8_SYNCBUSY_PER_Msk = 0x20
	// Bit PER.
	TC_COUNT8_SYNCBUSY_PER = 0x20
	// Position of CC0 field.
	TC_COUNT8_SYNCBUSY_CC0_Pos = 0x6
	// Bit mask of CC0 field.
	TC_COUNT8_SYNCBUSY_CC0_Msk = 0x40
	// Bit CC0.
	TC_COUNT8_SYNCBUSY_CC0 = 0x40
	// Position of CC1 field.
	TC_COUNT8_SYNCBUSY_CC1_Pos = 0x7
	// Bit mask of CC1 field.
	TC_COUNT8_SYNCBUSY_CC1_Msk = 0x80
	// Bit CC1.
	TC_COUNT8_SYNCBUSY_CC1 = 0x80

	// COUNT: COUNT8 Count
	// Position of COUNT field.
	TC_COUNT8_COUNT_COUNT_Pos = 0x0
	// Bit mask of COUNT field.
	TC_COUNT8_COUNT_COUNT_Msk = 0xff

	// PER: COUNT8 Period
	// Position of PER field.
	TC_COUNT8_PER_PER_Pos = 0x0
	// Bit mask of PER field.
	TC_COUNT8_PER_PER_Msk = 0xff

	// CC: COUNT8 Compare and Capture
	// Position of CC field.
	TC_COUNT8_CC_CC_Pos = 0x0
	// Bit mask of CC field.
	TC_COUNT8_CC_CC_Msk = 0xff

	// PERBUF: COUNT8 Period Buffer
	// Position of PERBUF field.
	TC_COUNT8_PERBUF_PERBUF_Pos = 0x0
	// Bit mask of PERBUF field.
	TC_COUNT8_PERBUF_PERBUF_Msk = 0xff

	// CCBUF: COUNT8 Compare and Capture Buffer
	// Position of CCBUF field.
	TC_COUNT8_CCBUF_CCBUF_Pos = 0x0
	// Bit mask of CCBUF field.
	TC_COUNT8_CCBUF_CCBUF_Msk = 0xff
)

// Constants for TC0_COUNT16: Basic Timer Counter - COUNT16
const (
	// CTRLA: Control A
	// Position of SWRST field.
	TC_COUNT16_CTRLA_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	TC_COUNT16_CTRLA_SWRST_Msk = 0x1
	// Bit SWRST.
	TC_COUNT16_CTRLA_SWRST = 0x1
	// Position of ENABLE field.
	TC_COUNT16_CTRLA_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	TC_COUNT16_CTRLA_ENABLE_Msk = 0x2
	// Bit ENABLE.
	TC_COUNT16_CTRLA_ENABLE = 0x2
	// Position of MODE field.
	TC_COUNT16_CTRLA_MODE_Pos = 0x2
	// Bit mask of MODE field.
	TC_COUNT16_CTRLA_MODE_Msk = 0xc
	// Counter in 16-bit mode
	TC_COUNT16_CTRLA_MODE_COUNT16 = 0x0
	// Counter in 8-bit mode
	TC_COUNT16_CTRLA_MODE_COUNT8 = 0x1
	// Counter in 32-bit mode
	TC_COUNT16_CTRLA_MODE_COUNT32 = 0x2
	// Position of PRESCSYNC field.
	TC_COUNT16_CTRLA_PRESCSYNC_Pos = 0x4
	// Bit mask of PRESCSYNC field.
	TC_COUNT16_CTRLA_PRESCSYNC_Msk = 0x30
	// Reload or reset the counter on next generic clock
	TC_COUNT16_CTRLA_PRESCSYNC_GCLK = 0x0
	// Reload or reset the counter on next prescaler clock
	TC_COUNT16_CTRLA_PRESCSYNC_PRESC = 0x1
	// Reload or reset the counter on next generic clock and reset the prescaler counter
	TC_COUNT16_CTRLA_PRESCSYNC_RESYNC = 0x2
	// Position of RUNSTDBY field.
	TC_COUNT16_CTRLA_RUNSTDBY_Pos = 0x6
	// Bit mask of RUNSTDBY field.
	TC_COUNT16_CTRLA_RUNSTDBY_Msk = 0x40
	// Bit RUNSTDBY.
	TC_COUNT16_CTRLA_RUNSTDBY = 0x40
	// Position of ONDEMAND field.
	TC_COUNT16_CTRLA_ONDEMAND_Pos = 0x7
	// Bit mask of ONDEMAND field.
	TC_COUNT16_CTRLA_ONDEMAND_Msk = 0x80
	// Bit ONDEMAND.
	TC_COUNT16_CTRLA_ONDEMAND = 0x80
	// Position of PRESCALER field.
	TC_COUNT16_CTRLA_PRESCALER_Pos = 0x8
	// Bit mask of PRESCALER field.
	TC_COUNT16_CTRLA_PRESCALER_Msk = 0x700
	// Prescaler: GCLK_TC
	TC_COUNT16_CTRLA_PRESCALER_DIV1 = 0x0
	// Prescaler: GCLK_TC/2
	TC_COUNT16_CTRLA_PRESCALER_DIV2 = 0x1
	// Prescaler: GCLK_TC/4
	TC_COUNT16_CTRLA_PRESCALER_DIV4 = 0x2
	// Prescaler: GCLK_TC/8
	TC_COUNT16_CTRLA_PRESCALER_DIV8 = 0x3
	// Prescaler: GCLK_TC/16
	TC_COUNT16_CTRLA_PRESCALER_DIV16 = 0x4
	// Prescaler: GCLK_TC/64
	TC_COUNT16_CTRLA_PRESCALER_DIV64 = 0x5
	// Prescaler: GCLK_TC/256
	TC_COUNT16_CTRLA_PRESCALER_DIV256 = 0x6
	// Prescaler: GCLK_TC/1024
	TC_COUNT16_CTRLA_PRESCALER_DIV1024 = 0x7
	// Position of ALOCK field.
	TC_COUNT16_CTRLA_ALOCK_Pos = 0xb
	// Bit mask of ALOCK field.
	TC_COUNT16_CTRLA_ALOCK_Msk = 0x800
	// Bit ALOCK.
	TC_COUNT16_CTRLA_ALOCK = 0x800
	// Position of CAPTEN0 field.
	TC_COUNT16_CTRLA_CAPTEN0_Pos = 0x10
	// Bit mask of CAPTEN0 field.
	TC_COUNT16_CTRLA_CAPTEN0_Msk = 0x10000
	// Bit CAPTEN0.
	TC_COUNT16_CTRLA_CAPTEN0 = 0x10000
	// Position of CAPTEN1 field.
	TC_COUNT16_CTRLA_CAPTEN1_Pos = 0x11
	// Bit mask of CAPTEN1 field.
	TC_COUNT16_CTRLA_CAPTEN1_Msk = 0x20000
	// Bit CAPTEN1.
	TC_COUNT16_CTRLA_CAPTEN1 = 0x20000
	// Position of COPEN0 field.
	TC_COUNT16_CTRLA_COPEN0_Pos = 0x14
	// Bit mask of COPEN0 field.
	TC_COUNT16_CTRLA_COPEN0_Msk = 0x100000
	// Bit COPEN0.
	TC_COUNT16_CTRLA_COPEN0 = 0x100000
	// Position of COPEN1 field.
	TC_COUNT16_CTRLA_COPEN1_Pos = 0x15
	// Bit mask of COPEN1 field.
	TC_COUNT16_CTRLA_COPEN1_Msk = 0x200000
	// Bit COPEN1.
	TC_COUNT16_CTRLA_COPEN1 = 0x200000
	// Position of CAPTMODE0 field.
	TC_COUNT16_CTRLA_CAPTMODE0_Pos = 0x18
	// Bit mask of CAPTMODE0 field.
	TC_COUNT16_CTRLA_CAPTMODE0_Msk = 0x3000000
	// Default capture
	TC_COUNT16_CTRLA_CAPTMODE0_DEFAULT = 0x0
	// Minimum capture
	TC_COUNT16_CTRLA_CAPTMODE0_CAPTMIN = 0x1
	// Maximum capture
	TC_COUNT16_CTRLA_CAPTMODE0_CAPTMAX = 0x2
	// Position of CAPTMODE1 field.
	TC_COUNT16_CTRLA_CAPTMODE1_Pos = 0x1b
	// Bit mask of CAPTMODE1 field.
	TC_COUNT16_CTRLA_CAPTMODE1_Msk = 0x18000000
	// Default capture
	TC_COUNT16_CTRLA_CAPTMODE1_DEFAULT = 0x0
	// Minimum capture
	TC_COUNT16_CTRLA_CAPTMODE1_CAPTMIN = 0x1
	// Maximum capture
	TC_COUNT16_CTRLA_CAPTMODE1_CAPTMAX = 0x2

	// CTRLBCLR: Control B Clear
	// Position of DIR field.
	TC_COUNT16_CTRLBCLR_DIR_Pos = 0x0
	// Bit mask of DIR field.
	TC_COUNT16_CTRLBCLR_DIR_Msk = 0x1
	// Bit DIR.
	TC_COUNT16_CTRLBCLR_DIR = 0x1
	// Position of LUPD field.
	TC_COUNT16_CTRLBCLR_LUPD_Pos = 0x1
	// Bit mask of LUPD field.
	TC_COUNT16_CTRLBCLR_LUPD_Msk = 0x2
	// Bit LUPD.
	TC_COUNT16_CTRLBCLR_LUPD = 0x2
	// Position of ONESHOT field.
	TC_COUNT16_CTRLBCLR_ONESHOT_Pos = 0x2
	// Bit mask of ONESHOT field.
	TC_COUNT16_CTRLBCLR_ONESHOT_Msk = 0x4
	// Bit ONESHOT.
	TC_COUNT16_CTRLBCLR_ONESHOT = 0x4
	// Position of CMD field.
	TC_COUNT16_CTRLBCLR_CMD_Pos = 0x5
	// Bit mask of CMD field.
	TC_COUNT16_CTRLBCLR_CMD_Msk = 0xe0
	// No action
	TC_COUNT16_CTRLBCLR_CMD_NONE = 0x0
	// Force a start, restart or retrigger
	TC_COUNT16_CTRLBCLR_CMD_RETRIGGER = 0x1
	// Force a stop
	TC_COUNT16_CTRLBCLR_CMD_STOP = 0x2
	// Force update of double-buffered register
	TC_COUNT16_CTRLBCLR_CMD_UPDATE = 0x3
	// Force a read synchronization of COUNT
	TC_COUNT16_CTRLBCLR_CMD_READSYNC = 0x4
	// One-shot DMA trigger
	TC_COUNT16_CTRLBCLR_CMD_DMAOS = 0x5

	// CTRLBSET: Control B Set
	// Position of DIR field.
	TC_COUNT16_CTRLBSET_DIR_Pos = 0x0
	// Bit mask of DIR field.
	TC_COUNT16_CTRLBSET_DIR_Msk = 0x1
	// Bit DIR.
	TC_COUNT16_CTRLBSET_DIR = 0x1
	// Position of LUPD field.
	TC_COUNT16_CTRLBSET_LUPD_Pos = 0x1
	// Bit mask of LUPD field.
	TC_COUNT16_CTRLBSET_LUPD_Msk = 0x2
	// Bit LUPD.
	TC_COUNT16_CTRLBSET_LUPD = 0x2
	// Position of ONESHOT field.
	TC_COUNT16_CTRLBSET_ONESHOT_Pos = 0x2
	// Bit mask of ONESHOT field.
	TC_COUNT16_CTRLBSET_ONESHOT_Msk = 0x4
	// Bit ONESHOT.
	TC_COUNT16_CTRLBSET_ONESHOT = 0x4
	// Position of CMD field.
	TC_COUNT16_CTRLBSET_CMD_Pos = 0x5
	// Bit mask of CMD field.
	TC_COUNT16_CTRLBSET_CMD_Msk = 0xe0
	// No action
	TC_COUNT16_CTRLBSET_CMD_NONE = 0x0
	// Force a start, restart or retrigger
	TC_COUNT16_CTRLBSET_CMD_RETRIGGER = 0x1
	// Force a stop
	TC_COUNT16_CTRLBSET_CMD_STOP = 0x2
	// Force update of double-buffered register
	TC_COUNT16_CTRLBSET_CMD_UPDATE = 0x3
	// Force a read synchronization of COUNT
	TC_COUNT16_CTRLBSET_CMD_READSYNC = 0x4
	// One-shot DMA trigger
	TC_COUNT16_CTRLBSET_CMD_DMAOS = 0x5

	// EVCTRL: Event Control
	// Position of EVACT field.
	TC_COUNT16_EVCTRL_EVACT_Pos = 0x0
	// Bit mask of EVACT field.
	TC_COUNT16_EVCTRL_EVACT_Msk = 0x7
	// Event action disabled
	TC_COUNT16_EVCTRL_EVACT_OFF = 0x0
	// Start, restart or retrigger TC on event
	TC_COUNT16_EVCTRL_EVACT_RETRIGGER = 0x1
	// Count on event
	TC_COUNT16_EVCTRL_EVACT_COUNT = 0x2
	// Start TC on event
	TC_COUNT16_EVCTRL_EVACT_START = 0x3
	// Time stamp capture
	TC_COUNT16_EVCTRL_EVACT_STAMP = 0x4
	// Period catured in CC0, pulse width in CC1
	TC_COUNT16_EVCTRL_EVACT_PPW = 0x5
	// Period catured in CC1, pulse width in CC0
	TC_COUNT16_EVCTRL_EVACT_PWP = 0x6
	// Pulse width capture
	TC_COUNT16_EVCTRL_EVACT_PW = 0x7
	// Position of TCINV field.
	TC_COUNT16_EVCTRL_TCINV_Pos = 0x4
	// Bit mask of TCINV field.
	TC_COUNT16_EVCTRL_TCINV_Msk = 0x10
	// Bit TCINV.
	TC_COUNT16_EVCTRL_TCINV = 0x10
	// Position of TCEI field.
	TC_COUNT16_EVCTRL_TCEI_Pos = 0x5
	// Bit mask of TCEI field.
	TC_COUNT16_EVCTRL_TCEI_Msk = 0x20
	// Bit TCEI.
	TC_COUNT16_EVCTRL_TCEI = 0x20
	// Position of OVFEO field.
	TC_COUNT16_EVCTRL_OVFEO_Pos = 0x8
	// Bit mask of OVFEO field.
	TC_COUNT16_EVCTRL_OVFEO_Msk = 0x100
	// Bit OVFEO.
	TC_COUNT16_EVCTRL_OVFEO = 0x100
	// Position of MCEO0 field.
	TC_COUNT16_EVCTRL_MCEO0_Pos = 0xc
	// Bit mask of MCEO0 field.
	TC_COUNT16_EVCTRL_MCEO0_Msk = 0x1000
	// Bit MCEO0.
	TC_COUNT16_EVCTRL_MCEO0 = 0x1000
	// Position of MCEO1 field.
	TC_COUNT16_EVCTRL_MCEO1_Pos = 0xd
	// Bit mask of MCEO1 field.
	TC_COUNT16_EVCTRL_MCEO1_Msk = 0x2000
	// Bit MCEO1.
	TC_COUNT16_EVCTRL_MCEO1 = 0x2000

	// INTENCLR: Interrupt Enable Clear
	// Position of OVF field.
	TC_COUNT16_INTENCLR_OVF_Pos = 0x0
	// Bit mask of OVF field.
	TC_COUNT16_INTENCLR_OVF_Msk = 0x1
	// Bit OVF.
	TC_COUNT16_INTENCLR_OVF = 0x1
	// Position of ERR field.
	TC_COUNT16_INTENCLR_ERR_Pos = 0x1
	// Bit mask of ERR field.
	TC_COUNT16_INTENCLR_ERR_Msk = 0x2
	// Bit ERR.
	TC_COUNT16_INTENCLR_ERR = 0x2
	// Position of MC0 field.
	TC_COUNT16_INTENCLR_MC0_Pos = 0x4
	// Bit mask of MC0 field.
	TC_COUNT16_INTENCLR_MC0_Msk = 0x10
	// Bit MC0.
	TC_COUNT16_INTENCLR_MC0 = 0x10
	// Position of MC1 field.
	TC_COUNT16_INTENCLR_MC1_Pos = 0x5
	// Bit mask of MC1 field.
	TC_COUNT16_INTENCLR_MC1_Msk = 0x20
	// Bit MC1.
	TC_COUNT16_INTENCLR_MC1 = 0x20

	// INTENSET: Interrupt Enable Set
	// Position of OVF field.
	TC_COUNT16_INTENSET_OVF_Pos = 0x0
	// Bit mask of OVF field.
	TC_COUNT16_INTENSET_OVF_Msk = 0x1
	// Bit OVF.
	TC_COUNT16_INTENSET_OVF = 0x1
	// Position of ERR field.
	TC_COUNT16_INTENSET_ERR_Pos = 0x1
	// Bit mask of ERR field.
	TC_COUNT16_INTENSET_ERR_Msk = 0x2
	// Bit ERR.
	TC_COUNT16_INTENSET_ERR = 0x2
	// Position of MC0 field.
	TC_COUNT16_INTENSET_MC0_Pos = 0x4
	// Bit mask of MC0 field.
	TC_COUNT16_INTENSET_MC0_Msk = 0x10
	// Bit MC0.
	TC_COUNT16_INTENSET_MC0 = 0x10
	// Position of MC1 field.
	TC_COUNT16_INTENSET_MC1_Pos = 0x5
	// Bit mask of MC1 field.
	TC_COUNT16_INTENSET_MC1_Msk = 0x20
	// Bit MC1.
	TC_COUNT16_INTENSET_MC1 = 0x20

	// INTFLAG: Interrupt Flag Status and Clear
	// Position of OVF field.
	TC_COUNT16_INTFLAG_OVF_Pos = 0x0
	// Bit mask of OVF field.
	TC_COUNT16_INTFLAG_OVF_Msk = 0x1
	// Bit OVF.
	TC_COUNT16_INTFLAG_OVF = 0x1
	// Position of ERR field.
	TC_COUNT16_INTFLAG_ERR_Pos = 0x1
	// Bit mask of ERR field.
	TC_COUNT16_INTFLAG_ERR_Msk = 0x2
	// Bit ERR.
	TC_COUNT16_INTFLAG_ERR = 0x2
	// Position of MC0 field.
	TC_COUNT16_INTFLAG_MC0_Pos = 0x4
	// Bit mask of MC0 field.
	TC_COUNT16_INTFLAG_MC0_Msk = 0x10
	// Bit MC0.
	TC_COUNT16_INTFLAG_MC0 = 0x10
	// Position of MC1 field.
	TC_COUNT16_INTFLAG_MC1_Pos = 0x5
	// Bit mask of MC1 field.
	TC_COUNT16_INTFLAG_MC1_Msk = 0x20
	// Bit MC1.
	TC_COUNT16_INTFLAG_MC1 = 0x20

	// STATUS: Status
	// Position of STOP field.
	TC_COUNT16_STATUS_STOP_Pos = 0x0
	// Bit mask of STOP field.
	TC_COUNT16_STATUS_STOP_Msk = 0x1
	// Bit STOP.
	TC_COUNT16_STATUS_STOP = 0x1
	// Position of SLAVE field.
	TC_COUNT16_STATUS_SLAVE_Pos = 0x1
	// Bit mask of SLAVE field.
	TC_COUNT16_STATUS_SLAVE_Msk = 0x2
	// Bit SLAVE.
	TC_COUNT16_STATUS_SLAVE = 0x2
	// Position of PERBUFV field.
	TC_COUNT16_STATUS_PERBUFV_Pos = 0x3
	// Bit mask of PERBUFV field.
	TC_COUNT16_STATUS_PERBUFV_Msk = 0x8
	// Bit PERBUFV.
	TC_COUNT16_STATUS_PERBUFV = 0x8
	// Position of CCBUFV0 field.
	TC_COUNT16_STATUS_CCBUFV0_Pos = 0x4
	// Bit mask of CCBUFV0 field.
	TC_COUNT16_STATUS_CCBUFV0_Msk = 0x10
	// Bit CCBUFV0.
	TC_COUNT16_STATUS_CCBUFV0 = 0x10
	// Position of CCBUFV1 field.
	TC_COUNT16_STATUS_CCBUFV1_Pos = 0x5
	// Bit mask of CCBUFV1 field.
	TC_COUNT16_STATUS_CCBUFV1_Msk = 0x20
	// Bit CCBUFV1.
	TC_COUNT16_STATUS_CCBUFV1 = 0x20

	// WAVE: Waveform Generation Control
	// Position of WAVEGEN field.
	TC_COUNT16_WAVE_WAVEGEN_Pos = 0x0
	// Bit mask of WAVEGEN field.
	TC_COUNT16_WAVE_WAVEGEN_Msk = 0x3
	// Normal frequency
	TC_COUNT16_WAVE_WAVEGEN_NFRQ = 0x0
	// Match frequency
	TC_COUNT16_WAVE_WAVEGEN_MFRQ = 0x1
	// Normal PWM
	TC_COUNT16_WAVE_WAVEGEN_NPWM = 0x2
	// Match PWM
	TC_COUNT16_WAVE_WAVEGEN_MPWM = 0x3

	// DRVCTRL: Control C
	// Position of INVEN0 field.
	TC_COUNT16_DRVCTRL_INVEN0_Pos = 0x0
	// Bit mask of INVEN0 field.
	TC_COUNT16_DRVCTRL_INVEN0_Msk = 0x1
	// Bit INVEN0.
	TC_COUNT16_DRVCTRL_INVEN0 = 0x1
	// Position of INVEN1 field.
	TC_COUNT16_DRVCTRL_INVEN1_Pos = 0x1
	// Bit mask of INVEN1 field.
	TC_COUNT16_DRVCTRL_INVEN1_Msk = 0x2
	// Bit INVEN1.
	TC_COUNT16_DRVCTRL_INVEN1 = 0x2

	// DBGCTRL: Debug Control
	// Position of DBGRUN field.
	TC_COUNT16_DBGCTRL_DBGRUN_Pos = 0x0
	// Bit mask of DBGRUN field.
	TC_COUNT16_DBGCTRL_DBGRUN_Msk = 0x1
	// Bit DBGRUN.
	TC_COUNT16_DBGCTRL_DBGRUN = 0x1

	// SYNCBUSY: Synchronization Status
	// Position of SWRST field.
	TC_COUNT16_SYNCBUSY_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	TC_COUNT16_SYNCBUSY_SWRST_Msk = 0x1
	// Bit SWRST.
	TC_COUNT16_SYNCBUSY_SWRST = 0x1
	// Position of ENABLE field.
	TC_COUNT16_SYNCBUSY_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	TC_COUNT16_SYNCBUSY_ENABLE_Msk = 0x2
	// Bit ENABLE.
	TC_COUNT16_SYNCBUSY_ENABLE = 0x2
	// Position of CTRLB field.
	TC_COUNT16_SYNCBUSY_CTRLB_Pos = 0x2
	// Bit mask of CTRLB field.
	TC_COUNT16_SYNCBUSY_CTRLB_Msk = 0x4
	// Bit CTRLB.
	TC_COUNT16_SYNCBUSY_CTRLB = 0x4
	// Position of STATUS field.
	TC_COUNT16_SYNCBUSY_STATUS_Pos = 0x3
	// Bit mask of STATUS field.
	TC_COUNT16_SYNCBUSY_STATUS_Msk = 0x8
	// Bit STATUS.
	TC_COUNT16_SYNCBUSY_STATUS = 0x8
	// Position of COUNT field.
	TC_COUNT16_SYNCBUSY_COUNT_Pos = 0x4
	// Bit mask of COUNT field.
	TC_COUNT16_SYNCBUSY_COUNT_Msk = 0x10
	// Bit COUNT.
	TC_COUNT16_SYNCBUSY_COUNT = 0x10
	// Position of PER field.
	TC_COUNT16_SYNCBUSY_PER_Pos = 0x5
	// Bit mask of PER field.
	TC_COUNT16_SYNCBUSY_PER_Msk = 0x20
	// Bit PER.
	TC_COUNT16_SYNCBUSY_PER = 0x20
	// Position of CC0 field.
	TC_COUNT16_SYNCBUSY_CC0_Pos = 0x6
	// Bit mask of CC0 field.
	TC_COUNT16_SYNCBUSY_CC0_Msk = 0x40
	// Bit CC0.
	TC_COUNT16_SYNCBUSY_CC0 = 0x40
	// Position of CC1 field.
	TC_COUNT16_SYNCBUSY_CC1_Pos = 0x7
	// Bit mask of CC1 field.
	TC_COUNT16_SYNCBUSY_CC1_Msk = 0x80
	// Bit CC1.
	TC_COUNT16_SYNCBUSY_CC1 = 0x80

	// COUNT: COUNT16 Count
	// Position of COUNT field.
	TC_COUNT16_COUNT_COUNT_Pos = 0x0
	// Bit mask of COUNT field.
	TC_COUNT16_COUNT_COUNT_Msk = 0xffff

	// PER: COUNT16 Period
	// Position of PER field.
	TC_COUNT16_PER_PER_Pos = 0x0
	// Bit mask of PER field.
	TC_COUNT16_PER_PER_Msk = 0xffff

	// CC: COUNT16 Compare and Capture
	// Position of CC field.
	TC_COUNT16_CC_CC_Pos = 0x0
	// Bit mask of CC field.
	TC_COUNT16_CC_CC_Msk = 0xffff

	// PERBUF: COUNT16 Period Buffer
	// Position of PERBUF field.
	TC_COUNT16_PERBUF_PERBUF_Pos = 0x0
	// Bit mask of PERBUF field.
	TC_COUNT16_PERBUF_PERBUF_Msk = 0xffff

	// CCBUF: COUNT16 Compare and Capture Buffer
	// Position of CCBUF field.
	TC_COUNT16_CCBUF_CCBUF_Pos = 0x0
	// Bit mask of CCBUF field.
	TC_COUNT16_CCBUF_CCBUF_Msk = 0xffff
)

// Constants for TC0_COUNT32: Basic Timer Counter - COUNT32
const (
	// CTRLA: Control A
	// Position of SWRST field.
	TC_COUNT32_CTRLA_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	TC_COUNT32_CTRLA_SWRST_Msk = 0x1
	// Bit SWRST.
	TC_COUNT32_CTRLA_SWRST = 0x1
	// Position of ENABLE field.
	TC_COUNT32_CTRLA_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	TC_COUNT32_CTRLA_ENABLE_Msk = 0x2
	// Bit ENABLE.
	TC_COUNT32_CTRLA_ENABLE = 0x2
	// Position of MODE field.
	TC_COUNT32_CTRLA_MODE_Pos = 0x2
	// Bit mask of MODE field.
	TC_COUNT32_CTRLA_MODE_Msk = 0xc
	// Counter in 16-bit mode
	TC_COUNT32_CTRLA_MODE_COUNT16 = 0x0
	// Counter in 8-bit mode
	TC_COUNT32_CTRLA_MODE_COUNT8 = 0x1
	// Counter in 32-bit mode
	TC_COUNT32_CTRLA_MODE_COUNT32 = 0x2
	// Position of PRESCSYNC field.
	TC_COUNT32_CTRLA_PRESCSYNC_Pos = 0x4
	// Bit mask of PRESCSYNC field.
	TC_COUNT32_CTRLA_PRESCSYNC_Msk = 0x30
	// Reload or reset the counter on next generic clock
	TC_COUNT32_CTRLA_PRESCSYNC_GCLK = 0x0
	// Reload or reset the counter on next prescaler clock
	TC_COUNT32_CTRLA_PRESCSYNC_PRESC = 0x1
	// Reload or reset the counter on next generic clock and reset the prescaler counter
	TC_COUNT32_CTRLA_PRESCSYNC_RESYNC = 0x2
	// Position of RUNSTDBY field.
	TC_COUNT32_CTRLA_RUNSTDBY_Pos = 0x6
	// Bit mask of RUNSTDBY field.
	TC_COUNT32_CTRLA_RUNSTDBY_Msk = 0x40
	// Bit RUNSTDBY.
	TC_COUNT32_CTRLA_RUNSTDBY = 0x40
	// Position of ONDEMAND field.
	TC_COUNT32_CTRLA_ONDEMAND_Pos = 0x7
	// Bit mask of ONDEMAND field.
	TC_COUNT32_CTRLA_ONDEMAND_Msk = 0x80
	// Bit ONDEMAND.
	TC_COUNT32_CTRLA_ONDEMAND = 0x80
	// Position of PRESCALER field.
	TC_COUNT32_CTRLA_PRESCALER_Pos = 0x8
	// Bit mask of PRESCALER field.
	TC_COUNT32_CTRLA_PRESCALER_Msk = 0x700
	// Prescaler: GCLK_TC
	TC_COUNT32_CTRLA_PRESCALER_DIV1 = 0x0
	// Prescaler: GCLK_TC/2
	TC_COUNT32_CTRLA_PRESCALER_DIV2 = 0x1
	// Prescaler: GCLK_TC/4
	TC_COUNT32_CTRLA_PRESCALER_DIV4 = 0x2
	// Prescaler: GCLK_TC/8
	TC_COUNT32_CTRLA_PRESCALER_DIV8 = 0x3
	// Prescaler: GCLK_TC/16
	TC_COUNT32_CTRLA_PRESCALER_DIV16 = 0x4
	// Prescaler: GCLK_TC/64
	TC_COUNT32_CTRLA_PRESCALER_DIV64 = 0x5
	// Prescaler: GCLK_TC/256
	TC_COUNT32_CTRLA_PRESCALER_DIV256 = 0x6
	// Prescaler: GCLK_TC/1024
	TC_COUNT32_CTRLA_PRESCALER_DIV1024 = 0x7
	// Position of ALOCK field.
	TC_COUNT32_CTRLA_ALOCK_Pos = 0xb
	// Bit mask of ALOCK field.
	TC_COUNT32_CTRLA_ALOCK_Msk = 0x800
	// Bit ALOCK.
	TC_COUNT32_CTRLA_ALOCK = 0x800
	// Position of CAPTEN0 field.
	TC_COUNT32_CTRLA_CAPTEN0_Pos = 0x10
	// Bit mask of CAPTEN0 field.
	TC_COUNT32_CTRLA_CAPTEN0_Msk = 0x10000
	// Bit CAPTEN0.
	TC_COUNT32_CTRLA_CAPTEN0 = 0x10000
	// Position of CAPTEN1 field.
	TC_COUNT32_CTRLA_CAPTEN1_Pos = 0x11
	// Bit mask of CAPTEN1 field.
	TC_COUNT32_CTRLA_CAPTEN1_Msk = 0x20000
	// Bit CAPTEN1.
	TC_COUNT32_CTRLA_CAPTEN1 = 0x20000
	// Position of COPEN0 field.
	TC_COUNT32_CTRLA_COPEN0_Pos = 0x14
	// Bit mask of COPEN0 field.
	TC_COUNT32_CTRLA_COPEN0_Msk = 0x100000
	// Bit COPEN0.
	TC_COUNT32_CTRLA_COPEN0 = 0x100000
	// Position of COPEN1 field.
	TC_COUNT32_CTRLA_COPEN1_Pos = 0x15
	// Bit mask of COPEN1 field.
	TC_COUNT32_CTRLA_COPEN1_Msk = 0x200000
	// Bit COPEN1.
	TC_COUNT32_CTRLA_COPEN1 = 0x200000
	// Position of CAPTMODE0 field.
	TC_COUNT32_CTRLA_CAPTMODE0_Pos = 0x18
	// Bit mask of CAPTMODE0 field.
	TC_COUNT32_CTRLA_CAPTMODE0_Msk = 0x3000000
	// Default capture
	TC_COUNT32_CTRLA_CAPTMODE0_DEFAULT = 0x0
	// Minimum capture
	TC_COUNT32_CTRLA_CAPTMODE0_CAPTMIN = 0x1
	// Maximum capture
	TC_COUNT32_CTRLA_CAPTMODE0_CAPTMAX = 0x2
	// Position of CAPTMODE1 field.
	TC_COUNT32_CTRLA_CAPTMODE1_Pos = 0x1b
	// Bit mask of CAPTMODE1 field.
	TC_COUNT32_CTRLA_CAPTMODE1_Msk = 0x18000000
	// Default capture
	TC_COUNT32_CTRLA_CAPTMODE1_DEFAULT = 0x0
	// Minimum capture
	TC_COUNT32_CTRLA_CAPTMODE1_CAPTMIN = 0x1
	// Maximum capture
	TC_COUNT32_CTRLA_CAPTMODE1_CAPTMAX = 0x2

	// CTRLBCLR: Control B Clear
	// Position of DIR field.
	TC_COUNT32_CTRLBCLR_DIR_Pos = 0x0
	// Bit mask of DIR field.
	TC_COUNT32_CTRLBCLR_DIR_Msk = 0x1
	// Bit DIR.
	TC_COUNT32_CTRLBCLR_DIR = 0x1
	// Position of LUPD field.
	TC_COUNT32_CTRLBCLR_LUPD_Pos = 0x1
	// Bit mask of LUPD field.
	TC_COUNT32_CTRLBCLR_LUPD_Msk = 0x2
	// Bit LUPD.
	TC_COUNT32_CTRLBCLR_LUPD = 0x2
	// Position of ONESHOT field.
	TC_COUNT32_CTRLBCLR_ONESHOT_Pos = 0x2
	// Bit mask of ONESHOT field.
	TC_COUNT32_CTRLBCLR_ONESHOT_Msk = 0x4
	// Bit ONESHOT.
	TC_COUNT32_CTRLBCLR_ONESHOT = 0x4
	// Position of CMD field.
	TC_COUNT32_CTRLBCLR_CMD_Pos = 0x5
	// Bit mask of CMD field.
	TC_COUNT32_CTRLBCLR_CMD_Msk = 0xe0
	// No action
	TC_COUNT32_CTRLBCLR_CMD_NONE = 0x0
	// Force a start, restart or retrigger
	TC_COUNT32_CTRLBCLR_CMD_RETRIGGER = 0x1
	// Force a stop
	TC_COUNT32_CTRLBCLR_CMD_STOP = 0x2
	// Force update of double-buffered register
	TC_COUNT32_CTRLBCLR_CMD_UPDATE = 0x3
	// Force a read synchronization of COUNT
	TC_COUNT32_CTRLBCLR_CMD_READSYNC = 0x4
	// One-shot DMA trigger
	TC_COUNT32_CTRLBCLR_CMD_DMAOS = 0x5

	// CTRLBSET: Control B Set
	// Position of DIR field.
	TC_COUNT32_CTRLBSET_DIR_Pos = 0x0
	// Bit mask of DIR field.
	TC_COUNT32_CTRLBSET_DIR_Msk = 0x1
	// Bit DIR.
	TC_COUNT32_CTRLBSET_DIR = 0x1
	// Position of LUPD field.
	TC_COUNT32_CTRLBSET_LUPD_Pos = 0x1
	// Bit mask of LUPD field.
	TC_COUNT32_CTRLBSET_LUPD_Msk = 0x2
	// Bit LUPD.
	TC_COUNT32_CTRLBSET_LUPD = 0x2
	// Position of ONESHOT field.
	TC_COUNT32_CTRLBSET_ONESHOT_Pos = 0x2
	// Bit mask of ONESHOT field.
	TC_COUNT32_CTRLBSET_ONESHOT_Msk = 0x4
	// Bit ONESHOT.
	TC_COUNT32_CTRLBSET_ONESHOT = 0x4
	// Position of CMD field.
	TC_COUNT32_CTRLBSET_CMD_Pos = 0x5
	// Bit mask of CMD field.
	TC_COUNT32_CTRLBSET_CMD_Msk = 0xe0
	// No action
	TC_COUNT32_CTRLBSET_CMD_NONE = 0x0
	// Force a start, restart or retrigger
	TC_COUNT32_CTRLBSET_CMD_RETRIGGER = 0x1
	// Force a stop
	TC_COUNT32_CTRLBSET_CMD_STOP = 0x2
	// Force update of double-buffered register
	TC_COUNT32_CTRLBSET_CMD_UPDATE = 0x3
	// Force a read synchronization of COUNT
	TC_COUNT32_CTRLBSET_CMD_READSYNC = 0x4
	// One-shot DMA trigger
	TC_COUNT32_CTRLBSET_CMD_DMAOS = 0x5

	// EVCTRL: Event Control
	// Position of EVACT field.
	TC_COUNT32_EVCTRL_EVACT_Pos = 0x0
	// Bit mask of EVACT field.
	TC_COUNT32_EVCTRL_EVACT_Msk = 0x7
	// Event action disabled
	TC_COUNT32_EVCTRL_EVACT_OFF = 0x0
	// Start, restart or retrigger TC on event
	TC_COUNT32_EVCTRL_EVACT_RETRIGGER = 0x1
	// Count on event
	TC_COUNT32_EVCTRL_EVACT_COUNT = 0x2
	// Start TC on event
	TC_COUNT32_EVCTRL_EVACT_START = 0x3
	// Time stamp capture
	TC_COUNT32_EVCTRL_EVACT_STAMP = 0x4
	// Period catured in CC0, pulse width in CC1
	TC_COUNT32_EVCTRL_EVACT_PPW = 0x5
	// Period catured in CC1, pulse width in CC0
	TC_COUNT32_EVCTRL_EVACT_PWP = 0x6
	// Pulse width capture
	TC_COUNT32_EVCTRL_EVACT_PW = 0x7
	// Position of TCINV field.
	TC_COUNT32_EVCTRL_TCINV_Pos = 0x4
	// Bit mask of TCINV field.
	TC_COUNT32_EVCTRL_TCINV_Msk = 0x10
	// Bit TCINV.
	TC_COUNT32_EVCTRL_TCINV = 0x10
	// Position of TCEI field.
	TC_COUNT32_EVCTRL_TCEI_Pos = 0x5
	// Bit mask of TCEI field.
	TC_COUNT32_EVCTRL_TCEI_Msk = 0x20
	// Bit TCEI.
	TC_COUNT32_EVCTRL_TCEI = 0x20
	// Position of OVFEO field.
	TC_COUNT32_EVCTRL_OVFEO_Pos = 0x8
	// Bit mask of OVFEO field.
	TC_COUNT32_EVCTRL_OVFEO_Msk = 0x100
	// Bit OVFEO.
	TC_COUNT32_EVCTRL_OVFEO = 0x100
	// Position of MCEO0 field.
	TC_COUNT32_EVCTRL_MCEO0_Pos = 0xc
	// Bit mask of MCEO0 field.
	TC_COUNT32_EVCTRL_MCEO0_Msk = 0x1000
	// Bit MCEO0.
	TC_COUNT32_EVCTRL_MCEO0 = 0x1000
	// Position of MCEO1 field.
	TC_COUNT32_EVCTRL_MCEO1_Pos = 0xd
	// Bit mask of MCEO1 field.
	TC_COUNT32_EVCTRL_MCEO1_Msk = 0x2000
	// Bit MCEO1.
	TC_COUNT32_EVCTRL_MCEO1 = 0x2000

	// INTENCLR: Interrupt Enable Clear
	// Position of OVF field.
	TC_COUNT32_INTENCLR_OVF_Pos = 0x0
	// Bit mask of OVF field.
	TC_COUNT32_INTENCLR_OVF_Msk = 0x1
	// Bit OVF.
	TC_COUNT32_INTENCLR_OVF = 0x1
	// Position of ERR field.
	TC_COUNT32_INTENCLR_ERR_Pos = 0x1
	// Bit mask of ERR field.
	TC_COUNT32_INTENCLR_ERR_Msk = 0x2
	// Bit ERR.
	TC_COUNT32_INTENCLR_ERR = 0x2
	// Position of MC0 field.
	TC_COUNT32_INTENCLR_MC0_Pos = 0x4
	// Bit mask of MC0 field.
	TC_COUNT32_INTENCLR_MC0_Msk = 0x10
	// Bit MC0.
	TC_COUNT32_INTENCLR_MC0 = 0x10
	// Position of MC1 field.
	TC_COUNT32_INTENCLR_MC1_Pos = 0x5
	// Bit mask of MC1 field.
	TC_COUNT32_INTENCLR_MC1_Msk = 0x20
	// Bit MC1.
	TC_COUNT32_INTENCLR_MC1 = 0x20

	// INTENSET: Interrupt Enable Set
	// Position of OVF field.
	TC_COUNT32_INTENSET_OVF_Pos = 0x0
	// Bit mask of OVF field.
	TC_COUNT32_INTENSET_OVF_Msk = 0x1
	// Bit OVF.
	TC_COUNT32_INTENSET_OVF = 0x1
	// Position of ERR field.
	TC_COUNT32_INTENSET_ERR_Pos = 0x1
	// Bit mask of ERR field.
	TC_COUNT32_INTENSET_ERR_Msk = 0x2
	// Bit ERR.
	TC_COUNT32_INTENSET_ERR = 0x2
	// Position of MC0 field.
	TC_COUNT32_INTENSET_MC0_Pos = 0x4
	// Bit mask of MC0 field.
	TC_COUNT32_INTENSET_MC0_Msk = 0x10
	// Bit MC0.
	TC_COUNT32_INTENSET_MC0 = 0x10
	// Position of MC1 field.
	TC_COUNT32_INTENSET_MC1_Pos = 0x5
	// Bit mask of MC1 field.
	TC_COUNT32_INTENSET_MC1_Msk = 0x20
	// Bit MC1.
	TC_COUNT32_INTENSET_MC1 = 0x20

	// INTFLAG: Interrupt Flag Status and Clear
	// Position of OVF field.
	TC_COUNT32_INTFLAG_OVF_Pos = 0x0
	// Bit mask of OVF field.
	TC_COUNT32_INTFLAG_OVF_Msk = 0x1
	// Bit OVF.
	TC_COUNT32_INTFLAG_OVF = 0x1
	// Position of ERR field.
	TC_COUNT32_INTFLAG_ERR_Pos = 0x1
	// Bit mask of ERR field.
	TC_COUNT32_INTFLAG_ERR_Msk = 0x2
	// Bit ERR.
	TC_COUNT32_INTFLAG_ERR = 0x2
	// Position of MC0 field.
	TC_COUNT32_INTFLAG_MC0_Pos = 0x4
	// Bit mask of MC0 field.
	TC_COUNT32_INTFLAG_MC0_Msk = 0x10
	// Bit MC0.
	TC_COUNT32_INTFLAG_MC0 = 0x10
	// Position of MC1 field.
	TC_COUNT32_INTFLAG_MC1_Pos = 0x5
	// Bit mask of MC1 field.
	TC_COUNT32_INTFLAG_MC1_Msk = 0x20
	// Bit MC1.
	TC_COUNT32_INTFLAG_MC1 = 0x20

	// STATUS: Status
	// Position of STOP field.
	TC_COUNT32_STATUS_STOP_Pos = 0x0
	// Bit mask of STOP field.
	TC_COUNT32_STATUS_STOP_Msk = 0x1
	// Bit STOP.
	TC_COUNT32_STATUS_STOP = 0x1
	// Position of SLAVE field.
	TC_COUNT32_STATUS_SLAVE_Pos = 0x1
	// Bit mask of SLAVE field.
	TC_COUNT32_STATUS_SLAVE_Msk = 0x2
	// Bit SLAVE.
	TC_COUNT32_STATUS_SLAVE = 0x2
	// Position of PERBUFV field.
	TC_COUNT32_STATUS_PERBUFV_Pos = 0x3
	// Bit mask of PERBUFV field.
	TC_COUNT32_STATUS_PERBUFV_Msk = 0x8
	// Bit PERBUFV.
	TC_COUNT32_STATUS_PERBUFV = 0x8
	// Position of CCBUFV0 field.
	TC_COUNT32_STATUS_CCBUFV0_Pos = 0x4
	// Bit mask of CCBUFV0 field.
	TC_COUNT32_STATUS_CCBUFV0_Msk = 0x10
	// Bit CCBUFV0.
	TC_COUNT32_STATUS_CCBUFV0 = 0x10
	// Position of CCBUFV1 field.
	TC_COUNT32_STATUS_CCBUFV1_Pos = 0x5
	// Bit mask of CCBUFV1 field.
	TC_COUNT32_STATUS_CCBUFV1_Msk = 0x20
	// Bit CCBUFV1.
	TC_COUNT32_STATUS_CCBUFV1 = 0x20

	// WAVE: Waveform Generation Control
	// Position of WAVEGEN field.
	TC_COUNT32_WAVE_WAVEGEN_Pos = 0x0
	// Bit mask of WAVEGEN field.
	TC_COUNT32_WAVE_WAVEGEN_Msk = 0x3
	// Normal frequency
	TC_COUNT32_WAVE_WAVEGEN_NFRQ = 0x0
	// Match frequency
	TC_COUNT32_WAVE_WAVEGEN_MFRQ = 0x1
	// Normal PWM
	TC_COUNT32_WAVE_WAVEGEN_NPWM = 0x2
	// Match PWM
	TC_COUNT32_WAVE_WAVEGEN_MPWM = 0x3

	// DRVCTRL: Control C
	// Position of INVEN0 field.
	TC_COUNT32_DRVCTRL_INVEN0_Pos = 0x0
	// Bit mask of INVEN0 field.
	TC_COUNT32_DRVCTRL_INVEN0_Msk = 0x1
	// Bit INVEN0.
	TC_COUNT32_DRVCTRL_INVEN0 = 0x1
	// Position of INVEN1 field.
	TC_COUNT32_DRVCTRL_INVEN1_Pos = 0x1
	// Bit mask of INVEN1 field.
	TC_COUNT32_DRVCTRL_INVEN1_Msk = 0x2
	// Bit INVEN1.
	TC_COUNT32_DRVCTRL_INVEN1 = 0x2

	// DBGCTRL: Debug Control
	// Position of DBGRUN field.
	TC_COUNT32_DBGCTRL_DBGRUN_Pos = 0x0
	// Bit mask of DBGRUN field.
	TC_COUNT32_DBGCTRL_DBGRUN_Msk = 0x1
	// Bit DBGRUN.
	TC_COUNT32_DBGCTRL_DBGRUN = 0x1

	// SYNCBUSY: Synchronization Status
	// Position of SWRST field.
	TC_COUNT32_SYNCBUSY_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	TC_COUNT32_SYNCBUSY_SWRST_Msk = 0x1
	// Bit SWRST.
	TC_COUNT32_SYNCBUSY_SWRST = 0x1
	// Position of ENABLE field.
	TC_COUNT32_SYNCBUSY_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	TC_COUNT32_SYNCBUSY_ENABLE_Msk = 0x2
	// Bit ENABLE.
	TC_COUNT32_SYNCBUSY_ENABLE = 0x2
	// Position of CTRLB field.
	TC_COUNT32_SYNCBUSY_CTRLB_Pos = 0x2
	// Bit mask of CTRLB field.
	TC_COUNT32_SYNCBUSY_CTRLB_Msk = 0x4
	// Bit CTRLB.
	TC_COUNT32_SYNCBUSY_CTRLB = 0x4
	// Position of STATUS field.
	TC_COUNT32_SYNCBUSY_STATUS_Pos = 0x3
	// Bit mask of STATUS field.
	TC_COUNT32_SYNCBUSY_STATUS_Msk = 0x8
	// Bit STATUS.
	TC_COUNT32_SYNCBUSY_STATUS = 0x8
	// Position of COUNT field.
	TC_COUNT32_SYNCBUSY_COUNT_Pos = 0x4
	// Bit mask of COUNT field.
	TC_COUNT32_SYNCBUSY_COUNT_Msk = 0x10
	// Bit COUNT.
	TC_COUNT32_SYNCBUSY_COUNT = 0x10
	// Position of PER field.
	TC_COUNT32_SYNCBUSY_PER_Pos = 0x5
	// Bit mask of PER field.
	TC_COUNT32_SYNCBUSY_PER_Msk = 0x20
	// Bit PER.
	TC_COUNT32_SYNCBUSY_PER = 0x20
	// Position of CC0 field.
	TC_COUNT32_SYNCBUSY_CC0_Pos = 0x6
	// Bit mask of CC0 field.
	TC_COUNT32_SYNCBUSY_CC0_Msk = 0x40
	// Bit CC0.
	TC_COUNT32_SYNCBUSY_CC0 = 0x40
	// Position of CC1 field.
	TC_COUNT32_SYNCBUSY_CC1_Pos = 0x7
	// Bit mask of CC1 field.
	TC_COUNT32_SYNCBUSY_CC1_Msk = 0x80
	// Bit CC1.
	TC_COUNT32_SYNCBUSY_CC1 = 0x80

	// COUNT: COUNT32 Count
	// Position of COUNT field.
	TC_COUNT32_COUNT_COUNT_Pos = 0x0
	// Bit mask of COUNT field.
	TC_COUNT32_COUNT_COUNT_Msk = 0xffffffff

	// PER: COUNT32 Period
	// Position of PER field.
	TC_COUNT32_PER_PER_Pos = 0x0
	// Bit mask of PER field.
	TC_COUNT32_PER_PER_Msk = 0xffffffff

	// CC: COUNT32 Compare and Capture
	// Position of CC field.
	TC_COUNT32_CC_CC_Pos = 0x0
	// Bit mask of CC field.
	TC_COUNT32_CC_CC_Msk = 0xffffffff

	// PERBUF: COUNT32 Period Buffer
	// Position of PERBUF field.
	TC_COUNT32_PERBUF_PERBUF_Pos = 0x0
	// Bit mask of PERBUF field.
	TC_COUNT32_PERBUF_PERBUF_Msk = 0xffffffff

	// CCBUF: COUNT32 Compare and Capture Buffer
	// Position of CCBUF field.
	TC_COUNT32_CCBUF_CCBUF_Pos = 0x0
	// Bit mask of CCBUF field.
	TC_COUNT32_CCBUF_CCBUF_Msk = 0xffffffff
)

// Constants for TRAM: TrustRAM
const (
	// CTRLA: Control
	// Position of SWRST field.
	TRAM_CTRLA_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	TRAM_CTRLA_SWRST_Msk = 0x1
	// Bit SWRST.
	TRAM_CTRLA_SWRST = 0x1
	// Position of ENABLE field.
	TRAM_CTRLA_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	TRAM_CTRLA_ENABLE_Msk = 0x2
	// Bit ENABLE.
	TRAM_CTRLA_ENABLE = 0x2
	// Position of TAMPERS field.
	TRAM_CTRLA_TAMPERS_Pos = 0x4
	// Bit mask of TAMPERS field.
	TRAM_CTRLA_TAMPERS_Msk = 0x10
	// Bit TAMPERS.
	TRAM_CTRLA_TAMPERS = 0x10
	// Position of DRP field.
	TRAM_CTRLA_DRP_Pos = 0x6
	// Bit mask of DRP field.
	TRAM_CTRLA_DRP_Msk = 0x40
	// Bit DRP.
	TRAM_CTRLA_DRP = 0x40
	// Position of SILACC field.
	TRAM_CTRLA_SILACC_Pos = 0x7
	// Bit mask of SILACC field.
	TRAM_CTRLA_SILACC_Msk = 0x80
	// Bit SILACC.
	TRAM_CTRLA_SILACC = 0x80

	// INTENCLR: Interrupt Enable Clear
	// Position of ERR field.
	TRAM_INTENCLR_ERR_Pos = 0x0
	// Bit mask of ERR field.
	TRAM_INTENCLR_ERR_Msk = 0x1
	// Bit ERR.
	TRAM_INTENCLR_ERR = 0x1
	// Position of DRP field.
	TRAM_INTENCLR_DRP_Pos = 0x1
	// Bit mask of DRP field.
	TRAM_INTENCLR_DRP_Msk = 0x2
	// Bit DRP.
	TRAM_INTENCLR_DRP = 0x2

	// INTENSET: Interrupt Enable Set
	// Position of ERR field.
	TRAM_INTENSET_ERR_Pos = 0x0
	// Bit mask of ERR field.
	TRAM_INTENSET_ERR_Msk = 0x1
	// Bit ERR.
	TRAM_INTENSET_ERR = 0x1
	// Position of DRP field.
	TRAM_INTENSET_DRP_Pos = 0x1
	// Bit mask of DRP field.
	TRAM_INTENSET_DRP_Msk = 0x2
	// Bit DRP.
	TRAM_INTENSET_DRP = 0x2

	// INTFLAG: Interrupt Flag Status and Clear
	// Position of ERR field.
	TRAM_INTFLAG_ERR_Pos = 0x0
	// Bit mask of ERR field.
	TRAM_INTFLAG_ERR_Msk = 0x1
	// Bit ERR.
	TRAM_INTFLAG_ERR = 0x1
	// Position of DRP field.
	TRAM_INTFLAG_DRP_Pos = 0x1
	// Bit mask of DRP field.
	TRAM_INTFLAG_DRP_Msk = 0x2
	// Bit DRP.
	TRAM_INTFLAG_DRP = 0x2

	// STATUS: Status
	// Position of RAMINV field.
	TRAM_STATUS_RAMINV_Pos = 0x0
	// Bit mask of RAMINV field.
	TRAM_STATUS_RAMINV_Msk = 0x1
	// Bit RAMINV.
	TRAM_STATUS_RAMINV = 0x1
	// Position of DRP field.
	TRAM_STATUS_DRP_Pos = 0x1
	// Bit mask of DRP field.
	TRAM_STATUS_DRP_Msk = 0x2
	// Bit DRP.
	TRAM_STATUS_DRP = 0x2

	// SYNCBUSY: Synchronization Busy Status
	// Position of SWRST field.
	TRAM_SYNCBUSY_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	TRAM_SYNCBUSY_SWRST_Msk = 0x1
	// Bit SWRST.
	TRAM_SYNCBUSY_SWRST = 0x1
	// Position of ENABLE field.
	TRAM_SYNCBUSY_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	TRAM_SYNCBUSY_ENABLE_Msk = 0x2
	// Bit ENABLE.
	TRAM_SYNCBUSY_ENABLE = 0x2

	// DSCC: Data Scramble Control
	// Position of DSCKEY field.
	TRAM_DSCC_DSCKEY_Pos = 0x0
	// Bit mask of DSCKEY field.
	TRAM_DSCC_DSCKEY_Msk = 0x3fffffff
	// Position of DSCEN field.
	TRAM_DSCC_DSCEN_Pos = 0x1f
	// Bit mask of DSCEN field.
	TRAM_DSCC_DSCEN_Msk = 0x80000000
	// Bit DSCEN.
	TRAM_DSCC_DSCEN = 0x80000000

	// PERMW: Permutation Write
	// Position of DATA field.
	TRAM_PERMW_DATA_Pos = 0x0
	// Bit mask of DATA field.
	TRAM_PERMW_DATA_Msk = 0x7

	// PERMR: Permutation Read
	// Position of DATA field.
	TRAM_PERMR_DATA_Pos = 0x0
	// Bit mask of DATA field.
	TRAM_PERMR_DATA_Msk = 0x7

	// RAM: TrustRAM
	// Position of DATA field.
	TRAM_RAM_DATA_Pos = 0x0
	// Bit mask of DATA field.
	TRAM_RAM_DATA_Msk = 0xffffffff
)

// Constants for TRNG: True Random Generator
const (
	// CTRLA: Control A
	// Position of ENABLE field.
	TRNG_CTRLA_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	TRNG_CTRLA_ENABLE_Msk = 0x2
	// Bit ENABLE.
	TRNG_CTRLA_ENABLE = 0x2
	// Position of RUNSTDBY field.
	TRNG_CTRLA_RUNSTDBY_Pos = 0x6
	// Bit mask of RUNSTDBY field.
	TRNG_CTRLA_RUNSTDBY_Msk = 0x40
	// Bit RUNSTDBY.
	TRNG_CTRLA_RUNSTDBY = 0x40

	// EVCTRL: Event Control
	// Position of DATARDYEO field.
	TRNG_EVCTRL_DATARDYEO_Pos = 0x0
	// Bit mask of DATARDYEO field.
	TRNG_EVCTRL_DATARDYEO_Msk = 0x1
	// Bit DATARDYEO.
	TRNG_EVCTRL_DATARDYEO = 0x1

	// INTENCLR: Interrupt Enable Clear
	// Position of DATARDY field.
	TRNG_INTENCLR_DATARDY_Pos = 0x0
	// Bit mask of DATARDY field.
	TRNG_INTENCLR_DATARDY_Msk = 0x1
	// Bit DATARDY.
	TRNG_INTENCLR_DATARDY = 0x1

	// INTENSET: Interrupt Enable Set
	// Position of DATARDY field.
	TRNG_INTENSET_DATARDY_Pos = 0x0
	// Bit mask of DATARDY field.
	TRNG_INTENSET_DATARDY_Msk = 0x1
	// Bit DATARDY.
	TRNG_INTENSET_DATARDY = 0x1

	// INTFLAG: Interrupt Flag Status and Clear
	// Position of DATARDY field.
	TRNG_INTFLAG_DATARDY_Pos = 0x0
	// Bit mask of DATARDY field.
	TRNG_INTFLAG_DATARDY_Msk = 0x1
	// Bit DATARDY.
	TRNG_INTFLAG_DATARDY = 0x1

	// DATA: Output Data
	// Position of DATA field.
	TRNG_DATA_DATA_Pos = 0x0
	// Bit mask of DATA field.
	TRNG_DATA_DATA_Msk = 0xffffffff
)

// Constants for WDT: Watchdog Timer
const (
	// CTRLA: Control
	// Position of ENABLE field.
	WDT_CTRLA_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	WDT_CTRLA_ENABLE_Msk = 0x2
	// Bit ENABLE.
	WDT_CTRLA_ENABLE = 0x2
	// Position of WEN field.
	WDT_CTRLA_WEN_Pos = 0x2
	// Bit mask of WEN field.
	WDT_CTRLA_WEN_Msk = 0x4
	// Bit WEN.
	WDT_CTRLA_WEN = 0x4
	// Position of RUNSTDBY field.
	WDT_CTRLA_RUNSTDBY_Pos = 0x6
	// Bit mask of RUNSTDBY field.
	WDT_CTRLA_RUNSTDBY_Msk = 0x40
	// Bit RUNSTDBY.
	WDT_CTRLA_RUNSTDBY = 0x40
	// Position of ALWAYSON field.
	WDT_CTRLA_ALWAYSON_Pos = 0x7
	// Bit mask of ALWAYSON field.
	WDT_CTRLA_ALWAYSON_Msk = 0x80
	// Bit ALWAYSON.
	WDT_CTRLA_ALWAYSON = 0x80

	// CONFIG: Configuration
	// Position of PER field.
	WDT_CONFIG_PER_Pos = 0x0
	// Bit mask of PER field.
	WDT_CONFIG_PER_Msk = 0xf
	// 8 clock cycles
	WDT_CONFIG_PER_CYC8 = 0x0
	// 16 clock cycles
	WDT_CONFIG_PER_CYC16 = 0x1
	// 32 clock cycles
	WDT_CONFIG_PER_CYC32 = 0x2
	// 64 clock cycles
	WDT_CONFIG_PER_CYC64 = 0x3
	// 128 clock cycles
	WDT_CONFIG_PER_CYC128 = 0x4
	// 256 clock cycles
	WDT_CONFIG_PER_CYC256 = 0x5
	// 512 clock cycles
	WDT_CONFIG_PER_CYC512 = 0x6
	// 1024 clock cycles
	WDT_CONFIG_PER_CYC1024 = 0x7
	// 2048 clock cycles
	WDT_CONFIG_PER_CYC2048 = 0x8
	// 4096 clock cycles
	WDT_CONFIG_PER_CYC4096 = 0x9
	// 8192 clock cycles
	WDT_CONFIG_PER_CYC8192 = 0xa
	// 16384 clock cycles
	WDT_CONFIG_PER_CYC16384 = 0xb
	// Position of WINDOW field.
	WDT_CONFIG_WINDOW_Pos = 0x4
	// Bit mask of WINDOW field.
	WDT_CONFIG_WINDOW_Msk = 0xf0
	// 8 clock cycles
	WDT_CONFIG_WINDOW_CYC8 = 0x0
	// 16 clock cycles
	WDT_CONFIG_WINDOW_CYC16 = 0x1
	// 32 clock cycles
	WDT_CONFIG_WINDOW_CYC32 = 0x2
	// 64 clock cycles
	WDT_CONFIG_WINDOW_CYC64 = 0x3
	// 128 clock cycles
	WDT_CONFIG_WINDOW_CYC128 = 0x4
	// 256 clock cycles
	WDT_CONFIG_WINDOW_CYC256 = 0x5
	// 512 clock cycles
	WDT_CONFIG_WINDOW_CYC512 = 0x6
	// 1024 clock cycles
	WDT_CONFIG_WINDOW_CYC1024 = 0x7
	// 2048 clock cycles
	WDT_CONFIG_WINDOW_CYC2048 = 0x8
	// 4096 clock cycles
	WDT_CONFIG_WINDOW_CYC4096 = 0x9
	// 8192 clock cycles
	WDT_CONFIG_WINDOW_CYC8192 = 0xa
	// 16384 clock cycles
	WDT_CONFIG_WINDOW_CYC16384 = 0xb

	// EWCTRL: Early Warning Interrupt Control
	// Position of EWOFFSET field.
	WDT_EWCTRL_EWOFFSET_Pos = 0x0
	// Bit mask of EWOFFSET field.
	WDT_EWCTRL_EWOFFSET_Msk = 0xf
	// 8 clock cycles
	WDT_EWCTRL_EWOFFSET_CYC8 = 0x0
	// 16 clock cycles
	WDT_EWCTRL_EWOFFSET_CYC16 = 0x1
	// 32 clock cycles
	WDT_EWCTRL_EWOFFSET_CYC32 = 0x2
	// 64 clock cycles
	WDT_EWCTRL_EWOFFSET_CYC64 = 0x3
	// 128 clock cycles
	WDT_EWCTRL_EWOFFSET_CYC128 = 0x4
	// 256 clock cycles
	WDT_EWCTRL_EWOFFSET_CYC256 = 0x5
	// 512 clock cycles
	WDT_EWCTRL_EWOFFSET_CYC512 = 0x6
	// 1024 clock cycles
	WDT_EWCTRL_EWOFFSET_CYC1024 = 0x7
	// 2048 clock cycles
	WDT_EWCTRL_EWOFFSET_CYC2048 = 0x8
	// 4096 clock cycles
	WDT_EWCTRL_EWOFFSET_CYC4096 = 0x9
	// 8192 clock cycles
	WDT_EWCTRL_EWOFFSET_CYC8192 = 0xa
	// 16384 clock cycles
	WDT_EWCTRL_EWOFFSET_CYC16384 = 0xb

	// INTENCLR: Interrupt Enable Clear
	// Position of EW field.
	WDT_INTENCLR_EW_Pos = 0x0
	// Bit mask of EW field.
	WDT_INTENCLR_EW_Msk = 0x1
	// Bit EW.
	WDT_INTENCLR_EW = 0x1

	// INTENSET: Interrupt Enable Set
	// Position of EW field.
	WDT_INTENSET_EW_Pos = 0x0
	// Bit mask of EW field.
	WDT_INTENSET_EW_Msk = 0x1
	// Bit EW.
	WDT_INTENSET_EW = 0x1

	// INTFLAG: Interrupt Flag Status and Clear
	// Position of EW field.
	WDT_INTFLAG_EW_Pos = 0x0
	// Bit mask of EW field.
	WDT_INTFLAG_EW_Msk = 0x1
	// Bit EW.
	WDT_INTFLAG_EW = 0x1

	// SYNCBUSY: Synchronization Busy
	// Position of ENABLE field.
	WDT_SYNCBUSY_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	WDT_SYNCBUSY_ENABLE_Msk = 0x2
	// Bit ENABLE.
	WDT_SYNCBUSY_ENABLE = 0x2
	// Position of WEN field.
	WDT_SYNCBUSY_WEN_Pos = 0x2
	// Bit mask of WEN field.
	WDT_SYNCBUSY_WEN_Msk = 0x4
	// Bit WEN.
	WDT_SYNCBUSY_WEN = 0x4
	// Position of RUNSTDBY field.
	WDT_SYNCBUSY_RUNSTDBY_Pos = 0x3
	// Bit mask of RUNSTDBY field.
	WDT_SYNCBUSY_RUNSTDBY_Msk = 0x8
	// Bit RUNSTDBY.
	WDT_SYNCBUSY_RUNSTDBY = 0x8
	// Position of ALWAYSON field.
	WDT_SYNCBUSY_ALWAYSON_Pos = 0x4
	// Bit mask of ALWAYSON field.
	WDT_SYNCBUSY_ALWAYSON_Msk = 0x10
	// Bit ALWAYSON.
	WDT_SYNCBUSY_ALWAYSON = 0x10
	// Position of CLEAR field.
	WDT_SYNCBUSY_CLEAR_Pos = 0x5
	// Bit mask of CLEAR field.
	WDT_SYNCBUSY_CLEAR_Msk = 0x20
	// Bit CLEAR.
	WDT_SYNCBUSY_CLEAR = 0x20

	// CLEAR: Clear
	// Position of CLEAR field.
	WDT_CLEAR_CLEAR_Pos = 0x0
	// Bit mask of CLEAR field.
	WDT_CLEAR_CLEAR_Msk = 0xff
	// Clear Key
	WDT_CLEAR_CLEAR_KEY = 0xa5
)

// Constants for CoreDebug: Debug Control Block
const (
	// DHCSR: Debug Halting Control and Status Register
	// Position of C_DEBUGEN field.
	CoreDebug_DHCSR_C_DEBUGEN_Pos = 0x0
	// Bit mask of C_DEBUGEN field.
	CoreDebug_DHCSR_C_DEBUGEN_Msk = 0x1
	// Bit C_DEBUGEN.
	CoreDebug_DHCSR_C_DEBUGEN = 0x1
	// Position of C_HALT field.
	CoreDebug_DHCSR_C_HALT_Pos = 0x1
	// Bit mask of C_HALT field.
	CoreDebug_DHCSR_C_HALT_Msk = 0x2
	// Bit C_HALT.
	CoreDebug_DHCSR_C_HALT = 0x2
	// Position of C_STEP field.
	CoreDebug_DHCSR_C_STEP_Pos = 0x2
	// Bit mask of C_STEP field.
	CoreDebug_DHCSR_C_STEP_Msk = 0x4
	// Bit C_STEP.
	CoreDebug_DHCSR_C_STEP = 0x4
	// Position of C_MASKINTS field.
	CoreDebug_DHCSR_C_MASKINTS_Pos = 0x3
	// Bit mask of C_MASKINTS field.
	CoreDebug_DHCSR_C_MASKINTS_Msk = 0x8
	// Bit C_MASKINTS.
	CoreDebug_DHCSR_C_MASKINTS = 0x8
	// Position of S_SNAPSTALL field.
	CoreDebug_DHCSR_S_SNAPSTALL_Pos = 0x5
	// Bit mask of S_SNAPSTALL field.
	CoreDebug_DHCSR_S_SNAPSTALL_Msk = 0x20
	// Bit S_SNAPSTALL.
	CoreDebug_DHCSR_S_SNAPSTALL = 0x20
	// Position of S_REGRDY field.
	CoreDebug_DHCSR_S_REGRDY_Pos = 0x10
	// Bit mask of S_REGRDY field.
	CoreDebug_DHCSR_S_REGRDY_Msk = 0x10000
	// Bit S_REGRDY.
	CoreDebug_DHCSR_S_REGRDY = 0x10000
	// Position of S_HALT field.
	CoreDebug_DHCSR_S_HALT_Pos = 0x11
	// Bit mask of S_HALT field.
	CoreDebug_DHCSR_S_HALT_Msk = 0x20000
	// Bit S_HALT.
	CoreDebug_DHCSR_S_HALT = 0x20000
	// Position of S_SLEEP field.
	CoreDebug_DHCSR_S_SLEEP_Pos = 0x12
	// Bit mask of S_SLEEP field.
	CoreDebug_DHCSR_S_SLEEP_Msk = 0x40000
	// Bit S_SLEEP.
	CoreDebug_DHCSR_S_SLEEP = 0x40000
	// Position of S_LOCKUP field.
	CoreDebug_DHCSR_S_LOCKUP_Pos = 0x13
	// Bit mask of S_LOCKUP field.
	CoreDebug_DHCSR_S_LOCKUP_Msk = 0x80000
	// Bit S_LOCKUP.
	CoreDebug_DHCSR_S_LOCKUP = 0x80000
	// Position of S_SDE field.
	CoreDebug_DHCSR_S_SDE_Pos = 0x14
	// Bit mask of S_SDE field.
	CoreDebug_DHCSR_S_SDE_Msk = 0x100000
	// Bit S_SDE.
	CoreDebug_DHCSR_S_SDE = 0x100000
	// Position of S_RETIRE_ST field.
	CoreDebug_DHCSR_S_RETIRE_ST_Pos = 0x18
	// Bit mask of S_RETIRE_ST field.
	CoreDebug_DHCSR_S_RETIRE_ST_Msk = 0x1000000
	// Bit S_RETIRE_ST.
	CoreDebug_DHCSR_S_RETIRE_ST = 0x1000000
	// Position of S_RESET_ST field.
	CoreDebug_DHCSR_S_RESET_ST_Pos = 0x19
	// Bit mask of S_RESET_ST field.
	CoreDebug_DHCSR_S_RESET_ST_Msk = 0x2000000
	// Bit S_RESET_ST.
	CoreDebug_DHCSR_S_RESET_ST = 0x2000000
	// Position of S_RESTART_ST field.
	CoreDebug_DHCSR_S_RESTART_ST_Pos = 0x1a
	// Bit mask of S_RESTART_ST field.
	CoreDebug_DHCSR_S_RESTART_ST_Msk = 0x4000000
	// Bit S_RESTART_ST.
	CoreDebug_DHCSR_S_RESTART_ST = 0x4000000

	// DCRSR: Debug Core Register Select Register
	// Position of REGSEL field.
	CoreDebug_DCRSR_REGSEL_Pos = 0x0
	// Bit mask of REGSEL field.
	CoreDebug_DCRSR_REGSEL_Msk = 0x7f
	// Position of REGWnR field.
	CoreDebug_DCRSR_REGWnR_Pos = 0x10
	// Bit mask of REGWnR field.
	CoreDebug_DCRSR_REGWnR_Msk = 0x10000
	// Bit REGWnR.
	CoreDebug_DCRSR_REGWnR = 0x10000

	// DEMCR: Debug Exception and Monitor Control Register
	// Position of VC_CORERESET field.
	CoreDebug_DEMCR_VC_CORERESET_Pos = 0x0
	// Bit mask of VC_CORERESET field.
	CoreDebug_DEMCR_VC_CORERESET_Msk = 0x1
	// Bit VC_CORERESET.
	CoreDebug_DEMCR_VC_CORERESET = 0x1
	// Position of VC_MMERR field.
	CoreDebug_DEMCR_VC_MMERR_Pos = 0x4
	// Bit mask of VC_MMERR field.
	CoreDebug_DEMCR_VC_MMERR_Msk = 0x10
	// Bit VC_MMERR.
	CoreDebug_DEMCR_VC_MMERR = 0x10
	// Position of VC_NOCPERR field.
	CoreDebug_DEMCR_VC_NOCPERR_Pos = 0x5
	// Bit mask of VC_NOCPERR field.
	CoreDebug_DEMCR_VC_NOCPERR_Msk = 0x20
	// Bit VC_NOCPERR.
	CoreDebug_DEMCR_VC_NOCPERR = 0x20
	// Position of VC_CHKERR field.
	CoreDebug_DEMCR_VC_CHKERR_Pos = 0x6
	// Bit mask of VC_CHKERR field.
	CoreDebug_DEMCR_VC_CHKERR_Msk = 0x40
	// Bit VC_CHKERR.
	CoreDebug_DEMCR_VC_CHKERR = 0x40
	// Position of VC_STATERR field.
	CoreDebug_DEMCR_VC_STATERR_Pos = 0x7
	// Bit mask of VC_STATERR field.
	CoreDebug_DEMCR_VC_STATERR_Msk = 0x80
	// Bit VC_STATERR.
	CoreDebug_DEMCR_VC_STATERR = 0x80
	// Position of VC_BUSERR field.
	CoreDebug_DEMCR_VC_BUSERR_Pos = 0x8
	// Bit mask of VC_BUSERR field.
	CoreDebug_DEMCR_VC_BUSERR_Msk = 0x100
	// Bit VC_BUSERR.
	CoreDebug_DEMCR_VC_BUSERR = 0x100
	// Position of VC_INTERR field.
	CoreDebug_DEMCR_VC_INTERR_Pos = 0x9
	// Bit mask of VC_INTERR field.
	CoreDebug_DEMCR_VC_INTERR_Msk = 0x200
	// Bit VC_INTERR.
	CoreDebug_DEMCR_VC_INTERR = 0x200
	// Position of VC_HARDERR field.
	CoreDebug_DEMCR_VC_HARDERR_Pos = 0xa
	// Bit mask of VC_HARDERR field.
	CoreDebug_DEMCR_VC_HARDERR_Msk = 0x400
	// Bit VC_HARDERR.
	CoreDebug_DEMCR_VC_HARDERR = 0x400
	// Position of VC_SFERR field.
	CoreDebug_DEMCR_VC_SFERR_Pos = 0xb
	// Bit mask of VC_SFERR field.
	CoreDebug_DEMCR_VC_SFERR_Msk = 0x800
	// Bit VC_SFERR.
	CoreDebug_DEMCR_VC_SFERR = 0x800
	// Position of MON_EN field.
	CoreDebug_DEMCR_MON_EN_Pos = 0x10
	// Bit mask of MON_EN field.
	CoreDebug_DEMCR_MON_EN_Msk = 0x10000
	// Bit MON_EN.
	CoreDebug_DEMCR_MON_EN = 0x10000
	// Position of MON_PEND field.
	CoreDebug_DEMCR_MON_PEND_Pos = 0x11
	// Bit mask of MON_PEND field.
	CoreDebug_DEMCR_MON_PEND_Msk = 0x20000
	// Bit MON_PEND.
	CoreDebug_DEMCR_MON_PEND = 0x20000
	// Position of MON_STEP field.
	CoreDebug_DEMCR_MON_STEP_Pos = 0x12
	// Bit mask of MON_STEP field.
	CoreDebug_DEMCR_MON_STEP_Msk = 0x40000
	// Bit MON_STEP.
	CoreDebug_DEMCR_MON_STEP = 0x40000
	// Position of MON_REQ field.
	CoreDebug_DEMCR_MON_REQ_Pos = 0x13
	// Bit mask of MON_REQ field.
	CoreDebug_DEMCR_MON_REQ_Msk = 0x80000
	// Bit MON_REQ.
	CoreDebug_DEMCR_MON_REQ = 0x80000
	// Position of SDME field.
	CoreDebug_DEMCR_SDME_Pos = 0x14
	// Bit mask of SDME field.
	CoreDebug_DEMCR_SDME_Msk = 0x100000
	// Bit SDME.
	CoreDebug_DEMCR_SDME = 0x100000
	// Position of TRCENA field.
	CoreDebug_DEMCR_TRCENA_Pos = 0x18
	// Bit mask of TRCENA field.
	CoreDebug_DEMCR_TRCENA_Msk = 0x1000000
	// Bit TRCENA.
	CoreDebug_DEMCR_TRCENA = 0x1000000

	// DAUTHCTRL: Debug Authentication Control Register
	// Position of SPIDENSEL field.
	CoreDebug_DAUTHCTRL_SPIDENSEL_Pos = 0x0
	// Bit mask of SPIDENSEL field.
	CoreDebug_DAUTHCTRL_SPIDENSEL_Msk = 0x1
	// Bit SPIDENSEL.
	CoreDebug_DAUTHCTRL_SPIDENSEL = 0x1
	// Position of INTSPIDEN field.
	CoreDebug_DAUTHCTRL_INTSPIDEN_Pos = 0x1
	// Bit mask of INTSPIDEN field.
	CoreDebug_DAUTHCTRL_INTSPIDEN_Msk = 0x2
	// Bit INTSPIDEN.
	CoreDebug_DAUTHCTRL_INTSPIDEN = 0x2
	// Position of SPNIDENSEL field.
	CoreDebug_DAUTHCTRL_SPNIDENSEL_Pos = 0x2
	// Bit mask of SPNIDENSEL field.
	CoreDebug_DAUTHCTRL_SPNIDENSEL_Msk = 0x4
	// Bit SPNIDENSEL.
	CoreDebug_DAUTHCTRL_SPNIDENSEL = 0x4
	// Position of INTSPNIDEN field.
	CoreDebug_DAUTHCTRL_INTSPNIDEN_Pos = 0x3
	// Bit mask of INTSPNIDEN field.
	CoreDebug_DAUTHCTRL_INTSPNIDEN_Msk = 0x8
	// Bit INTSPNIDEN.
	CoreDebug_DAUTHCTRL_INTSPNIDEN = 0x8

	// DSCSR: Debug Security Control and Status Register
	// Position of SBRSELEN field.
	CoreDebug_DSCSR_SBRSELEN_Pos = 0x0
	// Bit mask of SBRSELEN field.
	CoreDebug_DSCSR_SBRSELEN_Msk = 0x1
	// Bit SBRSELEN.
	CoreDebug_DSCSR_SBRSELEN = 0x1
	// Position of SBRSEL field.
	CoreDebug_DSCSR_SBRSEL_Pos = 0x1
	// Bit mask of SBRSEL field.
	CoreDebug_DSCSR_SBRSEL_Msk = 0x2
	// Bit SBRSEL.
	CoreDebug_DSCSR_SBRSEL = 0x2
	// Position of CDS field.
	CoreDebug_DSCSR_CDS_Pos = 0x10
	// Bit mask of CDS field.
	CoreDebug_DSCSR_CDS_Msk = 0x10000
	// Bit CDS.
	CoreDebug_DSCSR_CDS = 0x10000
	// Position of CDSKEY field.
	CoreDebug_DSCSR_CDSKEY_Pos = 0x11
	// Bit mask of CDSKEY field.
	CoreDebug_DSCSR_CDSKEY_Msk = 0x20000
	// Bit CDSKEY.
	CoreDebug_DSCSR_CDSKEY = 0x20000
)

// Constants for DIB: Debug Identification Block
const (
	// DLAR: SCS Software Lock Access Register
	// Position of KEY field.
	DIB_DLAR_KEY_Pos = 0x0
	// Bit mask of KEY field.
	DIB_DLAR_KEY_Msk = 0xffffffff
	// Unlock key value
	DIB_DLAR_KEY_UNLOCK = 0xc5acce55

	// DLSR: SCS Software Lock Status Register
	// Position of SLI field.
	DIB_DLSR_SLI_Pos = 0x0
	// Bit mask of SLI field.
	DIB_DLSR_SLI_Msk = 0x1
	// Bit SLI.
	DIB_DLSR_SLI = 0x1
	// Position of SLK field.
	DIB_DLSR_SLK_Pos = 0x1
	// Bit mask of SLK field.
	DIB_DLSR_SLK_Msk = 0x2
	// Bit SLK.
	DIB_DLSR_SLK = 0x2
	// Position of NTT field.
	DIB_DLSR_NTT_Pos = 0x2
	// Bit mask of NTT field.
	DIB_DLSR_NTT_Msk = 0x4
	// Bit NTT.
	DIB_DLSR_NTT = 0x4

	// DAUTHSTATUS: Debug Authentication Status Register
	// Position of NSID field.
	DIB_DAUTHSTATUS_NSID_Pos = 0x0
	// Bit mask of NSID field.
	DIB_DAUTHSTATUS_NSID_Msk = 0x1
	// Bit NSID.
	DIB_DAUTHSTATUS_NSID = 0x1
	// Non-secure invasive debug prohibited
	DIB_DAUTHSTATUS_NSID_NO = 0x2
	// Non-secure invasive debug allowed
	DIB_DAUTHSTATUS_NSID_YES = 0x3
	// Position of NSNID field.
	DIB_DAUTHSTATUS_NSNID_Pos = 0x2
	// Bit mask of NSNID field.
	DIB_DAUTHSTATUS_NSNID_Msk = 0x4
	// Bit NSNID.
	DIB_DAUTHSTATUS_NSNID = 0x4
	// Non-secure non-invasive debug prohibited
	DIB_DAUTHSTATUS_NSNID_NO = 0x2
	// Non-secure non-invasive debug allowed
	DIB_DAUTHSTATUS_NSNID_YES = 0x3
	// Position of SID field.
	DIB_DAUTHSTATUS_SID_Pos = 0x4
	// Bit mask of SID field.
	DIB_DAUTHSTATUS_SID_Msk = 0x30
	// Security Extension not implemented
	DIB_DAUTHSTATUS_SID_NOSEC = 0x0
	// Secure invasive debug prohibited
	DIB_DAUTHSTATUS_SID_NO = 0x2
	// Secure invasive debug allowed
	DIB_DAUTHSTATUS_SID_YES = 0x3
	// Position of SNID field.
	DIB_DAUTHSTATUS_SNID_Pos = 0x6
	// Bit mask of SNID field.
	DIB_DAUTHSTATUS_SNID_Msk = 0xc0
	// Security Extension not implemented
	DIB_DAUTHSTATUS_SNID_NOSEC = 0x0
	// Secure non-invasive debug prohibited
	DIB_DAUTHSTATUS_SNID_NO = 0x2
	// Secure non-invasive debug allowed
	DIB_DAUTHSTATUS_SNID_YES = 0x3

	// DDEVARCH: SCS Device Architecture Register
	// Position of ARCHPART field.
	DIB_DDEVARCH_ARCHPART_Pos = 0x0
	// Bit mask of ARCHPART field.
	DIB_DDEVARCH_ARCHPART_Msk = 0xfff
	// Position of ARCHVER field.
	DIB_DDEVARCH_ARCHVER_Pos = 0xc
	// Bit mask of ARCHVER field.
	DIB_DDEVARCH_ARCHVER_Msk = 0xf000
	// Position of REVISION field.
	DIB_DDEVARCH_REVISION_Pos = 0x10
	// Bit mask of REVISION field.
	DIB_DDEVARCH_REVISION_Msk = 0xf0000
	// Position of PRESENT field.
	DIB_DDEVARCH_PRESENT_Pos = 0x14
	// Bit mask of PRESENT field.
	DIB_DDEVARCH_PRESENT_Msk = 0x100000
	// Bit PRESENT.
	DIB_DDEVARCH_PRESENT = 0x100000
	// Position of ARCHITECT field.
	DIB_DDEVARCH_ARCHITECT_Pos = 0x15
	// Bit mask of ARCHITECT field.
	DIB_DDEVARCH_ARCHITECT_Msk = 0xffe00000

	// DDEVTYPE: SCS Device Type Register
	// Position of MAJOR field.
	DIB_DDEVTYPE_MAJOR_Pos = 0x0
	// Bit mask of MAJOR field.
	DIB_DDEVTYPE_MAJOR_Msk = 0xf
	// Position of SUB field.
	DIB_DDEVTYPE_SUB_Pos = 0x4
	// Bit mask of SUB field.
	DIB_DDEVTYPE_SUB_Msk = 0xf0

	// DPIDR4: SCS Peripheral Identification Register 4
	// Position of DES_2 field.
	DIB_DPIDR4_DES_2_Pos = 0x0
	// Bit mask of DES_2 field.
	DIB_DPIDR4_DES_2_Msk = 0xf
	// Position of SIZE field.
	DIB_DPIDR4_SIZE_Pos = 0x4
	// Bit mask of SIZE field.
	DIB_DPIDR4_SIZE_Msk = 0xf0

	// DPIDR0: SCS Peripheral Identification Register 0
	// Position of PART_0 field.
	DIB_DPIDR0_PART_0_Pos = 0x0
	// Bit mask of PART_0 field.
	DIB_DPIDR0_PART_0_Msk = 0xff

	// DPIDR1: SCS Peripheral Identification Register 1
	// Position of PART_1 field.
	DIB_DPIDR1_PART_1_Pos = 0x0
	// Bit mask of PART_1 field.
	DIB_DPIDR1_PART_1_Msk = 0xf
	// Position of DES_0 field.
	DIB_DPIDR1_DES_0_Pos = 0x4
	// Bit mask of DES_0 field.
	DIB_DPIDR1_DES_0_Msk = 0xf0

	// DPIDR2: SCS Peripheral Identification Register 2
	// Position of DES_1 field.
	DIB_DPIDR2_DES_1_Pos = 0x0
	// Bit mask of DES_1 field.
	DIB_DPIDR2_DES_1_Msk = 0x7
	// Position of JEDEC field.
	DIB_DPIDR2_JEDEC_Pos = 0x3
	// Bit mask of JEDEC field.
	DIB_DPIDR2_JEDEC_Msk = 0x8
	// Bit JEDEC.
	DIB_DPIDR2_JEDEC = 0x8
	// Position of REVISION field.
	DIB_DPIDR2_REVISION_Pos = 0x4
	// Bit mask of REVISION field.
	DIB_DPIDR2_REVISION_Msk = 0xf0

	// DPIDR3: SCS Peripheral Identification Register 3
	// Position of CMOD field.
	DIB_DPIDR3_CMOD_Pos = 0x0
	// Bit mask of CMOD field.
	DIB_DPIDR3_CMOD_Msk = 0xf
	// Position of REVAND field.
	DIB_DPIDR3_REVAND_Pos = 0x4
	// Bit mask of REVAND field.
	DIB_DPIDR3_REVAND_Msk = 0xf0

	// DCIDR0: SCS Component Identification Register 0
	// Position of PRMBL_0 field.
	DIB_DCIDR0_PRMBL_0_Pos = 0x0
	// Bit mask of PRMBL_0 field.
	DIB_DCIDR0_PRMBL_0_Msk = 0xff

	// DCIDR1: SCS Component Identification Register 1
	// Position of PRMBL_1 field.
	DIB_DCIDR1_PRMBL_1_Pos = 0x0
	// Bit mask of PRMBL_1 field.
	DIB_DCIDR1_PRMBL_1_Msk = 0xf
	// Position of CLASS field.
	DIB_DCIDR1_CLASS_Pos = 0x4
	// Bit mask of CLASS field.
	DIB_DCIDR1_CLASS_Msk = 0xf0

	// DCIDR2: SCS Component Identification Register 2
	// Position of PRMBL_2 field.
	DIB_DCIDR2_PRMBL_2_Pos = 0x0
	// Bit mask of PRMBL_2 field.
	DIB_DCIDR2_PRMBL_2_Msk = 0xff

	// DCIDR3: SCS Component Identification Register 3
	// Position of PRMBL_3 field.
	DIB_DCIDR3_PRMBL_3_Pos = 0x0
	// Bit mask of PRMBL_3 field.
	DIB_DCIDR3_PRMBL_3_Msk = 0xff
)

// Constants for DWT: Data Watchpoint and Trace
const (
	// DWT_CTRL: DWT Control Register
	// Position of CYCCNTENA field.
	DWT_DWT_CTRL_CYCCNTENA_Pos = 0x0
	// Bit mask of CYCCNTENA field.
	DWT_DWT_CTRL_CYCCNTENA_Msk = 0x1
	// Bit CYCCNTENA.
	DWT_DWT_CTRL_CYCCNTENA = 0x1
	// Position of POSTPRESET field.
	DWT_DWT_CTRL_POSTPRESET_Pos = 0x1
	// Bit mask of POSTPRESET field.
	DWT_DWT_CTRL_POSTPRESET_Msk = 0x1e
	// Position of POSTINIT field.
	DWT_DWT_CTRL_POSTINIT_Pos = 0x5
	// Bit mask of POSTINIT field.
	DWT_DWT_CTRL_POSTINIT_Msk = 0x1e0
	// Position of CYCTAP field.
	DWT_DWT_CTRL_CYCTAP_Pos = 0x9
	// Bit mask of CYCTAP field.
	DWT_DWT_CTRL_CYCTAP_Msk = 0x200
	// Bit CYCTAP.
	DWT_DWT_CTRL_CYCTAP = 0x200
	// Position of SYNCTAP field.
	DWT_DWT_CTRL_SYNCTAP_Pos = 0xa
	// Bit mask of SYNCTAP field.
	DWT_DWT_CTRL_SYNCTAP_Msk = 0xc00
	// Position of PCSAMPLENA field.
	DWT_DWT_CTRL_PCSAMPLENA_Pos = 0xc
	// Bit mask of PCSAMPLENA field.
	DWT_DWT_CTRL_PCSAMPLENA_Msk = 0x1000
	// Bit PCSAMPLENA.
	DWT_DWT_CTRL_PCSAMPLENA = 0x1000
	// Position of EXCTRCENA field.
	DWT_DWT_CTRL_EXCTRCENA_Pos = 0x10
	// Bit mask of EXCTRCENA field.
	DWT_DWT_CTRL_EXCTRCENA_Msk = 0x10000
	// Bit EXCTRCENA.
	DWT_DWT_CTRL_EXCTRCENA = 0x10000
	// Position of CPIEVTENA field.
	DWT_DWT_CTRL_CPIEVTENA_Pos = 0x11
	// Bit mask of CPIEVTENA field.
	DWT_DWT_CTRL_CPIEVTENA_Msk = 0x20000
	// Bit CPIEVTENA.
	DWT_DWT_CTRL_CPIEVTENA = 0x20000
	// Position of EXCEVTENA field.
	DWT_DWT_CTRL_EXCEVTENA_Pos = 0x12
	// Bit mask of EXCEVTENA field.
	DWT_DWT_CTRL_EXCEVTENA_Msk = 0x40000
	// Bit EXCEVTENA.
	DWT_DWT_CTRL_EXCEVTENA = 0x40000
	// Position of SLEEPEVTENA field.
	DWT_DWT_CTRL_SLEEPEVTENA_Pos = 0x13
	// Bit mask of SLEEPEVTENA field.
	DWT_DWT_CTRL_SLEEPEVTENA_Msk = 0x80000
	// Bit SLEEPEVTENA.
	DWT_DWT_CTRL_SLEEPEVTENA = 0x80000
	// Position of LSUEVTENA field.
	DWT_DWT_CTRL_LSUEVTENA_Pos = 0x14
	// Bit mask of LSUEVTENA field.
	DWT_DWT_CTRL_LSUEVTENA_Msk = 0x100000
	// Bit LSUEVTENA.
	DWT_DWT_CTRL_LSUEVTENA = 0x100000
	// Position of FOLDEVTENA field.
	DWT_DWT_CTRL_FOLDEVTENA_Pos = 0x15
	// Bit mask of FOLDEVTENA field.
	DWT_DWT_CTRL_FOLDEVTENA_Msk = 0x200000
	// Bit FOLDEVTENA.
	DWT_DWT_CTRL_FOLDEVTENA = 0x200000
	// Position of CYCEVTENA field.
	DWT_DWT_CTRL_CYCEVTENA_Pos = 0x16
	// Bit mask of CYCEVTENA field.
	DWT_DWT_CTRL_CYCEVTENA_Msk = 0x400000
	// Bit CYCEVTENA.
	DWT_DWT_CTRL_CYCEVTENA = 0x400000
	// Position of CYCDISS field.
	DWT_DWT_CTRL_CYCDISS_Pos = 0x17
	// Bit mask of CYCDISS field.
	DWT_DWT_CTRL_CYCDISS_Msk = 0x800000
	// Bit CYCDISS.
	DWT_DWT_CTRL_CYCDISS = 0x800000
	// Position of NOPRFCNT field.
	DWT_DWT_CTRL_NOPRFCNT_Pos = 0x18
	// Bit mask of NOPRFCNT field.
	DWT_DWT_CTRL_NOPRFCNT_Msk = 0x1000000
	// Bit NOPRFCNT.
	DWT_DWT_CTRL_NOPRFCNT = 0x1000000
	// Position of NOCYCCNT field.
	DWT_DWT_CTRL_NOCYCCNT_Pos = 0x19
	// Bit mask of NOCYCCNT field.
	DWT_DWT_CTRL_NOCYCCNT_Msk = 0x2000000
	// Bit NOCYCCNT.
	DWT_DWT_CTRL_NOCYCCNT = 0x2000000
	// Position of NOEXTTRIG field.
	DWT_DWT_CTRL_NOEXTTRIG_Pos = 0x1a
	// Bit mask of NOEXTTRIG field.
	DWT_DWT_CTRL_NOEXTTRIG_Msk = 0x4000000
	// Bit NOEXTTRIG.
	DWT_DWT_CTRL_NOEXTTRIG = 0x4000000
	// Position of NOTRCPKT field.
	DWT_DWT_CTRL_NOTRCPKT_Pos = 0x1b
	// Bit mask of NOTRCPKT field.
	DWT_DWT_CTRL_NOTRCPKT_Msk = 0x8000000
	// Bit NOTRCPKT.
	DWT_DWT_CTRL_NOTRCPKT = 0x8000000
	// Position of NUMCOMP field.
	DWT_DWT_CTRL_NUMCOMP_Pos = 0x1c
	// Bit mask of NUMCOMP field.
	DWT_DWT_CTRL_NUMCOMP_Msk = 0xf0000000

	// DWT_PCSR: DWT Program Counter Sample Register
	// Position of EIASAMPLE field.
	DWT_DWT_PCSR_EIASAMPLE_Pos = 0x0
	// Bit mask of EIASAMPLE field.
	DWT_DWT_PCSR_EIASAMPLE_Msk = 0xffffffff

	// COMPARATOR.DWT_COMP: DWT Comparator Register n
	// Position of VALUE field.
	DWT_COMPARATOR_DWT_COMP_VALUE_Pos = 0x0
	// Bit mask of VALUE field.
	DWT_COMPARATOR_DWT_COMP_VALUE_Msk = 0xffffffff

	// COMPARATOR.DWT_FUNCTION: DWT Function Register x
	// Position of MATCH field.
	DWT_COMPARATOR_DWT_FUNCTION_MATCH_Pos = 0x0
	// Bit mask of MATCH field.
	DWT_COMPARATOR_DWT_FUNCTION_MATCH_Msk = 0xf
	// Position of ACTION field.
	DWT_COMPARATOR_DWT_FUNCTION_ACTION_Pos = 0x4
	// Bit mask of ACTION field.
	DWT_COMPARATOR_DWT_FUNCTION_ACTION_Msk = 0x30
	// Position of DATAVSIZE field.
	DWT_COMPARATOR_DWT_FUNCTION_DATAVSIZE_Pos = 0xa
	// Bit mask of DATAVSIZE field.
	DWT_COMPARATOR_DWT_FUNCTION_DATAVSIZE_Msk = 0xc00
	// Position of MATCHED field.
	DWT_COMPARATOR_DWT_FUNCTION_MATCHED_Pos = 0x18
	// Bit mask of MATCHED field.
	DWT_COMPARATOR_DWT_FUNCTION_MATCHED_Msk = 0x1000000
	// Bit MATCHED.
	DWT_COMPARATOR_DWT_FUNCTION_MATCHED = 0x1000000
	// Position of ID field.
	DWT_COMPARATOR_DWT_FUNCTION_ID_Pos = 0x1b
	// Bit mask of ID field.
	DWT_COMPARATOR_DWT_FUNCTION_ID_Msk = 0xf8000000

	// DWT_LAR: DWT Software Lock Access Register
	// Position of KEY field.
	DWT_DWT_LAR_KEY_Pos = 0x0
	// Bit mask of KEY field.
	DWT_DWT_LAR_KEY_Msk = 0xffffffff
	// Unlock key value
	DWT_DWT_LAR_KEY_UNLOCK = 0xc5acce55

	// DWT_LSR: DWT Software Lock Status Register
	// Position of SLI field.
	DWT_DWT_LSR_SLI_Pos = 0x0
	// Bit mask of SLI field.
	DWT_DWT_LSR_SLI_Msk = 0x1
	// Bit SLI.
	DWT_DWT_LSR_SLI = 0x1
	// Position of SLK field.
	DWT_DWT_LSR_SLK_Pos = 0x1
	// Bit mask of SLK field.
	DWT_DWT_LSR_SLK_Msk = 0x2
	// Bit SLK.
	DWT_DWT_LSR_SLK = 0x2
	// Position of NTT field.
	DWT_DWT_LSR_NTT_Pos = 0x2
	// Bit mask of NTT field.
	DWT_DWT_LSR_NTT_Msk = 0x4
	// Bit NTT.
	DWT_DWT_LSR_NTT = 0x4

	// DWT_DEVARCH: DWT Device Architecture Register
	// Position of ARCHPART field.
	DWT_DWT_DEVARCH_ARCHPART_Pos = 0x0
	// Bit mask of ARCHPART field.
	DWT_DWT_DEVARCH_ARCHPART_Msk = 0xfff
	// Position of ARCHVER field.
	DWT_DWT_DEVARCH_ARCHVER_Pos = 0xc
	// Bit mask of ARCHVER field.
	DWT_DWT_DEVARCH_ARCHVER_Msk = 0xf000
	// Position of REVISION field.
	DWT_DWT_DEVARCH_REVISION_Pos = 0x10
	// Bit mask of REVISION field.
	DWT_DWT_DEVARCH_REVISION_Msk = 0xf0000
	// Position of PRESENT field.
	DWT_DWT_DEVARCH_PRESENT_Pos = 0x14
	// Bit mask of PRESENT field.
	DWT_DWT_DEVARCH_PRESENT_Msk = 0x100000
	// Bit PRESENT.
	DWT_DWT_DEVARCH_PRESENT = 0x100000
	// Position of ARCHITECT field.
	DWT_DWT_DEVARCH_ARCHITECT_Pos = 0x15
	// Bit mask of ARCHITECT field.
	DWT_DWT_DEVARCH_ARCHITECT_Msk = 0xffe00000

	// DWT_DEVTYPE: DWT Device Type Register
	// Position of MAJOR field.
	DWT_DWT_DEVTYPE_MAJOR_Pos = 0x0
	// Bit mask of MAJOR field.
	DWT_DWT_DEVTYPE_MAJOR_Msk = 0xf
	// Position of SUB field.
	DWT_DWT_DEVTYPE_SUB_Pos = 0x4
	// Bit mask of SUB field.
	DWT_DWT_DEVTYPE_SUB_Msk = 0xf0

	// DWT_PIDR4: DWT Peripheral Identification Register 4
	// Position of DES_2 field.
	DWT_DWT_PIDR4_DES_2_Pos = 0x0
	// Bit mask of DES_2 field.
	DWT_DWT_PIDR4_DES_2_Msk = 0xf
	// Position of SIZE field.
	DWT_DWT_PIDR4_SIZE_Pos = 0x4
	// Bit mask of SIZE field.
	DWT_DWT_PIDR4_SIZE_Msk = 0xf0

	// DWT_PIDR0: DWT Peripheral Identification Register 0
	// Position of PART_0 field.
	DWT_DWT_PIDR0_PART_0_Pos = 0x0
	// Bit mask of PART_0 field.
	DWT_DWT_PIDR0_PART_0_Msk = 0xff

	// DWT_PIDR1: DWT Peripheral Identification Register 1
	// Position of PART_1 field.
	DWT_DWT_PIDR1_PART_1_Pos = 0x0
	// Bit mask of PART_1 field.
	DWT_DWT_PIDR1_PART_1_Msk = 0xf
	// Position of DES_0 field.
	DWT_DWT_PIDR1_DES_0_Pos = 0x4
	// Bit mask of DES_0 field.
	DWT_DWT_PIDR1_DES_0_Msk = 0xf0

	// DWT_PIDR2: DWT Peripheral Identification Register 2
	// Position of DES_1 field.
	DWT_DWT_PIDR2_DES_1_Pos = 0x0
	// Bit mask of DES_1 field.
	DWT_DWT_PIDR2_DES_1_Msk = 0x7
	// Position of JEDEC field.
	DWT_DWT_PIDR2_JEDEC_Pos = 0x3
	// Bit mask of JEDEC field.
	DWT_DWT_PIDR2_JEDEC_Msk = 0x8
	// Bit JEDEC.
	DWT_DWT_PIDR2_JEDEC = 0x8
	// Position of REVISION field.
	DWT_DWT_PIDR2_REVISION_Pos = 0x4
	// Bit mask of REVISION field.
	DWT_DWT_PIDR2_REVISION_Msk = 0xf0

	// DWT_PIDR3: DWT Peripheral Identification Register 3
	// Position of CMOD field.
	DWT_DWT_PIDR3_CMOD_Pos = 0x0
	// Bit mask of CMOD field.
	DWT_DWT_PIDR3_CMOD_Msk = 0xf
	// Position of REVAND field.
	DWT_DWT_PIDR3_REVAND_Pos = 0x4
	// Bit mask of REVAND field.
	DWT_DWT_PIDR3_REVAND_Msk = 0xf0

	// DWT_CIDR0: DWT Component Identification Register 0
	// Position of PRMBL_0 field.
	DWT_DWT_CIDR0_PRMBL_0_Pos = 0x0
	// Bit mask of PRMBL_0 field.
	DWT_DWT_CIDR0_PRMBL_0_Msk = 0xff

	// DWT_CIDR1: DWT Component Identification Register 1
	// Position of PRMBL_1 field.
	DWT_DWT_CIDR1_PRMBL_1_Pos = 0x0
	// Bit mask of PRMBL_1 field.
	DWT_DWT_CIDR1_PRMBL_1_Msk = 0xf
	// Position of CLASS field.
	DWT_DWT_CIDR1_CLASS_Pos = 0x4
	// Bit mask of CLASS field.
	DWT_DWT_CIDR1_CLASS_Msk = 0xf0

	// DWT_CIDR2: DWT Component Identification Register 2
	// Position of PRMBL_2 field.
	DWT_DWT_CIDR2_PRMBL_2_Pos = 0x0
	// Bit mask of PRMBL_2 field.
	DWT_DWT_CIDR2_PRMBL_2_Msk = 0xff

	// DWT_CIDR3: DWT Component Identification Register 3
	// Position of PRMBL_3 field.
	DWT_DWT_CIDR3_PRMBL_3_Pos = 0x0
	// Bit mask of PRMBL_3 field.
	DWT_DWT_CIDR3_PRMBL_3_Msk = 0xff
)

// Constants for FPB: Flash Patch and Breakpoint
const (
	// FP_CTRL: Flash Patch Control Register
	// Position of ENABLE field.
	FPB_FP_CTRL_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	FPB_FP_CTRL_ENABLE_Msk = 0x1
	// Bit ENABLE.
	FPB_FP_CTRL_ENABLE = 0x1
	// Position of KEY field.
	FPB_FP_CTRL_KEY_Pos = 0x1
	// Bit mask of KEY field.
	FPB_FP_CTRL_KEY_Msk = 0x2
	// Bit KEY.
	FPB_FP_CTRL_KEY = 0x2
	// Position of NUM_CODE field.
	FPB_FP_CTRL_NUM_CODE_Pos = 0x4
	// Bit mask of NUM_CODE field.
	FPB_FP_CTRL_NUM_CODE_Msk = 0xf0
	// Position of NUM_LIT field.
	FPB_FP_CTRL_NUM_LIT_Pos = 0x8
	// Bit mask of NUM_LIT field.
	FPB_FP_CTRL_NUM_LIT_Msk = 0xf00
	// Position of NUM_CODE_1 field.
	FPB_FP_CTRL_NUM_CODE_1_Pos = 0xc
	// Bit mask of NUM_CODE_1 field.
	FPB_FP_CTRL_NUM_CODE_1_Msk = 0x7000
	// Position of REV field.
	FPB_FP_CTRL_REV_Pos = 0x1c
	// Bit mask of REV field.
	FPB_FP_CTRL_REV_Msk = 0xf0000000

	// FP_REMAP: Flash Patch Remap Register
	// Position of REMAP field.
	FPB_FP_REMAP_REMAP_Pos = 0x5
	// Bit mask of REMAP field.
	FPB_FP_REMAP_REMAP_Msk = 0x1fffffe0
	// Position of RMPSPT field.
	FPB_FP_REMAP_RMPSPT_Pos = 0x1d
	// Bit mask of RMPSPT field.
	FPB_FP_REMAP_RMPSPT_Msk = 0x20000000
	// Bit RMPSPT.
	FPB_FP_REMAP_RMPSPT = 0x20000000

	// FP_COMP: Flash Patch Comparator Register n
	// Position of BE field.
	FPB_FP_COMP_BE_Pos = 0x0
	// Bit mask of BE field.
	FPB_FP_COMP_BE_Msk = 0x1
	// Bit BE.
	FPB_FP_COMP_BE = 0x1
	// Position of FPADDR field.
	FPB_FP_COMP_FPADDR_Pos = 0x2
	// Bit mask of FPADDR field.
	FPB_FP_COMP_FPADDR_Msk = 0x1ffffffc
	// Position of FE field.
	FPB_FP_COMP_FE_Pos = 0x1f
	// Bit mask of FE field.
	FPB_FP_COMP_FE_Msk = 0x80000000
	// Bit FE.
	FPB_FP_COMP_FE = 0x80000000

	// FP_COMP_BREAKPOINT_MODE: Flash Patch Comparator Register n
	// Position of BE field.
	FPB_FP_COMP_BREAKPOINT_MODE_BE_Pos = 0x0
	// Bit mask of BE field.
	FPB_FP_COMP_BREAKPOINT_MODE_BE_Msk = 0x1
	// Bit BE.
	FPB_FP_COMP_BREAKPOINT_MODE_BE = 0x1
	// Position of BPADDR field.
	FPB_FP_COMP_BREAKPOINT_MODE_BPADDR_Pos = 0x1
	// Bit mask of BPADDR field.
	FPB_FP_COMP_BREAKPOINT_MODE_BPADDR_Msk = 0xfffffffe

	// FP_LAR: FPB Software Lock Access Register
	// Position of KEY field.
	FPB_FP_LAR_KEY_Pos = 0x0
	// Bit mask of KEY field.
	FPB_FP_LAR_KEY_Msk = 0xffffffff
	// Unlock key value
	FPB_FP_LAR_KEY_UNLOCK = 0xc5acce55

	// FP_LSR: FPB Software Lock Status Register
	// Position of SLI field.
	FPB_FP_LSR_SLI_Pos = 0x0
	// Bit mask of SLI field.
	FPB_FP_LSR_SLI_Msk = 0x1
	// Bit SLI.
	FPB_FP_LSR_SLI = 0x1
	// Position of SLK field.
	FPB_FP_LSR_SLK_Pos = 0x1
	// Bit mask of SLK field.
	FPB_FP_LSR_SLK_Msk = 0x2
	// Bit SLK.
	FPB_FP_LSR_SLK = 0x2
	// Position of NTT field.
	FPB_FP_LSR_NTT_Pos = 0x2
	// Bit mask of NTT field.
	FPB_FP_LSR_NTT_Msk = 0x4
	// Bit NTT.
	FPB_FP_LSR_NTT = 0x4

	// FP_DEVARCH: FPB Device Architecture Register
	// Position of ARCHPART field.
	FPB_FP_DEVARCH_ARCHPART_Pos = 0x0
	// Bit mask of ARCHPART field.
	FPB_FP_DEVARCH_ARCHPART_Msk = 0xfff
	// Position of ARCHVER field.
	FPB_FP_DEVARCH_ARCHVER_Pos = 0xc
	// Bit mask of ARCHVER field.
	FPB_FP_DEVARCH_ARCHVER_Msk = 0xf000
	// Position of REVISION field.
	FPB_FP_DEVARCH_REVISION_Pos = 0x10
	// Bit mask of REVISION field.
	FPB_FP_DEVARCH_REVISION_Msk = 0xf0000
	// Position of PRESENT field.
	FPB_FP_DEVARCH_PRESENT_Pos = 0x14
	// Bit mask of PRESENT field.
	FPB_FP_DEVARCH_PRESENT_Msk = 0x100000
	// Bit PRESENT.
	FPB_FP_DEVARCH_PRESENT = 0x100000
	// Position of ARCHITECT field.
	FPB_FP_DEVARCH_ARCHITECT_Pos = 0x15
	// Bit mask of ARCHITECT field.
	FPB_FP_DEVARCH_ARCHITECT_Msk = 0xffe00000

	// FP_DEVTYPE: FPB Device Type Register
	// Position of MAJOR field.
	FPB_FP_DEVTYPE_MAJOR_Pos = 0x0
	// Bit mask of MAJOR field.
	FPB_FP_DEVTYPE_MAJOR_Msk = 0xf
	// Position of SUB field.
	FPB_FP_DEVTYPE_SUB_Pos = 0x4
	// Bit mask of SUB field.
	FPB_FP_DEVTYPE_SUB_Msk = 0xf0

	// FP_PIDR4: FP Peripheral Identification Register 4
	// Position of DES_2 field.
	FPB_FP_PIDR4_DES_2_Pos = 0x0
	// Bit mask of DES_2 field.
	FPB_FP_PIDR4_DES_2_Msk = 0xf
	// Position of SIZE field.
	FPB_FP_PIDR4_SIZE_Pos = 0x4
	// Bit mask of SIZE field.
	FPB_FP_PIDR4_SIZE_Msk = 0xf0

	// FP_PIDR0: FP Peripheral Identification Register 0
	// Position of PART_0 field.
	FPB_FP_PIDR0_PART_0_Pos = 0x0
	// Bit mask of PART_0 field.
	FPB_FP_PIDR0_PART_0_Msk = 0xff

	// FP_PIDR1: FP Peripheral Identification Register 1
	// Position of PART_1 field.
	FPB_FP_PIDR1_PART_1_Pos = 0x0
	// Bit mask of PART_1 field.
	FPB_FP_PIDR1_PART_1_Msk = 0xf
	// Position of DES_0 field.
	FPB_FP_PIDR1_DES_0_Pos = 0x4
	// Bit mask of DES_0 field.
	FPB_FP_PIDR1_DES_0_Msk = 0xf0

	// FP_PIDR2: FP Peripheral Identification Register 2
	// Position of DES_1 field.
	FPB_FP_PIDR2_DES_1_Pos = 0x0
	// Bit mask of DES_1 field.
	FPB_FP_PIDR2_DES_1_Msk = 0x7
	// Position of JEDEC field.
	FPB_FP_PIDR2_JEDEC_Pos = 0x3
	// Bit mask of JEDEC field.
	FPB_FP_PIDR2_JEDEC_Msk = 0x8
	// Bit JEDEC.
	FPB_FP_PIDR2_JEDEC = 0x8
	// Position of REVISION field.
	FPB_FP_PIDR2_REVISION_Pos = 0x4
	// Bit mask of REVISION field.
	FPB_FP_PIDR2_REVISION_Msk = 0xf0

	// FP_PIDR3: FP Peripheral Identification Register 3
	// Position of CMOD field.
	FPB_FP_PIDR3_CMOD_Pos = 0x0
	// Bit mask of CMOD field.
	FPB_FP_PIDR3_CMOD_Msk = 0xf
	// Position of REVAND field.
	FPB_FP_PIDR3_REVAND_Pos = 0x4
	// Bit mask of REVAND field.
	FPB_FP_PIDR3_REVAND_Msk = 0xf0

	// FP_CIDR0: FP Component Identification Register 0
	// Position of PRMBL_0 field.
	FPB_FP_CIDR0_PRMBL_0_Pos = 0x0
	// Bit mask of PRMBL_0 field.
	FPB_FP_CIDR0_PRMBL_0_Msk = 0xff

	// FP_CIDR1: FP Component Identification Register 1
	// Position of PRMBL_1 field.
	FPB_FP_CIDR1_PRMBL_1_Pos = 0x0
	// Bit mask of PRMBL_1 field.
	FPB_FP_CIDR1_PRMBL_1_Msk = 0xf
	// Position of CLASS field.
	FPB_FP_CIDR1_CLASS_Pos = 0x4
	// Bit mask of CLASS field.
	FPB_FP_CIDR1_CLASS_Msk = 0xf0

	// FP_CIDR2: FP Component Identification Register 2
	// Position of PRMBL_2 field.
	FPB_FP_CIDR2_PRMBL_2_Pos = 0x0
	// Bit mask of PRMBL_2 field.
	FPB_FP_CIDR2_PRMBL_2_Msk = 0xff

	// FP_CIDR3: FP Component Identification Register 3
	// Position of PRMBL_3 field.
	FPB_FP_CIDR3_PRMBL_3_Pos = 0x0
	// Bit mask of PRMBL_3 field.
	FPB_FP_CIDR3_PRMBL_3_Msk = 0xff
)

// Constants for ICB: Implementation Control Block
const (
	// ICTR: Interrupt Controller Type Register
	// Position of INTLINESNUM field.
	ICB_ICTR_INTLINESNUM_Pos = 0x0
	// Bit mask of INTLINESNUM field.
	ICB_ICTR_INTLINESNUM_Msk = 0xf
)

// Constants for MPU: Memory Protection Unit
const (
	// MPU_TYPE: MPU Type Register
	// Position of SEPARATE field.
	MPU_MPU_TYPE_SEPARATE_Pos = 0x0
	// Bit mask of SEPARATE field.
	MPU_MPU_TYPE_SEPARATE_Msk = 0x1
	// Bit SEPARATE.
	MPU_MPU_TYPE_SEPARATE = 0x1
	// Position of DREGION field.
	MPU_MPU_TYPE_DREGION_Pos = 0x8
	// Bit mask of DREGION field.
	MPU_MPU_TYPE_DREGION_Msk = 0xff00

	// MPU_CTRL: MPU Control Register
	// Position of ENABLE field.
	MPU_MPU_CTRL_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	MPU_MPU_CTRL_ENABLE_Msk = 0x1
	// Bit ENABLE.
	MPU_MPU_CTRL_ENABLE = 0x1
	// Position of HFNMIENA field.
	MPU_MPU_CTRL_HFNMIENA_Pos = 0x1
	// Bit mask of HFNMIENA field.
	MPU_MPU_CTRL_HFNMIENA_Msk = 0x2
	// Bit HFNMIENA.
	MPU_MPU_CTRL_HFNMIENA = 0x2
	// Position of PRIVDEFENA field.
	MPU_MPU_CTRL_PRIVDEFENA_Pos = 0x2
	// Bit mask of PRIVDEFENA field.
	MPU_MPU_CTRL_PRIVDEFENA_Msk = 0x4
	// Bit PRIVDEFENA.
	MPU_MPU_CTRL_PRIVDEFENA = 0x4

	// MPU_RNR: MPU Region Number Register
	// Position of REGION field.
	MPU_MPU_RNR_REGION_Pos = 0x0
	// Bit mask of REGION field.
	MPU_MPU_RNR_REGION_Msk = 0xff

	// MPU_RBAR: MPU Region Base Address Register
	// Position of XN field.
	MPU_MPU_RBAR_XN_Pos = 0x0
	// Bit mask of XN field.
	MPU_MPU_RBAR_XN_Msk = 0x1
	// Bit XN.
	MPU_MPU_RBAR_XN = 0x1
	// Position of AP field.
	MPU_MPU_RBAR_AP_Pos = 0x1
	// Bit mask of AP field.
	MPU_MPU_RBAR_AP_Msk = 0x6
	// Read/write by privileged code only
	MPU_MPU_RBAR_AP_RWPRIV = 0x0
	// Read/write by any privilege level
	MPU_MPU_RBAR_AP_RWANY = 0x1
	// Read-only by privileged code only
	MPU_MPU_RBAR_AP_RPRIV = 0x2
	// Read-only by any privilege level
	MPU_MPU_RBAR_AP_RANY = 0x3
	// Position of SH field.
	MPU_MPU_RBAR_SH_Pos = 0x3
	// Bit mask of SH field.
	MPU_MPU_RBAR_SH_Msk = 0x18
	// Non-shareable
	MPU_MPU_RBAR_SH_NO = 0x0
	// Outer shareable
	MPU_MPU_RBAR_SH_OUTER = 0x2
	// Inner shareable
	MPU_MPU_RBAR_SH_INNER = 0x3
	// Position of BASE field.
	MPU_MPU_RBAR_BASE_Pos = 0x5
	// Bit mask of BASE field.
	MPU_MPU_RBAR_BASE_Msk = 0xffffffe0

	// MPU_RLAR: MPU Region Limit Address Register
	// Position of EN field.
	MPU_MPU_RLAR_EN_Pos = 0x0
	// Bit mask of EN field.
	MPU_MPU_RLAR_EN_Msk = 0x1
	// Bit EN.
	MPU_MPU_RLAR_EN = 0x1
	// Position of AttrInd field.
	MPU_MPU_RLAR_AttrInd_Pos = 0x1
	// Bit mask of AttrInd field.
	MPU_MPU_RLAR_AttrInd_Msk = 0xe
	// Position of LIMIT field.
	MPU_MPU_RLAR_LIMIT_Pos = 0x5
	// Bit mask of LIMIT field.
	MPU_MPU_RLAR_LIMIT_Msk = 0xffffffe0

	// MPU_MAIR0: MPU Memory Attribute Indirection Register 0
	// Position of Attr0 field.
	MPU_MPU_MAIR0_Attr0_Pos = 0x0
	// Bit mask of Attr0 field.
	MPU_MPU_MAIR0_Attr0_Msk = 0xff
	// Position of Attr1 field.
	MPU_MPU_MAIR0_Attr1_Pos = 0x8
	// Bit mask of Attr1 field.
	MPU_MPU_MAIR0_Attr1_Msk = 0xff00
	// Position of Attr2 field.
	MPU_MPU_MAIR0_Attr2_Pos = 0x10
	// Bit mask of Attr2 field.
	MPU_MPU_MAIR0_Attr2_Msk = 0xff0000
	// Position of Attr3 field.
	MPU_MPU_MAIR0_Attr3_Pos = 0x18
	// Bit mask of Attr3 field.
	MPU_MPU_MAIR0_Attr3_Msk = 0xff000000
)

// Constants for NVIC: Nested Vectored Interrupt Controller
const (
	// NVIC_ISER: Interrupt Set Enable Register n
	// Position of SETENA field.
	NVIC_NVIC_ISER_SETENA_Pos = 0x0
	// Bit mask of SETENA field.
	NVIC_NVIC_ISER_SETENA_Msk = 0xffffffff

	// NVIC_ICER: Interrupt Clear Enable Register n
	// Position of CLRENA field.
	NVIC_NVIC_ICER_CLRENA_Pos = 0x0
	// Bit mask of CLRENA field.
	NVIC_NVIC_ICER_CLRENA_Msk = 0xffffffff

	// NVIC_ISPR: Interrupt Set Pending Register n
	// Position of SETPEND field.
	NVIC_NVIC_ISPR_SETPEND_Pos = 0x0
	// Bit mask of SETPEND field.
	NVIC_NVIC_ISPR_SETPEND_Msk = 0xffffffff

	// NVIC_ICPR: Interrupt Clear Pending Register n
	// Position of CLRPEND field.
	NVIC_NVIC_ICPR_CLRPEND_Pos = 0x0
	// Bit mask of CLRPEND field.
	NVIC_NVIC_ICPR_CLRPEND_Msk = 0xffffffff

	// NVIC_IABR: Interrupt Active Bit Register n
	// Position of ACTIVE field.
	NVIC_NVIC_IABR_ACTIVE_Pos = 0x0
	// Bit mask of ACTIVE field.
	NVIC_NVIC_IABR_ACTIVE_Msk = 0xffffffff

	// NVIC_ITNS: Interrupt Target Non-secure Register n
	// Position of ITNS field.
	NVIC_NVIC_ITNS_ITNS_Pos = 0x0
	// Bit mask of ITNS field.
	NVIC_NVIC_ITNS_ITNS_Msk = 0xffffffff

	// NVIC_IPR: Interrupt Priority Register n
	// Position of PRI_N0 field.
	NVIC_NVIC_IPR_PRI_N0_Pos = 0x0
	// Bit mask of PRI_N0 field.
	NVIC_NVIC_IPR_PRI_N0_Msk = 0xff
	// Position of PRI_N1 field.
	NVIC_NVIC_IPR_PRI_N1_Pos = 0x8
	// Bit mask of PRI_N1 field.
	NVIC_NVIC_IPR_PRI_N1_Msk = 0xff00
	// Position of PRI_N2 field.
	NVIC_NVIC_IPR_PRI_N2_Pos = 0x10
	// Bit mask of PRI_N2 field.
	NVIC_NVIC_IPR_PRI_N2_Msk = 0xff0000
	// Position of PRI_N3 field.
	NVIC_NVIC_IPR_PRI_N3_Pos = 0x18
	// Bit mask of PRI_N3 field.
	NVIC_NVIC_IPR_PRI_N3_Msk = 0xff000000
)

// Constants for SCB: System Control Block
const (
	// CPUID: CPUID base register
	// Position of Revision field.
	SCB_CPUID_Revision_Pos = 0x0
	// Bit mask of Revision field.
	SCB_CPUID_Revision_Msk = 0xf
	// Position of PartNo field.
	SCB_CPUID_PartNo_Pos = 0x4
	// Bit mask of PartNo field.
	SCB_CPUID_PartNo_Msk = 0xfff0
	// Position of Architecture field.
	SCB_CPUID_Architecture_Pos = 0x10
	// Bit mask of Architecture field.
	SCB_CPUID_Architecture_Msk = 0xf0000
	// Position of Variant field.
	SCB_CPUID_Variant_Pos = 0x14
	// Bit mask of Variant field.
	SCB_CPUID_Variant_Msk = 0xf00000
	// Position of Implementer field.
	SCB_CPUID_Implementer_Pos = 0x18
	// Bit mask of Implementer field.
	SCB_CPUID_Implementer_Msk = 0xff000000

	// ICSR: Interrupt Control and State Register
	// Position of VECTACTIVE field.
	SCB_ICSR_VECTACTIVE_Pos = 0x0
	// Bit mask of VECTACTIVE field.
	SCB_ICSR_VECTACTIVE_Msk = 0x1ff
	// Position of RETTOBASE field.
	SCB_ICSR_RETTOBASE_Pos = 0xb
	// Bit mask of RETTOBASE field.
	SCB_ICSR_RETTOBASE_Msk = 0x800
	// Bit RETTOBASE.
	SCB_ICSR_RETTOBASE = 0x800
	// Position of VECTPENDING field.
	SCB_ICSR_VECTPENDING_Pos = 0xc
	// Bit mask of VECTPENDING field.
	SCB_ICSR_VECTPENDING_Msk = 0x1ff000
	// Position of ISRPENDING field.
	SCB_ICSR_ISRPENDING_Pos = 0x16
	// Bit mask of ISRPENDING field.
	SCB_ICSR_ISRPENDING_Msk = 0x400000
	// Bit ISRPENDING.
	SCB_ICSR_ISRPENDING = 0x400000
	// Position of ISRPREEMPT field.
	SCB_ICSR_ISRPREEMPT_Pos = 0x17
	// Bit mask of ISRPREEMPT field.
	SCB_ICSR_ISRPREEMPT_Msk = 0x800000
	// Bit ISRPREEMPT.
	SCB_ICSR_ISRPREEMPT = 0x800000
	// Position of PENDSTCLR field.
	SCB_ICSR_PENDSTCLR_Pos = 0x19
	// Bit mask of PENDSTCLR field.
	SCB_ICSR_PENDSTCLR_Msk = 0x2000000
	// Bit PENDSTCLR.
	SCB_ICSR_PENDSTCLR = 0x2000000
	// No effect
	SCB_ICSR_PENDSTCLR_VALUE_0 = 0x0
	// Removes the pending state from the SysTick exception
	SCB_ICSR_PENDSTCLR_VALUE_1 = 0x1
	// Position of PENDSTSET field.
	SCB_ICSR_PENDSTSET_Pos = 0x1a
	// Bit mask of PENDSTSET field.
	SCB_ICSR_PENDSTSET_Msk = 0x4000000
	// Bit PENDSTSET.
	SCB_ICSR_PENDSTSET = 0x4000000
	// Write: no effect; read: SysTick exception is not pending
	SCB_ICSR_PENDSTSET_VALUE_0 = 0x0
	// Write: changes SysTick exception state to pending; read: SysTick exception is pending
	SCB_ICSR_PENDSTSET_VALUE_1 = 0x1
	// Position of PENDSVCLR field.
	SCB_ICSR_PENDSVCLR_Pos = 0x1b
	// Bit mask of PENDSVCLR field.
	SCB_ICSR_PENDSVCLR_Msk = 0x8000000
	// Bit PENDSVCLR.
	SCB_ICSR_PENDSVCLR = 0x8000000
	// No effect
	SCB_ICSR_PENDSVCLR_VALUE_0 = 0x0
	// Removes the pending state from the PendSV exception
	SCB_ICSR_PENDSVCLR_VALUE_1 = 0x1
	// Position of PENDSVSET field.
	SCB_ICSR_PENDSVSET_Pos = 0x1c
	// Bit mask of PENDSVSET field.
	SCB_ICSR_PENDSVSET_Msk = 0x10000000
	// Bit PENDSVSET.
	SCB_ICSR_PENDSVSET = 0x10000000
	// Write: no effect; read: PendSV exception is not pending
	SCB_ICSR_PENDSVSET_VALUE_0 = 0x0
	// Write: changes PendSV exception state to pending; read: PendSV exception is pending
	SCB_ICSR_PENDSVSET_VALUE_1 = 0x1
	// Position of PENDNMICLR field.
	SCB_ICSR_PENDNMICLR_Pos = 0x1e
	// Bit mask of PENDNMICLR field.
	SCB_ICSR_PENDNMICLR_Msk = 0x40000000
	// Bit PENDNMICLR.
	SCB_ICSR_PENDNMICLR = 0x40000000
	// Position of PENDNMISET field.
	SCB_ICSR_PENDNMISET_Pos = 0x1f
	// Bit mask of PENDNMISET field.
	SCB_ICSR_PENDNMISET_Msk = 0x80000000
	// Bit PENDNMISET.
	SCB_ICSR_PENDNMISET = 0x80000000
	// Write: no effect; read: NMI exception is not pending
	SCB_ICSR_PENDNMISET_VALUE_0 = 0x0
	// Write: changes NMI exception state to pending; read: NMI exception is pending
	SCB_ICSR_PENDNMISET_VALUE_1 = 0x1

	// VTOR: Vector Table Offset Register
	// Position of TBLOFF field.
	SCB_VTOR_TBLOFF_Pos = 0x7
	// Bit mask of TBLOFF field.
	SCB_VTOR_TBLOFF_Msk = 0xffffff80

	// AIRCR: Application Interrupt and Reset Control Register
	// Position of VECTCLRACTIVE field.
	SCB_AIRCR_VECTCLRACTIVE_Pos = 0x1
	// Bit mask of VECTCLRACTIVE field.
	SCB_AIRCR_VECTCLRACTIVE_Msk = 0x2
	// Bit VECTCLRACTIVE.
	SCB_AIRCR_VECTCLRACTIVE = 0x2
	// Do not clear active state
	SCB_AIRCR_VECTCLRACTIVE_NO = 0x0
	// Clear active state
	SCB_AIRCR_VECTCLRACTIVE_YES = 0x1
	// Position of SYSRESETREQ field.
	SCB_AIRCR_SYSRESETREQ_Pos = 0x2
	// Bit mask of SYSRESETREQ field.
	SCB_AIRCR_SYSRESETREQ_Msk = 0x4
	// Bit SYSRESETREQ.
	SCB_AIRCR_SYSRESETREQ = 0x4
	// Do not request a system reset
	SCB_AIRCR_SYSRESETREQ_NO = 0x0
	// Request a system reset
	SCB_AIRCR_SYSRESETREQ_YES = 0x1
	// Position of SYSRESETREQS field.
	SCB_AIRCR_SYSRESETREQS_Pos = 0x3
	// Bit mask of SYSRESETREQS field.
	SCB_AIRCR_SYSRESETREQS_Msk = 0x8
	// Bit SYSRESETREQS.
	SCB_AIRCR_SYSRESETREQS = 0x8
	// SYSRESETREQ functionality is available to both Security states
	SCB_AIRCR_SYSRESETREQS_BOTH = 0x0
	// SYSRESETREQ functionality is only available to Secure state
	SCB_AIRCR_SYSRESETREQS_SECURE = 0x1
	// Position of BFHFNMINS field.
	SCB_AIRCR_BFHFNMINS_Pos = 0xd
	// Bit mask of BFHFNMINS field.
	SCB_AIRCR_BFHFNMINS_Msk = 0x2000
	// Bit BFHFNMINS.
	SCB_AIRCR_BFHFNMINS = 0x2000
	// BusFault, HardFault, and NMI are Secure
	SCB_AIRCR_BFHFNMINS_SECURE = 0x0
	// BusFault and NMI are Non-secure and exceptions can target Non-secure HardFault
	SCB_AIRCR_BFHFNMINS_NON_SECURE = 0x1
	// Position of PRIS field.
	SCB_AIRCR_PRIS_Pos = 0xe
	// Bit mask of PRIS field.
	SCB_AIRCR_PRIS_Msk = 0x4000
	// Bit PRIS.
	SCB_AIRCR_PRIS = 0x4000
	// Priority ranges of Secure and Non-secure exceptions are identical
	SCB_AIRCR_PRIS_SAME = 0x0
	// Non-secure exceptions are de-prioritized
	SCB_AIRCR_PRIS_NS_DEPRIO = 0x1
	// Position of ENDIANNESS field.
	SCB_AIRCR_ENDIANNESS_Pos = 0xf
	// Bit mask of ENDIANNESS field.
	SCB_AIRCR_ENDIANNESS_Msk = 0x8000
	// Bit ENDIANNESS.
	SCB_AIRCR_ENDIANNESS = 0x8000
	// Little-endian
	SCB_AIRCR_ENDIANNESS_LITTLE = 0x0
	// Big-endian
	SCB_AIRCR_ENDIANNESS_BIG = 0x1
	// Position of VECTKEY field.
	SCB_AIRCR_VECTKEY_Pos = 0x10
	// Bit mask of VECTKEY field.
	SCB_AIRCR_VECTKEY_Msk = 0xffff0000

	// SCR: System Control Register
	// Position of SLEEPONEXIT field.
	SCB_SCR_SLEEPONEXIT_Pos = 0x1
	// Bit mask of SLEEPONEXIT field.
	SCB_SCR_SLEEPONEXIT_Msk = 0x2
	// Bit SLEEPONEXIT.
	SCB_SCR_SLEEPONEXIT = 0x2
	// O not sleep when returning to Thread mode
	SCB_SCR_SLEEPONEXIT_VALUE_0 = 0x0
	// Enter sleep, or deep sleep, on return from an ISR
	SCB_SCR_SLEEPONEXIT_VALUE_1 = 0x1
	// Position of SLEEPDEEP field.
	SCB_SCR_SLEEPDEEP_Pos = 0x2
	// Bit mask of SLEEPDEEP field.
	SCB_SCR_SLEEPDEEP_Msk = 0x4
	// Bit SLEEPDEEP.
	SCB_SCR_SLEEPDEEP = 0x4
	// Sleep
	SCB_SCR_SLEEPDEEP_VALUE_0 = 0x0
	// Deep sleep
	SCB_SCR_SLEEPDEEP_VALUE_1 = 0x1
	// Position of SLEEPDEEPS field.
	SCB_SCR_SLEEPDEEPS_Pos = 0x3
	// Bit mask of SLEEPDEEPS field.
	SCB_SCR_SLEEPDEEPS_Msk = 0x8
	// Bit SLEEPDEEPS.
	SCB_SCR_SLEEPDEEPS = 0x8
	// Position of SEVONPEND field.
	SCB_SCR_SEVONPEND_Pos = 0x4
	// Bit mask of SEVONPEND field.
	SCB_SCR_SEVONPEND_Msk = 0x10
	// Bit SEVONPEND.
	SCB_SCR_SEVONPEND = 0x10
	// Only enabled interrupts or events can wakeup the processor, disabled interrupts are excluded
	SCB_SCR_SEVONPEND_VALUE_0 = 0x0
	// Enabled events and all interrupts, including disabled interrupts, can wakeup the processor
	SCB_SCR_SEVONPEND_VALUE_1 = 0x1

	// CCR: Configuration and Control Register
	// Position of USERSETMPEND field.
	SCB_CCR_USERSETMPEND_Pos = 0x1
	// Bit mask of USERSETMPEND field.
	SCB_CCR_USERSETMPEND_Msk = 0x2
	// Bit USERSETMPEND.
	SCB_CCR_USERSETMPEND = 0x2
	// Position of UNALIGN_TRP field.
	SCB_CCR_UNALIGN_TRP_Pos = 0x3
	// Bit mask of UNALIGN_TRP field.
	SCB_CCR_UNALIGN_TRP_Msk = 0x8
	// Bit UNALIGN_TRP.
	SCB_CCR_UNALIGN_TRP = 0x8
	// Do not trap unaligned halfword and word accesses
	SCB_CCR_UNALIGN_TRP_VALUE_0 = 0x0
	// Trap unaligned halfword and word accesses
	SCB_CCR_UNALIGN_TRP_VALUE_1 = 0x1
	// Position of DIV_0_TRP field.
	SCB_CCR_DIV_0_TRP_Pos = 0x4
	// Bit mask of DIV_0_TRP field.
	SCB_CCR_DIV_0_TRP_Msk = 0x10
	// Bit DIV_0_TRP.
	SCB_CCR_DIV_0_TRP = 0x10
	// Position of BFHFNMIGN field.
	SCB_CCR_BFHFNMIGN_Pos = 0x8
	// Bit mask of BFHFNMIGN field.
	SCB_CCR_BFHFNMIGN_Msk = 0x100
	// Bit BFHFNMIGN.
	SCB_CCR_BFHFNMIGN = 0x100
	// Position of STKOFHFNMIGN field.
	SCB_CCR_STKOFHFNMIGN_Pos = 0xa
	// Bit mask of STKOFHFNMIGN field.
	SCB_CCR_STKOFHFNMIGN_Msk = 0x400
	// Bit STKOFHFNMIGN.
	SCB_CCR_STKOFHFNMIGN = 0x400
	// Position of DC field.
	SCB_CCR_DC_Pos = 0x10
	// Bit mask of DC field.
	SCB_CCR_DC_Msk = 0x10000
	// Bit DC.
	SCB_CCR_DC = 0x10000
	// Position of IC field.
	SCB_CCR_IC_Pos = 0x11
	// Bit mask of IC field.
	SCB_CCR_IC_Msk = 0x20000
	// Bit IC.
	SCB_CCR_IC = 0x20000
	// Position of BP field.
	SCB_CCR_BP_Pos = 0x12
	// Bit mask of BP field.
	SCB_CCR_BP_Msk = 0x40000
	// Bit BP.
	SCB_CCR_BP = 0x40000

	// SHPR2: System Handler Priority Register 2
	// Position of PRI_11 field.
	SCB_SHPR2_PRI_11_Pos = 0x18
	// Bit mask of PRI_11 field.
	SCB_SHPR2_PRI_11_Msk = 0xff000000

	// SHPR3: System Handler Priority Register 3
	// Position of PRI_12 field.
	SCB_SHPR3_PRI_12_Pos = 0x0
	// Bit mask of PRI_12 field.
	SCB_SHPR3_PRI_12_Msk = 0xff
	// Position of PRI_14 field.
	SCB_SHPR3_PRI_14_Pos = 0x10
	// Bit mask of PRI_14 field.
	SCB_SHPR3_PRI_14_Msk = 0xff0000
	// Position of PRI_15 field.
	SCB_SHPR3_PRI_15_Pos = 0x18
	// Bit mask of PRI_15 field.
	SCB_SHPR3_PRI_15_Msk = 0xff000000

	// SHCSR: System Handler Control and State Register
	// Position of HARDFAULTACT field.
	SCB_SHCSR_HARDFAULTACT_Pos = 0x2
	// Bit mask of HARDFAULTACT field.
	SCB_SHCSR_HARDFAULTACT_Msk = 0x4
	// Bit HARDFAULTACT.
	SCB_SHCSR_HARDFAULTACT = 0x4
	// Position of NMIACT field.
	SCB_SHCSR_NMIACT_Pos = 0x5
	// Bit mask of NMIACT field.
	SCB_SHCSR_NMIACT_Msk = 0x20
	// Bit NMIACT.
	SCB_SHCSR_NMIACT = 0x20
	// Position of SVCALLACT field.
	SCB_SHCSR_SVCALLACT_Pos = 0x7
	// Bit mask of SVCALLACT field.
	SCB_SHCSR_SVCALLACT_Msk = 0x80
	// Bit SVCALLACT.
	SCB_SHCSR_SVCALLACT = 0x80
	// Position of PENDSVACT field.
	SCB_SHCSR_PENDSVACT_Pos = 0xa
	// Bit mask of PENDSVACT field.
	SCB_SHCSR_PENDSVACT_Msk = 0x400
	// Bit PENDSVACT.
	SCB_SHCSR_PENDSVACT = 0x400
	// Position of SYSTICKACT field.
	SCB_SHCSR_SYSTICKACT_Pos = 0xb
	// Bit mask of SYSTICKACT field.
	SCB_SHCSR_SYSTICKACT_Msk = 0x800
	// Bit SYSTICKACT.
	SCB_SHCSR_SYSTICKACT = 0x800
	// Position of SVCALLPENDED field.
	SCB_SHCSR_SVCALLPENDED_Pos = 0xf
	// Bit mask of SVCALLPENDED field.
	SCB_SHCSR_SVCALLPENDED_Msk = 0x8000
	// Bit SVCALLPENDED.
	SCB_SHCSR_SVCALLPENDED = 0x8000
	// Position of HARDFAULTPENDED field.
	SCB_SHCSR_HARDFAULTPENDED_Pos = 0x15
	// Bit mask of HARDFAULTPENDED field.
	SCB_SHCSR_HARDFAULTPENDED_Msk = 0x200000
	// Bit HARDFAULTPENDED.
	SCB_SHCSR_HARDFAULTPENDED = 0x200000

	// DFSR: Debug Fault Status Register
	// Position of HALTED field.
	SCB_DFSR_HALTED_Pos = 0x0
	// Bit mask of HALTED field.
	SCB_DFSR_HALTED_Msk = 0x1
	// Bit HALTED.
	SCB_DFSR_HALTED = 0x1
	// Position of BKPT field.
	SCB_DFSR_BKPT_Pos = 0x1
	// Bit mask of BKPT field.
	SCB_DFSR_BKPT_Msk = 0x2
	// Bit BKPT.
	SCB_DFSR_BKPT = 0x2
	// Position of DWTTRAP field.
	SCB_DFSR_DWTTRAP_Pos = 0x2
	// Bit mask of DWTTRAP field.
	SCB_DFSR_DWTTRAP_Msk = 0x4
	// Bit DWTTRAP.
	SCB_DFSR_DWTTRAP = 0x4
	// Position of VCATCH field.
	SCB_DFSR_VCATCH_Pos = 0x3
	// Bit mask of VCATCH field.
	SCB_DFSR_VCATCH_Msk = 0x8
	// Bit VCATCH.
	SCB_DFSR_VCATCH = 0x8
	// Position of EXTERNAL field.
	SCB_DFSR_EXTERNAL_Pos = 0x4
	// Bit mask of EXTERNAL field.
	SCB_DFSR_EXTERNAL_Msk = 0x10
	// Bit EXTERNAL.
	SCB_DFSR_EXTERNAL = 0x10

	// CLIDR: Cache Level ID Register
	// Position of Ctype1 field.
	SCB_CLIDR_Ctype1_Pos = 0x0
	// Bit mask of Ctype1 field.
	SCB_CLIDR_Ctype1_Msk = 0x7
	// No cache
	SCB_CLIDR_Ctype1_NO = 0x0
	// Instruction cache only
	SCB_CLIDR_Ctype1_IC = 0x1
	// Data cache only
	SCB_CLIDR_Ctype1_DC = 0x2
	// Separate instruction and data caches
	SCB_CLIDR_Ctype1_SEPARATE = 0x3
	// Unified cache
	SCB_CLIDR_Ctype1_UNIFIED = 0x4
	// Position of Ctype2 field.
	SCB_CLIDR_Ctype2_Pos = 0x3
	// Bit mask of Ctype2 field.
	SCB_CLIDR_Ctype2_Msk = 0x38
	// No cache
	SCB_CLIDR_Ctype2_NO = 0x0
	// Instruction cache only
	SCB_CLIDR_Ctype2_IC = 0x1
	// Data cache only
	SCB_CLIDR_Ctype2_DC = 0x2
	// Separate instruction and data caches
	SCB_CLIDR_Ctype2_SEPARATE = 0x3
	// Unified cache
	SCB_CLIDR_Ctype2_UNIFIED = 0x4
	// Position of Ctype3 field.
	SCB_CLIDR_Ctype3_Pos = 0x6
	// Bit mask of Ctype3 field.
	SCB_CLIDR_Ctype3_Msk = 0x1c0
	// No cache
	SCB_CLIDR_Ctype3_NO = 0x0
	// Instruction cache only
	SCB_CLIDR_Ctype3_IC = 0x1
	// Data cache only
	SCB_CLIDR_Ctype3_DC = 0x2
	// Separate instruction and data caches
	SCB_CLIDR_Ctype3_SEPARATE = 0x3
	// Unified cache
	SCB_CLIDR_Ctype3_UNIFIED = 0x4
	// Position of Ctype4 field.
	SCB_CLIDR_Ctype4_Pos = 0x9
	// Bit mask of Ctype4 field.
	SCB_CLIDR_Ctype4_Msk = 0xe00
	// No cache
	SCB_CLIDR_Ctype4_NO = 0x0
	// Instruction cache only
	SCB_CLIDR_Ctype4_IC = 0x1
	// Data cache only
	SCB_CLIDR_Ctype4_DC = 0x2
	// Separate instruction and data caches
	SCB_CLIDR_Ctype4_SEPARATE = 0x3
	// Unified cache
	SCB_CLIDR_Ctype4_UNIFIED = 0x4
	// Position of Ctype5 field.
	SCB_CLIDR_Ctype5_Pos = 0xc
	// Bit mask of Ctype5 field.
	SCB_CLIDR_Ctype5_Msk = 0x7000
	// No cache
	SCB_CLIDR_Ctype5_NO = 0x0
	// Instruction cache only
	SCB_CLIDR_Ctype5_IC = 0x1
	// Data cache only
	SCB_CLIDR_Ctype5_DC = 0x2
	// Separate instruction and data caches
	SCB_CLIDR_Ctype5_SEPARATE = 0x3
	// Unified cache
	SCB_CLIDR_Ctype5_UNIFIED = 0x4
	// Position of Ctype6 field.
	SCB_CLIDR_Ctype6_Pos = 0xf
	// Bit mask of Ctype6 field.
	SCB_CLIDR_Ctype6_Msk = 0x38000
	// No cache
	SCB_CLIDR_Ctype6_NO = 0x0
	// Instruction cache only
	SCB_CLIDR_Ctype6_IC = 0x1
	// Data cache only
	SCB_CLIDR_Ctype6_DC = 0x2
	// Separate instruction and data caches
	SCB_CLIDR_Ctype6_SEPARATE = 0x3
	// Unified cache
	SCB_CLIDR_Ctype6_UNIFIED = 0x4
	// Position of Ctype7 field.
	SCB_CLIDR_Ctype7_Pos = 0x12
	// Bit mask of Ctype7 field.
	SCB_CLIDR_Ctype7_Msk = 0x1c0000
	// No cache
	SCB_CLIDR_Ctype7_NO = 0x0
	// Instruction cache only
	SCB_CLIDR_Ctype7_IC = 0x1
	// Data cache only
	SCB_CLIDR_Ctype7_DC = 0x2
	// Separate instruction and data caches
	SCB_CLIDR_Ctype7_SEPARATE = 0x3
	// Unified cache
	SCB_CLIDR_Ctype7_UNIFIED = 0x4
	// Position of LoUIS field.
	SCB_CLIDR_LoUIS_Pos = 0x15
	// Bit mask of LoUIS field.
	SCB_CLIDR_LoUIS_Msk = 0xe00000
	// Position of LoC field.
	SCB_CLIDR_LoC_Pos = 0x18
	// Bit mask of LoC field.
	SCB_CLIDR_LoC_Msk = 0x7000000
	// Position of LoUU field.
	SCB_CLIDR_LoUU_Pos = 0x1b
	// Bit mask of LoUU field.
	SCB_CLIDR_LoUU_Msk = 0x38000000
	// Position of ICB field.
	SCB_CLIDR_ICB_Pos = 0x1e
	// Bit mask of ICB field.
	SCB_CLIDR_ICB_Msk = 0xc0000000
	// Not disclosed in this mechanism
	SCB_CLIDR_ICB_NO = 0x0
	// L1 cache is the highest inner level
	SCB_CLIDR_ICB_L1 = 0x1
	// L2 cache is the highest inner level
	SCB_CLIDR_ICB_L2 = 0x2
	// L3 cache is the highest inner level
	SCB_CLIDR_ICB_L3 = 0x3

	// CTR: Cache Type Register
	// Position of IminLine field.
	SCB_CTR_IminLine_Pos = 0x0
	// Bit mask of IminLine field.
	SCB_CTR_IminLine_Msk = 0xf
	// Position of DminLine field.
	SCB_CTR_DminLine_Pos = 0x10
	// Bit mask of DminLine field.
	SCB_CTR_DminLine_Msk = 0xf0000
	// Position of ERG field.
	SCB_CTR_ERG_Pos = 0x14
	// Bit mask of ERG field.
	SCB_CTR_ERG_Msk = 0xf00000
	// Position of CWG field.
	SCB_CTR_CWG_Pos = 0x18
	// Bit mask of CWG field.
	SCB_CTR_CWG_Msk = 0xf000000
	// Position of Format field.
	SCB_CTR_Format_Pos = 0x1d
	// Bit mask of Format field.
	SCB_CTR_Format_Msk = 0xe0000000
	// No cache type information provided
	SCB_CTR_Format_NO = 0x0
	// Cache type information is provided
	SCB_CTR_Format_YES = 0x4

	// CCSIDR: Current Cache Size ID register
	// Position of LineSize field.
	SCB_CCSIDR_LineSize_Pos = 0x0
	// Bit mask of LineSize field.
	SCB_CCSIDR_LineSize_Msk = 0x7
	// Position of Associativity field.
	SCB_CCSIDR_Associativity_Pos = 0x3
	// Bit mask of Associativity field.
	SCB_CCSIDR_Associativity_Msk = 0x1ff8
	// Position of NumSets field.
	SCB_CCSIDR_NumSets_Pos = 0xd
	// Bit mask of NumSets field.
	SCB_CCSIDR_NumSets_Msk = 0xfffe000
	// Position of WA field.
	SCB_CCSIDR_WA_Pos = 0x1c
	// Bit mask of WA field.
	SCB_CCSIDR_WA_Msk = 0x10000000
	// Bit WA.
	SCB_CCSIDR_WA = 0x10000000
	// Position of RA field.
	SCB_CCSIDR_RA_Pos = 0x1d
	// Bit mask of RA field.
	SCB_CCSIDR_RA_Msk = 0x20000000
	// Bit RA.
	SCB_CCSIDR_RA = 0x20000000
	// Position of WB field.
	SCB_CCSIDR_WB_Pos = 0x1e
	// Bit mask of WB field.
	SCB_CCSIDR_WB_Msk = 0x40000000
	// Bit WB.
	SCB_CCSIDR_WB = 0x40000000
	// Position of WT field.
	SCB_CCSIDR_WT_Pos = 0x1f
	// Bit mask of WT field.
	SCB_CCSIDR_WT_Msk = 0x80000000
	// Bit WT.
	SCB_CCSIDR_WT = 0x80000000

	// CSSELR: Cache Size Selection Register
	// Position of InD field.
	SCB_CSSELR_InD_Pos = 0x0
	// Bit mask of InD field.
	SCB_CSSELR_InD_Msk = 0x1
	// Bit InD.
	SCB_CSSELR_InD = 0x1
	// Position of Level field.
	SCB_CSSELR_Level_Pos = 0x1
	// Bit mask of Level field.
	SCB_CSSELR_Level_Msk = 0xe
)

// Constants for SysTick: SysTick Timer
const (
	// SYST_CSR: SysTick Control and Status Register
	// Position of ENABLE field.
	SysTick_SYST_CSR_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	SysTick_SYST_CSR_ENABLE_Msk = 0x1
	// Bit ENABLE.
	SysTick_SYST_CSR_ENABLE = 0x1
	// Position of TICKINT field.
	SysTick_SYST_CSR_TICKINT_Pos = 0x1
	// Bit mask of TICKINT field.
	SysTick_SYST_CSR_TICKINT_Msk = 0x2
	// Bit TICKINT.
	SysTick_SYST_CSR_TICKINT = 0x2
	// Position of CLKSOURCE field.
	SysTick_SYST_CSR_CLKSOURCE_Pos = 0x2
	// Bit mask of CLKSOURCE field.
	SysTick_SYST_CSR_CLKSOURCE_Msk = 0x4
	// Bit CLKSOURCE.
	SysTick_SYST_CSR_CLKSOURCE = 0x4
	// Position of COUNTFLAG field.
	SysTick_SYST_CSR_COUNTFLAG_Pos = 0x10
	// Bit mask of COUNTFLAG field.
	SysTick_SYST_CSR_COUNTFLAG_Msk = 0x10000
	// Bit COUNTFLAG.
	SysTick_SYST_CSR_COUNTFLAG = 0x10000

	// SYST_RVR: SysTick Reload Value Register
	// Position of RELOAD field.
	SysTick_SYST_RVR_RELOAD_Pos = 0x18
	// Bit mask of RELOAD field.
	SysTick_SYST_RVR_RELOAD_Msk = 0x1000000
	// Bit RELOAD.
	SysTick_SYST_RVR_RELOAD = 0x1000000

	// SYST_CVR: SysTick Current Value Register
	// Position of CURRENT field.
	SysTick_SYST_CVR_CURRENT_Pos = 0x18
	// Bit mask of CURRENT field.
	SysTick_SYST_CVR_CURRENT_Msk = 0x1000000
	// Bit CURRENT.
	SysTick_SYST_CVR_CURRENT = 0x1000000

	// SYST_CALIB: SysTick Calibration Value Register
	// Position of TENMS field.
	SysTick_SYST_CALIB_TENMS_Pos = 0x0
	// Bit mask of TENMS field.
	SysTick_SYST_CALIB_TENMS_Msk = 0xffffff
	// Position of SKEW field.
	SysTick_SYST_CALIB_SKEW_Pos = 0x1e
	// Bit mask of SKEW field.
	SysTick_SYST_CALIB_SKEW_Msk = 0x40000000
	// Bit SKEW.
	SysTick_SYST_CALIB_SKEW = 0x40000000
	// Position of NOREF field.
	SysTick_SYST_CALIB_NOREF_Pos = 0x1f
	// Bit mask of NOREF field.
	SysTick_SYST_CALIB_NOREF_Msk = 0x80000000
	// Bit NOREF.
	SysTick_SYST_CALIB_NOREF = 0x80000000
)
