/* baobab-chart.c generated by valac 0.56.0, the Vala compiler
 * generated from baobab-chart.vala, do not modify */

/* -*- tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/* Baobab - disk usage analyzer
 *
 * Copyright (C) 2006, 2007, 2008  Igalia
 * Copyright (C) 2013  Stefano Facchini <stefano.facchini@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor,
 * Boston, MA  02110-1301  USA
 *
 * Authors of the original code:
 *   Felipe Erias <femorandeira@igalia.com>
 *   Pablo Santamaria <psantamaria@igalia.com>
 *   Jacobo Aragunde <jaragunde@igalia.com>
 *   Eduardo Lima <elima@igalia.com>
 *   Mario Sanchez <msanchez@igalia.com>
 *   Miguel Gomez <magomez@igalia.com>
 *   Henrique Ferreiro <hferreiro@igalia.com>
 *   Alejandro Pinheiro <apinheiro@igalia.com>
 *   Carlos Sanmartin <csanmartin@igalia.com>
 *   Alejandro Garcia <alex@igalia.com>
 */

#include "baobab.h"
#include <gobject/gvaluecollector.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <cairo-gobject.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <glib-object.h>

#define BAOBAB_CHART_NUM_COLORS 6

#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _BaobabParamSpecChartItem BaobabParamSpecChartItem;
enum  {
	BAOBAB_CHART_0_PROPERTY,
	BAOBAB_CHART_LOCATION_PROPERTY,
	BAOBAB_CHART_MAX_DEPTH_PROPERTY,
	BAOBAB_CHART_MODEL_PROPERTY,
	BAOBAB_CHART_TREE_ROOT_PROPERTY,
	BAOBAB_CHART_HIGHLIGHTED_ITEM_PROPERTY,
	BAOBAB_CHART_NUM_PROPERTIES
};
static GParamSpec* baobab_chart_properties[BAOBAB_CHART_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _baobab_location_unref0(var) ((var == NULL) ? NULL : (var = (baobab_location_unref (var), NULL)))
#define __vala_GtkTreeRowReference_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTreeRowReference_free (var), NULL)))
#define _baobab_chart_item_unref0(var) ((var == NULL) ? NULL : (var = (baobab_chart_item_unref (var), NULL)))
#define __vala_GtkTreePath_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTreePath_free (var), NULL)))
enum  {
	BAOBAB_CHART_ITEM_ACTIVATED_SIGNAL,
	BAOBAB_CHART_NUM_SIGNALS
};
static guint baobab_chart_signals[BAOBAB_CHART_NUM_SIGNALS] = {0};

struct _BaobabParamSpecChartItem {
	GParamSpec parent_instance;
};

struct _BaobabChartPrivate {
	gboolean model_changed;
	GtkPopoverMenu* context_menu;
	GtkEventControllerScroll* scroll_controller;
	GtkEventControllerMotion* motion_controller;
	GtkGestureClick* primary_click_gesture;
	GtkGestureClick* secondary_click_gesture;
	GtkGestureClick* middle_click_gesture;
	GList* items;
	BaobabLocation* location_;
	guint max_depth_;
	GtkTreeModel* model_;
	GtkTreeRowReference* root_;
	BaobabChartItem* highlighted_item_;
	GSimpleActionGroup* action_group;
};

static gpointer baobab_chart_item_parent_class = NULL;
static gint BaobabChart_private_offset;
static gpointer baobab_chart_parent_class = NULL;

static void baobab_chart_item_finalize (BaobabChartItem * obj);
static GType baobab_chart_item_get_type_once (void);
static void _baobab_chart_open_file_gsimple_action_activate_callback (GSimpleAction* action,
                                                               GVariant* parameter,
                                                               gpointer self);
static void _baobab_chart_copy_path_gsimple_action_activate_callback (GSimpleAction* action,
                                                               GVariant* parameter,
                                                               gpointer self);
static void _baobab_chart_trash_file_gsimple_action_activate_callback (GSimpleAction* action,
                                                                GVariant* parameter,
                                                                gpointer self);
static void _baobab_chart_move_up_root_gsimple_action_activate_callback (GSimpleAction* action,
                                                                  GVariant* parameter,
                                                                  gpointer self);
static void _baobab_chart_zoom_in_gsimple_action_activate_callback (GSimpleAction* action,
                                                             GVariant* parameter,
                                                             gpointer self);
static void _baobab_chart_zoom_out_gsimple_action_activate_callback (GSimpleAction* action,
                                                              GVariant* parameter,
                                                              gpointer self);
static void _baobab_chart_item_unref0_ (gpointer var);
static inline void _g_list_free__baobab_chart_item_unref0_ (GList* self);
static void _vala_GtkTreeRowReference_free (GtkTreeRowReference* self);
static void baobab_chart_real_post_draw (BaobabChart* self,
                                  cairo_t* cr);
static void baobab_chart_real_draw_item (BaobabChart* self,
                                  cairo_t* cr,
                                  BaobabChartItem* item,
                                  gboolean highlighted);
static void baobab_chart_real_calculate_item_geometry (BaobabChart* self,
                                                BaobabChartItem* item);
static gboolean baobab_chart_real_is_point_over_item (BaobabChart* self,
                                               BaobabChartItem* item,
                                               gdouble x,
                                               gdouble y);
static void baobab_chart_real_get_item_rectangle (BaobabChart* self,
                                           BaobabChartItem* item);
static gboolean baobab_chart_real_can_zoom_in (BaobabChart* self);
static gboolean baobab_chart_real_can_zoom_out (BaobabChart* self);
static BaobabChartItem* baobab_chart_real_create_new_chartitem (BaobabChart* self);
static void baobab_chart_real_size_allocate (GtkWidget* base,
                                      gint width,
                                      gint height,
                                      gint baseline);
static gboolean baobab_chart_highlight_item_at_point (BaobabChart* self,
                                               gdouble x,
                                               gdouble y);
static void baobab_chart_motion_cb (BaobabChart* self,
                             gdouble x,
                             gdouble y);
static void baobab_chart_leave_cb (BaobabChart* self);
static GList* baobab_chart_add_item (BaobabChart* self,
                              guint depth,
                              gdouble rel_start,
                              gdouble rel_size,
                              GtkTreeIter* iter);
static void baobab_chart_get_items (BaobabChart* self,
                             GtkTreePath* root_path);
static void _vala_GtkTreePath_free (GtkTreePath* self);
static void baobab_chart_draw_chart (BaobabChart* self,
                              cairo_t* cr);
static void baobab_chart_update_draw (BaobabChart* self,
                               GtkTreePath* path);
static void baobab_chart_row_changed (BaobabChart* self,
                               GtkTreeModel* model,
                               GtkTreePath* path,
                               GtkTreeIter* iter);
static void baobab_chart_row_inserted (BaobabChart* self,
                                GtkTreeModel* model,
                                GtkTreePath* path,
                                GtkTreeIter* iter);
static void baobab_chart_row_deleted (BaobabChart* self,
                               GtkTreeModel* model,
                               GtkTreePath* path);
static void baobab_chart_row_has_child_toggled (BaobabChart* self,
                                         GtkTreeModel* model,
                                         GtkTreePath* path,
                                         GtkTreeIter* iter);
static void baobab_chart_rows_reordered (BaobabChart* self,
                                  GtkTreeModel* model,
                                  GtkTreePath* path,
                                  GtkTreeIter* iter,
                                  void* new_order);
static void baobab_chart_draw_func (BaobabChart* self,
                             GtkDrawingArea* da,
                             cairo_t* cr,
                             gint width,
                             gint height);
static void baobab_chart_interpolate_colors (BaobabChart* self,
                                      GdkRGBA* colora,
                                      GdkRGBA* colorb,
                                      gfloat percentage,
                                      GdkRGBA* result);
static gboolean baobab_chart_scroll_cb (BaobabChart* self,
                                 gdouble dx,
                                 gdouble dy);
static void baobab_chart_build_context_menu (BaobabChart* self);
static void baobab_chart_show_popover_at (BaobabChart* self,
                                   gint x,
                                   gint y);
static void baobab_chart_connect_model_signals (BaobabChart* self,
                                         GtkTreeModel* m);
static void _baobab_chart_row_changed_gtk_tree_model_row_changed (GtkTreeModel* _sender,
                                                           GtkTreePath* path,
                                                           GtkTreeIter* iter,
                                                           gpointer self);
static void _baobab_chart_row_inserted_gtk_tree_model_row_inserted (GtkTreeModel* _sender,
                                                             GtkTreePath* path,
                                                             GtkTreeIter* iter,
                                                             gpointer self);
static void _baobab_chart_row_has_child_toggled_gtk_tree_model_row_has_child_toggled (GtkTreeModel* _sender,
                                                                               GtkTreePath* path,
                                                                               GtkTreeIter* iter,
                                                                               gpointer self);
static void _baobab_chart_row_deleted_gtk_tree_model_row_deleted (GtkTreeModel* _sender,
                                                           GtkTreePath* path,
                                                           gpointer self);
static void _baobab_chart_rows_reordered_gtk_tree_model_rows_reordered (GtkTreeModel* _sender,
                                                                 GtkTreePath* path,
                                                                 GtkTreeIter* iter,
                                                                 gint* new_order,
                                                                 gpointer self);
static void baobab_chart_disconnect_model_signals (BaobabChart* self,
                                            GtkTreeModel* m);
static gboolean baobab_chart_real_query_tooltip (GtkWidget* base,
                                          gint x,
                                          gint y,
                                          gboolean keyboard_tooltip,
                                          GtkTooltip* tooltip);
static GtkTreeRowReference* _vala_GtkTreeRowReference_copy (GtkTreeRowReference* self);
static GObject * baobab_chart_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties);
static gboolean _baobab_chart_scroll_cb_gtk_event_controller_scroll_scroll (GtkEventControllerScroll* _sender,
                                                                     gdouble dx,
                                                                     gdouble dy,
                                                                     gpointer self);
static void _baobab_chart_motion_cb_gtk_event_controller_motion_motion (GtkEventControllerMotion* _sender,
                                                                 gdouble x,
                                                                 gdouble y,
                                                                 gpointer self);
static void _baobab_chart_leave_cb_gtk_event_controller_motion_leave (GtkEventControllerMotion* _sender,
                                                               gpointer self);
static void _baobab_chart___lambda13_ (BaobabChart* self,
                                gint _,
                                gdouble x,
                                gdouble y);
static void __baobab_chart___lambda13__gtk_gesture_click_pressed (GtkGestureClick* _sender,
                                                           gint n_press,
                                                           gdouble x,
                                                           gdouble y,
                                                           gpointer self);
static void _baobab_chart___lambda14_ (BaobabChart* self,
                                gint _,
                                gdouble x,
                                gdouble y);
static void __baobab_chart___lambda14__gtk_gesture_click_pressed (GtkGestureClick* _sender,
                                                           gint n_press,
                                                           gdouble x,
                                                           gdouble y,
                                                           gpointer self);
static void _baobab_chart___lambda15_ (BaobabChart* self,
                                gint _,
                                gdouble x,
                                gdouble y);
static void __baobab_chart___lambda15__gtk_gesture_click_pressed (GtkGestureClick* _sender,
                                                           gint n_press,
                                                           gdouble x,
                                                           gdouble y,
                                                           gpointer self);
static void _baobab_chart_draw_func_gtk_drawing_area_draw_func (GtkDrawingArea* drawing_area,
                                                         cairo_t* cr,
                                                         gint width,
                                                         gint height,
                                                         gpointer self);
static void baobab_chart_finalize (GObject * obj);
static GType baobab_chart_get_type_once (void);
static void _vala_baobab_chart_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec);
static void _vala_baobab_chart_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec);

static const GActionEntry BAOBAB_CHART_action_entries[6] = {{"open-file", _baobab_chart_open_file_gsimple_action_activate_callback}, {"copy-path", _baobab_chart_copy_path_gsimple_action_activate_callback}, {"trash-file", _baobab_chart_trash_file_gsimple_action_activate_callback}, {"move-up", _baobab_chart_move_up_root_gsimple_action_activate_callback}, {"zoom-in", _baobab_chart_zoom_in_gsimple_action_activate_callback}, {"zoom-out", _baobab_chart_zoom_out_gsimple_action_activate_callback}};

BaobabChartItem*
baobab_chart_item_construct (GType object_type)
{
	BaobabChartItem* self = NULL;
	self = (BaobabChartItem*) g_type_create_instance (object_type);
	return self;
}

static void
baobab_value_chart_item_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
baobab_value_chart_item_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		baobab_chart_item_unref (value->data[0].v_pointer);
	}
}

static void
baobab_value_chart_item_copy_value (const GValue* src_value,
                                    GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = baobab_chart_item_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
baobab_value_chart_item_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
baobab_value_chart_item_collect_value (GValue* value,
                                       guint n_collect_values,
                                       GTypeCValue* collect_values,
                                       guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		BaobabChartItem * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = baobab_chart_item_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
baobab_value_chart_item_lcopy_value (const GValue* value,
                                     guint n_collect_values,
                                     GTypeCValue* collect_values,
                                     guint collect_flags)
{
	BaobabChartItem ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = baobab_chart_item_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
baobab_param_spec_chart_item (const gchar* name,
                              const gchar* nick,
                              const gchar* blurb,
                              GType object_type,
                              GParamFlags flags)
{
	BaobabParamSpecChartItem* spec;
	g_return_val_if_fail (g_type_is_a (object_type, BAOBAB_TYPE_CHART_ITEM), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
baobab_value_get_chart_item (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BAOBAB_TYPE_CHART_ITEM), NULL);
	return value->data[0].v_pointer;
}

void
baobab_value_set_chart_item (GValue* value,
                             gpointer v_object)
{
	BaobabChartItem * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BAOBAB_TYPE_CHART_ITEM));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BAOBAB_TYPE_CHART_ITEM));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		baobab_chart_item_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		baobab_chart_item_unref (old);
	}
}

void
baobab_value_take_chart_item (GValue* value,
                              gpointer v_object)
{
	BaobabChartItem * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BAOBAB_TYPE_CHART_ITEM));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BAOBAB_TYPE_CHART_ITEM));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		baobab_chart_item_unref (old);
	}
}

static void
baobab_chart_item_class_init (BaobabChartItemClass * klass,
                              gpointer klass_data)
{
	baobab_chart_item_parent_class = g_type_class_peek_parent (klass);
	((BaobabChartItemClass *) klass)->finalize = baobab_chart_item_finalize;
}

static void
baobab_chart_item_instance_init (BaobabChartItem * self,
                                 gpointer klass)
{
	self->ref_count = 1;
}

static void
baobab_chart_item_finalize (BaobabChartItem * obj)
{
	BaobabChartItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BAOBAB_TYPE_CHART_ITEM, BaobabChartItem);
	g_signal_handlers_destroy (self);
	_g_free0 (self->name);
	_g_free0 (self->size);
}

static GType
baobab_chart_item_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { baobab_value_chart_item_init, baobab_value_chart_item_free_value, baobab_value_chart_item_copy_value, baobab_value_chart_item_peek_pointer, "p", baobab_value_chart_item_collect_value, "p", baobab_value_chart_item_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (BaobabChartItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) baobab_chart_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BaobabChartItem), 0, (GInstanceInitFunc) baobab_chart_item_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType baobab_chart_item_type_id;
	baobab_chart_item_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BaobabChartItem", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
	return baobab_chart_item_type_id;
}

GType
baobab_chart_item_get_type (void)
{
	static volatile gsize baobab_chart_item_type_id__once = 0;
	if (g_once_init_enter (&baobab_chart_item_type_id__once)) {
		GType baobab_chart_item_type_id;
		baobab_chart_item_type_id = baobab_chart_item_get_type_once ();
		g_once_init_leave (&baobab_chart_item_type_id__once, baobab_chart_item_type_id);
	}
	return baobab_chart_item_type_id__once;
}

gpointer
baobab_chart_item_ref (gpointer instance)
{
	BaobabChartItem * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
baobab_chart_item_unref (gpointer instance)
{
	BaobabChartItem * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		BAOBAB_CHART_ITEM_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
baobab_chart_get_instance_private (BaobabChart* self)
{
	return G_STRUCT_MEMBER_P (self, BaobabChart_private_offset);
}

static void
_baobab_chart_open_file_gsimple_action_activate_callback (GSimpleAction* action,
                                                          GVariant* parameter,
                                                          gpointer self)
{
	baobab_chart_open_file ((BaobabChart*) self);
}

static void
_baobab_chart_copy_path_gsimple_action_activate_callback (GSimpleAction* action,
                                                          GVariant* parameter,
                                                          gpointer self)
{
	baobab_chart_copy_path ((BaobabChart*) self);
}

static void
_baobab_chart_trash_file_gsimple_action_activate_callback (GSimpleAction* action,
                                                           GVariant* parameter,
                                                           gpointer self)
{
	baobab_chart_trash_file ((BaobabChart*) self);
}

static void
_baobab_chart_move_up_root_gsimple_action_activate_callback (GSimpleAction* action,
                                                             GVariant* parameter,
                                                             gpointer self)
{
	baobab_chart_move_up_root ((BaobabChart*) self);
}

static void
_baobab_chart_zoom_in_gsimple_action_activate_callback (GSimpleAction* action,
                                                        GVariant* parameter,
                                                        gpointer self)
{
	baobab_chart_zoom_in ((BaobabChart*) self);
}

static void
_baobab_chart_zoom_out_gsimple_action_activate_callback (GSimpleAction* action,
                                                         GVariant* parameter,
                                                         gpointer self)
{
	baobab_chart_zoom_out ((BaobabChart*) self);
}

static void
_baobab_chart_item_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (baobab_chart_item_unref (var), NULL));
}

static inline void
_g_list_free__baobab_chart_item_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _baobab_chart_item_unref0_);
}

static void
_vala_GtkTreeRowReference_free (GtkTreeRowReference* self)
{
	g_boxed_free (gtk_tree_row_reference_get_type (), self);
}

static void
baobab_chart_real_post_draw (BaobabChart* self,
                             cairo_t* cr)
{
	g_return_if_fail (cr != NULL);
}

void
baobab_chart_post_draw (BaobabChart* self,
                        cairo_t* cr)
{
	BaobabChartClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = BAOBAB_CHART_GET_CLASS (self);
	if (_klass_->post_draw) {
		_klass_->post_draw (self, cr);
	}
}

static void
baobab_chart_real_draw_item (BaobabChart* self,
                             cairo_t* cr,
                             BaobabChartItem* item,
                             gboolean highlighted)
{
	g_critical ("Type `%s' does not implement abstract method `baobab_chart_draw_item'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
baobab_chart_draw_item (BaobabChart* self,
                        cairo_t* cr,
                        BaobabChartItem* item,
                        gboolean highlighted)
{
	BaobabChartClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = BAOBAB_CHART_GET_CLASS (self);
	if (_klass_->draw_item) {
		_klass_->draw_item (self, cr, item, highlighted);
	}
}

static void
baobab_chart_real_calculate_item_geometry (BaobabChart* self,
                                           BaobabChartItem* item)
{
	g_critical ("Type `%s' does not implement abstract method `baobab_chart_calculate_item_geometry'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
baobab_chart_calculate_item_geometry (BaobabChart* self,
                                      BaobabChartItem* item)
{
	BaobabChartClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = BAOBAB_CHART_GET_CLASS (self);
	if (_klass_->calculate_item_geometry) {
		_klass_->calculate_item_geometry (self, item);
	}
}

static gboolean
baobab_chart_real_is_point_over_item (BaobabChart* self,
                                      BaobabChartItem* item,
                                      gdouble x,
                                      gdouble y)
{
	gboolean _tmp0_ = FALSE;
	g_critical ("Type `%s' does not implement abstract method `baobab_chart_is_point_over_item'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}

gboolean
baobab_chart_is_point_over_item (BaobabChart* self,
                                 BaobabChartItem* item,
                                 gdouble x,
                                 gdouble y)
{
	BaobabChartClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = BAOBAB_CHART_GET_CLASS (self);
	if (_klass_->is_point_over_item) {
		return _klass_->is_point_over_item (self, item, x, y);
	}
	return FALSE;
}

static void
baobab_chart_real_get_item_rectangle (BaobabChart* self,
                                      BaobabChartItem* item)
{
	g_critical ("Type `%s' does not implement abstract method `baobab_chart_get_item_rectangle'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
baobab_chart_get_item_rectangle (BaobabChart* self,
                                 BaobabChartItem* item)
{
	BaobabChartClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = BAOBAB_CHART_GET_CLASS (self);
	if (_klass_->get_item_rectangle) {
		_klass_->get_item_rectangle (self, item);
	}
}

static gboolean
baobab_chart_real_can_zoom_in (BaobabChart* self)
{
	gboolean _tmp0_ = FALSE;
	g_critical ("Type `%s' does not implement abstract method `baobab_chart_can_zoom_in'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}

gboolean
baobab_chart_can_zoom_in (BaobabChart* self)
{
	BaobabChartClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = BAOBAB_CHART_GET_CLASS (self);
	if (_klass_->can_zoom_in) {
		return _klass_->can_zoom_in (self);
	}
	return FALSE;
}

static gboolean
baobab_chart_real_can_zoom_out (BaobabChart* self)
{
	gboolean _tmp0_ = FALSE;
	g_critical ("Type `%s' does not implement abstract method `baobab_chart_can_zoom_out'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}

gboolean
baobab_chart_can_zoom_out (BaobabChart* self)
{
	BaobabChartClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = BAOBAB_CHART_GET_CLASS (self);
	if (_klass_->can_zoom_out) {
		return _klass_->can_zoom_out (self);
	}
	return FALSE;
}

static BaobabChartItem*
baobab_chart_real_create_new_chartitem (BaobabChart* self)
{
	g_critical ("Type `%s' does not implement abstract method `baobab_chart_create_new_chartitem'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

BaobabChartItem*
baobab_chart_create_new_chartitem (BaobabChart* self)
{
	BaobabChartClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = BAOBAB_CHART_GET_CLASS (self);
	if (_klass_->create_new_chartitem) {
		return _klass_->create_new_chartitem (self);
	}
	return NULL;
}

static gpointer
_baobab_chart_item_ref0 (gpointer self)
{
	return self ? baobab_chart_item_ref (self) : NULL;
}

static void
baobab_chart_real_size_allocate (GtkWidget* base,
                                 gint width,
                                 gint height,
                                 gint baseline)
{
	BaobabChart * self;
	GList* _tmp0_;
	self = (BaobabChart*) base;
	GTK_WIDGET_CLASS (baobab_chart_parent_class)->size_allocate ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_drawing_area_get_type (), GtkDrawingArea), width, height, baseline);
	_tmp0_ = self->priv->items;
	{
		GList* item_collection = NULL;
		GList* item_it = NULL;
		item_collection = _tmp0_;
		for (item_it = item_collection; item_it != NULL; item_it = item_it->next) {
			BaobabChartItem* _tmp1_;
			BaobabChartItem* item = NULL;
			_tmp1_ = _baobab_chart_item_ref0 ((BaobabChartItem*) item_it->data);
			item = _tmp1_;
			{
				BaobabChartItem* _tmp2_;
				BaobabChartItem* _tmp3_;
				BaobabChartItem* _tmp4_;
				_tmp2_ = item;
				_tmp2_->has_visible_children = FALSE;
				_tmp3_ = item;
				_tmp3_->visible = FALSE;
				_tmp4_ = item;
				baobab_chart_calculate_item_geometry (self, _tmp4_);
				_baobab_chart_item_unref0 (item);
			}
		}
	}
}

static gboolean
baobab_chart_highlight_item_at_point (BaobabChart* self,
                                      gdouble x,
                                      gdouble y)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		GList* node = NULL;
		GList* _tmp0_;
		GList* _tmp1_;
		_tmp0_ = self->priv->items;
		_tmp1_ = g_list_last (_tmp0_);
		node = _tmp1_;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				GList* _tmp5_;
				BaobabChartItem* item = NULL;
				GList* _tmp6_;
				gconstpointer _tmp7_;
				BaobabChartItem* _tmp8_;
				gboolean _tmp9_ = FALSE;
				BaobabChartItem* _tmp10_;
				if (!_tmp2_) {
					GList* _tmp3_;
					GList* _tmp4_;
					_tmp3_ = node;
					_tmp4_ = _tmp3_->prev;
					node = _tmp4_;
				}
				_tmp2_ = FALSE;
				_tmp5_ = node;
				if (!(_tmp5_ != NULL)) {
					break;
				}
				_tmp6_ = node;
				_tmp7_ = _tmp6_->data;
				_tmp8_ = _baobab_chart_item_ref0 ((BaobabChartItem*) _tmp7_);
				item = _tmp8_;
				_tmp10_ = item;
				if (_tmp10_->visible) {
					BaobabChartItem* _tmp11_;
					_tmp11_ = item;
					_tmp9_ = baobab_chart_is_point_over_item (self, _tmp11_, x, y);
				} else {
					_tmp9_ = FALSE;
				}
				if (_tmp9_) {
					BaobabChartItem* _tmp12_;
					_tmp12_ = item;
					baobab_chart_set_highlighted_item (self, _tmp12_);
					result = TRUE;
					_baobab_chart_item_unref0 (item);
					return result;
				}
				_baobab_chart_item_unref0 (item);
			}
		}
	}
	baobab_chart_set_highlighted_item (self, NULL);
	result = FALSE;
	return result;
}

static void
baobab_chart_motion_cb (BaobabChart* self,
                        gdouble x,
                        gdouble y)
{
	g_return_if_fail (self != NULL);
	gtk_widget_set_has_tooltip ((GtkWidget*) self, baobab_chart_highlight_item_at_point (self, x, y));
}

static void
baobab_chart_leave_cb (BaobabChart* self)
{
	GtkPopoverMenu* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->context_menu;
	_tmp1_ = gtk_widget_get_visible ((GtkWidget*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		baobab_chart_set_highlighted_item (self, NULL);
	}
}

static GList*
baobab_chart_add_item (BaobabChart* self,
                       guint depth,
                       gdouble rel_start,
                       gdouble rel_size,
                       GtkTreeIter* iter)
{
	gchar* name = NULL;
	gchar* display_name = NULL;
	guint64 size = 0ULL;
	GtkTreeModel* _tmp0_;
	GtkTreeModel* _tmp1_;
	GtkTreeIter _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	guint64 _tmp5_ = 0ULL;
	BaobabChartItem* item = NULL;
	BaobabChartItem* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GtkTreeIter _tmp9_;
	BaobabChartItem* _tmp10_;
	GList* ret = NULL;
	GList* _tmp11_;
	GList* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (iter != NULL, NULL);
	_tmp0_ = baobab_chart_get_model (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = *iter;
	gtk_tree_model_get (_tmp1_, &_tmp2_, BAOBAB_SCANNER_COLUMNS_NAME, &_tmp3_, BAOBAB_SCANNER_COLUMNS_DISPLAY_NAME, &_tmp4_, BAOBAB_SCANNER_COLUMNS_SIZE, &_tmp5_, -1);
	_g_free0 (name);
	name = _tmp3_;
	_g_free0 (display_name);
	display_name = _tmp4_;
	size = _tmp5_;
	_tmp6_ = baobab_chart_create_new_chartitem (self);
	item = _tmp6_;
	_tmp7_ = baobab_format_name (display_name, name);
	_g_free0 (item->name);
	item->name = _tmp7_;
	_tmp8_ = g_format_size_full (size, G_FORMAT_SIZE_DEFAULT);
	_g_free0 (item->size);
	item->size = _tmp8_;
	item->depth = depth;
	item->rel_start = rel_start;
	item->rel_size = rel_size;
	item->has_any_child = FALSE;
	item->visible = FALSE;
	item->has_visible_children = FALSE;
	_tmp9_ = *iter;
	item->iter = _tmp9_;
	item->parent = NULL;
	_tmp10_ = _baobab_chart_item_ref0 (item);
	self->priv->items = g_list_prepend (self->priv->items, _tmp10_);
	_tmp11_ = self->priv->items;
	ret = _tmp11_;
	result = ret;
	_baobab_chart_item_unref0 (item);
	_g_free0 (display_name);
	_g_free0 (name);
	return result;
}

static void
_vala_GtkTreePath_free (GtkTreePath* self)
{
	g_boxed_free (gtk_tree_path_get_type (), self);
}

static void
baobab_chart_get_items (BaobabChart* self,
                        GtkTreePath* root_path)
{
	GList* node = NULL;
	GtkTreeIter initial_iter = {0};
	GtkTreeIter _tmp0_ = {0};
	gdouble percent = 0.0;
	GtkTreePath* model_root_path = NULL;
	GtkTreeIter model_root_iter = {0};
	GtkTreeIter child_iter = {0};
	GtkTreeIter _tmp1_ = {0};
	GList* child_node = NULL;
	gdouble rel_start = 0.0;
	GtkTreeModel* _tmp2_;
	GtkTreeModel* _tmp3_;
	GtkTreeIter _tmp4_ = {0};
	gboolean _tmp5_;
	GtkTreePath* _tmp6_;
	GtkTreeModel* _tmp7_;
	GtkTreeModel* _tmp8_;
	GtkTreePath* _tmp9_;
	GtkTreeIter _tmp10_ = {0};
	GtkTreeModel* _tmp11_;
	GtkTreeModel* _tmp12_;
	GtkTreeIter _tmp13_;
	gdouble _tmp14_ = 0.0;
	GtkTreeIter _tmp15_;
	GList* _tmp16_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (root_path != NULL);
	node = NULL;
	_tmp0_.stamp = 0;
	initial_iter = _tmp0_;
	_tmp1_.stamp = 0;
	child_iter = _tmp1_;
	(self->priv->items == NULL) ? NULL : (self->priv->items = (_g_list_free__baobab_chart_item_unref0_ (self->priv->items), NULL));
	self->priv->items = NULL;
	_tmp2_ = baobab_chart_get_model (self);
	_tmp3_ = _tmp2_;
	_tmp5_ = gtk_tree_model_get_iter (_tmp3_, &_tmp4_, root_path);
	initial_iter = _tmp4_;
	if (!_tmp5_) {
		self->priv->model_changed = FALSE;
		__vala_GtkTreePath_free0 (model_root_path);
		return;
	}
	_tmp6_ = gtk_tree_path_new_first ();
	__vala_GtkTreePath_free0 (model_root_path);
	model_root_path = _tmp6_;
	_tmp7_ = baobab_chart_get_model (self);
	_tmp8_ = _tmp7_;
	_tmp9_ = model_root_path;
	gtk_tree_model_get_iter (_tmp8_, &_tmp10_, _tmp9_);
	model_root_iter = _tmp10_;
	_tmp11_ = baobab_chart_get_model (self);
	_tmp12_ = _tmp11_;
	_tmp13_ = model_root_iter;
	gtk_tree_model_get (_tmp12_, &_tmp13_, BAOBAB_SCANNER_COLUMNS_PERCENT, &_tmp14_, -1);
	percent = _tmp14_;
	_tmp15_ = initial_iter;
	_tmp16_ = baobab_chart_add_item (self, (guint) 0, (gdouble) 0, (gdouble) 100, &_tmp15_);
	node = _tmp16_;
	{
		gboolean _tmp17_ = FALSE;
		_tmp17_ = TRUE;
		while (TRUE) {
			BaobabChartItem* item = NULL;
			GList* _tmp19_;
			gconstpointer _tmp20_;
			BaobabChartItem* _tmp21_;
			BaobabChartItem* _tmp22_;
			GtkTreeModel* _tmp23_;
			GtkTreeModel* _tmp24_;
			BaobabChartItem* _tmp25_;
			GtkTreeIter _tmp26_;
			GtkTreeIter _tmp27_ = {0};
			gboolean _tmp28_;
			BaobabChartItem* _tmp29_;
			BaobabChartItem* _tmp30_;
			gboolean _tmp33_ = FALSE;
			BaobabChartItem* _tmp34_;
			GList* _tmp54_;
			GList* _tmp55_;
			if (!_tmp17_) {
				GList* _tmp18_;
				_tmp18_ = node;
				if (!(_tmp18_ != NULL)) {
					break;
				}
			}
			_tmp17_ = FALSE;
			_tmp19_ = node;
			_tmp20_ = _tmp19_->data;
			_tmp21_ = _baobab_chart_item_ref0 ((BaobabChartItem*) _tmp20_);
			item = _tmp21_;
			_tmp22_ = item;
			_tmp23_ = baobab_chart_get_model (self);
			_tmp24_ = _tmp23_;
			_tmp25_ = item;
			_tmp26_ = _tmp25_->iter;
			_tmp28_ = gtk_tree_model_iter_children (_tmp24_, &_tmp27_, &_tmp26_);
			child_iter = _tmp27_;
			_tmp22_->has_any_child = _tmp28_;
			_tmp29_ = item;
			baobab_chart_calculate_item_geometry (self, _tmp29_);
			_tmp30_ = item;
			if (!_tmp30_->visible) {
				GList* _tmp31_;
				GList* _tmp32_;
				_tmp31_ = node;
				_tmp32_ = _tmp31_->prev;
				node = _tmp32_;
				_baobab_chart_item_unref0 (item);
				continue;
			}
			_tmp34_ = item;
			if (_tmp34_->has_any_child) {
				BaobabChartItem* _tmp35_;
				guint _tmp36_;
				guint _tmp37_;
				_tmp35_ = item;
				_tmp36_ = baobab_chart_get_max_depth (self);
				_tmp37_ = _tmp36_;
				_tmp33_ = _tmp35_->depth < (_tmp37_ + 1);
			} else {
				_tmp33_ = FALSE;
			}
			if (_tmp33_) {
				rel_start = (gdouble) 0;
				{
					gboolean _tmp38_ = FALSE;
					_tmp38_ = TRUE;
					while (TRUE) {
						GtkTreeModel* _tmp42_;
						GtkTreeModel* _tmp43_;
						GtkTreeIter _tmp44_;
						gdouble _tmp45_ = 0.0;
						BaobabChartItem* _tmp46_;
						GtkTreeIter _tmp47_;
						GList* _tmp48_;
						BaobabChartItem* child = NULL;
						GList* _tmp49_;
						gconstpointer _tmp50_;
						BaobabChartItem* _tmp51_;
						BaobabChartItem* _tmp52_;
						GList* _tmp53_;
						if (!_tmp38_) {
							GtkTreeModel* _tmp39_;
							GtkTreeModel* _tmp40_;
							gboolean _tmp41_;
							_tmp39_ = baobab_chart_get_model (self);
							_tmp40_ = _tmp39_;
							_tmp41_ = gtk_tree_model_iter_next (_tmp40_, &child_iter);
							if (!_tmp41_) {
								break;
							}
						}
						_tmp38_ = FALSE;
						_tmp42_ = baobab_chart_get_model (self);
						_tmp43_ = _tmp42_;
						_tmp44_ = child_iter;
						gtk_tree_model_get (_tmp43_, &_tmp44_, BAOBAB_SCANNER_COLUMNS_PERCENT, &_tmp45_, -1);
						percent = _tmp45_;
						_tmp46_ = item;
						_tmp47_ = child_iter;
						_tmp48_ = baobab_chart_add_item (self, _tmp46_->depth + 1, rel_start, percent, &_tmp47_);
						child_node = _tmp48_;
						_tmp49_ = child_node;
						_tmp50_ = _tmp49_->data;
						_tmp51_ = _baobab_chart_item_ref0 ((BaobabChartItem*) _tmp50_);
						child = _tmp51_;
						_tmp52_ = child;
						_tmp53_ = node;
						_tmp52_->parent = _tmp53_;
						rel_start += percent;
						_baobab_chart_item_unref0 (child);
					}
				}
			}
			_tmp54_ = node;
			_tmp55_ = _tmp54_->prev;
			node = _tmp55_;
			_baobab_chart_item_unref0 (item);
		}
	}
	self->priv->items = g_list_reverse (self->priv->items);
	self->priv->model_changed = FALSE;
	__vala_GtkTreePath_free0 (model_root_path);
}

static void
baobab_chart_draw_chart (BaobabChart* self,
                         cairo_t* cr)
{
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	cairo_save (cr);
	_tmp0_ = self->priv->items;
	{
		GList* item_collection = NULL;
		GList* item_it = NULL;
		item_collection = _tmp0_;
		for (item_it = item_collection; item_it != NULL; item_it = item_it->next) {
			BaobabChartItem* _tmp1_;
			BaobabChartItem* item = NULL;
			_tmp1_ = _baobab_chart_item_ref0 ((BaobabChartItem*) item_it->data);
			item = _tmp1_;
			{
				gboolean _tmp2_ = FALSE;
				BaobabChartItem* _tmp3_;
				_tmp3_ = item;
				if (_tmp3_->visible) {
					BaobabChartItem* _tmp4_;
					guint _tmp5_;
					guint _tmp6_;
					_tmp4_ = item;
					_tmp5_ = baobab_chart_get_max_depth (self);
					_tmp6_ = _tmp5_;
					_tmp2_ = _tmp4_->depth <= _tmp6_;
				} else {
					_tmp2_ = FALSE;
				}
				if (_tmp2_) {
					gboolean highlighted = FALSE;
					BaobabChartItem* _tmp7_;
					BaobabChartItem* _tmp8_;
					BaobabChartItem* _tmp9_;
					BaobabChartItem* _tmp10_;
					_tmp7_ = item;
					_tmp8_ = baobab_chart_get_highlighted_item (self);
					_tmp9_ = _tmp8_;
					highlighted = _tmp7_ == _tmp9_;
					_tmp10_ = item;
					baobab_chart_draw_item (self, cr, _tmp10_, highlighted);
				}
				_baobab_chart_item_unref0 (item);
			}
		}
	}
	cairo_restore (cr);
	baobab_chart_post_draw (self, cr);
}

static void
baobab_chart_update_draw (BaobabChart* self,
                          GtkTreePath* path)
{
	gint root_depth = 0;
	GtkTreePath* _tmp0_;
	GtkTreePath* _tmp1_;
	GtkTreePath* _tmp2_;
	gint _tmp3_;
	gint node_depth = 0;
	gboolean _tmp4_ = FALSE;
	guint _tmp5_;
	guint _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	if (!gtk_widget_get_realized ((GtkWidget*) self)) {
		return;
	}
	_tmp0_ = baobab_chart_get_tree_root (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = gtk_tree_path_get_depth (_tmp2_);
	__vala_GtkTreePath_free0 (_tmp2_);
	root_depth = _tmp3_;
	node_depth = gtk_tree_path_get_depth (path);
	_tmp5_ = baobab_chart_get_max_depth (self);
	_tmp6_ = _tmp5_;
	if (((guint) (node_depth - root_depth)) <= _tmp6_) {
		gboolean _tmp7_ = FALSE;
		GtkTreePath* _tmp8_;
		GtkTreePath* _tmp9_;
		GtkTreePath* _tmp10_;
		gboolean _tmp11_;
		_tmp8_ = baobab_chart_get_tree_root (self);
		_tmp9_ = _tmp8_;
		_tmp10_ = _tmp9_;
		_tmp11_ = gtk_tree_path_is_ancestor (_tmp10_, path);
		__vala_GtkTreePath_free0 (_tmp10_);
		if (_tmp11_) {
			_tmp7_ = TRUE;
		} else {
			GtkTreePath* _tmp12_;
			GtkTreePath* _tmp13_;
			GtkTreePath* _tmp14_;
			_tmp12_ = baobab_chart_get_tree_root (self);
			_tmp13_ = _tmp12_;
			_tmp14_ = _tmp13_;
			_tmp7_ = gtk_tree_path_compare (_tmp14_, path) == 0;
			__vala_GtkTreePath_free0 (_tmp14_);
		}
		_tmp4_ = _tmp7_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		gtk_widget_queue_draw ((GtkWidget*) self);
	}
}

static void
baobab_chart_row_changed (BaobabChart* self,
                          GtkTreeModel* model,
                          GtkTreePath* path,
                          GtkTreeIter* iter)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (model != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (iter != NULL);
	self->priv->model_changed = TRUE;
	baobab_chart_update_draw (self, path);
}

static void
baobab_chart_row_inserted (BaobabChart* self,
                           GtkTreeModel* model,
                           GtkTreePath* path,
                           GtkTreeIter* iter)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (model != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (iter != NULL);
	self->priv->model_changed = TRUE;
	baobab_chart_update_draw (self, path);
}

static void
baobab_chart_row_deleted (BaobabChart* self,
                          GtkTreeModel* model,
                          GtkTreePath* path)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (model != NULL);
	g_return_if_fail (path != NULL);
	self->priv->model_changed = TRUE;
	baobab_chart_update_draw (self, path);
}

static void
baobab_chart_row_has_child_toggled (BaobabChart* self,
                                    GtkTreeModel* model,
                                    GtkTreePath* path,
                                    GtkTreeIter* iter)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (model != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (iter != NULL);
	self->priv->model_changed = TRUE;
	baobab_chart_update_draw (self, path);
}

static void
baobab_chart_rows_reordered (BaobabChart* self,
                             GtkTreeModel* model,
                             GtkTreePath* path,
                             GtkTreeIter* iter,
                             void* new_order)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (model != NULL);
	g_return_if_fail (path != NULL);
	self->priv->model_changed = TRUE;
	baobab_chart_update_draw (self, path);
}

static void
baobab_chart_draw_func (BaobabChart* self,
                        GtkDrawingArea* da,
                        cairo_t* cr,
                        gint width,
                        gint height)
{
	GtkTreeModel* _tmp0_;
	GtkTreeModel* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (da != NULL);
	g_return_if_fail (cr != NULL);
	_tmp0_ = baobab_chart_get_model (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		gboolean _tmp2_ = FALSE;
		if (self->priv->model_changed) {
			_tmp2_ = TRUE;
		} else {
			GList* _tmp3_;
			_tmp3_ = self->priv->items;
			_tmp2_ = _tmp3_ == NULL;
		}
		if (_tmp2_) {
			GtkTreePath* _tmp4_;
			GtkTreePath* _tmp5_;
			GtkTreePath* _tmp6_;
			_tmp4_ = baobab_chart_get_tree_root (self);
			_tmp5_ = _tmp4_;
			_tmp6_ = _tmp5_;
			baobab_chart_get_items (self, _tmp6_);
			__vala_GtkTreePath_free0 (_tmp6_);
		} else {
			GtkTreePath* current_path = NULL;
			GtkTreeModel* _tmp7_;
			GtkTreeModel* _tmp8_;
			GList* _tmp9_;
			gconstpointer _tmp10_;
			GtkTreeIter _tmp11_;
			GtkTreePath* _tmp12_;
			GtkTreePath* _tmp13_;
			GtkTreePath* _tmp14_;
			GtkTreePath* _tmp15_;
			GtkTreePath* _tmp16_;
			gboolean _tmp17_;
			_tmp7_ = baobab_chart_get_model (self);
			_tmp8_ = _tmp7_;
			_tmp9_ = self->priv->items;
			_tmp10_ = _tmp9_->data;
			_tmp11_ = ((BaobabChartItem*) _tmp10_)->iter;
			_tmp12_ = gtk_tree_model_get_path (_tmp8_, &_tmp11_);
			current_path = _tmp12_;
			_tmp13_ = baobab_chart_get_tree_root (self);
			_tmp14_ = _tmp13_;
			_tmp15_ = _tmp14_;
			_tmp16_ = current_path;
			_tmp17_ = gtk_tree_path_compare (_tmp15_, _tmp16_) != 0;
			__vala_GtkTreePath_free0 (_tmp15_);
			if (_tmp17_) {
				GtkTreePath* _tmp18_;
				GtkTreePath* _tmp19_;
				GtkTreePath* _tmp20_;
				_tmp18_ = baobab_chart_get_tree_root (self);
				_tmp19_ = _tmp18_;
				_tmp20_ = _tmp19_;
				baobab_chart_get_items (self, _tmp20_);
				__vala_GtkTreePath_free0 (_tmp20_);
			}
			__vala_GtkTreePath_free0 (current_path);
		}
		baobab_chart_draw_chart (self, cr);
	}
}

static void
baobab_chart_interpolate_colors (BaobabChart* self,
                                 GdkRGBA* colora,
                                 GdkRGBA* colorb,
                                 gfloat percentage,
                                 GdkRGBA* result)
{
	GdkRGBA color = {0};
	gfloat diff = 0.0F;
	GdkRGBA _tmp0_;
	GdkRGBA _tmp1_;
	GdkRGBA _tmp2_;
	GdkRGBA _tmp3_;
	GdkRGBA _tmp4_;
	GdkRGBA _tmp5_;
	GdkRGBA _tmp6_;
	GdkRGBA _tmp7_;
	GdkRGBA _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (colora != NULL);
	g_return_if_fail (colorb != NULL);
	memset (&color, 0, sizeof (GdkRGBA));
	_tmp0_ = *colora;
	_tmp1_ = *colorb;
	diff = _tmp0_.red - _tmp1_.red;
	_tmp2_ = *colora;
	color.red = _tmp2_.red - (diff * percentage);
	_tmp3_ = *colora;
	_tmp4_ = *colorb;
	diff = _tmp3_.green - _tmp4_.green;
	_tmp5_ = *colora;
	color.green = _tmp5_.green - (diff * percentage);
	_tmp6_ = *colora;
	_tmp7_ = *colorb;
	diff = _tmp6_.blue - _tmp7_.blue;
	_tmp8_ = *colora;
	color.blue = _tmp8_.blue - (diff * percentage);
	color.alpha = (gfloat) 1.0;
	*result = color;
	return;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
baobab_chart_get_item_color (BaobabChart* self,
                             gdouble rel_position,
                             guint depth,
                             gboolean highlighted,
                             GdkRGBA* result)
{
	GtkStyleContext* context = NULL;
	GtkStyleContext* _tmp0_;
	GtkStyleContext* _tmp1_;
	GdkRGBA color = {0};
	gfloat intensity = 0.0F;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	context = _tmp1_;
	memset (&color, 0, sizeof (GdkRGBA));
	intensity = (gfloat) (1 - (((depth - 1) * 0.3) / BAOBAB_CHART_MAX_DEPTH));
	if (depth == ((guint) 0)) {
		GtkStyleContext* _tmp2_;
		GdkRGBA _tmp3_ = {0};
		_tmp2_ = context;
		gtk_style_context_lookup_color (_tmp2_, "level_color", &_tmp3_);
		color = _tmp3_;
	} else {
		GdkRGBA color_a = {0};
		GdkRGBA color_b = {0};
		gint color_number = 0;
		gint next_color_number = 0;
		GtkStyleContext* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		GdkRGBA _tmp9_ = {0};
		GtkStyleContext* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		GdkRGBA _tmp15_ = {0};
		GdkRGBA _tmp16_;
		GdkRGBA _tmp17_;
		GdkRGBA _tmp18_ = {0};
		color_number = (gint) (rel_position / (100.0 / 3));
		next_color_number = (color_number + 1) % BAOBAB_CHART_NUM_COLORS;
		_tmp4_ = context;
		_tmp5_ = g_strdup_printf ("%i", color_number);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strconcat ("color_", _tmp6_, NULL);
		_tmp8_ = _tmp7_;
		gtk_style_context_lookup_color (_tmp4_, _tmp8_, &_tmp9_);
		color_a = _tmp9_;
		_g_free0 (_tmp8_);
		_g_free0 (_tmp6_);
		_tmp10_ = context;
		_tmp11_ = g_strdup_printf ("%i", next_color_number);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_strconcat ("color_", _tmp12_, NULL);
		_tmp14_ = _tmp13_;
		gtk_style_context_lookup_color (_tmp10_, _tmp14_, &_tmp15_);
		color_b = _tmp15_;
		_g_free0 (_tmp14_);
		_g_free0 (_tmp12_);
		_tmp16_ = color_a;
		_tmp17_ = color_b;
		baobab_chart_interpolate_colors (self, &_tmp16_, &_tmp17_, ((gfloat) (rel_position - ((color_number * 100) / 3))) / (100 / 3), &_tmp18_);
		color = _tmp18_;
		color.red = color.red * intensity;
		color.green = color.green * intensity;
		color.blue = color.blue * intensity;
	}
	if (highlighted) {
		if (depth == ((guint) 0)) {
			GtkStyleContext* _tmp19_;
			GdkRGBA _tmp20_ = {0};
			_tmp19_ = context;
			gtk_style_context_lookup_color (_tmp19_, "level_color_hi", &_tmp20_);
			color = _tmp20_;
		} else {
			gfloat maximum = 0.0F;
			GdkRGBA _tmp21_;
			GdkRGBA _tmp22_;
			GdkRGBA _tmp23_;
			_tmp21_ = color;
			_tmp22_ = color;
			_tmp23_ = color;
			maximum = MAX (_tmp21_.red, MAX (_tmp22_.green, _tmp23_.blue));
			color.red = color.red / maximum;
			color.green = color.green / maximum;
			color.blue = color.blue / maximum;
		}
	}
	*result = color;
	_g_object_unref0 (context);
	return;
}

static gboolean
baobab_chart_scroll_cb (BaobabChart* self,
                        gdouble dx,
                        gdouble dy)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (dx > 0.0) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = dy < 0.0;
	}
	if (_tmp0_) {
		baobab_chart_zoom_out (self);
		result = TRUE;
		return result;
	} else {
		gboolean _tmp1_ = FALSE;
		if (dx < 0.0) {
			_tmp1_ = TRUE;
		} else {
			_tmp1_ = dy > 0.0;
		}
		if (_tmp1_) {
			baobab_chart_zoom_in (self);
			result = TRUE;
			return result;
		}
	}
	result = FALSE;
	return result;
}

void
baobab_chart_open_file (BaobabChart* self)
{
	GtkRoot* _tmp0_;
	BaobabChartItem* _tmp1_;
	BaobabChartItem* _tmp2_;
	GtkTreeIter _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_widget_get_root ((GtkWidget*) self);
	_tmp1_ = baobab_chart_get_highlighted_item (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_->iter;
	baobab_window_open_item (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, BAOBAB_TYPE_WINDOW, BaobabWindow), &_tmp3_);
}

void
baobab_chart_copy_path (BaobabChart* self)
{
	GtkRoot* _tmp0_;
	BaobabChartItem* _tmp1_;
	BaobabChartItem* _tmp2_;
	GtkTreeIter _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_widget_get_root ((GtkWidget*) self);
	_tmp1_ = baobab_chart_get_highlighted_item (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_->iter;
	baobab_window_copy_path (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, BAOBAB_TYPE_WINDOW, BaobabWindow), &_tmp3_);
}

void
baobab_chart_trash_file (BaobabChart* self)
{
	GtkRoot* _tmp0_;
	BaobabChartItem* _tmp1_;
	BaobabChartItem* _tmp2_;
	GtkTreeIter _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_widget_get_root ((GtkWidget*) self);
	_tmp1_ = baobab_chart_get_highlighted_item (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_->iter;
	baobab_window_trash_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, BAOBAB_TYPE_WINDOW, BaobabWindow), &_tmp3_);
}

gboolean
baobab_chart_can_move_up_root (BaobabChart* self)
{
	GtkTreeIter iter = {0};
	GtkTreeIter parent_iter = {0};
	GtkTreeModel* _tmp0_;
	GtkTreeModel* _tmp1_;
	GtkTreePath* _tmp2_;
	GtkTreePath* _tmp3_;
	GtkTreePath* _tmp4_;
	GtkTreeIter _tmp5_ = {0};
	GtkTreeModel* _tmp6_;
	GtkTreeModel* _tmp7_;
	GtkTreeIter _tmp8_;
	GtkTreeIter _tmp9_ = {0};
	gboolean _tmp10_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = baobab_chart_get_model (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = baobab_chart_get_tree_root (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	gtk_tree_model_get_iter (_tmp1_, &_tmp5_, _tmp4_);
	iter = _tmp5_;
	__vala_GtkTreePath_free0 (_tmp4_);
	_tmp6_ = baobab_chart_get_model (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = iter;
	_tmp10_ = gtk_tree_model_iter_parent (_tmp7_, &_tmp9_, &_tmp8_);
	parent_iter = _tmp9_;
	result = _tmp10_;
	return result;
}

void
baobab_chart_move_up_root (BaobabChart* self)
{
	GtkTreeIter iter = {0};
	GtkTreeIter parent_iter = {0};
	GtkTreeModel* _tmp0_;
	GtkTreeModel* _tmp1_;
	GtkTreePath* _tmp2_;
	GtkTreePath* _tmp3_;
	GtkTreePath* _tmp4_;
	GtkTreeIter _tmp5_ = {0};
	GtkTreeModel* _tmp6_;
	GtkTreeModel* _tmp7_;
	GtkTreeIter _tmp8_;
	GtkTreeIter _tmp9_ = {0};
	gboolean _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = baobab_chart_get_model (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = baobab_chart_get_tree_root (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	gtk_tree_model_get_iter (_tmp1_, &_tmp5_, _tmp4_);
	iter = _tmp5_;
	__vala_GtkTreePath_free0 (_tmp4_);
	_tmp6_ = baobab_chart_get_model (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = iter;
	_tmp10_ = gtk_tree_model_iter_parent (_tmp7_, &_tmp9_, &_tmp8_);
	parent_iter = _tmp9_;
	if (_tmp10_) {
		GtkTreeModel* _tmp11_;
		GtkTreeModel* _tmp12_;
		GtkTreeIter _tmp13_;
		GtkTreePath* _tmp14_;
		GtkTreePath* _tmp15_;
		GtkTreeIter _tmp16_;
		_tmp11_ = baobab_chart_get_model (self);
		_tmp12_ = _tmp11_;
		_tmp13_ = parent_iter;
		_tmp14_ = gtk_tree_model_get_path (_tmp12_, &_tmp13_);
		_tmp15_ = _tmp14_;
		baobab_chart_set_tree_root (self, _tmp15_);
		__vala_GtkTreePath_free0 (_tmp15_);
		_tmp16_ = parent_iter;
		g_signal_emit (self, baobab_chart_signals[BAOBAB_CHART_ITEM_ACTIVATED_SIGNAL], 0, &_tmp16_);
	}
}

void
baobab_chart_zoom_in (BaobabChart* self)
{
	g_return_if_fail (self != NULL);
	if (baobab_chart_can_zoom_in (self)) {
		guint _tmp0_;
		guint _tmp1_;
		_tmp0_ = baobab_chart_get_max_depth (self);
		_tmp1_ = _tmp0_;
		baobab_chart_set_max_depth (self, _tmp1_ - 1);
	}
}

void
baobab_chart_zoom_out (BaobabChart* self)
{
	g_return_if_fail (self != NULL);
	if (baobab_chart_can_zoom_out (self)) {
		guint _tmp0_;
		guint _tmp1_;
		_tmp0_ = baobab_chart_get_max_depth (self);
		_tmp1_ = _tmp0_;
		baobab_chart_set_max_depth (self, _tmp1_ + 1);
	}
}

static void
baobab_chart_build_context_menu (BaobabChart* self)
{
	GMenu* menu_model = NULL;
	BaobabApplication* _tmp0_;
	BaobabApplication* _tmp1_;
	GMenu* _tmp2_;
	GMenu* _tmp3_;
	GMenu* _tmp4_;
	GtkPopoverMenu* _tmp5_;
	GtkPopoverMenu* _tmp6_;
	GtkPopoverMenu* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = baobab_application_get_default ();
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_application_get_menu_by_id ((GtkApplication*) _tmp1_, "chartmenu");
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp1_);
	menu_model = _tmp4_;
	_tmp5_ = (GtkPopoverMenu*) gtk_popover_menu_new_from_model ((GMenuModel*) menu_model);
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->context_menu);
	self->priv->context_menu = _tmp5_;
	_tmp6_ = self->priv->context_menu;
	gtk_widget_set_parent ((GtkWidget*) _tmp6_, (GtkWidget*) self);
	_tmp7_ = self->priv->context_menu;
	gtk_popover_set_position ((GtkPopover*) _tmp7_, GTK_POS_BOTTOM);
	_g_object_unref0 (menu_model);
}

static void
baobab_chart_show_popover_at (BaobabChart* self,
                              gint x,
                              gint y)
{
	gboolean enable = FALSE;
	BaobabChartItem* _tmp0_;
	BaobabChartItem* _tmp1_;
	GSimpleAction* action = NULL;
	GSimpleActionGroup* _tmp2_;
	GAction* _tmp3_;
	GSimpleAction* _tmp4_;
	GSimpleAction* _tmp5_;
	GSimpleActionGroup* _tmp6_;
	GAction* _tmp7_;
	GSimpleAction* _tmp8_;
	GSimpleAction* _tmp9_;
	GSimpleActionGroup* _tmp10_;
	GAction* _tmp11_;
	GSimpleAction* _tmp12_;
	GSimpleAction* _tmp13_;
	GSimpleActionGroup* _tmp14_;
	GAction* _tmp15_;
	GSimpleAction* _tmp16_;
	GSimpleAction* _tmp17_;
	GSimpleActionGroup* _tmp18_;
	GAction* _tmp19_;
	GSimpleAction* _tmp20_;
	GSimpleAction* _tmp21_;
	GSimpleActionGroup* _tmp22_;
	GAction* _tmp23_;
	GSimpleAction* _tmp24_;
	GSimpleAction* _tmp25_;
	GdkRectangle rect = {0};
	GdkRectangle _tmp26_ = {0};
	GtkPopoverMenu* _tmp27_;
	GdkRectangle _tmp28_;
	GtkPopoverMenu* _tmp29_;
	g_return_if_fail (self != NULL);
	_tmp0_ = baobab_chart_get_highlighted_item (self);
	_tmp1_ = _tmp0_;
	enable = _tmp1_ != NULL;
	_tmp2_ = self->priv->action_group;
	_tmp3_ = g_action_map_lookup_action ((GActionMap*) _tmp2_, "open-file");
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp3_) : NULL);
	action = _tmp4_;
	_tmp5_ = action;
	g_simple_action_set_enabled (_tmp5_, enable);
	_tmp6_ = self->priv->action_group;
	_tmp7_ = g_action_map_lookup_action ((GActionMap*) _tmp6_, "copy-path");
	_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp7_) : NULL);
	_g_object_unref0 (action);
	action = _tmp8_;
	_tmp9_ = action;
	g_simple_action_set_enabled (_tmp9_, enable);
	_tmp10_ = self->priv->action_group;
	_tmp11_ = g_action_map_lookup_action ((GActionMap*) _tmp10_, "trash-file");
	_tmp12_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp11_) : NULL);
	_g_object_unref0 (action);
	action = _tmp12_;
	_tmp13_ = action;
	g_simple_action_set_enabled (_tmp13_, enable);
	_tmp14_ = self->priv->action_group;
	_tmp15_ = g_action_map_lookup_action ((GActionMap*) _tmp14_, "move-up");
	_tmp16_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp15_) : NULL);
	_g_object_unref0 (action);
	action = _tmp16_;
	_tmp17_ = action;
	g_simple_action_set_enabled (_tmp17_, baobab_chart_can_move_up_root (self));
	_tmp18_ = self->priv->action_group;
	_tmp19_ = g_action_map_lookup_action ((GActionMap*) _tmp18_, "zoom-in");
	_tmp20_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp19_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp19_) : NULL);
	_g_object_unref0 (action);
	action = _tmp20_;
	_tmp21_ = action;
	g_simple_action_set_enabled (_tmp21_, baobab_chart_can_zoom_in (self));
	_tmp22_ = self->priv->action_group;
	_tmp23_ = g_action_map_lookup_action ((GActionMap*) _tmp22_, "zoom-out");
	_tmp24_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp23_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp23_) : NULL);
	_g_object_unref0 (action);
	action = _tmp24_;
	_tmp25_ = action;
	g_simple_action_set_enabled (_tmp25_, baobab_chart_can_zoom_out (self));
	_tmp26_.x = x;
	_tmp26_.y = y;
	_tmp26_.width = 0;
	_tmp26_.height = 0;
	rect = _tmp26_;
	_tmp27_ = self->priv->context_menu;
	_tmp28_ = rect;
	gtk_popover_set_pointing_to ((GtkPopover*) _tmp27_, &_tmp28_);
	_tmp29_ = self->priv->context_menu;
	gtk_popover_popup ((GtkPopover*) _tmp29_);
	_g_object_unref0 (action);
}

static void
_baobab_chart_row_changed_gtk_tree_model_row_changed (GtkTreeModel* _sender,
                                                      GtkTreePath* path,
                                                      GtkTreeIter* iter,
                                                      gpointer self)
{
	baobab_chart_row_changed ((BaobabChart*) self, _sender, path, iter);
}

static void
_baobab_chart_row_inserted_gtk_tree_model_row_inserted (GtkTreeModel* _sender,
                                                        GtkTreePath* path,
                                                        GtkTreeIter* iter,
                                                        gpointer self)
{
	baobab_chart_row_inserted ((BaobabChart*) self, _sender, path, iter);
}

static void
_baobab_chart_row_has_child_toggled_gtk_tree_model_row_has_child_toggled (GtkTreeModel* _sender,
                                                                          GtkTreePath* path,
                                                                          GtkTreeIter* iter,
                                                                          gpointer self)
{
	baobab_chart_row_has_child_toggled ((BaobabChart*) self, _sender, path, iter);
}

static void
_baobab_chart_row_deleted_gtk_tree_model_row_deleted (GtkTreeModel* _sender,
                                                      GtkTreePath* path,
                                                      gpointer self)
{
	baobab_chart_row_deleted ((BaobabChart*) self, _sender, path);
}

static void
_baobab_chart_rows_reordered_gtk_tree_model_rows_reordered (GtkTreeModel* _sender,
                                                            GtkTreePath* path,
                                                            GtkTreeIter* iter,
                                                            gint* new_order,
                                                            gpointer self)
{
	baobab_chart_rows_reordered ((BaobabChart*) self, _sender, path, iter, new_order);
}

static void
baobab_chart_connect_model_signals (BaobabChart* self,
                                    GtkTreeModel* m)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (m != NULL);
	g_signal_connect_object (m, "row-changed", (GCallback) _baobab_chart_row_changed_gtk_tree_model_row_changed, self, 0);
	g_signal_connect_object (m, "row-inserted", (GCallback) _baobab_chart_row_inserted_gtk_tree_model_row_inserted, self, 0);
	g_signal_connect_object (m, "row-has-child-toggled", (GCallback) _baobab_chart_row_has_child_toggled_gtk_tree_model_row_has_child_toggled, self, 0);
	g_signal_connect_object (m, "row-deleted", (GCallback) _baobab_chart_row_deleted_gtk_tree_model_row_deleted, self, 0);
	g_signal_connect_object (m, "rows-reordered", (GCallback) _baobab_chart_rows_reordered_gtk_tree_model_rows_reordered, self, 0);
}

static void
baobab_chart_disconnect_model_signals (BaobabChart* self,
                                       GtkTreeModel* m)
{
	guint _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (m != NULL);
	g_signal_parse_name ("row-changed", gtk_tree_model_get_type (), &_tmp0_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (m, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _baobab_chart_row_changed_gtk_tree_model_row_changed, self);
	g_signal_parse_name ("row-inserted", gtk_tree_model_get_type (), &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (m, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _baobab_chart_row_inserted_gtk_tree_model_row_inserted, self);
	g_signal_parse_name ("row-has-child-toggled", gtk_tree_model_get_type (), &_tmp2_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (m, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _baobab_chart_row_has_child_toggled_gtk_tree_model_row_has_child_toggled, self);
	g_signal_parse_name ("row-deleted", gtk_tree_model_get_type (), &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (m, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _baobab_chart_row_deleted_gtk_tree_model_row_deleted, self);
	g_signal_parse_name ("rows-reordered", gtk_tree_model_get_type (), &_tmp4_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (m, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, 0, NULL, (GCallback) _baobab_chart_rows_reordered_gtk_tree_model_rows_reordered, self);
}

static gboolean
baobab_chart_real_query_tooltip (GtkWidget* base,
                                 gint x,
                                 gint y,
                                 gboolean keyboard_tooltip,
                                 GtkTooltip* tooltip)
{
	BaobabChart * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	BaobabChartItem* _tmp2_;
	BaobabChartItem* _tmp3_;
	BaobabChartItem* _tmp10_;
	BaobabChartItem* _tmp11_;
	GdkRectangle _tmp12_;
	gchar* markup = NULL;
	BaobabChartItem* _tmp13_;
	BaobabChartItem* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	BaobabChartItem* _tmp18_;
	BaobabChartItem* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	const gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gboolean result;
	self = (BaobabChart*) base;
	g_return_val_if_fail (tooltip != NULL, FALSE);
	_tmp2_ = baobab_chart_get_highlighted_item (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		BaobabChartItem* _tmp4_;
		BaobabChartItem* _tmp5_;
		const gchar* _tmp6_;
		_tmp4_ = baobab_chart_get_highlighted_item (self);
		_tmp5_ = _tmp4_;
		_tmp6_ = _tmp5_->name;
		_tmp1_ = _tmp6_ == NULL;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		BaobabChartItem* _tmp7_;
		BaobabChartItem* _tmp8_;
		const gchar* _tmp9_;
		_tmp7_ = baobab_chart_get_highlighted_item (self);
		_tmp8_ = _tmp7_;
		_tmp9_ = _tmp8_->size;
		_tmp0_ = _tmp9_ == NULL;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp10_ = baobab_chart_get_highlighted_item (self);
	_tmp11_ = _tmp10_;
	_tmp12_ = _tmp11_->rect;
	gtk_tooltip_set_tip_area (tooltip, &_tmp12_);
	_tmp13_ = baobab_chart_get_highlighted_item (self);
	_tmp14_ = _tmp13_;
	_tmp15_ = _tmp14_->name;
	_tmp16_ = g_strconcat (_tmp15_, "\n", NULL);
	_tmp17_ = _tmp16_;
	_tmp18_ = baobab_chart_get_highlighted_item (self);
	_tmp19_ = _tmp18_;
	_tmp20_ = _tmp19_->size;
	_tmp21_ = g_strconcat (_tmp17_, _tmp20_, NULL);
	_tmp22_ = _tmp21_;
	_g_free0 (_tmp17_);
	markup = _tmp22_;
	_tmp23_ = markup;
	_tmp24_ = g_markup_escape_text (_tmp23_, (gssize) -1);
	_tmp25_ = _tmp24_;
	gtk_tooltip_set_markup (tooltip, _tmp25_);
	_g_free0 (_tmp25_);
	result = TRUE;
	_g_free0 (markup);
	return result;
}

BaobabChart*
baobab_chart_construct (GType object_type)
{
	BaobabChart * self = NULL;
	self = (BaobabChart*) g_object_new (object_type, NULL);
	return self;
}

BaobabLocation*
baobab_chart_get_location (BaobabChart* self)
{
	BaobabLocation* result;
	BaobabLocation* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->location_;
	result = _tmp0_;
	return result;
}

static gpointer
_baobab_location_ref0 (gpointer self)
{
	return self ? baobab_location_ref (self) : NULL;
}

void
baobab_chart_set_location (BaobabChart* self,
                           BaobabLocation* value)
{
	BaobabLocation* _tmp0_;
	BaobabLocation* _tmp1_;
	BaobabScanner* _tmp2_;
	BaobabScanner* _tmp3_;
	GtkTreeModel* _tmp4_;
	GtkTreeModel* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _baobab_location_ref0 (value);
	_baobab_location_unref0 (self->priv->location_);
	self->priv->location_ = _tmp0_;
	_tmp1_ = self->priv->location_;
	_tmp2_ = baobab_location_get_scanner (_tmp1_);
	_tmp3_ = _tmp2_;
	baobab_chart_set_model (self, (GtkTreeModel*) _tmp3_);
	_tmp4_ = baobab_chart_get_model (self);
	_tmp5_ = _tmp4_;
	g_object_bind_property_with_closures ((GObject*) _tmp5_, "max-depth", (GObject*) self, "max-depth", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	g_object_notify_by_pspec ((GObject *) self, baobab_chart_properties[BAOBAB_CHART_LOCATION_PROPERTY]);
}

guint
baobab_chart_get_max_depth (BaobabChart* self)
{
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->max_depth_;
	return result;
}

void
baobab_chart_set_max_depth (BaobabChart* self,
                            guint value)
{
	guint m = 0U;
	g_return_if_fail (self != NULL);
	m = CLAMP (value, BAOBAB_CHART_MIN_DEPTH, BAOBAB_CHART_MAX_DEPTH);
	if (self->priv->max_depth_ == m) {
		return;
	}
	self->priv->max_depth_ = m;
	self->priv->model_changed = TRUE;
	gtk_widget_queue_draw ((GtkWidget*) self);
	g_object_notify_by_pspec ((GObject *) self, baobab_chart_properties[BAOBAB_CHART_MAX_DEPTH_PROPERTY]);
}

GtkTreeModel*
baobab_chart_get_model (BaobabChart* self)
{
	GtkTreeModel* result;
	GtkTreeModel* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->model_;
	result = _tmp0_;
	return result;
}

void
baobab_chart_set_model (BaobabChart* self,
                        GtkTreeModel* value)
{
	GtkTreeModel* _tmp0_;
	GtkTreeModel* _tmp1_;
	GtkTreeModel* _tmp3_;
	GtkTreeModel* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->model_;
	if (_tmp0_ == value) {
		return;
	}
	_tmp1_ = self->priv->model_;
	if (_tmp1_ != NULL) {
		GtkTreeModel* _tmp2_;
		_tmp2_ = self->priv->model_;
		baobab_chart_disconnect_model_signals (self, _tmp2_);
	}
	_tmp3_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->model_);
	self->priv->model_ = _tmp3_;
	self->priv->model_changed = TRUE;
	baobab_chart_set_tree_root (self, NULL);
	_tmp4_ = self->priv->model_;
	baobab_chart_connect_model_signals (self, _tmp4_);
	gtk_widget_queue_draw ((GtkWidget*) self);
	g_object_notify_by_pspec ((GObject *) self, baobab_chart_properties[BAOBAB_CHART_MODEL_PROPERTY]);
}

GtkTreePath*
baobab_chart_get_tree_root (BaobabChart* self)
{
	GtkTreePath* result;
	GtkTreeRowReference* _tmp0_;
	GtkTreePath* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->root_;
	if (_tmp0_ != NULL) {
		GtkTreePath* path = NULL;
		GtkTreeRowReference* _tmp1_;
		GtkTreePath* _tmp2_;
		GtkTreePath* _tmp3_;
		_tmp1_ = self->priv->root_;
		_tmp2_ = gtk_tree_row_reference_get_path (_tmp1_);
		path = _tmp2_;
		_tmp3_ = path;
		if (_tmp3_ != NULL) {
			result = path;
			return result;
		}
		__vala_GtkTreeRowReference_free0 (self->priv->root_);
		self->priv->root_ = NULL;
		__vala_GtkTreePath_free0 (path);
	}
	_tmp4_ = gtk_tree_path_new_first ();
	result = _tmp4_;
	return result;
}

static GtkTreeRowReference*
_vala_GtkTreeRowReference_copy (GtkTreeRowReference* self)
{
	return g_boxed_copy (gtk_tree_row_reference_get_type (), self);
}

static gpointer
__vala_GtkTreeRowReference_copy0 (gpointer self)
{
	return self ? _vala_GtkTreeRowReference_copy (self) : NULL;
}

void
baobab_chart_set_tree_root (BaobabChart* self,
                            GtkTreePath* value)
{
	GtkTreeModel* _tmp0_;
	GtkTreeModel* _tmp1_;
	GtkTreeRowReference* _tmp2_;
	GtkTreeRowReference* _tmp9_ = NULL;
	GtkTreeRowReference* _tmp13_;
	g_return_if_fail (self != NULL);
	_tmp0_ = baobab_chart_get_model (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp2_ = self->priv->root_;
	if (_tmp2_ != NULL) {
		GtkTreePath* current_root = NULL;
		GtkTreeRowReference* _tmp3_;
		GtkTreePath* _tmp4_;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		GtkTreePath* _tmp7_;
		_tmp3_ = self->priv->root_;
		_tmp4_ = gtk_tree_row_reference_get_path (_tmp3_);
		current_root = _tmp4_;
		_tmp7_ = current_root;
		if (_tmp7_ != NULL) {
			_tmp6_ = value != NULL;
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			GtkTreePath* _tmp8_;
			_tmp8_ = current_root;
			_tmp5_ = gtk_tree_path_compare (_tmp8_, value) == 0;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			__vala_GtkTreePath_free0 (current_root);
			return;
		}
		__vala_GtkTreePath_free0 (current_root);
	} else {
		if (value == NULL) {
			return;
		}
	}
	if (value != NULL) {
		GtkTreeModel* _tmp10_;
		GtkTreeModel* _tmp11_;
		GtkTreeRowReference* _tmp12_;
		_tmp10_ = baobab_chart_get_model (self);
		_tmp11_ = _tmp10_;
		_tmp12_ = gtk_tree_row_reference_new (_tmp11_, value);
		__vala_GtkTreeRowReference_free0 (_tmp9_);
		_tmp9_ = _tmp12_;
	} else {
		__vala_GtkTreeRowReference_free0 (_tmp9_);
		_tmp9_ = NULL;
	}
	_tmp13_ = __vala_GtkTreeRowReference_copy0 (_tmp9_);
	__vala_GtkTreeRowReference_free0 (self->priv->root_);
	self->priv->root_ = _tmp13_;
	baobab_chart_set_highlighted_item (self, NULL);
	gtk_widget_queue_draw ((GtkWidget*) self);
	__vala_GtkTreeRowReference_free0 (_tmp9_);
	g_object_notify_by_pspec ((GObject *) self, baobab_chart_properties[BAOBAB_CHART_TREE_ROOT_PROPERTY]);
}

BaobabChartItem*
baobab_chart_get_highlighted_item (BaobabChart* self)
{
	BaobabChartItem* result;
	BaobabChartItem* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->highlighted_item_;
	result = _tmp0_;
	return result;
}

void
baobab_chart_set_highlighted_item (BaobabChart* self,
                                   BaobabChartItem* value)
{
	BaobabChartItem* _tmp0_;
	BaobabChartItem* _tmp1_;
	BaobabChartItem* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->highlighted_item_;
	if (_tmp0_ == value) {
		return;
	}
	_tmp1_ = self->priv->highlighted_item_;
	if (_tmp1_ != NULL) {
		gtk_widget_queue_draw ((GtkWidget*) self);
	}
	if (value != NULL) {
		gtk_widget_queue_draw ((GtkWidget*) self);
	}
	_tmp2_ = _baobab_chart_item_ref0 (value);
	_baobab_chart_item_unref0 (self->priv->highlighted_item_);
	self->priv->highlighted_item_ = _tmp2_;
	g_object_notify_by_pspec ((GObject *) self, baobab_chart_properties[BAOBAB_CHART_HIGHLIGHTED_ITEM_PROPERTY]);
}

static gboolean
_baobab_chart_scroll_cb_gtk_event_controller_scroll_scroll (GtkEventControllerScroll* _sender,
                                                            gdouble dx,
                                                            gdouble dy,
                                                            gpointer self)
{
	gboolean result;
	result = baobab_chart_scroll_cb ((BaobabChart*) self, dx, dy);
	return result;
}

static void
_baobab_chart_motion_cb_gtk_event_controller_motion_motion (GtkEventControllerMotion* _sender,
                                                            gdouble x,
                                                            gdouble y,
                                                            gpointer self)
{
	baobab_chart_motion_cb ((BaobabChart*) self, x, y);
}

static void
_baobab_chart_leave_cb_gtk_event_controller_motion_leave (GtkEventControllerMotion* _sender,
                                                          gpointer self)
{
	baobab_chart_leave_cb ((BaobabChart*) self);
}

static void
_baobab_chart___lambda13_ (BaobabChart* self,
                           gint _,
                           gdouble x,
                           gdouble y)
{
	if (baobab_chart_highlight_item_at_point (self, x, y)) {
		GtkTreePath* path = NULL;
		GtkTreeModel* _tmp0_;
		GtkTreeModel* _tmp1_;
		BaobabChartItem* _tmp2_;
		BaobabChartItem* _tmp3_;
		GtkTreeIter _tmp4_;
		GtkTreePath* _tmp5_;
		GtkTreePath* _tmp6_;
		GtkTreePath* _tmp7_;
		GtkTreePath* _tmp8_;
		GtkTreePath* _tmp9_;
		gboolean _tmp10_;
		_tmp0_ = baobab_chart_get_model (self);
		_tmp1_ = _tmp0_;
		_tmp2_ = baobab_chart_get_highlighted_item (self);
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_->iter;
		_tmp5_ = gtk_tree_model_get_path (_tmp1_, &_tmp4_);
		path = _tmp5_;
		_tmp6_ = baobab_chart_get_tree_root (self);
		_tmp7_ = _tmp6_;
		_tmp8_ = _tmp7_;
		_tmp9_ = path;
		_tmp10_ = gtk_tree_path_compare (_tmp8_, _tmp9_) == 0;
		__vala_GtkTreePath_free0 (_tmp8_);
		if (_tmp10_) {
			baobab_chart_move_up_root (self);
		} else {
			BaobabChartItem* _tmp11_;
			BaobabChartItem* _tmp12_;
			GtkTreeIter _tmp13_;
			_tmp11_ = baobab_chart_get_highlighted_item (self);
			_tmp12_ = _tmp11_;
			_tmp13_ = _tmp12_->iter;
			g_signal_emit (self, baobab_chart_signals[BAOBAB_CHART_ITEM_ACTIVATED_SIGNAL], 0, &_tmp13_);
		}
		__vala_GtkTreePath_free0 (path);
	}
}

static void
__baobab_chart___lambda13__gtk_gesture_click_pressed (GtkGestureClick* _sender,
                                                      gint n_press,
                                                      gdouble x,
                                                      gdouble y,
                                                      gpointer self)
{
	_baobab_chart___lambda13_ ((BaobabChart*) self, n_press, x, y);
}

static void
_baobab_chart___lambda14_ (BaobabChart* self,
                           gint _,
                           gdouble x,
                           gdouble y)
{
	baobab_chart_show_popover_at (self, (gint) x, (gint) y);
}

static void
__baobab_chart___lambda14__gtk_gesture_click_pressed (GtkGestureClick* _sender,
                                                      gint n_press,
                                                      gdouble x,
                                                      gdouble y,
                                                      gpointer self)
{
	_baobab_chart___lambda14_ ((BaobabChart*) self, n_press, x, y);
}

static void
_baobab_chart___lambda15_ (BaobabChart* self,
                           gint _,
                           gdouble x,
                           gdouble y)
{
	baobab_chart_move_up_root (self);
}

static void
__baobab_chart___lambda15__gtk_gesture_click_pressed (GtkGestureClick* _sender,
                                                      gint n_press,
                                                      gdouble x,
                                                      gdouble y,
                                                      gpointer self)
{
	_baobab_chart___lambda15_ ((BaobabChart*) self, n_press, x, y);
}

static void
_baobab_chart_draw_func_gtk_drawing_area_draw_func (GtkDrawingArea* drawing_area,
                                                    cairo_t* cr,
                                                    gint width,
                                                    gint height,
                                                    gpointer self)
{
	baobab_chart_draw_func ((BaobabChart*) self, drawing_area, cr, width, height);
}

static GObject *
baobab_chart_constructor (GType type,
                          guint n_construct_properties,
                          GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	BaobabChart * self;
	GtkEventControllerScroll* _tmp0_;
	GtkEventControllerScroll* _tmp1_;
	GtkEventControllerScroll* _tmp2_;
	GtkEventController* _tmp3_;
	GtkEventControllerMotion* _tmp4_;
	GtkEventControllerMotion* _tmp5_;
	GtkEventControllerMotion* _tmp6_;
	GtkEventControllerMotion* _tmp7_;
	GtkEventController* _tmp8_;
	GtkGestureClick* _tmp9_;
	GtkGestureClick* _tmp10_;
	GtkGestureClick* _tmp11_;
	GtkGestureClick* _tmp12_;
	GtkEventController* _tmp13_;
	GtkGestureClick* _tmp14_;
	GtkGestureClick* _tmp15_;
	GtkGestureClick* _tmp16_;
	GtkGestureClick* _tmp17_;
	GtkEventController* _tmp18_;
	GtkGestureClick* _tmp19_;
	GtkGestureClick* _tmp20_;
	GtkGestureClick* _tmp21_;
	GtkGestureClick* _tmp22_;
	GtkEventController* _tmp23_;
	GSimpleActionGroup* _tmp24_;
	GSimpleActionGroup* _tmp25_;
	GSimpleActionGroup* _tmp26_;
	parent_class = G_OBJECT_CLASS (baobab_chart_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BAOBAB_TYPE_CHART, BaobabChart);
	_tmp0_ = (GtkEventControllerScroll*) gtk_event_controller_scroll_new (GTK_EVENT_CONTROLLER_SCROLL_BOTH_AXES);
	_g_object_unref0 (self->priv->scroll_controller);
	self->priv->scroll_controller = _tmp0_;
	_tmp1_ = self->priv->scroll_controller;
	g_signal_connect_object (_tmp1_, "scroll", (GCallback) _baobab_chart_scroll_cb_gtk_event_controller_scroll_scroll, self, 0);
	_tmp2_ = self->priv->scroll_controller;
	_tmp3_ = _g_object_ref0 ((GtkEventController*) _tmp2_);
	gtk_widget_add_controller ((GtkWidget*) self, _tmp3_);
	_tmp4_ = (GtkEventControllerMotion*) gtk_event_controller_motion_new ();
	_g_object_unref0 (self->priv->motion_controller);
	self->priv->motion_controller = _tmp4_;
	_tmp5_ = self->priv->motion_controller;
	g_signal_connect_object (_tmp5_, "motion", (GCallback) _baobab_chart_motion_cb_gtk_event_controller_motion_motion, self, 0);
	_tmp6_ = self->priv->motion_controller;
	g_signal_connect_object (_tmp6_, "leave", (GCallback) _baobab_chart_leave_cb_gtk_event_controller_motion_leave, self, 0);
	_tmp7_ = self->priv->motion_controller;
	_tmp8_ = _g_object_ref0 ((GtkEventController*) _tmp7_);
	gtk_widget_add_controller ((GtkWidget*) self, _tmp8_);
	_tmp9_ = (GtkGestureClick*) gtk_gesture_click_new ();
	_g_object_unref0 (self->priv->primary_click_gesture);
	self->priv->primary_click_gesture = _tmp9_;
	_tmp10_ = self->priv->primary_click_gesture;
	gtk_gesture_single_set_button ((GtkGestureSingle*) _tmp10_, (guint) GDK_BUTTON_PRIMARY);
	_tmp11_ = self->priv->primary_click_gesture;
	g_signal_connect_object (_tmp11_, "pressed", (GCallback) __baobab_chart___lambda13__gtk_gesture_click_pressed, self, 0);
	_tmp12_ = self->priv->primary_click_gesture;
	_tmp13_ = _g_object_ref0 ((GtkEventController*) _tmp12_);
	gtk_widget_add_controller ((GtkWidget*) self, _tmp13_);
	_tmp14_ = (GtkGestureClick*) gtk_gesture_click_new ();
	_g_object_unref0 (self->priv->secondary_click_gesture);
	self->priv->secondary_click_gesture = _tmp14_;
	_tmp15_ = self->priv->secondary_click_gesture;
	gtk_gesture_single_set_button ((GtkGestureSingle*) _tmp15_, (guint) GDK_BUTTON_SECONDARY);
	_tmp16_ = self->priv->secondary_click_gesture;
	g_signal_connect_object (_tmp16_, "pressed", (GCallback) __baobab_chart___lambda14__gtk_gesture_click_pressed, self, 0);
	_tmp17_ = self->priv->secondary_click_gesture;
	_tmp18_ = _g_object_ref0 ((GtkEventController*) _tmp17_);
	gtk_widget_add_controller ((GtkWidget*) self, _tmp18_);
	_tmp19_ = (GtkGestureClick*) gtk_gesture_click_new ();
	_g_object_unref0 (self->priv->middle_click_gesture);
	self->priv->middle_click_gesture = _tmp19_;
	_tmp20_ = self->priv->middle_click_gesture;
	gtk_gesture_single_set_button ((GtkGestureSingle*) _tmp20_, (guint) GDK_BUTTON_MIDDLE);
	_tmp21_ = self->priv->middle_click_gesture;
	g_signal_connect_object (_tmp21_, "pressed", (GCallback) __baobab_chart___lambda15__gtk_gesture_click_pressed, self, 0);
	_tmp22_ = self->priv->middle_click_gesture;
	_tmp23_ = _g_object_ref0 ((GtkEventController*) _tmp22_);
	gtk_widget_add_controller ((GtkWidget*) self, _tmp23_);
	_tmp24_ = g_simple_action_group_new ();
	_g_object_unref0 (self->priv->action_group);
	self->priv->action_group = _tmp24_;
	_tmp25_ = self->priv->action_group;
	g_action_map_add_action_entries ((GActionMap*) _tmp25_, BAOBAB_CHART_action_entries, (gint) G_N_ELEMENTS (BAOBAB_CHART_action_entries), self);
	_tmp26_ = self->priv->action_group;
	gtk_widget_insert_action_group ((GtkWidget*) self, "chart", (GActionGroup*) _tmp26_);
	baobab_chart_build_context_menu (self);
	gtk_drawing_area_set_draw_func ((GtkDrawingArea*) self, _baobab_chart_draw_func_gtk_drawing_area_draw_func, g_object_ref (self), g_object_unref);
	return obj;
}

static void
baobab_chart_class_init (BaobabChartClass * klass,
                         gpointer klass_data)
{
	baobab_chart_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BaobabChart_private_offset);
	((BaobabChartClass *) klass)->post_draw = (void (*) (BaobabChart*, cairo_t*)) baobab_chart_real_post_draw;
	((BaobabChartClass *) klass)->draw_item = (void (*) (BaobabChart*, cairo_t*, BaobabChartItem*, gboolean)) baobab_chart_real_draw_item;
	((BaobabChartClass *) klass)->calculate_item_geometry = (void (*) (BaobabChart*, BaobabChartItem*)) baobab_chart_real_calculate_item_geometry;
	((BaobabChartClass *) klass)->is_point_over_item = (gboolean (*) (BaobabChart*, BaobabChartItem*, gdouble, gdouble)) baobab_chart_real_is_point_over_item;
	((BaobabChartClass *) klass)->get_item_rectangle = (void (*) (BaobabChart*, BaobabChartItem*)) baobab_chart_real_get_item_rectangle;
	((BaobabChartClass *) klass)->can_zoom_in = (gboolean (*) (BaobabChart*)) baobab_chart_real_can_zoom_in;
	((BaobabChartClass *) klass)->can_zoom_out = (gboolean (*) (BaobabChart*)) baobab_chart_real_can_zoom_out;
	((BaobabChartClass *) klass)->create_new_chartitem = (BaobabChartItem* (*) (BaobabChart*)) baobab_chart_real_create_new_chartitem;
	((GtkWidgetClass *) klass)->size_allocate = (void (*) (GtkWidget*, gint, gint, gint)) baobab_chart_real_size_allocate;
	((GtkWidgetClass *) klass)->query_tooltip = (gboolean (*) (GtkWidget*, gint, gint, gboolean, GtkTooltip*)) baobab_chart_real_query_tooltip;
	G_OBJECT_CLASS (klass)->get_property = _vala_baobab_chart_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_baobab_chart_set_property;
	G_OBJECT_CLASS (klass)->constructor = baobab_chart_constructor;
	G_OBJECT_CLASS (klass)->finalize = baobab_chart_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BAOBAB_CHART_LOCATION_PROPERTY, baobab_chart_properties[BAOBAB_CHART_LOCATION_PROPERTY] = baobab_param_spec_location ("location", "location", "location", BAOBAB_TYPE_LOCATION, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BAOBAB_CHART_MAX_DEPTH_PROPERTY, baobab_chart_properties[BAOBAB_CHART_MAX_DEPTH_PROPERTY] = g_param_spec_uint ("max-depth", "max-depth", "max-depth", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BAOBAB_CHART_MODEL_PROPERTY, baobab_chart_properties[BAOBAB_CHART_MODEL_PROPERTY] = g_param_spec_object ("model", "model", "model", gtk_tree_model_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BAOBAB_CHART_TREE_ROOT_PROPERTY, baobab_chart_properties[BAOBAB_CHART_TREE_ROOT_PROPERTY] = g_param_spec_boxed ("tree-root", "tree-root", "tree-root", gtk_tree_path_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BAOBAB_CHART_HIGHLIGHTED_ITEM_PROPERTY, baobab_chart_properties[BAOBAB_CHART_HIGHLIGHTED_ITEM_PROPERTY] = baobab_param_spec_chart_item ("highlighted-item", "highlighted-item", "highlighted-item", BAOBAB_TYPE_CHART_ITEM, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	baobab_chart_signals[BAOBAB_CHART_ITEM_ACTIVATED_SIGNAL] = g_signal_new ("item-activated", BAOBAB_TYPE_CHART, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOXED, G_TYPE_NONE, 1, gtk_tree_iter_get_type ());
}

static void
baobab_chart_instance_init (BaobabChart * self,
                            gpointer klass)
{
	self->priv = baobab_chart_get_instance_private (self);
	self->priv->context_menu = NULL;
	self->priv->max_depth_ = BAOBAB_CHART_MAX_DEPTH;
	self->priv->highlighted_item_ = NULL;
}

static void
baobab_chart_finalize (GObject * obj)
{
	BaobabChart * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BAOBAB_TYPE_CHART, BaobabChart);
	_g_object_unref0 (self->priv->context_menu);
	_g_object_unref0 (self->priv->scroll_controller);
	_g_object_unref0 (self->priv->motion_controller);
	_g_object_unref0 (self->priv->primary_click_gesture);
	_g_object_unref0 (self->priv->secondary_click_gesture);
	_g_object_unref0 (self->priv->middle_click_gesture);
	(self->priv->items == NULL) ? NULL : (self->priv->items = (_g_list_free__baobab_chart_item_unref0_ (self->priv->items), NULL));
	_baobab_location_unref0 (self->priv->location_);
	_g_object_unref0 (self->priv->model_);
	__vala_GtkTreeRowReference_free0 (self->priv->root_);
	_baobab_chart_item_unref0 (self->priv->highlighted_item_);
	_g_object_unref0 (self->priv->action_group);
	G_OBJECT_CLASS (baobab_chart_parent_class)->finalize (obj);
}

static GType
baobab_chart_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BaobabChartClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) baobab_chart_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BaobabChart), 0, (GInstanceInitFunc) baobab_chart_instance_init, NULL };
	GType baobab_chart_type_id;
	baobab_chart_type_id = g_type_register_static (gtk_drawing_area_get_type (), "BaobabChart", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	BaobabChart_private_offset = g_type_add_instance_private (baobab_chart_type_id, sizeof (BaobabChartPrivate));
	return baobab_chart_type_id;
}

GType
baobab_chart_get_type (void)
{
	static volatile gsize baobab_chart_type_id__once = 0;
	if (g_once_init_enter (&baobab_chart_type_id__once)) {
		GType baobab_chart_type_id;
		baobab_chart_type_id = baobab_chart_get_type_once ();
		g_once_init_leave (&baobab_chart_type_id__once, baobab_chart_type_id);
	}
	return baobab_chart_type_id__once;
}

static void
_vala_baobab_chart_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec)
{
	BaobabChart * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BAOBAB_TYPE_CHART, BaobabChart);
	switch (property_id) {
		case BAOBAB_CHART_LOCATION_PROPERTY:
		baobab_value_set_location (value, baobab_chart_get_location (self));
		break;
		case BAOBAB_CHART_MAX_DEPTH_PROPERTY:
		g_value_set_uint (value, baobab_chart_get_max_depth (self));
		break;
		case BAOBAB_CHART_MODEL_PROPERTY:
		g_value_set_object (value, baobab_chart_get_model (self));
		break;
		case BAOBAB_CHART_TREE_ROOT_PROPERTY:
		g_value_take_boxed (value, baobab_chart_get_tree_root (self));
		break;
		case BAOBAB_CHART_HIGHLIGHTED_ITEM_PROPERTY:
		baobab_value_set_chart_item (value, baobab_chart_get_highlighted_item (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_baobab_chart_set_property (GObject * object,
                                 guint property_id,
                                 const GValue * value,
                                 GParamSpec * pspec)
{
	BaobabChart * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BAOBAB_TYPE_CHART, BaobabChart);
	switch (property_id) {
		case BAOBAB_CHART_LOCATION_PROPERTY:
		baobab_chart_set_location (self, baobab_value_get_location (value));
		break;
		case BAOBAB_CHART_MAX_DEPTH_PROPERTY:
		baobab_chart_set_max_depth (self, g_value_get_uint (value));
		break;
		case BAOBAB_CHART_MODEL_PROPERTY:
		baobab_chart_set_model (self, g_value_get_object (value));
		break;
		case BAOBAB_CHART_TREE_ROOT_PROPERTY:
		baobab_chart_set_tree_root (self, g_value_get_boxed (value));
		break;
		case BAOBAB_CHART_HIGHLIGHTED_ITEM_PROPERTY:
		baobab_chart_set_highlighted_item (self, baobab_value_get_chart_item (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

