/* ============================================================
 *
 * This file is a part of digiKam project
 * https://www.digikam.org
 *
 * Date        : 2004-09-09
 * Description : digiKam release ID header.
 *
 * Copyright (C) 2004-2022 by Gilles Caulier <caulier dot gilles at gmail dot com>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

#ifndef DIGIKAM_VERSION_H
#define DIGIKAM_VERSION_H

// Qt includes

#include <QString>
#include <QDateTime>

// Local includes

#include "digikam_export.h"

namespace Digikam
{

static const char digikam_version_short[]  = "7.7.0";
static const char digikam_version[]        = "7.7.0";
static const char digikam_version_suffix[] = "";
static const char digikam_build_type[]     = "";

/**
 * Return the current digiKam version as string.
 */
DIGIKAM_EXPORT const QString digiKamVersion();

/**
 * Return al list of additional information about the current application build.
 */
DIGIKAM_EXPORT const QString additionalInformation();

/**
 * Return the UTC time-stamp of the current build.
 */
DIGIKAM_EXPORT const QDateTime digiKamBuildDate();

/**
 * Make an integer version number for comparison from a major, minor and
 * a patch version number.
 */
DIGIKAM_EXPORT int digiKamMakeIntegerVersion(int major, int minor, int patch);

} // namespace Digikam

#endif // DIGIKAM_VERSION_H
