# Imported via `make aws_managed_policies`
aws_managed_policies_data = """
{
 "APIGatewayServiceRolePolicy":{
  "CreateDate":"2017-10-20T17:23:10+00:00",
  "DefaultVersionId":"v9",
  "Document":{
   "Statement":[
    {
     "Action":[
      "elasticloadbalancing:AddListenerCertificates",
      "elasticloadbalancing:RemoveListenerCertificates",
      "elasticloadbalancing:ModifyListener",
      "elasticloadbalancing:DescribeListeners",
      "elasticloadbalancing:DescribeLoadBalancers",
      "xray:PutTraceSegments",
      "xray:PutTelemetryRecords",
      "xray:GetSamplingTargets",
      "xray:GetSamplingRules",
      "logs:CreateLogDelivery",
      "logs:GetLogDelivery",
      "logs:UpdateLogDelivery",
      "logs:DeleteLogDelivery",
      "logs:ListLogDeliveries",
      "servicediscovery:DiscoverInstances"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "firehose:DescribeDeliveryStream",
      "firehose:PutRecord",
      "firehose:PutRecordBatch"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:firehose:*:*:deliverystream/amazon-apigateway-*"
    },
    {
     "Action":[
      "acm:DescribeCertificate",
      "acm:GetCertificate"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:acm:*:*:certificate/*"
    },
    {
     "Action":"ec2:CreateNetworkInterfacePermission",
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:network-interface/*"
    },
    {
     "Action":"ec2:CreateTags",
     "Condition":{
      "ForAllValues:StringEquals":{
       "aws:TagKeys":[
        "Owner",
        "VpcLinkId"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:network-interface/*"
    },
    {
     "Action":[
      "ec2:ModifyNetworkInterfaceAttribute",
      "ec2:DeleteNetworkInterface",
      "ec2:AssignPrivateIpAddresses",
      "ec2:CreateNetworkInterface",
      "ec2:DeleteNetworkInterfacePermission",
      "ec2:DescribeNetworkInterfaces",
      "ec2:DescribeAvailabilityZones",
      "ec2:DescribeNetworkInterfaceAttribute",
      "ec2:DescribeVpcs",
      "ec2:DescribeNetworkInterfacePermissions",
      "ec2:UnassignPrivateIpAddresses",
      "ec2:DescribeSubnets",
      "ec2:DescribeRouteTables",
      "ec2:DescribeSecurityGroups"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"servicediscovery:GetNamespace",
     "Effect":"Allow",
     "Resource":"arn:aws:servicediscovery:*:*:namespace/*"
    },
    {
     "Action":"servicediscovery:GetService",
     "Effect":"Allow",
     "Resource":"arn:aws:servicediscovery:*:*:service/*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-07-12T22:24:40+00:00"
 },
 "AWSAccountActivityAccess":{
  "CreateDate":"2015-02-06T18:41:18+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "aws-portal:ViewBilling"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2015-02-06T18:41:18+00:00"
 },
 "AWSAccountManagementFullAccess":{
  "CreateDate":"2021-09-30T23:20:37+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":"account:*",
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-09-30T23:20:37+00:00"
 },
 "AWSAccountManagementReadOnlyAccess":{
  "CreateDate":"2021-09-30T23:29:53+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "account:Get*",
      "account:List*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-09-30T23:29:53+00:00"
 },
 "AWSAccountUsageReportAccess":{
  "CreateDate":"2015-02-06T18:41:19+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "aws-portal:ViewUsage"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2015-02-06T18:41:19+00:00"
 },
 "AWSAgentlessDiscoveryService":{
  "CreateDate":"2016-08-02T01:35:11+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "awsconnector:RegisterConnector",
      "awsconnector:GetConnectorHealth"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"iam:GetUser",
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "s3:GetObject",
      "s3:ListBucket"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::connector-platform-upgrade-info/*",
      "arn:aws:s3:::connector-platform-upgrade-info",
      "arn:aws:s3:::connector-platform-upgrade-bundles/*",
      "arn:aws:s3:::connector-platform-upgrade-bundles",
      "arn:aws:s3:::connector-platform-release-notes/*",
      "arn:aws:s3:::connector-platform-release-notes",
      "arn:aws:s3:::prod.agentless.discovery.connector.upgrade/*",
      "arn:aws:s3:::prod.agentless.discovery.connector.upgrade"
     ]
    },
    {
     "Action":[
      "s3:PutObject",
      "s3:PutObjectAcl"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::import-to-ec2-connector-debug-logs/*"
     ]
    },
    {
     "Action":[
      "SNS:Publish"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:sns:*:*:metrics-sns-topic-for-*"
    },
    {
     "Action":[
      "Discovery:*"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"Discovery"
    },
    {
     "Action":[
      "arsenal:RegisterOnPremisesAgent"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"arsenal"
    },
    {
     "Action":[
      "mgh:GetHomeRegion"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-02-24T23:08:23+00:00"
 },
 "AWSAppMeshEnvoyAccess":{
  "CreateDate":"2019-07-03T21:29:37+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "appmesh:StreamAggregatedResources"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-07-03T21:29:37+00:00"
 },
 "AWSAppMeshFullAccess":{
  "CreateDate":"2019-04-16T17:50:40+00:00",
  "DefaultVersionId":"v6",
  "Document":{
   "Statement":[
    {
     "Action":[
      "appmesh:*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "iam:CreateServiceLinkedRole"
     ],
     "Condition":{
      "StringLike":{
       "iam:AWSServiceName":[
        "appmesh.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/aws-service-role/appmesh.amazonaws.com/AWSServiceRoleForAppMesh"
    },
    {
     "Action":[
      "cloudformation:CreateStack",
      "cloudformation:DeleteStack",
      "cloudformation:DescribeStack*",
      "cloudformation:UpdateStack"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:cloudformation:*:*:stack/AWSAppMesh-GettingStarted-*"
    },
    {
     "Action":[
      "acm:ListCertificates",
      "acm:DescribeCertificate",
      "acm-pca:DescribeCertificateAuthority",
      "acm-pca:ListCertificateAuthorities"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "servicediscovery:ListNamespaces",
      "servicediscovery:ListServices",
      "servicediscovery:ListInstances"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-01-07T19:54:08+00:00"
 },
 "AWSAppMeshPreviewEnvoyAccess":{
  "CreateDate":"2019-08-05T23:32:39+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "appmesh-preview:StreamAggregatedResources"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-08-05T23:32:39+00:00"
 },
 "AWSAppMeshPreviewServiceRolePolicy":{
  "CreateDate":"2019-06-19T19:07:00+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "servicediscovery:DiscoverInstances"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CloudMapServiceDiscovery"
    },
    {
     "Action":[
      "acm:DescribeCertificate"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ACMCertificateVerification"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-08-21T21:06:29+00:00"
 },
 "AWSAppMeshReadOnly":{
  "CreateDate":"2019-04-16T17:51:11+00:00",
  "DefaultVersionId":"v5",
  "Document":{
   "Statement":[
    {
     "Action":[
      "appmesh:Describe*",
      "appmesh:List*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "cloudformation:DescribeStack*"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:cloudformation:*:*:stack/AWSAppMesh-GettingStarted-*"
    },
    {
     "Action":[
      "acm:ListCertificates",
      "acm:DescribeCertificate",
      "acm-pca:DescribeCertificateAuthority",
      "acm-pca:ListCertificateAuthorities"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "servicediscovery:ListNamespaces",
      "servicediscovery:ListServices",
      "servicediscovery:ListInstances"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-01-07T19:53:16+00:00"
 },
 "AWSAppMeshServiceRolePolicy":{
  "CreateDate":"2019-06-03T18:30:51+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "servicediscovery:DiscoverInstances"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CloudMapServiceDiscovery"
    },
    {
     "Action":[
      "acm:DescribeCertificate"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ACMCertificateVerification"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-09-10T22:44:43+00:00"
 },
 "AWSAppRunnerFullAccess":{
  "CreateDate":"2022-01-11T04:02:09+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringLike":{
       "iam:AWSServiceName":"apprunner.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/aws-service-role/apprunner.amazonaws.com/AWSServiceRoleForAppRunner"
    },
    {
     "Action":"iam:PassRole",
     "Condition":{
      "StringLike":{
       "iam:PassedToService":"apprunner.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"apprunner:*",
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AppRunnerAdminAccess"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-01-11T04:02:09+00:00"
 },
 "AWSAppRunnerReadOnlyAccess":{
  "CreateDate":"2022-02-24T21:24:15+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "apprunner:List*",
      "apprunner:Describe*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-02-24T21:24:15+00:00"
 },
 "AWSAppRunnerServicePolicyForECRAccess":{
  "CreateDate":"2021-05-14T19:17:21+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ecr:GetDownloadUrlForLayer",
      "ecr:BatchGetImage",
      "ecr:DescribeImages",
      "ecr:GetAuthorizationToken",
      "ecr:BatchCheckLayerAvailability"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-05-14T19:17:21+00:00"
 },
 "AWSAppSyncAdministrator":{
  "CreateDate":"2018-03-20T21:20:28+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "appsync:*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":[
        "appsync.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":"appsync.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "iam:DeleteServiceLinkedRole",
      "iam:GetServiceLinkedRoleDeletionStatus"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/aws-service-role/appsync.amazonaws.com/AWSServiceRoleForAppSync*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-11-04T19:23:49+00:00"
 },
 "AWSAppSyncInvokeFullAccess":{
  "CreateDate":"2018-03-20T21:21:20+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "appsync:GraphQL",
      "appsync:GetGraphqlApi",
      "appsync:ListGraphqlApis",
      "appsync:ListApiKeys"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2018-03-20T21:21:20+00:00"
 },
 "AWSAppSyncPushToCloudWatchLogs":{
  "CreateDate":"2018-04-09T19:38:55+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "logs:CreateLogGroup",
      "logs:CreateLogStream",
      "logs:PutLogEvents"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2018-04-09T19:38:55+00:00"
 },
 "AWSAppSyncSchemaAuthor":{
  "CreateDate":"2018-03-20T21:21:06+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "appsync:GraphQL",
      "appsync:CreateResolver",
      "appsync:CreateType",
      "appsync:DeleteResolver",
      "appsync:DeleteType",
      "appsync:GetResolver",
      "appsync:GetType",
      "appsync:GetDataSource",
      "appsync:GetSchemaCreationStatus",
      "appsync:GetIntrospectionSchema",
      "appsync:GetGraphqlApi",
      "appsync:ListTypes",
      "appsync:ListApiKeys",
      "appsync:ListResolvers",
      "appsync:ListDataSources",
      "appsync:ListGraphqlApis",
      "appsync:StartSchemaCreation",
      "appsync:UpdateResolver",
      "appsync:UpdateType"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2018-03-20T21:21:06+00:00"
 },
 "AWSAppSyncServiceRolePolicy":{
  "CreateDate":"2020-01-21T19:56:53+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "xray:PutTraceSegments",
      "xray:PutTelemetryRecords",
      "xray:GetSamplingTargets",
      "xray:GetSamplingRules",
      "xray:GetSamplingStatisticSummaries"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-01-21T19:56:53+00:00"
 },
 "AWSApplicationAutoScalingCustomResourcePolicy":{
  "CreateDate":"2018-06-04T23:22:44+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "execute-api:Invoke",
      "cloudwatch:PutMetricAlarm",
      "cloudwatch:DescribeAlarms",
      "cloudwatch:DeleteAlarms"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2018-06-04T23:22:44+00:00"
 },
 "AWSApplicationAutoscalingAppStreamFleetPolicy":{
  "CreateDate":"2017-10-20T19:04:06+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "appstream:UpdateFleet",
      "appstream:DescribeFleets",
      "cloudwatch:PutMetricAlarm",
      "cloudwatch:DescribeAlarms",
      "cloudwatch:DeleteAlarms"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2017-10-20T19:04:06+00:00"
 },
 "AWSApplicationAutoscalingCassandraTablePolicy":{
  "CreateDate":"2020-03-18T22:49:23+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":"cassandra:Select",
     "Effect":"Allow",
     "Resource":[
      "arn:*:cassandra:*:*:/keyspace/system/table/*",
      "arn:*:cassandra:*:*:/keyspace/system_schema/table/*",
      "arn:*:cassandra:*:*:/keyspace/system_schema_mcs/table/*"
     ]
    },
    {
     "Action":[
      "cassandra:Alter",
      "cloudwatch:PutMetricAlarm",
      "cloudwatch:DescribeAlarms",
      "cloudwatch:DeleteAlarms"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-03-18T22:49:23+00:00"
 },
 "AWSApplicationAutoscalingComprehendEndpointPolicy":{
  "CreateDate":"2019-11-14T18:39:07+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "comprehend:UpdateEndpoint",
      "comprehend:DescribeEndpoint",
      "cloudwatch:PutMetricAlarm",
      "cloudwatch:DescribeAlarms",
      "cloudwatch:DeleteAlarms"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-11-14T18:39:07+00:00"
 },
 "AWSApplicationAutoscalingDynamoDBTablePolicy":{
  "CreateDate":"2017-10-20T21:34:57+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "dynamodb:DescribeTable",
      "dynamodb:UpdateTable",
      "cloudwatch:PutMetricAlarm",
      "cloudwatch:DescribeAlarms",
      "cloudwatch:DeleteAlarms"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2017-10-20T21:34:57+00:00"
 },
 "AWSApplicationAutoscalingEC2SpotFleetRequestPolicy":{
  "CreateDate":"2017-10-25T18:23:27+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:DescribeSpotFleetRequests",
      "ec2:ModifySpotFleetRequest",
      "cloudwatch:PutMetricAlarm",
      "cloudwatch:DescribeAlarms",
      "cloudwatch:DeleteAlarms"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2017-10-25T18:23:27+00:00"
 },
 "AWSApplicationAutoscalingECSServicePolicy":{
  "CreateDate":"2017-10-25T23:53:08+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ecs:DescribeServices",
      "ecs:UpdateService",
      "cloudwatch:PutMetricAlarm",
      "cloudwatch:DescribeAlarms",
      "cloudwatch:DeleteAlarms"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2017-10-25T23:53:08+00:00"
 },
 "AWSApplicationAutoscalingEMRInstanceGroupPolicy":{
  "CreateDate":"2017-10-26T00:57:39+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "elasticmapreduce:ListInstanceGroups",
      "elasticmapreduce:ModifyInstanceGroups",
      "cloudwatch:PutMetricAlarm",
      "cloudwatch:DescribeAlarms",
      "cloudwatch:DeleteAlarms"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2017-10-26T00:57:39+00:00"
 },
 "AWSApplicationAutoscalingElastiCacheRGPolicy":{
  "CreateDate":"2021-08-17T23:41:42+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "elasticache:DescribeReplicationGroups",
      "elasticache:ModifyReplicationGroupShardConfiguration",
      "elasticache:IncreaseReplicaCount",
      "elasticache:DecreaseReplicaCount",
      "elasticache:DescribeCacheClusters",
      "elasticache:DescribeCacheParameters",
      "cloudwatch:DescribeAlarms"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "cloudwatch:PutMetricAlarm",
      "cloudwatch:DeleteAlarms"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:cloudwatch:*:*:alarm:TargetTracking*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-08-17T23:41:42+00:00"
 },
 "AWSApplicationAutoscalingKafkaClusterPolicy":{
  "CreateDate":"2020-08-24T18:36:01+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "kafka:DescribeCluster",
      "kafka:DescribeClusterOperation",
      "kafka:UpdateBrokerStorage",
      "cloudwatch:PutMetricAlarm",
      "cloudwatch:DescribeAlarms",
      "cloudwatch:DeleteAlarms"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-08-24T18:36:01+00:00"
 },
 "AWSApplicationAutoscalingLambdaConcurrencyPolicy":{
  "CreateDate":"2019-10-21T20:04:17+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "lambda:PutProvisionedConcurrencyConfig",
      "lambda:GetProvisionedConcurrencyConfig",
      "lambda:DeleteProvisionedConcurrencyConfig",
      "cloudwatch:PutMetricAlarm",
      "cloudwatch:DescribeAlarms",
      "cloudwatch:DeleteAlarms"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-10-21T20:04:17+00:00"
 },
 "AWSApplicationAutoscalingNeptuneClusterPolicy":{
  "CreateDate":"2021-09-02T21:14:55+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "rds:ListTagsForResource",
      "rds:DescribeDBInstances",
      "rds:DescribeDBClusters",
      "rds:DescribeDBClusterParameters",
      "cloudwatch:DescribeAlarms"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":"rds:AddTagsToResource",
     "Condition":{
      "StringEquals":{
       "rds:DatabaseEngine":"neptune"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:rds:*:*:db:autoscaled-reader*"
     ]
    },
    {
     "Action":"rds:CreateDBInstance",
     "Condition":{
      "StringEquals":{
       "rds:DatabaseEngine":"neptune"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:rds:*:*:db:autoscaled-reader*",
      "arn:aws:rds:*:*:cluster:*"
     ]
    },
    {
     "Action":[
      "rds:DeleteDBInstance"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:rds:*:*:db:autoscaled-reader*"
     ]
    },
    {
     "Action":[
      "cloudwatch:PutMetricAlarm",
      "cloudwatch:DeleteAlarms"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:cloudwatch:*:*:alarm:TargetTracking*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-09-02T21:14:55+00:00"
 },
 "AWSApplicationAutoscalingRDSClusterPolicy":{
  "CreateDate":"2017-10-17T17:46:56+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "rds:AddTagsToResource",
      "rds:CreateDBInstance",
      "rds:DeleteDBInstance",
      "rds:DescribeDBClusters",
      "rds:DescribeDBInstances",
      "rds:ModifyDBCluster",
      "cloudwatch:PutMetricAlarm",
      "cloudwatch:DescribeAlarms",
      "cloudwatch:DeleteAlarms"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringLike":{
       "iam:PassedToService":"rds.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2018-08-07T19:14:24+00:00"
 },
 "AWSApplicationAutoscalingSageMakerEndpointPolicy":{
  "CreateDate":"2018-02-06T19:58:21+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "sagemaker:DescribeEndpoint",
      "sagemaker:DescribeEndpointConfig",
      "sagemaker:UpdateEndpointWeightsAndCapacities",
      "cloudwatch:PutMetricAlarm",
      "cloudwatch:DescribeAlarms",
      "cloudwatch:DeleteAlarms"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2018-02-06T19:58:21+00:00"
 },
 "AWSApplicationDiscoveryAgentAccess":{
  "CreateDate":"2016-05-11T21:38:47+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "arsenal:RegisterOnPremisesAgent"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "mgh:GetHomeRegion"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-02-24T22:26:45+00:00"
 },
 "AWSApplicationDiscoveryServiceFullAccess":{
  "CreateDate":"2016-05-11T21:30:50+00:00",
  "DefaultVersionId":"v4",
  "Document":{
   "Statement":[
    {
     "Action":[
      "mgh:*",
      "discovery:*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "iam:GetRole"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":"continuousexport.discovery.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/aws-service-role/continuousexport.discovery.amazonaws.com/AWSServiceRoleForApplicationDiscoveryServiceContinuousExport*"
    },
    {
     "Action":[
      "iam:DeleteServiceLinkedRole",
      "iam:GetServiceLinkedRoleDeletionStatus"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/aws-service-role/continuousexport.discovery.amazonaws.com/AWSServiceRoleForApplicationDiscoveryServiceContinuousExport*"
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":[
        "migrationhub.amazonaws.com",
        "dmsintegration.migrationhub.amazonaws.com",
        "smsintegration.migrationhub.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-06-19T21:21:26+00:00"
 },
 "AWSApplicationMigrationAgentInstallationPolicy":{
  "CreateDate":"2022-06-19T07:51:04+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "mgn:GetAgentInstallationAssetsForMgn",
      "mgn:SendClientLogsForMgn",
      "mgn:RegisterAgentForMgn",
      "mgn:VerifyClientRoleForMgn"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "mgn:IssueClientCertificateForMgn"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:mgn:*:*:source-server/*"
    },
    {
     "Action":"mgn:TagResource",
     "Condition":{
      "StringEquals":{
       "mgn:CreateAction":"RegisterAgentForMgn"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:mgn:*:*:source-server/*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-06-19T07:51:04+00:00"
 },
 "AWSApplicationMigrationAgentPolicy":{
  "CreateDate":"2021-04-07T07:00:21+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "mgn:SendAgentMetricsForMgn",
      "mgn:SendAgentLogsForMgn",
      "mgn:SendClientLogsForMgn"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "mgn:RegisterAgentForMgn",
      "mgn:UpdateAgentSourcePropertiesForMgn",
      "mgn:UpdateAgentReplicationInfoForMgn",
      "mgn:UpdateAgentConversionInfoForMgn",
      "mgn:GetAgentInstallationAssetsForMgn",
      "mgn:GetAgentCommandForMgn",
      "mgn:GetAgentConfirmedResumeInfoForMgn",
      "mgn:GetAgentRuntimeConfigurationForMgn",
      "mgn:UpdateAgentBacklogForMgn",
      "mgn:GetAgentReplicationInfoForMgn"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"mgn:TagResource",
     "Effect":"Allow",
     "Resource":"arn:aws:mgn:*:*:source-server/*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-04-07T07:00:21+00:00"
 },
 "AWSApplicationMigrationAgentPolicy_v2":{
  "CreateDate":"2022-06-06T14:14:38+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "mgn:SendAgentMetricsForMgn",
      "mgn:SendAgentLogsForMgn",
      "mgn:UpdateAgentSourcePropertiesForMgn",
      "mgn:UpdateAgentReplicationInfoForMgn",
      "mgn:UpdateAgentConversionInfoForMgn",
      "mgn:GetAgentCommandForMgn",
      "mgn:GetAgentConfirmedResumeInfoForMgn",
      "mgn:GetAgentRuntimeConfigurationForMgn",
      "mgn:UpdateAgentBacklogForMgn",
      "mgn:GetAgentReplicationInfoForMgn",
      "mgn:IssueClientCertificateForMgn"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:mgn:*:*:source-server/${aws:SourceIdentity}"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-06-06T14:14:38+00:00"
 },
 "AWSApplicationMigrationConversionServerPolicy":{
  "CreateDate":"2021-04-07T06:48:58+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "mgn:SendClientMetricsForMgn",
      "mgn:SendClientLogsForMgn",
      "mgn:GetChannelCommandsForMgn",
      "mgn:SendChannelCommandResultForMgn"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-04-07T06:48:58+00:00"
 },
 "AWSApplicationMigrationEC2Access":{
  "CreateDate":"2021-04-07T07:05:22+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":"iam:PassRole",
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":"ec2.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/service-role/AWSApplicationMigrationConversionServerRole"
     ]
    },
    {
     "Action":[
      "ec2:DeleteSnapshot"
     ],
     "Condition":{
      "Bool":{
       "aws:ViaAWSService":"true"
      },
      "Null":{
       "aws:ResourceTag/AWSApplicationMigrationServiceManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:snapshot/*"
    },
    {
     "Action":[
      "ec2:CreateLaunchTemplateVersion",
      "ec2:ModifyLaunchTemplate",
      "ec2:DeleteLaunchTemplateVersions"
     ],
     "Condition":{
      "Null":{
       "aws:ResourceTag/AWSApplicationMigrationServiceManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:launch-template/*"
    },
    {
     "Action":[
      "ec2:DeleteVolume"
     ],
     "Condition":{
      "Bool":{
       "aws:ViaAWSService":"true"
      },
      "Null":{
       "aws:ResourceTag/AWSApplicationMigrationServiceManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:volume/*"
    },
    {
     "Action":[
      "ec2:StartInstances",
      "ec2:StopInstances",
      "ec2:TerminateInstances",
      "ec2:ModifyInstanceAttribute",
      "ec2:GetConsoleOutput",
      "ec2:GetConsoleScreenshot"
     ],
     "Condition":{
      "Bool":{
       "aws:ViaAWSService":"true"
      },
      "Null":{
       "aws:ResourceTag/AWSApplicationMigrationServiceManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:instance/*"
    },
    {
     "Action":[
      "ec2:RevokeSecurityGroupEgress",
      "ec2:AuthorizeSecurityGroupIngress",
      "ec2:AuthorizeSecurityGroupEgress"
     ],
     "Condition":{
      "Bool":{
       "aws:ViaAWSService":"true"
      },
      "Null":{
       "aws:ResourceTag/AWSApplicationMigrationServiceManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:security-group/*"
    },
    {
     "Action":[
      "ec2:CreateVolume"
     ],
     "Condition":{
      "Bool":{
       "aws:ViaAWSService":"true"
      },
      "Null":{
       "aws:RequestTag/AWSApplicationMigrationServiceManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:volume/*"
    },
    {
     "Action":"ec2:CreateSecurityGroup",
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:vpc/*"
    },
    {
     "Action":[
      "ec2:CreateSecurityGroup"
     ],
     "Condition":{
      "Bool":{
       "aws:ViaAWSService":"true"
      },
      "Null":{
       "aws:RequestTag/AWSApplicationMigrationServiceManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:security-group/*"
    },
    {
     "Action":[
      "ec2:CreateSnapshot"
     ],
     "Condition":{
      "Bool":{
       "aws:ViaAWSService":"true"
      },
      "Null":{
       "ec2:ResourceTag/AWSApplicationMigrationServiceManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:volume/*"
    },
    {
     "Action":[
      "ec2:CreateSnapshot"
     ],
     "Condition":{
      "Bool":{
       "aws:ViaAWSService":"true"
      },
      "Null":{
       "aws:RequestTag/AWSApplicationMigrationServiceManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:snapshot/*"
    },
    {
     "Action":[
      "ec2:DetachVolume",
      "ec2:AttachVolume"
     ],
     "Condition":{
      "Bool":{
       "aws:ViaAWSService":"true"
      },
      "Null":{
       "ec2:ResourceTag/AWSApplicationMigrationServiceManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:instance/*"
    },
    {
     "Action":[
      "ec2:AttachVolume"
     ],
     "Condition":{
      "Bool":{
       "aws:ViaAWSService":"true"
      },
      "Null":{
       "ec2:ResourceTag/AWSApplicationMigrationServiceManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:volume/*"
    },
    {
     "Action":[
      "ec2:DetachVolume"
     ],
     "Condition":{
      "Bool":{
       "aws:ViaAWSService":"true"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:volume/*"
    },
    {
     "Action":[
      "ec2:RunInstances"
     ],
     "Condition":{
      "Bool":{
       "aws:ViaAWSService":"true"
      },
      "Null":{
       "aws:RequestTag/AWSApplicationMigrationServiceManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:instance/*"
    },
    {
     "Action":[
      "ec2:RunInstances"
     ],
     "Condition":{
      "Bool":{
       "aws:ViaAWSService":"true"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:security-group/*",
      "arn:aws:ec2:*:*:volume/*",
      "arn:aws:ec2:*:*:subnet/*",
      "arn:aws:ec2:*:*:image/*",
      "arn:aws:ec2:*:*:network-interface/*",
      "arn:aws:ec2:*:*:launch-template/*"
     ]
    },
    {
     "Action":"ec2:CreateTags",
     "Condition":{
      "Bool":{
       "aws:ViaAWSService":"true"
      },
      "StringEquals":{
       "ec2:CreateAction":[
        "CreateSecurityGroup",
        "CreateVolume",
        "CreateSnapshot",
        "RunInstances"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:security-group/*",
      "arn:aws:ec2:*:*:volume/*",
      "arn:aws:ec2:*:*:snapshot/*",
      "arn:aws:ec2:*:*:instance/*"
     ]
    },
    {
     "Action":[
      "ec2:CreateTags",
      "ec2:ModifyVolume"
     ],
     "Condition":{
      "Bool":{
       "aws:ViaAWSService":"true"
      },
      "Null":{
       "ec2:ResourceTag/AWSApplicationMigrationServiceManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:volume/*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-03-02T08:49:20+00:00"
 },
 "AWSApplicationMigrationFullAccess":{
  "CreateDate":"2021-04-07T06:56:05+00:00",
  "DefaultVersionId":"v4",
  "Document":{
   "Statement":[
    {
     "Action":[
      "mgn:*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "kms:ListAliases",
      "kms:DescribeKey"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:DescribeKeyPairs",
      "ec2:DescribeTags",
      "ec2:DescribeNetworkInterfaces",
      "ec2:DescribePlacementGroups",
      "ec2:DescribeAccountAttributes",
      "ec2:DescribeAvailabilityZones",
      "ec2:DescribeImages",
      "ec2:DescribeInstances",
      "ec2:DescribeInstanceTypes",
      "ec2:DescribeInstanceAttribute",
      "ec2:DescribeInstanceStatus",
      "ec2:DescribeInstanceTypeOfferings",
      "ec2:DescribeLaunchTemplateVersions",
      "ec2:DescribeLaunchTemplates",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeSnapshots",
      "ec2:DescribeSubnets",
      "ec2:DescribeVolumes",
      "ec2:GetEbsEncryptionByDefault",
      "ec2:GetEbsDefaultKmsKeyId"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"license-manager:ListLicenseConfigurations",
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"elasticloadbalancing:DescribeLoadBalancers",
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"iam:ListInstanceProfiles",
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"iam:PassRole",
     "Condition":{
      "Bool":{
       "aws:ViaAWSService":"true"
      },
      "StringEquals":{
       "iam:PassedToService":"ec2.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/service-role/AWSApplicationMigrationLaunchInstanceWithSsmRole",
      "arn:aws:iam::*:role/service-role/AWSApplicationMigrationLaunchInstanceWithDrsRole"
     ]
    },
    {
     "Action":[
      "drs:DescribeSourceServers"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ssm:SendCommand"
     ],
     "Condition":{
      "Bool":{
       "aws:ViaAWSService":"true"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ssm:*:*:document/AWSDisasterRecovery-InstallDRAgentOnInstance",
      "arn:aws:ssm:*:*:document/AWSMigration-ConvertCentOsToRockyLinuxDistribution",
      "arn:aws:ssm:*:*:document/AWSMigration-ReplaceSuseSubscriptionWithAwsSubscription"
     ]
    },
    {
     "Action":[
      "ssm:SendCommand"
     ],
     "Condition":{
      "Bool":{
       "aws:ViaAWSService":"true"
      },
      "Null":{
       "aws:ResourceTag/AWSApplicationMigrationServiceManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:instance/*"
     ]
    },
    {
     "Action":[
      "ssm:ListCommandInvocations"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ssm:DescribeInstanceInformation",
      "ssm:GetCommandInvocation"
     ],
     "Condition":{
      "Bool":{
       "aws:ViaAWSService":"true"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ssm:DescribeDocument"
     ],
     "Condition":{
      "Bool":{
       "aws:ViaAWSService":"true"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ssm:*:*:document/AWSDisasterRecovery-InstallDRAgentOnInstance",
      "arn:aws:ssm:*:*:document/AWSMigration-ConvertCentOsToRockyLinuxDistribution",
      "arn:aws:ssm:*:*:document/AWSMigration-ReplaceSuseSubscriptionWithAwsSubscription"
     ]
    },
    {
     "Action":[
      "ssm:GetParameter",
      "ssm:PutParameter"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:ssm:*:*:parameter/ManagedByAWSApplicationMigrationService-*"
    },
    {
     "Action":[
      "servicequotas:GetServiceQuota"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-05-31T21:14:49+00:00"
 },
 "AWSApplicationMigrationMGHAccess":{
  "CreateDate":"2021-04-07T07:10:01+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "mgh:AssociateCreatedArtifact",
      "mgh:CreateProgressUpdateStream",
      "mgh:DisassociateCreatedArtifact",
      "mgh:GetHomeRegion",
      "mgh:ImportMigrationTask",
      "mgh:NotifyMigrationTaskState",
      "mgh:PutResourceAttributes"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-04-07T07:10:01+00:00"
 },
 "AWSApplicationMigrationReadOnlyAccess":{
  "CreateDate":"2021-04-07T07:15:26+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "mgn:DescribeJobLogItems",
      "mgn:DescribeJobs",
      "mgn:DescribeSourceServers",
      "mgn:DescribeReplicationConfigurationTemplates",
      "mgn:GetLaunchConfiguration",
      "mgn:DescribeVcenterClients",
      "mgn:GetReplicationConfiguration"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:DescribeInstances",
      "ec2:DescribeLaunchTemplateVersions",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeSubnets"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "servicequotas:GetServiceQuota"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-05-01T08:32:53+00:00"
 },
 "AWSApplicationMigrationReplicationServerPolicy":{
  "CreateDate":"2021-04-07T07:21:57+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "mgn:SendClientMetricsForMgn",
      "mgn:SendClientLogsForMgn",
      "mgn:GetChannelCommandsForMgn",
      "mgn:SendChannelCommandResultForMgn",
      "mgn:GetAgentSnapshotCreditsForMgn",
      "mgn:DescribeReplicationServerAssociationsForMgn",
      "mgn:DescribeSnapshotRequestsForMgn",
      "mgn:BatchDeleteSnapshotRequestForMgn",
      "mgn:NotifyAgentAuthenticationForMgn",
      "mgn:BatchCreateVolumeSnapshotGroupForMgn",
      "mgn:UpdateAgentReplicationProcessStateForMgn",
      "mgn:NotifyAgentReplicationProgressForMgn",
      "mgn:NotifyAgentConnectedForMgn",
      "mgn:NotifyAgentDisconnectedForMgn"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:DescribeInstances",
      "ec2:DescribeSnapshots"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:CreateSnapshot"
     ],
     "Condition":{
      "Null":{
       "aws:ResourceTag/AWSApplicationMigrationServiceManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:volume/*"
    },
    {
     "Action":[
      "ec2:CreateSnapshot"
     ],
     "Condition":{
      "Null":{
       "aws:RequestTag/AWSApplicationMigrationServiceManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:snapshot/*"
    },
    {
     "Action":"ec2:CreateTags",
     "Condition":{
      "StringEquals":{
       "ec2:CreateAction":"CreateSnapshot"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-04-07T07:21:57+00:00"
 },
 "AWSApplicationMigrationServiceRolePolicy":{
  "CreateDate":"2021-04-07T06:43:20+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":"mgn:ListTagsForResource",
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"kms:ListRetirableGrants",
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "mgh:AssociateCreatedArtifact",
      "mgh:CreateProgressUpdateStream",
      "mgh:DisassociateCreatedArtifact",
      "mgh:GetHomeRegion",
      "mgh:ImportMigrationTask",
      "mgh:NotifyMigrationTaskState",
      "mgh:PutResourceAttributes"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:DescribeAccountAttributes",
      "ec2:DescribeAvailabilityZones",
      "ec2:DescribeImages",
      "ec2:DescribeInstances",
      "ec2:DescribeInstanceTypes",
      "ec2:DescribeInstanceAttribute",
      "ec2:DescribeInstanceStatus",
      "ec2:DescribeLaunchTemplateVersions",
      "ec2:DescribeLaunchTemplates",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeSnapshots",
      "ec2:DescribeSubnets",
      "ec2:DescribeVolumes",
      "ec2:GetEbsDefaultKmsKeyId",
      "ec2:GetEbsEncryptionByDefault"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:RegisterImage",
      "ec2:DeregisterImage"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:DeleteSnapshot"
     ],
     "Condition":{
      "Null":{
       "aws:ResourceTag/AWSApplicationMigrationServiceManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:snapshot/*"
    },
    {
     "Action":[
      "ec2:CreateLaunchTemplateVersion",
      "ec2:ModifyLaunchTemplate",
      "ec2:DeleteLaunchTemplate",
      "ec2:DeleteLaunchTemplateVersions"
     ],
     "Condition":{
      "Null":{
       "aws:ResourceTag/AWSApplicationMigrationServiceManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:launch-template/*"
    },
    {
     "Action":[
      "ec2:DeleteVolume"
     ],
     "Condition":{
      "Null":{
       "aws:ResourceTag/AWSApplicationMigrationServiceManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:volume/*"
    },
    {
     "Action":[
      "ec2:StartInstances",
      "ec2:StopInstances",
      "ec2:TerminateInstances",
      "ec2:ModifyInstanceAttribute",
      "ec2:GetConsoleOutput",
      "ec2:GetConsoleScreenshot"
     ],
     "Condition":{
      "Null":{
       "aws:ResourceTag/AWSApplicationMigrationServiceManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:instance/*"
    },
    {
     "Action":[
      "ec2:RevokeSecurityGroupEgress",
      "ec2:AuthorizeSecurityGroupIngress",
      "ec2:AuthorizeSecurityGroupEgress"
     ],
     "Condition":{
      "Null":{
       "aws:ResourceTag/AWSApplicationMigrationServiceManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:security-group/*"
    },
    {
     "Action":[
      "ec2:CreateVolume"
     ],
     "Condition":{
      "Null":{
       "aws:RequestTag/AWSApplicationMigrationServiceManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:volume/*"
    },
    {
     "Action":[
      "ec2:CreateSecurityGroup"
     ],
     "Condition":{
      "Null":{
       "aws:RequestTag/AWSApplicationMigrationServiceManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:security-group/*"
    },
    {
     "Action":[
      "ec2:CreateSecurityGroup"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:vpc/*"
    },
    {
     "Action":[
      "ec2:CreateLaunchTemplate"
     ],
     "Condition":{
      "Null":{
       "aws:RequestTag/AWSApplicationMigrationServiceManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:launch-template/*"
    },
    {
     "Action":[
      "ec2:CreateSnapshot"
     ],
     "Condition":{
      "Null":{
       "ec2:ResourceTag/AWSApplicationMigrationServiceManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:volume/*"
    },
    {
     "Action":[
      "ec2:CreateSnapshot"
     ],
     "Condition":{
      "Null":{
       "aws:RequestTag/AWSApplicationMigrationServiceManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:snapshot/*"
    },
    {
     "Action":[
      "ec2:DetachVolume",
      "ec2:AttachVolume"
     ],
     "Condition":{
      "Null":{
       "ec2:ResourceTag/AWSApplicationMigrationServiceManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:instance/*"
    },
    {
     "Action":[
      "ec2:AttachVolume"
     ],
     "Condition":{
      "Null":{
       "ec2:ResourceTag/AWSApplicationMigrationServiceManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:volume/*"
    },
    {
     "Action":[
      "ec2:DetachVolume"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:volume/*"
    },
    {
     "Action":[
      "ec2:RunInstances"
     ],
     "Condition":{
      "Null":{
       "aws:RequestTag/AWSApplicationMigrationServiceManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:instance/*"
    },
    {
     "Action":[
      "ec2:RunInstances"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:security-group/*",
      "arn:aws:ec2:*:*:volume/*",
      "arn:aws:ec2:*:*:subnet/*",
      "arn:aws:ec2:*:*:image/*",
      "arn:aws:ec2:*:*:network-interface/*",
      "arn:aws:ec2:*:*:launch-template/*"
     ]
    },
    {
     "Action":"iam:PassRole",
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":"ec2.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/service-role/AWSApplicationMigrationReplicationServerRole",
      "arn:aws:iam::*:role/service-role/AWSApplicationMigrationConversionServerRole"
     ]
    },
    {
     "Action":"ec2:CreateTags",
     "Condition":{
      "StringEquals":{
       "ec2:CreateAction":[
        "CreateLaunchTemplate",
        "CreateSecurityGroup",
        "CreateVolume",
        "CreateSnapshot",
        "RunInstances"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:launch-template/*",
      "arn:aws:ec2:*:*:security-group/*",
      "arn:aws:ec2:*:*:volume/*",
      "arn:aws:ec2:*:*:snapshot/*",
      "arn:aws:ec2:*:*:instance/*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-04-07T06:43:20+00:00"
 },
 "AWSApplicationMigrationVCenterClientPolicy":{
  "CreateDate":"2021-11-08T12:53:08+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "mgn:CreateVcenterClientForMgn",
      "mgn:DescribeVcenterClients"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "mgn:GetVcenterClientCommandsForMgn",
      "mgn:SendVcenterClientCommandResultForMgn",
      "mgn:SendVcenterClientLogsForMgn",
      "mgn:SendVcenterClientMetricsForMgn",
      "mgn:DeleteVcenterClient",
      "mgn:TagResource",
      "mgn:NotifyVcenterClientStartedForMgn"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:mgn:*:*:vcenter-client/*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-11-08T12:53:08+00:00"
 },
 "AWSArtifactAccountSync":{
  "CreateDate":"2018-04-10T23:04:33+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "organizations:ListAccounts",
      "organizations:DescribeOrganization"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2018-04-10T23:04:33+00:00"
 },
 "AWSAuditManagerAdministratorAccess":{
  "CreateDate":"2020-12-11T20:02:42+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "auditmanager:*"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AuditManagerAccess"
    },
    {
     "Action":[
      "organizations:ListAccountsForParent",
      "organizations:ListAccounts",
      "organizations:DescribeOrganization",
      "organizations:DescribeOrganizationalUnit",
      "organizations:DescribeAccount",
      "organizations:ListParents",
      "organizations:ListChildren"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"OrganizationsAccess"
    },
    {
     "Action":[
      "organizations:RegisterDelegatedAdministrator",
      "organizations:DeregisterDelegatedAdministrator",
      "organizations:EnableAWSServiceAccess"
     ],
     "Condition":{
      "StringLikeIfExists":{
       "organizations:ServicePrincipal":[
        "auditmanager.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AllowOnlyAuditManagerIntegration"
    },
    {
     "Action":[
      "iam:GetUser",
      "iam:ListUsers",
      "iam:ListRoles"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"IAMAccess"
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringLike":{
       "iam:AWSServiceName":"auditmanager.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/aws-service-role/auditmanager.amazonaws.com/AWSServiceRoleForAuditManager*",
     "Sid":"IAMAccessCreateSLR"
    },
    {
     "Action":[
      "iam:DeleteServiceLinkedRole",
      "iam:UpdateRoleDescription",
      "iam:GetServiceLinkedRoleDeletionStatus"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/aws-service-role/auditmanager.amazonaws.com/AWSServiceRoleForAuditManager*",
     "Sid":"IAMAccessManageSLR"
    },
    {
     "Action":[
      "s3:ListAllMyBuckets"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"S3Access"
    },
    {
     "Action":[
      "kms:DescribeKey",
      "kms:ListKeys",
      "kms:ListAliases"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"KmsAccess"
    },
    {
     "Action":[
      "kms:CreateGrant"
     ],
     "Condition":{
      "Bool":{
       "kms:GrantIsForAWSResource":"true"
      },
      "StringLike":{
       "kms:ViaService":"auditmanager.*.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"KmsCreateGrantAccess"
    },
    {
     "Action":[
      "sns:ListTopics"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"SNSAccess"
    },
    {
     "Action":[
      "events:PutRule"
     ],
     "Condition":{
      "ForAllValues:StringEquals":{
       "events:source":[
        "aws.securityhub"
       ]
      },
      "StringEquals":{
       "events:detail-type":"Security Hub Findings - Imported"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CreateEventsAccess"
    },
    {
     "Action":[
      "events:DeleteRule",
      "events:DescribeRule",
      "events:EnableRule",
      "events:DisableRule",
      "events:ListTargetsByRule",
      "events:PutTargets",
      "events:RemoveTargets"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:events:*:*:rule/AuditManagerSecurityHubFindingsReceiver",
     "Sid":"EventsAccess"
    },
    {
     "Action":[
      "tag:GetResources"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"TagAccess"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-04-30T00:02:56+00:00"
 },
 "AWSAuditManagerServiceRolePolicy":{
  "CreateDate":"2020-12-08T15:12:12+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "license-manager:ListLicenseConfigurations",
      "license-manager:ListAssociationsForLicenseConfiguration",
      "license-manager:ListUsageForLicenseConfiguration"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"LicenseManagerAccess"
    },
    {
     "Action":[
      "iam:GenerateCredentialReport",
      "iam:GetAccountSummary",
      "iam:ListPolicies",
      "iam:GetAccountPasswordPolicy",
      "iam:ListUsers",
      "iam:ListUserPolicies",
      "iam:ListRoles",
      "iam:ListRolePolicies",
      "iam:ListGroups",
      "iam:ListGroupPolicies",
      "iam:ListEntitiesForPolicy"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"IAMAccess"
    },
    {
     "Action":[
      "ec2:DescribeInstances",
      "ec2:DescribeFlowLogs",
      "ec2:DescribeVpcs",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeNetworkAcls",
      "ec2:DescribeRouteTables",
      "ec2:DescribeSnapshots",
      "ec2:DescribeVpcEndpoints"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"EC2Access"
    },
    {
     "Action":[
      "cloudtrail:DescribeTrails"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CloudtrailAccess"
    },
    {
     "Action":[
      "config:DescribeDeliveryChannels",
      "config:ListDiscoveredResources",
      "config:DescribeConfigRules"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ConfigAccess"
    },
    {
     "Action":[
      "securityhub:DescribeStandards"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"SecurityHubAccess"
    },
    {
     "Action":[
      "kms:ListKeys",
      "kms:DescribeKey",
      "kms:ListGrants"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"KMSAccess"
    },
    {
     "Action":[
      "cloudwatch:DescribeAlarms"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CloudwatchAccess"
    },
    {
     "Action":[
      "s3:GetLifecycleConfiguration"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"S3Access"
    },
    {
     "Action":[
      "events:DescribeRule"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"EventBridgeAccess"
    },
    {
     "Action":[
      "waf:ListActivatedRulesInRuleGroup"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"WAFAccess"
    },
    {
     "Action":[
      "guardduty:ListDetectors"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"GuardDutyAccess"
    },
    {
     "Action":[
      "route53:GetQueryLoggingConfig"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"Route53Access"
    },
    {
     "Action":[
      "organizations:DescribePolicy",
      "organizations:DescribeOrganization"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"OrganizationsAccess"
    },
    {
     "Action":[
      "cognito-idp:DescribeUserPool"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CognitoAccess"
    },
    {
     "Action":[
      "elasticfilesystem:DescribeFileSystems"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"EFSAccess"
    },
    {
     "Action":[
      "events:PutRule"
     ],
     "Condition":{
      "ForAllValues:StringEquals":{
       "events:source":[
        "aws.securityhub"
       ]
      },
      "Null":{
       "events:source":"false"
      },
      "StringEquals":{
       "events:detail-type":"Security Hub Findings - Imported"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:events:*:*:rule/AuditManagerSecurityHubFindingsReceiver",
     "Sid":"CreateEventsAccess"
    },
    {
     "Action":[
      "events:DeleteRule",
      "events:DescribeRule",
      "events:EnableRule",
      "events:DisableRule",
      "events:ListTargetsByRule",
      "events:PutTargets",
      "events:RemoveTargets"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:events:*:*:rule/AuditManagerSecurityHubFindingsReceiver",
     "Sid":"EventsAccess"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-05-20T16:26:09+00:00"
 },
 "AWSAutoScalingPlansEC2AutoScalingPolicy":{
  "CreateDate":"2018-08-23T22:46:59+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cloudwatch:GetMetricData",
      "autoscaling:DescribeAutoScalingGroups",
      "autoscaling:DescribeScheduledActions",
      "autoscaling:BatchPutScheduledUpdateGroupAction",
      "autoscaling:BatchDeleteScheduledAction"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2018-08-23T22:46:59+00:00"
 },
 "AWSBackupAuditAccess":{
  "CreateDate":"2021-08-24T01:02:23+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "backup:CreateFramework",
      "backup:UpdateFramework",
      "backup:ListFrameworks",
      "backup:DescribeFramework",
      "backup:DeleteFramework",
      "backup:ListBackupPlans",
      "backup:ListBackupVaults",
      "backup:CreateReportPlan",
      "backup:UpdateReportPlan",
      "backup:ListReportPlans",
      "backup:DescribeReportPlan",
      "backup:DeleteReportPlan",
      "backup:StartReportJob",
      "backup:ListReportJobs",
      "backup:DescribeReportJob"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "config:DescribeConfigurationRecorders",
      "config:DescribeConfigurationRecorderStatus"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "config:DescribeComplianceByConfigRule",
      "config:GetComplianceDetailsByConfigRule"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:config:*:*:config-rule/*"
    },
    {
     "Action":[
      "s3:ListAllMyBuckets",
      "s3:GetBucketLocation"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-08-24T01:02:23+00:00"
 },
 "AWSBackupFullAccess":{
  "CreateDate":"2019-11-18T22:21:52+00:00",
  "DefaultVersionId":"v11",
  "Document":{
   "Statement":[
    {
     "Action":"backup:*",
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"backup-storage:*",
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "rds:DescribeDBSnapshots",
      "rds:ListTagsForResource",
      "rds:DescribeDBInstances",
      "rds:describeDBEngineVersions",
      "rds:describeOptionGroups",
      "rds:describeOrderableDBInstanceOptions",
      "rds:describeDBSubnetGroups",
      "rds:describeDBClusterSnapshots",
      "rds:describeDBClusters",
      "rds:describeDBParameterGroups",
      "rds:DescribeDBClusterParameterGroups",
      "rds:DescribeDBInstanceAutomatedBackups"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "rds:DeleteDBSnapshot",
      "rds:DeleteDBClusterSnapshot"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:CalledVia":[
        "backup.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "dynamodb:ListBackups",
      "dynamodb:ListTables"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "dynamodb:DeleteBackup"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:CalledVia":[
        "backup.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "elasticfilesystem:DescribeFilesystems"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:elasticfilesystem:*:*:file-system/*"
    },
    {
     "Action":[
      "ec2:DescribeSnapshots",
      "ec2:DescribeVolumes",
      "ec2:describeAvailabilityZones",
      "ec2:DescribeVpcs",
      "ec2:DescribeAccountAttributes",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeImages",
      "ec2:DescribeSubnets",
      "ec2:DescribePlacementGroups",
      "ec2:DescribeInstances",
      "ec2:DescribeInstanceTypes",
      "ec2:DescribeVpcEndpoints"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:DeleteSnapshot",
      "ec2:DeregisterImage"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:CalledVia":[
        "backup.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "tag:GetTagKeys",
      "tag:GetTagValues",
      "tag:GetResources"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "storagegateway:DescribeCachediSCSIVolumes",
      "storagegateway:DescribeStorediSCSIVolumes"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:storagegateway:*:*:gateway/*/volume/*"
    },
    {
     "Action":[
      "storagegateway:ListGateways"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:storagegateway:*:*:*"
    },
    {
     "Action":[
      "storagegateway:DescribeGatewayInformation",
      "storagegateway:ListVolumes",
      "storagegateway:ListLocalDisks"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:storagegateway:*:*:gateway/*"
    },
    {
     "Action":[
      "iam:ListRoles",
      "iam:GetRole"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"iam:PassRole",
     "Condition":{
      "StringLike":{
       "iam:PassedToService":"backup.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/*AwsBackup*",
      "arn:aws:iam::*:role/*AWSBackup*"
     ]
    },
    {
     "Action":"organizations:DescribeOrganization",
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "kms:ListKeys",
      "kms:DescribeKey",
      "kms:GenerateDataKey",
      "kms:ListAliases"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "kms:CreateGrant"
     ],
     "Condition":{
      "Bool":{
       "kms:GrantIsForAWSResource":true
      },
      "ForAnyValue:StringEquals":{
       "kms:EncryptionContextKeys":"aws:backup:backup-vault"
      },
      "StringLike":{
       "kms:ViaService":"backup.*.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ssm:CancelCommand",
      "ssm:GetCommandInvocation"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"ssm:SendCommand",
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ssm:*:*:document/AWSEC2-CreateVssSnapshot",
      "arn:aws:ec2:*:*:instance/*"
     ]
    },
    {
     "Action":"fsx:DescribeFileSystems",
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"fsx:DescribeBackups",
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"fsx:DescribeVolumes",
     "Effect":"Allow",
     "Resource":"arn:aws:fsx:*:*:volume/*/*"
    },
    {
     "Action":"fsx:DescribeStorageVirtualMachines",
     "Effect":"Allow",
     "Resource":"arn:aws:fsx:*:*:storage-virtual-machine/*/*"
    },
    {
     "Action":"fsx:DeleteBackup",
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:CalledVia":[
        "backup.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:fsx:*:*:backup/*"
    },
    {
     "Action":"ds:DescribeDirectories",
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":"backup.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "backup-gateway:AssociateGatewayToServer",
      "backup-gateway:CreateGateway",
      "backup-gateway:DeleteGateway",
      "backup-gateway:DeleteHypervisor",
      "backup-gateway:DisassociateGatewayFromServer",
      "backup-gateway:ImportHypervisorConfiguration",
      "backup-gateway:ListGateways",
      "backup-gateway:ListHypervisors",
      "backup-gateway:ListTagsForResource",
      "backup-gateway:ListVirtualMachines",
      "backup-gateway:PutMaintenanceStartTime",
      "backup-gateway:TagResource",
      "backup-gateway:TestHypervisorConfiguration",
      "backup-gateway:UntagResource",
      "backup-gateway:UpdateGatewayInformation",
      "backup-gateway:UpdateHypervisor"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"backup-gateway:GetGateway",
     "Effect":"Allow",
     "Resource":"arn:aws:backup-gateway:*:*:gateway/*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-06-01T17:36:04+00:00"
 },
 "AWSBackupOperatorAccess":{
  "CreateDate":"2019-11-18T22:23:17+00:00",
  "DefaultVersionId":"v10",
  "Document":{
   "Statement":[
    {
     "Action":[
      "backup:Get*",
      "backup:List*",
      "backup:Describe*",
      "backup:CreateBackupSelection",
      "backup:DeleteBackupSelection",
      "backup:StartBackupJob",
      "backup:StartRestoreJob",
      "backup:StartCopyJob"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "rds:DescribeDBSnapshots",
      "rds:ListTagsForResource",
      "rds:DescribeDBInstances",
      "rds:describeDBEngineVersions",
      "rds:describeOptionGroups",
      "rds:describeOrderableDBInstanceOptions",
      "rds:describeDBSubnetGroups",
      "rds:DescribeDBClusterSnapshots",
      "rds:DescribeDBClusters",
      "rds:DescribeDBParameterGroups",
      "rds:DescribeDBClusterParameterGroups",
      "rds:DescribeDBInstanceAutomatedBackups"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "dynamodb:ListBackups",
      "dynamodb:ListTables"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "elasticfilesystem:DescribeFilesystems"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:elasticfilesystem:*:*:file-system/*"
    },
    {
     "Action":[
      "ec2:DescribeSnapshots",
      "ec2:DescribeVolumes",
      "ec2:describeAvailabilityZones",
      "ec2:DescribeVpcs",
      "ec2:DescribeAccountAttributes",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeImages",
      "ec2:DescribeSubnets",
      "ec2:DescribePlacementGroups",
      "ec2:DescribeInstances",
      "ec2:DescribeInstanceTypes",
      "ec2:DescribeVpcEndpoints"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "tag:GetTagKeys",
      "tag:GetTagValues",
      "tag:GetResources"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "storagegateway:DescribeCachediSCSIVolumes",
      "storagegateway:DescribeStorediSCSIVolumes"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:storagegateway:*:*:gateway/*/volume/*"
    },
    {
     "Action":[
      "storagegateway:ListGateways"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:storagegateway:*:*:*"
    },
    {
     "Action":[
      "storagegateway:DescribeGatewayInformation",
      "storagegateway:ListVolumes",
      "storagegateway:ListLocalDisks"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:storagegateway:*:*:gateway/*"
    },
    {
     "Action":[
      "iam:ListRoles",
      "iam:GetRole"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"iam:PassRole",
     "Condition":{
      "StringLike":{
       "iam:PassedToService":"backup.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/*AwsBackup*",
      "arn:aws:iam::*:role/*AWSBackup*"
     ]
    },
    {
     "Action":"organizations:DescribeOrganization",
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ssm:CancelCommand",
      "ssm:GetCommandInvocation"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"ssm:SendCommand",
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ssm:*:*:document/AWSEC2-CreateVssSnapshot",
      "arn:aws:ec2:*:*:instance/*"
     ]
    },
    {
     "Action":"fsx:DescribeBackups",
     "Effect":"Allow",
     "Resource":"arn:aws:fsx:*:*:backup/*"
    },
    {
     "Action":"fsx:DescribeFileSystems",
     "Effect":"Allow",
     "Resource":"arn:aws:fsx:*:*:file-system/*"
    },
    {
     "Action":"fsx:DescribeVolumes",
     "Effect":"Allow",
     "Resource":"arn:aws:fsx:*:*:volume/*/*"
    },
    {
     "Action":"fsx:DescribeStorageVirtualMachines",
     "Effect":"Allow",
     "Resource":"arn:aws:fsx:*:*:storage-virtual-machine/*/*"
    },
    {
     "Action":"ds:DescribeDirectories",
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "backup-gateway:ListGateways",
      "backup-gateway:ListHypervisors",
      "backup-gateway:ListTagsForResource",
      "backup-gateway:ListVirtualMachines"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"backup-gateway:GetGateway",
     "Effect":"Allow",
     "Resource":"arn:aws:backup-gateway:*:*:gateway/*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-06-01T17:35:31+00:00"
 },
 "AWSBackupOrganizationAdminAccess":{
  "CreateDate":"2020-06-24T16:23:14+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "organizations:DisableAWSServiceAccess",
      "organizations:EnableAWSServiceAccess"
     ],
     "Condition":{
      "StringEquals":{
       "organizations:ServicePrincipal":[
        "backup.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "organizations:AttachPolicy",
      "organizations:ListPoliciesForTarget",
      "organizations:ListTargetsForPolicy",
      "organizations:DetachPolicy",
      "organizations:DisablePolicyType",
      "organizations:DescribePolicy",
      "organizations:DescribeEffectivePolicy",
      "organizations:ListPolicies",
      "organizations:EnablePolicyType",
      "organizations:CreatePolicy",
      "organizations:UpdatePolicy",
      "organizations:DeletePolicy"
     ],
     "Condition":{
      "StringLikeIfExists":{
       "organizations:PolicyType":[
        "BACKUP_POLICY"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "organizations:ListRoots",
      "organizations:ListParents",
      "organizations:ListAWSServiceAccessForOrganization",
      "organizations:ListAccountsForParent",
      "organizations:ListAccounts",
      "organizations:DescribeOrganization",
      "organizations:ListOrganizationalUnitsForParent",
      "organizations:ListChildren",
      "organizations:DescribeAccount",
      "organizations:DescribeOrganizationalUnit"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-11-24T22:09:43+00:00"
 },
 "AWSBackupServiceLinkedRolePolicyForBackup":{
  "CreateDate":"2020-06-02T23:08:40+00:00",
  "DefaultVersionId":"v10",
  "Document":{
   "Statement":[
    {
     "Action":[
      "elasticfilesystem:Backup",
      "elasticfilesystem:DescribeTags"
     ],
     "Condition":{
      "StringLike":{
       "aws:ResourceTag/aws:elasticfilesystem:default-backup":"enabled"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:elasticfilesystem:*:*:file-system/*"
    },
    {
     "Action":[
      "tag:GetResources",
      "elasticfilesystem:DescribeFileSystems",
      "dynamodb:ListTables",
      "storagegateway:ListVolumes",
      "ec2:DescribeVolumes",
      "ec2:DescribeInstances",
      "rds:DescribeDBInstances",
      "rds:DescribeDBClusters",
      "fsx:DescribeFileSystems",
      "fsx:DescribeVolumes",
      "s3:ListAllMyBuckets",
      "s3:GetBucketTagging"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"ec2:CreateTags",
     "Condition":{
      "StringEquals":{
       "ec2:CreateAction":"CopySnapshot"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*::snapshot/*"
    },
    {
     "Action":"ec2:CreateTags",
     "Condition":{
      "ForAllValues:StringEquals":{
       "aws:TagKeys":[
        "AWSBackupManagedResource"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*::image/*",
      "arn:aws:ec2:*::snapshot/*"
     ]
    },
    {
     "Action":"ec2:CreateTags",
     "Condition":{
      "Null":{
       "ec2:ResourceTag/AWSBackupManagedResource":"false"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*::image/*",
      "arn:aws:ec2:*::snapshot/*"
     ]
    },
    {
     "Action":[
      "ec2:DescribeSnapshots",
      "ec2:DescribeImages",
      "rds:DescribeDBSnapshots",
      "rds:DescribeDBClusterSnapshots"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"ec2:CopySnapshot",
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*::snapshot/*"
    },
    {
     "Action":"ec2:CopyImage",
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:DeregisterImage",
      "ec2:DeleteSnapshot"
     ],
     "Condition":{
      "Null":{
       "ec2:ResourceTag/AWSBackupManagedResource":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "rds:AddTagsToResource",
      "rds:CopyDBSnapshot",
      "rds:DeleteDBSnapshot"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:rds:*:*:snapshot:awsbackup:*"
    },
    {
     "Action":[
      "rds:AddTagsToResource",
      "rds:CopyDBClusterSnapshot",
      "rds:DeleteDBClusterSnapshot"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:rds:*:*:cluster-snapshot:awsbackup:*"
    },
    {
     "Action":"kms:DescribeKey",
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "kms:ListGrants",
      "kms:ReEncryptFrom",
      "kms:GenerateDataKeyWithoutPlaintext"
     ],
     "Condition":{
      "StringLike":{
       "kms:ViaService":[
        "ec2.*.amazonaws.com",
        "rds.*.amazonaws.com",
        "fsx.*.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"kms:CreateGrant",
     "Condition":{
      "Bool":{
       "kms:GrantIsForAWSResource":"true"
      },
      "StringLike":{
       "kms:ViaService":[
        "ec2.*.amazonaws.com",
        "rds.*.amazonaws.com",
        "fsx.*.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "fsx:CopyBackup",
      "fsx:TagResource",
      "fsx:DescribeBackups",
      "fsx:DeleteBackup"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:fsx:*:*:backup/*"
    },
    {
     "Action":"dynamodb:DeleteBackup",
     "Effect":"Allow",
     "Resource":"arn:aws:dynamodb:*:*:table/*/backup/*"
    },
    {
     "Action":[
      "backup-gateway:ListVirtualMachines"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"BackupGateway"
    },
    {
     "Action":[
      "backup-gateway:ListTagsForResource"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:backup-gateway:*:*:vm/*",
     "Sid":"ListTagsForBackupGateway"
    },
    {
     "Action":[
      "dynamodb:ListTagsOfResource",
      "dynamodb:DescribeTable"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:dynamodb:*:*:table/*"
    },
    {
     "Action":[
      "storagegateway:DescribeCachediSCSIVolumes",
      "storagegateway:DescribeStorediSCSIVolumes"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:storagegateway:*:*:gateway/*/volume/*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-05-17T17:21:50+00:00"
 },
 "AWSBackupServiceLinkedRolePolicyForBackupTest":{
  "CreateDate":"2020-05-12T17:37:29+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "elasticfilesystem:Backup",
      "elasticfilesystem:DescribeTags"
     ],
     "Condition":{
      "StringLike":{
       "aws:ResourceTag/aws:elasticfilesystem:default-backup":"enabled"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:elasticfilesystem:*:*:file-system/*"
    },
    {
     "Action":[
      "tag:GetResources"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-05-12T17:37:29+00:00"
 },
 "AWSBackupServiceRolePolicyForBackup":{
  "CreateDate":"2019-01-10T21:01:28+00:00",
  "DefaultVersionId":"v12",
  "Document":{
   "Statement":[
    {
     "Action":[
      "dynamodb:DescribeTable",
      "dynamodb:CreateBackup"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:dynamodb:*:*:table/*"
    },
    {
     "Action":[
      "dynamodb:DescribeBackup",
      "dynamodb:DeleteBackup"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:dynamodb:*:*:table/*/backup/*"
    },
    {
     "Action":[
      "rds:AddTagsToResource",
      "rds:ListTagsForResource",
      "rds:DescribeDBSnapshots",
      "rds:CreateDBSnapshot",
      "rds:CopyDBSnapshot",
      "rds:DescribeDBInstances",
      "rds:CreateDBClusterSnapshot",
      "rds:DescribeDBClusters",
      "rds:DescribeDBClusterSnapshots",
      "rds:CopyDBClusterSnapshot"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "rds:ModifyDBInstance"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:rds:*:*:db:*"
     ]
    },
    {
     "Action":[
      "rds:DeleteDBSnapshot",
      "rds:ModifyDBSnapshotAttribute"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:rds:*:*:snapshot:awsbackup:*"
     ]
    },
    {
     "Action":[
      "rds:DeleteDBClusterSnapshot",
      "rds:ModifyDBClusterSnapshotAttribute"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:rds:*:*:cluster-snapshot:awsbackup:*"
     ]
    },
    {
     "Action":[
      "storagegateway:CreateSnapshot",
      "storagegateway:ListTagsForResource"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:storagegateway:*:*:gateway/*/volume/*"
    },
    {
     "Action":[
      "ec2:CopySnapshot"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*::snapshot/*"
    },
    {
     "Action":[
      "ec2:CopyImage"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:CreateTags",
      "ec2:DeleteSnapshot"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*::snapshot/*"
    },
    {
     "Action":[
      "ec2:CreateImage",
      "ec2:DeregisterImage"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:CreateTags"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:image/*"
    },
    {
     "Action":[
      "ec2:DescribeSnapshots",
      "ec2:DescribeTags",
      "ec2:DescribeImages",
      "ec2:DescribeInstances",
      "ec2:DescribeInstanceAttribute",
      "ec2:DescribeInstanceCreditSpecifications",
      "ec2:DescribeNetworkInterfaces",
      "ec2:DescribeElasticGpus",
      "ec2:DescribeSpotInstanceRequests"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:ModifySnapshotAttribute",
      "ec2:ModifyImageAttribute"
     ],
     "Condition":{
      "Null":{
       "aws:ResourceTag/aws:backup:source-resource":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "backup:DescribeBackupVault",
      "backup:CopyIntoBackupVault"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:backup:*:*:backup-vault:*"
    },
    {
     "Action":[
      "backup:CopyFromBackupVault"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "elasticfilesystem:Backup",
      "elasticfilesystem:DescribeTags"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:elasticfilesystem:*:*:file-system/*"
    },
    {
     "Action":[
      "ec2:CreateSnapshot",
      "ec2:DeleteSnapshot",
      "ec2:DescribeVolumes",
      "ec2:DescribeSnapshots"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*::snapshot/*",
      "arn:aws:ec2:*:*:volume/*"
     ]
    },
    {
     "Action":[
      "kms:Decrypt",
      "kms:GenerateDataKey"
     ],
     "Condition":{
      "StringLike":{
       "kms:ViaService":[
        "dynamodb.*.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"kms:DescribeKey",
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"kms:CreateGrant",
     "Condition":{
      "Bool":{
       "kms:GrantIsForAWSResource":"true"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "kms:GenerateDataKeyWithoutPlaintext"
     ],
     "Condition":{
      "StringLike":{
       "kms:ViaService":[
        "ec2.*.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:kms:*:*:key/*"
    },
    {
     "Action":[
      "tag:GetResources"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ssm:CancelCommand",
      "ssm:GetCommandInvocation"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"ssm:SendCommand",
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ssm:*:*:document/AWSEC2-CreateVssSnapshot",
      "arn:aws:ec2:*:*:instance/*"
     ]
    },
    {
     "Action":"fsx:DescribeBackups",
     "Effect":"Allow",
     "Resource":"arn:aws:fsx:*:*:backup/*"
    },
    {
     "Action":"fsx:CreateBackup",
     "Effect":"Allow",
     "Resource":[
      "arn:aws:fsx:*:*:file-system/*",
      "arn:aws:fsx:*:*:backup/*",
      "arn:aws:fsx:*:*:volume/*"
     ]
    },
    {
     "Action":"fsx:DescribeFileSystems",
     "Effect":"Allow",
     "Resource":"arn:aws:fsx:*:*:file-system/*"
    },
    {
     "Action":"fsx:DescribeVolumes",
     "Effect":"Allow",
     "Resource":"arn:aws:fsx:*:*:volume/*"
    },
    {
     "Action":"fsx:ListTagsForResource",
     "Effect":"Allow",
     "Resource":[
      "arn:aws:fsx:*:*:file-system/*",
      "arn:aws:fsx:*:*:volume/*"
     ]
    },
    {
     "Action":"fsx:DeleteBackup",
     "Effect":"Allow",
     "Resource":"arn:aws:fsx:*:*:backup/*"
    },
    {
     "Action":[
      "fsx:ListTagsForResource",
      "fsx:ManageBackupPrincipalAssociations",
      "fsx:CopyBackup",
      "fsx:TagResource"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:fsx:*:*:backup/*"
    },
    {
     "Action":[
      "dynamodb:StartAwsBackupJob",
      "dynamodb:ListTagsOfResource"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:dynamodb:*:*:table/*",
     "Sid":"DynamodbBackupPermissions"
    },
    {
     "Action":[
      "backup-gateway:Backup",
      "backup-gateway:ListTagsForResource"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:backup-gateway:*:*:vm/*",
     "Sid":"BackupGatewayBackupPermissions"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-05-17T17:31:44+00:00"
 },
 "AWSBackupServiceRolePolicyForRestores":{
  "CreateDate":"2019-01-12T00:23:54+00:00",
  "DefaultVersionId":"v12",
  "Document":{
   "Statement":[
    {
     "Action":[
      "dynamodb:Scan",
      "dynamodb:Query",
      "dynamodb:UpdateItem",
      "dynamodb:PutItem",
      "dynamodb:GetItem",
      "dynamodb:DeleteItem",
      "dynamodb:BatchWriteItem",
      "dynamodb:DescribeTable"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:dynamodb:*:*:table/*"
    },
    {
     "Action":[
      "dynamodb:RestoreTableFromBackup"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:dynamodb:*:*:table/*/backup/*"
    },
    {
     "Action":[
      "ec2:CreateVolume",
      "ec2:DeleteVolume"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*::snapshot/*",
      "arn:aws:ec2:*:*:volume/*"
     ]
    },
    {
     "Action":[
      "ec2:DescribeImages",
      "ec2:DescribeInstances",
      "ec2:DescribeSnapshots",
      "ec2:DescribeVolumes"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "storagegateway:DeleteVolume",
      "storagegateway:DescribeCachediSCSIVolumes",
      "storagegateway:DescribeStorediSCSIVolumes"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:storagegateway:*:*:gateway/*/volume/*"
    },
    {
     "Action":[
      "storagegateway:DescribeGatewayInformation",
      "storagegateway:CreateStorediSCSIVolume",
      "storagegateway:CreateCachediSCSIVolume"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:storagegateway:*:*:gateway/*"
    },
    {
     "Action":[
      "storagegateway:ListVolumes"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:storagegateway:*:*:*"
    },
    {
     "Action":[
      "rds:DescribeDBInstances",
      "rds:DescribeDBSnapshots",
      "rds:ListTagsForResource",
      "rds:RestoreDBInstanceFromDBSnapshot",
      "rds:DeleteDBInstance",
      "rds:AddTagsToResource",
      "rds:DescribeDBClusters",
      "rds:RestoreDBClusterFromSnapshot",
      "rds:DeleteDBCluster",
      "rds:RestoreDBInstanceToPointInTime"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "elasticfilesystem:Restore",
      "elasticfilesystem:CreateFilesystem",
      "elasticfilesystem:DescribeFilesystems",
      "elasticfilesystem:DeleteFilesystem"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:elasticfilesystem:*:*:file-system/*"
    },
    {
     "Action":"kms:DescribeKey",
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "kms:Decrypt",
      "kms:Encrypt",
      "kms:GenerateDataKey",
      "kms:ReEncryptTo",
      "kms:ReEncryptFrom"
     ],
     "Condition":{
      "StringLike":{
       "kms:ViaService":[
        "dynamodb.*.amazonaws.com",
        "ec2.*.amazonaws.com",
        "elasticfilesystem.*.amazonaws.com",
        "rds.*.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"kms:CreateGrant",
     "Condition":{
      "Bool":{
       "kms:GrantIsForAWSResource":"true"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ebs:CompleteSnapshot",
      "ebs:StartSnapshot",
      "ebs:PutSnapshotBlock"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*::snapshot/*"
    },
    {
     "Action":[
      "ec2:DeleteSnapshot",
      "ec2:DeleteTags"
     ],
     "Condition":{
      "Null":{
       "aws:ResourceTag/aws:backup:source-resource":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*::snapshot/*"
    },
    {
     "Action":"ec2:CreateTags",
     "Condition":{
      "ForAllValues:StringEquals":{
       "aws:TagKeys":[
        "aws:backup:source-resource"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*::snapshot/*"
    },
    {
     "Action":[
      "ec2:RunInstances"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:TerminateInstances"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:instance/*"
    },
    {
     "Action":[
      "fsx:CreateFileSystemFromBackup"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:fsx:*:*:file-system/*",
      "arn:aws:fsx:*:*:backup/*"
     ]
    },
    {
     "Action":[
      "fsx:DescribeFileSystems",
      "fsx:TagResource"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:fsx:*:*:file-system/*"
    },
    {
     "Action":"fsx:DescribeBackups",
     "Effect":"Allow",
     "Resource":"arn:aws:fsx:*:*:backup/*"
    },
    {
     "Action":[
      "fsx:DeleteFileSystem",
      "fsx:UntagResource"
     ],
     "Condition":{
      "Null":{
       "aws:ResourceTag/aws:backup:source-resource":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:fsx:*:*:file-system/*"
    },
    {
     "Action":[
      "fsx:DescribeVolumes"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:fsx:*:*:volume/*"
    },
    {
     "Action":[
      "fsx:CreateVolumeFromBackup",
      "fsx:TagResource"
     ],
     "Condition":{
      "ForAllValues:StringEquals":{
       "aws:TagKeys":[
        "aws:backup:source-resource"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:fsx:*:*:volume/*"
     ]
    },
    {
     "Action":[
      "fsx:CreateVolumeFromBackup"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:fsx:*:*:storage-virtual-machine/*",
      "arn:aws:fsx:*:*:backup/*"
     ]
    },
    {
     "Action":[
      "fsx:DeleteVolume",
      "fsx:UntagResource"
     ],
     "Condition":{
      "Null":{
       "aws:ResourceTag/aws:backup:source-resource":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:fsx:*:*:volume/*"
    },
    {
     "Action":"ds:DescribeDirectories",
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "dynamodb:RestoreTableFromAwsBackup"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:dynamodb:*:*:table/*",
     "Sid":"DynamoDBRestorePermissions"
    },
    {
     "Action":[
      "backup-gateway:Restore"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:backup-gateway:*:*:hypervisor/*",
     "Sid":"GatewayRestorePermissions"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-05-17T17:36:12+00:00"
 },
 "AWSBackupServiceRolePolicyForS3Backup":{
  "CreateDate":"2022-02-18T17:40:24+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":"cloudwatch:GetMetricData",
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "events:DeleteRule",
      "events:PutTargets",
      "events:DescribeRule",
      "events:EnableRule",
      "events:PutRule",
      "events:RemoveTargets",
      "events:ListTargetsByRule",
      "events:DisableRule"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:events:*:*:rule/AwsBackupManagedRule*"
     ]
    },
    {
     "Action":"events:ListRules",
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "kms:Decrypt",
      "kms:DescribeKey"
     ],
     "Condition":{
      "StringLike":{
       "kms:ViaService":"s3.*.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "s3:GetBucketTagging",
      "s3:GetInventoryConfiguration",
      "s3:ListBucketVersions",
      "s3:ListBucket",
      "s3:GetBucketVersioning",
      "s3:GetBucketLocation",
      "s3:PutInventoryConfiguration",
      "s3:GetBucketNotification",
      "s3:PutBucketNotification"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::*"
    },
    {
     "Action":[
      "s3:GetObjectAcl",
      "s3:GetObject",
      "s3:GetObjectVersionTagging",
      "s3:GetObjectVersionAcl",
      "s3:GetObjectTagging",
      "s3:GetObjectVersion"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::*/*"
    },
    {
     "Action":"s3:ListAllMyBuckets",
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-02-26T00:01:09+00:00"
 },
 "AWSBackupServiceRolePolicyForS3Restore":{
  "CreateDate":"2022-02-18T17:39:37+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "s3:CreateBucket",
      "s3:ListBucketVersions",
      "s3:ListBucket",
      "s3:GetBucketVersioning",
      "s3:GetBucketLocation",
      "s3:PutBucketVersioning"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::*"
     ]
    },
    {
     "Action":[
      "s3:GetObject",
      "s3:GetObjectVersion",
      "s3:DeleteObject",
      "s3:PutObjectVersionAcl",
      "s3:GetObjectVersionAcl",
      "s3:GetObjectTagging",
      "s3:PutObjectTagging",
      "s3:GetObjectAcl",
      "s3:PutObjectAcl",
      "s3:ListMultipartUploadParts",
      "s3:PutObject"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::*/*"
     ]
    },
    {
     "Action":[
      "kms:DescribeKey",
      "kms:GenerateDataKey"
     ],
     "Condition":{
      "StringLike":{
       "kms:ViaService":"s3.*.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-02-18T17:39:37+00:00"
 },
 "AWSBatchFullAccess":{
  "CreateDate":"2016-12-06T19:35:42+00:00",
  "DefaultVersionId":"v6",
  "Document":{
   "Statement":[
    {
     "Action":[
      "batch:*",
      "cloudwatch:GetMetricStatistics",
      "ec2:DescribeSubnets",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeKeyPairs",
      "ec2:DescribeVpcs",
      "ec2:DescribeImages",
      "ec2:DescribeLaunchTemplates",
      "ec2:DescribeLaunchTemplateVersions",
      "ecs:DescribeClusters",
      "ecs:Describe*",
      "ecs:List*",
      "logs:Describe*",
      "logs:Get*",
      "logs:TestMetricFilter",
      "logs:FilterLogEvents",
      "iam:ListInstanceProfiles",
      "iam:ListRoles"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/AWSBatchServiceRole",
      "arn:aws:iam::*:role/service-role/AWSBatchServiceRole",
      "arn:aws:iam::*:role/ecsInstanceRole",
      "arn:aws:iam::*:instance-profile/ecsInstanceRole",
      "arn:aws:iam::*:role/iaws-ec2-spot-fleet-role",
      "arn:aws:iam::*:role/aws-ec2-spot-fleet-role",
      "arn:aws:iam::*:role/AWSBatchJobRole*"
     ]
    },
    {
     "Action":[
      "iam:CreateServiceLinkedRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":"batch.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/*Batch*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-03-10T07:02:45+00:00"
 },
 "AWSBatchServiceEventTargetRole":{
  "CreateDate":"2018-02-28T22:31:13+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "batch:SubmitJob"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2018-02-28T22:31:13+00:00"
 },
 "AWSBatchServiceRole":{
  "CreateDate":"2016-12-06T19:36:24+00:00",
  "DefaultVersionId":"v12",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:DescribeAccountAttributes",
      "ec2:DescribeInstances",
      "ec2:DescribeInstanceStatus",
      "ec2:DescribeInstanceAttribute",
      "ec2:DescribeSubnets",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeKeyPairs",
      "ec2:DescribeImages",
      "ec2:DescribeImageAttribute",
      "ec2:DescribeSpotInstanceRequests",
      "ec2:DescribeSpotFleetInstances",
      "ec2:DescribeSpotFleetRequests",
      "ec2:DescribeSpotPriceHistory",
      "ec2:DescribeVpcClassicLink",
      "ec2:DescribeLaunchTemplateVersions",
      "ec2:CreateLaunchTemplate",
      "ec2:DeleteLaunchTemplate",
      "ec2:RequestSpotFleet",
      "ec2:CancelSpotFleetRequests",
      "ec2:ModifySpotFleetRequest",
      "ec2:TerminateInstances",
      "ec2:RunInstances",
      "autoscaling:DescribeAccountLimits",
      "autoscaling:DescribeAutoScalingGroups",
      "autoscaling:DescribeLaunchConfigurations",
      "autoscaling:DescribeAutoScalingInstances",
      "autoscaling:CreateLaunchConfiguration",
      "autoscaling:CreateAutoScalingGroup",
      "autoscaling:UpdateAutoScalingGroup",
      "autoscaling:SetDesiredCapacity",
      "autoscaling:DeleteLaunchConfiguration",
      "autoscaling:DeleteAutoScalingGroup",
      "autoscaling:CreateOrUpdateTags",
      "autoscaling:SuspendProcesses",
      "autoscaling:PutNotificationConfiguration",
      "autoscaling:TerminateInstanceInAutoScalingGroup",
      "ecs:DescribeClusters",
      "ecs:DescribeContainerInstances",
      "ecs:DescribeTaskDefinition",
      "ecs:DescribeTasks",
      "ecs:ListAccountSettings",
      "ecs:ListClusters",
      "ecs:ListContainerInstances",
      "ecs:ListTaskDefinitionFamilies",
      "ecs:ListTaskDefinitions",
      "ecs:ListTasks",
      "ecs:CreateCluster",
      "ecs:DeleteCluster",
      "ecs:RegisterTaskDefinition",
      "ecs:DeregisterTaskDefinition",
      "ecs:RunTask",
      "ecs:StartTask",
      "ecs:StopTask",
      "ecs:UpdateContainerAgent",
      "ecs:DeregisterContainerInstance",
      "logs:CreateLogGroup",
      "logs:CreateLogStream",
      "logs:PutLogEvents",
      "logs:DescribeLogGroups",
      "iam:GetInstanceProfile",
      "iam:GetRole"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"ecs:TagResource",
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ecs:*:*:task/*_Batch_*"
     ]
    },
    {
     "Action":"iam:PassRole",
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":[
        "ec2.amazonaws.com",
        "ec2.amazonaws.com.cn",
        "ecs-tasks.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":[
        "spot.amazonaws.com",
        "spotfleet.amazonaws.com",
        "autoscaling.amazonaws.com",
        "ecs.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:CreateTags"
     ],
     "Condition":{
      "StringEquals":{
       "ec2:CreateAction":"RunInstances"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-12-07T02:22:29+00:00"
 },
 "AWSBillingConductorFullAccess":{
  "CreateDate":"2022-04-13T18:02:29+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "billingconductor:*",
      "organizations:ListAccounts",
      "pricing:DescribeServices"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-04-13T18:02:29+00:00"
 },
 "AWSBillingConductorReadOnlyAccess":{
  "CreateDate":"2022-04-13T18:02:59+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "billingconductor:List*",
      "organizations:ListAccounts",
      "pricing:DescribeServices"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-04-13T18:02:59+00:00"
 },
 "AWSBillingReadOnlyAccess":{
  "CreateDate":"2020-08-27T20:08:51+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "aws-portal:ViewBilling"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-08-27T20:08:51+00:00"
 },
 "AWSBudgetsActionsWithAWSResourceControlAccess":{
  "CreateDate":"2020-10-15T17:19:12+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "budgets:*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "aws-portal:ViewBilling"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":"budgets.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "aws-portal:ModifyBilling",
      "ec2:DescribeInstances",
      "iam:ListGroups",
      "iam:ListPolicies",
      "iam:ListRoles",
      "iam:ListUsers",
      "organizations:ListAccounts",
      "organizations:ListOrganizationalUnitsForParent",
      "organizations:ListPolicies",
      "organizations:ListRoots",
      "rds:DescribeDBInstances",
      "sns:ListTopics"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-10-15T17:19:12+00:00"
 },
 "AWSBudgetsActions_RolePolicyForResourceAdministrationWithSSM":{
  "CreateDate":"2022-05-25T19:03:30+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:DescribeInstanceStatus",
      "ec2:StartInstances",
      "ec2:StopInstances",
      "rds:DescribeDBInstances",
      "rds:StartDBInstance",
      "rds:StopDBInstance"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:CalledVia":[
        "ssm.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ssm:StartAutomationExecution"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ssm:*:*:automation-definition/AWS-StartEC2Instance:*",
      "arn:aws:ssm:*:*:automation-definition/AWS-StopEC2Instance:*",
      "arn:aws:ssm:*:*:automation-definition/AWS-StartRdsInstance:*",
      "arn:aws:ssm:*:*:automation-definition/AWS-StopRdsInstance:*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-05-25T19:03:30+00:00"
 },
 "AWSBudgetsReadOnlyAccess":{
  "CreateDate":"2020-10-15T17:18:28+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "aws-portal:ViewBilling",
      "budgets:ViewBudget",
      "budgets:Describe*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-10-15T17:18:28+00:00"
 },
 "AWSBugBustFullAccess":{
  "CreateDate":"2021-06-24T07:03:26+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "codeguru-reviewer:DescribeCodeReview",
      "codeguru-reviewer:ListRecommendations",
      "codeguru-reviewer:ListCodeReviews"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CodeGuruReviewerPermission"
    },
    {
     "Action":[
      "codeguru-profiler:ListProfilingGroups",
      "codeguru-profiler:DescribeProfilingGroup"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CodeGuruProfilerPermission"
    },
    {
     "Action":[
      "bugbust:*"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AWSBugBustFullAccess"
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringLike":{
       "iam:AWSServiceName":"bugbust.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/aws-service-role/bugbust.amazonaws.com/AWSServiceRoleForBugBust",
     "Sid":"AWSBugBustSLRCreation"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-07-22T20:04:29+00:00"
 },
 "AWSBugBustPlayerAccess":{
  "CreateDate":"2021-06-24T07:15:00+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "codeguru-reviewer:DescribeCodeReview",
      "codeguru-reviewer:ListRecommendations"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CodeGuruReviewerPermission"
    },
    {
     "Action":[
      "codeguru-profiler:DescribeProfilingGroup"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CodeGuruProfilerPermission"
    },
    {
     "Action":[
      "bugbust:ListBugs",
      "bugbust:ListProfilingGroups",
      "bugbust:JoinEvent",
      "bugbust:GetEvent",
      "bugbust:ListEvents",
      "bugbust:GetJoinEventStatus",
      "bugbust:ListEventScores",
      "bugbust:ListEventParticipants",
      "bugbust:UpdateWorkItem",
      "bugbust:ListPullRequests"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AWSBugBustPlayerAccess"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-06-24T07:15:00+00:00"
 },
 "AWSBugBustServiceRolePolicy":{
  "CreateDate":"2021-06-24T06:59:05+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "codeguru-reviewer:ListRecommendations",
      "codeguru-reviewer:UntagResource",
      "codeguru-reviewer:DescribeCodeReview"
     ],
     "Condition":{
      "StringLike":{
       "aws:ResourceTag/bugbust":"enabled"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-06-24T06:59:05+00:00"
 },
 "AWSCertificateManagerFullAccess":{
  "CreateDate":"2016-01-21T17:02:36+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "acm:*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":"acm.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/aws-service-role/acm.amazonaws.com/AWSServiceRoleForCertificateManager*"
    },
    {
     "Action":[
      "iam:DeleteServiceLinkedRole",
      "iam:GetServiceLinkedRoleDeletionStatus",
      "iam:GetRole"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/aws-service-role/acm.amazonaws.com/AWSServiceRoleForCertificateManager*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-08-17T22:18:28+00:00"
 },
 "AWSCertificateManagerPrivateCAAuditor":{
  "CreateDate":"2018-10-23T16:51:08+00:00",
  "DefaultVersionId":"v4",
  "Document":{
   "Statement":[
    {
     "Action":[
      "acm-pca:CreateCertificateAuthorityAuditReport",
      "acm-pca:DescribeCertificateAuthority",
      "acm-pca:DescribeCertificateAuthorityAuditReport",
      "acm-pca:GetCertificateAuthorityCsr",
      "acm-pca:GetCertificateAuthorityCertificate",
      "acm-pca:GetCertificate",
      "acm-pca:GetPolicy",
      "acm-pca:ListPermissions",
      "acm-pca:ListTags"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:acm-pca:*:*:certificate-authority/*"
    },
    {
     "Action":[
      "acm-pca:ListCertificateAuthorities"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-08-17T22:54:12+00:00"
 },
 "AWSCertificateManagerPrivateCAFullAccess":{
  "CreateDate":"2018-10-23T16:54:50+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "acm-pca:*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2018-10-23T16:54:50+00:00"
 },
 "AWSCertificateManagerPrivateCAPrivilegedUser":{
  "CreateDate":"2019-06-20T17:43:13+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "acm-pca:IssueCertificate"
     ],
     "Condition":{
      "StringLike":{
       "acm-pca:TemplateArn":[
        "arn:aws:acm-pca:::template/*CACertificate*/V*"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:acm-pca:*:*:certificate-authority/*"
    },
    {
     "Action":[
      "acm-pca:IssueCertificate"
     ],
     "Condition":{
      "StringNotLike":{
       "acm-pca:TemplateArn":[
        "arn:aws:acm-pca:::template/*CACertificate*/V*"
       ]
      }
     },
     "Effect":"Deny",
     "Resource":"arn:aws:acm-pca:*:*:certificate-authority/*"
    },
    {
     "Action":[
      "acm-pca:RevokeCertificate",
      "acm-pca:GetCertificate",
      "acm-pca:ListPermissions"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:acm-pca:*:*:certificate-authority/*"
    },
    {
     "Action":[
      "acm-pca:ListCertificateAuthorities"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-06-20T17:43:13+00:00"
 },
 "AWSCertificateManagerPrivateCAReadOnly":{
  "CreateDate":"2018-10-23T16:57:04+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":{
    "Action":[
     "acm-pca:DescribeCertificateAuthority",
     "acm-pca:DescribeCertificateAuthorityAuditReport",
     "acm-pca:ListCertificateAuthorities",
     "acm-pca:GetCertificateAuthorityCsr",
     "acm-pca:GetCertificateAuthorityCertificate",
     "acm-pca:GetCertificate",
     "acm-pca:GetPolicy",
     "acm-pca:ListPermissions",
     "acm-pca:ListTags"
    ],
    "Effect":"Allow",
    "Resource":"*"
   },
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-08-17T22:54:22+00:00"
 },
 "AWSCertificateManagerPrivateCAUser":{
  "CreateDate":"2018-10-23T16:53:33+00:00",
  "DefaultVersionId":"v4",
  "Document":{
   "Statement":[
    {
     "Action":[
      "acm-pca:IssueCertificate"
     ],
     "Condition":{
      "StringLike":{
       "acm-pca:TemplateArn":[
        "arn:aws:acm-pca:::template/EndEntityCertificate/V*"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:acm-pca:*:*:certificate-authority/*"
    },
    {
     "Action":[
      "acm-pca:IssueCertificate"
     ],
     "Condition":{
      "StringNotLike":{
       "acm-pca:TemplateArn":[
        "arn:aws:acm-pca:::template/EndEntityCertificate/V*"
       ]
      }
     },
     "Effect":"Deny",
     "Resource":"arn:aws:acm-pca:*:*:certificate-authority/*"
    },
    {
     "Action":[
      "acm-pca:RevokeCertificate",
      "acm-pca:GetCertificate",
      "acm-pca:ListPermissions"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:acm-pca:*:*:certificate-authority/*"
    },
    {
     "Action":[
      "acm-pca:ListCertificateAuthorities"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-06-20T17:42:37+00:00"
 },
 "AWSCertificateManagerReadOnly":{
  "CreateDate":"2016-01-21T17:07:33+00:00",
  "DefaultVersionId":"v4",
  "Document":{
   "Statement":{
    "Action":[
     "acm:DescribeCertificate",
     "acm:ListCertificates",
     "acm:GetCertificate",
     "acm:ListTagsForCertificate",
     "acm:GetAccountConfiguration"
    ],
    "Effect":"Allow",
    "Resource":"*"
   },
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-03-15T16:25:21+00:00"
 },
 "AWSChatbotServiceLinkedRolePolicy":{
  "CreateDate":"2019-11-18T16:39:50+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "sns:ListSubscriptionsByTopic",
      "sns:ListTopics",
      "sns:Unsubscribe",
      "sns:Subscribe",
      "sns:ListSubscriptions"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "logs:PutLogEvents",
      "logs:CreateLogStream",
      "logs:DescribeLogStreams",
      "logs:CreateLogGroup",
      "logs:DescribeLogGroups"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:logs:*:*:log-group:/aws/chatbot/*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-11-18T16:39:50+00:00"
 },
 "AWSCloud9Administrator":{
  "CreateDate":"2017-11-30T16:17:28+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cloud9:*",
      "iam:GetUser",
      "iam:ListUsers",
      "ec2:DescribeVpcs",
      "ec2:DescribeSubnets"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "iam:CreateServiceLinkedRole"
     ],
     "Condition":{
      "StringLike":{
       "iam:AWSServiceName":"cloud9.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"ssm:StartSession",
     "Condition":{
      "StringEquals":{
       "aws:CalledViaFirst":"cloud9.amazonaws.com"
      },
      "StringLike":{
       "ssm:resourceTag/aws:cloud9:environment":"*"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:instance/*"
    },
    {
     "Action":[
      "ssm:StartSession"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ssm:*:*:document/*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-07-29T06:28:54+00:00"
 },
 "AWSCloud9EnvironmentMember":{
  "CreateDate":"2017-11-30T16:18:28+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cloud9:GetUserSettings",
      "cloud9:UpdateUserSettings",
      "iam:GetUser",
      "iam:ListUsers"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "cloud9:DescribeEnvironmentMemberships"
     ],
     "Condition":{
      "Null":{
       "cloud9:EnvironmentId":"true",
       "cloud9:UserArn":"true"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":"ssm:StartSession",
     "Condition":{
      "StringEquals":{
       "aws:CalledViaFirst":"cloud9.amazonaws.com"
      },
      "StringLike":{
       "ssm:resourceTag/aws:cloud9:environment":"*"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:instance/*"
    },
    {
     "Action":[
      "ssm:StartSession"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ssm:*:*:document/*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-07-29T06:29:08+00:00"
 },
 "AWSCloud9SSMInstanceProfile":{
  "CreateDate":"2020-05-14T11:40:49+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ssmmessages:CreateControlChannel",
      "ssmmessages:CreateDataChannel",
      "ssmmessages:OpenControlChannel",
      "ssmmessages:OpenDataChannel",
      "ssm:UpdateInstanceInformation"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-05-14T11:40:49+00:00"
 },
 "AWSCloud9ServiceRolePolicy":{
  "CreateDate":"2017-11-30T13:44:08+00:00",
  "DefaultVersionId":"v8",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:RunInstances",
      "ec2:CreateSecurityGroup",
      "ec2:DescribeVpcs",
      "ec2:DescribeSubnets",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeInstances",
      "ec2:DescribeInstanceStatus",
      "cloudformation:CreateStack",
      "cloudformation:DescribeStacks",
      "cloudformation:DescribeStackEvents",
      "cloudformation:DescribeStackResources"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:TerminateInstances",
      "ec2:DeleteSecurityGroup",
      "ec2:AuthorizeSecurityGroupIngress"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "cloudformation:DeleteStack"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:cloudformation:*:*:stack/aws-cloud9-*"
    },
    {
     "Action":[
      "ec2:CreateTags"
     ],
     "Condition":{
      "StringLike":{
       "aws:RequestTag/Name":"aws-cloud9-*"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:instance/*",
      "arn:aws:ec2:*:*:security-group/*"
     ]
    },
    {
     "Action":[
      "ec2:StartInstances",
      "ec2:StopInstances"
     ],
     "Condition":{
      "StringLike":{
       "ec2:ResourceTag/aws:cloudformation:stack-name":"aws-cloud9-*"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:StartInstances",
      "ec2:StopInstances"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:license-manager:*:*:license-configuration:*"
     ]
    },
    {
     "Action":[
      "iam:ListInstanceProfiles",
      "iam:GetInstanceProfile"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:instance-profile/cloud9/*"
     ]
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringLike":{
       "iam:PassedToService":"ec2.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/service-role/AWSCloud9SSMAccessRole"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-01-17T14:06:15+00:00"
 },
 "AWSCloud9User":{
  "CreateDate":"2017-11-30T16:16:17+00:00",
  "DefaultVersionId":"v4",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cloud9:ValidateEnvironmentName",
      "cloud9:UpdateUserSettings",
      "cloud9:GetUserSettings",
      "iam:GetUser",
      "iam:ListUsers",
      "ec2:DescribeVpcs",
      "ec2:DescribeSubnets"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "cloud9:CreateEnvironmentEC2",
      "cloud9:CreateEnvironmentSSH"
     ],
     "Condition":{
      "Null":{
       "cloud9:OwnerArn":"true"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "cloud9:GetUserPublicKey"
     ],
     "Condition":{
      "Null":{
       "cloud9:UserArn":"true"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "cloud9:DescribeEnvironmentMemberships"
     ],
     "Condition":{
      "Null":{
       "cloud9:EnvironmentId":"true",
       "cloud9:UserArn":"true"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "iam:CreateServiceLinkedRole"
     ],
     "Condition":{
      "StringLike":{
       "iam:AWSServiceName":"cloud9.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"ssm:StartSession",
     "Condition":{
      "StringEquals":{
       "aws:CalledViaFirst":"cloud9.amazonaws.com"
      },
      "StringLike":{
       "ssm:resourceTag/aws:cloud9:environment":"*"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:instance/*"
    },
    {
     "Action":[
      "ssm:StartSession"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ssm:*:*:document/*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-07-29T06:26:43+00:00"
 },
 "AWSCloudFormationFullAccess":{
  "CreateDate":"2019-07-26T21:50:35+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cloudformation:*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-07-26T21:50:35+00:00"
 },
 "AWSCloudFormationReadOnlyAccess":{
  "CreateDate":"2015-02-06T18:39:49+00:00",
  "DefaultVersionId":"v4",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cloudformation:Describe*",
      "cloudformation:EstimateTemplateCost",
      "cloudformation:Get*",
      "cloudformation:List*",
      "cloudformation:ValidateTemplate",
      "cloudformation:Detect*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-11-13T17:40:07+00:00"
 },
 "AWSCloudFrontLogger":{
  "CreateDate":"2018-06-12T20:15:23+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "logs:CreateLogGroup",
      "logs:CreateLogStream",
      "logs:PutLogEvents"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:logs:*:*:log-group:/aws/cloudfront/*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-11-22T19:33:51+00:00"
 },
 "AWSCloudHSMFullAccess":{
  "CreateDate":"2015-02-06T18:39:51+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":"cloudhsm:*",
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2015-02-06T18:39:51+00:00"
 },
 "AWSCloudHSMReadOnlyAccess":{
  "CreateDate":"2015-02-06T18:39:52+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cloudhsm:Get*",
      "cloudhsm:List*",
      "cloudhsm:Describe*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2015-02-06T18:39:52+00:00"
 },
 "AWSCloudHSMRole":{
  "CreateDate":"2015-02-06T18:41:23+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:CreateNetworkInterface",
      "ec2:CreateTags",
      "ec2:DeleteNetworkInterface",
      "ec2:DescribeNetworkInterfaceAttribute",
      "ec2:DescribeNetworkInterfaces",
      "ec2:DescribeSubnets",
      "ec2:DescribeVpcs",
      "ec2:DetachNetworkInterface"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2015-02-06T18:41:23+00:00"
 },
 "AWSCloudMapDiscoverInstanceAccess":{
  "CreateDate":"2018-11-29T00:02:42+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "servicediscovery:DiscoverInstances"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2018-11-29T00:02:42+00:00"
 },
 "AWSCloudMapFullAccess":{
  "CreateDate":"2018-11-28T23:57:31+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "route53:GetHostedZone",
      "route53:ListHostedZonesByName",
      "route53:CreateHostedZone",
      "route53:DeleteHostedZone",
      "route53:ChangeResourceRecordSets",
      "route53:CreateHealthCheck",
      "route53:GetHealthCheck",
      "route53:DeleteHealthCheck",
      "route53:UpdateHealthCheck",
      "ec2:DescribeVpcs",
      "ec2:DescribeRegions",
      "ec2:DescribeInstances",
      "servicediscovery:*"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-07-29T19:15:35+00:00"
 },
 "AWSCloudMapReadOnlyAccess":{
  "CreateDate":"2018-11-28T23:45:26+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "servicediscovery:Get*",
      "servicediscovery:List*",
      "servicediscovery:DiscoverInstances"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2018-11-28T23:45:26+00:00"
 },
 "AWSCloudMapRegisterInstanceAccess":{
  "CreateDate":"2018-11-29T00:04:57+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "route53:GetHostedZone",
      "route53:ListHostedZonesByName",
      "route53:ChangeResourceRecordSets",
      "route53:CreateHealthCheck",
      "route53:GetHealthCheck",
      "route53:DeleteHealthCheck",
      "route53:UpdateHealthCheck",
      "servicediscovery:Get*",
      "servicediscovery:List*",
      "servicediscovery:RegisterInstance",
      "servicediscovery:DeregisterInstance",
      "servicediscovery:DiscoverInstances",
      "ec2:DescribeInstances"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-07-29T17:57:24+00:00"
 },
 "AWSCloudShellFullAccess":{
  "CreateDate":"2020-12-15T18:07:44+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cloudshell:*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-12-15T18:07:44+00:00"
 },
 "AWSCloudTrailReadOnlyAccess":{
  "CreateDate":"2015-02-06T18:39:59+00:00",
  "DefaultVersionId":"v9",
  "Document":{
   "Statement":[
    {
     "Action":[
      "s3:GetObject",
      "s3:GetBucketLocation"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "cloudtrail:GetTrail",
      "cloudtrail:GetTrailStatus",
      "cloudtrail:DescribeTrails",
      "cloudtrail:ListTrails",
      "cloudtrail:LookupEvents",
      "cloudtrail:ListTags",
      "cloudtrail:ListPublicKeys",
      "cloudtrail:GetEventSelectors",
      "cloudtrail:GetInsightSelectors",
      "s3:ListAllMyBuckets",
      "kms:ListAliases",
      "lambda:ListFunctions"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-11-20T21:06:49+00:00"
 },
 "AWSCloudTrail_FullAccess":{
  "CreateDate":"2020-10-08T23:41:15+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "sns:AddPermission",
      "sns:CreateTopic",
      "sns:SetTopicAttributes",
      "sns:GetTopicAttributes"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:sns:*:*:aws-cloudtrail-logs*"
     ]
    },
    {
     "Action":[
      "sns:ListTopics"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "s3:CreateBucket",
      "s3:PutBucketPolicy",
      "s3:PutBucketPublicAccessBlock"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::aws-cloudtrail-logs*"
     ]
    },
    {
     "Action":[
      "s3:ListAllMyBuckets",
      "s3:GetBucketLocation",
      "s3:GetBucketPolicy"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"cloudtrail:*",
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "logs:CreateLogGroup"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:logs:*:*:log-group:aws-cloudtrail-logs*"
     ]
    },
    {
     "Action":[
      "iam:ListRoles",
      "iam:GetRolePolicy",
      "iam:GetUser"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":"cloudtrail.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "kms:CreateKey",
      "kms:CreateAlias",
      "kms:ListKeys",
      "kms:ListAliases"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "lambda:ListFunctions"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "dynamodb:ListGlobalTables",
      "dynamodb:ListTables"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-02-22T19:01:00+00:00"
 },
 "AWSCloudTrail_ReadOnlyAccess":{
  "CreateDate":"2022-06-14T17:19:05+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cloudtrail:Get*",
      "cloudtrail:Describe*",
      "cloudtrail:List*",
      "cloudtrail:LookupEvents"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-06-14T17:19:05+00:00"
 },
 "AWSCloudWatchAlarms_ActionSSMIncidentsServiceRolePolicy":{
  "CreateDate":"2021-04-27T13:30:52+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":"ssm-incidents:StartIncident",
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"StartIncidentPermissions"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-04-27T13:30:52+00:00"
 },
 "AWSCodeArtifactAdminAccess":{
  "CreateDate":"2020-06-16T23:53:23+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "codeartifact:*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"sts:GetServiceBearerToken",
     "Condition":{
      "StringEquals":{
       "sts:AWSServiceName":"codeartifact.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-06-16T23:53:23+00:00"
 },
 "AWSCodeArtifactReadOnlyAccess":{
  "CreateDate":"2020-06-25T21:23:52+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "codeartifact:Describe*",
      "codeartifact:Get*",
      "codeartifact:List*",
      "codeartifact:ReadFromRepository"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"sts:GetServiceBearerToken",
     "Condition":{
      "StringEquals":{
       "sts:AWSServiceName":"codeartifact.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-06-25T21:23:52+00:00"
 },
 "AWSCodeBuildAdminAccess":{
  "CreateDate":"2016-12-01T19:04:44+00:00",
  "DefaultVersionId":"v12",
  "Document":{
   "Statement":[
    {
     "Action":[
      "codebuild:*",
      "codecommit:GetBranch",
      "codecommit:GetCommit",
      "codecommit:GetRepository",
      "codecommit:ListBranches",
      "codecommit:ListRepositories",
      "cloudwatch:GetMetricStatistics",
      "ec2:DescribeVpcs",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeSubnets",
      "ecr:DescribeRepositories",
      "ecr:ListImages",
      "elasticfilesystem:DescribeFileSystems",
      "events:DeleteRule",
      "events:DescribeRule",
      "events:DisableRule",
      "events:EnableRule",
      "events:ListTargetsByRule",
      "events:ListRuleNamesByTarget",
      "events:PutRule",
      "events:PutTargets",
      "events:RemoveTargets",
      "logs:GetLogEvents",
      "s3:GetBucketLocation",
      "s3:ListAllMyBuckets"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "logs:DeleteLogGroup"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:logs:*:*:log-group:/aws/codebuild/*:log-stream:*"
    },
    {
     "Action":[
      "ssm:PutParameter"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:ssm:*:*:parameter/CodeBuild/*"
    },
    {
     "Action":[
      "ssm:StartSession"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:ecs:*:*:task/*/*"
    },
    {
     "Action":[
      "codestar-connections:CreateConnection",
      "codestar-connections:DeleteConnection",
      "codestar-connections:UpdateConnectionInstallation",
      "codestar-connections:TagResource",
      "codestar-connections:UntagResource",
      "codestar-connections:ListConnections",
      "codestar-connections:ListInstallationTargets",
      "codestar-connections:ListTagsForResource",
      "codestar-connections:GetConnection",
      "codestar-connections:GetIndividualAccessToken",
      "codestar-connections:GetInstallationUrl",
      "codestar-connections:PassConnection",
      "codestar-connections:StartOAuthHandshake",
      "codestar-connections:UseConnection"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:codestar-connections:*:*:connection/*",
     "Sid":"CodeStarConnectionsReadWriteAccess"
    },
    {
     "Action":[
      "codestar-notifications:CreateNotificationRule",
      "codestar-notifications:DescribeNotificationRule",
      "codestar-notifications:UpdateNotificationRule",
      "codestar-notifications:DeleteNotificationRule",
      "codestar-notifications:Subscribe",
      "codestar-notifications:Unsubscribe"
     ],
     "Condition":{
      "StringLike":{
       "codestar-notifications:NotificationsForResource":"arn:aws:codebuild:*"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CodeStarNotificationsReadWriteAccess"
    },
    {
     "Action":[
      "codestar-notifications:ListNotificationRules",
      "codestar-notifications:ListEventTypes",
      "codestar-notifications:ListTargets",
      "codestar-notifications:ListTagsforResource"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CodeStarNotificationsListAccess"
    },
    {
     "Action":[
      "sns:CreateTopic",
      "sns:SetTopicAttributes"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:sns:*:*:codestar-notifications*",
     "Sid":"CodeStarNotificationsSNSTopicCreateAccess"
    },
    {
     "Action":[
      "sns:ListTopics",
      "sns:GetTopicAttributes"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"SNSTopicListAccess"
    },
    {
     "Action":[
      "chatbot:DescribeSlackChannelConfigurations"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CodeStarNotificationsChatbotAccess"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-09-14T16:03:39+00:00"
 },
 "AWSCodeBuildDeveloperAccess":{
  "CreateDate":"2016-12-01T19:02:32+00:00",
  "DefaultVersionId":"v13",
  "Document":{
   "Statement":[
    {
     "Action":[
      "codebuild:StartBuild",
      "codebuild:StopBuild",
      "codebuild:StartBuildBatch",
      "codebuild:StopBuildBatch",
      "codebuild:RetryBuild",
      "codebuild:RetryBuildBatch",
      "codebuild:BatchGet*",
      "codebuild:GetResourcePolicy",
      "codebuild:DescribeTestCases",
      "codebuild:DescribeCodeCoverages",
      "codebuild:List*",
      "codecommit:GetBranch",
      "codecommit:GetCommit",
      "codecommit:GetRepository",
      "codecommit:ListBranches",
      "cloudwatch:GetMetricStatistics",
      "events:DescribeRule",
      "events:ListTargetsByRule",
      "events:ListRuleNamesByTarget",
      "logs:GetLogEvents",
      "s3:GetBucketLocation",
      "s3:ListAllMyBuckets"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ssm:PutParameter"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:ssm:*:*:parameter/CodeBuild/*"
    },
    {
     "Action":[
      "ssm:StartSession"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:ecs:*:*:task/*/*"
    },
    {
     "Action":[
      "codestar-connections:ListConnections",
      "codestar-connections:GetConnection"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:codestar-connections:*:*:connection/*",
     "Sid":"CodeStarConnectionsUserAccess"
    },
    {
     "Action":[
      "codestar-notifications:CreateNotificationRule",
      "codestar-notifications:DescribeNotificationRule",
      "codestar-notifications:UpdateNotificationRule",
      "codestar-notifications:Subscribe",
      "codestar-notifications:Unsubscribe"
     ],
     "Condition":{
      "StringLike":{
       "codestar-notifications:NotificationsForResource":"arn:aws:codebuild:*"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CodeStarNotificationsReadWriteAccess"
    },
    {
     "Action":[
      "codestar-notifications:ListNotificationRules",
      "codestar-notifications:ListEventTypes",
      "codestar-notifications:ListTargets",
      "codestar-notifications:ListTagsforResource"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CodeStarNotificationsListAccess"
    },
    {
     "Action":[
      "sns:ListTopics",
      "sns:GetTopicAttributes"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"SNSTopicListAccess"
    },
    {
     "Action":[
      "chatbot:DescribeSlackChannelConfigurations"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CodeStarNotificationsChatbotAccess"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-09-14T16:03:44+00:00"
 },
 "AWSCodeBuildReadOnlyAccess":{
  "CreateDate":"2016-12-01T19:03:41+00:00",
  "DefaultVersionId":"v11",
  "Document":{
   "Statement":[
    {
     "Action":[
      "codebuild:BatchGet*",
      "codebuild:GetResourcePolicy",
      "codebuild:List*",
      "codebuild:DescribeTestCases",
      "codebuild:DescribeCodeCoverages",
      "codecommit:GetBranch",
      "codecommit:GetCommit",
      "codecommit:GetRepository",
      "cloudwatch:GetMetricStatistics",
      "events:DescribeRule",
      "events:ListTargetsByRule",
      "events:ListRuleNamesByTarget",
      "logs:GetLogEvents"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "codestar-connections:ListConnections",
      "codestar-connections:GetConnection"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:codestar-connections:*:*:connection/*",
     "Sid":"CodeStarConnectionsUserAccess"
    },
    {
     "Action":[
      "codestar-notifications:DescribeNotificationRule"
     ],
     "Condition":{
      "StringLike":{
       "codestar-notifications:NotificationsForResource":"arn:aws:codebuild:*"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CodeStarNotificationsPowerUserAccess"
    },
    {
     "Action":[
      "codestar-notifications:ListNotificationRules",
      "codestar-notifications:ListEventTypes",
      "codestar-notifications:ListTargets"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CodeStarNotificationsListAccess"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-09-14T16:04:04+00:00"
 },
 "AWSCodeCommitFullAccess":{
  "CreateDate":"2015-07-09T17:02:19+00:00",
  "DefaultVersionId":"v9",
  "Document":{
   "Statement":[
    {
     "Action":[
      "codecommit:*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "events:DeleteRule",
      "events:DescribeRule",
      "events:DisableRule",
      "events:EnableRule",
      "events:PutRule",
      "events:PutTargets",
      "events:RemoveTargets",
      "events:ListTargetsByRule"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:events:*:*:rule/codecommit*",
     "Sid":"CloudWatchEventsCodeCommitRulesAccess"
    },
    {
     "Action":[
      "sns:CreateTopic",
      "sns:DeleteTopic",
      "sns:Subscribe",
      "sns:Unsubscribe",
      "sns:SetTopicAttributes"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:sns:*:*:codecommit*",
     "Sid":"SNSTopicAndSubscriptionAccess"
    },
    {
     "Action":[
      "sns:ListTopics",
      "sns:ListSubscriptionsByTopic",
      "sns:GetTopicAttributes"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"SNSTopicAndSubscriptionReadAccess"
    },
    {
     "Action":[
      "lambda:ListFunctions"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"LambdaReadOnlyListAccess"
    },
    {
     "Action":[
      "iam:ListUsers"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"IAMReadOnlyListAccess"
    },
    {
     "Action":[
      "iam:ListAccessKeys",
      "iam:ListSSHPublicKeys",
      "iam:ListServiceSpecificCredentials"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:user/${aws:username}",
     "Sid":"IAMReadOnlyConsoleAccess"
    },
    {
     "Action":[
      "iam:DeleteSSHPublicKey",
      "iam:GetSSHPublicKey",
      "iam:ListSSHPublicKeys",
      "iam:UpdateSSHPublicKey",
      "iam:UploadSSHPublicKey"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:user/${aws:username}",
     "Sid":"IAMUserSSHKeys"
    },
    {
     "Action":[
      "iam:CreateServiceSpecificCredential",
      "iam:UpdateServiceSpecificCredential",
      "iam:DeleteServiceSpecificCredential",
      "iam:ResetServiceSpecificCredential"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:user/${aws:username}",
     "Sid":"IAMSelfManageServiceSpecificCredentials"
    },
    {
     "Action":[
      "codestar-notifications:CreateNotificationRule",
      "codestar-notifications:DescribeNotificationRule",
      "codestar-notifications:UpdateNotificationRule",
      "codestar-notifications:DeleteNotificationRule",
      "codestar-notifications:Subscribe",
      "codestar-notifications:Unsubscribe"
     ],
     "Condition":{
      "StringLike":{
       "codestar-notifications:NotificationsForResource":"arn:aws:codecommit:*"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CodeStarNotificationsReadWriteAccess"
    },
    {
     "Action":[
      "codestar-notifications:ListNotificationRules",
      "codestar-notifications:ListTargets",
      "codestar-notifications:ListTagsforResource",
      "codestar-notifications:ListEventTypes"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CodeStarNotificationsListAccess"
    },
    {
     "Action":[
      "sns:CreateTopic",
      "sns:SetTopicAttributes"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:sns:*:*:codestar-notifications*",
     "Sid":"CodeStarNotificationsSNSTopicCreateAccess"
    },
    {
     "Action":[
      "codeguru-reviewer:AssociateRepository",
      "codeguru-reviewer:DescribeRepositoryAssociation",
      "codeguru-reviewer:ListRepositoryAssociations",
      "codeguru-reviewer:DisassociateRepository",
      "codeguru-reviewer:DescribeCodeReview",
      "codeguru-reviewer:ListCodeReviews"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AmazonCodeGuruReviewerFullAccess"
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringLike":{
       "iam:AWSServiceName":"codeguru-reviewer.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/aws-service-role/codeguru-reviewer.amazonaws.com/AWSServiceRoleForAmazonCodeGuruReviewer",
     "Sid":"AmazonCodeGuruReviewerSLRCreation"
    },
    {
     "Action":[
      "events:PutRule",
      "events:PutTargets",
      "events:DeleteRule",
      "events:RemoveTargets"
     ],
     "Condition":{
      "StringEquals":{
       "events:ManagedBy":"codeguru-reviewer.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CloudWatchEventsManagedRules"
    },
    {
     "Action":[
      "chatbot:DescribeSlackChannelConfigurations"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CodeStarNotificationsChatbotAccess"
    },
    {
     "Action":[
      "codestar-connections:ListConnections",
      "codestar-connections:GetConnection"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:codestar-connections:*:*:connection/*",
     "Sid":"CodeStarConnectionsReadOnlyAccess"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-07-30T23:17:35+00:00"
 },
 "AWSCodeCommitPowerUser":{
  "CreateDate":"2015-07-09T17:06:49+00:00",
  "DefaultVersionId":"v14",
  "Document":{
   "Statement":[
    {
     "Action":[
      "codecommit:AssociateApprovalRuleTemplateWithRepository",
      "codecommit:BatchAssociateApprovalRuleTemplateWithRepositories",
      "codecommit:BatchDisassociateApprovalRuleTemplateFromRepositories",
      "codecommit:BatchGet*",
      "codecommit:BatchDescribe*",
      "codecommit:Create*",
      "codecommit:DeleteBranch",
      "codecommit:DeleteFile",
      "codecommit:Describe*",
      "codecommit:DisassociateApprovalRuleTemplateFromRepository",
      "codecommit:EvaluatePullRequestApprovalRules",
      "codecommit:Get*",
      "codecommit:List*",
      "codecommit:Merge*",
      "codecommit:OverridePullRequestApprovalRules",
      "codecommit:Put*",
      "codecommit:Post*",
      "codecommit:TagResource",
      "codecommit:Test*",
      "codecommit:UntagResource",
      "codecommit:Update*",
      "codecommit:GitPull",
      "codecommit:GitPush"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "events:DeleteRule",
      "events:DescribeRule",
      "events:DisableRule",
      "events:EnableRule",
      "events:PutRule",
      "events:PutTargets",
      "events:RemoveTargets",
      "events:ListTargetsByRule"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:events:*:*:rule/codecommit*",
     "Sid":"CloudWatchEventsCodeCommitRulesAccess"
    },
    {
     "Action":[
      "sns:Subscribe",
      "sns:Unsubscribe"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:sns:*:*:codecommit*",
     "Sid":"SNSTopicAndSubscriptionAccess"
    },
    {
     "Action":[
      "sns:ListTopics",
      "sns:ListSubscriptionsByTopic",
      "sns:GetTopicAttributes"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"SNSTopicAndSubscriptionReadAccess"
    },
    {
     "Action":[
      "lambda:ListFunctions"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"LambdaReadOnlyListAccess"
    },
    {
     "Action":[
      "iam:ListUsers"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"IAMReadOnlyListAccess"
    },
    {
     "Action":[
      "iam:ListAccessKeys",
      "iam:ListSSHPublicKeys",
      "iam:ListServiceSpecificCredentials"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:user/${aws:username}",
     "Sid":"IAMReadOnlyConsoleAccess"
    },
    {
     "Action":[
      "iam:DeleteSSHPublicKey",
      "iam:GetSSHPublicKey",
      "iam:ListSSHPublicKeys",
      "iam:UpdateSSHPublicKey",
      "iam:UploadSSHPublicKey"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:user/${aws:username}",
     "Sid":"IAMUserSSHKeys"
    },
    {
     "Action":[
      "iam:CreateServiceSpecificCredential",
      "iam:UpdateServiceSpecificCredential",
      "iam:DeleteServiceSpecificCredential",
      "iam:ResetServiceSpecificCredential"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:user/${aws:username}",
     "Sid":"IAMSelfManageServiceSpecificCredentials"
    },
    {
     "Action":[
      "codestar-notifications:CreateNotificationRule",
      "codestar-notifications:DescribeNotificationRule",
      "codestar-notifications:UpdateNotificationRule",
      "codestar-notifications:Subscribe",
      "codestar-notifications:Unsubscribe"
     ],
     "Condition":{
      "StringLike":{
       "codestar-notifications:NotificationsForResource":"arn:aws:codecommit:*"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CodeStarNotificationsReadWriteAccess"
    },
    {
     "Action":[
      "codestar-notifications:ListNotificationRules",
      "codestar-notifications:ListTargets",
      "codestar-notifications:ListTagsforResource",
      "codestar-notifications:ListEventTypes"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CodeStarNotificationsListAccess"
    },
    {
     "Action":[
      "codeguru-reviewer:AssociateRepository",
      "codeguru-reviewer:DescribeRepositoryAssociation",
      "codeguru-reviewer:ListRepositoryAssociations",
      "codeguru-reviewer:DisassociateRepository",
      "codeguru-reviewer:DescribeCodeReview",
      "codeguru-reviewer:ListCodeReviews"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AmazonCodeGuruReviewerFullAccess"
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringLike":{
       "iam:AWSServiceName":"codeguru-reviewer.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/aws-service-role/codeguru-reviewer.amazonaws.com/AWSServiceRoleForAmazonCodeGuruReviewer",
     "Sid":"AmazonCodeGuruReviewerSLRCreation"
    },
    {
     "Action":[
      "events:PutRule",
      "events:PutTargets",
      "events:DeleteRule",
      "events:RemoveTargets"
     ],
     "Condition":{
      "StringEquals":{
       "events:ManagedBy":"codeguru-reviewer.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CloudWatchEventsManagedRules"
    },
    {
     "Action":[
      "chatbot:DescribeSlackChannelConfigurations"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CodeStarNotificationsChatbotAccess"
    },
    {
     "Action":[
      "codestar-connections:ListConnections",
      "codestar-connections:GetConnection"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:codestar-connections:*:*:connection/*",
     "Sid":"CodeStarConnectionsReadOnlyAccess"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-07-30T23:12:48+00:00"
 },
 "AWSCodeCommitReadOnly":{
  "CreateDate":"2015-07-09T17:05:06+00:00",
  "DefaultVersionId":"v11",
  "Document":{
   "Statement":[
    {
     "Action":[
      "codecommit:BatchGet*",
      "codecommit:BatchDescribe*",
      "codecommit:Describe*",
      "codecommit:EvaluatePullRequestApprovalRules",
      "codecommit:Get*",
      "codecommit:List*",
      "codecommit:GitPull"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "events:DescribeRule",
      "events:ListTargetsByRule"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:events:*:*:rule/codecommit*",
     "Sid":"CloudWatchEventsCodeCommitRulesReadOnlyAccess"
    },
    {
     "Action":[
      "sns:ListTopics",
      "sns:ListSubscriptionsByTopic",
      "sns:GetTopicAttributes"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"SNSSubscriptionAccess"
    },
    {
     "Action":[
      "lambda:ListFunctions"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"LambdaReadOnlyListAccess"
    },
    {
     "Action":[
      "iam:ListUsers"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"IAMReadOnlyListAccess"
    },
    {
     "Action":[
      "iam:ListSSHPublicKeys",
      "iam:ListServiceSpecificCredentials",
      "iam:ListAccessKeys",
      "iam:GetSSHPublicKey"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:user/${aws:username}",
     "Sid":"IAMReadOnlyConsoleAccess"
    },
    {
     "Action":[
      "codestar-connections:ListConnections",
      "codestar-connections:GetConnection"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:codestar-connections:*:*:connection/*",
     "Sid":"CodeStarConnectionsReadOnlyAccess"
    },
    {
     "Action":[
      "codestar-notifications:DescribeNotificationRule"
     ],
     "Condition":{
      "StringLike":{
       "codestar-notifications:NotificationsForResource":"arn:aws:codecommit:*"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CodeStarNotificationsReadOnlyAccess"
    },
    {
     "Action":[
      "codestar-notifications:ListNotificationRules",
      "codestar-notifications:ListEventTypes",
      "codestar-notifications:ListTargets"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CodeStarNotificationsListAccess"
    },
    {
     "Action":[
      "codeguru-reviewer:DescribeRepositoryAssociation",
      "codeguru-reviewer:ListRepositoryAssociations",
      "codeguru-reviewer:DescribeCodeReview",
      "codeguru-reviewer:ListCodeReviews"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AmazonCodeGuruReviewerReadOnlyAccess"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-08-18T18:18:01+00:00"
 },
 "AWSCodeDeployDeployerAccess":{
  "CreateDate":"2015-05-19T18:18:43+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "codedeploy:Batch*",
      "codedeploy:CreateDeployment",
      "codedeploy:Get*",
      "codedeploy:List*",
      "codedeploy:RegisterApplicationRevision"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "codestar-notifications:CreateNotificationRule",
      "codestar-notifications:DescribeNotificationRule",
      "codestar-notifications:UpdateNotificationRule",
      "codestar-notifications:Subscribe",
      "codestar-notifications:Unsubscribe"
     ],
     "Condition":{
      "StringLike":{
       "codestar-notifications:NotificationsForResource":"arn:aws:codedeploy:*"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CodeStarNotificationsReadWriteAccess"
    },
    {
     "Action":[
      "codestar-notifications:ListNotificationRules",
      "codestar-notifications:ListTargets",
      "codestar-notifications:ListTagsforResource",
      "codestar-notifications:ListEventTypes"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CodeStarNotificationsListAccess"
    },
    {
     "Action":[
      "chatbot:DescribeSlackChannelConfigurations"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CodeStarNotificationsChatbotAccess"
    },
    {
     "Action":[
      "sns:ListTopics"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"SNSTopicListAccess"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-04-02T16:16:11+00:00"
 },
 "AWSCodeDeployFullAccess":{
  "CreateDate":"2015-05-19T18:13:23+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":"codedeploy:*",
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "codestar-notifications:CreateNotificationRule",
      "codestar-notifications:DescribeNotificationRule",
      "codestar-notifications:UpdateNotificationRule",
      "codestar-notifications:DeleteNotificationRule",
      "codestar-notifications:Subscribe",
      "codestar-notifications:Unsubscribe"
     ],
     "Condition":{
      "StringLike":{
       "codestar-notifications:NotificationsForResource":"arn:aws:codedeploy:*"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CodeStarNotificationsReadWriteAccess"
    },
    {
     "Action":[
      "codestar-notifications:ListNotificationRules",
      "codestar-notifications:ListTargets",
      "codestar-notifications:ListTagsforResource",
      "codestar-notifications:ListEventTypes"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CodeStarNotificationsListAccess"
    },
    {
     "Action":[
      "sns:CreateTopic",
      "sns:SetTopicAttributes"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:sns:*:*:codestar-notifications*",
     "Sid":"CodeStarNotificationsSNSTopicCreateAccess"
    },
    {
     "Action":[
      "chatbot:DescribeSlackChannelConfigurations"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CodeStarNotificationsChatbotAccess"
    },
    {
     "Action":[
      "sns:ListTopics"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"SNSTopicListAccess"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-04-02T16:14:47+00:00"
 },
 "AWSCodeDeployReadOnlyAccess":{
  "CreateDate":"2015-05-19T18:21:32+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "codedeploy:Batch*",
      "codedeploy:Get*",
      "codedeploy:List*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "codestar-notifications:DescribeNotificationRule"
     ],
     "Condition":{
      "StringLike":{
       "codestar-notifications:NotificationsForResource":"arn:aws:codedeploy:*"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CodeStarNotificationsPowerUserAccess"
    },
    {
     "Action":[
      "codestar-notifications:ListNotificationRules",
      "codestar-notifications:ListEventTypes",
      "codestar-notifications:ListTargets"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CodeStarNotificationsListAccess"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-04-02T16:20:09+00:00"
 },
 "AWSCodeDeployRole":{
  "CreateDate":"2015-05-04T18:05:37+00:00",
  "DefaultVersionId":"v9",
  "Document":{
   "Statement":[
    {
     "Action":[
      "autoscaling:CompleteLifecycleAction",
      "autoscaling:DeleteLifecycleHook",
      "autoscaling:DescribeAutoScalingGroups",
      "autoscaling:DescribeLifecycleHooks",
      "autoscaling:PutLifecycleHook",
      "autoscaling:RecordLifecycleActionHeartbeat",
      "autoscaling:CreateAutoScalingGroup",
      "autoscaling:UpdateAutoScalingGroup",
      "autoscaling:EnableMetricsCollection",
      "autoscaling:DescribePolicies",
      "autoscaling:DescribeScheduledActions",
      "autoscaling:DescribeNotificationConfigurations",
      "autoscaling:SuspendProcesses",
      "autoscaling:ResumeProcesses",
      "autoscaling:AttachLoadBalancers",
      "autoscaling:AttachLoadBalancerTargetGroups",
      "autoscaling:PutScalingPolicy",
      "autoscaling:PutScheduledUpdateGroupAction",
      "autoscaling:PutNotificationConfiguration",
      "autoscaling:PutWarmPool",
      "autoscaling:DescribeScalingActivities",
      "autoscaling:DeleteAutoScalingGroup",
      "ec2:DescribeInstances",
      "ec2:DescribeInstanceStatus",
      "ec2:TerminateInstances",
      "tag:GetResources",
      "sns:Publish",
      "cloudwatch:DescribeAlarms",
      "cloudwatch:PutMetricAlarm",
      "elasticloadbalancing:DescribeLoadBalancers",
      "elasticloadbalancing:DescribeInstanceHealth",
      "elasticloadbalancing:RegisterInstancesWithLoadBalancer",
      "elasticloadbalancing:DeregisterInstancesFromLoadBalancer",
      "elasticloadbalancing:DescribeTargetGroups",
      "elasticloadbalancing:DescribeTargetHealth",
      "elasticloadbalancing:RegisterTargets",
      "elasticloadbalancing:DeregisterTargets"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-05-19T00:42:51+00:00"
 },
 "AWSCodeDeployRoleForCloudFormation":{
  "CreateDate":"2020-05-19T17:12:52+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "lambda:InvokeFunction"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:lambda:*:*:function:CodeDeployHook_*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-05-19T17:12:52+00:00"
 },
 "AWSCodeDeployRoleForECS":{
  "CreateDate":"2018-11-27T20:40:57+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ecs:DescribeServices",
      "ecs:CreateTaskSet",
      "ecs:UpdateServicePrimaryTaskSet",
      "ecs:DeleteTaskSet",
      "elasticloadbalancing:DescribeTargetGroups",
      "elasticloadbalancing:DescribeListeners",
      "elasticloadbalancing:ModifyListener",
      "elasticloadbalancing:DescribeRules",
      "elasticloadbalancing:ModifyRule",
      "lambda:InvokeFunction",
      "cloudwatch:DescribeAlarms",
      "sns:Publish",
      "s3:GetObject",
      "s3:GetObjectVersion"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringLike":{
       "iam:PassedToService":[
        "ecs-tasks.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-09-23T22:37:46+00:00"
 },
 "AWSCodeDeployRoleForECSLimited":{
  "CreateDate":"2018-11-27T20:42:42+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ecs:DescribeServices",
      "ecs:CreateTaskSet",
      "ecs:UpdateServicePrimaryTaskSet",
      "ecs:DeleteTaskSet",
      "cloudwatch:DescribeAlarms"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "sns:Publish"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:sns:*:*:CodeDeployTopic_*"
    },
    {
     "Action":[
      "elasticloadbalancing:DescribeTargetGroups",
      "elasticloadbalancing:DescribeListeners",
      "elasticloadbalancing:ModifyListener",
      "elasticloadbalancing:DescribeRules",
      "elasticloadbalancing:ModifyRule"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "lambda:InvokeFunction"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:lambda:*:*:function:CodeDeployHook_*"
    },
    {
     "Action":[
      "s3:GetObject",
      "s3:GetObjectVersion"
     ],
     "Condition":{
      "StringEquals":{
       "s3:ExistingObjectTag/UseWithCodeDeploy":"true"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringLike":{
       "iam:PassedToService":[
        "ecs-tasks.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/ecsTaskExecutionRole",
      "arn:aws:iam::*:role/ECSTaskExecution*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-09-23T22:10:29+00:00"
 },
 "AWSCodeDeployRoleForLambda":{
  "CreateDate":"2017-11-28T14:05:44+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cloudwatch:DescribeAlarms",
      "lambda:UpdateAlias",
      "lambda:GetAlias",
      "lambda:GetProvisionedConcurrencyConfig",
      "sns:Publish"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "s3:GetObject",
      "s3:GetObjectVersion"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::*/CodeDeploy/*"
    },
    {
     "Action":[
      "s3:GetObject",
      "s3:GetObjectVersion"
     ],
     "Condition":{
      "StringEquals":{
       "s3:ExistingObjectTag/UseWithCodeDeploy":"true"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "lambda:InvokeFunction"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:lambda:*:*:function:CodeDeployHook_*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-12-03T19:53:10+00:00"
 },
 "AWSCodeDeployRoleForLambdaLimited":{
  "CreateDate":"2020-08-17T17:14:14+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cloudwatch:DescribeAlarms",
      "lambda:UpdateAlias",
      "lambda:GetAlias",
      "lambda:GetProvisionedConcurrencyConfig"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "s3:GetObject",
      "s3:GetObjectVersion"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::*/CodeDeploy/*"
    },
    {
     "Action":[
      "s3:GetObject",
      "s3:GetObjectVersion"
     ],
     "Condition":{
      "StringEquals":{
       "s3:ExistingObjectTag/UseWithCodeDeploy":"true"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "lambda:InvokeFunction"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:lambda:*:*:function:CodeDeployHook_*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-08-17T17:14:14+00:00"
 },
 "AWSCodePipelineApproverAccess":{
  "CreateDate":"2016-07-28T18:59:17+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "codepipeline:GetPipeline",
      "codepipeline:GetPipelineState",
      "codepipeline:GetPipelineExecution",
      "codepipeline:ListPipelineExecutions",
      "codepipeline:ListPipelines",
      "codepipeline:PutApprovalResult"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2017-08-02T17:24:58+00:00"
 },
 "AWSCodePipelineCustomActionAccess":{
  "CreateDate":"2015-07-09T17:02:54+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "codepipeline:AcknowledgeJob",
      "codepipeline:GetJobDetails",
      "codepipeline:PollForJobs",
      "codepipeline:PutJobFailureResult",
      "codepipeline:PutJobSuccessResult"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2015-07-09T17:02:54+00:00"
 },
 "AWSCodePipelineFullAccess":{
  "CreateDate":"2015-07-09T16:58:07+00:00",
  "DefaultVersionId":"v10",
  "Document":{
   "Statement":[
    {
     "Action":[
      "codepipeline:*",
      "cloudformation:DescribeStacks",
      "cloudformation:ListChangeSets",
      "cloudtrail:CreateTrail",
      "cloudtrail:DescribeTrails",
      "cloudtrail:GetEventSelectors",
      "cloudtrail:PutEventSelectors",
      "cloudtrail:StartLogging",
      "codebuild:BatchGetProjects",
      "codebuild:CreateProject",
      "codebuild:ListCuratedEnvironmentImages",
      "codebuild:ListProjects",
      "codecommit:GetBranch",
      "codecommit:GetRepositoryTriggers",
      "codecommit:ListBranches",
      "codecommit:ListRepositories",
      "codecommit:PutRepositoryTriggers",
      "codecommit:GetReferences",
      "codedeploy:GetApplication",
      "codedeploy:BatchGetApplications",
      "codedeploy:GetDeploymentGroup",
      "codedeploy:BatchGetDeploymentGroups",
      "codedeploy:ListApplications",
      "codedeploy:ListDeploymentGroups",
      "devicefarm:GetDevicePool",
      "devicefarm:GetProject",
      "devicefarm:ListDevicePools",
      "devicefarm:ListProjects",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeSubnets",
      "ec2:DescribeVpcs",
      "ecr:DescribeRepositories",
      "ecr:ListImages",
      "ecs:ListClusters",
      "ecs:ListServices",
      "elasticbeanstalk:DescribeApplications",
      "elasticbeanstalk:DescribeEnvironments",
      "iam:ListRoles",
      "iam:GetRole",
      "lambda:GetFunctionConfiguration",
      "lambda:ListFunctions",
      "events:ListRules",
      "events:ListTargetsByRule",
      "events:DescribeRule",
      "opsworks:DescribeApps",
      "opsworks:DescribeLayers",
      "opsworks:DescribeStacks",
      "s3:GetBucketPolicy",
      "s3:GetBucketVersioning",
      "s3:GetObjectVersion",
      "s3:ListAllMyBuckets",
      "s3:ListBucket",
      "sns:ListTopics",
      "codestar-notifications:ListNotificationRules",
      "codestar-notifications:ListTargets",
      "codestar-notifications:ListTagsforResource",
      "codestar-notifications:ListEventTypes",
      "states:ListStateMachines"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "s3:GetObject",
      "s3:CreateBucket",
      "s3:PutBucketPolicy"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:s3::*:codepipeline-*"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":[
        "events.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/service-role/cwe-role-*"
     ]
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":[
        "codepipeline.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "events:PutRule",
      "events:PutTargets",
      "events:DeleteRule",
      "events:DisableRule",
      "events:RemoveTargets"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:events:*:*:rule/codepipeline-*"
     ]
    },
    {
     "Action":[
      "codestar-notifications:CreateNotificationRule",
      "codestar-notifications:DescribeNotificationRule",
      "codestar-notifications:UpdateNotificationRule",
      "codestar-notifications:DeleteNotificationRule",
      "codestar-notifications:Subscribe",
      "codestar-notifications:Unsubscribe"
     ],
     "Condition":{
      "StringLike":{
       "codestar-notifications:NotificationsForResource":"arn:aws:codepipeline:*"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CodeStarNotificationsReadWriteAccess"
    },
    {
     "Action":[
      "sns:CreateTopic",
      "sns:SetTopicAttributes"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:sns:*:*:codestar-notifications*",
     "Sid":"CodeStarNotificationsSNSTopicCreateAccess"
    },
    {
     "Action":[
      "chatbot:DescribeSlackChannelConfigurations"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CodeStarNotificationsChatbotAccess"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-05-21T22:03:13+00:00"
 },
 "AWSCodePipelineReadOnlyAccess":{
  "CreateDate":"2015-07-09T16:43:57+00:00",
  "DefaultVersionId":"v9",
  "Document":{
   "Statement":[
    {
     "Action":[
      "codepipeline:GetPipeline",
      "codepipeline:GetPipelineState",
      "codepipeline:GetPipelineExecution",
      "codepipeline:ListPipelineExecutions",
      "codepipeline:ListActionExecutions",
      "codepipeline:ListActionTypes",
      "codepipeline:ListPipelines",
      "codepipeline:ListTagsForResource",
      "iam:ListRoles",
      "s3:GetBucketPolicy",
      "s3:GetObject",
      "s3:ListAllMyBuckets",
      "s3:ListBucket",
      "codecommit:ListBranches",
      "codecommit:ListRepositories",
      "codedeploy:GetApplication",
      "codedeploy:GetDeploymentGroup",
      "codedeploy:ListApplications",
      "codedeploy:ListDeploymentGroups",
      "elasticbeanstalk:DescribeApplications",
      "elasticbeanstalk:DescribeEnvironments",
      "lambda:GetFunctionConfiguration",
      "lambda:ListFunctions",
      "opsworks:DescribeApps",
      "opsworks:DescribeLayers",
      "opsworks:DescribeStacks",
      "codestar-notifications:ListNotificationRules",
      "codestar-notifications:ListEventTypes",
      "codestar-notifications:ListTargets"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "codestar-notifications:DescribeNotificationRule"
     ],
     "Condition":{
      "StringLike":{
       "codestar-notifications:NotificationsForResource":"arn:aws:codepipeline:*"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CodeStarNotificationsReadOnlyAccess"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-03-26T16:07:17+00:00"
 },
 "AWSCodePipeline_FullAccess":{
  "CreateDate":"2020-08-03T22:38:28+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "codepipeline:*",
      "cloudformation:DescribeStacks",
      "cloudformation:ListChangeSets",
      "cloudtrail:DescribeTrails",
      "codebuild:BatchGetProjects",
      "codebuild:CreateProject",
      "codebuild:ListCuratedEnvironmentImages",
      "codebuild:ListProjects",
      "codecommit:ListBranches",
      "codecommit:GetReferences",
      "codecommit:ListRepositories",
      "codedeploy:BatchGetDeploymentGroups",
      "codedeploy:ListApplications",
      "codedeploy:ListDeploymentGroups",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeSubnets",
      "ec2:DescribeVpcs",
      "ecr:DescribeRepositories",
      "ecr:ListImages",
      "ecs:ListClusters",
      "ecs:ListServices",
      "elasticbeanstalk:DescribeApplications",
      "elasticbeanstalk:DescribeEnvironments",
      "iam:ListRoles",
      "iam:GetRole",
      "lambda:ListFunctions",
      "events:ListRules",
      "events:ListTargetsByRule",
      "events:DescribeRule",
      "opsworks:DescribeApps",
      "opsworks:DescribeLayers",
      "opsworks:DescribeStacks",
      "s3:ListAllMyBuckets",
      "sns:ListTopics",
      "codestar-notifications:ListNotificationRules",
      "codestar-notifications:ListTargets",
      "codestar-notifications:ListTagsforResource",
      "codestar-notifications:ListEventTypes",
      "states:ListStateMachines"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "s3:GetObject",
      "s3:ListBucket",
      "s3:GetBucketPolicy",
      "s3:GetBucketVersioning",
      "s3:GetObjectVersion",
      "s3:CreateBucket",
      "s3:PutBucketPolicy"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:s3::*:codepipeline-*"
    },
    {
     "Action":[
      "cloudtrail:PutEventSelectors",
      "cloudtrail:CreateTrail",
      "cloudtrail:GetEventSelectors",
      "cloudtrail:StartLogging"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:cloudtrail:*:*:trail/codepipeline-source-trail"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":[
        "events.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/service-role/cwe-role-*"
     ]
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":[
        "codepipeline.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "events:PutRule",
      "events:PutTargets",
      "events:DeleteRule",
      "events:DisableRule",
      "events:RemoveTargets"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:events:*:*:rule/codepipeline-*"
     ]
    },
    {
     "Action":[
      "codestar-notifications:CreateNotificationRule",
      "codestar-notifications:DescribeNotificationRule",
      "codestar-notifications:UpdateNotificationRule",
      "codestar-notifications:DeleteNotificationRule",
      "codestar-notifications:Subscribe",
      "codestar-notifications:Unsubscribe"
     ],
     "Condition":{
      "StringLike":{
       "codestar-notifications:NotificationsForResource":"arn:aws:codepipeline:*"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CodeStarNotificationsReadWriteAccess"
    },
    {
     "Action":[
      "sns:CreateTopic",
      "sns:SetTopicAttributes"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:sns:*:*:codestar-notifications*",
     "Sid":"CodeStarNotificationsSNSTopicCreateAccess"
    },
    {
     "Action":[
      "chatbot:DescribeSlackChannelConfigurations"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CodeStarNotificationsChatbotAccess"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-08-03T22:38:28+00:00"
 },
 "AWSCodePipeline_ReadOnlyAccess":{
  "CreateDate":"2020-08-03T22:25:17+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "codepipeline:GetPipeline",
      "codepipeline:GetPipelineState",
      "codepipeline:GetPipelineExecution",
      "codepipeline:ListPipelineExecutions",
      "codepipeline:ListActionExecutions",
      "codepipeline:ListActionTypes",
      "codepipeline:ListPipelines",
      "codepipeline:ListTagsForResource",
      "s3:ListAllMyBuckets",
      "codestar-notifications:ListNotificationRules",
      "codestar-notifications:ListEventTypes",
      "codestar-notifications:ListTargets"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "s3:GetObject",
      "s3:ListBucket",
      "s3:GetBucketPolicy"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:s3::*:codepipeline-*"
    },
    {
     "Action":[
      "codestar-notifications:DescribeNotificationRule"
     ],
     "Condition":{
      "StringLike":{
       "codestar-notifications:NotificationsForResource":"arn:aws:codepipeline:*"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CodeStarNotificationsReadOnlyAccess"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-08-03T22:25:17+00:00"
 },
 "AWSCodeStarFullAccess":{
  "CreateDate":"2017-04-19T16:23:19+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "codestar:*",
      "ec2:DescribeKeyPairs",
      "ec2:DescribeVpcs",
      "ec2:DescribeSubnets",
      "cloud9:DescribeEnvironment*",
      "cloud9:ValidateEnvironmentName"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CodeStarEC2"
    },
    {
     "Action":[
      "cloudformation:DescribeStack*",
      "cloudformation:GetTemplateSummary"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:cloudformation:*:*:stack/awscodestar-*"
     ],
     "Sid":"CodeStarCF"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2018-01-10T21:54:06+00:00"
 },
 "AWSCodeStarNotificationsServiceRolePolicy":{
  "CreateDate":"2019-11-05T16:10:21+00:00",
  "DefaultVersionId":"v4",
  "Document":{
   "Statement":[
    {
     "Action":[
      "events:PutTargets",
      "events:PutRule",
      "events:DescribeRule"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:events:*:*:rule/awscodestarnotifications-*"
    },
    {
     "Action":[
      "sns:CreateTopic"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:sns:*:*:CodeStarNotifications-*"
    },
    {
     "Action":[
      "codecommit:GetCommentsForPullRequest",
      "codecommit:GetCommentsForComparedCommit",
      "chatbot:DescribeSlackChannelConfigurations",
      "chatbot:UpdateSlackChannelConfiguration",
      "codecommit:GetDifferences",
      "codepipeline:ListActionExecutions"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "codecommit:GetFile"
     ],
     "Condition":{
      "StringNotEquals":{
       "aws:ResourceTag/ExcludeFileContentFromNotifications":"true"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-03-19T16:01:55+00:00"
 },
 "AWSCodeStarServiceRole":{
  "CreateDate":"2017-04-19T15:20:50+00:00",
  "DefaultVersionId":"v11",
  "Document":{
   "Statement":[
    {
     "Action":[
      "events:PutTargets",
      "events:RemoveTargets",
      "events:PutRule",
      "events:DeleteRule",
      "events:DescribeRule"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:events:*:*:rule/awscodestar-*"
     ],
     "Sid":"ProjectEventRules"
    },
    {
     "Action":[
      "cloudformation:*Stack*",
      "cloudformation:CreateChangeSet",
      "cloudformation:ExecuteChangeSet",
      "cloudformation:DeleteChangeSet",
      "cloudformation:GetTemplate"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:cloudformation:*:*:stack/awscodestar-*",
      "arn:aws:cloudformation:*:*:stack/awseb-*",
      "arn:aws:cloudformation:*:*:stack/aws-cloud9-*",
      "arn:aws:cloudformation:*:aws:transform/CodeStar*"
     ],
     "Sid":"ProjectStack"
    },
    {
     "Action":[
      "cloudformation:GetTemplateSummary",
      "cloudformation:DescribeChangeSet"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ProjectStackTemplate"
    },
    {
     "Action":[
      "s3:GetObject"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::awscodestar-*/*"
     ],
     "Sid":"ProjectQuickstarts"
    },
    {
     "Action":[
      "s3:*"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::aws-codestar-*",
      "arn:aws:s3:::elasticbeanstalk-*"
     ],
     "Sid":"ProjectS3Buckets"
    },
    {
     "Action":[
      "codestar:*",
      "codecommit:*",
      "codepipeline:*",
      "codedeploy:*",
      "codebuild:*",
      "autoscaling:*",
      "cloudwatch:Put*",
      "ec2:*",
      "elasticbeanstalk:*",
      "elasticloadbalancing:*",
      "iam:ListRoles",
      "logs:*",
      "sns:*",
      "cloud9:CreateEnvironmentEC2",
      "cloud9:DeleteEnvironment",
      "cloud9:DescribeEnvironment*",
      "cloud9:ListEnvironments"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ProjectServices"
    },
    {
     "Action":[
      "iam:AttachRolePolicy",
      "iam:CreateRole",
      "iam:DeleteRole",
      "iam:DeleteRolePolicy",
      "iam:DetachRolePolicy",
      "iam:GetRole",
      "iam:PassRole",
      "iam:GetRolePolicy",
      "iam:PutRolePolicy",
      "iam:SetDefaultPolicyVersion",
      "iam:CreatePolicy",
      "iam:DeletePolicy",
      "iam:AddRoleToInstanceProfile",
      "iam:CreateInstanceProfile",
      "iam:DeleteInstanceProfile",
      "iam:RemoveRoleFromInstanceProfile"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/CodeStarWorker*",
      "arn:aws:iam::*:policy/CodeStarWorker*",
      "arn:aws:iam::*:instance-profile/awscodestar-*"
     ],
     "Sid":"ProjectWorkerRoles"
    },
    {
     "Action":[
      "iam:AttachUserPolicy",
      "iam:DetachUserPolicy"
     ],
     "Condition":{
      "ArnEquals":{
       "iam:PolicyArn":[
        "arn:aws:iam::*:policy/CodeStar_*"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ProjectTeamMembers"
    },
    {
     "Action":[
      "iam:CreatePolicy",
      "iam:DeletePolicy",
      "iam:CreatePolicyVersion",
      "iam:DeletePolicyVersion",
      "iam:ListEntitiesForPolicy",
      "iam:ListPolicyVersions",
      "iam:GetPolicy",
      "iam:GetPolicyVersion"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:policy/CodeStar_*"
     ],
     "Sid":"ProjectRoles"
    },
    {
     "Action":[
      "iam:ListAttachedRolePolicies"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/aws-codestar-service-role",
      "arn:aws:iam::*:role/service-role/aws-codestar-service-role"
     ],
     "Sid":"InspectServiceRole"
    },
    {
     "Action":[
      "iam:CreateServiceLinkedRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":"cloud9.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"IAMLinkRole"
    },
    {
     "Action":[
      "config:DescribeConfigRules"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"DescribeConfigRuleForARN"
    },
    {
     "Action":[
      "codestar-connections:UseConnection",
      "codestar-connections:GetConnection"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ProjectCodeStarConnections"
    },
    {
     "Action":"codestar-connections:PassConnection",
     "Condition":{
      "StringEqualsIfExists":{
       "codestar-connections:PassedToService":"codepipeline.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ProjectCodeStarConnectionsPassConnections"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-09-20T19:11:03+00:00"
 },
 "AWSCompromisedKeyQuarantine":{
  "CreateDate":"2020-08-11T18:04:13+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iam:AttachGroupPolicy",
      "iam:AttachRolePolicy",
      "iam:AttachUserPolicy",
      "iam:ChangePassword",
      "iam:CreateAccessKey",
      "iam:CreateInstanceProfile",
      "iam:CreateLoginProfile",
      "iam:CreateRole",
      "iam:CreateUser",
      "iam:DetachUserPolicy",
      "iam:PutUserPermissionsBoundary",
      "iam:PutUserPolicy",
      "iam:UpdateAccessKey",
      "iam:UpdateAccountPasswordPolicy",
      "iam:UpdateUser",
      "ec2:RequestSpotInstances",
      "ec2:RunInstances",
      "ec2:StartInstances",
      "organizations:CreateAccount",
      "organizations:CreateOrganization",
      "organizations:InviteAccountToOrganization",
      "lambda:CreateFunction",
      "lightsail:Create*",
      "lightsail:Start*",
      "lightsail:Delete*",
      "lightsail:Update*",
      "lightsail:GetInstanceAccessDetails",
      "lightsail:DownloadDefaultKeyPair"
     ],
     "Effect":"Deny",
     "Resource":[
      "*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-08-11T18:04:13+00:00"
 },
 "AWSCompromisedKeyQuarantineV2":{
  "CreateDate":"2021-04-21T22:30:59+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:RequestSpotInstances",
      "ec2:RunInstances",
      "ec2:StartInstances",
      "iam:AddUserToGroup",
      "iam:AttachGroupPolicy",
      "iam:AttachRolePolicy",
      "iam:AttachUserPolicy",
      "iam:ChangePassword",
      "iam:CreateAccessKey",
      "iam:CreateInstanceProfile",
      "iam:CreateLoginProfile",
      "iam:CreatePolicyVersion",
      "iam:CreateRole",
      "iam:CreateUser",
      "iam:DetachUserPolicy",
      "iam:PassRole",
      "iam:PutGroupPolicy",
      "iam:PutRolePolicy",
      "iam:PutUserPermissionsBoundary",
      "iam:PutUserPolicy",
      "iam:SetDefaultPolicyVersion",
      "iam:UpdateAccessKey",
      "iam:UpdateAccountPasswordPolicy",
      "iam:UpdateAssumeRolePolicy",
      "iam:UpdateLoginProfile",
      "iam:UpdateUser",
      "lambda:AddLayerVersionPermission",
      "lambda:AddPermission",
      "lambda:CreateFunction",
      "lambda:GetPolicy",
      "lambda:ListTags",
      "lambda:PutProvisionedConcurrencyConfig",
      "lambda:TagResource",
      "lambda:UntagResource",
      "lambda:UpdateFunctionCode",
      "lightsail:Create*",
      "lightsail:Delete*",
      "lightsail:DownloadDefaultKeyPair",
      "lightsail:GetInstanceAccessDetails",
      "lightsail:Start*",
      "lightsail:Update*",
      "organizations:CreateAccount",
      "organizations:CreateOrganization",
      "organizations:InviteAccountToOrganization",
      "s3:DeleteBucket",
      "s3:DeleteObject",
      "s3:DeleteObjectVersion",
      "s3:PutLifecycleConfiguration",
      "s3:PutBucketAcl",
      "s3:PutBucketOwnershipControls",
      "s3:DeleteBucketPolicy",
      "s3:ObjectOwnerOverrideToBucketOwner",
      "s3:PutAccountPublicAccessBlock",
      "s3:PutBucketPolicy",
      "s3:ListAllMyBuckets"
     ],
     "Effect":"Deny",
     "Resource":[
      "*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-11-11T21:32:48+00:00"
 },
 "AWSConfigMultiAccountSetupPolicy":{
  "CreateDate":"2019-06-17T18:03:16+00:00",
  "DefaultVersionId":"v4",
  "Document":{
   "Statement":[
    {
     "Action":[
      "config:PutConfigRule",
      "config:DeleteConfigRule"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:config:*:*:config-rule/aws-service-rule/config-multiaccountsetup.amazonaws.com/*"
    },
    {
     "Action":[
      "config:DescribeConfigurationRecorders"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "organizations:ListAccounts",
      "organizations:DescribeOrganization",
      "organizations:ListAWSServiceAccessForOrganization",
      "organizations:DescribeAccount"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "config:PutConformancePack",
      "config:DeleteConformancePack",
      "config:DescribeConformancePackStatus"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:config:*:*:conformance-pack/aws-service-conformance-pack/config-multiaccountsetup.amazonaws.com/*"
    },
    {
     "Action":[
      "iam:GetRole"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/aws-service-role/config-conforms.amazonaws.com/AWSServiceRoleForConfigConforms"
    },
    {
     "Action":[
      "iam:CreateServiceLinkedRole"
     ],
     "Condition":{
      "StringLike":{
       "iam:AWSServiceName":"config-conforms.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/aws-service-role/config-conforms.amazonaws.com/AWSServiceRoleForConfigConforms"
    },
    {
     "Action":"iam:PassRole",
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":"ssm.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-05-21T22:59:26+00:00"
 },
 "AWSConfigRemediationServiceRolePolicy":{
  "CreateDate":"2019-06-18T21:21:35+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ssm:GetDocument",
      "ssm:DescribeDocument",
      "ssm:StartAutomationExecution"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"iam:PassRole",
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":"ssm.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-06-18T21:21:35+00:00"
 },
 "AWSConfigRole":{
  "CreateDate":"2015-04-02T17:36:23+00:00",
  "DefaultVersionId":"v42",
  "Document":{
   "Statement":[
    {
     "Action":[
      "access-analyzer:GetAnalyzer",
      "access-analyzer:GetArchiveRule",
      "access-analyzer:ListAnalyzers",
      "access-analyzer:ListArchiveRules",
      "access-analyzer:ListTagsForResource",
      "account:GetAlternateContact",
      "acm:DescribeCertificate",
      "acm:ListCertificates",
      "acm:ListTagsForCertificate",
      "apigateway:GET",
      "application-autoscaling:DescribeScalableTargets",
      "application-autoscaling:DescribeScalingPolicies",
      "autoscaling:DescribeAutoScalingGroups",
      "autoscaling:DescribeLaunchConfigurations",
      "autoscaling:DescribeLifecycleHooks",
      "autoscaling:DescribePolicies",
      "autoscaling:DescribeScheduledActions",
      "autoscaling:DescribeTags",
      "backup:DescribeBackupVault",
      "backup:DescribeRecoveryPoint",
      "backup:GetBackupPlan",
      "backup:GetBackupSelection",
      "backup:GetBackupVaultAccessPolicy",
      "backup:GetBackupVaultNotifications",
      "backup:ListBackupPlans",
      "backup:ListBackupSelections",
      "backup:ListBackupVaults",
      "backup:ListRecoveryPointsByBackupVault",
      "backup:ListTags",
      "cloudformation:DescribeType",
      "cloudformation:ListTypes",
      "cloudfront:ListDistributions",
      "cloudfront:ListTagsForResource",
      "cloudtrail:DescribeTrails",
      "cloudtrail:GetEventSelectors",
      "cloudtrail:GetTrailStatus",
      "cloudtrail:ListTags",
      "cloudwatch:DescribeAlarms",
      "codedeploy:GetDeploymentConfig",
      "codepipeline:GetPipeline",
      "codepipeline:GetPipelineState",
      "codepipeline:ListPipelines",
      "config:BatchGet*",
      "config:Describe*",
      "config:Get*",
      "config:List*",
      "config:Put*",
      "config:Select*",
      "dax:DescribeClusters",
      "dms:DescribeEventSubscriptions",
      "dms:DescribeReplicationInstances",
      "dms:DescribeReplicationSubnetGroups",
      "dms:ListTagsForResource",
      "dynamodb:DescribeContinuousBackups",
      "dynamodb:DescribeLimits",
      "dynamodb:DescribeTable",
      "dynamodb:ListTables",
      "dynamodb:ListTagsOfResource",
      "ec2:Describe*",
      "ec2:GetEbsEncryptionByDefault",
      "ecr-public:DescribeRepositories",
      "ecr-public:GetRepositoryCatalogData",
      "ecr-public:GetRepositoryPolicy",
      "ecr-public:ListTagsForResource",
      "ecr:DescribeRepositories",
      "ecr:GetLifecyclePolicy",
      "ecr:GetRepositoryPolicy",
      "ecr:ListTagsForResource",
      "ecs:DescribeClusters",
      "ecs:DescribeServices",
      "ecs:DescribeTaskDefinition",
      "ecs:DescribeTaskSets",
      "ecs:ListClusters",
      "ecs:ListServices",
      "ecs:ListTagsForResource",
      "ecs:ListTaskDefinitionFamilies",
      "ecs:ListTaskDefinitions",
      "eks:DescribeCluster",
      "eks:DescribeNodegroup",
      "eks:ListClusters",
      "eks:ListNodegroups",
      "elasticache:DescribeCacheClusters",
      "elasticache:DescribeCacheParameterGroups",
      "elasticache:DescribeCacheSubnetGroups",
      "elasticache:DescribeReplicationGroups",
      "elasticache:DescribeSnapshots",
      "elasticache:ListTagsForResource",
      "elasticbeanstalk:DescribeConfigurationSettings",
      "elasticbeanstalk:DescribeEnvironments",
      "elasticfilesystem:DescribeAccessPoints",
      "elasticfilesystem:DescribeBackupPolicy",
      "elasticfilesystem:DescribeFileSystemPolicy",
      "elasticfilesystem:DescribeFileSystems",
      "elasticfilesystem:DescribeLifecycleConfiguration",
      "elasticfilesystem:DescribeMountTargets",
      "elasticfilesystem:DescribeMountTargetSecurityGroups",
      "elasticloadbalancing:DescribeListeners",
      "elasticloadbalancing:DescribeLoadBalancerAttributes",
      "elasticloadbalancing:DescribeLoadBalancerPolicies",
      "elasticloadbalancing:DescribeLoadBalancers",
      "elasticloadbalancing:DescribeRules",
      "elasticloadbalancing:DescribeTags",
      "elasticmapreduce:DescribeCluster",
      "elasticmapreduce:DescribeSecurityConfiguration",
      "elasticmapreduce:DescribeStep",
      "elasticmapreduce:GetBlockPublicAccessConfiguration",
      "elasticmapreduce:GetManagedScalingPolicy",
      "elasticmapreduce:ListClusters",
      "elasticmapreduce:ListInstanceFleets",
      "elasticmapreduce:ListInstanceGroups",
      "elasticmapreduce:ListInstances",
      "elasticmapreduce:ListSecurityConfigurations",
      "elasticmapreduce:ListSteps",
      "es:DescribeDomain",
      "es:DescribeDomains",
      "es:DescribeElasticsearchDomain",
      "es:DescribeElasticsearchDomains",
      "es:GetCompatibleElasticsearchVersions",
      "es:GetCompatibleVersions",
      "es:ListDomainNames",
      "es:ListTags",
      "firehose:DescribeDeliveryStream",
      "firehose:ListDeliveryStreams",
      "firehose:ListTagsForDeliveryStream",
      "fsx:DescribeFileSystems",
      "globalaccelerator:DescribeAccelerator",
      "globalaccelerator:DescribeEndpointGroup",
      "globalaccelerator:DescribeListener",
      "globalaccelerator:ListAccelerators",
      "globalaccelerator:ListEndpointGroups",
      "globalaccelerator:ListListeners",
      "globalaccelerator:ListTagsForResource",
      "guardduty:GetDetector",
      "guardduty:GetFindings",
      "guardduty:GetMasterAccount",
      "guardduty:ListDetectors",
      "guardduty:ListFindings",
      "iam:GenerateCredentialReport",
      "iam:GetAccountAuthorizationDetails",
      "iam:GetAccountPasswordPolicy",
      "iam:GetAccountSummary",
      "iam:GetCredentialReport",
      "iam:GetGroup",
      "iam:GetGroupPolicy",
      "iam:GetPolicy",
      "iam:GetPolicyVersion",
      "iam:GetRole",
      "iam:GetRolePolicy",
      "iam:GetUser",
      "iam:GetUserPolicy",
      "iam:ListAttachedGroupPolicies",
      "iam:ListAttachedRolePolicies",
      "iam:ListAttachedUserPolicies",
      "iam:ListEntitiesForPolicy",
      "iam:ListGroupPolicies",
      "iam:ListGroupsForUser",
      "iam:ListInstanceProfilesForRole",
      "iam:ListPolicyVersions",
      "iam:ListRolePolicies",
      "iam:ListUserPolicies",
      "iam:ListVirtualMFADevices",
      "kafka:DescribeCluster",
      "kafka:ListClusters",
      "kinesis:DescribeStreamConsumer",
      "kinesis:DescribeStreamSummary",
      "kinesis:ListStreamConsumers",
      "kinesis:ListStreams",
      "kinesis:ListTagsForStream",
      "kms:DescribeKey",
      "kms:GetKeyPolicy",
      "kms:GetKeyRotationStatus",
      "kms:ListKeys",
      "kms:ListResourceTags",
      "lambda:GetAlias",
      "lambda:GetFunction",
      "lambda:GetFunctionCodeSigningConfig",
      "lambda:GetPolicy",
      "lambda:ListAliases",
      "lambda:ListFunctions",
      "lambda:ListVersionsByFunction",
      "logs:DescribeLogGroups",
      "logs:ListTagsLogGroup",
      "network-firewall:DescribeLoggingConfiguration",
      "network-firewall:ListFirewalls",
      "organizations:DescribeOrganization",
      "organizations:DescribePolicy",
      "organizations:ListParents",
      "organizations:ListPoliciesForTarget",
      "rds:DescribeDBClusters",
      "rds:DescribeDBClusterSnapshotAttributes",
      "rds:DescribeDBClusterSnapshots",
      "rds:DescribeDBEngineVersions",
      "rds:DescribeDBInstances",
      "rds:DescribeDBParameterGroups",
      "rds:DescribeDBParameters",
      "rds:DescribeDBSecurityGroups",
      "rds:DescribeDBSnapshotAttributes",
      "rds:DescribeDBSnapshots",
      "rds:DescribeDBSubnetGroups",
      "rds:DescribeEventSubscriptions",
      "rds:DescribeOptionGroups",
      "rds:ListTagsForResource",
      "redshift:DescribeClusterParameterGroups",
      "redshift:DescribeClusterParameters",
      "redshift:DescribeClusters",
      "redshift:DescribeClusterSecurityGroups",
      "redshift:DescribeClusterSnapshots",
      "redshift:DescribeClusterSubnetGroups",
      "redshift:DescribeEventSubscriptions",
      "redshift:DescribeLoggingStatus",
      "route53:GetHealthCheck",
      "route53:GetHostedZone",
      "route53:ListHealthChecks",
      "route53:ListHostedZones",
      "route53:ListHostedZonesByName",
      "route53:ListQueryLoggingConfigs",
      "route53:ListResourceRecordSets",
      "route53:ListTagsForResource",
      "route53resolver:GetResolverEndpoint",
      "route53resolver:GetResolverRule",
      "route53resolver:GetResolverRuleAssociation",
      "route53resolver:ListResolverEndpointIpAddresses",
      "route53resolver:ListResolverEndpoints",
      "route53resolver:ListResolverRuleAssociations",
      "route53resolver:ListResolverRules",
      "route53resolver:ListTagsForResource",
      "s3:GetAccelerateConfiguration",
      "s3:GetAccessPoint",
      "s3:GetAccessPointPolicy",
      "s3:GetAccessPointPolicyStatus",
      "s3:GetAccountPublicAccessBlock",
      "s3:GetBucketAcl",
      "s3:GetBucketCORS",
      "s3:GetBucketLocation",
      "s3:GetBucketLogging",
      "s3:GetBucketNotification",
      "s3:GetBucketObjectLockConfiguration",
      "s3:GetBucketPolicy",
      "s3:GetBucketPublicAccessBlock",
      "s3:GetBucketRequestPayment",
      "s3:GetBucketTagging",
      "s3:GetBucketVersioning",
      "s3:GetBucketWebsite",
      "s3:GetEncryptionConfiguration",
      "s3:GetLifecycleConfiguration",
      "s3:GetObject",
      "s3:GetReplicationConfiguration",
      "s3:ListAccessPoints",
      "s3:ListAllMyBuckets",
      "s3:ListBucket",
      "sagemaker:DescribeCodeRepository",
      "sagemaker:DescribeEndpoint",
      "sagemaker:DescribeEndpointConfig",
      "sagemaker:DescribeModel",
      "sagemaker:DescribeMonitoringSchedule",
      "sagemaker:DescribeNotebookInstance",
      "sagemaker:DescribeNotebookInstanceLifecycleConfig",
      "sagemaker:DescribeWorkteam",
      "sagemaker:ListCodeRepositories",
      "sagemaker:ListEndpointConfigs",
      "sagemaker:ListEndpoints",
      "sagemaker:ListModels",
      "sagemaker:ListMonitoringSchedules",
      "sagemaker:ListNotebookInstanceLifecycleConfigs",
      "sagemaker:ListNotebookInstances",
      "sagemaker:ListTags",
      "sagemaker:ListWorkteams",
      "secretsmanager:ListSecrets",
      "secretsmanager:ListSecretVersionIds",
      "securityhub:DescribeHub",
      "shield:DescribeDRTAccess",
      "shield:DescribeProtection",
      "shield:DescribeSubscription",
      "sns:GetSubscriptionAttributes",
      "sns:GetTopicAttributes",
      "sns:ListSubscriptions",
      "sns:ListSubscriptionsByTopic",
      "sns:ListTagsForResource",
      "sns:ListTopics",
      "sqs:GetQueueAttributes",
      "sqs:ListQueues",
      "sqs:ListQueueTags",
      "ssm:DescribeAutomationExecutions",
      "ssm:DescribeDocument",
      "ssm:DescribeDocumentPermission",
      "ssm:GetAutomationExecution",
      "ssm:GetDocument",
      "ssm:ListDocuments",
      "states:DescribeStateMachine",
      "states:ListStateMachines",
      "states:ListTagsForResource",
      "storagegateway:ListGateways",
      "storagegateway:ListTagsForResource",
      "storagegateway:ListVolumes",
      "support:DescribeCases",
      "tag:GetResources",
      "waf-regional:GetLoggingConfiguration",
      "waf-regional:GetWebACL",
      "waf-regional:GetWebACLForResource",
      "waf:GetLoggingConfiguration",
      "waf:GetWebACL",
      "wafv2:GetLoggingConfiguration"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-02-10T18:33:55+00:00"
 },
 "AWSConfigRoleForOrganizations":{
  "CreateDate":"2018-03-19T22:53:01+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "organizations:ListAccounts",
      "organizations:DescribeOrganization",
      "organizations:ListAWSServiceAccessForOrganization",
      "organizations:ListDelegatedAdministrators"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-11-24T20:19:13+00:00"
 },
 "AWSConfigRulesExecutionRole":{
  "CreateDate":"2016-03-25T17:59:36+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "s3:GetObject"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::*/AWSLogs/*/Config/*"
    },
    {
     "Action":[
      "config:Put*",
      "config:Get*",
      "config:List*",
      "config:Describe*",
      "config:BatchGet*",
      "config:Select*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-05-13T21:33:30+00:00"
 },
 "AWSConfigServiceRolePolicy":{
  "CreateDate":"2018-05-30T23:31:46+00:00",
  "DefaultVersionId":"v32",
  "Document":{
   "Statement":[
    {
     "Action":[
      "access-analyzer:GetAnalyzer",
      "access-analyzer:GetArchiveRule",
      "access-analyzer:ListAnalyzers",
      "access-analyzer:ListArchiveRules",
      "access-analyzer:ListTagsForResource",
      "account:GetAlternateContact",
      "acm:DescribeCertificate",
      "acm:ListCertificates",
      "acm:ListTagsForCertificate",
      "apigateway:GET",
      "application-autoscaling:DescribeScalableTargets",
      "application-autoscaling:DescribeScalingPolicies",
      "athena:GetDataCatalog",
      "athena:GetWorkGroup",
      "athena:ListDataCatalogs",
      "athena:ListTagsForResource",
      "athena:ListWorkGroups",
      "autoscaling:DescribeAutoScalingGroups",
      "autoscaling:DescribeLaunchConfigurations",
      "autoscaling:DescribeLifecycleHooks",
      "autoscaling:DescribePolicies",
      "autoscaling:DescribeScheduledActions",
      "autoscaling:DescribeTags",
      "backup-gateway:ListTagsForResource",
      "backup-gateway:ListVirtualMachines",
      "backup:DescribeBackupVault",
      "backup:DescribeRecoveryPoint",
      "backup:GetBackupPlan",
      "backup:GetBackupSelection",
      "backup:GetBackupVaultAccessPolicy",
      "backup:GetBackupVaultNotifications",
      "backup:ListBackupPlans",
      "backup:ListBackupSelections",
      "backup:ListBackupVaults",
      "backup:ListRecoveryPointsByBackupVault",
      "backup:ListTags",
      "batch:DescribeComputeEnvironments",
      "batch:DescribeJobQueues",
      "batch:ListTagsForResource",
      "cloudformation:DescribeType",
      "cloudformation:GetResource",
      "cloudformation:ListResources",
      "cloudformation:ListTypes",
      "cloudfront:ListDistributions",
      "cloudfront:ListTagsForResource",
      "cloudtrail:DescribeTrails",
      "cloudtrail:GetEventDataStore",
      "cloudtrail:GetEventSelectors",
      "cloudtrail:GetTrailStatus",
      "cloudtrail:ListEventDataStores",
      "cloudtrail:ListTags",
      "cloudwatch:DescribeAlarms",
      "codedeploy:GetDeploymentConfig",
      "codepipeline:GetPipeline",
      "codepipeline:GetPipelineState",
      "codepipeline:ListPipelines",
      "config:BatchGet*",
      "config:Describe*",
      "config:Get*",
      "config:List*",
      "config:Put*",
      "config:Select*",
      "dax:DescribeClusters",
      "dax:DescribeParameterGroups",
      "dax:DescribeParameters",
      "dax:DescribeSubnetGroups",
      "dax:ListTags",
      "detective:ListTagsForResource",
      "detective:ListGraphs",
      "dms:DescribeCertificates",
      "dms:DescribeEventSubscriptions",
      "dms:DescribeReplicationInstances",
      "dms:DescribeReplicationSubnetGroups",
      "dms:DescribeReplicationTasks",
      "dms:ListTagsForResource",
      "dynamodb:DescribeContinuousBackups",
      "dynamodb:DescribeGlobalTable",
      "dynamodb:DescribeGlobalTableSettings",
      "dynamodb:DescribeLimits",
      "dynamodb:DescribeTable",
      "dynamodb:ListTables",
      "dynamodb:ListTagsOfResource",
      "ec2:Describe*",
      "ec2:DescribeClientVpnAuthorizationRules",
      "ec2:DescribeClientVpnEndpoints",
      "ec2:DescribeDhcpOptions",
      "ec2:DescribeFleets",
      "ec2:DescribeNetworkAcls",
      "ec2:DescribePlacementGroups",
      "ec2:DescribeSpotFleetRequests",
      "ec2:DescribeVolumeAttribute",
      "ec2:DescribeVolumes",
      "ec2:GetEbsEncryptionByDefault",
      "ecr-public:DescribeRepositories",
      "ecr-public:GetRepositoryCatalogData",
      "ecr-public:GetRepositoryPolicy",
      "ecr-public:ListTagsForResource",
      "ecr:DescribeRepositories",
      "ecr:GetLifecyclePolicy",
      "ecr:GetRepositoryPolicy",
      "ecr:ListTagsForResource",
      "ecs:DescribeClusters",
      "ecs:DescribeServices",
      "ecs:DescribeTaskDefinition",
      "ecs:DescribeTaskSets",
      "ecs:ListClusters",
      "ecs:ListServices",
      "ecs:ListTagsForResource",
      "ecs:ListTaskDefinitionFamilies",
      "ecs:ListTaskDefinitions",
      "eks:DescribeCluster",
      "eks:DescribeFargateProfile",
      "eks:DescribeNodegroup",
      "eks:ListClusters",
      "eks:ListFargateProfiles",
      "eks:ListNodegroups",
      "eks:ListTagsForResource",
      "elasticache:DescribeCacheClusters",
      "elasticache:DescribeCacheParameterGroups",
      "elasticache:DescribeCacheSubnetGroups",
      "elasticache:DescribeReplicationGroups",
      "elasticache:DescribeSnapshots",
      "elasticache:ListTagsForResource",
      "elasticbeanstalk:DescribeConfigurationSettings",
      "elasticbeanstalk:DescribeEnvironments",
      "elasticfilesystem:DescribeAccessPoints",
      "elasticfilesystem:DescribeBackupPolicy",
      "elasticfilesystem:DescribeFileSystemPolicy",
      "elasticfilesystem:DescribeFileSystems",
      "elasticfilesystem:DescribeLifecycleConfiguration",
      "elasticfilesystem:DescribeMountTargets",
      "elasticfilesystem:DescribeMountTargetSecurityGroups",
      "elasticloadbalancing:DescribeListeners",
      "elasticloadbalancing:DescribeLoadBalancerAttributes",
      "elasticloadbalancing:DescribeLoadBalancerPolicies",
      "elasticloadbalancing:DescribeLoadBalancers",
      "elasticloadbalancing:DescribeRules",
      "elasticloadbalancing:DescribeTags",
      "elasticmapreduce:DescribeCluster",
      "elasticmapreduce:DescribeSecurityConfiguration",
      "elasticmapreduce:DescribeStep",
      "elasticmapreduce:GetBlockPublicAccessConfiguration",
      "elasticmapreduce:GetManagedScalingPolicy",
      "elasticmapreduce:ListClusters",
      "elasticmapreduce:ListInstanceFleets",
      "elasticmapreduce:ListInstanceGroups",
      "elasticmapreduce:ListInstances",
      "elasticmapreduce:ListSecurityConfigurations",
      "elasticmapreduce:ListSteps",
      "es:DescribeDomain",
      "es:DescribeDomains",
      "es:DescribeElasticsearchDomain",
      "es:DescribeElasticsearchDomains",
      "es:GetCompatibleElasticsearchVersions",
      "es:GetCompatibleVersions",
      "es:ListDomainNames",
      "es:ListTags",
      "firehose:DescribeDeliveryStream",
      "firehose:ListDeliveryStreams",
      "firehose:ListTagsForDeliveryStream",
      "fsx:DescribeFileSystems",
      "fsx:ListTagsForResource",
      "globalaccelerator:DescribeAccelerator",
      "globalaccelerator:DescribeEndpointGroup",
      "globalaccelerator:DescribeListener",
      "globalaccelerator:ListAccelerators",
      "globalaccelerator:ListEndpointGroups",
      "globalaccelerator:ListListeners",
      "globalaccelerator:ListTagsForResource",
      "glue:BatchGetDevEndpoints",
      "glue:GetDevEndpoint",
      "glue:GetDevEndpoints",
      "glue:GetSecurityConfiguration",
      "glue:GetSecurityConfigurations",
      "glue:GetTags",
      "glue:ListCrawlers",
      "glue:ListDevEndpoints",
      "glue:ListJobs",
      "glue:ListWorkflows",
      "guardduty:GetDetector",
      "guardduty:GetFilter",
      "guardduty:GetFindings",
      "guardduty:GetIPSet",
      "guardduty:GetMasterAccount",
      "guardduty:GetMembers",
      "guardduty:GetThreatIntelSet",
      "guardduty:ListDetectors",
      "guardduty:ListFilters",
      "guardduty:ListFindings",
      "guardduty:ListIPSets",
      "guardduty:ListMembers",
      "guardduty:ListOrganizationAdminAccounts",
      "guardduty:ListTagsForResource",
      "guardduty:ListThreatIntelSets",
      "iam:GenerateCredentialReport",
      "iam:GetAccountAuthorizationDetails",
      "iam:GetAccountPasswordPolicy",
      "iam:GetAccountSummary",
      "iam:GetCredentialReport",
      "iam:GetGroup",
      "iam:GetGroupPolicy",
      "iam:GetPolicy",
      "iam:GetPolicyVersion",
      "iam:GetRole",
      "iam:GetRolePolicy",
      "iam:GetUser",
      "iam:GetUserPolicy",
      "iam:ListAttachedGroupPolicies",
      "iam:ListAttachedRolePolicies",
      "iam:ListAttachedUserPolicies",
      "iam:ListEntitiesForPolicy",
      "iam:ListGroupPolicies",
      "iam:ListGroupsForUser",
      "iam:ListInstanceProfilesForRole",
      "iam:ListPolicyVersions",
      "iam:ListRolePolicies",
      "iam:ListUserPolicies",
      "iam:ListVirtualMFADevices",
      "kafka:DescribeCluster",
      "kafka:ListClusters",
      "kinesis:DescribeStreamConsumer",
      "kinesis:DescribeStreamSummary",
      "kinesis:ListStreamConsumers",
      "kinesis:ListStreams",
      "kinesis:ListTagsForStream",
      "kms:DescribeKey",
      "kms:GetKeyPolicy",
      "kms:GetKeyRotationStatus",
      "kms:ListAliases",
      "kms:ListKeys",
      "kms:ListResourceTags",
      "lambda:GetAlias",
      "lambda:GetFunction",
      "lambda:GetFunctionCodeSigningConfig",
      "lambda:GetPolicy",
      "lambda:ListAliases",
      "lambda:ListFunctions",
      "lambda:ListVersionsByFunction",
      "logs:DescribeLogGroups",
      "logs:ListTagsLogGroup",
      "macie2:GetMacieSession",
      "network-firewall:DescribeLoggingConfiguration",
      "network-firewall:ListFirewalls",
      "opsworks:DescribeLayers",
      "opsworks:ListTags",
      "organizations:DescribeOrganization",
      "organizations:DescribePolicy",
      "organizations:ListParents",
      "organizations:ListPolicies",
      "organizations:ListPoliciesForTarget",
      "ram:GetResourceShareAssociations",
      "ram:GetResourceShares",
      "rds:DescribeDBClusterParameterGroups",
      "rds:DescribeDBClusterParameters",
      "rds:DescribeDBClusters",
      "rds:DescribeDBClusterSnapshotAttributes",
      "rds:DescribeDBClusterSnapshots",
      "rds:DescribeDBEngineVersions",
      "rds:DescribeDBInstances",
      "rds:DescribeDBParameterGroups",
      "rds:DescribeDBParameters",
      "rds:DescribeDBSecurityGroups",
      "rds:DescribeDBSnapshotAttributes",
      "rds:DescribeDBSnapshots",
      "rds:DescribeDBSubnetGroups",
      "rds:DescribeEventSubscriptions",
      "rds:DescribeOptionGroups",
      "rds:ListTagsForResource",
      "redshift:DescribeClusterParameterGroups",
      "redshift:DescribeClusterParameters",
      "redshift:DescribeClusters",
      "redshift:DescribeClusterSecurityGroups",
      "redshift:DescribeClusterSnapshots",
      "redshift:DescribeClusterSubnetGroups",
      "redshift:DescribeEventSubscriptions",
      "redshift:DescribeLoggingStatus",
      "route53:GetHealthCheck",
      "route53:GetHostedZone",
      "route53:ListHealthChecks",
      "route53:ListHostedZones",
      "route53:ListHostedZonesByName",
      "route53:ListQueryLoggingConfigs",
      "route53:ListResourceRecordSets",
      "route53:ListTagsForResource",
      "route53resolver:GetResolverEndpoint",
      "route53resolver:GetResolverRule",
      "route53resolver:GetResolverRuleAssociation",
      "route53resolver:ListResolverEndpointIpAddresses",
      "route53resolver:ListResolverEndpoints",
      "route53resolver:ListResolverRuleAssociations",
      "route53resolver:ListResolverRules",
      "route53resolver:ListTagsForResource",
      "s3:GetAccelerateConfiguration",
      "s3:GetAccessPoint",
      "s3:GetAccessPointPolicy",
      "s3:GetAccessPointPolicyStatus",
      "s3:GetAccountPublicAccessBlock",
      "s3:GetBucketAcl",
      "s3:GetBucketCORS",
      "s3:GetBucketLocation",
      "s3:GetBucketLogging",
      "s3:GetBucketNotification",
      "s3:GetBucketObjectLockConfiguration",
      "s3:GetBucketPolicy",
      "s3:GetBucketPublicAccessBlock",
      "s3:GetBucketRequestPayment",
      "s3:GetBucketTagging",
      "s3:GetBucketVersioning",
      "s3:GetBucketWebsite",
      "s3:GetEncryptionConfiguration",
      "s3:GetLifecycleConfiguration",
      "s3:GetReplicationConfiguration",
      "s3:ListAccessPoints",
      "s3:ListAllMyBuckets",
      "s3:ListBucket",
      "sagemaker:DescribeCodeRepository",
      "sagemaker:DescribeEndpoint",
      "sagemaker:DescribeEndpointConfig",
      "sagemaker:DescribeModel",
      "sagemaker:DescribeMonitoringSchedule",
      "sagemaker:DescribeNotebookInstance",
      "sagemaker:DescribeNotebookInstanceLifecycleConfig",
      "sagemaker:DescribeWorkteam",
      "sagemaker:ListCodeRepositories",
      "sagemaker:ListEndpointConfigs",
      "sagemaker:ListEndpoints",
      "sagemaker:ListModels",
      "sagemaker:ListMonitoringSchedules",
      "sagemaker:ListNotebookInstanceLifecycleConfigs",
      "sagemaker:ListNotebookInstances",
      "sagemaker:ListTags",
      "sagemaker:ListWorkteams",
      "secretsmanager:ListSecrets",
      "secretsmanager:ListSecretVersionIds",
      "securityhub:DescribeHub",
      "ses:GetConfigurationSet",
      "ses:GetConfigurationSetEventDestinations",
      "ses:ListConfigurationSets",
      "shield:DescribeDRTAccess",
      "shield:DescribeProtection",
      "shield:DescribeSubscription",
      "sns:GetSubscriptionAttributes",
      "sns:GetTopicAttributes",
      "sns:ListSubscriptions",
      "sns:ListSubscriptionsByTopic",
      "sns:ListTagsForResource",
      "sns:ListTopics",
      "sqs:GetQueueAttributes",
      "sqs:ListQueues",
      "sqs:ListQueueTags",
      "ssm:DescribeAutomationExecutions",
      "ssm:DescribeDocument",
      "ssm:DescribeDocumentPermission",
      "ssm:GetAutomationExecution",
      "ssm:GetDocument",
      "ssm:ListDocuments",
      "sso:DescribeInstanceAccessControlAttributeConfiguration",
      "sso:DescribePermissionSet",
      "sso:ListManagedPoliciesInPermissionSet",
      "sso:ListPermissionSets",
      "sso:ListTagsForResource",
      "states:DescribeActivity",
      "states:DescribeStateMachine",
      "states:ListActivities",
      "states:ListStateMachines",
      "states:ListTagsForResource",
      "storagegateway:ListGateways",
      "storagegateway:ListTagsForResource",
      "storagegateway:ListVolumes",
      "support:DescribeCases",
      "tag:GetResources",
      "waf-regional:GetLoggingConfiguration",
      "waf-regional:GetWebACL",
      "waf-regional:GetWebACLForResource",
      "waf:GetLoggingConfiguration",
      "waf:GetWebACL",
      "wafv2:GetLoggingConfiguration",
      "wafv2:GetRuleGroup",
      "wafv2:ListRuleGroups",
      "wafv2:ListTagsForResource",
      "workspaces:DescribeConnectionAliases",
      "workspaces:DescribeTags",
      "workspaces:DescribeWorkspaces"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "logs:CreateLogStream",
      "logs:CreateLogGroup"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:logs:*:*:log-group:/aws/config/*"
    },
    {
     "Action":"logs:PutLogEvents",
     "Effect":"Allow",
     "Resource":"arn:aws:logs:*:*:log-group:/aws/config/*:log-stream:config-rule-evaluation/*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-05-31T18:25:11+00:00"
 },
 "AWSConfigUserAccess":{
  "CreateDate":"2015-02-18T19:38:41+00:00",
  "DefaultVersionId":"v4",
  "Document":{
   "Statement":[
    {
     "Action":[
      "config:Get*",
      "config:Describe*",
      "config:Deliver*",
      "config:List*",
      "config:Select*",
      "tag:GetResources",
      "tag:GetTagKeys",
      "cloudtrail:DescribeTrails",
      "cloudtrail:GetTrailStatus",
      "cloudtrail:LookupEvents"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-03-18T20:27:47+00:00"
 },
 "AWSConnector":{
  "CreateDate":"2015-02-11T17:14:31+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":"iam:GetUser",
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "s3:ListAllMyBuckets"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "s3:CreateBucket",
      "s3:DeleteBucket",
      "s3:DeleteObject",
      "s3:GetBucketLocation",
      "s3:GetObject",
      "s3:ListBucket",
      "s3:PutObject",
      "s3:PutObjectAcl",
      "s3:AbortMultipartUpload",
      "s3:ListBucketMultipartUploads",
      "s3:ListMultipartUploadParts"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::import-to-ec2-*"
    },
    {
     "Action":[
      "ec2:CancelConversionTask",
      "ec2:CancelExportTask",
      "ec2:CreateImage",
      "ec2:CreateInstanceExportTask",
      "ec2:CreateTags",
      "ec2:CreateVolume",
      "ec2:DeleteTags",
      "ec2:DeleteVolume",
      "ec2:DescribeConversionTasks",
      "ec2:DescribeExportTasks",
      "ec2:DescribeImages",
      "ec2:DescribeInstanceAttribute",
      "ec2:DescribeInstanceStatus",
      "ec2:DescribeInstances",
      "ec2:DescribeRegions",
      "ec2:DescribeTags",
      "ec2:DetachVolume",
      "ec2:ImportInstance",
      "ec2:ImportVolume",
      "ec2:ModifyInstanceAttribute",
      "ec2:RunInstances",
      "ec2:StartInstances",
      "ec2:StopInstances",
      "ec2:TerminateInstances",
      "ec2:ImportImage",
      "ec2:DescribeImportImageTasks",
      "ec2:DeregisterImage",
      "ec2:DescribeSnapshots",
      "ec2:DeleteSnapshot",
      "ec2:CancelImportTask",
      "ec2:ImportSnapshot",
      "ec2:DescribeImportSnapshotTasks"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "SNS:Publish"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:sns:*:*:metrics-sns-topic-for-*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2015-09-28T19:50:38+00:00"
 },
 "AWSControlTowerServiceRolePolicy":{
  "CreateDate":"2019-05-03T18:19:11+00:00",
  "DefaultVersionId":"v8",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cloudformation:CreateStack",
      "cloudformation:CreateStackInstances",
      "cloudformation:CreateStackSet",
      "cloudformation:DeleteStack",
      "cloudformation:DeleteStackInstances",
      "cloudformation:DeleteStackSet",
      "cloudformation:DescribeStackInstance",
      "cloudformation:DescribeStacks",
      "cloudformation:DescribeStackSet",
      "cloudformation:DescribeStackSetOperation",
      "cloudformation:ListStackInstances",
      "cloudformation:UpdateStack",
      "cloudformation:UpdateStackInstances",
      "cloudformation:UpdateStackSet"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:cloudformation:*:*:type/resource/AWS-IAM-Role"
     ]
    },
    {
     "Action":[
      "cloudformation:CreateStack",
      "cloudformation:CreateStackInstances",
      "cloudformation:CreateStackSet",
      "cloudformation:DeleteStack",
      "cloudformation:DeleteStackInstances",
      "cloudformation:DeleteStackSet",
      "cloudformation:DescribeStackInstance",
      "cloudformation:DescribeStacks",
      "cloudformation:DescribeStackSet",
      "cloudformation:DescribeStackSetOperation",
      "cloudformation:GetTemplate",
      "cloudformation:ListStackInstances",
      "cloudformation:UpdateStack",
      "cloudformation:UpdateStackInstances",
      "cloudformation:UpdateStackSet"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:cloudformation:*:*:stack/AWSControlTower*/*",
      "arn:aws:cloudformation:*:*:stack/StackSet-AWSControlTower*/*",
      "arn:aws:cloudformation:*:*:stackset/AWSControlTower*:*",
      "arn:aws:cloudformation:*:*:stackset-target/AWSControlTower*/*"
     ]
    },
    {
     "Action":[
      "cloudtrail:CreateTrail",
      "cloudtrail:DeleteTrail",
      "cloudtrail:GetTrailStatus",
      "cloudtrail:StartLogging",
      "cloudtrail:StopLogging",
      "cloudtrail:UpdateTrail",
      "cloudtrail:PutEventSelectors",
      "logs:CreateLogStream",
      "logs:PutLogEvents",
      "logs:PutRetentionPolicy"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:logs:*:*:log-group:aws-controltower/CloudTrailLogs:*",
      "arn:aws:cloudtrail:*:*:trail/aws-controltower*"
     ]
    },
    {
     "Action":[
      "s3:GetObject"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::aws-controltower*/*"
     ]
    },
    {
     "Action":[
      "sts:AssumeRole"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/AWSControlTowerExecution"
     ]
    },
    {
     "Action":[
      "cloudtrail:DescribeTrails",
      "ec2:DescribeAvailabilityZones",
      "iam:ListRoles",
      "logs:CreateLogGroup",
      "logs:DescribeLogGroups",
      "organizations:CreateAccount",
      "organizations:DescribeAccount",
      "organizations:DescribeCreateAccountStatus",
      "organizations:DescribeOrganization",
      "organizations:DescribeOrganizationalUnit",
      "organizations:DescribePolicy",
      "organizations:ListAccounts",
      "organizations:ListAccountsForParent",
      "organizations:ListAWSServiceAccessForOrganization",
      "organizations:ListChildren",
      "organizations:ListOrganizationalUnitsForParent",
      "organizations:ListParents",
      "organizations:ListPoliciesForTarget",
      "organizations:ListTargetsForPolicy",
      "organizations:ListRoots",
      "organizations:MoveAccount",
      "servicecatalog:AssociatePrincipalWithPortfolio"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "iam:GetRole",
      "iam:GetUser",
      "iam:ListAttachedRolePolicies",
      "iam:GetRolePolicy"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/service-role/AWSControlTowerStackSetRole",
      "arn:aws:iam::*:role/service-role/AWSControlTowerCloudTrailRole",
      "arn:aws:iam::*:role/service-role/AWSControlTowerConfigAggregatorRoleForOrganizations"
     ]
    },
    {
     "Action":[
      "config:DeleteConfigurationAggregator",
      "config:PutConfigurationAggregator",
      "config:TagResource"
     ],
     "Condition":{
      "StringEquals":{
       "aws:ResourceTag/aws-control-tower":"managed-by-control-tower"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "organizations:EnableAWSServiceAccess",
      "organizations:DisableAWSServiceAccess"
     ],
     "Condition":{
      "StringLike":{
       "organizations:ServicePrincipal":[
        "config.amazonaws.com",
        "cloudtrail.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":"cloudtrail.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-06-20T21:45:54+00:00"
 },
 "AWSCostAndUsageReportAutomationPolicy":{
  "CreateDate":"2021-11-01T21:27:29+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "organizations:DescribeOrganization"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "s3:GetBucketTagging",
      "s3:PutBucketTagging",
      "s3:GetBucketPolicy",
      "s3:PutBucketPolicy",
      "s3:ListBucket",
      "s3:CreateBucket"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::aws-map-cur-bucket-*"
    },
    {
     "Action":[
      "cur:PutReportDefinition",
      "cur:DeleteReportDefinition",
      "cur:DescribeReportDefinitions"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:cur:*:*:definition/map-migrated-report"
    },
    {
     "Action":"cur:DescribeReportDefinitions",
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-11-01T21:27:29+00:00"
 },
 "AWSDataExchangeFullAccess":{
  "CreateDate":"2019-11-13T19:27:59+00:00",
  "DefaultVersionId":"v6",
  "Document":{
   "Statement":[
    {
     "Action":[
      "dataexchange:*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"s3:GetObject",
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:CalledVia":[
        "dataexchange.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::*aws-data-exchange*"
    },
    {
     "Action":"s3:GetObject",
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:CalledVia":[
        "dataexchange.amazonaws.com"
       ]
      },
      "StringEqualsIgnoreCase":{
       "s3:ExistingObjectTag/AWSDataExchange":"true"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "s3:PutObject",
      "s3:PutObjectAcl"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:CalledVia":[
        "dataexchange.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::*aws-data-exchange*"
    },
    {
     "Action":[
      "s3:GetBucketLocation",
      "s3:ListBucket",
      "s3:ListAllMyBuckets"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "aws-marketplace:DescribeEntity",
      "aws-marketplace:ListEntities",
      "aws-marketplace:StartChangeSet",
      "aws-marketplace:ListChangeSets",
      "aws-marketplace:DescribeChangeSet",
      "aws-marketplace:CancelChangeSet",
      "aws-marketplace:GetAgreementApprovalRequest",
      "aws-marketplace:ListAgreementApprovalRequests",
      "aws-marketplace:AcceptAgreementApprovalRequest",
      "aws-marketplace:RejectAgreementApprovalRequest",
      "aws-marketplace:UpdateAgreementApprovalRequest",
      "aws-marketplace:SearchAgreements",
      "aws-marketplace:GetAgreementTerms"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "aws-marketplace:Subscribe",
      "aws-marketplace:Unsubscribe",
      "aws-marketplace:ViewSubscriptions",
      "aws-marketplace:GetAgreementRequest",
      "aws-marketplace:ListAgreementRequests",
      "aws-marketplace:CancelAgreementRequest"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "kms:DescribeKey",
      "kms:ListAliases",
      "kms:ListKeys"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "redshift:AuthorizeDataShare"
     ],
     "Condition":{
      "StringEqualsIgnoreCase":{
       "redshift:ConsumerIdentifier":"ADX"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "redshift:DescribeDataSharesForProducer",
      "redshift:DescribeDataShares"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "apigateway:GET"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-12-02T16:14:27+00:00"
 },
 "AWSDataExchangeProviderFullAccess":{
  "CreateDate":"2019-11-13T19:27:55+00:00",
  "DefaultVersionId":"v11",
  "Document":{
   "Statement":[
    {
     "Action":[
      "dataexchange:CreateDataSet",
      "dataexchange:CreateRevision",
      "dataexchange:CreateAsset",
      "dataexchange:Get*",
      "dataexchange:Update*",
      "dataexchange:List*",
      "dataexchange:Delete*",
      "dataexchange:TagResource",
      "dataexchange:UntagResource",
      "dataexchange:PublishDataSet",
      "dataexchange:SendApiAsset",
      "dataexchange:RevokeRevision",
      "tag:GetTagKeys",
      "tag:GetTagValues"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "dataexchange:CreateJob",
      "dataexchange:StartJob",
      "dataexchange:CancelJob"
     ],
     "Condition":{
      "StringEquals":{
       "dataexchange:JobType":[
        "IMPORT_ASSETS_FROM_S3",
        "IMPORT_ASSET_FROM_SIGNED_URL",
        "EXPORT_ASSETS_TO_S3",
        "EXPORT_ASSET_TO_SIGNED_URL",
        "IMPORT_ASSET_FROM_API_GATEWAY_API",
        "IMPORT_ASSETS_FROM_REDSHIFT_DATA_SHARES"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"s3:GetObject",
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:CalledVia":[
        "dataexchange.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::*aws-data-exchange*"
    },
    {
     "Action":"s3:GetObject",
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:CalledVia":[
        "dataexchange.amazonaws.com"
       ]
      },
      "StringEqualsIgnoreCase":{
       "s3:ExistingObjectTag/AWSDataExchange":"true"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "s3:PutObject",
      "s3:PutObjectAcl"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:CalledVia":[
        "dataexchange.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::*aws-data-exchange*"
    },
    {
     "Action":[
      "s3:GetBucketLocation",
      "s3:ListBucket",
      "s3:ListAllMyBuckets"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "aws-marketplace:DescribeEntity",
      "aws-marketplace:ListEntities",
      "aws-marketplace:DescribeChangeSet",
      "aws-marketplace:ListChangeSets",
      "aws-marketplace:StartChangeSet",
      "aws-marketplace:CancelChangeSet",
      "aws-marketplace:GetAgreementApprovalRequest",
      "aws-marketplace:ListAgreementApprovalRequests",
      "aws-marketplace:AcceptAgreementApprovalRequest",
      "aws-marketplace:RejectAgreementApprovalRequest",
      "aws-marketplace:UpdateAgreementApprovalRequest",
      "aws-marketplace:SearchAgreements",
      "aws-marketplace:GetAgreementTerms"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "kms:DescribeKey",
      "kms:ListAliases",
      "kms:ListKeys"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "redshift:AuthorizeDataShare"
     ],
     "Condition":{
      "StringEqualsIgnoreCase":{
       "redshift:ConsumerIdentifier":"ADX"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "redshift:DescribeDataSharesForProducer",
      "redshift:DescribeDataShares"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "apigateway:GET"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-03-15T16:16:20+00:00"
 },
 "AWSDataExchangeReadOnly":{
  "CreateDate":"2019-11-13T19:27:37+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "dataexchange:Get*",
      "dataexchange:List*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "aws-marketplace:ViewSubscriptions",
      "aws-marketplace:GetAgreementRequest",
      "aws-marketplace:ListAgreementRequests",
      "aws-marketplace:GetAgreementApprovalRequest",
      "aws-marketplace:ListAgreementApprovalRequests",
      "aws-marketplace:DescribeEntity",
      "aws-marketplace:ListEntities",
      "aws-marketplace:DescribeChangeSet",
      "aws-marketplace:ListChangeSets",
      "aws-marketplace:SearchAgreements",
      "aws-marketplace:GetAgreementTerms"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-05-10T21:15:26+00:00"
 },
 "AWSDataExchangeSubscriberFullAccess":{
  "CreateDate":"2019-11-13T19:27:52+00:00",
  "DefaultVersionId":"v6",
  "Document":{
   "Statement":[
    {
     "Action":[
      "dataexchange:Get*",
      "dataexchange:List*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "dataexchange:CreateJob",
      "dataexchange:StartJob",
      "dataexchange:CancelJob"
     ],
     "Condition":{
      "StringEquals":{
       "dataexchange:JobType":[
        "EXPORT_ASSETS_TO_S3",
        "EXPORT_ASSET_TO_SIGNED_URL",
        "EXPORT_REVISIONS_TO_S3"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "dataexchange:CreateEventAction",
      "dataexchange:UpdateEventAction",
      "dataexchange:DeleteEventAction",
      "dataexchange:SendApiAsset"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"s3:GetObject",
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:CalledVia":[
        "dataexchange.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::*aws-data-exchange*"
    },
    {
     "Action":[
      "s3:GetBucketLocation",
      "s3:ListBucket",
      "s3:ListAllMyBuckets"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "aws-marketplace:Subscribe",
      "aws-marketplace:Unsubscribe",
      "aws-marketplace:ViewSubscriptions",
      "aws-marketplace:GetAgreementRequest",
      "aws-marketplace:ListAgreementRequests",
      "aws-marketplace:CancelAgreementRequest"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "kms:DescribeKey",
      "kms:ListAliases",
      "kms:ListKeys"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-11-29T23:00:06+00:00"
 },
 "AWSDataLifecycleManagerServiceRole":{
  "CreateDate":"2018-07-06T19:34:16+00:00",
  "DefaultVersionId":"v6",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:CreateSnapshot",
      "ec2:CreateSnapshots",
      "ec2:DeleteSnapshot",
      "ec2:DescribeInstances",
      "ec2:DescribeVolumes",
      "ec2:DescribeSnapshots",
      "ec2:EnableFastSnapshotRestores",
      "ec2:DescribeFastSnapshotRestores",
      "ec2:DisableFastSnapshotRestores",
      "ec2:CopySnapshot",
      "ec2:ModifySnapshotAttribute",
      "ec2:DescribeSnapshotAttribute"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:CreateTags"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*::snapshot/*"
    },
    {
     "Action":[
      "events:PutRule",
      "events:DeleteRule",
      "events:DescribeRule",
      "events:EnableRule",
      "events:DisableRule",
      "events:ListTargetsByRule",
      "events:PutTargets",
      "events:RemoveTargets"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:events:*:*:rule/AwsDataLifecycleRule.managed-cwe.*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-12-11T18:15:06+00:00"
 },
 "AWSDataLifecycleManagerServiceRoleForAMIManagement":{
  "CreateDate":"2020-10-21T19:39:41+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":"ec2:CreateTags",
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*::snapshot/*",
      "arn:aws:ec2:*::image/*"
     ]
    },
    {
     "Action":[
      "ec2:DescribeImages",
      "ec2:DescribeInstances",
      "ec2:DescribeImageAttribute",
      "ec2:DescribeVolumes",
      "ec2:DescribeSnapshots"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"ec2:DeleteSnapshot",
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*::snapshot/*"
    },
    {
     "Action":[
      "ec2:ResetImageAttribute",
      "ec2:DeregisterImage",
      "ec2:CreateImage",
      "ec2:CopyImage",
      "ec2:ModifyImageAttribute"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:EnableImageDeprecation",
      "ec2:DisableImageDeprecation"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*::image/*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-08-19T17:03:44+00:00"
 },
 "AWSDataPipelineRole":{
  "CreateDate":"2015-02-06T18:41:24+00:00",
  "DefaultVersionId":"v6",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cloudwatch:*",
      "datapipeline:DescribeObjects",
      "datapipeline:EvaluateExpression",
      "dynamodb:BatchGetItem",
      "dynamodb:DescribeTable",
      "dynamodb:GetItem",
      "dynamodb:Query",
      "dynamodb:Scan",
      "dynamodb:UpdateTable",
      "ec2:AuthorizeSecurityGroupIngress",
      "ec2:CancelSpotInstanceRequests",
      "ec2:CreateSecurityGroup",
      "ec2:CreateTags",
      "ec2:DeleteTags",
      "ec2:Describe*",
      "ec2:ModifyImageAttribute",
      "ec2:ModifyInstanceAttribute",
      "ec2:RequestSpotInstances",
      "ec2:RunInstances",
      "ec2:StartInstances",
      "ec2:StopInstances",
      "ec2:TerminateInstances",
      "ec2:AuthorizeSecurityGroupEgress",
      "ec2:DeleteSecurityGroup",
      "ec2:RevokeSecurityGroupEgress",
      "ec2:DescribeNetworkInterfaces",
      "ec2:CreateNetworkInterface",
      "ec2:DeleteNetworkInterface",
      "ec2:DetachNetworkInterface",
      "elasticmapreduce:*",
      "iam:GetInstanceProfile",
      "iam:GetRole",
      "iam:GetRolePolicy",
      "iam:ListAttachedRolePolicies",
      "iam:ListRolePolicies",
      "iam:ListInstanceProfiles",
      "iam:PassRole",
      "rds:DescribeDBInstances",
      "rds:DescribeDBSecurityGroups",
      "redshift:DescribeClusters",
      "redshift:DescribeClusterSecurityGroups",
      "s3:CreateBucket",
      "s3:DeleteObject",
      "s3:Get*",
      "s3:List*",
      "s3:Put*",
      "sdb:BatchPutAttributes",
      "sdb:Select*",
      "sns:GetTopicAttributes",
      "sns:ListTopics",
      "sns:Publish",
      "sns:Subscribe",
      "sns:Unsubscribe",
      "sqs:CreateQueue",
      "sqs:Delete*",
      "sqs:GetQueue*",
      "sqs:PurgeQueue",
      "sqs:ReceiveMessage"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringLike":{
       "iam:AWSServiceName":[
        "elasticmapreduce.amazonaws.com",
        "spot.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2017-12-22T23:43:28+00:00"
 },
 "AWSDataPipeline_FullAccess":{
  "CreateDate":"2017-01-19T23:14:54+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "s3:List*",
      "dynamodb:DescribeTable",
      "rds:DescribeDBInstances",
      "rds:DescribeDBSecurityGroups",
      "redshift:DescribeClusters",
      "redshift:DescribeClusterSecurityGroups",
      "sns:ListTopics",
      "sns:Subscribe",
      "iam:ListRoles",
      "iam:GetRolePolicy",
      "iam:GetInstanceProfile",
      "iam:ListInstanceProfiles",
      "datapipeline:*"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":"iam:PassRole",
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/DataPipelineDefaultResourceRole",
      "arn:aws:iam::*:role/DataPipelineDefaultRole"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2017-08-17T18:48:39+00:00"
 },
 "AWSDataPipeline_PowerUser":{
  "CreateDate":"2017-01-19T23:16:46+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "s3:List*",
      "dynamodb:DescribeTable",
      "rds:DescribeDBInstances",
      "rds:DescribeDBSecurityGroups",
      "redshift:DescribeClusters",
      "redshift:DescribeClusterSecurityGroups",
      "sns:ListTopics",
      "iam:ListRoles",
      "iam:GetRolePolicy",
      "iam:GetInstanceProfile",
      "iam:ListInstanceProfiles",
      "datapipeline:*"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":"iam:PassRole",
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/DataPipelineDefaultResourceRole",
      "arn:aws:iam::*:role/DataPipelineDefaultRole"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2017-08-17T18:49:42+00:00"
 },
 "AWSDataSyncFullAccess":{
  "CreateDate":"2019-01-18T19:40:36+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "datasync:*",
      "ec2:CreateNetworkInterface",
      "ec2:CreateNetworkInterfacePermission",
      "ec2:DeleteNetworkInterface",
      "ec2:DescribeNetworkInterfaces",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeSubnets",
      "ec2:ModifyNetworkInterfaceAttribute",
      "fsx:DescribeFileSystems",
      "elasticfilesystem:DescribeFileSystems",
      "elasticfilesystem:DescribeMountTargets",
      "iam:GetRole",
      "iam:ListRoles",
      "logs:CreateLogGroup",
      "logs:DescribeLogGroups",
      "logs:DescribeResourcePolicies",
      "s3:ListAllMyBuckets",
      "s3:ListBucket"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":[
        "datasync.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-06-30T17:58:58+00:00"
 },
 "AWSDataSyncReadOnlyAccess":{
  "CreateDate":"2019-01-18T19:18:44+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "datasync:Describe*",
      "datasync:List*",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeSubnets",
      "elasticfilesystem:DescribeFileSystems",
      "elasticfilesystem:DescribeMountTargets",
      "fsx:DescribeFileSystems",
      "iam:GetRole",
      "iam:ListRoles",
      "logs:DescribeLogGroups",
      "logs:DescribeResourcePolicies",
      "s3:ListAllMyBuckets",
      "s3:ListBucket"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-06-30T17:59:22+00:00"
 },
 "AWSDeepLensLambdaFunctionAccessPolicy":{
  "CreateDate":"2017-11-29T15:47:18+00:00",
  "DefaultVersionId":"v4",
  "Document":{
   "Statement":[
    {
     "Action":[
      "s3:ListBucket",
      "s3:GetObject"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::deeplens*/*",
      "arn:aws:s3:::deeplens*"
     ],
     "Sid":"DeepLensS3ObjectAccess"
    },
    {
     "Action":[
      "logs:CreateLogStream",
      "logs:DescribeLogStreams",
      "logs:PutLogEvents",
      "logs:CreateLogGroup"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:logs:*:*:log-group:/aws/greengrass/*",
     "Sid":"DeepLensGreenGrassCloudWatchAccess"
    },
    {
     "Action":[
      "deeplens:*"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"DeepLensAccess"
    },
    {
     "Action":[
      "kinesisvideo:DescribeStream",
      "kinesisvideo:CreateStream",
      "kinesisvideo:GetDataEndpoint",
      "kinesisvideo:PutMedia"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"DeepLensKinesisVideoAccess"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-06-11T23:11:55+00:00"
 },
 "AWSDeepLensServiceRolePolicy":{
  "CreateDate":"2017-11-29T15:46:36+00:00",
  "DefaultVersionId":"v6",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iot:CreateThing",
      "iot:DeleteThing",
      "iot:DeleteThingShadow",
      "iot:DescribeThing",
      "iot:GetThingShadow",
      "iot:UpdateThing",
      "iot:UpdateThingShadow"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iot:*:*:thing/deeplens*"
     ],
     "Sid":"DeepLensIoTThingAccess"
    },
    {
     "Action":[
      "iot:AttachThingPrincipal",
      "iot:DetachThingPrincipal",
      "iot:UpdateCertificate",
      "iot:DeleteCertificate",
      "iot:DetachPrincipalPolicy"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iot:*:*:thing/deeplens*",
      "arn:aws:iot:*:*:cert/*"
     ],
     "Sid":"DeepLensIoTCertificateAccess"
    },
    {
     "Action":[
      "iot:CreateKeysAndCertificate",
      "iot:CreatePolicy",
      "iot:CreatePolicyVersion"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"DeepLensIoTCreateCertificateAndPolicyAccess"
    },
    {
     "Action":[
      "iot:AttachPrincipalPolicy"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iot:*:*:policy/deeplens*",
      "arn:aws:iot:*:*:cert/*"
     ],
     "Sid":"DeepLensIoTAttachCertificatePolicyAccess"
    },
    {
     "Action":[
      "iot:GetThingShadow",
      "iot:UpdateThingShadow"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iot:*:*:thing/deeplens*"
     ],
     "Sid":"DeepLensIoTDataAccess"
    },
    {
     "Action":[
      "iot:DescribeEndpoint"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"DeepLensIoTEndpointAccess"
    },
    {
     "Action":[
      "deeplens:*"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"DeepLensAccess"
    },
    {
     "Action":[
      "s3:GetObject"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::deeplens*"
     ],
     "Sid":"DeepLensS3ObjectAccess"
    },
    {
     "Action":[
      "s3:DeleteBucket",
      "s3:ListBucket"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::deeplens*"
     ],
     "Sid":"DeepLensS3Buckets"
    },
    {
     "Action":[
      "s3:CreateBucket"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"DeepLensCreateS3Buckets"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":[
        "greengrass.amazonaws.com",
        "sagemaker.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"DeepLensIAMPassRoleAccess"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringEqualsIfExists":{
       "iam:PassedToService":"lambda.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/AWSDeepLens*",
      "arn:aws:iam::*:role/service-role/AWSDeepLens*"
     ],
     "Sid":"DeepLensIAMLambdaPassRoleAccess"
    },
    {
     "Action":[
      "greengrass:AssociateRoleToGroup",
      "greengrass:AssociateServiceRoleToAccount",
      "greengrass:CreateResourceDefinition",
      "greengrass:CreateResourceDefinitionVersion",
      "greengrass:CreateCoreDefinition",
      "greengrass:CreateCoreDefinitionVersion",
      "greengrass:CreateDeployment",
      "greengrass:CreateFunctionDefinition",
      "greengrass:CreateFunctionDefinitionVersion",
      "greengrass:CreateGroup",
      "greengrass:CreateGroupCertificateAuthority",
      "greengrass:CreateGroupVersion",
      "greengrass:CreateLoggerDefinition",
      "greengrass:CreateLoggerDefinitionVersion",
      "greengrass:CreateSubscriptionDefinition",
      "greengrass:CreateSubscriptionDefinitionVersion",
      "greengrass:DeleteCoreDefinition",
      "greengrass:DeleteFunctionDefinition",
      "greengrass:DeleteGroup",
      "greengrass:DeleteLoggerDefinition",
      "greengrass:DeleteSubscriptionDefinition",
      "greengrass:DisassociateRoleFromGroup",
      "greengrass:DisassociateServiceRoleFromAccount",
      "greengrass:GetAssociatedRole",
      "greengrass:GetConnectivityInfo",
      "greengrass:GetCoreDefinition",
      "greengrass:GetCoreDefinitionVersion",
      "greengrass:GetDeploymentStatus",
      "greengrass:GetDeviceDefinition",
      "greengrass:GetDeviceDefinitionVersion",
      "greengrass:GetFunctionDefinition",
      "greengrass:GetFunctionDefinitionVersion",
      "greengrass:GetGroup",
      "greengrass:GetGroupCertificateAuthority",
      "greengrass:GetGroupCertificateConfiguration",
      "greengrass:GetGroupVersion",
      "greengrass:GetLoggerDefinition",
      "greengrass:GetLoggerDefinitionVersion",
      "greengrass:GetResourceDefinition",
      "greengrass:GetServiceRoleForAccount",
      "greengrass:GetSubscriptionDefinition",
      "greengrass:GetSubscriptionDefinitionVersion",
      "greengrass:ListCoreDefinitionVersions",
      "greengrass:ListCoreDefinitions",
      "greengrass:ListDeployments",
      "greengrass:ListDeviceDefinitionVersions",
      "greengrass:ListDeviceDefinitions",
      "greengrass:ListFunctionDefinitionVersions",
      "greengrass:ListFunctionDefinitions",
      "greengrass:ListGroupCertificateAuthorities",
      "greengrass:ListGroupVersions",
      "greengrass:ListGroups",
      "greengrass:ListLoggerDefinitionVersions",
      "greengrass:ListLoggerDefinitions",
      "greengrass:ListSubscriptionDefinitionVersions",
      "greengrass:ListSubscriptionDefinitions",
      "greengrass:ResetDeployments",
      "greengrass:UpdateConnectivityInfo",
      "greengrass:UpdateCoreDefinition",
      "greengrass:UpdateDeviceDefinition",
      "greengrass:UpdateFunctionDefinition",
      "greengrass:UpdateGroup",
      "greengrass:UpdateGroupCertificateConfiguration",
      "greengrass:UpdateLoggerDefinition",
      "greengrass:UpdateSubscriptionDefinition",
      "greengrass:UpdateResourceDefinition"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"DeepLensGreenGrassAccess"
    },
    {
     "Action":[
      "lambda:CreateFunction",
      "lambda:DeleteFunction",
      "lambda:GetFunction",
      "lambda:GetFunctionConfiguration",
      "lambda:ListFunctions",
      "lambda:ListVersionsByFunction",
      "lambda:PublishVersion",
      "lambda:UpdateFunctionCode",
      "lambda:UpdateFunctionConfiguration"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:lambda:*:*:function:deeplens*"
     ],
     "Sid":"DeepLensLambdaAdminFunctionAccess"
    },
    {
     "Action":[
      "lambda:GetFunction",
      "lambda:GetFunctionConfiguration",
      "lambda:ListFunctions",
      "lambda:ListVersionsByFunction"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:lambda:*:*:function:*"
     ],
     "Sid":"DeepLensLambdaUsersFunctionAccess"
    },
    {
     "Action":[
      "sagemaker:CreateTrainingJob",
      "sagemaker:DescribeTrainingJob",
      "sagemaker:StopTrainingJob"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:sagemaker:*:*:training-job/deeplens*"
     ],
     "Sid":"DeepLensSageMakerWriteAccess"
    },
    {
     "Action":[
      "sagemaker:DescribeTrainingJob"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:sagemaker:*:*:training-job/*"
     ],
     "Sid":"DeepLensSageMakerReadAccess"
    },
    {
     "Action":[
      "kinesisvideo:CreateStream",
      "kinesisvideo:DescribeStream",
      "kinesisvideo:DeleteStream"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:kinesisvideo:*:*:stream/deeplens*/*"
     ],
     "Sid":"DeepLensKinesisVideoStreamAccess"
    },
    {
     "Action":[
      "kinesisvideo:GetDataEndpoint"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"DeepLensKinesisVideoEndpointAccess"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-09-25T19:25:06+00:00"
 },
 "AWSDeepRacerAccountAdminAccess":{
  "CreateDate":"2021-10-28T01:27:13+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "deepracer:*"
     ],
     "Condition":{
      "Null":{
       "deepracer:UserToken":"true"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"DeepRacerAdminAccessStatement"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-10-28T01:27:13+00:00"
 },
 "AWSDeepRacerCloudFormationAccessPolicy":{
  "CreateDate":"2019-02-28T21:59:49+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cloudformation:*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:AllocateAddress",
      "ec2:AttachInternetGateway",
      "ec2:AssociateRouteTable",
      "ec2:AuthorizeSecurityGroupEgress",
      "ec2:AuthorizeSecurityGroupIngress",
      "ec2:CreateInternetGateway",
      "ec2:CreateNatGateway",
      "ec2:CreateNetworkAcl",
      "ec2:CreateNetworkAclEntry",
      "ec2:CreateRoute",
      "ec2:CreateRouteTable",
      "ec2:CreateSecurityGroup",
      "ec2:CreateSubnet",
      "ec2:CreateTags",
      "ec2:CreateVpc",
      "ec2:CreateVpcEndpoint",
      "ec2:DeleteInternetGateway",
      "ec2:DeleteNatGateway",
      "ec2:DeleteNetworkAcl",
      "ec2:DeleteNetworkAclEntry",
      "ec2:DeleteRoute",
      "ec2:DeleteRouteTable",
      "ec2:DeleteSecurityGroup",
      "ec2:DeleteSubnet",
      "ec2:DeleteTags",
      "ec2:DeleteVpc",
      "ec2:DeleteVpcEndpoints",
      "ec2:DescribeAddresses",
      "ec2:DescribeInternetGateways",
      "ec2:DescribeNatGateways",
      "ec2:DescribeNetworkAcls",
      "ec2:DescribeRouteTables",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeSubnets",
      "ec2:DescribeTags",
      "ec2:DescribeVpcEndpoints",
      "ec2:DescribeVpcs",
      "ec2:DetachInternetGateway",
      "ec2:DisassociateRouteTable",
      "ec2:ModifySubnetAttribute",
      "ec2:ModifyVpcAttribute",
      "ec2:ReleaseAddress",
      "ec2:ReplaceNetworkAclAssociation",
      "ec2:RevokeSecurityGroupEgress",
      "ec2:RevokeSecurityGroupIngress"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringLikeIfExists":{
       "iam:PassedToService":"lambda.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/service-role/AWSDeepRacerLambdaAccessRole"
    },
    {
     "Action":[
      "lambda:CreateFunction",
      "lambda:GetFunction",
      "lambda:DeleteFunction",
      "lambda:TagResource",
      "lambda:UpdateFunctionCode"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:lambda:*:*:function:*DeepRacer*",
      "arn:aws:lambda:*:*:function:*Deepracer*",
      "arn:aws:lambda:*:*:function:*deepracer*"
     ]
    },
    {
     "Action":[
      "s3:PutBucketPolicy",
      "s3:CreateBucket",
      "s3:ListBucket",
      "s3:GetBucketAcl",
      "s3:DeleteBucket"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::*DeepRacer*",
      "arn:aws:s3:::*Deepracer*",
      "arn:aws:s3:::*deepracer*"
     ]
    },
    {
     "Action":[
      "robomaker:CreateSimulationApplication",
      "robomaker:CreateSimulationApplicationVersion",
      "robomaker:DeleteSimulationApplication",
      "robomaker:DescribeSimulationApplication",
      "robomaker:ListSimulationApplications",
      "robomaker:TagResource",
      "robomaker:UpdateSimulationApplication"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:robomaker:*:*:/createSimulationApplication",
      "arn:aws:robomaker:*:*:simulation-application/deepracer*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-06-14T17:02:04+00:00"
 },
 "AWSDeepRacerDefaultMultiUserAccess":{
  "CreateDate":"2021-10-28T01:27:13+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "deepracer:Add*",
      "deepracer:Remove*",
      "deepracer:Create*",
      "deepracer:Perform*",
      "deepracer:Clone*",
      "deepracer:Get*",
      "deepracer:List*",
      "deepracer:Edit*",
      "deepracer:Start*",
      "deepracer:Set*",
      "deepracer:Update*",
      "deepracer:Delete*",
      "deepracer:Stop*",
      "deepracer:Import*",
      "deepracer:Tag*",
      "deepracer:Untag*"
     ],
     "Condition":{
      "Bool":{
       "deepracer:MultiUser":"true"
      },
      "Null":{
       "deepracer:UserToken":"false"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "deepracer:GetAccountConfig",
      "deepracer:GetTrack",
      "deepracer:ListTracks",
      "deepracer:TestRewardFunction"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "deepracer:Admin*"
     ],
     "Effect":"Deny",
     "Resource":[
      "*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-10-28T01:27:13+00:00"
 },
 "AWSDeepRacerFullAccess":{
  "CreateDate":"2020-10-05T22:03:10+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "s3:ListAllMyBuckets"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "s3:DeleteObject",
      "s3:DeleteObjectVersion",
      "s3:GetBucketPolicy",
      "s3:PutBucketPolicy",
      "s3:ListBucket",
      "s3:GetBucketAcl",
      "s3:GetObject",
      "s3:GetObjectVersion",
      "s3:GetObjectAcl",
      "s3:GetBucketLocation"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::*DeepRacer*",
      "arn:aws:s3:::*Deepracer*",
      "arn:aws:s3:::*deepracer*",
      "arn:aws:s3:::dr-*",
      "arn:aws:s3:::*DeepRacer*/*",
      "arn:aws:s3:::*Deepracer*/*",
      "arn:aws:s3:::*deepracer*/*",
      "arn:aws:s3:::dr-*/*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-10-05T22:03:10+00:00"
 },
 "AWSDeepRacerRoboMakerAccessPolicy":{
  "CreateDate":"2019-02-28T21:59:58+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "robomaker:*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "cloudwatch:PutMetricData",
      "ec2:CreateNetworkInterfacePermission",
      "ec2:DeleteNetworkInterface",
      "ec2:DescribeNetworkInterfaces",
      "ec2:DescribeSubnets",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeVpcs"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "logs:CreateLogGroup",
      "logs:CreateLogStream",
      "logs:DescribeLogStreams",
      "logs:PutLogEvents"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:logs:*:*:log-group:/aws/robomaker/SimulationJobs",
      "arn:aws:logs:*:*:log-group:/aws/robomaker/SimulationJobs:log-stream:*"
     ]
    },
    {
     "Action":[
      "s3:GetObject",
      "s3:GetBucketLocation",
      "s3:ListBucket",
      "s3:ListAllMyBuckets",
      "s3:PutObject"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::*DeepRacer*",
      "arn:aws:s3:::*Deepracer*",
      "arn:aws:s3:::*deepracer*",
      "arn:aws:s3:::dr-*"
     ]
    },
    {
     "Action":[
      "s3:GetObject"
     ],
     "Condition":{
      "StringEqualsIgnoreCase":{
       "s3:ExistingObjectTag/DeepRacer":"true"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "kinesisvideo:CreateStream",
      "kinesisvideo:DescribeStream",
      "kinesisvideo:GetDataEndpoint",
      "kinesisvideo:PutMedia",
      "kinesisvideo:TagStream"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:kinesisvideo:*:*:stream/dr-*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-02-28T21:59:58+00:00"
 },
 "AWSDeepRacerServiceRolePolicy":{
  "CreateDate":"2019-02-28T21:58:09+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "deepracer:*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "robomaker:*",
      "sagemaker:*",
      "s3:ListAllMyBuckets"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "cloudformation:ListStackResources",
      "cloudformation:DescribeStacks",
      "cloudformation:CreateStack",
      "cloudformation:DeleteStack",
      "cloudformation:DescribeStackResource",
      "cloudformation:DescribeStackResources",
      "cloudformation:DescribeStackEvents",
      "cloudformation:DetectStackDrift",
      "cloudformation:DescribeStackDriftDetectionStatus",
      "cloudformation:DescribeStackResourceDrifts"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":"robomaker.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/AWSDeepRacer*",
      "arn:aws:iam::*:role/service-role/AWSDeepRacer*"
     ]
    },
    {
     "Action":[
      "cloudwatch:GetMetricData",
      "logs:CreateLogGroup",
      "logs:CreateLogStream",
      "logs:DescribeLogStreams",
      "logs:GetLogEvents",
      "logs:PutLogEvents"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "lambda:CreateFunction",
      "lambda:DeleteFunction",
      "lambda:GetFunction",
      "lambda:InvokeFunction",
      "lambda:UpdateFunctionCode"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:lambda:*:*:function:*DeepRacer*",
      "arn:aws:lambda:*:*:function:*Deepracer*",
      "arn:aws:lambda:*:*:function:*deepracer*",
      "arn:aws:lambda:*:*:function:*dr-*"
     ]
    },
    {
     "Action":[
      "s3:GetObject",
      "s3:GetBucketLocation",
      "s3:DeleteObject",
      "s3:ListBucket",
      "s3:PutObject",
      "s3:PutBucketPolicy",
      "s3:GetBucketAcl"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::*DeepRacer*",
      "arn:aws:s3:::*Deepracer*",
      "arn:aws:s3:::*deepracer*",
      "arn:aws:s3:::dr-*"
     ]
    },
    {
     "Action":[
      "s3:GetObject"
     ],
     "Condition":{
      "StringEqualsIgnoreCase":{
       "s3:ExistingObjectTag/DeepRacer":"true"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "kinesisvideo:CreateStream",
      "kinesisvideo:DeleteStream",
      "kinesisvideo:DescribeStream",
      "kinesisvideo:GetDataEndpoint",
      "kinesisvideo:GetHLSStreamingSessionURL",
      "kinesisvideo:GetMedia",
      "kinesisvideo:PutMedia",
      "kinesisvideo:TagStream"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:kinesisvideo:*:*:stream/dr-*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-06-12T20:55:34+00:00"
 },
 "AWSDenyAll":{
  "CreateDate":"2019-05-01T22:36:14+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "*"
     ],
     "Effect":"Deny",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-05-01T22:36:14+00:00"
 },
 "AWSDeviceFarmFullAccess":{
  "CreateDate":"2015-07-13T16:37:38+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "devicefarm:*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2015-07-13T16:37:38+00:00"
 },
 "AWSDeviceFarmTestGridServiceRolePolicy":{
  "CreateDate":"2021-05-26T22:01:35+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:DescribeNetworkInterfaces",
      "ec2:DescribeVpcs",
      "ec2:DescribeSubnets",
      "ec2:DescribeSecurityGroups"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:CreateNetworkInterface"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:subnet/*",
      "arn:aws:ec2:*:*:security-group/*"
     ]
    },
    {
     "Action":[
      "ec2:CreateNetworkInterface"
     ],
     "Condition":{
      "StringEquals":{
       "aws:RequestTag/AWSDeviceFarmManaged":"true"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:network-interface/*"
     ]
    },
    {
     "Action":[
      "ec2:CreateTags"
     ],
     "Condition":{
      "StringEquals":{
       "ec2:CreateAction":"CreateNetworkInterface"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:network-interface/*"
    },
    {
     "Action":[
      "ec2:CreateNetworkInterfacePermission",
      "ec2:DeleteNetworkInterface"
     ],
     "Condition":{
      "StringEquals":{
       "aws:ResourceTag/AWSDeviceFarmManaged":"true"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:network-interface/*"
    },
    {
     "Action":[
      "ec2:ModifyNetworkInterfaceAttribute"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:security-group/*",
      "arn:aws:ec2:*:*:instance/*"
     ]
    },
    {
     "Action":[
      "ec2:ModifyNetworkInterfaceAttribute"
     ],
     "Condition":{
      "StringEquals":{
       "aws:ResourceTag/AWSDeviceFarmManaged":"true"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:network-interface/*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-05-26T22:01:35+00:00"
 },
 "AWSDirectConnectFullAccess":{
  "CreateDate":"2015-02-06T18:40:07+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "directconnect:*",
      "ec2:DescribeVpnGateways",
      "ec2:DescribeTransitGateways"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-04-30T15:29:29+00:00"
 },
 "AWSDirectConnectReadOnlyAccess":{
  "CreateDate":"2015-02-06T18:40:08+00:00",
  "DefaultVersionId":"v4",
  "Document":{
   "Statement":[
    {
     "Action":[
      "directconnect:Describe*",
      "directconnect:List*",
      "ec2:DescribeVpnGateways",
      "ec2:DescribeTransitGateways"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-05-18T18:48:22+00:00"
 },
 "AWSDirectConnectServiceRolePolicy":{
  "CreateDate":"2021-01-14T18:35:27+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "secretsmanager:DescribeSecret",
      "secretsmanager:ListSecretVersionIds",
      "secretsmanager:GetSecretValue"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:secretsmanager:*:*:secret:*directconnect*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-01-14T18:35:27+00:00"
 },
 "AWSDirectoryServiceFullAccess":{
  "CreateDate":"2015-02-06T18:41:11+00:00",
  "DefaultVersionId":"v5",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ds:*",
      "ec2:AuthorizeSecurityGroupEgress",
      "ec2:AuthorizeSecurityGroupIngress",
      "ec2:CreateNetworkInterface",
      "ec2:CreateSecurityGroup",
      "ec2:DeleteNetworkInterface",
      "ec2:DeleteSecurityGroup",
      "ec2:DescribeNetworkInterfaces",
      "ec2:DescribeSubnets",
      "ec2:DescribeVpcs",
      "ec2:RevokeSecurityGroupEgress",
      "ec2:RevokeSecurityGroupIngress",
      "ec2:DescribeSecurityGroups",
      "sns:GetTopicAttributes",
      "sns:ListSubscriptions",
      "sns:ListSubscriptionsByTopic",
      "sns:ListTopics",
      "iam:ListRoles",
      "organizations:ListAccountsForParent",
      "organizations:ListRoots",
      "organizations:ListAccounts",
      "organizations:DescribeOrganization",
      "organizations:DescribeAccount",
      "organizations:ListOrganizationalUnitsForParent",
      "organizations:ListAWSServiceAccessForOrganization"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "sns:CreateTopic",
      "sns:DeleteTopic",
      "sns:SetTopicAttributes",
      "sns:Subscribe",
      "sns:Unsubscribe"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:sns:*:*:DirectoryMonitoring*"
    },
    {
     "Action":[
      "organizations:EnableAWSServiceAccess",
      "organizations:DisableAWSServiceAccess"
     ],
     "Condition":{
      "StringEquals":{
       "organizations:ServicePrincipal":"ds.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:CreateTags",
      "ec2:DeleteTags"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:network-interface/*",
      "arn:aws:ec2:*:*:security-group/*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-11-24T23:24:10+00:00"
 },
 "AWSDirectoryServiceReadOnlyAccess":{
  "CreateDate":"2015-02-06T18:41:12+00:00",
  "DefaultVersionId":"v4",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ds:Check*",
      "ds:Describe*",
      "ds:Get*",
      "ds:List*",
      "ds:Verify*",
      "ec2:DescribeNetworkInterfaces",
      "ec2:DescribeSubnets",
      "ec2:DescribeVpcs",
      "sns:ListTopics",
      "sns:GetTopicAttributes",
      "sns:ListSubscriptions",
      "sns:ListSubscriptionsByTopic",
      "organizations:DescribeAccount",
      "organizations:DescribeOrganization",
      "organizations:ListAWSServiceAccessForOrganization"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2018-09-25T21:54:01+00:00"
 },
 "AWSDiscoveryContinuousExportFirehosePolicy":{
  "CreateDate":"2018-08-09T18:29:39+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "glue:GetTableVersions"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "s3:AbortMultipartUpload",
      "s3:GetBucketLocation",
      "s3:GetObject",
      "s3:ListBucket",
      "s3:ListBucketMultipartUploads",
      "s3:PutObject"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::aws-application-discovery-service-*"
     ]
    },
    {
     "Action":[
      "logs:PutLogEvents"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:logs:*:*:log-group:/aws/application-discovery-service/firehose:log-stream:*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-06-08T17:32:46+00:00"
 },
 "AWSEC2CapacityReservationFleetRolePolicy":{
  "CreateDate":"2021-09-29T14:43:09+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:DescribeCapacityReservations",
      "ec2:DescribeInstances"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:CreateCapacityReservation",
      "ec2:CancelCapacityReservation",
      "ec2:ModifyCapacityReservation"
     ],
     "Condition":{
      "StringLike":{
       "ec2:CapacityReservationFleet":"arn:aws:ec2:*:*:capacity-reservation-fleet/crf-*"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:capacity-reservation/*"
     ]
    },
    {
     "Action":[
      "ec2:CreateTags"
     ],
     "Condition":{
      "StringEquals":{
       "ec2:CreateAction":"CreateCapacityReservation"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:capacity-reservation/*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-09-29T14:43:09+00:00"
 },
 "AWSEC2FleetServiceRolePolicy":{
  "CreateDate":"2018-03-21T00:08:55+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:DescribeImages",
      "ec2:DescribeSubnets",
      "ec2:RequestSpotInstances",
      "ec2:DescribeInstanceStatus",
      "ec2:RunInstances"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "iam:CreateServiceLinkedRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":"spot.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"EC2SpotManagement"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":[
        "ec2.amazonaws.com",
        "ec2.amazonaws.com.cn"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "ec2:CreateTags"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:instance/*",
      "arn:aws:ec2:*:*:spot-instances-request/*"
     ]
    },
    {
     "Action":[
      "ec2:CreateTags"
     ],
     "Condition":{
      "StringEquals":{
       "ec2:CreateAction":"RunInstances"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:volume/*"
     ]
    },
    {
     "Action":[
      "ec2:TerminateInstances"
     ],
     "Condition":{
      "StringLike":{
       "ec2:ResourceTag/aws:ec2:fleet-id":"*"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-05-04T20:10:31+00:00"
 },
 "AWSEC2SpotFleetServiceRolePolicy":{
  "CreateDate":"2017-10-23T19:13:06+00:00",
  "DefaultVersionId":"v4",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:DescribeImages",
      "ec2:DescribeSubnets",
      "ec2:RequestSpotInstances",
      "ec2:DescribeInstanceStatus",
      "ec2:RunInstances"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":[
        "ec2.amazonaws.com",
        "ec2.amazonaws.com.cn"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "ec2:CreateTags"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:instance/*",
      "arn:aws:ec2:*:*:spot-instances-request/*",
      "arn:aws:ec2:*:*:spot-fleet-request/*",
      "arn:aws:ec2:*:*:volume/*"
     ]
    },
    {
     "Action":[
      "ec2:TerminateInstances"
     ],
     "Condition":{
      "StringLike":{
       "ec2:ResourceTag/aws:ec2spot:fleet-request-id":"*"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "elasticloadbalancing:RegisterInstancesWithLoadBalancer"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:elasticloadbalancing:*:*:loadbalancer/*"
     ]
    },
    {
     "Action":[
      "elasticloadbalancing:RegisterTargets"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:elasticloadbalancing:*:*:*/*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-03-16T19:16:21+00:00"
 },
 "AWSEC2SpotServiceRolePolicy":{
  "CreateDate":"2017-09-18T18:51:54+00:00",
  "DefaultVersionId":"v4",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:DescribeInstances",
      "ec2:StartInstances",
      "ec2:StopInstances",
      "ec2:RunInstances"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "ec2:RunInstances"
     ],
     "Condition":{
      "StringNotEquals":{
       "ec2:InstanceMarketType":"spot"
      }
     },
     "Effect":"Deny",
     "Resource":[
      "arn:aws:ec2:*:*:instance/*"
     ]
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":[
        "ec2.amazonaws.com",
        "ec2.amazonaws.com.cn"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "ec2:CreateTags"
     ],
     "Condition":{
      "StringEquals":{
       "ec2:CreateAction":"RunInstances"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2018-12-12T00:13:51+00:00"
 },
 "AWSECRPullThroughCache_ServiceRolePolicy":{
  "CreateDate":"2021-11-26T21:51:09+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ecr:GetAuthorizationToken",
      "ecr:BatchCheckLayerAvailability",
      "ecr:InitiateLayerUpload",
      "ecr:UploadLayerPart",
      "ecr:CompleteLayerUpload",
      "ecr:PutImage"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-11-26T21:51:09+00:00"
 },
 "AWSElasticBeanstalkCustomPlatformforEC2Role":{
  "CreateDate":"2017-02-21T22:50:30+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:AttachVolume",
      "ec2:AuthorizeSecurityGroupIngress",
      "ec2:CopyImage",
      "ec2:CreateImage",
      "ec2:CreateKeypair",
      "ec2:CreateSecurityGroup",
      "ec2:CreateSnapshot",
      "ec2:CreateTags",
      "ec2:CreateVolume",
      "ec2:DeleteKeypair",
      "ec2:DeleteSecurityGroup",
      "ec2:DeleteSnapshot",
      "ec2:DeleteVolume",
      "ec2:DeregisterImage",
      "ec2:DescribeImageAttribute",
      "ec2:DescribeImages",
      "ec2:DescribeInstances",
      "ec2:DescribeRegions",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeSnapshots",
      "ec2:DescribeSubnets",
      "ec2:DescribeTags",
      "ec2:DescribeVolumes",
      "ec2:DetachVolume",
      "ec2:GetPasswordData",
      "ec2:ModifyImageAttribute",
      "ec2:ModifyInstanceAttribute",
      "ec2:ModifySnapshotAttribute",
      "ec2:RegisterImage",
      "ec2:RunInstances",
      "ec2:StopInstances",
      "ec2:TerminateInstances"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"EC2Access"
    },
    {
     "Action":[
      "s3:Get*",
      "s3:List*",
      "s3:PutObject"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::elasticbeanstalk-*",
      "arn:aws:s3:::elasticbeanstalk-*/*"
     ],
     "Sid":"BucketAccess"
    },
    {
     "Action":[
      "logs:CreateLogGroup",
      "logs:CreateLogStream",
      "logs:PutLogEvents",
      "logs:DescribeLogStreams"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:logs:*:*:log-group:/aws/elasticbeanstalk/platform/*",
     "Sid":"CloudWatchLogsAccess"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2017-02-21T22:50:30+00:00"
 },
 "AWSElasticBeanstalkEnhancedHealth":{
  "CreateDate":"2016-02-08T23:17:27+00:00",
  "DefaultVersionId":"v4",
  "Document":{
   "Statement":[
    {
     "Action":[
      "elasticloadbalancing:DescribeInstanceHealth",
      "elasticloadbalancing:DescribeLoadBalancers",
      "elasticloadbalancing:DescribeTargetHealth",
      "ec2:DescribeInstances",
      "ec2:DescribeInstanceStatus",
      "ec2:GetConsoleOutput",
      "ec2:AssociateAddress",
      "ec2:DescribeAddresses",
      "ec2:DescribeSecurityGroups",
      "sqs:GetQueueAttributes",
      "sqs:GetQueueUrl",
      "autoscaling:DescribeAutoScalingGroups",
      "autoscaling:DescribeAutoScalingInstances",
      "autoscaling:DescribeScalingActivities",
      "autoscaling:DescribeNotificationConfigurations",
      "sns:Publish"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "logs:DescribeLogStreams",
      "logs:CreateLogStream",
      "logs:PutLogEvents"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:logs:*:*:log-group:/aws/elasticbeanstalk/*:log-stream:*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2018-04-09T22:12:53+00:00"
 },
 "AWSElasticBeanstalkMaintenance":{
  "CreateDate":"2019-01-11T23:22:52+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cloudformation:CreateChangeSet",
      "cloudformation:DescribeChangeSet",
      "cloudformation:ExecuteChangeSet",
      "cloudformation:DeleteChangeSet",
      "cloudformation:ListChangeSets",
      "cloudformation:DescribeStacks"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:cloudformation:*:*:stack/awseb-*",
      "arn:aws:cloudformation:*:*:stack/eb-*"
     ],
     "Sid":"AllowCloudformationChangeSetOperationsOnElasticBeanstalkStacks"
    },
    {
     "Action":"elasticloadbalancing:DescribeLoadBalancers",
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AllowElasticBeanstalkStacksUpdateExecuteSuccessfully"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-06-04T17:48:27+00:00"
 },
 "AWSElasticBeanstalkManagedUpdatesCustomerRolePolicy":{
  "CreateDate":"2021-03-03T22:18:00+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "elasticbeanstalk:*"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ElasticBeanstalkPermissions"
    },
    {
     "Action":"iam:PassRole",
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":[
        "elasticbeanstalk.amazonaws.com",
        "ec2.amazonaws.com",
        "ec2.amazonaws.com.cn",
        "autoscaling.amazonaws.com",
        "elasticloadbalancing.amazonaws.com",
        "ecs.amazonaws.com",
        "cloudformation.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/*",
     "Sid":"AllowPassRoleToElasticBeanstalkAndDownstreamServices"
    },
    {
     "Action":[
      "autoscaling:DescribeAccountLimits",
      "autoscaling:DescribeAutoScalingGroups",
      "autoscaling:DescribeAutoScalingInstances",
      "autoscaling:DescribeLaunchConfigurations",
      "autoscaling:DescribeLoadBalancers",
      "autoscaling:DescribeNotificationConfigurations",
      "autoscaling:DescribeScalingActivities",
      "autoscaling:DescribeScheduledActions",
      "ec2:DescribeAccountAttributes",
      "ec2:DescribeAddresses",
      "ec2:DescribeAvailabilityZones",
      "ec2:DescribeImages",
      "ec2:DescribeInstanceAttribute",
      "ec2:DescribeInstances",
      "ec2:DescribeKeyPairs",
      "ec2:DescribeLaunchTemplates",
      "ec2:DescribeLaunchTemplateVersions",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeSnapshots",
      "ec2:DescribeSpotInstanceRequests",
      "ec2:DescribeSubnets",
      "ec2:DescribeVpcClassicLink",
      "ec2:DescribeVpcs",
      "elasticloadbalancing:DescribeInstanceHealth",
      "elasticloadbalancing:DescribeLoadBalancers",
      "elasticloadbalancing:DescribeTargetGroups",
      "elasticloadbalancing:DescribeTargetHealth",
      "logs:DescribeLogGroups",
      "rds:DescribeDBEngineVersions",
      "rds:DescribeDBInstances",
      "rds:DescribeOrderableDBInstanceOptions",
      "sns:ListSubscriptionsByTopic"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"ReadOnlyPermissions"
    },
    {
     "Action":[
      "ec2:AllocateAddress",
      "ec2:AssociateAddress",
      "ec2:AuthorizeSecurityGroupEgress",
      "ec2:AuthorizeSecurityGroupIngress",
      "ec2:CreateLaunchTemplate",
      "ec2:CreateLaunchTemplateVersion",
      "ec2:CreateSecurityGroup",
      "ec2:DeleteLaunchTemplate",
      "ec2:DeleteLaunchTemplateVersions",
      "ec2:DeleteSecurityGroup",
      "ec2:DisassociateAddress",
      "ec2:ReleaseAddress",
      "ec2:RevokeSecurityGroupEgress",
      "ec2:RevokeSecurityGroupIngress"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"EC2BroadOperationPermissions"
    },
    {
     "Action":"ec2:RunInstances",
     "Condition":{
      "ArnLike":{
       "ec2:LaunchTemplate":"arn:aws:ec2:*:*:launch-template/*"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"EC2RunInstancesOperationPermissions"
    },
    {
     "Action":[
      "ec2:TerminateInstances"
     ],
     "Condition":{
      "StringLike":{
       "ec2:ResourceTag/aws:cloudformation:stack-id":[
        "arn:aws:cloudformation:*:*:stack/awseb-e-*",
        "arn:aws:cloudformation:*:*:stack/eb-*"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:instance/*",
     "Sid":"EC2TerminateInstancesOperationPermissions"
    },
    {
     "Action":[
      "ecs:CreateCluster",
      "ecs:DescribeClusters",
      "ecs:RegisterTaskDefinition"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ECSBroadOperationPermissions"
    },
    {
     "Action":"ecs:DeleteCluster",
     "Effect":"Allow",
     "Resource":"arn:aws:ecs:*:*:cluster/awseb-*",
     "Sid":"ECSDeleteClusterOperationPermissions"
    },
    {
     "Action":[
      "autoscaling:AttachInstances",
      "autoscaling:CreateAutoScalingGroup",
      "autoscaling:CreateLaunchConfiguration",
      "autoscaling:DeleteLaunchConfiguration",
      "autoscaling:DeleteAutoScalingGroup",
      "autoscaling:DeleteScheduledAction",
      "autoscaling:DetachInstances",
      "autoscaling:DeletePolicy",
      "autoscaling:PutScalingPolicy",
      "autoscaling:PutScheduledUpdateGroupAction",
      "autoscaling:PutNotificationConfiguration",
      "autoscaling:ResumeProcesses",
      "autoscaling:SetDesiredCapacity",
      "autoscaling:SuspendProcesses",
      "autoscaling:TerminateInstanceInAutoScalingGroup",
      "autoscaling:UpdateAutoScalingGroup"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:autoscaling:*:*:launchConfiguration:*:launchConfigurationName/awseb-e-*",
      "arn:aws:autoscaling:*:*:launchConfiguration:*:launchConfigurationName/eb-*",
      "arn:aws:autoscaling:*:*:autoScalingGroup:*:autoScalingGroupName/awseb-e-*",
      "arn:aws:autoscaling:*:*:autoScalingGroup:*:autoScalingGroupName/eb-*"
     ],
     "Sid":"ASGOperationPermissions"
    },
    {
     "Action":[
      "cloudformation:*"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:cloudformation:*:*:stack/awseb-*",
      "arn:aws:cloudformation:*:*:stack/eb-*"
     ],
     "Sid":"CFNOperationPermissions"
    },
    {
     "Action":[
      "elasticloadbalancing:ApplySecurityGroupsToLoadBalancer",
      "elasticloadbalancing:ConfigureHealthCheck",
      "elasticloadbalancing:CreateLoadBalancer",
      "elasticloadbalancing:DeleteLoadBalancer",
      "elasticloadbalancing:DeregisterInstancesFromLoadBalancer",
      "elasticloadbalancing:DeregisterTargets",
      "elasticloadbalancing:RegisterInstancesWithLoadBalancer",
      "elasticloadbalancing:RegisterTargets"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:elasticloadbalancing:*:*:targetgroup/awseb-*",
      "arn:aws:elasticloadbalancing:*:*:targetgroup/eb-*",
      "arn:aws:elasticloadbalancing:*:*:loadbalancer/awseb-*",
      "arn:aws:elasticloadbalancing:*:*:loadbalancer/eb-*",
      "arn:aws:elasticloadbalancing:*:*:loadbalancer/*/awseb-*/*",
      "arn:aws:elasticloadbalancing:*:*:loadbalancer/*/eb-*/*"
     ],
     "Sid":"ELBOperationPermissions"
    },
    {
     "Action":[
      "logs:CreateLogGroup",
      "logs:DeleteLogGroup",
      "logs:PutRetentionPolicy"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:logs:*:*:log-group:/aws/elasticbeanstalk/*",
     "Sid":"CWLogsOperationPermissions"
    },
    {
     "Action":[
      "s3:DeleteObject",
      "s3:GetObject",
      "s3:GetObjectAcl",
      "s3:GetObjectVersion",
      "s3:GetObjectVersionAcl",
      "s3:PutObject",
      "s3:PutObjectAcl",
      "s3:PutObjectVersionAcl"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::elasticbeanstalk-*/*",
     "Sid":"S3ObjectOperationPermissions"
    },
    {
     "Action":[
      "s3:GetBucketLocation",
      "s3:GetBucketPolicy",
      "s3:ListBucket",
      "s3:PutBucketPolicy"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::elasticbeanstalk-*",
     "Sid":"S3BucketOperationPermissions"
    },
    {
     "Action":[
      "sns:CreateTopic",
      "sns:GetTopicAttributes",
      "sns:SetTopicAttributes",
      "sns:Subscribe"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:sns:*:*:ElasticBeanstalkNotifications-*",
     "Sid":"SNSOperationPermissions"
    },
    {
     "Action":[
      "sqs:GetQueueAttributes",
      "sqs:GetQueueUrl"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:sqs:*:*:awseb-e-*",
      "arn:aws:sqs:*:*:eb-*"
     ],
     "Sid":"SQSOperationPermissions"
    },
    {
     "Action":[
      "cloudwatch:PutMetricAlarm"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:cloudwatch:*:*:alarm:awseb-*",
      "arn:aws:cloudwatch:*:*:alarm:eb-*"
     ],
     "Sid":"CWPutMetricAlarmOperationPermissions"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-06-16T22:40:31+00:00"
 },
 "AWSElasticBeanstalkManagedUpdatesServiceRolePolicy":{
  "CreateDate":"2019-11-21T22:35:06+00:00",
  "DefaultVersionId":"v5",
  "Document":{
   "Statement":[
    {
     "Action":"iam:PassRole",
     "Condition":{
      "StringLikeIfExists":{
       "iam:PassedToService":[
        "elasticbeanstalk.amazonaws.com",
        "ec2.amazonaws.com",
        "autoscaling.amazonaws.com",
        "elasticloadbalancing.amazonaws.com",
        "ecs.amazonaws.com",
        "cloudformation.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AllowPassRoleToElasticBeanstalkAndDownstreamServices"
    },
    {
     "Action":[
      "ec2:releaseAddress",
      "ec2:allocateAddress",
      "ec2:DisassociateAddress",
      "ec2:AssociateAddress"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"SingleInstanceAPIs"
    },
    {
     "Action":[
      "ecs:RegisterTaskDefinition",
      "ecs:DeRegisterTaskDefinition",
      "ecs:List*",
      "ecs:Describe*"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ECS"
    },
    {
     "Action":[
      "elasticbeanstalk:*"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ElasticBeanstalkAPIs"
    },
    {
     "Action":[
      "cloudformation:Describe*",
      "cloudformation:List*",
      "ec2:Describe*",
      "autoscaling:Describe*",
      "elasticloadbalancing:Describe*",
      "logs:DescribeLogGroups",
      "sns:GetTopicAttributes",
      "sns:ListSubscriptionsByTopic"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ReadOnlyAPIs"
    },
    {
     "Action":[
      "autoscaling:AttachInstances",
      "autoscaling:CreateAutoScalingGroup",
      "autoscaling:CreateLaunchConfiguration",
      "autoscaling:DeleteAutoScalingGroup",
      "autoscaling:DeleteLaunchConfiguration",
      "autoscaling:DeleteScheduledAction",
      "autoscaling:DetachInstances",
      "autoscaling:PutNotificationConfiguration",
      "autoscaling:PutScalingPolicy",
      "autoscaling:PutScheduledUpdateGroupAction",
      "autoscaling:ResumeProcesses",
      "autoscaling:SuspendProcesses",
      "autoscaling:TerminateInstanceInAutoScalingGroup",
      "autoscaling:UpdateAutoScalingGroup"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:autoscaling:*:*:launchConfiguration:*:launchConfigurationName/awseb-e-*",
      "arn:aws:autoscaling:*:*:autoScalingGroup:*:autoScalingGroupName/awseb-e-*",
      "arn:aws:autoscaling:*:*:launchConfiguration:*:launchConfigurationName/eb-*",
      "arn:aws:autoscaling:*:*:autoScalingGroup:*:autoScalingGroupName/eb-*"
     ],
     "Sid":"ASG"
    },
    {
     "Action":[
      "cloudformation:CreateStack",
      "cloudformation:CancelUpdateStack",
      "cloudformation:DeleteStack",
      "cloudformation:GetTemplate",
      "cloudformation:UpdateStack"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:cloudformation:*:*:stack/awseb-e-*",
      "arn:aws:cloudformation:*:*:stack/eb-*"
     ],
     "Sid":"CFN"
    },
    {
     "Action":[
      "ec2:TerminateInstances"
     ],
     "Condition":{
      "StringLike":{
       "ec2:ResourceTag/aws:cloudformation:stack-id":[
        "arn:aws:cloudformation:*:*:stack/awseb-e-*",
        "arn:aws:cloudformation:*:*:stack/eb-*"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:instance/*",
     "Sid":"EC2"
    },
    {
     "Action":[
      "s3:DeleteObject",
      "s3:GetObject",
      "s3:GetObjectAcl",
      "s3:GetObjectVersion",
      "s3:GetObjectVersionAcl",
      "s3:PutObject",
      "s3:PutObjectAcl",
      "s3:PutObjectVersionAcl"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::elasticbeanstalk-*/*",
     "Sid":"S3Obj"
    },
    {
     "Action":[
      "s3:GetBucketLocation",
      "s3:GetBucketPolicy",
      "s3:ListBucket",
      "s3:PutBucketPolicy"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::elasticbeanstalk-*",
     "Sid":"S3Bucket"
    },
    {
     "Action":[
      "logs:CreateLogGroup",
      "logs:DeleteLogGroup",
      "logs:PutRetentionPolicy"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:logs:*:*:log-group:/aws/elasticbeanstalk/*",
     "Sid":"CWL"
    },
    {
     "Action":[
      "elasticloadbalancing:RegisterTargets",
      "elasticloadbalancing:DeRegisterTargets",
      "elasticloadbalancing:DeregisterInstancesFromLoadBalancer",
      "elasticloadbalancing:RegisterInstancesWithLoadBalancer"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:elasticloadbalancing:*:*:targetgroup/awseb-*",
      "arn:aws:elasticloadbalancing:*:*:loadbalancer/awseb-e-*",
      "arn:aws:elasticloadbalancing:*:*:targetgroup/eb-*",
      "arn:aws:elasticloadbalancing:*:*:loadbalancer/eb-*"
     ],
     "Sid":"ELB"
    },
    {
     "Action":[
      "sns:CreateTopic"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:sns:*:*:ElasticBeanstalkNotifications-Environment-*",
     "Sid":"SNS"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-12-11T18:21:32+00:00"
 },
 "AWSElasticBeanstalkMulticontainerDocker":{
  "CreateDate":"2016-02-08T23:15:29+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ecs:Poll",
      "ecs:StartTask",
      "ecs:StopTask",
      "ecs:DiscoverPollEndpoint",
      "ecs:StartTelemetrySession",
      "ecs:RegisterContainerInstance",
      "ecs:DeregisterContainerInstance",
      "ecs:DescribeContainerInstances",
      "ecs:Submit*",
      "ecs:DescribeTasks"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ECSAccess"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2016-06-06T23:45:37+00:00"
 },
 "AWSElasticBeanstalkReadOnly":{
  "CreateDate":"2021-01-22T19:02:37+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "acm:ListCertificates",
      "autoscaling:DescribeAccountLimits",
      "autoscaling:DescribeAutoScalingGroups",
      "autoscaling:DescribeAutoScalingInstances",
      "autoscaling:DescribeLaunchConfigurations",
      "autoscaling:DescribePolicies",
      "autoscaling:DescribeLoadBalancers",
      "autoscaling:DescribeNotificationConfigurations",
      "autoscaling:DescribeScalingActivities",
      "autoscaling:DescribeScheduledActions",
      "cloudformation:DescribeStackResource",
      "cloudformation:DescribeStackResources",
      "cloudformation:DescribeStacks",
      "cloudformation:GetTemplate",
      "cloudformation:ListStackResources",
      "cloudformation:ListStacks",
      "cloudformation:ValidateTemplate",
      "cloudtrail:LookupEvents",
      "cloudwatch:DescribeAlarms",
      "cloudwatch:GetMetricStatistics",
      "cloudwatch:ListMetrics",
      "ec2:DescribeAccountAttributes",
      "ec2:DescribeAddresses",
      "ec2:DescribeImages",
      "ec2:DescribeInstanceAttribute",
      "ec2:DescribeInstances",
      "ec2:DescribeInstanceStatus",
      "ec2:DescribeKeyPairs",
      "ec2:DescribeLaunchTemplateVersions",
      "ec2:DescribeLaunchTemplates",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeSnapshots",
      "ec2:DescribeSpotInstanceRequests",
      "ec2:DescribeAvailabilityZones",
      "ec2:DescribeSubnets",
      "ec2:DescribeVpcs",
      "elasticbeanstalk:Check*",
      "elasticbeanstalk:Describe*",
      "elasticbeanstalk:List*",
      "elasticbeanstalk:RequestEnvironmentInfo",
      "elasticbeanstalk:RetrieveEnvironmentInfo",
      "elasticloadbalancing:DescribeInstanceHealth",
      "elasticloadbalancing:DescribeLoadBalancers",
      "elasticloadbalancing:DescribeSSLPolicies",
      "elasticloadbalancing:DescribeTargetGroups",
      "elasticloadbalancing:DescribeTargetHealth",
      "iam:GetRole",
      "iam:ListAttachedRolePolicies",
      "iam:ListInstanceProfiles",
      "iam:ListRolePolicies",
      "iam:ListRoles",
      "iam:ListServerCertificates",
      "rds:DescribeDBEngineVersions",
      "rds:DescribeDBInstances",
      "rds:DescribeOrderableDBInstanceOptions",
      "rds:DescribeDBSnapshots",
      "s3:ListAllMyBuckets",
      "sns:ListSubscriptionsByTopic",
      "sns:ListTopics",
      "sqs:ListQueues"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AllowAPIs"
    },
    {
     "Action":[
      "s3:GetObject",
      "s3:GetObjectAcl",
      "s3:GetObjectVersion",
      "s3:GetObjectVersionAcl",
      "s3:GetBucketLocation",
      "s3:GetBucketPolicy",
      "s3:ListBucket"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::elasticbeanstalk-*",
     "Sid":"AllowS3"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-01-22T19:02:37+00:00"
 },
 "AWSElasticBeanstalkRoleCWL":{
  "CreateDate":"2020-06-05T21:49:06+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "logs:CreateLogGroup",
      "logs:DeleteLogGroup",
      "logs:PutRetentionPolicy"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:logs:*:*:log-group:/aws/elasticbeanstalk/*",
     "Sid":"AllowCWL"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-06-05T21:49:06+00:00"
 },
 "AWSElasticBeanstalkRoleCore":{
  "CreateDate":"2020-06-05T21:48:24+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:TerminateInstances"
     ],
     "Condition":{
      "StringLike":{
       "ec2:ResourceTag/aws:cloudformation:stack-id":"arn:aws:cloudformation:*:*:stack/awseb-e-*"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:instance/*",
     "Sid":"TerminateInstances"
    },
    {
     "Action":[
      "ec2:ReleaseAddress",
      "ec2:AllocateAddress",
      "ec2:DisassociateAddress",
      "ec2:AssociateAddress",
      "ec2:CreateTags",
      "ec2:DeleteTags",
      "ec2:CreateSecurityGroup",
      "ec2:DeleteSecurityGroup",
      "ec2:AuthorizeSecurityGroup*",
      "ec2:RevokeSecurityGroup*",
      "ec2:CreateLaunchTemplate*",
      "ec2:DeleteLaunchTemplate*"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"EC2"
    },
    {
     "Action":"ec2:RunInstances",
     "Condition":{
      "ArnLike":{
       "ec2:LaunchTemplate":"arn:aws:ec2:*:*:launch-template/*"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"LTRunInstances"
    },
    {
     "Action":[
      "autoscaling:AttachInstances",
      "autoscaling:*LoadBalancer*",
      "autoscaling:*AutoScalingGroup",
      "autoscaling:*LaunchConfiguration",
      "autoscaling:DeleteScheduledAction",
      "autoscaling:DetachInstances",
      "autoscaling:PutNotificationConfiguration",
      "autoscaling:PutScalingPolicy",
      "autoscaling:PutScheduledUpdateGroupAction",
      "autoscaling:ResumeProcesses",
      "autoscaling:SuspendProcesses",
      "autoscaling:*Tags"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:autoscaling:*:*:launchConfiguration:*:launchConfigurationName/awseb-e-*",
      "arn:aws:autoscaling:*:*:autoScalingGroup:*:autoScalingGroupName/awseb-e-*"
     ],
     "Sid":"ASG"
    },
    {
     "Action":[
      "autoscaling:DeletePolicy"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"ASGPolicy"
    },
    {
     "Action":[
      "iam:CreateServiceLinkedRole"
     ],
     "Condition":{
      "StringLike":{
       "iam:AWSServiceName":"elasticbeanstalk.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/aws-service-role/elasticbeanstalk.amazonaws.com/AWSServiceRoleForElasticBeanstalk*"
     ],
     "Sid":"EBSLR"
    },
    {
     "Action":[
      "s3:Delete*",
      "s3:Get*",
      "s3:Put*"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::elasticbeanstalk-*/*",
      "arn:aws:s3:::elasticbeanstalk-env-resources-*/*"
     ],
     "Sid":"S3Obj"
    },
    {
     "Action":[
      "s3:GetBucket*",
      "s3:ListBucket",
      "s3:PutBucketPolicy"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::elasticbeanstalk-*",
     "Sid":"S3Bucket"
    },
    {
     "Action":[
      "cloudformation:CreateStack",
      "cloudformation:DeleteStack",
      "cloudformation:GetTemplate",
      "cloudformation:ListStackResources",
      "cloudformation:UpdateStack",
      "cloudformation:ContinueUpdateRollback",
      "cloudformation:CancelUpdateStack"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:cloudformation:*:*:stack/awseb-e-*",
     "Sid":"CFN"
    },
    {
     "Action":[
      "cloudwatch:PutMetricAlarm",
      "cloudwatch:DeleteAlarms"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:cloudwatch:*:*:alarm:awseb-*",
     "Sid":"CloudWatch"
    },
    {
     "Action":[
      "elasticloadbalancing:Create*",
      "elasticloadbalancing:Delete*",
      "elasticloadbalancing:Modify*",
      "elasticloadbalancing:RegisterTargets",
      "elasticloadbalancing:DeRegisterTargets",
      "elasticloadbalancing:DeregisterInstancesFromLoadBalancer",
      "elasticloadbalancing:RegisterInstancesWithLoadBalancer",
      "elasticloadbalancing:*Tags",
      "elasticloadbalancing:ConfigureHealthCheck",
      "elasticloadbalancing:SetRulePriorities",
      "elasticloadbalancing:SetLoadBalancerPoliciesOfListener"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:elasticloadbalancing:*:*:targetgroup/awseb-*",
      "arn:aws:elasticloadbalancing:*:*:loadbalancer/awseb-*",
      "arn:aws:elasticloadbalancing:*:*:loadbalancer/app/awseb-*/*",
      "arn:aws:elasticloadbalancing:*:*:loadbalancer/net/awseb-*/*",
      "arn:aws:elasticloadbalancing:*:*:listener/awseb-*",
      "arn:aws:elasticloadbalancing:*:*:listener/app/awseb-*",
      "arn:aws:elasticloadbalancing:*:*:listener/net/awseb-*",
      "arn:aws:elasticloadbalancing:*:*:listener-rule/app/awseb-*/*/*/*"
     ],
     "Sid":"ELB"
    },
    {
     "Action":[
      "autoscaling:Describe*",
      "cloudformation:Describe*",
      "logs:Describe*",
      "ec2:Describe*",
      "ecs:Describe*",
      "ecs:List*",
      "elasticloadbalancing:Describe*",
      "rds:Describe*",
      "sns:List*",
      "iam:List*",
      "acm:Describe*",
      "acm:List*"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ListAPIs"
    },
    {
     "Action":"iam:PassRole",
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":[
        "elasticbeanstalk.amazonaws.com",
        "ec2.amazonaws.com",
        "autoscaling.amazonaws.com",
        "elasticloadbalancing.amazonaws.com",
        "ecs.amazonaws.com",
        "cloudformation.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/aws-elasticbeanstalk-*",
     "Sid":"AllowPassRole"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-09-09T20:31:14+00:00"
 },
 "AWSElasticBeanstalkRoleECS":{
  "CreateDate":"2020-06-05T21:47:27+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ecs:CreateCluster",
      "ecs:DeleteCluster",
      "ecs:RegisterTaskDefinition",
      "ecs:DeRegisterTaskDefinition"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"AllowECS"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-06-05T21:47:27+00:00"
 },
 "AWSElasticBeanstalkRoleRDS":{
  "CreateDate":"2020-06-05T21:46:55+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "rds:CreateDBSecurityGroup",
      "rds:DeleteDBSecurityGroup",
      "rds:AuthorizeDBSecurityGroupIngress",
      "rds:CreateDBInstance",
      "rds:ModifyDBInstance",
      "rds:DeleteDBInstance"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:rds:*:*:secgrp:awseb-e-*",
      "arn:aws:rds:*:*:db:*"
     ],
     "Sid":"AllowRDS"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-06-05T21:46:55+00:00"
 },
 "AWSElasticBeanstalkRoleSNS":{
  "CreateDate":"2020-06-05T21:46:22+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "sns:CreateTopic",
      "sns:SetTopicAttributes",
      "sns:DeleteTopic"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:sns:*:*:ElasticBeanstalkNotifications-*"
     ],
     "Sid":"AllowBeanstalkManageSNS"
    },
    {
     "Action":[
      "sns:GetTopicAttributes",
      "sns:Subscribe",
      "sns:Unsubscribe",
      "sns:Publish"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AllowSNSPublish"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-06-05T21:46:22+00:00"
 },
 "AWSElasticBeanstalkRoleWorkerTier":{
  "CreateDate":"2020-06-05T21:43:37+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "sqs:TagQueue",
      "sqs:DeleteQueue",
      "sqs:GetQueueAttributes",
      "sqs:CreateQueue"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:sqs:*:*:awseb-e-*",
     "Sid":"AllowSQS"
    },
    {
     "Action":[
      "dynamodb:CreateTable",
      "dynamodb:TagResource",
      "dynamodb:DescribeTable",
      "dynamodb:DeleteTable"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:dynamodb:*:*:table/awseb-e-*",
     "Sid":"AllowDDB"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-06-05T21:43:37+00:00"
 },
 "AWSElasticBeanstalkService":{
  "CreateDate":"2016-04-11T20:27:23+00:00",
  "DefaultVersionId":"v16",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cloudformation:*"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:cloudformation:*:*:stack/awseb-*",
      "arn:aws:cloudformation:*:*:stack/eb-*"
     ],
     "Sid":"AllowCloudformationOperationsOnElasticBeanstalkStacks"
    },
    {
     "Action":[
      "logs:DeleteLogGroup"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:logs:*:*:log-group:/aws/elasticbeanstalk*"
     ],
     "Sid":"AllowDeleteCloudwatchLogGroups"
    },
    {
     "Action":[
      "s3:*"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::elasticbeanstalk-*",
      "arn:aws:s3:::elasticbeanstalk-*/*"
     ],
     "Sid":"AllowS3OperationsOnElasticBeanstalkBuckets"
    },
    {
     "Action":"ec2:RunInstances",
     "Condition":{
      "ArnLike":{
       "ec2:LaunchTemplate":"arn:aws:ec2:*:*:launch-template/*"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AllowLaunchTemplateRunInstances"
    },
    {
     "Action":[
      "autoscaling:AttachInstances",
      "autoscaling:CreateAutoScalingGroup",
      "autoscaling:CreateLaunchConfiguration",
      "autoscaling:DeleteLaunchConfiguration",
      "autoscaling:DeleteAutoScalingGroup",
      "autoscaling:DeleteScheduledAction",
      "autoscaling:DescribeAccountLimits",
      "autoscaling:DescribeAutoScalingGroups",
      "autoscaling:DescribeAutoScalingInstances",
      "autoscaling:DescribeLaunchConfigurations",
      "autoscaling:DescribeLoadBalancers",
      "autoscaling:DescribeNotificationConfigurations",
      "autoscaling:DescribeScalingActivities",
      "autoscaling:DescribeScheduledActions",
      "autoscaling:DetachInstances",
      "autoscaling:DeletePolicy",
      "autoscaling:PutScalingPolicy",
      "autoscaling:PutScheduledUpdateGroupAction",
      "autoscaling:PutNotificationConfiguration",
      "autoscaling:ResumeProcesses",
      "autoscaling:SetDesiredCapacity",
      "autoscaling:SuspendProcesses",
      "autoscaling:TerminateInstanceInAutoScalingGroup",
      "autoscaling:UpdateAutoScalingGroup",
      "cloudwatch:PutMetricAlarm",
      "ec2:AssociateAddress",
      "ec2:AllocateAddress",
      "ec2:AuthorizeSecurityGroupEgress",
      "ec2:AuthorizeSecurityGroupIngress",
      "ec2:CreateLaunchTemplate",
      "ec2:CreateLaunchTemplateVersion",
      "ec2:DescribeLaunchTemplates",
      "ec2:DescribeLaunchTemplateVersions",
      "ec2:DeleteLaunchTemplate",
      "ec2:DeleteLaunchTemplateVersions",
      "ec2:CreateSecurityGroup",
      "ec2:DeleteSecurityGroup",
      "ec2:DescribeAccountAttributes",
      "ec2:DescribeAddresses",
      "ec2:DescribeImages",
      "ec2:DescribeInstances",
      "ec2:DescribeKeyPairs",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeSnapshots",
      "ec2:DescribeSubnets",
      "ec2:DescribeVpcs",
      "ec2:DescribeInstanceAttribute",
      "ec2:DescribeSpotInstanceRequests",
      "ec2:DescribeVpcClassicLink",
      "ec2:DisassociateAddress",
      "ec2:ReleaseAddress",
      "ec2:RevokeSecurityGroupEgress",
      "ec2:RevokeSecurityGroupIngress",
      "ec2:TerminateInstances",
      "ecs:CreateCluster",
      "ecs:DeleteCluster",
      "ecs:DescribeClusters",
      "ecs:RegisterTaskDefinition",
      "elasticbeanstalk:*",
      "elasticloadbalancing:ApplySecurityGroupsToLoadBalancer",
      "elasticloadbalancing:ConfigureHealthCheck",
      "elasticloadbalancing:CreateLoadBalancer",
      "elasticloadbalancing:DeleteLoadBalancer",
      "elasticloadbalancing:DeregisterInstancesFromLoadBalancer",
      "elasticloadbalancing:DescribeInstanceHealth",
      "elasticloadbalancing:DescribeLoadBalancers",
      "elasticloadbalancing:DescribeTargetHealth",
      "elasticloadbalancing:RegisterInstancesWithLoadBalancer",
      "elasticloadbalancing:DescribeTargetGroups",
      "elasticloadbalancing:RegisterTargets",
      "elasticloadbalancing:DeregisterTargets",
      "iam:ListRoles",
      "iam:PassRole",
      "logs:CreateLogGroup",
      "logs:PutRetentionPolicy",
      "logs:DescribeLogGroups",
      "rds:DescribeDBEngineVersions",
      "rds:DescribeDBInstances",
      "rds:DescribeOrderableDBInstanceOptions",
      "s3:GetObject",
      "s3:GetObjectAcl",
      "s3:ListBucket",
      "sns:CreateTopic",
      "sns:GetTopicAttributes",
      "sns:ListSubscriptionsByTopic",
      "sns:Subscribe",
      "sns:SetTopicAttributes",
      "sqs:GetQueueAttributes",
      "sqs:GetQueueUrl",
      "codebuild:CreateProject",
      "codebuild:DeleteProject",
      "codebuild:BatchGetBuilds",
      "codebuild:StartBuild"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"AllowOperations"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-06-14T23:18:46+00:00"
 },
 "AWSElasticBeanstalkServiceRolePolicy":{
  "CreateDate":"2017-09-13T23:46:37+00:00",
  "DefaultVersionId":"v6",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cloudformation:DescribeStackResource",
      "cloudformation:DescribeStackResources",
      "cloudformation:DescribeStacks"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:cloudformation:*:*:stack/awseb-*",
      "arn:aws:cloudformation:*:*:stack/eb-*"
     ],
     "Sid":"AllowCloudformationReadOperationsOnElasticBeanstalkStacks"
    },
    {
     "Action":[
      "autoscaling:DescribeAutoScalingGroups",
      "autoscaling:DescribeAutoScalingInstances",
      "autoscaling:DescribeNotificationConfigurations",
      "autoscaling:DescribeScalingActivities",
      "autoscaling:PutNotificationConfiguration",
      "ec2:DescribeInstanceStatus",
      "ec2:AssociateAddress",
      "ec2:DescribeAddresses",
      "ec2:DescribeInstances",
      "ec2:DescribeSecurityGroups",
      "elasticloadbalancing:DescribeInstanceHealth",
      "elasticloadbalancing:DescribeLoadBalancers",
      "elasticloadbalancing:DescribeTargetHealth",
      "elasticloadbalancing:DescribeTargetGroups",
      "lambda:GetFunction",
      "sqs:GetQueueAttributes",
      "sqs:GetQueueUrl",
      "sns:Publish"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"AllowOperations"
    },
    {
     "Action":[
      "logs:CreateLogStream",
      "logs:DescribeLogGroups",
      "logs:DescribeLogStreams",
      "logs:DeleteLogGroup",
      "logs:PutLogEvents"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:logs:*:*:log-group:/aws/elasticbeanstalk/*",
     "Sid":"AllowOperationsOnHealthStreamingLogs"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-06-06T21:59:51+00:00"
 },
 "AWSElasticBeanstalkWebTier":{
  "CreateDate":"2016-02-08T23:08:54+00:00",
  "DefaultVersionId":"v7",
  "Document":{
   "Statement":[
    {
     "Action":[
      "s3:Get*",
      "s3:List*",
      "s3:PutObject"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::elasticbeanstalk-*",
      "arn:aws:s3:::elasticbeanstalk-*/*"
     ],
     "Sid":"BucketAccess"
    },
    {
     "Action":[
      "xray:PutTraceSegments",
      "xray:PutTelemetryRecords",
      "xray:GetSamplingRules",
      "xray:GetSamplingTargets",
      "xray:GetSamplingStatisticSummaries"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"XRayAccess"
    },
    {
     "Action":[
      "logs:PutLogEvents",
      "logs:CreateLogStream",
      "logs:DescribeLogStreams",
      "logs:DescribeLogGroups"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:logs:*:*:log-group:/aws/elasticbeanstalk*"
     ],
     "Sid":"CloudWatchLogsAccess"
    },
    {
     "Action":[
      "elasticbeanstalk:PutInstanceStatistics"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:elasticbeanstalk:*:*:application/*",
      "arn:aws:elasticbeanstalk:*:*:environment/*"
     ],
     "Sid":"ElasticBeanstalkHealthAccess"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-09-09T19:38:36+00:00"
 },
 "AWSElasticBeanstalkWorkerTier":{
  "CreateDate":"2016-02-08T23:12:02+00:00",
  "DefaultVersionId":"v6",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cloudwatch:PutMetricData"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"MetricsAccess"
    },
    {
     "Action":[
      "xray:PutTraceSegments",
      "xray:PutTelemetryRecords",
      "xray:GetSamplingRules",
      "xray:GetSamplingTargets",
      "xray:GetSamplingStatisticSummaries"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"XRayAccess"
    },
    {
     "Action":[
      "sqs:ChangeMessageVisibility",
      "sqs:DeleteMessage",
      "sqs:ReceiveMessage",
      "sqs:SendMessage"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"QueueAccess"
    },
    {
     "Action":[
      "s3:Get*",
      "s3:List*",
      "s3:PutObject"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::elasticbeanstalk-*",
      "arn:aws:s3:::elasticbeanstalk-*/*"
     ],
     "Sid":"BucketAccess"
    },
    {
     "Action":[
      "dynamodb:BatchGetItem",
      "dynamodb:BatchWriteItem",
      "dynamodb:DeleteItem",
      "dynamodb:GetItem",
      "dynamodb:PutItem",
      "dynamodb:Query",
      "dynamodb:Scan",
      "dynamodb:UpdateItem"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:dynamodb:*:*:table/*-stack-AWSEBWorkerCronLeaderRegistry*"
     ],
     "Sid":"DynamoPeriodicTasks"
    },
    {
     "Action":[
      "logs:PutLogEvents",
      "logs:CreateLogStream"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:logs:*:*:log-group:/aws/elasticbeanstalk*"
     ],
     "Sid":"CloudWatchLogsAccess"
    },
    {
     "Action":[
      "elasticbeanstalk:PutInstanceStatistics"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:elasticbeanstalk:*:*:application/*",
      "arn:aws:elasticbeanstalk:*:*:environment/*"
     ],
     "Sid":"ElasticBeanstalkHealthAccess"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-09-09T19:53:40+00:00"
 },
 "AWSElasticDisasterRecoveryAgentInstallationPolicy":{
  "CreateDate":"2021-11-17T10:37:54+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "drs:GetAgentInstallationAssetsForDrs",
      "drs:SendClientLogsForDrs",
      "drs:CreateSourceServerForDrs",
      "drs:CreateRecoveryInstanceForDrs",
      "drs:DescribeRecoveryInstances"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "drs:TagResource",
      "drs:IssueAgentCertificateForDrs"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:drs:*:*:source-server/*"
    },
    {
     "Action":[
      "drs:TagResource"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:drs:*:*:recovery-instance/*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-11-17T10:37:54+00:00"
 },
 "AWSElasticDisasterRecoveryAgentPolicy":{
  "CreateDate":"2021-11-17T10:32:32+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "drs:SendAgentMetricsForDrs",
      "drs:SendAgentLogsForDrs",
      "drs:UpdateAgentSourcePropertiesForDrs",
      "drs:UpdateAgentReplicationInfoForDrs",
      "drs:UpdateAgentConversionInfoForDrs",
      "drs:GetAgentCommandForDrs",
      "drs:GetAgentConfirmedResumeInfoForDrs",
      "drs:GetAgentRuntimeConfigurationForDrs",
      "drs:UpdateAgentBacklogForDrs",
      "drs:GetAgentReplicationInfoForDrs",
      "drs:IssueAgentCertificateForDrs"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:drs:*:*:source-server/${aws:SourceIdentity}"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-11-17T10:32:32+00:00"
 },
 "AWSElasticDisasterRecoveryConsoleFullAccess":{
  "CreateDate":"2021-11-17T10:46:29+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "drs:*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "kms:ListAliases",
      "kms:DescribeKey"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:DescribeAccountAttributes",
      "ec2:DescribeAvailabilityZones",
      "ec2:DescribeImages",
      "ec2:DescribeInstances",
      "ec2:DescribeInstanceTypes",
      "ec2:DescribeInstanceAttribute",
      "ec2:DescribeInstanceStatus",
      "ec2:DescribeInstanceTypeOfferings",
      "ec2:DescribeLaunchTemplateVersions",
      "ec2:DescribeLaunchTemplates",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeSnapshots",
      "ec2:DescribeSubnets",
      "ec2:DescribeVolumes",
      "ec2:GetEbsEncryptionByDefault",
      "ec2:GetEbsDefaultKmsKeyId"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"license-manager:ListLicenseConfigurations",
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"resource-groups:ListGroups",
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"elasticloadbalancing:DescribeLoadBalancers",
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "iam:ListInstanceProfiles",
      "iam:ListRoles"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"iam:PassRole",
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":"ec2.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/service-role/AWSElasticDisasterRecoveryConversionServerRole",
      "arn:aws:iam::*:role/service-role/AWSElasticDisasterRecoveryRecoveryInstanceRole"
     ]
    },
    {
     "Action":[
      "ec2:DeleteSnapshot"
     ],
     "Condition":{
      "Bool":{
       "aws:ViaAWSService":"true"
      },
      "Null":{
       "aws:ResourceTag/AWSElasticDisasterRecoveryManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:snapshot/*"
    },
    {
     "Action":[
      "ec2:CreateLaunchTemplateVersion",
      "ec2:ModifyLaunchTemplate",
      "ec2:DeleteLaunchTemplateVersions"
     ],
     "Condition":{
      "Null":{
       "aws:ResourceTag/AWSElasticDisasterRecoveryManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:launch-template/*"
    },
    {
     "Action":[
      "ec2:DeleteVolume"
     ],
     "Condition":{
      "Bool":{
       "aws:ViaAWSService":"true"
      },
      "Null":{
       "aws:ResourceTag/AWSElasticDisasterRecoveryManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:volume/*"
    },
    {
     "Action":[
      "ec2:StartInstances",
      "ec2:StopInstances",
      "ec2:TerminateInstances",
      "ec2:ModifyInstanceAttribute",
      "ec2:GetConsoleOutput",
      "ec2:GetConsoleScreenshot"
     ],
     "Condition":{
      "Bool":{
       "aws:ViaAWSService":"true"
      },
      "Null":{
       "aws:ResourceTag/AWSElasticDisasterRecoveryManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:instance/*"
    },
    {
     "Action":[
      "ec2:RevokeSecurityGroupEgress",
      "ec2:AuthorizeSecurityGroupIngress",
      "ec2:AuthorizeSecurityGroupEgress"
     ],
     "Condition":{
      "Bool":{
       "aws:ViaAWSService":"true"
      },
      "Null":{
       "aws:ResourceTag/AWSElasticDisasterRecoveryManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:security-group/*"
    },
    {
     "Action":[
      "ec2:CreateVolume"
     ],
     "Condition":{
      "Bool":{
       "aws:ViaAWSService":"true"
      },
      "Null":{
       "aws:RequestTag/AWSElasticDisasterRecoveryManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:volume/*"
    },
    {
     "Action":"ec2:CreateSecurityGroup",
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:vpc/*"
    },
    {
     "Action":[
      "ec2:CreateSecurityGroup"
     ],
     "Condition":{
      "Bool":{
       "aws:ViaAWSService":"true"
      },
      "Null":{
       "aws:RequestTag/AWSElasticDisasterRecoveryManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:security-group/*"
    },
    {
     "Action":[
      "ec2:CreateSnapshot"
     ],
     "Condition":{
      "Bool":{
       "aws:ViaAWSService":"true"
      },
      "Null":{
       "ec2:ResourceTag/AWSElasticDisasterRecoveryManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:volume/*"
    },
    {
     "Action":[
      "ec2:CreateSnapshot"
     ],
     "Condition":{
      "Bool":{
       "aws:ViaAWSService":"true"
      },
      "Null":{
       "aws:RequestTag/AWSElasticDisasterRecoveryManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:snapshot/*"
    },
    {
     "Action":[
      "ec2:DetachVolume",
      "ec2:AttachVolume"
     ],
     "Condition":{
      "Bool":{
       "aws:ViaAWSService":"true"
      },
      "Null":{
       "ec2:ResourceTag/AWSElasticDisasterRecoveryManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:instance/*"
    },
    {
     "Action":[
      "ec2:AttachVolume"
     ],
     "Condition":{
      "Bool":{
       "aws:ViaAWSService":"true"
      },
      "Null":{
       "ec2:ResourceTag/AWSElasticDisasterRecoveryManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:volume/*"
    },
    {
     "Action":[
      "ec2:DetachVolume"
     ],
     "Condition":{
      "Bool":{
       "aws:ViaAWSService":"true"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:volume/*"
    },
    {
     "Action":[
      "ec2:RunInstances"
     ],
     "Condition":{
      "Bool":{
       "aws:ViaAWSService":"true"
      },
      "Null":{
       "aws:RequestTag/AWSElasticDisasterRecoveryManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:instance/*"
    },
    {
     "Action":[
      "ec2:RunInstances"
     ],
     "Condition":{
      "Bool":{
       "aws:ViaAWSService":"true"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:security-group/*",
      "arn:aws:ec2:*:*:volume/*",
      "arn:aws:ec2:*:*:subnet/*",
      "arn:aws:ec2:*:*:image/*",
      "arn:aws:ec2:*:*:network-interface/*",
      "arn:aws:ec2:*:*:launch-template/*"
     ]
    },
    {
     "Action":"ec2:CreateTags",
     "Condition":{
      "Bool":{
       "aws:ViaAWSService":"true"
      },
      "StringEquals":{
       "ec2:CreateAction":[
        "CreateSecurityGroup",
        "CreateVolume",
        "CreateSnapshot",
        "RunInstances"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:security-group/*",
      "arn:aws:ec2:*:*:volume/*",
      "arn:aws:ec2:*:*:snapshot/*",
      "arn:aws:ec2:*:*:instance/*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-05-29T08:40:00+00:00"
 },
 "AWSElasticDisasterRecoveryConversionServerPolicy":{
  "CreateDate":"2021-11-17T13:42:23+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "drs:SendClientMetricsForDrs",
      "drs:SendClientLogsForDrs"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "drs:GetChannelCommandsForDrs",
      "drs:SendChannelCommandResultForDrs"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-11-17T13:42:23+00:00"
 },
 "AWSElasticDisasterRecoveryEc2InstancePolicy":{
  "CreateDate":"2022-05-26T12:30:18+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "drs:GetAgentInstallationAssetsForDrs",
      "drs:SendClientLogsForDrs",
      "drs:CreateSourceServerForDrs"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "drs:TagResource"
     ],
     "Condition":{
      "StringEquals":{
       "drs:CreateAction":"CreateSourceServerForDrs"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:drs:*:*:source-server/*"
    },
    {
     "Action":[
      "drs:SendAgentMetricsForDrs",
      "drs:SendAgentLogsForDrs",
      "drs:UpdateAgentSourcePropertiesForDrs",
      "drs:UpdateAgentReplicationInfoForDrs",
      "drs:UpdateAgentConversionInfoForDrs",
      "drs:GetAgentCommandForDrs",
      "drs:GetAgentConfirmedResumeInfoForDrs",
      "drs:GetAgentRuntimeConfigurationForDrs",
      "drs:UpdateAgentBacklogForDrs",
      "drs:GetAgentReplicationInfoForDrs"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:drs:*:*:source-server/*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-05-26T12:30:18+00:00"
 },
 "AWSElasticDisasterRecoveryFailbackInstallationPolicy":{
  "CreateDate":"2021-11-17T11:02:03+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "drs:SendClientLogsForDrs",
      "drs:SendClientMetricsForDrs",
      "drs:DescribeRecoveryInstances",
      "drs:DescribeSourceServers"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "drs:TagResource",
      "drs:IssueAgentCertificateForDrs",
      "drs:AssociateFailbackClientToRecoveryInstanceForDrs",
      "drs:GetSuggestedFailbackClientDeviceMappingForDrs",
      "drs:UpdateFailbackClientDeviceMappingForDrs"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:drs:*:*:recovery-instance/*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-11-17T11:02:03+00:00"
 },
 "AWSElasticDisasterRecoveryFailbackPolicy":{
  "CreateDate":"2021-11-17T10:41:40+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "drs:SendClientMetricsForDrs",
      "drs:SendClientLogsForDrs"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "drs:GetChannelCommandsForDrs",
      "drs:SendChannelCommandResultForDrs"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "drs:DescribeReplicationServerAssociationsForDrs",
      "drs:DescribeRecoveryInstances"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "drs:GetFailbackCommandForDrs",
      "drs:UpdateFailbackClientLastSeenForDrs",
      "drs:NotifyAgentAuthenticationForDrs",
      "drs:UpdateAgentReplicationProcessStateForDrs",
      "drs:NotifyAgentReplicationProgressForDrs",
      "drs:NotifyAgentConnectedForDrs",
      "drs:NotifyAgentDisconnectedForDrs",
      "drs:NotifyConsistencyAttainedForDrs",
      "drs:GetFailbackLaunchRequestedForDrs",
      "drs:IssueAgentCertificateForDrs"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:drs:*:*:recovery-instance/${aws:SourceIdentity}"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-11-17T10:41:40+00:00"
 },
 "AWSElasticDisasterRecoveryReadOnlyAccess":{
  "CreateDate":"2021-11-17T10:50:05+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "drs:DescribeJobLogItems",
      "drs:DescribeJobs",
      "drs:DescribeRecoveryInstances",
      "drs:DescribeRecoverySnapshots",
      "drs:DescribeReplicationConfigurationTemplates",
      "drs:DescribeSourceServers",
      "drs:GetFailbackReplicationConfiguration",
      "drs:GetLaunchConfiguration",
      "drs:GetReplicationConfiguration",
      "drs:ListExtensibleSourceServers",
      "drs:ListStagingAccounts",
      "drs:ListTagsForResource"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:DescribeInstances",
      "ec2:DescribeLaunchTemplateVersions",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeSubnets"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"iam:ListRoles",
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-05-29T08:27:37+00:00"
 },
 "AWSElasticDisasterRecoveryRecoveryInstancePolicy":{
  "CreateDate":"2021-11-17T10:20:43+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "drs:SendAgentMetricsForDrs",
      "drs:SendAgentLogsForDrs",
      "drs:UpdateAgentSourcePropertiesForDrs",
      "drs:UpdateAgentReplicationInfoForDrs",
      "drs:UpdateAgentConversionInfoForDrs",
      "drs:GetAgentCommandForDrs",
      "drs:GetAgentConfirmedResumeInfoForDrs",
      "drs:GetAgentRuntimeConfigurationForDrs",
      "drs:UpdateAgentBacklogForDrs",
      "drs:GetAgentReplicationInfoForDrs",
      "drs:UpdateReplicationCertificateForDrs",
      "drs:NotifyReplicationServerAuthenticationForDrs"
     ],
     "Condition":{
      "StringEquals":{
       "drs:EC2InstanceARN":"${ec2:SourceInstanceARN}"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:drs:*:*:recovery-instance/*"
    },
    {
     "Action":[
      "drs:DescribeRecoveryInstances"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:DescribeInstanceTypes"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-11-17T10:20:43+00:00"
 },
 "AWSElasticDisasterRecoveryReplicationServerPolicy":{
  "CreateDate":"2021-11-17T13:34:00+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "drs:SendClientMetricsForDrs",
      "drs:SendClientLogsForDrs"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "drs:GetChannelCommandsForDrs",
      "drs:SendChannelCommandResultForDrs"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "drs:GetAgentSnapshotCreditsForDrs",
      "drs:DescribeReplicationServerAssociationsForDrs",
      "drs:DescribeSnapshotRequestsForDrs",
      "drs:BatchDeleteSnapshotRequestForDrs",
      "drs:NotifyAgentAuthenticationForDrs",
      "drs:BatchCreateVolumeSnapshotGroupForDrs",
      "drs:UpdateAgentReplicationProcessStateForDrs",
      "drs:NotifyAgentReplicationProgressForDrs",
      "drs:NotifyAgentConnectedForDrs",
      "drs:NotifyAgentDisconnectedForDrs"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:DescribeInstances",
      "ec2:DescribeSnapshots"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:CreateSnapshot"
     ],
     "Condition":{
      "Null":{
       "aws:ResourceTag/AWSElasticDisasterRecoveryManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:volume/*"
    },
    {
     "Action":[
      "ec2:CreateSnapshot"
     ],
     "Condition":{
      "Null":{
       "aws:RequestTag/AWSElasticDisasterRecoveryManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:snapshot/*"
    },
    {
     "Action":"ec2:CreateTags",
     "Condition":{
      "StringEquals":{
       "ec2:CreateAction":"CreateSnapshot"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-11-17T13:34:00+00:00"
 },
 "AWSElasticDisasterRecoveryServiceRolePolicy":{
  "CreateDate":"2021-11-17T10:56:17+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "drs:ListTagsForResource"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "drs:CreateRecoveryInstanceForDrs",
      "drs:TagResource"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:drs:*:*:recovery-instance/*"
    },
    {
     "Action":"iam:GetInstanceProfile",
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"kms:ListRetirableGrants",
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:DescribeAccountAttributes",
      "ec2:DescribeAvailabilityZones",
      "ec2:DescribeImages",
      "ec2:DescribeInstances",
      "ec2:DescribeInstanceTypes",
      "ec2:DescribeInstanceAttribute",
      "ec2:DescribeInstanceStatus",
      "ec2:DescribeLaunchTemplateVersions",
      "ec2:DescribeLaunchTemplates",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeSnapshots",
      "ec2:DescribeSubnets",
      "ec2:DescribeVolumes",
      "ec2:GetEbsDefaultKmsKeyId",
      "ec2:GetEbsEncryptionByDefault"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:RegisterImage"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:DeregisterImage"
     ],
     "Condition":{
      "Null":{
       "aws:ResourceTag/AWSElasticDisasterRecoveryManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:DeleteSnapshot"
     ],
     "Condition":{
      "Null":{
       "aws:ResourceTag/AWSElasticDisasterRecoveryManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:snapshot/*"
    },
    {
     "Action":[
      "ec2:CreateLaunchTemplateVersion",
      "ec2:ModifyLaunchTemplate",
      "ec2:DeleteLaunchTemplate",
      "ec2:DeleteLaunchTemplateVersions"
     ],
     "Condition":{
      "Null":{
       "aws:ResourceTag/AWSElasticDisasterRecoveryManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:launch-template/*"
    },
    {
     "Action":[
      "ec2:DeleteVolume"
     ],
     "Condition":{
      "Null":{
       "aws:ResourceTag/AWSElasticDisasterRecoveryManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:volume/*"
    },
    {
     "Action":[
      "ec2:StartInstances",
      "ec2:StopInstances",
      "ec2:TerminateInstances",
      "ec2:ModifyInstanceAttribute",
      "ec2:GetConsoleOutput",
      "ec2:GetConsoleScreenshot"
     ],
     "Condition":{
      "Null":{
       "aws:ResourceTag/AWSElasticDisasterRecoveryManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:instance/*"
    },
    {
     "Action":[
      "ec2:RevokeSecurityGroupEgress",
      "ec2:AuthorizeSecurityGroupIngress",
      "ec2:AuthorizeSecurityGroupEgress"
     ],
     "Condition":{
      "Null":{
       "aws:ResourceTag/AWSElasticDisasterRecoveryManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:security-group/*"
    },
    {
     "Action":[
      "ec2:CreateVolume"
     ],
     "Condition":{
      "Null":{
       "aws:RequestTag/AWSElasticDisasterRecoveryManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:volume/*"
    },
    {
     "Action":[
      "ec2:CreateSecurityGroup"
     ],
     "Condition":{
      "Null":{
       "aws:RequestTag/AWSElasticDisasterRecoveryManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:security-group/*"
    },
    {
     "Action":[
      "ec2:CreateSecurityGroup"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:vpc/*"
    },
    {
     "Action":[
      "ec2:CreateLaunchTemplate"
     ],
     "Condition":{
      "Null":{
       "aws:RequestTag/AWSElasticDisasterRecoveryManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:launch-template/*"
    },
    {
     "Action":[
      "ec2:CreateSnapshot"
     ],
     "Condition":{
      "Null":{
       "aws:ResourceTag/AWSElasticDisasterRecoveryManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:volume/*"
    },
    {
     "Action":[
      "ec2:CreateSnapshot"
     ],
     "Condition":{
      "Null":{
       "aws:RequestTag/AWSElasticDisasterRecoveryManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:snapshot/*"
    },
    {
     "Action":[
      "ec2:DetachVolume",
      "ec2:AttachVolume"
     ],
     "Condition":{
      "Null":{
       "aws:ResourceTag/AWSElasticDisasterRecoveryManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:instance/*"
    },
    {
     "Action":[
      "ec2:AttachVolume"
     ],
     "Condition":{
      "Null":{
       "aws:ResourceTag/AWSElasticDisasterRecoveryManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:volume/*"
    },
    {
     "Action":[
      "ec2:DetachVolume"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:volume/*"
    },
    {
     "Action":[
      "ec2:RunInstances"
     ],
     "Condition":{
      "Null":{
       "aws:RequestTag/AWSElasticDisasterRecoveryManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:instance/*"
    },
    {
     "Action":[
      "ec2:RunInstances"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:security-group/*",
      "arn:aws:ec2:*:*:volume/*",
      "arn:aws:ec2:*:*:subnet/*",
      "arn:aws:ec2:*:*:image/*",
      "arn:aws:ec2:*:*:network-interface/*",
      "arn:aws:ec2:*:*:launch-template/*"
     ]
    },
    {
     "Action":"iam:PassRole",
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":"ec2.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/service-role/AWSElasticDisasterRecoveryReplicationServerRole",
      "arn:aws:iam::*:role/service-role/AWSElasticDisasterRecoveryConversionServerRole",
      "arn:aws:iam::*:role/service-role/AWSElasticDisasterRecoveryRecoveryInstanceRole"
     ]
    },
    {
     "Action":"ec2:CreateTags",
     "Condition":{
      "StringEquals":{
       "ec2:CreateAction":[
        "CreateLaunchTemplate",
        "CreateSecurityGroup",
        "CreateVolume",
        "CreateSnapshot",
        "RunInstances"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:launch-template/*",
      "arn:aws:ec2:*:*:security-group/*",
      "arn:aws:ec2:*:*:volume/*",
      "arn:aws:ec2:*:*:snapshot/*",
      "arn:aws:ec2:*:*:instance/*"
     ]
    },
    {
     "Action":"ec2:CreateTags",
     "Condition":{
      "Null":{
       "aws:RequestTag/AWSElasticDisasterRecoveryManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:image/*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-11-17T10:56:17+00:00"
 },
 "AWSElasticDisasterRecoveryStagingAccountPolicy":{
  "CreateDate":"2022-05-26T09:49:18+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "drs:DescribeSourceServers",
      "drs:DescribeRecoverySnapshots",
      "drs:CreateConvertedSnapshotForDrs",
      "drs:GetReplicationConfiguration",
      "drs:DescribeJobs",
      "drs:DescribeJobLogItems"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:ModifySnapshotAttribute"
     ],
     "Condition":{
      "Null":{
       "aws:ResourceTag/AWSElasticDisasterRecoveryManaged":"false"
      },
      "StringEquals":{
       "ec2:Add/userId":"${aws:SourceIdentity}"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:snapshot/*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-05-26T09:49:18+00:00"
 },
 "AWSElasticLoadBalancingClassicServiceRolePolicy":{
  "CreateDate":"2017-09-19T22:36:18+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:DescribeAddresses",
      "ec2:DescribeInstances",
      "ec2:DescribeSubnets",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeVpcs",
      "ec2:DescribeInternetGateways",
      "ec2:DescribeAccountAttributes",
      "ec2:DescribeClassicLinkInstances",
      "ec2:DescribeVpcClassicLink",
      "ec2:CreateSecurityGroup",
      "ec2:CreateNetworkInterface",
      "ec2:DeleteNetworkInterface",
      "ec2:ModifyNetworkInterfaceAttribute",
      "ec2:AuthorizeSecurityGroupIngress",
      "ec2:AssociateAddress",
      "ec2:DisassociateAddress",
      "ec2:AttachNetworkInterface",
      "ec2:DetachNetworkInterface",
      "ec2:AssignPrivateIpAddresses",
      "ec2:AssignIpv6Addresses",
      "ec2:UnassignIpv6Addresses"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-10-07T23:04:27+00:00"
 },
 "AWSElasticLoadBalancingServiceRolePolicy":{
  "CreateDate":"2017-09-19T22:19:04+00:00",
  "DefaultVersionId":"v7",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:DescribeAddresses",
      "ec2:DescribeCoipPools",
      "ec2:DescribeInstances",
      "ec2:DescribeNetworkInterfaces",
      "ec2:DescribeSubnets",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeVpcs",
      "ec2:DescribeInternetGateways",
      "ec2:DescribeAccountAttributes",
      "ec2:DescribeClassicLinkInstances",
      "ec2:DescribeVpcClassicLink",
      "ec2:CreateSecurityGroup",
      "ec2:CreateNetworkInterface",
      "ec2:DeleteNetworkInterface",
      "ec2:GetCoipPoolUsage",
      "ec2:ModifyNetworkInterfaceAttribute",
      "ec2:AllocateAddress",
      "ec2:AuthorizeSecurityGroupIngress",
      "ec2:AssociateAddress",
      "ec2:DisassociateAddress",
      "ec2:AttachNetworkInterface",
      "ec2:DetachNetworkInterface",
      "ec2:AssignPrivateIpAddresses",
      "ec2:AssignIpv6Addresses",
      "ec2:ReleaseAddress",
      "ec2:UnassignIpv6Addresses",
      "ec2:DescribeVpcPeeringConnections",
      "logs:CreateLogDelivery",
      "logs:GetLogDelivery",
      "logs:UpdateLogDelivery",
      "logs:DeleteLogDelivery",
      "logs:ListLogDeliveries",
      "outposts:GetOutpostInstanceTypes"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-08-26T19:01:48+00:00"
 },
 "AWSElementalMediaConvertFullAccess":{
  "CreateDate":"2018-06-25T19:25:35+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "mediaconvert:*",
      "s3:ListAllMyBuckets",
      "s3:ListBucket"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringLike":{
       "iam:PassedToService":[
        "mediaconvert.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-06-10T22:52:25+00:00"
 },
 "AWSElementalMediaConvertReadOnly":{
  "CreateDate":"2018-06-25T19:25:14+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "mediaconvert:Get*",
      "mediaconvert:List*",
      "mediaconvert:DescribeEndpoints",
      "s3:ListAllMyBuckets",
      "s3:ListBucket"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-06-10T22:52:18+00:00"
 },
 "AWSElementalMediaLiveFullAccess":{
  "CreateDate":"2020-07-08T17:07:14+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":{
    "Action":"medialive:*",
    "Effect":"Allow",
    "Resource":"*"
   },
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-07-08T17:07:14+00:00"
 },
 "AWSElementalMediaLiveReadOnly":{
  "CreateDate":"2020-07-08T16:38:07+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":{
    "Action":[
     "medialive:List*",
     "medialive:Describe*"
    ],
    "Effect":"Allow",
    "Resource":"*"
   },
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-07-08T16:38:07+00:00"
 },
 "AWSElementalMediaPackageFullAccess":{
  "CreateDate":"2017-12-29T23:39:52+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":{
    "Action":"mediapackage:*",
    "Effect":"Allow",
    "Resource":"*"
   },
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2017-12-29T23:39:52+00:00"
 },
 "AWSElementalMediaPackageReadOnly":{
  "CreateDate":"2017-12-30T00:04:29+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":{
    "Action":[
     "mediapackage:List*",
     "mediapackage:Describe*"
    ],
    "Effect":"Allow",
    "Resource":"*"
   },
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2017-12-30T00:04:29+00:00"
 },
 "AWSElementalMediaStoreFullAccess":{
  "CreateDate":"2018-03-05T23:15:31+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "mediastore:*"
     ],
     "Condition":{
      "Bool":{
       "aws:SecureTransport":"true"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2018-03-05T23:15:31+00:00"
 },
 "AWSElementalMediaStoreReadOnly":{
  "CreateDate":"2018-03-08T19:48:22+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "mediastore:Get*",
      "mediastore:List*",
      "mediastore:Describe*"
     ],
     "Condition":{
      "Bool":{
       "aws:SecureTransport":"true"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2018-03-08T19:48:22+00:00"
 },
 "AWSElementalMediaTailorFullAccess":{
  "CreateDate":"2021-11-23T00:04:39+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":{
    "Action":"mediatailor:*",
    "Effect":"Allow",
    "Resource":"*"
   },
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-11-23T00:04:39+00:00"
 },
 "AWSElementalMediaTailorReadOnly":{
  "CreateDate":"2021-11-23T00:05:01+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":{
    "Action":[
     "mediatailor:List*",
     "mediatailor:Describe*",
     "mediatailor:Get*"
    ],
    "Effect":"Allow",
    "Resource":"*"
   },
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-11-23T00:05:01+00:00"
 },
 "AWSEnhancedClassicNetworkingMangementPolicy":{
  "CreateDate":"2017-09-20T17:29:09+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:DescribeInstances",
      "ec2:DescribeSecurityGroups"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2017-09-20T17:29:09+00:00"
 },
 "AWSFMAdminFullAccess":{
  "CreateDate":"2018-05-09T18:06:18+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "fms:*",
      "waf:*",
      "waf-regional:*",
      "elasticloadbalancing:SetWebACL",
      "organizations:DescribeOrganization"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2018-05-09T18:06:18+00:00"
 },
 "AWSFMAdminReadOnlyAccess":{
  "CreateDate":"2018-05-09T20:07:39+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "fms:Get*",
      "fms:List*",
      "waf:Get*",
      "waf:List*",
      "waf-regional:Get*",
      "waf-regional:List*",
      "organizations:DescribeOrganization"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2018-05-09T20:07:39+00:00"
 },
 "AWSFMMemberReadOnlyAccess":{
  "CreateDate":"2018-05-09T21:05:29+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "fms:GetAdminAccount",
      "waf:Get*",
      "waf:List*",
      "waf-regional:Get*",
      "waf-regional:List*",
      "organizations:DescribeOrganization"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2018-05-09T21:05:29+00:00"
 },
 "AWSForWordPressPluginPolicy":{
  "CreateDate":"2019-10-30T00:27:46+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "polly:SynthesizeSpeech",
      "polly:DescribeVoices",
      "translate:TranslateText"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"Permissions1"
    },
    {
     "Action":[
      "s3:ListBucket",
      "s3:GetBucketAcl",
      "s3:GetBucketPolicy",
      "s3:PutObject",
      "s3:DeleteObject",
      "s3:CreateBucket",
      "s3:PutObjectAcl"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::audio_for_wordpress*",
      "arn:aws:s3:::audio-for-wordpress*"
     ],
     "Sid":"Permissions2"
    },
    {
     "Action":[
      "acm:AddTagsToCertificate",
      "acm:DescribeCertificate",
      "acm:RequestCertificate",
      "cloudformation:CreateStack",
      "cloudfront:ListDistributions"
     ],
     "Condition":{
      "StringEquals":{
       "aws:RequestedRegion":"us-east-1"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"Permissions3"
    },
    {
     "Action":[
      "acm:DeleteCertificate",
      "cloudformation:DeleteStack",
      "cloudformation:DescribeStackEvents",
      "cloudformation:DescribeStackResources",
      "cloudformation:UpdateStack",
      "cloudfront:CreateDistribution",
      "cloudfront:CreateInvalidation",
      "cloudfront:DeleteDistribution",
      "cloudfront:GetDistribution",
      "cloudfront:GetInvalidation",
      "cloudfront:TagResource",
      "cloudfront:UpdateDistribution"
     ],
     "Condition":{
      "StringEquals":{
       "aws:ResourceTag/createdBy":"AWSForWordPressPlugin"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"Permissions4"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-01-20T23:20:47+00:00"
 },
 "AWSGlobalAcceleratorSLRPolicy":{
  "CreateDate":"2019-04-05T19:39:13+00:00",
  "DefaultVersionId":"v6",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:CreateNetworkInterface",
      "ec2:DescribeNetworkInterfaces",
      "ec2:DescribeInstances",
      "ec2:DescribeInternetGateways",
      "ec2:DescribeSubnets",
      "ec2:DescribeRegions",
      "ec2:ModifyNetworkInterfaceAttribute",
      "ec2:DeleteNetworkInterface"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:DeleteSecurityGroup",
      "ec2:AssignIpv6Addresses",
      "ec2:UnassignIpv6Addresses"
     ],
     "Condition":{
      "StringEquals":{
       "ec2:ResourceTag/AWSServiceName":"GlobalAccelerator"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:CreateSecurityGroup",
      "ec2:DescribeSecurityGroups"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"elasticloadbalancing:DescribeLoadBalancers",
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"ec2:CreateTags",
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:security-group/*",
      "arn:aws:ec2:*:*:network-interface/*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-11-02T18:33:56+00:00"
 },
 "AWSGlueConsoleFullAccess":{
  "CreateDate":"2017-08-14T13:37:39+00:00",
  "DefaultVersionId":"v12",
  "Document":{
   "Statement":[
    {
     "Action":[
      "glue:*",
      "redshift:DescribeClusters",
      "redshift:DescribeClusterSubnetGroups",
      "iam:ListRoles",
      "iam:ListUsers",
      "iam:ListGroups",
      "iam:ListRolePolicies",
      "iam:GetRole",
      "iam:GetRolePolicy",
      "iam:ListAttachedRolePolicies",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeSubnets",
      "ec2:DescribeVpcs",
      "ec2:DescribeVpcEndpoints",
      "ec2:DescribeRouteTables",
      "ec2:DescribeVpcAttribute",
      "ec2:DescribeKeyPairs",
      "ec2:DescribeInstances",
      "ec2:DescribeImages",
      "rds:DescribeDBInstances",
      "rds:DescribeDBClusters",
      "rds:DescribeDBSubnetGroups",
      "s3:ListAllMyBuckets",
      "s3:ListBucket",
      "s3:GetBucketAcl",
      "s3:GetBucketLocation",
      "cloudformation:DescribeStacks",
      "cloudformation:GetTemplateSummary",
      "dynamodb:ListTables",
      "kms:ListAliases",
      "kms:DescribeKey",
      "cloudwatch:GetMetricData",
      "cloudwatch:ListDashboards"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "s3:GetObject",
      "s3:PutObject"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::aws-glue-*/*",
      "arn:aws:s3:::*/*aws-glue-*/*",
      "arn:aws:s3:::aws-glue-*"
     ]
    },
    {
     "Action":[
      "tag:GetResources"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "s3:CreateBucket"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::aws-glue-*"
     ]
    },
    {
     "Action":[
      "logs:GetLogEvents"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:logs:*:*:/aws-glue/*"
     ]
    },
    {
     "Action":[
      "cloudformation:CreateStack",
      "cloudformation:DeleteStack"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:cloudformation:*:*:stack/aws-glue*/*"
    },
    {
     "Action":[
      "ec2:RunInstances"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:instance/*",
      "arn:aws:ec2:*:*:key-pair/*",
      "arn:aws:ec2:*:*:image/*",
      "arn:aws:ec2:*:*:security-group/*",
      "arn:aws:ec2:*:*:network-interface/*",
      "arn:aws:ec2:*:*:subnet/*",
      "arn:aws:ec2:*:*:volume/*"
     ]
    },
    {
     "Action":[
      "ec2:TerminateInstances",
      "ec2:CreateTags",
      "ec2:DeleteTags"
     ],
     "Condition":{
      "StringEquals":{
       "ec2:ResourceTag/aws:cloudformation:logical-id":"ZeppelinInstance"
      },
      "StringLike":{
       "ec2:ResourceTag/aws:cloudformation:stack-id":"arn:aws:cloudformation:*:*:stack/aws-glue-*/*"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:instance/*"
     ]
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringLike":{
       "iam:PassedToService":[
        "glue.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/AWSGlueServiceRole*"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringLike":{
       "iam:PassedToService":[
        "ec2.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/AWSGlueServiceNotebookRole*"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringLike":{
       "iam:PassedToService":[
        "glue.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/service-role/AWSGlueServiceRole*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-02-11T19:49:01+00:00"
 },
 "AWSGlueConsoleSageMakerNotebookFullAccess":{
  "CreateDate":"2018-10-05T17:52:35+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "glue:*",
      "redshift:DescribeClusters",
      "redshift:DescribeClusterSubnetGroups",
      "iam:ListRoles",
      "iam:ListRolePolicies",
      "iam:GetRole",
      "iam:GetRolePolicy",
      "iam:ListAttachedRolePolicies",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeSubnets",
      "ec2:DescribeVpcs",
      "ec2:DescribeVpcEndpoints",
      "ec2:DescribeRouteTables",
      "ec2:DescribeVpcAttribute",
      "ec2:DescribeKeyPairs",
      "ec2:DescribeInstances",
      "ec2:DescribeImages",
      "ec2:CreateNetworkInterface",
      "ec2:AttachNetworkInterface",
      "ec2:ModifyNetworkInterfaceAttribute",
      "ec2:DeleteNetworkInterface",
      "ec2:DescribeAvailabilityZones",
      "ec2:DescribeInternetGateways",
      "ec2:DescribeNetworkInterfaces",
      "rds:DescribeDBInstances",
      "s3:ListAllMyBuckets",
      "s3:ListBucket",
      "s3:GetBucketAcl",
      "s3:GetBucketLocation",
      "cloudformation:DescribeStacks",
      "cloudformation:GetTemplateSummary",
      "dynamodb:ListTables",
      "kms:ListAliases",
      "kms:DescribeKey",
      "sagemaker:ListNotebookInstances",
      "cloudformation:ListStacks",
      "cloudwatch:GetMetricData",
      "cloudwatch:ListDashboards"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "s3:GetObject",
      "s3:PutObject"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::*/*aws-glue-*/*",
      "arn:aws:s3:::aws-glue-*"
     ]
    },
    {
     "Action":[
      "s3:CreateBucket"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::aws-glue-*"
     ]
    },
    {
     "Action":[
      "logs:GetLogEvents"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:logs:*:*:/aws-glue/*"
     ]
    },
    {
     "Action":[
      "cloudformation:CreateStack",
      "cloudformation:DeleteStack"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:cloudformation:*:*:stack/aws-glue*/*"
    },
    {
     "Action":[
      "sagemaker:CreatePresignedNotebookInstanceUrl",
      "sagemaker:CreateNotebookInstance",
      "sagemaker:DeleteNotebookInstance",
      "sagemaker:DescribeNotebookInstance",
      "sagemaker:StartNotebookInstance",
      "sagemaker:StopNotebookInstance",
      "sagemaker:UpdateNotebookInstance",
      "sagemaker:ListTags"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:sagemaker:*:*:notebook-instance/aws-glue-*"
    },
    {
     "Action":[
      "sagemaker:DescribeNotebookInstanceLifecycleConfig",
      "sagemaker:CreateNotebookInstanceLifecycleConfig",
      "sagemaker:DeleteNotebookInstanceLifecycleConfig",
      "sagemaker:ListNotebookInstanceLifecycleConfigs"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:sagemaker:*:*:notebook-instance-lifecycle-config/aws-glue-*"
    },
    {
     "Action":[
      "ec2:RunInstances"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:instance/*",
      "arn:aws:ec2:*:*:key-pair/*",
      "arn:aws:ec2:*:*:image/*",
      "arn:aws:ec2:*:*:security-group/*",
      "arn:aws:ec2:*:*:network-interface/*",
      "arn:aws:ec2:*:*:subnet/*",
      "arn:aws:ec2:*:*:volume/*"
     ]
    },
    {
     "Action":[
      "ec2:TerminateInstances",
      "ec2:CreateTags",
      "ec2:DeleteTags"
     ],
     "Condition":{
      "StringEquals":{
       "ec2:ResourceTag/aws:cloudformation:logical-id":"ZeppelinInstance"
      },
      "StringLike":{
       "ec2:ResourceTag/aws:cloudformation:stack-id":"arn:aws:cloudformation:*:*:stack/aws-glue-*/*"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:instance/*"
     ]
    },
    {
     "Action":[
      "tag:GetResources"
     ],
     "Condition":{
      "ForAllValues:StringLike":{
       "aws:TagKeys":[
        "aws-glue-*"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringLike":{
       "iam:PassedToService":[
        "glue.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/AWSGlueServiceRole*"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringLike":{
       "iam:PassedToService":[
        "ec2.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/AWSGlueServiceNotebookRole*"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringLike":{
       "iam:PassedToService":[
        "sagemaker.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/AWSGlueServiceSageMakerNotebookRole*"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringLike":{
       "iam:PassedToService":[
        "glue.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/service-role/AWSGlueServiceRole*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-07-15T15:24:19+00:00"
 },
 "AWSGlueDataBrewServiceRole":{
  "CreateDate":"2020-12-04T21:26:50+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "glue:GetDatabases",
      "glue:GetPartitions",
      "glue:GetTable",
      "glue:GetTables",
      "glue:GetConnection"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "glue:BatchGetCustomEntityTypes"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "s3:ListBucket",
      "s3:GetObject"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::databrew-public-datasets-*"
     ]
    },
    {
     "Action":[
      "ec2:DescribeVpcEndpoints",
      "ec2:DescribeRouteTables",
      "ec2:DescribeNetworkInterfaces",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeSubnets",
      "ec2:DescribeVpcAttribute",
      "ec2:CreateNetworkInterface"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":"ec2:DeleteNetworkInterface",
     "Condition":{
      "StringLike":{
       "aws:ResourceTag/aws-glue-service-resource":"*"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "ec2:CreateTags",
      "ec2:DeleteTags"
     ],
     "Condition":{
      "ForAllValues:StringEquals":{
       "aws:TagKeys":[
        "aws-glue-service-resource"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:network-interface/*",
      "arn:aws:ec2:*:*:security-group/*"
     ]
    },
    {
     "Action":[
      "logs:CreateLogGroup",
      "logs:CreateLogStream",
      "logs:PutLogEvents"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:logs:*:*:log-group:/aws-glue-databrew/*"
     ]
    },
    {
     "Action":[
      "lakeformation:GetDataAccess"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "secretsmanager:GetSecretValue"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:secretsmanager:*:*:secret:databrew!default-*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-05-09T23:06:36+00:00"
 },
 "AWSGlueSchemaRegistryFullAccess":{
  "CreateDate":"2020-11-20T00:19:00+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "glue:CreateRegistry",
      "glue:UpdateRegistry",
      "glue:DeleteRegistry",
      "glue:GetRegistry",
      "glue:ListRegistries",
      "glue:CreateSchema",
      "glue:UpdateSchema",
      "glue:DeleteSchema",
      "glue:GetSchema",
      "glue:ListSchemas",
      "glue:RegisterSchemaVersion",
      "glue:DeleteSchemaVersions",
      "glue:GetSchemaByDefinition",
      "glue:GetSchemaVersion",
      "glue:GetSchemaVersionsDiff",
      "glue:ListSchemaVersions",
      "glue:CheckSchemaVersionValidity",
      "glue:PutSchemaVersionMetadata",
      "glue:RemoveSchemaVersionMetadata",
      "glue:QuerySchemaVersionMetadata"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"AWSGlueSchemaRegistryFullAccess"
    },
    {
     "Action":[
      "glue:GetTags",
      "glue:TagResource",
      "glue:UnTagResource"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:glue:*:*:schema/*",
      "arn:aws:glue:*:*:registry/*"
     ],
     "Sid":"AWSGlueSchemaRegistryTagsFullAccess"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-11-20T00:19:00+00:00"
 },
 "AWSGlueSchemaRegistryReadonlyAccess":{
  "CreateDate":"2020-11-20T00:20:06+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "glue:GetRegistry",
      "glue:ListRegistries",
      "glue:GetSchema",
      "glue:ListSchemas",
      "glue:GetSchemaByDefinition",
      "glue:GetSchemaVersion",
      "glue:ListSchemaVersions",
      "glue:GetSchemaVersionsDiff",
      "glue:CheckSchemaVersionValidity",
      "glue:QuerySchemaVersionMetadata",
      "glue:GetTags"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"AWSGlueSchemaRegistryReadonlyAccess"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-11-20T00:20:06+00:00"
 },
 "AWSGlueServiceNotebookRole":{
  "CreateDate":"2017-08-14T13:37:42+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "glue:CreateDatabase",
      "glue:CreatePartition",
      "glue:CreateTable",
      "glue:DeleteDatabase",
      "glue:DeletePartition",
      "glue:DeleteTable",
      "glue:GetDatabase",
      "glue:GetDatabases",
      "glue:GetPartition",
      "glue:GetPartitions",
      "glue:GetTable",
      "glue:GetTableVersions",
      "glue:GetTables",
      "glue:UpdateDatabase",
      "glue:UpdatePartition",
      "glue:UpdateTable",
      "glue:CreateConnection",
      "glue:CreateJob",
      "glue:DeleteConnection",
      "glue:DeleteJob",
      "glue:GetConnection",
      "glue:GetConnections",
      "glue:GetDevEndpoint",
      "glue:GetDevEndpoints",
      "glue:GetJob",
      "glue:GetJobs",
      "glue:UpdateJob",
      "glue:BatchDeleteConnection",
      "glue:UpdateConnection",
      "glue:GetUserDefinedFunction",
      "glue:UpdateUserDefinedFunction",
      "glue:GetUserDefinedFunctions",
      "glue:DeleteUserDefinedFunction",
      "glue:CreateUserDefinedFunction",
      "glue:BatchGetPartition",
      "glue:BatchDeletePartition",
      "glue:BatchCreatePartition",
      "glue:BatchDeleteTable",
      "glue:UpdateDevEndpoint",
      "s3:GetBucketLocation",
      "s3:ListBucket",
      "s3:ListAllMyBuckets",
      "s3:GetBucketAcl"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "s3:GetObject"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::crawler-public*",
      "arn:aws:s3:::aws-glue*"
     ]
    },
    {
     "Action":[
      "s3:PutObject",
      "s3:DeleteObject"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::aws-glue*"
     ]
    },
    {
     "Action":[
      "ec2:CreateTags",
      "ec2:DeleteTags"
     ],
     "Condition":{
      "ForAllValues:StringEquals":{
       "aws:TagKeys":[
        "aws-glue-service-resource"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:network-interface/*",
      "arn:aws:ec2:*:*:security-group/*",
      "arn:aws:ec2:*:*:instance/*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-10-07T18:05:54+00:00"
 },
 "AWSGlueServiceRole":{
  "CreateDate":"2017-08-14T13:37:21+00:00",
  "DefaultVersionId":"v4",
  "Document":{
   "Statement":[
    {
     "Action":[
      "glue:*",
      "s3:GetBucketLocation",
      "s3:ListBucket",
      "s3:ListAllMyBuckets",
      "s3:GetBucketAcl",
      "ec2:DescribeVpcEndpoints",
      "ec2:DescribeRouteTables",
      "ec2:CreateNetworkInterface",
      "ec2:DeleteNetworkInterface",
      "ec2:DescribeNetworkInterfaces",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeSubnets",
      "ec2:DescribeVpcAttribute",
      "iam:ListRolePolicies",
      "iam:GetRole",
      "iam:GetRolePolicy",
      "cloudwatch:PutMetricData"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "s3:CreateBucket"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::aws-glue-*"
     ]
    },
    {
     "Action":[
      "s3:GetObject",
      "s3:PutObject",
      "s3:DeleteObject"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::aws-glue-*/*",
      "arn:aws:s3:::*/*aws-glue-*/*"
     ]
    },
    {
     "Action":[
      "s3:GetObject"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::crawler-public*",
      "arn:aws:s3:::aws-glue-*"
     ]
    },
    {
     "Action":[
      "logs:CreateLogGroup",
      "logs:CreateLogStream",
      "logs:PutLogEvents"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:logs:*:*:/aws-glue/*"
     ]
    },
    {
     "Action":[
      "ec2:CreateTags",
      "ec2:DeleteTags"
     ],
     "Condition":{
      "ForAllValues:StringEquals":{
       "aws:TagKeys":[
        "aws-glue-service-resource"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:network-interface/*",
      "arn:aws:ec2:*:*:security-group/*",
      "arn:aws:ec2:*:*:instance/*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2018-06-25T18:23:09+00:00"
 },
 "AWSGrafanaAccountAdministrator":{
  "CreateDate":"2021-02-23T00:20:38+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iam:ListRoles"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AWSGrafanaOrganizationAdmin"
    },
    {
     "Action":"iam:GetRole",
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/*",
     "Sid":"GrafanaIAMGetRolePermission"
    },
    {
     "Action":[
      "grafana:*"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AWSGrafanaPermissions"
    },
    {
     "Action":"iam:PassRole",
     "Condition":{
      "StringLike":{
       "iam:PassedToService":"grafana.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/*",
     "Sid":"GrafanaIAMPassRolePermission"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-02-15T22:36:18+00:00"
 },
 "AWSGrafanaConsoleReadOnlyAccess":{
  "CreateDate":"2021-02-23T00:10:40+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "grafana:Describe*",
      "grafana:List*"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AWSGrafanaConsoleReadOnlyAccess"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-02-15T22:30:54+00:00"
 },
 "AWSGrafanaWorkspacePermissionManagement":{
  "CreateDate":"2021-02-23T00:15:54+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "grafana:DescribeWorkspace",
      "grafana:DescribeWorkspaceAuthentication",
      "grafana:UpdatePermissions",
      "grafana:ListPermissions",
      "grafana:ListWorkspaces"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:grafana:*:*:/workspaces*",
     "Sid":"AWSGrafanaPermissions"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-09-21T20:30:06+00:00"
 },
 "AWSGreengrassFullAccess":{
  "CreateDate":"2017-05-03T00:47:37+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "greengrass:*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2017-05-03T00:47:37+00:00"
 },
 "AWSGreengrassReadOnlyAccess":{
  "CreateDate":"2018-10-30T16:01:43+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "greengrass:List*",
      "greengrass:Get*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2018-10-30T16:01:43+00:00"
 },
 "AWSGreengrassResourceAccessRolePolicy":{
  "CreateDate":"2017-02-14T21:17:24+00:00",
  "DefaultVersionId":"v5",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iot:DeleteThingShadow",
      "iot:GetThingShadow",
      "iot:UpdateThingShadow"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iot:*:*:thing/GG_*",
      "arn:aws:iot:*:*:thing/*-gcm",
      "arn:aws:iot:*:*:thing/*-gda",
      "arn:aws:iot:*:*:thing/*-gci"
     ],
     "Sid":"AllowGreengrassAccessToShadows"
    },
    {
     "Action":[
      "iot:DescribeThing"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:iot:*:*:thing/*",
     "Sid":"AllowGreengrassToDescribeThings"
    },
    {
     "Action":[
      "iot:DescribeCertificate"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:iot:*:*:cert/*",
     "Sid":"AllowGreengrassToDescribeCertificates"
    },
    {
     "Action":[
      "greengrass:*"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AllowGreengrassToCallGreengrassServices"
    },
    {
     "Action":[
      "lambda:GetFunction",
      "lambda:GetFunctionConfiguration"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AllowGreengrassToGetLambdaFunctions"
    },
    {
     "Action":[
      "secretsmanager:GetSecretValue"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:secretsmanager:*:*:secret:greengrass-*",
     "Sid":"AllowGreengrassToGetGreengrassSecrets"
    },
    {
     "Action":[
      "s3:GetObject"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::*Greengrass*",
      "arn:aws:s3:::*GreenGrass*",
      "arn:aws:s3:::*greengrass*",
      "arn:aws:s3:::*Sagemaker*",
      "arn:aws:s3:::*SageMaker*",
      "arn:aws:s3:::*sagemaker*"
     ],
     "Sid":"AllowGreengrassAccessToS3Objects"
    },
    {
     "Action":[
      "s3:GetBucketLocation"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AllowGreengrassAccessToS3BucketLocation"
    },
    {
     "Action":[
      "sagemaker:DescribeTrainingJob"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:sagemaker:*:*:training-job/*"
     ],
     "Sid":"AllowGreengrassAccessToSageMakerTrainingJobs"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2018-11-14T00:35:02+00:00"
 },
 "AWSHealthFullAccess":{
  "CreateDate":"2016-12-06T12:30:31+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "organizations:EnableAWSServiceAccess",
      "organizations:DisableAWSServiceAccess"
     ],
     "Condition":{
      "StringEquals":{
       "organizations:ServicePrincipal":"health.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "health:*",
      "organizations:ListAccounts",
      "organizations:ListParents",
      "organizations:DescribeAccount",
      "organizations:ListDelegatedAdministrators"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":"health.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-11-16T18:11:34+00:00"
 },
 "AWSIPAMServiceRolePolicy":{
  "CreateDate":"2021-11-30T19:08:11+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:DescribeAddresses",
      "ec2:DescribeByoipCidrs",
      "ec2:DescribeIpv6Pools",
      "ec2:DescribePublicIpv4Pools",
      "ec2:DescribeSubnets",
      "ec2:DescribeVpcs",
      "organizations:DescribeAccount",
      "organizations:DescribeOrganization",
      "organizations:ListAccounts",
      "organizations:ListDelegatedAdministrators"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"cloudwatch:PutMetricData",
     "Condition":{
      "StringEquals":{
       "cloudwatch:namespace":"AWS/IPAM"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-11-30T19:08:11+00:00"
 },
 "AWSIQContractServiceRolePolicy":{
  "CreateDate":"2019-08-22T19:28:39+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "aws-marketplace:Subscribe"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-08-22T19:28:39+00:00"
 },
 "AWSIQFullAccess":{
  "CreateDate":"2019-04-04T23:13:42+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iq:*",
      "iq-permission:*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":[
        "permission.iq.amazonaws.com",
        "contract.iq.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-09-25T20:22:34+00:00"
 },
 "AWSIQPermissionServiceRolePolicy":{
  "CreateDate":"2019-08-22T19:36:29+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iam:DeleteRole",
      "iam:ListAttachedRolePolicies"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/AWSIQPermission-*"
    },
    {
     "Action":[
      "iam:AttachRolePolicy"
     ],
     "Condition":{
      "ArnEquals":{
       "iam:PolicyARN":"arn:aws:iam::aws:policy/AWSDenyAll"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/AWSIQPermission-*"
    },
    {
     "Action":[
      "iam:DetachRolePolicy"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/AWSIQPermission-*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-08-22T19:36:29+00:00"
 },
 "AWSIdentitySyncFullAccess":{
  "CreateDate":"2022-03-23T23:29:33+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ds:AuthorizeApplication",
      "ds:UnauthorizeApplication"
     ],
     "Effect":"Allow",
     "Resource":"arn:*:ds:*:*:*/*"
    },
    {
     "Action":[
      "identity-sync:DeleteSyncProfile",
      "identity-sync:CreateSyncProfile",
      "identity-sync:GetSyncProfile",
      "identity-sync:StartSync",
      "identity-sync:StopSync",
      "identity-sync:CreateSyncFilter",
      "identity-sync:DeleteSyncFilter",
      "identity-sync:ListSyncFilters",
      "identity-sync:CreateSyncTarget",
      "identity-sync:DeleteSyncTarget",
      "identity-sync:GetSyncTarget",
      "identity-sync:UpdateSyncTarget"
     ],
     "Effect":"Allow",
     "Resource":"arn:*:identity-sync:*:*:*/*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-03-23T23:29:33+00:00"
 },
 "AWSIdentitySyncReadOnlyAccess":{
  "CreateDate":"2022-03-23T23:29:52+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "identity-sync:GetSyncProfile",
      "identity-sync:ListSyncFilters",
      "identity-sync:GetSyncTarget"
     ],
     "Effect":"Allow",
     "Resource":"arn:*:identity-sync:*:*:*/*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-03-23T23:29:52+00:00"
 },
 "AWSImageBuilderFullAccess":{
  "CreateDate":"2019-12-20T18:25:12+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "imagebuilder:*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "sns:ListTopics"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "sns:Publish"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:sns:*:*:*imagebuilder*"
    },
    {
     "Action":[
      "license-manager:ListLicenseConfigurations",
      "license-manager:ListLicenseSpecificationsForResource"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "iam:GetRole"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/aws-service-role/imagebuilder.amazonaws.com/AWSServiceRoleForImageBuilder"
    },
    {
     "Action":[
      "iam:GetInstanceProfile"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:instance-profile/*imagebuilder*"
    },
    {
     "Action":[
      "iam:ListInstanceProfiles",
      "iam:ListRoles"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"iam:PassRole",
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":"ec2.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:instance-profile/*imagebuilder*",
      "arn:aws:iam::*:role/*imagebuilder*"
     ]
    },
    {
     "Action":[
      "s3:ListAllMyBuckets",
      "s3:GetBucketLocation"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "s3:ListBucket"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:s3::*:*imagebuilder*"
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringLike":{
       "iam:AWSServiceName":"imagebuilder.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/aws-service-role/imagebuilder.amazonaws.com/AWSServiceRoleForImageBuilder"
    },
    {
     "Action":[
      "ec2:DescribeImages",
      "ec2:DescribeSnapshots",
      "ec2:DescribeVpcs",
      "ec2:DescribeRegions",
      "ec2:DescribeVolumes",
      "ec2:DescribeSubnets",
      "ec2:DescribeKeyPairs",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeInstanceTypeOfferings",
      "ec2:DescribeLaunchTemplates"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-04-13T17:33:42+00:00"
 },
 "AWSImageBuilderReadOnlyAccess":{
  "CreateDate":"2019-12-19T22:29:23+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "imagebuilder:Get*",
      "imagebuilder:List*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "iam:GetRole"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/aws-service-role/imagebuilder.amazonaws.com/AWSServiceRoleForImageBuilder"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-12-19T22:29:23+00:00"
 },
 "AWSImportExportFullAccess":{
  "CreateDate":"2015-02-06T18:40:43+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "importexport:*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2015-02-06T18:40:43+00:00"
 },
 "AWSImportExportReadOnlyAccess":{
  "CreateDate":"2015-02-06T18:40:42+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "importexport:ListJobs",
      "importexport:GetStatus"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2015-02-06T18:40:42+00:00"
 },
 "AWSIncidentManagerResolverAccess":{
  "CreateDate":"2021-05-10T06:12:34+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ssm-incidents:StartIncident"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"StartIncidentPermissions"
    },
    {
     "Action":[
      "ssm-incidents:ListResponsePlans",
      "ssm-incidents:GetResponsePlan"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ResponsePlanReadOnlyPermissions"
    },
    {
     "Action":[
      "ssm-incidents:ListIncidentRecords",
      "ssm-incidents:GetIncidentRecord",
      "ssm-incidents:UpdateIncidentRecord",
      "ssm-incidents:ListTimelineEvents",
      "ssm-incidents:CreateTimelineEvent",
      "ssm-incidents:GetTimelineEvent",
      "ssm-incidents:UpdateTimelineEvent",
      "ssm-incidents:DeleteTimelineEvent",
      "ssm-incidents:ListRelatedItems",
      "ssm-incidents:UpdateRelatedItems"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"IncidentRecordResolverPermissions"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-05-10T06:12:34+00:00"
 },
 "AWSIncidentManagerServiceRolePolicy":{
  "CreateDate":"2021-05-10T03:34:45+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ssm-incidents:ListIncidentRecords",
      "ssm-incidents:CreateTimelineEvent"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"UpdateIncidentRecordPermissions"
    },
    {
     "Action":[
      "ssm:CreateOpsItem",
      "ssm:AssociateOpsItemRelatedItem"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"RelatedOpsItemPermissions"
    },
    {
     "Action":"ssm-contacts:StartEngagement",
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"IncidentEngagementPermissions"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-05-10T03:34:45+00:00"
 },
 "AWSIoT1ClickFullAccess":{
  "CreateDate":"2018-05-11T22:10:14+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iot1click:*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2018-05-11T22:10:14+00:00"
 },
 "AWSIoT1ClickReadOnlyAccess":{
  "CreateDate":"2018-05-11T21:49:24+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iot1click:Describe*",
      "iot1click:Get*",
      "iot1click:List*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2018-05-11T21:49:24+00:00"
 },
 "AWSIoTAnalyticsFullAccess":{
  "CreateDate":"2018-06-18T23:02:45+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iotanalytics:*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2018-06-18T23:02:45+00:00"
 },
 "AWSIoTAnalyticsReadOnlyAccess":{
  "CreateDate":"2018-06-18T21:37:49+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iotanalytics:Describe*",
      "iotanalytics:List*",
      "iotanalytics:Get*",
      "iotanalytics:SampleChannelData"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2018-06-18T21:37:49+00:00"
 },
 "AWSIoTConfigAccess":{
  "CreateDate":"2015-10-27T21:52:07+00:00",
  "DefaultVersionId":"v9",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iot:AcceptCertificateTransfer",
      "iot:AddThingToThingGroup",
      "iot:AssociateTargetsWithJob",
      "iot:AttachPolicy",
      "iot:AttachPrincipalPolicy",
      "iot:AttachThingPrincipal",
      "iot:CancelCertificateTransfer",
      "iot:CancelJob",
      "iot:CancelJobExecution",
      "iot:ClearDefaultAuthorizer",
      "iot:CreateAuthorizer",
      "iot:CreateCertificateFromCsr",
      "iot:CreateJob",
      "iot:CreateKeysAndCertificate",
      "iot:CreateOTAUpdate",
      "iot:CreatePolicy",
      "iot:CreatePolicyVersion",
      "iot:CreateRoleAlias",
      "iot:CreateStream",
      "iot:CreateThing",
      "iot:CreateThingGroup",
      "iot:CreateThingType",
      "iot:CreateTopicRule",
      "iot:DeleteAuthorizer",
      "iot:DeleteCACertificate",
      "iot:DeleteCertificate",
      "iot:DeleteJob",
      "iot:DeleteJobExecution",
      "iot:DeleteOTAUpdate",
      "iot:DeletePolicy",
      "iot:DeletePolicyVersion",
      "iot:DeleteRegistrationCode",
      "iot:DeleteRoleAlias",
      "iot:DeleteStream",
      "iot:DeleteThing",
      "iot:DeleteThingGroup",
      "iot:DeleteThingType",
      "iot:DeleteTopicRule",
      "iot:DeleteV2LoggingLevel",
      "iot:DeprecateThingType",
      "iot:DescribeAuthorizer",
      "iot:DescribeCACertificate",
      "iot:DescribeCertificate",
      "iot:DescribeDefaultAuthorizer",
      "iot:DescribeEndpoint",
      "iot:DescribeEventConfigurations",
      "iot:DescribeIndex",
      "iot:DescribeJob",
      "iot:DescribeJobExecution",
      "iot:DescribeRoleAlias",
      "iot:DescribeStream",
      "iot:DescribeThing",
      "iot:DescribeThingGroup",
      "iot:DescribeThingRegistrationTask",
      "iot:DescribeThingType",
      "iot:DetachPolicy",
      "iot:DetachPrincipalPolicy",
      "iot:DetachThingPrincipal",
      "iot:DisableTopicRule",
      "iot:EnableTopicRule",
      "iot:GetEffectivePolicies",
      "iot:GetIndexingConfiguration",
      "iot:GetJobDocument",
      "iot:GetLoggingOptions",
      "iot:GetOTAUpdate",
      "iot:GetPolicy",
      "iot:GetPolicyVersion",
      "iot:GetRegistrationCode",
      "iot:GetTopicRule",
      "iot:GetV2LoggingOptions",
      "iot:ListAttachedPolicies",
      "iot:ListAuthorizers",
      "iot:ListCACertificates",
      "iot:ListCertificates",
      "iot:ListCertificatesByCA",
      "iot:ListIndices",
      "iot:ListJobExecutionsForJob",
      "iot:ListJobExecutionsForThing",
      "iot:ListJobs",
      "iot:ListOTAUpdates",
      "iot:ListOutgoingCertificates",
      "iot:ListPolicies",
      "iot:ListPolicyPrincipals",
      "iot:ListPolicyVersions",
      "iot:ListPrincipalPolicies",
      "iot:ListPrincipalThings",
      "iot:ListRoleAliases",
      "iot:ListStreams",
      "iot:ListTargetsForPolicy",
      "iot:ListThingGroups",
      "iot:ListThingGroupsForThing",
      "iot:ListThingPrincipals",
      "iot:ListThingRegistrationTaskReports",
      "iot:ListThingRegistrationTasks",
      "iot:ListThings",
      "iot:ListThingsInThingGroup",
      "iot:ListThingTypes",
      "iot:ListTopicRules",
      "iot:ListV2LoggingLevels",
      "iot:RegisterCACertificate",
      "iot:RegisterCertificate",
      "iot:RegisterThing",
      "iot:RejectCertificateTransfer",
      "iot:RemoveThingFromThingGroup",
      "iot:ReplaceTopicRule",
      "iot:SearchIndex",
      "iot:SetDefaultAuthorizer",
      "iot:SetDefaultPolicyVersion",
      "iot:SetLoggingOptions",
      "iot:SetV2LoggingLevel",
      "iot:SetV2LoggingOptions",
      "iot:StartThingRegistrationTask",
      "iot:StopThingRegistrationTask",
      "iot:TestAuthorization",
      "iot:TestInvokeAuthorizer",
      "iot:TransferCertificate",
      "iot:UpdateAuthorizer",
      "iot:UpdateCACertificate",
      "iot:UpdateCertificate",
      "iot:UpdateEventConfigurations",
      "iot:UpdateIndexingConfiguration",
      "iot:UpdateRoleAlias",
      "iot:UpdateStream",
      "iot:UpdateThing",
      "iot:UpdateThingGroup",
      "iot:UpdateThingGroupsForThing",
      "iot:UpdateAccountAuditConfiguration",
      "iot:DescribeAccountAuditConfiguration",
      "iot:DeleteAccountAuditConfiguration",
      "iot:StartOnDemandAuditTask",
      "iot:CancelAuditTask",
      "iot:DescribeAuditTask",
      "iot:ListAuditTasks",
      "iot:CreateScheduledAudit",
      "iot:UpdateScheduledAudit",
      "iot:DeleteScheduledAudit",
      "iot:DescribeScheduledAudit",
      "iot:ListScheduledAudits",
      "iot:ListAuditFindings",
      "iot:CreateSecurityProfile",
      "iot:DescribeSecurityProfile",
      "iot:UpdateSecurityProfile",
      "iot:DeleteSecurityProfile",
      "iot:AttachSecurityProfile",
      "iot:DetachSecurityProfile",
      "iot:ListSecurityProfiles",
      "iot:ListSecurityProfilesForTarget",
      "iot:ListTargetsForSecurityProfile",
      "iot:ListActiveViolations",
      "iot:ListViolationEvents",
      "iot:ValidateSecurityProfileBehaviors"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-09-27T20:48:00+00:00"
 },
 "AWSIoTConfigReadOnlyAccess":{
  "CreateDate":"2015-10-27T21:52:31+00:00",
  "DefaultVersionId":"v8",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iot:DescribeAuthorizer",
      "iot:DescribeCACertificate",
      "iot:DescribeCertificate",
      "iot:DescribeDefaultAuthorizer",
      "iot:DescribeEndpoint",
      "iot:DescribeEventConfigurations",
      "iot:DescribeIndex",
      "iot:DescribeJob",
      "iot:DescribeJobExecution",
      "iot:DescribeRoleAlias",
      "iot:DescribeStream",
      "iot:DescribeThing",
      "iot:DescribeThingGroup",
      "iot:DescribeThingRegistrationTask",
      "iot:DescribeThingType",
      "iot:GetEffectivePolicies",
      "iot:GetIndexingConfiguration",
      "iot:GetJobDocument",
      "iot:GetLoggingOptions",
      "iot:GetOTAUpdate",
      "iot:GetPolicy",
      "iot:GetPolicyVersion",
      "iot:GetRegistrationCode",
      "iot:GetTopicRule",
      "iot:GetV2LoggingOptions",
      "iot:ListAttachedPolicies",
      "iot:ListAuthorizers",
      "iot:ListCACertificates",
      "iot:ListCertificates",
      "iot:ListCertificatesByCA",
      "iot:ListIndices",
      "iot:ListJobExecutionsForJob",
      "iot:ListJobExecutionsForThing",
      "iot:ListJobs",
      "iot:ListOTAUpdates",
      "iot:ListOutgoingCertificates",
      "iot:ListPolicies",
      "iot:ListPolicyPrincipals",
      "iot:ListPolicyVersions",
      "iot:ListPrincipalPolicies",
      "iot:ListPrincipalThings",
      "iot:ListRoleAliases",
      "iot:ListStreams",
      "iot:ListTargetsForPolicy",
      "iot:ListThingGroups",
      "iot:ListThingGroupsForThing",
      "iot:ListThingPrincipals",
      "iot:ListThingRegistrationTaskReports",
      "iot:ListThingRegistrationTasks",
      "iot:ListThings",
      "iot:ListThingsInThingGroup",
      "iot:ListThingTypes",
      "iot:ListTopicRules",
      "iot:ListV2LoggingLevels",
      "iot:SearchIndex",
      "iot:TestAuthorization",
      "iot:TestInvokeAuthorizer",
      "iot:DescribeAccountAuditConfiguration",
      "iot:DescribeAuditTask",
      "iot:ListAuditTasks",
      "iot:DescribeScheduledAudit",
      "iot:ListScheduledAudits",
      "iot:ListAuditFindings",
      "iot:DescribeSecurityProfile",
      "iot:ListSecurityProfiles",
      "iot:ListSecurityProfilesForTarget",
      "iot:ListTargetsForSecurityProfile",
      "iot:ListActiveViolations",
      "iot:ListViolationEvents",
      "iot:ValidateSecurityProfileBehaviors"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-09-27T20:52:40+00:00"
 },
 "AWSIoTDataAccess":{
  "CreateDate":"2015-10-27T21:51:18+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iot:Connect",
      "iot:Publish",
      "iot:Subscribe",
      "iot:Receive",
      "iot:GetThingShadow",
      "iot:UpdateThingShadow",
      "iot:DeleteThingShadow",
      "iot:ListNamedShadowsForThing"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-06-23T21:34:47+00:00"
 },
 "AWSIoTDeviceDefenderAddThingsToThingGroupMitigationAction":{
  "CreateDate":"2019-08-07T17:55:37+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iot:ListPrincipalThings",
      "iot:AddThingToThingGroup"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-08-07T17:55:37+00:00"
 },
 "AWSIoTDeviceDefenderAudit":{
  "CreateDate":"2018-07-18T21:17:40+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iot:GetLoggingOptions",
      "iot:GetV2LoggingOptions",
      "iot:ListCACertificates",
      "iot:ListCertificates",
      "iot:DescribeCACertificate",
      "iot:DescribeCertificate",
      "iot:ListPolicies",
      "iot:GetPolicy",
      "iot:GetEffectivePolicies",
      "iot:ListRoleAliases",
      "iot:DescribeRoleAlias",
      "cognito-identity:GetIdentityPoolRoles",
      "iam:ListRolePolicies",
      "iam:ListAttachedRolePolicies",
      "iam:GetRole",
      "iam:GetPolicy",
      "iam:GetPolicyVersion",
      "iam:GetRolePolicy",
      "iam:GenerateServiceLastAccessedDetails",
      "iam:GetServiceLastAccessedDetails"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-11-25T23:52:43+00:00"
 },
 "AWSIoTDeviceDefenderEnableIoTLoggingMitigationAction":{
  "CreateDate":"2019-08-07T17:04:07+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iot:SetV2LoggingOptions"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":[
        "iot.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-08-07T17:04:07+00:00"
 },
 "AWSIoTDeviceDefenderPublishFindingsToSNSMitigationAction":{
  "CreateDate":"2019-08-07T17:04:37+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "sns:Publish"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-08-07T17:04:37+00:00"
 },
 "AWSIoTDeviceDefenderReplaceDefaultPolicyMitigationAction":{
  "CreateDate":"2019-08-07T17:04:57+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iot:CreatePolicyVersion"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-08-07T17:04:57+00:00"
 },
 "AWSIoTDeviceDefenderUpdateCACertMitigationAction":{
  "CreateDate":"2019-08-07T17:05:49+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iot:UpdateCACertificate"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-08-07T17:05:49+00:00"
 },
 "AWSIoTDeviceDefenderUpdateDeviceCertMitigationAction":{
  "CreateDate":"2019-08-07T17:06:00+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iot:UpdateCertificate"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-08-07T17:06:00+00:00"
 },
 "AWSIoTDeviceTesterForFreeRTOSFullAccess":{
  "CreateDate":"2020-02-12T20:33:53+00:00",
  "DefaultVersionId":"v5",
  "Document":{
   "Statement":[
    {
     "Action":"iam:PassRole",
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":"iot.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/idt-*",
     "Sid":"VisualEditor0"
    },
    {
     "Action":[
      "iot:DeleteThing",
      "iot:AttachThingPrincipal",
      "iot:DeleteCertificate",
      "iot:GetRegistrationCode",
      "iot:CreatePolicy",
      "iot:UpdateCACertificate",
      "s3:ListBucket",
      "iot:DescribeEndpoint",
      "iot:CreateOTAUpdate",
      "iot:CreateStream",
      "signer:ListSigningJobs",
      "acm:ListCertificates",
      "iot:CreateKeysAndCertificate",
      "iot:UpdateCertificate",
      "iot:CreateCertificateFromCsr",
      "iot:DetachThingPrincipal",
      "iot:RegisterCACertificate",
      "iot:CreateThing",
      "freertos:ListHardwarePlatforms",
      "iam:ListRoles",
      "iot:RegisterCertificate",
      "iot:DeleteCACertificate",
      "signer:PutSigningProfile",
      "s3:ListAllMyBuckets",
      "signer:ListSigningPlatforms",
      "iot-device-tester:SendMetrics",
      "iot-device-tester:SupportedVersion",
      "iot-device-tester:LatestIdt",
      "iot-device-tester:CheckVersion",
      "iot-device-tester:DownloadTestSuite"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"VisualEditor1"
    },
    {
     "Action":[
      "iam:GetRole",
      "signer:StartSigningJob",
      "acm:GetCertificate",
      "signer:DescribeSigningJob",
      "s3:CreateBucket",
      "execute-api:Invoke",
      "s3:DeleteBucket",
      "s3:PutBucketVersioning",
      "signer:CancelSigningProfile"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:execute-api:us-east-1:098862408343:9xpmnvs5h4/prod/POST/metrics",
      "arn:aws:signer:*:*:/signing-profiles/*",
      "arn:aws:signer:*:*:/signing-jobs/*",
      "arn:aws:iam::*:role/idt-*",
      "arn:aws:acm:*:*:certificate/*",
      "arn:aws:s3:::idt-*",
      "arn:aws:s3:::afr-ota*"
     ],
     "Sid":"VisualEditor2"
    },
    {
     "Action":[
      "iot:DeleteStream",
      "iot:DeleteCertificate",
      "iot:AttachPolicy",
      "iot:DetachPolicy",
      "iot:DeletePolicy",
      "s3:ListBucketVersions",
      "iot:UpdateCertificate",
      "iot:GetOTAUpdate",
      "iot:DeleteOTAUpdate",
      "iot:DescribeJobExecution"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::afr-ota*",
      "arn:aws:iot:*:*:thinggroup/idt*",
      "arn:aws:iam::*:role/idt-*"
     ],
     "Sid":"VisualEditor3"
    },
    {
     "Action":[
      "iot:DeleteCertificate",
      "iot:AttachPolicy",
      "iot:DetachPolicy",
      "s3:DeleteObjectVersion",
      "iot:DeleteOTAUpdate",
      "s3:PutObject",
      "s3:GetObject",
      "iot:DeleteStream",
      "iot:DeletePolicy",
      "s3:DeleteObject",
      "iot:UpdateCertificate",
      "iot:GetOTAUpdate",
      "s3:GetObjectVersion",
      "iot:DescribeJobExecution"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::afr-ota*/*",
      "arn:aws:s3:::idt-*/*",
      "arn:aws:iot:*:*:policy/idt*",
      "arn:aws:iam::*:role/idt-*",
      "arn:aws:iot:*:*:otaupdate/idt*",
      "arn:aws:iot:*:*:thing/idt*",
      "arn:aws:iot:*:*:cert/*",
      "arn:aws:iot:*:*:job/*",
      "arn:aws:iot:*:*:stream/*"
     ],
     "Sid":"VisualEditor4"
    },
    {
     "Action":[
      "s3:PutObject",
      "s3:GetObject"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::afr-ota*/*",
      "arn:aws:s3:::idt-*/*"
     ],
     "Sid":"VisualEditor5"
    },
    {
     "Action":[
      "iot:CancelJobExecution"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iot:*:*:job/*",
      "arn:aws:iot:*:*:thing/idt*"
     ],
     "Sid":"VisualEditor6"
    },
    {
     "Action":[
      "ec2:TerminateInstances"
     ],
     "Condition":{
      "StringEquals":{
       "ec2:ResourceTag/Owner":"IoTDeviceTester"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:instance/*"
     ],
     "Sid":"VisualEditor7"
    },
    {
     "Action":[
      "ec2:AuthorizeSecurityGroupIngress",
      "ec2:DeleteSecurityGroup"
     ],
     "Condition":{
      "StringEquals":{
       "ec2:ResourceTag/Owner":"IoTDeviceTester"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:security-group/*"
     ],
     "Sid":"VisualEditor8"
    },
    {
     "Action":[
      "ec2:RunInstances"
     ],
     "Condition":{
      "StringEquals":{
       "aws:RequestTag/Owner":"IoTDeviceTester"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:instance/*"
     ],
     "Sid":"VisualEditor9"
    },
    {
     "Action":[
      "ec2:RunInstances"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:image/*",
      "arn:aws:ec2:*:*:security-group/*",
      "arn:aws:ec2:*:*:volume/*",
      "arn:aws:ec2:*:*:key-pair/*",
      "arn:aws:ec2:*:*:placement-group/*",
      "arn:aws:ec2:*:*:snapshot/*",
      "arn:aws:ec2:*:*:network-interface/*",
      "arn:aws:ec2:*:*:subnet/*"
     ],
     "Sid":"VisualEditor10"
    },
    {
     "Action":[
      "ec2:CreateSecurityGroup"
     ],
     "Condition":{
      "StringEquals":{
       "aws:RequestTag/Owner":"IoTDeviceTester"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:security-group/*"
     ],
     "Sid":"VisualEditor11"
    },
    {
     "Action":[
      "ec2:DescribeInstances",
      "ec2:DescribeSecurityGroups",
      "ssm:DescribeParameters",
      "ssm:GetParameters"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"VisualEditor12"
    },
    {
     "Action":[
      "ec2:CreateTags"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:TagKeys":[
        "Owner"
       ],
       "ec2:CreateAction":[
        "RunInstances",
        "CreateSecurityGroup"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:security-group/*",
      "arn:aws:ec2:*:*:instance/*"
     ],
     "Sid":"VisualEditor13"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-12-15T18:03:46+00:00"
 },
 "AWSIoTDeviceTesterForGreengrassFullAccess":{
  "CreateDate":"2020-02-20T21:21:27+00:00",
  "DefaultVersionId":"v4",
  "Document":{
   "Statement":[
    {
     "Action":"iam:PassRole",
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":[
        "iot.amazonaws.com",
        "lambda.amazonaws.com",
        "greengrass.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/idt-*",
     "Sid":"VisualEditor1"
    },
    {
     "Action":[
      "lambda:CreateFunction",
      "iot:DeleteCertificate",
      "lambda:DeleteFunction",
      "execute-api:Invoke",
      "iot:UpdateCertificate"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:execute-api:us-east-1:098862408343:9xpmnvs5h4/prod/POST/metrics",
      "arn:aws:lambda:*:*:function:idt-*",
      "arn:aws:iot:*:*:cert/*"
     ],
     "Sid":"VisualEditor2"
    },
    {
     "Action":[
      "iot:CreateThing",
      "iot:DeleteThing"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iot:*:*:thing/idt-*",
      "arn:aws:iot:*:*:cert/*"
     ],
     "Sid":"VisualEditor3"
    },
    {
     "Action":[
      "iot:AttachPolicy",
      "iot:DetachPolicy",
      "iot:DeletePolicy"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iot:*:*:policy/idt-*",
      "arn:aws:iot:*:*:cert/*"
     ],
     "Sid":"VisualEditor4"
    },
    {
     "Action":[
      "iot:CreateJob",
      "iot:DescribeJob",
      "iot:DescribeJobExecution",
      "iot:DeleteJob"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iot:*:*:thing/idt-*",
      "arn:aws:iot:*:*:job/*"
     ],
     "Sid":"VisualEditor5"
    },
    {
     "Action":[
      "iot:DescribeEndpoint",
      "greengrass:*",
      "iam:ListAttachedRolePolicies",
      "iot:CreatePolicy",
      "iot:GetThingShadow",
      "iot:CreateKeysAndCertificate",
      "iot:ListThings",
      "iot:UpdateThingShadow",
      "iot:CreateCertificateFromCsr",
      "iot-device-tester:SendMetrics",
      "iot-device-tester:SupportedVersion",
      "iot-device-tester:LatestIdt",
      "iot-device-tester:CheckVersion",
      "iot-device-tester:DownloadTestSuite"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"VisualEditor6"
    },
    {
     "Action":[
      "iot:DetachThingPrincipal",
      "iot:AttachThingPrincipal"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iot:*:*:thing/idt-*",
      "arn:aws:iot:*:*:cert/*"
     ],
     "Sid":"VisualEditor7"
    },
    {
     "Action":[
      "s3:PutObject",
      "s3:DeleteObjectVersion",
      "s3:ListBucketVersions",
      "s3:CreateBucket",
      "s3:DeleteObject",
      "s3:DeleteBucket"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::idt*",
     "Sid":"VisualEditor8"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-06-25T17:01:56+00:00"
 },
 "AWSIoTEventsFullAccess":{
  "CreateDate":"2019-01-10T22:51:57+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iotevents:*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-01-10T22:51:57+00:00"
 },
 "AWSIoTEventsReadOnlyAccess":{
  "CreateDate":"2019-01-10T22:50:08+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iotevents:Describe*",
      "iotevents:List*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-09-23T17:22:04+00:00"
 },
 "AWSIoTFleetHubFederationAccess":{
  "CreateDate":"2020-12-15T08:08:05+00:00",
  "DefaultVersionId":"v5",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iot:DescribeIndex",
      "iot:DescribeThingGroup",
      "iot:GetBucketsAggregation",
      "iot:GetCardinality",
      "iot:GetIndexingConfiguration",
      "iot:GetPercentiles",
      "iot:GetStatistics",
      "iot:SearchIndex",
      "iot:CreateFleetMetric",
      "iot:ListFleetMetrics",
      "iot:DeleteFleetMetric",
      "iot:DescribeFleetMetric",
      "iot:UpdateFleetMetric",
      "iot:DescribeCustomMetric",
      "iot:ListCustomMetrics",
      "iot:ListDimensions",
      "iot:ListMetricValues",
      "iot:ListThingGroups",
      "iot:ListThingsInThingGroup",
      "iot:ListJobTemplates",
      "iot:DescribeJobTemplate",
      "iot:ListJobs",
      "iot:CreateJob",
      "iot:CancelJob",
      "iot:DescribeJob",
      "iot:ListJobExecutionsForJob",
      "iot:ListJobExecutionsForThing",
      "iot:DescribeJobExecution",
      "iot:ListSecurityProfiles",
      "iot:DescribeSecurityProfile",
      "iot:ListActiveViolations",
      "iot:GetThingShadow",
      "iot:ListNamedShadowsForThing",
      "iot:CancelJobExecution",
      "iot:DescribeEndpoint",
      "iotfleethub:DescribeApplication",
      "cloudwatch:DescribeAlarms",
      "cloudwatch:GetMetricData",
      "cloudwatch:ListMetrics",
      "sns:ListTopics"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "sns:CreateTopic",
      "sns:DeleteTopic",
      "sns:ListSubscriptionsByTopic",
      "sns:Subscribe",
      "sns:Unsubscribe"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:sns:*:*:iotfleethub*"
    },
    {
     "Action":[
      "cloudwatch:PutMetricAlarm",
      "cloudwatch:DeleteAlarms",
      "cloudwatch:DescribeAlarmHistory"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:cloudwatch:*:*:iotfleethub*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-04-04T18:03:01+00:00"
 },
 "AWSIoTFullAccess":{
  "CreateDate":"2015-10-08T15:19:49+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iot:*",
      "iotjobsdata:*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-05-19T21:39:11+00:00"
 },
 "AWSIoTLogging":{
  "CreateDate":"2015-10-08T15:17:25+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "logs:CreateLogGroup",
      "logs:CreateLogStream",
      "logs:PutLogEvents",
      "logs:PutMetricFilter",
      "logs:PutRetentionPolicy",
      "logs:GetLogEvents",
      "logs:DeleteLogStream"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2015-10-08T15:17:25+00:00"
 },
 "AWSIoTOTAUpdate":{
  "CreateDate":"2017-12-20T20:36:53+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":{
    "Action":[
     "iot:CreateJob",
     "signer:DescribeSigningJob"
    ],
    "Effect":"Allow",
    "Resource":"*"
   },
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2017-12-20T20:36:53+00:00"
 },
 "AWSIoTRuleActions":{
  "CreateDate":"2015-10-08T15:14:51+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":{
    "Action":[
     "dynamodb:PutItem",
     "kinesis:PutRecord",
     "iot:Publish",
     "s3:PutObject",
     "sns:Publish",
     "sqs:SendMessage*",
     "cloudwatch:SetAlarmState",
     "cloudwatch:PutMetricData",
     "es:ESHttpPut",
     "firehose:PutRecord"
    ],
    "Effect":"Allow",
    "Resource":"*"
   },
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2018-01-16T19:28:19+00:00"
 },
 "AWSIoTSiteWiseConsoleFullAccess":{
  "CreateDate":"2019-05-31T21:37:49+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":"iotsitewise:*",
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "iotanalytics:List*",
      "iotanalytics:Describe*",
      "iotanalytics:Create*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "iot:DescribeEndpoint",
      "iot:GetThingShadow"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "greengrass:GetGroup",
      "greengrass:GetGroupVersion",
      "greengrass:GetCoreDefinitionVersion",
      "greengrass:ListGroups"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "secretsmanager:ListSecrets",
      "secretsmanager:CreateSecret"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "secretsmanager:UpdateSecret"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:secretsmanager:*:*:secret:greengrass-*"
    },
    {
     "Action":[
      "tag:GetResources"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "iam:CreateServiceLinkedRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":"iotsitewise.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/aws-service-role/iotsitewise.amazonaws.com/AWSServiceRoleForIoTSiteWise*"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":"iotsitewise.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/aws-service-role/iotsitewise.amazonaws.com/AWSServiceRoleForIoTSiteWise*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-05-31T21:37:49+00:00"
 },
 "AWSIoTSiteWiseFullAccess":{
  "CreateDate":"2018-12-04T20:53:39+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iotsitewise:*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2018-12-04T20:53:39+00:00"
 },
 "AWSIoTSiteWiseMonitorPortalAccess":{
  "CreateDate":"2020-05-19T20:01:21+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iotsitewise:CreateProject",
      "iotsitewise:DescribeProject",
      "iotsitewise:UpdateProject",
      "iotsitewise:DeleteProject",
      "iotsitewise:ListProjects",
      "iotsitewise:BatchAssociateProjectAssets",
      "iotsitewise:BatchDisassociateProjectAssets",
      "iotsitewise:ListProjectAssets",
      "iotsitewise:CreateDashboard",
      "iotsitewise:DescribeDashboard",
      "iotsitewise:UpdateDashboard",
      "iotsitewise:DeleteDashboard",
      "iotsitewise:ListDashboards",
      "iotsitewise:CreateAccessPolicy",
      "iotsitewise:DescribeAccessPolicy",
      "iotsitewise:UpdateAccessPolicy",
      "iotsitewise:DeleteAccessPolicy",
      "iotsitewise:ListAccessPolicies",
      "iotsitewise:DescribeAsset",
      "iotsitewise:ListAssets",
      "iotsitewise:ListAssociatedAssets",
      "iotsitewise:DescribeAssetProperty",
      "iotsitewise:GetAssetPropertyValue",
      "iotsitewise:GetAssetPropertyValueHistory",
      "iotsitewise:GetAssetPropertyAggregates",
      "sso-directory:DescribeUsers"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-05-19T20:01:21+00:00"
 },
 "AWSIoTSiteWiseMonitorServiceRolePolicy":{
  "CreateDate":"2019-11-14T00:59:10+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iotsitewise:CreateProject",
      "iotsitewise:DescribeProject",
      "iotsitewise:UpdateProject",
      "iotsitewise:DeleteProject",
      "iotsitewise:ListProjects",
      "iotsitewise:BatchAssociateProjectAssets",
      "iotsitewise:BatchDisassociateProjectAssets",
      "iotsitewise:ListProjectAssets",
      "iotsitewise:CreateDashboard",
      "iotsitewise:DescribeDashboard",
      "iotsitewise:UpdateDashboard",
      "iotsitewise:DeleteDashboard",
      "iotsitewise:ListDashboards",
      "iotsitewise:CreateAccessPolicy",
      "iotsitewise:DescribeAccessPolicy",
      "iotsitewise:UpdateAccessPolicy",
      "iotsitewise:DeleteAccessPolicy",
      "iotsitewise:ListAccessPolicies",
      "iotsitewise:DescribeAsset",
      "iotsitewise:ListAssets",
      "iotsitewise:ListAssociatedAssets",
      "iotsitewise:DescribeAssetProperty",
      "iotsitewise:GetAssetPropertyValue",
      "iotsitewise:GetAssetPropertyValueHistory",
      "iotsitewise:GetAssetPropertyAggregates",
      "sso-directory:DescribeUsers"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-12-13T22:19:25+00:00"
 },
 "AWSIoTSiteWiseReadOnlyAccess":{
  "CreateDate":"2018-12-04T20:55:11+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iotsitewise:Describe*",
      "iotsitewise:List*",
      "iotsitewise:Get*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2018-12-04T20:55:11+00:00"
 },
 "AWSIoTThingsRegistration":{
  "CreateDate":"2017-12-01T20:21:52+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iot:AddThingToThingGroup",
      "iot:AttachPolicy",
      "iot:AttachPrincipalPolicy",
      "iot:AttachThingPrincipal",
      "iot:CreateCertificateFromCsr",
      "iot:CreatePolicy",
      "iot:CreateThing",
      "iot:DescribeCertificate",
      "iot:DescribeThing",
      "iot:DescribeThingGroup",
      "iot:DescribeThingType",
      "iot:DetachPolicy",
      "iot:DetachThingPrincipal",
      "iot:GetPolicy",
      "iot:ListAttachedPolicies",
      "iot:ListPolicyPrincipals",
      "iot:ListPrincipalPolicies",
      "iot:ListPrincipalThings",
      "iot:ListTargetsForPolicy",
      "iot:ListThingGroupsForThing",
      "iot:ListThingPrincipals",
      "iot:RegisterCertificate",
      "iot:RegisterThing",
      "iot:RemoveThingFromThingGroup",
      "iot:UpdateCertificate",
      "iot:UpdateThing",
      "iot:UpdateThingGroupsForThing",
      "iot:AddThingToBillingGroup",
      "iot:DescribeBillingGroup",
      "iot:RemoveThingFromBillingGroup"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-10-05T19:20:12+00:00"
 },
 "AWSIoTWirelessDataAccess":{
  "CreateDate":"2020-12-15T15:31:39+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iotwireless:SendDataToWirelessDevice"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-12-15T15:31:39+00:00"
 },
 "AWSIoTWirelessFullAccess":{
  "CreateDate":"2020-12-15T15:27:57+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iotwireless:*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-12-15T15:27:57+00:00"
 },
 "AWSIoTWirelessFullPublishAccess":{
  "CreateDate":"2020-12-15T15:29:59+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iot:DescribeEndpoint",
      "iot:Publish"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-12-15T15:29:59+00:00"
 },
 "AWSIoTWirelessGatewayCertManager":{
  "CreateDate":"2020-12-15T15:30:48+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iot:CreateKeysAndCertificate",
      "iot:DescribeCertificate",
      "iot:ListCertificates"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"IoTWirelessGatewayCertManager"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-12-15T15:30:48+00:00"
 },
 "AWSIoTWirelessLogging":{
  "CreateDate":"2020-12-15T15:32:40+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "logs:CreateLogGroup",
      "logs:CreateLogStream",
      "logs:DescribeLogGroups",
      "logs:DescribeLogStreams",
      "logs:PutLogEvents"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:logs:*:*:log-group:/aws/iotwireless*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-12-15T15:32:40+00:00"
 },
 "AWSIoTWirelessReadOnlyAccess":{
  "CreateDate":"2020-12-15T15:28:56+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iotwireless:List*",
      "iotwireless:Get*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-12-15T15:28:56+00:00"
 },
 "AWSIotRoboRunnerFullAccess":{
  "CreateDate":"2021-11-29T03:54:37+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":"iotroborunner:*",
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-11-29T03:54:37+00:00"
 },
 "AWSIotRoboRunnerReadOnly":{
  "CreateDate":"2021-11-29T03:43:32+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iotroborunner:GetTask",
      "iotroborunner:ListActivities",
      "iotroborunner:GetSite",
      "iotroborunner:GetDestinationRelationship",
      "iotroborunner:GetWorker",
      "iotroborunner:ListTasks",
      "iotroborunner:GetAction",
      "iotroborunner:GetActivity",
      "iotroborunner:ListDestinationRelationships",
      "iotroborunner:ListActionTemplates",
      "iotroborunner:ListWorkerFleets",
      "iotroborunner:ListSites",
      "iotroborunner:ListActions",
      "iotroborunner:ListWorkers",
      "iotroborunner:GetDestination",
      "iotroborunner:GetActionTemplate",
      "iotroborunner:GetWorkerFleet",
      "iotroborunner:ListDestinations"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-11-29T03:43:32+00:00"
 },
 "AWSKeyManagementServiceCustomKeyStoresServiceRolePolicy":{
  "CreateDate":"2018-11-14T20:10:53+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cloudhsm:Describe*",
      "ec2:CreateNetworkInterface",
      "ec2:AuthorizeSecurityGroupIngress",
      "ec2:CreateSecurityGroup",
      "ec2:DescribeSecurityGroups",
      "ec2:RevokeSecurityGroupEgress",
      "ec2:DeleteSecurityGroup"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2018-11-14T20:10:53+00:00"
 },
 "AWSKeyManagementServiceMultiRegionKeysServiceRolePolicy":{
  "CreateDate":"2021-06-16T15:37:37+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "kms:SynchronizeMultiRegionKey"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-06-16T15:37:37+00:00"
 },
 "AWSKeyManagementServicePowerUser":{
  "CreateDate":"2015-02-06T18:40:40+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "kms:CreateAlias",
      "kms:CreateKey",
      "kms:DeleteAlias",
      "kms:Describe*",
      "kms:GenerateRandom",
      "kms:Get*",
      "kms:List*",
      "kms:TagResource",
      "kms:UntagResource",
      "iam:ListGroups",
      "iam:ListRoles",
      "iam:ListUsers"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2017-03-07T00:55:11+00:00"
 },
 "AWSLakeFormationCrossAccountManager":{
  "CreateDate":"2020-08-04T20:59:46+00:00",
  "DefaultVersionId":"v4",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ram:CreateResourceShare"
     ],
     "Condition":{
      "StringLikeIfExists":{
       "ram:RequestedResourceType":[
        "glue:Table",
        "glue:Database",
        "glue:Catalog"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ram:UpdateResourceShare",
      "ram:DeleteResourceShare",
      "ram:AssociateResourceShare",
      "ram:DisassociateResourceShare",
      "ram:GetResourceShares"
     ],
     "Condition":{
      "StringLike":{
       "ram:ResourceShareName":[
        "LakeFormation*"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "glue:PutResourcePolicy",
      "glue:DeleteResourcePolicy",
      "organizations:DescribeOrganization",
      "organizations:DescribeAccount",
      "ram:Get*",
      "ram:List*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "organizations:ListRoots",
      "organizations:ListAccountsForParent",
      "organizations:ListOrganizationalUnitsForParent"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-05-20T22:19:37+00:00"
 },
 "AWSLakeFormationDataAdmin":{
  "CreateDate":"2019-08-08T17:33:44+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "lakeformation:*",
      "cloudtrail:DescribeTrails",
      "cloudtrail:LookupEvents",
      "glue:GetDatabase",
      "glue:GetDatabases",
      "glue:CreateDatabase",
      "glue:UpdateDatabase",
      "glue:DeleteDatabase",
      "glue:GetConnections",
      "glue:SearchTables",
      "glue:GetTable",
      "glue:CreateTable",
      "glue:UpdateTable",
      "glue:DeleteTable",
      "glue:GetTableVersions",
      "glue:GetPartitions",
      "glue:GetTables",
      "glue:GetWorkflow",
      "glue:ListWorkflows",
      "glue:BatchGetWorkflows",
      "glue:DeleteWorkflow",
      "glue:GetWorkflowRuns",
      "glue:StartWorkflowRun",
      "glue:GetWorkflow",
      "s3:ListBucket",
      "s3:GetBucketLocation",
      "s3:ListAllMyBuckets",
      "s3:GetBucketAcl",
      "iam:ListUsers",
      "iam:ListRoles",
      "iam:GetRole",
      "iam:GetRolePolicy"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "lakeformation:PutDataLakeSettings"
     ],
     "Effect":"Deny",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-12-16T22:41:40+00:00"
 },
 "AWSLambdaBasicExecutionRole":{
  "CreateDate":"2015-04-09T15:03:43+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "logs:CreateLogGroup",
      "logs:CreateLogStream",
      "logs:PutLogEvents"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2015-04-09T15:03:43+00:00"
 },
 "AWSLambdaDynamoDBExecutionRole":{
  "CreateDate":"2015-04-09T15:09:29+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "dynamodb:DescribeStream",
      "dynamodb:GetRecords",
      "dynamodb:GetShardIterator",
      "dynamodb:ListStreams",
      "logs:CreateLogGroup",
      "logs:CreateLogStream",
      "logs:PutLogEvents"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2015-04-09T15:09:29+00:00"
 },
 "AWSLambdaENIManagementAccess":{
  "CreateDate":"2016-12-06T00:37:27+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:CreateNetworkInterface",
      "ec2:DescribeNetworkInterfaces",
      "ec2:DeleteNetworkInterface",
      "ec2:AssignPrivateIpAddresses",
      "ec2:UnassignPrivateIpAddresses"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-10-01T20:07:26+00:00"
 },
 "AWSLambdaExecute":{
  "CreateDate":"2015-02-06T18:40:46+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "logs:*"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:logs:*:*:*"
    },
    {
     "Action":[
      "s3:GetObject",
      "s3:PutObject"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2015-02-06T18:40:46+00:00"
 },
 "AWSLambdaInvocation-DynamoDB":{
  "CreateDate":"2015-02-06T18:40:47+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "lambda:InvokeFunction"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "dynamodb:DescribeStream",
      "dynamodb:GetRecords",
      "dynamodb:GetShardIterator",
      "dynamodb:ListStreams"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2015-02-06T18:40:47+00:00"
 },
 "AWSLambdaKinesisExecutionRole":{
  "CreateDate":"2015-04-09T15:14:16+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "kinesis:DescribeStream",
      "kinesis:DescribeStreamSummary",
      "kinesis:GetRecords",
      "kinesis:GetShardIterator",
      "kinesis:ListShards",
      "kinesis:ListStreams",
      "kinesis:SubscribeToShard",
      "logs:CreateLogGroup",
      "logs:CreateLogStream",
      "logs:PutLogEvents"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2018-11-19T20:09:24+00:00"
 },
 "AWSLambdaMSKExecutionRole":{
  "CreateDate":"2020-08-11T17:35:05+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "kafka:DescribeCluster",
      "kafka:GetBootstrapBrokers",
      "ec2:CreateNetworkInterface",
      "ec2:DescribeNetworkInterfaces",
      "ec2:DescribeVpcs",
      "ec2:DeleteNetworkInterface",
      "ec2:DescribeSubnets",
      "ec2:DescribeSecurityGroups",
      "logs:CreateLogGroup",
      "logs:CreateLogStream",
      "logs:PutLogEvents"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-08-11T17:35:05+00:00"
 },
 "AWSLambdaReplicator":{
  "CreateDate":"2017-05-23T17:53:03+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "lambda:CreateFunction",
      "lambda:DeleteFunction",
      "lambda:DisableReplication"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:lambda:*:*:function:*"
     ],
     "Sid":"LambdaCreateDeletePermission"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringLikeIfExists":{
       "iam:PassedToService":"lambda.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"IamPassRolePermission"
    },
    {
     "Action":[
      "cloudfront:ListDistributionsByLambdaFunction"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"CloudFrontListDistributions"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2017-12-08T00:17:54+00:00"
 },
 "AWSLambdaRole":{
  "CreateDate":"2015-02-06T18:41:28+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "lambda:InvokeFunction"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2015-02-06T18:41:28+00:00"
 },
 "AWSLambdaSQSQueueExecutionRole":{
  "CreateDate":"2018-06-14T21:50:45+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "sqs:ReceiveMessage",
      "sqs:DeleteMessage",
      "sqs:GetQueueAttributes",
      "logs:CreateLogGroup",
      "logs:CreateLogStream",
      "logs:PutLogEvents"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2018-06-14T21:50:45+00:00"
 },
 "AWSLambdaVPCAccessExecutionRole":{
  "CreateDate":"2016-02-11T23:15:26+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "logs:CreateLogGroup",
      "logs:CreateLogStream",
      "logs:PutLogEvents",
      "ec2:CreateNetworkInterface",
      "ec2:DescribeNetworkInterfaces",
      "ec2:DeleteNetworkInterface",
      "ec2:AssignPrivateIpAddresses",
      "ec2:UnassignPrivateIpAddresses"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-10-15T22:53:03+00:00"
 },
 "AWSLambda_FullAccess":{
  "CreateDate":"2020-11-17T21:14:08+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cloudformation:DescribeStacks",
      "cloudformation:ListStackResources",
      "cloudwatch:ListMetrics",
      "cloudwatch:GetMetricData",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeSubnets",
      "ec2:DescribeVpcs",
      "kms:ListAliases",
      "iam:GetPolicy",
      "iam:GetPolicyVersion",
      "iam:GetRole",
      "iam:GetRolePolicy",
      "iam:ListAttachedRolePolicies",
      "iam:ListRolePolicies",
      "iam:ListRoles",
      "lambda:*",
      "logs:DescribeLogGroups",
      "states:DescribeStateMachine",
      "states:ListStateMachines",
      "tag:GetResources",
      "xray:GetTraceSummaries",
      "xray:BatchGetTraces"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"iam:PassRole",
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":"lambda.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "logs:DescribeLogStreams",
      "logs:GetLogEvents",
      "logs:FilterLogEvents"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:logs:*:*:log-group:/aws/lambda/*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-11-17T21:14:08+00:00"
 },
 "AWSLambda_ReadOnlyAccess":{
  "CreateDate":"2020-11-17T21:10:32+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cloudformation:DescribeStacks",
      "cloudformation:ListStackResources",
      "cloudwatch:GetMetricData",
      "cloudwatch:ListMetrics",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeSubnets",
      "ec2:DescribeVpcs",
      "kms:ListAliases",
      "iam:GetPolicy",
      "iam:GetPolicyVersion",
      "iam:GetRole",
      "iam:GetRolePolicy",
      "iam:ListAttachedRolePolicies",
      "iam:ListRolePolicies",
      "iam:ListRoles",
      "logs:DescribeLogGroups",
      "lambda:Get*",
      "lambda:List*",
      "states:DescribeStateMachine",
      "states:ListStateMachines",
      "tag:GetResources",
      "xray:GetTraceSummaries",
      "xray:BatchGetTraces"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "logs:DescribeLogStreams",
      "logs:GetLogEvents",
      "logs:FilterLogEvents"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:logs:*:*:log-group:/aws/lambda/*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-11-17T21:10:32+00:00"
 },
 "AWSLicenseManagerConsumptionPolicy":{
  "CreateDate":"2021-08-11T23:18:08+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":{
    "Action":[
     "license-manager:CheckoutLicense",
     "license-manager:CheckInLicense",
     "license-manager:ExtendLicenseConsumption",
     "license-manager:GetLicense"
    ],
    "Effect":"Allow",
    "Resource":"*"
   },
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-08-11T23:18:08+00:00"
 },
 "AWSLicenseManagerMasterAccountRolePolicy":{
  "CreateDate":"2018-11-26T19:03:51+00:00",
  "DefaultVersionId":"v5",
  "Document":{
   "Statement":[
    {
     "Action":[
      "s3:GetBucketLocation",
      "s3:ListBucket",
      "s3:GetLifecycleConfiguration",
      "s3:PutLifecycleConfiguration",
      "s3:GetBucketPolicy",
      "s3:PutBucketPolicy"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::aws-license-manager-service-*"
     ],
     "Sid":"S3BucketPermissions"
    },
    {
     "Action":[
      "s3:AbortMultipartUpload",
      "s3:PutObject",
      "s3:GetObject",
      "s3:ListBucketMultipartUploads",
      "s3:ListMultipartUploadParts"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::aws-license-manager-service-*"
     ],
     "Sid":"S3ObjectPermissions1"
    },
    {
     "Action":[
      "s3:DeleteObject"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::aws-license-manager-service-*/resource_sync/*"
     ],
     "Sid":"S3ObjectPermissions2"
    },
    {
     "Action":[
      "athena:GetQueryExecution",
      "athena:GetQueryResults",
      "athena:StartQueryExecution"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"AthenaPermissions"
    },
    {
     "Action":[
      "glue:GetTable",
      "glue:GetPartition",
      "glue:GetPartitions"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"GluePermissions"
    },
    {
     "Action":[
      "organizations:DescribeOrganization",
      "organizations:ListAccounts",
      "organizations:DescribeAccount",
      "organizations:ListChildren",
      "organizations:ListParents",
      "organizations:ListAccountsForParent",
      "organizations:ListRoots",
      "organizations:ListAWSServiceAccessForOrganization"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"OrganizationPermissions"
    },
    {
     "Action":[
      "ram:GetResourceShares",
      "ram:GetResourceShareAssociations",
      "ram:TagResource"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"RAMPermissions1"
    },
    {
     "Action":[
      "ram:CreateResourceShare"
     ],
     "Condition":{
      "StringEquals":{
       "aws:RequestTag/Service":"LicenseManager"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"RAMPermissions2"
    },
    {
     "Action":[
      "ram:AssociateResourceShare",
      "ram:DisassociateResourceShare",
      "ram:UpdateResourceShare",
      "ram:DeleteResourceShare"
     ],
     "Condition":{
      "StringEquals":{
       "aws:ResourceTag/Service":"LicenseManager"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"RAMPermissions3"
    },
    {
     "Action":[
      "iam:GetRole"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"IAMGetRoles"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":[
        "cloudformation.amazonaws.com",
        "glue.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/LicenseManagerServiceResourceDataSyncRole*"
     ],
     "Sid":"IAMPassRoles"
    },
    {
     "Action":[
      "cloudformation:UpdateStack",
      "cloudformation:CreateStack",
      "cloudformation:DeleteStack",
      "cloudformation:DescribeStacks"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:cloudformation:*:*:stack/LicenseManagerCrossAccountCloudDiscoveryStack/*"
     ],
     "Sid":"CloudformationPermission"
    },
    {
     "Action":[
      "glue:CreateTable",
      "glue:UpdateTable",
      "glue:DeleteTable",
      "glue:UpdateJob",
      "glue:UpdateCrawler"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:glue:*:*:catalog",
      "arn:aws:glue:*:*:crawler/LicenseManagerResourceSynDataCrawler",
      "arn:aws:glue:*:*:job/LicenseManagerResourceSynDataProcessJob",
      "arn:aws:glue:*:*:table/license_manager_resource_inventory_db/*",
      "arn:aws:glue:*:*:table/license_manager_resource_sync/*",
      "arn:aws:glue:*:*:database/license_manager_resource_inventory_db",
      "arn:aws:glue:*:*:database/license_manager_resource_sync"
     ],
     "Sid":"GlueUpdatePermissions"
    },
    {
     "Action":[
      "resource-groups:PutGroupPolicy"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:CalledVia":[
        "ram.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"RGPermissions"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-05-31T20:50:26+00:00"
 },
 "AWSLicenseManagerMemberAccountRolePolicy":{
  "CreateDate":"2018-11-26T19:04:32+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "license-manager:UpdateLicenseSpecificationsForResource",
      "license-manager:GetLicenseConfiguration"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"LicenseManagerPermissions"
    },
    {
     "Action":[
      "ssm:ListInventoryEntries",
      "ssm:GetInventory",
      "ssm:CreateAssociation",
      "ssm:CreateResourceDataSync",
      "ssm:DeleteResourceDataSync",
      "ssm:ListResourceDataSync",
      "ssm:ListAssociations"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"SSMPermissions"
    },
    {
     "Action":[
      "ram:AcceptResourceShareInvitation",
      "ram:GetResourceShareInvitations"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"RAMPermissions"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-11-15T22:09:32+00:00"
 },
 "AWSLicenseManagerServiceRolePolicy":{
  "CreateDate":"2018-11-26T19:02:53+00:00",
  "DefaultVersionId":"v7",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iam:CreateServiceLinkedRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":"license-management.marketplace.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/aws-service-role/license-management.marketplace.amazonaws.com/AWSServiceRoleForMarketplaceLicenseManagement"
     ],
     "Sid":"IAMPermissions"
    },
    {
     "Action":[
      "iam:CreateServiceLinkedRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":"license-manager.member-account.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:*:iam::*:role/aws-service-role/license-manager.member-account.amazonaws.com/AWSServiceRoleForAWSLicenseManagerMemberAccountRole"
     ],
     "Sid":"IAMPermissionsForCreatingMemberSLR"
    },
    {
     "Action":[
      "s3:GetBucketLocation",
      "s3:ListBucket"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::aws-license-manager-service-*"
     ],
     "Sid":"S3BucketPermissions1"
    },
    {
     "Action":[
      "s3:ListAllMyBuckets"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"S3BucketPermissions2"
    },
    {
     "Action":[
      "s3:PutObject"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::aws-license-manager-service-*"
     ],
     "Sid":"S3ObjectPermissions"
    },
    {
     "Action":[
      "sns:Publish"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:sns:*:*:aws-license-manager-service-*"
     ],
     "Sid":"SNSAccountPermissions"
    },
    {
     "Action":[
      "sns:ListTopics"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"SNSTopicPermissions"
    },
    {
     "Action":[
      "ec2:DescribeInstances",
      "ec2:DescribeImages",
      "ec2:DescribeHosts"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"EC2Permissions"
    },
    {
     "Action":[
      "ssm:ListInventoryEntries",
      "ssm:GetInventory",
      "ssm:CreateAssociation"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"SSMPermissions"
    },
    {
     "Action":[
      "organizations:ListAWSServiceAccessForOrganization",
      "organizations:DescribeOrganization",
      "organizations:ListDelegatedAdministrators"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"OrganizationPermissions"
    },
    {
     "Action":[
      "license-manager:GetServiceSettings",
      "license-manager:GetLicense*",
      "license-manager:UpdateLicenseSpecificationsForResource",
      "license-manager:List*"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"LicenseManagerPermissions"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-07-30T01:43:19+00:00"
 },
 "AWSM2ServicePolicy":{
  "CreateDate":"2022-06-07T20:26:39+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:DescribeSubnets",
      "ec2:CreateNetworkInterface",
      "ec2:DeleteNetworkInterface",
      "ec2:DescribeNetworkInterfaces",
      "ec2:CreateNetworkInterfacePermission",
      "ec2:ModifyNetworkInterfaceAttribute"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "elasticfilesystem:DescribeMountTargets"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "elasticloadbalancing:RegisterTargets",
      "elasticloadbalancing:DeregisterTargets"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "fsx:DescribeFileSystems"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "cloudwatch:PutMetricData"
     ],
     "Condition":{
      "StringEquals":{
       "cloudwatch:namespace":[
        "AWS/M2"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-06-07T20:26:39+00:00"
 },
 "AWSManagedServicesDeploymentToolkitPolicy":{
  "CreateDate":"2022-06-09T18:33:03+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "s3:GetBucketPolicy",
      "s3:CreateBucket",
      "s3:DeleteBucket",
      "s3:DeleteBucketPolicy",
      "s3:DeleteObject*",
      "s3:ListBucketVersions",
      "s3:PutBucketAcl",
      "s3:PutBucketLogging",
      "s3:PutBucketObjectLockConfiguration",
      "s3:PutBucketPolicy",
      "s3:PutBucketPublicAccessBlock",
      "s3:PutBucketTagging",
      "s3:PutBucketVersioning",
      "s3:PutEncryptionConfiguration"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::ams-cdktoolkit*"
    },
    {
     "Action":[
      "cloudformation:CreateChangeSet",
      "cloudformation:DeleteStack",
      "cloudformation:DescribeChangeSet",
      "cloudformation:DescribeStackResources",
      "cloudformation:DescribeStacks",
      "cloudformation:ExecuteChangeSet",
      "cloudformation:GetTemplateSummary",
      "cloudformation:UpdateTermination*"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:cloudformation:*:*:stack/ams-cdk-toolkit*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-06-09T18:33:03+00:00"
 },
 "AWSMarketplaceAmiIngestion":{
  "CreateDate":"2020-09-25T20:55:10+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:ModifySnapshotAttribute"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:us-east-1::snapshot/snap-*"
    },
    {
     "Action":[
      "ec2:DescribeImageAttribute",
      "ec2:DescribeImages",
      "ec2:DescribeSnapshotAttribute",
      "ec2:ModifyImageAttribute"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-09-25T20:55:10+00:00"
 },
 "AWSMarketplaceFullAccess":{
  "CreateDate":"2015-02-11T17:21:45+00:00",
  "DefaultVersionId":"v4",
  "Document":{
   "Statement":[
    {
     "Action":[
      "aws-marketplace:*",
      "cloudformation:CreateStack",
      "cloudformation:DescribeStackResource",
      "cloudformation:DescribeStackResources",
      "cloudformation:DescribeStacks",
      "cloudformation:List*",
      "ec2:AuthorizeSecurityGroupEgress",
      "ec2:AuthorizeSecurityGroupIngress",
      "ec2:CreateSecurityGroup",
      "ec2:CreateTags",
      "ec2:DescribeAccountAttributes",
      "ec2:DescribeAddresses",
      "ec2:DeleteSecurityGroup",
      "ec2:DescribeAccountAttributes",
      "ec2:DescribeImages",
      "ec2:DescribeInstances",
      "ec2:DescribeKeyPairs",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeSubnets",
      "ec2:DescribeTags",
      "ec2:DescribeVpcs",
      "ec2:RunInstances",
      "ec2:StartInstances",
      "ec2:StopInstances",
      "ec2:TerminateInstances"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:CopyImage",
      "ec2:DeregisterImage",
      "ec2:DescribeSnapshots",
      "ec2:DeleteSnapshot",
      "ec2:CreateImage",
      "ec2:DescribeInstanceStatus",
      "ssm:GetAutomationExecution",
      "ssm:ListDocuments",
      "ssm:DescribeDocument",
      "sns:ListTopics",
      "sns:GetTopicAttributes",
      "sns:CreateTopic",
      "iam:GetRole",
      "iam:GetInstanceProfile",
      "iam:ListRoles",
      "iam:ListInstanceProfiles"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "s3:ListBucket",
      "s3:GetObject"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::*image-build*"
     ]
    },
    {
     "Action":[
      "sns:Publish",
      "sns:setTopicAttributes"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:sns:*:*:*image-build*"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringLike":{
       "iam:PassedToService":[
        "ec2.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "ssm:StartAutomationExecution"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ssm:eu-central-1:906690553262:automation-definition/*",
      "arn:aws:ssm:us-east-1:058657716661:automation-definition/*",
      "arn:aws:ssm:ap-northeast-1:340648487307:automation-definition/*",
      "arn:aws:ssm:eu-west-1:564714592864:automation-definition/*",
      "arn:aws:ssm:us-west-2:243045473901:automation-definition/*",
      "arn:aws:ssm:ap-southeast-2:362149219987:automation-definition/*",
      "arn:aws:ssm:eu-west-2:587945719687:automation-definition/*",
      "arn:aws:ssm:us-east-2:134937423163:automation-definition/*"
     ]
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringLike":{
       "iam:AssociatedResourceARN":[
        "arn:aws:ssm:eu-central-1:906690553262:automation-definition/*",
        "arn:aws:ssm:us-east-1:058657716661:automation-definition/*",
        "arn:aws:ssm:ap-northeast-1:340648487307:automation-definition/*",
        "arn:aws:ssm:eu-west-1:564714592864:automation-definition/*",
        "arn:aws:ssm:us-west-2:243045473901:automation-definition/*",
        "arn:aws:ssm:ap-southeast-2:362149219987:automation-definition/*",
        "arn:aws:ssm:eu-west-2:587945719687:automation-definition/*",
        "arn:aws:ssm:us-east-2:134937423163:automation-definition/*"
       ],
       "iam:PassedToService":[
        "ssm.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-03-04T17:04:00+00:00"
 },
 "AWSMarketplaceGetEntitlements":{
  "CreateDate":"2017-03-27T19:37:24+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "aws-marketplace:GetEntitlements"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2017-03-27T19:37:24+00:00"
 },
 "AWSMarketplaceImageBuildFullAccess":{
  "CreateDate":"2018-07-31T23:29:49+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "aws-marketplace:ListBuilds",
      "aws-marketplace:StartBuild",
      "aws-marketplace:DescribeBuilds"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"ec2:TerminateInstances",
     "Condition":{
      "StringLike":{
       "ec2:ResourceTag/marketplace-image-build:build-id":"*"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"iam:PassRole",
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":[
        "ec2.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/*Automation*",
      "arn:aws:iam::*:role/*Instance*"
     ]
    },
    {
     "Action":[
      "ssm:GetAutomationExecution",
      "ssm:ListDocuments",
      "ssm:DescribeDocument",
      "ec2:DeregisterImage",
      "ec2:CopyImage",
      "ec2:DescribeSnapshots",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeImages",
      "ec2:DescribeSubnets",
      "ec2:DeleteSnapshot",
      "ec2:CreateImage",
      "ec2:RunInstances",
      "ec2:DescribeInstanceStatus",
      "sns:GetTopicAttributes",
      "iam:GetRole",
      "iam:GetInstanceProfile"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "s3:GetObject",
      "s3:ListBucket"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::*image-build*"
     ]
    },
    {
     "Action":[
      "ec2:CreateTags"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*::image/*",
      "arn:aws:ec2:*:*:instance/*"
     ]
    },
    {
     "Action":[
      "sns:Publish"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:sns:*:*:*image-build*"
     ]
    },
    {
     "Action":[
      "ssm:StartAutomationExecution"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ssm:eu-central-1:906690553262:automation-definition/*",
      "arn:aws:ssm:us-east-1:058657716661:automation-definition/*",
      "arn:aws:ssm:ap-northeast-1:340648487307:automation-definition/*",
      "arn:aws:ssm:eu-west-1:564714592864:automation-definition/*",
      "arn:aws:ssm:us-west-2:243045473901:automation-definition/*",
      "arn:aws:ssm:ap-southeast-2:362149219987:automation-definition/*",
      "arn:aws:ssm:eu-west-2:587945719687:automation-definition/*",
      "arn:aws:ssm:us-east-2:134937423163:automation-definition/*"
     ]
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringLike":{
       "iam:AssociatedResourceARN":[
        "arn:aws:ssm:eu-central-1:906690553262:automation-definition/*",
        "arn:aws:ssm:us-east-1:058657716661:automation-definition/*",
        "arn:aws:ssm:ap-northeast-1:340648487307:automation-definition/*",
        "arn:aws:ssm:eu-west-1:564714592864:automation-definition/*",
        "arn:aws:ssm:us-west-2:243045473901:automation-definition/*",
        "arn:aws:ssm:ap-southeast-2:362149219987:automation-definition/*",
        "arn:aws:ssm:eu-west-2:587945719687:automation-definition/*",
        "arn:aws:ssm:us-east-2:134937423163:automation-definition/*"
       ],
       "iam:PassedToService":[
        "ssm.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "ec2:CreateTags"
     ],
     "Condition":{
      "StringLike":{
       "aws:RequestTag/marketplace-image-build:build-id":"*"
      },
      "StringNotEquals":{
       "ec2:CreateAction":"RunInstances"
      }
     },
     "Effect":"Deny",
     "Resource":[
      "arn:aws:ec2:*:*:instance/*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-03-04T17:05:09+00:00"
 },
 "AWSMarketplaceLicenseManagementServiceRolePolicy":{
  "CreateDate":"2020-12-03T08:33:40+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "organizations:DescribeOrganization",
      "license-manager:ListReceivedGrants",
      "license-manager:ListDistributedGrants",
      "license-manager:GetGrant",
      "license-manager:CreateGrant",
      "license-manager:CreateGrantVersion",
      "license-manager:DeleteGrant",
      "license-manager:AcceptGrant"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"AllowLicenseManagerActions"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-12-03T08:33:40+00:00"
 },
 "AWSMarketplaceManageSubscriptions":{
  "CreateDate":"2015-02-06T18:40:32+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "aws-marketplace:ViewSubscriptions",
      "aws-marketplace:Subscribe",
      "aws-marketplace:Unsubscribe"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "aws-marketplace:CreatePrivateMarketplaceRequests",
      "aws-marketplace:ListPrivateMarketplaceRequests",
      "aws-marketplace:DescribePrivateMarketplaceRequests"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-10-28T21:49:43+00:00"
 },
 "AWSMarketplaceMeteringFullAccess":{
  "CreateDate":"2016-03-17T22:39:22+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "aws-marketplace:MeterUsage"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2016-03-17T22:39:22+00:00"
 },
 "AWSMarketplaceMeteringRegisterUsage":{
  "CreateDate":"2019-11-21T01:17:54+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "aws-marketplace:RegisterUsage"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-11-21T01:17:54+00:00"
 },
 "AWSMarketplaceProcurementSystemAdminFullAccess":{
  "CreateDate":"2019-06-25T13:07:47+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "aws-marketplace:PutProcurementSystemConfiguration",
      "aws-marketplace:DescribeProcurementSystemConfiguration",
      "organizations:Describe*",
      "organizations:List*"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-06-25T13:07:47+00:00"
 },
 "AWSMarketplacePurchaseOrdersServiceRolePolicy":{
  "CreateDate":"2021-10-27T15:12:37+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "purchase-orders:ViewPurchaseOrders",
      "purchase-orders:ModifyPurchaseOrders"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"AllowPurchaseOrderActions"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-10-27T15:12:37+00:00"
 },
 "AWSMarketplaceRead-only":{
  "CreateDate":"2015-02-06T18:40:31+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "aws-marketplace:ViewSubscriptions",
      "ec2:DescribeAccountAttributes",
      "ec2:DescribeAddresses",
      "ec2:DescribeImages",
      "ec2:DescribeInstances",
      "ec2:DescribeKeyPairs",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeSubnets",
      "ec2:DescribeVpcs"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "aws-marketplace:ListBuilds",
      "aws-marketplace:DescribeBuilds",
      "iam:ListRoles",
      "iam:ListInstanceProfiles",
      "sns:GetTopicAttributes",
      "sns:ListTopics"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "aws-marketplace:ListPrivateMarketplaceRequests",
      "aws-marketplace:DescribePrivateMarketplaceRequests"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-10-28T21:51:31+00:00"
 },
 "AWSMarketplaceSellerFullAccess":{
  "CreateDate":"2019-07-02T20:40:09+00:00",
  "DefaultVersionId":"v5",
  "Document":{
   "Statement":[
    {
     "Action":[
      "aws-marketplace-management:uploadFiles",
      "aws-marketplace-management:viewMarketing",
      "aws-marketplace-management:viewReports",
      "aws-marketplace-management:viewSupport",
      "aws-marketplace-management:viewSettings",
      "aws-marketplace:ListChangeSets",
      "aws-marketplace:DescribeChangeSet",
      "aws-marketplace:StartChangeSet",
      "aws-marketplace:CancelChangeSet",
      "aws-marketplace:ListEntities",
      "aws-marketplace:DescribeEntity",
      "aws-marketplace:ListTasks",
      "aws-marketplace:DescribeTask",
      "aws-marketplace:UpdateTask",
      "aws-marketplace:CompleteTask",
      "ec2:DescribeImages",
      "ec2:DescribeSnapshots",
      "ec2:ModifyImageAttribute",
      "ec2:ModifySnapshotAttribute"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "aws-marketplace:SearchAgreements",
      "aws-marketplace:DescribeAgreement",
      "aws-marketplace:GetAgreementTerms"
     ],
     "Condition":{
      "ForAllValues:StringEquals":{
       "aws-marketplace:AgreementType":[
        "PurchaseAgreement"
       ]
      },
      "StringEquals":{
       "aws-marketplace:PartyType":"Proposer"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "iam:GetRole"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/*"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":"assets.marketplace.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-11-30T19:26:49+00:00"
 },
 "AWSMarketplaceSellerProductsFullAccess":{
  "CreateDate":"2019-07-02T21:06:25+00:00",
  "DefaultVersionId":"v4",
  "Document":{
   "Statement":[
    {
     "Action":[
      "aws-marketplace:ListChangeSets",
      "aws-marketplace:DescribeChangeSet",
      "aws-marketplace:StartChangeSet",
      "aws-marketplace:CancelChangeSet",
      "aws-marketplace:ListEntities",
      "aws-marketplace:DescribeEntity",
      "aws-marketplace:ListTasks",
      "aws-marketplace:DescribeTask",
      "aws-marketplace:UpdateTask",
      "aws-marketplace:CompleteTask",
      "ec2:DescribeImages",
      "ec2:DescribeSnapshots",
      "ec2:ModifyImageAttribute",
      "ec2:ModifySnapshotAttribute"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "iam:GetRole"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/*"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":"assets.marketplace.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-11-26T18:50:50+00:00"
 },
 "AWSMarketplaceSellerProductsReadOnly":{
  "CreateDate":"2019-07-02T21:40:47+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "aws-marketplace:ListChangeSets",
      "aws-marketplace:DescribeChangeSet",
      "aws-marketplace:ListEntities",
      "aws-marketplace:DescribeEntity",
      "aws-marketplace:ListTasks",
      "aws-marketplace:DescribeTask",
      "ec2:DescribeImages",
      "ec2:DescribeSnapshots"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-03-05T23:11:53+00:00"
 },
 "AWSMediaTailorServiceRolePolicy":{
  "CreateDate":"2021-09-17T22:27:10+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":"logs:PutLogEvents",
     "Effect":"Allow",
     "Resource":"arn:aws:logs:*:*:log-group:MediaTailor/*:log-stream:*"
    },
    {
     "Action":[
      "logs:CreateLogStream",
      "logs:CreateLogGroup",
      "logs:DescribeLogGroups",
      "logs:DescribeLogStreams"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:logs:*:*:log-group:MediaTailor/*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-09-17T22:27:10+00:00"
 },
 "AWSMigrationHubDMSAccess":{
  "CreateDate":"2017-08-14T14:00:06+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "mgh:CreateProgressUpdateStream"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:mgh:*:*:progressUpdateStream/DMS"
    },
    {
     "Action":[
      "mgh:AssociateCreatedArtifact",
      "mgh:DescribeMigrationTask",
      "mgh:DisassociateCreatedArtifact",
      "mgh:ImportMigrationTask",
      "mgh:ListCreatedArtifacts",
      "mgh:NotifyMigrationTaskState",
      "mgh:PutResourceAttributes",
      "mgh:NotifyApplicationState",
      "mgh:DescribeApplicationState",
      "mgh:AssociateDiscoveredResource",
      "mgh:DisassociateDiscoveredResource",
      "mgh:ListDiscoveredResources"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:mgh:*:*:progressUpdateStream/DMS/*"
    },
    {
     "Action":[
      "mgh:ListMigrationTasks",
      "mgh:GetHomeRegion"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-10-07T17:51:53+00:00"
 },
 "AWSMigrationHubDiscoveryAccess":{
  "CreateDate":"2017-08-14T13:30:51+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "discovery:ListConfigurations",
      "discovery:DescribeConfigurations"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":"ec2:CreateTags",
     "Condition":{
      "ForAllValues:StringEquals":{
       "aws:TagKeys":"aws:migrationhub:source-id"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:instance/*",
      "arn:aws:ec2:*:*:image/*",
      "arn:aws:ec2:*:*:volume/*"
     ]
    },
    {
     "Action":"dms:AddTagsToResource",
     "Condition":{
      "ForAllValues:StringEquals":{
       "aws:TagKeys":"aws:migrationhub:source-id"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:dms:*:*:endpoint:*"
     ]
    },
    {
     "Action":[
      "ec2:DescribeInstanceAttribute"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-08-06T17:34:42+00:00"
 },
 "AWSMigrationHubFullAccess":{
  "CreateDate":"2017-08-14T14:02:54+00:00",
  "DefaultVersionId":"v4",
  "Document":{
   "Statement":[
    {
     "Action":[
      "mgh:*",
      "discovery:*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "iam:GetRole"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":"continuousexport.discovery.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/aws-service-role/continuousexport.discovery.amazonaws.com/AWSServiceRoleForApplicationDiscoveryServiceContinuousExport*"
    },
    {
     "Action":[
      "iam:DeleteServiceLinkedRole",
      "iam:GetServiceLinkedRoleDeletionStatus"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/aws-service-role/continuousexport.discovery.amazonaws.com/AWSServiceRoleForApplicationDiscoveryServiceContinuousExport*"
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":[
        "migrationhub.amazonaws.com",
        "dmsintegration.migrationhub.amazonaws.com",
        "smsintegration.migrationhub.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-06-19T21:14:41+00:00"
 },
 "AWSMigrationHubOrchestratorConsoleFullAccess":{
  "CreateDate":"2022-04-20T02:26:28+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "migrationhub-orchestrator:*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "s3:ListAllMyBuckets"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::*"
    },
    {
     "Action":[
      "s3:GetObject",
      "s3:GetBucketAcl",
      "s3:GetBucketLocation",
      "s3:ListBucket",
      "s3:ListBucketVersions",
      "s3:PutObject"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::migrationhub-orchestrator-*",
      "arn:aws:s3:::migrationhub-orchestrator-*/*"
     ]
    },
    {
     "Action":[
      "secretsmanager:ListSecrets"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "discovery:DescribeConfigurations",
      "discovery:ListConfigurations",
      "discovery:GetDiscoverySummary"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "mgh:GetHomeRegion"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:DescribeInstances"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "iam:ListInstanceProfiles"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "iam:CreateServiceLinkedRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":"migrationhub-orchestrator.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "iam:GetRole"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/aws-service-role/migrationhub-orchestrator.amazonaws.com/AWSServiceRoleForMigrationHubOrchestrator*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-04-20T02:26:28+00:00"
 },
 "AWSMigrationHubOrchestratorInstanceRolePolicy":{
  "CreateDate":"2022-04-20T02:43:50+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "secretsmanager:GetSecretValue"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:secretsmanager:*:*:secret:migrationhub-orchestrator-*"
    },
    {
     "Action":[
      "s3:GetObject"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::migrationhub-orchestrator-*",
      "arn:aws:s3:::aws-migrationhub-orchestrator-*/*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-04-20T02:43:50+00:00"
 },
 "AWSMigrationHubOrchestratorPlugin":{
  "CreateDate":"2022-04-20T02:25:10+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "s3:CreateBucket",
      "s3:PutObject",
      "s3:GetObject",
      "s3:GetBucketAcl"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::migrationhub-orchestrator-*"
    },
    {
     "Action":[
      "s3:ListAllMyBuckets"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::*"
    },
    {
     "Action":[
      "execute-api:Invoke",
      "execute-api:ManageConnections"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:execute-api:*:*:*/prod/*/put-log-data",
      "arn:aws:execute-api:*:*:*/prod/*/put-metric-data"
     ]
    },
    {
     "Action":[
      "migrationhub-orchestrator:RegisterPlugin",
      "migrationhub-orchestrator:GetMessage",
      "migrationhub-orchestrator:SendMessage"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:migrationhub-orchestrator:*:*:*"
    },
    {
     "Action":[
      "secretsmanager:GetSecretValue"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:secretsmanager:*:*:secret:migrationhub-orchestrator-*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-04-20T02:25:10+00:00"
 },
 "AWSMigrationHubOrchestratorServiceRolePolicy":{
  "CreateDate":"2022-04-20T02:24:04+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "discovery:DescribeConfigurations",
      "discovery:ListConfigurations"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "launchwizard:ListProvisionedApps",
      "launchwizard:DescribeProvisionedApp"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:DescribeInstances"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:CreateLaunchTemplateVersion",
      "ec2:ModifyLaunchTemplate"
     ],
     "Condition":{
      "StringEquals":{
       "aws:ResourceTag/AWSApplicationMigrationServiceManaged":"mgn.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "mgh:GetHomeRegion"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ssm:SendCommand",
      "ssm:GetCommandInvocation",
      "ssm:CancelCommand"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ssm:*::document/AWS-RunRemoteScript",
      "arn:aws:ec2:*:*:instance/*",
      "arn:aws:s3:::aws-migrationhub-orchestrator-*",
      "arn:aws:s3:::migrationhub-orchestrator-*"
     ]
    },
    {
     "Action":[
      "ssm:DescribeInstanceInformation",
      "ssm:GetCommandInvocation"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "s3:GetObject"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::migrationhub-orchestrator-*",
      "arn:aws:s3:::migrationhub-orchestrator-*/*"
     ]
    },
    {
     "Action":[
      "events:PutTargets",
      "events:DescribeRule",
      "events:DeleteRule",
      "events:PutRule"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:events:*:*:rule/MigrationHubOrchestratorManagedRule*"
    },
    {
     "Action":[
      "mgn:GetReplicationConfiguration",
      "mgn:GetLaunchConfiguration",
      "mgn:StartCutover",
      "mgn:FinalizeCutover",
      "mgn:StartTest",
      "mgn:UpdateReplicationConfiguration",
      "mgn:DescribeSourceServers",
      "mgn:MarkAsArchived",
      "mgn:ChangeServerLifeCycleState"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-04-20T02:24:04+00:00"
 },
 "AWSMigrationHubRefactorSpacesFullAccess":{
  "CreateDate":"2021-11-29T07:12:55+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "refactor-spaces:*"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"RefactorSpaces"
    },
    {
     "Action":[
      "ec2:DescribeNetworkInterfaces",
      "ec2:DescribeRouteTables",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeSubnets",
      "ec2:DescribeVpcEndpointServiceConfigurations",
      "ec2:DescribeVpcs",
      "ec2:DescribeTransitGatewayVpcAttachments",
      "ec2:DescribeTransitGateways",
      "ec2:DescribeTags",
      "ec2:DescribeTransitGateways",
      "ec2:DescribeAccountAttributes",
      "ec2:DescribeInternetGateways"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:CreateTransitGateway",
      "ec2:CreateSecurityGroup",
      "ec2:CreateTransitGatewayVpcAttachment"
     ],
     "Condition":{
      "Null":{
       "aws:RequestTag/refactor-spaces:environment-id":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:CreateTransitGateway",
      "ec2:CreateSecurityGroup",
      "ec2:CreateTransitGatewayVpcAttachment"
     ],
     "Condition":{
      "Null":{
       "aws:ResourceTag/refactor-spaces:environment-id":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:CreateVpcEndpointServiceConfiguration"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:DeleteTransitGateway",
      "ec2:AuthorizeSecurityGroupIngress",
      "ec2:RevokeSecurityGroupIngress",
      "ec2:DeleteSecurityGroup",
      "ec2:DeleteTransitGatewayVpcAttachment",
      "ec2:CreateRoute",
      "ec2:DeleteRoute",
      "ec2:DeleteTags"
     ],
     "Condition":{
      "Null":{
       "aws:ResourceTag/refactor-spaces:environment-id":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"ec2:DeleteVpcEndpointServiceConfigurations",
     "Condition":{
      "Null":{
       "aws:ResourceTag/refactor-spaces:application-id":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "elasticloadbalancing:CreateLoadBalancer"
     ],
     "Condition":{
      "Null":{
       "aws:RequestTag/refactor-spaces:application-id":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "elasticloadbalancing:DescribeLoadBalancers",
      "elasticloadbalancing:DescribeTags",
      "elasticloadbalancing:DescribeTargetHealth",
      "elasticloadbalancing:DescribeTargetGroups",
      "elasticloadbalancing:DescribeListeners"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "elasticloadbalancing:RegisterTargets",
      "elasticloadbalancing:CreateLoadBalancerListeners",
      "elasticloadbalancing:CreateListener",
      "elasticloadbalancing:DeleteListener",
      "elasticloadbalancing:DeleteTargetGroup"
     ],
     "Condition":{
      "StringLike":{
       "aws:ResourceTag/refactor-spaces:route-id":[
        "*"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"elasticloadbalancing:DeleteLoadBalancer",
     "Effect":"Allow",
     "Resource":"arn:*:elasticloadbalancing:*:*:loadbalancer/net/refactor-spaces-nlb-*"
    },
    {
     "Action":[
      "elasticloadbalancing:AddTags",
      "elasticloadbalancing:CreateListener"
     ],
     "Condition":{
      "Null":{
       "aws:RequestTag/refactor-spaces:route-id":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:*:elasticloadbalancing:*:*:loadbalancer/net/refactor-spaces-nlb-*"
    },
    {
     "Action":"elasticloadbalancing:DeleteListener",
     "Effect":"Allow",
     "Resource":"arn:*:elasticloadbalancing:*:*:listener/net/refactor-spaces-nlb-*"
    },
    {
     "Action":[
      "elasticloadbalancing:DeleteTargetGroup",
      "elasticloadbalancing:RegisterTargets"
     ],
     "Effect":"Allow",
     "Resource":"arn:*:elasticloadbalancing:*:*:targetgroup/refactor-spaces-tg-*"
    },
    {
     "Action":[
      "elasticloadbalancing:AddTags",
      "elasticloadbalancing:CreateTargetGroup"
     ],
     "Condition":{
      "Null":{
       "aws:RequestTag/refactor-spaces:route-id":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:*:elasticloadbalancing:*:*:targetgroup/refactor-spaces-tg-*"
    },
    {
     "Action":[
      "apigateway:GET",
      "apigateway:DELETE",
      "apigateway:PATCH",
      "apigateway:POST",
      "apigateway:PUT",
      "apigateway:UpdateRestApiPolicy"
     ],
     "Condition":{
      "Null":{
       "aws:ResourceTag/refactor-spaces:application-id":"false"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:apigateway:*::/restapis",
      "arn:aws:apigateway:*::/restapis/*",
      "arn:aws:apigateway:*::/vpclinks",
      "arn:aws:apigateway:*::/vpclinks/*",
      "arn:aws:apigateway:*::/tags",
      "arn:aws:apigateway:*::/tags/*"
     ]
    },
    {
     "Action":"apigateway:GET",
     "Effect":"Allow",
     "Resource":[
      "arn:aws:apigateway:*::/vpclinks",
      "arn:aws:apigateway:*::/vpclinks/*"
     ]
    },
    {
     "Action":[
      "organizations:DescribeOrganization"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "cloudformation:CreateStack"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":"refactor-spaces.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":"elasticloadbalancing.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-03-21T17:41:49+00:00"
 },
 "AWSMigrationHubRefactorSpacesServiceRolePolicy":{
  "CreateDate":"2021-11-29T06:50:15+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:DescribeNetworkInterfaces",
      "ec2:DescribeRouteTables",
      "ec2:DescribeSubnets",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeVpcEndpointServiceConfigurations",
      "ec2:DescribeTransitGatewayVpcAttachments",
      "elasticloadbalancing:DescribeTargetHealth",
      "elasticloadbalancing:DescribeListeners",
      "elasticloadbalancing:DescribeTargetGroups",
      "ram:GetResourceShareAssociations"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:AuthorizeSecurityGroupIngress",
      "ec2:RevokeSecurityGroupIngress",
      "ec2:DeleteSecurityGroup",
      "ec2:DeleteTransitGatewayVpcAttachment",
      "ec2:CreateRoute",
      "ec2:DeleteRoute",
      "ec2:DeleteTags",
      "ram:DeleteResourceShare",
      "ram:AssociateResourceShare",
      "ram:DisassociateResourceShare"
     ],
     "Condition":{
      "Null":{
       "aws:ResourceTag/refactor-spaces:environment-id":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"ec2:DeleteVpcEndpointServiceConfigurations",
     "Condition":{
      "Null":{
       "aws:ResourceTag/refactor-spaces:application-id":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "elasticloadbalancing:RegisterTargets",
      "elasticloadbalancing:CreateLoadBalancerListeners",
      "elasticloadbalancing:CreateListener",
      "elasticloadbalancing:DeleteListener",
      "elasticloadbalancing:DeleteTargetGroup"
     ],
     "Condition":{
      "StringLike":{
       "aws:ResourceTag/refactor-spaces:route-id":[
        "*"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "apigateway:PUT",
      "apigateway:POST",
      "apigateway:GET",
      "apigateway:PATCH",
      "apigateway:DELETE"
     ],
     "Condition":{
      "Null":{
       "aws:ResourceTag/refactor-spaces:application-id":"false"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:apigateway:*::/restapis",
      "arn:aws:apigateway:*::/restapis/*",
      "arn:aws:apigateway:*::/vpclinks/*",
      "arn:aws:apigateway:*::/tags",
      "arn:aws:apigateway:*::/tags/*"
     ]
    },
    {
     "Action":"apigateway:GET",
     "Effect":"Allow",
     "Resource":"arn:aws:apigateway:*::/vpclinks/*"
    },
    {
     "Action":"elasticloadbalancing:DeleteLoadBalancer",
     "Effect":"Allow",
     "Resource":"arn:*:elasticloadbalancing:*:*:loadbalancer/net/refactor-spaces-nlb-*"
    },
    {
     "Action":[
      "elasticloadbalancing:AddTags",
      "elasticloadbalancing:CreateListener"
     ],
     "Condition":{
      "Null":{
       "aws:RequestTag/refactor-spaces:route-id":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:*:elasticloadbalancing:*:*:loadbalancer/net/refactor-spaces-nlb-*"
    },
    {
     "Action":"elasticloadbalancing:DeleteListener",
     "Effect":"Allow",
     "Resource":"arn:*:elasticloadbalancing:*:*:listener/net/refactor-spaces-nlb-*"
    },
    {
     "Action":[
      "elasticloadbalancing:DeleteTargetGroup",
      "elasticloadbalancing:RegisterTargets"
     ],
     "Effect":"Allow",
     "Resource":"arn:*:elasticloadbalancing:*:*:targetgroup/refactor-spaces-tg-*"
    },
    {
     "Action":[
      "elasticloadbalancing:AddTags",
      "elasticloadbalancing:CreateTargetGroup"
     ],
     "Condition":{
      "Null":{
       "aws:RequestTag/refactor-spaces:route-id":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:*:elasticloadbalancing:*:*:targetgroup/refactor-spaces-tg-*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-11-29T06:50:15+00:00"
 },
 "AWSMigrationHubSMSAccess":{
  "CreateDate":"2017-08-14T13:57:54+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "mgh:CreateProgressUpdateStream"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:mgh:*:*:progressUpdateStream/SMS"
    },
    {
     "Action":[
      "mgh:AssociateCreatedArtifact",
      "mgh:DescribeMigrationTask",
      "mgh:DisassociateCreatedArtifact",
      "mgh:ImportMigrationTask",
      "mgh:ListCreatedArtifacts",
      "mgh:NotifyMigrationTaskState",
      "mgh:PutResourceAttributes",
      "mgh:NotifyApplicationState",
      "mgh:DescribeApplicationState",
      "mgh:AssociateDiscoveredResource",
      "mgh:DisassociateDiscoveredResource",
      "mgh:ListDiscoveredResources"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:mgh:*:*:progressUpdateStream/SMS/*"
    },
    {
     "Action":[
      "mgh:ListMigrationTasks",
      "mgh:GetHomeRegion"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-10-07T18:01:22+00:00"
 },
 "AWSMigrationHubStrategyCollector":{
  "CreateDate":"2021-10-19T20:15:15+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "s3:PutObject",
      "s3:GetBucketAcl"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::migrationhub-strategy-*"
    },
    {
     "Action":[
      "s3:ListAllMyBuckets"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::*"
    },
    {
     "Action":[
      "execute-api:Invoke",
      "execute-api:ManageConnections"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:execute-api:*:*:*/prod/*/put-log-data",
      "arn:aws:execute-api:*:*:*/prod/*/put-metric-data"
     ]
    },
    {
     "Action":[
      "migrationhub-strategy:RegisterCollector",
      "migrationhub-strategy:GetAntiPattern",
      "migrationhub-strategy:GetMessage",
      "migrationhub-strategy:SendMessage",
      "migrationhub-strategy:ListAntiPatterns",
      "migrationhub-strategy:ListJarArtifacts"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:migrationhub-strategy:*:*:*"
    },
    {
     "Action":[
      "secretsmanager:GetSecretValue"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:secretsmanager:*:*:secret:migrationhub-strategy-*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-10-19T20:15:15+00:00"
 },
 "AWSMigrationHubStrategyConsoleFullAccess":{
  "CreateDate":"2021-10-19T20:13:26+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "migrationhub-strategy:*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "s3:ListAllMyBuckets"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::*"
    },
    {
     "Action":[
      "s3:GetObject",
      "s3:CreateBucket",
      "s3:PutEncryptionConfiguration",
      "s3:PutBucketPublicAccessBlock",
      "s3:PutBucketPolicy",
      "s3:PutBucketVersioning",
      "s3:PutLifecycleConfiguration"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::migrationhub-strategy-*"
    },
    {
     "Action":[
      "secretsmanager:ListSecrets"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "discovery:GetDiscoverySummary"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "iam:CreateServiceLinkedRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":"migrationhub-strategy.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "iam:GetRole"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/aws-service-role/migrationhub-strategy.amazonaws.com/AWSMigrationHubStrategyServiceRolePolicy*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-10-19T20:13:26+00:00"
 },
 "AWSMigrationHubStrategyServiceRolePolicy":{
  "CreateDate":"2021-10-19T20:02:37+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "discovery:ListConfigurations",
      "discovery:DescribeConfigurations",
      "mgh:GetHomeRegion"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"permissionsForAds"
    },
    {
     "Action":[
      "s3:ListAllMyBuckets"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::*"
    },
    {
     "Action":[
      "s3:GetBucketAcl",
      "s3:GetBucketLocation",
      "s3:GetObject",
      "s3:ListBucket",
      "s3:PutObject",
      "s3:PutObjectAcl"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::migrationhub-strategy-*",
     "Sid":"permissionsForS3"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-10-19T20:02:37+00:00"
 },
 "AWSMobileHub_FullAccess":{
  "CreateDate":"2016-01-05T19:56:01+00:00",
  "DefaultVersionId":"v14",
  "Document":{
   "Statement":[
    {
     "Action":[
      "apigateway:GET",
      "apigateway:POST",
      "cloudfront:GetDistribution",
      "devicefarm:CreateProject",
      "devicefarm:ListJobs",
      "devicefarm:ListRuns",
      "devicefarm:GetProject",
      "devicefarm:GetRun",
      "devicefarm:ListArtifacts",
      "devicefarm:ListProjects",
      "devicefarm:ScheduleRun",
      "dynamodb:DescribeTable",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeSubnets",
      "ec2:DescribeVpcs",
      "iam:ListSAMLProviders",
      "lambda:ListFunctions",
      "sns:ListTopics",
      "lex:GetIntent",
      "lex:GetIntents",
      "lex:GetSlotType",
      "lex:GetSlotTypes",
      "lex:GetBot",
      "lex:GetBots",
      "lex:GetBotAlias",
      "lex:GetBotAliases",
      "mobilehub:*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "s3:GetObject"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::*/aws-my-sample-app*.zip"
    },
    {
     "Action":[
      "s3:PutObject"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::*-mobilehub-*/*"
    },
    {
     "Action":[
      "s3:ListBucket"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::*-mobilehub-*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-12-19T23:15:52+00:00"
 },
 "AWSMobileHub_ReadOnly":{
  "CreateDate":"2016-01-05T19:55:48+00:00",
  "DefaultVersionId":"v10",
  "Document":{
   "Statement":[
    {
     "Action":[
      "dynamodb:DescribeTable",
      "iam:ListSAMLProviders",
      "lambda:ListFunctions",
      "sns:ListTopics",
      "lex:GetIntent",
      "lex:GetIntents",
      "lex:GetSlotType",
      "lex:GetSlotTypes",
      "lex:GetBot",
      "lex:GetBots",
      "lex:GetBotAlias",
      "lex:GetBotAliases",
      "mobilehub:ExportProject",
      "mobilehub:GenerateProjectParameters",
      "mobilehub:GetProject",
      "mobilehub:SynchronizeProject",
      "mobilehub:GetProjectSnapshot",
      "mobilehub:ListProjectSnapshots",
      "mobilehub:ListAvailableConnectors",
      "mobilehub:ListAvailableFeatures",
      "mobilehub:ListAvailableRegions",
      "mobilehub:ListProjects",
      "mobilehub:ValidateProject",
      "mobilehub:VerifyServiceRole",
      "mobilehub:DescribeBundle",
      "mobilehub:ExportBundle",
      "mobilehub:ListBundles"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "s3:GetObject"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::*/aws-my-sample-app*.zip"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2018-07-23T21:59:05+00:00"
 },
 "AWSNetworkFirewallServiceRolePolicy":{
  "CreateDate":"2020-11-17T17:17:26+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:DescribeSubnets",
      "ec2:DescribeVpcs",
      "ec2:CreateVpcEndpoint",
      "ec2:DescribeVpcEndpoints"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:CreateTags"
     ],
     "Condition":{
      "StringEquals":{
       "aws:RequestTag/AWSNetworkFirewallManaged":"true",
       "ec2:CreateAction":"CreateVpcEndpoint"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:vpc-endpoint/*"
    },
    {
     "Action":[
      "ec2:DeleteVpcEndpoints"
     ],
     "Condition":{
      "StringEquals":{
       "aws:ResourceTag/AWSNetworkFirewallManaged":"true"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-11-17T17:17:26+00:00"
 },
 "AWSNetworkManagerFullAccess":{
  "CreateDate":"2019-12-03T17:37:58+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":"networkmanager:*",
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":[
        "networkmanager.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-12-03T17:37:58+00:00"
 },
 "AWSNetworkManagerReadOnlyAccess":{
  "CreateDate":"2019-12-03T17:35:05+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "networkmanager:Describe*",
      "networkmanager:Get*",
      "networkmanager:List*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-12-03T17:35:05+00:00"
 },
 "AWSNetworkManagerServiceRolePolicy":{
  "CreateDate":"2019-12-03T14:03:35+00:00",
  "DefaultVersionId":"v6",
  "Document":{
   "Statement":[
    {
     "Action":[
      "directconnect:DescribeDirectConnectGateways",
      "directconnect:DescribeConnections",
      "directconnect:DescribeDirectConnectGatewayAttachments",
      "directconnect:DescribeLocations",
      "directconnect:DescribeVirtualInterfaces",
      "ec2:DescribeCustomerGateways",
      "ec2:DescribeTransitGatewayAttachments",
      "ec2:DescribeTransitGatewayRouteTables",
      "ec2:DescribeTransitGateways",
      "ec2:DescribeVpnConnections",
      "ec2:DescribeVpcs",
      "ec2:GetTransitGatewayRouteTableAssociations",
      "ec2:SearchTransitGatewayRoutes",
      "ec2:DescribeTransitGatewayPeeringAttachments",
      "ec2:DescribeTransitGatewayConnects",
      "ec2:DescribeTransitGatewayConnectPeers",
      "ec2:DescribeRegions",
      "organizations:DescribeAccount",
      "organizations:DescribeOrganization",
      "organizations:ListAccounts",
      "organizations:ListAWSServiceAccessForOrganization",
      "organizations:ListDelegatedAdministrators"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-05-24T14:42:03+00:00"
 },
 "AWSOpsWorksCMInstanceProfileRole":{
  "CreateDate":"2016-11-24T09:48:22+00:00",
  "DefaultVersionId":"v5",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cloudformation:DescribeStackResource",
      "cloudformation:SignalResource"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "s3:AbortMultipartUpload",
      "s3:DeleteObject",
      "s3:GetObject",
      "s3:ListAllMyBuckets",
      "s3:ListBucket",
      "s3:ListMultipartUploadParts",
      "s3:PutObject"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::aws-opsworks-cm-*"
    },
    {
     "Action":"acm:GetCertificate",
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"secretsmanager:GetSecretValue",
     "Effect":"Allow",
     "Resource":"arn:aws:secretsmanager:*:*:opsworks-cm!aws-opsworks-cm-secrets-*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-04-23T17:34:03+00:00"
 },
 "AWSOpsWorksCMServiceRole":{
  "CreateDate":"2016-11-24T09:49:46+00:00",
  "DefaultVersionId":"v14",
  "Document":{
   "Statement":[
    {
     "Action":[
      "s3:CreateBucket",
      "s3:DeleteObject",
      "s3:DeleteBucket",
      "s3:GetObject",
      "s3:ListBucket",
      "s3:PutBucketPolicy",
      "s3:PutObject",
      "s3:GetBucketTagging",
      "s3:PutBucketTagging"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::aws-opsworks-cm-*"
     ]
    },
    {
     "Action":[
      "tag:UntagResources",
      "tag:TagResources"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "ssm:DescribeInstanceInformation",
      "ssm:GetCommandInvocation",
      "ssm:ListCommandInvocations",
      "ssm:ListCommands"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "ssm:SendCommand"
     ],
     "Condition":{
      "StringLike":{
       "ssm:resourceTag/aws:cloudformation:stack-name":"aws-opsworks-cm-*"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "ssm:SendCommand"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ssm:*::document/*",
      "arn:aws:s3:::aws-opsworks-cm-*"
     ]
    },
    {
     "Action":[
      "ec2:AllocateAddress",
      "ec2:AssociateAddress",
      "ec2:AuthorizeSecurityGroupIngress",
      "ec2:CreateImage",
      "ec2:CreateSecurityGroup",
      "ec2:CreateSnapshot",
      "ec2:CreateTags",
      "ec2:DeleteSecurityGroup",
      "ec2:DeleteSnapshot",
      "ec2:DeregisterImage",
      "ec2:DescribeAccountAttributes",
      "ec2:DescribeAddresses",
      "ec2:DescribeImages",
      "ec2:DescribeInstanceStatus",
      "ec2:DescribeInstances",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeSnapshots",
      "ec2:DescribeSubnets",
      "ec2:DisassociateAddress",
      "ec2:ReleaseAddress",
      "ec2:RunInstances",
      "ec2:StopInstances"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "ec2:TerminateInstances",
      "ec2:RebootInstances"
     ],
     "Condition":{
      "StringLike":{
       "ec2:ResourceTag/aws:cloudformation:stack-name":"aws-opsworks-cm-*"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "opsworks-cm:DeleteServer",
      "opsworks-cm:StartMaintenance"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:opsworks-cm:*:*:server/*"
     ]
    },
    {
     "Action":[
      "cloudformation:CreateStack",
      "cloudformation:DeleteStack",
      "cloudformation:DescribeStackEvents",
      "cloudformation:DescribeStackResources",
      "cloudformation:DescribeStacks",
      "cloudformation:UpdateStack"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:cloudformation:*:*:stack/aws-opsworks-cm-*"
     ]
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/aws-opsworks-cm-*",
      "arn:aws:iam::*:role/service-role/aws-opsworks-cm-*"
     ]
    },
    {
     "Action":[
      "acm:DeleteCertificate",
      "acm:ImportCertificate"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "secretsmanager:CreateSecret",
      "secretsmanager:GetSecretValue",
      "secretsmanager:UpdateSecret",
      "secretsmanager:DeleteSecret",
      "secretsmanager:TagResource",
      "secretsmanager:UntagResource"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:secretsmanager:*:*:opsworks-cm!aws-opsworks-cm-secrets-*"
    },
    {
     "Action":"ec2:DeleteTags",
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:instance/*",
      "arn:aws:ec2:*:*:elastic-ip/*",
      "arn:aws:ec2:*:*:security-group/*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-04-23T17:32:13+00:00"
 },
 "AWSOpsWorksCloudWatchLogs":{
  "CreateDate":"2017-03-30T17:47:19+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "logs:CreateLogGroup",
      "logs:CreateLogStream",
      "logs:PutLogEvents",
      "logs:DescribeLogStreams"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:logs:*:*:*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2017-03-30T17:47:19+00:00"
 },
 "AWSOpsWorksInstanceRegistration":{
  "CreateDate":"2016-06-03T14:23:15+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "opsworks:DescribeStackProvisioningParameters",
      "opsworks:DescribeStacks",
      "opsworks:RegisterInstance"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2016-06-03T14:23:15+00:00"
 },
 "AWSOpsWorksRegisterCLI_EC2":{
  "CreateDate":"2019-06-18T15:56:17+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "opsworks:AssignInstance",
      "opsworks:CreateLayer",
      "opsworks:DeregisterInstance",
      "opsworks:DescribeInstances",
      "opsworks:DescribeStackProvisioningParameters",
      "opsworks:DescribeStacks",
      "opsworks:UnassignInstance"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "ec2:DescribeInstances"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-06-18T15:56:17+00:00"
 },
 "AWSOpsWorksRegisterCLI_OnPremises":{
  "CreateDate":"2019-06-18T15:33:16+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "opsworks:AssignInstance",
      "opsworks:CreateLayer",
      "opsworks:DeregisterInstance",
      "opsworks:DescribeInstances",
      "opsworks:DescribeStackProvisioningParameters",
      "opsworks:DescribeStacks",
      "opsworks:UnassignInstance"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "ec2:DescribeInstances"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "iam:CreateGroup",
      "iam:AddUserToGroup"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:group/AWS/OpsWorks/OpsWorks-*"
     ]
    },
    {
     "Action":[
      "iam:CreateUser",
      "iam:CreateAccessKey"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:user/AWS/OpsWorks/OpsWorks-*"
     ]
    },
    {
     "Action":[
      "iam:AttachUserPolicy"
     ],
     "Condition":{
      "ArnEquals":{
       "iam:PolicyARN":"arn:aws:iam::aws:policy/AWSOpsWorksInstanceRegistration"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:user/AWS/OpsWorks/OpsWorks-*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-06-18T15:33:16+00:00"
 },
 "AWSOpsWorks_FullAccess":{
  "CreateDate":"2021-01-22T16:29:08+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cloudwatch:GetMetricStatistics",
      "ec2:DescribeAccountAttributes",
      "ec2:DescribeAvailabilityZones",
      "ec2:DescribeInstances",
      "ec2:DescribeKeyPairs",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeSubnets",
      "ec2:DescribeVpcs",
      "elasticloadbalancing:DescribeInstanceHealth",
      "elasticloadbalancing:DescribeLoadBalancers",
      "iam:GetRolePolicy",
      "iam:ListInstanceProfiles",
      "iam:ListRoles",
      "iam:ListUsers",
      "opsworks:*"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":"opsworks.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-01-22T16:29:08+00:00"
 },
 "AWSOrganizationsFullAccess":{
  "CreateDate":"2018-11-06T20:31:57+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":"organizations:*",
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "account:PutAlternateContact",
      "account:DeleteAlternateContact",
      "account:GetAlternateContact"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-02-07T18:26:04+00:00"
 },
 "AWSOrganizationsReadOnlyAccess":{
  "CreateDate":"2018-11-06T20:32:38+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "organizations:Describe*",
      "organizations:List*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "account:GetAlternateContact"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-02-07T18:17:19+00:00"
 },
 "AWSOrganizationsServiceTrustPolicy":{
  "CreateDate":"2017-10-10T23:04:07+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iam:DeleteRole"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/aws-service-role/organizations.amazonaws.com/*"
     ],
     "Sid":"AllowDeletionOfServiceLinkedRoleForOrganizations"
    },
    {
     "Action":[
      "iam:CreateServiceLinkedRole"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AllowCreationOfServiceLinkedRoles"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2017-11-01T06:01:18+00:00"
 },
 "AWSOutpostsServiceRolePolicy":{
  "CreateDate":"2020-11-09T22:55:56+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:DescribeNetworkInterfaces",
      "ec2:DescribeSecurityGroups",
      "ec2:CreateNetworkInterface",
      "ec2:CreateSecurityGroup"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-11-09T22:55:56+00:00"
 },
 "AWSPanoramaApplianceRolePolicy":{
  "CreateDate":"2020-12-01T13:13:18+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "logs:CreateLogStream",
      "logs:DescribeLogStreams",
      "logs:PutLogEvents"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:logs:*:*:log-group:/aws/panorama_device*:log-stream:*",
     "Sid":"PanoramaDeviceCreateLogStream"
    },
    {
     "Action":"logs:CreateLogGroup",
     "Effect":"Allow",
     "Resource":"arn:aws:logs:*:*:log-group:/aws/panorama_device*",
     "Sid":"PanoramaDeviceCreateLogGroup"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-12-01T13:13:18+00:00"
 },
 "AWSPanoramaApplianceServiceRolePolicy":{
  "CreateDate":"2021-10-20T12:14:03+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "logs:CreateLogStream",
      "logs:DescribeLogStreams",
      "logs:PutLogEvents"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:logs:*:*:log-group:/aws/panorama_device*:log-stream:*",
      "arn:aws:logs:*:*:log-group:/aws/panorama/devices/*"
     ],
     "Sid":"PanoramaDeviceCreateLogStream"
    },
    {
     "Action":"logs:CreateLogGroup",
     "Effect":"Allow",
     "Resource":[
      "arn:aws:logs:*:*:log-group:/aws/panorama_device*",
      "arn:aws:logs:*:*:log-group:/aws/panorama/devices/*"
     ],
     "Sid":"PanoramaDeviceCreateLogGroup"
    },
    {
     "Action":"cloudwatch:PutMetricData",
     "Condition":{
      "StringEquals":{
       "cloudwatch:namespace":"PanoramaDeviceMetrics"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"PanoramaDevicePutMetric"
    },
    {
     "Action":[
      "s3:GetObject",
      "s3:ListBucket"
     ],
     "Condition":{
      "StringLike":{
       "s3:DataAccessPointArn":"arn:aws:s3:*:*:accesspoint/panorama*"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"PanoramaDeviceS3Access"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-10-20T12:14:03+00:00"
 },
 "AWSPanoramaFullAccess":{
  "CreateDate":"2020-12-01T13:12:47+00:00",
  "DefaultVersionId":"v4",
  "Document":{
   "Statement":[
    {
     "Action":[
      "panorama:*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "s3:PutObject",
      "s3:PutObjectAcl",
      "s3:DeleteObject",
      "s3:GetObject",
      "s3:ListBucket"
     ],
     "Condition":{
      "StringLike":{
       "s3:DataAccessPointArn":"arn:aws:s3:*:*:accesspoint/panorama*"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "secretsmanager:GetSecretValue",
      "secretsmanager:DescribeSecret",
      "secretsmanager:ListSecretVersionIds",
      "secretsmanager:PutSecretValue",
      "secretsmanager:UpdateSecret"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:secretsmanager:*:*:secret:panorama*",
      "arn:aws:secretsmanager:*:*:secret:Panorama*"
     ]
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":"panorama.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "logs:Describe*",
      "logs:Get*",
      "logs:List*",
      "logs:StartQuery",
      "logs:StopQuery",
      "logs:TestMetricFilter",
      "logs:FilterLogEvents"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:logs:*:*:log-group:/aws/panorama_device*:log-stream:*",
      "arn:aws:logs:*:*:log-group:/aws/panorama/devices/*"
     ]
    },
    {
     "Action":[
      "logs:DescribeLogGroups"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:logs:*:*:log-group:*"
     ]
    },
    {
     "Action":[
      "cloudwatch:ListMetrics",
      "cloudwatch:GetMetricData",
      "cloudwatch:GetMetricStatistics"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"iam:ListRoles",
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":"panorama.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-01-12T21:21:04+00:00"
 },
 "AWSPanoramaGreengrassGroupRolePolicy":{
  "CreateDate":"2020-12-01T13:10:22+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "s3:ListBucket",
      "s3:GetBucket*",
      "s3:GetObject",
      "s3:PutObject"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::*aws-panorama*"
     ],
     "Sid":"PanoramaS3Access"
    },
    {
     "Action":"cloudwatch:PutDashboard",
     "Effect":"Allow",
     "Resource":[
      "arn:aws:cloudwatch::*:dashboard/panorama*"
     ],
     "Sid":"PanoramaCLoudWatchPutDashboard"
    },
    {
     "Action":"cloudwatch:PutMetricData",
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"PanoramaCloudWatchPutMetricData"
    },
    {
     "Action":[
      "logs:CreateLogStream",
      "logs:DescribeLogStreams",
      "logs:PutLogEvents",
      "logs:CreateLogGroup"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:logs:*:*:log-group:/aws/greengrass/*",
     "Sid":"PanoramaGreenGrassCloudWatchAccess"
    },
    {
     "Action":[
      "panorama:*"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"PanoramaAccess"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-01-06T19:30:35+00:00"
 },
 "AWSPanoramaSageMakerRolePolicy":{
  "CreateDate":"2020-12-01T13:13:54+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "s3:GetObject",
      "s3:PutObject",
      "s3:GetBucket*"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::*aws-panorama*"
     ],
     "Sid":"PanoramaSageMakerS3Access"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-12-01T13:13:54+00:00"
 },
 "AWSPanoramaServiceLinkedRolePolicy":{
  "CreateDate":"2021-10-20T12:12:50+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iot:CreateThing",
      "iot:DeleteThing",
      "iot:DeleteThingShadow",
      "iot:DescribeThing",
      "iot:GetThingShadow",
      "iot:UpdateThing",
      "iot:UpdateThingShadow"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iot:*:*:thing/panorama*"
     ],
     "Sid":"PanoramaIoTThingAccess"
    },
    {
     "Action":[
      "iot:AttachThingPrincipal",
      "iot:DetachThingPrincipal",
      "iot:UpdateCertificate",
      "iot:DeleteCertificate",
      "iot:AttachPrincipalPolicy",
      "iot:DetachPrincipalPolicy"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iot:*:*:thing/panorama*",
      "arn:aws:iot:*:*:cert/*"
     ],
     "Sid":"PanoramaIoTCertificateAccess"
    },
    {
     "Action":[
      "iot:CreateKeysAndCertificate"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"PanoramaIoTCreateCertificateAccess"
    },
    {
     "Action":[
      "iot:CreatePolicy",
      "iot:CreatePolicyVersion",
      "iot:AttachPolicy"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iot:*:*:policy/panorama*"
     ],
     "Sid":"PanoramaIoTCreatePolicyAndVersionAccess"
    },
    {
     "Action":[
      "iot:DescribeJobExecution",
      "iot:CreateJob",
      "iot:DeleteJob"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iot:*:*:job/panorama*",
      "arn:aws:iot:*:*:thing/panorama*"
     ],
     "Sid":"PanoramaIoTJobAccess"
    },
    {
     "Action":[
      "iot:DescribeEndpoint"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"PanoramaIoTEndpointAccess"
    },
    {
     "Action":[
      "panorama:Describe*",
      "panorama:List*"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"PanoramaReadOnlyAccess"
    },
    {
     "Action":[
      "secretsmanager:GetSecretValue",
      "secretsmanager:DescribeSecret",
      "secretsmanager:CreateSecret",
      "secretsmanager:ListSecretVersionIds",
      "secretsmanager:DeleteSecret"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:secretsmanager:*:*:secret:panorama*",
      "arn:aws:secretsmanager:*:*:secret:Panorama*"
     ],
     "Sid":"SecretsManagerPermissions"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-10-20T12:12:50+00:00"
 },
 "AWSPanoramaServiceRolePolicy":{
  "CreateDate":"2020-12-01T13:14:43+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iot:CreateThing",
      "iot:DeleteThing",
      "iot:DeleteThingShadow",
      "iot:DescribeThing",
      "iot:GetThingShadow",
      "iot:UpdateThing",
      "iot:UpdateThingShadow"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iot:*:*:thing/panorama*"
     ],
     "Sid":"PanoramaIoTThingAccess"
    },
    {
     "Action":[
      "iot:AttachThingPrincipal",
      "iot:DetachThingPrincipal",
      "iot:UpdateCertificate",
      "iot:DeleteCertificate",
      "iot:AttachPrincipalPolicy",
      "iot:DetachPrincipalPolicy"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iot:*:*:thing/panorama*",
      "arn:aws:iot:*:*:cert/*"
     ],
     "Sid":"PanoramaIoTCertificateAccess"
    },
    {
     "Action":[
      "iot:CreateKeysAndCertificate",
      "iot:CreatePolicy"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"PanoramaIoTCreateCertificateAndPolicyAccess"
    },
    {
     "Action":[
      "iot:CreatePolicyVersion"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iot:*:*:policy/panorama*"
     ],
     "Sid":"PanoramaIoTCreatePolicyVersionAccess"
    },
    {
     "Action":[
      "iot:DescribeJobExecution",
      "iot:CreateJob",
      "iot:DeleteJob"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iot:*:*:job/panorama*",
      "arn:aws:iot:*:*:thing/panorama*"
     ],
     "Sid":"PanoramaIoTJobAccess"
    },
    {
     "Action":[
      "iot:DescribeEndpoint"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"PanoramaIoTEndpointAccess"
    },
    {
     "Action":[
      "panorama:Describe*",
      "panorama:List*",
      "panorama:Get*"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"PanoramaAccess"
    },
    {
     "Action":[
      "s3:GetObject",
      "s3:PutObject",
      "s3:DeleteObject",
      "s3:DeleteBucket",
      "s3:ListBucket",
      "s3:GetBucket*",
      "s3:CreateBucket"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::*aws-panorama*"
     ],
     "Sid":"PanoramaS3Access"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":[
        "sagemaker.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/AWSPanoramaSageMakerRole",
      "arn:aws:iam::*:role/service-role/AWSPanoramaSageMakerRole"
     ],
     "Sid":"PanoramaIAMPassSageMakerRoleAccess"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":[
        "greengrass.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/AWSPanoramaGreengrassGroupRole",
      "arn:aws:iam::*:role/service-role/AWSPanoramaGreengrassGroupRole",
      "arn:aws:iam::*:role/AWSPanoramaGreengrassRole",
      "arn:aws:iam::*:role/service-role/AWSPanoramaGreengrassRole"
     ],
     "Sid":"PanoramaIAMPassGreengrassRoleAccess"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringEqualsIfExists":{
       "iam:PassedToService":"iot.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/AWSPanoramaApplianceRole",
      "arn:aws:iam::*:role/service-role/AWSPanoramaApplianceRole"
     ],
     "Sid":"PanoramaIAMPassIoTRoleAccess"
    },
    {
     "Action":[
      "greengrass:AssociateRoleToGroup",
      "greengrass:AssociateServiceRoleToAccount",
      "greengrass:CreateResourceDefinition",
      "greengrass:CreateResourceDefinitionVersion",
      "greengrass:CreateCoreDefinition",
      "greengrass:CreateCoreDefinitionVersion",
      "greengrass:CreateDeployment",
      "greengrass:CreateFunctionDefinition",
      "greengrass:CreateFunctionDefinitionVersion",
      "greengrass:CreateGroup",
      "greengrass:CreateGroupCertificateAuthority",
      "greengrass:CreateGroupVersion",
      "greengrass:CreateLoggerDefinition",
      "greengrass:CreateLoggerDefinitionVersion",
      "greengrass:CreateSubscriptionDefinition",
      "greengrass:CreateSubscriptionDefinitionVersion",
      "greengrass:DeleteCoreDefinition",
      "greengrass:DeleteFunctionDefinition",
      "greengrass:DeleteResourceDefinition",
      "greengrass:DeleteGroup",
      "greengrass:DeleteLoggerDefinition",
      "greengrass:DeleteSubscriptionDefinition",
      "greengrass:DisassociateRoleFromGroup",
      "greengrass:DisassociateServiceRoleFromAccount",
      "greengrass:GetAssociatedRole",
      "greengrass:GetConnectivityInfo",
      "greengrass:GetCoreDefinition",
      "greengrass:GetCoreDefinitionVersion",
      "greengrass:GetDeploymentStatus",
      "greengrass:GetDeviceDefinition",
      "greengrass:GetDeviceDefinitionVersion",
      "greengrass:GetFunctionDefinition",
      "greengrass:GetFunctionDefinitionVersion",
      "greengrass:GetGroup",
      "greengrass:GetGroupCertificateAuthority",
      "greengrass:GetGroupCertificateConfiguration",
      "greengrass:GetGroupVersion",
      "greengrass:GetLoggerDefinition",
      "greengrass:GetLoggerDefinitionVersion",
      "greengrass:GetResourceDefinition",
      "greengrass:GetServiceRoleForAccount",
      "greengrass:GetSubscriptionDefinition",
      "greengrass:GetSubscriptionDefinitionVersion",
      "greengrass:ListCoreDefinitionVersions",
      "greengrass:ListCoreDefinitions",
      "greengrass:ListDeployments",
      "greengrass:ListDeviceDefinitionVersions",
      "greengrass:ListDeviceDefinitions",
      "greengrass:ListFunctionDefinitionVersions",
      "greengrass:ListFunctionDefinitions",
      "greengrass:ListGroupCertificateAuthorities",
      "greengrass:ListGroupVersions",
      "greengrass:ListGroups",
      "greengrass:ListLoggerDefinitionVersions",
      "greengrass:ListLoggerDefinitions",
      "greengrass:ListSubscriptionDefinitionVersions",
      "greengrass:ListSubscriptionDefinitions",
      "greengrass:ResetDeployments",
      "greengrass:UpdateConnectivityInfo",
      "greengrass:UpdateCoreDefinition",
      "greengrass:UpdateDeviceDefinition",
      "greengrass:UpdateFunctionDefinition",
      "greengrass:UpdateGroup",
      "greengrass:UpdateGroupCertificateConfiguration",
      "greengrass:UpdateLoggerDefinition",
      "greengrass:UpdateSubscriptionDefinition",
      "greengrass:UpdateResourceDefinition"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"PanoramaGreenGrassAccess"
    },
    {
     "Action":[
      "lambda:GetFunction",
      "lambda:GetFunctionConfiguration",
      "lambda:ListFunctions",
      "lambda:ListVersionsByFunction"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:lambda:*:*:function:*"
     ],
     "Sid":"PanoramaLambdaUsersFunctionAccess"
    },
    {
     "Action":[
      "sagemaker:CreateTrainingJob",
      "sagemaker:StopTrainingJob",
      "sagemaker:CreateCompilationJob",
      "sagemaker:DescribeCompilationJob",
      "sagemaker:StopCompilationJob"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:sagemaker:*:*:training-job/panorama*",
      "arn:aws:sagemaker:*:*:compilation-job/panorama*"
     ],
     "Sid":"PanoramaSageMakerWriteAccess"
    },
    {
     "Action":[
      "sagemaker:ListCompilationJobs"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"PanoramaSageMakerListAccess"
    },
    {
     "Action":[
      "sagemaker:DescribeTrainingJob"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:sagemaker:*:*:training-job/*"
     ],
     "Sid":"PanoramaSageMakerReadAccess"
    },
    {
     "Action":[
      "iot:AttachPolicy",
      "iot:CreateRoleAlias"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iot:*:*:policy/panorama*",
      "arn:aws:iot:*:*:rolealias/panorama*"
     ],
     "Sid":"PanoramaCWLogsAccess"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-12-01T13:14:43+00:00"
 },
 "AWSPriceListServiceFullAccess":{
  "CreateDate":"2017-11-22T00:36:27+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "pricing:*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2017-11-22T00:36:27+00:00"
 },
 "AWSPrivateMarketplaceAdminFullAccess":{
  "CreateDate":"2018-11-27T16:32:32+00:00",
  "DefaultVersionId":"v4",
  "Document":{
   "Statement":[
    {
     "Action":[
      "aws-marketplace:AssociateProductsWithPrivateMarketplace",
      "aws-marketplace:DisassociateProductsFromPrivateMarketplace",
      "aws-marketplace:ListPrivateMarketplaceRequests",
      "aws-marketplace:DescribePrivateMarketplaceRequests"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "aws-marketplace:ListEntities",
      "aws-marketplace:DescribeEntity",
      "aws-marketplace:StartChangeSet",
      "aws-marketplace:ListChangeSets",
      "aws-marketplace:DescribeChangeSet",
      "aws-marketplace:CancelChangeSet"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-08-27T15:34:07+00:00"
 },
 "AWSPrivateMarketplaceRequests":{
  "CreateDate":"2019-10-28T21:44:03+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "aws-marketplace:CreatePrivateMarketplaceRequests",
      "aws-marketplace:ListPrivateMarketplaceRequests",
      "aws-marketplace:DescribePrivateMarketplaceRequests"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-10-28T21:44:03+00:00"
 },
 "AWSPrivateNetworksServiceRolePolicy":{
  "CreateDate":"2021-12-16T23:17:46+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cloudwatch:PutMetricData"
     ],
     "Condition":{
      "StringEquals":{
       "cloudwatch:namespace":"AWS/Private5G"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-12-16T23:17:46+00:00"
 },
 "AWSProtonDeveloperAccess":{
  "CreateDate":"2021-02-17T19:02:08+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "codecommit:ListRepositories",
      "codepipeline:GetPipeline",
      "codepipeline:GetPipelineExecution",
      "codepipeline:GetPipelineState",
      "codepipeline:ListPipelineExecutions",
      "codepipeline:ListPipelines",
      "codestar-connections:ListConnections",
      "codestar-connections:UseConnection",
      "proton:CancelServiceInstanceDeployment",
      "proton:CancelServicePipelineDeployment",
      "proton:CreateService",
      "proton:DeleteService",
      "proton:GetAccountRoles",
      "proton:GetAccountSettings",
      "proton:GetEnvironment",
      "proton:GetEnvironmentAccountConnection",
      "proton:GetEnvironmentTemplate",
      "proton:GetEnvironmentTemplateMajorVersion",
      "proton:GetEnvironmentTemplateMinorVersion",
      "proton:GetEnvironmentTemplateVersion",
      "proton:GetRepository",
      "proton:GetRepositorySyncStatus",
      "proton:GetService",
      "proton:GetServiceInstance",
      "proton:GetServiceTemplate",
      "proton:GetServiceTemplateMajorVersion",
      "proton:GetServiceTemplateMinorVersion",
      "proton:GetServiceTemplateVersion",
      "proton:GetTemplateSyncConfig",
      "proton:GetTemplateSyncStatus",
      "proton:ListEnvironmentAccountConnections",
      "proton:ListEnvironmentOutputs",
      "proton:ListEnvironmentProvisionedResources",
      "proton:ListEnvironments",
      "proton:ListEnvironmentTemplateMajorVersions",
      "proton:ListEnvironmentTemplateMinorVersions",
      "proton:ListEnvironmentTemplates",
      "proton:ListEnvironmentTemplateVersions",
      "proton:ListRepositories",
      "proton:ListRepositorySyncDefinitions",
      "proton:ListServiceInstanceOutputs",
      "proton:ListServiceInstanceProvisionedResources",
      "proton:ListServiceInstances",
      "proton:ListServicePipelineOutputs",
      "proton:ListServicePipelineProvisionedResources",
      "proton:ListServices",
      "proton:ListServiceTemplateMajorVersions",
      "proton:ListServiceTemplateMinorVersions",
      "proton:ListServiceTemplates",
      "proton:ListServiceTemplateVersions",
      "proton:ListTagsForResource",
      "proton:UpdateService",
      "proton:UpdateServiceInstance",
      "proton:UpdateServicePipeline",
      "s3:ListAllMyBuckets",
      "s3:ListBucket"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"codestar-connections:PassConnection",
     "Condition":{
      "StringEquals":{
       "codestar-connections:PassedToService":"proton.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:codestar-connections:*:*:connection/*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-04-21T12:57:14+00:00"
 },
 "AWSProtonFullAccess":{
  "CreateDate":"2021-02-17T19:07:18+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "proton:*",
      "codestar-connections:ListConnections",
      "kms:ListAliases",
      "kms:DescribeKey"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "kms:CreateGrant"
     ],
     "Condition":{
      "StringLike":{
       "kms:ViaService":"proton.*.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":"proton.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":"sync.proton.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/aws-service-role/sync.proton.amazonaws.com/AWSServiceRoleForProtonSync"
    },
    {
     "Action":[
      "codestar-connections:PassConnection"
     ],
     "Condition":{
      "StringEquals":{
       "codestar-connections:PassedToService":"proton.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:codestar-connections:*:*:connection/*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-06-20T12:36:26+00:00"
 },
 "AWSProtonReadOnlyAccess":{
  "CreateDate":"2021-02-17T19:09:12+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "codepipeline:ListPipelineExecutions",
      "codepipeline:ListPipelines",
      "codepipeline:GetPipeline",
      "codepipeline:GetPipelineState",
      "codepipeline:GetPipelineExecution",
      "proton:GetAccountRoles",
      "proton:GetAccountSettings",
      "proton:GetEnvironment",
      "proton:GetEnvironmentAccountConnection",
      "proton:GetEnvironmentTemplate",
      "proton:GetEnvironmentTemplateMajorVersion",
      "proton:GetEnvironmentTemplateMinorVersion",
      "proton:GetEnvironmentTemplateVersion",
      "proton:GetRepository",
      "proton:GetRepositorySyncStatus",
      "proton:GetService",
      "proton:GetServiceInstance",
      "proton:GetServiceTemplate",
      "proton:GetServiceTemplateMajorVersion",
      "proton:GetServiceTemplateMinorVersion",
      "proton:GetServiceTemplateVersion",
      "proton:GetTemplateSyncConfig",
      "proton:GetTemplateSyncStatus",
      "proton:ListEnvironmentAccountConnections",
      "proton:ListEnvironmentOutputs",
      "proton:ListEnvironmentProvisionedResources",
      "proton:ListEnvironments",
      "proton:ListEnvironmentTemplateMajorVersions",
      "proton:ListEnvironmentTemplateMinorVersions",
      "proton:ListEnvironmentTemplates",
      "proton:ListEnvironmentTemplateVersions",
      "proton:ListRepositories",
      "proton:ListRepositorySyncDefinitions",
      "proton:ListServiceInstanceOutputs",
      "proton:ListServiceInstanceProvisionedResources",
      "proton:ListServiceInstances",
      "proton:ListServicePipelineOutputs",
      "proton:ListServicePipelineProvisionedResources",
      "proton:ListServices",
      "proton:ListServiceTemplateMajorVersions",
      "proton:ListServiceTemplateMinorVersions",
      "proton:ListServiceTemplates",
      "proton:ListServiceTemplateVersions",
      "proton:ListTagsForResource"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-04-21T12:33:42+00:00"
 },
 "AWSProtonSyncServiceRolePolicy":{
  "CreateDate":"2021-11-23T21:14:36+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "proton:UpdateServiceTemplateVersion",
      "proton:UpdateServiceTemplate",
      "proton:UpdateEnvironmentTemplateVersion",
      "proton:UpdateEnvironmentTemplate",
      "proton:GetServiceTemplateVersion",
      "proton:GetServiceTemplate",
      "proton:GetEnvironmentTemplateVersion",
      "proton:GetEnvironmentTemplate",
      "proton:DeleteServiceTemplateVersion",
      "proton:DeleteEnvironmentTemplateVersion",
      "proton:CreateServiceTemplateVersion",
      "proton:CreateServiceTemplate",
      "proton:CreateEnvironmentTemplateVersion",
      "proton:CreateEnvironmentTemplate",
      "proton:ListEnvironmentTemplateVersions",
      "proton:ListServiceTemplateVersions",
      "proton:CreateEnvironmentTemplateMajorVersion",
      "proton:CreateServiceTemplateMajorVersion"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"SyncToProton"
    },
    {
     "Action":[
      "codestar-connections:UseConnection"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:codestar-connections:*:*:connection/*",
     "Sid":"AccessGitRepos"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-11-23T21:14:36+00:00"
 },
 "AWSPurchaseOrdersServiceRolePolicy":{
  "CreateDate":"2020-05-06T18:15:47+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "aws-portal:*Billing",
      "purchase-orders:*PurchaseOrders"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-11-22T20:06:47+00:00"
 },
 "AWSQuickSightDescribeRDS":{
  "CreateDate":"2015-11-10T23:24:50+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "rds:Describe*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2015-11-10T23:24:50+00:00"
 },
 "AWSQuickSightDescribeRedshift":{
  "CreateDate":"2015-11-10T23:25:01+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "redshift:Describe*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2015-11-10T23:25:01+00:00"
 },
 "AWSQuickSightElasticsearchPolicy":{
  "CreateDate":"2020-09-09T17:27:19+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "es:ESHttpGet"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:es:*:*:domain/*/",
      "arn:aws:es:*:*:domain/*/_cluster/settings",
      "arn:aws:es:*:*:domain/*/_cat/indices"
     ]
    },
    {
     "Action":"es:ListDomainNames",
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "es:DescribeElasticsearchDomain",
      "es:DescribeDomain"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:es:*:*:domain/*"
     ]
    },
    {
     "Action":[
      "es:ESHttpPost",
      "es:ESHttpGet"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:es:*:*:domain/*/_opendistro/_sql",
      "arn:aws:es:*:*:domain/*/_plugin/_sql"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-09-07T23:25:55+00:00"
 },
 "AWSQuickSightIoTAnalyticsAccess":{
  "CreateDate":"2017-11-29T17:00:54+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iotanalytics:ListDatasets",
      "iotanalytics:DescribeDataset",
      "iotanalytics:GetDatasetContent"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2017-11-29T17:00:54+00:00"
 },
 "AWSQuickSightListIAM":{
  "CreateDate":"2015-11-10T23:25:07+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iam:List*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2015-11-10T23:25:07+00:00"
 },
 "AWSQuickSightSageMakerPolicy":{
  "CreateDate":"2020-01-17T17:18:13+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "sagemaker:DescribeTransformJob",
      "sagemaker:StopTransformJob",
      "sagemaker:CreateTransformJob"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:sagemaker:*:*:transform-job/quicksight-auto-generated-*"
    },
    {
     "Action":"sagemaker:ListModels",
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"s3:GetObject",
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::quicksight-ml.*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-01-17T17:18:13+00:00"
 },
 "AWSQuickSightTimestreamPolicy":{
  "CreateDate":"2020-09-30T21:47:03+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "timestream:Select",
      "timestream:CancelQuery",
      "timestream:ListTables",
      "timestream:ListDatabases",
      "timestream:ListMeasures",
      "timestream:DescribeTable",
      "timestream:DescribeDatabase",
      "timestream:SelectValues",
      "timestream:DescribeEndpoints"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-09-30T21:47:03+00:00"
 },
 "AWSQuicksightAthenaAccess":{
  "CreateDate":"2016-12-09T02:31:03+00:00",
  "DefaultVersionId":"v10",
  "Document":{
   "Statement":[
    {
     "Action":[
      "athena:BatchGetQueryExecution",
      "athena:CancelQueryExecution",
      "athena:GetCatalogs",
      "athena:GetExecutionEngine",
      "athena:GetExecutionEngines",
      "athena:GetNamespace",
      "athena:GetNamespaces",
      "athena:GetQueryExecution",
      "athena:GetQueryExecutions",
      "athena:GetQueryResults",
      "athena:GetQueryResultsStream",
      "athena:GetTable",
      "athena:GetTables",
      "athena:ListQueryExecutions",
      "athena:RunQuery",
      "athena:StartQueryExecution",
      "athena:StopQueryExecution",
      "athena:ListWorkGroups",
      "athena:ListEngineVersions",
      "athena:GetWorkGroup",
      "athena:GetDataCatalog",
      "athena:GetDatabase",
      "athena:GetTableMetadata",
      "athena:ListDataCatalogs",
      "athena:ListDatabases",
      "athena:ListTableMetadata"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "glue:CreateDatabase",
      "glue:DeleteDatabase",
      "glue:GetDatabase",
      "glue:GetDatabases",
      "glue:UpdateDatabase",
      "glue:CreateTable",
      "glue:DeleteTable",
      "glue:BatchDeleteTable",
      "glue:UpdateTable",
      "glue:GetTable",
      "glue:GetTables",
      "glue:BatchCreatePartition",
      "glue:CreatePartition",
      "glue:DeletePartition",
      "glue:BatchDeletePartition",
      "glue:UpdatePartition",
      "glue:GetPartition",
      "glue:GetPartitions",
      "glue:BatchGetPartition"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "s3:GetBucketLocation",
      "s3:GetObject",
      "s3:ListBucket",
      "s3:ListBucketMultipartUploads",
      "s3:ListMultipartUploadParts",
      "s3:AbortMultipartUpload",
      "s3:CreateBucket",
      "s3:PutObject",
      "s3:PutBucketPublicAccessBlock"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::aws-athena-query-results-*"
     ]
    },
    {
     "Action":[
      "lakeformation:GetDataAccess"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-07-07T20:09:06+00:00"
 },
 "AWSQuicksightOpenSearchPolicy":{
  "CreateDate":"2021-09-07T23:26:19+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "es:ESHttpGet"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:es:*:*:domain/*/",
      "arn:aws:es:*:*:domain/*/_cluster/settings",
      "arn:aws:es:*:*:domain/*/_cat/indices"
     ]
    },
    {
     "Action":"es:ListDomainNames",
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "es:DescribeDomain"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:es:*:*:domain/*"
     ]
    },
    {
     "Action":[
      "es:ESHttpPost",
      "es:ESHttpGet"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:es:*:*:domain/*/_opendistro/_sql",
      "arn:aws:es:*:*:domain/*/_plugin/_sql"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-09-07T23:26:19+00:00"
 },
 "AWSResourceAccessManagerFullAccess":{
  "CreateDate":"2019-06-04T17:28:22+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ram:*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-06-04T17:28:22+00:00"
 },
 "AWSResourceAccessManagerReadOnlyAccess":{
  "CreateDate":"2019-12-09T20:58:37+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ram:Get*",
      "ram:List*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-12-09T20:58:37+00:00"
 },
 "AWSResourceAccessManagerResourceShareParticipantAccess":{
  "CreateDate":"2019-12-09T20:41:37+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ram:AcceptResourceShareInvitation",
      "ram:GetResourcePolicies",
      "ram:GetResourceShareInvitations",
      "ram:GetResourceShares",
      "ram:ListPendingInvitationResources",
      "ram:ListPrincipals",
      "ram:ListResources",
      "ram:RejectResourceShareInvitation"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-12-09T20:41:37+00:00"
 },
 "AWSResourceAccessManagerServiceRolePolicy":{
  "CreateDate":"2018-11-14T19:28:28+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "organizations:DescribeAccount",
      "organizations:DescribeOrganization",
      "organizations:DescribeOrganizationalUnit",
      "organizations:ListAccounts",
      "organizations:ListAccountsForParent",
      "organizations:ListChildren",
      "organizations:ListOrganizationalUnitsForParent",
      "organizations:ListParents",
      "organizations:ListRoots"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "iam:DeleteRole"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/aws-service-role/ram.amazonaws.com/*"
     ],
     "Sid":"AllowDeletionOfServiceLinkedRoleForResourceAccessManager"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2018-11-14T19:28:28+00:00"
 },
 "AWSResourceGroupsReadOnlyAccess":{
  "CreateDate":"2018-03-07T10:27:04+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "resource-groups:Get*",
      "resource-groups:List*",
      "resource-groups:Search*",
      "tag:Get*",
      "cloudformation:DescribeStacks",
      "cloudformation:ListStackResources",
      "ec2:DescribeInstances",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeSnapshots",
      "ec2:DescribeVolumes",
      "ec2:DescribeVpcs",
      "elasticache:DescribeCacheClusters",
      "elasticache:DescribeSnapshots",
      "elasticache:ListTagsForResource",
      "elasticbeanstalk:DescribeEnvironments",
      "elasticmapreduce:DescribeCluster",
      "elasticmapreduce:ListClusters",
      "glacier:ListVaults",
      "glacier:DescribeVault",
      "glacier:ListTagsForVault",
      "kinesis:ListStreams",
      "kinesis:DescribeStream",
      "kinesis:ListTagsForStream",
      "opsworks:DescribeStacks",
      "opsworks:ListTags",
      "rds:DescribeDBInstances",
      "rds:DescribeDBSnapshots",
      "rds:ListTagsForResource",
      "redshift:DescribeClusters",
      "redshift:DescribeTags",
      "route53domains:ListDomains",
      "route53:ListHealthChecks",
      "route53:GetHealthCheck",
      "route53:ListHostedZones",
      "route53:GetHostedZone",
      "route53:ListTagsForResource",
      "storagegateway:ListGateways",
      "storagegateway:DescribeGatewayInformation",
      "storagegateway:ListTagsForResource",
      "s3:ListAllMyBuckets",
      "s3:GetBucketTagging",
      "elasticloadbalancing:DescribeLoadBalancers",
      "elasticloadbalancing:DescribeTags",
      "ssm:ListDocuments"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-02-05T17:56:25+00:00"
 },
 "AWSRoboMakerReadOnlyAccess":{
  "CreateDate":"2018-11-26T05:30:50+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "robomaker:List*",
      "robomaker:BatchDescribe*",
      "robomaker:Describe*",
      "robomaker:Get*"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"VisualEditor0"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-08-28T23:10:18+00:00"
 },
 "AWSRoboMakerServicePolicy":{
  "CreateDate":"2018-11-26T06:30:08+00:00",
  "DefaultVersionId":"v6",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:CreateNetworkInterfacePermission",
      "ec2:DescribeNetworkInterfaces",
      "ec2:DeleteNetworkInterface",
      "ec2:DescribeSubnets",
      "ec2:DescribeVpcs",
      "ec2:DescribeSecurityGroups",
      "greengrass:CreateDeployment",
      "greengrass:CreateGroupVersion",
      "greengrass:CreateFunctionDefinition",
      "greengrass:CreateFunctionDefinitionVersion",
      "greengrass:GetDeploymentStatus",
      "greengrass:GetGroup",
      "greengrass:GetGroupVersion",
      "greengrass:GetCoreDefinitionVersion",
      "greengrass:GetFunctionDefinitionVersion",
      "greengrass:GetAssociatedRole",
      "lambda:CreateFunction",
      "robomaker:CreateSimulationJob",
      "robomaker:CancelSimulationJob"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "robomaker:TagResource"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:robomaker:*:*:simulation-job/*"
    },
    {
     "Action":[
      "lambda:UpdateFunctionCode",
      "lambda:GetFunction",
      "lambda:UpdateFunctionConfiguration",
      "lambda:DeleteFunction",
      "lambda:ListVersionsByFunction",
      "lambda:GetAlias",
      "lambda:UpdateAlias",
      "lambda:CreateAlias",
      "lambda:DeleteAlias"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:lambda:*:*:function:aws-robomaker-*"
    },
    {
     "Action":"iam:PassRole",
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":[
        "lambda.amazonaws.com",
        "robomaker.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-11-11T22:23:45+00:00"
 },
 "AWSRoboMakerServiceRolePolicy":{
  "CreateDate":"2018-11-26T05:33:19+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:CreateNetworkInterfacePermission",
      "ec2:DescribeNetworkInterfaces",
      "ec2:DeleteNetworkInterface",
      "ec2:DescribeSubnets",
      "ec2:DescribeVpcs",
      "ec2:DescribeSecurityGroups",
      "greengrass:CreateDeployment",
      "greengrass:CreateGroupVersion",
      "greengrass:CreateFunctionDefinition",
      "greengrass:CreateFunctionDefinitionVersion",
      "greengrass:GetDeploymentStatus",
      "greengrass:GetGroup",
      "greengrass:GetGroupVersion",
      "greengrass:GetCoreDefinitionVersion",
      "greengrass:GetFunctionDefinitionVersion",
      "greengrass:GetAssociatedRole",
      "lambda:CreateFunction"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "lambda:UpdateFunctionCode",
      "lambda:GetFunction",
      "lambda:UpdateFunctionConfiguration"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:lambda:*:*:function:aws-robomaker-*"
    },
    {
     "Action":"iam:PassRole",
     "Condition":{
      "StringEqualsIfExists":{
       "iam:PassedToService":"lambda.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2018-11-26T05:33:19+00:00"
 },
 "AWSRoboMaker_FullAccess":{
  "CreateDate":"2020-09-10T18:34:18+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":"robomaker:*",
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"s3:GetObject",
     "Condition":{
      "StringEquals":{
       "aws:CalledViaFirst":"robomaker.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"ecr:BatchGetImage",
     "Condition":{
      "StringEquals":{
       "aws:CalledViaFirst":"robomaker.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"ecr-public:DescribeImages",
     "Condition":{
      "StringEquals":{
       "aws:CalledViaFirst":"robomaker.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":"robomaker.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-09-16T21:06:10+00:00"
 },
 "AWSSSMOpsInsightsServiceRolePolicy":{
  "CreateDate":"2021-06-16T20:12:52+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ssm:CreateOpsItem",
      "ssm:AddTagsToResource"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AllowCreateOpsItem"
    },
    {
     "Action":[
      "ssm:UpdateOpsItem",
      "ssm:GetOpsItem"
     ],
     "Condition":{
      "StringEquals":{
       "aws:ResourceTag/SsmOperationalInsight":"true"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AllowAccessOpsItem"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-06-16T20:12:52+00:00"
 },
 "AWSSSODirectoryAdministrator":{
  "CreateDate":"2018-10-31T23:54:00+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "sso-directory:*",
      "identitystore:*",
      "sso:ListDirectoryAssociations"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AWSSSODirectoryAdministrator"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-03-25T20:31:19+00:00"
 },
 "AWSSSODirectoryReadOnly":{
  "CreateDate":"2018-10-31T23:49:32+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "sso-directory:Search*",
      "sso-directory:Describe*",
      "sso-directory:List*",
      "sso-directory:Get*",
      "identitystore:Describe*",
      "identitystore:List*"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AWSSSODirectoryReadOnly"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-03-25T20:57:20+00:00"
 },
 "AWSSSOMasterAccountAdministrator":{
  "CreateDate":"2018-06-27T20:36:51+00:00",
  "DefaultVersionId":"v6",
  "Document":{
   "Statement":[
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringLike":{
       "iam:AWSServiceName":"sso.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/aws-service-role/sso.amazonaws.com/AWSServiceRoleForSSO",
     "Sid":"AWSSSOCreateSLR"
    },
    {
     "Action":"iam:PassRole",
     "Condition":{
      "StringLike":{
       "iam:PassedToService":"sso.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/aws-service-role/sso.amazonaws.com/AWSServiceRoleForSSO",
     "Sid":"AWSSSOMasterAccountAdministrator"
    },
    {
     "Action":[
      "ds:DescribeTrusts",
      "ds:UnauthorizeApplication",
      "ds:DescribeDirectories",
      "ds:AuthorizeApplication",
      "iam:ListPolicies",
      "organizations:EnableAWSServiceAccess",
      "organizations:ListRoots",
      "organizations:ListAccounts",
      "organizations:ListOrganizationalUnitsForParent",
      "organizations:ListAccountsForParent",
      "organizations:DescribeOrganization",
      "organizations:ListChildren",
      "organizations:DescribeAccount",
      "organizations:ListParents",
      "sso:*",
      "sso-directory:*",
      "identitystore:*",
      "ds:CreateAlias",
      "access-analyzer:ValidatePolicy"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AWSSSOMemberAccountAdministrator"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-04-28T18:38:55+00:00"
 },
 "AWSSSOMemberAccountAdministrator":{
  "CreateDate":"2018-06-27T20:45:42+00:00",
  "DefaultVersionId":"v5",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ds:DescribeDirectories",
      "ds:AuthorizeApplication",
      "ds:UnauthorizeApplication",
      "ds:DescribeTrusts",
      "iam:ListPolicies",
      "organizations:EnableAWSServiceAccess",
      "organizations:DescribeOrganization",
      "organizations:DescribeAccount",
      "organizations:ListRoots",
      "organizations:ListAccounts",
      "organizations:ListAccountsForParent",
      "organizations:ListParents",
      "organizations:ListChildren",
      "organizations:ListOrganizationalUnitsForParent",
      "sso:*",
      "sso-directory:*",
      "identitystore:*",
      "ds:CreateAlias",
      "access-analyzer:ValidatePolicy"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AWSSSOMemberAccountAdministrator"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-04-28T18:53:46+00:00"
 },
 "AWSSSOReadOnly":{
  "CreateDate":"2018-06-27T20:24:34+00:00",
  "DefaultVersionId":"v7",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ds:DescribeDirectories",
      "ds:DescribeTrusts",
      "iam:ListPolicies",
      "organizations:DescribeOrganization",
      "organizations:DescribeAccount",
      "organizations:ListParents",
      "organizations:ListChildren",
      "organizations:ListAccounts",
      "organizations:ListRoots",
      "organizations:ListAccountsForParent",
      "organizations:ListOrganizationalUnitsForParent",
      "sso:Describe*",
      "sso:Get*",
      "sso:List*",
      "sso:Search*",
      "sso-directory:DescribeDirectory",
      "access-analyzer:ValidatePolicy"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AWSSSOReadOnly"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-04-28T18:46:11+00:00"
 },
 "AWSSSOServiceRolePolicy":{
  "CreateDate":"2017-12-05T18:36:15+00:00",
  "DefaultVersionId":"v15",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iam:AttachRolePolicy",
      "iam:CreateRole",
      "iam:PutRolePolicy",
      "iam:UpdateRole",
      "iam:UpdateRoleDescription",
      "iam:UpdateAssumeRolePolicy"
     ],
     "Condition":{
      "StringNotEquals":{
       "aws:PrincipalOrgMasterAccountId":"${aws:PrincipalAccount}"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/aws-reserved/sso.amazonaws.com/*"
     ],
     "Sid":"IAMRoleProvisioningActions"
    },
    {
     "Action":[
      "iam:GetRole",
      "iam:ListRoles"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"IAMRoleReadActions"
    },
    {
     "Action":[
      "iam:DeleteRole",
      "iam:DeleteRolePolicy",
      "iam:DetachRolePolicy",
      "iam:ListRolePolicies",
      "iam:ListAttachedRolePolicies"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/aws-reserved/sso.amazonaws.com/*"
     ],
     "Sid":"IAMRoleCleanupActions"
    },
    {
     "Action":[
      "iam:DeleteServiceLinkedRole",
      "iam:GetServiceLinkedRoleDeletionStatus",
      "iam:DeleteRole",
      "iam:GetRole"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/aws-service-role/sso.amazonaws.com/AWSServiceRoleForSSO"
     ],
     "Sid":"IAMSLRCleanupActions"
    },
    {
     "Action":[
      "iam:CreateSAMLProvider",
      "iam:UpdateSAMLProvider"
     ],
     "Condition":{
      "StringNotEquals":{
       "aws:PrincipalOrgMasterAccountId":"${aws:PrincipalAccount}"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:saml-provider/AWSSSO_*"
     ],
     "Sid":"IAMSAMLProviderProvisioningActions"
    },
    {
     "Action":[
      "iam:DeleteSAMLProvider",
      "iam:GetSAMLProvider"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:saml-provider/AWSSSO_*"
     ],
     "Sid":"IAMSAMLProviderCleanupActions"
    },
    {
     "Action":[
      "organizations:DescribeAccount",
      "organizations:DescribeOrganization",
      "organizations:ListAccounts",
      "organizations:ListDelegatedAdministrators",
      "organizations:ListAWSServiceAccessForOrganization"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "ds:UnauthorizeApplication"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"AllowUnauthAppForDirectory"
    },
    {
     "Action":[
      "ds:DescribeDirectories",
      "ds:DescribeTrusts"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"AllowDescribeForDirectory"
    },
    {
     "Action":[
      "identitystore:DescribeUser",
      "identitystore:DescribeGroup",
      "identitystore:ListGroups",
      "identitystore:ListUsers"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"AllowDescribeAndListOperationsOnIdentitySource"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-05-12T21:14:40+00:00"
 },
 "AWSSavingsPlansFullAccess":{
  "CreateDate":"2019-11-06T22:45:18+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":"savingsplans:*",
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-11-06T22:45:18+00:00"
 },
 "AWSSavingsPlansReadOnlyAccess":{
  "CreateDate":"2019-11-06T22:45:10+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "savingsplans:Describe*",
      "savingsplans:List*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-11-06T22:45:10+00:00"
 },
 "AWSSecurityHubFullAccess":{
  "CreateDate":"2018-11-27T23:54:34+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":"securityhub:*",
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringLike":{
       "iam:AWSServiceName":"securityhub.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2018-11-27T23:54:34+00:00"
 },
 "AWSSecurityHubOrganizationsAccess":{
  "CreateDate":"2021-03-15T20:53:03+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "organizations:ListAccounts",
      "organizations:DescribeOrganization"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"organizations:EnableAWSServiceAccess",
     "Condition":{
      "StringEquals":{
       "organizations:ServicePrincipal":"securityhub.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "organizations:RegisterDelegatedAdministrator",
      "organizations:DeregisterDelegatedAdministrator"
     ],
     "Condition":{
      "StringEquals":{
       "organizations:ServicePrincipal":"securityhub.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:organizations::*:account/o-*/*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-03-15T20:53:03+00:00"
 },
 "AWSSecurityHubReadOnlyAccess":{
  "CreateDate":"2018-11-28T01:34:29+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "securityhub:Get*",
      "securityhub:List*",
      "securityhub:BatchGet*",
      "securityhub:Describe*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-04-04T17:46:51+00:00"
 },
 "AWSSecurityHubServiceRolePolicy":{
  "CreateDate":"2018-11-27T23:47:51+00:00",
  "DefaultVersionId":"v9",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cloudtrail:DescribeTrails",
      "cloudtrail:GetTrailStatus",
      "cloudtrail:GetEventSelectors",
      "cloudwatch:DescribeAlarms",
      "cloudwatch:DescribeAlarmsForMetric",
      "logs:DescribeMetricFilters",
      "sns:ListSubscriptionsByTopic",
      "config:DescribeConfigurationRecorders",
      "config:DescribeConfigurationRecorderStatus",
      "config:DescribeConfigRules",
      "config:BatchGetResourceConfig",
      "config:SelectResourceConfig",
      "iam:GenerateCredentialReport",
      "iam:GetCredentialReport",
      "organizations:ListAccounts",
      "organizations:DescribeAccount",
      "organizations:DescribeOrganization",
      "config:PutEvaluations"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "config:PutConfigRule",
      "config:DeleteConfigRule",
      "config:GetComplianceDetailsByConfigRule",
      "config:DescribeConfigRuleEvaluationStatus"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:config:*:*:config-rule/aws-service-rule/*securityhub*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-07-14T20:32:48+00:00"
 },
 "AWSServiceCatalogAdminFullAccess":{
  "CreateDate":"2018-02-15T17:19:40+00:00",
  "DefaultVersionId":"v5",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cloudformation:CreateStack",
      "cloudformation:DeleteStack",
      "cloudformation:DescribeStackEvents",
      "cloudformation:DescribeStacks",
      "cloudformation:SetStackPolicy",
      "cloudformation:UpdateStack",
      "cloudformation:CreateChangeSet",
      "cloudformation:DescribeChangeSet",
      "cloudformation:ExecuteChangeSet",
      "cloudformation:ListChangeSets",
      "cloudformation:DeleteChangeSet",
      "cloudformation:ListStackResources",
      "cloudformation:TagResource",
      "cloudformation:CreateStackSet",
      "cloudformation:CreateStackInstances",
      "cloudformation:UpdateStackSet",
      "cloudformation:UpdateStackInstances",
      "cloudformation:DeleteStackSet",
      "cloudformation:DeleteStackInstances",
      "cloudformation:DescribeStackSet",
      "cloudformation:DescribeStackInstance",
      "cloudformation:DescribeStackSetOperation",
      "cloudformation:ListStackInstances",
      "cloudformation:ListStackSetOperations",
      "cloudformation:ListStackSetOperationResults"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:cloudformation:*:*:stack/SC-*",
      "arn:aws:cloudformation:*:*:stack/StackSet-SC-*",
      "arn:aws:cloudformation:*:*:changeSet/SC-*",
      "arn:aws:cloudformation:*:*:stackset/SC-*"
     ]
    },
    {
     "Action":[
      "cloudformation:CreateUploadBucket",
      "cloudformation:GetTemplateSummary",
      "cloudformation:ValidateTemplate",
      "iam:GetGroup",
      "iam:GetRole",
      "iam:GetUser",
      "iam:ListGroups",
      "iam:ListRoles",
      "iam:ListUsers",
      "servicecatalog:*",
      "ssm:DescribeDocument",
      "ssm:GetAutomationExecution",
      "ssm:ListDocuments",
      "ssm:ListDocumentVersions",
      "config:DescribeConfigurationRecorders",
      "config:DescribeConfigurationRecorderStatus"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"iam:PassRole",
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":"servicecatalog.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-02-06T01:57:54+00:00"
 },
 "AWSServiceCatalogAdminReadOnlyAccess":{
  "CreateDate":"2019-10-25T18:53:38+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cloudformation:DescribeStackEvents",
      "cloudformation:DescribeStacks",
      "cloudformation:DescribeChangeSet",
      "cloudformation:ListChangeSets",
      "cloudformation:ListStackResources",
      "cloudformation:DescribeStackSet",
      "cloudformation:DescribeStackInstance",
      "cloudformation:DescribeStackSetOperation",
      "cloudformation:ListStackInstances",
      "cloudformation:ListStackSetOperations",
      "cloudformation:ListStackSetOperationResults"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:cloudformation:*:*:stack/SC-*",
      "arn:aws:cloudformation:*:*:stack/StackSet-SC-*",
      "arn:aws:cloudformation:*:*:changeSet/SC-*",
      "arn:aws:cloudformation:*:*:stackset/SC-*"
     ]
    },
    {
     "Action":[
      "cloudformation:GetTemplateSummary",
      "iam:GetGroup",
      "iam:GetRole",
      "iam:GetUser",
      "iam:ListGroups",
      "iam:ListRoles",
      "iam:ListUsers",
      "servicecatalog:Get*",
      "servicecatalog:List*",
      "servicecatalog:Describe*",
      "servicecatalog:ScanProvisionedProducts",
      "servicecatalog:Search*",
      "ssm:DescribeDocument",
      "ssm:GetAutomationExecution",
      "ssm:ListDocuments",
      "ssm:ListDocumentVersions",
      "config:DescribeConfigurationRecorders",
      "config:DescribeConfigurationRecorderStatus"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-10-25T18:53:38+00:00"
 },
 "AWSServiceCatalogAppRegistryFullAccess":{
  "CreateDate":"2020-11-12T22:25:58+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cloudformation:UpdateStack"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:CalledVia":"servicecatalog-appregistry.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":"servicecatalog-appregistry.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/aws-service-role/servicecatalog-appregistry.amazonaws.com/AWSServiceRoleForAWSServiceCatalogAppRegistry*"
    },
    {
     "Action":[
      "cloudformation:DescribeStacks",
      "servicecatalog:CreateApplication",
      "servicecatalog:GetApplication",
      "servicecatalog:UpdateApplication",
      "servicecatalog:DeleteApplication",
      "servicecatalog:ListApplications",
      "servicecatalog:AssociateResource",
      "servicecatalog:DisassociateResource",
      "servicecatalog:GetAssociatedResource",
      "servicecatalog:ListAssociatedResources",
      "servicecatalog:AssociateAttributeGroup",
      "servicecatalog:DisassociateAttributeGroup",
      "servicecatalog:ListAssociatedAttributeGroups",
      "servicecatalog:CreateAttributeGroup",
      "servicecatalog:UpdateAttributeGroup",
      "servicecatalog:DeleteAttributeGroup",
      "servicecatalog:GetAttributeGroup",
      "servicecatalog:ListAttributeGroups",
      "servicecatalog:SyncResource",
      "servicecatalog:ListAttributeGroupsForApplication"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "servicecatalog:ListTagsForResource",
      "servicecatalog:UntagResource",
      "servicecatalog:TagResource"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:servicecatalog:*:*:*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-06-15T22:01:01+00:00"
 },
 "AWSServiceCatalogAppRegistryReadOnlyAccess":{
  "CreateDate":"2020-11-12T22:34:32+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "servicecatalog:GetApplication",
      "servicecatalog:ListApplications",
      "servicecatalog:GetAssociatedResource",
      "servicecatalog:ListAssociatedResources",
      "servicecatalog:ListAssociatedAttributeGroups",
      "servicecatalog:GetAttributeGroup",
      "servicecatalog:ListAttributeGroups",
      "servicecatalog:ListTagsForResource",
      "servicecatalog:ListAttributeGroupsForApplication"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-06-15T20:20:31+00:00"
 },
 "AWSServiceCatalogAppRegistryServiceRolePolicy":{
  "CreateDate":"2021-05-18T22:18:55+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":"cloudformation:DescribeStacks",
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "resource-groups:CreateGroup",
      "resource-groups:Tag"
     ],
     "Condition":{
      "StringEquals":{
       "aws:RequestTag/EnableAWSServiceCatalogAppRegistry":"true"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "resource-groups:DeleteGroup",
      "resource-groups:UpdateGroup",
      "resource-groups:GetGroup",
      "resource-groups:GetTags",
      "resource-groups:Tag",
      "resource-groups:Untag",
      "resource-groups:GetGroupConfiguration"
     ],
     "Condition":{
      "StringEquals":{
       "aws:ResourceTag/EnableAWSServiceCatalogAppRegistry":"true"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-03-04T21:06:44+00:00"
 },
 "AWSServiceCatalogEndUserFullAccess":{
  "CreateDate":"2018-02-15T17:22:32+00:00",
  "DefaultVersionId":"v7",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cloudformation:CreateStack",
      "cloudformation:DeleteStack",
      "cloudformation:DescribeStackEvents",
      "cloudformation:DescribeStacks",
      "cloudformation:SetStackPolicy",
      "cloudformation:ValidateTemplate",
      "cloudformation:UpdateStack",
      "cloudformation:CreateChangeSet",
      "cloudformation:DescribeChangeSet",
      "cloudformation:ExecuteChangeSet",
      "cloudformation:ListChangeSets",
      "cloudformation:DeleteChangeSet",
      "cloudformation:TagResource",
      "cloudformation:CreateStackSet",
      "cloudformation:CreateStackInstances",
      "cloudformation:UpdateStackSet",
      "cloudformation:UpdateStackInstances",
      "cloudformation:DeleteStackSet",
      "cloudformation:DeleteStackInstances",
      "cloudformation:DescribeStackSet",
      "cloudformation:DescribeStackInstance",
      "cloudformation:DescribeStackSetOperation",
      "cloudformation:ListStackInstances",
      "cloudformation:ListStackResources",
      "cloudformation:ListStackSetOperations",
      "cloudformation:ListStackSetOperationResults"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:cloudformation:*:*:stack/SC-*",
      "arn:aws:cloudformation:*:*:stack/StackSet-SC-*",
      "arn:aws:cloudformation:*:*:changeSet/SC-*",
      "arn:aws:cloudformation:*:*:stackset/SC-*"
     ]
    },
    {
     "Action":[
      "cloudformation:GetTemplateSummary",
      "servicecatalog:DescribeProduct",
      "servicecatalog:DescribeProductView",
      "servicecatalog:DescribeProvisioningParameters",
      "servicecatalog:ListLaunchPaths",
      "servicecatalog:ProvisionProduct",
      "servicecatalog:SearchProducts",
      "ssm:DescribeDocument",
      "ssm:GetAutomationExecution",
      "config:DescribeConfigurationRecorders",
      "config:DescribeConfigurationRecorderStatus"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "servicecatalog:DescribeProvisionedProduct",
      "servicecatalog:DescribeRecord",
      "servicecatalog:ListRecordHistory",
      "servicecatalog:ListStackInstancesForProvisionedProduct",
      "servicecatalog:ScanProvisionedProducts",
      "servicecatalog:TerminateProvisionedProduct",
      "servicecatalog:UpdateProvisionedProduct",
      "servicecatalog:SearchProvisionedProducts",
      "servicecatalog:CreateProvisionedProductPlan",
      "servicecatalog:DescribeProvisionedProductPlan",
      "servicecatalog:ExecuteProvisionedProductPlan",
      "servicecatalog:DeleteProvisionedProductPlan",
      "servicecatalog:ListProvisionedProductPlans",
      "servicecatalog:ListServiceActionsForProvisioningArtifact",
      "servicecatalog:ExecuteProvisionedProductServiceAction",
      "servicecatalog:DescribeServiceActionExecutionParameters"
     ],
     "Condition":{
      "StringEquals":{
       "servicecatalog:userLevel":"self"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-07-10T20:30:52+00:00"
 },
 "AWSServiceCatalogEndUserReadOnlyAccess":{
  "CreateDate":"2019-10-25T18:49:34+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cloudformation:DescribeStackEvents",
      "cloudformation:DescribeStacks",
      "cloudformation:DescribeChangeSet",
      "cloudformation:ListChangeSets",
      "cloudformation:DescribeStackSet",
      "cloudformation:DescribeStackInstance",
      "cloudformation:DescribeStackSetOperation",
      "cloudformation:ListStackInstances",
      "cloudformation:ListStackResources",
      "cloudformation:ListStackSetOperations",
      "cloudformation:ListStackSetOperationResults"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:cloudformation:*:*:stack/SC-*",
      "arn:aws:cloudformation:*:*:stack/StackSet-SC-*",
      "arn:aws:cloudformation:*:*:changeSet/SC-*",
      "arn:aws:cloudformation:*:*:stackset/SC-*"
     ]
    },
    {
     "Action":[
      "cloudformation:GetTemplateSummary",
      "servicecatalog:DescribeProduct",
      "servicecatalog:DescribeProductView",
      "servicecatalog:DescribeProvisioningParameters",
      "servicecatalog:ListLaunchPaths",
      "servicecatalog:SearchProducts",
      "ssm:DescribeDocument",
      "ssm:GetAutomationExecution",
      "config:DescribeConfigurationRecorders",
      "config:DescribeConfigurationRecorderStatus"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "servicecatalog:DescribeProvisionedProduct",
      "servicecatalog:DescribeRecord",
      "servicecatalog:ListRecordHistory",
      "servicecatalog:ListStackInstancesForProvisionedProduct",
      "servicecatalog:ScanProvisionedProducts",
      "servicecatalog:SearchProvisionedProducts",
      "servicecatalog:DescribeProvisionedProductPlan",
      "servicecatalog:ListProvisionedProductPlans",
      "servicecatalog:ListServiceActionsForProvisioningArtifact",
      "servicecatalog:DescribeServiceActionExecutionParameters"
     ],
     "Condition":{
      "StringEquals":{
       "servicecatalog:userLevel":"self"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-10-25T18:49:34+00:00"
 },
 "AWSServiceRoleForAmazonEKSNodegroup":{
  "CreateDate":"2019-11-07T01:34:26+00:00",
  "DefaultVersionId":"v6",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:RevokeSecurityGroupIngress",
      "ec2:AuthorizeSecurityGroupEgress",
      "ec2:AuthorizeSecurityGroupIngress",
      "ec2:DescribeInstances",
      "ec2:RevokeSecurityGroupEgress",
      "ec2:DeleteSecurityGroup"
     ],
     "Condition":{
      "StringLike":{
       "ec2:ResourceTag/eks":"*"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"SharedSecurityGroupRelatedPermissions"
    },
    {
     "Action":[
      "ec2:RevokeSecurityGroupIngress",
      "ec2:AuthorizeSecurityGroupEgress",
      "ec2:AuthorizeSecurityGroupIngress",
      "ec2:DescribeInstances",
      "ec2:RevokeSecurityGroupEgress",
      "ec2:DeleteSecurityGroup"
     ],
     "Condition":{
      "StringLike":{
       "ec2:ResourceTag/eks:nodegroup-name":"*"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"EKSCreatedSecurityGroupRelatedPermissions"
    },
    {
     "Action":[
      "ec2:DeleteLaunchTemplate",
      "ec2:CreateLaunchTemplateVersion"
     ],
     "Condition":{
      "StringLike":{
       "ec2:ResourceTag/eks:nodegroup-name":"*"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"LaunchTemplateRelatedPermissions"
    },
    {
     "Action":[
      "autoscaling:UpdateAutoScalingGroup",
      "autoscaling:DeleteAutoScalingGroup",
      "autoscaling:TerminateInstanceInAutoScalingGroup",
      "autoscaling:CompleteLifecycleAction",
      "autoscaling:PutLifecycleHook",
      "autoscaling:PutNotificationConfiguration",
      "autoscaling:EnableMetricsCollection"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:autoscaling:*:*:*:autoScalingGroupName/eks-*",
     "Sid":"AutoscalingRelatedPermissions"
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":"autoscaling.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AllowAutoscalingToCreateSLR"
    },
    {
     "Action":[
      "autoscaling:CreateOrUpdateTags",
      "autoscaling:CreateAutoScalingGroup"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:TagKeys":[
        "eks",
        "eks:cluster-name",
        "eks:nodegroup-name"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AllowASGCreationByEKS"
    },
    {
     "Action":"iam:PassRole",
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":"autoscaling.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AllowPassRoleToAutoscaling"
    },
    {
     "Action":"iam:PassRole",
     "Condition":{
      "StringEqualsIfExists":{
       "iam:PassedToService":[
        "ec2.amazonaws.com",
        "ec2.amazonaws.com.cn"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AllowPassRoleToEC2"
    },
    {
     "Action":[
      "iam:GetRole",
      "ec2:CreateLaunchTemplate",
      "ec2:DescribeInstances",
      "iam:GetInstanceProfile",
      "ec2:DescribeLaunchTemplates",
      "autoscaling:DescribeAutoScalingGroups",
      "ec2:CreateSecurityGroup",
      "ec2:DescribeLaunchTemplateVersions",
      "ec2:RunInstances",
      "ec2:DescribeSecurityGroups",
      "ec2:GetConsoleOutput",
      "ec2:DescribeRouteTables",
      "ec2:DescribeSubnets"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"PermissionsToManageResourcesForNodegroups"
    },
    {
     "Action":[
      "iam:CreateInstanceProfile",
      "iam:DeleteInstanceProfile",
      "iam:RemoveRoleFromInstanceProfile",
      "iam:AddRoleToInstanceProfile"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:instance-profile/eks-*",
     "Sid":"PermissionsToCreateAndManageInstanceProfiles"
    },
    {
     "Action":[
      "ec2:CreateTags",
      "ec2:DeleteTags"
     ],
     "Condition":{
      "ForAnyValue:StringLike":{
       "aws:TagKeys":[
        "eks",
        "eks:cluster-name",
        "eks:nodegroup-name",
        "kubernetes.io/cluster/*"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"PermissionsToManageEKSAndKubernetesTags"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-01-14T00:33:26+00:00"
 },
 "AWSServiceRoleForCloudWatchAlarmsActionSSMServiceRolePolicy":{
  "CreateDate":"2020-10-01T09:49:01+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ssm:CreateOpsItem"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-10-01T09:49:01+00:00"
 },
 "AWSServiceRoleForCodeGuru-Profiler":{
  "CreateDate":"2020-06-26T22:04:26+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "sns:Publish"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AllowSNSPublishToSendNotifications"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-06-26T22:04:26+00:00"
 },
 "AWSServiceRoleForEC2ScheduledInstances":{
  "CreateDate":"2017-10-12T18:31:55+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:CreateTags"
     ],
     "Condition":{
      "ForAllValues:StringEquals":{
       "aws:TagKeys":[
        "aws:ec2sri:scheduledInstanceId"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:instance/*"
     ]
    },
    {
     "Action":[
      "ec2:TerminateInstances"
     ],
     "Condition":{
      "StringLike":{
       "ec2:ResourceTag/aws:ec2sri:scheduledInstanceId":"*"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2017-10-12T18:31:55+00:00"
 },
 "AWSServiceRoleForImageBuilder":{
  "CreateDate":"2019-11-29T22:02:13+00:00",
  "DefaultVersionId":"v17",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:RunInstances"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*::image/*",
      "arn:aws:ec2:*::snapshot/*",
      "arn:aws:ec2:*:*:subnet/*",
      "arn:aws:ec2:*:*:network-interface/*",
      "arn:aws:ec2:*:*:security-group/*",
      "arn:aws:ec2:*:*:key-pair/*",
      "arn:aws:ec2:*:*:launch-template/*",
      "arn:aws:license-manager:*:*:license-configuration:*"
     ]
    },
    {
     "Action":[
      "ec2:RunInstances"
     ],
     "Condition":{
      "StringEquals":{
       "aws:RequestTag/CreatedBy":[
        "EC2 Image Builder",
        "EC2 Fast Launch"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:volume/*",
      "arn:aws:ec2:*:*:instance/*"
     ]
    },
    {
     "Action":"iam:PassRole",
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":[
        "ec2.amazonaws.com",
        "ec2.amazonaws.com.cn",
        "vmie.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:StopInstances",
      "ec2:StartInstances",
      "ec2:TerminateInstances"
     ],
     "Condition":{
      "StringEquals":{
       "ec2:ResourceTag/CreatedBy":"EC2 Image Builder"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:CopyImage",
      "ec2:CreateImage",
      "ec2:CreateLaunchTemplate",
      "ec2:DeregisterImage",
      "ec2:DescribeImages",
      "ec2:DescribeInstanceAttribute",
      "ec2:DescribeInstanceStatus",
      "ec2:DescribeInstances",
      "ec2:DescribeInstanceTypeOfferings",
      "ec2:DescribeInstanceTypes",
      "ec2:DescribeSubnets",
      "ec2:DescribeTags",
      "ec2:ModifyImageAttribute",
      "ec2:DescribeImportImageTasks",
      "ec2:DescribeExportImageTasks",
      "ec2:DescribeSnapshots"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:ModifySnapshotAttribute"
     ],
     "Condition":{
      "StringEquals":{
       "ec2:ResourceTag/CreatedBy":"EC2 Image Builder"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*::snapshot/*"
    },
    {
     "Action":[
      "ec2:CreateTags"
     ],
     "Condition":{
      "StringEquals":{
       "aws:RequestTag/CreatedBy":[
        "EC2 Image Builder",
        "EC2 Fast Launch"
       ],
       "ec2:CreateAction":[
        "RunInstances",
        "CreateImage"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:CreateTags"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*::image/*",
      "arn:aws:ec2:*:*:export-image-task/*"
     ]
    },
    {
     "Action":[
      "ec2:CreateTags"
     ],
     "Condition":{
      "StringEquals":{
       "aws:RequestTag/CreatedBy":[
        "EC2 Image Builder",
        "EC2 Fast Launch"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*::snapshot/*",
      "arn:aws:ec2:*:*:launch-template/*"
     ]
    },
    {
     "Action":[
      "license-manager:UpdateLicenseSpecificationsForResource"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "sns:Publish"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ssm:ListCommands",
      "ssm:ListCommandInvocations",
      "ssm:AddTagsToResource",
      "ssm:DescribeInstanceInformation",
      "ssm:GetAutomationExecution",
      "ssm:StopAutomationExecution",
      "ssm:ListInventoryEntries",
      "ssm:SendAutomationSignal",
      "ssm:DescribeInstanceAssociationsStatus",
      "ssm:DescribeAssociationExecutions"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"ssm:SendCommand",
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ssm:*:*:document/AWS-RunPowerShellScript",
      "arn:aws:ssm:*:*:document/AWS-RunShellScript",
      "arn:aws:ssm:*:*:document/AWSEC2-RunSysprep",
      "arn:aws:s3:::*"
     ]
    },
    {
     "Action":[
      "ssm:SendCommand"
     ],
     "Condition":{
      "StringEquals":{
       "ssm:resourceTag/CreatedBy":[
        "EC2 Image Builder"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:instance/*"
     ]
    },
    {
     "Action":"ssm:StartAutomationExecution",
     "Effect":"Allow",
     "Resource":"arn:aws:ssm:*:*:automation-definition/ImageBuilder*"
    },
    {
     "Action":[
      "ssm:CreateAssociation",
      "ssm:DeleteAssociation"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ssm:*:*:document/AWS-GatherSoftwareInventory",
      "arn:aws:ssm:*:*:association/*",
      "arn:aws:ec2:*:*:instance/*"
     ]
    },
    {
     "Action":[
      "kms:Encrypt",
      "kms:Decrypt",
      "kms:ReEncryptFrom",
      "kms:ReEncryptTo",
      "kms:GenerateDataKeyWithoutPlaintext"
     ],
     "Condition":{
      "ForAllValues:StringEquals":{
       "kms:EncryptionContextKeys":[
        "aws:ebs:id"
       ]
      },
      "StringLike":{
       "kms:ViaService":[
        "ec2.*.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "kms:DescribeKey"
     ],
     "Condition":{
      "StringLike":{
       "kms:ViaService":[
        "ec2.*.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"kms:CreateGrant",
     "Condition":{
      "Bool":{
       "kms:GrantIsForAWSResource":true
      },
      "StringLike":{
       "kms:ViaService":[
        "ec2.*.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"sts:AssumeRole",
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/EC2ImageBuilderDistributionCrossAccountRole"
    },
    {
     "Action":[
      "logs:CreateLogStream",
      "logs:CreateLogGroup",
      "logs:PutLogEvents"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:logs:*:*:log-group:/aws/imagebuilder/*"
    },
    {
     "Action":[
      "ec2:CreateLaunchTemplateVersion",
      "ec2:DescribeLaunchTemplates",
      "ec2:ModifyLaunchTemplate",
      "ec2:DescribeLaunchTemplateVersions"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:ExportImage"
     ],
     "Condition":{
      "StringEquals":{
       "ec2:ResourceTag/CreatedBy":"EC2 Image Builder"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*::image/*"
    },
    {
     "Action":[
      "ec2:ExportImage"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:export-image-task/*"
    },
    {
     "Action":[
      "ec2:CancelExportTask"
     ],
     "Condition":{
      "StringEquals":{
       "ec2:ResourceTag/CreatedBy":"EC2 Image Builder"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:export-image-task/*"
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":[
        "ssm.amazonaws.com",
        "ec2fastlaunch.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:EnableFastLaunch"
     ],
     "Condition":{
      "StringEquals":{
       "ec2:ResourceTag/CreatedBy":"EC2 Image Builder"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*::image/*",
      "arn:aws:ec2:*:*:launch-template/*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-06-16T00:09:27+00:00"
 },
 "AWSServiceRoleForIoTSiteWise":{
  "CreateDate":"2018-11-14T19:19:17+00:00",
  "DefaultVersionId":"v7",
  "Document":{
   "Statement":[
    {
     "Action":[
      "greengrass:GetAssociatedRole",
      "greengrass:GetCoreDefinition",
      "greengrass:GetCoreDefinitionVersion",
      "greengrass:GetGroup",
      "greengrass:GetGroupVersion"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "logs:CreateLogGroup",
      "logs:DescribeLogGroups"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:logs:*:*:log-group:/aws/iotsitewise*"
    },
    {
     "Action":[
      "logs:CreateLogStream",
      "logs:DescribeLogStreams",
      "logs:PutLogEvents"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:logs:*:*:log-group:/aws/iotsitewise*:log-stream:*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-04-25T02:15:01+00:00"
 },
 "AWSServiceRoleForLogDeliveryPolicy":{
  "CreateDate":"2019-10-04T17:31:19+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "firehose:PutRecord",
      "firehose:PutRecordBatch",
      "firehose:ListTagsForDeliveryStream"
     ],
     "Condition":{
      "StringEquals":{
       "aws:ResourceTag/LogDeliveryEnabled":"true"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-07-15T20:07:44+00:00"
 },
 "AWSServiceRoleForMonitronPolicy":{
  "CreateDate":"2020-12-02T19:06:08+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "sso:GetManagedApplicationInstance",
      "sso:GetProfile",
      "sso:ListProfiles",
      "sso:AssociateProfile",
      "sso:ListDirectoryAssociations",
      "sso-directory:DescribeUsers",
      "sso-directory:SearchUsers"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-12-02T19:06:08+00:00"
 },
 "AWSServiceRoleForSMS":{
  "CreateDate":"2019-08-06T18:39:29+00:00",
  "DefaultVersionId":"v10",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cloudformation:CreateChangeSet",
      "cloudformation:CreateStack"
     ],
     "Condition":{
      "ForAllValues:StringEquals":{
       "cloudformation:ResourceTypes":[
        "AWS::EC2::Instance",
        "AWS::ApplicationInsights::Application",
        "AWS::ResourceGroups::Group"
       ]
      },
      "Null":{
       "cloudformation:ResourceTypes":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:cloudformation:*:*:stack/sms-app-*/*"
    },
    {
     "Action":[
      "cloudformation:DeleteStack",
      "cloudformation:ExecuteChangeSet",
      "cloudformation:DeleteChangeSet",
      "cloudformation:DescribeChangeSet",
      "cloudformation:DescribeStacks",
      "cloudformation:DescribeStackEvents",
      "cloudformation:DescribeStackResource",
      "cloudformation:DescribeStackResources",
      "cloudformation:GetTemplate"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:cloudformation:*:*:stack/sms-app-*/*"
    },
    {
     "Action":[
      "cloudformation:ValidateTemplate",
      "s3:ListAllMyBuckets"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "s3:CreateBucket",
      "s3:DeleteBucket",
      "s3:DeleteObject",
      "s3:GetBucketAcl",
      "s3:GetBucketLocation",
      "s3:GetObject",
      "s3:ListBucket",
      "s3:PutObject",
      "s3:PutObjectAcl",
      "s3:PutLifecycleConfiguration"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::sms-app-*"
    },
    {
     "Action":[
      "sms:CreateReplicationJob",
      "sms:DeleteReplicationJob",
      "sms:GetReplicationJobs",
      "sms:GetReplicationRuns",
      "sms:GetServers",
      "sms:ImportServerCatalog",
      "sms:StartOnDemandReplicationRun",
      "sms:UpdateReplicationJob"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"ssm:SendCommand",
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ssm:*::document/AWS-RunRemoteScript",
      "arn:aws:s3:::sms-app-*"
     ]
    },
    {
     "Action":"ssm:SendCommand",
     "Condition":{
      "StringEquals":{
       "ssm:resourceTag/UseForSMSApplicationValidation":[
        "true"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:instance/*"
    },
    {
     "Action":[
      "ssm:CancelCommand",
      "ssm:GetCommandInvocation"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"ec2:CreateTags",
     "Condition":{
      "StringEquals":{
       "ec2:CreateAction":"CopySnapshot"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:snapshot/*"
    },
    {
     "Action":"ec2:CopySnapshot",
     "Condition":{
      "StringLike":{
       "aws:RequestTag/SMSJobId":[
        "sms-*"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:snapshot/*"
    },
    {
     "Action":[
      "ec2:ModifySnapshotAttribute",
      "ec2:DeleteSnapshot"
     ],
     "Condition":{
      "StringLike":{
       "ec2:ResourceTag/SMSJobId":[
        "sms-*"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:snapshot/*"
    },
    {
     "Action":[
      "ec2:CopyImage",
      "ec2:DescribeImages",
      "ec2:DescribeInstances",
      "ec2:DescribeSnapshots",
      "ec2:DescribeSnapshotAttribute",
      "ec2:DeregisterImage",
      "ec2:ImportImage",
      "ec2:DescribeImportImageTasks",
      "ec2:GetEbsEncryptionByDefault"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "iam:GetRole",
      "iam:GetInstanceProfile"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:DisassociateIamInstanceProfile",
      "ec2:AssociateIamInstanceProfile",
      "ec2:ReplaceIamInstanceProfileAssociation"
     ],
     "Condition":{
      "StringLike":{
       "ec2:ResourceTag/aws:cloudformation:stack-id":"arn:aws:cloudformation:*:*:stack/sms-app-*/*"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:instance/*"
    },
    {
     "Action":"iam:PassRole",
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":"ec2.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"iam:PassRole",
     "Condition":{
      "StringEqualsIfExists":{
       "iam:PassedToService":"cloudformation.amazonaws.com"
      },
      "StringLike":{
       "iam:AssociatedResourceArn":"arn:aws:cloudformation:*:*:stack/sms-app-*/*"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:RunInstances"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:CreateTags",
      "ec2:DeleteTags"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:instance/*"
    },
    {
     "Action":[
      "ec2:ModifyInstanceAttribute",
      "ec2:StopInstances",
      "ec2:StartInstances",
      "ec2:TerminateInstances"
     ],
     "Condition":{
      "StringLike":{
       "ec2:ResourceTag/aws:cloudformation:stack-id":"arn:aws:cloudformation:*:*:stack/sms-app-*/*"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "applicationinsights:Describe*",
      "applicationinsights:List*",
      "cloudformation:ListStackResources"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "applicationinsights:CreateApplication",
      "applicationinsights:CreateComponent",
      "applicationinsights:UpdateApplication",
      "applicationinsights:DeleteApplication",
      "applicationinsights:UpdateComponentConfiguration",
      "applicationinsights:DeleteComponent"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:applicationinsights:*:*:application/resource-group/sms-app-*"
    },
    {
     "Action":[
      "resource-groups:CreateGroup",
      "resource-groups:GetGroup",
      "resource-groups:UpdateGroup",
      "resource-groups:DeleteGroup"
     ],
     "Condition":{
      "StringLike":{
       "aws:ResourceTag/aws:cloudformation:stack-id":"arn:aws:cloudformation:*:*:stack/sms-app-*/*"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:resource-groups:*:*:group/sms-app-*"
    },
    {
     "Action":[
      "iam:CreateServiceLinkedRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":"application-insights.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/aws-service-role/application-insights.amazonaws.com/AWSServiceRoleForApplicationInsights"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-10-15T17:28:13+00:00"
 },
 "AWSServiceRolePolicyForBackupReports":{
  "CreateDate":"2021-08-19T21:16:45+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "backup:DescribeFramework",
      "backup:ListBackupJobs",
      "backup:ListRestoreJobs",
      "backup:ListCopyJobs"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "config:DescribeConfigurationRecorders",
      "config:DescribeConfigurationRecorderStatus",
      "config:BatchGetResourceConfig",
      "config:SelectResourceConfig",
      "config:DescribeConfigurationAggregators",
      "config:SelectAggregateResourceConfig",
      "s3:GetBucketLocation"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "config:GetComplianceDetailsByConfigRule",
      "config:DescribeConfigRuleEvaluationStatus",
      "config:DescribeConfigRules",
      "config:PutConfigRule",
      "config:DeleteConfigRule"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:config:*:*:config-rule/aws-service-rule/backup.amazonaws.com*"
    },
    {
     "Action":[
      "config:DeleteConfigurationAggregator",
      "config:PutConfigurationAggregator"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:config:*:*:config-aggregator/aws-service-config-aggregator/backup.amazonaws.com*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-08-19T21:16:45+00:00"
 },
 "AWSShieldDRTAccessPolicy":{
  "CreateDate":"2018-06-05T22:29:39+00:00",
  "DefaultVersionId":"v6",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cloudfront:List*",
      "route53:List*",
      "elasticloadbalancing:Describe*",
      "cloudwatch:Describe*",
      "cloudwatch:Get*",
      "cloudwatch:List*",
      "cloudfront:GetDistribution*",
      "globalaccelerator:ListAccelerators",
      "globalaccelerator:DescribeAccelerator",
      "ec2:DescribeRegions",
      "ec2:DescribeAddresses"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"SRTAccessProtectedResources"
    },
    {
     "Action":[
      "shield:*",
      "waf:*",
      "wafv2:*",
      "waf-regional:*",
      "elasticloadbalancing:SetWebACL",
      "cloudfront:UpdateDistribution",
      "apigateway:SetWebACL"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"SRTManageProtections"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-12-15T17:28:15+00:00"
 },
 "AWSShieldServiceRolePolicy":{
  "CreateDate":"2021-11-17T19:17:46+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "wafv2:GetWebACL",
      "wafv2:UpdateWebACL",
      "wafv2:GetWebACLForResource",
      "wafv2:ListResourcesForWebACL",
      "cloudfront:ListDistributions",
      "cloudfront:GetDistribution"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AWSShield"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-11-17T19:17:46+00:00"
 },
 "AWSStepFunctionsConsoleFullAccess":{
  "CreateDate":"2017-01-11T21:54:31+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":"states:*",
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"iam:ListRoles",
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"iam:PassRole",
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/service-role/StatesExecutionRole*"
    },
    {
     "Action":"lambda:ListFunctions",
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2017-01-12T00:19:34+00:00"
 },
 "AWSStepFunctionsFullAccess":{
  "CreateDate":"2017-01-11T21:51:32+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":"states:*",
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2017-01-11T21:51:32+00:00"
 },
 "AWSStepFunctionsReadOnlyAccess":{
  "CreateDate":"2017-01-11T21:46:19+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "states:ListStateMachines",
      "states:ListActivities",
      "states:DescribeStateMachine",
      "states:DescribeStateMachineForExecution",
      "states:ListExecutions",
      "states:DescribeExecution",
      "states:GetExecutionHistory",
      "states:DescribeActivity"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2017-11-10T22:03:49+00:00"
 },
 "AWSStorageGatewayFullAccess":{
  "CreateDate":"2015-02-06T18:41:09+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "storagegateway:*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:DescribeSnapshots",
      "ec2:DeleteSnapshot"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2015-02-06T18:41:09+00:00"
 },
 "AWSStorageGatewayReadOnlyAccess":{
  "CreateDate":"2015-02-06T18:41:10+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "storagegateway:List*",
      "storagegateway:Describe*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:DescribeSnapshots"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2015-02-06T18:41:10+00:00"
 },
 "AWSStorageGatewayServiceRolePolicy":{
  "CreateDate":"2021-02-17T19:03:19+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "fsx:ListTagsForResource"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:fsx:*:*:backup/*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-02-17T19:03:19+00:00"
 },
 "AWSSupportAccess":{
  "CreateDate":"2015-02-06T18:41:11+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "support:*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2015-02-06T18:41:11+00:00"
 },
 "AWSSupportServiceRolePolicy":{
  "CreateDate":"2018-04-19T18:04:44+00:00",
  "DefaultVersionId":"v24",
  "Document":{
   "Statement":[
    {
     "Action":[
      "apigateway:GET"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:apigateway:*::/account",
      "arn:aws:apigateway:*::/apis",
      "arn:aws:apigateway:*::/apis/*",
      "arn:aws:apigateway:*::/apis/*/authorizers",
      "arn:aws:apigateway:*::/apis/*/authorizers/*",
      "arn:aws:apigateway:*::/apis/*/deployments",
      "arn:aws:apigateway:*::/apis/*/deployments/*",
      "arn:aws:apigateway:*::/apis/*/integrations",
      "arn:aws:apigateway:*::/apis/*/integrations/*",
      "arn:aws:apigateway:*::/apis/*/integrations/*/integrationresponses",
      "arn:aws:apigateway:*::/apis/*/integrations/*/integrationresponses/*",
      "arn:aws:apigateway:*::/apis/*/models",
      "arn:aws:apigateway:*::/apis/*/models/*",
      "arn:aws:apigateway:*::/apis/*/routes",
      "arn:aws:apigateway:*::/apis/*/routes/*",
      "arn:aws:apigateway:*::/apis/*/routes/*/routeresponses",
      "arn:aws:apigateway:*::/apis/*/routes/*/routeresponses/*",
      "arn:aws:apigateway:*::/apis/*/stages",
      "arn:aws:apigateway:*::/apis/*/stages/*",
      "arn:aws:apigateway:*::/clientcertificates",
      "arn:aws:apigateway:*::/clientcertificates/*",
      "arn:aws:apigateway:*::/domainnames",
      "arn:aws:apigateway:*::/domainnames/*",
      "arn:aws:apigateway:*::/domainnames/*/apimappings",
      "arn:aws:apigateway:*::/domainnames/*/apimappings/*",
      "arn:aws:apigateway:*::/domainnames/*/basepathmappings",
      "arn:aws:apigateway:*::/domainnames/*/basepathmappings/*",
      "arn:aws:apigateway:*::/restapis",
      "arn:aws:apigateway:*::/restapis/*",
      "arn:aws:apigateway:*::/restapis/*/authorizers",
      "arn:aws:apigateway:*::/restapis/*/authorizers/*",
      "arn:aws:apigateway:*::/restapis/*/deployments",
      "arn:aws:apigateway:*::/restapis/*/deployments/*",
      "arn:aws:apigateway:*::/restapis/*/models",
      "arn:aws:apigateway:*::/restapis/*/models/*",
      "arn:aws:apigateway:*::/restapis/*/models/*/default_template",
      "arn:aws:apigateway:*::/restapis/*/resources",
      "arn:aws:apigateway:*::/restapis/*/resources/*",
      "arn:aws:apigateway:*::/restapis/*/resources/*/methods/*/integration/responses/*",
      "arn:aws:apigateway:*::/restapis/*/resources/*/methods/*/responses/*",
      "arn:aws:apigateway:*::/restapis/*/stages/*/sdks/*",
      "arn:aws:apigateway:*::/restapis/*/resources/*/methods/*",
      "arn:aws:apigateway:*::/restapis/*/resources/*/methods/*/integration",
      "arn:aws:apigateway:*::/restapis/*/stages",
      "arn:aws:apigateway:*::/restapis/*/stages/*"
     ]
    },
    {
     "Action":[
      "iam:DeleteRole"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/aws-service-role/support.amazonaws.com/AWSServiceRoleForSupport"
     ]
    },
    {
     "Action":[
      "a4b:getDevice",
      "a4b:getProfile",
      "a4b:getRoom",
      "a4b:getRoomSkillParameter",
      "a4b:getSkillGroup",
      "a4b:searchDevices",
      "a4b:searchProfiles",
      "a4b:searchRooms",
      "a4b:searchSkillGroups",
      "access-analyzer:getFinding",
      "access-analyzer:listAnalyzers",
      "access-analyzer:listArchiveRules",
      "access-analyzer:listFindings",
      "acm-pca:describeCertificateAuthority",
      "acm-pca:describeCertificateAuthorityAuditReport",
      "acm-pca:getCertificate",
      "acm-pca:getCertificateAuthorityCertificate",
      "acm-pca:getCertificateAuthorityCsr",
      "acm-pca:listCertificateAuthorities",
      "acm-pca:listTags",
      "acm:describeCertificate",
      "acm:getCertificate",
      "acm:listCertificates",
      "acm:listTagsForCertificate",
      "airflow:getEnvironment",
      "airflow:listEnvironments",
      "airflow:listTagsForResource",
      "amplify:getApp",
      "amplify:getBranch",
      "amplify:getDomainAssociation",
      "amplify:getJob",
      "amplify:getWebhook",
      "amplify:listApps",
      "amplify:listWebhooks",
      "amplifyuibuilder:exportComponents",
      "amplifyuibuilder:exportThemes",
      "appflow:describeConnectorEntity",
      "appflow:describeConnectorProfiles",
      "appflow:describeConnectors",
      "appflow:describeFlow",
      "appflow:describeFlowExecutionRecords",
      "appflow:listConnectorEntities",
      "appflow:listFlows",
      "application-autoscaling:describeScalableTargets",
      "application-autoscaling:describeScalingActivities",
      "application-autoscaling:describeScalingPolicies",
      "application-autoscaling:describeScheduledActions",
      "applicationinsights:describeComponentConfiguration",
      "applicationinsights:describeComponentConfigurationRecommendation",
      "applicationinsights:listApplications",
      "applicationinsights:listComponents",
      "applicationinsights:listConfigurationHistory",
      "applicationinsights:listLogPatterns",
      "applicationinsights:listLogPatternSets",
      "appmesh:describeGatewayRoute",
      "appmesh:describeMesh",
      "appmesh:describeRoute",
      "appmesh:describeVirtualGateway",
      "appmesh:describeVirtualNode",
      "appmesh:describeVirtualRouter",
      "appmesh:describeVirtualService",
      "appmesh:listGatewayRoutes",
      "appmesh:listMeshes",
      "appmesh:listRoutes",
      "appmesh:listTagsForResource",
      "appmesh:listVirtualGateways",
      "appmesh:listVirtualNodes",
      "appmesh:listVirtualRouters",
      "appmesh:listVirtualServices",
      "apprunner:describeAutoScalingConfiguration",
      "apprunner:describeCustomDomains",
      "apprunner:describeOperation",
      "apprunner:describeService",
      "apprunner:listAutoScalingConfigurations",
      "apprunner:listConnections",
      "apprunner:listOperations",
      "apprunner:listServices",
      "apprunner:listTagsForResource",
      "appstream:describeAppBlocks",
      "appstream:describeApplicationFleetAssociations",
      "appstream:describeApplications",
      "appstream:describeDirectoryConfigs",
      "appstream:describeFleets",
      "appstream:describeImageBuilders",
      "appstream:describeImages",
      "appstream:describeSessions",
      "appstream:describeStacks",
      "appstream:listAssociatedFleets",
      "appstream:listAssociatedStacks",
      "appstream:listTagsForResource",
      "appsync:getFunction",
      "appsync:getGraphqlApi",
      "appsync:getIntrospectionSchema",
      "appsync:getResolver",
      "appsync:getSchemaCreationStatus",
      "appsync:getType",
      "appsync:listDataSources",
      "appsync:listFunctions",
      "appsync:listGraphqlApis",
      "appsync:listResolvers",
      "appsync:listTypes",
      "athena:batchGetNamedQuery",
      "athena:batchGetQueryExecution",
      "athena:getNamedQuery",
      "athena:getQueryExecution",
      "athena:getWorkGroup",
      "athena:listNamedQueries",
      "athena:listQueryExecutions",
      "athena:listTagsForResource",
      "athena:listWorkGroups",
      "auditmanager:getAccountStatus",
      "auditmanager:getDelegations",
      "auditmanager:listAssessmentFrameworks",
      "auditmanager:listAssessmentReports",
      "auditmanager:listAssessments",
      "auditmanager:listControls",
      "auditmanager:listKeywordsForDataSource",
      "auditmanager:listNotifications",
      "autoscaling-plans:describeScalingPlanResources",
      "autoscaling-plans:describeScalingPlans",
      "autoscaling-plans:getScalingPlanResourceForecastData",
      "autoscaling:describeAccountLimits",
      "autoscaling:describeAdjustmentTypes",
      "autoscaling:describeAutoScalingGroups",
      "autoscaling:describeAutoScalingInstances",
      "autoscaling:describeAutoScalingNotificationTypes",
      "autoscaling:describeInstanceRefreshes",
      "autoscaling:describeLaunchConfigurations",
      "autoscaling:describeLifecycleHooks",
      "autoscaling:describeLifecycleHookTypes",
      "autoscaling:describeLoadBalancers",
      "autoscaling:describeLoadBalancerTargetGroups",
      "autoscaling:describeMetricCollectionTypes",
      "autoscaling:describeNotificationConfigurations",
      "autoscaling:describePolicies",
      "autoscaling:describeScalingActivities",
      "autoscaling:describeScalingProcessTypes",
      "autoscaling:describeScheduledActions",
      "autoscaling:describeTags",
      "autoscaling:describeTerminationPolicyTypes",
      "backup:describeBackupJob",
      "backup:describeBackupVault",
      "backup:describeCopyJob",
      "backup:describeFramework",
      "backup:describeGlobalSettings",
      "backup:describeProtectedResource",
      "backup:describeRecoveryPoint",
      "backup:describeRegionSettings",
      "backup:describeReportJob",
      "backup:describeReportPlan",
      "backup:describeRestoreJob",
      "backup:getBackupPlan",
      "backup:getBackupPlanFromJSON",
      "backup:getBackupPlanFromTemplate",
      "backup:getBackupSelection",
      "backup:getBackupVaultAccessPolicy",
      "backup:getBackupVaultNotifications",
      "backup:getRecoveryPointRestoreMetadata",
      "backup:getSupportedResourceTypes",
      "backup:listBackupJobs",
      "backup:listBackupPlans",
      "backup:listBackupPlanTemplates",
      "backup:listBackupPlanVersions",
      "backup:listBackupSelections",
      "backup:listBackupVaults",
      "backup:listCopyJobs",
      "backup:listFrameworks",
      "backup:listProtectedResources",
      "backup:listRecoveryPointsByBackupVault",
      "backup:listRecoveryPointsByResource",
      "backup:listReportJobs",
      "backup:listReportPlans",
      "backup:listRestoreJobs",
      "backup:listTags",
      "batch:describeComputeEnvironments",
      "batch:describeJobDefinitions",
      "batch:describeJobQueues",
      "batch:describeJobs",
      "batch:listJobs",
      "braket:getDevice",
      "braket:getQuantumTask",
      "braket:searchDevices",
      "braket:searchQuantumTasks",
      "budgets:viewBudget",
      "ce:getCostAndUsage",
      "ce:getCostAndUsageWithResources",
      "ce:getCostForecast",
      "ce:getDimensionValues",
      "ce:getReservationCoverage",
      "ce:getReservationPurchaseRecommendation",
      "ce:getReservationUtilization",
      "ce:getRightsizingRecommendation",
      "ce:getSavingsPlansCoverage",
      "ce:getSavingsPlansPurchaseRecommendation",
      "ce:getSavingsPlansUtilization",
      "ce:getSavingsPlansUtilizationDetails",
      "ce:getTags",
      "cloud9:describeEnvironmentMemberships",
      "cloud9:describeEnvironments",
      "cloud9:listEnvironments",
      "clouddirectory:getDirectory",
      "clouddirectory:listDirectories",
      "cloudformation:batchDescribeTypeConfigurations",
      "cloudformation:describeAccountLimits",
      "cloudformation:describeChangeSet",
      "cloudformation:describePublisher",
      "cloudformation:describeStackEvents",
      "cloudformation:describeStackInstance",
      "cloudformation:describeStackResource",
      "cloudformation:describeStackResources",
      "cloudformation:describeStacks",
      "cloudformation:describeStackSet",
      "cloudformation:describeStackSetOperation",
      "cloudformation:describeType",
      "cloudformation:describeTypeRegistration",
      "cloudformation:estimateTemplateCost",
      "cloudformation:getStackPolicy",
      "cloudformation:getTemplate",
      "cloudformation:getTemplateSummary",
      "cloudformation:listChangeSets",
      "cloudformation:listExports",
      "cloudformation:listImports",
      "cloudformation:listStackInstances",
      "cloudformation:listStackResources",
      "cloudformation:listStacks",
      "cloudformation:listStackSetOperationResults",
      "cloudformation:listStackSetOperations",
      "cloudformation:listStackSets",
      "cloudformation:listTypeRegistrations",
      "cloudformation:listTypes",
      "cloudformation:listTypeVersions",
      "cloudfront:getCloudFrontOriginAccessIdentity",
      "cloudfront:getCloudFrontOriginAccessIdentityConfig",
      "cloudfront:getDistribution",
      "cloudfront:getDistributionConfig",
      "cloudfront:getInvalidation",
      "cloudfront:getStreamingDistribution",
      "cloudfront:getStreamingDistributionConfig",
      "cloudfront:listCloudFrontOriginAccessIdentities",
      "cloudfront:listDistributions",
      "cloudfront:listDistributionsByWebACLId",
      "cloudfront:listInvalidations",
      "cloudfront:listStreamingDistributions",
      "cloudhsm:describeBackups",
      "cloudhsm:describeClusters",
      "cloudsearch:describeAnalysisSchemes",
      "cloudsearch:describeAvailabilityOptions",
      "cloudsearch:describeDomains",
      "cloudsearch:describeExpressions",
      "cloudsearch:describeIndexFields",
      "cloudsearch:describeScalingParameters",
      "cloudsearch:describeServiceAccessPolicies",
      "cloudsearch:describeSuggesters",
      "cloudsearch:listDomainNames",
      "cloudtrail:describeTrails",
      "cloudtrail:getEventSelectors",
      "cloudtrail:getInsightSelectors",
      "cloudtrail:getTrail",
      "cloudtrail:getTrailStatus",
      "cloudtrail:listPublicKeys",
      "cloudtrail:listTags",
      "cloudtrail:listTrails",
      "cloudtrail:lookupEvents",
      "cloudwatch:describeAlarmHistory",
      "cloudwatch:describeAlarms",
      "cloudwatch:describeAlarmsForMetric",
      "cloudwatch:describeAnomalyDetectors",
      "cloudwatch:describeInsightRules",
      "cloudwatch:getDashboard",
      "cloudwatch:getInsightRuleReport",
      "cloudwatch:getMetricData",
      "cloudwatch:getMetricStatistics",
      "cloudwatch:listDashboards",
      "cloudwatch:listMetrics",
      "codeartifact:describeDomain",
      "codeartifact:describePackageVersion",
      "codeartifact:describeRepository",
      "codeartifact:getDomainPermissionsPolicy",
      "codeartifact:getRepositoryEndpoint",
      "codeartifact:getRepositoryPermissionsPolicy",
      "codeartifact:listDomains",
      "codeartifact:listPackages",
      "codeartifact:listPackageVersionAssets",
      "codeartifact:listPackageVersions",
      "codeartifact:listRepositories",
      "codeartifact:listRepositoriesInDomain",
      "codebuild:batchGetBuildBatches",
      "codebuild:batchGetBuilds",
      "codebuild:batchGetProjects",
      "codebuild:listBuildBatches",
      "codebuild:listBuildBatchesForProject",
      "codebuild:listBuilds",
      "codebuild:listBuildsForProject",
      "codebuild:listCuratedEnvironmentImages",
      "codebuild:listProjects",
      "codebuild:listSourceCredentials",
      "codecommit:batchGetRepositories",
      "codecommit:getBranch",
      "codecommit:getRepository",
      "codecommit:getRepositoryTriggers",
      "codecommit:listBranches",
      "codecommit:listRepositories",
      "codedeploy:batchGetApplicationRevisions",
      "codedeploy:batchGetApplications",
      "codedeploy:batchGetDeploymentGroups",
      "codedeploy:batchGetDeploymentInstances",
      "codedeploy:batchGetDeployments",
      "codedeploy:batchGetDeploymentTargets",
      "codedeploy:batchGetOnPremisesInstances",
      "codedeploy:getApplication",
      "codedeploy:getApplicationRevision",
      "codedeploy:getDeployment",
      "codedeploy:getDeploymentConfig",
      "codedeploy:getDeploymentGroup",
      "codedeploy:getDeploymentInstance",
      "codedeploy:getDeploymentTarget",
      "codedeploy:getOnPremisesInstance",
      "codedeploy:listApplicationRevisions",
      "codedeploy:listApplications",
      "codedeploy:listDeploymentConfigs",
      "codedeploy:listDeploymentGroups",
      "codedeploy:listDeploymentInstances",
      "codedeploy:listDeployments",
      "codedeploy:listDeploymentTargets",
      "codedeploy:listGitHubAccountTokenNames",
      "codedeploy:listOnPremisesInstances",
      "codepipeline:getJobDetails",
      "codepipeline:getPipeline",
      "codepipeline:getPipelineExecution",
      "codepipeline:getPipelineState",
      "codepipeline:listActionExecutions",
      "codepipeline:listActionTypes",
      "codepipeline:listPipelineExecutions",
      "codepipeline:listPipelines",
      "codepipeline:listWebhooks",
      "codestar:describeProject",
      "codestar:listProjects",
      "codestar:listResources",
      "codestar:listTeamMembers",
      "codestar:listUserProfiles",
      "cognito-identity:describeIdentityPool",
      "cognito-identity:getIdentityPoolRoles",
      "cognito-identity:listIdentities",
      "cognito-identity:listIdentityPools",
      "cognito-idp:describeIdentityProvider",
      "cognito-idp:describeResourceServer",
      "cognito-idp:describeRiskConfiguration",
      "cognito-idp:describeUserImportJob",
      "cognito-idp:describeUserPool",
      "cognito-idp:describeUserPoolClient",
      "cognito-idp:describeUserPoolDomain",
      "cognito-idp:getGroup",
      "cognito-idp:getUICustomization",
      "cognito-idp:getUserPoolMfaConfig",
      "cognito-idp:listGroups",
      "cognito-idp:listIdentityProviders",
      "cognito-idp:listResourceServers",
      "cognito-idp:listUserImportJobs",
      "cognito-idp:listUserPoolClients",
      "cognito-idp:listUserPools",
      "cognito-sync:describeDataset",
      "cognito-sync:describeIdentityPoolUsage",
      "cognito-sync:describeIdentityUsage",
      "cognito-sync:getCognitoEvents",
      "cognito-sync:getIdentityPoolConfiguration",
      "cognito-sync:listDatasets",
      "cognito-sync:listIdentityPoolUsage",
      "compute-optimizer:getAutoScalingGroupRecommendations",
      "compute-optimizer:getEBSVolumeRecommendations",
      "compute-optimizer:getEC2InstanceRecommendations",
      "compute-optimizer:getEC2RecommendationProjectedMetrics",
      "compute-optimizer:getEnrollmentStatus",
      "compute-optimizer:getRecommendationSummaries",
      "config:batchGetAggregateResourceConfig",
      "config:batchGetResourceConfig",
      "config:describeAggregateComplianceByConfigRules",
      "config:describeAggregationAuthorizations",
      "config:describeComplianceByConfigRule",
      "config:describeComplianceByResource",
      "config:describeConfigRuleEvaluationStatus",
      "config:describeConfigRules",
      "config:describeConfigurationAggregators",
      "config:describeConfigurationAggregatorSourcesStatus",
      "config:describeConfigurationRecorders",
      "config:describeConfigurationRecorderStatus",
      "config:describeConformancePackCompliance",
      "config:describeConformancePacks",
      "config:describeConformancePackStatus",
      "config:describeDeliveryChannels",
      "config:describeDeliveryChannelStatus",
      "config:describeOrganizationConfigRules",
      "config:describeOrganizationConfigRuleStatuses",
      "config:describeOrganizationConformancePacks",
      "config:describeOrganizationConformancePackStatuses",
      "config:describePendingAggregationRequests",
      "config:describeRemediationConfigurations",
      "config:describeRemediationExceptions",
      "config:describeRemediationExecutionStatus",
      "config:describeRetentionConfigurations",
      "config:getAggregateComplianceDetailsByConfigRule",
      "config:getAggregateConfigRuleComplianceSummary",
      "config:getAggregateDiscoveredResourceCounts",
      "config:getAggregateResourceConfig",
      "config:getComplianceDetailsByConfigRule",
      "config:getComplianceDetailsByResource",
      "config:getComplianceSummaryByConfigRule",
      "config:getComplianceSummaryByResourceType",
      "config:getConformancePackComplianceDetails",
      "config:getConformancePackComplianceSummary",
      "config:getDiscoveredResourceCounts",
      "config:getOrganizationConfigRuleDetailedStatus",
      "config:getOrganizationConformancePackDetailedStatus",
      "config:getResourceConfigHistory",
      "config:listAggregateDiscoveredResources",
      "config:listDiscoveredResources",
      "config:listTagsForResource",
      "connect:describeUser",
      "connect:getCurrentMetricData",
      "connect:getMetricData",
      "connect:listRoutingProfiles",
      "connect:listSecurityProfiles",
      "connect:listUsers",
      "controltower:describeAccountFactoryConfig",
      "controltower:describeCoreService",
      "controltower:describeGuardrail",
      "controltower:describeGuardrailForTarget",
      "controltower:describeManagedAccount",
      "controltower:describeSingleSignOn",
      "controltower:getAvailableUpdates",
      "controltower:getHomeRegion",
      "controltower:getLandingZoneStatus",
      "controltower:listDirectoryGroups",
      "controltower:listGuardrailsForTarget",
      "controltower:listGuardrailViolations",
      "controltower:listManagedAccounts",
      "controltower:listManagedAccountsForGuardrail",
      "controltower:listManagedAccountsForParent",
      "controltower:listManagedOrganizationalUnits",
      "controltower:listManagedOrganizationalUnitsForGuardrail",
      "databrew:describeDataset",
      "databrew:describeJob",
      "databrew:describeProject",
      "databrew:describeRecipe",
      "databrew:listDatasets",
      "databrew:listJobRuns",
      "databrew:listJobs",
      "databrew:listProjects",
      "databrew:listRecipes",
      "databrew:listRecipeVersions",
      "databrew:listTagsForResource",
      "datapipeline:describeObjects",
      "datapipeline:describePipelines",
      "datapipeline:getPipelineDefinition",
      "datapipeline:listPipelines",
      "datapipeline:queryObjects",
      "datasync:describeAgent",
      "datasync:describeLocationEfs",
      "datasync:describeLocationFsxWindows",
      "datasync:describeLocationNfs",
      "datasync:describeLocationObjectStorage",
      "datasync:describeLocationS3",
      "datasync:describeLocationSmb",
      "datasync:describeTask",
      "datasync:describeTaskExecution",
      "datasync:listAgents",
      "datasync:listLocations",
      "datasync:listTaskExecutions",
      "datasync:listTasks",
      "dax:describeClusters",
      "dax:describeDefaultParameters",
      "dax:describeEvents",
      "dax:describeParameterGroups",
      "dax:describeParameters",
      "dax:describeSubnetGroups",
      "detective:getMembers",
      "detective:listGraphs",
      "detective:listInvitations",
      "detective:listMembers",
      "devicefarm:getAccountSettings",
      "devicefarm:getDevice",
      "devicefarm:getDevicePool",
      "devicefarm:getDevicePoolCompatibility",
      "devicefarm:getJob",
      "devicefarm:getProject",
      "devicefarm:getRemoteAccessSession",
      "devicefarm:getRun",
      "devicefarm:getSuite",
      "devicefarm:getTest",
      "devicefarm:getTestGridProject",
      "devicefarm:getTestGridSession",
      "devicefarm:getUpload",
      "devicefarm:listArtifacts",
      "devicefarm:listDevicePools",
      "devicefarm:listDevices",
      "devicefarm:listJobs",
      "devicefarm:listProjects",
      "devicefarm:listRemoteAccessSessions",
      "devicefarm:listRuns",
      "devicefarm:listSamples",
      "devicefarm:listSuites",
      "devicefarm:listTestGridProjects",
      "devicefarm:listTestGridSessionActions",
      "devicefarm:listTestGridSessionArtifacts",
      "devicefarm:listTestGridSessions",
      "devicefarm:listTests",
      "devicefarm:listUniqueProblems",
      "devicefarm:listUploads",
      "directconnect:describeConnections",
      "directconnect:describeConnectionsOnInterconnect",
      "directconnect:describeInterconnects",
      "directconnect:describeLocations",
      "directconnect:describeVirtualGateways",
      "directconnect:describeVirtualInterfaces",
      "dlm:getLifecyclePolicies",
      "dlm:getLifecyclePolicy",
      "dms:describeAccountAttributes",
      "dms:describeConnections",
      "dms:describeEndpoints",
      "dms:describeEndpointTypes",
      "dms:describeOrderableReplicationInstances",
      "dms:describeRefreshSchemasStatus",
      "dms:describeReplicationInstances",
      "dms:describeReplicationSubnetGroups",
      "drs:describeJobLogItems",
      "drs:describeJobs",
      "drs:describeRecoveryInstances",
      "drs:describeRecoverySnapshots",
      "drs:describeReplicationConfigurationTemplates",
      "drs:describeSourceServers",
      "drs:getLaunchConfiguration",
      "drs:getReplicationConfiguration",
      "ds:describeConditionalForwarders",
      "ds:describeDirectories",
      "ds:describeEventTopics",
      "ds:describeSnapshots",
      "ds:describeTrusts",
      "ds:getDirectoryLimits",
      "ds:getSnapshotLimits",
      "ds:listIpRoutes",
      "ds:listSchemaExtensions",
      "ds:listTagsForResource",
      "dynamodb:describeBackup",
      "dynamodb:describeContinuousBackups",
      "dynamodb:describeGlobalTable",
      "dynamodb:describeLimits",
      "dynamodb:describeStream",
      "dynamodb:describeTable",
      "dynamodb:describeTimeToLive",
      "dynamodb:listBackups",
      "dynamodb:listGlobalTables",
      "dynamodb:listStreams",
      "dynamodb:listTables",
      "dynamodb:listTagsOfResource",
      "ec2:describeAccountAttributes",
      "ec2:describeAddresses",
      "ec2:describeAvailabilityZones",
      "ec2:describeBundleTasks",
      "ec2:describeByoipCidrs",
      "ec2:describeCapacityReservations",
      "ec2:describeClassicLinkInstances",
      "ec2:describeClientVpnAuthorizationRules",
      "ec2:describeClientVpnConnections",
      "ec2:describeClientVpnEndpoints",
      "ec2:describeClientVpnRoutes",
      "ec2:describeClientVpnTargetNetworks",
      "ec2:describeCoipPools",
      "ec2:describeConversionTasks",
      "ec2:describeCustomerGateways",
      "ec2:describeDhcpOptions",
      "ec2:describeElasticGpus",
      "ec2:describeExportImageTasks",
      "ec2:describeExportTasks",
      "ec2:describeFastSnapshotRestores",
      "ec2:describeFleetHistory",
      "ec2:describeFleetInstances",
      "ec2:describeFleets",
      "ec2:describeFlowLogs",
      "ec2:describeHostReservationOfferings",
      "ec2:describeHostReservations",
      "ec2:describeHosts",
      "ec2:describeIdentityIdFormat",
      "ec2:describeIdFormat",
      "ec2:describeImageAttribute",
      "ec2:describeImages",
      "ec2:describeImportImageTasks",
      "ec2:describeImportSnapshotTasks",
      "ec2:describeInstanceAttribute",
      "ec2:describeInstances",
      "ec2:describeInstanceStatus",
      "ec2:describeInternetGateways",
      "ec2:describeIpamPools",
      "ec2:describeIpams",
      "ec2:describeIpamScopes",
      "ec2:describeKeyPairs",
      "ec2:describeLaunchTemplates",
      "ec2:describeLaunchTemplateVersions",
      "ec2:describeLocalGatewayRouteTables",
      "ec2:describeLocalGatewayRouteTableVirtualInterfaceGroupAssociations",
      "ec2:describeLocalGatewayRouteTableVpcAssociations",
      "ec2:describeLocalGateways",
      "ec2:describeLocalGatewayVirtualInterfaceGroups",
      "ec2:describeLocalGatewayVirtualInterfaces",
      "ec2:describeManagedPrefixLists",
      "ec2:describeMovingAddresses",
      "ec2:describeNatGateways",
      "ec2:describeNetworkAcls",
      "ec2:describeNetworkInterfaceAttribute",
      "ec2:describeNetworkInterfaces",
      "ec2:describePlacementGroups",
      "ec2:describePrefixLists",
      "ec2:describePublicIpv4Pools",
      "ec2:describeRegions",
      "ec2:describeReservedInstances",
      "ec2:describeReservedInstancesListings",
      "ec2:describeReservedInstancesModifications",
      "ec2:describeReservedInstancesOfferings",
      "ec2:describeRouteTables",
      "ec2:describeScheduledInstances",
      "ec2:describeSecurityGroups",
      "ec2:describeSnapshotAttribute",
      "ec2:describeSnapshots",
      "ec2:describeSpotDatafeedSubscription",
      "ec2:describeSpotFleetInstances",
      "ec2:describeSpotFleetRequestHistory",
      "ec2:describeSpotFleetRequests",
      "ec2:describeSpotInstanceRequests",
      "ec2:describeSpotPriceHistory",
      "ec2:describeSubnets",
      "ec2:describeTags",
      "ec2:describeTrafficMirrorFilters",
      "ec2:describeTrafficMirrorSessions",
      "ec2:describeTrafficMirrorTargets",
      "ec2:describeTransitGatewayAttachments",
      "ec2:describeTransitGatewayRouteTables",
      "ec2:describeTransitGateways",
      "ec2:describeTransitGatewayVpcAttachments",
      "ec2:describeVolumeAttribute",
      "ec2:describeVolumes",
      "ec2:describeVolumesModifications",
      "ec2:describeVolumeStatus",
      "ec2:describeVpcAttribute",
      "ec2:describeVpcClassicLink",
      "ec2:describeVpcClassicLinkDnsSupport",
      "ec2:describeVpcEndpointConnectionNotifications",
      "ec2:describeVpcEndpointConnections",
      "ec2:describeVpcEndpoints",
      "ec2:describeVpcEndpointServiceConfigurations",
      "ec2:describeVpcEndpointServicePermissions",
      "ec2:describeVpcEndpointServices",
      "ec2:describeVpcPeeringConnections",
      "ec2:describeVpcs",
      "ec2:describeVpnConnections",
      "ec2:describeVpnGateways",
      "ec2:getCoipPoolUsage",
      "ec2:getConsoleScreenshot",
      "ec2:getIpamAddressHistory",
      "ec2:getIpamPoolAllocations",
      "ec2:getIpamPoolCidrs",
      "ec2:getIpamResourceCidrs",
      "ec2:getManagedPrefixListAssociations",
      "ec2:getManagedPrefixListEntries",
      "ec2:getReservedInstancesExchangeQuote",
      "ec2:searchLocalGatewayRoutes",
      "ecr-public:describeImages",
      "ecr-public:describeImageTags",
      "ecr-public:describeRegistries",
      "ecr-public:describeRepositories",
      "ecr-public:getRegistryCatalogData",
      "ecr-public:getRepositoryCatalogData",
      "ecr-public:getRepositoryPolicy",
      "ecr-public:listTagsForResource",
      "ecr:batchCheckLayerAvailability",
      "ecr:describeImages",
      "ecr:describeImageScanFindings",
      "ecr:describeRegistry",
      "ecr:describeRepositories",
      "ecr:getLifecyclePolicy",
      "ecr:getRegistryPolicy",
      "ecr:getRepositoryPolicy",
      "ecr:listImages",
      "ecr:listTagsForResource",
      "ecs:describeCapacityProviders",
      "ecs:describeClusters",
      "ecs:describeContainerInstances",
      "ecs:describeServices",
      "ecs:describeTaskDefinition",
      "ecs:describeTasks",
      "ecs:describeTaskSets",
      "ecs:listAccountSettings",
      "ecs:listAttributes",
      "ecs:listClusters",
      "ecs:listContainerInstances",
      "ecs:listServices",
      "ecs:listTagsForResource",
      "ecs:listTaskDefinitionFamilies",
      "ecs:listTaskDefinitions",
      "ecs:listTasks",
      "eks:describeCluster",
      "eks:describeFargateProfile",
      "eks:describeNodegroup",
      "eks:describeUpdate",
      "eks:listClusters",
      "eks:listFargateProfiles",
      "eks:listNodegroups",
      "eks:listUpdates",
      "elasticache:describeCacheClusters",
      "elasticache:describeCacheEngineVersions",
      "elasticache:describeCacheParameterGroups",
      "elasticache:describeCacheParameters",
      "elasticache:describeCacheSecurityGroups",
      "elasticache:describeCacheSubnetGroups",
      "elasticache:describeEngineDefaultParameters",
      "elasticache:describeEvents",
      "elasticache:describeReplicationGroups",
      "elasticache:describeReservedCacheNodes",
      "elasticache:describeReservedCacheNodesOfferings",
      "elasticache:describeSnapshots",
      "elasticache:listAllowedNodeTypeModifications",
      "elasticache:listTagsForResource",
      "elasticbeanstalk:checkDNSAvailability",
      "elasticbeanstalk:describeApplicationVersions",
      "elasticbeanstalk:describeConfigurationOptions",
      "elasticbeanstalk:describeEnvironmentHealth",
      "elasticbeanstalk:describeEnvironmentManagedActionHistory",
      "elasticbeanstalk:describeEnvironmentManagedActions",
      "elasticbeanstalk:describeEnvironmentResources",
      "elasticbeanstalk:describeEnvironments",
      "elasticbeanstalk:describeEvents",
      "elasticbeanstalk:describeInstancesHealth",
      "elasticbeanstalk:describePlatformVersion",
      "elasticbeanstalk:listAvailableSolutionStacks",
      "elasticbeanstalk:listPlatformVersions",
      "elasticbeanstalk:validateConfigurationSettings",
      "elasticfilesystem:describeAccessPoints",
      "elasticfilesystem:describeFileSystemPolicy",
      "elasticfilesystem:describeFileSystems",
      "elasticfilesystem:describeLifecycleConfiguration",
      "elasticfilesystem:describeMountTargets",
      "elasticfilesystem:describeMountTargetSecurityGroups",
      "elasticfilesystem:describeTags",
      "elasticfilesystem:listTagsForResource",
      "elasticloadbalancing:describeAccountLimits",
      "elasticloadbalancing:describeInstanceHealth",
      "elasticloadbalancing:describeListenerCertificates",
      "elasticloadbalancing:describeListeners",
      "elasticloadbalancing:describeLoadBalancerAttributes",
      "elasticloadbalancing:describeLoadBalancerPolicies",
      "elasticloadbalancing:describeLoadBalancerPolicyTypes",
      "elasticloadbalancing:describeLoadBalancers",
      "elasticloadbalancing:describeRules",
      "elasticloadbalancing:describeSSLPolicies",
      "elasticloadbalancing:describeTags",
      "elasticloadbalancing:describeTargetGroupAttributes",
      "elasticloadbalancing:describeTargetGroups",
      "elasticloadbalancing:describeTargetHealth",
      "elasticmapreduce:describeCluster",
      "elasticmapreduce:describeSecurityConfiguration",
      "elasticmapreduce:describeStep",
      "elasticmapreduce:listBootstrapActions",
      "elasticmapreduce:listClusters",
      "elasticmapreduce:listInstanceGroups",
      "elasticmapreduce:listInstances",
      "elasticmapreduce:listSecurityConfigurations",
      "elasticmapreduce:listSteps",
      "elastictranscoder:listJobsByPipeline",
      "elastictranscoder:listJobsByStatus",
      "elastictranscoder:listPipelines",
      "elastictranscoder:listPresets",
      "elastictranscoder:readPipeline",
      "elastictranscoder:readPreset",
      "es:describeElasticsearchDomain",
      "es:describeElasticsearchDomainConfig",
      "es:describeElasticsearchDomains",
      "es:listDomainNames",
      "events:describeApiDestination",
      "events:describeEventBus",
      "events:describeEventSource",
      "events:describePartnerEventSource",
      "events:describeRule",
      "events:listApiDestinations",
      "events:listConnections",
      "events:listEventBuses",
      "events:listEventSources",
      "events:listPartnerEventSourceAccounts",
      "events:listPartnerEventSources",
      "events:listRuleNamesByTarget",
      "events:listRules",
      "events:listTargetsByRule",
      "events:testEventPattern",
      "firehose:describeDeliveryStream",
      "firehose:listDeliveryStreams",
      "fms:getAdminAccount",
      "fms:getComplianceDetail",
      "fms:getNotificationChannel",
      "fms:getPolicy",
      "fms:getProtectionStatus",
      "fms:listComplianceStatus",
      "fms:listMemberAccounts",
      "fms:listPolicies",
      "forecast:describeDataset",
      "forecast:describeDatasetGroup",
      "forecast:describeDatasetImportJob",
      "forecast:describeForecast",
      "forecast:describeForecastExportJob",
      "forecast:describePredictor",
      "forecast:getAccuracyMetrics",
      "forecast:listDatasetGroups",
      "forecast:listDatasetImportJobs",
      "forecast:listDatasets",
      "forecast:listForecastExportJobs",
      "forecast:listForecasts",
      "forecast:listPredictors",
      "fsx:describeBackups",
      "fsx:describeDataRepositoryTasks",
      "fsx:describeFileSystems",
      "fsx:describeSnapshots",
      "fsx:describeStorageVirtualMachines",
      "fsx:describeVolumes",
      "fsx:listTagsForResource",
      "glacier:describeJob",
      "glacier:describeVault",
      "glacier:getDataRetrievalPolicy",
      "glacier:getVaultAccessPolicy",
      "glacier:getVaultLock",
      "glacier:getVaultNotifications",
      "glacier:listJobs",
      "glacier:listTagsForVault",
      "glacier:listVaults",
      "globalaccelerator:describeAccelerator",
      "globalaccelerator:describeAcceleratorAttributes",
      "globalaccelerator:describeEndpointGroup",
      "globalaccelerator:describeListener",
      "globalaccelerator:listAccelerators",
      "globalaccelerator:listEndpointGroups",
      "globalaccelerator:listListeners",
      "glue:batchGetPartition",
      "glue:checkSchemaVersionValidity",
      "glue:getCatalogImportStatus",
      "glue:getClassifier",
      "glue:getClassifiers",
      "glue:getCrawler",
      "glue:getCrawlerMetrics",
      "glue:getCrawlers",
      "glue:getDatabase",
      "glue:getDatabases",
      "glue:getDataflowGraph",
      "glue:getDevEndpoint",
      "glue:getDevEndpoints",
      "glue:getJob",
      "glue:getJobRun",
      "glue:getJobRuns",
      "glue:getJobs",
      "glue:getMapping",
      "glue:getPartition",
      "glue:getPartitions",
      "glue:getRegistry",
      "glue:getSchema",
      "glue:getSchemaByDefinition",
      "glue:getSchemaVersion",
      "glue:getSchemaVersionsDiff",
      "glue:getTable",
      "glue:getTables",
      "glue:getTableVersions",
      "glue:getTrigger",
      "glue:getTriggers",
      "glue:getUserDefinedFunction",
      "glue:getUserDefinedFunctions",
      "glue:listRegistries",
      "glue:listSchemas",
      "glue:listSchemaVersions",
      "glue:querySchemaVersionMetadata",
      "greengrass:getConnectivityInfo",
      "greengrass:getCoreDefinition",
      "greengrass:getCoreDefinitionVersion",
      "greengrass:getDeploymentStatus",
      "greengrass:getDeviceDefinition",
      "greengrass:getDeviceDefinitionVersion",
      "greengrass:getFunctionDefinition",
      "greengrass:getFunctionDefinitionVersion",
      "greengrass:getGroup",
      "greengrass:getGroupCertificateAuthority",
      "greengrass:getGroupVersion",
      "greengrass:getLoggerDefinition",
      "greengrass:getLoggerDefinitionVersion",
      "greengrass:getResourceDefinitionVersion",
      "greengrass:getServiceRoleForAccount",
      "greengrass:getSubscriptionDefinition",
      "greengrass:getSubscriptionDefinitionVersion",
      "greengrass:listCoreDefinitions",
      "greengrass:listCoreDefinitionVersions",
      "greengrass:listDeployments",
      "greengrass:listDeviceDefinitions",
      "greengrass:listDeviceDefinitionVersions",
      "greengrass:listFunctionDefinitions",
      "greengrass:listFunctionDefinitionVersions",
      "greengrass:listGroups",
      "greengrass:listGroupVersions",
      "greengrass:listLoggerDefinitions",
      "greengrass:listLoggerDefinitionVersions",
      "greengrass:listResourceDefinitions",
      "greengrass:listResourceDefinitionVersions",
      "greengrass:listSubscriptionDefinitions",
      "greengrass:listSubscriptionDefinitionVersions",
      "guardduty:getDetector",
      "guardduty:getFindings",
      "guardduty:getFindingsStatistics",
      "guardduty:getInvitationsCount",
      "guardduty:getIPSet",
      "guardduty:getMasterAccount",
      "guardduty:getMembers",
      "guardduty:getThreatIntelSet",
      "guardduty:listDetectors",
      "guardduty:listFindings",
      "guardduty:listInvitations",
      "guardduty:listIPSets",
      "guardduty:listMembers",
      "guardduty:listThreatIntelSets",
      "health:describeAffectedAccountsForOrganization",
      "health:describeAffectedEntities",
      "health:describeAffectedEntitiesForOrganization",
      "health:describeEntityAggregates",
      "health:describeEventAggregates",
      "health:describeEventDetails",
      "health:describeEventDetailsForOrganization",
      "health:describeEvents",
      "health:describeEventsForOrganization",
      "health:describeEventTypes",
      "health:describeHealthServiceStatusForOrganization",
      "iam:getAccessKeyLastUsed",
      "iam:getAccountAuthorizationDetails",
      "iam:getAccountPasswordPolicy",
      "iam:getAccountSummary",
      "iam:getContextKeysForCustomPolicy",
      "iam:getContextKeysForPrincipalPolicy",
      "iam:getCredentialReport",
      "iam:getGroup",
      "iam:getGroupPolicy",
      "iam:getInstanceProfile",
      "iam:getLoginProfile",
      "iam:getOpenIDConnectProvider",
      "iam:getPolicy",
      "iam:getPolicyVersion",
      "iam:getRole",
      "iam:getRolePolicy",
      "iam:getSAMLProvider",
      "iam:getServerCertificate",
      "iam:getSSHPublicKey",
      "iam:getUser",
      "iam:getUserPolicy",
      "iam:listAccessKeys",
      "iam:listAccountAliases",
      "iam:listAttachedGroupPolicies",
      "iam:listAttachedRolePolicies",
      "iam:listAttachedUserPolicies",
      "iam:listEntitiesForPolicy",
      "iam:listGroupPolicies",
      "iam:listGroups",
      "iam:listGroupsForUser",
      "iam:listInstanceProfiles",
      "iam:listInstanceProfilesForRole",
      "iam:listMFADevices",
      "iam:listOpenIDConnectProviders",
      "iam:listPolicies",
      "iam:listPolicyVersions",
      "iam:listRolePolicies",
      "iam:listRoles",
      "iam:listSAMLProviders",
      "iam:listServerCertificates",
      "iam:listSigningCertificates",
      "iam:listSSHPublicKeys",
      "iam:listUserPolicies",
      "iam:listUsers",
      "iam:listVirtualMFADevices",
      "iam:simulateCustomPolicy",
      "iam:simulatePrincipalPolicy",
      "imagebuilder:getComponent",
      "imagebuilder:getComponentPolicy",
      "imagebuilder:getContainerRecipe",
      "imagebuilder:getDistributionConfiguration",
      "imagebuilder:getImage",
      "imagebuilder:getImagePipeline",
      "imagebuilder:getImagePolicy",
      "imagebuilder:getImageRecipe",
      "imagebuilder:getImageRecipePolicy",
      "imagebuilder:getInfrastructureConfiguration",
      "imagebuilder:listComponentBuildVersions",
      "imagebuilder:listComponents",
      "imagebuilder:listContainerRecipes",
      "imagebuilder:listDistributionConfigurations",
      "imagebuilder:listImageBuildVersions",
      "imagebuilder:listImagePipelineImages",
      "imagebuilder:listImagePipelines",
      "imagebuilder:listImageRecipes",
      "imagebuilder:listImages",
      "imagebuilder:listInfrastructureConfigurations",
      "imagebuilder:listTagsForResource",
      "inspector:describeAssessmentRuns",
      "inspector:describeAssessmentTargets",
      "inspector:describeAssessmentTemplates",
      "inspector:describeCrossAccountAccessRole",
      "inspector:describeResourceGroups",
      "inspector:describeRulesPackages",
      "inspector:getTelemetryMetadata",
      "inspector:listAssessmentRunAgents",
      "inspector:listAssessmentRuns",
      "inspector:listAssessmentTargets",
      "inspector:listAssessmentTemplates",
      "inspector:listEventSubscriptions",
      "inspector:listRulesPackages",
      "inspector:listTagsForResource",
      "inspector2:batchGetAccountStatus",
      "inspector2:batchGetFreeTrialInfo",
      "inspector2:describeOrganizationConfiguration",
      "inspector2:getDelegatedAdminAccount",
      "inspector2:getMember",
      "inspector2:listCoverage",
      "inspector2:listDelegatedAdminAccounts",
      "inspector2:listFilters",
      "inspector2:listFindings",
      "inspector2:listMembers",
      "inspector2:listUsageTotals",
      "iot:describeAuthorizer",
      "iot:describeCACertificate",
      "iot:describeCertificate",
      "iot:describeDefaultAuthorizer",
      "iot:describeEndpoint",
      "iot:describeIndex",
      "iot:describeJobExecution",
      "iot:describeThing",
      "iot:describeThingGroup",
      "iot:describeTunnel",
      "iot:getEffectivePolicies",
      "iot:getIndexingConfiguration",
      "iot:getLoggingOptions",
      "iot:getPolicy",
      "iot:getPolicyVersion",
      "iot:getTopicRule",
      "iot:getV2LoggingOptions",
      "iot:listAttachedPolicies",
      "iot:listAuthorizers",
      "iot:listCACertificates",
      "iot:listCertificates",
      "iot:listCertificatesByCA",
      "iot:listJobExecutionsForJob",
      "iot:listJobExecutionsForThing",
      "iot:listJobs",
      "iot:listOutgoingCertificates",
      "iot:listPolicies",
      "iot:listPolicyPrincipals",
      "iot:listPolicyVersions",
      "iot:listPrincipalPolicies",
      "iot:listPrincipalThings",
      "iot:listRoleAliases",
      "iot:listTargetsForPolicy",
      "iot:listThingGroups",
      "iot:listThingGroupsForThing",
      "iot:listThingPrincipals",
      "iot:listThingRegistrationTasks",
      "iot:listThings",
      "iot:listThingTypes",
      "iot:listTopicRules",
      "iot:listTunnels",
      "iot:listV2LoggingLevels",
      "iotevents:describeDetector",
      "iotevents:describeDetectorModel",
      "iotevents:describeInput",
      "iotevents:describeLoggingOptions",
      "iotevents:listDetectorModels",
      "iotevents:listDetectorModelVersions",
      "iotevents:listDetectors",
      "iotevents:listInputs",
      "iotsitewise:describeAccessPolicy",
      "iotsitewise:describeAsset",
      "iotsitewise:describeAssetModel",
      "iotsitewise:describeAssetProperty",
      "iotsitewise:describeDashboard",
      "iotsitewise:describeGateway",
      "iotsitewise:describeGatewayCapabilityConfiguration",
      "iotsitewise:describeLoggingOptions",
      "iotsitewise:describePortal",
      "iotsitewise:describeProject",
      "iotsitewise:listAccessPolicies",
      "iotsitewise:listAssetModels",
      "iotsitewise:listAssets",
      "iotsitewise:listAssociatedAssets",
      "iotsitewise:listDashboards",
      "iotsitewise:listGateways",
      "iotsitewise:listPortals",
      "iotsitewise:listProjectAssets",
      "iotsitewise:listProjects",
      "iotwireless:getDestination",
      "iotwireless:getDeviceProfile",
      "iotwireless:getPartnerAccount",
      "iotwireless:getServiceEndpoint",
      "iotwireless:getServiceProfile",
      "iotwireless:getWirelessDevice",
      "iotwireless:getWirelessDeviceStatistics",
      "iotwireless:getWirelessGateway",
      "iotwireless:getWirelessGatewayCertificate",
      "iotwireless:getWirelessGatewayFirmwareInformation",
      "iotwireless:getWirelessGatewayStatistics",
      "iotwireless:getWirelessGatewayTask",
      "iotwireless:getWirelessGatewayTaskDefinition",
      "iotwireless:listDestinations",
      "iotwireless:listDeviceProfiles",
      "iotwireless:listPartnerAccounts",
      "iotwireless:listServiceProfiles",
      "iotwireless:listTagsForResource",
      "iotwireless:listWirelessDevices",
      "iotwireless:listWirelessGateways",
      "iotwireless:listWirelessGatewayTaskDefinitions",
      "ivs:listChannels",
      "ivs:listStreams",
      "ivs:listStreamSessions",
      "kafka:describeCluster",
      "kafka:getBootstrapBrokers",
      "kafka:listClusters",
      "kafka:listNodes",
      "kendra:describeDataSource",
      "kendra:describeFaq",
      "kendra:describeIndex",
      "kendra:listDataSources",
      "kendra:listFaqs",
      "kendra:listIndices",
      "kinesis:describeStream",
      "kinesis:describeStreamConsumer",
      "kinesis:describeStreamSummary",
      "kinesis:listShards",
      "kinesis:listStreams",
      "kinesis:listStreamConsumers",
      "kinesis:listTagsForStream",
      "kinesisanalytics:describeApplication",
      "kinesisanalytics:describeApplicationSnapshot",
      "kinesisanalytics:listApplications",
      "kinesisanalytics:listApplicationSnapshots",
      "kms:describeKey",
      "kms:getKeyPolicy",
      "kms:getKeyRotationStatus",
      "kms:listAliases",
      "kms:listGrants",
      "kms:listKeyPolicies",
      "kms:listKeys",
      "kms:listResourceTags",
      "kms:listRetirableGrants",
      "lambda:getAccountSettings",
      "lambda:getAlias",
      "lambda:getCodeSigningConfig",
      "lambda:getEventSourceMapping",
      "lambda:getFunction",
      "lambda:getFunctionCodeSigningConfig",
      "lambda:getFunctionConcurrency",
      "lambda:getFunctionConfiguration",
      "lambda:getFunctionEventInvokeConfig",
      "lambda:getLayerVersion",
      "lambda:getLayerVersionPolicy",
      "lambda:getPolicy",
      "lambda:getProvisionedConcurrencyConfig",
      "lambda:listAliases",
      "lambda:listCodeSigningConfigs",
      "lambda:listEventSourceMappings",
      "lambda:listFunctionEventInvokeConfigs",
      "lambda:listFunctions",
      "lambda:listFunctionsByCodeSigningConfig",
      "lambda:listLayers",
      "lambda:listLayerVersions",
      "lambda:listProvisionedConcurrencyConfigs",
      "lambda:listVersionsByFunction",
      "launchwizard:describeProvisionedApp",
      "launchwizard:describeProvisioningEvents",
      "launchwizard:listProvisionedApps",
      "lex:getBot",
      "lex:getBotAlias",
      "lex:getBotAliases",
      "lex:getBotChannelAssociation",
      "lex:getBotChannelAssociations",
      "lex:getBots",
      "lex:getBotVersions",
      "lex:getBuiltinIntent",
      "lex:getBuiltinIntents",
      "lex:getBuiltinSlotTypes",
      "lex:getIntent",
      "lex:getIntents",
      "lex:getIntentVersions",
      "lex:getSlotType",
      "lex:getSlotTypes",
      "lex:getSlotTypeVersions",
      "license-manager:getLicenseConfiguration",
      "license-manager:getServiceSettings",
      "license-manager:listAssociationsForLicenseConfiguration",
      "license-manager:listFailuresForLicenseConfigurationOperations",
      "license-manager:listLicenseConfigurations",
      "license-manager:listLicenseSpecificationsForResource",
      "license-manager:listResourceInventory",
      "license-manager:listUsageForLicenseConfiguration",
      "lightsail:getActiveNames",
      "lightsail:getAlarms",
      "lightsail:getAutoSnapshots",
      "lightsail:getBlueprints",
      "lightsail:getBucketBundles",
      "lightsail:getBucketMetricData",
      "lightsail:getBuckets",
      "lightsail:getBundles",
      "lightsail:getCertificates",
      "lightsail:getContainerImages",
      "lightsail:getContainerServiceDeployments",
      "lightsail:getContainerServiceMetricData",
      "lightsail:getContainerServicePowers",
      "lightsail:getContainerServices",
      "lightsail:getDisk",
      "lightsail:getDisks",
      "lightsail:getDiskSnapshot",
      "lightsail:getDiskSnapshots",
      "lightsail:getDistributionBundles",
      "lightsail:getDistributionMetricData",
      "lightsail:getDistributions",
      "lightsail:getDomain",
      "lightsail:getDomains",
      "lightsail:getExportSnapshotRecords",
      "lightsail:getInstance",
      "lightsail:getInstanceMetricData",
      "lightsail:getInstancePortStates",
      "lightsail:getInstances",
      "lightsail:getInstanceSnapshot",
      "lightsail:getInstanceSnapshots",
      "lightsail:getInstanceState",
      "lightsail:getKeyPair",
      "lightsail:getKeyPairs",
      "lightsail:getLoadBalancer",
      "lightsail:getLoadBalancerMetricData",
      "lightsail:getLoadBalancers",
      "lightsail:getLoadBalancerTlsCertificates",
      "lightsail:getOperation",
      "lightsail:getOperations",
      "lightsail:getOperationsForResource",
      "lightsail:getRegions",
      "lightsail:getRelationalDatabase",
      "lightsail:getRelationalDatabaseMetricData",
      "lightsail:getRelationalDatabases",
      "lightsail:getRelationalDatabaseSnapshot",
      "lightsail:getRelationalDatabaseSnapshots",
      "lightsail:getStaticIp",
      "lightsail:getStaticIps",
      "lightsail:isVpcPeered",
      "logs:describeDestinations",
      "logs:describeExportTasks",
      "logs:describeLogGroups",
      "logs:describeLogStreams",
      "logs:describeMetricFilters",
      "logs:describeQueries",
      "logs:describeResourcePolicies",
      "logs:describeSubscriptionFilters",
      "logs:getLogDelivery",
      "logs:listLogDeliveries",
      "logs:testMetricFilter",
      "lookoutmetrics:describeAlert",
      "lookoutmetrics:describeAnomalyDetectionExecutions",
      "lookoutmetrics:describeAnomalyDetector",
      "lookoutmetrics:describeMetricSet",
      "lookoutmetrics:getAnomalyGroup",
      "lookoutmetrics:getDataQualityMetrics",
      "lookoutmetrics:getFeedback",
      "lookoutmetrics:getSampleData",
      "lookoutmetrics:listAlerts",
      "lookoutmetrics:listAnomalyDetectors",
      "lookoutmetrics:listAnomalyGroupSummaries",
      "lookoutmetrics:listAnomalyGroupTimeSeries",
      "lookoutmetrics:listMetricSets",
      "lookoutmetrics:listTagsForResource",
      "machinelearning:describeBatchPredictions",
      "machinelearning:describeDataSources",
      "machinelearning:describeEvaluations",
      "machinelearning:describeMLModels",
      "machinelearning:getBatchPrediction",
      "machinelearning:getDataSource",
      "machinelearning:getEvaluation",
      "machinelearning:getMLModel",
      "macie2:getClassificationExportConfiguration",
      "macie2:getCustomDataIdentifier",
      "macie2:getFindings",
      "macie2:getFindingStatistics",
      "macie2:listClassificationJobs",
      "macie2:listCustomDataIdentifiers",
      "macie2:listFindings",
      "managedblockchain:getMember",
      "managedblockchain:getNetwork",
      "managedblockchain:getNode",
      "managedblockchain:listMembers",
      "managedblockchain:listNetworks",
      "managedblockchain:listNodes",
      "mediaconnect:describeFlow",
      "mediaconnect:listEntitlements",
      "mediaconnect:listFlows",
      "mediaconvert:describeEndpoints",
      "mediaconvert:getJob",
      "mediaconvert:getJobTemplate",
      "mediaconvert:getPreset",
      "mediaconvert:getQueue",
      "mediaconvert:listJobs",
      "mediaconvert:listJobTemplates",
      "medialive:describeChannel",
      "medialive:describeInput",
      "medialive:describeInputDevice",
      "medialive:describeInputSecurityGroup",
      "medialive:describeMultiplex",
      "medialive:describeOffering",
      "medialive:describeReservation",
      "medialive:describeSchedule",
      "medialive:listChannels",
      "medialive:listInputDevices",
      "medialive:listInputs",
      "medialive:listInputSecurityGroups",
      "medialive:listMultiplexes",
      "medialive:listOfferings",
      "medialive:listReservations",
      "mediapackage:describeChannel",
      "mediapackage:describeOriginEndpoint",
      "mediapackage:listChannels",
      "mediapackage:listOriginEndpoints",
      "mediastore:describeContainer",
      "mediastore:getContainerPolicy",
      "mediastore:getCorsPolicy",
      "mediastore:listContainers",
      "mediatailor:getPlaybackConfiguration",
      "mediatailor:listPlaybackConfigurations",
      "mgn:describeJobLogItems",
      "mgn:describeJobs",
      "mgn:describeReplicationConfigurationTemplates",
      "mgn:describeSourceServers",
      "mgn:describeVcenterClients",
      "mgn:getLaunchConfiguration",
      "mgn:getReplicationConfiguration",
      "mobiletargeting:getAdmChannel",
      "mobiletargeting:getApnsChannel",
      "mobiletargeting:getApnsSandboxChannel",
      "mobiletargeting:getApnsVoipChannel",
      "mobiletargeting:getApnsVoipSandboxChannel",
      "mobiletargeting:getApp",
      "mobiletargeting:getApplicationSettings",
      "mobiletargeting:getApps",
      "mobiletargeting:getBaiduChannel",
      "mobiletargeting:getCampaign",
      "mobiletargeting:getCampaignActivities",
      "mobiletargeting:getCampaigns",
      "mobiletargeting:getCampaignVersion",
      "mobiletargeting:getCampaignVersions",
      "mobiletargeting:getEmailChannel",
      "mobiletargeting:getEndpoint",
      "mobiletargeting:getEventStream",
      "mobiletargeting:getExportJob",
      "mobiletargeting:getExportJobs",
      "mobiletargeting:getGcmChannel",
      "mobiletargeting:getImportJob",
      "mobiletargeting:getImportJobs",
      "mobiletargeting:getSegment",
      "mobiletargeting:getSegmentImportJobs",
      "mobiletargeting:getSegments",
      "mobiletargeting:getSegmentVersion",
      "mobiletargeting:getSegmentVersions",
      "mobiletargeting:getSmsChannel",
      "mq:describeBroker",
      "mq:describeConfiguration",
      "mq:describeConfigurationRevision",
      "mq:describeUser",
      "mq:listBrokers",
      "mq:listConfigurationRevisions",
      "mq:listConfigurations",
      "mq:listUsers",
      "network-firewall:describeFirewall",
      "network-firewall:describeFirewallPolicy",
      "network-firewall:describeLoggingConfiguration",
      "network-firewall:describeRuleGroup",
      "network-firewall:listFirewallPolicies",
      "network-firewall:listFirewalls",
      "network-firewall:listRuleGroups",
      "networkmanager:describeGlobalNetworks",
      "networkmanager:getConnectAttachment",
      "networkmanager:getConnections",
      "networkmanager:getConnectPeer",
      "networkmanager:getConnectPeerAssociations",
      "networkmanager:getCoreNetwork",
      "networkmanager:getCoreNetworkChangeSet",
      "networkmanager:getCoreNetworkPolicy",
      "networkmanager:getCustomerGatewayAssociations",
      "networkmanager:getDevices",
      "networkmanager:getLinkAssociations",
      "networkmanager:getLinks",
      "networkmanager:getNetworkResourceCounts",
      "networkmanager:getNetworkResourceRelationships",
      "networkmanager:getNetworkResources",
      "networkmanager:getNetworkRoutes",
      "networkmanager:getNetworkTelemetry",
      "networkmanager:getResourcePolicy",
      "networkmanager:getRouteAnalysis",
      "networkmanager:getSites",
      "networkmanager:getSiteToSiteVpnAttachment",
      "networkmanager:getTransitGatewayConnectPeerAssociations",
      "networkmanager:getTransitGatewayRegistrations",
      "networkmanager:getVpcAttachment",
      "networkmanager:listAttachments",
      "networkmanager:listConnectPeers",
      "networkmanager:listCoreNetworkPolicyVersions",
      "networkmanager:listCoreNetworks",
      "networkmanager:listTagsForResource",
      "opsworks-cm:describeAccountAttributes",
      "opsworks-cm:describeBackups",
      "opsworks-cm:describeEvents",
      "opsworks-cm:describeNodeAssociationStatus",
      "opsworks-cm:describeServers",
      "opsworks:describeAgentVersions",
      "opsworks:describeApps",
      "opsworks:describeCommands",
      "opsworks:describeDeployments",
      "opsworks:describeEcsClusters",
      "opsworks:describeElasticIps",
      "opsworks:describeElasticLoadBalancers",
      "opsworks:describeInstances",
      "opsworks:describeLayers",
      "opsworks:describeLoadBasedAutoScaling",
      "opsworks:describeMyUserProfile",
      "opsworks:describePermissions",
      "opsworks:describeRaidArrays",
      "opsworks:describeRdsDbInstances",
      "opsworks:describeServiceErrors",
      "opsworks:describeStackProvisioningParameters",
      "opsworks:describeStacks",
      "opsworks:describeStackSummary",
      "opsworks:describeTimeBasedAutoScaling",
      "opsworks:describeUserProfiles",
      "opsworks:describeVolumes",
      "opsworks:getHostnameSuggestion",
      "organizations:listAccounts",
      "organizations:listTagsForResource",
      "outposts:getOutpost",
      "outposts:getOutpostInstanceTypes",
      "outposts:listOutposts",
      "outposts:listSites",
      "personalize:describeAlgorithm",
      "personalize:describeCampaign",
      "personalize:describeDataset",
      "personalize:describeDatasetGroup",
      "personalize:describeDatasetImportJob",
      "personalize:describeEventTracker",
      "personalize:describeFeatureTransformation",
      "personalize:describeRecipe",
      "personalize:describeSchema",
      "personalize:describeSolution",
      "personalize:describeSolutionVersion",
      "personalize:listCampaigns",
      "personalize:listDatasetGroups",
      "personalize:listDatasetImportJobs",
      "personalize:listDatasets",
      "personalize:listEventTrackers",
      "personalize:listRecipes",
      "personalize:listSchemas",
      "personalize:listSolutions",
      "personalize:listSolutionVersions",
      "polly:describeVoices",
      "polly:getLexicon",
      "polly:listLexicons",
      "pricing:describeServices",
      "pricing:getAttributeValues",
      "pricing:getProducts",
      "quicksight:describeDashboard",
      "quicksight:describeDashboardPermissions",
      "quicksight:describeGroup",
      "quicksight:describeIAMPolicyAssignment",
      "quicksight:describeTemplate",
      "quicksight:describeTemplateAlias",
      "quicksight:describeTemplatePermissions",
      "quicksight:describeUser",
      "quicksight:listDashboards",
      "quicksight:listGroupMemberships",
      "quicksight:listGroups",
      "quicksight:listIAMPolicyAssignments",
      "quicksight:listIAMPolicyAssignmentsForUser",
      "quicksight:listTemplateAliases",
      "quicksight:listTemplates",
      "quicksight:listTemplateVersions",
      "quicksight:listUserGroups",
      "quicksight:listUsers",
      "ram:getPermission",
      "ram:getResourceShareAssociations",
      "ram:getResourceShareInvitations",
      "ram:getResourceShares",
      "ram:listPendingInvitationResources",
      "ram:listPrincipals",
      "ram:listResources",
      "ram:listResourceSharePermissions",
      "rbin:getRule",
      "rbin:listRules",
      "rds:describeAccountAttributes",
      "rds:describeCertificates",
      "rds:describeDBClusterParameterGroups",
      "rds:describeDBClusterParameters",
      "rds:describeDBClusters",
      "rds:describeDBClusterSnapshots",
      "rds:describeDBEngineVersions",
      "rds:describeDBInstances",
      "rds:describeDBParameterGroups",
      "rds:describeDBParameters",
      "rds:describeDBSecurityGroups",
      "rds:describeDBSnapshotAttributes",
      "rds:describeDBSnapshots",
      "rds:describeDBSubnetGroups",
      "rds:describeEngineDefaultClusterParameters",
      "rds:describeEngineDefaultParameters",
      "rds:describeEventCategories",
      "rds:describeEvents",
      "rds:describeEventSubscriptions",
      "rds:describeExportTasks",
      "rds:describeOptionGroupOptions",
      "rds:describeOptionGroups",
      "rds:describeOrderableDBInstanceOptions",
      "rds:describePendingMaintenanceActions",
      "rds:describeReservedDBInstances",
      "rds:describeReservedDBInstancesOfferings",
      "rds:listTagsForResource",
      "redshift-data:describeStatement",
      "redshift-data:listStatements",
      "redshift:describeClusterParameterGroups",
      "redshift:describeClusterParameters",
      "redshift:describeClusters",
      "redshift:describeClusterSecurityGroups",
      "redshift:describeClusterSnapshots",
      "redshift:describeClusterSubnetGroups",
      "redshift:describeClusterVersions",
      "redshift:describeDefaultClusterParameters",
      "redshift:describeEventCategories",
      "redshift:describeEvents",
      "redshift:describeEventSubscriptions",
      "redshift:describeHsmClientCertificates",
      "redshift:describeHsmConfigurations",
      "redshift:describeLoggingStatus",
      "redshift:describeOrderableClusterOptions",
      "redshift:describeReservedNodeOfferings",
      "redshift:describeReservedNodes",
      "redshift:describeResize",
      "redshift:describeSnapshotCopyGrants",
      "redshift:describeStorage",
      "redshift:describeTableRestoreStatus",
      "redshift:describeTags",
      "rekognition:listCollections",
      "rekognition:listFaces",
      "resource-groups:getGroup",
      "resource-groups:getGroupQuery",
      "resource-groups:getTags",
      "resource-groups:listGroupResources",
      "resource-groups:listGroups",
      "resource-groups:searchResources",
      "robomaker:batchDescribeSimulationJob",
      "robomaker:describeDeploymentJob",
      "robomaker:describeFleet",
      "robomaker:describeRobot",
      "robomaker:describeRobotApplication",
      "robomaker:describeSimulationApplication",
      "robomaker:describeSimulationJob",
      "robomaker:listDeploymentJobs",
      "robomaker:listFleets",
      "robomaker:listRobotApplications",
      "robomaker:listRobots",
      "robomaker:listSimulationApplications",
      "robomaker:listSimulationJobs",
      "route53-recovery-readiness:getCell",
      "route53-recovery-readiness:getCellReadinessSummary",
      "route53-recovery-readiness:getReadinessCheck",
      "route53-recovery-readiness:getReadinessCheckResourceStatus",
      "route53-recovery-readiness:getReadinessCheckStatus",
      "route53-recovery-readiness:getRecoveryGroup",
      "route53-recovery-readiness:getRecoveryGroupReadinessSummary",
      "route53-recovery-readiness:listCells",
      "route53-recovery-readiness:listReadinessChecks",
      "route53-recovery-readiness:listRecoveryGroups",
      "route53-recovery-readiness:listResourceSets",
      "route53:getChange",
      "route53:getCheckerIpRanges",
      "route53:getGeoLocation",
      "route53:getHealthCheck",
      "route53:getHealthCheckCount",
      "route53:getHealthCheckLastFailureReason",
      "route53:getHealthCheckStatus",
      "route53:getHostedZone",
      "route53:getHostedZoneCount",
      "route53:getReusableDelegationSet",
      "route53:getTrafficPolicy",
      "route53:getTrafficPolicyInstance",
      "route53:getTrafficPolicyInstanceCount",
      "route53:listGeoLocations",
      "route53:listHealthChecks",
      "route53:listHostedZones",
      "route53:listHostedZonesByName",
      "route53:listResourceRecordSets",
      "route53:listReusableDelegationSets",
      "route53:listTrafficPolicies",
      "route53:listTrafficPolicyInstances",
      "route53:listTrafficPolicyInstancesByHostedZone",
      "route53:listTrafficPolicyInstancesByPolicy",
      "route53:listTrafficPolicyVersions",
      "route53domains:checkDomainAvailability",
      "route53domains:getContactReachabilityStatus",
      "route53domains:getDomainDetail",
      "route53domains:getOperationDetail",
      "route53domains:listDomains",
      "route53domains:listOperations",
      "route53domains:listTagsForDomain",
      "route53domains:viewBilling",
      "route53resolver:getFirewallConfig",
      "route53resolver:getFirewallDomainList",
      "route53resolver:getFirewallRuleGroup",
      "route53resolver:getFirewallRuleGroupAssociation",
      "route53resolver:getResolverDnssecConfig",
      "route53resolver:getResolverRulePolicy",
      "route53resolver:listFirewallConfigs",
      "route53resolver:listFirewallDomainLists",
      "route53resolver:listFirewallDomains",
      "route53resolver:listFirewallRuleGroupAssociations",
      "route53resolver:listFirewallRuleGroups",
      "route53resolver:listFirewallRules",
      "route53resolver:listResolverDnssecConfigs",
      "route53resolver:listResolverEndpointIpAddresses",
      "route53resolver:listResolverEndpoints",
      "route53resolver:listResolverRuleAssociations",
      "route53resolver:listResolverRules",
      "route53resolver:listTagsForResource",
      "s3:describeJob",
      "s3:describeMultiRegionAccessPointOperation",
      "s3:getAccelerateConfiguration",
      "s3:getAccessPoint",
      "s3:getAccessPointConfigurationForObjectLambda",
      "s3:getAccessPointForObjectLambda",
      "s3:getAccessPointPolicy",
      "s3:getAccessPointPolicyForObjectLambda",
      "s3:getAccessPointPolicyStatus",
      "s3:getAccessPointPolicyStatusForObjectLambda",
      "s3:getAccountPublicAccessBlock",
      "s3:getAnalyticsConfiguration",
      "s3:getBucketAcl",
      "s3:getBucketCORS",
      "s3:getBucketLocation",
      "s3:getBucketLogging",
      "s3:getBucketNotification",
      "s3:getBucketObjectLockConfiguration",
      "s3:getBucketOwnershipControls",
      "s3:getBucketPolicy",
      "s3:getBucketPolicyStatus",
      "s3:getBucketPublicAccessBlock",
      "s3:getBucketRequestPayment",
      "s3:getBucketVersioning",
      "s3:getBucketWebsite",
      "s3:getEncryptionConfiguration",
      "s3:getIntelligentTieringConfiguration",
      "s3:getInventoryConfiguration",
      "s3:getLifecycleConfiguration",
      "s3:getMetricsConfiguration",
      "s3:getMultiRegionAccessPoint",
      "s3:getMultiRegionAccessPointPolicy",
      "s3:getMultiRegionAccessPointPolicyStatus",
      "s3:getObjectLegalHold",
      "s3:getObjectRetention",
      "s3:getReplicationConfiguration",
      "s3:getStorageLensConfiguration",
      "s3:listAccessPoints",
      "s3:listAccessPointsForObjectLambda",
      "s3:listAllMyBuckets",
      "s3:listBucket",
      "s3:listBucketMultipartUploads",
      "s3:listBucketVersions",
      "s3:listJobs",
      "s3:listMultipartUploadParts",
      "s3:listMultiRegionAccessPoints",
      "s3:listStorageLensConfigurations",
      "sagemaker:describeAction",
      "sagemaker:describeAlgorithm",
      "sagemaker:describeApp",
      "sagemaker:describeArtifact",
      "sagemaker:describeAutoMLJob",
      "sagemaker:describeCompilationJob",
      "sagemaker:describeContext",
      "sagemaker:describeDataQualityJobDefinition",
      "sagemaker:describeDevice",
      "sagemaker:describeDeviceFleet",
      "sagemaker:describeDomain",
      "sagemaker:describeEdgePackagingJob",
      "sagemaker:describeEndpoint",
      "sagemaker:describeEndpointConfig",
      "sagemaker:describeExperiment",
      "sagemaker:describeFeatureGroup",
      "sagemaker:describeHumanTaskUi",
      "sagemaker:describeHyperParameterTuningJob",
      "sagemaker:describeImage",
      "sagemaker:describeImageVersion",
      "sagemaker:describeLabelingJob",
      "sagemaker:describeModel",
      "sagemaker:describeModelBiasJobDefinition",
      "sagemaker:describeModelExplainabilityJobDefinition",
      "sagemaker:describeModelPackage",
      "sagemaker:describeModelPackageGroup",
      "sagemaker:describeModelQualityJobDefinition",
      "sagemaker:describeMonitoringSchedule",
      "sagemaker:describeNotebookInstance",
      "sagemaker:describeNotebookInstanceLifecycleConfig",
      "sagemaker:describePipeline",
      "sagemaker:describePipelineDefinitionForExecution",
      "sagemaker:describePipelineExecution",
      "sagemaker:describeProcessingJob",
      "sagemaker:describeProject",
      "sagemaker:describeSubscribedWorkteam",
      "sagemaker:describeTrainingJob",
      "sagemaker:describeTransformJob",
      "sagemaker:describeTrial",
      "sagemaker:describeTrialComponent",
      "sagemaker:describeUserProfile",
      "sagemaker:describeWorkteam",
      "sagemaker:listActions",
      "sagemaker:listAlgorithms",
      "sagemaker:listApps",
      "sagemaker:listArtifacts",
      "sagemaker:listAssociations",
      "sagemaker:listAutoMLJobs",
      "sagemaker:listCandidatesForAutoMLJob",
      "sagemaker:listCodeRepositories",
      "sagemaker:listCompilationJobs",
      "sagemaker:listContexts",
      "sagemaker:listDataQualityJobDefinitions",
      "sagemaker:listDeviceFleets",
      "sagemaker:listDevices",
      "sagemaker:listDomains",
      "sagemaker:listEdgePackagingJobs",
      "sagemaker:listEndpointConfigs",
      "sagemaker:listEndpoints",
      "sagemaker:listExperiments",
      "sagemaker:listFeatureGroups",
      "sagemaker:listFlowDefinitions",
      "sagemaker:listHumanTaskUis",
      "sagemaker:listHyperParameterTuningJobs",
      "sagemaker:listImages",
      "sagemaker:listImageVersions",
      "sagemaker:listLabelingJobs",
      "sagemaker:listLabelingJobsForWorkteam",
      "sagemaker:listModelBiasJobDefinitions",
      "sagemaker:listModelExplainabilityJobDefinitions",
      "sagemaker:listModelPackageGroups",
      "sagemaker:listModelPackages",
      "sagemaker:listModelQualityJobDefinitions",
      "sagemaker:listModels",
      "sagemaker:listMonitoringExecutions",
      "sagemaker:listMonitoringSchedules",
      "sagemaker:listNotebookInstanceLifecycleConfigs",
      "sagemaker:listNotebookInstances",
      "sagemaker:listPipelineExecutions",
      "sagemaker:listPipelineExecutionSteps",
      "sagemaker:listPipelineParametersForExecution",
      "sagemaker:listPipelines",
      "sagemaker:listProcessingJobs",
      "sagemaker:listProjects",
      "sagemaker:listSubscribedWorkteams",
      "sagemaker:listTags",
      "sagemaker:listTrainingJobs",
      "sagemaker:listTrainingJobsForHyperParameterTuningJob",
      "sagemaker:listTransformJobs",
      "sagemaker:listTrialComponents",
      "sagemaker:listTrials",
      "sagemaker:listUserProfiles",
      "sagemaker:listWorkteams",
      "savingsplans:describeSavingsPlans",
      "sdb:domainMetadata",
      "sdb:listDomains",
      "secretsmanager:describeSecret",
      "secretsmanager:getResourcePolicy",
      "secretsmanager:listSecrets",
      "secretsmanager:listSecretVersionIds",
      "securityhub:getEnabledStandards",
      "securityhub:getFindings",
      "securityhub:getInsightResults",
      "securityhub:getInsights",
      "securityhub:getMasterAccount",
      "securityhub:getMembers",
      "securityhub:listEnabledProductsForImport",
      "securityhub:listInvitations",
      "securityhub:listMembers",
      "serverlessrepo:getApplication",
      "serverlessrepo:getApplicationPolicy",
      "serverlessrepo:getCloudFormationTemplate",
      "serverlessrepo:listApplicationDependencies",
      "serverlessrepo:listApplications",
      "serverlessrepo:listApplicationVersions",
      "servicecatalog:describeConstraint",
      "servicecatalog:describePortfolio",
      "servicecatalog:describeProduct",
      "servicecatalog:describeProductAsAdmin",
      "servicecatalog:describeProductView",
      "servicecatalog:describeProvisioningArtifact",
      "servicecatalog:describeProvisioningParameters",
      "servicecatalog:describeRecord",
      "servicecatalog:listAcceptedPortfolioShares",
      "servicecatalog:listConstraintsForPortfolio",
      "servicecatalog:listLaunchPaths",
      "servicecatalog:listPortfolioAccess",
      "servicecatalog:listPortfolios",
      "servicecatalog:listPortfoliosForProduct",
      "servicecatalog:listPrincipalsForPortfolio",
      "servicecatalog:listProvisioningArtifacts",
      "servicecatalog:listRecordHistory",
      "servicecatalog:scanProvisionedProducts",
      "servicecatalog:searchProducts",
      "servicequotas:getAssociationForServiceQuotaTemplate",
      "servicequotas:getAWSDefaultServiceQuota",
      "servicequotas:getRequestedServiceQuotaChange",
      "servicequotas:getServiceQuota",
      "servicequotas:getServiceQuotaIncreaseRequestFromTemplate",
      "servicequotas:listAWSDefaultServiceQuotas",
      "servicequotas:listRequestedServiceQuotaChangeHistory",
      "servicequotas:listRequestedServiceQuotaChangeHistoryByQuota",
      "servicequotas:listServiceQuotaIncreaseRequestsInTemplate",
      "servicequotas:listServiceQuotas",
      "servicequotas:listServices",
      "ses:describeActiveReceiptRuleSet",
      "ses:describeReceiptRule",
      "ses:describeReceiptRuleSet",
      "ses:getAccount",
      "ses:getBlacklistReports",
      "ses:getConfigurationSet",
      "ses:getConfigurationSetEventDestinations",
      "ses:getDedicatedIp",
      "ses:getDedicatedIps",
      "ses:getDeliverabilityDashboardOptions",
      "ses:getDeliverabilityTestReport",
      "ses:getDomainDeliverabilityCampaign",
      "ses:getDomainStatisticsReport",
      "ses:getEmailIdentity",
      "ses:getIdentityDkimAttributes",
      "ses:getIdentityMailFromDomainAttributes",
      "ses:getIdentityNotificationAttributes",
      "ses:getIdentityPolicies",
      "ses:getIdentityVerificationAttributes",
      "ses:getSendQuota",
      "ses:getSendStatistics",
      "ses:listConfigurationSets",
      "ses:listDedicatedIpPools",
      "ses:listDeliverabilityTestReports",
      "ses:listDomainDeliverabilityCampaigns",
      "ses:listEmailIdentities",
      "ses:listIdentities",
      "ses:listIdentityPolicies",
      "ses:listReceiptFilters",
      "ses:listReceiptRuleSets",
      "ses:listTagsForResource",
      "ses:listVerifiedEmailAddresses",
      "shield:describeAttack",
      "shield:describeProtection",
      "shield:describeSubscription",
      "shield:listAttacks",
      "shield:listProtections",
      "sms-voice:getConfigurationSetEventDestinations",
      "sms:getConnectors",
      "sms:getReplicationJobs",
      "sms:getReplicationRuns",
      "sms:getServers",
      "snowball:describeAddress",
      "snowball:describeAddresses",
      "snowball:describeJob",
      "snowball:getSnowballUsage",
      "snowball:listJobs",
      "sns:checkIfPhoneNumberIsOptedOut",
      "sns:getEndpointAttributes",
      "sns:getPlatformApplicationAttributes",
      "sns:getSMSAttributes",
      "sns:getSubscriptionAttributes",
      "sns:getTopicAttributes",
      "sns:listEndpointsByPlatformApplication",
      "sns:listPhoneNumbersOptedOut",
      "sns:listPlatformApplications",
      "sns:listSubscriptions",
      "sns:listSubscriptionsByTopic",
      "sns:listTopics",
      "sqs:getQueueAttributes",
      "sqs:getQueueUrl",
      "sqs:listDeadLetterSourceQueues",
      "sqs:listQueues",
      "ssm-contacts:describeEngagement",
      "ssm-contacts:describePage",
      "ssm-contacts:getContact",
      "ssm-contacts:getContactChannel",
      "ssm-contacts:listContactChannels",
      "ssm-contacts:listContacts",
      "ssm-contacts:listEngagements",
      "ssm-contacts:listPageReceipts",
      "ssm-contacts:listPagesByContact",
      "ssm-contacts:listPagesByEngagement",
      "ssm-incidents:getIncidentRecord",
      "ssm-incidents:getReplicationSet",
      "ssm-incidents:getResponsePlan",
      "ssm-incidents:listIncidentRecords",
      "ssm-incidents:listReplicationSets",
      "ssm-incidents:listResponsePlans",
      "ssm-incidents:listTimelineEvents",
      "ssm:describeActivations",
      "ssm:describeAssociation",
      "ssm:describeAssociationExecutions",
      "ssm:describeAssociationExecutionTargets",
      "ssm:describeAutomationExecutions",
      "ssm:describeAutomationStepExecutions",
      "ssm:describeAvailablePatches",
      "ssm:describeDocument",
      "ssm:describeDocumentPermission",
      "ssm:describeEffectiveInstanceAssociations",
      "ssm:describeEffectivePatchesForPatchBaseline",
      "ssm:describeInstanceAssociationsStatus",
      "ssm:describeInstanceInformation",
      "ssm:describeInstancePatches",
      "ssm:describeInstancePatchStates",
      "ssm:describeInstancePatchStatesForPatchGroup",
      "ssm:describeInventoryDeletions",
      "ssm:describeMaintenanceWindowExecutions",
      "ssm:describeMaintenanceWindowExecutionTaskInvocations",
      "ssm:describeMaintenanceWindowExecutionTasks",
      "ssm:describeMaintenanceWindows",
      "ssm:describeMaintenanceWindowSchedule",
      "ssm:describeMaintenanceWindowsForTarget",
      "ssm:describeMaintenanceWindowTargets",
      "ssm:describeMaintenanceWindowTasks",
      "ssm:describeOpsItems",
      "ssm:describeParameters",
      "ssm:describePatchBaselines",
      "ssm:describePatchGroups",
      "ssm:describePatchGroupState",
      "ssm:describePatchProperties",
      "ssm:describeSessions",
      "ssm:getAutomationExecution",
      "ssm:getCommandInvocation",
      "ssm:getConnectionStatus",
      "ssm:getDefaultPatchBaseline",
      "ssm:getDeployablePatchSnapshotForInstance",
      "ssm:getInventorySchema",
      "ssm:getMaintenanceWindow",
      "ssm:getMaintenanceWindowExecution",
      "ssm:getMaintenanceWindowExecutionTask",
      "ssm:getMaintenanceWindowExecutionTaskInvocation",
      "ssm:getMaintenanceWindowTask",
      "ssm:getOpsItem",
      "ssm:getPatchBaseline",
      "ssm:getPatchBaselineForPatchGroup",
      "ssm:getServiceSetting",
      "ssm:listAssociations",
      "ssm:listAssociationVersions",
      "ssm:listCommandInvocations",
      "ssm:listCommands",
      "ssm:listComplianceItems",
      "ssm:listComplianceSummaries",
      "ssm:listDocuments",
      "ssm:listDocumentVersions",
      "ssm:listOpsItemEvents",
      "ssm:listResourceComplianceSummaries",
      "ssm:listResourceDataSync",
      "ssm:listTagsForResource",
      "states:describeActivity",
      "states:describeExecution",
      "states:describeStateMachine",
      "states:describeStateMachineForExecution",
      "states:getExecutionHistory",
      "states:listActivities",
      "states:listExecutions",
      "states:listStateMachines",
      "storagegateway:describeBandwidthRateLimit",
      "storagegateway:describeCache",
      "storagegateway:describeCachediSCSIVolumes",
      "storagegateway:describeFileSystemAssociations",
      "storagegateway:describeGatewayInformation",
      "storagegateway:describeMaintenanceStartTime",
      "storagegateway:describeNFSFileShares",
      "storagegateway:describeSMBFileShares",
      "storagegateway:describeSMBSettings",
      "storagegateway:describeSnapshotSchedule",
      "storagegateway:describeStorediSCSIVolumes",
      "storagegateway:describeTapeArchives",
      "storagegateway:describeTapeRecoveryPoints",
      "storagegateway:describeTapes",
      "storagegateway:describeUploadBuffer",
      "storagegateway:describeVTLDevices",
      "storagegateway:describeWorkingStorage",
      "storagegateway:listAutomaticTapeCreationPolicies",
      "storagegateway:listFileShares",
      "storagegateway:listFileSystemAssociations",
      "storagegateway:listGateways",
      "storagegateway:listLocalDisks",
      "storagegateway:listTagsForResource",
      "storagegateway:listTapes",
      "storagegateway:listVolumeInitiators",
      "storagegateway:listVolumeRecoveryPoints",
      "storagegateway:listVolumes",
      "swf:countClosedWorkflowExecutions",
      "swf:countOpenWorkflowExecutions",
      "swf:countPendingActivityTasks",
      "swf:countPendingDecisionTasks",
      "swf:describeActivityType",
      "swf:describeDomain",
      "swf:describeWorkflowExecution",
      "swf:describeWorkflowType",
      "swf:getWorkflowExecutionHistory",
      "swf:listActivityTypes",
      "swf:listClosedWorkflowExecutions",
      "swf:listDomains",
      "swf:listOpenWorkflowExecutions",
      "swf:listWorkflowTypes",
      "synthetics:describeCanaries",
      "synthetics:describeCanariesLastRun",
      "synthetics:describeRuntimeVersions",
      "synthetics:getCanary",
      "synthetics:getCanaryRuns",
      "transfer:describeExecution",
      "transfer:describeServer",
      "transfer:describeUser",
      "transfer:describeWorkflow",
      "transfer:listExecutions",
      "transfer:listServers",
      "transfer:listTagsForResource",
      "transfer:listUsers",
      "transfer:listWorkflows",
      "transfer:sendWorkflowStepState",
      "waf-regional:getByteMatchSet",
      "waf-regional:getChangeTokenStatus",
      "waf-regional:getIPSet",
      "waf-regional:getRule",
      "waf-regional:getSqlInjectionMatchSet",
      "waf-regional:getWebACL",
      "waf-regional:getWebACLForResource",
      "waf-regional:listByteMatchSets",
      "waf-regional:listIPSets",
      "waf-regional:listResourcesForWebACL",
      "waf-regional:listRules",
      "waf-regional:listSqlInjectionMatchSets",
      "waf-regional:listWebACLs",
      "waf:getByteMatchSet",
      "waf:getChangeTokenStatus",
      "waf:getIPSet",
      "waf:getRule",
      "waf:getSampledRequests",
      "waf:getSizeConstraintSet",
      "waf:getSqlInjectionMatchSet",
      "waf:getWebACL",
      "waf:getXssMatchSet",
      "waf:listByteMatchSets",
      "waf:listIPSets",
      "waf:listRules",
      "waf:listSizeConstraintSets",
      "waf:listSqlInjectionMatchSets",
      "waf:listWebACLs",
      "waf:listXssMatchSets",
      "wafv2:checkCapacity",
      "wafv2:describeManagedRuleGroup",
      "wafv2:getIPSet",
      "wafv2:getLoggingConfiguration",
      "wafv2:getPermissionPolicy",
      "wafv2:getRateBasedStatementManagedKeys",
      "wafv2:getRegexPatternSet",
      "wafv2:getRuleGroup",
      "wafv2:getSampledRequests",
      "wafv2:getWebACL",
      "wafv2:getWebACLForResource",
      "wafv2:listAvailableManagedRuleGroups",
      "wafv2:listIPSets",
      "wafv2:listLoggingConfigurations",
      "wafv2:listRegexPatternSets",
      "wafv2:listResourcesForWebACL",
      "wafv2:listRuleGroups",
      "wafv2:listTagsForResource",
      "wafv2:listWebACLs",
      "workdocs:checkAlias",
      "workdocs:describeAvailableDirectories",
      "workdocs:describeInstances",
      "workmail:describeGroup",
      "workmail:describeOrganization",
      "workmail:describeResource",
      "workmail:describeUser",
      "workmail:listAliases",
      "workmail:listGroupMembers",
      "workmail:listGroups",
      "workmail:listMailboxPermissions",
      "workmail:listOrganizations",
      "workmail:listResourceDelegates",
      "workmail:listResources",
      "workmail:listUsers",
      "workspaces-web:getBrowserSettings",
      "workspaces-web:getIdentityProvider",
      "workspaces-web:getNetworkSettings",
      "workspaces-web:getPortal",
      "workspaces-web:getPortalServiceProviderMetadata",
      "workspaces-web:getTrustStoreCertificate",
      "workspaces-web:getUserSettings",
      "workspaces-web:listBrowserSettings",
      "workspaces-web:listIdentityProviders",
      "workspaces-web:listNetworkSettings",
      "workspaces-web:listPortals",
      "workspaces-web:listTagsForResource",
      "workspaces-web:listTrustStoreCertificates",
      "workspaces-web:listTrustStores",
      "workspaces-web:listUserSettings",
      "workspaces:describeAccount",
      "workspaces:describeAccountModifications",
      "workspaces:describeIpGroups",
      "workspaces:describeTags",
      "workspaces:describeWorkspaceBundles",
      "workspaces:describeWorkspaceDirectories",
      "workspaces:describeWorkspaceImages",
      "workspaces:describeWorkspaces",
      "workspaces:describeWorkspacesConnectionStatus"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-06-24T16:27:09+00:00"
 },
 "AWSSystemsManagerAccountDiscoveryServicePolicy":{
  "CreateDate":"2019-10-24T17:21:05+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "organizations:DescribeAccount",
      "organizations:DescribeOrganization",
      "organizations:ListAccounts",
      "organizations:ListAWSServiceAccessForOrganization",
      "organizations:ListChildren",
      "organizations:ListParents",
      "organizations:ListDelegatedServicesForAccount",
      "organizations:ListDelegatedAdministrators"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-05-27T18:04:51+00:00"
 },
 "AWSSystemsManagerChangeManagementServicePolicy":{
  "CreateDate":"2020-12-07T22:21:57+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ssm:CreateAssociation",
      "ssm:DeleteAssociation",
      "ssm:CreateOpsItem",
      "ssm:GetOpsItem",
      "ssm:UpdateOpsItem",
      "ssm:StartAutomationExecution",
      "ssm:StopAutomationExecution",
      "ssm:GetAutomationExecution",
      "ssm:GetCalendarState",
      "ssm:GetDocument"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "cloudwatch:DescribeAlarms"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "sso:ListDirectoryAssociations"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "sso-directory:DescribeUsers",
      "sso-directory:IsMemberInGroup"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":"iam:GetGroup",
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"iam:PassRole",
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":[
        "ssm.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-12-07T22:21:57+00:00"
 },
 "AWSSystemsManagerOpsDataSyncServiceRolePolicy":{
  "CreateDate":"2021-04-26T20:42:39+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ssm:GetOpsItem",
      "ssm:UpdateOpsItem"
     ],
     "Condition":{
      "StringEquals":{
       "aws:ResourceTag/ExplorerSecurityHubOpsItem":"true"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ssm:CreateOpsItem"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ssm:AddTagsToResource"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:ssm:*:*:opsitem/*"
    },
    {
     "Action":[
      "ssm:UpdateServiceSetting",
      "ssm:GetServiceSetting"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ssm:*:*:servicesetting/ssm/opsitem/*",
      "arn:aws:ssm:*:*:servicesetting/ssm/opsdata/*"
     ]
    },
    {
     "Action":[
      "securityhub:GetFindings",
      "securityhub:BatchUpdateFindings"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":"securityhub:BatchUpdateFindings",
     "Condition":{
      "Null":{
       "securityhub:ASFFSyntaxPath/Confidence":false,
       "securityhub:ASFFSyntaxPath/Criticality":false,
       "securityhub:ASFFSyntaxPath/Note":false,
       "securityhub:ASFFSyntaxPath/RelatedFindings":false,
       "securityhub:ASFFSyntaxPath/Types":false,
       "securityhub:ASFFSyntaxPath/UserDefinedFields":false,
       "securityhub:ASFFSyntaxPath/VerificationState":false
      },
      "StringEquals":{
       "securityhub:ASFFSyntaxPath/Workflow.Status":"SUPPRESSED"
      }
     },
     "Effect":"Deny",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-04-26T20:42:39+00:00"
 },
 "AWSThinkboxAWSPortalAdminPolicy":{
  "CreateDate":"2020-05-27T19:41:02+00:00",
  "DefaultVersionId":"v4",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:AttachInternetGateway",
      "ec2:AssociateAddress",
      "ec2:AssociateRouteTable",
      "ec2:AllocateAddress",
      "ec2:AuthorizeSecurityGroupIngress",
      "ec2:CreateFleet",
      "ec2:CreateLaunchTemplate",
      "ec2:CreateInternetGateway",
      "ec2:CreateNatGateway",
      "ec2:CreatePlacementGroup",
      "ec2:CreateRoute",
      "ec2:CreateRouteTable",
      "ec2:CreateSecurityGroup",
      "ec2:CreateSubnet",
      "ec2:CreateVpc",
      "ec2:CreateVpcEndpoint",
      "ec2:DescribeAvailabilityZones",
      "ec2:DescribeAddresses",
      "ec2:DescribeFleets",
      "ec2:DescribeFleetHistory",
      "ec2:DescribeFleetInstances",
      "ec2:DescribeImages",
      "ec2:DescribeInstances",
      "ec2:DescribeInternetGateways",
      "ec2:DescribeLaunchTemplates",
      "ec2:DescribeRouteTables",
      "ec2:DescribeNatGateways",
      "ec2:DescribeTags",
      "ec2:DescribeKeyPairs",
      "ec2:DescribePlacementGroups",
      "ec2:DescribeInstanceTypeOfferings",
      "ec2:DescribeRegions",
      "ec2:DescribeSpotFleetRequestHistory",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeSpotFleetInstances",
      "ec2:DescribeSpotFleetRequests",
      "ec2:DescribeSpotPriceHistory",
      "ec2:DescribeSubnets",
      "ec2:DescribeVpcs",
      "ec2:DescribeVpcEndpoints",
      "ec2:GetConsoleOutput",
      "ec2:ImportKeyPair",
      "ec2:ReleaseAddress",
      "ec2:RequestSpotFleet",
      "ec2:CancelSpotFleetRequests",
      "ec2:DisassociateAddress",
      "ec2:DeleteFleets",
      "ec2:DeleteLaunchTemplate",
      "ec2:DeleteVpc",
      "ec2:DeletePlacementGroup",
      "ec2:DeleteVpcEndpoints",
      "ec2:DeleteInternetGateway",
      "ec2:DeleteSecurityGroup",
      "ec2:RevokeSecurityGroupIngress",
      "ec2:DeleteRoute",
      "ec2:DeleteRouteTable",
      "ec2:DisassociateRouteTable",
      "ec2:DeleteSubnet",
      "ec2:DeleteNatGateway",
      "ec2:DetachInternetGateway",
      "ec2:ModifyInstanceAttribute",
      "ec2:ModifyFleet",
      "ec2:ModifySpotFleetRequest",
      "ec2:ModifyVpcAttribute"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"ec2:RunInstances",
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:subnet/*",
      "arn:aws:ec2:*:*:key-pair/*",
      "arn:aws:ec2:*::snapshot/*",
      "arn:aws:ec2:*:*:launch-template/*",
      "arn:aws:ec2:*:*:volume/*",
      "arn:aws:ec2:*:*:security-group/*",
      "arn:aws:ec2:*:*:placement-group/*",
      "arn:aws:ec2:*:*:network-interface/*",
      "arn:aws:ec2:*::image/*"
     ]
    },
    {
     "Action":"ec2:RunInstances",
     "Condition":{
      "StringLike":{
       "ec2:InstanceProfile":"arn:aws:iam::*:instance-profile/AWSPortal*"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:instance/*"
    },
    {
     "Action":"ec2:TerminateInstances",
     "Condition":{
      "StringEquals":{
       "ec2:ResourceTag/aws:cloudformation:logical-id":"ReverseForwarder"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"ec2:TerminateInstances",
     "Condition":{
      "StringLike":{
       "ec2:ResourceTag/aws:ec2spot:fleet-request-id":"*"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"ec2:TerminateInstances",
     "Condition":{
      "StringLike":{
       "ec2:PlacementGroup":"*DeadlinePlacementGroup*"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:CreateTags"
     ],
     "Condition":{
      "StringLike":{
       "ec2:PlacementGroup":"*DeadlinePlacementGroup*"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:instance/*"
    },
    {
     "Action":[
      "ec2:CreateTags"
     ],
     "Condition":{
      "StringLike":{
       "ec2:CreateAction":"RunInstances"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:CreateTags",
      "ec2:DeleteTags"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:subnet/*",
      "arn:aws:ec2:*:*:security-group/*",
      "arn:aws:ec2:*:*:internet-gateway/*",
      "arn:aws:ec2:*:*:route-table/*",
      "arn:aws:ec2:*:*:volume/*",
      "arn:aws:ec2:*:*:vpc/*",
      "arn:aws:ec2:*:*:natgateway/*"
     ]
    },
    {
     "Action":[
      "iam:GetUser"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "iam:GetInstanceProfile"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:instance-profile/AWSPortal*"
     ]
    },
    {
     "Action":[
      "iam:GetPolicy",
      "iam:ListEntitiesForPolicy",
      "iam:ListPolicyVersions"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:policy/AWSPortal*"
     ]
    },
    {
     "Action":[
      "iam:GetRole",
      "iam:GetRolePolicy"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/AWSPortal*",
      "arn:aws:iam::*:role/DeadlineSpot*"
     ]
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":[
        "ec2.amazonaws.com",
        "ec2fleet.amazonaws.com",
        "spot.amazonaws.com",
        "spotfleet.amazonaws.com",
        "cloudformation.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/AWSPortal*",
      "arn:aws:iam::*:role/DeadlineSpot*"
     ]
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":[
        "ec2fleet.amazonaws.com",
        "spot.amazonaws.com",
        "spotfleet.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/aws-service-role/*"
    },
    {
     "Action":[
      "s3:CreateBucket",
      "s3:GetBucketLocation",
      "s3:GetBucketLogging",
      "s3:GetBucketVersioning",
      "s3:PutBucketAcl",
      "s3:PutBucketCORS",
      "s3:PutBucketVersioning",
      "s3:GetBucketAcl",
      "s3:GetObject",
      "s3:PutBucketLogging",
      "s3:PutBucketTagging",
      "s3:PutObject",
      "s3:ListBucket",
      "s3:ListBucketVersions",
      "s3:PutEncryptionConfiguration",
      "s3:PutLifecycleConfiguration",
      "s3:DeleteBucket",
      "s3:DeleteObject",
      "s3:DeleteBucketPolicy",
      "s3:DeleteObjectVersion"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3::*:awsportal*",
      "arn:aws:s3::*:stack*",
      "arn:aws:s3::*:aws-portal-cache*",
      "arn:aws:s3::*:logs-for-aws-portal-cache*",
      "arn:aws:s3::*:logs-for-stack*"
     ]
    },
    {
     "Action":[
      "s3:ListAllMyBuckets"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "dynamodb:Scan"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:dynamodb:*:*:table/DeadlineFleetHealth*"
    },
    {
     "Action":[
      "cloudformation:CreateStack",
      "cloudformation:DescribeStackEvents",
      "cloudformation:DescribeStackResources",
      "cloudformation:DeleteStack",
      "cloudformation:DeleteChangeSet",
      "cloudformation:ListStackResources",
      "cloudformation:CreateChangeSet",
      "cloudformation:DescribeChangeSet",
      "cloudformation:ExecuteChangeSet",
      "cloudformation:UpdateTerminationProtection"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:cloudformation:*:*:stack/stack*/*",
      "arn:aws:cloudformation:*:*:stack/Deadline*/*"
     ]
    },
    {
     "Action":[
      "cloudformation:EstimateTemplateCost",
      "cloudformation:DescribeStacks"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "logs:DescribeLogStreams",
      "logs:GetLogEvents",
      "logs:PutRetentionPolicy",
      "logs:DeleteRetentionPolicy"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:logs:*:*:log-group:/thinkbox*"
    },
    {
     "Action":[
      "logs:DescribeLogGroups",
      "logs:CreateLogGroup"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "kms:Encrypt",
      "kms:GenerateDataKey"
     ],
     "Condition":{
      "StringLike":{
       "kms:ViaService":[
        "s3.*.amazonaws.com",
        "secretsmanager.*.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "secretsmanager:CreateSecret"
     ],
     "Condition":{
      "StringLike":{
       "secretsmanager:Name":[
        "rcs-tls-pw*"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "secretsmanager:DeleteSecret",
      "secretsmanager:UpdateSecret",
      "secretsmanager:DescribeSecret",
      "secretsmanager:TagResource"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:secretsmanager:*:*:secret:rcs-tls-pw*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-08-20T17:16:03+00:00"
 },
 "AWSThinkboxAWSPortalGatewayPolicy":{
  "CreateDate":"2020-05-27T19:05:00+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "logs:PutLogEvents",
      "logs:DescribeLogStreams",
      "logs:DescribeLogGroups",
      "logs:CreateLogStream"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:logs:*:*:log-group:/thinkbox*"
     ]
    },
    {
     "Action":[
      "logs:CreateLogGroup"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "s3:GetObject",
      "s3:PutObject",
      "s3:ListBucket"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::aws-portal-cache*"
     ]
    },
    {
     "Action":"dynamodb:Scan",
     "Effect":"Allow",
     "Resource":[
      "arn:aws:dynamodb:*:*:table/DeadlineFleetHealth*"
     ]
    },
    {
     "Action":[
      "s3:ListBucket",
      "s3:GetObject"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::stack*"
     ]
    },
    {
     "Action":[
      "s3:PutObject"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::stack*/gateway_certs/*"
     ]
    },
    {
     "Action":[
      "secretsmanager:GetSecretValue"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:secretsmanager:*:*:secret:rcs-tls-pw-stack*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-06-30T16:02:07+00:00"
 },
 "AWSThinkboxAWSPortalWorkerPolicy":{
  "CreateDate":"2020-05-27T19:15:05+00:00",
  "DefaultVersionId":"v4",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:DescribeTags"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "ec2:TerminateInstances"
     ],
     "Condition":{
      "StringEquals":{
       "ec2:ResourceTag/DeadlineRole":"DeadlineRenderNode"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:instance/*"
     ]
    },
    {
     "Action":[
      "s3:GetObject",
      "s3:PutObject",
      "s3:ListBucket"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::aws-portal-cache*"
     ]
    },
    {
     "Action":[
      "s3:GetObject"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::stack*/gateway_certs/*"
     ]
    },
    {
     "Action":[
      "logs:CreateLogStream",
      "logs:PutLogEvents",
      "logs:DescribeLogStreams",
      "logs:DescribeLogGroups"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:logs:*:*:log-group:/thinkbox*"
     ]
    },
    {
     "Action":[
      "logs:CreateLogGroup"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "sqs:SendMessage",
      "sqs:GetQueueUrl"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:sqs:*:*:DeadlineAWS*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-12-07T23:27:47+00:00"
 },
 "AWSThinkboxAssetServerPolicy":{
  "CreateDate":"2020-05-27T19:18:53+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "logs:DescribeLogGroups",
      "logs:DescribeLogStreams",
      "logs:GetLogEvents"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:logs:*:*:log-group:/thinkbox*"
     ]
    },
    {
     "Action":[
      "s3:GetObject",
      "s3:PutObject",
      "s3:ListBucket"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::aws-portal-cache*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-05-27T19:18:53+00:00"
 },
 "AWSThinkboxDeadlineResourceTrackerAccessPolicy":{
  "CreateDate":"2020-05-27T19:25:05+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "dynamodb:ListStreams"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "dynamodb:BatchWriteItem",
      "dynamodb:DeleteItem",
      "dynamodb:DescribeStream",
      "dynamodb:DescribeTable",
      "dynamodb:GetItem",
      "dynamodb:GetRecords",
      "dynamodb:GetShardIterator",
      "dynamodb:PutItem",
      "dynamodb:Scan",
      "dynamodb:UpdateItem",
      "dynamodb:UpdateTable"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:dynamodb:*:*:table/DeadlineEC2ComputeNodeHealth*",
      "arn:aws:dynamodb:*:*:table/DeadlineEC2ComputeNodeInfo*",
      "arn:aws:dynamodb:*:*:table/DeadlineFleetHealth*"
     ]
    },
    {
     "Action":[
      "ec2:CancelSpotFleetRequests",
      "ec2:DeleteFleets",
      "ec2:DescribeFleetInstances",
      "ec2:DescribeFleets",
      "ec2:DescribeInstances",
      "ec2:DescribeSpotFleetInstances",
      "ec2:DescribeSpotFleetRequests"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "ec2:RebootInstances",
      "ec2:TerminateInstances"
     ],
     "Condition":{
      "StringLike":{
       "ec2:ResourceTag/DeadlineTrackedAWSResource":"*"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:instance/*"
     ]
    },
    {
     "Action":[
      "events:PutEvents"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:events:*:*:event-bus/default"
     ]
    },
    {
     "Action":[
      "lambda:InvokeFunction"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:lambda:*:*:function:DeadlineResourceTracker*"
     ]
    },
    {
     "Action":[
      "logs:CreateLogGroup"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "logs:CreateLogStream",
      "logs:PutLogEvents"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:logs:*:*:log-group:/aws/lambda/DeadlineResourceTracker*"
     ]
    },
    {
     "Action":[
      "sqs:DeleteMessage",
      "sqs:GetQueueAttributes",
      "sqs:ReceiveMessage"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:sqs:*:*:DeadlineAWSComputeNodeStateMessageQueue*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-05-27T19:25:05+00:00"
 },
 "AWSThinkboxDeadlineResourceTrackerAdminPolicy":{
  "CreateDate":"2020-05-27T19:29:09+00:00",
  "DefaultVersionId":"v6",
  "Document":{
   "Statement":[
    {
     "Action":[
      "application-autoscaling:DeleteScalingPolicy",
      "application-autoscaling:DeregisterScalableTarget",
      "application-autoscaling:DescribeScalableTargets",
      "application-autoscaling:DescribeScalingPolicies",
      "application-autoscaling:PutScalingPolicy",
      "application-autoscaling:RegisterScalableTarget"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "cloudformation:ListStacks"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "cloudformation:CreateStack",
      "cloudformation:DeleteStack",
      "cloudformation:UpdateStack",
      "cloudformation:DescribeStacks",
      "cloudformation:UpdateTerminationProtection"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:cloudformation:*:*:stack/DeadlineResourceTracker*"
     ]
    },
    {
     "Action":[
      "dynamodb:CreateTable",
      "dynamodb:DeleteTable",
      "dynamodb:DescribeTable",
      "dynamodb:ListTagsOfResource",
      "dynamodb:TagResource",
      "dynamodb:UntagResource"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:dynamodb:*:*:table/DeadlineEC2ComputeNodeHealth*",
      "arn:aws:dynamodb:*:*:table/DeadlineEC2ComputeNodeInfo*",
      "arn:aws:dynamodb:*:*:table/DeadlineFleetHealth*"
     ]
    },
    {
     "Action":[
      "dynamodb:BatchWriteItem",
      "dynamodb:Scan"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:dynamodb:*:*:table/DeadlineFleetHealth*"
     ]
    },
    {
     "Action":[
      "events:DeleteRule",
      "events:DescribeRule",
      "events:PutRule",
      "events:PutTargets",
      "events:RemoveTargets"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:events:*:*:rule/DeadlineResourceTracker*"
     ]
    },
    {
     "Action":[
      "iam:GetRole",
      "iam:ListAttachedRolePolicies"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/DeadlineResourceTracker*"
     ]
    },
    {
     "Action":[
      "iam:GetUser"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "iam:CreateServiceLinkedRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":[
        "dynamodb.application-autoscaling.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/aws-service-role/*"
     ]
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":[
        "lambda.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/DeadlineResourceTrackerAccess*"
     ]
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":[
        "application-autoscaling.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/aws-service-role/dynamodb.application-autoscaling.amazonaws.com/AWSServiceRoleForApplicationAutoScaling_DynamoDBTable"
     ]
    },
    {
     "Action":[
      "lambda:GetEventSourceMapping"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "lambda:CreateEventSourceMapping",
      "lambda:DeleteEventSourceMapping"
     ],
     "Condition":{
      "StringLike":{
       "lambda:FunctionArn":[
        "arn:aws:lambda:*:*:function:DeadlineResourceTracker*"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "lambda:AddPermission",
      "lambda:RemovePermission"
     ],
     "Condition":{
      "StringLike":{
       "lambda:Principal":"events.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:lambda:*:*:function:DeadlineResourceTracker*"
     ]
    },
    {
     "Action":[
      "lambda:CreateFunction",
      "lambda:DeleteFunction",
      "lambda:DeleteFunctionConcurrency",
      "lambda:GetFunction",
      "lambda:GetFunctionConfiguration",
      "lambda:ListTags",
      "lambda:PutFunctionConcurrency",
      "lambda:TagResource",
      "lambda:UntagResource",
      "lambda:UpdateFunctionCode",
      "lambda:UpdateFunctionConfiguration"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:lambda:*:*:function:DeadlineResourceTracker*"
     ]
    },
    {
     "Action":[
      "s3:GetObject"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::*/deadline_aws_resource_tracker-*.zip",
      "arn:aws:s3:::*/DeadlineAWSResourceTrackerTemplate-*.yaml"
     ]
    },
    {
     "Action":[
      "sqs:CreateQueue",
      "sqs:DeleteQueue",
      "sqs:GetQueueAttributes",
      "sqs:ListQueueTags",
      "sqs:TagQueue",
      "sqs:UntagQueue"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:sqs:*:*:DeadlineAWSComputeNodeState*",
      "arn:aws:sqs:*:*:DeadlineResourceTracker*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-06-22T18:08:40+00:00"
 },
 "AWSThinkboxDeadlineSpotEventPluginAdminPolicy":{
  "CreateDate":"2020-05-27T19:38:34+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:CancelSpotFleetRequests",
      "ec2:DescribeSpotFleetInstances",
      "ec2:DescribeSpotFleetRequests",
      "ec2:ModifySpotFleetRequest",
      "ec2:RequestSpotFleet"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "ec2:CreateTags"
     ],
     "Condition":{
      "StringEquals":{
       "ec2:CreateAction":"RunInstances"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:instance/*"
     ]
    },
    {
     "Action":[
      "ec2:RunInstances"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "ec2:TerminateInstances"
     ],
     "Condition":{
      "StringLike":{
       "ec2:ResourceTag/aws:ec2spot:fleet-request-id":"*"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:instance/*"
     ]
    },
    {
     "Action":[
      "iam:CreateServiceLinkedRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":[
        "spot.amazonaws.com",
        "spotfleet.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/aws-service-role/*"
     ]
    },
    {
     "Action":[
      "iam:GetInstanceProfile"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:instance-profile/*"
     ]
    },
    {
     "Action":[
      "iam:GetRole"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/aws-ec2-spot-fleet-tagging-role",
      "arn:aws:iam::*:role/DeadlineSpot*"
     ]
    },
    {
     "Action":[
      "iam:GetUser"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringLike":{
       "iam:PassedToService":"ec2.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/aws-ec2-spot-fleet-tagging-role",
      "arn:aws:iam::*:role/DeadlineSpot*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-05-27T19:38:34+00:00"
 },
 "AWSThinkboxDeadlineSpotEventPluginWorkerPolicy":{
  "CreateDate":"2020-05-27T19:35:00+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:DescribeInstances",
      "ec2:DescribeTags"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "ec2:TerminateInstances"
     ],
     "Condition":{
      "StringEquals":{
       "ec2:ResourceTag/DeadlineTrackedAWSResource":"SpotEventPlugin"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:instance/*"
     ]
    },
    {
     "Action":[
      "ec2:TerminateInstances"
     ],
     "Condition":{
      "StringEquals":{
       "ec2:ResourceTag/DeadlineResourceTracker":"SpotEventPlugin"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:instance/*"
     ]
    },
    {
     "Action":[
      "sqs:GetQueueUrl",
      "sqs:SendMessage"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:sqs:*:*:DeadlineAWSComputeNodeState*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-12-07T23:31:31+00:00"
 },
 "AWSTransferConsoleFullAccess":{
  "CreateDate":"2020-12-14T19:33:25+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":"iam:PassRole",
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":"transfer.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "acm:ListCertificates",
      "ec2:DescribeAddresses",
      "ec2:DescribeAvailabilityZones",
      "ec2:DescribeNetworkInterfaces",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeSubnets",
      "ec2:DescribeVpcs",
      "ec2:DescribeVpcEndpoints",
      "health:DescribeEventAggregates",
      "iam:GetPolicyVersion",
      "iam:ListPolicies",
      "iam:ListRoles",
      "route53:ListHostedZones",
      "s3:ListAllMyBuckets",
      "transfer:*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-12-14T19:33:25+00:00"
 },
 "AWSTransferFullAccess":{
  "CreateDate":"2020-12-14T19:37:23+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":"transfer:*",
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"iam:PassRole",
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":"transfer.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:DescribeVpcEndpoints",
      "ec2:DescribeNetworkInterfaces",
      "ec2:DescribeAddresses"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-12-14T19:37:23+00:00"
 },
 "AWSTransferLoggingAccess":{
  "CreateDate":"2019-01-14T15:32:50+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "logs:CreateLogStream",
      "logs:DescribeLogStreams",
      "logs:CreateLogGroup",
      "logs:PutLogEvents"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-01-14T15:32:50+00:00"
 },
 "AWSTransferReadOnlyAccess":{
  "CreateDate":"2020-08-27T17:54:51+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "transfer:DescribeUser",
      "transfer:DescribeServer",
      "transfer:ListUsers",
      "transfer:ListServers",
      "transfer:TestIdentityProvider",
      "transfer:ListTagsForResource"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-08-27T17:54:51+00:00"
 },
 "AWSTrustedAdvisorReportingServiceRolePolicy":{
  "CreateDate":"2019-11-19T17:41:13+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "organizations:DescribeOrganization",
      "organizations:ListAWSServiceAccessForOrganization",
      "organizations:ListAccounts",
      "organizations:ListAccountsForParent",
      "organizations:ListOrganizationalUnitsForParent",
      "organizations:ListChildren",
      "organizations:ListParents",
      "organizations:DescribeOrganizationalUnit",
      "organizations:DescribeAccount"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-09-11T21:36:48+00:00"
 },
 "AWSTrustedAdvisorServiceRolePolicy":{
  "CreateDate":"2018-02-22T21:24:25+00:00",
  "DefaultVersionId":"v9",
  "Document":{
   "Statement":[
    {
     "Action":[
      "autoscaling:DescribeAccountLimits",
      "autoscaling:DescribeAutoScalingGroups",
      "autoscaling:DescribeLaunchConfigurations",
      "cloudformation:DescribeAccountLimits",
      "cloudformation:DescribeStacks",
      "cloudformation:ListStacks",
      "cloudfront:ListDistributions",
      "cloudtrail:DescribeTrails",
      "cloudtrail:GetTrailStatus",
      "dynamodb:DescribeLimits",
      "dynamodb:DescribeTable",
      "dynamodb:ListTables",
      "ec2:DescribeAddresses",
      "ec2:DescribeReservedInstances",
      "ec2:DescribeInstances",
      "ec2:DescribeVpcs",
      "ec2:DescribeInternetGateways",
      "ec2:DescribeImages",
      "ec2:DescribeVolumes",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeReservedInstancesOfferings",
      "ec2:DescribeSnapshots",
      "ec2:DescribeVpnConnections",
      "ec2:DescribeVpnGateways",
      "ec2:DescribeLaunchTemplateVersions",
      "elasticloadbalancing:DescribeAccountLimits",
      "elasticloadbalancing:DescribeInstanceHealth",
      "elasticloadbalancing:DescribeLoadBalancerAttributes",
      "elasticloadbalancing:DescribeLoadBalancerPolicies",
      "elasticloadbalancing:DescribeLoadBalancerPolicyTypes",
      "elasticloadbalancing:DescribeLoadBalancers",
      "elasticloadbalancing:DescribeTargetGroups",
      "iam:GenerateCredentialReport",
      "iam:GetAccountPasswordPolicy",
      "iam:GetAccountSummary",
      "iam:GetCredentialReport",
      "iam:GetServerCertificate",
      "iam:ListServerCertificates",
      "kinesis:DescribeLimits",
      "rds:DescribeAccountAttributes",
      "rds:DescribeDBClusters",
      "rds:DescribeDBEngineVersions",
      "rds:DescribeDBInstances",
      "rds:DescribeDBParameterGroups",
      "rds:DescribeDBParameters",
      "rds:DescribeDBSecurityGroups",
      "rds:DescribeDBSnapshots",
      "rds:DescribeDBSubnetGroups",
      "rds:DescribeEngineDefaultParameters",
      "rds:DescribeEvents",
      "rds:DescribeOptionGroupOptions",
      "rds:DescribeOptionGroups",
      "rds:DescribeOrderableDBInstanceOptions",
      "rds:DescribeReservedDBInstances",
      "rds:DescribeReservedDBInstancesOfferings",
      "rds:ListTagsForResource",
      "redshift:DescribeClusters",
      "redshift:DescribeReservedNodeOfferings",
      "redshift:DescribeReservedNodes",
      "route53:GetAccountLimit",
      "route53:GetHealthCheck",
      "route53:GetHostedZone",
      "route53:ListHealthChecks",
      "route53:ListHostedZones",
      "route53:ListHostedZonesByName",
      "route53:ListResourceRecordSets",
      "s3:GetAccountPublicAccessBlock",
      "s3:GetBucketAcl",
      "s3:GetBucketPolicy",
      "s3:GetBucketPolicyStatus",
      "s3:GetBucketLocation",
      "s3:GetBucketLogging",
      "s3:GetBucketVersioning",
      "s3:GetBucketPublicAccessBlock",
      "s3:ListBucket",
      "s3:ListAllMyBuckets",
      "ses:GetSendQuota",
      "sqs:ListQueues",
      "cloudwatch:GetMetricStatistics",
      "ce:GetReservationPurchaseRecommendation",
      "ce:GetSavingsPlansPurchaseRecommendation"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-08-10T22:41:30+00:00"
 },
 "AWSVPCS2SVpnServiceRolePolicy":{
  "CreateDate":"2019-08-06T14:13:58+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "acm:ExportCertificate",
      "acm:DescribeCertificate",
      "acm:ListCertificates",
      "acm-pca:DescribeCertificateAuthority"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"0"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-08-06T14:13:58+00:00"
 },
 "AWSVPCTransitGatewayServiceRolePolicy":{
  "CreateDate":"2018-11-26T16:21:17+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:CreateNetworkInterface",
      "ec2:DescribeNetworkInterfaces",
      "ec2:ModifyNetworkInterfaceAttribute",
      "ec2:DeleteNetworkInterface",
      "ec2:CreateNetworkInterfacePermission",
      "ec2:AssignIpv6Addresses",
      "ec2:UnAssignIpv6Addresses"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"0"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-04-15T16:31:44+00:00"
 },
 "AWSWAFConsoleFullAccess":{
  "CreateDate":"2020-04-06T18:38:38+00:00",
  "DefaultVersionId":"v4",
  "Document":{
   "Statement":[
    {
     "Action":[
      "apigateway:GET",
      "apigateway:SetWebACL",
      "cloudfront:ListDistributions",
      "cloudfront:ListDistributionsByWebACLId",
      "cloudfront:UpdateDistribution",
      "cloudwatch:GetMetricData",
      "cloudwatch:GetMetricStatistics",
      "cloudwatch:ListMetrics",
      "ec2:DescribeRegions",
      "elasticloadbalancing:DescribeLoadBalancers",
      "elasticloadbalancing:SetWebACL",
      "appsync:ListGraphqlApis",
      "appsync:SetWebACL",
      "waf-regional:*",
      "waf:*",
      "wafv2:*",
      "s3:ListAllMyBuckets",
      "logs:DescribeResourcePolicies",
      "logs:DescribeLogGroups"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AllowUseOfAWSWAF"
    },
    {
     "Action":[
      "logs:CreateLogDelivery",
      "logs:DeleteLogDelivery"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AllowLogDeliverySubscription"
    },
    {
     "Action":[
      "s3:PutBucketPolicy",
      "s3:GetBucketPolicy"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::aws-waf-logs-*"
     ],
     "Sid":"GrantLogDeliveryPermissionForS3Bucket"
    },
    {
     "Action":[
      "logs:PutResourcePolicy"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:CalledVia":[
        "wafv2.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"GrantLogDeliveryPermissionForCloudWatchLogGroup"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-01-11T19:34:04+00:00"
 },
 "AWSWAFConsoleReadOnlyAccess":{
  "CreateDate":"2020-04-06T18:43:24+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "apigateway:GET",
      "cloudfront:ListDistributions",
      "cloudfront:ListDistributionsByWebACLId",
      "cloudwatch:GetMetricData",
      "cloudwatch:GetMetricStatistics",
      "cloudwatch:ListMetrics",
      "ec2:DescribeRegions",
      "elasticloadbalancing:DescribeLoadBalancers",
      "appsync:ListGraphqlApis",
      "waf-regional:Get*",
      "waf-regional:List*",
      "waf:Get*",
      "waf:List*",
      "wafv2:Describe*",
      "wafv2:Get*",
      "wafv2:List*",
      "wafv2:CheckCapacity"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-10-01T20:13:54+00:00"
 },
 "AWSWAFFullAccess":{
  "CreateDate":"2015-10-06T20:44:00+00:00",
  "DefaultVersionId":"v7",
  "Document":{
   "Statement":[
    {
     "Action":[
      "waf:*",
      "waf-regional:*",
      "wafv2:*",
      "elasticloadbalancing:SetWebACL",
      "apigateway:SetWebACL",
      "appsync:SetWebACL",
      "logs:DescribeResourcePolicies",
      "logs:DescribeLogGroups"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AllowUseOfAWSWAF"
    },
    {
     "Action":[
      "logs:CreateLogDelivery",
      "logs:DeleteLogDelivery"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AllowLogDeliverySubscription"
    },
    {
     "Action":[
      "s3:PutBucketPolicy",
      "s3:GetBucketPolicy"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::aws-waf-logs-*"
     ],
     "Sid":"GrantLogDeliveryPermissionForS3Bucket"
    },
    {
     "Action":[
      "logs:PutResourcePolicy"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:CalledVia":[
        "wafv2.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"GrantLogDeliveryPermissionForCloudWatchLogGroup"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-01-11T19:33:38+00:00"
 },
 "AWSWAFReadOnlyAccess":{
  "CreateDate":"2015-10-06T20:43:45+00:00",
  "DefaultVersionId":"v4",
  "Document":{
   "Statement":[
    {
     "Action":[
      "waf:Get*",
      "waf:List*",
      "waf-regional:Get*",
      "waf-regional:List*",
      "wafv2:Get*",
      "wafv2:List*",
      "wafv2:Describe*",
      "wafv2:CheckCapacity"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-06-22T22:38:54+00:00"
 },
 "AWSWellArchitectedOrganizationsServiceRolePolicy":{
  "CreateDate":"2022-06-23T17:15:26+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "organizations:DescribeAccount",
      "organizations:DescribeOrganization",
      "organizations:ListAccounts",
      "organizations:ListAccountsForParent",
      "organizations:ListChildren",
      "organizations:ListParents",
      "organizations:ListRoots"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-06-23T17:15:26+00:00"
 },
 "AWSXRayDaemonWriteAccess":{
  "CreateDate":"2018-08-28T23:00:33+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "xray:PutTraceSegments",
      "xray:PutTelemetryRecords",
      "xray:GetSamplingRules",
      "xray:GetSamplingTargets",
      "xray:GetSamplingStatisticSummaries"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2018-08-28T23:00:33+00:00"
 },
 "AWSXrayFullAccess":{
  "CreateDate":"2016-12-01T18:30:55+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "xray:*"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2016-12-01T18:30:55+00:00"
 },
 "AWSXrayReadOnlyAccess":{
  "CreateDate":"2016-12-01T18:27:02+00:00",
  "DefaultVersionId":"v5",
  "Document":{
   "Statement":[
    {
     "Action":[
      "xray:GetSamplingRules",
      "xray:GetSamplingTargets",
      "xray:GetSamplingStatisticSummaries",
      "xray:BatchGetTraces",
      "xray:GetServiceGraph",
      "xray:GetTraceGraph",
      "xray:GetTraceSummaries",
      "xray:GetGroups",
      "xray:GetGroup",
      "xray:ListTagsForResource",
      "xray:GetTimeSeriesServiceStatistics",
      "xray:GetInsightSummaries",
      "xray:GetInsight",
      "xray:GetInsightEvents",
      "xray:GetInsightImpactGraph"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-09-03T22:19:40+00:00"
 },
 "AWSXrayWriteOnlyAccess":{
  "CreateDate":"2016-12-01T18:19:53+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "xray:PutTraceSegments",
      "xray:PutTelemetryRecords",
      "xray:GetSamplingRules",
      "xray:GetSamplingTargets",
      "xray:GetSamplingStatisticSummaries"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2018-08-28T23:03:04+00:00"
 },
 "AWS_ConfigRole":{
  "CreateDate":"2020-09-15T20:30:30+00:00",
  "DefaultVersionId":"v13",
  "Document":{
   "Statement":[
    {
     "Action":[
      "access-analyzer:GetAnalyzer",
      "access-analyzer:GetArchiveRule",
      "access-analyzer:ListAnalyzers",
      "access-analyzer:ListArchiveRules",
      "access-analyzer:ListTagsForResource",
      "account:GetAlternateContact",
      "acm:DescribeCertificate",
      "acm:ListCertificates",
      "acm:ListTagsForCertificate",
      "apigateway:GET",
      "application-autoscaling:DescribeScalableTargets",
      "application-autoscaling:DescribeScalingPolicies",
      "athena:GetDataCatalog",
      "athena:GetWorkGroup",
      "athena:ListDataCatalogs",
      "athena:ListTagsForResource",
      "athena:ListWorkGroups",
      "autoscaling:DescribeAutoScalingGroups",
      "autoscaling:DescribeLaunchConfigurations",
      "autoscaling:DescribeLifecycleHooks",
      "autoscaling:DescribePolicies",
      "autoscaling:DescribeScheduledActions",
      "autoscaling:DescribeTags",
      "backup-gateway:ListTagsForResource",
      "backup-gateway:ListVirtualMachines",
      "backup:DescribeBackupVault",
      "backup:DescribeRecoveryPoint",
      "backup:GetBackupPlan",
      "backup:GetBackupSelection",
      "backup:GetBackupVaultAccessPolicy",
      "backup:GetBackupVaultNotifications",
      "backup:ListBackupPlans",
      "backup:ListBackupSelections",
      "backup:ListBackupVaults",
      "backup:ListRecoveryPointsByBackupVault",
      "backup:ListTags",
      "batch:DescribeComputeEnvironments",
      "batch:DescribeJobQueues",
      "batch:ListTagsForResource",
      "cloudformation:DescribeType",
      "cloudformation:GetResource",
      "cloudformation:ListResources",
      "cloudformation:ListTypes",
      "cloudfront:ListDistributions",
      "cloudfront:ListTagsForResource",
      "cloudtrail:DescribeTrails",
      "cloudtrail:GetEventDataStore",
      "cloudtrail:GetEventSelectors",
      "cloudtrail:GetTrailStatus",
      "cloudtrail:ListEventDataStores",
      "cloudtrail:ListTags",
      "cloudwatch:DescribeAlarms",
      "codedeploy:GetDeploymentConfig",
      "codepipeline:GetPipeline",
      "codepipeline:GetPipelineState",
      "codepipeline:ListPipelines",
      "config:BatchGet*",
      "config:Describe*",
      "config:Get*",
      "config:List*",
      "config:Put*",
      "config:Select*",
      "dax:DescribeClusters",
      "dax:DescribeParameterGroups",
      "dax:DescribeParameters",
      "dax:DescribeSubnetGroups",
      "dax:ListTags",
      "detective:ListTagsForResource",
      "detective:ListGraphs",
      "dms:DescribeCertificates",
      "dms:DescribeEventSubscriptions",
      "dms:DescribeReplicationInstances",
      "dms:DescribeReplicationTasks",
      "dms:DescribeReplicationSubnetGroups",
      "dms:ListTagsForResource",
      "dynamodb:DescribeContinuousBackups",
      "dynamodb:DescribeGlobalTable",
      "dynamodb:DescribeGlobalTableSettings",
      "dynamodb:DescribeLimits",
      "dynamodb:DescribeTable",
      "dynamodb:ListTables",
      "dynamodb:ListTagsOfResource",
      "ec2:Describe*",
      "ec2:DescribeClientVpnAuthorizationRules",
      "ec2:DescribeClientVpnEndpoints",
      "ec2:DescribeDhcpOptions",
      "ec2:DescribeFleets",
      "ec2:DescribeNetworkAcls",
      "ec2:DescribePlacementGroups",
      "ec2:DescribeSpotFleetRequests",
      "ec2:DescribeVolumeAttribute",
      "ec2:DescribeVolumes",
      "ec2:GetEbsEncryptionByDefault",
      "ecr-public:DescribeRepositories",
      "ecr-public:GetRepositoryCatalogData",
      "ecr-public:GetRepositoryPolicy",
      "ecr-public:ListTagsForResource",
      "ecr:DescribeRepositories",
      "ecr:GetLifecyclePolicy",
      "ecr:GetRepositoryPolicy",
      "ecr:ListTagsForResource",
      "ecs:DescribeClusters",
      "ecs:DescribeServices",
      "ecs:DescribeTaskDefinition",
      "ecs:DescribeTaskSets",
      "ecs:ListClusters",
      "ecs:ListServices",
      "ecs:ListTagsForResource",
      "ecs:ListTaskDefinitionFamilies",
      "ecs:ListTaskDefinitions",
      "eks:DescribeCluster",
      "eks:DescribeFargateProfile",
      "eks:DescribeNodegroup",
      "eks:ListClusters",
      "eks:ListFargateProfiles",
      "eks:ListNodegroups",
      "eks:ListTagsForResource",
      "elasticache:DescribeCacheClusters",
      "elasticache:DescribeCacheParameterGroups",
      "elasticache:DescribeCacheSubnetGroups",
      "elasticache:DescribeReplicationGroups",
      "elasticache:DescribeSnapshots",
      "elasticache:ListTagsForResource",
      "elasticbeanstalk:DescribeConfigurationSettings",
      "elasticbeanstalk:DescribeEnvironments",
      "elasticfilesystem:DescribeAccessPoints",
      "elasticfilesystem:DescribeBackupPolicy",
      "elasticfilesystem:DescribeFileSystemPolicy",
      "elasticfilesystem:DescribeFileSystems",
      "elasticfilesystem:DescribeLifecycleConfiguration",
      "elasticfilesystem:DescribeMountTargets",
      "elasticfilesystem:DescribeMountTargetSecurityGroups",
      "elasticloadbalancing:DescribeListeners",
      "elasticloadbalancing:DescribeLoadBalancerAttributes",
      "elasticloadbalancing:DescribeLoadBalancerPolicies",
      "elasticloadbalancing:DescribeLoadBalancers",
      "elasticloadbalancing:DescribeRules",
      "elasticloadbalancing:DescribeTags",
      "elasticmapreduce:DescribeCluster",
      "elasticmapreduce:DescribeSecurityConfiguration",
      "elasticmapreduce:DescribeStep",
      "elasticmapreduce:GetBlockPublicAccessConfiguration",
      "elasticmapreduce:GetManagedScalingPolicy",
      "elasticmapreduce:ListClusters",
      "elasticmapreduce:ListInstanceFleets",
      "elasticmapreduce:ListInstanceGroups",
      "elasticmapreduce:ListInstances",
      "elasticmapreduce:ListSecurityConfigurations",
      "elasticmapreduce:ListSteps",
      "es:DescribeDomain",
      "es:DescribeDomains",
      "es:DescribeElasticsearchDomain",
      "es:DescribeElasticsearchDomains",
      "es:GetCompatibleElasticsearchVersions",
      "es:GetCompatibleVersions",
      "es:ListDomainNames",
      "es:ListTags",
      "firehose:DescribeDeliveryStream",
      "firehose:ListDeliveryStreams",
      "firehose:ListTagsForDeliveryStream",
      "fsx:DescribeFileSystems",
      "fsx:ListTagsForResource",
      "globalaccelerator:DescribeAccelerator",
      "globalaccelerator:DescribeEndpointGroup",
      "globalaccelerator:DescribeListener",
      "globalaccelerator:ListAccelerators",
      "globalaccelerator:ListEndpointGroups",
      "globalaccelerator:ListListeners",
      "globalaccelerator:ListTagsForResource",
      "glue:BatchGetDevEndpoints",
      "glue:GetDevEndpoint",
      "glue:GetDevEndpoints",
      "glue:GetSecurityConfiguration",
      "glue:GetSecurityConfigurations",
      "glue:GetTags",
      "glue:ListCrawlers",
      "glue:ListDevEndpoints",
      "glue:ListJobs",
      "glue:ListWorkflows",
      "guardduty:GetDetector",
      "guardduty:GetFilter",
      "guardduty:GetFindings",
      "guardduty:GetIPSet",
      "guardduty:GetMasterAccount",
      "guardduty:GetMembers",
      "guardduty:GetThreatIntelSet",
      "guardduty:ListDetectors",
      "guardduty:ListFilters",
      "guardduty:ListFindings",
      "guardduty:ListIPSets",
      "guardduty:ListMembers",
      "guardduty:ListOrganizationAdminAccounts",
      "guardduty:ListTagsForResource",
      "guardduty:ListThreatIntelSets",
      "iam:GenerateCredentialReport",
      "iam:GetAccountAuthorizationDetails",
      "iam:GetAccountPasswordPolicy",
      "iam:GetAccountSummary",
      "iam:GetCredentialReport",
      "iam:GetGroup",
      "iam:GetGroupPolicy",
      "iam:GetPolicy",
      "iam:GetPolicyVersion",
      "iam:GetRole",
      "iam:GetRolePolicy",
      "iam:GetUser",
      "iam:GetUserPolicy",
      "iam:ListAttachedGroupPolicies",
      "iam:ListAttachedRolePolicies",
      "iam:ListAttachedUserPolicies",
      "iam:ListEntitiesForPolicy",
      "iam:ListGroupPolicies",
      "iam:ListGroupsForUser",
      "iam:ListInstanceProfilesForRole",
      "iam:ListPolicyVersions",
      "iam:ListRolePolicies",
      "iam:ListUserPolicies",
      "iam:ListVirtualMFADevices",
      "kafka:DescribeCluster",
      "kafka:ListClusters",
      "kinesis:DescribeStreamConsumer",
      "kinesis:DescribeStreamSummary",
      "kinesis:ListStreamConsumers",
      "kinesis:ListStreams",
      "kinesis:ListTagsForStream",
      "kms:DescribeKey",
      "kms:GetKeyPolicy",
      "kms:GetKeyRotationStatus",
      "kms:ListAliases",
      "kms:ListKeys",
      "kms:ListResourceTags",
      "lambda:GetAlias",
      "lambda:GetFunction",
      "lambda:GetFunctionCodeSigningConfig",
      "lambda:GetPolicy",
      "lambda:ListAliases",
      "lambda:ListFunctions",
      "lambda:ListVersionsByFunction",
      "logs:DescribeLogGroups",
      "logs:ListTagsLogGroup",
      "macie2:GetMacieSession",
      "network-firewall:DescribeLoggingConfiguration",
      "network-firewall:ListFirewalls",
      "opsworks:DescribeLayers",
      "opsworks:ListTags",
      "organizations:DescribeOrganization",
      "organizations:DescribePolicy",
      "organizations:ListParents",
      "organizations:ListPolicies",
      "organizations:ListPoliciesForTarget",
      "ram:GetResourceShareAssociations",
      "ram:GetResourceShares",
      "rds:DescribeDBClusterParameterGroups",
      "rds:DescribeDBClusterParameters",
      "rds:DescribeDBClusters",
      "rds:DescribeDBClusterSnapshotAttributes",
      "rds:DescribeDBClusterSnapshots",
      "rds:DescribeDBEngineVersions",
      "rds:DescribeDBInstances",
      "rds:DescribeDBParameterGroups",
      "rds:DescribeDBParameterGroups",
      "rds:DescribeDBParameters",
      "rds:DescribeDBSecurityGroups",
      "rds:DescribeDBSnapshotAttributes",
      "rds:DescribeDBSnapshots",
      "rds:DescribeDBSubnetGroups",
      "rds:DescribeEventSubscriptions",
      "rds:DescribeOptionGroups",
      "rds:ListTagsForResource",
      "redshift:DescribeClusterParameterGroups",
      "redshift:DescribeClusterParameters",
      "redshift:DescribeClusters",
      "redshift:DescribeClusterSecurityGroups",
      "redshift:DescribeClusterSnapshots",
      "redshift:DescribeClusterSubnetGroups",
      "redshift:DescribeEventSubscriptions",
      "redshift:DescribeLoggingStatus",
      "route53:GetHealthCheck",
      "route53:GetHostedZone",
      "route53:ListHealthChecks",
      "route53:ListHostedZones",
      "route53:ListHostedZonesByName",
      "route53:ListQueryLoggingConfigs",
      "route53:ListResourceRecordSets",
      "route53:ListTagsForResource",
      "route53resolver:GetResolverEndpoint",
      "route53resolver:GetResolverRule",
      "route53resolver:GetResolverRuleAssociation",
      "route53resolver:ListResolverEndpointIpAddresses",
      "route53resolver:ListResolverEndpoints",
      "route53resolver:ListResolverRuleAssociations",
      "route53resolver:ListResolverRules",
      "route53resolver:ListTagsForResource",
      "s3:GetAccelerateConfiguration",
      "s3:GetAccessPoint",
      "s3:GetAccessPointPolicy",
      "s3:GetAccessPointPolicyStatus",
      "s3:GetAccountPublicAccessBlock",
      "s3:GetBucketAcl",
      "s3:GetBucketCORS",
      "s3:GetBucketLocation",
      "s3:GetBucketLogging",
      "s3:GetBucketNotification",
      "s3:GetBucketObjectLockConfiguration",
      "s3:GetBucketPolicy",
      "s3:GetBucketPublicAccessBlock",
      "s3:GetBucketRequestPayment",
      "s3:GetBucketTagging",
      "s3:GetBucketVersioning",
      "s3:GetBucketWebsite",
      "s3:GetEncryptionConfiguration",
      "s3:GetLifecycleConfiguration",
      "s3:GetReplicationConfiguration",
      "s3:ListAccessPoints",
      "s3:ListAllMyBuckets",
      "s3:ListBucket",
      "sagemaker:DescribeCodeRepository",
      "sagemaker:DescribeEndpoint",
      "sagemaker:DescribeEndpointConfig",
      "sagemaker:DescribeModel",
      "sagemaker:DescribeMonitoringSchedule",
      "sagemaker:DescribeNotebookInstance",
      "sagemaker:DescribeNotebookInstanceLifecycleConfig",
      "sagemaker:DescribeWorkteam",
      "sagemaker:ListCodeRepositories",
      "sagemaker:ListEndpointConfigs",
      "sagemaker:ListEndpoints",
      "sagemaker:ListModels",
      "sagemaker:ListMonitoringSchedules",
      "sagemaker:ListNotebookInstanceLifecycleConfigs",
      "sagemaker:ListNotebookInstances",
      "sagemaker:ListTags",
      "sagemaker:ListWorkteams",
      "secretsmanager:ListSecrets",
      "secretsmanager:ListSecretVersionIds",
      "securityhub:DescribeHub",
      "ses:GetConfigurationSet",
      "ses:GetConfigurationSetEventDestinations",
      "ses:ListConfigurationSets",
      "shield:DescribeDRTAccess",
      "shield:DescribeProtection",
      "shield:DescribeSubscription",
      "sns:GetSubscriptionAttributes",
      "sns:GetTopicAttributes",
      "sns:ListSubscriptions",
      "sns:ListSubscriptionsByTopic",
      "sns:ListTagsForResource",
      "sns:ListTopics",
      "sqs:GetQueueAttributes",
      "sqs:ListQueues",
      "sqs:ListQueueTags",
      "ssm:DescribeAutomationExecutions",
      "ssm:DescribeDocument",
      "ssm:DescribeDocumentPermission",
      "ssm:GetAutomationExecution",
      "ssm:GetDocument",
      "ssm:ListDocuments",
      "sso:DescribeInstanceAccessControlAttributeConfiguration",
      "sso:DescribePermissionSet",
      "sso:ListManagedPoliciesInPermissionSet",
      "sso:ListPermissionSets",
      "sso:ListTagsForResource",
      "states:DescribeActivity",
      "states:DescribeStateMachine",
      "states:ListActivities",
      "states:ListStateMachines",
      "states:ListTagsForResource",
      "storagegateway:ListGateways",
      "storagegateway:ListTagsForResource",
      "storagegateway:ListVolumes",
      "support:DescribeCases",
      "tag:GetResources",
      "waf-regional:GetLoggingConfiguration",
      "waf-regional:GetWebACL",
      "waf-regional:GetWebACLForResource",
      "waf:GetLoggingConfiguration",
      "waf:GetWebACL",
      "wafv2:GetLoggingConfiguration",
      "wafv2:GetRuleGroup",
      "wafv2:ListRuleGroups",
      "wafv2:ListTagsForResource",
      "workspaces:DescribeConnectionAliases",
      "workspaces:DescribeTags",
      "workspaces:DescribeWorkspaces"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "logs:CreateLogStream",
      "logs:CreateLogGroup"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:logs:*:*:log-group:/aws/config/*"
    },
    {
     "Action":"logs:PutLogEvents",
     "Effect":"Allow",
     "Resource":"arn:aws:logs:*:*:log-group:/aws/config/*:log-stream:config-rule-evaluation/*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-05-27T03:11:37+00:00"
 },
 "AccessAnalyzerServiceRolePolicy":{
  "CreateDate":"2019-12-02T17:13:10+00:00",
  "DefaultVersionId":"v7",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:DescribeAddresses",
      "ec2:DescribeByoipCidrs",
      "ec2:DescribeVpcEndpoints",
      "ec2:DescribeVpcs",
      "iam:GetRole",
      "iam:ListRoles",
      "kms:DescribeKey",
      "kms:GetKeyPolicy",
      "kms:ListGrants",
      "kms:ListKeyPolicies",
      "kms:ListKeys",
      "lambda:GetFunctionUrlConfig",
      "lambda:GetLayerVersionPolicy",
      "lambda:GetPolicy",
      "lambda:ListAliases",
      "lambda:ListFunctions",
      "lambda:ListLayers",
      "lambda:ListLayerVersions",
      "lambda:ListVersionsByFunction",
      "organizations:DescribeAccount",
      "organizations:DescribeOrganization",
      "organizations:DescribeOrganizationalUnit",
      "organizations:ListAccounts",
      "organizations:ListAccountsForParent",
      "organizations:ListAWSServiceAccessForOrganization",
      "organizations:ListChildren",
      "organizations:ListDelegatedAdministrators",
      "organizations:ListOrganizationalUnitsForParent",
      "organizations:ListParents",
      "organizations:ListRoots",
      "s3:DescribeMultiRegionAccessPointOperation",
      "s3:GetAccessPoint",
      "s3:GetAccessPointPolicy",
      "s3:GetAccessPointPolicyStatus",
      "s3:GetAccountPublicAccessBlock",
      "s3:GetBucketAcl",
      "s3:GetBucketLocation",
      "s3:GetBucketPolicyStatus",
      "s3:GetBucketPolicy",
      "s3:GetBucketPublicAccessBlock",
      "s3:GetMultiRegionAccessPoint",
      "s3:GetMultiRegionAccessPointPolicy",
      "s3:GetMultiRegionAccessPointPolicyStatus",
      "s3:ListAccessPoints",
      "s3:ListAllMyBuckets",
      "s3:ListMultiRegionAccessPoints",
      "sns:GetTopicAttributes",
      "sns:ListTopics",
      "secretsmanager:DescribeSecret",
      "secretsmanager:GetResourcePolicy",
      "secretsmanager:ListSecrets",
      "sqs:GetQueueAttributes",
      "sqs:ListQueues"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-04-06T20:18:51+00:00"
 },
 "AdministratorAccess":{
  "CreateDate":"2015-02-06T18:39:46+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":"*",
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2015-02-06T18:39:46+00:00"
 },
 "AdministratorAccess-AWSElasticBeanstalk":{
  "CreateDate":"2021-01-22T19:36:54+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "acm:Describe*",
      "acm:List*",
      "autoscaling:Describe*",
      "cloudformation:Describe*",
      "cloudformation:Estimate*",
      "cloudformation:Get*",
      "cloudformation:List*",
      "cloudformation:Validate*",
      "cloudtrail:LookupEvents",
      "cloudwatch:DescribeAlarms",
      "cloudwatch:GetMetricStatistics",
      "cloudwatch:ListMetrics",
      "codecommit:Get*",
      "codecommit:UploadArchive",
      "ec2:AllocateAddress",
      "ec2:AssociateAddress",
      "ec2:AuthorizeSecurityGroup*",
      "ec2:CreateLaunchTemplate*",
      "ec2:CreateSecurityGroup",
      "ec2:CreateTags",
      "ec2:DeleteLaunchTemplate*",
      "ec2:DeleteSecurityGroup",
      "ec2:DeleteTags",
      "ec2:Describe*",
      "ec2:DisassociateAddress",
      "ec2:ReleaseAddress",
      "ec2:RevokeSecurityGroup*",
      "ecs:CreateCluster",
      "ecs:DeRegisterTaskDefinition",
      "ecs:Describe*",
      "ecs:List*",
      "ecs:RegisterTaskDefinition",
      "elasticbeanstalk:*",
      "elasticloadbalancing:Describe*",
      "iam:GetRole",
      "iam:ListAttachedRolePolicies",
      "iam:ListInstanceProfiles",
      "iam:ListRolePolicies",
      "iam:ListRoles",
      "iam:ListServerCertificates",
      "logs:Describe*",
      "rds:Describe*",
      "s3:ListAllMyBuckets",
      "sns:ListSubscriptionsByTopic",
      "sns:ListTopics",
      "sqs:ListQueues"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "autoscaling:*"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:autoscaling:*:*:launchConfiguration:*:launchConfigurationName/awseb-e-*",
      "arn:aws:autoscaling:*:*:launchConfiguration:*:launchConfigurationName/eb-*",
      "arn:aws:autoscaling:*:*:autoScalingGroup:*:autoScalingGroupName/awseb-e-*",
      "arn:aws:autoscaling:*:*:autoScalingGroup:*:autoScalingGroupName/eb-*"
     ]
    },
    {
     "Action":[
      "cloudformation:CancelUpdateStack",
      "cloudformation:ContinueUpdateRollback",
      "cloudformation:CreateStack",
      "cloudformation:DeleteStack",
      "cloudformation:GetTemplate",
      "cloudformation:ListStackResources",
      "cloudformation:SignalResource",
      "cloudformation:TagResource",
      "cloudformation:UntagResource",
      "cloudformation:UpdateStack"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:cloudformation:*:*:stack/awseb-*",
      "arn:aws:cloudformation:*:*:stack/eb-*"
     ]
    },
    {
     "Action":[
      "cloudwatch:DeleteAlarms",
      "cloudwatch:PutMetricAlarm"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:cloudwatch:*:*:alarm:awseb-*",
      "arn:aws:cloudwatch:*:*:alarm:eb-*"
     ]
    },
    {
     "Action":[
      "codebuild:BatchGetBuilds",
      "codebuild:CreateProject",
      "codebuild:DeleteProject",
      "codebuild:StartBuild"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:codebuild:*:*:project/Elastic-Beanstalk-*"
    },
    {
     "Action":[
      "dynamodb:CreateTable",
      "dynamodb:DeleteTable",
      "dynamodb:DescribeTable",
      "dynamodb:TagResource"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:dynamodb:*:*:table/awseb-e-*",
      "arn:aws:dynamodb:*:*:table/eb-*"
     ]
    },
    {
     "Action":[
      "ec2:RebootInstances",
      "ec2:TerminateInstances"
     ],
     "Condition":{
      "StringLike":{
       "ec2:ResourceTag/aws:cloudformation:stack-id":[
        "arn:aws:cloudformation:*:*:stack/awseb-e-*",
        "arn:aws:cloudformation:*:*:stack/eb-*"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:instance/*"
    },
    {
     "Action":"ec2:RunInstances",
     "Condition":{
      "ArnLike":{
       "ec2:LaunchTemplate":"arn:aws:ec2:*:*:launch-template/*"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ecs:DeleteCluster"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:ecs:*:*:cluster/awseb-*"
    },
    {
     "Action":[
      "elasticloadbalancing:*Rule",
      "elasticloadbalancing:*Tags",
      "elasticloadbalancing:SetRulePriorities",
      "elasticloadbalancing:SetSecurityGroups"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:elasticloadbalancing:*:*:loadbalancer/app/*/*",
      "arn:aws:elasticloadbalancing:*:*:listener/app/*/*/*",
      "arn:aws:elasticloadbalancing:*:*:listener-rule/app/*/*/*/*"
     ]
    },
    {
     "Action":[
      "elasticloadbalancing:*"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:elasticloadbalancing:*:*:targetgroup/awseb-*",
      "arn:aws:elasticloadbalancing:*:*:targetgroup/eb-*",
      "arn:aws:elasticloadbalancing:*:*:loadbalancer/awseb-*",
      "arn:aws:elasticloadbalancing:*:*:loadbalancer/eb-*",
      "arn:aws:elasticloadbalancing:*:*:loadbalancer/*/awseb-*/*",
      "arn:aws:elasticloadbalancing:*:*:loadbalancer/*/eb-*/*",
      "arn:aws:elasticloadbalancing:*:*:listener/awseb-*",
      "arn:aws:elasticloadbalancing:*:*:listener/eb-*",
      "arn:aws:elasticloadbalancing:*:*:listener/*/awseb-*/*/*",
      "arn:aws:elasticloadbalancing:*:*:listener/*/eb-*/*/*",
      "arn:aws:elasticloadbalancing:*:*:listener-rule/app/awseb-*/*/*/*",
      "arn:aws:elasticloadbalancing:*:*:listener-rule/app/eb-*/*/*/*"
     ]
    },
    {
     "Action":[
      "iam:AddRoleToInstanceProfile",
      "iam:CreateInstanceProfile",
      "iam:CreateRole"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/aws-elasticbeanstalk*",
      "arn:aws:iam::*:instance-profile/aws-elasticbeanstalk*"
     ]
    },
    {
     "Action":[
      "iam:AttachRolePolicy"
     ],
     "Condition":{
      "StringLike":{
       "iam:PolicyArn":[
        "arn:aws:iam::aws:policy/AWSElasticBeanstalk*",
        "arn:aws:iam::aws:policy/service-role/AWSElasticBeanstalk*"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/aws-elasticbeanstalk*"
    },
    {
     "Action":"iam:PassRole",
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":[
        "elasticbeanstalk.amazonaws.com",
        "ec2.amazonaws.com",
        "ec2.amazonaws.com.cn",
        "autoscaling.amazonaws.com",
        "elasticloadbalancing.amazonaws.com",
        "ecs.amazonaws.com",
        "cloudformation.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/*"
    },
    {
     "Action":[
      "iam:CreateServiceLinkedRole"
     ],
     "Condition":{
      "StringLike":{
       "iam:AWSServiceName":[
        "autoscaling.amazonaws.com",
        "elasticbeanstalk.amazonaws.com",
        "elasticloadbalancing.amazonaws.com",
        "managedupdates.elasticbeanstalk.amazonaws.com",
        "maintenance.elasticbeanstalk.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/aws-service-role/autoscaling.amazonaws.com/AWSServiceRoleForAutoScaling*",
      "arn:aws:iam::*:role/aws-service-role/elasticbeanstalk.amazonaws.com/AWSServiceRoleForElasticBeanstalk*",
      "arn:aws:iam::*:role/aws-service-role/elasticloadbalancing.amazonaws.com/AWSServiceRoleForElasticLoadBalancing*",
      "arn:aws:iam::*:role/aws-service-role/managedupdates.elasticbeanstalk.amazonaws.com/AWSServiceRoleForElasticBeanstalk*",
      "arn:aws:iam::*:role/aws-service-role/maintenance.elasticbeanstalk.amazonaws.com/AWSServiceRoleForElasticBeanstalk*"
     ]
    },
    {
     "Action":[
      "logs:CreateLogGroup",
      "logs:DeleteLogGroup",
      "logs:PutRetentionPolicy"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:logs:*:*:log-group:/aws/elasticbeanstalk/*"
    },
    {
     "Action":[
      "rds:*DBSubnetGroup",
      "rds:AuthorizeDBSecurityGroupIngress",
      "rds:CreateDBInstance",
      "rds:CreateDBSecurityGroup",
      "rds:DeleteDBInstance",
      "rds:DeleteDBSecurityGroup",
      "rds:ModifyDBInstance",
      "rds:RestoreDBInstanceFromDBSnapshot"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:rds:*:*:db:*",
      "arn:aws:rds:*:*:secgrp:awseb-e-*",
      "arn:aws:rds:*:*:secgrp:eb-*",
      "arn:aws:rds:*:*:snapshot:*",
      "arn:aws:rds:*:*:subgrp:awseb-e-*",
      "arn:aws:rds:*:*:subgrp:eb-*"
     ]
    },
    {
     "Action":[
      "s3:Delete*",
      "s3:Get*",
      "s3:Put*"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::elasticbeanstalk-*/*"
    },
    {
     "Action":[
      "s3:CreateBucket",
      "s3:GetBucket*",
      "s3:ListBucket",
      "s3:PutBucketPolicy"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::elasticbeanstalk-*"
    },
    {
     "Action":[
      "sns:CreateTopic",
      "sns:DeleteTopic",
      "sns:GetTopicAttributes",
      "sns:Publish",
      "sns:SetTopicAttributes",
      "sns:Subscribe",
      "sns:Unsubscribe"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:sns:*:*:ElasticBeanstalkNotifications-*"
    },
    {
     "Action":[
      "sqs:*QueueAttributes",
      "sqs:CreateQueue",
      "sqs:DeleteQueue",
      "sqs:SendMessage",
      "sqs:TagQueue"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:sqs:*:*:awseb-e-*",
      "arn:aws:sqs:*:*:eb-*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-03-09T22:36:27+00:00"
 },
 "AdministratorAccess-Amplify":{
  "CreateDate":"2020-12-01T19:03:08+00:00",
  "DefaultVersionId":"v8",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cloudformation:CreateChangeSet",
      "cloudformation:CreateStack",
      "cloudformation:DeleteStack",
      "cloudformation:DescribeChangeSet",
      "cloudformation:DescribeStackEvents",
      "cloudformation:DescribeStackResource",
      "cloudformation:DescribeStackResources",
      "cloudformation:DescribeStacks",
      "cloudformation:ExecuteChangeSet",
      "cloudformation:GetTemplate",
      "cloudformation:UpdateStack",
      "cloudformation:ListStackResources",
      "cloudformation:DeleteStackSet",
      "cloudformation:DescribeStackSet",
      "cloudformation:UpdateStackSet"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:cloudformation:*:*:stack/amplify-*"
     ],
     "Sid":"CLICloudformationPolicy"
    },
    {
     "Action":[
      "iam:ListRoleTags",
      "iam:TagRole",
      "iam:AttachRolePolicy",
      "iam:CreatePolicy",
      "iam:DeletePolicy",
      "iam:DeleteRole",
      "iam:DeleteRolePolicy",
      "iam:DetachRolePolicy",
      "iam:PutRolePolicy",
      "iam:UpdateRole",
      "iam:GetRole",
      "iam:GetPolicy",
      "iam:GetRolePolicy",
      "iam:PassRole",
      "iam:ListPolicyVersions",
      "iam:CreatePolicyVersion",
      "iam:DeletePolicyVersion",
      "iam:CreateRole",
      "iam:ListRolePolicies",
      "iam:PutRolePermissionsBoundary",
      "iam:DeleteRolePermissionsBoundary",
      "appsync:CreateApiKey",
      "appsync:CreateDataSource",
      "appsync:CreateFunction",
      "appsync:CreateResolver",
      "appsync:CreateType",
      "appsync:DeleteApiKey",
      "appsync:DeleteDataSource",
      "appsync:DeleteFunction",
      "appsync:DeleteResolver",
      "appsync:DeleteType",
      "appsync:GetDataSource",
      "appsync:GetFunction",
      "appsync:GetIntrospectionSchema",
      "appsync:GetResolver",
      "appsync:GetSchemaCreationStatus",
      "appsync:GetType",
      "appsync:GraphQL",
      "appsync:ListApiKeys",
      "appsync:ListDataSources",
      "appsync:ListFunctions",
      "appsync:ListGraphqlApis",
      "appsync:ListResolvers",
      "appsync:ListResolversByFunction",
      "appsync:ListTypes",
      "appsync:StartSchemaCreation",
      "appsync:UpdateApiKey",
      "appsync:UpdateDataSource",
      "appsync:UpdateFunction",
      "appsync:UpdateResolver",
      "appsync:UpdateType",
      "appsync:TagResource",
      "appsync:CreateGraphqlApi",
      "appsync:DeleteGraphqlApi",
      "appsync:GetGraphqlApi",
      "appsync:ListTagsForResource",
      "appsync:UpdateGraphqlApi",
      "apigateway:DELETE",
      "apigateway:GET",
      "apigateway:PATCH",
      "apigateway:POST",
      "apigateway:PUT",
      "cognito-idp:CreateUserPool",
      "cognito-identity:CreateIdentityPool",
      "cognito-identity:DeleteIdentityPool",
      "cognito-identity:DescribeIdentity",
      "cognito-identity:DescribeIdentityPool",
      "cognito-identity:SetIdentityPoolRoles",
      "cognito-identity:GetIdentityPoolRoles",
      "cognito-identity:UpdateIdentityPool",
      "cognito-idp:CreateUserPoolClient",
      "cognito-idp:DeleteUserPool",
      "cognito-idp:DeleteUserPoolClient",
      "cognito-idp:DescribeUserPool",
      "cognito-idp:DescribeUserPoolClient",
      "cognito-idp:ListTagsForResource",
      "cognito-idp:ListUserPoolClients",
      "cognito-idp:UpdateUserPoolClient",
      "cognito-idp:CreateGroup",
      "cognito-idp:DeleteGroup",
      "cognito-identity:TagResource",
      "cognito-idp:TagResource",
      "cognito-idp:UpdateUserPool",
      "cognito-idp:SetUserPoolMfaConfig",
      "lambda:AddPermission",
      "lambda:CreateFunction",
      "lambda:DeleteFunction",
      "lambda:GetFunction",
      "lambda:GetFunctionConfiguration",
      "lambda:InvokeAsync",
      "lambda:InvokeFunction",
      "lambda:RemovePermission",
      "lambda:UpdateFunctionCode",
      "lambda:UpdateFunctionConfiguration",
      "lambda:ListTags",
      "lambda:TagResource",
      "lambda:UntagResource",
      "lambda:AddLayerVersionPermission",
      "lambda:CreateEventSourceMapping",
      "lambda:DeleteEventSourceMapping",
      "lambda:DeleteLayerVersion",
      "lambda:GetEventSourceMapping",
      "lambda:GetLayerVersion",
      "lambda:ListEventSourceMappings",
      "lambda:ListLayerVersions",
      "lambda:PublishLayerVersion",
      "lambda:RemoveLayerVersionPermission",
      "lambda:UpdateEventSourceMapping",
      "dynamodb:CreateTable",
      "dynamodb:DeleteItem",
      "dynamodb:DeleteTable",
      "dynamodb:DescribeContinuousBackups",
      "dynamodb:DescribeTable",
      "dynamodb:DescribeTimeToLive",
      "dynamodb:ListStreams",
      "dynamodb:PutItem",
      "dynamodb:TagResource",
      "dynamodb:ListTagsOfResource",
      "dynamodb:UpdateContinuousBackups",
      "dynamodb:UpdateItem",
      "dynamodb:UpdateTable",
      "dynamodb:UpdateTimeToLive",
      "s3:CreateBucket",
      "s3:ListBucket",
      "s3:PutBucketAcl",
      "s3:PutBucketCORS",
      "s3:PutBucketNotification",
      "s3:PutBucketPolicy",
      "s3:PutBucketWebsite",
      "s3:PutObjectAcl",
      "cloudfront:CreateCloudFrontOriginAccessIdentity",
      "cloudfront:CreateDistribution",
      "cloudfront:DeleteCloudFrontOriginAccessIdentity",
      "cloudfront:DeleteDistribution",
      "cloudfront:GetCloudFrontOriginAccessIdentity",
      "cloudfront:GetCloudFrontOriginAccessIdentityConfig",
      "cloudfront:GetDistribution",
      "cloudfront:GetDistributionConfig",
      "cloudfront:TagResource",
      "cloudfront:UntagResource",
      "cloudfront:UpdateCloudFrontOriginAccessIdentity",
      "cloudfront:UpdateDistribution",
      "events:DeleteRule",
      "events:DescribeRule",
      "events:ListRuleNamesByTarget",
      "events:PutRule",
      "events:PutTargets",
      "events:RemoveTargets",
      "mobiletargeting:GetApp",
      "kinesis:AddTagsToStream",
      "kinesis:CreateStream",
      "kinesis:DeleteStream",
      "kinesis:DescribeStream",
      "kinesis:DescribeStreamSummary",
      "kinesis:ListTagsForStream",
      "kinesis:PutRecords",
      "es:AddTags",
      "es:CreateElasticsearchDomain",
      "es:DeleteElasticsearchDomain",
      "es:DescribeElasticsearchDomain",
      "s3:PutEncryptionConfiguration"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:CalledVia":[
        "cloudformation.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CLIManageviaCFNPolicy"
    },
    {
     "Action":[
      "appsync:GetIntrospectionSchema",
      "appsync:GraphQL",
      "appsync:UpdateApiKey",
      "appsync:ListApiKeys",
      "amplify:*",
      "amplifybackend:*",
      "amplifyuibuilder:*",
      "sts:AssumeRole",
      "mobiletargeting:*",
      "cognito-idp:AdminAddUserToGroup",
      "cognito-idp:AdminCreateUser",
      "cognito-idp:CreateGroup",
      "cognito-idp:DeleteGroup",
      "cognito-idp:DeleteUser",
      "cognito-idp:ListUsers",
      "cognito-idp:AdminGetUser",
      "cognito-idp:ListUsersInGroup",
      "cognito-idp:AdminDisableUser",
      "cognito-idp:AdminRemoveUserFromGroup",
      "cognito-idp:AdminResetUserPassword",
      "cognito-idp:AdminListGroupsForUser",
      "cognito-idp:ListGroups",
      "cognito-idp:AdminListUserAuthEvents",
      "cognito-idp:AdminDeleteUser",
      "cognito-idp:AdminConfirmSignUp",
      "cognito-idp:AdminEnableUser",
      "cognito-idp:AdminUpdateUserAttributes",
      "cognito-idp:DescribeIdentityProvider",
      "cognito-idp:DescribeUserPool",
      "cognito-idp:DeleteUserPool",
      "cognito-idp:DescribeUserPoolClient",
      "cognito-idp:CreateUserPool",
      "cognito-idp:CreateUserPoolClient",
      "cognito-idp:UpdateUserPool",
      "cognito-idp:AdminSetUserPassword",
      "cognito-idp:ListUserPools",
      "cognito-idp:ListUserPoolClients",
      "cognito-idp:ListIdentityProviders",
      "cognito-idp:GetUserPoolMfaConfig",
      "cognito-identity:GetIdentityPoolRoles",
      "cognito-identity:SetIdentityPoolRoles",
      "cognito-identity:CreateIdentityPool",
      "cognito-identity:DeleteIdentityPool",
      "cognito-identity:ListIdentityPools",
      "cognito-identity:DescribeIdentityPool",
      "dynamodb:DescribeTable",
      "dynamodb:ListTables",
      "lambda:GetFunction",
      "lambda:CreateFunction",
      "lambda:AddPermission",
      "lambda:DeleteFunction",
      "lambda:DeleteLayerVersion",
      "lambda:InvokeFunction",
      "lambda:ListLayerVersions",
      "iam:PutRolePolicy",
      "iam:CreatePolicy",
      "iam:AttachRolePolicy",
      "iam:ListPolicyVersions",
      "iam:ListAttachedRolePolicies",
      "iam:CreateRole",
      "iam:PassRole",
      "iam:ListRolePolicies",
      "iam:DeleteRolePolicy",
      "iam:CreatePolicyVersion",
      "iam:DeletePolicyVersion",
      "iam:DeleteRole",
      "iam:DetachRolePolicy",
      "cloudformation:ListStacks",
      "sns:CreateSMSSandboxPhoneNumber",
      "sns:GetSMSSandboxAccountStatus",
      "sns:VerifySMSSandboxPhoneNumber",
      "sns:DeleteSMSSandboxPhoneNumber",
      "sns:ListSMSSandboxPhoneNumbers",
      "sns:ListOriginationNumbers",
      "rekognition:DescribeCollection",
      "logs:DescribeLogStreams",
      "logs:GetLogEvents",
      "lex:GetBot",
      "lex:GetBuiltinIntent",
      "lex:GetBuiltinIntents",
      "lex:GetBuiltinSlotTypes",
      "cloudformation:GetTemplateSummary",
      "codecommit:GitPull"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CLISDKCalls"
    },
    {
     "Action":[
      "ssm:PutParameter",
      "ssm:DeleteParameter",
      "ssm:GetParametersByPath",
      "ssm:GetParameters",
      "ssm:GetParameter",
      "ssm:DeleteParameters"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:ssm:*:*:parameter/amplify/*",
     "Sid":"AmplifySSMCalls"
    },
    {
     "Action":[
      "geo:*"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"GeoPowerUser"
    },
    {
     "Action":[
      "s3:CreateBucket",
      "s3:DeleteBucket",
      "s3:DeleteBucketPolicy",
      "s3:DeleteBucketWebsite",
      "s3:DeleteObject",
      "s3:DeleteObjectVersion",
      "s3:GetBucketLocation",
      "s3:GetObject",
      "s3:ListAllMyBuckets",
      "s3:ListBucket",
      "s3:ListBucketVersions",
      "s3:PutBucketAcl",
      "s3:PutBucketCORS",
      "s3:PutBucketNotification",
      "s3:PutBucketPolicy",
      "s3:PutBucketVersioning",
      "s3:PutBucketWebsite",
      "s3:PutEncryptionConfiguration",
      "s3:PutLifecycleConfiguration",
      "s3:PutObject",
      "s3:PutObjectAcl"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AmplifyStorageSDKCalls"
    },
    {
     "Action":[
      "cloudfront:CreateCloudFrontOriginAccessIdentity",
      "cloudfront:CreateDistribution",
      "cloudfront:CreateInvalidation",
      "cloudfront:GetDistribution",
      "cloudfront:GetDistributionConfig",
      "cloudfront:ListCloudFrontOriginAccessIdentities",
      "cloudfront:ListDistributions",
      "cloudfront:ListDistributionsByLambdaFunction",
      "cloudfront:ListDistributionsByWebACLId",
      "cloudfront:ListFieldLevelEncryptionConfigs",
      "cloudfront:ListFieldLevelEncryptionProfiles",
      "cloudfront:ListInvalidations",
      "cloudfront:ListPublicKeys",
      "cloudfront:ListStreamingDistributions",
      "cloudfront:UpdateDistribution",
      "cloudfront:TagResource",
      "cloudfront:UntagResource",
      "cloudfront:ListTagsForResource",
      "cloudfront:DeleteDistribution",
      "iam:AttachRolePolicy",
      "iam:CreateRole",
      "iam:CreateServiceLinkedRole",
      "iam:GetRole",
      "iam:PutRolePolicy",
      "iam:PassRole",
      "lambda:CreateFunction",
      "lambda:EnableReplication",
      "lambda:DeleteFunction",
      "lambda:GetFunction",
      "lambda:GetFunctionConfiguration",
      "lambda:PublishVersion",
      "lambda:UpdateFunctionCode",
      "lambda:UpdateFunctionConfiguration",
      "lambda:ListTags",
      "lambda:TagResource",
      "lambda:UntagResource",
      "route53:ChangeResourceRecordSets",
      "route53:ListHostedZonesByName",
      "route53:ListResourceRecordSets",
      "s3:CreateBucket",
      "s3:GetAccelerateConfiguration",
      "s3:GetObject",
      "s3:ListBucket",
      "s3:PutAccelerateConfiguration",
      "s3:PutBucketPolicy",
      "s3:PutObject",
      "s3:PutBucketTagging",
      "s3:GetBucketTagging",
      "lambda:ListEventSourceMappings",
      "lambda:CreateEventSourceMapping",
      "iam:UpdateAssumeRolePolicy",
      "iam:DeleteRolePolicy",
      "sqs:CreateQueue",
      "sqs:DeleteQueue",
      "sqs:GetQueueAttributes",
      "sqs:SetQueueAttributes",
      "amplify:GetApp",
      "amplify:GetBranch",
      "amplify:UpdateApp",
      "amplify:UpdateBranch"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AmplifySSRCalls"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-04-13T22:42:11+00:00"
 },
 "AlexaForBusinessDeviceSetup":{
  "CreateDate":"2017-11-30T16:47:16+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "a4b:RegisterDevice",
      "a4b:CompleteRegistration",
      "a4b:SearchDevices",
      "a4b:SearchNetworkProfiles",
      "a4b:GetNetworkProfile",
      "a4b:PutDeviceSetupEvents"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "secretsmanager:GetSecretValue"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:secretsmanager:*:*:secret:A4BNetworkProfile*",
     "Sid":"A4bDeviceSetupAccess"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-05-20T21:05:39+00:00"
 },
 "AlexaForBusinessFullAccess":{
  "CreateDate":"2017-11-30T16:47:09+00:00",
  "DefaultVersionId":"v5",
  "Document":{
   "Statement":[
    {
     "Action":[
      "a4b:*",
      "kms:DescribeKey"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "iam:CreateServiceLinkedRole"
     ],
     "Condition":{
      "StringLike":{
       "iam:AWSServiceName":[
        "*a4b.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "iam:DeleteServiceLinkedRole",
      "iam:GetServiceLinkedRoleDeletionStatus"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/aws-service-role/*a4b.amazonaws.com/AWSServiceRoleForAlexaForBusiness*"
    },
    {
     "Action":[
      "secretsmanager:GetSecretValue",
      "secretsmanager:DeleteSecret",
      "secretsmanager:UpdateSecret"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:secretsmanager:*:*:secret:A4B*"
    },
    {
     "Action":"secretsmanager:CreateSecret",
     "Condition":{
      "StringLike":{
       "secretsmanager:Name":"A4B*"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-07-01T21:01:55+00:00"
 },
 "AlexaForBusinessGatewayExecution":{
  "CreateDate":"2017-11-30T16:47:19+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "a4b:Send*",
      "a4b:Get*"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:a4b:*:*:gateway/*"
    },
    {
     "Action":[
      "sqs:ReceiveMessage",
      "sqs:DeleteMessage"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:sqs:*:*:dd-*",
      "arn:aws:sqs:*:*:sd-*"
     ]
    },
    {
     "Action":[
      "a4b:List*",
      "logs:CreateLogGroup",
      "logs:CreateLogStream",
      "logs:DescribeLogGroups",
      "logs:PutLogEvents"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2017-11-30T16:47:19+00:00"
 },
 "AlexaForBusinessLifesizeDelegatedAccessPolicy":{
  "CreateDate":"2020-06-04T19:46:56+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "a4b:DisassociateDeviceFromRoom",
      "a4b:DeleteDevice",
      "a4b:UpdateDevice",
      "a4b:GetDevice"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:a4b:us-east-1:*:device/*/*:A2IWO7UEGWV4TL"
     ]
    },
    {
     "Action":[
      "a4b:RegisterAVSDevice"
     ],
     "Condition":{
      "StringEquals":{
       "a4b:amazonId":[
        "A2IWO7UEGWV4TL"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "a4b:SearchDevices"
     ],
     "Condition":{
      "ForAllValues:StringLike":{
       "a4b:filters_deviceType":[
        "*A2IWO7UEGWV4TL"
       ]
      },
      "Null":{
       "a4b:filters_deviceType":"false"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "a4b:AssociateDeviceWithRoom"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:a4b:us-east-1:*:device/*/*:A2IWO7UEGWV4TL",
      "arn:aws:a4b:us-east-1:*:room/*"
     ]
    },
    {
     "Action":[
      "a4b:GetRoom",
      "a4b:GetAddressBook",
      "a4b:SearchRooms",
      "a4b:CreateContact",
      "a4b:CreateRoom",
      "a4b:UpdateContact",
      "a4b:ListConferenceProviders",
      "a4b:DeleteRoom",
      "a4b:CreateAddressBook",
      "a4b:DisassociateContactFromAddressBook",
      "a4b:CreateConferenceProvider",
      "a4b:PutConferencePreference",
      "a4b:DeleteAddressBook",
      "a4b:AssociateContactWithAddressBook",
      "a4b:DeleteContact",
      "a4b:SearchProfiles",
      "a4b:UpdateProfile",
      "a4b:GetContact"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "kms:DescribeKey"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:kms:*:*:key/*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-06-12T20:31:59+00:00"
 },
 "AlexaForBusinessNetworkProfileServicePolicy":{
  "CreateDate":"2019-03-13T00:53:40+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "acm-pca:GetCertificate",
      "acm-pca:IssueCertificate",
      "acm-pca:RevokeCertificate"
     ],
     "Condition":{
      "StringEquals":{
       "aws:ResourceTag/a4b":"enabled"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"A4bPcaTagAccess"
    },
    {
     "Action":[
      "secretsmanager:GetSecretValue"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:secretsmanager:*:*:secret:A4BNetworkProfile*",
     "Sid":"A4bNetworkProfileAccess"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-04-05T21:57:56+00:00"
 },
 "AlexaForBusinessPolyDelegatedAccessPolicy":{
  "CreateDate":"2019-10-16T19:48:45+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "a4b:DisassociateDeviceFromRoom",
      "a4b:DeleteDevice",
      "a4b:UpdateDevice",
      "a4b:GetDevice"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:a4b:us-east-1:*:device/*/*:A238TWV36W3S92",
      "arn:aws:a4b:us-east-1:*:device/*/*:A1FUZ1SC53VJXD"
     ]
    },
    {
     "Action":[
      "a4b:RegisterAVSDevice"
     ],
     "Condition":{
      "StringEquals":{
       "a4b:amazonId":[
        "A238TWV36W3S92",
        "A1FUZ1SC53VJXD"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "a4b:SearchDevices"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "a4b:AssociateDeviceWithRoom"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:a4b:us-east-1:*:device/*/*:A238TWV36W3S92",
      "arn:aws:a4b:us-east-1:*:device/*/*:A1FUZ1SC53VJXD",
      "arn:aws:a4b:us-east-1:*:room/*"
     ]
    },
    {
     "Action":[
      "a4b:GetRoom",
      "a4b:SearchRooms",
      "a4b:CreateRoom",
      "a4b:GetProfile",
      "a4b:SearchSkillGroups",
      "a4b:DisassociateSkillGroupFromRoom",
      "a4b:AssociateSkillGroupWithRoom",
      "a4b:GetSkillGroup",
      "a4b:SearchProfiles",
      "a4b:GetAddressBook",
      "a4b:UpdateRoom"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-10-16T19:48:45+00:00"
 },
 "AlexaForBusinessReadOnlyAccess":{
  "CreateDate":"2017-11-30T16:47:12+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "a4b:Get*",
      "a4b:List*",
      "a4b:Search*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-11-20T00:25:33+00:00"
 },
 "AmazonAPIGatewayAdministrator":{
  "CreateDate":"2015-07-09T17:34:45+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "apigateway:*"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:apigateway:*::/*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2015-07-09T17:34:45+00:00"
 },
 "AmazonAPIGatewayInvokeFullAccess":{
  "CreateDate":"2015-07-09T17:36:12+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "execute-api:Invoke",
      "execute-api:ManageConnections"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:execute-api:*:*:*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2018-12-18T18:25:10+00:00"
 },
 "AmazonAPIGatewayPushToCloudWatchLogs":{
  "CreateDate":"2015-11-11T23:41:46+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "logs:CreateLogGroup",
      "logs:CreateLogStream",
      "logs:DescribeLogGroups",
      "logs:DescribeLogStreams",
      "logs:PutLogEvents",
      "logs:GetLogEvents",
      "logs:FilterLogEvents"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2015-11-11T23:41:46+00:00"
 },
 "AmazonAppFlowFullAccess":{
  "CreateDate":"2020-06-02T23:30:14+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":"appflow:*",
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"iam:ListRoles",
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ListRolesForRedshift"
    },
    {
     "Action":[
      "kms:ListKeys",
      "kms:DescribeKey",
      "kms:ListAliases"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"KMSListAccess"
    },
    {
     "Action":[
      "kms:CreateGrant"
     ],
     "Condition":{
      "Bool":{
       "kms:GrantIsForAWSResource":"true"
      },
      "StringLike":{
       "kms:ViaService":"appflow.*.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"KMSGrantAccess"
    },
    {
     "Action":[
      "kms:ListGrants"
     ],
     "Condition":{
      "StringLike":{
       "kms:ViaService":"appflow.*.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"KMSListGrantAccess"
    },
    {
     "Action":[
      "s3:ListAllMyBuckets",
      "s3:ListBucket",
      "s3:GetBucketLocation",
      "s3:GetBucketPolicy"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"S3ReadAccess"
    },
    {
     "Action":[
      "s3:PutBucketPolicy"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::appflow-*",
     "Sid":"S3PutBucketPolicyAccess"
    },
    {
     "Action":"secretsmanager:CreateSecret",
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:CalledVia":[
        "appflow.amazonaws.com"
       ]
      },
      "StringLike":{
       "secretsmanager:Name":"appflow!*"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"SecretsManagerCreateSecretAccess"
    },
    {
     "Action":[
      "secretsmanager:PutResourcePolicy"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:CalledVia":[
        "appflow.amazonaws.com"
       ]
      },
      "StringEqualsIgnoreCase":{
       "secretsmanager:ResourceTag/aws:secretsmanager:owningService":"appflow"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"SecretsManagerPutResourcePolicyAccess"
    },
    {
     "Action":[
      "lambda:ListFunctions"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"LambdaListFunctions"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-02-28T23:11:23+00:00"
 },
 "AmazonAppFlowReadOnlyAccess":{
  "CreateDate":"2020-06-02T23:26:51+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "appflow:DescribeConnector",
      "appflow:DescribeConnectors",
      "appflow:DescribeConnectorProfiles",
      "appflow:DescribeFlows",
      "appflow:DescribeFlowExecution",
      "appflow:DescribeConnectorFields",
      "appflow:ListConnectors",
      "appflow:ListConnectorFields",
      "appflow:ListTagsForResource"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-02-28T20:42:58+00:00"
 },
 "AmazonAppStreamFullAccess":{
  "CreateDate":"2015-02-06T18:40:09+00:00",
  "DefaultVersionId":"v6",
  "Document":{
   "Statement":[
    {
     "Action":[
      "appstream:*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "application-autoscaling:DeleteScalingPolicy",
      "application-autoscaling:DescribeScalableTargets",
      "application-autoscaling:DescribeScalingPolicies",
      "application-autoscaling:PutScalingPolicy",
      "application-autoscaling:RegisterScalableTarget",
      "application-autoscaling:DescribeScheduledActions",
      "application-autoscaling:PutScheduledAction",
      "application-autoscaling:DeleteScheduledAction"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "cloudwatch:DeleteAlarms",
      "cloudwatch:DescribeAlarms",
      "cloudwatch:GetMetricStatistics",
      "cloudwatch:PutMetricAlarm"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:DescribeRouteTables",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeSubnets",
      "ec2:DescribeVpcs",
      "ec2:DescribeVpcEndpoints"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"iam:ListRoles",
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"iam:PassRole",
     "Condition":{
      "StringLike":{
       "iam:PassedToService":"application-autoscaling.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/service-role/ApplicationAutoScalingForAmazonAppStreamAccess"
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringLike":{
       "iam:AWSServiceName":"appstream.application-autoscaling.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/aws-service-role/appstream.application-autoscaling.amazonaws.com/AWSServiceRoleForApplicationAutoScaling_AppStreamFleet"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-08-28T17:24:35+00:00"
 },
 "AmazonAppStreamReadOnlyAccess":{
  "CreateDate":"2015-02-06T18:40:10+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "appstream:Get*",
      "appstream:List*",
      "appstream:Describe*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2016-12-07T21:00:06+00:00"
 },
 "AmazonAppStreamServiceAccess":{
  "CreateDate":"2016-11-19T04:17:37+00:00",
  "DefaultVersionId":"v8",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:DescribeVpcs",
      "ec2:DescribeSubnets",
      "ec2:DescribeAvailabilityZones",
      "ec2:CreateNetworkInterface",
      "ec2:DescribeNetworkInterfaces",
      "ec2:DeleteNetworkInterface",
      "ec2:DescribeSubnets",
      "ec2:AssociateAddress",
      "ec2:DisassociateAddress",
      "ec2:DescribeRouteTables",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeVpcEndpoints",
      "s3:ListAllMyBuckets",
      "ds:DescribeDirectories"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "s3:CreateBucket",
      "s3:ListBucket",
      "s3:GetObject",
      "s3:PutObject",
      "s3:DeleteObject",
      "s3:GetObjectVersion",
      "s3:DeleteObjectVersion",
      "s3:GetBucketPolicy",
      "s3:PutBucketPolicy",
      "s3:PutEncryptionConfiguration"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::appstream2-36fb080bb8-*",
      "arn:aws:s3:::appstream-app-settings-*",
      "arn:aws:s3:::appstream-logs-*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-06-26T16:33:54+00:00"
 },
 "AmazonAthenaFullAccess":{
  "CreateDate":"2016-11-30T16:46:01+00:00",
  "DefaultVersionId":"v7",
  "Document":{
   "Statement":[
    {
     "Action":[
      "athena:*"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "glue:CreateDatabase",
      "glue:DeleteDatabase",
      "glue:GetDatabase",
      "glue:GetDatabases",
      "glue:UpdateDatabase",
      "glue:CreateTable",
      "glue:DeleteTable",
      "glue:BatchDeleteTable",
      "glue:UpdateTable",
      "glue:GetTable",
      "glue:GetTables",
      "glue:BatchCreatePartition",
      "glue:CreatePartition",
      "glue:DeletePartition",
      "glue:BatchDeletePartition",
      "glue:UpdatePartition",
      "glue:GetPartition",
      "glue:GetPartitions",
      "glue:BatchGetPartition"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "s3:GetBucketLocation",
      "s3:GetObject",
      "s3:ListBucket",
      "s3:ListBucketMultipartUploads",
      "s3:ListMultipartUploadParts",
      "s3:AbortMultipartUpload",
      "s3:CreateBucket",
      "s3:PutObject",
      "s3:PutBucketPublicAccessBlock"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::aws-athena-query-results-*"
     ]
    },
    {
     "Action":[
      "s3:GetObject",
      "s3:ListBucket"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::athena-examples*"
     ]
    },
    {
     "Action":[
      "s3:ListBucket",
      "s3:GetBucketLocation",
      "s3:ListAllMyBuckets"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "sns:ListTopics",
      "sns:GetTopicAttributes"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "cloudwatch:PutMetricAlarm",
      "cloudwatch:DescribeAlarms",
      "cloudwatch:DeleteAlarms"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "lakeformation:GetDataAccess"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-07-07T20:15:04+00:00"
 },
 "AmazonAugmentedAIFullAccess":{
  "CreateDate":"2019-12-03T16:21:56+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "sagemaker:*HumanLoop",
      "sagemaker:*HumanLoops",
      "sagemaker:*FlowDefinition",
      "sagemaker:*FlowDefinitions",
      "sagemaker:*HumanTaskUi",
      "sagemaker:*HumanTaskUis"
     ],
     "Condition":{
      "StringEqualsIfExists":{
       "sagemaker:WorkteamType":[
        "private-crowd",
        "vendor-crowd"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":[
        "sagemaker.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-12-03T16:21:56+00:00"
 },
 "AmazonAugmentedAIHumanLoopFullAccess":{
  "CreateDate":"2019-12-03T16:20:47+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "sagemaker:*HumanLoop",
      "sagemaker:*HumanLoops"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-12-03T16:20:47+00:00"
 },
 "AmazonAugmentedAIIntegratedAPIAccess":{
  "CreateDate":"2020-04-22T20:47:32+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "sagemaker:*HumanLoop",
      "sagemaker:*HumanLoops",
      "sagemaker:*FlowDefinition",
      "sagemaker:*FlowDefinitions",
      "sagemaker:*HumanTaskUi",
      "sagemaker:*HumanTaskUis"
     ],
     "Condition":{
      "StringEqualsIfExists":{
       "sagemaker:WorkteamType":[
        "private-crowd",
        "vendor-crowd"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "textract:AnalyzeDocument"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "rekognition:DetectModerationLabels"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":[
        "sagemaker.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-04-22T20:47:32+00:00"
 },
 "AmazonBraketFullAccess":{
  "CreateDate":"2020-08-06T20:12:37+00:00",
  "DefaultVersionId":"v5",
  "Document":{
   "Statement":[
    {
     "Action":[
      "s3:GetObject",
      "s3:PutObject",
      "s3:ListBucket",
      "s3:CreateBucket",
      "s3:PutBucketPublicAccessBlock",
      "s3:PutBucketPolicy"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::amazon-braket-*"
    },
    {
     "Action":[
      "s3:ListAllMyBuckets"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ecr:GetDownloadUrlForLayer",
      "ecr:BatchGetImage",
      "ecr:BatchCheckLayerAvailability"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:ecr:*:*:repository/amazon-braket*"
    },
    {
     "Action":[
      "ecr:GetAuthorizationToken"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "logs:Describe*",
      "logs:Get*",
      "logs:List*",
      "logs:StartQuery",
      "logs:StopQuery",
      "logs:TestMetricFilter",
      "logs:FilterLogEvents"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:logs:*:*:log-group:/aws/braket*"
    },
    {
     "Action":[
      "iam:ListRoles",
      "iam:ListRolePolicies",
      "iam:GetRole",
      "iam:GetRolePolicy",
      "iam:ListAttachedRolePolicies"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "sagemaker:ListNotebookInstances"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "sagemaker:CreatePresignedNotebookInstanceUrl",
      "sagemaker:CreateNotebookInstance",
      "sagemaker:DeleteNotebookInstance",
      "sagemaker:DescribeNotebookInstance",
      "sagemaker:StartNotebookInstance",
      "sagemaker:StopNotebookInstance",
      "sagemaker:UpdateNotebookInstance",
      "sagemaker:ListTags",
      "sagemaker:AddTags",
      "sagemaker:DeleteTags"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:sagemaker:*:*:notebook-instance/amazon-braket-*"
    },
    {
     "Action":[
      "sagemaker:DescribeNotebookInstanceLifecycleConfig",
      "sagemaker:CreateNotebookInstanceLifecycleConfig",
      "sagemaker:DeleteNotebookInstanceLifecycleConfig",
      "sagemaker:ListNotebookInstanceLifecycleConfigs",
      "sagemaker:UpdateNotebookInstanceLifecycleConfig"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:sagemaker:*:*:notebook-instance-lifecycle-config/amazon-braket-*"
    },
    {
     "Action":"braket:*",
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":"braket.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/aws-service-role/braket.amazonaws.com/AWSServiceRoleForAmazonBraket*"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringLike":{
       "iam:PassedToService":[
        "sagemaker.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/service-role/AmazonBraketServiceSageMakerNotebookRole*"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringLike":{
       "iam:PassedToService":[
        "braket.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/service-role/AmazonBraketJobsExecutionRole*"
    },
    {
     "Action":[
      "logs:GetQueryResults"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:logs:*:*:log-group:*"
     ]
    },
    {
     "Action":[
      "logs:PutLogEvents",
      "logs:CreateLogStream",
      "logs:CreateLogGroup"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:logs:*:*:log-group:/aws/braket*"
    },
    {
     "Action":"cloudwatch:PutMetricData",
     "Condition":{
      "StringEquals":{
       "cloudwatch:namespace":"/aws/braket"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-03-31T19:03:33+00:00"
 },
 "AmazonBraketJobsExecutionPolicy":{
  "CreateDate":"2021-11-26T19:34:41+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "s3:GetObject",
      "s3:PutObject",
      "s3:ListBucket",
      "s3:CreateBucket",
      "s3:PutBucketPublicAccessBlock",
      "s3:PutBucketPolicy"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::amazon-braket-*"
    },
    {
     "Action":[
      "ecr:GetDownloadUrlForLayer",
      "ecr:BatchGetImage",
      "ecr:BatchCheckLayerAvailability"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:ecr:*:*:repository/amazon-braket*"
    },
    {
     "Action":[
      "ecr:GetAuthorizationToken"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "braket:CancelJob",
      "braket:CancelQuantumTask",
      "braket:CreateJob",
      "braket:CreateQuantumTask",
      "braket:GetDevice",
      "braket:GetJob",
      "braket:GetQuantumTask",
      "braket:SearchDevices",
      "braket:SearchJobs",
      "braket:SearchQuantumTasks",
      "braket:ListTagsForResource",
      "braket:TagResource",
      "braket:UntagResource"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringLike":{
       "iam:PassedToService":[
        "braket.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/service-role/AmazonBraketJobsExecutionRole*"
    },
    {
     "Action":[
      "iam:ListRoles"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/*"
    },
    {
     "Action":[
      "logs:GetQueryResults"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:logs:*:*:log-group:*"
     ]
    },
    {
     "Action":[
      "logs:PutLogEvents",
      "logs:CreateLogStream",
      "logs:CreateLogGroup",
      "logs:GetLogEvents",
      "logs:DescribeLogStreams",
      "logs:StartQuery",
      "logs:StopQuery"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:logs:*:*:log-group:/aws/braket*"
    },
    {
     "Action":"cloudwatch:PutMetricData",
     "Condition":{
      "StringEquals":{
       "cloudwatch:namespace":"/aws/braket"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-11-28T05:34:55+00:00"
 },
 "AmazonBraketServiceRolePolicy":{
  "CreateDate":"2020-08-04T17:12:23+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "s3:PutObject",
      "s3:GetObject",
      "s3:ListBucket"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::amazon-braket-*"
    },
    {
     "Action":[
      "logs:PutLogEvents",
      "logs:CreateLogStream",
      "logs:DescribeLogStreams",
      "logs:CreateLogGroup",
      "logs:DescribeLogGroups"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:logs:*:*:log-group:/aws/braket:*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-08-06T20:10:42+00:00"
 },
 "AmazonChimeFullAccess":{
  "CreateDate":"2017-11-01T22:15:43+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "chime:*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "s3:ListBucket",
      "s3:ListAllMyBuckets",
      "s3:GetBucketAcl",
      "s3:GetBucketLocation",
      "s3:GetBucketLogging",
      "s3:GetBucketVersioning",
      "s3:GetBucketWebsite"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "logs:CreateLogDelivery",
      "logs:DeleteLogDelivery",
      "logs:GetLogDelivery",
      "logs:ListLogDeliveries",
      "logs:DescribeResourcePolicies",
      "logs:PutResourcePolicy",
      "logs:CreateLogGroup",
      "logs:DescribeLogGroups"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "sns:CreateTopic",
      "sns:GetTopicAttributes"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:sns:*:*:ChimeVoiceConnector-Streaming*"
     ]
    },
    {
     "Action":[
      "sqs:GetQueueAttributes",
      "sqs:CreateQueue"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:sqs:*:*:ChimeVoiceConnector-Streaming*"
     ]
    },
    {
     "Action":[
      "kinesis:ListStreams"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "kinesis:DescribeStream"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:kinesis:*:*:stream/chime-chat-*",
      "arn:aws:kinesis:*:*:stream/chime-messaging-*"
     ]
    },
    {
     "Action":[
      "s3:GetEncryptionConfiguration",
      "s3:ListBucket"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::chime-chat-*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-12-14T21:00:52+00:00"
 },
 "AmazonChimeReadOnly":{
  "CreateDate":"2017-11-01T22:04:17+00:00",
  "DefaultVersionId":"v10",
  "Document":{
   "Statement":[
    {
     "Action":[
      "chime:List*",
      "chime:Get*",
      "chime:Describe*",
      "chime:SearchAvailablePhoneNumbers"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-12-14T20:53:57+00:00"
 },
 "AmazonChimeSDK":{
  "CreateDate":"2020-02-04T21:53:37+00:00",
  "DefaultVersionId":"v4",
  "Document":{
   "Statement":[
    {
     "Action":[
      "chime:CreateMeeting",
      "chime:CreateMeetingWithAttendees",
      "chime:DeleteMeeting",
      "chime:GetMeeting",
      "chime:ListMeetings",
      "chime:CreateAttendee",
      "chime:BatchCreateAttendee",
      "chime:DeleteAttendee",
      "chime:GetAttendee",
      "chime:ListAttendees",
      "chime:ListAttendeeTags",
      "chime:ListMeetingTags",
      "chime:ListTagsForResource",
      "chime:TagAttendee",
      "chime:TagMeeting",
      "chime:TagResource",
      "chime:UntagAttendee",
      "chime:UntagMeeting",
      "chime:UntagResource",
      "chime:StartMeetingTranscription",
      "chime:StopMeetingTranscription"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-10-21T18:04:27+00:00"
 },
 "AmazonChimeSDKMediaPipelinesServiceLinkedRolePolicy":{
  "CreateDate":"2022-04-04T22:02:05+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "chime:GetMeeting",
      "chime:CreateAttendee",
      "chime:DeleteAttendee"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-04-04T22:02:05+00:00"
 },
 "AmazonChimeServiceRolePolicy":{
  "CreateDate":"2019-09-30T22:25:06+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iam:CreateServiceLinkedRole"
     ],
     "Condition":{
      "StringLike":{
       "iam:AWSServiceName":"chime.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/aws-service-role/chime.amazonaws.com/AWSServiceRoleForAmazonChime"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-09-30T22:25:06+00:00"
 },
 "AmazonChimeTranscriptionServiceLinkedRolePolicy":{
  "CreateDate":"2021-08-04T21:47:41+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "transcribe:StartStreamTranscription",
      "transcribe:StartMedicalStreamTranscription"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-08-04T21:47:41+00:00"
 },
 "AmazonChimeUserManagement":{
  "CreateDate":"2017-11-01T22:17:26+00:00",
  "DefaultVersionId":"v8",
  "Document":{
   "Statement":[
    {
     "Action":[
      "chime:ListAccounts",
      "chime:GetAccount",
      "chime:GetAccountSettings",
      "chime:UpdateAccountSettings",
      "chime:ListUsers",
      "chime:GetUser",
      "chime:GetUserByEmail",
      "chime:InviteUsers",
      "chime:InviteUsersFromProvider",
      "chime:SuspendUsers",
      "chime:ActivateUsers",
      "chime:UpdateUserLicenses",
      "chime:ResetPersonalPIN",
      "chime:LogoutUser",
      "chime:ListDomains",
      "chime:GetDomain",
      "chime:ListDirectories",
      "chime:ListGroups",
      "chime:SubmitSupportRequest",
      "chime:ListDelegates",
      "chime:ListAccountUsageReportData",
      "chime:GetMeetingDetail",
      "chime:ListMeetingEvents",
      "chime:ListMeetingsReportData",
      "chime:GetUserActivityReportData",
      "chime:UpdateUser",
      "chime:BatchUpdateUser",
      "chime:BatchSuspendUser",
      "chime:BatchUnsuspendUser",
      "chime:AssociatePhoneNumberWithUser",
      "chime:DisassociatePhoneNumberFromUser",
      "chime:GetPhoneNumber",
      "chime:ListPhoneNumbers",
      "chime:GetUserSettings",
      "chime:UpdateUserSettings",
      "chime:CreateUser",
      "chime:AssociateSigninDelegateGroupsWithAccount",
      "chime:DisassociateSigninDelegateGroupsFromAccount"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-02-18T19:26:10+00:00"
 },
 "AmazonChimeVoiceConnectorServiceLinkedRolePolicy":{
  "CreateDate":"2019-09-30T22:16:42+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "chime:GetVoiceConnector*"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "kinesisvideo:GetDataEndpoint",
      "kinesisvideo:PutMedia",
      "kinesisvideo:UpdateDataRetention",
      "kinesisvideo:DescribeStream",
      "kinesisvideo:CreateStream"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:kinesisvideo:*:*:stream/ChimeVoiceConnector-*"
     ]
    },
    {
     "Action":[
      "kinesisvideo:ListStreams"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "SNS:Publish"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:sns:*:*:ChimeVoiceConnector-Streaming*"
     ]
    },
    {
     "Action":[
      "sqs:SendMessage"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:sqs:*:*:ChimeVoiceConnector-Streaming*"
     ]
    },
    {
     "Action":[
      "polly:SynthesizeSpeech"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-03-17T16:18:11+00:00"
 },
 "AmazonCloudDirectoryFullAccess":{
  "CreateDate":"2017-02-25T00:41:39+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "clouddirectory:*"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2017-02-25T00:41:39+00:00"
 },
 "AmazonCloudDirectoryReadOnlyAccess":{
  "CreateDate":"2017-02-28T23:42:06+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "clouddirectory:List*",
      "clouddirectory:Get*",
      "clouddirectory:LookupPolicy",
      "clouddirectory:BatchRead"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2017-02-28T23:42:06+00:00"
 },
 "AmazonCloudWatchEvidentlyFullAccess":{
  "CreateDate":"2021-11-29T15:10:14+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "evidently:*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "iam:ListRoles"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "iam:GetRole"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/service-role/CloudWatchRUMEvidentlyRole-*"
     ]
    },
    {
     "Action":[
      "s3:GetBucketLocation",
      "s3:ListAllMyBuckets"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::*"
    },
    {
     "Action":[
      "cloudwatch:GetMetricData",
      "cloudwatch:GetMetricStatistics",
      "cloudwatch:DescribeAlarmHistory",
      "cloudwatch:DescribeAlarmsForMetric",
      "cloudwatch:ListTagsForResource"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "cloudwatch:DescribeAlarms",
      "cloudwatch:TagResource",
      "cloudwatch:UnTagResource"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:cloudwatch:*:*:alarm:*"
     ]
    },
    {
     "Action":[
      "cloudtrail:LookupEvents"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "cloudwatch:PutMetricAlarm"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:cloudwatch:*:*:alarm:Evidently-Alarm-*"
     ]
    },
    {
     "Action":[
      "sns:ListTopics"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "sns:CreateTopic",
      "sns:Subscribe",
      "sns:ListSubscriptionsByTopic"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:*:sns:*:*:Evidently-*"
     ]
    },
    {
     "Action":[
      "logs:DescribeLogGroups"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-11-29T15:10:14+00:00"
 },
 "AmazonCloudWatchEvidentlyReadOnlyAccess":{
  "CreateDate":"2021-11-29T15:08:38+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "evidently:GetExperiment",
      "evidently:GetFeature",
      "evidently:GetLaunch",
      "evidently:GetProject",
      "evidently:ListExperiments",
      "evidently:ListFeatures",
      "evidently:ListLaunches",
      "evidently:ListProjects"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-11-29T15:08:38+00:00"
 },
 "AmazonCloudWatchRUMFullAccess":{
  "CreateDate":"2021-11-29T15:46:12+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "rum:*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "iam:GetRole",
      "iam:CreateServiceLinkedRole"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/aws-service-role/rum.amazonaws.com/AWSServiceRoleForRealUserMonitoring"
     ]
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":[
        "cognito-identity.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/RUM-Monitor*"
     ]
    },
    {
     "Action":[
      "cloudwatch:GetMetricData",
      "cloudwatch:GetMetricStatistics",
      "cloudwatch:ListMetrics"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "cloudwatch:DescribeAlarms"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:cloudwatch:*:*:alarm:*"
    },
    {
     "Action":[
      "cognito-identity:CreateIdentityPool",
      "cognito-identity:ListIdentityPools",
      "cognito-identity:DescribeIdentityPool",
      "cognito-identity:GetIdentityPoolRoles",
      "cognito-identity:SetIdentityPoolRoles"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:cognito-identity:*:*:identitypool/*"
    },
    {
     "Action":[
      "logs:CreateLogGroup",
      "logs:DeleteLogGroup",
      "logs:PutRetentionPolicy",
      "logs:CreateLogStream"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:logs:*:*:log-group:*RUMService*"
    },
    {
     "Action":[
      "logs:CreateLogDelivery",
      "logs:GetLogDelivery",
      "logs:UpdateLogDelivery",
      "logs:DeleteLogDelivery",
      "logs:ListLogDeliveries",
      "logs:DescribeResourcePolicies"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "logs:DescribeLogGroups"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:logs:*:*:log-group::log-stream:*"
    },
    {
     "Action":[
      "synthetics:describeCanaries",
      "synthetics:describeCanariesLastRun"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:synthetics:*:*:canary:*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-11-29T15:46:12+00:00"
 },
 "AmazonCloudWatchRUMReadOnlyAccess":{
  "CreateDate":"2021-11-29T15:43:47+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "rum:GetAppMonitor",
      "rum:GetAppMonitorData",
      "rum:ListAppMonitors"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-11-29T15:43:47+00:00"
 },
 "AmazonCloudWatchRUMServiceRolePolicy":{
  "CreateDate":"2021-11-17T23:17:23+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "xray:PutTraceSegments"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-11-17T23:17:23+00:00"
 },
 "AmazonCodeGuruProfilerAgentAccess":{
  "CreateDate":"2021-02-05T22:11:56+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "codeguru-profiler:ConfigureAgent",
      "codeguru-profiler:CreateProfilingGroup",
      "codeguru-profiler:PostAgentProfile"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:codeguru-profiler:*:*:profilingGroup/*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-05-05T18:11:03+00:00"
 },
 "AmazonCodeGuruProfilerFullAccess":{
  "CreateDate":"2019-12-03T10:13:27+00:00",
  "DefaultVersionId":"v4",
  "Document":{
   "Statement":[
    {
     "Action":[
      "codeguru-profiler:*",
      "iam:ListRoles",
      "iam:ListUsers",
      "sns:ListTopics",
      "codeguru:*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "iam:CreateServiceLinkedRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":"codeguru-profiler.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/*AWSServiceRoleForCodeGuruProfiler*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-07-15T03:23:08+00:00"
 },
 "AmazonCodeGuruProfilerReadOnlyAccess":{
  "CreateDate":"2019-12-03T10:30:15+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "codeguru:Get*",
      "codeguru-profiler:BatchGet*",
      "codeguru-profiler:Describe*",
      "codeguru-profiler:Get*",
      "codeguru-profiler:List*",
      "iam:ListRoles",
      "iam:ListUsers"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-06-27T23:52:52+00:00"
 },
 "AmazonCodeGuruReviewerFullAccess":{
  "CreateDate":"2019-12-03T08:33:47+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "codeguru-reviewer:*",
      "codeguru:*"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AmazonCodeGuruReviewerFullAccess"
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringLike":{
       "iam:AWSServiceName":"codeguru-reviewer.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/aws-service-role/codeguru-reviewer.amazonaws.com/AWSServiceRoleForAmazonCodeGuruReviewer",
     "Sid":"AmazonCodeGuruReviewerSLRCreation"
    },
    {
     "Action":[
      "iam:DeleteServiceLinkedRole",
      "iam:GetServiceLinkedRoleDeletionStatus"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/aws-service-role/codeguru-reviewer.amazonaws.com/AWSServiceRoleForAmazonCodeGuruReviewer",
     "Sid":"AmazonCodeGuruReviewerSLRDeletion"
    },
    {
     "Action":[
      "codecommit:ListRepositories"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CodeCommitAccess"
    },
    {
     "Action":[
      "codecommit:TagResource",
      "codecommit:UntagResource"
     ],
     "Condition":{
      "ForAllValues:StringEquals":{
       "aws:TagKeys":"codeguru-reviewer"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CodeCommitTagManagement"
    },
    {
     "Action":[
      "codestar-connections:TagResource",
      "codestar-connections:UntagResource",
      "codestar-connections:ListTagsForResource"
     ],
     "Condition":{
      "ForAllValues:StringEquals":{
       "aws:TagKeys":"codeguru-reviewer"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CodeConnectTagManagement"
    },
    {
     "Action":[
      "codestar-connections:UseConnection",
      "codestar-connections:ListConnections",
      "codestar-connections:PassConnection"
     ],
     "Condition":{
      "ForAllValues:StringEquals":{
       "codestar-connections:ProviderAction":[
        "ListRepositories",
        "ListOwners"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CodeConnectManagedRules"
    },
    {
     "Action":[
      "events:PutRule",
      "events:PutTargets",
      "events:DeleteRule",
      "events:RemoveTargets"
     ],
     "Condition":{
      "StringEquals":{
       "events:ManagedBy":"codeguru-reviewer.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CloudWatchEventsManagedRules"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-08-29T04:16:08+00:00"
 },
 "AmazonCodeGuruReviewerReadOnlyAccess":{
  "CreateDate":"2019-12-03T08:48:24+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "codeguru:Get*",
      "codeguru-reviewer:List*",
      "codeguru-reviewer:Describe*",
      "codeguru-reviewer:Get*"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AmazonCodeGuruReviewerReadOnlyAccess"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-08-29T04:15:32+00:00"
 },
 "AmazonCodeGuruReviewerServiceRolePolicy":{
  "CreateDate":"2019-12-03T05:31:12+00:00",
  "DefaultVersionId":"v4",
  "Document":{
   "Statement":[
    {
     "Action":[
      "codecommit:GetRepository",
      "codecommit:GetBranch",
      "codecommit:DescribePullRequestEvents",
      "codecommit:GetCommentsForPullRequest",
      "codecommit:GetDifferences",
      "codecommit:GetPullRequest",
      "codecommit:ListPullRequests",
      "codecommit:PostCommentForPullRequest",
      "codecommit:GitPull",
      "codecommit:UntagResource"
     ],
     "Condition":{
      "StringLike":{
       "aws:ResourceTag/codeguru-reviewer":"enabled"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AccessCodeGuruReviewerEnabledRepositories"
    },
    {
     "Action":[
      "codestar-connections:UseConnection"
     ],
     "Condition":{
      "ForAllValues:StringEquals":{
       "codestar-connections:ProviderAction":[
        "ListBranches",
        "GetBranch",
        "ListRepositories",
        "ListOwners",
        "ListPullRequests",
        "GetPullRequest",
        "ListPullRequestComments",
        "ListPullRequestCommits",
        "ListCommitFiles",
        "ListBranchCommits",
        "CreatePullRequestDiffComment",
        "GitPull"
       ]
      },
      "Null":{
       "aws:ResourceTag/codeguru-reviewer":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AccessCodeGuruReviewerEnabledConnections"
    },
    {
     "Action":[
      "events:DeleteRule",
      "events:RemoveTargets"
     ],
     "Condition":{
      "StringEquals":{
       "events:ManagedBy":"codeguru-reviewer.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CloudWatchEventsResourceCleanup"
    },
    {
     "Action":[
      "s3:GetObject"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::codeguru-reviewer-*",
      "arn:aws:s3:::codeguru-reviewer-*/*"
     ],
     "Sid":"AllowGuruS3GetObject"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-11-27T15:09:46+00:00"
 },
 "AmazonCognitoDeveloperAuthenticatedIdentities":{
  "CreateDate":"2015-03-24T17:22:23+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cognito-identity:GetOpenIdTokenForDeveloperIdentity",
      "cognito-identity:LookupDeveloperIdentity",
      "cognito-identity:MergeDeveloperIdentities",
      "cognito-identity:UnlinkDeveloperIdentity"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2015-03-24T17:22:23+00:00"
 },
 "AmazonCognitoIdpEmailServiceRolePolicy":{
  "CreateDate":"2019-03-21T21:32:25+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ses:SendEmail",
      "ses:SendRawEmail"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ses:List*"
     ],
     "Effect":"Deny",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-03-21T21:32:25+00:00"
 },
 "AmazonCognitoIdpServiceRolePolicy":{
  "CreateDate":"2020-06-26T22:30:20+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cognito-idp:Describe*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-06-26T22:30:20+00:00"
 },
 "AmazonCognitoPowerUser":{
  "CreateDate":"2015-03-24T17:14:56+00:00",
  "DefaultVersionId":"v6",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cognito-identity:*",
      "cognito-idp:*",
      "cognito-sync:*",
      "iam:ListRoles",
      "iam:ListOpenIdConnectProviders",
      "iam:GetRole",
      "iam:ListSAMLProviders",
      "iam:GetSAMLProvider",
      "kinesis:ListStreams",
      "lambda:GetPolicy",
      "lambda:ListFunctions",
      "sns:GetSMSSandboxAccountStatus",
      "sns:ListPlatformApplications",
      "ses:ListIdentities",
      "ses:GetIdentityVerificationAttributes",
      "mobiletargeting:GetApps",
      "acm:ListCertificates"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":[
        "cognito-idp.amazonaws.com",
        "email.cognito-idp.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "iam:DeleteServiceLinkedRole",
      "iam:GetServiceLinkedRoleDeletionStatus"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/aws-service-role/cognito-idp.amazonaws.com/AWSServiceRoleForAmazonCognitoIdp*",
      "arn:aws:iam::*:role/aws-service-role/email.cognito-idp.amazonaws.com/AWSServiceRoleForAmazonCognitoIdpEmail*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-06-01T17:33:32+00:00"
 },
 "AmazonCognitoReadOnly":{
  "CreateDate":"2015-03-24T17:06:46+00:00",
  "DefaultVersionId":"v4",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cognito-identity:Describe*",
      "cognito-identity:Get*",
      "cognito-identity:List*",
      "cognito-idp:Describe*",
      "cognito-idp:AdminGet*",
      "cognito-idp:AdminList*",
      "cognito-idp:List*",
      "cognito-idp:Get*",
      "cognito-sync:Describe*",
      "cognito-sync:Get*",
      "cognito-sync:List*",
      "iam:ListOpenIdConnectProviders",
      "iam:ListRoles",
      "sns:ListPlatformApplications"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-08-01T19:21:04+00:00"
 },
 "AmazonConnectCampaignsServiceLinkedRolePolicy":{
  "CreateDate":"2021-09-23T20:54:26+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "connect-campaigns:ListCampaigns"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-09-23T20:54:26+00:00"
 },
 "AmazonConnectReadOnlyAccess":{
  "CreateDate":"2018-10-17T21:00:44+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "connect:Get*",
      "connect:Describe*",
      "connect:List*",
      "ds:DescribeDirectories"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"connect:GetFederationTokens",
     "Effect":"Deny",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-11-06T22:10:18+00:00"
 },
 "AmazonConnectServiceLinkedRolePolicy":{
  "CreateDate":"2018-09-07T00:21:43+00:00",
  "DefaultVersionId":"v6",
  "Document":{
   "Statement":[
    {
     "Action":[
      "connect:*"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "iam:DeleteRole"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/aws-service-role/connect.amazonaws.com/AWSServiceRoleForAmazonConnect_*"
    },
    {
     "Action":[
      "s3:GetObject",
      "s3:GetObjectAcl",
      "s3:PutObject",
      "s3:PutObjectAcl",
      "s3:DeleteObject"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::amazon-connect-*/*"
     ]
    },
    {
     "Action":[
      "s3:GetBucketLocation",
      "s3:GetBucketAcl"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::amazon-connect-*"
     ]
    },
    {
     "Action":[
      "logs:CreateLogStream",
      "logs:DescribeLogStreams",
      "logs:PutLogEvents"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:logs:*:*:log-group:/aws/connect/*:*"
     ]
    },
    {
     "Action":[
      "lex:ListBots",
      "lex:ListBotAliases"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "profile:SearchProfiles",
      "profile:CreateProfile",
      "profile:UpdateProfile",
      "profile:AddProfileKey"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:profile:*:*:domains/amazon-connect-*"
    },
    {
     "Action":[
      "profile:ListProfileObjects"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:profile:*:*:domains/amazon-connect-*/object-types/CTR",
      "arn:aws:profile:*:*:domains/amazon-connect-*/object-types/_asset"
     ]
    },
    {
     "Action":[
      "profile:ListAccountIntegrations"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"cloudwatch:PutMetricData",
     "Condition":{
      "StringEquals":{
       "cloudwatch:namespace":"AWS/Connect"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-12-09T22:12:26+00:00"
 },
 "AmazonConnectVoiceIDFullAccess":{
  "CreateDate":"2021-09-26T19:04:10+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":"voiceid:*",
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-09-26T19:04:10+00:00"
 },
 "AmazonConnect_FullAccess":{
  "CreateDate":"2020-11-20T19:54:21+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "connect:*",
      "ds:CreateAlias",
      "ds:AuthorizeApplication",
      "ds:CreateIdentityPoolDirectory",
      "ds:DeleteDirectory",
      "ds:DescribeDirectories",
      "ds:UnauthorizeApplication",
      "firehose:DescribeDeliveryStream",
      "firehose:ListDeliveryStreams",
      "kinesis:DescribeStream",
      "kinesis:ListStreams",
      "kms:DescribeKey",
      "kms:ListAliases",
      "lex:GetBots",
      "lex:ListBots",
      "lex:ListBotAliases",
      "logs:CreateLogGroup",
      "s3:GetBucketLocation",
      "s3:ListAllMyBuckets",
      "lambda:ListFunctions",
      "ds:CheckAlias",
      "profile:ListAccountIntegrations",
      "profile:GetDomain",
      "profile:ListDomains",
      "profile:GetProfileObjectType",
      "profile:ListProfileObjectTypeTemplates"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "profile:AddProfileKey",
      "profile:CreateDomain",
      "profile:CreateProfile",
      "profile:DeleteDomain",
      "profile:DeleteIntegration",
      "profile:DeleteProfile",
      "profile:DeleteProfileKey",
      "profile:DeleteProfileObject",
      "profile:DeleteProfileObjectType",
      "profile:GetIntegration",
      "profile:GetMatches",
      "profile:GetProfileObjectType",
      "profile:ListIntegrations",
      "profile:ListProfileObjects",
      "profile:ListProfileObjectTypes",
      "profile:ListTagsForResource",
      "profile:MergeProfiles",
      "profile:PutIntegration",
      "profile:PutProfileObject",
      "profile:PutProfileObjectType",
      "profile:SearchProfiles",
      "profile:TagResource",
      "profile:UntagResource",
      "profile:UpdateDomain",
      "profile:UpdateProfile"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:profile:*:*:domains/amazon-connect-*"
    },
    {
     "Action":[
      "s3:CreateBucket",
      "s3:GetBucketAcl"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::amazon-connect-*"
    },
    {
     "Action":[
      "servicequotas:GetServiceQuota"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:servicequotas:*:*:connect/*"
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":"connect.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"iam:DeleteServiceLinkedRole",
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/aws-service-role/connect.amazonaws.com/AWSServiceRoleForAmazonConnect*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-11-23T22:05:12+00:00"
 },
 "AmazonDMSCloudWatchLogsRole":{
  "CreateDate":"2016-01-07T23:44:53+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "logs:DescribeLogGroups"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"AllowDescribeOnAllLogGroups"
    },
    {
     "Action":[
      "logs:DescribeLogStreams"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:logs:*:*:log-group:dms-tasks-*"
     ],
     "Sid":"AllowDescribeOfAllLogStreamsOnDmsTasksLogGroup"
    },
    {
     "Action":[
      "logs:CreateLogGroup"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:logs:*:*:log-group:dms-tasks-*"
     ],
     "Sid":"AllowCreationOfDmsTasksLogGroups"
    },
    {
     "Action":[
      "logs:CreateLogStream"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:logs:*:*:log-group:dms-tasks-*:log-stream:dms-task-*"
     ],
     "Sid":"AllowCreationOfDmsTaskLogStream"
    },
    {
     "Action":[
      "logs:PutLogEvents"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:logs:*:*:log-group:dms-tasks-*:log-stream:dms-task-*"
     ],
     "Sid":"AllowUploadOfLogEventsToDmsTaskLogStream"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2016-01-07T23:44:53+00:00"
 },
 "AmazonDMSRedshiftS3Role":{
  "CreateDate":"2016-04-20T17:05:56+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "s3:CreateBucket",
      "s3:ListBucket",
      "s3:DeleteBucket",
      "s3:GetBucketLocation",
      "s3:GetObject",
      "s3:PutObject",
      "s3:DeleteObject",
      "s3:GetObjectVersion",
      "s3:GetBucketPolicy",
      "s3:PutBucketPolicy",
      "s3:GetBucketAcl",
      "s3:PutBucketVersioning",
      "s3:GetBucketVersioning",
      "s3:PutLifecycleConfiguration",
      "s3:GetLifecycleConfiguration",
      "s3:DeleteBucketPolicy"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::dms-*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-07-08T18:19:14+00:00"
 },
 "AmazonDMSVPCManagementRole":{
  "CreateDate":"2015-11-18T16:33:19+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:CreateNetworkInterface",
      "ec2:DescribeAvailabilityZones",
      "ec2:DescribeInternetGateways",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeSubnets",
      "ec2:DescribeVpcs",
      "ec2:DeleteNetworkInterface",
      "ec2:ModifyNetworkInterfaceAttribute"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2016-05-23T16:29:57+00:00"
 },
 "AmazonDRSVPCManagement":{
  "CreateDate":"2015-09-02T00:09:20+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:AuthorizeSecurityGroupIngress",
      "ec2:CreateNetworkInterface",
      "ec2:CreateSecurityGroup",
      "ec2:DescribeAvailabilityZones",
      "ec2:DescribeInternetGateways",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeSubnets",
      "ec2:DescribeVpcAttribute",
      "ec2:DescribeVpcs",
      "ec2:DeleteNetworkInterface",
      "ec2:DeleteSecurityGroup",
      "ec2:ModifyNetworkInterfaceAttribute",
      "ec2:RevokeSecurityGroupIngress"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2015-09-02T00:09:20+00:00"
 },
 "AmazonDetectiveFullAccess":{
  "CreateDate":"2020-04-30T17:57:15+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "detective:*",
      "organizations:DescribeOrganization",
      "organizations:ListAccounts"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "guardduty:ArchiveFindings"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:guardduty:*:*:detector/*"
    },
    {
     "Action":[
      "guardduty:ListDetectors"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-10-21T22:07:28+00:00"
 },
 "AmazonDetectiveServiceLinkedRolePolicy":{
  "CreateDate":"2021-11-18T19:47:32+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "organizations:DescribeAccount",
      "organizations:ListAccounts"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-11-18T19:47:32+00:00"
 },
 "AmazonDevOpsGuruConsoleFullAccess":{
  "CreateDate":"2021-12-17T18:43:09+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "devops-guru:*"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"DevOpsGuruFullAccess"
    },
    {
     "Action":[
      "cloudformation:DescribeStacks",
      "cloudformation:ListStacks"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CloudFormationListStacksAccess"
    },
    {
     "Action":[
      "cloudwatch:GetMetricData"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CloudWatchGetMetricDataAccess"
    },
    {
     "Action":[
      "sns:ListTopics"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"SnsListTopicsAccess"
    },
    {
     "Action":[
      "sns:CreateTopic",
      "sns:GetTopicAttributes",
      "sns:SetTopicAttributes",
      "sns:Publish"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:sns:*:*:DevOps-Guru-*",
     "Sid":"SnsTopicOperations"
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringLike":{
       "iam:AWSServiceName":"devops-guru.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/aws-service-role/devops-guru.amazonaws.com/AWSServiceRoleForDevOpsGuru",
     "Sid":"DevOpsGuruSlrCreation"
    },
    {
     "Action":[
      "iam:DeleteServiceLinkedRole",
      "iam:GetServiceLinkedRoleDeletionStatus"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/aws-service-role/devops-guru.amazonaws.com/AWSServiceRoleForDevOpsGuru",
     "Sid":"DevOpsGuruSlrDeletion"
    },
    {
     "Action":[
      "rds:DescribeDBInstances"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"RDSDescribeDBInstancesAccess"
    },
    {
     "Action":[
      "pi:GetResourceMetrics",
      "pi:DescribeDimensionKeys"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"PerformanceInsightsMetricsDataAccess"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-12-17T18:43:09+00:00"
 },
 "AmazonDevOpsGuruFullAccess":{
  "CreateDate":"2020-12-01T16:38:12+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "devops-guru:*"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"DevOpsGuruFullAccess"
    },
    {
     "Action":[
      "cloudformation:DescribeStacks",
      "cloudformation:ListStacks"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CloudFormationListStacksAccess"
    },
    {
     "Action":[
      "cloudwatch:GetMetricData"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CloudWatchGetMetricDataAccess"
    },
    {
     "Action":[
      "sns:ListTopics"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"SnsListTopicsAccess"
    },
    {
     "Action":[
      "sns:CreateTopic",
      "sns:GetTopicAttributes",
      "sns:SetTopicAttributes",
      "sns:Publish"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:sns:*:*:DevOps-Guru-*",
     "Sid":"SnsTopicOperations"
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringLike":{
       "iam:AWSServiceName":"devops-guru.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/aws-service-role/devops-guru.amazonaws.com/AWSServiceRoleForDevOpsGuru",
     "Sid":"DevOpsGuruSlrCreation"
    },
    {
     "Action":[
      "iam:DeleteServiceLinkedRole",
      "iam:GetServiceLinkedRoleDeletionStatus"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/aws-service-role/devops-guru.amazonaws.com/AWSServiceRoleForDevOpsGuru",
     "Sid":"DevOpsGuruSlrDeletion"
    },
    {
     "Action":[
      "rds:DescribeDBInstances"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"RDSDescribeDBInstancesAccess"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-11-26T20:39:13+00:00"
 },
 "AmazonDevOpsGuruOrganizationsAccess":{
  "CreateDate":"2021-11-15T23:50:52+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "devops-guru:DescribeOrganizationHealth",
      "devops-guru:DescribeOrganizationResourceCollectionHealth",
      "devops-guru:DescribeOrganizationOverview",
      "devops-guru:ListOrganizationInsights",
      "devops-guru:SearchOrganizationInsights"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"DevOpsGuruOrganizationsAccess"
    },
    {
     "Action":[
      "organizations:DescribeAccount",
      "organizations:DescribeOrganization",
      "organizations:ListAWSServiceAccessForOrganization",
      "organizations:ListAccounts",
      "organizations:ListChildren",
      "organizations:ListOrganizationalUnitsForParent",
      "organizations:ListRoots"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:organizations::*:",
     "Sid":"OrganizationsDataAccess"
    },
    {
     "Action":[
      "organizations:DeregisterDelegatedAdministrator",
      "organizations:RegisterDelegatedAdministrator",
      "organizations:ListDelegatedAdministrators",
      "organizations:EnableAWSServiceAccess",
      "organizations:DisableAWSServiceAccess"
     ],
     "Condition":{
      "StringEquals":{
       "organizations:ServicePrincipal":[
        "devops-guru.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"OrganizationsAdminDataAccess"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-11-15T23:50:52+00:00"
 },
 "AmazonDevOpsGuruReadOnlyAccess":{
  "CreateDate":"2020-12-01T16:34:40+00:00",
  "DefaultVersionId":"v5",
  "Document":{
   "Statement":[
    {
     "Action":[
      "devops-guru:DescribeAccountHealth",
      "devops-guru:DescribeAccountOverview",
      "devops-guru:DescribeAnomaly",
      "devops-guru:DescribeEventSourcesConfig",
      "devops-guru:DescribeFeedback",
      "devops-guru:DescribeInsight",
      "devops-guru:DescribeResourceCollectionHealth",
      "devops-guru:DescribeServiceIntegration",
      "devops-guru:GetCostEstimation",
      "devops-guru:GetResourceCollection",
      "devops-guru:ListAnomaliesForInsight",
      "devops-guru:ListEvents",
      "devops-guru:ListInsights",
      "devops-guru:ListNotificationChannels",
      "devops-guru:ListRecommendations",
      "devops-guru:SearchInsights",
      "devops-guru:StartCostEstimation"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"DevOpsGuruReadOnlyAccess"
    },
    {
     "Action":[
      "cloudformation:DescribeStacks",
      "cloudformation:ListStacks"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CloudFormationListStacksAccess"
    },
    {
     "Action":[
      "iam:GetRole"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/aws-service-role/devops-guru.amazonaws.com/AWSServiceRoleForDevOpsGuru"
    },
    {
     "Action":[
      "cloudwatch:GetMetricData"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CloudWatchGetMetricDataAccess"
    },
    {
     "Action":[
      "rds:DescribeDBInstances"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"RDSDescribeDBInstancesAccess"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-03-04T02:37:19+00:00"
 },
 "AmazonDevOpsGuruServiceRolePolicy":{
  "CreateDate":"2020-12-01T10:24:42+00:00",
  "DefaultVersionId":"v6",
  "Document":{
   "Statement":[
    {
     "Action":[
      "autoscaling:DescribeAutoScalingGroups",
      "cloudtrail:LookupEvents",
      "cloudwatch:GetMetricData",
      "cloudwatch:ListMetrics",
      "cloudwatch:DescribeAnomalyDetectors",
      "cloudwatch:DescribeAlarms",
      "cloudwatch:ListDashboards",
      "cloudwatch:GetDashboard",
      "cloudformation:GetTemplate",
      "cloudformation:ListStacks",
      "cloudformation:ListStackResources",
      "cloudformation:DescribeStacks",
      "cloudformation:ListImports",
      "codedeploy:BatchGetDeployments",
      "codedeploy:GetDeploymentGroup",
      "codedeploy:ListDeployments",
      "config:DescribeConfigurationRecorderStatus",
      "config:GetResourceConfigHistory",
      "events:ListRuleNamesByTarget",
      "xray:GetServiceGraph",
      "organizations:ListRoots",
      "organizations:ListChildren",
      "organizations:ListDelegatedAdministrators",
      "pi:GetResourceMetrics",
      "tag:GetResources",
      "lambda:GetFunction",
      "lambda:GetFunctionConcurrency",
      "lambda:GetAccountSettings",
      "lambda:ListProvisionedConcurrencyConfigs",
      "lambda:ListAliases",
      "lambda:ListEventSourceMappings",
      "lambda:GetPolicy",
      "ec2:DescribeSubnets",
      "application-autoscaling:DescribeScalableTargets",
      "application-autoscaling:DescribeScalingPolicies",
      "sqs:GetQueueAttributes",
      "kinesis:DescribeStream",
      "kinesis:DescribeLimits",
      "dynamodb:DescribeTable",
      "dynamodb:DescribeLimits",
      "dynamodb:DescribeContinuousBackups",
      "dynamodb:DescribeStream",
      "dynamodb:ListStreams",
      "elasticloadbalancing:DescribeLoadBalancers",
      "elasticloadbalancing:DescribeLoadBalancerAttributes",
      "rds:DescribeDBInstances",
      "rds:DescribeDBClusters",
      "rds:DescribeOptionGroups",
      "rds:DescribeDBClusterParameters",
      "rds:DescribeDBInstanceAutomatedBackups",
      "rds:DescribeAccountAttributes"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "events:PutTargets",
      "events:PutRule"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:events:*:*:rule/DevOps-Guru-managed-*",
     "Sid":"AllowPutTargetsOnASpecificRule"
    },
    {
     "Action":[
      "ssm:CreateOpsItem"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AllowCreateOpsItem"
    },
    {
     "Action":[
      "ssm:AddTagsToResource"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:ssm:*:*:opsitem/*",
     "Sid":"AllowAddTagsToOpsItem"
    },
    {
     "Action":[
      "ssm:GetOpsItem",
      "ssm:UpdateOpsItem"
     ],
     "Condition":{
      "StringEquals":{
       "aws:ResourceTag/DevOps-GuruInsightSsmOpsItemRelated":"true"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AllowAccessOpsItem"
    },
    {
     "Action":"events:PutRule",
     "Effect":"Allow",
     "Resource":"arn:aws:events:*:*:rule/DevOpsGuruManagedRule*",
     "Sid":"AllowCreateManagedRule"
    },
    {
     "Action":[
      "events:DescribeRule",
      "events:ListTargetsByRule"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:events:*:*:rule/DevOpsGuruManagedRule*",
     "Sid":"AllowAccessManagedRule"
    },
    {
     "Action":[
      "events:DeleteRule",
      "events:EnableRule",
      "events:DisableRule",
      "events:PutTargets",
      "events:RemoveTargets"
     ],
     "Condition":{
      "StringEquals":{
       "events:ManagedBy":"devops-guru.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:events:*:*:rule/DevOpsGuruManagedRule*",
     "Sid":"AllowOtherOperationsOnManagedRule"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-02-07T19:30:10+00:00"
 },
 "AmazonDocDBConsoleFullAccess":{
  "CreateDate":"2019-01-09T20:37:28+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "rds:AddRoleToDBCluster",
      "rds:AddSourceIdentifierToSubscription",
      "rds:AddTagsToResource",
      "rds:ApplyPendingMaintenanceAction",
      "rds:CopyDBClusterParameterGroup",
      "rds:CopyDBClusterSnapshot",
      "rds:CopyDBParameterGroup",
      "rds:CreateDBCluster",
      "rds:CreateDBClusterParameterGroup",
      "rds:CreateDBClusterSnapshot",
      "rds:CreateDBInstance",
      "rds:CreateDBParameterGroup",
      "rds:CreateDBSubnetGroup",
      "rds:CreateEventSubscription",
      "rds:DeleteDBCluster",
      "rds:DeleteDBClusterParameterGroup",
      "rds:DeleteDBClusterSnapshot",
      "rds:DeleteDBInstance",
      "rds:DeleteDBParameterGroup",
      "rds:DeleteDBSubnetGroup",
      "rds:DeleteEventSubscription",
      "rds:DescribeAccountAttributes",
      "rds:DescribeCertificates",
      "rds:DescribeDBClusterParameterGroups",
      "rds:DescribeDBClusterParameters",
      "rds:DescribeDBClusterSnapshotAttributes",
      "rds:DescribeDBClusterSnapshots",
      "rds:DescribeDBClusters",
      "rds:DescribeDBEngineVersions",
      "rds:DescribeDBInstances",
      "rds:DescribeDBLogFiles",
      "rds:DescribeDBParameterGroups",
      "rds:DescribeDBParameters",
      "rds:DescribeDBSecurityGroups",
      "rds:DescribeDBSubnetGroups",
      "rds:DescribeEngineDefaultClusterParameters",
      "rds:DescribeEngineDefaultParameters",
      "rds:DescribeEventCategories",
      "rds:DescribeEventSubscriptions",
      "rds:DescribeEvents",
      "rds:DescribeOptionGroups",
      "rds:DescribeOrderableDBInstanceOptions",
      "rds:DescribePendingMaintenanceActions",
      "rds:DescribeValidDBInstanceModifications",
      "rds:DownloadDBLogFilePortion",
      "rds:FailoverDBCluster",
      "rds:ListTagsForResource",
      "rds:ModifyDBCluster",
      "rds:ModifyDBClusterParameterGroup",
      "rds:ModifyDBClusterSnapshotAttribute",
      "rds:ModifyDBInstance",
      "rds:ModifyDBParameterGroup",
      "rds:ModifyDBSubnetGroup",
      "rds:ModifyEventSubscription",
      "rds:PromoteReadReplicaDBCluster",
      "rds:RebootDBInstance",
      "rds:RemoveRoleFromDBCluster",
      "rds:RemoveSourceIdentifierFromSubscription",
      "rds:RemoveTagsFromResource",
      "rds:ResetDBClusterParameterGroup",
      "rds:ResetDBParameterGroup",
      "rds:RestoreDBClusterFromSnapshot",
      "rds:RestoreDBClusterToPointInTime"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "iam:GetRole",
      "cloudwatch:GetMetricData",
      "cloudwatch:GetMetricStatistics",
      "cloudwatch:ListMetrics",
      "ec2:AllocateAddress",
      "ec2:AssignIpv6Addresses",
      "ec2:AssignPrivateIpAddresses",
      "ec2:AssociateAddress",
      "ec2:AssociateRouteTable",
      "ec2:AssociateSubnetCidrBlock",
      "ec2:AssociateVpcCidrBlock",
      "ec2:AttachInternetGateway",
      "ec2:AttachNetworkInterface",
      "ec2:CreateCustomerGateway",
      "ec2:CreateDefaultSubnet",
      "ec2:CreateDefaultVpc",
      "ec2:CreateInternetGateway",
      "ec2:CreateNatGateway",
      "ec2:CreateNetworkInterface",
      "ec2:CreateRoute",
      "ec2:CreateRouteTable",
      "ec2:CreateSecurityGroup",
      "ec2:CreateSubnet",
      "ec2:CreateVpc",
      "ec2:CreateVpcEndpoint",
      "ec2:DescribeAccountAttributes",
      "ec2:DescribeAddresses",
      "ec2:DescribeAvailabilityZones",
      "ec2:DescribeCustomerGateways",
      "ec2:DescribeInstances",
      "ec2:DescribeNatGateways",
      "ec2:DescribeNetworkInterfaces",
      "ec2:DescribePrefixLists",
      "ec2:DescribeRouteTables",
      "ec2:DescribeSecurityGroupReferences",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeSubnets",
      "ec2:DescribeVpcAttribute",
      "ec2:DescribeVpcEndpoints",
      "ec2:DescribeVpcs",
      "ec2:ModifyNetworkInterfaceAttribute",
      "ec2:ModifySubnetAttribute",
      "ec2:ModifyVpcAttribute",
      "ec2:ModifyVpcEndpoint",
      "kms:DescribeKey",
      "kms:ListAliases",
      "kms:ListKeyPolicies",
      "kms:ListKeys",
      "kms:ListRetirableGrants",
      "logs:DescribeLogStreams",
      "logs:GetLogEvents",
      "sns:ListSubscriptions",
      "sns:ListTopics",
      "sns:Publish"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringLike":{
       "iam:AWSServiceName":"rds.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/aws-service-role/rds.amazonaws.com/AWSServiceRoleForRDS"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-04-05T22:42:40+00:00"
 },
 "AmazonDocDBFullAccess":{
  "CreateDate":"2019-01-09T20:21:44+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "rds:AddRoleToDBCluster",
      "rds:AddSourceIdentifierToSubscription",
      "rds:AddTagsToResource",
      "rds:ApplyPendingMaintenanceAction",
      "rds:CopyDBClusterParameterGroup",
      "rds:CopyDBClusterSnapshot",
      "rds:CopyDBParameterGroup",
      "rds:CreateDBCluster",
      "rds:CreateDBClusterParameterGroup",
      "rds:CreateDBClusterSnapshot",
      "rds:CreateDBInstance",
      "rds:CreateDBParameterGroup",
      "rds:CreateDBSubnetGroup",
      "rds:CreateEventSubscription",
      "rds:DeleteDBCluster",
      "rds:DeleteDBClusterParameterGroup",
      "rds:DeleteDBClusterSnapshot",
      "rds:DeleteDBInstance",
      "rds:DeleteDBParameterGroup",
      "rds:DeleteDBSubnetGroup",
      "rds:DeleteEventSubscription",
      "rds:DescribeAccountAttributes",
      "rds:DescribeCertificates",
      "rds:DescribeDBClusterParameterGroups",
      "rds:DescribeDBClusterParameters",
      "rds:DescribeDBClusterSnapshotAttributes",
      "rds:DescribeDBClusterSnapshots",
      "rds:DescribeDBClusters",
      "rds:DescribeDBEngineVersions",
      "rds:DescribeDBInstances",
      "rds:DescribeDBLogFiles",
      "rds:DescribeDBParameterGroups",
      "rds:DescribeDBParameters",
      "rds:DescribeDBSecurityGroups",
      "rds:DescribeDBSubnetGroups",
      "rds:DescribeEngineDefaultClusterParameters",
      "rds:DescribeEngineDefaultParameters",
      "rds:DescribeEventCategories",
      "rds:DescribeEventSubscriptions",
      "rds:DescribeEvents",
      "rds:DescribeOptionGroups",
      "rds:DescribeOrderableDBInstanceOptions",
      "rds:DescribePendingMaintenanceActions",
      "rds:DescribeValidDBInstanceModifications",
      "rds:DownloadDBLogFilePortion",
      "rds:FailoverDBCluster",
      "rds:ListTagsForResource",
      "rds:ModifyDBCluster",
      "rds:ModifyDBClusterParameterGroup",
      "rds:ModifyDBClusterSnapshotAttribute",
      "rds:ModifyDBInstance",
      "rds:ModifyDBParameterGroup",
      "rds:ModifyDBSubnetGroup",
      "rds:ModifyEventSubscription",
      "rds:PromoteReadReplicaDBCluster",
      "rds:RebootDBInstance",
      "rds:RemoveRoleFromDBCluster",
      "rds:RemoveSourceIdentifierFromSubscription",
      "rds:RemoveTagsFromResource",
      "rds:ResetDBClusterParameterGroup",
      "rds:ResetDBParameterGroup",
      "rds:RestoreDBClusterFromSnapshot",
      "rds:RestoreDBClusterToPointInTime"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "cloudwatch:GetMetricStatistics",
      "cloudwatch:ListMetrics",
      "ec2:DescribeAccountAttributes",
      "ec2:DescribeAvailabilityZones",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeSubnets",
      "ec2:DescribeVpcAttribute",
      "ec2:DescribeVpcs",
      "kms:ListAliases",
      "kms:ListKeyPolicies",
      "kms:ListKeys",
      "kms:ListRetirableGrants",
      "logs:DescribeLogStreams",
      "logs:GetLogEvents",
      "sns:ListSubscriptions",
      "sns:ListTopics",
      "sns:Publish"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringLike":{
       "iam:AWSServiceName":"rds.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/aws-service-role/rds.amazonaws.com/AWSServiceRoleForRDS"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-01-09T20:21:44+00:00"
 },
 "AmazonDocDBReadOnlyAccess":{
  "CreateDate":"2019-01-09T20:30:28+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "rds:DescribeAccountAttributes",
      "rds:DescribeCertificates",
      "rds:DescribeDBClusterParameterGroups",
      "rds:DescribeDBClusterParameters",
      "rds:DescribeDBClusterSnapshotAttributes",
      "rds:DescribeDBClusterSnapshots",
      "rds:DescribeDBClusters",
      "rds:DescribeDBEngineVersions",
      "rds:DescribeDBInstances",
      "rds:DescribeDBLogFiles",
      "rds:DescribeDBParameterGroups",
      "rds:DescribeDBParameters",
      "rds:DescribeDBSubnetGroups",
      "rds:DescribeEventCategories",
      "rds:DescribeEventSubscriptions",
      "rds:DescribeEvents",
      "rds:DescribeOrderableDBInstanceOptions",
      "rds:DescribePendingMaintenanceActions",
      "rds:DownloadDBLogFilePortion",
      "rds:ListTagsForResource"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "cloudwatch:GetMetricStatistics",
      "cloudwatch:ListMetrics"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:DescribeAccountAttributes",
      "ec2:DescribeAvailabilityZones",
      "ec2:DescribeInternetGateways",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeSubnets",
      "ec2:DescribeVpcAttribute",
      "ec2:DescribeVpcs"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "kms:ListKeys",
      "kms:ListRetirableGrants",
      "kms:ListAliases",
      "kms:ListKeyPolicies"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "logs:DescribeLogStreams",
      "logs:GetLogEvents"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:logs:*:*:log-group:/aws/rds/*:log-stream:*",
      "arn:aws:logs:*:*:log-group:/aws/docdb/*:log-stream:*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-01-09T20:30:28+00:00"
 },
 "AmazonDynamoDBFullAccess":{
  "CreateDate":"2015-02-06T18:40:11+00:00",
  "DefaultVersionId":"v15",
  "Document":{
   "Statement":[
    {
     "Action":[
      "dynamodb:*",
      "dax:*",
      "application-autoscaling:DeleteScalingPolicy",
      "application-autoscaling:DeregisterScalableTarget",
      "application-autoscaling:DescribeScalableTargets",
      "application-autoscaling:DescribeScalingActivities",
      "application-autoscaling:DescribeScalingPolicies",
      "application-autoscaling:PutScalingPolicy",
      "application-autoscaling:RegisterScalableTarget",
      "cloudwatch:DeleteAlarms",
      "cloudwatch:DescribeAlarmHistory",
      "cloudwatch:DescribeAlarms",
      "cloudwatch:DescribeAlarmsForMetric",
      "cloudwatch:GetMetricStatistics",
      "cloudwatch:ListMetrics",
      "cloudwatch:PutMetricAlarm",
      "cloudwatch:GetMetricData",
      "datapipeline:ActivatePipeline",
      "datapipeline:CreatePipeline",
      "datapipeline:DeletePipeline",
      "datapipeline:DescribeObjects",
      "datapipeline:DescribePipelines",
      "datapipeline:GetPipelineDefinition",
      "datapipeline:ListPipelines",
      "datapipeline:PutPipelineDefinition",
      "datapipeline:QueryObjects",
      "ec2:DescribeVpcs",
      "ec2:DescribeSubnets",
      "ec2:DescribeSecurityGroups",
      "iam:GetRole",
      "iam:ListRoles",
      "kms:DescribeKey",
      "kms:ListAliases",
      "sns:CreateTopic",
      "sns:DeleteTopic",
      "sns:ListSubscriptions",
      "sns:ListSubscriptionsByTopic",
      "sns:ListTopics",
      "sns:Subscribe",
      "sns:Unsubscribe",
      "sns:SetTopicAttributes",
      "lambda:CreateFunction",
      "lambda:ListFunctions",
      "lambda:ListEventSourceMappings",
      "lambda:CreateEventSourceMapping",
      "lambda:DeleteEventSourceMapping",
      "lambda:GetFunctionConfiguration",
      "lambda:DeleteFunction",
      "resource-groups:ListGroups",
      "resource-groups:ListGroupResources",
      "resource-groups:GetGroup",
      "resource-groups:GetGroupQuery",
      "resource-groups:DeleteGroup",
      "resource-groups:CreateGroup",
      "tag:GetResources",
      "kinesis:ListStreams",
      "kinesis:DescribeStream",
      "kinesis:DescribeStreamSummary"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"cloudwatch:GetInsightRuleReport",
     "Effect":"Allow",
     "Resource":"arn:aws:cloudwatch:*:*:insight-rule/DynamoDBContributorInsights*"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringLike":{
       "iam:PassedToService":[
        "application-autoscaling.amazonaws.com",
        "application-autoscaling.amazonaws.com.cn",
        "dax.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "iam:CreateServiceLinkedRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":[
        "replication.dynamodb.amazonaws.com",
        "dax.amazonaws.com",
        "dynamodb.application-autoscaling.amazonaws.com",
        "contributorinsights.dynamodb.amazonaws.com",
        "kinesisreplication.dynamodb.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-01-29T17:38:30+00:00"
 },
 "AmazonDynamoDBFullAccesswithDataPipeline":{
  "CreateDate":"2015-02-06T18:40:14+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cloudwatch:DeleteAlarms",
      "cloudwatch:DescribeAlarmHistory",
      "cloudwatch:DescribeAlarms",
      "cloudwatch:DescribeAlarmsForMetric",
      "cloudwatch:GetMetricStatistics",
      "cloudwatch:ListMetrics",
      "cloudwatch:PutMetricAlarm",
      "dynamodb:*",
      "sns:CreateTopic",
      "sns:DeleteTopic",
      "sns:ListSubscriptions",
      "sns:ListSubscriptionsByTopic",
      "sns:ListTopics",
      "sns:Subscribe",
      "sns:Unsubscribe",
      "sns:SetTopicAttributes"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"DDBConsole"
    },
    {
     "Action":[
      "lambda:*",
      "iam:ListRoles"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"DDBConsoleTriggers"
    },
    {
     "Action":[
      "datapipeline:*",
      "iam:ListRoles"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"DDBConsoleImportExport"
    },
    {
     "Action":[
      "iam:GetRolePolicy",
      "iam:PassRole"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"IAMEDPRoles"
    },
    {
     "Action":[
      "ec2:CreateTags",
      "ec2:DescribeInstances",
      "ec2:RunInstances",
      "ec2:StartInstances",
      "ec2:StopInstances",
      "ec2:TerminateInstances",
      "elasticmapreduce:*",
      "datapipeline:*"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"EMR"
    },
    {
     "Action":[
      "s3:DeleteObject",
      "s3:Get*",
      "s3:List*",
      "s3:Put*"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"S3"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2015-11-12T02:17:42+00:00"
 },
 "AmazonDynamoDBReadOnlyAccess":{
  "CreateDate":"2015-02-06T18:40:12+00:00",
  "DefaultVersionId":"v13",
  "Document":{
   "Statement":[
    {
     "Action":[
      "application-autoscaling:DescribeScalableTargets",
      "application-autoscaling:DescribeScalingActivities",
      "application-autoscaling:DescribeScalingPolicies",
      "cloudwatch:DescribeAlarmHistory",
      "cloudwatch:DescribeAlarms",
      "cloudwatch:DescribeAlarmsForMetric",
      "cloudwatch:GetMetricStatistics",
      "cloudwatch:ListMetrics",
      "cloudwatch:GetMetricData",
      "datapipeline:DescribeObjects",
      "datapipeline:DescribePipelines",
      "datapipeline:GetPipelineDefinition",
      "datapipeline:ListPipelines",
      "datapipeline:QueryObjects",
      "dynamodb:BatchGetItem",
      "dynamodb:Describe*",
      "dynamodb:List*",
      "dynamodb:GetItem",
      "dynamodb:Query",
      "dynamodb:Scan",
      "dynamodb:PartiQLSelect",
      "dax:Describe*",
      "dax:List*",
      "dax:GetItem",
      "dax:BatchGetItem",
      "dax:Query",
      "dax:Scan",
      "ec2:DescribeVpcs",
      "ec2:DescribeSubnets",
      "ec2:DescribeSecurityGroups",
      "iam:GetRole",
      "iam:ListRoles",
      "kms:DescribeKey",
      "kms:ListAliases",
      "sns:ListSubscriptionsByTopic",
      "sns:ListTopics",
      "lambda:ListFunctions",
      "lambda:ListEventSourceMappings",
      "lambda:GetFunctionConfiguration",
      "resource-groups:ListGroups",
      "resource-groups:ListGroupResources",
      "resource-groups:GetGroup",
      "resource-groups:GetGroupQuery",
      "tag:GetResources",
      "kinesis:ListStreams",
      "kinesis:DescribeStream",
      "kinesis:DescribeStreamSummary"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"cloudwatch:GetInsightRuleReport",
     "Effect":"Allow",
     "Resource":"arn:aws:cloudwatch:*:*:insight-rule/DynamoDBContributorInsights*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-01-27T01:01:47+00:00"
 },
 "AmazonEBSCSIDriverPolicy":{
  "CreateDate":"2022-04-04T17:24:29+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:CreateSnapshot",
      "ec2:AttachVolume",
      "ec2:DetachVolume",
      "ec2:ModifyVolume",
      "ec2:DescribeAvailabilityZones",
      "ec2:DescribeInstances",
      "ec2:DescribeSnapshots",
      "ec2:DescribeTags",
      "ec2:DescribeVolumes",
      "ec2:DescribeVolumesModifications"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:CreateTags"
     ],
     "Condition":{
      "StringEquals":{
       "ec2:CreateAction":[
        "CreateVolume",
        "CreateSnapshot"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:volume/*",
      "arn:aws:ec2:*:*:snapshot/*"
     ]
    },
    {
     "Action":[
      "ec2:DeleteTags"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:volume/*",
      "arn:aws:ec2:*:*:snapshot/*"
     ]
    },
    {
     "Action":[
      "ec2:CreateVolume"
     ],
     "Condition":{
      "StringLike":{
       "aws:RequestTag/ebs.csi.aws.com/cluster":"true"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:CreateVolume"
     ],
     "Condition":{
      "StringLike":{
       "aws:RequestTag/CSIVolumeName":"*"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:CreateVolume"
     ],
     "Condition":{
      "StringLike":{
       "aws:RequestTag/kubernetes.io/cluster/*":"owned"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:DeleteVolume"
     ],
     "Condition":{
      "StringLike":{
       "ec2:ResourceTag/ebs.csi.aws.com/cluster":"true"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:DeleteVolume"
     ],
     "Condition":{
      "StringLike":{
       "ec2:ResourceTag/CSIVolumeName":"*"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:DeleteVolume"
     ],
     "Condition":{
      "StringLike":{
       "ec2:ResourceTag/kubernetes.io/cluster/*":"owned"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:DeleteSnapshot"
     ],
     "Condition":{
      "StringLike":{
       "ec2:ResourceTag/CSIVolumeSnapshotName":"*"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:DeleteSnapshot"
     ],
     "Condition":{
      "StringLike":{
       "ec2:ResourceTag/ebs.csi.aws.com/cluster":"true"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-04-04T17:24:29+00:00"
 },
 "AmazonEC2ContainerRegistryFullAccess":{
  "CreateDate":"2015-12-21T17:06:48+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ecr:*",
      "cloudtrail:LookupEvents"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "iam:CreateServiceLinkedRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":[
        "replication.ecr.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-12-05T00:04:19+00:00"
 },
 "AmazonEC2ContainerRegistryPowerUser":{
  "CreateDate":"2015-12-21T17:05:33+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ecr:GetAuthorizationToken",
      "ecr:BatchCheckLayerAvailability",
      "ecr:GetDownloadUrlForLayer",
      "ecr:GetRepositoryPolicy",
      "ecr:DescribeRepositories",
      "ecr:ListImages",
      "ecr:DescribeImages",
      "ecr:BatchGetImage",
      "ecr:GetLifecyclePolicy",
      "ecr:GetLifecyclePolicyPreview",
      "ecr:ListTagsForResource",
      "ecr:DescribeImageScanFindings",
      "ecr:InitiateLayerUpload",
      "ecr:UploadLayerPart",
      "ecr:CompleteLayerUpload",
      "ecr:PutImage"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-12-10T20:48:08+00:00"
 },
 "AmazonEC2ContainerRegistryReadOnly":{
  "CreateDate":"2015-12-21T17:04:15+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ecr:GetAuthorizationToken",
      "ecr:BatchCheckLayerAvailability",
      "ecr:GetDownloadUrlForLayer",
      "ecr:GetRepositoryPolicy",
      "ecr:DescribeRepositories",
      "ecr:ListImages",
      "ecr:DescribeImages",
      "ecr:BatchGetImage",
      "ecr:GetLifecyclePolicy",
      "ecr:GetLifecyclePolicyPreview",
      "ecr:ListTagsForResource",
      "ecr:DescribeImageScanFindings"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-12-10T20:56:32+00:00"
 },
 "AmazonEC2ContainerServiceAutoscaleRole":{
  "CreateDate":"2016-05-12T23:25:44+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ecs:DescribeServices",
      "ecs:UpdateService"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "cloudwatch:DescribeAlarms",
      "cloudwatch:PutMetricAlarm"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2018-02-05T19:15:15+00:00"
 },
 "AmazonEC2ContainerServiceEventsRole":{
  "CreateDate":"2017-05-30T16:51:35+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ecs:RunTask"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":"iam:PassRole",
     "Condition":{
      "StringLike":{
       "iam:PassedToService":"ecs-tasks.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2018-05-22T19:13:11+00:00"
 },
 "AmazonEC2ContainerServiceRole":{
  "CreateDate":"2015-04-09T16:14:19+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:AuthorizeSecurityGroupIngress",
      "ec2:Describe*",
      "elasticloadbalancing:DeregisterInstancesFromLoadBalancer",
      "elasticloadbalancing:DeregisterTargets",
      "elasticloadbalancing:Describe*",
      "elasticloadbalancing:RegisterInstancesWithLoadBalancer",
      "elasticloadbalancing:RegisterTargets"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2016-08-11T13:08:01+00:00"
 },
 "AmazonEC2ContainerServiceforEC2Role":{
  "CreateDate":"2015-03-19T18:45:18+00:00",
  "DefaultVersionId":"v6",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:DescribeTags",
      "ecs:CreateCluster",
      "ecs:DeregisterContainerInstance",
      "ecs:DiscoverPollEndpoint",
      "ecs:Poll",
      "ecs:RegisterContainerInstance",
      "ecs:StartTelemetrySession",
      "ecs:UpdateContainerInstancesState",
      "ecs:Submit*",
      "ecr:GetAuthorizationToken",
      "ecr:BatchCheckLayerAvailability",
      "ecr:GetDownloadUrlForLayer",
      "ecr:BatchGetImage",
      "logs:CreateLogStream",
      "logs:PutLogEvents"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-06-13T19:11:37+00:00"
 },
 "AmazonEC2FullAccess":{
  "CreateDate":"2015-02-06T18:40:15+00:00",
  "DefaultVersionId":"v5",
  "Document":{
   "Statement":[
    {
     "Action":"ec2:*",
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"elasticloadbalancing:*",
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"cloudwatch:*",
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"autoscaling:*",
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":[
        "autoscaling.amazonaws.com",
        "ec2scheduled.amazonaws.com",
        "elasticloadbalancing.amazonaws.com",
        "spot.amazonaws.com",
        "spotfleet.amazonaws.com",
        "transitgateway.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2018-11-27T02:16:56+00:00"
 },
 "AmazonEC2ReadOnlyAccess":{
  "CreateDate":"2015-02-06T18:40:17+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":"ec2:Describe*",
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"elasticloadbalancing:Describe*",
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "cloudwatch:ListMetrics",
      "cloudwatch:GetMetricStatistics",
      "cloudwatch:Describe*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"autoscaling:Describe*",
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2015-02-06T18:40:17+00:00"
 },
 "AmazonEC2RolePolicyForLaunchWizard":{
  "CreateDate":"2019-11-13T08:05:53+00:00",
  "DefaultVersionId":"v10",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:AttachVolume",
      "ec2:RebootInstances",
      "ec2:StartInstances",
      "ec2:StopInstances"
     ],
     "Condition":{
      "StringLike":{
       "ec2:ResourceTag/LaunchWizardResourceGroupID":"*"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:volume/*",
      "arn:aws:ec2:*:*:instance/*"
     ]
    },
    {
     "Action":[
      "ec2:ReplaceRoute"
     ],
     "Condition":{
      "StringLike":{
       "ec2:ResourceTag/LaunchWizardApplicationType":"*"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:route-table/*"
    },
    {
     "Action":[
      "ec2:DescribeAddresses",
      "ec2:AssociateAddress",
      "ec2:DescribeInstances",
      "ec2:DescribeImages",
      "ec2:DescribeRegions",
      "ec2:DescribeVolumes",
      "ec2:DescribeRouteTables",
      "ec2:ModifyInstanceAttribute",
      "cloudwatch:GetMetricStatistics",
      "cloudwatch:PutMetricData",
      "ssm:GetCommandInvocation"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:CreateTags",
      "ec2:CreateVolume"
     ],
     "Condition":{
      "ForAllValues:StringEquals":{
       "aws:TagKeys":[
        "LaunchWizardResourceGroupID",
        "LaunchWizardApplicationType"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:volume/*"
    },
    {
     "Action":[
      "s3:GetObject",
      "s3:ListBucket",
      "s3:PutObject",
      "s3:PutObjectTagging",
      "s3:GetBucketLocation",
      "logs:PutLogEvents",
      "logs:DescribeLogGroups",
      "logs:DescribeLogStreams"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:logs:*:*:*",
      "arn:aws:s3:::launchwizard*",
      "arn:aws:s3:::aws-sap-data-provider/config.properties"
     ]
    },
    {
     "Action":"logs:Create*",
     "Effect":"Allow",
     "Resource":"arn:aws:logs:*:*:*"
    },
    {
     "Action":[
      "ec2:Describe*",
      "cloudformation:DescribeStackResources",
      "cloudformation:SignalResource",
      "cloudformation:DescribeStackResource",
      "cloudformation:DescribeStacks"
     ],
     "Condition":{
      "ForAllValues:StringEquals":{
       "aws:TagKeys":"LaunchWizardResourceGroupID"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "dynamodb:BatchGetItem",
      "dynamodb:PutItem",
      "sqs:ReceiveMessage",
      "sqs:SendMessage",
      "dynamodb:Scan",
      "s3:ListBucket",
      "dynamodb:Query",
      "dynamodb:UpdateItem",
      "dynamodb:DeleteTable",
      "dynamodb:CreateTable",
      "s3:GetObject",
      "dynamodb:DescribeTable",
      "s3:GetBucketLocation",
      "dynamodb:UpdateTable"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::launchwizard*",
      "arn:aws:dynamodb:*:*:table/LaunchWizard*",
      "arn:aws:sqs:*:*:LaunchWizard*"
     ]
    },
    {
     "Action":"ssm:SendCommand",
     "Condition":{
      "StringLike":{
       "ssm:resourceTag/LaunchWizardApplicationType":"*"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:instance/*"
    },
    {
     "Action":[
      "ssm:SendCommand",
      "ssm:GetDocument"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ssm:*:*:document/AWSSAP-InstallBackint"
     ]
    },
    {
     "Action":[
      "fsx:DescribeFileSystems",
      "fsx:ListTagsForResource",
      "fsx:DescribeStorageVirtualMachines"
     ],
     "Condition":{
      "ForAllValues:StringLike":{
       "aws:TagKeys":"LaunchWizard*"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-05-16T21:16:38+00:00"
 },
 "AmazonEC2RoleforAWSCodeDeploy":{
  "CreateDate":"2015-05-19T18:10:14+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "s3:GetObject",
      "s3:GetObjectVersion",
      "s3:ListBucket"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2017-03-20T17:14:10+00:00"
 },
 "AmazonEC2RoleforAWSCodeDeployLimited":{
  "CreateDate":"2020-08-24T17:55:18+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "s3:GetObject",
      "s3:GetObjectVersion",
      "s3:ListBucket"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::*/CodeDeploy/*"
    },
    {
     "Action":[
      "s3:GetObject",
      "s3:GetObjectVersion"
     ],
     "Condition":{
      "StringEquals":{
       "s3:ExistingObjectTag/UseWithCodeDeploy":"true"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-01-20T21:37:31+00:00"
 },
 "AmazonEC2RoleforDataPipelineRole":{
  "CreateDate":"2015-02-06T18:41:25+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cloudwatch:*",
      "datapipeline:*",
      "dynamodb:*",
      "ec2:Describe*",
      "elasticmapreduce:AddJobFlowSteps",
      "elasticmapreduce:Describe*",
      "elasticmapreduce:ListInstance*",
      "elasticmapreduce:ModifyInstanceGroups",
      "rds:Describe*",
      "redshift:DescribeClusters",
      "redshift:DescribeClusterSecurityGroups",
      "s3:*",
      "sdb:*",
      "sns:*",
      "sqs:*"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2016-02-22T17:24:05+00:00"
 },
 "AmazonEC2RoleforSSM":{
  "CreateDate":"2015-05-29T17:48:35+00:00",
  "DefaultVersionId":"v8",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ssm:DescribeAssociation",
      "ssm:GetDeployablePatchSnapshotForInstance",
      "ssm:GetDocument",
      "ssm:DescribeDocument",
      "ssm:GetManifest",
      "ssm:GetParameters",
      "ssm:ListAssociations",
      "ssm:ListInstanceAssociations",
      "ssm:PutInventory",
      "ssm:PutComplianceItems",
      "ssm:PutConfigurePackageResult",
      "ssm:UpdateAssociationStatus",
      "ssm:UpdateInstanceAssociationStatus",
      "ssm:UpdateInstanceInformation"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ssmmessages:CreateControlChannel",
      "ssmmessages:CreateDataChannel",
      "ssmmessages:OpenControlChannel",
      "ssmmessages:OpenDataChannel"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2messages:AcknowledgeMessage",
      "ec2messages:DeleteMessage",
      "ec2messages:FailMessage",
      "ec2messages:GetEndpoint",
      "ec2messages:GetMessages",
      "ec2messages:SendReply"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "cloudwatch:PutMetricData"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:DescribeInstanceStatus"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ds:CreateComputer",
      "ds:DescribeDirectories"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "logs:CreateLogGroup",
      "logs:CreateLogStream",
      "logs:DescribeLogGroups",
      "logs:DescribeLogStreams",
      "logs:PutLogEvents"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "s3:GetBucketLocation",
      "s3:PutObject",
      "s3:GetObject",
      "s3:GetEncryptionConfiguration",
      "s3:AbortMultipartUpload",
      "s3:ListMultipartUploadParts",
      "s3:ListBucket",
      "s3:ListBucketMultipartUploads"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-01-24T19:20:51+00:00"
 },
 "AmazonEC2SpotFleetAutoscaleRole":{
  "CreateDate":"2016-08-19T18:27:22+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:DescribeSpotFleetRequests",
      "ec2:ModifySpotFleetRequest"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "cloudwatch:DescribeAlarms",
      "cloudwatch:PutMetricAlarm",
      "cloudwatch:DeleteAlarms"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringLike":{
       "iam:AWSServiceName":"ec2.application-autoscaling.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/aws-service-role/ec2.application-autoscaling.amazonaws.com/AWSServiceRoleForApplicationAutoScaling_EC2SpotFleetRequest"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-02-18T19:17:03+00:00"
 },
 "AmazonEC2SpotFleetTaggingRole":{
  "CreateDate":"2017-06-29T18:19:29+00:00",
  "DefaultVersionId":"v5",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:DescribeImages",
      "ec2:DescribeSubnets",
      "ec2:RequestSpotInstances",
      "ec2:TerminateInstances",
      "ec2:DescribeInstanceStatus",
      "ec2:CreateTags",
      "ec2:RunInstances"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":"iam:PassRole",
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":[
        "ec2.amazonaws.com",
        "ec2.amazonaws.com.cn"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "elasticloadbalancing:RegisterInstancesWithLoadBalancer"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:elasticloadbalancing:*:*:loadbalancer/*"
     ]
    },
    {
     "Action":[
      "elasticloadbalancing:RegisterTargets"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:elasticloadbalancing:*:*:*/*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-04-23T19:30:49+00:00"
 },
 "AmazonECSServiceRolePolicy":{
  "CreateDate":"2017-10-14T01:18:58+00:00",
  "DefaultVersionId":"v8",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:AttachNetworkInterface",
      "ec2:CreateNetworkInterface",
      "ec2:CreateNetworkInterfacePermission",
      "ec2:DeleteNetworkInterface",
      "ec2:DeleteNetworkInterfacePermission",
      "ec2:Describe*",
      "ec2:DetachNetworkInterface",
      "elasticloadbalancing:DeregisterInstancesFromLoadBalancer",
      "elasticloadbalancing:DeregisterTargets",
      "elasticloadbalancing:Describe*",
      "elasticloadbalancing:RegisterInstancesWithLoadBalancer",
      "elasticloadbalancing:RegisterTargets",
      "route53:ChangeResourceRecordSets",
      "route53:CreateHealthCheck",
      "route53:DeleteHealthCheck",
      "route53:Get*",
      "route53:List*",
      "route53:UpdateHealthCheck",
      "servicediscovery:DeregisterInstance",
      "servicediscovery:Get*",
      "servicediscovery:List*",
      "servicediscovery:RegisterInstance",
      "servicediscovery:UpdateInstanceCustomHealthStatus"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ECSTaskManagement"
    },
    {
     "Action":[
      "autoscaling:Describe*"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AutoScaling"
    },
    {
     "Action":[
      "autoscaling:DeletePolicy",
      "autoscaling:PutScalingPolicy",
      "autoscaling:SetInstanceProtection",
      "autoscaling:UpdateAutoScalingGroup"
     ],
     "Condition":{
      "Null":{
       "autoscaling:ResourceTag/AmazonECSManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AutoScalingManagement"
    },
    {
     "Action":[
      "autoscaling-plans:CreateScalingPlan",
      "autoscaling-plans:DeleteScalingPlan",
      "autoscaling-plans:DescribeScalingPlans"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AutoScalingPlanManagement"
    },
    {
     "Action":[
      "cloudwatch:DeleteAlarms",
      "cloudwatch:DescribeAlarms",
      "cloudwatch:PutMetricAlarm"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:cloudwatch:*:*:alarm:*",
     "Sid":"CWAlarmManagement"
    },
    {
     "Action":[
      "ec2:CreateTags"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:network-interface/*",
     "Sid":"ECSTagging"
    },
    {
     "Action":[
      "logs:CreateLogGroup",
      "logs:DescribeLogGroups",
      "logs:PutRetentionPolicy"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:logs:*:*:log-group:/aws/ecs/*",
     "Sid":"CWLogGroupManagement"
    },
    {
     "Action":[
      "logs:CreateLogStream",
      "logs:DescribeLogStreams",
      "logs:PutLogEvents"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:logs:*:*:log-group:/aws/ecs/*:log-stream:*",
     "Sid":"CWLogStreamManagement"
    },
    {
     "Action":[
      "ssm:DescribeSessions"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ExecuteCommandSessionManagement"
    },
    {
     "Action":[
      "ssm:StartSession"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ecs:*:*:task/*",
      "arn:aws:ssm:*:*:document/AmazonECS-ExecuteInteractiveCommand"
     ],
     "Sid":"ExecuteCommand"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-01-13T20:04:13+00:00"
 },
 "AmazonECSTaskExecutionRolePolicy":{
  "CreateDate":"2017-11-16T18:48:22+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ecr:GetAuthorizationToken",
      "ecr:BatchCheckLayerAvailability",
      "ecr:GetDownloadUrlForLayer",
      "ecr:BatchGetImage",
      "logs:CreateLogStream",
      "logs:PutLogEvents"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2017-11-16T18:48:22+00:00"
 },
 "AmazonECS_FullAccess":{
  "CreateDate":"2017-11-07T21:36:54+00:00",
  "DefaultVersionId":"v19",
  "Document":{
   "Statement":[
    {
     "Action":[
      "application-autoscaling:DeleteScalingPolicy",
      "application-autoscaling:DeregisterScalableTarget",
      "application-autoscaling:DescribeScalableTargets",
      "application-autoscaling:DescribeScalingActivities",
      "application-autoscaling:DescribeScalingPolicies",
      "application-autoscaling:PutScalingPolicy",
      "application-autoscaling:RegisterScalableTarget",
      "appmesh:DescribeVirtualGateway",
      "appmesh:DescribeVirtualNode",
      "appmesh:ListMeshes",
      "appmesh:ListVirtualGateways",
      "appmesh:ListVirtualNodes",
      "autoscaling:CreateAutoScalingGroup",
      "autoscaling:CreateLaunchConfiguration",
      "autoscaling:DeleteAutoScalingGroup",
      "autoscaling:DeleteLaunchConfiguration",
      "autoscaling:Describe*",
      "autoscaling:UpdateAutoScalingGroup",
      "cloudformation:CreateStack",
      "cloudformation:DeleteStack",
      "cloudformation:DescribeStack*",
      "cloudformation:UpdateStack",
      "cloudwatch:DeleteAlarms",
      "cloudwatch:DescribeAlarms",
      "cloudwatch:GetMetricStatistics",
      "cloudwatch:PutMetricAlarm",
      "codedeploy:BatchGetApplicationRevisions",
      "codedeploy:BatchGetApplications",
      "codedeploy:BatchGetDeploymentGroups",
      "codedeploy:BatchGetDeployments",
      "codedeploy:ContinueDeployment",
      "codedeploy:CreateApplication",
      "codedeploy:CreateDeployment",
      "codedeploy:CreateDeploymentGroup",
      "codedeploy:GetApplication",
      "codedeploy:GetApplicationRevision",
      "codedeploy:GetDeployment",
      "codedeploy:GetDeploymentConfig",
      "codedeploy:GetDeploymentGroup",
      "codedeploy:GetDeploymentTarget",
      "codedeploy:ListApplicationRevisions",
      "codedeploy:ListApplications",
      "codedeploy:ListDeploymentConfigs",
      "codedeploy:ListDeploymentGroups",
      "codedeploy:ListDeployments",
      "codedeploy:ListDeploymentTargets",
      "codedeploy:RegisterApplicationRevision",
      "codedeploy:StopDeployment",
      "ec2:AssociateRouteTable",
      "ec2:AttachInternetGateway",
      "ec2:AuthorizeSecurityGroupIngress",
      "ec2:CancelSpotFleetRequests",
      "ec2:CreateInternetGateway",
      "ec2:CreateLaunchTemplate",
      "ec2:CreateRoute",
      "ec2:CreateRouteTable",
      "ec2:CreateSecurityGroup",
      "ec2:CreateSubnet",
      "ec2:CreateVpc",
      "ec2:DeleteLaunchTemplate",
      "ec2:DeleteSubnet",
      "ec2:DeleteVpc",
      "ec2:Describe*",
      "ec2:DetachInternetGateway",
      "ec2:DisassociateRouteTable",
      "ec2:ModifySubnetAttribute",
      "ec2:ModifyVpcAttribute",
      "ec2:RequestSpotFleet",
      "ec2:RunInstances",
      "ecs:*",
      "elasticfilesystem:DescribeAccessPoints",
      "elasticfilesystem:DescribeFileSystems",
      "elasticloadbalancing:CreateListener",
      "elasticloadbalancing:CreateLoadBalancer",
      "elasticloadbalancing:CreateRule",
      "elasticloadbalancing:CreateTargetGroup",
      "elasticloadbalancing:DeleteListener",
      "elasticloadbalancing:DeleteLoadBalancer",
      "elasticloadbalancing:DeleteRule",
      "elasticloadbalancing:DeleteTargetGroup",
      "elasticloadbalancing:DescribeListeners",
      "elasticloadbalancing:DescribeLoadBalancers",
      "elasticloadbalancing:DescribeRules",
      "elasticloadbalancing:DescribeTargetGroups",
      "events:DeleteRule",
      "events:DescribeRule",
      "events:ListRuleNamesByTarget",
      "events:ListTargetsByRule",
      "events:PutRule",
      "events:PutTargets",
      "events:RemoveTargets",
      "fsx:DescribeFileSystems",
      "iam:ListAttachedRolePolicies",
      "iam:ListInstanceProfiles",
      "iam:ListRoles",
      "lambda:ListFunctions",
      "logs:CreateLogGroup",
      "logs:DescribeLogGroups",
      "logs:FilterLogEvents",
      "route53:CreateHostedZone",
      "route53:DeleteHostedZone",
      "route53:GetHealthCheck",
      "route53:GetHostedZone",
      "route53:ListHostedZonesByName",
      "servicediscovery:CreatePrivateDnsNamespace",
      "servicediscovery:CreateService",
      "servicediscovery:DeleteService",
      "servicediscovery:GetNamespace",
      "servicediscovery:GetOperation",
      "servicediscovery:GetService",
      "servicediscovery:ListNamespaces",
      "servicediscovery:ListServices",
      "servicediscovery:UpdateService",
      "sns:ListTopics"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "ssm:GetParameter",
      "ssm:GetParameters",
      "ssm:GetParametersByPath"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:ssm:*:*:parameter/aws/service/ecs*"
    },
    {
     "Action":[
      "ec2:DeleteInternetGateway",
      "ec2:DeleteRoute",
      "ec2:DeleteRouteTable",
      "ec2:DeleteSecurityGroup"
     ],
     "Condition":{
      "StringLike":{
       "ec2:ResourceTag/aws:cloudformation:stack-name":"EC2ContainerService-*"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":"iam:PassRole",
     "Condition":{
      "StringLike":{
       "iam:PassedToService":"ecs-tasks.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":"iam:PassRole",
     "Condition":{
      "StringLike":{
       "iam:PassedToService":[
        "ec2.amazonaws.com",
        "ec2.amazonaws.com.cn"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/ecsInstanceRole*"
     ]
    },
    {
     "Action":"iam:PassRole",
     "Condition":{
      "StringLike":{
       "iam:PassedToService":[
        "application-autoscaling.amazonaws.com",
        "application-autoscaling.amazonaws.com.cn"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/ecsAutoscaleRole*"
     ]
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringLike":{
       "iam:AWSServiceName":[
        "autoscaling.amazonaws.com",
        "ecs.amazonaws.com",
        "ecs.application-autoscaling.amazonaws.com",
        "spot.amazonaws.com",
        "spotfleet.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-10-12T21:02:23+00:00"
 },
 "AmazonEKSClusterPolicy":{
  "CreateDate":"2018-05-27T21:06:14+00:00",
  "DefaultVersionId":"v5",
  "Document":{
   "Statement":[
    {
     "Action":[
      "autoscaling:DescribeAutoScalingGroups",
      "autoscaling:UpdateAutoScalingGroup",
      "ec2:AttachVolume",
      "ec2:AuthorizeSecurityGroupIngress",
      "ec2:CreateRoute",
      "ec2:CreateSecurityGroup",
      "ec2:CreateTags",
      "ec2:CreateVolume",
      "ec2:DeleteRoute",
      "ec2:DeleteSecurityGroup",
      "ec2:DeleteVolume",
      "ec2:DescribeInstances",
      "ec2:DescribeRouteTables",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeSubnets",
      "ec2:DescribeVolumes",
      "ec2:DescribeVolumesModifications",
      "ec2:DescribeVpcs",
      "ec2:DescribeDhcpOptions",
      "ec2:DescribeNetworkInterfaces",
      "ec2:DetachVolume",
      "ec2:ModifyInstanceAttribute",
      "ec2:ModifyVolume",
      "ec2:RevokeSecurityGroupIngress",
      "ec2:DescribeAccountAttributes",
      "ec2:DescribeAddresses",
      "ec2:DescribeInternetGateways",
      "elasticloadbalancing:AddTags",
      "elasticloadbalancing:ApplySecurityGroupsToLoadBalancer",
      "elasticloadbalancing:AttachLoadBalancerToSubnets",
      "elasticloadbalancing:ConfigureHealthCheck",
      "elasticloadbalancing:CreateListener",
      "elasticloadbalancing:CreateLoadBalancer",
      "elasticloadbalancing:CreateLoadBalancerListeners",
      "elasticloadbalancing:CreateLoadBalancerPolicy",
      "elasticloadbalancing:CreateTargetGroup",
      "elasticloadbalancing:DeleteListener",
      "elasticloadbalancing:DeleteLoadBalancer",
      "elasticloadbalancing:DeleteLoadBalancerListeners",
      "elasticloadbalancing:DeleteTargetGroup",
      "elasticloadbalancing:DeregisterInstancesFromLoadBalancer",
      "elasticloadbalancing:DeregisterTargets",
      "elasticloadbalancing:DescribeListeners",
      "elasticloadbalancing:DescribeLoadBalancerAttributes",
      "elasticloadbalancing:DescribeLoadBalancerPolicies",
      "elasticloadbalancing:DescribeLoadBalancers",
      "elasticloadbalancing:DescribeTargetGroupAttributes",
      "elasticloadbalancing:DescribeTargetGroups",
      "elasticloadbalancing:DescribeTargetHealth",
      "elasticloadbalancing:DetachLoadBalancerFromSubnets",
      "elasticloadbalancing:ModifyListener",
      "elasticloadbalancing:ModifyLoadBalancerAttributes",
      "elasticloadbalancing:ModifyTargetGroup",
      "elasticloadbalancing:ModifyTargetGroupAttributes",
      "elasticloadbalancing:RegisterInstancesWithLoadBalancer",
      "elasticloadbalancing:RegisterTargets",
      "elasticloadbalancing:SetLoadBalancerPoliciesForBackendServer",
      "elasticloadbalancing:SetLoadBalancerPoliciesOfListener",
      "kms:DescribeKey"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":"elasticloadbalancing.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-06-15T20:57:05+00:00"
 },
 "AmazonEKSConnectorServiceRolePolicy":{
  "CreateDate":"2021-09-04T20:31:08+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ssm:CreateActivation",
      "ssm:DescribeInstanceInformation",
      "ssm:DeleteActivation"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AccessSSMService"
    },
    {
     "Action":[
      "ssm:StartSession"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:eks:*:*:cluster/*",
      "arn:aws:ssm:*::document/AmazonEKS-ExecuteNonInteractiveCommand"
     ],
     "Sid":"ConnectorAgentStartSession"
    },
    {
     "Action":[
      "ssm:DeregisterManagedInstance"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:eks:*:*:cluster/*"
     ],
     "Sid":"ConnectorAgentDeregister"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":[
        "ssm.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"PassAnyRoleToSsm"
    },
    {
     "Action":"events:PutRule",
     "Condition":{
      "StringEquals":{
       "events:ManagedBy":"eks-connector.amazonaws.com",
       "events:source":"aws.ssm"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"PutManagedEventRule"
    },
    {
     "Action":"events:PutTargets",
     "Condition":{
      "StringEquals":{
       "events:ManagedBy":"eks-connector.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"PutManagedEventTarget"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-09-04T20:31:08+00:00"
 },
 "AmazonEKSFargatePodExecutionRolePolicy":{
  "CreateDate":"2019-11-22T04:34:29+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ecr:GetAuthorizationToken",
      "ecr:BatchCheckLayerAvailability",
      "ecr:GetDownloadUrlForLayer",
      "ecr:BatchGetImage"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-11-22T04:34:29+00:00"
 },
 "AmazonEKSForFargateServiceRolePolicy":{
  "CreateDate":"2019-11-22T04:36:25+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:CreateNetworkInterface",
      "ec2:CreateNetworkInterfacePermission",
      "ec2:DeleteNetworkInterface",
      "ec2:DescribeNetworkInterfaces",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeSubnets",
      "ec2:DescribeVpcs",
      "ec2:DescribeDhcpOptions",
      "ec2:DescribeRouteTables"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-11-22T04:36:25+00:00"
 },
 "AmazonEKSServicePolicy":{
  "CreateDate":"2018-05-27T21:08:21+00:00",
  "DefaultVersionId":"v6",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:CreateNetworkInterface",
      "ec2:CreateNetworkInterfacePermission",
      "ec2:DeleteNetworkInterface",
      "ec2:DescribeInstances",
      "ec2:DescribeNetworkInterfaces",
      "ec2:DetachNetworkInterface",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeSubnets",
      "ec2:DescribeVpcs",
      "ec2:ModifyNetworkInterfaceAttribute",
      "iam:ListAttachedRolePolicies",
      "eks:UpdateClusterVersion"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:CreateTags",
      "ec2:DeleteTags"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:vpc/*",
      "arn:aws:ec2:*:*:subnet/*"
     ]
    },
    {
     "Action":"route53:AssociateVPCWithHostedZone",
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"logs:CreateLogGroup",
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "logs:CreateLogStream",
      "logs:DescribeLogStreams"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:logs:*:*:log-group:/aws/eks/*:*"
    },
    {
     "Action":"logs:PutLogEvents",
     "Effect":"Allow",
     "Resource":"arn:aws:logs:*:*:log-group:/aws/eks/*:*:*"
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringLike":{
       "iam:AWSServiceName":"eks.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-05-27T19:27:03+00:00"
 },
 "AmazonEKSServiceRolePolicy":{
  "CreateDate":"2020-02-21T20:10:47+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:CreateNetworkInterface",
      "ec2:DeleteNetworkInterface",
      "ec2:DetachNetworkInterface",
      "ec2:ModifyNetworkInterfaceAttribute",
      "ec2:DescribeInstances",
      "ec2:DescribeNetworkInterfaces",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeSubnets",
      "ec2:DescribeVpcs",
      "ec2:CreateNetworkInterfacePermission",
      "iam:ListAttachedRolePolicies",
      "ec2:CreateSecurityGroup"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:DeleteSecurityGroup",
      "ec2:RevokeSecurityGroupIngress",
      "ec2:AuthorizeSecurityGroupIngress"
     ],
     "Condition":{
      "ForAnyValue:StringLike":{
       "ec2:ResourceTag/Name":"eks-cluster-sg*"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:security-group/*"
    },
    {
     "Action":[
      "ec2:CreateTags",
      "ec2:DeleteTags"
     ],
     "Condition":{
      "ForAnyValue:StringLike":{
       "aws:TagKeys":[
        "kubernetes.io/cluster/*"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:vpc/*",
      "arn:aws:ec2:*:*:subnet/*"
     ]
    },
    {
     "Action":[
      "ec2:CreateTags",
      "ec2:DeleteTags"
     ],
     "Condition":{
      "ForAnyValue:StringLike":{
       "aws:RequestTag/Name":"eks-cluster-sg*",
       "aws:TagKeys":[
        "kubernetes.io/cluster/*"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:security-group/*"
     ]
    },
    {
     "Action":"route53:AssociateVPCWithHostedZone",
     "Effect":"Allow",
     "Resource":"arn:aws:route53:::hostedzone/*"
    },
    {
     "Action":"logs:CreateLogGroup",
     "Effect":"Allow",
     "Resource":"arn:aws:logs:*:*:log-group:/aws/eks/*"
    },
    {
     "Action":[
      "logs:CreateLogStream",
      "logs:DescribeLogStreams"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:logs:*:*:log-group:/aws/eks/*:*"
    },
    {
     "Action":"logs:PutLogEvents",
     "Effect":"Allow",
     "Resource":"arn:aws:logs:*:*:log-group:/aws/eks/*:*:*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-05-27T19:30:19+00:00"
 },
 "AmazonEKSVPCResourceController":{
  "CreateDate":"2020-08-12T00:55:34+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":"ec2:CreateNetworkInterfacePermission",
     "Condition":{
      "ForAnyValue:StringEquals":{
       "ec2:ResourceTag/eks:eni:owner":"eks-vpc-resource-controller"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:CreateNetworkInterface",
      "ec2:DetachNetworkInterface",
      "ec2:ModifyNetworkInterfaceAttribute",
      "ec2:DeleteNetworkInterface",
      "ec2:AttachNetworkInterface",
      "ec2:UnassignPrivateIpAddresses",
      "ec2:AssignPrivateIpAddresses"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-08-12T00:55:34+00:00"
 },
 "AmazonEKSWorkerNodePolicy":{
  "CreateDate":"2018-05-27T21:09:01+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:DescribeInstances",
      "ec2:DescribeInstanceTypes",
      "ec2:DescribeRouteTables",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeSubnets",
      "ec2:DescribeVolumes",
      "ec2:DescribeVolumesModifications",
      "ec2:DescribeVpcs",
      "eks:DescribeCluster"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-03-21T22:39:36+00:00"
 },
 "AmazonEKS_CNI_Policy":{
  "CreateDate":"2018-05-27T21:07:42+00:00",
  "DefaultVersionId":"v4",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:AssignPrivateIpAddresses",
      "ec2:AttachNetworkInterface",
      "ec2:CreateNetworkInterface",
      "ec2:DeleteNetworkInterface",
      "ec2:DescribeInstances",
      "ec2:DescribeTags",
      "ec2:DescribeNetworkInterfaces",
      "ec2:DescribeInstanceTypes",
      "ec2:DetachNetworkInterface",
      "ec2:ModifyNetworkInterfaceAttribute",
      "ec2:UnassignPrivateIpAddresses"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:CreateTags"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:network-interface/*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-04-20T20:52:01+00:00"
 },
 "AmazonEMRCleanupPolicy":{
  "CreateDate":"2017-09-26T23:54:19+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:DescribeInstances",
      "ec2:DescribeLaunchTemplates",
      "ec2:DescribeSpotInstanceRequests",
      "ec2:DeleteLaunchTemplate",
      "ec2:ModifyInstanceAttribute",
      "ec2:TerminateInstances",
      "ec2:CancelSpotInstanceRequests",
      "ec2:DeleteNetworkInterface",
      "ec2:DescribeInstanceAttribute",
      "ec2:DescribeVolumeStatus",
      "ec2:DescribeVolumes",
      "ec2:DetachVolume",
      "ec2:DeleteVolume",
      "ec2:DescribePlacementGroups",
      "ec2:DeletePlacementGroup"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-09-29T21:11:54+00:00"
 },
 "AmazonEMRContainersServiceRolePolicy":{
  "CreateDate":"2020-12-09T00:38:19+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "eks:DescribeCluster",
      "ec2:DescribeRouteTables",
      "ec2:DescribeSubnets",
      "ec2:DescribeSecurityGroups",
      "elasticloadbalancing:DescribeInstanceHealth",
      "elasticloadbalancing:DescribeLoadBalancers"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "acm:ImportCertificate",
      "acm:AddTagsToCertificate"
     ],
     "Condition":{
      "StringEquals":{
       "aws:RequestTag/emr-container:endpoint:managed-certificate":"true"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "acm:DeleteCertificate"
     ],
     "Condition":{
      "StringEquals":{
       "aws:ResourceTag/emr-container:endpoint:managed-certificate":"true"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-12-03T19:55:44+00:00"
 },
 "AmazonEMRFullAccessPolicy_v2":{
  "CreateDate":"2021-03-12T01:50:29+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "elasticmapreduce:RunJobFlow"
     ],
     "Condition":{
      "StringEquals":{
       "aws:RequestTag/for-use-with-amazon-emr-managed-policies":"true"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"RunJobFlowExplicitlyWithEMRManagedTag"
    },
    {
     "Action":[
      "elasticmapreduce:AddInstanceFleet",
      "elasticmapreduce:AddInstanceGroups",
      "elasticmapreduce:AddJobFlowSteps",
      "elasticmapreduce:AddTags",
      "elasticmapreduce:CancelSteps",
      "elasticmapreduce:CreateEditor",
      "elasticmapreduce:CreateSecurityConfiguration",
      "elasticmapreduce:DeleteEditor",
      "elasticmapreduce:DeleteSecurityConfiguration",
      "elasticmapreduce:DescribeCluster",
      "elasticmapreduce:DescribeEditor",
      "elasticmapreduce:DescribeJobFlows",
      "elasticmapreduce:DescribeSecurityConfiguration",
      "elasticmapreduce:DescribeStep",
      "elasticmapreduce:DescribeReleaseLabel",
      "elasticmapreduce:GetBlockPublicAccessConfiguration",
      "elasticmapreduce:GetManagedScalingPolicy",
      "elasticmapreduce:GetAutoTerminationPolicy",
      "elasticmapreduce:ListBootstrapActions",
      "elasticmapreduce:ListClusters",
      "elasticmapreduce:ListEditors",
      "elasticmapreduce:ListInstanceFleets",
      "elasticmapreduce:ListInstanceGroups",
      "elasticmapreduce:ListInstances",
      "elasticmapreduce:ListSecurityConfigurations",
      "elasticmapreduce:ListSteps",
      "elasticmapreduce:ModifyCluster",
      "elasticmapreduce:ModifyInstanceFleet",
      "elasticmapreduce:ModifyInstanceGroups",
      "elasticmapreduce:OpenEditorInConsole",
      "elasticmapreduce:PutAutoScalingPolicy",
      "elasticmapreduce:PutBlockPublicAccessConfiguration",
      "elasticmapreduce:PutManagedScalingPolicy",
      "elasticmapreduce:RemoveAutoScalingPolicy",
      "elasticmapreduce:RemoveManagedScalingPolicy",
      "elasticmapreduce:RemoveTags",
      "elasticmapreduce:SetTerminationProtection",
      "elasticmapreduce:StartEditor",
      "elasticmapreduce:StopEditor",
      "elasticmapreduce:TerminateJobFlows",
      "elasticmapreduce:ViewEventsFromAllClustersInConsole"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ElasticMapReduceActions"
    },
    {
     "Action":[
      "cloudwatch:GetMetricStatistics"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ViewMetricsInEMRConsole"
    },
    {
     "Action":"iam:PassRole",
     "Condition":{
      "StringLike":{
       "iam:PassedToService":"elasticmapreduce.amazonaws.com*"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/EMR_DefaultRole_V2",
     "Sid":"PassRoleForElasticMapReduce"
    },
    {
     "Action":"iam:PassRole",
     "Condition":{
      "StringLike":{
       "iam:PassedToService":"ec2.amazonaws.com*"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/EMR_EC2_DefaultRole",
     "Sid":"PassRoleForEC2"
    },
    {
     "Action":"iam:PassRole",
     "Condition":{
      "StringLike":{
       "iam:PassedToService":"application-autoscaling.amazonaws.com*"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/EMR_AutoScaling_DefaultRole",
     "Sid":"PassRoleForAutoScaling"
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":[
        "elasticmapreduce.amazonaws.com",
        "elasticmapreduce.amazonaws.com.cn"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/aws-service-role/elasticmapreduce.amazonaws.com*/AWSServiceRoleForEMRCleanup*",
     "Sid":"ElasticMapReduceServiceLinkedRole"
    },
    {
     "Action":[
      "ec2:DescribeAccountAttributes",
      "ec2:DescribeAvailabilityZones",
      "ec2:DescribeImages",
      "ec2:DescribeKeyPairs",
      "ec2:DescribeNatGateways",
      "ec2:DescribeRouteTables",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeSubnets",
      "ec2:DescribeVpcs",
      "ec2:DescribeVpcEndpoints",
      "s3:ListAllMyBuckets",
      "iam:ListRoles"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ConsoleUIActions"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-04-21T22:31:45+00:00"
 },
 "AmazonEMRReadOnlyAccessPolicy_v2":{
  "CreateDate":"2021-03-12T01:39:16+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "elasticmapreduce:DescribeCluster",
      "elasticmapreduce:DescribeEditor",
      "elasticmapreduce:DescribeJobFlows",
      "elasticmapreduce:DescribeSecurityConfiguration",
      "elasticmapreduce:DescribeStep",
      "elasticmapreduce:DescribeReleaseLabel",
      "elasticmapreduce:GetBlockPublicAccessConfiguration",
      "elasticmapreduce:GetManagedScalingPolicy",
      "elasticmapreduce:GetAutoTerminationPolicy",
      "elasticmapreduce:ListBootstrapActions",
      "elasticmapreduce:ListClusters",
      "elasticmapreduce:ListEditors",
      "elasticmapreduce:ListInstanceFleets",
      "elasticmapreduce:ListInstanceGroups",
      "elasticmapreduce:ListInstances",
      "elasticmapreduce:ListSecurityConfigurations",
      "elasticmapreduce:ListSteps",
      "elasticmapreduce:ViewEventsFromAllClustersInConsole"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ElasticMapReduceActions"
    },
    {
     "Action":[
      "cloudwatch:GetMetricStatistics"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ViewMetricsInEMRConsole"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-04-21T22:31:26+00:00"
 },
 "AmazonEMRServerlessServiceRolePolicy":{
  "CreateDate":"2022-05-20T23:15:42+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:CreateNetworkInterface",
      "ec2:DeleteNetworkInterface",
      "ec2:DescribeNetworkInterfaces",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeSubnets",
      "ec2:DescribeVpcs",
      "ec2:DescribeDhcpOptions",
      "ec2:DescribeRouteTables"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "cloudwatch:PutMetricData"
     ],
     "Condition":{
      "StringEquals":{
       "cloudwatch:namespace":"AWS/EMRServerless"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-05-20T23:15:42+00:00"
 },
 "AmazonEMRServicePolicy_v2":{
  "CreateDate":"2021-03-12T01:11:08+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:CreateNetworkInterface",
      "ec2:RunInstances",
      "ec2:CreateFleet",
      "ec2:CreateLaunchTemplate",
      "ec2:CreateLaunchTemplateVersion"
     ],
     "Condition":{
      "StringEquals":{
       "aws:ResourceTag/for-use-with-amazon-emr-managed-policies":"true"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:subnet/*",
      "arn:aws:ec2:*:*:security-group/*"
     ],
     "Sid":"CreateInTaggedNetwork"
    },
    {
     "Action":[
      "ec2:CreateFleet",
      "ec2:RunInstances",
      "ec2:CreateLaunchTemplateVersion"
     ],
     "Condition":{
      "StringEquals":{
       "aws:ResourceTag/for-use-with-amazon-emr-managed-policies":"true"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:launch-template/*",
     "Sid":"CreateWithEMRTaggedLaunchTemplate"
    },
    {
     "Action":"ec2:CreateLaunchTemplate",
     "Condition":{
      "StringEquals":{
       "aws:RequestTag/for-use-with-amazon-emr-managed-policies":"true"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:launch-template/*",
     "Sid":"CreateEMRTaggedLaunchTemplate"
    },
    {
     "Action":[
      "ec2:RunInstances",
      "ec2:CreateFleet"
     ],
     "Condition":{
      "StringEquals":{
       "aws:RequestTag/for-use-with-amazon-emr-managed-policies":"true"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:instance/*",
      "arn:aws:ec2:*:*:volume/*"
     ],
     "Sid":"CreateEMRTaggedInstancesAndVolumes"
    },
    {
     "Action":[
      "ec2:RunInstances",
      "ec2:CreateFleet",
      "ec2:CreateLaunchTemplate",
      "ec2:CreateLaunchTemplateVersion"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:network-interface/*",
      "arn:aws:ec2:*::image/ami-*",
      "arn:aws:ec2:*:*:key-pair/*",
      "arn:aws:ec2:*:*:capacity-reservation/*",
      "arn:aws:ec2:*:*:placement-group/EMR_*",
      "arn:aws:ec2:*:*:fleet/*",
      "arn:aws:ec2:*:*:dedicated-host/*",
      "arn:aws:resource-groups:*:*:group/*"
     ],
     "Sid":"ResourcesToLaunchEC2"
    },
    {
     "Action":[
      "ec2:CreateLaunchTemplateVersion",
      "ec2:DeleteLaunchTemplate",
      "ec2:DeleteNetworkInterface",
      "ec2:ModifyInstanceAttribute",
      "ec2:TerminateInstances"
     ],
     "Condition":{
      "StringEquals":{
       "aws:ResourceTag/for-use-with-amazon-emr-managed-policies":"true"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ManageEMRTaggedResources"
    },
    {
     "Action":[
      "ec2:CreateTags",
      "ec2:DeleteTags"
     ],
     "Condition":{
      "StringEquals":{
       "aws:ResourceTag/for-use-with-amazon-emr-managed-policies":"true"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:instance/*",
      "arn:aws:ec2:*:*:volume/*",
      "arn:aws:ec2:*:*:network-interface/*",
      "arn:aws:ec2:*:*:launch-template/*"
     ],
     "Sid":"ManageTagsOnEMRTaggedResources"
    },
    {
     "Action":[
      "ec2:CreateNetworkInterface"
     ],
     "Condition":{
      "StringEquals":{
       "aws:RequestTag/for-use-with-amazon-emr-managed-policies":"true"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:network-interface/*"
     ],
     "Sid":"CreateNetworkInterfaceNeededForPrivateSubnet"
    },
    {
     "Action":[
      "ec2:CreateTags"
     ],
     "Condition":{
      "StringEquals":{
       "ec2:CreateAction":[
        "RunInstances",
        "CreateFleet",
        "CreateLaunchTemplate",
        "CreateNetworkInterface"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:network-interface/*",
      "arn:aws:ec2:*:*:instance/*",
      "arn:aws:ec2:*:*:volume/*",
      "arn:aws:ec2:*:*:launch-template/*"
     ],
     "Sid":"TagOnCreateTaggedEMRResources"
    },
    {
     "Action":[
      "ec2:CreateTags",
      "ec2:DeleteTags"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:placement-group/EMR_*"
     ],
     "Sid":"TagPlacementGroups"
    },
    {
     "Action":[
      "ec2:DescribeAccountAttributes",
      "ec2:DescribeCapacityReservations",
      "ec2:DescribeDhcpOptions",
      "ec2:DescribeImages",
      "ec2:DescribeInstances",
      "ec2:DescribeLaunchTemplates",
      "ec2:DescribeNetworkAcls",
      "ec2:DescribeNetworkInterfaces",
      "ec2:DescribePlacementGroups",
      "ec2:DescribeRouteTables",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeSubnets",
      "ec2:DescribeVolumes",
      "ec2:DescribeVolumeStatus",
      "ec2:DescribeVpcAttribute",
      "ec2:DescribeVpcEndpoints",
      "ec2:DescribeVpcs"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ListActionsForEC2Resources"
    },
    {
     "Action":[
      "ec2:CreateSecurityGroup"
     ],
     "Condition":{
      "StringEquals":{
       "aws:RequestTag/for-use-with-amazon-emr-managed-policies":"true"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:security-group/*"
     ],
     "Sid":"CreateDefaultSecurityGroupWithEMRTags"
    },
    {
     "Action":[
      "ec2:CreateSecurityGroup"
     ],
     "Condition":{
      "StringEquals":{
       "aws:ResourceTag/for-use-with-amazon-emr-managed-policies":"true"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:vpc/*"
     ],
     "Sid":"CreateDefaultSecurityGroupInVPCWithEMRTags"
    },
    {
     "Action":[
      "ec2:CreateTags"
     ],
     "Condition":{
      "StringEquals":{
       "aws:RequestTag/for-use-with-amazon-emr-managed-policies":"true",
       "ec2:CreateAction":"CreateSecurityGroup"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:security-group/*",
     "Sid":"TagOnCreateDefaultSecurityGroupWithEMRTags"
    },
    {
     "Action":[
      "ec2:AuthorizeSecurityGroupEgress",
      "ec2:AuthorizeSecurityGroupIngress",
      "ec2:RevokeSecurityGroupEgress",
      "ec2:RevokeSecurityGroupIngress"
     ],
     "Condition":{
      "StringEquals":{
       "aws:ResourceTag/for-use-with-amazon-emr-managed-policies":"true"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ManageSecurityGroups"
    },
    {
     "Action":[
      "ec2:CreatePlacementGroup"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:placement-group/EMR_*",
     "Sid":"CreateEMRPlacementGroups"
    },
    {
     "Action":[
      "ec2:DeletePlacementGroup"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"DeletePlacementGroups"
    },
    {
     "Action":[
      "application-autoscaling:DeleteScalingPolicy",
      "application-autoscaling:DeregisterScalableTarget",
      "application-autoscaling:DescribeScalableTargets",
      "application-autoscaling:DescribeScalingPolicies",
      "application-autoscaling:PutScalingPolicy",
      "application-autoscaling:RegisterScalableTarget"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AutoScaling"
    },
    {
     "Action":[
      "resource-groups:ListGroupResources"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ResourceGroupsForCapacityReservations"
    },
    {
     "Action":[
      "cloudwatch:PutMetricAlarm",
      "cloudwatch:DeleteAlarms",
      "cloudwatch:DescribeAlarms"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:cloudwatch:*:*:alarm:*_EMR_Auto_Scaling",
     "Sid":"AutoScalingCloudWatch"
    },
    {
     "Action":"iam:PassRole",
     "Condition":{
      "StringLike":{
       "iam:PassedToService":"application-autoscaling.amazonaws.com*"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/EMR_AutoScaling_DefaultRole",
     "Sid":"PassRoleForAutoScaling"
    },
    {
     "Action":"iam:PassRole",
     "Condition":{
      "StringLike":{
       "iam:PassedToService":"ec2.amazonaws.com*"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/EMR_EC2_DefaultRole",
     "Sid":"PassRoleForEC2"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-02-15T16:48:29+00:00"
 },
 "AmazonESCognitoAccess":{
  "CreateDate":"2018-02-28T22:29:18+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cognito-idp:DescribeUserPool",
      "cognito-idp:CreateUserPoolClient",
      "cognito-idp:DeleteUserPoolClient",
      "cognito-idp:UpdateUserPoolClient",
      "cognito-idp:DescribeUserPoolClient",
      "cognito-idp:AdminInitiateAuth",
      "cognito-idp:AdminUserGlobalSignOut",
      "cognito-idp:ListUserPoolClients",
      "cognito-identity:DescribeIdentityPool",
      "cognito-identity:UpdateIdentityPool",
      "cognito-identity:SetIdentityPoolRoles",
      "cognito-identity:GetIdentityPoolRoles"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"iam:PassRole",
     "Condition":{
      "StringLike":{
       "iam:PassedToService":[
        "cognito-identity.amazonaws.com",
        "cognito-identity-us-gov.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-12-20T14:04:44+00:00"
 },
 "AmazonESFullAccess":{
  "CreateDate":"2015-10-01T19:14:00+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "es:*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2015-10-01T19:14:00+00:00"
 },
 "AmazonESReadOnlyAccess":{
  "CreateDate":"2015-10-01T19:18:24+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "es:Describe*",
      "es:List*",
      "es:Get*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2018-10-03T03:32:56+00:00"
 },
 "AmazonElastiCacheFullAccess":{
  "CreateDate":"2015-02-06T18:40:20+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":"elasticache:*",
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringLike":{
       "iam:AWSServiceName":"elasticache.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/aws-service-role/elasticache.amazonaws.com/AWSServiceRoleForElastiCache"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2017-12-07T17:48:26+00:00"
 },
 "AmazonElastiCacheReadOnlyAccess":{
  "CreateDate":"2015-02-06T18:40:21+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "elasticache:Describe*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2015-02-06T18:40:21+00:00"
 },
 "AmazonElasticContainerRegistryPublicFullAccess":{
  "CreateDate":"2020-12-01T17:25:52+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ecr-public:*",
      "sts:GetServiceBearerToken"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-12-01T17:25:52+00:00"
 },
 "AmazonElasticContainerRegistryPublicPowerUser":{
  "CreateDate":"2020-12-01T16:16:54+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ecr-public:GetAuthorizationToken",
      "sts:GetServiceBearerToken",
      "ecr-public:BatchCheckLayerAvailability",
      "ecr-public:GetRepositoryPolicy",
      "ecr-public:DescribeRepositories",
      "ecr-public:DescribeRegistries",
      "ecr-public:DescribeImages",
      "ecr-public:DescribeImageTags",
      "ecr-public:GetRepositoryCatalogData",
      "ecr-public:GetRegistryCatalogData",
      "ecr-public:InitiateLayerUpload",
      "ecr-public:UploadLayerPart",
      "ecr-public:CompleteLayerUpload",
      "ecr-public:PutImage"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-12-01T16:16:54+00:00"
 },
 "AmazonElasticContainerRegistryPublicReadOnly":{
  "CreateDate":"2020-12-01T17:27:04+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ecr-public:GetAuthorizationToken",
      "sts:GetServiceBearerToken",
      "ecr-public:BatchCheckLayerAvailability",
      "ecr-public:GetRepositoryPolicy",
      "ecr-public:DescribeRepositories",
      "ecr-public:DescribeRegistries",
      "ecr-public:DescribeImages",
      "ecr-public:DescribeImageTags",
      "ecr-public:GetRepositoryCatalogData",
      "ecr-public:GetRegistryCatalogData"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-12-01T17:27:04+00:00"
 },
 "AmazonElasticFileSystemClientFullAccess":{
  "CreateDate":"2020-01-13T16:27:00+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "elasticfilesystem:ClientMount",
      "elasticfilesystem:ClientRootAccess",
      "elasticfilesystem:ClientWrite",
      "elasticfilesystem:DescribeMountTargets"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-01-13T16:27:00+00:00"
 },
 "AmazonElasticFileSystemClientReadOnlyAccess":{
  "CreateDate":"2020-01-13T16:24:36+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "elasticfilesystem:ClientMount",
      "elasticfilesystem:DescribeMountTargets"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-01-13T16:24:36+00:00"
 },
 "AmazonElasticFileSystemClientReadWriteAccess":{
  "CreateDate":"2020-01-13T16:21:55+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "elasticfilesystem:ClientMount",
      "elasticfilesystem:ClientWrite",
      "elasticfilesystem:DescribeMountTargets"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-01-13T16:21:55+00:00"
 },
 "AmazonElasticFileSystemFullAccess":{
  "CreateDate":"2015-05-27T16:22:28+00:00",
  "DefaultVersionId":"v8",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cloudwatch:DescribeAlarmsForMetric",
      "cloudwatch:GetMetricData",
      "ec2:CreateNetworkInterface",
      "ec2:DeleteNetworkInterface",
      "ec2:DescribeAvailabilityZones",
      "ec2:DescribeNetworkInterfaceAttribute",
      "ec2:DescribeNetworkInterfaces",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeSubnets",
      "ec2:DescribeVpcAttribute",
      "ec2:DescribeVpcs",
      "ec2:ModifyNetworkInterfaceAttribute",
      "elasticfilesystem:CreateFileSystem",
      "elasticfilesystem:CreateMountTarget",
      "elasticfilesystem:CreateTags",
      "elasticfilesystem:CreateAccessPoint",
      "elasticfilesystem:CreateReplicationConfiguration",
      "elasticfilesystem:DeleteFileSystem",
      "elasticfilesystem:DeleteMountTarget",
      "elasticfilesystem:DeleteTags",
      "elasticfilesystem:DeleteAccessPoint",
      "elasticfilesystem:DeleteFileSystemPolicy",
      "elasticfilesystem:DeleteReplicationConfiguration",
      "elasticfilesystem:DescribeAccountPreferences",
      "elasticfilesystem:DescribeBackupPolicy",
      "elasticfilesystem:DescribeFileSystems",
      "elasticfilesystem:DescribeFileSystemPolicy",
      "elasticfilesystem:DescribeLifecycleConfiguration",
      "elasticfilesystem:DescribeMountTargets",
      "elasticfilesystem:DescribeMountTargetSecurityGroups",
      "elasticfilesystem:DescribeTags",
      "elasticfilesystem:DescribeAccessPoints",
      "elasticfilesystem:DescribeReplicationConfigurations",
      "elasticfilesystem:ModifyMountTargetSecurityGroups",
      "elasticfilesystem:PutAccountPreferences",
      "elasticfilesystem:PutBackupPolicy",
      "elasticfilesystem:PutLifecycleConfiguration",
      "elasticfilesystem:PutFileSystemPolicy",
      "elasticfilesystem:UpdateFileSystem",
      "elasticfilesystem:TagResource",
      "elasticfilesystem:UntagResource",
      "elasticfilesystem:ListTagsForResource",
      "elasticfilesystem:Backup",
      "elasticfilesystem:Restore",
      "kms:DescribeKey",
      "kms:ListAliases"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":[
        "elasticfilesystem.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-01-10T19:03:16+00:00"
 },
 "AmazonElasticFileSystemReadOnlyAccess":{
  "CreateDate":"2015-05-27T16:25:25+00:00",
  "DefaultVersionId":"v7",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cloudwatch:DescribeAlarmsForMetric",
      "cloudwatch:GetMetricData",
      "ec2:DescribeAvailabilityZones",
      "ec2:DescribeNetworkInterfaceAttribute",
      "ec2:DescribeNetworkInterfaces",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeSubnets",
      "ec2:DescribeVpcAttribute",
      "ec2:DescribeVpcs",
      "elasticfilesystem:DescribeAccountPreferences",
      "elasticfilesystem:DescribeBackupPolicy",
      "elasticfilesystem:DescribeFileSystems",
      "elasticfilesystem:DescribeFileSystemPolicy",
      "elasticfilesystem:DescribeLifecycleConfiguration",
      "elasticfilesystem:DescribeMountTargets",
      "elasticfilesystem:DescribeMountTargetSecurityGroups",
      "elasticfilesystem:DescribeTags",
      "elasticfilesystem:DescribeAccessPoints",
      "elasticfilesystem:DescribeReplicationConfigurations",
      "elasticfilesystem:ListTagsForResource",
      "kms:ListAliases"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-01-10T18:53:37+00:00"
 },
 "AmazonElasticFileSystemServiceRolePolicy":{
  "CreateDate":"2019-11-05T16:52:41+00:00",
  "DefaultVersionId":"v4",
  "Document":{
   "Statement":[
    {
     "Action":[
      "backup-storage:MountCapsule",
      "ec2:CreateNetworkInterface",
      "ec2:DeleteNetworkInterface",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeSubnets",
      "ec2:DescribeNetworkInterfaceAttribute",
      "ec2:ModifyNetworkInterfaceAttribute",
      "tag:GetResources"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "kms:DescribeKey"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:kms:*:*:key/*"
    },
    {
     "Action":[
      "backup:CreateBackupVault",
      "backup:PutBackupVaultAccessPolicy"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:backup:*:*:backup-vault:aws/efs/automatic-backup-vault"
     ]
    },
    {
     "Action":[
      "backup:CreateBackupPlan",
      "backup:CreateBackupSelection"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:backup:*:*:backup-plan:*"
     ]
    },
    {
     "Action":[
      "iam:CreateServiceLinkedRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":[
        "backup.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringLike":{
       "iam:PassedToService":"backup.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/aws-service-role/backup.amazonaws.com/AWSServiceRoleForBackup"
     ]
    },
    {
     "Action":[
      "elasticfilesystem:DescribeFileSystems",
      "elasticfilesystem:CreateReplicationConfiguration",
      "elasticfilesystem:DescribeReplicationConfigurations",
      "elasticfilesystem:DeleteReplicationConfiguration"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-01-10T19:27:33+00:00"
 },
 "AmazonElasticFileSystemsUtils":{
  "CreateDate":"2020-09-29T15:16:47+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ssm:DescribeAssociation",
      "ssm:GetDeployablePatchSnapshotForInstance",
      "ssm:GetDocument",
      "ssm:DescribeDocument",
      "ssm:GetManifest",
      "ssm:GetParameter",
      "ssm:GetParameters",
      "ssm:ListAssociations",
      "ssm:ListInstanceAssociations",
      "ssm:PutInventory",
      "ssm:PutComplianceItems",
      "ssm:PutConfigurePackageResult",
      "ssm:UpdateAssociationStatus",
      "ssm:UpdateInstanceAssociationStatus",
      "ssm:UpdateInstanceInformation"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ssmmessages:CreateControlChannel",
      "ssmmessages:CreateDataChannel",
      "ssmmessages:OpenControlChannel",
      "ssmmessages:OpenDataChannel"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2messages:AcknowledgeMessage",
      "ec2messages:DeleteMessage",
      "ec2messages:FailMessage",
      "ec2messages:GetEndpoint",
      "ec2messages:GetMessages",
      "ec2messages:SendReply"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "elasticfilesystem:DescribeMountTargets"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:DescribeAvailabilityZones"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "logs:PutLogEvents",
      "logs:DescribeLogStreams",
      "logs:DescribeLogGroups",
      "logs:CreateLogStream",
      "logs:CreateLogGroup",
      "logs:PutRetentionPolicy"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-09-29T15:16:47+00:00"
 },
 "AmazonElasticMapReduceEditorsRole":{
  "CreateDate":"2018-11-16T21:55:25+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:AuthorizeSecurityGroupEgress",
      "ec2:AuthorizeSecurityGroupIngress",
      "ec2:CreateSecurityGroup",
      "ec2:DescribeSecurityGroups",
      "ec2:RevokeSecurityGroupEgress",
      "ec2:CreateNetworkInterface",
      "ec2:CreateNetworkInterfacePermission",
      "ec2:DeleteNetworkInterface",
      "ec2:DeleteNetworkInterfacePermission",
      "ec2:DescribeNetworkInterfaces",
      "ec2:ModifyNetworkInterfaceAttribute",
      "ec2:DescribeTags",
      "ec2:DescribeInstances",
      "ec2:DescribeSubnets",
      "elasticmapreduce:ListInstances",
      "elasticmapreduce:DescribeCluster"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"ec2:CreateTags",
     "Condition":{
      "ForAllValues:StringEquals":{
       "aws:TagKeys":[
        "aws:elasticmapreduce:editor-id",
        "aws:elasticmapreduce:job-flow-id"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:network-interface/*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2018-11-16T21:55:25+00:00"
 },
 "AmazonElasticMapReduceFullAccess":{
  "CreateDate":"2015-02-06T18:40:22+00:00",
  "DefaultVersionId":"v7",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cloudwatch:*",
      "cloudformation:CreateStack",
      "cloudformation:DescribeStackEvents",
      "ec2:AuthorizeSecurityGroupIngress",
      "ec2:AuthorizeSecurityGroupEgress",
      "ec2:CancelSpotInstanceRequests",
      "ec2:CreateRoute",
      "ec2:CreateSecurityGroup",
      "ec2:CreateTags",
      "ec2:DeleteRoute",
      "ec2:DeleteTags",
      "ec2:DeleteSecurityGroup",
      "ec2:DescribeAvailabilityZones",
      "ec2:DescribeAccountAttributes",
      "ec2:DescribeInstances",
      "ec2:DescribeKeyPairs",
      "ec2:DescribeRouteTables",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeSpotInstanceRequests",
      "ec2:DescribeSpotPriceHistory",
      "ec2:DescribeSubnets",
      "ec2:DescribeVpcAttribute",
      "ec2:DescribeVpcs",
      "ec2:DescribeRouteTables",
      "ec2:DescribeNetworkAcls",
      "ec2:CreateVpcEndpoint",
      "ec2:ModifyImageAttribute",
      "ec2:ModifyInstanceAttribute",
      "ec2:RequestSpotInstances",
      "ec2:RevokeSecurityGroupEgress",
      "ec2:RunInstances",
      "ec2:TerminateInstances",
      "elasticmapreduce:*",
      "iam:GetPolicy",
      "iam:GetPolicyVersion",
      "iam:ListRoles",
      "iam:PassRole",
      "kms:List*",
      "s3:*",
      "sdb:*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringLike":{
       "iam:AWSServiceName":[
        "elasticmapreduce.amazonaws.com",
        "elasticmapreduce.amazonaws.com.cn"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-10-11T15:19:30+00:00"
 },
 "AmazonElasticMapReducePlacementGroupPolicy":{
  "CreateDate":"2020-09-29T00:37:08+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:DeletePlacementGroup",
      "ec2:DescribePlacementGroups"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:CreatePlacementGroup"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:placement-group/EMR_*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-09-29T00:37:08+00:00"
 },
 "AmazonElasticMapReduceReadOnlyAccess":{
  "CreateDate":"2015-02-06T18:40:23+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "elasticmapreduce:Describe*",
      "elasticmapreduce:List*",
      "elasticmapreduce:GetBlockPublicAccessConfiguration",
      "elasticmapreduce:ViewEventsFromAllClustersInConsole",
      "s3:GetObject",
      "s3:ListAllMyBuckets",
      "s3:ListBucket",
      "sdb:Select",
      "cloudwatch:GetMetricStatistics"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-07-29T23:14:09+00:00"
 },
 "AmazonElasticMapReduceRole":{
  "CreateDate":"2015-02-06T18:41:20+00:00",
  "DefaultVersionId":"v10",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:AuthorizeSecurityGroupEgress",
      "ec2:AuthorizeSecurityGroupIngress",
      "ec2:CancelSpotInstanceRequests",
      "ec2:CreateFleet",
      "ec2:CreateLaunchTemplate",
      "ec2:CreateNetworkInterface",
      "ec2:CreateSecurityGroup",
      "ec2:CreateTags",
      "ec2:DeleteLaunchTemplate",
      "ec2:DeleteNetworkInterface",
      "ec2:DeleteSecurityGroup",
      "ec2:DeleteTags",
      "ec2:DescribeAvailabilityZones",
      "ec2:DescribeAccountAttributes",
      "ec2:DescribeDhcpOptions",
      "ec2:DescribeImages",
      "ec2:DescribeInstanceStatus",
      "ec2:DescribeInstances",
      "ec2:DescribeKeyPairs",
      "ec2:DescribeLaunchTemplates",
      "ec2:DescribeNetworkAcls",
      "ec2:DescribeNetworkInterfaces",
      "ec2:DescribePrefixLists",
      "ec2:DescribeRouteTables",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeSpotInstanceRequests",
      "ec2:DescribeSpotPriceHistory",
      "ec2:DescribeSubnets",
      "ec2:DescribeTags",
      "ec2:DescribeVpcAttribute",
      "ec2:DescribeVpcEndpoints",
      "ec2:DescribeVpcEndpointServices",
      "ec2:DescribeVpcs",
      "ec2:DetachNetworkInterface",
      "ec2:ModifyImageAttribute",
      "ec2:ModifyInstanceAttribute",
      "ec2:RequestSpotInstances",
      "ec2:RevokeSecurityGroupEgress",
      "ec2:RunInstances",
      "ec2:TerminateInstances",
      "ec2:DeleteVolume",
      "ec2:DescribeVolumeStatus",
      "ec2:DescribeVolumes",
      "ec2:DetachVolume",
      "iam:GetRole",
      "iam:GetRolePolicy",
      "iam:ListInstanceProfiles",
      "iam:ListRolePolicies",
      "iam:PassRole",
      "s3:CreateBucket",
      "s3:Get*",
      "s3:List*",
      "sdb:BatchPutAttributes",
      "sdb:Select",
      "sqs:CreateQueue",
      "sqs:Delete*",
      "sqs:GetQueue*",
      "sqs:PurgeQueue",
      "sqs:ReceiveMessage",
      "cloudwatch:PutMetricAlarm",
      "cloudwatch:DescribeAlarms",
      "cloudwatch:DeleteAlarms",
      "application-autoscaling:RegisterScalableTarget",
      "application-autoscaling:DeregisterScalableTarget",
      "application-autoscaling:PutScalingPolicy",
      "application-autoscaling:DeleteScalingPolicy",
      "application-autoscaling:Describe*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringLike":{
       "iam:AWSServiceName":"spot.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/aws-service-role/spot.amazonaws.com/AWSServiceRoleForEC2Spot*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-06-24T22:24:20+00:00"
 },
 "AmazonElasticMapReduceforAutoScalingRole":{
  "CreateDate":"2016-11-18T01:09:10+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cloudwatch:DescribeAlarms",
      "elasticmapreduce:ListInstanceGroups",
      "elasticmapreduce:ModifyInstanceGroups"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2016-11-18T01:09:10+00:00"
 },
 "AmazonElasticMapReduceforEC2Role":{
  "CreateDate":"2015-02-06T18:41:21+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cloudwatch:*",
      "dynamodb:*",
      "ec2:Describe*",
      "elasticmapreduce:Describe*",
      "elasticmapreduce:ListBootstrapActions",
      "elasticmapreduce:ListClusters",
      "elasticmapreduce:ListInstanceGroups",
      "elasticmapreduce:ListInstances",
      "elasticmapreduce:ListSteps",
      "kinesis:CreateStream",
      "kinesis:DeleteStream",
      "kinesis:DescribeStream",
      "kinesis:GetRecords",
      "kinesis:GetShardIterator",
      "kinesis:MergeShards",
      "kinesis:PutRecord",
      "kinesis:SplitShard",
      "rds:Describe*",
      "s3:*",
      "sdb:*",
      "sns:*",
      "sqs:*",
      "glue:CreateDatabase",
      "glue:UpdateDatabase",
      "glue:DeleteDatabase",
      "glue:GetDatabase",
      "glue:GetDatabases",
      "glue:CreateTable",
      "glue:UpdateTable",
      "glue:DeleteTable",
      "glue:GetTable",
      "glue:GetTables",
      "glue:GetTableVersions",
      "glue:CreatePartition",
      "glue:BatchCreatePartition",
      "glue:UpdatePartition",
      "glue:DeletePartition",
      "glue:BatchDeletePartition",
      "glue:GetPartition",
      "glue:GetPartitions",
      "glue:BatchGetPartition",
      "glue:CreateUserDefinedFunction",
      "glue:UpdateUserDefinedFunction",
      "glue:DeleteUserDefinedFunction",
      "glue:GetUserDefinedFunction",
      "glue:GetUserDefinedFunctions"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2017-08-11T23:57:30+00:00"
 },
 "AmazonElasticTranscoderRole":{
  "CreateDate":"2015-02-06T18:41:26+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "s3:ListBucket",
      "s3:Get*",
      "s3:PutObject",
      "s3:PutObjectAcl",
      "s3:*MultipartUpload*"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"1"
    },
    {
     "Action":[
      "sns:Publish"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"2"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-06-13T22:48:22+00:00"
 },
 "AmazonElasticTranscoder_FullAccess":{
  "CreateDate":"2018-04-27T18:59:35+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "elastictranscoder:*",
      "s3:ListAllMyBuckets",
      "s3:ListBucket",
      "iam:ListRoles",
      "sns:ListTopics"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringLike":{
       "iam:PassedToService":[
        "elastictranscoder.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-06-10T22:51:51+00:00"
 },
 "AmazonElasticTranscoder_JobsSubmitter":{
  "CreateDate":"2018-06-07T21:12:16+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "elastictranscoder:Read*",
      "elastictranscoder:List*",
      "elastictranscoder:*Job",
      "elastictranscoder:*Preset",
      "s3:ListAllMyBuckets",
      "s3:ListBucket",
      "iam:ListRoles",
      "sns:ListTopics"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-06-10T22:49:34+00:00"
 },
 "AmazonElasticTranscoder_ReadOnlyAccess":{
  "CreateDate":"2018-06-07T21:09:56+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "elastictranscoder:Read*",
      "elastictranscoder:List*",
      "s3:ListAllMyBuckets",
      "s3:ListBucket",
      "iam:ListRoles",
      "sns:ListTopics"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-06-10T22:48:32+00:00"
 },
 "AmazonElasticsearchServiceRolePolicy":{
  "CreateDate":"2017-07-07T00:15:31+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:CreateNetworkInterface",
      "ec2:DeleteNetworkInterface",
      "ec2:DescribeNetworkInterfaces",
      "ec2:ModifyNetworkInterfaceAttribute",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeSubnets",
      "ec2:DescribeVpcs",
      "elasticloadbalancing:AddListenerCertificates",
      "elasticloadbalancing:RemoveListenerCertificates"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"Stmt1480452973134"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-08-31T10:30:23+00:00"
 },
 "AmazonEventBridgeApiDestinationsServiceRolePolicy":{
  "CreateDate":"2021-02-11T20:52:05+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "secretsmanager:CreateSecret",
      "secretsmanager:UpdateSecret",
      "secretsmanager:DescribeSecret",
      "secretsmanager:DeleteSecret",
      "secretsmanager:GetSecretValue",
      "secretsmanager:PutSecretValue"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:secretsmanager:*:*:secret:events!connection/*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-02-11T20:52:05+00:00"
 },
 "AmazonEventBridgeFullAccess":{
  "CreateDate":"2019-07-11T14:08:55+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":"events:*",
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":"apidestinations.events.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/aws-service-role/AmazonEventBridgeApiDestinationsServiceRolePolicy"
    },
    {
     "Action":[
      "secretsmanager:CreateSecret",
      "secretsmanager:UpdateSecret",
      "secretsmanager:DeleteSecret",
      "secretsmanager:GetSecretValue",
      "secretsmanager:PutSecretValue"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:secretsmanager:*:*:secret:events!*"
    },
    {
     "Action":"iam:PassRole",
     "Condition":{
      "StringLike":{
       "iam:PassedToService":"events.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-03-04T18:56:38+00:00"
 },
 "AmazonEventBridgeReadOnlyAccess":{
  "CreateDate":"2019-07-11T13:59:07+00:00",
  "DefaultVersionId":"v4",
  "Document":{
   "Statement":[
    {
     "Action":[
      "events:DescribeRule",
      "events:DescribeEventBus",
      "events:DescribeEventSource",
      "events:ListEventBuses",
      "events:ListEventSources",
      "events:ListRuleNamesByTarget",
      "events:ListRules",
      "events:ListTargetsByRule",
      "events:TestEventPattern",
      "events:DescribeArchive",
      "events:ListArchives",
      "events:DescribeReplay",
      "events:ListReplays",
      "events:DescribeConnection",
      "events:ListConnections",
      "events:DescribeApiDestination",
      "events:ListApiDestinations",
      "events:DescribeEndpoint",
      "events:ListEndpoints"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-04-08T20:42:18+00:00"
 },
 "AmazonEventBridgeSchemasFullAccess":{
  "CreateDate":"2019-11-28T23:12:53+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "schemas:*"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AmazonEventBridgeSchemasFullAccess"
    },
    {
     "Action":[
      "events:PutRule",
      "events:PutTargets",
      "events:EnableRule",
      "events:DisableRule",
      "events:DeleteRule",
      "events:RemoveTargets",
      "events:ListTargetsByRule"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:events:*:*:rule/*Schemas*",
     "Sid":"AmazonEventBridgeManageRule"
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/aws-service-role/schemas.amazonaws.com/AWSServiceRoleForSchemas",
     "Sid":"IAMCreateServiceLinkedRoleForAmazonEventBridgeSchemas"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-11-28T23:12:53+00:00"
 },
 "AmazonEventBridgeSchemasReadOnlyAccess":{
  "CreateDate":"2019-11-28T23:05:57+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "schemas:ListDiscoverers",
      "schemas:DescribeDiscoverer",
      "schemas:ListRegistries",
      "schemas:DescribeRegistry",
      "schemas:SearchSchemas",
      "schemas:ListSchemas",
      "schemas:ListSchemaVersions",
      "schemas:DescribeSchema",
      "schemas:GetDiscoveredSchema",
      "schemas:DescribeCodeBinding",
      "schemas:GetCodeBindingSource",
      "schemas:ListTagsForResource",
      "schemas:GetResourcePolicy"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AmazonEventBridgeSchemasReadOnlyAccess"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-05-01T00:50:53+00:00"
 },
 "AmazonEventBridgeSchemasServiceRolePolicy":{
  "CreateDate":"2019-11-27T01:10:40+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "events:PutRule",
      "events:PutTargets",
      "events:EnableRule",
      "events:DisableRule",
      "events:DeleteRule",
      "events:RemoveTargets",
      "events:ListTargetsByRule"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:events:*:*:rule/*Schemas-*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-11-27T01:10:40+00:00"
 },
 "AmazonFISServiceRolePolicy":{
  "CreateDate":"2020-12-21T21:18:19+00:00",
  "DefaultVersionId":"v5",
  "Document":{
   "Statement":[
    {
     "Action":[
      "events:PutRule",
      "events:DeleteRule",
      "events:PutTargets",
      "events:RemoveTargets"
     ],
     "Condition":{
      "StringEquals":{
       "events:ManagedBy":"fis.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"EventBridge"
    },
    {
     "Action":[
      "events:DescribeRule"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"EventBridgeDescribe"
    },
    {
     "Action":[
      "tag:GetResources"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"Tagging"
    },
    {
     "Action":[
      "cloudwatch:DescribeAlarms",
      "cloudwatch:DescribeAlarmHistory"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CloudWatch"
    },
    {
     "Action":[
      "ec2:DescribeInstances",
      "iam:GetUser",
      "iam:GetRole",
      "iam:ListUsers",
      "iam:ListRoles",
      "rds:DescribeDBClusters",
      "rds:DescribeDBInstances",
      "ecs:DescribeClusters",
      "ecs:DescribeTasks",
      "ecs:ListTasks",
      "eks:DescribeNodegroup"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"DescribeUserResources"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-02-07T11:13:04+00:00"
 },
 "AmazonFSxConsoleFullAccess":{
  "CreateDate":"2018-11-28T16:36:05+00:00",
  "DefaultVersionId":"v5",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cloudwatch:DescribeAlarms",
      "ds:DescribeDirectories",
      "ec2:DescribeNetworkInterfaceAttribute",
      "ec2:DescribeRouteTables",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeSubnets",
      "ec2:DescribeVpcs",
      "firehose:ListDeliveryStreams",
      "fsx:*",
      "kms:ListAliases",
      "logs:DescribeLogGroups",
      "s3:ListBucket"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":[
        "fsx.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":[
        "s3.data-source.lustre.fsx.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:CreateTags"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:CalledVia":[
        "fsx.amazonaws.com"
       ]
      },
      "StringEquals":{
       "aws:RequestTag/AmazonFSx":"ManagedByAmazonFSx"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:route-table/*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-08-26T13:18:46+00:00"
 },
 "AmazonFSxConsoleReadOnlyAccess":{
  "CreateDate":"2018-11-28T16:35:24+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cloudwatch:DescribeAlarms",
      "ds:DescribeDirectories",
      "ec2:DescribeNetworkInterfaceAttribute",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeSubnets",
      "ec2:DescribeVpcs",
      "firehose:ListDeliveryStreams",
      "fsx:Describe*",
      "fsx:ListTagsForResource",
      "kms:DescribeKey",
      "logs:DescribeLogGroups"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-06-08T12:21:09+00:00"
 },
 "AmazonFSxFullAccess":{
  "CreateDate":"2018-11-28T16:34:43+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ds:DescribeDirectories",
      "fsx:*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":[
        "fsx.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":[
        "s3.data-source.lustre.fsx.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "logs:CreateLogGroup",
      "logs:CreateLogStream",
      "logs:PutLogEvents"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:logs:*:*:log-group:/aws/fsx/*:log-group:*"
     ]
    },
    {
     "Action":[
      "firehose:PutRecord"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:firehose:*:*:deliverystream/aws-fsx-*"
     ]
    },
    {
     "Action":[
      "ec2:CreateTags"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:CalledVia":[
        "fsx.amazonaws.com"
       ]
      },
      "StringEquals":{
       "aws:RequestTag/AmazonFSx":"ManagedByAmazonFSx"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:route-table/*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-08-26T13:17:29+00:00"
 },
 "AmazonFSxReadOnlyAccess":{
  "CreateDate":"2018-11-28T16:33:32+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "fsx:Describe*",
      "fsx:ListTagsForResource"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2018-11-28T16:33:32+00:00"
 },
 "AmazonFSxServiceRolePolicy":{
  "CreateDate":"2018-11-28T10:38:37+00:00",
  "DefaultVersionId":"v5",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cloudwatch:PutMetricData",
      "ds:AuthorizeApplication",
      "ds:GetAuthorizedApplicationDetails",
      "ds:UnauthorizeApplication",
      "ec2:CreateNetworkInterface",
      "ec2:CreateNetworkInterfacePermission",
      "ec2:DeleteNetworkInterface",
      "ec2:DescribeAddresses",
      "ec2:DescribeDhcpOptions",
      "ec2:DescribeNetworkInterfaces",
      "ec2:DescribeRouteTables",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeSubnets",
      "ec2:DescribeVpcs",
      "ec2:DisassociateAddress",
      "route53:AssociateVPCWithHostedZone"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:CreateTags"
     ],
     "Condition":{
      "ForAllValues:StringEquals":{
       "aws:TagKeys":"AmazonFSx.FileSystemId"
      },
      "StringEquals":{
       "ec2:CreateAction":"CreateNetworkInterface"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:network-interface/*"
     ]
    },
    {
     "Action":[
      "ec2:AssignPrivateIpAddresses",
      "ec2:ModifyNetworkInterfaceAttribute",
      "ec2:UnassignPrivateIpAddresses"
     ],
     "Condition":{
      "Null":{
       "aws:ResourceTag/AmazonFSx.FileSystemId":"false"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:network-interface/*"
     ]
    },
    {
     "Action":[
      "ec2:CreateRoute",
      "ec2:ReplaceRoute",
      "ec2:DeleteRoute"
     ],
     "Condition":{
      "StringEquals":{
       "aws:ResourceTag/AmazonFSx":"ManagedByAmazonFSx"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:route-table/*"
     ]
    },
    {
     "Action":[
      "logs:DescribeLogGroups",
      "logs:DescribeLogStreams",
      "logs:PutLogEvents"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:logs:*:*:log-group:/aws/fsx/*"
    },
    {
     "Action":[
      "firehose:DescribeDeliveryStream",
      "firehose:PutRecord",
      "firehose:PutRecordBatch"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:firehose:*:*:deliverystream/aws-fsx-*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-08-20T12:51:29+00:00"
 },
 "AmazonForecastFullAccess":{
  "CreateDate":"2019-01-18T01:52:29+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "forecast:*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":"forecast.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-01-18T01:52:29+00:00"
 },
 "AmazonFraudDetectorFullAccessPolicy":{
  "CreateDate":"2019-12-03T22:46:26+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "frauddetector:*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "sagemaker:ListEndpoints",
      "sagemaker:DescribeEndpoint"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "s3:ListAllMyBuckets",
      "s3:GetBucketLocation"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "iam:ListRoles"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":"frauddetector.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-12-03T22:46:26+00:00"
 },
 "AmazonFreeRTOSFullAccess":{
  "CreateDate":"2017-11-29T15:32:51+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "freertos:*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2017-11-29T15:32:51+00:00"
 },
 "AmazonFreeRTOSOTAUpdate":{
  "CreateDate":"2018-08-27T22:43:07+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "s3:GetObjectVersion",
      "s3:PutObject",
      "s3:GetObject"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::afr-ota*"
    },
    {
     "Action":[
      "signer:StartSigningJob",
      "signer:DescribeSigningJob",
      "signer:GetSigningProfile",
      "signer:PutSigningProfile"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "s3:ListBucketVersions",
      "s3:ListBucket",
      "s3:ListAllMyBuckets",
      "s3:GetBucketLocation"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "iot:DeleteJob",
      "iot:DescribeJob"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:iot:*:*:job/AFR_OTA*"
    },
    {
     "Action":[
      "iot:DeleteStream"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:iot:*:*:stream/AFR_OTA*"
    },
    {
     "Action":[
      "iot:CreateStream",
      "iot:CreateJob"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-12-18T17:47:30+00:00"
 },
 "AmazonGlacierFullAccess":{
  "CreateDate":"2015-02-06T18:40:28+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":"glacier:*",
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2015-02-06T18:40:28+00:00"
 },
 "AmazonGlacierReadOnlyAccess":{
  "CreateDate":"2015-02-06T18:40:27+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "glacier:DescribeJob",
      "glacier:DescribeVault",
      "glacier:GetDataRetrievalPolicy",
      "glacier:GetJobOutput",
      "glacier:GetVaultAccessPolicy",
      "glacier:GetVaultLock",
      "glacier:GetVaultNotifications",
      "glacier:ListJobs",
      "glacier:ListMultipartUploads",
      "glacier:ListParts",
      "glacier:ListTagsForVault",
      "glacier:ListVaults"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2016-05-05T18:46:10+00:00"
 },
 "AmazonGrafanaAthenaAccess":{
  "CreateDate":"2021-11-22T17:11:11+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "athena:GetDatabase",
      "athena:GetDataCatalog",
      "athena:GetTableMetadata",
      "athena:ListDatabases",
      "athena:ListDataCatalogs",
      "athena:ListTableMetadata",
      "athena:ListWorkGroups"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "athena:GetQueryExecution",
      "athena:GetQueryResults",
      "athena:GetWorkGroup",
      "athena:StartQueryExecution",
      "athena:StopQueryExecution"
     ],
     "Condition":{
      "Null":{
       "aws:ResourceTag/GrafanaDataSource":"false"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "glue:GetDatabase",
      "glue:GetDatabases",
      "glue:GetTable",
      "glue:GetTables",
      "glue:GetPartition",
      "glue:GetPartitions",
      "glue:BatchGetPartition"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "s3:GetBucketLocation",
      "s3:GetObject",
      "s3:ListBucket",
      "s3:ListBucketMultipartUploads",
      "s3:ListMultipartUploadParts",
      "s3:AbortMultipartUpload",
      "s3:CreateBucket",
      "s3:PutObject",
      "s3:PutBucketPublicAccessBlock"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::grafana-athena-query-results-*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-11-22T17:11:11+00:00"
 },
 "AmazonGrafanaRedshiftAccess":{
  "CreateDate":"2021-11-26T23:15:15+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "redshift:DescribeClusters",
      "redshift-data:GetStatementResult",
      "redshift-data:DescribeStatement",
      "secretsmanager:ListSecrets"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "redshift-data:DescribeTable",
      "redshift-data:ExecuteStatement",
      "redshift-data:ListTables",
      "redshift-data:ListSchemas"
     ],
     "Condition":{
      "Null":{
       "aws:ResourceTag/GrafanaDataSource":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"redshift:GetClusterCredentials",
     "Effect":"Allow",
     "Resource":[
      "arn:aws:redshift:*:*:dbname:*/*",
      "arn:aws:redshift:*:*:dbuser:*/redshift_data_api_user"
     ]
    },
    {
     "Action":[
      "secretsmanager:GetSecretValue"
     ],
     "Condition":{
      "Null":{
       "secretsmanager:ResourceTag/RedshiftQueryOwner":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-11-26T23:15:15+00:00"
 },
 "AmazonGuardDutyFullAccess":{
  "CreateDate":"2017-11-28T22:31:30+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":"guardduty:*",
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringLike":{
       "iam:AWSServiceName":"guardduty.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "organizations:EnableAWSServiceAccess",
      "organizations:RegisterDelegatedAdministrator",
      "organizations:ListDelegatedAdministrators",
      "organizations:ListAWSServiceAccessForOrganization",
      "organizations:DescribeOrganizationalUnit",
      "organizations:DescribeAccount",
      "organizations:DescribeOrganization"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-02-16T23:39:53+00:00"
 },
 "AmazonGuardDutyReadOnlyAccess":{
  "CreateDate":"2017-11-28T22:29:40+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "guardduty:Describe*",
      "guardduty:Get*",
      "guardduty:List*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "organizations:ListDelegatedAdministrators",
      "organizations:ListAWSServiceAccessForOrganization",
      "organizations:DescribeOrganizationalUnit",
      "organizations:DescribeAccount",
      "organizations:DescribeOrganization"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-02-16T23:37:57+00:00"
 },
 "AmazonGuardDutyServiceRolePolicy":{
  "CreateDate":"2017-11-28T20:12:59+00:00",
  "DefaultVersionId":"v4",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:DescribeInstances",
      "ec2:DescribeImages",
      "ec2:DescribeVpcEndpoints",
      "ec2:DescribeSubnets",
      "ec2:DescribeVpcPeeringConnections",
      "ec2:DescribeTransitGatewayAttachments",
      "organizations:ListAccounts",
      "organizations:DescribeAccount",
      "s3:GetBucketPublicAccessBlock",
      "s3:GetEncryptionConfiguration",
      "s3:GetBucketTagging",
      "s3:GetAccountPublicAccessBlock",
      "s3:ListAllMyBuckets",
      "s3:GetBucketAcl",
      "s3:GetBucketPolicy",
      "s3:GetBucketPolicyStatus"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-08-03T23:14:07+00:00"
 },
 "AmazonHealthLakeFullAccess":{
  "CreateDate":"2021-02-17T01:07:05+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "healthlake:*",
      "s3:ListAllMyBuckets",
      "s3:ListBucket",
      "s3:GetBucketLocation",
      "iam:ListRoles"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"iam:PassRole",
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":"healthlake.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-02-17T01:07:05+00:00"
 },
 "AmazonHealthLakeReadOnlyAccess":{
  "CreateDate":"2021-02-17T02:43:31+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "healthlake:ListFHIRDatastores",
      "healthlake:DescribeFHIRDatastore",
      "healthlake:DescribeFHIRImportJob",
      "healthlake:DescribeFHIRExportJob",
      "healthlake:GetCapabilities",
      "healthlake:ReadResource",
      "healthlake:SearchWithGet",
      "healthlake:SearchWithPost"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-02-17T02:43:31+00:00"
 },
 "AmazonHoneycodeFullAccess":{
  "CreateDate":"2020-06-24T20:28:11+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "honeycode:*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-06-24T20:28:11+00:00"
 },
 "AmazonHoneycodeReadOnlyAccess":{
  "CreateDate":"2020-06-24T20:28:16+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "honeycode:List*",
      "honeycode:Get*",
      "honeycode:Describe*",
      "honeycode:Query*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-12-01T17:27:53+00:00"
 },
 "AmazonHoneycodeServiceRolePolicy":{
  "CreateDate":"2020-11-18T18:03:08+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "sso:GetManagedApplicationInstance"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-11-18T18:03:08+00:00"
 },
 "AmazonHoneycodeTeamAssociationFullAccess":{
  "CreateDate":"2020-06-24T20:28:27+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "honeycode:ListTeamAssociations",
      "honeycode:ApproveTeamAssociation",
      "honeycode:RejectTeamAssociation"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-06-24T20:28:27+00:00"
 },
 "AmazonHoneycodeTeamAssociationReadOnlyAccess":{
  "CreateDate":"2020-06-24T20:27:46+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "honeycode:ListTeamAssociations"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-06-24T20:27:46+00:00"
 },
 "AmazonHoneycodeWorkbookFullAccess":{
  "CreateDate":"2020-06-24T20:28:46+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "honeycode:GetScreenData",
      "honeycode:InvokeScreenAutomation",
      "honeycode:BatchCreateTableRows",
      "honeycode:BatchDeleteTableRows",
      "honeycode:BatchUpdateTableRows",
      "honeycode:BatchUpsertTableRows",
      "honeycode:DescribeTableDataImportJob",
      "honeycode:ListTableColumns",
      "honeycode:ListTableRows",
      "honeycode:ListTables",
      "honeycode:QueryTableRows",
      "honeycode:StartTableDataImportJob"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-12-01T17:30:06+00:00"
 },
 "AmazonHoneycodeWorkbookReadOnlyAccess":{
  "CreateDate":"2020-06-24T20:28:07+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "honeycode:GetScreenData",
      "honeycode:DescribeTableDataImportJob",
      "honeycode:ListTableColumns",
      "honeycode:ListTableRows",
      "honeycode:ListTables",
      "honeycode:QueryTableRows"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-12-01T17:32:49+00:00"
 },
 "AmazonInspector2FullAccess":{
  "CreateDate":"2021-11-29T19:10:15+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":"inspector2:*",
     "E