/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import sun.nio.cs.ext.EUC_TW;

public abstract class X11CNS11643
extends Charset {
    private final int plane;

    public X11CNS11643(int plane, String name) {
        super(name, null);
        switch (plane) {
            case 1: {
                this.plane = 0;
                break;
            }
            case 2: 
            case 3: {
                this.plane = plane;
                break;
            }
            default: {
                throw new IllegalArgumentException("Only planes 1, 2, and 3 supported");
            }
        }
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new Encoder(this, this.plane);
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new Decoder(this, this.plane);
    }

    @Override
    public boolean contains(Charset cs) {
        return cs instanceof X11CNS11643;
    }

    private class Decoder
    extends EUC_TW.Decoder {
        int plane;
        private String table;

        protected Decoder(Charset cs, int plane) {
            super(cs);
            if (plane == 0) {
                this.plane = plane;
            } else if (plane == 2 || plane == 3) {
                this.plane = plane - 1;
            } else {
                throw new IllegalArgumentException("Only planes 1, 2, and 3 supported");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected CoderResult decodeLoop(ByteBuffer src, CharBuffer dst) {
            int sp;
            byte[] sa = src.array();
            int sl = src.arrayOffset() + src.limit();
            char[] da = dst.array();
            int dp = dst.arrayOffset() + dst.position();
            int dl = dst.arrayOffset() + dst.limit();
            try {
                for (sp = src.arrayOffset() + src.position(); sp < sl; sp += 2) {
                    if (sl - sp < 2) {
                        CoderResult coderResult = CoderResult.UNDERFLOW;
                        return coderResult;
                    }
                    int b1 = sa[sp] & 0xFF | 0x80;
                    int b2 = sa[sp + 1] & 0xFF | 0x80;
                    char[] cc = this.toUnicode(b1, b2, this.plane);
                    if (cc == null || cc.length == 2) {
                        CoderResult coderResult = CoderResult.unmappableForLength(2);
                        return coderResult;
                    }
                    if (dl - dp < 1) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    da[dp++] = cc[0];
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                src.position(sp - src.arrayOffset());
                dst.position(dp - dst.arrayOffset());
            }
        }
    }

    private class Encoder
    extends EUC_TW.Encoder {
        private int plane;
        private byte[] bb;

        public Encoder(Charset cs, int plane) {
            super(cs);
            this.bb = new byte[4];
            this.plane = plane;
        }

        public boolean canEncode(char c) {
            if (c <= '\u007f') {
                return false;
            }
            int nb = this.toEUC(c, this.bb);
            if (nb == -1) {
                return false;
            }
            int p = 0;
            if (nb == 4) {
                p = (this.bb[1] & 0xFF) - 160;
            }
            return p == this.plane;
        }

        public boolean isLegalReplacement(byte[] repl) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected CoderResult encodeLoop(CharBuffer src, ByteBuffer dst) {
            int sp;
            char[] sa = src.array();
            int sl = src.arrayOffset() + src.limit();
            byte[] da = dst.array();
            int dp = dst.arrayOffset() + dst.position();
            int dl = dst.arrayOffset() + dst.limit();
            try {
                for (sp = src.arrayOffset() + src.position(); sp < sl; ++sp) {
                    int nb;
                    char c = sa[sp];
                    if (c > '\u007f' && c < '\ufffe' && (nb = this.toEUC(c, this.bb)) != -1) {
                        int p = 0;
                        if (nb == 4) {
                            p = (this.bb[1] & 0xFF) - 160;
                        }
                        if (p == this.plane) {
                            if (dl - dp < 2) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            if (nb == 2) {
                                da[dp++] = (byte)(this.bb[0] & 0x7F);
                                da[dp++] = (byte)(this.bb[1] & 0x7F);
                                continue;
                            }
                            da[dp++] = (byte)(this.bb[2] & 0x7F);
                            da[dp++] = (byte)(this.bb[3] & 0x7F);
                            continue;
                        }
                    }
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                src.position(sp - src.arrayOffset());
                dst.position(dp - dst.arrayOffset());
            }
        }
    }
}

