/*
 * Decompiled with CFR 0.152.
 */
package org.openide.text;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.EditorKit;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DocumentLine;
import org.openide.text.DocumentStatus;
import org.openide.text.Line;
import org.openide.text.LineVector;
import org.openide.text.NbDocument;
import org.openide.text.UndoRedoManager;
import org.openide.text.UserQuestionExceptionHandler;
import org.openide.util.Mutex;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.UserQuestionException;
import org.openide.util.Utilities;

final class DocumentOpenClose {
    static final RequestProcessor RP = new RequestProcessor("org.openide.text Document Processing", 1, false, false);
    private static final int NULL_DOCUMENT_CLOSE_DELAY = 1000;
    private static final Logger LOG = CloneableEditorSupport.ERR;
    final CloneableEditorSupport ces;
    final Object lock;
    DocumentStatus documentStatus = DocumentStatus.CLOSED;
    DocumentLoad activeOpen;
    RequestProcessor.Task activeOpenTask;
    DocumentClose activeClose;
    RequestProcessor.Task activeCloseTask;
    Runnable preReloadEDT;
    DocumentLoad activeReload;
    RequestProcessor.Task activeReloadTask;
    DocumentRef docRef;
    final Object docRefLock;
    StyledDocument strongDocRef;
    boolean firingCloseDocument;
    StyledDocument docOpenedWhenFiringCloseDocument;

    static String getSimpleName(Object object) {
        return object != null ? object.getClass().getSimpleName() + "@" + System.identityHashCode(object) : "null";
    }

    DocumentOpenClose(CloneableEditorSupport cloneableEditorSupport) {
        this.ces = cloneableEditorSupport;
        this.lock = cloneableEditorSupport.getLock();
        this.docRefLock = new Object();
    }

    public DocumentStatus getDocumentStatusLA() {
        return this.documentStatus;
    }

    void setDocumentStatusLA(DocumentStatus documentStatus) {
        this.documentStatus = documentStatus;
    }

    StyledDocument getDocument() {
        return this.getRefDocument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StyledDocument getRefDocument() {
        Object object = this.docRefLock;
        synchronized (object) {
            return this.docRef != null ? (StyledDocument)this.docRef.get() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setDocRef(StyledDocument styledDocument) {
        Object object = this.docRefLock;
        synchronized (object) {
            this.docRef = styledDocument != null ? new DocumentRef(styledDocument) : null;
        }
    }

    void setDocumentStronglyReferenced(boolean bl) {
        StyledDocument styledDocument;
        this.strongDocRef = bl ? (styledDocument = this.getRefDocument()) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StyledDocument open() throws IOException {
        RequestProcessor.Task task;
        DocumentLoad documentLoad;
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.log(Level.FINEST, "open() requested by", new Exception());
        }
        Object object = this.lock;
        synchronized (object) {
            StyledDocument styledDocument = this.retainExistingDocLA();
            if (styledDocument != null) {
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.finer("open(): Existing openDoc retained.\n");
                }
                return styledDocument;
            }
            switch (this.documentStatus) {
                case OPENED: {
                    if (LOG.isLoggable(Level.FINER)) {
                        LOG.finer("open(): status OPENED but doc GCed. Schedule close task followed by possible open task\n");
                    }
                    this.closeImplLA(null, false);
                    if (this.activeOpen == null) {
                        this.initLoadTaskLA();
                    }
                    documentLoad = this.activeOpen;
                    task = this.activeOpenTask;
                    break;
                }
                case CLOSED: {
                    if (LOG.isLoggable(Level.FINER)) {
                        LOG.finer("open(): status CLOSED. Schedule a synchronous open task\n");
                    }
                    if (this.activeOpen == null) {
                        this.initLoadTaskLA();
                    }
                    documentLoad = this.activeOpen;
                    task = this.activeOpenTask;
                    break;
                }
                case RELOADING: {
                    documentLoad = this.activeReload;
                    task = this.activeReloadTask;
                    break;
                }
                case LOADING: {
                    documentLoad = this.activeOpen;
                    task = this.activeOpenTask;
                    break;
                }
                default: {
                    throw this.invalidStatus();
                }
            }
        }
        if (documentLoad == null || task == null) {
            LOG.info("load=" + documentLoad + ", task=" + task + ", this: " + this);
        }
        task.waitFinished();
        if (documentLoad.loadIOException != null) {
            throw documentLoad.loadIOException;
        }
        if (documentLoad.loadRuntimeException != null) {
            throw documentLoad.loadRuntimeException;
        }
        return documentLoad.loadDoc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Task openTask() {
        Object object = this.lock;
        synchronized (object) {
            final StyledDocument styledDocument = this.retainExistingDocLA();
            if (styledDocument != null) {
                Task task = new Task(new Runnable(){
                    private final StyledDocument doc;
                    {
                        this.doc = styledDocument;
                    }

                    @Override
                    public void run() {
                    }
                });
                task.run();
                return task;
            }
            if (this.activeOpenTask != null) {
                return this.activeOpenTask;
            }
            switch (this.documentStatus) {
                case OPENED: {
                    this.closeImplLA(null, false);
                    this.initLoadTaskLA();
                    break;
                }
                case CLOSED: {
                    this.initLoadTaskLA();
                    break;
                }
                case RELOADING: {
                    return this.activeReloadTask;
                }
                case LOADING: {
                    assert (this.activeOpenTask != null);
                    break;
                }
                default: {
                    throw this.invalidStatus();
                }
            }
            return this.activeOpenTask;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForCloseFinish() {
        RequestProcessor.Task task;
        Object object = this.lock;
        synchronized (object) {
            task = this.activeCloseTask;
        }
        if (task != null) {
            task.waitFinished();
        }
    }

    boolean isDocumentLoadedOrLoading() {
        this.waitForCloseFinish();
        Object object = this.lock;
        synchronized (object) {
            switch (this.documentStatus) {
                case CLOSED: {
                    return false;
                }
                case OPENED: 
                case RELOADING: 
                case LOADING: {
                    return true;
                }
            }
            throw this.invalidStatus();
        }
    }

    boolean isDocumentOpened() {
        this.waitForCloseFinish();
        Object object = this.lock;
        synchronized (object) {
            switch (this.documentStatus) {
                case CLOSED: 
                case RELOADING: 
                case LOADING: {
                    return false;
                }
                case OPENED: {
                    return true;
                }
            }
            throw this.invalidStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Task reloadTask() {
        Object object = this.lock;
        synchronized (object) {
            if (this.activeReloadTask != null) {
                return this.activeReloadTask;
            }
            return Task.EMPTY;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reload(JEditorPane[] jEditorPaneArray) {
        DocumentLoad documentLoad = null;
        Object object = this.lock;
        synchronized (object) {
            switch (this.documentStatus) {
                case CLOSED: {
                    break;
                }
                case RELOADING: {
                    break;
                }
                case OPENED: 
                case LOADING: {
                    StyledDocument styledDocument;
                    if (this.activeClose != null || this.activeReload != null || (styledDocument = (StyledDocument)this.docRef.get()) == null) break;
                    this.initReloadTaskLA(styledDocument, jEditorPaneArray);
                    documentLoad = this.activeReload;
                    break;
                }
                default: {
                    throw this.invalidStatus();
                }
            }
        }
        if (documentLoad != null) {
            Mutex.EVENT.readAccess(documentLoad);
        }
    }

    private StyledDocument retainExistingDocLA() {
        switch (this.documentStatus) {
            case CLOSED: {
                break;
            }
            case RELOADING: 
            case LOADING: {
                this.cancelCloseLA();
                break;
            }
            case OPENED: {
                StyledDocument styledDocument = this.getRefDocument();
                if (styledDocument == null) break;
                this.cancelCloseLA();
                if (this.activeClose != null) break;
                return styledDocument;
            }
            default: {
                throw this.invalidStatus();
            }
        }
        return null;
    }

    private void initLoadTaskLA() {
        if (this.activeOpen != null) {
            throw new IllegalStateException("Open task already inited. State:\n" + this);
        }
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("initLoadTaskLA(): Schedule open task followed by change firing task.\n");
        }
        this.activeOpen = new DocumentLoad();
        this.activeOpenTask = RP.create((Runnable)this.activeOpen);
        this.activeOpenTask.schedule(0);
        RP.create((Runnable)new DocumentOpenFire(this.activeOpen)).schedule(0);
    }

    private void initReloadTaskLA(StyledDocument styledDocument, JEditorPane[] jEditorPaneArray) {
        assert (this.activeReload == null) : "Reload task already inited.";
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("initLoadTaskLA(): Schedule reload task.\n");
        }
        this.activeReload = new DocumentLoad(styledDocument, jEditorPaneArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        Object object = this.lock;
        synchronized (object) {
            StyledDocument styledDocument = this.getRefDocument();
            this.closeImplLA(styledDocument, styledDocument == null);
        }
    }

    void closeImplLA(StyledDocument styledDocument, boolean bl) {
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.log(Level.FINEST, "Close requested by:\n", new Exception());
        }
        if (this.activeClose != null) {
            if (!bl && this.activeClose.delayedClose) {
                this.cancelCloseLA();
                if (this.activeClose != null) {
                    if (LOG.isLoggable(Level.FINER)) {
                        LOG.finer("closeImplLA(): Delayed active close already running (can't be cancelled). Return.\n");
                    }
                    return;
                }
            } else {
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.finer("closeImplLA(): Close already in progress. Return.\n");
                }
                return;
            }
        }
        assert (this.activeClose == null);
        this.activeClose = new DocumentClose(styledDocument, bl);
        this.activeCloseTask = RP.create((Runnable)this.activeClose);
        int n = bl ? 1000 : 0;
        this.activeCloseTask.schedule(n);
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("closeImplLA(): Scheduled close task with delay=" + n + ".\n");
        }
    }

    void cancelCloseLA() {
        if (LOG.isLoggable(Level.FINER)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.log(Level.FINEST, "cancelCloseLA(): Attempt to cancel close by\n", new Exception());
            } else {
                LOG.finer("cancelCloseLA(): Attempt to cancel close.\n");
            }
        }
        if (this.activeClose != null && this.activeClose.cancel()) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer("cancelCloseLA(): activeClose().cancel() successful.\n");
            }
            this.activeCloseTask.cancel();
            this.activeCloseTask = null;
            this.activeClose = null;
        }
    }

    void updateLines(final StyledDocument styledDocument, final boolean bl) {
        LineVector lineVector = this.ces.findLineVector();
        lineVector.updateLines(new LineVector.LineUpdater(){

            @Override
            public void updateLine(Line line) {
                if (line instanceof DocumentLine) {
                    ((DocumentLine)line).documentOpenedClosed(styledDocument, bl);
                }
            }
        });
    }

    IllegalStateException invalidStatus() {
        return new IllegalStateException("Unknown documentStatus=" + (Object)((Object)this.documentStatus));
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append("DocumentOpenClose: ").append(DocumentOpenClose.getSimpleName((Object)this.ces)).append(", documentStatus=").append((Object)this.documentStatus);
        DocumentRef documentRef = this.docRef;
        stringBuilder.append(", docRef=");
        if (documentRef != null) {
            StyledDocument styledDocument = (StyledDocument)documentRef.get();
            stringBuilder.append("(").append(DocumentOpenClose.getSimpleName(styledDocument)).append(")");
        } else {
            stringBuilder.append("null");
        }
        if (this.activeOpen != null) {
            stringBuilder.append("\n  activeOpen: ").append(this.activeOpen);
        }
        if (this.activeReload != null) {
            stringBuilder.append("\n  activeReload: ").append(this.activeReload);
        }
        if (this.activeClose != null) {
            stringBuilder.append("\n  activeClose: ").append(this.activeClose);
        }
        return stringBuilder.toString();
    }

    private final class DocumentRef
    extends WeakReference<StyledDocument>
    implements Runnable {
        public DocumentRef(StyledDocument styledDocument) {
            super(styledDocument, Utilities.activeReferenceQueue());
            Logger.getLogger("TIMER").log(Level.FINE, "TextDocument", styledDocument);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = DocumentOpenClose.this.lock;
            synchronized (object) {
                if (this == DocumentOpenClose.this.docRef) {
                    DocumentOpenClose.this.closeImplLA(null, true);
                }
            }
        }
    }

    private final class DocumentClose
    implements Runnable {
        final StyledDocument closeDoc;
        final boolean delayedClose;
        boolean cancelled;
        boolean started;
        boolean readLockedRun;

        public DocumentClose(StyledDocument styledDocument, boolean bl) {
            this.closeDoc = styledDocument;
            this.delayedClose = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.readLockedRun) {
                this.readLockedRun = false;
                this.readLockedRun();
                return;
            }
            Object object = DocumentOpenClose.this.lock;
            synchronized (object) {
                if (this.cancelled) {
                    return;
                }
                this.started = true;
            }
            DocumentOpenClose.this.setDocRef(null);
            try {
                DocumentOpenClose.this.ces.setListeningOnEnv(false);
                this.readLockedRun = true;
                if (this.closeDoc != null) {
                    this.closeDoc.render(this);
                }
                DocumentOpenClose.this.ces.updateLineSet(true);
                DocumentOpenClose.this.updateLines(this.closeDoc, true);
            }
            finally {
                object = DocumentOpenClose.this.lock;
                synchronized (object) {
                    DocumentOpenClose.this.documentStatus = DocumentStatus.CLOSED;
                    DocumentOpenClose.this.activeCloseTask = null;
                    DocumentOpenClose.this.activeClose = null;
                }
                DocumentOpenClose.this.firingCloseDocument = true;
                boolean bl = false;
                try {
                    DocumentOpenClose.this.ces.fireDocumentChange(this.closeDoc, true);
                    bl = true;
                }
                finally {
                    DocumentOpenClose.this.firingCloseDocument = false;
                    DocumentOpenClose.this.docOpenedWhenFiringCloseDocument = null;
                    if (LOG.isLoggable(Level.FINER)) {
                        LOG.finer("documentClose(): fireDocumentChange: success=" + bl + "\n");
                    }
                }
            }
        }

        void readLockedRun() {
            DocumentOpenClose.this.ces.callNotifyUnmodified();
            if (this.closeDoc != null) {
                this.closeDoc.removeUndoableEditListener((UndoableEditListener)DocumentOpenClose.this.ces.getUndoRedo());
                DocumentOpenClose.this.ces.removeDocListener(this.closeDoc);
            }
            DocumentOpenClose.this.ces.getPositionManager().documentClosed();
            DocumentOpenClose.this.ces.getUndoRedo().discardAllEdits();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean cancel() {
            Object object = DocumentOpenClose.this.lock;
            synchronized (object) {
                if (this.started) {
                    return false;
                }
                this.cancelled = true;
                return true;
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(200);
            stringBuilder.append("closeDoc=").append(DocumentOpenClose.getSimpleName(this.closeDoc)).append(", delayedClose=").append(this.delayedClose).append(", cancelled=").append(this.cancelled).append(", started=").append(this.started);
            return stringBuilder.toString();
        }
    }

    private static final class DocumentOpenFire
    implements Runnable {
        final DocumentLoad documentOpen;

        public DocumentOpenFire(DocumentLoad documentLoad) {
            this.documentOpen = documentLoad;
        }

        @Override
        public void run() {
            assert (!this.documentOpen.reload) : "This task should not be posted for reloads.";
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer("documentLoad(): Going to fireDocumentChange...\n");
            }
            boolean bl = false;
            try {
                this.documentOpen.fireDocumentChange();
                bl = true;
            }
            finally {
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.finer("documentLoad(): fireDocumentChange: success=" + bl + "\n");
                }
            }
        }
    }

    private final class DocumentLoad
    implements Runnable {
        final boolean reload;
        StyledDocument loadDoc;
        boolean loadSuccess;
        IOException loadIOException;
        RuntimeException loadRuntimeException;
        boolean userQuestionExceptionInReload;
        boolean skipInputStreamReading;
        JEditorPane[] reloadOpenPanes;
        int[] reloadCaretOffsets;
        private boolean atomicLockedRun;
        private boolean preReloadInEDT;

        DocumentLoad() {
            this.reload = false;
        }

        DocumentLoad(StyledDocument styledDocument, JEditorPane[] jEditorPaneArray) {
            assert (styledDocument != null) : "loadDoc cannot be null for reload";
            this.reload = true;
            this.preReloadInEDT = true;
            this.loadDoc = styledDocument;
            this.reloadOpenPanes = jEditorPaneArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.preReloadInEDT) {
                this.preReloadInEDT = false;
                this.preReloadInEDT();
                return;
            }
            if (this.atomicLockedRun) {
                this.atomicLockedRun = false;
                this.atomicLockedRun();
                return;
            }
            try {
                Object object;
                Object object2 = DocumentOpenClose.this.ces.getUndoRedo();
                if (!this.userQuestionExceptionInReload) {
                    object = DocumentOpenClose.this.lock;
                    synchronized (object) {
                        if (this.reload) {
                            assert (DocumentOpenClose.this.documentStatus == DocumentStatus.OPENED) : "Invalid documentStatus=" + (Object)((Object)DocumentOpenClose.this.documentStatus) + " expected OPENED";
                            DocumentOpenClose.this.documentStatus = DocumentStatus.RELOADING;
                        } else {
                            assert (DocumentOpenClose.this.documentStatus == DocumentStatus.CLOSED) : "Invalid documentStatus=" + (Object)((Object)DocumentOpenClose.this.documentStatus) + " expected CLOSED";
                            DocumentOpenClose.this.documentStatus = DocumentStatus.LOADING;
                        }
                    }
                    if (this.reload) {
                        this.loadDoc.removeUndoableEditListener((UndoableEditListener)object2);
                        object2.discardAllEdits();
                    } else {
                        object = DocumentOpenClose.this.lock;
                        synchronized (object) {
                            EditorKit editorKit = DocumentOpenClose.this.ces.createEditorKit();
                            this.loadDoc = DocumentOpenClose.this.ces.createStyledDocument(editorKit);
                            assert (this.loadDoc != null) : "kit.createDefaultDocument() returned null";
                        }
                    }
                }
                this.atomicLockedRun = true;
                NbDocument.runAtomic(this.loadDoc, this);
                if (this.loadIOException == null && this.loadRuntimeException == null) {
                    if (this.reload) {
                        object2.discardAllEdits();
                    } else {
                        DocumentOpenClose.this.ces.setListeningOnEnv(true);
                    }
                    if (object2 instanceof UndoRedoManager) {
                        ((UndoRedoManager)((Object)object2)).markSavepoint();
                    }
                    if (this.loadDoc != null) {
                        LOG.fine("task-addUndoableEditListener");
                        this.loadDoc.addUndoableEditListener((UndoableEditListener)object2);
                    }
                    DocumentOpenClose.this.ces.callNotifyUnmodified();
                    DocumentOpenClose.this.updateLines(this.loadDoc, false);
                    object = DocumentOpenClose.this.lock;
                    synchronized (object) {
                        DocumentOpenClose.this.documentStatus = DocumentStatus.OPENED;
                    }
                    this.loadSuccess = true;
                }
                if (this.reload && this.loadIOException instanceof UserQuestionException) {
                    this.reloadUQEThrown((UserQuestionException)((Object)this.loadIOException));
                }
            }
            catch (RuntimeException runtimeException) {
                this.loadRuntimeException = runtimeException;
            }
            finally {
                if (!this.userQuestionExceptionInReload) {
                    Object object = DocumentOpenClose.this.lock;
                    synchronized (object) {
                        if (!this.loadSuccess) {
                            DocumentOpenClose.this.documentStatus = DocumentStatus.CLOSED;
                            DocumentOpenClose.this.setDocRef(null);
                            DocumentOpenClose.this.ces.setListeningOnEnv(false);
                        }
                        DocumentOpenClose.this.ces.setPreventModification(false);
                        if (this.reload) {
                            DocumentOpenClose.this.activeReloadTask = null;
                            DocumentOpenClose.this.activeReload = null;
                        } else {
                            DocumentOpenClose.this.activeOpenTask = null;
                            DocumentOpenClose.this.activeOpen = null;
                        }
                        if (LOG.isLoggable(Level.FINER)) {
                            LOG.finer("documentLoad(): reload=" + this.reload + ", documentStatus=" + (Object)((Object)DocumentOpenClose.this.documentStatus) + ", loadSuccess=" + this.loadSuccess + "\n");
                        }
                    }
                }
            }
        }

        private void atomicLockedRun() {
            try {
                if (!this.userQuestionExceptionInReload) {
                    if (this.reload) {
                        DocumentOpenClose.this.ces.getPositionManager().documentClosed();
                        DocumentOpenClose.this.ces.updateLineSet(true);
                    }
                    DocumentOpenClose.this.ces.removeDocListener(this.loadDoc);
                    if (this.reload) {
                        LOG.fine("clearDocument");
                        try {
                            if (this.loadDoc.getLength() > 0) {
                                this.loadDoc.remove(0, this.loadDoc.getLength());
                            }
                        }
                        catch (BadLocationException badLocationException) {
                            LOG.log(Level.INFO, null, badLocationException);
                        }
                    }
                } else {
                    this.userQuestionExceptionInReload = false;
                }
                if (!this.skipInputStreamReading) {
                    try (BufferedInputStream bufferedInputStream = new BufferedInputStream(DocumentOpenClose.this.ces.cesEnv().inputStream());){
                        DocumentOpenClose.this.ces.loadFromStreamToKit(this.loadDoc, bufferedInputStream, DocumentOpenClose.this.ces.createEditorKit());
                    }
                }
                DocumentOpenClose.this.setDocRef(this.loadDoc);
                if (this.reload && this.reloadOpenPanes != null) {
                    DocumentOpenClose.this.ces.getPositionManager().documentOpened(new WeakReference<StyledDocument>(this.loadDoc));
                }
                DocumentOpenClose.this.ces.updateLineSet(true);
                DocumentOpenClose.this.ces.updateLastSaveTime();
                DocumentOpenClose.this.ces.addDocListener(this.loadDoc);
                if (this.reload && this.reloadCaretOffsets != null) {
                    int n = this.loadDoc.getLength();
                    final Position[] positionArray = new Position[this.reloadCaretOffsets.length];
                    for (int i = 0; i < this.reloadCaretOffsets.length; ++i) {
                        try {
                            int n2 = this.reloadCaretOffsets[i];
                            n2 = Math.max(Math.min(n2, n), 0);
                            positionArray[i] = this.loadDoc.createPosition(n2);
                            continue;
                        }
                        catch (BadLocationException badLocationException) {
                            positionArray[i] = null;
                        }
                    }
                    Mutex.EVENT.postReadRequest(new Runnable(){

                        @Override
                        public void run() {
                            for (int i = 0; i < DocumentLoad.this.reloadOpenPanes.length; ++i) {
                                JEditorPane jEditorPane = DocumentLoad.this.reloadOpenPanes[i];
                                if (jEditorPane.getDocument() != DocumentLoad.this.loadDoc || positionArray[i] == null) continue;
                                DocumentLoad.this.reloadOpenPanes[i].setCaretPosition(positionArray[i].getOffset());
                            }
                        }
                    });
                }
                DocumentOpenClose.this.ces.setPreventModification(true);
            }
            catch (BadLocationException badLocationException) {
                this.loadRuntimeException = new IllegalStateException(badLocationException);
            }
            catch (IOException iOException) {
                this.loadIOException = iOException;
            }
        }

        void preReloadInEDT() {
            boolean bl = false;
            try {
                this.loadDoc.render(new Runnable(){

                    @Override
                    public void run() {
                        if (DocumentLoad.this.reloadOpenPanes != null) {
                            DocumentLoad.this.reloadCaretOffsets = new int[DocumentLoad.this.reloadOpenPanes.length];
                            for (int i = 0; i < DocumentLoad.this.reloadOpenPanes.length; ++i) {
                                DocumentLoad.this.reloadCaretOffsets[i] = DocumentLoad.this.reloadOpenPanes[i].getCaretPosition();
                            }
                        }
                    }
                });
                DocumentOpenClose.this.activeReloadTask = RP.create((Runnable)this);
                DocumentOpenClose.this.activeReloadTask.schedule(0);
                bl = true;
            }
            finally {
                if (!bl) {
                    DocumentOpenClose.this.activeReload = null;
                    DocumentOpenClose.this.activeReloadTask = null;
                }
            }
        }

        void reloadUQEThrown(UserQuestionException userQuestionException) {
            this.userQuestionExceptionInReload = true;
            UserQuestionExceptionHandler userQuestionExceptionHandler = new UserQuestionExceptionHandler(DocumentOpenClose.this.ces, (UserQuestionException)((Object)this.loadIOException)){

                @Override
                protected StyledDocument openDocument() throws IOException {
                    DocumentLoad.this.loadIOException = null;
                    DocumentOpenClose.this.activeReloadTask.schedule(0);
                    return DocumentLoad.this.loadDoc;
                }

                @Override
                protected void openRefused() {
                    DocumentLoad.this.loadIOException = null;
                    DocumentLoad.this.skipInputStreamReading = true;
                    DocumentOpenClose.this.activeReloadTask.schedule(0);
                }
            };
            userQuestionExceptionHandler.runInEDT();
        }

        void fireDocumentChange() {
            if (this.loadSuccess) {
                DocumentOpenClose.this.ces.fireDocumentChange(this.loadDoc, false);
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(200);
            stringBuilder.append(DocumentOpenClose.getSimpleName(this)).append(": reload=").append(this.reload).append(", loadDoc=").append(DocumentOpenClose.getSimpleName(this.loadDoc)).append(", loadSuccess=").append(this.loadSuccess);
            if (this.reload && this.reloadOpenPanes != null) {
                stringBuilder.append(", reloadOpenPanes.length=").append(this.reloadOpenPanes.length);
            }
            return stringBuilder.toString();
        }
    }
}

