/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.java.impl;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import org.graalvm.visualvm.core.ui.components.SectionSeparator;
import org.graalvm.visualvm.heapviewer.HeapContext;
import org.graalvm.visualvm.heapviewer.java.JavaHeapFragment;
import org.graalvm.visualvm.heapviewer.java.impl.Bundle;
import org.graalvm.visualvm.heapviewer.swing.LinkButton;
import org.graalvm.visualvm.heapviewer.swing.Splitter;
import org.graalvm.visualvm.heapviewer.ui.HeapView;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerActions;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerNodeAction;
import org.graalvm.visualvm.heapviewer.ui.SummaryView;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.HeapSummary;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.JavaClass;
import org.graalvm.visualvm.lib.jfluid.heap.ObjectArrayInstance;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.api.DetailsSupport;
import org.graalvm.visualvm.lib.ui.UIUtils;
import org.graalvm.visualvm.lib.ui.components.HTMLTextArea;
import org.graalvm.visualvm.lib.ui.components.HTMLTextAreaSearchUtils;
import org.graalvm.visualvm.lib.ui.components.ProfilerToolbar;
import org.graalvm.visualvm.lib.ui.swing.renderer.LabelRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.ProfilerRenderer;
import org.graalvm.visualvm.uisupport.SeparatorLine;
import org.graalvm.visualvm.uisupport.VerticalLayout;
import org.openide.util.Exceptions;

class JavaOverviewSummary
extends HeapView {
    private final Object[][] heapData;
    private final Object[][] environmentData;
    private final String vmArgsData;
    private final String modulesData;
    private final String syspropsData;
    private JComponent component;

    private JavaOverviewSummary(HeapContext context) {
        super(Bundle.JavaOverviewSummary_Name(), Bundle.JavaOverviewSummary_Description());
        Heap heap = context.getFragment().getHeap();
        Properties sysprops = heap.getSystemProperties();
        this.heapData = JavaOverviewSummary.computeHeapData(heap);
        this.environmentData = JavaOverviewSummary.computeEnvironmentData(heap, sysprops);
        this.vmArgsData = this.computeVMArgs(heap);
        this.modulesData = this.computeModules(heap);
        this.syspropsData = JavaOverviewSummary.computeSyspropsData(sysprops);
    }

    @Override
    public JComponent getComponent() {
        if (this.component == null) {
            this.init();
        }
        return this.component;
    }

    @Override
    public ProfilerToolbar getToolbar() {
        return null;
    }

    private void init() {
        ResultsSnippet heapSnippet = new ResultsSnippet(Bundle.JavaOverviewSummary_HeapSection(), this.heapData, 0);
        ResultsSnippet environmentSnippet = new ResultsSnippet(Bundle.JavaOverviewSummary_EnvironmentSection(), this.environmentData, 1);
        Splitter overviewRow = new Splitter(1, heapSnippet, environmentSnippet);
        Snippet modulesSnippet = this.modulesData == null ? null : new Snippet(Bundle.JavaOverviewSummary_ModulesSection(), this.modulesData);
        Snippet vmArgsSnippet = this.vmArgsData == null ? null : new Snippet(Bundle.JavaOverviewSummary_VmArgsSection(), this.vmArgsData);
        Snippet syspropsSnippet = new Snippet(Bundle.JavaOverviewSummary_SysPropsSection(), this.syspropsData);
        syspropsSnippet.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.component = new JPanel((LayoutManager)new VerticalLayout(false)){

            @Override
            public Dimension getMinimumSize() {
                Dimension dim = super.getMinimumSize();
                dim.width = 0;
                return dim;
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                dim.width = 100;
                return dim;
            }
        };
        this.component.setOpaque(false);
        this.component.add(overviewRow);
        if (vmArgsSnippet != null) {
            this.component.add(vmArgsSnippet);
        }
        if (modulesSnippet != null) {
            this.component.add(modulesSnippet);
        }
        this.component.add(syspropsSnippet);
    }

    private static Object[][] computeHeapData(Heap heap) {
        int gcroots;
        int nclassloaders;
        NumberFormat numberFormat = (NumberFormat)NumberFormat.getInstance().clone();
        numberFormat.setMaximumFractionDigits(1);
        HeapSummary hsummary = heap.getSummary();
        JavaClass cl = heap.getJavaClassByName("java.lang.ClassLoader");
        if (cl != null) {
            nclassloaders = cl.getInstancesCount();
            Collection jcs = cl.getSubClasses();
            for (JavaClass jc : jcs) {
                nclassloaders += jc.getInstancesCount();
            }
        } else {
            nclassloaders = -1;
        }
        if ((gcroots = heap.getGCRoots().size()) < 1) {
            gcroots = -1;
        }
        return new Object[][]{{Bundle.JavaOverviewSummary_SizeItemString(), JavaOverviewSummary.format(hsummary.getTotalLiveBytes(), numberFormat, " B")}, {Bundle.JavaOverviewSummary_ClassesItemString(), JavaOverviewSummary.format(heap.getAllClasses().size(), numberFormat, null)}, {Bundle.JavaOverviewSummary_InstancesItemString(), JavaOverviewSummary.format(hsummary.getTotalLiveInstances(), numberFormat, null)}, {Bundle.JavaOverviewSummary_ClassloadersItemString(), JavaOverviewSummary.format(nclassloaders, numberFormat, null)}, {Bundle.JavaOverviewSummary_GcRootsItemString(), JavaOverviewSummary.format(gcroots, numberFormat, null)}, {Bundle.JavaOverviewSummary_FinalizersItemString(), JavaOverviewSummary.format(JavaOverviewSummary.computeFinalizers(heap), numberFormat, null)}};
    }

    private static Object[][] computeEnvironmentData(Heap heap, Properties sysprops) {
        String os_patch;
        String uptime;
        HeapSummary hsummary = heap.getSummary();
        long startupTime = JavaOverviewSummary.computeStartupTime(heap);
        String string = uptime = startupTime == -1L ? JavaOverviewSummary.format(startupTime, null, null) : JavaOverviewSummary.getTime(hsummary.getTime() - startupTime);
        if (sysprops == null) {
            return new Object[][]{{Bundle.JavaOverviewSummary_OsItemString(), Bundle.JavaOverviewSummary_NotAvailable()}, {Bundle.JavaOverviewSummary_ArchitectureItemString(), Bundle.JavaOverviewSummary_NotAvailable()}, {Bundle.JavaOverviewSummary_JavaHomeItemString(), Bundle.JavaOverviewSummary_NotAvailable()}, {Bundle.JavaOverviewSummary_JavaVersionItemString(), Bundle.JavaOverviewSummary_NotAvailable()}, {Bundle.JavaOverviewSummary_JvmItemString(), Bundle.JavaOverviewSummary_NotAvailable()}, {Bundle.JavaOverviewSummary_JavaVendorItemString(), Bundle.JavaOverviewSummary_NotAvailable()}, {Bundle.JavaOverviewSummary_UptimeItemString(), uptime}};
        }
        String os = sysprops.getProperty("os.name", Bundle.JavaOverviewSummary_NotAvailable());
        String os_ver = sysprops.getProperty("os.version", "");
        if (!os_ver.isEmpty()) {
            os = os + " (" + os_ver + ")";
        }
        if (!(os_patch = sysprops.getProperty("sun.os.patch.level", "")).isEmpty() && !"unknown".equals(os_patch)) {
            os = os + " " + os_patch;
        }
        String arch = sysprops.getProperty("os.arch", Bundle.JavaOverviewSummary_NotAvailable());
        arch = arch + " " + sysprops.getProperty("sun.arch.data.model", "?") + "bit";
        String home = sysprops.getProperty("java.home", Bundle.JavaOverviewSummary_NotAvailable());
        String version = sysprops.getProperty("java.version", Bundle.JavaOverviewSummary_NotAvailable());
        if ("0".equals(version)) {
            version = Bundle.JavaOverviewSummary_NotAvailable();
        }
        String name = sysprops.getProperty("java.vm.name", Bundle.JavaOverviewSummary_NotAvailable());
        String name_ver = sysprops.getProperty("java.vm.version", "");
        String name_info = sysprops.getProperty("java.vm.info", "");
        name = name_ver.isEmpty() || name_info.isEmpty() ? (name_ver.isEmpty() ? name + " (" + name_info + ")" : name + " (" + name_ver + ")") : name + " (" + name_ver + ", " + name_info + ")";
        String vendor = sysprops.getProperty("java.vendor", Bundle.JavaOverviewSummary_NotAvailable());
        return new Object[][]{{Bundle.JavaOverviewSummary_OsItemString(), os}, {Bundle.JavaOverviewSummary_ArchitectureItemString(), arch}, {Bundle.JavaOverviewSummary_JavaHomeItemString(), home}, {Bundle.JavaOverviewSummary_JavaVersionItemString(), version}, {Bundle.JavaOverviewSummary_JvmItemString(), name}, {Bundle.JavaOverviewSummary_JavaVendorItemString(), vendor}, {Bundle.JavaOverviewSummary_UptimeItemString(), uptime}};
    }

    private static String computeSyspropsData(Properties sysprops) {
        if (sysprops == null) {
            return null;
        }
        TreeSet<Map.Entry<Object, Object>> entries = new TreeSet<Map.Entry<Object, Object>>(new Comparator<Map.Entry<Object, Object>>(){

            @Override
            public int compare(Map.Entry<Object, Object> e1, Map.Entry<Object, Object> e2) {
                return e1.getKey().toString().compareTo(e2.getKey().toString());
            }
        });
        entries.addAll(sysprops.entrySet());
        boolean oddRow = false;
        Color oddRowBackground = UIUtils.getDarker((Color)UIUtils.getProfilerResultsBackground());
        String oddRowBackgroundString = "rgb(" + oddRowBackground.getRed() + "," + oddRowBackground.getGreen() + "," + oddRowBackground.getBlue() + ")";
        StringBuilder sb = new StringBuilder("<table border='0' cellpadding='2' cellspacing='0' width='100%'>");
        for (Map.Entry entry : entries) {
            String val;
            sb.append(oddRow ? "<tr><td style='background-color: " + oddRowBackgroundString + ";'>" : "<tr><td>");
            oddRow = !oddRow;
            String key = entry.getKey().toString();
            String string = val = entry.getValue() == null ? null : entry.getValue().toString();
            if (val != null) {
                if ("line.separator".equals(key)) {
                    val = val.replace("\n", "\\n");
                    val = val.replace("\r", "\\r");
                }
                sb.append("<b>");
                sb.append(key);
                sb.append("</b>=");
                sb.append(val);
            } else {
                sb.append("<b>");
                sb.append(key);
                sb.append("</b>");
            }
            sb.append("</td></tr>");
        }
        sb.append("</table>");
        return JavaOverviewSummary.expandInvalidXMLChars(sb);
    }

    private static long computeFinalizers(Heap heap) {
        Long len;
        Instance queue;
        JavaClass finalizerClass = heap.getJavaClassByName("java.lang.ref.Finalizer");
        if (finalizerClass != null && (queue = (Instance)finalizerClass.getValueOfStaticField("queue")) != null && (len = (Long)queue.getValueOfField("queueLength")) != null) {
            return len;
        }
        return -1L;
    }

    private static long computeStartupTime(Heap heap) {
        Long len;
        Instance runtimeImpl;
        JavaClass jmxFactoryClass = heap.getJavaClassByName("sun.management.ManagementFactoryHelper");
        if (jmxFactoryClass == null) {
            jmxFactoryClass = heap.getJavaClassByName("sun.management.ManagementFactory");
        }
        if (jmxFactoryClass != null && (runtimeImpl = (Instance)jmxFactoryClass.getValueOfStaticField("runtimeMBean")) != null && (len = (Long)runtimeImpl.getValueOfField("vmStartupTime")) != null) {
            return len;
        }
        return -1L;
    }

    private String computeModules(Heap heap) {
        JavaClass resolvedModulesClass = heap.getJavaClassByName("java.lang.module.ResolvedModule");
        if (resolvedModulesClass != null) {
            TreeSet<String> resolvedModules = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            List modules = resolvedModulesClass.getInstances();
            for (Instance module : modules) {
                resolvedModules.add(DetailsSupport.getDetailsString((Instance)module));
            }
            if (resolvedModules.isEmpty()) {
                return null;
            }
            return this.formatModules(resolvedModules);
        }
        return null;
    }

    private String computeVMArgs(Heap heap) {
        Instance vmManagement;
        Object vma;
        ArrayList<String> vmArgsList = new ArrayList<String>();
        JavaClass vmManagementClass = heap.getJavaClassByName("sun.management.VMManagementImpl");
        if (vmManagementClass != null && vmManagementClass.getInstancesCount() > 0 && (vma = (vmManagement = (Instance)vmManagementClass.getInstancesIterator().next()).getValueOfField("vmArgs")) instanceof Instance) {
            Object arr;
            Instance vmargs = (Instance)vma;
            Object list = vmargs.getValueOfField("list");
            Object size = null;
            if (list instanceof Instance) {
                arr = ((Instance)list).getValueOfField("a");
            } else {
                size = vmargs.getValueOfField("size");
                arr = vmargs.getValueOfField("elementData");
            }
            if (arr instanceof ObjectArrayInstance) {
                ObjectArrayInstance vmArgsArr = (ObjectArrayInstance)arr;
                int length = vmArgsArr.getLength();
                List elements = vmArgsArr.getValues();
                if (size instanceof Integer) {
                    length = (Integer)size;
                }
                for (int i = 0; i < length; ++i) {
                    Instance arg = (Instance)elements.get(i);
                    vmArgsList.add(DetailsSupport.getDetailsString((Instance)arg));
                }
                return vmArgsList.isEmpty() ? Bundle.JavaOverviewSummary_NoJvmArguments() : this.formatVMArgs(vmArgsList);
            }
        }
        return null;
    }

    private String formatModules(Collection<String> data) {
        boolean oddRow = false;
        Color oddRowBackground = UIUtils.getDarker((Color)UIUtils.getProfilerResultsBackground());
        String oddRowBackgroundString = "rgb(" + oddRowBackground.getRed() + "," + oddRowBackground.getGreen() + "," + oddRowBackground.getBlue() + ")";
        StringBuilder sb = new StringBuilder("<table border='0' cellpadding='2' cellspacing='0' width='100%'>");
        for (String string : data) {
            sb.append(oddRow ? "<tr><td style='background-color: " + oddRowBackgroundString + ";'>" : "<tr><td>");
            oddRow = !oddRow;
            sb.append(string.replace(" ", "&nbsp;"));
            sb.append("</td></tr>");
        }
        sb.append("</table>");
        return JavaOverviewSummary.expandInvalidXMLChars(sb);
    }

    private final String formatVMArgs(List<String> data) {
        boolean oddRow = false;
        Color oddRowBackground = UIUtils.getDarker((Color)UIUtils.getProfilerResultsBackground());
        String oddRowBackgroundString = "rgb(" + oddRowBackground.getRed() + "," + oddRowBackground.getGreen() + "," + oddRowBackground.getBlue() + ")";
        StringBuilder sb = new StringBuilder("<table border='0' cellpadding='2' cellspacing='0' width='100%'>");
        for (String string : data) {
            sb.append(oddRow ? "<tr><td style='background-color: " + oddRowBackgroundString + ";'>" : "<tr><td>");
            oddRow = !oddRow;
            String key = string;
            int equals = key.indexOf(61);
            if (equals > 0) {
                key = string.substring(0, equals);
                String val = string.substring(equals + 1);
                sb.append("<b>");
                sb.append(key);
                sb.append("</b>=");
                sb.append(val);
            } else {
                sb.append("<b>");
                sb.append(key);
                sb.append("</b>");
            }
            sb.append("</td></tr>");
        }
        sb.append("</table>");
        return JavaOverviewSummary.expandInvalidXMLChars(sb);
    }

    private static String expandInvalidXMLChars(CharSequence chars) {
        StringBuilder text = new StringBuilder(chars.length());
        for (int i = 0; i < chars.length(); ++i) {
            char ch = chars.charAt(i);
            text.append(JavaOverviewSummary.isValidXMLChar(ch) ? Character.valueOf(ch) : "&lt;0x" + Integer.toHexString(0x10000 | ch).substring(1).toUpperCase() + "&gt;");
        }
        return text.toString();
    }

    private static boolean isValidXMLChar(char ch) {
        return ch == '\t' || ch == '\n' || ch == '\r' || ch >= ' ' && ch <= '\ud7ff' || ch >= '\ue000' && ch <= '\ufffd' || ch >= '\u10000' && ch <= '\u10ffff';
    }

    private static String getTime(long millis) {
        String sSeconds;
        long hours = millis / 3600000L;
        String sHours = hours == 0L ? "" : "" + hours;
        long minutes = (millis %= 3600000L) / 60000L;
        String sMinutes = hours > 0L && minutes < 10L ? "0" + minutes : "" + minutes;
        long seconds = (millis %= 60000L) / 1000L;
        String string = sSeconds = seconds < 10L ? "0" + seconds : "" + seconds;
        if (sHours.isEmpty()) {
            return Bundle.JavaOverviewSummary_FORMAT_ms(sMinutes, sSeconds);
        }
        return Bundle.JavaOverviewSummary_FORMAT_hms(sHours, sMinutes, sSeconds);
    }

    private static String format(Number number, NumberFormat format, String suffix) {
        return number.longValue() == -1L ? Bundle.JavaOverviewSummary_NotAvailable() : format.format(number) + (suffix == null ? "" : suffix);
    }

    public static class Provider
    extends SummaryView.ContentProvider {
        @Override
        public HeapView createSummary(String viewID, HeapContext context, HeapViewerActions actions, Collection<HeapViewerNodeAction.Provider> actionProviders) {
            if (JavaHeapFragment.isJavaHeap(context)) {
                return new JavaOverviewSummary(context);
            }
            return null;
        }
    }

    private static class HorizontalScroller
    extends JScrollPane {
        HorizontalScroller(JComponent view) {
            super(view, 21, 30);
            this.setBorder(BorderFactory.createEmptyBorder());
            this.setViewportBorder(BorderFactory.createEmptyBorder());
            this.getViewport().setOpaque(false);
            this.setOpaque(false);
            super.addMouseWheelListener(new MouseWheelListener(){

                @Override
                public void mouseWheelMoved(MouseWheelEvent e) {
                    if (e.getModifiers() == 1) {
                        HorizontalScroller.scroll(this.getHorizontalScrollBar(), e);
                    } else {
                        this.getParent().dispatchEvent(e);
                    }
                }
            });
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension size = this.getViewport().getView().getPreferredSize();
            if (this.getHorizontalScrollBar().isVisible()) {
                size.height += this.getHorizontalScrollBar().getPreferredSize().height;
            }
            return size;
        }

        @Override
        public void addMouseWheelListener(MouseWheelListener l) {
        }

        private static void scroll(JScrollBar scroller, MouseWheelEvent event) {
            if (event.getScrollType() == 0) {
                int unitsToScroll = event.getUnitsToScroll();
                if (unitsToScroll != 0) {
                    int newValue;
                    int direction = unitsToScroll < 0 ? -1 : 1;
                    int increment = scroller.getUnitIncrement(direction);
                    int amount = 1;
                    int oldValue = scroller.getValue();
                    if (oldValue != (newValue = oldValue + increment * amount * direction)) {
                        scroller.setValue(newValue);
                    }
                }
                event.consume();
            }
        }

        @Override
        protected JViewport createViewport() {
            return new JViewport(){

                @Override
                public void scrollRectToVisible(Rectangle aRect) {
                    if (this.getView() instanceof JTextComponent) {
                        try {
                            JTextComponent tc = (JTextComponent)this.getView();
                            Caret caret = tc.getCaret();
                            Rectangle selStart = tc.modelToView(Math.min(caret.getDot(), caret.getMark()));
                            Rectangle selEnd = tc.modelToView(Math.max(caret.getDot(), caret.getMark()));
                            int x = Math.min(selStart.x, selEnd.x);
                            int xx = Math.max(selStart.x + selStart.width, selEnd.x + selEnd.width);
                            int y = Math.min(selStart.y, selEnd.y);
                            int yy = Math.max(selStart.y + selStart.height, selEnd.y + selEnd.height);
                            Rectangle r = new Rectangle(x, y, xx - x, yy - y);
                            super.scrollRectToVisible(SwingUtilities.convertRectangle(tc, r, this));
                        }
                        catch (BadLocationException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    } else {
                        super.scrollRectToVisible(aRect);
                    }
                    aRect = SwingUtilities.convertRectangle(this, aRect, this.getParent());
                    ((JComponent)this.getParent()).scrollRectToVisible(aRect);
                }
            };
        }
    }

    private static class Snippet
    extends JPanel {
        Snippet(String label, String data) {
            super(new GridBagLayout());
            this.setOpaque(false);
            this.setBorder(BorderFactory.createEmptyBorder(0, 5, 15, 5));
            JLabel caption = new JLabel(label);
            caption.setFont(caption.getFont().deriveFont(1));
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.weighty = 1.0;
            this.add((Component)caption, c);
            c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = 0;
            c.insets = new Insets(0, 5, 0, 0);
            this.add((Component)new JLabel("["), c);
            if (data != null) {
                HTMLTextArea htmlArea = new HTMLTextArea(data);
                final JPanel view = new JPanel(new BorderLayout());
                view.setOpaque(false);
                view.add((Component)new HorizontalScroller((JComponent)htmlArea), "Center");
                view.add((Component)HTMLTextAreaSearchUtils.createSearchPanel((HTMLTextArea)htmlArea), "South");
                LinkButton lb = new LinkButton(){
                    {
                        this.clicked();
                    }

                    @Override
                    protected void clicked() {
                        if (view.isVisible()) {
                            this.setText(Bundle.JavaOverviewSummary_LinkShow());
                            view.setVisible(false);
                        } else {
                            this.setText(Bundle.JavaOverviewSummary_LinkHide());
                            view.setVisible(true);
                        }
                    }
                };
                c = new GridBagConstraints();
                c.gridx = 2;
                c.gridy = 0;
                c.insets = new Insets(0, 0, 0, 0);
                this.add((Component)lb, c);
                c = new GridBagConstraints();
                c.gridx = 0;
                c.gridy = 1;
                c.gridwidth = 0;
                c.weightx = 1.0;
                c.weighty = 1.0;
                c.anchor = 18;
                c.fill = 1;
                c.insets = new Insets(6, 0, 0, 0);
                this.add((Component)view, c);
            } else {
                JLabel nal = new JLabel(Bundle.JavaOverviewSummary_NotAvailable());
                nal.setBorder(new LinkButton().getBorder());
                c = new GridBagConstraints();
                c.gridx = 2;
                c.insets = new Insets(0, 0, 0, 0);
                this.add((Component)nal, c);
            }
            c = new GridBagConstraints();
            c.gridx = 3;
            c.gridy = 0;
            c.insets = new Insets(0, 0, 0, 0);
            this.add((Component)new JLabel("]"), c);
            c = new GridBagConstraints();
            c.gridx = 4;
            c.gridy = 0;
            c.weightx = 1.0;
            c.fill = 2;
            c.insets = new Insets(1, 4, 0, 0);
            this.add((Component)new SeparatorLine(), c);
        }

        @Override
        public Dimension getMinimumSize() {
            Dimension dim = super.getMinimumSize();
            dim.width = 0;
            return dim;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dim = super.getPreferredSize();
            dim.width = 100;
            return dim;
        }
    }

    private static class ResultsSnippet
    extends JPanel {
        ResultsSnippet(String text, Object[][] data, int fillerColumn) {
            super(new BorderLayout(0, 6));
            this.setOpaque(false);
            this.setBorder(BorderFactory.createEmptyBorder(10, 5, 5, 5));
            this.add((Component)new SectionSeparator(text), "North");
            DefaultTableModel model = new DefaultTableModel(data, new Object[]{Bundle.JavaOverviewSummary_NameColumn(), Bundle.JavaOverviewSummary_ValueColumn()}){

                @Override
                public boolean isCellEditable(int row, int column) {
                    return false;
                }
            };
            SummaryView.SimpleTable table = new SummaryView.SimpleTable(model, fillerColumn);
            table.setFocusable(false);
            LabelRenderer r1 = new LabelRenderer();
            r1.setFont(r1.getFont().deriveFont(1));
            table.setColumnRenderer(0, (ProfilerRenderer)r1, fillerColumn != 0);
            LabelRenderer r2 = new LabelRenderer();
            r2.setHorizontalAlignment(4);
            table.setColumnRenderer(1, (ProfilerRenderer)r2, fillerColumn != 1);
            this.add((Component)((Object)table), "Center");
        }

        @Override
        public Dimension getMinimumSize() {
            Dimension dim = super.getMinimumSize();
            dim.width = 0;
            return dim;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dim = super.getPreferredSize();
            dim.width = 100;
            return dim;
        }
    }
}

