/* ClockApplet.c generated by valac 0.56.2, the Vala compiler
 * generated from ClockApplet.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright © 2014-2022 Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include "clockapplet.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "plugin.h"
#include <glib-object.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <gio/gdesktopappinfo.h>
#include <libpeas/peas.h>

#define CLOCK_SETTINGS_SCHEMA "com.solus-project.clock"
#define GNOME_SETTINGS_SCHEMA "org.gnome.desktop.interface"

enum  {
	CLOCK_PLUGIN_0_PROPERTY,
	CLOCK_PLUGIN_NUM_PROPERTIES
};
static GParamSpec* clock_plugin_properties[CLOCK_PLUGIN_NUM_PROPERTIES];
enum  {
	CLOCK_APPLET_0_PROPERTY,
	CLOCK_APPLET_UUID_PROPERTY,
	CLOCK_APPLET_NUM_PROPERTIES
};
static GParamSpec* clock_applet_properties[CLOCK_APPLET_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_time_zone_unref0(var) ((var == NULL) ? NULL : (var = (g_time_zone_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	CLOCK_SETTINGS_0_PROPERTY,
	CLOCK_SETTINGS_NUM_PROPERTIES
};
static GParamSpec* clock_settings_properties[CLOCK_SETTINGS_NUM_PROPERTIES];

struct _ClockAppletPrivate {
	GDateTime* time;
	BudgiePopover* popover;
	GAppInfo* calprov;
	GtkButton* cal_button;
	GtkOrientation orient;
	BudgiePopoverManager* manager;
	gboolean clock_show_date;
	gboolean clock_show_seconds;
	gboolean clock_use_24_hour_time;
	gboolean clock_use_custom_format;
	gchar* clock_custom_format;
	GTimeZone* clock_timezone;
	gchar* _uuid;
};

struct _ClockSettingsPrivate {
	GtkSwitch* show_date;
	GtkSwitch* show_seconds;
	GtkSwitch* use_24_hour_time;
	GtkSwitch* use_custom_format;
	GtkEntry* custom_format;
	GtkSwitch* use_custom_timezone;
	GtkEntry* custom_timezone;
};

static gpointer clock_plugin_parent_class = NULL;
static BudgiePluginIface * clock_plugin_budgie_plugin_parent_iface = NULL;
static GType clock_plugin_type_id = 0;
static gint ClockApplet_private_offset;
static gpointer clock_applet_parent_class = NULL;
static GType clock_applet_type_id = 0;
static gint ClockSettings_private_offset;
static gpointer clock_settings_parent_class = NULL;
static GType clock_settings_type_id = 0;

static BudgieApplet* clock_plugin_real_get_panel_widget (BudgiePlugin* base,
                                                  const gchar* uuid);
static GtkButton* clock_applet_new_plain_button (ClockApplet* self,
                                          const gchar* label_str);
static void clock_applet_real_panel_position_changed (BudgieApplet* base,
                                               BudgiePanelPosition position);
static void clock_applet_on_date_activate (ClockApplet* self);
static void _clock_applet_on_date_activate_gtk_button_clicked (GtkButton* _sender,
                                                        gpointer self);
static void clock_applet_on_cal_activate (ClockApplet* self);
static void _clock_applet_on_cal_activate_gtk_button_clicked (GtkButton* _sender,
                                                       gpointer self);
static gboolean __lambda4_ (ClockApplet* self,
                     GdkEventButton* e);
static gboolean ___lambda4__gtk_widget_button_press_event (GtkWidget* _sender,
                                                    GdkEventButton* event,
                                                    gpointer self);
static void clock_applet_update_setting (ClockApplet* self,
                                  const gchar* schema,
                                  const gchar* key);
static gboolean _clock_applet_update_clock_gsource_func (gpointer self);
static void __lambda5_ (ClockApplet* self,
                 const gchar* key);
static void ___lambda5__g_settings_changed (GSettings* _sender,
                                     const gchar* key,
                                     gpointer self);
static void __lambda6_ (ClockApplet* self,
                 const gchar* key);
static void ___lambda6__g_settings_changed (GSettings* _sender,
                                     const gchar* key,
                                     gpointer self);
static void clock_applet_update_cal (ClockApplet* self);
static void _clock_applet_update_cal_g_app_info_monitor_changed (GAppInfoMonitor* _sender,
                                                          gpointer self);
static void clock_applet_real_update_popovers (BudgieApplet* base,
                                        BudgiePopoverManager* manager);
static gboolean clock_applet_real_supports_settings (BudgieApplet* base);
static GtkWidget* clock_applet_real_get_settings_ui (BudgieApplet* base);
static void clock_applet_finalize (GObject * obj);
static void _vala_clock_applet_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec);
static void _vala_clock_applet_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec);
static gboolean __lambda7_ (GValue* value,
                     GVariant* variant,
                     void* user_data);
static gboolean ___lambda7__gsettings_bind_get_mapping (GValue* value,
                                                 GVariant* variant,
                                                 void* user_data);
static GVariant* __lambda8_ (GValue* value,
                      const GVariantType* expected_type,
                      void* user_data);
static GVariant* ___lambda8__gsettings_bind_set_mapping (GValue* value,
                                                  const GVariantType* expected_type,
                                                  void* user_data);
static void clock_settings_updateSensitve (ClockSettings* self);
static void _clock_settings_updateSensitve_g_object_notify (GObject* _sender,
                                                     GParamSpec* pspec,
                                                     gpointer self);
static void clock_settings_finalize (GObject * obj);

static BudgieApplet*
clock_plugin_real_get_panel_widget (BudgiePlugin* base,
                                    const gchar* uuid)
{
	ClockPlugin * self;
	ClockApplet* _tmp0_;
	BudgieApplet* result;
	self = (ClockPlugin*) base;
	g_return_val_if_fail (uuid != NULL, NULL);
	_tmp0_ = clock_applet_new (uuid);
	g_object_ref_sink (_tmp0_);
	result = (BudgieApplet*) _tmp0_;
	return result;
}

ClockPlugin*
clock_plugin_construct (GType object_type)
{
	ClockPlugin * self = NULL;
	self = (ClockPlugin*) g_object_new (object_type, NULL);
	return self;
}

ClockPlugin*
clock_plugin_new (void)
{
	return clock_plugin_construct (TYPE_CLOCK_PLUGIN);
}

static void
clock_plugin_class_init (ClockPluginClass * klass,
                         gpointer klass_data)
{
	clock_plugin_parent_class = g_type_class_peek_parent (klass);
}

static void
clock_plugin_budgie_plugin_interface_init (BudgiePluginIface * iface,
                                           gpointer iface_data)
{
	clock_plugin_budgie_plugin_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_panel_widget = (BudgieApplet* (*) (BudgiePlugin*, const gchar*)) clock_plugin_real_get_panel_widget;
}

static void
clock_plugin_instance_init (ClockPlugin * self,
                            gpointer klass)
{
}

GType
clock_plugin_get_type (void)
{
	return clock_plugin_type_id;
}

GType
clock_plugin_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (ClockPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) clock_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ClockPlugin), 0, (GInstanceInitFunc) clock_plugin_instance_init, NULL };
	static const GInterfaceInfo budgie_plugin_info = { (GInterfaceInitFunc) clock_plugin_budgie_plugin_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	clock_plugin_type_id = g_type_module_register_type (module, peas_extension_base_get_type (), "ClockPlugin", &g_define_type_info, 0);
	g_type_module_add_interface (module, clock_plugin_type_id, budgie_plugin_get_type (), &budgie_plugin_info);
	return clock_plugin_type_id;
}

static inline gpointer
clock_applet_get_instance_private (ClockApplet* self)
{
	return G_STRUCT_MEMBER_P (self, ClockApplet_private_offset);
}

static GtkButton*
clock_applet_new_plain_button (ClockApplet* self,
                               const gchar* label_str)
{
	GtkButton* ret = NULL;
	GtkButton* _tmp0_;
	GtkWidget* _tmp1_;
	GtkStyleContext* _tmp2_;
	GtkButton* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (label_str != NULL, NULL);
	_tmp0_ = (GtkButton*) gtk_button_new_with_label (label_str);
	g_object_ref_sink (_tmp0_);
	ret = _tmp0_;
	_tmp1_ = gtk_bin_get_child ((GtkBin*) ret);
	gtk_widget_set_halign (_tmp1_, GTK_ALIGN_START);
	_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) ret);
	gtk_style_context_add_class (_tmp2_, GTK_STYLE_CLASS_FLAT);
	result = ret;
	return result;
}

static void
clock_applet_real_panel_position_changed (BudgieApplet* base,
                                          BudgiePanelPosition position)
{
	ClockApplet * self;
	gboolean _tmp0_ = FALSE;
	GtkLabel* _tmp5_;
	GtkBox* _tmp6_;
	self = (ClockApplet*) base;
	if (position == BUDGIE_PANEL_POSITION_LEFT) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = position == BUDGIE_PANEL_POSITION_RIGHT;
	}
	if (_tmp0_) {
		GtkLabel* _tmp1_;
		GtkLabel* _tmp2_;
		self->priv->orient = GTK_ORIENTATION_VERTICAL;
		_tmp1_ = self->clock_label;
		gtk_label_set_line_wrap (_tmp1_, TRUE);
		_tmp2_ = self->clock_label;
		gtk_label_set_max_width_chars (_tmp2_, 1);
	} else {
		GtkLabel* _tmp3_;
		GtkLabel* _tmp4_;
		self->priv->orient = GTK_ORIENTATION_HORIZONTAL;
		_tmp3_ = self->clock_label;
		gtk_label_set_line_wrap (_tmp3_, FALSE);
		_tmp4_ = self->clock_label;
		gtk_label_set_max_width_chars (_tmp4_, -1);
	}
	_tmp5_ = self->seconds_label;
	gtk_label_set_text (_tmp5_, "");
	_tmp6_ = self->layout;
	gtk_orientable_set_orientation ((GtkOrientable*) _tmp6_, self->priv->orient);
	clock_applet_update_clock (self);
}

static void
_clock_applet_on_date_activate_gtk_button_clicked (GtkButton* _sender,
                                                   gpointer self)
{
	clock_applet_on_date_activate ((ClockApplet*) self);
}

static void
_clock_applet_on_cal_activate_gtk_button_clicked (GtkButton* _sender,
                                                  gpointer self)
{
	clock_applet_on_cal_activate ((ClockApplet*) self);
}

static gboolean
__lambda4_ (ClockApplet* self,
            GdkEventButton* e)
{
	BudgiePopover* _tmp0_;
	gboolean result;
	g_return_val_if_fail (e != NULL, FALSE);
	if (e->button != ((guint) 1)) {
		result = GDK_EVENT_PROPAGATE;
		return result;
	}
	_tmp0_ = self->priv->popover;
	if (gtk_widget_get_visible ((GtkWidget*) _tmp0_)) {
		BudgiePopover* _tmp1_;
		_tmp1_ = self->priv->popover;
		gtk_widget_hide ((GtkWidget*) _tmp1_);
	} else {
		BudgiePopoverManager* _tmp2_;
		GtkEventBox* _tmp3_;
		_tmp2_ = self->priv->manager;
		_tmp3_ = self->widget;
		budgie_popover_manager_show_popover (_tmp2_, (GtkWidget*) _tmp3_);
	}
	result = GDK_EVENT_STOP;
	return result;
}

static gboolean
___lambda4__gtk_widget_button_press_event (GtkWidget* _sender,
                                           GdkEventButton* event,
                                           gpointer self)
{
	gboolean result;
	result = __lambda4_ ((ClockApplet*) self, event);
	return result;
}

static gboolean
_clock_applet_update_clock_gsource_func (gpointer self)
{
	gboolean result;
	result = clock_applet_update_clock ((ClockApplet*) self);
	return result;
}

static void
__lambda5_ (ClockApplet* self,
            const gchar* key)
{
	g_return_if_fail (key != NULL);
	clock_applet_update_setting (self, CLOCK_SETTINGS_SCHEMA, key);
	clock_applet_update_clock (self);
}

static void
___lambda5__g_settings_changed (GSettings* _sender,
                                const gchar* key,
                                gpointer self)
{
	__lambda5_ ((ClockApplet*) self, key);
}

static void
__lambda6_ (ClockApplet* self,
            const gchar* key)
{
	g_return_if_fail (key != NULL);
	clock_applet_update_setting (self, GNOME_SETTINGS_SCHEMA, key);
	clock_applet_update_clock (self);
}

static void
___lambda6__g_settings_changed (GSettings* _sender,
                                const gchar* key,
                                gpointer self)
{
	__lambda6_ ((ClockApplet*) self, key);
}

static void
_clock_applet_update_cal_g_app_info_monitor_changed (GAppInfoMonitor* _sender,
                                                     gpointer self)
{
	clock_applet_update_cal ((ClockApplet*) self);
}

ClockApplet*
clock_applet_construct (GType object_type,
                        const gchar* uuid)
{
	ClockApplet * self = NULL;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GtkEventBox* _tmp2_;
	GtkBox* _tmp3_;
	GtkEventBox* _tmp4_;
	GtkBox* _tmp5_;
	GtkLabel* _tmp6_;
	GtkLabel* _tmp7_;
	GtkLabel* _tmp8_;
	GtkBox* _tmp9_;
	GtkLabel* _tmp10_;
	GtkBox* _tmp11_;
	GtkBox* _tmp12_;
	GtkLabel* _tmp13_;
	GtkLabel* _tmp14_;
	GtkStyleContext* _tmp15_;
	GtkBox* _tmp16_;
	GtkLabel* _tmp17_;
	GtkLabel* _tmp18_;
	GtkLabel* _tmp19_;
	GtkLabel* _tmp20_;
	GtkBox* _tmp21_;
	GtkLabel* _tmp22_;
	GtkLabel* _tmp23_;
	GtkLabel* _tmp24_;
	GtkLabel* _tmp25_;
	GtkLabel* _tmp26_;
	GtkLabel* _tmp27_;
	GtkStyleContext* _tmp28_;
	GtkEventBox* _tmp29_;
	BudgiePopover* _tmp30_;
	GtkStack* stack = NULL;
	GtkStack* _tmp31_;
	GtkStyleContext* _tmp32_;
	BudgiePopover* _tmp33_;
	GtkBox* menu = NULL;
	GtkBox* _tmp34_;
	GtkButton* time_button = NULL;
	GtkButton* _tmp35_;
	GtkButton* _tmp36_;
	GtkButton* _tmp37_;
	GtkButton* _tmp38_;
	GtkEventBox* _tmp39_;
	GtkLabel* _tmp40_;
	GtkLabel* _tmp41_;
	GSettings* _tmp42_;
	GSettings* _tmp43_;
	GAppInfo* _tmp44_;
	GAppInfoMonitor* monitor = NULL;
	GAppInfoMonitor* _tmp45_;
	GtkButton* _tmp46_;
	GAppInfo* _tmp47_;
	GtkButton* _tmp48_;
	GtkEventBox* _tmp49_;
	BudgiePopover* _tmp50_;
	GtkWidget* _tmp51_;
	g_return_val_if_fail (uuid != NULL, NULL);
	self = (ClockApplet*) g_object_new (object_type, "uuid", uuid, NULL);
	budgie_applet_set_settings_schema ((BudgieApplet*) self, CLOCK_SETTINGS_SCHEMA);
	budgie_applet_set_settings_prefix ((BudgieApplet*) self, "/com/solus-project/clock/instance/clock");
	_tmp0_ = budgie_applet_get_applet_settings ((BudgieApplet*) self, uuid);
	_g_object_unref0 (self->settings);
	self->settings = _tmp0_;
	_tmp1_ = g_settings_new (GNOME_SETTINGS_SCHEMA);
	_g_object_unref0 (self->gnome_settings);
	self->gnome_settings = _tmp1_;
	_tmp2_ = (GtkEventBox*) gtk_event_box_new ();
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->widget);
	self->widget = _tmp2_;
	_tmp3_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 2);
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->layout);
	self->layout = _tmp3_;
	_tmp4_ = self->widget;
	_tmp5_ = self->layout;
	gtk_container_add ((GtkContainer*) _tmp4_, (GtkWidget*) _tmp5_);
	_tmp6_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp6_);
	_g_object_unref0 (self->clock_label);
	self->clock_label = _tmp6_;
	_tmp7_ = self->clock_label;
	gtk_label_set_line_wrap (_tmp7_, TRUE);
	_tmp8_ = self->clock_label;
	gtk_label_set_justify (_tmp8_, GTK_JUSTIFY_CENTER);
	_tmp9_ = self->layout;
	_tmp10_ = self->clock_label;
	gtk_box_pack_start (_tmp9_, (GtkWidget*) _tmp10_, FALSE, FALSE, (guint) 0);
	_tmp11_ = self->layout;
	g_object_set ((GtkWidget*) _tmp11_, "margin", 0, NULL);
	_tmp12_ = self->layout;
	gtk_container_set_border_width ((GtkContainer*) _tmp12_, (guint) 0);
	_tmp13_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp13_);
	_g_object_unref0 (self->seconds_label);
	self->seconds_label = _tmp13_;
	_tmp14_ = self->seconds_label;
	_tmp15_ = gtk_widget_get_style_context ((GtkWidget*) _tmp14_);
	gtk_style_context_add_class (_tmp15_, "dim-label");
	_tmp16_ = self->layout;
	_tmp17_ = self->seconds_label;
	gtk_box_pack_start (_tmp16_, (GtkWidget*) _tmp17_, FALSE, FALSE, (guint) 0);
	_tmp18_ = self->seconds_label;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp18_, TRUE);
	_tmp19_ = self->seconds_label;
	gtk_widget_hide ((GtkWidget*) _tmp19_);
	_tmp20_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp20_);
	_g_object_unref0 (self->date_label);
	self->date_label = _tmp20_;
	_tmp21_ = self->layout;
	_tmp22_ = self->date_label;
	gtk_box_pack_start (_tmp21_, (GtkWidget*) _tmp22_, FALSE, FALSE, (guint) 0);
	_tmp23_ = self->date_label;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp23_, TRUE);
	_tmp24_ = self->date_label;
	gtk_widget_hide ((GtkWidget*) _tmp24_);
	_tmp25_ = self->clock_label;
	gtk_widget_set_valign ((GtkWidget*) _tmp25_, GTK_ALIGN_CENTER);
	_tmp26_ = self->seconds_label;
	gtk_widget_set_valign ((GtkWidget*) _tmp26_, GTK_ALIGN_CENTER);
	_tmp27_ = self->date_label;
	gtk_widget_set_valign ((GtkWidget*) _tmp27_, GTK_ALIGN_CENTER);
	_tmp28_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp28_, "budgie-clock-applet");
	_tmp29_ = self->widget;
	_tmp30_ = (BudgiePopover*) budgie_popover_new ((GtkWidget*) _tmp29_);
	g_object_ref_sink (_tmp30_);
	_g_object_unref0 (self->priv->popover);
	self->priv->popover = _tmp30_;
	_tmp31_ = (GtkStack*) gtk_stack_new ();
	g_object_ref_sink (_tmp31_);
	stack = _tmp31_;
	_tmp32_ = gtk_widget_get_style_context ((GtkWidget*) stack);
	gtk_style_context_add_class (_tmp32_, "clock-applet-stack");
	_tmp33_ = self->priv->popover;
	gtk_container_add ((GtkContainer*) _tmp33_, (GtkWidget*) stack);
	gtk_stack_set_homogeneous (stack, TRUE);
	gtk_stack_set_transition_type (stack, GTK_STACK_TRANSITION_TYPE_SLIDE_LEFT_RIGHT);
	_tmp34_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 1);
	g_object_ref_sink (_tmp34_);
	menu = _tmp34_;
	gtk_container_set_border_width ((GtkContainer*) menu, (guint) 6);
	_tmp35_ = clock_applet_new_plain_button (self, _ ("System time and date settings"));
	time_button = _tmp35_;
	_tmp36_ = clock_applet_new_plain_button (self, _ ("Calendar"));
	_g_object_unref0 (self->priv->cal_button);
	self->priv->cal_button = _tmp36_;
	g_signal_connect_object (time_button, "clicked", (GCallback) _clock_applet_on_date_activate_gtk_button_clicked, self, 0);
	_tmp37_ = self->priv->cal_button;
	g_signal_connect_object (_tmp37_, "clicked", (GCallback) _clock_applet_on_cal_activate_gtk_button_clicked, self, 0);
	gtk_box_pack_start (menu, (GtkWidget*) time_button, FALSE, FALSE, (guint) 0);
	_tmp38_ = self->priv->cal_button;
	gtk_box_pack_start (menu, (GtkWidget*) _tmp38_, FALSE, FALSE, (guint) 0);
	gtk_container_add ((GtkContainer*) stack, (GtkWidget*) menu);
	_tmp39_ = self->widget;
	g_signal_connect_object ((GtkWidget*) _tmp39_, "button-press-event", (GCallback) ___lambda4__gtk_widget_button_press_event, self, 0);
	clock_applet_update_setting (self, CLOCK_SETTINGS_SCHEMA, "show-date");
	clock_applet_update_setting (self, CLOCK_SETTINGS_SCHEMA, "show-seconds");
	clock_applet_update_setting (self, GNOME_SETTINGS_SCHEMA, "clock-format");
	clock_applet_update_setting (self, CLOCK_SETTINGS_SCHEMA, "use-custom-format");
	clock_applet_update_setting (self, CLOCK_SETTINGS_SCHEMA, "custom-format");
	clock_applet_update_setting (self, CLOCK_SETTINGS_SCHEMA, "use-custom-timezone");
	clock_applet_update_setting (self, CLOCK_SETTINGS_SCHEMA, "custom-timezone");
	_tmp40_ = self->date_label;
	gtk_widget_set_visible ((GtkWidget*) _tmp40_, self->priv->clock_show_date);
	_tmp41_ = self->seconds_label;
	gtk_widget_set_visible ((GtkWidget*) _tmp41_, self->priv->clock_show_seconds);
	g_timeout_add_seconds_full (G_PRIORITY_LOW, (guint) 1, _clock_applet_update_clock_gsource_func, g_object_ref (self), g_object_unref);
	_tmp42_ = self->settings;
	g_signal_connect_object (_tmp42_, "changed", (GCallback) ___lambda5__g_settings_changed, self, 0);
	_tmp43_ = self->gnome_settings;
	g_signal_connect_object (_tmp43_, "changed", (GCallback) ___lambda6__g_settings_changed, self, 0);
	_tmp44_ = g_app_info_get_default_for_type (CALENDAR_MIME, FALSE);
	_g_object_unref0 (self->priv->calprov);
	self->priv->calprov = _tmp44_;
	_tmp45_ = g_app_info_monitor_get ();
	monitor = _tmp45_;
	g_signal_connect_object (monitor, "changed", (GCallback) _clock_applet_update_cal_g_app_info_monitor_changed, self, 0);
	_tmp46_ = self->priv->cal_button;
	_tmp47_ = self->priv->calprov;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp46_, _tmp47_ != NULL);
	_tmp48_ = self->priv->cal_button;
	g_signal_connect_object (_tmp48_, "clicked", (GCallback) _clock_applet_on_cal_activate_gtk_button_clicked, self, 0);
	clock_applet_update_cal (self);
	_tmp49_ = self->widget;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp49_);
	_tmp50_ = self->priv->popover;
	_tmp51_ = gtk_bin_get_child ((GtkBin*) _tmp50_);
	gtk_widget_show_all (_tmp51_);
	gtk_widget_show_all ((GtkWidget*) self);
	_g_object_unref0 (monitor);
	_g_object_unref0 (time_button);
	_g_object_unref0 (menu);
	_g_object_unref0 (stack);
	return self;
}

ClockApplet*
clock_applet_new (const gchar* uuid)
{
	return clock_applet_construct (TYPE_CLOCK_APPLET, uuid);
}

static void
clock_applet_update_cal (ClockApplet* self)
{
	GAppInfo* _tmp0_;
	GtkButton* _tmp1_;
	GAppInfo* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_app_info_get_default_for_type (CALENDAR_MIME, FALSE);
	_g_object_unref0 (self->priv->calprov);
	self->priv->calprov = _tmp0_;
	_tmp1_ = self->priv->cal_button;
	_tmp2_ = self->priv->calprov;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp1_, _tmp2_ != NULL);
}

static void
clock_applet_on_date_activate (ClockApplet* self)
{
	BudgiePopover* _tmp0_;
	GDesktopAppInfo* app_info = NULL;
	GDesktopAppInfo* _tmp1_;
	GDesktopAppInfo* _tmp2_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->popover;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
	_tmp1_ = g_desktop_app_info_new ("budgie-datetime-panel.desktop");
	app_info = _tmp1_;
	_tmp2_ = app_info;
	if (_tmp2_ == NULL) {
		_g_object_unref0 (app_info);
		return;
	}
	{
		GDesktopAppInfo* _tmp3_;
		_tmp3_ = app_info;
		g_app_info_launch ((GAppInfo*) _tmp3_, NULL, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_message ("ClockApplet.vala:201: Unable to launch budgie-datetime-panel.desktop: " \
"%s", _tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (app_info);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (app_info);
}

static void
clock_applet_on_cal_activate (ClockApplet* self)
{
	BudgiePopover* _tmp0_;
	GAppInfo* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->popover;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
	_tmp1_ = self->priv->calprov;
	if (_tmp1_ == NULL) {
		return;
	}
	{
		GAppInfo* _tmp2_;
		_tmp2_ = self->priv->calprov;
		g_app_info_launch (_tmp2_, NULL, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GAppInfo* _tmp3_;
		const gchar* _tmp4_;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = self->priv->calprov;
		_tmp4_ = g_app_info_get_name (_tmp3_);
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_message ("ClockApplet.vala:214: Unable to launch %s: %s", _tmp4_, _tmp6_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
clock_applet_real_update_popovers (BudgieApplet* base,
                                   BudgiePopoverManager* manager)
{
	ClockApplet * self;
	GtkEventBox* _tmp0_;
	BudgiePopover* _tmp1_;
	self = (ClockApplet*) base;
	self->priv->manager = manager;
	_tmp0_ = self->widget;
	_tmp1_ = self->priv->popover;
	budgie_popover_manager_register_popover (manager, (GtkWidget*) _tmp0_, _tmp1_);
}

static GTimeZone*
vala_g_time_zone_new_identifier (const gchar* identifier,
                                 GError** error)
{
	GTimeZone* self;
	GError* _inner_error0_ = NULL;
	self = (GTimeZone*) g_time_zone_new_identifier (identifier);
	if (((GTimeZone*) self) == NULL) {
		GError* _tmp0_;
		_tmp0_ = g_error_new_literal (G_CONVERT_ERROR, G_CONVERT_ERROR_ILLEGAL_SEQUENCE, "Invalid identifier argument");
		_inner_error0_ = _tmp0_;
		g_propagate_error (error, _inner_error0_);
		_g_time_zone_unref0 (self);
		return NULL;
	}
	return self;
}

static void
clock_applet_update_setting (ClockApplet* self,
                             const gchar* schema,
                             const gchar* key)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (schema != NULL);
	g_return_if_fail (key != NULL);
	if (g_strcmp0 (schema, CLOCK_SETTINGS_SCHEMA) == 0) {
		const gchar* _tmp0_;
		GQuark _tmp2_ = 0U;
		static GQuark _tmp1_label0 = 0;
		static GQuark _tmp1_label1 = 0;
		static GQuark _tmp1_label2 = 0;
		static GQuark _tmp1_label3 = 0;
		static GQuark _tmp1_label4 = 0;
		static GQuark _tmp1_label5 = 0;
		_tmp0_ = key;
		_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
		if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("show-date")))) {
			switch (0) {
				default:
				{
					GSettings* _tmp3_;
					GtkLabel* _tmp4_;
					_tmp3_ = self->settings;
					self->priv->clock_show_date = g_settings_get_boolean (_tmp3_, key);
					_tmp4_ = self->date_label;
					gtk_widget_set_visible ((GtkWidget*) _tmp4_, self->priv->clock_show_date);
					break;
				}
			}
		} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("show-seconds")))) {
			switch (0) {
				default:
				{
					GSettings* _tmp5_;
					GtkLabel* _tmp6_;
					_tmp5_ = self->settings;
					self->priv->clock_show_seconds = g_settings_get_boolean (_tmp5_, key);
					_tmp6_ = self->seconds_label;
					gtk_widget_set_visible ((GtkWidget*) _tmp6_, self->priv->clock_show_seconds);
					break;
				}
			}
		} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("use-custom-format")))) {
			switch (0) {
				default:
				{
					GSettings* _tmp7_;
					_tmp7_ = self->settings;
					self->priv->clock_use_custom_format = g_settings_get_boolean (_tmp7_, key);
					if (self->priv->clock_use_custom_format) {
						GtkLabel* _tmp8_;
						GtkLabel* _tmp9_;
						_tmp8_ = self->date_label;
						gtk_widget_set_visible ((GtkWidget*) _tmp8_, FALSE);
						_tmp9_ = self->seconds_label;
						gtk_widget_set_visible ((GtkWidget*) _tmp9_, FALSE);
					} else {
						GtkLabel* _tmp10_;
						GtkLabel* _tmp11_;
						_tmp10_ = self->date_label;
						gtk_widget_set_visible ((GtkWidget*) _tmp10_, self->priv->clock_show_date);
						_tmp11_ = self->seconds_label;
						gtk_widget_set_visible ((GtkWidget*) _tmp11_, self->priv->clock_show_seconds);
					}
					break;
				}
			}
		} else if (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("custom-format")))) {
			switch (0) {
				default:
				{
					GSettings* _tmp12_;
					gchar* _tmp13_;
					_tmp12_ = self->settings;
					_tmp13_ = g_settings_get_string (_tmp12_, key);
					_g_free0 (self->priv->clock_custom_format);
					self->priv->clock_custom_format = _tmp13_;
					break;
				}
			}
		} else if ((_tmp2_ == ((0 != _tmp1_label4) ? _tmp1_label4 : (_tmp1_label4 = g_quark_from_static_string ("use-custom-timezone")))) || (_tmp2_ == ((0 != _tmp1_label5) ? _tmp1_label5 : (_tmp1_label5 = g_quark_from_static_string ("custom-timezone"))))) {
			switch (0) {
				default:
				{
					GSettings* _tmp14_;
					_tmp14_ = self->settings;
					if (g_settings_get_boolean (_tmp14_, "use-custom-timezone")) {
						gchar* custom_tz = NULL;
						GSettings* _tmp15_;
						gchar* _tmp16_;
						_tmp15_ = self->settings;
						_tmp16_ = g_settings_get_string (_tmp15_, "custom_timezone");
						custom_tz = _tmp16_;
						{
							GTimeZone* _tmp17_ = NULL;
							const gchar* _tmp18_;
							GTimeZone* _tmp19_;
							GTimeZone* _tmp20_;
							_tmp18_ = custom_tz;
							_tmp19_ = vala_g_time_zone_new_identifier (_tmp18_, &_inner_error0_);
							_tmp17_ = _tmp19_;
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								goto __catch0_g_error;
							}
							_tmp20_ = _tmp17_;
							_tmp17_ = NULL;
							_g_time_zone_unref0 (self->priv->clock_timezone);
							self->priv->clock_timezone = _tmp20_;
							_g_time_zone_unref0 (_tmp17_);
						}
						goto __finally0;
						__catch0_g_error:
						{
							const gchar* _tmp21_;
							GTimeZone* _tmp22_;
							g_clear_error (&_inner_error0_);
							_tmp21_ = custom_tz;
							g_warning ("ClockApplet.vala:254: Clock applet: Failed to set time zone from ident" \
"ifier %s. Using UTC instead.", _tmp21_);
							_tmp22_ = g_time_zone_new_utc ();
							_g_time_zone_unref0 (self->priv->clock_timezone);
							self->priv->clock_timezone = _tmp22_;
						}
						__finally0:
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							_g_free0 (custom_tz);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return;
						}
						_g_free0 (custom_tz);
					} else {
						GTimeZone* _tmp23_;
						_tmp23_ = g_time_zone_new_local ();
						_g_time_zone_unref0 (self->priv->clock_timezone);
						self->priv->clock_timezone = _tmp23_;
					}
					break;
				}
			}
		}
		return;
	}
	if (g_strcmp0 (schema, GNOME_SETTINGS_SCHEMA) == 0) {
		const gchar* _tmp24_;
		GQuark _tmp26_ = 0U;
		static GQuark _tmp25_label0 = 0;
		_tmp24_ = key;
		_tmp26_ = (NULL == _tmp24_) ? 0 : g_quark_from_string (_tmp24_);
		if (_tmp26_ == ((0 != _tmp25_label0) ? _tmp25_label0 : (_tmp25_label0 = g_quark_from_static_string ("clock-format")))) {
			switch (0) {
				default:
				{
					GSettings* _tmp27_;
					gchar* _tmp28_;
					gchar* _tmp29_;
					_tmp27_ = self->gnome_settings;
					_tmp28_ = g_settings_get_string (_tmp27_, "clock-format");
					_tmp29_ = _tmp28_;
					self->priv->clock_use_24_hour_time = g_strcmp0 (_tmp29_, "24h") == 0;
					_g_free0 (_tmp29_);
					break;
				}
			}
		}
		return;
	}
}

/**
 * Update the date if necessary
 */
void
clock_applet_update_date (ClockApplet* self)
{
	gboolean _tmp0_ = FALSE;
	gchar* ftime = NULL;
	gchar* old = NULL;
	GtkLabel* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* ctime = NULL;
	GDateTime* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	GtkLabel* _tmp11_;
	const gchar* _tmp12_;
	g_return_if_fail (self != NULL);
	if (!self->priv->clock_show_date) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->priv->clock_use_custom_format;
	}
	if (_tmp0_) {
		return;
	}
	if (self->priv->orient == GTK_ORIENTATION_HORIZONTAL) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("%x");
		_g_free0 (ftime);
		ftime = _tmp1_;
	} else {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("<small>%b %d</small>");
		_g_free0 (ftime);
		ftime = _tmp2_;
	}
	_tmp3_ = self->date_label;
	_tmp4_ = gtk_label_get_label (_tmp3_);
	_tmp5_ = g_strdup (_tmp4_);
	old = _tmp5_;
	_tmp6_ = self->priv->time;
	_tmp7_ = ftime;
	_tmp8_ = g_date_time_format (_tmp6_, _tmp7_);
	ctime = _tmp8_;
	_tmp9_ = old;
	_tmp10_ = ctime;
	if (g_strcmp0 (_tmp9_, _tmp10_) == 0) {
		_g_free0 (ctime);
		_g_free0 (old);
		_g_free0 (ftime);
		return;
	}
	_tmp11_ = self->date_label;
	_tmp12_ = ctime;
	gtk_label_set_markup (_tmp11_, _tmp12_);
	_g_free0 (ctime);
	_g_free0 (old);
	_g_free0 (ftime);
}

/**
 * Update the seconds if necessary
 */
void
clock_applet_update_seconds (ClockApplet* self)
{
	gboolean _tmp0_ = FALSE;
	gchar* ftime = NULL;
	gchar* old = NULL;
	GtkLabel* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* ctime = NULL;
	GDateTime* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	GtkLabel* _tmp11_;
	const gchar* _tmp12_;
	g_return_if_fail (self != NULL);
	if (!self->priv->clock_show_seconds) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->priv->clock_use_custom_format;
	}
	if (_tmp0_) {
		return;
	}
	if (self->priv->orient == GTK_ORIENTATION_HORIZONTAL) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("");
		_g_free0 (ftime);
		ftime = _tmp1_;
	} else {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("<big>%S</big>");
		_g_free0 (ftime);
		ftime = _tmp2_;
	}
	_tmp3_ = self->seconds_label;
	_tmp4_ = gtk_label_get_label (_tmp3_);
	_tmp5_ = g_strdup (_tmp4_);
	old = _tmp5_;
	_tmp6_ = self->priv->time;
	_tmp7_ = ftime;
	_tmp8_ = g_date_time_format (_tmp6_, _tmp7_);
	ctime = _tmp8_;
	_tmp9_ = old;
	_tmp10_ = ctime;
	if (g_strcmp0 (_tmp9_, _tmp10_) == 0) {
		_g_free0 (ctime);
		_g_free0 (old);
		_g_free0 (ftime);
		return;
	}
	_tmp11_ = self->seconds_label;
	_tmp12_ = ctime;
	gtk_label_set_markup (_tmp11_, _tmp12_);
	_g_free0 (ctime);
	_g_free0 (old);
	_g_free0 (ftime);
}

/**
 * This is called once every second, updating the time
 */
static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

gboolean
clock_applet_update_clock (ClockApplet* self)
{
	GTimeZone* _tmp0_;
	GDateTime* _tmp1_;
	gchar* format = NULL;
	gchar* old = NULL;
	GtkLabel* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* ctime = NULL;
	GDateTime* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* ftime = NULL;
	gchar* formatted = NULL;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	gchar* _tmp24_;
	const gchar* _tmp25_;
	const gchar* _tmp26_;
	GtkLabel* _tmp27_;
	const gchar* _tmp28_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->clock_timezone;
	_tmp1_ = g_date_time_new_now (_tmp0_);
	_g_date_time_unref0 (self->priv->time);
	self->priv->time = _tmp1_;
	if (!self->priv->clock_use_custom_format) {
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		gboolean _tmp4_ = FALSE;
		if (self->priv->clock_use_24_hour_time) {
			_tmp2_ = "%H:%M";
		} else {
			_tmp2_ = "%l:%M";
		}
		_tmp3_ = g_strdup (_tmp2_);
		_g_free0 (format);
		format = _tmp3_;
		if (self->priv->orient == GTK_ORIENTATION_HORIZONTAL) {
			_tmp4_ = self->priv->clock_show_seconds;
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			const gchar* _tmp5_;
			gchar* _tmp6_;
			_tmp5_ = format;
			_tmp6_ = g_strconcat (_tmp5_, ":%S", NULL);
			_g_free0 (format);
			format = _tmp6_;
		}
		if (!self->priv->clock_use_24_hour_time) {
			const gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp7_ = format;
			_tmp8_ = g_strconcat (_tmp7_, " %p", NULL);
			_g_free0 (format);
			format = _tmp8_;
		}
	} else {
		const gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp9_ = self->priv->clock_custom_format;
		_tmp10_ = g_strdup (_tmp9_);
		_g_free0 (format);
		format = _tmp10_;
	}
	clock_applet_update_date (self);
	clock_applet_update_seconds (self);
	_tmp11_ = self->clock_label;
	_tmp12_ = gtk_label_get_label (_tmp11_);
	_tmp13_ = g_strdup (_tmp12_);
	old = _tmp13_;
	_tmp14_ = self->priv->time;
	_tmp15_ = format;
	_tmp16_ = g_date_time_format (_tmp14_, _tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = string_strip (_tmp17_);
	_tmp19_ = _tmp18_;
	_g_free0 (_tmp17_);
	ctime = _tmp19_;
	if (self->priv->orient == GTK_ORIENTATION_HORIZONTAL) {
		gchar* _tmp20_;
		_tmp20_ = g_strdup ("%s");
		_g_free0 (ftime);
		ftime = _tmp20_;
	} else {
		gchar* _tmp21_;
		_tmp21_ = g_strdup ("<small>%s</small>");
		_g_free0 (ftime);
		ftime = _tmp21_;
	}
	_tmp22_ = ftime;
	_tmp23_ = ctime;
	_tmp24_ = g_strdup_printf (_tmp22_, _tmp23_);
	formatted = _tmp24_;
	_tmp25_ = old;
	_tmp26_ = formatted;
	if (g_strcmp0 (_tmp25_, _tmp26_) == 0) {
		result = TRUE;
		_g_free0 (formatted);
		_g_free0 (ftime);
		_g_free0 (ctime);
		_g_free0 (old);
		_g_free0 (format);
		return result;
	}
	_tmp27_ = self->clock_label;
	_tmp28_ = formatted;
	gtk_label_set_markup (_tmp27_, _tmp28_);
	gtk_widget_queue_draw ((GtkWidget*) self);
	result = TRUE;
	_g_free0 (formatted);
	_g_free0 (ftime);
	_g_free0 (ctime);
	_g_free0 (old);
	_g_free0 (format);
	return result;
}

static gboolean
clock_applet_real_supports_settings (BudgieApplet* base)
{
	ClockApplet * self;
	gboolean result;
	self = (ClockApplet*) base;
	result = TRUE;
	return result;
}

static GtkWidget*
clock_applet_real_get_settings_ui (BudgieApplet* base)
{
	ClockApplet * self;
	const gchar* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	GSettings* _tmp3_;
	GSettings* _tmp4_;
	ClockSettings* _tmp5_;
	GtkWidget* _tmp6_;
	GtkWidget* result;
	self = (ClockApplet*) base;
	_tmp0_ = self->priv->_uuid;
	_tmp1_ = budgie_applet_get_applet_settings ((BudgieApplet*) self, _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_settings_new (GNOME_SETTINGS_SCHEMA);
	_tmp4_ = _tmp3_;
	_tmp5_ = clock_settings_new (_tmp2_, _tmp4_);
	g_object_ref_sink (_tmp5_);
	_tmp6_ = (GtkWidget*) _tmp5_;
	_g_object_unref0 (_tmp4_);
	_g_object_unref0 (_tmp2_);
	result = _tmp6_;
	return result;
}

const gchar*
clock_applet_get_uuid (ClockApplet* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_uuid;
	result = _tmp0_;
	return result;
}

void
clock_applet_set_uuid (ClockApplet* self,
                       const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = clock_applet_get_uuid (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_uuid);
		self->priv->_uuid = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, clock_applet_properties[CLOCK_APPLET_UUID_PROPERTY]);
	}
}

static void
clock_applet_class_init (ClockAppletClass * klass,
                         gpointer klass_data)
{
	clock_applet_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ClockApplet_private_offset);
	((BudgieAppletClass *) klass)->panel_position_changed = (void (*) (BudgieApplet*, BudgiePanelPosition)) clock_applet_real_panel_position_changed;
	((BudgieAppletClass *) klass)->update_popovers = (void (*) (BudgieApplet*, BudgiePopoverManager*)) clock_applet_real_update_popovers;
	((BudgieAppletClass *) klass)->supports_settings = (gboolean (*) (BudgieApplet*)) clock_applet_real_supports_settings;
	((BudgieAppletClass *) klass)->get_settings_ui = (GtkWidget* (*) (BudgieApplet*)) clock_applet_real_get_settings_ui;
	G_OBJECT_CLASS (klass)->get_property = _vala_clock_applet_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_clock_applet_set_property;
	G_OBJECT_CLASS (klass)->finalize = clock_applet_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCK_APPLET_UUID_PROPERTY, clock_applet_properties[CLOCK_APPLET_UUID_PROPERTY] = g_param_spec_string ("uuid", "uuid", "uuid", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
clock_applet_instance_init (ClockApplet * self,
                            gpointer klass)
{
	self->priv = clock_applet_get_instance_private (self);
	self->priv->popover = NULL;
	self->priv->calprov = NULL;
	self->priv->orient = GTK_ORIENTATION_HORIZONTAL;
	self->priv->manager = NULL;
}

static void
clock_applet_finalize (GObject * obj)
{
	ClockApplet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CLOCK_APPLET, ClockApplet);
	_g_object_unref0 (self->widget);
	_g_object_unref0 (self->layout);
	_g_object_unref0 (self->clock_label);
	_g_object_unref0 (self->date_label);
	_g_object_unref0 (self->seconds_label);
	_g_date_time_unref0 (self->priv->time);
	_g_object_unref0 (self->settings);
	_g_object_unref0 (self->gnome_settings);
	_g_object_unref0 (self->priv->popover);
	_g_object_unref0 (self->priv->calprov);
	_g_object_unref0 (self->priv->cal_button);
	_g_free0 (self->priv->clock_custom_format);
	_g_time_zone_unref0 (self->priv->clock_timezone);
	_g_free0 (self->priv->_uuid);
	G_OBJECT_CLASS (clock_applet_parent_class)->finalize (obj);
}

GType
clock_applet_get_type (void)
{
	return clock_applet_type_id;
}

GType
clock_applet_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (ClockAppletClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) clock_applet_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ClockApplet), 0, (GInstanceInitFunc) clock_applet_instance_init, NULL };
	clock_applet_type_id = g_type_module_register_type (module, budgie_applet_get_type (), "ClockApplet", &g_define_type_info, 0);
	ClockApplet_private_offset = sizeof (ClockAppletPrivate);
	return clock_applet_type_id;
}

static void
_vala_clock_applet_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec)
{
	ClockApplet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CLOCK_APPLET, ClockApplet);
	switch (property_id) {
		case CLOCK_APPLET_UUID_PROPERTY:
		g_value_set_string (value, clock_applet_get_uuid (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_clock_applet_set_property (GObject * object,
                                 guint property_id,
                                 const GValue * value,
                                 GParamSpec * pspec)
{
	ClockApplet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CLOCK_APPLET, ClockApplet);
	switch (property_id) {
		case CLOCK_APPLET_UUID_PROPERTY:
		clock_applet_set_uuid (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
clock_settings_get_instance_private (ClockSettings* self)
{
	return G_STRUCT_MEMBER_P (self, ClockSettings_private_offset);
}

static gboolean
__lambda7_ (GValue* value,
            GVariant* variant,
            void* user_data)
{
	const gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (value != NULL, FALSE);
	g_return_val_if_fail (variant != NULL, FALSE);
	_tmp0_ = g_variant_get_string (variant, NULL);
	g_value_set_boolean (value, g_strcmp0 (_tmp0_, "24h") == 0);
	result = TRUE;
	return result;
}

static gboolean
___lambda7__gsettings_bind_get_mapping (GValue* value,
                                        GVariant* variant,
                                        void* user_data)
{
	gboolean result;
	result = __lambda7_ (value, variant, user_data);
	return result;
}

static GVariant*
__lambda8_ (GValue* value,
            const GVariantType* expected_type,
            void* user_data)
{
	GVariant* _tmp1_;
	GVariant* result;
	g_return_val_if_fail (value != NULL, NULL);
	g_return_val_if_fail (expected_type != NULL, NULL);
	if (g_value_get_boolean (value)) {
		GVariant* _tmp0_;
		_tmp0_ = g_variant_new ("s", "24h", NULL);
		g_variant_ref_sink (_tmp0_);
		result = _tmp0_;
		return result;
	}
	_tmp1_ = g_variant_new ("s", "12h", NULL);
	g_variant_ref_sink (_tmp1_);
	result = _tmp1_;
	return result;
}

static GVariant*
___lambda8__gsettings_bind_set_mapping (GValue* value,
                                        const GVariantType* expected_type,
                                        void* user_data)
{
	GVariant* result;
	result = __lambda8_ (value, expected_type, user_data);
	return result;
}

static void
_clock_settings_updateSensitve_g_object_notify (GObject* _sender,
                                                GParamSpec* pspec,
                                                gpointer self)
{
	clock_settings_updateSensitve ((ClockSettings*) self);
}

ClockSettings*
clock_settings_construct (GType object_type,
                          GSettings* settings,
                          GSettings* gnome_settings)
{
	ClockSettings * self = NULL;
	GtkSwitch* _tmp0_;
	GtkSwitch* _tmp1_;
	GtkSwitch* _tmp2_;
	GtkSwitch* _tmp3_;
	GtkEntry* _tmp4_;
	GtkSwitch* _tmp5_;
	GtkEntry* _tmp6_;
	GtkSwitch* _tmp7_;
	GtkSwitch* _tmp8_;
	self = (ClockSettings*) g_object_new (object_type, NULL);
	_tmp0_ = self->priv->show_date;
	g_settings_bind (settings, "show-date", (GObject*) _tmp0_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp1_ = self->priv->show_seconds;
	g_settings_bind (settings, "show-seconds", (GObject*) _tmp1_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp2_ = self->priv->use_24_hour_time;
	g_settings_bind_with_mapping (gnome_settings, "clock-format", (GObject*) _tmp2_, "active", G_SETTINGS_BIND_DEFAULT, ___lambda7__gsettings_bind_get_mapping, ___lambda8__gsettings_bind_set_mapping, NULL, NULL);
	_tmp3_ = self->priv->use_custom_format;
	g_settings_bind (settings, "use-custom-format", (GObject*) _tmp3_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp4_ = self->priv->custom_format;
	g_settings_bind (settings, "custom-format", (GObject*) _tmp4_, "text", G_SETTINGS_BIND_DEFAULT);
	_tmp5_ = self->priv->use_custom_timezone;
	g_settings_bind (settings, "use-custom-timezone", (GObject*) _tmp5_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp6_ = self->priv->custom_timezone;
	g_settings_bind (settings, "custom-timezone", (GObject*) _tmp6_, "text", G_SETTINGS_BIND_DEFAULT);
	_tmp7_ = self->priv->use_custom_format;
	g_signal_connect_object ((GObject*) _tmp7_, "notify::active", (GCallback) _clock_settings_updateSensitve_g_object_notify, self, 0);
	_tmp8_ = self->priv->use_custom_timezone;
	g_signal_connect_object ((GObject*) _tmp8_, "notify::active", (GCallback) _clock_settings_updateSensitve_g_object_notify, self, 0);
	clock_settings_updateSensitve (self);
	return self;
}

ClockSettings*
clock_settings_new (GSettings* settings,
                    GSettings* gnome_settings)
{
	return clock_settings_construct (TYPE_CLOCK_SETTINGS, settings, gnome_settings);
}

static void
clock_settings_updateSensitve (ClockSettings* self)
{
	gboolean useCustomFormat = FALSE;
	GtkSwitch* _tmp0_;
	GtkSwitch* _tmp1_;
	GtkSwitch* _tmp2_;
	GtkSwitch* _tmp3_;
	GtkEntry* _tmp4_;
	GtkEntry* _tmp5_;
	GtkSwitch* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->use_custom_format;
	useCustomFormat = gtk_switch_get_active (_tmp0_);
	_tmp1_ = self->priv->show_date;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp1_, !useCustomFormat);
	_tmp2_ = self->priv->show_seconds;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp2_, !useCustomFormat);
	_tmp3_ = self->priv->use_24_hour_time;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp3_, !useCustomFormat);
	_tmp4_ = self->priv->custom_format;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp4_, useCustomFormat);
	_tmp5_ = self->priv->custom_timezone;
	_tmp6_ = self->priv->use_custom_timezone;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp5_, gtk_switch_get_active (_tmp6_));
}

static void
clock_settings_class_init (ClockSettingsClass * klass,
                           gpointer klass_data)
{
	clock_settings_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ClockSettings_private_offset);
	G_OBJECT_CLASS (klass)->finalize = clock_settings_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/com/solus-project/clock/settings.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "show_date", FALSE, ClockSettings_private_offset + G_STRUCT_OFFSET (ClockSettingsPrivate, show_date));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "show_seconds", FALSE, ClockSettings_private_offset + G_STRUCT_OFFSET (ClockSettingsPrivate, show_seconds));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "use_24_hour_time", FALSE, ClockSettings_private_offset + G_STRUCT_OFFSET (ClockSettingsPrivate, use_24_hour_time));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "use_custom_format", FALSE, ClockSettings_private_offset + G_STRUCT_OFFSET (ClockSettingsPrivate, use_custom_format));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "custom_format", FALSE, ClockSettings_private_offset + G_STRUCT_OFFSET (ClockSettingsPrivate, custom_format));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "use_custom_timezone", FALSE, ClockSettings_private_offset + G_STRUCT_OFFSET (ClockSettingsPrivate, use_custom_timezone));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "custom_timezone", FALSE, ClockSettings_private_offset + G_STRUCT_OFFSET (ClockSettingsPrivate, custom_timezone));
}

static void
clock_settings_instance_init (ClockSettings * self,
                              gpointer klass)
{
	self->priv = clock_settings_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
clock_settings_finalize (GObject * obj)
{
	ClockSettings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CLOCK_SETTINGS, ClockSettings);
	G_OBJECT_CLASS (clock_settings_parent_class)->finalize (obj);
}

GType
clock_settings_get_type (void)
{
	return clock_settings_type_id;
}

GType
clock_settings_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (ClockSettingsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) clock_settings_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ClockSettings), 0, (GInstanceInitFunc) clock_settings_instance_init, NULL };
	clock_settings_type_id = g_type_module_register_type (module, gtk_grid_get_type (), "ClockSettings", &g_define_type_info, 0);
	ClockSettings_private_offset = sizeof (ClockSettingsPrivate);
	return clock_settings_type_id;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
peas_register_types (GTypeModule* module)
{
	PeasObjectModule* objmodule = NULL;
	PeasObjectModule* _tmp0_;
	g_return_if_fail (module != NULL);
	clock_plugin_register_type (module);
	clock_applet_register_type (module);
	clock_settings_register_type (module);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (module, peas_object_module_get_type ()) ? ((PeasObjectModule*) module) : NULL);
	objmodule = _tmp0_;
	peas_object_module_register_extension_type (objmodule, budgie_plugin_get_type (), TYPE_CLOCK_PLUGIN);
	_g_object_unref0 (objmodule);
}

