/* settings_autostart.c generated by valac 0.56.2, the Vala compiler
 * generated from settings_autostart.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright © 2017-2022 Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <gio/gdesktopappinfo.h>
#include <glib/gstdio.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <pango/pango.h>
#include <gdk/gdk.h>

#define BUDGIE_SETTINGS_GROUP_SESSION "session"
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef struct _BudgieCommandInfo BudgieCommandInfo;
#define _g_free0(var) (var = (g_free (var), NULL))

#define BUDGIE_TYPE_AUTOSTART_ITEM (budgie_autostart_item_get_type ())
#define BUDGIE_AUTOSTART_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_AUTOSTART_ITEM, BudgieAutostartItem))
#define BUDGIE_AUTOSTART_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_AUTOSTART_ITEM, BudgieAutostartItemClass))
#define BUDGIE_IS_AUTOSTART_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_AUTOSTART_ITEM))
#define BUDGIE_IS_AUTOSTART_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_AUTOSTART_ITEM))
#define BUDGIE_AUTOSTART_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_AUTOSTART_ITEM, BudgieAutostartItemClass))

typedef struct _BudgieAutostartItem BudgieAutostartItem;
typedef struct _BudgieAutostartItemClass BudgieAutostartItemClass;
typedef struct _BudgieAutostartItemPrivate BudgieAutostartItemPrivate;
enum  {
	BUDGIE_AUTOSTART_ITEM_0_PROPERTY,
	BUDGIE_AUTOSTART_ITEM_NUM_PROPERTIES
};
static GParamSpec* budgie_autostart_item_properties[BUDGIE_AUTOSTART_ITEM_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define BUDGIE_TYPE_AUTOSTART_ITEM_WIDGET (budgie_autostart_item_widget_get_type ())
#define BUDGIE_AUTOSTART_ITEM_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_AUTOSTART_ITEM_WIDGET, BudgieAutostartItemWidget))
#define BUDGIE_AUTOSTART_ITEM_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_AUTOSTART_ITEM_WIDGET, BudgieAutostartItemWidgetClass))
#define BUDGIE_IS_AUTOSTART_ITEM_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_AUTOSTART_ITEM_WIDGET))
#define BUDGIE_IS_AUTOSTART_ITEM_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_AUTOSTART_ITEM_WIDGET))
#define BUDGIE_AUTOSTART_ITEM_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_AUTOSTART_ITEM_WIDGET, BudgieAutostartItemWidgetClass))

typedef struct _BudgieAutostartItemWidget BudgieAutostartItemWidget;
typedef struct _BudgieAutostartItemWidgetClass BudgieAutostartItemWidgetClass;
typedef struct _BudgieAutostartItemWidgetPrivate BudgieAutostartItemWidgetPrivate;
enum  {
	BUDGIE_AUTOSTART_ITEM_WIDGET_0_PROPERTY,
	BUDGIE_AUTOSTART_ITEM_WIDGET_NUM_PROPERTIES
};
static GParamSpec* budgie_autostart_item_widget_properties[BUDGIE_AUTOSTART_ITEM_WIDGET_NUM_PROPERTIES];

#define BUDGIE_TYPE_APP_CHOOSER (budgie_app_chooser_get_type ())
#define BUDGIE_APP_CHOOSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_APP_CHOOSER, BudgieAppChooser))
#define BUDGIE_APP_CHOOSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_APP_CHOOSER, BudgieAppChooserClass))
#define BUDGIE_IS_APP_CHOOSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_APP_CHOOSER))
#define BUDGIE_IS_APP_CHOOSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_APP_CHOOSER))
#define BUDGIE_APP_CHOOSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_APP_CHOOSER, BudgieAppChooserClass))

typedef struct _BudgieAppChooser BudgieAppChooser;
typedef struct _BudgieAppChooserClass BudgieAppChooserClass;
typedef struct _BudgieAppChooserPrivate BudgieAppChooserPrivate;
enum  {
	BUDGIE_APP_CHOOSER_0_PROPERTY,
	BUDGIE_APP_CHOOSER_NUM_PROPERTIES
};
static GParamSpec* budgie_app_chooser_properties[BUDGIE_APP_CHOOSER_NUM_PROPERTIES];
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define BUDGIE_TYPE_COMMAND_DIALOG (budgie_command_dialog_get_type ())
#define BUDGIE_COMMAND_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_COMMAND_DIALOG, BudgieCommandDialog))
#define BUDGIE_COMMAND_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_COMMAND_DIALOG, BudgieCommandDialogClass))
#define BUDGIE_IS_COMMAND_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_COMMAND_DIALOG))
#define BUDGIE_IS_COMMAND_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_COMMAND_DIALOG))
#define BUDGIE_COMMAND_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_COMMAND_DIALOG, BudgieCommandDialogClass))

typedef struct _BudgieCommandDialog BudgieCommandDialog;
typedef struct _BudgieCommandDialogClass BudgieCommandDialogClass;
typedef struct _BudgieCommandDialogPrivate BudgieCommandDialogPrivate;
enum  {
	BUDGIE_COMMAND_DIALOG_0_PROPERTY,
	BUDGIE_COMMAND_DIALOG_NUM_PROPERTIES
};
static GParamSpec* budgie_command_dialog_properties[BUDGIE_COMMAND_DIALOG_NUM_PROPERTIES];
#define _budgie_command_info_free0(var) ((var == NULL) ? NULL : (var = (budgie_command_info_free (var), NULL)))

#define BUDGIE_TYPE_SETTINGS_PAGE (budgie_settings_page_get_type ())
#define BUDGIE_SETTINGS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_SETTINGS_PAGE, BudgieSettingsPage))
#define BUDGIE_SETTINGS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_SETTINGS_PAGE, BudgieSettingsPageClass))
#define BUDGIE_IS_SETTINGS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_SETTINGS_PAGE))
#define BUDGIE_IS_SETTINGS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_SETTINGS_PAGE))
#define BUDGIE_SETTINGS_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_SETTINGS_PAGE, BudgieSettingsPageClass))

typedef struct _BudgieSettingsPage BudgieSettingsPage;
typedef struct _BudgieSettingsPageClass BudgieSettingsPageClass;
typedef struct _BudgieSettingsPagePrivate BudgieSettingsPagePrivate;

#define BUDGIE_TYPE_AUTOSTART_PAGE (budgie_autostart_page_get_type ())
#define BUDGIE_AUTOSTART_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_AUTOSTART_PAGE, BudgieAutostartPage))
#define BUDGIE_AUTOSTART_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_AUTOSTART_PAGE, BudgieAutostartPageClass))
#define BUDGIE_IS_AUTOSTART_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_AUTOSTART_PAGE))
#define BUDGIE_IS_AUTOSTART_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_AUTOSTART_PAGE))
#define BUDGIE_AUTOSTART_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_AUTOSTART_PAGE, BudgieAutostartPageClass))

typedef struct _BudgieAutostartPage BudgieAutostartPage;
typedef struct _BudgieAutostartPageClass BudgieAutostartPageClass;
typedef struct _BudgieAutostartPagePrivate BudgieAutostartPagePrivate;
enum  {
	BUDGIE_AUTOSTART_PAGE_0_PROPERTY,
	BUDGIE_AUTOSTART_PAGE_NUM_PROPERTIES
};
static GParamSpec* budgie_autostart_page_properties[BUDGIE_AUTOSTART_PAGE_NUM_PROPERTIES];
typedef struct _BudgieAutostartPageListDirectoryData BudgieAutostartPageListDirectoryData;

struct _BudgieCommandInfo {
	gchar* title;
	gchar* description;
	gchar* command;
};

struct _BudgieAutostartItem {
	GObject parent_instance;
	BudgieAutostartItemPrivate * priv;
	gchar* id;
	gchar* filename;
	gchar* title;
	gchar* description;
	gchar* command;
	gchar* executable;
	GIcon* icon;
};

struct _BudgieAutostartItemClass {
	GObjectClass parent_class;
};

struct _BudgieAutostartItemWidget {
	GtkListBoxRow parent_instance;
	BudgieAutostartItemWidgetPrivate * priv;
	BudgieAutostartItem* autostart_item;
	gboolean running;
};

struct _BudgieAutostartItemWidgetClass {
	GtkListBoxRowClass parent_class;
};

struct _BudgieAppChooser {
	GtkDialog parent_instance;
	BudgieAppChooserPrivate * priv;
};

struct _BudgieAppChooserClass {
	GtkDialogClass parent_class;
};

struct _BudgieAppChooserPrivate {
	GtkListBox* app_listbox;
	GtkWidget* button_ok;
	GtkSearchEntry* search_entry;
	GHashTable* running_processes;
	BudgieAutostartItem* selected_item;
};

struct _BudgieCommandDialog {
	GtkDialog parent_instance;
	BudgieCommandDialogPrivate * priv;
};

struct _BudgieCommandDialogClass {
	GtkDialogClass parent_class;
};

struct _BudgieCommandDialogPrivate {
	GtkWidget* button_ok;
	GtkLabel* exists_label;
	GtkEntry* title_entry;
	GtkEntry* desc_entry;
	GtkEntry* command_entry;
};

struct _BudgieSettingsPage {
	GtkBox parent_instance;
	BudgieSettingsPagePrivate * priv;
};

struct _BudgieSettingsPageClass {
	GtkBoxClass parent_class;
};

struct _BudgieAutostartPage {
	BudgieSettingsPage parent_instance;
	BudgieAutostartPagePrivate * priv;
};

struct _BudgieAutostartPageClass {
	BudgieSettingsPageClass parent_class;
};

struct _BudgieAutostartPagePrivate {
	GtkListBox* listbox_autostart;
};

struct _BudgieAutostartPageListDirectoryData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BudgieAutostartPage* self;
	gchar* directory;
	gchar** result;
	gint result_length1;
	gchar** filelist;
	gchar** _tmp0_;
	gint filelist_length1;
	gint _filelist_size_;
	GFile* dir;
	GFile* _tmp1_;
	GFileEnumerator* e;
	GFile* _tmp2_;
	GFileEnumerator* _tmp3_;
	GList* files;
	GFileEnumerator* _tmp4_;
	GList* _tmp5_;
	GList* _tmp6_;
	GList* _tmp7_;
	GList* info_collection;
	GList* info_it;
	GFileInfo* _tmp8_;
	GFileInfo* info;
	GFileInfo* _tmp9_;
	const gchar* _tmp10_;
	gchar* path;
	GFileInfo* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	GError* _vala1_e;
	GError* _tmp16_;
	const gchar* _tmp17_;
	gchar** _tmp18_;
	gint _tmp18__length1;
	GError* _inner_error0_;
};

static gpointer budgie_autostart_item_parent_class = NULL;
VALA_EXTERN gchar* budgie_autostart_page_AUTOSTART_PATH;
VALA_EXTERN GHashTable* budgie_autostart_page_autostart_files;
static gpointer budgie_autostart_item_widget_parent_class = NULL;
static gint BudgieAppChooser_private_offset;
static gpointer budgie_app_chooser_parent_class = NULL;
static gint BudgieCommandDialog_private_offset;
static gpointer budgie_command_dialog_parent_class = NULL;
static gint BudgieAutostartPage_private_offset;
static gpointer budgie_autostart_page_parent_class = NULL;
GHashTable* budgie_autostart_page_autostart_files = NULL;
gchar* budgie_autostart_page_AUTOSTART_PATH = NULL;

VALA_EXTERN void budgie_command_info_free (BudgieCommandInfo * self);
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieCommandInfo, budgie_command_info_free)
static void budgie_command_info_instance_init (BudgieCommandInfo * self);
VALA_EXTERN BudgieCommandInfo* budgie_command_info_new (void);
VALA_EXTERN GType budgie_autostart_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieAutostartItem, g_object_unref)
VALA_EXTERN BudgieAutostartItem* budgie_autostart_item_new_from_app_info (GDesktopAppInfo* info);
VALA_EXTERN BudgieAutostartItem* budgie_autostart_item_construct_from_app_info (GType object_type,
                                                                    GDesktopAppInfo* info);
VALA_EXTERN BudgieAutostartItem* budgie_autostart_item_new_from_command_info (BudgieCommandInfo* info);
VALA_EXTERN BudgieAutostartItem* budgie_autostart_item_construct_from_command_info (GType object_type,
                                                                        BudgieCommandInfo* info);
VALA_EXTERN gchar* budgie_autostart_item_make_autostart (BudgieAutostartItem* self);
VALA_EXTERN void budgie_autostart_item_delete (BudgieAutostartItem* self);
VALA_EXTERN BudgieAutostartItem* budgie_autostart_item_new (void);
VALA_EXTERN BudgieAutostartItem* budgie_autostart_item_construct (GType object_type);
static GObject * budgie_autostart_item_constructor (GType type,
                                             guint n_construct_properties,
                                             GObjectConstructParam * construct_properties);
static void budgie_autostart_item_finalize (GObject * obj);
static GType budgie_autostart_item_get_type_once (void);
VALA_EXTERN GType budgie_autostart_item_widget_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieAutostartItemWidget, g_object_unref)
VALA_EXTERN BudgieAutostartItemWidget* budgie_autostart_item_widget_new (BudgieAutostartItem* item,
                                                             gboolean show_delete,
                                                             gboolean running);
VALA_EXTERN BudgieAutostartItemWidget* budgie_autostart_item_widget_construct (GType object_type,
                                                                   BudgieAutostartItem* item,
                                                                   gboolean show_delete,
                                                                   gboolean running);
static void ___lambda16_ (BudgieAutostartItemWidget* self);
static void ____lambda16__gtk_button_clicked (GtkButton* _sender,
                                       gpointer self);
static void budgie_autostart_item_widget_finalize (GObject * obj);
static GType budgie_autostart_item_widget_get_type_once (void);
VALA_EXTERN GType budgie_app_chooser_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieAppChooser, g_object_unref)
VALA_EXTERN BudgieAppChooser* budgie_app_chooser_new (GtkWindow* parent);
VALA_EXTERN BudgieAppChooser* budgie_app_chooser_construct (GType object_type,
                                                GtkWindow* parent);
static void _g_free0_ (gpointer var);
static void budgie_app_chooser_get_running_processes (BudgieAppChooser* self);
static gboolean _gtk_search_bar_handle_event_gtk_widget_key_press_event (GtkWidget* _sender,
                                                                  GdkEventKey* event,
                                                                  gpointer self);
static void __lambda15_ (BudgieAppChooser* self);
static void ___lambda15__gtk_editable_changed (GtkEditable* _sender,
                                        gpointer self);
static gboolean budgie_app_chooser_search_filter (BudgieAppChooser* self,
                                           GtkListBoxRow* row);
static gboolean _budgie_app_chooser_search_filter_gtk_list_box_filter_func (GtkListBoxRow* row,
                                                                     gpointer self);
static gint budgie_app_chooser_sort_function (BudgieAppChooser* self,
                                       GtkListBoxRow* row1,
                                       GtkListBoxRow* row2);
static gint _budgie_app_chooser_sort_function_gtk_list_box_sort_func (GtkListBoxRow* row1,
                                                               GtkListBoxRow* row2,
                                                               gpointer self);
static void budgie_app_chooser_row_selected (BudgieAppChooser* self,
                                      GtkListBoxRow* row);
static void _budgie_app_chooser_row_selected_gtk_list_box_row_selected (GtkListBox* _sender,
                                                                 GtkListBoxRow* row,
                                                                 gpointer self);
static void budgie_app_chooser_row_activated (BudgieAppChooser* self,
                                       GtkListBoxRow* row);
static void _budgie_app_chooser_row_activated_gtk_list_box_row_activated (GtkListBox* _sender,
                                                                   GtkListBoxRow* row,
                                                                   gpointer self);
static void budgie_app_chooser_set_app_list (BudgieAppChooser* self,
                                      GList* app_list);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
VALA_EXTERN BudgieAutostartItem* budgie_app_chooser_run (BudgieAppChooser* self);
static void budgie_app_chooser_finalize (GObject * obj);
static GType budgie_app_chooser_get_type_once (void);
VALA_EXTERN GType budgie_command_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieCommandDialog, g_object_unref)
VALA_EXTERN BudgieCommandDialog* budgie_command_dialog_new (GtkWindow* parent);
VALA_EXTERN BudgieCommandDialog* budgie_command_dialog_construct (GType object_type,
                                                      GtkWindow* parent);
static void budgie_command_dialog_check_inputs (BudgieCommandDialog* self);
static void _budgie_command_dialog_check_inputs_gtk_editable_changed (GtkEditable* _sender,
                                                               gpointer self);
VALA_EXTERN BudgieCommandInfo* budgie_command_dialog_run (BudgieCommandDialog* self);
static void budgie_command_dialog_finalize (GObject * obj);
static GType budgie_command_dialog_get_type_once (void);
VALA_EXTERN GType budgie_settings_page_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieSettingsPage, g_object_unref)
VALA_EXTERN GType budgie_autostart_page_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieAutostartPage, g_object_unref)
VALA_EXTERN BudgieAutostartPage* budgie_autostart_page_new (void);
VALA_EXTERN BudgieAutostartPage* budgie_autostart_page_construct (GType object_type);
static GtkMenu* budgie_autostart_page_create_menu (BudgieAutostartPage* self);
static void budgie_autostart_page_list_directory (BudgieAutostartPage* self,
                                           const gchar* directory,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
static gchar** budgie_autostart_page_list_directory_finish (BudgieAutostartPage* self,
                                                     GAsyncResult* _res_,
                                                     gint* result_length1);
static void __lambda17_ (BudgieAutostartPage* self,
                  GObject* obj,
                  GAsyncResult* res);
static void budgie_autostart_page_add_item (BudgieAutostartPage* self,
                                     BudgieAutostartItem* item);
static void ___lambda17__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void budgie_autostart_page_on_add_app (BudgieAutostartPage* self);
static void _budgie_autostart_page_on_add_app_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                               gpointer self);
static void budgie_autostart_page_on_add_command (BudgieAutostartPage* self);
static void _budgie_autostart_page_on_add_command_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                                   gpointer self);
static void budgie_autostart_page_list_directory_data_free (gpointer _data);
static gboolean budgie_autostart_page_list_directory_co (BudgieAutostartPageListDirectoryData* _data_);
static void budgie_autostart_page_list_directory_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_);
static void _vala_array_add4 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void budgie_autostart_page_finalize (GObject * obj);
static GType budgie_autostart_page_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

BudgieCommandInfo*
budgie_command_info_new (void)
{
	BudgieCommandInfo* self;
	self = g_slice_new0 (BudgieCommandInfo);
	budgie_command_info_instance_init (self);
	return self;
}

static void
budgie_command_info_instance_init (BudgieCommandInfo * self)
{
}

void
budgie_command_info_free (BudgieCommandInfo * self)
{
	_g_free0 (self->title);
	_g_free0 (self->description);
	_g_free0 (self->command);
	g_slice_free (BudgieCommandInfo, self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

BudgieAutostartItem*
budgie_autostart_item_construct_from_app_info (GType object_type,
                                               GDesktopAppInfo* info)
{
	BudgieAutostartItem * self = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_ = NULL;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	const gchar* _tmp12_ = NULL;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	GIcon* _tmp15_;
	GIcon* _tmp16_;
	g_return_val_if_fail (info != NULL, NULL);
	self = (BudgieAutostartItem*) g_object_new (object_type, NULL);
	_tmp1_ = g_app_info_get_id ((GAppInfo*) info);
	_tmp0_ = _tmp1_;
	if (_tmp0_ == NULL) {
		_tmp0_ = "";
	}
	_tmp2_ = g_strdup (_tmp0_);
	_g_free0 (self->id);
	self->id = _tmp2_;
	_tmp4_ = g_desktop_app_info_get_filename (info);
	_tmp3_ = _tmp4_;
	if (_tmp3_ == NULL) {
		_tmp3_ = "";
	}
	_tmp5_ = g_strdup (_tmp3_);
	_g_free0 (self->filename);
	self->filename = _tmp5_;
	_tmp7_ = g_app_info_get_display_name ((GAppInfo*) info);
	_tmp6_ = _tmp7_;
	if (_tmp6_ == NULL) {
		_tmp6_ = "";
	}
	_tmp8_ = g_strdup (_tmp6_);
	_g_free0 (self->title);
	self->title = _tmp8_;
	_tmp10_ = g_app_info_get_description ((GAppInfo*) info);
	_tmp9_ = _tmp10_;
	if (_tmp9_ == NULL) {
		_tmp9_ = "";
	}
	_tmp11_ = g_strdup (_tmp9_);
	_g_free0 (self->description);
	self->description = _tmp11_;
	_tmp13_ = G_TYPE_INSTANCE_GET_INTERFACE ((GAppInfo*) info, g_app_info_get_type (), GAppInfoIface)->get_executable ((GAppInfo*) info);
	_tmp12_ = _tmp13_;
	if (_tmp12_ == NULL) {
		_tmp12_ = "";
	}
	_tmp14_ = g_strdup (_tmp12_);
	_g_free0 (self->executable);
	self->executable = _tmp14_;
	_tmp15_ = g_app_info_get_icon ((GAppInfo*) info);
	_tmp16_ = _g_object_ref0 (_tmp15_);
	_g_object_unref0 (self->icon);
	self->icon = _tmp16_;
	return self;
}

BudgieAutostartItem*
budgie_autostart_item_new_from_app_info (GDesktopAppInfo* info)
{
	return budgie_autostart_item_construct_from_app_info (BUDGIE_TYPE_AUTOSTART_ITEM, info);
}

BudgieAutostartItem*
budgie_autostart_item_construct_from_command_info (GType object_type,
                                                   BudgieCommandInfo* info)
{
	BudgieAutostartItem * self = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_val_if_fail (info != NULL, NULL);
	self = (BudgieAutostartItem*) g_object_new (object_type, NULL);
	_tmp0_ = info->title;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->title);
	self->title = _tmp1_;
	_tmp2_ = info->description;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (self->description);
	self->description = _tmp3_;
	_tmp4_ = info->command;
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 (self->command);
	self->command = _tmp5_;
	return self;
}

BudgieAutostartItem*
budgie_autostart_item_new_from_command_info (BudgieCommandInfo* info)
{
	return budgie_autostart_item_construct_from_command_info (BUDGIE_TYPE_AUTOSTART_ITEM, info);
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

gchar*
budgie_autostart_item_make_autostart (BudgieAutostartItem* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp57_;
	gchar* _tmp58_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = budgie_autostart_page_AUTOSTART_PATH;
	_tmp1_ = g_build_path ("/", _tmp0_, NULL);
	_tmp2_ = _tmp1_;
	g_mkdir_with_parents (_tmp2_, 00755);
	_g_free0 (_tmp2_);
	_tmp3_ = self->filename;
	if (g_strcmp0 (_tmp3_, "") != 0) {
		gchar* destination_path = NULL;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		GFile* destination = NULL;
		const gchar* _tmp10_;
		GFile* _tmp11_;
		GFile* file = NULL;
		const gchar* _tmp12_;
		GFile* _tmp13_;
		_tmp4_ = budgie_autostart_page_AUTOSTART_PATH;
		_tmp5_ = self->filename;
		_tmp6_ = g_filename_display_basename (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_build_path ("/", _tmp4_, _tmp7_, NULL);
		_tmp9_ = _tmp8_;
		_g_free0 (_tmp7_);
		destination_path = _tmp9_;
		_tmp10_ = destination_path;
		_tmp11_ = g_file_new_for_path (_tmp10_);
		destination = _tmp11_;
		_tmp12_ = self->filename;
		_tmp13_ = g_file_new_for_path (_tmp12_);
		file = _tmp13_;
		{
			GFile* _tmp14_;
			GFile* _tmp15_;
			const gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp14_ = file;
			_tmp15_ = destination;
			g_file_copy (_tmp14_, _tmp15_, G_FILE_COPY_NONE, NULL, NULL, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp16_ = destination_path;
			_tmp17_ = g_strdup (_tmp16_);
			_g_free0 (self->filename);
			self->filename = _tmp17_;
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp18_;
			const gchar* _tmp19_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp18_ = e;
			_tmp19_ = _tmp18_->message;
			g_warning ("settings_autostart.vala:63: %s", _tmp19_);
			result = NULL;
			_g_error_free0 (e);
			_g_object_unref0 (file);
			_g_object_unref0 (destination);
			_g_free0 (destination_path);
			return result;
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (file);
			_g_object_unref0 (destination);
			_g_free0 (destination_path);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_g_object_unref0 (file);
		_g_object_unref0 (destination);
		_g_free0 (destination_path);
	} else {
		const gchar* _tmp20_;
		_tmp20_ = self->command;
		if (g_strcmp0 (_tmp20_, "") != 0) {
			gchar* destination_path = NULL;
			const gchar* _tmp21_;
			const gchar* _tmp22_;
			const gchar* _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			GFile* file = NULL;
			const gchar* _tmp28_;
			GFile* _tmp29_;
			_tmp21_ = budgie_autostart_page_AUTOSTART_PATH;
			_tmp22_ = self->title;
			_tmp23_ = string_to_string (_tmp22_);
			_tmp24_ = g_strconcat (_tmp23_, ".desktop", NULL);
			_tmp25_ = _tmp24_;
			_tmp26_ = g_build_path ("/", _tmp21_, _tmp25_, NULL);
			_tmp27_ = _tmp26_;
			_g_free0 (_tmp25_);
			destination_path = _tmp27_;
			_tmp28_ = destination_path;
			_tmp29_ = g_file_new_for_path (_tmp28_);
			file = _tmp29_;
			{
				GFileOutputStream* file_stream = NULL;
				GFile* _tmp30_;
				GFileOutputStream* _tmp31_;
				GFile* _tmp32_;
				_tmp30_ = file;
				_tmp31_ = g_file_create (_tmp30_, G_FILE_CREATE_NONE, NULL, &_inner_error0_);
				file_stream = _tmp31_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch1_g_error;
				}
				_tmp32_ = file;
				if (g_file_query_exists (_tmp32_, NULL)) {
					GDataOutputStream* data_stream = NULL;
					GFileOutputStream* _tmp33_;
					GDataOutputStream* _tmp34_;
					GDataOutputStream* _tmp35_;
					const gchar* _tmp36_;
					const gchar* _tmp37_;
					const gchar* _tmp38_;
					const gchar* _tmp39_;
					const gchar* _tmp40_;
					const gchar* _tmp41_;
					gchar* _tmp42_;
					gchar* _tmp43_;
					GFile* _tmp44_;
					gchar* _tmp45_;
					GDesktopAppInfo* info = NULL;
					GFile* _tmp46_;
					gchar* _tmp47_;
					gchar* _tmp48_;
					GDesktopAppInfo* _tmp49_;
					GDesktopAppInfo* _tmp50_;
					GDesktopAppInfo* _tmp51_;
					GDesktopAppInfo* _tmp52_;
					const gchar* _tmp53_;
					gchar* _tmp54_;
					_tmp33_ = file_stream;
					_tmp34_ = g_data_output_stream_new ((GOutputStream*) _tmp33_);
					data_stream = _tmp34_;
					_tmp35_ = data_stream;
					_tmp36_ = self->title;
					_tmp37_ = string_to_string (_tmp36_);
					_tmp38_ = self->description;
					_tmp39_ = string_to_string (_tmp38_);
					_tmp40_ = self->command;
					_tmp41_ = string_to_string (_tmp40_);
					_tmp42_ = g_strconcat ("[Desktop Entry]\nType=Application\nName=", _tmp37_, "\nDescription=", _tmp39_, "\nExec=", _tmp41_, "\n", NULL);
					_tmp43_ = _tmp42_;
					g_data_output_stream_put_string (_tmp35_, _tmp43_, NULL, &_inner_error0_);
					_g_free0 (_tmp43_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_object_unref0 (data_stream);
						_g_object_unref0 (file_stream);
						goto __catch1_g_error;
					}
					_tmp44_ = file;
					_tmp45_ = G_TYPE_INSTANCE_GET_INTERFACE (_tmp44_, g_file_get_type (), GFileIface)->get_path (_tmp44_);
					_g_free0 (self->filename);
					self->filename = _tmp45_;
					_tmp46_ = file;
					_tmp47_ = G_TYPE_INSTANCE_GET_INTERFACE (_tmp46_, g_file_get_type (), GFileIface)->get_path (_tmp46_);
					_tmp48_ = _tmp47_;
					_tmp49_ = g_desktop_app_info_new_from_filename (_tmp48_);
					_tmp50_ = _tmp49_;
					_g_free0 (_tmp48_);
					info = _tmp50_;
					_tmp51_ = info;
					if (_tmp51_ == NULL) {
						budgie_autostart_item_delete (self);
						result = NULL;
						_g_object_unref0 (info);
						_g_object_unref0 (data_stream);
						_g_object_unref0 (file_stream);
						_g_object_unref0 (file);
						_g_free0 (destination_path);
						return result;
					}
					_tmp52_ = info;
					_tmp53_ = g_app_info_get_id ((GAppInfo*) _tmp52_);
					_tmp54_ = g_strdup (_tmp53_);
					_g_free0 (self->id);
					self->id = _tmp54_;
					_g_object_unref0 (info);
					_g_object_unref0 (data_stream);
				} else {
					result = NULL;
					_g_object_unref0 (file_stream);
					_g_object_unref0 (file);
					_g_free0 (destination_path);
					return result;
				}
				_g_object_unref0 (file_stream);
			}
			goto __finally1;
			__catch1_g_error:
			{
				GError* e = NULL;
				GError* _tmp55_;
				const gchar* _tmp56_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp55_ = e;
				_tmp56_ = _tmp55_->message;
				g_warning ("settings_autostart.vala:85: %s", _tmp56_);
				result = NULL;
				_g_error_free0 (e);
				_g_object_unref0 (file);
				_g_free0 (destination_path);
				return result;
			}
			__finally1:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (file);
				_g_free0 (destination_path);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
			_g_object_unref0 (file);
			_g_free0 (destination_path);
		}
	}
	_tmp57_ = self->filename;
	_tmp58_ = g_strdup (_tmp57_);
	result = _tmp58_;
	return result;
}

void
budgie_autostart_item_delete (BudgieAutostartItem* self)
{
	GFile* file = NULL;
	const gchar* _tmp0_;
	GFile* _tmp1_;
	GHashTable* _tmp4_;
	const gchar* _tmp5_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->filename;
	_tmp1_ = g_file_new_for_path (_tmp0_);
	file = _tmp1_;
	{
		g_file_delete (file, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("settings_autostart.vala:98: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp4_ = budgie_autostart_page_autostart_files;
	_tmp5_ = self->id;
	g_hash_table_remove (_tmp4_, _tmp5_);
	_g_object_unref0 (file);
}

BudgieAutostartItem*
budgie_autostart_item_construct (GType object_type)
{
	BudgieAutostartItem * self = NULL;
	self = (BudgieAutostartItem*) g_object_new (object_type, NULL);
	return self;
}

BudgieAutostartItem*
budgie_autostart_item_new (void)
{
	return budgie_autostart_item_construct (BUDGIE_TYPE_AUTOSTART_ITEM);
}

static GObject *
budgie_autostart_item_constructor (GType type,
                                   guint n_construct_properties,
                                   GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	BudgieAutostartItem * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	parent_class = G_OBJECT_CLASS (budgie_autostart_item_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_AUTOSTART_ITEM, BudgieAutostartItem);
	_tmp0_ = g_strdup ("");
	_g_free0 (self->id);
	self->id = _tmp0_;
	_tmp1_ = g_strdup ("");
	_g_free0 (self->filename);
	self->filename = _tmp1_;
	_tmp2_ = g_strdup ("");
	_g_free0 (self->title);
	self->title = _tmp2_;
	_tmp3_ = g_strdup ("");
	_g_free0 (self->description);
	self->description = _tmp3_;
	_tmp4_ = g_strdup ("");
	_g_free0 (self->command);
	self->command = _tmp4_;
	_tmp5_ = g_strdup ("");
	_g_free0 (self->executable);
	self->executable = _tmp5_;
	return obj;
}

static void
budgie_autostart_item_class_init (BudgieAutostartItemClass * klass,
                                  gpointer klass_data)
{
	budgie_autostart_item_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->constructor = budgie_autostart_item_constructor;
	G_OBJECT_CLASS (klass)->finalize = budgie_autostart_item_finalize;
}

static void
budgie_autostart_item_instance_init (BudgieAutostartItem * self,
                                     gpointer klass)
{
	self->icon = NULL;
}

static void
budgie_autostart_item_finalize (GObject * obj)
{
	BudgieAutostartItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_AUTOSTART_ITEM, BudgieAutostartItem);
	_g_free0 (self->id);
	_g_free0 (self->filename);
	_g_free0 (self->title);
	_g_free0 (self->description);
	_g_free0 (self->command);
	_g_free0 (self->executable);
	_g_object_unref0 (self->icon);
	G_OBJECT_CLASS (budgie_autostart_item_parent_class)->finalize (obj);
}

static GType
budgie_autostart_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieAutostartItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_autostart_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieAutostartItem), 0, (GInstanceInitFunc) budgie_autostart_item_instance_init, NULL };
	GType budgie_autostart_item_type_id;
	budgie_autostart_item_type_id = g_type_register_static (G_TYPE_OBJECT, "BudgieAutostartItem", &g_define_type_info, 0);
	return budgie_autostart_item_type_id;
}

GType
budgie_autostart_item_get_type (void)
{
	static volatile gsize budgie_autostart_item_type_id__once = 0;
	if (g_once_init_enter (&budgie_autostart_item_type_id__once)) {
		GType budgie_autostart_item_type_id;
		budgie_autostart_item_type_id = budgie_autostart_item_get_type_once ();
		g_once_init_leave (&budgie_autostart_item_type_id__once, budgie_autostart_item_type_id);
	}
	return budgie_autostart_item_type_id__once;
}

static void
___lambda16_ (BudgieAutostartItemWidget* self)
{
	BudgieAutostartItem* _tmp0_;
	_tmp0_ = self->autostart_item;
	budgie_autostart_item_delete (_tmp0_);
	gtk_widget_destroy ((GtkWidget*) self);
}

static void
____lambda16__gtk_button_clicked (GtkButton* _sender,
                                  gpointer self)
{
	___lambda16_ ((BudgieAutostartItemWidget*) self);
}

BudgieAutostartItemWidget*
budgie_autostart_item_widget_construct (GType object_type,
                                        BudgieAutostartItem* item,
                                        gboolean show_delete,
                                        gboolean running)
{
	BudgieAutostartItemWidget * self = NULL;
	BudgieAutostartItem* _tmp0_;
	GtkBox* main_box = NULL;
	GtkBox* _tmp1_;
	GtkBox* _tmp2_;
	GtkBox* _tmp3_;
	GtkImage* icon = NULL;
	GIcon* _tmp4_;
	GtkImage* _tmp8_;
	GtkBox* _tmp9_;
	GtkImage* _tmp10_;
	GtkImage* _tmp11_;
	GtkBox* text_box = NULL;
	GtkBox* _tmp12_;
	GtkBox* _tmp13_;
	GtkBox* _tmp14_;
	GtkBox* _tmp15_;
	gchar* title = NULL;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_ = NULL;
	const gchar* _tmp19_;
	gchar* _tmp25_;
	GtkLabel* title_label = NULL;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	GtkLabel* _tmp30_;
	GtkLabel* _tmp31_;
	GtkBox* _tmp32_;
	GtkLabel* _tmp33_;
	GtkLabel* _tmp34_;
	GtkLabel* _tmp35_;
	gchar* description = NULL;
	const gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_ = NULL;
	const gchar* _tmp39_;
	gchar* _tmp45_;
	GtkLabel* desc_label = NULL;
	const gchar* _tmp46_;
	GtkLabel* _tmp47_;
	GtkBox* _tmp48_;
	GtkLabel* _tmp49_;
	GtkLabel* _tmp50_;
	GtkLabel* _tmp51_;
	const gchar* _tmp52_;
	GtkLabel* _tmp53_;
	GtkLabel* _tmp54_;
	GtkLabel* _tmp55_;
	GtkStyleContext* _tmp56_;
	GtkLabel* _tmp57_;
	g_return_val_if_fail (item != NULL, NULL);
	self = (BudgieAutostartItemWidget*) g_object_new (object_type, "can-focus", FALSE, "focus-on-click", FALSE, NULL);
	_tmp0_ = _g_object_ref0 (item);
	_g_object_unref0 (self->autostart_item);
	self->autostart_item = _tmp0_;
	self->running = running;
	_tmp1_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 5);
	g_object_ref_sink (_tmp1_);
	main_box = _tmp1_;
	_tmp2_ = main_box;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp2_);
	_tmp3_ = main_box;
	g_object_set ((GtkWidget*) _tmp3_, "margin", 6, NULL);
	_tmp4_ = item->icon;
	if (_tmp4_ != NULL) {
		GIcon* _tmp5_;
		GtkImage* _tmp6_;
		_tmp5_ = item->icon;
		_tmp6_ = (GtkImage*) gtk_image_new_from_gicon (_tmp5_, (GtkIconSize) GTK_ICON_SIZE_INVALID);
		g_object_ref_sink (_tmp6_);
		_g_object_unref0 (icon);
		icon = _tmp6_;
	} else {
		GtkImage* _tmp7_;
		_tmp7_ = (GtkImage*) gtk_image_new_from_icon_name ("image-missing", (GtkIconSize) GTK_ICON_SIZE_INVALID);
		g_object_ref_sink (_tmp7_);
		_g_object_unref0 (icon);
		icon = _tmp7_;
	}
	_tmp8_ = icon;
	gtk_image_set_pixel_size (_tmp8_, 48);
	_tmp9_ = main_box;
	_tmp10_ = icon;
	gtk_box_pack_start (_tmp9_, (GtkWidget*) _tmp10_, FALSE, FALSE, (guint) 0);
	_tmp11_ = icon;
	gtk_widget_set_valign ((GtkWidget*) _tmp11_, GTK_ALIGN_CENTER);
	_tmp12_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 5);
	g_object_ref_sink (_tmp12_);
	text_box = _tmp12_;
	_tmp13_ = main_box;
	_tmp14_ = text_box;
	gtk_box_pack_start (_tmp13_, (GtkWidget*) _tmp14_, FALSE, FALSE, (guint) 0);
	_tmp15_ = text_box;
	gtk_widget_set_valign ((GtkWidget*) _tmp15_, GTK_ALIGN_CENTER);
	_tmp16_ = item->title;
	_tmp17_ = g_strdup (_tmp16_);
	title = _tmp17_;
	_tmp19_ = title;
	if (g_strcmp0 (_tmp19_, "") != 0) {
		const gchar* _tmp20_;
		gchar* _tmp21_;
		_tmp20_ = title;
		_tmp21_ = g_markup_escape_text (_tmp20_, (gssize) -1);
		_g_free0 (_tmp18_);
		_tmp18_ = _tmp21_;
	} else {
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		_tmp22_ = g_strconcat ("<i>", _ ("Untitled"), NULL);
		_tmp23_ = _tmp22_;
		_tmp24_ = g_strconcat (_tmp23_, "</i>", NULL);
		_g_free0 (_tmp18_);
		_tmp18_ = _tmp24_;
		_g_free0 (_tmp23_);
	}
	_tmp25_ = g_strdup (_tmp18_);
	_g_free0 (title);
	title = _tmp25_;
	_tmp26_ = title;
	_tmp27_ = string_to_string (_tmp26_);
	_tmp28_ = g_strconcat ("<big>", _tmp27_, "</big>", NULL);
	_tmp29_ = _tmp28_;
	_tmp30_ = (GtkLabel*) gtk_label_new (_tmp29_);
	g_object_ref_sink (_tmp30_);
	_tmp31_ = _tmp30_;
	_g_free0 (_tmp29_);
	title_label = _tmp31_;
	_tmp32_ = text_box;
	_tmp33_ = title_label;
	gtk_container_add ((GtkContainer*) _tmp32_, (GtkWidget*) _tmp33_);
	_tmp34_ = title_label;
	gtk_label_set_use_markup (_tmp34_, TRUE);
	_tmp35_ = title_label;
	gtk_widget_set_halign ((GtkWidget*) _tmp35_, GTK_ALIGN_START);
	_tmp36_ = item->description;
	_tmp37_ = g_strdup (_tmp36_);
	description = _tmp37_;
	_tmp39_ = description;
	if (g_strcmp0 (_tmp39_, "") != 0) {
		const gchar* _tmp40_;
		gchar* _tmp41_;
		_tmp40_ = description;
		_tmp41_ = g_markup_escape_text (_tmp40_, (gssize) -1);
		_g_free0 (_tmp38_);
		_tmp38_ = _tmp41_;
	} else {
		gchar* _tmp42_;
		gchar* _tmp43_;
		gchar* _tmp44_;
		_tmp42_ = g_strconcat ("<i>", _ ("No description"), NULL);
		_tmp43_ = _tmp42_;
		_tmp44_ = g_strconcat (_tmp43_, "</i>", NULL);
		_g_free0 (_tmp38_);
		_tmp38_ = _tmp44_;
		_g_free0 (_tmp43_);
	}
	_tmp45_ = g_strdup (_tmp38_);
	_g_free0 (description);
	description = _tmp45_;
	_tmp46_ = description;
	_tmp47_ = (GtkLabel*) gtk_label_new (_tmp46_);
	g_object_ref_sink (_tmp47_);
	desc_label = _tmp47_;
	_tmp48_ = text_box;
	_tmp49_ = desc_label;
	gtk_container_add ((GtkContainer*) _tmp48_, (GtkWidget*) _tmp49_);
	_tmp50_ = desc_label;
	gtk_label_set_max_width_chars (_tmp50_, 35);
	_tmp51_ = desc_label;
	_tmp52_ = description;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp51_, _tmp52_);
	_tmp53_ = desc_label;
	gtk_label_set_ellipsize (_tmp53_, PANGO_ELLIPSIZE_END);
	_tmp54_ = desc_label;
	gtk_label_set_use_markup (_tmp54_, TRUE);
	_tmp55_ = desc_label;
	_tmp56_ = gtk_widget_get_style_context ((GtkWidget*) _tmp55_);
	gtk_style_context_add_class (_tmp56_, "dim-label");
	_tmp57_ = desc_label;
	gtk_widget_set_halign ((GtkWidget*) _tmp57_, GTK_ALIGN_START);
	if (show_delete) {
		GtkButton* remove_button = NULL;
		GtkButton* _tmp58_;
		GtkBox* _tmp59_;
		GtkButton* _tmp60_;
		GtkButton* _tmp61_;
		GtkStyleContext* _tmp62_;
		GtkButton* _tmp63_;
		GtkStyleContext* _tmp64_;
		GtkButton* _tmp65_;
		GtkButton* _tmp66_;
		_tmp58_ = (GtkButton*) gtk_button_new_from_icon_name ("list-remove-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
		g_object_ref_sink (_tmp58_);
		remove_button = _tmp58_;
		_tmp59_ = main_box;
		_tmp60_ = remove_button;
		gtk_box_pack_end (_tmp59_, (GtkWidget*) _tmp60_, FALSE, FALSE, (guint) 0);
		_tmp61_ = remove_button;
		_tmp62_ = gtk_widget_get_style_context ((GtkWidget*) _tmp61_);
		gtk_style_context_add_class (_tmp62_, GTK_STYLE_CLASS_DESTRUCTIVE_ACTION);
		_tmp63_ = remove_button;
		_tmp64_ = gtk_widget_get_style_context ((GtkWidget*) _tmp63_);
		gtk_style_context_add_class (_tmp64_, "round-button");
		_tmp65_ = remove_button;
		gtk_widget_set_valign ((GtkWidget*) _tmp65_, GTK_ALIGN_CENTER);
		_tmp66_ = remove_button;
		g_signal_connect_object (_tmp66_, "clicked", (GCallback) ____lambda16__gtk_button_clicked, self, 0);
		_g_object_unref0 (remove_button);
	}
	if (running) {
		GtkLabel* running_label = NULL;
		GtkLabel* _tmp67_;
		GtkBox* _tmp68_;
		GtkLabel* _tmp69_;
		GtkLabel* _tmp70_;
		GtkStyleContext* _tmp71_;
		GtkLabel* _tmp72_;
		_tmp67_ = (GtkLabel*) gtk_label_new (_ ("running"));
		g_object_ref_sink (_tmp67_);
		running_label = _tmp67_;
		_tmp68_ = main_box;
		_tmp69_ = running_label;
		gtk_box_pack_end (_tmp68_, (GtkWidget*) _tmp69_, FALSE, FALSE, (guint) 0);
		_tmp70_ = running_label;
		_tmp71_ = gtk_widget_get_style_context ((GtkWidget*) _tmp70_);
		gtk_style_context_add_class (_tmp71_, "dim-label");
		_tmp72_ = running_label;
		gtk_widget_set_valign ((GtkWidget*) _tmp72_, GTK_ALIGN_CENTER);
		_g_object_unref0 (running_label);
	}
	gtk_widget_show_all ((GtkWidget*) self);
	_g_object_unref0 (desc_label);
	_g_free0 (_tmp38_);
	_g_free0 (description);
	_g_object_unref0 (title_label);
	_g_free0 (_tmp18_);
	_g_free0 (title);
	_g_object_unref0 (text_box);
	_g_object_unref0 (icon);
	_g_object_unref0 (main_box);
	return self;
}

BudgieAutostartItemWidget*
budgie_autostart_item_widget_new (BudgieAutostartItem* item,
                                  gboolean show_delete,
                                  gboolean running)
{
	return budgie_autostart_item_widget_construct (BUDGIE_TYPE_AUTOSTART_ITEM_WIDGET, item, show_delete, running);
}

static void
budgie_autostart_item_widget_class_init (BudgieAutostartItemWidgetClass * klass,
                                         gpointer klass_data)
{
	budgie_autostart_item_widget_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = budgie_autostart_item_widget_finalize;
}

static void
budgie_autostart_item_widget_instance_init (BudgieAutostartItemWidget * self,
                                            gpointer klass)
{
}

static void
budgie_autostart_item_widget_finalize (GObject * obj)
{
	BudgieAutostartItemWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_AUTOSTART_ITEM_WIDGET, BudgieAutostartItemWidget);
	_g_object_unref0 (self->autostart_item);
	G_OBJECT_CLASS (budgie_autostart_item_widget_parent_class)->finalize (obj);
}

static GType
budgie_autostart_item_widget_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieAutostartItemWidgetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_autostart_item_widget_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieAutostartItemWidget), 0, (GInstanceInitFunc) budgie_autostart_item_widget_instance_init, NULL };
	GType budgie_autostart_item_widget_type_id;
	budgie_autostart_item_widget_type_id = g_type_register_static (gtk_list_box_row_get_type (), "BudgieAutostartItemWidget", &g_define_type_info, 0);
	return budgie_autostart_item_widget_type_id;
}

GType
budgie_autostart_item_widget_get_type (void)
{
	static volatile gsize budgie_autostart_item_widget_type_id__once = 0;
	if (g_once_init_enter (&budgie_autostart_item_widget_type_id__once)) {
		GType budgie_autostart_item_widget_type_id;
		budgie_autostart_item_widget_type_id = budgie_autostart_item_widget_get_type_once ();
		g_once_init_leave (&budgie_autostart_item_widget_type_id__once, budgie_autostart_item_widget_type_id);
	}
	return budgie_autostart_item_widget_type_id__once;
}

static inline gpointer
budgie_app_chooser_get_instance_private (BudgieAppChooser* self)
{
	return G_STRUCT_MEMBER_P (self, BudgieAppChooser_private_offset);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static gboolean
_gtk_search_bar_handle_event_gtk_widget_key_press_event (GtkWidget* _sender,
                                                         GdkEventKey* event,
                                                         gpointer self)
{
	gboolean result;
	result = gtk_search_bar_handle_event ((GtkSearchBar*) self, event);
	return result;
}

static void
__lambda15_ (BudgieAppChooser* self)
{
	GtkListBox* _tmp0_;
	GtkListBox* _tmp1_;
	_tmp0_ = self->priv->app_listbox;
	gtk_list_box_invalidate_filter (_tmp0_);
	_tmp1_ = self->priv->app_listbox;
	gtk_list_box_invalidate_sort (_tmp1_);
}

static void
___lambda15__gtk_editable_changed (GtkEditable* _sender,
                                   gpointer self)
{
	__lambda15_ ((BudgieAppChooser*) self);
}

static gboolean
_budgie_app_chooser_search_filter_gtk_list_box_filter_func (GtkListBoxRow* row,
                                                            gpointer self)
{
	gboolean result;
	result = budgie_app_chooser_search_filter ((BudgieAppChooser*) self, row);
	return result;
}

static gint
_budgie_app_chooser_sort_function_gtk_list_box_sort_func (GtkListBoxRow* row1,
                                                          GtkListBoxRow* row2,
                                                          gpointer self)
{
	gint result;
	result = budgie_app_chooser_sort_function ((BudgieAppChooser*) self, row1, row2);
	return result;
}

static void
_budgie_app_chooser_row_selected_gtk_list_box_row_selected (GtkListBox* _sender,
                                                            GtkListBoxRow* row,
                                                            gpointer self)
{
	budgie_app_chooser_row_selected ((BudgieAppChooser*) self, row);
}

static void
_budgie_app_chooser_row_activated_gtk_list_box_row_activated (GtkListBox* _sender,
                                                              GtkListBoxRow* row,
                                                              gpointer self)
{
	budgie_app_chooser_row_activated ((BudgieAppChooser*) self, row);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

BudgieAppChooser*
budgie_app_chooser_construct (GType object_type,
                              GtkWindow* parent)
{
	BudgieAppChooser * self = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GtkBox* content_area = NULL;
	GtkBox* _tmp3_;
	GtkBox* _tmp4_;
	GtkWidget* _tmp5_;
	GtkWidget* _tmp6_;
	GtkWidget* _tmp7_;
	GtkWidget* _tmp8_;
	GtkStyleContext* _tmp9_;
	GtkHeaderBar* header_bar = NULL;
	GtkHeaderBar* _tmp10_;
	GtkHeaderBar* _tmp11_;
	GtkToggleButton* search_button = NULL;
	GtkToggleButton* _tmp12_;
	GtkImage* _tmp13_;
	GtkImage* _tmp14_;
	GtkSearchBar* search_bar = NULL;
	GtkSearchBar* _tmp15_;
	GtkSearchEntry* _tmp16_;
	GtkSearchEntry* _tmp17_;
	GtkSearchEntry* _tmp18_;
	GtkScrolledWindow* scroll = NULL;
	GtkScrolledWindow* _tmp19_;
	GtkListBox* _tmp20_;
	GtkListBox* _tmp21_;
	GtkListBox* _tmp22_;
	GtkListBox* _tmp23_;
	GtkListBox* _tmp24_;
	GtkListBox* _tmp25_;
	GtkListBox* _tmp26_;
	GList* _tmp27_;
	GList* _tmp28_;
	g_return_val_if_fail (parent != NULL, NULL);
	self = (BudgieAppChooser*) g_object_new (object_type, "use-header-bar", 1, "modal", TRUE, "title", _ ("Applications"), "transient-for", parent, NULL);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, NULL, _g_free0_);
	_g_hash_table_unref0 (self->priv->running_processes);
	self->priv->running_processes = _tmp2_;
	budgie_app_chooser_get_running_processes (self);
	_tmp3_ = gtk_dialog_get_content_area ((GtkDialog*) self);
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, gtk_box_get_type ()) ? ((GtkBox*) _tmp3_) : NULL);
	content_area = _tmp4_;
	gtk_dialog_add_button ((GtkDialog*) self, _ ("Cancel"), (gint) GTK_RESPONSE_CANCEL);
	_tmp5_ = gtk_dialog_add_button ((GtkDialog*) self, _ ("Add"), (gint) GTK_RESPONSE_ACCEPT);
	_tmp6_ = _g_object_ref0 (_tmp5_);
	_g_object_unref0 (self->priv->button_ok);
	self->priv->button_ok = _tmp6_;
	_tmp7_ = self->priv->button_ok;
	gtk_widget_set_sensitive (_tmp7_, FALSE);
	_tmp8_ = self->priv->button_ok;
	_tmp9_ = gtk_widget_get_style_context (_tmp8_);
	gtk_style_context_add_class (_tmp9_, GTK_STYLE_CLASS_SUGGESTED_ACTION);
	_tmp10_ = gtk_dialog_get_header_bar ((GtkDialog*) self);
	_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, gtk_header_bar_get_type ()) ? ((GtkHeaderBar*) _tmp10_) : NULL);
	header_bar = _tmp11_;
	_tmp12_ = (GtkToggleButton*) gtk_toggle_button_new ();
	g_object_ref_sink (_tmp12_);
	search_button = _tmp12_;
	_tmp13_ = (GtkImage*) gtk_image_new_from_icon_name ("system-search-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp13_);
	_tmp14_ = _tmp13_;
	gtk_button_set_image ((GtkButton*) search_button, (GtkWidget*) _tmp14_);
	_g_object_unref0 (_tmp14_);
	gtk_header_bar_pack_end (header_bar, (GtkWidget*) search_button);
	_tmp15_ = (GtkSearchBar*) gtk_search_bar_new ();
	g_object_ref_sink (_tmp15_);
	search_bar = _tmp15_;
	gtk_box_pack_start (content_area, (GtkWidget*) search_bar, FALSE, FALSE, (guint) 0);
	gtk_widget_show_all ((GtkWidget*) search_bar);
	g_object_bind_property_with_closures ((GObject*) search_button, "active", (GObject*) search_bar, "search-mode-enabled", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	g_object_bind_property_with_closures ((GObject*) search_bar, "search-mode-enabled", (GObject*) search_button, "active", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	g_signal_connect_object ((GtkWidget*) self, "key-press-event", (GCallback) _gtk_search_bar_handle_event_gtk_widget_key_press_event, search_bar, 0);
	_tmp16_ = (GtkSearchEntry*) gtk_search_entry_new ();
	g_object_ref_sink (_tmp16_);
	_g_object_unref0 (self->priv->search_entry);
	self->priv->search_entry = _tmp16_;
	_tmp17_ = self->priv->search_entry;
	gtk_container_add ((GtkContainer*) search_bar, (GtkWidget*) _tmp17_);
	_tmp18_ = self->priv->search_entry;
	g_signal_connect_object ((GtkEditable*) _tmp18_, "changed", (GCallback) ___lambda15__gtk_editable_changed, self, 0);
	_tmp19_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp19_);
	scroll = _tmp19_;
	gtk_box_pack_start (content_area, (GtkWidget*) scroll, TRUE, TRUE, (guint) 0);
	gtk_scrolled_window_set_policy (scroll, GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
	_tmp20_ = (GtkListBox*) gtk_list_box_new ();
	g_object_ref_sink (_tmp20_);
	_g_object_unref0 (self->priv->app_listbox);
	self->priv->app_listbox = _tmp20_;
	_tmp21_ = self->priv->app_listbox;
	gtk_container_add ((GtkContainer*) scroll, (GtkWidget*) _tmp21_);
	_tmp22_ = self->priv->app_listbox;
	gtk_list_box_set_filter_func (_tmp22_, _budgie_app_chooser_search_filter_gtk_list_box_filter_func, g_object_ref (self), g_object_unref);
	_tmp23_ = self->priv->app_listbox;
	gtk_list_box_set_sort_func (_tmp23_, _budgie_app_chooser_sort_function_gtk_list_box_sort_func, g_object_ref (self), g_object_unref);
	_tmp24_ = self->priv->app_listbox;
	gtk_list_box_set_activate_on_single_click (_tmp24_, FALSE);
	_tmp25_ = self->priv->app_listbox;
	g_signal_connect_object (_tmp25_, "row-selected", (GCallback) _budgie_app_chooser_row_selected_gtk_list_box_row_selected, self, 0);
	_tmp26_ = self->priv->app_listbox;
	g_signal_connect_object (_tmp26_, "row-activated", (GCallback) _budgie_app_chooser_row_activated_gtk_list_box_row_activated, self, 0);
	gtk_widget_show_all ((GtkWidget*) content_area);
	gtk_window_set_default_size ((GtkWindow*) self, 400, 450);
	_tmp27_ = g_app_info_get_all ();
	_tmp28_ = _tmp27_;
	budgie_app_chooser_set_app_list (self, _tmp28_);
	(_tmp28_ == NULL) ? NULL : (_tmp28_ = (_g_list_free__g_object_unref0_ (_tmp28_), NULL));
	_g_object_unref0 (scroll);
	_g_object_unref0 (search_bar);
	_g_object_unref0 (search_button);
	_g_object_unref0 (header_bar);
	_g_object_unref0 (content_area);
	return self;
}

BudgieAppChooser*
budgie_app_chooser_new (GtkWindow* parent)
{
	return budgie_app_chooser_construct (BUDGIE_TYPE_APP_CHOOSER, parent);
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gboolean
budgie_app_chooser_search_filter (BudgieAppChooser* self,
                                  GtkListBoxRow* row)
{
	BudgieAutostartItem* item = NULL;
	BudgieAutostartItem* _tmp0_;
	BudgieAutostartItem* _tmp1_;
	GHashTable* _tmp2_;
	BudgieAutostartItem* _tmp3_;
	const gchar* _tmp4_;
	gchar* search_text = NULL;
	GtkSearchEntry* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* title_text = NULL;
	BudgieAutostartItem* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* desc_text = NULL;
	BudgieAutostartItem* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gboolean _tmp14_ = FALSE;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (row != NULL, FALSE);
	_tmp0_ = G_TYPE_CHECK_INSTANCE_CAST (row, BUDGIE_TYPE_AUTOSTART_ITEM_WIDGET, BudgieAutostartItemWidget)->autostart_item;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	item = _tmp1_;
	_tmp2_ = budgie_autostart_page_autostart_files;
	_tmp3_ = item;
	_tmp4_ = _tmp3_->id;
	if (g_hash_table_contains (_tmp2_, _tmp4_)) {
		result = FALSE;
		_g_object_unref0 (item);
		return result;
	}
	_tmp5_ = self->priv->search_entry;
	_tmp6_ = gtk_entry_get_text ((GtkEntry*) _tmp5_);
	_tmp7_ = g_utf8_strdown (_tmp6_, (gssize) -1);
	search_text = _tmp7_;
	_tmp8_ = item;
	_tmp9_ = _tmp8_->title;
	_tmp10_ = g_utf8_strdown (_tmp9_, (gssize) -1);
	title_text = _tmp10_;
	_tmp11_ = item;
	_tmp12_ = _tmp11_->description;
	_tmp13_ = g_utf8_strdown (_tmp12_, (gssize) -1);
	desc_text = _tmp13_;
	_tmp15_ = title_text;
	_tmp16_ = search_text;
	if (string_contains (_tmp15_, _tmp16_)) {
		_tmp14_ = TRUE;
	} else {
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		_tmp17_ = desc_text;
		_tmp18_ = search_text;
		_tmp14_ = string_contains (_tmp17_, _tmp18_);
	}
	result = _tmp14_;
	_g_free0 (desc_text);
	_g_free0 (title_text);
	_g_free0 (search_text);
	_g_object_unref0 (item);
	return result;
}

static gint
budgie_app_chooser_sort_function (BudgieAppChooser* self,
                                  GtkListBoxRow* row1,
                                  GtkListBoxRow* row2)
{
	BudgieAutostartItemWidget* item1 = NULL;
	BudgieAutostartItemWidget* _tmp0_;
	BudgieAutostartItemWidget* item2 = NULL;
	BudgieAutostartItemWidget* _tmp1_;
	gboolean _tmp2_ = FALSE;
	BudgieAutostartItemWidget* _tmp3_;
	GCompareFunc _tmp8_;
	BudgieAutostartItemWidget* _tmp9_;
	BudgieAutostartItem* _tmp10_;
	const gchar* _tmp11_;
	BudgieAutostartItemWidget* _tmp12_;
	BudgieAutostartItem* _tmp13_;
	const gchar* _tmp14_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (row1 != NULL, 0);
	g_return_val_if_fail (row2 != NULL, 0);
	_tmp0_ = _g_object_ref0 (BUDGIE_IS_AUTOSTART_ITEM_WIDGET (row1) ? ((BudgieAutostartItemWidget*) row1) : NULL);
	item1 = _tmp0_;
	_tmp1_ = _g_object_ref0 (BUDGIE_IS_AUTOSTART_ITEM_WIDGET (row2) ? ((BudgieAutostartItemWidget*) row2) : NULL);
	item2 = _tmp1_;
	_tmp3_ = item1;
	if (_tmp3_->running) {
		BudgieAutostartItemWidget* _tmp4_;
		_tmp4_ = item2;
		_tmp2_ = !_tmp4_->running;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		result = -1;
		_g_object_unref0 (item2);
		_g_object_unref0 (item1);
		return result;
	} else {
		gboolean _tmp5_ = FALSE;
		BudgieAutostartItemWidget* _tmp6_;
		_tmp6_ = item1;
		if (!_tmp6_->running) {
			BudgieAutostartItemWidget* _tmp7_;
			_tmp7_ = item2;
			_tmp5_ = _tmp7_->running;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			result = 1;
			_g_object_unref0 (item2);
			_g_object_unref0 (item1);
			return result;
		}
	}
	_tmp8_ = ((GCompareFunc) g_strcmp0);
	_tmp9_ = item1;
	_tmp10_ = _tmp9_->autostart_item;
	_tmp11_ = _tmp10_->title;
	_tmp12_ = item2;
	_tmp13_ = _tmp12_->autostart_item;
	_tmp14_ = _tmp13_->title;
	result = _tmp8_ (_tmp11_, _tmp14_);
	_g_object_unref0 (item2);
	_g_object_unref0 (item1);
	return result;
}

BudgieAutostartItem*
budgie_app_chooser_run (BudgieAppChooser* self)
{
	GtkResponseType resp = 0;
	BudgieAutostartItem* result;
	g_return_val_if_fail (self != NULL, NULL);
	resp = (GtkResponseType) gtk_dialog_run (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_dialog_get_type (), GtkDialog));
	switch (resp) {
		case GTK_RESPONSE_ACCEPT:
		{
			BudgieAutostartItem* _tmp0_;
			BudgieAutostartItem* _tmp1_;
			_tmp0_ = self->priv->selected_item;
			_tmp1_ = _g_object_ref0 (_tmp0_);
			result = _tmp1_;
			return result;
		}
		default:
		case GTK_RESPONSE_CANCEL:
		{
			result = NULL;
			return result;
		}
	}
}

static void
budgie_app_chooser_row_selected (BudgieAppChooser* self,
                                 GtkListBoxRow* row)
{
	GtkWidget* _tmp1_;
	BudgieAutostartItem* _tmp2_;
	BudgieAutostartItem* _tmp3_;
	g_return_if_fail (self != NULL);
	if (row == NULL) {
		GtkWidget* _tmp0_;
		_g_object_unref0 (self->priv->selected_item);
		self->priv->selected_item = NULL;
		_tmp0_ = self->priv->button_ok;
		gtk_widget_set_sensitive (_tmp0_, FALSE);
		return;
	}
	_tmp1_ = self->priv->button_ok;
	gtk_widget_set_sensitive (_tmp1_, TRUE);
	_tmp2_ = G_TYPE_CHECK_INSTANCE_CAST (row, BUDGIE_TYPE_AUTOSTART_ITEM_WIDGET, BudgieAutostartItemWidget)->autostart_item;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->selected_item);
	self->priv->selected_item = _tmp3_;
}

static void
budgie_app_chooser_row_activated (BudgieAppChooser* self,
                                  GtkListBoxRow* row)
{
	BudgieAutostartItem* _tmp0_;
	g_return_if_fail (self != NULL);
	budgie_app_chooser_row_selected (self, row);
	_tmp0_ = self->priv->selected_item;
	if (_tmp0_ != NULL) {
		gtk_dialog_response ((GtkDialog*) self, (gint) GTK_RESPONSE_ACCEPT);
	}
}

static void
budgie_app_chooser_set_app_list (BudgieAppChooser* self,
                                 GList* app_list)
{
	GtkListBox* _tmp0_;
	GList* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->app_listbox;
	_tmp1_ = gtk_container_get_children ((GtkContainer*) _tmp0_);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp1_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			GtkWidget* child = NULL;
			child = (GtkWidget*) child_it->data;
			{
				GtkWidget* _tmp2_;
				_tmp2_ = child;
				gtk_widget_destroy (_tmp2_);
			}
		}
		(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
	}
	{
		GList* app_collection = NULL;
		GList* app_it = NULL;
		app_collection = app_list;
		for (app_it = app_collection; app_it != NULL; app_it = app_it->next) {
			GAppInfo* _tmp3_;
			GAppInfo* app = NULL;
			_tmp3_ = _g_object_ref0 ((GAppInfo*) app_it->data);
			app = _tmp3_;
			{
				GAppInfo* _tmp4_;
				_tmp4_ = app;
				if (g_app_info_should_show (_tmp4_)) {
					GDesktopAppInfo* info = NULL;
					GAppInfo* _tmp5_;
					const gchar* _tmp6_;
					GDesktopAppInfo* _tmp7_;
					GDesktopAppInfo* _tmp8_;
					_tmp5_ = app;
					_tmp6_ = g_app_info_get_id (_tmp5_);
					_tmp7_ = g_desktop_app_info_new (_tmp6_);
					info = _tmp7_;
					_tmp8_ = info;
					if (_tmp8_ != NULL) {
						BudgieAutostartItem* item = NULL;
						GDesktopAppInfo* _tmp9_;
						BudgieAutostartItem* _tmp10_;
						gboolean running = FALSE;
						GHashTable* _tmp11_;
						BudgieAutostartItem* _tmp12_;
						const gchar* _tmp13_;
						GtkListBox* _tmp14_;
						BudgieAutostartItem* _tmp15_;
						BudgieAutostartItemWidget* _tmp16_;
						BudgieAutostartItemWidget* _tmp17_;
						_tmp9_ = info;
						_tmp10_ = budgie_autostart_item_new_from_app_info (_tmp9_);
						item = _tmp10_;
						_tmp11_ = self->priv->running_processes;
						_tmp12_ = item;
						_tmp13_ = _tmp12_->executable;
						running = g_hash_table_contains (_tmp11_, _tmp13_);
						_tmp14_ = self->priv->app_listbox;
						_tmp15_ = item;
						_tmp16_ = budgie_autostart_item_widget_new (_tmp15_, FALSE, running);
						g_object_ref_sink (_tmp16_);
						_tmp17_ = _tmp16_;
						gtk_container_add ((GtkContainer*) _tmp14_, (GtkWidget*) _tmp17_);
						_g_object_unref0 (_tmp17_);
						_g_object_unref0 (item);
					}
					_g_object_unref0 (info);
				}
				_g_object_unref0 (app);
			}
		}
	}
	gtk_widget_show_all ((GtkWidget*) self);
}

static void
budgie_app_chooser_get_running_processes (BudgieAppChooser* self)
{
	gchar* ls_stdout = NULL;
	gchar* ls_stderr = NULL;
	gint ls_status = 0;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		gchar* username = NULL;
		const gchar* _tmp0_;
		gchar* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		gchar** commands = NULL;
		const gchar* _tmp9_;
		gchar** _tmp10_;
		gchar** _tmp11_;
		gint commands_length1;
		gint _commands_size_;
		gchar** _tmp12_;
		gint _tmp12__length1;
		_tmp0_ = g_get_user_name ();
		_tmp1_ = g_strdup (_tmp0_);
		username = _tmp1_;
		_tmp2_ = username;
		_tmp3_ = string_to_string (_tmp2_);
		_tmp4_ = g_strconcat ("ps -e -w -w -U ", _tmp3_, " -o cmd", NULL);
		_tmp5_ = _tmp4_;
		g_spawn_command_line_sync (_tmp5_, &_tmp6_, &_tmp7_, &_tmp8_, &_inner_error0_);
		_g_free0 (ls_stdout);
		ls_stdout = _tmp6_;
		_g_free0 (ls_stderr);
		ls_stderr = _tmp7_;
		ls_status = _tmp8_;
		_g_free0 (_tmp5_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (username);
			if (_inner_error0_->domain == G_SPAWN_ERROR) {
				goto __catch0_g_spawn_error;
			}
			_g_free0 (ls_stderr);
			_g_free0 (ls_stdout);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		if (ls_status != 0) {
			_g_free0 (username);
			_g_free0 (ls_stderr);
			_g_free0 (ls_stdout);
			return;
		}
		_tmp9_ = ls_stdout;
		_tmp11_ = _tmp10_ = g_strsplit (_tmp9_, "\n", 0);
		commands = _tmp11_;
		commands_length1 = _vala_array_length (_tmp10_);
		_commands_size_ = commands_length1;
		_tmp12_ = commands;
		_tmp12__length1 = commands_length1;
		{
			gchar** line_collection = NULL;
			gint line_collection_length1 = 0;
			gint _line_collection_size_ = 0;
			gint line_it = 0;
			line_collection = _tmp12_;
			line_collection_length1 = _tmp12__length1;
			for (line_it = 0; line_it < line_collection_length1; line_it = line_it + 1) {
				gchar* _tmp13_;
				gchar* line = NULL;
				_tmp13_ = g_strdup (line_collection[line_it]);
				line = _tmp13_;
				{
					gchar* command = NULL;
					const gchar* _tmp14_;
					gchar** _tmp15_;
					gchar** _tmp16_;
					gchar** _tmp17_;
					gint _tmp17__length1;
					const gchar* _tmp18_;
					gchar* _tmp19_;
					gchar* _tmp20_;
					gboolean _tmp21_ = FALSE;
					const gchar* _tmp22_;
					_tmp14_ = line;
					_tmp16_ = _tmp15_ = g_strsplit (_tmp14_, " ", 0);
					_tmp17_ = _tmp16_;
					_tmp17__length1 = _vala_array_length (_tmp15_);
					_tmp18_ = _tmp17_[0];
					_tmp19_ = g_strdup (_tmp18_);
					_tmp20_ = _tmp19_;
					_tmp17_ = (_vala_array_free (_tmp17_, _tmp17__length1, (GDestroyNotify) g_free), NULL);
					command = _tmp20_;
					_tmp22_ = command;
					if (_tmp22_ != NULL) {
						const gchar* _tmp23_;
						_tmp23_ = command;
						_tmp21_ = g_strcmp0 (_tmp23_, "") != 0;
					} else {
						_tmp21_ = FALSE;
					}
					if (_tmp21_) {
						const gchar* _tmp24_;
						_tmp24_ = command;
						if (!g_str_has_prefix (_tmp24_, "[")) {
							GHashTable* _tmp25_;
							const gchar* _tmp26_;
							gchar* _tmp27_;
							_tmp25_ = self->priv->running_processes;
							_tmp26_ = command;
							_tmp27_ = g_strdup (_tmp26_);
							g_hash_table_add (_tmp25_, _tmp27_);
						}
					}
					_g_free0 (command);
					_g_free0 (line);
				}
			}
		}
		commands = (_vala_array_free (commands, commands_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (username);
	}
	goto __finally0;
	__catch0_g_spawn_error:
	{
		GError* e = NULL;
		GError* _tmp28_;
		const gchar* _tmp29_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp28_ = e;
		_tmp29_ = _tmp28_->message;
		g_warning ("settings_autostart.vala:339: %s", _tmp29_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (ls_stderr);
		_g_free0 (ls_stdout);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (ls_stderr);
	_g_free0 (ls_stdout);
}

static void
budgie_app_chooser_class_init (BudgieAppChooserClass * klass,
                               gpointer klass_data)
{
	budgie_app_chooser_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BudgieAppChooser_private_offset);
	G_OBJECT_CLASS (klass)->finalize = budgie_app_chooser_finalize;
}

static void
budgie_app_chooser_instance_init (BudgieAppChooser * self,
                                  gpointer klass)
{
	self->priv = budgie_app_chooser_get_instance_private (self);
	self->priv->selected_item = NULL;
}

static void
budgie_app_chooser_finalize (GObject * obj)
{
	BudgieAppChooser * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_APP_CHOOSER, BudgieAppChooser);
	_g_object_unref0 (self->priv->app_listbox);
	_g_object_unref0 (self->priv->button_ok);
	_g_object_unref0 (self->priv->search_entry);
	_g_hash_table_unref0 (self->priv->running_processes);
	_g_object_unref0 (self->priv->selected_item);
	G_OBJECT_CLASS (budgie_app_chooser_parent_class)->finalize (obj);
}

static GType
budgie_app_chooser_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieAppChooserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_app_chooser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieAppChooser), 0, (GInstanceInitFunc) budgie_app_chooser_instance_init, NULL };
	GType budgie_app_chooser_type_id;
	budgie_app_chooser_type_id = g_type_register_static (gtk_dialog_get_type (), "BudgieAppChooser", &g_define_type_info, 0);
	BudgieAppChooser_private_offset = g_type_add_instance_private (budgie_app_chooser_type_id, sizeof (BudgieAppChooserPrivate));
	return budgie_app_chooser_type_id;
}

GType
budgie_app_chooser_get_type (void)
{
	static volatile gsize budgie_app_chooser_type_id__once = 0;
	if (g_once_init_enter (&budgie_app_chooser_type_id__once)) {
		GType budgie_app_chooser_type_id;
		budgie_app_chooser_type_id = budgie_app_chooser_get_type_once ();
		g_once_init_leave (&budgie_app_chooser_type_id__once, budgie_app_chooser_type_id);
	}
	return budgie_app_chooser_type_id__once;
}

static inline gpointer
budgie_command_dialog_get_instance_private (BudgieCommandDialog* self)
{
	return G_STRUCT_MEMBER_P (self, BudgieCommandDialog_private_offset);
}

static void
_budgie_command_dialog_check_inputs_gtk_editable_changed (GtkEditable* _sender,
                                                          gpointer self)
{
	budgie_command_dialog_check_inputs ((BudgieCommandDialog*) self);
}

BudgieCommandDialog*
budgie_command_dialog_construct (GType object_type,
                                 GtkWindow* parent)
{
	BudgieCommandDialog * self = NULL;
	GtkBox* content_area = NULL;
	GtkBox* _tmp0_;
	GtkBox* _tmp1_;
	GtkWidget* _tmp2_;
	GtkWidget* _tmp3_;
	GtkWidget* _tmp4_;
	GtkWidget* _tmp5_;
	GtkStyleContext* _tmp6_;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp7_;
	GtkLabel* _tmp8_;
	GtkLabel* _tmp9_;
	GtkLabel* label = NULL;
	GtkLabel* _tmp10_;
	GtkLabel* _tmp11_;
	GtkLabel* _tmp12_;
	GtkEntry* _tmp13_;
	GtkEntry* _tmp14_;
	GtkEntry* _tmp15_;
	GtkLabel* _tmp16_;
	GtkLabel* _tmp17_;
	GtkLabel* _tmp18_;
	GtkEntry* _tmp19_;
	GtkEntry* _tmp20_;
	GtkEntry* _tmp21_;
	GtkLabel* _tmp22_;
	GtkLabel* _tmp23_;
	GtkLabel* _tmp24_;
	GtkEntry* _tmp25_;
	GtkEntry* _tmp26_;
	GtkEntry* _tmp27_;
	GtkEntry* _tmp28_;
	GtkEntry* _tmp29_;
	GtkLabel* _tmp30_;
	g_return_val_if_fail (parent != NULL, NULL);
	self = (BudgieCommandDialog*) g_object_new (object_type, "use-header-bar", 1, "modal", TRUE, "title", _ ("Command"), "transient-for", parent, NULL);
	_tmp0_ = gtk_dialog_get_content_area ((GtkDialog*) self);
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gtk_box_get_type ()) ? ((GtkBox*) _tmp0_) : NULL);
	content_area = _tmp1_;
	gtk_dialog_add_button ((GtkDialog*) self, _ ("Cancel"), (gint) GTK_RESPONSE_CANCEL);
	_tmp2_ = gtk_dialog_add_button ((GtkDialog*) self, _ ("Add"), (gint) GTK_RESPONSE_ACCEPT);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->button_ok);
	self->priv->button_ok = _tmp3_;
	_tmp4_ = self->priv->button_ok;
	gtk_widget_set_sensitive (_tmp4_, FALSE);
	_tmp5_ = self->priv->button_ok;
	_tmp6_ = gtk_widget_get_style_context (_tmp5_);
	gtk_style_context_add_class (_tmp6_, GTK_STYLE_CLASS_SUGGESTED_ACTION);
	_tmp7_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp7_);
	grid = _tmp7_;
	gtk_grid_set_column_spacing (grid, (guint) 20);
	gtk_grid_set_row_spacing (grid, (guint) 10);
	gtk_widget_set_halign ((GtkWidget*) grid, GTK_ALIGN_CENTER);
	gtk_widget_set_valign ((GtkWidget*) grid, GTK_ALIGN_CENTER);
	_tmp8_ = (GtkLabel*) gtk_label_new (_ ("An entry with that title already exists"));
	g_object_ref_sink (_tmp8_);
	_g_object_unref0 (self->priv->exists_label);
	self->priv->exists_label = _tmp8_;
	_tmp9_ = self->priv->exists_label;
	gtk_grid_attach (grid, (GtkWidget*) _tmp9_, 0, 0, 2, 1);
	_tmp10_ = (GtkLabel*) gtk_label_new (_ ("Title"));
	g_object_ref_sink (_tmp10_);
	label = _tmp10_;
	_tmp11_ = label;
	gtk_widget_set_halign ((GtkWidget*) _tmp11_, GTK_ALIGN_START);
	_tmp12_ = label;
	gtk_grid_attach (grid, (GtkWidget*) _tmp12_, 0, 1, 1, 1);
	_tmp13_ = (GtkEntry*) gtk_entry_new ();
	g_object_ref_sink (_tmp13_);
	_g_object_unref0 (self->priv->title_entry);
	self->priv->title_entry = _tmp13_;
	_tmp14_ = self->priv->title_entry;
	gtk_entry_set_placeholder_text (_tmp14_, _ ("Required"));
	_tmp15_ = self->priv->title_entry;
	gtk_grid_attach (grid, (GtkWidget*) _tmp15_, 1, 1, 1, 1);
	_tmp16_ = (GtkLabel*) gtk_label_new (_ ("Description"));
	g_object_ref_sink (_tmp16_);
	_g_object_unref0 (label);
	label = _tmp16_;
	_tmp17_ = label;
	gtk_widget_set_halign ((GtkWidget*) _tmp17_, GTK_ALIGN_START);
	_tmp18_ = label;
	gtk_grid_attach (grid, (GtkWidget*) _tmp18_, 0, 2, 1, 1);
	_tmp19_ = (GtkEntry*) gtk_entry_new ();
	g_object_ref_sink (_tmp19_);
	_g_object_unref0 (self->priv->desc_entry);
	self->priv->desc_entry = _tmp19_;
	_tmp20_ = self->priv->desc_entry;
	gtk_entry_set_placeholder_text (_tmp20_, _ ("Optional"));
	_tmp21_ = self->priv->desc_entry;
	gtk_grid_attach (grid, (GtkWidget*) _tmp21_, 1, 2, 1, 1);
	_tmp22_ = (GtkLabel*) gtk_label_new (_ ("Command"));
	g_object_ref_sink (_tmp22_);
	_g_object_unref0 (label);
	label = _tmp22_;
	_tmp23_ = label;
	gtk_widget_set_halign ((GtkWidget*) _tmp23_, GTK_ALIGN_START);
	_tmp24_ = label;
	gtk_grid_attach (grid, (GtkWidget*) _tmp24_, 0, 3, 1, 1);
	_tmp25_ = (GtkEntry*) gtk_entry_new ();
	g_object_ref_sink (_tmp25_);
	_g_object_unref0 (self->priv->command_entry);
	self->priv->command_entry = _tmp25_;
	_tmp26_ = self->priv->command_entry;
	gtk_entry_set_placeholder_text (_tmp26_, _ ("Required"));
	_tmp27_ = self->priv->command_entry;
	gtk_grid_attach (grid, (GtkWidget*) _tmp27_, 1, 3, 1, 1);
	_tmp28_ = self->priv->title_entry;
	g_signal_connect_object ((GtkEditable*) _tmp28_, "changed", (GCallback) _budgie_command_dialog_check_inputs_gtk_editable_changed, self, 0);
	_tmp29_ = self->priv->command_entry;
	g_signal_connect_object ((GtkEditable*) _tmp29_, "changed", (GCallback) _budgie_command_dialog_check_inputs_gtk_editable_changed, self, 0);
	gtk_box_pack_start (content_area, (GtkWidget*) grid, TRUE, TRUE, (guint) 0);
	gtk_widget_show_all ((GtkWidget*) content_area);
	_tmp30_ = self->priv->exists_label;
	gtk_widget_hide ((GtkWidget*) _tmp30_);
	gtk_window_set_default_size ((GtkWindow*) self, 300, 200);
	_g_object_unref0 (label);
	_g_object_unref0 (grid);
	_g_object_unref0 (content_area);
	return self;
}

BudgieCommandDialog*
budgie_command_dialog_new (GtkWindow* parent)
{
	return budgie_command_dialog_construct (BUDGIE_TYPE_COMMAND_DIALOG, parent);
}

static void
budgie_command_dialog_check_inputs (BudgieCommandDialog* self)
{
	gchar* title_text = NULL;
	GtkEntry* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* command_text = NULL;
	GtkEntry* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean exists = FALSE;
	GHashTable* _tmp6_;
	GList* _tmp7_;
	GtkLabel* _tmp16_;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp18_ = FALSE;
	const gchar* _tmp19_;
	GtkWidget* _tmp21_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->title_entry;
	_tmp1_ = gtk_entry_get_text (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	title_text = _tmp2_;
	_tmp3_ = self->priv->command_entry;
	_tmp4_ = gtk_entry_get_text (_tmp3_);
	_tmp5_ = g_strdup (_tmp4_);
	command_text = _tmp5_;
	exists = FALSE;
	_tmp6_ = budgie_autostart_page_autostart_files;
	_tmp7_ = g_hash_table_get_values (_tmp6_);
	{
		GList* title_collection = NULL;
		GList* title_it = NULL;
		title_collection = _tmp7_;
		for (title_it = title_collection; title_it != NULL; title_it = title_it->next) {
			gchar* _tmp8_;
			gchar* title = NULL;
			_tmp8_ = g_strdup ((const gchar*) title_it->data);
			title = _tmp8_;
			{
				const gchar* _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
				const gchar* _tmp12_;
				gchar* _tmp13_;
				gchar* _tmp14_;
				gboolean _tmp15_;
				_tmp9_ = title;
				_tmp10_ = g_utf8_strdown (_tmp9_, (gssize) -1);
				_tmp11_ = _tmp10_;
				_tmp12_ = title_text;
				_tmp13_ = g_utf8_strdown (_tmp12_, (gssize) -1);
				_tmp14_ = _tmp13_;
				_tmp15_ = g_strcmp0 (_tmp11_, _tmp14_) == 0;
				_g_free0 (_tmp14_);
				_g_free0 (_tmp11_);
				if (_tmp15_) {
					exists = TRUE;
					_g_free0 (title);
					break;
				}
				_g_free0 (title);
			}
		}
		(title_collection == NULL) ? NULL : (title_collection = (g_list_free (title_collection), NULL));
	}
	_tmp16_ = self->priv->exists_label;
	gtk_widget_set_visible ((GtkWidget*) _tmp16_, exists);
	_tmp19_ = title_text;
	if (g_strcmp0 (_tmp19_, "") != 0) {
		const gchar* _tmp20_;
		_tmp20_ = command_text;
		_tmp18_ = g_strcmp0 (_tmp20_, "") != 0;
	} else {
		_tmp18_ = FALSE;
	}
	if (_tmp18_) {
		_tmp17_ = !exists;
	} else {
		_tmp17_ = FALSE;
	}
	_tmp21_ = self->priv->button_ok;
	gtk_widget_set_sensitive (_tmp21_, _tmp17_);
	_g_free0 (command_text);
	_g_free0 (title_text);
}

BudgieCommandInfo*
budgie_command_dialog_run (BudgieCommandDialog* self)
{
	GtkResponseType resp = 0;
	BudgieCommandInfo* result;
	g_return_val_if_fail (self != NULL, NULL);
	resp = (GtkResponseType) gtk_dialog_run (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_dialog_get_type (), GtkDialog));
	switch (resp) {
		case GTK_RESPONSE_ACCEPT:
		{
			BudgieCommandInfo* info = NULL;
			BudgieCommandInfo* _tmp0_;
			BudgieCommandInfo* _tmp1_;
			GtkEntry* _tmp2_;
			const gchar* _tmp3_;
			gchar* _tmp4_;
			BudgieCommandInfo* _tmp5_;
			GtkEntry* _tmp6_;
			const gchar* _tmp7_;
			gchar* _tmp8_;
			BudgieCommandInfo* _tmp9_;
			GtkEntry* _tmp10_;
			const gchar* _tmp11_;
			gchar* _tmp12_;
			_tmp0_ = budgie_command_info_new ();
			info = _tmp0_;
			_tmp1_ = info;
			_tmp2_ = self->priv->title_entry;
			_tmp3_ = gtk_entry_get_text (_tmp2_);
			_tmp4_ = g_strdup (_tmp3_);
			_g_free0 (_tmp1_->title);
			_tmp1_->title = _tmp4_;
			_tmp5_ = info;
			_tmp6_ = self->priv->desc_entry;
			_tmp7_ = gtk_entry_get_text (_tmp6_);
			_tmp8_ = g_strdup (_tmp7_);
			_g_free0 (_tmp5_->description);
			_tmp5_->description = _tmp8_;
			_tmp9_ = info;
			_tmp10_ = self->priv->command_entry;
			_tmp11_ = gtk_entry_get_text (_tmp10_);
			_tmp12_ = g_strdup (_tmp11_);
			_g_free0 (_tmp9_->command);
			_tmp9_->command = _tmp12_;
			result = info;
			return result;
		}
		default:
		case GTK_RESPONSE_CANCEL:
		{
			result = NULL;
			return result;
		}
	}
}

static void
budgie_command_dialog_class_init (BudgieCommandDialogClass * klass,
                                  gpointer klass_data)
{
	budgie_command_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BudgieCommandDialog_private_offset);
	G_OBJECT_CLASS (klass)->finalize = budgie_command_dialog_finalize;
}

static void
budgie_command_dialog_instance_init (BudgieCommandDialog * self,
                                     gpointer klass)
{
	self->priv = budgie_command_dialog_get_instance_private (self);
}

static void
budgie_command_dialog_finalize (GObject * obj)
{
	BudgieCommandDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_COMMAND_DIALOG, BudgieCommandDialog);
	_g_object_unref0 (self->priv->button_ok);
	_g_object_unref0 (self->priv->exists_label);
	_g_object_unref0 (self->priv->title_entry);
	_g_object_unref0 (self->priv->desc_entry);
	_g_object_unref0 (self->priv->command_entry);
	G_OBJECT_CLASS (budgie_command_dialog_parent_class)->finalize (obj);
}

static GType
budgie_command_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieCommandDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_command_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieCommandDialog), 0, (GInstanceInitFunc) budgie_command_dialog_instance_init, NULL };
	GType budgie_command_dialog_type_id;
	budgie_command_dialog_type_id = g_type_register_static (gtk_dialog_get_type (), "BudgieCommandDialog", &g_define_type_info, 0);
	BudgieCommandDialog_private_offset = g_type_add_instance_private (budgie_command_dialog_type_id, sizeof (BudgieCommandDialogPrivate));
	return budgie_command_dialog_type_id;
}

GType
budgie_command_dialog_get_type (void)
{
	static volatile gsize budgie_command_dialog_type_id__once = 0;
	if (g_once_init_enter (&budgie_command_dialog_type_id__once)) {
		GType budgie_command_dialog_type_id;
		budgie_command_dialog_type_id = budgie_command_dialog_get_type_once ();
		g_once_init_leave (&budgie_command_dialog_type_id__once, budgie_command_dialog_type_id);
	}
	return budgie_command_dialog_type_id__once;
}

static inline gpointer
budgie_autostart_page_get_instance_private (BudgieAutostartPage* self)
{
	return G_STRUCT_MEMBER_P (self, BudgieAutostartPage_private_offset);
}

static void
__lambda17_ (BudgieAutostartPage* self,
             GObject* obj,
             GAsyncResult* res)
{
	gchar** files = NULL;
	gint _tmp0_ = 0;
	gchar** _tmp1_;
	gint files_length1;
	gint _files_size_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	g_return_if_fail (res != NULL);
	_tmp1_ = budgie_autostart_page_list_directory_finish (self, res, &_tmp0_);
	files = _tmp1_;
	files_length1 = _tmp0_;
	_files_size_ = files_length1;
	_tmp2_ = files;
	_tmp2__length1 = files_length1;
	{
		gchar** file_collection = NULL;
		gint file_collection_length1 = 0;
		gint _file_collection_size_ = 0;
		gint file_it = 0;
		file_collection = _tmp2_;
		file_collection_length1 = _tmp2__length1;
		for (file_it = 0; file_it < file_collection_length1; file_it = file_it + 1) {
			gchar* _tmp3_;
			gchar* file = NULL;
			_tmp3_ = g_strdup (file_collection[file_it]);
			file = _tmp3_;
			{
				GDesktopAppInfo* info = NULL;
				const gchar* _tmp4_;
				GDesktopAppInfo* _tmp5_;
				GDesktopAppInfo* _tmp6_;
				_tmp4_ = file;
				_tmp5_ = g_desktop_app_info_new_from_filename (_tmp4_);
				info = _tmp5_;
				_tmp6_ = info;
				if (_tmp6_ != NULL) {
					BudgieAutostartItem* item = NULL;
					GDesktopAppInfo* _tmp7_;
					BudgieAutostartItem* _tmp8_;
					BudgieAutostartItem* _tmp9_;
					GHashTable* _tmp10_;
					BudgieAutostartItem* _tmp11_;
					const gchar* _tmp12_;
					gchar* _tmp13_;
					BudgieAutostartItem* _tmp14_;
					const gchar* _tmp15_;
					gchar* _tmp16_;
					_tmp7_ = info;
					_tmp8_ = budgie_autostart_item_new_from_app_info (_tmp7_);
					item = _tmp8_;
					_tmp9_ = item;
					budgie_autostart_page_add_item (self, _tmp9_);
					_tmp10_ = budgie_autostart_page_autostart_files;
					_tmp11_ = item;
					_tmp12_ = _tmp11_->id;
					_tmp13_ = g_strdup (_tmp12_);
					_tmp14_ = item;
					_tmp15_ = _tmp14_->title;
					_tmp16_ = g_strdup (_tmp15_);
					g_hash_table_insert (_tmp10_, _tmp13_, _tmp16_);
					_g_object_unref0 (item);
				}
				_g_object_unref0 (info);
				_g_free0 (file);
			}
		}
	}
	files = (_vala_array_free (files, files_length1, (GDestroyNotify) g_free), NULL);
}

static void
___lambda17__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda17_ ((BudgieAutostartPage*) self, source_object, res);
	g_object_unref (self);
}

BudgieAutostartPage*
budgie_autostart_page_construct (GType object_type)
{
	BudgieAutostartPage * self = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GHashFunc _tmp2_;
	GEqualFunc _tmp3_;
	GHashTable* _tmp4_;
	GtkFrame* frame = NULL;
	GtkFrame* _tmp5_;
	GtkFrame* _tmp6_;
	GtkBox* frame_box = NULL;
	GtkBox* _tmp7_;
	GtkFrame* _tmp8_;
	GtkBox* _tmp9_;
	GtkOverlay* overlay = NULL;
	GtkOverlay* _tmp10_;
	GtkBox* _tmp11_;
	GtkOverlay* _tmp12_;
	GtkLabel* add_label = NULL;
	GtkLabel* _tmp13_;
	GtkOverlay* _tmp14_;
	GtkLabel* _tmp15_;
	GtkLabel* _tmp16_;
	GtkLabel* _tmp17_;
	GtkStyleContext* _tmp18_;
	GtkMenuButton* add_button = NULL;
	GtkMenuButton* _tmp19_;
	GtkMenuButton* _tmp20_;
	GtkImage* _tmp21_;
	GtkImage* _tmp22_;
	GtkMenuButton* _tmp23_;
	GtkMenu* _tmp24_;
	GtkMenu* _tmp25_;
	GtkOverlay* _tmp26_;
	GtkMenuButton* _tmp27_;
	GtkMenuButton* _tmp28_;
	GtkMenuButton* _tmp29_;
	GtkStyleContext* _tmp30_;
	GtkMenuButton* _tmp31_;
	GtkWidget* _tmp32_;
	GtkStyleContext* _tmp33_;
	GtkMenuButton* _tmp34_;
	GtkMenuButton* _tmp35_;
	GtkSeparator* separator = NULL;
	GtkSeparator* _tmp36_;
	GtkBox* _tmp37_;
	GtkSeparator* _tmp38_;
	GtkListBox* _tmp39_;
	GtkBox* _tmp40_;
	GtkListBox* _tmp41_;
	GtkListBox* _tmp42_;
	const gchar* _tmp43_;
	const gchar* _tmp44_;
	self = (BudgieAutostartPage*) g_object_new (object_type, "group", BUDGIE_SETTINGS_GROUP_SESSION, "content-id", "autostart", "title", _ ("Autostart"), "display-weight", 0, "icon-name", "preferences-other", "halign", GTK_ALIGN_FILL, NULL);
	_tmp0_ = g_get_user_config_dir ();
	_tmp1_ = g_build_path ("/", _tmp0_, "autostart", NULL);
	_g_free0 (budgie_autostart_page_AUTOSTART_PATH);
	budgie_autostart_page_AUTOSTART_PATH = _tmp1_;
	_tmp2_ = g_str_hash;
	_tmp3_ = g_str_equal;
	_tmp4_ = g_hash_table_new_full (_tmp2_, _tmp3_, _g_free0_, _g_free0_);
	_g_hash_table_unref0 (budgie_autostart_page_autostart_files);
	budgie_autostart_page_autostart_files = _tmp4_;
	_tmp5_ = (GtkFrame*) gtk_frame_new (NULL);
	g_object_ref_sink (_tmp5_);
	frame = _tmp5_;
	_tmp6_ = frame;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp6_, TRUE, TRUE, (guint) 0);
	_tmp7_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp7_);
	frame_box = _tmp7_;
	_tmp8_ = frame;
	_tmp9_ = frame_box;
	gtk_container_add ((GtkContainer*) _tmp8_, (GtkWidget*) _tmp9_);
	_tmp10_ = (GtkOverlay*) gtk_overlay_new ();
	g_object_ref_sink (_tmp10_);
	overlay = _tmp10_;
	_tmp11_ = frame_box;
	_tmp12_ = overlay;
	gtk_box_pack_start (_tmp11_, (GtkWidget*) _tmp12_, FALSE, FALSE, (guint) 0);
	_tmp13_ = (GtkLabel*) gtk_label_new (_ ("Autostart apps"));
	g_object_ref_sink (_tmp13_);
	add_label = _tmp13_;
	_tmp14_ = overlay;
	_tmp15_ = add_label;
	gtk_container_add ((GtkContainer*) _tmp14_, (GtkWidget*) _tmp15_);
	_tmp16_ = add_label;
	g_object_set ((GtkWidget*) _tmp16_, "margin", 15, NULL);
	_tmp17_ = add_label;
	_tmp18_ = gtk_widget_get_style_context ((GtkWidget*) _tmp17_);
	gtk_style_context_add_class (_tmp18_, "dim-label");
	_tmp19_ = (GtkMenuButton*) gtk_menu_button_new ();
	g_object_ref_sink (_tmp19_);
	add_button = _tmp19_;
	_tmp20_ = add_button;
	_tmp21_ = (GtkImage*) gtk_image_new_from_icon_name ("list-add-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp21_);
	_tmp22_ = _tmp21_;
	gtk_button_set_image ((GtkButton*) _tmp20_, (GtkWidget*) _tmp22_);
	_g_object_unref0 (_tmp22_);
	_tmp23_ = add_button;
	_tmp24_ = budgie_autostart_page_create_menu (self);
	_tmp25_ = _tmp24_;
	gtk_menu_button_set_popup (_tmp23_, _tmp25_);
	_g_object_unref0 (_tmp25_);
	_tmp26_ = overlay;
	_tmp27_ = add_button;
	gtk_overlay_add_overlay (_tmp26_, (GtkWidget*) _tmp27_);
	_tmp28_ = add_button;
	gtk_widget_set_margin_end ((GtkWidget*) _tmp28_, 10);
	_tmp29_ = add_button;
	_tmp30_ = gtk_widget_get_style_context ((GtkWidget*) _tmp29_);
	gtk_style_context_add_class (_tmp30_, GTK_STYLE_CLASS_SUGGESTED_ACTION);
	_tmp31_ = add_button;
	_tmp32_ = gtk_bin_get_child ((GtkBin*) _tmp31_);
	_tmp33_ = gtk_widget_get_style_context (_tmp32_);
	gtk_style_context_add_class (_tmp33_, "round-button");
	_tmp34_ = add_button;
	gtk_widget_set_halign ((GtkWidget*) _tmp34_, GTK_ALIGN_END);
	_tmp35_ = add_button;
	gtk_widget_set_valign ((GtkWidget*) _tmp35_, GTK_ALIGN_CENTER);
	_tmp36_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
	g_object_ref_sink (_tmp36_);
	separator = _tmp36_;
	_tmp37_ = frame_box;
	_tmp38_ = separator;
	gtk_box_pack_start (_tmp37_, (GtkWidget*) _tmp38_, FALSE, FALSE, (guint) 0);
	_tmp39_ = (GtkListBox*) gtk_list_box_new ();
	g_object_ref_sink (_tmp39_);
	_g_object_unref0 (self->priv->listbox_autostart);
	self->priv->listbox_autostart = _tmp39_;
	_tmp40_ = frame_box;
	_tmp41_ = self->priv->listbox_autostart;
	gtk_box_pack_start (_tmp40_, (GtkWidget*) _tmp41_, TRUE, TRUE, (guint) 0);
	_tmp42_ = self->priv->listbox_autostart;
	gtk_list_box_set_selection_mode (_tmp42_, GTK_SELECTION_NONE);
	_tmp43_ = budgie_autostart_page_AUTOSTART_PATH;
	if (!g_file_test (_tmp43_, G_FILE_TEST_EXISTS | G_FILE_TEST_IS_DIR)) {
		_g_object_unref0 (separator);
		_g_object_unref0 (add_button);
		_g_object_unref0 (add_label);
		_g_object_unref0 (overlay);
		_g_object_unref0 (frame_box);
		_g_object_unref0 (frame);
		return self;
	}
	_tmp44_ = budgie_autostart_page_AUTOSTART_PATH;
	budgie_autostart_page_list_directory (self, _tmp44_, ___lambda17__gasync_ready_callback, g_object_ref (self));
	_g_object_unref0 (separator);
	_g_object_unref0 (add_button);
	_g_object_unref0 (add_label);
	_g_object_unref0 (overlay);
	_g_object_unref0 (frame_box);
	_g_object_unref0 (frame);
	return self;
}

BudgieAutostartPage*
budgie_autostart_page_new (void)
{
	return budgie_autostart_page_construct (BUDGIE_TYPE_AUTOSTART_PAGE);
}

static void
_budgie_autostart_page_on_add_app_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                          gpointer self)
{
	budgie_autostart_page_on_add_app ((BudgieAutostartPage*) self);
}

static void
_budgie_autostart_page_on_add_command_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                              gpointer self)
{
	budgie_autostart_page_on_add_command ((BudgieAutostartPage*) self);
}

static GtkMenu*
budgie_autostart_page_create_menu (BudgieAutostartPage* self)
{
	GtkMenu* menu = NULL;
	GtkMenu* _tmp0_;
	GtkMenuItem* item_new_app = NULL;
	GtkMenuItem* _tmp1_;
	GtkMenuItem* item_new_command = NULL;
	GtkMenuItem* _tmp2_;
	GtkMenu* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp0_);
	menu = _tmp0_;
	_tmp1_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_ ("Add Application"));
	g_object_ref_sink (_tmp1_);
	item_new_app = _tmp1_;
	gtk_container_add ((GtkContainer*) menu, (GtkWidget*) item_new_app);
	_tmp2_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_ ("Add Command"));
	g_object_ref_sink (_tmp2_);
	item_new_command = _tmp2_;
	gtk_container_add ((GtkContainer*) menu, (GtkWidget*) item_new_command);
	g_signal_connect_object (item_new_app, "activate", (GCallback) _budgie_autostart_page_on_add_app_gtk_menu_item_activate, self, 0);
	g_signal_connect_object (item_new_command, "activate", (GCallback) _budgie_autostart_page_on_add_command_gtk_menu_item_activate, self, 0);
	gtk_widget_show_all ((GtkWidget*) menu);
	result = menu;
	_g_object_unref0 (item_new_command);
	_g_object_unref0 (item_new_app);
	return result;
}

static void
budgie_autostart_page_add_item (BudgieAutostartPage* self,
                                BudgieAutostartItem* item)
{
	GtkListBox* _tmp0_;
	BudgieAutostartItemWidget* _tmp1_;
	BudgieAutostartItemWidget* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = self->priv->listbox_autostart;
	_tmp1_ = budgie_autostart_item_widget_new (item, TRUE, FALSE);
	g_object_ref_sink (_tmp1_);
	_tmp2_ = _tmp1_;
	gtk_container_add ((GtkContainer*) _tmp0_, (GtkWidget*) _tmp2_);
	_g_object_unref0 (_tmp2_);
}

static void
budgie_autostart_page_list_directory_data_free (gpointer _data)
{
	BudgieAutostartPageListDirectoryData* _data_;
	_data_ = _data;
	_g_free0 (_data_->directory);
	_data_->result = (_vala_array_free (_data_->result, _data_->result_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (_data_->self);
	g_slice_free (BudgieAutostartPageListDirectoryData, _data_);
}

static void
budgie_autostart_page_list_directory (BudgieAutostartPage* self,
                                      const gchar* directory,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	BudgieAutostartPageListDirectoryData* _data_;
	BudgieAutostartPage* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (directory != NULL);
	_data_ = g_slice_new0 (BudgieAutostartPageListDirectoryData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, budgie_autostart_page_list_directory_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (directory);
	_g_free0 (_data_->directory);
	_data_->directory = _tmp1_;
	budgie_autostart_page_list_directory_co (_data_);
}

static gchar**
budgie_autostart_page_list_directory_finish (BudgieAutostartPage* self,
                                             GAsyncResult* _res_,
                                             gint* result_length1)
{
	gchar** result;
	BudgieAutostartPageListDirectoryData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	*result_length1 = _data_->result_length1;
	_data_->result = NULL;
	return result;
}

static void
budgie_autostart_page_list_directory_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_)
{
	BudgieAutostartPageListDirectoryData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	budgie_autostart_page_list_directory_co (_data_);
}

static void
_vala_array_add4 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gboolean
budgie_autostart_page_list_directory_co (BudgieAutostartPageListDirectoryData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_new0 (gchar*, 0 + 1);
	_data_->filelist = _data_->_tmp0_;
	_data_->filelist_length1 = 0;
	_data_->_filelist_size_ = _data_->filelist_length1;
	_data_->_tmp1_ = g_file_new_for_path (_data_->directory);
	_data_->dir = _data_->_tmp1_;
	{
		_data_->_tmp2_ = _data_->dir;
		_data_->_state_ = 1;
		g_file_enumerate_children_async (_data_->_tmp2_, G_FILE_ATTRIBUTE_STANDARD_NAME, 0, G_PRIORITY_DEFAULT, NULL, budgie_autostart_page_list_directory_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp3_ = g_file_enumerate_children_finish (_data_->_tmp2_, _data_->_res_, &_data_->_inner_error0_);
		_data_->e = _data_->_tmp3_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		while (TRUE) {
			_data_->_tmp4_ = _data_->e;
			_data_->_state_ = 2;
			g_file_enumerator_next_files_async (_data_->_tmp4_, 10, G_PRIORITY_DEFAULT, NULL, budgie_autostart_page_list_directory_ready, _data_);
			return FALSE;
			_state_2:
			_data_->_tmp5_ = g_file_enumerator_next_files_finish (_data_->_tmp4_, _data_->_res_, &_data_->_inner_error0_);
			_data_->files = _data_->_tmp5_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				_g_object_unref0 (_data_->e);
				goto __catch0_g_error;
			}
			_data_->_tmp6_ = _data_->files;
			if (_data_->_tmp6_ == NULL) {
				(_data_->files == NULL) ? NULL : (_data_->files = (_g_list_free__g_object_unref0_ (_data_->files), NULL));
				break;
			}
			_data_->_tmp7_ = _data_->files;
			{
				_data_->info_collection = _data_->_tmp7_;
				for (_data_->info_it = _data_->info_collection; _data_->info_it != NULL; _data_->info_it = _data_->info_it->next) {
					_data_->_tmp8_ = _g_object_ref0 ((GFileInfo*) _data_->info_it->data);
					_data_->info = _data_->_tmp8_;
					{
						_data_->_tmp9_ = _data_->info;
						_data_->_tmp10_ = g_file_info_get_name (_data_->_tmp9_);
						if (g_str_has_suffix (_data_->_tmp10_, ".desktop")) {
							_data_->_tmp11_ = _data_->info;
							_data_->_tmp12_ = g_file_info_get_name (_data_->_tmp11_);
							_data_->_tmp13_ = g_build_path ("/", _data_->directory, _data_->_tmp12_, NULL);
							_data_->path = _data_->_tmp13_;
							_data_->_tmp14_ = _data_->path;
							_data_->_tmp15_ = g_strdup (_data_->_tmp14_);
							_vala_array_add4 (&_data_->filelist, &_data_->filelist_length1, &_data_->_filelist_size_, _data_->_tmp15_);
							_g_free0 (_data_->path);
						}
						_g_object_unref0 (_data_->info);
					}
				}
			}
			(_data_->files == NULL) ? NULL : (_data_->files = (_g_list_free__g_object_unref0_ (_data_->files), NULL));
		}
		_g_object_unref0 (_data_->e);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->_vala1_e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp16_ = _data_->_vala1_e;
		_data_->_tmp17_ = _data_->_tmp16_->message;
		g_warning ("settings_autostart.vala:542: Error: list_directory failed: %s\n", _data_->_tmp17_);
		_g_error_free0 (_data_->_vala1_e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->dir);
		_data_->filelist = (_vala_array_free (_data_->filelist, _data_->filelist_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp18_ = _data_->filelist;
	_data_->_tmp18__length1 = _data_->filelist_length1;
	_data_->result_length1 = _data_->_tmp18__length1;
	_data_->result = _data_->_tmp18_;
	_g_object_unref0 (_data_->dir);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
budgie_autostart_page_on_add_app (BudgieAutostartPage* self)
{
	BudgieAppChooser* dlg = NULL;
	GtkWidget* _tmp0_;
	BudgieAppChooser* _tmp1_;
	BudgieAutostartItem* item = NULL;
	BudgieAppChooser* _tmp2_;
	BudgieAutostartItem* _tmp3_;
	BudgieAppChooser* _tmp4_;
	BudgieAutostartItem* _tmp5_;
	GHashTable* _tmp6_;
	BudgieAutostartItem* _tmp7_;
	const gchar* _tmp8_;
	gchar* autostart_path = NULL;
	BudgieAutostartItem* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	GHashTable* _tmp12_;
	BudgieAutostartItem* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	BudgieAutostartItem* _tmp16_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	BudgieAutostartItem* _tmp19_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	_tmp1_ = budgie_app_chooser_new (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gtk_window_get_type ()) ? ((GtkWindow*) _tmp0_) : NULL);
	g_object_ref_sink (_tmp1_);
	dlg = _tmp1_;
	_tmp2_ = dlg;
	_tmp3_ = budgie_app_chooser_run (_tmp2_);
	item = _tmp3_;
	_tmp4_ = dlg;
	gtk_widget_destroy ((GtkWidget*) _tmp4_);
	_tmp5_ = item;
	if (_tmp5_ == NULL) {
		_g_object_unref0 (item);
		_g_object_unref0 (dlg);
		return;
	}
	_tmp6_ = budgie_autostart_page_autostart_files;
	_tmp7_ = item;
	_tmp8_ = _tmp7_->id;
	if (g_hash_table_contains (_tmp6_, _tmp8_)) {
		_g_object_unref0 (item);
		_g_object_unref0 (dlg);
		return;
	}
	_tmp9_ = item;
	_tmp10_ = budgie_autostart_item_make_autostart (_tmp9_);
	autostart_path = _tmp10_;
	_tmp11_ = autostart_path;
	if (_tmp11_ == NULL) {
		_g_free0 (autostart_path);
		_g_object_unref0 (item);
		_g_object_unref0 (dlg);
		return;
	}
	_tmp12_ = budgie_autostart_page_autostart_files;
	_tmp13_ = item;
	_tmp14_ = _tmp13_->id;
	_tmp15_ = g_strdup (_tmp14_);
	_tmp16_ = item;
	_tmp17_ = _tmp16_->title;
	_tmp18_ = g_strdup (_tmp17_);
	g_hash_table_insert (_tmp12_, _tmp15_, _tmp18_);
	_tmp19_ = item;
	budgie_autostart_page_add_item (self, _tmp19_);
	_g_free0 (autostart_path);
	_g_object_unref0 (item);
	_g_object_unref0 (dlg);
}

static void
budgie_autostart_page_on_add_command (BudgieAutostartPage* self)
{
	BudgieCommandDialog* dlg = NULL;
	GtkWidget* _tmp0_;
	BudgieCommandDialog* _tmp1_;
	BudgieCommandInfo* command_info = NULL;
	BudgieCommandDialog* _tmp2_;
	BudgieCommandInfo* _tmp3_;
	BudgieCommandDialog* _tmp4_;
	BudgieCommandInfo* _tmp5_;
	BudgieAutostartItem* item = NULL;
	BudgieCommandInfo* _tmp6_;
	BudgieAutostartItem* _tmp7_;
	gchar* autostart_path = NULL;
	BudgieAutostartItem* _tmp8_;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	GHashTable* _tmp11_;
	BudgieAutostartItem* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	BudgieAutostartItem* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	BudgieAutostartItem* _tmp18_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	_tmp1_ = budgie_command_dialog_new (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gtk_window_get_type ()) ? ((GtkWindow*) _tmp0_) : NULL);
	g_object_ref_sink (_tmp1_);
	dlg = _tmp1_;
	_tmp2_ = dlg;
	_tmp3_ = budgie_command_dialog_run (_tmp2_);
	command_info = _tmp3_;
	_tmp4_ = dlg;
	gtk_widget_destroy ((GtkWidget*) _tmp4_);
	_tmp5_ = command_info;
	if (_tmp5_ == NULL) {
		_budgie_command_info_free0 (command_info);
		_g_object_unref0 (dlg);
		return;
	}
	_tmp6_ = command_info;
	_tmp7_ = budgie_autostart_item_new_from_command_info (_tmp6_);
	item = _tmp7_;
	_tmp8_ = item;
	_tmp9_ = budgie_autostart_item_make_autostart (_tmp8_);
	autostart_path = _tmp9_;
	_tmp10_ = autostart_path;
	if (_tmp10_ == NULL) {
		_g_free0 (autostart_path);
		_g_object_unref0 (item);
		_budgie_command_info_free0 (command_info);
		_g_object_unref0 (dlg);
		return;
	}
	_tmp11_ = budgie_autostart_page_autostart_files;
	_tmp12_ = item;
	_tmp13_ = _tmp12_->id;
	_tmp14_ = g_strdup (_tmp13_);
	_tmp15_ = item;
	_tmp16_ = _tmp15_->title;
	_tmp17_ = g_strdup (_tmp16_);
	g_hash_table_insert (_tmp11_, _tmp14_, _tmp17_);
	_tmp18_ = item;
	budgie_autostart_page_add_item (self, _tmp18_);
	_g_free0 (autostart_path);
	_g_object_unref0 (item);
	_budgie_command_info_free0 (command_info);
	_g_object_unref0 (dlg);
}

static void
budgie_autostart_page_class_init (BudgieAutostartPageClass * klass,
                                  gpointer klass_data)
{
	budgie_autostart_page_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BudgieAutostartPage_private_offset);
	G_OBJECT_CLASS (klass)->finalize = budgie_autostart_page_finalize;
}

static void
budgie_autostart_page_instance_init (BudgieAutostartPage * self,
                                     gpointer klass)
{
	self->priv = budgie_autostart_page_get_instance_private (self);
}

static void
budgie_autostart_page_finalize (GObject * obj)
{
	BudgieAutostartPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_AUTOSTART_PAGE, BudgieAutostartPage);
	_g_object_unref0 (self->priv->listbox_autostart);
	G_OBJECT_CLASS (budgie_autostart_page_parent_class)->finalize (obj);
}

/**
* AutostartPage allows users to control autostart apps
*/
static GType
budgie_autostart_page_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieAutostartPageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_autostart_page_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieAutostartPage), 0, (GInstanceInitFunc) budgie_autostart_page_instance_init, NULL };
	GType budgie_autostart_page_type_id;
	budgie_autostart_page_type_id = g_type_register_static (BUDGIE_TYPE_SETTINGS_PAGE, "BudgieAutostartPage", &g_define_type_info, 0);
	BudgieAutostartPage_private_offset = g_type_add_instance_private (budgie_autostart_page_type_id, sizeof (BudgieAutostartPagePrivate));
	return budgie_autostart_page_type_id;
}

GType
budgie_autostart_page_get_type (void)
{
	static volatile gsize budgie_autostart_page_type_id__once = 0;
	if (g_once_init_enter (&budgie_autostart_page_type_id__once)) {
		GType budgie_autostart_page_type_id;
		budgie_autostart_page_type_id = budgie_autostart_page_get_type_once ();
		g_once_init_leave (&budgie_autostart_page_type_id__once, budgie_autostart_page_type_id);
	}
	return budgie_autostart_page_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

