/* BudgieMenuWindow.c generated by valac 0.56.2, the Vala compiler
 * generated from BudgieMenuWindow.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright © 2015-2022 Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "budgiemenuapplet.h"
#include <gmenu-tree.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <glib-object.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <stdio.h>
#include <gio/gdesktopappinfo.h>
#include <float.h>
#include <math.h>

#define APPS_ID "gnome-applications.menu"
#define LOGOUT_BINARY "budgie-session-dialog"

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
enum  {
	BUDGIE_MENU_WINDOW_0_PROPERTY,
	BUDGIE_MENU_WINDOW_SETTINGS_PROPERTY,
	BUDGIE_MENU_WINDOW_NUM_PROPERTIES
};
static GParamSpec* budgie_menu_window_properties[BUDGIE_MENU_WINDOW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_GMenuTreeDirectory_free0(var) ((var == NULL) ? NULL : (var = (_vala_GMenuTreeDirectory_free (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __vala_GMenuTreeIter_free0(var) ((var == NULL) ? NULL : (var = (_vala_GMenuTreeIter_free (var), NULL)))
typedef struct _Block1Data Block1Data;
#define __vala_GMenuTreeEntry_free0(var) ((var == NULL) ? NULL : (var = (_vala_GMenuTreeEntry_free (var), NULL)))
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;
typedef struct _Block4Data Block4Data;

struct _BudgieMenuWindowPrivate {
	GMenuTree* tree;
	GMenuTreeDirectory* other_tree;
	gboolean attempted_other_search;
	GSettings* _settings;
	gboolean reloading;
	GRecMutex __lock_reloading;
};

struct _Block1Data {
	int _ref_count_;
	BudgieMenuWindow* self;
	CategoryButton* btn;
};

struct _Block2Data {
	int _ref_count_;
	BudgieMenuWindow* self;
	MenuButton* btn;
};

struct _Block3Data {
	int _ref_count_;
	BudgieMenuWindow* self;
	GList* category_names;
};

struct _Block4Data {
	int _ref_count_;
	BudgieMenuWindow* self;
	GDesktopAppInfo* info;
};

static gint BudgieMenuWindow_private_offset;
static gpointer budgie_menu_window_parent_class = NULL;
static GType budgie_menu_window_type_id = 0;

VALA_EXTERN gchar* searchable_string (const gchar* input);
static void _vala_GMenuTreeDirectory_free (GMenuTreeDirectory* self);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
static gboolean budgie_menu_window_on_mouse_enter (BudgieMenuWindow* self,
                                            GtkWidget* source_widget,
                                            GdkEventCrossing* e);
static gboolean _budgie_menu_window_on_mouse_enter_gtk_widget_enter_notify_event (GtkWidget* _sender,
                                                                           GdkEventCrossing* event,
                                                                           gpointer self);
static void __lambda4_ (BudgieMenuWindow* self);
static void ___lambda4__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                            gpointer self);
static void _budgie_menu_window_on_row_activate_gtk_list_box_row_activated (GtkListBox* _sender,
                                                                     GtkListBoxRow* row,
                                                                     gpointer self);
static void _budgie_menu_window_on_settings_changed_g_settings_changed (GSettings* _sender,
                                                                 const gchar* key,
                                                                 gpointer self);
static gboolean _budgie_menu_window_do_filter_list_gtk_list_box_filter_func (GtkListBoxRow* row,
                                                                      gpointer self);
static gint _budgie_menu_window_do_sort_list_gtk_list_box_sort_func (GtkListBoxRow* row1,
                                                              GtkListBoxRow* row2,
                                                              gpointer self);
static void __lambda7_ (BudgieMenuWindow* self);
static void ___lambda7__gtk_editable_changed (GtkEditable* _sender,
                                       gpointer self);
static void _budgie_menu_window_on_entry_activate_gtk_entry_activate (GtkEntry* _sender,
                                                               gpointer self);
static gboolean __lambda8_ (BudgieMenuWindow* self);
static void budgie_menu_window_load_menus (BudgieMenuWindow* self,
                                    GMenuTreeDirectory* tree_root);
static gboolean ___lambda8__gsource_func (gpointer self);
static gboolean __lambda10_ (BudgieMenuWindow* self);
static gboolean ___lambda10__gsource_func (gpointer self);
static gboolean ___lambda9_ (BudgieMenuWindow* self);
static void _budgie_menu_window_refresh_tree_gmenu_tree_changed (GMenuTree* _sender,
                                                          gpointer self);
static gboolean ____lambda9__gsource_func (gpointer self);
static GMenuTreeDirectory* _vala_GMenuTreeDirectory_copy (GMenuTreeDirectory* self);
static GMenuTreeItemType* _gmenu_tree_item_type_dup (GMenuTreeItemType* self);
static gboolean _gmenu_tree_item_type_equal (const GMenuTreeItemType * s1,
                                      const GMenuTreeItemType * s2);
static void _vala_GMenuTreeIter_free (GMenuTreeIter* self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void _____lambda11_ (Block1Data* _data1_);
static void ______lambda11__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                gpointer self);
static void _vala_GMenuTreeEntry_free (GMenuTreeEntry* self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void _______lambda12_ (Block2Data* _data2_);
static void ________lambda12__gtk_button_clicked (GtkButton* _sender,
                                           gpointer self);
static gboolean* _bool_dup (gboolean* self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static inline void _g_list_free__g_free0_ (GList* self);
static void block3_data_unref (void * _userdata_);
static void ___lambda13_ (Block3Data* _data3_,
                   const gchar* name,
                   gboolean* has);
static void ____lambda13__gh_func (gconstpointer key,
                            gconstpointer value,
                            gpointer self);
static gint ___lambda14_ (const gchar* cat_one,
                   const gchar* cat_two);
static gint ____lambda14__gcompare_func (gconstpointer a,
                                  gconstpointer b);
static void ___lambda15_ (BudgieMenuWindow* self,
                   const gchar* category_name);
static void ____lambda15__gfunc (gconstpointer data,
                          gpointer self);
static void _budgie_menu_window_do_list_header_gtk_list_box_update_header_func (GtkListBoxRow* row,
                                                                         GtkListBoxRow* before,
                                                                         gpointer self);
static gboolean budgie_menu_window_array_contains (BudgieMenuWindow* self,
                                            gchar** array,
                                            gint array_length1,
                                            const gchar* term);
static gboolean budgie_menu_window_info_matches_term (BudgieMenuWindow* self,
                                               GAppInfo* info,
                                               const gchar* term);
static gchar** _vala_array_dup1 (gchar** self,
                          gssize length);
static gboolean budgie_menu_window_is_item_dupe (BudgieMenuWindow* self,
                                          MenuButton* button);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static gboolean __lambda5_ (Block4Data* _data4_);
static void ____lambda6_ (BudgieMenuWindow* self,
                   GPid pid,
                   gint status);
static void _____lambda6__gchild_watch_func (GPid pid,
                                      gint status,
                                      gpointer self);
static gboolean ___lambda5__gsource_func (gpointer self);
static void budgie_menu_window_real_show (GtkWidget* base);
static gboolean __lambda16_ (BudgieMenuWindow* self);
static gboolean ___lambda16__gsource_func (gpointer self);
static void budgie_menu_window_finalize (GObject * obj);
static void _vala_budgie_menu_window_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);
static void _vala_budgie_menu_window_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

/**
 * Return a string suitable for working on.
 * This works around the issue of GNOME Control Center and others deciding to
 * use soft hyphens in their .desktop files.
 */
static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

gchar*
searchable_string (const gchar* input)
{
	gchar* mod = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* result;
	g_return_val_if_fail (input != NULL, NULL);
	_tmp0_ = g_strconcat ("", input, NULL);
	mod = _tmp0_;
	_tmp1_ = string_replace (mod, "\u00AD", "");
	_tmp2_ = _tmp1_;
	_tmp3_ = g_ascii_strdown (_tmp2_, (gssize) -1);
	_tmp4_ = _tmp3_;
	_tmp5_ = string_strip (_tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	result = _tmp6_;
	_g_free0 (mod);
	return result;
}

static inline gpointer
budgie_menu_window_get_instance_private (BudgieMenuWindow* self)
{
	return G_STRUCT_MEMBER_P (self, BudgieMenuWindow_private_offset);
}

static void
_vala_GMenuTreeDirectory_free (GMenuTreeDirectory* self)
{
	g_boxed_free (gmenu_tree_directory_get_type (), self);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static gboolean
_budgie_menu_window_on_mouse_enter_gtk_widget_enter_notify_event (GtkWidget* _sender,
                                                                  GdkEventCrossing* event,
                                                                  gpointer self)
{
	gboolean result;
	result = budgie_menu_window_on_mouse_enter ((BudgieMenuWindow*) self, _sender, event);
	return result;
}

static void
__lambda4_ (BudgieMenuWindow* self)
{
	CategoryButton* _tmp0_;
	_tmp0_ = self->all_categories;
	budgie_menu_window_update_category (self, _tmp0_);
}

static void
___lambda4__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                       gpointer self)
{
	__lambda4_ ((BudgieMenuWindow*) self);
}

static void
_budgie_menu_window_on_row_activate_gtk_list_box_row_activated (GtkListBox* _sender,
                                                                GtkListBoxRow* row,
                                                                gpointer self)
{
	budgie_menu_window_on_row_activate ((BudgieMenuWindow*) self, row);
}

static void
_budgie_menu_window_on_settings_changed_g_settings_changed (GSettings* _sender,
                                                            const gchar* key,
                                                            gpointer self)
{
	budgie_menu_window_on_settings_changed ((BudgieMenuWindow*) self, key);
}

static gboolean
_budgie_menu_window_do_filter_list_gtk_list_box_filter_func (GtkListBoxRow* row,
                                                             gpointer self)
{
	gboolean result;
	result = budgie_menu_window_do_filter_list ((BudgieMenuWindow*) self, row);
	return result;
}

static gint
_budgie_menu_window_do_sort_list_gtk_list_box_sort_func (GtkListBoxRow* row1,
                                                         GtkListBoxRow* row2,
                                                         gpointer self)
{
	gint result;
	result = budgie_menu_window_do_sort_list ((BudgieMenuWindow*) self, row1, row2);
	return result;
}

static void
__lambda7_ (BudgieMenuWindow* self)
{
	GtkSearchEntry* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	GtkListBox* _tmp4_;
	GtkListBox* _tmp5_;
	GtkListBox* _tmp6_;
	_tmp0_ = self->search_entry;
	_tmp1_ = gtk_entry_get_text ((GtkEntry*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = searchable_string (_tmp2_);
	_g_free0 (self->search_term);
	self->search_term = _tmp3_;
	_tmp4_ = self->content;
	gtk_list_box_invalidate_headers (_tmp4_);
	_tmp5_ = self->content;
	gtk_list_box_invalidate_filter (_tmp5_);
	_tmp6_ = self->content;
	gtk_list_box_invalidate_sort (_tmp6_);
}

static void
___lambda7__gtk_editable_changed (GtkEditable* _sender,
                                  gpointer self)
{
	__lambda7_ ((BudgieMenuWindow*) self);
}

static void
_budgie_menu_window_on_entry_activate_gtk_entry_activate (GtkEntry* _sender,
                                                          gpointer self)
{
	budgie_menu_window_on_entry_activate ((BudgieMenuWindow*) self);
}

static gboolean
__lambda8_ (BudgieMenuWindow* self)
{
	GtkListBox* _tmp0_;
	GtkListBox* _tmp1_;
	GtkListBox* _tmp2_;
	gboolean result;
	budgie_menu_window_load_menus (self, NULL);
	_tmp0_ = self->content;
	gtk_list_box_invalidate_headers (_tmp0_);
	_tmp1_ = self->content;
	gtk_list_box_invalidate_filter (_tmp1_);
	_tmp2_ = self->content;
	gtk_list_box_invalidate_sort (_tmp2_);
	gtk_widget_queue_resize ((GtkWidget*) self);
	if (!gtk_widget_get_realized ((GtkWidget*) self)) {
		gtk_widget_realize ((GtkWidget*) self);
	}
	result = FALSE;
	return result;
}

static gboolean
___lambda8__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda8_ ((BudgieMenuWindow*) self);
	return result;
}

BudgieMenuWindow*
budgie_menu_window_construct (GType object_type,
                              GSettings* settings,
                              GtkWidget* leparent)
{
	BudgieMenuWindow * self = NULL;
	GtkStyleContext* _tmp0_;
	GtkBox* _tmp1_;
	GtkBox* _tmp2_;
	GHashFunc _tmp3_;
	GEqualFunc _tmp4_;
	GHashTable* _tmp5_;
	GHashFunc _tmp6_;
	GEqualFunc _tmp7_;
	GHashTable* _tmp8_;
	GHashFunc _tmp9_;
	GEqualFunc _tmp10_;
	GHashTable* _tmp11_;
	GtkSearchEntry* _tmp12_;
	GtkBox* _tmp13_;
	GtkSearchEntry* _tmp14_;
	GtkBox* middle = NULL;
	GtkBox* _tmp15_;
	GtkBox* _tmp16_;
	GtkBox* _tmp17_;
	GtkBox* _tmp18_;
	GtkBox* _tmp19_;
	GtkScrolledWindow* _tmp20_;
	GtkScrolledWindow* _tmp21_;
	GtkScrolledWindow* _tmp22_;
	GtkScrolledWindow* _tmp23_;
	GtkStyleContext* _tmp24_;
	GtkScrolledWindow* _tmp25_;
	GtkStyleContext* _tmp26_;
	GtkScrolledWindow* _tmp27_;
	GtkBox* _tmp28_;
	GtkScrolledWindow* _tmp29_;
	GtkScrolledWindow* _tmp30_;
	CategoryButton* _tmp31_;
	CategoryButton* _tmp32_;
	CategoryButton* _tmp33_;
	GtkBox* _tmp34_;
	CategoryButton* _tmp35_;
	GtkBox* right_layout = NULL;
	GtkBox* _tmp36_;
	GtkListBox* _tmp37_;
	GtkListBox* _tmp38_;
	GtkListBox* _tmp39_;
	GtkScrolledWindow* _tmp40_;
	GtkScrolledWindow* _tmp41_;
	GtkScrolledWindow* _tmp42_;
	GtkScrolledWindow* _tmp43_;
	GtkListBox* _tmp44_;
	GtkScrolledWindow* _tmp45_;
	GtkLabel* placeholder = NULL;
	gchar* _tmp46_;
	gchar* _tmp47_;
	GtkLabel* _tmp48_;
	GtkLabel* _tmp49_;
	GtkStyleContext* _tmp50_;
	GtkListBox* _tmp51_;
	GtkListBox* _tmp52_;
	GtkListBox* _tmp53_;
	GtkListBox* _tmp54_;
	GtkSearchEntry* _tmp55_;
	GtkSearchEntry* _tmp56_;
	GtkSearchEntry* _tmp57_;
	GtkScrolledWindow* _tmp58_;
	GtkScrolledWindow* _tmp59_;
	self = (BudgieMenuWindow*) g_object_new (object_type, "settings", settings, "relative-to", leparent, NULL);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp0_, "budgie-menu");
	_tmp1_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->main_layout);
	self->main_layout = _tmp1_;
	_tmp2_ = self->main_layout;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp2_);
	_tmp3_ = g_str_hash;
	_tmp4_ = g_str_equal;
	_tmp5_ = g_hash_table_new_full (_tmp3_, _tmp4_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->category_buttons);
	self->category_buttons = _tmp5_;
	_tmp6_ = g_str_hash;
	_tmp7_ = g_str_equal;
	_tmp8_ = g_hash_table_new_full (_tmp6_, _tmp7_, _g_free0_, _g_free0_);
	_g_hash_table_unref0 (self->category_has_items);
	self->category_has_items = _tmp8_;
	_tmp9_ = g_str_hash;
	_tmp10_ = g_str_equal;
	_tmp11_ = g_hash_table_new_full (_tmp9_, _tmp10_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->menu_buttons);
	self->menu_buttons = _tmp11_;
	self->icon_size = g_settings_get_int (settings, "menu-icons-size");
	_tmp12_ = (GtkSearchEntry*) gtk_search_entry_new ();
	g_object_ref_sink (_tmp12_);
	_g_object_unref0 (self->search_entry);
	self->search_entry = _tmp12_;
	_tmp13_ = self->main_layout;
	_tmp14_ = self->search_entry;
	gtk_box_pack_start (_tmp13_, (GtkWidget*) _tmp14_, FALSE, FALSE, (guint) 0);
	_tmp15_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp15_);
	middle = _tmp15_;
	_tmp16_ = self->main_layout;
	gtk_box_pack_start (_tmp16_, (GtkWidget*) middle, TRUE, TRUE, (guint) 0);
	_tmp17_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp17_);
	_g_object_unref0 (self->categories);
	self->categories = _tmp17_;
	_tmp18_ = self->categories;
	gtk_widget_set_margin_top ((GtkWidget*) _tmp18_, 3);
	_tmp19_ = self->categories;
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp19_, 3);
	_tmp20_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp20_);
	_g_object_unref0 (self->categories_scroll);
	self->categories_scroll = _tmp20_;
	_tmp21_ = self->categories_scroll;
	gtk_scrolled_window_set_overlay_scrolling (_tmp21_, FALSE);
	_tmp22_ = self->categories_scroll;
	gtk_scrolled_window_set_shadow_type (_tmp22_, GTK_SHADOW_NONE);
	_tmp23_ = self->categories_scroll;
	_tmp24_ = gtk_widget_get_style_context ((GtkWidget*) _tmp23_);
	gtk_style_context_add_class (_tmp24_, "categories");
	_tmp25_ = self->categories_scroll;
	_tmp26_ = gtk_widget_get_style_context ((GtkWidget*) _tmp25_);
	gtk_style_context_add_class (_tmp26_, "sidebar");
	_tmp27_ = self->categories_scroll;
	_tmp28_ = self->categories;
	gtk_container_add ((GtkContainer*) _tmp27_, (GtkWidget*) _tmp28_);
	_tmp29_ = self->categories_scroll;
	gtk_scrolled_window_set_policy (_tmp29_, GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
	_tmp30_ = self->categories_scroll;
	gtk_box_pack_start (middle, (GtkWidget*) _tmp30_, FALSE, FALSE, (guint) 0);
	_tmp31_ = category_button_new (NULL);
	g_object_ref_sink (_tmp31_);
	_g_object_unref0 (self->all_categories);
	self->all_categories = _tmp31_;
	_tmp32_ = self->all_categories;
	g_signal_connect_object ((GtkWidget*) _tmp32_, "enter-notify-event", (GCallback) _budgie_menu_window_on_mouse_enter_gtk_widget_enter_notify_event, self, 0);
	_tmp33_ = self->all_categories;
	g_signal_connect_object ((GtkToggleButton*) _tmp33_, "toggled", (GCallback) ___lambda4__gtk_toggle_button_toggled, self, 0);
	_tmp34_ = self->categories;
	_tmp35_ = self->all_categories;
	gtk_box_pack_start (_tmp34_, (GtkWidget*) _tmp35_, FALSE, FALSE, (guint) 0);
	_tmp36_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp36_);
	right_layout = _tmp36_;
	gtk_box_pack_start (middle, (GtkWidget*) right_layout, TRUE, TRUE, (guint) 0);
	_tmp37_ = (GtkListBox*) gtk_list_box_new ();
	g_object_ref_sink (_tmp37_);
	_g_object_unref0 (self->content);
	self->content = _tmp37_;
	_tmp38_ = self->content;
	g_signal_connect_object (_tmp38_, "row-activated", (GCallback) _budgie_menu_window_on_row_activate_gtk_list_box_row_activated, self, 0);
	_tmp39_ = self->content;
	gtk_list_box_set_selection_mode (_tmp39_, GTK_SELECTION_NONE);
	_tmp40_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp40_);
	_g_object_unref0 (self->content_scroll);
	self->content_scroll = _tmp40_;
	_tmp41_ = self->content_scroll;
	gtk_scrolled_window_set_overlay_scrolling (_tmp41_, TRUE);
	_tmp42_ = self->content_scroll;
	gtk_scrolled_window_set_policy (_tmp42_, GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
	_tmp43_ = self->content_scroll;
	_tmp44_ = self->content;
	gtk_container_add ((GtkContainer*) _tmp43_, (GtkWidget*) _tmp44_);
	_tmp45_ = self->content_scroll;
	gtk_box_pack_start (right_layout, (GtkWidget*) _tmp45_, TRUE, TRUE, (guint) 0);
	_tmp46_ = g_strdup_printf ("<big>%s</big>", _ ("Sorry, no items found"));
	_tmp47_ = _tmp46_;
	_tmp48_ = (GtkLabel*) gtk_label_new (_tmp47_);
	g_object_ref_sink (_tmp48_);
	_tmp49_ = _tmp48_;
	_g_free0 (_tmp47_);
	placeholder = _tmp49_;
	gtk_label_set_use_markup (placeholder, TRUE);
	_tmp50_ = gtk_widget_get_style_context ((GtkWidget*) placeholder);
	gtk_style_context_add_class (_tmp50_, "dim-label");
	gtk_widget_show ((GtkWidget*) placeholder);
	g_object_set ((GtkWidget*) placeholder, "margin", 6, NULL);
	_tmp51_ = self->content;
	gtk_widget_set_valign ((GtkWidget*) _tmp51_, GTK_ALIGN_START);
	_tmp52_ = self->content;
	gtk_list_box_set_placeholder (_tmp52_, (GtkWidget*) placeholder);
	g_signal_connect_object (settings, "changed", (GCallback) _budgie_menu_window_on_settings_changed_g_settings_changed, self, 0);
	budgie_menu_window_on_settings_changed (self, "menu-compact");
	budgie_menu_window_on_settings_changed (self, "menu-headers");
	budgie_menu_window_on_settings_changed (self, "menu-categories-hover");
	_tmp53_ = self->content;
	gtk_list_box_set_filter_func (_tmp53_, _budgie_menu_window_do_filter_list_gtk_list_box_filter_func, g_object_ref (self), g_object_unref);
	_tmp54_ = self->content;
	gtk_list_box_set_sort_func (_tmp54_, _budgie_menu_window_do_sort_list_gtk_list_box_sort_func, g_object_ref (self), g_object_unref);
	_tmp55_ = self->search_entry;
	g_signal_connect_object ((GtkEditable*) _tmp55_, "changed", (GCallback) ___lambda7__gtk_editable_changed, self, 0);
	_tmp56_ = self->search_entry;
	gtk_widget_grab_focus ((GtkWidget*) _tmp56_);
	_tmp57_ = self->search_entry;
	g_signal_connect_object ((GtkEntry*) _tmp57_, "activate", (GCallback) _budgie_menu_window_on_entry_activate_gtk_entry_activate, self, 0);
	gtk_widget_set_size_request ((GtkWidget*) self, 300, 510);
	_tmp58_ = self->categories_scroll;
	gtk_scrolled_window_set_min_content_height (_tmp58_, 510);
	_tmp59_ = self->categories_scroll;
	gtk_scrolled_window_set_propagate_natural_height (_tmp59_, TRUE);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda8__gsource_func, g_object_ref (self), g_object_unref);
	_g_object_unref0 (placeholder);
	_g_object_unref0 (right_layout);
	_g_object_unref0 (middle);
	return self;
}

BudgieMenuWindow*
budgie_menu_window_new (GSettings* settings,
                        GtkWidget* leparent)
{
	return budgie_menu_window_construct (TYPE_BUDGIE_MENU_WINDOW, settings, leparent);
}

static gboolean
__lambda10_ (BudgieMenuWindow* self)
{
	GtkListBox* _tmp0_;
	GtkListBox* _tmp1_;
	GtkListBox* _tmp2_;
	gboolean result;
	budgie_menu_window_load_menus (self, NULL);
	_tmp0_ = self->content;
	gtk_list_box_invalidate_headers (_tmp0_);
	_tmp1_ = self->content;
	gtk_list_box_invalidate_filter (_tmp1_);
	_tmp2_ = self->content;
	gtk_list_box_invalidate_sort (_tmp2_);
	result = FALSE;
	return result;
}

static gboolean
___lambda10__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda10_ ((BudgieMenuWindow*) self);
	return result;
}

void
budgie_menu_window_refresh_tree (BudgieMenuWindow* self)
{
	GtkListBox* _tmp0_;
	GList* _tmp1_;
	GHashTable* _tmp3_;
	GHashTable* _tmp4_;
	GHashTable* _tmp5_;
	GtkBox* _tmp6_;
	GList* _tmp7_;
	GMenuTree* _tmp12_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		g_rec_mutex_lock (&self->priv->__lock_reloading);
		{
			if (self->priv->reloading) {
				{
					g_rec_mutex_unlock (&self->priv->__lock_reloading);
				}
				return;
			}
			self->priv->reloading = TRUE;
		}
		__finally0:
		{
			g_rec_mutex_unlock (&self->priv->__lock_reloading);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp0_ = self->content;
	_tmp1_ = gtk_container_get_children ((GtkContainer*) _tmp0_);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp1_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			GtkWidget* child = NULL;
			child = (GtkWidget*) child_it->data;
			{
				GtkWidget* _tmp2_;
				_tmp2_ = child;
				gtk_widget_destroy (_tmp2_);
			}
		}
		(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
	}
	_tmp3_ = self->category_buttons;
	g_hash_table_remove_all (_tmp3_);
	_tmp4_ = self->category_has_items;
	g_hash_table_remove_all (_tmp4_);
	_tmp5_ = self->menu_buttons;
	g_hash_table_remove_all (_tmp5_);
	_tmp6_ = self->categories;
	_tmp7_ = gtk_container_get_children ((GtkContainer*) _tmp6_);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp7_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			GtkWidget* child = NULL;
			child = (GtkWidget*) child_it->data;
			{
				GtkWidget* _tmp8_;
				CategoryButton* _tmp9_;
				_tmp8_ = child;
				_tmp9_ = self->all_categories;
				if (_tmp8_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_widget_get_type (), GtkWidget)) {
					GtkWidget* _tmp10_;
					GtkWidget* _tmp11_;
					_tmp10_ = child;
					g_signal_handlers_disconnect_by_func (_tmp10_, (void*) budgie_menu_window_on_mouse_enter, self);
					_tmp11_ = child;
					gtk_widget_destroy (_tmp11_);
				}
			}
		}
		(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
	}
	_tmp12_ = self->priv->tree;
	g_signal_handlers_disconnect_by_func (_tmp12_, (void*) budgie_menu_window_refresh_tree, self);
	_g_object_unref0 (self->priv->tree);
	self->priv->tree = NULL;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda10__gsource_func, g_object_ref (self), g_object_unref);
	{
		g_rec_mutex_lock (&self->priv->__lock_reloading);
		{
			self->priv->reloading = FALSE;
		}
		__finally1:
		{
			g_rec_mutex_unlock (&self->priv->__lock_reloading);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

/**
 * Permits "rolling" over categories
 */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
budgie_menu_window_on_mouse_enter (BudgieMenuWindow* self,
                                   GtkWidget* source_widget,
                                   GdkEventCrossing* e)
{
	GtkToggleButton* b = NULL;
	GtkToggleButton* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GtkToggleButton* _tmp2_;
	GtkToggleButton* _tmp4_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (source_widget != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	if (!self->rollover_menus) {
		result = GDK_EVENT_PROPAGATE;
		return result;
	}
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (source_widget, gtk_toggle_button_get_type ()) ? ((GtkToggleButton*) source_widget) : NULL);
	b = _tmp0_;
	_tmp2_ = b;
	if (!gtk_widget_get_sensitive ((GtkWidget*) _tmp2_)) {
		_tmp1_ = TRUE;
	} else {
		GtkToggleButton* _tmp3_;
		_tmp3_ = b;
		_tmp1_ = !gtk_widget_get_visible ((GtkWidget*) _tmp3_);
	}
	if (_tmp1_) {
		result = GDK_EVENT_PROPAGATE;
		_g_object_unref0 (b);
		return result;
	}
	_tmp4_ = b;
	gtk_toggle_button_set_active (_tmp4_, TRUE);
	result = GDK_EVENT_PROPAGATE;
	_g_object_unref0 (b);
	return result;
}

/**
 * Load "menus" (.desktop's) recursively (ripped from our RunDialog)
 *
 * @param tree_root Initialised GMenu.TreeDirectory, or null
 */
static void
_budgie_menu_window_refresh_tree_gmenu_tree_changed (GMenuTree* _sender,
                                                     gpointer self)
{
	budgie_menu_window_refresh_tree ((BudgieMenuWindow*) self);
}

static gboolean
___lambda9_ (BudgieMenuWindow* self)
{
	GMenuTree* _tmp0_;
	gboolean result;
	_tmp0_ = self->priv->tree;
	g_signal_connect_object (_tmp0_, "changed", (GCallback) _budgie_menu_window_refresh_tree_gmenu_tree_changed, self, 0);
	result = FALSE;
	return result;
}

static gboolean
____lambda9__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda9_ ((BudgieMenuWindow*) self);
	return result;
}

static GMenuTreeDirectory*
_vala_GMenuTreeDirectory_copy (GMenuTreeDirectory* self)
{
	return g_boxed_copy (gmenu_tree_directory_get_type (), self);
}

static gpointer
__vala_GMenuTreeDirectory_copy0 (gpointer self)
{
	return self ? _vala_GMenuTreeDirectory_copy (self) : NULL;
}

static GMenuTreeItemType*
_gmenu_tree_item_type_dup (GMenuTreeItemType* self)
{
	GMenuTreeItemType* dup;
	dup = g_new0 (GMenuTreeItemType, 1);
	memcpy (dup, self, sizeof (GMenuTreeItemType));
	return dup;
}

static gpointer
__gmenu_tree_item_type_dup0 (gpointer self)
{
	return self ? _gmenu_tree_item_type_dup (self) : NULL;
}

static gboolean
_gmenu_tree_item_type_equal (const GMenuTreeItemType * s1,
                             const GMenuTreeItemType * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	return (*s1) == (*s2);
}

static void
_vala_GMenuTreeIter_free (GMenuTreeIter* self)
{
	g_boxed_free (gmenu_tree_iter_get_type (), self);
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		BudgieMenuWindow* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->btn);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
_____lambda11_ (Block1Data* _data1_)
{
	BudgieMenuWindow* self;
	CategoryButton* _tmp0_;
	self = _data1_->self;
	_tmp0_ = _data1_->btn;
	budgie_menu_window_update_category (self, _tmp0_);
}

static void
______lambda11__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                           gpointer self)
{
	_____lambda11_ (self);
}

static void
_vala_GMenuTreeEntry_free (GMenuTreeEntry* self)
{
	g_boxed_free (gmenu_tree_entry_get_type (), self);
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		BudgieMenuWindow* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->btn);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static void
_______lambda12_ (Block2Data* _data2_)
{
	BudgieMenuWindow* self;
	MenuButton* _tmp0_;
	GDesktopAppInfo* _tmp1_;
	GDesktopAppInfo* _tmp2_;
	self = _data2_->self;
	gtk_widget_hide ((GtkWidget*) self);
	_tmp0_ = _data2_->btn;
	_tmp1_ = menu_button_get_info (_tmp0_);
	_tmp2_ = _tmp1_;
	budgie_menu_window_launch_app (self, _tmp2_);
}

static void
________lambda12__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self)
{
	_______lambda12_ (self);
}

static gboolean*
_bool_dup (gboolean* self)
{
	gboolean* dup;
	dup = g_new0 (gboolean, 1);
	memcpy (dup, self, sizeof (gboolean));
	return dup;
}

static gpointer
__bool_dup0 (gpointer self)
{
	return self ? _bool_dup (self) : NULL;
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static inline void
_g_list_free__g_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_free0_);
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		BudgieMenuWindow* self;
		self = _data3_->self;
		(_data3_->category_names == NULL) ? NULL : (_data3_->category_names = (_g_list_free__g_free0_ (_data3_->category_names), NULL));
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static void
___lambda13_ (Block3Data* _data3_,
              const gchar* name,
              gboolean* has)
{
	BudgieMenuWindow* self;
	self = _data3_->self;
	g_return_if_fail (name != NULL);
	if (*has) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (name);
		_data3_->category_names = g_list_append (_data3_->category_names, _tmp0_);
	} else {
		GHashTable* _tmp1_;
		_tmp1_ = self->category_buttons;
		g_hash_table_remove (_tmp1_, name);
	}
}

static void
____lambda13__gh_func (gconstpointer key,
                       gconstpointer value,
                       gpointer self)
{
	___lambda13_ (self, (const gchar*) key, (gboolean*) value);
}

static gint
___lambda14_ (const gchar* cat_one,
              const gchar* cat_two)
{
	gint result;
	g_return_val_if_fail (cat_one != NULL, 0);
	g_return_val_if_fail (cat_two != NULL, 0);
	result = g_utf8_collate (cat_one, cat_two);
	return result;
}

static gint
____lambda14__gcompare_func (gconstpointer a,
                             gconstpointer b)
{
	gint result;
	result = ___lambda14_ ((const gchar*) a, (const gchar*) b);
	return result;
}

static void
___lambda15_ (BudgieMenuWindow* self,
              const gchar* category_name)
{
	CategoryButton* button = NULL;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	CategoryButton* _tmp2_;
	CategoryButton* _tmp3_;
	g_return_if_fail (category_name != NULL);
	_tmp0_ = self->category_buttons;
	_tmp1_ = g_hash_table_lookup (_tmp0_, category_name);
	_tmp2_ = _g_object_ref0 ((CategoryButton*) _tmp1_);
	button = _tmp2_;
	_tmp3_ = button;
	if (_tmp3_ != NULL) {
		GtkBox* _tmp4_;
		CategoryButton* _tmp5_;
		_tmp4_ = self->categories;
		_tmp5_ = button;
		gtk_box_pack_start (_tmp4_, (GtkWidget*) _tmp5_, FALSE, FALSE, (guint) 0);
	}
	_g_object_unref0 (button);
}

static void
____lambda15__gfunc (gconstpointer data,
                     gpointer self)
{
	___lambda15_ ((BudgieMenuWindow*) self, (const gchar*) data);
}

static void
budgie_menu_window_load_menus (BudgieMenuWindow* self,
                               GMenuTreeDirectory* tree_root)
{
	GMenuTreeDirectory* root = NULL;
	gboolean is_top_level = FALSE;
	GMenuTree* _tmp0_;
	gboolean _tmp9_ = FALSE;
	GMenuTreeDirectory* _tmp10_;
	GMenuTreeIter* it = NULL;
	GMenuTreeDirectory* _tmp26_;
	GMenuTreeIter* _tmp27_;
	GMenuTreeItemType* type = NULL;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	is_top_level = FALSE;
	_tmp0_ = self->priv->tree;
	if (_tmp0_ == NULL) {
		GMenuTree* _tmp1_;
		is_top_level = TRUE;
		_tmp1_ = gmenu_tree_new (APPS_ID, GMENU_TREE_FLAGS_SORT_DISPLAY_NAME);
		_g_object_unref0 (self->priv->tree);
		self->priv->tree = _tmp1_;
		{
			GMenuTree* _tmp2_;
			_tmp2_ = self->priv->tree;
			gmenu_tree_load_sync (_tmp2_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			FILE* _tmp3_;
			GError* _tmp4_;
			const gchar* _tmp5_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp3_ = stderr;
			_tmp4_ = e;
			_tmp5_ = _tmp4_->message;
			fprintf (_tmp3_, "Error: %s\n", _tmp5_);
			{
				g_rec_mutex_lock (&self->priv->__lock_reloading);
				{
					self->priv->reloading = FALSE;
				}
				__finally1:
				{
					g_rec_mutex_unlock (&self->priv->__lock_reloading);
				}
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_error_free0 (e);
					__vala_GMenuTreeDirectory_free0 (root);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
			_g_error_free0 (e);
			__vala_GMenuTreeDirectory_free0 (root);
			return;
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			__vala_GMenuTreeDirectory_free0 (root);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda9__gsource_func, g_object_ref (self), g_object_unref);
	}
	if (tree_root == NULL) {
		GMenuTree* _tmp6_;
		GMenuTreeDirectory* _tmp7_;
		_tmp6_ = self->priv->tree;
		_tmp7_ = gmenu_tree_get_root_directory (_tmp6_);
		__vala_GMenuTreeDirectory_free0 (root);
		root = _tmp7_;
	} else {
		GMenuTreeDirectory* _tmp8_;
		_tmp8_ = __vala_GMenuTreeDirectory_copy0 (tree_root);
		__vala_GMenuTreeDirectory_free0 (root);
		root = _tmp8_;
	}
	_tmp10_ = self->priv->other_tree;
	if (_tmp10_ == NULL) {
		_tmp9_ = !self->priv->attempted_other_search;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		GMenuTreeIter* it = NULL;
		GMenuTreeDirectory* _tmp11_;
		GMenuTreeIter* _tmp12_;
		GMenuTreeItemType* type = NULL;
		_tmp11_ = root;
		_tmp12_ = gmenu_tree_directory_iter (_tmp11_);
		it = _tmp12_;
		while (TRUE) {
			GMenuTreeIter* _tmp13_;
			GMenuTreeItemType _tmp14_;
			GMenuTreeItemType* _tmp15_;
			GMenuTreeItemType* _tmp16_;
			GMenuTreeItemType _tmp17_;
			GMenuTreeItemType* _tmp18_;
			GMenuTreeItemType _tmp19_;
			_tmp13_ = it;
			_tmp14_ = gmenu_tree_iter_next (_tmp13_);
			_tmp15_ = __gmenu_tree_item_type_dup0 (&_tmp14_);
			_g_free0 (type);
			type = _tmp15_;
			_tmp16_ = type;
			_tmp17_ = GMENU_TREE_ITEM_INVALID;
			if (!(_gmenu_tree_item_type_equal (_tmp16_, &_tmp17_) != TRUE)) {
				break;
			}
			_tmp18_ = type;
			_tmp19_ = GMENU_TREE_ITEM_DIRECTORY;
			if (_gmenu_tree_item_type_equal (_tmp18_, &_tmp19_) == TRUE) {
				GMenuTreeDirectory* dir = NULL;
				GMenuTreeIter* _tmp20_;
				GMenuTreeDirectory* _tmp21_;
				GMenuTreeDirectory* _tmp22_;
				const gchar* _tmp23_;
				_tmp20_ = it;
				_tmp21_ = gmenu_tree_iter_get_directory (_tmp20_);
				dir = _tmp21_;
				_tmp22_ = dir;
				_tmp23_ = gmenu_tree_directory_get_desktop_file_path (_tmp22_);
				if (g_str_has_suffix (_tmp23_, "X-GNOME-Other.directory")) {
					GMenuTreeDirectory* _tmp24_;
					GMenuTreeDirectory* _tmp25_;
					_tmp24_ = dir;
					_tmp25_ = __vala_GMenuTreeDirectory_copy0 (_tmp24_);
					__vala_GMenuTreeDirectory_free0 (self->priv->other_tree);
					self->priv->other_tree = _tmp25_;
					__vala_GMenuTreeDirectory_free0 (dir);
					break;
				}
				__vala_GMenuTreeDirectory_free0 (dir);
			}
		}
		self->priv->attempted_other_search = TRUE;
		_g_free0 (type);
		__vala_GMenuTreeIter_free0 (it);
	}
	_tmp26_ = root;
	_tmp27_ = gmenu_tree_directory_iter (_tmp26_);
	it = _tmp27_;
	while (TRUE) {
		GMenuTreeIter* _tmp28_;
		GMenuTreeItemType _tmp29_;
		GMenuTreeItemType* _tmp30_;
		GMenuTreeItemType* _tmp31_;
		GMenuTreeItemType _tmp32_;
		GMenuTreeItemType* _tmp33_;
		GMenuTreeItemType _tmp34_;
		_tmp28_ = it;
		_tmp29_ = gmenu_tree_iter_next (_tmp28_);
		_tmp30_ = __gmenu_tree_item_type_dup0 (&_tmp29_);
		_g_free0 (type);
		type = _tmp30_;
		_tmp31_ = type;
		_tmp32_ = GMENU_TREE_ITEM_INVALID;
		if (!(_gmenu_tree_item_type_equal (_tmp31_, &_tmp32_) != TRUE)) {
			break;
		}
		_tmp33_ = type;
		_tmp34_ = GMENU_TREE_ITEM_DIRECTORY;
		if (_gmenu_tree_item_type_equal (_tmp33_, &_tmp34_) == TRUE) {
			GMenuTreeDirectory* dir = NULL;
			GMenuTreeIter* _tmp35_;
			GMenuTreeDirectory* _tmp36_;
			gboolean is_sundry = FALSE;
			GMenuTreeDirectory* _tmp37_;
			const gchar* _tmp38_;
			gboolean _tmp39_ = FALSE;
			GMenuTreeDirectory* _tmp54_;
			_tmp35_ = it;
			_tmp36_ = gmenu_tree_iter_get_directory (_tmp35_);
			dir = _tmp36_;
			_tmp37_ = dir;
			_tmp38_ = gmenu_tree_directory_get_desktop_file_path (_tmp37_);
			is_sundry = g_str_has_suffix (_tmp38_, "X-GNOME-Sundry.directory");
			if (!is_sundry) {
				_tmp39_ = TRUE;
			} else {
				gboolean _tmp40_ = FALSE;
				if (is_sundry) {
					GMenuTreeDirectory* _tmp41_;
					_tmp41_ = self->priv->other_tree;
					_tmp40_ = _tmp41_ == NULL;
				} else {
					_tmp40_ = FALSE;
				}
				_tmp39_ = _tmp40_;
			}
			if (_tmp39_) {
				Block1Data* _data1_;
				GMenuTreeDirectory* _tmp42_;
				CategoryButton* _tmp43_;
				CategoryButton* _tmp44_;
				CategoryButton* _tmp45_;
				CategoryButton* _tmp46_;
				GHashTable* _tmp47_;
				GMenuTreeDirectory* _tmp48_;
				const gchar* _tmp49_;
				gchar* _tmp50_;
				CategoryButton* _tmp51_;
				CategoryButton* _tmp52_;
				CategoryButton* _tmp53_;
				_data1_ = g_slice_new0 (Block1Data);
				_data1_->_ref_count_ = 1;
				_data1_->self = g_object_ref (self);
				_tmp42_ = dir;
				_tmp43_ = category_button_new (_tmp42_);
				g_object_ref_sink (_tmp43_);
				_data1_->btn = _tmp43_;
				_tmp44_ = _data1_->btn;
				_tmp45_ = self->all_categories;
				gtk_radio_button_join_group ((GtkRadioButton*) _tmp44_, (GtkRadioButton*) _tmp45_);
				_tmp46_ = _data1_->btn;
				g_signal_connect_object ((GtkWidget*) _tmp46_, "enter-notify-event", (GCallback) _budgie_menu_window_on_mouse_enter_gtk_widget_enter_notify_event, self, 0);
				_tmp47_ = self->category_buttons;
				_tmp48_ = dir;
				_tmp49_ = gmenu_tree_directory_get_name (_tmp48_);
				_tmp50_ = g_strdup (_tmp49_);
				_tmp51_ = _data1_->btn;
				_tmp52_ = _g_object_ref0 (_tmp51_);
				g_hash_table_insert (_tmp47_, _tmp50_, _tmp52_);
				_tmp53_ = _data1_->btn;
				g_signal_connect_data ((GtkToggleButton*) _tmp53_, "toggled", (GCallback) ______lambda11__gtk_toggle_button_toggled, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
				block1_data_unref (_data1_);
				_data1_ = NULL;
			}
			_tmp54_ = dir;
			budgie_menu_window_load_menus (self, _tmp54_);
			__vala_GMenuTreeDirectory_free0 (dir);
		} else {
			GMenuTreeItemType* _tmp55_;
			GMenuTreeItemType _tmp56_;
			_tmp55_ = type;
			_tmp56_ = GMENU_TREE_ITEM_ENTRY;
			if (_gmenu_tree_item_type_equal (_tmp55_, &_tmp56_) == TRUE) {
				GDesktopAppInfo* appinfo = NULL;
				GMenuTreeIter* _tmp57_;
				GMenuTreeEntry* _tmp58_;
				GMenuTreeEntry* _tmp59_;
				GDesktopAppInfo* _tmp60_;
				GDesktopAppInfo* _tmp61_;
				GDesktopAppInfo* _tmp62_;
				_tmp57_ = it;
				_tmp58_ = gmenu_tree_iter_get_entry (_tmp57_);
				_tmp59_ = _tmp58_;
				_tmp60_ = gmenu_tree_entry_get_app_info (_tmp59_);
				_tmp61_ = _g_object_ref0 (_tmp60_);
				_tmp62_ = _tmp61_;
				__vala_GMenuTreeEntry_free0 (_tmp59_);
				appinfo = _tmp62_;
				if (tree_root == NULL) {
					GDesktopAppInfo* _tmp63_;
					const gchar* _tmp64_;
					_tmp63_ = appinfo;
					_tmp64_ = g_app_info_get_display_name ((GAppInfo*) _tmp63_);
					g_warning ("BudgieMenuWindow.vala:311: %s has no parent directory, not adding to m" \
"enu\n", _tmp64_);
				} else {
					GMenuTreeDirectory* use_root = NULL;
					GMenuTreeDirectory* _tmp65_;
					GMenuTreeDirectory* _tmp66_;
					gboolean _tmp67_ = FALSE;
					GDesktopAppInfo* _tmp68_;
					gchar** not_show_in = NULL;
					GDesktopAppInfo* _tmp70_;
					gsize _tmp71_ = 0;
					gchar** _tmp72_;
					gint not_show_in_length1;
					gint _not_show_in_size_;
					gboolean not_show_in_budgie = FALSE;
					gchar** _tmp73_;
					gint _tmp73__length1;
					gchar* app_id = NULL;
					GDesktopAppInfo* _tmp81_;
					const gchar* _tmp82_;
					gchar* _tmp83_;
					GMenuTreeDirectory* _tmp84_;
					const gchar* _tmp85_;
					GHashTable* _tmp89_;
					const gchar* _tmp90_;
					_tmp65_ = root;
					_tmp66_ = __vala_GMenuTreeDirectory_copy0 (_tmp65_);
					use_root = _tmp66_;
					_tmp68_ = appinfo;
					if (g_desktop_app_info_get_is_hidden (_tmp68_)) {
						_tmp67_ = TRUE;
					} else {
						GDesktopAppInfo* _tmp69_;
						_tmp69_ = appinfo;
						_tmp67_ = g_desktop_app_info_get_nodisplay (_tmp69_);
					}
					if (_tmp67_) {
						__vala_GMenuTreeDirectory_free0 (use_root);
						_g_object_unref0 (appinfo);
						continue;
					}
					_tmp70_ = appinfo;
					_tmp72_ = g_desktop_app_info_get_string_list (_tmp70_, "NotShowIn", &_tmp71_);
					not_show_in = _tmp72_;
					not_show_in_length1 = _tmp71_;
					_not_show_in_size_ = not_show_in_length1;
					not_show_in_budgie = FALSE;
					_tmp73_ = not_show_in;
					_tmp73__length1 = not_show_in_length1;
					if (_tmp73_ != NULL) {
						{
							gint i = 0;
							i = 0;
							{
								gboolean _tmp74_ = FALSE;
								_tmp74_ = TRUE;
								while (TRUE) {
									gchar** _tmp76_;
									gint _tmp76__length1;
									gchar* item = NULL;
									gchar** _tmp77_;
									gint _tmp77__length1;
									const gchar* _tmp78_;
									gchar* _tmp79_;
									const gchar* _tmp80_;
									if (!_tmp74_) {
										gint _tmp75_;
										_tmp75_ = i;
										i = _tmp75_ + 1;
									}
									_tmp74_ = FALSE;
									_tmp76_ = not_show_in;
									_tmp76__length1 = not_show_in_length1;
									if (!(i < _tmp76__length1)) {
										break;
									}
									_tmp77_ = not_show_in;
									_tmp77__length1 = not_show_in_length1;
									_tmp78_ = _tmp77_[i];
									_tmp79_ = g_strdup (_tmp78_);
									item = _tmp79_;
									_tmp80_ = item;
									not_show_in_budgie = string_contains (_tmp80_, "Budgie");
									if (not_show_in_budgie) {
										_g_free0 (item);
										break;
									}
									_g_free0 (item);
								}
							}
						}
					}
					if (not_show_in_budgie) {
						not_show_in = (_vala_array_free (not_show_in, not_show_in_length1, (GDestroyNotify) g_free), NULL);
						__vala_GMenuTreeDirectory_free0 (use_root);
						_g_object_unref0 (appinfo);
						continue;
					}
					_tmp81_ = appinfo;
					_tmp82_ = g_app_info_get_id ((GAppInfo*) _tmp81_);
					_tmp83_ = g_strdup (_tmp82_);
					app_id = _tmp83_;
					_tmp84_ = root;
					_tmp85_ = gmenu_tree_directory_get_desktop_file_path (_tmp84_);
					if (g_str_has_suffix (_tmp85_, "X-GNOME-Sundry.directory")) {
						GMenuTreeDirectory* _tmp86_;
						_tmp86_ = self->priv->other_tree;
						if (_tmp86_ != NULL) {
							GMenuTreeDirectory* _tmp87_;
							GMenuTreeDirectory* _tmp88_;
							_tmp87_ = self->priv->other_tree;
							_tmp88_ = __vala_GMenuTreeDirectory_copy0 (_tmp87_);
							__vala_GMenuTreeDirectory_free0 (use_root);
							use_root = _tmp88_;
						}
					}
					_tmp89_ = self->menu_buttons;
					_tmp90_ = app_id;
					if (!g_hash_table_contains (_tmp89_, _tmp90_)) {
						Block2Data* _data2_;
						GDesktopAppInfo* _tmp91_;
						GMenuTreeDirectory* _tmp92_;
						MenuButton* _tmp93_;
						MenuButton* _tmp94_;
						GHashTable* _tmp95_;
						const gchar* _tmp96_;
						gchar* _tmp97_;
						MenuButton* _tmp98_;
						MenuButton* _tmp99_;
						MenuButton* _tmp100_;
						GtkListBox* _tmp101_;
						MenuButton* _tmp102_;
						gchar* desktop_file_path = NULL;
						GMenuTreeDirectory* _tmp103_;
						const gchar* _tmp104_;
						gchar* _tmp105_;
						GHashTable* _tmp106_;
						const gchar* _tmp107_;
						gchar* _tmp108_;
						gboolean _tmp109_;
						gboolean* _tmp110_;
						_data2_ = g_slice_new0 (Block2Data);
						_data2_->_ref_count_ = 1;
						_data2_->self = g_object_ref (self);
						_tmp91_ = appinfo;
						_tmp92_ = use_root;
						_tmp93_ = menu_button_new (_tmp91_, _tmp92_, self->icon_size);
						g_object_ref_sink (_tmp93_);
						_data2_->btn = _tmp93_;
						_tmp94_ = _data2_->btn;
						g_signal_connect_data ((GtkButton*) _tmp94_, "clicked", (GCallback) ________lambda12__gtk_button_clicked, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
						_tmp95_ = self->menu_buttons;
						_tmp96_ = app_id;
						_tmp97_ = g_strdup (_tmp96_);
						_tmp98_ = _data2_->btn;
						_tmp99_ = _g_object_ref0 (_tmp98_);
						g_hash_table_insert (_tmp95_, _tmp97_, _tmp99_);
						_tmp100_ = _data2_->btn;
						gtk_widget_show_all ((GtkWidget*) _tmp100_);
						_tmp101_ = self->content;
						_tmp102_ = _data2_->btn;
						gtk_container_add ((GtkContainer*) _tmp101_, (GtkWidget*) _tmp102_);
						_tmp103_ = use_root;
						_tmp104_ = gmenu_tree_directory_get_name (_tmp103_);
						_tmp105_ = g_strdup (_tmp104_);
						desktop_file_path = _tmp105_;
						_tmp106_ = self->category_has_items;
						_tmp107_ = desktop_file_path;
						_tmp108_ = g_strdup (_tmp107_);
						_tmp109_ = TRUE;
						_tmp110_ = __bool_dup0 (&_tmp109_);
						g_hash_table_insert (_tmp106_, _tmp108_, _tmp110_);
						_g_free0 (desktop_file_path);
						block2_data_unref (_data2_);
						_data2_ = NULL;
					}
					_g_free0 (app_id);
					not_show_in = (_vala_array_free (not_show_in, not_show_in_length1, (GDestroyNotify) g_free), NULL);
					__vala_GMenuTreeDirectory_free0 (use_root);
				}
				_g_object_unref0 (appinfo);
			}
		}
	}
	if (is_top_level) {
		Block3Data* _data3_;
		GHashTable* _tmp111_;
		GList* _tmp112_;
		_data3_ = g_slice_new0 (Block3Data);
		_data3_->_ref_count_ = 1;
		_data3_->self = g_object_ref (self);
		_data3_->category_names = NULL;
		_tmp111_ = self->category_has_items;
		g_hash_table_foreach (_tmp111_, ____lambda13__gh_func, _data3_);
		_data3_->category_names = g_list_sort (_data3_->category_names, ____lambda14__gcompare_func);
		_tmp112_ = _data3_->category_names;
		g_list_foreach (_tmp112_, ____lambda15__gfunc, self);
		block3_data_unref (_data3_);
		_data3_ = NULL;
	}
	_g_free0 (type);
	__vala_GMenuTreeIter_free0 (it);
	__vala_GMenuTreeDirectory_free0 (root);
}

static void
_budgie_menu_window_do_list_header_gtk_list_box_update_header_func (GtkListBoxRow* row,
                                                                    GtkListBoxRow* before,
                                                                    gpointer self)
{
	budgie_menu_window_do_list_header ((BudgieMenuWindow*) self, row, before);
}

void
budgie_menu_window_on_settings_changed (BudgieMenuWindow* self,
                                        const gchar* key)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = key;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("menu-compact")))) {
		switch (0) {
			default:
			{
				gboolean vis = FALSE;
				GSettings* _tmp3_;
				GtkScrolledWindow* _tmp4_;
				GtkScrolledWindow* _tmp5_;
				GtkListBox* _tmp6_;
				GtkListBox* _tmp7_;
				GtkListBox* _tmp8_;
				_tmp3_ = self->priv->_settings;
				vis = g_settings_get_boolean (_tmp3_, key);
				_tmp4_ = self->categories_scroll;
				gtk_widget_set_no_show_all ((GtkWidget*) _tmp4_, vis);
				_tmp5_ = self->categories_scroll;
				gtk_widget_set_visible ((GtkWidget*) _tmp5_, vis);
				self->compact_mode = vis;
				_tmp6_ = self->content;
				gtk_list_box_invalidate_headers (_tmp6_);
				_tmp7_ = self->content;
				gtk_list_box_invalidate_filter (_tmp7_);
				_tmp8_ = self->content;
				gtk_list_box_invalidate_sort (_tmp8_);
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("menu-headers")))) {
		switch (0) {
			default:
			{
				gboolean hed = FALSE;
				GSettings* _tmp9_;
				GtkListBox* _tmp12_;
				GtkListBox* _tmp13_;
				GtkListBox* _tmp14_;
				_tmp9_ = self->priv->_settings;
				hed = g_settings_get_boolean (_tmp9_, key);
				self->headers_visible = hed;
				if (hed) {
					GtkListBox* _tmp10_;
					_tmp10_ = self->content;
					gtk_list_box_set_header_func (_tmp10_, _budgie_menu_window_do_list_header_gtk_list_box_update_header_func, g_object_ref (self), g_object_unref);
				} else {
					GtkListBox* _tmp11_;
					_tmp11_ = self->content;
					gtk_list_box_set_header_func (_tmp11_, NULL, NULL, NULL);
				}
				_tmp12_ = self->content;
				gtk_list_box_invalidate_headers (_tmp12_);
				_tmp13_ = self->content;
				gtk_list_box_invalidate_filter (_tmp13_);
				_tmp14_ = self->content;
				gtk_list_box_invalidate_sort (_tmp14_);
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("menu-categories-hover")))) {
		switch (0) {
			default:
			{
				GSettings* _tmp15_;
				_tmp15_ = self->priv->_settings;
				self->rollover_menus = g_settings_get_boolean (_tmp15_, key);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				break;
			}
		}
	}
}

void
budgie_menu_window_on_entry_activate (BudgieMenuWindow* self)
{
	GtkListBoxRow* selected = NULL;
	GList* rows = NULL;
	GtkListBox* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	GtkListBoxRow* _tmp13_;
	MenuButton* btn = NULL;
	GtkListBoxRow* _tmp14_;
	GtkWidget* _tmp15_;
	MenuButton* _tmp16_;
	MenuButton* _tmp17_;
	GDesktopAppInfo* _tmp18_;
	GDesktopAppInfo* _tmp19_;
	g_return_if_fail (self != NULL);
	selected = NULL;
	_tmp0_ = self->content;
	_tmp1_ = gtk_list_box_get_selected_rows (_tmp0_);
	rows = _tmp1_;
	_tmp2_ = rows;
	if (_tmp2_ != NULL) {
		GList* _tmp3_;
		gconstpointer _tmp4_;
		GtkListBoxRow* _tmp5_;
		_tmp3_ = rows;
		_tmp4_ = _tmp3_->data;
		_tmp5_ = _g_object_ref0 ((GtkListBoxRow*) _tmp4_);
		_g_object_unref0 (selected);
		selected = _tmp5_;
	} else {
		GtkListBox* _tmp6_;
		GList* _tmp7_;
		_tmp6_ = self->content;
		_tmp7_ = gtk_container_get_children ((GtkContainer*) _tmp6_);
		{
			GList* child_collection = NULL;
			GList* child_it = NULL;
			child_collection = _tmp7_;
			for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
				GtkWidget* child = NULL;
				child = (GtkWidget*) child_it->data;
				{
					gboolean _tmp8_ = FALSE;
					GtkWidget* _tmp9_;
					_tmp9_ = child;
					if (gtk_widget_get_visible (_tmp9_)) {
						GtkWidget* _tmp10_;
						_tmp10_ = child;
						_tmp8_ = gtk_widget_get_child_visible (_tmp10_);
					} else {
						_tmp8_ = FALSE;
					}
					if (_tmp8_) {
						GtkWidget* _tmp11_;
						GtkListBoxRow* _tmp12_;
						_tmp11_ = child;
						_tmp12_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, gtk_list_box_row_get_type ()) ? ((GtkListBoxRow*) _tmp11_) : NULL);
						_g_object_unref0 (selected);
						selected = _tmp12_;
						break;
					}
				}
			}
			(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
		}
	}
	_tmp13_ = selected;
	if (_tmp13_ == NULL) {
		(rows == NULL) ? NULL : (rows = (g_list_free (rows), NULL));
		_g_object_unref0 (selected);
		return;
	}
	_tmp14_ = selected;
	_tmp15_ = gtk_bin_get_child ((GtkBin*) _tmp14_);
	_tmp16_ = _g_object_ref0 (IS_MENU_BUTTON (_tmp15_) ? ((MenuButton*) _tmp15_) : NULL);
	btn = _tmp16_;
	_tmp17_ = btn;
	_tmp18_ = menu_button_get_info (_tmp17_);
	_tmp19_ = _tmp18_;
	budgie_menu_window_launch_app (self, _tmp19_);
	_g_object_unref0 (btn);
	(rows == NULL) ? NULL : (rows = (g_list_free (rows), NULL));
	_g_object_unref0 (selected);
}

void
budgie_menu_window_on_row_activate (BudgieMenuWindow* self,
                                    GtkListBoxRow* row)
{
	MenuButton* btn = NULL;
	GtkWidget* _tmp0_;
	MenuButton* _tmp1_;
	MenuButton* _tmp2_;
	GDesktopAppInfo* _tmp3_;
	GDesktopAppInfo* _tmp4_;
	g_return_if_fail (self != NULL);
	if (row == NULL) {
		return;
	}
	_tmp0_ = gtk_bin_get_child ((GtkBin*) row);
	_tmp1_ = _g_object_ref0 (IS_MENU_BUTTON (_tmp0_) ? ((MenuButton*) _tmp0_) : NULL);
	btn = _tmp1_;
	_tmp2_ = btn;
	_tmp3_ = menu_button_get_info (_tmp2_);
	_tmp4_ = _tmp3_;
	budgie_menu_window_launch_app (self, _tmp4_);
	_g_object_unref0 (btn);
}

/**
 * Provide category headers in the "All" category
 */
void
budgie_menu_window_do_list_header (BudgieMenuWindow* self,
                                   GtkListBoxRow* before,
                                   GtkListBoxRow* after)
{
	MenuButton* child = NULL;
	gchar* prev = NULL;
	gchar* next = NULL;
	GMenuTreeDirectory* _tmp0_;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	g_return_if_fail (self != NULL);
	child = NULL;
	prev = NULL;
	next = NULL;
	_tmp0_ = self->group;
	if (_tmp0_ != NULL) {
		if (before != NULL) {
			gtk_list_box_row_set_header (before, NULL);
		}
		if (after != NULL) {
			gtk_list_box_row_set_header (after, NULL);
		}
		_g_free0 (next);
		_g_free0 (prev);
		_g_object_unref0 (child);
		return;
	}
	if (before != NULL) {
		GtkWidget* _tmp1_;
		MenuButton* _tmp2_;
		MenuButton* _tmp3_;
		GMenuTreeDirectory* _tmp4_;
		GMenuTreeDirectory* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp1_ = gtk_bin_get_child ((GtkBin*) before);
		_tmp2_ = _g_object_ref0 (IS_MENU_BUTTON (_tmp1_) ? ((MenuButton*) _tmp1_) : NULL);
		_g_object_unref0 (child);
		child = _tmp2_;
		_tmp3_ = child;
		_tmp4_ = menu_button_get_parent_menu (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = gmenu_tree_directory_get_name (_tmp5_);
		_tmp7_ = g_strdup (_tmp6_);
		_g_free0 (prev);
		prev = _tmp7_;
	}
	if (after != NULL) {
		GtkWidget* _tmp8_;
		MenuButton* _tmp9_;
		MenuButton* _tmp10_;
		GMenuTreeDirectory* _tmp11_;
		GMenuTreeDirectory* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		_tmp8_ = gtk_bin_get_child ((GtkBin*) after);
		_tmp9_ = _g_object_ref0 (IS_MENU_BUTTON (_tmp8_) ? ((MenuButton*) _tmp8_) : NULL);
		_g_object_unref0 (child);
		child = _tmp9_;
		_tmp10_ = child;
		_tmp11_ = menu_button_get_parent_menu (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = gmenu_tree_directory_get_name (_tmp12_);
		_tmp14_ = g_strdup (_tmp13_);
		_g_free0 (next);
		next = _tmp14_;
	}
	if (before == NULL) {
		_tmp16_ = TRUE;
	} else {
		_tmp16_ = after == NULL;
	}
	if (_tmp16_) {
		_tmp15_ = TRUE;
	} else {
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		_tmp17_ = prev;
		_tmp18_ = next;
		_tmp15_ = g_strcmp0 (_tmp17_, _tmp18_) != 0;
	}
	if (_tmp15_) {
		GtkLabel* label = NULL;
		const gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		GtkLabel* _tmp22_;
		GtkLabel* _tmp23_;
		GtkLabel* _tmp24_;
		GtkStyleContext* _tmp25_;
		GtkLabel* _tmp26_;
		GtkLabel* _tmp27_;
		GtkLabel* _tmp28_;
		GtkLabel* _tmp29_;
		_tmp19_ = prev;
		_tmp20_ = g_markup_printf_escaped ("<big>%s</big>", _tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = (GtkLabel*) gtk_label_new (_tmp21_);
		g_object_ref_sink (_tmp22_);
		_tmp23_ = _tmp22_;
		_g_free0 (_tmp21_);
		label = _tmp23_;
		_tmp24_ = label;
		_tmp25_ = gtk_widget_get_style_context ((GtkWidget*) _tmp24_);
		gtk_style_context_add_class (_tmp25_, "dim-label");
		_tmp26_ = label;
		gtk_widget_set_halign ((GtkWidget*) _tmp26_, GTK_ALIGN_START);
		_tmp27_ = label;
		gtk_label_set_use_markup (_tmp27_, TRUE);
		_tmp28_ = label;
		gtk_list_box_row_set_header (before, (GtkWidget*) _tmp28_);
		_tmp29_ = label;
		g_object_set ((GtkWidget*) _tmp29_, "margin", 6, NULL);
		_g_object_unref0 (label);
	} else {
		gtk_list_box_row_set_header (before, NULL);
	}
	_g_free0 (next);
	_g_free0 (prev);
	_g_object_unref0 (child);
}

static gboolean
budgie_menu_window_array_contains (BudgieMenuWindow* self,
                                   gchar** array,
                                   gint array_length1,
                                   const gchar* term)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (term != NULL, FALSE);
	{
		gchar** field_collection = NULL;
		gint field_collection_length1 = 0;
		gint _field_collection_size_ = 0;
		gint field_it = 0;
		field_collection = array;
		field_collection_length1 = array_length1;
		for (field_it = 0; field_it < field_collection_length1; field_it = field_it + 1) {
			gchar* _tmp0_;
			gchar* field = NULL;
			_tmp0_ = g_strdup (field_collection[field_it]);
			field = _tmp0_;
			{
				const gchar* _tmp1_;
				gchar* ct = NULL;
				const gchar* _tmp2_;
				gchar* _tmp3_;
				const gchar* _tmp4_;
				const gchar* _tmp5_;
				_tmp1_ = field;
				if (_tmp1_ == NULL) {
					_g_free0 (field);
					continue;
				}
				_tmp2_ = field;
				_tmp3_ = searchable_string (_tmp2_);
				ct = _tmp3_;
				_tmp4_ = ct;
				if (g_str_match_string (term, _tmp4_, TRUE)) {
					result = TRUE;
					_g_free0 (ct);
					_g_free0 (field);
					return result;
				}
				_tmp5_ = ct;
				if (string_contains (_tmp5_, term)) {
					result = TRUE;
					_g_free0 (ct);
					_g_free0 (field);
					return result;
				}
				_g_free0 (ct);
				_g_free0 (field);
			}
		}
	}
	result = FALSE;
	return result;
}

static gchar**
_vala_array_dup1 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gboolean
budgie_menu_window_info_matches_term (BudgieMenuWindow* self,
                                      GAppInfo* info,
                                      const gchar* term)
{
	gchar** fields = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar** _tmp8_;
	gint fields_length1;
	gint _fields_size_;
	gchar** _tmp9_;
	gint _tmp9__length1;
	gchar** keywords = NULL;
	gchar** _tmp10_;
	gchar** _tmp11_;
	gchar** _tmp12_;
	gint _tmp12__length1;
	gint keywords_length1;
	gint _keywords_size_;
	gboolean _tmp13_ = FALSE;
	gchar** _tmp14_;
	gint _tmp14__length1;
	gchar** _tmp16_;
	gint _tmp16__length1;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (term != NULL, FALSE);
	if (info == NULL) {
		result = FALSE;
		return result;
	}
	_tmp0_ = g_app_info_get_display_name (info);
	_tmp1_ = g_strdup (_tmp0_);
	_tmp2_ = g_app_info_get_description (info);
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = g_app_info_get_name (info);
	_tmp5_ = g_strdup (_tmp4_);
	_tmp6_ = G_TYPE_INSTANCE_GET_INTERFACE (info, g_app_info_get_type (), GAppInfoIface)->get_executable (info);
	_tmp7_ = g_strdup (_tmp6_);
	_tmp8_ = g_new0 (gchar*, 4 + 1);
	_tmp8_[0] = _tmp1_;
	_tmp8_[1] = _tmp3_;
	_tmp8_[2] = _tmp5_;
	_tmp8_[3] = _tmp7_;
	fields = _tmp8_;
	fields_length1 = 4;
	_fields_size_ = fields_length1;
	_tmp9_ = fields;
	_tmp9__length1 = fields_length1;
	if (budgie_menu_window_array_contains (self, _tmp9_, (gint) _tmp9__length1, term)) {
		result = TRUE;
		fields = (_vala_array_free (fields, fields_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp11_ = _tmp10_ = g_desktop_app_info_get_keywords (G_TYPE_CHECK_INSTANCE_CAST (info, G_TYPE_DESKTOP_APP_INFO, GDesktopAppInfo));
	_tmp12_ = (_tmp11_ != NULL) ? _vala_array_dup1 (_tmp11_, _vala_array_length (_tmp10_)) : _tmp11_;
	_tmp12__length1 = _vala_array_length (_tmp10_);
	keywords = _tmp12_;
	keywords_length1 = _tmp12__length1;
	_keywords_size_ = keywords_length1;
	_tmp14_ = keywords;
	_tmp14__length1 = keywords_length1;
	if (_tmp14_ == NULL) {
		_tmp13_ = TRUE;
	} else {
		gchar** _tmp15_;
		gint _tmp15__length1;
		_tmp15_ = keywords;
		_tmp15__length1 = keywords_length1;
		_tmp13_ = _tmp15__length1 < 1;
	}
	if (_tmp13_) {
		result = FALSE;
		keywords = (_vala_array_free (keywords, keywords_length1, (GDestroyNotify) g_free), NULL);
		fields = (_vala_array_free (fields, fields_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp16_ = keywords;
	_tmp16__length1 = keywords_length1;
	result = budgie_menu_window_array_contains (self, _tmp16_, (gint) _tmp16__length1, term);
	keywords = (_vala_array_free (keywords, keywords_length1, (GDestroyNotify) g_free), NULL);
	fields = (_vala_array_free (fields, fields_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static gboolean
budgie_menu_window_is_item_dupe (BudgieMenuWindow* self,
                                 MenuButton* button)
{
	MenuButton* compare_item = NULL;
	GHashTable* _tmp0_;
	GDesktopAppInfo* _tmp1_;
	GDesktopAppInfo* _tmp2_;
	const gchar* _tmp3_;
	gconstpointer _tmp4_;
	MenuButton* _tmp5_;
	gboolean _tmp6_ = FALSE;
	MenuButton* _tmp7_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->menu_buttons;
	_tmp1_ = menu_button_get_info (button);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_app_info_get_id ((GAppInfo*) _tmp2_);
	_tmp4_ = g_hash_table_lookup (_tmp0_, _tmp3_);
	_tmp5_ = _g_object_ref0 ((MenuButton*) _tmp4_);
	compare_item = _tmp5_;
	_tmp7_ = compare_item;
	if (_tmp7_ != NULL) {
		MenuButton* _tmp8_;
		_tmp8_ = compare_item;
		_tmp6_ = _tmp8_ != button;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		result = TRUE;
		_g_object_unref0 (compare_item);
		return result;
	}
	result = FALSE;
	_g_object_unref0 (compare_item);
	return result;
}

/**
 * Filter out results in the list according to whatever the current filter is,
 * i.e. group based or search based
 */
gboolean
budgie_menu_window_do_filter_list (BudgieMenuWindow* self,
                                   GtkListBoxRow* row)
{
	MenuButton* child = NULL;
	GtkWidget* _tmp0_;
	MenuButton* _tmp1_;
	gchar* term = NULL;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	GtkBox* _tmp13_;
	GMenuTreeDirectory* _tmp14_;
	MenuButton* _tmp16_;
	GMenuTreeDirectory* _tmp17_;
	GMenuTreeDirectory* _tmp18_;
	GMenuTreeDirectory* _tmp19_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (row != NULL, FALSE);
	_tmp0_ = gtk_bin_get_child ((GtkBin*) row);
	_tmp1_ = _g_object_ref0 (IS_MENU_BUTTON (_tmp0_) ? ((MenuButton*) _tmp0_) : NULL);
	child = _tmp1_;
	_tmp2_ = self->search_term;
	_tmp3_ = string_strip (_tmp2_);
	term = _tmp3_;
	_tmp4_ = term;
	_tmp5_ = strlen (_tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_ > 0) {
		GtkBox* _tmp7_;
		MenuButton* _tmp8_;
		MenuButton* _tmp9_;
		GDesktopAppInfo* _tmp10_;
		GDesktopAppInfo* _tmp11_;
		const gchar* _tmp12_;
		_tmp7_ = self->categories;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp7_, FALSE);
		_tmp8_ = child;
		if (budgie_menu_window_is_item_dupe (self, _tmp8_)) {
			result = FALSE;
			_g_free0 (term);
			_g_object_unref0 (child);
			return result;
		}
		_tmp9_ = child;
		_tmp10_ = menu_button_get_info (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = term;
		result = budgie_menu_window_info_matches_term (self, (GAppInfo*) _tmp11_, _tmp12_);
		_g_free0 (term);
		_g_object_unref0 (child);
		return result;
	}
	_tmp13_ = self->categories;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp13_, TRUE);
	_tmp14_ = self->group;
	if (_tmp14_ == NULL) {
		if (self->headers_visible) {
			result = TRUE;
			_g_free0 (term);
			_g_object_unref0 (child);
			return result;
		} else {
			MenuButton* _tmp15_;
			_tmp15_ = child;
			result = !budgie_menu_window_is_item_dupe (self, _tmp15_);
			_g_free0 (term);
			_g_object_unref0 (child);
			return result;
		}
	}
	_tmp16_ = child;
	_tmp17_ = menu_button_get_parent_menu (_tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = self->group;
	if (_tmp18_ != _tmp19_) {
		result = FALSE;
		_g_free0 (term);
		_g_object_unref0 (child);
		return result;
	}
	result = TRUE;
	_g_free0 (term);
	_g_object_unref0 (child);
	return result;
}

gint
budgie_menu_window_do_sort_list (BudgieMenuWindow* self,
                                 GtkListBoxRow* row1,
                                 GtkListBoxRow* row2)
{
	MenuButton* child1 = NULL;
	GtkWidget* _tmp0_;
	MenuButton* _tmp1_;
	MenuButton* child2 = NULL;
	GtkWidget* _tmp2_;
	MenuButton* _tmp3_;
	gchar* term = NULL;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gchar* parentA = NULL;
	MenuButton* _tmp13_;
	GMenuTreeDirectory* _tmp14_;
	GMenuTreeDirectory* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* parentB = NULL;
	MenuButton* _tmp18_;
	GMenuTreeDirectory* _tmp19_;
	GMenuTreeDirectory* _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	gboolean _tmp23_ = FALSE;
	MenuButton* _tmp24_;
	GMenuTreeDirectory* _tmp25_;
	GMenuTreeDirectory* _tmp26_;
	MenuButton* _tmp27_;
	GMenuTreeDirectory* _tmp28_;
	GMenuTreeDirectory* _tmp29_;
	gchar* nameA = NULL;
	MenuButton* _tmp32_;
	GDesktopAppInfo* _tmp33_;
	GDesktopAppInfo* _tmp34_;
	const gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* nameB = NULL;
	MenuButton* _tmp37_;
	GDesktopAppInfo* _tmp38_;
	GDesktopAppInfo* _tmp39_;
	const gchar* _tmp40_;
	gchar* _tmp41_;
	const gchar* _tmp42_;
	const gchar* _tmp43_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (row1 != NULL, 0);
	g_return_val_if_fail (row2 != NULL, 0);
	_tmp0_ = gtk_bin_get_child ((GtkBin*) row1);
	_tmp1_ = _g_object_ref0 (IS_MENU_BUTTON (_tmp0_) ? ((MenuButton*) _tmp0_) : NULL);
	child1 = _tmp1_;
	_tmp2_ = gtk_bin_get_child ((GtkBin*) row2);
	_tmp3_ = _g_object_ref0 (IS_MENU_BUTTON (_tmp2_) ? ((MenuButton*) _tmp2_) : NULL);
	child2 = _tmp3_;
	_tmp4_ = self->search_term;
	_tmp5_ = string_strip (_tmp4_);
	term = _tmp5_;
	_tmp6_ = term;
	_tmp7_ = strlen (_tmp6_);
	_tmp8_ = _tmp7_;
	if (_tmp8_ > 0) {
		gint sc1 = 0;
		MenuButton* _tmp9_;
		const gchar* _tmp10_;
		gint sc2 = 0;
		MenuButton* _tmp11_;
		const gchar* _tmp12_;
		_tmp9_ = child1;
		_tmp10_ = term;
		sc1 = menu_button_get_score (_tmp9_, _tmp10_);
		_tmp11_ = child2;
		_tmp12_ = term;
		sc2 = menu_button_get_score (_tmp11_, _tmp12_);
		if (sc1 < sc2) {
			result = 1;
			_g_free0 (term);
			_g_object_unref0 (child2);
			_g_object_unref0 (child1);
			return result;
		} else {
			if (sc1 > sc2) {
				result = -1;
				_g_free0 (term);
				_g_object_unref0 (child2);
				_g_object_unref0 (child1);
				return result;
			}
		}
		result = 0;
		_g_free0 (term);
		_g_object_unref0 (child2);
		_g_object_unref0 (child1);
		return result;
	}
	_tmp13_ = child1;
	_tmp14_ = menu_button_get_parent_menu (_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = gmenu_tree_directory_get_name (_tmp15_);
	_tmp17_ = searchable_string (_tmp16_);
	parentA = _tmp17_;
	_tmp18_ = child2;
	_tmp19_ = menu_button_get_parent_menu (_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = gmenu_tree_directory_get_name (_tmp20_);
	_tmp22_ = searchable_string (_tmp21_);
	parentB = _tmp22_;
	_tmp24_ = child1;
	_tmp25_ = menu_button_get_parent_menu (_tmp24_);
	_tmp26_ = _tmp25_;
	_tmp27_ = child2;
	_tmp28_ = menu_button_get_parent_menu (_tmp27_);
	_tmp29_ = _tmp28_;
	if (_tmp26_ != _tmp29_) {
		_tmp23_ = self->headers_visible;
	} else {
		_tmp23_ = FALSE;
	}
	if (_tmp23_) {
		const gchar* _tmp30_;
		const gchar* _tmp31_;
		_tmp30_ = parentA;
		_tmp31_ = parentB;
		result = g_utf8_collate (_tmp30_, _tmp31_);
		_g_free0 (parentB);
		_g_free0 (parentA);
		_g_free0 (term);
		_g_object_unref0 (child2);
		_g_object_unref0 (child1);
		return result;
	}
	_tmp32_ = child1;
	_tmp33_ = menu_button_get_info (_tmp32_);
	_tmp34_ = _tmp33_;
	_tmp35_ = g_app_info_get_display_name ((GAppInfo*) _tmp34_);
	_tmp36_ = searchable_string (_tmp35_);
	nameA = _tmp36_;
	_tmp37_ = child2;
	_tmp38_ = menu_button_get_info (_tmp37_);
	_tmp39_ = _tmp38_;
	_tmp40_ = g_app_info_get_display_name ((GAppInfo*) _tmp39_);
	_tmp41_ = searchable_string (_tmp40_);
	nameB = _tmp41_;
	_tmp42_ = nameA;
	_tmp43_ = nameB;
	result = g_utf8_collate (_tmp42_, _tmp43_);
	_g_free0 (nameB);
	_g_free0 (nameA);
	_g_free0 (parentB);
	_g_free0 (parentA);
	_g_free0 (term);
	_g_object_unref0 (child2);
	_g_object_unref0 (child1);
	return result;
}

/**
 * Change the current group/category
 */
void
budgie_menu_window_update_category (BudgieMenuWindow* self,
                                    CategoryButton* btn)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (btn != NULL);
	_tmp0_ = gtk_toggle_button_get_active ((GtkToggleButton*) btn);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		GMenuTreeDirectory* _tmp2_;
		GMenuTreeDirectory* _tmp3_;
		GMenuTreeDirectory* _tmp4_;
		GtkListBox* _tmp5_;
		GtkListBox* _tmp6_;
		GtkListBox* _tmp7_;
		_tmp2_ = category_button_get_group (btn);
		_tmp3_ = _tmp2_;
		_tmp4_ = __vala_GMenuTreeDirectory_copy0 (_tmp3_);
		__vala_GMenuTreeDirectory_free0 (self->group);
		self->group = _tmp4_;
		_tmp5_ = self->content;
		gtk_list_box_invalidate_filter (_tmp5_);
		_tmp6_ = self->content;
		gtk_list_box_invalidate_headers (_tmp6_);
		_tmp7_ = self->content;
		gtk_list_box_invalidate_sort (_tmp7_);
	}
}

/**
 * Launch an application
 */
static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		BudgieMenuWindow* self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->info);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static void
____lambda6_ (BudgieMenuWindow* self,
              GPid pid,
              gint status)
{
	g_spawn_close_pid (pid);
}

static void
_____lambda6__gchild_watch_func (GPid pid,
                                 gint status,
                                 gpointer self)
{
	____lambda6_ ((BudgieMenuWindow*) self, pid, status);
}

static gboolean
__lambda5_ (Block4Data* _data4_)
{
	BudgieMenuWindow* self;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = _data4_->self;
	{
		gchar* commandline = NULL;
		const gchar* _tmp0_;
		gchar* _tmp1_;
		gchar** spawn_args = NULL;
		gchar** _tmp2_;
		gint spawn_args_length1;
		gint _spawn_args_size_;
		static const char checkstr[] = "pkexec";
		const gchar* _tmp3_;
		gboolean _tmp7_ = FALSE;
		gchar** _tmp8_;
		gint _tmp8__length1;
		_tmp0_ = G_TYPE_INSTANCE_GET_INTERFACE ((GAppInfo*) _data4_->info, g_app_info_get_type (), GAppInfoIface)->get_commandline ((GAppInfo*) _data4_->info);
		_tmp1_ = g_strdup (_tmp0_);
		commandline = _tmp1_;
		_tmp2_ = g_new0 (gchar*, 0 + 1);
		spawn_args = _tmp2_;
		spawn_args_length1 = 0;
		_spawn_args_size_ = spawn_args_length1;
		_tmp3_ = commandline;
		if (string_contains (_tmp3_, checkstr)) {
			const gchar* _tmp4_;
			gchar** _tmp5_;
			gchar** _tmp6_;
			_tmp4_ = commandline;
			_tmp6_ = _tmp5_ = g_strsplit (_tmp4_, " ", 0);
			spawn_args = (_vala_array_free (spawn_args, spawn_args_length1, (GDestroyNotify) g_free), NULL);
			spawn_args = _tmp6_;
			spawn_args_length1 = _vala_array_length (_tmp5_);
			_spawn_args_size_ = spawn_args_length1;
		}
		_tmp8_ = spawn_args;
		_tmp8__length1 = spawn_args_length1;
		if (_tmp8__length1 >= 2) {
			gchar** _tmp9_;
			gint _tmp9__length1;
			const gchar* _tmp10_;
			_tmp9_ = spawn_args;
			_tmp9__length1 = spawn_args_length1;
			_tmp10_ = _tmp9_[0];
			_tmp7_ = g_strcmp0 (_tmp10_, checkstr) == 0;
		} else {
			_tmp7_ = FALSE;
		}
		if (_tmp7_) {
			gchar** spawn_env = NULL;
			gchar** _tmp11_;
			gchar** _tmp12_;
			gint spawn_env_length1;
			gint _spawn_env_size_;
			GPid child_pid = 0;
			gchar** _tmp13_;
			gint _tmp13__length1;
			gchar** _tmp14_;
			gint _tmp14__length1;
			GPid _tmp15_ = 0;
			_tmp12_ = _tmp11_ = g_get_environ ();
			spawn_env = _tmp12_;
			spawn_env_length1 = _vala_array_length (_tmp11_);
			_spawn_env_size_ = spawn_env_length1;
			_tmp13_ = spawn_args;
			_tmp13__length1 = spawn_args_length1;
			_tmp14_ = spawn_env;
			_tmp14__length1 = spawn_env_length1;
			g_spawn_async ("/", _tmp13_, _tmp14_, G_SPAWN_SEARCH_PATH | G_SPAWN_DO_NOT_REAP_CHILD, NULL, NULL, &_tmp15_, &_inner_error0_);
			child_pid = _tmp15_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				spawn_env = (_vala_array_free (spawn_env, spawn_env_length1, (GDestroyNotify) g_free), NULL);
				spawn_args = (_vala_array_free (spawn_args, spawn_args_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (commandline);
				goto __catch0_g_error;
			}
			g_child_watch_add_full (G_PRIORITY_DEFAULT_IDLE, child_pid, _____lambda6__gchild_watch_func, g_object_ref (self), g_object_unref);
			spawn_env = (_vala_array_free (spawn_env, spawn_env_length1, (GDestroyNotify) g_free), NULL);
		} else {
			g_app_info_launch ((GAppInfo*) _data4_->info, NULL, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				spawn_args = (_vala_array_free (spawn_args, spawn_args_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (commandline);
				goto __catch0_g_error;
			}
		}
		spawn_args = (_vala_array_free (spawn_args, spawn_args_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (commandline);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		FILE* _tmp16_;
		GError* _tmp17_;
		const gchar* _tmp18_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp16_ = stdout;
		_tmp17_ = e;
		_tmp18_ = _tmp17_->message;
		fprintf (_tmp16_, "Error launching application: %s\n", _tmp18_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp19_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp19_;
	}
	result = FALSE;
	return result;
}

static gboolean
___lambda5__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda5_ (self);
	return result;
}

void
budgie_menu_window_launch_app (BudgieMenuWindow* self,
                               GDesktopAppInfo* info)
{
	Block4Data* _data4_;
	GDesktopAppInfo* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (info != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (info);
	_g_object_unref0 (_data4_->info);
	_data4_->info = _tmp0_;
	gtk_widget_hide ((GtkWidget*) self);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda5__gsource_func, block4_data_ref (_data4_), block4_data_unref);
	block4_data_unref (_data4_);
	_data4_ = NULL;
}

/**
 * We need to make some changes to our display before we go showing ourselves
 * again! :)
 */
static gboolean
__lambda16_ (BudgieMenuWindow* self)
{
	GtkSearchEntry* _tmp0_;
	gboolean result;
	_tmp0_ = self->search_entry;
	gtk_widget_grab_focus ((GtkWidget*) _tmp0_);
	result = FALSE;
	return result;
}

static gboolean
___lambda16__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda16_ ((BudgieMenuWindow*) self);
	return result;
}

static void
budgie_menu_window_real_show (GtkWidget* base)
{
	BudgieMenuWindow * self;
	gchar* _tmp0_;
	GtkSearchEntry* _tmp1_;
	CategoryButton* _tmp2_;
	GtkListBox* _tmp3_;
	GtkScrolledWindow* _tmp4_;
	GtkAdjustment* _tmp5_;
	GtkScrolledWindow* _tmp6_;
	GtkAdjustment* _tmp7_;
	GtkBox* _tmp8_;
	self = (BudgieMenuWindow*) base;
	_tmp0_ = g_strdup ("");
	_g_free0 (self->search_term);
	self->search_term = _tmp0_;
	_tmp1_ = self->search_entry;
	gtk_entry_set_text ((GtkEntry*) _tmp1_, "");
	__vala_GMenuTreeDirectory_free0 (self->group);
	self->group = NULL;
	_tmp2_ = self->all_categories;
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp2_, TRUE);
	_tmp3_ = self->content;
	gtk_list_box_select_row (_tmp3_, NULL);
	_tmp4_ = self->content_scroll;
	_tmp5_ = gtk_scrolled_window_get_vadjustment (_tmp4_);
	gtk_adjustment_set_value (_tmp5_, (gdouble) 0);
	_tmp6_ = self->categories_scroll;
	_tmp7_ = gtk_scrolled_window_get_vadjustment (_tmp6_);
	gtk_adjustment_set_value (_tmp7_, (gdouble) 0);
	_tmp8_ = self->categories;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp8_, TRUE);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda16__gsource_func, g_object_ref (self), g_object_unref);
	GTK_WIDGET_CLASS (budgie_menu_window_parent_class)->show ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, budgie_popover_get_type (), BudgiePopover));
	if (!self->compact_mode) {
		GtkScrolledWindow* _tmp9_;
		_tmp9_ = self->categories_scroll;
		gtk_widget_show_all ((GtkWidget*) _tmp9_);
	} else {
		GtkScrolledWindow* _tmp10_;
		_tmp10_ = self->categories_scroll;
		gtk_widget_hide ((GtkWidget*) _tmp10_);
	}
}

GSettings*
budgie_menu_window_get_settings (BudgieMenuWindow* self)
{
	GSettings* result;
	GSettings* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_settings;
	result = _tmp0_;
	return result;
}

void
budgie_menu_window_set_settings (BudgieMenuWindow* self,
                                 GSettings* value)
{
	GSettings* old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_menu_window_get_settings (self);
	if (old_value != value) {
		GSettings* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_settings);
		self->priv->_settings = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, budgie_menu_window_properties[BUDGIE_MENU_WINDOW_SETTINGS_PROPERTY]);
	}
}

static void
budgie_menu_window_class_init (BudgieMenuWindowClass * klass,
                               gpointer klass_data)
{
	budgie_menu_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BudgieMenuWindow_private_offset);
	((GtkWidgetClass *) klass)->show = (void (*) (GtkWidget*)) budgie_menu_window_real_show;
	G_OBJECT_CLASS (klass)->get_property = _vala_budgie_menu_window_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_budgie_menu_window_set_property;
	G_OBJECT_CLASS (klass)->finalize = budgie_menu_window_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_MENU_WINDOW_SETTINGS_PROPERTY, budgie_menu_window_properties[BUDGIE_MENU_WINDOW_SETTINGS_PROPERTY] = g_param_spec_object ("settings", "settings", "settings", g_settings_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
budgie_menu_window_instance_init (BudgieMenuWindow * self,
                                  gpointer klass)
{
	gchar* _tmp0_;
	self->priv = budgie_menu_window_get_instance_private (self);
	self->priv->attempted_other_search = FALSE;
	self->desktop_dir_overrides = NULL;
	self->category_has_items = NULL;
	self->category_buttons = NULL;
	self->menu_buttons = NULL;
	self->group = NULL;
	self->rollover_menus = TRUE;
	_tmp0_ = g_strdup ("");
	self->search_term = _tmp0_;
	self->icon_size = 24;
	g_rec_mutex_init (&self->priv->__lock_reloading);
	self->priv->reloading = FALSE;
}

static void
budgie_menu_window_finalize (GObject * obj)
{
	BudgieMenuWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BUDGIE_MENU_WINDOW, BudgieMenuWindow);
	_g_object_unref0 (self->search_entry);
	_g_object_unref0 (self->main_layout);
	_g_object_unref0 (self->categories);
	_g_object_unref0 (self->content);
	_g_object_unref0 (self->priv->tree);
	__vala_GMenuTreeDirectory_free0 (self->priv->other_tree);
	_g_object_unref0 (self->categories_scroll);
	_g_object_unref0 (self->content_scroll);
	_g_object_unref0 (self->all_categories);
	_g_hash_table_unref0 (self->desktop_dir_overrides);
	_g_hash_table_unref0 (self->category_has_items);
	_g_hash_table_unref0 (self->category_buttons);
	_g_hash_table_unref0 (self->menu_buttons);
	__vala_GMenuTreeDirectory_free0 (self->group);
	_g_free0 (self->search_term);
	_g_object_unref0 (self->priv->_settings);
	g_rec_mutex_clear (&self->priv->__lock_reloading);
	G_OBJECT_CLASS (budgie_menu_window_parent_class)->finalize (obj);
}

GType
budgie_menu_window_get_type (void)
{
	return budgie_menu_window_type_id;
}

GType
budgie_menu_window_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieMenuWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_menu_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieMenuWindow), 0, (GInstanceInitFunc) budgie_menu_window_instance_init, NULL };
	budgie_menu_window_type_id = g_type_module_register_type (module, budgie_popover_get_type (), "BudgieMenuWindow", &g_define_type_info, 0);
	BudgieMenuWindow_private_offset = sizeof (BudgieMenuWindowPrivate);
	return budgie_menu_window_type_id;
}

static void
_vala_budgie_menu_window_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	BudgieMenuWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_BUDGIE_MENU_WINDOW, BudgieMenuWindow);
	switch (property_id) {
		case BUDGIE_MENU_WINDOW_SETTINGS_PROPERTY:
		g_value_set_object (value, budgie_menu_window_get_settings (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_budgie_menu_window_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec)
{
	BudgieMenuWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_BUDGIE_MENU_WINDOW, BudgieMenuWindow);
	switch (property_id) {
		case BUDGIE_MENU_WINDOW_SETTINGS_PROPERTY:
		budgie_menu_window_set_settings (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

