/* TasklistApplet.c generated by valac 0.56.2, the Vala compiler
 * generated from TasklistApplet.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright © 2015-2022 Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <glib.h>
#include "tasklistapplet.h"
#include <stdlib.h>
#include <string.h>
#include "plugin.h"
#include <glib-object.h>
#include <gtk/gtk.h>
#include <libwnck/libwnck.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <libpeas/peas.h>

#define icon_size 32

enum  {
	TASKLIST_PLUGIN_0_PROPERTY,
	TASKLIST_PLUGIN_NUM_PROPERTIES
};
static GParamSpec* tasklist_plugin_properties[TASKLIST_PLUGIN_NUM_PROPERTIES];
enum  {
	TASKLIST_APPLET_0_PROPERTY,
	TASKLIST_APPLET_NUM_PROPERTIES
};
static GParamSpec* tasklist_applet_properties[TASKLIST_APPLET_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _TasklistAppletPrivate {
	GtkScrolledWindow* scroller;
	WnckTasklist* tlist;
};

static gpointer tasklist_plugin_parent_class = NULL;
static BudgiePluginIface * tasklist_plugin_budgie_plugin_parent_iface = NULL;
static GType tasklist_plugin_type_id = 0;
static gint TasklistApplet_private_offset;
static gpointer tasklist_applet_parent_class = NULL;
static GType tasklist_applet_type_id = 0;

static BudgieApplet* tasklist_plugin_real_get_panel_widget (BudgiePlugin* base,
                                                     const gchar* uuid);
static gboolean tasklist_applet_real_scroll_event (GtkWidget* base,
                                            GdkEventScroll* event);
static void tasklist_applet_real_panel_position_changed (BudgieApplet* base,
                                                  BudgiePanelPosition position);
static void tasklist_applet_finalize (GObject * obj);

static BudgieApplet*
tasklist_plugin_real_get_panel_widget (BudgiePlugin* base,
                                       const gchar* uuid)
{
	TasklistPlugin * self;
	TasklistApplet* _tmp0_;
	BudgieApplet* result;
	self = (TasklistPlugin*) base;
	g_return_val_if_fail (uuid != NULL, NULL);
	_tmp0_ = tasklist_applet_new ();
	g_object_ref_sink (_tmp0_);
	result = (BudgieApplet*) _tmp0_;
	return result;
}

TasklistPlugin*
tasklist_plugin_construct (GType object_type)
{
	TasklistPlugin * self = NULL;
	self = (TasklistPlugin*) g_object_new (object_type, NULL);
	return self;
}

TasklistPlugin*
tasklist_plugin_new (void)
{
	return tasklist_plugin_construct (TYPE_TASKLIST_PLUGIN);
}

static void
tasklist_plugin_class_init (TasklistPluginClass * klass,
                            gpointer klass_data)
{
	tasklist_plugin_parent_class = g_type_class_peek_parent (klass);
}

static void
tasklist_plugin_budgie_plugin_interface_init (BudgiePluginIface * iface,
                                              gpointer iface_data)
{
	tasklist_plugin_budgie_plugin_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_panel_widget = (BudgieApplet* (*) (BudgiePlugin*, const gchar*)) tasklist_plugin_real_get_panel_widget;
}

static void
tasklist_plugin_instance_init (TasklistPlugin * self,
                               gpointer klass)
{
}

GType
tasklist_plugin_get_type (void)
{
	return tasklist_plugin_type_id;
}

GType
tasklist_plugin_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (TasklistPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tasklist_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TasklistPlugin), 0, (GInstanceInitFunc) tasklist_plugin_instance_init, NULL };
	static const GInterfaceInfo budgie_plugin_info = { (GInterfaceInitFunc) tasklist_plugin_budgie_plugin_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	tasklist_plugin_type_id = g_type_module_register_type (module, peas_extension_base_get_type (), "TasklistPlugin", &g_define_type_info, 0);
	g_type_module_add_interface (module, tasklist_plugin_type_id, budgie_plugin_get_type (), &budgie_plugin_info);
	return tasklist_plugin_type_id;
}

static inline gpointer
tasklist_applet_get_instance_private (TasklistApplet* self)
{
	return G_STRUCT_MEMBER_P (self, TasklistApplet_private_offset);
}

TasklistApplet*
tasklist_applet_construct (GType object_type)
{
	TasklistApplet * self = NULL;
	GtkScrolledWindow* _tmp0_;
	WnckTasklist* _tmp1_;
	GtkScrolledWindow* _tmp2_;
	GtkScrolledWindow* _tmp3_;
	GtkScrolledWindow* _tmp4_;
	GtkScrolledWindow* _tmp5_;
	GtkScrolledWindow* _tmp6_;
	GtkScrolledWindow* _tmp7_;
	WnckTasklist* _tmp8_;
	GtkScrolledWindow* _tmp9_;
	WnckTasklist* _tmp10_;
	GtkScrolledWindow* _tmp11_;
	WnckTasklist* _tmp12_;
	self = (TasklistApplet*) g_object_new (object_type, NULL);
	_tmp0_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->scroller);
	self->priv->scroller = _tmp0_;
	_tmp1_ = (WnckTasklist*) wnck_tasklist_new ();
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->tlist);
	self->priv->tlist = _tmp1_;
	_tmp2_ = self->priv->scroller;
	gtk_scrolled_window_set_overlay_scrolling (_tmp2_, TRUE);
	_tmp3_ = self->priv->scroller;
	gtk_scrolled_window_set_propagate_natural_height (_tmp3_, TRUE);
	_tmp4_ = self->priv->scroller;
	gtk_scrolled_window_set_propagate_natural_width (_tmp4_, TRUE);
	_tmp5_ = self->priv->scroller;
	gtk_scrolled_window_set_shadow_type (_tmp5_, GTK_SHADOW_NONE);
	_tmp6_ = self->priv->scroller;
	g_object_set (_tmp6_, "hscrollbar-policy", GTK_POLICY_EXTERNAL, NULL);
	_tmp7_ = self->priv->scroller;
	g_object_set (_tmp7_, "vscrollbar-policy", GTK_POLICY_NEVER, NULL);
	_tmp8_ = self->priv->tlist;
	wnck_tasklist_set_scroll_enabled (_tmp8_, FALSE);
	_tmp9_ = self->priv->scroller;
	_tmp10_ = self->priv->tlist;
	gtk_container_add ((GtkContainer*) _tmp9_, (GtkWidget*) _tmp10_);
	_tmp11_ = self->priv->scroller;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp11_);
	_tmp12_ = self->priv->tlist;
	wnck_tasklist_set_grouping (_tmp12_, WNCK_TASKLIST_AUTO_GROUP);
	gtk_widget_add_events ((GtkWidget*) self, (gint) GDK_SCROLL_MASK);
	gtk_widget_show_all ((GtkWidget*) self);
	return self;
}

TasklistApplet*
tasklist_applet_new (void)
{
	return tasklist_applet_construct (TYPE_TASKLIST_APPLET);
}

static gboolean
tasklist_applet_real_scroll_event (GtkWidget* base,
                                   GdkEventScroll* event)
{
	TasklistApplet * self;
	gboolean result;
	self = (TasklistApplet*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	if (event->direction == GDK_SCROLL_UP) {
		GtkScrolledWindow* _tmp0_;
		GtkAdjustment* _tmp1_;
		GtkAdjustment* _tmp2_;
		GtkScrolledWindow* _tmp3_;
		GtkAdjustment* _tmp4_;
		GtkAdjustment* _tmp5_;
		gdouble _tmp6_;
		gdouble _tmp7_;
		_tmp0_ = self->priv->scroller;
		_tmp1_ = gtk_scrolled_window_get_hadjustment (_tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = self->priv->scroller;
		_tmp4_ = gtk_scrolled_window_get_hadjustment (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = gtk_adjustment_get_value (_tmp5_);
		_tmp7_ = _tmp6_;
		gtk_adjustment_set_value (_tmp5_, _tmp7_ - 50);
	} else {
		GtkScrolledWindow* _tmp8_;
		GtkAdjustment* _tmp9_;
		GtkAdjustment* _tmp10_;
		GtkScrolledWindow* _tmp11_;
		GtkAdjustment* _tmp12_;
		GtkAdjustment* _tmp13_;
		gdouble _tmp14_;
		gdouble _tmp15_;
		_tmp8_ = self->priv->scroller;
		_tmp9_ = gtk_scrolled_window_get_hadjustment (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = self->priv->scroller;
		_tmp12_ = gtk_scrolled_window_get_hadjustment (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = gtk_adjustment_get_value (_tmp13_);
		_tmp15_ = _tmp14_;
		gtk_adjustment_set_value (_tmp13_, _tmp15_ + 50);
	}
	result = GDK_EVENT_STOP;
	return result;
}

/**
 * Update the tasklist orientation to match the panel direction
 */
static void
tasklist_applet_real_panel_position_changed (BudgieApplet* base,
                                             BudgiePanelPosition position)
{
	TasklistApplet * self;
	GtkOrientation orientation = 0;
	gboolean _tmp0_ = FALSE;
	WnckTasklist* _tmp1_;
	self = (TasklistApplet*) base;
	orientation = GTK_ORIENTATION_HORIZONTAL;
	if (position == BUDGIE_PANEL_POSITION_LEFT) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = position == BUDGIE_PANEL_POSITION_RIGHT;
	}
	if (_tmp0_) {
		orientation = GTK_ORIENTATION_VERTICAL;
	}
	_tmp1_ = self->priv->tlist;
	wnck_tasklist_set_orientation (_tmp1_, orientation);
}

static void
tasklist_applet_class_init (TasklistAppletClass * klass,
                            gpointer klass_data)
{
	tasklist_applet_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &TasklistApplet_private_offset);
	((GtkWidgetClass *) klass)->scroll_event = (gboolean (*) (GtkWidget*, GdkEventScroll*)) tasklist_applet_real_scroll_event;
	((BudgieAppletClass *) klass)->panel_position_changed = (void (*) (BudgieApplet*, BudgiePanelPosition)) tasklist_applet_real_panel_position_changed;
	G_OBJECT_CLASS (klass)->finalize = tasklist_applet_finalize;
}

static void
tasklist_applet_instance_init (TasklistApplet * self,
                               gpointer klass)
{
	self->priv = tasklist_applet_get_instance_private (self);
}

static void
tasklist_applet_finalize (GObject * obj)
{
	TasklistApplet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TASKLIST_APPLET, TasklistApplet);
	_g_object_unref0 (self->priv->scroller);
	_g_object_unref0 (self->priv->tlist);
	G_OBJECT_CLASS (tasklist_applet_parent_class)->finalize (obj);
}

GType
tasklist_applet_get_type (void)
{
	return tasklist_applet_type_id;
}

GType
tasklist_applet_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (TasklistAppletClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tasklist_applet_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TasklistApplet), 0, (GInstanceInitFunc) tasklist_applet_instance_init, NULL };
	tasklist_applet_type_id = g_type_module_register_type (module, budgie_applet_get_type (), "TasklistApplet", &g_define_type_info, 0);
	TasklistApplet_private_offset = sizeof (TasklistAppletPrivate);
	return tasklist_applet_type_id;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
peas_register_types (GTypeModule* module)
{
	PeasObjectModule* objmodule = NULL;
	PeasObjectModule* _tmp0_;
	g_return_if_fail (module != NULL);
	tasklist_plugin_register_type (module);
	tasklist_applet_register_type (module);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (module, peas_object_module_get_type ()) ? ((PeasObjectModule*) module) : NULL);
	objmodule = _tmp0_;
	peas_object_module_register_extension_type (objmodule, budgie_plugin_get_type (), TYPE_TASKLIST_PLUGIN);
	_g_object_unref0 (objmodule);
}

