/* UserIndicatorWindow.c generated by valac 0.56.2, the Vala compiler
 * generated from UserIndicatorWindow.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright © 2015-2022 Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include "userindicator.h"
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

#define TYPE_ACCOUNTS_INTERFACE (accounts_interface_get_type ())
#define ACCOUNTS_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNTS_INTERFACE, AccountsInterface))
#define IS_ACCOUNTS_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNTS_INTERFACE))
#define ACCOUNTS_INTERFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_ACCOUNTS_INTERFACE, AccountsInterfaceIface))

typedef struct _AccountsInterface AccountsInterface;
typedef struct _AccountsInterfaceIface AccountsInterfaceIface;

#define TYPE_ACCOUNTS_INTERFACE_PROXY (accounts_interface_proxy_get_type ())

#define TYPE_ACCOUNT_USER_INTERFACE (account_user_interface_get_type ())
#define ACCOUNT_USER_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT_USER_INTERFACE, AccountUserInterface))
#define IS_ACCOUNT_USER_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT_USER_INTERFACE))
#define ACCOUNT_USER_INTERFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_ACCOUNT_USER_INTERFACE, AccountUserInterfaceIface))

typedef struct _AccountUserInterface AccountUserInterface;
typedef struct _AccountUserInterfaceIface AccountUserInterfaceIface;

#define TYPE_ACCOUNT_USER_INTERFACE_PROXY (account_user_interface_proxy_get_type ())

#define TYPE_PROPERTIES_INTERFACE (properties_interface_get_type ())
#define PROPERTIES_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROPERTIES_INTERFACE, PropertiesInterface))
#define IS_PROPERTIES_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROPERTIES_INTERFACE))
#define PROPERTIES_INTERFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_PROPERTIES_INTERFACE, PropertiesInterfaceIface))

typedef struct _PropertiesInterface PropertiesInterface;
typedef struct _PropertiesInterfaceIface PropertiesInterfaceIface;

#define TYPE_PROPERTIES_INTERFACE_PROXY (properties_interface_proxy_get_type ())
enum  {
	USER_INDICATOR_WINDOW_0_PROPERTY,
	USER_INDICATOR_WINDOW_NUM_PROPERTIES
};
static GParamSpec* user_indicator_window_properties[USER_INDICATOR_WINDOW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _UserIndicatorWindowSetupDbusData UserIndicatorWindowSetupDbusData;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
enum  {
	INDICATOR_ITEM_0_PROPERTY,
	INDICATOR_ITEM_IMAGE_SOURCE_PROPERTY,
	INDICATOR_ITEM_LABEL_TEXT_PROPERTY,
	INDICATOR_ITEM_NUM_PROPERTIES
};
static GParamSpec* indicator_item_properties[INDICATOR_ITEM_NUM_PROPERTIES];

struct _AccountsInterfaceIface {
	GTypeInterface parent_iface;
	gchar* (*find_user_by_name) (AccountsInterface* self, const gchar* username, GError** error);
};

struct _AccountUserInterfaceIface {
	GTypeInterface parent_iface;
};

struct _PropertiesInterfaceIface {
	GTypeInterface parent_iface;
	GVariant* (*get) (PropertiesInterface* self, const gchar* interface, const gchar* property, GError** error);
};

struct _UserIndicatorWindowPrivate {
	ScreenSaver* saver;
	SessionManager* session;
	LogindInterface* logind_interface;
	AccountsInterface* user_manager;
	AccountUserInterface* current_user;
	gchar* current_username;
	PropertiesInterface* current_user_props;
	IndicatorItem* user_item;
	IndicatorItem* lock_menu;
	IndicatorItem* suspend_menu;
	IndicatorItem* hibernate_menu;
	IndicatorItem* reboot_menu;
	IndicatorItem* shutdown_menu;
	IndicatorItem* logout_menu;
};

struct _UserIndicatorWindowSetupDbusData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	UserIndicatorWindow* self;
	AccountsInterface* _tmp0_;
	AccountsInterface* _tmp1_;
	AccountsInterface* _tmp2_;
	gchar* uid;
	AccountsInterface* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	PropertiesInterface* _tmp6_;
	const gchar* _tmp7_;
	PropertiesInterface* _tmp8_;
	PropertiesInterface* _tmp9_;
	GError* e;
	GError* _tmp10_;
	const gchar* _tmp11_;
	AccountUserInterface* _tmp12_;
	const gchar* _tmp13_;
	AccountUserInterface* _tmp14_;
	AccountUserInterface* _tmp15_;
	AccountUserInterface* _tmp16_;
	GError* _vala1_e;
	GError* _tmp17_;
	const gchar* _tmp18_;
	GError* _vala2_e;
	GError* _tmp19_;
	const gchar* _tmp20_;
	LogindInterface* _tmp21_;
	LogindInterface* _tmp22_;
	LogindInterface* _tmp23_;
	GError* _vala3_e;
	GError* _tmp24_;
	const gchar* _tmp25_;
	ScreenSaver* _tmp26_;
	ScreenSaver* _tmp27_;
	ScreenSaver* _tmp28_;
	GError* _vala4_e;
	GError* _tmp29_;
	const gchar* _tmp30_;
	SessionManager* _tmp31_;
	SessionManager* _tmp32_;
	SessionManager* _tmp33_;
	GError* _vala5_e;
	GError* _tmp34_;
	const gchar* _tmp35_;
	GError* _inner_error0_;
};

struct _IndicatorItemPrivate {
	GtkBox* menu_item;
	GtkImage* arrow;
	GtkImage* button_image;
	GtkLabel* button_label;
	gchar* _image_source;
	gchar* _label_text;
};

static gint UserIndicatorWindow_private_offset;
static gpointer user_indicator_window_parent_class = NULL;
static GType user_indicator_window_type_id = 0;
static gint IndicatorItem_private_offset;
static gpointer indicator_item_parent_class = NULL;
static GType indicator_item_type_id = 0;

VALA_EXTERN GType accounts_interface_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void accounts_interface_proxy_register_dynamic_type (GTypeModule* module);
VALA_EXTERN guint accounts_interface_register_object (void* object,
                                          GDBusConnection* connection,
                                          const gchar* path,
                                          GError** error);
GType accounts_interface_register_type (GTypeModule * module);
VALA_EXTERN GType accounts_interface_get_type (void) G_GNUC_CONST ;
GType account_user_interface_register_type (GTypeModule * module);
VALA_EXTERN GType account_user_interface_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType account_user_interface_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void account_user_interface_proxy_register_dynamic_type (GTypeModule* module);
VALA_EXTERN guint account_user_interface_register_object (void* object,
                                              GDBusConnection* connection,
                                              const gchar* path,
                                              GError** error);
VALA_EXTERN GType properties_interface_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void properties_interface_proxy_register_dynamic_type (GTypeModule* module);
VALA_EXTERN guint properties_interface_register_object (void* object,
                                            GDBusConnection* connection,
                                            const gchar* path,
                                            GError** error);
GType properties_interface_register_type (GTypeModule * module);
VALA_EXTERN GType properties_interface_get_type (void) G_GNUC_CONST ;
static void user_indicator_window_setup_dbus_data_free (gpointer _data);
static void user_indicator_window_setup_dbus (UserIndicatorWindow* self,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_);
static void user_indicator_window_setup_dbus_finish (UserIndicatorWindow* self,
                                              GAsyncResult* _res_);
static gboolean user_indicator_window_setup_dbus_co (UserIndicatorWindowSetupDbusData* _data_);
static void user_indicator_window_setup_dbus_ready (GObject* source_object,
                                             GAsyncResult* _res_,
                                             gpointer _user_data_);
VALA_EXTERN gchar* accounts_interface_find_user_by_name (AccountsInterface* self,
                                             const gchar* username,
                                             GError** error);
static void user_indicator_window_update_userinfo (UserIndicatorWindow* self);
static void _user_indicator_window_update_userinfo_account_user_interface_changed (AccountUserInterface* _sender,
                                                                            gpointer self);
static GtkRevealer* user_indicator_window_create_usersection (UserIndicatorWindow* self);
static gboolean __lambda6_ (UserIndicatorWindow* self,
                     GdkEventButton* e);
static gboolean ___lambda6__gtk_widget_button_release_event (GtkWidget* _sender,
                                                      GdkEventButton* event,
                                                      gpointer self);
static gboolean __lambda7_ (UserIndicatorWindow* self,
                     GdkEventButton* e);
static void user_indicator_window_lock_screen (UserIndicatorWindow* self);
static gboolean ___lambda7__gtk_widget_button_release_event (GtkWidget* _sender,
                                                      GdkEventButton* event,
                                                      gpointer self);
static gboolean __lambda9_ (UserIndicatorWindow* self,
                     GdkEventButton* e);
static void user_indicator_window_suspend (UserIndicatorWindow* self);
static gboolean ___lambda9__gtk_widget_button_release_event (GtkWidget* _sender,
                                                      GdkEventButton* event,
                                                      gpointer self);
static gboolean __lambda11_ (UserIndicatorWindow* self,
                      GdkEventButton* e);
static void user_indicator_window_reboot (UserIndicatorWindow* self);
static gboolean ___lambda11__gtk_widget_button_release_event (GtkWidget* _sender,
                                                       GdkEventButton* event,
                                                       gpointer self);
static gboolean __lambda13_ (UserIndicatorWindow* self,
                      GdkEventButton* e);
static void user_indicator_window_hibernate (UserIndicatorWindow* self);
static gboolean ___lambda13__gtk_widget_button_release_event (GtkWidget* _sender,
                                                       GdkEventButton* event,
                                                       gpointer self);
static gboolean __lambda15_ (UserIndicatorWindow* self,
                      GdkEventButton* e);
static void user_indicator_window_shutdown (UserIndicatorWindow* self);
static gboolean ___lambda15__gtk_widget_button_release_event (GtkWidget* _sender,
                                                       GdkEventButton* event,
                                                       gpointer self);
static void user_indicator_window_hide_usersection (UserIndicatorWindow* self);
static void _user_indicator_window_hide_usersection_gtk_widget_unmap (GtkWidget* _sender,
                                                               gpointer self);
static void user_indicator_window_real_hide (GtkWidget* base);
static gboolean __lambda4_ (UserIndicatorWindow* self,
                     GdkEventButton* e);
static void user_indicator_window_logout (UserIndicatorWindow* self);
static gboolean ___lambda4__gtk_widget_button_release_event (GtkWidget* _sender,
                                                      GdkEventButton* event,
                                                      gpointer self);
static void user_indicator_window_show_usersection (UserIndicatorWindow* self);
static gchar* user_indicator_window_get_user_image (UserIndicatorWindow* self);
static gchar* user_indicator_window_get_user_name (UserIndicatorWindow* self);
VALA_EXTERN GVariant* properties_interface_get (PropertiesInterface* self,
                                    const gchar* interface,
                                    const gchar* property,
                                    GError** error);
static gboolean __lambda5_ (UserIndicatorWindow* self);
static gboolean ___lambda5__gsource_func (gpointer self);
static gboolean __lambda14_ (UserIndicatorWindow* self);
static gboolean ___lambda14__gsource_func (gpointer self);
static gboolean __lambda12_ (UserIndicatorWindow* self);
static gboolean ___lambda12__gsource_func (gpointer self);
static gboolean __lambda16_ (UserIndicatorWindow* self);
static gboolean ___lambda16__gsource_func (gpointer self);
static gboolean __lambda10_ (UserIndicatorWindow* self);
static gboolean ___lambda10__gsource_func (gpointer self);
static gboolean __lambda8_ (UserIndicatorWindow* self);
static gboolean ___lambda8__gsource_func (gpointer self);
static void user_indicator_window_finalize (GObject * obj);
static void indicator_item_finalize (GObject * obj);
static void _vala_indicator_item_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec);
static void _vala_indicator_item_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
user_indicator_window_get_instance_private (UserIndicatorWindow* self)
{
	return G_STRUCT_MEMBER_P (self, UserIndicatorWindow_private_offset);
}

static void
user_indicator_window_setup_dbus_data_free (gpointer _data)
{
	UserIndicatorWindowSetupDbusData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (UserIndicatorWindowSetupDbusData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
user_indicator_window_setup_dbus (UserIndicatorWindow* self,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_)
{
	UserIndicatorWindowSetupDbusData* _data_;
	UserIndicatorWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (UserIndicatorWindowSetupDbusData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, user_indicator_window_setup_dbus_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	user_indicator_window_setup_dbus_co (_data_);
}

static void
user_indicator_window_setup_dbus_finish (UserIndicatorWindow* self,
                                         GAsyncResult* _res_)
{
	UserIndicatorWindowSetupDbusData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
user_indicator_window_setup_dbus_ready (GObject* source_object,
                                        GAsyncResult* _res_,
                                        gpointer _user_data_)
{
	UserIndicatorWindowSetupDbusData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	user_indicator_window_setup_dbus_co (_data_);
}

static void
_user_indicator_window_update_userinfo_account_user_interface_changed (AccountUserInterface* _sender,
                                                                       gpointer self)
{
	user_indicator_window_update_userinfo ((UserIndicatorWindow*) self);
}

static gboolean
user_indicator_window_setup_dbus_co (UserIndicatorWindowSetupDbusData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		case 5:
		goto _state_5;
		case 6:
		goto _state_6;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_state_ = 1;
		g_async_initable_new_async (TYPE_ACCOUNTS_INTERFACE_PROXY, 0, NULL, user_indicator_window_setup_dbus_ready, _data_, "g-flags", 0, "g-name", ACCOUNTSSERVICE_ACC, "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", "/org/freedesktop/Accounts", "g-interface-name", "org.freedesktop.Accounts", NULL);
		return FALSE;
		_state_1:
		_data_->_tmp1_ = (AccountsInterface*) g_async_initable_new_finish ((GAsyncInitable *) _data_->_source_object_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp0_ = (AccountsInterface*) _data_->_tmp1_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp2_ = _data_->_tmp0_;
		_data_->_tmp0_ = NULL;
		_g_object_unref0 (_data_->self->priv->user_manager);
		_data_->self->priv->user_manager = _data_->_tmp2_;
		_data_->_tmp3_ = _data_->self->priv->user_manager;
		_data_->_tmp4_ = _data_->self->priv->current_username;
		_data_->_tmp5_ = accounts_interface_find_user_by_name (_data_->_tmp3_, _data_->_tmp4_, &_data_->_inner_error0_);
		_data_->uid = _data_->_tmp5_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->_tmp0_);
			goto __catch0_g_error;
		}
		{
			_data_->_tmp7_ = _data_->uid;
			_data_->_state_ = 2;
			g_async_initable_new_async (TYPE_PROPERTIES_INTERFACE_PROXY, 0, NULL, user_indicator_window_setup_dbus_ready, _data_, "g-flags", 0, "g-name", ACCOUNTSSERVICE_ACC, "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", _data_->_tmp7_, "g-interface-name", "org.freedesktop.DBus.Properties", NULL);
			return FALSE;
			_state_2:
			_data_->_tmp8_ = (PropertiesInterface*) g_async_initable_new_finish ((GAsyncInitable *) _data_->_source_object_, _data_->_res_, &_data_->_inner_error0_);
			_data_->_tmp6_ = (PropertiesInterface*) _data_->_tmp8_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
			_data_->_tmp9_ = _data_->_tmp6_;
			_data_->_tmp6_ = NULL;
			_g_object_unref0 (_data_->self->priv->current_user_props);
			_data_->self->priv->current_user_props = _data_->_tmp9_;
			user_indicator_window_update_userinfo (_data_->self);
			_g_object_unref0 (_data_->_tmp6_);
		}
		goto __finally1;
		__catch1_g_error:
		{
			_data_->e = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp10_ = _data_->e;
			_data_->_tmp11_ = _data_->_tmp10_->message;
			g_warning (UNABLE_CONTACT "Account User Service: %s", _data_->_tmp11_);
			_g_error_free0 (_data_->e);
		}
		__finally1:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_free0 (_data_->uid);
			_g_object_unref0 (_data_->_tmp0_);
			goto __catch0_g_error;
		}
		{
			_data_->_tmp13_ = _data_->uid;
			_data_->_state_ = 3;
			g_async_initable_new_async (TYPE_ACCOUNT_USER_INTERFACE_PROXY, 0, NULL, user_indicator_window_setup_dbus_ready, _data_, "g-flags", 0, "g-name", ACCOUNTSSERVICE_ACC, "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", _data_->_tmp13_, "g-interface-name", "org.freedesktop.Accounts.User", NULL);
			return FALSE;
			_state_3:
			_data_->_tmp14_ = (AccountUserInterface*) g_async_initable_new_finish ((GAsyncInitable *) _data_->_source_object_, _data_->_res_, &_data_->_inner_error0_);
			_data_->_tmp12_ = (AccountUserInterface*) _data_->_tmp14_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch2_g_error;
			}
			_data_->_tmp15_ = _data_->_tmp12_;
			_data_->_tmp12_ = NULL;
			_g_object_unref0 (_data_->self->priv->current_user);
			_data_->self->priv->current_user = _data_->_tmp15_;
			_data_->_tmp16_ = _data_->self->priv->current_user;
			g_signal_connect_object (_data_->_tmp16_, "changed", (GCallback) _user_indicator_window_update_userinfo_account_user_interface_changed, _data_->self, 0);
			_g_object_unref0 (_data_->_tmp12_);
		}
		goto __finally2;
		__catch2_g_error:
		{
			_data_->_vala1_e = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp17_ = _data_->_vala1_e;
			_data_->_tmp18_ = _data_->_tmp17_->message;
			g_warning (UNABLE_CONTACT "Account User Service: %s", _data_->_tmp18_);
			_g_error_free0 (_data_->_vala1_e);
		}
		__finally2:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_free0 (_data_->uid);
			_g_object_unref0 (_data_->_tmp0_);
			goto __catch0_g_error;
		}
		_g_free0 (_data_->uid);
		_g_object_unref0 (_data_->_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->_vala2_e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp19_ = _data_->_vala2_e;
		_data_->_tmp20_ = _data_->_tmp19_->message;
		g_warning (UNABLE_CONTACT "Accounts Service: %s", _data_->_tmp20_);
		_g_error_free0 (_data_->_vala2_e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_state_ = 4;
		g_async_initable_new_async (TYPE_LOGIND_INTERFACE_PROXY, 0, NULL, user_indicator_window_setup_dbus_ready, _data_, "g-flags", 0, "g-name", LOGIND_LOGIN, "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", "/org/freedesktop/login1", "g-interface-name", "org.freedesktop.login1.Manager", NULL);
		return FALSE;
		_state_4:
		_data_->_tmp22_ = (LogindInterface*) g_async_initable_new_finish ((GAsyncInitable *) _data_->_source_object_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp21_ = (LogindInterface*) _data_->_tmp22_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch3_g_error;
		}
		_data_->_tmp23_ = _data_->_tmp21_;
		_data_->_tmp21_ = NULL;
		_g_object_unref0 (_data_->self->priv->logind_interface);
		_data_->self->priv->logind_interface = _data_->_tmp23_;
		_g_object_unref0 (_data_->_tmp21_);
	}
	goto __finally3;
	__catch3_g_error:
	{
		_data_->_vala3_e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp24_ = _data_->_vala3_e;
		_data_->_tmp25_ = _data_->_tmp24_->message;
		g_warning (UNABLE_CONTACT "logind: %s", _data_->_tmp25_);
		_g_error_free0 (_data_->_vala3_e);
	}
	__finally3:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_state_ = 5;
		g_async_initable_new_async (TYPE_SCREEN_SAVER_PROXY, 0, NULL, user_indicator_window_setup_dbus_ready, _data_, "g-flags", 0, "g-name", "org.gnome.ScreenSaver", "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/org/gnome/ScreenSaver", "g-interface-name", "org.gnome.ScreenSaver", NULL);
		return FALSE;
		_state_5:
		_data_->_tmp27_ = (ScreenSaver*) g_async_initable_new_finish ((GAsyncInitable *) _data_->_source_object_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp26_ = (ScreenSaver*) _data_->_tmp27_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch4_g_error;
		}
		_data_->_tmp28_ = _data_->_tmp26_;
		_data_->_tmp26_ = NULL;
		_g_object_unref0 (_data_->self->priv->saver);
		_data_->self->priv->saver = _data_->_tmp28_;
		_g_object_unref0 (_data_->_tmp26_);
	}
	goto __finally4;
	__catch4_g_error:
	{
		_data_->_vala4_e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp29_ = _data_->_vala4_e;
		_data_->_tmp30_ = _data_->_tmp29_->message;
		g_warning (UNABLE_CONTACT "budgie-screensaver: %s", _data_->_tmp30_);
		_g_error_free0 (_data_->_vala4_e);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally4:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_state_ = 6;
		g_async_initable_new_async (TYPE_SESSION_MANAGER_PROXY, 0, NULL, user_indicator_window_setup_dbus_ready, _data_, "g-flags", 0, "g-name", G_SESSION, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/org/gnome/SessionManager", "g-interface-name", "org.gnome.SessionManager", NULL);
		return FALSE;
		_state_6:
		_data_->_tmp32_ = (SessionManager*) g_async_initable_new_finish ((GAsyncInitable *) _data_->_source_object_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp31_ = (SessionManager*) _data_->_tmp32_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch5_g_error;
		}
		_data_->_tmp33_ = _data_->_tmp31_;
		_data_->_tmp31_ = NULL;
		_g_object_unref0 (_data_->self->priv->session);
		_data_->self->priv->session = _data_->_tmp33_;
		_g_object_unref0 (_data_->_tmp31_);
	}
	goto __finally5;
	__catch5_g_error:
	{
		_data_->_vala5_e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp34_ = _data_->_vala5_e;
		_data_->_tmp35_ = _data_->_tmp34_->message;
		g_warning (UNABLE_CONTACT "GNOME Session: %s", _data_->_tmp35_);
		_g_error_free0 (_data_->_vala5_e);
	}
	__finally5:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gboolean
__lambda6_ (UserIndicatorWindow* self,
            GdkEventButton* e)
{
	gboolean result;
	g_return_val_if_fail (e != NULL, FALSE);
	if (e->button != ((guint) 1)) {
		result = GDK_EVENT_PROPAGATE;
		return result;
	}
	user_indicator_window_toggle_usersection (self);
	result = GDK_EVENT_STOP;
	return result;
}

static gboolean
___lambda6__gtk_widget_button_release_event (GtkWidget* _sender,
                                             GdkEventButton* event,
                                             gpointer self)
{
	gboolean result;
	result = __lambda6_ ((UserIndicatorWindow*) self, event);
	return result;
}

static gboolean
__lambda7_ (UserIndicatorWindow* self,
            GdkEventButton* e)
{
	gboolean result;
	g_return_val_if_fail (e != NULL, FALSE);
	if (e->button != ((guint) 1)) {
		result = GDK_EVENT_PROPAGATE;
		return result;
	}
	user_indicator_window_lock_screen (self);
	result = GDK_EVENT_STOP;
	return result;
}

static gboolean
___lambda7__gtk_widget_button_release_event (GtkWidget* _sender,
                                             GdkEventButton* event,
                                             gpointer self)
{
	gboolean result;
	result = __lambda7_ ((UserIndicatorWindow*) self, event);
	return result;
}

static gboolean
__lambda9_ (UserIndicatorWindow* self,
            GdkEventButton* e)
{
	gboolean result;
	g_return_val_if_fail (e != NULL, FALSE);
	if (e->button != ((guint) 1)) {
		result = GDK_EVENT_PROPAGATE;
		return result;
	}
	user_indicator_window_suspend (self);
	result = GDK_EVENT_STOP;
	return result;
}

static gboolean
___lambda9__gtk_widget_button_release_event (GtkWidget* _sender,
                                             GdkEventButton* event,
                                             gpointer self)
{
	gboolean result;
	result = __lambda9_ ((UserIndicatorWindow*) self, event);
	return result;
}

static gboolean
__lambda11_ (UserIndicatorWindow* self,
             GdkEventButton* e)
{
	gboolean result;
	g_return_val_if_fail (e != NULL, FALSE);
	if (e->button != ((guint) 1)) {
		result = GDK_EVENT_PROPAGATE;
		return result;
	}
	user_indicator_window_reboot (self);
	result = GDK_EVENT_STOP;
	return result;
}

static gboolean
___lambda11__gtk_widget_button_release_event (GtkWidget* _sender,
                                              GdkEventButton* event,
                                              gpointer self)
{
	gboolean result;
	result = __lambda11_ ((UserIndicatorWindow*) self, event);
	return result;
}

static gboolean
__lambda13_ (UserIndicatorWindow* self,
             GdkEventButton* e)
{
	gboolean result;
	g_return_val_if_fail (e != NULL, FALSE);
	if (e->button != ((guint) 1)) {
		result = GDK_EVENT_PROPAGATE;
		return result;
	}
	user_indicator_window_hibernate (self);
	result = GDK_EVENT_STOP;
	return result;
}

static gboolean
___lambda13__gtk_widget_button_release_event (GtkWidget* _sender,
                                              GdkEventButton* event,
                                              gpointer self)
{
	gboolean result;
	result = __lambda13_ ((UserIndicatorWindow*) self, event);
	return result;
}

static gboolean
__lambda15_ (UserIndicatorWindow* self,
             GdkEventButton* e)
{
	gboolean result;
	g_return_val_if_fail (e != NULL, FALSE);
	if (e->button != ((guint) 1)) {
		result = GDK_EVENT_PROPAGATE;
		return result;
	}
	user_indicator_window_shutdown (self);
	result = GDK_EVENT_STOP;
	return result;
}

static gboolean
___lambda15__gtk_widget_button_release_event (GtkWidget* _sender,
                                              GdkEventButton* event,
                                              gpointer self)
{
	gboolean result;
	result = __lambda15_ ((UserIndicatorWindow*) self, event);
	return result;
}

static void
_user_indicator_window_hide_usersection_gtk_widget_unmap (GtkWidget* _sender,
                                                          gpointer self)
{
	user_indicator_window_hide_usersection ((UserIndicatorWindow*) self);
}

UserIndicatorWindow*
user_indicator_window_construct (GType object_type,
                                 GtkWidget* window_parent)
{
	UserIndicatorWindow * self = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GtkBox* _tmp2_;
	GtkListBox* items = NULL;
	GtkListBox* _tmp3_;
	GtkStyleContext* _tmp4_;
	GtkStyleContext* _tmp5_;
	gboolean _tmp6_;
	IndicatorItem* _tmp7_;
	GtkRevealer* _tmp8_;
	GtkSeparator* separator = NULL;
	GtkSeparator* _tmp9_;
	gboolean _tmp10_;
	IndicatorItem* _tmp11_;
	gboolean _tmp12_;
	IndicatorItem* _tmp13_;
	gboolean _tmp14_;
	IndicatorItem* _tmp15_;
	gboolean _tmp16_;
	IndicatorItem* _tmp17_;
	gboolean _tmp18_;
	IndicatorItem* _tmp19_;
	IndicatorItem* _tmp20_;
	GtkRevealer* _tmp21_;
	IndicatorItem* _tmp22_;
	IndicatorItem* _tmp23_;
	IndicatorItem* _tmp24_;
	IndicatorItem* _tmp25_;
	IndicatorItem* _tmp26_;
	GtkBox* _tmp27_;
	GtkBox* _tmp28_;
	IndicatorItem* _tmp29_;
	IndicatorItem* _tmp30_;
	IndicatorItem* _tmp31_;
	IndicatorItem* _tmp32_;
	IndicatorItem* _tmp33_;
	IndicatorItem* _tmp34_;
	self = (UserIndicatorWindow*) g_object_new (object_type, "relative-to", window_parent, NULL);
	_tmp0_ = g_get_user_name ();
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->current_username);
	self->priv->current_username = _tmp1_;
	user_indicator_window_setup_dbus (self, NULL, NULL);
	_tmp2_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->menu);
	self->menu = _tmp2_;
	_tmp3_ = (GtkListBox*) gtk_list_box_new ();
	g_object_ref_sink (_tmp3_);
	items = _tmp3_;
	_tmp4_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp4_, "user-menu");
	_tmp5_ = gtk_widget_get_style_context ((GtkWidget*) items);
	gtk_style_context_add_class (_tmp5_, "content-box");
	gtk_list_box_set_selection_mode (items, GTK_SELECTION_NONE);
	_tmp6_ = TRUE;
	_tmp7_ = indicator_item_new (_ ("User"), USER_SYMBOLIC_ICON, &_tmp6_);
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->user_item);
	self->priv->user_item = _tmp7_;
	_tmp8_ = user_indicator_window_create_usersection (self);
	_g_object_unref0 (self->user_section);
	self->user_section = _tmp8_;
	_tmp9_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
	g_object_ref_sink (_tmp9_);
	separator = _tmp9_;
	_tmp10_ = FALSE;
	_tmp11_ = indicator_item_new (_ ("Lock"), "system-lock-screen-symbolic", &_tmp10_);
	g_object_ref_sink (_tmp11_);
	_g_object_unref0 (self->priv->lock_menu);
	self->priv->lock_menu = _tmp11_;
	_tmp12_ = FALSE;
	_tmp13_ = indicator_item_new (_ ("Suspend"), "system-suspend-symbolic", &_tmp12_);
	g_object_ref_sink (_tmp13_);
	_g_object_unref0 (self->priv->suspend_menu);
	self->priv->suspend_menu = _tmp13_;
	_tmp14_ = FALSE;
	_tmp15_ = indicator_item_new (_ ("Hibernate"), "system-hibernate-symbolic", &_tmp14_);
	g_object_ref_sink (_tmp15_);
	_g_object_unref0 (self->priv->hibernate_menu);
	self->priv->hibernate_menu = _tmp15_;
	_tmp16_ = FALSE;
	_tmp17_ = indicator_item_new (_ ("Restart"), "system-restart-symbolic", &_tmp16_);
	g_object_ref_sink (_tmp17_);
	_g_object_unref0 (self->priv->reboot_menu);
	self->priv->reboot_menu = _tmp17_;
	_tmp18_ = FALSE;
	_tmp19_ = indicator_item_new (_ ("Shutdown"), "system-shutdown-symbolic", &_tmp18_);
	g_object_ref_sink (_tmp19_);
	_g_object_unref0 (self->priv->shutdown_menu);
	self->priv->shutdown_menu = _tmp19_;
	_tmp20_ = self->priv->user_item;
	gtk_container_add ((GtkContainer*) items, (GtkWidget*) _tmp20_);
	_tmp21_ = self->user_section;
	gtk_container_add ((GtkContainer*) items, (GtkWidget*) _tmp21_);
	gtk_container_add ((GtkContainer*) items, (GtkWidget*) separator);
	_tmp22_ = self->priv->lock_menu;
	gtk_container_add ((GtkContainer*) items, (GtkWidget*) _tmp22_);
	_tmp23_ = self->priv->suspend_menu;
	gtk_container_add ((GtkContainer*) items, (GtkWidget*) _tmp23_);
	_tmp24_ = self->priv->hibernate_menu;
	gtk_container_add ((GtkContainer*) items, (GtkWidget*) _tmp24_);
	_tmp25_ = self->priv->reboot_menu;
	gtk_container_add ((GtkContainer*) items, (GtkWidget*) _tmp25_);
	_tmp26_ = self->priv->shutdown_menu;
	gtk_container_add ((GtkContainer*) items, (GtkWidget*) _tmp26_);
	_tmp27_ = self->menu;
	gtk_box_pack_start (_tmp27_, (GtkWidget*) items, FALSE, FALSE, (guint) 0);
	_tmp28_ = self->menu;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp28_);
	gtk_widget_set_size_request ((GtkWidget*) self, 250, 0);
	_tmp29_ = self->priv->user_item;
	g_signal_connect_object ((GtkWidget*) _tmp29_, "button-release-event", (GCallback) ___lambda6__gtk_widget_button_release_event, self, 0);
	_tmp30_ = self->priv->lock_menu;
	g_signal_connect_object ((GtkWidget*) _tmp30_, "button-release-event", (GCallback) ___lambda7__gtk_widget_button_release_event, self, 0);
	_tmp31_ = self->priv->suspend_menu;
	g_signal_connect_object ((GtkWidget*) _tmp31_, "button-release-event", (GCallback) ___lambda9__gtk_widget_button_release_event, self, 0);
	_tmp32_ = self->priv->reboot_menu;
	g_signal_connect_object ((GtkWidget*) _tmp32_, "button-release-event", (GCallback) ___lambda11__gtk_widget_button_release_event, self, 0);
	_tmp33_ = self->priv->hibernate_menu;
	g_signal_connect_object ((GtkWidget*) _tmp33_, "button-release-event", (GCallback) ___lambda13__gtk_widget_button_release_event, self, 0);
	_tmp34_ = self->priv->shutdown_menu;
	g_signal_connect_object ((GtkWidget*) _tmp34_, "button-release-event", (GCallback) ___lambda15__gtk_widget_button_release_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "unmap", (GCallback) _user_indicator_window_hide_usersection_gtk_widget_unmap, self, 0);
	_g_object_unref0 (separator);
	_g_object_unref0 (items);
	return self;
}

UserIndicatorWindow*
user_indicator_window_new (GtkWidget* window_parent)
{
	return user_indicator_window_construct (TYPE_USER_INDICATOR_WINDOW, window_parent);
}

static void
user_indicator_window_real_hide (GtkWidget* base)
{
	UserIndicatorWindow * self;
	GtkButton** buttons = NULL;
	IndicatorItem* _tmp0_;
	GtkButton* _tmp1_;
	IndicatorItem* _tmp2_;
	GtkButton* _tmp3_;
	IndicatorItem* _tmp4_;
	GtkButton* _tmp5_;
	IndicatorItem* _tmp6_;
	GtkButton* _tmp7_;
	IndicatorItem* _tmp8_;
	GtkButton* _tmp9_;
	IndicatorItem* _tmp10_;
	GtkButton* _tmp11_;
	IndicatorItem* _tmp12_;
	GtkButton* _tmp13_;
	GtkButton** _tmp14_;
	gint buttons_length1;
	gint _buttons_size_;
	self = (UserIndicatorWindow*) base;
	_tmp0_ = self->priv->user_item;
	_tmp1_ = _g_object_ref0 ((GtkButton*) _tmp0_);
	_tmp2_ = self->priv->logout_menu;
	_tmp3_ = _g_object_ref0 ((GtkButton*) _tmp2_);
	_tmp4_ = self->priv->lock_menu;
	_tmp5_ = _g_object_ref0 ((GtkButton*) _tmp4_);
	_tmp6_ = self->priv->suspend_menu;
	_tmp7_ = _g_object_ref0 ((GtkButton*) _tmp6_);
	_tmp8_ = self->priv->reboot_menu;
	_tmp9_ = _g_object_ref0 ((GtkButton*) _tmp8_);
	_tmp10_ = self->priv->hibernate_menu;
	_tmp11_ = _g_object_ref0 ((GtkButton*) _tmp10_);
	_tmp12_ = self->priv->shutdown_menu;
	_tmp13_ = _g_object_ref0 ((GtkButton*) _tmp12_);
	_tmp14_ = g_new0 (GtkButton*, 7 + 1);
	_tmp14_[0] = _tmp1_;
	_tmp14_[1] = _tmp3_;
	_tmp14_[2] = _tmp5_;
	_tmp14_[3] = _tmp7_;
	_tmp14_[4] = _tmp9_;
	_tmp14_[5] = _tmp11_;
	_tmp14_[6] = _tmp13_;
	buttons = _tmp14_;
	buttons_length1 = 7;
	_buttons_size_ = buttons_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp15_ = FALSE;
			_tmp15_ = TRUE;
			while (TRUE) {
				GtkButton** _tmp17_;
				gint _tmp17__length1;
				GtkButton* button = NULL;
				GtkButton** _tmp18_;
				gint _tmp18__length1;
				GtkButton* _tmp19_;
				GtkButton* _tmp20_;
				GtkButton* _tmp21_;
				GtkButton* _tmp22_;
				GtkButton* _tmp23_;
				if (!_tmp15_) {
					gint _tmp16_;
					_tmp16_ = i;
					i = _tmp16_ + 1;
				}
				_tmp15_ = FALSE;
				_tmp17_ = buttons;
				_tmp17__length1 = buttons_length1;
				if (!(i < _tmp17__length1)) {
					break;
				}
				_tmp18_ = buttons;
				_tmp18__length1 = buttons_length1;
				_tmp19_ = _tmp18_[0];
				_tmp20_ = _g_object_ref0 (_tmp19_);
				button = _tmp20_;
				_tmp21_ = button;
				if (_tmp21_ == NULL) {
					_g_object_unref0 (button);
					continue;
				}
				_tmp22_ = button;
				g_object_set ((GtkWidget*) _tmp22_, "has-focus", FALSE, NULL);
				_tmp23_ = button;
				g_object_set ((GtkWidget*) _tmp23_, "is-focus", FALSE, NULL);
				_g_object_unref0 (button);
			}
		}
	}
	GTK_WIDGET_CLASS (user_indicator_window_parent_class)->hide ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, budgie_popover_get_type (), BudgiePopover));
	buttons = (_vala_array_free (buttons, buttons_length1, (GDestroyNotify) g_object_unref), NULL);
}

static gboolean
__lambda4_ (UserIndicatorWindow* self,
            GdkEventButton* e)
{
	gboolean result;
	g_return_val_if_fail (e != NULL, FALSE);
	if (e->button != ((guint) 1)) {
		result = GDK_EVENT_PROPAGATE;
		return result;
	}
	user_indicator_window_logout (self);
	result = GDK_EVENT_STOP;
	return result;
}

static gboolean
___lambda4__gtk_widget_button_release_event (GtkWidget* _sender,
                                             GdkEventButton* event,
                                             gpointer self)
{
	gboolean result;
	result = __lambda4_ ((UserIndicatorWindow*) self, event);
	return result;
}

static GtkRevealer*
user_indicator_window_create_usersection (UserIndicatorWindow* self)
{
	GtkRevealer* user_section = NULL;
	GtkRevealer* _tmp0_;
	GtkBox* user_section_box = NULL;
	GtkBox* _tmp1_;
	gboolean _tmp2_;
	IndicatorItem* _tmp3_;
	IndicatorItem* _tmp4_;
	IndicatorItem* _tmp5_;
	GtkRevealer* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GtkRevealer*) gtk_revealer_new ();
	g_object_ref_sink (_tmp0_);
	user_section = _tmp0_;
	_tmp1_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp1_);
	user_section_box = _tmp1_;
	_tmp2_ = FALSE;
	_tmp3_ = indicator_item_new (_ ("Logout"), "system-log-out-symbolic", &_tmp2_);
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->logout_menu);
	self->priv->logout_menu = _tmp3_;
	_tmp4_ = self->priv->logout_menu;
	gtk_box_pack_start (user_section_box, (GtkWidget*) _tmp4_, FALSE, FALSE, (guint) 0);
	gtk_container_add ((GtkContainer*) user_section, (GtkWidget*) user_section_box);
	_tmp5_ = self->priv->logout_menu;
	g_signal_connect_object ((GtkWidget*) _tmp5_, "button-release-event", (GCallback) ___lambda4__gtk_widget_button_release_event, self, 0);
	result = user_section;
	_g_object_unref0 (user_section_box);
	return result;
}

void
user_indicator_window_toggle_usersection (UserIndicatorWindow* self)
{
	GtkRevealer* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->user_section;
	if (_tmp0_ != NULL) {
		GtkRevealer* _tmp1_;
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp1_ = self->user_section;
		_tmp2_ = gtk_revealer_get_child_revealed (_tmp1_);
		_tmp3_ = _tmp2_;
		if (!_tmp3_) {
			user_indicator_window_show_usersection (self);
		} else {
			user_indicator_window_hide_usersection (self);
		}
	}
}

static void
user_indicator_window_show_usersection (UserIndicatorWindow* self)
{
	GtkRevealer* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->user_section;
	_tmp1_ = gtk_revealer_get_child_revealed (_tmp0_);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		GtkRevealer* _tmp3_;
		GtkRevealer* _tmp4_;
		IndicatorItem* _tmp5_;
		_tmp3_ = self->user_section;
		gtk_revealer_set_transition_type (_tmp3_, GTK_REVEALER_TRANSITION_TYPE_SLIDE_DOWN);
		_tmp4_ = self->user_section;
		gtk_revealer_set_reveal_child (_tmp4_, TRUE);
		_tmp5_ = self->priv->user_item;
		indicator_item_set_arrow (_tmp5_, "up");
	}
}

static void
user_indicator_window_hide_usersection (UserIndicatorWindow* self)
{
	GtkRevealer* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->user_section;
	_tmp1_ = gtk_revealer_get_child_revealed (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GtkRevealer* _tmp3_;
		GtkRevealer* _tmp4_;
		IndicatorItem* _tmp5_;
		_tmp3_ = self->user_section;
		gtk_revealer_set_transition_type (_tmp3_, GTK_REVEALER_TRANSITION_TYPE_SLIDE_UP);
		_tmp4_ = self->user_section;
		gtk_revealer_set_reveal_child (_tmp4_, FALSE);
		_tmp5_ = self->priv->user_item;
		indicator_item_set_arrow (_tmp5_, "down");
	}
}

static void
user_indicator_window_update_userinfo (UserIndicatorWindow* self)
{
	gchar* user_image = NULL;
	gchar* _tmp0_;
	gchar* user_name = NULL;
	gchar* _tmp1_;
	IndicatorItem* _tmp2_;
	IndicatorItem* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = user_indicator_window_get_user_image (self);
	user_image = _tmp0_;
	_tmp1_ = user_indicator_window_get_user_name (self);
	user_name = _tmp1_;
	_tmp2_ = self->priv->user_item;
	indicator_item_set_image (_tmp2_, user_image);
	_tmp3_ = self->priv->user_item;
	indicator_item_set_label (_tmp3_, user_name);
	_g_free0 (user_name);
	_g_free0 (user_image);
}

static gchar*
user_indicator_window_get_user_image (UserIndicatorWindow* self)
{
	gchar* image = NULL;
	gchar* _tmp0_;
	PropertiesInterface* _tmp1_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (USER_SYMBOLIC_ICON);
	image = _tmp0_;
	_tmp1_ = self->priv->current_user_props;
	if (_tmp1_ != NULL) {
		{
			GVariant* _tmp2_ = NULL;
			PropertiesInterface* _tmp3_;
			GVariant* _tmp4_;
			gchar* icon_file = NULL;
			const gchar* _tmp5_;
			gchar* _tmp6_;
			const gchar* _tmp7_ = NULL;
			const gchar* _tmp8_;
			gchar* _tmp11_;
			_tmp3_ = self->priv->current_user_props;
			_tmp4_ = properties_interface_get (_tmp3_, ACCOUNTSSERVICE_USER, "IconFile", &_inner_error0_);
			_tmp2_ = _tmp4_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp5_ = g_variant_get_string (_tmp2_, NULL);
			_tmp6_ = g_strdup (_tmp5_);
			icon_file = _tmp6_;
			_tmp8_ = icon_file;
			if (g_strcmp0 (_tmp8_, "") != 0) {
				const gchar* _tmp9_;
				_tmp9_ = icon_file;
				_tmp7_ = _tmp9_;
			} else {
				const gchar* _tmp10_;
				_tmp10_ = image;
				_tmp7_ = _tmp10_;
			}
			_tmp11_ = g_strdup (_tmp7_);
			_g_free0 (image);
			image = _tmp11_;
			_g_free0 (icon_file);
			_g_variant_unref0 (_tmp2_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp12_;
			const gchar* _tmp13_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp12_ = e;
			_tmp13_ = _tmp12_->message;
			g_warning ("UserIndicatorWindow.vala:271: Failed to fetch IconFile: %s", _tmp13_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (image);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	result = image;
	return result;
}

static gchar*
user_indicator_window_get_user_name (UserIndicatorWindow* self)
{
	gchar* user_name = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	PropertiesInterface* _tmp2_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->current_username;
	_tmp1_ = g_strdup (_tmp0_);
	user_name = _tmp1_;
	_tmp2_ = self->priv->current_user_props;
	if (_tmp2_ != NULL) {
		{
			GVariant* _tmp3_ = NULL;
			PropertiesInterface* _tmp4_;
			GVariant* _tmp5_;
			gchar* real_name = NULL;
			const gchar* _tmp6_;
			gchar* _tmp7_;
			const gchar* _tmp8_ = NULL;
			const gchar* _tmp9_;
			gchar* _tmp12_;
			_tmp4_ = self->priv->current_user_props;
			_tmp5_ = properties_interface_get (_tmp4_, ACCOUNTSSERVICE_USER, "RealName", &_inner_error0_);
			_tmp3_ = _tmp5_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp6_ = g_variant_get_string (_tmp3_, NULL);
			_tmp7_ = g_strdup (_tmp6_);
			real_name = _tmp7_;
			_tmp9_ = real_name;
			if (g_strcmp0 (_tmp9_, "") != 0) {
				const gchar* _tmp10_;
				_tmp10_ = real_name;
				_tmp8_ = _tmp10_;
			} else {
				const gchar* _tmp11_;
				_tmp11_ = user_name;
				_tmp8_ = _tmp11_;
			}
			_tmp12_ = g_strdup (_tmp8_);
			_g_free0 (user_name);
			user_name = _tmp12_;
			_g_free0 (real_name);
			_g_variant_unref0 (_tmp3_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp13_;
			const gchar* _tmp14_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp13_ = e;
			_tmp14_ = _tmp13_->message;
			g_warning ("UserIndicatorWindow.vala:287: Failed to fetch RealName: %s", _tmp14_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (user_name);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	result = user_name;
	return result;
}

static gboolean
__lambda5_ (UserIndicatorWindow* self)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	{
		SessionManager* _tmp0_;
		_tmp0_ = self->priv->session;
		session_manager_Logout (_tmp0_, (guint) 0, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("UserIndicatorWindow.vala:304: Failed to logout: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp3_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp3_;
	}
	result = FALSE;
	return result;
}

static gboolean
___lambda5__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda5_ ((UserIndicatorWindow*) self);
	return result;
}

static void
user_indicator_window_logout (UserIndicatorWindow* self)
{
	SessionManager* _tmp0_;
	g_return_if_fail (self != NULL);
	gtk_widget_hide ((GtkWidget*) self);
	_tmp0_ = self->priv->session;
	if (_tmp0_ == NULL) {
		return;
	}
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda5__gsource_func, g_object_ref (self), g_object_unref);
}

static gboolean
__lambda14_ (UserIndicatorWindow* self)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	{
		LogindInterface* _tmp0_;
		user_indicator_window_lock_screen (self);
		_tmp0_ = self->priv->logind_interface;
		logind_interface_hibernate (_tmp0_, FALSE, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("UserIndicatorWindow.vala:321: Cannot hibernate: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp3_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp3_;
	}
	result = FALSE;
	return result;
}

static gboolean
___lambda14__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda14_ ((UserIndicatorWindow*) self);
	return result;
}

static void
user_indicator_window_hibernate (UserIndicatorWindow* self)
{
	LogindInterface* _tmp0_;
	g_return_if_fail (self != NULL);
	gtk_widget_hide ((GtkWidget*) self);
	_tmp0_ = self->priv->logind_interface;
	if (_tmp0_ == NULL) {
		return;
	}
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda14__gsource_func, g_object_ref (self), g_object_unref);
}

static gboolean
__lambda12_ (UserIndicatorWindow* self)
{
	SessionManager* _tmp0_;
	gboolean result;
	_tmp0_ = self->priv->session;
	session_manager_Reboot (_tmp0_, NULL, NULL);
	result = FALSE;
	return result;
}

static gboolean
___lambda12__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda12_ ((UserIndicatorWindow*) self);
	return result;
}

static void
user_indicator_window_reboot (UserIndicatorWindow* self)
{
	SessionManager* _tmp0_;
	g_return_if_fail (self != NULL);
	gtk_widget_hide ((GtkWidget*) self);
	_tmp0_ = self->priv->session;
	if (_tmp0_ == NULL) {
		return;
	}
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda12__gsource_func, g_object_ref (self), g_object_unref);
}

static gboolean
__lambda16_ (UserIndicatorWindow* self)
{
	SessionManager* _tmp0_;
	gboolean result;
	_tmp0_ = self->priv->session;
	session_manager_Shutdown (_tmp0_, NULL, NULL);
	result = FALSE;
	return result;
}

static gboolean
___lambda16__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda16_ ((UserIndicatorWindow*) self);
	return result;
}

static void
user_indicator_window_shutdown (UserIndicatorWindow* self)
{
	SessionManager* _tmp0_;
	g_return_if_fail (self != NULL);
	gtk_widget_hide ((GtkWidget*) self);
	_tmp0_ = self->priv->session;
	if (_tmp0_ == NULL) {
		return;
	}
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda16__gsource_func, g_object_ref (self), g_object_unref);
}

static gboolean
__lambda10_ (UserIndicatorWindow* self)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	{
		LogindInterface* _tmp0_;
		user_indicator_window_lock_screen (self);
		_tmp0_ = self->priv->logind_interface;
		logind_interface_suspend (_tmp0_, FALSE, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("UserIndicatorWindow.vala:362: Cannot suspend: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp3_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp3_;
	}
	result = FALSE;
	return result;
}

static gboolean
___lambda10__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda10_ ((UserIndicatorWindow*) self);
	return result;
}

static void
user_indicator_window_suspend (UserIndicatorWindow* self)
{
	LogindInterface* _tmp0_;
	g_return_if_fail (self != NULL);
	gtk_widget_hide ((GtkWidget*) self);
	_tmp0_ = self->priv->logind_interface;
	if (_tmp0_ == NULL) {
		return;
	}
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda10__gsource_func, g_object_ref (self), g_object_unref);
}

static gboolean
__lambda8_ (UserIndicatorWindow* self)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	{
		ScreenSaver* _tmp0_;
		_tmp0_ = self->priv->saver;
		screen_saver_lock (_tmp0_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("UserIndicatorWindow.vala:379: Cannot lock screen: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp3_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp3_;
	}
	result = FALSE;
	return result;
}

static gboolean
___lambda8__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda8_ ((UserIndicatorWindow*) self);
	return result;
}

static void
user_indicator_window_lock_screen (UserIndicatorWindow* self)
{
	g_return_if_fail (self != NULL);
	gtk_widget_hide ((GtkWidget*) self);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda8__gsource_func, g_object_ref (self), g_object_unref);
}

static void
user_indicator_window_class_init (UserIndicatorWindowClass * klass,
                                  gpointer klass_data)
{
	user_indicator_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &UserIndicatorWindow_private_offset);
	((GtkWidgetClass *) klass)->hide = (void (*) (GtkWidget*)) user_indicator_window_real_hide;
	G_OBJECT_CLASS (klass)->finalize = user_indicator_window_finalize;
}

static void
user_indicator_window_instance_init (UserIndicatorWindow * self,
                                     gpointer klass)
{
	self->priv = user_indicator_window_get_instance_private (self);
	self->menu = NULL;
	self->user_section = NULL;
	self->priv->saver = NULL;
	self->priv->session = NULL;
	self->priv->logind_interface = NULL;
	self->priv->user_manager = NULL;
	self->priv->current_user = NULL;
	self->priv->current_username = NULL;
	self->priv->current_user_props = NULL;
	self->priv->user_item = NULL;
	self->priv->lock_menu = NULL;
	self->priv->suspend_menu = NULL;
	self->priv->hibernate_menu = NULL;
	self->priv->reboot_menu = NULL;
	self->priv->shutdown_menu = NULL;
	self->priv->logout_menu = NULL;
}

static void
user_indicator_window_finalize (GObject * obj)
{
	UserIndicatorWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_USER_INDICATOR_WINDOW, UserIndicatorWindow);
	_g_object_unref0 (self->menu);
	_g_object_unref0 (self->user_section);
	_g_object_unref0 (self->priv->saver);
	_g_object_unref0 (self->priv->session);
	_g_object_unref0 (self->priv->logind_interface);
	_g_object_unref0 (self->priv->user_manager);
	_g_object_unref0 (self->priv->current_user);
	_g_free0 (self->priv->current_username);
	_g_object_unref0 (self->priv->current_user_props);
	_g_object_unref0 (self->priv->user_item);
	_g_object_unref0 (self->priv->lock_menu);
	_g_object_unref0 (self->priv->suspend_menu);
	_g_object_unref0 (self->priv->hibernate_menu);
	_g_object_unref0 (self->priv->reboot_menu);
	_g_object_unref0 (self->priv->shutdown_menu);
	_g_object_unref0 (self->priv->logout_menu);
	G_OBJECT_CLASS (user_indicator_window_parent_class)->finalize (obj);
}

GType
user_indicator_window_get_type (void)
{
	return user_indicator_window_type_id;
}

GType
user_indicator_window_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (UserIndicatorWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) user_indicator_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UserIndicatorWindow), 0, (GInstanceInitFunc) user_indicator_window_instance_init, NULL };
	user_indicator_window_type_id = g_type_module_register_type (module, budgie_popover_get_type (), "UserIndicatorWindow", &g_define_type_info, 0);
	UserIndicatorWindow_private_offset = sizeof (UserIndicatorWindowPrivate);
	return user_indicator_window_type_id;
}

static inline gpointer
indicator_item_get_instance_private (IndicatorItem* self)
{
	return G_STRUCT_MEMBER_P (self, IndicatorItem_private_offset);
}

IndicatorItem*
indicator_item_construct (GType object_type,
                          const gchar* label_string,
                          const gchar* image_source,
                          gboolean* add_arrow)
{
	IndicatorItem * self = NULL;
	GtkBox* _tmp0_;
	GtkBox* _tmp1_;
	GtkImage* _tmp2_;
	GtkBox* _tmp3_;
	GtkLabel* _tmp4_;
	GtkBox* _tmp8_;
	GtkStyleContext* _tmp9_;
	GtkStyleContext* _tmp10_;
	GtkStyleContext* _tmp11_;
	g_return_val_if_fail (label_string != NULL, NULL);
	g_return_val_if_fail (image_source != NULL, NULL);
	self = (IndicatorItem*) g_object_new (object_type, NULL);
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 10);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->menu_item);
	self->priv->menu_item = _tmp0_;
	indicator_item_set_image (self, image_source);
	indicator_item_set_label (self, label_string);
	gtk_widget_set_can_focus ((GtkWidget*) self, FALSE);
	_tmp1_ = self->priv->menu_item;
	_tmp2_ = self->priv->button_image;
	gtk_box_pack_start (_tmp1_, (GtkWidget*) _tmp2_, FALSE, FALSE, (guint) 0);
	_tmp3_ = self->priv->menu_item;
	_tmp4_ = self->priv->button_label;
	gtk_box_pack_start (_tmp3_, (GtkWidget*) _tmp4_, FALSE, FALSE, (guint) 0);
	if (*add_arrow) {
		GtkImage* _tmp5_;
		GtkBox* _tmp6_;
		GtkImage* _tmp7_;
		_tmp5_ = (GtkImage*) gtk_image_new_from_icon_name ("pan-down-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
		g_object_ref_sink (_tmp5_);
		_g_object_unref0 (self->priv->arrow);
		self->priv->arrow = _tmp5_;
		_tmp6_ = self->priv->menu_item;
		_tmp7_ = self->priv->arrow;
		gtk_box_pack_end (_tmp6_, (GtkWidget*) _tmp7_, FALSE, FALSE, (guint) 0);
	}
	_tmp8_ = self->priv->menu_item;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp8_);
	_tmp9_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp9_, "indicator-item");
	_tmp10_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp10_, "flat");
	_tmp11_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp11_, "menuitem");
	return self;
}

IndicatorItem*
indicator_item_new (const gchar* label_string,
                    const gchar* image_source,
                    gboolean* add_arrow)
{
	return indicator_item_construct (TYPE_INDICATOR_ITEM, label_string, image_source, add_arrow);
}

void
indicator_item_set_arrow (IndicatorItem* self,
                          const gchar* direction)
{
	GtkImage* _tmp0_;
	GtkImage* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (direction != NULL);
	_tmp0_ = self->priv->arrow;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->arrow;
	_tmp2_ = g_strconcat ("pan-", direction, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat (_tmp3_, "-symbolic", NULL);
	_tmp5_ = _tmp4_;
	gtk_image_set_from_icon_name (_tmp1_, _tmp5_, (GtkIconSize) GTK_ICON_SIZE_MENU);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
}

void
indicator_item_set_image (IndicatorItem* self,
                          const gchar* source)
{
	GdkPixbuf* pixbuf = NULL;
	gboolean has_slash_prefix = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean is_user_image = FALSE;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GtkImage* _tmp3_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	pixbuf = NULL;
	has_slash_prefix = g_str_has_prefix (source, "/");
	if (has_slash_prefix) {
		_tmp0_ = !g_str_has_suffix (source, ".face");
	} else {
		_tmp0_ = FALSE;
	}
	is_user_image = _tmp0_;
	if (has_slash_prefix) {
		_tmp2_ = !is_user_image;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = USER_SYMBOLIC_ICON;
	} else {
		_tmp1_ = source;
	}
	source = _tmp1_;
	_tmp3_ = self->priv->button_image;
	if (_tmp3_ == NULL) {
		GtkImage* _tmp4_;
		_tmp4_ = (GtkImage*) gtk_image_new ();
		g_object_ref_sink (_tmp4_);
		_g_object_unref0 (self->priv->button_image);
		self->priv->button_image = _tmp4_;
	}
	if (is_user_image) {
		{
			GdkPixbuf* _tmp5_ = NULL;
			GdkPixbuf* _tmp6_;
			GdkPixbuf* _tmp7_;
			GtkImage* _tmp8_;
			GdkPixbuf* _tmp9_;
			_tmp6_ = gdk_pixbuf_new_from_file_at_size (source, 24, 24, &_inner_error0_);
			_tmp5_ = _tmp6_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp7_ = _tmp5_;
			_tmp5_ = NULL;
			_g_object_unref0 (pixbuf);
			pixbuf = _tmp7_;
			_tmp8_ = self->priv->button_image;
			_tmp9_ = pixbuf;
			gtk_image_set_from_pixbuf (_tmp8_, _tmp9_);
			_g_object_unref0 (_tmp5_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp10_;
			const gchar* _tmp11_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp10_ = e;
			_tmp11_ = _tmp10_->message;
			g_message ("UserIndicatorWindow.vala:459: File does not exist: %s", _tmp11_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (pixbuf);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	} else {
		GtkImage* _tmp12_;
		_tmp12_ = self->priv->button_image;
		gtk_image_set_from_icon_name (_tmp12_, source, (GtkIconSize) GTK_ICON_SIZE_SMALL_TOOLBAR);
	}
	_g_object_unref0 (pixbuf);
}

void
indicator_item_set_label (IndicatorItem* self,
                          const gchar* text)
{
	GtkLabel* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = self->priv->button_label;
	if (_tmp0_ == NULL) {
		GtkLabel* _tmp1_;
		GtkLabel* _tmp2_;
		_tmp1_ = (GtkLabel*) gtk_label_new (text);
		g_object_ref_sink (_tmp1_);
		_g_object_unref0 (self->priv->button_label);
		self->priv->button_label = _tmp1_;
		_tmp2_ = self->priv->button_label;
		gtk_label_set_use_markup (_tmp2_, TRUE);
	} else {
		GtkLabel* _tmp3_;
		_tmp3_ = self->priv->button_label;
		gtk_label_set_label (_tmp3_, text);
	}
}

const gchar*
indicator_item_get_image_source (IndicatorItem* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_image_source;
	result = _tmp0_;
	return result;
}

void
indicator_item_set_image_source (IndicatorItem* self,
                                 const gchar* value)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = indicator_item_get_image_source (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (self->priv->_image_source);
	self->priv->_image_source = _tmp2_;
	_tmp3_ = indicator_item_get_image_source (self);
	_tmp4_ = _tmp3_;
	indicator_item_set_image (self, _tmp4_);
	g_object_notify_by_pspec ((GObject *) self, indicator_item_properties[INDICATOR_ITEM_IMAGE_SOURCE_PROPERTY]);
}

const gchar*
indicator_item_get_label_text (IndicatorItem* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_label_text;
	result = _tmp0_;
	return result;
}

void
indicator_item_set_label_text (IndicatorItem* self,
                               const gchar* value)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = indicator_item_get_label_text (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (self->priv->_label_text);
	self->priv->_label_text = _tmp2_;
	_tmp3_ = indicator_item_get_label_text (self);
	_tmp4_ = _tmp3_;
	indicator_item_set_label (self, _tmp4_);
	g_object_notify_by_pspec ((GObject *) self, indicator_item_properties[INDICATOR_ITEM_LABEL_TEXT_PROPERTY]);
}

static void
indicator_item_class_init (IndicatorItemClass * klass,
                           gpointer klass_data)
{
	indicator_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &IndicatorItem_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_indicator_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_indicator_item_set_property;
	G_OBJECT_CLASS (klass)->finalize = indicator_item_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), INDICATOR_ITEM_IMAGE_SOURCE_PROPERTY, indicator_item_properties[INDICATOR_ITEM_IMAGE_SOURCE_PROPERTY] = g_param_spec_string ("image-source", "image-source", "image-source", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), INDICATOR_ITEM_LABEL_TEXT_PROPERTY, indicator_item_properties[INDICATOR_ITEM_LABEL_TEXT_PROPERTY] = g_param_spec_string ("label-text", "label-text", "label-text", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
indicator_item_instance_init (IndicatorItem * self,
                              gpointer klass)
{
	self->priv = indicator_item_get_instance_private (self);
	self->priv->menu_item = NULL;
	self->priv->arrow = NULL;
	self->priv->button_image = NULL;
	self->priv->button_label = NULL;
	self->priv->_image_source = NULL;
	self->priv->_label_text = NULL;
}

static void
indicator_item_finalize (GObject * obj)
{
	IndicatorItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_INDICATOR_ITEM, IndicatorItem);
	_g_object_unref0 (self->priv->menu_item);
	_g_object_unref0 (self->priv->arrow);
	_g_object_unref0 (self->priv->button_image);
	_g_object_unref0 (self->priv->button_label);
	_g_free0 (self->priv->_image_source);
	_g_free0 (self->priv->_label_text);
	G_OBJECT_CLASS (indicator_item_parent_class)->finalize (obj);
}

GType
indicator_item_get_type (void)
{
	return indicator_item_type_id;
}

GType
indicator_item_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (IndicatorItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) indicator_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (IndicatorItem), 0, (GInstanceInitFunc) indicator_item_instance_init, NULL };
	indicator_item_type_id = g_type_module_register_type (module, gtk_button_get_type (), "IndicatorItem", &g_define_type_info, 0);
	IndicatorItem_private_offset = sizeof (IndicatorItemPrivate);
	return indicator_item_type_id;
}

static void
_vala_indicator_item_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec)
{
	IndicatorItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_INDICATOR_ITEM, IndicatorItem);
	switch (property_id) {
		case INDICATOR_ITEM_IMAGE_SOURCE_PROPERTY:
		g_value_set_string (value, indicator_item_get_image_source (self));
		break;
		case INDICATOR_ITEM_LABEL_TEXT_PROPERTY:
		g_value_set_string (value, indicator_item_get_label_text (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_indicator_item_set_property (GObject * object,
                                   guint property_id,
                                   const GValue * value,
                                   GParamSpec * pspec)
{
	IndicatorItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_INDICATOR_ITEM, IndicatorItem);
	switch (property_id) {
		case INDICATOR_ITEM_IMAGE_SOURCE_PROPERTY:
		indicator_item_set_image_source (self, g_value_get_string (value));
		break;
		case INDICATOR_ITEM_LABEL_TEXT_PROPERTY:
		indicator_item_set_label_text (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

