/* panel.c generated by valac 0.56.2, the Vala compiler
 * generated from panel.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright © 2015-2022 Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include "budgie-private.h"
#include <gdk/gdk.h>
#include <gio/gio.h>
#include "plugin.h"
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <cairo-gobject.h>

#define BUDGIE_PANEL_KEY_SIZE "size"
#define BUDGIE_PANEL_KEY_POSITION "location"
#define BUDGIE_PANEL_KEY_TRANSPARENCY "transparency"
#define BUDGIE_PANEL_KEY_SHADOW "enable-shadow"
#define BUDGIE_PANEL_KEY_DOCK_MODE "dock-mode"
#define BUDGIE_PANEL_KEY_REGIONS "theme-regions"
#define BUDGIE_PANEL_KEY_APPLETS "applets"
#define BUDGIE_PANEL_KEY_AUTOHIDE "autohide"
#define BUDGIE_BUDGIE_MIGRATION_LEVEL 1
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define BUDGIE_TYPE_MAIN_PANEL (budgie_main_panel_get_type ())
#define BUDGIE_MAIN_PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_MAIN_PANEL, BudgieMainPanel))
#define BUDGIE_MAIN_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_MAIN_PANEL, BudgieMainPanelClass))
#define BUDGIE_IS_MAIN_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_MAIN_PANEL))
#define BUDGIE_IS_MAIN_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_MAIN_PANEL))
#define BUDGIE_MAIN_PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_MAIN_PANEL, BudgieMainPanelClass))

typedef struct _BudgieMainPanel BudgieMainPanel;
typedef struct _BudgieMainPanelClass BudgieMainPanelClass;
typedef struct _BudgieMainPanelPrivate BudgieMainPanelPrivate;
enum  {
	BUDGIE_MAIN_PANEL_0_PROPERTY,
	BUDGIE_MAIN_PANEL_NUM_PROPERTIES
};
static GParamSpec* budgie_main_panel_properties[BUDGIE_MAIN_PANEL_NUM_PROPERTIES];
typedef enum  {
	BUDGIE_PANEL_ANIMATION_NONE = 0,
	BUDGIE_PANEL_ANIMATION_SHOW,
	BUDGIE_PANEL_ANIMATION_HIDE
} BudgiePanelAnimation;

#define BUDGIE_TYPE_PANEL_ANIMATION (budgie_panel_animation_get_type ())

#define BUDGIE_TYPE_PANEL (budgie_panel_get_type ())
#define BUDGIE_PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_PANEL, BudgiePanel))
#define BUDGIE_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_PANEL, BudgiePanelClass))
#define BUDGIE_IS_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_PANEL))
#define BUDGIE_IS_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_PANEL))
#define BUDGIE_PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_PANEL, BudgiePanelClass))

typedef struct _BudgiePanel BudgiePanel;
typedef struct _BudgiePanelClass BudgiePanelClass;
typedef struct _BudgiePanelPrivate BudgiePanelPrivate;

#define BUDGIE_TYPE_PANEL_MANAGER (budgie_panel_manager_get_type ())
#define BUDGIE_PANEL_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_PANEL_MANAGER, BudgiePanelManager))
#define BUDGIE_PANEL_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_PANEL_MANAGER, BudgiePanelManagerClass))
#define BUDGIE_IS_PANEL_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_PANEL_MANAGER))
#define BUDGIE_IS_PANEL_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_PANEL_MANAGER))
#define BUDGIE_PANEL_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_PANEL_MANAGER, BudgiePanelManagerClass))

typedef struct _BudgiePanelManager BudgiePanelManager;
typedef struct _BudgiePanelManagerClass BudgiePanelManagerClass;
enum  {
	BUDGIE_PANEL_0_PROPERTY,
	BUDGIE_PANEL_SETTINGS_PROPERTY,
	BUDGIE_PANEL_NSCALE_PROPERTY,
	BUDGIE_PANEL_NUM_PROPERTIES
};
static GParamSpec* budgie_panel_properties[BUDGIE_PANEL_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _Block4Data Block4Data;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef enum  {
	UUID_UUID_FLAGS_LOWER_CASE = 1 << 0,
	UUID_UUID_FLAGS_UPPER_CASE = 1 << 1,
	UUID_UUID_FLAGS_DEFAULT_CASE = 1 << 2,
	UUID_UUID_FLAGS_RANDOM_TYPE = 1 << 3,
	UUID_UUID_FLAGS_DEFAULT_TYPE = 1 << 4,
	UUID_UUID_FLAGS_TIME_TYPE = 1 << 5,
	UUID_UUID_FLAGS_TIME_SAFE_TYPE = 1 << 6
} LibUUIDUUIDFlags;

#define UUID_TYPE_UUID_FLAGS (uuid_uuid_flags_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _cairo_region_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_region_destroy (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
enum  {
	BUDGIE_PANEL_PANEL_LOADED_SIGNAL,
	BUDGIE_PANEL_NUM_SIGNALS
};
static guint budgie_panel_signals[BUDGIE_PANEL_NUM_SIGNALS] = {0};

struct _BudgieMainPanel {
	GtkBox parent_instance;
	BudgieMainPanelPrivate * priv;
};

struct _BudgieMainPanelClass {
	GtkBoxClass parent_class;
};

struct _BudgiePanel {
	BudgieToplevel parent_instance;
	BudgiePanelPrivate * priv;
};

struct _BudgiePanelClass {
	BudgieToplevelClass parent_class;
};

struct _BudgiePanelPrivate {
	BudgieMainPanel* layout;
	GtkBox* main_layout;
	GdkRectangle orig_scr;
	GSettings* _settings;
	BudgiePanelManager* manager;
	BudgiePopoverManager* popover_manager;
	BudgieShadowBlock* shadow;
	GHashTable* pending;
	GHashTable* creating;
	GHashTable* applets;
	GHashTable* initial_config;
	GList* expected_uuids;
	GRecMutex __lock_expected_uuids;
	gint scale;
	GtkBox* start_box;
	GtkBox* center_box;
	GtkBox* end_box;
	gint* icon_sizes;
	gint icon_sizes_length1;
	gint _icon_sizes_size_;
	gint current_icon_size;
	gint current_small_icon_size;
	gboolean is_fully_loaded;
	gboolean need_migratory;
	GRecMutex __lock_need_migratory;
	gdouble render_scale;
	BudgiePanelAnimation animation;
	gboolean allow_animation;
	gboolean screen_occluded;
	gint old_width;
	gint old_height;
	gboolean initial_anim;
	BudgieAnimation* dock_animation;
	gboolean render_panel;
	guint update_dock_id;
	guint show_panel_id;
};

struct _Block4Data {
	int _ref_count_;
	BudgiePanel* self;
	BudgieAppletInfo* info;
	BudgiePanelAction action;
};

static gpointer budgie_main_panel_parent_class = NULL;
static gint BudgiePanel_private_offset;
static gpointer budgie_panel_parent_class = NULL;

VALA_EXTERN GType budgie_main_panel_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieMainPanel, g_object_unref)
VALA_EXTERN BudgieMainPanel* budgie_main_panel_new (void);
VALA_EXTERN BudgieMainPanel* budgie_main_panel_construct (GType object_type);
VALA_EXTERN void budgie_main_panel_set_transparent (BudgieMainPanel* self,
                                        gboolean transparent);
VALA_EXTERN void budgie_main_panel_set_dock_mode (BudgieMainPanel* self,
                                      gboolean dock_mode);
static GType budgie_main_panel_get_type_once (void);
VALA_EXTERN GType budgie_panel_animation_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType budgie_panel_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgiePanel, g_object_unref)
VALA_EXTERN GType budgie_panel_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgiePanelManager, g_object_unref)
static void _g_free0_ (gpointer var);
static inline void _g_list_free__g_free0_ (GList* self);
VALA_EXTERN gboolean budgie_panel_activate_action (BudgiePanel* self,
                                       gint remote_action);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static gboolean ____lambda4_ (Block4Data* _data4_);
static gboolean _____lambda4__gsource_func (gpointer self);
VALA_EXTERN void budgie_panel_update_geometry (BudgiePanel* self,
                                   GdkRectangle* screen,
                                   BudgiePanelPosition position,
                                   gint size);
VALA_EXTERN GSettings* budgie_panel_get_settings (BudgiePanel* self);
static void budgie_panel_update_positions (BudgiePanel* self);
static void budgie_panel_placement (BudgiePanel* self);
static void budgie_panel_update_sizes (BudgiePanel* self);
VALA_EXTERN void budgie_panel_update_transparency (BudgiePanel* self,
                                       BudgiePanelTransparency transparency);
VALA_EXTERN void budgie_panel_set_transparent (BudgiePanel* self,
                                   gboolean transparent);
VALA_EXTERN void budgie_panel_manager_check_windows (BudgiePanelManager* self);
static gboolean budgie_panel_update_dock_behavior (BudgiePanel* self);
VALA_EXTERN void budgie_panel_set_occluded (BudgiePanel* self,
                                gboolean occluded);
static GList* budgie_panel_real_get_applets (BudgieToplevel* base);
static void budgie_panel_initial_applet_placement (BudgiePanel* self,
                                            gboolean repar,
                                            gboolean repos);
static void budgie_panel_applet_reparent (BudgiePanel* self,
                                   BudgieAppletInfo* info);
static void budgie_panel_applet_reposition (BudgiePanel* self,
                                     BudgieAppletInfo* info);
static void budgie_panel_on_fully_loaded (BudgiePanel* self);
static gboolean budgie_panel_initial_animation (BudgiePanel* self);
static gboolean _budgie_panel_initial_animation_gsource_func (gpointer self);
static gboolean budgie_panel_add_migratory (BudgiePanel* self);
static gboolean _budgie_panel_add_migratory_gsource_func (gpointer self);
VALA_EXTERN BudgiePanel* budgie_panel_new (BudgiePanelManager* manager,
                               const gchar* uuid,
                               GSettings* settings);
VALA_EXTERN BudgiePanel* budgie_panel_construct (GType object_type,
                                     BudgiePanelManager* manager,
                                     const gchar* uuid,
                                     GSettings* settings);
static void _g_object_unref0_ (gpointer var);
VALA_EXTERN void budgie_panel_set_nscale (BudgiePanel* self,
                              gdouble value);
static void __lambda8_ (BudgiePanel* self);
static void ___lambda8__g_object_notify (GObject* _sender,
                                  GParamSpec* pspec,
                                  gpointer self);
static void __lambda9_ (BudgiePanel* self);
static void ___lambda9__g_object_notify (GObject* _sender,
                                  GParamSpec* pspec,
                                  gpointer self);
static void _g_hash_table_unref0_ (gpointer var);
static void _budgie_panel_on_fully_loaded_budgie_panel_panel_loaded (BudgiePanel* _sender,
                                                              gpointer self);
static void budgie_panel_update_dock_mode (BudgiePanel* self);
static void _budgie_panel_update_dock_mode_g_object_notify (GObject* _sender,
                                                     GParamSpec* pspec,
                                                     gpointer self);
static void budgie_panel_update_theme_regions (BudgiePanel* self);
static void _budgie_panel_update_theme_regions_g_object_notify (GObject* _sender,
                                                         GParamSpec* pspec,
                                                         gpointer self);
static void budgie_panel_do_size_allocate (BudgiePanel* self);
static void _budgie_panel_do_size_allocate_gtk_widget_size_allocate (GtkWidget* _sender,
                                                              GtkAllocation* allocation,
                                                              gpointer self);
static gboolean budgie_panel_on_enter_notify (BudgiePanel* self,
                                       GdkEventCrossing* cr);
static gboolean _budgie_panel_on_enter_notify_gtk_widget_enter_notify_event (GtkWidget* _sender,
                                                                      GdkEventCrossing* event,
                                                                      gpointer self);
static gboolean budgie_panel_on_leave_notify (BudgiePanel* self,
                                       GdkEventCrossing* cr);
static gboolean _budgie_panel_on_leave_notify_gtk_widget_leave_notify_event (GtkWidget* _sender,
                                                                      GdkEventCrossing* event,
                                                                      gpointer self);
static void budgie_panel_on_extension_loaded (BudgiePanel* self,
                                       const gchar* name);
static void _budgie_panel_on_extension_loaded_budgie_panel_manager_extension_loaded (BudgiePanelManager* _sender,
                                                                              const gchar* name,
                                                                              gpointer self);
static void budgie_panel_load_applets (BudgiePanel* self);
static void budgie_panel_update_screen_edge (BudgiePanel* self);
VALA_EXTERN void budgie_panel_destroy_children (BudgiePanel* self);
VALA_EXTERN void budgie_panel_manager_reset_dconf_path (BudgiePanelManager* self,
                                            GSettings* settings);
VALA_EXTERN BudgieAppletInfo* budgie_panel_manager_load_applet_instance (BudgiePanelManager* self,
                                                             const gchar* uuid,
                                                             gchar** name,
                                                             GSettings* psettings);
static void budgie_panel_add_applet (BudgiePanel* self,
                              BudgieAppletInfo* info);
VALA_EXTERN BudgieAppletInfo* budgie_panel_manager_create_new_applet (BudgiePanelManager* self,
                                                          const gchar* name,
                                                          const gchar* uuid);
static gint __lambda10_ (BudgieAppletInfo* a,
                  BudgieAppletInfo* b);
static gint ___lambda10__gcompare_func (gconstpointer a,
                                 gconstpointer b);
static BudgieAppletInfo* budgie_panel_add_pending (BudgiePanel* self,
                                            const gchar* uuid,
                                            const gchar* plugin_name);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void budgie_panel_add_new_applet_at (BudgiePanel* self,
                                     const gchar* id,
                                     GtkBox* target_region);
VALA_EXTERN GType uuid_uuid_flags_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gchar* uuid_new (LibUUIDUUIDFlags flags);
static void budgie_panel_add_new (BudgiePanel* self,
                           const gchar* plugin_name,
                           const gchar* initial_uuid);
static void budgie_panel_real_add_new_applet (BudgieToplevel* base,
                                       const gchar* id);
VALA_EXTERN void budgie_panel_create_default_layout (BudgiePanel* self,
                                         const gchar* name,
                                         GKeyFile* config);
static void budgie_panel_toggle_container_visibilities (BudgiePanel* self);
static void budgie_panel_set_applets (BudgiePanel* self);
static void _vala_array_add3 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void budgie_panel_real_remove_applet (BudgieToplevel* base,
                                      BudgieAppletInfo* info);
static void budgie_panel_budge_em_left (BudgiePanel* self,
                                 const gchar* alignment,
                                 gint after);
static void budgie_panel_applet_updated (BudgiePanel* self,
                                  GObject* o,
                                  GParamSpec* p);
static void _budgie_panel_applet_updated_g_object_notify (GObject* _sender,
                                                   GParamSpec* pspec,
                                                   gpointer self);
VALA_EXTERN gboolean budgie_panel_manager_is_extension_valid (BudgiePanelManager* self,
                                                  const gchar* name);
VALA_EXTERN gboolean budgie_panel_manager_is_extension_loaded (BudgiePanelManager* self,
                                                   const gchar* name);
VALA_EXTERN void budgie_panel_manager_modprobe (BudgiePanelManager* self,
                                    const gchar* name);
static void budgie_panel_real_map (GtkWidget* base);
VALA_EXTERN void budgie_panel_set_autohide_policy (BudgiePanel* self,
                                       BudgieAutohidePolicy policy);
static void budgie_panel_apply_strut_policy (BudgiePanel* self);
static void budgie_panel_set_input_region (BudgiePanel* self);
static gboolean budgie_panel_applet_at_start_of_region (BudgiePanel* self,
                                                 BudgieAppletInfo* info);
static gboolean budgie_panel_applet_at_end_of_region (BudgiePanel* self,
                                               BudgieAppletInfo* info);
static gchar* budgie_panel_get_box_left (BudgiePanel* self,
                                  BudgieAppletInfo* info);
static gchar* budgie_panel_get_box_right (BudgiePanel* self,
                                   BudgieAppletInfo* info);
static gboolean budgie_panel_real_can_move_applet_left (BudgieToplevel* base,
                                                 BudgieAppletInfo* info);
static gboolean budgie_panel_real_can_move_applet_right (BudgieToplevel* base,
                                                  BudgieAppletInfo* info);
static void budgie_panel_conflict_swap (BudgiePanel* self,
                                 BudgieAppletInfo* info,
                                 gint old_position);
static void budgie_panel_budge_em_right (BudgiePanel* self,
                                  const gchar* alignment,
                                  gint after);
static void budgie_panel_reinforce_positions (BudgiePanel* self);
static void budgie_panel_real_move_applet_left (BudgieToplevel* base,
                                         BudgieAppletInfo* info);
static void budgie_panel_real_move_applet_right (BudgieToplevel* base,
                                          BudgieAppletInfo* info);
static gboolean budgie_panel_show_panel (BudgiePanel* self);
static void budgie_panel_remove_panel_animations (BudgiePanel* self);
static gboolean budgie_panel_cursor_within_bounds (BudgiePanel* self);
VALA_EXTERN gdouble budgie_panel_get_nscale (BudgiePanel* self);
static void budgie_panel_hide_panel (BudgiePanel* self);
static void budgie_panel_unset_input_region (BudgiePanel* self);
static gboolean _budgie_panel_show_panel_gsource_func (gpointer self);
static gboolean _budgie_panel_update_dock_behavior_gsource_func (gpointer self);
static gdouble _budgie_expo_ease_out_budgie_tween_func (gdouble factor,
                                                 gpointer self);
static void _vala_BudgiePropChange_array_free (BudgiePropChange * array,
                                        gssize array_length);
static void __lambda5_ (BudgiePanel* self,
                 BudgieAnimation* a);
static void ___lambda5__budgie_anim_completion_func (BudgieAnimation* src,
                                              gpointer self);
static void __lambda6_ (BudgiePanel* self,
                 BudgieAnimation* a);
static void ___lambda6__budgie_anim_completion_func (BudgieAnimation* src,
                                              gpointer self);
static gboolean budgie_panel_real_draw (GtkWidget* base,
                                 cairo_t* cr);
VALA_EXTERN void budgie_panel_perform_migration (BudgiePanel* self,
                                     gint current_migration_level);
VALA_EXTERN void budgie_panel_set_settings (BudgiePanel* self,
                                GSettings* value);
static GObject * budgie_panel_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties);
static void budgie_panel_finalize (GObject * obj);
static GType budgie_panel_get_type_once (void);
static void _vala_budgie_panel_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec);
static void _vala_budgie_panel_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

VALA_EXTERN const gchar* BUDGIE_MIGRATION_1_APPLETS[2];

BudgieMainPanel*
budgie_main_panel_construct (GType object_type)
{
	BudgieMainPanel * self = NULL;
	GtkStyleContext* _tmp0_;
	GtkStyleContext* _tmp1_;
	self = (BudgieMainPanel*) g_object_new (object_type, "orientation", GTK_ORIENTATION_HORIZONTAL, NULL);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp0_, "budgie-panel");
	_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp1_, GTK_STYLE_CLASS_BACKGROUND);
	return self;
}

BudgieMainPanel*
budgie_main_panel_new (void)
{
	return budgie_main_panel_construct (BUDGIE_TYPE_MAIN_PANEL);
}

void
budgie_main_panel_set_transparent (BudgieMainPanel* self,
                                   gboolean transparent)
{
	g_return_if_fail (self != NULL);
	if (transparent) {
		GtkStyleContext* _tmp0_;
		_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
		gtk_style_context_add_class (_tmp0_, "transparent");
	} else {
		GtkStyleContext* _tmp1_;
		_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) self);
		gtk_style_context_remove_class (_tmp1_, "transparent");
	}
}

void
budgie_main_panel_set_dock_mode (BudgieMainPanel* self,
                                 gboolean dock_mode)
{
	g_return_if_fail (self != NULL);
	if (dock_mode) {
		GtkStyleContext* _tmp0_;
		_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
		gtk_style_context_add_class (_tmp0_, "dock-mode");
	} else {
		GtkStyleContext* _tmp1_;
		_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) self);
		gtk_style_context_remove_class (_tmp1_, "dock-mode");
	}
}

static void
budgie_main_panel_class_init (BudgieMainPanelClass * klass,
                              gpointer klass_data)
{
	budgie_main_panel_parent_class = g_type_class_peek_parent (klass);
}

static void
budgie_main_panel_instance_init (BudgieMainPanel * self,
                                 gpointer klass)
{
}

/**
* The main panel area - i.e. the bit that's rendered
*/
static GType
budgie_main_panel_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieMainPanelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_main_panel_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieMainPanel), 0, (GInstanceInitFunc) budgie_main_panel_instance_init, NULL };
	GType budgie_main_panel_type_id;
	budgie_main_panel_type_id = g_type_register_static (gtk_box_get_type (), "BudgieMainPanel", &g_define_type_info, 0);
	return budgie_main_panel_type_id;
}

GType
budgie_main_panel_get_type (void)
{
	static volatile gsize budgie_main_panel_type_id__once = 0;
	if (g_once_init_enter (&budgie_main_panel_type_id__once)) {
		GType budgie_main_panel_type_id;
		budgie_main_panel_type_id = budgie_main_panel_get_type_once ();
		g_once_init_leave (&budgie_main_panel_type_id__once, budgie_main_panel_type_id);
	}
	return budgie_main_panel_type_id__once;
}

/**
* This is used to track panel animations, i.e. within the toplevel
* itself to provide dock like behavior
*/
static GType
budgie_panel_animation_get_type_once (void)
{
	static const GEnumValue values[] = {{BUDGIE_PANEL_ANIMATION_NONE, "BUDGIE_PANEL_ANIMATION_NONE", "none"}, {BUDGIE_PANEL_ANIMATION_SHOW, "BUDGIE_PANEL_ANIMATION_SHOW", "show"}, {BUDGIE_PANEL_ANIMATION_HIDE, "BUDGIE_PANEL_ANIMATION_HIDE", "hide"}, {0, NULL, NULL}};
	GType budgie_panel_animation_type_id;
	budgie_panel_animation_type_id = g_enum_register_static ("BudgiePanelAnimation", values);
	return budgie_panel_animation_type_id;
}

GType
budgie_panel_animation_get_type (void)
{
	static volatile gsize budgie_panel_animation_type_id__once = 0;
	if (g_once_init_enter (&budgie_panel_animation_type_id__once)) {
		GType budgie_panel_animation_type_id;
		budgie_panel_animation_type_id = budgie_panel_animation_get_type_once ();
		g_once_init_leave (&budgie_panel_animation_type_id__once, budgie_panel_animation_type_id);
	}
	return budgie_panel_animation_type_id__once;
}

static inline gpointer
budgie_panel_get_instance_private (BudgiePanel* self)
{
	return G_STRUCT_MEMBER_P (self, BudgiePanel_private_offset);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static inline void
_g_list_free__g_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_free0_);
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		BudgiePanel* self;
		self = _data4_->self;
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static gboolean
____lambda4_ (Block4Data* _data4_)
{
	BudgiePanel* self;
	BudgieAppletInfo* _tmp0_;
	BudgieApplet* _tmp1_;
	BudgieApplet* _tmp2_;
	BudgieApplet* _tmp3_;
	gboolean result;
	self = _data4_->self;
	_tmp0_ = _data4_->info;
	g_object_get (_tmp0_, "applet", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	budgie_applet_invoke_action (_tmp3_, _data4_->action);
	_g_object_unref0 (_tmp3_);
	result = FALSE;
	return result;
}

static gboolean
_____lambda4__gsource_func (gpointer self)
{
	gboolean result;
	result = ____lambda4_ (self);
	return result;
}

gboolean
budgie_panel_activate_action (BudgiePanel* self,
                              gint remote_action)
{
	Block4Data* _data4_;
	const gchar* uuid = NULL;
	GHashTableIter iter = {0};
	GHashTable* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	uuid = NULL;
	_data4_->info = NULL;
	_data4_->action = (BudgiePanelAction) remote_action;
	_tmp0_ = self->priv->applets;
	g_hash_table_iter_init (&iter, _tmp0_);
	while (TRUE) {
		gconstpointer _tmp1_ = NULL;
		gconstpointer _tmp2_ = NULL;
		gboolean _tmp3_;
		BudgieAppletInfo* _tmp4_;
		BudgieApplet* _tmp5_;
		BudgieApplet* _tmp6_;
		BudgieApplet* _tmp7_;
		BudgiePanelAction _tmp8_;
		BudgiePanelAction _tmp9_;
		gboolean _tmp10_;
		_tmp3_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp1_), (gpointer*) (&_tmp2_));
		uuid = _tmp1_;
		_data4_->info = _tmp2_;
		if (!_tmp3_) {
			break;
		}
		_tmp4_ = _data4_->info;
		g_object_get (_tmp4_, "applet", &_tmp5_, NULL);
		_tmp6_ = _tmp5_;
		_tmp7_ = _tmp6_;
		g_object_get (_tmp7_, "supported-actions", &_tmp8_, NULL);
		_tmp9_ = _tmp8_;
		_tmp10_ = (_tmp9_ & _data4_->action) != 0;
		_g_object_unref0 (_tmp7_);
		if (_tmp10_) {
			gtk_window_present ((GtkWindow*) self);
			g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _____lambda4__gsource_func, block4_data_ref (_data4_), block4_data_unref);
			result = TRUE;
			block4_data_unref (_data4_);
			_data4_ = NULL;
			return result;
		}
	}
	result = FALSE;
	block4_data_unref (_data4_);
	_data4_ = NULL;
	return result;
}

/**
* Force update the geometry
*/
void
budgie_panel_update_geometry (BudgiePanel* self,
                              GdkRectangle* screen,
                              BudgiePanelPosition position,
                              gint size)
{
	GdkRectangle _tmp0_;
	gchar* old_class = NULL;
	BudgiePanelPosition _tmp1_;
	BudgiePanelPosition _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	GSettings* _tmp9_;
	GtkStyleContext* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	BudgiePanelPosition _tmp13_;
	BudgiePanelPosition _tmp14_;
	BudgieShadowBlock* _tmp16_;
	BudgieMainPanel* _tmp17_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (screen != NULL);
	_tmp0_ = *screen;
	self->priv->orig_scr = _tmp0_;
	_tmp1_ = budgie_toplevel_get_position ((BudgieToplevel*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = budgie_position_class_name (_tmp2_);
	old_class = _tmp3_;
	_tmp4_ = old_class;
	if (g_strcmp0 (_tmp4_, "") != 0) {
		GtkStyleContext* _tmp5_;
		const gchar* _tmp6_;
		_tmp5_ = gtk_widget_get_style_context ((GtkWidget*) self);
		_tmp6_ = old_class;
		gtk_style_context_remove_class (_tmp5_, _tmp6_);
	}
	if (size == 0) {
		gint _tmp7_;
		gint _tmp8_;
		_tmp7_ = budgie_toplevel_get_intended_size ((BudgieToplevel*) self);
		_tmp8_ = _tmp7_;
		size = _tmp8_;
	}
	_tmp9_ = self->priv->_settings;
	g_settings_set_int (_tmp9_, BUDGIE_PANEL_KEY_SIZE, size);
	budgie_toplevel_set_intended_size ((BudgieToplevel*) self, size);
	_tmp10_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp11_ = budgie_position_class_name (position);
	_tmp12_ = _tmp11_;
	gtk_style_context_add_class (_tmp10_, _tmp12_);
	_g_free0 (_tmp12_);
	_tmp13_ = budgie_toplevel_get_position ((BudgieToplevel*) self);
	_tmp14_ = _tmp13_;
	if (position != _tmp14_) {
		GSettings* _tmp15_;
		budgie_toplevel_set_position ((BudgieToplevel*) self, position);
		_tmp15_ = self->priv->_settings;
		g_settings_set_enum (_tmp15_, BUDGIE_PANEL_KEY_POSITION, (gint) position);
		budgie_panel_update_positions (self);
	}
	_tmp16_ = self->priv->shadow;
	budgie_shadow_block_set_position (_tmp16_, position);
	_tmp17_ = self->priv->layout;
	gtk_widget_queue_resize ((GtkWidget*) _tmp17_);
	gtk_widget_queue_resize ((GtkWidget*) self);
	gtk_widget_queue_draw ((GtkWidget*) self);
	budgie_panel_placement (self);
	budgie_panel_update_sizes (self);
	_g_free0 (old_class);
}

void
budgie_panel_update_transparency (BudgiePanel* self,
                                  BudgiePanelTransparency transparency)
{
	GSettings* _tmp1_;
	g_return_if_fail (self != NULL);
	budgie_toplevel_set_transparency ((BudgieToplevel*) self, transparency);
	switch (transparency) {
		case BUDGIE_PANEL_TRANSPARENCY_ALWAYS:
		{
			budgie_panel_set_transparent (self, TRUE);
			break;
		}
		case BUDGIE_PANEL_TRANSPARENCY_DYNAMIC:
		{
			BudgiePanelManager* _tmp0_;
			_tmp0_ = self->priv->manager;
			budgie_panel_manager_check_windows (_tmp0_);
			break;
		}
		default:
		{
			budgie_panel_set_transparent (self, FALSE);
			break;
		}
	}
	_tmp1_ = self->priv->_settings;
	g_settings_set_enum (_tmp1_, BUDGIE_PANEL_KEY_TRANSPARENCY, (gint) transparency);
}

void
budgie_panel_set_transparent (BudgiePanel* self,
                              gboolean transparent)
{
	BudgieMainPanel* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->layout;
	budgie_main_panel_set_transparent (_tmp0_, transparent);
	budgie_panel_update_dock_behavior (self);
}

/**
* Specific for docks, regardless of transparency, and determines
* how our "screen blocked by thingy" policy works.
*/
void
budgie_panel_set_occluded (BudgiePanel* self,
                           gboolean occluded)
{
	BudgieAutohidePolicy _tmp0_;
	BudgieAutohidePolicy _tmp1_;
	g_return_if_fail (self != NULL);
	self->priv->screen_occluded = occluded;
	_tmp0_ = budgie_toplevel_get_autohide ((BudgieToplevel*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == BUDGIE_AUTOHIDE_POLICY_NONE) {
		return;
	}
	budgie_panel_update_dock_behavior (self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GList*
budgie_panel_real_get_applets (BudgieToplevel* base)
{
	BudgiePanel * self;
	GList* ret = NULL;
	const gchar* key = NULL;
	BudgieAppletInfo* appl_info = NULL;
	GHashTableIter iter = {0};
	GHashTable* _tmp0_;
	GList* result;
	self = (BudgiePanel*) base;
	ret = NULL;
	key = NULL;
	appl_info = NULL;
	_tmp0_ = self->priv->applets;
	g_hash_table_iter_init (&iter, _tmp0_);
	while (TRUE) {
		gconstpointer _tmp1_ = NULL;
		gconstpointer _tmp2_ = NULL;
		gboolean _tmp3_;
		BudgieAppletInfo* _tmp4_;
		BudgieAppletInfo* _tmp5_;
		_tmp3_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp1_), (gpointer*) (&_tmp2_));
		key = _tmp1_;
		appl_info = _tmp2_;
		if (!_tmp3_) {
			break;
		}
		_tmp4_ = appl_info;
		_tmp5_ = _g_object_ref0 (_tmp4_);
		ret = g_list_append (ret, _tmp5_);
	}
	result = ret;
	return result;
}

/**
* Loop the applets, performing a reparent or reposition
*/
static void
budgie_panel_initial_applet_placement (BudgiePanel* self,
                                       gboolean repar,
                                       gboolean repos)
{
	gboolean _tmp0_ = FALSE;
	const gchar* uuid = NULL;
	BudgieAppletInfo* info = NULL;
	GHashTableIter iter = {0};
	GHashTable* _tmp1_;
	g_return_if_fail (self != NULL);
	if (!repar) {
		_tmp0_ = !repos;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	uuid = NULL;
	info = NULL;
	_tmp1_ = self->priv->applets;
	g_hash_table_iter_init (&iter, _tmp1_);
	while (TRUE) {
		gconstpointer _tmp2_ = NULL;
		gconstpointer _tmp3_ = NULL;
		gboolean _tmp4_;
		_tmp4_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp2_), (gpointer*) (&_tmp3_));
		uuid = _tmp2_;
		info = _tmp3_;
		if (!_tmp4_) {
			break;
		}
		if (repar) {
			BudgieAppletInfo* _tmp5_;
			_tmp5_ = info;
			budgie_panel_applet_reparent (self, _tmp5_);
		}
		if (repos) {
			BudgieAppletInfo* _tmp6_;
			_tmp6_ = info;
			budgie_panel_applet_reposition (self, _tmp6_);
		}
	}
}

static gboolean
_budgie_panel_initial_animation_gsource_func (gpointer self)
{
	gboolean result;
	result = budgie_panel_initial_animation ((BudgiePanel*) self);
	return result;
}

static gboolean
_budgie_panel_add_migratory_gsource_func (gpointer self)
{
	gboolean result;
	result = budgie_panel_add_migratory ((BudgiePanel*) self);
	return result;
}

static void
budgie_panel_on_fully_loaded (BudgiePanel* self)
{
	GHashTable* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->applets;
	if (g_hash_table_size (_tmp0_) < ((guint) 1)) {
		if (!self->priv->initial_anim) {
			g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _budgie_panel_initial_animation_gsource_func, g_object_ref (self), g_object_unref);
		}
		return;
	}
	budgie_panel_initial_applet_placement (self, TRUE, FALSE);
	budgie_panel_initial_applet_placement (self, FALSE, TRUE);
	g_signal_emit_by_name ((BudgieToplevel*) self, "applets-changed");
	if (!self->priv->initial_anim) {
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _budgie_panel_initial_animation_gsource_func, g_object_ref (self), g_object_unref);
	}
	{
		g_rec_mutex_lock (&self->priv->__lock_need_migratory);
		{
			if (!self->priv->need_migratory) {
				{
					g_rec_mutex_unlock (&self->priv->__lock_need_migratory);
				}
				return;
			}
		}
		__finally0:
		{
			g_rec_mutex_unlock (&self->priv->__lock_need_migratory);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 500, _budgie_panel_add_migratory_gsource_func, g_object_ref (self), g_object_unref);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static void
__lambda8_ (BudgiePanel* self)
{
	self->priv->scale = gtk_widget_get_scale_factor ((GtkWidget*) self);
	budgie_panel_placement (self);
}

static void
___lambda8__g_object_notify (GObject* _sender,
                             GParamSpec* pspec,
                             gpointer self)
{
	__lambda8_ ((BudgiePanel*) self);
}

static void
__lambda9_ (BudgiePanel* self)
{
	BudgieAutohidePolicy _tmp0_;
	BudgieAutohidePolicy _tmp1_;
	_tmp0_ = budgie_toplevel_get_autohide ((BudgieToplevel*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != BUDGIE_AUTOHIDE_POLICY_NONE) {
		budgie_panel_update_dock_behavior (self);
	}
}

static void
___lambda9__g_object_notify (GObject* _sender,
                             GParamSpec* pspec,
                             gpointer self)
{
	__lambda9_ ((BudgiePanel*) self);
}

static void
_g_hash_table_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL));
}

static void
_budgie_panel_on_fully_loaded_budgie_panel_panel_loaded (BudgiePanel* _sender,
                                                         gpointer self)
{
	budgie_panel_on_fully_loaded ((BudgiePanel*) self);
}

static void
_budgie_panel_update_dock_mode_g_object_notify (GObject* _sender,
                                                GParamSpec* pspec,
                                                gpointer self)
{
	budgie_panel_update_dock_mode ((BudgiePanel*) self);
}

static void
_budgie_panel_update_theme_regions_g_object_notify (GObject* _sender,
                                                    GParamSpec* pspec,
                                                    gpointer self)
{
	budgie_panel_update_theme_regions ((BudgiePanel*) self);
}

static void
_budgie_panel_do_size_allocate_gtk_widget_size_allocate (GtkWidget* _sender,
                                                         GtkAllocation* allocation,
                                                         gpointer self)
{
	budgie_panel_do_size_allocate ((BudgiePanel*) self);
}

static gboolean
_budgie_panel_on_enter_notify_gtk_widget_enter_notify_event (GtkWidget* _sender,
                                                             GdkEventCrossing* event,
                                                             gpointer self)
{
	gboolean result;
	result = budgie_panel_on_enter_notify ((BudgiePanel*) self, event);
	return result;
}

static gboolean
_budgie_panel_on_leave_notify_gtk_widget_leave_notify_event (GtkWidget* _sender,
                                                             GdkEventCrossing* event,
                                                             gpointer self)
{
	gboolean result;
	result = budgie_panel_on_leave_notify ((BudgiePanel*) self, event);
	return result;
}

static void
_budgie_panel_on_extension_loaded_budgie_panel_manager_extension_loaded (BudgiePanelManager* _sender,
                                                                         const gchar* name,
                                                                         gpointer self)
{
	budgie_panel_on_extension_loaded ((BudgiePanel*) self, name);
}

BudgiePanel*
budgie_panel_construct (GType object_type,
                        BudgiePanelManager* manager,
                        const gchar* uuid,
                        GSettings* settings)
{
	BudgiePanel * self = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	BudgiePopoverManager* _tmp3_;
	GHashFunc _tmp4_;
	GEqualFunc _tmp5_;
	GHashTable* _tmp6_;
	GHashFunc _tmp7_;
	GEqualFunc _tmp8_;
	GHashTable* _tmp9_;
	GHashFunc _tmp10_;
	GEqualFunc _tmp11_;
	GHashTable* _tmp12_;
	GdkVisual* vis = NULL;
	GdkScreen* _tmp13_;
	GdkScreen* _tmp14_;
	GdkVisual* _tmp15_;
	GdkVisual* _tmp16_;
	GdkVisual* _tmp17_;
	GtkStyleContext* _tmp19_;
	GtkBox* _tmp20_;
	GtkBox* _tmp21_;
	BudgieMainPanel* _tmp22_;
	BudgieMainPanel* _tmp23_;
	BudgieMainPanel* _tmp24_;
	GtkBox* _tmp25_;
	BudgieMainPanel* _tmp26_;
	GtkBox* _tmp27_;
	BudgiePanelPosition _tmp28_;
	BudgiePanelPosition _tmp29_;
	BudgieShadowBlock* _tmp30_;
	BudgieShadowBlock* _tmp31_;
	BudgieShadowBlock* _tmp32_;
	BudgieShadowBlock* _tmp33_;
	GtkBox* _tmp34_;
	BudgieShadowBlock* _tmp35_;
	GSettings* _tmp36_;
	BudgieShadowBlock* _tmp37_;
	GSettings* _tmp38_;
	BudgieMainPanel* _tmp39_;
	gboolean _tmp40_;
	gboolean _tmp41_;
	GSettings* _tmp42_;
	GSettings* _tmp43_;
	GtkBox* _tmp44_;
	GtkBox* _tmp45_;
	BudgieMainPanel* _tmp46_;
	GtkBox* _tmp47_;
	GtkBox* _tmp48_;
	BudgieMainPanel* _tmp49_;
	GtkBox* _tmp50_;
	GtkBox* _tmp51_;
	BudgieMainPanel* _tmp52_;
	GtkBox* _tmp53_;
	GtkBox* _tmp54_;
	GSettings* _tmp55_;
	GSettings* _tmp56_;
	GtkWidget* _tmp57_;
	GtkBox* _tmp58_;
	GtkBox* _tmp59_;
	GtkBox* _tmp60_;
	BudgiePanelManager* _tmp61_;
	self = (BudgiePanel*) g_object_new (object_type, "type-hint", GDK_WINDOW_TYPE_HINT_DOCK, "window-position", GTK_WIN_POS_NONE, "settings", settings, "uuid", uuid, NULL);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->initial_config);
	self->priv->initial_config = _tmp2_;
	budgie_toplevel_set_intended_size ((BudgieToplevel*) self, g_settings_get_int (settings, BUDGIE_PANEL_KEY_SIZE));
	self->priv->manager = manager;
	gtk_window_set_skip_taskbar_hint ((GtkWindow*) self, TRUE);
	gtk_window_set_skip_pager_hint ((GtkWindow*) self, TRUE);
	gtk_window_set_decorated ((GtkWindow*) self, FALSE);
	self->priv->scale = gtk_widget_get_scale_factor ((GtkWidget*) self);
	budgie_panel_set_nscale (self, 1.0);
	g_signal_connect_object ((GObject*) self, "notify::scale-factor", (GCallback) ___lambda8__g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::intersected", (GCallback) ___lambda9__g_object_notify, self, 0);
	_tmp3_ = budgie_popover_manager_new ();
	_g_object_unref0 (self->priv->popover_manager);
	self->priv->popover_manager = _tmp3_;
	_tmp4_ = g_str_hash;
	_tmp5_ = g_str_equal;
	_tmp6_ = g_hash_table_new_full (_tmp4_, _tmp5_, _g_free0_, _g_hash_table_unref0_);
	_g_hash_table_unref0 (self->priv->pending);
	self->priv->pending = _tmp6_;
	_tmp7_ = g_str_hash;
	_tmp8_ = g_str_equal;
	_tmp9_ = g_hash_table_new_full (_tmp7_, _tmp8_, _g_free0_, _g_hash_table_unref0_);
	_g_hash_table_unref0 (self->priv->creating);
	self->priv->creating = _tmp9_;
	_tmp10_ = g_str_hash;
	_tmp11_ = g_str_equal;
	_tmp12_ = g_hash_table_new_full (_tmp10_, _tmp11_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->applets);
	self->priv->applets = _tmp12_;
	(self->priv->expected_uuids == NULL) ? NULL : (self->priv->expected_uuids = (_g_list_free__g_free0_ (self->priv->expected_uuids), NULL));
	self->priv->expected_uuids = NULL;
	g_signal_connect_object (self, "panel-loaded", (GCallback) _budgie_panel_on_fully_loaded_budgie_panel_panel_loaded, self, 0);
	_tmp13_ = gtk_window_get_screen ((GtkWindow*) self);
	_tmp14_ = _tmp13_;
	_tmp15_ = gdk_screen_get_rgba_visual (_tmp14_);
	_tmp16_ = _g_object_ref0 (_tmp15_);
	vis = _tmp16_;
	_tmp17_ = vis;
	if (_tmp17_ == NULL) {
		g_warning ("panel.vala:305: Compositing not available, things will Look Bad (TM)");
	} else {
		GdkVisual* _tmp18_;
		_tmp18_ = vis;
		gtk_widget_set_visual ((GtkWidget*) self, _tmp18_);
	}
	gtk_window_set_resizable ((GtkWindow*) self, FALSE);
	gtk_widget_set_app_paintable ((GtkWidget*) self, TRUE);
	_tmp19_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp19_, "budgie-container");
	_tmp20_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp20_);
	_g_object_unref0 (self->priv->main_layout);
	self->priv->main_layout = _tmp20_;
	_tmp21_ = self->priv->main_layout;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp21_);
	_tmp22_ = budgie_main_panel_new ();
	g_object_ref_sink (_tmp22_);
	_g_object_unref0 (self->priv->layout);
	self->priv->layout = _tmp22_;
	_tmp23_ = self->priv->layout;
	gtk_widget_set_valign ((GtkWidget*) _tmp23_, GTK_ALIGN_FILL);
	_tmp24_ = self->priv->layout;
	gtk_widget_set_halign ((GtkWidget*) _tmp24_, GTK_ALIGN_FILL);
	_tmp25_ = self->priv->main_layout;
	_tmp26_ = self->priv->layout;
	gtk_box_pack_start (_tmp25_, (GtkWidget*) _tmp26_, TRUE, TRUE, (guint) 0);
	_tmp27_ = self->priv->main_layout;
	gtk_widget_set_valign ((GtkWidget*) _tmp27_, GTK_ALIGN_START);
	_tmp28_ = budgie_toplevel_get_position ((BudgieToplevel*) self);
	_tmp29_ = _tmp28_;
	_tmp30_ = budgie_shadow_block_new (_tmp29_);
	g_object_ref_sink (_tmp30_);
	_g_object_unref0 (self->priv->shadow);
	self->priv->shadow = _tmp30_;
	_tmp31_ = self->priv->shadow;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp31_, FALSE);
	_tmp32_ = self->priv->shadow;
	gtk_widget_set_halign ((GtkWidget*) _tmp32_, GTK_ALIGN_FILL);
	_tmp33_ = self->priv->shadow;
	gtk_widget_show_all ((GtkWidget*) _tmp33_);
	_tmp34_ = self->priv->main_layout;
	_tmp35_ = self->priv->shadow;
	gtk_box_pack_start (_tmp34_, (GtkWidget*) _tmp35_, FALSE, FALSE, (guint) 0);
	_tmp36_ = self->priv->_settings;
	_tmp37_ = self->priv->shadow;
	g_settings_bind (_tmp36_, BUDGIE_PANEL_KEY_SHADOW, (GObject*) _tmp37_, "active", G_SETTINGS_BIND_GET);
	_tmp38_ = self->priv->_settings;
	g_settings_bind (_tmp38_, BUDGIE_PANEL_KEY_DOCK_MODE, (GObject*) self, "dock-mode", G_SETTINGS_BIND_DEFAULT);
	g_signal_connect_object ((GObject*) self, "notify::dock-mode", (GCallback) _budgie_panel_update_dock_mode_g_object_notify, self, 0);
	_tmp39_ = self->priv->layout;
	_tmp40_ = budgie_toplevel_get_dock_mode ((BudgieToplevel*) self);
	_tmp41_ = _tmp40_;
	budgie_main_panel_set_dock_mode (_tmp39_, _tmp41_);
	_tmp42_ = self->priv->_settings;
	budgie_toplevel_set_shadow_visible ((BudgieToplevel*) self, g_settings_get_boolean (_tmp42_, BUDGIE_PANEL_KEY_SHADOW));
	_tmp43_ = self->priv->_settings;
	g_settings_bind (_tmp43_, BUDGIE_PANEL_KEY_SHADOW, (GObject*) self, "shadow-visible", G_SETTINGS_BIND_DEFAULT);
	_tmp44_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 2);
	g_object_ref_sink (_tmp44_);
	_g_object_unref0 (self->priv->start_box);
	self->priv->start_box = _tmp44_;
	_tmp45_ = self->priv->start_box;
	gtk_widget_set_halign ((GtkWidget*) _tmp45_, GTK_ALIGN_START);
	_tmp46_ = self->priv->layout;
	_tmp47_ = self->priv->start_box;
	gtk_box_pack_start ((GtkBox*) _tmp46_, (GtkWidget*) _tmp47_, FALSE, FALSE, (guint) 0);
	_tmp48_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 2);
	g_object_ref_sink (_tmp48_);
	_g_object_unref0 (self->priv->center_box);
	self->priv->center_box = _tmp48_;
	_tmp49_ = self->priv->layout;
	_tmp50_ = self->priv->center_box;
	gtk_box_set_center_widget ((GtkBox*) _tmp49_, (GtkWidget*) _tmp50_);
	_tmp51_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 2);
	g_object_ref_sink (_tmp51_);
	_g_object_unref0 (self->priv->end_box);
	self->priv->end_box = _tmp51_;
	_tmp52_ = self->priv->layout;
	_tmp53_ = self->priv->end_box;
	gtk_box_pack_end ((GtkBox*) _tmp52_, (GtkWidget*) _tmp53_, FALSE, FALSE, (guint) 0);
	_tmp54_ = self->priv->end_box;
	gtk_widget_set_halign ((GtkWidget*) _tmp54_, GTK_ALIGN_END);
	_tmp55_ = self->priv->_settings;
	budgie_toplevel_set_theme_regions ((BudgieToplevel*) self, g_settings_get_boolean (_tmp55_, BUDGIE_PANEL_KEY_REGIONS));
	g_signal_connect_object ((GObject*) self, "notify::theme-regions", (GCallback) _budgie_panel_update_theme_regions_g_object_notify, self, 0);
	_tmp56_ = self->priv->_settings;
	g_settings_bind (_tmp56_, BUDGIE_PANEL_KEY_REGIONS, (GObject*) self, "theme-regions", G_SETTINGS_BIND_DEFAULT);
	budgie_panel_update_theme_regions (self);
	g_signal_connect_object ((GtkWidget*) self, "size-allocate", (GCallback) _budgie_panel_do_size_allocate_gtk_widget_size_allocate, self, G_CONNECT_AFTER);
	g_signal_connect_object ((GtkWidget*) self, "enter-notify-event", (GCallback) _budgie_panel_on_enter_notify_gtk_widget_enter_notify_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "leave-notify-event", (GCallback) _budgie_panel_on_leave_notify_gtk_widget_leave_notify_event, self, 0);
	_tmp57_ = gtk_bin_get_child ((GtkBin*) self);
	gtk_widget_show_all (_tmp57_);
	_tmp58_ = self->priv->start_box;
	gtk_widget_hide ((GtkWidget*) _tmp58_);
	_tmp59_ = self->priv->center_box;
	gtk_widget_hide ((GtkWidget*) _tmp59_);
	_tmp60_ = self->priv->end_box;
	gtk_widget_hide ((GtkWidget*) _tmp60_);
	_tmp61_ = self->priv->manager;
	g_signal_connect_object (_tmp61_, "extension-loaded", (GCallback) _budgie_panel_on_extension_loaded_budgie_panel_manager_extension_loaded, self, G_CONNECT_AFTER);
	budgie_panel_update_sizes (self);
	budgie_panel_load_applets (self);
	_g_object_unref0 (vis);
	return self;
}

BudgiePanel*
budgie_panel_new (BudgiePanelManager* manager,
                  const gchar* uuid,
                  GSettings* settings)
{
	return budgie_panel_construct (BUDGIE_TYPE_PANEL, manager, uuid, settings);
}

static void
budgie_panel_do_size_allocate (BudgiePanel* self)
{
	g_return_if_fail (self != NULL);
	budgie_panel_update_screen_edge (self);
}

static void
budgie_panel_update_theme_regions (BudgiePanel* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = budgie_toplevel_get_theme_regions ((BudgieToplevel*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		GtkBox* _tmp2_;
		GtkStyleContext* _tmp3_;
		GtkBox* _tmp4_;
		GtkStyleContext* _tmp5_;
		GtkBox* _tmp6_;
		GtkStyleContext* _tmp7_;
		_tmp2_ = self->priv->start_box;
		_tmp3_ = gtk_widget_get_style_context ((GtkWidget*) _tmp2_);
		gtk_style_context_add_class (_tmp3_, "start-region");
		_tmp4_ = self->priv->center_box;
		_tmp5_ = gtk_widget_get_style_context ((GtkWidget*) _tmp4_);
		gtk_style_context_add_class (_tmp5_, "center-region");
		_tmp6_ = self->priv->end_box;
		_tmp7_ = gtk_widget_get_style_context ((GtkWidget*) _tmp6_);
		gtk_style_context_add_class (_tmp7_, "end-region");
	} else {
		GtkBox* _tmp8_;
		GtkStyleContext* _tmp9_;
		GtkBox* _tmp10_;
		GtkStyleContext* _tmp11_;
		GtkBox* _tmp12_;
		GtkStyleContext* _tmp13_;
		_tmp8_ = self->priv->start_box;
		_tmp9_ = gtk_widget_get_style_context ((GtkWidget*) _tmp8_);
		gtk_style_context_remove_class (_tmp9_, "start-region");
		_tmp10_ = self->priv->center_box;
		_tmp11_ = gtk_widget_get_style_context ((GtkWidget*) _tmp10_);
		gtk_style_context_remove_class (_tmp11_, "center-region");
		_tmp12_ = self->priv->end_box;
		_tmp13_ = gtk_widget_get_style_context ((GtkWidget*) _tmp12_);
		gtk_style_context_remove_class (_tmp13_, "end-region");
	}
	gtk_widget_queue_draw ((GtkWidget*) self);
}

static void
budgie_panel_update_sizes (BudgiePanel* self)
{
	gint size = 0;
	gint* _tmp0_;
	gint _tmp0__length1;
	gint _tmp1_;
	gint small_size = 0;
	gint* _tmp2_;
	gint _tmp2__length1;
	gint _tmp3_;
	const gchar* key = NULL;
	BudgieAppletInfo* info = NULL;
	GHashTableIter iter = {0};
	GHashTable* _tmp15_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->icon_sizes;
	_tmp0__length1 = self->priv->icon_sizes_length1;
	_tmp1_ = _tmp0_[0];
	size = _tmp1_;
	_tmp2_ = self->priv->icon_sizes;
	_tmp2__length1 = self->priv->icon_sizes_length1;
	_tmp3_ = _tmp2_[0];
	small_size = _tmp3_;
	key = NULL;
	info = NULL;
	{
		gint i = 0;
		i = 1;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				gint* _tmp6_;
				gint _tmp6__length1;
				gint* _tmp7_;
				gint _tmp7__length1;
				gint _tmp8_;
				gint _tmp9_;
				gint _tmp10_;
				gint* _tmp11_;
				gint _tmp11__length1;
				gint _tmp12_;
				gint* _tmp13_;
				gint _tmp13__length1;
				gint _tmp14_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp6_ = self->priv->icon_sizes;
				_tmp6__length1 = self->priv->icon_sizes_length1;
				if (!(i < _tmp6__length1)) {
					break;
				}
				_tmp7_ = self->priv->icon_sizes;
				_tmp7__length1 = self->priv->icon_sizes_length1;
				_tmp8_ = _tmp7_[i];
				_tmp9_ = budgie_toplevel_get_intended_size ((BudgieToplevel*) self);
				_tmp10_ = _tmp9_;
				if (_tmp8_ > _tmp10_) {
					break;
				}
				_tmp11_ = self->priv->icon_sizes;
				_tmp11__length1 = self->priv->icon_sizes_length1;
				_tmp12_ = _tmp11_[i];
				size = _tmp12_;
				_tmp13_ = self->priv->icon_sizes;
				_tmp13__length1 = self->priv->icon_sizes_length1;
				_tmp14_ = _tmp13_[i - 1];
				small_size = _tmp14_;
			}
		}
	}
	self->priv->current_icon_size = size;
	self->priv->current_small_icon_size = small_size;
	_tmp15_ = self->priv->applets;
	g_hash_table_iter_init (&iter, _tmp15_);
	while (TRUE) {
		gconstpointer _tmp16_ = NULL;
		gconstpointer _tmp17_ = NULL;
		gboolean _tmp18_;
		BudgieAppletInfo* _tmp19_;
		BudgieApplet* _tmp20_;
		BudgieApplet* _tmp21_;
		BudgieApplet* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		_tmp18_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp16_), (gpointer*) (&_tmp17_));
		key = _tmp16_;
		info = _tmp17_;
		if (!_tmp18_) {
			break;
		}
		_tmp19_ = info;
		g_object_get (_tmp19_, "applet", &_tmp20_, NULL);
		_tmp21_ = _tmp20_;
		_tmp22_ = _tmp21_;
		_tmp23_ = budgie_toplevel_get_intended_size ((BudgieToplevel*) self);
		_tmp24_ = _tmp23_;
		g_signal_emit_by_name (_tmp22_, "panel-size-changed", _tmp24_, size, small_size);
		_g_object_unref0 (_tmp22_);
	}
}

static void
budgie_panel_update_positions (BudgiePanel* self)
{
	const gchar* key = NULL;
	BudgieAppletInfo* info = NULL;
	GHashTableIter iter = {0};
	GHashTable* _tmp0_;
	g_return_if_fail (self != NULL);
	key = NULL;
	info = NULL;
	_tmp0_ = self->priv->applets;
	g_hash_table_iter_init (&iter, _tmp0_);
	while (TRUE) {
		gconstpointer _tmp1_ = NULL;
		gconstpointer _tmp2_ = NULL;
		gboolean _tmp3_;
		BudgieAppletInfo* _tmp4_;
		BudgieApplet* _tmp5_;
		BudgieApplet* _tmp6_;
		BudgieApplet* _tmp7_;
		BudgiePanelPosition _tmp8_;
		BudgiePanelPosition _tmp9_;
		_tmp3_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp1_), (gpointer*) (&_tmp2_));
		key = _tmp1_;
		info = _tmp2_;
		if (!_tmp3_) {
			break;
		}
		_tmp4_ = info;
		g_object_get (_tmp4_, "applet", &_tmp5_, NULL);
		_tmp6_ = _tmp5_;
		_tmp7_ = _tmp6_;
		_tmp8_ = budgie_toplevel_get_position ((BudgieToplevel*) self);
		_tmp9_ = _tmp8_;
		g_signal_emit_by_name (_tmp7_, "panel-position-changed", _tmp9_);
		_g_object_unref0 (_tmp7_);
	}
}

void
budgie_panel_destroy_children (BudgiePanel* self)
{
	const gchar* key = NULL;
	BudgieAppletInfo* info = NULL;
	GHashTableIter iter = {0};
	GHashTable* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->applets;
	g_hash_table_iter_init (&iter, _tmp0_);
	while (TRUE) {
		gconstpointer _tmp1_ = NULL;
		gconstpointer _tmp2_ = NULL;
		gboolean _tmp3_;
		GSettings* app_settings = NULL;
		BudgieAppletInfo* _tmp4_;
		BudgieApplet* _tmp5_;
		BudgieApplet* _tmp6_;
		BudgieApplet* _tmp7_;
		BudgieAppletInfo* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		GSettings* _tmp12_;
		GSettings* _tmp13_;
		GSettings* _tmp14_;
		gulong notify_id = 0UL;
		BudgieAppletInfo* _tmp16_;
		gconstpointer _tmp17_;
		BudgieAppletInfo* _tmp18_;
		BudgieAppletInfo* _tmp19_;
		BudgieApplet* _tmp20_;
		BudgieApplet* _tmp21_;
		BudgieApplet* _tmp22_;
		GtkContainer* _tmp23_;
		BudgieAppletInfo* _tmp24_;
		BudgieApplet* _tmp25_;
		BudgieApplet* _tmp26_;
		BudgieApplet* _tmp27_;
		BudgiePanelManager* _tmp28_;
		BudgieAppletInfo* _tmp29_;
		GSettings* _tmp30_;
		GSettings* _tmp31_;
		GSettings* _tmp32_;
		GSettings* _tmp33_;
		_tmp3_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp1_), (gpointer*) (&_tmp2_));
		key = _tmp1_;
		info = _tmp2_;
		if (!_tmp3_) {
			break;
		}
		_tmp4_ = info;
		g_object_get (_tmp4_, "applet", &_tmp5_, NULL);
		_tmp6_ = _tmp5_;
		_tmp7_ = _tmp6_;
		_tmp8_ = info;
		g_object_get (_tmp8_, "uuid", &_tmp9_, NULL);
		_tmp10_ = _tmp9_;
		_tmp11_ = _tmp10_;
		_tmp12_ = budgie_applet_get_applet_settings (_tmp7_, _tmp11_);
		_tmp13_ = _tmp12_;
		_g_free0 (_tmp11_);
		_g_object_unref0 (_tmp7_);
		app_settings = _tmp13_;
		_tmp14_ = app_settings;
		if (_tmp14_ != NULL) {
			GSettings* _tmp15_;
			_tmp15_ = app_settings;
			g_object_ref ((GObject*) _tmp15_);
		}
		_tmp16_ = info;
		_tmp17_ = g_object_get_data ((GObject*) _tmp16_, "notify_id");
		notify_id = (gulong) ((guintptr) _tmp17_);
		_tmp18_ = info;
		g_signal_handler_disconnect (_tmp18_, notify_id);
		_tmp19_ = info;
		g_object_get (_tmp19_, "applet", &_tmp20_, NULL);
		_tmp21_ = _tmp20_;
		_tmp22_ = _tmp21_;
		_tmp23_ = gtk_widget_get_parent ((GtkWidget*) _tmp22_);
		_tmp24_ = info;
		g_object_get (_tmp24_, "applet", &_tmp25_, NULL);
		_tmp26_ = _tmp25_;
		_tmp27_ = _tmp26_;
		gtk_container_remove (_tmp23_, (GtkWidget*) _tmp27_);
		_g_object_unref0 (_tmp27_);
		_g_object_unref0 (_tmp22_);
		_tmp28_ = self->priv->manager;
		_tmp29_ = info;
		g_object_get (_tmp29_, "settings", &_tmp30_, NULL);
		_tmp31_ = _tmp30_;
		_tmp32_ = _tmp31_;
		budgie_panel_manager_reset_dconf_path (_tmp28_, _tmp32_);
		_g_object_unref0 (_tmp32_);
		_tmp33_ = app_settings;
		if (_tmp33_ != NULL) {
			BudgiePanelManager* _tmp34_;
			GSettings* _tmp35_;
			_tmp34_ = self->priv->manager;
			_tmp35_ = app_settings;
			budgie_panel_manager_reset_dconf_path (_tmp34_, _tmp35_);
		}
		_g_object_unref0 (app_settings);
	}
}

static void
budgie_panel_on_extension_loaded (BudgiePanel* self,
                                  const gchar* name)
{
	GHashTable* todo = NULL;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	GHashTable* _tmp2_;
	GHashTable* _tmp15_;
	gconstpointer _tmp16_;
	GHashTable* _tmp17_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	todo = NULL;
	_tmp0_ = self->priv->pending;
	_tmp1_ = g_hash_table_lookup (_tmp0_, name);
	todo = (GHashTable*) _tmp1_;
	_tmp2_ = todo;
	if (_tmp2_ != NULL) {
		GHashTableIter iter = {0};
		GHashTable* _tmp3_;
		gchar* uuid = NULL;
		GHashTable* _tmp14_;
		_tmp3_ = todo;
		g_hash_table_iter_init (&iter, _tmp3_);
		uuid = NULL;
		while (TRUE) {
			gconstpointer _tmp4_ = NULL;
			gboolean _tmp5_;
			gchar* _tmp6_;
			gchar* uname = NULL;
			BudgieAppletInfo* info = NULL;
			BudgiePanelManager* _tmp7_;
			const gchar* _tmp8_;
			gchar* _tmp9_ = NULL;
			BudgieAppletInfo* _tmp10_;
			BudgieAppletInfo* _tmp11_;
			BudgieAppletInfo* _tmp13_;
			_tmp5_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp4_), (gpointer*) NULL);
			_g_free0 (uuid);
			_tmp6_ = g_strdup (_tmp4_);
			uuid = _tmp6_;
			if (!_tmp5_) {
				break;
			}
			uname = NULL;
			_tmp7_ = self->priv->manager;
			_tmp8_ = uuid;
			_tmp10_ = budgie_panel_manager_load_applet_instance (_tmp7_, _tmp8_, &_tmp9_, NULL);
			_g_free0 (uname);
			uname = _tmp9_;
			info = _tmp10_;
			_tmp11_ = info;
			if (_tmp11_ == NULL) {
				const gchar* _tmp12_;
				_tmp12_ = uname;
				g_critical ("panel.vala:461: Failed to load applet when we know it exists: %s", _tmp12_);
				_g_object_unref0 (info);
				_g_free0 (uname);
				_g_free0 (uuid);
				return;
			}
			_tmp13_ = info;
			budgie_panel_add_applet (self, _tmp13_);
			_g_object_unref0 (info);
			_g_free0 (uname);
		}
		_tmp14_ = self->priv->pending;
		g_hash_table_remove (_tmp14_, name);
		_g_free0 (uuid);
	}
	todo = NULL;
	_tmp15_ = self->priv->creating;
	_tmp16_ = g_hash_table_lookup (_tmp15_, name);
	todo = (GHashTable*) _tmp16_;
	_tmp17_ = todo;
	if (_tmp17_ != NULL) {
		GHashTableIter iter = {0};
		GHashTable* _tmp18_;
		gchar* uuid = NULL;
		GHashTable* _tmp27_;
		_tmp18_ = todo;
		g_hash_table_iter_init (&iter, _tmp18_);
		uuid = NULL;
		while (TRUE) {
			gconstpointer _tmp19_ = NULL;
			gboolean _tmp20_;
			gchar* _tmp21_;
			BudgieAppletInfo* info = NULL;
			BudgiePanelManager* _tmp22_;
			const gchar* _tmp23_;
			BudgieAppletInfo* _tmp24_;
			BudgieAppletInfo* _tmp25_;
			BudgieAppletInfo* _tmp26_;
			_tmp20_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp19_), (gpointer*) NULL);
			_g_free0 (uuid);
			_tmp21_ = g_strdup (_tmp19_);
			uuid = _tmp21_;
			if (!_tmp20_) {
				break;
			}
			_tmp22_ = self->priv->manager;
			_tmp23_ = uuid;
			_tmp24_ = budgie_panel_manager_create_new_applet (_tmp22_, name, _tmp23_);
			info = _tmp24_;
			_tmp25_ = info;
			if (_tmp25_ == NULL) {
				g_critical ("panel.vala:479: Failed to load applet when we know it exists");
				_g_object_unref0 (info);
				_g_free0 (uuid);
				return;
			}
			_tmp26_ = info;
			budgie_panel_add_applet (self, _tmp26_);
			_g_object_unref0 (info);
		}
		_tmp27_ = self->priv->creating;
		g_hash_table_remove (_tmp27_, name);
		_g_free0 (uuid);
	}
}

/**
* Load all pre-configured applets
*/
static gint
__lambda10_ (BudgieAppletInfo* a,
             BudgieAppletInfo* b)
{
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gint result;
	g_object_get (a, "position", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	g_object_get (b, "position", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	g_object_get (a, "position", &_tmp4_, NULL);
	_tmp5_ = _tmp4_;
	g_object_get (b, "position", &_tmp6_, NULL);
	_tmp7_ = _tmp6_;
	result = ((gint) (_tmp1_ > _tmp3_)) - ((gint) (_tmp5_ < _tmp7_));
	return result;
}

static gint
___lambda10__gcompare_func (gconstpointer a,
                            gconstpointer b)
{
	gint result;
	result = __lambda10_ ((BudgieAppletInfo*) a, (BudgieAppletInfo*) b);
	return result;
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
budgie_panel_load_applets (BudgiePanel* self)
{
	gchar** applets = NULL;
	GSettings* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint applets_length1;
	gint _applets_size_;
	gboolean _tmp3_ = FALSE;
	gchar** _tmp4_;
	gint _tmp4__length1;
	GCompareFunc infocmp = NULL;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_settings;
	_tmp2_ = _tmp1_ = g_settings_get_strv (_tmp0_, BUDGIE_PANEL_KEY_APPLETS);
	applets = _tmp2_;
	applets_length1 = _vala_array_length (_tmp1_);
	_applets_size_ = applets_length1;
	_tmp4_ = applets;
	_tmp4__length1 = applets_length1;
	if (_tmp4_ == NULL) {
		_tmp3_ = TRUE;
	} else {
		gchar** _tmp5_;
		gint _tmp5__length1;
		_tmp5_ = applets;
		_tmp5__length1 = applets_length1;
		_tmp3_ = _tmp5__length1 == 0;
	}
	if (_tmp3_) {
		g_signal_emit (self, budgie_panel_signals[BUDGIE_PANEL_PANEL_LOADED_SIGNAL], 0);
		self->priv->is_fully_loaded = TRUE;
		applets = (_vala_array_free (applets, applets_length1, (GDestroyNotify) g_free), NULL);
		return;
	}
	infocmp = ___lambda10__gcompare_func;
	{
		GList* _tmp6_;
		_tmp6_ = self->priv->expected_uuids;
		g_rec_mutex_lock (&self->priv->__lock_expected_uuids);
		{
			GList* start_applets = NULL;
			GList* center_applets = NULL;
			GList* end_applets = NULL;
			{
				gint i = 0;
				i = 0;
				{
					gboolean _tmp7_ = FALSE;
					_tmp7_ = TRUE;
					while (TRUE) {
						gchar** _tmp9_;
						gint _tmp9__length1;
						gchar** _tmp10_;
						gint _tmp10__length1;
						const gchar* _tmp11_;
						gchar* _tmp12_;
						if (!_tmp7_) {
							gint _tmp8_;
							_tmp8_ = i;
							i = _tmp8_ + 1;
						}
						_tmp7_ = FALSE;
						_tmp9_ = applets;
						_tmp9__length1 = applets_length1;
						if (!(i < _tmp9__length1)) {
							break;
						}
						_tmp10_ = applets;
						_tmp10__length1 = applets_length1;
						_tmp11_ = _tmp10_[i];
						_tmp12_ = g_strdup (_tmp11_);
						self->priv->expected_uuids = g_list_append (self->priv->expected_uuids, _tmp12_);
					}
				}
			}
			start_applets = NULL;
			center_applets = NULL;
			end_applets = NULL;
			{
				gint i = 0;
				i = 0;
				{
					gboolean _tmp13_ = FALSE;
					_tmp13_ = TRUE;
					while (TRUE) {
						gchar** _tmp15_;
						gint _tmp15__length1;
						gchar* name = NULL;
						BudgieAppletInfo* info = NULL;
						BudgiePanelManager* _tmp16_;
						gchar** _tmp17_;
						gint _tmp17__length1;
						const gchar* _tmp18_;
						gchar* _tmp19_ = NULL;
						BudgieAppletInfo* _tmp20_;
						BudgieAppletInfo* _tmp21_;
						BudgieAppletInfo* _tmp39_;
						gchar* _tmp40_;
						gchar* _tmp41_;
						gchar* _tmp42_;
						gboolean _tmp43_;
						if (!_tmp13_) {
							gint _tmp14_;
							_tmp14_ = i;
							i = _tmp14_ + 1;
						}
						_tmp13_ = FALSE;
						_tmp15_ = applets;
						_tmp15__length1 = applets_length1;
						if (!(i < _tmp15__length1)) {
							break;
						}
						name = NULL;
						_tmp16_ = self->priv->manager;
						_tmp17_ = applets;
						_tmp17__length1 = applets_length1;
						_tmp18_ = _tmp17_[i];
						_tmp20_ = budgie_panel_manager_load_applet_instance (_tmp16_, _tmp18_, &_tmp19_, NULL);
						_g_free0 (name);
						name = _tmp19_;
						info = _tmp20_;
						_tmp21_ = info;
						if (_tmp21_ == NULL) {
							const gchar* _tmp22_;
							gchar** _tmp34_;
							gint _tmp34__length1;
							const gchar* _tmp35_;
							const gchar* _tmp36_;
							BudgieAppletInfo* _tmp37_;
							BudgieAppletInfo* _tmp38_;
							_tmp22_ = name;
							if (_tmp22_ == NULL) {
								GList* g = NULL;
								GList* _tmp23_;
								gchar** _tmp24_;
								gint _tmp24__length1;
								const gchar* _tmp25_;
								GCompareFunc _tmp26_;
								GList* _tmp27_;
								GList* _tmp28_;
								gchar** _tmp30_;
								gint _tmp30__length1;
								const gchar* _tmp31_;
								gchar** _tmp32_;
								gint _tmp32__length1;
								const gchar* _tmp33_;
								_tmp23_ = self->priv->expected_uuids;
								_tmp24_ = applets;
								_tmp24__length1 = applets_length1;
								_tmp25_ = _tmp24_[i];
								_tmp26_ = ((GCompareFunc) g_strcmp0);
								_tmp27_ = g_list_find_custom (_tmp23_, _tmp25_, _tmp26_);
								g = _tmp27_;
								_tmp28_ = g;
								if (_tmp28_ != NULL) {
									GList* _tmp29_;
									_tmp29_ = g;
									self->priv->expected_uuids = g_list_remove_link (self->priv->expected_uuids, _tmp29_);
								}
								_tmp30_ = applets;
								_tmp30__length1 = applets_length1;
								_tmp31_ = _tmp30_[i];
								g_message ("panel.vala:523: Unable to load invalid applet: %s", _tmp31_);
								_tmp32_ = applets;
								_tmp32__length1 = applets_length1;
								_tmp33_ = _tmp32_[i];
								g_signal_emit_by_name ((BudgieToplevel*) self, "applet-removed", _tmp33_);
								_g_object_unref0 (info);
								_g_free0 (name);
								continue;
							}
							_tmp34_ = applets;
							_tmp34__length1 = applets_length1;
							_tmp35_ = _tmp34_[i];
							_tmp36_ = name;
							_tmp37_ = budgie_panel_add_pending (self, _tmp35_, _tmp36_);
							_g_object_unref0 (info);
							info = _tmp37_;
							_tmp38_ = info;
							if (_tmp38_ == NULL) {
								_g_object_unref0 (info);
								_g_free0 (name);
								continue;
							}
						}
						_tmp39_ = info;
						g_object_get (_tmp39_, "alignment", &_tmp40_, NULL);
						_tmp41_ = _tmp40_;
						_tmp42_ = _tmp41_;
						_tmp43_ = g_strcmp0 (_tmp42_, "start") == 0;
						_g_free0 (_tmp42_);
						if (_tmp43_) {
							BudgieAppletInfo* _tmp44_;
							BudgieAppletInfo* _tmp45_;
							GCompareFunc _tmp46_;
							_tmp44_ = info;
							_tmp45_ = _g_object_ref0 (_tmp44_);
							_tmp46_ = infocmp;
							start_applets = g_list_insert_sorted (start_applets, _tmp45_, _tmp46_);
						} else {
							BudgieAppletInfo* _tmp47_;
							gchar* _tmp48_;
							gchar* _tmp49_;
							gchar* _tmp50_;
							gboolean _tmp51_;
							_tmp47_ = info;
							g_object_get (_tmp47_, "alignment", &_tmp48_, NULL);
							_tmp49_ = _tmp48_;
							_tmp50_ = _tmp49_;
							_tmp51_ = g_strcmp0 (_tmp50_, "center") == 0;
							_g_free0 (_tmp50_);
							if (_tmp51_) {
								BudgieAppletInfo* _tmp52_;
								BudgieAppletInfo* _tmp53_;
								GCompareFunc _tmp54_;
								_tmp52_ = info;
								_tmp53_ = _g_object_ref0 (_tmp52_);
								_tmp54_ = infocmp;
								center_applets = g_list_insert_sorted (center_applets, _tmp53_, _tmp54_);
							} else {
								BudgieAppletInfo* _tmp55_;
								BudgieAppletInfo* _tmp56_;
								GCompareFunc _tmp57_;
								_tmp55_ = info;
								_tmp56_ = _g_object_ref0 (_tmp55_);
								_tmp57_ = infocmp;
								end_applets = g_list_insert_sorted (end_applets, _tmp56_, _tmp57_);
							}
						}
						_g_object_unref0 (info);
						_g_free0 (name);
					}
				}
			}
			{
				gint i = 0;
				i = 0;
				{
					gboolean _tmp58_ = FALSE;
					_tmp58_ = TRUE;
					while (TRUE) {
						GList* _tmp60_;
						GList* _tmp61_;
						gconstpointer _tmp62_;
						GList* _tmp63_;
						gconstpointer _tmp64_;
						if (!_tmp58_) {
							gint _tmp59_;
							_tmp59_ = i;
							i = _tmp59_ + 1;
						}
						_tmp58_ = FALSE;
						_tmp60_ = start_applets;
						if (!(((guint) i) < g_list_length (_tmp60_))) {
							break;
						}
						_tmp61_ = start_applets;
						_tmp62_ = g_list_nth_data (_tmp61_, (guint) i);
						g_object_set ((BudgieAppletInfo*) _tmp62_, "position", i, NULL);
						_tmp63_ = start_applets;
						_tmp64_ = g_list_nth_data (_tmp63_, (guint) i);
						budgie_panel_add_applet (self, (BudgieAppletInfo*) _tmp64_);
					}
				}
			}
			{
				gint i = 0;
				i = 0;
				{
					gboolean _tmp65_ = FALSE;
					_tmp65_ = TRUE;
					while (TRUE) {
						GList* _tmp67_;
						GList* _tmp68_;
						gconstpointer _tmp69_;
						GList* _tmp70_;
						gconstpointer _tmp71_;
						if (!_tmp65_) {
							gint _tmp66_;
							_tmp66_ = i;
							i = _tmp66_ + 1;
						}
						_tmp65_ = FALSE;
						_tmp67_ = center_applets;
						if (!(((guint) i) < g_list_length (_tmp67_))) {
							break;
						}
						_tmp68_ = center_applets;
						_tmp69_ = g_list_nth_data (_tmp68_, (guint) i);
						g_object_set ((BudgieAppletInfo*) _tmp69_, "position", i, NULL);
						_tmp70_ = center_applets;
						_tmp71_ = g_list_nth_data (_tmp70_, (guint) i);
						budgie_panel_add_applet (self, (BudgieAppletInfo*) _tmp71_);
					}
				}
			}
			{
				gint i = 0;
				i = 0;
				{
					gboolean _tmp72_ = FALSE;
					_tmp72_ = TRUE;
					while (TRUE) {
						GList* _tmp74_;
						GList* _tmp75_;
						gconstpointer _tmp76_;
						GList* _tmp77_;
						gconstpointer _tmp78_;
						if (!_tmp72_) {
							gint _tmp73_;
							_tmp73_ = i;
							i = _tmp73_ + 1;
						}
						_tmp72_ = FALSE;
						_tmp74_ = end_applets;
						if (!(((guint) i) < g_list_length (_tmp74_))) {
							break;
						}
						_tmp75_ = end_applets;
						_tmp76_ = g_list_nth_data (_tmp75_, (guint) i);
						g_object_set ((BudgieAppletInfo*) _tmp76_, "position", i, NULL);
						_tmp77_ = end_applets;
						_tmp78_ = g_list_nth_data (_tmp77_, (guint) i);
						budgie_panel_add_applet (self, (BudgieAppletInfo*) _tmp78_);
					}
				}
			}
			(end_applets == NULL) ? NULL : (end_applets = (_g_list_free__g_object_unref0_ (end_applets), NULL));
			(center_applets == NULL) ? NULL : (center_applets = (_g_list_free__g_object_unref0_ (center_applets), NULL));
			(start_applets == NULL) ? NULL : (start_applets = (_g_list_free__g_object_unref0_ (start_applets), NULL));
		}
		__finally0:
		{
			GList* _tmp79_;
			_tmp79_ = self->priv->expected_uuids;
			g_rec_mutex_unlock (&self->priv->__lock_expected_uuids);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			applets = (_vala_array_free (applets, applets_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	applets = (_vala_array_free (applets, applets_length1, (GDestroyNotify) g_free), NULL);
}

/**
* Add a new applet to the panel (Raven UI)
*
* Explanation: Try to find the most underpopulated region first,
* and add the applet there. Determine a suitable position,
* set the alignment+position, stuff an initial config in,
* and hope for the best when we initiate add_new
*
* If the @target_region is set, we'll use that instead
*/
static void
budgie_panel_add_new_applet_at (BudgiePanel* self,
                                const gchar* id,
                                GtkBox* target_region)
{
	gint position = 0;
	GHashTable* _tmp0_;
	GtkBox* target = NULL;
	gchar* align = NULL;
	BudgieAppletInfo* info = NULL;
	gchar* uuid = NULL;
	GtkBox** regions = NULL;
	GtkBox* _tmp1_;
	GtkBox* _tmp2_;
	GtkBox* _tmp3_;
	GtkBox* _tmp4_;
	GtkBox* _tmp5_;
	GtkBox* _tmp6_;
	GtkBox** _tmp7_;
	gint regions_length1;
	gint _regions_size_;
	GtkBox* _tmp16_;
	GtkBox* _tmp17_;
	gchar* _tmp23_;
	const gchar* _tmp24_;
	BudgieAppletInfo* _tmp25_;
	BudgieAppletInfo* _tmp26_;
	const gchar* _tmp27_;
	GList* kids = NULL;
	GtkBox* _tmp28_;
	GList* _tmp29_;
	guint nkids = 0U;
	GList* _tmp30_;
	BudgieAppletInfo* _tmp31_;
	GHashTable* _tmp32_;
	const gchar* _tmp33_;
	gchar* _tmp34_;
	BudgieAppletInfo* _tmp35_;
	BudgieAppletInfo* _tmp36_;
	const gchar* _tmp37_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (id != NULL);
	_tmp0_ = self->priv->applets;
	position = ((gint) g_hash_table_size (_tmp0_)) + 1;
	target = NULL;
	align = NULL;
	info = NULL;
	uuid = NULL;
	_tmp1_ = self->priv->start_box;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_tmp3_ = self->priv->center_box;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_tmp5_ = self->priv->end_box;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	_tmp7_ = g_new0 (GtkBox*, 3 + 1);
	_tmp7_[0] = _tmp2_;
	_tmp7_[1] = _tmp4_;
	_tmp7_[2] = _tmp6_;
	regions = _tmp7_;
	regions_length1 = 3;
	_regions_size_ = regions_length1;
	if (target_region != NULL) {
		GList* kids = NULL;
		GList* _tmp8_;
		GList* _tmp9_;
		_tmp8_ = gtk_container_get_children ((GtkContainer*) target_region);
		kids = _tmp8_;
		_tmp9_ = kids;
		position = (gint) g_list_length (_tmp9_);
		target = target_region;
		(kids == NULL) ? NULL : (kids = (g_list_free (kids), NULL));
	} else {
		GtkBox** _tmp10_;
		gint _tmp10__length1;
		_tmp10_ = regions;
		_tmp10__length1 = regions_length1;
		{
			GtkBox** region_collection = NULL;
			gint region_collection_length1 = 0;
			gint _region_collection_size_ = 0;
			gint region_it = 0;
			region_collection = _tmp10_;
			region_collection_length1 = _tmp10__length1;
			for (region_it = 0; region_it < region_collection_length1; region_it = region_it + 1) {
				GtkBox* _tmp11_;
				GtkBox* region = NULL;
				_tmp11_ = _g_object_ref0 (region_collection[region_it]);
				region = _tmp11_;
				{
					GList* kids = NULL;
					GtkBox* _tmp12_;
					GList* _tmp13_;
					guint len = 0U;
					GList* _tmp14_;
					_tmp12_ = region;
					_tmp13_ = gtk_container_get_children ((GtkContainer*) _tmp12_);
					kids = _tmp13_;
					_tmp14_ = kids;
					len = g_list_length (_tmp14_);
					if (len < ((guint) position)) {
						GtkBox* _tmp15_;
						position = (gint) len;
						_tmp15_ = region;
						target = _tmp15_;
					}
					(kids == NULL) ? NULL : (kids = (g_list_free (kids), NULL));
					_g_object_unref0 (region);
				}
			}
		}
	}
	_tmp16_ = target;
	_tmp17_ = self->priv->start_box;
	if (_tmp16_ == _tmp17_) {
		gchar* _tmp18_;
		_tmp18_ = g_strdup ("start");
		_g_free0 (align);
		align = _tmp18_;
	} else {
		GtkBox* _tmp19_;
		GtkBox* _tmp20_;
		_tmp19_ = target;
		_tmp20_ = self->priv->center_box;
		if (_tmp19_ == _tmp20_) {
			gchar* _tmp21_;
			_tmp21_ = g_strdup ("center");
			_g_free0 (align);
			align = _tmp21_;
		} else {
			gchar* _tmp22_;
			_tmp22_ = g_strdup ("end");
			_g_free0 (align);
			align = _tmp22_;
		}
	}
	_tmp23_ = uuid_new (UUID_UUID_FLAGS_LOWER_CASE | UUID_UUID_FLAGS_TIME_SAFE_TYPE);
	_g_free0 (uuid);
	uuid = _tmp23_;
	_tmp24_ = uuid;
	_tmp25_ = budgie_applet_info_new_from_uuid (_tmp24_);
	_g_object_unref0 (info);
	info = _tmp25_;
	_tmp26_ = info;
	_tmp27_ = align;
	g_object_set (_tmp26_, "alignment", _tmp27_, NULL);
	_tmp28_ = target;
	_tmp29_ = gtk_container_get_children ((GtkContainer*) _tmp28_);
	kids = _tmp29_;
	_tmp30_ = kids;
	nkids = g_list_length (_tmp30_);
	if (((guint) position) >= nkids) {
		position = (gint) nkids;
	}
	if (position < 0) {
		position = 0;
	}
	_tmp31_ = info;
	g_object_set (_tmp31_, "position", position, NULL);
	_tmp32_ = self->priv->initial_config;
	_tmp33_ = uuid;
	_tmp34_ = g_strdup (_tmp33_);
	_tmp35_ = info;
	_tmp36_ = _g_object_ref0 (_tmp35_);
	g_hash_table_insert (_tmp32_, _tmp34_, _tmp36_);
	_tmp37_ = uuid;
	budgie_panel_add_new (self, id, _tmp37_);
	(kids == NULL) ? NULL : (kids = (g_list_free (kids), NULL));
	regions = (_vala_array_free (regions, regions_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_free0 (uuid);
	_g_object_unref0 (info);
	_g_free0 (align);
}

/**
* Add a new applet to the panel (Raven UI)
*/
static void
budgie_panel_real_add_new_applet (BudgieToplevel* base,
                                  const gchar* id)
{
	BudgiePanel * self;
	self = (BudgiePanel*) base;
	g_return_if_fail (id != NULL);
	budgie_panel_add_new_applet_at (self, id, NULL);
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

void
budgie_panel_create_default_layout (BudgiePanel* self,
                                    const gchar* name,
                                    GKeyFile* config)
{
	gint s_index = 0;
	gint c_index = 0;
	gint e_index = 0;
	gint index = 0;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (config != NULL);
	s_index = -1;
	c_index = -1;
	e_index = -1;
	index = 0;
	{
		gboolean _tmp0_ = FALSE;
		gchar** applets = NULL;
		gsize _tmp1_ = 0;
		gchar** _tmp2_;
		gint applets_length1;
		gint _applets_size_;
		gchar** _tmp3_;
		gint _tmp3__length1;
		_tmp0_ = g_key_file_has_key (config, name, "Children", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		if (!_tmp0_) {
			g_warning ("panel.vala:644: Config for panel %s does not specify applets", name);
			return;
		}
		_tmp2_ = g_key_file_get_string_list (config, name, "Children", &_tmp1_, &_inner_error0_);
		applets = _tmp2_;
		applets_length1 = _tmp1_;
		_applets_size_ = applets_length1;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = applets;
		_tmp3__length1 = applets_length1;
		{
			gchar** appl_collection = NULL;
			gint appl_collection_length1 = 0;
			gint _appl_collection_size_ = 0;
			gint appl_it = 0;
			appl_collection = _tmp3_;
			appl_collection_length1 = _tmp3__length1;
			for (appl_it = 0; appl_it < appl_collection_length1; appl_it = appl_it + 1) {
				gchar* _tmp4_;
				gchar* appl = NULL;
				_tmp4_ = g_strdup (appl_collection[appl_it]);
				appl = _tmp4_;
				{
					BudgieAppletInfo* info = NULL;
					gchar* uuid = NULL;
					const gchar* _tmp5_;
					gchar* _tmp6_;
					gchar* alignment = NULL;
					gchar* _tmp7_;
					const gchar* _tmp8_;
					gboolean _tmp10_ = FALSE;
					const gchar* _tmp11_;
					gchar* _tmp13_;
					gchar* _tmp14_ = NULL;
					const gchar* _tmp15_;
					gchar* _tmp16_;
					gchar* id = NULL;
					gchar* _tmp17_;
					gboolean _tmp18_ = FALSE;
					const gchar* _tmp19_;
					const gchar* _tmp24_;
					BudgieAppletInfo* _tmp25_;
					gboolean _tmp26_ = FALSE;
					const gchar* _tmp27_;
					const gchar* _tmp32_;
					const gchar* _tmp33_;
					GQuark _tmp35_ = 0U;
					static GQuark _tmp34_label0 = 0;
					static GQuark _tmp34_label1 = 0;
					BudgieAppletInfo* _tmp39_;
					const gchar* _tmp40_;
					BudgieAppletInfo* _tmp41_;
					GHashTable* _tmp42_;
					const gchar* _tmp43_;
					gchar* _tmp44_;
					BudgieAppletInfo* _tmp45_;
					BudgieAppletInfo* _tmp46_;
					const gchar* _tmp47_;
					const gchar* _tmp48_;
					info = NULL;
					uuid = NULL;
					_tmp5_ = appl;
					_tmp6_ = string_strip (_tmp5_);
					_g_free0 (appl);
					appl = _tmp6_;
					_tmp7_ = g_strdup ("start");
					alignment = _tmp7_;
					_tmp8_ = appl;
					if (!g_key_file_has_group (config, _tmp8_)) {
						const gchar* _tmp9_;
						_tmp9_ = appl;
						g_warning ("panel.vala:655: Panel applet %s missing from config", _tmp9_);
						_g_free0 (alignment);
						_g_free0 (uuid);
						_g_object_unref0 (info);
						_g_free0 (appl);
						continue;
					}
					_tmp11_ = appl;
					_tmp10_ = g_key_file_has_key (config, _tmp11_, "ID", &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_free0 (alignment);
						_g_free0 (uuid);
						_g_object_unref0 (info);
						_g_free0 (appl);
						applets = (_vala_array_free (applets, applets_length1, (GDestroyNotify) g_free), NULL);
						goto __catch0_g_error;
					}
					if (!_tmp10_) {
						const gchar* _tmp12_;
						_tmp12_ = appl;
						g_warning ("panel.vala:660: Applet %s is missing ID", _tmp12_);
						_g_free0 (alignment);
						_g_free0 (uuid);
						_g_object_unref0 (info);
						_g_free0 (appl);
						continue;
					}
					_tmp13_ = uuid_new (UUID_UUID_FLAGS_LOWER_CASE | UUID_UUID_FLAGS_TIME_SAFE_TYPE);
					_g_free0 (uuid);
					uuid = _tmp13_;
					_tmp15_ = appl;
					_tmp16_ = g_key_file_get_string (config, _tmp15_, "ID", &_inner_error0_);
					_tmp14_ = _tmp16_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_free0 (alignment);
						_g_free0 (uuid);
						_g_object_unref0 (info);
						_g_free0 (appl);
						applets = (_vala_array_free (applets, applets_length1, (GDestroyNotify) g_free), NULL);
						goto __catch0_g_error;
					}
					_tmp17_ = string_strip (_tmp14_);
					id = _tmp17_;
					_tmp19_ = uuid;
					if (_tmp19_ == NULL) {
						_tmp18_ = TRUE;
					} else {
						const gchar* _tmp20_;
						gchar* _tmp21_;
						gchar* _tmp22_;
						_tmp20_ = uuid;
						_tmp21_ = string_strip (_tmp20_);
						_tmp22_ = _tmp21_;
						_tmp18_ = g_strcmp0 (_tmp22_, "") == 0;
						_g_free0 (_tmp22_);
					}
					if (_tmp18_) {
						const gchar* _tmp23_;
						_tmp23_ = id;
						g_warning ("panel.vala:668: Could not add new applet %s from config %s", _tmp23_, name);
						_g_free0 (id);
						_g_free0 (_tmp14_);
						_g_free0 (alignment);
						_g_free0 (uuid);
						_g_object_unref0 (info);
						_g_free0 (appl);
						continue;
					}
					_tmp24_ = uuid;
					_tmp25_ = budgie_applet_info_new_from_uuid (_tmp24_);
					_g_object_unref0 (info);
					info = _tmp25_;
					_tmp27_ = appl;
					_tmp26_ = g_key_file_has_key (config, _tmp27_, "Alignment", &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_free0 (id);
						_g_free0 (_tmp14_);
						_g_free0 (alignment);
						_g_free0 (uuid);
						_g_object_unref0 (info);
						_g_free0 (appl);
						applets = (_vala_array_free (applets, applets_length1, (GDestroyNotify) g_free), NULL);
						goto __catch0_g_error;
					}
					if (_tmp26_) {
						gchar* _tmp28_ = NULL;
						const gchar* _tmp29_;
						gchar* _tmp30_;
						gchar* _tmp31_;
						_tmp29_ = appl;
						_tmp30_ = g_key_file_get_string (config, _tmp29_, "Alignment", &_inner_error0_);
						_tmp28_ = _tmp30_;
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							_g_free0 (id);
							_g_free0 (_tmp14_);
							_g_free0 (alignment);
							_g_free0 (uuid);
							_g_object_unref0 (info);
							_g_free0 (appl);
							applets = (_vala_array_free (applets, applets_length1, (GDestroyNotify) g_free), NULL);
							goto __catch0_g_error;
						}
						_tmp31_ = string_strip (_tmp28_);
						_g_free0 (alignment);
						alignment = _tmp31_;
						_g_free0 (_tmp28_);
					}
					_tmp32_ = alignment;
					_tmp33_ = _tmp32_;
					_tmp35_ = (NULL == _tmp33_) ? 0 : g_quark_from_string (_tmp33_);
					if (_tmp35_ == ((0 != _tmp34_label0) ? _tmp34_label0 : (_tmp34_label0 = g_quark_from_static_string ("center")))) {
						switch (0) {
							default:
							{
								gint _tmp36_;
								c_index = c_index + 1;
								_tmp36_ = c_index;
								index = _tmp36_;
								break;
							}
						}
					} else if (_tmp35_ == ((0 != _tmp34_label1) ? _tmp34_label1 : (_tmp34_label1 = g_quark_from_static_string ("end")))) {
						switch (0) {
							default:
							{
								gint _tmp37_;
								e_index = e_index + 1;
								_tmp37_ = e_index;
								index = _tmp37_;
								break;
							}
						}
					} else {
						switch (0) {
							default:
							{
								gint _tmp38_;
								s_index = s_index + 1;
								_tmp38_ = s_index;
								index = _tmp38_;
								break;
							}
						}
					}
					_tmp39_ = info;
					_tmp40_ = alignment;
					g_object_set (_tmp39_, "alignment", _tmp40_, NULL);
					_tmp41_ = info;
					g_object_set (_tmp41_, "position", index, NULL);
					_tmp42_ = self->priv->initial_config;
					_tmp43_ = uuid;
					_tmp44_ = g_strdup (_tmp43_);
					_tmp45_ = info;
					_tmp46_ = _g_object_ref0 (_tmp45_);
					g_hash_table_insert (_tmp42_, _tmp44_, _tmp46_);
					_tmp47_ = id;
					_tmp48_ = uuid;
					budgie_panel_add_new (self, _tmp47_, _tmp48_);
					_g_free0 (id);
					_g_free0 (_tmp14_);
					_g_free0 (alignment);
					_g_free0 (uuid);
					_g_object_unref0 (info);
					_g_free0 (appl);
				}
			}
		}
		applets = (_vala_array_free (applets, applets_length1, (GDestroyNotify) g_free), NULL);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp49_;
		const gchar* _tmp50_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp49_ = e;
		_tmp50_ = _tmp49_->message;
		g_warning ("panel.vala:695: Error loading default config: %s", _tmp50_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
budgie_panel_toggle_container_visibilities (BudgiePanel* self)
{
	GtkBox** regions = NULL;
	GtkBox* _tmp0_;
	GtkBox* _tmp1_;
	GtkBox* _tmp2_;
	GtkBox* _tmp3_;
	GtkBox* _tmp4_;
	GtkBox* _tmp5_;
	GtkBox** _tmp6_;
	gint regions_length1;
	gint _regions_size_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->start_box;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_tmp2_ = self->priv->center_box;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_tmp4_ = self->priv->end_box;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_tmp6_ = g_new0 (GtkBox*, 3 + 1);
	_tmp6_[0] = _tmp1_;
	_tmp6_[1] = _tmp3_;
	_tmp6_[2] = _tmp5_;
	regions = _tmp6_;
	regions_length1 = 3;
	_regions_size_ = regions_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp7_ = FALSE;
			_tmp7_ = TRUE;
			while (TRUE) {
				GtkBox** _tmp9_;
				gint _tmp9__length1;
				GtkBox* region = NULL;
				GtkBox** _tmp10_;
				gint _tmp10__length1;
				GtkBox* _tmp11_;
				GtkBox* _tmp12_;
				GtkBox* _tmp13_;
				GList* _tmp14_;
				GList* _tmp15_;
				gboolean _tmp16_;
				if (!_tmp7_) {
					gint _tmp8_;
					_tmp8_ = i;
					i = _tmp8_ + 1;
				}
				_tmp7_ = FALSE;
				_tmp9_ = regions;
				_tmp9__length1 = regions_length1;
				if (!(i < _tmp9__length1)) {
					break;
				}
				_tmp10_ = regions;
				_tmp10__length1 = regions_length1;
				_tmp11_ = _tmp10_[i];
				_tmp12_ = _g_object_ref0 (_tmp11_);
				region = _tmp12_;
				_tmp13_ = region;
				_tmp14_ = gtk_container_get_children ((GtkContainer*) _tmp13_);
				_tmp15_ = _tmp14_;
				_tmp16_ = g_list_length (_tmp15_) > ((guint) 0);
				(_tmp15_ == NULL) ? NULL : (_tmp15_ = (g_list_free (_tmp15_), NULL));
				if (_tmp16_) {
					GtkBox* _tmp17_;
					_tmp17_ = region;
					if (!gtk_widget_get_visible ((GtkWidget*) _tmp17_)) {
						GtkBox* _tmp18_;
						GtkBox* _tmp19_;
						_tmp18_ = region;
						gtk_widget_show ((GtkWidget*) _tmp18_);
						_tmp19_ = region;
						gtk_widget_queue_draw ((GtkWidget*) _tmp19_);
					}
				} else {
					GtkBox* _tmp20_;
					_tmp20_ = region;
					gtk_widget_hide ((GtkWidget*) _tmp20_);
				}
				_g_object_unref0 (region);
			}
		}
	}
	regions = (_vala_array_free (regions, regions_length1, (GDestroyNotify) g_object_unref), NULL);
}

static void
_vala_array_add3 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
budgie_panel_set_applets (BudgiePanel* self)
{
	gchar** uuids = NULL;
	gint uuids_length1;
	gint _uuids_size_;
	const gchar* uuid = NULL;
	BudgieAppletInfo* plugin = NULL;
	GHashTableIter iter = {0};
	GHashTable* _tmp0_;
	GSettings* _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	g_return_if_fail (self != NULL);
	uuids = NULL;
	uuids_length1 = 0;
	_uuids_size_ = uuids_length1;
	uuid = NULL;
	plugin = NULL;
	_tmp0_ = self->priv->applets;
	g_hash_table_iter_init (&iter, _tmp0_);
	while (TRUE) {
		gconstpointer _tmp1_ = NULL;
		gconstpointer _tmp2_ = NULL;
		gboolean _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp3_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp1_), (gpointer*) (&_tmp2_));
		uuid = _tmp1_;
		plugin = _tmp2_;
		if (!_tmp3_) {
			break;
		}
		_tmp4_ = uuid;
		_tmp5_ = g_strdup (_tmp4_);
		_vala_array_add3 (&uuids, &uuids_length1, &_uuids_size_, _tmp5_);
	}
	_tmp6_ = self->priv->_settings;
	_tmp7_ = uuids;
	_tmp7__length1 = uuids_length1;
	g_settings_set_strv (_tmp6_, BUDGIE_PANEL_KEY_APPLETS, _tmp7_);
	uuids = (_vala_array_free (uuids, uuids_length1, (GDestroyNotify) g_free), NULL);
}

static void
budgie_panel_real_remove_applet (BudgieToplevel* base,
                                 BudgieAppletInfo* info)
{
	BudgiePanel * self;
	gint position = 0;
	gint _tmp0_;
	gint _tmp1_;
	gchar* alignment = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* uuid = NULL;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gulong notify_id = 0UL;
	gconstpointer _tmp6_;
	GtkBox* applet_parent = NULL;
	BudgieApplet* _tmp7_;
	BudgieApplet* _tmp8_;
	BudgieApplet* _tmp9_;
	GtkContainer* _tmp10_;
	GtkBox* _tmp11_;
	GtkBox* _tmp12_;
	GtkBox* _tmp13_;
	BudgieApplet* _tmp14_;
	BudgieApplet* _tmp15_;
	BudgieApplet* _tmp16_;
	GSettings* app_settings = NULL;
	BudgieApplet* _tmp17_;
	BudgieApplet* _tmp18_;
	BudgieApplet* _tmp19_;
	const gchar* _tmp20_;
	GSettings* _tmp21_;
	GSettings* _tmp22_;
	GSettings* _tmp23_;
	BudgiePanelManager* _tmp25_;
	GSettings* _tmp26_;
	GSettings* _tmp27_;
	GSettings* _tmp28_;
	GHashTable* _tmp29_;
	const gchar* _tmp30_;
	const gchar* _tmp31_;
	GSettings* _tmp32_;
	const gchar* _tmp35_;
	self = (BudgiePanel*) base;
	if (info == NULL) {
		return;
	}
	g_object_get (info, "position", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	position = _tmp1_;
	g_object_get (info, "alignment", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	alignment = _tmp3_;
	g_object_get (info, "uuid", &_tmp4_, NULL);
	_tmp5_ = _tmp4_;
	uuid = _tmp5_;
	_tmp6_ = g_object_get_data ((GObject*) info, "notify_id");
	notify_id = (gulong) ((guintptr) _tmp6_);
	g_signal_handler_disconnect (info, notify_id);
	g_object_get (info, "applet", &_tmp7_, NULL);
	_tmp8_ = _tmp7_;
	_tmp9_ = _tmp8_;
	_tmp10_ = gtk_widget_get_parent ((GtkWidget*) _tmp9_);
	_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_box_get_type (), GtkBox));
	_tmp12_ = _tmp11_;
	_g_object_unref0 (_tmp9_);
	applet_parent = _tmp12_;
	_tmp13_ = applet_parent;
	g_object_get (info, "applet", &_tmp14_, NULL);
	_tmp15_ = _tmp14_;
	_tmp16_ = _tmp15_;
	gtk_container_remove ((GtkContainer*) _tmp13_, (GtkWidget*) _tmp16_);
	_g_object_unref0 (_tmp16_);
	budgie_panel_toggle_container_visibilities (self);
	g_object_get (info, "applet", &_tmp17_, NULL);
	_tmp18_ = _tmp17_;
	_tmp19_ = _tmp18_;
	_tmp20_ = uuid;
	_tmp21_ = budgie_applet_get_applet_settings (_tmp19_, _tmp20_);
	_tmp22_ = _tmp21_;
	_g_object_unref0 (_tmp19_);
	app_settings = _tmp22_;
	_tmp23_ = app_settings;
	if (_tmp23_ != NULL) {
		GSettings* _tmp24_;
		_tmp24_ = app_settings;
		g_object_ref ((GObject*) _tmp24_);
	}
	_tmp25_ = self->priv->manager;
	g_object_get (info, "settings", &_tmp26_, NULL);
	_tmp27_ = _tmp26_;
	_tmp28_ = _tmp27_;
	budgie_panel_manager_reset_dconf_path (_tmp25_, _tmp28_);
	_g_object_unref0 (_tmp28_);
	_tmp29_ = self->priv->applets;
	_tmp30_ = uuid;
	g_hash_table_remove (_tmp29_, _tmp30_);
	_tmp31_ = uuid;
	g_signal_emit_by_name ((BudgieToplevel*) self, "applet-removed", _tmp31_);
	_tmp32_ = app_settings;
	if (_tmp32_ != NULL) {
		BudgiePanelManager* _tmp33_;
		GSettings* _tmp34_;
		_tmp33_ = self->priv->manager;
		_tmp34_ = app_settings;
		budgie_panel_manager_reset_dconf_path (_tmp33_, _tmp34_);
	}
	budgie_panel_set_applets (self);
	_tmp35_ = alignment;
	budgie_panel_budge_em_left (self, _tmp35_, position);
	_g_object_unref0 (app_settings);
	_g_object_unref0 (applet_parent);
	_g_free0 (uuid);
	_g_free0 (alignment);
}

static void
_budgie_panel_applet_updated_g_object_notify (GObject* _sender,
                                              GParamSpec* pspec,
                                              gpointer self)
{
	budgie_panel_applet_updated ((BudgiePanel*) self, _sender, pspec);
}

static void
budgie_panel_add_applet (BudgiePanel* self,
                         BudgieAppletInfo* info)
{
	GtkBox* pack_target = NULL;
	BudgieAppletInfo* initial_info = NULL;
	GHashTable* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gconstpointer _tmp4_;
	BudgieAppletInfo* _tmp5_;
	BudgieAppletInfo* _tmp6_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	GQuark _tmp33_ = 0U;
	static GQuark _tmp32_label0 = 0;
	static GQuark _tmp32_label1 = 0;
	GHashTable* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	BudgieAppletInfo* _tmp40_;
	BudgieApplet* _tmp41_;
	BudgieApplet* _tmp42_;
	BudgieApplet* _tmp43_;
	BudgiePopoverManager* _tmp44_;
	BudgieApplet* _tmp45_;
	BudgieApplet* _tmp46_;
	BudgieApplet* _tmp47_;
	gint _tmp48_;
	gint _tmp49_;
	BudgieApplet* _tmp50_;
	BudgieApplet* _tmp51_;
	BudgieApplet* _tmp52_;
	BudgiePanelPosition _tmp53_;
	BudgiePanelPosition _tmp54_;
	GtkBox* _tmp55_;
	BudgieApplet* _tmp56_;
	BudgieApplet* _tmp57_;
	BudgieApplet* _tmp58_;
	GtkBox* _tmp59_;
	BudgieApplet* _tmp60_;
	BudgieApplet* _tmp61_;
	BudgieApplet* _tmp62_;
	gint _tmp63_;
	gint _tmp64_;
	gulong id = 0UL;
	gulong _tmp65_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	pack_target = NULL;
	initial_info = NULL;
	_tmp0_ = self->priv->initial_config;
	g_object_get (info, "uuid", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = g_hash_table_lookup (_tmp0_, _tmp3_);
	_tmp5_ = _g_object_ref0 ((BudgieAppletInfo*) _tmp4_);
	_g_object_unref0 (initial_info);
	initial_info = _tmp5_;
	_g_free0 (_tmp3_);
	_tmp6_ = initial_info;
	if (_tmp6_ != NULL) {
		BudgieAppletInfo* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		BudgieAppletInfo* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		GHashTable* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		_tmp7_ = initial_info;
		g_object_get (_tmp7_, "alignment", &_tmp8_, NULL);
		_tmp9_ = _tmp8_;
		_tmp10_ = _tmp9_;
		g_object_set (info, "alignment", _tmp10_, NULL);
		_g_free0 (_tmp10_);
		_tmp11_ = initial_info;
		g_object_get (_tmp11_, "position", &_tmp12_, NULL);
		_tmp13_ = _tmp12_;
		g_object_set (info, "position", _tmp13_, NULL);
		_tmp14_ = self->priv->initial_config;
		g_object_get (info, "uuid", &_tmp15_, NULL);
		_tmp16_ = _tmp15_;
		_tmp17_ = _tmp16_;
		g_hash_table_remove (_tmp14_, _tmp17_);
		_g_free0 (_tmp17_);
	}
	if (!self->priv->is_fully_loaded) {
		{
			GList* _tmp18_;
			_tmp18_ = self->priv->expected_uuids;
			g_rec_mutex_lock (&self->priv->__lock_expected_uuids);
			{
				GList* exp_fin = NULL;
				GList* _tmp19_;
				gchar* _tmp20_;
				gchar* _tmp21_;
				gchar* _tmp22_;
				GCompareFunc _tmp23_;
				GList* _tmp24_;
				GList* _tmp25_;
				GList* _tmp26_;
				_tmp19_ = self->priv->expected_uuids;
				g_object_get (info, "uuid", &_tmp20_, NULL);
				_tmp21_ = _tmp20_;
				_tmp22_ = _tmp21_;
				_tmp23_ = ((GCompareFunc) g_strcmp0);
				_tmp24_ = g_list_find_custom (_tmp19_, _tmp22_, _tmp23_);
				_tmp25_ = _tmp24_;
				_g_free0 (_tmp22_);
				exp_fin = _tmp25_;
				_tmp26_ = exp_fin;
				if (_tmp26_ != NULL) {
					GList* _tmp27_;
					_tmp27_ = exp_fin;
					self->priv->expected_uuids = g_list_remove_link (self->priv->expected_uuids, _tmp27_);
				}
			}
			__finally0:
			{
				GList* _tmp28_;
				_tmp28_ = self->priv->expected_uuids;
				g_rec_mutex_unlock (&self->priv->__lock_expected_uuids);
			}
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (initial_info);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
	g_object_get (info, "alignment", &_tmp29_, NULL);
	_tmp30_ = _tmp29_;
	_tmp31_ = _tmp30_;
	_tmp33_ = (NULL == _tmp31_) ? 0 : g_quark_from_string (_tmp31_);
	g_free (_tmp31_);
	if (_tmp33_ == ((0 != _tmp32_label0) ? _tmp32_label0 : (_tmp32_label0 = g_quark_from_static_string ("start")))) {
		switch (0) {
			default:
			{
				GtkBox* _tmp34_;
				_tmp34_ = self->priv->start_box;
				pack_target = _tmp34_;
				break;
			}
		}
	} else if (_tmp33_ == ((0 != _tmp32_label1) ? _tmp32_label1 : (_tmp32_label1 = g_quark_from_static_string ("end")))) {
		switch (0) {
			default:
			{
				GtkBox* _tmp35_;
				_tmp35_ = self->priv->end_box;
				pack_target = _tmp35_;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				GtkBox* _tmp36_;
				_tmp36_ = self->priv->center_box;
				pack_target = _tmp36_;
				break;
			}
		}
	}
	_tmp37_ = self->priv->applets;
	g_object_get (info, "uuid", &_tmp38_, NULL);
	_tmp39_ = _tmp38_;
	_tmp40_ = _g_object_ref0 (info);
	g_hash_table_insert (_tmp37_, _tmp39_, _tmp40_);
	budgie_panel_set_applets (self);
	g_object_get (info, "applet", &_tmp41_, NULL);
	_tmp42_ = _tmp41_;
	_tmp43_ = _tmp42_;
	_tmp44_ = self->priv->popover_manager;
	budgie_applet_update_popovers (_tmp43_, _tmp44_);
	_g_object_unref0 (_tmp43_);
	g_object_get (info, "applet", &_tmp45_, NULL);
	_tmp46_ = _tmp45_;
	_tmp47_ = _tmp46_;
	_tmp48_ = budgie_toplevel_get_intended_size ((BudgieToplevel*) self);
	_tmp49_ = _tmp48_;
	g_signal_emit_by_name (_tmp47_, "panel-size-changed", _tmp49_, self->priv->current_icon_size, self->priv->current_small_icon_size);
	_g_object_unref0 (_tmp47_);
	g_object_get (info, "applet", &_tmp50_, NULL);
	_tmp51_ = _tmp50_;
	_tmp52_ = _tmp51_;
	_tmp53_ = budgie_toplevel_get_position ((BudgieToplevel*) self);
	_tmp54_ = _tmp53_;
	g_signal_emit_by_name (_tmp52_, "panel-position-changed", _tmp54_);
	_g_object_unref0 (_tmp52_);
	_tmp55_ = pack_target;
	g_object_get (info, "applet", &_tmp56_, NULL);
	_tmp57_ = _tmp56_;
	_tmp58_ = _tmp57_;
	gtk_box_pack_start (_tmp55_, (GtkWidget*) _tmp58_, FALSE, FALSE, (guint) 0);
	_g_object_unref0 (_tmp58_);
	_tmp59_ = pack_target;
	g_object_get (info, "applet", &_tmp60_, NULL);
	_tmp61_ = _tmp60_;
	_tmp62_ = _tmp61_;
	g_object_get (info, "position", &_tmp63_, NULL);
	_tmp64_ = _tmp63_;
	gtk_container_child_set ((GtkContainer*) _tmp59_, (GtkWidget*) _tmp62_, "position", _tmp64_, NULL);
	_g_object_unref0 (_tmp62_);
	budgie_panel_toggle_container_visibilities (self);
	_tmp65_ = g_signal_connect_object ((GObject*) info, "notify", (GCallback) _budgie_panel_applet_updated_g_object_notify, self, 0);
	id = _tmp65_;
	g_object_set_data_full ((GObject*) info, "notify_id", (gpointer) ((guintptr) id), NULL);
	g_signal_emit_by_name ((BudgieToplevel*) self, "applet-added", info);
	if (self->priv->is_fully_loaded) {
		_g_object_unref0 (initial_info);
		return;
	}
	{
		GList* _tmp66_;
		_tmp66_ = self->priv->expected_uuids;
		g_rec_mutex_lock (&self->priv->__lock_expected_uuids);
		{
			GList* _tmp67_;
			_tmp67_ = self->priv->expected_uuids;
			if (g_list_length (_tmp67_) == ((guint) 0)) {
				self->priv->is_fully_loaded = TRUE;
				g_signal_emit (self, budgie_panel_signals[BUDGIE_PANEL_PANEL_LOADED_SIGNAL], 0);
			}
		}
		__finally1:
		{
			GList* _tmp68_;
			_tmp68_ = self->priv->expected_uuids;
			g_rec_mutex_unlock (&self->priv->__lock_expected_uuids);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (initial_info);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_g_object_unref0 (initial_info);
}

static void
budgie_panel_applet_reparent (BudgiePanel* self,
                              BudgieAppletInfo* info)
{
	GtkBox* new_parent = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GQuark _tmp4_ = 0U;
	static GQuark _tmp3_label0 = 0;
	static GQuark _tmp3_label1 = 0;
	GtkBox* current_parent = NULL;
	BudgieApplet* _tmp8_;
	BudgieApplet* _tmp9_;
	BudgieApplet* _tmp10_;
	GtkContainer* _tmp11_;
	GtkBox* _tmp12_;
	GtkBox* _tmp13_;
	GtkBox* _tmp14_;
	GtkBox* _tmp15_;
	g_return_if_fail (self != NULL);
	new_parent = NULL;
	g_object_get (info, "alignment", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp4_ = (NULL == _tmp2_) ? 0 : g_quark_from_string (_tmp2_);
	g_free (_tmp2_);
	if (_tmp4_ == ((0 != _tmp3_label0) ? _tmp3_label0 : (_tmp3_label0 = g_quark_from_static_string ("start")))) {
		switch (0) {
			default:
			{
				GtkBox* _tmp5_;
				_tmp5_ = self->priv->start_box;
				new_parent = _tmp5_;
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label1) ? _tmp3_label1 : (_tmp3_label1 = g_quark_from_static_string ("end")))) {
		switch (0) {
			default:
			{
				GtkBox* _tmp6_;
				_tmp6_ = self->priv->end_box;
				new_parent = _tmp6_;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				GtkBox* _tmp7_;
				_tmp7_ = self->priv->center_box;
				new_parent = _tmp7_;
				break;
			}
		}
	}
	g_object_get (info, "applet", &_tmp8_, NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = _tmp9_;
	_tmp11_ = gtk_widget_get_parent ((GtkWidget*) _tmp10_);
	_tmp12_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_box_get_type (), GtkBox));
	_tmp13_ = _tmp12_;
	_g_object_unref0 (_tmp10_);
	current_parent = _tmp13_;
	_tmp14_ = new_parent;
	_tmp15_ = current_parent;
	if (_tmp14_ != _tmp15_) {
		GtkBox* _tmp16_;
		BudgieApplet* _tmp17_;
		BudgieApplet* _tmp18_;
		BudgieApplet* _tmp19_;
		GtkBox* _tmp20_;
		BudgieApplet* _tmp21_;
		BudgieApplet* _tmp22_;
		BudgieApplet* _tmp23_;
		BudgieApplet* _tmp24_;
		BudgieApplet* _tmp25_;
		BudgieApplet* _tmp26_;
		_tmp16_ = current_parent;
		g_object_get (info, "applet", &_tmp17_, NULL);
		_tmp18_ = _tmp17_;
		_tmp19_ = _tmp18_;
		gtk_container_remove ((GtkContainer*) _tmp16_, (GtkWidget*) _tmp19_);
		_g_object_unref0 (_tmp19_);
		_tmp20_ = new_parent;
		g_object_get (info, "applet", &_tmp21_, NULL);
		_tmp22_ = _tmp21_;
		_tmp23_ = _tmp22_;
		gtk_container_add ((GtkContainer*) _tmp20_, (GtkWidget*) _tmp23_);
		_g_object_unref0 (_tmp23_);
		budgie_panel_toggle_container_visibilities (self);
		g_object_get (info, "applet", &_tmp24_, NULL);
		_tmp25_ = _tmp24_;
		_tmp26_ = _tmp25_;
		gtk_widget_queue_resize ((GtkWidget*) _tmp26_);
		_g_object_unref0 (_tmp26_);
	}
	_g_object_unref0 (current_parent);
}

static void
budgie_panel_applet_reposition (BudgiePanel* self,
                                BudgieAppletInfo* info)
{
	BudgieApplet* _tmp0_;
	BudgieApplet* _tmp1_;
	BudgieApplet* _tmp2_;
	GtkContainer* _tmp3_;
	BudgieApplet* _tmp4_;
	BudgieApplet* _tmp5_;
	BudgieApplet* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	g_return_if_fail (self != NULL);
	g_object_get (info, "applet", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = gtk_widget_get_parent ((GtkWidget*) _tmp2_);
	g_object_get (info, "applet", &_tmp4_, NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_;
	g_object_get (info, "position", &_tmp7_, NULL);
	_tmp8_ = _tmp7_;
	gtk_container_child_set (_tmp3_, (GtkWidget*) _tmp6_, "position", _tmp8_, NULL);
	_g_object_unref0 (_tmp6_);
	_g_object_unref0 (_tmp2_);
	budgie_panel_toggle_container_visibilities (self);
}

static void
budgie_panel_applet_updated (BudgiePanel* self,
                             GObject* o,
                             GParamSpec* p)
{
	BudgieAppletInfo* info = NULL;
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (o != NULL);
	g_return_if_fail (p != NULL);
	info = G_TYPE_CHECK_INSTANCE_TYPE (o, budgie_applet_info_get_type ()) ? ((BudgieAppletInfo*) o) : NULL;
	if (!self->priv->is_fully_loaded) {
		return;
	}
	_tmp0_ = p->name;
	if (g_strcmp0 (_tmp0_, "alignment") == 0) {
		BudgieAppletInfo* _tmp1_;
		_tmp1_ = info;
		budgie_panel_applet_reparent (self, _tmp1_);
	} else {
		const gchar* _tmp2_;
		_tmp2_ = p->name;
		if (g_strcmp0 (_tmp2_, "position") == 0) {
			BudgieAppletInfo* _tmp3_;
			_tmp3_ = info;
			budgie_panel_applet_reposition (self, _tmp3_);
		}
	}
	g_signal_emit_by_name ((BudgieToplevel*) self, "applets-changed");
}

static void
budgie_panel_add_new (BudgiePanel* self,
                      const gchar* plugin_name,
                      const gchar* initial_uuid)
{
	gchar* uuid = NULL;
	GHashTable* table = NULL;
	BudgiePanelManager* _tmp0_;
	BudgiePanelManager* _tmp3_;
	BudgieAppletInfo* info = NULL;
	BudgiePanelManager* _tmp27_;
	const gchar* _tmp28_;
	BudgieAppletInfo* _tmp29_;
	BudgieAppletInfo* _tmp30_;
	BudgieAppletInfo* _tmp31_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (plugin_name != NULL);
	uuid = NULL;
	table = NULL;
	_tmp0_ = self->priv->manager;
	if (!budgie_panel_manager_is_extension_valid (_tmp0_, plugin_name)) {
		g_warning ("panel.vala:877: Not loading invalid plugin: %s", plugin_name);
		_g_free0 (uuid);
		return;
	}
	if (initial_uuid == NULL) {
		gchar* _tmp1_;
		_tmp1_ = uuid_new (UUID_UUID_FLAGS_LOWER_CASE | UUID_UUID_FLAGS_TIME_SAFE_TYPE);
		_g_free0 (uuid);
		uuid = _tmp1_;
	} else {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (initial_uuid);
		_g_free0 (uuid);
		uuid = _tmp2_;
	}
	_tmp3_ = self->priv->manager;
	if (!budgie_panel_manager_is_extension_loaded (_tmp3_, plugin_name)) {
		GHashTable* _tmp4_;
		gconstpointer _tmp5_;
		GHashTable* _tmp6_;
		GHashTable* _tmp14_;
		gchar* _tmp15_;
		GHashFunc _tmp16_;
		GEqualFunc _tmp17_;
		GHashTable* _tmp18_;
		GHashTable* _tmp19_;
		gconstpointer _tmp20_;
		GHashTable* _tmp21_;
		const gchar* _tmp22_;
		gchar* _tmp23_;
		const gchar* _tmp24_;
		gchar* _tmp25_;
		BudgiePanelManager* _tmp26_;
		_tmp4_ = self->priv->creating;
		_tmp5_ = g_hash_table_lookup (_tmp4_, plugin_name);
		table = (GHashTable*) _tmp5_;
		_tmp6_ = table;
		if (_tmp6_ != NULL) {
			GHashTable* _tmp7_;
			const gchar* _tmp8_;
			_tmp7_ = table;
			_tmp8_ = uuid;
			if (!g_hash_table_contains (_tmp7_, _tmp8_)) {
				GHashTable* _tmp9_;
				const gchar* _tmp10_;
				gchar* _tmp11_;
				const gchar* _tmp12_;
				gchar* _tmp13_;
				_tmp9_ = table;
				_tmp10_ = uuid;
				_tmp11_ = g_strdup (_tmp10_);
				_tmp12_ = uuid;
				_tmp13_ = g_strdup (_tmp12_);
				g_hash_table_insert (_tmp9_, _tmp11_, _tmp13_);
			}
			_g_free0 (uuid);
			return;
		}
		_tmp14_ = self->priv->creating;
		_tmp15_ = g_strdup (plugin_name);
		_tmp16_ = g_str_hash;
		_tmp17_ = g_str_equal;
		_tmp18_ = g_hash_table_new_full (_tmp16_, _tmp17_, _g_free0_, _g_free0_);
		g_hash_table_insert (_tmp14_, _tmp15_, _tmp18_);
		_tmp19_ = self->priv->creating;
		_tmp20_ = g_hash_table_lookup (_tmp19_, plugin_name);
		table = (GHashTable*) _tmp20_;
		_tmp21_ = table;
		_tmp22_ = uuid;
		_tmp23_ = g_strdup (_tmp22_);
		_tmp24_ = uuid;
		_tmp25_ = g_strdup (_tmp24_);
		g_hash_table_insert (_tmp21_, _tmp23_, _tmp25_);
		_tmp26_ = self->priv->manager;
		budgie_panel_manager_modprobe (_tmp26_, plugin_name);
		_g_free0 (uuid);
		return;
	}
	_tmp27_ = self->priv->manager;
	_tmp28_ = uuid;
	_tmp29_ = budgie_panel_manager_create_new_applet (_tmp27_, plugin_name, _tmp28_);
	info = _tmp29_;
	_tmp30_ = info;
	if (_tmp30_ == NULL) {
		g_critical ("panel.vala:905: Failed to load applet when we know it exists");
		_g_object_unref0 (info);
		_g_free0 (uuid);
		return;
	}
	_tmp31_ = info;
	budgie_panel_add_applet (self, _tmp31_);
	_g_object_unref0 (info);
	_g_free0 (uuid);
	return;
}

static BudgieAppletInfo*
budgie_panel_add_pending (BudgiePanel* self,
                          const gchar* uuid,
                          const gchar* plugin_name)
{
	gchar* rname = NULL;
	GHashTable* table = NULL;
	BudgiePanelManager* _tmp0_;
	BudgiePanelManager* _tmp1_;
	BudgieAppletInfo* info = NULL;
	BudgiePanelManager* _tmp20_;
	gchar* _tmp21_ = NULL;
	BudgieAppletInfo* _tmp22_;
	BudgieAppletInfo* _tmp23_;
	BudgieAppletInfo* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (uuid != NULL, NULL);
	g_return_val_if_fail (plugin_name != NULL, NULL);
	rname = NULL;
	table = NULL;
	_tmp0_ = self->priv->manager;
	if (!budgie_panel_manager_is_extension_valid (_tmp0_, plugin_name)) {
		g_warning ("panel.vala:917: Not adding invalid plugin: %s %s", plugin_name, uuid);
		result = NULL;
		_g_free0 (rname);
		return result;
	}
	_tmp1_ = self->priv->manager;
	if (!budgie_panel_manager_is_extension_loaded (_tmp1_, plugin_name)) {
		GHashTable* _tmp2_;
		gconstpointer _tmp3_;
		GHashTable* _tmp4_;
		GHashTable* _tmp9_;
		gchar* _tmp10_;
		GHashFunc _tmp11_;
		GEqualFunc _tmp12_;
		GHashTable* _tmp13_;
		GHashTable* _tmp14_;
		gconstpointer _tmp15_;
		GHashTable* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		BudgiePanelManager* _tmp19_;
		_tmp2_ = self->priv->pending;
		_tmp3_ = g_hash_table_lookup (_tmp2_, plugin_name);
		table = (GHashTable*) _tmp3_;
		_tmp4_ = table;
		if (_tmp4_ != NULL) {
			GHashTable* _tmp5_;
			_tmp5_ = table;
			if (!g_hash_table_contains (_tmp5_, uuid)) {
				GHashTable* _tmp6_;
				gchar* _tmp7_;
				gchar* _tmp8_;
				_tmp6_ = table;
				_tmp7_ = g_strdup (uuid);
				_tmp8_ = g_strdup (uuid);
				g_hash_table_insert (_tmp6_, _tmp7_, _tmp8_);
			}
			result = NULL;
			_g_free0 (rname);
			return result;
		}
		_tmp9_ = self->priv->pending;
		_tmp10_ = g_strdup (plugin_name);
		_tmp11_ = g_str_hash;
		_tmp12_ = g_str_equal;
		_tmp13_ = g_hash_table_new_full (_tmp11_, _tmp12_, _g_free0_, _g_free0_);
		g_hash_table_insert (_tmp9_, _tmp10_, _tmp13_);
		_tmp14_ = self->priv->pending;
		_tmp15_ = g_hash_table_lookup (_tmp14_, plugin_name);
		table = (GHashTable*) _tmp15_;
		_tmp16_ = table;
		_tmp17_ = g_strdup (uuid);
		_tmp18_ = g_strdup (uuid);
		g_hash_table_insert (_tmp16_, _tmp17_, _tmp18_);
		_tmp19_ = self->priv->manager;
		budgie_panel_manager_modprobe (_tmp19_, plugin_name);
		result = NULL;
		_g_free0 (rname);
		return result;
	}
	_tmp20_ = self->priv->manager;
	_tmp22_ = budgie_panel_manager_load_applet_instance (_tmp20_, uuid, &_tmp21_, NULL);
	_g_free0 (rname);
	rname = _tmp21_;
	info = _tmp22_;
	_tmp23_ = info;
	if (_tmp23_ == NULL) {
		g_critical ("panel.vala:941: Failed to load applet when we know it exists");
		result = NULL;
		_g_object_unref0 (info);
		_g_free0 (rname);
		return result;
	}
	result = info;
	_g_free0 (rname);
	return result;
}

static void
budgie_panel_real_map (GtkWidget* base)
{
	BudgiePanel * self;
	self = (BudgiePanel*) base;
	GTK_WIDGET_CLASS (budgie_panel_parent_class)->map ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, BUDGIE_TYPE_TOPLEVEL, BudgieToplevel));
	budgie_panel_placement (self);
}

void
budgie_panel_set_autohide_policy (BudgiePanel* self,
                                  BudgieAutohidePolicy policy)
{
	BudgieAutohidePolicy _tmp0_;
	BudgieAutohidePolicy _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = budgie_toplevel_get_autohide ((BudgieToplevel*) self);
	_tmp1_ = _tmp0_;
	if (policy != _tmp1_) {
		GSettings* _tmp2_;
		_tmp2_ = self->priv->_settings;
		g_settings_set_enum (_tmp2_, BUDGIE_PANEL_KEY_AUTOHIDE, (gint) policy);
		budgie_toplevel_set_autohide ((BudgieToplevel*) self, policy);
		budgie_panel_apply_strut_policy (self);
		budgie_panel_update_dock_behavior (self);
	}
}

/**
* Update the internal representation of the panel based on whether
* we're in dock mode or not
*/
static void
budgie_panel_update_dock_mode (BudgiePanel* self)
{
	BudgieMainPanel* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->layout;
	_tmp1_ = budgie_toplevel_get_dock_mode ((BudgieToplevel*) self);
	_tmp2_ = _tmp1_;
	budgie_main_panel_set_dock_mode (_tmp0_, _tmp2_);
	budgie_panel_placement (self);
}

static void
budgie_panel_update_screen_edge (BudgiePanel* self)
{
	GtkAllocation alloc = {0};
	GtkBox* _tmp0_;
	GtkAllocation _tmp1_ = {0};
	gint x = 0;
	gint y = 0;
	gint nx = 0;
	gint ny = 0;
	gint nw = 0;
	gint nh = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gboolean _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp56_ = FALSE;
	gboolean _tmp57_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->main_layout;
	gtk_widget_get_allocation ((GtkWidget*) _tmp0_, &_tmp1_);
	alloc = _tmp1_;
	x = 0;
	y = 0;
	nx = 0;
	ny = 0;
	nw = 0;
	nh = 0;
	gtk_window_get_position ((GtkWindow*) self, &_tmp2_, &_tmp3_);
	nx = _tmp2_;
	ny = _tmp3_;
	gtk_window_get_size ((GtkWindow*) self, &_tmp4_, &_tmp5_);
	nw = _tmp4_;
	nh = _tmp5_;
	_tmp6_ = budgie_toplevel_get_dock_mode ((BudgieToplevel*) self);
	_tmp7_ = _tmp6_;
	if (_tmp7_) {
		BudgiePanelPosition _tmp8_;
		BudgiePanelPosition _tmp9_;
		_tmp8_ = budgie_toplevel_get_position ((BudgieToplevel*) self);
		_tmp9_ = _tmp8_;
		switch (_tmp9_) {
			case BUDGIE_PANEL_POSITION_TOP:
			{
				GdkRectangle _tmp10_;
				GdkRectangle _tmp11_;
				GdkRectangle _tmp12_;
				GtkAllocation _tmp13_;
				GdkRectangle _tmp14_;
				GdkRectangle _tmp16_;
				_tmp10_ = self->priv->orig_scr;
				_tmp11_ = self->priv->orig_scr;
				_tmp12_ = self->priv->orig_scr;
				_tmp13_ = alloc;
				x = (_tmp10_.x / 2) + (((_tmp11_.x + _tmp12_.width) / 2) - (_tmp13_.width / 2));
				_tmp14_ = self->priv->orig_scr;
				if (x < _tmp14_.x) {
					GdkRectangle _tmp15_;
					_tmp15_ = self->priv->orig_scr;
					x = _tmp15_.x;
				}
				_tmp16_ = self->priv->orig_scr;
				y = _tmp16_.y;
				break;
			}
			case BUDGIE_PANEL_POSITION_LEFT:
			{
				GdkRectangle _tmp17_;
				GdkRectangle _tmp18_;
				GdkRectangle _tmp19_;
				GdkRectangle _tmp20_;
				GtkAllocation _tmp21_;
				GdkRectangle _tmp22_;
				_tmp17_ = self->priv->orig_scr;
				x = _tmp17_.x;
				_tmp18_ = self->priv->orig_scr;
				_tmp19_ = self->priv->orig_scr;
				_tmp20_ = self->priv->orig_scr;
				_tmp21_ = alloc;
				y = (_tmp18_.y / 2) + (((_tmp19_.y + _tmp20_.height) / 2) - (_tmp21_.height / 2));
				_tmp22_ = self->priv->orig_scr;
				if (y < _tmp22_.y) {
					GdkRectangle _tmp23_;
					_tmp23_ = self->priv->orig_scr;
					y = _tmp23_.y;
				}
				break;
			}
			case BUDGIE_PANEL_POSITION_RIGHT:
			{
				GdkRectangle _tmp24_;
				GdkRectangle _tmp25_;
				GtkAllocation _tmp26_;
				GdkRectangle _tmp27_;
				GdkRectangle _tmp28_;
				GdkRectangle _tmp29_;
				GtkAllocation _tmp30_;
				GdkRectangle _tmp31_;
				_tmp24_ = self->priv->orig_scr;
				_tmp25_ = self->priv->orig_scr;
				_tmp26_ = alloc;
				x = (_tmp24_.x + _tmp25_.width) - _tmp26_.width;
				_tmp27_ = self->priv->orig_scr;
				_tmp28_ = self->priv->orig_scr;
				_tmp29_ = self->priv->orig_scr;
				_tmp30_ = alloc;
				y = (_tmp27_.y / 2) + (((_tmp28_.y + _tmp29_.height) / 2) - (_tmp30_.height / 2));
				_tmp31_ = self->priv->orig_scr;
				if (y < _tmp31_.y) {
					GdkRectangle _tmp32_;
					_tmp32_ = self->priv->orig_scr;
					y = _tmp32_.y;
				}
				break;
			}
			default:
			case BUDGIE_PANEL_POSITION_BOTTOM:
			{
				GdkRectangle _tmp33_;
				GdkRectangle _tmp34_;
				GdkRectangle _tmp35_;
				GtkAllocation _tmp36_;
				GdkRectangle _tmp37_;
				GdkRectangle _tmp38_;
				GtkAllocation _tmp39_;
				GdkRectangle _tmp40_;
				_tmp33_ = self->priv->orig_scr;
				_tmp34_ = self->priv->orig_scr;
				_tmp35_ = self->priv->orig_scr;
				_tmp36_ = alloc;
				x = (_tmp33_.x / 2) + (((_tmp34_.x + _tmp35_.width) / 2) - (_tmp36_.width / 2));
				_tmp37_ = self->priv->orig_scr;
				_tmp38_ = self->priv->orig_scr;
				_tmp39_ = alloc;
				y = _tmp37_.y + (_tmp38_.height - _tmp39_.height);
				_tmp40_ = self->priv->orig_scr;
				if (x < _tmp40_.x) {
					GdkRectangle _tmp41_;
					_tmp41_ = self->priv->orig_scr;
					x = _tmp41_.x;
				}
				break;
			}
		}
	} else {
		BudgiePanelPosition _tmp42_;
		BudgiePanelPosition _tmp43_;
		_tmp42_ = budgie_toplevel_get_position ((BudgieToplevel*) self);
		_tmp43_ = _tmp42_;
		switch (_tmp43_) {
			case BUDGIE_PANEL_POSITION_TOP:
			{
				GdkRectangle _tmp44_;
				GdkRectangle _tmp45_;
				_tmp44_ = self->priv->orig_scr;
				x = _tmp44_.x;
				_tmp45_ = self->priv->orig_scr;
				y = _tmp45_.y;
				break;
			}
			case BUDGIE_PANEL_POSITION_LEFT:
			{
				GdkRectangle _tmp46_;
				GdkRectangle _tmp47_;
				_tmp46_ = self->priv->orig_scr;
				x = _tmp46_.x;
				_tmp47_ = self->priv->orig_scr;
				y = _tmp47_.y;
				break;
			}
			case BUDGIE_PANEL_POSITION_RIGHT:
			{
				GdkRectangle _tmp48_;
				GdkRectangle _tmp49_;
				GtkAllocation _tmp50_;
				GdkRectangle _tmp51_;
				_tmp48_ = self->priv->orig_scr;
				_tmp49_ = self->priv->orig_scr;
				_tmp50_ = alloc;
				x = (_tmp48_.x + _tmp49_.width) - _tmp50_.width;
				_tmp51_ = self->priv->orig_scr;
				y = _tmp51_.y;
				break;
			}
			default:
			case BUDGIE_PANEL_POSITION_BOTTOM:
			{
				GdkRectangle _tmp52_;
				GdkRectangle _tmp53_;
				GdkRectangle _tmp54_;
				GtkAllocation _tmp55_;
				_tmp52_ = self->priv->orig_scr;
				x = _tmp52_.x;
				_tmp53_ = self->priv->orig_scr;
				_tmp54_ = self->priv->orig_scr;
				_tmp55_ = alloc;
				y = _tmp53_.y + (_tmp54_.height - _tmp55_.height);
				break;
			}
		}
	}
	if (self->priv->old_width != nw) {
		_tmp56_ = TRUE;
	} else {
		_tmp56_ = self->priv->old_height != nh;
	}
	if (_tmp56_) {
		if (gtk_widget_get_visible ((GtkWidget*) self)) {
			budgie_panel_set_input_region (self);
		}
		self->priv->old_width = nw;
		self->priv->old_height = nh;
	}
	if (nx == x) {
		_tmp57_ = ny == y;
	} else {
		_tmp57_ = FALSE;
	}
	if (_tmp57_) {
		return;
	}
	gtk_window_move ((GtkWindow*) self, x, y);
	gtk_widget_queue_draw ((GtkWidget*) self);
}

static void
budgie_panel_apply_strut_policy (BudgiePanel* self)
{
	BudgieAutohidePolicy _tmp0_;
	BudgieAutohidePolicy _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = budgie_toplevel_get_autohide ((BudgieToplevel*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != BUDGIE_AUTOHIDE_POLICY_NONE) {
		budgie_unset_struts ((GtkWindow*) self);
	} else {
		BudgiePanelPosition _tmp2_;
		BudgiePanelPosition _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		_tmp2_ = budgie_toplevel_get_position ((BudgieToplevel*) self);
		_tmp3_ = _tmp2_;
		_tmp4_ = budgie_toplevel_get_intended_size ((BudgieToplevel*) self);
		_tmp5_ = _tmp4_;
		budgie_set_struts ((GtkWindow*) self, _tmp3_, (glong) _tmp5_);
	}
}

static void
budgie_panel_placement (BudgiePanel* self)
{
	gboolean horizontal = FALSE;
	GtkAllocation alloc = {0};
	GtkBox* _tmp0_;
	GtkAllocation _tmp1_ = {0};
	gint width = 0;
	gint height = 0;
	gint x = 0;
	gint y = 0;
	gint shadow_position = 0;
	BudgiePanelPosition _tmp2_;
	BudgiePanelPosition _tmp3_;
	gboolean _tmp28_;
	gboolean _tmp29_;
	GtkBox* _tmp36_;
	BudgieShadowBlock* _tmp37_;
	BudgieMainPanel* _tmp73_;
	g_return_if_fail (self != NULL);
	budgie_panel_apply_strut_policy (self);
	horizontal = FALSE;
	_tmp0_ = self->priv->main_layout;
	gtk_widget_get_allocation ((GtkWidget*) _tmp0_, &_tmp1_);
	alloc = _tmp1_;
	width = 0;
	height = 0;
	x = 0;
	y = 0;
	shadow_position = 0;
	_tmp2_ = budgie_toplevel_get_position ((BudgieToplevel*) self);
	_tmp3_ = _tmp2_;
	switch (_tmp3_) {
		case BUDGIE_PANEL_POSITION_TOP:
		{
			GdkRectangle _tmp4_;
			GdkRectangle _tmp5_;
			GdkRectangle _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			_tmp4_ = self->priv->orig_scr;
			x = _tmp4_.x;
			_tmp5_ = self->priv->orig_scr;
			y = _tmp5_.y;
			_tmp6_ = self->priv->orig_scr;
			width = _tmp6_.width;
			_tmp7_ = budgie_toplevel_get_intended_size ((BudgieToplevel*) self);
			_tmp8_ = _tmp7_;
			height = _tmp8_;
			shadow_position = 1;
			horizontal = TRUE;
			break;
		}
		case BUDGIE_PANEL_POSITION_LEFT:
		{
			GdkRectangle _tmp9_;
			GdkRectangle _tmp10_;
			gint _tmp11_;
			gint _tmp12_;
			GdkRectangle _tmp13_;
			_tmp9_ = self->priv->orig_scr;
			x = _tmp9_.x;
			_tmp10_ = self->priv->orig_scr;
			y = _tmp10_.y;
			_tmp11_ = budgie_toplevel_get_intended_size ((BudgieToplevel*) self);
			_tmp12_ = _tmp11_;
			width = _tmp12_;
			_tmp13_ = self->priv->orig_scr;
			height = _tmp13_.height;
			shadow_position = 1;
			break;
		}
		case BUDGIE_PANEL_POSITION_RIGHT:
		{
			GdkRectangle _tmp14_;
			GdkRectangle _tmp15_;
			GtkAllocation _tmp16_;
			GdkRectangle _tmp17_;
			gint _tmp18_;
			gint _tmp19_;
			GdkRectangle _tmp20_;
			_tmp14_ = self->priv->orig_scr;
			_tmp15_ = self->priv->orig_scr;
			_tmp16_ = alloc;
			x = (_tmp14_.x + _tmp15_.width) - _tmp16_.width;
			_tmp17_ = self->priv->orig_scr;
			y = _tmp17_.y;
			_tmp18_ = budgie_toplevel_get_intended_size ((BudgieToplevel*) self);
			_tmp19_ = _tmp18_;
			width = _tmp19_;
			_tmp20_ = self->priv->orig_scr;
			height = _tmp20_.height;
			shadow_position = 0;
			break;
		}
		default:
		case BUDGIE_PANEL_POSITION_BOTTOM:
		{
			GdkRectangle _tmp21_;
			GdkRectangle _tmp22_;
			GdkRectangle _tmp23_;
			GtkAllocation _tmp24_;
			GdkRectangle _tmp25_;
			gint _tmp26_;
			gint _tmp27_;
			_tmp21_ = self->priv->orig_scr;
			x = _tmp21_.x;
			_tmp22_ = self->priv->orig_scr;
			_tmp23_ = self->priv->orig_scr;
			_tmp24_ = alloc;
			y = _tmp22_.y + (_tmp23_.height - _tmp24_.height);
			_tmp25_ = self->priv->orig_scr;
			width = _tmp25_.width;
			_tmp26_ = budgie_toplevel_get_intended_size ((BudgieToplevel*) self);
			_tmp27_ = _tmp26_;
			height = _tmp27_;
			shadow_position = 0;
			horizontal = TRUE;
			break;
		}
	}
	_tmp28_ = budgie_toplevel_get_dock_mode ((BudgieToplevel*) self);
	_tmp29_ = _tmp28_;
	if (_tmp29_) {
		if (horizontal) {
			GtkAllocation _tmp30_;
			GdkRectangle _tmp31_;
			_tmp30_ = alloc;
			_tmp31_ = self->priv->orig_scr;
			if (_tmp30_.width > _tmp31_.width) {
				GdkRectangle _tmp32_;
				_tmp32_ = self->priv->orig_scr;
				width = _tmp32_.width;
			} else {
				width = 100;
			}
		} else {
			GtkAllocation _tmp33_;
			GdkRectangle _tmp34_;
			_tmp33_ = alloc;
			_tmp34_ = self->priv->orig_scr;
			if (_tmp33_.height > _tmp34_.height) {
				GdkRectangle _tmp35_;
				_tmp35_ = self->priv->orig_scr;
				height = _tmp35_.height;
			} else {
				height = 100;
			}
		}
	}
	_tmp36_ = self->priv->main_layout;
	_tmp37_ = self->priv->shadow;
	gtk_container_child_set ((GtkContainer*) _tmp36_, (GtkWidget*) _tmp37_, "position", shadow_position, NULL);
	if (horizontal) {
		GtkBox* _tmp38_;
		GtkBox* _tmp39_;
		GtkBox* _tmp40_;
		GtkBox* _tmp41_;
		GtkBox* _tmp42_;
		GtkBox* _tmp43_;
		GtkBox* _tmp44_;
		GtkBox* _tmp45_;
		GtkBox* _tmp46_;
		BudgieMainPanel* _tmp47_;
		GtkBox* _tmp48_;
		GtkBox* _tmp49_;
		gboolean _tmp50_;
		gboolean _tmp51_;
		GtkBox* _tmp54_;
		BudgieMainPanel* _tmp55_;
		_tmp38_ = self->priv->start_box;
		gtk_widget_set_halign ((GtkWidget*) _tmp38_, GTK_ALIGN_START);
		_tmp39_ = self->priv->center_box;
		gtk_widget_set_halign ((GtkWidget*) _tmp39_, GTK_ALIGN_CENTER);
		_tmp40_ = self->priv->end_box;
		gtk_widget_set_halign ((GtkWidget*) _tmp40_, GTK_ALIGN_END);
		_tmp41_ = self->priv->start_box;
		gtk_widget_set_valign ((GtkWidget*) _tmp41_, GTK_ALIGN_FILL);
		_tmp42_ = self->priv->center_box;
		gtk_widget_set_valign ((GtkWidget*) _tmp42_, GTK_ALIGN_FILL);
		_tmp43_ = self->priv->end_box;
		gtk_widget_set_valign ((GtkWidget*) _tmp43_, GTK_ALIGN_FILL);
		_tmp44_ = self->priv->start_box;
		gtk_orientable_set_orientation ((GtkOrientable*) _tmp44_, GTK_ORIENTATION_HORIZONTAL);
		_tmp45_ = self->priv->center_box;
		gtk_orientable_set_orientation ((GtkOrientable*) _tmp45_, GTK_ORIENTATION_HORIZONTAL);
		_tmp46_ = self->priv->end_box;
		gtk_orientable_set_orientation ((GtkOrientable*) _tmp46_, GTK_ORIENTATION_HORIZONTAL);
		_tmp47_ = self->priv->layout;
		gtk_orientable_set_orientation ((GtkOrientable*) _tmp47_, GTK_ORIENTATION_HORIZONTAL);
		_tmp48_ = self->priv->main_layout;
		gtk_orientable_set_orientation ((GtkOrientable*) _tmp48_, GTK_ORIENTATION_VERTICAL);
		_tmp49_ = self->priv->main_layout;
		gtk_widget_set_valign ((GtkWidget*) _tmp49_, GTK_ALIGN_FILL);
		_tmp50_ = budgie_toplevel_get_dock_mode ((BudgieToplevel*) self);
		_tmp51_ = _tmp50_;
		if (_tmp51_) {
			GtkBox* _tmp52_;
			_tmp52_ = self->priv->main_layout;
			gtk_widget_set_halign ((GtkWidget*) _tmp52_, GTK_ALIGN_START);
		} else {
			GtkBox* _tmp53_;
			_tmp53_ = self->priv->main_layout;
			gtk_widget_set_halign ((GtkWidget*) _tmp53_, GTK_ALIGN_FILL);
		}
		_tmp54_ = self->priv->main_layout;
		gtk_widget_set_hexpand ((GtkWidget*) _tmp54_, FALSE);
		_tmp55_ = self->priv->layout;
		gtk_widget_set_valign ((GtkWidget*) _tmp55_, GTK_ALIGN_FILL);
	} else {
		GtkBox* _tmp56_;
		GtkBox* _tmp57_;
		GtkBox* _tmp58_;
		GtkBox* _tmp59_;
		GtkBox* _tmp60_;
		GtkBox* _tmp61_;
		GtkBox* _tmp62_;
		GtkBox* _tmp63_;
		GtkBox* _tmp64_;
		BudgieMainPanel* _tmp65_;
		GtkBox* _tmp66_;
		gboolean _tmp67_;
		gboolean _tmp68_;
		GtkBox* _tmp71_;
		GtkBox* _tmp72_;
		_tmp56_ = self->priv->start_box;
		gtk_widget_set_halign ((GtkWidget*) _tmp56_, GTK_ALIGN_FILL);
		_tmp57_ = self->priv->center_box;
		gtk_widget_set_halign ((GtkWidget*) _tmp57_, GTK_ALIGN_FILL);
		_tmp58_ = self->priv->end_box;
		gtk_widget_set_halign ((GtkWidget*) _tmp58_, GTK_ALIGN_FILL);
		_tmp59_ = self->priv->start_box;
		gtk_widget_set_valign ((GtkWidget*) _tmp59_, GTK_ALIGN_START);
		_tmp60_ = self->priv->center_box;
		gtk_widget_set_valign ((GtkWidget*) _tmp60_, GTK_ALIGN_CENTER);
		_tmp61_ = self->priv->end_box;
		gtk_widget_set_valign ((GtkWidget*) _tmp61_, GTK_ALIGN_END);
		_tmp62_ = self->priv->start_box;
		gtk_orientable_set_orientation ((GtkOrientable*) _tmp62_, GTK_ORIENTATION_VERTICAL);
		_tmp63_ = self->priv->center_box;
		gtk_orientable_set_orientation ((GtkOrientable*) _tmp63_, GTK_ORIENTATION_VERTICAL);
		_tmp64_ = self->priv->end_box;
		gtk_orientable_set_orientation ((GtkOrientable*) _tmp64_, GTK_ORIENTATION_VERTICAL);
		_tmp65_ = self->priv->layout;
		gtk_orientable_set_orientation ((GtkOrientable*) _tmp65_, GTK_ORIENTATION_VERTICAL);
		_tmp66_ = self->priv->main_layout;
		gtk_orientable_set_orientation ((GtkOrientable*) _tmp66_, GTK_ORIENTATION_HORIZONTAL);
		_tmp67_ = budgie_toplevel_get_dock_mode ((BudgieToplevel*) self);
		_tmp68_ = _tmp67_;
		if (_tmp68_) {
			GtkBox* _tmp69_;
			_tmp69_ = self->priv->main_layout;
			gtk_widget_set_valign ((GtkWidget*) _tmp69_, GTK_ALIGN_START);
		} else {
			GtkBox* _tmp70_;
			_tmp70_ = self->priv->main_layout;
			gtk_widget_set_valign ((GtkWidget*) _tmp70_, GTK_ALIGN_FILL);
		}
		_tmp71_ = self->priv->main_layout;
		gtk_widget_set_halign ((GtkWidget*) _tmp71_, GTK_ALIGN_FILL);
		_tmp72_ = self->priv->main_layout;
		gtk_widget_set_hexpand ((GtkWidget*) _tmp72_, TRUE);
	}
	_tmp73_ = self->priv->layout;
	gtk_widget_set_size_request ((GtkWidget*) _tmp73_, width, height);
	gtk_widget_set_size_request ((GtkWidget*) self, width, height);
	budgie_panel_update_screen_edge (self);
}

static gboolean
budgie_panel_applet_at_start_of_region (BudgiePanel* self,
                                        BudgieAppletInfo* info)
{
	gint _tmp0_;
	gint _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_object_get (info, "position", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	result = _tmp1_ == 0;
	return result;
}

static gboolean
budgie_panel_applet_at_end_of_region (BudgiePanel* self,
                                      BudgieAppletInfo* info)
{
	gint _tmp0_;
	gint _tmp1_;
	BudgieApplet* _tmp2_;
	BudgieApplet* _tmp3_;
	BudgieApplet* _tmp4_;
	GtkContainer* _tmp5_;
	GList* _tmp6_;
	GList* _tmp7_;
	gboolean _tmp8_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_object_get (info, "position", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	g_object_get (info, "applet", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp5_ = gtk_widget_get_parent ((GtkWidget*) _tmp4_);
	_tmp6_ = gtk_container_get_children (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = ((guint) _tmp1_) >= (g_list_length (_tmp7_) - 1);
	(_tmp7_ == NULL) ? NULL : (_tmp7_ = (g_list_free (_tmp7_), NULL));
	_g_object_unref0 (_tmp4_);
	result = _tmp8_;
	return result;
}

static gchar*
budgie_panel_get_box_left (BudgiePanel* self,
                           BudgieAppletInfo* info)
{
	GtkWidget* parent = NULL;
	BudgieApplet* _tmp0_;
	BudgieApplet* _tmp1_;
	BudgieApplet* _tmp2_;
	GtkContainer* _tmp3_;
	GtkWidget* _tmp4_;
	GtkBox* _tmp5_;
	gboolean _tmp6_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	parent = NULL;
	g_object_get (info, "applet", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = gtk_widget_get_parent ((GtkWidget*) _tmp2_);
	parent = (GtkWidget*) _tmp3_;
	_tmp4_ = parent;
	_tmp5_ = self->priv->end_box;
	_tmp6_ = _tmp4_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_widget_get_type (), GtkWidget);
	_g_object_unref0 (_tmp2_);
	if (_tmp6_) {
		gchar* _tmp7_;
		_tmp7_ = g_strdup ("center");
		result = _tmp7_;
		return result;
	} else {
		GtkWidget* _tmp8_;
		GtkBox* _tmp9_;
		_tmp8_ = parent;
		_tmp9_ = self->priv->center_box;
		if (_tmp8_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_widget_get_type (), GtkWidget)) {
			gchar* _tmp10_;
			_tmp10_ = g_strdup ("start");
			result = _tmp10_;
			return result;
		} else {
			result = NULL;
			return result;
		}
	}
}

static gchar*
budgie_panel_get_box_right (BudgiePanel* self,
                            BudgieAppletInfo* info)
{
	GtkWidget* parent = NULL;
	BudgieApplet* _tmp0_;
	BudgieApplet* _tmp1_;
	BudgieApplet* _tmp2_;
	GtkContainer* _tmp3_;
	GtkWidget* _tmp4_;
	GtkBox* _tmp5_;
	gboolean _tmp6_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	parent = NULL;
	g_object_get (info, "applet", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = gtk_widget_get_parent ((GtkWidget*) _tmp2_);
	parent = (GtkWidget*) _tmp3_;
	_tmp4_ = parent;
	_tmp5_ = self->priv->start_box;
	_tmp6_ = _tmp4_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_widget_get_type (), GtkWidget);
	_g_object_unref0 (_tmp2_);
	if (_tmp6_) {
		gchar* _tmp7_;
		_tmp7_ = g_strdup ("center");
		result = _tmp7_;
		return result;
	} else {
		GtkWidget* _tmp8_;
		GtkBox* _tmp9_;
		_tmp8_ = parent;
		_tmp9_ = self->priv->center_box;
		if (_tmp8_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_widget_get_type (), GtkWidget)) {
			gchar* _tmp10_;
			_tmp10_ = g_strdup ("end");
			result = _tmp10_;
			return result;
		} else {
			result = NULL;
			return result;
		}
	}
}

static gboolean
budgie_panel_real_can_move_applet_left (BudgieToplevel* base,
                                        BudgieAppletInfo* info)
{
	BudgiePanel * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	self = (BudgiePanel*) base;
	if (!budgie_panel_applet_at_start_of_region (self, info)) {
		result = TRUE;
		return result;
	}
	_tmp0_ = budgie_panel_get_box_left (self, info);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_ != NULL;
	_g_free0 (_tmp1_);
	if (_tmp2_) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static gboolean
budgie_panel_real_can_move_applet_right (BudgieToplevel* base,
                                         BudgieAppletInfo* info)
{
	BudgiePanel * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	self = (BudgiePanel*) base;
	if (!budgie_panel_applet_at_end_of_region (self, info)) {
		result = TRUE;
		return result;
	}
	_tmp0_ = budgie_panel_get_box_right (self, info);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_ != NULL;
	_g_free0 (_tmp1_);
	if (_tmp2_) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static void
budgie_panel_conflict_swap (BudgiePanel* self,
                            BudgieAppletInfo* info,
                            gint old_position)
{
	const gchar* key = NULL;
	BudgieAppletInfo* val = NULL;
	BudgieAppletInfo* conflict = NULL;
	GHashTableIter iter = {0};
	GHashTable* _tmp0_;
	BudgieAppletInfo* _tmp21_;
	BudgieAppletInfo* _tmp22_;
	g_return_if_fail (self != NULL);
	conflict = NULL;
	_tmp0_ = self->priv->applets;
	g_hash_table_iter_init (&iter, _tmp0_);
	while (TRUE) {
		gconstpointer _tmp1_ = NULL;
		gconstpointer _tmp2_ = NULL;
		gboolean _tmp3_;
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		BudgieAppletInfo* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gboolean _tmp13_;
		_tmp3_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp1_), (gpointer*) (&_tmp2_));
		key = _tmp1_;
		val = _tmp2_;
		if (!_tmp3_) {
			break;
		}
		_tmp6_ = val;
		g_object_get (_tmp6_, "alignment", &_tmp7_, NULL);
		_tmp8_ = _tmp7_;
		_tmp9_ = _tmp8_;
		g_object_get (info, "alignment", &_tmp10_, NULL);
		_tmp11_ = _tmp10_;
		_tmp12_ = _tmp11_;
		_tmp13_ = g_strcmp0 (_tmp9_, _tmp12_) == 0;
		_g_free0 (_tmp12_);
		_g_free0 (_tmp9_);
		if (_tmp13_) {
			BudgieAppletInfo* _tmp14_;
			gint _tmp15_;
			gint _tmp16_;
			gint _tmp17_;
			gint _tmp18_;
			_tmp14_ = val;
			g_object_get (_tmp14_, "position", &_tmp15_, NULL);
			_tmp16_ = _tmp15_;
			g_object_get (info, "position", &_tmp17_, NULL);
			_tmp18_ = _tmp17_;
			_tmp5_ = _tmp16_ == _tmp18_;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			BudgieAppletInfo* _tmp19_;
			_tmp19_ = val;
			_tmp4_ = info != _tmp19_;
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			BudgieAppletInfo* _tmp20_;
			_tmp20_ = val;
			conflict = _tmp20_;
			break;
		}
	}
	_tmp21_ = conflict;
	if (_tmp21_ == NULL) {
		return;
	}
	_tmp22_ = conflict;
	g_object_set (_tmp22_, "position", old_position, NULL);
}

static void
budgie_panel_budge_em_right (BudgiePanel* self,
                             const gchar* alignment,
                             gint after)
{
	const gchar* key = NULL;
	BudgieAppletInfo* val = NULL;
	GHashTableIter iter = {0};
	GHashTable* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (alignment != NULL);
	_tmp0_ = self->priv->applets;
	g_hash_table_iter_init (&iter, _tmp0_);
	while (TRUE) {
		gconstpointer _tmp1_ = NULL;
		gconstpointer _tmp2_ = NULL;
		gboolean _tmp3_;
		BudgieAppletInfo* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gboolean _tmp8_;
		_tmp3_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp1_), (gpointer*) (&_tmp2_));
		key = _tmp1_;
		val = _tmp2_;
		if (!_tmp3_) {
			break;
		}
		_tmp4_ = val;
		g_object_get (_tmp4_, "alignment", &_tmp5_, NULL);
		_tmp6_ = _tmp5_;
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strcmp0 (_tmp7_, alignment) == 0;
		_g_free0 (_tmp7_);
		if (_tmp8_) {
			BudgieAppletInfo* _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			_tmp9_ = val;
			g_object_get (_tmp9_, "position", &_tmp10_, NULL);
			_tmp11_ = _tmp10_;
			if (_tmp11_ > after) {
				BudgieAppletInfo* _tmp12_;
				gint _tmp13_;
				gint _tmp14_;
				_tmp12_ = val;
				g_object_get (_tmp12_, "position", &_tmp13_, NULL);
				_tmp14_ = _tmp13_;
				g_object_set (_tmp12_, "position", _tmp14_ + 1, NULL);
			}
		}
	}
	budgie_panel_reinforce_positions (self);
}

static void
budgie_panel_budge_em_left (BudgiePanel* self,
                            const gchar* alignment,
                            gint after)
{
	const gchar* key = NULL;
	BudgieAppletInfo* val = NULL;
	GHashTableIter iter = {0};
	GHashTable* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (alignment != NULL);
	_tmp0_ = self->priv->applets;
	g_hash_table_iter_init (&iter, _tmp0_);
	while (TRUE) {
		gconstpointer _tmp1_ = NULL;
		gconstpointer _tmp2_ = NULL;
		gboolean _tmp3_;
		BudgieAppletInfo* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gboolean _tmp8_;
		_tmp3_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp1_), (gpointer*) (&_tmp2_));
		key = _tmp1_;
		val = _tmp2_;
		if (!_tmp3_) {
			break;
		}
		_tmp4_ = val;
		g_object_get (_tmp4_, "alignment", &_tmp5_, NULL);
		_tmp6_ = _tmp5_;
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strcmp0 (_tmp7_, alignment) == 0;
		_g_free0 (_tmp7_);
		if (_tmp8_) {
			BudgieAppletInfo* _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			_tmp9_ = val;
			g_object_get (_tmp9_, "position", &_tmp10_, NULL);
			_tmp11_ = _tmp10_;
			if (_tmp11_ > after) {
				BudgieAppletInfo* _tmp12_;
				gint _tmp13_;
				gint _tmp14_;
				_tmp12_ = val;
				g_object_get (_tmp12_, "position", &_tmp13_, NULL);
				_tmp14_ = _tmp13_;
				g_object_set (_tmp12_, "position", _tmp14_ - 1, NULL);
			}
		}
	}
	budgie_panel_reinforce_positions (self);
}

static void
budgie_panel_reinforce_positions (BudgiePanel* self)
{
	const gchar* key = NULL;
	BudgieAppletInfo* val = NULL;
	GHashTableIter iter = {0};
	GHashTable* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->applets;
	g_hash_table_iter_init (&iter, _tmp0_);
	while (TRUE) {
		gconstpointer _tmp1_ = NULL;
		gconstpointer _tmp2_ = NULL;
		gboolean _tmp3_;
		BudgieAppletInfo* _tmp4_;
		_tmp3_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp1_), (gpointer*) (&_tmp2_));
		key = _tmp1_;
		val = _tmp2_;
		if (!_tmp3_) {
			break;
		}
		_tmp4_ = val;
		budgie_panel_applet_reposition (self, _tmp4_);
	}
	gtk_widget_queue_draw ((GtkWidget*) self);
}

static void
budgie_panel_real_move_applet_left (BudgieToplevel* base,
                                    BudgieAppletInfo* info)
{
	BudgiePanel * self;
	gchar* new_home = NULL;
	gint new_position = 0;
	gint _tmp0_;
	gint _tmp1_;
	gint old_position = 0;
	gint _tmp2_;
	gint _tmp3_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	self = (BudgiePanel*) base;
	new_home = NULL;
	g_object_get (info, "position", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	new_position = _tmp1_;
	g_object_get (info, "position", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	old_position = _tmp3_;
	if (!budgie_panel_applet_at_start_of_region (self, info)) {
		gint _tmp4_;
		_tmp4_ = new_position;
		new_position = _tmp4_ - 1;
		if (new_position < 0) {
			new_position = 0;
		}
		g_object_set (info, "position", new_position, NULL);
		budgie_panel_conflict_swap (self, info, old_position);
		g_signal_emit_by_name ((BudgieToplevel*) self, "applets-changed");
		_g_free0 (new_home);
		return;
	}
	_tmp5_ = budgie_panel_get_box_left (self, info);
	_g_free0 (new_home);
	new_home = _tmp5_;
	_tmp6_ = new_home;
	if (_tmp6_ != NULL) {
		GtkBox* new_parent = NULL;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		GQuark _tmp11_ = 0U;
		static GQuark _tmp10_label0 = 0;
		static GQuark _tmp10_label1 = 0;
		gchar* old_home = NULL;
		gchar* _tmp15_;
		gchar* _tmp16_;
		guint len = 0U;
		GtkBox* _tmp17_;
		GList* _tmp18_;
		GList* _tmp19_;
		guint _tmp20_;
		const gchar* _tmp21_;
		const gchar* _tmp22_;
		new_parent = NULL;
		g_object_get (info, "alignment", &_tmp7_, NULL);
		_tmp8_ = _tmp7_;
		_tmp9_ = _tmp8_;
		_tmp11_ = (NULL == _tmp9_) ? 0 : g_quark_from_string (_tmp9_);
		g_free (_tmp9_);
		if (_tmp11_ == ((0 != _tmp10_label0) ? _tmp10_label0 : (_tmp10_label0 = g_quark_from_static_string ("end")))) {
			switch (0) {
				default:
				{
					GtkBox* _tmp12_;
					_tmp12_ = self->priv->center_box;
					new_parent = _tmp12_;
					break;
				}
			}
		} else if (_tmp11_ == ((0 != _tmp10_label1) ? _tmp10_label1 : (_tmp10_label1 = g_quark_from_static_string ("center")))) {
			switch (0) {
				default:
				{
					GtkBox* _tmp13_;
					_tmp13_ = self->priv->start_box;
					new_parent = _tmp13_;
					break;
				}
			}
		} else {
			switch (0) {
				default:
				{
					GtkBox* _tmp14_;
					_tmp14_ = self->priv->end_box;
					new_parent = _tmp14_;
					break;
				}
			}
		}
		g_object_get (info, "alignment", &_tmp15_, NULL);
		_tmp16_ = _tmp15_;
		old_home = _tmp16_;
		_tmp17_ = new_parent;
		_tmp18_ = gtk_container_get_children ((GtkContainer*) _tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = g_list_length (_tmp19_);
		(_tmp19_ == NULL) ? NULL : (_tmp19_ = (g_list_free (_tmp19_), NULL));
		len = _tmp20_;
		_tmp21_ = new_home;
		g_object_set (info, "alignment", _tmp21_, NULL);
		g_object_set (info, "position", (gint) len, NULL);
		_tmp22_ = old_home;
		budgie_panel_budge_em_left (self, _tmp22_, 0);
		g_signal_emit_by_name ((BudgieToplevel*) self, "applets-changed");
		_g_free0 (old_home);
	}
	_g_free0 (new_home);
}

static void
budgie_panel_real_move_applet_right (BudgieToplevel* base,
                                     BudgieAppletInfo* info)
{
	BudgiePanel * self;
	gchar* new_home = NULL;
	gint new_position = 0;
	gint _tmp0_;
	gint _tmp1_;
	gint old_position = 0;
	gint _tmp2_;
	gint _tmp3_;
	guint len = 0U;
	gchar* _tmp11_;
	const gchar* _tmp12_;
	self = (BudgiePanel*) base;
	new_home = NULL;
	g_object_get (info, "position", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	new_position = _tmp1_;
	g_object_get (info, "position", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	old_position = _tmp3_;
	if (!budgie_panel_applet_at_end_of_region (self, info)) {
		gint _tmp4_;
		BudgieApplet* _tmp5_;
		BudgieApplet* _tmp6_;
		BudgieApplet* _tmp7_;
		GtkContainer* _tmp8_;
		GList* _tmp9_;
		GList* _tmp10_;
		_tmp4_ = new_position;
		new_position = _tmp4_ + 1;
		g_object_get (info, "applet", &_tmp5_, NULL);
		_tmp6_ = _tmp5_;
		_tmp7_ = _tmp6_;
		_tmp8_ = gtk_widget_get_parent ((GtkWidget*) _tmp7_);
		_tmp9_ = gtk_container_get_children (_tmp8_);
		_tmp10_ = _tmp9_;
		len = g_list_length (_tmp10_) - 1;
		(_tmp10_ == NULL) ? NULL : (_tmp10_ = (g_list_free (_tmp10_), NULL));
		_g_object_unref0 (_tmp7_);
		if (((guint) new_position) > len) {
			new_position = (gint) len;
		}
		g_object_set (info, "position", new_position, NULL);
		budgie_panel_conflict_swap (self, info, old_position);
		g_signal_emit_by_name ((BudgieToplevel*) self, "applets-changed");
		_g_free0 (new_home);
		return;
	}
	_tmp11_ = budgie_panel_get_box_right (self, info);
	_g_free0 (new_home);
	new_home = _tmp11_;
	_tmp12_ = new_home;
	if (_tmp12_ != NULL) {
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		_tmp13_ = new_home;
		g_object_set (info, "alignment", _tmp13_, NULL);
		_tmp14_ = new_home;
		budgie_panel_budge_em_right (self, _tmp14_, -1);
		g_object_set (info, "position", 0, NULL);
		budgie_panel_reinforce_positions (self);
		g_signal_emit_by_name ((BudgieToplevel*) self, "applets-changed");
	}
	_g_free0 (new_home);
}

static gboolean
budgie_panel_initial_animation (BudgiePanel* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	self->priv->allow_animation = TRUE;
	self->priv->initial_anim = TRUE;
	budgie_panel_show_panel (self);
	result = FALSE;
	return result;
}

/**
* Remove existing animations
*/
static void
budgie_panel_remove_panel_animations (BudgiePanel* self)
{
	BudgieAnimation* _tmp0_;
	BudgieAnimation* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->dock_animation;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->dock_animation;
	budgie_animation_stop (_tmp1_);
	_g_object_unref0 (self->priv->dock_animation);
	self->priv->dock_animation = NULL;
	self->priv->animation = BUDGIE_PANEL_ANIMATION_NONE;
}

static gboolean
budgie_panel_cursor_within_bounds (BudgiePanel* self)
{
	gint cx = 0;
	gint cy = 0;
	gint x = 0;
	gint y = 0;
	gint w = 0;
	gint h = 0;
	GdkDisplay* display = NULL;
	GdkDisplay* _tmp0_;
	GdkDisplay* _tmp1_;
	GdkDevice* pointer = NULL;
	GdkSeat* seat = NULL;
	GdkDisplay* _tmp2_;
	GdkSeat* _tmp3_;
	GdkSeat* _tmp4_;
	GdkSeat* _tmp5_;
	GdkDevice* _tmp6_;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	GdkDevice* _tmp11_;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	cx = 0;
	cy = 0;
	x = 0;
	y = 0;
	w = 0;
	h = 0;
	_tmp0_ = gtk_widget_get_display ((GtkWidget*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	display = _tmp1_;
	pointer = NULL;
	_tmp2_ = display;
	_tmp3_ = gdk_display_get_default_seat (_tmp2_);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	seat = _tmp4_;
	_tmp5_ = seat;
	_tmp6_ = gdk_seat_get_pointer (_tmp5_);
	pointer = _tmp6_;
	gtk_window_get_position ((GtkWindow*) self, &_tmp7_, &_tmp8_);
	x = _tmp7_;
	y = _tmp8_;
	gtk_window_get_size ((GtkWindow*) self, &_tmp9_, &_tmp10_);
	w = _tmp9_;
	h = _tmp10_;
	_tmp11_ = pointer;
	gdk_device_get_position (_tmp11_, NULL, &_tmp12_, &_tmp13_);
	cx = _tmp12_;
	cy = _tmp13_;
	if (cx >= x) {
		_tmp15_ = cx <= (x + w);
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		gboolean _tmp16_ = FALSE;
		if (cy >= y) {
			_tmp16_ = cy <= (y + h);
		} else {
			_tmp16_ = FALSE;
		}
		_tmp14_ = _tmp16_;
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		result = TRUE;
		_g_object_unref0 (seat);
		_g_object_unref0 (display);
		return result;
	}
	result = FALSE;
	_g_object_unref0 (seat);
	_g_object_unref0 (display);
	return result;
}

/**
* Handle dock like functionality
*/
static gboolean
budgie_panel_update_dock_behavior (BudgiePanel* self)
{
	BudgiePanelAnimation target_state = 0;
	BudgieAutohidePolicy _tmp0_;
	BudgieAutohidePolicy _tmp1_;
	BudgieAutohidePolicy _tmp2_;
	BudgieAutohidePolicy _tmp3_;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	self->priv->update_dock_id = (guint) 0;
	target_state = BUDGIE_PANEL_ANIMATION_NONE;
	_tmp0_ = budgie_toplevel_get_autohide ((BudgieToplevel*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == BUDGIE_AUTOHIDE_POLICY_NONE) {
		budgie_panel_remove_panel_animations (self);
		self->priv->animation = BUDGIE_PANEL_ANIMATION_NONE;
		budgie_panel_placement (self);
		budgie_panel_show_panel (self);
		result = FALSE;
		return result;
	}
	_tmp2_ = budgie_toplevel_get_autohide ((BudgieToplevel*) self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == BUDGIE_AUTOHIDE_POLICY_INTELLIGENT) {
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp4_ = budgie_toplevel_get_intersected ((BudgieToplevel*) self);
		_tmp5_ = _tmp4_;
		if (_tmp5_) {
			target_state = BUDGIE_PANEL_ANIMATION_HIDE;
		} else {
			target_state = BUDGIE_PANEL_ANIMATION_SHOW;
		}
	} else {
		if (self->priv->screen_occluded) {
			target_state = BUDGIE_PANEL_ANIMATION_HIDE;
		} else {
			target_state = BUDGIE_PANEL_ANIMATION_SHOW;
		}
	}
	if (target_state == BUDGIE_PANEL_ANIMATION_SHOW) {
		gdouble _tmp7_;
		gdouble _tmp8_;
		_tmp7_ = budgie_panel_get_nscale (self);
		_tmp8_ = _tmp7_;
		_tmp6_ = _tmp8_ == 1.0;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		result = FALSE;
		return result;
	}
	if (target_state == BUDGIE_PANEL_ANIMATION_HIDE) {
		gdouble _tmp10_;
		gdouble _tmp11_;
		_tmp10_ = budgie_panel_get_nscale (self);
		_tmp11_ = _tmp10_;
		_tmp9_ = _tmp11_ == 0.0;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		result = FALSE;
		return result;
	}
	budgie_panel_remove_panel_animations (self);
	if (target_state == BUDGIE_PANEL_ANIMATION_SHOW) {
		budgie_panel_show_panel (self);
	} else {
		budgie_panel_hide_panel (self);
	}
	result = FALSE;
	return result;
}

/**
* Unset the input region to allow peek events
*/
static void
budgie_panel_unset_input_region (BudgiePanel* self)
{
	cairo_region_t* region = NULL;
	BudgiePanelPosition _tmp0_;
	BudgiePanelPosition _tmp1_;
	GdkWindow* _tmp34_;
	cairo_region_t* _tmp35_;
	g_return_if_fail (self != NULL);
	self->priv->render_panel = FALSE;
	region = NULL;
	_tmp0_ = budgie_toplevel_get_position ((BudgieToplevel*) self);
	_tmp1_ = _tmp0_;
	switch (_tmp1_) {
		case BUDGIE_PANEL_POSITION_TOP:
		{
			gint _tmp2_;
			gint _tmp3_;
			gint _tmp4_;
			gint _tmp5_;
			cairo_rectangle_int_t _tmp6_ = {0};
			cairo_region_t* _tmp7_;
			_tmp2_ = gtk_widget_get_scale_factor ((GtkWidget*) self);
			_tmp3_ = _tmp2_;
			_tmp4_ = gtk_widget_get_scale_factor ((GtkWidget*) self);
			_tmp5_ = _tmp4_;
			memset (&_tmp6_, 0, sizeof (cairo_rectangle_int_t));
			_tmp6_.x = 0;
			_tmp6_.y = 0;
			_tmp6_.width = gtk_widget_get_allocated_width ((GtkWidget*) self) * _tmp3_;
			_tmp6_.height = 1 * _tmp5_;
			_tmp7_ = cairo_region_create_rectangle (&_tmp6_);
			_cairo_region_destroy0 (region);
			region = _tmp7_;
			break;
		}
		case BUDGIE_PANEL_POSITION_LEFT:
		{
			gint _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			cairo_rectangle_int_t _tmp12_ = {0};
			cairo_region_t* _tmp13_;
			_tmp8_ = gtk_widget_get_scale_factor ((GtkWidget*) self);
			_tmp9_ = _tmp8_;
			_tmp10_ = gtk_widget_get_scale_factor ((GtkWidget*) self);
			_tmp11_ = _tmp10_;
			memset (&_tmp12_, 0, sizeof (cairo_rectangle_int_t));
			_tmp12_.x = 0;
			_tmp12_.y = 0;
			_tmp12_.width = 1 * _tmp9_;
			_tmp12_.height = gtk_widget_get_allocated_height ((GtkWidget*) self) * _tmp11_;
			_tmp13_ = cairo_region_create_rectangle (&_tmp12_);
			_cairo_region_destroy0 (region);
			region = _tmp13_;
			break;
		}
		case BUDGIE_PANEL_POSITION_RIGHT:
		{
			gint _tmp14_;
			gint _tmp15_;
			gint _tmp16_;
			gint _tmp17_;
			gint _tmp18_;
			gint _tmp19_;
			gint _tmp20_;
			gint _tmp21_;
			cairo_rectangle_int_t _tmp22_ = {0};
			cairo_region_t* _tmp23_;
			_tmp14_ = gtk_widget_get_scale_factor ((GtkWidget*) self);
			_tmp15_ = _tmp14_;
			_tmp16_ = gtk_widget_get_scale_factor ((GtkWidget*) self);
			_tmp17_ = _tmp16_;
			_tmp18_ = gtk_widget_get_scale_factor ((GtkWidget*) self);
			_tmp19_ = _tmp18_;
			_tmp20_ = gtk_widget_get_scale_factor ((GtkWidget*) self);
			_tmp21_ = _tmp20_;
			memset (&_tmp22_, 0, sizeof (cairo_rectangle_int_t));
			_tmp22_.x = (gtk_widget_get_allocated_width ((GtkWidget*) self) * _tmp15_) - (1 * _tmp17_);
			_tmp22_.y = 0;
			_tmp22_.width = 1 * _tmp19_;
			_tmp22_.height = gtk_widget_get_allocated_height ((GtkWidget*) self) * _tmp21_;
			_tmp23_ = cairo_region_create_rectangle (&_tmp22_);
			_cairo_region_destroy0 (region);
			region = _tmp23_;
			break;
		}
		default:
		case BUDGIE_PANEL_POSITION_BOTTOM:
		{
			gint _tmp24_;
			gint _tmp25_;
			gint _tmp26_;
			gint _tmp27_;
			gint _tmp28_;
			gint _tmp29_;
			gint _tmp30_;
			gint _tmp31_;
			cairo_rectangle_int_t _tmp32_ = {0};
			cairo_region_t* _tmp33_;
			_tmp24_ = gtk_widget_get_scale_factor ((GtkWidget*) self);
			_tmp25_ = _tmp24_;
			_tmp26_ = gtk_widget_get_scale_factor ((GtkWidget*) self);
			_tmp27_ = _tmp26_;
			_tmp28_ = gtk_widget_get_scale_factor ((GtkWidget*) self);
			_tmp29_ = _tmp28_;
			_tmp30_ = gtk_widget_get_scale_factor ((GtkWidget*) self);
			_tmp31_ = _tmp30_;
			memset (&_tmp32_, 0, sizeof (cairo_rectangle_int_t));
			_tmp32_.x = 0;
			_tmp32_.y = (gtk_widget_get_allocated_height ((GtkWidget*) self) * _tmp25_) - (1 * _tmp27_);
			_tmp32_.width = gtk_widget_get_allocated_width ((GtkWidget*) self) * _tmp29_;
			_tmp32_.height = 1 * _tmp31_;
			_tmp33_ = cairo_region_create_rectangle (&_tmp32_);
			_cairo_region_destroy0 (region);
			region = _tmp33_;
			break;
		}
	}
	_tmp34_ = gtk_widget_get_window ((GtkWidget*) self);
	_tmp35_ = region;
	gdk_window_input_shape_combine_region (_tmp34_, _tmp35_, 0, 0);
	_cairo_region_destroy0 (region);
}

/**
* Restore the full input region for "normal" usage
*/
static void
budgie_panel_set_input_region (BudgiePanel* self)
{
	cairo_region_t* region = NULL;
	cairo_rectangle_int_t _tmp0_ = {0};
	cairo_region_t* _tmp1_;
	GdkWindow* _tmp2_;
	g_return_if_fail (self != NULL);
	memset (&_tmp0_, 0, sizeof (cairo_rectangle_int_t));
	_tmp0_.x = 0;
	_tmp0_.y = 0;
	_tmp0_.width = gtk_widget_get_allocated_width ((GtkWidget*) self);
	_tmp0_.height = gtk_widget_get_allocated_height ((GtkWidget*) self);
	_tmp1_ = cairo_region_create_rectangle (&_tmp0_);
	region = _tmp1_;
	_tmp2_ = gtk_widget_get_window ((GtkWidget*) self);
	gdk_window_input_shape_combine_region (_tmp2_, region, 0, 0);
	_cairo_region_destroy0 (region);
}

/**
* In an autohidden mode, if we're not visible, and get peeked, say
* hello
*/
static gboolean
_budgie_panel_show_panel_gsource_func (gpointer self)
{
	gboolean result;
	result = budgie_panel_show_panel ((BudgiePanel*) self);
	return result;
}

static gboolean
budgie_panel_on_enter_notify (BudgiePanel* self,
                              GdkEventCrossing* cr)
{
	BudgieAutohidePolicy _tmp0_;
	BudgieAutohidePolicy _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (cr != NULL, FALSE);
	if (self->priv->render_panel) {
		result = GDK_EVENT_PROPAGATE;
		return result;
	}
	_tmp0_ = budgie_toplevel_get_autohide ((BudgieToplevel*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == BUDGIE_AUTOHIDE_POLICY_NONE) {
		result = GDK_EVENT_PROPAGATE;
		return result;
	}
	if (cr->detail == GDK_NOTIFY_INFERIOR) {
		result = GDK_EVENT_PROPAGATE;
		return result;
	}
	if (self->priv->update_dock_id > ((guint) 0)) {
		g_source_remove (self->priv->update_dock_id);
		self->priv->update_dock_id = (guint) 0;
	}
	if (self->priv->show_panel_id > ((guint) 0)) {
		g_source_remove (self->priv->show_panel_id);
	}
	self->priv->show_panel_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 150, _budgie_panel_show_panel_gsource_func, g_object_ref (self), g_object_unref);
	result = GDK_EVENT_STOP;
	return result;
}

static gboolean
_budgie_panel_update_dock_behavior_gsource_func (gpointer self)
{
	gboolean result;
	result = budgie_panel_update_dock_behavior ((BudgiePanel*) self);
	return result;
}

static gboolean
budgie_panel_on_leave_notify (BudgiePanel* self,
                              GdkEventCrossing* cr)
{
	BudgieAutohidePolicy _tmp0_;
	BudgieAutohidePolicy _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (cr != NULL, FALSE);
	_tmp0_ = budgie_toplevel_get_autohide ((BudgieToplevel*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == BUDGIE_AUTOHIDE_POLICY_NONE) {
		result = GDK_EVENT_PROPAGATE;
		return result;
	}
	if (cr->detail == GDK_NOTIFY_INFERIOR) {
		result = GDK_EVENT_PROPAGATE;
		return result;
	}
	if (self->priv->show_panel_id > ((guint) 0)) {
		g_source_remove (self->priv->show_panel_id);
		self->priv->show_panel_id = (guint) 0;
	}
	if (self->priv->update_dock_id > ((guint) 0)) {
		g_source_remove (self->priv->update_dock_id);
	}
	self->priv->update_dock_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 175, _budgie_panel_update_dock_behavior_gsource_func, g_object_ref (self), g_object_unref);
	result = GDK_EVENT_STOP;
	return result;
}

/**
* Show the panel through a small animation
*/
static gdouble
_budgie_expo_ease_out_budgie_tween_func (gdouble factor,
                                         gpointer self)
{
	gdouble result;
	result = budgie_expo_ease_out (factor);
	return result;
}

static void
_vala_BudgiePropChange_array_free (BudgiePropChange * array,
                                   gssize array_length)
{
	if (array != NULL) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			budgie_prop_change_destroy (&array[i]);
		}
	}
	g_free (array);
}

static void
__lambda5_ (BudgiePanel* self,
            BudgieAnimation* a)
{
	budgie_panel_set_input_region (self);
	self->priv->animation = BUDGIE_PANEL_ANIMATION_NONE;
}

static void
___lambda5__budgie_anim_completion_func (BudgieAnimation* src,
                                         gpointer self)
{
	__lambda5_ ((BudgiePanel*) self, src);
}

static gboolean
budgie_panel_show_panel (BudgiePanel* self)
{
	GtkSettings* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	BudgieAnimation* _tmp3_;
	BudgieAnimation* _tmp4_;
	BudgieAnimation* _tmp5_;
	BudgieAnimation* _tmp6_;
	BudgieAnimation* _tmp7_;
	gchar* _tmp8_;
	gdouble _tmp9_;
	gdouble _tmp10_;
	GValue _tmp11_ = {0};
	GValue _tmp12_ = {0};
	BudgiePropChange _tmp13_ = {0};
	BudgiePropChange* _tmp14_;
	BudgieAnimation* _tmp15_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	self->priv->show_panel_id = (guint) 0;
	if (!self->priv->allow_animation) {
		result = FALSE;
		return result;
	}
	self->priv->animation = BUDGIE_PANEL_ANIMATION_SHOW;
	self->priv->render_panel = TRUE;
	gtk_widget_queue_draw ((GtkWidget*) self);
	gtk_widget_show ((GtkWidget*) self);
	_tmp0_ = gtk_widget_get_settings ((GtkWidget*) self);
	g_object_get (_tmp0_, "gtk-enable-animations", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		budgie_panel_set_nscale (self, 1.0);
		budgie_panel_set_input_region (self);
		self->priv->animation = BUDGIE_PANEL_ANIMATION_NONE;
		gtk_widget_queue_draw ((GtkWidget*) self);
		result = FALSE;
		return result;
	}
	budgie_panel_set_input_region (self);
	_tmp3_ = budgie_animation_new ();
	_g_object_unref0 (self->priv->dock_animation);
	self->priv->dock_animation = _tmp3_;
	_tmp4_ = self->priv->dock_animation;
	_tmp4_->widget = (GtkWidget*) self;
	_tmp5_ = self->priv->dock_animation;
	_tmp5_->length = 360 * BUDGIE_MSECOND;
	_tmp6_ = self->priv->dock_animation;
	_tmp6_->tween = _budgie_expo_ease_out_budgie_tween_func;
	_tmp6_->tween_target = NULL;
	_tmp7_ = self->priv->dock_animation;
	_tmp8_ = g_strdup ("nscale");
	_tmp9_ = budgie_panel_get_nscale (self);
	_tmp10_ = _tmp9_;
	g_value_init (&_tmp11_, G_TYPE_DOUBLE);
	g_value_set_double (&_tmp11_, _tmp10_);
	g_value_init (&_tmp12_, G_TYPE_DOUBLE);
	g_value_set_double (&_tmp12_, 1.0);
	memset (&_tmp13_, 0, sizeof (BudgiePropChange));
	_g_free0 (_tmp13_.property);
	_tmp13_.property = _tmp8_;
	G_IS_VALUE (&_tmp13_.old) ? (g_value_unset (&_tmp13_.old), NULL) : NULL;
	_tmp13_.old = _tmp11_;
	G_IS_VALUE (&_tmp13_.new) ? (g_value_unset (&_tmp13_.new), NULL) : NULL;
	_tmp13_.new = _tmp12_;
	_tmp14_ = g_new0 (BudgiePropChange, 1);
	_tmp14_[0] = _tmp13_;
	_tmp7_->changes = (_vala_BudgiePropChange_array_free (_tmp7_->changes, _tmp7_->changes_length1), NULL);
	_tmp7_->changes = _tmp14_;
	_tmp7_->changes_length1 = 1;
	_tmp15_ = self->priv->dock_animation;
	budgie_animation_start (_tmp15_, ___lambda5__budgie_anim_completion_func, self);
	result = FALSE;
	return result;
}

/**
* Hide the panel through a small animation
*/
static void
__lambda6_ (BudgiePanel* self,
            BudgieAnimation* a)
{
	budgie_panel_unset_input_region (self);
	self->priv->animation = BUDGIE_PANEL_ANIMATION_NONE;
}

static void
___lambda6__budgie_anim_completion_func (BudgieAnimation* src,
                                         gpointer self)
{
	__lambda6_ ((BudgiePanel*) self, src);
}

static void
budgie_panel_hide_panel (BudgiePanel* self)
{
	GtkSettings* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	BudgieAnimation* _tmp3_;
	BudgieAnimation* _tmp4_;
	BudgieAnimation* _tmp5_;
	BudgieAnimation* _tmp6_;
	BudgieAnimation* _tmp7_;
	gchar* _tmp8_;
	gdouble _tmp9_;
	gdouble _tmp10_;
	GValue _tmp11_ = {0};
	GValue _tmp12_ = {0};
	BudgiePropChange _tmp13_ = {0};
	BudgiePropChange* _tmp14_;
	BudgieAnimation* _tmp15_;
	g_return_if_fail (self != NULL);
	if (!self->priv->allow_animation) {
		return;
	}
	if (budgie_panel_cursor_within_bounds (self)) {
		return;
	}
	_tmp0_ = gtk_widget_get_settings ((GtkWidget*) self);
	g_object_get (_tmp0_, "gtk-enable-animations", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		budgie_panel_set_nscale (self, 0.0);
		budgie_panel_unset_input_region (self);
		self->priv->animation = BUDGIE_PANEL_ANIMATION_NONE;
		gtk_widget_queue_draw ((GtkWidget*) self);
		return;
	}
	budgie_panel_unset_input_region (self);
	self->priv->render_panel = TRUE;
	self->priv->animation = BUDGIE_PANEL_ANIMATION_SHOW;
	_tmp3_ = budgie_animation_new ();
	_g_object_unref0 (self->priv->dock_animation);
	self->priv->dock_animation = _tmp3_;
	_tmp4_ = self->priv->dock_animation;
	_tmp4_->widget = (GtkWidget*) self;
	_tmp5_ = self->priv->dock_animation;
	_tmp5_->length = 360 * BUDGIE_MSECOND;
	_tmp6_ = self->priv->dock_animation;
	_tmp6_->tween = _budgie_expo_ease_out_budgie_tween_func;
	_tmp6_->tween_target = NULL;
	_tmp7_ = self->priv->dock_animation;
	_tmp8_ = g_strdup ("nscale");
	_tmp9_ = budgie_panel_get_nscale (self);
	_tmp10_ = _tmp9_;
	g_value_init (&_tmp11_, G_TYPE_DOUBLE);
	g_value_set_double (&_tmp11_, _tmp10_);
	g_value_init (&_tmp12_, G_TYPE_DOUBLE);
	g_value_set_double (&_tmp12_, 0.0);
	memset (&_tmp13_, 0, sizeof (BudgiePropChange));
	_g_free0 (_tmp13_.property);
	_tmp13_.property = _tmp8_;
	G_IS_VALUE (&_tmp13_.old) ? (g_value_unset (&_tmp13_.old), NULL) : NULL;
	_tmp13_.old = _tmp11_;
	G_IS_VALUE (&_tmp13_.new) ? (g_value_unset (&_tmp13_.new), NULL) : NULL;
	_tmp13_.new = _tmp12_;
	_tmp14_ = g_new0 (BudgiePropChange, 1);
	_tmp14_[0] = _tmp13_;
	_tmp7_->changes = (_vala_BudgiePropChange_array_free (_tmp7_->changes, _tmp7_->changes_length1), NULL);
	_tmp7_->changes = _tmp14_;
	_tmp7_->changes_length1 = 1;
	_tmp15_ = self->priv->dock_animation;
	budgie_animation_start (_tmp15_, ___lambda6__budgie_anim_completion_func, self);
}

static gboolean
budgie_panel_real_draw (GtkWidget* base,
                        cairo_t* cr)
{
	BudgiePanel * self;
	GdkWindow* window = NULL;
	GdkWindow* _tmp0_;
	GdkWindow* _tmp1_;
	GdkWindow* _tmp2_;
	GtkAllocation alloc = {0};
	GtkAllocation _tmp3_ = {0};
	cairo_surface_t* buffer = NULL;
	GdkWindow* _tmp4_;
	GtkAllocation _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	GtkAllocation _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	cairo_surface_t* _tmp13_;
	cairo_t* cr2 = NULL;
	cairo_surface_t* _tmp14_;
	cairo_t* _tmp15_;
	GtkWidget* _tmp16_;
	cairo_t* _tmp17_;
	gdouble y = 0.0;
	GtkAllocation _tmp18_;
	gdouble x = 0.0;
	GtkAllocation _tmp19_;
	BudgiePanelPosition _tmp20_;
	BudgiePanelPosition _tmp21_;
	gboolean result;
	self = (BudgiePanel*) base;
	g_return_val_if_fail (cr != NULL, FALSE);
	if (!self->priv->render_panel) {
		result = GDK_EVENT_STOP;
		return result;
	}
	if (self->priv->animation == BUDGIE_PANEL_ANIMATION_NONE) {
		result = GTK_WIDGET_CLASS (budgie_panel_parent_class)->draw ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, BUDGIE_TYPE_TOPLEVEL, BudgieToplevel), cr);
		return result;
	}
	_tmp0_ = gtk_widget_get_window ((GtkWidget*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	window = _tmp1_;
	_tmp2_ = window;
	if (_tmp2_ == NULL) {
		result = GDK_EVENT_STOP;
		_g_object_unref0 (window);
		return result;
	}
	gtk_widget_get_allocation ((GtkWidget*) self, &_tmp3_);
	alloc = _tmp3_;
	_tmp4_ = window;
	_tmp5_ = alloc;
	_tmp6_ = gtk_widget_get_scale_factor ((GtkWidget*) self);
	_tmp7_ = _tmp6_;
	_tmp8_ = alloc;
	_tmp9_ = gtk_widget_get_scale_factor ((GtkWidget*) self);
	_tmp10_ = _tmp9_;
	_tmp11_ = gtk_widget_get_scale_factor ((GtkWidget*) self);
	_tmp12_ = _tmp11_;
	_tmp13_ = gdk_window_create_similar_image_surface (_tmp4_, CAIRO_FORMAT_ARGB32, _tmp5_.width * _tmp7_, _tmp8_.height * _tmp10_, _tmp12_);
	buffer = _tmp13_;
	_tmp14_ = buffer;
	_tmp15_ = cairo_create (_tmp14_);
	cr2 = _tmp15_;
	_tmp16_ = gtk_bin_get_child ((GtkBin*) self);
	_tmp17_ = cr2;
	gtk_container_propagate_draw ((GtkContainer*) self, _tmp16_, _tmp17_);
	_tmp18_ = alloc;
	y = ((gdouble) _tmp18_.height) * self->priv->render_scale;
	_tmp19_ = alloc;
	x = ((gdouble) _tmp19_.width) * self->priv->render_scale;
	_tmp20_ = budgie_toplevel_get_position ((BudgieToplevel*) self);
	_tmp21_ = _tmp20_;
	switch (_tmp21_) {
		case BUDGIE_PANEL_POSITION_TOP:
		{
			cairo_surface_t* _tmp22_;
			GtkAllocation _tmp23_;
			_tmp22_ = buffer;
			_tmp23_ = alloc;
			cairo_set_source_surface (cr, _tmp22_, (gdouble) 0, y - _tmp23_.height);
			break;
		}
		case BUDGIE_PANEL_POSITION_LEFT:
		{
			cairo_surface_t* _tmp24_;
			GtkAllocation _tmp25_;
			_tmp24_ = buffer;
			_tmp25_ = alloc;
			cairo_set_source_surface (cr, _tmp24_, x - _tmp25_.width, (gdouble) 0);
			break;
		}
		case BUDGIE_PANEL_POSITION_RIGHT:
		{
			cairo_surface_t* _tmp26_;
			GtkAllocation _tmp27_;
			_tmp26_ = buffer;
			_tmp27_ = alloc;
			cairo_set_source_surface (cr, _tmp26_, _tmp27_.width - x, (gdouble) 0);
			break;
		}
		default:
		case BUDGIE_PANEL_POSITION_BOTTOM:
		{
			cairo_surface_t* _tmp28_;
			GtkAllocation _tmp29_;
			_tmp28_ = buffer;
			_tmp29_ = alloc;
			cairo_set_source_surface (cr, _tmp28_, (gdouble) 0, _tmp29_.height - y);
			break;
		}
	}
	cairo_paint (cr);
	result = GDK_EVENT_STOP;
	_cairo_destroy0 (cr2);
	_cairo_surface_destroy0 (buffer);
	_g_object_unref0 (window);
	return result;
}

/**
* Specialist operation, perform a migration after we changed applet configurations
* See: https://github.com/solus-project/budgie-desktop/issues/555
*/
void
budgie_panel_perform_migration (BudgiePanel* self,
                                gint current_migration_level)
{
	g_return_if_fail (self != NULL);
	if (current_migration_level != 0) {
		g_warning ("panel.vala:1704: Unknown migration level: %d", current_migration_level);
		return;
	}
	self->priv->need_migratory = TRUE;
	if (self->priv->is_fully_loaded) {
		g_message ("panel.vala:1709: Performing migration to level %d", BUDGIE_BUDGIE_MIGRATION_LEVEL);
		budgie_panel_add_migratory (self);
	}
}

/**
* Very simple right now. Just add the applets to the end of the panel
*/
static gboolean
budgie_panel_add_migratory (BudgiePanel* self)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		g_rec_mutex_lock (&self->priv->__lock_need_migratory);
		{
			if (!self->priv->need_migratory) {
				result = FALSE;
				{
					g_rec_mutex_unlock (&self->priv->__lock_need_migratory);
				}
				return result;
			}
			self->priv->need_migratory = FALSE;
			{
				const gchar** new_applet_collection = NULL;
				gint new_applet_collection_length1 = 0;
				gint _new_applet_collection_size_ = 0;
				gint new_applet_it = 0;
				new_applet_collection = BUDGIE_MIGRATION_1_APPLETS;
				new_applet_collection_length1 = G_N_ELEMENTS (BUDGIE_MIGRATION_1_APPLETS);
				for (new_applet_it = 0; new_applet_it < new_applet_collection_length1; new_applet_it = new_applet_it + 1) {
					const gchar* new_applet = NULL;
					new_applet = new_applet_collection[new_applet_it];
					{
						const gchar* _tmp0_;
						const gchar* _tmp1_;
						GtkBox* _tmp2_;
						_tmp0_ = new_applet;
						g_message ("panel.vala:1724: Adding migratory applet: %s", _tmp0_);
						_tmp1_ = new_applet;
						_tmp2_ = self->priv->end_box;
						budgie_panel_add_new_applet_at (self, _tmp1_, _tmp2_);
					}
				}
			}
		}
		__finally0:
		{
			g_rec_mutex_unlock (&self->priv->__lock_need_migratory);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp3_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp3_;
		}
	}
	result = FALSE;
	return result;
}

GSettings*
budgie_panel_get_settings (BudgiePanel* self)
{
	GSettings* result;
	GSettings* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_settings;
	result = _tmp0_;
	return result;
}

void
budgie_panel_set_settings (BudgiePanel* self,
                           GSettings* value)
{
	GSettings* old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_panel_get_settings (self);
	if (old_value != value) {
		GSettings* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_settings);
		self->priv->_settings = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, budgie_panel_properties[BUDGIE_PANEL_SETTINGS_PROPERTY]);
	}
}

gdouble
budgie_panel_get_nscale (BudgiePanel* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->render_scale;
	return result;
}

void
budgie_panel_set_nscale (BudgiePanel* self,
                         gdouble value)
{
	g_return_if_fail (self != NULL);
	self->priv->render_scale = value;
	gtk_widget_queue_draw ((GtkWidget*) self);
	g_object_notify_by_pspec ((GObject *) self, budgie_panel_properties[BUDGIE_PANEL_NSCALE_PROPERTY]);
}

static GObject *
budgie_panel_constructor (GType type,
                          guint n_construct_properties,
                          GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	BudgiePanel * self;
	parent_class = G_OBJECT_CLASS (budgie_panel_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_PANEL, BudgiePanel);
	budgie_toplevel_set_position ((BudgieToplevel*) self, BUDGIE_PANEL_POSITION_NONE);
	return obj;
}

static void
budgie_panel_class_init (BudgiePanelClass * klass,
                         gpointer klass_data)
{
	budgie_panel_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BudgiePanel_private_offset);
	((BudgieToplevelClass *) klass)->get_applets = (GList* (*) (BudgieToplevel*)) budgie_panel_real_get_applets;
	((BudgieToplevelClass *) klass)->add_new_applet = (void (*) (BudgieToplevel*, const gchar*)) budgie_panel_real_add_new_applet;
	((BudgieToplevelClass *) klass)->remove_applet = (void (*) (BudgieToplevel*, BudgieAppletInfo*)) budgie_panel_real_remove_applet;
	((GtkWidgetClass *) klass)->map = (void (*) (GtkWidget*)) budgie_panel_real_map;
	((BudgieToplevelClass *) klass)->can_move_applet_left = (gboolean (*) (BudgieToplevel*, BudgieAppletInfo*)) budgie_panel_real_can_move_applet_left;
	((BudgieToplevelClass *) klass)->can_move_applet_right = (gboolean (*) (BudgieToplevel*, BudgieAppletInfo*)) budgie_panel_real_can_move_applet_right;
	((BudgieToplevelClass *) klass)->move_applet_left = (void (*) (BudgieToplevel*, BudgieAppletInfo*)) budgie_panel_real_move_applet_left;
	((BudgieToplevelClass *) klass)->move_applet_right = (void (*) (BudgieToplevel*, BudgieAppletInfo*)) budgie_panel_real_move_applet_right;
	((GtkWidgetClass *) klass)->draw = (gboolean (*) (GtkWidget*, cairo_t*)) budgie_panel_real_draw;
	G_OBJECT_CLASS (klass)->get_property = _vala_budgie_panel_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_budgie_panel_set_property;
	G_OBJECT_CLASS (klass)->constructor = budgie_panel_constructor;
	G_OBJECT_CLASS (klass)->finalize = budgie_panel_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_PANEL_SETTINGS_PROPERTY, budgie_panel_properties[BUDGIE_PANEL_SETTINGS_PROPERTY] = g_param_spec_object ("settings", "settings", "settings", g_settings_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_PANEL_NSCALE_PROPERTY, budgie_panel_properties[BUDGIE_PANEL_NSCALE_PROPERTY] = g_param_spec_double ("nscale", "nscale", "nscale", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	budgie_panel_signals[BUDGIE_PANEL_PANEL_LOADED_SIGNAL] = g_signal_new ("panel-loaded", BUDGIE_TYPE_PANEL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
budgie_panel_instance_init (BudgiePanel * self,
                            gpointer klass)
{
	gint* _tmp0_;
	self->priv = budgie_panel_get_instance_private (self);
	self->priv->pending = NULL;
	self->priv->creating = NULL;
	self->priv->applets = NULL;
	self->priv->initial_config = NULL;
	g_rec_mutex_init (&self->priv->__lock_expected_uuids);
	self->priv->scale = 1;
	_tmp0_ = g_new0 (gint, 7);
	_tmp0_[0] = 16;
	_tmp0_[1] = 24;
	_tmp0_[2] = 32;
	_tmp0_[3] = 48;
	_tmp0_[4] = 96;
	_tmp0_[5] = 128;
	_tmp0_[6] = 256;
	self->priv->icon_sizes = _tmp0_;
	self->priv->icon_sizes_length1 = 7;
	self->priv->_icon_sizes_size_ = self->priv->icon_sizes_length1;
	self->priv->is_fully_loaded = FALSE;
	g_rec_mutex_init (&self->priv->__lock_need_migratory);
	self->priv->need_migratory = FALSE;
	self->priv->render_scale = 0.0;
	self->priv->animation = BUDGIE_PANEL_ANIMATION_SHOW;
	self->priv->allow_animation = FALSE;
	self->priv->screen_occluded = FALSE;
	self->priv->old_width = 0;
	self->priv->old_height = 0;
	self->priv->initial_anim = FALSE;
	self->priv->dock_animation = NULL;
	self->priv->render_panel = TRUE;
	self->priv->update_dock_id = (guint) 0;
	self->priv->show_panel_id = (guint) 0;
}

static void
budgie_panel_finalize (GObject * obj)
{
	BudgiePanel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_PANEL, BudgiePanel);
	_g_object_unref0 (self->priv->layout);
	_g_object_unref0 (self->priv->main_layout);
	_g_object_unref0 (self->priv->_settings);
	_g_object_unref0 (self->priv->popover_manager);
	_g_object_unref0 (self->priv->shadow);
	_g_hash_table_unref0 (self->priv->pending);
	_g_hash_table_unref0 (self->priv->creating);
	_g_hash_table_unref0 (self->priv->applets);
	_g_hash_table_unref0 (self->priv->initial_config);
	g_rec_mutex_clear (&self->priv->__lock_expected_uuids);
	(self->priv->expected_uuids == NULL) ? NULL : (self->priv->expected_uuids = (_g_list_free__g_free0_ (self->priv->expected_uuids), NULL));
	_g_object_unref0 (self->priv->start_box);
	_g_object_unref0 (self->priv->center_box);
	_g_object_unref0 (self->priv->end_box);
	self->priv->icon_sizes = (g_free (self->priv->icon_sizes), NULL);
	g_rec_mutex_clear (&self->priv->__lock_need_migratory);
	_g_object_unref0 (self->priv->dock_animation);
	G_OBJECT_CLASS (budgie_panel_parent_class)->finalize (obj);
}

/**
* The toplevel window for a panel
*/
static GType
budgie_panel_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgiePanelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_panel_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgiePanel), 0, (GInstanceInitFunc) budgie_panel_instance_init, NULL };
	GType budgie_panel_type_id;
	budgie_panel_type_id = g_type_register_static (BUDGIE_TYPE_TOPLEVEL, "BudgiePanel", &g_define_type_info, 0);
	BudgiePanel_private_offset = g_type_add_instance_private (budgie_panel_type_id, sizeof (BudgiePanelPrivate));
	return budgie_panel_type_id;
}

GType
budgie_panel_get_type (void)
{
	static volatile gsize budgie_panel_type_id__once = 0;
	if (g_once_init_enter (&budgie_panel_type_id__once)) {
		GType budgie_panel_type_id;
		budgie_panel_type_id = budgie_panel_get_type_once ();
		g_once_init_leave (&budgie_panel_type_id__once, budgie_panel_type_id);
	}
	return budgie_panel_type_id__once;
}

static void
_vala_budgie_panel_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec)
{
	BudgiePanel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_TYPE_PANEL, BudgiePanel);
	switch (property_id) {
		case BUDGIE_PANEL_SETTINGS_PROPERTY:
		g_value_set_object (value, budgie_panel_get_settings (self));
		break;
		case BUDGIE_PANEL_NSCALE_PROPERTY:
		g_value_set_double (value, budgie_panel_get_nscale (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_budgie_panel_set_property (GObject * object,
                                 guint property_id,
                                 const GValue * value,
                                 GParamSpec * pspec)
{
	BudgiePanel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_TYPE_PANEL, BudgiePanel);
	switch (property_id) {
		case BUDGIE_PANEL_SETTINGS_PROPERTY:
		budgie_panel_set_settings (self, g_value_get_object (value));
		break;
		case BUDGIE_PANEL_NSCALE_PROPERTY:
		budgie_panel_set_nscale (self, g_value_get_double (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

