/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.components.splineeditor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.Locale;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gephi.ui.components.splineeditor.SplineDisplay;
import org.gephi.ui.components.splineeditor.SplineEditor;
import org.jdesktop.animation.timing.Animator;
import org.jdesktop.animation.timing.TimingTarget;
import org.jdesktop.animation.timing.interpolation.Evaluator;
import org.jdesktop.animation.timing.interpolation.PropertySetter;
import org.openide.util.NbBundle;

class SplineControlPanel
extends JPanel {
    private SplineDisplay display;
    private int linesCount = 0;
    private Animator controller;
    private final SplineEditor editor;
    private final Evaluator point2dInterpolator = new Point2DNonLinearInterpolator();

    SplineControlPanel(SplineEditor editor) {
        super(new BorderLayout());
        this.editor = editor;
        this.add(this.buildEquationDisplay(), "Center");
        this.add(this.buildDebugControls(), "East");
    }

    private static NumberFormat getNumberFormatter() {
        NumberFormat formatter = NumberFormat.getInstance(Locale.ENGLISH);
        formatter.setMinimumFractionDigits(2);
        formatter.setMaximumFractionDigits(2);
        return formatter;
    }

    private static Template createTemplate(double x1, double y1, double x2, double y2) {
        return new Template(new Point2D.Double(x1, y1), new Point2D.Double(x2, y2));
    }

    private Component buildDebugControls() {
        JPanel debugPanel = new JPanel(new GridBagLayout());
        debugPanel.add(Box.createHorizontalStrut(150), new GridBagConstraints(0, this.linesCount++, 2, 1, 1.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.addSeparator(debugPanel, NbBundle.getMessage(SplineEditor.class, (String)"splineEditor_templates"));
        debugPanel.add(this.createTemplates(), new GridBagConstraints(0, this.linesCount++, 2, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.addEmptySpace(debugPanel, 6);
        JButton closeButton = this.addButton(debugPanel, NbBundle.getMessage(SplineEditor.class, (String)"splineEditor_close"));
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SplineControlPanel.this.editor.dispose();
            }
        });
        this.addEmptySpace(debugPanel, 6);
        debugPanel.add(Box.createVerticalGlue(), new GridBagConstraints(0, this.linesCount++, 2, 1, 1.0, 1.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        JPanel wrapper = new JPanel(new BorderLayout());
        wrapper.add((Component)new JSeparator(1), "West");
        wrapper.add(debugPanel);
        wrapper.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 6));
        return wrapper;
    }

    private Component createTemplates() {
        DefaultListModel<Template> model = new DefaultListModel<Template>();
        model.addElement(SplineControlPanel.createTemplate(0.0, 0.0, 1.0, 1.0));
        model.addElement(SplineControlPanel.createTemplate(0.0, 1.0, 0.0, 1.0));
        model.addElement(SplineControlPanel.createTemplate(0.0, 1.0, 1.0, 1.0));
        model.addElement(SplineControlPanel.createTemplate(0.0, 1.0, 1.0, 0.0));
        model.addElement(SplineControlPanel.createTemplate(1.0, 0.0, 0.0, 1.0));
        model.addElement(SplineControlPanel.createTemplate(1.0, 0.0, 1.0, 1.0));
        model.addElement(SplineControlPanel.createTemplate(1.0, 0.0, 1.0, 0.0));
        JList<Object> list = new JList<Object>(model);
        list.setSelectionMode(0);
        list.setCellRenderer(new TemplateCellRenderer());
        list.addListSelectionListener(new TemplateSelectionHandler());
        JScrollPane pane = new JScrollPane(list);
        pane.getViewport().setPreferredSize(new Dimension(98, 291));
        return pane;
    }

    private JButton addButton(JPanel debugPanel, String label) {
        JButton button = new JButton(label);
        debugPanel.add((Component)button, new GridBagConstraints(0, this.linesCount++, 2, 1, 1.0, 0.0, 10, 0, new Insets(3, 0, 0, 0), 0, 0));
        return button;
    }

    private String formatPoint(Point2D p) {
        NumberFormat formatter = SplineControlPanel.getNumberFormatter();
        return formatter.format(p.getX()) + ", " + formatter.format(p.getY());
    }

    private Component buildEquationDisplay() {
        JPanel panel = new JPanel(new BorderLayout());
        this.display = new SplineDisplay();
        panel.add((Component)this.display, "North");
        return panel;
    }

    private JLabel addDebugLabel(JPanel panel, String label, String value) {
        JLabel labelComponent = new JLabel(label);
        panel.add((Component)labelComponent, new GridBagConstraints(0, this.linesCount, 1, 1, 0.5, 0.0, 22, 0, new Insets(0, 6, 0, 0), 0, 0));
        labelComponent = new JLabel(value);
        panel.add((Component)labelComponent, new GridBagConstraints(1, this.linesCount++, 1, 1, 0.5, 0.0, 21, 0, new Insets(0, 6, 0, 0), 0, 0));
        return labelComponent;
    }

    private void addEmptySpace(JPanel panel, int size) {
        panel.add(Box.createVerticalStrut(size), new GridBagConstraints(0, this.linesCount++, 2, 1, 1.0, 0.0, 10, 3, new Insets(6, 0, 0, 0), 0, 0));
    }

    private void addSeparator(JPanel panel, String label) {
        JPanel innerPanel = new JPanel(new GridBagLayout());
        innerPanel.add((Component)new JLabel(label), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        innerPanel.add((Component)new JSeparator(), new GridBagConstraints(1, 0, 1, 1, 0.9, 0.0, 21, 2, new Insets(0, 6, 0, 6), 0, 0));
        panel.add((Component)innerPanel, new GridBagConstraints(0, this.linesCount++, 2, 1, 1.0, 0.0, 21, 2, new Insets(6, 6, 6, 0), 0, 0));
    }

    public SplineDisplay getDisplay() {
        return this.display;
    }

    private class TemplateSelectionHandler
    implements ListSelectionListener {
        private TemplateSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            JList list = (JList)e.getSource();
            Template template = (Template)list.getSelectedValue();
            if (template != null) {
                if (SplineControlPanel.this.controller != null && SplineControlPanel.this.controller.isRunning()) {
                    SplineControlPanel.this.controller.stop();
                }
                SplineControlPanel.this.controller = new Animator(300, (TimingTarget)new PropertySetter((Object)SplineControlPanel.this.display, "control1", SplineControlPanel.this.point2dInterpolator, (Object[])new Point2D[]{SplineControlPanel.this.display.getControl1(), template.getControl1()}));
                SplineControlPanel.this.controller.setResolution(10);
                SplineControlPanel.this.controller.addTarget((TimingTarget)new PropertySetter((Object)SplineControlPanel.this.display, "control2", SplineControlPanel.this.point2dInterpolator, (Object[])new Point2D[]{SplineControlPanel.this.display.getControl2(), template.getControl2()}));
                SplineControlPanel.this.controller.start();
            }
        }
    }

    private class Point2DNonLinearInterpolator
    extends Evaluator<Point2D> {
        private Point2D value;

        private Point2DNonLinearInterpolator() {
        }

        public Point2D evaluate(Point2D v0, Point2D v1, float fraction) {
            Point2D value = (Point2D)v0.clone();
            if (v0 != v1) {
                double x = value.getX();
                double y = value.getY();
                value.setLocation(x += (v1.getX() - v0.getX()) * (double)fraction, y += (v1.getY() - v0.getY()) * (double)fraction);
            } else {
                value.setLocation(v0.getX(), v0.getY());
            }
            return value;
        }
    }

    private static class Template {
        private final Point2D control1;
        private final Point2D control2;
        private Image image;

        public Template(Point2D control1, Point2D control2) {
            this.control1 = control1;
            this.control2 = control2;
        }

        public Point2D getControl1() {
            return this.control1;
        }

        public Point2D getControl2() {
            return this.control2;
        }

        public Image getImage() {
            if (this.image == null) {
                NumberFormat formatter = SplineControlPanel.getNumberFormatter();
                Object name = "";
                name = (String)name + formatter.format(this.control1.getX()) + "-" + formatter.format(this.control1.getY());
                name = (String)name + "-";
                name = (String)name + formatter.format(this.control2.getX()) + "-" + formatter.format(this.control2.getY());
                try {
                    this.image = ImageIO.read(this.getClass().getResourceAsStream("images/templates/" + (String)name + ".png"));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return this.image;
        }
    }

    private static class TemplateCellRenderer
    extends DefaultListCellRenderer {
        private boolean isSelected;

        private TemplateCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Template template = (Template)value;
            this.setBackground(Color.WHITE);
            this.setIcon(new ImageIcon(template.getImage()));
            this.isSelected = isSelected;
            return this;
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.isSelected) {
                g.setColor(new Color(0.0f, 0.0f, 0.7f, 0.1f));
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
        }
    }
}

