/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.optim;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

@Internal
public abstract class StaticOptimizations {
    private static final Map<Class<?>, Object> OPTIMIZATIONS = new ConcurrentHashMap();
    private static boolean cacheEnvironment = false;

    public static void cacheEnvironment() {
        cacheEnvironment = true;
    }

    @NonNull
    public static <T> Optional<T> get(@NonNull Class<T> optimizationClass) {
        Object value = OPTIMIZATIONS.get(optimizationClass);
        return Optional.ofNullable(value);
    }

    public static <T> void set(@NonNull T value) {
        Class<?> optimizationClass = value.getClass();
        OPTIMIZATIONS.put(optimizationClass, value);
    }

    public static boolean isEnvironmentCached() {
        return cacheEnvironment;
    }
}

