/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.openstreetmap.josm.data.projection.CustomProjection;
import org.openstreetmap.josm.data.projection.Ellipsoid;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.ProjectionConfigurationException;
import org.openstreetmap.josm.data.projection.datum.Datum;
import org.openstreetmap.josm.data.projection.datum.GRS80Datum;
import org.openstreetmap.josm.data.projection.datum.NTV2GridShiftFileWrapper;
import org.openstreetmap.josm.data.projection.datum.SevenParameterDatum;
import org.openstreetmap.josm.data.projection.datum.ThreeParameterDatum;
import org.openstreetmap.josm.data.projection.datum.WGS84Datum;
import org.openstreetmap.josm.data.projection.proj.AlbersEqualArea;
import org.openstreetmap.josm.data.projection.proj.AzimuthalEquidistant;
import org.openstreetmap.josm.data.projection.proj.CassiniSoldner;
import org.openstreetmap.josm.data.projection.proj.ClassProjFactory;
import org.openstreetmap.josm.data.projection.proj.DoubleStereographic;
import org.openstreetmap.josm.data.projection.proj.EquidistantCylindrical;
import org.openstreetmap.josm.data.projection.proj.LambertAzimuthalEqualArea;
import org.openstreetmap.josm.data.projection.proj.LambertConformalConic;
import org.openstreetmap.josm.data.projection.proj.LonLat;
import org.openstreetmap.josm.data.projection.proj.Mercator;
import org.openstreetmap.josm.data.projection.proj.ObliqueMercator;
import org.openstreetmap.josm.data.projection.proj.PolarStereographic;
import org.openstreetmap.josm.data.projection.proj.Proj;
import org.openstreetmap.josm.data.projection.proj.ProjFactory;
import org.openstreetmap.josm.data.projection.proj.Sinusoidal;
import org.openstreetmap.josm.data.projection.proj.SwissObliqueMercator;
import org.openstreetmap.josm.data.projection.proj.TransverseMercator;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.Logging;

public final class Projections {
    private static final Set<String> allCodes = new HashSet<String>();
    private static final Map<String, Supplier<Projection>> projectionSuppliersByCode = new HashMap<String, Supplier<Projection>>();
    private static final Map<String, Projection> projectionsByCodeCache = new ConcurrentHashMap<String, Projection>();
    private static final Map<String, ProjFactory> projs = new HashMap<String, ProjFactory>();
    private static final Map<String, Ellipsoid> ellipsoids = new HashMap<String, Ellipsoid>();
    private static final Map<String, Datum> datums = new HashMap<String, Datum>();
    private static final Map<String, NTV2GridShiftFileWrapper> nadgrids = new HashMap<String, NTV2GridShiftFileWrapper>();
    private static final Map<String, ProjectionDefinition> inits;

    private Projections() {
    }

    private static void loadNadgrids(String definition) {
        String key = CustomProjection.Param.nadgrids.key;
        if (definition.contains(key)) {
            try {
                String nadgridsId = CustomProjection.parseParameterList(definition, true).get(key);
                if (nadgridsId.startsWith("@")) {
                    nadgridsId = nadgridsId.substring(1);
                }
                if (!"null".equals(nadgridsId) && !nadgrids.containsKey(nadgridsId)) {
                    nadgrids.put(nadgridsId, new NTV2GridShiftFileWrapper(nadgridsId));
                }
            }
            catch (ProjectionConfigurationException e) {
                Logging.trace(e);
            }
        }
    }

    public static void registerBaseProjection(String id, ProjFactory fac, String origin) {
        projs.put(id, fac);
    }

    public static void registerBaseProjection(String id, Class<? extends Proj> projClass, String origin) {
        Projections.registerBaseProjection(id, new ClassProjFactory(projClass), origin);
    }

    public static void registerProjectionSupplier(String code, Supplier<Projection> supplier) {
        projectionSuppliersByCode.put(code, supplier);
        allCodes.add(code);
    }

    public static Proj getBaseProjection(String id) {
        ProjFactory fac = projs.get(id);
        if (fac == null) {
            return null;
        }
        return fac.createInstance();
    }

    public static Ellipsoid getEllipsoid(String id) {
        return ellipsoids.get(id);
    }

    public static Datum getDatum(String id) {
        return datums.get(id);
    }

    public static NTV2GridShiftFileWrapper getNTV2Grid(String id) {
        return nadgrids.get(id);
    }

    public static String getInit(String code) {
        ProjectionDefinition pd = inits.get(code.toUpperCase(Locale.ENGLISH));
        if (pd == null) {
            return null;
        }
        return pd.definition;
    }

    /*
     * Exception decompiling
     */
    public static List<ProjectionDefinition> loadProjectionDefinitions(String path) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static List<ProjectionDefinition> loadProjectionDefinitions(BufferedReader r) throws IOException {
        String line;
        ArrayList<ProjectionDefinition> result = new ArrayList<ProjectionDefinition>();
        Pattern epsgPattern = Pattern.compile("<(\\d+)>(.*)<>");
        String coor = "(-?\\d+\\.\\d+)";
        Pattern areaPattern = Pattern.compile("# area: \\(lat: " + coor + ", " + coor + "\\) - \\(lon: " + coor + ", " + coor + "\\).*");
        StringBuilder sb = new StringBuilder();
        String bounds = null;
        while ((line = r.readLine()) != null) {
            Matcher m;
            if ((line = line.trim()).isEmpty() || line.startsWith("##")) continue;
            if (!line.startsWith("#")) {
                m = epsgPattern.matcher(line);
                if (m.matches()) {
                    String code = "EPSG:" + m.group(1);
                    String definition = m.group(2).trim();
                    if (!definition.contains("+bounds=") && bounds != null) {
                        definition = definition + bounds;
                    }
                    result.add(new ProjectionDefinition(code, sb.toString(), definition));
                } else {
                    Logging.warn("Failed to parse line from the EPSG projection definition: " + line);
                }
                sb.setLength(0);
                bounds = null;
                continue;
            }
            if (line.startsWith("# area: ")) {
                m = areaPattern.matcher(line);
                if (!m.matches()) continue;
                bounds = " +bounds=" + String.join((CharSequence)",", m.group(3), m.group(1), m.group(4), m.group(2));
                continue;
            }
            String s = line.substring(1).trim();
            if (sb.length() == 0) {
                sb.append(s);
                continue;
            }
            sb.append('(').append(s).append(')');
        }
        return result;
    }

    public static Projection getProjectionByCode(String code) {
        return code != null ? projectionsByCodeCache.computeIfAbsent(code, Projections::computeProjectionByCode) : null;
    }

    private static Projection computeProjectionByCode(String code) {
        Supplier<Projection> ps;
        Projection proj = null;
        ProjectionDefinition pd = inits.get(code);
        if (pd != null) {
            CustomProjection cproj = new CustomProjection(pd.name, code, null);
            try {
                cproj.update(pd.definition);
            }
            catch (ProjectionConfigurationException ex) {
                throw new JosmRuntimeException("Error loading " + code, ex);
            }
            proj = cproj;
        }
        if (proj == null && (ps = projectionSuppliersByCode.get(code)) != null) {
            proj = ps.get();
        }
        return proj;
    }

    public static Collection<String> getAllProjectionCodes() {
        return Collections.unmodifiableCollection(allCodes);
    }

    public static Collection<String> getAllBaseProjectionIds() {
        return projs.keySet();
    }

    private static String listKeys(Map<String, ?> map) {
        return map.keySet().stream().sorted().collect(Collectors.joining(", "));
    }

    public static String listProjs() {
        return Projections.listKeys(projs);
    }

    public static String listEllipsoids() {
        return Projections.listKeys(ellipsoids);
    }

    public static String listDatums() {
        return Projections.listKeys(datums);
    }

    public static String listNadgrids() {
        return Projections.listKeys(nadgrids);
    }

    private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
                x0.addSuppressed(throwable);
            }
        } else {
            x1.close();
        }
    }

    static {
        Projections.registerBaseProjection("aea", AlbersEqualArea.class, "core");
        Projections.registerBaseProjection("aeqd", AzimuthalEquidistant.class, "core");
        Projections.registerBaseProjection("cass", CassiniSoldner.class, "core");
        Projections.registerBaseProjection("eqc", EquidistantCylindrical.class, "core");
        Projections.registerBaseProjection("laea", LambertAzimuthalEqualArea.class, "core");
        Projections.registerBaseProjection("lcc", LambertConformalConic.class, "core");
        Projections.registerBaseProjection("lonlat", LonLat.class, "core");
        Projections.registerBaseProjection("merc", Mercator.class, "core");
        Projections.registerBaseProjection("omerc", ObliqueMercator.class, "core");
        Projections.registerBaseProjection("somerc", SwissObliqueMercator.class, "core");
        Projections.registerBaseProjection("sinu", Sinusoidal.class, "core");
        Projections.registerBaseProjection("stere", PolarStereographic.class, "core");
        Projections.registerBaseProjection("sterea", DoubleStereographic.class, "core");
        Projections.registerBaseProjection("tmerc", TransverseMercator.class, "core");
        ellipsoids.put("airy", Ellipsoid.Airy);
        ellipsoids.put("mod_airy", Ellipsoid.AiryMod);
        ellipsoids.put("aust_SA", Ellipsoid.AustSA);
        ellipsoids.put("bessel", Ellipsoid.Bessel1841);
        ellipsoids.put("bess_nam", Ellipsoid.BesselNamibia);
        ellipsoids.put("clrk66", Ellipsoid.Clarke1866);
        ellipsoids.put("clrk80", Ellipsoid.Clarke1880);
        ellipsoids.put("clrk80ign", Ellipsoid.ClarkeIGN);
        ellipsoids.put("evrst30", Ellipsoid.Everest);
        ellipsoids.put("evrst48", Ellipsoid.Everest1948);
        ellipsoids.put("evrst56", Ellipsoid.Everest1956);
        ellipsoids.put("evrst69", Ellipsoid.Everest1969);
        ellipsoids.put("evrstSS", Ellipsoid.EverestSabahSarawak);
        ellipsoids.put("fschr60", Ellipsoid.Fischer);
        ellipsoids.put("fschr60m", Ellipsoid.FischerMod);
        ellipsoids.put("fschr68", Ellipsoid.Fischer1968);
        ellipsoids.put("intl", Ellipsoid.Hayford);
        ellipsoids.put("helmert", Ellipsoid.Helmert);
        ellipsoids.put("hough", Ellipsoid.Hough);
        ellipsoids.put("krass", Ellipsoid.Krassowsky);
        ellipsoids.put("sphere", Ellipsoid.Sphere);
        ellipsoids.put("walbeck", Ellipsoid.Walbeck);
        ellipsoids.put("GRS67", Ellipsoid.GRS67);
        ellipsoids.put("GRS80", Ellipsoid.GRS80);
        ellipsoids.put("WGS66", Ellipsoid.WGS66);
        ellipsoids.put("WGS72", Ellipsoid.WGS72);
        ellipsoids.put("WGS84", Ellipsoid.WGS84);
        datums.put("WGS84", WGS84Datum.INSTANCE);
        datums.put("NAD83", GRS80Datum.INSTANCE);
        datums.put("carthage", new ThreeParameterDatum("Carthage 1934 Tunisia", "carthage", Ellipsoid.ClarkeIGN, -263.0, 6.0, 431.0));
        datums.put("GGRS87", new ThreeParameterDatum("Greek Geodetic Reference System 1987", "GGRS87", Ellipsoid.GRS80, -199.87, 74.79, 246.62));
        datums.put("hermannskogel", new SevenParameterDatum("Hermannskogel", "hermannskogel", Ellipsoid.Bessel1841, 577.326, 90.129, 463.919, 5.137, 1.474, 5.297, 2.4232));
        datums.put("ire65", new SevenParameterDatum("Ireland 1965", "ire65", Ellipsoid.AiryMod, 482.53, -130.596, 564.557, -1.042, -0.214, -0.631, 8.15));
        datums.put("nzgd49", new SevenParameterDatum("New Zealand Geodetic Datum 1949", "nzgd49", Ellipsoid.Hayford, 59.47, -5.04, 187.44, 0.47, -0.1, 1.024, -4.5993));
        datums.put("OSGB36", new SevenParameterDatum("Airy 1830", "OSGB36", Ellipsoid.Airy, 446.448, -125.157, 542.06, 0.1502, 0.247, 0.8421, -20.4894));
        datums.put("potsdam", new SevenParameterDatum("Potsdam Rauenberg 1950 DHDN", "potsdam", Ellipsoid.Bessel1841, 598.1, 73.7, 418.2, 0.202, 0.045, -2.455, 6.7));
        try {
            inits = new LinkedHashMap<String, ProjectionDefinition>();
            for (ProjectionDefinition pd : Projections.loadProjectionDefinitions("resource://data/projection/custom-epsg")) {
                inits.put(pd.code, pd);
                Projections.loadNadgrids(pd.definition);
            }
        }
        catch (IOException ex) {
            throw new JosmRuntimeException(ex);
        }
        allCodes.addAll(inits.keySet());
    }

    public static class ProjectionDefinition {
        public final String code;
        public final String name;
        public final String definition;

        public ProjectionDefinition(String code, String name, String definition) {
            this.code = code.intern();
            this.name = name.intern();
            this.definition = definition.intern();
        }
    }
}

