/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.openstreetmap.josm.actions.ActionParameter;
import org.openstreetmap.josm.actions.AdaptableAction;
import org.openstreetmap.josm.actions.AddImageryLayerAction;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.ParameterizedAction;
import org.openstreetmap.josm.actions.ParameterizedActionDecorator;
import org.openstreetmap.josm.actions.ToggleAction;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.imagery.ImageryLayerInfo;
import org.openstreetmap.josm.gui.IconToggleButton;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.preferences.DefaultTabPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceDialog;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetListener;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresets;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.util.ReorderableTableModel;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;

public class ToolbarPreferences
implements PreferenceSettingFactory,
TaggingPresetListener {
    private static final String EMPTY_TOOLBAR_MARKER = "<!-empty-!>";
    public static final String IMAGERY_PREFIX = "imagery_";
    private final ToolbarPopupMenu popupMenu = new ToolbarPopupMenu();
    private final Map<String, Action> regactions = new ConcurrentHashMap<String, Action>();
    private final DefaultMutableTreeNode rootActionsNode = new DefaultMutableTreeNode(I18n.tr("Actions", new Object[0]));
    public final JToolBar control = new JToolBar();
    private final Map<Object, ActionDefinition> buttonActions = new ConcurrentHashMap<Object, ActionDefinition>(30);
    private boolean showInfoAboutMissingActions;
    private static final String[] deftoolbar = new String[]{"open", "save", "download", "upload", "|", "undo", "redo", "|", "dialogs/search", "preference", "|", "splitway", "combineway", "wayflip", "|", "imagery-offset", "|", "tagginggroup_Highways/Streets", "tagginggroup_Highways/Ways", "tagginggroup_Highways/Waypoints", "tagginggroup_Highways/Barriers", "|", "tagginggroup_Transport/Car", "tagginggroup_Transport/Public Transport", "|", "tagginggroup_Facilities/Tourism", "tagginggroup_Facilities/Food+Drinks", "|", "tagginggroup_Man Made/Historic Places", "|", "tagginggroup_Man Made/Man Made"};
    private static final DataFlavor ACTION_FLAVOR = new DataFlavor(ActionDefinition.class, "ActionItem");

    @Override
    public PreferenceSetting createPreferenceSetting() {
        return new Settings(this.rootActionsNode);
    }

    public ToolbarPreferences() {
        GuiHelper.runInEDTAndWait(() -> {
            this.control.setFloatable(false);
            this.control.setComponentPopupMenu(this.popupMenu);
        });
        MapFrame.TOOLBAR_VISIBLE.addListener(e -> this.refreshToolbarControl());
        TaggingPresets.addListener(this);
    }

    private static void loadAction(DefaultMutableTreeNode node, MenuElement menu, Map<String, Action> actionsInMenu) {
        Object userObject = null;
        MenuElement menuElement = menu;
        if (menu.getSubElements().length > 0 && menu.getSubElements()[0] instanceof JPopupMenu) {
            menuElement = menu.getSubElements()[0];
        }
        for (MenuElement item : menuElement.getSubElements()) {
            if (item instanceof JMenuItem) {
                JMenuItem menuItem = (JMenuItem)item;
                if (menuItem.getAction() != null) {
                    Action action = menuItem.getAction();
                    userObject = action;
                    Object tb = action.getValue("toolbar");
                    if (tb == null) {
                        Logging.info(I18n.tr("Toolbar action without name: {0}", action.getClass().getName()));
                        continue;
                    }
                    if (!(tb instanceof String)) {
                        if (tb instanceof Boolean && !((Boolean)tb).booleanValue()) continue;
                        Logging.info(I18n.tr("Strange toolbar value: {0}", action.getClass().getName()));
                        continue;
                    }
                    String toolbar = (String)tb;
                    Action r = actionsInMenu.get(toolbar);
                    if (r != null && r != action && !toolbar.startsWith(IMAGERY_PREFIX)) {
                        Logging.info(I18n.tr("Toolbar action {0} overwritten: {1} gets {2}", toolbar, r.getClass().getName(), action.getClass().getName()));
                    }
                    actionsInMenu.put(toolbar, action);
                } else {
                    userObject = menuItem.getText();
                }
            }
            DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(userObject);
            node.add(newNode);
            ToolbarPreferences.loadAction(newNode, item, actionsInMenu);
        }
    }

    private void loadActions(Map<String, Action> actionsInMenu) {
        this.rootActionsNode.removeAllChildren();
        ToolbarPreferences.loadAction(this.rootActionsNode, MainApplication.getMenu(), actionsInMenu);
        for (Map.Entry<String, Action> a : this.regactions.entrySet()) {
            if (actionsInMenu.get(a.getKey()) != null) continue;
            this.rootActionsNode.add(new DefaultMutableTreeNode(a.getValue()));
        }
        this.rootActionsNode.add(new DefaultMutableTreeNode(null));
    }

    public static Collection<String> getToolString() {
        List<String> toolStr = Config.getPref().getList("toolbar", Arrays.asList(deftoolbar));
        if (Utils.isEmpty(toolStr)) {
            toolStr = Arrays.asList(deftoolbar);
        }
        return toolStr;
    }

    private Collection<ActionDefinition> getDefinedActions() {
        ConcurrentHashMap<String, Action> actionsInMenu = new ConcurrentHashMap<String, Action>();
        this.loadActions(actionsInMenu);
        ConcurrentHashMap<String, Action> allActions = new ConcurrentHashMap<String, Action>(this.regactions);
        allActions.putAll(actionsInMenu);
        ActionParser actionParser = new ActionParser(allActions);
        ArrayList<ActionDefinition> result = new ArrayList<ActionDefinition>();
        for (String s : ToolbarPreferences.getToolString()) {
            if ("|".equals(s)) {
                result.add(ActionDefinition.getSeparator());
                continue;
            }
            ActionDefinition a = actionParser.loadAction(s);
            if (a != null) {
                result.add(a);
                continue;
            }
            if (!this.showInfoAboutMissingActions) continue;
            Logging.info("Could not load tool definition " + s);
        }
        return result;
    }

    public Action register(Action action) {
        String toolbar = (String)action.getValue("toolbar");
        if (toolbar == null) {
            Logging.info(I18n.tr("Registered toolbar action without name: {0}", action.getClass().getName()));
        } else {
            Action r = this.regactions.get(toolbar);
            if (r != null) {
                Logging.info(I18n.tr("Registered toolbar action {0} overwritten: {1} gets {2}", toolbar, r.getClass().getName(), action.getClass().getName()));
            }
        }
        if (toolbar != null) {
            this.regactions.put(toolbar, action);
        }
        return action;
    }

    public Action unregister(Action action) {
        Object toolbar = action.getValue("toolbar");
        if (toolbar instanceof String) {
            return this.regactions.remove(toolbar);
        }
        return null;
    }

    public void refreshToolbarControl() {
        this.control.removeAll();
        this.buttonActions.clear();
        boolean unregisterTab = Shortcut.findShortcut(9, 0).isPresent();
        for (ActionDefinition action : this.getDefinedActions()) {
            if (action.isSeparator()) {
                this.control.addSeparator();
                continue;
            }
            AbstractButton b = this.addButtonAndShortcut(action);
            this.buttonActions.put(b, action);
            Icon i = action.getDisplayIcon();
            if (i != null) {
                b.setIcon(i);
                Dimension s = b.getPreferredSize();
                if (s.width < s.height) {
                    s.width = s.height;
                    b.setMinimumSize(s);
                    b.setMaximumSize(s);
                } else if (s.height < s.width) {
                    s.height = s.width;
                    b.setMinimumSize(s);
                    b.setMaximumSize(s);
                }
            } else {
                action.getParametrizedAction().addPropertyChangeListener(evt -> {
                    if ("SmallIcon".equals(evt.getPropertyName())) {
                        b.setHideActionText(evt.getNewValue() != null);
                    }
                });
            }
            b.setInheritsPopupMenu(true);
            b.setFocusTraversalKeysEnabled(!unregisterTab);
        }
        boolean visible = MapFrame.TOOLBAR_VISIBLE.get();
        this.control.setFocusTraversalKeysEnabled(!unregisterTab);
        this.control.setVisible(visible && this.control.getComponentCount() != 0);
        this.control.repaint();
    }

    public void addCustomButton(String definitionText, int preferredIndex, boolean removeIfExists) {
        LinkedList<String> t = new LinkedList<String>(ToolbarPreferences.getToolString());
        if (t.contains(definitionText)) {
            if (!removeIfExists) {
                return;
            }
            t.remove(definitionText);
        } else if (preferredIndex >= 0 && preferredIndex < t.size()) {
            t.add(preferredIndex, definitionText);
        } else {
            t.add(definitionText);
        }
        Config.getPref().putList("toolbar", t);
        MainApplication.getToolbar().refreshToolbarControl();
    }

    private AbstractButton addButtonAndShortcut(ActionDefinition action) {
        String tt;
        AbstractButton b;
        block12: {
            long paramCode;
            Shortcut sc;
            Action act;
            block11: {
                act = action.getParametrizedAction();
                if (act instanceof ToggleAction) {
                    b = new IconToggleButton(act);
                    this.control.add(b);
                } else {
                    b = this.control.add(act);
                }
                sc = null;
                if (action.getAction() instanceof JosmAction && (sc = ((JosmAction)action.getAction()).getShortcut()).getAssignedKey() == 65535) {
                    sc = null;
                }
                paramCode = 0L;
                if (action.hasParameters()) {
                    paramCode = action.parameters.hashCode();
                }
                tt = Optional.ofNullable(action.getDisplayTooltip()).orElse("");
                if (sc == null) break block11;
                if (paramCode == 0L) break block12;
            }
            String name = Optional.ofNullable((String)action.getAction().getValue("toolbar")).orElseGet(action::getDisplayName);
            if (paramCode != 0L) {
                name = name + paramCode;
            }
            String desc = action.getDisplayName() + (paramCode == 0L ? "" : action.parameters.toString());
            sc = Shortcut.registerShortcut("toolbar:" + name, I18n.tr("Toolbar: {0}", desc), 65535, 5000);
            MainApplication.unregisterShortcut(sc);
            MainApplication.registerActionShortcut(act, sc);
            if (sc.isAssignedUser()) {
                if (tt.startsWith("<html>") && tt.endsWith("</html>")) {
                    tt = tt.substring(6, tt.length() - 6);
                }
                tt = Shortcut.makeTooltip(tt, sc.getKeyStroke());
            }
        }
        if (!tt.isEmpty()) {
            b.setToolTipText(tt);
        }
        return b;
    }

    @Override
    public void taggingPresetsModified() {
        this.refreshToolbarControl();
    }

    public void enableInfoAboutMissingAction() {
        this.showInfoAboutMissingActions = true;
    }

    public class Settings
    extends DefaultTabPreferenceSetting {
        private final Move moveAction;
        private final ActionDefinitionModel selected;
        private final JList<ActionDefinition> selectedList;
        private final DefaultTreeModel actionsTreeModel;
        private final JTree actionsTree;
        private final ActionParametersTableModel actionParametersModel;
        private final JTable actionParametersTable;
        private JPanel actionParametersPanel;
        private final JButton upButton;
        private final JButton downButton;
        private final JButton removeButton;
        private final JButton addButton;
        private String movingComponent;

        public Settings(DefaultMutableTreeNode rootActionsNode) {
            super("toolbar", I18n.tr("Toolbar", new Object[0]), I18n.tr("Customize the elements on the toolbar.", new Object[0]));
            this.moveAction = new Move();
            this.selected = new ActionDefinitionModel();
            this.selectedList = new JList<ActionDefinition>(this.selected);
            this.actionParametersModel = new ActionParametersTableModel();
            this.actionParametersTable = new JTable(this.actionParametersModel);
            this.upButton = this.createButton("up");
            this.downButton = this.createButton("down");
            this.removeButton = this.createButton(">");
            this.addButton = this.createButton("<");
            this.actionsTreeModel = new DefaultTreeModel(rootActionsNode);
            this.actionsTree = new JTree(this.actionsTreeModel);
        }

        private JButton createButton(String name) {
            JButton b = new JButton();
            if ("up".equals(name)) {
                b.setIcon(ImageProvider.get("dialogs", "up", ImageProvider.ImageSizes.LARGEICON));
                b.setToolTipText(I18n.tr("Move the currently selected members up", new Object[0]));
            } else if ("down".equals(name)) {
                b.setIcon(ImageProvider.get("dialogs", "down", ImageProvider.ImageSizes.LARGEICON));
                b.setToolTipText(I18n.tr("Move the currently selected members down", new Object[0]));
            } else if ("<".equals(name)) {
                b.setIcon(ImageProvider.get("dialogs/conflict", "copybeforecurrentright", ImageProvider.ImageSizes.LARGEICON));
                b.setToolTipText(I18n.tr("Add all objects selected in the current dataset before the first selected member", new Object[0]));
            } else if (">".equals(name)) {
                b.setIcon(ImageProvider.get("dialogs", "delete", ImageProvider.ImageSizes.LARGEICON));
                b.setToolTipText(I18n.tr("Remove", new Object[0]));
            }
            b.addActionListener(this.moveAction);
            b.setActionCommand(name);
            return b;
        }

        private void updateEnabledState() {
            int index = this.selectedList.getSelectedIndex();
            this.upButton.setEnabled(index > 0);
            this.downButton.setEnabled(index != -1 && index < this.selectedList.getModel().getSize() - 1);
            this.removeButton.setEnabled(index != -1);
            this.addButton.setEnabled(this.actionsTree.getSelectionCount() > 0);
        }

        @Override
        public void addGui(PreferenceTabbedPane gui) {
            this.actionsTree.setCellRenderer(new DefaultTreeCellRenderer(){

                @Override
                public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
                    JLabel comp = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                    if (node.getUserObject() == null) {
                        comp.setText(I18n.tr("Separator", new Object[0]));
                        comp.setIcon(ImageProvider.get("preferences/separator"));
                    } else if (node.getUserObject() instanceof Action) {
                        Action action = (Action)node.getUserObject();
                        comp.setText((String)action.getValue("Name"));
                        comp.setIcon((Icon)action.getValue("SmallIcon"));
                    }
                    return comp;
                }
            });
            ListCellRenderer<ActionDefinition> renderer = new ListCellRenderer<ActionDefinition>(){
                private final DefaultListCellRenderer def = new DefaultListCellRenderer();

                @Override
                public Component getListCellRendererComponent(JList<? extends ActionDefinition> list, ActionDefinition action, int index, boolean isSelected, boolean cellHasFocus) {
                    Icon i;
                    String s;
                    if (!action.isSeparator()) {
                        s = action.getDisplayName();
                        i = action.getDisplayIcon();
                    } else {
                        i = ImageProvider.get("preferences/separator");
                        s = I18n.tr("Separator", new Object[0]);
                    }
                    JLabel l = (JLabel)this.def.getListCellRendererComponent(list, s, index, isSelected, cellHasFocus);
                    l.setIcon(i);
                    return l;
                }
            };
            this.selectedList.setCellRenderer(renderer);
            this.selectedList.addListSelectionListener(e -> {
                boolean sel;
                boolean bl = sel = this.selectedList.getSelectedIndex() != -1;
                if (sel) {
                    this.actionsTree.clearSelection();
                    ActionDefinition action = (ActionDefinition)this.selected.get(this.selectedList.getSelectedIndex());
                    this.actionParametersModel.setCurrentAction(action);
                    this.actionParametersPanel.setVisible(this.actionParametersModel.getRowCount() > 0);
                }
                this.updateEnabledState();
            });
            if (!GraphicsEnvironment.isHeadless()) {
                this.selectedList.setDragEnabled(true);
            }
            this.selectedList.setTransferHandler(new SelectedListTransferHandler());
            this.actionsTree.setTransferHandler(new TransferHandler(){
                private static final long serialVersionUID = 1L;

                @Override
                public int getSourceActions(JComponent c) {
                    return 2;
                }

                @Override
                protected Transferable createTransferable(JComponent c) {
                    TreePath[] paths = Settings.this.actionsTree.getSelectionPaths();
                    ArrayList<ActionDefinition> dragActions = new ArrayList<ActionDefinition>();
                    for (TreePath path : paths) {
                        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                        Object obj = node.getUserObject();
                        if (obj == null) {
                            dragActions.add(ActionDefinition.getSeparator());
                            continue;
                        }
                        if (!(obj instanceof Action)) continue;
                        dragActions.add(new ActionDefinition((Action)obj));
                    }
                    return new ActionTransferable(dragActions);
                }
            });
            if (!GraphicsEnvironment.isHeadless()) {
                this.actionsTree.setDragEnabled(true);
            }
            this.actionsTree.getSelectionModel().addTreeSelectionListener(e -> this.updateEnabledState());
            final JPanel left = new JPanel(new GridBagLayout());
            left.add((Component)new JLabel(I18n.tr("Toolbar", new Object[0])), GBC.eol());
            left.add((Component)new JScrollPane(this.selectedList), GBC.std().fill(1));
            final JPanel right = new JPanel(new GridBagLayout());
            right.add((Component)new JLabel(I18n.tr("Available", new Object[0])), GBC.eol());
            right.add((Component)new JScrollPane(this.actionsTree), GBC.eol().fill(1));
            final JPanel buttons = new JPanel(new GridLayout(6, 1));
            buttons.add(this.upButton);
            buttons.add(this.addButton);
            buttons.add(this.removeButton);
            buttons.add(this.downButton);
            this.updateEnabledState();
            final JPanel p = new JPanel();
            p.setLayout(new LayoutManager(){

                @Override
                public void addLayoutComponent(String name, Component comp) {
                }

                @Override
                public void removeLayoutComponent(Component comp) {
                }

                @Override
                public Dimension minimumLayoutSize(Container parent) {
                    Dimension l = left.getMinimumSize();
                    Dimension r = right.getMinimumSize();
                    Dimension b = buttons.getMinimumSize();
                    return new Dimension(l.width + b.width + 10 + r.width, l.height + b.height + 10 + r.height);
                }

                @Override
                public Dimension preferredLayoutSize(Container parent) {
                    Dimension l = new Dimension(200, 200);
                    Dimension r = new Dimension(200, 200);
                    return new Dimension(l.width + r.width + 10 + buttons.getPreferredSize().width, Math.max(l.height, r.height));
                }

                @Override
                public void layoutContainer(Container parent) {
                    Dimension d = p.getSize();
                    Dimension b = buttons.getPreferredSize();
                    int width = (d.width - 10 - b.width) / 2;
                    left.setBounds(new Rectangle(0, 0, width, d.height));
                    right.setBounds(new Rectangle(width + 10 + b.width, 0, width, d.height));
                    buttons.setBounds(new Rectangle(width + 5, d.height / 2 - b.height / 2, b.width, b.height));
                }
            });
            p.add(left);
            p.add(buttons);
            p.add(right);
            this.actionParametersPanel = new JPanel(new GridBagLayout());
            this.actionParametersPanel.add((Component)new JLabel(I18n.tr("Action parameters", new Object[0])), GBC.eol().insets(0, 10, 0, 20));
            this.actionParametersTable.getColumnModel().getColumn(0).setHeaderValue(I18n.tr("Parameter name", new Object[0]));
            this.actionParametersTable.getColumnModel().getColumn(1).setHeaderValue(I18n.tr("Parameter value", new Object[0]));
            this.actionParametersPanel.add((Component)this.actionParametersTable.getTableHeader(), GBC.eol().fill(2));
            this.actionParametersPanel.add((Component)this.actionParametersTable, GBC.eol().fill(1).insets(0, 0, 0, 10));
            this.actionParametersPanel.setVisible(false);
            PreferenceTabbedPane.PreferencePanel panel = gui.createPreferenceTab(this);
            panel.add((Component)p, GBC.eol().fill(1));
            panel.add((Component)this.actionParametersPanel, GBC.eol().fill(2));
            this.selected.removeAllElements();
            for (ActionDefinition actionDefinition : ToolbarPreferences.this.getDefinedActions()) {
                this.selected.addElement(actionDefinition);
            }
            this.actionsTreeModel.reload();
        }

        @Override
        public boolean ok() {
            LinkedList<String> t = new LinkedList();
            ActionParser parser = new ActionParser(null);
            for (int i = 0; i < this.selected.size(); ++i) {
                ActionDefinition action = (ActionDefinition)this.selected.get(i);
                if (action.isSeparator()) {
                    t.add("|");
                    continue;
                }
                String res = parser.saveAction(action);
                if (res == null) continue;
                t.add(res);
            }
            if (t.isEmpty()) {
                t = Collections.singletonList(ToolbarPreferences.EMPTY_TOOLBAR_MARKER);
            }
            Config.getPref().putList("toolbar", t);
            MainApplication.getToolbar().refreshToolbarControl();
            return false;
        }

        @Override
        public String getHelpContext() {
            return HelpUtil.ht("/Preferences/Toolbar");
        }

        private class ActionDefinitionModel
        extends DefaultListModel<ActionDefinition>
        implements ReorderableTableModel<ActionDefinition> {
            private ActionDefinitionModel() {
            }

            @Override
            public ListSelectionModel getSelectionModel() {
                return Settings.this.selectedList.getSelectionModel();
            }

            @Override
            public int getRowCount() {
                return this.getSize();
            }

            @Override
            public ActionDefinition getValue(int index) {
                return (ActionDefinition)this.getElementAt(index);
            }

            @Override
            public ActionDefinition setValue(int index, ActionDefinition value) {
                return this.set(index, value);
            }
        }

        private class ActionTransferable
        implements Transferable {
            private final DataFlavor[] flavors = new DataFlavor[]{ToolbarPreferences.access$400()};
            private final List<ActionDefinition> actions;

            ActionTransferable(List<ActionDefinition> actions) {
                this.actions = actions;
            }

            @Override
            public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
                return this.actions;
            }

            @Override
            public DataFlavor[] getTransferDataFlavors() {
                return this.flavors;
            }

            @Override
            public boolean isDataFlavorSupported(DataFlavor flavor) {
                return this.flavors[0] == flavor;
            }
        }

        private final class Move
        implements ActionListener {
            private Move() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if ("<".equals(e.getActionCommand()) && Settings.this.actionsTree.getSelectionCount() > 0) {
                    int leadItem = Settings.this.selected.getSize();
                    if (Settings.this.selectedList.getSelectedIndex() != -1) {
                        int[] indices = Settings.this.selectedList.getSelectedIndices();
                        leadItem = indices[indices.length - 1];
                    }
                    for (TreePath selectedAction : Settings.this.actionsTree.getSelectionPaths()) {
                        DefaultMutableTreeNode node = (DefaultMutableTreeNode)selectedAction.getLastPathComponent();
                        if (node.getUserObject() == null) {
                            Settings.this.selected.add(leadItem++, ActionDefinition.getSeparator());
                            continue;
                        }
                        if (!(node.getUserObject() instanceof Action)) continue;
                        Settings.this.selected.add(leadItem++, new ActionDefinition((Action)node.getUserObject()));
                    }
                } else if (">".equals(e.getActionCommand()) && Settings.this.selectedList.getSelectedIndex() != -1) {
                    while (Settings.this.selectedList.getSelectedIndex() != -1) {
                        Settings.this.selected.remove(Settings.this.selectedList.getSelectedIndex());
                    }
                } else if ("up".equals(e.getActionCommand())) {
                    Settings.this.selected.moveUp();
                } else if ("down".equals(e.getActionCommand())) {
                    Settings.this.selected.moveDown();
                }
            }
        }

        private final class SelectedListTransferHandler
        extends TransferHandler {
            private SelectedListTransferHandler() {
            }

            @Override
            protected Transferable createTransferable(JComponent c) {
                ArrayList<ActionDefinition> actions = new ArrayList<ActionDefinition>(((JList)c).getSelectedValuesList());
                return new ActionTransferable(actions);
            }

            @Override
            public int getSourceActions(JComponent c) {
                return 2;
            }

            @Override
            public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
                return Arrays.stream(transferFlavors).anyMatch(ACTION_FLAVOR::equals);
            }

            @Override
            public void exportAsDrag(JComponent comp, InputEvent e, int action) {
                super.exportAsDrag(comp, e, action);
                Settings.this.movingComponent = "list";
            }

            @Override
            public boolean importData(JComponent comp, Transferable t) {
                try {
                    int dropIndex = Settings.this.selectedList.locationToIndex(Settings.this.selectedList.getMousePosition(true));
                    List draggedData = (List)t.getTransferData(ACTION_FLAVOR);
                    Object leadItem = dropIndex >= 0 ? (Object)Settings.this.selected.elementAt(dropIndex) : null;
                    int dataLength = draggedData.size();
                    if (leadItem != null) {
                        for (Object o : draggedData) {
                            if (!leadItem.equals(o)) continue;
                            return false;
                        }
                    }
                    int dragLeadIndex = -1;
                    boolean localDrop = "list".equals(Settings.this.movingComponent);
                    if (localDrop) {
                        dragLeadIndex = Settings.this.selected.indexOf(draggedData.get(0));
                        for (Object o : draggedData) {
                            Settings.this.selected.removeElement(o);
                        }
                    }
                    int[] indices = new int[dataLength];
                    if (localDrop) {
                        int adjustedLeadIndex = Settings.this.selected.indexOf(leadItem);
                        int insertionAdjustment = dragLeadIndex <= adjustedLeadIndex ? 1 : 0;
                        for (int i = 0; i < dataLength; ++i) {
                            Settings.this.selected.insertElementAt((ActionDefinition)draggedData.get(i), adjustedLeadIndex + insertionAdjustment + i);
                            indices[i] = adjustedLeadIndex + insertionAdjustment + i;
                        }
                    } else {
                        for (int i = 0; i < dataLength; ++i) {
                            Settings.this.selected.add(dropIndex, (ActionDefinition)draggedData.get(i));
                            indices[i] = dropIndex + i;
                        }
                    }
                    Settings.this.selectedList.clearSelection();
                    Settings.this.selectedList.setSelectedIndices(indices);
                    Settings.this.movingComponent = "";
                    return true;
                }
                catch (UnsupportedFlavorException | IOException e) {
                    Logging.error(e);
                    return false;
                }
            }

            @Override
            protected void exportDone(JComponent source, Transferable data, int action) {
                if ("list".equals(Settings.this.movingComponent)) {
                    try {
                        List draggedData = (List)data.getTransferData(ACTION_FLAVOR);
                        boolean localDrop = Settings.this.selected.contains(draggedData.get(0));
                        if (localDrop) {
                            int[] indices = Settings.this.selectedList.getSelectedIndices();
                            Arrays.sort(indices);
                            for (int i = indices.length - 1; i >= 0; --i) {
                                Settings.this.selected.remove(indices[i]);
                            }
                        }
                    }
                    catch (UnsupportedFlavorException | IOException e) {
                        Logging.error(e);
                    }
                    Settings.this.movingComponent = "";
                }
            }
        }
    }

    private class ToolbarPopupMenu
    extends JPopupMenu {
        private transient ActionDefinition act;
        private final JMenuItem remove = new JMenuItem(new AbstractAction(I18n.tr("Remove from toolbar", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                LinkedList<String> t = new LinkedList<String>(ToolbarPreferences.getToolString());
                ActionParser parser = new ActionParser(null);
                String res = parser.saveAction(ToolbarPopupMenu.this.act);
                t.remove(res);
                Config.getPref().putList("toolbar", t);
                MainApplication.getToolbar().refreshToolbarControl();
            }
        });
        private final JMenuItem configure = new JMenuItem(new AbstractAction(I18n.tr("Configure toolbar", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreferenceDialog p = new PreferenceDialog((Component)MainApplication.getMainFrame());
                SwingUtilities.invokeLater(() -> p.selectPreferencesTabByName("toolbar"));
                p.setVisible(true);
            }
        });
        private final JMenuItem shortcutEdit = new JMenuItem(new AbstractAction(I18n.tr("Edit shortcut", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreferenceDialog p = new PreferenceDialog((Component)MainApplication.getMainFrame());
                p.getTabbedPane().getShortcutPreference().setDefaultFilter(ToolbarPopupMenu.this.act.getDisplayName());
                SwingUtilities.invokeLater(() -> p.selectPreferencesTabByName("shortcuts"));
                p.setVisible(true);
                MainApplication.getToolbar().refreshToolbarControl();
            }
        });
        private final JCheckBoxMenuItem doNotHide = new JCheckBoxMenuItem(new AbstractAction(I18n.tr("Do not hide toolbar and menu", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean sel = ((JCheckBoxMenuItem)e.getSource()).getState();
                Config.getPref().putBoolean("toolbar.always-visible", sel);
                Config.getPref().putBoolean("menu.always-visible", sel);
            }
        });

        private ToolbarPopupMenu() {
            this.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    ToolbarPopupMenu.this.setActionAndAdapt((ActionDefinition)ToolbarPreferences.this.buttonActions.get(((JPopupMenu)e.getSource()).getInvoker()));
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                }
            });
            this.add(this.remove);
            this.add(this.configure);
            this.add(this.shortcutEdit);
            this.add(this.doNotHide);
        }

        private void setActionAndAdapt(ActionDefinition action) {
            this.act = action;
            this.doNotHide.setSelected(Config.getPref().getBoolean("toolbar.always-visible", true));
            this.remove.setVisible(this.act != null);
            this.shortcutEdit.setVisible(this.act != null);
        }
    }

    private static class ActionParametersTableModel
    extends AbstractTableModel {
        private transient ActionDefinition currentAction = ActionDefinition.getSeparator();

        private ActionParametersTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            int adaptable;
            int n = adaptable = this.currentAction.getAction() instanceof AdaptableAction ? 2 : 0;
            if (this.currentAction.isSeparator() || !(this.currentAction.getAction() instanceof ParameterizedAction)) {
                return adaptable;
            }
            ParameterizedAction pa = (ParameterizedAction)this.currentAction.getAction();
            return pa.getActionParameters().size() + adaptable;
        }

        private ActionParameter<Object> getParam(int index) {
            ParameterizedAction pa = (ParameterizedAction)this.currentAction.getAction();
            return pa.getActionParameters().get(index);
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (this.currentAction.getAction() instanceof AdaptableAction) {
                if (rowIndex < 2) {
                    switch (columnIndex) {
                        case 0: {
                            return rowIndex == 0 ? I18n.tr("Tooltip", new Object[0]) : I18n.tr("Icon", new Object[0]);
                        }
                        case 1: {
                            return rowIndex == 0 ? this.currentAction.getName() : this.currentAction.getIcon();
                        }
                    }
                    return null;
                }
                rowIndex -= 2;
            }
            ActionParameter<Object> param = this.getParam(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return param.getName();
                }
                case 1: {
                    return param.writeToString(this.currentAction.getParameters().get(param.getName()));
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == 1;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            ActionParameter<Object> param;
            String val = (String)aValue;
            int paramIndex = rowIndex;
            if (this.currentAction.getAction() instanceof AdaptableAction) {
                if (rowIndex == 0) {
                    this.currentAction.setName(val);
                    return;
                }
                if (rowIndex == 1) {
                    this.currentAction.setIcon(val);
                    return;
                }
                paramIndex -= 2;
            }
            if ((param = this.getParam(paramIndex)) != null && !val.isEmpty()) {
                this.currentAction.getParameters().put(param.getName(), param.readFromString((String)aValue));
            }
        }

        public void setCurrentAction(ActionDefinition currentAction) {
            this.currentAction = currentAction;
            this.fireTableDataChanged();
        }
    }

    public static class ActionParser {
        private final Map<String, Action> actions;
        private final StringBuilder result = new StringBuilder();
        private int index;
        private char[] s;

        public ActionParser(Map<String, Action> actions) {
            this.actions = actions;
        }

        private String readTillChar(char ch1, char ch2) {
            this.result.setLength(0);
            while (this.index < this.s.length && this.s[this.index] != ch1 && this.s[this.index] != ch2) {
                if (this.s[this.index] == '\\') {
                    ++this.index;
                    if (this.index >= this.s.length) break;
                }
                this.result.append(this.s[this.index]);
                ++this.index;
            }
            return this.result.toString();
        }

        private void skip(char ch) {
            if (this.index < this.s.length && this.s[this.index] == ch) {
                ++this.index;
            }
        }

        public ActionDefinition loadAction(String actionName) {
            this.index = 0;
            this.s = actionName.toCharArray();
            String name = this.readTillChar('(', '{');
            Action action = this.actions.get(name);
            if (action == null && name.startsWith(ToolbarPreferences.IMAGERY_PREFIX)) {
                String imageryName = name.substring(ToolbarPreferences.IMAGERY_PREFIX.length());
                for (ImageryInfo i : ImageryLayerInfo.instance.getDefaultLayers()) {
                    if (!imageryName.equalsIgnoreCase(i.getName())) continue;
                    action = new AddImageryLayerAction(i);
                    break;
                }
            }
            if (action == null) {
                return null;
            }
            ActionDefinition result = new ActionDefinition(action);
            if (action instanceof ParameterizedAction) {
                this.skip('(');
                ParameterizedAction parametrizedAction = (ParameterizedAction)action;
                ConcurrentHashMap actionParams = new ConcurrentHashMap();
                for (ActionParameter<?> param : parametrizedAction.getActionParameters()) {
                    actionParams.put(param.getName(), param);
                }
                while (this.index < this.s.length && this.s[this.index] != ')') {
                    ActionParameter actionParam;
                    String paramName = this.readTillChar('=', '=');
                    this.skip('=');
                    String paramValue = this.readTillChar(',', ')');
                    if (!paramName.isEmpty() && !paramValue.isEmpty() && (actionParam = (ActionParameter)actionParams.get(paramName)) != null) {
                        result.getParameters().put(paramName, actionParam.readFromString(paramValue));
                    }
                    this.skip(',');
                }
                this.skip(')');
            }
            if (action instanceof AdaptableAction) {
                this.skip('{');
                while (this.index < this.s.length && this.s[this.index] != '}') {
                    String paramName = this.readTillChar('=', '=');
                    this.skip('=');
                    String paramValue = this.readTillChar(',', '}');
                    if ("icon".equals(paramName) && !paramValue.isEmpty()) {
                        result.setIcon(paramValue);
                    } else if ("name".equals(paramName) && !paramValue.isEmpty()) {
                        result.setName(paramValue);
                    }
                    this.skip(',');
                }
                this.skip('}');
            }
            return result;
        }

        private void escape(String s) {
            for (int i = 0; i < s.length(); ++i) {
                char ch = s.charAt(i);
                if (ch == '\\' || ch == '(' || ch == '{' || ch == ',' || ch == ')' || ch == '}' || ch == '=') {
                    this.result.append('\\');
                }
                this.result.append(ch);
            }
        }

        public String saveAction(ActionDefinition action) {
            this.result.setLength(0);
            String val = (String)action.getAction().getValue("toolbar");
            if (val == null) {
                return null;
            }
            this.escape(val);
            if (action.getAction() instanceof ParameterizedAction) {
                this.result.append('(');
                List<ActionParameter<?>> params = ((ParameterizedAction)action.getAction()).getActionParameters();
                for (int i = 0; i < params.size(); ++i) {
                    ActionParameter<?> param = params.get(i);
                    this.escape(param.getName());
                    this.result.append('=');
                    Object value = action.getParameters().get(param.getName());
                    if (value != null) {
                        this.escape(param.writeToString(value));
                    }
                    if (i < params.size() - 1) {
                        this.result.append(',');
                        continue;
                    }
                    this.result.append(')');
                }
            }
            if (action.getAction() instanceof AdaptableAction) {
                boolean first = true;
                String tmp = action.getName();
                if (!tmp.isEmpty()) {
                    this.result.append(first ? "{" : ",");
                    this.result.append("name=");
                    this.escape(tmp);
                    first = false;
                }
                if (!(tmp = action.getIcon()).isEmpty()) {
                    this.result.append(first ? "{" : ",");
                    this.result.append("icon=");
                    this.escape(tmp);
                    first = false;
                }
                if (!first) {
                    this.result.append('}');
                }
            }
            return this.result.toString();
        }
    }

    public static class ActionDefinition {
        private final Action action;
        private String name = "";
        private String icon = "";
        private ImageIcon ico;
        private final Map<String, Object> parameters = new ConcurrentHashMap<String, Object>();

        public ActionDefinition(Action action) {
            this.action = action;
        }

        public Map<String, Object> getParameters() {
            return this.parameters;
        }

        public Action getParametrizedAction() {
            if (this.getAction() instanceof ParameterizedAction) {
                return new ParameterizedActionDecorator((ParameterizedAction)this.getAction(), this.parameters);
            }
            return this.getAction();
        }

        public Action getAction() {
            return this.action;
        }

        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            return this.name.isEmpty() ? (String)this.action.getValue("Name") : this.name;
        }

        public String getDisplayTooltip() {
            if (!this.name.isEmpty()) {
                return this.name;
            }
            Object tt = this.action.getValue("Optional tooltip text");
            if (tt != null) {
                return (String)tt;
            }
            return (String)this.action.getValue("ShortDescription");
        }

        public Icon getDisplayIcon() {
            if (this.ico != null) {
                return this.ico;
            }
            return (Icon)Optional.ofNullable(this.action.getValue("SwingLargeIconKey")).orElseGet(() -> this.action.getValue("SmallIcon"));
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getIcon() {
            return this.icon;
        }

        public void setIcon(String icon) {
            this.icon = icon;
            this.ico = ImageProvider.getIfAvailable("", icon);
        }

        public boolean isSeparator() {
            return this.action == null;
        }

        public static ActionDefinition getSeparator() {
            return new ActionDefinition(null);
        }

        public boolean hasParameters() {
            return this.getAction() instanceof ParameterizedAction && this.parameters.values().stream().anyMatch(Objects::nonNull);
        }
    }
}

