#!/bin/sh

# Copyright (C) 2019-2021 Internet Systems Consortium, Inc. ("ISC")
#
# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.

# shellcheck disable=SC1091
# SC1091: Not following: ... was not specified as input (see shellcheck -x).

# Exit with error if commands exit with non-zero and if undefined variables are
# used.
set -eu

# shellcheck disable=SC2034
# SC2034: ... appears unused. Verify use (or export if used externally).
prefix="/usr"

# Include utilities. Use installed version if available and
# use build version if it isn't.
if [ -e ${prefix}/share/kea/scripts/admin-utils.sh ]; then
    . "${prefix}/share/kea/scripts/admin-utils.sh"
else
    . "/build/kea/src/kea-2.0.3/src/bin/admin/admin-utils.sh"
fi

VERSION=$(mysql_version "$@")

if [ "$VERSION" != "8.2" ]; then
    printf 'This script upgrades 8.2 to 9.0. '
    printf 'Reported version is %s. Skipping upgrade.\n' "${VERSION}"
    exit 0
fi

mysql "$@" <<EOF

# Create hostname index for host reservations
CREATE INDEX hosts_by_hostname ON hosts (hostname);

# Move to lower case hostnames in lease4 table.
UPDATE lease4 SET hostname = LOWER(hostname)
WHERE BINARY LOWER(hostname) != hostname;

# Move to lower case hostnames in lease6 table.
UPDATE lease6 SET hostname = LOWER(hostname)
WHERE BINARY LOWER(hostname) != hostname;

# Create hostname index for lease4
CREATE INDEX lease4_by_hostname ON lease4 (hostname);

# Create hostname index for lease6
CREATE INDEX lease6_by_hostname ON lease6 (hostname);

# Update the schema version number
UPDATE schema_version
SET version = '9', minor = '0';

# This line concludes database upgrade to version 9.0.

EOF
