(window.webpackJsonp=window.webpackJsonp||[]).push([[10],{1490:function(t,n,e){"use strict";var a=e(40),r=e.n(a),o=e(41),i=e.n(o)()(r.a);i.push([t.i,"\n.mail-empty-content {\n\tmargin: 0 auto;\n}\n","",{version:3,sources:["webpack://./src/views/Setup.vue"],names:[],mappings:";AAyFA;CACA,cAAA;AACA",sourcesContent:["<template>\n\t<Content app-name=\"mail\">\n\t\t<Navigation v-if=\"hasAccounts\" />\n\t\t<div class=\"mail-empty-content\">\n\t\t\t<EmptyContent icon=\"icon-mail\">\n\t\t\t\t<h2>{{ t('mail', 'Connect your mail account') }}</h2>\n\t\t\t\t<template #desc>\n\t\t\t\t\t<AccountForm :display-name=\"displayName\" :email=\"email\" :save=\"onSave\">\n\t\t\t\t\t\t<template v-if=\"error\" #feedback class=\"warning\">\n\t\t\t\t\t\t\t{{ error }}\n\t\t\t\t\t\t</template>\n\t\t\t\t\t</AccountForm>\n\t\t\t\t</template>\n\t\t\t</EmptyContent>\n\t\t</div>\n\t</Content>\n</template>\n\n<script>\nimport Content from '@nextcloud/vue/dist/Components/Content'\nimport { loadState } from '@nextcloud/initial-state'\nimport { translate as t } from '@nextcloud/l10n'\n\nimport AccountForm from '../components/AccountForm'\nimport EmptyContent from '@nextcloud/vue/dist/Components/EmptyContent'\nimport Navigation from '../components/Navigation'\nimport logger from '../logger'\n\nexport default {\n\tname: 'Setup',\n\tcomponents: {\n\t\tAccountForm,\n\t\tContent,\n\t\tEmptyContent,\n\t\tNavigation,\n\t},\n\tdata() {\n\t\treturn {\n\t\t\tdisplayName: loadState('mail', 'prefill_displayName'),\n\t\t\temail: loadState('mail', 'prefill_email'),\n\t\t\terror: null,\n\t\t}\n\t},\n\tcomputed: {\n\t\thasAccounts() {\n\t\t\treturn this.$store.getters.accounts.length > 1\n\t\t},\n\t},\n\tmethods: {\n\t\tonSave(data) {\n\t\t\tthis.error = null\n\n\t\t\treturn this.$store\n\t\t\t\t.dispatch('createAccount', data)\n\t\t\t\t.then((account) => {\n\t\t\t\t\tlogger.info('account successfully created, redirecting …')\n\t\t\t\t\tthis.$router.push({\n\t\t\t\t\t\tname: 'home',\n\t\t\t\t\t})\n\n\t\t\t\t\treturn account\n\t\t\t\t})\n\t\t\t\t.catch((error) => {\n\t\t\t\t\tlogger.error('Could not create account', { error })\n\n\t\t\t\t\tif (error.data?.error === 'AUTOCONFIG_FAILED') {\n\t\t\t\t\t\tthis.error = t('mail', 'Auto detect failed. Please try manual mode.')\n\t\t\t\t\t} else if (error.data?.error === 'CONNECTION_ERROR') {\n\t\t\t\t\t\tif (error.data.service === 'IMAP') {\n\t\t\t\t\t\t\tthis.error = t('mail', 'Manual config failed. IMAP server is not reachable.')\n\t\t\t\t\t\t} else if (error.data.service === 'SMTP') {\n\t\t\t\t\t\t\tthis.error = t('mail', 'Manual config failed. SMTP server is not reachable.')\n\t\t\t\t\t\t}\n\t\t\t\t\t} else if (error.data?.error === 'AUTHENTICATION') {\n\t\t\t\t\t\tif (error.data.service === 'IMAP') {\n\t\t\t\t\t\t\tthis.error = t('mail', 'Manual config failed. IMAP username or password is wrong.')\n\t\t\t\t\t\t} else if (error.data.service === 'SMTP') {\n\t\t\t\t\t\t\tthis.error = t('mail', 'Manual config failed. SMTP username or password is wrong.')\n\t\t\t\t\t\t}\n\t\t\t\t\t} else {\n\t\t\t\t\t\tthis.error = t('mail', 'There was an error while setting up your account. Please try again.')\n\t\t\t\t\t}\n\t\t\t\t})\n\t\t},\n\t},\n}\n<\/script>\n\n<style>\n.mail-empty-content {\n\tmargin: 0 auto;\n}\n</style>\n"],sourceRoot:""}]),n.a=i},1532:function(t,n,e){"use strict";e.r(n);var a=e(1102),r=e.n(a),o=e(47),i=e(31),l=e(1237),s=e(569),c=e.n(s),u=e(1232),m=e(9),d={name:"Setup",components:{AccountForm:l.a,Content:r.a,EmptyContent:c.a,Navigation:u.a},data:function(){return{displayName:Object(o.loadState)("mail","prefill_displayName"),email:Object(o.loadState)("mail","prefill_email"),error:null}},computed:{hasAccounts:function(){return this.$store.getters.accounts.length>1}},methods:{onSave:function(t){var n=this;return this.error=null,this.$store.dispatch("createAccount",t).then((function(t){return m.a.info("account successfully created, redirecting …"),n.$router.push({name:"home"}),t})).catch((function(t){var e,a,r;m.a.error("Could not create account",{error:t}),"AUTOCONFIG_FAILED"===(null===(e=t.data)||void 0===e?void 0:e.error)?n.error=Object(i.translate)("mail","Auto detect failed. Please try manual mode."):"CONNECTION_ERROR"===(null===(a=t.data)||void 0===a?void 0:a.error)?"IMAP"===t.data.service?n.error=Object(i.translate)("mail","Manual config failed. IMAP server is not reachable."):"SMTP"===t.data.service&&(n.error=Object(i.translate)("mail","Manual config failed. SMTP server is not reachable.")):"AUTHENTICATION"===(null===(r=t.data)||void 0===r?void 0:r.error)?"IMAP"===t.data.service?n.error=Object(i.translate)("mail","Manual config failed. IMAP username or password is wrong."):"SMTP"===t.data.service&&(n.error=Object(i.translate)("mail","Manual config failed. SMTP username or password is wrong.")):n.error=Object(i.translate)("mail","There was an error while setting up your account. Please try again.")}))}}},p=e(39),f=e.n(p),v=e(1490),h={insert:"head",singleton:!1},A=(f()(v.a,h),v.a.locals,e(29)),g=Object(A.a)(d,(function(){var t=this,n=t.$createElement,e=t._self._c||n;return e("Content",{attrs:{"app-name":"mail"}},[t.hasAccounts?e("Navigation"):t._e(),t._v(" "),e("div",{staticClass:"mail-empty-content"},[e("EmptyContent",{attrs:{icon:"icon-mail"},scopedSlots:t._u([{key:"desc",fn:function(){return[e("AccountForm",{attrs:{"display-name":t.displayName,email:t.email,save:t.onSave},scopedSlots:t._u([t.error?{key:"feedback",fn:function(){return[t._v("\n\t\t\t\t\t\t"+t._s(t.error)+"\n\t\t\t\t\t")]},proxy:!0}:null],null,!0)})]},proxy:!0}])},[e("h2",[t._v(t._s(t.t("mail","Connect your mail account")))])])],1)],1)}),[],!1,null,null,null);n.default=g.exports}},0,[8]]);
//# sourceMappingURL=mail.10.01ce276afc971e2ccf8e.js.map