"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = translate;

var _configSchema = require("@osd/config-schema");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
function translate(server, service) {
  server.post({
    path: '/api/sql_console/translatesql',
    validate: {
      body: _configSchema.schema.any()
    }
  }, async (context, request, response) => {
    const retVal = await service.translateSQL(request);
    return response.ok({
      body: retVal
    });
  });
  server.post({
    path: '/api/sql_console/translateppl',
    validate: {
      body: _configSchema.schema.any()
    }
  }, async (context, request, response) => {
    const retVal = await service.translatePPL(request);
    return response.ok({
      body: retVal
    });
  });
}

module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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