/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.registries;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.directory.api.asn1.util.Oid;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.schema.SchemaErrorHandler;
import org.apache.directory.api.ldap.model.schema.SchemaObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OidRegistry<T extends SchemaObject>
implements Iterable<T> {
    private static final Logger LOG = LoggerFactory.getLogger(OidRegistry.class);
    private Map<String, T> byOid = new HashMap<String, T>();
    private boolean isRelaxed = false;
    private SchemaErrorHandler errorHandler;

    public boolean contains(String oid) {
        return this.byOid.containsKey(oid);
    }

    public String getPrimaryName(String oid) throws LdapException {
        SchemaObject schemaObject = (SchemaObject)this.byOid.get(oid);
        if (schemaObject != null) {
            return schemaObject.getName();
        }
        String msg = I18n.err(I18n.ERR_13741_OID_NOT_FOUND_IN_REGISTRY, oid);
        LdapException error = new LdapException(msg);
        this.errorHandler.handle(LOG, msg, error);
        throw error;
    }

    public T getSchemaObject(String oid) throws LdapException {
        SchemaObject schemaObject = (SchemaObject)this.byOid.get(oid);
        if (schemaObject != null) {
            return (T)schemaObject;
        }
        String msg = I18n.err(I18n.ERR_13742_NO_SCHEMA_OBJECT_WITH_OID, oid);
        LdapException error = new LdapException(msg);
        this.errorHandler.handle(LOG, msg, error);
        throw error;
    }

    public List<String> getNameSet(String oid) throws LdapException {
        SchemaObject schemaObject = (SchemaObject)this.byOid.get(oid);
        if (null == schemaObject) {
            String msg = I18n.err(I18n.ERR_13741_OID_NOT_FOUND_IN_REGISTRY, oid);
            LdapException error = new LdapException(msg);
            this.errorHandler.handle(LOG, msg, error);
            throw error;
        }
        List<String> names = schemaObject.getNames();
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg(I18n.MSG_13756_LOOKED_UP_NAME, ArrayUtils.toString(names), oid));
        }
        return names;
    }

    public Iterator<String> iteratorOids() {
        return Collections.unmodifiableSet(this.byOid.keySet()).iterator();
    }

    @Override
    public Iterator<T> iterator() {
        return this.byOid.values().iterator();
    }

    public boolean isRelaxed() {
        return this.isRelaxed;
    }

    public boolean isStrict() {
        return !this.isRelaxed;
    }

    public void setRelaxed() {
        this.isRelaxed = true;
    }

    public void setStrict() {
        this.isRelaxed = false;
    }

    public SchemaErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(SchemaErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void register(T schemaObject) throws LdapException {
        if (schemaObject == null) {
            String message = I18n.err(I18n.ERR_13743_CANNOT_REGISTER_NULL_SCHEMA_OBJECT, new Object[0]);
            if (LOG.isDebugEnabled()) {
                LOG.debug(message);
            }
            throw new LdapException(message);
        }
        String oid = schemaObject.getOid();
        if (this.isStrict()) {
            if (!Oid.isOid(oid)) {
                String message = I18n.err(I18n.ERR_13744_SCHEMA_OBJECT_HAS_NO_VALID_OID, new Object[0]);
                if (LOG.isDebugEnabled()) {
                    LOG.debug(message);
                }
                throw new LdapException(message);
            }
        } else if (oid == null || oid.isEmpty()) {
            throw new LdapException(I18n.err(I18n.ERR_00003_INVALID_OID, ""));
        }
        if (this.byOid.containsKey(oid)) {
            this.errorHandler.handle(LOG, I18n.err(I18n.ERR_13745_SCHEMA_OBJECT_WITH_OID_ALREADY_EXIST, oid), null);
        } else {
            this.byOid.put(oid, schemaObject);
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.msg(I18n.MSG_13742_REGISTERED_SCHEMA_OBJECT, schemaObject, oid));
            }
        }
    }

    void put(T schemaObject) {
        this.byOid.put(schemaObject.getOid(), schemaObject);
    }

    public void unregister(String oid) throws LdapException {
        SchemaObject removed = (SchemaObject)this.byOid.remove(oid);
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg(I18n.MSG_13736_UNREGISTERED_SCHEMA_OBJECT, removed, oid));
        }
    }

    public OidRegistry<T> copy() {
        OidRegistry<T> copy = new OidRegistry<T>();
        copy.byOid = new HashMap<String, T>();
        return copy;
    }

    public int size() {
        return this.byOid.size();
    }

    public void clear() {
        this.byOid.clear();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.byOid != null) {
            boolean isFirst = true;
            for (Map.Entry<String, T> entry : this.byOid.entrySet()) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(", ");
                }
                sb.append("<");
                SchemaObject schemaObject = (SchemaObject)entry.getValue();
                if (schemaObject != null) {
                    sb.append((Object)schemaObject.getObjectType());
                    sb.append(", ");
                    sb.append(schemaObject.getOid());
                    sb.append(", ");
                    sb.append(schemaObject.getName());
                }
                sb.append(">");
            }
        }
        return sb.toString();
    }
}

