#!/usr/bin/env python
# -*- mode: python; coding: utf-8; -*-
# ---------------------------------------------------------------------------##
#
# Copyright (C) 1998-2003 Markus Franz Xaver Johannes Oberhumer
# Copyright (C) 2003 Mt. Hood Playing Card Co.
# Copyright (C) 2005-2009 Skomoroh
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# ---------------------------------------------------------------------------##

# This layouts converted from Kyodai Mahjongg game
# http://www.kyodai.com/index.en.html
# http://files.cyna.net/layouts.zip

from pysollib.games.mahjongg.mahjongg import r

# ************************************************************************
# * game definitions
# ************************************************************************

#
r(5200, "Another Round", ncards=140, layout="0aagaaihbhacfach" +
    "acjhdghdiaecaeea" +
    "egoehaeiaekaemhf" +
    "dhffhfhhfjhflaga" +
    "agcageogeaggogga" +
    "giogiagkogkagmag" +
    "ohhbhhdhhfhhhhhj" +
    "hhlhhnaiaaicoica" +
    "ieoieaigoigaiioi" +
    "iaikoikaimoimaio" +
    "hjbhjdhjfhjhhjjh" +
    "jlhjnakaakcakeak" +
    "gakiakkakmakoama" +
    "amcammamoaoaaoca" +
    "oeaogaoiaokaomao" +
    "ohpbhpdhpfhphhpj" +
    "hplhpnaqaaqcoqca" +
    "qeoqeaqgoqgaqioq" +
    "iaqkoqkaqmoqmaqo" +
    "hrbhrdhrfhrhhrjh" +
    "rlhrnasaascaseos" +
    "easgosgasiosiask" +
    "oskasmasohtdhtfh" +
    "thhtjhtlaucaueau" +
    "gouhauiaukaumhvg" +
    "hviawfawhawjhxha" +
    "ygayi")
r(5201, "Aqab's", layout="0caedagcaicccbcg" +
    "cckceabegcembgga" +
    "hdahjbigbkabkeck" +
    "gbkibkmbmabmccme" +
    "dmgcmibmkbmmboac" +
    "ocdoedogdoicokbo" +
    "mbqabqccqedqgcqi" +
    "bqkbqmbsabsecsgb" +
    "sibsmbugawdbwgaw" +
    "jcyabygcymcAcbAg" +
    "cAkcCedCgcCi")
#
r(5202, "Big Mountain", layout="0aaaaaqaeihfiagh" +
    "ogiagjhhhvhihhja" +
    "igoihaiiCiioijai" +
    "khjgvjhhjivjjhjk" +
    "akfokgakhCkhokia" +
    "kjCkjokkaklhlfvl" +
    "ghlhvlihljvlkhll" +
    "ameomfamgomhCmha" +
    "miomjCmjamkomlam" +
    "mhnehngvnghnivni" +
    "hnkvnkhnmaodaofo" +
    "ofaohoohCohaojoo" +
    "jCojaoloolaonhpe" +
    "hpgvpghpivpihpkv" +
    "pkhpmaqdaqfoqfaq" +
    "hoqhCqhaqjoqjCqj" +
    "aqloqlaqnhrehrgv" +
    "rghrivrihrkvrkhr" +
    "maseosfasgoshCsh" +
    "asiosjCsjaskosla" +
    "smhtfvtghthvtiht" +
    "jvtkhtlaufougauh" +
    "CuhouiaujCujouka" +
    "ulhvgvvhhvivvjhv" +
    "kawgowhawiCwiowj" +
    "awkhxhvxihxjayho" +
    "yiayjhziaAiaGaaG" +
    "q")
#
r(5203, "Bridge", layout="0aaaaacaaeaagaai" +
    "hbahbchbehbghbio" +
    "caoccoceocgociwd" +
    "avdcvdevdgwdioeb" +
    "oedoefoehvfahfcv" +
    "fchfevfehfgvfgvf" +
    "iogbagdogdagfogf" +
    "oghvhahhcvhchhev" +
    "hehhgvhgvhioibai" +
    "doidaifoifoihvja" +
    "hjcvjchjevjehjgv" +
    "jgvjiokbokdokfok" +
    "hvlavlcvlevlgvli" +
    "CmaCmivnavncvnev" +
    "ngvniooboodoofoo" +
    "hvpahpcvpchpevpe" +
    "hpgvpgvpioqbaqdo" +
    "qdaqfoqfoqhvrahr" +
    "cvrchrevrehrgvrg" +
    "vriosbasdosdasfo" +
    "sfoshvtahtcvtcht" +
    "evtehtgvtgvtioub" +
    "oudoufouhwvavvcv" +
    "vevvgwviowaowcow" +
    "eowgowihxahxchxe" +
    "hxghxiayaaycayea" +
    "ygayi")
r(5204, "Butterfly 2", layout="0aaeaagabcabiadb" +
    "adjhefvefaenafaa" +
    "feofeafgofgaflaf" +
    "phgdvgdwgfhghvgh" +
    "ahaaheoheahgohga" +
    "hkahqhifvifcinbj" +
    "bbjjajqblcbliblq" +
    "bmocndcnhcnmapbb" +
    "pdapfbphapjbplap" +
    "nhqbpqdiqfpqhiqj" +
    "pqlhqnarbbrdarfb" +
    "rharjbrlarnctdct" +
    "hctmbuobvcbvibvq" +
    "bxbbxjaxqhyfvyfc" +
    "ynazaazeozeazgoz" +
    "gazkazqhAdvAdwAf" +
    "hAhvAhaBaaBeoBea" +
    "BgoBgaBlaBphCfvC" +
    "faCnaDbaDjaFcaFi" +
    "aGeaGg")
r(5205, "ChessMania", layout="0aaaaacaaeaagaaj" +
    "aalaanaapacaacgb" +
    "cmaeaaegaejaelae" +
    "naepaibbidaifbih" +
    "aijbilainbipbkba" +
    "kdbkfakhbkjaklbk" +
    "nakpambbmdamfbmh" +
    "amjbmlamnbmponfo" +
    "nhonjonlbobaodbo" +
    "faohbojaolbonaop" +
    "opfppioplaqbbqda" +
    "qfbqhaqjbqlaqnbq" +
    "porforlbsbasdbsf" +
    "ashbsjaslbsnaspa" +
    "ubbudaufbuhaujbu" +
    "launbupbwbawdbwf" +
    "awhbwjawlbwnawpa" +
    "BaaBcaBgaBjaBlaB" +
    "paDabDdaDgaDjbDm" +
    "aDpaFaaFeaFgaFja" +
    "FnaFp")
r(5206, "Cross", layout="0baebagbaiaccdce" +
    "bcgdciackaeacecd" +
    "eebegdeicekaemcg" +
    "adgcdgebggdgidgk" +
    "cgmbiabicaiebiga" +
    "iibikbimbkabkcak" +
    "ebkgakibkkbkmcma" +
    "dmcdmebmgdmidmkc" +
    "mmaoacocdoebogdo" +
    "icokaomaqcdqebqg" +
    "dqiaqkbsebsgbsi")
r(5207, "Cupido's Heart", layout="0aadaalbbfbbjcch" +
    "addadlbefcehbejc" +
    "ghdhfdidcihdjbdj" +
    "jckhdkldlacmhdmn" +
    "dnbdodcohdopeqed" +
    "qqdsddspdtbdundv" +
    "adwldxbdxjdyddyh" +
    "dzfcAhaCecChaCkb" +
    "EfcEhbEjcGh")
r(5208, "Diamond", ncards=140, layout="0aaiaakacgbcibck" +
    "acmaeebegceicekb" +
    "emaeoagcbgecggdg" +
    "idgkcgmbgoagqaia" +
    "bicciedigeiieikd" +
    "imciobiqaisakabk" +
    "cckedkgekiekkdkm" +
    "ckobkqaksamcbmec" +
    "mgdmidmkcmmbmoam" +
    "qaoebogcoicokbom" +
    "aooaqgbqibqkaqma" +
    "siask")
r(5209, "Dragon 2", layout="0bafbbdobeobgbbh" +
    "bcfbcmbdkodlodnb" +
    "dobecaegbemofcbg" +
    "abgcbghbgjagloha" +
    "vhbohcbiabicbijb" +
    "ilojbbjhojjojlbk" +
    "bbkfokhbkjvkjbkl" +
    "vklolbolfblholjo" +
    "llbmbcmdbmfbmjbm" +
    "lboioojbokaoohpo" +
    "bqhbqjaqobrforho" +
    "rjasdosfbshvshbs" +
    "jvsjbslbsnhtdbtf" +
    "othotjaubaudbuhb" +
    "ujbwgbwkbwmbydoy" +
    "ebyfbymayohzobAc" +
    "aAobBjbCdoCebCfo" +
    "CgbCh")
r(5210, "Empty Pyramids", layout="0aaiabghbiabkacc" +
    "acehcgocihckacma" +
    "coadghdiadkaeiah" +
    "iaighiiaikajehjg" +
    "ojihjkajmakchkeo" +
    "kgvkiokkhkmakoal" +
    "ahlcolevlgClivlk" +
    "olmhloalqhmaamch" +
    "meomgvmiomkhmmam" +
    "ohmqonahncanehng" +
    "onihnkanmhnoonqv" +
    "oaoochoeaoghoiao" +
    "khomooovoqCpavpc" +
    "opehpgapiopihpko" +
    "pmvpoCpqvqaoqchq" +
    "eaqghqiaqkhqmoqo" +
    "vqqorahrcarehrgo" +
    "rihrkarmhroorqhs" +
    "aaschseosgvsiosk" +
    "hsmasohsqatahtco" +
    "tevtgCtivtkotmht" +
    "oatqauchueougvui" +
    "oukhumauoavehvgo" +
    "vihvkavmawghwiaw" +
    "kaxiaAiaBghBiaBk" +
    "aCcaCehCgoCihCka" +
    "CmaCoaDghDiaDkaE" +
    "i")
r(5211, "Fish face", layout="0bajbciocjbckvdj" +
    "behoeibejoekbelc" +
    "ggcgmchichkcifci" +
    "ncjhcjlckebkjcko" +
    "clgclmcmebmiomjb" +
    "mkcmocnccnqcoebo" +
    "ioojbokcoobpbcpg" +
    "cpmbprcqebqjcqoa" +
    "racrhcrlarsbsfbs" +
    "nbtiotjbtkbugbum" +
    "bwhbwlbyibykcAjc" +
    "BhcBlbDgbDmaFfaF" +
    "n")
r(5212, "Floating City", layout="0oagoaiocdocfoch" +
    "ocjoclocphdahdch" +
    "dmhdoaeboebaedae" +
    "faehaejaelaenoen" +
    "hfahfcvfchfmvfmh" +
    "foagbagnahdvheah" +
    "fahhahjvhkahlaib" +
    "ainvjgvjiakbCkha" +
    "knhlfhlhhljambam" +
    "damfomgamhCmhomi" +
    "amjamlamnomphnfh" +
    "nhhnjjoaaobCobao" +
    "dCodaofCofoogaoh" +
    "CohooiaojCojaolC" +
    "olaonConjooCopoo" +
    "qhpfhphhpjaqbaqd" +
    "aqfoqgaqhCqhoqia" +
    "qjaqlaqnoqphrfhr" +
    "hhrjasbCshasnvtg" +
    "vtiaubaunavdvvea" +
    "vfavhavjvvkavlaw" +
    "bawnhxahxcvxchxm" +
    "vxmhxoayboybayda" +
    "yfayhayjaylaynoy" +
    "nhzahzchzmhzooAd" +
    "oAfoAhoAjoAloApo" +
    "CgoCi")
# r(5213, "Flowers 2", layout="0aaiacgbciackadc" +
#    "adoaeiafabfcafea" +
#    "fmbfoafqahcahoai" +
#    "haijhjiakfakhakj" +
#    "aklhlghlihlkamda" +
#    "mfamhomhamjomjam" +
#    "lamnhnehnghnivni" +
#    "hnkhnmaobaodaofo" +
#    "ofaohoohaojoojao" +
#    "loolaonaophpchpe" +
#    "hpgvpghpivpihpkv" +
#    "pkhpmhpoaqbaqdoq" +
#    "daqfoqfaqhoqhCqh" +
#    "aqjoqjCqjaqloqla" +
#    "qnoqnaqphrchrehr" +
#    "gvrghrivrihrkvrk" +
#    "hrmhroasbasdasfo" +
#    "sfashoshasjosjas" +
#    "loslasnasphtehtg" +
#    "htivtihtkhtmauda" +
#    "ufauhouhaujoujau" +
#    "launhvghvihvkawf" +
#    "awhawjawlhxiayha" +
#    "yjazcazoaBabBcaB" +
#    "eaBmbBoaBqaCiaDc" +
#    "aDoaEgbEiaEkaGi")
# r(5214, "Full Vision 3", layout="0aaeaagaaihbehbi" +
#    "acbhccacdacfhcga" +
#    "chacjhckaclacnhc" +
#    "oacpaeahebaecaee" +
#    "aegaeiaekhelaema" +
#    "gbhgcagdagfhggag" +
#    "hagjhgkaglagnhgo" +
#    "agphhehhiaieaiga" +
#    "iiainhioaiphjgak" +
#    "eakgakiaknhkoakp" +
#    "hlehliambhmcamda" +
#    "mfhmgamhamjhmkam" +
#    "lamnhmoampaoahob" +
#    "aocaoehofaogaoia" +
#    "okholaomaqbhqcaq" +
#    "daqfhqgaqhaqjhqk" +
#    "aqlaqnhqoaqphreh" +
#    "riaseasgasiasnhs" +
#    "oasphtgaueaugaui" +
#    "aunhuoauphvehvia" +
#    "wbhwcawdawfhwgaw" +
#    "hawjhwkawlawnhwo" +
#    "awpayahybaycayea" +
#    "ygayiaykhylaymaA" +
#    "bhAcaAdaAfhAgaAh" +
#    "aAjhAkaAlaAnhAoa" +
#    "AphBehBiaCeaCgaC" +
#    "i")
r(5215, "Hidden Words", layout="0haahachaehaghal" +
    "abaabcobdabeabga" +
    "bjablbbnabphcahc" +
    "chceocghchhckhcq" +
    "adgadmodohefheih" +
    "emheoafgafjofjaf" +
    "lafnafphgfogghgk" +
    "hgmhgohichiehikh" +
    "inajaojaajcojdaj" +
    "eajghjhajjajlajn" +
    "ajphkbhkfokjhklh" +
    "kpalaalghlialjal" +
    "mombhmchmehmnana" +
    "ancanebnganjanla" +
    "nnbnphochoiholhq" +
    "chqfhqihqkaraarc" +
    "arearjhschshhslh" +
    "snhspatgatjatlat" +
    "natphuchuhhunava" +
    "avcaveavjhvkhwdh" +
    "wfhxihxmhxqayahy" +
    "baycayeaygayjayl" +
    "aynhyoayphzfhzka" +
    "AabAdaAghAhaAjaA" +
    "maAphBlhBnhBqaCa" +
    "hCbaCghCiaCjaCph" +
    "DfhDp")
r(5216, "Hovercraft", layout="0aadaafaahaajjbg" +
    "dccdceacgdcidckj" +
    "dgaedaefaehaejhf" +
    "gagfpggaghhhgaig" +
    "ajajjgajmhkaakgh" +
    "kmalaolaalmolmhm" +
    "avmaemghmmvmmana" +
    "onaCnaenceneenie" +
    "nkanmonmCnmhoavo" +
    "aeoghomvomapaopa" +
    "apmopmhqaaqghqma" +
    "rajrgarmasghtgau" +
    "fpugauhhvgawdawf" +
    "awhawjjxgdycdyea" +
    "ygdyidykjzgaAdaA" +
    "faAhaAj")
r(5217, "Hurdles", layout="0aaaaacaaeaagaai" +
    "aakaamaaohbahbch" +
    "behbghbihbkhbmhb" +
    "oacaocaaccoccace" +
    "oceacgocgaciocia" +
    "ckockacmocmacooc" +
    "ohdahdchdehdghdi" +
    "hdkhdmhdoaeaaeca" +
    "eeaegaeiaekaemae" +
    "oagaagcageaggagi" +
    "agkagmagohhahhch" +
    "hehhghhihhkhhmhh" +
    "oaiaoiaaicoicaie" +
    "oieaigoigaiioiia" +
    "ikoikaimoimaiooi" +
    "ohjahjchjehjghji" +
    "hjkhjmhjoakaakca" +
    "keakgakiakkakmak" +
    "oamaamcameamgami" +
    "amkammamohnahnch" +
    "nehnghnihnkhnmhn" +
    "oaoaooaaocoocaoe" +
    "ooeaogoogaoiooia" +
    "okookaomoomaoooo" +
    "ohpahpchpehpghpi" +
    "hpkhpmhpoaqaaqca" +
    "qeaqgaqiaqkaqmaq" +
    "o")
r(5218, "Tornado", layout="0babaadaambaoabi" +
    "begbekofdbfeoffa" +
    "fiofioflbfmofnbg" +
    "chgibgoahaahiohi" +
    "ahqhibhiihipajba" +
    "jeijfajgvjgajioj" +
    "iajkvjkijlajmajp" +
    "hkbhkihkpalcalia" +
    "lohmchmoandinean" +
    "fanianlinmannapb" +
    "ipdapevpeipfapga" +
    "pkiplapmvpmipnap" +
    "pardirearfariarl" +
    "irmarnhschsoatca" +
    "tiatohubhuihupav" +
    "baveivfavgvvgavi" +
    "oviavkvvkivlavma" +
    "vphwbhwihwpaxaax" +
    "ioxiaxqbychyibyo" +
    "ozdbzeozfaziozio" +
    "zlbzmoznbAgbAkaD" +
    "ibEbaEdaEmbEo")
#
r(5219, "IloveU", layout="0caddafcahdaldan" +
    "dapdcbcciceacejc" +
    "gacgkdibcilckdck" +
    "mcmecmndngdnpcoe" +
    "concqdcqmdsbcslc" +
    "uacukcwacwjdybcy" +
    "idzldzndzpcAddAf" +
    "cAhdBpdDldDndDp")
r(5220, "Inazuma", layout="0caaaaocaqcccacm" +
    "ccoacqceebeiaekc" +
    "emaeoagacggcgkag" +
    "mciaaicciibimaka" +
    "ckcakeckkamccmea" +
    "mgcmmaoecogaoico" +
    "ocqaaqgdqiaqkcqq" +
    "cscasicskasmcuea" +
    "ukcumauocwgawmcw" +
    "oawqbyecyiayocyq" +
    "aAecAgcAkaAqaCcc" +
    "CeaCgbCicCmaEacE" +
    "caEecEocGaaGccGq")
r(5221, "JPs", layout="0baabakbbmbcabck" +
    "bcobdmbdqbeabeob" +
    "fqbgabhobhqbiabi" +
    "cbiebigbiibikbim" +
    "bjobkabkcbkebkgb" +
    "kibkkbkmamqbqabq" +
    "cbqebqgbqibqkbqm" +
    "bqobqqbsabscbseb" +
    "sgbsibskbsmbsobs" +
    "qbuabuhbujbwabwh" +
    "bwjaxqbyabyhbyjb" +
    "AabAcbAgbAibCabC" +
    "cbCebCgbCibEabEc" +
    "bEebEgbEibGe")
r(5222, "Japan", ncards=96, layout="0baabacbaebagbai" +
    "bcaacebcibeaaeeb" +
    "eibgabgcbgebggbg" +
    "iahoajkajoalgali" +
    "alkhllalmaloangb" +
    "nibnkanmapebpgbp" +
    "iapkapmbrebrgari" +
    "arkatehtfatgatia" +
    "vaavcavebwibwoax" +
    "aaxcbxmbyiaykaza" +
    "bAgbAibAkbAmbAob" +
    "CiaCkbDmbEibEo")
r(5223, "Krebs", layout="0aaaaacaaeaagbai" +
    "balaanaapaaraata" +
    "caactaeaaetagaag" +
    "taiaCikaitvjkaka" +
    "CkjokkCklaktvljh" +
    "lkvllamaCmiomjam" +
    "kCmkomlCmmamtvni" +
    "hnjvnkhnlvnmaoaC" +
    "ohooiaojCojookao" +
    "lColoomConaotvph" +
    "hpivpjhpkvplhpmv" +
    "pnbqaCqgoqhaqiCq" +
    "ioqjaqkCqkoqlaqm" +
    "CqmoqnCqobqtvrhh" +
    "rivrjhrkvrlhrmvr" +
    "nCshosiasjCsjosk" +
    "aslCslosmCsnbtav" +
    "tihtjvtkhtlvtmbt" +
    "tCuioujaukCukoul" +
    "Cumavavvjhvkvvla" +
    "vtCwjowkCwlaxavx" +
    "kaxtCykazaaztaBa" +
    "aBtaDaaDtaFaaFta" +
    "HaaHcaHeaHgdHidH" +
    "laHnaHpaHraHt")
r(5224, "Kumo", layout="0caadaccaecagbai" +
    "bamdaqdcacccaceb" +
    "cgbckdcoceaaecce" +
    "ebeidembeqcgabgc" +
    "cggdgkbgobiabied" +
    "iibimbiqbkcdkgck" +
    "kbkockqbmadmebmi" +
    "cmmamocmqdocbogb" +
    "okaomcoodoqdqabq" +
    "ebqicqkcqmdqocqq")
r(5225, "Kyodai 14", layout="0aaiachhciacjodi" +
    "aefhegaehheiveia" +
    "ejhekaelofhCfiof" +
    "jagchgdagehgfagg" +
    "hghagivgihgjagkh" +
    "glagmhgnagoohiai" +
    "bhicaidaihhiiaij" +
    "ainhioaipakcbkgo" +
    "khbkivkiokjbkkak" +
    "ohlchloamcbmfbml" +
    "amoaoahobaochoda" +
    "oeooehofvofaogoo" +
    "ghohvohaoiooihoj" +
    "vojaokookholvola" +
    "omoomhonaoohopao" +
    "qaqcbqfbqlaqohrc" +
    "hroascbsgoshbsiv" +
    "siosjbskasoaubhu" +
    "caudauhhuiaujaun" +
    "huoaupoviawchwda" +
    "wehwfawghwhawivw" +
    "ihwjawkhwlawmhwn" +
    "awooxhCxioxjayfh" +
    "ygayhhyivyiayjhy" +
    "kayloziaAhhAiaAj" +
    "aCi")
r(5226, "Kyodai 17", layout="0daacaccaecagcai" +
    "cakdamccaccgccmc" +
    "eacegcemcgacgccg" +
    "ecggcgicgkcgmcia" +
    "digcimckadkgckmc" +
    "macmccmecmgcmicm" +
    "kcmmcoacogcomcqa" +
    "cqgcqmdsacsccsec" +
    "sgcsicskdsm")
#
r(5227, "Kyodai 18", layout="0daidchdcjdegdek" +
    "dgfdgldiedimdkda" +
    "kidkndmcamhamjdm" +
    "odobaogaoiaokdop" +
    "dqaaqfaqhaqjaqld" +
    "qqdsbasgasiaskds" +
    "pducauhaujduodwd" +
    "awidwndyedymdAfd" +
    "AldCgdCkdEhdEjdG" +
    "i")
r(5228, "Kyodai 20", layout="0aaeaagaaiaakaam" +
    "aaohbjacdaciacka" +
    "cpaecbehbelaeqag" +
    "baggagmagraiaaif" +
    "higaihoihhiiviia" +
    "ijoijCijhikvikai" +
    "loilhimainaisaka" +
    "akebkjakoaksamaa" +
    "mdcmhamjcmlampam" +
    "saoahobaocoochod" +
    "vodaoeooeCoehofv" +
    "ofaogooghohaoiko" +
    "jaokholaomoomhon" +
    "vonaoooooCoohopv" +
    "opaoqooqhoraosaq" +
    "aaqdcqhaqjcqlaqp" +
    "aqsasaasebsjasoa" +
    "ssauaaufhugauhou" +
    "hhuivuiaujoujCuj" +
    "hukvukauloulhuma" +
    "unausawbawgawmaw" +
    "raycbyhbylayqaAd" +
    "aAiaAkaAphBjaCea" +
    "CgaCiaCkaCmaCo")
#
r(5229, "Kyodai 23", layout="0aaehbeacdoceacf" +
    "hdevdeaecaeeoeea" +
    "eghfdvfehffagaag" +
    "cageogeaggagihhb" +
    "hhdhhfhhhaiaaico" +
    "icaieoieaigoigai" +
    "ihjbhjdvjdhjfvjf" +
    "hjhakaakcokcakeo" +
    "keCkeakgokgakihl" +
    "bhldvldhlfvlfhlh" +
    "amaamcomcameomea" +
    "mgomgamihnbhndhn" +
    "fhnhaoaaocaoeooe" +
    "aogaoihpdhpfaqaa" +
    "qcaqeoqeaqgaqihr" +
    "bhrdhrfhrhasaasc" +
    "oscaseoseasgosga" +
    "sihtbhtdvtdhtfvt" +
    "fhthauaaucoucaue" +
    "oueCueaugougauih" +
    "vbhvdvvdhvfvvfhv" +
    "hawaawcowcaweowe" +
    "awgowgawihxbhxdh" +
    "xfhxhayaaycayeoy" +
    "eaygayihzdvzehzf" +
    "aAcaAeoAeaAghBev" +
    "BeaCdoCeaCfhDeaE" +
    "e")
#
r(5230, "Kyodai 24", layout="0aaaiabaacaaejaf" +
    "aagaaiiajaakvbci" +
    "bdCbfibhvbiacaic" +
    "baccacevceicfacg" +
    "vcgaciicjackvdci" +
    "ddCddCdfidhCdhvd" +
    "iaeaiebaecaeevee" +
    "iefaegvegaeiieja" +
    "ekvfcifdCfdifhCf" +
    "hvfiagaigbagcage" +
    "vgeigfaggvggagii" +
    "gjagkvhcihdChdih" +
    "hChhvhiaiaiibaic" +
    "aievieiifaigviga" +
    "iiiijaikvjcijdCj" +
    "dCjfijhCjhvjiaka" +
    "ikbakcakevkeikfa" +
    "kgvkgakiikjakkvl" +
    "cildClfilhvliama" +
    "imbamcamejmfamga" +
    "miimjamk")
r(5231, "Kyodai 25", layout="0cagbaicakbcgbck" +
    "odgodkbegbekcggc" +
    "gkbieoifbigciibi" +
    "koilbimbkiolicma" +
    "bmicmqboabogdoib" +
    "okboqcqabqcoqdbq" +
    "edqgdqkbqmoqnbqo" +
    "cqqbsabsgdsibskb" +
    "sqcuabuicuqovibw" +
    "ibyeoyfbygcyibyk" +
    "oylbymcAgcAkbCgb" +
    "CkoDgoDkbEgbEkcG" +
    "gbGicGk")
#
r(5232, "Kyodai 26", layout="0aahhbhacgacihdg" +
    "hdiaefaehaejhffh" +
    "fhhfjageaggagiag" +
    "khhehhghhihhkaid" +
    "aifaihaijailhjdh" +
    "jhhjlakcakeakgak" +
    "iakkakmhlchlehlg" +
    "hlihlkhlmambamda" +
    "mfamhamjamlamnhn" +
    "bhnfhnhhnjhnnaoa" +
    "aocaoeaogaoiaoka" +
    "omaoohpahpchpehp" +
    "ghpihpkhpmhpoaqa" +
    "aqcaqeaqgaqiaqka" +
    "qmaqohrahrchrehr" +
    "ghrihrkhrmhroasa" +
    "ascaseasgasiaska" +
    "smasohtbhtfhthht" +
    "jhtnaubaudaufauh" +
    "aujaulaunhvchveh" +
    "vghvihvkhvmawcaw" +
    "eawgawiawkawmhxd" +
    "hxhhxlaydayfayha" +
    "yjaylhzehzghzihz" +
    "kaAeaAgaAiaAkhBf" +
    "hBhhBjaCfaChaCjh" +
    "DghDiaEgaEihFhaG" +
    "h")
#
r(5233, "Kyodai 27", layout="0aagacfhcgachaee" +
    "hefaegoeghehaeiv" +
    "fgagdhgeagfogfhg" +
    "gCggaghoghhgiagj" +
    "vhfvhhaichidaieo" +
    "iehifCifaigoighi" +
    "hCihaiioiihijaik" +
    "vjevjgvjiakbhkca" +
    "kdokdhkeCkeakfok" +
    "fhkgCkgakhokhhki" +
    "Ckiakjokjhkkaklv" +
    "ldvlfvlhvljamahm" +
    "bamcomchmdameome" +
    "hmfCmfamgomghmhC" +
    "mhamiomihmjamkom" +
    "khmlammvndvnfvnh" +
    "vnjaobhocaodoodh" +
    "oeCoeaofoofhogCo" +
    "gaohoohhoiCoiaoj" +
    "oojhokaolvpevpgv" +
    "piaqchqdaqeoqehq" +
    "fCqfaqgoqghqhCqh" +
    "aqioqihqjaqkvrfv" +
    "rhasdhseasfosfhs" +
    "gCsgashoshhsiasj" +
    "vtgauehufaugough" +
    "uhauiawfhwgawhay" +
    "g")
#
r(5234, "Kyodai 28", layout="0baibbgbbkbcebci" +
    "bcmbdcbdobeabeib" +
    "eqbgacggvghcgiCg" +
    "ivgjcgkbgqbiacif" +
    "ciicilbiqbkackea" +
    "khakjckmbkqhlhhl" +
    "jbmacmdamgamiomi" +
    "amkcmnbmqhnhhnjb" +
    "oacoeaohaojcombo" +
    "qbqacqfcqicqlbqq" +
    "bsacsgvshcsiCsiv" +
    "sjcskbsqbuabuibu" +
    "qbvcbvobwebwibwm" +
    "bxgbxkbyi")
#
r(5235, "Kyodai 41", layout="0CaeCagCaivbevbg" +
    "vbiCcdoceocgociC" +
    "cjvddhdevdfhdgCd" +
    "gvdhhdivdjCecaee" +
    "oeeCeeaegoegaeio" +
    "eiCeiCekCfavfbof" +
    "chfdvfdhffvffCfg" +
    "hfhvfhhfjvfjofkv" +
    "flCfmCgdageogeag" +
    "goggagiogiCgjCha" +
    "vhbohchhdvhdhhfv" +
    "hfChghhhvhhhhjvh" +
    "johkvhlChmCicaie" +
    "oieCieaigoigaiio" +
    "iiCiiCikCjavjboj" +
    "chjdvjdhjfvjfCjg" +
    "hjhvjhhjjvjjojkv" +
    "jlCjmCkdakeokeak" +
    "gokgakiokiCkjCla" +
    "vlbolchldvldhlfv" +
    "lfClghlhvlhhljvl" +
    "jolkvllClmCmcame" +
    "omeCmeamgomgamio" +
    "miCmiCmkvndhnevn" +
    "fhngCngvnhhnivnj" +
    "CodooeoogooiCojv" +
    "pevpgvpiCqeCqgCq" +
    "i")
#
r(5236, "Kyodai 42", layout="0oaboadCagoajoal" +
    "hbahbcvbchbeobfv" +
    "bgobhhbihbkvbkhb" +
    "macbacdacjaclhdb" +
    "hddodevdfCdgvdho" +
    "dihdjhdlaecaekhf" +
    "chfeoffvfgofhhfi" +
    "hfkagdCggagjhhdh" +
    "hfhhhhhjaieaiihj" +
    "ehjghjiakfCkgakh" +
    "hlfvlghlhCmfamgo" +
    "mgCmhhnfvnghnhao" +
    "gCoghpfhphCqcvqd" +
    "oqeCqeaqgoqgoqiC" +
    "qivqjCqkhrfhrhas" +
    "gCsghtfvtghthCuf" +
    "augougCuhhvfvvgh" +
    "vhawfCwgawhhxehx" +
    "ghxiayeayihzdhzf" +
    "hzhhzjaAdCAgaAjh" +
    "BchBeoBfvBgoBhhB" +
    "ihBkaCcaCkhDbhDd" +
    "oDevDfCDgvDhoDih" +
    "DjhDlaEbaEdaEjaE" +
    "lhFahFcvFchFeoFf" +
    "vFgoFhhFihFkvFkh" +
    "FmoGboGdCGgoGjoG" +
    "l")
r(5237, "Lattice", layout="0aaiacebciacmaec" +
    "beeaegbeiaekbema" +
    "eoagecgiagmaicbi" +
    "eaigciiaikbimaio" +
    "akeckiakmamcbmeb" +
    "mgdmibmkbmmamobo" +
    "eeoibomaqabqccqe" +
    "eqgdqieqkcqmbqoa" +
    "qqbseesibsmaucbu" +
    "ebugduibukbumauo" +
    "awecwiawmaycbyea" +
    "ygcyiaykbymayoaA" +
    "ecAiaAmaCcbCeaCg" +
    "bCiaCkbCmaCoaEeb" +
    "EiaEmaGi")
#
# r(5238, "Leo", layout="0aapabiablhbphcf" +
#    "acghchhclacnocpa" +
#    "djodladpvdpheeae" +
#    "fheiaelvelhepCep" +
#    "ofihflCflafnofph" +
#    "gdagevgiagjoglag" +
#    "pvgphhiChiahlvhl" +
#    "hhpChphicaidoiih" +
#    "ilCilainoipvjiaj" +
#    "jojlajpvjpbkabkc" +
#    "hkiCkiaklvklhkpC" +
#    "kpolbolihllalnol" +
#    "pbmabmcvmiamjoml" +
#    "ampvmphnianlhnpo" +
#    "oiholaonoophpfap" +
#    "hapjappaqfhqiaql" +
#    "hqphrdarnasehsqh" +
#    "tcatpaudbumhuphv" +
#    "bcvgavqawccwlhwq" +
#    "hxbcxjaxpayccylh" +
#    "yphzbczgazqaAdbA" +
#    "mhAqhBcaBpaCehCp" +
#    "hDeaDgaDohEgaEia" +
#    "EmhEohFiaFkhFmhG" +
#    "k")
#
r(5239, "Loose Ends", layout="0aaaoabaaioapaaq" +
    "hbahbihbqacbocca" +
    "chociacjocoacphd" +
    "bhdivdihdpaecoed" +
    "aegaeioeiaekoena" +
    "eohfchfivfihfoag" +
    "dogeaghogiagjogm" +
    "agnhhdhhivhihhna" +
    "ieoifaiioiioilai" +
    "mhjfhjihjlakgokg" +
    "akiakkokkhlholih" +
    "ljamahmbamcomchm" +
    "dvmdameomehmfvmf" +
    "amgvmhamiCmivmja" +
    "mkhmlvmlammommhm" +
    "nvmnamoomohmpamq" +
    "hnhonihnjaogooga" +
    "oiaokookhpfhpihp" +
    "laqeoqfaqioqioql" +
    "aqmhrdhrivrihrna" +
    "sdoseashosiasjos" +
    "masnhtchtivtihto" +
    "aucoudaugauiouia" +
    "ukounauohvbhvivv" +
    "ihvpawbowcawhowi" +
    "awjowoawphxahxih" +
    "xqayaoybayioypay" +
    "q")
r(5240, "Mini Traditional", ncards=48, layout="0aaeacdacfhdeaec" +
    "aeeoeeaeghfdvfeh" +
    "ffagbagdogeagfag" +
    "hhhchhevhehhgaia" +
    "aicoicaieoieaigo" +
    "igaiihjchjevjehj" +
    "gakbakdokeakfakh" +
    "hldvlehlfamcameo" +
    "meamghneaodaofaq" +
    "e")
r(5241, "Mini-Layout", ncards=8, layout="0aabaadacahcbhcd" +
    "aceaebaed")
r(5242, "Mission Impossible", layout="0baabamaapccaccm" +
    "acpdeacecbeeaegb" +
    "eicekdemaepcgacg" +
    "magpbiabimaipakp" +
    "bmacmcdmeemgdmic" +
    "mkbmmampcocaopdq" +
    "eaqpcscaspbuacuc" +
    "dueeugduicukbuma" +
    "upawpbyabycbyeby" +
    "gbyibykbymaypcAa" +
    "cAgaApdCadCgaCpe" +
    "EaaEp")
#
r(5243, "Multi X", layout="0aaaaaiaaqhbbhbh" +
    "hbjhbpoccocgocko" +
    "covddvdfvdlvdnce" +
    "eCeecemCemvfdvff" +
    "vflvfnogcoggogko" +
    "gohhbhhhhhjhhpai" +
    "aaiiaiqhjbojcvjd" +
    "Cjevjfojghjhojih" +
    "jjojkvjlCjmvjnoj" +
    "ohjpakaakiakqhlb" +
    "hlhhljhlpomcomgo" +
    "mkomovndvnfvnlvn" +
    "ncoeCoecomComvpd" +
    "vpfvplvpnoqcoqgo" +
    "qkoqohrbhrhhrjhr" +
    "pasaasiasqhtbotc" +
    "vtdCtevtfotghtho" +
    "tihtjotkvtlCtmvt" +
    "notohtpauaauiauq" +
    "hvbhvhhvjhvpowco" +
    "wgowkowovxdvxfvx" +
    "lvxncyeCyecymCym" +
    "vzdvzfvzlvznoAco" +
    "AgoAkoAohBbhBhhB" +
    "jhBpaCaaCiaCq")
# r(5244, "New Layout 2", layout="0CabCadCafacapca" +
#    "hccvccacepcehcgv" +
#    "cgheaveaaecpeche" +
#    "eveeaegpegCfaCfc" +
#    "CfeCfgagapgahgcv" +
#    "gcagepgehggvggCh" +
#    "aChcCheChghiavia" +
#    "aicpichievieaigp" +
#    "igakaqkahkcwkcak" +
#    "eqkehkgwkghmawma" +
#    "amcqmchmewmeamgq" +
#    "mgaoaqoahocwocao" +
#    "eqoehogwoghqavqa" +
#    "aqcpqchqevqeaqgp" +
#    "qgCraCrcCreCrgas" +
#    "apsahscvscasepse" +
#    "hsgvsgCtaCtcCteC" +
#    "tghuavuaaucpuchu" +
#    "evueaugpugawapwa" +
#    "hwcvwcawepwehwgv" +
#    "wgCybCydCyf")
r(5245, "Okie's Nitemare", layout="0aaoaaqbbeabmhbp" +
    "acoacqcddbdgadmh" +
    "dpaeoaeqbfccffaf" +
    "mhfpagoagqbhehhp" +
    "aiiaioaiqhjihjqa" +
    "kiakqalohlqammhm" +
    "oamqandankhnmano" +
    "onohnqaobaoihoka" +
    "ompomhooaoqapghp" +
    "iapkopkhpmapoopo" +
    "hpqaqabqcoqdbqeo" +
    "qfhqgaqioqihqkvq" +
    "kCqlaqmpqmhqoaqq" +
    "arghriarkorkhrma" +
    "roorohrqasbasihs" +
    "kasmpsmhsoasqatd" +
    "atkhtmatootohtqa" +
    "umhuoauqavohvqaw" +
    "iawqhxihxqbyeayi" +
    "ayoayqhzpbAccAfa" +
    "AoaAqaBmhBpcCdbC" +
    "gaCoaCqaDmhDpbEe" +
    "aEoaEqaFmhFpaGoa" +
    "Gq")
r(5246, "Orbital", ncards=84, layout="0dafdahdajdchceh" +
    "bghbihbkhclablfb" +
    "ljclocnabncbnebn" +
    "kbnmcnocpabpfbpj" +
    "cpobqhbshbuhcwhd" +
    "yhdAfdAhdAj")
r(5247, "Owl", layout="0baebagbaibakbam" +
    "bcdbcncecbejbeoc" +
    "gbbghcgjbglbgpci" +
    "cbijbiobkdbkncla" +
    "blpbmebmmcnbanpc" +
    "odaofbohbojbolbo" +
    "nhopipfappoppcqd" +
    "aqfbqhbqjbqlbqnh" +
    "qpcrbarpbsebsmct" +
    "abtpbudbuncwcbwj" +
    "bwocybbyhcyjbylb" +
    "ypcAcbAjbAobCdbC" +
    "nbEebEgbEibEkbEm")
r(5248, "Pantheon", layout="0baebcebdgbdqbee" +
    "aeiaekaemaeobfcb" +
    "fgbfqbgebhcbiebj" +
    "cojdbjgbjqbkabke" +
    "akiakkakmakoolbb" +
    "lcoldblgblqbmabm" +
    "eonbbncboaoodboe" +
    "opbbpcbpgbpqbqab" +
    "qeaqiaqkaqmaqoor" +
    "bbrcbrgbrqbsaosd" +
    "bseotbbtcbuabueo" +
    "vbbvcovdbvgbvqbw" +
    "abweawiawkawmawo" +
    "bxcoxdbxgbxqbyeb" +
    "zcbAebBcbBgbBqbC" +
    "eaCiaCkaCmaCobDg" +
    "bDqbEebGe")
#
r(5249, "Papillon", layout="0bagbaibakobhobj" +
    "bcfbchbcjbclodho" +
    "djbecbeebegbeibe" +
    "kbembeoofdofnbgd" +
    "bgnbiebimojeojmb" +
    "kdbkfbklbknbmcbm" +
    "gbmkbmobobbohboj" +
    "bopopibqabqibqqo" +
    "ribsbbshbsjbspbu" +
    "cbugbukbuobwdbwf" +
    "bwlbwnoxeoxmbyeb" +
    "ymbAdbAnoBdoBnbC" +
    "cbCebCgbCibCkbCm" +
    "bCooDhoDjbEfbEhb" +
    "EjbEloFhoFjbGgbG" +
    "ibGk")
r(5250, "Pyramid 1", layout="0aagaaiaceacghch" +
    "aciackaecbeebegb" +
    "eibekaemagabgcbg" +
    "ecggcgibgkbgmago" +
    "aiabicciecigvihc" +
    "iicikbimaioakabk" +
    "cckedkgdkickkbkm" +
    "akoamabmccmedmgd" +
    "micmkbmmamoaoabo" +
    "ccoecogvohcoicok" +
    "bomaooaqabqcbqec" +
    "qgcqibqkbqmaqoas" +
    "cbsebsgbsibskasm" +
    "aueaughuhauiauka" +
    "wgawi")
r(5251, "Pyramid 2", layout="0aaeaagaaiaccbce" +
    "bcgbciackaeabecb" +
    "eeoefbegoehbeibe" +
    "kaemagacgcdgedgg" +
    "dgicgkagmbiadice" +
    "ieeigeiidikbimbk" +
    "adkcekeekgekidkk" +
    "bkmamacmcdmedmgd" +
    "micmkammaoabocbo" +
    "eoofbogoohboibok" +
    "aomaqcbqebqgbqia" +
    "qkaseasgasi")
#
r(5252, "Quad", layout="0baabacbaeaagbai" +
    "bakbamobbobdobjo" +
    "blbcabccvccbceac" +
    "gbcibckvckbcmodb" +
    "oddodjodlbeabecv" +
    "ecbeeaegbeibekve" +
    "kbemofbofdofjofl" +
    "bgabgcbgeaggbgib" +
    "gkbgmaiaaicaiebi" +
    "gaiiaikaimbkabkc" +
    "bkeakgbkibkkbkmo" +
    "lboldoljollbmabm" +
    "cvmcbmeamgbmibmk" +
    "vmkbmmonbondonjo" +
    "nlboabocvocboeao" +
    "gboibokvokbomopb" +
    "opdopjoplbqabqcb" +
    "qeaqgbqibqkbqm")
#
r(5253, "Rectangle", layout="0daadacdaedagdca" +
    "dccdcedcgdeadecd" +
    "eedegdgadgcdgedg" +
    "gdiadicdiedigdka" +
    "dkcdkedkgdmadmcd" +
    "medmgdoadocdoedo" +
    "gdqadqcdqedqg")
r(5254, "Reindeer", ncards=64, layout="0haeabdocchdbadn" +
    "aecheehemaffafla" +
    "fohgkahfahhahjaj" +
    "fajjalfalhaljall" +
    "hmmanfanjonnaooa" +
    "pfaphapjarfarjas" +
    "latfathatjhtmoua" +
    "hufounhvbhvjavoa" +
    "wchwfawkhxdaxghx" +
    "hhxlayioymazevzn" +
    "aAiaBchBdaBgaBoh" +
    "CbhChaCioDaoDivE" +
    "h")
r(5255, "Rings", layout="0aahabfhbhabjacd" +
    "hcfachochhcjaclh" +
    "ddadfodfhdhvdhad" +
    "jodjhdlaebaedhef" +
    "aehoehhejaelaenh" +
    "fcaffhfhafjhfmag" +
    "caghagmhhchhmaic" +
    "aihaimhjcajfhjha" +
    "jjhjmakbakdhkfak" +
    "hokhhkjaklaknhld" +
    "alfolfhlhvlhaljo" +
    "ljhllamdhmfamhom" +
    "hhmjamlanfhnhanj" +
    "aoaaohaooaqaaqha" +
    "qoarfhrharjasdhs" +
    "fashoshhsjaslhtd" +
    "atfotfhthvthatjo" +
    "tjhtlaubaudhufau" +
    "houhhujaulaunhvc" +
    "avfhvhavjhvmawca" +
    "whawmhxchxmaycay" +
    "haymhzcazfhzhazj" +
    "hzmaAbaAdhAfaAho" +
    "AhhAjaAlaAnhBdaB" +
    "foBfhBhvBhaBjoBj" +
    "hBlaCdhCfaChoChh" +
    "CjaClaDfhDhaDjaE" +
    "h")
r(5256, "River Bridge", ncards=116, layout="0aafaalacfachacj" +
    "aclhdfhdhhdjhdlo" +
    "efoehoejoelvffvf" +
    "loggogiogkvhfhhh" +
    "hhjvhloigaiioiio" +
    "ikvjfhjhhjjvjlaj" +
    "oakcokgakiokiokk" +
    "akmakqalavlfhlhh" +
    "ljvllomgamiomiom" +
    "kvnfhnhhnjvnloog" +
    "aoiooiookvpfhphh" +
    "pjvploqgaqioqioq" +
    "kvrfhrhhrjvrlosg" +
    "asiosioskvtfhthh" +
    "tjvtlaucougauiou" +
    "ioukauoavavvfhvh" +
    "hvjvvlavmavqowga" +
    "wiowiowkvxfhxhhx" +
    "jvxloygoyioykvzf" +
    "vzloAfoAhoAjoAlh" +
    "BfhBhhBjhBlaCfaC" +
    "haCjaClaEfaEl")
#
r(5257, "Roman Arena", layout="0CaaCacCaeCagCai" +
    "vbbvbdvbfvbhCcao" +
    "ccoceocgCcivdbhd" +
    "dadehdfvdhCeaoec" +
    "oegCeivfbhfdafeh" +
    "ffvfhCgaogcoggCg" +
    "ivhbhhdahehhfvhh" +
    "CiaoicoigCiivjbh" +
    "jdajehjfvjhCkaok" +
    "cokgCkivlbhldale" +
    "hlfvlhCmaomcCmcC" +
    "meomgCmgCmivnbhn" +
    "dvndanehnfvnfvnh" +
    "CoaoocooeCoeoogC" +
    "oivpbhpdvpdapehp" +
    "fvpfvphCqaoqcCqc" +
    "CqeoqgCqgCqivrbh" +
    "rdarehrfvrhCsaos" +
    "cosgCsivtbhtdate" +
    "htfvthCuaoucougC" +
    "uivvbhvdavehvfvv" +
    "hCwaowcowgCwivxb" +
    "hxdaxehxfvxhCyao" +
    "ycoygCyivzbhzdaz" +
    "ehzfvzhCAaoAcoAe" +
    "oAgCAivBbvBdvBfv" +
    "BhCCaCCcCCeCCgCC" +
    "i")
r(5258, "Rugby", layout="0aafaahaceacgaci" +
    "aecaeeaegaeiaeka" +
    "gaagcagehgfagghg" +
    "hagiagkagmaiaaic" +
    "hidaiehifaighiha" +
    "iihijaikaimakahk" +
    "bakchkdakeikfakg" +
    "ikhakihkjakkhkla" +
    "kmamahmbamchmdam" +
    "eimfamgvmgimhami" +
    "hmjamkhmlammondo" +
    "njaoahobaochodao" +
    "evoeiofaogvogioh" +
    "aoivoihojaokhola" +
    "omopdopjaqahqbaq" +
    "chqdaqeiqfaqgvqg" +
    "iqhaqihqjaqkhqla" +
    "qmasahsbaschsdas" +
    "eisfasgishasihsj" +
    "askhslasmauaauch" +
    "udauehufaughuhau" +
    "ihujaukaumawaawc" +
    "awehwfawghwhawia" +
    "wkawmaycayeaygay" +
    "iaykaAeaAgaAiaCf" +
    "aCh")
r(5259, "Shapeshifter", layout="0aaoacmhcnacoaek" +
    "hemaenheoaepagih" +
    "gkaglogmhgnagohg" +
    "paiaaighiiaijoij" +
    "hilaimoinbiohjaa" +
    "kaokaakehkgakhok" +
    "hhkjakkokkokmhkn" +
    "akohkphlavlaamao" +
    "maamchmeamfomghm" +
    "hamiomiomkhmlamm" +
    "omnbmohnavnavngv" +
    "nivnkaoaooaCoaho" +
    "caodooehofaogoog" +
    "CogooiCoihojaoko" +
    "okCokoomhonaooho" +
    "phpavpavpgvpivpk" +
    "aqaoqaaqchqeaqfo" +
    "qghqhaqioqioqkhq" +
    "laqmoqnbqohravra" +
    "asaosaasehsgasho" +
    "shhsjaskoskosmhs" +
    "nasohsphtaauaaug" +
    "huiaujoujhulaumo" +
    "unbuoawihwkawlow" +
    "mhwnawohwpaykhym" +
    "aynhyoaypaAmhAna" +
    "AoaCo")
#
r(5260, "Space Bridge", layout="0aaaaacaaeaagaai" +
    "aakaamaaoaaqhbbh" +
    "bdhbfhbhhbjhblhb" +
    "nhbpacaoccoceocg" +
    "ociockocmocoacqh" +
    "dbvddvdfvdivdlvd" +
    "nhdpaeaoecCeeCei" +
    "Cemoeoaeqhfbvfdv" +
    "fnhfpagaogcogoag" +
    "qhhbhhpaiaoicoio" +
    "aiqhjbajfajlhjpa" +
    "kaokchkghkkokoak" +
    "qhlbvldClealholh" +
    "aljoljClmvlnhlpa" +
    "maomchmivmiomoam" +
    "qhnbanhonhanjonj" +
    "hnpaoaoochoghoko" +
    "ooaoqhpbapfaplhp" +
    "paqaoqcoqoaqqhrb" +
    "vrdvrnhrpasaoscC" +
    "seCsiCsmosoasqht" +
    "bvtdvtfvtivtlvtn" +
    "htpauaoucoueougo" +
    "uioukoumouoauqhv" +
    "bhvdhvfhvhhvjhvl" +
    "hvnhvpawaawcawea" +
    "wgawiawkawmawoaw" +
    "q")
r(5261, "Space Shuttle", layout="0aalaanacibckbcm" +
    "aeebegbeibekbemb" +
    "gcbgecggcgicgkcg" +
    "mbiacicciedigdii" +
    "dikdimckadkcekee" +
    "kgekiekkekmbmacm" +
    "ccmedmgdmidmkdmm" +
    "bocboecogcoicokc" +
    "omaqebqgbqibqkbq" +
    "masibskbsmaulaun")
r(5262, "Stage 1", layout="0aaebagaaiaccbce" +
    "ccgbciackaeabecc" +
    "eevefcegvehceibe" +
    "kaemagacgcdgedgg" +
    "dgicgkagmaiadicd" +
    "iedigdiidikaimak" +
    "adkcdkedkgdkidkk" +
    "akmamacmcdmedmgd" +
    "micmkammaoabocco" +
    "evofcogvohcoibok" +
    "aomaqcbqecqgbqia" +
    "qkasebsgasi")
r(5263, "Stage 2", layout="0aafaahaceacgaci" +
    "aeeaegaeiagcbgeb" +
    "ggbgiagkaiabicci" +
    "ecigciibikaimbka" +
    "ckcckeckgckickkb" +
    "kmbmaombbmcomdbm" +
    "epmfbmgpmhbmiomj" +
    "bmkomlbmmboaoobb" +
    "ocoodboepofbogpo" +
    "hboioojbokoolbom" +
    "bqacqccqecqgcqic" +
    "qkbqmasabsccsecs" +
    "gcsibskasmaucbue" +
    "bugbuiaukaweawga" +
    "wiayeaygayiaAfaA" +
    "h")
r(5264, "Stairs 2", layout="0aaadacaaedagaai" +
    "dakacadccacedcga" +
    "cidckbeadecbeede" +
    "gbeidekbgacgcbge" +
    "cggbgicgkciacicc" +
    "iecigciicikckabk" +
    "cckebkgckibkkdma" +
    "bmcdmebmgdmibmkd" +
    "oaaocdoeaogdoiao" +
    "kdqaaqcdqeaqgdqi" +
    "aqk")
r(5265, "Stairs 3", layout="0eaeeageaieakeam" +
    "dcfdchdcjdclcegc" +
    "eicekbgabghbgjbg" +
    "qaicaiiaioalfali" +
    "allhmibnaanibnqa" +
    "ocioiaoobpaapibp" +
    "qhqiarfariarlauc" +
    "auiauobwabwhbwjb" +
    "wqcygcyicykdAfdA" +
    "hdAjdAleCeeCgeCi" +
    "eCkeCm")
r(5266, "Stargate", layout="0hagobeabgobgobi" +
    "hcehcghcjoddadeo" +
    "dgadiodkhechelaf" +
    "cofcafgpfgafkofm" +
    "hgbhgghgnahaohap" +
    "hgahmohohiahilhi" +
    "pajaojavjcvjevjg" +
    "vjivjkajoojphkav" +
    "kaokdokfokhokjhk" +
    "palaolaClavlchle" +
    "hlghlivlkolpalqh" +
    "mavmaomdamfamhom" +
    "jhmpanaonaCnavnc" +
    "hnehnivnkanopnph" +
    "oavoaoodaofaohoo" +
    "jhopapaopaCpavpc" +
    "hpehpghpivpkoppa" +
    "pqhqavqaoqdoqfoq" +
    "hoqjhqparaoravrc" +
    "vrevrgvrivrkaroo" +
    "rphsahslhspataot" +
    "aptgatmotohubhug" +
    "hunavcovcavgpvga" +
    "vkovmhwchwloxdax" +
    "eoxgaxioxkhyehyg" +
    "hyjozeazgozgozih" +
    "Ag")
#
r(5267, "Sukis", layout="0aaaaacaaeaagaai" +
    "aakaamaaoaaqhbbh" +
    "bfhbjhbnacaaccac" +
    "eacgaciackacmaco" +
    "acqafaafcafeafga" +
    "fiafkafmafoafqhg" +
    "bhgpahaahcaheahg" +
    "ahiahkahmahoahqa" +
    "kahkbakcakeakgak" +
    "iakkakmakoakqhlp" +
    "amaamcameamgamia" +
    "mkammamoamqapaap" +
    "capeapgapiapkapm" +
    "apoapqhqbhqparaa" +
    "rcareargariarkar" +
    "maroarqauaaucaue" +
    "augauiaukaumauoa" +
    "uqhvpawahwbawcaw" +
    "eawgawiawkawmawo" +
    "awqazaazcazeazga" +
    "ziazkazmazoazqhA" +
    "bhApaBaaBcaBeaBg" +
    "aBiaBkaBmaBoaBqa" +
    "EaaEcaEeaEgaEiaE" +
    "kaEmaEoaEqhFbhFf" +
    "hFjhFnaGaaGcaGea" +
    "GgaGiaGkaGmaGoaG" +
    "q")
#
r(5268, "Temple 1", layout="0aaaaaeaaiabchbd" +
    "abghbhacahcbocca" +
    "cehcfocgaciadchd" +
    "dodeadghdhaeaheb" +
    "oecaeehefoegaeia" +
    "fchfdpfeafghfhag" +
    "ahgbogcagehgfogg" +
    "agiahchhdvhdohev" +
    "hfahghhhaiahiboi" +
    "caiehifoigaiiajc" +
    "hjdvjdojeCjevjfa" +
    "jghjhakahkbokcak" +
    "ehkfokgakialchld" +
    "vldoleClevlfalgh" +
    "lhamahmbomcamehm" +
    "fomgamianchndvnd" +
    "oneCnevnfanghnha" +
    "oahoboocaoehofoo" +
    "gaoiapchpdvpdope" +
    "vpfapghphaqahqbo" +
    "qcaqehqfoqgaqiar" +
    "chrdprearghrhasa" +
    "hsboscasehsfosga" +
    "siatchtdoteatght" +
    "hauahuboucauehuf" +
    "ougauiavchvdavgh" +
    "vhawaaweawi")
#
r(5269, "Temple 2", layout="0aacaagaakabahbb" +
    "abehbfabihbjacco" +
    "cchcdacgocghchac" +
    "kadahdbadeodehdf" +
    "adiodihdjaecoech" +
    "edaegoeghehaekaf" +
    "ahfbafeofehffafi" +
    "ofihfjagcogchgda" +
    "ggpgghghagkahahh" +
    "bahephehhfahiohi" +
    "hhjaicoichidaigp" +
    "ighihaikajahjbaj" +
    "epjehjfajiojihjj" +
    "akcokchkdakgpkgh" +
    "khakkalahlbalepl" +
    "ehlfaliolihljamc" +
    "omchmdamgpmghmha" +
    "mkanahnbaneonehn" +
    "fanionihnjaocooc" +
    "hodaogooghohaoka" +
    "pahpbapeopehpfap" +
    "iopihpjaqcoqchqd" +
    "aqgoqghqhaqkarah" +
    "rbareorehrfarior" +
    "ihrjaschsdasghsh" +
    "askataateati")
r(5270, "Totally Random-Made", layout="0aaevajaaoabbhbh" +
    "obioceCceacgaclC" +
    "clpcmhddvddwdhhd" +
    "moecaedCedoeghej" +
    "oenhffafgCfhafjo" +
    "fjCfkvfmagaCgfvg" +
    "gvgjhgkCgnahfohh" +
    "Chjahlohlahoaibh" +
    "ichieaihvihhiioj" +
    "cajdojeCjiojjwjl" +
    "ojookmhkovkoClcC" +
    "lfvlgolhvliCljpl" +
    "khlmvlmalpClpvmd" +
    "hmghmjammCmmCnco" +
    "ndCnganhCniankho" +
    "dvodaoeCoehofhoh" +
    "vohvokoolvomaooC" +
    "phopibplCpnvqhar" +
    "ahreorfCrharkhrl" +
    "ormasfashvsiCsjh" +
    "tfCthotiatjptnht" +
    "oaucoufhuhvuhauo" +
    "hvbavgovjCvjavkv" +
    "vkhwghwjawnawpbx" +
    "daxjoxkayfaymayo" +
    "aCdaCiaEiaFe")
r(5271, "Trika", layout="0hagaahiaiaajhak" +
    "abfablhceicihcma" +
    "ddoddodfadhvdhCd" +
    "iadjvdjodladnodn" +
    "heeieihemaffaflh" +
    "ggaghigiagjhgkci" +
    "iakgokghkhakioki" +
    "hkjakkokkhlfhlla" +
    "meomeamiammommhn" +
    "dhnnaocoocaogaoi" +
    "aokaooooohpbhphh" +
    "pjhppaqapqaaqehq" +
    "faqioqihqlaqmaqq" +
    "pqqhrbhrhhrjhrpa" +
    "scoscasgasiaskas" +
    "oosohtdhtnaueoue" +
    "auiaumoumhvfhvla" +
    "wgowghwhawiowihw" +
    "jawkowkcyihAgaAh" +
    "iAiaAjhAkaBfaBlh" +
    "CeiCihCmaDdoDdoD" +
    "faDhvDhCDiaDjvDj" +
    "oDlaDnoDnhEeiEih" +
    "EmaFfaFlhGgaGhiG" +
    "iaGjhGk")
r(5272, "Twin", layout="0aaeaagaaibccbce" +
    "bcgbcibckaeabecc" +
    "eecegceibekaemag" +
    "abgccgedggcgibgk" +
    "agmaiabicciecigc" +
    "iibikaimbkcbkebk" +
    "gbkibkkbmebmgbmi" +
    "bocboebogboiboka" +
    "qabqccqecqgcqibq" +
    "kaqmasabsccsedsg" +
    "csibskasmauabucc" +
    "uecugcuibukaumbw" +
    "cbwebwgbwibwkaye" +
    "aygayi")
#
r(5273, "Two Domes", layout="0aaiabghbiabkace" +
    "hcghckacmhdeodho" +
    "djhdmaecoefveioe" +
    "laeohfdvfgvfkhfn" +
    "agbogeCghCgjogma" +
    "gphhcvhfvhlhhoai" +
    "aoidCigCikoinaiq" +
    "hjcvjfajhvjlhjoa" +
    "kbokeCkhCkjokmak" +
    "phldvlgvlkhlnamc" +
    "omfvmiomlamohneo" +
    "nhonjhnmaoehogho" +
    "kaomapghpiapkaqe" +
    "hqgoqhaqivqioqjh" +
    "qkaqmarghriarkas" +
    "ehsghskasmhteoth" +
    "otjhtmaucoufvuio" +
    "ulauohvdvvgvvkhv" +
    "nawboweCwhCwjowm" +
    "awphxcvxfvxlhxoa" +
    "yaoydCygCykoynay" +
    "qhzcvzfazhvzlhzo" +
    "aAboAeCAhCAjoAma" +
    "AphBdvBgvBkhBnaC" +
    "coCfvCioClaCohDe" +
    "oDhoDjhDmaEehEgh" +
    "EkaEmaFghFiaFkaG" +
    "i")
#
r(5274, "Vagues", layout="0aacCaeaagCaiaak" +
    "Camhbcvbehbgvbih" +
    "bkvbmoccoceocgoc" +
    "iockocmvdchdevdg" +
    "hdivdkhdmCecaeeC" +
    "egaeiCekaemvfchf" +
    "evfghfivfkhfmaga" +
    "ogcogeoggogiogko" +
    "gmagohhahhcvhehh" +
    "gvhihhkvhmhhooia" +
    "aicCieaigCiiaikC" +
    "imoiovjahjcvjehj" +
    "gvjihjkvjmvjoCka" +
    "okcokeokgokiokko" +
    "kmCkovlavlchlevl" +
    "ghlivlkhlmvlooma" +
    "CmcameCmgamiCmka" +
    "mmomohnavnchnevn" +
    "ghnivnkhnmhnoaoa" +
    "oocooeoogooiooko" +
    "omaoohpcvpehpgvp" +
    "ihpkvpmaqcCqeaqg" +
    "CqiaqkCqmhrcvreh" +
    "rgvrihrkvrmoscos" +
    "eosgosioskosmvtc" +
    "htevtghtivtkhtmC" +
    "ucaueCugauiCukau" +
    "m")
r(5275, "Well 2", layout="0aaaaacaaeaagaai" +
    "aakaamaaoacacccc" +
    "ceccgccicckccmac" +
    "oaeadecdeedegdei" +
    "dekdemaeoagadgcd" +
    "gedgkdgmagoaiadi" +
    "cdiedikdimaioaka" +
    "dkcdkedkgdkidkkd" +
    "kmakoamacmccmecm" +
    "gcmicmkcmmamoaoa" +
    "aocaoeaogaoiaoka" +
    "omaoo")
#
r(5276, "Whatever", layout="0oaeoaghbdhbfhbh" +
    "hcbaceoceacgocgh" +
    "cjadcadiheboeeoe" +
    "ghejafcafihgboge" +
    "ogghgjahcwhfahio" +
    "iahiboicoieoigoi" +
    "ihijoikajcvjdwjf" +
    "vjhajiokahkbokcC" +
    "kdokeokgCkhokihk" +
    "jokkalcvldwlfvlh" +
    "aliomahmbvmbomcC" +
    "mdomeomgCmhomihm" +
    "jvmjomkancvndwnf" +
    "vnhaniooahobvobo" +
    "ocCodooeoogCohoo" +
    "ihojvojookapcvpd" +
    "wpfvphapioqahqbo" +
    "qcCqdoqeoqgCqhoq" +
    "ihqjoqkarcvrdwrf" +
    "vrhariosahsbosco" +
    "seosgosihsjoskat" +
    "cwtfatihuboueoug" +
    "hujavcavihwboweo" +
    "wghwjaxcaxihybay" +
    "eoyeaygoyghyjhzd" +
    "hzfhzhoAeoAg")
r(5277, "Win", layout="0aaeaahaakaanbed" +
    "begbejbembepbheb" +
    "hhbhkbhnbhqbjdbj" +
    "gbjjbjmbjpbmcbme" +
    "bmgbmibmkbmmbmoc" +
    "occoicoocqbcqhcq" +
    "ncsbcshcsncuacuc" +
    "cuecugcuicukcumc" +
    "wbcwhcwncybcyhcy" +
    "ncAccAicAocCccCe" +
    "cCgcCicCkcCmcCo")
r(5278, "X-Files", layout="0aaaaaiaaqhbiacb" +
    "acgaciociackacph" +
    "dibecaeiaeoegdeg" +
    "neieeiidimdkfckl" +
    "ekpelbbmgbmkaocb" +
    "ohooibojaooaqahq" +
    "baqcoqchqdaqeaqi" +
    "aqmhqnaqooqohqpa" +
    "qqascbshosibsjas" +
    "obugbukewbcwfcwl" +
    "ewpdyeeyidymeAde" +
    "AnaCcaCiaCohDiaE" +
    "baEgaEioEiaEkaEp" +
    "hFiaGaaGiaGq")
r(5279, "X-Shape", layout="0aaibbabbqcdabdc" +
    "bdocdqaeicfacfcb" +
    "febfmcfocfqchabh" +
    "cchebhgbhkchmbho" +
    "chqbjabjecjgbjic" +
    "jkbjmbjqblgdlibl" +
    "kbnabnecngbnicnk" +
    "bnmbnqcpabpccpeb" +
    "pgbpkcpmbpocpqcr" +
    "acrcbrebrmcrocrq" +
    "asictabtcbtoctqb" +
    "vabvqawi")
