/// <reference types="node" resolution-mode="require"/>
import type tsp from 'typescript/lib/protocol.d.js';
import { CancellationToken } from 'vscode-jsonrpc';
import { CommandTypes } from './tsp-command-types.js';
import { Logger } from './logger.js';
export interface TspClientOptions {
    logger: Logger;
    tsserverPath: string;
    logFile?: string;
    logVerbosity?: string;
    disableAutomaticTypingAcquisition?: boolean;
    maxTsServerMemory?: number;
    npmLocation?: string;
    locale?: string;
    globalPlugins?: string[];
    pluginProbeLocations?: string[];
    onEvent?: (event: tsp.Event) => void;
    onExit?: (exitCode: number | null, signal: NodeJS.Signals | null) => void;
}
interface TypeScriptRequestTypes {
    'geterr': [tsp.GeterrRequestArgs, any];
    'compilerOptionsForInferredProjects': [tsp.SetCompilerOptionsForInferredProjectsArgs, tsp.SetCompilerOptionsForInferredProjectsResponse];
    'documentHighlights': [tsp.DocumentHighlightsRequestArgs, tsp.DocumentHighlightsResponse];
    'applyCodeActionCommand': [tsp.ApplyCodeActionCommandRequestArgs, tsp.ApplyCodeActionCommandResponse];
    'completionEntryDetails': [tsp.CompletionDetailsRequestArgs, tsp.CompletionDetailsResponse];
    'completionInfo': [tsp.CompletionsRequestArgs, tsp.CompletionInfoResponse];
    'configure': [tsp.ConfigureRequestArguments, tsp.ConfigureResponse];
    'definition': [tsp.FileLocationRequestArgs, tsp.DefinitionResponse];
    'definitionAndBoundSpan': [tsp.FileLocationRequestArgs, tsp.DefinitionInfoAndBoundSpanResponse];
    'docCommentTemplate': [tsp.FileLocationRequestArgs, tsp.DocCommandTemplateResponse];
    'format': [tsp.FormatRequestArgs, tsp.FormatResponse];
    'formatonkey': [tsp.FormatOnKeyRequestArgs, tsp.FormatResponse];
    'getApplicableRefactors': [tsp.GetApplicableRefactorsRequestArgs, tsp.GetApplicableRefactorsResponse];
    'getCodeFixes': [tsp.CodeFixRequestArgs, tsp.CodeFixResponse];
    'getCombinedCodeFix': [tsp.GetCombinedCodeFixRequestArgs, tsp.GetCombinedCodeFixResponse];
    'getEditsForFileRename': [tsp.GetEditsForFileRenameRequestArgs, tsp.GetEditsForFileRenameResponse];
    'getEditsForRefactor': [tsp.GetEditsForRefactorRequestArgs, tsp.GetEditsForRefactorResponse];
    'getOutliningSpans': [tsp.FileRequestArgs, tsp.OutliningSpansResponse];
    'getSupportedCodeFixes': [null, tsp.GetSupportedCodeFixesResponse];
    'implementation': [tsp.FileLocationRequestArgs, tsp.ImplementationResponse];
    'jsxClosingTag': [tsp.JsxClosingTagRequestArgs, tsp.JsxClosingTagResponse];
    'navto': [tsp.NavtoRequestArgs, tsp.NavtoResponse];
    'navtree': [tsp.FileRequestArgs, tsp.NavTreeResponse];
    'organizeImports': [tsp.OrganizeImportsRequestArgs, tsp.OrganizeImportsResponse];
    'projectInfo': [tsp.ProjectInfoRequestArgs, tsp.ProjectInfoResponse];
    'quickinfo': [tsp.FileLocationRequestArgs, tsp.QuickInfoResponse];
    'references': [tsp.FileLocationRequestArgs, tsp.ReferencesResponse];
    'rename': [tsp.RenameRequestArgs, tsp.RenameResponse];
    'signatureHelp': [tsp.SignatureHelpRequestArgs, tsp.SignatureHelpResponse];
    'typeDefinition': [tsp.FileLocationRequestArgs, tsp.TypeDefinitionResponse];
    'provideInlayHints': [tsp.InlayHintsRequestArgs, tsp.InlayHintsResponse];
    'encodedSemanticClassifications-full': [tsp.EncodedSemanticClassificationsRequestArgs, tsp.EncodedSemanticClassificationsResponse];
}
export declare class TspClient {
    private options;
    private tsserverProc;
    private readlineInterface;
    private seq;
    private readonly deferreds;
    private logger;
    private tsserverLogger;
    private cancellationPipeName;
    constructor(options: TspClientOptions);
    start(): boolean;
    shutdown(): void;
    notify(command: CommandTypes.Open, args: tsp.OpenRequestArgs): void;
    notify(command: CommandTypes.Close, args: tsp.FileRequestArgs): void;
    notify(command: CommandTypes.Saveto, args: tsp.SavetoRequestArgs): void;
    notify(command: CommandTypes.Change, args: tsp.ChangeRequestArgs): void;
    request<K extends keyof TypeScriptRequestTypes>(command: K, args: TypeScriptRequestTypes[K][0], token?: CancellationToken): Promise<TypeScriptRequestTypes[K][1]>;
    protected sendMessage(command: string, notification: boolean, args?: any): void;
    protected processMessage(untrimmedMessageString: string): void;
    private resolveResponse;
    private isEvent;
    private isResponse;
    private isRequestCompletedEvent;
}
export {};
//# sourceMappingURL=tsp-client.d.ts.map